/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.common.Log;
import brut.directory.DirectoryException;
import brut.directory.PathAlreadyExists;
import brut.directory.PathNotExist;
import brut.util.BrutIO;
import brut.util.OS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class Directory
implements AutoCloseable {
    private static final String TAG = "";
    public final String separator = "/";
    public final char separatorChar = (char)47;
    protected Set<String> mFiles;
    protected Set<String> mFilesRecursive;
    protected Map<String, Directory> mDirs;

    protected abstract void load();

    protected InputStream getFileInputImpl(String name) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    protected OutputStream getFileOutputImpl(String name) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    protected void removeFileImpl(String name) {
        throw new UnsupportedOperationException();
    }

    protected Directory createDirImpl(String name) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public long getSize(String name) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public long getCompressedSize(String name) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public int getCompressionLevel(String name) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws DirectoryException {
    }

    public Set<String> getFiles() {
        return this.getFiles(false);
    }

    public Set<String> getFiles(boolean recursive) {
        if (this.mFiles == null) {
            this.load();
        }
        if (!recursive) {
            return this.mFiles;
        }
        if (this.mFilesRecursive == null) {
            this.mFilesRecursive = new LinkedHashSet<String>(this.mFiles);
            for (Map.Entry<String, Directory> dir : this.getDirs().entrySet()) {
                for (String path : dir.getValue().getFiles(true)) {
                    this.mFilesRecursive.add(dir.getKey() + "/" + path);
                }
            }
        }
        return this.mFilesRecursive;
    }

    public Map<String, Directory> getDirs() {
        return this.getDirs(false);
    }

    public Map<String, Directory> getDirs(boolean recursive) {
        if (this.mDirs == null) {
            this.load();
        }
        if (!recursive) {
            return this.mDirs;
        }
        LinkedHashMap<String, Directory> dirs = new LinkedHashMap<String, Directory>(this.mDirs);
        for (Map.Entry<String, Directory> dir : this.mDirs.entrySet()) {
            for (Map.Entry<String, Directory> subdir : dir.getValue().getDirs(true).entrySet()) {
                dirs.put(dir.getKey() + "/" + subdir.getKey(), subdir.getValue());
            }
        }
        return dirs;
    }

    public boolean containsFile(String path) {
        SubPath subpath;
        try {
            subpath = this.getSubPath(path);
        }
        catch (PathNotExist ignored) {
            return false;
        }
        if (subpath.dir != null) {
            return subpath.dir.containsFile(subpath.path);
        }
        return this.getFiles().contains(subpath.path);
    }

    public boolean containsDir(String path) {
        SubPath subpath;
        try {
            subpath = this.getSubPath(path);
        }
        catch (PathNotExist ignored) {
            return false;
        }
        if (subpath.dir != null) {
            return subpath.dir.containsDir(subpath.path);
        }
        return this.getDirs().containsKey(subpath.path);
    }

    public InputStream getFileInput(String path) throws DirectoryException {
        SubPath subpath = this.getSubPath(path);
        if (subpath.dir != null) {
            return subpath.dir.getFileInput(subpath.path);
        }
        if (!this.getFiles().contains(subpath.path)) {
            throw new PathNotExist(path);
        }
        return this.getFileInputImpl(subpath.path);
    }

    public OutputStream getFileOutput(String path) throws DirectoryException {
        Directory dir;
        ParsedPath parsed = this.parsePath(path);
        if (parsed.dir == null) {
            this.getFiles().add(parsed.subpath);
            return this.getFileOutputImpl(parsed.subpath);
        }
        try {
            dir = this.createDir(parsed.dir);
        }
        catch (PathAlreadyExists ignored) {
            dir = this.getDirs().get(parsed.dir);
        }
        return dir.getFileOutput(parsed.subpath);
    }

    public boolean removeFile(String path) {
        SubPath subpath;
        try {
            subpath = this.getSubPath(path);
        }
        catch (PathNotExist ignored) {
            return false;
        }
        if (subpath.dir != null) {
            return subpath.dir.removeFile(subpath.path);
        }
        if (!this.getFiles().contains(subpath.path)) {
            return false;
        }
        this.removeFileImpl(subpath.path);
        this.getFiles().remove(subpath.path);
        return true;
    }

    public Directory getDir(String path) throws PathNotExist {
        SubPath subpath = this.getSubPath(path);
        if (subpath.dir != null) {
            return subpath.dir.getDir(subpath.path);
        }
        if (!this.getDirs().containsKey(subpath.path)) {
            throw new PathNotExist(path);
        }
        return this.getDirs().get(subpath.path);
    }

    public Directory createDir(String path) throws DirectoryException {
        Directory dir;
        ParsedPath parsed = this.parsePath(path);
        if (parsed.dir == null) {
            if (this.getDirs().containsKey(parsed.subpath)) {
                throw new PathAlreadyExists(path);
            }
            Directory dir2 = this.createDirImpl(parsed.subpath);
            this.getDirs().put(parsed.subpath, dir2);
            return dir2;
        }
        if (this.getDirs().containsKey(parsed.dir)) {
            dir = this.getDirs().get(parsed.dir);
        } else {
            dir = this.createDirImpl(parsed.dir);
            this.getDirs().put(parsed.dir, dir);
        }
        return dir.createDir(parsed.subpath);
    }

    public void copyToDir(Directory out) throws DirectoryException {
        for (String fileName : this.getFiles(true)) {
            this.copyToDir(out, fileName);
        }
    }

    public void copyToDir(Directory out, String fileName) throws DirectoryException {
        this.copyToDir(fileName, out, fileName);
    }

    public void copyToDir(Directory out, String ... fileNames) throws DirectoryException {
        for (String fileName : fileNames) {
            this.copyToDir(out, fileName);
        }
    }

    public void copyToDir(String inFileName, Directory out, String outFileName) throws DirectoryException {
        try {
            if (this.containsDir(inFileName)) {
                this.getDir(inFileName).copyToDir(out.createDir(outFileName));
            } else {
                BrutIO.copyAndClose(this.getFileInput(inFileName), out.getFileOutput(outFileName));
            }
        }
        catch (IOException ex) {
            throw new DirectoryException("Error copying file: " + inFileName, ex);
        }
    }

    public void copyToDir(File out) throws DirectoryException {
        for (String fileName : this.getFiles(true)) {
            this.copyToDir(out, fileName);
        }
    }

    public void copyToDir(File out, String fileName) throws DirectoryException {
        this.copyToDir(fileName, out, fileName);
    }

    public void copyToDir(File out, String ... fileNames) throws DirectoryException {
        for (String fileName : fileNames) {
            this.copyToDir(out, fileName);
        }
    }

    public void copyToDir(String inFileName, File out, String outFileName) throws DirectoryException {
        block9: {
            try {
                if (this.containsDir(inFileName)) {
                    File outDir = new File(out, outFileName);
                    this.getDir(inFileName).copyToDir(outDir);
                    break block9;
                }
                if (this.containsFile(inFileName)) {
                    if ((outFileName = BrutIO.sanitizePath(out, outFileName)).isEmpty()) {
                        return;
                    }
                    File outFile = new File(out, outFileName);
                    if (outFile.exists()) {
                        OS.rmfile(outFile);
                    } else {
                        File parentDir = outFile.getParentFile();
                        if (parentDir != null) {
                            OS.mkdir(parentDir);
                        }
                    }
                    BrutIO.copyAndClose(this.getFileInput(inFileName), Files.newOutputStream(outFile.toPath(), new OpenOption[0]));
                    break block9;
                }
                return;
            }
            catch (InvalidPathException ex) {
                Log.w(TAG, "Skipping file %s (%s)", inFileName, ex.getMessage());
            }
            catch (IOException ex) {
                throw new DirectoryException("Error copying file: " + inFileName, ex);
            }
        }
    }

    private SubPath getSubPath(String path) throws PathNotExist {
        ParsedPath parsed = this.parsePath(path);
        if (parsed.dir == null) {
            return new SubPath(null, parsed.subpath);
        }
        if (!this.getDirs().containsKey(parsed.dir)) {
            throw new PathNotExist(path);
        }
        return new SubPath(this.getDirs().get(parsed.dir), parsed.subpath);
    }

    private ParsedPath parsePath(String path) {
        int pos = path.indexOf(47);
        if (pos == -1) {
            return new ParsedPath(null, path);
        }
        return new ParsedPath(path.substring(0, pos), path.substring(pos + 1));
    }

    private static class SubPath {
        public final Directory dir;
        public final String path;

        public SubPath(Directory dir, String path) {
            this.dir = dir;
            this.path = path;
        }
    }

    private static class ParsedPath {
        public final String dir;
        public final String subpath;

        public ParsedPath(String dir, String subpath) {
            this.dir = dir;
            this.subpath = subpath;
        }
    }
}

