/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResPackage;
import brut.androlib.res.table.value.ResPrimitive;
import brut.androlib.res.table.value.ResReference;
import brut.androlib.res.table.value.ResValue;
import brut.androlib.res.xml.ValuesXmlSerializable;
import brut.common.Log;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class ResItem
extends ResValue
implements ValuesXmlSerializable {
    private static final String TAG = ResItem.class.getName();
    protected static final Map<String, Set<String>> STANDARD_TYPE_FORMATS = new HashMap<String, Set<String>>();
    protected final int mType;

    protected ResItem(int type) {
        this.mType = type;
    }

    public static ResItem parse(ResPackage pkg, int type, int data) {
        assert (type != 3);
        switch (type) {
            case 0: {
                return data == 1 ? ResPrimitive.EMPTY : ResPrimitive.NULL;
            }
            case 1: 
            case 7: {
                return new ResReference(pkg, ResId.of(data));
            }
            case 2: 
            case 8: {
                return new ResReference(pkg, ResId.of(data), true);
            }
            case 4: 
            case 5: 
            case 6: {
                return new ResPrimitive(type, data);
            }
        }
        if (type >= 16 && type <= 31) {
            return new ResPrimitive(type, data);
        }
        Log.w(TAG, "Invalid value type: 0x%02x", type);
        return null;
    }

    public int getType() {
        return this.mType;
    }

    public String getFormat() {
        switch (this.mType) {
            case 0: {
                return null;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                return "reference";
            }
            case 3: {
                return "string";
            }
            case 4: {
                return "float";
            }
            case 5: {
                return "dimension";
            }
            case 6: {
                return "fraction";
            }
            case 18: {
                return "boolean";
            }
        }
        if (this.mType >= 28 && this.mType <= 31) {
            return "color";
        }
        if (this.mType >= 16 && this.mType <= 31) {
            return "integer";
        }
        Log.w(TAG, "Unexpected value type: 0x%02x", this.mType);
        return null;
    }

    public abstract String toXmlTextValue() throws AndrolibException;

    public String toXmlAttributeValue() throws AndrolibException {
        return this.toXmlTextValue();
    }

    static {
        STANDARD_TYPE_FORMATS.put("bool", Sets.newHashSet("boolean"));
        STANDARD_TYPE_FORMATS.put("color", Sets.newHashSet("color"));
        STANDARD_TYPE_FORMATS.put("dimen", Sets.newHashSet("float", "fraction", "dimension"));
        STANDARD_TYPE_FORMATS.put("drawable", Sets.newHashSet("color"));
        STANDARD_TYPE_FORMATS.put("fraction", Sets.newHashSet("float", "fraction", "dimension"));
        STANDARD_TYPE_FORMATS.put("integer", Sets.newHashSet("integer"));
        STANDARD_TYPE_FORMATS.put("string", Sets.newHashSet("string"));
    }
}

