/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res;

import brut.androlib.exceptions.AndrolibException;
import brut.common.BrutException;
import brut.util.Jar;
import brut.util.OS;
import brut.util.OSDetection;
import java.io.File;

public final class AaptManager {
    private AaptManager() {
    }

    public static String getBinaryName() {
        return "aapt2";
    }

    public static File getBinaryFile() throws AndrolibException {
        File binFile;
        String binName = AaptManager.getBinaryName();
        if (!OSDetection.is64Bit()) {
            throw new AndrolibException(binName + " binaries are not available for 32-bit platforms.");
        }
        StringBuilder binPath = new StringBuilder("/prebuilt/");
        if (OSDetection.isUnix()) {
            binPath.append("linux");
        } else if (OSDetection.isMacOSX()) {
            binPath.append("macosx");
        } else if (OSDetection.isWindows()) {
            binPath.append("windows");
        } else {
            throw new AndrolibException("Could not identify platform: " + OSDetection.returnOS());
        }
        binPath.append('/');
        binPath.append(binName);
        if (OSDetection.isWindows()) {
            binPath.append(".exe");
        }
        try {
            binFile = Jar.getResourceAsFile(AaptManager.class, binPath.toString(), binName + "_");
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
        AaptManager.setBinaryExecutable(binFile);
        return binFile;
    }

    private static void setBinaryExecutable(File binFile) throws AndrolibException {
        if (!binFile.isFile() || !binFile.canRead()) {
            throw new AndrolibException("Could not read aapt binary: " + binFile.getPath());
        }
        if (!binFile.setExecutable(true)) {
            throw new AndrolibException("Could not set aapt binary as executable: " + binFile.getPath());
        }
    }

    public static int getBinaryVersion(File binFile) throws AndrolibException {
        AaptManager.setBinaryExecutable(binFile);
        String versionStr = OS.execAndReturn(new String[]{binFile.getPath(), "version"});
        if (versionStr == null) {
            throw new AndrolibException("Could not execute aapt binary at location: " + binFile.getPath());
        }
        return AaptManager.getVersionFromString(versionStr);
    }

    public static int getVersionFromString(String versionStr) throws AndrolibException {
        if (versionStr.startsWith("Android Asset Packaging Tool (aapt) 2:")) {
            return 2;
        }
        if (versionStr.startsWith("Android Asset Packaging Tool (aapt) 2.")) {
            return 2;
        }
        if (versionStr.startsWith("Android Asset Packaging Tool, v0.")) {
            return 1;
        }
        throw new AndrolibException("Could not identify aapt binary version: " + versionStr);
    }
}

