/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.value.ResItem;
import brut.androlib.res.xml.ResStringEncoder;
import java.io.IOException;
import java.util.Set;
import org.xmlpull.v1.XmlSerializer;

public class ResString
extends ResItem {
    public static final ResString EMPTY = new ResString("");
    private final CharSequence mValue;

    public ResString(CharSequence value) {
        super(3);
        assert (value != null);
        this.mValue = value;
    }

    public CharSequence getValue() {
        return this.mValue;
    }

    @Override
    public String toXmlTextValue() {
        return ResStringEncoder.encodeTextValue(this.mValue);
    }

    @Override
    public String toXmlAttributeValue() {
        return ResStringEncoder.encodeAttributeValue(this.mValue);
    }

    @Override
    public void serializeToValuesXml(XmlSerializer serial, ResEntry entry) throws AndrolibException, IOException {
        String body;
        String typeName = entry.getType().getName();
        Set stdFormats = (Set)STANDARD_TYPE_FORMATS.get(typeName);
        String format = stdFormats != null ? this.getFormat() : null;
        boolean asItem = format != null && !stdFormats.contains(format);
        String tagName = asItem ? "item" : typeName;
        serial.startTag(null, tagName);
        if (asItem) {
            serial.attribute(null, "type", typeName);
        }
        serial.attribute(null, "name", entry.getName());
        if (asItem) {
            serial.attribute(null, "format", format);
        }
        if (!asItem && !this.isFormatted()) {
            serial.attribute(null, "formatted", "false");
        }
        if (!(body = this.toXmlTextValue()).isEmpty()) {
            serial.text(body);
        }
        serial.endTag(null, tagName);
    }

    private boolean isFormatted() {
        if (this.mValue.length() == 0) {
            return true;
        }
        int[][] specs = ResStringEncoder.findFormatSpecifiers(this.mValue.toString());
        int[] sequential = specs[0];
        int[] positional = specs[1];
        return sequential.length == 0 || sequential.length + positional.length <= 1;
    }

    public String toString() {
        return String.format("ResString{value=%s}", this.mValue);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResString) {
            ResString other = (ResString)obj;
            return this.mValue.equals(other.mValue);
        }
        return false;
    }

    public int hashCode() {
        return this.mValue.hashCode();
    }
}

