/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.util.OS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public class FileDirectory
extends Directory {
    private final File mDir;

    public FileDirectory(String dirName) throws DirectoryException {
        this(new File(dirName));
    }

    public FileDirectory(File dir) throws DirectoryException {
        if (!dir.isDirectory()) {
            throw new DirectoryException("file must be a directory: " + dir);
        }
        this.mDir = dir;
    }

    @Override
    protected void load() {
        this.mFiles = new LinkedHashSet();
        this.mDirs = new LinkedHashMap();
        File[] files = this.mDir.listFiles();
        Arrays.sort(files, Comparator.comparing(File::getName));
        for (File file : files) {
            if (file.isFile()) {
                this.mFiles.add(file.getName());
                continue;
            }
            try {
                this.mDirs.put(file.getName(), new FileDirectory(file));
            }
            catch (DirectoryException directoryException) {
                // empty catch block
            }
        }
    }

    private String generatePath(String name) {
        return this.mDir.getPath() + "/" + name;
    }

    @Override
    protected InputStream getFileInputImpl(String name) throws DirectoryException {
        try {
            File file = new File(this.generatePath(name));
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new DirectoryException(ex);
        }
    }

    @Override
    protected OutputStream getFileOutputImpl(String name) throws DirectoryException {
        try {
            File file = new File(this.generatePath(name));
            return Files.newOutputStream(file.toPath(), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new DirectoryException(ex);
        }
    }

    @Override
    protected void removeFileImpl(String name) {
        File file = new File(this.generatePath(name));
        OS.rmfile(file);
    }

    @Override
    protected Directory createDirImpl(String name) throws DirectoryException {
        File dir = new File(this.generatePath(name));
        OS.mkdir(dir);
        return new FileDirectory(dir);
    }

    @Override
    public long getSize(String name) throws DirectoryException {
        File file = new File(this.generatePath(name));
        if (!file.isFile()) {
            throw new DirectoryException("file must be a file: " + file);
        }
        return file.length();
    }

    @Override
    public long getCompressedSize(String name) throws DirectoryException {
        return this.getSize(name);
    }

    @Override
    public int getCompressionLevel(String name) {
        return 0;
    }
}

