/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.smali;

import brut.androlib.exceptions.AndrolibException;
import brut.common.Log;
import brut.directory.DirectoryException;
import brut.directory.FileDirectory;
import brut.util.OS;
import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.writer.builder.DexBuilder;
import com.android.tools.smali.dexlib2.writer.io.FileDataStore;
import com.android.tools.smali.smali.smaliFlexLexer;
import com.android.tools.smali.smali.smaliParser;
import com.android.tools.smali.smali.smaliTreeWalker;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;

public class SmaliBuilder {
    private static final String TAG = SmaliBuilder.class.getName();
    private static final boolean VERBOSE_ERRORS = false;
    private static final boolean PRINT_TOKENS = false;
    private final int mApiLevel;

    public SmaliBuilder(int apiLevel) {
        this.mApiLevel = Math.min(apiLevel, 29);
    }

    public void build(File smaliDir, File dexFile) throws AndrolibException {
        try {
            DexBuilder dexBuilder = new DexBuilder(this.mApiLevel > 0 ? Opcodes.forApi(this.mApiLevel) : Opcodes.getDefault());
            for (String fileName : new FileDirectory(smaliDir).getFiles(true)) {
                Exception cause;
                boolean success;
                File smaliFile = new File(smaliDir, fileName);
                if (!fileName.endsWith(".smali")) {
                    Log.w(TAG, "Unknown file type, ignoring: " + smaliFile);
                    continue;
                }
                try {
                    success = this.buildFile(smaliFile, dexBuilder);
                    cause = null;
                }
                catch (Exception ex) {
                    success = false;
                    cause = ex;
                }
                if (success) continue;
                AndrolibException ex = new AndrolibException("Could not smali file: " + smaliFile);
                if (cause != null) {
                    ex.initCause(cause);
                }
                throw ex;
            }
            if (dexFile.exists()) {
                OS.rmfile(dexFile);
            } else {
                File parentDir = dexFile.getParentFile();
                if (parentDir != null) {
                    OS.mkdir(parentDir);
                }
            }
            dexBuilder.writeTo(new FileDataStore(dexFile));
        }
        catch (DirectoryException | IOException | RuntimeException ex) {
            throw new AndrolibException("Could not smali folder: " + smaliDir.getName(), ex);
        }
    }

    private boolean buildFile(File smaliFile, DexBuilder dexBuilder) throws IOException, RecognitionException {
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(smaliFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            smaliFlexLexer lexer = new smaliFlexLexer(reader, this.mApiLevel);
            lexer.setSourceFile(smaliFile);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            smaliParser parser = new smaliParser(tokens);
            parser.setApiLevel(this.mApiLevel);
            parser.setVerboseErrors(false);
            smaliParser.smali_file_return result = parser.smali_file();
            if (parser.getNumberOfSyntaxErrors() > 0 || lexer.getNumberOfSyntaxErrors() > 0) {
                boolean bl = false;
                return bl;
            }
            CommonTree tree = result.getTree();
            CommonTreeNodeStream treeStream = new CommonTreeNodeStream(tree);
            treeStream.setTokenStream(tokens);
            smaliTreeWalker treeWalker = new smaliTreeWalker(treeStream);
            treeWalker.setApiLevel(this.mApiLevel);
            treeWalker.setVerboseErrors(false);
            treeWalker.setDexBuilder(dexBuilder);
            treeWalker.smali_file();
            boolean bl = treeWalker.getNumberOfSyntaxErrors() == 0;
            return bl;
        }
    }
}

