/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table;

import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.table.ResEntrySpec;
import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResPackage;
import brut.common.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.xmlpull.v1.XmlSerializer;

public class ResOverlayable {
    private static final String TAG = ResOverlayable.class.getName();
    private static final int FLAG_NONE = 0;
    private static final int FLAG_PUBLIC = 1;
    private static final int FLAG_SYSTEM_PARTITION = 2;
    private static final int FLAG_VENDOR_PARTITION = 4;
    private static final int FLAG_PRODUCT_PARTITION = 8;
    private static final int FLAG_SIGNATURE = 16;
    private static final int FLAG_ODM_PARTITION = 32;
    private static final int FLAG_OEM_PARTITION = 64;
    private static final int FLAG_ACTOR_SIGNATURE = 128;
    private static final int FLAG_CONFIG_SIGNATURE = 256;
    private static final int[] FLAG_MASKS = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256};
    private static final String[] FLAG_NAMES = new String[]{"public", "system", "vendor", "product", "signature", "odm", "oem", "actor", "config_signature"};
    private final ResPackage mPackage;
    private final String mName;
    private final String mActor;
    private final List<Policy> mPolicies;

    public ResOverlayable(ResPackage pkg, String name, String actor) {
        assert (pkg != null && name != null && actor != null);
        this.mPackage = pkg;
        this.mName = name;
        this.mActor = actor;
        this.mPolicies = new ArrayList<Policy>();
    }

    public ResPackage getPackage() {
        return this.mPackage;
    }

    public String getName() {
        return this.mName;
    }

    public String getActor() {
        return this.mActor;
    }

    public void addPolicy(int flags, ResId[] entries) {
        this.mPolicies.add(new Policy(flags, entries));
    }

    public void serializeToXml(XmlSerializer serial) throws IOException {
        if (this.mPolicies.isEmpty()) {
            return;
        }
        serial.startTag(null, "overlayable");
        serial.attribute(null, "name", this.mName);
        if (!this.mActor.isEmpty()) {
            serial.attribute(null, "actor", this.mActor);
        }
        for (Policy policy : this.mPolicies) {
            String type = this.renderType(policy.getFlags());
            ResEntrySpec[] entrySpecs = this.resolveEntries(policy.getEntries());
            if (type == null || entrySpecs == null) continue;
            serial.startTag(null, "policy");
            serial.attribute(null, "type", type);
            for (ResEntrySpec entrySpec : entrySpecs) {
                serial.startTag(null, "item");
                serial.attribute(null, "type", entrySpec.getTypeSpec().getName());
                serial.attribute(null, "name", entrySpec.getName());
                serial.endTag(null, "item");
            }
            serial.endTag(null, "policy");
        }
        serial.endTag(null, "overlayable");
    }

    private String renderType(int flags) {
        if (flags == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < FLAG_MASKS.length; ++i) {
            if ((flags & FLAG_MASKS[i]) == 0) continue;
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(FLAG_NAMES[i]);
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    private ResEntrySpec[] resolveEntries(ResId[] entries) {
        if (entries == null || entries.length == 0) {
            return null;
        }
        ResEntrySpec[] entrySpecs = new ResEntrySpec[entries.length];
        int entrySpecsCount = 0;
        for (int i = 0; i < entries.length; ++i) {
            ResEntrySpec entrySpec;
            ResId resId = entries[i];
            if (resId == ResId.NULL) continue;
            try {
                entrySpec = this.mPackage.getEntrySpec(resId.typeId(), resId.entryId());
            }
            catch (UndefinedResObjectException ignored) {
                Log.w(TAG, "Unresolved overlayable entry ID: " + resId);
                continue;
            }
            entrySpecs[entrySpecsCount++] = entrySpec;
        }
        if (entrySpecsCount < entrySpecs.length) {
            entrySpecs = Arrays.copyOf(entrySpecs, entrySpecsCount);
        }
        return entrySpecs;
    }

    public String toString() {
        return String.format("ResOverlayable{pkg=%s, name=%s, actor=%s}", this.mPackage, this.mName, this.mActor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResOverlayable) {
            ResOverlayable other = (ResOverlayable)obj;
            return this.mPackage.equals(other.mPackage) && this.mName.equals(other.mName) && this.mActor.equals(other.mActor);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mPackage, this.mName, this.mActor);
    }

    private static class Policy {
        private final int mFlags;
        private final ResId[] mEntries;

        public Policy(int flags, ResId[] entries) {
            this.mFlags = flags;
            this.mEntries = entries;
        }

        public int getFlags() {
            return this.mFlags;
        }

        public ResId[] getEntries() {
            return this.mEntries;
        }
    }
}

