/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.CRC32;
import org.apache.commons.io.IOUtils;

public final class BrutIO {
    private BrutIO() {
    }

    public static byte[] readAndClose(InputStream in) throws IOException {
        try {
            byte[] byArray = IOUtils.toByteArray(in);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static void copyAndClose(InputStream in, OutputStream out) throws IOException {
        try {
            IOUtils.copy(in, out);
        }
        finally {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
        }
    }

    public static long recursiveModifiedTime(File[] files) {
        long modified = 0L;
        for (File file : files) {
            long submodified = BrutIO.recursiveModifiedTime(file);
            if (submodified <= modified) continue;
            modified = submodified;
        }
        return modified;
    }

    public static long recursiveModifiedTime(File file) {
        long modified = file.lastModified();
        if (file.isDirectory()) {
            File[] subfiles;
            for (File subfile : subfiles = file.listFiles()) {
                long submodified = BrutIO.recursiveModifiedTime(subfile);
                if (submodified <= modified) continue;
                modified = submodified;
            }
        }
        return modified;
    }

    public static CRC32 calculateCrc(InputStream in) throws IOException {
        int bytesRead;
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[8192];
        while ((bytesRead = in.read(buffer)) != -1) {
            crc.update(buffer, 0, bytesRead);
        }
        return crc;
    }

    public static String sanitizePath(File baseDir, String path) throws InvalidPathException, IOException {
        if (path == null || path.isEmpty()) {
            throw new InvalidPathException(path, "Path is null or empty.");
        }
        Path origPath = Paths.get(path, new String[0]);
        if (origPath.isAbsolute()) {
            throw new InvalidPathException(path, "Absolute paths are not allowed.");
        }
        Path basePath = Paths.get(baseDir.getCanonicalPath(), new String[0]);
        Path resolvedPath = basePath.resolve(origPath).normalize();
        if (!resolvedPath.startsWith(basePath)) {
            throw new InvalidPathException(path, "Path traverses outside the base directory");
        }
        return basePath.relativize(resolvedPath).toString();
    }
}

