/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.data.ResStringPool;
import brut.androlib.res.decoder.ResChunkPullParser;
import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResPackage;
import brut.androlib.res.table.ResTable;
import brut.androlib.res.table.value.ResAttribute;
import brut.androlib.res.table.value.ResItem;
import brut.androlib.res.table.value.ResString;
import brut.common.Log;
import brut.util.BinaryDataInputStream;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class BinaryXmlResourceParser
implements XmlPullParser {
    private static final String TAG = BinaryXmlResourceParser.class.getName();
    private static final String NOT_SUPPORTED = "Method is not supported.";
    private final ResTable mTable;
    private final boolean mIgnoreRawValues;
    private final boolean mSkipUnresolved;
    private final NamespaceStack mNamespaces;
    private BinaryDataInputStream mIn;
    private ResChunkPullParser mParser;
    private ResStringPool mStringPool;
    private ResId[] mResourceMap;
    private boolean mHasRawValues;
    private AndrolibException mFirstError;
    private int mEventType;
    private int mLineNumber;
    private int mNamespaceIndex;
    private int mNameIndex;
    private int mIdIndex;
    private int mClassIndex;
    private int mStyleIndex;
    private Attribute[] mAttributes;

    public BinaryXmlResourceParser(ResTable table, boolean ignoreRawValues, boolean skipUnresolved) {
        this.mTable = table;
        this.mIgnoreRawValues = ignoreRawValues;
        this.mSkipUnresolved = skipUnresolved;
        this.mNamespaces = new NamespaceStack();
        this.resetEventInfo();
    }

    public boolean hasRawValues() {
        return this.mHasRawValues;
    }

    public AndrolibException getFirstError() {
        return this.mFirstError;
    }

    @Override
    public void setFeature(String name, boolean state) throws XmlPullParserException {
        throw new XmlPullParserException(NOT_SUPPORTED);
    }

    @Override
    public boolean getFeature(String name) {
        return false;
    }

    @Override
    public void setProperty(String name, Object value) throws XmlPullParserException {
        throw new XmlPullParserException(NOT_SUPPORTED);
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setInput(Reader in) throws XmlPullParserException {
        throw new XmlPullParserException(NOT_SUPPORTED);
    }

    @Override
    public void setInput(InputStream inputStream, String inputEncoding) throws XmlPullParserException {
        if (inputEncoding != null) {
            throw new XmlPullParserException(NOT_SUPPORTED);
        }
        this.reset();
        this.mIn = new BinaryDataInputStream(inputStream);
        this.mParser = new ResChunkPullParser(this.mIn);
        try {
            if (!this.nextChunk()) {
                throw new IOException("Input file is empty.");
            }
            if (this.mParser.chunkType() != 3) {
                throw new IOException("Unexpected chunk: " + this.mParser.chunkName() + " (expected: RES_XML_TYPE)");
            }
        }
        catch (IOException ex) {
            this.mIn = null;
            this.mParser = null;
            throw new XmlPullParserException("Could not initialize parser.", this, ex);
        }
        this.mParser = new ResChunkPullParser(this.mIn, this.mParser.dataSize());
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public void defineEntityReplacementText(String entityName, String replacementText) throws XmlPullParserException {
        throw new XmlPullParserException(NOT_SUPPORTED);
    }

    @Override
    public int getNamespaceCount(int depth) {
        return this.mNamespaces.getCount(depth);
    }

    @Override
    public String getNamespacePrefix(int pos) {
        if (this.mStringPool == null) {
            return null;
        }
        int prefixIdx = this.mNamespaces.getPrefix(pos);
        return this.mStringPool.getString(prefixIdx);
    }

    @Override
    public String getNamespaceUri(int pos) {
        if (this.mStringPool == null) {
            return null;
        }
        int uriIdx = this.mNamespaces.getUri(pos);
        return this.mStringPool.getString(uriIdx);
    }

    @Override
    public String getNamespace(String prefix) {
        throw new RuntimeException(NOT_SUPPORTED);
    }

    @Override
    public int getDepth() {
        return this.mNamespaces.getDepth();
    }

    @Override
    public String getPositionDescription() {
        return "XML line #" + this.getLineNumber();
    }

    @Override
    public int getLineNumber() {
        return this.mLineNumber;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public boolean isWhitespace() throws XmlPullParserException {
        if (this.mEventType != 4) {
            throw new XmlPullParserException("Parser must be on TEXT to get text.", this, null);
        }
        String text = this.getText();
        if (text == null) {
            return true;
        }
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getText() {
        if (this.mStringPool == null || this.mEventType != 4) {
            return null;
        }
        return this.mStringPool.getString(this.mNameIndex);
    }

    @Override
    public char[] getTextCharacters(int[] holderForStartAndLength) {
        String text = this.getText();
        if (text == null) {
            return null;
        }
        int len = text.length();
        holderForStartAndLength[0] = 0;
        holderForStartAndLength[1] = len;
        char[] chars = new char[len];
        text.getChars(0, len, chars, 0);
        return chars;
    }

    @Override
    public String getNamespace() {
        if (this.mStringPool == null || this.mEventType != 2 && this.mEventType != 3) {
            return null;
        }
        return this.mStringPool.getString(this.mNamespaceIndex);
    }

    @Override
    public String getName() {
        if (this.mStringPool == null || this.mEventType != 2 && this.mEventType != 3) {
            return null;
        }
        return this.mStringPool.getString(this.mNameIndex);
    }

    @Override
    public String getPrefix() {
        if (this.mStringPool == null || this.mEventType != 2 && this.mEventType != 3) {
            return null;
        }
        int prefixIdx = this.mNamespaces.findPrefix(this.mNamespaceIndex);
        return this.mStringPool.getString(prefixIdx);
    }

    @Override
    public boolean isEmptyElementTag() {
        return false;
    }

    @Override
    public int getAttributeCount() {
        if (this.mEventType != 2) {
            return -1;
        }
        return this.mAttributes != null ? this.mAttributes.length : 0;
    }

    @Override
    public String getAttributeNamespace(int index) {
        String uri;
        Attribute attr = this.getAttribute(index);
        if (attr == null) {
            return "";
        }
        ResId nameId = this.getAttributeNameResourceId(index);
        if (attr.ns < 0) {
            if (nameId.pkgId() == 127) {
                return this.getNonDefaultNamespaceUri(index);
            }
            if (nameId.pkgId() == 1) {
                return "http://schemas.android.com/apk/res/android";
            }
            return "";
        }
        String string = uri = this.mStringPool != null ? this.mStringPool.getString(attr.ns) : null;
        if (uri != null && !uri.isEmpty()) {
            return uri;
        }
        if (nameId.pkgId() == 127) {
            return this.getNonDefaultNamespaceUri(index);
        }
        return "http://schemas.android.com/apk/res/android";
    }

    @Override
    public String getAttributeName(int index) {
        String name;
        Attribute attr = this.getAttribute(index);
        if (attr == null || attr.name < 0) {
            return "";
        }
        ResId nameId = this.getAttributeNameResourceId(index);
        if (nameId != ResId.NULL) {
            try {
                return this.mTable.resolve(nameId).getName();
            }
            catch (AndrolibException androlibException) {
                // empty catch block
            }
        }
        String string = name = this.mStringPool != null ? this.mStringPool.getString(attr.name) : null;
        if (name == null) {
            name = "";
        }
        if (nameId != ResId.NULL) {
            try {
                ResPackage pkg = this.mTable.getMainPackage();
                if (pkg == null) {
                    pkg = this.mTable.resolvePackageGroup(1).getBasePackage();
                }
                if (this.mSkipUnresolved || nameId.pkgId() != pkg.getId()) {
                    Log.w(TAG, "Unresolved attr reference: ns=%s, name=%s, id=%s", this.getAttributePrefix(index), name, nameId);
                    return name;
                }
                if (name.isEmpty()) {
                    name = "APKTOOL_DUMMY_" + nameId;
                }
                name = pkg.addEntrySpec(nameId.typeId(), nameId.entryId(), name).getName();
                pkg.addEntry(nameId.typeId(), nameId.entryId(), ResAttribute.DEFAULT);
            }
            catch (AndrolibException ex) {
                if (this.mFirstError == null) {
                    this.mFirstError = ex;
                }
                Log.w(TAG, "Could not add missing attr: ns=%s, name=%s, id=%s", this.getAttributePrefix(index), name, nameId);
            }
        }
        return name;
    }

    @Override
    public String getAttributePrefix(int index) {
        if (this.mStringPool == null) {
            return "";
        }
        Attribute attr = this.getAttribute(index);
        if (attr == null || attr.ns < 0) {
            return "";
        }
        int prefixIdx = this.mNamespaces.findPrefix(attr.ns);
        String prefix = this.mStringPool.getString(prefixIdx);
        if (prefix == null) {
            return "";
        }
        return prefix;
    }

    @Override
    public String getAttributeType(int index) {
        return "CDATA";
    }

    @Override
    public boolean isAttributeDefault(int index) {
        return false;
    }

    @Override
    public String getAttributeValue(int index) {
        String decoded;
        String name;
        ResItem value;
        Attribute attr;
        block22: {
            attr = this.getAttribute(index);
            if (attr == null) {
                return "";
            }
            if (this.mHasRawValues && !this.mIgnoreRawValues) {
                String rawValue;
                String string = rawValue = this.mStringPool != null ? this.mStringPool.getString(attr.rawValue) : null;
                if (rawValue != null) {
                    return rawValue;
                }
            }
            value = null;
            name = null;
            decoded = null;
            try {
                ResPackage pkg = this.mTable.getMainPackage();
                if (pkg == null) {
                    pkg = this.mTable.resolvePackageGroup(1).getBasePackage();
                }
                if (attr.valueType == 3) {
                    CharSequence strValue = this.mStringPool != null ? this.mStringPool.getText(attr.valueData) : null;
                    value = strValue != null ? new ResString(strValue) : null;
                } else {
                    value = ResItem.parse(pkg, attr.valueType, attr.valueData);
                }
                if (value == null) break block22;
                ResId nameId = this.getAttributeNameResourceId(index);
                if (nameId != ResId.NULL) {
                    try {
                        ResEntry nameEntry = this.mTable.resolveEntry(nameId);
                        name = nameEntry.getName();
                        if (nameEntry.getValue() instanceof ResAttribute) {
                            boolean isExplicitType;
                            ResAttribute nameValue = (ResAttribute)nameEntry.getValue();
                            switch (attr.valueType) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 7: 
                                case 8: {
                                    isExplicitType = false;
                                    break;
                                }
                                default: {
                                    isExplicitType = true;
                                }
                            }
                            if (isExplicitType && !nameValue.hasSymbolsForValue(value)) {
                                nameValue.addValueType(attr.valueType);
                            }
                            decoded = nameValue.formatAsAttributeValue(value);
                            break block22;
                        }
                        Log.w(TAG, "Unexpected attribute name: " + nameEntry);
                    }
                    catch (UndefinedResObjectException undefinedResObjectException) {}
                    break block22;
                }
                decoded = ResAttribute.DEFAULT.formatAsAttributeValue(value);
            }
            catch (AndrolibException ex) {
                if (this.mFirstError != null) break block22;
                this.mFirstError = ex;
            }
        }
        if (decoded == null) {
            if (name == null) {
                name = this.mStringPool != null ? this.mStringPool.getString(attr.name) : null;
            }
            Log.w(TAG, "Could not decode attribute value: ns=%s, name=%s, type=0x%02x, value=0x%08x", this.getAttributePrefix(index), name, attr.valueType, attr.valueData);
            if (value != null) {
                try {
                    decoded = ResAttribute.DEFAULT.formatAsAttributeValue(value);
                }
                catch (AndrolibException androlibException) {
                    // empty catch block
                }
            }
            if (decoded == null) {
                decoded = "";
            }
        }
        return decoded;
    }

    @Override
    public String getAttributeValue(String namespace, String name) {
        if (this.mEventType != 2) {
            throw new IndexOutOfBoundsException("Parser must be on START_TAG to get attributes.");
        }
        if (this.mAttributes == null || this.mStringPool == null || name == null) {
            return "";
        }
        int uriIdx = this.mStringPool.findString(namespace);
        int nameIdx = this.mStringPool.findString(name);
        for (int i = 0; i < this.mAttributes.length; ++i) {
            Attribute attr = this.mAttributes[i];
            if (attr == null || uriIdx != attr.ns || nameIdx != attr.name) continue;
            return this.getAttributeValue(i);
        }
        return "";
    }

    @Override
    public int getEventType() {
        return this.mEventType;
    }

    @Override
    public int next() throws XmlPullParserException, IOException {
        if (this.mIn == null) {
            throw new XmlPullParserException("Parser is not opened.", this, null);
        }
        try {
            return this.doNext();
        }
        catch (IOException ex) {
            this.reset();
            throw ex;
        }
    }

    @Override
    public int nextToken() throws XmlPullParserException, IOException {
        return this.next();
    }

    @Override
    public void require(int type, String namespace, String name) throws XmlPullParserException {
        if (type != this.mEventType || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getName())) {
            throw new XmlPullParserException(TYPES[type] + " is expected.", this, null);
        }
    }

    @Override
    public String nextText() throws XmlPullParserException, IOException {
        if (this.mEventType != 2) {
            throw new XmlPullParserException("Parser must be on START_TAG to read next text.", this, null);
        }
        int eventType = this.next();
        if (eventType == 3) {
            return "";
        }
        if (eventType != 4) {
            throw new XmlPullParserException("Parser must be on TEXT or END_TAG to read text.", this, null);
        }
        String result = this.getText();
        eventType = this.next();
        if (eventType != 3) {
            throw new XmlPullParserException("Event TEXT must be immediately followed by END_TAG.", this, null);
        }
        return result;
    }

    @Override
    public int nextTag() throws XmlPullParserException, IOException {
        int eventType = this.next();
        if (eventType == 4 && this.isWhitespace()) {
            eventType = this.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("Expected start or end tag.", this, null);
        }
        return eventType;
    }

    private String getNonDefaultNamespaceUri(int pos) {
        String prefix = this.getNamespacePrefix(pos);
        if (prefix == null) {
            return "http://schemas.android.com/apk/res-auto";
        }
        return this.getNamespaceUri(pos);
    }

    private Attribute getAttribute(int index) {
        if (this.mEventType != 2) {
            throw new IndexOutOfBoundsException("Parser must be on START_TAG to get attributes.");
        }
        if (this.mAttributes == null || index < 0 || index >= this.mAttributes.length) {
            throw new IndexOutOfBoundsException(String.format("Attribute index out of range: index=%s, length=%s", index, this.mAttributes != null ? this.mAttributes.length : 0));
        }
        return this.mAttributes[index];
    }

    private ResId getAttributeNameResourceId(int index) {
        if (this.mResourceMap == null) {
            return ResId.NULL;
        }
        Attribute attr = this.getAttribute(index);
        if (attr == null || attr.name < 0 || attr.name >= this.mResourceMap.length) {
            return ResId.NULL;
        }
        return this.mResourceMap[attr.name];
    }

    private void reset() {
        this.mIn = null;
        this.mParser = null;
        this.mStringPool = null;
        this.mResourceMap = null;
        this.resetEventInfo();
        this.mNamespaces.reset();
    }

    private void resetEventInfo() {
        this.mEventType = 0;
        this.mLineNumber = -1;
        this.mNamespaceIndex = -1;
        this.mNameIndex = -1;
        this.mIdIndex = -1;
        this.mClassIndex = -1;
        this.mStyleIndex = -1;
        this.mAttributes = null;
    }

    private boolean nextChunk() throws IOException {
        int lastEventType;
        int skipped;
        if (this.mParser.isChunk() && (skipped = this.mParser.skipChunk()) > 0) {
            Log.d(TAG, "Skipped unknown %s bytes at end of %s chunk.", skipped, this.mParser.chunkName());
        }
        if ((lastEventType = this.mEventType) != -1) {
            this.resetEventInfo();
        }
        if (lastEventType == 3 && this.mNamespaces.getDepth() == 0 && this.mNamespaces.getCurrentCount() == 0) {
            return false;
        }
        while (this.mParser.next()) {
            if (this.mParser.chunkType() == 0) {
                Log.d(TAG, "Skipping unknown chunk (%s) of %s bytes at 0x%08x.", this.mParser.chunkName(), this.mParser.chunkSize(), this.mParser.chunkStart());
                this.mParser.skipChunk();
                continue;
            }
            Log.d(TAG, "Chunk at 0x%08x: %s (%s bytes)", this.mParser.chunkStart(), this.mParser.chunkName(), this.mParser.chunkSize());
            return true;
        }
        return false;
    }

    private int doNext() throws IOException {
        if (this.mEventType == 1) {
            return 1;
        }
        if (this.mEventType == 3) {
            this.mNamespaces.decrementDepth();
        }
        block11: while (this.nextChunk()) {
            switch (this.mParser.chunkType()) {
                case 1: {
                    this.mStringPool = ResStringPool.parse(this.mParser);
                    continue block11;
                }
                case 384: {
                    this.skipUnreadHeader();
                    this.mResourceMap = new ResId[this.mParser.dataSize() / 4];
                    for (int i = 0; i < this.mResourceMap.length; ++i) {
                        this.mResourceMap[i] = ResId.of(this.mIn.readInt());
                    }
                    continue block11;
                }
            }
            if (this.mParser.chunkType() < 256 || this.mParser.chunkType() > 383) {
                this.skipUnexpectedChunk();
                continue;
            }
            this.mLineNumber = this.mIn.readInt();
            this.mIn.skipInt();
            switch (this.mParser.chunkType()) {
                case 256: {
                    int prefix = this.mIn.readInt();
                    int uri = this.mIn.readInt();
                    this.skipUnreadHeader();
                    this.mNamespaces.push(prefix, uri);
                    continue block11;
                }
                case 257: {
                    this.mIn.skipInt();
                    this.mIn.skipInt();
                    this.skipUnreadHeader();
                    this.mNamespaces.pop();
                    continue block11;
                }
                case 258: {
                    long startPosition = this.mIn.position();
                    this.mNamespaceIndex = this.mIn.readInt();
                    this.mNameIndex = this.mIn.readInt();
                    int attributeStart = this.mIn.readUnsignedShort();
                    int attributeSize = this.mIn.readUnsignedShort();
                    int attributeCount = this.mIn.readUnsignedShort();
                    this.mIdIndex = this.mIn.readUnsignedShort();
                    this.mClassIndex = this.mIn.readUnsignedShort();
                    this.mStyleIndex = this.mIn.readUnsignedShort();
                    this.skipUnreadHeader();
                    this.mIn.jumpTo(startPosition + (long)attributeStart);
                    this.mAttributes = new Attribute[attributeCount];
                    for (int i = 0; i < attributeCount; ++i) {
                        Attribute attr = Attribute.read(this.mIn);
                        if (attributeSize > 20) {
                            int skipped = this.mIn.skipBytes(attributeSize - 20);
                            Log.d(TAG, "Skipped unknown %s bytes in attribute.", skipped);
                        }
                        if (attr.valueType == 3 ? attr.valueData != attr.rawValue : attr.rawValue >= 0) {
                            this.mHasRawValues = true;
                        }
                        this.mAttributes[i] = attr;
                    }
                    this.mNamespaces.incrementDepth();
                    this.mEventType = 2;
                    return 2;
                }
                case 259: {
                    this.mNamespaceIndex = this.mIn.readInt();
                    this.mNameIndex = this.mIn.readInt();
                    this.skipUnreadHeader();
                    this.mEventType = 3;
                    return 3;
                }
                case 260: {
                    this.mNameIndex = this.mIn.readInt();
                    this.mIn.skipInt();
                    this.mIn.skipInt();
                    this.skipUnreadHeader();
                    this.mEventType = 4;
                    return 4;
                }
            }
            this.skipUnexpectedChunk();
        }
        Log.d(TAG, "End of chunks at 0x%08x", this.mIn.position());
        if (this.mIn.available() > 0) {
            Log.d(TAG, "Ignoring trailing data at 0x%08x.", this.mIn.position());
        }
        this.mEventType = 1;
        return 1;
    }

    private void skipUnexpectedChunk() throws IOException {
        Log.w(TAG, "Skipping unexpected %s chunk of %s bytes at 0x%08x.", this.mParser.chunkName(), this.mParser.chunkSize(), this.mParser.chunkStart());
        this.mParser.skipChunk();
    }

    private void skipUnreadHeader() throws IOException {
        int bytesRead = (int)(this.mIn.position() - this.mParser.chunkStart());
        this.readExceedingBytes("Chunk header", this.mParser.headerSize(), bytesRead);
    }

    private byte[] readExceedingBytes(String name, int size, int bytesRead) throws IOException {
        int bytesExceeding = size - bytesRead;
        if (bytesExceeding > 0) {
            byte[] buf = this.mIn.readBytes(bytesExceeding);
            for (int i = 0; i < buf.length; ++i) {
                if (buf[i] == 0) continue;
                Log.w(TAG, "%s size: %s bytes, read: %s bytes. Exceeding bytes: %s", name, size, bytesRead, BaseEncoding.base16().encode(buf));
                return buf;
            }
        }
        return null;
    }

    private static final class Attribute {
        public static final int SIZE = 20;
        public final int ns;
        public final int name;
        public final int rawValue;
        public final int valueType;
        public final int valueData;

        public Attribute(int ns, int name, int rawValue, int valueType, int valueData) {
            this.ns = ns;
            this.name = name;
            this.rawValue = rawValue;
            this.valueType = valueType;
            this.valueData = valueData;
        }

        public static Attribute read(BinaryDataInputStream in) throws IOException {
            int ns = in.readInt();
            int name = in.readInt();
            int rawValue = in.readInt();
            int valueSize = in.readUnsignedShort();
            if (valueSize < 8) {
                return null;
            }
            in.skipByte();
            int valueType = in.readUnsignedByte();
            int valueData = in.readInt();
            return new Attribute(ns, name, rawValue, valueType, valueData);
        }
    }

    private static final class NamespaceStack {
        private static final int INITIAL_CAPACITY = 32;
        private int[] mData = new int[32];
        private int mDataLength;
        private int mDepth;

        public NamespaceStack() {
            this.reset();
        }

        public void reset() {
            this.mDataLength = 0;
            this.mDepth = -1;
            this.incrementDepth();
        }

        public int getDepth() {
            return this.mDepth;
        }

        public void incrementDepth() {
            this.ensureCapacity();
            int offset = this.mDataLength;
            this.mData[offset] = 0;
            this.mData[offset + 1] = 0;
            this.mDataLength += 2;
            ++this.mDepth;
        }

        private void ensureCapacity() {
            if (this.mData.length - this.mDataLength >= 2) {
                return;
            }
            int[] newData = new int[this.mData.length + 32];
            System.arraycopy(this.mData, 0, newData, 0, this.mDataLength);
            this.mData = newData;
        }

        public void decrementDepth() {
            if (this.mDataLength == 0) {
                return;
            }
            int offset = this.mDataLength - 1;
            int count = this.mData[offset];
            this.mDataLength -= 2 + count * 2;
            --this.mDepth;
        }

        public int getCount(int depth) {
            if (this.mDataLength == 0 || depth <= 0) {
                return 0;
            }
            if (depth > this.mDepth) {
                depth = this.mDepth;
            }
            int total = 0;
            int offset = 0;
            while (depth > 0) {
                int count = this.mData[offset];
                total += count;
                offset += 2 + count * 2;
                --depth;
            }
            return total;
        }

        public int getCurrentCount() {
            if (this.mDataLength == 0) {
                return 0;
            }
            int offset = this.mDataLength - 1;
            return this.mData[offset];
        }

        public void push(int prefix, int uri) {
            this.ensureCapacity();
            int offset = this.mDataLength - 1;
            int count = this.mData[offset];
            this.mData[offset - 1 - count * 2] = count + 1;
            this.mData[offset] = prefix;
            this.mData[offset + 1] = uri;
            this.mData[offset + 2] = count + 1;
            this.mDataLength += 2;
        }

        public boolean pop() {
            if (this.mDataLength == 0) {
                return false;
            }
            int offset = this.mDataLength - 1;
            int count = this.mData[offset];
            if (count == 0) {
                return false;
            }
            this.mData[offset -= 2] = --count;
            this.mData[offset -= 1 + count * 2] = count;
            this.mDataLength -= 2;
            return true;
        }

        public int getPrefix(int index) {
            return this.get(index, true);
        }

        public int getUri(int index) {
            return this.get(index, false);
        }

        private int get(int index, boolean isPrefix) {
            if (this.mDataLength == 0 || index < 0) {
                return -1;
            }
            int offset = 0;
            for (int i = this.mDepth; i >= 0; --i) {
                int count = this.mData[offset];
                if (index >= count) {
                    index -= count;
                    offset += 2 + count * 2;
                    continue;
                }
                offset += 1 + index * 2;
                if (!isPrefix) {
                    ++offset;
                }
                return this.mData[offset];
            }
            return -1;
        }

        public int findPrefix(int uri) {
            return this.find(uri, true);
        }

        public int findUri(int prefix) {
            return this.find(prefix, false);
        }

        private int find(int prefixOrUri, boolean isPrefix) {
            if (this.mDataLength == 0) {
                return -1;
            }
            int offset = this.mDataLength - 1;
            for (int i = this.mDepth; i >= 0; --i) {
                int count = this.mData[offset];
                offset -= 2;
                while (count > 0) {
                    if (isPrefix) {
                        if (this.mData[offset + 1] == prefixOrUri) {
                            return this.mData[offset];
                        }
                    } else if (this.mData[offset] == prefixOrUri) {
                        return this.mData[offset + 1];
                    }
                    offset -= 2;
                    --count;
                }
            }
            return -1;
        }
    }
}

