/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

public class Config {
    private final String mVersion;
    private int mJobs;
    private String mFrameworkDirectory;
    private String mFrameworkTag;
    private String[] mLibraryFiles;
    private boolean mForced;
    private boolean mVerbose;
    private DecodeSources mDecodeSources;
    private boolean mBaksmaliDebugMode;
    private DecodeResources mDecodeResources;
    private DecodeResolve mDecodeResolve;
    private boolean mKeepBrokenResources;
    private boolean mIgnoreRawValues;
    private boolean mAnalysisMode;
    private DecodeAssets mDecodeAssets;
    private boolean mNoApk;
    private boolean mNoCrunch;
    private boolean mCopyOriginal;
    private boolean mDebuggable;
    private boolean mNetSecConf;
    private String mAaptBinary;

    public Config(String version) {
        this.mVersion = version;
        this.mJobs = Math.min(Runtime.getRuntime().availableProcessors(), 8);
        this.mFrameworkDirectory = null;
        this.mFrameworkTag = null;
        this.mLibraryFiles = null;
        this.mForced = false;
        this.mVerbose = false;
        this.mDecodeSources = DecodeSources.ONLY_MAIN_CLASSES;
        this.mBaksmaliDebugMode = true;
        this.mDecodeResources = DecodeResources.FULL;
        this.mDecodeResolve = DecodeResolve.DEFAULT;
        this.mKeepBrokenResources = false;
        this.mIgnoreRawValues = false;
        this.mAnalysisMode = false;
        this.mDecodeAssets = DecodeAssets.FULL;
        this.mNoApk = false;
        this.mNoCrunch = false;
        this.mCopyOriginal = false;
        this.mDebuggable = false;
        this.mNetSecConf = false;
        this.mAaptBinary = null;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public int getJobs() {
        return this.mJobs;
    }

    public void setJobs(int jobs) {
        this.mJobs = jobs;
    }

    public String getFrameworkDirectory() {
        return this.mFrameworkDirectory;
    }

    public void setFrameworkDirectory(String frameworkDirectory) {
        this.mFrameworkDirectory = frameworkDirectory;
    }

    public String getFrameworkTag() {
        return this.mFrameworkTag;
    }

    public void setFrameworkTag(String frameworkTag) {
        this.mFrameworkTag = frameworkTag;
    }

    public String[] getLibraryFiles() {
        return this.mLibraryFiles;
    }

    public void setLibraryFiles(String[] libraryFiles) {
        this.mLibraryFiles = libraryFiles;
    }

    public boolean isForced() {
        return this.mForced;
    }

    public void setForced(boolean forced) {
        this.mForced = forced;
    }

    public boolean isVerbose() {
        return this.mVerbose;
    }

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    public boolean isDecodeSourcesFull() {
        return this.mDecodeSources == DecodeSources.FULL;
    }

    public boolean isDecodeSourcesNone() {
        return this.mDecodeSources == DecodeSources.NONE;
    }

    public void setDecodeSources(DecodeSources decodeSources) {
        assert (decodeSources != null);
        this.mDecodeSources = decodeSources;
    }

    public boolean isBaksmaliDebugMode() {
        return this.mBaksmaliDebugMode;
    }

    public void setBaksmaliDebugMode(boolean baksmaliDebugMode) {
        this.mBaksmaliDebugMode = baksmaliDebugMode;
    }

    public boolean isDecodeResourcesFull() {
        return this.mDecodeResources == DecodeResources.FULL;
    }

    public boolean isDecodeResourcesNone() {
        return this.mDecodeResources == DecodeResources.NONE;
    }

    public void setDecodeResources(DecodeResources decodeResources) {
        assert (decodeResources != null);
        this.mDecodeResources = decodeResources;
    }

    public boolean isDecodeResolveLazy() {
        return this.mDecodeResolve == DecodeResolve.LAZY;
    }

    public boolean isDecodeResolveGreedy() {
        return this.mDecodeResolve == DecodeResolve.GREEDY;
    }

    public void setDecodeResolve(DecodeResolve decodeResolve) {
        assert (decodeResolve != null);
        this.mDecodeResolve = decodeResolve;
    }

    public boolean isKeepBrokenResources() {
        return this.mKeepBrokenResources;
    }

    public void setKeepBrokenResources(boolean keepBrokenResources) {
        this.mKeepBrokenResources = keepBrokenResources;
    }

    public boolean isIgnoreRawValues() {
        return this.mIgnoreRawValues;
    }

    public void setIgnoreRawValues(boolean ignoreRawValues) {
        this.mIgnoreRawValues = ignoreRawValues;
    }

    public boolean isAnalysisMode() {
        return this.mAnalysisMode;
    }

    public void setAnalysisMode(boolean analysisMode) {
        this.mAnalysisMode = analysisMode;
    }

    public boolean isDecodeAssetsFull() {
        return this.mDecodeAssets == DecodeAssets.FULL;
    }

    public boolean isDecodeAssetsNone() {
        return this.mDecodeAssets == DecodeAssets.NONE;
    }

    public void setDecodeAssets(DecodeAssets decodeAssets) {
        assert (decodeAssets != null);
        this.mDecodeAssets = decodeAssets;
    }

    public boolean isNoApk() {
        return this.mNoApk;
    }

    public void setNoApk(boolean noApk) {
        this.mNoApk = noApk;
    }

    public boolean isNoCrunch() {
        return this.mNoCrunch;
    }

    public void setNoCrunch(boolean noCrunch) {
        this.mNoCrunch = noCrunch;
    }

    public boolean isCopyOriginal() {
        return this.mCopyOriginal;
    }

    public void setCopyOriginal(boolean copyOriginal) {
        this.mCopyOriginal = copyOriginal;
    }

    public boolean isDebuggable() {
        return this.mDebuggable;
    }

    public void setDebuggable(boolean debuggable) {
        this.mDebuggable = debuggable;
    }

    public boolean isNetSecConf() {
        return this.mNetSecConf;
    }

    public void setNetSecConf(boolean netSecConf) {
        this.mNetSecConf = netSecConf;
    }

    public String getAaptBinary() {
        return this.mAaptBinary;
    }

    public void setAaptBinary(String aaptBinary) {
        this.mAaptBinary = aaptBinary;
    }

    public static enum DecodeAssets {
        FULL,
        NONE;

    }

    public static enum DecodeResolve {
        DEFAULT,
        GREEDY,
        LAZY;

    }

    public static enum DecodeResources {
        FULL,
        ONLY_MANIFEST,
        NONE;

    }

    public static enum DecodeSources {
        FULL,
        ONLY_MAIN_CLASSES,
        NONE;

    }
}

