/*
 * Decompiled with CFR 0.152.
 */
package brut.xmlpull;

import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public final class XmlPullUtils {
    private static final String PROPERTY_XMLDECL_STANDALONE = "http://xmlpull.org/v1/doc/properties.html#xmldecl-standalone";

    private XmlPullUtils() {
    }

    public static void copy(XmlPullParser in, XmlSerializer out) throws XmlPullParserException, IOException {
        XmlPullUtils.copy(in, out, null);
    }

    public static void copy(XmlPullParser in, XmlSerializer out, EventHandler handler) throws XmlPullParserException, IOException {
        int event;
        Boolean standalone = (Boolean)in.getProperty(PROPERTY_XMLDECL_STANDALONE);
        if (in.getEventType() == 0) {
            out.startDocument(in.getInputEncoding(), standalone);
        }
        block11: while ((event = in.nextToken()) != -1) {
            if (event == 1) {
                out.endDocument();
                break;
            }
            if (event == 0) {
                out.startDocument(in.getInputEncoding(), standalone);
                continue;
            }
            if (handler != null && handler.onEvent(in, out)) continue;
            switch (event) {
                case 2: {
                    if (!in.getFeature("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes")) {
                        int nsStart = in.getNamespaceCount(in.getDepth() - 1);
                        int nsEnd = in.getNamespaceCount(in.getDepth());
                        for (int i = nsStart; i < nsEnd; ++i) {
                            String prefix = in.getNamespacePrefix(i);
                            String ns = in.getNamespaceUri(i);
                            out.setPrefix(prefix, ns);
                        }
                    }
                    out.startTag(XmlPullUtils.normalizeNamespace(in.getNamespace()), in.getName());
                    for (int i = 0; i < in.getAttributeCount(); ++i) {
                        String ns = XmlPullUtils.normalizeNamespace(in.getAttributeNamespace(i));
                        String name = in.getAttributeName(i);
                        String value = in.getAttributeValue(i);
                        out.attribute(ns, name, value);
                    }
                    continue block11;
                }
                case 3: {
                    out.endTag(XmlPullUtils.normalizeNamespace(in.getNamespace()), in.getName());
                    break;
                }
                case 4: {
                    out.text(in.getText());
                    break;
                }
                case 5: {
                    out.cdsect(in.getText());
                    break;
                }
                case 6: {
                    out.entityRef(in.getName());
                    break;
                }
                case 7: {
                    out.ignorableWhitespace(in.getText());
                    break;
                }
                case 8: {
                    out.processingInstruction(in.getText());
                    break;
                }
                case 9: {
                    out.comment(in.getText());
                    break;
                }
                case 10: {
                    out.docdecl(in.getText());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown event: " + event);
                }
            }
        }
    }

    private static String normalizeNamespace(String namespace) {
        return namespace != null && !namespace.isEmpty() ? namespace : null;
    }

    public static interface EventHandler {
        public boolean onEvent(XmlPullParser var1, XmlSerializer var2) throws XmlPullParserException;
    }
}

