/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResPackage;
import brut.androlib.res.table.value.ResAttribute;
import brut.androlib.res.table.value.ResBag;
import brut.androlib.res.table.value.ResItem;
import brut.androlib.res.table.value.ResReference;
import brut.common.Log;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.xmlpull.v1.XmlSerializer;

public class ResStyle
extends ResBag {
    private static final String TAG = ResStyle.class.getName();
    private final Item[] mItems;

    public ResStyle(ResReference parent, Item[] items) {
        super(parent);
        assert (parent != null && items != null);
        this.mItems = items;
    }

    public static ResStyle parse(ResReference parent, ResBag.RawItem[] rawItems) {
        Item[] items = new Item[rawItems.length];
        ResPackage pkg = parent.getPackage();
        for (int i = 0; i < rawItems.length; ++i) {
            ResBag.RawItem rawItem = rawItems[i];
            int keyId = rawItem.getKey();
            ResReference key = new ResReference(pkg, ResId.of(keyId));
            ResItem value = rawItem.getValue();
            items[i] = new Item(key, value);
        }
        return new ResStyle(parent, items);
    }

    @Override
    public void resolveKeys() throws AndrolibException {
        ResPackage pkg = this.mParent.getPackage();
        boolean skipUnresolved = pkg.getTable().getConfig().isDecodeResolveLazy();
        for (Item item : this.mItems) {
            ResReference key = item.getKey();
            if (key.resolveEntry() != null) continue;
            ResId keyId = key.getResId();
            if (skipUnresolved || keyId.pkgId() != pkg.getId()) {
                Log.w(TAG, "Unresolved style reference: key=%s, value=%s", key, item.getValue());
                continue;
            }
            pkg.addEntrySpec(keyId.typeId(), keyId.entryId(), "APKTOOL_DUMMY_" + keyId);
            pkg.addEntry(keyId.typeId(), keyId.entryId(), ResAttribute.DEFAULT);
        }
    }

    @Override
    public void serializeToValuesXml(XmlSerializer serial, ResEntry entry) throws AndrolibException, IOException {
        String tagName = "style";
        serial.startTag(null, tagName);
        serial.attribute(null, "name", entry.getName());
        if (this.mParent.resolve() != null) {
            serial.attribute(null, "parent", this.mParent.toXmlAttributeValue());
        } else if (entry.getName().indexOf(46) != -1) {
            serial.attribute(null, "parent", "");
        }
        ResPackage pkg = this.mParent.getPackage();
        boolean skipDuplicates = !pkg.getTable().getConfig().isAnalysisMode();
        HashSet<ResId> processedKeys = new HashSet<ResId>();
        for (Item item : this.mItems) {
            String body;
            ResReference key = item.getKey();
            ResEntry keyEntry = key.resolveEntry();
            if (keyEntry == null) continue;
            ResId keyId = key.getResId();
            if (skipDuplicates && processedKeys.contains(keyId)) continue;
            processedKeys.add(keyId);
            boolean includePackage = pkg.getGroup() != keyEntry.getPackage().getGroup();
            String keyName = (includePackage ? keyEntry.getPackage().getName() + ":" : "") + keyEntry.getName();
            ResItem value = item.getValue();
            if (keyEntry.getValue() instanceof ResAttribute) {
                ResAttribute keyValue = (ResAttribute)keyEntry.getValue();
                body = keyValue.formatAsTextValue(value);
            } else {
                Log.w(TAG, "Unexpected style item key: " + keyEntry);
                body = ResAttribute.DEFAULT.formatAsTextValue(value);
            }
            serial.startTag(null, "item");
            serial.attribute(null, "name", keyName);
            serial.text(body);
            serial.endTag(null, "item");
        }
        serial.endTag(null, tagName);
    }

    public String toString() {
        return String.format("ResStyle{parent=%s, items=%s}", this.mParent, Arrays.toString(this.mItems));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResStyle) {
            ResStyle other = (ResStyle)obj;
            return this.mParent.equals(other.mParent) && Arrays.equals(this.mItems, other.mItems);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mParent, Arrays.hashCode(this.mItems));
    }

    public static class Item {
        private final ResReference mKey;
        private final ResItem mValue;

        public Item(ResReference key, ResItem value) {
            assert (key != null && value != null);
            this.mKey = key;
            this.mValue = value;
        }

        public ResReference getKey() {
            return this.mKey;
        }

        public ResItem getValue() {
            return this.mValue;
        }
    }
}

