/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table;

import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResPackage;
import brut.androlib.res.table.ResTypeSpec;
import java.util.Objects;

public class ResEntrySpec {
    public static final String DUMMY_PREFIX = "APKTOOL_DUMMY_";
    public static final String RENAMED_PREFIX = "APKTOOL_RENAMED_";
    private final ResTypeSpec mTypeSpec;
    private final int mId;
    private final ResId mResId;
    private final String mName;

    public ResEntrySpec(ResTypeSpec typeSpec, int id, String name) {
        assert (typeSpec != null && id >= 0 && name != null);
        this.mTypeSpec = typeSpec;
        this.mId = id;
        this.mResId = ResId.of(typeSpec.getPackage().getId(), typeSpec.getId(), id);
        this.mName = ResEntrySpec.isValidEntryName(name) ? name : RENAMED_PREFIX + this.mResId;
    }

    private static boolean isValidEntryName(String name) {
        int len = name.length();
        if (len == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            char ch = name.charAt(i);
            if (Character.isJavaIdentifierPart(ch) || ch == '.' || ch == '-') continue;
            return false;
        }
        return true;
    }

    public ResPackage getPackage() {
        return this.mTypeSpec.getPackage();
    }

    public ResTypeSpec getTypeSpec() {
        return this.mTypeSpec;
    }

    public int getId() {
        return this.mId;
    }

    public ResId getResId() {
        return this.mResId;
    }

    public String getName() {
        return this.mName;
    }

    public String toString() {
        return String.format("ResEntrySpec{typeSpec=%s, id=0x%04x, name=%s}", this.mTypeSpec, this.mId, this.mName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResEntrySpec) {
            ResEntrySpec other = (ResEntrySpec)obj;
            return this.mTypeSpec.equals(other.mTypeSpec) && this.mId == other.mId && this.mName.equals(other.mName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mTypeSpec, this.mId, this.mName);
    }
}

