/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import brut.common.BrutException;
import brut.common.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public final class OS {
    private static final String TAG = "";

    private OS() {
    }

    public static void mkdir(String dir) {
        OS.mkdir(new File(dir));
    }

    public static void mkdir(File dir) {
        dir.mkdirs();
    }

    public static void rmfile(String file) {
        OS.rmfile(new File(file));
    }

    public static void rmfile(File file) {
        file.delete();
    }

    public static void rmdir(String dir) {
        OS.rmdir(new File(dir));
    }

    public static void rmdir(File dir) {
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                OS.rmdir(file);
                continue;
            }
            OS.rmfile(file);
        }
        OS.rmfile(dir);
    }

    public static void mvfile(String src, String dest) throws BrutException {
        OS.mvfile(new File(src), new File(dest));
    }

    public static void mvfile(File src, File dest) throws BrutException {
        try {
            Files.move(src.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            throw new BrutException("Could not move file: " + src, ex);
        }
    }

    public static void cpfile(String src, String dest) throws BrutException {
        OS.cpfile(new File(src), new File(dest));
    }

    public static void cpfile(File src, File dest) throws BrutException {
        if (!src.isFile()) {
            return;
        }
        try {
            Files.copy(src.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            throw new BrutException("Could not copy file: " + src, ex);
        }
    }

    public static void cpdir(String src, String dest) throws BrutException {
        OS.cpdir(new File(src), new File(dest));
    }

    public static void cpdir(File src, File dest) throws BrutException {
        if (!src.isDirectory()) {
            return;
        }
        OS.mkdir(dest);
        File[] files = src.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            File destFile = new File(dest, file.getName());
            if (file.isDirectory()) {
                OS.cpdir(file, destFile);
                continue;
            }
            OS.cpfile(file, destFile);
        }
    }

    public static void exec(String[] cmd) throws BrutException {
        try {
            ProcessBuilder builder = new ProcessBuilder(cmd);
            Process ps = builder.start();
            new StreamForwarder(ps.getErrorStream(), "ERROR").start();
            new StreamForwarder(ps.getInputStream(), "OUTPUT").start();
            int exitValue = ps.waitFor();
            if (exitValue != 0) {
                throw new BrutException("Execution failed (exit code = " + exitValue + "): " + Arrays.toString(cmd));
            }
        }
        catch (IOException ex) {
            throw new BrutException("could not exec: " + Arrays.toString(cmd), ex);
        }
        catch (InterruptedException ex) {
            throw new BrutException("could not exec : " + Arrays.toString(cmd), ex);
        }
    }

    public static String execAndReturn(String[] cmd) {
        ExecutorService executor = Executors.newCachedThreadPool();
        try {
            ProcessBuilder builder = new ProcessBuilder(cmd);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            StreamCollector collector = new StreamCollector(process.getInputStream());
            executor.execute(collector);
            process.waitFor(15L, TimeUnit.SECONDS);
            executor.shutdownNow();
            if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                Log.w(TAG, "Stream collector did not terminate.");
            }
            return collector.get();
        }
        catch (IOException | InterruptedException ignored) {
            return null;
        }
    }

    public static File createTempDirectory() throws BrutException {
        try {
            File tmp = File.createTempFile("BRUT", null);
            tmp.deleteOnExit();
            if (!tmp.delete()) {
                throw new BrutException("Could not delete tmp file: " + tmp.getAbsolutePath());
            }
            if (!tmp.mkdir()) {
                throw new BrutException("Could not create tmp dir: " + tmp.getAbsolutePath());
            }
            return tmp;
        }
        catch (IOException ex) {
            throw new BrutException("Could not create tmp dir", ex);
        }
    }

    private static class StreamCollector
    implements Runnable {
        private final InputStream mIn;
        private final StringBuilder mBuffer;

        public StreamCollector(InputStream in) {
            this.mIn = in;
            this.mBuffer = new StringBuilder();
        }

        @Override
        public void run() {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.mIn));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.mBuffer.append(line).append('\n');
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String get() {
            return this.mBuffer.toString();
        }
    }

    private static class StreamForwarder
    extends Thread {
        private final InputStream mIn;
        private final String mType;

        public StreamForwarder(InputStream in, String type) {
            this.mIn = in;
            this.mType = type;
        }

        @Override
        public void run() {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.mIn));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (this.mType.equals("OUTPUT")) {
                        Log.i(OS.TAG, line);
                        continue;
                    }
                    Log.w(OS.TAG, line);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

