/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.xml;

import brut.androlib.res.data.StyledString;
import brut.util.TextUtils;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class ResStringEncoder {
    private static final Pattern TAG_SPLIT_PATTERN = Pattern.compile(";(?=[\\p{L}_][\\p{L}\\p{N}_.-]*=)");

    private ResStringEncoder() {
    }

    public static String encodeTextValue(CharSequence text) {
        return text instanceof StyledString ? ResStringEncoder.encodeStyledString((StyledString)text) : ResStringEncoder.encodeRawString(text.toString(), 0);
    }

    public static String encodeAttributeValue(CharSequence text) {
        return ResStringEncoder.encodeAttributeValue(text, 65535);
    }

    public static String encodeAttributeValue(CharSequence text, int attrType) {
        return ResStringEncoder.encodeRawString(text.toString(), attrType);
    }

    private static String encodeStyledString(StyledString styledStr) {
        String str = styledStr.getValue();
        StyledString.Span[] spans = styledStr.getSpans();
        int len = str.length();
        if (len == 0 && spans.length == 0) {
            return "";
        }
        StringBuilder out = new StringBuilder(len * 2);
        ArrayDeque<StyledString.Span> stack = new ArrayDeque<StyledString.Span>();
        int offset = 0;
        for (int i = 0; i <= spans.length; ++i) {
            StyledString.Span span;
            int prevOffset = offset;
            if (i < spans.length) {
                span = spans[i];
                offset = span.getFirstChar();
            } else {
                span = null;
                offset = len;
            }
            while (!stack.isEmpty() && ((StyledString.Span)stack.peek()).getLastChar() < offset) {
                String prevTag;
                int prevTagEnd;
                StyledString.Span prevSpan = (StyledString.Span)stack.pop();
                int prevSpanEnd = prevSpan.getLastChar() + 1;
                if (prevOffset < prevSpanEnd) {
                    ResStringEncoder.appendEscapedString(out, str, prevOffset, prevSpanEnd, 0, true);
                    prevOffset = prevSpanEnd;
                }
                if ((prevTagEnd = (prevTag = prevSpan.getTag()).indexOf(59)) == -1) {
                    prevTagEnd = prevTag.length();
                }
                out.append("</").append(prevTag, 0, prevTagEnd).append('>');
            }
            if (prevOffset > offset) continue;
            if (prevOffset < offset) {
                ResStringEncoder.appendEscapedString(out, str, prevOffset, offset, 0, true);
            }
            if (span == null) break;
            int spanEnd = span.getLastChar() + 1;
            String tag = span.getTag();
            int tagEnd = tag.indexOf(59);
            if (tagEnd == -1) {
                tagEnd = tag.length();
            }
            if (tagEnd == 0) continue;
            out.append('<').append(tag, 0, tagEnd);
            if (tagEnd < tag.length()) {
                for (String attr : TAG_SPLIT_PATTERN.split(tag.substring(tagEnd + 1))) {
                    int nameEnd;
                    int attrLen = attr.length();
                    if (attrLen == 0 || (nameEnd = attr.indexOf(61)) == -1) continue;
                    int valueStart = nameEnd + 1;
                    out.append(' ').append(attr, 0, valueStart).append('\"');
                    if (valueStart < attrLen) {
                        ResStringEncoder.appendTagAttributeValue(out, attr, valueStart, attrLen);
                    }
                    out.append('\"');
                }
            }
            if (offset == spanEnd) {
                out.append("/>");
                continue;
            }
            out.append('>');
            stack.push(span);
        }
        return out.toString();
    }

    private static String encodeRawString(String str, int attrType) {
        int len = str.length();
        if (len == 0) {
            return "";
        }
        StringBuilder out = new StringBuilder(len * 2);
        ResStringEncoder.appendEscapedString(out, str, 0, len, attrType, false);
        if (out.charAt(0) != '\"' && ResStringEncoder.isAmbiguousString(out, attrType)) {
            out.insert(0, '\\');
        }
        return out.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static void appendEscapedString(StringBuilder out, String str, int start, int end, int attrType, boolean styled) {
        len = str.length();
        offset = out.length();
        quote = false;
        ch = '\u0000';
        prev = '\u0000';
        prev2 = '\u0000';
        for (i = start; i < end; ++i) {
            block14: {
                block16: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block15: {
                                        block13: {
                                            ch = str.charAt(i);
                                            if (ch != '\n') break block13;
                                            if (attrType != 0) {
                                                out.append("\\n");
                                            } else {
                                                out.append(ch);
                                                quote = true;
                                            }
                                            break block14;
                                        }
                                        if (ch != '\t') break block15;
                                        out.append("\\t");
                                        break block14;
                                    }
                                    if (!TextUtils.isPrintableChar(ch)) break block16;
                                    if (ch != '\\') break block17;
                                    out.append('\\');
                                    ** GOTO lbl-1000
                                }
                                if (attrType != 0) ** GOTO lbl-1000
                                if (ch != ' ') break block18;
                                if (prev == ' ' || !styled && (i == 0 || i == len - 1)) {
                                    quote = true;
                                }
                                ** GOTO lbl-1000
                            }
                            if (ch != '\'') break block19;
                            quote = true;
                            ** GOTO lbl-1000
                        }
                        if (ch != '\"') break block20;
                        out.append('\\');
                        ** GOTO lbl-1000
                    }
                    if (ch == '&') {
                        out.append("&amp;");
                    } else if (ch == '<') {
                        out.append("&lt;");
                    } else if (ch == '>' && prev == ']' && prev2 == ']') {
                        out.append("&gt;");
                    } else lbl-1000:
                    // 6 sources

                    {
                        out.append(ch);
                    }
                    break block14;
                }
                if (Character.isHighSurrogate(ch) && i < end - 1 && Character.isLowSurrogate(low = str.charAt(i + 1))) {
                    out.append(ch);
                    out.append(low);
                    ++i;
                } else {
                    if (ch == '\u0000' && i == len - 1) break;
                    out.append(String.format("\\u%04x", new Object[]{(int)ch}));
                }
            }
            prev2 = prev;
            prev = ch;
        }
        if (quote) {
            out.insert(offset, '\"').append('\"');
        }
    }

    private static boolean isAmbiguousString(CharSequence text, int attrType) {
        boolean checkFraction;
        int len = text.length();
        char ch = text.charAt(0);
        if (ch == '@') {
            if (len == 5 ? text.charAt(1) == 'n' && text.charAt(2) == 'u' && text.charAt(3) == 'l' && text.charAt(4) == 'l' : len == 6 && text.charAt(1) == 'e' && text.charAt(2) == 'm' && text.charAt(3) == 'p' && text.charAt(4) == 't' && text.charAt(5) == 'y') {
                return true;
            }
            for (int i = 1; i < len; ++i) {
                if (text.charAt(i) != '/') continue;
                return true;
            }
            return false;
        }
        if (ch == '?') {
            return len > 1;
        }
        if (attrType == 0) {
            return false;
        }
        if (ch == '#') {
            if ((attrType & 0x10) != 0) {
                try {
                    TextUtils.parseColor(text, 0, len);
                    return true;
                }
                catch (NumberFormatException i) {
                    // empty catch block
                }
            }
            return false;
        }
        if ((attrType & 4) != 0) {
            try {
                TextUtils.parseInt(text, 0, len);
                return true;
            }
            catch (NumberFormatException i) {
                // empty catch block
            }
        }
        boolean checkFloat = (attrType & 0x20) != 0;
        boolean checkDimen = (attrType & 0x40) != 0;
        boolean bl = checkFraction = (attrType & 0x80) != 0;
        if (checkFloat || checkDimen || checkFraction) {
            String suffix;
            int suffixLen = 0;
            if (checkDimen && (suffix = TextUtils.matchSuffix(text, "px", "dp", "dip", "sp", "pt", "in", "mm")) != null) {
                suffixLen = suffix.length();
            }
            if (checkFraction && suffixLen == 0 && (suffix = TextUtils.matchSuffix(text, "%", "%p")) != null) {
                suffixLen = suffix.length();
            }
            if (checkFloat && suffixLen == 0 || suffixLen > 0) {
                try {
                    TextUtils.parseFloat(text, 0, len - suffixLen);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private static void appendTagAttributeValue(StringBuilder out, String str, int start, int end) {
        char ch = '\u0000';
        char prev = '\u0000';
        char prev2 = '\u0000';
        for (int i = start; i < end; ++i) {
            ch = str.charAt(i);
            if (ch == '\n') {
                out.append("&#xA;");
            } else if (ch == '\r') {
                out.append("&#xD;");
            } else if (ch == '\t') {
                out.append("&#x9;");
            } else if (ch == '\"') {
                out.append("&quot;");
            } else if (ch == '&') {
                out.append("&amp;");
            } else if (ch == '<') {
                out.append("&lt;");
            } else if (ch == '>' && prev == ']' && prev2 == ']') {
                out.append("&gt;");
            } else {
                out.append(ch);
            }
            prev2 = prev;
            prev = ch;
        }
    }

    public static String normalizeFormatSpecifiers(String str) {
        int len = str.length();
        if (len == 0) {
            return str;
        }
        int[][] specs = ResStringEncoder.findFormatSpecifiers(str);
        int[] sequential = specs[0];
        int[] positional = specs[1];
        if (sequential.length == 0 || sequential.length + positional.length < 2) {
            return str;
        }
        StringBuilder out = new StringBuilder(len + sequential.length * 2);
        int i = 0;
        int count = 0;
        for (int j : sequential) {
            out.append(str, i, ++j).append(++count).append('$');
            i = j;
        }
        out.append(str, i, len);
        return out.toString();
    }

    public static int[][] findFormatSpecifiers(String str) {
        int i;
        int[] sequential = new int[4];
        int sequentialCount = 0;
        int[] positional = new int[4];
        int positionalCount = 0;
        int len = str.length();
        int j = 0;
        while ((i = str.indexOf(37, j)) != -1) {
            char ch;
            j = i + 1;
            if (j == len) {
                if (sequentialCount == sequential.length) {
                    sequential = Arrays.copyOf(sequential, sequential.length + 4);
                }
                sequential[sequentialCount++] = i - 1;
                break;
            }
            if ((ch = str.charAt(j++)) == '%') continue;
            if (ch >= '0' && ch <= '9' && j < len) {
                while ((ch = str.charAt(j++)) >= '0' && ch <= '9' && j < len) {
                }
                if (ch == '$') {
                    if (positionalCount == positional.length) {
                        positional = Arrays.copyOf(positional, positional.length + 4);
                    }
                    positional[positionalCount++] = i;
                    continue;
                }
            }
            if (sequentialCount == sequential.length) {
                sequential = Arrays.copyOf(sequential, sequential.length + 4);
            }
            sequential[sequentialCount++] = i;
        }
        if (sequentialCount < sequential.length) {
            sequential = Arrays.copyOf(sequential, sequentialCount);
        }
        if (positionalCount < positional.length) {
            positional = Arrays.copyOf(positional, positionalCount);
        }
        return new int[][]{sequential, positional};
    }
}

