/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.shared.impl.cldr;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "smn" locale.
 */
public class DateTimeFormatInfoImpl_smn extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "ip.",
        "ep."
    };
  }

  @Override
  public String dateFormatFull() {
    return "cccc, MMMM d. y";
  }

  @Override
  public String dateFormatLong() {
    return "MMMM d. y";
  }

  @Override
  public String dateFormatMedium() {
    return "MMM d. y";
  }

  @Override
  public String dateFormatShort() {
    return "d.M.y";
  }

  @Override
  public String dateTimeFull(String timePattern, String datePattern) {
    return datePattern + " 'tme' " + timePattern;
  }

  @Override
  public String dateTimeLong(String timePattern, String datePattern) {
    return datePattern + " 'tme' " + timePattern;
  }

  @Override
  public String dateTimeMedium(String timePattern, String datePattern) {
    return datePattern + " 'tme' " + timePattern;
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "Ovdil Kristus šoddâm",
        "maŋa Kristus šoddâm"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "oKr.",
        "mKr."
    };
  }

  @Override
  public String formatHour12Minute() {
    return "h.mm a";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "h.mm.ss a";
  }

  @Override
  public String formatHour24Minute() {
    return "H.mm";
  }

  @Override
  public String formatHour24MinuteSecond() {
    return "H.mm.ss";
  }

  @Override
  public String formatMinuteSecond() {
    return "m.ss.";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "MMM d.";
  }

  @Override
  public String formatMonthFullDay() {
    return "MMMM d.";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, MMMM d.";
  }

  @Override
  public String formatMonthNumDay() {
    return "d.M.";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "LLL y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "MMM d. y";
  }

  @Override
  public String formatYearMonthFull() {
    return "LLLL y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "MMMM d. y";
  }

  @Override
  public String formatYearMonthNum() {
    return "L.y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "d.M.y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "ccc, MMM d. y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "uđđâivemáánu",
        "kuovâmáánu",
        "njuhčâmáánu",
        "cuáŋuimáánu",
        "vyesimáánu",
        "kesimáánu",
        "syeinimáánu",
        "porgemáánu",
        "čohčâmáánu",
        "roovvâdmáánu",
        "skammâmáánu",
        "juovlâmáánu"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "U",
        "K",
        "NJ",
        "C",
        "V",
        "K",
        "S",
        "P",
        "Č",
        "R",
        "S",
        "J"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "uđiv",
        "kuovâ",
        "njuhčâ",
        "cuáŋui",
        "vyesi",
        "kesi",
        "syeini",
        "porge",
        "čohčâ",
        "roovvâd",
        "skammâ",
        "juovlâ"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "1. niäljádâs",
        "2. niäljádâs",
        "3. niäljádâs",
        "4. niäljádâs"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "1. niälj.",
        "2. niälj.",
        "3. niälj.",
        "4. niälj."
    };
  }

  @Override
  public String timeFormatFull() {
    return "H.mm.ss zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "H.mm.ss z";
  }

  @Override
  public String timeFormatMedium() {
    return "H.mm.ss";
  }

  @Override
  public String timeFormatShort() {
    return "H.mm";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "pasepeeivi",
        "vuossaargâ",
        "majebaargâ",
        "koskoho",
        "tuorâstuv",
        "vástuppeeivi",
        "lávurduv"
    };
  }

  @Override
  public String[] weekdaysFullStandalone() {
    return new String[] {
        "pasepeivi",
        "vuossargâ",
        "majebargâ",
        "koskokko",
        "tuorâstâh",
        "vástuppeivi",
        "lávurdâh"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "p",
        "V",
        "M",
        "K",
        "T",
        "V",
        "L"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "pas",
        "vuo",
        "maj",
        "kos",
        "tuo",
        "vás",
        "láv"
    };
  }
}
