/*
 * Decompiled with CFR 0.152.
 */
package org.jpl7;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.jpl7.Atom;
import org.jpl7.Compound;
import org.jpl7.Dict;
import org.jpl7.Float;
import org.jpl7.Integer;
import org.jpl7.JPL;
import org.jpl7.JPLException;
import org.jpl7.JRef;
import org.jpl7.Query;
import org.jpl7.Rational;
import org.jpl7.Variable;
import org.jpl7.fli.DoubleHolder;
import org.jpl7.fli.Int64Holder;
import org.jpl7.fli.IntHolder;
import org.jpl7.fli.ObjectHolder;
import org.jpl7.fli.Prolog;
import org.jpl7.fli.StringHolder;
import org.jpl7.fli.TermHolder;
import org.jpl7.fli.term_t;

public abstract class Term {
    protected Term() {
    }

    public Term arg(int n) {
        throw new JPLException("arg(int) is undefined for " + this.typeName() + " instances");
    }

    public Term[] args() {
        throw new JPLException("args() is undefined for " + this.typeName());
    }

    public int arity() {
        return 0;
    }

    public String atomType() {
        throw new JPLException("atomType() is undefined for " + this.typeName());
    }

    public String name() {
        throw new JPLException("name() is undefined for " + this.typeName());
    }

    public void setName(String string) {
        throw new JPLException("name() is undefined for " + this.typeName());
    }

    public static Term textToTerm(String string) {
        Query query = new Query(new Compound("atom_to_term", new Term[]{new Atom(string), new Variable("T"), new Variable("NVdict")}));
        query.open();
        if (query.hasMoreSolutions()) {
            Term[] termArray;
            Map<String, Term> map = query.nextSolution();
            for (Term term : termArray = Term.listToTermArray(map.get("NVdict"))) {
                String string2 = term.arg(1).name();
                Variable variable = (Variable)term.arg(2);
                variable.setName(string2);
            }
            query.close();
            return map.get("T");
        }
        query.close();
        return null;
    }

    public static Term textParamsToTerm(String string, Term[] termArray) {
        return Term.textToTerm(string).putParams(termArray);
    }

    public int intValue() {
        throw new JPLException("intValue() is undefined for " + this.typeName());
    }

    public long longValue() {
        throw new JPLException("longValue() is undefined for " + this.typeName());
    }

    public BigInteger bigValue() {
        throw new JPLException("bigValue() is undefined for " + this.typeName());
    }

    public double doubleValue() {
        throw new JPLException("doubleValue() is undefined for " + this.typeName());
    }

    public float floatValue() {
        throw new JPLException("floatValue() is undefined for " + this.typeName());
    }

    protected static Term getTerm(Map<term_t, Variable> map, term_t term_t2) {
        return Term.getLoop(new GetTask(0, new TermHolder(), term_t2), map);
    }

    protected static Term getTerm(term_t term_t2) {
        return Term.getTerm(new HashMap<term_t, Variable>(), term_t2);
    }

    public boolean hasFunctor(String string, int n) {
        return false;
    }

    public boolean hasFunctor(long l, int n) {
        return false;
    }

    public boolean hasFunctor(BigInteger bigInteger, int n) {
        return false;
    }

    public boolean hasFunctor(double d, int n) {
        return false;
    }

    public final boolean isAtom() {
        return this instanceof Atom;
    }

    protected boolean isAtomOfNameType(String string, String string2) {
        return false;
    }

    public boolean isBig() {
        throw new JPLException("isBig() is undefined for " + this.typeName());
    }

    public boolean isBigInteger() {
        return this instanceof Integer && ((Integer)this).isBig();
    }

    public final boolean isCompound() {
        return this instanceof Compound;
    }

    public final boolean isFloat() {
        return this instanceof Float;
    }

    public final boolean isInteger() {
        return this instanceof Integer;
    }

    public boolean isJFalse() {
        return false;
    }

    public boolean isJNull() {
        return false;
    }

    public final boolean isJRef() {
        return this instanceof JRef;
    }

    public boolean isJTrue() {
        return false;
    }

    public boolean isJVoid() {
        return false;
    }

    public final boolean isVariable() {
        return this instanceof Variable;
    }

    public Object object() {
        if (this == JPL.JNULL) {
            return null;
        }
        throw new JPLException("term is neither a JRef nor a Compound representing @(null)");
    }

    @Deprecated
    public static final Term objectToJRef(Object object) {
        return JPL.newJRef(object);
    }

    protected void put(term_t term_t2) {
        Term.putTerm(this, new HashMap<String, term_t>(), term_t2);
    }

    protected static void putTerm(Term term, Map<String, term_t> map, term_t term_t2) {
        Term.putLoop(new PutTask(0, term, term_t2), map);
    }

    protected static void putLoop(PutTask putTask, Map<String, term_t> map) {
        PutTask putTask2 = putTask;
        block10: while (putTask2 != null) {
            term_t term_t2;
            Term term;
            if (putTask2.n > putTask2.t.arity()) {
                if (putTask2.termP != null) {
                    Prolog.cons_functor_v(putTask2.termP, Prolog.new_functor(Prolog.new_atom(putTask2.t.name()), putTask2.t.arity()), putTask2.term);
                }
                putTask2 = putTask2.prev;
                continue;
            }
            if (putTask2.n == 0) {
                term = putTask2.t;
                term_t2 = putTask2.term;
                putTask2 = putTask2.prev;
            } else {
                term = putTask2.t.arg(putTask2.n);
                if (putTask2.n == 1) {
                    term_t2 = putTask2.term;
                } else {
                    term_t2 = new term_t();
                    term_t2.value = putTask2.term.value + (long)(putTask2.n - 1);
                }
                ++putTask2.n;
            }
            switch (term.type()) {
                case 2: {
                    if (term.equals(JPL.LIST_NIL)) {
                        Prolog.put_nil(term_t2);
                        continue block10;
                    }
                    Prolog.put_atom_chars(term_t2, term.name());
                    continue block10;
                }
                case 7: {
                    putTask2 = new PutTask(1, term, Prolog.new_term_refs(term.arity()), term_t2, putTask2);
                    continue block10;
                }
                case 44: {
                    Prolog.put_rational(term_t2, term.toString());
                    continue block10;
                }
                case 5: {
                    Prolog.put_float(term_t2, term.floatValue());
                    continue block10;
                }
                case 3: {
                    if (term.isBig()) {
                        Prolog.put_integer_big(term_t2, term.bigValue().toString());
                        continue block10;
                    }
                    Prolog.put_integer(term_t2, term.longValue());
                    continue block10;
                }
                case 102: {
                    Prolog.put_jref(term_t2, term.object());
                    continue block10;
                }
                case 4: {
                    Prolog.put_rational(term_t2, term.toString());
                    continue block10;
                }
                case 1: {
                    term_t term_t3;
                    if (term.name().equals("_") || (term_t3 = map.get(term.name())) == null) {
                        ((Variable)term).term_ = term_t2;
                        ((Variable)term).index = map.size();
                        Prolog.put_variable(term_t2);
                        if (term.name().equals("_")) continue block10;
                        map.put(term.name(), term_t2);
                        continue block10;
                    }
                    ((Variable)term).term_ = term_t3;
                    Prolog.put_term(term_t2, term_t3);
                    continue block10;
                }
            }
            throw new JPLException("bad term type in Term.putLoop/2");
        }
    }

    public Term putParams(Term[] termArray) {
        IntHolder intHolder = new IntHolder();
        intHolder.value = 0;
        Term term = this.putParams1(intHolder, termArray);
        if (intHolder.value != termArray.length) {
            throw new JPLException("more actual params than formal");
        }
        return term;
    }

    protected Term putParams(Term term) {
        Term[] termArray = term.listToTermArray();
        return this.putParams(termArray);
    }

    protected Term putParams1(IntHolder intHolder, Term[] termArray) {
        switch (this.type()) {
            case 7: {
                return new Compound(this.name(), Term.putParams2(this.args(), intHolder, termArray));
            }
            case 2: {
                if (!this.name().equals("?")) {
                    return this;
                }
                if (intHolder.value >= termArray.length) {
                    throw new JPLException("fewer actual params than formal params");
                }
                return termArray[intHolder.value++];
            }
        }
        return this;
    }

    protected static Term[] putParams2(Term[] termArray, IntHolder intHolder, Term[] termArray2) {
        int n = termArray.length;
        Term[] termArray3 = new Term[n];
        for (int i = 0; i < n; ++i) {
            termArray3[i] = termArray[i].putParams1(intHolder, termArray2);
        }
        return termArray3;
    }

    public static void putTerm(Object object, term_t term_t2) {
        if (!(object instanceof Term)) {
            throw new JPLException("not a Term");
        }
        Term.putTerm((Term)object, new HashMap<String, term_t>(), term_t2);
    }

    protected static term_t putArgs(Term term, Map<String, term_t> map) {
        term_t term_t2 = Prolog.new_term_refs(term.arity());
        Term.putLoop(new PutTask(1, term, term_t2), map);
        return term_t2;
    }

    @Deprecated
    public Object ref() {
        throw new JPLException("this Term is not a JRef");
    }

    @Deprecated
    public Object jrefToObject() {
        return this.object();
    }

    protected void getSubst(Map<String, Term> map, Map<term_t, Variable> map2) {
    }

    protected static void getSubsts(Map<String, Term> map, Map<term_t, Variable> map2, Term[] termArray) {
        Term.getSubstsLoop(map, map2, termArray);
    }

    public static String toString(Term[] termArray) {
        Object object = "";
        for (int i = 0; i < termArray.length; ++i) {
            object = (String)object + termArray[i].toString();
            if (i == termArray.length - 1) continue;
            object = (String)object + ", ";
        }
        return object;
    }

    public abstract int type();

    public abstract String typeName();

    public boolean isListNil() {
        return false;
    }

    public boolean isListPair() {
        return false;
    }

    public final boolean isList() {
        return Term.isList(this);
    }

    public static final boolean isList(Term term) {
        return Term.listLength(term) >= 0;
    }

    public static int listLength(Term term) {
        int n = 0;
        Term term2 = term;
        while (term2.isListPair()) {
            ++n;
            term2 = term2.arg(2);
        }
        return term2.isListNil() ? n : -1;
    }

    public int listLength() {
        return Term.listLength(this);
    }

    public static Term stringArrayToList(String[] stringArray) {
        Term term = JPL.LIST_NIL;
        for (int i = stringArray.length - 1; i >= 0; --i) {
            term = new Compound(JPL.LIST_PAIR, new Term[]{new Atom(stringArray[i]), term});
        }
        return term;
    }

    public static Term intArrayToList(int[] nArray) {
        Term term = JPL.LIST_NIL;
        for (int i = nArray.length - 1; i >= 0; --i) {
            term = new Compound(JPL.LIST_PAIR, new Term[]{new Integer(nArray[i]), term});
        }
        return term;
    }

    public static Term intArrayArrayToList(int[][] nArray) {
        Term term = JPL.LIST_NIL;
        for (int i = nArray.length - 1; i >= 0; --i) {
            term = new Compound(JPL.LIST_PAIR, new Term[]{Term.intArrayToList(nArray[i]), term});
        }
        return term;
    }

    public static Term termArrayToList(Term[] termArray) {
        Term term = JPL.LIST_NIL;
        for (int i = termArray.length - 1; i >= 0; --i) {
            term = new Compound(JPL.LIST_PAIR, new Term[]{termArray[i], term});
        }
        return term;
    }

    public static String[] atomListToStringArray(Term term) {
        int n = Term.listLength(term);
        if (n < 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        Term term2 = term;
        while (term2.isListPair()) {
            Term term3 = term2.arg(1);
            if (!term3.isAtom()) {
                return null;
            }
            stringArray[n2++] = term3.name();
            term2 = term2.arg(2);
        }
        return term2.isListNil() ? stringArray : null;
    }

    public static Term[] listToTermArray(Term term) {
        int n = Term.listLength(term);
        if (n < 0) {
            throw new JPLException("term is not a proper list");
        }
        Term[] termArray = new Term[n];
        for (int i = 0; i < n; ++i) {
            termArray[i] = term.arg(1);
            term = term.arg(2);
        }
        return termArray;
    }

    public final Term[] listToTermArray() {
        return Term.listToTermArray(this);
    }

    @Deprecated
    public final Term[] toTermArray() {
        return this.listToTermArray();
    }

    protected static Term getLoop(GetTask getTask, Map<term_t, Variable> map) {
        GetTask getTask2 = getTask;
        StringHolder stringHolder = new StringHolder();
        StringHolder stringHolder2 = new StringHolder();
        IntHolder intHolder = new IntHolder();
        Int64Holder int64Holder = new Int64Holder();
        DoubleHolder doubleHolder = new DoubleHolder();
        ObjectHolder objectHolder = new ObjectHolder();
        while (getTask2 != null) {
            Object object;
            term_t term_t2;
            GetTask getTask3 = getTask2;
            if (getTask3.n > 0) {
                term_t2 = Prolog.new_term_ref();
                Prolog.get_arg(getTask3.n, getTask3.term, term_t2);
                if (getTask3.n == getTask3.arity) {
                    getTask2 = getTask2.prev;
                }
            } else if (getTask2.n < 0) {
                term_t2 = Prolog.new_term_ref();
                Prolog.get_arg(-getTask3.n, getTask3.term, term_t2);
                if (-getTask3.n == getTask3.arity) {
                    getTask2 = getTask2.prev;
                }
            } else {
                term_t2 = getTask3.term;
                getTask2 = getTask2.prev;
            }
            switch (Prolog.term_type(term_t2)) {
                case 1: {
                    object = null;
                    for (term_t term_t3 : map.keySet()) {
                        if (Prolog.compare(term_t3, term_t2) != 0) continue;
                        object = map.get(term_t3);
                        break;
                    }
                    if (object != null) break;
                    Variable variable = new Variable();
                    variable.term_ = term_t2;
                    map.put(term_t2, variable);
                    object = variable;
                    break;
                }
                case 2: {
                    if (Prolog.get_atom_chars(term_t2, stringHolder)) {
                        object = new Atom(stringHolder.value, "text");
                        break;
                    }
                    throw new JPLException("Prolog.get_atom_chars failed");
                }
                case 6: {
                    if (Prolog.get_string_chars(term_t2, stringHolder)) {
                        object = new Atom(stringHolder.value, "string");
                        break;
                    }
                    throw new JPLException("Prolog.get_string_chars failed");
                }
                case 3: {
                    if (Prolog.get_integer(term_t2, int64Holder)) {
                        object = new Integer(int64Holder.value);
                        break;
                    }
                    if (Prolog.get_integer_big(term_t2, stringHolder)) {
                        object = new Integer(new BigInteger(stringHolder.value));
                        break;
                    }
                    throw new JPLException("Prolog.get_integer and Prolog.get_integer_big failed");
                }
                case 9: {
                    if (Prolog.get_jref_object(term_t2, objectHolder)) {
                        object = objectHolder.value == null ? JPL.JNULL : new JRef(objectHolder.value);
                        break;
                    }
                    throw new JPLException("unsupported blob type passed from Prolog");
                }
                case 7: 
                case 10: {
                    if (Prolog.get_name_arity(term_t2, stringHolder2, intHolder)) {
                        object = new Compound(stringHolder2.value, new Term[intHolder.value]);
                        if (intHolder.value <= 0) break;
                        getTask2 = new GetTask(1, new TermHolder((Term)object), term_t2, intHolder.value, getTask2);
                        break;
                    }
                    throw new JPLException("Prolog.get_name_arity failed");
                }
                case 44: {
                    if (Prolog.get_name_arity(term_t2, stringHolder2, intHolder)) {
                        object = new Dict(null, new HashMap<Atom, Term>((intHolder.value - 1) / 2));
                        getTask2 = new GetTask(-1, new TermHolder((Term)object), term_t2, intHolder.value, getTask2);
                        break;
                    }
                    throw new JPLException("Prolog.get_name_arity failed on a dict");
                }
                case 5: {
                    if (Prolog.get_float(term_t2, doubleHolder)) {
                        object = new Float(doubleHolder.value);
                        break;
                    }
                    throw new JPLException("Prolog.get_float failed");
                }
                case 8: {
                    object = JPL.LIST_NIL;
                    break;
                }
                case 4: {
                    if (Prolog.get_rational(term_t2, stringHolder)) {
                        object = new Rational(stringHolder.value);
                        break;
                    }
                    throw new JPLException("Prolog.get_rational failed");
                }
                default: {
                    throw new JPLException("unknown term type=" + Prolog.term_type(term_t2));
                }
            }
            if (getTask3.n > 0) {
                getTask3.hTerm.t.args()[getTask3.n - 1] = object;
                if (getTask3.n >= getTask3.arity) continue;
                ++getTask3.n;
                continue;
            }
            if (getTask3.n < 0) {
                if (-getTask3.n == 1) {
                    ((Dict)getTask3.hTerm.t).tag = object;
                    if (-getTask3.n >= getTask3.arity) continue;
                    --getTask2.n;
                    continue;
                }
                if (-getTask3.n % 2 == 0) {
                    --getTask3.n;
                    getTask3.value = object;
                    continue;
                }
                ((Dict)getTask3.hTerm.t).map.put((Atom)object, getTask3.value);
                if (-getTask3.n >= getTask3.arity) continue;
                --getTask3.n;
                continue;
            }
            getTask3.hTerm.t = object;
        }
        return getTask.hTerm.t;
    }

    protected static void getSubstsLoop(Map<String, Term> map, Map<term_t, Variable> map2, Term[] termArray) {
        GetSubstsTask getSubstsTask;
        GetSubstsTask getSubstsTask2 = getSubstsTask = termArray.length > 0 ? new GetSubstsTask(0, termArray, null) : null;
        block5: while (getSubstsTask != null) {
            GetSubstsTask getSubstsTask3 = getSubstsTask;
            Term term = getSubstsTask3.args[getSubstsTask3.n];
            if (getSubstsTask3.n + 1 < getSubstsTask3.args.length) {
                ++getSubstsTask3.n;
            } else {
                getSubstsTask = getSubstsTask.prev;
            }
            switch (term.type()) {
                case 1: {
                    Variable variable = (Variable)term;
                    if (!variable.tellThem() || map.get(variable.name) != null) continue block5;
                    map.put(variable.name, Term.getTerm(map2, variable.term_));
                    continue block5;
                }
                case 7: 
                case 10: {
                    if (term.args().length <= 0) continue block5;
                    getSubstsTask = new GetSubstsTask(0, term.args(), getSubstsTask);
                    continue block5;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 44: 
                case 102: {
                    continue block5;
                }
            }
            throw new JPLException("unknown term type=" + term.type());
        }
    }

    public static class GetSubstsTask {
        public int n;
        public Term[] args;
        public GetSubstsTask prev;

        GetSubstsTask(int n, Term[] termArray, GetSubstsTask getSubstsTask) {
            this.n = n;
            this.args = termArray;
            this.prev = getSubstsTask;
        }
    }

    public static class GetTask {
        public int n;
        public TermHolder hTerm;
        public term_t term;
        public int arity;
        public Term value;
        public GetTask prev;

        GetTask(int n, TermHolder termHolder, term_t term_t2) {
            this.n = n;
            this.hTerm = termHolder;
            this.term = term_t2;
            this.arity = 0;
            this.value = null;
            this.prev = null;
        }

        GetTask(int n, TermHolder termHolder, term_t term_t2, int n2, GetTask getTask) {
            this.n = n;
            this.hTerm = termHolder;
            this.term = term_t2;
            this.arity = n2;
            this.value = null;
            this.prev = getTask;
        }
    }

    public static class PutTask {
        public int n;
        public Term t;
        public term_t term;
        public term_t termP;
        public PutTask prev;

        PutTask(int n, Term term, term_t term_t2) {
            this.n = n;
            this.t = term;
            this.term = term_t2;
            this.termP = null;
            this.prev = null;
        }

        PutTask(int n, Term term, term_t term_t2, term_t term_t3, PutTask putTask) {
            this.n = n;
            this.t = term;
            this.term = term_t2;
            this.termP = term_t3;
            this.prev = putTask;
        }
    }
}

