private rule architecture {
	meta:
		bits = 64
		endianness = "little"
		architecture = "x64"
	condition:
		true
}

rule file_0_10_0 {
	meta:
		name = "??0UMSThreadVirtualProcessor@details@Concurrency@@QEAA@PEAVSchedulingNode@12@PEAUIVirtualProcessorRoot@2@@Z"
		size = 95
		refs = "0026 ??0VirtualProcessor@details@Concurrency@@QEAA@XZ 002e ??_7UMSThreadVirtualProcessor@details@Concurrency@@6B@ 0047 ?Initialize@UMSThreadVirtualProcessor@details@Concurrency@@MEAAXPEAVSchedulingNode@23@PEAUIVirtualProcessorRoot@3@@Z"
	strings:
		$1 = { 48 8B C4 48 89 48 08 57 48 83 EC 30 48 C7 40 E8 FE FF FF FF 48 89 58 10 48 89 70 18 49 8B D8 48 8B FA 48 8B F1 E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 89 06 48 83 A6 70 01 00 00 00 4C 8B C3 48 8B D7 48 8B CE E8 ?? ?? ?? ?? 90 48 8B C6 48 8B 5C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_0_12_0 {
	meta:
		name = "??0cancellation_token_source@Concurrency@@QEAA@AEBV01@@Z"
		size = 19
		altNames = "??0cancellation_token@Concurrency@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 8B 02 48 85 C0 74 04 F0 FF 40 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_0_13_0 {
	meta:
		name = "??0location@Concurrency@@QEAA@AEBV01@@Z"
		size = 52
		altNames = "??4location@Concurrency@@QEAAAEAV01@AEBV01@@Z"
	strings:
		$1 = { 8B 02 41 B8 FF FF FF 0F 33 01 41 23 C0 31 01 8B 02 33 01 41 23 C0 33 02 89 01 48 8B 42 08 48 89 41 08 8B 42 04 89 41 04 48 8B 42 10 48 89 41 10 48 8B C1 C3 }
	condition:
		$1
}

rule file_0_15_0 {
	meta:
		name = "??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
		size = 34
		refs = "0013 free"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 19 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_0_17_0 {
	meta:
		name = "??1UMSThreadVirtualProcessor@details@Concurrency@@UEAA@XZ"
		size = 59
		refs = "0009 ??_7UMSThreadVirtualProcessor@details@Concurrency@@6B@ 0022 ??_7UMSSchedulingContext@details@Concurrency@@6B@ 002a ??3@YAXPEAX@Z 0037 ??1VirtualProcessor@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 48 8B 89 70 01 00 00 48 85 C9 74 0F 48 8D 05 ?? ?? ?? ?? 48 89 01 E8 ?? ?? ?? ?? 48 8B CB 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_0_18_0 {
	meta:
		name = "??1cancellation_token_source@Concurrency@@QEAA@XZ"
		size = 29
	strings:
		$1 = { 48 83 EC 28 48 8B 09 48 85 C9 74 0C F0 FF 49 08 75 06 48 8B 01 FF 50 08 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_0_27_0 {
	meta:
		name = "??_EGlobalCore@details@Concurrency@@QEAAPEAXI@Z"
		size = 110
		refs = "0020 ??1GlobalCore@details@Concurrency@@QEAA@XZ 002d ??_M@YAXPEAX_KHP6AX0@Z@Z 003b ??_V@YAXPEAX@Z 0049 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 8B F2 48 8B D9 F6 C2 02 74 2B 48 8D 79 F8 4C 8D 0D ?? ?? ?? ?? BA 30 00 00 00 44 8B 07 E8 ?? ?? ?? ?? 40 F6 C6 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 EB 1A 48 8B 49 28 E8 ?? ?? ?? ?? 40 F6 C6 01 74 08 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_0_28_0 {
	meta:
		name = "??_GUMSSchedulingContext@details@Concurrency@@QEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7UMSSchedulingContext@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_62_635_2 {
	meta:
		name = "??_G?$ISource@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$ISource@W4agent_status@Concurrency@@@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_62_636_2 {
	meta:
		name = "??_G?$ISource@_K@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$ISource@_K@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_62_637_2 {
	meta:
		name = "??_G?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$ITarget@W4agent_status@Concurrency@@@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_62_638_2 {
	meta:
		name = "??_G?$ITarget@_K@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$ITarget@_K@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_392_50_0 {
	meta:
		name = "??_G?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7IThreadProxyFactory@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_392_51_0 {
	meta:
		name = "??_G?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7IThreadProxyFactory@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_57_879_1 {
	meta:
		name = "??_G?$_Func_base@EV?$task@_N@Concurrency@@@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$_Func_base@EV?$task@_N@Concurrency@@@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_39_834_2 {
	meta:
		name = "??_G?$_Func_base@V?$task@_N@Concurrency@@_N@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$_Func_base@V?$task@_N@Concurrency@@_N@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_39_835_2 {
	meta:
		name = "??_G?$_Func_base@X$$$V@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$_Func_base@X$$$V@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_62_643_2 {
	meta:
		name = "??_G?$_Func_base@XAEB_K@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$_Func_base@XAEB_K@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_62_644_2 {
	meta:
		name = "??_G?$_Func_base@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$_Func_base@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_62_645_2 {
	meta:
		name = "??_G?$_Func_base@XPEAV?$message@_K@Concurrency@@@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$_Func_base@XPEAV?$message@_K@Concurrency@@@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_39_836_2 {
	meta:
		name = "??_G?$_Func_base@XV?$task@_N@Concurrency@@@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$_Func_base@XV?$task@_N@Concurrency@@@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_62_646_2 {
	meta:
		name = "??_G?$_Func_base@_NAEBW4agent_status@Concurrency@@@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$_Func_base@_NAEBW4agent_status@Concurrency@@@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_62_647_2 {
	meta:
		name = "??_G?$_Func_impl@U?$_Callable_obj@P6A_NAEBW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NAEBW4agent_status@Concurrency@@@std@@@2@_NAEBW4agent_status@Concurrency@@@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$_Func_base@_NAEBW4agent_status@Concurrency@@@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_620_60_0 {
	meta:
		name = "??_G?$_Ref_count@V__ExceptionPtr@@@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Ref_count_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_620_61_0 {
	meta:
		name = "??_G?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPEAV1@@ZV?$_DebugMallocator@H@@@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Ref_count_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_39_848_2 {
	meta:
		name = "??_G?$_Ref_count_obj@U?$_Task_impl@E@details@Concurrency@@@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Ref_count_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_39_849_2 {
	meta:
		name = "??_G?$_Ref_count_obj@U?$_Task_impl@_N@details@Concurrency@@@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Ref_count_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_39_850_2 {
	meta:
		name = "??_G?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Ref_count_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_49_105_2 {
	meta:
		name = "??_G?$codecvt@DDH@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_2_112_2 {
	meta:
		name = "??_G?$codecvt@GDH@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_9_347_2 {
	meta:
		name = "??_G?$codecvt@_WDH@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_118_667_1 {
	meta:
		name = "??_G?$message@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$message@W4agent_status@Concurrency@@@Concurrency@@6B@ 0019 ?Free@Concurrency@@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_118_668_1 {
	meta:
		name = "??_G?$message@_K@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7?$message@_K@Concurrency@@6B@ 0019 ?Free@Concurrency@@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_0_164_2 {
	meta:
		name = "??_G?$messages@D@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_9_352_2 {
	meta:
		name = "??_G?$messages@G@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_90_404_1 {
	meta:
		name = "??_G?$messages@_W@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_0_165_2 {
	meta:
		name = "??_G?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_9_354_2 {
	meta:
		name = "??_G?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_9_355_2 {
	meta:
		name = "??_G?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_0_166_2 {
	meta:
		name = "??_G?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_90_407_1 {
	meta:
		name = "??_G?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_9_357_2 {
	meta:
		name = "??_G?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_49_107_2 {
	meta:
		name = "??_G?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_9_362_2 {
	meta:
		name = "??_G?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_9_363_2 {
	meta:
		name = "??_G?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_49_108_2 {
	meta:
		name = "??_G?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_90_415_1 {
	meta:
		name = "??_G?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_9_365_2 {
	meta:
		name = "??_G?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1369_133_0 {
	meta:
		name = "??_GCacheLocalScheduleGroup@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7ScheduleGroup@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_360_37_0 {
	meta:
		name = "??_GCancellationTokenRegistration_TaskProc@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_RefCounter@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_832_57_0 {
	meta:
		name = "??_GContext@Concurrency@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7Context@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_163_38_0 {
	meta:
		name = "??_GExecutionResource@details@Concurrency@@QEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7ExecutionResource@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1369_135_0 {
	meta:
		name = "??_GFairScheduleGroup@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7ScheduleGroup@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_392_53_0 {
	meta:
		name = "??_GFreeThreadProxyFactory@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7IThreadProxyFactory@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_392_54_0 {
	meta:
		name = "??_GIThreadProxyFactory@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7IThreadProxyFactory@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1369_137_0 {
	meta:
		name = "??_GRealizedChore@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Chore@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1369_138_0 {
	meta:
		name = "??_GScheduleGroup@Concurrency@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7ScheduleGroup@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1106_85_0 {
	meta:
		name = "??_GScheduleGroupBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7ScheduleGroup@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1369_139_0 {
	meta:
		name = "??_GScheduler@Concurrency@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7Scheduler@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_360_38_0 {
	meta:
		name = "??_G_CancellationTokenRegistration@details@Concurrency@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_RefCounter@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_39_860_2 {
	meta:
		name = "??_G_Chore@details@Concurrency@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Chore@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_39_861_2 {
	meta:
		name = "??_G_ContinuationTaskHandleBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Chore@details@Concurrency@@6B@ 0019 ?Free@Concurrency@@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_85_114_2 {
	meta:
		name = "??_G_Facet_base@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_39_863_2 {
	meta:
		name = "??_G_Future_error_category@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7error_category@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_57_2 {
	meta:
		name = "??_G_Generic_error_category@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7error_category@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_76_39_2 {
	meta:
		name = "??_G_Iostream_error_category@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7error_category@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_39_866_2 {
	meta:
		name = "??_G_RefCounter@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_RefCounter@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_619_78_0 {
	meta:
		name = "??_G_RefCounterBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_RefCounterBase@details@Concurrency@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_57_913_1 {
	meta:
		name = "??_G_Ref_count_base@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Ref_count_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_59_2 {
	meta:
		name = "??_G_System_error_category@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7error_category@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_57_915_1 {
	meta:
		name = "??_G_TaskProcHandle@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Chore@details@Concurrency@@6B@ 0019 ?Free@Concurrency@@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_57_918_1 {
	meta:
		name = "??_G_UnrealizedChore@details@Concurrency@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Chore@details@Concurrency@@6B@ 0019 ?Free@Concurrency@@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_42_138_1 {
	meta:
		name = "??_Gcodecvt_base@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_103_127_1 {
	meta:
		name = "??_Gctype_base@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_69_32_2 {
	meta:
		name = "??_Gerror_category@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7error_category@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_101_54_2 {
	meta:
		name = "??_Gfacet@locale@std@@MEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_29_208_1 {
	meta:
		name = "??_Gmessages_base@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_90_432_1 {
	meta:
		name = "??_Gmoney_base@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_90_434_1 {
	meta:
		name = "??_Gtime_base@std@@UEAAPEAXI@Z"
		size = 38
		refs = "0009 ??_7_Facet_base@std@@6B@ 0019 ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_0_29_0 {
	meta:
		name = "??_GUMSThreadVirtualProcessor@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1UMSThreadVirtualProcessor@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_654_2 {
	meta:
		name = "??_G?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_655_2 {
	meta:
		name = "??_G?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_57_898_1 {
	meta:
		name = "??_G?$_RunAnyParam@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$_RunAnyParam@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_118_660_1 {
	meta:
		name = "??_G?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_118_661_1 {
	meta:
		name = "??_G?$_SyncOriginator@_K@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$_SyncOriginator@_K@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_116_128_1 {
	meta:
		name = "??_G?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_114_127_1 {
	meta:
		name = "??_G?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_120_108_2 {
	meta:
		name = "??_G?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_118_662_1 {
	meta:
		name = "??_G?$call@_KV?$function@$$A6AXAEB_K@Z@std@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$call@_KV?$function@$$A6AXAEB_K@Z@std@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_663_2 {
	meta:
		name = "??_G?$concurrent_queue@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$concurrent_queue@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_664_2 {
	meta:
		name = "??_G?$concurrent_queue@PEAV?$message@_K@Concurrency@@V?$allocator@PEAV?$message@_K@Concurrency@@@std@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$concurrent_queue@PEAV?$message@_K@Concurrency@@V?$allocator@PEAV?$message@_K@Concurrency@@@std@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_669_2 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_670_2 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_671_2 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_672_2 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_673_2 {
	meta:
		name = "??_G?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_118_674_1 {
	meta:
		name = "??_G?$ordered_message_processor@_K@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$ordered_message_processor@_K@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_675_2 {
	meta:
		name = "??_G?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_118_676_1 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_118_677_1 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_678_2 {
	meta:
		name = "??_G?$propagator_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$propagator_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_679_2 {
	meta:
		name = "??_G?$single_assignment@_K@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$single_assignment@_K@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_692_2 {
	meta:
		name = "??_G?$source_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$source_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_693_2 {
	meta:
		name = "??_G?$target_block@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1?$target_block@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1369_134_0 {
	meta:
		name = "??_GCacheLocalScheduleGroupSegment@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1ScheduleGroupSegmentBase@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1236_64_0 {
	meta:
		name = "??_GContextBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1ContextBase@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_391_43_0 {
	meta:
		name = "??_GExternalContextBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1ExternalContextBase@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1369_136_0 {
	meta:
		name = "??_GFairScheduleGroupSegment@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1ScheduleGroupSegmentBase@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_832_58_0 {
	meta:
		name = "??_GInternalContextBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1InternalContextBase@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_326_67_0 {
	meta:
		name = "??_GResourceManager@details@Concurrency@@AEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1ResourceManager@details@Concurrency@@AEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1106_86_0 {
	meta:
		name = "??_GScheduleGroupSegmentBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1ScheduleGroupSegmentBase@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1369_140_0 {
	meta:
		name = "??_GSchedulerBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1SchedulerBase@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1369_141_0 {
	meta:
		name = "??_GSchedulerPolicy@Concurrency@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1SchedulerPolicy@Concurrency@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_163_39_0 {
	meta:
		name = "??_GSchedulerProxy@details@Concurrency@@IEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1SchedulerProxy@details@Concurrency@@IEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1369_142_0 {
	meta:
		name = "??_GSchedulingNode@details@Concurrency@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1SchedulingNode@details@Concurrency@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1369_143_0 {
	meta:
		name = "??_GSchedulingRing@details@Concurrency@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1SchedulingRing@details@Concurrency@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_755_29_0 {
	meta:
		name = "??_GThreadProxy@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1ThreadProxy@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_323_35_0 {
	meta:
		name = "??_GTransmogrifiedPrimary@details@Concurrency@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1TransmogrifiedPrimary@details@Concurrency@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_907_50_0 {
	meta:
		name = "??_GUMSFreeVirtualProcessorRoot@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1UMSFreeVirtualProcessorRoot@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_907_51_0 {
	meta:
		name = "??_GUMSSchedulerProxy@details@Concurrency@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1UMSSchedulerProxy@details@Concurrency@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_688_32_0 {
	meta:
		name = "??_GUMSThreadProxy@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1UMSThreadProxy@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_718_43_0 {
	meta:
		name = "??_GVirtualProcessor@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1VirtualProcessor@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_694_2 {
	meta:
		name = "??_G_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PEAV?$ISource@W4agent_status@Concurrency@@@1@IPEBV?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@std@@@Z@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PEAV?$ISource@W4agent_status@Concurrency@@@1@IPEBV?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@std@@@Z@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_118_695_1 {
	meta:
		name = "??_G_Blocking_recipient@?1???$_Receive_impl@_K@Concurrency@@YA_KPEAV?$ISource@_K@1@IPEBV?$function@$$A6A_NAEB_K@Z@std@@@Z@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1_Blocking_recipient@?1???$_Receive_impl@_K@Concurrency@@YA_KPEAV?$ISource@_K@1@IPEBV?$function@$$A6A_NAEB_K@Z@std@@@Z@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_38_2_2 {
	meta:
		name = "??_G_Condition_variable@details@Concurrency@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1_Condition_variable@details@Concurrency@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_57_908_1 {
	meta:
		name = "??_G_ExceptionHolder@details@Concurrency@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1_ExceptionHolder@details@Concurrency@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_619_76_0 {
	meta:
		name = "??_G_Interruption_exception@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_28_136_1 {
	meta:
		name = "??_G_System_error@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_619_79_0 {
	meta:
		name = "??_G_TaskCollection@details@Concurrency@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1_TaskCollection@details@Concurrency@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_57_917_1 {
	meta:
		name = "??_G_Task_impl_base@details@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1_Task_impl_base@details@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_620_64_0 {
	meta:
		name = "??_G__ExceptionPtr@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1__ExceptionPtr@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_696_2 {
	meta:
		name = "??_Gagent@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1agent@Concurrency@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_17_61_2 {
	meta:
		name = "??_Gbad_function_call@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_62_697_2 {
	meta:
		name = "??_Gbad_target@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_39_874_2 {
	meta:
		name = "??_Gbad_weak_ptr@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_391_44_0 {
	meta:
		name = "??_Gcontext_self_unblock@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_832_60_0 {
	meta:
		name = "??_Gcontext_unblock_unbalanced@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_4_64_1 {
	meta:
		name = "??_Gcritical_section@Concurrency@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1critical_section@Concurrency@@QEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1369_146_0 {
	meta:
		name = "??_Gdefault_scheduler_exists@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_37_24_0 {
	meta:
		name = "??_Gexception_ptr@std@@QEAAPEAXI@Z"
		size = 47
		refs = "0010 ?__ExceptionPtrDestroy@@YAXPEAX@Z 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_66_71_1 {
	meta:
		name = "??_Gfailure@ios_base@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_57_922_1 {
	meta:
		name = "??_Gfuture_error@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1240_59_0 {
	meta:
		name = "??_Gimproper_lock@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_459_102_0 {
	meta:
		name = "??_Gimproper_scheduler_attach@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_459_103_0 {
	meta:
		name = "??_Gimproper_scheduler_detach@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_459_104_0 {
	meta:
		name = "??_Gimproper_scheduler_reference@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_605_35_0 {
	meta:
		name = "??_Ginvalid_argument@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_118_699_1 {
	meta:
		name = "??_Ginvalid_link_target@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_459_106_0 {
	meta:
		name = "??_Ginvalid_multiple_scheduling@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_605_36_0 {
	meta:
		name = "??_Ginvalid_operation@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_771_30_0 {
	meta:
		name = "??_Ginvalid_oversubscribe_operation@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_459_109_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_key@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_459_110_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_thread_specification@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_459_111_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_value@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_87_92_2 {
	meta:
		name = "??_Glength_error@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_76_42_2 {
	meta:
		name = "??_Glock_error@threads@stdext@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1369_151_0 {
	meta:
		name = "??_Glogic_error@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_459_112_0 {
	meta:
		name = "??_Gmessage_not_found@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_360_42_0 {
	meta:
		name = "??_Gmissing_wait@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_459_114_0 {
	meta:
		name = "??_Gnested_scheduler_missing_detach@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_459_115_0 {
	meta:
		name = "??_Goperation_timed_out@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_22_77_1 {
	meta:
		name = "??_Gout_of_range@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_22_78_1 {
	meta:
		name = "??_Goverflow_error@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_87_95_2 {
	meta:
		name = "??_Grange_error@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_17_68_2 {
	meta:
		name = "??_Gregex_error@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_77_52_2 {
	meta:
		name = "??_Gruntime_error@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_26_24_0 {
	meta:
		name = "??_Gscheduler_not_attached@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_392_58_0 {
	meta:
		name = "??_Gscheduler_resource_allocation_error@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_459_118_0 {
	meta:
		name = "??_Gscheduler_worker_creation_error@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_92_127_2 {
	meta:
		name = "??_Gsystem_error@std@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_459_119_0 {
	meta:
		name = "??_Gtask_canceled@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_69_55_1 {
	meta:
		name = "??_Gthread_resource_error@threads@stdext@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_459_120_0 {
	meta:
		name = "??_Gunsupported_os@Concurrency@@UEAAPEAXI@Z"
		size = 47
		refs = "0010 ??1exception@std@@UEAA@XZ 001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_0_30_0 {
	meta:
		name = "??_H@YAXPEAX_KHP6APEAX0@Z@Z"
		size = 67
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 49 8B F1 41 8B D8 48 8B EA 48 8B F9 EB 08 48 8B CF FF D6 48 03 FD FF CB 79 F4 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_0_31_0 {
	meta:
		name = "?Affinitize@UMSThreadVirtualProcessor@details@Concurrency@@MEAAXPEAVInternalContextBase@23@@Z"
		size = 21
		refs = "0005 ?Affinitize@VirtualProcessor@details@Concurrency@@MEAAXPEAVInternalContextBase@23@@Z"
	strings:
		$1 = { 48 85 D2 0F 85 ?? ?? ?? ?? 48 C7 81 B8 00 00 00 00 00 00 00 C3 }
	condition:
		$1
}

rule file_0_32_0 {
	meta:
		name = "?AttemptWake@UMSThreadVirtualProcessor@details@Concurrency@@QEAAXXZ"
		size = 57
		refs = "0018 ?ClaimExclusiveOwnership@VirtualProcessor@details@Concurrency@@QEAA_NAEAVClaimTicket@123@K_N@Z 0030 ?ExerciseClaim@VirtualProcessor@details@Concurrency@@AEAA_NW4AvailabilityType@123@PEAVScheduleGroupSegmentBase@23@PEAVInternalContextBase@23@@Z"
	strings:
		$1 = { 48 83 EC 38 83 64 24 20 00 48 8D 54 24 20 41 B1 01 41 B8 0F 00 00 00 E8 ?? ?? ?? ?? 84 C0 74 14 8B 54 24 20 48 8B 4C 24 28 45 33 C9 45 33 C0 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_0_33_0 {
	meta:
		name = "?CriticalNotify@UMSThreadVirtualProcessor@details@Concurrency@@QEAAXXZ"
		size = 16
		refs = "000c ?AttemptWake@UMSThreadVirtualProcessor@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { B8 01 00 00 00 87 81 68 01 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_0_34_0 {
	meta:
		name = "?Exercise@ClaimTicket@VirtualProcessor@details@Concurrency@@QEAA_NPEAVScheduleGroupSegmentBase@34@@Z"
		size = 35
		refs = "0016 ?ExerciseClaim@VirtualProcessor@details@Concurrency@@AEAA_NW4AvailabilityType@123@PEAVScheduleGroupSegmentBase@23@PEAVInternalContextBase@23@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 4C 8B C2 8B 11 48 8B D9 48 8B 49 08 45 33 C9 E8 ?? ?? ?? ?? 83 23 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_0_35_0 {
	meta:
		name = "?ExerciseWakesExisting@ClaimTicket@VirtualProcessor@details@Concurrency@@QEBA_NXZ"
		size = 19
	strings:
		$1 = { 83 39 02 74 08 83 39 08 74 03 33 C0 C3 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_0_39_0 {
	meta:
		name = "?Initialize@UMSThreadVirtualProcessor@details@Concurrency@@MEAAXPEAVSchedulingNode@23@PEAUIVirtualProcessorRoot@3@@Z"
		size = 151
		refs = "001d ?Initialize@VirtualProcessor@details@Concurrency@@MEAAXPEAVSchedulingNode@23@PEAUIVirtualProcessorRoot@3@@Z 0046 ??_7UMSSchedulingContext@details@Concurrency@@6B@ 004e ??3@YAXPEAX@Z 0058 ??2@YAPEAX_K@Z 0079 ??0UMSSchedulingContext@details@Concurrency@@QEAA@PEAVUMSThreadScheduler@12@PEAVUMSThreadVirtualProcessor@12@@Z"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 48 48 89 74 24 50 48 8B F9 E8 ?? ?? ?? ?? 33 DB 48 89 9F 78 01 00 00 89 9F 68 01 00 00 48 8B 47 78 48 8B 30 48 8B 8F 70 01 00 00 48 85 C9 74 0F 48 8D 05 ?? ?? ?? ?? 48 89 01 E8 ?? ?? ?? ?? B9 28 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 40 48 85 C0 74 1A 48 85 F6 74 04 48 8D 5E F0 4C 8B C7 48 8B D3 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48 89 9F 70 01 00 00 48 8B 5C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_0_41_0 {
	meta:
		name = "?MakeAvailableFromSchedulingContext@UMSThreadVirtualProcessor@details@Concurrency@@QEAAXXZ"
		size = 27
		refs = "0017 ?MakeAvailable@VirtualProcessor@details@Concurrency@@IEAAXW4AvailabilityType@123@_N@Z"
	strings:
		$1 = { 48 8B 81 70 01 00 00 41 B0 01 BA 08 00 00 00 48 89 81 B8 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_0_42_0 {
	meta:
		name = "?PreRunnableSearch@UMSThreadVirtualProcessor@details@Concurrency@@UEAAPEAVInternalContextBase@23@XZ"
		size = 119
		refs = "006c ?MoveCompletionListToRunnables@UMSThreadScheduler@details@Concurrency@@QEAA_NVlocation@3@@Z"
	strings:
		$1 = { 48 83 EC 48 48 8B 41 78 4C 8B C9 33 C9 48 8B 10 48 85 D2 74 04 48 8D 4A F0 8B 54 24 20 45 8B 81 D8 00 00 00 41 BA FF FF FF 0F 41 8B C0 33 C2 41 23 C2 33 D0 41 8B C0 33 C2 48 8D 54 24 20 41 23 C2 41 33 C0 89 44 24 20 49 8B 81 E0 00 00 00 48 89 44 24 28 41 8B 81 DC 00 00 00 89 44 24 24 49 8B 81 E8 00 00 00 48 89 44 24 30 E8 ?? ?? ?? ?? 33 C0 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_0_43_0 {
	meta:
		name = "?StartupWorkerContext@UMSThreadVirtualProcessor@details@Concurrency@@UEAA_NPEAVScheduleGroupSegmentBase@23@PEAVInternalContextBase@23@@Z"
		size = 48
	strings:
		$1 = { 48 83 EC 28 48 89 91 80 01 00 00 4C 8B C9 4C 89 81 B0 00 00 00 48 8B 89 88 00 00 00 49 8B 91 70 01 00 00 48 8B 01 FF 50 28 B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_0_44_0 {
	meta:
		name = "?ToInternalContext@UMSThreadVirtualProcessor@details@Concurrency@@MEAAPEAVInternalContextBase@23@PEAUIExecutionContext@3@@Z"
		size = 17
	strings:
		$1 = { 33 C0 48 3B 91 70 01 00 00 48 0F 44 D0 48 8B C2 C3 }
	condition:
		$1
}

rule file_0_46_0 {
	meta:
		name = "?_Assign@location@Concurrency@@QEAAXAEBV12@@Z"
		size = 49
	strings:
		$1 = { 8B 02 41 B8 FF FF FF 0F 33 01 41 23 C0 31 01 8B 02 33 01 41 23 C0 33 02 89 01 48 8B 42 08 48 89 41 08 8B 42 04 89 41 04 48 8B 42 10 48 89 41 10 C3 }
	condition:
		$1
}

rule file_0_47_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_84facb30090f515e7b1bbafb4c9a7a16>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_84facb30090f515e7b1bbafb4c9a7a16>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_1174_24_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_877e36a9b8f2beec69b03ec0697600b5>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_877e36a9b8f2beec69b03ec0697600b5>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_1353_65_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_3fdf5a3bf3c558fb7d020342b3e3ecc4>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_3fdf5a3bf3c558fb7d020342b3e3ecc4>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_1342_38_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_2835475992419787e20c95841abbc371>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_2835475992419787e20c95841abbc371>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_1298_44_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_26da27b0aac018e5d14f38d73214e9c2>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_26da27b0aac018e5d14f38d73214e9c2>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_1249_54_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_227f2a6d2f0fd793a6959dc5f99010cf>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_227f2a6d2f0fd793a6959dc5f99010cf>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_1248_68_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_7c3f04af9f99d98b77477e35fe019769>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_7c3f04af9f99d98b77477e35fe019769>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_1236_228_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_b983c5cc1c0237b64124564f0b2924e5>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_b983c5cc1c0237b64124564f0b2924e5>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_1218_58_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_de335a338d31a18b265829348f9c173a>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_de335a338d31a18b265829348f9c173a>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_1186_39_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_22a3e8643a03ea7327c3b0e02a63c323>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_22a3e8643a03ea7327c3b0e02a63c323>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_1369_443_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_6a4a14dee8e1b31efd89026e5270571c>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_6a4a14dee8e1b31efd89026e5270571c>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_1106_196_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_d70fd5481fe106e846cf3419378f032d>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_d70fd5481fe106e846cf3419378f032d>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_1095_58_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_210e261af42dd89513ab9b87d35dcdae>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_210e261af42dd89513ab9b87d35dcdae>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_918_31_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_36f990409ada6d03288478c172d2c439>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_36f990409ada6d03288478c172d2c439>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_910_42_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_26a068338f0cda3166f22367ebccaf09>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_26a068338f0cda3166f22367ebccaf09>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_907_118_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_cdfc667e9119b7a203a9991a55b8dd61>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_cdfc667e9119b7a203a9991a55b8dd61>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_832_164_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_491a9a05af435afb7f83e67bc1a93029>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_491a9a05af435afb7f83e67bc1a93029>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_799_43_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_e08ea6f40b15185036d0953e08feec00>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_e08ea6f40b15185036d0953e08feec00>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_118_715_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_a0f18cf06b229bd63c2fac3645485d8c>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_a0f18cf06b229bd63c2fac3645485d8c>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_122_65_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_9019455767b65677490b1d7ba55f2ec7>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9019455767b65677490b1d7ba55f2ec7>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_118_61_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_9d91f4c20d4b84890709d629e3eda655>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9d91f4c20d4b84890709d629e3eda655>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_115_23_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_8ee961418814d5bf472957f658b2a085>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_8ee961418814d5bf472957f658b2a085>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_87_105_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_9382d68b9a24ce66c7928ba5a7172089>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9382d68b9a24ce66c7928ba5a7172089>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_62_715_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_a0f18cf06b229bd63c2fac3645485d8c>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_a0f18cf06b229bd63c2fac3645485d8c>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_41_62_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_0aa3eeb7fc6a1a7ab2bd619ed42cef02>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_0aa3eeb7fc6a1a7ab2bd619ed42cef02>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_39_909_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_4b4f7bbdf60ea0fcc31469056233f33d>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_4b4f7bbdf60ea0fcc31469056233f33d>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_29_30_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_789e7dbf30254e9f4e5c9f04cb8ae4bf>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_789e7dbf30254e9f4e5c9f04cb8ae4bf>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_792_44_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_4f309ec3f1591cc309f87a3a1238f559>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_4f309ec3f1591cc309f87a3a1238f559>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_91_61_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_9d91f4c20d4b84890709d629e3eda655>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9d91f4c20d4b84890709d629e3eda655>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_81_23_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_8ee961418814d5bf472957f658b2a085>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_8ee961418814d5bf472957f658b2a085>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_75_117_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_9382d68b9a24ce66c7928ba5a7172089>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9382d68b9a24ce66c7928ba5a7172089>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_57_959_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_4b4f7bbdf60ea0fcc31469056233f33d>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_4b4f7bbdf60ea0fcc31469056233f33d>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_20_77_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_9019455767b65677490b1d7ba55f2ec7>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9019455767b65677490b1d7ba55f2ec7>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_5_30_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_789e7dbf30254e9f4e5c9f04cb8ae4bf>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_789e7dbf30254e9f4e5c9f04cb8ae4bf>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_4_74_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_0aa3eeb7fc6a1a7ab2bd619ed42cef02>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_0aa3eeb7fc6a1a7ab2bd619ed42cef02>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_149_39_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_464601bb309619f9e38e1053581c8b2f>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_464601bb309619f9e38e1053581c8b2f>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_360_63_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_65768df68addf95c6fb1a2e153ca26af>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_65768df68addf95c6fb1a2e153ca26af>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_326_231_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_715586d55be594d0e9637c8c1c3755ee>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_715586d55be594d0e9637c8c1c3755ee>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_323_63_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_349d5681a8333e5bd10da4776df83714>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_349d5681a8333e5bd10da4776df83714>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_284_49_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_8df48103692e73c34f0dca9919093edb>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_8df48103692e73c34f0dca9919093edb>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_260_45_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_d9d7bd5f35fe0d976683ca071d74f79e>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_d9d7bd5f35fe0d976683ca071d74f79e>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_199_39_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_172be19dea7500ca6c398fe3625e7d6f>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_172be19dea7500ca6c398fe3625e7d6f>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_184_72_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_21ed68d291bc97f6ce40664916d565c4>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_21ed68d291bc97f6ce40664916d565c4>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_163_122_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_1e66f546d77ed469181b8bd5fdb0dcbc>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_1e66f546d77ed469181b8bd5fdb0dcbc>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_391_81_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_5a630fb471fdfbbc6a947cc3c61ce21b>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_5a630fb471fdfbbc6a947cc3c61ce21b>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_96_29_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_6e36059cbffeaeca4a48396da8c676a3>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_6e36059cbffeaeca4a48396da8c676a3>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_87_55_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_31a06f7a109cabeff6d2606ba0fb4709>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_31a06f7a109cabeff6d2606ba0fb4709>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_37_27_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_b27592a6f7dba7f6725788fb5a9e6656>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_b27592a6f7dba7f6725788fb5a9e6656>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_34_96_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_e295ff122d0cb08069f1941b9918174e>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_e295ff122d0cb08069f1941b9918174e>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_26_39_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_069e32e6c00f5d305ada4a80e39380a3>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_069e32e6c00f5d305ada4a80e39380a3>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_25_30_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_037bc7ce6502ec890500c5533fbc3dfc>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_037bc7ce6502ec890500c5533fbc3dfc>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_18_73_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_c80257f86a38a015eb1e9cb0825778f2>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_c80257f86a38a015eb1e9cb0825778f2>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_605_55_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_9feb76b72e25345552edb63bc7288f00>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9feb76b72e25345552edb63bc7288f00>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_771_60_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_9474bfb0de79727fb4f6d2a6e115fd83>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9474bfb0de79727fb4f6d2a6e115fd83>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_755_42_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_618abf99f167c7a97575a06b06227e91>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_618abf99f167c7a97575a06b06227e91>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_718_119_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_81be46b36946dea1582ccc149adc898b>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_81be46b36946dea1582ccc149adc898b>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_705_47_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_9fce432520bfa06a9827a71bd2f8eca3>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9fce432520bfa06a9827a71bd2f8eca3>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_688_69_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_a82b98f7e2c6043eed4851637b7cc3e6>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_a82b98f7e2c6043eed4851637b7cc3e6>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_660_35_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_492bc47d8aa9efc8d9d8aa9c5b0056e7>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_492bc47d8aa9efc8d9d8aa9c5b0056e7>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_630_34_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_86065f47d7bd75fa202583640c2daf5c>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_86065f47d7bd75fa202583640c2daf5c>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_619_136_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_a089b1c204f74f21f85c3e9ff2c574c1>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_a089b1c204f74f21f85c3e9ff2c574c1>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_3_23_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_294bcb8bc95793505f0ce7948783cc2d>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_294bcb8bc95793505f0ce7948783cc2d>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_604_157_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_d4b5ea99cdfdbe00970f3567e0471f71>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_d4b5ea99cdfdbe00970f3567e0471f71>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_559_87_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_d706c475399fb4da4ce69251d1ecf59e>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_d706c475399fb4da4ce69251d1ecf59e>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_459_123_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_641203ede6f833c1db99207d0b358097>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_641203ede6f833c1db99207d0b358097>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_447_36_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_af546d3a72174e50889cf57d5b8ef1a7>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_af546d3a72174e50889cf57d5b8ef1a7>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_441_45_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_20f446c26f46874b82540befc88a529a>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_20f446c26f46874b82540befc88a529a>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_427_60_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_cb8f2bcadd1f7763372fe4e4aa50437f>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_cb8f2bcadd1f7763372fe4e4aa50437f>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_392_126_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 176
		refs = "0037 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0069 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 007a ??$for_each@V<lambda_df5da3f88215411accbf3d551e9f2f37>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_df5da3f88215411accbf3d551e9f2f37>@@@Z 008a ?set@event@Concurrency@@QEAAXXZ 0099 free"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 10 48 8B F9 B9 01 00 00 00 33 C0 F0 0F B1 4F 10 75 7D 0F 57 C0 F3 0F 7F 44 24 28 48 8D 57 60 49 8D 4B C0 E8 ?? ?? ?? ?? 48 8B 9F 98 00 00 00 48 89 5C 24 28 48 83 A7 98 00 00 00 00 48 8B 87 A0 00 00 00 48 89 44 24 30 48 83 A7 A0 00 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8A 94 24 80 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? C7 47 10 02 00 00 00 48 8D 4F 18 E8 ?? ?? ?? ?? 90 EB 0C 48 8B CB 48 8B 5B 08 E8 ?? ?? ?? ?? 48 85 DB 75 EF 48 8B 9C 24 88 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_0_49_0 {
	meta:
		name = "?_Invoke@_CancellationTokenRegistration@details@Concurrency@@AEAAXXZ"
		size = 90
		refs = "000e ?GetCurrentThreadId@platform@details@Concurrency@@YAJXZ 003c ?set@event@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 8B F8 33 C0 F0 0F B1 7B 10 75 23 48 8B 13 48 8B CB FF 52 10 B9 03 00 00 00 8B C7 F0 0F B1 4B 10 83 F8 02 75 09 48 8B 4B 18 E8 ?? ?? ?? ?? F0 FF 4B 08 75 09 48 8B 03 48 8B CB FF 50 08 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_0_51_0 {
	meta:
		name = "?_Release@_RefCounter@details@Concurrency@@QEAAJXZ"
		size = 32
		altNames = "?_Release@_RefCounterBase@details@Concurrency@@QEAAJXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 83 CB FF F0 0F C1 59 08 FF CB 75 06 48 8B 11 FF 52 08 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_0_54_0 {
	meta:
		name = "?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z"
		size = 29
	strings:
		$1 = { 48 8B 01 4C 8B 02 48 89 02 4C 89 01 48 8B 41 08 4C 8B 42 08 48 89 42 08 4C 89 41 08 C3 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "_getbuf"
		size = 83
		refs = "0008 _cflush 0015 _malloc_crt"
	strings:
		$1 = { 40 53 48 83 EC 20 FF 05 ?? ?? ?? ?? 48 8B D9 B9 00 10 00 00 E8 ?? ?? ?? ?? 48 89 43 10 48 85 C0 74 0D 83 4B 18 08 C7 43 24 00 10 00 00 EB 13 83 4B 18 04 48 8D 43 20 C7 43 24 02 00 00 00 48 89 43 10 48 8B 43 10 83 63 08 00 48 89 03 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "sinf"
		size = 1734
		refs = "0006 __use_fma3_lib 0088 L_one_sixth 00bc __Lsinfarray 012c L_large_x_sse2 013e L_twobypi 014a L_one_half 0161 L_piby2_1 016d L_piby2_1tail 0191 L_piby2_2 019e L_piby2_2tail 0224 L_one 0275 __remainder_piby2d2f_forC 02f4 __Lcosfarray 0371 _sinf_special 0387 L_inf_mask_32 03a8 L_piby4 03b5 L_mask_3f8 03be L_mask_3f2 0438 L_large_x_fma3 0442 L_sign_mask 0464 L_int_three 04a3 __L_2_by_pi_bits 05f2 L_piby2_lead 068a L_int_two 069f L_signbit"
	strings:
		$1 = { 48 83 EC 58 83 3D ?? ?? ?? ?? 00 0F 85 6F 03 00 00 66 0F 57 D2 66 0F 7E C2 B8 00 00 80 7F 44 8B D0 44 23 D2 44 3B D0 0F 84 43 03 00 00 F3 0F 5A C0 66 48 0F 7E C2 4C 8B D2 49 0F BA F2 3F 41 B8 01 00 00 00 48 B8 18 2D 44 54 FB 21 E9 3F 4C 3B D0 0F 8F B9 00 00 00 48 B8 00 00 00 00 00 00 80 3F 4C 3B D0 7D 4A 48 B8 00 00 00 00 00 00 20 3F 4C 3B D0 7D 0B E9 EC 02 00 00 66 0F 1F 44 00 00 F2 0F 10 D0 F2 0F 10 25 ?? ?? ?? ?? F2 0F 59 D2 F2 0F 59 D0 F2 0F 59 D4 F2 0F 5C C2 E9 C5 02 00 00 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 F2 0F 10 D0 F2 0F 59 D0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 10 E2 F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 E2 F2 0F 10 D8 F2 0F 59 EA F2 0F 59 DA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CC F2 0F 58 2D ?? ?? ?? ?? F2 0F 58 CD F2 0F 59 CB F2 0F 58 C1 E9 61 02 00 00 66 66 66 0F 1F 84 00 00 00 00 00 49 3B D2 41 BB 00 00 00 00 74 0E 41 BB 01 00 00 00 F2 0F 5C D0 F2 0F 10 C2 4C 3B 15 ?? ?? ?? ?? 0F 83 2A 01 00 00 F2 0F 10 D0 F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 E0 F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 D3 4D 8B CA 49 C1 E9 34 F2 0F 58 D5 F2 0F 10 1D ?? ?? ?? ?? 66 0F E6 C2 F2 0F 10 0D ?? ?? ?? ?? F3 0F E6 D0 F2 0F 59 DA F2 0F 5C E3 F2 0F 59 CA 66 0F 7E C0 F2 0F 10 C4 F2 0F 5C C1 F2 0F 10 1D ?? ?? ?? ?? 66 48 0F 7E C1 F2 0F 10 2D ?? ?? ?? ?? 48 D1 E1 48 C1 E9 35 4C 2B C9 49 83 F9 0F 7E 28 F2 0F 10 CC F2 0F 59 DA F2 0F 59 EA F2 0F 5C E3 F2 0F 5C CC F2 0F 5C CB F2 0F 5C E9 F2 0F 10 C4 F2 0F 10 CD F2 0F 5C C5 48 81 F9 F2 03 00 00 0F 8D A7 00 00 00 48 81 F9 DE 03 00 00 7E 50 F2 0F 10 D0 F2 0F 59 D0 44 23 C0 75 23 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 59 DA F2 0F 5C C3 E9 2E 01 00 00 66 66 0F 1F 84 00 00 00 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? F2 0F 5C C2 E9 0B 01 00 00 0F 1F 80 00 00 00 00 44 23 C0 0F 84 FB 00 00 00 F2 0F 10 05 ?? ?? ?? ?? E9 EE 00 00 00 66 66 0F 1F 84 00 00 00 00 00 4C 89 5C 24 10 48 8D 54 24 28 4C 8D 44 24 20 66 48 0F 7E C1 E8 ?? ?? ?? ?? 4C 8B 5C 24 10 41 B8 01 00 00 00 F2 0F 10 4C 24 28 8B 44 24 20 F2 0F 10 D0 F2 0F 59 D0 44 23 C0 75 55 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 10 E2 F2 0F 59 E2 F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 EA F2 0F 10 D8 F2 0F 59 DA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CC F2 0F 58 2D ?? ?? ?? ?? F2 0F 58 CD F2 0F 59 CB F2 0F 58 C1 EB 5F 66 66 66 0F 1F 84 00 00 00 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 E2 F2 0F 59 CA F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 E2 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 DA F2 0F 59 C2 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 CB F2 0F 59 CC F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 C1 D1 E8 8B C8 41 23 C3 F7 D1 41 F7 D3 41 23 CB 0B C1 83 E0 01 75 0C F2 0F 10 D0 66 0F 57 C0 F2 0F 5C C2 F2 0F 5A C0 48 83 C4 58 C3 90 E8 ?? ?? ?? ?? 48 83 C4 58 C3 66 0F 1F 44 00 00 C5 F9 7E C0 44 8B 05 ?? ?? ?? ?? 41 23 C0 41 3B C0 0F 84 25 03 00 00 C5 FA 5A E8 C4 C1 F9 7E E9 49 0F BA F1 3F 4C 3B 0D ?? ?? ?? ?? 0F 8F 7E 00 00 00 4C 3B 0D ?? ?? ?? ?? 7D 35 4C 3B 0D ?? ?? ?? ?? 7D 0C 48 83 C4 58 C3 0F 1F 80 00 00 00 00 C5 D3 59 CD C5 F3 59 C5 C4 E2 D1 9D 05 ?? ?? ?? ?? E9 CD 02 00 00 66 66 0F 1F 84 00 00 00 00 00 C5 F9 28 C5 C5 FB 10 0D ?? ?? ?? ?? C5 FB 59 D8 C4 E2 E1 B9 0D ?? ?? ?? ?? C4 E2 E1 A9 0D ?? ?? ?? ?? C4 E2 E1 A9 0D ?? ?? ?? ?? C5 FB 59 DB C4 E2 F1 B9 C3 E9 8A 02 00 00 0F 1F 80 00 00 00 00 C4 C1 F9 6E C1 4C 3B 0D ?? ?? ?? ?? 7D 62 C5 F9 54 0D ?? ?? ?? ?? C5 F9 28 15 ?? ?? ?? ?? C4 E2 F1 A9 15 ?? ?? ?? ?? C5 F9 E6 D2 C4 E2 79 25 CA C5 F1 54 25 ?? ?? ?? ?? C5 F0 C6 C9 08 C5 FA E6 C9 C5 F9 6F D0 C4 E2 F1 BD 15 ?? ?? ?? ?? C5 F3 59 1D ?? ?? ?? ?? C5 EB 5C C3 C5 EB 5C D0 C5 EB 5C CB E9 5F 01 00 00 66 0F 1F 84 00 00 00 00 00 4C 8D 0D ?? ?? ?? ?? C4 C1 F9 7E C3 49 8B CB 49 C1 EB 34 49 81 EB FF 03 00 00 4D 8B D3 49 C1 EA 03 49 81 EA 86 00 00 00 49 F7 DA 4B 8B 04 0A 48 C1 E1 0C 48 C1 E9 0C 48 0F BA E9 34 49 83 C2 08 C4 81 7A 6F 04 0A 48 F7 E1 4C 8B C0 4C 8B D2 C4 E1 F9 7E C0 48 F7 E1 49 83 E3 07 66 0F 73 D8 08 49 03 C2 48 83 D2 00 4C 8B C8 4C 8B D2 C4 E1 F9 7E C0 48 F7 E1 4C 03 D0 48 C7 C1 36 00 00 00 49 8B C2 49 2B CB 48 33 D2 48 D3 E8 73 13 49 F7 D2 49 F7 D1 49 F7 D0 48 BA 00 00 00 00 00 00 00 80 48 83 D0 00 48 83 E0 03 C5 F9 6E E0 49 8B CB 48 83 C1 0A 49 D3 E2 49 D3 EA 48 83 E9 40 4C 8B D9 49 0F BD CA 75 15 4D 8B D1 4D 8B C8 49 C7 C0 00 00 00 00 49 0F BD CA 49 83 EB 40 4C 03 D9 48 83 E9 34 48 83 F9 00 7C 28 74 46 4D 8B C2 49 D3 EA 49 D3 E9 48 83 E9 40 48 F7 D9 49 D3 E0 4D 0B C8 EB 2E 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 48 F7 D9 49 8B C1 49 D3 E2 49 D3 E1 48 83 E9 40 48 F7 D9 48 D3 E8 4C 0B D0 49 D3 E8 4D 0B C8 90 49 81 C3 FF 03 00 00 49 0F BA F2 34 49 8B CB 4C 0B D2 48 C1 E1 34 4C 0B D1 C4 C1 F9 6E C2 C5 FB 59 05 ?? ?? ?? ?? C4 E1 F9 7E E0 48 83 E0 01 48 83 F8 01 74 3B C5 FB 10 0D ?? ?? ?? ?? C5 FB 59 D8 C4 E2 E1 B9 0D ?? ?? ?? ?? C4 E2 E1 A9 0D ?? ?? ?? ?? C4 E2 E1 A9 0D ?? ?? ?? ?? C5 FB 59 DB C4 E2 F1 B9 C3 EB 4E 66 0F 1F 84 00 00 00 00 00 C5 F9 28 15 ?? ?? ?? ?? C5 FB 59 D8 C4 E2 E1 B9 15 ?? ?? ?? ?? C5 FB 10 0D ?? ?? ?? ?? C4 E2 E1 B9 0D ?? ?? ?? ?? C4 E2 E1 A9 0D ?? ?? ?? ?? C4 E2 E1 A9 0D ?? ?? ?? ?? C5 E3 59 DB C5 F9 6F C2 C4 E2 F1 B9 C3 C4 E2 59 29 15 ?? ?? ?? ?? C4 E2 59 29 1D ?? ?? ?? ?? C5 E9 56 DB C5 E1 55 1D ?? ?? ?? ?? C5 F9 57 C3 C5 D1 55 0D ?? ?? ?? ?? C5 F1 57 C0 C5 FB 5A C0 48 83 C4 58 C3 E8 ?? ?? ?? ?? 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "_fdclass"
		size = 25
		refs = "0010 _fdtest"
	strings:
		$1 = { F3 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_4_1_0 {
	meta:
		name = "_fdpcomp"
		size = 97
		refs = "0017 _fdtest"
	strings:
		$1 = { F3 0F 11 4C 24 10 F3 0F 11 44 24 08 53 48 83 EC 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? BB 02 00 00 00 66 3B C3 74 34 48 8D 4C 24 38 E8 ?? ?? ?? ?? 66 3B C3 74 25 F3 0F 10 44 24 38 F3 0F 10 4C 24 30 0F 2F C1 76 05 8D 43 FF EB 11 B8 04 00 00 00 0F 2F C8 0F 47 D8 8B C3 EB 02 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_4_2_0 {
	meta:
		name = "_fdsign"
		size = 19
	strings:
		$1 = { F3 0F 11 44 24 08 8B 44 24 08 C1 E8 10 25 00 80 00 00 C3 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "_dclass"
		size = 25
		refs = "0010 _dtest"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1313_0_0 {
	meta:
		name = "_ldclass"
		size = 25
		refs = "0010 _ldtest"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_5_1_0 {
	meta:
		name = "_dpcomp"
		size = 99
		refs = "0017 _dtest"
	strings:
		$1 = { F2 0F 11 4C 24 10 F2 0F 11 44 24 08 53 48 83 EC 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? BB 02 00 00 00 66 3B C3 74 36 48 8D 4C 24 38 E8 ?? ?? ?? ?? 66 3B C3 74 27 F2 0F 10 44 24 38 F2 0F 10 4C 24 30 66 0F 2F C1 76 05 8D 43 FF EB 12 B8 04 00 00 00 66 0F 2F C8 0F 47 D8 8B C3 EB 02 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1313_1_0 {
	meta:
		name = "_ldpcomp"
		size = 99
		refs = "0017 _ldtest"
	strings:
		$1 = { F2 0F 11 4C 24 10 F2 0F 11 44 24 08 53 48 83 EC 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? BB 02 00 00 00 66 3B C3 74 36 48 8D 4C 24 38 E8 ?? ?? ?? ?? 66 3B C3 74 27 F2 0F 10 44 24 38 F2 0F 10 4C 24 30 66 0F 2F C1 76 05 8D 43 FF EB 12 B8 04 00 00 00 66 0F 2F C8 0F 47 D8 8B C3 EB 02 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_5_2_0 {
	meta:
		name = "_dsign"
		size = 21
		altNames = "_ldsign"
	strings:
		$1 = { F2 0F 11 44 24 08 48 8B 44 24 08 48 C1 E8 30 25 00 80 00 00 C3 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "_invoke_watson_if_error"
		size = 49
		refs = "002c _invoke_watson"
	strings:
		$1 = { 85 C9 75 01 C3 53 48 83 EC 30 48 8B 44 24 68 4D 8B D1 44 8B 4C 24 60 4D 8B D8 48 8B DA 4D 8B C2 49 8B D3 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_6_1_0 {
	meta:
		name = "_wfindfirst32"
		size = 325
		refs = "0015 __security_cookie 002f _errno 003a _invalid_parameter_noinfo 004e __security_check_cookie 0081 __imp_FindFirstFileExW 0090 __imp_GetLastError 00e9 __timet_from_ft 0120 wcscpy_s 0140 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 18 48 89 74 24 20 57 48 81 EC 90 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 80 02 00 00 33 F6 48 8B DA 48 85 D2 75 39 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF 48 8B 8C 24 80 02 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 90 02 00 00 49 8B 5B 20 49 8B 73 28 49 8B E3 5F C3 48 85 C9 74 C2 4C 8D 44 24 30 45 33 C9 33 D2 89 74 24 28 48 89 74 24 20 FF 15 ?? ?? ?? ?? 48 8B F8 48 83 F8 FF 75 47 FF 15 ?? ?? ?? ?? 83 F8 02 72 0F 83 F8 03 76 27 83 F8 08 74 12 83 F8 12 74 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 89 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E9 79 FF FF FF E8 ?? ?? ?? ?? C7 00 02 00 00 00 E9 69 FF FF FF 8B 44 24 30 48 8D 4C 24 34 3D 80 00 00 00 0F 44 C6 89 03 E8 ?? ?? ?? ?? 48 8D 4C 24 3C 89 43 04 E8 ?? ?? ?? ?? 48 8D 4C 24 44 89 43 08 E8 ?? ?? ?? ?? 48 8D 4B 14 89 43 0C 8B 44 24 50 4C 8D 44 24 5C BA 04 01 00 00 89 43 10 E8 ?? ?? ?? ?? 85 C0 75 08 48 8B C7 E9 12 FF FF FF 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_6_2_0 {
	meta:
		name = "_wfindnext32"
		size = 287
		refs = "0010 __security_cookie 0029 _errno 0034 _invalid_parameter_noinfo 0047 __security_check_cookie 006a __imp_FindNextFileW 0074 __imp_GetLastError 00c7 __timet_from_ft 00fe wcscpy_s 011a _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 18 56 48 81 EC 90 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 80 02 00 00 48 8B DA 48 83 F9 FF 75 34 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 8B 8C 24 80 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 B0 02 00 00 48 81 C4 90 02 00 00 5E C3 33 F6 48 85 D2 74 C5 48 8D 54 24 30 FF 15 ?? ?? ?? ?? 85 C0 75 41 FF 15 ?? ?? ?? ?? 83 F8 02 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 9F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 92 E8 ?? ?? ?? ?? C7 00 02 00 00 00 EB 85 8B 44 24 30 48 8D 4C 24 34 3D 80 00 00 00 0F 44 C6 89 03 E8 ?? ?? ?? ?? 48 8D 4C 24 3C 89 43 04 E8 ?? ?? ?? ?? 48 8D 4C 24 44 89 43 08 E8 ?? ?? ?? ?? 48 8D 4B 14 89 43 0C 8B 44 24 50 4C 8D 44 24 5C BA 04 01 00 00 89 43 10 E8 ?? ?? ?? ?? 85 C0 0F 84 31 FF FF FF 45 33 C9 45 33 C0 33 D2 33 C9 48 89 74 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "truncf"
		size = 33
		refs = "0012 _fd_int"
	strings:
		$1 = { F3 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 33 D2 E8 ?? ?? ?? ?? F3 0F 10 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z"
		size = 168
		refs = "0017 _getptd 0037 __ptlocinfo 0045 __globallocalestatus 004c __updatetlocinfo 0056 __ptmbcinfo 0073 __updatetmbcinfo"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 C6 41 18 00 48 85 D2 0F 85 82 00 00 00 E8 ?? ?? ?? ?? 48 89 43 10 48 8B 90 C0 00 00 00 48 89 13 48 8B 88 B8 00 00 00 48 89 4B 08 48 3B 15 ?? ?? ?? ?? 74 16 8B 80 C8 00 00 00 85 05 ?? ?? ?? ?? 75 08 E8 ?? ?? ?? ?? 48 89 03 48 8B 05 ?? ?? ?? ?? 48 39 43 08 74 1B 48 8B 43 10 8B 88 C8 00 00 00 85 0D ?? ?? ?? ?? 75 09 E8 ?? ?? ?? ?? 48 89 43 08 48 8B 4B 10 8B 81 C8 00 00 00 A8 02 75 16 83 C8 02 89 81 C8 00 00 00 C6 43 18 01 EB 07 0F 10 02 F3 0F 7F 01 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_9_1_0 {
	meta:
		name = "??1_LocaleUpdate@@QEAA@XZ"
		size = 18
	strings:
		$1 = { 80 79 18 00 74 0B 48 8B 41 10 83 A0 C8 00 00 00 FD C3 }
	condition:
		$1
}

rule file_9_4_0 {
	meta:
		name = "_ismbcupper_l"
		size = 182
		refs = "0019 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0064 __crtGetStringTypeA"
	strings:
		$1 = { 48 89 5C 24 10 48 89 7C 24 20 55 48 8B EC 48 83 EC 60 8B D9 48 8D 4D E0 E8 ?? ?? ?? ?? 33 FF 81 FB FF 00 00 00 76 54 8B C3 89 7D 20 88 5D 11 C1 E8 08 88 45 10 48 8B 45 E8 39 78 08 74 39 8B 40 04 8D 5F 01 44 8D 4F 02 89 5C 24 30 89 44 24 28 48 8D 45 20 4C 8D 45 10 48 8D 4D E0 8B D3 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 74 0B 66 39 7D 22 75 05 84 5D 20 75 1A 8B DF EB 16 48 8B 45 E8 8D 4B 01 BB 01 00 00 00 0F B6 54 01 18 C1 EA 04 23 DA 40 38 7D F8 74 0B 48 8B 4D F0 83 A1 C8 00 00 00 FD 4C 8D 5C 24 60 8B C3 49 8B 5B 18 49 8B 7B 28 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "atanf"
		size = 573
		refs = "001d __xmm@80000000000000008000000000000000 0072 __real@3fddac670561bb4f 0080 __real@4000000000000000 0088 __real@3ff0000000000000 00b3 __real@3fe921fb54442d18 00ec __real@3fef730bd281f69b 00f7 __real@3ff8000000000000 0145 ??_C@_05HDLDHOMB@atanf?$AA@ 016c _handle_errorf 0179 __real@43d3200000000000 0183 ?piby2@?1??atanf@@9@9 01a5 _set_statfp 01b5 __real@bff0000000000000 01bd __real@3ff921fb54442d18 01dc __real@3f73476a758da22a 01e4 __real@3fd327e3df2cf2aa 01f0 __real@3fc89e173a81ee7f 01f8 __real@3ff1c58793da6ea4 0208 __real@3fd2fa5316907834 0210 __real@3fec777ca21053f0"
	strings:
		$1 = { 48 83 EC 68 48 BA FF FF FF FF FF FF FF 7F 0F 57 E4 0F 28 C8 0F 29 74 24 50 F2 0F 10 35 ?? ?? ?? ?? F3 0F 5A E1 F2 0F 11 64 24 78 48 8B 4C 24 78 48 8B C1 48 23 C2 48 BA 00 00 00 00 00 00 00 80 48 23 CA 74 03 0F 57 E6 48 BA 00 00 00 00 00 00 DC 3F 48 3B C2 73 08 0F 57 ED E9 69 01 00 00 48 BA 00 00 00 00 00 00 E6 3F 48 3B C2 73 32 F2 0F 10 2D ?? ?? ?? ?? 0F 28 D4 0F 28 C4 F2 0F 59 15 ?? ?? ?? ?? F2 0F 5C 15 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? 0F 28 E2 F2 0F 5E E0 E9 28 01 00 00 48 BA 00 00 00 00 00 00 F3 3F 48 3B C2 73 2A F2 0F 10 2D ?? ?? ?? ?? 0F 28 D4 0F 28 CC F2 0F 5C 15 ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? 0F 28 E2 F2 0F 5E E1 E9 EF 00 00 00 48 BA 00 00 00 00 00 80 03 40 48 3B C2 73 32 F2 0F 10 2D ?? ?? ?? ?? 0F 28 D4 F2 0F 59 25 ?? ?? ?? ?? F2 0F 5C 15 ?? ?? ?? ?? 0F 28 CC F2 0F 58 0D ?? ?? ?? ?? 0F 28 E2 F2 0F 5E E1 E9 AE 00 00 00 48 BA 00 00 00 00 00 00 F0 7F 48 3B C2 76 4C 41 B9 01 00 00 00 F3 0F 11 4C 24 70 0F 57 C0 44 8B 44 24 70 44 89 4C 24 40 48 8D 0D ?? ?? ?? ?? F3 0F 11 44 24 38 F3 0F 11 4C 24 30 41 8D 51 0E 49 0F BA E8 16 C7 44 24 28 21 00 00 00 83 64 24 20 00 E8 ?? ?? ?? ?? E9 BE 00 00 00 66 0F 2F 25 ?? ?? ?? ?? 76 32 F2 0F 10 05 ?? ?? ?? ?? 48 85 C9 74 0C 0F 57 C6 0F 57 F6 F2 0F 5A F0 EB 07 66 0F 5A C0 0F 28 F0 B9 20 00 00 00 E8 ?? ?? ?? ?? 0F 28 C6 E9 82 00 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 10 2D ?? ?? ?? ?? F2 0F 5E C4 0F 28 E0 0F 28 D4 F2 0F 59 D4 0F 28 DA 0F 28 CA 0F 28 C2 F2 0F 59 1D ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 59 C4 F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 DA F2 0F 59 CA F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 5E D9 F2 0F 5C DC F2 0F 5C EB 48 85 C9 74 03 0F 57 EE 0F 57 C0 F2 0F 5A C5 0F 28 74 24 50 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_10_1_0 {
	meta:
		name = "raise_fpsw_flags"
		size = 49
		refs = "002d _set_statfp"
	strings:
		$1 = { 33 C0 F6 C1 01 8D 50 08 0F 45 C2 F6 C1 02 74 03 83 C8 10 F6 C1 04 74 03 83 C8 04 84 CA 74 03 83 C8 01 F6 C1 10 74 03 83 C8 20 8B C8 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_2_0 {
	meta:
		name = "valf_with_flags"
		size = 74
		refs = "0039 _set_statfp"
		altNames = "val_with_flags"
	strings:
		$1 = { 48 83 EC 38 33 C0 F6 C2 01 0F 29 74 24 20 8D 48 08 0F 28 F0 0F 45 C1 F6 C2 02 74 03 83 C8 10 F6 C2 04 74 03 83 C8 04 84 D1 74 03 83 C8 01 F6 C2 10 74 03 83 C8 20 8B C8 E8 ?? ?? ?? ?? 0F 28 C6 0F 28 74 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "__common_dlog10_cout_rare"
		size = 736
		refs = "003e _vmldLgHATab 006b _2il0floatpacket_78 0287 _2il0floatpacket_79"
	strings:
		$1 = { 48 83 EC 38 33 C0 44 0F B7 41 06 41 81 E0 F0 7F 00 00 41 81 F8 F0 7F 00 00 0F 84 79 02 00 00 F2 0F 10 11 45 33 C0 48 8B 09 48 89 4C 24 30 48 C1 E9 30 F7 C1 F0 7F 00 00 75 18 F2 0F 10 05 ?? ?? ?? ?? 41 B8 C4 FF FF FF F2 0F 59 D0 F2 0F 11 54 24 30 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F D0 0F 86 F9 01 00 00 0F 28 DA F2 0F 5C 1D ?? ?? ?? ?? F2 0F 11 5C 24 28 80 64 24 2F 7F F2 0F 10 44 24 28 66 0F 2F 05 ?? ?? ?? ?? 0F 86 56 01 00 00 F2 0F 11 54 24 28 44 0F B7 4C 24 2E 41 81 E1 0F 80 FF FF 41 81 C9 F0 3F FF FF 66 44 89 4C 24 2E F2 0F 10 64 24 28 0F 28 D4 0F 28 DC 0F B7 4C 24 36 81 E1 F0 7F 00 00 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? C1 E9 04 F2 0F 11 54 24 20 44 8B 54 24 20 41 83 E2 7F F2 0F 11 5C 24 20 45 8D 84 08 01 FC FF FF F2 0F 10 5C 24 20 48 8D 0D ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 4C 8B C9 F2 0F 10 2D ?? ?? ?? ?? 47 8D 1C 52 F2 0F 10 15 ?? ?? ?? ?? F2 41 0F 2A C0 F2 0F 5C 1D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 5C E3 F2 0F 59 C5 4C 8B C1 F2 42 0F 10 2C D9 F2 0F 59 DD F2 43 0F 58 44 D9 10 F2 43 0F 58 4C D8 08 F2 0F 59 EC F2 0F 5C 1D ?? ?? ?? ?? 0F 28 E3 F2 0F 58 CB F2 0F 58 E5 F2 0F 59 D4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D4 0F 28 E5 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 E2 F2 0F 59 DA F2 0F 58 C4 F2 0F 58 E8 F2 0F 58 EB F2 0F 58 CD F2 0F 11 0A 48 83 C4 38 C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 D8 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 D9 F2 0F 11 1A 48 83 C4 38 C3 66 0F 2E D0 7A 02 74 12 F2 0F 5E C0 F2 0F 11 02 B8 01 00 00 00 48 83 C4 38 C3 F2 0F 10 0D ?? ?? ?? ?? B8 02 00 00 00 0F 57 0D ?? ?? ?? ?? F2 0F 5E C8 F2 0F 11 0A 48 83 C4 38 C3 44 8A 41 07 41 80 E0 80 41 80 F8 80 74 11 F2 0F 10 01 F2 0F 59 C0 F2 0F 11 02 48 83 C4 38 C3 F7 41 04 FF FF 0F 00 75 E6 83 39 00 75 E1 F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 5E C0 F2 0F 11 02 48 83 C4 38 C3 90 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "_RTC_Check_2_to_1"
		size = 47
		refs = "0023 ?_RTC_Failure@@YAXPEAXH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 0F BF D9 B9 00 FF 00 00 8B C3 23 C1 74 13 3B C1 74 0F 48 8B 4C 24 28 BA 01 00 00 00 E8 ?? ?? ?? ?? 8A C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_12_1_0 {
	meta:
		name = "_RTC_Check_4_to_1"
		size = 50
		refs = "0026 ?_RTC_Failure@@YAXPEAXH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 8B C1 8B D9 25 00 FF FF FF 05 00 01 00 00 A9 FF FE FF FF 74 0F 48 8B 4C 24 28 BA 01 00 00 00 E8 ?? ?? ?? ?? 8A C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_12_2_0 {
	meta:
		name = "_RTC_Check_4_to_2"
		size = 51
		refs = "0026 ?_RTC_Failure@@YAXPEAXH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 8B C1 8B D9 25 00 00 FF FF 05 00 00 01 00 A9 FF FF FE FF 74 0F 48 8B 4C 24 28 BA 01 00 00 00 E8 ?? ?? ?? ?? 0F B7 C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_12_3_0 {
	meta:
		name = "_RTC_Check_8_to_1"
		size = 55
		refs = "002b ?_RTC_Failure@@YAXPEAXH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B C1 48 8B D9 48 25 00 FF FF FF 48 05 00 01 00 00 48 A9 FF FE FF FF 74 0F 48 8B 4C 24 28 BA 01 00 00 00 E8 ?? ?? ?? ?? 8A C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_12_4_0 {
	meta:
		name = "_RTC_Check_8_to_2"
		size = 56
		refs = "002b ?_RTC_Failure@@YAXPEAXH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B C1 48 8B D9 48 25 00 00 FF FF 48 05 00 00 01 00 48 A9 FF FF FE FF 74 0F 48 8B 4C 24 28 BA 01 00 00 00 E8 ?? ?? ?? ?? 0F B7 C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_12_5_0 {
	meta:
		name = "_RTC_Check_8_to_4"
		size = 76
		refs = "0040 ?_RTC_Failure@@YAXPEAXH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B C1 48 8B D9 48 B9 00 00 00 00 FF FF FF FF 48 23 C1 48 B9 00 00 00 00 01 00 00 00 48 03 C1 48 B9 FF FF FF FF FE FF FF FF 48 85 C1 74 0F 48 8B 4C 24 28 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "_vscprintf"
		size = 21
		refs = "0009 _output_l 0011 _vscprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_258_1_0 {
	meta:
		name = "_vprintf_p"
		size = 21
		refs = "0009 _output_p_l 0011 vprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_3_0 {
	meta:
		name = "_vscprintf_p"
		size = 21
		refs = "0009 _output_p_l 0011 _vscprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_674_1_0 {
	meta:
		name = "_vscwprintf"
		size = 21
		refs = "0009 _woutput_l 0011 _vscwprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_674_4_0 {
	meta:
		name = "_vscwprintf_p"
		size = 21
		refs = "0009 _woutput_p_l 0011 _vscwprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1333_1_0 {
	meta:
		name = "_vwprintf_p"
		size = 21
		refs = "0009 _woutput_p_l 0011 vwprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_258_4_0 {
	meta:
		name = "vprintf"
		size = 21
		refs = "0009 _output_l 0011 vprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_258_7_0 {
	meta:
		name = "vprintf_s"
		size = 21
		refs = "0009 _output_s_l 0011 vprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_328_4_0 {
	meta:
		name = "vscanf"
		size = 21
		refs = "0009 _input_l 0011 vscanf_fn"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_328_7_0 {
	meta:
		name = "vscanf_s"
		size = 21
		refs = "0009 _input_s_l 0011 vscanf_fn"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1333_4_0 {
	meta:
		name = "vwprintf"
		size = 21
		refs = "0009 _woutput_l 0011 vwprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1333_7_0 {
	meta:
		name = "vwprintf_s"
		size = 21
		refs = "0009 _woutput_s_l 0011 vwprintf_helper"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1021_2_0 {
	meta:
		name = "vwscanf"
		size = 21
		refs = "0009 _winput_l 0011 vwscanf_fn"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1021_5_0 {
	meta:
		name = "vwscanf_s"
		size = 21
		refs = "0009 _winput_s_l 0011 vwscanf_fn"
	strings:
		$1 = { 4C 8B CA 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_1_0 {
	meta:
		name = "_vscprintf_helper"
		size = 143
		refs = "0030 memset 003a _errno 0045 _invalid_parameter_noinfo"
		altNames = "_vscwprintf_helper"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 57 48 83 EC 50 48 83 60 C8 00 48 8B DA 33 D2 49 8B F0 48 8B E9 44 8D 42 28 48 8D 48 D0 49 8B F9 E8 ?? ?? ?? ?? 48 85 DB 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 2C 48 83 64 24 30 00 48 83 64 24 20 00 48 8D 4C 24 20 4C 8B CF 4C 8B C6 48 8B D3 C7 44 24 28 FF FF FF 7F C7 44 24 38 42 00 00 00 FF D5 48 8B 5C 24 60 48 8B 6C 24 68 48 8B 74 24 70 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_15_2_0 {
	meta:
		name = "_vscprintf_l"
		size = 21
		refs = "000c _output_l 0011 _vscprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "_vprintf_l"
		size = 21
		refs = "000c _output_l 0011 vprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_258_2_0 {
	meta:
		name = "_vprintf_p_l"
		size = 21
		refs = "000c _output_p_l 0011 vprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_258_3_0 {
	meta:
		name = "_vprintf_s_l"
		size = 21
		refs = "000c _output_s_l 0011 vprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_4_0 {
	meta:
		name = "_vscprintf_p_l"
		size = 21
		refs = "000c _output_p_l 0011 _vscprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_674_3_0 {
	meta:
		name = "_vscwprintf_l"
		size = 21
		refs = "000c _woutput_l 0011 _vscwprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_674_5_0 {
	meta:
		name = "_vscwprintf_p_l"
		size = 21
		refs = "000c _woutput_p_l 0011 _vscwprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1333_0_0 {
	meta:
		name = "_vwprintf_l"
		size = 21
		refs = "000c _woutput_l 0011 vwprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1333_2_0 {
	meta:
		name = "_vwprintf_p_l"
		size = 21
		refs = "000c _woutput_p_l 0011 vwprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1333_3_0 {
	meta:
		name = "_vwprintf_s_l"
		size = 21
		refs = "000c _woutput_s_l 0011 vwprintf_helper"
	strings:
		$1 = { 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_5_0 {
	meta:
		name = "_vsprintf_l"
		size = 181
		refs = "0030 memset 003a _errno 0045 _invalid_parameter_noinfo 007c _output_l 009a _flsbuf"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 57 48 83 EC 50 48 83 60 C8 00 48 8B FA 33 D2 49 8B E8 48 8B D9 44 8D 42 28 48 8D 48 D0 49 8B F1 E8 ?? ?? ?? ?? 48 85 FF 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 52 48 85 DB 74 E6 48 8D 4C 24 20 4C 8B CE 4C 8B C5 48 8B D7 C7 44 24 28 FF FF FF 7F C7 44 24 38 42 00 00 00 48 89 5C 24 30 48 89 5C 24 20 E8 ?? ?? ?? ?? FF 4C 24 28 8B D8 78 0A 48 8B 4C 24 20 C6 01 00 EB 0C 48 8D 54 24 20 33 C9 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 60 48 8B 6C 24 68 48 8B 74 24 70 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "_add_exp"
		size = 78
	strings:
		$1 = { F2 0F 11 44 24 08 48 8B 4C 24 08 B8 FF 07 00 00 48 C1 E9 30 F2 0F 11 44 24 20 F2 0F 11 44 24 18 66 C1 E9 04 66 23 C8 48 8B 44 24 20 66 03 CA 48 C1 E8 30 BA 0F 80 00 00 66 23 C2 66 C1 E1 04 66 0B C8 66 89 4C 24 1E F2 0F 10 44 24 18 C3 }
	condition:
		$1
}

rule file_16_1_0 {
	meta:
		name = "_decomp"
		size = 308
	strings:
		$1 = { 0F 28 C8 F2 0F 11 44 24 08 0F 57 C0 4C 8B D2 66 0F 2E C8 7A 09 75 07 33 C9 E9 12 01 00 00 48 8B 44 24 08 B9 F0 7F 00 00 4C 8B C0 49 C1 E8 30 66 44 85 C1 0F 85 AD 00 00 00 8B 54 24 08 48 C1 E8 20 A9 FF FF 0F 00 75 08 85 D2 0F 84 96 00 00 00 45 33 C9 66 0F 2F C1 B9 03 FC FF FF 41 0F 97 C1 41 F6 C0 10 75 24 8B 44 24 0C 03 C0 89 44 24 0C 85 D2 79 07 83 C8 01 89 44 24 0C 03 D2 FF C9 F6 44 24 0E 10 74 E4 89 54 24 08 0F B7 44 24 0E BA EF FF 00 00 66 23 C2 66 89 44 24 0E 45 85 C9 74 0D BA 00 80 00 00 66 0B C2 66 89 44 24 0E F2 0F 10 44 24 08 BA EF BF 00 00 F2 0F 11 44 24 10 F2 0F 11 44 24 08 48 8B 44 24 10 48 C1 E8 30 66 23 C2 BA E0 3F 00 00 66 0B C2 66 89 44 24 0E F2 0F 10 44 24 08 EB 4A BA EF BF 00 00 F2 0F 11 4C 24 10 B9 FF 07 00 00 F2 0F 11 4C 24 18 48 8B 44 24 18 48 C1 E8 30 66 23 C2 BA E0 3F 00 00 66 0B C2 66 89 44 24 16 0F B7 44 24 0E 66 C1 E8 04 F2 0F 10 44 24 10 66 23 C1 0F BF C8 81 E9 FE 03 00 00 41 89 0A C3 }
	condition:
		$1
}

rule file_16_2_0 {
	meta:
		name = "_get_exp"
		size = 37
	strings:
		$1 = { B9 FF 07 00 00 F2 0F 11 44 24 08 48 8B 44 24 08 48 C1 E8 30 66 C1 E8 04 66 23 C1 B9 FE 03 00 00 66 2B C1 98 C3 }
	condition:
		$1
}

rule file_16_3_0 {
	meta:
		name = "_set_bexp"
		size = 48
	strings:
		$1 = { F2 0F 11 44 24 08 48 8B 44 24 08 F2 0F 11 44 24 18 48 C1 E8 30 B9 0F 80 00 00 66 C1 E2 04 66 23 C1 66 0B C2 66 89 44 24 1E F2 0F 10 44 24 18 C3 }
	condition:
		$1
}

rule file_16_4_0 {
	meta:
		name = "_set_exp"
		size = 56
	strings:
		$1 = { F2 0F 11 44 24 08 48 8B 44 24 08 B9 0F 80 00 00 48 C1 E8 30 F2 0F 11 44 24 18 66 23 C1 B9 FE 03 00 00 66 03 D1 66 C1 E2 04 66 0B C2 66 89 44 24 1E F2 0F 10 44 24 18 C3 }
	condition:
		$1
}

rule file_16_5_0 {
	meta:
		name = "_sptype"
		size = 116
	strings:
		$1 = { F2 0F 11 44 24 08 48 8B 44 24 08 48 8B C8 48 C1 E9 20 81 F9 00 00 F0 7F 75 0A 85 C0 75 06 B8 01 00 00 00 C3 81 F9 00 00 F0 FF 75 0A 85 C0 75 06 B8 02 00 00 00 C3 41 B8 F8 7F 00 00 48 8B D0 48 C1 EA 30 66 41 23 D0 66 41 3B D0 75 06 B8 03 00 00 00 C3 41 B8 F0 7F 00 00 66 41 3B D0 75 12 F7 C1 FF FF 07 00 75 04 85 C0 74 06 B8 04 00 00 00 C3 33 C0 C3 }
	condition:
		$1
}

rule file_17_3_0 {
	meta:
		name = "_mbslwr"
		size = 43
		refs = "0016 _mbslwr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B C1 48 8B D9 48 F7 D8 48 1B D2 45 33 C0 E8 ?? ?? ?? ?? 33 D2 85 C0 48 0F 44 D3 48 8B C2 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_901_3_0 {
	meta:
		name = "_mbsupr"
		size = 43
		refs = "0016 _mbsupr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B C1 48 8B D9 48 F7 D8 48 1B D2 45 33 C0 E8 ?? ?? ?? ?? 33 D2 85 C0 48 0F 44 D3 48 8B C2 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_4_0 {
	meta:
		name = "_mbslwr_l"
		size = 43
		refs = "0016 _mbslwr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B C1 4C 8B C2 48 8B D9 48 F7 D8 48 1B D2 E8 ?? ?? ?? ?? 33 D2 85 C0 48 0F 44 D3 48 8B C2 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_901_4_0 {
	meta:
		name = "_mbsupr_l"
		size = 43
		refs = "0016 _mbsupr_s_l"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B C1 4C 8B C2 48 8B D9 48 F7 D8 48 1B D2 E8 ?? ?? ?? ?? 33 D2 85 C0 48 0F 44 D3 48 8B C2 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_6_0 {
	meta:
		name = "_mbslwr_s_l"
		size = 338
		refs = "0034 _errno 0040 _invalid_parameter_noinfo 004c strnlen 0063 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 00ca __crtLCMapStringA"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 57 48 83 EC 70 49 8B F0 48 8B DA 48 8B F9 48 85 C9 74 11 48 85 D2 74 11 48 85 C9 75 24 33 C0 E9 FB 00 00 00 48 85 D2 74 EF E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 E9 DE 00 00 00 E8 ?? ?? ?? ?? 48 3B C3 72 05 C6 07 00 EB D9 48 8D 4C 24 50 48 8B D6 E8 ?? ?? ?? ?? 80 3F 00 48 8B F7 48 8B DF 0F 84 9B 00 00 00 48 8B 54 24 58 0F B6 06 48 8D 0C 10 F6 41 19 04 74 6C 8B 42 04 48 8B 92 20 02 00 00 C7 44 24 40 01 00 00 00 89 44 24 38 48 8D 84 24 80 00 00 00 C7 44 24 30 02 00 00 00 48 89 44 24 28 48 8D 4C 24 50 4C 8B CE 41 B8 00 01 00 00 C7 44 24 20 02 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 69 8A 8C 24 80 00 00 00 48 8B 54 24 58 48 FF C6 88 0B 48 FF C3 83 F8 01 7E 1A 8A 84 24 81 00 00 00 EB 0C F6 41 19 10 74 06 8A 81 19 01 00 00 88 03 48 FF C3 48 FF C6 80 3E 00 0F 85 6A FF FF FF C6 03 00 33 C0 80 7C 24 68 00 74 0C 48 8B 4C 24 60 83 A1 C8 00 00 00 FD 4C 8D 5C 24 70 49 8B 5B 18 49 8B 73 20 49 8B E3 5F C3 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C6 07 00 E8 ?? ?? ?? ?? 8B 00 EB C4 }
	condition:
		$1
}

rule file_18_8_0 {
	meta:
		name = "??0?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAA@PEAV_CriticalNonReentrantLock@12@@Z"
		size = 121
		refs = "002c ??_U@YAPEAX_K@Z 0067 memset"
		altNames = "??0?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAA@PEAV_HyperNonReentrantLock@12@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 C7 01 00 00 00 00 48 8B D9 48 89 51 20 C7 41 04 00 00 00 00 BF 3F 00 00 00 89 79 08 B9 00 02 00 00 E8 ?? ?? ?? ?? B9 00 04 00 00 48 89 43 10 E8 ?? ?? ?? ?? 48 85 C0 74 13 48 8B C8 48 83 21 00 83 61 08 00 FF CF 48 8D 49 10 79 F0 48 8B 4B 10 33 D2 41 B8 00 02 00 00 48 89 43 18 E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_18_9_0 {
	meta:
		name = "??0?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAA@PEAV_CriticalNonReentrantLock@12@@Z"
		size = 116
		refs = "0038 ??_U@YAPEAX_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 83 61 1C 00 83 61 0C 00 48 89 51 10 C7 01 00 00 00 00 48 8B D9 C6 41 18 00 C7 41 04 00 00 00 00 BF 3F 00 00 00 89 79 08 B9 00 02 00 00 E8 ?? ?? ?? ?? B9 00 04 00 00 48 89 43 20 E8 ?? ?? ?? ?? 48 85 C0 74 13 48 8B C8 48 83 21 00 83 61 08 00 FF CF 48 8D 49 10 79 F0 48 89 43 28 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_18_12_0 {
	meta:
		name = "??0WorkQueue@details@Concurrency@@QEAA@XZ"
		size = 119
		refs = "0026 ??0?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAA@PEAV_CriticalNonReentrantLock@12@@Z 0048 ??0?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAA@PEAV_CriticalNonReentrantLock@12@@Z 005f ?GetNewWorkQueueId@SchedulerBase@details@Concurrency@@SAIXZ"
	strings:
		$1 = { 48 89 4C 24 08 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 48 48 8B F9 48 8D 99 E0 00 00 00 48 8B D3 E8 ?? ?? ?? ?? 90 C7 87 90 00 00 00 00 00 00 00 48 83 A7 A8 00 00 00 00 48 8D 8F B0 00 00 00 48 8B D3 E8 ?? ?? ?? ?? 90 C7 03 00 00 00 00 83 67 60 00 48 89 BF 80 00 00 00 E8 ?? ?? ?? ?? 89 87 A0 00 00 00 48 8B C7 48 8B 5C 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_18_14_0 {
	meta:
		name = "?dtor$1@?0???0WorkQueue@details@Concurrency@@QEAA@XZ@4HA"
		size = 19
		refs = "000f ??1?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 81 C1 B0 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1369_100_0 {
	meta:
		name = "?dtor$6@?0???1SchedulerBase@details@Concurrency@@UEAA@XZ@4HA"
		size = 19
		refs = "000f ??1?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 81 C1 B0 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_17_0 {
	meta:
		name = "??0_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 29
		refs = "0010 ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 89 11 48 8B CA E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_832_12_0 {
	meta:
		name = "??0ScopedCriticalRegion@ContextBase@details@Concurrency@@QEAA@PEAV123@@Z"
		size = 29
		refs = "0010 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QEAAHXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 89 11 48 8B CA E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1369_62_0 {
	meta:
		name = "??0_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 29
		refs = "0010 ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 89 11 48 8B CA E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_326_28_0 {
	meta:
		name = "??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 29
		refs = "0010 ?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 89 11 48 8B CA E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1369_64_0 {
	meta:
		name = "??0_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 29
		refs = "0010 ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 89 11 48 8B CA E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_163_15_0 {
	meta:
		name = "??0_Scoped_lock@_ReentrantBlockingLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 29
		refs = "0010 ?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 89 11 48 8B CA E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1240_33_0 {
	meta:
		name = "??0scoped_lock_read@reader_writer_lock@Concurrency@@QEAA@AEAV12@@Z"
		size = 29
		refs = "0010 ?lock_read@reader_writer_lock@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 89 11 48 8B CA E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_18_19_0 {
	meta:
		name = "??1?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAA@XZ"
		size = 32
		refs = "000e ??_V@YAXPEAX@Z"
		altNames = "??1?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 49 10 E8 ?? ?? ?? ?? 48 8B 4B 18 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_20_0 {
	meta:
		name = "??1?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAA@XZ"
		size = 32
		refs = "000e ??_V@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 49 20 E8 ?? ?? ?? ?? 48 8B 4B 28 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_23_0 {
	meta:
		name = "??1Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 32
		refs = "000e ??_V@YAXPEAX@Z"
		altNames = "??1Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 49 18 E8 ?? ?? ?? ?? 48 8B 4B 10 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_35_0 {
	meta:
		name = "??_GSegment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEAAPEAXI@Z"
		size = 60
		refs = "0014 ??_V@YAXPEAX@Z 002a ??3@YAXPEAX@Z"
		altNames = "??_GSegment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAAPEAXI@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 48 8B 49 18 8B DA E8 ?? ?? ?? ?? 48 8B 4F 10 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_18_38_0 {
	meta:
		name = "?Claim@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEAA_NPEAPEAV_UnrealizedChore@34@@Z"
		size = 110
		refs = "005d ?StaticDelete@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@SAXPEAU1234@@Z 0062 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QEAAXP6AXPEAX@Z0PEAVSchedulerBase@23@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 01 44 8B 49 08 4C 8B D9 4C 8B 40 18 4B 8B 1C C8 48 83 FB 01 74 25 4C 8B 01 44 8B 51 08 B9 01 00 00 00 4D 8B 48 18 4B 87 0C D1 48 3B CB 75 0C 48 85 D2 74 03 48 89 1A B0 01 EB 25 4D 8B 03 83 C8 FF F0 41 0F C1 40 24 FF C8 75 13 4D 8B 08 49 8D 48 30 48 8D 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 32 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_559_47_0 {
	meta:
		name = "?Claim@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAA_NPEAPEAVInternalContextBase@34@@Z"
		size = 110
		refs = "005d ?StaticDelete@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@SAXPEAU1234@@Z 0062 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QEAAXP6AXPEAX@Z0PEAVSchedulerBase@23@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 01 44 8B 49 08 4C 8B D9 4C 8B 40 18 4B 8B 1C C8 48 83 FB 01 74 25 4C 8B 01 44 8B 51 08 B9 01 00 00 00 4D 8B 48 18 4B 87 0C D1 48 3B CB 75 0C 48 85 D2 74 03 48 89 1A B0 01 EB 25 4D 8B 03 83 C8 FF F0 41 0F C1 40 24 FF C8 75 13 4D 8B 08 49 8D 48 30 48 8D 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 32 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_18_39_0 {
	meta:
		name = "?DeferToAffineSearchers@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEBA_NXZ"
		size = 159
		refs = "0013 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ"
		altNames = "?DeferToAffineSearchers@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEBA_NXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 85 C0 74 06 4C 8D 50 F0 EB 03 45 33 D2 48 8B 33 33 C0 33 FF 4C 8B 1E 45 8B 43 60 41 83 C0 1F 41 C1 E8 05 45 85 C0 74 49 44 8D 48 01 85 C0 75 1A 48 8B 46 10 49 8B 4B 68 8B 04 B8 23 04 B9 41 03 F9 41 3B F8 72 E6 85 C0 74 27 49 8B 82 08 01 00 00 8B 88 D4 00 00 00 48 8B 03 48 8B 50 10 44 8B C1 83 E1 1F 49 C1 E8 05 42 8B 04 82 0F A3 C8 73 03 45 33 C9 48 8B 5C 24 30 48 8B 74 24 38 41 8A C1 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_18_40_0 {
	meta:
		name = "?Dereference@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEAAXXZ"
		size = 37
		refs = "0013 ?StaticDelete@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@SAXPEAU1234@@Z 001c ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QEAAXP6AXPEAX@Z0PEAVSchedulerBase@23@@Z"
	strings:
		$1 = { 48 83 EC 28 F0 FF 49 24 4C 8B C1 75 13 4D 8B 08 48 8D 15 ?? ?? ?? ?? 48 83 C1 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_559_54_0 {
	meta:
		name = "?Dereference@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAAXXZ"
		size = 37
		refs = "0013 ?StaticDelete@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@SAXPEAU1234@@Z 001c ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QEAAXP6AXPEAX@Z0PEAVSchedulerBase@23@@Z"
	strings:
		$1 = { 48 83 EC 28 F0 FF 49 24 4C 8B C1 75 13 4D 8B 08 48 8D 15 ?? ?? ?? ?? 48 83 C1 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_43_0 {
	meta:
		name = "?Expire@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEAAXXZ"
		size = 22
		refs = "0006 ?StaticDelete@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@SAXPEAU1234@@Z 0012 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QEAAXP6AXPEAX@Z0PEAVSchedulerBase@23@@Z"
	strings:
		$1 = { 4C 8B C1 48 8D 15 ?? ?? ?? ?? 48 83 C1 30 4D 8B 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_559_55_0 {
	meta:
		name = "?Expire@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAAXXZ"
		size = 22
		refs = "0006 ?StaticDelete@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@SAXPEAU1234@@Z 0012 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QEAAXP6AXPEAX@Z0PEAVSchedulerBase@23@@Z"
	strings:
		$1 = { 4C 8B C1 48 8D 15 ?? ?? ?? ?? 48 83 C1 30 4D 8B 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_48_0 {
	meta:
		name = "?HasSearchers@SchedulerBase@details@Concurrency@@QEBA_NAEBVQuickBitSet@23@@Z"
		size = 90
	strings:
		$1 = { 48 89 5C 24 08 48 89 7C 24 10 44 8B 51 60 33 C0 48 8B FA 41 83 C2 1F 48 8B D9 44 8B C8 41 C1 EA 05 44 8B D8 45 85 D2 74 20 45 85 C9 75 1E 48 8B 4F 08 48 8B 53 68 45 8B C3 46 8B 0C 81 41 FF C3 46 23 0C 82 45 3B DA 72 E0 45 85 C9 48 8B 5C 24 08 48 8B 7C 24 10 0F 95 C0 C3 }
	condition:
		$1
}

rule file_18_49_0 {
	meta:
		name = "?Intersects@QuickBitSet@details@Concurrency@@QEBA_NAEBV123@@Z"
		size = 89
	strings:
		$1 = { 48 89 5C 24 08 48 89 7C 24 10 44 8B 11 33 C0 48 8B FA 41 83 C2 1F 48 8B D9 44 8B C8 41 C1 EA 05 44 8B D8 45 85 D2 74 20 45 85 C9 75 1E 48 8B 4B 08 48 8B 57 08 45 8B C3 46 8B 0C 81 41 FF C3 46 23 0C 82 45 3B DA 72 E0 45 85 C9 48 8B 5C 24 08 48 8B 7C 24 10 0F 95 C0 C3 }
	condition:
		$1
}

rule file_18_50_0 {
	meta:
		name = "?IsEmpty@WorkQueue@details@Concurrency@@QEBA_NXZ"
		size = 34
	strings:
		$1 = { 8B 51 04 8B 01 3B D0 7F 16 8B 91 B4 00 00 00 8B 81 B0 00 00 00 3B D0 7F 06 B8 01 00 00 00 C3 33 C0 C3 }
	condition:
		$1
}

rule file_18_51_0 {
	meta:
		name = "?IsSet@QuickBitSet@details@Concurrency@@QEBA_NI@Z"
		size = 25
	strings:
		$1 = { 48 8B 41 08 44 8B C2 83 E2 1F 49 C1 E8 05 42 8B 0C 80 0F A3 D1 0F 92 C0 C3 }
	condition:
		$1
}

rule file_18_54_0 {
	meta:
		name = "?RedetachFromScheduleGroupAtSafePoint@WorkQueue@details@Concurrency@@QEAAXPEAVScheduleGroupSegmentBase@23@@Z"
		size = 37
		refs = "0018 ?StaticRedetachFromScheduleGroup@WorkQueue@details@Concurrency@@CAXPEAV123@@Z 0021 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QEAAXP6AXPEAX@Z0PEAVSchedulerBase@23@@Z"
	strings:
		$1 = { 48 89 91 98 00 00 00 4C 8B 8A A8 01 00 00 4C 8B C1 4D 8B 49 08 48 8D 15 ?? ?? ?? ?? 48 83 C1 40 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_58_0 {
	meta:
		name = "?RetireAtSafePoint@WorkQueue@details@Concurrency@@QEAAXPEAVScheduleGroupSegmentBase@23@@Z"
		size = 37
		refs = "0018 ?StaticRetire@WorkQueue@details@Concurrency@@CAXPEAV123@@Z 0021 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QEAAXP6AXPEAX@Z0PEAVSchedulerBase@23@@Z"
	strings:
		$1 = { 48 89 91 98 00 00 00 4C 8B 8A A8 01 00 00 4C 8B C1 4D 8B 49 08 48 8D 15 ?? ?? ?? ?? 48 83 C1 40 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_56_0 {
	meta:
		name = "?Reinitialize@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAAXXZ"
		size = 17
	strings:
		$1 = { 33 C0 89 01 89 41 04 89 41 1C 88 41 18 89 41 0C C3 }
	condition:
		$1
}

rule file_18_57_0 {
	meta:
		name = "?Reinitialize@WorkQueue@details@Concurrency@@AEAAXXZ"
		size = 107
		refs = "0018 ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ 001d ?GetNewWorkQueueId@SchedulerBase@details@Concurrency@@SAIXZ 0067 ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 99 E0 00 00 00 48 8B F9 48 8B CB E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B CB 89 87 A0 00 00 00 33 C0 89 07 89 47 04 89 87 B0 00 00 00 89 87 B4 00 00 00 89 87 CC 00 00 00 88 87 C8 00 00 00 89 87 BC 00 00 00 89 87 90 00 00 00 48 89 87 A8 00 00 00 48 8B 5C 24 30 48 83 C4 20 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_59_0 {
	meta:
		name = "?StaticDelete@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@SAXPEAU1234@@Z"
		size = 45
		refs = "0012 ??_V@YAXPEAX@Z 0023 ??3@YAXPEAX@Z"
		altNames = "?StaticDelete@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@SAXPEAU1234@@Z"
	strings:
		$1 = { 48 85 C9 74 27 53 48 83 EC 20 48 8B D9 48 8B 49 18 E8 ?? ?? ?? ?? 48 8B 4B 10 E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_18_62_0 {
	meta:
		name = "?Steal@WorkQueue@details@Concurrency@@QEAAPEAV_UnrealizedChore@23@_N@Z"
		size = 91
		refs = "002d ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ 0039 ?UnlockedSteal@WorkQueue@details@Concurrency@@AEAAPEAV_UnrealizedChore@23@_N@Z 0044 ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 8B C4 57 48 83 EC 30 48 C7 40 E8 FE FF FF FF 48 89 58 10 48 89 70 18 40 8A FA 48 8B F1 48 8D 99 E0 00 00 00 48 89 58 08 48 8B CB E8 ?? ?? ?? ?? 90 40 8A D7 48 8B CE E8 ?? ?? ?? ?? 48 8B F8 48 8B CB E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_18_64_0 {
	meta:
		name = "?Sweep@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAAXP6A_NPEAV_UnrealizedChore@23@PEAX@Z12@Z"
		size = 194
		refs = "0034 ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ 00be ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 8B C4 48 89 50 10 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 30 48 C7 40 B8 FE FF FF FF 48 89 58 18 4D 8B E9 4D 8B E0 48 8B D9 48 8B 49 10 48 89 48 08 E8 ?? ?? ?? ?? 90 8B 7B 04 8B 73 04 FF CE 8B 03 3B F0 7C 57 8D 6E 01 4C 63 FE 48 63 4B 08 49 23 CF 48 8B 43 20 4C 8B 34 C8 4D 85 F6 74 33 49 8B D4 49 8B CE FF 54 24 78 84 C0 74 25 49 8B D4 49 8B CE 41 FF D5 84 C0 74 18 3B EF 75 04 FF CF EB 10 48 63 4B 08 49 23 CF 48 8B 43 20 48 83 24 C8 00 FF CE FF CD 8B 03 3B F0 7D AC 87 7B 04 48 8B 4C 24 70 48 8B 9C 24 80 00 00 00 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F 5E 5D E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_67_0 {
	meta:
		name = "?TryToSteal@WorkQueue@details@Concurrency@@QEAAPEAV_UnrealizedChore@23@_NAEA_N@Z"
		size = 106
		refs = "002e ?_TryAcquire@_CriticalNonReentrantLock@details@Concurrency@@QEAA_NXZ 003d ?UnlockedSteal@WorkQueue@details@Concurrency@@AEAAPEAV_UnrealizedChore@23@_N@Z 0048 ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 48 89 4C 24 08 57 41 56 41 57 48 83 EC 20 49 8B F8 44 8A FA 48 8B F1 33 DB 4C 8D B1 E0 00 00 00 49 8B CE E8 ?? ?? ?? ?? 84 C0 74 1B 41 8A D7 48 8B CE E8 ?? ?? ?? ?? 48 8B D8 49 8B CE E8 ?? ?? ?? ?? C6 07 01 EB 02 88 1F 48 8B C3 48 8B 5C 24 48 48 8B 74 24 50 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_18_68_0 {
	meta:
		name = "?fin$0@?0??TryToSteal@WorkQueue@details@Concurrency@@QEAAPEAV_UnrealizedChore@23@_NAEA_N@Z@4HA"
		size = 31
		refs = "001a ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 48 81 C1 E0 00 00 00 48 83 C4 20 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_18_69_0 {
	meta:
		name = "?UnlockedSteal@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAAPEAV_UnrealizedChore@23@_N@Z"
		size = 260
		refs = "004b ?DeferToAffineSearchers@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEBA_NXZ 00c4 ?StaticDelete@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@SAXPEAU1234@@Z 00c9 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QEAAXP6AXPEAX@Z0PEAVSchedulerBase@23@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 44 8B 01 8B 41 04 40 8A EA 44 3B C0 48 8B D9 0F 8D C4 00 00 00 48 63 3B 48 63 4B 08 48 8B 43 10 48 23 CF F6 04 C8 01 74 1A 40 84 ED 75 15 48 C1 E1 04 48 03 4B 18 E8 ?? ?? ?? ?? 84 C0 0F 85 96 00 00 00 48 63 4B 08 48 8B 43 10 45 33 C0 48 23 CF 4C 87 04 C8 41 F6 C0 01 74 6F 4C 63 4B 08 49 83 E0 FE 4C 23 CF 49 C1 E1 04 4C 03 4B 18 49 8B 01 41 8B 51 08 48 8B 48 18 4C 8B 14 D1 49 83 FA 01 74 19 49 8B 01 41 8B 51 08 48 8B 48 18 B8 01 00 00 00 48 87 04 D1 49 3B C2 74 2E 4D 8B 01 F0 41 FF 48 24 75 13 4D 8B 08 49 8D 48 30 48 8D 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 47 01 89 03 8B 0B 8B 43 04 3B C8 E9 45 FF FF FF 4D 85 C0 74 05 8D 4F 01 89 0B 49 8B C0 EB 02 33 C0 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_559_84_0 {
	meta:
		name = "?UnlockedSteal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAPEAVInternalContextBase@23@_N@Z"
		size = 260
		refs = "004b ?DeferToAffineSearchers@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEBA_NXZ 00c4 ?StaticDelete@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@SAXPEAU1234@@Z 00c9 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QEAAXP6AXPEAX@Z0PEAVSchedulerBase@23@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 44 8B 01 8B 41 04 40 8A EA 44 3B C0 48 8B D9 0F 8D C4 00 00 00 48 63 3B 48 63 4B 08 48 8B 43 10 48 23 CF F6 04 C8 01 74 1A 40 84 ED 75 15 48 C1 E1 04 48 03 4B 18 E8 ?? ?? ?? ?? 84 C0 0F 85 96 00 00 00 48 63 4B 08 48 8B 43 10 45 33 C0 48 23 CF 4C 87 04 C8 41 F6 C0 01 74 6F 4C 63 4B 08 49 83 E0 FE 4C 23 CF 49 C1 E1 04 4C 03 4B 18 49 8B 01 41 8B 51 08 48 8B 48 18 4C 8B 14 D1 49 83 FA 01 74 19 49 8B 01 41 8B 51 08 48 8B 48 18 B8 01 00 00 00 48 87 04 D1 49 3B C2 74 2E 4D 8B 01 F0 41 FF 48 24 75 13 4D 8B 08 49 8D 48 30 48 8D 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 47 01 89 03 8B 0B 8B 43 04 3B C8 E9 45 FF FF FF 4D 85 C0 74 05 8D 4F 01 89 0B 49 8B C0 EB 02 33 C0 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_18_70_0 {
	meta:
		name = "?UnlockedSteal@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAAPEAV_UnrealizedChore@23@_N0@Z"
		size = 283
		refs = "0051 ?DeferToAffineSearchers@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEBA_NXZ 00e0 ?StaticDelete@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@SAXPEAU1234@@Z 00e5 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QEAAXP6AXPEAX@Z0PEAVSchedulerBase@23@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 8B 39 40 8A EA 48 8B D9 8D 47 01 45 33 C0 87 01 8B 41 04 3B F8 0F 8D D2 00 00 00 48 63 4B 08 48 8B 43 20 48 63 F7 48 23 CE F6 04 C8 01 74 1A 40 84 ED 75 15 48 C1 E1 04 48 03 4B 28 E8 ?? ?? ?? ?? 84 C0 0F 85 9E 00 00 00 80 7B 18 00 74 0B 8B 03 3B 43 1C 7C 04 C6 43 18 00 48 63 4B 08 48 8B 43 20 45 33 C0 48 23 CE 4C 87 04 C8 4D 85 C0 74 67 41 F6 C0 01 74 78 4C 63 4B 08 49 83 E0 FE 4C 23 CE 49 C1 E1 04 4C 03 4B 28 49 8B 01 41 8B 51 08 48 8B 48 18 4C 8B 14 D1 49 83 FA 01 74 19 49 8B 01 41 8B 51 08 48 8B 48 18 B8 01 00 00 00 48 87 04 D1 49 3B C2 74 37 4D 8B 01 F0 41 FF 48 24 75 13 4D 8B 08 49 8D 48 30 48 8D 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 45 33 C0 8B 3B 8D 47 01 87 03 8B 43 04 E9 2C FF FF FF 89 3B 33 C0 EB 05 89 3B 49 8B C0 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_18_71_0 {
	meta:
		name = "?UnlockedSteal@WorkQueue@details@Concurrency@@AEAAPEAV_UnrealizedChore@23@_N@Z"
		size = 270
		refs = "0078 ?UnlockedSteal@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAAPEAV_UnrealizedChore@23@_N0@Z 008a ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 00a7 ?UnlockedSteal@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAAPEAV_UnrealizedChore@23@_N@Z 00e1 ?ReferenceForCancellation@ContextBase@details@Concurrency@@QEAAXXZ 00f2 ?_SetDetached@_UnrealizedChore@details@Concurrency@@QEAAX_N@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 44 8B 41 04 8B 01 40 8A EA 48 8B F9 44 3B C0 7F 19 44 8B 81 B4 00 00 00 8B 81 B0 00 00 00 44 3B C0 7F 07 33 C0 E9 BB 00 00 00 48 8B 89 A8 00 00 00 33 DB 8B F3 48 85 C9 74 52 8B 81 BC 00 00 00 85 C0 7E 48 48 8B 01 FF 50 20 84 C0 75 3E 38 9F C8 00 00 00 74 1F 48 8D 8F B0 00 00 00 41 B0 01 40 8A D5 E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 74 05 48 8B C8 EB 66 E8 ?? ?? ?? ?? 48 85 C0 74 04 48 8D 58 F0 80 8B 27 01 00 00 02 EB 56 40 8A D5 48 8B CF E8 ?? ?? ?? ?? 48 85 C0 75 49 48 8D 8F B0 00 00 00 45 33 C0 40 8A D5 E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 74 2C 48 8B 8F A8 00 00 00 48 85 C9 74 16 48 8B 40 10 48 39 48 18 75 0C E8 ?? ?? ?? ?? 33 D2 48 8B CE EB 05 48 8B CE B2 01 E8 ?? ?? ?? ?? 48 8B C6 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "_ungetc_nolock"
		size = 263
		refs = "001d _fileno 0024 __badioinfo 002b __pioinfo 0082 _errno 008d _invalid_parameter_noinfo 00c1 _getbuf"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 F6 42 18 40 48 8B DA 8B F9 0F 85 86 00 00 00 48 8B CA E8 ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? 4C 63 D0 45 8D 42 02 41 83 F8 01 76 17 49 8B D2 49 8B CA 83 E2 1F 48 C1 F9 05 48 6B C2 58 49 03 04 CB EB 03 49 8B C1 F6 40 38 7F 75 25 41 8D 42 02 83 F8 01 76 15 49 8B CA 49 8B C2 83 E1 1F 48 C1 F8 05 4C 6B C9 58 4D 03 0C C3 41 F6 41 38 80 74 1E E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 8B 5C 24 30 48 83 C4 20 5F C3 83 FF FF 74 ED F6 43 18 01 75 0C F6 43 18 80 74 E1 F6 43 18 02 75 DB 48 83 7B 10 00 75 08 48 8B CB E8 ?? ?? ?? ?? 48 8B 03 48 3B 43 10 75 0C 83 7B 08 00 75 BD 48 FF C0 48 89 03 48 FF 0B F6 43 18 40 48 8B 03 74 0D 40 38 38 74 0B 48 FF C0 48 89 03 EB 9E 40 88 38 FF 43 08 83 63 18 EF 83 4B 18 01 40 0F B6 C7 EB 8D }
	condition:
		$1
}

rule file_19_1_0 {
	meta:
		name = "ungetc"
		size = 95
		refs = "0021 _errno 002c _invalid_parameter_noinfo 0039 _lock_file 0044 _ungetc_nolock 004e _unlock_file"
	strings:
		$1 = { 48 89 5C 24 08 48 89 54 24 10 57 48 83 EC 20 48 8B DA 8B F9 33 C0 48 85 D2 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 1F 48 8B CA E8 ?? ?? ?? ?? 90 48 8B D3 8B CF E8 ?? ?? ?? ?? 8B F8 48 8B CB E8 ?? ?? ?? ?? 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_19_2_0 {
	meta:
		name = "ungetc$fin$0"
		size = 24
		refs = "0013 _unlock_file"
		altNames = "_fdopen$fin$0 fputc$fin$0 fputs$fin$0 fputwc$fin$0 putc$fin$0 ungetwc$fin$0 vfwscanf_fn$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 38 48 83 C4 20 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "__raise_securityfailure"
		size = 73
		refs = "000b __imp_IsDebuggerPresent 0016 DebuggerWasPresent 001b __crt_debugger_hook 0023 __crtUnhandledException 0045 __crtTerminateProcess"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 FF 15 ?? ?? ?? ?? B9 01 00 00 00 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 0A B9 01 00 00 00 E8 ?? ?? ?? ?? B9 09 04 00 C0 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_1_0 {
	meta:
		name = "__report_gsfailure"
		size = 209
		refs = "000f IsProcessorFeaturePresent 0021 GS_ContextRecord 0026 __crtCapturePreviousContext 0050 GS_ExceptionRecord 00a2 __security_cookie 00b7 __security_cookie_complement 00c3 GS_ExceptionPointers 00c8 __raise_securityfailure"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 B9 17 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 07 B9 02 00 00 00 CD 29 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 38 48 89 05 ?? ?? ?? ?? 48 8D 44 24 38 48 83 C0 08 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 44 24 40 48 89 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 04 00 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 B8 08 00 00 00 48 6B C0 00 48 8D 0D ?? ?? ?? ?? 48 C7 04 01 02 00 00 00 B8 08 00 00 00 48 6B C0 00 48 8B 0D ?? ?? ?? ?? 48 89 4C 04 20 B8 08 00 00 00 48 6B C0 01 48 8B 0D ?? ?? ?? ?? 48 89 4C 04 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_20_2_0 {
	meta:
		name = "__report_rangecheckfailure"
		size = 19
		refs = "000a __report_securityfailure"
	strings:
		$1 = { 48 83 EC 28 B9 08 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_20_3_0 {
	meta:
		name = "__report_securityfailure"
		size = 155
		refs = "000e IsProcessorFeaturePresent 0021 GS_ContextRecord 0026 __crtCaptureCurrentContext 0050 GS_ExceptionRecord 008d GS_ExceptionPointers 0092 __raise_securityfailure"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 B9 17 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 08 8B 44 24 30 8B C8 CD 29 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 05 ?? ?? ?? ?? 48 8D 44 24 28 48 83 C0 08 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 04 00 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 B8 08 00 00 00 48 6B C0 00 48 8D 0D ?? ?? ?? ?? 8B 54 24 30 48 89 14 01 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_20_4_0 {
	meta:
		name = "__report_securityfailureEx"
		size = 270
		refs = "0017 IsProcessorFeaturePresent 002a GS_ContextRecord 002f __crtCaptureCurrentContext 0059 GS_ExceptionRecord 0100 GS_ExceptionPointers 0105 __raise_securityfailure"
	strings:
		$1 = { 4C 89 44 24 18 89 54 24 10 89 4C 24 08 48 83 EC 38 B9 17 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 08 8B 44 24 40 8B C8 CD 29 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 38 48 89 05 ?? ?? ?? ?? 48 8D 44 24 38 48 83 C0 08 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 04 00 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 83 7C 24 48 00 76 10 48 83 7C 24 50 00 75 08 C7 44 24 48 00 00 00 00 83 7C 24 48 0E 76 0A 8B 44 24 48 FF C8 89 44 24 48 8B 44 24 48 FF C0 89 05 ?? ?? ?? ?? B8 08 00 00 00 48 6B C0 00 48 8D 0D ?? ?? ?? ?? 8B 54 24 40 48 89 14 01 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 8B 44 24 48 39 44 24 20 73 22 8B 44 24 20 8B 4C 24 20 FF C1 8B C9 48 8D 15 ?? ?? ?? ?? 4C 8B 44 24 50 49 8B 04 C0 48 89 04 CA EB CA 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "_copysign"
		size = 55
	strings:
		$1 = { F2 0F 11 44 24 08 48 BA 00 00 00 00 00 00 00 80 48 8B 4C 24 08 F2 0F 11 4C 24 08 48 8B 44 24 08 48 33 C1 48 85 C2 74 0E 48 33 CA 48 89 4C 24 08 F2 0F 10 44 24 08 C3 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "__common_datan2_cout_rare"
		size = 4464
		refs = "0011 _vmldAtanHATab"
	strings:
		$1 = { 57 48 81 EC C0 00 00 00 0F 29 74 24 70 F2 0F 10 35 ?? ?? ?? ?? F2 0F 10 01 0F 28 CE F2 0F 59 C1 F2 0F 59 0A F2 0F 11 44 24 38 F2 0F 11 4C 24 40 0F B7 44 24 3E 25 F0 7F 00 00 8A 54 24 47 44 0F B7 5C 24 46 80 E2 80 41 81 E3 F0 7F 00 00 C1 E8 04 8A 4C 24 3F C0 E9 07 C0 EA 07 44 0F 29 BC 24 90 00 00 00 44 0F 29 AC 24 A0 00 00 00 44 0F 29 9C 24 80 00 00 00 44 0F 29 84 24 B0 00 00 00 41 C1 EB 04 48 8B 3D ?? ?? ?? ?? 3D FF 07 00 00 0F 84 64 10 00 00 41 81 FB FF 07 00 00 0F 84 9C 0F 00 00 85 C0 75 15 F7 44 24 3C FF FF 0F 00 75 0B 83 7C 24 38 00 0F 84 AC 0E 00 00 45 85 DB 75 15 F7 44 24 44 FF FF 0F 00 75 0B 83 7C 24 40 00 0F 84 7F 0E 00 00 41 F7 DB F2 0F 11 44 24 38 44 03 D8 F2 0F 11 4C 24 40 44 8A 54 24 3F 44 8A 4C 24 47 41 80 E2 7F 41 80 E1 7F 41 83 FB CA 0F 8E B3 0D 00 00 41 83 FB 36 0F 8D 5E 0D 00 00 44 88 4C 24 47 84 D2 44 88 54 24 3F 75 0F F2 44 0F 10 05 ?? ?? ?? ?? 45 0F 28 D8 EB 12 F2 44 0F 10 05 ?? ?? ?? ?? F2 44 0F 10 1D ?? ?? ?? ?? F2 0F 10 4C 24 38 85 C0 F2 0F 10 6C 24 40 0F 28 D1 F2 0F 5E D5 4C 8B 4C 24 38 F2 0F 11 54 24 58 0F 8E C0 0E 00 00 3D FE 07 00 00 7D 24 4C 89 4C 24 38 05 01 FC FF FF 49 C1 E9 30 41 81 E1 0F 80 FF FF 41 81 C9 F0 3F FF FF 66 44 89 4C 24 3E EB 17 F2 0F 10 05 ?? ?? ?? ?? B8 FE 03 00 00 F2 0F 59 C8 F2 0F 11 4C 24 38 F7 D8 05 FF 03 00 00 48 89 7C 24 40 25 FF 07 00 00 48 C1 EF 30 C1 E0 04 81 E7 0F 80 FF FF 0B F8 66 89 7C 24 46 F2 0F 10 44 24 40 F2 0F 59 E8 66 0F 2F 15 ?? ?? ?? ?? 0F 82 03 08 00 00 F2 0F 10 25 ?? ?? ?? ?? 0F 28 C5 F2 0F 59 C4 B8 71 00 00 00 F2 0F 11 44 24 20 0F 28 C5 F2 44 0F 10 7C 24 20 F2 0F 11 54 24 40 F2 44 0F 5C FD F2 44 0F 11 7C 24 28 F2 0F 10 5C 24 20 F2 0F 10 54 24 28 44 8B 54 24 44 45 8B DA 41 81 E2 00 00 08 00 41 81 E3 00 00 F0 FF 41 81 CA 00 00 04 00 F2 0F 5C DA F2 0F 11 5C 24 20 45 0B DA F2 0F 10 4C 24 20 4C 8D 15 ?? ?? ?? ?? C7 44 24 40 00 00 00 00 F2 0F 5C C1 44 89 5C 24 44 4D 8B DA F2 0F 11 44 24 28 F2 0F 10 5C 24 20 F2 0F 10 4C 24 40 F2 0F 10 44 24 28 F2 0F 59 D9 F2 0F 59 C1 F2 44 0F 10 2D ?? ?? ?? ?? F2 41 0F 59 DD F2 41 0F 59 C5 44 0F 28 FB 44 0F B7 4C 24 5E F2 44 0F 58 F8 F2 44 0F 11 7C 24 20 41 81 E1 F0 7F 00 00 F2 0F 10 54 24 20 41 C1 E9 04 F2 0F 5C DA 8B 7C 24 5C F2 0F 58 D8 F2 0F 10 44 24 38 81 E7 FF FF 0F 00 F2 0F 11 5C 24 28 44 0F 28 F8 F2 0F 10 54 24 20 F2 44 0F 10 6C 24 28 F2 44 0F 58 FA F2 44 0F 11 7C 24 20 44 0F 28 F8 F2 0F 10 5C 24 20 41 C1 E1 14 F2 44 0F 5C FB F2 44 0F 11 7C 24 28 44 0B CF F2 44 0F 10 7C 24 20 41 81 C1 00 00 40 C0 F2 0F 10 5C 24 28 41 C1 F9 13 F2 44 0F 58 FB F2 44 0F 11 7C 24 30 44 0F 28 F8 F2 0F 10 5C 24 28 41 83 F9 71 F2 0F 58 D3 F2 0F 11 54 24 28 41 0F 4C C1 F2 0F 10 54 24 30 03 C0 48 63 C0 F2 44 0F 5C FA F2 44 0F 11 7C 24 30 F2 0F 10 5C 24 28 F2 0F 10 54 24 30 F2 0F 58 DA F2 0F 11 5C 24 30 F2 0F 10 5C 24 20 F2 0F 10 54 24 30 F2 41 0F 58 D5 44 0F 28 EB F2 44 0F 59 EC F2 44 0F 11 6C 24 20 F2 44 0F 10 7C 24 20 F2 44 0F 5C FB F2 44 0F 11 7C 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 10 6C 24 28 F2 45 0F 5C FD F2 44 0F 11 7C 24 20 44 0F 28 F8 F2 44 0F 10 6C 24 20 F2 44 0F 59 3D ?? ?? ?? ?? F2 41 0F 5C DD F2 0F 11 5C 24 28 F2 0F 10 5C 24 20 F2 44 0F 10 6C 24 28 F2 44 0F 11 7C 24 20 F2 41 0F 58 D5 F2 44 0F 10 6C 24 20 F2 44 0F 5C 6C 24 38 F2 44 0F 11 6C 24 28 F2 44 0F 10 6C 24 20 F2 44 0F 10 7C 24 28 F2 45 0F 5C EF F2 44 0F 11 6C 24 20 F2 44 0F 10 7C 24 20 F2 41 0F 5C C7 F2 0F 11 44 24 28 F2 0F 10 44 24 20 F2 44 0F 10 6C 24 28 F2 0F 59 C1 F2 44 0F 59 E9 0F 28 C8 F2 41 0F 58 CD F2 0F 11 4C 24 20 F2 44 0F 10 7C 24 20 F2 41 0F 5C C7 F2 41 0F 58 C5 44 0F 28 ED F2 0F 11 44 24 28 F2 0F 10 44 24 20 F2 44 0F 10 7C 24 28 F2 44 0F 58 E8 F2 44 0F 11 6C 24 20 44 0F 28 ED F2 0F 10 4C 24 20 F2 44 0F 5C E9 F2 44 0F 11 6C 24 28 F2 44 0F 10 6C 24 20 F2 0F 10 4C 24 28 F2 44 0F 58 E9 F2 44 0F 11 6C 24 30 F2 0F 10 4C 24 28 F2 0F 58 C1 F2 0F 11 44 24 28 F2 0F 10 44 24 30 F2 0F 5C E8 F2 0F 11 6C 24 30 F2 0F 10 44 24 28 F2 0F 10 6C 24 30 F2 0F 58 C5 F2 0F 11 44 24 30 F2 44 0F 10 6C 24 20 F2 0F 10 4C 24 30 F2 41 0F 58 CF 45 0F 28 FD F2 44 0F 59 FC F2 44 0F 11 7C 24 20 44 0F 28 FE F2 0F 10 44 24 20 F2 41 0F 5C C5 F2 0F 11 44 24 28 F2 0F 10 44 24 20 F2 0F 10 6C 24 28 F2 0F 5C C5 F2 0F 11 44 24 20 F2 0F 10 6C 24 20 F2 44 0F 5C ED F2 44 0F 11 6C 24 28 F2 0F 10 6C 24 20 F2 44 0F 5E FD 41 0F 28 C7 F2 0F 59 C4 F2 44 0F 10 6C 24 28 F2 0F 11 44 24 28 F2 41 0F 58 CD F2 0F 10 44 24 28 F2 41 0F 5C C7 F2 0F 11 44 24 30 F2 0F 10 44 24 28 F2 44 0F 10 6C 24 30 F2 41 0F 5C C5 F2 0F 11 44 24 30 F2 44 0F 10 6C 24 30 F2 41 0F 59 ED F2 0F 5C F5 F2 0F 10 6C 24 30 F2 0F 59 CD F2 0F 11 4C 24 28 F2 0F 10 4C 24 28 F2 0F 5C F1 F2 0F 11 74 24 28 F2 0F 10 6C 24 28 48 8B 7C 24 30 F2 0F 10 74 24 28 F2 0F 10 44 24 30 48 89 7C 24 48 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EE F2 0F 59 E8 F2 0F 10 74 24 48 44 0F 28 ED 0F 28 C6 F2 0F 59 C3 F2 44 0F 59 EA F2 0F 59 DD F2 0F 59 D6 F2 44 0F 58 EB 44 0F 28 F8 F2 44 0F 58 EA F2 44 0F 11 6C 24 20 F2 0F 10 54 24 20 F2 0F 10 1D ?? ?? ?? ?? F2 44 0F 58 FA F2 44 0F 11 7C 24 20 F2 0F 10 4C 24 20 F2 0F 5C C1 F2 0F 58 C2 F2 0F 11 44 24 28 F2 44 0F 10 7C 24 20 41 0F 28 F7 41 0F 28 EF F2 41 0F 59 F7 F2 0F 59 EC F2 0F 59 DE F2 0F 10 44 24 28 F2 0F 11 6C 24 20 F2 44 0F 10 6C 24 20 F2 0F 58 1D ?? ?? ?? ?? F2 45 0F 5C EF F2 0F 59 DE F2 44 0F 11 6C 24 28 F2 0F 10 54 24 20 F2 0F 10 4C 24 28 F2 0F 58 1D ?? ?? ?? ?? F2 0F 5C D1 F2 0F 59 DE F2 0F 11 54 24 20 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 F3 F2 0F 10 5C 24 20 F2 0F 59 E6 F2 44 0F 5C FB F2 44 0F 11 7C 24 28 F2 44 0F 10 6C 24 20 F2 44 0F 10 7C 24 28 F2 0F 11 64 24 20 F2 41 0F 58 C7 F2 0F 10 64 24 20 F2 0F 5C E6 F2 0F 11 64 24 28 F2 0F 10 4C 24 20 F2 0F 10 6C 24 28 F2 0F 5C CD F2 0F 11 4C 24 20 F2 0F 10 54 24 20 F2 0F 5C F2 F2 0F 11 74 24 28 F2 0F 10 74 24 20 F2 0F 10 5C 24 28 0F 28 EE 44 0F 28 FB F2 44 0F 59 F8 F2 0F 59 F0 F2 41 0F 59 DD F2 41 0F 59 ED F2 44 0F 58 FE 0F 28 CD 0F 28 D5 F2 44 0F 58 FB F2 41 0F 58 CD F2 44 0F 11 7C 24 20 F2 0F 10 74 24 20 F2 0F 11 4C 24 20 F2 0F 10 64 24 20 F2 0F 5C D4 F2 0F 11 54 24 28 F2 0F 10 5C 24 20 F2 0F 10 4C 24 28 F2 0F 58 D9 F2 0F 11 5C 24 30 F2 0F 10 64 24 28 F2 44 0F 58 EC F2 44 0F 11 6C 24 28 F2 44 0F 10 6C 24 30 F2 41 0F 5C ED F2 0F 11 6C 24 30 F2 0F 10 54 24 28 F2 0F 10 4C 24 30 F2 0F 58 D1 F2 0F 11 54 24 30 4C 8B 4C 24 20 4C 89 4C 24 48 F2 0F 10 4C 24 48 0F 28 E1 F2 0F 10 5C 24 30 F2 41 0F 58 24 C2 F2 0F 58 C3 F2 0F 11 64 24 20 F2 0F 58 C6 F2 0F 10 6C 24 20 0F 28 F1 F2 0F 11 44 24 50 F2 0F 5C F5 F2 0F 11 74 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 10 6C 24 28 F2 45 0F 58 FD F2 44 0F 11 7C 24 30 F2 0F 10 64 24 28 F2 41 0F 58 24 C3 F2 0F 11 64 24 28 F2 0F 10 6C 24 30 F2 0F 5C CD F2 0F 11 4C 24 30 F2 0F 10 5C 24 28 F2 0F 10 54 24 30 F2 0F 58 DA F2 0F 11 5C 24 30 4C 8B 4C 24 20 F2 0F 10 4C 24 30 4C 89 4C 24 48 48 8D 3D ?? ?? ?? ?? F2 0F 58 C1 C0 E1 07 F2 0F 58 44 C7 08 8A C2 C0 E0 07 F2 0F 11 44 24 50 41 0F 28 C0 49 C1 E9 38 44 8A 54 24 57 45 8A DA 41 C0 EA 07 41 80 E3 7F 41 80 E1 7F 41 32 D2 44 0A C8 44 88 4C 24 4F F2 0F 10 74 24 48 0F 28 D6 F2 0F 58 C6 C0 E2 07 F2 0F 11 44 24 20 F2 0F 10 4C 24 20 F2 0F 5C D1 F2 0F 11 54 24 28 44 0A DA F2 0F 10 64 24 20 F2 0F 10 5C 24 28 44 88 5C 24 57 F2 0F 58 E3 F2 0F 11 64 24 30 F2 0F 10 6C 24 28 F2 44 0F 58 C5 F2 44 0F 11 44 24 28 F2 44 0F 10 44 24 30 F2 41 0F 5C F0 F2 0F 11 74 24 30 F2 44 0F 10 7C 24 28 F2 44 0F 10 6C 24 30 F2 45 0F 58 FD F2 44 0F 11 7C 24 30 48 8B 54 24 20 F2 0F 10 44 24 30 48 89 54 24 48 F2 0F 58 44 24 50 F2 41 0F 58 C3 F2 44 0F 10 5C 24 48 F2 0F 11 44 24 50 F2 44 0F 58 D8 F2 44 0F 11 5C 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 4C 24 60 49 89 08 E9 0A 06 00 00 F2 0F 10 4C 24 38 44 8A CA 0F 28 C1 F2 0F 59 05 ?? ?? ?? ?? 41 C0 E1 07 C0 E1 07 F2 0F 11 44 24 20 F2 0F 10 54 24 20 F2 0F 10 05 ?? ?? ?? ?? F2 0F 5C 54 24 38 F2 0F 11 54 24 28 0F 28 D5 F2 0F 10 64 24 20 F2 44 0F 10 6C 24 28 F2 0F 59 D0 F2 41 0F 5C E5 F2 0F 11 64 24 20 F2 44 0F 10 7C 24 20 F2 41 0F 5C CF F2 0F 11 4C 24 28 F2 0F 10 4C 24 20 F2 0F 10 5C 24 28 F2 0F 11 54 24 20 0F 28 D6 F2 0F 10 64 24 20 F2 0F 5C E5 F2 0F 11 64 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 10 6C 24 28 F2 45 0F 5C FD F2 44 0F 11 7C 24 20 F2 0F 10 64 24 20 F2 0F 5C EC F2 0F 11 6C 24 28 F2 44 0F 10 7C 24 20 F2 41 0F 5E D7 0F 28 EA F2 0F 59 E8 F2 0F 10 64 24 28 F2 0F 11 6C 24 28 F2 44 0F 10 6C 24 28 F2 44 0F 5C EA F2 44 0F 11 6C 24 30 F2 0F 10 54 24 28 F2 0F 10 6C 24 30 F2 0F 5C D5 F2 0F 11 54 24 30 F2 0F 10 6C 24 30 F2 44 0F 59 FD F2 41 0F 5C F7 F2 44 0F 10 7C 24 30 F2 41 0F 59 E7 F2 0F 11 64 24 28 F2 0F 10 64 24 28 F2 0F 5C F4 F2 0F 11 74 24 28 F2 0F 10 6C 24 28 48 8B 44 24 30 F2 0F 10 74 24 28 F2 0F 10 64 24 30 48 89 44 24 48 F2 0F 10 54 24 48 44 0F 28 EA F2 0F 58 2D ?? ?? ?? ?? F2 44 0F 59 E9 F2 0F 59 D3 F2 0F 59 EE F2 0F 59 EC 44 0F 28 FD F2 44 0F 59 FB F2 0F 59 CD F2 44 0F 58 F9 41 0F 28 CD F2 44 0F 58 FA F2 44 0F 11 7C 24 20 F2 0F 10 5C 24 20 F2 0F 58 CB F2 0F 11 4C 24 20 F2 0F 10 74 24 20 F2 44 0F 5C EE F2 44 0F 58 EB F2 0F 10 1D ?? ?? ?? ?? F2 44 0F 11 6C 24 28 F2 44 0F 10 6C 24 58 F2 45 0F 59 ED F2 41 0F 59 DD F2 0F 10 54 24 20 0F 28 F2 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 F0 F2 41 0F 59 DD F2 0F 10 64 24 28 F2 0F 11 74 24 20 F2 0F 10 6C 24 20 F2 0F 58 1D ?? ?? ?? ?? F2 0F 5C EA F2 41 0F 59 DD F2 0F 11 6C 24 28 F2 44 0F 10 7C 24 20 F2 0F 10 4C 24 28 F2 0F 58 1D ?? ?? ?? ?? F2 44 0F 5C F9 F2 41 0F 59 DD F2 44 0F 11 7C 24 20 F2 0F 58 1D ?? ?? ?? ?? F2 41 0F 59 DD F2 0F 58 1D ?? ?? ?? ?? F2 41 0F 59 DD F2 0F 58 1D ?? ?? ?? ?? F2 41 0F 59 DD F2 44 0F 10 6C 24 20 F2 0F 59 C3 F2 41 0F 5C D5 F2 0F 11 54 24 28 F2 0F 10 4C 24 20 F2 0F 10 54 24 28 F2 0F 11 44 24 20 F2 0F 58 E2 F2 0F 10 44 24 20 F2 0F 5C C3 F2 0F 11 44 24 28 F2 0F 10 6C 24 20 F2 0F 10 74 24 28 F2 0F 5C EE F2 0F 11 6C 24 20 F2 0F 10 44 24 20 F2 0F 5C D8 F2 0F 11 5C 24 28 F2 0F 10 54 24 20 F2 0F 10 5C 24 28 0F 28 EA 44 0F 28 EB F2 44 0F 59 EC F2 0F 59 D4 F2 0F 59 D9 F2 0F 59 E9 F2 44 0F 58 EA 44 0F 28 FD 0F 28 D5 F2 44 0F 58 EB F2 44 0F 58 F9 F2 44 0F 11 6C 24 20 F2 0F 10 74 24 20 F2 44 0F 11 7C 24 20 F2 0F 10 44 24 20 F2 0F 5C D0 F2 0F 11 54 24 28 F2 44 0F 10 6C 24 20 F2 0F 10 5C 24 28 F2 44 0F 58 EB F2 44 0F 11 6C 24 30 F2 44 0F 10 7C 24 28 F2 41 0F 58 CF F2 0F 11 4C 24 28 F2 0F 10 4C 24 30 F2 0F 5C E9 F2 0F 11 6C 24 30 F2 0F 10 54 24 28 F2 0F 10 44 24 30 F2 0F 58 D0 F2 0F 11 54 24 30 48 8B 7C 24 20 F2 0F 10 4C 24 30 48 89 7C 24 48 F2 0F 58 E1 48 C1 EF 38 F2 0F 58 E6 40 80 E7 7F 41 0A F9 40 88 7C 24 4F F2 0F 11 64 24 50 41 0F 28 E0 F2 0F 10 6C 24 48 0F 28 C5 F2 0F 58 E5 F2 0F 11 64 24 20 F2 0F 10 64 24 20 44 8A 54 24 57 45 8A DA 41 C0 EA 07 F2 0F 5C C4 F2 0F 11 44 24 28 F2 0F 10 54 24 20 F2 0F 10 4C 24 28 41 32 D2 41 80 E3 7F C0 E2 07 F2 0F 58 D1 F2 0F 11 54 24 30 F2 0F 10 5C 24 28 F2 44 0F 58 C3 F2 44 0F 11 44 24 28 44 0A DA F2 44 0F 10 44 24 30 44 88 5C 24 57 F2 41 0F 5C E8 F2 0F 11 6C 24 30 F2 0F 10 4C 24 28 F2 0F 10 44 24 30 F2 0F 58 C8 F2 0F 11 4C 24 30 48 8B 54 24 20 F2 0F 10 54 24 30 48 89 54 24 48 F2 0F 58 54 24 50 F2 41 0F 58 D3 F2 44 0F 10 5C 24 48 F2 0F 11 54 24 50 F2 44 0F 58 DA F2 44 0F 11 5C 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 4C 24 60 49 89 08 E9 83 01 00 00 41 83 FB 4A 0F 8D F4 00 00 00 44 88 54 24 3F F2 0F 5E 4C 24 38 F2 0F 10 05 ?? ?? ?? ?? C0 E1 07 F2 0F 5C C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 54 24 60 49 89 10 E9 38 01 00 00 84 D2 0F 85 03 01 00 00 44 88 54 24 3F 44 88 4C 24 47 F2 0F 10 4C 24 38 F2 0F 5E 4C 24 40 F2 0F 11 4C 24 60 0F B7 44 24 66 A9 F0 7F 00 00 74 36 C0 E1 07 F2 0F 58 F1 F2 0F 11 74 24 20 F2 0F 10 44 24 20 F2 0F 59 C8 F2 0F 11 4C 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 54 24 60 49 89 10 E9 D2 00 00 00 F2 0F 59 C9 C0 E1 07 F2 0F 11 4C 24 20 F2 0F 10 44 24 20 F2 0F 58 44 24 60 F2 0F 11 44 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 54 24 60 49 89 10 E9 9A 00 00 00 85 C0 75 11 F7 44 24 3C FF FF 0F 00 75 07 E9 EA 01 00 00 74 2F F2 0F 10 05 ?? ?? ?? ?? C0 E1 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 54 24 60 49 89 10 EB 56 84 D2 75 25 C0 E1 07 48 8B 05 ?? ?? ?? ?? 48 89 44 24 60 48 C1 E8 38 24 7F 0A C1 88 44 24 67 48 8B 54 24 60 49 89 10 EB 2D F2 0F 10 05 ?? ?? ?? ?? C0 E1 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 54 24 60 49 89 10 0F 28 74 24 70 33 C0 44 0F 28 84 24 B0 00 00 00 44 0F }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "ldiv"
		size = 23
		altNames = "div"
	strings:
		$1 = { 8B C1 44 8B C2 99 41 F7 F8 89 44 24 18 89 54 24 1C 48 8B 44 24 18 C3 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "_mbsnbset_s"
		size = 20
		refs = "000b _mbsnbset_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_282_7_0 {
	meta:
		name = "_aligned_recalloc"
		size = 20
		refs = "000b _aligned_offset_recalloc"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1162_11_0 {
	meta:
		name = "_cftof"
		size = 20
		refs = "000b _cftof_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1015_0_0 {
	meta:
		name = "_mbccpy_s"
		size = 20
		refs = "000b _mbccpy_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1072_0_0 {
	meta:
		name = "_mbsnbcat_s"
		size = 20
		refs = "000b _mbsnbcat_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_719_0_0 {
	meta:
		name = "_mbsnbcpy_s"
		size = 20
		refs = "000b _mbsnbcpy_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_780_0_0 {
	meta:
		name = "_mbsncat_s"
		size = 20
		refs = "000b _mbsncat_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_140_0_0 {
	meta:
		name = "_mbsncpy_s"
		size = 20
		refs = "000b _mbsncpy_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1189_0_0 {
	meta:
		name = "_mbsnset_s"
		size = 20
		refs = "000b _mbsnset_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_534_6_0 {
	meta:
		name = "wctomb_s"
		size = 20
		refs = "000b _wctomb_s_l"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_25_10_0 {
	meta:
		name = "??0scheduler_resource_allocation_error@Concurrency@@QEAA@AEBV01@@Z"
		size = 51
		refs = "0011 ??0exception@std@@QEAA@AEBV01@@Z 0018 ??_7scheduler_resource_allocation_error@Concurrency@@6B@"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 07 8B 43 18 48 8B 5C 24 30 89 47 18 48 8B C7 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_22_43_1 {
	meta:
		name = "??0regex_error@std@@QEAA@AEBV01@@Z"
		size = 51
		refs = "0011 ??0exception@std@@QEAA@AEBV01@@Z 0018 ??_7regex_error@std@@6B@"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 07 8B 43 18 48 8B 5C 24 30 89 47 18 48 8B C7 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_25_25_0 {
	meta:
		name = "?Initialize@WinRT@details@Concurrency@@SAXXZ"
		size = 309
		refs = "000a ??_C@_1BI@IDAOOPDH@?$AAc?$AAo?$AAm?$AAb?$AAa?$AAs?$AAe?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0018 __imp_LoadLibraryExW 001f ?m_hModule@WinRT@details@Concurrency@@0PEAUHINSTANCE__@@EA 0031 __imp_GetModuleHandleW 0038 ??_C@_0N@PPOMPGGK@RoInitialize?$AA@ 0041 __imp_GetProcAddress 0052 ?EncodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z 0060 ?s_pfn_RoInitialize@WinRT@details@Concurrency@@0P6AJW4RO_INIT_TYPE@@@ZEA 006d ??_C@_0P@LLFHBIJD@RoUninitialize?$AA@ 008e ?s_pfn_RoUninitialize@WinRT@details@Concurrency@@0P6AXXZEA 0099 ?s_fInitialized@WinRT@details@Concurrency@@0JC 00a7 __imp_GetLastError 00bf ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 00c6 _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 00d0 _CxxThrowException"
	strings:
		$1 = { 48 81 EC 88 00 00 00 48 8D 0D ?? ?? ?? ?? 33 D2 41 B8 00 08 00 00 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 85 C0 74 7D 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 87 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 82 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? B8 01 00 00 00 87 05 ?? ?? ?? ?? 48 81 C4 88 00 00 00 C3 FF 15 ?? ?? ?? ?? 48 8D 4C 24 20 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 4C 24 40 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 40 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 4C 24 60 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_25_27_0 {
	meta:
		name = "?RoInitialize@WinRT@details@Concurrency@@SAJW4RO_INIT_TYPE@@@Z"
		size = 30
		refs = "000b ?s_pfn_RoInitialize@WinRT@details@Concurrency@@0P6AJW4RO_INIT_TYPE@@@ZEA 0010 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B CB 48 83 C4 20 5B 48 FF E0 }
	condition:
		$1
}

rule file_25_28_0 {
	meta:
		name = "?RoUninitialize@WinRT@details@Concurrency@@SAXXZ"
		size = 23
		refs = "0007 ?s_pfn_RoUninitialize@WinRT@details@Concurrency@@0P6AXXZEA 000c ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 48 83 EC 28 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 48 FF E0 }
	condition:
		$1
}

rule file_260_34_0 {
	meta:
		name = "?GetCurrentUmsThread@UMS@details@Concurrency@@SAPEAXXZ"
		size = 23
		refs = "0007 ?s_pfn_GetCurrentUmsThread@UMS@details@Concurrency@@0P6APEAXXZEA 000c ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 48 83 EC 28 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 48 FF E0 }
	condition:
		$1
}

rule file_26_11_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_360_12_0 {
	meta:
		name = "??0_Interruption_exception@details@Concurrency@@QEAA@AEBV012@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7_Interruption_exception@details@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_10_0 {
	meta:
		name = "??0_Interruption_exception@details@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7_Interruption_exception@details@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_645_0_0 {
	meta:
		name = "??0__non_rtti_object@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_645_1_0 {
	meta:
		name = "??0__non_rtti_object@std@@QEAA@PEBD@Z"
		size = 33
		refs = "000a ??0bad_typeid@std@@QEAA@PEBD@Z 0011 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_18_2 {
	meta:
		name = "??0bad_alloc@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_645_2_0 {
	meta:
		name = "??0bad_cast@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_620_36_0 {
	meta:
		name = "??0bad_exception@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_20_2 {
	meta:
		name = "??0bad_function_call@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7bad_function_call@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_21_2 {
	meta:
		name = "??0bad_function_call@std@@QEAA@PEBD@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7bad_function_call@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_118_394_1 {
	meta:
		name = "??0bad_target@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_12_0 {
	meta:
		name = "??0bad_target@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_645_4_0 {
	meta:
		name = "??0bad_typeid@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_57_612_1 {
	meta:
		name = "??0bad_weak_ptr@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7bad_weak_ptr@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_39_588_2 {
	meta:
		name = "??0bad_weak_ptr@std@@QEAA@PEBD@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7bad_weak_ptr@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_391_15_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_15_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_391_16_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_17_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1369_66_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_19_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1240_27_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_21_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1369_67_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_23_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1369_68_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_25_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1369_69_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_27_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_34_27_0 {
	meta:
		name = "??0invalid_argument@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_62_398_2 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_29_0 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_619_38_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_31_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_39_600_2 {
	meta:
		name = "??0invalid_operation@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_33_0 {
	meta:
		name = "??0invalid_operation@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_771_12_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_35_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_792_13_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_37_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_792_14_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_39_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_792_15_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_41_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_620_38_0 {
	meta:
		name = "??0length_error@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7length_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_76_20_2 {
	meta:
		name = "??0lock_error@threads@stdext@@QEAA@AEBV012@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7lock_error@threads@stdext@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_57_626_1 {
	meta:
		name = "??0logic_error@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_118_402_1 {
	meta:
		name = "??0message_not_found@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_43_0 {
	meta:
		name = "??0message_not_found@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_619_39_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_45_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_832_26_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_47_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_62_403_2 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_49_0 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_31_2 {
	meta:
		name = "??0out_of_range@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_33_2 {
	meta:
		name = "??0overflow_error@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_75_59_1 {
	meta:
		name = "??0range_error@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7range_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_111_68_2 {
	meta:
		name = "??0runtime_error@std@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_51_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_54_0 {
	meta:
		name = "??0scheduler_worker_creation_error@Concurrency@@QEAA@J@Z"
		size = 33
		refs = "000a ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 0011 ??_7scheduler_worker_creation_error@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_55_0 {
	meta:
		name = "??0scheduler_worker_creation_error@Concurrency@@QEAA@PEBDJ@Z"
		size = 33
		refs = "000a ??0scheduler_resource_allocation_error@Concurrency@@QEAA@PEBDJ@Z 0011 ??_7scheduler_worker_creation_error@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_57_0 {
	meta:
		name = "??0task_canceled@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7task_canceled@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_76_24_2 {
	meta:
		name = "??0thread_resource_error@threads@stdext@@QEAA@AEBV012@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7thread_resource_error@threads@stdext@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_326_39_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QEAA@AEBV01@@Z"
		size = 33
		refs = "000a ??0exception@std@@QEAA@AEBV01@@Z 0011 ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_59_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QEAA@XZ"
		size = 33
		refs = "000a ??0exception@std@@QEAA@XZ 0011 ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_26_26_0 {
	meta:
		name = "?Create@CurrentScheduler@Concurrency@@SAXAEBVSchedulerPolicy@2@@Z"
		size = 23
		refs = "0005 ?Create@SchedulerBase@details@Concurrency@@SAPEAV123@AEBVSchedulerPolicy@3@@Z"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B C8 48 8B 10 48 83 C4 28 48 FF 62 38 }
	condition:
		$1
}

rule file_26_27_0 {
	meta:
		name = "?CreateScheduleGroup@CurrentScheduler@Concurrency@@SAPEAVScheduleGroup@2@AEAVlocation@2@@Z"
		size = 32
		refs = "000a ?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPEAV123@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B D3 4C 8B 00 48 8B C8 48 83 C4 20 5B 49 FF 60 40 }
	condition:
		$1
}

rule file_26_28_0 {
	meta:
		name = "?CreateScheduleGroup@CurrentScheduler@Concurrency@@SAPEAVScheduleGroup@2@XZ"
		size = 23
		refs = "0005 ?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPEAV123@XZ"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B C8 48 8B 10 48 83 C4 28 48 FF 62 48 }
	condition:
		$1
}

rule file_26_29_0 {
	meta:
		name = "?Detach@CurrentScheduler@Concurrency@@SAXXZ"
		size = 54
		refs = "0005 ?SafeFastCurrentScheduler@SchedulerBase@details@Concurrency@@SAPEAV123@XZ 0016 ?Detach@SchedulerBase@details@Concurrency@@QEAAXXZ 0020 ??0scheduler_not_attached@Concurrency@@QEAA@XZ 0027 _TI2?AVscheduler_not_attached@Concurrency@@ 0031 _CxxThrowException"
	strings:
		$1 = { 48 83 EC 48 E8 ?? ?? ?? ?? 48 85 C0 74 0C 48 8B C8 48 83 C4 48 E9 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_26_31_0 {
	meta:
		name = "?GetNumberOfVirtualProcessors@CurrentScheduler@Concurrency@@SAIXZ"
		size = 36
		refs = "0005 ?SafeFastCurrentScheduler@SchedulerBase@details@Concurrency@@SAPEAV123@XZ"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 85 C0 74 0E 48 8B 10 48 8B C8 48 83 C4 28 48 FF 62 10 83 C8 FF 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_660_31_0 {
	meta:
		name = "?ScheduleGroupId@Context@Concurrency@@SAIXZ"
		size = 36
		refs = "0005 ?SafeFastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 85 C0 74 0E 48 8B 10 48 8B C8 48 83 C4 28 48 FF 62 10 83 C8 FF 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_26_32_0 {
	meta:
		name = "?GetPolicy@CurrentScheduler@Concurrency@@SA?AVSchedulerPolicy@2@XZ"
		size = 41
		refs = "000f ?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPEAV123@XZ"
	strings:
		$1 = { 40 53 48 83 EC 30 83 64 24 20 00 48 8B D9 E8 ?? ?? ?? ?? 4C 8B 00 48 8B D3 48 8B C8 41 FF 50 18 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_26_33_0 {
	meta:
		name = "?Id@CurrentScheduler@Concurrency@@SAIXZ"
		size = 36
		refs = "0005 ?SafeFastCurrentScheduler@SchedulerBase@details@Concurrency@@SAPEAV123@XZ"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 85 C0 74 0E 48 8B 10 48 8B C8 48 83 C4 28 48 FF 62 08 83 C8 FF 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_660_32_0 {
	meta:
		name = "?VirtualProcessorId@Context@Concurrency@@SAIXZ"
		size = 36
		refs = "0005 ?SafeFastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 85 C0 74 0E 48 8B 10 48 8B C8 48 83 C4 28 48 FF 62 08 83 C8 FF 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_26_34_0 {
	meta:
		name = "?IsAvailableLocation@CurrentScheduler@Concurrency@@SA_NAEBVlocation@2@@Z"
		size = 40
		refs = "000a ?SafeFastCurrentScheduler@SchedulerBase@details@Concurrency@@SAPEAV123@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C8 33 C0 48 85 C9 74 0A 4C 8B 01 48 8B D3 41 FF 50 60 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_26_35_0 {
	meta:
		name = "?RegisterShutdownEvent@CurrentScheduler@Concurrency@@SAXPEAX@Z"
		size = 65
		refs = "000a ?SafeFastCurrentScheduler@SchedulerBase@details@Concurrency@@SAPEAV123@XZ 002b ??0scheduler_not_attached@Concurrency@@QEAA@XZ 0032 _TI2?AVscheduler_not_attached@Concurrency@@ 003c _CxxThrowException"
	strings:
		$1 = { 40 53 48 83 EC 40 48 8B D9 E8 ?? ?? ?? ?? 48 85 C0 74 12 4C 8B 00 48 8B D3 48 8B C8 48 83 C4 40 5B 49 FF 60 30 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_26_36_0 {
	meta:
		name = "?ScheduleTask@CurrentScheduler@Concurrency@@SAXP6AXPEAX@Z0@Z"
		size = 47
		refs = "0011 ?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPEAV123@XZ"
		altNames = "?_ScheduleTask@_CurrentScheduler@details@Concurrency@@SAXP6AXPEAX@Z0@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 4C 8B 08 4C 8B C3 48 8B D7 48 8B C8 48 8B 5C 24 30 48 83 C4 20 5F 49 FF 61 58 }
	condition:
		$1
}

rule file_26_37_0 {
	meta:
		name = "?ScheduleTask@CurrentScheduler@Concurrency@@SAXP6AXPEAX@Z0AEAVlocation@2@@Z"
		size = 63
		refs = "0019 ?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPEAV123@XZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 49 8B D8 48 8B FA 48 8B F1 E8 ?? ?? ?? ?? 4C 8B CB 4C 8B C7 4C 8B 10 48 8B D6 48 8B C8 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F 49 FF 62 50 }
	condition:
		$1
}

rule file_26_41_0 {
	meta:
		name = "?_Get@_CurrentScheduler@details@Concurrency@@SA?AV_Scheduler@23@XZ"
		size = 26
		refs = "000a ?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPEAV123@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_26_42_0 {
	meta:
		name = "?_GetNumberOfVirtualProcessors@_CurrentScheduler@details@Concurrency@@SAIXZ"
		size = 23
		refs = "0005 ?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPEAV123@XZ"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B C8 48 8B 10 48 83 C4 28 48 FF 62 10 }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "__tzset"
		size = 59
		refs = "0006 ?first_time@?1??__tzset@@9@9 0013 _lock 0022 _tzset_nolock 0032 _unlock"
	strings:
		$1 = { 48 83 EC 28 83 3D ?? ?? ?? ?? 00 75 29 B9 06 00 00 00 E8 ?? ?? ?? ?? 90 83 3D ?? ?? ?? ?? 00 75 0B E8 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? B9 06 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_27_1_0 {
	meta:
		name = "__tzset$fin$0"
		size = 25
		refs = "0014 _unlock"
		altNames = "_isindst$fin$0 _tzset$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 06 00 00 00 48 83 C4 20 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_27_3_0 {
	meta:
		name = "_isindst"
		size = 48
		refs = "000f _lock 0018 _isindst_nolock 0024 _unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 B9 06 00 00 00 E8 ?? ?? ?? ?? 90 48 8B CB E8 ?? ?? ?? ?? 8B D8 B9 06 00 00 00 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_27_5_0 {
	meta:
		name = "_isindst_nolock"
		size = 685
		refs = "0025 _get_daylight 0061 dststart 0069 dstend 0075 tzapiused 0082 tzinfo 010a cvtdate 02a8 _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 18 48 89 70 20 57 41 56 41 57 48 83 EC 60 48 8B F1 48 8D 48 10 33 FF 89 78 10 E8 ?? ?? ?? ?? 85 C0 0F 85 67 02 00 00 39 BC 24 88 00 00 00 75 1C 33 C0 4C 8D 5C 24 60 49 8B 5B 20 49 8B 6B 30 49 8B 73 38 49 8B E3 41 5F 41 5E 5F C3 8B 6E 14 41 BF 01 00 00 00 3B 2D ?? ?? ?? ?? 75 0C 3B 2D ?? ?? ?? ?? 0F 84 9F 01 00 00 39 3D ?? ?? ?? ?? 0F 84 10 01 00 00 66 39 3D ?? ?? ?? ?? 0F B7 0D ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 0F B7 15 ?? ?? ?? ?? 44 0F B7 0D ?? ?? ?? ?? 89 44 24 50 89 4C 24 48 89 54 24 40 41 8B CF 75 2E 44 0F B7 15 ?? ?? ?? ?? 44 0F B7 1D ?? ?? ?? ?? 0F B7 1D ?? ?? ?? ?? 44 89 54 24 38 89 7C 24 30 44 89 5C 24 28 89 5C 24 20 41 8B D7 EB 24 44 0F B7 05 ?? ?? ?? ?? 44 0F B7 15 ?? ?? ?? ?? 33 D2 44 89 44 24 38 44 89 54 24 30 89 7C 24 28 89 7C 24 20 44 8B C5 E8 ?? ?? ?? ?? 0F B7 0D ?? ?? ?? ?? 44 0F B7 05 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 0F B7 15 ?? ?? ?? ?? 44 0F B7 0D ?? ?? ?? ?? 89 44 24 50 89 4C 24 48 89 54 24 40 33 C9 66 39 3D ?? ?? ?? ?? 44 89 44 24 38 44 8B 46 14 75 23 44 0F B7 15 ?? ?? ?? ?? 44 0F B7 1D ?? ?? ?? ?? 89 7C 24 30 44 89 54 24 28 44 89 5C 24 20 E9 94 00 00 00 44 0F B7 15 ?? ?? ?? ?? 33 D2 44 89 54 24 30 89 7C 24 28 89 7C 24 20 EB 7E B8 02 00 00 00 45 8B F7 8D 58 09 44 8D 48 01 83 FD 6B 7D 0F 44 8D 48 02 41 8B C7 41 8D 59 06 45 8D 71 01 89 7C 24 50 89 7C 24 48 89 7C 24 40 C7 44 24 38 02 00 00 00 89 7C 24 30 44 8B C5 41 8B D7 41 8B CF 89 7C 24 28 89 44 24 20 E8 ?? ?? ?? ?? 44 8B 46 14 89 7C 24 50 89 7C 24 48 89 7C 24 40 C7 44 24 38 02 00 00 00 89 7C 24 30 89 7C 24 28 44 89 74 24 20 44 8B CB 33 C9 41 8B D7 E8 ?? ?? ?? ?? 44 8B 0D ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 44 8B 46 1C 44 3B C9 7D 24 45 3B C1 0F 8C 09 FE FF FF 44 3B C1 0F 8F 00 FE FF FF 45 3B C1 7E 25 44 3B C1 7D 20 41 8B C7 E9 F0 FD FF FF 44 3B C1 7C F3 45 3B C1 7F EE 44 3B C1 7E 09 45 3B C1 0F 8C D6 FD FF FF 6B 4E 08 3C 03 4E 04 6B D1 3C 03 16 69 C2 E8 03 00 00 45 3B C1 75 11 3B 05 ?? ?? ?? ?? 40 0F 9D C7 8B C7 E9 B0 FD FF FF 3B 05 ?? ?? ?? ?? 40 0F 9C C7 EB ED 45 33 C9 45 33 C0 33 D2 33 C9 48 89 7C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_27_6_0 {
	meta:
		name = "_set_daylight"
		size = 21
		refs = "0009 __daylight"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 E8 ?? ?? ?? ?? 89 18 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_27_7_0 {
	meta:
		name = "_set_dstbias"
		size = 21
		refs = "0009 __dstbias"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 E8 ?? ?? ?? ?? 89 18 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_27_8_0 {
	meta:
		name = "_set_timezone"
		size = 21
		refs = "0009 __timezone"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 E8 ?? ?? ?? ?? 89 18 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_27_9_0 {
	meta:
		name = "_tzset"
		size = 36
		refs = "000a _lock 0010 _tzset_nolock 001b _unlock"
	strings:
		$1 = { 48 83 EC 28 B9 06 00 00 00 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 90 B9 06 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_27_11_0 {
	meta:
		name = "_tzset_nolock"
		size = 1121
		refs = "002d _lock 0033 __tzname 0043 _get_timezone 0058 _get_daylight 006d _get_dstbias 007a ___lc_codepage_func 0083 tzapiused 008e dstend 0095 dststart 009c ??_C@_02CLFPBFFP@TZ?$AA@ 00a1 _getenv_helper_nolock 00c2 lastTZ 00d2 strcmp 00eb free 00f3 strlen 00fc _malloc_crt 0127 strcpy_s 0143 _invoke_watson 0162 tzinfo 0168 __imp_GetTimeZoneInformation 021b __imp_WideCharToMultiByte 029b __timezone 02a9 __daylight 02b7 __dstbias 02c3 _unlock 02e5 strncpy_s 0304 atol"
	strings:
		$1 = { 48 8B C4 53 56 57 41 54 41 55 41 56 41 57 48 83 EC 50 45 33 E4 44 89 60 08 44 89 60 10 44 89 60 18 41 8B F4 45 8B FC 41 8D 4C 24 07 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 4C 8B F0 48 8D 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 ED 03 00 00 48 8D 8C 24 98 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 C4 03 00 00 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 9B 03 00 00 E8 ?? ?? ?? ?? 8B D8 44 89 25 ?? ?? ?? ?? 41 83 CD FF 44 89 2D ?? ?? ?? ?? 44 89 2D ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B F8 48 89 44 24 40 48 85 C0 0F 84 91 00 00 00 44 38 20 0F 84 88 00 00 00 48 8B 0D ?? ?? ?? ?? 48 85 C9 74 24 48 8B D1 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 84 B0 01 00 00 48 8B 0D ?? ?? ?? ?? 48 85 C9 74 05 E8 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 48 8D 48 01 E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 85 C0 0F 84 7E 01 00 00 48 8B CF E8 ?? ?? ?? ?? 48 8D 50 01 4C 8B C7 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 60 01 00 00 4C 89 64 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 85 C9 74 0C E8 ?? ?? ?? ?? 4C 89 25 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 F8 FF 0F 84 19 01 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 6B 0D ?? ?? ?? ?? 3C 89 8C 24 90 00 00 00 66 44 39 25 ?? ?? ?? ?? 74 10 6B 05 ?? ?? ?? ?? 3C 03 C8 89 8C 24 90 00 00 00 66 44 39 25 ?? ?? ?? ?? 74 27 8B 05 ?? ?? ?? ?? 85 C0 74 1D C7 84 24 98 00 00 00 01 00 00 00 2B 05 ?? ?? ?? ?? 6B C0 3C 89 84 24 A0 00 00 00 EB 10 44 89 A4 24 98 00 00 00 44 89 A4 24 A0 00 00 00 48 8D 84 24 A8 00 00 00 48 89 44 24 38 4C 89 64 24 30 BE 3F 00 00 00 89 74 24 28 49 8B 06 48 89 44 24 20 45 8B CD 4C 8D 05 ?? ?? ?? ?? 33 D2 8B CB FF 15 ?? ?? ?? ?? 85 C0 74 13 44 39 A4 24 A8 00 00 00 75 09 49 8B 06 44 88 60 3F EB 06 49 8B 06 44 88 20 48 8D 84 24 A8 00 00 00 48 89 44 24 38 4C 89 64 24 30 89 74 24 28 49 8B 46 08 48 89 44 24 20 45 8B CD 4C 8D 05 ?? ?? ?? ?? 33 D2 8B CB FF 15 ?? ?? ?? ?? 85 C0 74 14 44 39 A4 24 A8 00 00 00 75 0A 49 8B 46 08 44 88 60 3F EB 07 49 8B 46 08 44 88 20 BE 01 00 00 00 8B 9C 24 90 00 00 00 E8 ?? ?? ?? ?? 89 18 8B 9C 24 98 00 00 00 E8 ?? ?? ?? ?? 89 18 8B 9C 24 A0 00 00 00 E8 ?? ?? ?? ?? 89 18 B9 07 00 00 00 E8 ?? ?? ?? ?? 85 F6 0F 85 82 01 00 00 BE 03 00 00 00 44 8B CE 4C 8B C7 44 8D 6E 3D 41 8B D5 49 8B 0E E8 ?? ?? ?? ?? 85 C0 0F 85 0E 01 00 00 48 03 FE 80 3F 2D 75 07 44 8D 7E FE 48 FF C7 48 8B CF E8 ?? ?? ?? ?? 69 D0 10 0E 00 00 89 94 24 90 00 00 00 B3 30 8A 07 3C 2B 74 06 2A C3 3C 09 77 05 48 FF C7 EB EF 80 3F 3A 75 5C 48 FF C7 48 8B CF E8 ?? ?? ?? ?? 6B C8 3C 8B 94 24 90 00 00 00 03 D1 89 94 24 90 00 00 00 EB 07 3C 39 7F 09 48 FF C7 8A 07 3A C3 7D F3 80 3F 3A 75 2A 48 FF C7 48 8B CF E8 ?? ?? ?? ?? 8B 94 24 90 00 00 00 03 D0 89 94 24 90 00 00 00 EB 07 3C 39 7F 09 48 FF C7 8A 07 3A C3 7D F3 45 85 FF 74 09 F7 DA 89 94 24 90 00 00 00 44 38 27 74 36 C7 84 24 98 00 00 00 01 00 00 00 4C 8B CE 4C 8B C7 49 8B D5 49 8B 4E 08 E8 ?? ?? ?? ?? 85 C0 74 24 4C 89 64 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 44 89 A4 24 98 00 00 00 49 8B 46 08 44 88 20 8B 9C 24 90 00 00 00 E8 ?? ?? ?? ?? 89 18 8B 9C 24 98 00 00 00 E8 ?? ?? ?? ?? 89 18 EB 52 4C 89 64 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 90 4C 89 64 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 4C 89 64 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 4C 89 64 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 90 48 83 C4 50 41 5F 41 5E 41 5D 41 5C 5F 5E 5B C3 }
	condition:
		$1
}

rule file_27_12_0 {
	meta:
		name = "_tzset_nolock$fin$0"
		size = 27
		refs = "000f _unlock"
	strings:
		$1 = { 40 55 48 83 EC 40 48 8B EA B9 07 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 40 5D C3 CC }
	condition:
		$1
}

rule file_27_13_0 {
	meta:
		name = "cvtdate"
		size = 714
		refs = "007d __ImageBase 0088 _days 009c _lpdays 0235 dststart 0260 dstend 026b _get_dstbias 02c5 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 56 57 41 56 48 83 EC 30 83 64 24 50 00 41 8B D8 44 8B F1 83 FA 01 0F 85 65 01 00 00 44 8B DB 41 81 E3 03 00 00 80 7D 0A 41 FF CB 41 83 CB FC 41 FF C3 BE 1F 85 EB 51 45 85 DB 75 15 8B C6 F7 EB C1 FA 05 8B C2 C1 E8 1F 03 D0 6B CA 64 3B D9 75 33 41 8D 88 6C 07 00 00 8B C6 F7 E9 C1 FA 07 8B C2 C1 E8 1F 03 D0 69 C2 90 01 00 00 3B C8 74 14 48 8D 3D ?? ?? ?? ?? 49 63 E9 44 8B 94 AF ?? ?? ?? ?? EB 12 48 8D 3D ?? ?? ?? ?? 49 63 E9 44 8B 94 AF ?? ?? ?? ?? 41 FF C8 8D 8B 2B 01 00 00 8B C6 41 FF C2 F7 E9 8B 4C 24 70 44 8B CA 41 C1 F9 07 41 8B C1 C1 E8 1F 44 03 C8 8B C6 41 F7 E8 C1 FA 05 8B C2 C1 E8 1F 03 D0 41 8B C0 44 2B CA 99 83 E2 03 44 8D 04 02 69 C3 6D 01 00 00 05 25 9C FF FF 41 C1 F8 02 45 03 C2 45 03 C1 44 03 C0 B8 93 24 49 92 41 F7 E8 41 03 D0 C1 FA 02 8B C2 C1 E8 1F 03 D0 6B C2 07 8B 54 24 78 44 2B C0 6B C1 07 41 2B C0 44 3B C2 7F 03 83 C0 F9 03 C2 44 03 D0 83 F9 05 0F 85 D2 00 00 00 45 85 DB 75 15 8B C6 F7 EB C1 FA 05 8B CA C1 E9 1F 03 D1 6B D2 64 3B DA 75 27 8D 8B 6C 07 00 00 8B C6 F7 E9 C1 FA 07 8B C2 C1 E8 1F 03 D0 69 C2 90 01 00 00 3B C8 74 09 8B 84 AF ?? ?? ?? ?? EB 07 8B 84 AF ?? ?? ?? ?? 44 3B D0 0F 8E 81 00 00 00 41 83 EA 07 EB 7B 8B C3 25 03 00 00 80 7D 07 FF C8 83 C8 FC FF C0 BE 1F 85 EB 51 85 C0 75 15 8B C6 F7 EB C1 FA 05 8B C2 C1 E8 1F 03 D0 6B CA 64 3B D9 75 33 41 8D 88 6C 07 00 00 8B C6 F7 E9 C1 FA 07 8B C2 C1 E8 1F 03 D0 69 C2 90 01 00 00 3B C8 74 14 48 8D 3D ?? ?? ?? ?? 49 63 C1 44 8B 94 87 ?? ?? ?? ?? EB 12 48 8D 3D ?? ?? ?? ?? 49 63 C1 44 8B 94 87 ?? ?? ?? ?? 44 03 94 24 80 00 00 00 6B 84 24 88 00 00 00 3C 03 84 24 90 00 00 00 6B C8 3C 03 8C 24 98 00 00 00 69 C1 E8 03 00 00 03 84 24 A0 00 00 00 41 83 FE 01 75 26 44 89 15 ?? ?? ?? ?? 89 05 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 48 8B 5C 24 58 48 8B 6C 24 60 48 83 C4 30 41 5E 5F 5E C3 48 8D 4C 24 50 44 89 15 ?? ?? ?? ?? 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 41 69 44 24 50 E8 03 00 00 8B 0D ?? ?? ?? ?? 03 C8 B8 00 5C 26 05 89 0D ?? ?? ?? ?? 79 0A 03 C8 FF 0D ?? ?? ?? ?? EB 0C 3B C8 7C 0E 2B C8 FF 05 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 1D ?? ?? ?? ?? EB 91 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "_log10_special"
		size = 32
		refs = "0007 ??_C@_05HGHHAHAP@log10?$AA@ 0017 _log_special_common"
	strings:
		$1 = { 48 83 EC 38 48 8D 05 ?? ?? ?? ?? 41 B9 1B 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "_log10f_special"
		size = 32
		refs = "0007 ??_C@_06KDGOKGLH@log10f?$AA@ 0017 _logf_special_common"
	strings:
		$1 = { 48 83 EC 38 48 8D 05 ?? ?? ?? ?? 41 B9 1B 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_28_2_0 {
	meta:
		name = "_log_special"
		size = 32
		refs = "0007 ??_C@_03MGHMBJCF@log?$AA@ 0017 _log_special_common"
	strings:
		$1 = { 48 83 EC 38 48 8D 05 ?? ?? ?? ?? 41 B9 1A 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_28_4_0 {
	meta:
		name = "_logf_special"
		size = 32
		refs = "0007 ??_C@_04HIGFGEHP@logf?$AA@ 0017 _logf_special_common"
	strings:
		$1 = { 48 83 EC 38 48 8D 05 ?? ?? ?? ?? 41 B9 1A 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_28_3_0 {
	meta:
		name = "_log_special_common"
		size = 201
		refs = "00b8 _handle_error"
	strings:
		$1 = { 48 8B C4 48 83 EC 68 0F 29 70 E8 41 8B D1 0F 28 D0 0F 28 F1 41 FF C8 74 5E 41 FF C8 74 30 41 FF C8 0F 85 95 00 00 00 C7 40 D8 01 00 00 00 0F 57 C0 F2 0F 11 40 D0 F2 0F 11 50 C8 C7 40 C0 21 00 00 00 44 21 40 B8 41 B9 01 00 00 00 EB 56 C7 44 24 40 01 00 00 00 0F 57 C0 F2 0F 11 44 24 38 F2 0F 11 54 24 30 C7 44 24 28 21 00 00 00 C7 44 24 20 08 00 00 00 EB CF C7 44 24 40 01 00 00 00 0F 57 C0 41 B9 02 00 00 00 F2 0F 11 44 24 38 F2 0F 11 54 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 04 00 00 00 48 8B 8C 24 90 00 00 00 F2 0F 11 4C 24 78 4C 8B 44 24 78 E8 ?? ?? ?? ?? 0F 28 C6 0F 28 74 24 50 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_28_5_0 {
	meta:
		name = "_logf_special_common"
		size = 274
		refs = "0101 _handle_errorf"
	strings:
		$1 = { 48 83 EC 78 0F 29 74 24 60 41 8B D1 0F 28 D0 0F 28 F1 41 FF C8 0F 84 A0 00 00 00 41 FF C8 74 6E 41 FF C8 0F 85 DC 00 00 00 48 83 64 24 50 00 41 8D 48 01 F3 0F 11 94 24 88 00 00 00 8B 84 24 88 00 00 00 89 4C 24 40 0F 57 C0 F3 0F 11 74 24 50 4C 8B 44 24 50 C1 E8 16 F3 0F 11 44 24 38 F3 0F 11 54 24 30 F7 D0 44 8B C9 C7 44 24 28 21 00 00 00 84 C1 48 8B 8C 24 A0 00 00 00 74 0A C7 44 24 20 08 00 00 00 EB 79 83 64 24 20 00 EB 72 B9 01 00 00 00 0F 57 C0 89 4C 24 40 44 8B C9 F3 0F 11 44 24 38 F3 0F 11 54 24 30 C7 44 24 28 21 00 00 00 C7 44 24 20 08 00 00 00 EB 2C B9 01 00 00 00 0F 57 C0 89 4C 24 40 44 8D 49 01 F3 0F 11 44 24 38 F3 0F 11 54 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 04 00 00 00 48 83 64 24 50 00 48 8B 8C 24 A0 00 00 00 F3 0F 11 74 24 50 4C 8B 44 24 50 E8 ?? ?? ?? ?? 0F 28 C6 0F 28 74 24 60 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_29_1_0 {
	meta:
		name = "_wsetenvp"
		size = 312
		refs = "001c _wenvptr 003f wcslen 005f _calloc_crt 0069 _wenviron 00b2 wcscpy_s 00d6 free 00e6 __env_initialized 0133 _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 30 48 8B 1D ?? ?? ?? ?? 45 33 F6 41 8B FE 48 85 DB 75 20 83 C8 FF E9 BD 00 00 00 66 83 F8 3D 74 02 FF C7 48 8B CB E8 ?? ?? ?? ?? 48 8D 1C 43 48 83 C3 02 0F B7 03 66 85 C0 75 E0 8D 47 01 BA 08 00 00 00 48 63 C8 E8 ?? ?? ?? ?? 48 8B F8 48 89 05 ?? ?? ?? ?? 48 85 C0 74 B9 48 8B 1D ?? ?? ?? ?? 66 44 39 33 74 53 48 8B CB E8 ?? ?? ?? ?? 66 83 3B 3D 8D 70 01 74 2E 48 63 EE BA 02 00 00 00 48 8B CD E8 ?? ?? ?? ?? 48 89 07 48 85 C0 74 63 4C 8B C3 48 8B D5 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 69 48 83 C7 08 48 63 C6 48 8D 1C 43 66 44 39 33 75 B4 48 8B 1D ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 4C 89 35 ?? ?? ?? ?? 4C 89 37 C7 05 ?? ?? ?? ?? 01 00 00 00 33 C0 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 30 41 5E C3 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 89 35 ?? ?? ?? ?? E9 08 FF FF FF 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 74 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "_stat32i64"
		size = 85
		refs = "001f __copy_path_to_wide_string 0038 _wstat32i64 0044 free"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 20 33 DB 48 8B FA 48 89 5C 24 30 48 85 C9 74 18 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 1E 48 8B 5C 24 30 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 48 8B 4C 24 30 8B D8 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_698_0_0 {
	meta:
		name = "_stat32"
		size = 85
		refs = "001f __copy_path_to_wide_string 0038 _wstat32 0044 free"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 20 33 DB 48 8B FA 48 89 5C 24 30 48 85 C9 74 18 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 1E 48 8B 5C 24 30 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 48 8B 4C 24 30 8B D8 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_454_0_0 {
	meta:
		name = "_stat64"
		size = 85
		refs = "001f __copy_path_to_wide_string 0038 _wstat64 0044 free"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 20 33 DB 48 8B FA 48 89 5C 24 30 48 85 C9 74 18 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 1E 48 8B 5C 24 30 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 48 8B 4C 24 30 8B D8 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1129_0_0 {
	meta:
		name = "_stat64i32"
		size = 85
		refs = "001f __copy_path_to_wide_string 0038 _wstat64i32 0044 free"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 20 33 DB 48 8B FA 48 89 5C 24 30 48 85 C9 74 18 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 1E 48 8B 5C 24 30 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 48 8B 4C 24 30 8B D8 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "_wcreat"
		size = 55
		refs = "0024 _wsopen_s"
	strings:
		$1 = { 40 53 48 83 EC 30 83 CB FF 89 54 24 20 48 8B D1 48 8D 4C 24 50 44 8D 4B 41 41 B8 02 03 00 00 89 5C 24 50 E8 ?? ?? ?? ?? 85 C0 0F 44 5C 24 50 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_656_0_0 {
	meta:
		name = "_creat"
		size = 55
		refs = "0024 _sopen_s"
	strings:
		$1 = { 40 53 48 83 EC 30 83 CB FF 89 54 24 20 48 8B D1 48 8D 4C 24 50 44 8D 4B 41 41 B8 02 03 00 00 89 5C 24 50 E8 ?? ?? ?? ?? 85 C0 0F 44 5C 24 50 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_34_8_0 {
	meta:
		name = "??0?$_MallocaArrayHolder@PEAVContext@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 24
		refs = "000d ??_7?$_MallocaArrayHolder@PEAVContext@Concurrency@@@details@Concurrency@@6B@"
	strings:
		$1 = { 48 83 61 08 00 48 83 61 10 00 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_118_204_1 {
	meta:
		name = "??0?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 24
		refs = "000d ??_7?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@6B@"
	strings:
		$1 = { 48 83 61 08 00 48 83 61 10 00 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_118_205_1 {
	meta:
		name = "??0?$_AnonymousOriginator@_K@details@Concurrency@@QEAA@XZ"
		size = 24
		refs = "000d ??_7?$_AnonymousOriginator@_K@details@Concurrency@@6B@"
	strings:
		$1 = { 48 83 61 08 00 48 83 61 10 00 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_619_11_0 {
	meta:
		name = "??0?$_MallocaArrayHolder@PEAVevent@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 24
		refs = "000d ??_7?$_MallocaArrayHolder@PEAVevent@Concurrency@@@details@Concurrency@@6B@"
	strings:
		$1 = { 48 83 61 08 00 48 83 61 10 00 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_34_12_0 {
	meta:
		name = "??0MultiWaitBlock@details@Concurrency@@QEAA@_K_N1@Z"
		size = 156
		refs = "001d ??_7WaitBlock@details@Concurrency@@6B@ 0038 ?CurrentContext@Context@Concurrency@@SAPEAV12@XZ 004d ??_7MultiWaitBlock@details@Concurrency@@6B@"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 56 48 83 EC 20 48 83 61 08 00 48 8D 05 ?? ?? ?? ?? 41 8A D9 48 89 01 C7 41 10 00 00 00 00 41 8A F0 48 8B FA 4C 8B F1 E8 ?? ?? ?? ?? 49 83 66 18 00 49 83 66 20 00 49 89 46 08 48 8D 05 ?? ?? ?? ?? 41 88 76 50 48 8B 74 24 38 49 89 06 33 C0 84 DB 48 8B 5C 24 30 41 C7 46 28 00 00 00 00 0F 95 C0 48 03 C7 48 8B 7C 24 40 49 89 46 30 49 C7 46 40 00 00 00 00 49 C7 46 48 00 00 00 00 41 C6 46 51 00 49 8B C6 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_34_13_0 {
	meta:
		name = "??0MultiWaitBlockHolder@details@Concurrency@@QEAA@_N_K00@Z"
		size = 262
		refs = "004b ??_U@YAPEAX_K@Z 0079 ??0MultiWaitBlock@details@Concurrency@@QEAA@_K_N1@Z 0080 ??_7WaitAllBlock@details@Concurrency@@6B@ 00aa ??_7WaitAnyBlock@details@Concurrency@@6B@"
	strings:
		$1 = { 48 8B C4 48 89 48 08 56 57 41 56 48 83 EC 30 48 C7 40 D8 FE FF FF FF 48 89 58 10 48 89 68 20 45 8A F1 49 8B E8 8A DA 48 8B F1 48 83 61 28 00 48 C7 01 60 00 00 00 48 C7 41 08 10 00 00 00 49 8D 48 06 48 C1 E1 04 48 89 4E 10 E8 ?? ?? ?? ?? 48 8B F8 48 89 46 18 48 89 46 20 48 89 44 24 60 84 DB 74 2A 8A 5C 24 70 48 85 C0 74 1F 44 8A CB 45 8A C6 48 8B D5 48 8B C8 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 07 48 89 6F 38 EB 2C 8A 5C 24 70 48 85 C0 74 23 44 8A CB 45 8A C6 48 8B D5 48 8B C8 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 07 48 C7 47 38 01 00 00 00 48 8B 0E 48 03 4E 18 48 85 ED 74 19 48 8B D5 48 85 C9 74 08 48 8B 46 20 48 89 41 08 48 03 4E 08 48 FF CA 75 EA F6 DB 48 1B C0 48 F7 D8 48 FF C5 48 03 C5 48 89 46 30 48 8B C6 48 8B 5C 24 58 48 8B 6C 24 68 48 83 C4 30 41 5E 5F 5E C3 }
	condition:
		$1
}

rule file_34_14_0 {
	meta:
		name = "?dtor$0@?0???0MultiWaitBlockHolder@details@Concurrency@@QEAA@_N_K00@Z@4HA"
		size = 35
		refs = "0019 ??3@YAXPEAX0@Z"
		altNames = "?dtor$1@?0???0MultiWaitBlockHolder@details@Concurrency@@QEAA@_N_K00@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 55 50 48 83 C2 18 48 8B 12 48 8B 4D 60 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_34_16_0 {
	meta:
		name = "??0SingleWaitBlock@details@Concurrency@@QEAA@XZ"
		size = 59
		refs = "000e ??_7WaitBlock@details@Concurrency@@6B@ 0020 ?CurrentContext@Context@Concurrency@@SAPEAV12@XZ 002b ??_7SingleWaitBlock@details@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 83 61 08 00 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 C7 41 10 00 00 00 00 E8 ?? ?? ?? ?? 48 89 43 08 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_34_17_0 {
	meta:
		name = "??0TimedSingleWaitBlock@details@Concurrency@@QEAA@_N@Z"
		size = 100
		refs = "0012 ??_7WaitBlock@details@Concurrency@@6B@ 0026 ?CurrentContext@Context@Concurrency@@SAPEAV12@XZ 0031 ??_7TimedSingleWaitBlock@details@Concurrency@@6B@"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 83 61 08 00 48 8D 05 ?? ?? ?? ?? 8A DA 48 89 01 C7 41 10 00 00 00 00 48 8B F9 E8 ?? ?? ?? ?? 48 89 47 08 48 8D 05 ?? ?? ?? ?? 48 89 07 48 83 67 20 00 88 5F 30 48 8B 5C 24 30 C7 47 34 00 00 00 00 C7 47 38 00 00 00 00 C6 47 3C 00 48 89 7F 20 48 8B C7 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_34_19_0 {
	meta:
		name = "??0WaitAllBlock@details@Concurrency@@QEAA@_K_N1@Z"
		size = 49
		refs = "0011 ??0MultiWaitBlock@details@Concurrency@@QEAA@_K_N1@Z 0018 ??_7WaitAllBlock@details@Concurrency@@6B@"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 07 48 89 5F 38 48 8B 5C 24 30 48 8B C7 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_34_20_0 {
	meta:
		name = "??0WaitAnyBlock@details@Concurrency@@QEAA@_K_N1@Z"
		size = 41
		refs = "000a ??0MultiWaitBlock@details@Concurrency@@QEAA@_K_N1@Z 0011 ??_7WaitAnyBlock@details@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 C7 43 38 01 00 00 00 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_34_21_0 {
	meta:
		name = "??0WaitBlock@details@Concurrency@@QEAA@XZ"
		size = 49
		refs = "000e ??_7WaitBlock@details@Concurrency@@6B@ 0020 ?CurrentContext@Context@Concurrency@@SAPEAV12@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 83 61 08 00 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 C7 41 10 00 00 00 00 E8 ?? ?? ?? ?? 48 89 43 08 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_34_22_0 {
	meta:
		name = "??0_Condition_variable@details@Concurrency@@QEAA@XZ"
		size = 34
		refs = "0015 ??0critical_section@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 C7 01 00 00 00 00 48 83 C1 08 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_34_24_0 {
	meta:
		name = "??0bad_alloc@std@@QEAA@XZ"
		size = 56
		refs = "0009 ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 0021 ??0exception@std@@QEAA@AEBQEBDH@Z 0028 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8D 54 24 30 41 B8 01 00 00 00 48 89 44 24 30 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_34_26_0 {
	meta:
		name = "??0event@Concurrency@@QEAA@XZ"
		size = 39
		refs = "001a ??0critical_section@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 83 61 08 00 48 8B D9 48 C7 01 00 00 00 00 48 83 C1 10 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_34_28_0 {
	meta:
		name = "??0invalid_argument@std@@QEAA@PEBD@Z"
		size = 43
		refs = "0014 ??0exception@std@@QEAA@AEBQEBD@Z 001b ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 89 54 24 30 48 8D 54 24 30 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_620_39_0 {
	meta:
		name = "??0length_error@std@@QEAA@PEBD@Z"
		size = 43
		refs = "0014 ??0exception@std@@QEAA@AEBQEBD@Z 001b ??_7length_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 89 54 24 30 48 8D 54 24 30 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_22_40_1 {
	meta:
		name = "??0out_of_range@std@@QEAA@PEBD@Z"
		size = 43
		refs = "0014 ??0exception@std@@QEAA@AEBQEBD@Z 001b ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 89 54 24 30 48 8D 54 24 30 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_22_42_1 {
	meta:
		name = "??0overflow_error@std@@QEAA@PEBD@Z"
		size = 43
		refs = "0014 ??0exception@std@@QEAA@AEBQEBD@Z 001b ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 89 54 24 30 48 8D 54 24 30 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_75_60_1 {
	meta:
		name = "??0range_error@std@@QEAA@PEBD@Z"
		size = 43
		refs = "0014 ??0exception@std@@QEAA@AEBQEBD@Z 001b ??_7range_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 89 54 24 30 48 8D 54 24 30 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_34_30_0 {
	meta:
		name = "??0logic_error@std@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7logic_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_9_0 {
	meta:
		name = "??0_Interruption_exception@details@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7_Interruption_exception@details@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_645_3_0 {
	meta:
		name = "??0bad_cast@std@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_273_2_0 {
	meta:
		name = "??0bad_exception@std@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_11_0 {
	meta:
		name = "??0bad_target@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_645_5_0 {
	meta:
		name = "??0bad_typeid@std@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_14_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_16_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_18_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_20_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_22_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_24_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_26_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_28_0 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_30_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_32_0 {
	meta:
		name = "??0invalid_operation@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_34_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_36_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_38_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_40_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_42_0 {
	meta:
		name = "??0message_not_found@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_44_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_46_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_48_0 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_0_103_2 {
	meta:
		name = "??0runtime_error@std@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_50_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_56_0 {
	meta:
		name = "??0task_canceled@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7task_canceled@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_459_58_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QEAA@PEBD@Z"
		size = 42
		refs = "0013 ??0exception@std@@QEAA@AEBQEBD@Z 001a ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 53 48 83 EC 20 48 8D 54 24 38 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_34_31_0 {
	meta:
		name = "??1?$_MallocaArrayHolder@PEAVContext@Concurrency@@@details@Concurrency@@UEAA@XZ"
		size = 45
		refs = "0007 ??_7?$_MallocaArrayHolder@PEAVContext@Concurrency@@@details@Concurrency@@6B@ 0024 free"
	strings:
		$1 = { 48 83 EC 28 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B 49 08 48 85 C9 74 11 48 83 E9 10 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_619_40_0 {
	meta:
		name = "??1?$_MallocaArrayHolder@PEAVevent@Concurrency@@@details@Concurrency@@UEAA@XZ"
		size = 45
		refs = "0007 ??_7?$_MallocaArrayHolder@PEAVevent@Concurrency@@@details@Concurrency@@6B@ 0024 free"
	strings:
		$1 = { 48 83 EC 28 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B 49 08 48 85 C9 74 11 48 83 E9 10 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_34_33_0 {
	meta:
		name = "??1MultiWaitBlockHolder@details@Concurrency@@QEAA@XZ"
		size = 52
		refs = "001c ?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 41 30 48 8B D9 48 39 41 28 73 17 48 8B 4B 20 48 FF 43 28 E8 ?? ?? ?? ?? 48 8B 43 30 48 39 43 28 72 E9 48 FF 43 28 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_34_35_0 {
	meta:
		name = "??1_Condition_variable@details@Concurrency@@QEAA@XZ"
		size = 64
		refs = "0020 ?_Flush_current_owner@critical_section@Concurrency@@QEAAXXZ 0028 ?notify_all@_Condition_variable@details@Concurrency@@QEAAXXZ 003c ??1critical_section@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 48 48 8B F9 48 83 C1 08 E8 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4F 08 48 8B 5C 24 48 48 83 C4 30 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_36_0 {
	meta:
		name = "?dtor$0@?0???1_Condition_variable@details@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1critical_section@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_264_2 {
	meta:
		name = "?dtor$0@?0???0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QEAA@PEAV?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@1@_K@Z@4HA"
		size = 16
		refs = "000c ??1?$_Dynamic_array@PEAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_266_2 {
	meta:
		name = "?dtor$0@?0???0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@@Concurrency@@QEAA@PEAV?$source_link_manager@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@@1@_K@Z@4HA"
		size = 16
		refs = "000c ??1?$_Dynamic_array@PEAV?$ISource@_K@Concurrency@@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_326_2 {
	meta:
		name = "?dtor$0@?0???0?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1?$concurrent_queue@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_328_2 {
	meta:
		name = "?dtor$0@?0???0?$ordered_message_processor@_K@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1?$concurrent_queue@PEAV?$message@_K@Concurrency@@V?$allocator@PEAV?$message@_K@Concurrency@@@std@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1095_13_0 {
	meta:
		name = "?dtor$0@?0???0Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEAA@PEAVSchedulerBase@23@AEBVQuickBitSet@23@II@Z@4HA"
		size = 16
		refs = "000c ??1QuickBitSet@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_581_1 {
	meta:
		name = "?dtor$0@?0???0_ExceptionHolder@details@Concurrency@@QEAA@AEBVexception_ptr@std@@AEBV_TaskCreationCallstack@12@@Z@4HA"
		size = 16
		refs = "000c ??1exception_ptr@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_391_2 {
	meta:
		name = "?dtor$0@?0???0agent@Concurrency@@QEAA@AEAVScheduler@1@@Z@4HA"
		size = 16
		refs = "000c ??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_393_1 {
	meta:
		name = "?dtor$0@?0???0agent@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1106_52_0 {
	meta:
		name = "?dtor$0@?0???1?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1QuickBitSet@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_441_1 {
	meta:
		name = "?dtor$0@?0???1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "000c ??1?$_Dynamic_array@PEAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_443_2 {
	meta:
		name = "?dtor$0@?0???1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "000c ??1?$_Dynamic_array@PEAV?$ISource@_K@Concurrency@@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_478_2 {
	meta:
		name = "?dtor$0@?0???1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "000c ??1?$concurrent_queue@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_484_1 {
	meta:
		name = "?dtor$0@?0???1?$ordered_message_processor@_K@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "000c ??1?$concurrent_queue@PEAV?$message@_K@Concurrency@@V?$allocator@PEAV?$message@_K@Concurrency@@@std@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1218_21_0 {
	meta:
		name = "?dtor$0@?0???1UMSSchedulerProxy@details@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1SchedulerProxy@details@Concurrency@@IEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_693_2 {
	meta:
		name = "?dtor$0@?0???1_ExceptionHolder@details@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1exception_ptr@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_562_2 {
	meta:
		name = "?dtor$0@?0???1agent@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "000c ??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_657_1 {
	meta:
		name = "?dtor$0@?0???_G?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UEAAPEAXI@Z@4HA"
		size = 16
		refs = "000c ??1?$_Dynamic_array@PEAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_659_1 {
	meta:
		name = "?dtor$0@?0???_G?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@@Concurrency@@UEAAPEAXI@Z@4HA"
		size = 16
		refs = "000c ??1?$_Dynamic_array@PEAV?$ISource@_K@Concurrency@@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_364_2 {
	meta:
		name = "?dtor$1@?0???0?$target_block@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1?$source_link_manager@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_545_1 {
	meta:
		name = "?dtor$1@?0???1?$target_block@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "000c ??1?$source_link_manager@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1369_95_0 {
	meta:
		name = "?dtor$1@?0???1SchedulerBase@details@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "000c ??1SchedulerPolicy@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_39_0 {
	meta:
		name = "??1event@Concurrency@@QEAA@XZ"
		size = 151
		refs = "0028 ?_Flush_current_owner@critical_section@Concurrency@@QEAAXXZ 0093 ??1critical_section@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 48 89 48 08 57 48 83 EC 30 48 C7 40 E8 FE FF FF FF 48 89 58 10 48 89 68 18 48 89 70 20 48 8B F9 48 83 C1 10 E8 ?? ?? ?? ?? 48 8B 1F 48 83 FB 01 76 27 48 8B 2B 48 8B 4B 08 48 8B 01 4C 8B C3 33 D2 FF 10 84 C0 74 0A 48 8B 4B 08 48 8B 01 FF 50 10 48 8B DD 48 85 ED 75 D9 48 8B 4F 08 48 85 C9 74 15 48 8B 19 48 8B 49 08 48 8B 01 FF 50 10 48 8B CB 48 85 DB 75 EB 48 8D 4F 10 48 8B 5C 24 48 48 8B 6C 24 50 48 8B 74 24 58 48 83 C4 30 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_40_0 {
	meta:
		name = "?dtor$0@?0???1event@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1critical_section@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 10 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_559_16_0 {
	meta:
		name = "?dtor$0@?0???0SchedulingNode@details@Concurrency@@QEAA@AEBVQuickBitSet@12@KPEAVSchedulingRing@12@@Z@4HA"
		size = 16
		refs = "000c ??1QuickBitSet@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 10 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_832_34_0 {
	meta:
		name = "?dtor$0@?0???1InternalContextBase@details@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "000c ??1ContextBase@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 10 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_559_26_0 {
	meta:
		name = "?dtor$0@?0???1SchedulingNode@details@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1QuickBitSet@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 10 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_757_1 {
	meta:
		name = "?dtor$0@?0???1_Task_impl_base@details@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "000c ??1?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 10 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_270_1 {
	meta:
		name = "?dtor$1@?0???0?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1event@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 10 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_273_1 {
	meta:
		name = "?dtor$1@?0???0?$_SyncOriginator@_K@details@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1event@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 10 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_687_1 {
	meta:
		name = "?dtor$1@?0???1?$_RunAnyParam@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1cancellation_token_source@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 10 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_53_0 {
	meta:
		name = "??_G?$_MallocaArrayHolder@PEAVContext@Concurrency@@@details@Concurrency@@UEAAPEAXI@Z"
		size = 79
		refs = "000d ??_7?$_MallocaArrayHolder@PEAVContext@Concurrency@@@details@Concurrency@@6B@ 002f free 003d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 8B FA 48 89 01 48 8B 49 08 48 85 C9 74 11 48 83 E9 10 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 40 F6 C7 01 74 08 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_619_70_0 {
	meta:
		name = "??_G?$_MallocaArrayHolder@PEAVevent@Concurrency@@@details@Concurrency@@UEAAPEAXI@Z"
		size = 79
		refs = "000d ??_7?$_MallocaArrayHolder@PEAVevent@Concurrency@@@details@Concurrency@@6B@ 002f free 003d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 8B FA 48 89 01 48 8B 49 08 48 85 C9 74 11 48 83 E9 10 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 40 F6 C7 01 74 08 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_34_54_0 {
	meta:
		name = "??_Gbad_alloc@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7bad_alloc@std@@6B@ 001a ??1exception@std@@UEAA@XZ 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_115_129_1 {
	meta:
		name = "??_G?$basic_ios@DU?$char_traits@D@std@@@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7ios_base@std@@6B@ 001a ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_21_109_2 {
	meta:
		name = "??_G?$basic_ios@GU?$char_traits@G@std@@@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7ios_base@std@@6B@ 001a ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_111_109_2 {
	meta:
		name = "??_G?$basic_ios@_WU?$char_traits@_W@std@@@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7ios_base@std@@6B@ 001a ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_392_52_0 {
	meta:
		name = "??_GFreeThreadProxy@details@Concurrency@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7FreeThreadProxy@details@Concurrency@@6B@ 001a ??1ThreadProxy@details@Concurrency@@UEAA@XZ 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_96_24_0 {
	meta:
		name = "??_GThreadVirtualProcessor@details@Concurrency@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7ThreadVirtualProcessor@details@Concurrency@@6B@ 001a ??1VirtualProcessor@details@Concurrency@@UEAA@XZ 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_645_15_0 {
	meta:
		name = "??_G__non_rtti_object@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7exception@std@@6B@ 001a ?_Tidy@exception@std@@AEAAXXZ 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_645_16_0 {
	meta:
		name = "??_Gbad_cast@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7exception@std@@6B@ 001a ?_Tidy@exception@std@@AEAAXXZ 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_273_4_0 {
	meta:
		name = "??_Gbad_exception@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7bad_exception@std@@6B@ 001a ??1exception@std@@UEAA@XZ 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_645_17_0 {
	meta:
		name = "??_Gbad_typeid@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7exception@std@@6B@ 001a ?_Tidy@exception@std@@AEAAXXZ 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_645_18_0 {
	meta:
		name = "??_Gexception@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7exception@std@@6B@ 001a ?_Tidy@exception@std@@AEAAXXZ 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_57_125_2 {
	meta:
		name = "??_Gios_base@std@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7ios_base@std@@6B@ 001a ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1118_5_0 {
	meta:
		name = "??_Gtype_info@@UEAAPEAXI@Z"
		size = 57
		refs = "000d ??_7type_info@@6B@ 001a ?_Type_info_dtor@type_info@@CAXPEAV1@@Z 0027 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B DA 48 8B F9 48 89 01 E8 ?? ?? ?? ?? F6 C3 01 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_34_60_0 {
	meta:
		name = "?Destroy@TimedSingleWaitBlock@details@Concurrency@@UEAAXXZ"
		size = 31
		refs = "0016 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 83 EC 28 B8 01 00 00 00 F0 0F C1 41 34 FF C0 83 F8 02 75 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_34_63_0 {
	meta:
		name = "?DispatchEventTimer@MultiWaitBlock@details@Concurrency@@SAXPEAU_TP_CALLBACK_INSTANCE@@PEAXPEAU_TP_TIMER@@@Z"
		size = 120
		refs = "004f ?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QEAAXXZ 005f ?UnRegisterAsyncTimerAndUnloadLibrary@details@Concurrency@@YAXPEAU_TP_CALLBACK_INSTANCE@@PEAU_TP_TIMER@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 49 8B F0 48 8B DA 48 8B E9 40 32 FF B8 01 00 00 00 F0 0F C1 42 28 FF C0 83 F8 01 75 1A 48 8B 4A 08 40 8A F8 88 42 51 48 85 C9 74 0B 48 83 62 18 00 48 8B 01 FF 50 18 48 8B CB E8 ?? ?? ?? ?? 40 84 FF 74 0B 48 8B D6 48 8B CD E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_34_64_0 {
	meta:
		name = "?DispatchEventTimer@TimedSingleWaitBlock@details@Concurrency@@SAXPEAU_TP_CALLBACK_INSTANCE@@PEAXPEAU_TP_TIMER@@@Z"
		size = 58
		refs = "002b ?UnRegisterAsyncTimerAndUnloadLibrary@details@Concurrency@@YAXPEAU_TP_CALLBACK_INSTANCE@@PEAU_TP_TIMER@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 02 4C 8B CA 49 8B D8 48 8B F9 45 33 C0 33 D2 49 8B C9 FF 10 84 C0 74 0B 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_34_65_0 {
	meta:
		name = "?DispatchEventTimerXP@MultiWaitBlock@details@Concurrency@@SAXPEAXE@Z"
		size = 95
		refs = "0023 ?GetSharedTimerQueue@details@Concurrency@@YAPEAXXZ 0032 ?__DeleteTimerQueueTimer@platform@details@Concurrency@@YAXPEAX00@Z 005b ?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B D9 B8 01 00 00 00 F0 0F C1 41 28 FF C0 83 F8 01 75 2F 48 8B 79 08 E8 ?? ?? ?? ?? 48 8B 53 20 48 8B C8 45 33 C0 E8 ?? ?? ?? ?? C6 43 51 01 48 85 FF 74 0E 48 83 63 18 00 48 8B 07 48 8B CF FF 50 18 48 8B CB 48 8B 5C 24 30 48 83 C4 20 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_67_0 {
	meta:
		name = "?GetIndexOfNode@MultiWaitBlockHolder@details@Concurrency@@QEBA_KPEAVEventWaitNode@23@@Z"
		size = 17
	strings:
		$1 = { 48 8B C2 33 D2 48 2B 41 18 48 2B 01 48 F7 71 08 C3 }
	condition:
		$1
}

rule file_34_68_0 {
	meta:
		name = "?GetSharedTimerQueue@details@Concurrency@@YAPEAXXZ"
		size = 200
		refs = "0009 ?g_hTimerQueue@details@Concurrency@@3REAXEA 0019 ?g_TimerQueueDemandInit@details@Concurrency@@3JC 0021 __imp_CreateTimerQueue 0048 ?_UnderlyingYield@details@Concurrency@@YAXXZ 0063 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ 008f ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 00a6 ??0exception@std@@QEAA@AEBQEBDH@Z 00ad ??_7bad_alloc@std@@6B@ 00b4 _TI2?AVbad_alloc@std@@ 00c3 _CxxThrowException"
	strings:
		$1 = { 40 53 48 83 EC 50 48 8B 05 ?? ?? ?? ?? 48 85 C0 75 6D 8D 58 01 F0 0F B1 1D ?? ?? ?? ?? 75 21 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 85 C0 75 3B 87 05 ?? ?? ?? ?? EB 33 83 64 24 28 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 30 EB 14 8B 05 ?? ?? ?? ?? 3B C3 75 16 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 85 C0 74 E0 48 8B 05 ?? ?? ?? ?? 48 85 C0 74 0D 48 8B 05 ?? ?? ?? ?? 48 83 C4 50 5B C3 48 8D 05 ?? ?? ?? ?? 48 8D 54 24 60 48 8D 4C 24 38 44 8B C3 48 89 44 24 60 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 38 48 89 44 24 38 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_34_70_0 {
	meta:
		name = "?GetWaitNode@MultiWaitBlockHolder@details@Concurrency@@QEBAPEAVEventWaitNode@23@_K@Z"
		size = 16
	strings:
		$1 = { 48 8B 41 08 48 0F AF C2 48 03 41 18 48 03 01 C3 }
	condition:
		$1
}

rule file_34_71_0 {
	meta:
		name = "?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QEAAXXZ"
		size = 40
		refs = "001f ??_V@YAXPEAX@Z"
	strings:
		$1 = { 48 83 EC 28 48 8B 41 30 BA 01 00 00 00 F0 48 0F C1 51 48 48 FF C2 48 FF C0 48 3B D0 75 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_34_75_0 {
	meta:
		name = "?Reset@WaitAllBlock@details@Concurrency@@UEAA_NXZ"
		size = 61
		refs = "0032 ?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 4C 8B 49 38 4C 8B 41 40 4D 3B C1 74 20 49 8D 50 FF 49 8B C0 F0 48 0F B1 51 40 74 08 4C 8B C0 49 3B C1 75 E9 4D 3B C1 74 04 B0 01 EB 07 E8 ?? ?? ?? ?? 32 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_34_77_0 {
	meta:
		name = "?Satisfy@EventWaitNode@details@Concurrency@@QEAA_NPEAPEAVContext@3@@Z"
		size = 16
	strings:
		$1 = { 48 8B 41 08 4C 8B C1 4C 8B 08 48 8B C8 49 FF 21 }
	condition:
		$1
}

rule file_34_78_0 {
	meta:
		name = "?Satisfy@SingleWaitBlock@details@Concurrency@@UEAA_NPEAPEAVContext@3@PEAVEventWaitNode@23@@Z"
		size = 81
	strings:
		$1 = { 48 83 EC 28 49 8B 40 08 44 8B 48 10 41 83 F9 02 74 20 4D 8B 40 08 33 C0 44 8D 48 01 F0 45 0F B1 48 10 83 F8 02 74 0B 48 85 D2 74 1E 48 83 22 00 EB 18 48 85 D2 74 09 48 8B 41 08 48 89 02 EB 0A 48 8B 49 08 48 8B 01 FF 50 18 32 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_34_79_0 {
	meta:
		name = "?Satisfy@TimedSingleWaitBlock@details@Concurrency@@UEAA_NPEAPEAVContext@3@PEAVEventWaitNode@23@@Z"
		size = 173
		refs = "003b ?GetOSVersion@Concurrency@@YA?AW4OSVersion@IResourceManager@1@XZ 0052 ?DeleteAsyncTimerAndUnloadLibrary@details@Concurrency@@YAXPEAU_TP_TIMER@@@Z 005e ?GetSharedTimerQueue@details@Concurrency@@YAPEAXXZ 006d ?__DeleteTimerQueueTimer@platform@details@Concurrency@@YAXPEAX00@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 49 8B E8 48 8B F2 48 8B F9 B8 01 00 00 00 F0 0F C1 41 38 FF C0 83 F8 01 75 68 4D 85 C0 0F 95 C3 80 79 30 00 74 37 E8 ?? ?? ?? ?? 83 F8 03 7C 14 84 DB 74 29 48 8B 4F 28 48 85 C9 74 20 E8 ?? ?? ?? ?? EB 19 F6 DB 48 1B DB E8 ?? ?? ?? ?? 48 8B 57 28 48 8B C8 4C 8B C3 E8 ?? ?? ?? ?? 48 85 ED 0F 94 C0 88 47 3C 48 85 F6 74 09 48 8B 47 08 48 89 06 EB 0A 48 8B 4F 08 48 8B 11 FF 52 18 B0 01 EB 02 32 C0 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_34_80_0 {
	meta:
		name = "?Satisfy@WaitAllBlock@details@Concurrency@@UEAA_NPEAPEAVContext@3@PEAVEventWaitNode@23@@Z"
		size = 68
		refs = "0034 ?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 85 D2 74 04 48 83 22 00 41 B9 01 00 00 00 F0 4C 0F C1 49 40 48 8B 41 38 49 FF C1 4C 3B C8 75 12 48 8B 01 FF 50 28 48 8B CB E8 ?? ?? ?? ?? 32 C0 EB 02 B0 01 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_34_81_0 {
	meta:
		name = "?Satisfy@WaitAnyBlock@details@Concurrency@@UEAA_NPEAPEAVContext@3@PEAVEventWaitNode@23@@Z"
		size = 64
		refs = "0034 ?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 85 D2 74 04 48 83 22 00 41 B9 01 00 00 00 F0 4C 0F C1 49 40 48 8B 41 38 49 FF C1 4C 3B C8 75 06 48 8B 01 FF 50 28 48 8B CB E8 ?? ?? ?? ?? 32 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_34_82_0 {
	meta:
		name = "?Set@StructuredEvent@details@Concurrency@@QEAAXXZ"
		size = 78
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D1 48 8B 09 41 B8 01 00 00 00 48 8B C1 F0 4C 0F B1 02 74 0D 48 8B C8 F0 4C 0F B1 02 48 3B C1 75 F3 49 3B C8 76 1A 48 85 C9 74 15 48 8B 19 48 8B 49 08 48 8B 01 FF 50 18 48 8B CB 48 85 DB 75 EB 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_34_83_0 {
	meta:
		name = "?SingleSatisfy@MultiWaitBlock@details@Concurrency@@MEAAXPEAPEAVContext@3@PEAVEventWaitNode@23@@Z"
		size = 225
		refs = "0052 ?GetOSVersion@Concurrency@@YA?AW4OSVersion@IResourceManager@1@XZ 0060 ?DeleteAsyncTimerAndUnloadLibrary@details@Concurrency@@YAXPEAU_TP_TIMER@@@Z 0067 ?GetSharedTimerQueue@details@Concurrency@@YAPEAXXZ 0077 ?__DeleteTimerQueueTimer@platform@details@Concurrency@@YAXPEAX00@Z 0087 ?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 57 48 83 EC 20 80 79 50 00 48 8B 71 08 49 8B E8 48 8B FA 48 8B D9 41 BF 01 00 00 00 74 14 41 8B C7 F0 0F C1 41 28 41 03 C7 41 3B C7 0F 85 80 00 00 00 48 83 79 20 00 4C 89 41 18 74 3A E8 ?? ?? ?? ?? 83 F8 03 7C 0B 48 8B 4B 20 E8 ?? ?? ?? ?? EB 15 E8 ?? ?? ?? ?? 48 8B 53 20 49 83 C8 FF 48 8B C8 E8 ?? ?? ?? ?? 8B 43 28 41 3B C7 75 08 48 8B CB E8 ?? ?? ?? ?? 48 8B 45 08 8B 48 10 83 F9 02 74 1C 48 8B 4D 08 33 C0 F0 44 0F B1 79 10 83 F8 02 74 0B 48 85 FF 74 19 48 83 27 00 EB 13 48 85 FF 74 05 48 89 37 EB 09 48 8B 06 48 8B CE FF 50 18 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5F C3 }
	condition:
		$1
}

rule file_34_84_0 {
	meta:
		name = "?Sweep@details@Concurrency@@YAPEAVEventWaitNode@12@PEAV312@_N@Z"
		size = 98
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 33 FF 40 8A EA 48 8B D9 48 85 C9 74 29 48 8B 4B 08 48 8B 33 48 8B 01 40 84 ED 74 05 FF 50 18 EB 03 FF 50 20 84 C0 74 06 48 89 3B 48 8B FB 48 8B DE 48 85 F6 75 D7 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B C7 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_34_87_0 {
	meta:
		name = "?SweepResetNode@WaitAllBlock@details@Concurrency@@UEAA_NXZ"
		size = 49
	strings:
		$1 = { 48 83 EC 28 48 8B 51 40 48 8B 41 38 48 3B D0 72 0A 48 8B 01 FF 50 08 32 C0 EB 11 8A 41 51 84 C0 74 08 48 8B 01 FF 50 10 EB ED B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_34_91_0 {
	meta:
		name = "?SweepWaitNode@TimedSingleWaitBlock@details@Concurrency@@UEAA_NXZ"
		size = 28
	strings:
		$1 = { 48 83 EC 28 8A 41 3C 84 C0 74 0A 48 8B 01 FF 50 10 32 C0 EB 02 B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_34_92_0 {
	meta:
		name = "?SweepWaitNode@WaitAllBlock@details@Concurrency@@UEAA_NXZ"
		size = 54
	strings:
		$1 = { 40 53 48 83 EC 20 8A 41 51 48 8B D9 84 C0 74 1E 48 8B 01 48 8D 54 24 30 45 33 C0 FF 10 84 C0 74 09 48 8B 03 48 8B CB FF 50 10 32 C0 EB 02 B0 01 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_34_93_0 {
	meta:
		name = "?SweepWaitNode@WaitAnyBlock@details@Concurrency@@UEAA_NXZ"
		size = 48
	strings:
		$1 = { 48 83 EC 28 48 8B 51 40 48 8B 41 38 48 3B D0 73 0B 8A 41 51 84 C0 75 04 B0 01 EB 0F 48 8B 01 48 8D 54 24 30 45 33 C0 FF 10 32 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_34_94_0 {
	meta:
		name = "?Wait@StructuredEvent@details@Concurrency@@QEAAXXZ"
		size = 144
		refs = "0021 ?_UnderlyingYield@details@Concurrency@@YAXXZ 0032 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ 0046 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 0081 ?Block@Context@Concurrency@@SAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 50 48 8B 01 48 8B D9 48 83 F8 01 74 6F 83 64 24 38 00 48 8B 39 48 8D 05 ?? ?? ?? ?? 48 89 44 24 40 EB 11 48 8D 4C 24 30 E8 ?? ?? ?? ?? 84 C0 74 0B 48 8B 3B 48 83 FF 01 75 E9 EB 40 E8 ?? ?? ?? ?? 48 89 7C 24 20 48 8D 4C 24 20 48 89 44 24 28 48 8B C7 F0 48 0F B1 0B 74 1D 48 8B C8 48 83 F8 01 74 19 48 89 44 24 20 48 8D 54 24 20 F0 48 0F B1 13 48 3B C1 75 E3 E8 ?? ?? ?? ?? 48 8B 5C 24 60 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_34_100_0 {
	meta:
		name = "?_InitOnRawMalloca@?$_MallocaArrayHolder@PEAVContext@Concurrency@@@details@Concurrency@@QEAAPEAPEAVContext@3@PEAX@Z"
		size = 89
		refs = "001d ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 0037 ??0exception@std@@QEAA@AEBQEBDH@Z 003e ??_7bad_alloc@std@@6B@ 0045 _TI2?AVbad_alloc@std@@ 0054 _CxxThrowException"
		altNames = "?_InitOnRawMalloca@?$_MallocaArrayHolder@PEAVevent@Concurrency@@@details@Concurrency@@QEAAPEAPEAVevent@3@PEAX@Z"
	strings:
		$1 = { 48 83 EC 48 48 85 D2 74 11 48 83 61 10 00 48 89 51 08 48 8B C2 48 83 C4 48 C3 48 8D 05 ?? ?? ?? ?? 48 8D 54 24 58 48 8D 4C 24 20 41 B8 01 00 00 00 48 89 44 24 58 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 48 89 44 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_34_107_0 {
	meta:
		name = "?_Reset@?$_SpinWait@$00@details@Concurrency@@IEAAXXZ"
		size = 50
		refs = "000e ?_Value@_SpinCount@details@Concurrency@@SAIXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 83 61 08 00 48 8B D9 E8 ?? ?? ?? ?? 85 C0 75 09 C7 43 08 04 00 00 00 EB 0D 89 03 B8 01 00 00 00 89 43 04 89 43 08 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_34_108_0 {
	meta:
		name = "?_Reset@?$_SpinWait@$0A@@details@Concurrency@@IEAAXXZ"
		size = 50
		refs = "000e ?_Value@_SpinCount@details@Concurrency@@SAIXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 83 61 08 00 48 8B D9 E8 ?? ?? ?? ?? 85 C0 75 09 C7 43 08 04 00 00 00 EB 0D 83 63 04 00 89 03 C7 43 08 01 00 00 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_34_109_0 {
	meta:
		name = "?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QEAAXI@Z"
		size = 26
	strings:
		$1 = { 85 D2 75 08 C7 41 08 04 00 00 00 C3 B8 01 00 00 00 89 11 89 41 04 89 41 08 C3 }
	condition:
		$1
}

rule file_34_110_0 {
	meta:
		name = "?_SetSpinCount@?$_SpinWait@$0A@@details@Concurrency@@QEAAXI@Z"
		size = 26
	strings:
		$1 = { 85 D2 75 08 C7 41 08 04 00 00 00 C3 83 61 04 00 89 11 C7 41 08 01 00 00 00 C3 }
	condition:
		$1
}

rule file_34_113_0 {
	meta:
		name = "?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ"
		size = 175
		refs = "001a ?_Value@_SpinCount@details@Concurrency@@SAIXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B D9 33 FF 8B 4B 08 85 C9 75 27 89 7B 08 E8 ?? ?? ?? ?? 85 C0 75 09 C7 43 08 04 00 00 00 EB E4 89 03 C7 43 04 01 00 00 00 C7 43 08 01 00 00 00 EB D2 FF C9 74 4E FF C9 74 33 FF C9 74 06 FF C9 74 3A EB 25 89 7B 08 E8 ?? ?? ?? ?? 85 C0 75 09 C7 43 08 04 00 00 00 EB 10 89 03 C7 43 04 01 00 00 00 C7 43 08 01 00 00 00 32 C0 EB 2C FF 4B 04 75 07 C7 43 08 03 00 00 00 40 B7 01 FF 53 10 40 8A C7 EB 15 F3 90 FF 0B 75 0D 8B 4B 04 F7 D9 1B D2 83 C2 03 89 53 08 B0 01 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_34_114_0 {
	meta:
		name = "?_SpinOnce@?$_SpinWait@$0A@@details@Concurrency@@QEAA_NXZ"
		size = 166
		refs = "001a ?_Value@_SpinCount@details@Concurrency@@SAIXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B D9 33 FF 8B 4B 08 85 C9 75 23 89 7B 08 E8 ?? ?? ?? ?? 85 C0 75 09 C7 43 08 04 00 00 00 EB E4 89 03 89 7B 04 C7 43 08 01 00 00 00 EB D6 FF C9 74 49 FF C9 74 2F FF C9 74 06 FF C9 74 36 EB 21 89 7B 08 E8 ?? ?? ?? ?? 85 C0 75 09 C7 43 08 04 00 00 00 EB 0C 89 03 89 7B 04 C7 43 08 01 00 00 00 32 C0 EB 2B FF 4B 04 75 07 C7 43 08 03 00 00 00 40 B7 01 F3 90 40 8A C7 EB 15 F3 90 FF 0B 75 0D 8B 4B 04 F7 D9 1B D2 83 C2 03 89 53 08 B0 01 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_34_117_0 {
	meta:
		name = "?createTimer@TimedSingleWaitBlock@details@Concurrency@@QEAA_NI@Z"
		size = 138
		refs = "001c ?GetOSVersion@Concurrency@@YA?AW4OSVersion@IResourceManager@1@XZ 0028 ?DispatchEventTimer@TimedSingleWaitBlock@details@Concurrency@@SAXPEAU_TP_CALLBACK_INSTANCE@@PEAXPEAU_TP_TIMER@@@Z 0035 ?RegisterAsyncTimerAndLoadLibrary@details@Concurrency@@YAPEAU_TP_TIMER@@KP6AXPEAU_TP_CALLBACK_INSTANCE@@PEAXPEAU3@@Z1_N@Z 0046 ?GetSharedTimerQueue@details@Concurrency@@YAPEAXXZ 0059 ?DispatchEventTimerXP@TimedSingleWaitBlock@details@Concurrency@@SAXPEAXE@Z 006c ?__CreateTimerQueueTimer@platform@details@Concurrency@@YAHPEAPEAXPEAXP6AX1E@Z1KKK@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 40 33 DB 8B F2 48 8B F9 38 59 30 74 5D E8 ?? ?? ?? ?? 83 F8 03 7C 20 48 8D 15 ?? ?? ?? ?? 45 33 C9 4C 8B C7 8B CE E8 ?? ?? ?? ?? 48 85 C0 48 89 47 28 0F 95 C0 EB 35 E8 ?? ?? ?? ?? C7 44 24 30 20 00 00 00 48 8D 4F 28 4C 8D 05 ?? ?? ?? ?? 4C 8B CF 48 8B D0 89 5C 24 28 89 74 24 20 E8 ?? ?? ?? ?? 83 F8 01 0F 94 C0 EB 02 32 C0 48 8B 5C 24 50 48 8B 74 24 58 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_34_118_0 {
	meta:
		name = "?destroyTimer@TimedSingleWaitBlock@details@Concurrency@@QEAAX_N@Z"
		size = 87
		refs = "0016 ?GetOSVersion@Concurrency@@YA?AW4OSVersion@IResourceManager@1@XZ 002d ?DeleteAsyncTimerAndUnloadLibrary@details@Concurrency@@YAXPEAU_TP_TIMER@@@Z 0039 ?GetSharedTimerQueue@details@Concurrency@@YAPEAXXZ 0048 ?__DeleteTimerQueueTimer@platform@details@Concurrency@@YAXPEAX00@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 80 79 30 00 8A DA 48 8B F9 74 37 E8 ?? ?? ?? ?? 83 F8 03 7C 14 84 DB 74 29 48 8B 4F 28 48 85 C9 74 20 E8 ?? ?? ?? ?? EB 19 F6 DB 48 1B DB E8 ?? ?? ?? ?? 48 8B 57 28 48 8B C8 4C 8B C3 E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_34_120_0 {
	meta:
		name = "?notify_all@_Condition_variable@details@Concurrency@@QEAAXXZ"
		size = 127
		refs = "001f ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0033 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 50 48 8B 01 48 8B D9 48 85 C0 74 5F 48 8D 51 08 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 3B 48 8D 4C 24 20 48 C7 03 00 00 00 00 E8 ?? ?? ?? ?? EB 36 48 83 64 24 60 00 48 8D 5F 08 48 8D 54 24 60 48 8B 0B 4C 8B C7 48 8B 01 FF 10 48 8B 0B 48 8B 3F 48 8B 01 FF 50 10 48 8B 4C 24 60 48 85 C9 74 06 48 8B 01 FF 50 18 48 85 FF 75 C5 48 8B 5C 24 68 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_34_121_0 {
	meta:
		name = "?notify_one@_Condition_variable@details@Concurrency@@QEAAXXZ"
		size = 173
		refs = "002c ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0097 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 60 49 C7 43 B8 FE FF FF FF 49 89 5B 10 49 89 73 18 48 8B F9 48 8B 01 48 85 C0 74 78 48 8D 51 08 49 8D 4B C0 E8 ?? ?? ?? ?? 90 48 8B 1F 48 83 64 24 70 00 48 85 DB 74 4B 48 8D 73 08 48 8B 0E 48 8B 01 4C 8B C3 48 8D 54 24 70 FF 10 84 C0 75 11 48 8B 1B 48 8B 0E 48 8B 01 FF 50 10 48 85 DB 75 D7 48 85 DB 74 1D 48 8B 03 48 89 07 48 8B 4B 08 48 8B 01 FF 50 10 48 8B 4C 24 70 48 8B 01 FF 50 18 EB 07 48 C7 07 00 00 00 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? 4C 8D 5C 24 60 49 8B 5B 18 49 8B 73 20 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_34_123_0 {
	meta:
		name = "?reset@event@Concurrency@@QEAAXXZ"
		size = 135
		refs = "0028 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 006d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 57 48 83 EC 60 48 C7 40 B8 FE FF FF FF 48 89 58 08 48 89 68 10 48 89 70 18 48 8B D9 48 8D 51 10 48 8D 48 C0 E8 ?? ?? ?? ?? 90 48 8B 03 48 83 F8 01 75 31 33 F6 48 8B 7B 08 48 21 73 08 48 85 FF 74 1F 48 8B 2F 48 8B 4F 08 48 8B 01 FF 50 08 84 C0 74 06 48 89 37 48 8B F7 48 8B FD 48 85 ED 75 E1 48 89 33 48 8D 4C 24 28 E8 ?? ?? ?? ?? 4C 8D 5C 24 60 49 8B 5B 10 49 8B 6B 18 49 8B 73 20 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_34_125_0 {
	meta:
		name = "?set@event@Concurrency@@QEAAXXZ"
		size = 506
		refs = "0039 __security_cookie 004e ??_7?$_MallocaArrayHolder@PEAVContext@Concurrency@@@details@Concurrency@@6B@ 0067 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 00c8 __chkstk 00e2 malloc 0104 ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 011b ??0exception@std@@QEAA@AEBQEBDH@Z 0122 ??_7bad_alloc@std@@6B@ 012d _TI2?AVbad_alloc@std@@ 0136 _CxxThrowException 0192 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 01c1 free 01cd __security_check_cookie"
	strings:
		$1 = { 40 55 41 56 41 57 48 81 EC A0 00 00 00 48 8D 6C 24 20 48 C7 45 28 FE FF FF FF 48 89 9D A0 00 00 00 48 89 B5 A8 00 00 00 48 89 BD B0 00 00 00 4C 89 A5 B8 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C5 48 89 45 78 4C 8B F9 33 DB 33 FF 48 8D 05 ?? ?? ?? ?? 48 89 45 08 48 21 5D 10 48 21 5D 18 48 8D 51 10 48 8D 4D 48 E8 ?? ?? ?? ?? 90 8D 73 01 49 87 37 48 83 FE 01 0F 86 0D 01 00 00 33 C9 48 8B C6 48 85 F6 74 0A FF C1 48 8B 00 48 85 C0 75 F6 8B D1 48 C1 E1 03 48 8D 41 10 48 3B C1 76 5B 48 8D 0C D5 10 00 00 00 48 81 F9 00 04 00 00 77 31 48 8D 41 0F 48 3B C1 77 0A 48 B8 F0 FF FF FF FF FF FF 0F 48 83 E0 F0 E8 ?? ?? ?? ?? 48 2B E0 48 8D 5C 24 20 48 85 DB 74 28 C7 03 CC CC 00 00 EB 13 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 0E C7 00 DD DD 00 00 48 83 C3 10 EB 02 33 DB 48 85 DB 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 45 20 41 B8 01 00 00 00 48 8D 55 20 48 8D 4D 30 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 45 30 48 8D 15 ?? ?? ?? ?? 48 8D 4D 30 E8 ?? ?? ?? ?? CC 4C 8B F3 48 89 5D 10 48 83 65 18 00 33 FF 48 85 F6 74 3F 4C 8B 26 48 8B 4E 08 48 8B 01 4C 8B C6 48 8D 55 00 FF 10 84 C0 74 0B 49 8B 47 08 48 89 06 49 89 77 08 48 8B 4D 00 48 85 C9 74 06 48 89 0C FB FF C7 49 8B F4 4D 85 E4 75 C7 EB 04 4C 8B 75 10 48 8D 4D 48 E8 ?? ?? ?? ?? 85 FF 74 15 48 8D 1C FB 48 8D 5B F8 48 8B 0B 48 8B 01 FF 50 18 FF CF 75 EF 4D 85 F6 74 11 49 8D 4E F0 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 48 8B 4D 78 48 33 CD E8 ?? ?? ?? ?? 48 8B 9D A0 00 00 00 48 8B B5 A8 00 00 00 48 8B BD B0 00 00 00 4C 8B A5 B8 00 00 00 48 8D A5 80 00 00 00 41 5F 41 5E 5D C3 }
	condition:
		$1
}

rule file_34_129_0 {
	meta:
		name = "?wait@_Condition_variable@details@Concurrency@@QEAAXAEAVcritical_section@3@@Z"
		size = 202
		refs = "0028 ??_7WaitBlock@details@Concurrency@@6B@ 003d ?CurrentContext@Context@Concurrency@@SAPEAV12@XZ 0048 ??_7TimedSingleWaitBlock@details@Concurrency@@6B@ 007c ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0087 ?Sweep@details@Concurrency@@YAPEAVEventWaitNode@12@PEAV312@_N@Z 009a ?unlock@critical_section@Concurrency@@QEAAXXZ 00a4 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 00a9 ?Block@Context@Concurrency@@SAXXZ 00b1 ?lock@critical_section@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 8B C4 55 48 8D 68 A1 48 81 EC A0 00 00 00 48 C7 45 D7 FE FF FF FF 48 89 58 08 48 89 78 10 48 8B FA 48 8B D9 48 8D 05 ?? ?? ?? ?? 48 89 45 17 48 83 65 1F 00 C7 45 27 00 00 00 00 E8 ?? ?? ?? ?? 48 89 45 1F 48 8D 05 ?? ?? ?? ?? 48 89 45 17 48 83 65 37 00 C6 45 47 00 C7 45 4B 00 00 00 00 C7 45 4F 00 00 00 00 C6 45 53 00 48 8D 45 17 48 89 45 37 48 8D 53 08 48 8D 4D DF E8 ?? ?? ?? ?? 90 B2 01 48 8B 0B E8 ?? ?? ?? ?? 48 89 45 2F 48 8D 45 2F 48 89 03 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4D DF E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 4C 8D 9C 24 A0 00 00 00 49 8B 5B 10 49 8B 7B 18 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_34_131_0 {
	meta:
		name = "?wait@event@Concurrency@@QEAA_KI@Z"
		size = 300
		refs = "0050 ?wait_for_multiple@event@Concurrency@@SA_KPEAPEAV12@_K_NI@Z 0060 ?_UnderlyingYield@details@Concurrency@@YAXXZ 007a ?_SpinOnce@?$_SpinWait@$0A@@details@Concurrency@@QEAA_NXZ 0085 ??_7WaitBlock@details@Concurrency@@6B@ 009a ?CurrentContext@Context@Concurrency@@SAPEAV12@XZ 00a5 ??_7SingleWaitBlock@details@Concurrency@@6B@ 00c1 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 00da ?Sweep@details@Concurrency@@YAPEAVEventWaitNode@12@PEAV312@_N@Z 00ee ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 0111 ?Block@Context@Concurrency@@SAXXZ"
	strings:
		$1 = { 48 8B C4 55 48 8D 68 A1 48 81 EC A0 00 00 00 48 C7 45 FF FE FF FF FF 48 89 58 08 48 89 78 10 48 8B D9 83 FA FF 74 32 85 D2 75 11 48 8B 01 48 FF C8 48 F7 D8 48 1B C0 E9 DB 00 00 00 48 89 4D 77 44 8B CA 41 B0 01 BA 01 00 00 00 48 8D 4D 77 E8 ?? ?? ?? ?? E9 BE 00 00 00 83 65 0F 00 48 8D 05 ?? ?? ?? ?? 48 89 45 17 48 8B 03 48 83 F8 01 0F 84 A0 00 00 00 48 8D 4D 07 E8 ?? ?? ?? ?? 84 C0 75 E6 48 8D 05 ?? ?? ?? ?? 48 89 45 D7 48 83 65 DF 00 C7 45 E7 00 00 00 00 E8 ?? ?? ?? ?? 48 89 45 DF 48 8D 05 ?? ?? ?? ?? 48 89 45 D7 48 8D 45 D7 48 89 45 F7 40 32 FF 48 8D 53 10 48 8D 4D 1F E8 ?? ?? ?? ?? 90 48 8B 03 48 83 F8 01 75 05 40 8A F8 EB 15 B2 01 48 8B 0B E8 ?? ?? ?? ?? 48 89 45 EF 48 8D 45 EF 48 89 03 48 8D 4D 1F E8 ?? ?? ?? ?? 40 84 FF 75 1E 8B 45 E7 83 F8 01 74 16 B9 02 00 00 00 33 C0 F0 0F B1 4D E7 83 F8 01 74 05 E8 ?? ?? ?? ?? 33 C0 4C 8D 9C 24 A0 00 00 00 49 8B 5B 10 49 8B 7B 18 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_34_133_0 {
	meta:
		name = "?wait_for@_Condition_variable@details@Concurrency@@QEAA_NAEAVcritical_section@3@I@Z"
		size = 361
		refs = "003a ?wait@_Condition_variable@details@Concurrency@@QEAAXAEAVcritical_section@3@@Z 004b ??2@YAPEAX_K@Z 005f ??_7WaitBlock@details@Concurrency@@6B@ 0073 ?CurrentContext@Context@Concurrency@@SAPEAV12@XZ 007e ??_7TimedSingleWaitBlock@details@Concurrency@@6B@ 00b6 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 00c1 ?Sweep@details@Concurrency@@YAPEAVEventWaitNode@12@PEAV312@_N@Z 00d1 ?createTimer@TimedSingleWaitBlock@details@Concurrency@@QEAA_NI@Z 00dc ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 00fc ??0exception@std@@QEAA@AEBQEBDH@Z 0103 ??_7bad_alloc@std@@6B@ 010f _TI2?AVbad_alloc@std@@ 0119 _CxxThrowException 0122 ?unlock@critical_section@Concurrency@@QEAAXXZ 012d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 0132 ?Block@Context@Concurrency@@SAXXZ 014b ?lock@critical_section@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 8B C4 56 57 41 56 48 81 EC 80 00 00 00 48 C7 40 88 FE FF FF FF 48 89 58 08 48 89 68 10 41 8B E8 48 8B F2 4C 8B F1 45 85 C0 75 07 32 C0 E9 1E 01 00 00 41 83 F8 FF 75 0C E8 ?? ?? ?? ?? B0 01 E9 0C 01 00 00 B9 40 00 00 00 E8 ?? ?? ?? ?? 48 8B F8 48 89 44 24 28 48 85 C0 74 4A 48 8D 05 ?? ?? ?? ?? 48 89 07 48 83 67 08 00 C7 47 10 00 00 00 00 E8 ?? ?? ?? ?? 48 89 47 08 48 8D 05 ?? ?? ?? ?? 48 89 07 48 83 67 20 00 C6 47 30 01 C7 47 34 00 00 00 00 C7 47 38 00 00 00 00 C6 47 3C 00 48 89 7F 20 EB 02 33 FF 48 8D 5F 18 49 8D 56 08 48 8D 4C 24 48 E8 ?? ?? ?? ?? 90 B2 01 49 8B 0E E8 ?? ?? ?? ?? 48 89 03 49 89 1E 8B D5 48 8B CF E8 ?? ?? ?? ?? 84 C0 75 45 48 8D 05 ?? ?? ?? ?? 48 89 84 24 B8 00 00 00 41 B8 01 00 00 00 48 8D 94 24 B8 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 44 24 30 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 30 E8 ?? ?? ?? ?? CC 48 8B CE E8 ?? ?? ?? ?? 90 48 8D 4C 24 48 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8A 47 3C 84 C0 0F 94 C3 48 8B 17 48 8B CF FF 52 10 48 8B CE E8 ?? ?? ?? ?? 8A C3 4C 8D 9C 24 80 00 00 00 49 8B 5B 20 49 8B 6B 28 49 8B E3 41 5E 5F 5E C3 }
	condition:
		$1
}

rule file_34_136_0 {
	meta:
		name = "?wait_for_multiple@event@Concurrency@@SA_KPEAPEAV12@_K_NI@Z"
		size = 1015
		refs = "003e ??_C@_07CAAEJHLA@pEvents?$AA@ 004f ??0exception@std@@QEAA@AEBQEBD@Z 0056 ??_7invalid_argument@std@@6B@ 0061 _TI3?AVinvalid_argument@std@@ 006a _CxxThrowException 00d1 ?wait@event@Concurrency@@QEAA_KI@Z 0148 ??0MultiWaitBlockHolder@details@Concurrency@@QEAA@_N_K00@Z 0175 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 01ce ?Sweep@details@Concurrency@@YAPEAVEventWaitNode@12@PEAV312@_N@Z 0212 ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 02da ?GetOSVersion@Concurrency@@YA?AW4OSVersion@IResourceManager@1@XZ 02ec ?DispatchEventTimer@MultiWaitBlock@details@Concurrency@@SAXPEAU_TP_CALLBACK_INSTANCE@@PEAXPEAU_TP_TIMER@@@Z 02f3 ?RegisterAsyncTimerAndLoadLibrary@details@Concurrency@@YAPEAU_TP_TIMER@@KP6AXPEAU_TP_CALLBACK_INSTANCE@@PEAXPEAU3@@Z1_N@Z 0307 ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 031b ??0exception@std@@QEAA@AEBQEBDH@Z 0322 ??_7bad_alloc@std@@6B@ 032d _TI2?AVbad_alloc@std@@ 033c ?GetSharedTimerQueue@details@Concurrency@@YAPEAXXZ 035e ?DispatchEventTimerXP@MultiWaitBlock@details@Concurrency@@SAXPEAXE@Z 0363 ?__CreateTimerQueueTimer@platform@details@Concurrency@@YAHPEAPEAXPEAXP6AX1E@Z1KKK@Z 03a8 ?Block@Context@Concurrency@@SAXXZ 03d5 ??1MultiWaitBlockHolder@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 44 88 40 18 55 56 57 41 54 41 55 41 56 41 57 48 8D 6C 24 A0 48 81 EC 60 01 00 00 48 C7 45 A8 FE FF FF FF 48 89 58 10 41 8B F1 45 8A D0 48 8B FA 4C 8B F9 48 85 C9 75 34 48 8D 05 ?? ?? ?? ?? 48 89 45 98 48 8D 55 98 48 8D 4D F8 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 45 F8 48 8D 15 ?? ?? ?? ?? 48 8D 4D F8 E8 ?? ?? ?? ?? CC 48 85 D2 75 07 33 C0 E9 61 03 00 00 41 BE 01 00 00 00 49 3B D6 75 54 41 8D 41 01 A9 FE FF FF FF 75 49 48 8B 09 48 85 C9 75 34 48 8D 05 ?? ?? ?? ?? 48 89 45 A0 48 8D 55 A0 48 8D 4D 10 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 45 10 48 8D 15 ?? ?? ?? ?? 48 8D 4D 10 E8 ?? ?? ?? ?? CC 41 8B D1 E8 ?? ?? ?? ?? E9 02 03 00 00 33 C0 48 85 D2 74 45 48 83 3C C1 00 74 0A 49 03 C6 48 3B C2 72 F1 EB 34 48 8D 05 ?? ?? ?? ?? 48 89 45 80 48 8D 55 80 48 8D 4D E0 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 45 E0 48 8D 15 ?? ?? ?? ?? 48 8D 4D E0 E8 ?? ?? ?? ?? CC 41 8D 41 FF 83 F8 FD 0F 96 C0 41 83 F9 FF 41 0F 95 C1 88 44 24 20 4C 8B C2 41 8A D2 48 8D 4C 24 48 E8 ?? ?? ?? ?? 90 48 8B 5C 24 68 45 32 E4 45 33 ED 48 85 FF 0F 84 1D 01 00 00 4B 8B 04 EF 48 89 85 A0 00 00 00 48 8D 50 10 48 8D 4D 28 E8 ?? ?? ?? ?? 90 4C 8B 74 24 50 4D 0F AF F5 4C 03 74 24 60 4C 03 74 24 48 48 FF 44 24 70 48 8B 85 A0 00 00 00 48 8B 08 48 83 F9 01 75 51 49 8B 4E 08 4D 8B C6 48 8D 54 24 40 48 8B 01 80 BD B0 00 00 00 00 74 69 FF 10 84 C0 74 20 33 D2 48 8B 85 A0 00 00 00 48 8B 48 08 E8 ?? ?? ?? ?? 49 89 06 48 8B 85 A0 00 00 00 4C 89 70 08 41 BE 01 00 00 00 48 83 7C 24 40 00 74 1F 45 8A E6 EB 1A B2 01 E8 ?? ?? ?? ?? 49 89 06 48 8B 85 A0 00 00 00 4C 89 30 41 BE 01 00 00 00 48 8D 4D 28 E8 ?? ?? ?? ?? 4D 03 EE 4C 3B EF 73 57 E9 3E FF FF FF FF 10 45 0F B6 E4 48 83 7C 24 40 00 41 BE 01 00 00 00 45 0F 45 E6 49 FF C5 EB 29 4C 8B 44 24 50 4D 0F AF C5 4C 03 44 24 60 4C 03 44 24 48 4C 01 74 24 70 49 8B 48 08 48 8B 01 48 8D 54 24 40 FF 10 4D 03 EE 4C 3B EF 72 D2 48 8D 4D 28 E8 ?? ?? ?? ?? 45 84 E4 0F 85 2E 01 00 00 8B 43 10 41 3B C6 0F 84 22 01 00 00 B9 02 00 00 00 33 C0 F0 0F B1 4B 10 41 3B C6 0F 84 0D 01 00 00 85 F6 75 22 41 8B C6 F0 0F C1 43 28 41 03 C6 41 3B C6 0F 85 F0 00 00 00 48 83 63 18 00 44 88 73 51 E9 E7 00 00 00 83 FE FF 0F 84 D9 00 00 00 8B 43 28 85 C0 0F 85 CE 00 00 00 E8 ?? ?? ?? ?? 83 F8 03 7C 58 45 33 C9 4C 8B C3 48 8D 15 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 48 89 43 20 48 85 C0 0F 85 9E 00 00 00 48 8D 05 ?? ?? ?? ?? 48 89 45 88 45 8B C6 48 8D 55 88 48 8D 4D B0 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 45 B0 48 8D 15 ?? ?? ?? ?? 48 8D 4D B0 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 48 8B D0 48 8D 4B 20 C7 44 24 30 20 00 00 00 83 64 24 28 00 89 74 24 20 4C 8B CB 4C 8D 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 37 48 8D 05 ?? ?? ?? ?? 48 89 45 90 45 8B C6 48 8D 55 90 48 8D 4D C8 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 45 C8 48 8D 15 ?? ?? ?? ?? 48 8D 4D C8 E8 ?? ?? ?? ?? CC 4C 01 74 24 70 E8 ?? ?? ?? ?? 48 8B 43 18 48 85 C0 75 06 48 83 CB FF EB 14 48 2B 44 24 60 48 2B 44 24 48 33 D2 48 F7 74 24 50 48 8B D8 48 8D 4C 24 48 E8 ?? ?? ?? ?? 48 8B C3 48 8B 9C 24 A8 01 00 00 48 81 C4 60 01 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_34_141_0 {
	meta:
		name = "_freea"
		size = 31
		refs = "0016 free"
	strings:
		$1 = { 48 83 EC 28 48 85 C9 74 11 48 83 E9 10 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "dekker_mul12"
		size = 124
	strings:
		$1 = { F2 0F 11 44 24 08 0F 28 E1 0F 28 E8 48 8B 44 24 08 F2 0F 59 C1 48 C7 C1 00 00 00 F8 48 23 C1 48 89 44 24 08 F2 0F 10 5C 24 08 F2 0F 11 4C 24 08 48 8B 44 24 08 48 23 C1 48 89 44 24 08 F2 0F 5C EB F2 0F 10 54 24 08 F2 41 0F 11 00 F2 0F 5C E2 0F 28 CA F2 0F 59 D5 F2 0F 59 CB F2 0F 5C C8 0F 28 C4 F2 0F 59 E5 F2 0F 59 C3 F2 0F 58 C8 F2 0F 58 CA F2 0F 58 CC F2 41 0F 11 09 C3 }
	condition:
		$1
}

rule file_36_2_0 {
	meta:
		name = "remainder"
		size = 1457
		refs = "00f4 ??_C@_09HALKBBKJ@remainder?$AA@ 0118 _handle_error 0238 __real@3fe0000000000000 0253 __xmm@80000000000000008000000000000000 0298 __real@3ff0000000000000"
	strings:
		$1 = { 48 8B C4 F2 0F 11 40 08 53 48 81 EC A0 00 00 00 0F 29 70 E8 0F 29 78 D8 44 0F 29 40 C8 F2 0F 11 84 24 B8 00 00 00 0F 28 D1 BB 01 00 00 00 4C 8B 84 24 B8 00 00 00 F2 0F 11 94 24 B8 00 00 00 4C 8B 9C 24 B8 00 00 00 4D 8B D0 4D 8B CB 49 8B C8 49 8B D3 0F 28 C8 44 0F 29 48 B8 44 0F 29 50 A8 48 B8 FF FF FF FF FF FF FF 7F 48 C1 E9 34 48 C1 EA 34 4C 23 C8 4C 23 D0 B8 FF 07 00 00 23 C8 23 D0 3B CB 7C 3E 81 F9 FE 07 00 00 7F 3E 8D 42 FF 3D FD 07 00 00 77 2C 4D 3B D1 0F 85 68 01 00 00 48 B8 00 00 00 00 00 00 00 80 4C 23 C0 4C 89 84 24 B0 00 00 00 F2 0F 10 84 24 B0 00 00 00 E9 C8 04 00 00 81 F9 FE 07 00 00 7E 6A C7 44 24 40 02 00 00 00 F2 0F 11 54 24 38 48 B8 FF FF FF FF FF FF 0F 00 F2 0F 11 44 24 30 44 8B CB BA 06 00 00 00 48 8D 0D ?? ?? ?? ?? C7 44 24 28 21 00 00 00 4C 85 C0 74 1C 48 B8 00 00 00 00 00 00 08 00 4C 0B C0 83 64 24 20 00 E8 ?? ?? ?? ?? E9 6A 04 00 00 C7 44 24 20 08 00 00 00 49 B8 00 00 00 00 00 00 F8 FF EB E2 81 FA FE 07 00 00 7E 52 48 B8 FF FF FF FF FF FF 0F 00 4C 85 D8 0F 84 3B 04 00 00 C7 44 24 40 02 00 00 00 F2 0F 11 54 24 38 F2 0F 11 44 24 30 49 B8 00 00 00 00 00 00 08 00 C7 44 24 28 21 00 00 00 4D 0B C3 83 64 24 20 00 BA 06 00 00 00 44 8B CB 48 8D 0D ?? ?? ?? ?? EB 88 4D 85 D2 75 39 4D 85 C9 0F 85 EE 03 00 00 C7 44 24 40 02 00 00 00 F2 0F 11 54 24 38 F2 0F 11 44 24 30 C7 44 24 28 21 00 00 00 49 B8 00 00 00 00 00 00 F8 FF C7 44 24 20 08 00 00 00 EB B1 4D 85 C9 74 CB 49 B8 00 00 00 00 00 00 10 00 3B CB 7D 12 49 8B C2 4D 3B D0 73 0A 48 03 C0 2B CB 49 3B C0 72 F6 3B D3 7D 12 49 8B C1 4D 3B C8 73 0A 48 03 C0 2B D3 49 3B C0 72 F6 4C 89 94 24 B8 00 00 00 F2 0F 10 BC 24 B8 00 00 00 4C 89 8C 24 B8 00 00 00 F2 44 0F 10 84 24 B8 00 00 00 4D 3B D1 73 2F 41 0F 28 C0 F2 0F 59 05 ?? ?? ?? ?? 66 0F 2F F8 76 05 F2 41 0F 5C F8 0F 57 C0 66 0F 2F C1 76 07 0F 57 3D ?? ?? ?? ?? 0F 28 C7 E9 2C 03 00 00 0F AE 9C 24 B8 00 00 00 44 8B 9C 24 B8 00 00 00 3B CA 7F 05 45 33 D2 EB 1B 2B CA B8 4F EC C4 4E F7 E9 44 8B D2 41 C1 FA 04 41 8B C2 C1 E8 1F 44 03 D0 75 0E F2 44 0F 10 15 ?? ?? ?? ?? E9 A7 00 00 00 45 6B C2 34 B8 56 55 55 55 41 F7 E8 41 8B C0 8B CA C1 E9 1F 03 CA 2B C1 99 2B C2 BA FF 03 00 00 D1 F8 44 2B C0 48 98 44 2B C1 48 03 C2 48 63 C9 48 C1 E0 34 48 03 CA 48 C1 E1 34 48 89 8C 24 B8 00 00 00 F2 0F 10 94 24 B8 00 00 00 48 89 84 24 B8 00 00 00 49 63 C0 F2 0F 10 8C 24 B8 00 00 00 48 03 C2 48 C1 E0 34 48 89 84 24 B8 00 00 00 F2 41 0F 59 D0 48 B8 00 00 00 00 00 00 B0 3C 44 0F 28 C2 F2 44 0F 59 C1 F2 0F 10 84 24 B8 00 00 00 48 89 84 24 B8 00 00 00 F2 44 0F 59 C0 F2 44 0F 10 94 24 B8 00 00 00 48 C7 C2 00 00 00 F8 45 0F 57 C9 45 85 D2 0F 8E CE 00 00 00 41 8B CA 0F 28 C7 F2 44 0F 11 84 24 B8 00 00 00 0F 28 DF F2 41 0F 5E C0 41 0F 28 F0 F2 48 0F 2C C0 0F 57 C0 F2 48 0F 2A C0 48 8B 84 24 B8 00 00 00 48 23 C2 48 89 84 24 C0 00 00 00 F2 0F 10 A4 24 C0 00 00 00 F2 0F 11 84 24 C8 00 00 00 0F 28 E8 F2 41 0F 59 C0 48 8B 84 24 C8 00 00 00 48 23 C2 48 89 84 24 C0 00 00 00 F2 0F 10 94 24 C0 00 00 00 F2 0F 5C D8 F2 0F 5C F4 F2 0F 5C FB F2 0F 5C EA 0F 28 CA F2 0F 59 D6 F2 0F 59 CC F2 0F 5C C8 F2 0F 5C F8 0F 28 C5 F2 0F 59 EE F2 0F 59 C4 F2 0F 58 C8 F2 0F 58 CA F2 0F 58 CD F2 0F 5C F9 F2 0F 58 FB 66 44 0F 2F CF 76 05 F2 41 0F 58 F8 F2 45 0F 59 C2 48 2B CB 0F 85 35 FF FF FF F2 44 0F 11 84 24 B8 00 00 00 0F 28 C7 0F 57 F6 48 8B 84 24 B8 00 00 00 F2 41 0F 5E C0 48 23 C2 41 0F 28 E8 48 89 84 24 B8 00 00 00 F2 0F 10 94 24 B8 00 00 00 F2 0F 5C EA F2 48 0F 2C C8 F2 48 0F 2A F1 48 23 CB F2 0F 11 B4 24 B8 00 00 00 0F 28 DE F2 41 0F 59 F0 48 8B 84 24 B8 00 00 00 48 23 C2 48 89 84 24 B8 00 00 00 F2 0F 10 8C 24 B8 00 00 00 F2 0F 5C D9 0F 28 E1 F2 0F 59 CD F2 0F 59 E2 0F 28 C3 F2 0F 59 DD F2 0F 5C E6 F2 0F 59 C2 F2 0F 58 E0 0F 28 C7 F2 0F 5C C6 F2 0F 58 E1 F2 0F 5C F8 F2 0F 58 E3 F2 0F 5C FE F2 0F 5C FC F2 0F 58 F8 66 44 0F 2F CF F2 0F 11 BC 24 C0 00 00 00 76 19 33 C0 48 85 C9 F2 41 0F 58 F8 0F 94 C0 F2 0F 11 BC 24 C0 00 00 00 48 8B C8 48 B8 00 00 00 00 00 00 D0 7F 4C 3B C8 73 1A 0F 28 C7 F2 0F 58 C7 66 41 0F 2F C0 77 2B 48 85 C9 74 34 66 41 0F 2E C0 EB 1B 41 0F 28 C0 F2 0F 59 05 ?? ?? ?? ?? 66 0F 2F F8 77 0D 48 85 C9 74 16 66 0F 2E F8 7A 10 75 0E F2 41 0F 5C F8 F2 0F 11 BC 24 C0 00 00 00 44 89 9C 24 B8 00 00 00 0F AE 94 24 B8 00 00 00 0F 57 C0 66 0F 2F 84 24 B0 00 00 00 F2 0F 10 84 24 C0 00 00 00 76 07 0F 57 05 ?? ?? ?? ?? 4C 8D 9C 24 A0 00 00 00 41 0F 28 73 F0 41 0F 28 7B E0 45 0F 28 43 D0 45 0F 28 4B C0 45 0F 28 53 B0 49 8B E3 5B C3 }
	condition:
		$1
}

rule file_36_3_0 {
	meta:
		name = "scaleDouble_3"
		size = 121
	strings:
		$1 = { 44 8B CA 0F 28 D8 B8 56 55 55 55 F7 EA 41 8B C1 44 8B C2 41 C1 E8 1F 44 03 C2 41 2B C0 49 63 C8 99 2B C2 BA FF 03 00 00 D1 F8 48 03 CA 48 C1 E1 34 44 2B C8 48 89 4C 24 08 48 63 C8 45 2B C8 48 03 CA 49 63 C1 F2 0F 10 44 24 08 48 C1 E1 34 48 03 C2 F2 0F 59 C3 48 89 4C 24 08 48 C1 E0 34 F2 0F 10 54 24 08 48 89 44 24 08 F2 0F 59 C2 F2 0F 10 4C 24 08 F2 0F 59 C1 C3 }
	condition:
		$1
}

rule file_37_10_0 {
	meta:
		name = "??0exception_ptr@std@@QEAA@AEBV01@@Z"
		size = 23
		refs = "000a ?__ExceptionPtrCopy@@YAXPEAXPEBX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_39_597_2 {
	meta:
		name = "??0exception_ptr@std@@QEAA@XZ"
		size = 23
		refs = "000a ?__ExceptionPtrCreate@@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1106_71_0 {
	meta:
		name = "??4QuickBitSet@details@Concurrency@@QEAAAEAV012@AEBV012@@Z"
		size = 23
		refs = "000a ?CopyFrom@QuickBitSet@details@Concurrency@@IEAAXAEBV123@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_49_101_2 {
	meta:
		name = "??E?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QEAAAEAV01@XZ"
		size = 23
		refs = "000a ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_90_370_1 {
	meta:
		name = "??E?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QEAAAEAV01@XZ"
		size = 23
		refs = "000a ?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_90_371_1 {
	meta:
		name = "??E?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@XZ"
		size = 23
		refs = "000a ?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_29_188_1 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAAAEAV01@_J@Z"
		size = 23
		refs = "000a ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_90_386_1 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAAAEAV01@_J@Z"
		size = 23
		refs = "000a ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_90_387_1 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAAAEAV01@_J@Z"
		size = 23
		refs = "000a ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_787_78_0 {
	meta:
		name = "?getECSUName@UnDecorator@@CA?AVDName@@XZ"
		size = 23
		refs = "000a ?getScopedName@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_787_99_0 {
	meta:
		name = "?getReferenceType@UnDecorator@@CA?AVDName@@AEBV2@0PEBD@Z"
		size = 23
		refs = "000a ?getPtrRefType@UnDecorator@@CA?AVDName@@AEBV2@0PEBD@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_787_123_0 {
	meta:
		name = "?getVbTableType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
		size = 23
		refs = "000a ?getVfTableType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_37_30_0 {
	meta:
		name = "?_Current_exception@exception_ptr@std@@SA?AV12@XZ"
		size = 58
		refs = "001c ?__ExceptionPtrCreate@@YAXPEAX@Z 002c ?__ExceptionPtrCurrentException@@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 53 48 83 EC 30 48 C7 44 24 28 FE FF FF FF 48 8B D9 83 64 24 20 00 E8 ?? ?? ?? ?? C7 44 24 20 01 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 CC }
	condition:
		$1
}

rule file_37_31_0 {
	meta:
		name = "?dtor$0@?0??_Current_exception@exception_ptr@std@@SA?AV12@XZ@4HA"
		size = 38
		refs = "001c ??1exception_ptr@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 8B 45 20 83 E0 01 85 C0 74 0D 83 65 20 FE 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_37_33_0 {
	meta:
		name = "?_FinishCancelState@_TaskCollectionBase@details@Concurrency@@IEAAX_K@Z"
		size = 53
	strings:
		$1 = { 48 8B 41 28 4C 8B D2 4C 8B C9 4C 8B C0 49 83 E0 FC 4C 0B C2 F0 4C 0F B1 41 28 74 18 48 8B C8 48 8B D0 48 83 E1 FC 49 0B CA F0 49 0F B1 49 28 48 3B C2 75 E8 C3 }
	condition:
		$1
}

rule file_37_35_0 {
	meta:
		name = "?_GetTokenState@_TaskCollectionBase@details@Concurrency@@QEAAPEAV_CancellationTokenState@23@PEAPEAV_CancellationTokenRegistration@23@@Z"
		size = 39
	strings:
		$1 = { 48 8B 41 10 33 C9 A8 01 74 14 48 8B C8 48 83 E1 FE 74 06 48 8B 41 20 EB 05 B8 02 00 00 00 48 85 D2 74 03 48 89 0A C3 }
	condition:
		$1
}

rule file_37_40_0 {
	meta:
		name = "?_MarkCancellation@_TaskCollectionBase@details@Concurrency@@IEAA_NXZ"
		size = 31
	strings:
		$1 = { 48 8B 41 28 EB 0F 48 8B D0 48 83 CA 01 F0 48 0F B1 51 28 74 07 A8 03 74 ED 32 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule file_37_42_0 {
	meta:
		name = "?_RaisedCancel@_TaskCollectionBase@details@Concurrency@@IEAAXXZ"
		size = 33
	strings:
		$1 = { 48 8B 41 28 EB 12 48 8B D0 83 E2 03 48 83 CA 0C F0 48 0F B1 51 28 74 08 48 A9 FC FF FF FF 74 E6 C3 }
	condition:
		$1
}

rule file_37_43_0 {
	meta:
		name = "?_RaisedException@_TaskCollectionBase@details@Concurrency@@IEAAXXZ"
		size = 139
		refs = "003d ??2@YAPEAX_K@Z 0052 ?current_exception@std@@YA?AVexception_ptr@1@XZ"
	strings:
		$1 = { 40 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 8B D9 48 8B 41 28 48 8B C8 48 83 E1 FC 74 06 48 83 F9 0C 75 60 48 8B C8 83 E1 03 48 83 C9 08 F0 48 0F B1 4B 28 75 DF B9 10 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 40 45 33 C0 48 85 C0 74 0B 48 8B C8 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 43 28 48 8B C8 83 E1 03 49 0B C8 F0 48 0F B1 4B 28 74 17 48 8B D0 48 8B C8 83 E1 03 49 0B C8 F0 48 0F B1 4B 28 48 3B C2 75 E9 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_37_47_0 {
	meta:
		name = "?_RethrowException@_TaskCollectionBase@details@Concurrency@@IEAAXXZ"
		size = 151
		refs = "0030 ?__ExceptionPtrCopy@@YAXPEAXPEBX@Z 0039 ?__ExceptionPtrDestroy@@YAXPEAX@Z 0041 ??3@YAXPEAX@Z 004b ?__uncaught_exception@@YA_NXZ 0072 ?__ExceptionPtrRethrow@@YAXPEBX@Z"
	strings:
		$1 = { 40 57 48 83 EC 50 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 68 48 8B F9 48 8B 59 28 48 83 E3 FC 74 6B 48 83 FB 0C 74 65 48 8B D3 48 8D 4C 24 38 E8 ?? ?? ?? ?? 90 48 8B CB E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 83 67 28 00 E8 ?? ?? ?? ?? 84 C0 75 2F 48 8D 54 24 38 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 44 24 28 48 89 44 24 60 48 8D 4C 24 28 E8 ?? ?? ?? ?? 90 48 8D 4C 24 28 E8 ?? ?? ?? ?? 90 48 8D 4C 24 38 E8 ?? ?? ?? ?? 48 8B 5C 24 68 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_37_51_0 {
	meta:
		name = "?_SafeGetParent@_TaskCollectionBase@details@Concurrency@@IEAAPEAV123@XZ"
		size = 21
	strings:
		$1 = { 8B 41 08 BA FF FF FF 0F 23 C2 3B C2 74 04 48 8B 01 C3 33 C0 C3 }
	condition:
		$1
}

rule file_37_52_0 {
	meta:
		name = "?_WillInterruptForPendingCancel@_TaskCollectionBase@details@Concurrency@@IEAA_NXZ"
		size = 190
		refs = "0063 ?_IsMarkedForAbnormalExit@_TaskCollection@details@Concurrency@@QEBA_NXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 57 48 83 EC 20 8B 41 08 BD FF FF FF 0F 33 DB 23 C5 3B C5 74 05 48 8B 39 EB 03 48 8B FB 48 8B 49 10 F6 C1 01 74 11 48 83 E1 FE 74 06 48 8B 49 20 EB 05 B9 02 00 00 00 48 85 FF 74 66 48 85 C9 75 51 8B 47 08 C1 F8 1C 24 01 74 06 F6 47 28 03 75 3D 84 C0 75 0C 48 8B CF E8 ?? ?? ?? ?? 84 C0 75 2D 48 8B 4F 10 F6 C1 01 74 11 48 83 E1 FE 74 06 48 8B 49 20 EB 05 B9 02 00 00 00 8B 47 08 23 C5 3B C5 74 05 48 8B 3F EB AE 48 8B FB EB A9 B0 01 EB 12 48 83 F9 02 74 0A 8B 49 10 85 C9 0F 95 C0 EB 02 32 C0 48 8B 5C 24 30 48 8B 6C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_37_55_0 {
	meta:
		name = "?current_exception@std@@YA?AVexception_ptr@1@XZ"
		size = 28
		refs = "000f ?_Current_exception@exception_ptr@std@@SA?AV12@XZ"
	strings:
		$1 = { 40 53 48 83 EC 30 83 64 24 20 00 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_37_56_0 {
	meta:
		name = "?rethrow_exception@std@@YAXVexception_ptr@1@@Z"
		size = 41
		refs = "0017 ?__ExceptionPtrRethrow@@YAXPEBX@Z 0025 ?__ExceptionPtrDestroy@@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 8B D9 E8 ?? ?? ?? ?? 90 48 8B CB 48 83 C4 30 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "__sse2_log10f4"
		size = 704
		refs = "0012 flMantissaMask 001a s_dwPosInf 0022 s_dwSqrt2Addition 002d s_fOne 003d s_dwSqrt2Mask 0068 s_dwExpBias 0073 s_fInvLn10 00b0 s_fB2 00ca s_fB1 00d1 s_fB0 00db s_fLg2 0130 s_dwAbsMask 013c s_dwPosZero 0144 s_dwNegInf 0164 s_dwSpecial1 016c s_dwSpecial2 0196 s_fDenoAdd"
	strings:
		$1 = { 48 83 EC 78 0F 29 7C 24 50 0F 29 74 24 60 66 0F 6F 25 ?? ?? ?? ?? 66 0F 6F 1D ?? ?? ?? ?? 66 0F 6F 15 ?? ?? ?? ?? 66 0F DB E0 0F 28 2D ?? ?? ?? ?? 66 0F FE D4 66 0F 6F C8 66 0F DB 15 ?? ?? ?? ?? 66 0F EF EA 66 0F 72 E2 17 66 0F EB E5 66 0F 72 E0 17 0F 28 2D ?? ?? ?? ?? 0F 58 EC 0F 5C 25 ?? ?? ?? ?? 66 0F FA 05 ?? ?? ?? ?? 66 0F FE C2 0F 28 15 ?? ?? ?? ?? 0F 59 D4 0F 5E E5 C7 44 24 70 01 00 00 00 0F 29 4C 24 20 66 0F 66 D9 66 0F 66 0D ?? ?? ?? ?? 0F 5B C0 0F 28 EC 0F 59 E4 66 0F DB D9 0F 28 CC 0F 59 E4 66 0F D7 D3 0F 28 1D ?? ?? ?? ?? 81 FA FF FF 00 00 75 32 C7 44 24 70 00 00 00 00 0F 59 DC 0F 59 25 ?? ?? ?? ?? 0F 58 1D ?? ?? ?? ?? 0F 59 D9 0F 59 05 ?? ?? ?? ?? 0F 58 DC 0F 5C DA 0F 59 DD 0F 58 DA 0F 58 C3 83 7C 24 70 00 75 0F 0F 28 74 24 60 0F 28 7C 24 50 48 83 C4 78 C3 0F 28 54 24 20 0F 28 F2 66 0F EF FF 66 0F 6F C6 66 0F 76 05 ?? ?? ?? ?? 66 0F DB 05 ?? ?? ?? ?? 66 0F EB F8 66 0F 6F C6 66 0F DB 05 ?? ?? ?? ?? 66 0F 6F C8 66 0F 76 05 ?? ?? ?? ?? 66 0F DB 05 ?? ?? ?? ?? 66 0F EB F8 66 0F 66 0D ?? ?? ?? ?? 66 0F DB CE 66 0F EB F9 66 0F 6F C6 66 0F FE 05 ?? ?? ?? ?? 66 0F 66 05 ?? ?? ?? ?? 66 0F EB F8 66 0F 7F 7C 24 30 66 0F 6F C6 66 0F FE 05 ?? ?? ?? ?? 66 0F 66 05 ?? ?? ?? ?? 66 0F 6F C8 66 0F DB 0D ?? ?? ?? ?? 66 0F 7F 4C 24 40 66 0F 6F C8 66 0F 6F D6 66 0F EB 15 ?? ?? ?? ?? 0F 5C 15 ?? ?? ?? ?? 66 0F DB C2 66 0F 76 3D ?? ?? ?? ?? 66 0F DB F7 66 0F DF 3D ?? ?? ?? ?? 66 0F EB FE 66 0F DF CF 66 0F EB C1 66 0F 6F 25 ?? ?? ?? ?? 66 0F 6F 1D ?? ?? ?? ?? 66 0F 6F 15 ?? ?? ?? ?? 66 0F DB E0 0F 28 2D ?? ?? ?? ?? 66 0F FE D4 66 0F 6F C8 66 0F DB 15 ?? ?? ?? ?? 66 0F EF EA 66 0F 72 E2 17 66 0F EB E5 66 0F 72 E0 17 0F 28 3D ?? ?? ?? ?? 0F 58 FC 0F 5C 25 ?? ?? ?? ?? 66 0F FA 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 59 EC 0F 5E E7 66 0F FE C2 0F 28 D1 66 0F 66 D9 66 0F 66 0D ?? ?? ?? ?? 0F 5B C0 0F 28 FC 0F 59 E4 66 0F DB D9 0F 28 CC 0F 59 E4 66 0F D7 D3 0F 28 1D ?? ?? ?? ?? 0F 28 15 ?? ?? ?? ?? 0F 59 DC 0F 59 D4 0F 58 1D ?? ?? ?? ?? 0F 59 D9 0F 59 05 ?? ?? ?? ?? 0F 58 DA 0F 5C DD 0F 59 DF 0F 58 DD 0F 58 C3 66 0F EB 44 24 30 0F 58 44 24 40 0F 28 74 24 60 0F 28 7C 24 50 48 83 C4 78 C3 66 90 }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "fmaxf"
		size = 108
		refs = "0016 _fdtest"
	strings:
		$1 = { F3 0F 11 4C 24 10 F3 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 83 F8 02 75 08 F3 0F 10 44 24 38 EB 3F 48 8D 4C 24 38 E8 ?? ?? ?? ?? 66 83 F8 02 75 08 F3 0F 10 44 24 30 EB 27 F3 0F 10 44 24 38 F3 0F 10 4C 24 30 0F 2F C1 77 16 0F 2E C8 7A 0E 75 0C B8 00 80 00 00 66 85 44 24 32 75 03 0F 28 C1 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "log1p"
		size = 190
		refs = "0015 _dtest 003c __real@bff0000000000000 0052 _fperrraise 005a _Nan_C 0076 _Inf_C 007d __xmm@80000000000000008000000000000000 0087 __real@3ff0000000000000 008f log"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 38 48 8D 4C 24 40 0F 29 7C 24 20 E8 ?? ?? ?? ?? 0F BF C8 85 C9 0F 84 8A 00 00 00 FF C9 74 04 FF C9 EB 0A B8 00 80 00 00 66 85 44 24 46 74 76 F2 0F 10 05 ?? ?? ?? ?? F2 0F 10 7C 24 40 66 0F 2F C7 76 14 B9 01 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? EB 54 66 0F 2E F8 7A 1D 75 1B B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? EB 31 F2 0F 58 3D ?? ?? ?? ?? 0F 28 C7 E8 ?? ?? ?? ?? 0F 28 CF F2 0F 5C 0D ?? ?? ?? ?? F2 0F 5C 4C 24 40 F2 0F 5E CF F2 0F 5C C1 EB 06 F2 0F 10 44 24 40 0F 28 7C 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_578_0_0 {
	meta:
		name = "log1pl"
		size = 190
		refs = "0015 _ldtest 003c __real@bff0000000000000 0052 _fperrraise 005a _LNan_C 0076 _LInf_C 007d __xmm@80000000000000008000000000000000 0087 __real@3ff0000000000000 008f log"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 38 48 8D 4C 24 40 0F 29 7C 24 20 E8 ?? ?? ?? ?? 0F BF C8 85 C9 0F 84 8A 00 00 00 FF C9 74 04 FF C9 EB 0A B8 00 80 00 00 66 85 44 24 46 74 76 F2 0F 10 05 ?? ?? ?? ?? F2 0F 10 7C 24 40 66 0F 2F C7 76 14 B9 01 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? EB 54 66 0F 2E F8 7A 1D 75 1B B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? EB 31 F2 0F 58 3D ?? ?? ?? ?? 0F 28 C7 E8 ?? ?? ?? ?? 0F 28 CF F2 0F 5C 0D ?? ?? ?? ?? F2 0F 5C 4C 24 40 F2 0F 5E CF F2 0F 5C C1 EB 06 F2 0F 10 44 24 40 0F 28 7C 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "_waccess"
		size = 18
		refs = "0005 _waccess_s"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? F7 D8 1B C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_415_0_0 {
	meta:
		name = "_access"
		size = 18
		refs = "0005 _access_s"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? F7 D8 1B C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_41_1_0 {
	meta:
		name = "_waccess_s"
		size = 168
		refs = "0009 __security_cookie 001d __doserrno 0025 _errno 0031 _invalid_parameter_noinfo 004a __imp_GetFileAttributesExW 0054 __imp_GetLastError 005b _dosmaperr 009e __security_check_cookie"
	strings:
		$1 = { 40 53 48 83 EC 50 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 48 8B DA 48 85 C9 75 1D E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 EB 5C F7 C2 F9 FF FF FF 75 DB 4C 8D 44 24 20 33 D2 FF 15 ?? ?? ?? ?? 85 C0 75 16 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 00 EB 2D F6 44 24 20 10 75 24 F6 44 24 20 01 74 1D F6 C3 02 74 18 E8 ?? ?? ?? ?? C7 00 05 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 EB CC 33 C0 48 8B 4C 24 48 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "??2@YAPEAX_KAEBUnothrow_t@std@@@Z"
		size = 31
		refs = "000e ??2@YAPEAX_K@Z"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF E8 ?? ?? ?? ?? 90 EB 05 48 8B 44 24 50 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_42_2_0 {
	meta:
		name = "__catch$??2@YAPEAX_KAEBUnothrow_t@std@@@Z$0"
		size = 19
		refs = "0008 $LN7"
	strings:
		$1 = { 48 83 65 50 00 48 8D 05 ?? ?? ?? ?? 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "__tmainCRTStartup"
		size = 384
		refs = "0012 __set_app_type 001e __ImageBase 0065 _heap_init 006f __error_mode 0077 _FF_MSGBANNER 0081 _NMSG_WRITE 008b __crtExitProcess 0090 _mtinit 00bb _RTC_Initialize 00c1 _ioinit 00cf fast_error_exit 00d5 __imp_GetCommandLineW 00dc _wcmdln 00e1 __crtGetEnvironmentStringsW 00e8 _wenvptr 00ed _wsetargv 00fb _amsg_exit 0100 _wsetenvp 0115 _cinit 0127 _wenviron 012e __winitenv 0135 __wargv 013b __argc 0140 wmain 0151 exit 0156 _cexit 0168 _exit 016e _c_exit"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 30 BF 01 00 00 00 8B CF E8 ?? ?? ?? ?? B8 4D 5A 00 00 66 39 05 ?? ?? ?? ?? 74 04 33 DB EB 38 48 63 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 03 C1 81 38 50 45 00 00 75 E3 B9 0B 02 00 00 66 39 48 18 75 D8 33 DB 83 B8 84 00 00 00 0E 76 09 39 98 F8 00 00 00 0F 95 C3 89 5C 24 40 E8 ?? ?? ?? ?? 85 C0 75 22 83 3D ?? ?? ?? ?? 02 74 05 E8 ?? ?? ?? ?? B9 1C 00 00 00 E8 ?? ?? ?? ?? B9 FF 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 22 83 3D ?? ?? ?? ?? 02 74 05 E8 ?? ?? ?? ?? B9 10 00 00 00 E8 ?? ?? ?? ?? B9 FF 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 85 C0 79 0A B9 1B 00 00 00 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 0A B9 08 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 0A B9 09 00 00 00 E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 85 C0 74 07 8B C8 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? 4C 89 05 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 89 44 24 20 85 DB 75 07 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 17 8B F8 83 7C 24 40 00 75 08 8B C8 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 90 8B C7 48 8B 5C 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_740_0_0 {
	meta:
		name = "__tmainCRTStartup"
		size = 384
		refs = "0012 __set_app_type 001e __ImageBase 0065 _heap_init 006f __error_mode 0077 _FF_MSGBANNER 0081 _NMSG_WRITE 008b __crtExitProcess 0090 _mtinit 00bb _RTC_Initialize 00c1 _ioinit 00cf fast_error_exit 00d5 __imp_GetCommandLineA 00dc _acmdln 00e1 __crtGetEnvironmentStringsA 00e8 _aenvptr 00ed _setargv 00fb _amsg_exit 0100 _setenvp 0115 _cinit 0127 _environ 012e __initenv 0135 __argv 013b __argc 0140 main 0151 exit 0156 _cexit 0168 _exit 016e _c_exit"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 30 BF 01 00 00 00 8B CF E8 ?? ?? ?? ?? B8 4D 5A 00 00 66 39 05 ?? ?? ?? ?? 74 04 33 DB EB 38 48 63 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 03 C1 81 38 50 45 00 00 75 E3 B9 0B 02 00 00 66 39 48 18 75 D8 33 DB 83 B8 84 00 00 00 0E 76 09 39 98 F8 00 00 00 0F 95 C3 89 5C 24 40 E8 ?? ?? ?? ?? 85 C0 75 22 83 3D ?? ?? ?? ?? 02 74 05 E8 ?? ?? ?? ?? B9 1C 00 00 00 E8 ?? ?? ?? ?? B9 FF 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 22 83 3D ?? ?? ?? ?? 02 74 05 E8 ?? ?? ?? ?? B9 10 00 00 00 E8 ?? ?? ?? ?? B9 FF 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 85 C0 79 0A B9 1B 00 00 00 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 0A B9 08 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 0A B9 09 00 00 00 E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 85 C0 74 07 8B C8 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? 4C 89 05 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 89 44 24 20 85 DB 75 07 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 17 8B F8 83 7C 24 40 00 75 08 8B C8 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 90 8B C7 48 8B 5C 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_44_1_0 {
	meta:
		name = "__tmainCRTStartup$filt$0"
		size = 30
		refs = "0012 _XcptFilter"
		altNames = "_callthreadstart$filt$0 _callthreadstartex$filt$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 01 48 8B D1 8B 08 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_44_2_0 {
	meta:
		name = "check_managed_app"
		size = 74
		refs = "0008 __ImageBase"
	strings:
		$1 = { B8 4D 5A 00 00 66 39 05 ?? ?? ?? ?? 74 03 33 C0 C3 48 63 0D ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 03 C8 81 39 50 45 00 00 75 E4 B8 0B 02 00 00 66 39 41 18 75 D9 33 C0 83 B9 84 00 00 00 0E 76 09 39 81 F8 00 00 00 0F 95 C0 C3 }
	condition:
		$1
}

rule file_44_3_0 {
	meta:
		name = "fast_error_exit"
		size = 44
		refs = "0008 __error_mode 0012 _FF_MSGBANNER 0019 _NMSG_WRITE 0028 __crtExitProcess"
	strings:
		$1 = { 40 53 48 83 EC 20 83 3D ?? ?? ?? ?? 02 8B D9 74 05 E8 ?? ?? ?? ?? 8B CB E8 ?? ?? ?? ?? B9 FF 00 00 00 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_4_0 {
	meta:
		name = "wmainCRTStartup"
		size = 18
		refs = "0005 __security_init_cookie 000e __tmainCRTStartup"
		altNames = "WinMainCRTStartup mainCRTStartup wWinMainCRTStartup"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1249_48_0 {
	meta:
		name = "?StandardDeviation@MeasuredHistory@HillClimbing@details@Concurrency@@QEAANXZ"
		size = 18
		refs = "0005 ?Variance@MeasuredHistory@HillClimbing@details@Concurrency@@QEAANXZ 000e sqrt"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_1_0 {
	meta:
		name = "_localtime32"
		size = 69
		refs = "0013 __getgmtimebuf 0028 _localtime32_s"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F9 E8 ?? ?? ?? ?? 33 F6 48 8B D8 48 85 C0 74 14 48 8B D7 48 8B C8 E8 ?? ?? ?? ?? 85 C0 48 0F 45 DE 48 8B C3 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1203_1_0 {
	meta:
		name = "_gmtime32"
		size = 69
		refs = "0013 __getgmtimebuf 0028 _gmtime32_s"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F9 E8 ?? ?? ?? ?? 33 F6 48 8B D8 48 85 C0 74 14 48 8B D7 48 8B C8 E8 ?? ?? ?? ?? 85 C0 48 0F 45 DE 48 8B C3 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1284_0_0 {
	meta:
		name = "_gmtime64"
		size = 69
		refs = "0013 __getgmtimebuf 0028 _gmtime64_s"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F9 E8 ?? ?? ?? ?? 33 F6 48 8B D8 48 85 C0 74 14 48 8B D7 48 8B C8 E8 ?? ?? ?? ?? 85 C0 48 0F 45 DE 48 8B C3 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_899_1_0 {
	meta:
		name = "_localtime64"
		size = 69
		refs = "0013 __getgmtimebuf 0028 _localtime64_s"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F9 E8 ?? ?? ?? ?? 33 F6 48 8B D8 48 85 C0 74 14 48 8B D7 48 8B C8 E8 ?? ?? ?? ?? 85 C0 48 0F 45 DE 48 8B C3 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_46_2_0 {
	meta:
		name = "_localtime32_s"
		size = 722
		refs = "0023 _errno 002f _invalid_parameter_noinfo 0049 memset 0066 __tzset 006f _get_daylight 0080 _get_dstbias 0091 _get_timezone 00ba _gmtime32_s 00d3 _isindst 02a1 _invoke_watson"
	strings:
		$1 = { 40 55 53 57 48 8B EC 48 83 EC 40 83 65 38 00 83 65 F0 00 83 65 30 00 48 8B FA 48 8B D9 48 85 C9 75 1B E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 83 C4 40 5F 5B 5D C3 BA FF 00 00 00 41 B8 24 00 00 00 E8 ?? ?? ?? ?? 48 85 FF 74 D0 83 3F 00 7D 0E E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 EB CE E8 ?? ?? ?? ?? 48 8D 4D 38 E8 ?? ?? ?? ?? 85 C0 0F 85 41 02 00 00 48 8D 4D F0 E8 ?? ?? ?? ?? 85 C0 0F 85 1A 02 00 00 48 8D 4D 30 E8 ?? ?? ?? ?? 85 C0 0F 85 F3 01 00 00 8B 0F 8D 81 7F 0B FC FF 3D FD 16 F8 7F 77 59 2B 4D 30 48 8D 55 20 89 4D 20 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 6F FF FF FF 39 45 38 0F 84 6D 01 00 00 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 84 5D 01 00 00 8B 45 F0 48 8D 55 20 48 8B CB 29 45 20 E8 ?? ?? ?? ?? 85 C0 0F 85 3C FF FF FF C7 43 20 01 00 00 00 E9 37 01 00 00 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 85 1D FF FF FF 39 45 38 74 1D 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 11 8B 0B C7 43 20 01 00 00 00 2B 4D 30 2B 4D F0 EB 05 8B 0B 2B 4D 30 41 B8 89 88 88 88 41 8B C0 F7 E9 03 D1 C1 FA 05 8B C2 C1 E8 1F 03 D0 6B C2 3C 8B D1 2B D0 89 13 79 08 8D 42 3C 83 E9 3C 89 03 41 8B C0 F7 E9 44 8D 0C 11 41 C1 F9 05 41 8B C1 C1 E8 1F 44 03 C8 41 8B C0 44 03 4B 04 41 F7 E9 41 03 D1 C1 FA 05 8B C2 C1 E8 1F 03 D0 6B CA 3C 41 8B D1 2B D1 89 53 04 79 0A 8D 4A 3C 41 83 E9 3C 89 4B 04 41 8B C0 41 F7 E9 45 8D 04 11 41 B9 AB AA AA 2A 41 C1 F8 05 41 8B C0 C1 E8 1F 44 03 C0 41 8B C1 44 03 43 08 41 F7 E8 C1 FA 02 8B C2 C1 E8 1F 03 D0 8D 0C 52 41 8B D0 C1 E1 03 2B D1 89 53 08 79 0A 8D 4A 18 41 83 E8 18 89 4B 08 41 8B C1 41 F7 E8 44 8B C2 41 C1 F8 02 41 8B C0 C1 E8 1F 44 03 C0 45 85 C0 7E 30 8B 4B 18 B8 93 24 49 92 41 03 C8 F7 E9 03 D1 C1 FA 02 8B C2 C1 E8 1F 03 D0 6B C2 07 2B C8 44 01 43 0C 89 4B 18 44 01 43 1C 33 C0 E9 F2 FD FF FF 79 F7 8B 4B 18 44 01 43 0C B8 93 24 49 92 83 C1 07 41 03 C8 F7 E9 03 D1 C1 FA 02 8B C2 C1 E8 1F 03 D0 6B C2 07 2B C8 8B 43 0C 89 4B 18 85 C0 7F C4 83 C0 1F C7 43 10 0B 00 00 00 89 43 0C 41 8D 80 6D 01 00 00 01 43 1C FF 4B 14 EB AC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "ceil"
		size = 273
		refs = "006e ??_C@_04GFPJNGEK@ceil?$AA@ 0090 _handle_error 00ca __real@3ff0000000000000"
	strings:
		$1 = { 48 83 EC 58 45 33 C0 48 B9 FF FF FF FF FF FF FF 7F F2 0F 11 44 24 60 48 8B 54 24 60 0F 28 C8 48 8B C2 48 23 C1 48 B9 00 00 00 00 00 00 40 43 48 3B D0 41 0F 95 C0 48 3B C1 72 5B 48 B9 00 00 00 00 00 00 F0 7F 48 3B C1 0F 86 BE 00 00 00 C7 44 24 40 01 00 00 00 0F 57 C0 49 B8 00 00 00 00 00 00 08 00 4C 0B C2 BA 0C 00 00 00 48 8D 0D ?? ?? ?? ?? F2 0F 11 44 24 38 F2 0F 11 4C 24 30 44 8D 4A F5 C7 44 24 28 21 00 00 00 83 64 24 20 00 E8 ?? ?? ?? ?? EB 76 48 B9 00 00 00 00 00 00 F0 3F 48 3B C1 73 2B 48 85 C0 74 62 4D 85 C0 74 17 48 B8 00 00 00 00 00 00 00 80 48 89 44 24 60 F2 0F 10 44 24 60 EB 46 F2 0F 10 05 ?? ?? ?? ?? EB 3C 48 8B C2 B9 33 00 00 00 48 C1 E8 34 2A C8 B8 01 00 00 00 48 D3 E0 48 FF C8 48 F7 D0 48 23 C2 48 89 44 24 60 F2 0F 10 44 24 60 4D 85 C0 75 0D 48 3B C2 74 08 F2 0F 58 05 ?? ?? ?? ?? 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_48_1_0 {
	meta:
		name = "catanhl"
		size = 840
		refs = "003e creall 0054 cimagl 0062 _ldtest 00a0 __real@bff921fb54442d18 00dc _LZero_C 00e3 __xmm@80000000000000008000000000000000 0127 __real@3ff921fb54442d18 017b __real@5fcffb3abd82527b 0189 __real@3ff0000000000000 0210 _fperrraise 0218 _LInf_C 022e __real@4010000000000000 0236 sqrt 0253 log 025b __real@4000000000000000 0267 atan2 027d __real@3fe0000000000000 02b6 log1pl 02df __real@3fd0000000000000 030e _LCbuild"
	strings:
		$1 = { 48 8B C4 48 89 58 18 55 56 57 48 8B EC 48 81 EC 80 00 00 00 0F 10 02 0F 29 70 D8 0F 29 78 C8 48 8B F1 48 8D 4D A0 48 8B DA 44 0F 29 40 B8 44 0F 29 48 A8 F3 0F 7F 45 A0 44 0F 29 50 98 E8 ?? ?? ?? ?? 48 8D 4D A0 F2 0F 11 45 28 0F 10 03 F3 0F 7F 45 A0 E8 ?? ?? ?? ?? 48 8D 4D 28 F2 0F 11 45 20 E8 ?? ?? ?? ?? 48 8D 4D 20 0F B7 F8 E8 ?? ?? ?? ?? 66 83 FF 02 75 3E 66 3B C7 75 07 F2 0F 10 7D 28 EB 68 BB 01 00 00 00 66 3B C3 75 1B 0F 57 FF 66 0F 2F 7D 20 0F 86 87 00 00 00 F2 0F 10 05 ?? ?? ?? ?? E9 5A 02 00 00 F2 0F 10 7D 28 0F 28 C7 E9 4D 02 00 00 BB 01 00 00 00 66 83 F8 02 75 35 66 3B FB 76 07 F2 0F 10 7D 20 EB E1 B8 00 80 00 00 66 85 45 2E 74 11 F2 0F 10 3D ?? ?? ?? ?? 0F 57 3D ?? ?? ?? ?? EB 03 0F 57 FF F2 0F 10 45 20 E9 0D 02 00 00 66 3B FB 75 35 0F 57 FF 66 0F 2F 7D 28 76 0F F2 0F 10 3D ?? ?? ?? ?? 0F 57 3D ?? ?? ?? ?? B8 00 80 00 00 66 85 45 26 0F 85 79 FF FF FF F2 0F 10 05 ?? ?? ?? ?? E9 D3 01 00 00 F2 0F 10 5D 20 F2 44 0F 10 05 ?? ?? ?? ?? B8 00 80 00 00 44 0F 28 CB 66 85 45 26 74 04 45 0F 57 C8 F2 0F 10 55 28 45 0F 57 D2 66 44 0F 2F D2 76 0B 41 0F 57 D0 F2 0F 11 55 28 EB 0B 41 0F 57 D8 33 DB F2 0F 11 5D 20 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F D0 76 37 F2 0F 10 3D ?? ?? ?? ?? 0F 28 CB F2 0F 5E CA F2 0F 5E FA F2 0F 59 C9 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5E F9 66 44 0F 2F D3 76 31 F2 0F 10 05 ?? ?? ?? ?? E9 39 01 00 00 66 44 0F 2F C8 76 2A F2 0F 5E D3 0F 28 FA F2 0F 59 D2 F2 0F 5E FB F2 0F 58 15 ?? ?? ?? ?? F2 0F 5E FA EB C8 F2 0F 10 05 ?? ?? ?? ?? E9 08 01 00 00 66 0F 2E 15 ?? ?? ?? ?? 0F 8A 8E 00 00 00 0F 85 88 00 00 00 66 41 0F 2E DA 7A 1E 75 1C B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 3D ?? ?? ?? ?? F2 0F 10 45 20 E9 CF 00 00 00 F2 0F 59 DB F2 0F 58 1D ?? ?? ?? ?? 0F 28 C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 28 F0 41 0F 28 C1 E8 ?? ?? ?? ?? F2 0F 5E F0 0F 28 C6 E8 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 0F 28 F8 41 0F 28 C1 E8 ?? ?? ?? ?? 66 44 0F 2F 55 20 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? 76 72 41 0F 57 C0 EB 6C F2 0F 10 35 ?? ?? ?? ?? F2 45 0F 59 C9 F2 0F 5C F2 F2 0F 59 15 ?? ?? ?? ?? 0F 28 CE F2 0F 59 CE F2 41 0F 58 C9 F2 0F 5E D1 0F 28 C2 E8 ?? ?? ?? ?? F2 0F 10 4D 28 F2 0F 58 0D ?? ?? ?? ?? 0F 28 F8 F2 0F 10 45 20 F2 0F 59 CE F2 0F 59 05 ?? ?? ?? ?? F2 0F 59 3D ?? ?? ?? ?? F2 41 0F 5C C9 E8 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? 85 DB 74 06 41 0F 57 F8 EB 04 41 0F 57 C0 48 8D 4D A0 0F 28 D0 0F 28 CF E8 ?? ?? ?? ?? 4C 8D 9C 24 80 00 00 00 0F 28 74 24 70 0F 28 7C 24 60 49 8B 5B 30 0F 10 00 45 0F 28 43 D0 45 0F 28 4B C0 48 8B C6 45 0F 28 53 B0 F3 0F 7F 06 49 8B E3 5F 5E 5D C3 }
	condition:
		$1
}

rule file_244_0_0 {
	meta:
		name = "catanh"
		size = 840
		refs = "003e creal 0054 cimag 0062 _dtest 00a0 __real@bff921fb54442d18 00dc _Zero_C 00e3 __xmm@80000000000000008000000000000000 0127 __real@3ff921fb54442d18 017b __real@5fcffb3abd82527b 0189 __real@3ff0000000000000 0210 _fperrraise 0218 _Inf_C 022e __real@4010000000000000 0236 sqrt 0253 log 025b __real@4000000000000000 0267 atan2 027d __real@3fe0000000000000 02b6 log1p 02df __real@3fd0000000000000 030e _Cbuild"
	strings:
		$1 = { 48 8B C4 48 89 58 18 55 56 57 48 8B EC 48 81 EC 80 00 00 00 0F 10 02 0F 29 70 D8 0F 29 78 C8 48 8B F1 48 8D 4D A0 48 8B DA 44 0F 29 40 B8 44 0F 29 48 A8 F3 0F 7F 45 A0 44 0F 29 50 98 E8 ?? ?? ?? ?? 48 8D 4D A0 F2 0F 11 45 28 0F 10 03 F3 0F 7F 45 A0 E8 ?? ?? ?? ?? 48 8D 4D 28 F2 0F 11 45 20 E8 ?? ?? ?? ?? 48 8D 4D 20 0F B7 F8 E8 ?? ?? ?? ?? 66 83 FF 02 75 3E 66 3B C7 75 07 F2 0F 10 7D 28 EB 68 BB 01 00 00 00 66 3B C3 75 1B 0F 57 FF 66 0F 2F 7D 20 0F 86 87 00 00 00 F2 0F 10 05 ?? ?? ?? ?? E9 5A 02 00 00 F2 0F 10 7D 28 0F 28 C7 E9 4D 02 00 00 BB 01 00 00 00 66 83 F8 02 75 35 66 3B FB 76 07 F2 0F 10 7D 20 EB E1 B8 00 80 00 00 66 85 45 2E 74 11 F2 0F 10 3D ?? ?? ?? ?? 0F 57 3D ?? ?? ?? ?? EB 03 0F 57 FF F2 0F 10 45 20 E9 0D 02 00 00 66 3B FB 75 35 0F 57 FF 66 0F 2F 7D 28 76 0F F2 0F 10 3D ?? ?? ?? ?? 0F 57 3D ?? ?? ?? ?? B8 00 80 00 00 66 85 45 26 0F 85 79 FF FF FF F2 0F 10 05 ?? ?? ?? ?? E9 D3 01 00 00 F2 0F 10 5D 20 F2 44 0F 10 05 ?? ?? ?? ?? B8 00 80 00 00 44 0F 28 CB 66 85 45 26 74 04 45 0F 57 C8 F2 0F 10 55 28 45 0F 57 D2 66 44 0F 2F D2 76 0B 41 0F 57 D0 F2 0F 11 55 28 EB 0B 41 0F 57 D8 33 DB F2 0F 11 5D 20 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F D0 76 37 F2 0F 10 3D ?? ?? ?? ?? 0F 28 CB F2 0F 5E CA F2 0F 5E FA F2 0F 59 C9 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5E F9 66 44 0F 2F D3 76 31 F2 0F 10 05 ?? ?? ?? ?? E9 39 01 00 00 66 44 0F 2F C8 76 2A F2 0F 5E D3 0F 28 FA F2 0F 59 D2 F2 0F 5E FB F2 0F 58 15 ?? ?? ?? ?? F2 0F 5E FA EB C8 F2 0F 10 05 ?? ?? ?? ?? E9 08 01 00 00 66 0F 2E 15 ?? ?? ?? ?? 0F 8A 8E 00 00 00 0F 85 88 00 00 00 66 41 0F 2E DA 7A 1E 75 1C B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 3D ?? ?? ?? ?? F2 0F 10 45 20 E9 CF 00 00 00 F2 0F 59 DB F2 0F 58 1D ?? ?? ?? ?? 0F 28 C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 28 F0 41 0F 28 C1 E8 ?? ?? ?? ?? F2 0F 5E F0 0F 28 C6 E8 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 0F 28 F8 41 0F 28 C1 E8 ?? ?? ?? ?? 66 44 0F 2F 55 20 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? 76 72 41 0F 57 C0 EB 6C F2 0F 10 35 ?? ?? ?? ?? F2 45 0F 59 C9 F2 0F 5C F2 F2 0F 59 15 ?? ?? ?? ?? 0F 28 CE F2 0F 59 CE F2 41 0F 58 C9 F2 0F 5E D1 0F 28 C2 E8 ?? ?? ?? ?? F2 0F 10 4D 28 F2 0F 58 0D ?? ?? ?? ?? 0F 28 F8 F2 0F 10 45 20 F2 0F 59 CE F2 0F 59 05 ?? ?? ?? ?? F2 0F 59 3D ?? ?? ?? ?? F2 41 0F 5C C9 E8 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? 85 DB 74 06 41 0F 57 F8 EB 04 41 0F 57 C0 48 8D 4D A0 0F 28 D0 0F 28 CF E8 ?? ?? ?? ?? 4C 8D 9C 24 80 00 00 00 0F 28 74 24 70 0F 28 7C 24 60 49 8B 5B 30 0F 10 00 45 0F 28 43 D0 45 0F 28 4B C0 48 8B C6 45 0F 28 53 B0 F3 0F 7F 06 49 8B E3 5F 5E 5D C3 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "_execl"
		size = 199
		refs = "001b __security_cookie 0033 _errno 003e _invalid_parameter_noinfo 0075 _capture_argv 008c _execve 00a6 free 00b9 __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 53 57 48 81 EC 48 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 02 00 00 48 8B D9 48 85 C9 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 65 80 39 00 74 E5 48 85 D2 74 E0 80 3A 00 74 DB 48 8D 84 24 70 02 00 00 4C 8D 44 24 30 48 8D 4C 24 20 41 B9 40 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 64 24 20 00 45 33 C0 48 8B D0 48 8B CB 48 8B F8 E8 ?? ?? ?? ?? 48 8B D8 48 85 FF 74 12 48 8D 44 24 30 48 3B F8 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 8B 8C 24 30 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 48 02 00 00 5F 5B C3 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "_wexeclpe"
		size = 217
		refs = "001c __security_cookie 0036 _errno 0041 _invalid_parameter_noinfo 0078 _wcapture_argv 009d _wexecvpe 00b7 free 00ca __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 53 56 57 48 81 EC 40 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 02 00 00 33 F6 48 8B D9 48 85 C9 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 73 66 39 31 74 E5 48 85 D2 74 E0 66 39 32 74 DB 48 8D 84 24 70 02 00 00 4C 8D 44 24 30 48 8D 4C 24 20 41 B9 40 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 4C 8B 44 24 20 48 8B CB 49 83 C0 08 48 8B D0 48 8B F8 4C 89 44 24 20 4D 8B 40 F8 48 89 74 24 20 E8 ?? ?? ?? ?? 48 8B D8 48 85 FF 74 12 48 8D 44 24 30 48 3B F8 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 8B 8C 24 30 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 40 02 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "_wexecle"
		size = 217
		refs = "001c __security_cookie 0036 _errno 0041 _invalid_parameter_noinfo 0078 _wcapture_argv 009d _wexecve 00b7 free 00ca __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 53 56 57 48 81 EC 40 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 02 00 00 33 F6 48 8B D9 48 85 C9 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 73 66 39 31 74 E5 48 85 D2 74 E0 66 39 32 74 DB 48 8D 84 24 70 02 00 00 4C 8D 44 24 30 48 8D 4C 24 20 41 B9 40 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 4C 8B 44 24 20 48 8B CB 49 83 C0 08 48 8B D0 48 8B F8 4C 89 44 24 20 4D 8B 40 F8 48 89 74 24 20 E8 ?? ?? ?? ?? 48 8B D8 48 85 FF 74 12 48 8D 44 24 30 48 3B F8 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 8B 8C 24 30 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 40 02 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "__GSHandlerCheck"
		size = 29
		refs = "000f __GSHandlerCheckCommon"
	strings:
		$1 = { 48 83 EC 28 4D 8B 41 38 48 8B CA 49 8B D1 E8 ?? ?? ?? ?? B8 01 00 00 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_52_1_0 {
	meta:
		name = "__GSHandlerCheckCommon"
		size = 99
		refs = "005f __security_check_cookie"
	strings:
		$1 = { 40 53 48 83 EC 20 45 8B 18 48 8B DA 4C 8B C9 41 83 E3 F8 41 F6 00 04 4C 8B D1 74 13 41 8B 40 08 4D 63 50 04 F7 D8 4C 03 D1 48 63 C8 4C 23 D1 49 63 C3 4A 8B 14 10 48 8B 43 10 8B 48 08 48 03 4B 08 F6 41 03 0F 74 0C 0F B6 41 03 83 E0 F0 48 98 4C 03 C8 4C 33 CA 49 8B C9 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "fgets"
		size = 351
		refs = "0024 _errno 002f _invalid_parameter_noinfo 005e _lock_file 0071 _fileno 007f __pioinfo 00a0 __badioinfo 0115 _filbuf 014c _unlock_file"
	strings:
		$1 = { 40 53 56 57 41 56 41 57 48 83 EC 30 49 8B D8 8B F2 4C 8B F9 4C 8B F1 48 8B F9 48 85 C9 75 1B 85 D2 74 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 19 01 00 00 33 C0 85 D2 0F 99 C0 85 C0 74 DE 33 C0 48 85 DB 0F 95 C0 85 C0 74 D2 85 D2 74 DE 48 89 5C 24 78 48 8B CB E8 ?? ?? ?? ?? 90 F6 43 18 40 0F 85 84 00 00 00 48 8B CB E8 ?? ?? ?? ?? 4C 63 C0 41 8D 48 02 4C 8D 0D ?? ?? ?? ?? 83 F9 01 76 1E 49 8B D0 49 8B C8 48 C1 F9 05 83 E2 1F 48 6B C2 58 49 03 04 C9 48 8D 0D ?? ?? ?? ?? EB 0A 48 8D 0D ?? ?? ?? ?? 48 8B C1 F6 40 38 7F 75 24 41 8D 40 02 83 F8 01 76 15 49 8B C8 49 8B C0 48 C1 F8 05 83 E1 1F 48 6B C9 58 49 03 0C C1 F6 41 38 80 74 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 FF 48 89 7C 24 20 48 85 FF 74 52 FF CE 89 74 24 68 74 46 FF 4B 08 78 0E 48 8B 03 0F B6 08 48 FF C0 48 89 03 EB 0A 48 8B CB E8 ?? ?? ?? ?? 8B C8 89 4C 24 60 83 F9 FF 75 0E 4D 3B F7 75 1B 33 FF 48 89 7C 24 20 EB 16 41 88 0E 49 FF C6 4C 89 74 24 28 80 F9 0A 74 02 EB B2 41 C6 06 00 48 8B CB E8 ?? ?? ?? ?? 48 8B C7 48 83 C4 30 41 5F 41 5E 5F 5E 5B C3 }
	condition:
		$1
}

rule file_55_1_0 {
	meta:
		name = "fgets$fin$0"
		size = 24
		refs = "0013 _unlock_file"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 78 48 83 C4 20 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "__sse2_log2"
		size = 1040
		refs = "0014 BT_Tbl 001c iExpMask 0061 dbOne 0069 dbLog2Hi 0071 iHi43Bits 008f iBias 00a7 dbLog2Lo 0107 dbZero 0138 dbP5 0140 dbP4 0150 dbP3 0158 dbP2 0168 dbP1 01b7 i00100000 01de i001fffff 0382 s_db1022xLn2Lo 038a s_db1022xLn2 03bc dwInf"
	strings:
		$1 = { 48 81 EC 88 00 00 00 0F 29 74 24 70 0F 29 7C 24 60 4C 8D 15 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 70 E8 B1 66 0F 28 C8 66 0F DB F8 66 0F 70 C0 5F 66 0F 7E E8 8B C8 66 0F 7E C2 25 00 F8 0F 00 81 E2 00 F8 0F 00 05 00 08 00 00 81 C2 00 08 00 00 25 00 F0 1F 00 81 E2 00 F0 1F 00 66 0F EB 3D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 70 C9 0D C1 E8 07 C1 EA 07 66 0F 72 D1 14 81 E9 00 00 10 00 66 0F FA 0D ?? ?? ?? ?? F3 0F E6 C9 66 0F DB DF 66 0F 5C FB 66 0F 59 D1 66 0F 59 0D ?? ?? ?? ?? F3 41 0F 7E 24 02 66 41 0F 16 24 12 81 F9 00 00 E0 7F 66 0F 7E C1 0F 83 BE 00 00 00 81 E9 00 00 10 00 81 F9 00 00 E0 7F 0F 83 AC 00 00 00 66 0F 59 DC 66 0F 59 FC 66 41 0F 28 44 02 10 66 0F 28 E8 66 41 0F 28 74 12 10 66 0F 14 C6 66 0F 15 EE 66 0F 58 C2 66 0F 28 E0 66 0F C2 05 ?? ?? ?? ?? 00 66 0F 58 E9 66 0F 5C 1D ?? ?? ?? ?? 66 0F DB C7 66 0F 58 E3 66 0F 58 E0 66 0F DF C7 66 0F 58 FB 66 0F 28 CF 66 0F 59 FF 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 D7 66 0F 59 F7 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 D7 66 0F 59 F1 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 F2 66 0F 59 FE 66 0F 58 FD 66 0F 58 C7 66 0F 58 C4 E9 73 02 00 00 66 0F 70 F5 B1 66 0F 6F EE 66 0F 73 F6 20 66 0F 6F CE 66 0F 72 F6 10 66 0F 6F DD 66 0F EB F1 66 0F 29 5C 24 20 66 0F 72 D6 10 66 0F EB EE 66 0F 6F 0D ?? ?? ?? ?? 66 0F 70 ED F5 66 0F FE CD 66 0F 6F E3 66 0F 6F C1 66 0F 66 0D ?? ?? ?? ?? 66 0F 7F 6C 24 30 66 0F 66 05 ?? ?? ?? ?? 66 0F 6F 35 ?? ?? ?? ?? 66 0F 7F 4C 24 40 66 0F EF C8 66 0F 54 E0 66 0F 55 C6 66 0F 7F 4C 24 50 66 0F 54 F1 66 0F 54 CB 66 0F 56 C1 66 0F 5C C6 66 0F 56 C4 66 0F 28 3D ?? ?? ?? ?? 66 0F 70 E8 B1 66 0F 28 C8 66 0F DB F8 66 0F 70 C0 5F 66 0F 7E E8 8B C8 66 0F 7E C2 25 00 F8 0F 00 81 E2 00 F8 0F 00 05 00 08 00 00 81 C2 00 08 00 00 25 00 F0 1F 00 81 E2 00 F0 1F 00 66 0F EB 3D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 70 C9 0D C1 E8 07 C1 EA 07 66 0F 72 D1 14 81 E9 00 00 10 00 66 0F FA 0D ?? ?? ?? ?? F3 0F E6 C9 66 0F DB DF 66 0F 5C FB 66 0F 59 D1 66 0F 59 0D ?? ?? ?? ?? F3 41 0F 7E 24 02 66 41 0F 16 24 12 81 F9 00 00 E0 7F 66 0F 7E C1 0F 83 C0 FE FF FF 81 E9 00 00 10 00 81 F9 00 00 E0 7F 0F 83 AE FE FF FF 66 0F 59 DC 66 0F 59 FC 66 41 0F 28 44 02 10 66 0F 28 E8 66 41 0F 28 74 12 10 66 0F 14 C6 66 0F 15 EE 66 0F 58 C2 66 0F 28 E0 66 0F C2 05 ?? ?? ?? ?? 00 66 0F 58 E9 66 0F 5C 1D ?? ?? ?? ?? 66 0F DB C7 66 0F 58 E3 66 0F 58 E0 66 0F DF C7 66 0F 58 FB 66 0F 28 CF 66 0F 59 FF 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 D7 66 0F 59 F7 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 D7 66 0F 59 F1 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 F2 66 0F 59 FE 66 0F 58 FD 66 0F 58 C7 66 0F 58 C4 66 0F 28 3D ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 6F 54 24 40 66 0F 6F 5C 24 30 66 0F 6F 64 24 50 66 0F EF ED 66 0F 54 FC 66 0F 54 CC 66 0F 76 ED 66 0F 58 C7 66 0F 58 C1 66 0F 6F 25 ?? ?? ?? ?? 66 0F 54 C2 66 0F EF D5 66 0F 76 E3 66 0F EF C9 66 0F EF D4 66 0F 72 F3 01 66 0F DB 64 24 20 66 0F 76 D9 66 0F EF D3 66 0F 73 F3 34 66 0F EB D4 66 0F EB D3 66 0F 58 C2 0F 28 74 24 70 0F 28 7C 24 60 48 81 C4 88 00 00 00 C3 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "$I10_OUTPUT"
		size = 2776
		refs = "001f __security_cookie 00ee ??_C@_06PGGFOGJG@1?$CDSNAN?$AA@ 00f8 strcpy_s 0123 ??_C@_05PHHOCPM@1?$CDIND?$AA@ 014a ??_C@_05DNEBIAHO@1?$CDINF?$AA@ 0170 ??_C@_06IMKFLFPG@1?$CDQNAN?$AA@ 01a7 _pow10pos 0205 _pow10neg 0a29 __security_check_cookie 0a94 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 10 55 56 57 41 54 41 55 41 56 41 57 48 8D 6C 24 D9 48 81 EC C0 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 17 44 0F B7 51 08 49 8B D9 44 8B 09 89 55 B3 BA 00 80 00 00 41 BB 01 00 00 00 44 89 45 C7 44 8B 41 04 41 0F B7 CA 66 23 CA 44 8D 6A FF 41 8D 43 1F 45 33 E4 66 45 23 D5 48 89 5D BF C7 45 F7 CC CC CC CC C7 45 FB CC CC CC CC C7 45 FF CC CC FB 3F 66 89 4D 99 8D 78 0D 66 85 C9 74 06 40 88 7B 02 EB 03 88 43 02 66 45 85 D2 75 2E 45 85 C0 0F 85 F4 00 00 00 45 85 C9 0F 85 EB 00 00 00 66 3B CA 0F 44 C7 66 44 89 23 88 43 02 66 C7 43 03 01 30 44 88 63 05 E9 5B 09 00 00 66 45 3B D5 0F 85 C5 00 00 00 BE 00 00 00 80 66 44 89 1B 44 3B C6 75 05 45 85 C9 74 29 41 0F BA E0 1E 72 22 48 8D 4B 04 4C 8D 05 ?? ?? ?? ?? BA 16 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 84 82 00 00 00 E9 7B 09 00 00 66 85 C9 74 2B 41 81 F8 00 00 00 C0 75 22 45 85 C9 75 4D 48 8D 4B 04 4C 8D 05 ?? ?? ?? ?? 41 8D 51 16 E8 ?? ?? ?? ?? 85 C0 74 2B E9 60 09 00 00 44 3B C6 75 2B 45 85 C9 75 26 48 8D 4B 04 4C 8D 05 ?? ?? ?? ?? 41 8D 51 16 E8 ?? ?? ?? ?? 85 C0 0F 85 4F 09 00 00 B8 05 00 00 00 88 43 03 EB 21 48 8D 4B 04 4C 8D 05 ?? ?? ?? ?? BA 16 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 3D 09 00 00 C6 43 03 06 45 8B DC E9 8C 08 00 00 41 0F B7 D2 44 89 4D E9 66 44 89 55 F1 41 8B C8 8B C2 4C 8D 0D ?? ?? ?? ?? C1 E9 18 C1 E8 08 41 BF 00 00 00 80 8D 04 48 41 BE 05 00 00 00 49 83 E9 60 44 89 45 ED 66 44 89 65 E7 BE FD BF 00 00 6B C8 4D 69 C2 10 4D 00 00 05 0C ED BC EC 44 89 75 B7 41 8D 7F FF 03 C8 C1 F9 10 44 0F BF D1 89 4D 9F 41 F7 DA 0F 84 6F 03 00 00 45 85 D2 79 11 4C 8D 0D ?? ?? ?? ?? 41 F7 DA 49 83 E9 60 45 85 D2 0F 84 53 03 00 00 44 8B 45 EB 8B 55 E7 41 8B C2 49 83 C1 54 41 C1 FA 03 44 89 55 AF 4C 89 4D A7 83 E0 07 0F 84 19 03 00 00 48 98 48 8D 0C 40 49 8D 34 89 41 B9 00 80 00 00 48 89 75 CF 66 44 39 0E 72 25 8B 46 08 F2 0F 10 06 48 8D 75 07 89 45 0F F2 0F 11 45 07 48 8B 45 07 48 C1 E8 10 48 89 75 CF 41 2B C3 89 45 09 0F B7 4E 0A 0F B7 45 F1 44 89 65 9B 0F B7 D9 66 41 23 CD 48 C7 45 D7 00 00 00 00 66 33 D8 66 41 23 C5 44 89 65 DF 66 41 23 D9 44 8D 0C 08 66 89 5D 97 66 41 3B C5 0F 83 7D 02 00 00 66 41 3B CD 0F 83 73 02 00 00 41 BD FD BF 00 00 66 45 3B CD 0F 87 5D 02 00 00 BB BF 3F 00 00 66 44 3B CB 77 13 48 C7 45 EB 00 00 00 00 41 BD FF 7F 00 00 E9 59 02 00 00 66 85 C0 75 22 66 45 03 CB 85 7D EF 75 19 45 85 C0 75 14 85 D2 75 10 66 44 89 65 F1 41 BD FF 7F 00 00 E9 3B 02 00 00 66 85 C9 75 14 66 45 03 CB 85 7E 08 75 0B 44 39 66 04 75 05 44 39 26 74 AD 41 8B FE 48 8D 55 D7 45 33 F6 44 8B EF 85 FF 7E 5F 43 8D 04 24 4C 8D 75 E7 41 8B DC 48 63 C8 41 23 DB 4C 8D 7E 08 4C 03 F1 33 F6 41 0F B7 07 41 0F B7 0E 44 8B D6 0F AF C8 8B 02 44 8D 04 08 44 3B C0 72 05 44 3B C1 73 03 45 8B D3 44 89 02 45 85 D2 74 05 66 44 01 5A 04 45 2B EB 49 83 C6 02 49 83 EF 02 45 85 ED 7F C2 48 8B 75 CF 45 33 F6 41 2B FB 48 83 C2 02 45 03 E3 85 FF 7F 8C 44 8B 55 DF 44 8B 45 D7 B8 02 C0 00 00 66 44 03 C8 45 33 E4 BB FF FF 00 00 41 BF 00 00 00 80 66 45 85 C9 7E 3C 45 85 D7 75 31 8B 7D DB 41 8B D0 45 03 D2 C1 EA 1F 45 03 C0 8B CF C1 E9 1F 8D 04 3F 66 44 03 CB 0B C2 44 0B D1 44 89 45 D7 89 45 DB 44 89 55 DF 66 45 85 C9 7F CA 66 45 85 C9 7F 6D 66 44 03 CB 79 67 41 0F B7 C1 66 F7 D8 0F B7 D0 66 44 03 CA 66 44 89 4D A3 44 8B 4D 9B 44 84 5D D7 74 03 45 03 CB 8B 7D DB 41 8B C2 41 D1 E8 8B CF C1 E0 1F D1 EF C1 E1 1F 0B F8 41 D1 EA 44 0B C1 89 7D DB 44 89 45 D7 49 2B D3 75 D0 45 85 C9 44 0F B7 4D A3 44 89 55 DF 74 12 41 0F B7 C0 66 41 0B C3 66 89 45 D7 44 8B 45 D7 EB 04 0F B7 45 D7 B9 00 80 00 00 66 3B C1 77 10 41 81 E0 FF FF 01 00 41 81 F8 00 80 01 00 75 48 8B 45 D9 83 CA FF 3B C2 75 38 8B 45 DD 44 89 65 D9 3B C2 75 21 0F B7 45 E1 44 89 65 DD 66 3B C3 75 0A 66 89 4D E1 66 45 03 CB EB 10 66 41 03 C3 66 89 45 E1 EB 06 41 03 C3 89 45 DD 44 8B 55 DF EB 06 41 03 C3 89 45 D9 41 BD FF 7F 00 00 41 BE 05 00 00 00 BF FF FF FF 7F 66 45 3B CD 72 0D 0F B7 45 97 44 8B 55 AF 66 F7 D8 EB 32 0F B7 45 D9 66 44 0B 4D 97 44 89 55 ED 44 8B 55 AF 66 89 45 E7 8B 45 DB 89 45 E9 44 8B 45 EB 8B 55 E7 66 44 89 4D F1 EB 23 41 BD FF 7F 00 00 66 F7 DB 1B C0 44 89 65 EB 41 23 C7 05 00 80 FF 7F 89 45 EF 41 8B D4 45 8B C4 89 55 E7 4C 8B 4D A7 45 85 D2 0F 85 C2 FC FF FF 48 8B 5D BF 8B 4D 9F BE FD BF 00 00 EB 07 44 8B 45 EB 8B 55 E7 8B 45 EF 41 B9 FF 3F 00 00 C1 E8 10 66 41 3B C1 0F 82 B6 02 00 00 66 41 03 CB 41 B9 00 80 00 00 44 89 65 9B 45 8D 51 FF 89 4D 9F 0F B7 4D 01 44 0F B7 E9 66 41 23 CA 48 C7 45 D7 00 00 00 00 66 44 33 E8 66 41 23 C2 44 89 65 DF 66 45 23 E9 44 8D 0C 08 66 41 3B C2 0F 83 58 02 00 00 66 41 3B CA 0F 83 4E 02 00 00 66 44 3B CE 0F 87 44 02 00 00 41 BA BF 3F 00 00 66 45 3B CA 77 09 44 89 65 EF E9 40 02 00 00 66 85 C0 75 1C 66 45 03 CB 85 7D EF 75 13 45 85 C0 75 0E 85 D2 75 0A 66 44 89 65 F1 E9 25 02 00 00 66 85 C9 75 15 66 45 03 CB 85 7D FF 75 0C 44 39 65 FB 75 06 44 39 65 F7 74 BC 41 8B FC 48 8D 55 D7 41 8B F6 45 85 F6 7E 5D 8D 04 3F 4C 8D 7D E7 44 8B E7 48 63 C8 45 23 E3 4C 8D 75 FF 4C 03 F9 33 DB 41 0F B7 07 41 0F B7 0E 44 8B C3 0F AF C8 8B 02 44 8D 14 08 44 3B D0 72 05 44 3B D1 73 03 45 8B C3 44 89 12 45 85 C0 74 05 66 44 01 5A 04 41 2B F3 49 83 C7 02 49 83 EE 02 85 F6 7F C3 44 8B 75 B7 45 33 E4 45 2B F3 48 83 C2 02 41 03 FB 44 89 75 B7 45 85 F6 7F 88 48 8B 5D BF 44 8B 45 DF 44 8B 55 D7 B8 02 C0 00 00 BE 00 00 00 80 41 BE FF FF 00 00 66 44 03 C8 66 45 85 C9 7E 3C 44 85 C6 75 31 8B 7D DB 41 8B D2 45 03 C0 C1 EA 1F 45 03 D2 8B CF C1 E9 1F 8D 04 3F 66 45 03 CE 0B C2 44 0B C1 44 89 55 D7 89 45 DB 44 89 45 DF 66 45 85 C9 7F CA 66 45 85 C9 7F 65 66 45 03 CE 79 5F 8B 5D 9B 41 0F B7 C1 66 F7 D8 0F B7 D0 66 44 03 CA 44 84 5D D7 74 03 41 03 DB 8B 7D DB 41 8B C0 41 D1 EA 8B CF C1 E0 1F D1 EF C1 E1 1F 0B F8 41 D1 E8 44 0B D1 89 7D DB 44 89 55 D7 49 2B D3 75 D0 85 DB 48 8B 5D BF 44 89 45 DF 74 12 41 0F B7 C2 66 41 0B C3 66 89 45 D7 44 8B 55 D7 EB 04 0F B7 45 D7 B9 00 80 00 00 66 3B C1 77 10 41 81 E2 FF FF 01 00 41 81 FA 00 80 01 00 75 49 8B 45 D9 83 CA FF 3B C2 75 39 8B 45 DD 44 89 65 D9 3B C2 75 22 0F B7 45 E1 44 89 65 DD 66 41 3B C6 75 0A 66 89 4D E1 66 45 03 CB EB 10 66 41 03 C3 66 89 45 E1 EB 06 41 03 C3 89 45 DD 44 8B 45 DF EB 06 41 03 C3 89 45 D9 B8 FF 7F 00 00 66 44 3B C8 72 18 66 41 F7 DD 45 8B C4 41 8B D4 1B C0 23 C6 05 00 80 FF 7F 89 45 EF EB 40 0F B7 45 D9 66 45 0B CD 44 89 45 ED 66 89 45 E7 8B 45 DB 66 44 89 4D F1 89 45 E9 44 8B 45 EB 8B 55 E7 EB 1C 66 41 F7 DD 1B C0 41 23 C7 05 00 80 FF 7F 89 45 EF 41 8B D4 45 8B C4 B9 00 80 00 00 8B 45 9F 44 8B 75 B3 66 89 03 44 84 5D C7 74 1D 98 44 03 F0 45 85 F6 7F 14 66 39 4D 99 B8 20 00 00 00 8D 48 0D 0F 44 C1 E9 3C F8 FF FF 44 8B 4D EF B8 15 00 00 00 66 44 89 65 F1 8B 75 EF 44 3B F0 44 8D 50 F3 44 0F 4F F0 41 C1 E9 10 41 81 E9 FE 3F 00 00 41 8B C8 8B C2 03 F6 45 03 C0 C1 E8 1F C1 E9 1F 44 0B C0 0B F1 03 D2 4D 2B D3 75 E4 44 89 45 EB 89 55 E7 45 85 C9 79 32 41 F7 D9 45 0F B6 D1 45 85 D2 7E 26 41 8B C8 8B C6 D1 EA 41 D1 E8 C1 E0 1F C1 E1 1F 45 2B D3 D1 EE 44 0B C0 0B D1 45 85 D2 7F E1 44 89 45 EB 89 55 E7 45 8D 7E 01 48 8D 7B 04 4C 8B D7 45 85 FF 0F 8E D4 00 00 00 F2 0F 10 45 E7 41 8B C8 45 03 C0 C1 E9 1F 8B C2 03 D2 C1 E8 1F 44 8D 0C 36 F2 0F 11 45 07 44 0B C0 44 0B C9 8B C2 41 8B C8 C1 E8 1F 45 03 C0 44 0B C0 8B 45 07 03 D2 C1 E9 1F 45 03 C9 44 8D 24 10 44 0B C9 44 3B E2 72 05 44 3B E0 73 21 45 33 F6 41 8D 40 01 41 8B CE 41 3B C0 72 05 41 3B C3 73 03 41 8B CB 44 8B C0 85 C9 74 03 45 03 CB 48 8B 45 07 48 C1 E8 20 45 8D 34 00 45 3B F0 72 05 44 3B F0 73 03 45 03 CB 41 8B C4 44 03 CE 43 8D 14 24 C1 E8 1F 45 33 E4 47 8D 04 36 44 0B C0 41 8B CE 43 8D 04 09 C1 E9 1F 45 2B FB 89 55 E7 0B C1 44 89 45 EB 89 45 EF C1 E8 18 44 88 65 F2 04 30 41 88 02 4D 03 D3 45 85 FF 7E 08 8B 75 EF E9 2C FF FF FF 4D 2B D3 41 8A 02 4D 2B D3 3C 35 7C 6A EB 0D 41 80 3A 39 75 0C 41 C6 02 30 4D 2B D3 4C 3B D7 73 EE 4C 3B D7 73 07 4D 03 D3 66 44 01 1B 45 00 1A 44 2A D3 41 80 EA 03 49 0F BE C2 44 88 53 03 44 88 64 18 04 41 8B C3 48 8B 4D 17 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 08 01 00 00 48 81 C4 C0 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 41 80 3A 30 75 08 4D 2B D3 4C 3B D7 73 F2 4C 3B D7 73 AF B8 20 00 00 00 41 B9 00 80 00 00 66 44 89 23 66 44 39 4D 99 8D 48 0D 44 88 5B 03 0F 44 C1 88 43 02 C6 07 30 E9 36 F6 FF FF 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 64 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 64 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 64 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 64 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_58_1_0 {
	meta:
		name = "__add_12"
		size = 122
	strings:
		$1 = { 8B 01 44 8B 12 45 33 C9 46 8D 04 10 4C 8B DA 44 3B C0 72 05 45 3B C2 73 06 41 B9 01 00 00 00 44 89 01 45 85 C9 74 23 8B 41 04 45 33 C0 8D 50 01 3B D0 72 05 83 FA 01 73 06 41 B8 01 00 00 00 89 51 04 45 85 C0 74 03 FF 41 08 8B 41 04 45 8B 4B 04 45 33 C0 42 8D 14 08 3B D0 72 05 41 3B D1 73 06 41 B8 01 00 00 00 89 51 04 45 85 C0 74 03 FF 41 08 41 8B 43 08 01 41 08 C3 }
	condition:
		$1
}

rule file_58_2_0 {
	meta:
		name = "__addl"
		size = 25
	strings:
		$1 = { 44 8D 0C 11 33 C0 44 3B C9 72 05 44 3B CA 73 05 B8 01 00 00 00 45 89 08 C3 }
	condition:
		$1
}

rule file_58_3_0 {
	meta:
		name = "__ld12mul"
		size = 813
		refs = "0022 __security_cookie 030c __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 48 89 7C 24 20 55 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 30 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F0 0F B7 42 0A 45 33 E4 4C 8B C1 48 89 4D D8 0F B7 49 0A 0F B7 F0 66 33 F1 48 8B FA BA 00 80 00 00 66 23 F2 BA FF 7F 00 00 44 89 65 D4 66 23 CA 66 23 C2 4C 89 65 E0 44 8D 0C 01 44 89 65 E8 66 89 75 D2 66 44 89 4D D0 66 3B CA 0F 83 6F 02 00 00 66 3B C2 0F 83 66 02 00 00 BA FD BF 00 00 66 44 3B CA 0F 87 57 02 00 00 BA BF 3F 00 00 66 44 3B CA 77 0C 4D 89 60 04 45 89 20 E9 58 02 00 00 BA FF FF FF 7F 41 BE 01 00 00 00 66 85 C9 75 24 66 45 03 CE 66 44 89 4D D0 41 85 50 08 75 15 45 39 60 04 75 0F 45 39 20 75 0A 66 45 89 60 0A E9 24 02 00 00 66 85 C0 75 19 66 45 03 CE 66 44 89 4D D0 85 57 08 75 0B 44 39 67 04 75 05 44 39 27 74 A2 41 BA 05 00 00 00 45 8B F4 48 8D 55 E0 45 8D 4A FC 45 8B FA 45 85 D2 7E 53 43 8D 04 36 41 8B F6 4C 8D 67 08 4C 63 E8 41 23 F1 4D 03 E8 41 0F B7 45 00 41 0F B7 0C 24 45 33 DB 0F AF C8 8B 02 8D 1C 08 3B D8 72 04 3B D9 73 03 45 8B D9 89 1A 45 85 DB 74 05 66 44 01 4A 04 45 2B F9 49 83 C5 02 49 83 EC 02 45 85 FF 7F C4 45 33 E4 45 2B D1 48 83 C2 02 45 03 F1 45 85 D2 7F 96 44 0F B7 4D D0 44 8B 55 E8 44 8B 5D E0 B8 02 C0 00 00 BB 00 00 00 80 41 BF FF FF 00 00 66 44 03 C8 66 45 85 C9 7E 3C 44 85 D3 75 31 8B 7D E4 41 8B D3 45 03 D2 C1 EA 1F 45 03 DB 8B CF C1 E9 1F 8D 04 3F 66 45 03 CF 0B C2 44 0B D1 44 89 5D E0 89 45 E4 44 89 55 E8 66 45 85 C9 7F CA 66 45 85 C9 7F 6D 66 45 03 CF 41 BE 01 00 00 00 79 67 44 8B 45 D4 41 0F B7 C1 66 F7 D8 0F B7 D0 66 44 03 CA 44 84 75 E0 74 03 45 03 C6 8B 7D E4 41 8B C2 41 D1 EB 8B CF C1 E0 1F D1 EF C1 E1 1F 0B F8 41 D1 EA 44 0B D9 89 7D E4 44 89 5D E0 49 2B D6 75 D0 45 85 C0 4C 8B 45 D8 44 89 55 E8 74 18 41 0F B7 C3 66 41 0B C6 66 89 45 E0 44 8B 5D E0 EB 0A 41 BE 01 00 00 00 0F B7 45 E0 0F B7 75 D2 BA 00 80 00 00 66 3B C2 77 10 41 81 E3 FF FF 01 00 41 81 FB 00 80 01 00 75 49 8B 45 E2 83 C9 FF 3B C1 75 39 8B 45 E6 44 89 65 E2 3B C1 75 22 0F B7 45 EA 44 89 65 E6 66 41 3B C7 75 0A 66 89 55 EA 66 45 03 CE EB 10 66 41 03 C6 66 89 45 EA EB 06 41 03 C6 89 45 E6 44 8B 55 E8 EB 06 41 03 C6 89 45 E2 B8 FF 7F 00 00 66 44 3B C8 72 09 49 C7 00 00 00 00 00 EB 26 0F B7 45 E2 66 44 0B CE 45 89 50 06 66 41 89 00 8B 45 E4 66 45 89 48 0A 41 89 40 02 EB 18 BB 00 00 00 80 4D 89 20 66 F7 DE 1B C0 23 C3 05 00 80 FF 7F 41 89 40 08 48 8B 4D F0 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 68 48 8B 74 24 70 48 8B 7C 24 78 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_58_4_0 {
	meta:
		name = "__multtenpow12"
		size = 948
		refs = "002a __security_cookie 0038 _pow10pos 0052 _pow10neg 0392 __security_check_cookie"
	strings:
		$1 = { 85 D2 0F 84 AB 03 00 00 48 89 5C 24 10 48 89 74 24 18 48 89 7C 24 20 55 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 50 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F8 4C 8D 35 ?? ?? ?? ?? 33 FF 8B DA 49 83 EE 60 4C 8B C9 48 89 4D C0 85 D2 79 0D 4C 8D 35 ?? ?? ?? ?? F7 DB 49 83 EE 60 45 85 C0 75 03 66 89 39 85 DB 0F 84 1E 03 00 00 41 BF 00 80 00 00 BE 01 00 00 00 45 8D 5F FF 8B C3 49 83 C6 54 C1 FB 03 89 5D B8 4C 89 75 C8 83 E0 07 0F 84 EE 02 00 00 48 98 48 8D 0C 40 49 8D 14 8E 66 44 39 3A 72 20 8B 42 08 F2 0F 10 02 48 8D 55 E8 89 45 F0 F2 0F 11 45 E8 48 8B 45 E8 48 C1 E8 10 2B C6 89 45 EA 0F B7 4A 0A 41 0F B7 41 0A 89 7D B4 44 0F B7 D1 66 41 23 CB 48 C7 45 D8 00 00 00 00 66 44 33 D0 66 41 23 C3 89 7D E0 66 45 23 D7 44 8D 04 08 66 44 89 55 B0 66 41 3B C3 0F 83 65 02 00 00 66 41 3B CB 0F 83 5B 02 00 00 41 BB FD BF 00 00 66 45 3B C3 0F 87 45 02 00 00 41 BA BF 3F 00 00 66 45 3B C2 77 16 49 C7 41 04 00 00 00 00 41 89 39 41 BB FF 7F 00 00 E9 44 02 00 00 66 85 C0 75 20 66 44 03 C6 41 F7 41 08 FF FF FF 7F 75 12 41 39 79 04 75 0C 41 39 39 75 07 66 41 89 79 0A EB D0 66 85 C9 75 16 66 44 03 C6 F7 42 08 FF FF FF 7F 75 09 39 7A 04 75 04 39 3A 74 AA 45 33 F6 4C 8D 55 D8 45 8D 5E 05 45 8B FE 45 8B E3 45 85 DB 7E 5C 43 8D 04 3F 41 8B DF 4C 8D 6A 08 48 98 23 DE 49 03 C1 4C 8B C8 41 0F B7 45 00 41 0F B7 09 41 8B F6 0F AF C8 41 8B 02 8D 3C 08 3B F8 72 04 3B F9 73 05 BE 01 00 00 00 85 F6 41 89 3A BE 01 00 00 00 74 05 66 41 01 72 04 44 2B E6 49 83 C1 02 49 83 ED 02 45 85 E4 7F BD 4C 8B 4D C0 44 2B DE 49 83 C2 02 44 03 FE 45 85 DB 7F 8D 44 8B 55 E0 44 8B 5D D8 B8 02 C0 00 00 66 44 03 C0 41 BC FF FF 00 00 66 45 85 C0 7E 3C 45 85 D2 78 31 8B 7D DC 41 8B D3 45 03 D2 C1 EA 1F 45 03 DB 8B CF C1 E9 1F 8D 04 3F 66 45 03 C4 0B C2 44 0B D1 44 89 5D D8 89 45 DC 44 89 55 E0 66 45 85 C0 7F CA 66 45 85 C0 7F 66 66 45 03 C4 79 60 44 8B 4D B4 41 0F B7 C0 66 F7 D8 0F B7 D0 66 44 03 C2 40 84 75 D8 74 03 44 03 CE 8B 7D DC 41 8B C2 41 D1 EB 8B CF C1 E0 1F D1 EF C1 E1 1F 0B F8 41 D1 EA 44 0B D9 89 7D DC 44 89 5D D8 48 2B D6 75 D0 45 85 C9 4C 8B 4D C0 44 89 55 E0 74 11 41 0F B7 C3 66 0B C6 66 89 45 D8 44 8B 5D D8 EB 04 0F B7 45 D8 8B 5D B8 4C 8B 75 C8 41 BF 00 80 00 00 66 41 3B C7 77 10 41 81 E3 FF FF 01 00 41 81 FB 00 80 01 00 75 46 8B 45 DA 83 F8 FF 75 39 8B 45 DE 33 FF 89 7D DA 83 F8 FF 75 21 0F B7 45 E2 89 7D DE 66 41 3B C4 75 0B 66 44 89 7D E2 66 44 03 C6 EB 0E 66 03 C6 66 89 45 E2 EB 05 03 C6 89 45 DE 44 8B 55 E0 EB 07 03 C6 89 45 DA 33 FF 41 BB FF 7F 00 00 66 45 3B C3 72 09 0F B7 45 B0 66 F7 D8 EB 29 0F B7 45 DA 66 44 0B 45 B0 45 89 51 06 66 41 89 01 8B 45 DC 66 45 89 41 0A 41 89 41 02 EB 21 41 BB FF 7F 00 00 66 41 F7 DA 1B C0 49 C7 01 00 00 00 00 25 00 00 00 80 05 00 80 FF 7F 41 89 41 08 85 DB 0F 85 F1 FC FF FF 48 8B 4D F8 48 33 CC E8 ?? ?? ?? ?? 4C 8D 5C 24 50 49 8B 5B 38 49 8B 73 40 49 8B 7B 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_58_5_0 {
	meta:
		name = "__shl_12"
		size = 44
	strings:
		$1 = { 8B 01 8B 51 04 44 8B C0 03 C0 44 8B CA 89 01 8D 04 12 41 C1 E8 1F 41 0B C0 41 C1 E9 1F 89 41 04 8B 41 08 03 C0 41 0B C1 89 41 08 C3 }
	condition:
		$1
}

rule file_58_6_0 {
	meta:
		name = "__shr_12"
		size = 43
	strings:
		$1 = { 8B 41 08 8B 51 04 44 8B C0 D1 E8 44 8B CA 89 41 08 8B 01 41 C1 E0 1F 41 C1 E1 1F D1 EA D1 E8 41 0B C1 41 0B D0 89 01 89 51 04 C3 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "realloc"
		size = 211
		refs = "001e malloc 002a free 0039 _crtheap 0053 __imp_HeapReAlloc 0061 _newmode 006b _callnewh 0082 _errno 00a8 __imp_GetLastError 00af _get_errno_from_oserr"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B DA 48 8B F9 48 85 C9 75 0A 48 8B CA E8 ?? ?? ?? ?? EB 6A 48 85 D2 75 07 E8 ?? ?? ?? ?? EB 5C 48 83 FA E0 77 43 48 8B 0D ?? ?? ?? ?? B8 01 00 00 00 48 85 DB 48 0F 44 D8 4C 8B C7 33 D2 4C 8B CB FF 15 ?? ?? ?? ?? 48 8B F0 48 85 C0 75 6F 39 05 ?? ?? ?? ?? 74 50 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 2B 48 83 FB E0 76 BD 48 8B CB E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 E8 ?? ?? ?? ?? 48 8B D8 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 89 03 EB D5 E8 ?? ?? ?? ?? 48 8B D8 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 89 03 48 8B C6 EB BB }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "_makepath_s"
		size = 328
		refs = "0085 _mbsdec 010d _errno 012c _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 56 48 83 EC 20 48 8B F2 4C 8B F1 48 85 C9 0F 84 FB 00 00 00 48 85 D2 0F 84 F2 00 00 00 33 FF 48 8B D9 4D 85 C0 74 21 41 8A 00 84 C0 74 1A BF 02 00 00 00 48 3B D7 0F 86 BC 00 00 00 48 8D 59 01 88 01 C6 03 3A 48 FF C3 49 8B D1 4D 85 C9 74 41 41 80 39 00 74 3B 48 FF C7 48 3B FE 0F 83 96 00 00 00 8A 02 48 FF C2 88 03 48 FF C3 80 3A 00 75 E5 49 8B C9 E8 ?? ?? ?? ?? 80 38 2F 74 13 80 38 5C 74 0E 48 FF C7 48 3B FE 73 6D C6 03 5C 48 FF C3 48 8B 4C 24 50 48 85 C9 74 19 EB 12 48 FF C7 48 3B FE 73 53 8A 01 88 03 48 FF C3 48 FF C1 80 39 00 75 E9 48 8B 4C 24 58 48 85 C9 74 31 8A 01 84 C0 74 2B 3C 2E 74 22 48 FF C7 48 3B FE 73 28 C6 03 2E 48 FF C3 EB 12 48 FF C7 48 3B FE 73 18 8A 01 88 03 48 FF C3 48 FF C1 80 39 00 75 E9 48 8D 47 01 48 3B C6 76 10 41 C6 06 00 E8 ?? ?? ?? ?? BB 22 00 00 00 EB 11 C6 03 00 33 C0 EB 13 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 30 48 8B 74 24 38 48 8B 7C 24 40 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "_fwscanf_l"
		size = 49
		refs = "001f _winput_l 0028 vfwscanf_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 4C 8B C2 49 8D 43 20 48 8B D1 48 8D 0D ?? ?? ?? ?? 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "_fscanf_l"
		size = 49
		refs = "001f _input_l 0028 vfscanf_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 4C 8B C2 49 8D 43 20 48 8B D1 48 8D 0D ?? ?? ?? ?? 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_157_1_0 {
	meta:
		name = "_fscanf_s_l"
		size = 49
		refs = "001f _input_s_l 0028 vfscanf_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 4C 8B C2 49 8D 43 20 48 8B D1 48 8D 0D ?? ?? ?? ?? 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_62_1_0 {
	meta:
		name = "_fwscanf_s_l"
		size = 49
		refs = "001f _winput_s_l 0028 vfwscanf_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 4C 8B C2 49 8D 43 20 48 8B D1 48 8D 0D ?? ?? ?? ?? 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_868_0_0 {
	meta:
		name = "_sscanf_l"
		size = 49
		refs = "001f _input_l 0028 vscan_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 4C 8B C2 49 8D 43 20 48 8B D1 48 8D 0D ?? ?? ?? ?? 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_868_1_0 {
	meta:
		name = "_sscanf_s_l"
		size = 49
		refs = "001f _input_s_l 0028 vscan_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 4C 8B C2 49 8D 43 20 48 8B D1 48 8D 0D ?? ?? ?? ?? 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "_swscanf_l"
		size = 49
		refs = "001f _winput_l 0028 vscan_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 4C 8B C2 49 8D 43 20 48 8B D1 48 8D 0D ?? ?? ?? ?? 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_128_1_0 {
	meta:
		name = "_swscanf_s_l"
		size = 49
		refs = "001f _winput_s_l 0028 vscan_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 4C 8B C2 49 8D 43 20 48 8B D1 48 8D 0D ?? ?? ?? ?? 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_62_2_0 {
	meta:
		name = "fwscanf"
		size = 53
		refs = "0020 _winput_l 002c vfwscanf_fn"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4C 8B C2 49 8D 43 18 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_157_2_0 {
	meta:
		name = "fscanf"
		size = 53
		refs = "0020 _input_l 002c vfscanf_fn"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4C 8B C2 49 8D 43 18 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_157_3_0 {
	meta:
		name = "fscanf_s"
		size = 53
		refs = "0020 _input_s_l 002c vfscanf_fn"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4C 8B C2 49 8D 43 18 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_62_3_0 {
	meta:
		name = "fwscanf_s"
		size = 53
		refs = "0020 _winput_s_l 002c vfwscanf_fn"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4C 8B C2 49 8D 43 18 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_868_2_0 {
	meta:
		name = "sscanf"
		size = 53
		refs = "0020 _input_l 002c vscan_fn"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4C 8B C2 49 8D 43 18 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_868_3_0 {
	meta:
		name = "sscanf_s"
		size = 53
		refs = "0020 _input_s_l 002c vscan_fn"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4C 8B C2 49 8D 43 18 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_128_2_0 {
	meta:
		name = "swscanf"
		size = 53
		refs = "0020 _winput_l 002c vscan_fn"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4C 8B C2 49 8D 43 18 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_128_3_0 {
	meta:
		name = "swscanf_s"
		size = 53
		refs = "0020 _winput_s_l 002c vscan_fn"
	strings:
		$1 = { 4C 8B DC 49 89 53 10 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4C 8B C2 49 8D 43 18 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 49 89 43 E8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_62_4_0 {
	meta:
		name = "vfwscanf"
		size = 35
		refs = "0012 _winput_l 001a vfwscanf_fn"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_150_1_0 {
	meta:
		name = "_vfprintf_p"
		size = 35
		refs = "0012 _output_p_l 001a vfprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_757_1_0 {
	meta:
		name = "_vfwprintf_p"
		size = 35
		refs = "0012 _woutput_p_l 001a vfwprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_150_4_0 {
	meta:
		name = "vfprintf"
		size = 35
		refs = "0012 _output_l 001a vfprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_150_7_0 {
	meta:
		name = "vfprintf_s"
		size = 35
		refs = "0012 _output_s_l 001a vfprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_157_4_0 {
	meta:
		name = "vfscanf"
		size = 35
		refs = "0012 _input_l 001a vfscanf_fn"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_157_7_0 {
	meta:
		name = "vfscanf_s"
		size = 35
		refs = "0012 _input_s_l 001a vfscanf_fn"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_757_4_0 {
	meta:
		name = "vfwprintf"
		size = 35
		refs = "0012 _woutput_l 001a vfwprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_757_7_0 {
	meta:
		name = "vfwprintf_s"
		size = 35
		refs = "0012 _woutput_s_l 001a vfwprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_62_7_0 {
	meta:
		name = "vfwscanf_s"
		size = 35
		refs = "0012 _winput_s_l 001a vfwscanf_fn"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_868_5_0 {
	meta:
		name = "vsscanf"
		size = 35
		refs = "0012 _input_l 001a vscan_fn"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_868_6_0 {
	meta:
		name = "vsscanf_s"
		size = 35
		refs = "0012 _input_s_l 001a vscan_fn"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_128_5_0 {
	meta:
		name = "vswscanf"
		size = 35
		refs = "0012 _winput_l 001a vscan_fn"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_128_6_0 {
	meta:
		name = "vswscanf_s"
		size = 35
		refs = "0012 _winput_s_l 001a vscan_fn"
	strings:
		$1 = { 48 83 EC 38 4C 89 44 24 20 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_62_5_0 {
	meta:
		name = "vfwscanf_fn"
		size = 142
		refs = "0032 _errno 003d _invalid_parameter_noinfo 0056 _lock_file 0072 _unlock_file"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 18 48 89 78 20 48 89 50 10 41 56 48 83 EC 20 49 8B F1 49 8B F8 48 8B DA 4C 8B F1 33 C0 48 85 D2 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 32 33 C0 4D 85 C0 0F 95 C0 85 C0 74 DF 48 8B CA E8 ?? ?? ?? ?? 90 4C 8B 4C 24 50 4C 8B C6 48 8B D7 48 8B CB 41 FF D6 8B F8 48 8B CB E8 ?? ?? ?? ?? 8B C7 48 8B 5C 24 30 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "_fread_nolock"
		size = 29
		refs = "0014 _fread_nolock_s"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 83 CA FF E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_64_2_0 {
	meta:
		name = "fread"
		size = 29
		refs = "0014 fread_s"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 83 CA FF E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_64_1_0 {
	meta:
		name = "_fread_nolock_s"
		size = 543
		refs = "003d _errno 0048 _invalid_parameter_noinfo 008a memset 010d memcpy_s 0178 _fileno 018a _read_nolock 01a6 _filbuf"
	strings:
		$1 = { 48 89 5C 24 18 4C 89 4C 24 20 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 20 4D 8B F0 48 8B EA 4C 8B E1 4C 8B F9 48 89 4C 24 68 4C 8B EA 4D 85 C0 74 1A 4D 85 C9 74 15 48 85 C9 75 27 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 48 8B 5C 24 70 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 48 8B BC 24 80 00 00 00 48 85 FF 74 0E 33 D2 48 83 C8 FF 49 F7 F6 4C 3B C8 76 28 48 83 FD FF 74 0F 4C 8B C5 33 D2 E8 ?? ?? ?? ?? 4C 8B 4C 24 78 48 85 FF 74 A4 33 D2 48 83 C8 FF 49 F7 F6 4C 3B C8 77 96 49 8B DE 49 0F AF D9 F7 47 18 0C 01 00 00 48 8B F3 74 05 8B 4F 24 EB 05 B9 00 10 00 00 89 4C 24 60 48 85 DB 0F 84 0A 01 00 00 F7 47 18 0C 01 00 00 41 B9 FF FF FF 7F 74 58 4C 63 7F 08 45 85 FF 74 4A 0F 88 17 01 00 00 49 3B F7 44 0F 42 FE 45 8B CF 4D 3B CD 0F 87 E1 00 00 00 4C 8B 07 48 8B 4C 24 68 49 8B D5 E8 ?? ?? ?? ?? 44 29 7F 08 41 8B C7 4C 8B 7C 24 68 48 2B F0 48 01 07 8B 4C 24 60 4C 03 F8 4C 2B E8 E9 95 00 00 00 4C 8B 7C 24 68 44 8B C1 49 3B F0 72 63 85 C9 74 1F 33 D2 49 3B F1 76 0A 41 8B C1 45 8B F9 F7 F1 EB 09 48 8B C6 44 8B FE 49 F7 F0 44 2B FA EB 0A 44 8B FE 49 3B F1 45 0F 47 F9 41 8B C7 49 3B C5 77 6E 48 8B CF E8 ?? ?? ?? ?? 45 8B C7 4C 8B 7C 24 68 49 8B D7 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 84 83 00 00 00 83 F8 FF 74 6A 8B C0 48 2B F0 EB 81 48 8B CF E8 ?? ?? ?? ?? 83 F8 FF 74 5A 4D 85 ED 74 2E 41 88 07 8B 4F 24 48 FF CE 49 FF C7 49 FF CD 89 4C 24 60 4C 89 7C 24 68 48 85 F6 0F 85 FB FE FF FF 4C 8B 4C 24 78 49 8B C1 E9 6C FE FF FF 48 83 FD FF 74 0D 4C 8B C5 33 D2 49 8B CC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 22 00 00 00 E9 42 FE FF FF 83 4F 18 20 48 2B DE 33 D2 48 8B C3 49 F7 F6 E9 35 FE FF FF 83 4F 18 10 EB EA }
	condition:
		$1
}

rule file_64_3_0 {
	meta:
		name = "fread_s"
		size = 167
		refs = "0045 memset 004a _errno 0055 _invalid_parameter_noinfo 005f _lock_file 0076 _fread_nolock_s 0081 _unlock_file"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 4C 89 70 20 41 57 48 83 EC 30 49 8B F1 4D 8B F8 48 8B FA 4C 8B F1 4D 85 C0 74 60 4D 85 C9 74 5B 48 8B 5C 24 60 48 85 DB 75 22 48 83 FA FF 74 0A 4C 8B C2 33 D2 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 2F 48 8B CB E8 ?? ?? ?? ?? 90 48 89 5C 24 20 4C 8B CE 4D 8B C7 48 8B D7 49 8B CE E8 ?? ?? ?? ?? 48 8B F8 48 8B CB E8 ?? ?? ?? ?? 48 8B C7 EB 02 33 C0 48 8B 5C 24 40 48 8B 74 24 48 48 8B 7C 24 50 4C 8B 74 24 58 48 83 C4 30 41 5F C3 }
	condition:
		$1
}

rule file_64_4_0 {
	meta:
		name = "fread_s$fin$0"
		size = 24
		refs = "0013 _unlock_file"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA 48 8B 4D 60 48 83 C4 30 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "fabs"
		size = 224
		refs = "002e _ctrlfp 004b _sptype 006f _except1 0081 _handle_qnan1 0095 __xmm@80000000000000008000000000000000"
	strings:
		$1 = { 48 89 5C 24 18 F2 0F 11 44 24 08 57 48 83 EC 40 0F 57 C9 BF C0 FF 00 00 B9 80 1F 00 00 8B D7 0F 29 74 24 30 0F 28 F0 F2 0F 11 4C 24 58 E8 ?? ?? ?? ?? 0F B7 4C 24 56 48 8B D8 B8 F0 7F 00 00 66 23 C8 66 3B C8 75 64 0F 28 C6 E8 ?? ?? ?? ?? FF C8 74 48 FF C8 74 30 FF C8 74 1A BA 15 00 00 00 0F 28 DE 0F 28 D6 48 89 5C 24 20 8D 4A F3 E8 ?? ?? ?? ?? EB 5B 0F 28 CE 4C 8B C3 B9 15 00 00 00 E8 ?? ?? ?? ?? EB 49 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 0F 57 35 ?? ?? ?? ?? EB 0B 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 0F 28 C6 EB 25 8B 44 24 54 48 8B D7 48 8B CB 0F BA F0 1F 89 44 24 5C 8B 44 24 50 89 44 24 58 E8 ?? ?? ?? ?? F2 0F 10 44 24 58 48 8B 5C 24 60 0F 28 74 24 30 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "_wputenv"
		size = 50
		refs = "000f _lock 001a _wputenv_helper 0026 _unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 33 D2 48 8B CB E8 ?? ?? ?? ?? 8B D8 B9 07 00 00 00 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_701_0_0 {
	meta:
		name = "_putenv"
		size = 50
		refs = "000f _lock 001a _putenv_helper 0026 _unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 33 D2 48 8B CB E8 ?? ?? ?? ?? 8B D8 B9 07 00 00 00 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_66_1_0 {
	meta:
		name = "_wputenv$fin$0"
		size = 25
		refs = "0014 _unlock"
		altNames = "_putenv$fin$0 _putenv_s$fin$0 _wgetenv$fin$0 _wputenv_s$fin$0 getenv$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 07 00 00 00 48 83 C4 20 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_66_2_0 {
	meta:
		name = "_wputenv_helper"
		size = 700
		refs = "0025 __env_initialized 003d _errno 0048 _invalid_parameter_noinfo 005b wcschr 0083 wcsnlen 0090 wcslen 00a1 _calloc_crt 0110 wcscpy_s 0146 __crtwsetenv 015c free 0168 _environ 0199 __imp_WideCharToMultiByte 023f strlen 0284 __crtsetenv"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 55 57 41 54 41 56 41 57 48 8B EC 48 83 EC 40 45 33 E4 48 8B F2 48 8B F9 44 39 25 ?? ?? ?? ?? 4C 89 65 48 75 08 83 C8 FF E9 6E 02 00 00 48 85 C9 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB E1 48 85 D2 75 67 44 8D 7A 3D 41 8B D7 E8 ?? ?? ?? ?? 48 85 C0 74 28 48 8B C8 48 2B CF 48 83 E1 FE 48 81 F9 FE FF 00 00 7D C5 BB FF 7F 00 00 48 8D 48 02 8B D3 E8 ?? ?? ?? ?? 48 3B C3 73 B0 48 8B CF E8 ?? ?? ?? ?? BA 02 00 00 00 48 8D 48 01 48 8B D8 E8 ?? ?? ?? ?? 48 89 45 48 48 85 C0 74 81 4C 8B C7 48 8D 53 01 48 8B C8 EB 7D BB FF 7F 00 00 8B D3 E8 ?? ?? ?? ?? 8B D3 48 8B CE 4C 8B F0 E8 ?? ?? ?? ?? 4C 3B F3 0F 83 60 FF FF FF 48 3B C3 0F 83 57 FF FF FF 48 8D 58 02 BA 02 00 00 00 49 03 DE 48 8B CB E8 ?? ?? ?? ?? 48 89 45 48 48 85 C0 0F 84 29 FF FF FF 4C 8B C7 48 8B D3 48 8B C8 E8 ?? ?? ?? ?? 48 8B 45 48 41 BF 3D 00 00 00 66 46 89 3C 70 48 8B 45 48 49 FF C6 49 2B DE 4C 8B C6 4A 8D 0C 70 48 8B D3 E8 ?? ?? ?? ?? 48 8D 4D 48 BA 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 17 48 8B 4D 48 48 85 C9 0F 84 D4 FE FF FF E8 ?? ?? ?? ?? E9 CA FE FF FF 4C 39 25 ?? ?? ?? ?? 0F 84 31 01 00 00 4C 89 64 24 38 4C 89 64 24 30 83 CB FF 4C 8B C7 33 D2 33 C9 44 8B CB 44 89 64 24 28 4C 89 65 40 4C 89 64 24 20 FF 15 ?? ?? ?? ?? 44 8B F0 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 8B C3 E9 EF 00 00 00 48 85 F6 74 2E 4C 89 64 24 38 4C 89 64 24 30 44 8B CB 4C 8B C6 33 D2 33 C9 44 89 64 24 28 4C 89 64 24 20 FF 15 ?? ?? ?? ?? 85 C0 74 C1 41 FF C6 44 03 F0 49 63 CE BA 01 00 00 00 E8 ?? ?? ?? ?? 48 89 45 40 48 85 C0 74 B0 4C 89 64 24 38 4C 89 64 24 30 44 8B CB 4C 8B C7 33 D2 33 C9 44 89 74 24 28 48 89 44 24 20 FF 15 ?? ?? ?? ?? 85 C0 75 0E 48 8B 4D 40 E8 ?? ?? ?? ?? E9 6F FF FF FF 48 85 F6 74 43 48 8B 4D 40 E8 ?? ?? ?? ?? 48 8B 4D 40 4C 89 64 24 38 44 88 3C 08 48 FF C0 4C 89 64 24 30 44 2B F0 48 03 45 40 44 8B CB 4C 8B C6 33 D2 33 C9 44 89 74 24 28 48 89 44 24 20 FF 15 ?? ?? ?? ?? 85 C0 74 AA 48 8D 4D 40 33 D2 E8 ?? ?? ?? ?? 85 C0 74 17 48 8B 4D 40 48 85 C9 0F 84 16 FF FF FF E8 ?? ?? ?? ?? E9 0C FF FF FF 33 C0 48 8B 5C 24 70 48 8B 74 24 78 48 83 C4 40 41 5F 41 5E 41 5C 5F 5D C3 }
	condition:
		$1
}

rule file_66_3_0 {
	meta:
		name = "_wputenv_s"
		size = 117
		refs = "0024 _errno 0030 _invalid_parameter_noinfo 003e _lock 004a _wputenv_helper 005f _unlock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B FA 48 8B F1 33 DB 8B C3 48 85 D2 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 EB 2D B9 07 00 00 00 E8 ?? ?? ?? ?? 90 48 8B D7 48 8B CE E8 ?? ?? ?? ?? 85 C0 74 07 E8 ?? ?? ?? ?? 8B 18 B9 07 00 00 00 E8 ?? ?? ?? ?? EB CF 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_701_3_0 {
	meta:
		name = "_putenv_s"
		size = 117
		refs = "0024 _errno 0030 _invalid_parameter_noinfo 003e _lock 004a _putenv_helper 005f _unlock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B FA 48 8B F1 33 DB 8B C3 48 85 D2 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 EB 2D B9 07 00 00 00 E8 ?? ?? ?? ?? 90 48 8B D7 48 8B CE E8 ?? ?? ?? ?? 85 C0 74 07 E8 ?? ?? ?? ?? 8B 18 B9 07 00 00 00 E8 ?? ?? ?? ?? EB CF 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "feof"
		size = 40
		refs = "000a _errno 0015 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 48 85 C9 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 06 8B 41 18 83 E0 10 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_67_1_0 {
	meta:
		name = "ferror"
		size = 40
		refs = "000a _errno 0015 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 48 85 C9 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 06 8B 41 18 83 E0 20 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_68_4_0 {
	meta:
		name = "_mbsbtype_l"
		size = 179
		refs = "001e ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0028 _errno 0033 _invalid_parameter_noinfo 0066 _mbbtype_l"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 40 48 8B F9 48 8B F2 48 8D 4C 24 20 49 8B D0 E8 ?? ?? ?? ?? 48 85 FF 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 CB FF EB 50 48 8B 44 24 28 83 78 08 00 75 04 33 DB EB 41 83 CB FF 8B D3 48 85 F6 75 05 40 38 37 74 32 8A 0F 84 C9 74 1C 4C 8D 44 24 20 E8 ?? ?? ?? ?? 48 FF C7 8B D0 48 8B C6 48 FF CE 48 85 C0 74 14 EB D4 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B D3 80 7C 24 38 00 74 0C 48 8B 4C 24 30 83 A1 C8 00 00 00 FD 48 8B 5C 24 50 48 8B 74 24 58 8B C2 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "_flsbuf"
		size = 395
		refs = "001e _fileno 002e _errno 008d __iob_func 00ab _isatty 00b7 _getbuf 00ea _write 010e __pioinfo 0126 __badioinfo 0139 _lseeki64"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 68 18 48 89 70 20 89 48 08 57 48 83 EC 20 48 8B CA 48 8B DA E8 ?? ?? ?? ?? 8B 4B 18 48 63 F0 F6 C1 82 75 17 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 4B 18 20 83 C8 FF E9 32 01 00 00 F6 C1 40 74 0D E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB E2 33 FF F6 C1 01 74 19 89 7B 08 F6 C1 10 0F 84 89 00 00 00 48 8B 43 10 83 E1 FE 48 89 03 89 4B 18 8B 43 18 89 7B 08 83 E0 EF 83 C8 02 89 43 18 A9 0C 01 00 00 75 2F E8 ?? ?? ?? ?? 48 83 C0 30 48 3B D8 74 0E E8 ?? ?? ?? ?? 48 83 C0 60 48 3B D8 75 0B 8B CE E8 ?? ?? ?? ?? 85 C0 75 08 48 8B CB E8 ?? ?? ?? ?? F7 43 18 08 01 00 00 0F 84 8B 00 00 00 8B 2B 48 8B 53 10 2B 6B 10 48 8D 42 01 48 89 03 8B 43 24 FF C8 89 43 08 85 ED 7E 19 44 8B C5 8B CE E8 ?? ?? ?? ?? 8B F8 EB 55 83 C9 20 89 4B 18 E9 3F FF FF FF 8D 46 02 83 F8 01 76 1E 48 8B CE 48 8B C6 4C 8D 05 ?? ?? ?? ?? 83 E1 1F 48 C1 F8 05 48 6B D1 58 49 03 14 C0 EB 07 48 8D 15 ?? ?? ?? ?? F6 42 08 20 74 17 33 D2 8B CE 44 8D 42 02 E8 ?? ?? ?? ?? 48 83 F8 FF 0F 84 F1 FE FF FF 48 8B 4B 10 8A 44 24 30 88 01 EB 16 BD 01 00 00 00 48 8D 54 24 30 8B CE 44 8B C5 E8 ?? ?? ?? ?? 8B F8 3B FD 0F 85 C7 FE FF FF 0F B6 44 24 30 48 8B 5C 24 38 48 8B 6C 24 40 48 8B 74 24 48 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "_mkdir"
		size = 70
		refs = "0018 __copy_path_to_wide_string 002e _wmkdir 003a free"
	strings:
		$1 = { 40 53 48 83 EC 20 33 DB 48 89 5C 24 30 48 85 C9 74 18 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 1B 48 8B 5C 24 30 48 8B CB E8 ?? ?? ?? ?? 48 8B 4C 24 30 8B D8 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_423_0_0 {
	meta:
		name = "_rmdir"
		size = 70
		refs = "0018 __copy_path_to_wide_string 002e _wrmdir 003a free"
	strings:
		$1 = { 40 53 48 83 EC 20 33 DB 48 89 5C 24 30 48 85 C9 74 18 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 1B 48 8B 5C 24 30 48 8B CB E8 ?? ?? ?? ?? 48 8B 4C 24 30 8B D8 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1181_1_0 {
	meta:
		name = "remove"
		size = 70
		refs = "0018 __copy_path_to_wide_string 002e _wremove 003a free"
	strings:
		$1 = { 40 53 48 83 EC 20 33 DB 48 89 5C 24 30 48 85 C9 74 18 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 1B 48 8B 5C 24 30 48 8B CB E8 ?? ?? ?? ?? 48 8B 4C 24 30 8B D8 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "sin"
		size = 1300
		refs = "0006 __use_fma3_lib 002b L_piby4 0044 L_small_arg_cw 0056 L_2_by_pi 0069 L_one_half 0071 L_real_piby2_1 007d L_real_piby2_1tail 00a1 L_real_piby2_2 00ae L_real_piby2_2tail 010c __Lsinarray 01b0 __Lcosarray 01d6 L_one 02f3 L__inf_mask_64 02ff __remainder_piby2_forAsm 0321 _sin_special 034d L_two_to_neg_13 0356 L_two_to_neg_27 037d L_one_sixth 03f5 L_small_arg_bdl 0400 __remainder_piby2_fma3_bdl 04d9 L_signbit 0506 __remainder_piby2_fma3"
	strings:
		$1 = { 48 83 EC 78 83 3D ?? ?? ?? ?? 00 0F 85 1F 03 00 00 66 48 0F 7E C2 66 0F 57 D2 4C 8B D2 41 B8 01 00 00 00 49 0F BA F2 3F 4C 3B 15 ?? ?? ?? ?? 0F 82 4B 02 00 00 4C 8B DA 49 C1 EB 3F 66 49 0F 6E C2 4C 3B 15 ?? ?? ?? ?? 0F 83 A2 02 00 00 66 0F 28 D0 F2 0F 59 15 ?? ?? ?? ?? 66 0F 28 E0 4D 8B CA 49 C1 E9 34 F2 0F 58 15 ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? 66 0F E6 C2 F2 0F 10 0D ?? ?? ?? ?? F3 0F E6 D0 F2 0F 59 DA F2 0F 5C E3 F2 0F 59 CA 66 0F 7E C0 66 0F 28 C4 F2 0F 5C C1 F2 0F 10 1D ?? ?? ?? ?? 66 48 0F 7E C1 F2 0F 10 2D ?? ?? ?? ?? 48 D1 E1 48 C1 E9 35 4C 2B C9 49 83 F9 0F 7E 28 66 0F 28 CC F2 0F 59 DA F2 0F 59 EA F2 0F 5C E3 F2 0F 5C CC F2 0F 5C CB F2 0F 5C E9 66 0F 28 C4 66 0F 28 CD F2 0F 5C C5 F2 0F 5C E0 F2 0F 5C E1 66 0F 28 D8 66 0F 28 D0 F2 0F 59 D0 0F BA E0 00 0F 82 98 00 00 00 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 DA F2 0F 10 2D ?? ?? ?? ?? F2 0F 11 64 24 30 66 0F 28 CA F2 0F 59 CA F2 0F 11 44 24 40 F2 0F 59 EA 66 0F 28 E0 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 DA F2 0F 59 E2 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EA F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? F2 0F 10 44 24 30 F2 0F 59 D9 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 D0 F2 0F 58 DD F2 0F 59 E3 F2 0F 5C E2 F2 0F 58 C4 F2 0F 58 44 24 40 E9 AF 00 00 00 0F 1F 80 00 00 00 00 F2 0F 59 E0 F2 0F 10 2D ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 EA 66 0F 28 DA F2 0F 11 64 24 30 F2 0F 59 CA F2 0F 59 C2 F2 0F 5C 2D ?? ?? ?? ?? F2 0F 59 DA F2 0F 58 0D ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 DA F2 0F 59 CA F2 0F 59 C2 66 0F 28 E2 F2 0F 59 25 ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 D2 F2 0F 5C EC F2 0F 59 CB F2 0F 58 C1 F2 0F 5C 25 ?? ?? ?? ?? F2 0F 5C 6C 24 30 F2 0F 59 C2 F2 0F 58 C5 F2 0F 5C C4 D1 E8 8B C8 41 23 C3 F7 D1 41 F7 D3 41 23 CB 0B C1 83 E0 01 75 12 66 0F 28 D0 66 0F 57 C0 F2 0F 5C C2 66 0F 1F 44 00 00 48 83 C4 78 C3 66 66 66 0F 1F 84 00 00 00 00 00 66 0F 28 D0 F2 0F 59 D0 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 DA F2 0F 10 2D ?? ?? ?? ?? 66 0F 28 CA F2 0F 59 CA F2 0F 59 EA 66 0F 28 E0 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 DA F2 0F 59 E2 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EA F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 D9 F2 0F 58 2D ?? ?? ?? ?? F2 0F 58 DD F2 0F 59 E3 F2 0F 58 C4 EB 82 66 90 4C 3B 15 ?? ?? ?? ?? 73 27 4C 89 5C 24 30 E8 ?? ?? ?? ?? 4C 8B 5C 24 30 66 0F 28 E1 E9 E1 FD FF FF 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 78 C3 66 0F 1F 44 00 00 C4 C1 F9 7E C1 4D 8B D1 49 0F BA F1 3F 4C 3B 0D ?? ?? ?? ?? 0F 83 96 00 00 00 4C 3B 0D ?? ?? ?? ?? 73 3D 4C 3B 0D ?? ?? ?? ?? 73 14 48 83 C4 78 C3 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 C5 FB 59 C8 C5 F3 59 C8 C4 E2 F1 BD 05 ?? ?? ?? ?? 48 83 C4 78 C3 66 66 0F 1F 84 00 00 00 00 00 C5 FB 10 2D ?? ?? ?? ?? C5 FB 59 D8 C4 E2 E1 A9 2D ?? ?? ?? ?? C4 E2 E1 A9 2D ?? ?? ?? ?? C4 E2 E1 A9 2D ?? ?? ?? ?? C4 E2 E1 A9 2D ?? ?? ?? ?? C5 FB 59 E3 C4 E2 E1 A9 2D ?? ?? ?? ?? C4 E2 D9 B9 C5 48 83 C4 78 C3 66 0F 1F 84 00 00 00 00 00 4C 3B 0D ?? ?? ?? ?? 0F 83 33 FF FF FF C4 C1 F9 6E C1 4C 3B 0D ?? ?? ?? ?? 0F 83 01 01 00 00 E8 ?? ?? ?? ?? 48 0F BA E0 00 C5 FB 59 D8 72 61 C5 FB 10 2D ?? ?? ?? ?? C4 E2 E1 A9 2D ?? ?? ?? ?? C4 E2 E1 A9 2D ?? ?? ?? ?? C4 E2 E1 A9 2D ?? ?? ?? ?? C4 E2 E1 A9 2D ?? ?? ?? ?? C5 FB 59 E3 C5 DB 59 D5 C5 F3 59 2D ?? ?? ?? ?? C5 D3 5C D2 C5 E3 59 D2 C5 EB 5C D1 C4 E2 D9 BD 15 ?? ?? ?? ?? C5 FB 5C C2 EB 6D 66 66 0F 1F 84 00 00 00 00 00 C5 F9 28 15 ?? ?? ?? ?? C5 E3 59 2D ?? ?? ?? ?? C5 EB 5C E5 C5 EB 5C D4 C5 EB 5C D5 C5 FB 10 2D ?? ?? ?? ?? C4 E2 F9 BD D1 C5 E3 59 CB C4 E2 E1 A9 2D ?? ?? ?? ?? C4 E2 E1 A9 2D ?? ?? ?? ?? C4 E2 E1 A9 2D ?? ?? ?? ?? C4 E2 E1 A9 2D ?? ?? ?? ?? C4 E2 E1 A9 2D ?? ?? ?? ?? C4 E2 F1 A9 EA C5 D3 58 C4 4D 33 C0 4C 23 15 ?? ?? ?? ?? 0F BA E0 01 4C 0F 42 05 ?? ?? ?? ?? 4D 33 C2 C4 C1 F9 6E D8 C5 F9 57 C3 48 83 C4 78 C3 66 0F 1F 44 00 00 4C 89 54 24 50 E8 ?? ?? ?? ?? 4C 8B 54 24 50 E9 F0 FE FF FF }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "_read"
		size = 284
		refs = "002a __doserrno 0033 _errno 004e _nhandle 0065 __pioinfo 00a7 __lock_fhandle 00c2 _read_nolock 00e2 _unlock_fhandle 00fd _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 89 4C 24 08 57 41 54 41 55 41 56 41 57 48 83 EC 20 41 8B F0 4C 8B FA 48 63 F9 83 FF FE 75 19 E8 ?? ?? ?? ?? 33 DB 89 18 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 BF 00 00 00 33 DB 85 C9 0F 88 9E 00 00 00 3B 3D ?? ?? ?? ?? 0F 83 92 00 00 00 48 8B C7 4C 8B F7 49 C1 FE 05 4C 8D 2D ?? ?? ?? ?? 83 E0 1F 4C 6B E0 58 4B 8B 44 F5 00 42 0F BE 4C 20 08 83 E1 01 74 6A 8B C3 41 81 F8 FF FF FF 7F 0F 96 C0 85 C0 75 14 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 58 8B CF E8 ?? ?? ?? ?? 90 4B 8B 44 F5 00 42 F6 44 20 08 01 74 11 44 8B C6 49 8B D7 8B CF E8 ?? ?? ?? ?? 8B D8 EB 15 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 18 83 CB FF 8B CF E8 ?? ?? ?? ?? 8B C3 EB 1A E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 8B 5C 24 58 48 8B 74 24 60 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_73_1_0 {
	meta:
		name = "_read$fin$0"
		size = 23
		refs = "0012 _unlock_fhandle"
		altNames = "_filelength$fin$0 _filelengthi64$fin$0 _locking$fin$0 _lseek$fin$0 _lseeki64$fin$0 _write$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 8B 4D 50 48 83 C4 20 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_73_2_0 {
	meta:
		name = "_read_nolock"
		size = 2160
		refs = "003b __doserrno 0042 _errno 005c _nhandle 006f __ImageBase 007e __pioinfo 010a _malloc_crt 013b _lseeki64_nolock 021b _isatty 0248 __imp_GetConsoleMode 027f __imp_ReadConsoleW 0289 __imp_GetLastError 0290 _dosmaperr 02cb __imp_ReadFile 04bf _lookuptrailbytes 0578 __imp_MultiByteToWideChar 0653 free 0858 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 55 53 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 58 41 8B D8 33 FF 4C 63 C1 4C 8B CA C7 45 E0 FE FF FF FF 89 7D E8 89 5D F0 41 83 F8 FE 75 17 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 0B 08 00 00 85 C9 0F 88 EC 07 00 00 44 3B 05 ?? ?? ?? ?? 0F 83 DF 07 00 00 49 8B C0 4D 8B E8 4C 8D 15 ?? ?? ?? ?? 83 E0 1F 49 C1 FD 05 4B 8B 8C EA ?? ?? ?? ?? 4C 6B F0 58 42 8A 44 31 08 A8 01 0F 84 B2 07 00 00 81 FB FF FF FF 7F 76 17 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 A5 07 00 00 8B F7 85 DB 0F 84 85 07 00 00 A8 02 0F 85 7D 07 00 00 48 85 D2 74 D2 42 8A 54 31 38 41 BB 04 00 00 00 02 D2 D0 FA 0F BE CA 88 55 60 FF C9 74 14 FF C9 75 0B 8B C3 F7 D0 A8 01 74 AD 83 E3 FE 4D 8B F9 EB 64 8B C3 F7 D0 A8 01 74 9D D1 EB 41 3B DB 41 0F 42 DB 8B CB E8 ?? ?? ?? ?? 4C 8B F8 48 85 C0 75 1B E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? C7 00 08 00 00 00 E9 2B 07 00 00 8B 4D 48 33 D2 44 8D 42 01 E8 ?? ?? ?? ?? 8A 55 60 44 8B 45 48 4C 8D 15 ?? ?? ?? ?? 4B 8B 8C EA ?? ?? ?? ?? 4A 89 44 31 40 4B 8B 84 EA ?? ?? ?? ?? 4D 8B E7 41 B9 0A 00 00 00 42 F6 44 30 08 48 0F 84 A0 00 00 00 42 8A 4C 30 09 41 3A C9 0F 84 92 00 00 00 85 DB 0F 84 8A 00 00 00 41 88 0F 4B 8B 84 EA ?? ?? ?? ?? 41 83 CB FF 41 03 DB 4D 8D 67 01 41 8D 71 F7 46 88 4C 30 09 84 D2 74 67 4B 8B 84 EA ?? ?? ?? ?? 42 8A 4C 30 39 41 3A C9 74 55 85 DB 74 51 41 88 0C 24 4B 8B 84 EA ?? ?? ?? ?? 41 03 DB 49 FF C4 41 8D 71 F8 46 88 4C 30 39 80 FA 01 75 31 4B 8B 84 EA ?? ?? ?? ?? 42 8A 4C 30 3A 41 3A C9 74 1F 85 DB 74 1B 41 88 0C 24 4B 8B 84 EA ?? ?? ?? ?? 49 FF C4 41 8D 71 F9 41 03 DB 46 88 4C 30 3A 41 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 84 80 00 00 00 48 8D 0D ?? ?? ?? ?? 4A 8B 8C E9 ?? ?? ?? ?? 42 F6 44 31 08 80 74 69 4A 8B 0C 31 48 8D 55 E8 FF 15 ?? ?? ?? ?? 89 45 E8 85 C0 74 54 80 7D 60 02 75 4E 48 8D 05 ?? ?? ?? ?? D1 EB 4C 8D 4D DC 4A 8B 8C E8 ?? ?? ?? ?? 49 8B D4 44 8B C3 4A 8B 0C 31 48 89 7C 24 20 FF 15 ?? ?? ?? ?? 85 C0 75 15 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 83 CB FF E9 AA 03 00 00 8B 45 DC 8D 14 00 89 55 DC EB 47 48 8D 0D ?? ?? ?? ?? 4C 8D 4D DC 44 8B C3 4A 8B 8C E9 ?? ?? ?? ?? 49 8B D4 48 89 7C 24 20 4A 8B 0C 31 FF 15 ?? ?? ?? ?? 85 C0 0F 84 34 05 00 00 48 63 55 DC 85 D2 0F 88 28 05 00 00 8B C3 48 3B D0 0F 87 1D 05 00 00 4C 8D 15 ?? ?? ?? ?? 03 F2 4B 8B 8C EA ?? ?? ?? ?? 42 8A 44 31 08 84 C0 0F 89 37 03 00 00 80 7D 60 02 0F 84 A5 02 00 00 85 D2 BA 0A 00 00 00 74 09 41 38 17 75 04 0C 04 EB 02 24 FB 42 88 44 31 08 48 63 C6 49 8B DF 49 03 C7 4D 8B E7 48 89 45 E8 4C 3B F8 0F 83 33 01 00 00 BE 0D 00 00 00 41 8A 04 24 3C 1A 0F 84 FF 00 00 00 40 3A C6 74 0D 88 03 48 FF C3 49 FF C4 E9 E1 00 00 00 48 8B 45 E8 48 FF C8 4C 3B E0 73 1A 49 8D 44 24 01 38 10 75 09 49 83 C4 02 E9 88 00 00 00 4C 8B E0 E9 B5 00 00 00 4B 8B 8C EA ?? ?? ?? ?? 4C 8D 4D DC 48 8D 55 58 4A 8B 0C 31 41 B8 01 00 00 00 49 FF C4 48 89 7C 24 20 FF 15 ?? ?? ?? ?? 85 C0 75 0A FF 15 ?? ?? ?? ?? 85 C0 75 73 39 7D DC 74 6E 4C 8D 15 ?? ?? ?? ?? 4B 8B 84 EA ?? ?? ?? ?? 42 F6 44 30 08 48 74 1F BA 0A 00 00 00 38 55 58 74 24 40 88 33 4B 8B 8C EA ?? ?? ?? ?? 8A 45 58 42 88 44 31 09 EB 47 49 3B DF 75 0E BA 0A 00 00 00 38 55 58 75 04 88 13 EB 34 8B 4D 48 41 B8 01 00 00 00 48 83 CA FF E8 ?? ?? ?? ?? BA 0A 00 00 00 4C 8D 15 ?? ?? ?? ?? 38 55 58 74 14 EB 0C BA 0A 00 00 00 4C 8D 15 ?? ?? ?? ?? 40 88 33 48 FF C3 4C 3B 65 E8 0F 82 F7 FE FF FF EB 23 4B 8B 8C EA ?? ?? ?? ?? 42 8A 44 31 08 A8 40 75 09 0C 02 42 88 44 31 08 EB 09 41 8A 04 24 88 03 48 FF C3 8B F3 41 2B F7 80 7D 60 01 0F 85 B9 01 00 00 85 F6 0F 84 B1 01 00 00 48 FF CB F6 03 80 75 08 48 FF C3 E9 B2 00 00 00 BA 01 00 00 00 EB 0F 83 FA 04 7F 17 49 3B DF 72 12 48 FF CB FF C2 0F B6 03 42 38 BC 10 ?? ?? ?? ?? 74 E4 0F B6 0B 42 0F BE 84 11 ?? ?? ?? ?? 85 C0 75 10 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E9 AF FD FF FF FF C0 3B C2 75 08 48 63 C2 48 03 D8 EB 61 4B 8B 84 EA ?? ?? ?? ?? 42 F6 44 30 08 48 74 3E 48 FF C3 42 88 4C 30 09 83 FA 02 7C 12 8A 03 4B 8B 8C EA ?? ?? ?? ?? 48 FF C3 42 88 44 31 39 83 FA 03 75 12 8A 03 4B 8B 8C EA ?? ?? ?? ?? 48 FF C3 42 88 44 31 3A 48 63 C2 48 2B D8 EB 13 8B 4D 48 F7 DA 41 B8 01 00 00 00 48 63 D2 E8 ?? ?? ?? ?? 8B 45 F0 4C 8B 65 50 41 2B DF D1 E8 44 8B CB 4D 8B C7 89 44 24 28 33 D2 B9 E9 FD 00 00 4C 89 64 24 20 FF 15 ?? ?? ?? ?? 8B F0 85 C0 75 15 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 83 CB FF E9 B3 00 00 00 3B C3 8B 5D E0 48 8D 05 ?? ?? ?? ?? 4A 8B 84 E8 ?? ?? ?? ?? 40 0F 95 C7 03 F6 42 89 7C 30 48 E9 8F 00 00 00 39 7D E8 0F 84 A0 00 00 00 8B C6 4D 8B C7 4D 8B CF 99 2B C2 D1 F8 48 63 C8 49 8D 14 4F 4C 3B FA 73 5B BE 0D 00 00 00 8D 4E FD 41 0F B7 01 66 83 F8 1A 74 3B 66 3B C6 74 0E 66 41 89 00 49 83 C0 02 49 83 C1 02 EB 21 48 8D 42 FE 4C 3B C8 73 18 49 83 C1 02 66 41 39 09 75 06 66 41 89 08 EB 04 66 41 89 30 49 83 C0 02 4C 3B CA 72 BD EB 0E 4B 8B 84 EA ?? ?? ?? ?? 42 80 4C 30 08 02 4D 2B C7 49 8B F0 48 D1 FE 03 F6 8B 5D E0 4C 8B 65 50 4D 3B FC 74 08 49 8B CF E8 ?? ?? ?? ?? 83 FB FE 0F 44 DE 8B C3 E9 FB 01 00 00 85 D2 BA 0A 00 00 00 74 0A 66 41 39 17 75 04 0C 04 EB 02 24 FB 42 88 44 31 08 48 63 C6 49 8B DF 49 03 C7 4D 8B E7 48 89 45 60 4C 3B F8 0F 83 6A 01 00 00 BE 0D 00 00 00 41 0F B7 04 24 66 83 F8 1A 0F 84 30 01 00 00 66 3B C6 74 10 66 89 03 48 83 C3 02 49 83 C4 02 E9 0F 01 00 00 48 8B 45 60 48 83 C0 FE 4C 3B E0 73 1B 49 8D 44 24 02 66 39 10 75 09 49 83 C4 04 E9 B0 00 00 00 4C 8B E0 E9 E0 00 00 00 4B 8B 8C EA ?? ?? ?? ?? 4C 8D 4D DC 48 8D 55 D8 4A 8B 0C 31 41 B8 02 00 00 00 49 83 C4 02 48 89 7C 24 20 FF 15 ?? ?? ?? ?? 85 C0 75 0E FF 15 ?? ?? ?? ?? 85 C0 0F 85 99 00 00 00 39 7D DC 0F 84 90 00 00 00 4C 8D 15 ?? ?? ?? ?? 4B 8B 84 EA ?? ?? ?? ?? 42 F6 44 30 08 48 74 3D BA 0A 00 00 00 66 39 55 D8 74 42 66 89 33 8A 45 D8 4B 8B 8C EA ?? ?? ?? ?? 42 88 44 31 09 8A 45 D9 4B 8B 8C EA ?? ?? ?? ?? 42 88 44 31 39 4B 8B 84 EA ?? ?? ?? ?? 42 88 54 30 3A EB 4B 49 3B DF 75 10 BA 0A 00 00 00 66 39 55 D8 75 05 66 89 13 EB 36 8B 4D 48 48 C7 C2 FE FF FF FF 44 8D 42 03 E8 ?? ?? ?? ?? BA 0A 00 00 00 4C 8D 15 ?? ?? ?? ?? 66 39 55 D8 74 15 EB 0C BA 0A 00 00 00 4C 8D 15 ?? ?? ?? ?? 66 89 33 48 83 C3 02 4C 3B 65 60 0F 82 C3 FE FF FF EB 26 4B 8B 8C EA ?? ?? ?? ?? 42 8A 44 31 08 A8 40 75 09 0C 02 42 88 44 31 08 EB 0C 41 0F B7 04 24 66 89 03 48 83 C3 02 41 2B DF 8B F3 E9 38 FE FF FF FF 15 ?? ?? ?? ?? 83 F8 05 75 1B E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? C7 00 05 00 00 00 E9 63 FA FF FF 83 F8 6D 0F 85 53 FA FF FF 8B DF E9 05 FE FF FF 33 C0 EB 1A E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 83 C4 58 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "__vdecl_fmod2"
		size = 61
		refs = "0011 fmod"
	strings:
		$1 = { 48 83 EC 48 F3 0F 7F 44 24 20 F3 0F 7F 4C 24 30 E8 ?? ?? ?? ?? 66 0F D6 44 24 20 F3 0F 7E 44 24 28 F3 0F 7E 4C 24 38 E8 ?? ?? ?? ?? 66 0F D6 44 24 28 F3 0F 6F 44 24 20 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "?_inconsistency@@YAXXZ"
		size = 32
		refs = "0007 ?__pInconsistency@@3P6AXXZEA 000d __imp_DecodePointer 001b ?terminate@@YAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 85 C0 74 04 FF D0 EB 00 E8 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_75_1_0 {
	meta:
		name = "?terminate@@YAXXZ"
		size = 31
		refs = "0005 _getptd 001a abort"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B 88 D0 00 00 00 48 85 C9 74 04 FF D1 EB 00 E8 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_75_2_0 {
	meta:
		name = "?unexpected@@YAXXZ"
		size = 29
		refs = "0005 _getptd 0018 ?terminate@@YAXXZ"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B 88 D8 00 00 00 48 85 C9 74 02 FF D1 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_75_3_0 {
	meta:
		name = "_initp_eh_hooks"
		size = 29
		refs = "0007 ?terminate@@YAXXZ 000d __imp_EncodePointer 0014 ?__pInconsistency@@3P6AXXZEA"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_76_1_0 {
	meta:
		name = "?_invoke_watson@@YAXPEBG00I_K@Z"
		size = 20
		refs = "000f _invoke_watson"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_76_2_0 {
	meta:
		name = "_call_reportfault"
		size = 242
		refs = "0021 __security_cookie 003c __crt_debugger_hook 0053 memset 006f __crtCaptureCurrentContext 00a6 __imp_IsDebuggerPresent 00b2 __crtUnhandledException 00d5 __security_check_cookie"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 70 18 48 89 78 20 55 48 8D A8 48 FB FF FF 48 81 EC B0 05 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 A0 04 00 00 41 8B F8 8B F2 8B D9 83 F9 FF 74 05 E8 ?? ?? ?? ?? 83 64 24 30 00 48 8D 4C 24 34 33 D2 41 B8 94 00 00 00 E8 ?? ?? ?? ?? 48 8D 44 24 30 48 8D 4D D0 48 89 44 24 20 48 8D 45 D0 48 89 44 24 28 E8 ?? ?? ?? ?? 48 8B 85 B8 04 00 00 48 89 85 C8 00 00 00 48 8D 85 B8 04 00 00 89 74 24 30 48 83 C0 08 89 7C 24 34 48 89 45 68 48 8B 85 B8 04 00 00 48 89 44 24 40 FF 15 ?? ?? ?? ?? 48 8D 4C 24 20 8B F8 E8 ?? ?? ?? ?? 85 C0 75 10 85 FF 75 0C 83 FB FF 74 07 8B CB E8 ?? ?? ?? ?? 48 8B 8D A0 04 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 B0 05 00 00 49 8B 5B 18 49 8B 73 20 49 8B 7B 28 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_76_5_0 {
	meta:
		name = "_invalid_parameter"
		size = 101
		refs = "001a __pInvalidArgHandler 0029 __imp_DecodePointer 0060 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 30 48 8B E9 48 8B 0D ?? ?? ?? ?? 41 8B D9 49 8B F8 48 8B F2 FF 15 ?? ?? ?? ?? 44 8B CB 4C 8B C7 48 8B D6 48 8B CD 48 85 C0 74 17 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 30 5F 48 FF E0 48 8B 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_76_6_0 {
	meta:
		name = "_invalid_parameter_noinfo"
		size = 30
		refs = "0015 _invalid_parameter"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_76_7_0 {
	meta:
		name = "_invalid_parameter_noinfo_noreturn"
		size = 47
		refs = "0015 _invalid_parameter 002a _invoke_watson"
	strings:
		$1 = { 48 83 EC 38 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_76_8_0 {
	meta:
		name = "_invoke_watson"
		size = 59
		refs = "000a IsProcessorFeaturePresent 0029 _call_reportfault 0037 __crtTerminateProcess"
	strings:
		$1 = { 48 83 EC 28 B9 17 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 07 B9 05 00 00 00 CD 29 41 B8 01 00 00 00 BA 17 04 00 C0 41 8D 48 01 E8 ?? ?? ?? ?? B9 17 04 00 C0 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_9_0 {
	meta:
		name = "_set_invalid_parameter_handler"
		size = 59
		refs = "0010 __pInvalidArgHandler 0016 __imp_DecodePointer 0022 __imp_EncodePointer"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B CF 48 8B D8 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_1150_0_0 {
	meta:
		name = "?__set_inconsistency@@YAP6AXXZP6AXXZ@Z"
		size = 59
		refs = "0010 ?__pInconsistency@@3P6AXXZEA 0016 __imp_DecodePointer 0022 __imp_EncodePointer"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B CF 48 8B D8 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_837_2_0 {
	meta:
		name = "_set_purecall_handler"
		size = 59
		refs = "0010 __pPurecall 0016 __imp_DecodePointer 0022 __imp_EncodePointer"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B CF 48 8B D8 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_77_1_0 {
	meta:
		name = "expm1l"
		size = 287
		refs = "0010 _ldtest 0039 __real@bfe62e42fefa39ef 0047 __real@3fd9f323ecbf984c 0059 __real@3f43d31708605728 0067 __real@3ec5ca73dff66ede 006f __real@3ef26c937b07e563 0077 __real@3f1da2e7e515ea71 008b __real@3f51de97c5b063b2 0093 __real@3f83945deb77150f 00a3 __real@3f9c8391e0c43166 00ab __real@3fb5d013b98b14b0 00bb __real@3fa41a22f5c5081f 00c3 __real@3fdb0d4f9f784ed1 00d3 __real@3fed9093fe30efd3 00f0 exp 00f8 __real@3ff0000000000000 010e __real@bff0000000000000"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 0F BF C8 85 C9 0F 84 F5 00 00 00 FF C9 0F 84 D7 00 00 00 FF C9 0F 84 E5 00 00 00 F2 0F 10 64 24 30 66 0F 2F 25 ?? ?? ?? ?? 0F 86 A9 00 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C4 0F 86 97 00 00 00 F2 0F 10 0D ?? ?? ?? ?? 0F 28 DC 0F 28 C4 F2 0F 59 1D ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 5C C8 F2 0F 59 DC F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 5C 0D ?? ?? ?? ?? F2 0F 59 DC F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 DC F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 5C 0D ?? ?? ?? ?? F2 0F 59 DC F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 5E D9 F2 0F 59 DC 0F 28 C3 EB 2E 0F 28 C4 E8 ?? ?? ?? ?? F2 0F 5C 05 ?? ?? ?? ?? EB 1C B8 00 80 00 00 66 85 44 24 36 74 0A F2 0F 10 05 ?? ?? ?? ?? EB 06 F2 0F 10 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_532_0_0 {
	meta:
		name = "expm1"
		size = 287
		refs = "0010 _dtest 0039 __real@bfe62e42fefa39ef 0047 __real@3fd9f323ecbf984c 0059 __real@3f43d31708605728 0067 __real@3ec5ca73dff66ede 006f __real@3ef26c937b07e563 0077 __real@3f1da2e7e515ea71 008b __real@3f51de97c5b063b2 0093 __real@3f83945deb77150f 00a3 __real@3f9c8391e0c43166 00ab __real@3fb5d013b98b14b0 00bb __real@3fa41a22f5c5081f 00c3 __real@3fdb0d4f9f784ed1 00d3 __real@3fed9093fe30efd3 00f0 exp 00f8 __real@3ff0000000000000 010e __real@bff0000000000000"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 0F BF C8 85 C9 0F 84 F5 00 00 00 FF C9 0F 84 D7 00 00 00 FF C9 0F 84 E5 00 00 00 F2 0F 10 64 24 30 66 0F 2F 25 ?? ?? ?? ?? 0F 86 A9 00 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C4 0F 86 97 00 00 00 F2 0F 10 0D ?? ?? ?? ?? 0F 28 DC 0F 28 C4 F2 0F 59 1D ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 5C C8 F2 0F 59 DC F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 5C 0D ?? ?? ?? ?? F2 0F 59 DC F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 DC F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 5C 0D ?? ?? ?? ?? F2 0F 59 DC F2 0F 59 CC F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 5E D9 F2 0F 59 DC 0F 28 C3 EB 2E 0F 28 C4 E8 ?? ?? ?? ?? F2 0F 5C 05 ?? ?? ?? ?? EB 1C B8 00 80 00 00 66 85 44 24 36 74 0A F2 0F 10 05 ?? ?? ?? ?? EB 06 F2 0F 10 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "__sse2_acos2"
		size = 480
		refs = "000b iSignMask 004a dbOneHalf 0053 dbOne 00b0 dbTwo 00d7 dbPio2hi 00df dbPi 0101 dbA10 010d dbA09 0115 dbA08 011d dbA07 0136 dbA06 0142 dbA05 0158 dbA04 0160 dbA03 0170 dbA02 0178 dbA01 0190 dbA00"
	strings:
		$1 = { 48 81 EC A8 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F C2 D0 05 66 0F 29 54 24 20 66 0F 54 C8 66 0F 28 D8 66 0F 55 1D ?? ?? ?? ?? 66 0F 29 5C 24 30 66 0F 29 4C 24 40 66 0F 55 C8 66 0F 28 E1 66 0F C2 25 ?? ?? ?? ?? 05 66 0F 28 2D ?? ?? ?? ?? 66 0F 29 4C 24 50 66 0F 5C E9 66 0F 59 C9 66 0F 59 2D ?? ?? ?? ?? 66 0F 28 D4 66 0F 54 EC 66 0F 55 D1 66 0F 56 D5 66 0F 51 ED 66 0F 28 D9 66 0F 29 54 24 60 66 0F 59 D2 66 0F C2 1D ?? ?? ?? ?? 00 66 0F 29 5C 24 70 66 0F 28 0D ?? ?? ?? ?? 66 0F 56 4C 24 30 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 44 24 40 66 0F 28 DC 66 0F 54 C4 66 0F 55 E1 66 0F 56 C4 66 0F 29 84 24 80 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 54 44 24 20 66 0F 28 E3 66 0F 54 C3 66 0F 55 D9 66 0F 28 CA 66 0F 56 C3 66 0F 59 0D ?? ?? ?? ?? 66 0F 28 DA 66 0F 59 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 29 84 24 90 00 00 00 66 0F 59 CA 66 0F 59 DA 66 0F 58 0D ?? ?? ?? ?? 66 0F 54 EC 66 0F 58 1D ?? ?? ?? ?? 66 0F 55 64 24 50 66 0F 59 CA 66 0F 59 DA 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 CA 66 0F 59 DA 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 CA 66 0F 59 DA 66 0F 28 15 ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 54 54 24 20 66 0F 59 4C 24 60 66 0F 56 EC 66 0F 58 CB 66 0F 59 CD 66 0F 28 44 24 70 66 0F 58 CD 66 0F 59 8C 24 80 00 00 00 66 0F 54 54 24 70 66 0F 58 8C 24 90 00 00 00 66 0F 55 C1 66 0F 56 C2 48 81 C4 A8 00 00 00 C3 66 90 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "__dtold"
		size = 205
	strings:
		$1 = { 48 89 5C 24 08 44 0F B7 5A 06 4C 8B D1 8B 4A 04 45 0F B7 C3 B8 00 80 00 00 41 B9 FF 07 00 00 66 41 C1 E8 04 66 44 23 D8 8B 02 66 45 23 C1 81 E1 FF FF 0F 00 BB 00 00 00 80 41 0F B7 D0 85 D2 74 18 41 3B D1 74 0B BA 00 3C 00 00 66 44 03 C2 EB 24 41 B8 FF 7F 00 00 EB 1C 85 C9 75 0D 85 C0 75 09 41 21 42 04 41 21 02 EB 58 BA 01 3C 00 00 66 44 03 C2 33 DB 44 8B C8 C1 E1 0B C1 E0 0B 41 C1 E9 15 41 89 02 44 0B C9 44 0B CB 45 89 4A 04 45 85 C9 78 2A 41 8B 12 43 8D 04 09 8B CA C1 E9 1F 44 8B C9 44 0B C8 8D 04 12 41 89 02 B8 FF FF 00 00 66 44 03 C0 45 85 C9 79 DA 45 89 4A 04 66 45 0B D8 48 8B 5C 24 08 66 45 89 5A 08 C3 }
	condition:
		$1
}

rule file_79_1_0 {
	meta:
		name = "_fltout2"
		size = 183
		refs = "0014 __security_cookie 0035 __dtold 005b $I10_OUTPUT 007a strcpy_s 0091 __security_check_cookie 00b2 _invoke_watson"
	strings:
		$1 = { 40 55 53 56 57 48 8D 6C 24 C1 48 81 EC 88 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 27 48 8B FA 48 89 4D E7 48 8D 55 E7 48 8D 4D F7 49 8B D9 49 8B F0 E8 ?? ?? ?? ?? 0F B7 45 FF 45 33 C0 F2 0F 10 45 F7 F2 0F 11 45 E7 4C 8D 4D 07 48 8D 4D E7 41 8D 50 11 66 89 45 EF E8 ?? ?? ?? ?? 0F BE 4D 09 89 0F 0F BF 4D 07 4C 8D 45 0B 89 4F 04 48 8B D3 48 8B CE 89 47 08 E8 ?? ?? ?? ?? 85 C0 75 1F 48 89 77 10 48 8B C7 48 8B 4D 27 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 5F 5E 5B 5D C3 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "_dnorm"
		size = 423
		altNames = "_Dnorm"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 0F B7 41 06 41 BE 01 00 00 00 4C 8B C1 0F B7 F0 41 8D 6E 0E B9 00 80 00 00 23 C5 45 33 D2 66 23 F1 45 0F B7 CE 66 41 89 40 06 66 85 C0 75 4E 66 45 39 50 04 75 11 66 45 39 50 02 75 0A 66 45 39 10 0F 84 2B 01 00 00 66 85 C0 75 31 41 0F B7 40 04 41 0F B7 48 02 0F B7 D0 66 41 83 C1 F0 0F B7 C1 41 0F B7 08 66 45 89 10 66 85 D2 74 E8 66 41 89 50 06 66 41 89 40 04 66 41 89 48 02 41 0F B7 58 06 66 83 FB 10 73 6F 45 0F B7 50 04 45 0F B7 58 02 41 0F B7 10 41 0F B7 C2 41 0F B7 CB 66 C1 E8 0F 66 C1 E9 0F 0F B7 FB 66 03 FF 66 41 FF C9 66 0B F8 41 0F B7 C2 44 0F B7 D1 66 03 C0 0F B7 CA 66 03 D2 66 44 0B D0 41 0F B7 C3 66 C1 E9 0F 66 03 C0 44 0F B7 D9 66 41 89 10 66 44 0B D8 0F B7 DF 66 83 FF 10 72 AA 66 41 89 78 06 66 45 89 50 04 66 45 89 58 02 41 0F B7 50 06 BF 20 00 00 00 66 3B FA 77 67 45 0F B7 58 04 45 0F B7 50 02 41 0F B7 18 41 0F B7 CA 0F B7 C3 66 41 D1 EA 66 D1 E8 66 C1 E1 0F 66 45 03 CE 0F B7 D9 0F B7 CA 66 D1 EA 66 0B D8 41 0F B7 C3 66 C1 E1 0F 66 C1 E0 0F 66 44 0B D0 41 0F B7 C3 44 0F B7 D9 66 D1 E8 66 44 0B D8 66 3B FA 76 BA 66 41 89 50 06 66 45 89 58 04 66 45 89 50 02 66 41 89 18 66 41 21 68 06 66 41 09 70 06 48 8B 5C 24 10 48 8B 6C 24 18 48 8B 74 24 20 48 8B 7C 24 28 41 0F B7 C1 41 5E C3 }
	condition:
		$1
}

rule file_80_1_0 {
	meta:
		name = "_fdnorm"
		size = 247
		altNames = "_FDnorm"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 0F B7 41 02 48 8B D1 BE 01 00 00 00 44 0F B7 D8 B9 00 80 00 00 8D 7E 7E 23 C7 66 44 23 D9 33 C9 44 0F B7 D6 66 89 42 02 66 85 C0 75 1C 66 39 0A 0F 84 99 00 00 00 66 85 C0 75 0E 0F B7 02 44 8D 56 F0 66 89 0A 66 89 42 02 44 0F B7 4A 02 BB 80 00 00 00 66 44 3B CB 73 30 0F B7 0A 41 0F B7 C1 66 41 FF CA 44 0F B7 C1 66 03 C0 66 03 C9 66 41 C1 E8 0F 66 89 0A 66 44 0B C0 45 0F B7 C8 66 44 3B C3 72 D5 66 44 89 42 02 44 0F B7 42 02 BB 00 01 00 00 66 41 3B D8 77 32 44 0F B7 0A 41 0F B7 C1 41 0F B7 C8 66 41 D1 E8 66 C1 E1 0F 66 D1 E8 66 44 03 D6 44 0F B7 C9 66 44 0B C8 66 41 3B D8 76 DB 66 44 89 42 02 66 44 89 0A 66 21 7A 02 66 44 09 5A 02 48 8B 5C 24 08 48 8B 74 24 10 48 8B 7C 24 18 41 0F B7 C2 C3 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "_getw"
		size = 179
		refs = "0027 _errno 0032 _invalid_parameter_noinfo 0041 _lock_file 006c _filbuf 0083 feof 008f ferror 009f _unlock_file"
	strings:
		$1 = { 48 89 5C 24 18 56 57 41 56 48 83 EC 30 48 8B D9 BE 04 00 00 00 4C 8D 74 24 50 33 C0 48 85 C9 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 6A 48 89 4C 24 58 E8 ?? ?? ?? ?? 90 83 CF FF 8B C6 FF CE 89 74 24 20 85 C0 74 2A 01 7B 08 78 0E 48 8B 03 0F B6 08 48 FF C0 48 89 03 EB 0A 48 8B CB E8 ?? ?? ?? ?? 8B C8 41 88 0E 49 FF C6 4C 89 74 24 28 EB CA 48 8B CB E8 ?? ?? ?? ?? 85 C0 75 10 48 8B CB E8 ?? ?? ?? ?? 85 C0 75 04 8B 7C 24 50 48 8B CB E8 ?? ?? ?? ?? 8B C7 48 8B 5C 24 60 48 83 C4 30 41 5E 5F 5E C3 }
	condition:
		$1
}

rule file_81_1_0 {
	meta:
		name = "_getw$fin$0"
		size = 26
		refs = "000e _unlock_file"
		altNames = "_putw$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 58 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "cargf"
		size = 50
		refs = "000f crealf 001c cimagf 0024 atan2f"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 0F 29 74 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 40 0F 28 F0 E8 ?? ?? ?? ?? 0F 28 CE E8 ?? ?? ?? ?? 0F 28 74 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_220_0_0 {
	meta:
		name = "cabsf"
		size = 50
		refs = "000f cimagf 001c crealf 0024 _hypotf"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 0F 29 74 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 40 0F 28 F0 E8 ?? ?? ?? ?? 0F 28 CE E8 ?? ?? ?? ?? 0F 28 74 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "llrintf"
		size = 121
		refs = "0015 _fdtest 002c nearbyintf 0042 _fperrraise 0049 __real@df000000 0053 __real@5f000000"
	strings:
		$1 = { F3 0F 11 44 24 08 48 83 EC 38 48 8D 4C 24 40 0F 29 74 24 20 E8 ?? ?? ?? ?? 98 85 C0 74 4F FF C8 83 F8 01 76 3E F3 0F 10 44 24 40 E8 ?? ?? ?? ?? 0F 28 F0 0F 2E 74 24 40 7A 02 74 0A B9 20 00 00 00 E8 ?? ?? ?? ?? 0F 2F 35 ?? ?? ?? ?? 72 14 F3 0F 10 05 ?? ?? ?? ?? 0F 2F C6 72 07 F3 48 0F 2C C6 EB 0C B9 01 00 00 00 E8 ?? ?? ?? ?? 33 C0 0F 28 74 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_85_3_0 {
	meta:
		name = "_mbscat_s_l"
		size = 461
		refs = "0039 _errno 0045 _invalid_parameter_noinfo 0073 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 008c strcat_s 00d5 _ismbblead_l"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 40 4D 8B F0 48 8B F2 48 8B D9 48 85 C9 74 0D 48 85 D2 74 08 4D 85 C0 75 35 44 88 01 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 48 8B 6C 24 68 48 8B 74 24 70 48 8B 7C 24 78 8B C3 48 8B 5C 24 60 48 83 C4 40 41 5F 41 5E 41 5C C3 48 8D 4C 24 20 49 8B D1 E8 ?? ?? ?? ?? 48 8B 44 24 28 83 78 08 00 75 15 4D 8B C6 48 8B D6 48 8B CB E8 ?? ?? ?? ?? 8B D8 E9 1A 01 00 00 45 33 E4 48 8B FB 44 38 27 74 08 48 FF C7 48 FF CE 75 F3 48 85 F6 75 10 44 88 23 E8 ?? ?? ?? ?? 8D 5E 16 E9 A0 00 00 00 4C 8D 7F FF 49 8B EF 4C 3B FB 72 1A 0F B6 4D 00 48 8D 54 24 20 E8 ?? ?? ?? ?? 85 C0 74 08 48 FF CD 48 3B EB 73 E6 41 8B C7 2B C5 BD 01 00 00 00 40 84 C5 74 0D 44 8B E5 49 8B FF 41 C6 07 00 48 03 F5 41 8A 06 4C 03 F5 88 07 48 03 FD 84 C0 74 05 48 2B F5 75 EC 48 85 F6 75 4E 41 38 36 75 33 48 8D 77 FF 48 8B FE 48 3B F3 72 19 0F B6 0F 48 8D 54 24 20 E8 ?? ?? ?? ?? 85 C0 74 08 48 2B FD 48 3B FB 73 E7 8B C6 2B C7 40 84 C5 74 05 C6 06 00 EB 4F C6 03 00 E8 ?? ?? ?? ?? BB 22 00 00 00 89 18 E8 ?? ?? ?? ?? EB 49 48 8D 77 FE 48 8B FE 48 3B F3 72 19 0F B6 0F 48 8D 54 24 20 E8 ?? ?? ?? ?? 85 C0 74 08 48 2B FD 48 3B FB 73 E7 8B C6 2B C7 40 84 C5 74 06 C6 06 00 44 8B E5 45 85 E4 74 0E E8 ?? ?? ?? ?? BB 2A 00 00 00 89 18 EB 02 33 DB 80 7C 24 38 00 0F 84 8D FE FF FF 48 8B 4C 24 30 83 A1 C8 00 00 00 FD E9 7C FE FF FF }
	condition:
		$1
}

rule file_86_1_0 {
	meta:
		name = "_invoke_watson_if_oneof"
		size = 61
		refs = "0038 _invoke_watson"
	strings:
		$1 = { 48 83 EC 38 4D 8B D1 85 C9 74 09 3B CA 74 0C 41 3B C8 74 07 8B C1 48 83 C4 38 C3 48 8B 44 24 78 44 8B 4C 24 70 4C 8B 44 24 68 48 8B 54 24 60 49 8B CA 48 89 44 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_86_2_0 {
	meta:
		name = "_wexecvpe"
		size = 628
		refs = "0032 _errno 003d _invalid_parameter_noinfo 0071 _wexecve 008c wcschr 00c3 ??_C@_19IJOJOJIB@?$AAP?$AAA?$AAT?$AAH?$AA?$AA@ 00cf _wdupenv_s 00fb _calloc_crt 0161 ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 016e wcscat_s 017e wcslen 0201 free 0245 _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 68 18 48 89 70 20 57 41 54 41 55 41 56 41 57 48 83 EC 30 45 33 ED 4D 8B E0 48 8B EA 48 8B F1 4C 89 68 08 48 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 CE 01 00 00 66 44 39 29 74 E5 48 85 D2 74 E0 48 8B 02 48 85 C0 74 D8 66 44 39 28 74 D2 E8 ?? ?? ?? ?? 4D 8B C4 48 8B D5 48 8B CE 44 89 28 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 38 02 0F 85 82 01 00 00 BA 5C 00 00 00 48 8B CE E8 ?? ?? ?? ?? 48 85 C0 0F 85 6C 01 00 00 8D 58 2F 48 8B CE 8B D3 E8 ?? ?? ?? ?? 48 85 C0 0F 85 56 01 00 00 66 44 39 2E 74 0B 66 83 7E 02 3A 0F 84 45 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 4C 24 60 33 D2 E8 ?? ?? ?? ?? 85 C0 74 0E 83 F8 16 0F 85 25 01 00 00 E9 50 01 00 00 4C 39 6C 24 60 0F 84 24 01 00 00 BA 02 00 00 00 B9 04 01 00 00 E8 ?? ?? ?? ?? 48 8B F8 4C 8B F0 48 85 C0 0F 84 F7 00 00 00 4C 8B 7C 24 60 EB 1E 66 83 F9 3B 74 21 48 8D 87 04 02 00 00 4C 3B F0 73 15 66 41 89 0E 49 83 C6 02 49 83 C7 02 41 0F B7 0F 66 85 C9 75 D9 66 45 89 2E 49 8D 46 FE 4C 3B F7 77 03 49 8B C6 B9 5C 00 00 00 4C 8B F7 66 39 08 74 21 66 39 18 74 1C 4C 8D 05 ?? ?? ?? ?? BA 04 01 00 00 48 8B CF E8 ?? ?? ?? ?? 85 C0 0F 85 D0 00 00 00 48 8B CF E8 ?? ?? ?? ?? 48 8B CE 48 8B D8 E8 ?? ?? ?? ?? 48 03 D8 B8 04 01 00 00 48 3B D8 73 63 4C 8B C6 8B D0 48 8B CF E8 ?? ?? ?? ?? 85 C0 0F 85 B0 00 00 00 E8 ?? ?? ?? ?? 4D 8B C4 48 8B D5 48 8B CF 44 89 28 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 38 02 74 1E B9 5C 00 00 00 8D 41 D3 66 39 0F 74 05 66 39 07 75 1C 66 39 4F 02 74 06 66 39 47 02 75 10 66 45 39 2F 74 0A BB 2F 00 00 00 E9 32 FF FF FF 48 8B CF E8 ?? ?? ?? ?? 48 8B 4C 24 60 48 85 C9 74 05 E8 ?? ?? ?? ?? 48 8B 5C 24 68 48 8B 6C 24 70 48 8B 74 24 78 48 83 C8 FF 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F C3 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 6C 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 6C 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 6C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_87_8_0 {
	meta:
		name = "??0ExecutionResource@details@Concurrency@@QEAA@PEAVSchedulerProxy@12@PEAUSchedulerNode@12@I@Z"
		size = 99
		refs = "0006 ??_7ExecutionResource@details@Concurrency@@6B@"
	strings:
		$1 = { 4C 8B D1 48 8D 05 ?? ?? ?? ?? 48 89 01 33 C9 33 C0 41 89 4A 08 49 89 42 18 66 41 89 4A 18 49 89 4A 10 49 89 52 20 49 89 4A 28 49 89 4A 30 49 89 4A 38 41 8B 40 14 41 89 42 40 41 89 4A 4C 45 89 4A 44 41 8B C1 48 8D 0C C0 49 8B 40 38 0F B6 54 C8 08 41 8B 40 10 C1 E0 08 03 D0 49 8B C2 41 89 52 48 C3 }
	condition:
		$1
}

rule file_87_9_0 {
	meta:
		name = "??0ExecutionResource@details@Concurrency@@QEAA@PEAVSchedulerProxy@12@PEAV012@@Z"
		size = 117
		refs = "0014 ??_7ExecutionResource@details@Concurrency@@6B@"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 F6 48 8D 05 ?? ?? ?? ?? 49 8B D8 48 89 01 89 71 08 33 C0 48 89 41 18 66 89 71 18 48 89 71 10 48 89 51 20 48 89 59 28 48 89 71 30 48 89 71 38 49 8B 00 48 8B F9 49 8B C8 FF 10 48 8B CB 89 47 40 8B 43 44 89 77 4C 89 47 44 48 8B 03 FF 50 08 48 8B 5C 24 30 48 8B 74 24 38 89 47 48 48 8B C7 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_87_10_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QEAA@G_K@Z"
		size = 17
	strings:
		$1 = { 33 C0 48 89 41 08 66 89 51 08 4C 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_87_11_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QEAA@XZ"
		size = 17
	strings:
		$1 = { 33 C0 48 89 41 08 66 89 41 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_87_27_0 {
	meta:
		name = "??4HardwareAffinity@details@Concurrency@@QEAAAEAU012@AEBU012@@Z"
		size = 18
	strings:
		$1 = { 0F B7 42 08 66 89 41 08 48 8B 02 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_87_40_0 {
	meta:
		name = "?CurrentSubscriptionLevel@ExecutionResource@details@Concurrency@@UEBAIXZ"
		size = 20
		refs = "0010 ?CurrentSubscriptionLevel@ResourceManager@details@Concurrency@@QEAAIII@Z"
	strings:
		$1 = { 48 8B 41 20 44 8B 41 44 8B 51 40 48 8B 48 18 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_41_0 {
	meta:
		name = "?DecrementUseCounts@ExecutionResource@details@Concurrency@@QEAAXXZ"
		size = 141
		refs = "001c ?ResetCurrent@ExecutionResource@details@Concurrency@@QEAAXXZ 003c ?DecrementFixedCoreCount@SchedulerProxy@details@Concurrency@@QEAAXII_N@Z 0047 __imp_GetCurrentThread 0053 ?ApplyTo@HardwareAffinity@details@Concurrency@@QEAAXPEAX@Z 005f ?DecrementCoreSubscription@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z 006b ?DestroyExecutionResource@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z 0072 ?DecrementUseCounts@ExecutionResource@details@Concurrency@@QEAAXXZ 007e ?RemoveThreadSubscription@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 FF 49 4C 48 8B D9 75 70 48 83 79 30 00 40 0F 95 C7 E8 ?? ?? ?? ?? 48 8B 4B 28 48 85 C9 75 48 44 8B 43 44 8B 53 40 48 8B 4B 20 40 84 FF 41 0F 94 C1 E8 ?? ?? ?? ?? 40 84 FF 75 3D FF 15 ?? ?? ?? ?? 48 8D 4B 10 48 8B D0 E8 ?? ?? ?? ?? 48 8B 4B 20 48 8B D3 E8 ?? ?? ?? ?? 48 8B 4B 20 48 8B D3 E8 ?? ?? ?? ?? EB 11 E8 ?? ?? ?? ?? 48 8B 4B 20 48 8B D3 E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_87_46_0 {
	meta:
		name = "?GetNodeAffinity@SchedulerProxy@details@Concurrency@@QEAA?AUHardwareAffinity@23@I@Z"
		size = 38
	strings:
		$1 = { 48 8B 41 20 45 8B C8 49 C1 E1 06 4D 8B 04 01 41 0F B7 4C 01 10 33 C0 48 89 42 08 66 89 4A 08 4C 89 02 48 8B C2 C3 }
	condition:
		$1
}

rule file_87_49_0 {
	meta:
		name = "?IncrementUseCounts@ExecutionResource@details@Concurrency@@QEAAXXZ"
		size = 258
		refs = "000d __security_cookie 0052 ?IncrementFixedCoreCount@SchedulerProxy@details@Concurrency@@QEAAXII_N@Z 0060 __imp_GetCurrentThread 0070 ??0HardwareAffinity@details@Concurrency@@QEAA@PEAX@Z 00bc ?ApplyTo@HardwareAffinity@details@Concurrency@@QEAAXPEAX@Z 00c8 ?IncrementCoreSubscription@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z 00d4 ?AddExecutionResource@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z 00de ?AddThreadSubscription@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z 00e6 ?SetAsCurrent@ExecutionResource@details@Concurrency@@QEAAXXZ 00f3 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 50 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 40 48 8B F9 8B 49 4C 8D 41 01 89 47 4C 85 C9 0F 85 BD 00 00 00 48 83 7F 30 00 48 8B 4F 20 0F 95 C3 48 83 7F 28 00 0F 85 96 00 00 00 44 8B 47 44 8B 57 40 84 DB 41 0F 94 C1 E8 ?? ?? ?? ?? 84 DB 0F 85 84 00 00 00 FF 15 ?? ?? ?? ?? 48 8D 4C 24 30 48 8B D0 48 8B D8 E8 ?? ?? ?? ?? 0F B7 48 08 66 89 4F 18 48 8B 08 48 89 4F 10 48 8B 4F 20 44 8B 47 40 48 8B 51 20 49 C1 E0 06 49 8B 0C 10 41 0F B7 44 10 10 33 D2 48 89 54 24 20 48 89 54 24 28 48 89 4C 24 20 48 8D 4C 24 20 48 8B D3 66 89 44 24 28 E8 ?? ?? ?? ?? 48 8B 4F 20 48 8B D7 E8 ?? ?? ?? ?? 48 8B 4F 20 48 8B D7 E8 ?? ?? ?? ?? EB 08 48 8B D7 E8 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 68 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_87_50_0 {
	meta:
		name = "?Remove@ExecutionResource@details@Concurrency@@UEAAXPEAUIScheduler@3@@Z"
		size = 180
		refs = "001a ?GetCurrentThreadExecutionResource@SchedulerProxy@details@Concurrency@@QEAAPEAVExecutionResource@23@XZ 003f ?RemoveExecutionResource@ResourceManager@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z 0046 ??_C@_0L@HKFDMHB@pScheduler?$AA@ 005a ??0exception@std@@QEAA@AEBQEBD@Z 0061 ??_7invalid_argument@std@@6B@ 0068 _TI3?AVinvalid_argument@std@@ 0077 _CxxThrowException 0082 ??0invalid_operation@Concurrency@@QEAA@XZ 0089 _TI2?AVinvalid_operation@Concurrency@@"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B FA 48 8B D9 48 85 D2 74 2E 48 8B 49 20 E8 ?? ?? ?? ?? 48 3B C3 75 59 48 8B 4B 20 48 39 79 10 75 6B 48 8B 49 18 48 8B D3 48 8B 5C 24 50 48 83 C4 40 5F E9 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8D 54 24 58 48 8D 4C 24 20 48 89 44 24 58 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 48 89 44 24 20 E8 ?? ?? ?? ?? CC 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_87_51_0 {
	meta:
		name = "?ResetCurrent@ExecutionResource@details@Concurrency@@QEAAXXZ"
		size = 43
		refs = "001c ?__TlsSetValue@platform@details@Concurrency@@YAXKPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 41 20 48 8B D9 48 8B 48 18 48 8B 53 38 8B 89 B0 00 00 00 E8 ?? ?? ?? ?? 48 83 63 38 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_87_53_0 {
	meta:
		name = "?SetAsCurrent@ExecutionResource@details@Concurrency@@QEAAXXZ"
		size = 58
		refs = "001e ?__TlsGetValue@platform@details@Concurrency@@YAPEAXK@Z 0036 ?__TlsSetValue@platform@details@Concurrency@@YAXKPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 41 20 48 8B F9 48 8B 50 18 8B 9A B0 00 00 00 8B CB E8 ?? ?? ?? ?? 48 8B D7 8B CB 48 89 47 38 48 8B 5C 24 30 48 83 C4 20 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "_heapused"
		size = 22
		refs = "0005 _errno"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? C7 00 28 00 00 00 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_90_3_0 {
	meta:
		name = "_mbsnbcat_s_l"
		size = 687
		refs = "0061 _errno 006d _invalid_parameter_noinfo 009f ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 00bb strncat_s 010a _ismbblead_l"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 40 45 33 ED 4D 8B F1 4D 8B F8 48 8B EA 48 8B F9 45 8B E5 44 89 AC 24 88 00 00 00 4D 85 C9 75 0E 48 85 C9 75 0E 48 85 D2 75 1B 33 C0 EB 2A 48 85 C9 74 12 48 85 D2 74 0D 4D 85 C9 74 39 4D 85 C0 75 34 44 88 29 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 4C 8D 5C 24 40 49 8B 5B 30 49 8B 6B 38 49 8B 73 40 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 48 8B 94 24 90 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 44 39 68 08 75 18 4D 8B CE 4D 8B C7 48 8B D5 48 8B CF E8 ?? ?? ?? ?? 8B D8 E9 CD 01 00 00 48 8B DF 48 8B F5 44 38 2B 74 08 48 FF C3 48 FF CE 75 F3 48 85 F6 75 10 44 88 2F E8 ?? ?? ?? ?? 8D 5E 16 E9 4B 01 00 00 48 3B F5 73 4E 4C 8D 6B FF 4D 8B E5 4C 3B EF 72 1B 41 0F B6 0C 24 48 8D 54 24 20 E8 ?? ?? ?? ?? 85 C0 74 08 49 FF CC 4C 3B E7 73 E5 41 8B C5 41 2B C4 A8 01 74 12 49 8B DD 45 33 ED 48 FF C6 45 8D 65 01 44 88 2B EB 0B 44 8B A4 24 88 00 00 00 45 33 ED 49 83 FE FF 75 16 41 8A 07 49 FF C7 88 03 48 FF C3 84 C0 74 30 48 FF CE 75 EC EB 29 4D 85 F6 74 1E 41 8A 07 49 FF C7 88 03 48 FF C3 84 C0 74 0A 48 FF CE 74 05 49 FF CE 75 E7 4D 85 F6 75 06 44 88 2B 48 FF C3 48 85 F6 0F 85 B3 00 00 00 45 38 2F 74 06 49 83 FE 01 75 35 48 8D 73 FF 48 8B DE 48 3B F7 72 19 0F B6 0B 48 8D 54 24 20 E8 ?? ?? ?? ?? 85 C0 74 08 48 FF CB 48 3B DF 73 E7 8B C6 2B C3 A8 01 74 08 44 88 2E E9 B3 00 00 00 49 83 FE FF 75 57 45 85 E4 74 0B E8 ?? ?? ?? ?? 41 8D 5E 2B 89 18 48 83 FD 01 76 35 48 8D 75 FE 48 03 F7 48 8B DE 48 3B F7 72 19 0F B6 0B 48 8D 54 24 20 E8 ?? ?? ?? ?? 85 C0 74 08 48 FF CB 48 3B DF 73 E7 8B C6 2B C3 A8 01 74 05 44 88 2E EB 05 44 88 6C 2F FF BB 50 00 00 00 EB 67 44 88 2F E8 ?? ?? ?? ?? BB 22 00 00 00 89 18 E8 ?? ?? ?? ?? EB 51 48 3B F5 73 36 48 8D 73 FE 48 8B DE 48 3B F7 72 19 0F B6 0B 48 8D 54 24 20 E8 ?? ?? ?? ?? 85 C0 74 08 48 FF CB 48 3B DF 73 E7 8B C6 2B C3 A8 01 74 09 44 88 2E 41 BC 01 00 00 00 45 85 E4 74 0E E8 ?? ?? ?? ?? BB 2A 00 00 00 89 18 EB 03 41 8B DD 44 38 6C 24 38 0F 84 D3 FD FF FF 48 8B 4C 24 30 83 A1 C8 00 00 00 FD E9 C2 FD FF FF }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "__common_slog_cout_rare"
		size = 720
		refs = "003d _imlsLnHATab 0063 _2il0floatpacket_72 026a _2il0floatpacket_73"
	strings:
		$1 = { 48 83 EC 38 33 C0 44 0F B7 41 02 41 81 E0 80 7F 00 00 41 81 F8 80 7F 00 00 0F 84 60 02 00 00 F3 0F 5A 19 F2 0F 11 5C 24 30 45 33 C0 0F B7 4C 24 36 F7 C1 F0 7F 00 00 75 14 F2 0F 59 1D ?? ?? ?? ?? 41 B8 C4 FF FF FF F2 0F 11 5C 24 30 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F D8 0F 86 DD 01 00 00 F2 0F 10 05 ?? ?? ?? ?? 0F 28 D3 F2 0F 5C D0 F2 0F 11 54 24 28 80 64 24 2F 7F F2 0F 10 4C 24 28 66 0F 2F 0D ?? ?? ?? ?? 0F 86 43 01 00 00 F2 0F 11 5C 24 28 44 0F B7 4C 24 2E 41 81 E1 0F 80 FF FF 41 81 C9 F0 3F FF FF 66 44 89 4C 24 2E F2 0F 10 6C 24 28 0F 28 DD 0F B7 4C 24 36 81 E1 F0 7F 00 00 F2 0F 58 1D ?? ?? ?? ?? C1 E9 04 F2 0F 11 5C 24 20 0F 28 DD 44 8B 54 24 20 41 83 E2 7F F2 0F 58 1D ?? ?? ?? ?? F2 0F 11 5C 24 20 45 8D 84 08 01 FC FF FF F2 41 0F 2A C8 F2 0F 10 5C 24 20 47 8D 1C 52 48 8D 0D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 4C 8B C9 F2 0F 10 25 ?? ?? ?? ?? 4C 8B C1 F2 0F 59 D1 F2 0F 5C 1D ?? ?? ?? ?? F2 0F 59 CC F2 0F 5C EB F2 43 0F 58 54 D8 08 F2 43 0F 58 4C D9 10 F2 42 0F 10 24 D9 F2 0F 59 DC F2 0F 59 E5 F2 0F 5C D8 0F 28 C3 F2 0F 58 DA F2 0F 58 C4 F2 0F 58 E1 F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 59 C0 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 E5 F2 0F 58 DC F2 0F 5A DB F3 0F 11 1A 48 83 C4 38 C3 F2 0F 10 0D ?? ?? ?? ?? 0F 28 C2 F2 0F 59 CA F2 0F 59 C2 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 D1 F2 0F 5A D2 F3 0F 11 12 48 83 C4 38 C3 66 0F 2E D8 7A 02 74 16 F2 0F 5E C0 F2 0F 5A C0 F3 0F 11 02 B8 01 00 00 00 48 83 C4 38 C3 F2 0F 10 0D ?? ?? ?? ?? B8 02 00 00 00 0F 57 0D ?? ?? ?? ?? F2 0F 5E C8 F2 0F 5A C9 F3 0F 11 0A 48 83 C4 38 C3 44 8A 41 03 41 80 E0 80 41 80 F8 80 74 11 F3 0F 10 01 F3 0F 59 C0 F3 0F 11 02 48 83 C4 38 C3 F7 01 FF FF 7F 00 75 E7 F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 5E C0 F2 0F 5A C0 F3 0F 11 02 48 83 C4 38 C3 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "__avx_atanf8"
		size = 208
		refs = "000e __common_satan_data"
	strings:
		$1 = { 48 83 EC 48 C5 7C 11 7C 24 20 C5 FC 10 2D ?? ?? ?? ?? C5 FC 10 15 ?? ?? ?? ?? C5 7C 54 3D ?? ?? ?? ?? C5 FC 54 CD C5 84 C2 C2 12 C4 C1 6C 5F DF C4 C1 6C 5D D7 C5 EC 5E D3 C5 FC 55 25 ?? ?? ?? ?? C5 FC 55 DD C5 DC 57 E1 C5 E4 57 C9 C5 F4 57 DA C5 E4 59 D3 C5 EC 59 CA C5 F4 59 2D ?? ?? ?? ?? C5 74 59 3D ?? ?? ?? ?? C5 D4 58 05 ?? ?? ?? ?? C5 84 58 2D ?? ?? ?? ?? C5 7C 59 F9 C5 D4 59 E9 C5 04 58 3D ?? ?? ?? ?? C5 D4 58 05 ?? ?? ?? ?? C5 84 59 E9 C5 FC 59 C9 C5 D4 58 2D ?? ?? ?? ?? C5 F4 58 0D ?? ?? ?? ?? C5 D4 59 EA C5 D4 58 C1 C5 FC 59 D2 C5 6C 58 3D ?? ?? ?? ?? C5 84 59 DB C5 7C 10 7C 24 20 C5 E4 58 C4 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "_execlpe"
		size = 214
		refs = "001b __security_cookie 0033 _errno 003e _invalid_parameter_noinfo 0075 _capture_argv 009b _execvpe 00b5 free 00c8 __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 53 57 48 81 EC 48 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 02 00 00 48 8B D9 48 85 C9 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 74 80 39 00 74 E5 48 85 D2 74 E0 80 3A 00 74 DB 48 8D 84 24 70 02 00 00 4C 8D 44 24 30 48 8D 4C 24 20 41 B9 40 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 4C 8B 44 24 20 48 8B CB 49 83 C0 08 48 8B D0 48 8B F8 4C 89 44 24 20 4D 8B 40 F8 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 8B D8 48 85 FF 74 12 48 8D 44 24 30 48 3B F8 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 8B 8C 24 30 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 48 02 00 00 5F 5B C3 }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "_execle"
		size = 214
		refs = "001b __security_cookie 0033 _errno 003e _invalid_parameter_noinfo 0075 _capture_argv 009b _execve 00b5 free 00c8 __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 53 57 48 81 EC 48 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 02 00 00 48 8B D9 48 85 C9 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 74 80 39 00 74 E5 48 85 D2 74 E0 80 3A 00 74 DB 48 8D 84 24 70 02 00 00 4C 8D 44 24 30 48 8D 4C 24 20 41 B9 40 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 4C 8B 44 24 20 48 8B CB 49 83 C0 08 48 8B D0 48 8B F8 4C 89 44 24 20 4D 8B 40 F8 48 83 64 24 20 00 E8 ?? ?? ?? ?? 48 8B D8 48 85 FF 74 12 48 8D 44 24 30 48 3B F8 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 8B 8C 24 30 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 48 02 00 00 5F 5B C3 }
	condition:
		$1
}

rule file_96_8_0 {
	meta:
		name = "??0ThreadVirtualProcessor@details@Concurrency@@QEAA@PEAVSchedulingNode@12@PEAUIVirtualProcessorRoot@2@@Z"
		size = 87
		refs = "0026 ??0VirtualProcessor@details@Concurrency@@QEAA@XZ 002e ??_7ThreadVirtualProcessor@details@Concurrency@@6B@ 003f ?Initialize@VirtualProcessor@details@Concurrency@@MEAAXPEAVSchedulingNode@23@PEAUIVirtualProcessorRoot@3@@Z"
	strings:
		$1 = { 48 8B C4 48 89 48 08 57 48 83 EC 30 48 C7 40 E8 FE FF FF FF 48 89 58 10 48 89 70 18 49 8B D8 48 8B FA 48 8B F1 E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 89 06 4C 8B C3 48 8B D7 48 8B CE E8 ?? ?? ?? ?? 90 48 8B C6 48 8B 5C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_97_1_0 {
	meta:
		name = "wmemcpy_s"
		size = 122
		refs = "001b _errno 0027 _invalid_parameter_noinfo 0041 memcpy"
	strings:
		$1 = { 40 57 48 83 EC 20 4D 8B D0 45 33 C0 4D 85 C9 75 04 33 C0 EB 5F 48 85 C9 75 15 E8 ?? ?? ?? ?? BF 16 00 00 00 89 38 E8 ?? ?? ?? ?? 8B C7 EB 45 4D 85 D2 74 13 49 3B D1 72 0E 4F 8D 04 09 49 8B D2 E8 ?? ?? ?? ?? EB CA 48 85 D2 74 0D 48 8B F9 41 0F B7 C0 48 8B CA 66 F3 AB 4D 85 D2 74 BC 49 3B D1 73 0C E8 ?? ?? ?? ?? BF 22 00 00 00 EB B5 B8 16 00 00 00 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_97_2_0 {
	meta:
		name = "wmemset"
		size = 34
	strings:
		$1 = { 48 89 7C 24 08 4C 8B C9 4D 85 C0 74 0C 48 8B F9 0F B7 C2 49 8B C8 66 F3 AB 48 8B 7C 24 08 49 8B C1 C3 }
	condition:
		$1
}

rule file_99_0_0 {
	meta:
		name = "__get_abstract_control"
		size = 108
	strings:
		$1 = { 33 D2 F7 C1 80 7E 00 00 74 5F F6 C1 80 8D 42 10 41 B9 00 02 00 00 0F 45 D0 41 85 C9 74 03 83 CA 08 0F BA E1 0A 73 03 83 CA 04 0F BA E1 0B 73 03 83 CA 02 0F BA E1 0C 73 03 83 CA 01 41 B8 00 60 00 00 8B C1 41 23 C0 41 3B C0 75 08 81 CA 00 03 00 00 EB 15 0F BA E1 0E 73 06 0F BA EA 08 EB 09 0F BA E1 0D 73 03 41 0B D1 8B C2 C3 }
	condition:
		$1
}

rule file_99_1_0 {
	meta:
		name = "__get_abstract_status"
		size = 48
	strings:
		$1 = { 33 C0 F6 C1 3D 74 28 F6 C1 01 8D 50 10 0F 45 C2 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 84 CA 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 C3 }
	condition:
		$1
}

rule file_99_2_0 {
	meta:
		name = "__get_machine_control"
		size = 110
	strings:
		$1 = { 33 D2 F7 C1 1F 03 00 00 74 61 F6 C1 10 B8 80 00 00 00 41 B9 00 02 00 00 0F 45 D0 F6 C1 08 74 03 41 0B D1 F6 C1 04 74 04 0F BA EA 0A F6 C1 02 74 04 0F BA EA 0B F6 C1 01 74 04 0F BA EA 0C 41 B8 00 03 00 00 8B C1 41 23 C0 41 3B C0 75 08 81 CA 00 60 00 00 EB 15 41 85 C9 74 06 0F BA EA 0D EB 0A 0F BA E1 08 73 04 0F BA EA 0E 8B C2 C3 }
	condition:
		$1
}

rule file_99_3_0 {
	meta:
		name = "__get_machine_status"
		size = 48
	strings:
		$1 = { 33 C0 F6 C1 1F 74 28 F6 C1 10 8D 50 01 0F 45 C2 F6 C1 08 74 03 83 C8 04 F6 C1 04 74 03 83 C8 08 F6 C1 02 74 03 83 C8 10 84 CA 74 03 83 C8 20 C3 }
	condition:
		$1
}

rule file_99_4_0 {
	meta:
		name = "_getfpcontrolword"
		size = 23
		refs = "0009 _controlfp"
	strings:
		$1 = { 48 83 EC 28 33 D2 33 C9 E8 ?? ?? ?? ?? 25 1F 03 00 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_99_5_0 {
	meta:
		name = "_getfpstatusword"
		size = 17
		refs = "0005 _statusfp"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 83 E0 1F 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_99_7_0 {
	meta:
		name = "_setfpstatusword"
		size = 48
		refs = "000d _get_fpsr 0016 __get_machine_status 002c _set_fpsr"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B D9 E8 ?? ?? ?? ?? 8B CB 8B F8 E8 ?? ?? ?? ?? 83 E7 C2 0B C7 8B C8 48 8B 5C 24 30 48 83 C4 20 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "_wsplitpath"
		size = 136
		refs = "0074 _wsplitpath_helper"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 50 48 8B 9C 24 80 00 00 00 49 8B F8 48 8B F2 41 B8 00 01 00 00 48 8B C3 48 F7 D8 49 8B C1 4D 1B DB 4D 23 D8 48 F7 D8 48 8B C7 4D 1B D2 4C 89 5C 24 40 48 89 5C 24 38 4D 23 D0 48 F7 D8 48 8B C6 48 1B D2 4C 89 54 24 30 4C 89 4C 24 28 49 23 D0 48 F7 D8 4C 8B CF 4D 1B C0 48 89 54 24 20 48 8B D6 41 83 E0 03 E8 ?? ?? ?? ?? 48 8B 5C 24 60 48 8B 74 24 68 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_953_0_0 {
	meta:
		name = "_splitpath"
		size = 136
		refs = "0074 _splitpath_helper"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 50 48 8B 9C 24 80 00 00 00 49 8B F8 48 8B F2 41 B8 00 01 00 00 48 8B C3 48 F7 D8 49 8B C1 4D 1B DB 4D 23 D8 48 F7 D8 48 8B C7 4D 1B D2 4C 89 5C 24 40 48 89 5C 24 38 4D 23 D0 48 F7 D8 48 8B C6 48 1B D2 4C 89 54 24 30 4C 89 4C 24 28 49 23 D0 48 F7 D8 4C 8B CF 4D 1B C0 48 89 54 24 20 48 8B D6 41 83 E0 03 E8 ?? ?? ?? ?? 48 8B 5C 24 60 48 8B 74 24 68 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_100_1_0 {
	meta:
		name = "_wsplitpath_helper"
		size = 659
		refs = "00e8 wcsncpy_s 025a _errno 026b _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 10 4C 89 44 24 18 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 20 4C 8B B4 24 98 00 00 00 4C 8B BC 24 88 00 00 00 48 8B F9 33 C9 4D 8B E9 4C 8B E2 8B F1 89 4C 24 60 4D 8B C8 48 85 FF 74 0A 48 85 D2 75 0F 4D 85 C0 74 0F BE 01 00 00 00 E9 BA 01 00 00 4D 85 C0 74 F1 4D 85 ED 75 0C 48 39 8C 24 80 00 00 00 75 E2 EB 0A 48 39 8C 24 80 00 00 00 74 D6 4D 85 FF 75 0C 48 39 8C 24 90 00 00 00 75 C7 EB 0A 48 39 8C 24 90 00 00 00 74 BB 4D 85 F6 75 0C 48 39 8C 24 A0 00 00 00 75 AC EB 0A 48 39 8C 24 A0 00 00 00 74 A0 B8 01 00 00 00 48 8B DF 66 39 0B 74 09 48 83 C3 02 48 FF C8 75 F2 66 83 3B 3A 75 2C 48 85 D2 74 21 49 83 F8 03 0F 82 39 01 00 00 41 B9 02 00 00 00 4C 8B C7 48 83 CA FF 49 8B CC E8 ?? ?? ?? ?? 33 C9 48 8D 7B 02 EB 08 48 85 D2 74 03 66 89 0A 0F B7 07 48 8B E9 48 8B F1 48 8B DF 66 85 C0 74 5E 66 83 F8 2F 74 11 66 83 F8 5C 74 0B 66 83 F8 2E 75 09 48 8B F3 EB 04 48 8D 6B 02 48 83 C3 02 0F B7 03 66 85 C0 75 D9 48 85 ED 74 32 4D 85 ED 74 28 4C 8B CD 4C 2B CF 49 D1 F9 4C 39 8C 24 80 00 00 00 0F 86 B2 00 00 00 4C 8B C7 48 83 CA FF 49 8B CD E8 ?? ?? ?? ?? 33 C9 48 8B FD EB 0A 4D 85 ED 74 05 66 41 89 4D 00 48 85 F6 74 57 48 3B F7 72 52 4D 85 FF 74 24 4C 8B CE 4C 2B CF 49 D1 F9 4C 39 8C 24 90 00 00 00 76 70 4C 8B C7 48 83 CA FF 49 8B CF E8 ?? ?? ?? ?? 33 C9 4D 85 F6 74 56 48 2B DE 48 D1 FB 48 39 9C 24 A0 00 00 00 76 4A 4C 8B CB 4C 8B C6 48 83 CA FF 49 8B CE E8 ?? ?? ?? ?? EB 32 4D 85 FF 74 24 48 2B DF 48 D1 FB 48 39 9C 24 90 00 00 00 76 21 4C 8B CB 4C 8B C7 48 83 CA FF 49 8B CF E8 ?? ?? ?? ?? 33 C9 4D 85 F6 74 04 66 41 89 0E 33 C0 EB 77 8B 74 24 60 4C 8B 4C 24 70 4D 85 E4 74 0A 4D 85 C9 74 05 66 41 89 0C 24 4D 85 ED 74 0F 48 39 8C 24 80 00 00 00 76 05 66 41 89 4D 00 4D 85 FF 74 0E 48 39 8C 24 90 00 00 00 76 04 66 41 89 0F 4D 85 F6 74 0E 48 39 8C 24 A0 00 00 00 76 04 66 41 89 0E E8 ?? ?? ?? ?? 48 85 FF 75 10 BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 EB 0B 85 F6 75 EC 8D 4E 22 89 08 8B C1 48 8B 5C 24 68 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "_fputchar"
		size = 29
		refs = "0009 __iob_func 0019 putc"
		altNames = "putchar"
	strings:
		$1 = { 40 53 48 83 EC 20 8B D9 E8 ?? ?? ?? ?? 8B CB 48 8D 50 30 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_1_0 {
	meta:
		name = "_pipe"
		size = 731
		refs = "0034 __doserrno 003b _errno 0046 _invalid_parameter_noinfo 00d9 __imp_CreatePipe 00e3 __imp_GetLastError 00ea _dosmaperr 00f1 _alloc_osfhnd 0119 __pioinfo 0145 _unlock_fhandle 01b2 _get_fmode 023e _set_osfhnd 0261 _invoke_watson 0299 __imp_CloseHandle"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 81 EC 80 00 00 00 45 8B E8 4C 8B F1 33 F6 8B FE 44 8B E6 8B C6 48 85 C9 0F 95 C0 85 C0 75 1F E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 6C 02 00 00 83 CB FF 89 59 04 89 19 41 F7 C0 7F 3F FF FF 8B C6 0F 94 C0 85 C0 75 1E E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B C3 E9 36 02 00 00 41 8B C0 41 B8 00 C0 00 00 41 23 C0 8B CE 41 3B C0 0F 95 C1 85 C9 74 CA C7 44 24 60 18 00 00 00 48 89 74 24 68 41 8B C5 25 80 00 00 00 89 84 24 C8 00 00 00 8B C6 0F 94 C0 89 44 24 70 44 8B CA 4C 8D 44 24 60 48 8D 54 24 58 48 8D 4C 24 50 FF 15 ?? ?? ?? ?? 85 C0 75 0F FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB 91 E8 ?? ?? ?? ?? 48 63 F0 89 B4 24 B0 00 00 00 3B F3 0F 84 75 01 00 00 48 8B CE 48 8B D6 48 C1 FA 05 48 89 54 24 38 4C 8D 05 ?? ?? ?? ?? 83 E1 1F 4C 6B F9 58 49 8B 04 D0 41 C6 44 07 08 89 49 8B 04 D0 41 80 64 07 38 80 49 8B 04 D0 41 80 64 07 38 7F 8B CE E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 63 F8 89 7C 24 30 3B FB 0F 84 09 01 00 00 83 A4 24 B0 00 00 00 00 48 8B CF 48 8B D7 48 C1 FA 05 48 89 54 24 48 83 E1 1F 48 6B C9 58 48 89 4C 24 40 4C 8D 05 ?? ?? ?? ?? 49 8B 04 D0 C6 44 08 08 89 49 8B 04 D0 80 64 08 38 80 49 8B 04 D0 80 64 08 38 7F 8B CF E8 ?? ?? ?? ?? 48 8D 8C 24 B0 00 00 00 E8 ?? ?? ?? ?? 85 C0 0F 85 92 00 00 00 B8 00 80 00 00 44 85 E8 75 10 41 0F BA E5 0E 72 34 39 84 24 B0 00 00 00 75 2B 48 8B 54 24 38 4C 8D 0D ?? ?? ?? ?? 49 8B 04 D1 41 80 64 07 08 7F 4C 8B 44 24 48 4B 8B 04 C1 48 8B 4C 24 40 80 64 08 08 7F EB 16 4C 8D 0D ?? ?? ?? ?? 4C 8B 44 24 48 48 8B 54 24 38 48 8B 4C 24 40 83 BC 24 C8 00 00 00 00 74 13 49 8B 04 D1 41 80 4C 07 08 10 4B 8B 04 C1 80 4C 08 08 10 48 8B 54 24 50 8B CE E8 ?? ?? ?? ?? 48 8B 54 24 58 8B CF E8 ?? ?? ?? ?? EB 32 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 8B 54 24 38 4C 8D 05 ?? ?? ?? ?? 49 8B 04 D0 41 C6 44 07 08 00 41 BC 01 00 00 00 45 85 E4 74 2E E8 ?? ?? ?? ?? C7 00 18 00 00 00 48 8B 4C 24 50 FF 15 ?? ?? ?? ?? 48 8B 4C 24 58 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 20 00 E9 CC FD FF FF 41 89 36 41 89 7E 04 33 C0 4C 8D 9C 24 80 00 00 00 49 8B 5B 38 49 8B 73 40 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_102_2_0 {
	meta:
		name = "_pipe$fin$1"
		size = 28
		refs = "0010 _unlock_fhandle"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA 8B 8D B0 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_102_3_0 {
	meta:
		name = "_pipe$fin$0"
		size = 25
		refs = "000d _unlock_fhandle"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA 8B 4D 30 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "strrchr"
		size = 324
		refs = "0058 __isa_available"
	strings:
		$1 = { 48 83 EC 18 45 33 C0 4C 8B C9 85 D2 75 48 41 83 E1 0F 48 8B D1 0F 57 C9 48 83 E2 F0 41 8B C9 41 83 C9 FF 41 D3 E1 66 0F 6F 02 66 0F 74 C1 66 0F D7 C0 41 23 C1 75 14 48 83 C2 10 66 0F 6F 02 66 0F 74 C1 66 0F D7 C0 85 C0 74 EC 0F BC C0 48 03 C2 E9 A6 00 00 00 83 3D ?? ?? ?? ?? 02 0F 8D 9E 00 00 00 4C 8B D1 0F B6 C2 41 83 E1 0F 49 83 E2 F0 8B C8 0F 57 D2 C1 E1 08 0B C8 66 0F 6E C1 41 8B C9 41 83 C9 FF 41 D3 E1 F2 0F 70 C8 00 66 0F 6F C2 66 41 0F 74 02 66 0F 70 D9 00 66 0F D7 C8 66 0F 6F C3 66 41 0F 74 02 66 0F D7 D0 41 23 D1 41 23 C9 75 2E 0F BD CA 66 0F 6F CA 66 0F 6F C3 49 03 CA 85 D2 4C 0F 45 C1 49 83 C2 10 66 41 0F 74 0A 66 41 0F 74 02 66 0F D7 C9 66 0F D7 D0 85 C9 74 D2 8B C1 F7 D8 23 C1 FF C8 23 D0 0F BD CA 49 03 CA 85 D2 4C 0F 45 C1 49 8B C0 48 83 C4 18 C3 F6 C1 0F 74 19 41 0F BE 01 3B C2 4D 0F 44 C1 41 80 39 00 74 E3 49 FF C1 41 F6 C1 0F 75 E7 0F B6 C2 66 0F 6E C0 66 41 0F 3A 63 01 40 73 0D 4C 63 C1 4D 03 C1 66 41 0F 3A 63 01 40 74 BB 49 83 C1 10 EB E2 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "__dyn_tls_dtor"
		size = 138
		refs = "001a _tls_index 0028 dtor_list 0069 free"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 83 FA 03 74 04 85 D2 75 5D 8B 0D ?? ?? ?? ?? 65 48 8B 04 25 58 00 00 00 BF ?? ?? ?? ?? 48 8B 04 C8 48 8B 3C 07 48 85 FF 74 3C 8B 1F FF CB 78 1D 48 63 F3 48 83 C6 02 48 8D 34 F7 48 8B 06 48 85 C0 74 02 FF D0 48 83 EE 08 FF CB 79 EE 48 8B 5F 08 48 85 DB 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B FB 48 85 DB 75 C4 48 8B 5C 24 30 48 8B 74 24 38 B8 01 00 00 00 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_106_1_0 {
	meta:
		name = "__tlregdtor"
		size = 143
		refs = "001a _tls_index 001f dtor_list 0034 dtor_list_head 004f _malloc_crt"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 65 48 8B 04 25 58 00 00 00 8B 15 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 8B 1C D0 48 8B F9 48 8B 04 1E 48 85 C0 75 11 B8 ?? ?? ?? ?? 48 03 C3 48 89 04 1E 83 20 00 EB 2B 83 38 1E 75 26 B9 00 01 00 00 E8 ?? ?? ?? ?? 48 8B C8 48 85 C0 75 05 83 C8 FF EB 1F 48 8B 04 1E 83 21 00 48 89 0C 1E 48 89 41 08 48 8B 0C 1E 48 63 01 48 89 7C C1 10 FF 01 33 C0 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "asinhf"
		size = 188
		refs = "0016 _fdtest 003e __xmm@80000000800000008000000080000000 0055 __real@40000000 005d _FEps_C 0071 __real@3f800000 0076 sqrtf 0090 log1pf 009a logf 00a2 __real@3f317218"
	strings:
		$1 = { F3 0F 11 44 24 08 53 48 83 EC 30 48 8D 4C 24 40 0F 29 7C 24 20 E8 ?? ?? ?? ?? 0F BF C8 83 F9 02 77 0B F3 0F 10 44 24 40 E9 84 00 00 00 F3 0F 10 7C 24 40 0F 57 C0 0F 2F C7 76 14 0F 57 3D ?? ?? ?? ?? BB 01 00 00 00 F3 0F 11 7C 24 40 EB 02 33 DB F3 0F 10 05 ?? ?? ?? ?? F3 0F 5E 05 ?? ?? ?? ?? 0F 2F C7 76 30 F3 0F 59 FF 0F 28 C7 F3 0F 58 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? F3 0F 58 05 ?? ?? ?? ?? F3 0F 5E F8 F3 0F 58 7C 24 40 0F 28 C7 E8 ?? ?? ?? ?? EB 10 0F 28 C7 E8 ?? ?? ?? ?? F3 0F 58 05 ?? ?? ?? ?? 85 DB 74 07 0F 57 05 ?? ?? ?? ?? 0F 28 7C 24 20 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "acos"
		size = 741
		refs = "009c ??_C@_04PDIFKINK@acos?$AA@ 00a6 _handle_error 00b8 __real@3ff921fb54442d18 00c6 __real@3ff0000000000000 00da __real@bff0000000000000 00e6 __real@400921fb54442d18 00f0 _set_statfp 013d __xmm@80000000000000008000000000000000 015d __real@3fe0000000000000 019b __real@3f0951665d321061 01a3 __real@3fbb1a422982ce76 01ab __real@3f51e5f887a62135 01b3 __real@3fee324ab418f78d 01c3 __real@3fac28d390c29690 01cb __real@40062021571dccfc 01db __real@3fd1a2bec1b7ef59 01e3 __real@400a4646f903cdea 01f3 __real@3fdc7b297e269eac 01fb __real@3ff5d6b12001f228 0207 __real@3fcd1e4180029834 0230 __real@3c91a62633145c07 023c __real@4000000000000000"
	strings:
		$1 = { 48 83 EC 68 48 B8 00 00 00 00 00 00 00 80 49 B9 FF FF FF FF FF FF FF 7F 0F 57 C9 0F 29 74 24 50 0F 28 D0 F2 0F 11 4C 24 70 F2 0F 11 84 24 80 00 00 00 4C 8B 84 24 80 00 00 00 49 8B D0 49 8B C8 48 23 D0 48 C1 E9 34 49 8B C0 49 23 C1 81 E1 FF 07 00 00 49 B9 00 00 00 00 00 00 F0 7F 81 E9 FF 03 00 00 49 3B C1 76 47 41 B9 01 00 00 00 48 B8 00 00 00 00 00 00 08 00 44 89 4C 24 40 4C 0B C0 F2 0F 11 4C 24 38 F2 0F 11 44 24 30 C7 44 24 28 21 00 00 00 83 64 24 20 00 48 8D 0D ?? ?? ?? ?? BA 0D 00 00 00 E8 ?? ?? ?? ?? E9 2C 02 00 00 83 F9 C8 7D 0A F2 0F 10 35 ?? ?? ?? ?? EB 2C 85 C9 78 70 66 0F 2E 05 ?? ?? ?? ?? 7A 0A 75 08 0F 28 C1 E9 05 02 00 00 66 0F 2E 05 ?? ?? ?? ?? 7A 1C 75 1A F2 0F 10 35 ?? ?? ?? ?? B9 20 00 00 00 E8 ?? ?? ?? ?? 0F 28 C6 E9 DF 01 00 00 41 B9 01 00 00 00 49 B8 00 00 00 00 00 00 F8 FF 44 89 4C 24 40 F2 0F 11 4C 24 38 F2 0F 11 44 24 30 C7 44 24 28 21 00 00 00 C7 44 24 20 08 00 00 00 E9 67 FF FF FF 0F 28 F0 48 85 D2 74 07 0F 57 35 ?? ?? ?? ?? 33 C0 83 F9 FF 0F 9D C0 85 C0 74 31 F2 0F 10 1D ?? ?? ?? ?? F2 0F 5C DE F2 0F 59 1D ?? ?? ?? ?? F2 0F 11 5C 24 78 F2 0F 51 4C 24 78 F2 0F 11 4C 24 70 F2 0F 10 64 24 70 0F 28 F4 EB 13 F2 0F 10 64 24 70 0F 28 DE F2 0F 59 DE F2 0F 11 5C 24 78 0F 28 EB 0F 28 C3 F2 0F 59 2D ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 5C 05 ?? ?? ?? ?? F2 0F 59 EB F2 0F 59 C3 F2 0F 5C 2D ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 EB F2 0F 59 C3 F2 0F 58 2D ?? ?? ?? ?? F2 0F 5C 05 ?? ?? ?? ?? F2 0F 59 EB F2 0F 59 C3 F2 0F 5C 2D ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 EB F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EB F2 0F 5E E8 85 C0 0F 84 A0 00 00 00 48 85 D2 74 29 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 EE F2 0F 5C 2D ?? ?? ?? ?? F2 0F 58 EC F2 0F 59 2D ?? ?? ?? ?? F2 0F 5C C5 E9 92 00 00 00 F2 0F 10 15 ?? ?? ?? ?? F2 0F 11 A4 24 80 00 00 00 48 B9 00 00 00 00 FF FF FF FF 48 8B 84 24 80 00 00 00 48 23 C1 48 89 84 24 80 00 00 00 F2 0F 59 F2 F2 0F 59 F5 F2 0F 10 A4 24 80 00 00 00 F2 0F 10 5C 24 78 0F 28 C4 0F 28 CC F2 0F 58 4C 24 70 F2 0F 59 C4 F2 0F 59 E2 F2 0F 5C D8 F2 0F 5E D9 F2 0F 59 DA F2 0F 58 DE F2 0F 58 DC 0F 28 C3 EB 20 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 EA F2 0F 5C C5 F2 0F 5C D0 F2 0F 10 05 ?? ?? ?? ?? F2 0F 5C C2 0F 28 74 24 50 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "_fdxp_addh"
		size = 850
		refs = "003d _fdunscale 0051 _fdtest 007f _fperrraise 0087 _FNan_C 0201 _fd_int 020e _fdscale"
	strings:
		$1 = { F3 0F 11 54 24 18 55 53 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 48 45 33 F6 F3 0F 11 55 60 0F 29 74 24 30 48 63 F2 48 8B F9 85 D2 0F 84 05 03 00 00 48 8D 55 60 48 8D 4D 48 E8 ?? ?? ?? ?? 66 44 3B F0 7D 68 66 83 F8 02 74 54 48 8B CF E8 ?? ?? ?? ?? 66 85 C0 7E 47 66 83 F8 02 0F 84 D5 02 00 00 0F B7 47 02 B9 00 80 00 00 66 33 45 5A 66 85 C1 0F 84 BF 02 00 00 41 8D 4E 01 E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? F3 0F 11 07 83 FE 01 0F 8E A1 02 00 00 44 89 77 04 E9 98 02 00 00 F3 0F 10 45 58 F3 0F 11 07 E9 8A 02 00 00 66 85 C0 0F 89 81 02 00 00 41 BC 00 01 00 00 41 8B DE 85 F6 0F 8E 70 02 00 00 4D 8B FE 4C 8D 6F FC 0F 57 F6 4C 8B F7 F3 41 0F 10 06 48 8D 55 D8 48 8D 4D 50 F3 0F 11 45 D8 E8 ?? ?? ?? ?? 33 D2 66 3B D0 0F 8C 41 02 00 00 66 85 C0 0F 84 20 02 00 00 0F BF 55 50 0F BF 45 48 F3 0F 10 4D 58 8B CA 2B C8 83 F9 F4 7F 58 0F 2E CE 7A 02 74 51 8B CB 49 8B C7 48 FF C0 FF C1 48 3B C6 7D 0C F3 0F 10 04 87 0F 2E C6 7A EC 75 EA 8D 46 FF 3B C8 7D 04 FF C1 EB 06 3B CE 75 02 FF C9 48 63 D1 4C 3B FA 7D 0F 8B 44 97 FC 89 04 97 48 FF CA 49 3B D7 7F F1 83 65 58 00 F3 41 0F 11 0E E9 A8 01 00 00 B8 0C 00 00 00 3B C8 7C 11 0F 2E CE 7A 02 74 0A 44 8B E2 FF C3 E9 83 01 00 00 F3 41 0F 58 0E 0F 2E CE F3 41 0F 11 0E 7A 39 75 37 8B CB 49 8B C6 FF C1 48 8D 40 04 3B CE 7D 10 F3 0F 10 00 0F 2E C6 F3 0F 11 40 FC 7A E8 75 E6 83 64 B7 FC 00 F3 41 0F 10 06 0F 2E C6 0F 28 C8 7A 06 0F 84 68 01 00 00 48 8D 55 58 48 8D 4D 48 F3 0F 11 4D 58 E8 ?? ?? ?? ?? 0F BF 55 48 41 8D 4C 24 F4 3B CA 0F 8D 94 00 00 00 66 41 2B D4 48 8D 4D 58 66 83 C2 0C E8 ?? ?? ?? ?? 0F BF 55 48 48 8D 4D 58 E8 ?? ?? ?? ?? F3 41 0F 10 06 F3 0F 5C 45 58 0F 2E C6 F3 41 0F 11 06 7A 26 75 24 8B CB 49 8B C6 FF C1 48 8D 40 04 3B CE 7D 10 F3 0F 10 00 0F 2E C6 F3 0F 11 40 FC 7A E8 75 E6 83 64 B7 FC 00 49 FF CF 49 83 ED 04 49 83 EE 04 FF CB 75 0B 41 BC 00 01 00 00 E9 B1 00 00 00 F3 41 0F 10 45 00 48 8D 55 60 48 8D 4D 50 F3 0F 11 45 60 E8 ?? ?? ?? ?? 44 0F BF 65 50 E9 8F 00 00 00 44 8D 63 01 44 3B E6 0F 84 A4 00 00 00 F3 41 0F 10 06 48 63 C3 48 8D 4D 50 48 8D 1C 87 F3 0F 11 45 58 48 8B D3 E8 ?? ?? ?? ?? BA 0C 00 00 00 48 8B CB E8 ?? ?? ?? ?? 0F BF 55 50 48 8B CB E8 ?? ?? ?? ?? 0F BF 45 50 F3 0F 10 45 58 F3 41 0F 10 0E 89 45 DC F3 0F 5C C1 0F 2E C6 F3 0F 11 45 58 7A 09 75 07 F3 0F 11 4D 60 EB 05 F3 0F 11 45 60 48 8D 55 60 48 8D 4D 48 E8 ?? ?? ?? ?? 41 8B DC 44 8B 65 DC 49 FF C7 49 83 C5 04 49 83 C6 04 3B DE 0F 8C B7 FD FF FF EB 18 F3 0F 10 45 58 8D 43 01 48 63 CB F3 0F 11 04 8F 3B C6 7D 04 89 54 8F 04 48 8B C7 0F 28 74 24 30 48 83 C4 48 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_109_1_0 {
	meta:
		name = "_fdxp_addx"
		size = 110
		refs = "0033 __real@00000000 0042 _fdxp_addh"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 FF 41 8B E9 49 8B F0 44 8B F2 48 8B D9 45 85 C9 7E 24 F3 0F 10 16 0F 2E 15 ?? ?? ?? ?? 7A 02 74 15 41 8B D6 48 8B CB E8 ?? ?? ?? ?? FF C7 48 83 C6 04 3B FD 7C DC 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 8B C3 48 8B 5C 24 30 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_27_1_1 {
	meta:
		name = "_FXp_addx"
		size = 110
		refs = "0033 __real@00000000 0042 _FXp_addh"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 FF 41 8B E9 49 8B F0 44 8B F2 48 8B D9 45 85 C9 7E 24 F3 0F 10 16 0F 2E 15 ?? ?? ?? ?? 7A 02 74 15 41 8B D6 48 8B CB E8 ?? ?? ?? ?? FF C7 48 83 C6 04 3B FD 7C DC 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 8B C3 48 8B 5C 24 30 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_109_2_0 {
	meta:
		name = "_fdxp_getw"
		size = 78
	strings:
		$1 = { 85 D2 75 04 0F 57 C0 C3 83 FA 01 74 3C F3 0F 10 11 0F 57 C0 0F 2E D0 7A 02 74 2E 83 FA 01 7E 0C F3 0F 10 49 04 0F 2E C8 7A 02 74 1D 83 FA 02 75 09 F3 0F 58 51 04 0F 28 C2 C3 F3 0F 10 41 08 F3 0F 58 41 04 F3 0F 58 C2 C3 F3 0F 10 01 C3 }
	condition:
		$1
}

rule file_109_3_0 {
	meta:
		name = "_fdxp_invx"
		size = 329
		refs = "0035 _fdtest 005a _FInf_C 0084 memcpy 008e __real@bf800000 0096 _fdxp_mulh 00ac __real@3f800000 00ba _fdxp_setw 00e1 _fdxp_mulx 00f3 _fdxp_addh 0118 _fdxp_addx"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 40 33 ED 0F 29 70 D8 4D 8B F8 48 63 FA 48 8B D9 85 D2 0F 84 EE 00 00 00 E8 ?? ?? ?? ?? 66 3B E8 7F 29 8D 75 01 66 3B C6 75 07 89 2B E9 D5 00 00 00 66 85 C0 0F 85 CC 00 00 00 F3 0F 10 05 ?? ?? ?? ?? F3 0F 11 03 E9 BB 00 00 00 F3 0F 10 33 4C 8B F7 48 8B D3 49 C1 E6 02 4D 8B C6 4B 8D 2C 3E 48 8B CD 4D 8D 24 2E E8 ?? ?? ?? ?? 8B D7 F3 0F 10 15 ?? ?? ?? ?? 48 8B CD E8 ?? ?? ?? ?? BE 01 00 00 00 3B FE 7E 05 F3 0F 58 73 04 F3 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CB F3 0F 5E D6 E8 ?? ?? ?? ?? 3B FE 7E 60 4D 8B C6 48 8B D3 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4C 8B C5 8B D7 49 8B CF 4C 89 64 24 20 E8 ?? ?? ?? ?? 8B D7 49 8B CF F3 0F 10 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 44 8B CF 4C 8B C3 8B D7 49 8B CF 4C 89 64 24 20 E8 ?? ?? ?? ?? 44 8B CF 4D 8B C7 8B D7 48 8B CB E8 ?? ?? ?? ?? 03 F6 3B F7 7C A0 48 8B 6C 24 68 48 8B 74 24 70 48 8B 7C 24 78 0F 28 74 24 30 48 8B C3 48 8B 5C 24 60 48 83 C4 40 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_27_3_1 {
	meta:
		name = "_FXp_invx"
		size = 329
		refs = "0035 _FDtest 005a _FInf 0084 memcpy 008e __real@bf800000 0096 _FXp_mulh 00ac __real@3f800000 00ba _FXp_setw 00e1 _FXp_mulx 00f3 _FXp_addh 0118 _FXp_addx"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 40 33 ED 0F 29 70 D8 4D 8B F8 48 63 FA 48 8B D9 85 D2 0F 84 EE 00 00 00 E8 ?? ?? ?? ?? 66 3B E8 7F 29 8D 75 01 66 3B C6 75 07 89 2B E9 D5 00 00 00 66 85 C0 0F 85 CC 00 00 00 F3 0F 10 05 ?? ?? ?? ?? F3 0F 11 03 E9 BB 00 00 00 F3 0F 10 33 4C 8B F7 48 8B D3 49 C1 E6 02 4D 8B C6 4B 8D 2C 3E 48 8B CD 4D 8D 24 2E E8 ?? ?? ?? ?? 8B D7 F3 0F 10 15 ?? ?? ?? ?? 48 8B CD E8 ?? ?? ?? ?? BE 01 00 00 00 3B FE 7E 05 F3 0F 58 73 04 F3 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CB F3 0F 5E D6 E8 ?? ?? ?? ?? 3B FE 7E 60 4D 8B C6 48 8B D3 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4C 8B C5 8B D7 49 8B CF 4C 89 64 24 20 E8 ?? ?? ?? ?? 8B D7 49 8B CF F3 0F 10 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 44 8B CF 4C 8B C3 8B D7 49 8B CF 4C 89 64 24 20 E8 ?? ?? ?? ?? 44 8B CF 4D 8B C7 8B D7 48 8B CB E8 ?? ?? ?? ?? 03 F6 3B F7 7C A0 48 8B 6C 24 68 48 8B 74 24 70 48 8B 7C 24 78 0F 28 74 24 30 48 8B C3 48 8B 5C 24 60 48 83 C4 40 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_109_4_0 {
	meta:
		name = "_fdxp_ldexpx"
		size = 119
		refs = "0035 ldexp 0043 __real@00000000"
		altNames = "_FXp_ldexpx"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 DB 45 8B F0 8B EA 48 8B F1 85 D2 7E 32 48 8B F9 F3 0F 10 07 41 8B D6 0F 5A C0 E8 ?? ?? ?? ?? 0F 57 C9 F2 0F 5A C8 0F 2E 0D ?? ?? ?? ?? F3 0F 11 0F 7A 02 74 0A FF C3 48 83 C7 04 3B DD 7C D1 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 7C 24 48 48 8B C6 48 8B 74 24 40 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_109_5_0 {
	meta:
		name = "_fdxp_movx"
		size = 36
		refs = "0017 memcpy"
		altNames = "_FXp_movx"
	strings:
		$1 = { 40 53 48 83 EC 20 49 8B C0 4C 63 C2 48 8B D9 49 C1 E0 02 48 8B D0 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_109_6_0 {
	meta:
		name = "_fdxp_mulh"
		size = 481
		refs = "001f __security_cookie 004b _fdtest 0066 _fperrraise 00d3 __real@00000000 0129 _fdunscale 0137 _fd_int 0144 _fdscale 0154 _fdxp_addh 01c0 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 60 0F 29 7C 24 50 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 E0 45 33 E4 0F 28 FA 44 8B FA 48 8B F9 85 D2 7E 58 0F 28 C2 F3 0F 59 01 48 8D 4D D0 F3 0F 11 45 D0 E8 ?? ?? ?? ?? 0F B7 F0 66 44 3B E0 7F 37 41 8D 5C 24 01 66 83 F8 02 75 07 8B CB E8 ?? ?? ?? ?? F3 0F 10 45 D0 F3 0F 11 07 66 44 3B E6 0F 8D 38 01 00 00 44 3B FB 0F 8E 2F 01 00 00 44 89 67 04 E9 26 01 00 00 44 89 27 BB 01 00 00 00 45 8B EC 44 8B F3 45 85 FF 0F 8E 0F 01 00 00 49 8B C4 4C 8D 65 D0 8B F3 4C 2B E7 48 89 45 C8 41 83 FE 04 7D 4B 48 03 C6 48 8D 0C 87 43 8D 04 2E 41 3B C7 7D 2E F3 0F 10 01 0F 2E 05 ?? ?? ?? ?? 7A 02 74 1F 83 21 00 F3 0F 59 C7 44 03 F3 48 03 F3 F3 41 0F 11 04 0C 48 83 C1 04 41 83 FE 04 7C CB EB 0D 83 64 B5 D0 00 BE 08 00 00 00 44 8B F6 F3 0F 10 45 D0 0F 2E 05 ?? ?? ?? ?? 7A 06 0F 84 9A 00 00 00 48 8D 55 C0 48 8D 4D C4 F3 0F 11 45 C0 E8 ?? ?? ?? ?? 48 8D 4D C0 BA 0C 00 00 00 E8 ?? ?? ?? ?? 0F BF 55 C4 48 8D 4D C0 E8 ?? ?? ?? ?? 41 8B D7 48 8B CF F3 0F 10 55 C0 E8 ?? ?? ?? ?? 41 8B D7 48 8B CF F3 0F 10 55 D0 F3 0F 5C 55 C0 E8 ?? ?? ?? ?? 48 8B C3 48 3B DE 7D 1F F3 0F 10 44 85 D0 0F 2E 05 ?? ?? ?? ?? F3 0F 11 44 85 CC 7A 02 74 08 48 03 C3 48 3B C6 7C E1 48 8B 45 C8 44 03 EB 49 83 EC 04 48 03 C3 44 2B F3 48 2B F3 48 89 45 C8 45 3B EF 0F 8C 01 FF FF FF 48 8B C7 48 8B 4D E0 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 B0 00 00 00 0F 28 7C 24 50 48 83 C4 60 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_27_6_1 {
	meta:
		name = "_FXp_mulh"
		size = 481
		refs = "001f __security_cookie 004b _FDtest 0066 _Feraise 00d3 __real@00000000 0129 _FDunscale 0137 _FDint 0144 _FDscale 0154 _FXp_addh 01c0 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 60 0F 29 7C 24 50 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 E0 45 33 E4 0F 28 FA 44 8B FA 48 8B F9 85 D2 7E 58 0F 28 C2 F3 0F 59 01 48 8D 4D D0 F3 0F 11 45 D0 E8 ?? ?? ?? ?? 0F B7 F0 66 44 3B E0 7F 37 41 8D 5C 24 01 66 83 F8 02 75 07 8B CB E8 ?? ?? ?? ?? F3 0F 10 45 D0 F3 0F 11 07 66 44 3B E6 0F 8D 38 01 00 00 44 3B FB 0F 8E 2F 01 00 00 44 89 67 04 E9 26 01 00 00 44 89 27 BB 01 00 00 00 45 8B EC 44 8B F3 45 85 FF 0F 8E 0F 01 00 00 49 8B C4 4C 8D 65 D0 8B F3 4C 2B E7 48 89 45 C8 41 83 FE 04 7D 4B 48 03 C6 48 8D 0C 87 43 8D 04 2E 41 3B C7 7D 2E F3 0F 10 01 0F 2E 05 ?? ?? ?? ?? 7A 02 74 1F 83 21 00 F3 0F 59 C7 44 03 F3 48 03 F3 F3 41 0F 11 04 0C 48 83 C1 04 41 83 FE 04 7C CB EB 0D 83 64 B5 D0 00 BE 08 00 00 00 44 8B F6 F3 0F 10 45 D0 0F 2E 05 ?? ?? ?? ?? 7A 06 0F 84 9A 00 00 00 48 8D 55 C0 48 8D 4D C4 F3 0F 11 45 C0 E8 ?? ?? ?? ?? 48 8D 4D C0 BA 0C 00 00 00 E8 ?? ?? ?? ?? 0F BF 55 C4 48 8D 4D C0 E8 ?? ?? ?? ?? 41 8B D7 48 8B CF F3 0F 10 55 C0 E8 ?? ?? ?? ?? 41 8B D7 48 8B CF F3 0F 10 55 D0 F3 0F 5C 55 C0 E8 ?? ?? ?? ?? 48 8B C3 48 3B DE 7D 1F F3 0F 10 44 85 D0 0F 2E 05 ?? ?? ?? ?? F3 0F 11 44 85 CC 7A 02 74 08 48 03 C3 48 3B C6 7C E1 48 8B 45 C8 44 03 EB 49 83 EC 04 48 03 C3 44 2B F3 48 2B F3 48 89 45 C8 45 3B EF 0F 8C 01 FF FF FF 48 8B C7 48 8B 4D E0 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 B0 00 00 00 0F 28 7C 24 50 48 83 C4 60 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_109_7_0 {
	meta:
		name = "_fdxp_mulx"
		size = 254
		refs = "0041 __real@00000000 005d _fdxp_mulh 007d memcpy 00d2 _fdxp_addx"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 20 49 63 E9 49 8B D8 48 63 FA 48 8B F1 85 D2 0F 84 AE 00 00 00 45 85 C9 0F 84 A5 00 00 00 F3 41 0F 10 10 0F 2E 15 ?? ?? ?? ?? 7A 02 74 11 F3 41 0F 10 40 04 0F 2E 05 ?? ?? ?? ?? 7A 0B 75 09 8B D7 E8 ?? ?? ?? ?? EB 7B 4C 8B 64 24 70 48 8B D1 4C 8B FF 49 C1 E7 02 49 8B CC 4D 8B C7 4F 8D 2C 27 E8 ?? ?? ?? ?? 8B D7 48 8B CE F3 0F 10 13 E8 ?? ?? ?? ?? 41 BE 01 00 00 00 EB 42 F3 42 0F 10 04 B3 0F 2E 05 ?? ?? ?? ?? 7A 02 74 36 4D 8B C7 49 8B D4 49 8B CD E8 ?? ?? ?? ?? 8B D7 49 8B CD F3 42 0F 10 14 B3 E8 ?? ?? ?? ?? 44 8B CF 4D 8B C5 8B D7 48 8B CE E8 ?? ?? ?? ?? 49 FF C6 4C 3B F5 7C B9 48 8B 5C 24 50 48 8B 6C 24 58 48 8B C6 48 8B 74 24 60 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_27_7_1 {
	meta:
		name = "_FXp_mulx"
		size = 254
		refs = "0041 __real@00000000 005d _FXp_mulh 007d memcpy 00d2 _FXp_addx"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 20 49 63 E9 49 8B D8 48 63 FA 48 8B F1 85 D2 0F 84 AE 00 00 00 45 85 C9 0F 84 A5 00 00 00 F3 41 0F 10 10 0F 2E 15 ?? ?? ?? ?? 7A 02 74 11 F3 41 0F 10 40 04 0F 2E 05 ?? ?? ?? ?? 7A 0B 75 09 8B D7 E8 ?? ?? ?? ?? EB 7B 4C 8B 64 24 70 48 8B D1 4C 8B FF 49 C1 E7 02 49 8B CC 4D 8B C7 4F 8D 2C 27 E8 ?? ?? ?? ?? 8B D7 48 8B CE F3 0F 10 13 E8 ?? ?? ?? ?? 41 BE 01 00 00 00 EB 42 F3 42 0F 10 04 B3 0F 2E 05 ?? ?? ?? ?? 7A 02 74 36 4D 8B C7 49 8B D4 49 8B CD E8 ?? ?? ?? ?? 8B D7 49 8B CD F3 42 0F 10 14 B3 E8 ?? ?? ?? ?? 44 8B CF 4D 8B C5 8B D7 48 8B CE E8 ?? ?? ?? ?? 49 FF C6 4C 3B F5 7C B9 48 8B 5C 24 50 48 8B 6C 24 58 48 8B C6 48 8B 74 24 60 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_109_8_0 {
	meta:
		name = "_fdxp_setw"
		size = 175
		refs = "0035 _fdunscale 005d _fd_int 006c _fdscale"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 20 57 48 83 EC 30 0F 29 70 E8 0F 28 F2 33 F6 8B FA 48 8B D9 F3 0F 11 70 18 85 D2 7E 70 83 FA 01 74 67 48 8D 50 18 48 8D 48 10 E8 ?? ?? ?? ?? 66 85 C0 74 4F 66 3B F0 7D 0F F3 0F 10 44 24 50 89 73 04 F3 0F 11 03 EB 45 48 8D 4C 24 50 BA 0C 00 00 00 E8 ?? ?? ?? ?? 0F BF 54 24 48 48 8D 4C 24 50 E8 ?? ?? ?? ?? F3 0F 10 44 24 50 F3 0F 5C F0 F3 0F 11 03 F3 0F 11 73 04 83 FF 02 7E 0F 89 73 08 EB 0A F3 0F 10 74 24 50 F3 0F 11 33 48 8B 74 24 58 0F 28 74 24 20 48 8B C3 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_27_9_1 {
	meta:
		name = "_FXp_setw"
		size = 175
		refs = "0035 _FDunscale 005d _FDint 006c _FDscale"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 20 57 48 83 EC 30 0F 29 70 E8 0F 28 F2 33 F6 8B FA 48 8B D9 F3 0F 11 70 18 85 D2 7E 70 83 FA 01 74 67 48 8D 50 18 48 8D 48 10 E8 ?? ?? ?? ?? 66 85 C0 74 4F 66 3B F0 7D 0F F3 0F 10 44 24 50 89 73 04 F3 0F 11 03 EB 45 48 8D 4C 24 50 BA 0C 00 00 00 E8 ?? ?? ?? ?? 0F BF 54 24 48 48 8D 4C 24 50 E8 ?? ?? ?? ?? F3 0F 10 44 24 50 F3 0F 5C F0 F3 0F 11 03 F3 0F 11 73 04 83 FF 02 7E 0F 89 73 08 EB 0A F3 0F 10 74 24 50 F3 0F 11 33 48 8B 74 24 58 0F 28 74 24 20 48 8B C3 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_109_9_0 {
	meta:
		name = "_fdxp_sqrtx"
		size = 349
		refs = "0031 _fdtest 006b sqrtf 0073 __real@3f800000 0081 _fdxp_setw 009a memcpy 00a7 __real@bf000000 00ac _fdxp_mulh 00c1 _fdxp_mulx 00e0 __real@3fc00000 00e8 _fdxp_addh 012b _fperrraise 0133 _FNan_C"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 30 33 F6 49 8B E8 48 63 FA 48 8B D9 85 D2 0F 84 0B 01 00 00 E8 ?? ?? ?? ?? 0F 57 C0 66 3B F0 0F 8E DF 00 00 00 F3 0F 10 0B 0F 2F C1 0F 87 D7 00 00 00 4C 8B F7 49 C1 E6 02 49 8D 34 2E 4D 8D 3C 36 83 FF 01 7E 05 F3 0F 58 4B 04 0F 28 C1 E8 ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CE F3 0F 5E D0 E8 ?? ?? ?? ?? 41 BC 02 00 00 00 41 3B FC 7E 79 4D 8B C6 48 8B D6 48 8B CD E8 ?? ?? ?? ?? 8B D7 48 8B CD F3 0F 10 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 44 8B CF 4C 8B C3 8B D7 48 8B CD 4C 89 7C 24 20 E8 ?? ?? ?? ?? 44 8B CF 4C 8B C6 8B D7 48 8B CD 4C 89 7C 24 20 E8 ?? ?? ?? ?? 8B D7 F3 0F 10 15 ?? ?? ?? ?? 48 8B CD E8 ?? ?? ?? ?? 44 8B CF 4C 8B C5 8B D7 48 8B CE 4C 89 7C 24 20 E8 ?? ?? ?? ?? 45 03 E4 44 3B E7 7C 87 44 8B CF 4C 8B C6 8B D7 48 8B CB 4C 89 7C 24 20 E8 ?? ?? ?? ?? EB 1B 0F 2F 03 76 16 B9 01 00 00 00 E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? F3 0F 11 03 48 8B 6C 24 58 48 8B 74 24 60 48 8B 7C 24 68 48 8B C3 48 8B 5C 24 50 48 83 C4 30 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_109_10_0 {
	meta:
		name = "_fdxp_subx"
		size = 117
		refs = "0033 __real@00000000 003e __xmm@80000000800000008000000080000000 0049 _fdxp_addh"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 FF 41 8B E9 49 8B F0 44 8B F2 48 8B D9 45 85 C9 7E 2B F3 0F 10 16 0F 2E 15 ?? ?? ?? ?? 7A 02 74 1C 0F 57 15 ?? ?? ?? ?? 41 8B D6 48 8B CB E8 ?? ?? ?? ?? FF C7 48 83 C6 04 3B FD 7C D5 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 8B C3 48 8B 5C 24 30 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_27_11_1 {
	meta:
		name = "_FXp_subx"
		size = 117
		refs = "0033 __real@00000000 003e __xmm@80000000800000008000000080000000 0049 _FXp_addh"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 FF 41 8B E9 49 8B F0 44 8B F2 48 8B D9 45 85 C9 7E 2B F3 0F 10 16 0F 2E 15 ?? ?? ?? ?? 7A 02 74 1C 0F 57 15 ?? ?? ?? ?? 41 8B D6 48 8B CB E8 ?? ?? ?? ?? FF C7 48 83 C6 04 3B FD 7C D5 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 8B C3 48 8B 5C 24 30 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_109_11_0 {
	meta:
		name = "fmaf"
		size = 629
		refs = "0025 __security_cookie 0063 _fdunscale 0133 _fdscale 0143 _fdxp_setw 0173 _fdxp_mulh 01b2 _fdxp_addx 023b _fperrraise 0243 _FNan_C 024f __security_check_cookie"
	strings:
		$1 = { 48 8B C4 48 89 58 20 55 56 57 48 8D 68 A1 48 81 EC B0 00 00 00 0F 29 70 D8 0F 29 78 C8 44 0F 29 40 B8 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 07 0F 28 FA 0F 28 F1 44 0F 28 C0 48 8D 55 BF 48 8D 4D C7 F3 44 0F 11 45 CF F3 0F 11 75 DF F3 0F 11 7D E7 F3 44 0F 11 45 BF F3 0F 11 75 D7 F3 0F 11 7D B7 E8 ?? ?? ?? ?? BE 02 00 00 00 0F B7 F8 66 3B C6 75 09 41 0F 28 C0 E9 CA 01 00 00 48 8D 55 D7 48 8D 4D C3 E8 ?? ?? ?? ?? 0F B7 D8 66 3B C6 75 08 0F 28 C6 E9 AD 01 00 00 48 8D 55 B7 48 8D 4D BB E8 ?? ?? ?? ?? 66 3B C6 75 08 0F 28 C7 E9 93 01 00 00 B9 01 00 00 00 66 3B F9 0F 84 45 01 00 00 66 3B D9 0F 84 3C 01 00 00 66 3B C1 74 DC 66 85 FF 0F 84 53 01 00 00 66 85 DB 0F 84 4A 01 00 00 66 85 C0 0F 84 41 01 00 00 0F BF 45 C7 0F B7 4D BB 0F BF 5D C3 03 D8 0F B7 45 D1 BA 00 80 00 00 66 33 45 E1 66 2B CB 66 33 45 E9 66 89 4D BB 66 85 C2 0F 84 12 01 00 00 8D 04 0E BF 04 00 00 00 66 3B C7 0F 87 01 01 00 00 0F BF D1 48 8D 4D B7 E8 ?? ?? ?? ?? 48 8D 4D F7 8B D7 F3 0F 10 55 BF E8 ?? ?? ?? ?? 48 8D 4D E7 8B D6 F3 0F 10 55 D7 E8 ?? ?? ?? ?? 48 8D 4D DF 8B D6 F3 0F 10 55 B7 E8 ?? ?? ?? ?? 48 8D 4D F7 8B D7 F3 0F 10 55 E7 E8 ?? ?? ?? ?? F3 0F 10 7D EB 0F 57 F6 0F 2E FE 7A 02 74 30 F3 0F 10 55 BF 48 8D 4D E7 8B D7 E8 ?? ?? ?? ?? 48 8D 4D E7 8B D7 0F 28 D7 E8 ?? ?? ?? ?? 4C 8D 45 E7 48 8D 4D F7 44 8B CF 8B D7 E8 ?? ?? ?? ?? 4C 8D 45 DF 48 8D 4D F7 44 8B CE 8B D7 E8 ?? ?? ?? ?? F3 0F 10 4D F7 0F 2E CE 7A 02 74 1C F3 0F 10 55 FB 0F 2E D6 7A 02 74 10 F3 0F 10 45 FF F3 0F 58 C2 F3 0F 58 C1 0F 28 C8 48 8D 4D B7 8B D3 F3 0F 11 4D B7 E8 ?? ?? ?? ?? F3 0F 10 45 B7 EB 40 66 85 FF 74 2E 66 85 DB 74 29 66 3B C1 75 16 0F B7 45 D1 BA 00 80 00 00 66 33 45 E1 66 33 45 E9 66 85 C2 75 0E F3 41 0F 59 F0 F3 0F 58 F7 E9 58 FE FF FF E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? 48 8B 4D 07 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 B0 00 00 00 49 8B 5B 38 41 0F 28 73 F0 41 0F 28 7B E0 45 0F 28 43 D0 49 8B E3 5F 5E 5D C3 }
	condition:
		$1
}

rule file_109_12_0 {
	meta:
		name = "ldexpf"
		size = 22
		refs = "0009 ldexp"
	strings:
		$1 = { 48 83 EC 28 F3 0F 5A C0 E8 ?? ?? ?? ?? F2 0F 5A C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "_write"
		size = 225
		refs = "0024 __doserrno 002c _errno 0041 _nhandle 0054 __pioinfo 0071 __lock_fhandle 008b _write_nolock 00ac _unlock_fhandle 00c8 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 10 89 4C 24 08 56 57 41 54 41 56 41 57 48 83 EC 20 41 8B F0 4C 8B F2 48 63 D9 83 FB FE 75 18 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 91 00 00 00 85 C9 78 75 3B 1D ?? ?? ?? ?? 73 6D 48 8B C3 48 8B FB 48 C1 FF 05 4C 8D 25 ?? ?? ?? ?? 83 E0 1F 4C 6B F8 58 49 8B 04 FC 42 0F BE 4C 38 08 83 E1 01 74 46 8B CB E8 ?? ?? ?? ?? 90 49 8B 04 FC 42 F6 44 38 08 01 74 11 44 8B C6 49 8B D6 8B CB E8 ?? ?? ?? ?? 8B F8 EB 16 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 20 00 83 CF FF 8B CB E8 ?? ?? ?? ?? 8B C7 EB 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 8B 5C 24 58 48 83 C4 20 41 5F 41 5E 41 5C 5F 5E C3 }
	condition:
		$1
}

rule file_111_2_0 {
	meta:
		name = "_write_nolock"
		size = 2033
		refs = "001e __chkstk 0028 __security_cookie 005f __doserrno 0067 _errno 0072 _invalid_parameter_noinfo 0087 __pioinfo 00dd _lseeki64_nolock 00e4 _isatty 010d _getptd 0143 __imp_GetConsoleMode 0162 __imp_GetConsoleCP 01de isleadbyte 0208 mbtowc 026a __imp_WideCharToMultiByte 02a8 __imp_WriteFile 035f _putwch_nolock 03d9 __imp_GetLastError 0781 _dosmaperr 07d2 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 C0 E5 FF FF B8 40 1B 00 00 E8 ?? ?? ?? ?? 48 2B E0 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 30 1A 00 00 45 33 E4 45 8B F8 4C 8B F2 48 63 F9 44 89 64 24 40 41 8B DC 41 8B F4 45 85 C0 75 07 33 C0 E9 6E 07 00 00 48 85 D2 75 20 E8 ?? ?? ?? ?? 44 89 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 49 07 00 00 48 8B C7 48 8B CF 48 8D 15 ?? ?? ?? ?? 48 C1 F9 05 83 E0 1F 48 89 4C 24 48 48 8B 0C CA 4C 6B E8 58 45 8A 64 0D 38 4C 89 6C 24 58 45 02 E4 41 D0 FC 41 8D 44 24 FF 3C 01 77 14 41 8B C7 F7 D0 A8 01 75 0B E8 ?? ?? ?? ?? 33 C9 89 08 EB 9A 41 F6 44 0D 08 20 74 0D 33 D2 8B CF 44 8D 42 02 E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 48 8B 7C 24 48 85 C0 0F 84 40 03 00 00 48 8D 05 ?? ?? ?? ?? 48 8B 04 F8 41 F6 44 05 08 80 0F 84 29 03 00 00 E8 ?? ?? ?? ?? 48 8D 54 24 64 48 8B 88 C0 00 00 00 33 C0 48 39 81 38 01 00 00 8B F8 48 8B 44 24 48 48 8D 0D ?? ?? ?? ?? 40 0F 94 C7 48 8B 0C C1 49 8B 4C 0D 00 FF 15 ?? ?? ?? ?? 33 C9 85 C0 0F 84 DF 02 00 00 33 C0 85 FF 74 09 45 84 E4 0F 84 C9 02 00 00 FF 15 ?? ?? ?? ?? 49 8B FE 89 44 24 68 33 C0 0F B7 C8 66 89 44 24 44 89 44 24 60 45 85 FF 0F 84 06 06 00 00 44 8B E8 45 84 E4 0F 85 A3 01 00 00 8A 0F 4C 8B 6C 24 58 48 8D 15 ?? ?? ?? ?? 80 F9 0A 0F 94 C0 45 33 C0 89 44 24 64 48 8B 44 24 48 48 8B 14 C2 45 39 44 15 50 74 1F 41 8A 44 15 4C 88 4C 24 6D 88 44 24 6C 45 89 44 15 50 41 B8 02 00 00 00 48 8D 54 24 6C EB 49 0F BE C9 E8 ?? ?? ?? ?? 85 C0 74 34 49 8B C7 48 2B C7 49 03 C6 48 83 F8 01 0F 8E B3 01 00 00 48 8D 4C 24 44 41 B8 02 00 00 00 48 8B D7 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 D9 01 00 00 48 FF C7 EB 1C 41 B8 01 00 00 00 48 8B D7 48 8D 4C 24 44 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 B8 01 00 00 8B 4C 24 68 33 C0 4C 8D 44 24 44 48 89 44 24 38 48 89 44 24 30 48 8D 44 24 6C 41 B9 01 00 00 00 33 D2 C7 44 24 28 05 00 00 00 48 89 44 24 20 48 FF C7 FF 15 ?? ?? ?? ?? 44 8B E8 85 C0 0F 84 70 01 00 00 48 8B 44 24 48 48 8D 0D ?? ?? ?? ?? 4C 8D 4C 24 60 48 8B 0C C1 33 C0 48 8D 54 24 6C 48 89 44 24 20 48 8B 44 24 58 45 8B C5 48 8B 0C 08 FF 15 ?? ?? ?? ?? 85 C0 0F 84 2D 01 00 00 8B 44 24 40 8B DF 41 2B DE 03 D8 44 39 6C 24 60 0F 8C A5 04 00 00 45 33 ED 44 39 6C 24 64 74 58 48 8B 44 24 48 45 8D 45 01 C6 44 24 6C 0D 48 8D 0D ?? ?? ?? ?? 4C 89 6C 24 20 4C 8B 6C 24 58 48 8B 0C C1 4C 8D 4C 24 60 48 8D 54 24 6C 49 8B 4C 0D 00 FF 15 ?? ?? ?? ?? 85 C0 0F 84 C3 00 00 00 83 7C 24 60 01 0F 8C CF 00 00 00 FF 44 24 40 0F B7 4C 24 44 FF C3 EB 6F 0F B7 4C 24 44 EB 63 41 8D 44 24 FF 3C 01 77 19 0F B7 0F 33 C0 66 83 F9 0A 44 8B E8 66 89 4C 24 44 41 0F 94 C5 48 83 C7 02 41 8D 44 24 FF 3C 01 77 38 E8 ?? ?? ?? ?? 0F B7 4C 24 44 66 3B C1 75 74 83 C3 02 45 85 ED 74 21 B8 0D 00 00 00 8B C8 66 89 44 24 44 E8 ?? ?? ?? ?? 0F B7 4C 24 44 66 3B C1 75 51 FF C3 FF 44 24 40 4C 8B 6C 24 58 8B C7 41 2B C6 41 3B C7 73 49 33 C0 E9 D8 FD FF FF 8A 07 4C 8B 7C 24 48 4C 8D 25 ?? ?? ?? ?? 4B 8B 0C FC FF C3 49 8B FF 41 88 44 0D 4C 4B 8B 04 FC 41 C7 44 05 50 01 00 00 00 EB 1C FF 15 ?? ?? ?? ?? 8B F0 EB 0D FF 15 ?? ?? ?? ?? 8B F0 4C 8B 6C 24 58 48 8B 7C 24 48 8B 44 24 40 85 DB 0F 85 C4 03 00 00 33 DB 85 F6 0F 84 86 03 00 00 83 FE 05 0F 85 6C 03 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 30 E9 4D FC FF FF 48 8B 7C 24 48 EB 07 48 8B 7C 24 48 33 C0 4C 8D 0D ?? ?? ?? ?? 49 8B 0C F9 41 F6 44 0D 08 80 0F 84 E8 02 00 00 8B F0 45 84 E4 0F 85 D8 00 00 00 4D 8B E6 45 85 FF 0F 84 2A 03 00 00 BA 0D 00 00 00 EB 02 33 C0 44 8B 6C 24 40 48 8D BD 30 06 00 00 48 8B C8 41 8B C4 41 2B C6 41 3B C7 73 27 41 8A 04 24 49 FF C4 3C 0A 75 0B 88 17 41 FF C5 48 FF C7 48 FF C1 48 FF C1 88 07 48 FF C7 48 81 F9 FF 13 00 00 72 CE 48 8D 85 30 06 00 00 44 8B C7 44 89 6C 24 40 4C 8B 6C 24 58 44 2B C0 48 8B 44 24 48 49 8B 0C C1 33 C0 4C 8D 4C 24 50 49 8B 4C 0D 00 48 8D 95 30 06 00 00 48 89 44 24 20 FF 15 ?? ?? ?? ?? 85 C0 0F 84 E2 FE FF FF 03 5C 24 50 48 8D 85 30 06 00 00 48 2B F8 48 63 44 24 50 48 3B C7 0F 8C DD FE FF FF 41 8B C4 BA 0D 00 00 00 4C 8D 0D ?? ?? ?? ?? 41 2B C6 41 3B C7 0F 82 40 FF FF FF E9 BD FE FF FF 41 80 FC 02 4D 8B E6 0F 85 E0 00 00 00 45 85 FF 0F 84 48 02 00 00 BA 0D 00 00 00 EB 02 33 C0 44 8B 6C 24 40 48 8D BD 30 06 00 00 48 8B C8 41 8B C4 41 2B C6 41 3B C7 73 32 41 0F B7 04 24 49 83 C4 02 66 83 F8 0A 75 0F 66 89 17 41 83 C5 02 48 83 C7 02 48 83 C1 02 48 83 C1 02 66 89 07 48 83 C7 02 48 81 F9 FE 13 00 00 72 C3 48 8D 85 30 06 00 00 44 8B C7 44 89 6C 24 40 4C 8B 6C 24 58 44 2B C0 48 8B 44 24 48 49 8B 0C C1 33 C0 4C 8D 4C 24 50 49 8B 4C 0D 00 48 8D 95 30 06 00 00 48 89 44 24 20 FF 15 ?? ?? ?? ?? 85 C0 0F 84 F5 FD FF FF 03 5C 24 50 48 8D 85 30 06 00 00 48 2B F8 48 63 44 24 50 48 3B C7 0F 8C F0 FD FF FF 41 8B C4 BA 0D 00 00 00 4C 8D 0D ?? ?? ?? ?? 41 2B C6 41 3B C7 0F 82 35 FF FF FF E9 D0 FD FF FF 45 85 FF 0F 84 68 01 00 00 41 B8 0D 00 00 00 EB 02 33 C0 48 8D 4D 80 48 8B D0 41 8B C4 41 2B C6 41 3B C7 73 2F 41 0F B7 04 24 49 83 C4 02 66 83 F8 0A 75 0C 66 44 89 01 48 83 C1 02 48 83 C2 02 48 83 C2 02 66 89 01 48 83 C1 02 48 81 FA A8 06 00 00 72 C6 48 8D 45 80 33 FF 4C 8D 45 80 2B C8 48 89 7C 24 38 48 89 7C 24 30 8B C1 B9 E9 FD 00 00 C7 44 24 28 55 0D 00 00 99 2B C2 33 D2 D1 F8 44 8B C8 48 8D 85 30 06 00 00 48 89 44 24 20 FF 15 ?? ?? ?? ?? 44 8B E8 85 C0 0F 84 23 FD FF FF 48 63 C7 45 8B C5 48 8D 95 30 06 00 00 48 03 D0 48 8B 44 24 48 48 8D 0D ?? ?? ?? ?? 48 8B 0C C1 33 C0 4C 8D 4C 24 50 48 89 44 24 20 48 8B 44 24 58 44 2B C7 48 8B 0C 08 FF 15 ?? ?? ?? ?? 85 C0 74 0B 03 7C 24 50 44 3B EF 7F B5 EB 08 FF 15 ?? ?? ?? ?? 8B F0 44 3B EF 0F 8F CD FC FF FF 41 8B DC 41 B8 0D 00 00 00 41 2B DE 41 3B DF 0F 82 FE FE FF FF E9 B3 FC FF FF 49 8B 4C 0D 00 4C 8D 4C 24 50 45 8B C7 49 8B D6 48 89 44 24 20 FF 15 ?? ?? ?? ?? 85 C0 74 0B 8B 5C 24 50 8B C6 E9 97 FC FF FF FF 15 ?? ?? ?? ?? 8B F0 8B C3 E9 88 FC FF FF 4C 8B 6C 24 58 48 8B 7C 24 48 E9 79 FC FF FF 8B CE E8 ?? ?? ?? ?? E9 EC F8 FF FF 48 8B 7C 24 48 48 8D 05 ?? ?? ?? ?? 48 8B 04 F8 41 F6 44 05 08 40 74 0A 41 80 3E 1A 0F 84 A6 F8 FF FF E8 ?? ?? ?? ?? C7 00 1C 00 00 00 E8 ?? ?? ?? ?? 89 18 E9 B3 F8 FF FF 2B D8 8B C3 48 8B 8D 30 1A 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 98 1B 00 00 48 81 C4 40 1B 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "_difftime32"
		size = 43
		refs = "0019 _errno"
	strings:
		$1 = { 48 83 EC 28 85 D2 78 10 85 C9 78 0C 2B CA 66 0F 6E C1 F3 0F E6 C0 EB 0E E8 ?? ?? ?? ?? 0F 57 C0 C7 00 16 00 00 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "_finitef"
		size = 23
	strings:
		$1 = { F3 0F 11 44 24 08 8B 44 24 08 0F BA F0 1F 2D 00 00 80 7F C1 E8 1F C3 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "atan2"
		size = 1979
		refs = "010d ??_C@_05KNGEOGJB@atan2?$AA@ 0122 _handle_error 0151 ?pi@?1??atan2@@9@9 0161 __xmm@80000000000000008000000000000000 0177 ?piby2@?1??atan2@@9@9 0190 _set_statfp 01cf __real@4010000000000000 01d7 __real@c010000000000000 02ec __real@8000000000000000 041d ?three_piby4@?1??atan2@@9@9 043c ?piby4@?1??atan2@@9@9 0496 __real@3fb0000000000000 04a4 __real@4070000000000000 04b4 __ImageBase 04bc __real@3fe0000000000000 04cc ?atan_jby256_tail@?1??atan2@@9@9 04d6 ?atan_jby256_lead@?1??atan2@@9@9 0521 __real@3f70000000000000 05eb __real@3fd5555555550877 060c __real@3fc99992b9802d7d 0629 __real@3e45798ee2308c3a 06bb __real@3fbc718839b8c4eb 06d4 __real@3fb70c3192d751c2 06e5 __real@3fc2492482bd6be1 06f5 __real@3fc99999999643a3 0705 __real@3fd5555555555538 0730 ?piby2_head@?1??atan2@@9@9 0738 ?piby2_tail@?1??atan2@@9@9 0755 ?pi_head@?1??atan2@@9@9 075d ?pi_tail@?1??atan2@@9@9"
	strings:
		$1 = { 48 8B C4 48 89 58 18 55 56 57 41 54 41 55 41 56 41 57 48 81 EC A0 00 00 00 33 DB 0F 29 70 B8 0F 29 78 A8 F2 0F 11 8C 24 E0 00 00 00 4C 8B B4 24 E0 00 00 00 48 BA FF FF FF FF FF FF FF 7F 49 BA 00 00 00 00 00 00 F0 7F F2 0F 11 84 24 E0 00 00 00 4C 8B BC 24 E0 00 00 00 44 0F 29 40 98 44 0F 29 48 88 44 0F 29 54 24 50 41 BB FF 07 00 00 44 8B CB 44 8B C3 44 0F 28 C9 44 0F 28 C0 49 8B C6 49 8B CF 4D 8B E6 48 23 CA 48 23 C2 49 C1 EC 34 45 23 E3 48 BA 00 00 00 00 00 00 00 80 4D 8B EF 49 C1 ED 34 49 8B EE 49 8B F7 48 23 EA 48 23 F2 45 23 EB 48 85 C0 8B D3 41 8B FD 0F 94 C2 49 3B C2 41 0F 94 C1 49 3B CA 41 0F 94 C0 41 2B FC 44 89 8C 24 E8 00 00 00 44 89 84 24 E0 00 00 00 49 3B C2 76 47 49 B8 00 00 00 00 00 00 08 00 4D 0B C6 C7 44 24 40 02 00 00 00 F2 0F 11 44 24 38 F2 0F 11 4C 24 30 BA 10 00 00 00 48 8D 0D ?? ?? ?? ?? C7 44 24 28 21 00 00 00 44 8D 4A F1 89 5C 24 20 E8 ?? ?? ?? ?? E9 5C 06 00 00 49 3B CA 76 0F 49 B8 00 00 00 00 00 00 08 00 4D 0B C7 EB B2 48 85 C9 75 26 48 85 ED 0F 84 3A 06 00 00 F2 0F 10 35 ?? ?? ?? ?? 48 85 F6 0F 84 59 01 00 00 0F 57 35 ?? ?? ?? ?? E9 4D 01 00 00 85 D2 74 46 48 85 F6 74 17 F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? 0F 28 F0 E9 2D 01 00 00 B9 20 00 00 00 E8 ?? ?? ?? ?? 44 8B 84 24 E0 00 00 00 44 8B 8C 24 E8 00 00 00 49 BA 00 00 00 00 00 00 F0 7F 41 BB FF 07 00 00 B8 FD 03 00 00 44 3B E0 0F 8D DF 00 00 00 44 3B E8 0F 8D D6 00 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 48 B9 00 00 00 00 00 00 00 40 48 BA 00 00 00 00 00 00 10 40 4D 85 F2 75 36 4C 0B F2 4C 89 B4 24 E0 00 00 00 F2 0F 10 84 24 E0 00 00 00 48 85 ED 74 06 F2 0F 58 C1 EB 04 F2 0F 58 C2 F2 0F 11 84 24 E0 00 00 00 48 8B 84 24 E0 00 00 00 EB 04 49 8D 04 0E 4D 85 FA 75 36 4C 0B FA 4C 89 BC 24 E0 00 00 00 F2 0F 10 84 24 E0 00 00 00 48 85 F6 74 06 F2 0F 58 C1 EB 04 F2 0F 58 C2 F2 0F 11 84 24 E0 00 00 00 48 8B BC 24 E0 00 00 00 EB 04 49 8D 3C 0F 48 89 84 24 E0 00 00 00 48 C1 E8 34 F2 44 0F 10 8C 24 E0 00 00 00 48 89 BC 24 E0 00 00 00 48 C1 EF 34 41 23 FB 41 23 C3 F2 44 0F 10 84 24 E0 00 00 00 2B F8 83 FF 38 7E 23 48 85 F6 0F 85 C4 FE FF FF F2 0F 10 35 ?? ?? ?? ?? B9 20 00 00 00 E8 ?? ?? ?? ?? 0F 28 C6 E9 BE 04 00 00 83 FF E4 0F 8D 25 01 00 00 48 85 ED 0F 85 1C 01 00 00 81 FF CE FB FF FF 7D 1A 48 85 F6 74 0D F2 0F 10 35 ?? ?? ?? ?? E9 E2 00 00 00 0F 57 F6 E9 DA 00 00 00 81 FF 02 FC FF FF 0F 8D E0 00 00 00 48 B8 00 00 00 00 00 00 30 46 48 B9 00 00 00 00 00 00 00 80 48 89 84 24 E0 00 00 00 F2 0F 10 84 24 E0 00 00 00 F2 41 0F 59 C0 F2 41 0F 5E C1 F2 0F 11 84 24 E0 00 00 00 48 8B 84 24 E0 00 00 00 4C 8B C0 4C 23 C1 48 B9 FF FF FF FF FF FF FF 7F 48 23 C1 48 8B C8 48 C1 E9 34 41 23 CB 83 E9 64 85 C9 7E 19 48 63 D9 48 B9 FF FF FF FF FF FF 0F 80 48 23 C1 48 C1 E3 34 48 0B D8 EB 38 48 BA FF FF FF FF FF FF 1F 80 48 23 C2 48 BA 00 00 00 00 00 00 10 00 48 0B C2 BA 01 00 00 00 2B D1 83 FA 36 7F 12 8D 4A FF 48 D3 E8 48 8B D8 83 E0 01 48 D1 EB 48 03 D8 49 0B D8 48 89 9C 24 E0 00 00 00 F2 0F 10 B4 24 E0 00 00 00 49 85 DA 75 0A B9 30 00 00 00 E9 DB FE FF FF 0F 28 C6 E9 9E 03 00 00 F2 45 0F 5E C1 41 0F 28 C0 E9 90 03 00 00 83 FF C8 7D 09 48 85 ED 0F 85 48 FD FF FF 45 85 C0 74 48 45 85 C9 74 43 48 85 ED 74 1F 48 85 F6 74 0D F2 0F 10 05 ?? ?? ?? ?? E9 55 FD FF FF F2 0F 10 35 ?? ?? ?? ?? E9 84 FE FF FF 48 85 F6 74 0D F2 0F 10 05 ?? ?? ?? ?? E9 36 FD FF FF F2 0F 10 35 ?? ?? ?? ?? E9 65 FE FF FF 48 85 ED 74 08 44 0F 57 0D ?? ?? ?? ?? 48 85 F6 74 08 44 0F 57 05 ?? ?? ?? ?? 66 45 0F 2F C1 44 8B CB 41 0F 97 C1 45 85 C9 74 0C 41 0F 28 C1 45 0F 28 C8 44 0F 28 C0 41 0F 28 E8 F2 41 0F 5E E9 66 0F 2F 2D ?? ?? ?? ?? 0F 86 85 01 00 00 F2 0F 59 2D ?? ?? ?? ?? 41 BA FF 03 00 00 0F 57 F6 48 8D 05 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 2C D5 8D 4A F0 F2 0F 10 BC C8 ?? ?? ?? ?? F2 44 0F 10 94 C8 ?? ?? ?? ?? F2 44 0F 11 8C 24 E0 00 00 00 4C 8B 84 24 E0 00 00 00 8B C2 49 C1 E8 34 45 23 C3 45 2B C2 41 F7 D8 F2 48 0F 2A F0 41 8B C0 99 2B C2 D1 F8 48 63 C8 49 03 CA 48 C1 E1 34 48 89 8C 24 E0 00 00 00 41 8B C8 F2 0F 59 35 ?? ?? ?? ?? 2B C8 48 63 C1 F2 0F 10 AC 24 E0 00 00 00 49 03 C2 48 C1 E0 34 48 89 84 24 E0 00 00 00 F2 41 0F 59 E9 41 8B C0 99 2B C2 F2 0F 10 84 24 E0 00 00 00 D1 F8 48 63 C8 44 2B C0 F2 0F 59 E8 49 03 CA 49 63 C0 0F 28 CD 49 03 C2 48 C1 E1 34 48 89 8C 24 E0 00 00 00 48 C1 E0 34 F2 0F 10 A4 24 E0 00 00 00 48 89 84 24 E0 00 00 00 F2 41 0F 59 E0 F2 0F 10 84 24 E0 00 00 00 F2 0F 11 AC 24 E0 00 00 00 48 8B 84 24 E0 00 00 00 48 25 00 00 00 F8 48 89 84 24 E0 00 00 00 F2 0F 59 E0 0F 28 DC F2 0F 10 94 24 E0 00 00 00 F2 0F 5C CA 0F 28 C2 F2 0F 59 C6 F2 0F 59 CE F2 0F 59 F4 F2 0F 5C D8 F2 0F 5C D9 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 F5 F2 0F 5E DE 0F 28 D3 0F 28 EB F2 0F 58 EF F2 0F 59 D3 0F 28 C2 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5C C8 F2 0F 59 CA F2 0F 59 CB F2 0F 5C E9 E9 02 01 00 00 F2 0F 10 05 ?? ?? ?? ?? 45 0F 57 D2 66 0F 2F C5 0F 87 EC 00 00 00 F2 44 0F 11 8C 24 E0 00 00 00 48 B9 00 00 00 00 FF FF FF FF 41 0F 28 C9 48 8B 84 24 E0 00 00 00 48 23 C1 0F 28 E5 48 89 84 24 E0 00 00 00 F2 0F 59 E5 F2 0F 10 9C 24 E0 00 00 00 F2 0F 11 AC 24 E0 00 00 00 48 8B 84 24 E0 00 00 00 48 23 C1 48 89 84 24 E0 00 00 00 F2 0F 5C CB F2 0F 10 94 24 E0 00 00 00 F2 0F 59 CA 0F 28 C2 F2 0F 59 C3 F2 44 0F 5C C0 0F 28 C5 F2 44 0F 5C C1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C C2 F2 41 0F 59 C1 F2 44 0F 5C C0 0F 28 C4 F2 0F 59 05 ?? ?? ?? ?? F2 45 0F 5E C1 F2 0F 5C C8 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 CC F2 0F 5C C1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C4 F2 0F 5C C8 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 CC F2 0F 59 E5 F2 0F 5C C1 F2 0F 59 C4 F2 44 0F 5C C0 F2 44 0F 58 C5 41 0F 28 E8 45 85 C9 74 20 F2 0F 10 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 41 0F 5C C2 F2 0F 5C CD 44 0F 28 D0 0F 28 E9 48 85 ED 74 20 F2 0F 10 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 41 0F 5C C2 F2 0F 5C CD 44 0F 28 D0 0F 28 E9 F2 44 0F 58 D5 48 85 F6 74 08 44 0F 57 15 ?? ?? ?? ?? 41 0F 28 C2 4C 8D 9C 24 A0 00 00 00 49 8B 5B 50 41 0F 28 73 F0 41 0F 28 7B E0 45 0F 28 43 D0 45 0F 28 4B C0 45 0F 28 53 B0 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_115_2_0 {
	meta:
		name = "scaleDouble_1"
		size = 32
	strings:
		$1 = { 0F 28 C8 48 63 C2 48 05 FF 03 00 00 48 C1 E0 34 48 89 44 24 08 F2 0F 10 44 24 08 F2 0F 59 C1 C3 }
	condition:
		$1
}

rule file_115_3_0 {
	meta:
		name = "scaleDouble_2"
		size = 72
	strings:
		$1 = { 8B C2 44 8B C2 0F 28 D0 99 2B C2 BA FF 03 00 00 D1 F8 48 63 C8 44 2B C0 48 03 CA 49 63 C0 48 C1 E1 34 48 03 C2 48 89 4C 24 08 48 C1 E0 34 F2 0F 10 44 24 08 48 89 44 24 08 F2 0F 59 C2 F2 0F 10 4C 24 08 F2 0F 59 C1 C3 }
	condition:
		$1
}

rule file_115_4_0 {
	meta:
		name = "scaleDownDouble"
		size = 142
	strings:
		$1 = { 4C 8B D1 4C 8B C9 48 B8 00 00 00 00 00 00 00 80 4C 23 D0 48 B8 FF FF FF FF FF FF FF 7F 4C 23 C8 33 C0 49 8B C9 48 C1 E9 34 81 E1 FF 07 00 00 2B CA 85 C9 7E 19 48 63 C1 48 B9 FF FF FF FF FF FF 0F 80 4C 23 C9 48 C1 E0 34 49 0B C1 EB 39 48 BA FF FF FF FF FF FF 1F 80 4C 23 CA 48 BA 00 00 00 00 00 00 10 00 4C 0B CA BA 01 00 00 00 2B D1 83 FA 36 7F 13 8D 4A FF 49 D3 E9 49 8B C1 41 83 E1 01 48 D1 E8 49 03 C1 49 0B C2 49 89 00 C3 }
	condition:
		$1
}

rule file_115_5_0 {
	meta:
		name = "scaleUpDouble1024"
		size = 105
		refs = "003d __real@4010000000000000 0047 __real@c010000000000000"
	strings:
		$1 = { 48 B8 00 00 00 00 00 00 F0 7F 48 85 C8 75 49 49 B8 00 00 00 00 00 00 10 40 48 8B C1 49 0B C0 48 89 44 24 08 48 B8 00 00 00 00 00 00 00 80 F2 0F 10 44 24 08 48 85 C8 74 0A F2 0F 58 05 ?? ?? ?? ?? EB 08 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 08 48 8B 44 24 08 EB 0D 48 B8 00 00 00 00 00 00 00 40 48 03 C1 48 89 02 C3 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "remquol"
		size = 483
		refs = "002c _ldtest 0071 __xmm@80000000000000008000000000000000 00bb _ldunscale 00fb _ldscale 014b __real@3fe0000000000000 01c1 _fperrraise 01c9 _LNan_C"
	strings:
		$1 = { F2 0F 11 4C 24 10 F2 0F 11 44 24 08 55 53 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 48 48 8D 4D 48 0F 29 74 24 30 4D 8B F0 E8 ?? ?? ?? ?? 48 8D 4D 50 0F B7 F8 E8 ?? ?? ?? ?? 45 33 ED 4D 85 F6 74 03 45 89 2E 66 44 3B EF 0F 8E 44 01 00 00 66 44 3B E8 0F 8E 3A 01 00 00 F2 0F 10 45 50 0F 57 F6 BB 01 00 00 00 66 0F 2F F0 76 12 0F 57 05 ?? ?? ?? ?? 44 0F B7 FB F2 0F 11 45 50 EB 03 45 8B FD F2 0F 10 4D 48 66 0F 2F F1 76 1C 0F 57 0D ?? ?? ?? ?? 8B C3 44 0F B7 E3 66 41 2B C7 44 0F B7 F8 F2 0F 11 4D 48 EB 03 45 8B E5 48 8D 55 D8 48 8D 4D 60 F2 0F 11 45 D8 E8 ?? ?? ?? ?? 41 8B F5 F2 0F 10 45 48 F2 0F 11 45 D8 48 8D 55 D8 48 8D 4D 58 E8 ?? ?? ?? ?? 66 85 C0 74 59 0F BF 7D 58 0F BF 45 60 2B F8 78 4D F2 0F 10 45 50 48 8D 4D D8 8B D7 F2 0F 11 45 D8 E8 ?? ?? ?? ?? F2 0F 10 45 48 66 0F 2F 45 D8 73 06 2B FB 79 DB EB 1B F2 0F 5C 45 D8 48 63 C7 F2 0F 11 45 48 48 83 F8 20 73 08 8B CF 8B C3 D3 E0 03 F0 F2 0F 11 45 D8 85 FF 79 97 EB 05 F2 0F 10 45 48 66 0F 2F C6 76 2D F2 0F 10 4D 50 F2 0F 59 0D ?? ?? ?? ?? 66 0F 2F C1 76 06 66 0F 2F CE 77 0D 66 0F 2E C8 7A 0E 75 0C 40 84 F3 74 07 F2 0F 5C 45 50 03 F3 4D 85 F6 74 12 0F BA F6 1F 8B C6 F7 D8 66 45 85 FF 0F 45 F0 41 89 36 66 45 85 E4 74 41 0F 57 05 ?? ?? ?? ?? EB 38 66 83 FF 02 75 07 F2 0F 10 45 48 EB 2B 66 83 F8 02 75 07 F2 0F 10 45 50 EB 1E BB 01 00 00 00 66 3B FB 74 05 66 85 C0 75 DD 8B CB E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 0F 28 74 24 30 48 83 C4 48 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_937_0_0 {
	meta:
		name = "remquo"
		size = 483
		refs = "002c _dtest 0071 __xmm@80000000000000008000000000000000 00bb _dunscale 00fb _dscale 014b __real@3fe0000000000000 01c1 _fperrraise 01c9 _Nan_C"
	strings:
		$1 = { F2 0F 11 4C 24 10 F2 0F 11 44 24 08 55 53 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 48 48 8D 4D 48 0F 29 74 24 30 4D 8B F0 E8 ?? ?? ?? ?? 48 8D 4D 50 0F B7 F8 E8 ?? ?? ?? ?? 45 33 ED 4D 85 F6 74 03 45 89 2E 66 44 3B EF 0F 8E 44 01 00 00 66 44 3B E8 0F 8E 3A 01 00 00 F2 0F 10 45 50 0F 57 F6 BB 01 00 00 00 66 0F 2F F0 76 12 0F 57 05 ?? ?? ?? ?? 44 0F B7 FB F2 0F 11 45 50 EB 03 45 8B FD F2 0F 10 4D 48 66 0F 2F F1 76 1C 0F 57 0D ?? ?? ?? ?? 8B C3 44 0F B7 E3 66 41 2B C7 44 0F B7 F8 F2 0F 11 4D 48 EB 03 45 8B E5 48 8D 55 D8 48 8D 4D 60 F2 0F 11 45 D8 E8 ?? ?? ?? ?? 41 8B F5 F2 0F 10 45 48 F2 0F 11 45 D8 48 8D 55 D8 48 8D 4D 58 E8 ?? ?? ?? ?? 66 85 C0 74 59 0F BF 7D 58 0F BF 45 60 2B F8 78 4D F2 0F 10 45 50 48 8D 4D D8 8B D7 F2 0F 11 45 D8 E8 ?? ?? ?? ?? F2 0F 10 45 48 66 0F 2F 45 D8 73 06 2B FB 79 DB EB 1B F2 0F 5C 45 D8 48 63 C7 F2 0F 11 45 48 48 83 F8 20 73 08 8B CF 8B C3 D3 E0 03 F0 F2 0F 11 45 D8 85 FF 79 97 EB 05 F2 0F 10 45 48 66 0F 2F C6 76 2D F2 0F 10 4D 50 F2 0F 59 0D ?? ?? ?? ?? 66 0F 2F C1 76 06 66 0F 2F CE 77 0D 66 0F 2E C8 7A 0E 75 0C 40 84 F3 74 07 F2 0F 5C 45 50 03 F3 4D 85 F6 74 12 0F BA F6 1F 8B C6 F7 D8 66 45 85 FF 0F 45 F0 41 89 36 66 45 85 E4 74 41 0F 57 05 ?? ?? ?? ?? EB 38 66 83 FF 02 75 07 F2 0F 10 45 48 EB 2B 66 83 F8 02 75 07 F2 0F 10 45 50 EB 1E BB 01 00 00 00 66 3B FB 74 05 66 85 C0 75 DD 8B CB E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 0F 28 74 24 30 48 83 C4 48 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_118_4_0 {
	meta:
		name = "__check_float_string"
		size = 150
		refs = "002b _calloc_crt 0050 memcpy 006c _recalloc_crt"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 49 8B F1 49 8B F8 48 8B DA 48 3B 0A 75 64 4D 39 08 75 3D 48 8B 0B BA 02 00 00 00 E8 ?? ?? ?? ?? 48 89 07 48 85 C0 75 04 33 C0 EB 4B 48 8B 44 24 50 48 8B D6 C7 00 01 00 00 00 4C 8B 03 48 8B 0F E8 ?? ?? ?? ?? 48 8B 03 48 03 C0 48 89 03 EB 22 48 8B 12 48 8B 0F 41 B8 02 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 C2 48 89 07 48 8B 0B 48 03 C9 48 89 0B B8 01 00 00 00 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_118_5_0 {
	meta:
		name = "_cprinput_l"
		size = 3717
		refs = "0022 __security_cookie 0066 _errno 0071 _invalid_parameter_noinfo 0082 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 00b0 isspace 00cb _getche_nolock 00e5 _ungetch_nolock 0156 isdigit 046f __check_float_string 061b free 0641 __security_check_cookie 0736 _cfltcvt_tab 073e __imp_DecodePointer 0817 memset 0a7c isleadbyte 0ab7 _mbtowc_l 0c14 isxdigit"
	strings:
		$1 = { 48 89 5C 24 10 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 A0 FE FF FF 48 81 EC 60 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 50 01 00 00 48 8D 75 F0 4C 89 45 98 4C 8B E9 48 89 74 24 68 33 F6 48 C7 45 90 5E 01 00 00 89 74 24 74 48 89 74 24 60 66 89 74 24 78 89 74 24 38 48 89 75 A8 48 85 C9 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 B9 05 00 00 48 8D 4D B0 E8 ?? ?? ?? ?? 41 8A 45 00 8B DE 40 88 74 24 3C 44 8B E6 89 74 24 34 89 5C 24 54 84 C0 0F 84 7F 05 00 00 41 83 CF FF 41 8D 5F 02 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 74 4C 44 2B E3 EB 05 BB 01 00 00 00 44 03 E3 44 89 64 24 34 E8 ?? ?? ?? ?? 8B D8 41 3B C7 74 13 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 75 DB 8B CB E8 ?? ?? ?? ?? BB 01 00 00 00 4C 03 EB 41 0F B6 4D 00 E8 ?? ?? ?? ?? 85 C0 75 EF E9 3A 0D 00 00 41 80 7D 00 25 0F 85 F2 0C 00 00 41 80 7D 01 25 0F 84 D5 0C 00 00 33 C0 89 74 24 4C 40 88 74 24 7C 89 74 24 48 8B FE 44 8B FE 88 44 24 70 44 8A F0 44 8B E0 40 88 74 24 44 40 88 74 24 3D 40 88 74 24 30 88 5C 24 31 4C 03 EB 41 0F B6 5D 00 8B CB E8 ?? ?? ?? ?? 33 D2 85 C0 74 58 47 8D 3C BF FF C7 45 8D 7F E8 46 8D 3C 7B BB 01 00 00 00 8A 4C 24 30 40 84 F6 74 CF 89 7C 24 50 8B 7C 24 38 44 89 64 24 58 44 8A 64 24 7C 44 89 7C 24 40 84 C9 0F 85 07 01 00 00 48 8B 45 98 48 89 45 A8 48 83 C0 08 48 89 45 98 48 8B 40 F8 48 89 45 80 E9 EE 00 00 00 83 FB 2A 0F 84 CD 00 00 00 83 FB 46 74 A8 83 FB 49 74 65 83 FB 4C 74 52 83 FB 4E 74 99 83 FB 68 74 3C 83 FB 6C 74 0F 83 FB 77 BB 01 00 00 00 74 25 E9 98 00 00 00 41 80 7D 01 6C BB 01 00 00 00 75 10 49 FF C5 44 03 E3 48 89 54 24 60 E9 69 FF FF FF 00 5C 24 31 44 02 F3 E9 5D FF FF FF FE 4C 24 31 41 FE CE E9 4C FF FF FF BB 01 00 00 00 00 5C 24 31 E9 43 FF FF FF 41 8A 45 01 3C 36 75 13 49 8D 4D 02 80 39 34 75 0A 4C 8B E9 BB 01 00 00 00 EB B2 3C 33 75 11 49 8D 4D 02 80 39 32 75 08 4C 8B E9 E9 0E FF FF FF 2C 58 3C 20 77 13 0F B6 C0 48 B9 01 10 82 00 01 00 00 00 48 0F A3 C1 72 CB BB 01 00 00 00 48 89 54 24 60 44 03 E3 40 02 F3 E9 E5 FE FF FF 8A 4C 24 30 BB 01 00 00 00 02 CB 88 4C 24 30 E9 D5 FE FF FF 48 89 55 80 8A DA 45 84 F6 75 1B 41 8A 45 00 2C 43 24 EF F6 D8 B8 01 00 00 00 45 1A F6 41 80 E6 FE 44 02 F0 EB 05 B8 01 00 00 00 45 0F B6 7D 00 41 83 CF 20 44 89 7D A0 41 83 FF 6E 74 5D 41 83 FF 63 74 39 41 83 FF 7B 74 33 8B 74 24 34 41 BF 01 00 00 00 41 03 F7 E8 ?? ?? ?? ?? 8B F8 89 44 24 38 83 F8 FF 74 0C 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 75 E1 44 8B 7D A0 89 74 24 34 EB 0F 01 44 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 38 83 FF FF 0F 84 D1 02 00 00 8A 4C 24 30 33 D2 8B 44 24 50 8B 74 24 40 85 C0 74 08 85 F6 0F 84 FE 0A 00 00 41 83 FF 6F 0F 8F 20 04 00 00 0F 84 10 08 00 00 41 83 FF 63 0F 84 ED 03 00 00 41 83 FF 64 0F 84 FC 07 00 00 0F 8E 2E 04 00 00 41 83 FF 67 7E 56 41 83 FF 69 74 31 41 83 FF 6E 0F 85 18 04 00 00 44 8B 64 24 34 33 F6 41 8B C4 84 C9 0F 84 17 0A 00 00 41 83 CF FF BB 01 00 00 00 00 5C 24 3C 4C 03 EB E9 86 0A 00 00 41 BF 64 00 00 00 41 BC 01 00 00 00 83 FF 2D 0F 85 14 05 00 00 44 88 64 24 3D E9 0F 05 00 00 48 8B DA 83 FF 2D 75 0F 48 8B 44 24 68 40 88 38 8D 47 D4 8B D8 EB 08 83 FF 2B 75 1E 8D 47 D6 44 8B 64 24 34 2B F0 44 03 E0 E8 ?? ?? ?? ?? 8B F8 89 44 24 38 8B 44 24 50 EB 05 44 8B 64 24 34 85 C0 41 BF FF FF FF FF 40 0F B6 CF 41 0F 44 F7 89 74 24 40 E8 ?? ?? ?? ?? BA 01 00 00 00 85 C0 74 56 8B C6 2B F2 89 74 24 40 85 C0 74 4A 48 8B 44 24 68 01 54 24 48 4C 8D 4D F0 40 88 3C 03 48 03 DA 48 8D 44 24 74 48 8D 55 90 4C 8D 44 24 68 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 8D 01 00 00 41 FF C4 E8 ?? ?? ?? ?? 8B F8 89 44 24 38 0F B6 C8 EB 9C 48 8B 45 B0 44 8B 74 24 40 48 8B 88 F0 00 00 00 48 8B 01 40 8A 30 40 3A F7 0F 85 B7 00 00 00 41 8B C6 44 2B F2 85 C0 0F 84 A9 00 00 00 44 03 E2 E8 ?? ?? ?? ?? 4C 8D 4D F0 8B F8 89 44 24 38 48 8B 44 24 68 40 88 34 03 48 8D 44 24 74 48 FF C3 4C 8D 44 24 68 48 8D 55 90 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 33 F6 85 C0 0F 84 0C 01 00 00 40 0F B6 CF EB 57 41 8B C6 B9 01 00 00 00 44 2B F1 85 C0 74 51 48 8B 44 24 68 01 4C 24 48 4C 8D 4D F0 40 88 3C 03 48 03 D9 48 8D 44 24 74 4C 8D 44 24 68 48 8D 55 90 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 C0 00 00 00 41 FF C4 E8 ?? ?? ?? ?? 8B F8 89 44 24 38 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 75 A0 8B 74 24 48 85 F6 0F 84 7D 01 00 00 8D 47 BB BA 01 00 00 00 A9 DF FF FF FF 0F 85 6F 01 00 00 41 8B C6 44 2B F2 85 C0 0F 84 61 01 00 00 48 8B 44 24 68 4C 8D 4D F0 4C 8D 44 24 68 C6 04 03 65 48 03 DA 48 8D 44 24 74 48 8D 55 90 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 74 48 41 FF C4 E8 ?? ?? ?? ?? 8B F8 89 44 24 38 83 F8 2D 0F 85 89 00 00 00 48 8B 44 24 68 4C 8D 4D F0 4C 8D 44 24 68 40 88 3C 03 48 8D 44 24 74 48 FF C3 48 8D 55 90 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 33 C9 85 C0 75 5F 33 F6 B8 01 00 00 00 39 44 24 74 75 0A 48 8B 4C 24 68 E8 ?? ?? ?? ?? 8B 5C 24 54 40 38 75 C8 74 0B 48 8B 4D C0 83 A1 C8 00 00 00 FD 8B C3 48 8B 8D 50 01 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 A8 02 00 00 48 81 C4 60 02 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 83 F8 2B 75 24 33 C9 41 8B C6 BA 01 00 00 00 44 2B F2 85 C0 75 05 44 8B F1 EB 0E 44 03 E2 E8 ?? ?? ?? ?? 8B F8 89 44 24 38 40 0F B6 CF E8 ?? ?? ?? ?? 85 C0 74 57 41 8B C6 BA 01 00 00 00 44 2B F2 85 C0 74 4D 48 8B 44 24 68 03 F2 4C 8D 4D F0 40 88 3C 03 48 03 DA 48 8D 44 24 74 48 8D 55 90 4C 8D 44 24 68 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 2E FF FF FF 41 FF C4 E8 ?? ?? ?? ?? 8B F8 89 44 24 38 0F B6 C8 EB A0 BA 01 00 00 00 44 2B E2 44 89 64 24 34 41 3B FF 74 0C 8B CF E8 ?? ?? ?? ?? BA 01 00 00 00 33 C0 85 F6 0F 84 F3 FE FF FF 33 F6 40 38 74 24 30 0F 85 85 FC FF FF 48 8B 74 24 68 01 54 24 54 88 04 33 0F BE 5C 24 31 48 8B 0D ?? ?? ?? ?? 2B DA FF 15 ?? ?? ?? ?? 48 8B 55 80 4C 8D 4D B0 4C 8B C6 8B CB FF D0 33 F6 E9 4F FC FF FF 41 BB 01 00 00 00 85 C0 75 08 44 89 5C 24 50 41 03 F3 45 84 F6 0F 8E 5A 02 00 00 45 8A F3 E9 57 02 00 00 41 83 FF 70 0F 84 D8 03 00 00 41 83 FF 73 0F 84 27 02 00 00 41 83 FF 75 0F 84 D8 03 00 00 41 83 FF 78 0F 84 1B FC FF FF 41 83 FF 7B 74 32 41 0F B6 45 00 3B C7 0F 85 99 06 00 00 44 8B 64 24 34 41 83 CF FF 33 F6 44 00 7C 24 3C 84 C9 0F 85 D9 FB FF FF 4C 8B 45 A8 4C 89 45 98 E9 CC FB FF FF 8B 44 24 70 45 84 F6 0F B6 C0 89 44 24 70 44 8B F0 B8 01 00 00 00 44 0F 4F F0 4C 03 E8 41 80 7D 00 5E 44 89 74 24 70 75 08 49 FF C5 C6 44 24 44 FF 33 D2 48 8D 4D D0 44 8D 42 20 E8 ?? ?? ?? ?? 41 80 7D 00 5D 41 BB 01 00 00 00 75 0A 41 B4 5D 4D 03 EB C6 45 DB 20 41 8A 45 00 3C 5D 0F 84 92 00 00 00 45 33 F6 4D 03 EB 3C 2D 75 5A 45 84 E4 74 55 41 8A 4D 00 80 F9 5D 74 4C 4D 03 EB 44 3A E1 73 05 44 8A C9 EB 06 45 8A CC 44 8A E1 45 3A E1 73 27 45 0F B6 D4 41 0F B6 CC 4D 8B C2 41 8B D3 83 E1 07 49 C1 E8 03 45 02 E3 D2 E2 4D 03 D3 42 08 54 05 D0 45 3A E1 72 DD 45 0F B6 C1 41 0F B6 C1 45 8A E6 EB 0A 44 8A E0 44 0F B6 C0 0F B6 C0 83 E0 07 49 C1 E8 03 41 8B D3 8A C8 41 8A 45 00 D2 E2 42 08 54 05 D0 3C 5D 0F 85 76 FF FF FF 44 8B 74 24 70 33 C0 41 38 45 00 0F 84 2C FD FF FF E9 F1 00 00 00 83 FF 2B 75 10 41 2B F4 89 74 24 40 75 56 85 C0 74 52 41 8A DC 44 8B 74 24 34 83 FF 30 0F 85 90 02 00 00 45 03 F4 44 89 74 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 38 83 C0 A8 A8 DF 74 60 44 89 64 24 48 41 83 FF 78 74 36 33 C0 39 44 24 50 74 0C 41 2B F4 89 74 24 40 75 03 41 02 DC 41 BF 6F 00 00 00 EB 69 44 8B 74 24 34 45 03 F4 44 89 74 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 38 EB 9C 45 2B F4 44 89 74 24 34 83 FF FF 74 07 8B CF E8 ?? ?? ?? ?? BF 30 00 00 00 89 7C 24 38 EB 30 45 03 F4 44 89 74 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 38 33 C0 39 44 24 50 74 0F 83 EE 02 89 74 24 40 41 3B F4 7D 03 41 02 DC 41 BF 78 00 00 00 45 8B E6 E9 E3 01 00 00 0F B6 44 24 70 45 84 F6 41 BB 01 00 00 00 41 0F 4F C3 44 8A F0 EB 05 44 8B 74 24 70 44 8B 64 24 34 48 8B 5D 80 45 2B E3 44 89 64 24 34 83 FF FF 74 0D 8B CF E8 ?? ?? ?? ?? 41 BB 01 00 00 00 33 C9 39 4C 24 50 74 0D 8B C6 41 2B F3 85 C0 0F 84 11 01 00 00 45 03 E3 44 89 64 24 34 E8 ?? ?? ?? ?? 48 63 F8 89 7C 24 38 41 83 FF 63 74 42 41 83 FF 73 75 11 8D 47 F7 83 F8 04 0F 86 C5 00 00 00 83 FF 20 75 2B 41 83 FF 7B 0F 85 B6 00 00 00 48 8B C7 8B D7 48 C1 F8 03 83 E2 07 0F BE 4C 05 D0 0F BE 44 24 44 33 C8 0F A3 D1 0F 83 95 00 00 00 33 C9 38 4C 24 30 75 7F 45 84 F6 74 61 40 0F B6 CF 40 88 7D 88 E8 ?? ?? ?? ?? 85 C0 74 10 41 FF C4 44 89 64 24 34 E8 ?? ?? ?? ?? 88 45 89 B8 3F 00 00 00 4C 8D 4D B0 48 8D 55 88 66 89 44 24 78 48 8B 45 B0 48 8D 4C 24 78 4C 63 80 D4 00 00 00 E8 ?? ?? ?? ?? 48 8B 4D 80 0F B7 44 24 78 66 89 01 48 83 C1 02 48 89 4D 80 E9 1B FF FF FF 48 8B 45 80 41 BB 01 00 00 00 40 88 38 49 03 C3 48 89 45 80 E9 0A FF FF FF 41 BB 01 00 00 00 49 03 DB E9 FC FE FF FF 41 BB 01 00 00 00 45 2B E3 44 89 64 24 34 83 FF FF 74 0D 8B CF E8 ?? ?? ?? ?? 41 BB 01 00 00 00 48 8B 45 80 33 F6 48 3B D8 0F 84 E0 FA FF FF 40 38 74 24 30 0F 85 6E F8 FF FF 44 01 5C 24 54 41 83 FF 63 0F 84 5F F8 FF FF 41 83 CF FF 45 84 F6 74 08 66 89 30 E9 52 F8 FF FF 40 88 30 E9 4A F8 FF FF B9 01 00 00 00 48 89 54 24 60 01 4C 24 58 88 4C 24 31 EB 05 B9 01 00 00 00 83 FF 2D 75 06 88 4C 24 3D EB 05 83 FF 2B 75 0E 2B F1 89 74 24 40 75 5C 85 C0 74 58 8A D9 44 8B 64 24 34 33 F6 39 74 24 58 0F 84 0E 01 00 00 48 8B 74 24 60 84 DB 0F 85 FD 00 00 00 44 8B 74 24 40 33 DB 41 8D 47 90 A9 F7 FF FF FF 74 49 40 0F B6 CF E8 ?? ?? ?? ?? 85 C0 0F 84 AA 00 00 00 41 83 FF 6F 75 29 83 FF 38 0F 8D 9B 00 00 00 48 C1 E6 03 EB 5B 44 8B 64 24 34 44 03 E1 44 89 64 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 38 EB 95 48 8D 34 B6 48 03 F6 EB 38 40 0F B6 F7 8B CE E8 ?? ?? ?? ?? 85 C0 74 63 48 C1 64 24 60 04 8B CE 40 0F BE DF E8 ?? ?? ?? ?? 48 8B 74 24 60 8B FB 83 E7 DF 83 EF 07 85 C0 0F 45 FB 33 DB 89 7C 24 38 8D 47 D0 BA 01 00 00 00 01 54 24 48 48 63 C8 48 03 F1 48 89 74 24 60 39 5C 24 50 74 05 44 2B F2 74 31 44 03 E2 44 89 64 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 38 E9 3A FF FF FF 41 FF CC 44 89 64 24 34 83 FF FF 74 07 8B CF E8 ?? ?? ?? ?? 48 8B 74 24 60 38 5C 24 3D 0F 84 ED 00 00 00 48 F7 DE 48 89 74 24 60 E9 E0 00 00 00 33 DB EB E5 8B 74 24 4C 84 DB 0F 85 12 01 00 00 44 8B 74 24 40 33 DB 41 8D 47 90 A9 F7 FF FF FF 74 29 40 0F B6 CF E8 ?? ?? ?? ?? 85 C0 0F 84 89 00 00 00 41 83 FF 6F 75 0A 83 FF 38 7D 7E C1 E6 03 EB 44 8D 04 B6 8D 34 00 EB 3C 40 0F B6 F7 8B CE E8 ?? ?? ?? ?? 85 C0 74 62 8B 44 24 4C 8B CE 40 0F BE DF C1 E0 04 89 44 24 4C E8 ?? ?? ?? ?? 8B 74 24 4C 8B FB 83 E7 DF 83 EF 07 85 C0 0F 45 FB 33 DB 89 7C 24 38 83 C6 D0 B8 01 00 00 00 01 44 24 48 03 F7 89 74 24 4C 39 5C 24 50 74 05 44 2B F0 74 30 44 03 E0 44 89 64 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 38 E9 5B FF FF FF 41 FF CC 44 89 64 24 34 83 FF FF 74 07 8B CF E8 ?? ?? ?? ?? 8B 74 24 4C 38 5C 24 3D 74 06 F7 DE 89 74 24 4C 8B 44 24 48 41 83 FF 46 BE 00 00 00 00 0F 44 C6 85 C0 0F 84 63 F8 FF FF 40 38 74 24 30 0F 85 F1 F5 FF FF FF 44 24 54 8B 44 24 4C 48 8B 4D 80 39 74 24 58 74 11 48 8B 44 24 60 48 89 01 E9 D2 F5 FF FF 33 DB EB AE 41 83 CF FF 40 38 74 24 31 74 07 89 01 E9 C0 F5 FF FF 66 89 01 E9 B8 F5 FF FF 41 80 7D 00 25 75 0B 49 8D 45 01 80 38 25 4C 0F 44 E8 44 03 E3 44 89 64 24 34 E8 ?? ?? ?? ?? 8B F8 89 44 24 38 41 0F B6 45 00 4C 03 EB 3B C7 75 50 40 0F B6 CF E8 ?? ?? ?? ?? 85 C0 74 11 E8 ?? ?? ?? ?? 41 0F B6 4D 00 4C 03 EB 3B C8 75 26 41 8A 45 00 84 C0 0F 84 C0 F7 FF FF E9 5D F2 FF FF 83 FF FF 0F 84 B0 F7 FF FF 8B CF E8 ?? ?? ?? ?? E9 A4 F7 FF FF 41 3B C7 74 07 8B C8 E8 ?? ?? ?? ?? 41 3B FF 0F 84 91 F7 FF FF 8B CF E8 ?? ?? ?? ?? E9 85 F7 FF FF }
	condition:
		$1
}

rule file_118_6_0 {
	meta:
		name = "_cscanf"
		size = 39
		refs = "001e _cprinput_l"
		altNames = "_cwscanf"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1081_3_0 {
	meta:
		name = "_cprintf"
		size = 39
		refs = "001e _vcprintf_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_631_3_0 {
	meta:
		name = "_cprintf_p"
		size = 39
		refs = "001e _vcprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_425_3_0 {
	meta:
		name = "_cprintf_s"
		size = 39
		refs = "001e _vcprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1252_6_0 {
	meta:
		name = "_cscanf_s"
		size = 39
		refs = "001e _cprinput_s_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_709_3_0 {
	meta:
		name = "_cwprintf"
		size = 39
		refs = "001e _vcwprintf_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_324_3_0 {
	meta:
		name = "_cwprintf_p"
		size = 39
		refs = "001e _vcwprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_162_3_0 {
	meta:
		name = "_cwprintf_s"
		size = 39
		refs = "001e _vcwprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_596_6_0 {
	meta:
		name = "_cwscanf_s"
		size = 39
		refs = "001e _cprinput_s_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_939_2_0 {
	meta:
		name = "_printf_p"
		size = 39
		refs = "001e _vprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_733_1_0 {
	meta:
		name = "_wprintf_p"
		size = 39
		refs = "001e _vwprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_939_8_0 {
	meta:
		name = "printf_s"
		size = 39
		refs = "001e _vprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_733_6_0 {
	meta:
		name = "wprintf_s"
		size = 39
		refs = "001e _vwprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 48 08 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 10 33 D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_118_7_0 {
	meta:
		name = "_cscanf_l"
		size = 33
		refs = "0018 _cprinput_l"
		altNames = "_cwscanf_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1081_4_0 {
	meta:
		name = "_cprintf_l"
		size = 33
		refs = "0018 _vcprintf_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_631_4_0 {
	meta:
		name = "_cprintf_p_l"
		size = 33
		refs = "0018 _vcprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_425_4_0 {
	meta:
		name = "_cprintf_s_l"
		size = 33
		refs = "0018 _vcprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1252_7_0 {
	meta:
		name = "_cscanf_s_l"
		size = 33
		refs = "0018 _cprinput_s_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_709_4_0 {
	meta:
		name = "_cwprintf_l"
		size = 33
		refs = "0018 _vcwprintf_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_324_4_0 {
	meta:
		name = "_cwprintf_p_l"
		size = 33
		refs = "0018 _vcwprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_162_4_0 {
	meta:
		name = "_cwprintf_s_l"
		size = 33
		refs = "0018 _vcwprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_596_7_0 {
	meta:
		name = "_cwscanf_s_l"
		size = 33
		refs = "0018 _cprinput_s_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_939_1_0 {
	meta:
		name = "_printf_l"
		size = 33
		refs = "0018 _vprintf_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_939_3_0 {
	meta:
		name = "_printf_p_l"
		size = 33
		refs = "0018 _vprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_939_4_0 {
	meta:
		name = "_printf_s_l"
		size = 33
		refs = "0018 _vprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_722_1_0 {
	meta:
		name = "_scprintf_l"
		size = 33
		refs = "0018 _vscprintf_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_722_3_0 {
	meta:
		name = "_scprintf_p_l"
		size = 33
		refs = "0018 _vscprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_297_2_0 {
	meta:
		name = "_scwprintf_l"
		size = 33
		refs = "0018 _vscwprintf_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_297_4_0 {
	meta:
		name = "_scwprintf_p_l"
		size = 33
		refs = "0018 _vscwprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_733_0_0 {
	meta:
		name = "_wprintf_l"
		size = 33
		refs = "0018 _vwprintf_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_733_2_0 {
	meta:
		name = "_wprintf_p_l"
		size = 33
		refs = "0018 _vwprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_733_3_0 {
	meta:
		name = "_wprintf_s_l"
		size = 33
		refs = "0018 _vwprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 40 18 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_118_8_0 {
	meta:
		name = "_hextodec"
		size = 38
		refs = "000d isdigit"
	strings:
		$1 = { 40 53 48 83 EC 20 0F BE D9 0F B6 C9 E8 ?? ?? ?? ?? 8B CB 83 E1 DF 83 E9 07 85 C0 0F 45 CB 8B C1 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_118_10_0 {
	meta:
		name = "_un_inc"
		size = 19
		refs = "000a _ungetch_nolock"
	strings:
		$1 = { 48 83 EC 28 83 F9 FF 74 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_904_8_0 {
	meta:
		name = "_un_inc"
		size = 19
		refs = "000a _ungetc_nolock"
	strings:
		$1 = { 48 83 EC 28 83 F9 FF 74 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_118_11_0 {
	meta:
		name = "_whiteout"
		size = 52
		refs = "0010 _getche_nolock 001f isspace"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 FF 07 E8 ?? ?? ?? ?? 8B D8 83 F8 FF 74 0C 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 75 E6 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "__avx_cos4"
		size = 2192
		refs = "000a __common_dcos_reduction_data 007f __common_dcos_data 023a __common_dcos_cout_rare 0244 __common_dcos_data_ha 029b _2il0floatpacket_267 02db _2il0floatpacket_268 0331 _2il0floatpacket_269 05ac _2il0floatpacket_270 05ce _2il0floatpacket_272 05d6 _2il0floatpacket_273 05e5 _2il0floatpacket_271 0611 _2il0floatpacket_274 0636 _2il0floatpacket_276 066c _2il0floatpacket_275 06d3 _2il0floatpacket_280 06e6 _2il0floatpacket_277 06ef _2il0floatpacket_278 06f8 _2il0floatpacket_279 0755 _2il0floatpacket_281 0763 _2il0floatpacket_282"
	strings:
		$1 = { 48 81 EC B8 02 00 00 4C 8D 15 ?? ?? ?? ?? C5 7C 11 BC 24 90 02 00 00 45 33 DB C5 7C 11 B4 24 70 02 00 00 C5 7C 11 AC 24 50 02 00 00 C5 7C 11 A4 24 30 02 00 00 C5 7C 11 9C 24 10 02 00 00 C5 7C 11 94 24 F0 01 00 00 C5 7C 11 8C 24 D0 01 00 00 C5 7C 11 84 24 B0 01 00 00 C5 FC 11 BC 24 90 01 00 00 C5 FC 11 B4 24 70 01 00 00 4C 89 AC 24 B0 02 00 00 4C 8D AC 24 0F 01 00 00 C5 FD 58 25 ?? ?? ?? ?? 49 83 E5 C0 C5 DD 54 2D ?? ?? ?? ?? C5 D5 C2 0D ?? ?? ?? ?? 1E C4 E3 7D 19 CA 01 C5 F0 C6 DA DD C5 F8 50 C3 85 C0 0F 85 91 01 00 00 C5 FD 10 1D ?? ?? ?? ?? C5 DD 59 25 ?? ?? ?? ?? C5 DD 58 F3 C5 CD 5C EB C5 55 5C 3D ?? ?? ?? ?? C5 05 59 15 ?? ?? ?? ?? C5 05 59 25 ?? ?? ?? ?? C5 05 59 35 ?? ?? ?? ?? C5 85 59 1D ?? ?? ?? ?? C4 41 7D 5C DA C4 41 25 5C EC C4 C1 15 5C CE C5 F5 5C CB C5 F5 59 D9 C5 E5 59 25 ?? ?? ?? ?? C5 DD 58 2D ?? ?? ?? ?? C5 C1 73 F6 3F C4 C3 7D 19 F0 01 C5 D5 59 F3 C4 C1 31 73 F0 3F C4 C3 45 18 D1 01 C5 CD 58 3D ?? ?? ?? ?? C5 45 59 C3 C5 3D 58 0D ?? ?? ?? ?? C5 35 59 D3 C5 2D 58 1D ?? ?? ?? ?? C5 25 59 E3 C5 1D 58 2D ?? ?? ?? ?? C5 15 59 F3 C5 0D 58 3D ?? ?? ?? ?? C5 85 59 E3 C5 DD 59 E9 C5 D5 58 C9 C5 F5 57 CA 45 85 DB 75 6E C5 FC 10 B4 24 70 01 00 00 C5 FC 10 BC 24 90 01 00 00 C5 7C 10 84 24 B0 01 00 00 C5 7C 10 8C 24 D0 01 00 00 C5 7C 10 94 24 F0 01 00 00 C5 7C 10 9C 24 10 02 00 00 C5 7C 10 A4 24 30 02 00 00 C5 7C 10 AC 24 50 02 00 00 C5 7C 10 B4 24 70 02 00 00 C5 7C 10 BC 24 90 02 00 00 4C 8B AC 24 B0 02 00 00 C5 FD 28 C1 48 81 C4 B8 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 84 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 41 8B F3 0F A3 DE 72 1C FF C3 83 FB 20 7C F4 48 8B 5C 24 28 48 8B 74 24 20 C4 C1 7D 10 4D 40 E9 52 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB D0 C5 FD 10 25 ?? ?? ?? ?? BA 00 00 F0 7F C4 C1 7D 11 45 00 C5 F9 6E CA C5 79 70 C1 11 C5 5D 54 DD C5 25 C2 CC 00 C4 43 7D 19 CF 01 C4 41 30 C6 EF DD C4 41 78 50 DD C5 B9 DB F8 C4 C3 7D 19 C5 01 C5 A9 73 D7 34 C4 C1 39 DB D5 C5 E1 73 D2 34 C5 F9 7E D9 C5 79 7E D0 C5 7A 6F 05 ?? ?? ?? ?? C5 F8 11 44 24 20 C5 B9 DB C0 C4 E3 79 16 DA 02 8D 0C 49 C4 43 79 16 D0 02 44 8D 0C 40 C1 E1 03 41 C1 E1 03 8D 04 52 C1 E0 03 47 8D 04 40 41 C1 E0 03 C4 21 F9 6E 1C 11 C5 FA 6F 15 ?? ?? ?? ?? C4 21 21 16 14 10 C4 A1 F9 6E 7C 11 10 C5 79 D4 DA C4 C1 39 DB C5 C4 01 F9 6E 24 11 C4 81 F9 6E 74 11 08 C4 A1 41 16 5C 10 10 C5 F9 D4 FA C5 78 11 6C 24 30 C4 01 19 16 34 10 C4 01 49 16 4C 10 08 C4 01 F9 6E 7C 11 10 C4 C1 19 73 D1 20 C5 7A 6F 2D ?? ?? ?? ?? C4 A1 F9 6E 6C 11 08 C4 C1 31 DB F5 C5 79 11 74 24 40 C4 C1 31 73 D3 20 C4 81 01 16 4C 10 10 C4 41 09 DB FD C4 41 29 DB F5 C4 41 21 DB C5 C4 41 41 DB DD C5 E9 73 D1 20 C4 A1 51 16 64 10 08 4C 8D 15 ?? ?? ?? ?? C4 C1 71 DB CD C5 7A 7F 74 24 70 C4 C1 59 DB C5 C4 41 21 F4 F6 C5 D1 73 D4 20 C5 79 11 54 24 50 C5 A9 73 D7 20 C5 FA 7F 84 24 A0 00 00 00 C5 D9 73 D3 20 C5 A1 F4 F8 C4 C1 61 DB DD C5 B1 F4 C1 C5 B1 F4 CA C5 B9 F4 D2 C5 FA 7F AC 24 90 00 00 00 C5 E9 73 D2 20 C5 7A 7F B4 24 C0 00 00 00 41 B8 00 00 00 80 C5 7A 7F 7C 24 60 C5 F1 D4 CA C5 21 F4 F5 C5 B9 F4 EE C4 41 39 F4 FF C5 B1 F4 F6 C5 7A 7F BC 24 B0 00 00 00 C5 81 73 D0 20 C4 C1 51 DB C5 C5 D1 73 D5 20 C5 F9 D4 C1 C5 81 D4 D0 C5 A9 F4 C3 C5 81 73 D0 20 C4 C1 41 DB DD C5 A9 F4 C4 C5 C1 73 D7 20 C5 A1 F4 E4 C5 D9 73 D4 20 C5 7A 7F A4 24 80 00 00 00 C4 41 39 F4 E4 C5 F9 D4 C4 C5 E1 D4 C8 C5 C9 D4 C5 C5 81 D4 E1 C4 41 19 DB FD C5 F1 73 D2 20 C5 01 D4 F8 C4 41 71 D4 FF C5 A9 F4 8C 24 A0 00 00 00 C5 F1 D4 EF C5 B1 F4 8C 24 80 00 00 00 C5 31 F4 4C 24 60 C4 C1 09 DB F5 C5 E1 73 D4 20 C5 C9 D4 C5 C5 A9 F4 AC 24 90 00 00 00 C5 29 F4 54 24 70 C5 E1 D4 F8 C4 C1 19 73 D4 20 C4 C1 49 73 D7 20 C5 FA 6F 9C 24 B0 00 00 00 C4 C1 09 73 D6 20 C4 C1 71 D4 CC C4 41 51 D4 F6 C4 C1 61 DB C5 C5 E1 73 D3 20 C5 F9 D4 C1 C5 31 D4 CB C5 C9 D4 F0 C5 FA 6F 84 24 C0 00 00 00 C5 99 73 D7 20 C5 F9 10 6C 24 40 C4 C1 79 DB CD C4 C1 71 D4 CE C5 89 73 D5 20 C5 F9 73 D0 20 C4 41 39 F4 C6 C4 C1 01 73 F7 20 C5 99 D4 C9 C5 29 D4 D0 C4 41 39 DB C5 C5 99 73 D6 20 C4 41 39 D4 C1 C5 F9 10 6C 24 50 C5 B1 73 D1 20 C4 41 19 D4 E0 C5 B9 73 D5 20 C4 C1 09 73 F4 20 C4 41 21 F4 D8 C4 C1 79 6E C0 C4 41 21 DB C5 C4 C1 49 DB F5 C4 41 39 D4 E2 C5 89 D4 F6 C4 41 31 D4 CC C4 C1 61 73 F1 20 C4 C1 71 DB CD C4 C1 69 DB D5 C5 C1 73 F7 20 C4 41 59 DB ED C5 B1 73 D6 0C C5 F9 70 E0 11 C5 61 D4 C1 C5 01 D4 D2 C4 C1 41 D4 D5 C5 D9 DB 7C 24 20 C4 C1 61 73 D0 0C C5 7A 6F 25 ?? ?? ?? ?? C5 D9 DB 4C 24 30 C4 41 41 EF FC C4 41 71 EF F4 C4 41 31 EB EF C4 41 61 EB DE C5 F8 10 1D ?? ?? ?? ?? C5 7A 6F 35 ?? ?? ?? ?? C4 C3 15 18 C3 01 C4 E2 7D 1A 2D ?? ?? ?? ?? C5 55 58 C8 C5 B5 5C E5 C4 C1 71 EF EE C5 7D 5C FC C4 C1 41 EF E6 C5 31 DB EB C4 43 7D 19 CC 01 C5 18 54 CB C5 FA 6F 1D ?? ?? ?? ?? C4 41 61 DB DA C5 61 DB F2 C4 C1 79 73 F3 1C C4 C1 21 73 F6 1C C5 79 EB E4 C5 A1 EB C5 C5 7A 6F 1D ?? ?? ?? ?? C5 79 7E EA C4 41 79 7E C9 C1 E2 05 C4 63 79 16 E8 02 41 C1 E1 05 C4 63 79 16 C9 02 C1 E0 05 C1 E1 05 C4 E3 1D 18 D8 01 C4 E3 5D 18 ED 01 C5 FA 6F 05 ?? ?? ?? ?? C5 65 5C E5 C5 F1 EF D8 C5 A1 DB CE C5 41 EF F0 C5 C1 73 F1 28 C4 C1 49 73 D2 18 C4 C1 21 DB C8 C5 C1 EB C6 C5 C1 73 F1 28 C5 B9 73 D2 18 C4 C1 41 EB D0 C4 C1 79 EB E6 C5 69 EB D3 C4 C3 5D 18 EA 01 C4 E3 0D 18 DB 01 C5 D5 5C F3 C5 85 58 C6 C5 05 5C F8 C4 41 4D 58 DF C4 C1 25 58 FC C4 62 7D 1A 25 ?? ?? ?? ?? C4 41 7D 54 FC C4 C1 7D 5C D7 C4 E2 7D 1A 0D ?? ?? ?? ?? C4 E2 7D 1A 25 ?? ?? ?? ?? C4 62 7D 1A 05 ?? ?? ?? ?? C5 5D 59 D2 C4 C1 3D 59 DF C5 F5 59 EF C5 BD 59 F2 C4 C1 5D 59 C7 C5 2D 58 DB C5 55 58 E6 C4 C1 25 58 E4 C4 21 F9 6E 1C 12 C4 21 21 16 2C 10 C5 FD 58 D4 C5 7D 5C F2 C4 C1 7D 10 45 00 C5 8D 58 F4 C4 81 F9 6E 24 11 C4 21 59 16 0C 11 C4 A1 F9 6E 64 12 10 C4 62 7D 1A 3D ?? ?? ?? ?? C4 C1 7D 54 CF C4 E2 7D 1A 3D ?? ?? ?? ?? C5 F5 C2 EF 1E C5 75 C2 C7 12 C5 3D 54 D0 C5 D5 54 DA C4 21 F9 6E 44 12 08 C5 AD 56 CB C4 81 F9 6E 5C 11 08 C4 21 39 16 54 10 08 C5 55 54 FE C4 A1 61 16 6C 11 08 C4 63 2D 18 D5 01 C4 41 75 59 DA C4 C3 15 18 D1 01 C4 01 F9 6E 6C 11 10 C4 21 59 16 4C 10 10 C4 A1 11 16 7C 11 10 C4 E3 35 18 FF 01 C5 6D 59 C9 C4 41 45 58 E3 C4 C1 35 58 E4 C4 C1 45 5C F4 C5 1D 5C F4 C4 41 4D 58 C3 C4 41 0D 58 E9 C4 41 15 58 E0 C4 41 6D 58 EA C5 75 59 C1 C5 BD 59 1D ?? ?? ?? ?? C5 3D 59 0D ?? ?? ?? ?? C5 E5 58 2D ?? ?? ?? ?? C4 C1 55 59 F0 C5 4D 59 D9 C5 F5 59 CF C4 C1 25 59 D5 C4 41 6D 58 D4 C5 B5 58 15 ?? ?? ?? ?? C4 C1 6D 59 D8 C5 E5 58 2D ?? ?? ?? ?? C4 81 F9 6E 5C 11 18 C4 41 55 59 C0 C4 A1 61 16 6C 11 18 C5 BD 59 F7 C4 41 4D 58 CA C5 95 5C F1 C4 A1 F9 6E 4C 12 18 C4 A1 71 16 54 10 18 C5 05 59 FE C4 E3 6D 18 FD 01 C5 85 58 CF C5 B5 58 D1 C5 DD 58 CA E9 F4 F8 FF FF 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "_fputwchar"
		size = 31
		refs = "000a __iob_func 001b fputwc"
		altNames = "putwchar"
	strings:
		$1 = { 40 53 48 83 EC 20 0F B7 D9 E8 ?? ?? ?? ?? 0F B7 CB 48 8D 50 30 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "_filelength"
		size = 263
		refs = "001a __doserrno 0022 _errno 003b _nhandle 0052 __pioinfo 006e __lock_fhandle 0087 _lseek_nolock 00d6 _unlock_fhandle 00f2 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 18 89 4C 24 08 56 57 41 56 48 83 EC 30 48 63 F9 83 FF FE 75 18 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 C5 00 00 00 85 C9 0F 88 A5 00 00 00 3B 3D ?? ?? ?? ?? 0F 83 99 00 00 00 48 8B C7 48 8B DF 48 C1 FB 05 4C 8D 35 ?? ?? ?? ?? 83 E0 1F 48 6B F0 58 49 8B 04 DE 0F BE 4C 30 08 83 E1 01 74 73 8B CF E8 ?? ?? ?? ?? 90 49 8B 04 DE F6 44 30 08 01 74 3B 33 D2 44 8D 42 01 8B CF E8 ?? ?? ?? ?? 8B F0 83 CB FF 3B C3 74 3B 33 D2 44 8D 43 03 8B CF E8 ?? ?? ?? ?? 8B D8 89 44 24 20 3B F0 74 28 45 33 C0 8B D6 8B CF E8 ?? ?? ?? ?? EB 1A E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 20 00 83 CB FF 89 5C 24 20 8B CF E8 ?? ?? ?? ?? 8B C3 EB 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 8B 5C 24 60 48 83 C4 30 41 5E 5F 5E C3 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "_Cbuild"
		size = 16
		altNames = "_LCbuild"
	strings:
		$1 = { F2 0F 11 C8 48 8B C1 66 0F 14 C2 F3 0F 7F 01 C3 }
	condition:
		$1
}

rule file_124_1_0 {
	meta:
		name = "cproj"
		size = 186
		refs = "0023 creal 003c cimag 004c _dtest 0079 _Zero_C 0080 __xmm@80000000000000008000000000000000 008d _Inf_C"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 18 57 48 83 EC 40 0F 10 02 48 8B F1 48 8D 48 D8 48 8B FA F3 0F 7F 40 D8 E8 ?? ?? ?? ?? 48 8D 4C 24 20 F2 0F 11 44 24 38 0F 10 07 F3 0F 7F 44 24 20 E8 ?? ?? ?? ?? 48 8D 4C 24 38 F2 0F 11 44 24 30 E8 ?? ?? ?? ?? 48 8D 4C 24 30 0F B7 D8 E8 ?? ?? ?? ?? 66 83 FB 01 74 06 66 83 F8 01 75 37 B8 00 80 00 00 66 85 44 24 36 74 11 F2 0F 10 0D ?? ?? ?? ?? 0F 57 0D ?? ?? ?? ?? EB 03 0F 57 C9 F2 0F 10 05 ?? ?? ?? ?? 48 8D 7C 24 20 66 0F 14 C1 66 0F 7F 44 24 20 0F 10 07 48 8B 5C 24 50 48 8B C6 F3 0F 7F 06 48 8B 74 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_183_1_0 {
	meta:
		name = "cprojl"
		size = 186
		refs = "0023 creall 003c cimagl 004c _ldtest 0079 _LZero_C 0080 __xmm@80000000000000008000000000000000 008d _LInf_C"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 18 57 48 83 EC 40 0F 10 02 48 8B F1 48 8D 48 D8 48 8B FA F3 0F 7F 40 D8 E8 ?? ?? ?? ?? 48 8D 4C 24 20 F2 0F 11 44 24 38 0F 10 07 F3 0F 7F 44 24 20 E8 ?? ?? ?? ?? 48 8D 4C 24 38 F2 0F 11 44 24 30 E8 ?? ?? ?? ?? 48 8D 4C 24 30 0F B7 D8 E8 ?? ?? ?? ?? 66 83 FB 01 74 06 66 83 F8 01 75 37 B8 00 80 00 00 66 85 44 24 36 74 11 F2 0F 10 0D ?? ?? ?? ?? 0F 57 0D ?? ?? ?? ?? EB 03 0F 57 C9 F2 0F 10 05 ?? ?? ?? ?? 48 8D 7C 24 20 66 0F 14 C1 66 0F 7F 44 24 20 0F 10 07 48 8B 5C 24 50 48 8B C6 F3 0F 7F 06 48 8B 74 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "fesetenv"
		size = 76
		refs = "0016 _setfpcontrolword 001e _setfpstatusword 0028 fegetenv"
	strings:
		$1 = { 40 53 48 83 EC 20 83 64 24 30 00 83 64 24 34 00 48 8B D9 8B 09 E8 ?? ?? ?? ?? 8B 4B 04 E8 ?? ?? ?? ?? 48 8D 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 30 39 03 75 0D 8B 44 24 34 39 43 04 75 04 33 C0 EB 05 B8 01 00 00 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_126_4_0 {
	meta:
		name = "__check_float_string"
		size = 153
		refs = "002b _calloc_crt 0053 memcpy 006f _recalloc_crt"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 49 8B F1 49 8B F8 48 8B DA 48 3B 0A 75 67 4D 39 08 75 40 48 8B 0B BA 04 00 00 00 E8 ?? ?? ?? ?? 48 89 07 48 85 C0 75 04 33 C0 EB 4E 48 8B 44 24 50 48 8B D6 C7 00 01 00 00 00 4C 8B 03 48 8B 0F 4D 03 C0 E8 ?? ?? ?? ?? 48 8B 03 48 03 C0 48 89 03 EB 22 48 8B 12 48 8B 0F 41 B8 04 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 BF 48 89 07 48 8B 0B 48 03 C9 48 89 0B B8 01 00 00 00 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_126_5_0 {
	meta:
		name = "_hextodec"
		size = 61
		refs = "001e isdigit"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 B8 00 FF 00 00 0F B7 F9 66 85 C8 75 0F 0F B7 D9 0F B6 CB E8 ?? ?? ?? ?? 85 C0 75 09 0F B7 DF 83 E3 DF 83 EB 07 0F B7 C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_126_8_0 {
	meta:
		name = "_un_inc"
		size = 24
		refs = "000f _ungetwc_nolock"
	strings:
		$1 = { 48 83 EC 28 B8 FF FF 00 00 66 3B C1 74 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_596_11_0 {
	meta:
		name = "_un_inc"
		size = 24
		refs = "000f _ungetwch_nolock"
	strings:
		$1 = { 48 83 EC 28 B8 FF FF 00 00 66 3B C1 74 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_126_9_0 {
	meta:
		name = "_whiteout"
		size = 80
		refs = "001b _fgetwc_nolock 0035 iswctype"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F2 48 8B F9 FF 07 48 8B CE E8 ?? ?? ?? ?? 0F B7 D8 B8 FF FF 00 00 66 3B D8 74 11 BA 08 00 00 00 0F B7 CB E8 ?? ?? ?? ?? 85 C0 75 D8 48 8B 74 24 38 0F B7 C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_126_10_0 {
	meta:
		name = "_winput_l"
		size = 4578
		refs = "0022 __security_cookie 007d _errno 0088 _invalid_parameter_noinfo 00a1 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 00e0 iswctype 00f9 _whiteout 010a _ungetwc_nolock 01b7 isdigit 038b _fgetwc_nolock 0516 __check_float_string 05d6 free 081f _malloc_crt 0844 wcstombs_s 085d _cfltcvt_tab 0868 __imp_DecodePointer 0974 memset 0d20 wctomb_s 0e74 isxdigit 119b __security_check_cookie 11c8 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 40 FD FF FF 48 81 EC C0 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 B0 02 00 00 45 33 ED 4C 8D 75 F0 4C 89 4D B0 41 8B C5 41 0F B7 FD 48 8B DA 48 89 54 24 60 48 8B F1 48 89 4C 24 70 89 45 A8 89 7C 24 3C 4C 89 75 88 48 C7 45 A0 5E 01 00 00 44 89 6D 80 4C 89 6C 24 68 4C 89 6C 24 78 4C 89 6D C0 48 85 D2 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 FC 10 00 00 48 85 C9 74 E3 48 8D 4D C8 49 8B D0 E8 ?? ?? ?? ?? 0F B7 03 44 88 6C 24 36 45 8B FD 44 89 6C 24 30 44 89 6C 24 44 45 8B F5 44 89 6C 24 38 66 85 C0 0F 84 B1 10 00 00 41 BE FF FF 00 00 41 BC 25 00 00 00 BA 08 00 00 00 0F B7 C8 E8 ?? ?? ?? ?? 85 C0 74 4F 48 8D 4C 24 44 41 FF CF 48 8B D6 44 89 7C 24 44 E8 ?? ?? ?? ?? 66 44 3B F0 74 0B 48 8B D6 0F B7 C8 E8 ?? ?? ?? ?? 48 83 C3 02 BA 08 00 00 00 0F B7 0B E8 ?? ?? ?? ?? 85 C0 75 EB 44 8B 7C 24 44 48 89 5C 24 60 44 89 7C 24 30 E9 BF 0F 00 00 4C 8B 54 24 60 66 45 3B 22 0F 85 67 0F 00 00 66 45 3B 62 02 0F 84 45 0F 00 00 45 33 DB 44 89 6D 90 45 0F B7 FB 45 8A E3 45 8D 4B 01 41 8B D3 44 89 7D B8 44 89 65 98 45 8A E9 44 89 5C 24 58 45 8B C3 44 89 5C 24 50 89 54 24 40 44 88 5C 24 54 44 88 5C 24 48 41 8A FB 41 8A F3 45 8A F3 45 8B E3 41 83 CF FF 49 83 C2 02 B8 00 FF 00 00 41 0F B7 1A 4C 89 54 24 60 66 85 D8 75 3B 0F B6 CB E8 ?? ?? ?? ?? 44 8B 44 24 50 8B 54 24 40 4C 8B 54 24 60 45 33 DB 45 8D 4B 01 85 C0 74 1A 8D 14 92 45 03 C1 8D 52 E8 44 89 44 24 50 8D 14 53 89 54 24 40 E9 D7 00 00 00 83 FB 2A 0F 84 CB 00 00 00 83 FB 46 0F 84 C5 00 00 00 83 FB 49 74 4E 83 FB 4C 74 44 83 FB 4E 0F 84 B2 00 00 00 83 FB 68 74 2E B9 6C 00 00 00 3B D9 74 0A 83 FB 77 74 1B E9 92 00 00 00 49 8D 42 02 66 39 08 75 0A 4C 8B D0 48 89 44 24 60 EB 32 45 02 E9 45 02 F1 EB 7F 45 02 EF 45 02 F7 EB 77 45 02 E9 EB 72 41 0F B7 42 02 66 83 F8 36 75 1C 49 8D 4A 04 66 83 39 34 75 12 4C 8B D1 48 89 4C 24 60 45 03 E1 4C 89 5C 24 78 EB 4B 66 83 F8 33 75 14 49 8D 4A 04 66 83 39 32 75 0A 4C 8B D1 48 89 4C 24 60 EB 31 66 83 E8 58 B9 20 00 00 00 66 3B C1 77 13 0F B7 C0 48 B9 01 10 82 00 01 00 00 00 48 0F A3 C1 72 BB 45 03 E1 4C 89 5C 24 78 41 02 F1 EB 03 41 02 F9 40 84 F6 0F 84 CE FE FF FF 44 8B 7D B8 40 88 7C 24 34 8B 7C 24 3C 8A 4C 24 34 44 88 6C 24 35 44 8B 6D 90 44 89 64 24 4C 44 8B 65 98 84 C9 75 1A 48 8B 45 B0 48 89 45 C0 48 83 C0 08 48 89 45 B0 48 8B 40 F8 48 89 45 90 EB 04 4C 89 5D 90 41 8A DB 45 84 F6 75 25 41 0F B7 02 41 B9 EF FF 00 00 66 83 E8 43 66 41 23 C1 41 B9 01 00 00 00 66 F7 D8 45 1A F6 41 80 E6 02 41 FE CE 41 0F B7 32 B8 6E 00 00 00 83 CE 20 3B F0 74 6D 83 FE 63 74 21 83 FE 7B 74 1C 48 8B 54 24 70 48 8D 4C 24 44 E8 ?? ?? ?? ?? 0F B7 F8 8B 44 24 44 89 44 24 30 EB 1C 8B 44 24 30 48 8B 4C 24 70 41 03 C1 89 44 24 30 89 44 24 44 E8 ?? ?? ?? ?? 0F B7 F8 B8 FF FF 00 00 89 7C 24 3C 66 3B C7 0F 84 BE 0D 00 00 8B 54 24 40 4C 8B 54 24 60 44 8B 44 24 50 8A 4C 24 34 45 33 DB 41 8D 43 6E 45 85 C0 74 08 85 D2 0F 84 42 0D 00 00 83 FE 6F 0F 8F DB 04 00 00 0F 84 10 0A 00 00 83 FE 63 0F 84 A7 04 00 00 83 FE 64 0F 84 FE 09 00 00 0F 8E E6 04 00 00 83 FE 67 7E 6C 83 FE 69 74 46 3B F0 0F 85 D4 04 00 00 44 8B 7C 24 30 45 8B EF 84 C9 0F 84 4A 0C 00 00 45 33 ED 41 BE FF FF 00 00 48 8B 5C 24 60 48 8B 74 24 70 B8 01 00 00 00 00 44 24 36 48 83 C3 02 44 8D 60 24 48 89 5C 24 60 E9 9E 0C 00 00 BE 64 00 00 00 B8 2D 00 00 00 44 8D 60 D4 66 3B C7 0F 85 1D 06 00 00 44 88 64 24 48 E9 1D 06 00 00 45 33 ED 41 8B F5 41 8D 4D 2D 8D 59 D4 66 3B CF 75 0B 48 8B 45 88 8B F3 66 89 08 EB 0A B8 2B 00 00 00 66 3B C7 75 2B 4C 8B 64 24 70 44 8B 74 24 40 44 8B 7C 24 30 49 8B CC 44 2B F3 44 03 FB E8 ?? ?? ?? ?? 44 8B 44 24 50 0F B7 F8 89 7C 24 3C EB 0F 44 8B 7C 24 30 44 8B 74 24 40 4C 8B 64 24 70 45 85 C0 B8 FF FF FF FF 44 0F 44 F0 EB 63 0F B7 C7 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 74 5E 41 8B C6 44 2B F3 85 C0 74 54 48 8B 4D 88 01 5C 24 58 40 0F BE C7 66 89 04 71 48 8D 45 80 48 03 F3 4C 8D 4D F0 4C 8D 45 88 48 8D 55 A0 48 8B CE 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 96 00 00 00 49 8B CC 44 03 FB E8 ?? ?? ?? ?? 0F B7 F8 89 7C 24 3C B8 00 FF 00 00 66 85 F8 74 93 48 8B 45 C8 BA 01 00 00 00 48 8B 88 F0 00 00 00 48 8B 41 58 0F B7 18 40 0F BE C7 8B CB 3B D8 0F 85 18 01 00 00 41 8B C6 44 2B F2 85 C0 0F 84 0A 01 00 00 49 8B CC 44 03 FA E8 ?? ?? ?? ?? 4C 8D 4D F0 4C 8D 45 88 0F B7 F8 48 8B 45 88 48 8D 55 A0 66 89 1C 70 48 8D 45 80 BB 01 00 00 00 48 03 F3 89 7C 24 3C 48 89 44 24 20 48 8B CE E8 ?? ?? ?? ?? 85 C0 0F 85 B6 00 00 00 44 8B 64 24 38 41 BE FF FF 00 00 48 8B 5C 24 68 BE 01 00 00 00 39 75 A8 75 08 48 8B CB E8 ?? ?? ?? ?? 39 75 80 75 09 48 8B 4D 88 E8 ?? ?? ?? ?? 66 44 3B F7 0F 85 85 0B 00 00 45 85 E4 0F 85 77 0B 00 00 8A 44 24 36 84 C0 0F 85 6B 0B 00 00 83 C8 FF E9 70 0B 00 00 0F B7 C7 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 74 5A 41 8B C6 44 2B F3 85 C0 74 50 48 8B 45 88 01 5C 24 58 4C 8D 4D F0 66 89 3C 70 48 8D 45 80 48 03 F3 4C 8D 45 88 48 8D 55 A0 48 8B CE 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 5C FF FF FF 49 8B CC 44 03 FB E8 ?? ?? ?? ?? 0F B7 F8 89 7C 24 3C B8 00 FF 00 00 66 85 F8 74 97 48 8B D3 8B 5C 24 58 85 DB 0F 84 31 01 00 00 8D 47 BB B9 DF FF 00 00 66 85 C1 0F 85 20 01 00 00 41 8B C6 44 2B F2 85 C0 0F 84 12 01 00 00 48 8B 45 88 B9 65 00 00 00 4C 8D 4D F0 66 89 0C 70 48 03 F2 48 8D 45 80 48 8D 55 A0 4C 8D 45 88 48 8B CE 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 DD FE FF FF 49 8B CC 41 FF C7 E8 ?? ?? ?? ?? B9 2D 00 00 00 0F B7 F8 89 7C 24 3C 66 3B C8 75 32 48 8B 45 88 4C 8D 4D F0 4C 8D 45 88 66 89 0C 70 48 8D 45 80 48 FF C6 48 8D 55 A0 48 8B CE 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 91 FE FF FF EB 0A B8 2B 00 00 00 66 3B C7 75 7B 41 8B C6 B9 01 00 00 00 44 2B F1 85 C0 75 05 45 8B F5 EB 67 44 03 F9 EB 53 0F B7 C7 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 74 5D 41 8B C6 B9 01 00 00 00 44 2B F1 85 C0 74 4E 48 8B 45 88 03 D9 4C 8D 4D F0 66 89 3C 70 48 03 F1 48 8D 45 80 4C 8D 45 88 48 8D 55 A0 48 8B CE 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 1C FE FF FF 41 FF C7 49 8B CC E8 ?? ?? ?? ?? 0F B7 F8 89 7C 24 3C B8 00 FF 00 00 66 85 F8 74 94 B8 01 00 00 00 41 BE FF FF 00 00 44 2B F8 44 89 7C 24 30 44 89 7C 24 44 66 44 3B F7 74 10 49 8B D4 0F B7 CF E8 ?? ?? ?? ?? B8 01 00 00 00 85 DB 0F 84 14 09 00 00 44 38 6C 24 34 0F 85 23 FC FF FF 44 8B 64 24 38 4C 8B 75 88 44 03 E0 48 8B 45 A0 66 45 89 2C 76 48 8D 1C 45 02 00 00 00 44 89 64 24 38 48 8B CB E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 0F 84 8E FD FF FF 48 8D 43 FF 4D 8B CE 4C 8B C3 48 8B D6 33 C9 48 89 44 24 20 E8 ?? ?? ?? ?? 83 F8 16 0F 84 7C 09 00 00 83 F8 22 0F 84 73 09 00 00 48 8B 0D ?? ?? ?? ?? 0F BE 5C 24 35 FF 15 ?? ?? ?? ?? 48 8B 55 90 4C 8D 4D C8 8D 4B FF 4C 8B C6 FF D0 48 8B CE E8 ?? ?? ?? ?? E9 8D FB FF FF B8 01 00 00 00 45 85 C0 75 0A 03 D0 89 44 24 50 89 54 24 40 45 84 F6 0F 8E 7F 03 00 00 44 8A E0 E9 77 03 00 00 83 FE 70 0F 84 1A 05 00 00 83 FE 73 0F 84 54 03 00 00 83 FE 75 0F 84 20 05 00 00 83 FE 78 0F 84 74 FB FF FF 83 FE 7B 74 31 41 BE FF FF 00 00 66 41 39 3A 0F 85 2B 08 00 00 FE 4C 24 36 44 8B 7C 24 30 45 33 ED 84 C9 0F 85 21 FB FF FF 4C 8B 4D C0 4C 89 4D B0 E9 14 FB FF FF 45 33 ED 45 84 F6 45 0F B6 E4 45 8D 75 01 41 8D 45 5E 45 0F 4F E6 49 83 C2 02 44 89 65 98 4C 89 54 24 60 66 41 3B 02 75 0E 49 83 C2 02 C6 44 24 54 FF 4C 89 54 24 60 48 8B 5C 24 68 48 85 DB 75 1F B9 00 20 00 00 E8 ?? ?? ?? ?? 48 8B D8 48 89 44 24 68 48 85 C0 0F 84 EE 07 00 00 44 89 75 A8 33 D2 41 B8 00 20 00 00 48 8B CB E8 ?? ?? ?? ?? 4C 8B 54 24 60 BA 5D 00 00 00 66 41 3B 12 75 0D 8D 42 C3 44 8B FA 49 83 C2 02 88 43 0B 41 0F B7 02 66 3B D0 0F 84 BF 00 00 00 41 BC 2D 00 00 00 49 83 C2 02 66 44 3B E0 75 7C 66 45 85 FF 74 76 41 0F B7 0A 66 3B D1 74 6D 49 83 C2 02 4C 89 54 24 60 66 44 3B F9 73 06 44 0F B7 C9 EB 08 45 0F B7 CF 44 0F B7 F9 41 BB 01 00 00 00 66 45 3B F9 73 2D 45 0F B7 D7 41 0F B7 CF 4D 8B C2 41 8B D3 83 E1 07 49 C1 E8 03 66 45 03 FB D2 E2 4D 03 D3 41 08 14 18 66 45 3B F9 72 DC 4C 8B 54 24 60 45 0F B7 C1 41 0F B7 C1 41 8B D3 45 0F B7 FD 41 BE 01 00 00 00 EB 0E 44 0F B7 F8 44 0F B7 C0 41 8B D6 0F B7 C0 83 E0 07 49 C1 E8 03 8A C8 D2 E2 41 08 14 18 41 0F B7 02 BA 5D 00 00 00 66 3B D0 0F 85 4B FF FF FF 44 8B 65 98 66 45 39 2A 0F 84 E7 06 00 00 4C 89 54 24 60 E9 B0 01 00 00 B8 2B 00 00 00 66 3B C7 75 11 41 2B D4 89 54 24 40 75 78 45 85 C0 74 73 41 8A DC 4C 8B 7C 24 70 44 8B 74 24 30 B8 30 00 00 00 66 3B C7 0F 85 B0 00 00 00 45 03 F4 49 8B CF 44 89 74 24 30 44 89 74 24 44 E8 ?? ?? ?? ?? 0F B7 F8 B9 DF FF 00 00 8D 47 A8 89 7C 24 3C 66 85 C1 0F 84 F9 00 00 00 44 89 64 24 58 83 FE 78 74 4C 44 8B 74 24 40 33 C9 39 4C 24 50 74 08 45 2B F4 75 03 41 02 DC 44 8B 64 24 4C BE 6F 00 00 00 EB 64 44 8B 74 24 30 4C 8B 7C 24 70 45 03 F4 49 8B CF 44 89 74 24 30 44 89 74 24 44 E8 ?? ?? ?? ?? 0F B7 F8 89 7C 24 3C E9 6F FF FF FF 45 2B F4 B8 FF FF 00 00 44 89 74 24 30 44 89 74 24 44 66 3B C7 74 0B 49 8B D7 0F B7 CF E8 ?? ?? ?? ?? B8 30 00 00 00 8B F8 89 44 24 3C 44 8B 64 24 4C 33 C9 44 8B 74 24 40 44 8B 7C 24 30 45 85 E4 0F 84 BF 03 00 00 84 DB 48 8B 5C 24 78 0F 85 97 03 00 00 8D 46 90 A9 F7 FF FF FF B8 00 FF 00 00 0F 84 D0 02 00 00 66 85 F8 0F 85 52 03 00 00 0F B7 C7 0F B6 C8 E8 ?? ?? ?? ?? 33 C9 85 C0 0F 84 3D 03 00 00 83 FE 6F 0F 85 A0 02 00 00 8D 41 38 66 3B C7 0F 86 28 03 00 00 48 C1 E3 03 E9 D6 02 00 00 45 03 F4 49 8B CF 44 89 74 24 30 44 89 74 24 44 E8 ?? ?? ?? ?? 33 C9 0F B7 F8 89 7C 24 3C 39 4C 24 50 74 13 8B 44 24 40 83 E8 02 89 44 24 40 41 3B C4 7D 03 41 02 DC 44 8B 64 24 4C BE 78 00 00 00 E9 4B FF FF FF 45 0F B6 E4 45 84 F6 41 B8 01 00 00 00 45 0F 4F E0 44 8B 7C 24 30 48 8B 5D 90 4C 8B 6C 24 70 41 FF CF B8 FF FF 00 00 44 89 7C 24 30 44 89 7C 24 44 66 3B C7 74 0B 49 8B D5 0F B7 CF E8 ?? ?? ?? ?? 44 8A 74 24 54 33 D2 39 54 24 50 74 14 8B 4C 24 40 8B C1 FF C9 89 4C 24 40 85 C0 0F 84 0C 01 00 00 41 FF C7 49 8B CD 44 89 7C 24 30 44 89 7C 24 44 E8 ?? ?? ?? ?? 0F B7 F8 B8 FF FF 00 00 89 7C 24 3C 66 3B C7 0F 84 B7 00 00 00 83 FE 63 74 44 83 FE 73 75 15 8D 47 F7 66 83 F8 04 0F 86 A0 00 00 00 8D 46 AD 66 3B F8 75 2A 83 FE 7B 0F 85 8F 00 00 00 48 8B 4C 24 68 0F B7 C7 0F B7 D7 48 C1 E8 03 83 E2 07 0F BE 0C 08 41 0F BE C6 33 C8 0F A3 D1 73 6E 33 D2 38 54 24 34 75 5D 45 84 E4 74 14 48 8B 4D 90 66 89 39 48 83 C1 02 48 89 4D 90 E9 52 FF FF FF 89 55 98 48 8B 55 90 48 8D 4D 98 44 0F B7 CF 41 B8 05 00 00 00 E8 ?? ?? ?? ?? 33 D2 85 C0 74 17 83 F8 16 0F 84 87 04 00 00 83 F8 22 0F 85 20 FF FF FF E9 79 04 00 00 48 63 45 98 48 01 45 90 E9 0E FF FF FF 48 83 C3 02 E9 05 FF FF FF B9 01 00 00 00 41 BE FF FF 00 00 44 2B F9 44 89 7C 24 30 44 89 7C 24 44 66 44 3B F7 74 18 49 8B D5 0F B7 CF E8 ?? ?? ?? ?? EB 06 41 BE FF FF 00 00 B9 01 00 00 00 48 8B 45 90 45 33 ED 48 3B D8 0F 84 65 03 00 00 44 38 6C 24 34 0F 85 74 F6 FF FF 01 4C 24 38 83 FE 63 0F 84 61 F6 FF FF 41 BE FF FF 00 00 45 84 E4 74 09 66 44 89 28 E9 53 F6 FF FF 44 88 28 E9 4B F6 FF FF 44 8B 64 24 4C B8 01 00 00 00 4C 89 5C 24 78 44 03 E0 88 44 24 35 EB 0A 44 8B 64 24 4C B8 01 00 00 00 B9 2D 00 00 00 66 3B CF 75 06 88 44 24 48 EB 0E B9 2B 00 00 00 66 3B CF 0F 85 4C FD FF FF 2B D0 89 54 24 40 75 11 45 85 C0 74 0C 8A D8 44 8B F2 33 C9 E9 3A FD FF FF 44 8B 7C 24 30 48 8B 4C 24 70 44 03 F8 44 89 7C 24 30 44 89 7C 24 44 E8 ?? ?? ?? ?? 44 8B 74 24 40 0F B7 F8 33 C9 89 7C 24 3C E9 10 FD FF FF 48 8D 1C 9B 48 03 DB EB 42 66 85 F8 0F 85 82 00 00 00 0F B7 C7 0F B6 D8 8B CB E8 ?? ?? ?? ?? 33 C9 85 C0 74 6F 48 C1 64 24 78 04 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 78 85 C0 75 10 B8 DF FF 00 00 66 23 F8 66 83 EF 07 89 7C 24 3C 0F B7 C7 B9 01 00 00 00 01 4C 24 58 83 E8 30 48 98 48 03 D8 33 C0 48 89 5C 24 78 39 44 24 50 74 05 44 2B F1 74 4C 44 03 F9 48 8B 4C 24 70 44 89 7C 24 30 44 89 7C 24 44 E8 ?? ?? ?? ?? 0F B7 F8 89 7C 24 3C E9 92 FC FF FF 41 FF CF B8 FF FF 00 00 44 89 7C 24 30 44 89 7C 24 44 66 3B C7 74 0D 48 8B 54 24 70 0F B7 CF E8 ?? ?? ?? ?? 48 8B 5C 24 78 45 33 DB 44 38 5C 24 48 0F 84 15 01 00 00 48 F7 DB 48 89 5C 24 78 E9 08 01 00 00 84 DB 0F 85 F3 00 00 00 8D 46 90 A9 F7 FF FF FF B8 00 FF 00 00 74 46 66 85 F8 0F 85 B7 00 00 00 0F B7 C7 0F B6 C8 E8 ?? ?? ?? ?? 33 C9 85 C0 0F 84 A2 00 00 00 83 FE 6F 75 12 8D 41 38 66 3B C7 0F 86 91 00 00 00 41 C1 E5 03 EB 48 42 8D 04 AD 00 00 00 00 41 03 C5 44 8D 2C 00 EB 37 66 85 F8 75 75 0F B7 C7 0F B6 D8 8B CB E8 ?? ?? ?? ?? 33 C9 85 C0 74 62 8B CB 41 C1 E5 04 E8 ?? ?? ?? ?? 85 C0 75 10 B8 DF FF 00 00 66 23 F8 66 83 EF 07 89 7C 24 3C 0F B7 C7 41 83 C5 D0 B9 01 00 00 00 01 4C 24 58 44 03 E8 33 C0 39 44 24 50 74 05 44 2B F1 74 47 44 03 F9 48 8B 4C 24 70 44 89 7C 24 30 44 89 7C 24 44 E8 ?? ?? ?? ?? 0F B7 F8 89 }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "_getdiskfree"
		size = 163
		refs = "0015 _errno 0020 _invalid_parameter_noinfo 003a memset 0071 __imp_GetDiskFreeSpaceA 007b __imp_GetLastError 008c _get_errno_from_oserr"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 30 48 8B FA 8B D9 48 85 D2 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 57 00 00 00 EB 6D 83 F9 1A 77 E4 33 D2 48 8B CF 44 8D 42 10 E8 ?? ?? ?? ?? 85 DB 75 04 33 C9 EB 18 80 C3 40 48 8D 4C 24 48 66 C7 44 24 49 3A 5C 88 5C 24 48 C6 44 24 4B 00 4C 8D 4F 04 4C 8D 47 0C 48 8D 57 08 48 89 7C 24 20 FF 15 ?? ?? ?? ?? 85 C0 75 1D FF 15 ?? ?? ?? ?? 8B F8 E8 ?? ?? ?? ?? 8B CF 48 8B D8 E8 ?? ?? ?? ?? 89 03 8B C7 EB 02 33 C0 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_128_4_0 {
	meta:
		name = "vscan_fn"
		size = 175
		refs = "0030 memset 003a _errno 0045 _invalid_parameter_noinfo 0057 wcslen"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 57 48 83 EC 50 48 83 60 C8 00 48 8B DA 33 D2 49 8B F8 48 8B E9 44 8D 42 28 48 8D 48 D0 49 8B F1 E8 ?? ?? ?? ?? 48 85 DB 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4C 48 85 FF 74 E6 48 8B CB E8 ?? ?? ?? ?? C7 44 24 38 49 00 00 00 48 89 5C 24 30 48 89 5C 24 20 48 3D FF FF FF 3F 76 0A C7 44 24 28 FF FF FF 7F EB 06 03 C0 89 44 24 28 4C 8B 8C 24 80 00 00 00 48 8D 4C 24 20 4C 8B C6 48 8B D7 FF D5 48 8B 5C 24 60 48 8B 6C 24 68 48 8B 74 24 70 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "_loaddll"
		size = 46
		refs = "000a __crtIsPackagedApp 002a __imp_LoadLibraryExA"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 85 C0 74 08 33 C0 48 83 C4 20 5B C3 45 33 C0 33 D2 48 8B CB 48 83 C4 20 5B 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_129_1_0 {
	meta:
		name = "_unloaddll"
		size = 32
		refs = "0006 __imp_FreeLibrary 0015 __imp_GetLastError"
	strings:
		$1 = { 48 83 EC 28 FF 15 ?? ?? ?? ?? 85 C0 75 0B 48 83 C4 28 48 FF 25 ?? ?? ?? ?? 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_130_4_0 {
	meta:
		name = "_mbsicoll_l"
		size = 201
		refs = "0021 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0030 _errno 003b _invalid_parameter_noinfo 0056 _stricoll_l 0089 __crtCompareStringA"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 60 48 8B F9 48 8B DA 48 8D 4C 24 40 49 8B D0 49 8B F0 E8 ?? ?? ?? ?? 48 85 FF 74 05 48 85 DB 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 5B 48 8B 54 24 48 83 7A 08 00 75 10 4C 8B C6 48 8B D3 48 8B CF E8 ?? ?? ?? ?? EB 4A 8B 42 04 48 8B 92 20 02 00 00 48 8D 4C 24 40 89 44 24 38 83 C8 FF 4C 8B CF 89 44 24 30 41 B8 01 10 00 00 48 89 5C 24 28 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 FF FF FF 7F EB 03 83 C0 FE 80 7C 24 58 00 74 0C 48 8B 4C 24 50 83 A1 C8 00 00 00 FD 48 8B 5C 24 70 48 8B 74 24 78 48 83 C4 60 5F C3 }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "_copyfinddata64"
		size = 149
		refs = "0020 __copy_to_char 0042 strcpy_s 0050 free 0090 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 30 48 83 64 24 48 00 48 8B D9 48 8B FA 48 8D 4A 28 48 8D 54 24 48 E8 ?? ?? ?? ?? 85 C0 75 0B 48 8B 5C 24 40 48 83 C4 30 5F C3 4C 8B 44 24 48 48 8D 4B 28 BA 04 01 00 00 E8 ?? ?? ?? ?? 85 C0 75 35 48 8B 4C 24 48 E8 ?? ?? ?? ?? 8B 07 89 03 48 8B 47 08 48 89 43 08 48 8B 47 10 48 89 43 10 48 8B 47 18 48 89 43 18 48 8B 47 20 48 89 43 20 B8 01 00 00 00 EB A9 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_131_1_0 {
	meta:
		name = "_findfirst64"
		size = 147
		refs = "0010 __security_cookie 002e __copy_path_to_wide_string 0047 _wfindfirst64 0054 free 0067 _copyfinddata64 007e __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 57 48 81 EC 70 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 60 02 00 00 48 83 64 24 20 00 48 8B FA 48 8D 54 24 20 E8 ?? ?? ?? ?? 85 C0 75 06 48 83 C8 FF EB 36 48 8B 4C 24 20 48 8D 54 24 30 E8 ?? ?? ?? ?? 48 8B 4C 24 20 48 8B D8 E8 ?? ?? ?? ?? 48 83 FB FF 74 11 48 8D 54 24 30 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 C7 48 8B C3 48 8B 8C 24 60 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 90 02 00 00 48 81 C4 70 02 00 00 5F C3 }
	condition:
		$1
}

rule file_1060_2_0 {
	meta:
		name = "_findfirst64i32"
		size = 147
		refs = "0010 __security_cookie 002e __copy_path_to_wide_string 0047 _wfindfirst64i32 0054 free 0067 _copyfinddata64i32 007e __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 57 48 81 EC 70 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 60 02 00 00 48 83 64 24 20 00 48 8B FA 48 8D 54 24 20 E8 ?? ?? ?? ?? 85 C0 75 06 48 83 C8 FF EB 36 48 8B 4C 24 20 48 8D 54 24 30 E8 ?? ?? ?? ?? 48 8B 4C 24 20 48 8B D8 E8 ?? ?? ?? ?? 48 83 FB FF 74 11 48 8D 54 24 30 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 C7 48 8B C3 48 8B 8C 24 60 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 90 02 00 00 48 81 C4 70 02 00 00 5F C3 }
	condition:
		$1
}

rule file_131_2_0 {
	meta:
		name = "_findnext64"
		size = 108
		refs = "0010 __security_cookie 0028 _wfindnext64 003c _copyfinddata64 0057 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 57 48 81 EC 60 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 50 02 00 00 48 8B FA 48 8D 54 24 20 E8 ?? ?? ?? ?? 8B D8 83 F8 FF 74 16 48 8D 54 24 20 48 8B CF E8 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 02 8B C3 48 8B 8C 24 50 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 80 02 00 00 48 81 C4 60 02 00 00 5F C3 }
	condition:
		$1
}

rule file_1060_3_0 {
	meta:
		name = "_findnext64i32"
		size = 108
		refs = "0010 __security_cookie 0028 _wfindnext64i32 003c _copyfinddata64i32 0057 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 57 48 81 EC 60 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 50 02 00 00 48 8B FA 48 8D 54 24 20 E8 ?? ?? ?? ?? 8B D8 83 F8 FF 74 16 48 8D 54 24 20 48 8B CF E8 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 02 8B C3 48 8B 8C 24 50 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 80 02 00 00 48 81 C4 60 02 00 00 5F C3 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "__crtGetEnvironmentStringsA"
		size = 244
		refs = "001b __imp_GetEnvironmentStringsW 0072 __imp_WideCharToMultiByte 0081 _malloc_crt 00b9 free 00c5 __imp_FreeEnvironmentStringsW"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 40 FF 15 ?? ?? ?? ?? 45 33 F6 48 8B F8 48 85 C0 0F 84 A9 00 00 00 48 8B D8 66 44 39 30 74 14 48 83 C3 02 66 44 39 33 75 F6 48 83 C3 02 66 44 39 33 75 EC 4C 89 74 24 38 48 2B D8 4C 89 74 24 30 48 D1 FB 4C 8B C0 33 D2 44 8D 4B 01 33 C9 44 89 74 24 28 4C 89 74 24 20 FF 15 ?? ?? ?? ?? 48 63 E8 85 C0 74 51 48 8B CD E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 74 41 4C 89 74 24 38 4C 89 74 24 30 44 8D 4B 01 4C 8B C7 33 D2 33 C9 89 6C 24 28 48 89 44 24 20 FF 15 ?? ?? ?? ?? 85 C0 75 0B 48 8B CE E8 ?? ?? ?? ?? 49 8B F6 48 8B CF FF 15 ?? ?? ?? ?? 48 8B C6 EB 0B 48 8B CF FF 15 ?? ?? ?? ?? 33 C0 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 8B 7C 24 68 48 83 C4 40 41 5E C3 }
	condition:
		$1
}

rule file_133_1_0 {
	meta:
		name = "_heap_init"
		size = 32
		refs = "0006 __imp_GetProcessHeap 0012 _crtheap"
	strings:
		$1 = { 48 83 EC 28 FF 15 ?? ?? ?? ?? 33 C9 48 85 C0 48 89 05 ?? ?? ?? ?? 0F 95 C1 8B C1 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_134_1_0 {
	meta:
		name = "ax8"
		size = 17
	strings:
		$1 = { 41 0F B6 00 48 03 42 78 48 89 01 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_134_2_0 {
	meta:
		name = "ax32"
		size = 16
	strings:
		$1 = { 41 8B 00 48 03 42 78 48 89 01 B8 04 00 00 00 C3 }
	condition:
		$1
}

rule file_134_4_0 {
	meta:
		name = "cx8"
		size = 20
	strings:
		$1 = { 41 0F B6 00 48 03 82 80 00 00 00 48 89 01 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_134_5_0 {
	meta:
		name = "cx32"
		size = 19
	strings:
		$1 = { 41 8B 00 48 03 82 80 00 00 00 48 89 01 B8 04 00 00 00 C3 }
	condition:
		$1
}

rule file_134_7_0 {
	meta:
		name = "dx8"
		size = 20
	strings:
		$1 = { 41 0F B6 00 48 03 82 88 00 00 00 48 89 01 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_134_8_0 {
	meta:
		name = "dx32"
		size = 19
	strings:
		$1 = { 41 8B 00 48 03 82 88 00 00 00 48 89 01 B8 04 00 00 00 C3 }
	condition:
		$1
}

rule file_134_10_0 {
	meta:
		name = "bx8"
		size = 20
	strings:
		$1 = { 41 0F B6 00 48 03 82 90 00 00 00 48 89 01 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_134_11_0 {
	meta:
		name = "bx32"
		size = 19
	strings:
		$1 = { 41 8B 00 48 03 82 90 00 00 00 48 89 01 B8 04 00 00 00 C3 }
	condition:
		$1
}

rule file_134_12_0 {
	meta:
		name = "sib0"
		size = 656
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 45 0F B6 18 0F B6 44 24 28 48 8B D9 45 8B D3 41 8B CB BF 01 00 00 00 41 C1 EA 03 C1 E9 06 49 8B F0 41 83 E2 07 D3 E7 41 03 C2 48 83 F8 04 75 08 45 33 C0 E9 F9 00 00 00 83 E0 0F 48 83 F8 08 0F 87 87 00 00 00 74 7C 48 85 C0 74 71 48 FF C8 74 63 48 FF C8 74 55 48 FF C8 74 44 48 FF C8 74 33 48 FF C8 74 22 48 FF C8 74 11 48 FF C8 75 C1 4C 8B 82 B0 00 00 00 E9 B6 00 00 00 4C 8B 82 A8 00 00 00 E9 AA 00 00 00 4C 8B 82 A0 00 00 00 E9 9E 00 00 00 4C 8B 82 98 00 00 00 E9 92 00 00 00 4C 8B 82 90 00 00 00 E9 86 00 00 00 4C 8B 82 88 00 00 00 EB 7D 4C 8B 82 80 00 00 00 EB 74 4C 8B 42 78 EB 6E 4C 8B 82 B8 00 00 00 EB 65 48 83 E8 09 74 58 48 FF C8 74 4A 48 FF C8 74 3C 48 FF C8 74 2E 48 FF C8 74 20 48 FF C8 74 12 48 FF C8 0F 85 3C FF FF FF 4C 8B 82 F0 00 00 00 EB 34 4C 8B 82 E8 00 00 00 EB 2B 4C 8B 82 E0 00 00 00 EB 22 4C 8B 82 D8 00 00 00 EB 19 4C 8B 82 D0 00 00 00 EB 10 4C 8B 82 C8 00 00 00 EB 07 4C 8B 82 C0 00 00 00 41 83 E3 07 41 0F B6 C1 44 03 D8 41 83 FB 05 75 17 8B 46 01 8B CF 49 0F AF C8 48 03 C8 41 8B C3 48 89 0B E9 18 01 00 00 41 83 FB 04 75 15 8B C7 49 0F AF C0 48 03 82 98 00 00 00 48 89 03 E9 F8 00 00 00 41 83 E3 0F 41 83 FB 08 77 7B 74 70 45 85 DB 74 62 41 FF CB 74 54 41 FF CB 74 46 41 FF CB 74 38 41 FF CB 74 2A 41 FF CB 74 1C 41 FF CB 74 0E 41 FF CB 75 75 48 8B 82 B0 00 00 00 EB 3A 48 8B 82 A8 00 00 00 EB 31 48 8B 82 A0 00 00 00 EB 28 48 8B 82 98 00 00 00 EB 1F 48 8B 82 90 00 00 00 EB 16 48 8B 82 88 00 00 00 EB 0D 48 8B 82 80 00 00 00 EB 04 48 8B 42 78 48 89 03 EB 73 48 8B 82 B8 00 00 00 EB F2 41 83 EB 09 74 5A 41 FF CB 74 4C 41 FF CB 74 3E 41 FF CB 74 30 41 FF CB 74 22 41 FF CB 74 14 41 FF CB 74 06 48 83 23 00 EB 40 48 8B 82 F0 00 00 00 EB BF 48 8B 82 E8 00 00 00 EB B6 48 8B 82 E0 00 00 00 EB AD 48 8B 82 D8 00 00 00 EB A4 48 8B 82 D0 00 00 00 EB 9B 48 8B 82 C8 00 00 00 EB 92 48 8B 8A C0 00 00 00 48 89 0B 8B CF 49 0F AF C8 48 01 0B B8 01 00 00 00 48 8B 5C 24 08 48 8B 74 24 10 48 8B 7C 24 18 C3 }
	condition:
		$1
}

rule file_134_13_0 {
	meta:
		name = "sib8"
		size = 665
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 45 0F B6 18 0F B6 44 24 28 48 8B D9 45 8B D3 41 8B CB BF 01 00 00 00 41 C1 EA 03 C1 E9 06 49 8B F0 41 83 E2 07 D3 E7 41 03 C2 48 83 F8 04 75 08 45 33 C0 E9 F9 00 00 00 83 E0 0F 48 83 F8 08 0F 87 87 00 00 00 74 7C 48 85 C0 74 71 48 FF C8 74 63 48 FF C8 74 55 48 FF C8 74 44 48 FF C8 74 33 48 FF C8 74 22 48 FF C8 74 11 48 FF C8 75 C1 4C 8B 82 B0 00 00 00 E9 B6 00 00 00 4C 8B 82 A8 00 00 00 E9 AA 00 00 00 4C 8B 82 A0 00 00 00 E9 9E 00 00 00 4C 8B 82 98 00 00 00 E9 92 00 00 00 4C 8B 82 90 00 00 00 E9 86 00 00 00 4C 8B 82 88 00 00 00 EB 7D 4C 8B 82 80 00 00 00 EB 74 4C 8B 42 78 EB 6E 4C 8B 82 B8 00 00 00 EB 65 48 83 E8 09 74 58 48 FF C8 74 4A 48 FF C8 74 3C 48 FF C8 74 2E 48 FF C8 74 20 48 FF C8 74 12 48 FF C8 0F 85 3C FF FF FF 4C 8B 82 F0 00 00 00 EB 34 4C 8B 82 E8 00 00 00 EB 2B 4C 8B 82 E0 00 00 00 EB 22 4C 8B 82 D8 00 00 00 EB 19 4C 8B 82 D0 00 00 00 EB 10 4C 8B 82 C8 00 00 00 EB 07 4C 8B 82 C0 00 00 00 41 83 E3 07 41 0F B6 C1 44 03 D8 41 83 FB 04 75 1C 0F B6 46 01 8B CF 49 0F AF C8 48 03 C8 48 03 8A 98 00 00 00 48 89 0B E9 17 01 00 00 41 83 E3 0F 41 83 FB 08 0F 87 8F 00 00 00 0F 84 80 00 00 00 45 85 DB 74 75 41 FF CB 74 67 41 FF CB 74 59 41 FF CB 74 48 41 FF CB 74 37 41 FF CB 74 26 41 FF CB 74 15 41 FF CB 0F 85 81 00 00 00 48 8B 82 B0 00 00 00 E9 B8 00 00 00 48 8B 82 A8 00 00 00 E9 AC 00 00 00 48 8B 82 A0 00 00 00 E9 A0 00 00 00 48 8B 82 98 00 00 00 E9 94 00 00 00 48 8B 82 90 00 00 00 E9 88 00 00 00 48 8B 82 88 00 00 00 EB 7F 48 8B 82 80 00 00 00 EB 76 48 8B 42 78 EB 70 48 8B 82 B8 00 00 00 EB 67 41 83 EB 09 74 5A 41 FF CB 74 4C 41 FF CB 74 3E 41 FF CB 74 30 41 FF CB 74 22 41 FF CB 74 14 41 FF CB 74 06 48 83 23 00 EB 40 48 8B 82 F0 00 00 00 EB 34 48 8B 82 E8 00 00 00 EB 2B 48 8B 82 E0 00 00 00 EB 22 48 8B 82 D8 00 00 00 EB 19 48 8B 82 D0 00 00 00 EB 10 48 8B 82 C8 00 00 00 EB 07 48 8B 82 C0 00 00 00 48 89 03 0F B6 46 01 8B CF 49 0F AF C8 48 03 C8 48 01 0B 48 8B 5C 24 08 48 8B 74 24 10 48 8B 7C 24 18 B8 02 00 00 00 C3 }
	condition:
		$1
}

rule file_134_14_0 {
	meta:
		name = "sib32"
		size = 663
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 45 0F B6 18 0F B6 44 24 28 48 8B D9 45 8B D3 41 8B CB BF 01 00 00 00 41 C1 EA 03 C1 E9 06 49 8B F0 41 83 E2 07 D3 E7 41 03 C2 48 83 F8 04 75 08 45 33 C0 E9 F9 00 00 00 83 E0 0F 48 83 F8 08 0F 87 87 00 00 00 74 7C 48 85 C0 74 71 48 FF C8 74 63 48 FF C8 74 55 48 FF C8 74 44 48 FF C8 74 33 48 FF C8 74 22 48 FF C8 74 11 48 FF C8 75 C1 4C 8B 82 B0 00 00 00 E9 B6 00 00 00 4C 8B 82 A8 00 00 00 E9 AA 00 00 00 4C 8B 82 A0 00 00 00 E9 9E 00 00 00 4C 8B 82 98 00 00 00 E9 92 00 00 00 4C 8B 82 90 00 00 00 E9 86 00 00 00 4C 8B 82 88 00 00 00 EB 7D 4C 8B 82 80 00 00 00 EB 74 4C 8B 42 78 EB 6E 4C 8B 82 B8 00 00 00 EB 65 48 83 E8 09 74 58 48 FF C8 74 4A 48 FF C8 74 3C 48 FF C8 74 2E 48 FF C8 74 20 48 FF C8 74 12 48 FF C8 0F 85 3C FF FF FF 4C 8B 82 F0 00 00 00 EB 34 4C 8B 82 E8 00 00 00 EB 2B 4C 8B 82 E0 00 00 00 EB 22 4C 8B 82 D8 00 00 00 EB 19 4C 8B 82 D0 00 00 00 EB 10 4C 8B 82 C8 00 00 00 EB 07 4C 8B 82 C0 00 00 00 41 83 E3 07 41 0F B6 C1 44 03 D8 41 83 FB 04 75 1B 8B 46 01 8B CF 49 0F AF C8 48 03 C8 48 03 8A 98 00 00 00 48 89 0B E9 16 01 00 00 41 83 E3 0F 41 83 FB 08 0F 87 8F 00 00 00 0F 84 80 00 00 00 45 85 DB 74 75 41 FF CB 74 67 41 FF CB 74 59 41 FF CB 74 48 41 FF CB 74 37 41 FF CB 74 26 41 FF CB 74 15 41 FF CB 0F 85 81 00 00 00 48 8B 82 B0 00 00 00 E9 B8 00 00 00 48 8B 82 A8 00 00 00 E9 AC 00 00 00 48 8B 82 A0 00 00 00 E9 A0 00 00 00 48 8B 82 98 00 00 00 E9 94 00 00 00 48 8B 82 90 00 00 00 E9 88 00 00 00 48 8B 82 88 00 00 00 EB 7F 48 8B 82 80 00 00 00 EB 76 48 8B 42 78 EB 70 48 8B 82 B8 00 00 00 EB 67 41 83 EB 09 74 5A 41 FF CB 74 4C 41 FF CB 74 3E 41 FF CB 74 30 41 FF CB 74 22 41 FF CB 74 14 41 FF CB 74 06 48 83 23 00 EB 40 48 8B 82 F0 00 00 00 EB 34 48 8B 82 E8 00 00 00 EB 2B 48 8B 82 E0 00 00 00 EB 22 48 8B 82 D8 00 00 00 EB 19 48 8B 82 D0 00 00 00 EB 10 48 8B 82 C8 00 00 00 EB 07 48 8B 82 C0 00 00 00 48 89 03 8B 46 01 8B CF 49 0F AF C8 48 03 C8 48 01 0B 48 8B 5C 24 08 48 8B 74 24 10 48 8B 7C 24 18 B8 05 00 00 00 C3 }
	condition:
		$1
}

rule file_134_15_0 {
	meta:
		name = "d32"
		size = 19
	strings:
		$1 = { 49 63 00 49 8D 50 04 48 03 D0 B8 04 00 00 00 48 89 11 C3 }
	condition:
		$1
}

rule file_134_16_0 {
	meta:
		name = "bp8"
		size = 20
	strings:
		$1 = { 41 0F B6 00 48 03 82 A0 00 00 00 48 89 01 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_134_17_0 {
	meta:
		name = "bp32"
		size = 19
	strings:
		$1 = { 41 8B 00 48 03 82 A0 00 00 00 48 89 01 B8 04 00 00 00 C3 }
	condition:
		$1
}

rule file_134_19_0 {
	meta:
		name = "si8"
		size = 20
	strings:
		$1 = { 41 0F B6 00 48 03 82 A8 00 00 00 48 89 01 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_134_20_0 {
	meta:
		name = "si32"
		size = 19
	strings:
		$1 = { 41 8B 00 48 03 82 A8 00 00 00 48 89 01 B8 04 00 00 00 C3 }
	condition:
		$1
}

rule file_134_22_0 {
	meta:
		name = "di8"
		size = 20
	strings:
		$1 = { 41 0F B6 00 48 03 82 B0 00 00 00 48 89 01 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_134_23_0 {
	meta:
		name = "di32"
		size = 19
	strings:
		$1 = { 41 8B 00 48 03 82 B0 00 00 00 48 89 01 B8 04 00 00 00 C3 }
	condition:
		$1
}

rule file_134_25_0 {
	meta:
		name = "AdjustExceptionResult"
		size = 488
	strings:
		$1 = { 4C 8B 4A 20 41 8B 41 60 A8 01 0F 84 95 01 00 00 83 E0 1E 3C 0E 0F 85 8A 01 00 00 83 F9 39 0F 82 81 01 00 00 41 BB 02 00 00 00 45 33 C0 45 8D 53 05 83 F9 3A 76 64 83 F9 3C 76 1B 83 F9 56 0F 86 61 01 00 00 83 F9 58 0F 86 A8 00 00 00 83 F9 5A 0F 87 4F 01 00 00 41 8B 49 50 85 C9 74 30 FF C9 74 24 FF C9 74 14 FF C9 0F 85 37 01 00 00 81 62 1C 6F F7 FF FF 83 4A 1C 45 C3 81 62 1C 2B F7 FF FF 83 4A 1C 01 C3 81 62 1C 2A F7 FF FF C3 81 62 1C 6A F7 FF FF 83 4A 1C 40 C3 41 8B 49 50 85 C9 0F 84 9C 00 00 00 FF C9 0F 84 86 00 00 00 FF C9 74 1C FF C9 75 3F 44 39 5A 18 76 0C 83 7A 18 06 76 2E 44 39 52 18 75 2D 45 89 41 50 EB 27 8B 42 18 85 C0 74 F3 41 3B C3 76 16 83 F8 03 74 E9 83 F8 04 74 0C 76 0F 83 F8 06 76 DD 41 3B C2 75 05 41 83 49 50 FF 48 8B 4A 20 44 8B 49 50 45 85 C9 0F 84 AE 00 00 00 41 FF C9 0F 84 97 00 00 00 41 FF C9 74 6A 41 FF C9 0F 85 88 00 00 00 44 39 5A 18 76 0C 83 7A 18 06 76 77 44 39 52 18 75 76 4C 89 41 50 C3 83 7A 18 03 76 8E 44 39 52 18 77 B5 EB AE 8B 42 18 85 C0 74 A7 83 F8 01 0F 84 76 FF FF FF 41 3B C3 74 99 76 9C 83 F8 04 0F 86 66 FF FF FF 83 F8 05 74 89 83 F8 06 0F 84 58 FF FF FF 41 3B C2 0F 84 77 FF FF FF E9 77 FF FF FF 8B 42 18 85 C0 74 AA 41 3B C3 76 16 83 F8 03 74 A0 83 F8 04 74 0C 76 0F 83 F8 06 76 94 41 3B C2 75 05 48 83 49 50 FF C3 83 7A 18 03 76 83 44 39 52 18 77 F3 EB EC 8B 42 18 85 C0 74 E5 83 F8 01 0F 84 6B FF FF FF 41 3B C3 74 D7 76 DA 83 F8 04 0F 86 5B FF FF FF 83 F8 05 74 C7 83 F8 06 0F 84 4D FF FF FF 41 3B C2 74 B9 C3 }
	condition:
		$1
}

rule file_134_26_0 {
	meta:
		name = "DppxEmulationWrapper"
		size = 515
		refs = "0095 LoopDppxSimdValue"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 40 48 8B 84 24 98 00 00 00 45 33 E4 33 FF 8B 28 4D 8B E9 4D 8B F8 C1 ED 1E 48 8B DA 44 8B F1 FF C5 83 7A 28 6D 41 0F 95 C4 41 FF C4 33 F6 83 7B 28 48 74 14 83 7B 28 6D 75 1A 8B C6 F7 D8 1B FF 83 E7 FC 83 C7 4D EB 0C 8B C6 F7 D8 1B FF 83 E7 FC 83 C7 2F 48 8B 84 24 90 00 00 00 89 7C 24 38 89 74 24 30 4D 8B CD 4D 8B C7 48 8B D3 41 8B CE 89 6C 24 28 48 89 44 24 20 E8 ?? ?? ?? ?? 41 8B CE 44 8B C8 45 85 F6 74 48 FF C9 0F 85 D6 00 00 00 85 F6 0F 85 CE 00 00 00 48 8D 4B 50 8D 56 02 48 8B 41 60 48 89 01 48 8D 49 08 48 FF CA 75 F0 48 8B 83 B8 00 00 00 48 89 83 80 00 00 00 48 8B 83 B0 00 00 00 48 89 83 88 00 00 00 E9 96 00 00 00 8B C6 85 F6 74 49 FF C8 0F 85 88 00 00 00 44 8B 83 B8 00 00 00 8B 93 BC 00 00 00 8B 8B B0 00 00 00 8B 83 B4 00 00 00 44 89 43 50 89 53 54 89 4B 58 89 8B 84 00 00 00 89 93 88 00 00 00 89 43 5C 89 83 80 00 00 00 44 89 83 8C 00 00 00 EB 47 48 8D 4B 50 BA 04 00 00 00 8B 41 60 89 01 48 8D 49 04 48 FF CA 75 F2 8B 83 B4 00 00 00 89 83 80 00 00 00 8B 83 B0 00 00 00 89 83 84 00 00 00 8B 83 BC 00 00 00 89 83 88 00 00 00 8B 83 B8 00 00 00 89 83 8C 00 00 00 FF C6 41 3B F4 0F 86 BC FE FF FF 45 85 F6 74 2C 41 FF CE 75 4B 33 C9 85 ED 74 45 48 81 C3 B0 00 00 00 41 8B 47 18 D3 E8 A8 01 75 04 48 83 23 00 FF C1 48 83 C3 08 3B CD 72 E8 EB 24 33 C9 85 ED 74 1E 48 81 C3 B0 00 00 00 41 8B 47 18 D3 E8 A8 01 75 03 83 23 00 FF C1 48 83 C3 04 3B CD 72 E9 4C 8D 5C 24 40 41 8B C1 49 8B 5B 30 49 8B 6B 38 49 8B 73 40 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_134_27_0 {
	meta:
		name = "LoadOperand"
		size = 799
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 10 48 8B 5C 24 40 44 8B DA 4D 89 19 49 83 FB 1F 75 0A 41 83 61 20 FE E9 EF 02 00 00 41 BB 08 00 00 00 83 FA 1B 77 25 B8 00 00 B0 08 0F A3 D0 73 1B 84 C9 74 0D 49 8B 01 83 FA 14 49 0F 44 C3 49 89 01 8B 44 24 48 41 89 41 08 EB 3A 84 C9 74 36 83 FA 1F 74 31 49 8B 01 83 FA 12 41 BA 0D 00 00 00 49 0F 44 C2 83 FA 13 41 8D 4A 0C 48 0F 44 C1 83 FA 0E 49 0F 44 C2 49 89 01 83 FA 0C 75 07 49 C7 01 0B 00 00 00 49 83 61 10 00 49 83 61 18 00 41 8B 51 20 49 8B 01 83 CA 01 41 89 51 20 48 83 F8 13 0F 87 93 01 00 00 0F 84 85 01 00 00 49 2B C3 74 6A 48 83 E8 03 74 5C 48 FF C8 74 4F 48 FF C8 74 31 48 FF C8 74 12 48 83 F8 04 0F 85 39 02 00 00 83 E2 E1 E9 AA 01 00 00 83 E2 E1 41 89 51 20 48 8B 83 A0 04 00 00 48 8B 08 49 89 49 10 E9 17 02 00 00 83 E2 E1 41 89 51 20 48 8B 83 A0 04 00 00 8B 08 41 89 49 10 E9 FE 01 00 00 83 E2 EB 83 CA 0A EB C8 83 E2 EB 83 CA 0A EB DA 83 E2 EB 83 CA 0A 41 89 51 20 45 3B C3 0F 87 87 00 00 00 74 79 45 85 C0 74 6B 41 FF C8 74 5A 41 FF C8 74 49 41 FF C8 74 38 41 83 E8 02 74 26 41 FF C8 74 15 41 FF C8 0F 85 B1 01 00 00 48 8B 83 B0 00 00 00 E9 A1 01 00 00 48 8B 83 A8 00 00 00 E9 95 01 00 00 48 8B 83 A0 00 00 00 E9 89 01 00 00 48 8B 83 90 00 00 00 E9 7D 01 00 00 48 8B 83 88 00 00 00 E9 71 01 00 00 48 8B 83 80 00 00 00 E9 65 01 00 00 48 8B 43 78 E9 5C 01 00 00 48 8B 83 B8 00 00 00 E9 50 01 00 00 41 83 E8 09 74 6A 41 FF C8 74 59 41 FF C8 74 48 41 FF C8 74 37 41 FF C8 74 26 41 FF C8 74 15 41 FF C8 0F 85 2C 01 00 00 48 8B 83 F0 00 00 00 E9 1C 01 00 00 48 8B 83 E8 00 00 00 E9 10 01 00 00 48 8B 83 E0 00 00 00 E9 04 01 00 00 48 8B 83 D8 00 00 00 E9 F8 00 00 00 48 8B 83 D0 00 00 00 E9 EC 00 00 00 48 8B 83 C8 00 00 00 E9 E0 00 00 00 48 8B 83 C0 00 00 00 E9 D4 00 00 00 83 E2 E3 83 CA 02 EB 49 48 83 E8 14 0F 84 AA 00 00 00 48 FF C8 74 70 48 83 E8 02 74 55 48 83 E8 02 74 44 48 FF C8 74 23 48 FF C8 0F 85 A7 00 00 00 41 8B C0 83 E2 EB 48 83 C0 1A 48 03 C0 83 CA 0A 48 8B 04 C3 41 89 41 10 EB 6B 83 E2 EB 83 CA 0A 41 89 51 20 48 8B 83 A0 04 00 00 0F 28 00 F3 41 0F 7F 41 10 EB 71 83 E2 E3 83 CA 02 E9 38 FE FF FF 41 8B C8 83 E2 E3 48 8D 41 1A 48 03 C9 48 03 C0 83 CA 02 EB 10 41 8B C8 48 8D 41 1A 48 03 C9 48 03 C0 83 E2 E1 48 8B 04 C3 48 89 04 24 48 8B 84 CB A8 01 00 00 48 89 44 24 08 0F 28 04 24 F3 41 0F 7F 41 10 41 89 51 20 EB 1C 41 8B C0 83 E2 EB 48 83 C0 12 48 03 C0 83 CA 0A 48 8B 04 C3 41 89 51 20 49 89 41 10 48 8B 5C 24 20 48 83 C4 10 5F C3 }
	condition:
		$1
}

rule file_134_28_0 {
	meta:
		name = "LoopDppxSimdValue"
		size = 602
		refs = "017f _XMMI_FP_Emulation 0186 _XMMI2_FP_Emulation"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 20 45 33 E4 83 CD FF 49 8B F9 49 8B F0 48 8B DA 44 8B E9 44 39 64 24 78 0F 86 02 02 00 00 4C 8D BA B0 00 00 00 4C 8D 72 08 83 BC 24 80 00 00 00 00 75 3A 8B 46 18 41 8D 4C 24 04 D3 E8 A8 01 75 2C 41 8B C5 45 85 ED 74 0A FF C8 75 0E 49 83 27 00 EB 08 41 83 A6 A8 00 00 00 00 83 8B C0 00 00 00 01 8B 46 1C 89 43 30 E9 9D 01 00 00 83 66 04 00 83 67 04 E0 83 67 08 E0 83 67 0C E0 8B 46 10 8B 94 24 88 00 00 00 33 07 81 E2 FF 0F 00 00 83 E0 03 C1 E2 03 31 07 8B 46 14 8B 0F 83 E0 07 81 E1 03 00 FE FF 0B D0 8B 47 20 C1 E2 02 0B D1 89 17 33 43 60 83 E0 01 31 47 20 8B 47 20 33 43 60 83 E0 1E 31 47 20 41 8B C5 45 85 ED 74 0E FF C8 75 11 49 8B 47 A0 48 89 47 10 EB 07 41 8B 46 48 89 47 10 8B 83 90 00 00 00 83 67 40 FE 83 E0 01 74 12 09 47 40 8B 47 40 33 83 90 00 00 00 83 E0 1E 31 47 40 41 8B C5 45 85 ED 74 0E FF C8 75 11 49 8B 47 D0 48 89 47 30 EB 07 41 8B 46 78 89 47 30 83 67 60 FE 41 8B C5 45 85 ED 74 0D FF C8 75 13 49 8B 07 48 89 47 50 EB 0A 41 8B 86 A8 00 00 00 89 47 50 8B 47 60 48 8B CE 33 83 C0 00 00 00 83 E0 1E 31 47 60 41 8D 45 FF 48 89 7E 20 83 F8 01 76 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 8B C8 41 89 06 8B 46 04 41 89 46 10 83 F9 01 75 4A F6 46 04 20 74 04 83 4B 04 20 F6 46 04 10 74 04 83 4B 04 10 F6 46 04 08 74 04 83 4B 04 08 F6 46 04 04 74 04 83 4B 04 04 F6 46 04 02 74 04 83 4B 04 02 F6 46 04 01 74 04 83 4B 04 01 48 8B CF FF 54 24 70 8B E8 83 F8 FF 75 58 8B 8B C0 00 00 00 33 4F 60 83 E1 01 31 8B C0 00 00 00 F6 83 C0 00 00 00 01 8B 4E 1C 89 4B 30 74 1F 41 8B C5 45 85 ED 74 0D FF C8 75 13 48 8B 47 50 49 89 07 EB 0A 8B 47 50 41 89 86 A8 00 00 00 41 FF C4 49 83 C7 08 49 83 C6 04 44 3B 64 24 78 0F 82 09 FE FF FF 8B C5 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_134_29_0 {
	meta:
		name = "SetPniOperation"
		size = 94
	strings:
		$1 = { 83 E9 43 74 45 FF C9 74 39 FF C9 74 2D 83 E9 23 74 1B FF C9 74 0F FF C9 74 03 32 C0 C3 C7 02 4B 00 00 00 EB 36 C7 02 49 00 00 00 EB 2E 41 F7 D8 1B C0 83 E0 FE 83 C0 4B EB 1F C7 02 2D 00 00 00 EB 19 C7 02 2B 00 00 00 EB 11 41 83 E0 FD 41 F7 D8 1B C0 83 E0 FE 83 C0 2D 89 02 B0 01 C3 }
	condition:
		$1
}

rule file_134_30_0 {
	meta:
		name = "UpdateResult"
		size = 479
	strings:
		$1 = { 4C 8B 09 8B 41 08 4C 8B D2 4C 8B D9 49 83 F9 13 0F 87 62 01 00 00 49 83 F9 12 0F 83 9F 01 00 00 49 83 E9 08 74 3F 49 FF C9 0F 84 44 01 00 00 49 83 E9 02 74 22 49 FF C9 74 0E 49 FF C9 74 18 49 FF C9 0F 85 96 01 00 00 48 8B 8A A0 04 00 00 49 8B 43 10 48 89 01 C3 48 8B 8A A0 04 00 00 41 8B 43 10 89 01 C3 83 F8 08 0F 87 96 00 00 00 0F 84 84 00 00 00 85 C0 74 77 FF C8 74 64 FF C8 74 51 FF C8 74 3E 83 E8 02 74 2A FF C8 74 17 FF C8 0F 85 DE 00 00 00 8B 41 10 48 89 82 B0 00 00 00 E9 CF 00 00 00 8B 41 10 48 89 82 A8 00 00 00 E9 C0 00 00 00 8B 41 10 48 89 82 A0 00 00 00 E9 B1 00 00 00 8B 41 10 48 89 82 90 00 00 00 E9 A2 00 00 00 8B 41 10 48 89 82 88 00 00 00 E9 93 00 00 00 8B 41 10 48 89 82 80 00 00 00 E9 84 00 00 00 8B 41 10 48 89 42 78 EB 7B 8B 41 10 48 89 82 B8 00 00 00 EB 6F 83 E8 09 74 60 FF C8 74 50 FF C8 74 40 FF C8 74 30 FF C8 74 20 FF C8 74 10 FF C8 75 52 8B 41 10 48 89 82 F0 00 00 00 EB 46 8B 41 10 48 89 82 E8 00 00 00 EB 3A 8B 41 10 48 89 82 E0 00 00 00 EB 2E 8B 41 10 48 89 82 D8 00 00 00 EB 22 8B 41 10 48 89 82 D0 00 00 00 EB 16 8B 41 10 48 89 82 C8 00 00 00 EB 0A 8B 41 10 48 89 82 C0 00 00 00 44 89 42 44 C3 49 83 E9 14 74 51 49 FF C9 74 1A 49 83 E9 02 74 14 49 83 E9 02 0F 84 B5 FE FF FF 49 FF C9 74 27 49 FF C9 75 41 48 8D 48 1A 48 8B D0 49 8B 43 10 48 03 C9 48 03 D2 49 89 04 CA 49 8B 43 18 49 89 84 D2 A8 01 00 00 C3 0F 10 41 10 48 8B 82 A0 04 00 00 F3 0F 7F 00 C3 48 8D 48 12 49 8B 43 10 48 03 C9 48 89 04 CA C3 }
	condition:
		$1
}

rule file_134_31_0 {
	meta:
		name = "_fpieee_flt_simd"
		size = 4937
		refs = "001d __security_cookie 04df InstInfoTableEX 04eb InstInfoTableDX 050e InstInfoTableCX 051a InstInfoTable7X 0523 InstInfoTable5X 0583 InstInfoTable4X 058c InstInfoTable0X 0595 InstInfoTable2X 06c2 __ImageBase 06d3 InstInfoTableX 07ec ??_C@_0N@MDJJJHMB@kernel32?4dll?$AA@ 07f5 __imp_GetModuleHandleA 07ff ??_C@_0BJ@DIBIJBHA@GetEnabledXStateFeatures?$AA@ 0805 __imp_GetProcAddress 081b ??_C@_0BG@IKLDMBLM@GetXStateFeaturesMask?$AA@ 0837 ??_C@_0BE@KINNKFDA@LocateXStateFeature?$AA@ 094b modrm32 0954 d32 0adc LoadOperand 1056 _XMMI_FP_Emulation 105d _XMMI2_FP_Emulation 111f AdjustExceptionResult 1201 DppxEmulationWrapper 1220 UpdateResult 1328 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 20 57 41 54 41 55 41 56 41 57 48 81 EC 90 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 80 03 00 00 49 8B F0 4C 89 84 24 08 01 00 00 83 C8 FF 89 84 24 80 00 00 00 45 33 FF 45 8A DF 44 88 7C 24 53 45 8A CF 44 88 7C 24 38 41 8A DF 88 5C 24 51 45 8B D7 44 89 BC 24 90 00 00 00 41 8A FF 89 7C 24 54 4C 89 7C 24 58 45 8B C7 44 89 7C 24 3C 44 89 BC 24 88 00 00 00 44 89 7C 24 74 4C 89 BC 24 A8 00 00 00 4C 89 BC 24 98 00 00 00 48 8B 02 48 8B 48 20 48 85 C9 74 07 FF D6 E9 72 12 00 00 48 8B 7A 08 48 89 7C 24 68 48 8B 87 A0 04 00 00 48 89 84 24 28 01 00 00 4C 89 BC 24 E8 00 00 00 45 8B F7 44 89 7C 24 34 44 89 7C 24 48 44 89 7C 24 4C 41 8A CF 88 4C 24 30 45 8A EF 44 88 7C 24 52 41 8A C7 89 44 24 70 88 44 24 50 45 8A E7 44 88 7C 24 45 B8 01 00 00 00 8A D0 88 44 24 44 41 8A C7 89 44 24 40 88 44 24 31 41 8A F7 44 88 7C 24 61 44 88 7C 24 60 48 8B BF F8 00 00 00 48 89 7C 24 78 33 C0 84 D2 0F 84 D5 02 00 00 44 0F B6 1F 44 88 5C 24 53 48 FF C7 48 89 7C 24 78 41 8B CB 41 83 FB 66 0F 8F 9B 00 00 00 83 F9 66 74 75 8D 41 DA A9 E7 FF FF FF 0F 84 8E 02 00 00 83 F9 3F 0F 8E 78 02 00 00 83 F9 4F 7E 15 8D 41 9C B9 01 00 00 00 3B C1 0F 86 70 02 00 00 E9 5E 02 00 00 B8 01 00 00 00 44 03 C0 44 89 44 24 3C 44 8B E1 41 83 E4 04 45 03 E4 44 88 64 24 45 44 8B E9 41 83 E5 02 41 C1 E5 02 44 88 6C 24 52 23 C8 8B C1 C1 E0 03 89 44 24 70 88 44 24 50 8A 4C 24 30 E9 36 02 00 00 B9 01 00 00 00 44 8B F1 89 4C 24 34 89 4C 24 48 44 03 C1 44 89 44 24 3C 8A 4C 24 30 E9 17 02 00 00 83 E9 67 0F 84 FD 01 00 00 83 E9 5D 0F 84 ED 00 00 00 FF C9 74 47 83 E9 2B 0F 84 E7 01 00 00 83 E9 02 74 21 FF C9 0F 85 CD 01 00 00 B9 01 00 00 00 8A C1 88 4C 24 31 89 44 24 40 44 03 C1 44 89 44 24 3C EB 91 B9 01 00 00 00 8A C1 88 4C 24 31 44 8B F1 89 4C 24 34 89 4C 24 48 EB DA 41 B9 01 00 00 00 45 8A F9 44 88 4C 24 60 8A 0F 49 03 F9 48 89 7C 24 78 8A C1 24 03 41 3A C1 45 0F 44 F1 44 89 74 24 34 44 89 74 24 48 8B 54 24 40 0F B6 D2 3C 02 41 0F 44 D1 89 54 24 40 88 54 24 31 3C 03 75 18 41 8A C1 89 44 24 40 88 44 24 31 45 8B F1 44 89 4C 24 34 44 89 4C 24 48 0F B6 C1 8B D8 C1 EB 02 41 23 D9 88 5C 24 51 44 8B D0 41 F7 D2 41 C1 FA 03 41 83 E2 0F 44 89 94 24 90 00 00 00 C1 E8 04 F7 D0 83 E0 08 44 8A E0 88 44 24 45 41 B1 0F 44 88 4C 24 38 41 FF C0 E9 F5 00 00 00 BB 01 00 00 00 40 8A F3 88 5C 24 61 44 8A 07 48 03 FB 48 89 7C 24 78 8A 17 48 03 FB 48 89 7C 24 78 8A CA 80 E1 03 3A CB 44 0F 44 F3 44 89 74 24 34 44 89 74 24 48 0F B6 44 24 40 80 F9 02 0F 44 C3 44 8A C8 44 89 4C 24 40 88 44 24 31 80 F9 03 75 15 8A C3 89 44 24 40 88 5C 24 31 44 8B F3 89 5C 24 34 89 5C 24 48 44 0F B6 D2 41 8B C2 C1 E8 02 23 C3 8A D8 88 44 24 51 41 F7 D2 41 C1 FA 03 41 83 E2 0F 44 89 94 24 90 00 00 00 41 0F B6 C8 8B C1 C1 E8 04 F7 D0 83 E0 08 44 8A E0 88 44 24 45 8B C1 C1 E8 03 F7 D0 83 E0 08 44 8A E8 88 44 24 52 8B C1 C1 E8 02 F7 D0 83 E0 08 89 44 24 70 88 44 24 50 83 E1 0F FF C9 74 19 FF C9 74 10 FF C9 74 07 33 C0 E9 53 0F 00 00 41 B1 3A EB 08 41 B1 38 EB 03 41 B1 0F 44 88 4C 24 38 44 8B 44 24 3C 41 83 C0 02 44 89 44 24 3C 33 C0 8A D0 88 44 24 44 E9 F1 FD FF FF B8 01 00 00 00 88 44 24 32 88 44 24 30 8A C8 33 C0 E9 23 FD FF FF 84 C9 74 07 33 C0 E9 05 0F 00 00 48 89 BC 24 B8 00 00 00 8B 17 44 8B C2 41 83 E0 0F 44 89 84 24 A4 00 00 00 8B CA C1 E9 04 83 E1 0F 89 8C 24 A0 00 00 00 45 84 FF 75 41 40 84 F6 75 3C C1 EA 0B 83 E2 07 41 0F B6 C4 03 D0 89 94 24 84 00 00 00 89 94 24 B0 00 00 00 41 80 FB 0F 74 4F B9 01 00 00 00 88 4C 24 30 88 4C 24 32 4C 8B 5C 24 58 44 8B 54 24 54 E9 66 05 00 00 41 80 F9 0F 74 1C B9 03 00 00 00 89 8C 24 A0 00 00 00 45 0F B6 C1 41 83 E0 0F 44 89 84 24 A4 00 00 00 41 8B C2 89 84 24 84 00 00 00 89 84 24 B0 00 00 00 83 E9 02 0F 84 D1 00 00 00 FF C9 74 64 83 E9 02 74 56 83 E9 02 74 48 83 E9 05 74 37 FF C9 74 10 FF C9 75 8D 48 8D 15 ?? ?? ?? ?? E9 B1 00 00 00 48 8D 15 ?? ?? ?? ?? 33 C0 38 44 24 40 0F 84 9E 00 00 00 44 8B F0 89 44 24 34 89 44 24 48 E9 8E 00 00 00 48 8D 15 ?? ?? ?? ?? E9 82 00 00 00 48 8D 15 ?? ?? ?? ?? EB CF 48 8D 15 ?? ?? ?? ?? EB 70 B9 01 00 00 00 41 83 F8 0A 0F 85 36 FF FF FF 44 8B C9 40 8A C6 41 0A C7 75 0C 48 03 F9 48 89 7C 24 78 01 4C 24 3C 48 89 BC 24 B8 00 00 00 8B 07 44 8B C0 41 83 E0 0F 44 89 84 24 A4 00 00 00 C1 E8 04 83 E0 0F 89 84 24 A0 00 00 00 74 12 83 F8 04 0F 85 EE FE FF FF 48 8D 15 ?? ?? ?? ?? EB 15 48 8D 15 ?? ?? ?? ?? EB 0C 48 8D 15 ?? ?? ?? ?? 44 8B 4C 24 4C 8B 07 B9 00 C0 00 00 23 C1 45 33 DB 45 8B D3 3B C1 41 0F 95 C2 44 89 54 24 54 44 88 94 24 8C 00 00 00 41 0F B6 C2 C1 E0 04 41 0B C0 41 8D 4B 01 83 F8 20 76 12 88 4C 24 30 88 4C 24 32 4C 8B 5C 24 58 E9 06 04 00 00 41 B8 FF 0F 00 00 44 3B C9 0F 85 9E 00 00 00 48 8D 14 82 48 89 54 24 58 48 89 94 24 F8 00 00 00 8B 0A 41 23 C8 8D 41 95 83 F8 02 76 1E 8D 41 BA 83 F8 02 76 07 B9 01 00 00 00 EB B2 45 8B F3 44 89 5C 24 34 44 89 5C 24 48 EB 10 B8 01 00 00 00 44 8B F0 89 44 24 34 89 44 24 48 8D 41 BA 83 F8 27 77 21 49 BB 05 00 00 00 A0 00 00 00 49 0F A3 C3 73 11 33 C9 44 8A D9 44 89 5C 24 40 44 88 5C 24 31 EB 48 83 F9 6C 74 1C 83 F9 47 74 17 B9 01 00 00 00 88 4C 24 30 88 4C 24 32 4C 8B 5C 24 58 E9 66 03 00 00 41 BB 01 00 00 00 EB CB 41 8D 04 46 48 8D 14 82 48 89 54 24 58 48 89 94 24 F8 00 00 00 44 8B 74 24 34 44 8B 5C 24 40 8B 0A 41 85 C8 74 BB 8B C1 25 00 F0 01 00 4C 8D 35 ?? ?? ?? ?? 3D 00 E0 01 00 75 46 45 33 D2 49 8D 96 ?? ?? ?? ?? 45 84 DB 74 0A C1 E9 11 83 E1 1F FF C1 EB 07 48 C1 E9 11 83 E1 1F 48 8D 14 8A 48 89 94 24 F8 00 00 00 48 89 54 24 58 45 8A DA 44 88 54 24 31 41 BA 02 00 00 00 44 89 54 24 48 EB 05 44 8B 54 24 34 8B 12 41 23 D0 8D 42 BD 41 0F B6 CB 83 F8 02 41 B8 00 00 00 00 41 0F 46 C8 89 4C 24 40 88 4C 24 31 8D 42 98 83 F8 02 45 8D 58 01 45 0F 46 D3 44 89 54 24 34 44 89 54 24 48 45 85 C9 75 0E 0F B6 C1 03 C2 89 84 24 D8 01 00 00 EB 07 89 94 24 D8 01 00 00 45 84 FF 75 05 40 84 F6 74 34 83 C2 CD 83 FA 38 77 2C 48 B9 01 A3 08 40 C0 5F 1F 01 48 0F A3 D1 73 1C 8B 0F C1 E9 0B 83 E1 07 41 0F B6 C4 03 C8 89 8C 24 84 00 00 00 89 8C 24 B0 00 00 00 44 8B 7C 24 3C 41 83 C7 03 44 89 7C 24 3C 49 8B C0 48 89 84 24 A8 00 00 00 48 89 84 24 18 01 00 00 48 8B 74 24 68 84 DB 0F 84 02 01 00 00 8B 46 30 B9 40 00 10 00 23 C1 3B C1 0F 85 F0 00 00 00 48 8D 1D ?? ?? ?? ?? 48 8B CB FF 15 ?? ?? ?? ?? 48 8B C8 48 8D 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B F0 48 8B CB FF 15 ?? ?? ?? ?? 48 8B C8 48 8D 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 4C 8B F8 48 8B CB FF 15 ?? ?? ?? ?? 48 8B C8 48 8D 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B D8 33 C0 48 85 DB 0F 84 CD 0A 00 00 FF D6 48 89 84 24 20 01 00 00 A8 04 75 07 33 C0 E9 B8 0A 00 00 48 8D 94 24 20 01 00 00 48 8B 74 24 68 48 8B CE 41 FF D7 85 C0 0F 84 9D 0A 00 00 4C 8D 84 24 00 01 00 00 BA 01 00 00 00 48 8B CE FF D3 48 89 84 24 98 00 00 00 48 89 84 24 10 01 00 00 45 33 C0 45 8D 78 02 41 8B D7 48 8B CE FF D3 48 89 84 24 A8 00 00 00 48 89 84 24 18 01 00 00 41 8B CF 89 4C 24 74 89 8C 24 F0 00 00 00 44 8B 7C 24 3C 44 8D 59 FF EB 25 41 8B C3 89 44 24 74 89 84 24 F0 00 00 00 48 8D 86 A0 01 00 00 48 89 84 24 98 00 00 00 48 89 84 24 10 01 00 00 44 8B 54 24 54 45 84 D2 0F 84 94 00 00 00 48 89 7C 24 78 49 03 FB 48 89 7C 24 78 0F B6 07 88 44 24 53 49 03 FB 48 89 7C 24 78 8B D8 41 0F B6 C5 44 0F B6 4C 24 70 89 44 24 20 4C 8B C7 48 8B 54 24 68 48 8D 8E A0 04 00 00 41 FF 94 DE ?? ?? ?? ?? 8B C8 48 8D 05 ?? ?? ?? ?? 4C 8B 5C 24 58 49 39 84 DE ?? ?? ?? ?? 75 1B 41 8B 03 25 00 00 C0 01 3D 00 00 40 00 75 0C B8 01 00 00 00 48 01 86 A0 04 00 00 48 8B 86 A0 04 00 00 48 89 84 24 E8 00 00 00 48 89 84 24 30 01 00 00 44 8B 54 24 54 EB 0C 8B 8C 24 88 00 00 00 4C 8B 5C 24 58 44 03 F9 44 89 7C 24 3C 41 8B 03 25 00 00 C0 01 3D 00 00 40 00 75 23 8B C1 48 03 F8 48 89 7C 24 78 0F B6 07 89 84 24 DC 01 00 00 B9 01 00 00 00 44 03 F9 44 89 7C 24 3C EB 05 B9 01 00 00 00 44 8B 74 24 34 33 DB 8B C3 89 5C 24 4C 44 8D 7B 10 48 8B 7C 24 68 39 5C 24 74 0F 8E 97 08 00 00 41 0F B6 CC 89 8C 24 88 00 00 00 44 8B AC 24 00 01 00 00 85 C0 74 6F 48 8B 84 24 98 00 00 00 48 8D 48 08 48 8D 94 24 80 02 00 00 48 2B D0 4C 8B 84 24 A8 00 00 00 4C 2B C0 4D 8B CF 4C 8B 54 24 68 8B 7C 24 54 48 8B 41 F8 48 89 44 0A F8 48 8B 01 48 89 04 0A 49 8B 44 08 F8 48 89 41 F8 49 8B 04 08 48 89 01 40 84 FF 74 12 48 8B 84 24 E8 00 00 00 49 03 C7 49 89 82 A0 04 00 00 49 03 CF 49 FF C9 75 C1 EB 19 45 84 D2 4C 8B 54 24 68 74 0F 48 8B 84 24 E8 00 00 00 48 89 87 A0 04 00 00 41 8B 3B 8B DF C1 EB 0C 83 E3 1F 44 8B A4 24 84 00 00 00 44 89 64 24 28 4C 89 54 24 20 4C 8D 8C 24 F0 01 00 00 45 8B C4 8B D3 8B 74 24 40 40 8A CE E8 ?? ?? ?? ?? 48 8B 84 24 B8 00 00 00 8B D7 40 8A CE 44 8B 00 C1 EA 11 41 C1 E8 08 0F B6 44 24 70 83 E2 1F 41 83 E0 07 44 03 C0 44 89 44 24 28 48 8B 44 24 68 48 89 44 24 20 83 FB 1F 75 17 4C 8D 8C 24 F0 01 00 00 E8 ?? ?? ?? ?? 83 A4 24 40 02 00 00 FE EB 0D 4C 8D 8C 24 20 02 00 00 E8 ?? ?? ?? ?? 48 8B 84 24 B8 00 00 00 8B 00 C1 E8 0B 83 E0 07 03 84 24 88 00 00 00 C1 EF 19 83 E7 1F 89 44 24 28 48 8B 44 24 68 48 89 44 24 20 4C 8D 8C 24 50 02 00 00 45 8B C4 8B D7 40 8A CE E8 ?? ?? ?? ?? 45 33 C9 44 38 4C 24 30 0F 85 84 F8 FF FF 48 8B 7C 24 68 8B 47 34 B9 00 03 00 00 45 8D 51 01 23 C1 74 1F 3D 00 02 00 00 74 0E 3B C1 75 1F 44 89 8C 24 D4 00 00 00 EB 15 44 89 94 24 D4 00 00 00 EB 0B C7 84 24 D4 00 00 00 02 00 00 00 8B 47 34 8B C8 C1 E9 0D 83 E1 03 74 30 FF C9 74 22 FF C9 74 11 FF C9 75 2C C7 84 24 D0 00 00 00 03 00 00 00 EB 1F C7 84 24 D0 00 00 00 02 00 00 00 EB 12 44 89 94 24 D0 00 00 00 EB 08 44 89 8C 24 D0 00 00 00 8B C8 C1 E9 07 83 E1 3F 89 8C 24 C0 00 00 00 8B C8 C1 E9 0F 41 23 CA 89 8C 24 C8 00 00 00 8B C8 C1 E9 06 41 23 CA 89 8C 24 CC 00 00 00 8B 4F 44 89 8C 24 DC 00 00 00 8B 8C 24 DC 01 00 00 89 8C 24 D8 00 00 00 83 E0 3F 89 84 24 B0 01 00 00 44 89 8C 24 B4 01 00 00 48 8B 44 24 58 44 8B 20 41 C1 EC 1E 45 03 E2 40 84 F6 45 0F 45 E2 8B 9C 24 D8 01 00 00 83 FB 48 0F 84 46 05 00 00 83 FB 6D 0F 84 3D 05 00 00 41 8B F1 45 85 E4 0F 84 6A 05 00 00 49 8B F9 44 8B 84 24 A0 01 00 00 44 89 8C 24 C4 00 00 00 41 BB E0 FF FF FF 44 21 9C 24 44 01 00 00 44 21 9C 24 48 01 00 00 44 21 9C 24 4C 01 00 00 8B 8C 24 D4 00 00 00 83 E1 07 C1 E1 02 8B 84 24 40 01 00 00 41 23 C3 0B C8 8B 84 24 D0 00 00 00 83 E0 03 0B C8 8B C3 83 E8 43 74 4B FF C8 74 3F FF C8 74 33 83 E8 23 74 1D FF C8 74 11 FF C8 74 05 41 8A C1 EB 46 41 BD 4B 00 00 00 EB 42 41 BD 49 00 00 00 EB 3A 8B C6 F7 D8 45 1B ED 41 83 E5 FE 41 83 C5 4B EB 29 41 BD 2D 00 00 00 EB 21 41 BD 2B 00 00 00 EB 19 8B C6 83 E0 FD F7 D8 45 1B ED 41 83 E5 FE 41 83 C5 2D 41 8A C2 84 C0 74 05 41 8B C5 EB 02 8B C3 C1 E0 05 33 C1 25 E0 FF 01 00 33 C8 89 8C 24 40 01 00 00 8B 94 24 10 02 00 00 83 E2 1F 8B 8C 24 60 01 00 00 41 23 CB 0B CA 89 8C 24 60 01 00 00 41 8B C6 45 85 F6 0F 84 96 00 00 00 FF C8 74 53 83 FB 5F 0F 82 E9 00 00 00 83 FB 60 76 31 83 FB 62 76 22 83 FB 65 76 0A 83 FB 67 76 18 E9 D0 00 00 00 8B 84 BC 00 02 00 00 89 84 24 50 01 00 00 E9 BD 00 00 00 48 8B 84 FC 00 02 00 00 EB 07 8B 84 BC 00 02 00 00 48 89 84 24 50 01 00 00 E9 9F 00 00 00 48 8B 84 FC 00 02 00 00 48 89 84 24 50 01 00 00 8D 43 97 41 3B C2 0F 87 83 00 00 00 41 3B F2 75 7E 48 8B 84 24 30 02 00 00 48 89 84 24 50 01 00 00 8B C1 33 84 24 40 02 00 00 83 E0 1F EB 57 8B 84 BC 00 02 00 00 89 84 24 50 01 00 00 8D 43 BC 41 3B C2 77 4A 8B C6 FF C8 74 21 FF C8 74 14 FF C8 75 3C 8B 84 24 38 02 00 00 89 84 24 50 01 00 00 EB BE 8B 84 24 30 02 00 00 EB EE 8B 84 24 08 02 00 00 89 84 24 50 01 00 00 8B C1 33 84 24 10 02 00 00 83 E0 1E 33 C8 89 8C 24 60 01 00 00 8B 8C 24 80 01 00 00 44 84 94 24 40 02 00 00 74 10 8B C1 33 84 24 40 02 00 00 83 E0 1F 33 C8 EB 03 83 E1 FE 89 8C 24 80 01 00 00 41 8B C6 45 85 F6 0F 84 8B 00 00 00 FF C8 74 4C 83 FB 5F 0F 82 EA 00 00 00 83 FB 60 76 2A 83 FB 62 76 1B 83 FB 65 76 0A 83 FB 67 76 11 E9 D1 00 00 00 8B 84 BC 30 02 00 00 E9 BE 00 00 00 48 8B 84 FC 30 02 00 00 EB 07 8B 84 BC 30 02 00 00 48 89 84 24 70 01 00 00 E9 A7 00 00 00 48 8B 84 FC 30 02 00 00 48 89 84 24 70 01 00 00 8D 43 97 41 3B C2 0F 87 8B 00 00 00 85 F6 0F 85 83 00 00 00 48 8B 84 24 08 02 00 00 48 89 84 24 70 01 00 00 41 23 CB 0B CA EB 40 8B 84 BC 30 02 00 00 89 84 24 70 01 00 00 8D 43 BC 41 3B C2 77 56 8B C6 85 F6 74 36 FF C8 74 29 FF C8 75 48 8B 84 24 34 02 00 00 89 84 24 70 01 00 00 8B C1 33 84 24 40 02 00 00 83 E0 1F 33 C8 89 8C 24 80 01 00 00 EB 23 8B 84 24 0C 02 00 00 EB 07 8B 84 24 04 02 00 00 41 23 CB 0B CA 89 8C 24 80 01 00 00 89 84 24 70 01 00 00 41 83 E0 FE 41 8B C6 45 85 F6 74 38 FF C8 74 19 83 FB 5F 72 3D 83 FB 60 76 19 83 FB 62 76 0A 83 FB 65 76 20 83 FB 67 77 29 48 8B 84 FC 60 02 00 00 EB 07 8B 84 BC }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "_lseek"
		size = 225
		refs = "0024 __doserrno 002c _errno 0041 _nhandle 0054 __pioinfo 0071 __lock_fhandle 008b _lseek_nolock 00ac _unlock_fhandle 00c8 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 10 89 4C 24 08 56 57 41 54 41 56 41 57 48 83 EC 20 41 8B F0 44 8B F2 48 63 D9 83 FB FE 75 18 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 91 00 00 00 85 C9 78 75 3B 1D ?? ?? ?? ?? 73 6D 48 8B C3 48 8B FB 48 C1 FF 05 4C 8D 25 ?? ?? ?? ?? 83 E0 1F 4C 6B F8 58 49 8B 04 FC 42 0F BE 4C 38 08 83 E1 01 74 46 8B CB E8 ?? ?? ?? ?? 90 49 8B 04 FC 42 F6 44 38 08 01 74 11 44 8B C6 41 8B D6 8B CB E8 ?? ?? ?? ?? 8B F8 EB 16 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 20 00 83 CF FF 8B CB E8 ?? ?? ?? ?? 8B C7 EB 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 48 8B 5C 24 58 48 83 C4 20 41 5F 41 5E 41 5C 5F 5E C3 }
	condition:
		$1
}

rule file_135_2_0 {
	meta:
		name = "_lseek_nolock"
		size = 227
		refs = "0020 _get_osfhandle 002e _errno 0052 __imp_SetFilePointerEx 005c __imp_GetLastError 0063 _dosmaperr 00b2 __pioinfo"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 30 48 63 F9 41 8B F0 48 63 EA 8B CF E8 ?? ?? ?? ?? 48 8B D8 48 83 F8 FF 75 13 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 8E 00 00 00 4C 8D 44 24 20 41 B9 01 00 00 00 33 D2 48 8B C8 FF 15 ?? ?? ?? ?? 85 C0 75 0F FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB CF 4C 8D 44 24 58 48 8B D5 44 8B CE 48 8B CB FF 15 ?? ?? ?? ?? 85 C0 74 D9 83 7C 24 5C 00 74 21 48 8B 54 24 20 45 33 C9 45 33 C0 48 8B CB FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 8F 48 8B CF 48 8B C7 48 8D 15 ?? ?? ?? ?? 48 C1 F8 05 83 E1 1F 48 8B 04 C2 48 6B C9 58 80 64 08 08 FD 8B 44 24 58 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_136_0_0 {
	meta:
		name = "ilogbl"
		size = 68
		refs = "0015 _ldunscale"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 54 24 30 48 8D 4C 24 38 E8 ?? ?? ?? ?? 0F BF C8 85 C9 74 1A FF C9 74 0F FF C9 74 0B 0F B7 44 24 38 66 FF C8 98 EB 0C B8 FF FF FF 7F EB 05 B8 00 00 00 80 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_724_0_0 {
	meta:
		name = "ilogb"
		size = 68
		refs = "0015 _dunscale"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 54 24 30 48 8D 4C 24 38 E8 ?? ?? ?? ?? 0F BF C8 85 C9 74 1A FF C9 74 0F FF C9 74 0B 0F B7 44 24 38 66 FF C8 98 EB 0C B8 FF FF FF 7F EB 05 B8 00 00 00 80 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "trunc"
		size = 33
		refs = "0012 _d_int"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 33 D2 E8 ?? ?? ?? ?? F2 0F 10 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_954_0_0 {
	meta:
		name = "truncl"
		size = 33
		refs = "0012 _ld_int"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 33 D2 E8 ?? ?? ?? ?? F2 0F 10 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_138_4_0 {
	meta:
		name = "_ismbstrail_l"
		size = 145
		refs = "0016 _errno 0021 _invalid_parameter_noinfo 0037 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B FA 48 8B D9 48 85 C9 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 5D 48 85 D2 74 E7 48 8D 4C 24 20 49 8B D0 E8 ?? ?? ?? ?? 48 8B 4C 24 28 83 79 08 00 74 2B 48 3B DF 77 26 80 3B 00 74 21 0F B6 03 F6 44 08 19 04 74 0D 48 FF C3 48 3B DF 74 0A 80 3B 00 74 0A 48 FF C3 EB DA 83 C8 FF EB 02 33 C0 80 7C 24 38 00 74 0C 48 8B 4C 24 30 83 A1 C8 00 00 00 FD 48 8B 5C 24 50 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "clog"
		size = 579
		refs = "0029 creal 003f cimag 004d _dtest 00af atan2 00d3 __xmm@80000000000000008000000000000000 0122 _fperrraise 012a _Inf_C 0141 __real@3feccccccccccccd 0153 __real@3fd999999999999a 0173 _d_int 01be __real@3ff0000000000000 01d3 log1p 01db __real@3fe0000000000000 0208 log 0222 _Cbuild"
	strings:
		$1 = { 40 55 53 56 57 48 8B EC 48 83 EC 58 0F 10 02 48 8B F9 48 8D 4D C8 0F 29 74 24 40 48 8B DA 0F 29 7C 24 30 F3 0F 7F 45 C8 E8 ?? ?? ?? ?? 48 8D 4D C8 F2 0F 11 45 28 0F 10 03 F3 0F 7F 45 C8 E8 ?? ?? ?? ?? 48 8D 4D 28 F2 0F 11 45 30 E8 ?? ?? ?? ?? 48 8D 4D 30 0F B7 F0 E8 ?? ?? ?? ?? 0F B7 D8 66 83 FE 02 75 1C F2 0F 10 55 28 48 8D 4D C8 66 83 F8 01 0F 84 A0 01 00 00 F2 0F 11 D1 E9 9F 01 00 00 66 83 FB 02 75 1C F2 0F 10 55 30 48 8D 4D C8 66 83 FE 01 0F 84 7E 01 00 00 F2 0F 11 D1 E9 7D 01 00 00 F2 0F 10 4D 28 F2 0F 10 45 30 E8 ?? ?? ?? ?? 0F 28 F8 66 83 FE 01 0F 84 52 01 00 00 66 83 FB 01 0F 84 48 01 00 00 F2 0F 10 55 28 F2 0F 10 35 ?? ?? ?? ?? 0F 57 DB 66 0F 2F DA 76 08 0F 57 D6 F2 0F 11 55 28 F2 0F 10 4D 30 66 0F 2F D9 76 08 0F 57 CE F2 0F 11 4D 30 66 0F 2F CA 76 13 0F 28 C2 F2 0F 11 4D 28 0F 28 D1 F2 0F 11 45 30 0F 28 C8 66 0F 2E D3 7A 23 75 21 B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 0F 57 CE 0F 28 D7 48 8D 4D C8 E9 E4 00 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C2 0F 82 98 00 00 00 66 0F 2F 0D ?? ?? ?? ?? 0F 82 8A 00 00 00 BB 1A 00 00 00 48 8D 4D 40 F2 0F 11 55 40 8B D3 F2 0F 11 4D 38 E8 ?? ?? ?? ?? 48 8D 4D 38 8B D3 E8 ?? ?? ?? ?? F2 0F 10 65 38 F2 0F 10 5D 40 F2 0F 10 6D 30 F2 0F 10 55 28 0F 28 C4 F2 0F 5C EC F2 0F 59 E4 F2 0F 58 45 30 F2 0F 5C D3 F2 0F 59 E8 0F 28 C3 F2 0F 59 DB F2 0F 58 45 28 F2 0F 5C 1D ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 C5 F2 0F 58 DC F2 0F 58 C3 E8 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? 0F 28 C8 E9 4A FF FF FF F2 0F 5E CA F2 0F 59 C9 0F 28 C1 E8 ?? ?? ?? ?? 0F 28 F0 F2 0F 10 45 28 F2 0F 59 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? F2 0F 58 C6 EB CD 0F 28 D0 48 8D 4D C8 F2 0F 10 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 28 74 24 40 0F 28 7C 24 30 0F 10 00 48 8B C7 F3 0F 7F 07 48 83 C4 58 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "_fgetwchar"
		size = 21
		refs = "0005 __iob_func 0011 fgetwc"
		altNames = "getwchar"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B C8 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_45_0 {
	meta:
		name = "?GetCurrent@UMSThreadProxy@details@Concurrency@@SAPEAV123@XZ"
		size = 21
		refs = "0005 ?GetCurrentUmsThread@UMS@details@Concurrency@@SAPEAXXZ 0011 ?FromUMSContext@UMSThreadProxy@details@Concurrency@@SAPEAV123@PEAX@Z"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B C8 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_778_0_0 {
	meta:
		name = "_fgetchar"
		size = 21
		refs = "0005 __iob_func 0011 getc"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B C8 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_778_1_0 {
	meta:
		name = "getchar"
		size = 21
		refs = "0005 __iob_func 0011 getc"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B C8 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "___lc_codepage_func"
		size = 55
		refs = "0005 _getptd 0013 __ptlocinfo 0021 __globallocalestatus 0028 __updatetlocinfo"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B 88 C0 00 00 00 48 3B 0D ?? ?? ?? ?? 74 16 8B 80 C8 00 00 00 85 05 ?? ?? ?? ?? 75 08 E8 ?? ?? ?? ?? 48 8B C8 8B 41 04 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_143_1_0 {
	meta:
		name = "___lc_collate_cp_func"
		size = 55
		refs = "0005 _getptd 0013 __ptlocinfo 0021 __globallocalestatus 0028 __updatetlocinfo"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B 88 C0 00 00 00 48 3B 0D ?? ?? ?? ?? 74 16 8B 80 C8 00 00 00 85 05 ?? ?? ?? ?? 75 08 E8 ?? ?? ?? ?? 48 8B C8 8B 41 08 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_143_2_0 {
	meta:
		name = "___lc_locale_name_func"
		size = 59
		refs = "0005 _getptd 0013 __ptlocinfo 0021 __globallocalestatus 0028 __updatetlocinfo"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B 88 C0 00 00 00 48 3B 0D ?? ?? ?? ?? 74 16 8B 80 C8 00 00 00 85 05 ?? ?? ?? ?? 75 08 E8 ?? ?? ?? ?? 48 8B C8 48 8D 81 28 01 00 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_143_3_0 {
	meta:
		name = "___mb_cur_max_func"
		size = 58
		refs = "0005 _getptd 0013 __ptlocinfo 0021 __globallocalestatus 0028 __updatetlocinfo"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B 88 C0 00 00 00 48 3B 0D ?? ?? ?? ?? 74 16 8B 80 C8 00 00 00 85 05 ?? ?? ?? ?? 75 08 E8 ?? ?? ?? ?? 48 8B C8 8B 81 D4 00 00 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_143_4_0 {
	meta:
		name = "___mb_cur_max_l_func"
		size = 19
		refs = "0005 ___mb_cur_max_func"
	strings:
		$1 = { 48 85 C9 0F 84 ?? ?? ?? ?? 48 8B 01 8B 80 D4 00 00 00 C3 }
	condition:
		$1
}

rule file_143_5_0 {
	meta:
		name = "__init_ctype"
		size = 1059
		refs = "0022 __security_cookie 007c __getlocaleinfo 008e _malloc_crt 00a4 _calloc_crt 0124 __imp_GetCPInfo 017b __crtLCMapStringA 0224 __crtGetStringTypeA 02a3 memcpy 02f2 free 03b0 __newctype 03ca __newclmap 03df __newcumap 03fe __security_check_cookie"
	strings:
		$1 = { 4C 8B DC 49 89 5B 10 49 89 6B 18 49 89 73 20 57 41 54 41 55 41 56 41 57 48 81 EC 90 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 88 00 00 00 4C 8B 81 38 01 00 00 33 DB 48 8B F9 48 89 5C 24 58 44 8B FB 44 8B E3 44 8B EB 8B EB 49 89 4B A8 49 89 5B B0 4D 85 C0 0F 84 40 03 00 00 4C 8D 71 04 8D 73 01 41 39 1E 75 1E 49 8D 4B A8 33 D2 41 B9 04 10 00 00 4C 89 74 24 20 E8 ?? ?? ?? ?? 85 C0 0F 85 E6 02 00 00 B9 04 00 00 00 E8 ?? ?? ?? ?? BD 80 01 00 00 BA 02 00 00 00 8B CD 48 89 44 24 58 E8 ?? ?? ?? ?? 48 8B D6 8B CD 4C 8B F8 E8 ?? ?? ?? ?? 48 8B D6 8B CD 4C 8B E0 E8 ?? ?? ?? ?? 8D 4D 81 48 8B D6 4C 8B E8 E8 ?? ?? ?? ?? 48 8B E8 48 8B 44 24 58 48 85 C0 0F 84 8D 02 00 00 4D 85 FF 0F 84 84 02 00 00 48 85 ED 0F 84 7B 02 00 00 4D 85 E4 0F 84 72 02 00 00 4D 85 ED 0F 84 69 02 00 00 89 18 48 8B CD 8B C3 88 01 03 C6 48 03 CE 3D 00 01 00 00 7C F2 41 8B 0E 48 8D 54 24 70 FF 15 ?? ?? ?? ?? 85 C0 0F 84 3E 02 00 00 83 7C 24 70 05 0F 87 33 02 00 00 0F B7 44 24 70 48 8B 97 38 01 00 00 89 5C 24 40 89 44 24 50 41 8B 06 49 8D 8C 24 81 00 00 00 89 44 24 38 B8 FF 00 00 00 4C 8D 4D 01 89 44 24 30 48 89 4C 24 28 44 8D 40 01 33 C9 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 E7 01 00 00 41 8B 06 48 8B 97 38 01 00 00 89 5C 24 40 89 44 24 38 B8 FF 00 00 00 49 8D 8D 81 00 00 00 89 44 24 30 48 89 4C 24 28 4C 8D 4D 01 33 C9 41 B8 00 02 00 00 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 A3 01 00 00 39 74 24 50 7E 2E 38 5C 24 76 74 28 48 8D 4C 24 77 38 19 74 1F 0F B6 51 FF EB 09 48 63 C2 03 D6 C6 04 28 20 0F B6 01 3B D0 7E F0 48 83 C1 02 38 59 FF 75 DD 41 8B 06 49 8D 8F 00 01 00 00 89 5C 24 30 89 44 24 28 48 89 4C 24 20 41 B9 00 01 00 00 33 C9 4C 8B C5 8B D6 E8 ?? ?? ?? ?? 85 C0 0F 84 3E 01 00 00 4D 8D B7 FE 00 00 00 66 41 89 1E 41 88 5C 24 7F 41 88 5D 7F 41 88 9C 24 80 00 00 00 41 88 9D 80 00 00 00 39 74 24 50 7E 39 38 5C 24 76 74 33 48 8D 4C 24 77 38 19 74 2A 0F B6 51 FF EB 14 48 63 C2 41 B8 00 80 00 00 03 D6 66 45 89 84 47 00 01 00 00 0F B6 01 3B D0 7E E5 48 83 C1 02 38 59 FF 75 D2 49 8D 97 00 02 00 00 41 B8 FE 00 00 00 49 8B CF E8 ?? ?? ?? ?? 49 8D 94 24 00 01 00 00 41 B8 7F 00 00 00 49 8B CC E8 ?? ?? ?? ?? 49 8D 95 00 01 00 00 41 B8 7F 00 00 00 49 8B CD E8 ?? ?? ?? ?? 48 8B 8F F8 00 00 00 48 85 C9 74 44 F0 FF 09 75 3F 48 8B 8F 00 01 00 00 48 81 E9 FE 00 00 00 E8 ?? ?? ?? ?? 48 8B 8F 10 01 00 00 48 83 C1 80 E8 ?? ?? ?? ?? 48 8B 8F 18 01 00 00 48 83 C1 80 E8 ?? ?? ?? ?? 48 8B 8F F8 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 58 89 30 48 89 87 F8 00 00 00 49 8D 87 00 01 00 00 48 89 87 08 01 00 00 49 8D 84 24 80 00 00 00 4C 89 B7 00 01 00 00 48 89 87 10 01 00 00 49 8D 85 80 00 00 00 48 89 87 18 01 00 00 8B 44 24 50 89 87 D4 00 00 00 EB 24 48 8B 4C 24 58 E8 ?? ?? ?? ?? 49 8B CF E8 ?? ?? ?? ?? 49 8B CC E8 ?? ?? ?? ?? 49 8B CD E8 ?? ?? ?? ?? 8B DE 48 8B CD E8 ?? ?? ?? ?? 8B C3 EB 54 48 8B 81 F8 00 00 00 48 85 C0 74 03 F0 FF 08 48 8D 05 ?? ?? ?? ?? BE 01 00 00 00 48 89 99 F8 00 00 00 48 89 81 08 01 00 00 48 8D 05 ?? ?? ?? ?? 48 89 99 00 01 00 00 48 89 81 10 01 00 00 48 8D 05 ?? ?? ?? ?? 89 B1 D4 00 00 00 48 89 81 18 01 00 00 33 C0 48 8B 8C 24 88 00 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 90 00 00 00 49 8B 5B 38 49 8B 6B 40 49 8B 73 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "__sse2_ceil2"
		size = 80
		refs = "0006 _2il0floatpacket_4 000d _2il0floatpacket_5 0038 _2il0floatpacket_6"
	strings:
		$1 = { 0F 28 E0 0F 28 1D ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 0F 28 D3 0F 54 E1 0F 55 C8 66 0F C2 D1 01 66 0F 58 CB 66 0F 5C CB 0F 56 CC 0F 28 DA 0F 28 E9 66 0F C2 E8 01 0F 54 2D ?? ?? ?? ?? 0F 54 C2 66 0F 5C CD 0F 55 D9 0F 56 C3 C3 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "llroundf"
		size = 95
		refs = "0010 _fdtest 0027 roundf 002e __real@df000000 003e __real@5f000000 0054 _fperrraise"
	strings:
		$1 = { F3 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 98 85 C0 74 3F FF C8 83 F8 01 76 2E F3 0F 10 44 24 30 E8 ?? ?? ?? ?? 0F 2F 05 ?? ?? ?? ?? F3 0F 11 44 24 30 72 14 F3 0F 10 0D ?? ?? ?? ?? 0F 2F C8 72 07 F3 48 0F 2C C0 EB 0C B9 01 00 00 00 E8 ?? ?? ?? ?? 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_147_0_0 {
	meta:
		name = "_cabsf"
		size = 22
		refs = "0012 _hypotf"
	strings:
		$1 = { F2 0F 10 49 08 F2 0F 10 01 66 0F 5A C9 66 0F 5A C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_149_14_0 {
	meta:
		name = "??1DefaultWaiterPool@platform@details@Concurrency@@QEAA@XZ"
		size = 97
		refs = "0009 s_waiterPool 003e __imp_SetEvent 0047 ??1_NonReentrantBlockingLock@details@Concurrency@@QEAA@XZ 004f ??3@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 1D ?? ?? ?? ?? 48 85 DB 74 49 48 8B 0B 48 85 C9 74 28 48 8B 81 00 02 00 00 48 83 20 00 B8 01 00 00 00 F0 0F C1 81 08 0A 00 00 FF C0 83 F8 01 75 09 48 8B 09 FF 15 ?? ?? ?? ?? 48 8D 4B 08 E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 83 25 ?? ?? ?? ?? 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_149_17_0 {
	meta:
		name = "??1WaiterThreadPool@platform@details@Concurrency@@QEAA@XZ"
		size = 71
		refs = "0035 __imp_SetEvent 0043 ??1_NonReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 09 48 85 C9 74 28 48 8B 81 00 02 00 00 48 83 20 00 B8 01 00 00 00 F0 0F C1 81 08 0A 00 00 FF C0 83 F8 01 75 09 48 8B 09 FF 15 ?? ?? ?? ?? 48 8D 4B 08 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_149_29_0 {
	meta:
		name = "??_GWaiterThreadPool@platform@details@Concurrency@@QEAAPEAXI@Z"
		size = 100
		refs = "003b __imp_SetEvent 0044 ??1_NonReentrantBlockingLock@details@Concurrency@@QEAA@XZ 0052 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B D9 48 8B 09 8B FA 48 85 C9 74 28 48 8B 81 00 02 00 00 48 83 20 00 B8 01 00 00 00 F0 0F C1 81 08 0A 00 00 FF C0 83 F8 01 75 09 48 8B 09 FF 15 ?? ?? ?? ?? 48 8D 4B 08 E8 ?? ?? ?? ?? 40 F6 C7 01 74 08 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_149_35_0 {
	meta:
		name = "?CaptureCallstack@platform@details@Concurrency@@YA_KPEAPEAX_K1@Z"
		size = 32
		refs = "0014 __imp_RtlCaptureStackBackTrace"
	strings:
		$1 = { 48 83 EC 28 49 8B C0 4C 8B C1 8D 4A 01 45 33 C9 8B D0 FF 15 ?? ?? ?? ?? 0F B7 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_149_37_0 {
	meta:
		name = "?InitializeSystemFunctionPointers@platform@details@Concurrency@@YAXXZ"
		size = 268
		refs = "000d ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0013 __imp_GetModuleHandleW 001a ??_C@_0BH@CJPDKMEB@SetThreadGroupAffinity?$AA@ 0026 __imp_GetProcAddress 002d ??_C@_0BH@CINNILJO@GetThreadGroupAffinity?$AA@ 0056 ?EncodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z 0060 s_pfnSetThreadGroupAffinity 0073 s_pfnGetThreadGroupAffinity 0080 ??_C@_0BM@JLHMEGJA@GetCurrentProcessorNumberEx?$AA@ 00a2 s_pfnGetCurrentProcessorNumberEx 00ae __imp_GetLastError 00c6 ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 00cd _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 00d7 _CxxThrowException"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 48 8B D8 FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 8B F8 FF 15 ?? ?? ?? ?? 48 8B D8 48 85 FF 0F 84 93 00 00 00 48 85 C0 0F 84 8A 00 00 00 48 8B CF E8 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 74 1A 48 8B C8 E8 ?? ?? ?? ?? 48 8B 5C 24 50 48 89 05 ?? ?? ?? ?? 48 83 C4 40 5F C3 FF 15 ?? ?? ?? ?? 48 8D 4C 24 20 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 4C 24 20 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_149_41_0 {
	meta:
		name = "?_Invoke@_CancellationTokenRegistration@details@Concurrency@@AEAAXXZ"
		size = 91
		refs = "000f __imp_GetCurrentThreadId 003d ?set@event@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 20 48 8B D9 FF 15 ?? ?? ?? ?? 8B F8 33 C0 F0 0F B1 7B 10 75 23 48 8B 13 48 8B CB FF 52 10 B9 03 00 00 00 8B C7 F0 0F B1 4B 10 83 F8 02 75 09 48 8B 4B 18 E8 ?? ?? ?? ?? F0 FF 4B 08 75 09 48 8B 03 48 8B CB FF 50 08 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_149_46_0 {
	meta:
		name = "?__CreateAutoResetEvent@platform@details@Concurrency@@YAPEAX_N@Z"
		size = 90
		refs = "001c __crtCreateEventExW 002c __imp_GetLastError 0044 ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 004b _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0055 _CxxThrowException"
	strings:
		$1 = { 48 83 EC 48 45 33 C0 84 C9 41 B9 02 00 1F 00 41 8D 40 02 44 0F 45 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 48 85 C0 74 05 48 83 C4 48 C3 FF 15 ?? ?? ?? ?? 48 8D 4C 24 20 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_149_47_0 {
	meta:
		name = "?__CreateManualResetEvent@platform@details@Concurrency@@YAPEAX_N@Z"
		size = 92
		refs = "001e __crtCreateEventExW 002e __imp_GetLastError 0046 ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 004d _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0057 _CxxThrowException"
	strings:
		$1 = { 48 83 EC 48 B8 03 00 00 00 84 C9 41 B9 02 00 1F 00 44 8D 40 FE 44 0F 45 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 48 85 C0 74 05 48 83 C4 48 C3 FF 15 ?? ?? ?? ?? 48 8D 4C 24 20 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_149_50_0 {
	meta:
		name = "?__DeleteTimerQueueTimer@platform@details@Concurrency@@YAXPEAX00@Z"
		size = 74
		refs = "001c __imp_GetLastError 0032 __imp_DeleteTimerQueueTimer"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 49 8B D8 48 8B FA 48 8B F1 EB 16 FF 15 ?? ?? ?? ?? 3D E5 03 00 00 74 13 4C 8B C3 48 8B D7 48 8B CE FF 15 ?? ?? ?? ?? 85 C0 74 E0 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_149_51_0 {
	meta:
		name = "?__GetCurrentProcessorNumberEx@platform@details@Concurrency@@YAXPEAU_PROCESSOR_NUMBER@@@Z"
		size = 32
		refs = "000c s_pfnGetCurrentProcessorNumberEx 0011 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B CB 48 83 C4 20 5B 48 FF E0 }
	condition:
		$1
}

rule file_260_26_0 {
	meta:
		name = "?CreateUmsCompletionList@UMS@details@Concurrency@@SAHPEAPEAX@Z"
		size = 32
		refs = "000c ?s_pfn_CreateUmsCompletionList@UMS@details@Concurrency@@0P6AHPEAPEAX@ZEA 0011 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B CB 48 83 C4 20 5B 48 FF E0 }
	condition:
		$1
}

rule file_260_27_0 {
	meta:
		name = "?CreateUmsThreadContext@UMS@details@Concurrency@@SAHPEAPEAX@Z"
		size = 32
		refs = "000c ?s_pfn_CreateUmsThreadContext@UMS@details@Concurrency@@0P6AHPEAPEAX@ZEA 0011 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B CB 48 83 C4 20 5B 48 FF E0 }
	condition:
		$1
}

rule file_260_28_0 {
	meta:
		name = "?DeleteProcThreadAttributeList@UMS@details@Concurrency@@SAXPEAU_PROC_THREAD_ATTRIBUTE_LIST@@@Z"
		size = 32
		refs = "000c ?s_pfn_DeleteProcThreadAttributeList@UMS@details@Concurrency@@0P6AXPEAU_PROC_THREAD_ATTRIBUTE_LIST@@@ZEA 0011 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B CB 48 83 C4 20 5B 48 FF E0 }
	condition:
		$1
}

rule file_260_29_0 {
	meta:
		name = "?DeleteUmsCompletionList@UMS@details@Concurrency@@SAHPEAX@Z"
		size = 32
		refs = "000c ?s_pfn_DeleteUmsCompletionList@UMS@details@Concurrency@@0P6AHPEAX@ZEA 0011 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B CB 48 83 C4 20 5B 48 FF E0 }
	condition:
		$1
}

rule file_260_30_0 {
	meta:
		name = "?DeleteUmsThreadContext@UMS@details@Concurrency@@SAHPEAX@Z"
		size = 32
		refs = "000c ?s_pfn_DeleteUmsThreadContext@UMS@details@Concurrency@@0P6AHPEAX@ZEA 0011 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B CB 48 83 C4 20 5B 48 FF E0 }
	condition:
		$1
}

rule file_260_32_0 {
	meta:
		name = "?EnterUmsSchedulingMode@UMS@details@Concurrency@@SAHPEAU_UMS_SCHEDULER_STARTUP_INFO@@@Z"
		size = 32
		refs = "000c ?s_pfn_EnterUmsSchedulingMode@UMS@details@Concurrency@@0P6AHPEAU_UMS_SCHEDULER_STARTUP_INFO@@@ZEA 0011 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B CB 48 83 C4 20 5B 48 FF E0 }
	condition:
		$1
}

rule file_260_33_0 {
	meta:
		name = "?ExecuteUmsThread@UMS@details@Concurrency@@SAHPEAX@Z"
		size = 32
		refs = "000c ?s_pfn_ExecuteUmsThread@UMS@details@Concurrency@@0P6AHPEAX@ZEA 0011 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B CB 48 83 C4 20 5B 48 FF E0 }
	condition:
		$1
}

rule file_260_35_0 {
	meta:
		name = "?GetNextUmsListItem@UMS@details@Concurrency@@SAPEAXPEAX@Z"
		size = 32
		refs = "000c ?s_pfn_GetNextUmsListItem@UMS@details@Concurrency@@0P6APEAXPEAX@ZEA 0011 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B CB 48 83 C4 20 5B 48 FF E0 }
	condition:
		$1
}

rule file_260_42_0 {
	meta:
		name = "?UmsThreadYield@UMS@details@Concurrency@@SAHPEAX@Z"
		size = 32
		refs = "000c ?s_pfn_UmsThreadYield@UMS@details@Concurrency@@0P6AHPEAX@ZEA 0011 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B CB 48 83 C4 20 5B 48 FF E0 }
	condition:
		$1
}

rule file_149_52_0 {
	meta:
		name = "?__GetLogicalProcessorInformation@platform@details@Concurrency@@YAPEAU_SYSTEM_LOGICAL_PROCESSOR_INFORMATION@@PEAK@Z"
		size = 239
		refs = "0014 __imp_GetLogicalProcessorInformation 001a __imp_GetLastError 0026 malloc 006a ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 0071 _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 007b _CxxThrowException 0083 ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 009d ??0exception@std@@QEAA@AEBQEBDH@Z 00a4 ??_7bad_alloc@std@@6B@ 00ab _TI2?AVbad_alloc@std@@"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B F9 48 8B D1 33 C9 FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 F8 7A 75 2D 8B 0F E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 4E 48 8B D7 48 8B C8 FF 15 ?? ?? ?? ?? 85 C0 74 7D 48 8B C3 48 8B 5C 24 50 48 83 C4 40 5F C3 FF 15 ?? ?? ?? ?? 48 8D 4C 24 20 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC 48 8D 05 ?? ?? ?? ?? 48 8D 54 24 58 48 8D 4C 24 20 41 B8 01 00 00 00 48 89 44 24 58 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 48 89 44 24 20 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 4C 24 20 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_149_53_0 {
	meta:
		name = "?__GetLogicalProcessorInformationEx@platform@details@Concurrency@@YAPEAU_SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX@@W4_LOGICAL_PROCESSOR_RELATIONSHIP@@PEAK@Z"
		size = 350
		refs = "0019 ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0022 __imp_GetModuleHandleW 0029 ??_C@_0CB@HOJBBPPI@GetLogicalProcessorInformationEx@ 0032 __imp_GetProcAddress 0049 __imp_GetLastError 0055 malloc 00a9 ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 00b0 _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 00ba _CxxThrowException 00f2 ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 010c ??0exception@std@@QEAA@AEBQEBDH@Z 0113 ??_7bad_alloc@std@@6B@ 011a _TI2?AVbad_alloc@std@@"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 20 57 48 83 EC 40 8B E9 48 8D 0D ?? ?? ?? ?? 48 8B FA FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B F0 48 85 C0 74 51 4C 8B C7 33 D2 8B CD FF D6 FF 15 ?? ?? ?? ?? 83 F8 7A 75 6D 8B 0F E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 0F 84 8A 00 00 00 4C 8B C7 48 8B D0 8B CD FF D6 85 C0 0F 84 B7 00 00 00 48 8B 6C 24 58 48 8B 74 24 68 48 8B C3 48 8B 5C 24 50 48 83 C4 40 5F C3 FF 15 ?? ?? ?? ?? 48 8D 4C 24 20 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 4C 24 20 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC 48 8D 05 ?? ?? ?? ?? 48 8D 54 24 60 48 8D 4C 24 20 41 B8 01 00 00 00 48 89 44 24 60 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 48 89 44 24 20 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 4C 24 20 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_149_54_0 {
	meta:
		name = "?__GetNumaHighestNodeNumber@platform@details@Concurrency@@YAKXZ"
		size = 76
		refs = "000b __imp_GetNumaHighestNodeNumber 001e __imp_GetLastError 0036 ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 003d _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0047 _CxxThrowException"
	strings:
		$1 = { 48 83 EC 48 48 8D 4C 24 50 FF 15 ?? ?? ?? ?? 85 C0 74 09 8B 44 24 50 48 83 C4 48 C3 FF 15 ?? ?? ?? ?? 48 8D 4C 24 20 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_149_55_0 {
	meta:
		name = "?__GetThreadGroupAffinity@platform@details@Concurrency@@YAHPEAXPEAU_GROUP_AFFINITY@@@Z"
		size = 103
		refs = "0011 ?GetOSVersion@Concurrency@@YA?AW4OSVersion@IResourceManager@1@XZ 001d s_pfnGetThreadGroupAffinity 0022 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z 0032 __imp_GetCurrentProcess 0045 __imp_GetProcessAffinityMask"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 83 F8 04 7C 16 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D3 48 8B CF FF D0 EB 27 FF 15 ?? ?? ?? ?? 4C 8D 44 24 48 48 8D 54 24 40 48 8B C8 FF 15 ?? ?? ?? ?? 33 C0 66 89 43 08 48 8B 44 24 40 48 89 03 B8 01 00 00 00 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_149_59_0 {
	meta:
		name = "?__RegisterWaitForSingleObject@platform@details@Concurrency@@YAPEAXPEAXP6AX0E@Z0@Z"
		size = 99
		refs = "0021 __imp_RegisterWaitForSingleObject 0035 __imp_GetLastError 004d ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 0054 _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 005e _CxxThrowException"
	strings:
		$1 = { 48 83 EC 58 4D 8B C8 4C 8B C2 48 8B D1 48 8D 4C 24 78 C7 44 24 28 0C 00 00 00 83 4C 24 20 FF FF 15 ?? ?? ?? ?? 85 C0 74 0A 48 8B 44 24 78 48 83 C4 58 C3 FF 15 ?? ?? ?? ?? 48 8D 4C 24 30 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 30 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_149_60_0 {
	meta:
		name = "?__SetThreadGroupAffinity@platform@details@Concurrency@@YAHPEAXPEBU_GROUP_AFFINITY@@@Z"
		size = 79
		refs = "0011 ?GetOSVersion@Concurrency@@YA?AW4OSVersion@IResourceManager@1@XZ 001d s_pfnSetThreadGroupAffinity 0022 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z 003b __imp_SetThreadAffinityMask"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 83 F8 04 7C 19 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 45 33 C0 48 8B D3 48 8B CF FF D0 EB 0C 48 8B 13 48 8B CF FF 15 ?? ?? ?? ?? B8 01 00 00 00 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_149_61_0 {
	meta:
		name = "?__SetThreadPriority@platform@details@Concurrency@@YAXPEAXH@Z"
		size = 67
		refs = "0006 __imp_SetThreadPriority 0015 __imp_GetLastError 002d ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 0034 _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 003e _CxxThrowException"
	strings:
		$1 = { 48 83 EC 48 FF 15 ?? ?? ?? ?? 85 C0 74 05 48 83 C4 48 C3 FF 15 ?? ?? ?? ?? 48 8D 4C 24 20 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_149_68_0 {
	meta:
		name = "?__TlsSetValue@platform@details@Concurrency@@YAXKPEAX@Z"
		size = 67
		refs = "0006 __imp_TlsSetValue 0015 __imp_GetLastError 002d ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 0034 _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 003e _CxxThrowException"
	strings:
		$1 = { 48 83 EC 48 FF 15 ?? ?? ?? ?? 85 C0 74 05 48 83 C4 48 C3 FF 15 ?? ?? ?? ?? 48 8D 4C 24 20 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_149_65_0 {
	meta:
		name = "?__TlsAlloc@platform@details@Concurrency@@YAKXZ"
		size = 68
		refs = "0006 __imp_TlsAlloc 0016 __imp_GetLastError 002e ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 0035 _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 003f _CxxThrowException"
	strings:
		$1 = { 48 83 EC 48 FF 15 ?? ?? ?? ?? 83 F8 FF 74 05 48 83 C4 48 C3 FF 15 ?? ?? ?? ?? 48 8D 4C 24 20 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_149_73_0 {
	meta:
		name = "?notify@WaiterThread@platform@details@Concurrency@@AEAAX_N@Z"
		size = 56
		refs = "002f __imp_SetEvent"
	strings:
		$1 = { 48 83 EC 28 84 D2 74 11 B8 01 00 00 00 F0 0F C1 81 08 0A 00 00 FF C0 EB 0C 8B 81 00 0A 00 00 2B 81 04 0A 00 00 83 F8 01 75 09 48 8B 09 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_149_74_0 {
	meta:
		name = "?stop@WaiterThread@platform@details@Concurrency@@QEAAXXZ"
		size = 49
		refs = "0028 __imp_SetEvent"
	strings:
		$1 = { 48 83 EC 28 48 8B 81 00 02 00 00 48 83 20 00 B8 01 00 00 00 F0 0F C1 81 08 0A 00 00 FF C0 83 F8 01 75 09 48 8B 09 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "_vfprintf_l"
		size = 35
		refs = "0015 _output_l 001a vfprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_150_2_0 {
	meta:
		name = "_vfprintf_p_l"
		size = 35
		refs = "0015 _output_p_l 001a vfprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_150_3_0 {
	meta:
		name = "_vfprintf_s_l"
		size = 35
		refs = "0015 _output_s_l 001a vfprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_757_0_0 {
	meta:
		name = "_vfwprintf_l"
		size = 35
		refs = "0015 _woutput_l 001a vfwprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_757_2_0 {
	meta:
		name = "_vfwprintf_p_l"
		size = 35
		refs = "0015 _woutput_p_l 001a vfwprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_757_3_0 {
	meta:
		name = "_vfwprintf_s_l"
		size = 35
		refs = "0015 _woutput_s_l 001a vfwprintf_helper"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_150_5_0 {
	meta:
		name = "vfprintf_helper"
		size = 318
		refs = "0038 _errno 0043 _invalid_parameter_noinfo 005f _lock_file 0072 _fileno 0080 __pioinfo 00a1 __badioinfo 00f6 _stbuf 0115 _ftbuf 011e _unlock_file"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 18 48 89 78 20 48 89 50 10 41 54 41 56 41 57 48 83 EC 20 4D 8B F9 4D 8B F0 48 8B F2 4C 8B E1 33 FF 33 C0 48 85 D2 0F 95 C0 85 C0 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 D5 00 00 00 33 C0 4D 85 C0 0F 95 C0 85 C0 74 DC 48 8B CA E8 ?? ?? ?? ?? 90 F6 46 18 40 0F 85 80 00 00 00 48 8B CE E8 ?? ?? ?? ?? 4C 63 C0 41 8D 48 02 4C 8D 0D ?? ?? ?? ?? 83 F9 01 76 1E 49 8B D0 49 8B C8 48 C1 F9 05 83 E2 1F 48 6B C2 58 49 03 04 C9 48 8D 0D ?? ?? ?? ?? EB 0A 48 8D 0D ?? ?? ?? ?? 48 8B C1 F6 40 38 7F 75 24 41 8D 40 02 83 F8 01 76 15 49 8B C8 49 8B C0 48 C1 F8 05 83 E1 1F 48 6B C9 58 49 03 0C C1 F6 41 38 80 74 13 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 CF FF 85 FF 75 28 48 8B CE E8 ?? ?? ?? ?? 8B D8 4C 8B 4C 24 60 4D 8B C7 49 8B D6 48 8B CE 41 FF D4 8B F8 48 8B D6 8B CB E8 ?? ?? ?? ?? 90 48 8B CE E8 ?? ?? ?? ?? 8B C7 48 8B 5C 24 40 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 20 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_150_6_0 {
	meta:
		name = "vfprintf_helper$fin$0"
		size = 24
		refs = "0013 _unlock_file"
		altNames = "_freopen_helper$fin$0 _wfdopen$fin$0 fwrite$fin$0 vfscanf_fn$fin$0 vfwprintf_helper$fin$0 vprintf_helper$fin$0 vwprintf_helper$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 48 48 83 C4 20 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "strcpy_s"
		size = 97
		refs = "0019 _errno 0025 _invalid_parameter_noinfo"
	strings:
		$1 = { 40 53 48 83 EC 20 48 85 C9 74 0D 48 85 D2 74 08 4D 85 C0 75 1C 44 88 01 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 4C 8B C9 4D 2B C8 41 8A 00 43 88 04 01 49 FF C0 84 C0 74 05 48 FF CA 75 ED 48 85 D2 75 0E 88 11 E8 ?? ?? ?? ?? BB 22 00 00 00 EB C5 33 C0 EB CA }
	condition:
		$1
}

rule file_152_4_0 {
	meta:
		name = "_tolower_l"
		size = 338
		refs = "001a ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 003f _isctype_l 00a0 _isleadbyte_l 00bc _errno 0111 __crtLCMapStringA"
	strings:
		$1 = { 48 89 7C 24 10 4C 89 74 24 20 55 48 8B EC 48 83 EC 70 48 63 F9 48 8D 4D E0 E8 ?? ?? ?? ?? 81 FF 00 01 00 00 73 5D 48 8B 55 E0 83 BA D4 00 00 00 01 7E 16 4C 8D 45 E0 BA 01 00 00 00 8B CF E8 ?? ?? ?? ?? 48 8B 55 E0 EB 0E 48 8B 82 08 01 00 00 0F B7 04 78 83 E0 01 85 C0 74 10 48 8B 82 10 01 00 00 0F B6 04 38 E9 C4 00 00 00 80 7D F8 00 74 0B 48 8B 45 F0 83 A0 C8 00 00 00 FD 8B C7 E9 BD 00 00 00 48 8B 45 E0 83 B8 D4 00 00 00 01 7E 2B 44 8B F7 48 8D 55 E0 41 C1 FE 08 41 0F B6 CE E8 ?? ?? ?? ?? 85 C0 74 13 44 88 75 10 40 88 7D 11 C6 45 12 00 B9 02 00 00 00 EB 18 E8 ?? ?? ?? ?? B9 01 00 00 00 C7 00 2A 00 00 00 40 88 7D 10 C6 45 11 00 48 8B 55 E0 C7 44 24 40 01 00 00 00 4C 8D 4D 10 8B 42 04 48 8B 92 38 01 00 00 41 B8 00 01 00 00 89 44 24 38 48 8D 45 20 C7 44 24 30 03 00 00 00 48 89 44 24 28 89 4C 24 20 48 8D 4D E0 E8 ?? ?? ?? ?? 85 C0 0F 84 4E FF FF FF 83 F8 01 0F B6 45 20 74 09 0F B6 4D 21 C1 E0 08 0B C1 80 7D F8 00 74 0B 48 8B 4D F0 83 A1 C8 00 00 00 FD 4C 8D 5C 24 70 49 8B 7B 18 4D 8B 73 28 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_152_5_0 {
	meta:
		name = "tolower"
		size = 30
		refs = "0002 __locale_changed 001a _tolower_l"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 0E 8D 41 BF 83 F8 19 77 03 83 C1 20 8B C1 C3 33 D2 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "bsearch"
		size = 240
		refs = "0042 _errno 004d _invalid_parameter_noinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 55 41 56 41 57 48 83 EC 20 49 8D 78 FF 45 33 F6 4D 8B F9 49 8B F0 48 8B DA 4C 8B E9 49 0F AF F9 48 03 FA 48 85 D2 75 36 4D 85 C0 74 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 20 41 5F 41 5E 41 5D C3 4D 85 C9 74 CA 4C 39 74 24 60 74 C3 48 3B D7 77 CE 48 8B EE 48 D1 ED 74 41 40 F6 C6 01 48 8D 75 FF 49 8B CD 48 0F 45 F5 4C 8B F6 4D 0F AF F7 4C 03 F3 49 8B D6 FF 54 24 60 85 C0 74 18 79 08 49 8B FE 49 2B FF EB 07 4B 8D 1C 3E 48 8B F5 48 3B DF 76 BE EB 8A 49 8B C6 EB 87 45 33 F6 48 85 F6 0F 84 79 FF FF FF 48 8B D3 49 8B CD FF 54 24 60 85 C0 49 0F 45 DE 48 8B C3 E9 63 FF FF FF }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "__static_scalar_sin"
		size = 1264
		refs = "000c __spec_table"
	strings:
		$1 = { 53 56 57 41 54 48 83 EC 58 48 8D 05 ?? ?? ?? ?? F2 0F 11 84 24 80 00 00 00 48 89 44 24 40 0F 29 74 24 30 0F 29 7C 24 20 F2 0F 10 84 24 80 00 00 00 4C 8B 64 24 40 66 0F C5 C0 03 25 F0 7F 00 00 3D F0 7F 00 00 0F 84 81 04 00 00 8B C8 81 E9 60 3F 00 00 C1 E9 07 81 E1 FC FF 00 00 4D 8D 9C 24 E0 00 00 00 49 03 CB 66 48 0F 7E C0 44 8B 51 14 44 8B 41 18 8B D0 48 C1 E8 15 0D 00 00 00 80 C1 E8 0B 45 8B CA 4C 0F AF D2 4C 0F AF C8 4C 0F AF C0 8B 71 10 8B 79 0C 45 8B DA 49 C1 EA 20 4D 03 CA 4D 03 D8 45 8B C3 49 C1 EB 20 4D 03 CB 44 8B D6 48 0F AF F2 4C 0F AF D0 44 8B DF 48 0F AF FA 8B DE 48 C1 EE 20 4C 03 CB 41 8B D9 49 C1 E9 20 4C 03 D6 4D 03 D1 48 C1 E3 20 4C 0B C3 4C 0F AF D8 44 8B 49 08 8B 71 04 8B DF 48 C1 EF 20 4C 03 D3 41 8B DA 49 C1 EA 20 4C 03 DF 4D 03 DA 49 8B F9 4C 0F AF CA 48 0F AF F8 45 8B D1 49 C1 E9 20 4D 03 DA 45 8B D3 49 C1 EB 20 49 03 F9 49 03 FB 4C 8B CE 48 0F AF F2 4C 0F AF C8 49 C1 E2 20 4C 0B D3 8B 01 44 8B DE 48 C1 EE 20 49 03 FB 44 8B DF 48 C1 EF 20 4C 03 CE 4C 03 CF 48 0F AF D0 66 0F C5 D8 03 49 8D BC 24 E0 00 00 00 48 2B CF 03 C9 03 C9 03 C9 83 C1 13 BE 00 80 00 00 23 F3 C1 EB 04 81 E3 FF 07 00 00 81 EB FF 03 00 00 2B CB 4C 03 CA 8B D1 83 C2 20 83 F9 01 0F 8C 89 02 00 00 F7 D9 83 C1 1D 41 D3 E1 41 8B F9 41 81 E1 FF FF FF 1F 41 F7 C1 00 00 00 10 0F 85 93 02 00 00 41 D3 E9 BB 00 00 00 00 49 C1 E1 20 4D 0B CB 49 83 F9 00 0F 84 F4 01 00 00 4D 0F BD D9 B9 1D 00 00 00 41 2B CB 0F 8E 1C 02 00 00 49 D3 E1 49 8B C2 49 D3 E2 03 D1 F7 D9 83 C1 40 48 D3 E8 49 D3 E8 4C 0B C8 4D 0B D0 F2 49 0F 2A C1 49 D1 EA F2 49 0F 2A DA 66 0F 57 E4 C1 E2 04 F7 DA 81 C2 F0 3F 00 00 0B D6 33 D3 66 0F C4 E2 03 F3 41 0F 7E 94 24 D0 00 00 00 F3 41 0F 7E B4 24 D8 00 00 00 66 0F 57 ED 81 EA F0 03 00 00 66 0F C4 EA 03 F2 0F 59 C4 C1 E6 10 C1 FE 1F F2 0F 59 DD F3 0F 7E C8 F2 0F 59 C2 C1 EF 1D F2 0F 58 CB F2 0F 59 DA 03 FE 33 FE F2 0F 59 F1 8B C7 F2 0F 58 F3 F3 0F 7E D0 F2 0F 58 C6 F2 0F 5C D0 F2 0F 58 F2 F3 41 0F 7E 4C 24 70 F2 0F 59 C8 F3 41 0F 7E 94 24 80 00 00 00 F2 0F 2D D1 F2 0F 58 CA F3 41 0F 7E 5C 24 50 F2 0F 5C CA 66 41 0F 28 54 24 40 F2 0F 59 D9 66 0F 14 C9 C1 E0 03 81 C2 00 76 1C 00 F3 0F 7E E0 03 D0 83 E2 3F 66 41 0F 28 6C 24 30 49 8D 84 24 90 01 00 00 C1 E2 05 48 03 C2 66 0F 59 D1 F2 0F 5C C3 F2 41 0F 59 4C 24 60 F2 0F 5C E3 F3 0F 7E 78 08 66 0F 14 C0 F3 0F 7E DC F2 0F 5C E2 66 0F 59 E8 66 0F 5C C2 F2 0F 59 FC F2 0F 5C DC 66 0F 59 E8 66 0F 59 C0 F2 0F 5C DA 66 0F 28 10 F2 0F 5C CB F3 0F 7E 58 18 F2 0F 58 D3 F2 0F 5C FA F2 0F 5C CE 66 41 0F 28 74 24 10 F2 0F 59 D4 66 0F 59 F0 F2 0F 59 DC 66 0F 59 D0 66 0F 59 C0 66 41 0F 58 6C 24 20 F2 0F 59 20 66 41 0F 58 34 24 66 0F 59 E8 F3 0F 7E C3 F2 0F 58 58 08 66 0F 59 CF F3 0F 7E FC F2 0F 58 E3 66 0F 58 F5 F3 0F 7E 68 08 F2 0F 5C EB F2 0F 5C DC F2 0F 58 48 10 66 0F 59 F2 F2 0F 58 E8 F2 0F 58 DF F2 0F 58 CD F2 0F 58 CB F2 0F 58 CE 66 0F 15 F6 F3 0F 7E C4 F2 0F 58 CE F2 0F 58 C1 E9 13 01 00 00 83 C2 40 4D 8B CA 4D 8B D0 49 C7 C0 00 00 00 00 49 83 F9 00 0F 85 F2 FD FF FF 83 C2 40 4D 8B CA 4D 8B D0 49 83 F9 00 0F 85 DF FD FF FF 66 0F 57 C0 66 0F 57 F6 E9 87 FE FF FF 0F 84 FA FD FF FF F7 D9 49 D3 EA 49 8B C1 49 D3 E9 2B D1 F7 D9 83 C1 40 48 D3 E0 4C 0B D0 E9 DD FD FF FF F7 D9 49 C1 E1 20 4D 0B CB 49 D3 E1 49 8B F9 41 F7 C1 00 00 00 80 75 56 41 D3 E9 BB 00 00 00 00 48 C1 EF 03 E9 7C FD FF FF 41 D3 E9 BB 00 00 00 20 D3 EB 49 C1 E1 20 4D 0B CB 48 C1 E3 20 81 C7 00 00 00 20 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 E9 37 FD FF FF 41 D3 E9 48 BB 00 00 00 00 01 00 00 00 48 D3 EB 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 48 C1 EF 03 81 C7 00 00 00 20 E9 F3 FC FF FF F2 0F 5C C0 F2 0F 11 44 24 48 0F 28 74 24 30 0F 28 7C 24 20 F2 0F 10 44 24 48 48 83 C4 58 41 5C 5F 5E 5B C3 }
	condition:
		$1
}

rule file_154_1_0 {
	meta:
		name = "__sse2_sin2"
		size = 1216
		refs = "001f MMDPI1 002b MMDINVPI 0033 MMIABSMASK 003b MMDPI2 0043 MMDPI3 004b MMDRSHIFT 005f MMDHUGE 0073 MMDPI4 00a8 MMDA8 00b0 MMDA7 00cc MMDA6 00d4 MMDA5 00e4 MMDA4 00ec MMDA3 00fc MMDA2 0104 MMDA1 014f flAllOnes 015d MMISIGNMASK 0177 TWO_POW_30 01f8 THE_PI02_INV 020d MMI_ONE 0215 MSK_LOW_BIT 021d RS 0231 PI02C_0 023d PI02C_1 024d PI02C_2 027e PI02C_3 02aa PI02C_4"
	strings:
		$1 = { 48 81 EC D8 00 00 00 0F 29 BC 24 C0 00 00 00 0F 29 B4 24 B0 00 00 00 66 0F 28 F8 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 D0 66 0F 59 05 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 58 05 ?? ?? ?? ?? 66 0F 28 D8 66 0F 5C 05 ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 66 0F 50 C7 0B C0 0F 85 C9 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 73 F3 3F 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 28 CA 66 0F 59 D2 66 0F 5C CF 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 E2 66 0F 59 E4 66 0F 59 D1 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F2 66 0F 59 C1 66 0F 58 F1 66 0F 58 C6 66 0F 57 C3 0F 28 B4 24 B0 00 00 00 0F 28 BC 24 C0 00 00 00 48 81 C4 D8 00 00 00 C3 C7 44 24 20 00 00 00 00 66 0F 70 FF F5 66 0F 29 7C 24 30 66 0F 57 3D ?? ?? ?? ?? 66 0F 29 7C 24 40 66 0F 28 3D ?? ?? ?? ?? 66 0F 54 FA 66 0F 29 54 24 50 66 0F 54 15 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 66 CA 66 0F 50 D1 66 0F 29 7C 24 60 66 0F 29 54 24 70 83 F2 03 0F 85 E0 01 00 00 83 F8 03 74 57 66 0F 28 54 24 50 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 73 F3 3F 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 54 5C 24 40 66 0F 5C D7 66 0F 54 54 24 40 66 0F 29 9C 24 80 00 00 00 66 0F 29 94 24 90 00 00 00 66 0F 28 54 24 70 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DA 66 0F E6 DB 66 0F 70 DB 10 66 0F FE 1D ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 C3 66 0F 5C 05 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E0 66 0F 5C D1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 CA 66 0F 5C D4 66 0F 5C CA 66 0F 28 F2 66 0F 5C CC 66 0F 5C D5 66 0F 73 F3 3E 66 0F 5C F2 66 0F 28 FA 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 D1 66 0F 59 E0 66 0F 5C FA 66 0F 28 EA 66 0F 5C D4 66 0F 58 CF 66 0F 5C EA 66 0F 59 05 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C C8 66 0F DB 1D ?? ?? ?? ?? 66 0F 58 D1 66 0F 57 5C 24 60 83 F8 03 74 1E 66 0F 54 54 24 30 66 0F 56 94 24 90 00 00 00 66 0F 54 5C 24 30 66 0F 56 9C 24 80 00 00 00 66 0F 28 CA 66 0F 59 D2 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 E2 66 0F 59 E4 66 0F 59 D1 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F2 66 0F 59 C1 66 0F 58 F1 66 0F 58 C6 66 0F 57 C3 E9 EA 00 00 00 89 44 24 20 83 F8 03 0F 84 C0 00 00 00 66 0F 28 54 24 50 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 73 F3 3F 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 28 CA 66 0F 59 D2 66 0F 5C CF 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 E2 66 0F 59 E4 66 0F 59 D1 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F2 66 0F 59 C1 66 0F 58 F1 66 0F 58 C6 66 0F 57 C3 66 0F 29 84 24 A0 00 00 00 8B 44 24 20 A8 01 75 4B D1 F8 A8 01 75 27 D1 F8 89 44 24 20 66 0F 28 84 24 A0 00 00 00 0F 28 B4 24 B0 00 00 00 0F 28 BC 24 C0 00 00 00 48 81 C4 D8 00 00 00 C3 F2 0F 10 44 24 58 89 44 24 20 E8 87 F6 FF FF F2 0F 11 84 24 A8 00 00 00 8B 44 24 20 EB BB F2 0F 10 44 24 50 E8 6D F6 FF FF F2 0F 11 84 24 A0 00 00 00 8B 44 24 20 EB 9B 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "_heap_alloc"
		size = 80
		refs = "000c _crtheap 0016 _FF_MSGBANNER 0020 _NMSG_WRITE 002a __crtExitProcess 004c __imp_HeapAlloc"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 0D ?? ?? ?? ?? 48 85 C9 75 20 E8 ?? ?? ?? ?? B9 1E 00 00 00 E8 ?? ?? ?? ?? B9 FF 00 00 00 E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 85 DB 41 B8 01 00 00 00 4C 0F 45 C3 33 D2 48 83 C4 20 5B 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_155_1_0 {
	meta:
		name = "malloc"
		size = 182
		refs = "0027 _crtheap 0031 _FF_MSGBANNER 003b _NMSG_WRITE 0045 __crtExitProcess 0057 __imp_HeapAlloc 0065 _newmode 006f _callnewh 007a _errno"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B D9 48 83 F9 E0 77 7C BF 01 00 00 00 48 85 C9 48 0F 45 F9 48 8B 0D ?? ?? ?? ?? 48 85 C9 75 20 E8 ?? ?? ?? ?? B9 1E 00 00 00 E8 ?? ?? ?? ?? B9 FF 00 00 00 E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 4C 8B C7 33 D2 FF 15 ?? ?? ?? ?? 48 8B F0 48 85 C0 75 2C 39 05 ?? ?? ?? ?? 74 0E 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 0D EB AB E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 48 8B C6 EB 12 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "_execve"
		size = 633
		refs = "002e _errno 0039 _invalid_parameter_noinfo 0073 _mbsrchr 009e _mbschr 00ae strlen 00bd _calloc_crt 00d0 ??_C@_02CEGDFPFP@?4?2?$AA@ 00db strcpy_s 00f1 strcat_s 012a _access_s 0140 comexecmd 01a4 ext_strings 020a free 0234 _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 10 4C 89 44 24 18 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 30 45 33 E4 4D 8B F0 4C 8B FA 48 8B E9 48 8B F9 48 85 C9 75 29 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF 48 8B 5C 24 78 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 44 38 21 74 D2 48 85 D2 74 CD 48 8B 02 48 85 C0 74 C5 44 38 20 74 C0 BA 5C 00 00 00 E8 ?? ?? ?? ?? BA 2F 00 00 00 48 8B CD 48 8B F0 E8 ?? ?? ?? ?? 41 BD 01 00 00 00 48 85 C0 75 71 48 85 F6 75 79 8D 50 3A 48 8B CD E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 75 66 48 8B CD E8 ?? ?? ?? ?? 41 8B D5 48 8D 58 03 48 8B CB E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 0F 84 70 FF FF FF 4C 8D 05 ?? ?? ?? ?? 48 8B D3 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 52 01 00 00 4C 8B C5 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 85 C0 0F 85 27 01 00 00 48 8D 77 02 EB 0D 48 85 F6 74 05 48 3B C6 76 03 48 8B F0 48 83 CB FF 48 8B CE 8D 53 2F E8 ?? ?? ?? ?? 48 8B CF 48 85 C0 74 25 33 D2 E8 ?? ?? ?? ?? 85 C0 0F 85 D8 00 00 00 4D 8B C6 49 8B D7 48 8B CF E8 ?? ?? ?? ?? 48 8B D8 E9 C2 00 00 00 E8 ?? ?? ?? ?? 49 8B D5 4C 8D 70 05 49 8B CE E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 75 08 48 8B C3 E9 D1 FE FF FF 4C 8B C7 49 8B D6 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 DE 00 00 00 48 8B CF E8 ?? ?? ?? ?? 4C 8D 24 06 E8 ?? ?? ?? ?? 4D 2B F4 44 8B 28 49 8D 04 36 4C 8D 35 ?? ?? ?? ?? 48 89 44 24 70 4D 8B 06 48 8B D0 49 8B CC E8 ?? ?? ?? ?? 85 C0 0F 85 8B 00 00 00 33 D2 48 8B CE E8 ?? ?? ?? ?? 85 C0 74 17 48 8D 05 ?? ?? ?? ?? 49 83 EE 08 4C 3B F0 48 8B 44 24 70 7D C7 EB 1E E8 ?? ?? ?? ?? 4C 8B 84 24 80 00 00 00 49 8B D7 48 8B CE 44 89 28 E8 ?? ?? ?? ?? 48 8B D8 48 8B CE E8 ?? ?? ?? ?? 48 3B FD 0F 84 51 FF FF FF 48 8B CF E8 ?? ?? ?? ?? E9 44 FF FF FF 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 64 24 20 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 64 24 20 E8 ?? ?? ?? ?? CC 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 64 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_156_2_0 {
	meta:
		name = "comexecmd"
		size = 133
		refs = "0015 _errno 0020 _invalid_parameter_noinfo 0045 _cenvarg 0061 _dospawn 006e free"
	strings:
		$1 = { 40 53 48 83 EC 30 4D 8B D0 48 8B C2 48 8B D9 48 85 C9 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 55 48 85 C0 74 E5 48 89 4C 24 20 4C 8D 4C 24 58 4C 8D 44 24 40 49 8B D2 48 8B C8 E8 ?? ?? ?? ?? 83 F8 FF 74 D6 4C 8B 4C 24 58 4C 8B 44 24 40 48 8B D3 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 8B D8 E8 ?? ?? ?? ?? 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_294_2_0 {
	meta:
		name = "wcomexecmd"
		size = 133
		refs = "0015 _errno 0020 _invalid_parameter_noinfo 0045 _wcenvarg 0061 _wdospawn 006e free"
	strings:
		$1 = { 40 53 48 83 EC 30 4D 8B D0 48 8B C2 48 8B D9 48 85 C9 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 55 48 85 C0 74 E5 48 89 4C 24 20 4C 8D 4C 24 58 4C 8D 44 24 40 49 8B D2 48 8B C8 E8 ?? ?? ?? ?? 83 F8 FF 74 D6 4C 8B 4C 24 58 4C 8B 44 24 40 48 8B D3 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 8B D8 E8 ?? ?? ?? ?? 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_157_5_0 {
	meta:
		name = "vfscanf_fn"
		size = 286
		refs = "0033 _errno 003e _invalid_parameter_noinfo 005a _lock_file 006d _fileno 007b __pioinfo 009c __badioinfo 0104 _unlock_file"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 18 48 89 54 24 10 57 41 56 41 57 48 83 EC 20 4D 8B F1 49 8B F0 48 8B FA 4C 8B F9 33 DB 33 C0 48 85 D2 0F 95 C0 85 C0 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 C0 00 00 00 33 C0 4D 85 C0 0F 95 C0 85 C0 74 DC 48 8B CA E8 ?? ?? ?? ?? 90 F6 47 18 40 0F 85 80 00 00 00 48 8B CF E8 ?? ?? ?? ?? 4C 63 C0 41 8D 48 02 4C 8D 0D ?? ?? ?? ?? 83 F9 01 76 1E 49 8B D0 49 8B C8 48 C1 F9 05 83 E2 1F 48 6B C2 58 49 03 04 C9 48 8D 0D ?? ?? ?? ?? EB 0A 48 8D 0D ?? ?? ?? ?? 48 8B C1 F6 40 38 7F 75 24 41 8D 40 02 83 F8 01 76 15 49 8B C8 49 8B C0 48 C1 F8 05 83 E1 1F 48 6B C9 58 49 03 0C C1 F6 41 38 80 74 13 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 CB FF 85 DB 75 13 4C 8B 4C 24 60 4D 8B C6 48 8B D6 48 8B CF 41 FF D7 8B D8 48 8B CF E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 40 48 8B 74 24 50 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "_lock"
		size = 68
		refs = "0010 _locktable 001f _mtinitlocknum 002b _amsg_exit 0040 __imp_EnterCriticalSection"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 63 D9 48 8D 3D ?? ?? ?? ?? 48 03 DB 48 83 3C DF 00 75 11 E8 ?? ?? ?? ?? 85 C0 75 08 8D 48 11 E8 ?? ?? ?? ?? 48 8B 0C DF 48 8B 5C 24 30 48 83 C4 20 5F 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_1_0 {
	meta:
		name = "_lockerr_exit"
		size = 44
		refs = "000a __crtIsPackagedApp 0019 __imp_FatalAppExitA 0028 __crtExitProcess"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 85 C0 75 0B 48 8B D3 33 C9 FF 15 ?? ?? ?? ?? B9 FF 00 00 00 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_2_0 {
	meta:
		name = "_mtdeletelocks"
		size = 135
		refs = "001c _locktable 0035 __imp_DeleteCriticalSection 003d free"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 BF 24 00 00 00 48 8D 1D ?? ?? ?? ?? 8B EF 48 8B 33 48 85 F6 74 1B 83 7B 08 01 74 15 48 8B CE FF 15 ?? ?? ?? ?? 48 8B CE E8 ?? ?? ?? ?? 48 83 23 00 48 83 C3 10 48 FF CD 75 D4 48 8D 1D ?? ?? ?? ?? 48 8B 4B F8 48 85 C9 74 0B 83 3B 01 75 06 FF 15 ?? ?? ?? ?? 48 83 C3 10 48 FF CF 75 E3 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_3_0 {
	meta:
		name = "_mtinitlocknum"
		size = 189
		refs = "0016 _crtheap 001e _FF_MSGBANNER 0028 _NMSG_WRITE 0032 __crtExitProcess 003c _locktable 0054 _malloc_crt 0061 _errno 0075 _lock 008d __crtInitializeCriticalSectionEx 0098 free 00a6 __imp_LeaveCriticalSection"
	strings:
		$1 = { 48 89 5C 24 08 48 89 7C 24 10 41 56 48 83 EC 20 48 63 D9 48 83 3D ?? ?? ?? ?? 00 75 19 E8 ?? ?? ?? ?? B9 1E 00 00 00 E8 ?? ?? ?? ?? B9 FF 00 00 00 E8 ?? ?? ?? ?? 48 03 DB 4C 8D 35 ?? ?? ?? ?? 49 83 3C DE 00 74 07 B8 01 00 00 00 EB 5E B9 28 00 00 00 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 3D B9 0A 00 00 00 E8 ?? ?? ?? ?? 90 48 8B CF 49 83 3C DE 00 75 13 45 33 C0 BA A0 0F 00 00 E8 ?? ?? ?? ?? 49 89 3C DE EB 06 E8 ?? ?? ?? ?? 90 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? EB 9B 48 8B 5C 24 30 48 8B 7C 24 38 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_158_4_0 {
	meta:
		name = "_mtinitlocknum$fin$0"
		size = 29
		refs = "000c _locktable 0018 __imp_LeaveCriticalSection"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 0D ?? ?? ?? ?? 48 83 C4 20 5D 48 FF 25 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_158_5_0 {
	meta:
		name = "_mtinitlocks"
		size = 97
		refs = "0014 _locktable 0027 lclcritsects 0041 __crtInitializeCriticalSectionEx"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 F6 48 8D 1D ?? ?? ?? ?? 8D 7E 24 83 7B 08 01 75 24 48 63 C6 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0C 80 FF C6 48 8D 0C CA BA A0 0F 00 00 48 89 0B E8 ?? ?? ?? ?? 48 83 C3 10 48 FF CF 75 CD 48 8B 5C 24 30 48 8B 74 24 38 8D 47 01 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_158_6_0 {
	meta:
		name = "_unlock"
		size = 24
		refs = "0006 _locktable 0014 __imp_LeaveCriticalSection"
	strings:
		$1 = { 48 63 C9 48 8D 05 ?? ?? ?? ?? 48 03 C9 48 8B 0C C8 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "__dyn_tls_init"
		size = 66
		refs = "0012 __xd_a 0019 __xd_z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 83 FA 02 75 23 48 8D 1D ?? ?? ?? ?? 48 8D 3D ?? ?? ?? ?? EB 0E 48 8B 03 48 85 C0 74 02 FF D0 48 83 C3 08 48 3B DF 75 ED B8 01 00 00 00 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "__sse4_floor2"
		size = 16
	strings:
		$1 = { 66 0F 3A 09 C0 01 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_162_6_0 {
	meta:
		name = "_vcwprintf_s_l"
		size = 2748
		refs = "0022 __security_cookie 0067 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 006c _errno 008d _invalid_parameter_noinfo 00fd __lookuptable_s 026d __nullstring 0275 strlen 02dd _isleadbyte_l 034c _mbtowc_l 03f8 __wnullstring 0483 _get_printf_count_output 060a _malloc_crt 0631 _cfltcvt_tab 064b __imp_DecodePointer 0740 write_multi_char 0755 write_string 07b5 _putwch_nolock 083b free 089d __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 10 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 30 FC FF FF 48 81 EC D0 04 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 C0 03 00 00 33 C0 48 89 4C 24 78 48 8D 4D 80 4D 8B E0 4C 89 44 24 50 89 44 24 70 44 8B F0 89 44 24 58 8B F8 89 44 24 40 89 44 24 4C 89 44 24 74 89 44 24 6C 8B D8 89 44 24 44 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 54 24 78 45 33 D2 48 89 45 A8 48 85 D2 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C9 38 4D 98 74 0B 48 8B 45 90 83 A0 C8 00 00 00 FD 83 C8 FF E9 E7 07 00 00 44 0F B7 3A 41 8B F2 44 89 54 24 48 45 8B EA 45 8B C2 4C 89 55 A0 66 45 85 FF 0F 84 B4 07 00 00 41 BB 20 00 00 00 41 B9 00 02 00 00 48 83 C2 02 48 89 54 24 78 85 F6 0F 88 88 07 00 00 41 0F B7 C7 B9 58 00 00 00 66 41 2B C3 66 3B C1 77 15 48 8D 0D ?? ?? ?? ?? 41 0F B7 C7 0F B6 4C 08 E0 83 E1 0F EB 03 41 8B CA 48 63 C1 48 8D 0C C0 49 63 C0 48 03 C8 48 8D 05 ?? ?? ?? ?? 44 0F B6 04 01 41 C1 E8 04 44 89 44 24 60 41 83 F8 08 0F 84 43 FF FF FF 41 8B C8 45 85 C0 0F 84 1A 08 00 00 FF C9 0F 84 3B 09 00 00 FF C9 0F 84 D8 08 00 00 FF C9 0F 84 8E 08 00 00 FF C9 0F 84 79 08 00 00 FF C9 0F 84 36 08 00 00 FF C9 0F 84 42 07 00 00 FF C9 0F 85 E0 06 00 00 41 0F B7 CF 83 F9 64 0F 8F 13 02 00 00 0F 84 1A 03 00 00 83 F9 41 0F 84 D0 01 00 00 83 F9 43 0F 84 54 01 00 00 8D 41 BB A9 FD FF FF FF 0F 84 B9 01 00 00 83 F9 53 0F 84 C6 00 00 00 B8 58 00 00 00 3B C8 0F 84 63 02 00 00 83 F9 5A 74 4F 83 F9 61 0F 84 A1 01 00 00 83 F9 63 0F 84 25 01 00 00 44 8B 7C 24 44 BF 2D 00 00 00 44 39 54 24 6C 0F 85 31 06 00 00 41 F6 C6 40 0F 84 1D 05 00 00 41 0F BA E6 08 0F 83 E4 04 00 00 66 89 7C 24 5C BF 01 00 00 00 89 7C 24 4C E9 03 05 00 00 49 8B 04 24 49 83 C4 08 4C 89 64 24 50 48 85 C0 74 39 48 8B 58 08 48 85 DB 74 30 BF 2D 00 00 00 41 0F BA E6 0B 73 16 0F BF 00 44 8D 7F D4 99 44 89 7C 24 44 2B C2 D1 F8 44 8B E8 EB 90 44 0F BF 28 45 8B FA 44 89 54 24 44 EB 82 48 8B 1D ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 45 33 D2 4C 8B E8 E9 5E FF FF FF 41 F7 C6 30 08 00 00 75 03 45 0B F3 83 7C 24 40 FF 49 8B 1C 24 B8 FF FF FF 7F 0F 44 F8 49 83 C4 08 4C 89 64 24 50 45 84 F3 0F 84 38 01 00 00 48 85 DB 45 8B EA 48 0F 44 1D ?? ?? ?? ?? 48 8B F3 85 FF 0F 8E 15 04 00 00 44 38 16 0F 84 0D FF FF FF 0F B6 0E 48 8D 55 80 E8 ?? ?? ?? ?? 45 33 D2 85 C0 74 03 48 FF C6 41 FF C5 48 FF C6 44 3B EF 7C D6 E9 E7 FE FF FF 41 F7 C6 30 08 00 00 75 03 45 0B F3 41 0F B7 04 24 49 83 C4 08 41 BF 01 00 00 00 66 89 44 24 64 44 89 7C 24 44 4C 89 64 24 50 45 84 F3 74 34 88 44 24 68 48 8B 45 80 44 88 54 24 69 4C 63 80 D4 00 00 00 4C 8D 4D 80 48 8D 54 24 68 48 8D 4D C0 E8 ?? ?? ?? ?? 45 33 D2 85 C0 79 0B 44 89 7C 24 6C EB 04 66 89 45 C0 48 8D 5D C0 45 8B EF E9 79 FE FF FF C7 44 24 74 01 00 00 00 66 45 03 FB B8 67 00 00 00 41 83 CE 40 48 8D 5D C0 41 8B F1 85 FF 0F 89 45 02 00 00 41 BD 06 00 00 00 44 89 6C 24 40 E9 88 02 00 00 B8 67 00 00 00 3B C8 7E D4 83 F9 69 0F 84 FB 00 00 00 83 F9 6E 0F 84 B8 00 00 00 83 F9 6F 0F 84 9A 00 00 00 83 F9 70 74 59 83 F9 73 0F 84 BC FE FF FF 83 F9 75 0F 84 D6 00 00 00 83 F9 78 0F 85 FC FD FF FF 8D 41 AF EB 48 48 85 DB 41 BF 01 00 00 00 48 0F 44 1D ?? ?? ?? ?? 44 89 7C 24 44 48 8B C3 EB 0C FF CF 66 44 39 10 74 08 48 83 C0 02 85 FF 75 F0 48 2B C3 48 D1 F8 44 8B E8 E9 C3 FD FF FF BF 10 00 00 00 41 0F BA EE 0F B8 07 00 00 00 41 B9 10 00 00 00 89 44 24 70 BE 00 02 00 00 45 8D 79 20 45 84 F6 79 79 66 83 C0 51 66 44 89 7C 24 5C 41 8D 51 F2 66 89 44 24 5E EB 68 41 B9 08 00 00 00 45 84 F6 79 4E BE 00 02 00 00 44 0B F6 EB 49 49 8B 3C 24 49 83 C4 08 4C 89 64 24 50 E8 ?? ?? ?? ?? 45 33 D2 85 C0 0F 84 EF FB FF FF 45 8D 5A 20 45 84 F3 74 05 66 89 37 EB 02 89 37 C7 44 24 6C 01 00 00 00 E9 7F 03 00 00 41 83 CE 40 41 B9 0A 00 00 00 BE 00 02 00 00 41 BF 30 00 00 00 8B 54 24 4C B8 00 80 00 00 44 85 F0 74 0A 4D 8B 04 24 49 83 C4 08 EB 3D 41 0F BA E6 0C 72 EF 49 83 C4 08 45 84 F3 74 1B 4C 89 64 24 50 41 F6 C6 40 74 08 4D 0F BF 44 24 F8 EB 1F 45 0F B7 44 24 F8 EB 17 41 F6 C6 40 74 07 4D 63 44 24 F8 EB 05 45 8B 44 24 F8 4C 89 64 24 50 41 F6 C6 40 74 0D 4D 85 C0 79 08 49 F7 D8 41 0F BA EE 08 44 85 F0 75 0A 41 0F BA E6 0C 72 03 45 8B C0 85 FF 79 07 BF 01 00 00 00 EB 09 41 83 E6 F7 3B FE 0F 4F FE 44 8B 64 24 70 49 8B C0 48 8D 9D BF 01 00 00 48 F7 D8 1B C9 23 CA 89 4C 24 4C 8B CF FF CF 85 C9 7F 05 4D 85 C0 74 20 33 D2 49 8B C0 49 63 C9 48 F7 F1 4C 8B C0 8D 42 30 83 F8 39 7E 03 41 03 C4 88 03 48 FF CB EB D3 4C 8B 64 24 50 48 8D 85 BF 01 00 00 89 7C 24 40 2B C3 48 FF C3 44 8B E8 44 85 F6 0F 84 26 FC FF FF 85 C0 74 09 44 38 3B 0F 84 19 FC FF FF 48 FF CB 41 FF C5 44 88 3B E9 0B FC FF FF 75 11 66 44 3B F8 75 41 41 BD 01 00 00 00 E9 AE FD FF FF 41 3B F9 41 BD A3 00 00 00 41 0F 4F F9 89 7C 24 40 41 3B FD 7E 27 81 C7 5D 01 00 00 48 63 CF E8 ?? ?? ?? ?? 48 89 45 A0 48 85 C0 0F 84 7D FD FF FF 48 8B D8 8B F7 44 8B 6C 24 40 EB 03 44 8B EF 49 8B 04 24 48 8B 0D ?? ?? ?? ?? 49 83 C4 08 4C 89 64 24 50 41 0F BE FF 48 63 F6 48 89 45 B0 FF 15 ?? ?? ?? ?? 48 8D 4D 80 48 89 4C 24 30 8B 4C 24 74 44 8B CF 89 4C 24 28 48 8D 4D B0 4C 8B C6 48 8B D3 44 89 6C 24 20 FF D0 41 8B FE 81 E7 80 00 00 00 74 1B 45 85 ED 75 16 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 55 80 48 8B CB FF D0 B9 67 00 00 00 66 44 3B F9 75 1A 85 FF 75 16 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 55 80 48 8B CB FF D0 BF 2D 00 00 00 40 38 3B 75 08 41 0F BA EE 08 48 FF C3 48 8B CB E8 ?? ?? ?? ?? 45 33 D2 44 8B E8 EB 05 BF 2D 00 00 00 44 8B 7C 24 44 E9 FC FA FF FF 41 F6 C6 01 74 0F B8 2B 00 00 00 66 89 44 24 5C E9 0C FB FF FF 41 F6 C6 02 74 13 B8 20 00 00 00 66 89 44 24 5C 8D 78 E1 89 7C 24 4C EB 09 8B 7C 24 4C B8 20 00 00 00 8B 74 24 58 41 2B F5 2B F7 41 F6 C6 0C 75 0E 4C 8D 44 24 48 8B C8 8B D6 E8 ?? ?? ?? ?? 4C 8B 4D A8 4C 8D 44 24 48 48 8D 4C 24 5C 8B D7 E8 ?? ?? ?? ?? 41 F6 C6 08 74 17 41 F6 C6 04 75 11 4C 8D 44 24 48 B9 30 00 00 00 8B D6 E8 ?? ?? ?? ?? 45 85 FF 75 74 45 85 ED 7E 6F 48 8B FB 45 8B FD 48 8B 45 80 4C 8D 4D 80 48 8D 4C 24 64 4C 63 80 D4 00 00 00 48 8B D7 41 FF CF E8 ?? ?? ?? ?? 45 33 D2 4C 63 E0 85 C0 7E 32 0F B7 4C 24 64 E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 75 09 83 C9 FF 89 4C 24 48 EB 08 FF 44 24 48 8B 4C 24 48 49 03 FC 45 33 D2 45 85 FF 7F A7 EB 07 83 C9 FF 89 4C 24 48 4C 8B 64 24 50 EB 1B 4C 8B 4D A8 4C 8D 44 24 48 41 8B D5 48 8B CB E8 ?? ?? ?? ?? 8B 4C 24 48 45 33 D2 85 C9 78 1A 41 F6 C6 04 74 14 4C 8D 44 24 48 B9 20 00 00 00 8B D6 E8 ?? ?? ?? ?? 45 33 D2 41 BB 20 00 00 00 48 8B 45 A0 48 85 C0 74 13 48 8B C8 E8 ?? ?? ?? ?? 45 33 D2 45 8D 5A 20 4C 89 55 A0 44 8B 44 24 60 48 8B 54 24 78 8B 74 24 48 8B 7C 24 40 41 B9 00 02 00 00 44 0F B7 3A 66 45 85 FF 0F 85 67 F8 FF FF 45 85 C0 74 0A 41 83 F8 07 0F 85 02 F8 FF FF 44 38 55 98 74 0B 48 8B 4D 90 83 A1 C8 00 00 00 FD 8B C6 48 8B 8D C0 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 18 05 00 00 48 81 C4 D0 04 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 41 0F B7 C7 83 F8 49 74 3E 83 F8 68 74 31 B9 6C 00 00 00 3B C1 74 0C 83 F8 77 75 8A 41 0F BA EE 0B EB 83 66 39 0A 75 0E 48 83 C2 02 41 0F BA EE 0C E9 70 FF FF FF 41 83 CE 10 E9 67 FF FF FF 45 0B F3 E9 5F FF FF FF 0F B7 02 41 0F BA EE 0F 66 83 F8 36 75 15 66 83 7A 02 34 75 0E 48 83 C2 04 41 0F BA EE 0F E9 3C FF FF FF 66 83 F8 33 75 15 66 83 7A 02 32 75 0E 48 83 C2 04 41 0F BA F6 0F E9 21 FF FF FF 66 83 E8 58 66 41 3B C3 77 14 48 B9 01 10 82 20 01 00 00 00 48 0F A3 C1 0F 82 03 FF FF FF 44 89 54 24 60 41 0F B7 CF C7 44 24 44 01 00 00 00 E8 ?? ?? ?? ?? 48 8B 54 24 78 44 8B 44 24 60 B9 FF FF 00 00 41 BB 20 00 00 00 41 B9 00 02 00 00 66 3B C1 0F 85 1C 01 00 00 83 CE FF 89 74 24 48 45 33 D2 E9 BA FE FF FF 66 41 83 FF 2A 75 1E 41 8B 3C 24 49 83 C4 08 4C 89 64 24 50 89 7C 24 40 85 FF 0F 89 9A FE FF FF 83 CF FF EB 0D 8D 3C BF 41 0F B7 C7 8D 7F E8 8D 3C 78 89 7C 24 40 E9 7F FE FF FF 41 8B FA 44 89 54 24 40 E9 72 FE FF FF 66 41 83 FF 2A 75 21 41 8B 04 24 49 83 C4 08 4C 89 64 24 50 89 44 24 58 85 C0 0F 89 52 FE FF FF 41 83 CE 04 F7 D8 EB 11 8B 44 24 58 8D 0C 80 41 0F B7 C7 8D 04 48 83 C0 D0 89 44 24 58 E9 30 FE FF FF 41 0F B7 C7 41 3B C3 74 49 83 F8 23 74 3A B9 2B 00 00 00 3B C1 74 28 B9 2D 00 00 00 3B C1 74 16 B9 30 00 00 00 3B C1 0F 85 03 FE FF FF 41 83 CE 08 E9 FA FD FF FF 41 83 CE 04 E9 F1 FD FF FF 41 83 CE 01 E9 E8 FD FF FF 41 0F BA EE 07 E9 DE FD FF FF 41 83 CE 02 E9 D5 FD FF FF 83 CF FF 44 89 54 24 74 44 89 54 24 6C 44 89 54 24 58 44 89 54 24 4C 45 8B F2 89 7C 24 40 44 89 54 24 44 E9 AD FD FF FF FF C6 E9 E0 FE FF FF }
	condition:
		$1
}

rule file_162_9_0 {
	meta:
		name = "write_char"
		size = 37
		refs = "000a _putwch_nolock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B DA E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 75 05 83 0B FF EB 02 FF 03 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_162_10_0 {
	meta:
		name = "write_multi_char"
		size = 79
		refs = "0021 _putwch_nolock"
	strings:
		$1 = { 85 D2 7E 4A 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 49 8B D8 8B FA 0F B7 F1 0F B7 CE FF CF E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 74 0D FF 03 83 3B FF 74 09 85 FF 7E 05 EB DF 83 0B FF 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_162_11_0 {
	meta:
		name = "write_string"
		size = 149
		refs = "003b _putwch_nolock"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 56 48 83 EC 20 41 8B 29 41 83 21 00 49 8B F9 49 8B D8 8B F2 4C 8B F1 85 D2 7E 4C 41 BC FF FF 00 00 41 0F B7 0E FF CE E8 ?? ?? ?? ?? 66 41 3B C4 75 05 83 0B FF EB 02 FF 03 49 83 C6 02 83 3B FF 75 1C 83 3F 2A 75 1B B9 3F 00 00 00 E8 ?? ?? ?? ?? 66 41 3B C4 75 05 83 0B FF EB 02 FF 03 85 F6 7F BF 83 3F 00 75 02 89 2F 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 20 41 5E 41 5C 5F C3 }
	condition:
		$1
}

rule file_163_11_0 {
	meta:
		name = "??0SchedulerProxy@details@Concurrency@@QEAA@PEAUIScheduler@2@PEAVResourceManager@12@AEBVSchedulerPolicy@2@@Z"
		size = 655
		refs = "0026 ??_7SchedulerProxy@details@Concurrency@@6B@ 003c ??0_ReentrantBlockingLock@details@Concurrency@@QEAA@XZ 007e ?GetPolicyValue@SchedulerPolicy@Concurrency@@QEBAIW4PolicyElementKey@2@@Z 00f1 __imp_GetCurrentThread 00f9 ?__GetThreadPriority@platform@details@Concurrency@@YAHPEAX@Z 0116 ?GetCoreCount@ResourceManager@details@Concurrency@@SAIXZ 0209 ??2@YAPEAX_K@Z 0227 ??0HillClimbing@details@Concurrency@@QEAA@IIPEAVSchedulerProxy@12@@Z 0235 ?GetProcessorNodeCount@Concurrency@@YAIXZ 025c ??_U@YAPEAX_K@Z"
	strings:
		$1 = { 48 89 4C 24 08 55 56 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 60 49 8B F9 48 8B DA 48 8B F1 48 8D 05 ?? ?? ?? ?? 48 89 01 33 ED 48 89 69 08 4C 89 41 18 48 83 C1 40 E8 ?? ?? ?? ?? 90 48 89 6E 68 89 AE A8 00 00 00 48 89 AE CC 00 00 00 48 89 AE D8 00 00 00 48 89 AE E0 00 00 00 89 AE E8 00 00 00 89 AE F8 00 00 00 48 89 AE 00 01 00 00 48 89 5E 10 8D 55 01 48 8B CF E8 ?? ?? ?? ?? 89 86 BC 00 00 00 8D 55 02 48 8B CF E8 ?? ?? ?? ?? 89 86 B8 00 00 00 8D 55 03 48 8B CF E8 ?? ?? ?? ?? 89 86 C0 00 00 00 8D 55 05 48 8B CF E8 ?? ?? ?? ?? 89 86 C4 00 00 00 8D 55 06 48 8B CF E8 ?? ?? ?? ?? 89 86 C8 00 00 00 8D 55 08 48 8B CF E8 ?? ?? ?? ?? 83 F8 01 0F 94 C0 88 86 08 01 00 00 81 BE C8 00 00 00 00 F0 00 00 75 17 FF 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 0F BE C8 89 8E C8 00 00 00 48 8B 4E 10 48 8B 01 FF 10 89 86 AC 00 00 00 E8 ?? ?? ?? ?? 8B D8 89 86 EC 00 00 00 8B 8E C0 00 00 00 44 8B 96 BC 00 00 00 41 8D 42 FF 03 C3 33 D2 F7 F3 3B C8 73 0E 89 86 C0 00 00 00 89 9E B0 00 00 00 EB 10 8D 41 FF 41 03 C2 33 D2 F7 F1 89 86 B0 00 00 00 44 8B 86 B0 00 00 00 33 D2 41 8B C2 41 F7 F0 44 8B C8 85 D2 75 1F 89 86 C0 00 00 00 44 89 86 D4 00 00 00 8B 86 B8 00 00 00 FF C8 41 03 C1 33 D2 41 F7 F1 EB 5B 41 8D 42 FF 41 03 C0 33 D2 41 F7 F0 44 8B C8 89 86 C0 00 00 00 B9 01 00 00 00 2B C8 41 0F AF C8 41 03 CA 89 8E D4 00 00 00 44 2B C1 44 8D 50 FF 41 8B CA 41 0F AF C8 8B 86 B8 00 00 00 33 D2 3B C8 72 0B 83 C0 FE 41 03 C1 41 F7 F2 EB 0D 2B C1 FF C8 41 03 C1 41 F7 F1 41 03 C0 89 86 B4 00 00 00 48 8B 4E 18 48 8B 01 FF 10 40 38 AE 08 01 00 00 74 31 B9 38 08 00 00 E8 ?? ?? ?? ?? 48 89 44 24 58 48 85 C0 74 16 4C 8B CE 44 8B C3 8B 96 AC 00 00 00 48 8B C8 E8 ?? ?? ?? ?? EB 03 48 8B C5 48 89 46 68 E8 ?? ?? ?? ?? 8B C8 89 8E F0 00 00 00 48 89 6E 20 B8 04 00 00 00 48 F7 E1 48 C7 C1 FF FF FF FF 48 0F 40 C1 48 8B C8 E8 ?? ?? ?? ?? 48 89 46 28 39 AE F0 00 00 00 76 13 8B CD 48 8B 46 28 89 2C 88 FF C5 3B AE F0 00 00 00 72 ED 48 8B C6 48 8B 5C 24 60 48 83 C4 30 5F 5E 5D C3 }
	condition:
		$1
}

rule file_163_12_0 {
	meta:
		name = "?dtor$0@?0???0SchedulerProxy@details@Concurrency@@QEAA@PEAUIScheduler@2@PEAVResourceManager@12@AEBVSchedulerPolicy@2@@Z@4HA"
		size = 16
		refs = "000c ??1_ReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 50 00 00 00 48 83 C1 40 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_23_0 {
	meta:
		name = "??1SchedulerProxy@details@Concurrency@@IEAA@XZ"
		size = 79
		refs = "0019 ??_7SchedulerProxy@details@Concurrency@@6B@ 0029 ?DestroyAllocatedNodeData@ResourceManager@details@Concurrency@@QEAAXPEAUSchedulerNode@23@@Z 0032 ??_V@YAXPEAX@Z 004b ??1_ReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 8B D9 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B 51 20 48 8B 49 18 E8 ?? ?? ?? ?? 48 8B 4B 28 E8 ?? ?? ?? ?? 48 8B 4B 18 48 8B 01 FF 50 08 90 48 8D 4B 40 48 83 C4 30 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_24_0 {
	meta:
		name = "?dtor$0@?0???1SchedulerProxy@details@Concurrency@@IEAA@XZ@4HA"
		size = 16
		refs = "000c ??1_ReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 40 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_348_1 {
	meta:
		name = "?dtor$2@?0???0?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 40 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_353_1 {
	meta:
		name = "?dtor$2@?0???0?$source_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@QEAA@XZ@4HA"
		size = 16
		refs = "000c ??1?$ordered_message_processor@_K@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 40 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_525_1 {
	meta:
		name = "?dtor$2@?0???1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "000c ??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 40 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_530_1 {
	meta:
		name = "?dtor$2@?0???1?$source_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ@4HA"
		size = 16
		refs = "000c ??1?$ordered_message_processor@_K@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 40 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_685_1 {
	meta:
		name = "?dtor$2@?0???_G?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAAPEAXI@Z@4HA"
		size = 16
		refs = "000c ??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 40 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_690_1 {
	meta:
		name = "?dtor$2@?0???_G?$source_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z@4HA"
		size = 16
		refs = "000c ??1?$ordered_message_processor@_K@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8B 8A 40 00 00 00 48 83 C1 40 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_43_0 {
	meta:
		name = "?AddCore@SchedulerProxy@details@Concurrency@@QEAAXPEAUSchedulerNode@23@I_N@Z"
		size = 261
		refs = "0070 ?ToggleBorrowedState@SchedulerProxy@details@Concurrency@@QEAAXPEAUSchedulerNode@23@I@Z 0099 ??_U@YAPEAX_K@Z 00d0 ?AddVirtualProcessorRoots@SchedulerProxy@details@Concurrency@@QEAAXPEAPEAUIVirtualProcessorRoot@3@I@Z 00e2 ??_V@YAXPEAX@Z"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 30 8B 81 D4 00 00 00 8B 99 C0 00 00 00 45 8B E0 48 8B EA 48 8B F9 85 C0 74 0A FF C8 89 81 D4 00 00 00 EB 02 FF CB FF 42 24 FF 81 D0 00 00 00 48 8B 42 38 4B 8D 0C E4 C7 04 C8 04 00 00 00 89 5C C8 34 01 9F E0 00 00 00 45 84 C9 74 0B 45 8B C4 48 8B CF E8 ?? ?? ?? ?? 83 FB 01 75 07 48 8D 74 24 20 EB 20 8B CB B8 08 00 00 00 48 F7 E1 48 C7 C1 FF FF FF FF 48 0F 40 C1 48 8B C8 E8 ?? ?? ?? ?? 48 8B F0 85 DB 74 22 4C 8B F6 44 8B FB 4C 8B 0F 45 8B C4 48 8B D5 48 8B CF 41 FF 51 30 49 89 06 4D 8D 76 08 49 FF CF 75 E4 44 8B C3 48 8B D6 48 8B CF E8 ?? ?? ?? ?? 48 8D 44 24 20 48 3B F0 74 08 48 8B CE E8 ?? ?? ?? ?? 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 8B 7C 24 68 48 83 C4 30 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_163_44_0 {
	meta:
		name = "?AddExecutionResource@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z"
		size = 170
		refs = "002a ?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ 00a6 ?_Release@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 8B C4 57 48 83 EC 30 48 C7 40 E8 FE FF FF FF 48 89 58 10 48 89 70 18 48 8B F2 48 8B F9 48 8D 59 40 48 89 58 08 48 8B CB E8 ?? ?? ?? ?? 90 48 8B 06 48 8B CE FF 10 44 8B C0 49 C1 E0 06 48 8B 4F 20 8B 46 44 48 8D 14 C0 4D 8B 4C 08 38 49 8B 44 D1 18 48 85 C0 75 0A 48 89 76 58 48 89 76 50 EB 27 48 8B 40 58 48 89 46 58 49 8B 44 D1 18 48 89 46 50 49 8B 44 D1 18 48 8B 48 58 48 89 71 50 49 8B 44 D1 18 48 89 70 58 49 89 74 D1 18 41 FF 44 D1 10 48 8B CB 48 8B 5C 24 48 48 8B 74 24 50 48 83 C4 30 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_46_0 {
	meta:
		name = "?AddTail@?$List@VExecutionResource@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z"
		size = 66
	strings:
		$1 = { 48 8B 41 08 4C 8B C1 48 85 C0 75 0A 48 89 52 58 48 89 52 50 EB 24 48 8B 40 58 48 89 42 58 48 8B 41 08 48 89 42 50 48 8B 41 08 48 8B 48 58 48 89 51 50 49 8B 40 08 48 89 50 58 41 FF 00 49 89 50 08 C3 }
	condition:
		$1
}

rule file_163_47_0 {
	meta:
		name = "?AddThreadSubscription@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z"
		size = 85
	strings:
		$1 = { 48 8B 81 00 01 00 00 4C 8B C1 48 85 C0 75 0A 48 89 52 58 48 89 52 50 EB 2D 48 8B 40 58 48 89 42 58 48 8B 81 00 01 00 00 48 89 42 50 48 8B 81 00 01 00 00 48 8B 48 58 48 89 51 50 49 8B 80 00 01 00 00 48 89 50 58 41 FF 80 F8 00 00 00 49 89 90 00 01 00 00 C3 }
	condition:
		$1
}

rule file_163_48_0 {
	meta:
		name = "?AddVirtualProcessorRoots@SchedulerProxy@details@Concurrency@@QEAAXPEAPEAUIVirtualProcessorRoot@3@I@Z"
		size = 234
		refs = "0034 ?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ 00e6 ?_Release@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 8B C4 56 57 41 54 41 56 41 57 48 83 EC 30 48 C7 40 C8 FE FF FF FF 48 89 58 10 48 89 68 18 41 8B E8 4C 8B FA 48 8B F1 48 8D 59 40 48 89 58 08 48 8B CB E8 ?? ?? ?? ?? 90 85 ED 74 79 4D 8B F7 44 8B E5 49 8B 3E 48 8B 07 48 8B CF FF 10 4C 8D 47 10 8B D0 48 C1 E2 06 48 8B 4E 20 8B 47 54 4C 8D 0C C0 4C 8B 54 0A 38 4B 8B 44 CA 18 48 85 C0 75 0A 4D 89 40 58 4D 89 40 50 EB 27 48 8B 40 58 49 89 40 58 4B 8B 44 CA 18 49 89 40 50 4B 8B 44 CA 18 48 8B 48 58 4C 89 41 50 4B 8B 44 CA 18 4C 89 40 58 4F 89 44 CA 18 43 FF 44 CA 10 49 83 C6 08 49 FF CC 75 8D 48 8B 4E 10 48 8B 01 44 8B C5 49 8B D7 FF 50 18 01 AE CC 00 00 00 48 8B CB 48 8B 5C 24 68 48 8B 6C 24 70 48 83 C4 30 41 5F 41 5E 41 5C 5F 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_50_0 {
	meta:
		name = "?AdjustAllocationIncrease@SchedulerProxy@details@Concurrency@@QEBAII@Z"
		size = 137
	strings:
		$1 = { 4C 8B C1 44 8B CA 33 C9 41 8B 80 BC 00 00 00 41 8B 90 CC 00 00 00 3B C2 76 30 45 8B 90 C0 00 00 00 45 8B 98 D4 00 00 00 2B C2 41 8B CA 33 D2 41 0F AF CB 3B C8 72 07 41 F7 F2 8B C8 EB 0C 2B C1 41 8D 4A FF F7 F1 41 8D 0C 03 41 8B 90 D0 00 00 00 45 8B 90 E8 00 00 00 45 03 90 B0 00 00 00 03 D1 41 8B 88 EC 00 00 00 41 3B CA 41 8B C2 0F 42 C1 3B D0 72 09 41 8B D2 41 3B CA 0F 42 D1 41 3B D1 44 0F 42 CA 41 8B C1 C3 }
	condition:
		$1
}

rule file_163_51_0 {
	meta:
		name = "?BindContext@SchedulerProxy@details@Concurrency@@UEAAXPEAUIExecutionContext@3@@Z"
		size = 115
		refs = "003d ??_C@_08BAFMHLII@pContext?$AA@ 0051 ??0exception@std@@QEAA@AEBQEBD@Z 0058 ??_7invalid_argument@std@@6B@ 005f _TI3?AVinvalid_argument@std@@ 006e _CxxThrowException"
		altNames = "?BindContext@UMSSchedulerProxy@details@Concurrency@@UEAAXPEAUIExecutionContext@3@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 40 48 8B DA 48 8B F9 48 85 D2 74 25 48 8B 02 48 8B CA FF 50 10 48 85 C0 75 0C 48 8B 07 48 8B D3 48 8B CF FF 50 38 48 8B 5C 24 50 48 83 C4 40 5F C3 48 8D 05 ?? ?? ?? ?? 48 8D 54 24 58 48 8D 4C 24 20 48 89 44 24 58 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 48 89 44 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_163_52_0 {
	meta:
		name = "?Cleanup@SchedulerProxy@details@Concurrency@@IEAAXXZ"
		size = 198
		refs = "0078 ?ResetSubscriptionLevel@VirtualProcessorRoot@details@Concurrency@@QEAAXXZ 00c2 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 20 45 33 F6 48 8B E9 44 39 B1 F0 00 00 00 76 73 41 8B F6 45 33 FF 48 C1 E6 06 48 03 75 20 44 39 7E 08 76 53 48 8B 46 38 4F 8D 24 FF 4A 8B 7C E0 18 48 85 FF 74 06 48 8B 7F 58 EB 2D EB 2B 48 8B 46 38 48 8B DF 4A 3B 7C E0 18 74 06 48 8B 7F 58 EB 02 33 FF 48 8B 5B 30 48 8B CB E8 ?? ?? ?? ?? 48 8B 03 48 8B CB FF 50 48 48 85 FF 75 D0 41 FF C7 44 3B 7E 08 72 AD 41 FF C6 44 3B B5 F0 00 00 00 72 8D 48 8B 4D 68 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 20 41 5F 41 5E 41 5C E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_56_0 {
	meta:
		name = "?CreateExternalThreadResource@SchedulerProxy@details@Concurrency@@QEAAPEAVExecutionResource@23@PEAUSchedulerNode@23@I@Z"
		size = 111
		refs = "002b ??2@YAPEAX_K@Z 0048 ??0ExecutionResource@details@Concurrency@@QEAA@PEAVSchedulerProxy@12@PEAUSchedulerNode@12@I@Z 0053 ?IncrementUseCounts@ExecutionResource@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 8B C4 57 48 83 EC 30 48 C7 40 E8 FE FF FF FF 48 89 58 08 48 89 68 10 48 89 70 18 41 8B F8 48 8B F2 48 8B E9 B9 60 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 58 33 DB 48 85 C0 74 14 44 8B CF 4C 8B C6 48 8B D5 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_163_58_0 {
	meta:
		name = "?CreateOversubscriber@SchedulerProxy@details@Concurrency@@UEAAPEAUIVirtualProcessorRoot@3@PEAUIExecutionResource@3@@Z"
		size = 317
		refs = "0028 ??_R0?AVExecutionResource@details@Concurrency@@@8 002f ??_R0?AUIExecutionResource@Concurrency@@@8 0039 __RTDynamicCast 0052 ??_C@_0BD@HOFLOOHM@pExecutionResource?$AA@ 006c ??0exception@std@@QEAA@AEBQEBD@Z 0073 ??_7invalid_argument@std@@6B@ 007f _TI3?AVinvalid_argument@std@@ 0089 _CxxThrowException 009e ?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ 0123 ?_Release@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 8B C4 56 57 41 56 48 83 EC 50 48 C7 40 C8 FE FF FF FF 48 89 58 08 48 89 68 10 48 8B DA 4C 8B F1 83 60 B8 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 33 D2 48 8B CB E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 49 48 8D 7B 10 4C 39 77 20 74 3F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 80 00 00 00 48 8D 94 24 80 00 00 00 48 8D 4C 24 38 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 44 24 38 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 38 E8 ?? ?? ?? ?? CC 49 8D 5E 40 48 89 9C 24 80 00 00 00 48 8B CB E8 ?? ?? ?? ?? 90 48 8B 07 48 8B CF FF 10 8B F0 48 C1 E6 06 49 03 76 20 8B 7F 44 49 8B 06 44 8B C7 48 8B D6 49 8B CE FF 50 30 48 8B E8 C6 40 71 01 48 8D 50 10 4C 8D 04 FF 4C 8B 4E 38 4B 8B 44 C1 18 48 85 C0 75 0A 48 89 52 58 48 89 52 50 EB 27 48 8B 40 58 48 89 42 58 4B 8B 44 C1 18 48 89 42 50 4B 8B 44 C1 18 48 8B 48 58 48 89 51 50 4B 8B 44 C1 18 48 89 50 58 4B 89 54 C1 18 43 FF 44 C1 10 48 8B CB E8 ?? ?? ?? ?? 48 8B C5 48 8B 5C 24 70 48 8B 6C 24 78 48 83 C4 50 41 5E 5F 5E C3 }
	condition:
		$1
}

rule file_163_60_0 {
	meta:
		name = "?CreateVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@UEAAPEAVVirtualProcessorRoot@23@PEAUSchedulerNode@23@I@Z"
		size = 90
		refs = "0028 ??2@YAPEAX_K@Z 0045 ??0FreeVirtualProcessorRoot@details@Concurrency@@QEAA@PEAVSchedulerProxy@12@PEAUSchedulerNode@12@I@Z"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 48 89 74 24 48 41 8B D8 48 8B FA 48 8B F1 B9 90 00 00 00 E8 ?? ?? ?? ?? 48 8B C8 48 89 44 24 58 33 C0 48 85 C9 74 0F 44 8B CB 4C 8B C7 48 8B D6 E8 ?? ?? ?? ?? 90 48 8B 5C 24 40 48 8B 74 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_163_63_0 {
	meta:
		name = "?DecrementCoreSubscription@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z"
		size = 102
		refs = "0057 __imp_SetEvent"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 02 48 8B F9 48 8B CA 48 8B DA FF 10 48 8B 57 20 44 8B C0 8B 43 44 49 C1 E0 06 4C 8D 0C C0 4D 8B 44 10 38 F0 43 FF 4C C8 28 75 24 8B 87 B0 00 00 00 48 8B 4F 18 33 D2 39 87 B4 00 00 00 0F 94 C2 39 51 14 76 0A 48 8B 49 70 FF 15 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_163_64_0 {
	meta:
		name = "?DecrementCoreUseCount@ResourceManager@details@Concurrency@@QEAAXII@Z"
		size = 31
	strings:
		$1 = { 44 8B CA 48 8B 51 60 41 8B C0 48 8D 0C 40 49 C1 E1 06 48 C1 E1 04 49 03 4C 11 30 FF 49 18 C3 }
	condition:
		$1
}

rule file_163_65_0 {
	meta:
		name = "?DecrementFixedCoreCount@SchedulerProxy@details@Concurrency@@QEAAXII_N@Z"
		size = 169
		refs = "006b ?ToggleBorrowedState@SchedulerProxy@details@Concurrency@@QEAAXPEAUSchedulerNode@23@I@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 20 41 8B C0 44 8B F2 41 83 CF FF 49 C1 E6 06 48 8D 3C C0 48 8B 41 20 4A 8B 74 30 38 41 8A E9 48 8B D9 45 84 C9 74 0C 44 01 7C FE 3C 44 01 B9 E4 00 00 00 44 01 7C FE 38 75 3F 48 8B 51 20 44 01 B9 DC 00 00 00 49 03 D6 44 01 7A 2C 80 7C FE 42 00 74 0A E8 ?? ?? ?? ?? C6 44 FE 42 00 40 84 ED 74 17 48 8B 43 20 4A 8B 4C 30 38 83 7C F9 34 00 75 07 44 01 BB E8 00 00 00 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_163_66_0 {
	meta:
		name = "?DeleteThis@SchedulerProxy@details@Concurrency@@MEAAXXZ"
		size = 32
		refs = "000e ??1SchedulerProxy@details@Concurrency@@IEAA@XZ 0016 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 85 C9 74 1A 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_163_67_0 {
	meta:
		name = "?DesiredHWThreads@SchedulerProxy@details@Concurrency@@QEBAIXZ"
		size = 24
	strings:
		$1 = { 8B 81 B0 00 00 00 03 81 E8 00 00 00 8B 89 EC 00 00 00 3B C8 0F 42 C1 C3 }
	condition:
		$1
}

rule file_163_68_0 {
	meta:
		name = "?DestroyExecutionResource@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z"
		size = 251
		refs = "0088 ?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ 00cb ?_Release@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ 00d2 ??_7ExecutionResource@details@Concurrency@@6B@ 00f7 ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 48 8B 02 48 8B E9 48 8B CA 48 8B FA FF 10 8B D0 8B 47 44 48 C1 E2 06 48 8D 34 C0 48 03 55 20 4C 8B 72 38 41 8B 44 F6 3C 41 03 44 F6 34 75 3B FF 4A 24 41 C7 04 F6 01 00 00 00 FF 8D D0 00 00 00 48 8B 07 8B 5F 44 48 8B CF FF 10 48 8B 4D 18 48 8B 51 60 48 8D 0C 5B 44 8B C0 49 C1 E0 06 48 C1 E1 04 49 03 4C 10 30 FF 49 18 48 8D 4D 40 E8 ?? ?? ?? ?? 41 FF 4C F6 10 48 8B 4F 58 48 8B 47 50 48 89 41 50 48 8B 47 58 48 8B 4F 50 48 89 41 58 49 8B 44 F6 18 48 3B F8 75 13 48 3B 40 58 75 04 33 C0 EB 04 48 8B 40 50 49 89 44 F6 18 48 8D 4D 40 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8B CF 48 89 07 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_69_0 {
	meta:
		name = "?DestroyVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@QEAAXPEAVVirtualProcessorRoot@23@@Z"
		size = 185
		refs = "002a ?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ 009c ?_Release@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 8B C4 57 48 83 EC 30 48 C7 40 E8 FE FF FF FF 48 89 58 10 48 89 70 18 48 8B FA 48 8B F1 48 8D 59 40 48 89 58 08 48 8B CB E8 ?? ?? ?? ?? 90 48 8B 07 48 8B CF FF 10 44 8B C0 49 C1 E0 06 4C 03 46 20 48 8D 57 10 48 63 47 54 4C 8D 0C C0 4D 8B 50 38 43 FF 4C CA 10 48 8B 4A 58 48 8B 42 50 48 89 41 50 48 8B 4A 50 48 8B 42 58 48 89 41 58 4B 8B 44 CA 18 48 3B D0 75 13 48 3B 40 58 75 04 33 C0 EB 04 48 8B 40 50 4B 89 44 CA 18 80 7F 71 00 75 06 FF 8E CC 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B 07 48 8B CF 48 8B 5C 24 48 48 8B 74 24 50 48 83 C4 30 5F 48 FF 60 48 }
	condition:
		$1
}

rule file_163_71_0 {
	meta:
		name = "?FinalShutdown@SchedulerProxy@details@Concurrency@@UEAAXXZ"
		size = 29
		refs = "000a ?Cleanup@SchedulerProxy@details@Concurrency@@IEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B 03 48 8B CB 48 83 C4 20 5B 48 FF 60 48 }
	condition:
		$1
}

rule file_163_72_0 {
	meta:
		name = "?First@?$List@VExecutionResource@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QEBAPEAVExecutionResource@23@XZ"
		size = 16
	strings:
		$1 = { 48 8B 51 08 33 C0 48 85 D2 74 04 48 8B 42 58 C3 }
	condition:
		$1
}

rule file_163_75_0 {
	meta:
		name = "?GetCurrentThreadExecutionResource@SchedulerProxy@details@Concurrency@@QEAAPEAVExecutionResource@23@XZ"
		size = 43
		refs = "0013 ?__TlsGetValue@platform@details@Concurrency@@YAPEAXK@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 41 18 33 DB 8B 88 B0 00 00 00 E8 ?? ?? ?? ?? 48 85 C0 74 06 A8 03 48 0F 44 D8 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_163_80_0 {
	meta:
		name = "?GetNewThreadProxy@SchedulerProxy@details@Concurrency@@UEAAPEAUIThreadProxy@3@PEAUIExecutionContext@3@@Z"
		size = 93
		refs = "0023 ?GetFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QEAAPEAVFreeThreadProxyFactory@23@XZ 004b ?AssociateExecutionContext@FreeThreadProxy@details@Concurrency@@QEAAXPEAUIExecutionContext@3@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 83 79 08 00 48 8B FA 48 8B D9 75 14 48 8B 49 18 48 81 C1 A0 00 00 00 E8 ?? ?? ?? ?? 48 89 43 08 48 8B 4B 08 44 8B 83 C8 00 00 00 8B 93 C4 00 00 00 48 8B 01 FF 10 48 8B D7 48 8B C8 48 8B D8 E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_163_85_0 {
	meta:
		name = "?GetResourceForNewSubscription@SchedulerProxy@details@Concurrency@@QEAAPEAVExecutionResource@23@PEAV423@@Z"
		size = 108
		refs = "002b ??2@YAPEAX_K@Z 0045 ??0ExecutionResource@details@Concurrency@@QEAA@PEAVSchedulerProxy@12@PEAV012@@Z 0050 ?IncrementUseCounts@ExecutionResource@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 48 48 89 74 24 50 48 8B FA 48 8B F1 48 39 4A 20 74 31 B9 60 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 40 33 DB 48 85 C0 74 11 4C 8B C7 48 8B D6 48 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48 8B CB E8 ?? ?? ?? ?? EB 03 48 8B DA 48 8B C3 48 8B 5C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_163_93_0 {
	meta:
		name = "?GrantAllocation@SchedulerProxy@details@Concurrency@@QEAAPEAVExecutionResource@23@I_N0@Z"
		size = 922
		refs = "00c0 ?GetCurrentNodeAndCore@ResourceManager@details@Concurrency@@QEAAIPEAI@Z 0121 ??_U@YAPEAX_K@Z 0311 ?AddVirtualProcessorRoots@SchedulerProxy@details@Concurrency@@QEAAXPEAPEAUIVirtualProcessorRoot@3@I@Z 031b ??_V@YAXPEAX@Z 0343 ?RemoveCore@SchedulerProxy@details@Concurrency@@QEAAXPEAUSchedulerNode@23@I@Z 0378 ?CreateExternalThreadResource@SchedulerProxy@details@Concurrency@@QEAAPEAVExecutionResource@23@PEAUSchedulerNode@23@I@Z"
	strings:
		$1 = { 48 89 5C 24 08 44 88 4C 24 20 89 54 24 10 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 50 33 DB 45 8A E9 44 8B F2 48 8B F9 89 5C 24 28 44 8B E3 45 84 C9 74 38 44 8B 91 E8 00 00 00 8B 81 B4 00 00 00 44 8B 81 DC 00 00 00 8B 89 D0 00 00 00 45 2B C2 44 3B C0 41 0F 47 C0 41 03 CE 41 8D 14 02 3B CA 41 0F 97 C4 44 89 64 24 34 EB 04 89 5C 24 34 41 8B C6 41 2B C4 45 3B E6 1B F6 23 F0 45 85 E4 74 0A C6 44 24 22 01 45 85 F6 74 04 88 5C 24 22 45 84 ED 74 0A C6 44 24 21 01 45 85 E4 74 04 88 5C 24 21 83 C9 FF 4C 8B FB 89 4C 24 38 44 8B C9 89 4C 24 24 45 84 ED 74 11 48 8B 4F 18 33 D2 E8 ?? ?? ?? ?? 89 44 24 2C EB 04 89 4C 24 2C 89 5C 24 30 85 F6 74 56 8B 97 D4 00 00 00 3B F2 77 0B 8B AF C0 00 00 00 0F AF EE EB 15 8B 8F C0 00 00 00 8B EE 8D 41 FF 2B EA 0F AF CA 0F AF E8 03 E9 89 6C 24 30 85 ED 74 24 8B CD B8 08 00 00 00 48 F7 E1 48 C7 C1 FF FF FF FF 48 0F 40 C1 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 48 EB 05 48 89 5C 24 48 8B 6C 24 2C 45 84 ED 89 5C 24 40 41 0F 94 C1 8B CB 89 5C 24 3C 44 88 4C 24 20 44 8B D3 45 3B D6 72 09 45 84 C9 0F 85 A1 01 00 00 3B 8F F0 00 00 00 0F 83 95 01 00 00 8B F1 48 C1 E6 06 48 03 77 20 39 5E 20 77 09 39 5E 24 0F 86 72 01 00 00 44 8B EB 45 3B D6 72 09 45 84 C9 0F 85 5E 01 00 00 44 3B 6E 08 0F 83 54 01 00 00 4C 8B 46 38 41 8B C5 48 8D 14 C0 41 83 3C D0 03 0F 85 D9 00 00 00 45 84 C9 75 18 41 8D 46 FF 44 3B D0 74 04 3B E9 75 0B B1 01 45 85 E4 74 06 8A C3 EB 04 8A CB B0 01 41 C7 04 D0 04 00 00 00 FF 46 24 FF 87 D0 00 00 00 84 C9 74 10 4C 8B FE 45 8B CD 44 89 6C 24 24 C6 44 24 20 01 84 C0 74 76 8B 87 D4 00 00 00 44 8B B7 C0 00 00 00 85 C0 74 0A FF C8 89 87 D4 00 00 00 EB 03 41 FF CE 45 01 74 D0 34 44 01 B7 E0 00 00 00 45 85 F6 74 3F 48 8B 6C 24 48 44 8B 64 24 40 48 8B 07 45 8B C5 48 8B D6 48 8B CF FF 50 30 48 8B C8 41 8B C4 41 FF C4 48 89 4C C5 00 41 FF CE 75 DE 8B 6C 24 2C 44 8B 54 24 28 44 89 64 24 40 44 8B 64 24 34 44 8B B4 24 98 00 00 00 8B 4C 24 3C 41 FF C2 44 89 54 24 28 44 8A 4C 24 20 41 FF C5 E9 F9 FE FF FF 41 83 3C D0 04 75 F1 38 5C 24 21 74 29 41 8B 44 D0 3C 41 03 44 D0 34 8B 54 24 38 3B C2 72 06 75 D7 3B CD 75 D3 89 44 24 38 4C 8B FE 45 8B CD 44 89 6C 24 24 EB BD 38 5C 24 22 74 BC 41 39 5C D0 38 77 B5 4D 85 FF 74 04 3B CD 75 AC 4C 8B FE 45 8B CD 44 89 6C 24 24 3B CD 75 98 41 B1 01 44 88 4C 24 20 EB 93 89 5E 20 FF C1 89 4C 24 3C E9 51 FE FF FF 8B 6C 24 30 85 ED 74 1A 48 8B 54 24 48 44 8B C5 48 8B CF E8 ?? ?? ?? ?? 48 8B 4C 24 48 E8 ?? ?? ?? ?? 38 9C 24 A8 00 00 00 74 57 38 5C 24 21 75 3B 38 5C 24 22 74 35 44 8B 6C 24 24 49 8B D7 48 8B CF 45 8B C5 E8 ?? ?? ?? ?? 49 8B 47 38 4A 8D 0C ED 00 00 00 00 49 03 CD C7 04 C8 04 00 00 00 41 FF 47 24 FF 87 D0 00 00 00 EB 05 44 8B 6C 24 24 45 8B C5 49 8B D7 48 8B CF E8 ?? ?? ?? ?? 48 8B D8 48 8B C3 48 8B 9C 24 90 00 00 00 48 83 C4 50 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_163_95_0 {
	meta:
		name = "?IncrementCoreSubscription@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z"
		size = 113
		refs = "0062 __imp_SetEvent"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 02 48 8B F9 48 8B CA 48 8B DA FF 10 48 8B 57 20 44 8B C0 8B 43 44 49 C1 E0 06 4C 8D 0C C0 B8 01 00 00 00 4D 8B 44 10 38 F0 43 0F C1 44 C8 28 FF C0 83 F8 01 75 24 8B 87 B0 00 00 00 48 8B 4F 18 33 D2 39 87 B4 00 00 00 0F 94 C2 39 51 14 76 0A 48 8B 49 70 FF 15 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_163_96_0 {
	meta:
		name = "?IncrementFixedCoreCount@SchedulerProxy@details@Concurrency@@QEAAXII_N@Z"
		size = 171
		refs = "0062 ?ToggleBorrowedState@SchedulerProxy@details@Concurrency@@QEAAXPEAUSchedulerNode@23@I@Z"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 41 8B C0 44 8B F2 41 8A E9 48 8D 3C C0 48 8B 41 20 49 C1 E6 06 4A 8B 74 30 38 48 8B D9 8B 54 FE 38 8D 42 01 89 44 FE 38 85 D2 75 3C 48 8B 51 20 49 03 D6 FF 42 2C FF 81 DC 00 00 00 80 7C FE 41 00 74 0A C6 44 FE 42 01 E8 ?? ?? ?? ?? 40 84 ED 74 25 48 8B 43 20 4A 8B 4C 30 38 83 7C F9 34 00 75 06 FF 83 E8 00 00 00 40 84 ED 74 0A FF 83 E4 00 00 00 FF 44 FE 3C 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_163_103_0 {
	meta:
		name = "?MinHWThreads@SchedulerProxy@details@Concurrency@@QEBAIXZ"
		size = 31
	strings:
		$1 = { 44 8B 81 E8 00 00 00 8B 81 B4 00 00 00 8B 91 DC 00 00 00 41 2B D0 3B D0 0F 47 C2 41 03 C0 C3 }
	condition:
		$1
}

rule file_163_104_0 {
	meta:
		name = "?MinVprocHWThreads@SchedulerProxy@details@Concurrency@@QEBAIXZ"
		size = 24
	strings:
		$1 = { 8B 81 B4 00 00 00 8B 91 DC 00 00 00 2B 91 E8 00 00 00 3B D0 0F 47 C2 C3 }
	condition:
		$1
}

rule file_163_106_0 {
	meta:
		name = "?ReferenceCurrentThreadExecutionResource@SchedulerProxy@details@Concurrency@@QEAAPEAVExecutionResource@23@XZ"
		size = 186
		refs = "001d ?__TlsGetValue@platform@details@Concurrency@@YAPEAXK@Z 0053 ?IncrementUseCounts@ExecutionResource@details@Concurrency@@QEAAXXZ 00a2 ?GetResourceForNewSubscription@SchedulerProxy@details@Concurrency@@QEAAPEAVExecutionResource@23@PEAV423@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B 41 18 48 8B F1 8B 88 B0 00 00 00 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 7F 83 E0 03 74 21 48 83 F8 01 75 25 48 83 E3 FE 48 8B 5B 20 48 8B 43 40 48 83 C3 10 48 85 C0 74 06 80 78 70 00 75 59 48 8B CB E8 ?? ?? ?? ?? EB 3D 48 83 E3 FD 48 8D 7B 08 48 8B CF 48 8B 07 FF 50 20 48 8B 5B 40 48 8B 43 50 48 83 C3 20 48 85 C0 74 0A 80 78 70 00 74 04 33 DB EB 08 48 8B CB E8 ?? ?? ?? ?? 48 8B 07 48 8B CF FF 50 28 48 85 DB 74 0D 48 8B D3 48 8B CE E8 ?? ?? ?? ?? EB 02 33 C0 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_163_107_0 {
	meta:
		name = "?Remove@?$List@VExecutionResource@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z"
		size = 54
	strings:
		$1 = { FF 09 4C 8B 42 58 48 8B 42 50 49 89 40 50 48 8B 42 58 4C 8B 42 50 49 89 40 58 48 8B 41 08 48 3B D0 75 12 48 3B 40 58 75 04 33 C0 EB 04 48 8B 40 50 48 89 41 08 C3 }
	condition:
		$1
}

rule file_163_108_0 {
	meta:
		name = "?RemoveCore@SchedulerProxy@details@Concurrency@@QEAAXPEAUSchedulerNode@23@I@Z"
		size = 248
		refs = "006b ?ToggleBorrowedState@SchedulerProxy@details@Concurrency@@QEAAXPEAUSchedulerNode@23@I@Z 0082 ?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ 00f4 ?_Release@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 40 56 57 41 56 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 60 48 89 6C 24 68 48 8B F9 83 C8 FF 01 42 24 01 81 D0 00 00 00 41 8B C0 48 8D 34 C0 4C 8B 72 38 41 C7 04 F6 01 00 00 00 8B 81 C0 00 00 00 41 39 44 F6 34 75 06 FF 81 D4 00 00 00 41 8B 44 F6 34 29 81 E0 00 00 00 41 83 64 F6 34 00 41 80 7C F6 41 00 74 05 E8 ?? ?? ?? ?? 41 C6 44 F6 40 00 48 8D 5F 40 48 89 5C 24 58 48 8B CB E8 ?? ?? ?? ?? 90 49 8B 44 F6 18 48 85 C0 74 04 48 8B 40 58 48 85 C0 74 44 49 3B 44 F6 18 74 06 48 8B 68 58 EB 02 33 ED 48 8B 48 30 48 85 C9 74 24 80 79 70 00 75 1E C6 41 70 01 48 89 4C 24 50 48 8B 4F 10 48 8B 01 41 B8 01 00 00 00 48 8D 54 24 50 FF 50 20 48 8B C5 48 85 ED 75 BC 48 8B CB 48 8B 5C 24 60 48 8B 6C 24 68 48 83 C4 30 41 5E 5F 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_110_0 {
	meta:
		name = "?RemoveThreadSubscription@SchedulerProxy@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z"
		size = 81
		refs = "0042 ??_7ExecutionResource@details@Concurrency@@6B@ 004d ??3@YAXPEAX@Z"
	strings:
		$1 = { FF 89 F8 00 00 00 4C 8B 42 58 48 8B 42 50 49 89 40 50 48 8B 42 58 4C 8B 42 50 49 89 40 58 48 8B 81 00 01 00 00 48 3B D0 75 15 48 3B 40 58 75 04 33 C0 EB 04 48 8B 40 50 48 89 81 00 01 00 00 48 8D 05 ?? ?? ?? ?? 48 8B CA 48 89 02 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_112_0 {
	meta:
		name = "?SendCoreNotification@SchedulerProxy@details@Concurrency@@QEAAXPEAUSchedulerCore@23@_N@Z"
		size = 264
		refs = "0020 __security_cookie 0042 ?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ 0064 ??_U@YAPEAX_K@Z 00ce ?_Release@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ 00e0 ??_V@YAXPEAX@Z 00ed __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 56 57 41 56 41 57 48 81 EC 80 00 00 00 48 C7 40 80 FE FF FF FF 48 89 58 18 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 70 45 8A F8 48 8B EA 4C 8B F1 48 8D 59 40 48 89 5C 24 20 48 8B CB E8 ?? ?? ?? ?? 90 33 F6 8D 46 08 39 45 10 7E 1C 48 63 4D 10 48 F7 E1 48 8D 4E FF 48 0F 40 C1 48 8B C8 E8 ?? ?? ?? ?? 48 8B F8 EB 05 48 8D 7C 24 30 48 8B 45 18 48 85 C0 74 04 48 8B 40 58 48 85 C0 74 2B 48 3B 45 18 74 06 48 8B 48 58 EB 02 33 C9 48 8B 50 30 48 85 D2 74 0C 80 7A 70 00 75 06 48 89 14 F7 FF C6 48 8B C1 48 85 C9 75 D5 49 8B 4E 10 44 8B C6 48 8B D7 48 8B 01 45 84 FF 74 05 FF 50 30 EB 04 FF 50 28 90 48 8B CB E8 ?? ?? ?? ?? 48 8D 44 24 30 48 3B F8 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B 4C 24 70 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 C0 00 00 00 48 81 C4 80 00 00 00 41 5F 41 5E 5F 5E 5D C3 }
	condition:
		$1
}

rule file_163_114_0 {
	meta:
		name = "?ShouldReceiveNotifications@SchedulerProxy@details@Concurrency@@QEAA_NXZ"
		size = 16
	strings:
		$1 = { 8B 91 B0 00 00 00 39 91 B4 00 00 00 0F 94 C0 C3 }
	condition:
		$1
}

rule file_163_117_0 {
	meta:
		name = "?ToggleBorrowedState@SchedulerProxy@details@Concurrency@@QEAAXPEAUSchedulerNode@23@I@Z"
		size = 57
	strings:
		$1 = { 41 8B C0 4C 8D 04 C0 48 8B 42 38 42 80 7C C0 41 00 74 16 41 83 C9 FF 44 01 89 D8 00 00 00 44 01 4A 28 42 C6 44 C0 41 00 C3 FF 81 D8 00 00 00 FF 42 28 42 C6 44 C0 41 01 C3 }
	condition:
		$1
}

rule file_163_118_0 {
	meta:
		name = "?UnbindContext@SchedulerProxy@details@Concurrency@@UEAAXPEAUIExecutionContext@3@@Z"
		size = 87
		refs = "001a ?ReturnIdleProxy@FreeThreadProxy@details@Concurrency@@QEAAXXZ 0021 ??_C@_08BAFMHLII@pContext?$AA@ 0035 ??0exception@std@@QEAA@AEBQEBD@Z 003c ??_7invalid_argument@std@@6B@ 0043 _TI3?AVinvalid_argument@std@@ 0052 _CxxThrowException"
	strings:
		$1 = { 48 83 EC 48 48 85 D2 74 15 48 8B 02 48 8B CA FF 50 10 48 8B C8 48 83 C4 48 E9 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8D 54 24 58 48 8D 4C 24 20 48 89 44 24 58 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 48 89 44 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_164_4_0 {
	meta:
		name = "_mbstrnlen_l"
		size = 271
		refs = "0020 _errno 002b _invalid_parameter_noinfo 004a ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0063 strnlen 0087 __imp_MultiByteToWideChar 00b7 _isleadbyte_l"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 50 48 8B F2 48 8B F9 48 85 C9 75 19 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF E9 C2 00 00 00 48 81 FA FF FF FF 7F 77 DE 48 8D 4C 24 30 49 8B D0 E8 ?? ?? ?? ?? 48 8B 44 24 30 83 B8 D4 00 00 00 01 75 10 48 8B D6 48 8B CF E8 ?? ?? ?? ?? 48 63 D8 EB 78 8B 48 04 83 64 24 28 00 48 83 64 24 20 00 44 8B CE 4C 8B C7 BA 09 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 11 E8 ?? ?? ?? ?? 48 83 CB FF C7 00 2A 00 00 00 EB 44 33 DB 33 ED 48 85 F6 74 34 80 3F 00 74 2F 0F B6 0F 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 74 10 48 FF C5 48 3B EE 73 19 48 FF C7 80 3F 00 74 0E 48 FF C5 48 FF C3 48 FF C7 48 3B EE 72 CC 48 3B EE 48 0F 43 DE 80 7C 24 48 00 74 0C 48 8B 4C 24 40 83 A1 C8 00 00 00 FD 48 8B C3 48 8B 5C 24 60 48 8B 6C 24 68 48 8B 74 24 70 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "_execlp"
		size = 198
		refs = "001b __security_cookie 0033 _errno 003e _invalid_parameter_noinfo 0075 _capture_argv 008b _execvp 00a5 free 00b8 __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 53 57 48 81 EC 48 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 02 00 00 48 8B D9 48 85 C9 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 64 80 39 00 74 E5 48 85 D2 74 E0 80 3A 00 74 DB 48 8D 84 24 70 02 00 00 4C 8D 44 24 30 48 8D 4C 24 20 41 B9 40 00 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 64 24 20 00 48 8D 54 24 30 48 8B CB 48 8B F8 E8 ?? ?? ?? ?? 48 8B D8 48 85 FF 74 12 48 8D 44 24 30 48 3B F8 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 8B 8C 24 30 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 48 02 00 00 5F 5B C3 }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "localeconv"
		size = 56
		refs = "0005 _getptd 000c __ptlocinfo 0021 __globallocalestatus 0028 __updatetlocinfo 002f __lconv"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 39 88 C0 00 00 00 74 13 8B 80 C8 00 00 00 85 05 ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_167_0_0 {
	meta:
		name = "_ldquad"
		size = 1028
		refs = "0026 __security_cookie 0039 __real@c1945f306dc9c883 0053 __real@41945f306dc9c883 0065 __real@3fe45f306dc9c883 0076 __real@3fe0000000000000 0080 __real@bfe0000000000000 0092 _ld_int 00b7 __real@3fd0000000000000 00bf __real@3e50000000000000 00cd __real@41b921fb50000000 00d5 __real@401110b460000000 00e4 __real@3e51a62620000000 00f3 __real@3cd3145c00000000 00fb __real@3b3b839a20000000 012f _ldunscale 014a _ldxp_setw 0170 _ldscale 018f __b 01ad memcpy 01bd _ldxp_mulh 020f _ldxp_addx 0240 __real@3fc45f306dc9c883 0262 __real@be50000000000000 0271 __c 02a9 get_acsize 036b __real@bfd0000000000000 0395 _ldxp_getw 03a7 __real@c1dfffffffc00000 03b5 __real@41dfffffffc00000 03bf __real@41e0000000000000 03c7 fmod 03dd __security_check_cookie"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 78 18 4C 89 78 20 55 48 8D 68 A1 48 81 EC 00 01 00 00 0F 29 70 E8 0F 29 78 D8 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 2F F2 0F 10 09 F2 0F 10 3D ?? ?? ?? ?? 48 8B F9 66 0F 2F CF F2 0F 11 4D 87 0F 86 CA 00 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C1 0F 86 B8 00 00 00 F2 0F 59 0D ?? ?? ?? ?? 0F 57 F6 66 0F 2F CE 72 0A F2 0F 58 0D ?? ?? ?? ?? EB 08 F2 0F 58 0D ?? ?? ?? ?? 48 8D 4C 24 28 33 D2 F2 0F 11 4C 24 28 E8 ?? ?? ?? ?? F2 0F 10 64 24 28 66 0F 2E E6 7A 09 75 07 F2 0F 10 5D 87 EB 65 F2 0F 10 5D 87 0F 28 D4 F2 0F 59 15 ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? 0F 28 C2 0F 28 CA F2 0F 59 05 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C D8 0F 28 C2 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5C D9 0F 28 CA F2 0F 59 0D ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? F2 0F 5C D8 F2 0F 5C D9 F2 0F 5C DA F2 0F 11 5D 87 F2 0F 11 1F E9 8A 02 00 00 48 8D 54 24 28 48 8D 4C 24 20 F2 0F 11 4C 24 28 BB 06 00 00 00 E8 ?? ?? ?? ?? 66 83 7C 24 20 56 0F 57 F6 7D 15 F2 0F 10 55 87 48 8D 4D 9F 8B D3 E8 ?? ?? ?? ?? E9 C0 00 00 00 0F BF 44 24 20 48 8D 4D 87 83 E8 36 C1 F8 05 0F BF D0 66 89 44 24 20 C1 E2 05 F7 DA E8 ?? ?? ?? ?? 48 8D 4D 8F BA 02 00 00 00 F2 0F 10 55 87 E8 ?? ?? ?? ?? 0F BF 44 24 20 4C 8D 3D ?? ?? ?? ?? FF C8 48 8D 4D 9F 41 B8 30 00 00 00 48 98 48 8D 14 40 48 C1 E2 04 49 03 D7 E8 ?? ?? ?? ?? 48 8D 4D 9F 8B D3 F2 0F 10 55 8F E8 ?? ?? ?? ?? F2 0F 10 45 97 66 0F 2E C6 7A 02 74 45 0F BF 44 24 20 48 8D 4D CF 41 B8 30 00 00 00 FF C8 48 98 48 8D 14 40 48 C1 E2 04 49 03 D7 E8 ?? ?? ?? ?? 48 8D 4D CF 8B D3 F2 0F 10 55 97 E8 ?? ?? ?? ?? 4C 8D 45 CF 48 8D 4D 9F 44 8B CB 8B D3 E8 ?? ?? ?? ?? F2 0F 10 4D 9F 66 0F 2F F9 77 0E 66 0F 2F 0D ?? ?? ?? ?? 0F 86 C2 00 00 00 F2 0F 10 45 A7 48 8D 4C 24 28 33 D2 F2 0F 58 C1 F2 0F 59 05 ?? ?? ?? ?? F2 0F 11 44 24 28 E8 ?? ?? ?? ?? F2 0F 10 54 24 28 48 8D 4D 8F BA 02 00 00 00 F2 0F 59 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 63 C3 48 8D 15 ?? ?? ?? ?? 48 8D 4D CF 49 C1 E0 03 E8 ?? ?? ?? ?? 48 8D 4D CF 8B D3 F2 0F 10 55 8F E8 ?? ?? ?? ?? F2 0F 10 45 97 66 0F 2E C6 7A 06 0F 84 5E FF FF FF F2 0F 10 45 9F E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D FF 48 63 D8 4C 8B C3 49 C1 E0 03 E8 ?? ?? ?? ?? 48 8D 4D FF 8B D3 F2 0F 10 55 97 E8 ?? ?? ?? ?? 4C 8D 45 FF 48 8D 4D CF 44 8B CB 8B D3 E8 ?? ?? ?? ?? E9 13 FF FF FF F2 0F 10 45 A7 F2 0F 58 C1 F2 0F 59 05 ?? ?? ?? ?? 66 0F 2F C6 72 0A F2 0F 58 05 ?? ?? ?? ?? EB 08 F2 0F 58 05 ?? ?? ?? ?? 48 8D 4C 24 28 33 D2 F2 0F 11 44 24 28 E8 ?? ?? ?? ?? F2 0F 10 44 24 28 66 0F 2E C6 7A 02 74 57 F2 0F 10 45 9F E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D FF 48 63 D8 4C 8B C3 49 C1 E0 03 E8 ?? ?? ?? ?? 48 8D 4D FF 8B D3 F2 0F 10 54 24 28 F2 0F 59 15 ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 8D 45 FF 48 8D 4D 9F 44 8B CB 8B D3 E8 ?? ?? ?? ?? 48 8D 4D 9F 8B D3 E8 ?? ?? ?? ?? F2 0F 10 64 24 28 F2 0F 11 07 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F CC 77 0A 66 0F 2F 25 ?? ?? ?? ?? 76 13 F2 0F 10 0D ?? ?? ?? ?? 0F 28 C4 E8 ?? ?? ?? ?? 0F 28 E0 F2 0F 2C C4 83 E0 03 48 8B 4D 2F 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 00 01 00 00 49 8B 5B 18 49 8B 7B 20 4D 8B 7B 28 41 0F 28 73 F0 41 0F 28 7B E0 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_312_0_0 {
	meta:
		name = "_dquad"
		size = 1028
		refs = "0026 __security_cookie 0039 __real@c1945f306dc9c883 0053 __real@41945f306dc9c883 0065 __real@3fe45f306dc9c883 0076 __real@3fe0000000000000 0080 __real@bfe0000000000000 0092 _d_int 00b7 __real@3fd0000000000000 00bf __real@3e50000000000000 00cd __real@41b921fb50000000 00d5 __real@401110b460000000 00e4 __real@3e51a62620000000 00f3 __real@3cd3145c00000000 00fb __real@3b3b839a20000000 012f _dunscale 014a _dxp_setw 0170 _dscale 018f __b 01ad memcpy 01bd _dxp_mulh 020f _dxp_addx 0240 __real@3fc45f306dc9c883 0262 __real@be50000000000000 0271 __c 02a9 get_acsize 036b __real@bfd0000000000000 0395 _dxp_getw 03a7 __real@c1dfffffffc00000 03b5 __real@41dfffffffc00000 03bf __real@41e0000000000000 03c7 fmod 03dd __security_check_cookie"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 78 18 4C 89 78 20 55 48 8D 68 A1 48 81 EC 00 01 00 00 0F 29 70 E8 0F 29 78 D8 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 2F F2 0F 10 09 F2 0F 10 3D ?? ?? ?? ?? 48 8B F9 66 0F 2F CF F2 0F 11 4D 87 0F 86 CA 00 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C1 0F 86 B8 00 00 00 F2 0F 59 0D ?? ?? ?? ?? 0F 57 F6 66 0F 2F CE 72 0A F2 0F 58 0D ?? ?? ?? ?? EB 08 F2 0F 58 0D ?? ?? ?? ?? 48 8D 4C 24 28 33 D2 F2 0F 11 4C 24 28 E8 ?? ?? ?? ?? F2 0F 10 64 24 28 66 0F 2E E6 7A 09 75 07 F2 0F 10 5D 87 EB 65 F2 0F 10 5D 87 0F 28 D4 F2 0F 59 15 ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? 0F 28 C2 0F 28 CA F2 0F 59 05 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C D8 0F 28 C2 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5C D9 0F 28 CA F2 0F 59 0D ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? F2 0F 5C D8 F2 0F 5C D9 F2 0F 5C DA F2 0F 11 5D 87 F2 0F 11 1F E9 8A 02 00 00 48 8D 54 24 28 48 8D 4C 24 20 F2 0F 11 4C 24 28 BB 06 00 00 00 E8 ?? ?? ?? ?? 66 83 7C 24 20 56 0F 57 F6 7D 15 F2 0F 10 55 87 48 8D 4D 9F 8B D3 E8 ?? ?? ?? ?? E9 C0 00 00 00 0F BF 44 24 20 48 8D 4D 87 83 E8 36 C1 F8 05 0F BF D0 66 89 44 24 20 C1 E2 05 F7 DA E8 ?? ?? ?? ?? 48 8D 4D 8F BA 02 00 00 00 F2 0F 10 55 87 E8 ?? ?? ?? ?? 0F BF 44 24 20 4C 8D 3D ?? ?? ?? ?? FF C8 48 8D 4D 9F 41 B8 30 00 00 00 48 98 48 8D 14 40 48 C1 E2 04 49 03 D7 E8 ?? ?? ?? ?? 48 8D 4D 9F 8B D3 F2 0F 10 55 8F E8 ?? ?? ?? ?? F2 0F 10 45 97 66 0F 2E C6 7A 02 74 45 0F BF 44 24 20 48 8D 4D CF 41 B8 30 00 00 00 FF C8 48 98 48 8D 14 40 48 C1 E2 04 49 03 D7 E8 ?? ?? ?? ?? 48 8D 4D CF 8B D3 F2 0F 10 55 97 E8 ?? ?? ?? ?? 4C 8D 45 CF 48 8D 4D 9F 44 8B CB 8B D3 E8 ?? ?? ?? ?? F2 0F 10 4D 9F 66 0F 2F F9 77 0E 66 0F 2F 0D ?? ?? ?? ?? 0F 86 C2 00 00 00 F2 0F 10 45 A7 48 8D 4C 24 28 33 D2 F2 0F 58 C1 F2 0F 59 05 ?? ?? ?? ?? F2 0F 11 44 24 28 E8 ?? ?? ?? ?? F2 0F 10 54 24 28 48 8D 4D 8F BA 02 00 00 00 F2 0F 59 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 63 C3 48 8D 15 ?? ?? ?? ?? 48 8D 4D CF 49 C1 E0 03 E8 ?? ?? ?? ?? 48 8D 4D CF 8B D3 F2 0F 10 55 8F E8 ?? ?? ?? ?? F2 0F 10 45 97 66 0F 2E C6 7A 06 0F 84 5E FF FF FF F2 0F 10 45 9F E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D FF 48 63 D8 4C 8B C3 49 C1 E0 03 E8 ?? ?? ?? ?? 48 8D 4D FF 8B D3 F2 0F 10 55 97 E8 ?? ?? ?? ?? 4C 8D 45 FF 48 8D 4D CF 44 8B CB 8B D3 E8 ?? ?? ?? ?? E9 13 FF FF FF F2 0F 10 45 A7 F2 0F 58 C1 F2 0F 59 05 ?? ?? ?? ?? 66 0F 2F C6 72 0A F2 0F 58 05 ?? ?? ?? ?? EB 08 F2 0F 58 05 ?? ?? ?? ?? 48 8D 4C 24 28 33 D2 F2 0F 11 44 24 28 E8 ?? ?? ?? ?? F2 0F 10 44 24 28 66 0F 2E C6 7A 02 74 57 F2 0F 10 45 9F E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D FF 48 63 D8 4C 8B C3 49 C1 E0 03 E8 ?? ?? ?? ?? 48 8D 4D FF 8B D3 F2 0F 10 54 24 28 F2 0F 59 15 ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 8D 45 FF 48 8D 4D 9F 44 8B CB 8B D3 E8 ?? ?? ?? ?? 48 8D 4D 9F 8B D3 E8 ?? ?? ?? ?? F2 0F 10 64 24 28 F2 0F 11 07 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F CC 77 0A 66 0F 2F 25 ?? ?? ?? ?? 76 13 F2 0F 10 0D ?? ?? ?? ?? 0F 28 C4 E8 ?? ?? ?? ?? 0F 28 E0 F2 0F 2C C4 83 E0 03 48 8B 4D 2F 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 00 01 00 00 49 8B 5B 18 49 8B 7B 20 4D 8B 7B 28 41 0F 28 73 F0 41 0F 28 7B E0 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_167_1_0 {
	meta:
		name = "_ldquadph"
		size = 214
		refs = "0016 _ldquad 002d _ld_int 003b __real@c1cfffffff800000 004d __real@41cfffffff800000 0057 __real@41d0000000000000 005c fmod 0064 __real@4000000000000000 006c __real@400921fb54442d18 0088 __real@3fe921fb54442d18 0092 __real@3fe0000000000000 009e __real@bfe921fb54442d18"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 30 0F 29 74 24 20 48 8B F9 0F 28 F1 E8 ?? ?? ?? ?? 48 8D 4C 24 40 BA 01 00 00 00 F2 0F 11 74 24 40 8B D8 E8 ?? ?? ?? ?? F2 0F 10 44 24 40 F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F D0 F2 0F 5C F0 77 0A 66 0F 2F 05 ?? ?? ?? ?? 76 0D F2 0F 10 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 0F 28 CE F2 0F 2C C0 F2 0F 59 CA F2 0F 58 0F 83 E0 03 03 D8 66 0F 2F 0D ?? ?? ?? ?? 72 0C F2 0F 5C 35 ?? ?? ?? ?? FF C3 EB 18 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C1 72 18 F2 0F 58 35 ?? ?? ?? ?? FF CB F2 0F 59 F2 F2 0F 58 37 F2 0F 11 37 EB 04 F2 0F 11 0F 0F 28 74 24 20 8B C3 48 8B 5C 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_312_1_0 {
	meta:
		name = "_dquadph"
		size = 214
		refs = "0016 _dquad 002d _d_int 003b __real@c1cfffffff800000 004d __real@41cfffffff800000 0057 __real@41d0000000000000 005c fmod 0064 __real@4000000000000000 006c __real@400921fb54442d18 0088 __real@3fe921fb54442d18 0092 __real@3fe0000000000000 009e __real@bfe921fb54442d18"
	strings:
		$1 = { 48 89 5C 24 10 57 48 83 EC 30 0F 29 74 24 20 48 8B F9 0F 28 F1 E8 ?? ?? ?? ?? 48 8D 4C 24 40 BA 01 00 00 00 F2 0F 11 74 24 40 8B D8 E8 ?? ?? ?? ?? F2 0F 10 44 24 40 F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F D0 F2 0F 5C F0 77 0A 66 0F 2F 05 ?? ?? ?? ?? 76 0D F2 0F 10 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 0F 28 CE F2 0F 2C C0 F2 0F 59 CA F2 0F 58 0F 83 E0 03 03 D8 66 0F 2F 0D ?? ?? ?? ?? 72 0C F2 0F 5C 35 ?? ?? ?? ?? FF C3 EB 18 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C1 72 18 F2 0F 58 35 ?? ?? ?? ?? FF CB F2 0F 59 F2 F2 0F 58 37 F2 0F 11 37 EB 04 F2 0F 11 0F 0F 28 74 24 20 8B C3 48 8B 5C 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_167_2_0 {
	meta:
		name = "_ldsin"
		size = 376
		refs = "0013 _ldtest 0038 _ldquad 0042 _LRteps_C 004a __xmm@80000000000000008000000000000000 0073 __real@3ff0000000000000 008f __real@3e21ba39100a2609 0097 __real@3e927df9c661a83b 00a3 __real@3efa019f9030ac63 00af __real@3f56c16c1651fbf6 00bb __real@3fa55555555502b1 00c7 __real@3fdfffffffffffae 00e0 __real@3de5d810c32f8fb0 00e8 __real@3e5ae5e1a1730c8f 00f4 __real@3ec71de34fe4ad4d 0100 __real@3f2a01a019b5e33e 010c __real@3f8111111110f0fa 011c __real@3fc5555555555542 0143 _fperrraise 014b _LNan_C"
	strings:
		$1 = { F2 0F 11 44 24 08 53 48 83 EC 20 48 8D 4C 24 30 8B DA E8 ?? ?? ?? ?? 0F BF C8 85 C9 0F 84 2F 01 00 00 FF C9 0F 84 13 01 00 00 FF C9 0F 84 03 01 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 03 D8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 4C 24 30 0F 28 C2 0F 57 C3 66 0F 2F C8 76 1C 66 0F 2F D1 76 16 F6 C3 01 0F 84 B9 00 00 00 F2 0F 10 0D ?? ?? ?? ?? E9 AC 00 00 00 0F 28 D1 F2 0F 59 D1 F6 C3 01 74 51 0F 28 CA F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 5C 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 5C 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? EB 4F 0F 28 C2 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5C 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 5C 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 59 D1 F2 0F 5C 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 C8 F6 C3 02 74 03 0F 57 CB 0F 28 C1 EB 3D F2 0F 10 44 24 30 EB 35 B9 01 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? EB 21 F6 C3 01 74 0A F2 0F 10 05 ?? ?? ?? ?? EB 06 F2 0F 10 44 24 30 F6 C3 02 74 07 0F 57 05 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_312_2_0 {
	meta:
		name = "_dsin"
		size = 376
		refs = "0013 _dtest 0038 _dquad 0042 _Rteps_C 004a __xmm@80000000000000008000000000000000 0073 __real@3ff0000000000000 008f __real@3e21ba39100a2609 0097 __real@3e927df9c661a83b 00a3 __real@3efa019f9030ac63 00af __real@3f56c16c1651fbf6 00bb __real@3fa55555555502b1 00c7 __real@3fdfffffffffffae 00e0 __real@3de5d810c32f8fb0 00e8 __real@3e5ae5e1a1730c8f 00f4 __real@3ec71de34fe4ad4d 0100 __real@3f2a01a019b5e33e 010c __real@3f8111111110f0fa 011c __real@3fc5555555555542 0143 _fperrraise 014b _Nan_C"
	strings:
		$1 = { F2 0F 11 44 24 08 53 48 83 EC 20 48 8D 4C 24 30 8B DA E8 ?? ?? ?? ?? 0F BF C8 85 C9 0F 84 2F 01 00 00 FF C9 0F 84 13 01 00 00 FF C9 0F 84 03 01 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 03 D8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 4C 24 30 0F 28 C2 0F 57 C3 66 0F 2F C8 76 1C 66 0F 2F D1 76 16 F6 C3 01 0F 84 B9 00 00 00 F2 0F 10 0D ?? ?? ?? ?? E9 AC 00 00 00 0F 28 D1 F2 0F 59 D1 F6 C3 01 74 51 0F 28 CA F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 5C 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 5C 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? EB 4F 0F 28 C2 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5C 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 5C 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 59 D1 F2 0F 5C 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 C8 F6 C3 02 74 03 0F 57 CB 0F 28 C1 EB 3D F2 0F 10 44 24 30 EB 35 B9 01 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? EB 21 F6 C3 01 74 0A F2 0F 10 05 ?? ?? ?? ?? EB 06 F2 0F 10 44 24 30 F6 C3 02 74 07 0F 57 05 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_167_4_0 {
	meta:
		name = "get_acsize"
		size = 73
		refs = "0015 _ldunscale"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 54 24 30 48 8D 4C 24 38 E8 ?? ?? ?? ?? 0F BF 4C 24 38 B8 ED 73 48 4D F7 E9 C1 FA 04 8B C2 C1 E8 1F 03 D0 B8 06 00 00 00 8D 14 55 05 00 00 00 48 63 CA 48 3B C8 0F 46 C2 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_312_3_0 {
	meta:
		name = "get_acsize"
		size = 73
		refs = "0015 _dunscale"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 48 8D 54 24 30 48 8D 4C 24 38 E8 ?? ?? ?? ?? 0F BF 4C 24 38 B8 ED 73 48 4D F7 E9 C1 FA 04 8B C2 C1 E8 1F 03 D0 B8 06 00 00 00 8D 14 55 05 00 00 00 48 63 CA 48 3B C8 0F 46 C2 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_167_5_0 {
	meta:
		name = "lgamma_big"
		size = 239
		refs = "0023 __real@3ff0000000000000 002d _ldlog 0035 __real@3fe0000000000000 0060 _ldunscale 0080 _ldscale 0096 __real@3f4a01a01a01a01a 009e __real@3f66c16c16c16c17 00aa __real@3fb5555555555555 00b7 __real@3fdacfe390c97d69 00c7 _fperrraise"
	strings:
		$1 = { 48 8B C4 48 83 EC 68 0F 29 70 E8 0F 29 78 D8 44 0F 29 40 C8 33 D2 0F 28 F8 44 0F 29 48 B8 F2 44 0F 10 0D ?? ?? ?? ?? F2 44 0F 5E C8 E8 ?? ?? ?? ?? F2 0F 5C 3D ?? ?? ?? ?? 48 8D 54 24 78 48 8D 4C 24 70 44 0F 28 C0 41 0F 28 F1 F2 0F 11 7C 24 78 F2 44 0F 5C 05 ?? ?? ?? ?? F2 41 0F 59 F1 E8 ?? ?? ?? ?? F2 0F 10 4C 24 78 0F BF 54 24 70 48 8D 4C 24 78 F2 41 0F 59 C8 F2 0F 11 4C 24 78 E8 ?? ?? ?? ?? 66 85 C0 79 38 F2 0F 10 4C 24 78 0F 28 C6 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5C 05 ?? ?? ?? ?? F2 0F 59 C6 F2 0F 58 05 ?? ?? ?? ?? F2 41 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 C8 EB 10 B9 08 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 4C 24 78 0F 28 74 24 50 0F 28 7C 24 40 44 0F 28 44 24 30 0F 28 C1 44 0F 28 4C 24 20 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_312_5_0 {
	meta:
		name = "lgamma_big"
		size = 239
		refs = "0023 __real@3ff0000000000000 002d _dlog 0035 __real@3fe0000000000000 0060 _dunscale 0080 _dscale 0096 __real@3f4a01a01a01a01a 009e __real@3f66c16c16c16c17 00aa __real@3fb5555555555555 00b7 __real@3fdacfe390c97d69 00c7 _fperrraise"
	strings:
		$1 = { 48 8B C4 48 83 EC 68 0F 29 70 E8 0F 29 78 D8 44 0F 29 40 C8 33 D2 0F 28 F8 44 0F 29 48 B8 F2 44 0F 10 0D ?? ?? ?? ?? F2 44 0F 5E C8 E8 ?? ?? ?? ?? F2 0F 5C 3D ?? ?? ?? ?? 48 8D 54 24 78 48 8D 4C 24 70 44 0F 28 C0 41 0F 28 F1 F2 0F 11 7C 24 78 F2 44 0F 5C 05 ?? ?? ?? ?? F2 41 0F 59 F1 E8 ?? ?? ?? ?? F2 0F 10 4C 24 78 0F BF 54 24 70 48 8D 4C 24 78 F2 41 0F 59 C8 F2 0F 11 4C 24 78 E8 ?? ?? ?? ?? 66 85 C0 79 38 F2 0F 10 4C 24 78 0F 28 C6 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5C 05 ?? ?? ?? ?? F2 0F 59 C6 F2 0F 58 05 ?? ?? ?? ?? F2 41 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 C8 EB 10 B9 08 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 4C 24 78 0F 28 74 24 50 0F 28 7C 24 40 44 0F 28 44 24 30 0F 28 C1 44 0F 28 4C 24 20 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_167_6_0 {
	meta:
		name = "lgammal"
		size = 582
		refs = "0026 _ld_int 0058 _fperrraise 0060 _LInf_C 006d _ldgamma_big 0077 __xmm@80000000000000008000000000000000 008a __real@400921fb54442d18 0092 _ldsin 00ad _ldlog 00c1 lgamma_big 00ea rootapprox 0140 _ldpoly 014d __real@3ff3333333333333 0157 __real@3ff8000000000000 0164 approx 01cd _ldtgamma 01e0 __xmm@7fffffffffffffff7fffffffffffffff 0205 __real@3fe62e42c0000000 020d __real@3e7f7d1cf79abc9e 0224 log1pl"
	strings:
		$1 = { F2 0F 11 44 24 08 55 53 57 48 8B EC 48 83 EC 40 48 8D 4D 30 33 D2 0F 29 74 24 30 F2 0F 11 45 30 0F 29 7C 24 20 E8 ?? ?? ?? ?? 0F BF C8 33 D2 F2 0F 10 7D 20 85 C9 74 11 FF C9 74 20 FF C9 75 29 F2 0F 11 F8 E9 EB 01 00 00 0F 57 C0 66 0F 2F C7 72 17 B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? E9 CB 01 00 00 F2 0F 10 0D ?? ?? ?? ?? 0F 28 C1 0F 57 05 ?? ?? ?? ?? 66 0F 2F C7 76 50 F2 0F 5C 7D 30 F2 0F 59 3D ?? ?? ?? ?? 0F 28 C7 E8 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 33 D2 F2 0F 59 45 20 F2 0F 5E C8 0F 28 C1 E8 ?? ?? ?? ?? 0F 28 F0 F2 0F 10 45 20 0F 57 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? F2 0F 5C F0 0F 28 C6 E9 63 01 00 00 66 0F 2F F9 72 0D 0F 28 C7 E8 ?? ?? ?? ?? E9 50 01 00 00 44 8B C2 48 8D 0D ?? ?? ?? ?? 66 0F 2F 79 F8 76 0A F2 0F 10 01 66 0F 2F C7 77 10 41 FF C0 48 83 C1 30 49 63 C0 48 83 F8 0B 72 DF 49 63 C0 48 83 F8 0B 73 31 48 8D 14 40 48 8D 05 ?? ?? ?? ?? 48 03 D2 F2 0F 5C 7C D0 10 44 8B 44 D0 28 F2 0F 5C 7C D0 18 48 8B 54 D0 20 0F 28 C7 E8 ?? ?? ?? ?? E9 EB 00 00 00 66 0F 2F 3D ?? ?? ?? ?? 76 71 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C7 76 63 48 8D 3D ?? ?? ?? ?? 48 8B CF F2 0F 10 01 66 0F 2F C7 77 0F FF C2 48 83 C1 30 48 63 C2 48 83 F8 01 72 E7 48 63 C2 48 8D 1C 40 48 03 DB F2 0F 5C 7C DF 08 44 8B 44 DF 18 48 8B 54 DF 10 0F 28 C7 E8 ?? ?? ?? ?? 44 8B 44 DF 28 48 8B 54 DF 20 0F 28 F0 0F 28 C7 E8 ?? ?? ?? ?? F2 0F 5E F0 E9 05 FF FF FF 48 8D 55 28 48 8D 4D 20 E8 ?? ?? ?? ?? 33 D2 F2 0F 11 45 30 F2 0F 10 45 20 0F 54 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F BF 45 28 F7 D8 0F 57 05 ?? ?? ?? ?? 66 0F 6E C8 F3 0F E6 C9 0F 28 D1 F2 0F 59 0D ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? F2 0F 58 D0 F2 0F 10 45 30 F2 0F 58 D1 F2 0F 11 55 20 E8 ?? ?? ?? ?? F2 0F 10 4D 20 F2 0F 58 C8 0F 28 C1 0F 28 74 24 30 0F 28 7C 24 20 48 83 C4 40 5F 5B 5D C3 }
	condition:
		$1
}

rule file_312_4_0 {
	meta:
		name = "lgamma"
		size = 582
		refs = "0026 _d_int 0058 _fperrraise 0060 _Inf_C 006d _dgamma_big 0077 __xmm@80000000000000008000000000000000 008a __real@400921fb54442d18 0092 _dsin 00ad _dlog 00c1 lgamma_big 00ea rootapprox 0140 _dpoly 014d __real@3ff3333333333333 0157 __real@3ff8000000000000 0164 approx 01cd _dtgamma 01e0 __xmm@7fffffffffffffff7fffffffffffffff 0205 __real@3fe62e42c0000000 020d __real@3e7f7d1cf79abc9e 0224 log1p"
	strings:
		$1 = { F2 0F 11 44 24 08 55 53 57 48 8B EC 48 83 EC 40 48 8D 4D 30 33 D2 0F 29 74 24 30 F2 0F 11 45 30 0F 29 7C 24 20 E8 ?? ?? ?? ?? 0F BF C8 33 D2 F2 0F 10 7D 20 85 C9 74 11 FF C9 74 20 FF C9 75 29 F2 0F 11 F8 E9 EB 01 00 00 0F 57 C0 66 0F 2F C7 72 17 B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? E9 CB 01 00 00 F2 0F 10 0D ?? ?? ?? ?? 0F 28 C1 0F 57 05 ?? ?? ?? ?? 66 0F 2F C7 76 50 F2 0F 5C 7D 30 F2 0F 59 3D ?? ?? ?? ?? 0F 28 C7 E8 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 33 D2 F2 0F 59 45 20 F2 0F 5E C8 0F 28 C1 E8 ?? ?? ?? ?? 0F 28 F0 F2 0F 10 45 20 0F 57 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? F2 0F 5C F0 0F 28 C6 E9 63 01 00 00 66 0F 2F F9 72 0D 0F 28 C7 E8 ?? ?? ?? ?? E9 50 01 00 00 44 8B C2 48 8D 0D ?? ?? ?? ?? 66 0F 2F 79 F8 76 0A F2 0F 10 01 66 0F 2F C7 77 10 41 FF C0 48 83 C1 30 49 63 C0 48 83 F8 0B 72 DF 49 63 C0 48 83 F8 0B 73 31 48 8D 14 40 48 8D 05 ?? ?? ?? ?? 48 03 D2 F2 0F 5C 7C D0 10 44 8B 44 D0 28 F2 0F 5C 7C D0 18 48 8B 54 D0 20 0F 28 C7 E8 ?? ?? ?? ?? E9 EB 00 00 00 66 0F 2F 3D ?? ?? ?? ?? 76 71 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C7 76 63 48 8D 3D ?? ?? ?? ?? 48 8B CF F2 0F 10 01 66 0F 2F C7 77 0F FF C2 48 83 C1 30 48 63 C2 48 83 F8 01 72 E7 48 63 C2 48 8D 1C 40 48 03 DB F2 0F 5C 7C DF 08 44 8B 44 DF 18 48 8B 54 DF 10 0F 28 C7 E8 ?? ?? ?? ?? 44 8B 44 DF 28 48 8B 54 DF 20 0F 28 F0 0F 28 C7 E8 ?? ?? ?? ?? F2 0F 5E F0 E9 05 FF FF FF 48 8D 55 28 48 8D 4D 20 E8 ?? ?? ?? ?? 33 D2 F2 0F 11 45 30 F2 0F 10 45 20 0F 54 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F BF 45 28 F7 D8 0F 57 05 ?? ?? ?? ?? 66 0F 6E C8 F3 0F E6 C9 0F 28 D1 F2 0F 59 0D ?? ?? ?? ?? F2 0F 59 15 ?? ?? ?? ?? F2 0F 58 D0 F2 0F 10 45 30 F2 0F 58 D1 F2 0F 11 55 20 E8 ?? ?? ?? ?? F2 0F 10 4D 20 F2 0F 58 C8 0F 28 C1 0F 28 74 24 30 0F 28 7C 24 20 48 83 C4 40 5F 5B 5D C3 }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "fegetexceptflag"
		size = 46
		refs = "0019 _getfpstatusword"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 83 E3 1F 75 04 21 19 EB 09 E8 ?? ?? ?? ?? 23 C3 89 07 33 C0 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "fminl"
		size = 110
		refs = "0016 _ldtest"
	strings:
		$1 = { F2 0F 11 4C 24 10 F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 83 F8 02 75 08 F2 0F 10 44 24 38 EB 41 48 8D 4C 24 38 E8 ?? ?? ?? ?? 66 83 F8 02 75 08 F2 0F 10 44 24 30 EB 29 F2 0F 10 44 24 38 F2 0F 10 4C 24 30 66 0F 2F C1 77 14 66 0F 2E C8 7A 11 75 0F B8 00 80 00 00 66 85 44 24 36 74 03 0F 28 C1 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_802_0_0 {
	meta:
		name = "fmin"
		size = 110
		refs = "0016 _dtest"
	strings:
		$1 = { F2 0F 11 4C 24 10 F2 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 83 F8 02 75 08 F2 0F 10 44 24 38 EB 41 48 8D 4C 24 38 E8 ?? ?? ?? ?? 66 83 F8 02 75 08 F2 0F 10 44 24 30 EB 29 F2 0F 10 44 24 38 F2 0F 10 4C 24 30 66 0F 2F C1 77 14 66 0F 2E C8 7A 11 75 0F B8 00 80 00 00 66 85 44 24 36 74 03 0F 28 C1 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "ctanhf"
		size = 384
		refs = "0021 crealf 002f cimagf 003d _fdtest 0065 _FZero_C 006c __xmm@80000000800000008000000080000000 007f __real@bf800000 008c __real@3f800000 00b7 __real@00000000 00d8 _FNan_C 00e7 tanf 00f4 sinhf 0121 _FInf_C 0150 sqrtf 0161 _FCbuild"
	strings:
		$1 = { 48 8B C4 48 89 58 20 48 89 48 08 55 48 8B EC 48 83 EC 50 0F 29 70 E8 0F 29 78 D8 44 0F 29 40 C8 E8 ?? ?? ?? ?? 48 8B 4D 10 F3 0F 11 45 20 E8 ?? ?? ?? ?? 48 8D 4D 20 F3 0F 11 45 18 E8 ?? ?? ?? ?? 48 8D 4D 18 0F B7 D8 E8 ?? ?? ?? ?? 66 83 FB 01 75 42 B8 00 80 00 00 0F 57 C0 66 85 45 1A 74 11 F3 0F 10 0D ?? ?? ?? ?? 0F 57 0D ?? ?? ?? ?? EB 03 0F 28 C8 0F 2F 45 20 76 0D F3 0F 10 05 ?? ?? ?? ?? E9 D8 00 00 00 F3 0F 10 05 ?? ?? ?? ?? E9 CB 00 00 00 66 83 F8 02 75 0E F3 0F 10 4D 18 F3 0F 10 C1 E9 B7 00 00 00 66 83 FB 02 75 1F F3 0F 10 4D 18 0F 2E 0D ?? ?? ?? ?? 7A 02 74 05 F3 0F 10 4D 20 F3 0F 10 45 20 E9 92 00 00 00 66 83 F8 01 75 0D F3 0F 10 05 ?? ?? ?? ?? 0F 28 C8 EB 7F F3 0F 10 45 18 E8 ?? ?? ?? ?? 0F 28 F0 F3 0F 10 45 20 E8 ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? 0F 28 FE F3 0F 59 FE F3 0F 58 FA F3 0F 59 F8 44 0F 28 C7 F3 44 0F 59 C0 F3 44 0F 58 C2 44 0F 2E 05 ?? ?? ?? ?? 7A 1B 75 19 0F 57 C9 0F 2F C8 76 08 F3 0F 10 15 ?? ?? ?? ?? F3 0F 59 F1 0F 28 C2 EB 1B F3 0F 59 C0 F3 41 0F 5E F0 F3 0F 58 C2 E8 ?? ?? ?? ?? F3 0F 59 C7 F3 41 0F 5E C0 0F 28 CE E8 ?? ?? ?? ?? 48 8B 5C 24 78 0F 28 74 24 40 0F 28 7C 24 30 44 0F 28 44 24 20 48 83 C4 50 5D C3 }
	condition:
		$1
}

rule file_173_4_0 {
	meta:
		name = "_mbsnicoll_l"
		size = 311
		refs = "002d ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0048 _errno 0053 _invalid_parameter_noinfo 0098 _strnicoll_l 00a9 _mbsnbcnt_l 00ef __crtCompareStringA"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 60 4C 8B F1 48 8B EA 48 8D 48 D8 49 8B D1 49 8B D9 49 8B F0 E8 ?? ?? ?? ?? 48 85 F6 75 07 33 FF E9 CA 00 00 00 4D 85 F6 74 05 48 85 ED 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? BF FF FF FF 7F E9 A6 00 00 00 BF FF FF FF 7F 48 3B F7 76 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 87 00 00 00 48 8B 44 24 48 49 8B CE 83 78 08 00 75 12 4C 8B CB 4C 8B C6 48 8B D5 E8 ?? ?? ?? ?? 8B F8 EB 67 4C 8D 44 24 40 48 8B D6 E8 ?? ?? ?? ?? 4C 8D 44 24 40 48 8B D6 48 8B CD 48 8B D8 E8 ?? ?? ?? ?? 48 8B 54 24 48 4D 8B CE 8B 4A 04 48 8B 92 20 02 00 00 41 B8 01 10 00 00 89 4C 24 38 89 44 24 30 48 8D 4C 24 40 48 89 6C 24 28 89 5C 24 20 E8 ?? ?? ?? ?? 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 03 8D 78 FE 80 7C 24 58 00 74 0C 48 8B 44 24 50 83 A0 C8 00 00 00 FD 4C 8D 5C 24 60 8B C7 49 8B 5B 10 49 8B 6B 18 49 8B 73 20 49 8B 7B 28 49 8B E3 41 5E C3 }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "copysignl"
		size = 56
		altNames = "copysign"
	strings:
		$1 = { F2 0F 11 44 24 08 F2 0F 11 4C 24 10 48 8B 44 24 10 48 8B C8 BA FF 7F 00 00 48 C1 E8 30 48 C1 E9 30 66 33 4C 24 0E 66 23 CA 66 33 C8 66 89 4C 24 0E F2 0F 10 44 24 08 C3 }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "__sse2_tanhf4"
		size = 272
		refs = "0011 s_fTh 0018 s_fRS 001f s_dwAbsMask 002d s_dwIndexMask 0058 s_fTen 0067 s_dwPosInf 0079 s_fOne 0097 s_fA2 00a1 s_fA0 00ac s_fA3 00b6 s_fA1"
	strings:
		$1 = { 48 83 EC 48 0F 29 7C 24 20 0F 29 74 24 30 4C 8D 0D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 3D ?? ?? ?? ?? 66 0F DB F8 0F 58 F7 0F 28 15 ?? ?? ?? ?? 66 0F DB D6 66 0F 7E D0 66 0F 70 D2 39 66 0F 7E D2 66 0F 70 D2 39 66 0F 7E D1 66 0F 70 D2 39 66 41 0F 7E D0 0F 28 1D ?? ?? ?? ?? 0F C2 DF 02 66 0F EF C7 0F 28 15 ?? ?? ?? ?? 0F 28 CF 0F C2 CA 02 66 0F DB CB 0F 28 2D ?? ?? ?? ?? 66 0F DB E9 0F 28 15 ?? ?? ?? ?? 0F 5C F2 0F 5C FE 0F 28 E7 0F 59 E7 0F 28 1D ?? ?? ?? ?? 0F 59 DC 0F 58 1D ?? ?? ?? ?? 66 0F EB C5 0F 28 15 ?? ?? ?? ?? 0F 59 E2 0F 58 25 ?? ?? ?? ?? 0F 59 E7 F3 41 0F 7E 14 81 F3 41 0F 7E 3C 91 F3 41 0F 7E 34 89 F3 43 0F 7E 2C 81 0F 14 D7 0F 14 F5 0F C6 D6 44 0F 28 F3 0F 59 F2 0F 58 F4 0F 59 E2 0F 58 E3 0F 5E F4 66 0F DF CE 66 0F EB C1 0F 28 74 24 30 0F 28 7C 24 20 48 83 C4 48 C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "feclearexcept"
		size = 70
		refs = "0016 _getfpstatusword 0027 _setfpstatusword 002e fetestexcept"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B D9 83 E3 1F 75 04 33 C0 EB 26 E8 ?? ?? ?? ?? 8B F8 85 C3 74 F1 F7 D3 23 FB 8B CF E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 33 C9 3B C7 0F 95 C1 8B C1 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "cbrt"
		size = 379
		refs = "0021 _dunscale 008c _dscale 00ac __xmm@80000000000000008000000000000000 00b9 __real@3fe0000000000000 00c7 __real@3fcf3482be8bc16a 00cf __real@3fd1e54b48d3ae68 00d7 __real@3feea8826aa8eb46 00e2 __real@3ff8000000000000 00f2 __real@3fb43419e30014f9"
	strings:
		$1 = { 48 89 5C 24 20 F2 0F 11 44 24 08 55 48 8B EC 48 83 EC 30 48 8D 55 10 48 8D 4D 18 0F 29 74 24 20 E8 ?? ?? ?? ?? 0F BF C8 83 F9 02 77 0A F2 0F 10 45 10 E9 34 01 00 00 44 0F BF 45 18 45 33 C9 B8 56 55 55 55 41 8D 59 01 41 F7 E8 8B C2 C1 E8 1F 03 D0 8D 04 52 41 3B C0 74 3B 66 44 03 C3 B8 56 55 55 55 44 2B CB 41 0F BF C8 F7 E9 8B C2 C1 E8 1F 03 D0 8D 04 52 3B C1 75 E0 66 44 89 45 18 45 85 C9 79 11 48 8D 4D 10 41 8B D1 E8 ?? ?? ?? ?? 44 0F B7 45 18 F2 0F 10 6D 10 B8 00 80 00 00 66 85 45 16 75 04 33 DB EB 0C 0F 57 2D ?? ?? ?? ?? F2 0F 11 6D 10 F2 0F 10 1D ?? ?? ?? ?? 0F 28 E5 0F 28 C5 F2 0F 59 25 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 25 ?? ?? ?? ?? 0F 28 F5 F2 0F 59 35 ?? ?? ?? ?? F2 0F 59 E5 F2 0F 59 EB F2 0F 58 25 ?? ?? ?? ?? 0F 28 D6 0F 28 CD F2 0F 5E E0 F2 0F 5E CC 0F 28 C4 F2 0F 59 C4 F2 0F 58 C8 F2 0F 5E D1 F2 0F 58 D4 F2 0F 59 D3 F2 0F 5E EA 0F 28 C2 F2 0F 59 C2 F2 0F 58 E8 F2 0F 5E F5 F2 0F 58 F2 F2 0F 59 F3 F2 0F 11 75 20 85 DB 74 0C 0F 57 35 ?? ?? ?? ?? F2 0F 11 75 20 41 0F BF C8 B8 56 55 55 55 F7 E9 48 8D 4D 20 8B C2 C1 E8 1F 03 D0 E8 ?? ?? ?? ?? F2 0F 10 45 20 48 8B 5C 24 58 0F 28 74 24 20 48 83 C4 30 5D C3 }
	condition:
		$1
}

rule file_962_0_0 {
	meta:
		name = "cbrtl"
		size = 379
		refs = "0021 _ldunscale 008c _ldscale 00ac __xmm@80000000000000008000000000000000 00b9 __real@3fe0000000000000 00c7 __real@3fcf3482be8bc16a 00cf __real@3fd1e54b48d3ae68 00d7 __real@3feea8826aa8eb46 00e2 __real@3ff8000000000000 00f2 __real@3fb43419e30014f9"
	strings:
		$1 = { 48 89 5C 24 20 F2 0F 11 44 24 08 55 48 8B EC 48 83 EC 30 48 8D 55 10 48 8D 4D 18 0F 29 74 24 20 E8 ?? ?? ?? ?? 0F BF C8 83 F9 02 77 0A F2 0F 10 45 10 E9 34 01 00 00 44 0F BF 45 18 45 33 C9 B8 56 55 55 55 41 8D 59 01 41 F7 E8 8B C2 C1 E8 1F 03 D0 8D 04 52 41 3B C0 74 3B 66 44 03 C3 B8 56 55 55 55 44 2B CB 41 0F BF C8 F7 E9 8B C2 C1 E8 1F 03 D0 8D 04 52 3B C1 75 E0 66 44 89 45 18 45 85 C9 79 11 48 8D 4D 10 41 8B D1 E8 ?? ?? ?? ?? 44 0F B7 45 18 F2 0F 10 6D 10 B8 00 80 00 00 66 85 45 16 75 04 33 DB EB 0C 0F 57 2D ?? ?? ?? ?? F2 0F 11 6D 10 F2 0F 10 1D ?? ?? ?? ?? 0F 28 E5 0F 28 C5 F2 0F 59 25 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 25 ?? ?? ?? ?? 0F 28 F5 F2 0F 59 35 ?? ?? ?? ?? F2 0F 59 E5 F2 0F 59 EB F2 0F 58 25 ?? ?? ?? ?? 0F 28 D6 0F 28 CD F2 0F 5E E0 F2 0F 5E CC 0F 28 C4 F2 0F 59 C4 F2 0F 58 C8 F2 0F 5E D1 F2 0F 58 D4 F2 0F 59 D3 F2 0F 5E EA 0F 28 C2 F2 0F 59 C2 F2 0F 58 E8 F2 0F 5E F5 F2 0F 58 F2 F2 0F 59 F3 F2 0F 11 75 20 85 DB 74 0C 0F 57 35 ?? ?? ?? ?? F2 0F 11 75 20 41 0F BF C8 B8 56 55 55 55 F7 E9 48 8D 4D 20 8B C2 C1 E8 1F 03 D0 E8 ?? ?? ?? ?? F2 0F 10 45 20 48 8B 5C 24 58 0F 28 74 24 20 48 83 C4 30 5D C3 }
	condition:
		$1
}

rule file_180_3_0 {
	meta:
		name = "_towlower_l"
		size = 202
		refs = "0025 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0060 iswctype 009b __crtLCMapStringW"
	strings:
		$1 = { 48 89 5C 24 10 66 89 4C 24 08 55 48 8B EC 48 83 EC 50 B8 FF FF 00 00 66 3B C8 0F 84 9F 00 00 00 48 8D 4D E0 E8 ?? ?? ?? ?? 48 8B 5D E0 48 8B 83 38 01 00 00 48 85 C0 75 13 0F B7 55 10 8D 42 BF 66 83 F8 19 77 65 66 83 C2 20 EB 5F 0F B7 4D 10 BA 00 01 00 00 66 3B CA 73 25 BA 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 06 0F B7 55 10 EB 3D 0F B7 4D 10 48 8B 83 10 01 00 00 0F B6 14 08 EB 2C 48 8D 4D 20 41 B9 01 00 00 00 4C 8D 45 10 44 89 4C 24 28 48 89 4C 24 20 48 8B C8 E8 ?? ?? ?? ?? 0F B7 55 10 85 C0 74 04 0F B7 55 20 80 7D F8 00 74 0B 48 8B 4D F0 83 A1 C8 00 00 00 FD 0F B7 C2 48 8B 5C 24 68 48 83 C4 50 5D C3 }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "_dupenv_s"
		size = 258
		refs = "0028 _lock 003c _errno 0048 _invalid_parameter_noinfo 0069 _getenv_helper_nolock 0079 strlen 008a calloc 00b4 strcpy_s 00ca _unlock 00e2 _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 4C 89 70 20 41 57 48 83 EC 30 49 8B F0 48 8B FA 4C 8B F1 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 33 DB 8B C3 4D 85 F6 0F 95 C0 85 C0 75 13 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? EB 76 49 89 1E 48 85 FF 74 03 48 89 1F 8B C3 48 85 F6 0F 95 C0 85 C0 74 D6 48 8B CE E8 ?? ?? ?? ?? 4C 8B F8 48 85 C0 74 4F 48 8B C8 E8 ?? ?? ?? ?? BA 01 00 00 00 48 8D 34 02 48 8B CE E8 ?? ?? ?? ?? 49 89 06 48 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 18 EB 1A 4D 8B C7 48 8B D6 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 16 48 85 FF 74 03 48 89 37 B9 07 00 00 00 E8 ?? ?? ?? ?? 8B C3 EB 15 48 89 5C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 90 48 8B 5C 24 40 48 8B 74 24 48 48 8B 7C 24 50 4C 8B 74 24 58 48 83 C4 30 41 5F C3 }
	condition:
		$1
}

rule file_181_1_0 {
	meta:
		name = "_dupenv_s$fin$0"
		size = 25
		refs = "0014 _unlock"
		altNames = "_wdupenv_s$fin$0 _wgetenv_s$fin$0 getenv_s$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA B9 07 00 00 00 48 83 C4 30 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_181_2_0 {
	meta:
		name = "_dupenv_s_helper"
		size = 212
		refs = "0020 _errno 002c _invalid_parameter_noinfo 005d _getenv_helper_nolock 0071 strlen 0082 calloc 00ac strcpy_s 00cf _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 30 48 8B DA 48 8B F1 48 85 C9 75 28 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 48 83 21 00 48 85 D2 74 04 48 83 22 00 4D 85 C0 74 C6 49 8B C8 E8 ?? ?? ?? ?? 48 8B E8 48 85 C0 75 04 33 C0 EB C5 48 8B C8 E8 ?? ?? ?? ?? BA 01 00 00 00 48 8D 3C 02 48 8B CF E8 ?? ?? ?? ?? 48 89 06 48 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 EB 90 4C 8B C5 48 8B D7 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 0A 48 85 DB 74 B0 48 89 3B EB AB 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_181_3_0 {
	meta:
		name = "_getenv_helper_nolock"
		size = 162
		refs = "0011 __env_initialized 0019 _environ 002a _wenviron 0031 __wtomb_environ 004e strlen 0077 _mbsnbicoll"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 83 3D ?? ?? ?? ?? 00 48 8B 1D ?? ?? ?? ?? 48 8B F1 74 6E 48 85 DB 75 1E 48 39 1D ?? ?? ?? ?? 74 60 E8 ?? ?? ?? ?? 85 C0 75 57 48 8B 1D ?? ?? ?? ?? 48 85 DB 74 4B 48 85 F6 74 46 48 8B CE E8 ?? ?? ?? ?? 48 8B F8 48 8B 0B 48 85 C9 74 33 E8 ?? ?? ?? ?? 48 3B C7 76 18 48 8B 0B 80 3C 39 3D 75 0F 4C 8B C7 48 8B D6 E8 ?? ?? ?? ?? 85 C0 74 06 48 83 C3 08 EB D0 48 8B 03 48 FF C0 48 03 C7 EB 02 33 C0 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_181_4_0 {
	meta:
		name = "_getenv_s_helper"
		size = 196
		refs = "0024 _errno 0030 _invalid_parameter_noinfo 006d _getenv_helper_nolock 0081 strlen 00a6 strcpy_s 00bf _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 56 48 83 EC 30 49 8B D8 48 8B FA 4C 8B F1 48 85 C9 75 29 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 40 48 8B 74 24 48 48 8B 7C 24 50 48 83 C4 30 41 5E C3 48 83 21 00 48 85 D2 74 07 48 85 DB 75 07 EB C7 48 85 DB 75 C2 48 85 D2 74 03 C6 02 00 49 8B C9 E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 75 04 33 C0 EB B9 48 8B C8 E8 ?? ?? ?? ?? 48 FF C0 49 89 06 48 85 DB 74 E9 48 3B C3 76 07 B8 22 00 00 00 EB 9A 4C 8B C6 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 CB 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_181_6_0 {
	meta:
		name = "getenv"
		size = 107
		refs = "0016 _errno 0021 _invalid_parameter_noinfo 002f strnlen 0048 _lock 0051 _getenv_helper_nolock 005e _unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 33 C0 48 85 C9 0F 95 C0 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 3C BA FF 7F 00 00 E8 ?? ?? ?? ?? 33 C9 48 3D FF 7F 00 00 0F 92 C1 85 C9 74 D3 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 48 8B CB E8 ?? ?? ?? ?? 48 8B D8 B9 07 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_1030_4_0 {
	meta:
		name = "_wgetenv"
		size = 107
		refs = "0016 _errno 0021 _invalid_parameter_noinfo 002f wcsnlen 0048 _lock 0051 _wgetenv_helper_nolock 005e _unlock"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 33 C0 48 85 C9 0F 95 C0 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 3C BA FF 7F 00 00 E8 ?? ?? ?? ?? 33 C9 48 3D FF 7F 00 00 0F 92 C1 85 C9 74 D3 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 48 8B CB E8 ?? ?? ?? ?? 48 8B D8 B9 07 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_181_8_0 {
	meta:
		name = "getenv_s"
		size = 251
		refs = "002b _lock 003f _errno 004b _invalid_parameter_noinfo 0080 _getenv_helper_nolock 0090 strlen 00b5 strcpy_s 00c3 _unlock 00db _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 4C 89 70 20 41 57 48 83 EC 30 4D 8B F1 49 8B F0 48 8B FA 4C 8B F9 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 33 DB 8B C3 4D 85 FF 0F 95 C0 85 C0 75 13 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? EB 6C 49 89 1F 48 85 FF 74 0A 48 85 F6 75 0A 48 85 FF 75 0C 48 85 F6 75 07 B8 01 00 00 00 EB 02 8B C3 85 C0 74 C9 48 85 FF 74 02 88 1F 49 8B CE E8 ?? ?? ?? ?? 4C 8B F0 48 85 C0 74 31 48 8B C8 E8 ?? ?? ?? ?? 48 FF C0 49 89 07 48 85 F6 74 1E 48 3B C6 76 07 BB 22 00 00 00 EB 12 4D 8B C6 48 8B D6 48 8B CF E8 ?? ?? ?? ?? 85 C0 75 0E B9 07 00 00 00 E8 ?? ?? ?? ?? 8B C3 EB 15 48 89 5C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 90 48 8B 5C 24 40 48 8B 74 24 48 48 8B 7C 24 50 4C 8B 74 24 58 48 83 C4 30 41 5F C3 }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "_snwscanf"
		size = 54
		refs = "0028 _winput_l 002d vscan_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 49 8D 43 20 4C 8B C2 48 8B D1 49 89 43 F0 49 83 63 E8 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_426_0_0 {
	meta:
		name = "_snscanf"
		size = 54
		refs = "0028 _input_l 002d vscan_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 49 8D 43 20 4C 8B C2 48 8B D1 49 89 43 F0 49 83 63 E8 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_426_2_0 {
	meta:
		name = "_snscanf_s"
		size = 54
		refs = "0028 _input_s_l 002d vscan_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 49 8D 43 20 4C 8B C2 48 8B D1 49 89 43 F0 49 83 63 E8 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_182_2_0 {
	meta:
		name = "_snwscanf_s"
		size = 54
		refs = "0028 _winput_s_l 002d vscan_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 43 18 4D 89 4B 20 48 83 EC 38 4D 8B C8 49 8D 43 20 4C 8B C2 48 8B D1 49 89 43 F0 49 83 63 E8 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_182_1_0 {
	meta:
		name = "_snwscanf_l"
		size = 49
		refs = "0023 _winput_l 0028 vscan_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 4B 20 48 83 EC 38 49 8D 43 28 49 89 43 F0 4D 89 4B E8 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_426_1_0 {
	meta:
		name = "_snscanf_l"
		size = 49
		refs = "0023 _input_l 0028 vscan_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 4B 20 48 83 EC 38 49 8D 43 28 49 89 43 F0 4D 89 4B E8 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_426_3_0 {
	meta:
		name = "_snscanf_s_l"
		size = 49
		refs = "0023 _input_s_l 0028 vscan_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 4B 20 48 83 EC 38 49 8D 43 28 49 89 43 F0 4D 89 4B E8 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_182_3_0 {
	meta:
		name = "_snwscanf_s_l"
		size = 49
		refs = "0023 _winput_s_l 0028 vscan_fn"
	strings:
		$1 = { 4C 8B DC 4D 89 4B 20 48 83 EC 38 49 8D 43 28 49 89 43 F0 4D 89 4B E8 4D 8B C8 4C 8B C2 48 8B D1 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_182_4_0 {
	meta:
		name = "vscan_fn"
		size = 174
		refs = "0030 memset 003a _errno 0045 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 57 48 83 EC 50 48 83 60 C8 00 48 8B DA 33 D2 49 8B F8 48 8B E9 44 8D 42 28 48 8D 48 D0 49 8B F1 E8 ?? ?? ?? ?? 48 85 DB 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4B 48 85 F6 74 E6 C7 44 24 38 49 00 00 00 48 89 5C 24 30 48 89 5C 24 20 48 81 FF FF FF FF 3F 76 0A C7 44 24 28 FF FF FF 7F EB 07 8D 04 3F 89 44 24 28 4C 8B 8C 24 88 00 00 00 4C 8B 84 24 80 00 00 00 48 8D 4C 24 20 48 8B D6 FF D5 48 8B 5C 24 60 48 8B 6C 24 68 48 8B 74 24 70 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_184_9_0 {
	meta:
		name = "??0FreeVirtualProcessorRoot@details@Concurrency@@QEAA@PEAVSchedulerProxy@12@PEAUSchedulerNode@12@I@Z"
		size = 55
		refs = "000a ??0VirtualProcessorRoot@details@Concurrency@@QEAA@PEAVSchedulerProxy@12@PEAUSchedulerNode@12@I@Z 0011 ??_7FreeVirtualProcessorRoot@details@Concurrency@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 C7 83 80 00 00 00 00 00 00 00 48 C7 83 88 00 00 00 00 00 00 00 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_184_20_0 {
	meta:
		name = "??1FreeVirtualProcessorRoot@details@Concurrency@@UEAA@XZ"
		size = 22
		refs = "0003 ??_7VirtualProcessorRoot@details@Concurrency@@6B@ 000d ??_7ExecutionResource@details@Concurrency@@6B@"
		altNames = "??1VirtualProcessorRoot@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8D 05 ?? ?? ?? ?? 48 89 41 10 C3 }
	condition:
		$1
}

rule file_184_29_0 {
	meta:
		name = "??8HardwareAffinity@details@Concurrency@@QEAA_NAEBU012@@Z"
		size = 27
	strings:
		$1 = { 0F B7 41 08 66 39 42 08 75 0E 48 8B 01 48 39 02 75 06 B8 01 00 00 00 C3 33 C0 C3 }
	condition:
		$1
}

rule file_184_30_0 {
	meta:
		name = "??9HardwareAffinity@details@Concurrency@@QEAA_NAEBU012@@Z"
		size = 34
	strings:
		$1 = { 0F B7 41 08 45 33 C0 66 39 42 08 75 0C 48 8B 01 48 39 02 41 8D 40 01 74 03 41 8B C0 84 C0 0F 94 C0 C3 }
	condition:
		$1
}

rule file_184_39_0 {
	meta:
		name = "??_GFreeVirtualProcessorRoot@details@Concurrency@@UEAAPEAXI@Z"
		size = 49
		refs = "0009 ??_7VirtualProcessorRoot@details@Concurrency@@6B@ 0016 ??_7ExecutionResource@details@Concurrency@@6B@ 0024 ??3@YAXPEAX@Z"
		altNames = "??_GVirtualProcessorRoot@details@Concurrency@@UEAAPEAXI@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 48 8D 05 ?? ?? ?? ?? 48 89 41 10 F6 C2 01 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_184_45_0 {
	meta:
		name = "?AcquireActivatedContext@VirtualProcessorRoot@details@Concurrency@@QEAAPEAUIExecutionContext@3@XZ"
		size = 69
		refs = "000e ?_Sleep0@details@Concurrency@@YAXXZ 0026 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 40 53 48 83 EC 40 83 64 24 28 00 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 44 24 30 48 8B 41 08 EB 0E 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 43 08 48 85 C0 74 ED 48 8B 43 08 48 C7 43 08 00 00 00 00 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_184_46_0 {
	meta:
		name = "?Activate@FreeVirtualProcessorRoot@details@Concurrency@@UEAAXPEAUIExecutionContext@3@@Z"
		size = 310
		refs = "005e ?_Sleep0@details@Concurrency@@YAXXZ 007b ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ 00b2 ?Subscribe@VirtualProcessorRoot@details@Concurrency@@QEAAXXZ 00bd ?Affinitize@FreeVirtualProcessorRoot@details@Concurrency@@QEAAXPEAVFreeThreadProxy@23@@Z 00c5 ?ResumeExecution@ThreadProxy@details@Concurrency@@QEAAXXZ 00de ??_C@_08BAFMHLII@pContext?$AA@ 00f8 ??0exception@std@@QEAA@AEBQEBD@Z 00ff ??_7invalid_argument@std@@6B@ 0106 _TI3?AVinvalid_argument@std@@ 0115 _CxxThrowException 0120 ??0invalid_operation@Concurrency@@QEAA@XZ 0127 _TI2?AVinvalid_operation@Concurrency@@"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 18 57 48 83 EC 70 48 8B FA 48 8B D9 48 85 D2 0F 84 BD 00 00 00 48 8B 02 48 8B CA FF 50 10 48 8B F0 48 85 C0 75 10 48 8B 4B 30 48 8B D7 48 8B 01 FF 50 38 48 8B F0 B8 01 00 00 00 F0 0F C1 43 78 FF C0 83 F8 02 75 06 48 87 7B 08 EB 73 83 64 24 40 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 48 EB 16 48 8B 83 88 00 00 00 48 85 C0 75 16 48 8D 4C 24 38 E8 ?? ?? ?? ?? 48 8B 83 80 00 00 00 48 85 C0 75 DE 48 8B 83 80 00 00 00 48 85 C0 74 0C 48 8B 83 80 00 00 00 48 3B F0 75 77 48 8B CB 48 C7 83 88 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? 48 8B D6 48 8B CB E8 ?? ?? ?? ?? 48 8B CE E8 ?? ?? ?? ?? 4C 8D 5C 24 70 49 8B 5B 10 49 8B 73 20 49 8B E3 5F C3 48 8D 05 ?? ?? ?? ?? 48 8D 94 24 88 00 00 00 48 8D 4C 24 20 48 89 84 24 88 00 00 00 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 48 89 44 24 20 E8 ?? ?? ?? ?? CC 48 8D 4C 24 50 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_184_47_0 {
	meta:
		name = "?Affinitize@FreeVirtualProcessorRoot@details@Concurrency@@QEAAXPEAVFreeThreadProxy@23@@Z"
		size = 164
		refs = "0019 ?SpinUntilBlocked@ThreadProxy@details@Concurrency@@QEAAXXZ 007e ?ApplyTo@HardwareAffinity@details@Concurrency@@QEAAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 40 48 8B D9 48 8B CA 48 8B F2 E8 ?? ?? ?? ?? 48 89 B3 80 00 00 00 48 89 5E 20 48 8B 03 48 8B 7B 30 48 8B CB FF 10 33 C9 48 89 4C 24 20 48 89 4C 24 28 8B C8 48 8B 47 20 48 C1 E1 06 0F B7 54 01 10 4C 8B 04 01 66 89 54 24 28 4C 89 44 24 20 0F 28 44 24 20 66 0F 7F 44 24 30 66 3B 56 50 75 06 4C 3B 46 48 74 0E 48 8B 56 10 48 8D 4C 24 30 E8 ?? ?? ?? ?? 0F B7 44 24 38 48 8B 5C 24 50 66 89 46 50 48 8B 44 24 30 48 89 46 48 48 8B 74 24 58 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_184_49_0 {
	meta:
		name = "?Deactivate@FreeVirtualProcessorRoot@details@Concurrency@@UEAA_NPEAUIExecutionContext@3@@Z"
		size = 289
		refs = "0065 ?Unsubscribe@VirtualProcessorRoot@details@Concurrency@@QEAAXXZ 006d ?SuspendExecution@ThreadProxy@details@Concurrency@@QEAAXXZ 007a ?_Sleep0@details@Concurrency@@YAXXZ 0089 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ 00bc ??_C@_08BAFMHLII@pContext?$AA@ 00cd ??0exception@std@@QEAA@AEBQEBD@Z 00d4 ??_7invalid_argument@std@@6B@ 00db _TI3?AVinvalid_argument@std@@ 00e8 _CxxThrowException 00f2 ??0invalid_operation@Concurrency@@QEAA@XZ 00f9 _TI2?AVinvalid_operation@Concurrency@@"
	strings:
		$1 = { 48 89 5C 24 08 48 89 7C 24 20 55 48 8B EC 48 81 EC 80 00 00 00 48 8B D9 48 85 D2 0F 84 98 00 00 00 48 8B 81 80 00 00 00 48 85 C0 0F 84 BC 00 00 00 48 8B 02 48 8B CA FF 50 10 48 8B 8B 80 00 00 00 48 8B F8 48 3B C8 0F 85 BA 00 00 00 F0 FF 4B 78 75 20 48 8B 83 80 00 00 00 48 8B CB 48 87 83 88 00 00 00 E8 ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? EB 2F 83 65 C0 00 48 8D 05 ?? ?? ?? ?? 48 89 45 C8 EB 09 48 8D 4D B8 E8 ?? ?? ?? ?? 48 8B 43 08 48 85 C0 74 EE 48 8B 43 08 48 C7 43 08 00 00 00 00 4C 8D 9C 24 80 00 00 00 B0 01 49 8B 5B 10 49 8B 7B 28 49 8B E3 5D C3 48 8D 05 ?? ?? ?? ?? 48 8D 55 20 48 8D 4D A0 48 89 45 20 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D A0 48 89 45 A0 E8 ?? ?? ?? ?? CC 48 8D 4D D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D D0 E8 ?? ?? ?? ?? CC 48 8D 4D E8 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D E8 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_184_50_0 {
	meta:
		name = "?DeleteThis@FreeVirtualProcessorRoot@details@Concurrency@@UEAAXXZ"
		size = 144
		refs = "0018 ?__TlsGetValue@platform@details@Concurrency@@YAPEAXK@Z 004f ?_Sleep0@details@Concurrency@@YAXXZ 006c ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 40 53 48 83 EC 40 48 8B 41 30 48 8B D9 48 8B 50 18 8B 8A B0 00 00 00 E8 ?? ?? ?? ?? 48 8B C8 48 85 C0 74 23 8A D0 80 E2 03 80 FA 01 75 19 48 83 E1 FE 74 13 48 8B 83 80 00 00 00 48 3B C8 75 07 48 83 61 20 00 EB 35 83 64 24 28 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 30 EB 16 48 8B 83 88 00 00 00 48 85 C0 75 16 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 83 80 00 00 00 48 85 C0 75 DE 48 8B 03 BA 01 00 00 00 48 8B CB 48 83 C4 40 5B 48 FF 60 40 }
	condition:
		$1
}

rule file_184_51_0 {
	meta:
		name = "?EnsureAllTasksVisible@FreeVirtualProcessorRoot@details@Concurrency@@UEAAXPEAUIExecutionContext@3@@Z"
		size = 184
		refs = "003d ?FlushStoreBuffers@ResourceManager@details@Concurrency@@QEAAXXZ 0044 ??_C@_08BAFMHLII@pContext?$AA@ 005e ??0exception@std@@QEAA@AEBQEBD@Z 0065 ??_7invalid_argument@std@@6B@ 006c _TI3?AVinvalid_argument@std@@ 007b _CxxThrowException 0086 ??0invalid_operation@Concurrency@@QEAA@XZ 008d _TI2?AVinvalid_operation@Concurrency@@"
	strings:
		$1 = { 40 53 48 83 EC 70 48 8B D9 48 85 D2 74 33 48 8B 81 80 00 00 00 48 85 C0 74 66 48 8B 02 48 8B CA FF 50 10 48 8B 8B 80 00 00 00 48 3B C8 75 6D 48 8B 4B 30 48 8B 49 18 48 83 C4 70 5B E9 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8D 94 24 88 00 00 00 48 8D 4C 24 20 48 89 84 24 88 00 00 00 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 48 89 44 24 20 E8 ?? ?? ?? ?? CC 48 8D 4C 24 38 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 38 E8 ?? ?? ?? ?? CC 48 8D 4C 24 50 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_184_66_0 {
	meta:
		name = "?ResetOnIdle@FreeVirtualProcessorRoot@details@Concurrency@@QEAAXW4SwitchingProxyState@3@@Z"
		size = 183
		refs = "0031 ?Unsubscribe@VirtualProcessorRoot@details@Concurrency@@QEAAXXZ 0049 ?SuspendExecution@ThreadProxy@details@Concurrency@@QEAAXXZ 0057 ?_Sleep0@details@Concurrency@@YAXXZ 006c ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 40 48 8B B9 80 00 00 00 8B EA 48 8B D9 83 C8 FF F0 0F C1 41 78 FF C8 7F 23 85 C0 75 05 E8 ?? ?? ?? ?? 48 C7 83 80 00 00 00 00 00 00 00 83 FD 01 75 5D 48 8B CF E8 ?? ?? ?? ?? EB 53 83 64 24 28 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 30 48 8B 41 08 EB 0E 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 43 08 48 85 C0 74 ED 48 8B 73 08 48 C7 43 08 00 00 00 00 48 8B 06 48 8B CE FF 50 10 48 3B F8 74 0F 48 8B 07 44 8B C5 48 8B D6 48 8B CF FF 50 08 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_184_68_0 {
	meta:
		name = "?SetAffinity@FreeThreadProxy@details@Concurrency@@QEAAXUHardwareAffinity@23@@Z"
		size = 73
		refs = "002b ?ApplyTo@HardwareAffinity@details@Concurrency@@QEAAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 18 57 48 83 EC 20 0F B7 41 50 48 8B FA 48 8B D9 66 39 42 08 75 09 48 8B 41 48 48 39 02 74 0C 48 8B 51 10 48 8B CF E8 ?? ?? ?? ?? 0F B7 47 08 66 89 43 50 48 8B 07 48 89 43 48 48 8B 5C 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_184_70_0 {
	meta:
		name = "?SpinUntilIdle@FreeVirtualProcessorRoot@details@Concurrency@@IEAAXXZ"
		size = 75
		refs = "000e ?_Sleep0@details@Concurrency@@YAXXZ 0035 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QEAA_NXZ"
	strings:
		$1 = { 40 53 48 83 EC 40 83 64 24 28 00 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 44 24 30 48 8B 81 80 00 00 00 EB 1D 48 8B 83 88 00 00 00 48 85 C0 75 16 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 83 80 00 00 00 48 85 C0 75 DE 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "wcscmp"
		size = 57
	strings:
		$1 = { 44 0F B7 02 0F B7 01 41 2B C0 75 1A 48 2B CA 66 45 85 C0 74 11 48 83 C2 02 44 0F B7 02 0F B7 04 11 41 2B C0 74 E9 85 C0 79 04 83 C8 FF C3 B9 01 00 00 00 85 C0 0F 4F C1 C3 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "_lsearch"
		size = 160
		refs = "002d _errno 0038 _invalid_parameter_noinfo 007c memcpy"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 57 48 83 EC 20 33 ED 41 8B F1 49 8B F8 48 8B DA 4C 8B F9 48 85 C9 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 45 4D 85 C0 74 E7 48 85 D2 74 E2 45 85 C9 74 DD 48 39 6C 24 50 74 D6 41 39 28 76 17 48 8B D3 49 8B CF FF 54 24 50 85 C0 74 19 FF C5 48 03 DE 3B 2F 72 E9 4C 8B C6 49 8B D7 48 8B CB E8 ?? ?? ?? ?? FF 07 48 8B C3 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5F C3 }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "_raise_zerodivide"
		size = 32
	strings:
		$1 = { 66 0F 76 C0 66 0F EF C9 66 0F 72 F0 1C F3 0F 5E C1 C3 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_187_1_0 {
	meta:
		name = "__sse2_pow2"
		size = 1152
		refs = "000a s_Data"
	strings:
		$1 = { 48 81 EC 98 00 00 00 48 8D 05 ?? ?? ?? ?? 0F 29 7C 24 70 0F 29 74 24 60 48 89 84 24 80 00 00 00 66 0F 28 D8 66 0F 28 D0 66 0F DB 05 ?? ?? ?? ?? 66 0F 57 F6 4C 8B 84 24 80 00 00 00 66 0F FE 05 ?? ?? ?? ?? BA 00 00 00 00 89 94 24 88 00 00 00 66 0F 73 D0 2A 66 0F 7E C0 66 0F C5 C8 04 66 0F 29 4C 24 20 66 0F C5 D3 03 F3 41 0F 7E 84 C0 50 02 00 00 66 41 0F 16 84 C8 50 02 00 00 66 0F DB 15 ?? ?? ?? ?? 03 C0 66 41 0F 28 BC C0 60 22 00 00 66 0F C5 C3 07 66 0F 29 5C 24 30 66 0F FB 1D ?? ?? ?? ?? 03 C9 66 0F EB 15 ?? ?? ?? ?? 66 0F 72 E3 14 66 0F DB 1D ?? ?? ?? ?? 66 41 0F 28 AC C8 60 22 00 00 66 0F 28 E2 66 0F 29 74 24 40 66 0F FE 1D ?? ?? ?? ?? 66 0F 59 D0 81 EA 10 00 00 80 66 0F 5C 1D ?? ?? ?? ?? 2D 10 00 00 80 81 FA DF 7F 00 80 0F 8F C4 02 00 00 3D DF 7F 00 80 0F 8F B9 02 00 00 66 0F 70 F7 0E 66 0F 14 FD 66 0F 58 DF 66 0F C6 F5 02 66 0F 28 3D ?? ?? ?? ?? 66 0F DB FC 66 0F 5C E7 66 0F 59 F8 66 0F 59 E0 66 0F 5C FA 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 FC 66 0F 28 E3 66 0F 58 DA 66 0F 5C E3 66 0F 58 E2 66 0F 28 C3 66 0F 58 DF 66 0F 5C C3 66 0F 58 C7 66 0F 58 FA 66 0F 58 C4 66 0F 28 D7 66 0F 59 FF 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 E7 66 0F 59 EF 66 0F 58 C6 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 28 F3 66 0F 59 E7 66 0F 59 EF 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E7 66 0F 59 EF 66 0F 28 F9 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F 70 D3 F1 66 0F 58 E5 66 0F 58 C4 66 0F 28 25 ?? ?? ?? ?? 66 0F 58 D8 66 0F 5C F3 66 0F 7E D0 66 0F 70 D2 FF 8B 4C 24 24 66 0F DB 3D ?? ?? ?? ?? 66 0F 58 C6 66 0F DB E3 25 00 00 F0 7F 81 E1 00 00 F0 7F 66 0F 5C DC 03 C1 3D 00 00 90 80 0F 87 DF 01 00 00 66 0F 7E D0 66 0F 59 C1 8B 4C 24 2C 25 00 00 F0 7F 81 E1 00 00 F0 7F 03 C1 3D 00 00 90 80 0F 87 BB 01 00 00 66 0F 28 EB 8B 44 24 24 25 FF FF FF 7F 8B 4C 24 20 0B C8 66 0F 5C CF 0F 84 9E 01 00 00 3D 00 00 F0 7F 66 0F 59 DF 0F 83 8F 01 00 00 8B 44 24 2C 25 FF FF FF 7F 8B 4C 24 28 0B C8 0F 84 7A 01 00 00 3D 00 00 F0 7F 66 0F 59 E9 0F 83 6B 01 00 00 66 0F 59 CC 66 0F 59 FC 66 0F 58 EB 66 0F 28 1D ?? ?? ?? ?? 66 0F 58 E9 66 0F 28 D7 66 0F 58 3D ?? ?? ?? ?? 66 0F 7E F8 66 0F C5 CF 04 66 0F C5 D7 05 C1 E2 10 66 0F 5C DF 0B CA 3D 80 FF 01 00 0F 8D 25 01 00 00 81 F9 80 FF 01 00 0F 8D 19 01 00 00 3D 00 1E FE FF 0F 8E 0E 01 00 00 81 F9 00 1E FE FF 0F 8E 02 01 00 00 83 E0 7F 83 E1 7F 03 C0 03 C9 66 0F 73 F7 2D 66 0F 28 25 ?? ?? ?? ?? 66 0F FE 3D ?? ?? ?? ?? 66 0F DB 3D ?? ?? ?? ?? 66 0F 58 DA 66 0F 58 E8 66 0F 28 05 ?? ?? ?? ?? F3 41 0F 7E 94 C0 90 62 00 00 66 0F 58 EB F3 41 0F 7E 9C C0 98 62 00 00 66 41 0F 16 94 C8 90 62 00 00 66 41 0F 16 9C C8 98 62 00 00 66 0F 59 C5 66 0F 28 CD 66 0F 59 E5 66 0F 59 ED 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 C5 66 0F 59 E5 66 0F 59 C5 66 0F 59 0D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 E2 66 0F 58 C3 66 0F 59 CA 66 0F 58 C4 66 0F 58 C1 66 0F 58 C2 66 0F 59 C7 E9 A9 00 00 00 66 0F 57 F6 66 0F 28 3D ?? ?? ?? ?? 66 0F C2 74 24 20 01 66 0F C2 7C 24 20 05 66 0F EF ED 66 0F DB F7 66 0F 76 6C 24 30 66 0F 70 FD B1 66 0F DB EE 66 0F DB EF 66 0F D7 D5 89 94 24 88 00 00 00 66 0F 29 6C 24 40 8B 84 24 88 00 00 00 A8 0F 75 1E F2 0F 10 44 24 30 F2 0F 10 4C 24 20 E8 60 00 00 00 F2 0F 11 44 24 50 8B 84 24 88 00 00 00 A9 00 0F 00 00 75 17 F2 0F 10 44 24 38 F2 0F 10 4C 24 28 E8 3B 00 00 00 F2 0F 11 44 24 58 4C 8B 84 24 80 00 00 00 66 0F 28 44 24 50 66 0F 76 C9 66 0F EF 4C 24 40 66 0F 54 C1 0F 28 74 24 60 0F 28 7C 24 70 48 81 C4 98 00 00 00 C3 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_187_2_0 {
	meta:
		name = "pow_scalar"
		size = 3712
		refs = "00e4 s_Data 03f6 INF_c_2044_0_4 048b _2il0floatpacket_15 04f6 _2il0floatpacket_16 0c25 QNaN_c_2044_0_4"
	strings:
		$1 = { 53 56 57 41 54 41 55 41 56 41 57 55 48 81 EC F8 00 00 00 33 D2 F2 0F 11 8C 24 88 00 00 00 8B 9C 24 8C 00 00 00 8B CB 81 E1 FF FF FF 7F 44 0F 29 BC 24 90 00 00 00 81 F9 00 00 F0 7F 44 0F 29 B4 24 D0 00 00 00 44 0F 29 A4 24 E0 00 00 00 44 0F 29 9C 24 A0 00 00 00 44 0F 29 84 24 B0 00 00 00 0F 29 B4 24 C0 00 00 00 F2 0F 11 84 24 40 01 00 00 66 49 0F 7E C1 0F 83 93 01 00 00 8B 84 24 88 00 00 00 0B C8 0F 84 84 01 00 00 49 8B C1 48 C1 E8 20 8B E8 81 E5 FF FF FF 7F 4C 89 4C 24 28 8D 8D 00 00 F0 FF 81 F9 00 00 E0 7F 73 14 8B C8 81 E1 00 00 00 80 81 F9 00 00 00 80 0F 85 47 04 00 00 81 FD 00 00 F0 7F 0F 83 42 01 00 00 8B 4C 24 28 0B E9 0F 84 36 01 00 00 3D 00 00 10 00 73 2B F2 0F 59 05 ?? ?? ?? ?? 48 B8 00 00 00 00 00 00 F0 3F F2 0F 11 44 24 28 BA 34 00 00 00 48 89 44 24 30 8B 44 24 2C E9 0C 04 00 00 F2 0F 11 4C 24 20 8B 7C 24 24 81 E7 FF FF FF 7F 8B CF 8B 74 24 20 0B CE 74 6C 8D 8F 00 00 10 C0 81 F9 00 00 00 40 73 3D 81 FF 00 00 40 43 7D 56 8B CF 81 E1 00 00 F0 7F 81 C1 00 00 10 C0 C1 F9 14 83 F9 14 7F 23 8B EF D3 E5 C1 E5 0C 0B EE 75 14 83 C1 0B D3 E7 F7 D7 81 E7 00 00 00 80 C1 EF 1F FF C7 EB 26 33 FF EB 22 83 C1 0B D3 E6 F7 C6 FF FF FF 7F 75 EF F7 D6 81 E6 00 00 00 80 C1 EE 1F 8D 7E 01 EB 05 BF 02 00 00 00 25 00 00 00 80 3D 00 00 00 80 75 6D 85 FF 74 69 0F 28 C8 83 FF 01 0F 57 C0 F2 0F 5C C1 F2 0F 11 44 24 28 74 11 48 B8 00 00 00 00 00 00 F0 3F 48 89 44 24 30 EB 0F 48 B8 00 00 00 00 00 00 F0 BF 48 89 44 24 30 8B 44 24 2C 8B C8 81 E1 FF FF FF 7F 81 F9 00 00 10 00 0F 83 24 03 00 00 F2 0F 59 05 ?? ?? ?? ?? BA 34 00 00 00 F2 0F 11 44 24 28 8B 44 24 2C E9 08 03 00 00 F2 0F 11 4C 24 20 4C 89 4C 24 30 49 C1 E9 20 45 8B D9 F2 0F 11 4C 24 28 41 81 E3 FF FF FF 7F 44 8B 54 24 2C 41 81 E1 00 00 00 80 44 8B 44 24 24 41 81 E2 FF FF FF 7F 41 81 E0 00 00 00 80 8B 7C 24 30 41 81 FB 00 00 F0 7F 44 89 5C 24 34 44 89 54 24 2C 0F 84 1F 0A 00 00 C7 44 24 20 00 00 00 00 41 BF 01 00 00 00 8B 44 24 28 41 81 FA 00 00 F0 7F 0F 84 F3 09 00 00 33 F6 41 8B D3 81 E2 00 00 F0 7F 81 FA 00 00 F0 7F 0F 84 CC 09 00 00 33 ED 41 8B D2 81 E2 00 00 F0 7F 81 FA 00 00 F0 7F 0F 84 A8 09 00 00 33 DB 41 8B D3 8B CE 0B D7 BA 00 00 00 00 41 0F 44 D7 45 33 E4 0B CB 45 0F 44 E7 41 81 FB 00 00 F0 3F 44 89 64 24 30 0F 84 6E 09 00 00 45 33 FF F2 0F 11 4C 24 28 44 8B 6C 24 2C 41 81 E5 FF FF FF 7F 41 8B CD 44 8B 74 24 28 41 0B CE 74 7F 41 8D 8D 00 00 10 C0 81 F9 00 00 00 40 73 48 41 81 FD 00 00 40 43 7D 67 41 8B CD 81 E1 00 00 F0 7F 81 C1 00 00 10 C0 C1 F9 14 83 F9 14 7F 2D 45 8B E5 41 D3 E4 41 C1 E4 0C 45 0B E6 75 19 83 C1 0B 41 D3 E5 41 F7 D5 41 81 E5 00 00 00 80 41 C1 ED 1F 41 FF C5 EB 2E 45 33 ED EB 29 83 C1 0B 41 D3 E6 41 F7 C6 FF FF FF 7F 75 EC 41 F7 D6 41 81 E6 00 00 00 80 41 C1 EE 1F 45 8D 6E 01 EB 06 41 BD 02 00 00 00 41 81 FB 00 00 F0 3F 7E 04 B1 01 EB 08 0F 84 A7 08 00 00 B1 00 44 0B D0 0F 84 4B 01 00 00 45 85 C9 75 0B 45 85 FF 0F 85 3D 01 00 00 EB 0D 45 85 FF 74 08 85 F6 0F 85 2E 01 00 00 85 ED 0F 85 21 01 00 00 85 DB 0F 85 26 01 00 00 85 D2 74 0D 45 85 C0 74 08 85 F6 0F 85 D9 00 00 00 84 C9 74 22 45 85 C0 75 11 85 F6 74 19 F2 0F 10 0D ?? ?? ?? ?? E9 FB 00 00 00 85 F6 74 08 0F 57 C9 E9 EF 00 00 00 41 81 FB 00 00 F0 3F 7D 22 45 85 C0 75 0C 85 F6 74 19 0F 57 C9 E9 D5 00 00 00 85 F6 74 0D F2 0F 10 0D ?? ?? ?? ?? E9 C4 00 00 00 45 85 C9 75 23 83 7C 24 20 00 74 0D 45 85 C0 74 AB 0F 57 C9 E9 AB 00 00 00 85 D2 74 B0 45 85 C0 74 7B 41 83 FD 01 EB 60 83 7C 24 20 00 74 2C 45 85 C0 75 14 41 83 FD 01 0F 84 BF 07 00 00 F2 0F 10 0D ?? ?? ?? ?? EB 7C 41 83 FD 01 0F 57 C9 75 73 F2 0F 10 0D ?? ?? ?? ?? EB 69 83 7C 24 30 00 74 0F 45 85 ED 75 0A 85 D2 0F 84 77 07 00 00 EB 08 85 D2 0F 84 54 FF FF FF 45 85 C0 74 19 41 83 FD 01 0F 84 70 07 00 00 E8 9D F6 FF FF F2 0F 10 0D ?? ?? ?? ?? EB 2D 41 83 FD 01 74 10 83 7C 24 30 00 0F 84 25 FF FF FF 0F 57 C9 EB 17 F2 0F 10 0D ?? ?? ?? ?? EB 0D 0F 28 C8 EB 08 F2 0F 10 0D ?? ?? ?? ?? F2 0F 11 8C 24 88 00 00 00 E9 C8 06 00 00 48 B9 00 00 00 00 00 00 F0 3F 48 89 4C 24 30 8B F0 48 8D 2D ?? ?? ?? ?? F2 0F 11 44 24 20 81 E6 00 FE 0F 00 8B 4C 24 24 81 C6 00 02 00 00 81 E1 FF FF 0F 00 05 00 02 18 C0 C1 EE 0A 81 C9 00 00 F0 3F 89 4C 24 24 4C 8B CD 48 C1 E1 20 8D 3C 36 44 8B 54 24 20 49 0B CA 48 89 4C 24 28 44 8D 44 36 01 81 E1 00 00 00 F8 F2 0F 10 AC F5 50 02 00 00 89 4C 24 28 0F 28 D5 F2 0F 10 74 24 20 0F 28 DD F2 0F 10 64 24 28 F2 0F 59 D6 F2 0F 5C F4 F2 0F 59 DC F2 0F 59 F5 F2 0F 5C DA C1 F8 14 2B C2 8B D3 F2 44 0F 2A D8 48 8B C5 F2 0F 11 5C 24 38 81 E2 00 00 F0 7F F2 44 0F 10 44 24 38 81 C2 00 00 10 C0 F2 0F 10 0D ?? ?? ?? ?? F2 44 0F 58 C6 F2 44 0F 58 9C F8 60 22 00 00 F2 0F 58 CA F2 44 0F 11 44 24 38 F2 44 0F 11 5C 24 40 F2 44 0F 10 64 24 40 F2 44 0F 58 E1 F2 44 0F 11 64 24 48 8B 44 24 4C 44 8B D8 41 81 E3 00 00 F0 7F 41 81 C3 00 00 10 C0 41 C1 FB 14 C1 FA 14 44 03 DA F2 43 0F 10 84 C1 60 22 00 00 41 83 FB 0B 0F 8F 64 06 00 00 F2 0F 10 74 24 40 F2 0F 10 64 24 48 48 8B 94 24 88 00 00 00 F2 0F 5C F4 F2 0F 11 74 24 50 F2 0F 10 54 24 50 48 89 54 24 28 F2 0F 58 D1 F2 0F 11 54 24 50 81 E2 00 00 00 F8 F2 0F 10 6C 24 48 F2 0F 10 5C 24 38 89 54 24 28 F2 0F 58 EB F2 0F 11 6C 24 58 F2 44 0F 10 5C 24 48 F2 44 0F 10 44 24 58 F2 45 0F 5C D8 F2 44 0F 11 5C 24 60 F2 44 0F 10 74 24 38 F2 44 0F 10 64 24 60 F2 45 0F 58 F4 F2 44 0F 11 74 24 60 F2 0F 10 64 24 50 F2 44 0F 10 7C 24 60 F2 41 0F 58 E7 F2 0F 11 64 24 60 F2 0F 10 74 24 60 F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 C6 F2 0F 11 44 24 60 F2 0F 10 44 24 38 F2 0F 10 74 24 60 F2 0F 58 C8 F2 0F 59 E1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 F4 F2 0F 11 74 24 60 F2 0F 10 64 24 58 F2 0F 10 4C 24 60 F2 0F 58 E1 F2 0F 11 64 24 68 F2 0F 10 44 24 68 F2 0F 10 74 24 58 F2 0F 10 A4 24 88 00 00 00 F2 0F 5C C6 F2 0F 5C 64 24 28 F2 0F 11 44 24 70 F2 0F 10 54 24 60 F2 0F 10 4C 24 70 F2 0F 5C D1 F2 0F 11 54 24 60 48 8B 44 24 68 48 89 44 24 78 81 64 24 78 00 00 00 F8 F2 0F 10 6C 24 68 F2 0F 10 5C 24 78 F2 0F 10 15 ?? ?? ?? ?? F2 0F 5C EB F2 0F 11 AC 24 80 00 00 00 0F 28 EA F2 0F 10 74 24 78 F2 0F 59 74 24 28 F2 44 0F 10 84 24 80 00 00 00 F2 0F 58 EE F2 44 0F 59 C4 F2 44 0F 10 A4 24 80 00 00 00 F2 44 0F 59 64 24 28 F2 44 0F 10 5C 24 78 F2 45 0F 58 E0 F2 41 0F 59 E3 F2 0F 11 6C 24 20 F2 41 0F 58 E4 8B 5C 24 20 8B C3 83 E0 80 83 E3 7F C1 F8 07 F2 0F 10 5C 24 60 3D FF 03 00 00 F2 0F 59 9C 24 88 00 00 00 7C 52 3D 01 04 00 00 7C 34 48 8B 05 ?? ?? ?? ?? 48 89 84 24 88 00 00 00 48 C1 E8 20 8B 54 24 34 81 E2 00 00 00 80 0B C2 89 84 24 8C 00 00 00 F2 0F 10 8C 24 88 00 00 00 E9 46 03 00 00 F2 0F 10 4C 24 30 FF C8 F2 0F 58 C9 F2 0F 11 4C 24 30 E9 6B 02 00 00 3D 3C FC FF FF 0F 8F 5A 02 00 00 3D CC FB FF FF 7F 2A 8B 44 24 34 48 C7 84 24 88 00 00 00 00 00 00 00 25 00 00 00 80 89 84 24 8C 00 00 00 F2 0F 10 8C 24 88 00 00 00 E9 F3 02 00 00 F2 44 0F 10 35 ?? ?? ?? ?? 83 C0 6F C1 E0 14 48 8D 15 ?? ?? ?? ?? 05 00 00 F0 3F 48 8B EA 89 44 24 2C 8D 04 1B F2 44 0F 10 3D ?? ?? ?? ?? 8D 5C 1B 01 48 8B CA F2 0F 5C EA F2 0F 58 E3 F2 0F 5C F5 0F 28 DE F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 DC F2 44 0F 59 F3 F2 0F 10 AC C2 90 62 00 00 F2 0F 10 8C DD 90 62 00 00 C7 44 24 28 00 00 00 00 F2 44 0F 10 5C 24 30 F2 44 0F 59 1D ?? ?? ?? ?? F2 44 0F 58 35 ?? ?? ?? ?? F2 44 0F 59 F3 48 8B 84 C1 90 62 00 00 F2 44 0F 58 F2 45 0F 28 E6 F2 44 0F 59 E3 F2 0F 10 15 ?? ?? ?? ?? F2 45 0F 58 E7 F2 44 0F 59 E5 44 0F 28 C2 F2 44 0F 59 C3 F2 44 0F 59 E3 F2 44 0F 59 C5 F2 44 0F 59 E3 F2 44 0F 58 E1 F2 45 0F 58 E0 F2 44 0F 10 44 24 28 41 0F 28 C0 F2 0F 59 C5 F2 41 0F 59 C3 F2 0F 11 44 24 20 8B 74 24 24 81 E6 FF FF FF 7F 81 FE 00 00 10 00 0F 86 B6 00 00 00 F2 44 0F 59 F3 F2 0F 5C F3 F2 45 0F 59 D8 F2 45 0F 58 FE F2 0F 58 F4 F2 44 0F 59 FB 44 0F 28 E3 F2 41 0F 58 D7 F2 44 0F 59 E2 F2 0F 59 D6 F2 44 0F 11 64 24 20 41 0F 28 DC 81 64 24 20 00 00 00 FF 0F 28 F5 F2 44 0F 10 74 24 20 48 89 44 24 28 F2 41 0F 5C DE F2 44 0F 59 E1 F2 0F 58 D3 C7 44 24 28 00 00 00 00 F2 44 0F 10 7C 24 28 F2 41 0F 5C F7 0F 28 E6 F2 0F 59 E2 F2 41 0F 59 D7 F2 41 0F 59 F6 F2 44 0F 58 E4 F2 45 0F 59 F7 F2 41 0F 58 CC F2 0F 58 CA F2 0F 58 CE F2 41 0F 58 CE F2 0F 58 CD F2 41 0F 59 CB F2 0F 11 8C 24 88 00 00 00 E9 36 01 00 00 48 89 44 24 20 33 C0 F2 44 0F 11 64 24 28 89 44 24 20 81 64 24 24 00 00 FF FF 89 44 24 28 F2 0F 10 4C 24 20 F2 0F 10 44 24 28 F2 0F 5C E9 F2 44 0F 5C E0 F2 44 0F 58 E5 41 0F 28 EB F2 41 0F 59 E8 F2 44 0F 59 C1 F2 44 0F 58 E0 F2 45 0F 59 C3 F2 44 0F 59 E5 41 0F 28 CC F2 41 0F 58 C8 F2 0F 11 8C 24 88 00 00 00 E9 CA 00 00 00 F2 0F 10 4C 24 30 C1 E0 14 48 8D 15 ?? ?? ?? ?? 05 00 00 F0 3F 8D 4C 1B 01 89 44 24 2C 8D 04 1B F2 0F 5C EA F2 0F 58 E3 F2 0F 5C F5 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 E6 F2 0F 10 35 ?? ?? ?? ?? 48 8B DA F2 0F 11 6C 24 20 F2 0F 10 AC C2 90 62 00 00 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 F4 F2 0F 59 D4 F2 0F 59 DC F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 DD F2 0F 59 F4 F2 0F 59 D4 F2 0F 59 F4 F2 0F 59 D4 F2 0F 59 F4 F2 0F 59 D5 F2 0F 59 F4 F2 0F 59 F5 C7 44 24 28 00 00 00 00 F2 0F 58 B4 CB 90 62 00 00 F2 0F 58 F2 F2 0F 58 F3 F2 0F 58 F5 F2 0F 59 CE F2 0F 59 4C 24 28 F2 0F 11 8C 24 88 00 00 00 0F 28 B4 24 C0 00 00 00 0F 28 C1 44 0F 28 84 24 B0 00 00 00 44 0F 28 9C 24 A0 00 00 00 44 0F 28 A4 24 E0 00 00 00 44 0F 28 B4 24 D0 00 00 00 44 0F 28 BC 24 90 00 00 00 48 81 C4 F8 00 00 00 5D 41 5F 41 5E 41 5D 41 5C 5F 5E 5B C3 E8 5F 02 00 00 F2 0F 10 0D ?? ?? ?? ?? E9 CC F8 FF FF E8 2D EF FF FF 0F 57 C9 F2 0F 5C 0D ?? ?? ?? ?? E9 B7 F8 FF FF 85 FF 0F 85 47 F7 FF FF E9 4C F7 FF FF 33 C9 85 FF 44 0F 45 F9 E9 88 F6 FF FF 33 DB 85 F6 41 0F 44 DF E9 4D F6 FF FF 33 ED 83 7C 24 20 00 41 0F 44 EF E9 26 F6 FF FF 33 F6 85 C0 41 0F 44 F7 E9 02 F6 FF FF 41 BF 01 00 00 00 33 C0 85 FF 41 0F 44 C7 89 44 24 20 E9 D8 F5 FF FF 33 D8 F7 C3 00 00 00 80 0F 85 F1 00 00 00 F7 84 24 44 01 00 00 00 00 00 80 75 1C 48 8B 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 48 89 84 24 88 00 00 00 E9 FB FE FF FF 48 8B 84 24 88 00 00 00 8B D8 48 C1 E8 20 25 FF FF FF 7F 8B D0 0B D3 74 CB 8D 90 00 00 10 C0 81 FA 00 00 00 40 73 50 3D 00 00 40 43 7D B6 8B C8 81 E1 00 00 F0 7F 81 C1 00 00 10 C0 C1 F9 14 83 F9 14 7F 4F 8B D0 D3 E2 C1 E2 0C 0B D3 75 28 83 C1 0B D3 E0 A9 00 00 00 80 74 89 48 8B 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 48 89 84 24 88 00 00 00 E9 84 FE FF FF 48 8B 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 48 89 84 24 88 00 00 00 E9 68 FE FF FF 83 C1 0B D3 E3 F7 C3 FF FF FF 7F 75 D7 F7 C3 00 00 00 80 0F 84 38 FF FF FF 48 8B 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 48 89 84 24 88 00 00 00 E9 33 FE FF FF F7 84 24 44 01 00 00 00 00 00 80 75 14 48 C7 84 24 88 00 00 00 00 00 00 00 0F 57 C9 E9 12 FE FF FF 48 8B 84 24 88 00 00 00 8B D8 48 C1 E8 20 25 FF FF FF 7F 8B D0 0B D3 74 D3 8D 90 00 00 10 C0 81 FA 00 00 00 40 0F 83 63 FF FF FF 3D 00 00 40 43 7D BA 8B C8 81 E1 00 00 F0 7F 81 C1 00 00 10 C0 C1 F9 14 83 F9 14 7F 37 8B D0 D3 E2 C1 E2 0C 0B D3 0F 85 37 FF FF FF 83 C1 0B D3 E0 A9 00 00 00 80 74 89 48 8B 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 48 89 84 24 88 00 00 00 E9 93 FD FF FF 83 C1 0B D3 E3 F7 C3 FF FF FF 7F 0F 85 FE FE FF FF F7 C3 00 00 00 80 0F 84 50 FF FF FF 48 8B 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 48 89 84 24 88 00 00 00 E9 5A FD FF FF 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_187_3_0 {
	meta:
		name = "_raise_invalid"
		size = 16
	strings:
		$1 = { B8 FF FF 8F FF 66 0F 6E C0 F3 0F 58 C0 C3 66 90 }
	condition:
		$1
}

rule file_188_1_0 {
	meta:
		name = "clogl"
		size = 591
		refs = "002f creall 0045 cimagl 0053 _ldtest 00b5 atan2 00da __xmm@80000000000000008000000000000000 0129 _fperrraise 0131 _LInf_C 0149 __real@3feccccccccccccd 015b __real@3fd999999999999a 017b _ld_int 01c6 __real@3ff0000000000000 01db log1pl 01e3 __real@3fe0000000000000 01f7 log 0228 _LCbuild"
	strings:
		$1 = { 40 55 53 56 57 48 8B EC 48 83 EC 68 0F 10 02 48 8B F9 0F 29 74 24 50 48 8D 4D B8 0F 29 7C 24 40 48 8B DA F3 0F 7F 45 B8 44 0F 29 44 24 30 E8 ?? ?? ?? ?? 48 8D 4D B8 F2 0F 11 45 30 0F 10 03 F3 0F 7F 45 B8 E8 ?? ?? ?? ?? 48 8D 4D 30 F2 0F 11 45 28 E8 ?? ?? ?? ?? 48 8D 4D 28 0F B7 F0 E8 ?? ?? ?? ?? 0F B7 D8 66 83 FE 02 75 1C F2 0F 10 55 30 48 8D 4D B8 66 83 F8 01 0F 84 A0 01 00 00 F2 0F 11 D1 E9 9F 01 00 00 66 83 FB 02 75 1C F2 0F 10 55 28 48 8D 4D B8 66 83 FE 01 0F 84 7E 01 00 00 F2 0F 11 D1 E9 7D 01 00 00 F2 0F 10 4D 30 F2 0F 10 45 28 E8 ?? ?? ?? ?? 44 0F 28 C0 66 83 FE 01 0F 84 51 01 00 00 66 83 FB 01 0F 84 47 01 00 00 F2 0F 10 4D 30 F2 0F 10 35 ?? ?? ?? ?? 0F 57 D2 66 0F 2F D1 76 08 0F 57 CE F2 0F 11 4D 30 F2 0F 10 7D 28 66 0F 2F D7 76 08 0F 57 FE F2 0F 11 7D 28 66 0F 2F F9 76 13 0F 28 C1 F2 0F 11 7D 30 0F 28 CF F2 0F 11 45 28 0F 28 F8 66 0F 2E CA 7A 24 75 22 B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 0F 57 CE 41 0F 28 D0 48 8D 4D B8 E9 E2 00 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C1 0F 82 98 00 00 00 66 0F 2F 3D ?? ?? ?? ?? 0F 82 8A 00 00 00 BB 1A 00 00 00 48 8D 4D 40 F2 0F 11 4D 40 8B D3 F2 0F 11 7D 38 E8 ?? ?? ?? ?? 48 8D 4D 38 8B D3 E8 ?? ?? ?? ?? F2 0F 10 65 38 F2 0F 10 5D 40 F2 0F 10 6D 28 F2 0F 10 55 30 0F 28 C4 F2 0F 5C EC F2 0F 59 E4 F2 0F 58 45 28 F2 0F 5C D3 F2 0F 59 E8 0F 28 C3 F2 0F 59 DB F2 0F 58 45 30 F2 0F 5C 1D ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 C5 F2 0F 58 DC F2 0F 58 C3 E8 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? 0F 28 C8 E9 49 FF FF FF 0F 28 C1 F2 0F 5E F9 E8 ?? ?? ?? ?? 0F 28 F0 F2 0F 59 FF 0F 28 C7 E8 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? F2 0F 58 C6 EB CF 0F 28 D0 48 8D 4D B8 F2 0F 10 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 28 74 24 50 0F 28 7C 24 40 0F 10 00 44 0F 28 44 24 30 48 8B C7 F3 0F 7F 07 48 83 C4 68 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "lrintf"
		size = 120
		refs = "0015 _fdtest 002c nearbyintf 0042 _fperrraise 0049 __real@cf000000 0053 __real@4f000000"
	strings:
		$1 = { F3 0F 11 44 24 08 48 83 EC 38 48 8D 4C 24 40 0F 29 74 24 20 E8 ?? ?? ?? ?? 98 85 C0 74 4E FF C8 83 F8 01 76 3D F3 0F 10 44 24 40 E8 ?? ?? ?? ?? 0F 28 F0 0F 2E 74 24 40 7A 02 74 0A B9 20 00 00 00 E8 ?? ?? ?? ?? 0F 2F 35 ?? ?? ?? ?? 72 13 F3 0F 10 05 ?? ?? ?? ?? 0F 2F C6 72 06 F3 0F 2C C6 EB 0C B9 01 00 00 00 E8 ?? ?? ?? ?? 33 C0 0F 28 74 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "__common_satan2_cout_rare"
		size = 4656
		refs = "010c _vmldAtanHATab"
	strings:
		$1 = { 56 41 55 48 81 EC B8 00 00 00 F3 0F 10 19 F3 0F 10 12 F3 0F 5A C3 F3 0F 5A CA F2 0F 11 44 24 38 F2 0F 11 4C 24 40 0F B7 41 02 25 80 7F 00 00 44 8A 52 03 44 0F B7 4C 24 3E 41 80 E2 80 0F B7 74 24 46 41 81 E1 F0 7F 00 00 81 E6 F0 7F 00 00 C1 E8 07 44 8A 59 03 41 C0 EB 07 41 C0 EA 07 44 0F 29 BC 24 90 00 00 00 44 0F 29 B4 24 A0 00 00 00 44 0F 29 6C 24 70 44 0F 29 A4 24 80 00 00 00 41 C1 E9 04 C1 EE 04 3D FF 00 00 00 0F 84 65 10 00 00 44 0F B7 6A 02 41 81 E5 80 7F 00 00 41 81 FD 80 7F 00 00 0F 84 4C 10 00 00 45 85 C9 75 0C F7 01 FF FF 7F 00 0F 84 8F 0F 00 00 85 F6 75 0C F7 02 FF FF 7F 00 0F 84 3E 0F 00 00 F7 DE F2 0F 11 44 24 38 41 03 F1 F2 0F 11 4C 24 40 8A 54 24 3F 8A 44 24 47 80 E2 7F 24 7F 83 FE CA 0F 8E 42 0E 00 00 83 FE 36 0F 8D EB 0D 00 00 88 44 24 47 45 84 D2 88 54 24 3F 75 0D F2 0F 10 0D ?? ?? ?? ?? 0F 28 D1 EB 10 F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 64 24 38 45 85 C9 F2 0F 10 44 24 40 0F 28 EC F2 0F 5E E8 48 8B 44 24 38 F2 0F 11 6C 24 58 0F 8E 8D 0F 00 00 41 81 F9 FE 07 00 00 7D 21 48 89 44 24 38 41 81 C1 01 FC FF FF 48 C1 E8 30 25 0F 80 FF FF 0D F0 3F FF FF 66 89 44 24 3E EB 18 F2 0F 10 1D ?? ?? ?? ?? 41 B9 FE 03 00 00 F2 0F 59 E3 F2 0F 11 64 24 38 41 F7 D9 48 8B 05 ?? ?? ?? ?? 41 81 C1 FF 03 00 00 48 89 44 24 40 41 81 E1 FF 07 00 00 48 C1 E8 30 41 C1 E1 04 25 0F 80 FF FF 41 0B C1 66 89 44 24 46 F2 0F 10 5C 24 40 F2 0F 59 C3 66 0F 2F 2D ?? ?? ?? ?? 0F 82 40 08 00 00 F2 44 0F 10 2D ?? ?? ?? ?? 0F 28 D8 F2 41 0F 59 DD 44 0F 28 F0 F2 0F 11 5C 24 20 F2 44 0F 10 7C 24 20 F2 0F 11 6C 24 40 F2 44 0F 5C F8 F2 44 0F 11 7C 24 28 F2 0F 10 6C 24 20 F2 0F 10 64 24 28 8B 4C 24 44 8B F1 81 E1 00 00 08 00 81 E6 00 00 F0 FF 81 C9 00 00 04 00 F2 0F 5C EC F2 0F 11 6C 24 20 0B F1 F2 0F 10 5C 24 20 C7 44 24 40 00 00 00 00 F2 44 0F 5C F3 89 74 24 44 F2 44 0F 11 74 24 28 F2 0F 10 6C 24 20 F2 0F 10 64 24 40 F2 44 0F 10 74 24 28 F2 0F 59 EC F2 44 0F 59 F4 F2 44 0F 10 25 ?? ?? ?? ?? F2 41 0F 59 EC F2 45 0F 59 F4 44 0F 28 FD 0F B7 54 24 5E F2 45 0F 58 FE F2 44 0F 11 7C 24 20 81 E2 F0 7F 00 00 F2 0F 10 5C 24 20 C1 EA 04 F2 0F 5C EB F2 0F 10 5C 24 38 F2 41 0F 58 EE F2 0F 11 6C 24 28 44 0F 28 FB F2 44 0F 10 64 24 20 F2 44 0F 10 74 24 28 F2 45 0F 58 FC F2 44 0F 11 7C 24 20 44 0F 28 FB F2 0F 10 6C 24 20 8B 44 24 5C F2 44 0F 5C FD F2 44 0F 11 7C 24 28 25 FF FF 0F 00 F2 44 0F 10 7C 24 20 F2 0F 10 6C 24 28 C1 E2 14 F2 44 0F 58 FD F2 44 0F 11 7C 24 30 44 0F 28 FB F2 0F 10 6C 24 28 0B D0 81 C2 00 00 40 C0 B8 71 00 00 00 C1 FA 13 F2 44 0F 58 E5 F2 44 0F 11 64 24 28 83 FA 71 F2 44 0F 10 64 24 30 0F 4C C2 48 8D 15 ?? ?? ?? ?? 03 C0 48 8B CA 48 63 C0 F2 45 0F 5C FC F2 44 0F 11 7C 24 30 F2 0F 10 6C 24 28 F2 44 0F 10 64 24 30 F2 41 0F 58 EC F2 0F 11 6C 24 30 F2 0F 10 6C 24 20 F2 44 0F 10 64 24 30 F2 45 0F 58 E6 44 0F 28 F5 F2 45 0F 59 F5 F2 44 0F 11 74 24 20 F2 44 0F 10 7C 24 20 F2 44 0F 5C FD F2 44 0F 11 7C 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 10 74 24 28 F2 45 0F 5C FE F2 44 0F 11 7C 24 20 44 0F 28 FB F2 44 0F 10 74 24 20 F2 44 0F 59 3D ?? ?? ?? ?? F2 41 0F 5C EE F2 0F 11 6C 24 28 F2 0F 10 6C 24 20 F2 44 0F 10 74 24 28 F2 44 0F 11 7C 24 20 F2 45 0F 58 E6 F2 44 0F 10 74 24 20 F2 44 0F 5C 74 24 38 F2 44 0F 11 74 24 28 F2 44 0F 10 74 24 20 F2 44 0F 10 7C 24 28 F2 45 0F 5C F7 F2 44 0F 11 74 24 20 F2 44 0F 10 7C 24 20 F2 41 0F 5C DF F2 0F 11 5C 24 28 F2 0F 10 5C 24 20 F2 44 0F 10 74 24 28 F2 0F 59 DC F2 44 0F 59 F4 0F 28 E3 F2 41 0F 58 E6 F2 0F 11 64 24 20 F2 44 0F 10 7C 24 20 F2 41 0F 5C DF F2 41 0F 58 DE F2 0F 11 5C 24 28 0F 28 D8 F2 44 0F 10 74 24 20 F2 44 0F 10 7C 24 28 F2 41 0F 58 DE F2 0F 11 5C 24 20 0F 28 D8 F2 0F 10 64 24 20 F2 0F 5C DC F2 0F 11 5C 24 28 F2 0F 10 5C 24 20 F2 0F 10 64 24 28 F2 0F 58 DC F2 0F 11 5C 24 30 F2 0F 10 64 24 28 F2 44 0F 58 F4 F2 44 0F 11 74 24 28 F2 44 0F 10 74 24 30 F2 41 0F 5C C6 F2 0F 11 44 24 30 F2 0F 10 5C 24 28 F2 0F 10 44 24 30 F2 0F 58 D8 F2 0F 11 5C 24 30 F2 0F 10 5C 24 20 F2 0F 10 44 24 30 F2 41 0F 58 C7 44 0F 28 FB F2 45 0F 59 FD F2 44 0F 11 7C 24 20 F2 0F 10 64 24 20 F2 0F 5C E3 F2 0F 11 64 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 10 74 24 28 F2 45 0F 5C FE F2 44 0F 11 7C 24 20 F2 44 0F 10 74 24 20 F2 41 0F 5C DE F2 44 0F 10 35 ?? ?? ?? ?? F2 0F 11 5C 24 28 F2 44 0F 10 7C 24 20 F2 0F 10 5C 24 28 F2 0F 58 C3 41 0F 28 DE F2 41 0F 5E DF 0F 28 E3 F2 41 0F 59 E5 F2 0F 11 64 24 28 F2 0F 10 64 24 28 F2 0F 5C E3 F2 0F 11 64 24 30 F2 0F 10 64 24 28 F2 0F 10 5C 24 30 F2 0F 5C E3 F2 0F 11 64 24 30 F2 0F 10 5C 24 30 F2 44 0F 59 FB F2 45 0F 5C F7 F2 44 0F 10 7C 24 30 F2 41 0F 59 C7 F2 0F 11 44 24 28 F2 0F 10 44 24 28 F2 44 0F 5C F0 F2 44 0F 11 74 24 28 F2 0F 10 64 24 28 4C 8B 4C 24 30 F2 0F 10 5C 24 28 F2 44 0F 10 74 24 30 4C 89 4C 24 48 F2 44 0F 10 7C 24 48 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E3 41 0F 28 DF F2 0F 59 DD F2 41 0F 59 E6 44 0F 28 F4 F2 45 0F 59 F4 F2 0F 59 EC F2 45 0F 59 E7 F2 44 0F 58 F5 F2 44 0F 10 3D ?? ?? ?? ?? F2 45 0F 58 F4 F2 44 0F 11 74 24 20 44 0F 28 E3 F2 44 0F 10 74 24 20 F2 45 0F 58 E6 F2 44 0F 11 64 24 20 F2 0F 10 6C 24 20 F2 0F 5C DD F2 41 0F 58 DE F2 0F 11 5C 24 28 F2 0F 10 6C 24 20 0F 28 C5 0F 28 E5 F2 0F 59 C5 F2 41 0F 59 E5 F2 44 0F 59 F8 F2 0F 10 5C 24 28 F2 0F 11 64 24 20 F2 44 0F 10 74 24 20 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 5C F5 F2 44 0F 59 F8 F2 44 0F 11 74 24 28 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 41 0F 59 C7 F2 44 0F 10 7C 24 20 F2 44 0F 10 64 24 28 F2 44 0F 59 E8 F2 45 0F 5C FC F2 44 0F 11 7C 24 20 F2 44 0F 10 74 24 20 F2 41 0F 5C EE F2 0F 11 6C 24 28 F2 44 0F 10 64 24 20 F2 0F 10 6C 24 28 F2 44 0F 11 6C 24 20 F2 0F 58 DD F2 44 0F 10 6C 24 20 F2 44 0F 5C E8 F2 44 0F 11 6C 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 10 74 24 28 F2 45 0F 5C FE F2 44 0F 11 7C 24 20 F2 0F 10 64 24 20 F2 0F 5C C4 F2 0F 11 44 24 28 F2 0F 10 44 24 20 F2 0F 10 6C 24 28 44 0F 28 F0 44 0F 28 FD F2 44 0F 59 FB F2 0F 59 C3 F2 41 0F 59 EC F2 45 0F 59 F4 F2 44 0F 58 F8 41 0F 28 C6 41 0F 28 E6 F2 44 0F 58 FD F2 41 0F 58 C4 F2 44 0F 11 7C 24 20 F2 44 0F 10 7C 24 20 F2 0F 11 44 24 20 F2 44 0F 10 6C 24 20 F2 41 0F 5C E5 F2 0F 11 64 24 28 F2 0F 10 6C 24 20 F2 0F 10 44 24 28 F2 0F 58 E8 F2 0F 11 6C 24 30 F2 44 0F 10 6C 24 28 F2 45 0F 58 E5 F2 44 0F 11 64 24 28 F2 44 0F 10 64 24 30 F2 45 0F 5C F4 F2 44 0F 11 74 24 30 F2 0F 10 44 24 28 F2 44 0F 10 74 24 30 F2 41 0F 58 C6 F2 0F 11 44 24 30 4C 8B 6C 24 20 4C 89 6C 24 48 F2 44 0F 10 74 24 48 41 0F 28 EE 45 0F 28 EE F2 0F 10 64 24 30 F2 0F 58 2C C2 F2 0F 58 DC F2 0F 11 6C 24 20 F2 41 0F 58 DF F2 44 0F 10 64 24 20 F2 0F 11 5C 24 50 F2 45 0F 5C EC F2 44 0F 11 6C 24 28 F2 0F 10 44 24 20 F2 44 0F 10 7C 24 28 F2 41 0F 58 C7 F2 0F 11 44 24 30 F2 0F 10 64 24 28 F2 0F 58 24 C1 F2 0F 11 64 24 28 F2 0F 10 6C 24 30 F2 44 0F 5C F5 F2 44 0F 11 74 24 30 F2 44 0F 10 6C 24 28 F2 44 0F 10 64 24 30 F2 45 0F 58 EC F2 44 0F 11 6C 24 30 48 8B 4C 24 20 F2 0F 10 44 24 30 48 89 4C 24 48 48 8D 15 ?? ?? ?? ?? F2 0F 58 D8 41 C0 E3 07 0F 28 C1 F2 0F 58 5C C2 08 41 8A C2 C0 E0 07 F2 0F 11 5C 24 50 48 C1 E9 38 40 8A 74 24 57 44 8A CE 40 C0 EE 07 41 80 E1 7F 80 E1 7F 44 32 D6 0A C8 88 4C 24 4F F2 44 0F 10 74 24 48 41 0F 28 E6 F2 41 0F 58 C6 41 C0 E2 07 F2 0F 11 44 24 20 F2 0F 10 5C 24 20 F2 0F 5C E3 F2 0F 11 64 24 28 45 0A CA F2 44 0F 10 64 24 20 F2 0F 10 6C 24 28 44 88 4C 24 57 F2 44 0F 58 E5 F2 44 0F 11 64 24 30 F2 44 0F 10 6C 24 28 F2 41 0F 58 CD F2 0F 11 4C 24 28 F2 0F 10 4C 24 30 F2 44 0F 5C F1 F2 44 0F 11 74 24 30 F2 0F 10 44 24 28 F2 44 0F 10 7C 24 30 F2 41 0F 58 C7 F2 0F 11 44 24 30 4C 8B 54 24 20 F2 0F 10 4C 24 30 4C 89 54 24 48 F2 0F 58 4C 24 50 F2 0F 58 CA F2 0F 10 54 24 48 F2 0F 11 4C 24 50 F2 0F 58 D1 F2 0F 11 54 24 68 44 8A 6C 24 6F 41 80 E5 7F 45 0A EB 44 88 6C 24 6F F2 0F 5A 44 24 68 F3 41 0F 11 00 E9 93 06 00 00 F2 44 0F 10 6C 24 38 41 8A CA 41 0F 28 ED F2 0F 59 2D ?? ?? ?? ?? C0 E1 07 41 C0 E3 07 F2 0F 11 6C 24 20 F2 0F 10 64 24 20 F2 0F 10 2D ?? ?? ?? ?? F2 0F 5C 64 24 38 F2 0F 11 64 24 28 F2 0F 10 5C 24 20 F2 44 0F 10 7C 24 28 F2 41 0F 5C DF F2 0F 11 5C 24 20 F2 44 0F 10 64 24 20 F2 45 0F 5C EC 44 0F 28 E0 F2 44 0F 59 E5 F2 44 0F 11 6C 24 28 F2 0F 10 5C 24 20 F2 0F 10 64 24 28 F2 44 0F 11 64 24 20 F2 44 0F 10 7C 24 20 F2 44 0F 5C F8 F2 44 0F 11 7C 24 28 F2 44 0F 10 64 24 20 F2 44 0F 10 74 24 28 F2 45 0F 5C E6 F2 44 0F 11 64 24 20 F2 44 0F 10 6C 24 20 F2 41 0F 5C C5 F2 0F 11 44 24 28 F2 0F 10 05 ?? ?? ?? ?? F2 44 0F 10 74 24 20 44 0F 28 E8 F2 45 0F 5E EE 45 0F 28 FD F2 44 0F 59 FD F2 44 0F 10 64 24 28 F2 44 0F 11 7C 24 28 F2 44 0F 10 7C 24 28 F2 45 0F 5C FD F2 44 0F 11 7C 24 30 F2 44 0F 10 7C 24 28 F2 44 0F 10 6C 24 30 F2 45 0F 5C FD F2 44 0F 11 7C 24 30 F2 44 0F 10 6C 24 30 F2 45 0F 59 F5 F2 41 0F 5C C6 F2 44 0F 10 74 24 30 F2 45 0F 59 E6 F2 44 0F 11 64 24 28 F2 44 0F 10 64 24 28 F2 41 0F 5C C4 F2 0F 11 44 24 28 F2 44 0F 10 64 24 28 48 8B 44 24 30 F2 0F 10 44 24 28 48 89 44 24 48 F2 44 0F 10 6C 24 48 F2 44 0F 58 25 ?? ?? ?? ?? F2 44 0F 59 E0 F2 0F 10 44 24 30 F2 44 0F 59 E0 41 0F 28 C5 F2 0F 59 C3 F2 44 0F 59 EC F2 41 0F 59 DC 45 0F 28 FC F2 44 0F 59 FC F2 44 0F 58 FB 0F 28 D8 F2 45 0F 58 FD F2 44 0F 11 7C 24 20 F2 44 0F 10 64 24 20 F2 44 0F 10 3D ?? ?? ?? ?? F2 41 0F 58 DC F2 0F 11 5C 24 20 F2 0F 10 64 24 20 F2 0F 5C C4 F2 41 0F 58 C4 F2 0F 11 44 24 28 F2 0F 10 44 24 58 F2 0F 59 C0 F2 44 0F 59 F8 F2 44 0F 10 74 24 20 45 0F 28 EE F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 ED F2 44 0F 59 F8 F2 0F 10 5C 24 28 F2 44 0F 11 6C 24 20 F2 0F 10 64 24 20 F2 44 0F 58 3D ?? ?? ?? ?? F2 41 0F 5C E6 F2 44 0F 59 F8 F2 0F 11 64 24 28 F2 44 0F 10 64 24 20 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 0F 10 44 24 28 F2 41 0F 59 EF F2 44 0F 5C E0 F2 44 0F 11 64 24 20 F2 44 0F 10 6C 24 20 F2 45 0F 5C F5 F2 44 0F 11 74 24 28 F2 44 0F 10 6C 24 20 F2 44 0F 10 74 24 28 F2 0F 11 6C 24 20 F2 41 0F 58 DE F2 0F 10 6C 24 20 F2 41 0F 5C EF F2 0F 11 6C 24 28 F2 44 0F 10 64 24 20 F2 0F 10 44 24 28 F2 44 0F 5C E0 F2 44 0F 11 64 24 20 F2 0F 10 64 24 20 F2 44 0F 5C FC F2 44 0F 11 7C 24 28 F2 44 0F 10 74 24 20 F2 44 0F 10 7C 24 28 45 0F 28 E6 41 0F 28 C7 F2 0F 59 C3 F2 44 0F 59 F3 F2 45 0F 59 FD F2 45 0F 59 E5 F2 41 0F 58 C6 41 0F 28 E4 45 0F 28 F4 F2 41 0F 58 C7 F2 41 0F 58 E5 F2 0F 11 44 24 20 F2 0F 10 44 24 20 F2 0F 11 64 24 20 F2 0F 10 6C 24 20 F2 44 0F 5C F5 F2 44 0F 11 74 24 28 F2 0F 10 6C 24 20 F2 0F 10 64 24 28 F2 0F 58 EC F2 0F 11 6C 24 30 F2 44 0F 10 7C 24 28 F2 45 0F 58 EF F2 44 0F 11 6C 24 28 F2 44 0F 10 6C 24 30 F2 45 0F 5C E5 F2 44 0F 11 64 24 30 F2 0F 10 6C 24 28 F2 0F 10 64 24 30 F2 0F 58 EC F2 0F 11 6C 24 30 48 8B 54 24 20 F2 44 0F 10 64 24 30 48 89 54 24 48 F2 41 0F 58 DC 48 C1 EA 38 F2 0F 58 D8 80 E2 7F 0A D1 88 54 24 4F F2 0F 11 5C 24 50 0F 28 D9 F2 44 0F 10 6C 24 48 41 0F 28 C5 F2 41 0F 58 DD F2 0F 11 5C 24 20 F2 0F 10 5C 24 20 40 8A 74 24 57 44 8A CE 40 C0 EE 07 F2 0F 5C C3 F2 0F 11 44 24 28 F2 0F 10 6C 24 20 F2 0F 10 64 24 28 44 32 D6 41 80 E1 7F 41 C0 E2 07 F2 0F 58 EC F2 0F 11 6C 24 30 F2 44 0F 10 64 24 28 F2 41 0F 58 CC F2 0F 11 4C 24 28 45 0A CA F2 0F 10 4C 24 30 44 88 4C 24 57 F2 44 0F 5C E9 F2 44 0F 11 6C 24 30 F2 0F 10 5C 24 28 F2 0F 10 44 24 30 F2 0F 58 D8 F2 0F 11 5C 24 30 4C 8B 54 24 20 F2 0F 10 64 24 30 4C 89 54 24 48 F2 0F 58 64 24 50 F2 0F 58 E2 F2 0F 10 54 24 48 F2 0F 11 64 24 50 F2 0F 58 D4 F2 0F 11 54 24 68 44 8A 6C 24 6F 41 80 E5 7F 45 0A EB 44 88 6C 24 6F F2 0F 5A 44 24 68 F3 41 0F 11 00 E9 C5 01 00 00 83 FE 4A 0F 8D 27 01 00 00 88 54 24 3F F2 0F 5E 4C 24 38 F2 0F 10 05 ?? ?? ?? ?? 41 C0 E3 07 F2 0F 5C C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 68 8A 44 24 6F 24 7F 41 0A C3 88 44 24 6F F2 0F 5A 4C 24 68 F3 41 0F 11 08 E9 77 01 00 00 45 84 D2 0F 85 3C 01 00 00 88 54 24 3F 88 44 24 47 F2 0F 10 54 24 38 F2 0F 5E 54 24 40 F2 0F 5A C2 F3 0F 11 44 24 60 0F B7 44 24 62 A9 80 7F 00 00 F2 0F 11 54 24 68 74 43 F2 0F 10 05 ?? ?? ?? ?? 41 C0 E3 07 F2 0F 58 C2 F2 0F 11 44 24 20 F2 0F 10 4C 24 20 F2 0F 59 D1 F2 0F 11 54 24 68 8A 44 24 6F 24 7F 41 0A C3 88 44 24 6F F2 0F 5A 54 24 68 F3 41 0F 11 10 E9 FB 00 00 00 F2 0F 5A 44 24 68 41 C0 E3 07 F3 0F 11 44 24 60 F3 0F 10 54 24 60 F3 0F 10 4C 24 60 F3 0F 59 D1 F3 0F 11 54 24 60 F3 0F 10 5C 24 60 F3 0F 5A DB F2 0F 58 5C 24 68 F2 0F 11 5C 24 68 8A 44 24 6F 24 7F 41 0A C3 88 44 24 6F F2 0F 5A 64 24 68 F3 }
	condition:
		$1
}

rule file_192_0_0 {
	meta:
		name = "__crtwsetenv"
		size = 986
		refs = "0030 _errno 003b _invalid_parameter_noinfo 0059 wcschr 007a _wenviron 0088 __winitenv 00bd _calloc_crt 00d0 _amsg_exit 00e3 _wcsdup 0114 _environ 0122 __crtGetEnvironmentStringsW 0129 _wenvptr 012e _wsetenvp 0137 __mbtow_environ 017c _malloc_crt 01e3 _wcsnicoll 023c free 028f _recalloc_crt 0332 wcslen 0361 wcscpy_s 0380 __imp_SetEnvironmentVariableW 03d5 _invoke_watson"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 18 48 89 70 20 89 50 10 57 41 54 41 55 41 56 41 57 48 83 EC 30 45 33 F6 8B DA 4C 8B F9 41 8B FE 48 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 06 01 00 00 48 8B 29 48 85 ED 0F 84 EF 00 00 00 BA 3D 00 00 00 48 8B CD E8 ?? ?? ?? ?? 4C 8B E0 48 85 C0 0F 84 D6 00 00 00 48 3B E8 0F 84 CD 00 00 00 66 44 39 70 02 48 8B 35 ?? ?? ?? ?? 45 8B EE 41 0F 94 C5 48 3B 35 ?? ?? ?? ?? 75 7A 48 8B DE 41 8B CE 48 8B C6 48 85 F6 75 05 49 8B F6 EB 5C 4C 39 36 74 0B 48 8D 40 08 FF C1 4C 39 30 75 F5 8D 41 01 BA 08 00 00 00 48 63 C8 E8 ?? ?? ?? ?? 4C 8B F0 48 8B F0 48 85 C0 75 08 8D 48 09 E8 ?? ?? ?? ?? 48 8B 03 48 85 C0 74 1B 49 2B DE 48 8B C8 E8 ?? ?? ?? ?? 49 89 06 49 83 C6 08 4A 8B 04 33 48 85 C0 75 E8 49 21 3E 45 33 F6 8B 5C 24 68 48 89 35 ?? ?? ?? ?? 48 85 F6 0F 85 AA 00 00 00 48 8B 05 ?? ?? ?? ?? 85 DB 74 4E 48 85 C0 74 49 E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 7E E8 ?? ?? ?? ?? 85 C0 74 75 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 48 8B 5C 24 60 48 8B 6C 24 70 48 8B 74 24 78 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F C3 45 85 ED 74 04 33 C0 EB DA 48 85 C0 75 23 8D 48 08 E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 85 C0 74 BE 4C 89 30 48 8B 35 ?? ?? ?? ?? 48 85 F6 75 20 B9 08 00 00 00 E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 85 C0 74 99 4C 89 30 48 8B 35 ?? ?? ?? ?? 33 C9 4C 8B F6 48 85 F6 74 85 48 8B 06 4C 2B E5 48 8B DE 49 D1 FC 48 85 C0 74 44 49 63 F4 4C 8B C6 48 8B D0 48 8B CD E8 ?? ?? ?? ?? 33 C9 85 C0 75 1A 48 8B 03 8D 51 3D 66 39 14 70 0F 84 AB 00 00 00 66 39 0C 70 0F 84 A1 00 00 00 48 83 C3 08 48 8B 03 48 85 C0 75 C6 48 8B 35 ?? ?? ?? ?? 48 2B DE 48 C1 FB 03 F7 DB 85 DB 0F 88 9C 00 00 00 49 39 0E 0F 84 93 00 00 00 48 63 F3 49 8B 0C F6 E8 ?? ?? ?? ?? 33 D2 45 85 ED 74 74 49 39 14 F6 74 1E 48 8D 4E 01 49 8D 0C CE 48 8B 01 FF C3 48 8D 49 08 49 89 04 F6 48 FF C6 49 39 14 F6 75 EA 48 63 D3 48 B8 FF FF FF FF FF FF FF 1F 48 3B D0 0F 83 A3 00 00 00 48 8B 0D ?? ?? ?? ?? 41 B8 08 00 00 00 E8 ?? ?? ?? ?? 45 33 F6 48 85 C0 0F 84 88 00 00 00 48 89 05 ?? ?? ?? ?? EB 7F 48 8B 35 ?? ?? ?? ?? 48 2B DE 48 C1 FB 03 E9 68 FF FF FF 49 89 2C F6 45 33 F6 4D 89 37 EB 60 45 33 F6 45 85 ED 0F 85 E2 00 00 00 85 DB 79 02 F7 DB 8D 43 02 3B C3 0F 8C 66 FE FF FF 4C 63 C0 48 B8 FF FF FF FF FF FF FF 1F 4C 3B C0 0F 83 50 FE FF FF BA 08 00 00 00 48 8B CE E8 ?? ?? ?? ?? 48 85 C0 0F 84 3A FE FF FF 48 63 CB 48 89 2C C8 4C 89 74 C8 08 4D 89 37 E9 7B FF FF FF 45 33 F6 44 39 74 24 68 74 70 48 8B CD E8 ?? ?? ?? ?? BE 02 00 00 00 48 8D 0C 06 8B D6 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 50 48 8B CD E8 ?? ?? ?? ?? 4C 8B C5 48 8B CB 48 8D 14 06 E8 ?? ?? ?? ?? 85 C0 75 5C 4A 8D 14 63 48 8B CB 66 44 89 32 48 03 D6 45 85 ED 49 0F 45 D6 FF 15 ?? ?? ?? ?? 85 C0 75 0E 83 CF FF E8 ?? ?? ?? ?? C7 00 2A 00 00 00 48 8B CB E8 ?? ?? ?? ?? 45 85 ED 74 0B 48 8B CD E8 ?? ?? ?? ?? 4D 89 37 8B C7 E9 98 FD FF FF 48 8B CD E8 ?? ?? ?? ?? 4D 89 37 E9 AA FD FF FF 45 33 C9 45 33 C0 33 D2 33 C9 4C 89 74 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_192_2_0 {
	meta:
		name = "copy_environ"
		size = 135
		refs = "0039 _calloc_crt 004c _amsg_exit 005c _wcsdup"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B D9 33 C9 48 8B C3 48 85 DB 74 5B 48 39 0B 74 0C 48 8D 40 08 FF C1 48 83 38 00 75 F4 8D 41 01 BA 08 00 00 00 48 63 C8 E8 ?? ?? ?? ?? 48 8B F8 48 8B F0 48 85 C0 75 08 8D 48 09 E8 ?? ?? ?? ?? 48 8B 0B 48 85 C9 74 18 48 2B DF E8 ?? ?? ?? ?? 48 89 07 48 83 C7 08 48 8B 0C 3B 48 85 C9 75 EB 48 83 27 00 48 8B C6 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_553_2_0 {
	meta:
		name = "copy_environ"
		size = 135
		refs = "0039 _calloc_crt 004c _amsg_exit 005c _strdup"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B D9 33 C9 48 8B C3 48 85 DB 74 5B 48 39 0B 74 0C 48 8D 40 08 FF C1 48 83 38 00 75 F4 8D 41 01 BA 08 00 00 00 48 63 C8 E8 ?? ?? ?? ?? 48 8B F8 48 8B F0 48 85 C0 75 08 8D 48 09 E8 ?? ?? ?? ?? 48 8B 0B 48 85 C9 74 18 48 2B DF E8 ?? ?? ?? ?? 48 89 07 48 83 C7 08 48 8B 0C 3B 48 85 C9 75 EB 48 83 27 00 48 8B C6 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_192_3_0 {
	meta:
		name = "wfindenv"
		size = 144
		refs = "0017 _wenviron 0038 _wcsnicoll"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B 05 ?? ?? ?? ?? 4C 63 C2 33 ED 48 8B 10 48 8B F1 48 8B D8 48 85 D2 74 35 49 8B F8 4C 8B C7 48 8B CE E8 ?? ?? ?? ?? 85 C0 75 10 48 8B 03 66 83 3C 78 3D 74 39 66 39 2C 78 74 33 48 83 C3 08 48 8B 13 48 85 D2 75 D5 48 8B 05 ?? ?? ?? ?? 48 2B D8 48 C1 FB 03 F7 DB 48 8B 6C 24 38 48 8B 74 24 40 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 48 2B 1D ?? ?? ?? ?? 48 C1 FB 03 EB DC }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "scalbln"
		size = 94
		refs = "001c _dtest 002d _dscale 0049 _fperrraise"
		altNames = "scalbn"
	strings:
		$1 = { 48 89 5C 24 10 F2 0F 11 44 24 08 57 48 83 EC 20 8B DA 85 D2 74 37 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 85 C0 79 28 48 8D 4C 24 30 8B D3 E8 ?? ?? ?? ?? 0F BF C8 85 C9 74 0B FF C9 75 11 B9 08 00 00 00 EB 05 B9 10 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 44 24 30 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_643_0_0 {
	meta:
		name = "scalblnl"
		size = 94
		refs = "001c _ldtest 002d _ldscale 0049 _fperrraise"
	strings:
		$1 = { 48 89 5C 24 10 F2 0F 11 44 24 08 57 48 83 EC 20 8B DA 85 D2 74 37 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 85 C0 79 28 48 8D 4C 24 30 8B D3 E8 ?? ?? ?? ?? 0F BF C8 85 C9 74 0B FF C9 75 11 B9 08 00 00 00 EB 05 B9 10 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 44 24 30 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_736_0_0 {
	meta:
		name = "scalbnl"
		size = 94
		refs = "001c _ldtest 002d _ldscale 0049 _fperrraise"
	strings:
		$1 = { 48 89 5C 24 10 F2 0F 11 44 24 08 57 48 83 EC 20 8B DA 85 D2 74 37 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 85 C0 79 28 48 8D 4C 24 30 8B D3 E8 ?? ?? ?? ?? 0F BF C8 85 C9 74 0B FF C9 75 11 B9 08 00 00 00 EB 05 B9 10 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 44 24 30 48 8B 5C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_195_0_0 {
	meta:
		name = "roundf"
		size = 101
		refs = "0015 _fd_int 004a __real@bf800000 0054 __real@3f800000"
	strings:
		$1 = { F3 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 BA 01 00 00 00 E8 ?? ?? ?? ?? 0F BF C8 FF C9 83 F9 01 76 37 48 8D 4C 24 30 33 D2 E8 ?? ?? ?? ?? 66 85 C0 74 26 F3 0F 10 44 24 30 B8 00 80 00 00 66 85 44 24 32 74 0A F3 0F 58 05 ?? ?? ?? ?? EB 10 F3 0F 58 05 ?? ?? ?? ?? EB 06 F3 0F 10 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_199_8_0 {
	meta:
		name = "??0AllocatorBucket@details@Concurrency@@QEAA@XZ"
		size = 32
		refs = "000f ?EncodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 83 21 00 48 8B D9 33 C9 E8 ?? ?? ?? ?? 48 89 43 08 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_199_13_0 {
	meta:
		name = "??1AllocatorBucket@details@Concurrency@@QEAA@XZ"
		size = 48
		refs = "0013 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z 0022 ??_V@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 83 39 00 48 8B D9 74 1C 48 8B 4B 08 E8 ?? ?? ?? ?? 48 8B C8 48 8B 10 48 89 53 08 E8 ?? ?? ?? ?? FF 0B 75 E4 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_199_28_0 {
	meta:
		name = "?Alloc@AllocatorBucket@details@Concurrency@@QEAAPEATAllocationEntry@23@XZ"
		size = 38
		refs = "000e ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 49 08 E8 ?? ?? ?? ?? 48 85 C0 74 09 48 8B 10 FF 0B 48 89 53 08 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_199_29_0 {
	meta:
		name = "?Alloc@Concurrency@@YAPEAX_K@Z"
		size = 141
		refs = "001a ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA 0026 ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 002b ?__TlsGetValue@platform@details@Concurrency@@YAPEAXK@Z 0038 ?CreateContextFromDefaultScheduler@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 0051 ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 006b ??0exception@std@@QEAA@AEBQEBDH@Z 0072 ??_7bad_alloc@std@@6B@ 0079 _TI2?AVbad_alloc@std@@ 0088 _CxxThrowException"
	strings:
		$1 = { 40 53 48 83 EC 40 48 B8 FF FF FF FF FF FF FF 7F 48 8B D9 48 3B C8 77 36 F7 05 ?? ?? ?? ?? 00 00 00 80 74 13 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 48 85 C0 75 08 E8 ?? ?? ?? ?? 48 8B C8 48 8B 01 48 8B D3 48 83 C4 40 5B 48 FF 60 50 48 8D 05 ?? ?? ?? ?? 48 8D 54 24 50 48 8D 4C 24 20 41 B8 01 00 00 00 48 89 44 24 50 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 48 89 44 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_199_30_0 {
	meta:
		name = "?Alloc@SubAllocator@details@Concurrency@@QEAAPEAX_K@Z"
		size = 125
		refs = "001f ?GetBucketIndex@SubAllocator@details@Concurrency@@SAH_K@Z 0037 ?Alloc@AllocatorBucket@details@Concurrency@@QEAAPEATAllocationEntry@23@XZ 0046 ?s_bucketSizes@SubAllocator@details@Concurrency@@0QBHB 0052 ??_U@YAPEAX_K@Z 005d ?EncodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8D 5A 08 48 8B E9 48 8B CB E8 ?? ?? ?? ?? 48 63 F8 83 FF FF 74 23 48 8D 4F 01 48 C1 E1 04 48 03 CD E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 16 48 8D 05 ?? ?? ?? ?? 48 63 1C B8 48 8B CB E8 ?? ?? ?? ?? 48 8B D8 48 8B CF E8 ?? ?? ?? ?? 48 8B 6C 24 38 48 8B 74 24 40 48 89 03 48 8D 43 08 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_199_31_0 {
	meta:
		name = "?CurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ"
		size = 42
		refs = "0006 ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA 0012 ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 0017 ?__TlsGetValue@platform@details@Concurrency@@YAPEAXK@Z 0021 ?CreateContextFromDefaultScheduler@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ"
		altNames = "?CurrentContext@Context@Concurrency@@SAPEAV12@XZ"
	strings:
		$1 = { 48 83 EC 28 F7 05 ?? ?? ?? ?? 00 00 00 80 74 10 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 75 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_199_32_0 {
	meta:
		name = "?Free@AllocatorBucket@details@Concurrency@@QEAA_NPEATAllocationEntry@23@@Z"
		size = 47
		refs = "0019 ?EncodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 83 39 20 48 8B D9 7D 19 48 8B 41 08 48 8B CA 48 89 02 E8 ?? ?? ?? ?? FF 03 48 89 43 08 B0 01 EB 02 32 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_199_33_0 {
	meta:
		name = "?Free@Concurrency@@YAXPEAX@Z"
		size = 67
		refs = "000c ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA 001b ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 0020 ?__TlsGetValue@platform@details@Concurrency@@YAPEAXK@Z 002d ?CreateContextFromDefaultScheduler@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ"
	strings:
		$1 = { 48 85 C9 74 3D 53 48 83 EC 20 F7 05 ?? ?? ?? ?? 00 00 00 80 48 8B D9 74 13 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 48 85 C0 75 08 E8 ?? ?? ?? ?? 48 8B C8 48 8B 01 48 8B D3 FF 50 58 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_199_34_0 {
	meta:
		name = "?Free@SubAllocator@details@Concurrency@@QEAAXPEAX@Z"
		size = 74
		refs = "0015 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z 002f ?Free@AllocatorBucket@details@Concurrency@@QEAA_NPEATAllocationEntry@23@@Z 003b ??_V@YAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 5A F8 48 8B F9 48 8B 0B E8 ?? ?? ?? ?? 83 F8 FF 74 19 48 63 C8 48 8B D3 48 FF C1 48 C1 E1 04 48 03 CF E8 ?? ?? ?? ?? 84 C0 75 08 48 8B CB E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_199_35_0 {
	meta:
		name = "?GetBucketIndex@SubAllocator@details@Concurrency@@SAH_K@Z"
		size = 86
	strings:
		$1 = { 48 8D 51 0F 48 83 E2 F0 48 81 FA 00 20 00 00 76 04 83 C8 FF C3 48 C1 EA 04 83 FA 20 7F 04 8D 42 FF C3 B9 05 00 00 00 F7 C2 E0 FF FF FF 7E 0A FF C1 8B C2 D3 F8 85 C0 7F F6 83 E9 05 B8 01 00 00 00 D3 E0 FF C8 03 D0 F7 D0 23 D0 D3 FA C1 E1 04 8D 41 FF 03 C2 C3 }
	condition:
		$1
}

rule file_199_37_0 {
	meta:
		name = "?StaticAlloc@SubAllocator@details@Concurrency@@SAPEAX_K@Z"
		size = 78
		refs = "0012 ?GetBucketIndex@SubAllocator@details@Concurrency@@SAH_K@Z 0021 ?s_bucketSizes@SubAllocator@details@Concurrency@@0QBHB 002d ??_U@YAPEAX_K@Z 0038 ?EncodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 59 08 48 8B CB E8 ?? ?? ?? ?? 48 63 F8 83 FF FF 74 0B 48 8D 0D ?? ?? ?? ?? 48 63 1C B9 48 8B CB E8 ?? ?? ?? ?? 48 8B CF 48 8B D8 E8 ?? ?? ?? ?? 48 89 03 48 8D 43 08 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_200_4_0 {
	meta:
		name = "_mbsrchr_l"
		size = 185
		refs = "001f ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0029 _errno 0034 _invalid_parameter_noinfo 004b strrchr"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 40 48 8B D9 8B F2 48 8D 4C 24 20 49 8B D0 33 FF E8 ?? ?? ?? ?? 48 85 DB 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 59 4C 8B 44 24 28 41 39 78 08 75 0F 8B D6 48 8B CB E8 ?? ?? ?? ?? 48 8B F8 EB 3F 0F B6 13 8B CA 42 F6 44 02 19 04 74 25 48 FF C3 8A 13 84 D2 74 12 C1 E1 08 0F B6 C2 0B C8 3B F1 75 16 48 8D 7B FF EB 10 48 85 FF 75 0B 48 8B FB EB 06 3B F2 48 0F 44 FB 48 FF C3 84 D2 75 C1 80 7C 24 38 00 74 0C 48 8B 4C 24 30 83 A1 C8 00 00 00 FD 48 8B 5C 24 50 48 8B 74 24 58 48 8B C7 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "_heapchk"
		size = 45
		refs = "0009 _crtheap 0019 __imp_HeapValidate"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 0D ?? ?? ?? ?? 45 33 C0 33 D2 BB FE FF FF FF FF 15 ?? ?? ?? ?? 8D 4B FE 85 C0 0F 44 D9 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_202_2_0 {
	meta:
		name = "_stripquote"
		size = 106
		refs = "0010 strlen 001c _calloc_crt 0059 free"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B D9 33 FF E8 ?? ?? ?? ?? 48 8D 48 01 8D 57 01 E8 ?? ?? ?? ?? 48 8B C8 48 85 C0 74 35 48 8B D0 8A 03 84 C0 74 24 3C 22 75 07 48 FF C3 FF C7 EB 08 88 01 48 FF C1 48 FF C3 8A 03 84 C0 75 E7 85 FF 74 07 88 01 48 8B C2 EB 0A 48 8B CA E8 ?? ?? ?? ?? 33 C0 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_202_3_0 {
	meta:
		name = "_tempnam"
		size = 725
		refs = "002c _mtinitlocknum 003e ??_C@_03FICNPLNB@TMP?$AA@ 004a _dupenv_s 0063 _invoke_watson 0079 _access_s 00a0 ??_C@_01KICIPPFI@?2?$AA@ 00b3 ??_C@_01LFCBOECM@?4?$AA@ 00c6 strlen 00e4 calloc 0101 strcat_s 012a _mbsrchr 01d0 _lock 01d8 _tempoff 01df _old_pfxlen 01fb _errno 022e _ultoa_s 027f free 028b _unlock"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 20 41 54 41 56 41 57 48 83 EC 30 48 8B F2 48 8B F9 45 33 E4 4C 21 60 18 41 8D 4C 24 02 E8 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 80 02 00 00 4C 8D 05 ?? ?? ?? ?? 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 83 F8 16 75 15 4C 21 64 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 85 C0 75 1C 48 8B 4C 24 60 48 85 C9 74 12 33 D2 E8 ?? ?? ?? ?? 85 C0 75 07 48 8B 7C 24 60 EB 35 48 85 FF 74 0E 33 D2 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 22 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 3D ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 85 C0 48 0F 45 F9 48 85 F6 74 0B 48 8B CE E8 ?? ?? ?? ?? 4C 8B E0 48 8B CF E8 ?? ?? ?? ?? 8D 48 0C 41 03 CC 44 8B F1 BA 01 00 00 00 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 0F 84 B3 01 00 00 C6 00 00 4C 8B C7 41 8B D6 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 84 01 00 00 48 8B CF E8 ?? ?? ?? ?? 4C 8D 7F FF 4C 03 F8 BA 5C 00 00 00 41 38 17 75 39 48 8B CF E8 ?? ?? ?? ?? 4C 3B F8 74 5E 4C 8D 05 ?? ?? ?? ?? 41 8B D6 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 48 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 41 80 3F 2F 74 2C 4C 8D 05 ?? ?? ?? ?? 49 8B D6 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 16 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 85 F6 74 28 4C 8B C6 49 8B D6 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 16 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 8B CB E8 ?? ?? ?? ?? 48 8D 3C 03 B9 02 00 00 00 E8 ?? ?? ?? ?? 90 44 8B 3D ?? ?? ?? ?? 44 39 25 ?? ?? ?? ?? B8 01 00 00 00 44 0F 42 F8 44 89 3D ?? ?? ?? ?? 44 89 25 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 30 8B 0D ?? ?? ?? ?? FF C1 89 0D ?? ?? ?? ?? 8B C1 41 2B C7 3D FF FF FF 7F 77 59 4D 8B C6 4C 2B C7 4C 03 C3 41 B9 0A 00 00 00 48 8B D7 E8 ?? ?? ?? ?? 85 C0 75 29 E8 ?? ?? ?? ?? 83 20 00 33 D2 48 8B CB E8 ?? ?? ?? ?? 85 C0 74 B5 E8 ?? ?? ?? ?? 83 38 0D 74 AB E8 ?? ?? ?? ?? 89 30 EB 26 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 30 48 8B CB E8 ?? ?? ?? ?? 33 DB B9 02 00 00 00 E8 ?? ?? ?? ?? EB 16 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC 48 8B 4C 24 60 E8 ?? ?? ?? ?? 33 C9 E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 50 48 8B 74 24 58 48 8B 7C 24 68 48 83 C4 30 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_202_4_0 {
	meta:
		name = "_tempnam$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "_wperror$fin$0 _wtempnam$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA B9 02 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "_makepath"
		size = 39
		refs = "001e _makepath_s"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 28 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 83 CA FF E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_964_0_0 {
	meta:
		name = "_wmakepath"
		size = 39
		refs = "001e _wmakepath_s"
	strings:
		$1 = { 48 83 EC 38 48 8B 44 24 60 48 89 44 24 28 4C 89 4C 24 20 4D 8B C8 4C 8B C2 48 83 CA FF E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "_getdllprocaddr"
		size = 33
		refs = "0014 __imp_GetProcAddress"
	strings:
		$1 = { 48 85 D2 75 13 49 81 F8 FF FF 00 00 7F 10 49 8B D0 48 FF 25 ?? ?? ?? ?? 49 83 F8 FF 74 F3 33 C0 C3 }
	condition:
		$1
}

rule file_206_3_0 {
	meta:
		name = "_wcstod_l"
		size = 303
		refs = "0017 __security_cookie 0035 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0047 _errno 0052 _invalid_parameter_noinfo 0070 iswctype 0086 _wfltin2 00bc _HUGE 00c5 __xmm@80000000000000008000000000000000 0114 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 48 89 74 24 20 57 48 83 EC 70 0F 29 74 24 60 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 58 48 8B F1 48 8B F9 48 8B DA 48 8D 4C 24 20 49 8B D0 E8 ?? ?? ?? ?? 48 85 DB 74 03 48 89 3B 48 85 F6 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 0F 57 F6 E9 97 00 00 00 0F B7 0E EB 07 48 83 C7 02 0F B7 0F BA 08 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 EB 4C 8D 44 24 20 48 8D 4C 24 40 48 8B D7 E8 ?? ?? ?? ?? 48 85 DB 74 0B 48 63 48 04 48 8D 14 4F 48 89 13 F7 00 40 02 00 00 74 0D 0F 57 F6 48 85 DB 74 4B 48 89 33 EB 46 F6 00 81 74 17 66 83 3F 2D F2 0F 10 35 ?? ?? ?? ?? 75 21 0F 57 35 ?? ?? ?? ?? EB 18 F7 00 00 01 00 00 74 1D F2 0F 10 40 10 0F 57 F6 66 0F 2E C6 7A 0F 75 0D E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 05 F2 0F 10 70 10 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 0F 28 C6 48 8B 4C 24 58 48 33 CC E8 ?? ?? ?? ?? 4C 8D 5C 24 70 49 8B 5B 20 49 8B 73 28 0F 28 74 24 60 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_207_4_0 {
	meta:
		name = "_ismbclower_l"
		size = 183
		refs = "0019 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0064 __crtGetStringTypeA"
	strings:
		$1 = { 48 89 5C 24 10 48 89 7C 24 20 55 48 8B EC 48 83 EC 60 8B D9 48 8D 4D E0 E8 ?? ?? ?? ?? 33 FF 81 FB FF 00 00 00 76 55 8B C3 89 7D 20 88 5D 11 C1 E8 08 88 45 10 48 8B 45 E8 39 78 08 74 3A 8B 40 04 8D 5F 01 44 8D 4F 02 89 5C 24 30 89 44 24 28 48 8D 45 20 4C 8D 45 10 48 8D 4D E0 8B D3 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 74 0C 66 39 7D 22 75 06 F6 45 20 02 75 1A 8B DF EB 16 48 8B 45 E8 8D 4B 01 BB 01 00 00 00 0F B6 54 01 18 C1 EA 05 23 DA 40 38 7D F8 74 0B 48 8B 4D F0 83 A1 C8 00 00 00 FD 4C 8D 5C 24 60 8B C3 49 8B 5B 18 49 8B 7B 28 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_210_0_0 {
	meta:
		name = "_expand"
		size = 249
		refs = "0020 _errno 002b _invalid_parameter_noinfo 0057 _crtheap 0063 __imp_HeapSize 007e __imp_HeapReAlloc 00b6 __imp_HeapQueryInformation 00d4 __imp_GetLastError 00db _get_errno_from_oserr"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 48 89 74 24 20 57 48 83 EC 30 48 8B DA 48 8B F9 48 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 AE 00 00 00 48 83 FA E0 76 0D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB E6 48 85 D2 B8 01 00 00 00 4C 8B C1 48 8B 0D ?? ?? ?? ?? 48 0F 44 D8 33 D2 FF 15 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 4C 8B CB 4C 8B C7 BA 10 00 00 00 48 8B E8 FF 15 ?? ?? ?? ?? 48 8B F0 48 85 C0 75 57 48 81 FD 00 40 00 00 77 37 48 3B DD 77 32 48 8B 0D ?? ?? ?? ?? 83 4C 24 40 FF 48 21 44 24 20 44 8D 48 04 4C 8D 44 24 40 33 D2 FF 15 ?? ?? ?? ?? 85 C0 74 0C 83 7C 24 40 02 75 05 48 8B F7 EB 17 E8 ?? ?? ?? ?? 48 8B D8 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 89 03 48 8B C6 48 8B 5C 24 48 48 8B 6C 24 50 48 8B 74 24 58 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_210_1_0 {
	meta:
		name = "_is_LFH_enabled"
		size = 66
		refs = "0009 _crtheap 0026 __imp_HeapQueryInformation"
	strings:
		$1 = { 40 53 48 83 EC 30 48 8B 0D ?? ?? ?? ?? 83 4C 24 40 FF 33 DB 44 8D 4B 04 4C 8D 44 24 40 33 D2 48 89 5C 24 20 FF 15 ?? ?? ?? ?? 85 C0 74 0C 83 7C 24 40 02 75 05 BB 01 00 00 00 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_212_0_0 {
	meta:
		name = "_mbsinc"
		size = 66
		refs = "000f _errno 001a _invalid_parameter_noinfo 0026 _ismbblead"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 85 C9 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 1A 0F B6 09 E8 ?? ?? ?? ?? 48 FF C3 85 C0 74 08 80 3B 00 74 03 48 FF C3 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_212_1_0 {
	meta:
		name = "_mbsinc_l"
		size = 39
		refs = "000e _ismbblead_l"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 59 01 0F B6 09 E8 ?? ?? ?? ?? 85 C0 74 08 80 3B 00 74 03 48 FF C3 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "__initstdio"
		size = 152
		refs = "000c _nstream 0036 _calloc_crt 003d __piob 006d _iob"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B 05 ?? ?? ?? ?? 33 DB BF 14 00 00 00 85 C0 75 07 B8 00 02 00 00 EB 05 3B C7 0F 4C C7 48 63 C8 BA 08 00 00 00 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 85 C0 75 24 8D 50 08 48 8B CF 89 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 85 C0 75 07 B8 1A 00 00 00 EB 23 48 8D 0D ?? ?? ?? ?? 48 89 0C 03 48 83 C1 30 48 8D 5B 08 48 FF CF 74 09 48 8B 05 ?? ?? ?? ?? EB E6 33 C0 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_213_1_0 {
	meta:
		name = "__endstdio"
		size = 48
		refs = "0005 _flushall 000b _exitflag 0013 _fcloseall 001a __piob 001f free"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 05 E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 25 ?? ?? ?? ?? 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_213_3_0 {
	meta:
		name = "_lock_file"
		size = 101
		refs = "000c _iob 0046 _lock 0061 __imp_EnterCriticalSection"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8D 0D ?? ?? ?? ?? 48 3B D9 72 40 48 8D 05 ?? ?? ?? ?? 48 3B D8 77 34 48 8B D3 48 B8 AB AA AA AA AA AA AA 2A 48 2B D1 48 F7 EA 48 C1 FA 03 48 8B CA 48 C1 E9 3F 48 03 CA 83 C1 10 E8 ?? ?? ?? ?? 0F BA 6B 18 0F 48 83 C4 20 5B C3 48 8D 4B 30 48 83 C4 20 5B 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_213_4_0 {
	meta:
		name = "_lock_file2"
		size = 49
		refs = "0012 _lock 002d __imp_EnterCriticalSection"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B DA 83 F9 14 7D 13 83 C1 10 E8 ?? ?? ?? ?? 0F BA 6B 18 0F 48 83 C4 20 5B C3 48 8D 4A 30 48 83 C4 20 5B 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_213_5_0 {
	meta:
		name = "_unlock_file"
		size = 78
		refs = "0003 _iob 003f _unlock 004a __imp_LeaveCriticalSection"
	strings:
		$1 = { 48 8D 15 ?? ?? ?? ?? 48 3B CA 72 37 48 8D 05 ?? ?? ?? ?? 48 3B C8 77 2B 0F BA 71 18 0F 48 2B CA 48 B8 AB AA AA AA AA AA AA 2A 48 F7 E9 48 C1 FA 03 48 8B CA 48 C1 E9 3F 48 03 CA 83 C1 10 E9 ?? ?? ?? ?? 48 83 C1 30 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_213_6_0 {
	meta:
		name = "_unlock_file2"
		size = 29
		refs = "000e _unlock 0019 __imp_LeaveCriticalSection"
	strings:
		$1 = { 83 F9 14 7D 0D 0F BA 72 18 0F 83 C1 10 E9 ?? ?? ?? ?? 48 8D 4A 30 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_216_2_0 {
	meta:
		name = "_wpopen"
		size = 1824
		refs = "001e __security_cookie 005d _errno 0068 _invalid_parameter_noinfo 00fb _pipe 013b _mtinitlocknum 0148 _close 0160 _lock 0171 __imp_GetCurrentProcess 0187 __pioinfo 01b8 __imp_DuplicateHandle 01e2 _wfdopen 01ff __idpairs 0214 __idtabsiz 0264 _recalloc_crt 02a5 ??_C@_1BA@HMCCKBDK@?$AAC?$AAO?$AAM?$AAS?$AAP?$AAE?$AAC?$AA?$AA@ 02b1 _wdupenv_s 02ca _invoke_watson 02df ??_C@_1BA@DBKIDAPL@?$AAc?$AAm?$AAd?$AA?4?$AAe?$AAx?$AAe?$AA?$AA@ 02f6 memset 0354 wcslen 0369 ??_C@_19FNCMDGGJ@?$AA?5?$AA?1?$AAc?$AA?5?$AA?$AA@ 037f _calloc_crt 0399 wcscpy_s 03b5 wcscat_s 0404 _waccess_s 0449 __imp_CreateProcessW 0472 free 0497 ??_C@_19IJOJOJIB@?$AAP?$AAA?$AAT?$AAH?$AA?$AA@ 04e0 _wgetpath 0519 ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 0626 __imp_CloseHandle 06a5 fclose 06ec _unlock 06ff __security_check_cookie"
	strings:
		$1 = { 4C 8B DC 49 89 5B 10 49 89 73 18 57 41 54 41 55 41 56 41 57 48 81 EC 40 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 38 01 00 00 48 89 4C 24 60 33 DB 49 89 9B 18 FF FF FF 44 8B EB 48 89 5C 24 78 41 89 5B C8 66 41 89 5B CC 89 5C 24 54 8B C3 48 85 C9 0F 95 C0 85 C0 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 80 06 00 00 8B C3 48 85 D2 0F 95 C0 85 C0 74 DD 66 B9 20 00 BE 02 00 00 00 66 39 0A 75 05 48 03 D6 EB F6 0F B7 02 66 83 F8 72 74 06 66 83 F8 77 75 BB 66 89 84 24 30 01 00 00 48 03 D6 66 39 0A 74 F8 0F B7 02 66 83 F8 62 74 0B 66 85 C0 74 06 66 83 F8 74 75 97 66 89 84 24 32 01 00 00 66 83 F8 74 75 08 41 B8 00 40 00 00 EB 10 44 8B C3 B9 00 80 00 00 66 83 F8 62 44 0F 44 C1 41 0F BA E8 07 BA 00 04 00 00 48 8D 4C 24 58 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 E8 05 00 00 41 BE 01 00 00 00 66 83 BC 24 30 01 00 00 77 75 0B 44 8B FB 44 8B E3 41 8B FE EB 08 45 8B FE 45 8B E6 8B FB 89 7C 24 70 44 89 64 24 50 B9 09 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 17 8B 4C 24 58 E8 ?? ?? ?? ?? 8B 4C 24 5C E8 ?? ?? ?? ?? E9 12 FF FF FF B9 09 00 00 00 E8 ?? ?? ?? ?? 90 44 89 74 24 6C 44 89 74 24 68 FF 15 ?? ?? ?? ?? 49 63 DC 48 63 54 9C 58 48 8B CA 48 C1 F9 05 4C 8D 05 ?? ?? ?? ?? 83 E2 1F 4C 6B D2 58 49 8B 14 C8 89 74 24 30 44 89 74 24 28 83 64 24 20 00 4C 8D 8C 24 80 00 00 00 4C 8B C0 4A 8B 14 12 48 8B C8 FF 15 ?? ?? ?? ?? 85 C0 0F 84 FB 04 00 00 8B 4C 9C 58 E8 ?? ?? ?? ?? 83 64 9C 68 00 48 63 C7 48 8D 94 24 30 01 00 00 8B 4C 84 58 E8 ?? ?? ?? ?? 4C 8B E8 48 89 84 24 A0 00 00 00 33 DB 48 85 C0 0F 84 C5 04 00 00 4C 8B 0D ?? ?? ?? ?? 49 8B F9 4C 89 8C 24 90 00 00 00 44 8D 43 10 8B 15 ?? ?? ?? ?? 48 8B CA 48 C1 E1 04 49 03 C9 48 3B F9 73 12 48 39 1F 74 0D 49 03 F8 48 89 BC 24 90 00 00 00 EB DF 48 8B C2 48 C1 E0 04 49 03 C1 48 3B F8 72 51 8D 42 01 3B C2 72 47 8B D0 48 B8 FF FF FF FF FF FF FF 0F 48 3B D0 73 36 49 8B C9 E8 ?? ?? ?? ?? 48 85 C0 74 29 48 89 05 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8B F9 48 C1 E7 04 48 03 F8 48 89 BC 24 90 00 00 00 41 03 CE 89 0D ?? ?? ?? ?? EB 03 48 8B FB 48 85 FF 0F 84 FF 03 00 00 4C 8D 05 ?? ?? ?? ?? 33 D2 48 8D 4C 24 78 E8 ?? ?? ?? ?? 83 F8 16 75 14 48 89 5C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 85 C0 75 0A 4C 8B 64 24 78 4D 85 E4 75 07 4C 8D 25 ?? ?? ?? ?? BB 68 00 00 00 44 8B C3 33 D2 48 8D 8C 24 C0 00 00 00 E8 ?? ?? ?? ?? 89 9C 24 C0 00 00 00 C7 84 24 FC 00 00 00 00 01 00 00 48 8B 84 24 80 00 00 00 48 8B 0D ?? ?? ?? ?? 45 85 FF 48 8B D0 74 03 48 8B 11 48 89 94 24 10 01 00 00 45 3B FE 74 04 48 8B 41 58 48 89 84 24 18 01 00 00 48 8B 81 B0 00 00 00 48 89 84 24 20 01 00 00 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8B D8 49 8B CC E8 ?? ?? ?? ?? 48 03 D8 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 FF C0 48 03 D8 48 8B D6 48 8B CB E8 ?? ?? ?? ?? 4C 8B F8 48 85 C0 0F 84 0B 03 00 00 4D 8B C4 48 8B D3 48 8B C8 E8 ?? ?? ?? ?? 33 C9 85 C0 0F 85 E1 02 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B D3 49 8B CF E8 ?? ?? ?? ?? 33 C9 85 C0 0F 85 B3 02 00 00 4C 8B 44 24 60 48 8B D3 49 8B CF E8 ?? ?? ?? ?? 33 C9 85 C0 0F 85 87 02 00 00 33 D2 44 8D 41 18 48 8D 8C 24 A8 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 18 89 9C 24 88 00 00 00 33 D2 49 8B CC E8 ?? ?? ?? ?? 33 C9 85 C0 75 47 48 8D 84 24 A8 00 00 00 48 89 44 24 48 48 8D 84 24 C0 00 00 00 48 89 44 24 40 48 89 4C 24 38 48 89 4C 24 30 89 4C 24 28 44 89 74 24 20 45 33 C9 45 33 C0 49 8B D7 49 8B CC FF 15 ?? ?? ?? ?? 44 8B F0 E9 B5 01 00 00 48 89 4C 24 60 48 8B D6 B9 04 01 00 00 E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 75 25 33 C9 E8 ?? ?? ?? ?? 49 8B CF E8 ?? ?? ?? ?? 48 8B 4C 24 78 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 18 E9 06 02 00 00 4C 8D 05 ?? ?? ?? ?? 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 83 F8 16 75 15 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 48 8B 4C 24 60 85 C0 74 0A E8 ?? ?? ?? ?? 48 8B CE EB 9D 33 DB 41 B8 03 01 00 00 48 8B D6 E8 ?? ?? ?? ?? 48 89 84 24 98 00 00 00 48 85 C0 0F 84 F7 00 00 00 66 39 1E 0F 84 EE 00 00 00 48 8B CE E8 ?? ?? ?? ?? 66 83 7C 46 FE 5C 74 34 66 83 7C 46 FE 2F 74 2C 4C 8D 05 ?? ?? ?? ?? BA 04 01 00 00 48 8B CE E8 ?? ?? ?? ?? 85 C0 74 14 48 89 5C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 49 8B CC E8 ?? ?? ?? ?? 48 8B D8 48 8B CE E8 ?? ?? ?? ?? 48 03 D8 B8 04 01 00 00 48 3B D8 0F 83 86 00 00 00 4D 8B C4 8B D0 48 8B CE E8 ?? ?? ?? ?? 33 DB 85 C0 75 5F 33 D2 48 8B CE E8 ?? ?? ?? ?? 85 C0 75 44 48 8D 84 24 A8 00 00 00 48 89 44 24 48 48 8D 84 24 C0 00 00 00 48 89 44 24 40 48 89 5C 24 38 48 89 5C 24 30 89 5C 24 28 44 89 74 24 20 45 33 C9 45 33 C0 49 8B D7 48 8B CE FF 15 ?? ?? ?? ?? 44 8B F0 EB 26 48 8B 8C 24 98 00 00 00 E9 FE FE FF FF 48 89 5C 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 44 8B 74 24 54 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8B CE E8 ?? ?? ?? ?? 8B 9C 24 88 00 00 00 49 8B CF E8 ?? ?? ?? ?? 48 8B 4C 24 78 E8 ?? ?? ?? ?? 48 8B 8C 24 80 00 00 00 FF 15 ?? ?? ?? ?? 45 85 F6 74 0E 48 8B 8C 24 B0 00 00 00 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 18 33 DB 45 85 F6 74 14 48 8B 84 24 A8 00 00 00 48 89 47 08 4C 89 2F E9 87 00 00 00 48 89 1F EB 38 48 89 4C 24 20 45 33 C9 45 33 C0 33 D2 E8 ?? ?? ?? ?? 48 89 4C 24 20 45 33 C9 45 33 C0 33 D2 E8 ?? ?? ?? ?? 48 89 4C 24 20 45 33 C9 45 33 C0 33 D2 E8 ?? ?? ?? ?? 33 DB 44 8B 64 24 50 49 8B CD E8 ?? ?? ?? ?? 48 63 7C 24 70 89 5C BC 68 4C 8B EB 48 89 9C 24 A0 00 00 00 EB 02 33 DB 49 63 C4 39 5C 84 68 74 09 8B 4C 84 58 E8 ?? ?? ?? ?? 48 63 C7 39 5C 84 68 74 0A 8B 4C 84 58 E8 ?? ?? ?? ?? 90 B9 09 00 00 00 E8 ?? ?? ?? ?? 49 8B C5 48 8B 8C 24 38 01 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 40 01 00 00 49 8B 5B 38 49 8B 73 40 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_216_3_0 {
	meta:
		name = "_wpopen$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "_popen$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 50 48 8B EA B9 09 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 50 5D C3 CC }
	condition:
		$1
}

rule file_216_4_0 {
	meta:
		name = "idtab"
		size = 150
		refs = "0007 __idpairs 000e __idtabsiz 0063 _recalloc_crt"
	strings:
		$1 = { 48 83 EC 28 4C 8B 15 ?? ?? ?? ?? 44 8B 05 ?? ?? ?? ?? 45 8B C8 49 8B D2 49 C1 E1 04 4D 03 CA 4D 3B D1 73 0E 48 39 0A 74 09 48 83 C2 10 49 3B D1 72 F2 49 3B D1 73 05 48 8B C2 EB 55 48 85 C9 75 4E 41 8D 40 01 41 3B C0 72 45 8B D0 48 B8 FF FF FF FF FF FF FF 0F 48 3B D0 73 34 44 8D 41 10 49 8B CA E8 ?? ?? ?? ?? 48 8B D0 48 85 C0 74 20 8B 0D ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 8B C1 48 C1 E0 04 48 03 C2 FF C1 89 0D ?? ?? ?? ?? EB 02 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_217_0_0 {
	meta:
		name = "rename"
		size = 327
		refs = "0026 __crtIsPackagedApp 0030 __imp_AreFileApisANSI 0056 __imp_MultiByteToWideChar 0095 _malloc_crt 00ee _wrename 00f8 free 010a __imp_GetLastError 0111 _dosmaperr"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 30 4C 8B FA 4C 8B E1 33 DB E8 ?? ?? ?? ?? 85 C0 75 0E FF 15 ?? ?? ?? ?? 8D 4B 01 85 C0 0F 44 D9 83 64 24 28 00 48 83 64 24 20 00 83 CD FF 44 8B CD 4D 8B C4 33 D2 8B CB FF 15 ?? ?? ?? ?? 48 63 F0 85 C0 0F 84 B4 00 00 00 83 64 24 28 00 48 83 64 24 20 00 44 8B CD 4D 8B C7 33 D2 8B CB FF 15 ?? ?? ?? ?? 44 8B F0 85 C0 0F 84 8E 00 00 00 8D 0C 30 48 63 C9 48 03 C9 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 0F 84 81 00 00 00 48 8D 2C 70 89 74 24 28 83 CE FF 4D 8B C4 33 D2 8B CB 44 8B CE 48 89 44 24 20 FF 15 ?? ?? ?? ?? 85 C0 74 37 44 8B CE 4D 8B C7 33 D2 8B CB 44 89 74 24 28 48 89 6C 24 20 FF 15 ?? ?? ?? ?? 85 C0 74 19 48 8B D5 48 8B CF E8 ?? ?? ?? ?? 48 8B CF 8B D8 E8 ?? ?? ?? ?? 8B C3 EB 28 48 8B CF E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C6 EB 0F FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C5 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 8B 7C 24 68 48 83 C4 30 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_221_3_0 {
	meta:
		name = "_output_p_l"
		size = 4307
		refs = "0022 __security_cookie 0062 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0072 _errno 0091 _fileno 0098 __badioinfo 00bc __ImageBase 00c4 __pioinfo 0110 _invalid_parameter_noinfo 01bb __lookuptable_s 0219 strtol 0244 memset 0408 _validate_param_reuseA 043c __nullstring 04f2 wctomb_s 064a __wnullstring 071b _get_printf_count_output 0a2e _malloc_crt 0a85 _cfltcvt_tab 0a92 __imp_DecodePointer 0b17 strlen 0ba0 write_multi_char 0bbd write_string 0c9a free 0f90 _isleadbyte_l 0fa5 write_char 10b4 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 A0 F4 FF FF 48 81 EC 60 0C 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 58 0B 00 00 33 F6 48 8B F9 48 89 4D 98 4C 8B E2 48 89 55 C8 48 8D 4D D0 49 8B D0 4D 8B E9 89 75 90 44 8B FE 89 74 24 50 89 75 8C 89 74 24 44 8B DE 89 74 24 68 E8 ?? ?? ?? ?? 48 89 75 80 41 83 CE FF 41 8B F6 E8 ?? ?? ?? ?? 48 89 45 A8 48 85 FF 0F 84 81 00 00 00 F6 47 18 40 0F 85 8C 00 00 00 48 8B CF E8 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 4C 63 D0 41 8D 4A 02 83 F9 01 76 22 49 8B D2 49 8B CA 83 E2 1F 48 C1 F9 05 4C 6B CA 58 48 8D 15 ?? ?? ?? ?? 4C 03 8C CA ?? ?? ?? ?? EB 0A 4D 8B C8 48 8D 15 ?? ?? ?? ?? 41 F6 41 38 7F 75 29 41 8D 42 02 83 F8 01 76 19 49 8B CA 49 8B C2 83 E1 1F 48 C1 F8 05 4C 6B C1 58 4C 03 84 C2 ?? ?? ?? ?? 41 F6 40 38 80 74 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 0F 03 00 00 33 FF 4D 85 E4 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 60 0F 00 00 8B CF 44 8B D7 89 7C 24 4C 89 4C 24 7C 83 F9 01 75 08 85 F6 0F 84 43 0F 00 00 48 8B 45 C8 41 8B D6 4D 8B CC 89 7C 24 54 45 8B E6 44 89 75 A0 41 8B F6 44 89 74 24 78 44 8A 30 44 8B DF 48 89 7D B0 89 54 24 40 89 7C 24 5C 89 7C 24 48 45 84 F6 0F 84 D7 0E 00 00 4C 63 C1 4C 89 44 24 70 49 FF C1 4C 89 4C 24 60 45 85 D2 0F 88 5A 0E 00 00 41 8D 46 E0 3C 58 77 1B 48 8D 0D ?? ?? ?? ?? 49 0F BE C6 0F B6 8C 08 ?? ?? ?? ?? 83 E1 0F 45 33 D2 EB 06 45 33 D2 41 8B CA 48 63 C1 48 8D 0C C0 49 63 C3 41 BB 01 00 00 00 48 03 C8 48 8D 05 ?? ?? ?? ?? 0F B6 84 01 ?? ?? ?? ?? C1 E8 04 89 45 88 41 3B C3 0F 85 DD 00 00 00 41 80 39 25 0F 84 DC 00 00 00 83 FE FF 75 5E 45 8D 43 09 48 8D 55 80 49 8B C9 E8 ?? ?? ?? ?? 45 33 D2 85 C0 7E 2F 48 8B 45 80 80 38 24 75 26 4C 39 54 24 70 75 14 48 8D 8D F0 01 00 00 33 D2 41 B8 60 09 00 00 E8 ?? ?? ?? ?? BE 01 00 00 00 89 74 24 78 EB 1D 4C 8B 44 24 70 4C 8B 4C 24 60 41 8B F2 44 89 54 24 78 41 BB 01 00 00 00 41 3B F3 75 74 48 8B 4C 24 60 48 8D 55 80 41 B8 0A 00 00 00 E8 ?? ?? ?? ?? 48 8B 4D 80 4C 8B 44 24 70 44 8B E0 41 BB 01 00 00 00 4C 8D 49 01 45 2B E3 45 33 D2 4C 89 4C 24 60 44 89 65 A0 4D 85 C0 75 36 45 85 E4 0F 88 5D 01 00 00 80 39 24 0F 85 54 01 00 00 41 83 FC 64 0F 8D 4A 01 00 00 8B 44 24 40 44 3B E0 41 0F 4F C4 89 44 24 40 EB 09 83 F8 08 0F 84 30 01 00 00 8B 4D 88 85 C9 0F 84 7F 0C 00 00 FF C9 0F 84 53 0C 00 00 FF C9 0F 84 F8 0B 00 00 FF C9 0F 84 5A 0B 00 00 FF C9 0F 84 45 0B 00 00 FF C9 0F 84 4A 0A 00 00 FF C9 0F 84 8F 09 00 00 FF C9 0F 85 BA 0C 00 00 41 0F BE CE 83 F9 64 0F 8F 7B 02 00 00 0F 84 0C 04 00 00 83 F9 41 0F 84 0E 02 00 00 83 F9 43 0F 84 29 01 00 00 8D 41 BB A9 FD FF FF FF 0F 84 F7 01 00 00 83 F9 53 0F 84 E2 00 00 00 83 F9 58 0F 84 37 03 00 00 83 F9 5A 74 17 83 F9 61 0F 84 DF 01 00 00 83 F9 63 0F 84 00 01 00 00 E9 97 07 00 00 85 F6 75 0A 49 8B 45 00 49 83 C5 08 EB 21 41 83 FC 63 77 78 49 63 C4 48 8D 0C 40 4D 85 C0 0F 84 65 02 00 00 48 8B 84 CD F8 01 00 00 48 8B 00 48 85 C0 74 7D 48 8B 58 08 48 85 DB 74 74 0F BF 00 41 0F BA E7 0B 73 60 99 44 89 5C 24 68 2B C2 D1 F8 E9 3D 07 00 00 C7 00 03 00 00 00 44 88 B4 CD 00 02 00 00 44 89 BC CD 04 02 00 00 E9 26 07 00 00 BA 03 00 00 00 45 8B CF 45 8A C6 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 0B 07 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 41 83 CE FF 33 FF E9 66 0C 00 00 44 89 54 24 68 E9 E2 06 00 00 48 8B 1D ?? ?? ?? ?? E9 CE 06 00 00 41 F7 C7 30 08 00 00 75 05 41 0F BA EF 0B 83 FF FF 8B D7 B8 FF FF FF 7F 0F 44 D0 85 F6 0F 85 93 01 00 00 49 8B 5D 00 49 83 C5 08 E9 C0 01 00 00 41 F7 C7 30 08 00 00 75 05 41 0F BA EF 0B 41 F7 C7 10 08 00 00 74 78 85 F6 75 0B 45 0F B7 4D 00 49 83 C5 08 EB 47 41 83 FC 63 0F 87 6F FF FF FF 49 63 C4 48 8D 0C 40 4D 85 C0 75 25 48 8D 85 F0 01 00 00 48 8D 04 C8 44 39 10 75 0B C7 00 02 00 00 00 E9 18 FF FF FF BA 02 00 00 00 E9 28 FF FF FF 48 8B 84 CD F8 01 00 00 44 0F B7 08 48 8D 55 F0 48 8D 4C 24 54 41 B8 00 02 00 00 E8 ?? ?? ?? ?? 85 C0 74 46 C7 44 24 44 01 00 00 00 EB 3C 85 F6 75 0B 41 0F B7 45 00 49 83 C5 08 EB 25 41 83 FC 63 0F 87 F7 FE FF FF 49 63 C4 48 8D 0C 40 4D 85 C0 0F 84 08 03 00 00 48 8B 84 CD F8 01 00 00 0F B7 00 88 45 F0 44 89 5C 24 54 48 8D 5D F0 E9 D6 05 00 00 44 89 18 E9 93 FE FF FF 44 89 5D 8C 41 80 C6 20 41 83 CF 40 41 3B F3 0F 85 85 04 00 00 4D 85 C0 0F 85 7C 04 00 00 41 83 FC 63 0F 87 9B FE FF FF 49 63 C4 48 8D 0C 40 48 8D 85 F0 01 00 00 48 8D 04 C8 44 39 10 0F 85 32 04 00 00 C7 00 08 00 00 00 44 88 B4 CD 00 02 00 00 44 89 BC CD 04 02 00 00 E9 32 0A 00 00 83 F9 67 7E A5 83 F9 69 0F 84 89 01 00 00 83 F9 6E 0F 84 21 01 00 00 83 F9 6F 0F 84 03 01 00 00 83 F9 70 0F 84 BD 00 00 00 83 F9 73 0F 84 72 FE FF FF 83 F9 75 0F 84 60 01 00 00 83 F9 78 0F 85 2C 05 00 00 8D 41 AF E9 AD 00 00 00 41 83 FC 63 0F 87 0F FE FF FF 49 63 C4 48 8D 0C 40 4D 85 C0 75 19 48 8D 85 F0 01 00 00 48 8D 04 C8 44 39 10 0F 84 B9 FD FF FF E9 CF FD FF FF 48 8B 9C CD F8 01 00 00 48 8B 1B 41 F7 C7 10 08 00 00 74 31 48 85 DB 44 89 5C 24 68 48 0F 44 1D ?? ?? ?? ?? 48 8B C3 EB 0D 41 2B D3 66 44 39 10 74 08 48 83 C0 02 85 D2 75 EF 48 2B C3 48 D1 F8 E9 AC 04 00 00 48 85 DB 48 0F 44 1D ?? ?? ?? ?? 48 8B C3 EB 0B 41 2B D3 44 38 10 74 07 49 03 C3 85 D2 75 F1 2B C3 E9 86 04 00 00 BF 10 00 00 00 41 0F BA EF 0F 89 7C 24 48 B8 07 00 00 00 89 45 90 41 B9 10 00 00 00 45 84 FF 0F 89 96 00 00 00 41 8D 51 F2 04 51 C6 44 24 58 30 89 54 24 50 88 44 24 59 E9 82 00 00 00 41 B9 08 00 00 00 45 84 FF 79 73 B8 00 02 00 00 44 0B F8 EB 69 85 F6 75 0A 49 8B 7D 00 49 83 C5 08 EB 25 41 83 FC 63 0F 87 15 FD FF FF 49 63 C4 48 8D 0C 40 4D 85 C0 0F 84 02 FF FF FF 48 8B 84 CD F8 01 00 00 48 8B 38 E8 ?? ?? ?? ?? 85 C0 0F 84 ED FC FF FF 8B 44 24 4C 41 F6 C7 20 74 05 66 89 07 EB 02 89 07 B8 01 00 00 00 89 44 24 44 E9 DD 03 00 00 41 83 CF 40 41 B9 0A 00 00 00 8B 54 24 50 41 0F BA E7 0F 73 4C 85 F6 75 0D 4D 8B 45 00 49 83 C5 08 E9 9A 01 00 00 41 83 FC 63 0F 87 9E FC FF FF 49 63 C4 48 8D 0C 40 4D 85 C0 75 6B 48 8D 85 F0 01 00 00 48 8D 04 C8 44 39 10 75 0B C7 00 04 00 00 00 E9 47 FC FF FF BA 04 00 00 00 E9 57 FC FF FF 41 0F BA E7 0C 73 4F 85 F6 74 AD 41 83 FC 63 0F 87 58 FC FF FF 49 63 C4 48 8D 0C 40 4D 85 C0 75 25 48 8D 85 F0 01 00 00 48 8D 04 C8 44 39 10 75 0B C7 00 05 00 00 00 E9 01 FC FF FF BA 05 00 00 00 E9 11 FC FF FF 48 8B 84 CD F8 01 00 00 4C 8B 00 E9 09 01 00 00 41 F6 C7 20 0F 84 91 00 00 00 41 F6 C7 40 74 55 85 F6 75 0E 4D 0F BF 45 00 49 83 C5 08 E9 E7 00 00 00 41 83 FC 63 0F 87 EB FB FF FF 49 63 C4 48 8D 0C 40 4D 85 C0 75 1C 48 8D 85 F0 01 00 00 48 8D 04 C8 44 39 10 0F 84 00 FD FF FF 41 8B D3 E9 AD FB FF FF 48 8B 84 CD F8 01 00 00 4C 0F BF 00 E9 A4 00 00 00 85 F6 75 0E 45 0F B7 45 00 49 83 C5 08 E9 92 00 00 00 41 83 FC 63 0F 87 96 FB FF FF 49 63 C4 48 8D 0C 40 4D 85 C0 74 AB 48 8B 84 CD F8 01 00 00 44 0F B7 00 EB 6E 41 F6 C7 40 74 35 85 F6 75 0A 4D 63 45 00 49 83 C5 08 EB 5A 41 83 FC 63 0F 87 5E FB FF FF 49 63 C4 48 8D 0C 40 4D 85 C0 0F 84 6F FF FF FF 48 8B 84 CD F8 01 00 00 4C 63 00 EB 33 85 F6 75 0A 45 8B 45 00 49 83 C5 08 EB 25 41 83 FC 63 0F 87 29 FB FF FF 49 63 C4 48 8D 0C 40 4D 85 C0 0F 84 3A FF FF FF 48 8B 84 CD F8 01 00 00 44 8B 00 41 F6 C7 40 74 0D 4D 85 C0 79 08 49 F7 D8 41 0F BA EF 08 41 0F BA E7 0F 72 0A 41 0F BA E7 0C 72 03 45 8B C0 BE 00 02 00 00 85 FF 79 05 41 8B FB EB 09 41 83 E7 F7 3B FE 0F 4F FE 44 8B 65 90 49 8B C0 48 8D 9D EF 01 00 00 48 F7 D8 1B C9 23 CA 89 4C 24 50 8B CF 41 2B FB 85 C9 7F 05 4D 85 C0 74 20 33 D2 49 8B C0 49 63 C9 48 F7 F1 4C 8B C0 8D 42 30 83 F8 39 7E 03 41 03 C4 88 03 49 2B DB EB D2 44 8B 65 A0 48 8D 85 EF 01 00 00 89 7C 24 48 2B C3 49 03 DB 89 44 24 54 44 85 FE 0F 84 76 01 00 00 85 C0 74 09 80 3B 30 0F 84 69 01 00 00 49 2B DB 44 01 5C 24 54 C6 03 30 E9 59 01 00 00 45 8A C6 BA 08 00 00 00 45 8B CF 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 84 33 FA FF FF 4C 8B 44 24 70 E9 F1 05 00 00 B8 00 02 00 00 48 8D 5D F0 8B F0 85 FF 79 0A C7 44 24 48 06 00 00 00 EB 49 75 0D 41 80 FE 67 75 41 44 89 5C 24 48 EB 3A 3B F8 0F 4F F8 89 7C 24 48 81 FF A3 00 00 00 7E 29 81 C7 5D 01 00 00 48 63 CF E8 ?? ?? ?? ?? 45 33 D2 48 89 45 B0 48 85 C0 74 07 48 8B D8 8B F7 EB 08 C7 44 24 48 A3 00 00 00 44 39 54 24 78 75 0E 49 8B 45 00 49 83 C5 08 48 89 45 C0 EB 20 41 83 FC 63 0F 87 A8 F9 FF FF 49 63 C4 48 8D 0C 40 48 8B 84 CD F8 01 00 00 48 8B 08 48 89 4D C0 48 8B 0D ?? ?? ?? ?? 41 0F BE FE 48 63 F6 FF 15 ?? ?? ?? ?? 48 8D 4D D0 44 8B CF 48 89 4C 24 30 8B 4D 8C 4C 8B C6 89 4C 24 28 8B 4C 24 48 48 8B D3 89 4C 24 20 48 8D 4D C0 FF D0 41 8B FF 81 E7 80 00 00 00 74 1E 33 C0 39 44 24 48 75 16 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 55 D0 48 8B CB FF D0 41 80 FE 67 75 1A 85 FF 75 16 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 55 D0 48 8B CB FF D0 80 3B 2D 75 08 41 0F BA EF 08 48 FF C3 48 8B CB E8 ?? ?? ?? ?? 89 44 24 54 8B 44 24 44 83 7C 24 78 01 75 0E 4C 8B 44 24 70 4D 85 C0 0F 84 A0 04 00 00 85 C0 0F 85 4D 01 00 00 41 F6 C7 40 74 31 41 0F BA E7 08 73 07 C6 44 24 58 2D EB 0B 41 F6 C7 01 74 10 C6 44 24 58 2B BF 01 00 00 00 89 7C 24 50 EB 11 41 F6 C7 02 74 07 C6 44 24 58 20 EB E8 8B 7C 24 50 44 8B 74 24 5C 48 8B 75 98 44 2B 74 24 54 44 2B F7 41 F6 C7 0C 75 12 4C 8D 4C 24 4C 4C 8B C6 41 8B D6 B1 20 E8 ?? ?? ?? ?? 48 8B 45 A8 4C 8D 4C 24 4C 48 8D 4C 24 58 4C 8B C6 8B D7 48 89 44 24 20 E8 ?? ?? ?? ?? 41 F6 C7 08 74 18 41 F6 C7 04 75 12 4C 8D 4C 24 4C 4C 8B C6 41 8B D6 B1 30 E8 ?? ?? ?? ?? 8B 7C 24 54 33 C0 39 44 24 68 74 67 85 FF 7E 63 48 8B F3 44 0F B7 0E 48 8D 95 50 0B 00 00 48 8D 4D B8 41 B8 06 00 00 00 FF CF 48 8D 76 02 E8 ?? ?? ?? ?? 85 C0 75 2F 8B 55 B8 85 D2 74 28 48 8B 45 A8 4C 8B 45 98 4C 8D 4C 24 4C 48 8D 8D 50 0B 00 00 48 89 44 24 20 E8 ?? ?? ?? ?? 85 FF 75 B3 48 8B 75 98 EB 28 48 8B 75 98 83 C8 FF 89 44 24 4C EB 1F 48 8B 45 A8 4C 8D 4C 24 4C 4C 8B C6 8B D7 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 8B 44 24 4C 85 C0 78 18 41 F6 C7 04 74 12 4C 8D 4C 24 4C 4C 8B C6 41 8B D6 B1 20 E8 ?? ?? ?? ?? 48 8B 45 B0 48 85 C0 74 0F 48 8B C8 E8 ?? ?? ?? ?? 45 33 D2 4C 89 55 B0 8B 7C 24 48 E9 33 FD FF FF 41 80 FE 49 74 49 41 80 FE 68 74 3A 41 80 FE 6C 74 14 41 80 FE 77 0F 85 17 03 00 00 41 0F BA EF 0B E9 0D 03 00 00 41 80 39 6C 8B 54 24 40 75 0D 4D 03 CB 41 0F BA EF 0C E9 FA 02 00 00 41 83 CF 10 E9 F1 02 00 00 41 83 CF 20 E9 E4 02 00 00 41 8A 01 B9 00 80 00 00 44 0B F9 3C 36 75 13 41 80 79 01 34 75 0C 49 83 C1 02 44 0B F9 E9 C2 02 00 00 3C 33 75 15 41 80 79 01 32 75 0E 49 83 C1 02 41 0F BA F7 0F E9 A9 02 00 00 2C 58 3C 20 77 1A 48 B9 01 10 82 20 01 00 00 00 48 0F A3 C1 73 0A 41 0F BA EF 10 E9 89 02 00 00 44 89 55 88 E9 21 02 00 00 41 80 FE 2A 0F 85 D3 00 00 00 85 F6 75 0D 41 8B 7D 00 49 83 C5 08 E9 A6 00 00 00 48 8D 55 80 41 B8 0A 00 00 00 49 8B C9 E8 ?? ?? ?? ?? 48 8B 4D 80 4C 8B 44 24 70 4C 8D 49 01 41 BB 01 00 00 00 45 33 D2 41 2B C3 4C 89 4C 24 60 4D 85 C0 75 61 85 C0 0F 88 5B F6 FF FF 80 39 24 0F 85 52 F6 FF FF 41 83 FC 64 0F 8D 48 F6 FF FF 8B 54 24 40 3B C2 0F 4F D0 48 98 48 8D 0C 40 48 8D 85 F0 01 00 00 89 54 24 40 48 8D 04 C8 44 39 10 75 18 44 89 18 C6 84 CD 00 02 00 00 2A 44 89 BC CD 04 02 00 00 E9 DE 01 00 00 41 B0 2A 41 8B D3 E9 BC FB FF FF 48 98 48 8D 0C 40 48 8B 84 CD F8 01 00 00 8B 38 8B 54 24 40 89 7C 24 48 85 FF 0F 89 B3 01 00 00 83 CF FF 89 7C 24 48 E9 A7 01 00 00 8D 3C BF 41 0F BE C6 8D 7F E8 8D 3C 78 89 7C 24 48 E9 8D 01 00 00 41 8B FA 44 89 54 24 48 E9 80 01 00 00 41 80 FE 2A 75 76 85 F6 75 0A 41 8B 45 00 49 83 C5 08 EB 49 48 8D 55 80 41 B8 0A 00 00 00 49 8B C9 E8 ?? ?? ?? ?? 48 8B 4D 80 4C 8B 44 24 70 4C 8D 49 01 41 BB 01 00 00 00 45 33 D2 41 2B C3 4C 89 4C 24 60 4D 85 C0 0F 84 03 FF FF FF 48 98 48 8D 0C 40 48 8B 84 CD F8 01 00 00 8B 00 8B 54 24 40 89 44 24 5C 85 C0 0F 89 17 01 00 00 41 83 CF 04 F7 D8 89 44 24 5C E9 08 01 00 00 8B 44 24 5C 8D 0C 80 41 0F BE C6 8D 04 48 83 C0 D0 89 44 24 5C E9 EA 00 00 00 41 80 FE 20 74 44 41 80 FE 23 74 34 41 80 FE 2B 74 26 41 80 FE 2D 74 17 8B 54 24 40 41 80 FE 30 0F 85 C8 00 00 00 41 83 CF 08 E9 BF 00 00 00 41 83 CF 04 E9 B2 00 00 00 45 0B FB E9 AA 00 00 00 41 0F BA EF 07 E9 A0 00 00 00 41 83 CF 02 E9 97 00 00 00 83 CF FF 44 89 55 8C 44 89 54 24 44 44 89 54 24 5C 44 89 54 24 50 45 8B FA 89 7C 24 48 44 89 54 24 68 EB 73 4D 85 C0 75 05 41 3B F3 74 69 4D 3B C3 75 05 83 FE FF 74 5F 48 8D 55 D0 41 0F B6 CE 44 89 54 24 68 E8 ?? ?? ?? ?? 85 C0 74 2A 48 8B 55 98 4C 8D 44 24 4C 41 8A CE E8 ?? ?? ?? ?? 48 8B 44 24 60 44 8A 30 48 FF C0 48 89 44 24 60 45 84 F6 0F 84 52 F4 FF FF 48 8B 55 98 4C 8D 44 24 4C 41 8A CE E8 ?? ?? ?? ?? E9 09 FA FF FF 8B 7C 24 48 4C 8B 4C 24 60 8B 54 24 40 45 8A 31 8B 74 24 78 44 8B 54 24 4C 44 8B 5D 88 45 84 F6 0F 85 95 F1 FF FF 33 FF }
	condition:
		$1
}

rule file_221_4_0 {
	meta:
		name = "_validate_param_reuseA"
		size = 290
	strings:
		$1 = { 48 89 5C 24 08 48 89 7C 24 10 4C 89 74 24 18 44 8A 51 10 41 8B D9 8B FA 4C 8B D9 41 80 FA 70 0F 84 E3 00 00 00 41 80 F8 70 0F 84 D9 00 00 00 41 8D 42 AD BA 00 00 00 00 A8 DF 41 8D 40 AD 8B CA 0F 94 C1 A8 DF 8B C2 0F 94 C0 85 C9 0F 85 8E 00 00 00 85 C0 0F 85 A8 00 00 00 41 8D 42 A8 49 BE 01 10 82 20 01 00 00 00 3C 20 77 0A 48 0F BE C0 49 0F A3 C6 72 12 41 8D 40 A8 3C 20 77 5D 48 0F BE C0 49 0F A3 C6 73 53 41 80 EA 58 B9 01 00 00 00 41 80 FA 20 77 0D 49 0F BE C2 44 8B C9 49 0F A3 C6 72 03 44 8B CA 41 80 E8 58 41 80 F8 20 77 0A 49 0F BE C0 49 0F A3 C6 72 02 8B CA 44 3B C9 74 04 33 C0 EB 4C 41 8B 4B 14 8B C1 33 C3 0F BA E0 10 72 EE 33 CB F6 C1 20 75 E7 41 39 3B EB 2D 3B C8 75 1E B8 10 08 00 00 8B CA 41 85 43 14 0F 95 C1 85 D8 8B C2 0F 95 C0 3B C8 B9 01 00 00 00 74 02 8B CA 8B C1 EB 0A 33 D2 45 3A D0 0F 94 C2 8B C2 48 8B 5C 24 08 48 8B 7C 24 10 4C 8B 74 24 18 C3 }
	condition:
		$1
}

rule file_221_9_0 {
	meta:
		name = "write_char"
		size = 70
		refs = "0031 _flsbuf"
	strings:
		$1 = { 40 53 48 83 EC 20 F6 42 18 40 49 8B D8 74 0C 48 83 7A 10 00 75 05 41 FF 00 EB 25 FF 4A 08 78 0D 48 8B 02 88 08 48 FF 02 0F B6 C1 EB 08 0F BE C9 E8 ?? ?? ?? ?? 83 F8 FF 75 04 09 03 EB 02 FF 03 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_221_10_0 {
	meta:
		name = "write_multi_char"
		size = 81
		refs = "002f write_char"
	strings:
		$1 = { 85 D2 7E 4C 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 49 8B F9 49 8B F0 8B DA 40 8A E9 4C 8B C7 48 8B D6 40 8A CD FF CB E8 ?? ?? ?? ?? 83 3F FF 74 04 85 DB 7F E7 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_221_11_0 {
	meta:
		name = "write_string"
		size = 148
		refs = "0051 write_char"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 20 41 F6 40 18 40 48 8B 5C 24 60 49 8B F9 44 8B 3B 49 8B E8 8B F2 4C 8B F1 74 0C 49 83 78 10 00 75 05 41 01 11 EB 3D 83 23 00 85 D2 7E 33 41 8A 0E 4C 8B C7 48 8B D5 FF CE E8 ?? ?? ?? ?? 49 FF C6 83 3F FF 75 12 83 3B 2A 75 11 4C 8B C7 48 8B D5 B1 3F E8 ?? ?? ?? ?? 85 F6 7F D2 83 3B 00 75 03 44 89 3B 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "__wtomb_environ"
		size = 242
		refs = "0018 _wenviron 004e __imp_WideCharToMultiByte 0066 _calloc_crt 00a5 __crtsetenv 00b8 free"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 57 48 83 EC 40 48 83 64 24 50 00 48 8B 1D ?? ?? ?? ?? 48 8B 03 48 85 C0 0F 84 AA 00 00 00 83 CD FF 48 83 64 24 38 00 48 83 64 24 30 00 83 64 24 28 00 48 83 64 24 20 00 44 8B CD 4C 8B C0 33 D2 33 C9 FF 15 ?? ?? ?? ?? 48 63 F8 85 C0 0F 84 91 00 00 00 48 8B CF BA 01 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 50 48 85 C0 74 7A 48 83 64 24 38 00 48 83 64 24 30 00 4C 8B 03 44 8B CD 33 D2 33 C9 89 7C 24 28 48 89 44 24 20 FF 15 ?? ?? ?? ?? 85 C0 74 47 48 8D 4C 24 50 33 D2 E8 ?? ?? ?? ?? 85 C0 79 15 48 8B 4C 24 50 48 85 C9 74 0B E8 ?? ?? ?? ?? 48 83 64 24 50 00 48 83 C3 08 48 8B 03 48 85 C0 0F 85 59 FF FF FF 33 C0 48 8B 5C 24 58 48 8B 6C 24 60 48 83 C4 40 5F C3 48 8B 4C 24 50 E8 ?? ?? ?? ?? 8B C5 EB E2 }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "_CopyMan"
		size = 24
	strings:
		$1 = { 48 2B CA 41 B8 03 00 00 00 8B 02 89 04 11 48 8D 52 04 49 FF C8 75 F2 C3 }
	condition:
		$1
}

rule file_223_2_0 {
	meta:
		name = "_IncMan"
		size = 121
	strings:
		$1 = { 4C 8B C9 8B C2 B9 1F 00 00 00 99 41 B8 01 00 00 00 23 D1 03 C2 44 8B D0 23 C1 2B C2 41 C1 FA 05 2B C8 4D 63 DA 43 8B 04 99 41 D3 E0 33 C9 42 8D 14 00 3B D0 72 05 41 3B D0 73 05 B9 01 00 00 00 41 8D 42 FF 43 89 14 99 48 63 D0 85 C0 78 27 85 C9 74 23 41 8B 04 91 33 C9 44 8D 40 01 44 3B C0 72 06 41 83 F8 01 73 05 B9 01 00 00 00 45 89 04 91 48 FF CA 79 D9 8B C1 C3 }
	condition:
		$1
}

rule file_223_3_0 {
	meta:
		name = "_IsZeroMan"
		size = 26
	strings:
		$1 = { 33 D2 83 3C 91 00 75 0F 48 FF C2 48 83 FA 03 7C F1 B8 01 00 00 00 C3 33 C0 C3 }
	condition:
		$1
}

rule file_223_4_0 {
	meta:
		name = "_RoundMan"
		size = 310
		refs = "0117 memset"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 20 44 8D 52 FF 33 DB 41 83 CB FF 8D 73 1F 41 8D 42 01 4C 8B C1 99 44 8B F6 44 8D 4B 03 23 D6 03 C2 8B F8 23 C6 2B C2 C1 FF 05 44 2B F0 4C 63 FF 42 8B 04 B9 44 0F A3 F0 0F 83 9C 00 00 00 41 8B CE 41 8B D3 48 63 C7 D3 E2 F7 D2 41 85 14 80 75 18 8D 47 01 48 63 C8 EB 09 41 39 1C 88 75 0A 48 FF C1 49 3B C9 7C F2 EB 71 41 8B C2 41 BA 01 00 00 00 99 23 D6 03 C2 8B E8 23 C6 2B C2 C1 FD 05 2B F0 40 8A CE 48 63 F5 41 8B 04 B0 41 D3 E2 8B CB 42 8D 14 10 3B D0 72 05 41 3B D2 73 05 B9 01 00 00 00 8D 45 FF 41 89 14 B0 48 63 D0 85 C0 78 27 85 C9 74 23 41 8B 04 90 8B CB 44 8D 50 01 44 3B D0 72 06 41 83 FA 01 73 05 B9 01 00 00 00 45 89 14 90 48 FF CA 79 D9 8B D9 8D 47 01 41 8B CE 41 D3 E3 48 63 D0 47 21 1C B8 49 3B D1 7D 15 4C 2B CA 49 8D 0C 90 33 D2 49 C1 E1 02 4D 8B C1 E8 ?? ?? ?? ?? 48 8B 6C 24 48 48 8B 74 24 50 8B C3 48 8B 5C 24 40 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_223_5_0 {
	meta:
		name = "_ShrMan"
		size = 169
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 45 33 C9 41 83 CA FF 8B C2 99 48 8B D9 41 8D 69 20 83 E2 1F 4C 8B C3 41 8D 79 03 03 C2 44 8B D8 83 E0 1F 2B C2 41 C1 FB 05 8B C8 8B F0 41 D3 E2 2B E8 41 F7 D2 41 8B 00 8B CE 8B D0 D3 E8 8B CD 41 0B C1 41 23 D2 44 8B CA 41 89 00 4D 8D 40 04 41 D3 E1 48 FF CF 75 DD 4D 63 CB 8D 57 02 48 8D 4B 08 4D 8B C1 49 F7 D8 49 3B D1 7C 08 42 8B 04 81 89 01 EB 03 83 21 00 48 83 E9 04 48 FF CA 79 E7 48 8B 5C 24 08 48 8B 6C 24 10 48 8B 74 24 18 48 8B 7C 24 20 C3 }
	condition:
		$1
}

rule file_223_6_0 {
	meta:
		name = "_ZeroTail"
		size = 78
	strings:
		$1 = { 8B C2 4C 8B C9 B9 1F 00 00 00 99 23 D1 03 C2 44 8B C0 23 C1 2B C2 83 CA FF 41 C1 F8 05 2B C8 49 63 C0 D3 E2 F7 D2 41 85 14 81 74 03 33 C0 C3 41 8D 40 01 48 63 C8 EB 0A 41 83 3C 89 00 75 ED 48 FF C1 48 83 F9 03 7C F0 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_223_8_0 {
	meta:
		name = "_ld12cvt"
		size = 1444
		refs = "001a __security_cookie 01bd memset 0588 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 08 55 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 70 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F0 0F B7 41 0A 44 0F B7 19 33 DB 8B F8 25 00 80 00 00 41 C1 E3 10 89 45 C0 8B 41 06 81 E7 FF 7F 00 00 89 45 E0 8B 41 02 81 EF FF 3F 00 00 41 BD 1F 00 00 00 4D 8B C8 4C 89 45 B8 89 45 E4 48 89 55 C8 44 89 5D D4 44 89 5D E8 8D 73 01 45 8D 75 E4 81 FF 01 C0 FF FF 75 29 44 8B C3 8B C3 39 5C 85 E0 75 0D 48 03 C6 49 3B C6 7C F2 E9 B2 04 00 00 48 89 5D E0 89 5D E8 BB 02 00 00 00 E9 A1 04 00 00 48 8B 45 E0 41 83 CF FF 89 7D B0 48 89 45 D8 41 8B 40 08 45 8B C5 FF C8 44 8B E3 89 45 B4 FF C0 99 41 23 D5 03 C2 44 8B C8 41 23 C5 41 C1 F9 05 2B C2 44 2B C0 4D 63 D1 42 8B 4C 95 E0 44 89 45 D0 44 0F A3 C1 0F 83 9E 00 00 00 41 8B C8 41 8B C7 49 63 D1 D3 E0 F7 D0 85 44 95 E0 75 19 41 8D 41 01 48 63 C8 EB 09 39 5C 8D E0 75 0A 48 03 CE 49 3B CE 7C F2 EB 72 8B 45 B4 41 8B CD 99 41 23 D5 03 C2 44 8B C0 41 23 C5 2B C2 41 C1 F8 05 8B D6 2B C8 4D 63 D0 42 8B 44 95 E0 D3 E2 8D 0C 10 3B C8 72 04 3B CA 73 03 44 8B E6 41 8D 40 FF 42 89 4C 95 E0 48 63 D0 85 C0 78 27 45 85 E4 74 22 8B 44 95 E0 44 8B E3 44 8D 40 01 44 3B C0 72 05 44 3B C6 73 03 44 8B E6 44 89 44 95 E0 48 2B D6 79 D9 44 8B 45 D0 4D 63 D1 41 8B C8 41 8B C7 D3 E0 42 21 44 95 E0 41 8D 41 01 48 63 D0 49 3B D6 7D 1D 48 8D 4D E0 4D 8B C6 4C 2B C2 48 8D 0C 91 33 D2 49 C1 E0 02 E8 ?? ?? ?? ?? 44 8B 5D D4 45 85 E4 74 02 03 FE 4C 8B 4D B8 41 8B 49 04 8B C1 41 2B 41 08 3B F8 7D 14 48 89 5D E0 89 5D E8 44 8B C3 BB 02 00 00 00 E9 51 03 00 00 3B F9 0F 8F 32 02 00 00 2B 4D B0 48 8B 45 D8 45 8B D7 48 89 45 E0 8B C1 44 89 5D E8 99 4D 8B DE 44 8B CB 41 23 D5 4C 8D 45 E0 03 C2 44 8B E0 41 23 C5 2B C2 41 C1 FC 05 8B C8 8B F8 B8 20 00 00 00 41 D3 E2 2B C1 44 8B F0 41 F7 D2 41 8B 00 8B CF 8B D0 D3 E8 41 8B CE 41 0B C1 41 23 D2 44 8B CA 41 89 00 4D 8D 40 04 41 D3 E1 4C 2B DE 75 DC 4D 63 D4 41 8D 7B 02 45 8D 73 03 4D 8B CA 44 8B C7 49 F7 D9 4D 3B C2 7C 15 49 8B D0 48 C1 E2 02 4A 8D 04 8A 8B 4C 05 E0 89 4C 15 E0 EB 05 42 89 5C 85 E0 4C 2B C6 79 DC 44 8B 45 B4 45 8B DD 41 8D 40 01 99 41 23 D5 03 C2 44 8B C8 41 23 C5 2B C2 41 C1 F9 05 44 2B D8 49 63 C1 8B 4C 85 E0 44 0F A3 D9 0F 83 98 00 00 00 41 8B CB 41 8B C7 49 63 D1 D3 E0 F7 D0 85 44 95 E0 75 19 41 8D 41 01 48 63 C8 EB 09 39 5C 8D E0 75 0A 48 03 CE 49 3B CE 7C F2 EB 6C 41 8B C0 41 8B CD 99 41 23 D5 03 C2 44 8B D0 41 23 C5 2B C2 41 C1 FA 05 8B D6 2B C8 4D 63 E2 42 8B 44 A5 E0 D3 E2 8B CB 44 8D 04 10 44 3B C0 72 05 44 3B C2 73 02 8B CE 41 8D 42 FF 46 89 44 A5 E0 48 63 D0 85 C0 78 24 85 C9 74 20 8B 44 95 E0 8B CB 44 8D 40 01 44 3B C0 72 05 44 3B C6 73 02 8B CE 44 89 44 95 E0 48 2B D6 79 DC 41 8B CB 41 8B C7 D3 E0 49 63 C9 21 44 8D E0 41 8D 41 01 48 63 D0 49 3B D6 7D 19 48 8D 4D E0 4D 8B C6 4C 2B C2 48 8D 0C 91 33 D2 49 C1 E0 02 E8 ?? ?? ?? ?? 48 8B 45 B8 41 BC 20 00 00 00 44 8B CB 8B 40 0C 4C 8D 45 E0 03 C6 99 41 23 D5 03 C2 44 8B D0 41 23 C5 2B C2 41 C1 FA 05 8B C8 44 8B D8 41 D3 E7 44 2B E0 41 F7 D7 41 8B 00 41 8B CB 8B D0 D3 E8 41 8B CC 41 0B C1 41 23 D7 44 8B CA 41 89 00 4D 8D 40 04 41 D3 E1 4C 2B F6 75 DB 4D 63 D2 4C 8B C7 4D 8B CA 49 F7 D9 4D 3B C2 7C 15 49 8B D0 48 C1 E2 02 4A 8D 04 8A 8B 4C 05 E0 89 4C 15 E0 EB 05 42 89 5C 85 E0 4C 2B C6 79 DC 44 8B C3 8B DF E9 13 01 00 00 41 8B 41 0C 45 8B 11 41 BC 20 00 00 00 99 41 23 D5 03 C2 44 8B D8 41 23 C5 2B C2 41 C1 FB 05 8B C8 41 D3 E7 41 F7 D7 41 3B FA 7C 7B 48 89 5D E0 0F BA 6D E0 1F 89 5D E8 44 2B E0 8B F8 44 8B CB 4C 8D 45 E0 41 8B 00 8B CF 41 8B D7 23 D0 D3 E8 41 8B CC 41 0B C1 44 8B CA 41 D3 E1 41 89 00 4D 8D 40 04 4C 2B F6 75 DC 4D 63 CB 41 8D 7E 02 4D 8B C1 49 F7 D8 49 3B F9 7C 15 48 8B D7 48 C1 E2 02 4A 8D 04 82 8B 4C 05 E0 89 4C 15 E0 EB 04 89 5C BD E0 48 2B FE 79 DD 4C 8B 4D B8 8B DE 45 8B 41 14 45 03 C2 EB 70 45 8B 41 14 0F BA 75 E0 1F 44 8B D3 44 03 C7 8B F8 44 2B E0 4C 8D 4D E0 41 8B 01 8B CF 8B D0 D3 E8 41 8B CC 41 0B C2 41 23 D7 44 8B D2 41 89 01 4D 8D 49 04 41 D3 E2 4C 2B F6 75 DC 4D 63 D3 41 8D 7E 02 4D 8B CA 49 F7 D9 49 3B FA 7C 15 48 8B D7 48 C1 E2 02 4A 8D 04 8A 8B 4C 05 E0 89 4C 15 E0 EB 04 89 5C BD E0 48 2B FE 79 DD 4C 8B 4D B8 48 8B 55 C8 45 2B 69 0C 41 8A CD 41 D3 E0 F7 5D C0 1B C0 25 00 00 00 80 44 0B C0 44 0B 45 E0 41 83 79 10 40 75 0B 8B 45 E4 44 89 42 04 89 02 EB 0A 41 83 79 10 20 75 03 44 89 02 8B C3 48 8B 4D F0 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 B0 00 00 00 48 83 C4 70 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_223_9_0 {
	meta:
		name = "_ld12tod"
		size = 1462
		refs = "0022 __security_cookie 00b9 DoubleFormat 01c1 memset 0594 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 18 48 89 7C 24 20 55 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 60 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F8 0F B7 41 0A 44 0F B7 09 33 DB 8B F8 25 00 80 00 00 41 C1 E1 10 89 45 C4 8B 41 06 81 E7 FF 7F 00 00 89 45 E8 8B 41 02 81 EF FF 3F 00 00 41 BC 1F 00 00 00 48 89 55 D0 44 89 4D D8 89 45 EC 44 89 4D F0 8D 73 01 45 8D 74 24 E4 81 FF 01 C0 FF FF 75 29 44 8B C3 8B C3 39 5C 85 E8 75 0D 48 03 C6 49 3B C6 7C F2 E9 B7 04 00 00 48 89 5D E8 89 5D F0 BB 02 00 00 00 E9 A6 04 00 00 48 8B 45 E8 45 8B C4 41 83 CF FF 48 89 45 E0 8B 05 ?? ?? ?? ?? 89 7D C0 FF C8 44 8B EB 89 45 C8 FF C0 99 41 23 D4 03 C2 44 8B D0 41 23 C4 41 C1 FA 05 2B C2 44 2B C0 4D 63 DA 42 8B 4C 9D E8 44 89 45 DC 44 0F A3 C1 0F 83 9E 00 00 00 41 8B C8 41 8B C7 49 63 D2 D3 E0 F7 D0 85 44 95 E8 75 19 41 8D 42 01 48 63 C8 EB 09 39 5C 8D E8 75 0A 48 03 CE 49 3B CE 7C F2 EB 72 8B 45 C8 41 8B CC 99 41 23 D4 03 C2 44 8B C0 41 23 C4 2B C2 41 C1 F8 05 8B D6 2B C8 4D 63 D8 42 8B 44 9D E8 D3 E2 8D 0C 10 3B C8 72 04 3B CA 73 03 44 8B EE 41 8D 40 FF 42 89 4C 9D E8 48 63 D0 85 C0 78 27 45 85 ED 74 22 8B 44 95 E8 44 8B EB 44 8D 40 01 44 3B C0 72 05 44 3B C6 73 03 44 8B EE 44 89 44 95 E8 48 2B D6 79 D9 44 8B 45 DC 4D 63 DA 41 8B C8 41 8B C7 D3 E0 42 21 44 9D E8 41 8D 42 01 48 63 D0 49 3B D6 7D 1D 48 8D 4D E8 4D 8B C6 4C 2B C2 48 8D 0C 91 33 D2 49 C1 E0 02 E8 ?? ?? ?? ?? 44 8B 4D D8 45 85 ED 74 02 03 FE 8B 0D ?? ?? ?? ?? 8B C1 2B 05 ?? ?? ?? ?? 3B F8 7D 14 48 89 5D E8 89 5D F0 44 8B C3 BB 02 00 00 00 E9 54 03 00 00 3B F9 0F 8F 31 02 00 00 2B 4D C0 48 8B 45 E0 45 8B D7 48 89 45 E8 8B C1 44 89 4D F0 99 4D 8B DE 44 8B CB 41 23 D4 4C 8D 45 E8 03 C2 44 8B E8 41 23 C4 2B C2 41 C1 FD 05 8B C8 8B F8 B8 20 00 00 00 41 D3 E2 2B C1 44 8B F0 41 F7 D2 41 8B 00 8B CF 8B D0 D3 E8 41 8B CE 41 0B C1 41 23 D2 44 8B CA 41 89 00 4D 8D 40 04 41 D3 E1 4C 2B DE 75 DC 4D 63 D5 41 8D 7B 02 45 8D 73 03 4D 8B CA 44 8B C7 49 F7 D9 4D 3B C2 7C 15 49 8B D0 48 C1 E2 02 4A 8D 04 8A 8B 4C 05 E8 89 4C 15 E8 EB 05 42 89 5C 85 E8 4C 2B C6 79 DC 44 8B 45 C8 45 8B DC 41 8D 40 01 99 41 23 D4 03 C2 44 8B C8 41 23 C4 2B C2 41 C1 F9 05 44 2B D8 49 63 C1 8B 4C 85 E8 44 0F A3 D9 0F 83 98 00 00 00 41 8B CB 41 8B C7 49 63 D1 D3 E0 F7 D0 85 44 95 E8 75 19 41 8D 41 01 48 63 C8 EB 09 39 5C 8D E8 75 0A 48 03 CE 49 3B CE 7C F2 EB 6C 41 8B C0 41 8B CC 99 41 23 D4 03 C2 44 8B D0 41 23 C4 2B C2 41 C1 FA 05 8B D6 2B C8 4D 63 EA 42 8B 44 AD E8 D3 E2 8B CB 44 8D 04 10 44 3B C0 72 05 44 3B C2 73 02 8B CE 41 8D 42 FF 46 89 44 AD E8 48 63 D0 85 C0 78 24 85 C9 74 20 8B 44 95 E8 8B CB 44 8D 40 01 44 3B C0 72 05 44 3B C6 73 02 8B CE 44 89 44 95 E8 48 2B D6 79 DC 41 8B CB 41 8B C7 D3 E0 49 63 C9 21 44 8D E8 41 8D 41 01 48 63 D0 49 3B D6 7D 19 48 8D 4D E8 4D 8B C6 4C 2B C2 48 8D 0C 91 33 D2 49 C1 E0 02 E8 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 41 BD 20 00 00 00 44 8B CB FF C0 4C 8D 45 E8 99 41 23 D4 03 C2 44 8B D0 41 23 C4 2B C2 41 C1 FA 05 8B C8 44 8B D8 41 D3 E7 44 2B E8 41 F7 D7 41 8B 00 41 8B CB 8B D0 D3 E8 41 8B CD 41 0B C1 41 23 D7 44 8B CA 41 89 00 4D 8D 40 04 41 D3 E1 4C 2B F6 75 DB 4D 63 D2 4C 8B C7 4D 8B CA 49 F7 D9 4D 3B C2 7C 15 49 8B D0 48 C1 E2 02 4A 8D 04 8A 8B 4C 05 E8 89 4C 15 E8 EB 05 42 89 5C 85 E8 4C 2B C6 79 DC 44 8B C3 8B DF E9 1B 01 00 00 8B 05 ?? ?? ?? ?? 44 8B 15 ?? ?? ?? ?? 41 BD 20 00 00 00 99 41 23 D4 03 C2 44 8B D8 41 23 C4 2B C2 41 C1 FB 05 8B C8 41 D3 E7 41 F7 D7 41 3B FA 7C 7A 48 89 5D E8 0F BA 6D E8 1F 89 5D F0 44 2B E8 8B F8 44 8B CB 4C 8D 45 E8 41 8B 00 8B CF 41 8B D7 23 D0 D3 E8 41 8B CD 41 0B C1 44 8B CA 41 D3 E1 41 89 00 4D 8D 40 04 4C 2B F6 75 DC 4D 63 CB 41 8D 7E 02 4D 8B C1 49 F7 D8 49 3B F9 7C 15 48 8B D7 48 C1 E2 02 4A 8D 04 82 8B 4C 05 E8 89 4C 15 E8 EB 04 89 5C BD E8 48 2B FE 79 DD 44 8B 05 ?? ?? ?? ?? 8B DE 45 03 C2 EB 6F 44 8B 05 ?? ?? ?? ?? 0F BA 75 E8 1F 44 8B D3 44 03 C7 8B F8 44 2B E8 4C 8D 4D E8 41 8B 01 8B CF 8B D0 D3 E8 41 8B CD 41 0B C2 41 23 D7 44 8B D2 41 89 01 4D 8D 49 04 41 D3 E2 4C 2B F6 75 DC 4D 63 D3 41 8D 7E 02 4D 8B CA 49 F7 D9 49 3B FA 7C 15 48 8B D7 48 C1 E2 02 4A 8D 04 8A 8B 4C 05 E8 89 4C 15 E8 EB 04 89 5C BD E8 48 2B FE 79 DD 48 8B 55 D0 44 2B 25 ?? ?? ?? ?? 41 8A CC 41 D3 E0 F7 5D C4 1B C0 25 00 00 00 80 44 0B C0 8B 05 ?? ?? ?? ?? 44 0B 45 E8 83 F8 40 75 0B 8B 45 EC 44 89 42 04 89 02 EB 08 83 F8 20 75 03 44 89 02 8B C3 48 8B 4D F8 48 33 CC E8 ?? ?? ?? ?? 4C 8D 5C 24 60 49 8B 5B 30 49 8B 73 40 49 8B 7B 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_223_10_0 {
	meta:
		name = "_ld12tof"
		size = 1462
		refs = "0022 __security_cookie 00b9 FloatFormat 01c1 memset 0594 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 18 48 89 7C 24 20 55 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 60 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F8 0F B7 41 0A 44 0F B7 09 33 DB 8B F8 25 00 80 00 00 41 C1 E1 10 89 45 C4 8B 41 06 81 E7 FF 7F 00 00 89 45 E8 8B 41 02 81 EF FF 3F 00 00 41 BC 1F 00 00 00 48 89 55 D0 44 89 4D D8 89 45 EC 44 89 4D F0 8D 73 01 45 8D 74 24 E4 81 FF 01 C0 FF FF 75 29 44 8B C3 8B C3 39 5C 85 E8 75 0D 48 03 C6 49 3B C6 7C F2 E9 B7 04 00 00 48 89 5D E8 89 5D F0 BB 02 00 00 00 E9 A6 04 00 00 48 8B 45 E8 45 8B C4 41 83 CF FF 48 89 45 E0 8B 05 ?? ?? ?? ?? 89 7D C0 FF C8 44 8B EB 89 45 C8 FF C0 99 41 23 D4 03 C2 44 8B D0 41 23 C4 41 C1 FA 05 2B C2 44 2B C0 4D 63 DA 42 8B 4C 9D E8 44 89 45 DC 44 0F A3 C1 0F 83 9E 00 00 00 41 8B C8 41 8B C7 49 63 D2 D3 E0 F7 D0 85 44 95 E8 75 19 41 8D 42 01 48 63 C8 EB 09 39 5C 8D E8 75 0A 48 03 CE 49 3B CE 7C F2 EB 72 8B 45 C8 41 8B CC 99 41 23 D4 03 C2 44 8B C0 41 23 C4 2B C2 41 C1 F8 05 8B D6 2B C8 4D 63 D8 42 8B 44 9D E8 D3 E2 8D 0C 10 3B C8 72 04 3B CA 73 03 44 8B EE 41 8D 40 FF 42 89 4C 9D E8 48 63 D0 85 C0 78 27 45 85 ED 74 22 8B 44 95 E8 44 8B EB 44 8D 40 01 44 3B C0 72 05 44 3B C6 73 03 44 8B EE 44 89 44 95 E8 48 2B D6 79 D9 44 8B 45 DC 4D 63 DA 41 8B C8 41 8B C7 D3 E0 42 21 44 9D E8 41 8D 42 01 48 63 D0 49 3B D6 7D 1D 48 8D 4D E8 4D 8B C6 4C 2B C2 48 8D 0C 91 33 D2 49 C1 E0 02 E8 ?? ?? ?? ?? 44 8B 4D D8 45 85 ED 74 02 03 FE 8B 0D ?? ?? ?? ?? 8B C1 2B 05 ?? ?? ?? ?? 3B F8 7D 14 48 89 5D E8 89 5D F0 44 8B C3 BB 02 00 00 00 E9 54 03 00 00 3B F9 0F 8F 31 02 00 00 2B 4D C0 48 8B 45 E0 45 8B D7 48 89 45 E8 8B C1 44 89 4D F0 99 4D 8B DE 44 8B CB 41 23 D4 4C 8D 45 E8 03 C2 44 8B E8 41 23 C4 2B C2 41 C1 FD 05 8B C8 8B F8 B8 20 00 00 00 41 D3 E2 2B C1 44 8B F0 41 F7 D2 41 8B 00 8B CF 8B D0 D3 E8 41 8B CE 41 0B C1 41 23 D2 44 8B CA 41 89 00 4D 8D 40 04 41 D3 E1 4C 2B DE 75 DC 4D 63 D5 41 8D 7B 02 45 8D 73 03 4D 8B CA 44 8B C7 49 F7 D9 4D 3B C2 7C 15 49 8B D0 48 C1 E2 02 4A 8D 04 8A 8B 4C 05 E8 89 4C 15 E8 EB 05 42 89 5C 85 E8 4C 2B C6 79 DC 44 8B 45 C8 45 8B DC 41 8D 40 01 99 41 23 D4 03 C2 44 8B C8 41 23 C4 2B C2 41 C1 F9 05 44 2B D8 49 63 C1 8B 4C 85 E8 44 0F A3 D9 0F 83 98 00 00 00 41 8B CB 41 8B C7 49 63 D1 D3 E0 F7 D0 85 44 95 E8 75 19 41 8D 41 01 48 63 C8 EB 09 39 5C 8D E8 75 0A 48 03 CE 49 3B CE 7C F2 EB 6C 41 8B C0 41 8B CC 99 41 23 D4 03 C2 44 8B D0 41 23 C4 2B C2 41 C1 FA 05 8B D6 2B C8 4D 63 EA 42 8B 44 AD E8 D3 E2 8B CB 44 8D 04 10 44 3B C0 72 05 44 3B C2 73 02 8B CE 41 8D 42 FF 46 89 44 AD E8 48 63 D0 85 C0 78 24 85 C9 74 20 8B 44 95 E8 8B CB 44 8D 40 01 44 3B C0 72 05 44 3B C6 73 02 8B CE 44 89 44 95 E8 48 2B D6 79 DC 41 8B CB 41 8B C7 D3 E0 49 63 C9 21 44 8D E8 41 8D 41 01 48 63 D0 49 3B D6 7D 19 48 8D 4D E8 4D 8B C6 4C 2B C2 48 8D 0C 91 33 D2 49 C1 E0 02 E8 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 41 BD 20 00 00 00 44 8B CB FF C0 4C 8D 45 E8 99 41 23 D4 03 C2 44 8B D0 41 23 C4 2B C2 41 C1 FA 05 8B C8 44 8B D8 41 D3 E7 44 2B E8 41 F7 D7 41 8B 00 41 8B CB 8B D0 D3 E8 41 8B CD 41 0B C1 41 23 D7 44 8B CA 41 89 00 4D 8D 40 04 41 D3 E1 4C 2B F6 75 DB 4D 63 D2 4C 8B C7 4D 8B CA 49 F7 D9 4D 3B C2 7C 15 49 8B D0 48 C1 E2 02 4A 8D 04 8A 8B 4C 05 E8 89 4C 15 E8 EB 05 42 89 5C 85 E8 4C 2B C6 79 DC 44 8B C3 8B DF E9 1B 01 00 00 8B 05 ?? ?? ?? ?? 44 8B 15 ?? ?? ?? ?? 41 BD 20 00 00 00 99 41 23 D4 03 C2 44 8B D8 41 23 C4 2B C2 41 C1 FB 05 8B C8 41 D3 E7 41 F7 D7 41 3B FA 7C 7A 48 89 5D E8 0F BA 6D E8 1F 89 5D F0 44 2B E8 8B F8 44 8B CB 4C 8D 45 E8 41 8B 00 8B CF 41 8B D7 23 D0 D3 E8 41 8B CD 41 0B C1 44 8B CA 41 D3 E1 41 89 00 4D 8D 40 04 4C 2B F6 75 DC 4D 63 CB 41 8D 7E 02 4D 8B C1 49 F7 D8 49 3B F9 7C 15 48 8B D7 48 C1 E2 02 4A 8D 04 82 8B 4C 05 E8 89 4C 15 E8 EB 04 89 5C BD E8 48 2B FE 79 DD 44 8B 05 ?? ?? ?? ?? 8B DE 45 03 C2 EB 6F 44 8B 05 ?? ?? ?? ?? 0F BA 75 E8 1F 44 8B D3 44 03 C7 8B F8 44 2B E8 4C 8D 4D E8 41 8B 01 8B CF 8B D0 D3 E8 41 8B CD 41 0B C2 41 23 D7 44 8B D2 41 89 01 4D 8D 49 04 41 D3 E2 4C 2B F6 75 DC 4D 63 D3 41 8D 7E 02 4D 8B CA 49 F7 D9 49 3B FA 7C 15 48 8B D7 48 C1 E2 02 4A 8D 04 8A 8B 4C 05 E8 89 4C 15 E8 EB 04 89 5C BD E8 48 2B FE 79 DD 48 8B 55 D0 44 2B 25 ?? ?? ?? ?? 41 8A CC 41 D3 E0 F7 5D C4 1B C0 25 00 00 00 80 44 0B C0 8B 05 ?? ?? ?? ?? 44 0B 45 E8 83 F8 40 75 0B 8B 45 EC 44 89 42 04 89 02 EB 08 83 F8 20 75 03 44 89 02 8B C3 48 8B 4D F8 48 33 CC E8 ?? ?? ?? ?? 4C 8D 5C 24 60 49 8B 5B 30 49 8B 73 40 49 8B 7B 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_223_11_0 {
	meta:
		name = "_ld12told"
		size = 235
		refs = "0012 __security_cookie 00d7 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 18 57 48 83 EC 20 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 10 44 0F B7 59 0A 44 0F B7 11 BD FF 7F 00 00 8D 45 01 45 0F B7 CB 45 33 C0 41 C1 E2 10 66 44 23 D8 8B 41 02 48 8B DA 8B 51 06 66 44 23 CD 44 89 54 24 08 41 8D 78 01 89 14 24 45 85 D2 79 59 41 F7 C2 FF FF FF 7F 74 50 8D 50 01 41 8B C8 3B D0 72 04 3B D7 73 02 8B CF 89 54 24 04 49 8B D0 85 C9 74 2E 8B 04 94 41 8B C8 44 8D 50 01 44 3B D0 72 05 44 3B D7 73 02 8B CF 44 89 14 94 48 2B D7 79 DD 85 C9 74 0B BA 00 00 00 80 66 44 03 CF EB 03 8B 14 24 8B 44 24 04 66 44 3B CD 89 03 89 53 04 44 0F 44 C7 66 45 0B D9 66 44 89 5B 08 41 8B C0 48 8B 4C 24 10 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B 6C 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "_calloc_impl"
		size = 154
		refs = "0024 _errno 004d _crtheap 0059 __imp_HeapAlloc 0064 _newmode 006f _callnewh"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 49 8B F8 48 8B DA 48 85 C9 74 1D 33 D2 48 8D 42 E0 48 F7 F1 48 3B C3 73 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 5D 48 0F AF D9 B8 01 00 00 00 48 85 DB 48 0F 44 D8 33 C0 48 83 FB E0 77 18 48 8B 0D ?? ?? ?? ?? 8D 50 08 4C 8B C3 FF 15 ?? ?? ?? ?? 48 85 C0 75 2D 83 3D ?? ?? ?? ?? 00 74 19 48 8B CB E8 ?? ?? ?? ?? 85 C0 75 CB 48 85 FF 74 B2 C7 07 0C 00 00 00 EB AA 48 85 FF 74 06 C7 07 0C 00 00 00 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "_snprintf"
		size = 177
		refs = "002e memset 0038 _errno 0043 _invalid_parameter_noinfo 0082 _output_l 00a2 _flsbuf"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 55 53 56 57 48 8B EC 48 83 EC 58 48 83 65 C8 00 48 8B DA 33 D2 49 8B F0 48 8B F9 44 8D 42 28 48 8D 4D D0 E8 ?? ?? ?? ?? 48 85 F6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 5C 48 85 DB 74 05 48 85 FF 74 E1 B8 FF FF FF 7F 4C 8D 4D 40 48 8D 4D C8 48 3B D8 48 8B D6 C7 45 E0 42 00 00 00 0F 47 D8 45 33 C0 48 89 7D D8 89 5D D0 48 89 7D C8 E8 ?? ?? ?? ?? 8B D8 48 85 FF 74 1B FF 4D D0 78 09 48 8B 45 C8 C6 00 00 EB 0B 48 8D 55 C8 33 C9 E8 ?? ?? ?? ?? 8B C3 48 83 C4 58 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_227_1_0 {
	meta:
		name = "_snprintf_l"
		size = 29
		refs = "0014 _vsnprintf_l"
	strings:
		$1 = { 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1019_1_0 {
	meta:
		name = "_snprintf_c_l"
		size = 29
		refs = "0014 _vsnprintf_c_l"
	strings:
		$1 = { 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_948_1_0 {
	meta:
		name = "_snwprintf_l"
		size = 29
		refs = "0014 _vsnwprintf_l"
	strings:
		$1 = { 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_722_8_0 {
	meta:
		name = "_sprintf_p_l"
		size = 29
		refs = "0014 _vsprintf_p_l"
	strings:
		$1 = { 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_722_9_0 {
	meta:
		name = "_sprintf_s_l"
		size = 29
		refs = "0014 _vsprintf_s_l"
	strings:
		$1 = { 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_677_1_0 {
	meta:
		name = "_swprintf_c_l"
		size = 29
		refs = "0014 _vswprintf_c_l"
	strings:
		$1 = { 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_297_9_0 {
	meta:
		name = "_swprintf_p_l"
		size = 29
		refs = "0014 _vswprintf_p_l"
	strings:
		$1 = { 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_297_10_0 {
	meta:
		name = "_swprintf_s_l"
		size = 29
		refs = "0014 _vswprintf_s_l"
	strings:
		$1 = { 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 60 48 89 44 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "__avx_log10f8"
		size = 576
		refs = "0024 __common_slog10_data 0236 __common_slog10_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 84 24 F0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 8F 01 00 00 C5 78 10 05 ?? ?? ?? ?? 49 83 E5 C0 C5 F8 10 2D ?? ?? ?? ?? C4 C1 79 FA C8 C4 E3 7D 19 C2 01 C4 C1 69 FA E0 C5 E9 72 E1 17 C5 E1 72 E4 17 C5 F1 DB CD C5 D9 DB E5 C5 FC C2 2D ?? ?? ?? ?? 11 C4 E3 6D 18 D3 01 C4 C1 71 FE D8 C4 C1 59 FE C8 C5 FC 5B D2 C4 E3 65 18 C9 01 C5 FC C2 1D ?? ?? ?? ?? 16 C5 F4 5C 0D ?? ?? ?? ?? C5 D4 56 E3 C5 E1 EF DB C4 C3 7D 19 E0 01 C4 C1 59 6B E8 C5 74 59 05 ?? ?? ?? ?? C5 D1 63 E3 C5 F4 59 D9 C5 F4 59 2D ?? ?? ?? ?? C5 3C 58 05 ?? ?? ?? ?? C5 F9 D7 D4 C5 D4 58 2D ?? ?? ?? ?? C5 3C 59 C3 C5 F4 59 25 ?? ?? ?? ?? C5 3C 58 C5 C5 DC 58 25 ?? ?? ?? ?? C5 F4 59 2D ?? ?? ?? ?? C5 3C 59 C3 C5 D4 58 2D ?? ?? ?? ?? C5 BC 58 E4 C5 6C 59 05 ?? ?? ?? ?? C5 EC 59 15 ?? ?? ?? ?? C5 DC 59 DB C5 E4 58 DD C5 E4 59 E1 C5 DC 58 2D ?? ?? ?? ?? C5 D4 59 C9 C4 C1 74 58 C8 C5 EC 58 C9 84 D2 75 1D C5 7C 10 84 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FC 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 D2 74 D3 33 C0 C5 FC 11 B4 24 20 01 00 00 C5 FC 11 BC 24 00 01 00 00 C5 7C 11 8C 24 E0 00 00 00 C5 7C 11 94 24 C0 00 00 00 C5 7C 11 9C 24 A0 00 00 00 C5 7C 11 A4 24 80 00 00 00 C5 7C 11 6C 24 60 C5 7C 11 74 24 40 C5 7C 11 7C 24 20 48 89 9C 24 48 01 00 00 8B D8 48 89 B4 24 40 01 00 00 8B F2 0F A3 DE 72 6A FF C3 83 FB 20 7C F4 C5 FC 10 B4 24 20 01 00 00 C5 FC 10 BC 24 00 01 00 00 C5 7C 10 8C 24 E0 00 00 00 C5 7C 10 94 24 C0 00 00 00 C5 7C 10 9C 24 A0 00 00 00 C5 7C 10 A4 24 80 00 00 00 C5 7C 10 6C 24 60 C5 7C 10 74 24 40 C5 7C 10 7C 24 20 C4 C1 7C 10 4D 40 48 8B 9C 24 48 01 00 00 48 8B B4 24 40 01 00 00 E9 06 FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB 82 0F 1F 40 00 }
	condition:
		$1
}

rule file_230_3_0 {
	meta:
		name = "_strtod_l"
		size = 340
		refs = "0017 __security_cookie 0035 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0047 _errno 0052 _invalid_parameter_noinfo 007a _isctype_l 00ad _fltin2 00e1 _HUGE 00ea __xmm@80000000000000008000000000000000 0139 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 48 89 74 24 20 57 48 83 EC 70 0F 29 74 24 60 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 58 48 8B F1 48 8B D9 48 8B FA 48 8D 4C 24 20 49 8B D0 E8 ?? ?? ?? ?? 48 85 FF 74 03 48 89 1F 48 85 F6 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 0F 57 F6 E9 BC 00 00 00 48 8B 54 24 20 83 BA D4 00 00 00 01 7E 19 0F B6 0B 4C 8D 44 24 20 BA 08 00 00 00 E8 ?? ?? ?? ?? 48 8B 54 24 20 EB 11 0F B6 0B 48 8B 82 08 01 00 00 0F B7 04 48 83 E0 08 85 C0 74 05 48 FF C3 EB C4 4C 8D 44 24 20 48 8D 4C 24 40 48 8B D3 E8 ?? ?? ?? ?? 48 85 FF 74 0A 48 63 48 04 48 03 CB 48 89 0F F7 00 40 02 00 00 74 0D 0F 57 F6 48 85 FF 74 4A 48 89 37 EB 45 F6 00 81 74 16 80 3B 2D F2 0F 10 35 ?? ?? ?? ?? 75 21 0F 57 35 ?? ?? ?? ?? EB 18 F7 00 00 01 00 00 74 1D F2 0F 10 40 10 0F 57 F6 66 0F 2E C6 7A 0F 75 0D E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 05 F2 0F 10 70 10 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 0F 28 C6 48 8B 4C 24 58 48 33 CC E8 ?? ?? ?? ?? 4C 8D 5C 24 70 49 8B 5B 20 49 8B 73 28 0F 28 74 24 60 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_232_3_0 {
	meta:
		name = "_mbsnbcpy_s_l"
		size = 519
		refs = "0055 _errno 0061 _invalid_parameter_noinfo 008d ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 00a9 strncpy_s 011a _ismbblead_l"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 40 49 8B F9 49 8B F0 48 8B EA 48 8B D9 4D 85 C9 75 0E 48 85 C9 75 0E 48 85 D2 75 20 33 C0 EB 2F 48 85 C9 74 17 48 85 D2 74 12 4D 85 C9 75 05 44 88 09 EB E8 4D 85 C0 75 31 44 88 01 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 8B 7C 24 68 48 83 C4 40 41 5E C3 48 8B 54 24 70 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 8B D5 83 78 08 00 48 8B CB 75 12 4C 8B CF 4C 8B C6 E8 ?? ?? ?? ?? 8B D8 E9 37 01 00 00 48 83 FF FF 75 15 8A 06 48 FF C6 88 01 48 FF C1 84 C0 74 2A 48 FF CA 75 ED EB 23 8A 06 48 FF C6 88 01 48 FF C1 84 C0 74 0A 48 FF CA 74 05 48 FF CF 75 E8 48 85 FF 75 06 40 88 39 48 FF C1 48 85 D2 0F 85 A4 00 00 00 38 16 74 06 48 83 FF 01 75 37 4C 8D 71 FF 49 8B F6 4C 3B F3 72 19 0F B6 0E 48 8D 54 24 20 E8 ?? ?? ?? ?? 85 C0 74 08 48 FF CE 48 3B F3 73 E7 41 8B C6 2B C6 A8 01 74 09 41 C6 06 00 E9 9F 00 00 00 48 83 FF FF 75 47 48 83 FD 01 76 35 48 8D 75 FE 48 03 F3 48 8B FE 48 3B F3 72 19 0F B6 0F 48 8D 54 24 20 E8 ?? ?? ?? ?? 85 C0 74 08 48 FF CF 48 3B FB 73 E7 8B C6 2B C7 A8 01 74 05 C6 06 00 EB 05 C6 44 2B FF 00 BB 50 00 00 00 EB 62 C6 03 00 E8 ?? ?? ?? ?? BB 22 00 00 00 89 18 E8 ?? ?? ?? ?? EB 4C 48 8B C1 48 2B C3 48 83 F8 02 7C 3E 48 8D 71 FE 48 8B FE 48 3B F3 72 19 0F B6 0F 48 8D 54 24 20 E8 ?? ?? ?? ?? 85 C0 74 08 48 FF CF 48 3B FB 73 E7 8B C6 2B C7 A8 01 74 11 C6 06 00 E8 ?? ?? ?? ?? BB 2A 00 00 00 89 18 EB 02 33 DB 80 7C 24 38 00 0F 84 6F FE FF FF 48 8B 4C 24 30 83 A1 C8 00 00 00 FD E9 5E FE FF FF }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "_wmakepath_s"
		size = 341
		refs = "0124 _errno 0144 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 33 FF 48 8B D9 48 85 C9 0F 84 1F 01 00 00 48 85 D2 0F 84 16 01 00 00 44 8B DF 4C 8B D1 4D 85 C0 74 27 41 0F B7 00 66 85 C0 74 1E 44 8D 5F 02 49 3B D3 0F 86 DE 00 00 00 66 89 01 4C 8D 51 02 8D 47 3A 66 41 89 02 4D 03 D3 4D 85 C9 74 50 66 41 39 39 74 4A 49 FF C3 4C 3B DA 0F 83 B6 00 00 00 41 0F B7 01 49 83 C1 02 66 41 89 02 49 83 C2 02 66 41 39 39 75 DE 66 41 83 79 FE 2F 74 20 B8 5C 00 00 00 66 41 39 41 FE 74 14 49 FF C3 4C 3B DA 0F 83 80 00 00 00 66 41 89 02 49 83 C2 02 48 8B 4C 24 50 48 85 C9 74 1E EB 17 49 FF C3 4C 3B DA 73 64 0F B7 01 66 41 89 02 49 83 C2 02 48 83 C1 02 66 39 39 75 E4 48 8B 4C 24 58 48 85 C9 74 3D 66 39 39 74 38 B8 2E 00 00 00 66 39 01 74 29 49 FF C3 4C 3B DA 73 2F 66 41 89 02 49 83 C2 02 EB 17 49 FF C3 4C 3B DA 73 1D 0F B7 01 66 41 89 02 49 83 C2 02 48 83 C1 02 66 39 39 75 E4 49 8D 43 01 48 3B C2 76 0F 66 89 3B E8 ?? ?? ?? ?? BB 22 00 00 00 EB 12 66 41 89 3A 33 C0 EB 13 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "catanf"
		size = 106
		refs = "000f crealf 001c cimagf 0026 __xmm@80000000800000008000000080000000 002b _FCbuild 0033 catanhf"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 0F 29 74 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 40 0F 28 F0 E8 ?? ?? ?? ?? 0F 28 CE 0F 57 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B C8 48 89 44 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 40 0F 28 F0 0F 57 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 28 CE E8 ?? ?? ?? ?? 0F 28 74 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "casinf"
		size = 106
		refs = "000f crealf 001c cimagf 0026 __xmm@80000000800000008000000080000000 002b _FCbuild 0033 casinhf"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 0F 29 74 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 40 0F 28 F0 E8 ?? ?? ?? ?? 0F 28 CE 0F 57 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B C8 48 89 44 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 40 0F 28 F0 0F 57 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 28 CE E8 ?? ?? ?? ?? 0F 28 74 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1142_0_0 {
	meta:
		name = "csinf"
		size = 106
		refs = "000f crealf 001c cimagf 0026 __xmm@80000000800000008000000080000000 002b _FCbuild 0033 csinhf"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 0F 29 74 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 40 0F 28 F0 E8 ?? ?? ?? ?? 0F 28 CE 0F 57 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B C8 48 89 44 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 40 0F 28 F0 0F 57 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 28 CE E8 ?? ?? ?? ?? 0F 28 74 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "ctanf"
		size = 106
		refs = "000f crealf 001c cimagf 0026 __xmm@80000000800000008000000080000000 002b _FCbuild 0033 ctanhf"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 0F 29 74 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 40 0F 28 F0 E8 ?? ?? ?? ?? 0F 28 CE 0F 57 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 8B C8 48 89 44 24 40 E8 ?? ?? ?? ?? 48 8B 4C 24 40 0F 28 F0 0F 57 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 28 CE E8 ?? ?? ?? ?? 0F 28 74 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "__security_check_cookie"
		size = 31
		refs = "0003 __security_cookie 001b __report_gsfailure"
	strings:
		$1 = { 48 3B 0D ?? ?? ?? ?? 75 11 48 C1 C1 10 66 F7 C1 FF FF 75 02 F3 C3 48 C1 C9 10 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "_isatty"
		size = 95
		refs = "000a _errno 001c _nhandle 0028 __pioinfo 0054 _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 83 F9 FE 75 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB 42 85 C9 78 2E 3B 0D ?? ?? ?? ?? 73 26 48 63 C9 48 8D 15 ?? ?? ?? ?? 48 8B C1 83 E1 1F 48 C1 F8 05 48 6B C9 58 48 8B 04 C2 0F BE 44 08 08 83 E0 40 EB 12 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_239_2_0 {
	meta:
		name = "_cfltcvt_init"
		size = 134
		refs = "0003 _cropzeros 000a _cfltcvt 0011 _cfltcvt_tab 0018 _fassign 002d _forcdecpt 0042 _positive 0050 _cfltcvt_l 005e _fassign_l 006c _cropzeros_l 007a _forcdecpt_l"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 0D ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 0D ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_240_2_0 {
	meta:
		name = "sinhf"
		size = 726
		refs = "004c _set_statfp 0087 ??_C@_05PJDDOCIG@sinhf?$AA@ 00ae _handle_errorf 00cf __xmm@80000000000000008000000000000000 00d7 __real@40565a9f84f82e63 012d __real@40420fd21b95825f 013b __real@3dcf473de6af278e 0143 __real@3f962e42fe000000 014b __real@40471547652b82fe 0180 __real@3ff0000000000000 0185 splitexp 01d7 __ImageBase 01f4 __real@3d6b4125921ea08b 0200 __real@3de611cb2bdcb7be 020c __real@3e5ae6460fbe61c0 0218 __real@3ec71de3a4e13e7d 0224 __real@3f2a01a01a01ee80 0230 __real@3f811111111110fd 023c __real@3fc5555555555555 024b __real@3da9984b7f63fcd7 0258 ?cosh_lead@?1??sinhf@@9@9 0260 __real@3e21ee56385b7b20 026c __real@3e927e5069f1cb55 0278 __real@3efa01a019079011 0284 __real@3f56c16c16c212e5 0290 __real@3fa5555555555502 029c __real@3fe0000000000000 02b1 ?sinh_lead@?1??sinhf@@9@9"
	strings:
		$1 = { 48 83 EC 68 48 BA FF FF FF FF FF FF FF 7F 0F 29 74 24 50 0F 57 E4 0F 28 F0 F3 0F 5A E6 F2 0F 11 64 24 78 48 8B 4C 24 78 48 8B C1 48 23 C2 48 BA 00 00 00 00 00 00 10 3F 48 3B C2 73 1B 48 85 C0 0F 84 86 02 00 00 B9 20 00 00 00 E8 ?? ?? ?? ?? 0F 28 C6 E9 74 02 00 00 48 BA 00 00 00 00 00 00 F0 7F 48 3B C2 72 56 76 4E C7 44 24 40 01 00 00 00 F3 0F 11 74 24 78 0F 57 C0 44 8B 44 24 78 BA 1F 00 00 00 48 8D 0D ?? ?? ?? ?? F3 0F 11 44 24 38 F3 0F 11 74 24 30 49 0F BA E8 16 C7 44 24 28 21 00 00 00 83 64 24 20 00 44 8D 4A E2 E8 ?? ?? ?? ?? E9 15 02 00 00 F3 0F 58 F6 EB 93 45 33 D2 48 3B C1 41 0F 95 C2 4D 85 D2 74 07 0F 57 25 ?? ?? ?? ?? 66 0F 2F 25 ?? ?? ?? ?? 72 4C C7 44 24 40 01 00 00 00 0F 57 C0 BA 1F 00 00 00 48 8D 0D ?? ?? ?? ?? 44 8D 4A E4 F3 0F 11 44 24 38 F3 0F 11 74 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 01 00 00 00 4D 85 D2 74 08 41 B8 00 00 80 FF EB 8C 41 B8 00 00 80 7F EB 84 66 0F 2F 25 ?? ?? ?? ?? 0F 82 92 00 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 48 8D 84 24 88 00 00 00 48 89 44 24 38 48 8D 84 24 80 00 00 00 48 89 44 24 30 48 8D 44 24 70 0F 28 C4 48 89 44 24 28 F2 0F 11 4C 24 20 F2 0F 10 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 44 8B 4C 24 70 41 FF C9 49 63 C1 44 89 4C 24 70 48 05 FF 03 00 00 48 C1 E0 34 48 89 44 24 78 F2 0F 10 44 24 78 F2 0F 10 94 24 80 00 00 00 F2 0F 58 94 24 88 00 00 00 F2 0F 59 D0 E9 F0 00 00 00 F2 0F 2C C4 66 0F 6E C0 48 63 C8 48 8D 05 ?? ?? ?? ?? F3 0F E6 C0 F2 0F 5C E0 0F 28 CC F2 0F 59 CC 0F 28 D1 0F 28 C1 F2 0F 59 15 ?? ?? ?? ?? F2 0F 59 C4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D0 0F 28 C1 F2 0F 59 05 ?? ?? ?? ?? F2 0F 58 D4 F2 0F 59 94 C8 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 84 C8 ?? ?? ?? ?? F2 0F 58 D0 4D 85 D2 74 07 0F 57 15 ?? ?? ?? ?? 0F 57 C0 F2 0F 5A C2 0F 28 74 24 50 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_240_3_0 {
	meta:
		name = "splitexp"
		size = 295
		refs = "0008 __real@3fe0000000000000 002c __real@0000000000000000 0048 __ImageBase 005f ?two_to_jby32_lead_table@?1??splitexp@@9@9 0068 ?two_to_jby32_trail_table@?1??splitexp@@9@9 00ce __real@3f56c1728d739765 00d6 __real@3f811115b7aa905e 00e2 __real@3fa5555555545d4e 00ee __real@3fc5555555548f7c"
	strings:
		$1 = { 48 83 EC 38 F2 0F 10 2D ?? ?? ?? ?? 0F 29 74 24 20 0F 29 7C 24 10 0F 28 E0 0F 28 F9 0F 28 F0 44 0F 29 04 24 F2 0F 59 E2 66 0F 2F 25 ?? ?? ?? ?? 44 0F 28 C3 76 06 F2 0F 58 E5 EB 04 F2 0F 5C E5 F2 44 0F 2C C4 48 8D 15 ?? ?? ?? ?? 41 8B C8 66 41 0F 6E C0 83 E1 1F 48 63 C1 F2 0F 10 9C C2 ?? ?? ?? ?? F2 0F 10 A4 C2 ?? ?? ?? ?? 41 8B C0 2B C1 48 8B 4C 24 68 99 83 E2 1F F3 0F E6 C0 03 C2 C1 F8 05 41 F7 D8 89 01 48 8B 44 24 70 F2 41 0F 59 C0 44 0F 28 04 24 F2 0F 5C F0 F2 0F 59 F1 66 41 0F 6E C8 F2 0F 11 18 48 8B 44 24 78 F3 0F E6 C9 F2 0F 59 4C 24 60 F2 0F 59 CF 0F 28 7C 24 10 0F 28 C1 F2 0F 58 C6 0F 28 D0 F2 0F 59 15 ?? ?? ?? ?? F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 59 C0 F2 0F 58 D5 F2 0F 59 D0 0F 28 C4 F2 0F 58 C3 F2 0F 58 D1 F2 0F 58 D6 0F 28 74 24 20 F2 0F 59 D0 F2 0F 58 D4 F2 0F 11 10 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "wcstok_s"
		size = 191
		refs = "0013 _errno 001e _invalid_parameter_noinfo"
	strings:
		$1 = { 48 83 EC 28 45 33 DB 4D 8B D0 4C 8B CA 4D 85 C0 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 91 00 00 00 48 85 D2 74 E4 48 85 C9 75 35 49 8B 08 48 85 C9 75 2D EB D5 49 8B D1 66 45 39 19 74 18 45 0F B7 01 66 44 3B C0 74 0E 48 83 C2 02 44 0F B7 02 66 45 85 C0 75 EC 66 44 39 1A 74 0C 48 83 C1 02 0F B7 01 66 85 C0 75 CD 48 8B C1 EB 2B 49 8B D1 66 45 39 19 74 18 45 0F B7 01 66 44 3B 01 74 0E 48 83 C2 02 44 0F B7 02 66 45 85 C0 75 EC 66 44 39 1A 75 0C 48 83 C1 02 66 44 39 19 75 CF EB 08 66 44 89 19 48 83 C1 02 48 3B C1 49 89 0A 49 0F 44 C3 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_246_0_0 {
	meta:
		name = "__getlocaleinfo"
		size = 485
		refs = "0015 __security_cookie 005a __crtGetLocaleInfoA 0067 __imp_GetLastError 0095 _calloc_crt 00e8 free 00fb __security_check_cookie 011f strncpy_s 0157 __crtGetLocaleInfoEx 01e0 _invoke_watson"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 56 41 57 48 81 EC D0 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 C0 00 00 00 48 8B 9C 24 30 01 00 00 41 8B F1 49 8B E8 4C 8B E1 83 FA 01 0F 85 FE 00 00 00 4C 8D 4C 24 40 44 8B C6 48 8B D5 48 8D 7C 24 40 45 33 F6 C7 44 24 20 80 00 00 00 E8 ?? ?? ?? ?? 44 8B F8 85 C0 75 5F FF 15 ?? ?? ?? ?? 83 F8 7A 75 7C 44 21 74 24 20 45 33 C9 44 8B C6 48 8B D5 49 8B CC E8 ?? ?? ?? ?? 4C 63 F8 85 C0 74 5F 41 8D 56 01 49 8B CF E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 4B 4C 8B C8 44 8B C6 48 8B D5 49 8B CC 41 BE 01 00 00 00 44 89 7C 24 20 E8 ?? ?? ?? ?? 44 8B F8 85 C0 74 20 49 63 F7 BA 01 00 00 00 48 8B CE E8 ?? ?? ?? ?? 48 8B C8 48 89 03 48 85 C0 75 32 45 85 F6 74 08 48 8B CF E8 ?? ?? ?? ?? 83 C8 FF 48 8B 8C 24 C0 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 D0 00 00 00 41 5F 41 5E 41 5C 5F 5E 5D 5B C3 41 8D 47 FF 4C 8B C7 48 8B D6 4C 63 C8 E8 ?? ?? ?? ?? 85 C0 0F 85 A4 00 00 00 45 85 F6 74 08 48 8B CF E8 ?? ?? ?? ?? 33 C0 EB B3 41 BE 02 00 00 00 41 3B D6 75 53 48 83 23 00 45 33 C9 45 33 C0 8B D6 48 8B CD E8 ?? ?? ?? ?? 48 63 F8 85 C0 74 27 48 8B CF 41 8B D6 E8 ?? ?? ?? ?? 48 89 03 48 85 C0 74 14 44 8B CF 4C 8B C0 8B D6 48 8B CD E8 ?? ?? ?? ?? 85 C0 75 AF 48 8B 0B E8 ?? ?? ?? ?? 48 83 23 00 E9 52 FF FF FF 85 D2 0F 85 4A FF FF FF 21 54 24 30 0F BA EE 1D 4C 8D 44 24 30 8B D6 45 8B CE 48 8B CD E8 ?? ?? ?? ?? 85 C0 0F 84 28 FF FF FF 8A 44 24 30 88 03 E9 69 FF FF FF 48 83 64 24 20 00 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "_wcsset"
		size = 19
	strings:
		$1 = { 48 8B C1 EB 07 66 89 11 48 8D 49 02 66 83 39 00 75 F3 C3 }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "__remainder_piby2d2f_forC"
		size = 396
		refs = "0022 L__2_by_pi_bits 0172 L__piby2"
	strings:
		$1 = { 48 81 EC 88 00 00 00 48 89 7C 24 20 48 89 74 24 30 48 8B F9 48 8B F2 49 8B D0 66 48 0F 6E C7 4C 8D 0D ?? ?? ?? ?? 66 49 0F 7E C3 49 8B CB 49 C1 EB 34 49 81 EB FF 03 00 00 4D 8B D3 49 C1 EA 03 49 81 EA 86 00 00 00 49 F7 DA 4B 8B 04 0A 48 8B FA 48 C1 E1 0C 48 C1 E9 0C 48 0F BA E9 34 49 83 C2 08 F3 43 0F 6F 04 0A 48 F7 E1 4C 8B C0 4C 8B D2 66 48 0F 7E C0 48 F7 E1 49 83 E3 07 66 0F 73 D8 08 49 03 C2 48 83 D2 00 4C 8B C8 4C 8B D2 66 48 0F 7E C0 48 F7 E1 4C 03 D0 48 C7 C1 36 00 00 00 49 8B C2 49 2B CB 48 33 D2 48 D3 E8 73 21 49 F7 D2 49 F7 D1 49 F7 D0 48 BA 00 00 00 00 00 00 00 80 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 48 83 D0 00 48 83 E0 03 89 07 49 8B CB 48 83 C1 0A 49 D3 E2 49 D3 EA 48 83 E9 40 4C 8B D9 49 0F BD CA 75 1C 4D 8B D1 4D 8B C8 49 0F BD CA 49 83 EB 40 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 4C 03 D9 48 83 E9 34 48 83 F9 00 7C 13 74 31 4D 8B C2 49 D3 EA EB 29 66 0F 1F 84 00 00 00 00 00 48 F7 D9 49 8B C1 49 D3 E2 49 D3 E1 48 83 E9 40 48 F7 D9 48 D3 E8 4C 0B D0 0F 1F 80 00 00 00 00 49 81 C3 FF 03 00 00 49 0F BA F2 34 49 8B CB 4C 0B D2 48 C1 E1 34 4C 0B D1 66 49 0F 6E C2 F2 0F 59 05 ?? ?? ?? ?? F2 0F 11 06 48 8B 74 24 30 48 8B 7C 24 20 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_249_3_0 {
	meta:
		name = "_validate_param_reuseW"
		size = 304
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 7C 24 18 44 0F B7 51 10 8B DA 4C 8B D9 66 41 83 FA 70 0F 84 F1 00 00 00 66 41 83 F8 70 0F 84 E6 00 00 00 41 8D 42 AD BF DF FF 00 00 B9 00 00 00 00 66 85 C7 41 8D 40 AD 8B D1 0F 94 C2 66 85 C7 8B C1 0F 94 C0 85 D2 0F 85 96 00 00 00 85 C0 0F 85 AE 00 00 00 41 8D 42 A8 66 BF 20 00 48 BD 01 10 82 20 01 00 00 00 66 3B C7 77 09 0F B7 C0 48 0F A3 C5 72 12 41 8D 40 A8 66 3B C7 77 60 0F B7 C0 48 0F A3 C5 73 57 66 41 83 EA 58 BA 01 00 00 00 66 44 3B D7 77 0D 41 0F B7 C2 44 8B D2 48 0F A3 C5 72 03 44 8B D1 66 41 83 E8 58 66 44 3B C7 77 0A 41 0F B7 C0 48 0F A3 C5 72 02 8B D1 44 3B D2 74 04 33 C0 EB 4D 41 8B 53 14 8B C2 41 33 C1 0F BA E0 10 72 ED 41 33 D1 40 84 D7 75 E5 41 39 1B EB 2C 3B D0 75 1C 41 8B 43 14 41 C1 E9 05 BA 01 00 00 00 C1 E8 05 41 F7 D1 F7 D0 41 33 C1 84 C2 74 02 8B D1 8B C2 EB 0B 33 C9 66 45 3B D0 0F 94 C1 8B C1 48 8B 5C 24 08 48 8B 6C 24 10 48 8B 7C 24 18 C3 }
	condition:
		$1
}

rule file_249_4_0 {
	meta:
		name = "_woutput_p_l"
		size = 4562
		refs = "0022 __security_cookie 006b ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 007b _errno 0094 _invalid_parameter_noinfo 0162 __lookuptable_s 01c6 wcstol 01f1 memset 03e8 _validate_param_reuseW 0475 __nullstring 047d strlen 0566 _mbtowc_l 06ac _isleadbyte_l 06de __wnullstring 07a0 _get_printf_count_output 0ae0 _malloc_crt 0b40 _cfltcvt_tab 0b4d __imp_DecodePointer 0c43 write_multi_char 0c5f write_string 0cca write_char 0d36 free 1116 get_crtdouble_arg 11b3 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 90 F2 FF FF 48 81 EC 70 0E 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 60 0D 00 00 45 33 ED 48 8B F9 48 89 4D D0 4C 8B F2 48 89 55 F8 48 8D 4C 24 68 49 8B D0 4C 89 4C 24 48 44 89 6D C8 45 8B E5 44 89 6C 24 64 44 89 6D C4 44 89 6C 24 44 41 8B DD 44 89 6D 94 E8 ?? ?? ?? ?? 41 83 CF FF 4C 89 6D B8 41 8B F7 E8 ?? ?? ?? ?? 48 89 45 F0 48 85 FF 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 44 38 6D 80 74 0C 48 8B 4C 24 78 83 A1 C8 00 00 00 FD 41 8B C7 E9 F6 10 00 00 4D 85 F6 75 24 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 44 38 6D 80 74 DD 48 8B 44 24 78 83 A0 C8 00 00 00 FD EB CF 4C 8B 7C 24 48 41 8B C5 45 8B DD 89 44 24 60 44 89 6D B0 41 83 FB 01 75 08 85 F6 0F 84 9A 10 00 00 83 C9 FF 4D 8B CE 45 0F B7 36 44 89 6C 24 58 45 8B D5 4C 89 6D E0 44 89 6D 8C 41 8B FD 44 89 6C 24 50 44 8B C1 89 4C 24 40 44 8B E9 89 4D D8 8B F1 89 4D 88 66 45 85 F6 0F 84 0D 10 00 00 49 63 D3 48 89 55 A0 49 83 C1 02 4C 89 4D 98 85 C0 0F 88 6E 0F 00 00 41 8D 46 E0 B9 58 00 00 00 66 3B C1 77 18 48 8D 0D ?? ?? ?? ?? 41 0F B7 C6 0F B6 4C 08 E0 83 E1 0F 45 33 C0 EB 06 45 33 C0 41 8B C8 48 63 C1 41 BB 01 00 00 00 48 8D 0C C0 49 63 C2 48 03 C8 48 8D 05 ?? ?? ?? ?? 0F B6 04 01 C1 E8 04 89 45 C0 41 3B C3 0F 85 E2 00 00 00 66 41 83 39 25 0F 84 E0 00 00 00 83 FE FF 75 5F 45 8D 43 09 48 8D 55 B8 49 8B C9 E8 ?? ?? ?? ?? 45 33 C0 85 C0 7E 2E 48 8B 45 B8 66 83 38 24 75 24 4C 39 45 A0 75 14 48 8D 8D 00 04 00 00 33 D2 41 B8 60 09 00 00 E8 ?? ?? ?? ?? BE 01 00 00 00 89 75 88 EB 1F 4C 8B 7C 24 48 48 8B 55 A0 4C 8B 4D 98 41 8B F0 44 89 45 88 41 BB 01 00 00 00 41 3B F3 75 77 48 8B 4D 98 48 8D 55 B8 41 B8 0A 00 00 00 E8 ?? ?? ?? ?? 48 8B 4D B8 48 8B 55 A0 44 8B E8 41 BB 01 00 00 00 4C 8D 49 02 45 2B EB 45 33 C0 4C 89 4D 98 44 89 6D D8 48 85 D2 75 2C 45 85 ED 0F 88 92 01 00 00 66 83 39 24 0F 85 88 01 00 00 41 83 FD 64 0F 8D 7E 01 00 00 8B 44 24 40 44 3B E8 41 0F 4F C5 89 44 24 40 4C 8B 7C 24 48 EB 09 83 F8 08 0F 84 5F 01 00 00 8B 4D C0 85 C9 0F 84 CA 0D 00 00 FF C9 0F 84 A0 0D 00 00 FF C9 0F 84 48 0D 00 00 FF C9 0F 84 51 0C 00 00 FF C9 0F 84 3C 0C 00 00 FF C9 0F 84 4E 0B 00 00 FF C9 0F 84 7E 0A 00 00 FF C9 0F 85 C9 0D 00 00 41 0F B7 CE 83 F9 64 0F 8F 16 03 00 00 0F 84 F1 04 00 00 83 F9 41 0F 84 A1 02 00 00 83 F9 43 0F 84 CC 01 00 00 8D 41 BB A9 FD FF FF FF 0F 84 8A 02 00 00 83 F9 53 0F 84 7F 01 00 00 B8 58 00 00 00 3B C8 0F 84 F8 03 00 00 83 F9 5A 74 5E 83 F9 61 0F 84 6F 02 00 00 83 F9 63 0F 84 A5 01 00 00 4C 8B 74 24 58 B9 20 00 00 00 BF 2D 00 00 00 8B 44 24 44 83 7D 88 01 75 0D 48 8B 55 A0 48 85 D2 0F 84 3B 0D 00 00 85 C0 0F 85 C6 09 00 00 41 F6 C4 40 0F 84 AF 08 00 00 41 0F BA E4 08 0F 83 7E 08 00 00 66 89 7D AC E9 84 08 00 00 85 F6 75 12 49 83 C7 08 4C 89 7C 24 48 49 8B 47 F8 E9 90 00 00 00 41 83 FD 63 77 54 49 63 C5 48 8D 0C 40 48 85 D2 75 73 48 8D 85 00 04 00 00 48 8D 04 C8 44 39 00 75 1C C7 00 02 00 00 00 66 44 89 B4 CD 10 04 00 00 44 89 A4 CD 14 04 00 00 E9 60 FF FF FF BA 02 00 00 00 45 0F B7 C6 45 8B CC 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 44 FF FF FF E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C9 38 4D 80 74 0C 48 8B 44 24 78 83 A0 C8 00 00 00 FD 83 C8 FF E9 89 0D 00 00 48 8B 84 CD 08 04 00 00 48 8B 00 48 85 C0 74 43 48 8B 58 08 48 85 DB 74 3A B9 20 00 00 00 8D 79 0D 41 0F BA E4 0B 73 19 0F BF 00 44 89 5D 94 99 2B C2 D1 F8 44 8B F0 4C 89 74 24 58 E9 E7 FE FF FF 44 0F BF 30 44 89 45 94 4C 89 74 24 58 E9 D5 FE FF FF 48 8B 1D ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 4C 8B F0 48 89 44 24 58 4C 8B 7C 24 48 E9 AA FE FF FF 41 F7 C4 30 08 00 00 75 04 41 83 CC 20 83 FF FF 8B F7 B8 FF FF FF 7F 0F 44 F0 44 39 45 88 0F 85 96 01 00 00 49 83 C7 08 4C 89 7C 24 48 49 8B 5F F8 E9 A9 01 00 00 41 B9 20 00 00 00 41 F7 C4 30 08 00 00 75 0B 45 0B E1 EB 06 41 B9 20 00 00 00 44 89 5D 94 85 F6 75 10 49 83 C7 08 4C 89 7C 24 48 41 0F B7 47 F8 EB 41 41 83 FD 63 0F 87 EF FE FF FF 49 63 C5 48 8D 0C 40 48 85 D2 75 20 48 8D 85 00 04 00 00 48 8D 04 C8 44 39 00 75 08 44 89 18 E9 99 FE FF FF 41 8B D3 E9 AC FE FF FF 48 8B 84 CD 08 04 00 00 0F B7 00 66 89 45 90 45 84 E1 74 3B 88 45 A8 48 8B 44 24 68 44 88 45 A9 4C 63 80 D4 00 00 00 4C 8D 4C 24 68 48 8D 55 A8 48 8D 4D 00 E8 ?? ?? ?? ?? 4C 8B 7C 24 48 41 BB 01 00 00 00 85 C0 79 0B 44 89 5C 24 44 EB 04 66 89 45 00 48 8D 5D 00 45 8B F3 4C 89 74 24 58 E9 A8 FD FF FF 44 89 5D C4 66 41 83 C6 20 41 BA 67 00 00 00 41 83 CC 40 41 3B F3 0F 85 EC 04 00 00 48 85 D2 0F 85 E3 04 00 00 41 83 FD 63 0F 87 30 FE FF FF 49 63 C5 48 8D 0C 40 48 8D 85 00 04 00 00 48 8D 04 C8 44 39 00 0F 85 96 04 00 00 C7 00 07 00 00 00 66 44 89 B4 CD 10 04 00 00 44 89 A4 CD 14 04 00 00 E9 A6 0A 00 00 41 BA 67 00 00 00 41 3B CA 7E 9E 83 F9 69 0F 84 CD 01 00 00 83 F9 6E 0F 84 4F 01 00 00 83 F9 6F 0F 84 2D 01 00 00 83 F9 70 0F 84 E1 00 00 00 83 F9 73 0F 84 6D FE FF FF 83 F9 75 0F 84 A4 01 00 00 83 F9 78 0F 85 F3 FC FF FF 8D 41 AF E9 D1 00 00 00 41 83 FD 63 0F 87 9D FD FF FF 49 63 C5 48 8D 0C 40 48 85 D2 0F 84 45 FD FF FF 48 8B 9C CD 08 04 00 00 48 8B 1B B9 20 00 00 00 44 84 E1 74 57 48 85 DB 45 8B F0 48 0F 44 1D ?? ?? ?? ?? 4C 89 74 24 58 48 8B FB 85 F6 0F 8E A8 FC FF FF 44 38 07 0F 84 E6 FD FF FF 0F B6 0F 48 8D 54 24 68 E8 ?? ?? ?? ?? 45 33 C0 45 8D 58 01 85 C0 74 03 49 03 FB 45 03 F3 49 03 FB 4C 89 74 24 58 44 3B F6 7C CC E9 B6 FD FF FF 48 85 DB 44 89 5D 94 48 0F 44 1D ?? ?? ?? ?? 48 8B C3 EB 0D 41 2B F3 66 44 39 00 74 08 48 83 C0 02 85 F6 75 EF 48 2B C3 48 D1 F8 44 8B F0 4C 89 74 24 58 E9 37 FC FF FF BF 10 00 00 00 41 0F BA EC 0F 89 7C 24 50 B8 07 00 00 00 89 45 C8 41 B9 10 00 00 00 45 84 E4 0F 89 B6 00 00 00 41 8D 49 20 45 8D 51 F2 66 83 C0 51 66 89 4D AC 44 89 54 24 64 66 89 45 AE E9 9D 00 00 00 41 B9 08 00 00 00 45 84 E4 0F 89 89 00 00 00 B8 00 02 00 00 44 0B E0 EB 7F 85 F6 75 0F 49 83 C7 08 4C 89 7C 24 48 49 8B 7F F8 EB 25 41 83 FD 63 0F 87 70 FC FF FF 49 63 C5 48 8D 0C 40 48 85 D2 0F 84 18 FC FF FF 48 8B 84 CD 08 04 00 00 48 8B 38 E8 ?? ?? ?? ?? 85 C0 0F 84 48 FC FF FF 8B 44 24 60 B9 20 00 00 00 44 84 E1 74 05 66 89 07 EB 02 89 07 4C 8B 7C 24 48 4C 8B 74 24 58 B8 01 00 00 00 8D 78 2C 89 44 24 44 E9 6F FB FF FF 41 83 CC 40 41 B9 0A 00 00 00 44 8B 54 24 64 41 0F BA E4 0F 73 51 85 F6 75 12 49 83 C7 08 4C 89 7C 24 48 4D 8B 47 F8 E9 9E 01 00 00 41 83 FD 63 0F 87 E2 FB FF FF 49 63 C5 48 8D 0C 40 48 85 D2 75 6B 48 8D 85 00 04 00 00 48 8D 04 C8 44 39 00 75 0B C7 00 03 00 00 00 E9 89 FB FF FF BA 03 00 00 00 E9 9A FB FF FF 41 0F BA E4 0C 73 4F 85 F6 74 A8 41 83 FD 63 0F 87 9C FB FF FF 49 63 C5 48 8D 0C 40 48 85 D2 75 25 48 8D 85 00 04 00 00 48 8D 04 C8 44 39 00 75 0B C7 00 04 00 00 00 E9 43 FB FF FF BA 04 00 00 00 E9 54 FB FF FF 48 8B 84 CD 08 04 00 00 4C 8B 00 E9 0D 01 00 00 B8 20 00 00 00 44 84 E0 0F 84 87 00 00 00 41 F6 C4 40 74 42 85 F6 75 13 49 83 C7 08 4C 89 7C 24 48 4D 0F BF 47 F8 E9 E2 00 00 00 41 83 FD 63 0F 87 26 FB FF FF 49 63 C5 48 8D 0C 40 48 85 D2 0F 84 33 FC FF FF 48 8B 84 CD 08 04 00 00 4C 0F BF 00 E9 B7 00 00 00 85 F6 75 13 49 83 C7 08 4C 89 7C 24 48 45 0F B7 47 F8 E9 A0 00 00 00 41 83 FD 63 0F 87 E4 FA FF FF 49 63 C5 48 8D 0C 40 48 85 D2 0F 84 F1 FB FF FF 48 8B 84 CD 08 04 00 00 44 0F B7 00 EB 78 41 F6 C4 40 74 3A 85 F6 75 0F 49 83 C7 08 4C 89 7C 24 48 4D 63 47 F8 EB 5F 41 83 FD 63 0F 87 A3 FA FF FF 49 63 C5 48 8D 0C 40 48 85 D2 0F 84 B0 FB FF FF 48 8B 84 CD 08 04 00 00 4C 63 00 EB 38 85 F6 75 0F 49 83 C7 08 4C 89 7C 24 48 45 8B 47 F8 EB 25 41 83 FD 63 0F 87 69 FA FF FF 49 63 C5 48 8D 0C 40 48 85 D2 0F 84 76 FB FF FF 48 8B 84 CD 08 04 00 00 44 8B 00 41 F6 C4 40 74 0D 4D 85 C0 79 08 49 F7 D8 41 0F BA EC 08 41 0F BA E4 0F 72 0A 41 0F BA E4 0C 72 03 45 8B C0 85 FF 79 05 41 8B FB EB 0E BA 00 02 00 00 41 83 E4 F7 3B FA 0F 4F FA 44 8B 6D C8 49 8B C0 48 8D 9D FF 01 00 00 48 F7 D8 1B C9 41 23 CA 89 4C 24 64 8B CF 41 2B FB 85 C9 7F 05 4D 85 C0 74 20 33 D2 49 8B C0 49 63 C9 48 F7 F1 4C 8B C0 8D 42 30 83 F8 39 7E 03 41 03 C5 88 03 49 2B DB EB D2 4C 8B 7C 24 48 44 8B 6D D8 4C 8D B5 FF 01 00 00 44 2B F3 B8 00 02 00 00 49 03 DB 4C 89 74 24 58 89 7C 24 50 44 85 E0 0F 84 E7 F8 FF FF B8 30 00 00 00 45 85 F6 74 08 38 03 0F 84 D5 F8 FF FF 49 2B DB 45 03 F3 88 03 E9 16 FB FF FF 45 8B CC 45 0F B7 C6 BA 07 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 45 33 F6 85 C0 0F 84 D0 06 00 00 48 8B 55 A0 E9 00 06 00 00 B8 00 02 00 00 48 8D 5D 00 8B F0 85 FF 79 0A C7 44 24 50 06 00 00 00 EB 4E 75 0D 66 45 3B F2 75 46 44 89 5C 24 50 EB 3F 3B F8 0F 4F F8 89 7C 24 50 81 FF A3 00 00 00 7E 2E 81 C7 5D 01 00 00 48 63 CF E8 ?? ?? ?? ?? 4C 8B 7C 24 48 45 33 C0 48 89 45 E0 48 85 C0 74 07 48 8B D8 8B F7 EB 08 C7 44 24 50 A3 00 00 00 44 39 45 88 75 13 49 83 C7 08 4C 89 7C 24 48 49 8B 47 F8 48 89 45 E8 EB 20 41 83 FD 63 0F 87 CD F8 FF FF 49 63 C5 48 8D 0C 40 48 8B 84 CD 08 04 00 00 48 8B 08 48 89 4D E8 48 8B 0D ?? ?? ?? ?? 41 0F BE FE 48 63 F6 FF 15 ?? ?? ?? ?? 44 8B 7C 24 50 48 8D 4C 24 68 48 89 4C 24 30 8B 4D C4 44 8B CF 89 4C 24 28 48 8D 4D E8 4C 8B C6 48 8B D3 44 89 7C 24 20 FF D0 41 8B FC 81 E7 80 00 00 00 74 1C 45 85 FF 75 17 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 54 24 68 48 8B CB FF D0 B9 67 00 00 00 66 44 3B F1 75 1B 85 FF 75 17 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 54 24 68 48 8B CB FF D0 BF 2D 00 00 00 40 38 3B 75 08 41 0F BA EC 08 48 FF C3 48 8B CB E8 ?? ?? ?? ?? 4C 8B 7C 24 48 B9 20 00 00 00 44 8B F0 4C 89 74 24 58 E9 4E F7 FF FF 41 F6 C4 01 74 14 B8 2B 00 00 00 66 89 45 AC BE 01 00 00 00 89 74 24 64 EB 10 41 F6 C4 02 74 06 66 89 4D AC EB E9 8B 74 24 64 44 8B 7D 8C 48 8B 7D D0 45 2B FE 44 2B FE 41 F6 C4 0C 75 10 4C 8D 4C 24 60 4C 8B C7 41 8B D7 E8 ?? ?? ?? ?? 48 8B 45 F0 4C 8D 4C 24 60 48 8D 4D AC 4C 8B C7 8B D6 48 89 44 24 20 E8 ?? ?? ?? ?? 41 F6 C4 08 74 1B 41 F6 C4 04 75 15 4C 8D 4C 24 60 B9 30 00 00 00 4C 8B C7 41 8B D7 E8 ?? ?? ?? ?? 33 C0 39 45 94 75 5D 45 85 F6 7E 58 48 8B FB 41 8B F6 48 8B 44 24 68 4C 8D 4C 24 68 48 8D 4D 90 4C 63 80 D4 00 00 00 48 8B D7 FF CE E8 ?? ?? ?? ?? 4C 63 F0 85 C0 7E 1F 48 8B 55 D0 0F B7 4D 90 4C 8D 44 24 60 E8 ?? ?? ?? ?? 49 03 FE 85 F6 7F C1 48 8B 7D D0 EB 29 48 8B 7D D0 83 C8 FF 89 44 24 60 EB 20 48 8B 45 F0 4C 8D 4C 24 60 4C 8B C7 41 8B D6 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 8B 44 24 60 85 C0 78 1B 41 F6 C4 04 74 15 4C 8D 4C 24 60 B9 20 00 00 00 4C 8B C7 41 8B D7 E8 ?? ?? ?? ?? 4C 8B 7C 24 48 48 8B 4D E0 48 85 C9 74 10 E8 ?? ?? ?? ?? 4C 8B 7C 24 48 33 C9 48 89 4D E0 8B 7C 24 50 E9 46 FD FF FF 41 0F B7 C6 83 F8 49 74 4C 83 F8 68 74 3E B9 6C 00 00 00 3B C1 74 13 83 F8 77 0F 85 33 03 00 00 41 0F BA EC 0B E9 29 03 00 00 44 8B 44 24 40 66 41 39 09 75 0E 49 83 C1 02 41 0F BA EC 0C E9 15 03 00 00 41 83 CC 10 E9 0C 03 00 00 41 83 CC 20 E9 FE 02 00 00 41 0F B7 01 B9 00 80 00 00 44 0B E1 66 83 F8 36 75 14 66 41 83 79 02 34 75 0C 49 83 C1 04 44 0B E1 E9 D8 02 00 00 66 83 F8 33 75 16 66 41 83 79 02 32 75 0E 49 83 C1 04 41 0F BA F4 0F E9 BC 02 00 00 66 83 E8 58 B9 20 00 00 00 66 3B C1 77 1A 48 B9 01 10 82 20 01 00 00 00 48 0F A3 C1 73 0A 41 0F BA EC 10 E9 94 02 00 00 44 89 45 C0 E9 68 02 00 00 B8 2A 00 00 00 66 44 3B F0 0F 85 C1 00 00 00 85 F6 75 0F 49 83 C7 08 4C 89 7C 24 48 41 8B 7F F8 EB 49 48 8D 55 B8 41 B8 0A 00 00 00 49 8B C9 E8 ?? ?? ?? ?? 48 8B 4D B8 48 8B 55 A0 4C 8D 49 02 41 BB 01 00 00 00 41 2B C3 4C 89 4D 98 48 85 D2 0F 84 F2 00 00 00 4C 8B 7C 24 48 48 98 48 8D 0C 40 48 8B 84 CD 08 04 00 00 8B 38 44 8B 44 24 40 89 7C 24 50 85 FF 0F 89 14 02 00 00 83 CF FF 89 7C 24 50 E9 08 02 00 00 4C 8B 7C 24 48 44 89 18 B8 2A 00 00 00 66 89 84 CD 10 04 00 00 44 89 A4 CD 14 04 00 00 E9 E6 01 00 00 45 8B CC 41 B8 2A 00 00 00 41 8B D3 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 84 88 02 00 00 4C 8B 7C 24 48 E9 AE FB FF FF 8D 3C BF 41 0F B7 C6 8D 7F E8 8D 3C 78 89 7C 24 50 E9 A5 01 00 00 41 8B F8 44 89 44 24 50 E9 98 01 00 00 B8 2A 00 00 00 66 44 3B F0 0F 85 C8 00 00 00 85 F6 75 12 49 83 C7 08 4C 89 7C 24 48 41 8B 4F F8 E9 94 00 00 00 48 8D 55 B8 41 B8 0A 00 00 00 49 8B C9 E8 ?? ?? ?? ?? 48 8B 4D B8 48 8B 55 A0 4C 8D 49 02 41 BB 01 00 00 00 41 2B C3 4C 89 4D 98 48 85 D2 75 4F 85 C0 0F 88 8E F4 FF FF 66 83 39 24 0F 85 84 F4 FF FF 41 83 FD 64 0F 8D 7A F4 FF FF 44 8B 44 24 40 41 3B C0 44 0F 4F C0 48 98 45 33 F6 48 8D 0C 40 48 8D 85 00 04 00 00 44 89 44 24 40 48 8D 04 C8 44 39 30 0F 84 F6 FE FF FF E9 13 FF FF FF 4C 8B 7C 24 48 48 98 48 8D 0C 40 48 8B 84 CD 08 04 00 00 8B 08 44 8B 44 24 40 89 4D 8C 85 C9 0F 89 D4 00 00 00 41 83 CC 04 F7 D9 89 4D 8C E9 C6 00 00 00 8B 45 8C 8D 0C 80 41 0F B7 C6 8D 49 E8 8D 0C 48 89 4D 8C E9 A9 00 00 00 41 0F B7 C6 B9 20 00 00 }
	condition:
		$1
}

rule file_249_7_0 {
	meta:
		name = "write_char"
		size = 55
		refs = "001c _fputwc_nolock"
	strings:
		$1 = { 40 53 48 83 EC 20 F6 42 18 40 49 8B D8 74 0C 48 83 7A 10 00 75 05 41 FF 00 EB 16 E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 75 05 83 0B FF EB 02 FF 03 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_249_8_0 {
	meta:
		name = "write_multi_char"
		size = 81
		refs = "002f write_char"
	strings:
		$1 = { 85 D2 7E 4C 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 49 8B F9 49 8B F0 8B DA 0F B7 E9 4C 8B C7 48 8B D6 0F B7 CD FF CB E8 ?? ?? ?? ?? 83 3F FF 74 04 85 DB 7F E7 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_249_9_0 {
	meta:
		name = "write_string"
		size = 153
		refs = "0052 write_char"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 20 41 F6 40 18 40 48 8B 5C 24 60 49 8B F9 44 8B 3B 49 8B E8 8B F2 4C 8B F1 74 0C 49 83 78 10 00 75 05 41 01 11 EB 42 83 23 00 85 D2 7E 38 41 0F B7 0E 4C 8B C7 48 8B D5 FF CE E8 ?? ?? ?? ?? 83 3F FF 4D 8D 76 02 75 15 83 3B 2A 75 14 B9 3F 00 00 00 4C 8B C7 48 8B D5 E8 ?? ?? ?? ?? 85 F6 7F CD 83 3B 00 75 03 44 89 3B 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_251_0_0 {
	meta:
		name = "IsRootUNCName"
		size = 188
		refs = "000a wcslen"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 83 F8 05 0F 82 9C 00 00 00 66 41 B9 5C 00 66 41 B8 2F 00 66 44 39 0B 74 0A 66 44 39 03 0F 85 82 00 00 00 66 44 39 4B 02 74 07 66 44 39 43 02 75 74 66 44 39 4B 04 74 6D 66 44 39 43 04 74 66 48 8D 43 06 33 D2 0F B7 08 66 85 C9 74 58 66 41 3B C9 74 12 66 41 3B C8 74 0C 48 83 C0 02 0F B7 08 66 85 C9 75 E8 66 39 10 74 3B 48 83 C0 02 66 39 10 74 32 0F B7 08 66 85 C9 74 23 66 41 3B C9 74 12 66 41 3B C8 74 0C 48 83 C0 02 0F B7 08 66 85 C9 75 E8 66 39 10 74 06 66 39 50 02 75 07 B8 01 00 00 00 EB 02 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_251_1_0 {
	meta:
		name = "_wfullpath_helper"
		size = 150
		refs = "0026 _errno 003e _wfullpath"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 4D 8B F1 49 8B D8 48 8B EA 48 8B F9 E8 ?? ?? ?? ?? 8B 30 E8 ?? ?? ?? ?? 4C 8B C3 83 20 00 48 8B D5 48 8B CF E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 0C E8 ?? ?? ?? ?? 89 30 48 8B C3 EB 25 E8 ?? ?? ?? ?? 83 38 22 74 04 33 C0 EB 17 E8 ?? ?? ?? ?? 45 33 C0 48 8B D5 33 C9 89 30 E8 ?? ?? ?? ?? 49 89 06 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_251_2_0 {
	meta:
		name = "_wstat64i32"
		size = 1165
		refs = "0022 __security_cookie 0042 __doserrno 004a _errno 0055 _invalid_parameter_noinfo 006a ??_C@_15HEJOKEHO@?$AA?$DP?$AA?$CK?$AA?$AA@ 006f wcspbrk 00a4 towlower 00b3 _getdrive 00d3 __imp_FindFirstFileExW 00ea ??_C@_17BAAFHAL@?$AA?4?$AA?1?$AA?2?$AA?$AA@ 0123 _wfullpath 0172 wcslen 0180 IsRootUNCName 018d __imp_GetDriveTypeW 01a5 free 01d8 __loctotime64_t 0251 _wsopen_s 0265 _fstat64i32 0270 _close 0299 __imp_FileTimeToSystemTime 02b3 __imp_SystemTimeToTzSpecificLocalTime 03f5 __imp_FindClose 0401 __wdtoxmode 044d __imp_GetLastError 0454 _dosmaperr 046e __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 30 FC FF FF 48 81 EC D0 04 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 C0 03 00 00 45 33 E4 48 8B FA 48 8B F1 45 8B FC 48 85 C9 75 21 E8 ?? ?? ?? ?? 44 89 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF E9 01 04 00 00 48 85 D2 74 DA 48 8D 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 74 15 E8 ?? ?? ?? ?? BF 02 00 00 00 89 38 E8 ?? ?? ?? ?? 89 38 EB CC 66 83 7E 02 3A 75 1E 0F B7 0E 66 85 C9 74 07 66 44 39 66 04 74 D5 E8 ?? ?? ?? ?? 44 0F B7 E8 41 83 ED 60 EB 08 E8 ?? ?? ?? ?? 44 8B E8 4C 8D 44 24 60 45 33 C9 33 D2 48 8B CE 44 89 64 24 28 4C 89 64 24 20 FF 15 ?? ?? ?? ?? 48 83 CB FF 4C 8B F0 48 3B C3 0F 85 2E 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8B CE 4D 8B F4 E8 ?? ?? ?? ?? 48 85 C0 0F 84 FB 00 00 00 E8 ?? ?? ?? ?? 44 8B 20 E8 ?? ?? ?? ?? 48 8D 8D B0 01 00 00 44 21 30 41 B8 04 01 00 00 48 8B D6 E8 ?? ?? ?? ?? 4C 8B F8 48 85 C0 74 0A E8 ?? ?? ?? ?? 44 89 20 EB 29 E8 ?? ?? ?? ?? 83 38 22 0F 85 B6 00 00 00 E8 ?? ?? ?? ?? 45 33 C0 48 8B D6 33 C9 44 89 20 E8 ?? ?? ?? ?? 4C 8B F0 4C 8B F8 45 33 E4 4D 85 FF 0F 84 82 00 00 00 49 8B CF E8 ?? ?? ?? ?? 48 83 F8 03 74 0C 49 8B CF E8 ?? ?? ?? ?? 85 C0 74 68 49 8B CF FF 15 ?? ?? ?? ?? 41 BF 01 00 00 00 41 3B C7 76 54 4D 85 F6 74 08 49 8B CE E8 ?? ?? ?? ?? 89 5C 24 30 45 33 C9 45 8B C7 41 8B D7 B9 BC 07 00 00 44 89 64 24 28 C7 44 24 60 10 00 00 00 4C 89 64 24 7C 66 44 89 65 8C 44 89 64 24 20 E8 ?? ?? ?? ?? 45 8B FC 48 89 47 20 48 89 47 18 48 89 47 28 E9 09 02 00 00 4D 85 F6 74 08 49 8B CE E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? BF 02 00 00 00 89 38 E8 ?? ?? ?? ?? 89 38 E9 4C 02 00 00 F7 44 24 60 00 04 00 00 74 5A 81 7D 84 0C 00 00 A0 75 51 F6 44 24 60 10 45 8B C4 B8 00 20 00 00 48 8D 4C 24 40 41 B9 40 00 00 00 48 8B D6 44 0F 45 C0 89 5C 24 40 44 89 64 24 20 E8 ?? ?? ?? ?? 85 C0 75 A4 8B 4C 24 40 3B CB 74 9C 48 8B D7 E8 ?? ?? ?? ?? 8B 4C 24 40 8B D8 E8 ?? ?? ?? ?? E9 DF 01 00 00 44 39 64 24 74 75 0D 44 39 64 24 78 75 06 4C 89 67 20 EB 69 48 8D 54 24 48 48 8D 4C 24 74 FF 15 ?? ?? ?? ?? 85 C0 0F 84 A6 01 00 00 4C 8D 44 24 48 48 8D 54 24 48 33 C9 FF 15 ?? ?? ?? ?? 85 C0 0F 84 8C 01 00 00 0F B7 44 24 54 44 0F B7 54 24 52 44 0F B7 4C 24 50 44 0F B7 44 24 4E 0F B7 54 24 4A 0F B7 4C 24 48 89 5C 24 30 89 44 24 28 44 89 54 24 20 E8 ?? ?? ?? ?? 48 89 47 20 44 39 64 24 6C 75 0D 44 39 64 24 70 75 06 48 8B 47 20 EB 65 48 8D 54 24 48 48 8D 4C 24 6C FF 15 ?? ?? ?? ?? 85 C0 0F 84 29 01 00 00 4C 8D 44 24 48 48 8D 54 24 48 33 C9 FF 15 ?? ?? ?? ?? 85 C0 0F 84 0F 01 00 00 0F B7 44 24 54 44 0F B7 54 24 52 44 0F B7 4C 24 50 44 0F B7 44 24 4E 0F B7 54 24 4A 0F B7 4C 24 48 89 5C 24 30 89 44 24 28 44 89 54 24 20 E8 ?? ?? ?? ?? 48 89 47 18 44 39 64 24 64 75 0D 44 39 64 24 68 75 06 48 8B 47 20 EB 65 48 8D 54 24 48 48 8D 4C 24 64 FF 15 ?? ?? ?? ?? 85 C0 0F 84 AC 00 00 00 4C 8D 44 24 48 48 8D 54 24 48 33 C9 FF 15 ?? ?? ?? ?? 85 C0 0F 84 92 00 00 00 0F B7 44 24 54 44 0F B7 54 24 52 44 0F B7 4C 24 50 44 0F B7 44 24 4E 0F B7 54 24 4A 0F B7 4C 24 48 89 5C 24 30 89 44 24 28 44 89 54 24 20 E8 ?? ?? ?? ?? 49 8B CE 48 89 47 28 FF 15 ?? ?? ?? ?? 8B 4C 24 60 48 8B D6 E8 ?? ?? ?? ?? 66 89 47 06 B8 01 00 00 00 66 89 47 08 8B 45 80 89 47 14 44 39 64 24 7C 74 12 E8 ?? ?? ?? ?? 44 8B FB C7 00 84 00 00 00 44 89 67 14 41 8D 4D FF 66 44 89 67 04 C7 47 0A 00 00 00 00 89 0F 89 4F 10 41 8B C7 EB 18 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 49 8B CE FF 15 ?? ?? ?? ?? 8B C3 48 8B 8D C0 03 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 20 05 00 00 48 81 C4 D0 04 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_253_0_0 {
	meta:
		name = "_RTC_AllocaHelper"
		size = 53
	strings:
		$1 = { 48 89 7C 24 08 4C 8B C9 48 85 C9 74 22 48 85 D2 74 1D 4D 85 C0 74 18 48 8B F9 B0 CC 48 8B CA F3 AA 49 8B 00 49 89 51 0C 49 89 41 04 4D 89 08 48 8B 7C 24 08 C3 }
	condition:
		$1
}

rule file_253_1_0 {
	meta:
		name = "_RTC_CheckStackVars"
		size = 115
		refs = "0050 ?_RTC_StackFailure@@YAXPEAXPEBD@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 33 DB 48 8B F2 48 8B E9 39 1A 7E 3E 8B FB 48 8B 56 08 48 63 0C 3A 81 7C 29 FC CC CC CC CC 75 11 48 63 44 3A 04 48 03 C1 81 3C 28 CC CC CC CC 74 0F 48 8B 4C 24 28 48 8B 54 3A 08 E8 ?? ?? ?? ?? FF C3 48 83 C7 10 3B 1E 7C C4 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_253_2_0 {
	meta:
		name = "_RTC_CheckStackVars2"
		size = 231
		refs = "005c ?_RTC_StackFailure@@YAXPEAXPEBD@Z 00a4 ?_RTC_AllocaFailure@@YAXPEAXPEAU_RTC_ALLOCA_NODE@@H@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 20 49 8B D8 48 8B F2 4C 8B F1 41 BF CC CC CC CC 48 85 D2 74 3E 33 ED 39 2A 7E 38 33 FF 48 8B 56 08 48 63 0C 3A 46 39 7C 31 FC 75 0E 48 63 44 3A 04 48 03 C1 46 39 3C 30 74 0F 48 8B 4C 24 38 48 8B 54 3A 08 E8 ?? ?? ?? ?? FF C5 48 83 C7 10 3B 2E 7C CA 33 FF 48 8B C3 48 85 DB 74 5A 48 8B 40 04 FF C7 48 85 C0 75 F5 EB 48 44 39 3B 75 12 44 39 7B 14 75 0C 44 39 7B 18 75 06 44 39 7B 1C 74 10 48 8B 4C 24 38 44 8B C7 48 8B D3 E8 ?? ?? ?? ?? 48 8B 43 0C 44 39 7C 18 FC 74 10 48 8B 4C 24 38 44 8B C7 48 8B D3 E8 ?? ?? ?? ?? 48 8B 5B 04 FF CF 48 85 DB 75 B3 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_254_0_0 {
	meta:
		name = "__vdecl_floor2"
		size = 18
		refs = "0002 __isa_available 0009 __sse4_floor2 000e __sse2_floor2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_640_0_0 {
	meta:
		name = "__vdecl_ceil2"
		size = 18
		refs = "0002 __isa_available 0009 __sse4_ceil2 000e __sse2_ceil2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1220_0_0 {
	meta:
		name = "__vdecl_ceilf4"
		size = 18
		refs = "0002 __isa_available 0009 __sse4_ceilf4 000e __sse2_ceilf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_320_0_0 {
	meta:
		name = "__vdecl_exp2"
		size = 18
		refs = "0002 __isa_available 0009 __sse4_exp2 000e __sse2_exp2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_349_0_0 {
	meta:
		name = "__vdecl_expf4"
		size = 18
		refs = "0002 __isa_available 0009 __sse4_expf4 000e __sse2_expf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_456_0_0 {
	meta:
		name = "__vdecl_floorf4"
		size = 18
		refs = "0002 __isa_available 0009 __sse4_floorf4 000e __sse2_floorf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_257_4_0 {
	meta:
		name = "_ismbcgraph_l"
		size = 209
		refs = "0019 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0064 __crtGetStringTypeA"
	strings:
		$1 = { 48 89 5C 24 10 48 89 7C 24 20 55 48 8B EC 48 83 EC 60 8B D9 48 8D 4D E0 E8 ?? ?? ?? ?? 33 FF 81 FB FF 00 00 00 76 5A 8B C3 89 7D 20 88 5D 11 C1 E8 08 88 45 10 48 8B 45 E8 39 78 08 74 3F 8B 40 04 8D 5F 01 44 8D 4F 02 89 5C 24 30 89 44 24 28 48 8D 45 20 4C 8D 45 10 48 8D 4D E0 8B D3 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 74 11 66 39 7D 22 75 0B B8 17 01 00 00 66 85 45 20 75 2F 8B DF EB 2B 48 8B 45 E0 0F B6 D3 48 8B 88 08 01 00 00 B8 17 01 00 00 66 85 04 51 75 0D 48 8B 45 E8 8B DF F6 44 02 19 03 74 05 BB 01 00 00 00 40 38 7D F8 74 0B 48 8B 4D F0 83 A1 C8 00 00 00 FD 4C 8D 5C 24 60 8B C3 49 8B 5B 18 49 8B 7B 28 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_258_5_0 {
	meta:
		name = "vprintf_helper"
		size = 167
		refs = "0026 __iob_func 0040 _errno 004b _invalid_parameter_noinfo 0058 _lock_file 0061 _stbuf 007e _ftbuf 0087 _unlock_file"
		altNames = "vwprintf_helper"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 18 48 89 7C 24 20 41 54 41 56 41 57 48 83 EC 20 4D 8B F1 4D 8B F8 48 8B F2 4C 8B E1 E8 ?? ?? ?? ?? 48 8D 78 30 48 89 7C 24 48 33 C0 48 85 F6 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 39 48 8B CF E8 ?? ?? ?? ?? 90 48 8B CF E8 ?? ?? ?? ?? 8B D8 4D 8B CE 4D 8B C7 48 8B D6 48 8B CF 41 FF D4 8B F0 48 8B D7 8B CB E8 ?? ?? ?? ?? 90 48 8B CF E8 ?? ?? ?? ?? 8B C6 48 8B 5C 24 40 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 20 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_259_0_0 {
	meta:
		name = "_fdpow"
		size = 1612
		refs = "003a __security_cookie 006b _fdunscale 007a _fd_int 00c1 __real@3f000000 00d2 __real@bf000000 00de __real@3f800000 0110 _fperrraise 0118 _FNan_C 0133 __xmm@80000000800000008000000080000000 015c __real@3f3504f3 0169 __real@40000000 01a0 _fdlogpoly 01b3 __real@3f317218 01fb __real@c7000000 0216 __real@c1400000 0220 __real@41400000 022d __real@c2200000 0237 __real@42200000 028a __real@47000000 02a3 _fdxp_setw 02c9 _fdxp_addx 02ee log2e 02fa memcpy 030a _fdxp_mulh 0378 _fdxp_addh 0448 _fdxp_getw 047b _fdexp 0499 _FInf_C 0541 __security_check_cookie 0599 _FZero_C"
	strings:
		$1 = { 48 8B C4 48 89 58 20 55 56 57 41 54 41 55 41 56 41 57 48 8D 68 A1 48 81 EC E0 00 00 00 0F 29 70 B8 0F 29 78 A8 44 0F 29 40 98 44 0F 29 48 88 44 0F 29 A0 78 FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 C7 44 0F 28 C9 48 8D 54 24 20 48 8D 4C 24 28 F3 0F 11 44 24 20 4D 8B F8 F3 44 0F 11 4C 24 38 F3 44 0F 11 4C 24 30 E8 ?? ?? ?? ?? 48 8D 4C 24 30 33 D2 0F B7 F8 E8 ?? ?? ?? ?? 45 33 ED 0F B7 F0 4D 85 FF 74 04 66 45 89 2F 45 0F 57 C0 66 85 F6 75 08 45 0F 2E C8 7A 02 74 3C 0F B7 44 24 28 F3 0F 10 4C 24 20 41 BE 01 00 00 00 66 85 FF 0F 89 13 04 00 00 66 41 3B C6 75 29 0F 2E 0D ?? ?? ?? ?? 7A 02 74 11 66 41 3B F6 75 18 0F 2E 0D ?? ?? ?? ?? 7A 0F 75 0D F3 0F 10 05 ?? ?? ?? ?? E9 52 04 00 00 66 44 3B EF 0F 8E DA 03 00 00 66 44 3B EE 0F 8C D0 03 00 00 BB 00 80 00 00 66 85 5C 24 22 74 1A 66 85 F6 79 15 41 8B CE E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? E9 18 04 00 00 83 CF FF 41 0F 2F C8 76 06 45 0F B7 E5 EB 28 0F 57 0D ?? ?? ?? ?? 48 8D 4C 24 30 8B D7 F3 0F 11 4C 24 20 E8 ?? ?? ?? ?? F3 0F 10 4C 24 20 44 0F B7 E0 0F B7 44 24 28 F3 0F 10 05 ?? ?? ?? ?? 0F 2F C1 76 10 F3 0F 59 0D ?? ?? ?? ?? 66 03 C7 66 89 44 24 28 0F 28 C1 F3 0F 58 0D ?? ?? ?? ?? F3 0F 5C 05 ?? ?? ?? ?? F3 0F 11 44 24 20 0F 28 F8 F3 0F 5E F9 0F 28 F7 F3 0F 59 F7 0F 28 C6 E8 ?? ?? ?? ?? F3 0F 10 64 24 20 0F BF 44 24 28 F3 0F 10 2D ?? ?? ?? ?? 41 0F 28 C9 BE 10 00 00 00 0F 28 DC 44 0F 28 E0 66 0F 6E D0 F3 44 0F 59 E6 F3 44 0F 5C E4 0F 5B D2 F3 44 0F 59 E7 F3 41 0F 58 DC 0F 28 C3 F3 0F 5E C5 F3 0F 58 C2 F3 0F 11 44 24 30 F3 0F 59 C8 F3 0F 10 05 ?? ?? ?? ?? 0F 2F C1 F3 0F 11 4C 24 2C 76 09 45 0F B7 F5 E9 76 02 00 00 0F 2F 0D ?? ?? ?? ?? 72 6B F3 0F 10 05 ?? ?? ?? ?? 0F 2F C1 72 5E 44 0F 2F 0D ?? ?? ?? ?? 76 54 F3 0F 10 05 ?? ?? ?? ?? 41 0F 2F C1 76 46 44 0F 2F C1 76 0A F3 0F 5C 0D ?? ?? ?? ?? EB 08 F3 0F 58 0D ?? ?? ?? ?? F3 41 0F 59 D1 F3 44 0F 2C C1 F3 41 0F 59 D9 66 41 0F 6E C0 0F 5B C0 F3 0F 5C D0 F3 0F 59 D5 F3 0F 58 DA F3 0F 11 5C 24 2C E9 DA 01 00 00 0F 2F 0D ?? ?? ?? ?? 0F 87 F5 01 00 00 BF 04 00 00 00 48 8D 4D 87 0F 28 D4 8B D7 E8 ?? ?? ?? ?? 8D 5F FE 48 8D 4C 24 38 41 0F 28 D4 8B D3 E8 ?? ?? ?? ?? 4C 8D 44 24 38 48 8D 4D 87 44 8B CB 8B D7 E8 ?? ?? ?? ?? F3 0F 10 45 87 41 0F 2E C0 7A 13 75 11 48 8D 4D A7 41 0F 28 D0 8B D7 E8 ?? ?? ?? ?? EB 7A 48 8D 15 ?? ?? ?? ?? 48 8D 4D A7 4C 8B C6 E8 ?? ?? ?? ?? 48 8D 4D A7 8B D7 F3 0F 10 55 87 E8 ?? ?? ?? ?? 49 8B F6 F3 0F 10 44 B5 87 41 0F 2E C0 7A 02 74 41 48 8D 15 ?? ?? ?? ?? 48 8D 4D B7 41 B8 10 00 00 00 E8 ?? ?? ?? ?? 48 8D 4D B7 8B D7 F3 0F 10 54 B5 87 E8 ?? ?? ?? ?? 4C 8D 45 B7 48 8D 4D A7 44 8B CF 8B D7 E8 ?? ?? ?? ?? 49 03 F6 48 3B F7 7C B1 BE 10 00 00 00 0F BF 44 24 28 48 8D 4D A7 8B D7 66 0F 6E D0 0F 5B D2 E8 ?? ?? ?? ?? 48 8D 4D 87 41 0F 28 D1 8B D3 E8 ?? ?? ?? ?? 48 8D 55 A7 48 8D 4D 97 4C 8B C6 E8 ?? ?? ?? ?? 48 8D 4D 97 8B D7 F3 0F 10 55 87 E8 ?? ?? ?? ?? F3 0F 10 45 8B 41 0F 2E C0 7A 02 74 32 48 8D 55 A7 48 8D 4D B7 4C 8B C6 E8 ?? ?? ?? ?? 48 8D 4D B7 8B D7 F3 0F 10 55 8B E8 ?? ?? ?? ?? 4C 8D 45 B7 48 8D 4D 97 44 8B CF 8B D7 E8 ?? ?? ?? ?? F3 0F 10 4D 97 41 0F 2E C8 F3 0F 11 4C 24 20 7A 02 74 20 F3 0F 10 55 9B 41 0F 2E D0 7A 02 74 13 F3 0F 10 45 9F F3 0F 58 C2 F3 0F 58 C1 F3 0F 11 44 24 20 48 8D 4C 24 20 33 D2 E8 ?? ?? ?? ?? 48 8D 4D 97 8B D7 F3 0F 10 54 24 20 0F 57 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 4D 97 8B D7 E8 ?? ?? ?? ?? F3 44 0F 2C 44 24 20 F3 0F 59 05 ?? ?? ?? ?? F3 0F 11 44 24 2C 4D 85 FF 74 07 66 45 89 07 45 8B C5 F3 0F 10 0D ?? ?? ?? ?? 48 8D 4C 24 2C E8 ?? ?? ?? ?? F3 0F 10 4C 24 2C 44 0F B7 F0 41 0F BF CE 85 C9 74 19 FF C9 75 27 F3 0F 10 05 ?? ?? ?? ?? B9 08 00 00 00 F3 0F 11 44 24 2C EB 07 44 21 6C 24 2C 8B CE E8 ?? ?? ?? ?? F3 0F 10 4C 24 2C 66 45 85 E4 74 13 0F 57 0D ?? ?? ?? ?? EB 0A BB 02 00 00 00 66 3B FB 75 05 0F 28 C1 EB 5F 66 3B F3 75 06 41 0F 28 C1 EB 54 BB 00 80 00 00 66 41 3B FE 0F 85 B6 00 00 00 66 85 5C 24 22 75 15 66 85 5D 81 75 09 F3 44 0F 10 05 ?? ?? ?? ?? 41 0F 28 C0 EB 29 66 85 5D 81 75 63 66 85 F6 75 16 48 8D 4C 24 30 83 CA FF E8 ?? ?? ?? ?? 66 85 C0 0F 88 07 01 00 00 F3 0F 10 05 ?? ?? ?? ?? 48 8B 4D C7 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 E0 00 00 00 49 8B 5B 58 41 0F 28 73 F0 41 0F 28 7B E0 45 0F 28 43 D0 45 0F 28 4B C0 45 0F 28 63 B0 49 8B E3 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 66 85 F6 75 8C 48 8D 4C 24 30 83 CA FF E8 ?? ?? ?? ?? 66 85 C0 0F 89 76 FF FF FF F3 44 0F 10 05 ?? ?? ?? ?? 44 0F 57 05 ?? ?? ?? ?? E9 60 FF FF FF 66 41 3B F6 75 22 66 85 5D 81 75 0E 66 85 C0 0F 8E 4B FF FF FF E9 3D FF FF FF 66 85 C0 0F 8F 3D FF FF FF E9 2F FF FF FF 66 85 5D 81 75 2C 66 85 F6 0F 85 29 FF FF FF 48 8D 4C 24 30 83 CA FF E8 ?? ?? ?? ?? 66 85 C0 0F 89 13 FF FF FF 66 85 5C 24 22 0F 84 08 FF FF FF EB 90 B9 04 00 00 00 E8 ?? ?? ?? ?? 66 85 F6 0F 85 1A FF FF FF 48 8D 4C 24 30 83 CA FF E8 ?? ?? ?? ?? 66 85 C0 0F 89 04 FF FF FF 66 85 5C 24 22 0F 84 F9 FE FF FF F3 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? E9 ED FE FF FF }
	condition:
		$1
}

rule file_259_1_0 {
	meta:
		name = "_fdtgamma"
		size = 379
		refs = "0015 __real@41f80000 001f stirling 002c __real@bf000000 0039 __real@3f000000 004f __real@3f800000 0066 __real@bf800000 0097 __real@3fc00000 00b1 __real@40200000 00c6 __real@c0000000 0104 _fdunscale 011c __real@3c590091 0124 __real@3d11e52b 012c __real@3c1aa374 0134 __real@3e452ca6 0144 __real@3edbc710 014c __real@3c9153c0 015c __real@3eddacfc 0164 __real@3f8314b3"
	strings:
		$1 = { 40 53 48 83 EC 30 0F 29 74 24 20 F3 0F 10 31 48 8B C2 0F 2F 35 ?? ?? ?? ?? 48 8B D9 72 0A E8 ?? ?? ?? ?? E9 48 01 00 00 F3 0F 10 05 ?? ?? ?? ?? 0F 2F C6 76 3A F3 0F 10 0D ?? ?? ?? ?? 0F 28 C6 0F 2F F1 F3 0F 11 44 24 40 77 17 F3 0F 58 35 ?? ?? ?? ?? 0F 2F F1 F3 0F 59 C6 76 EF F3 0F 11 44 24 40 F3 0F 58 35 ?? ?? ?? ?? E9 8C 00 00 00 F3 0F 10 05 ?? ?? ?? ?? 0F 2F C6 76 17 0F 28 C6 F3 0F 58 05 ?? ?? ?? ?? F3 0F 59 C6 F3 0F 11 44 24 40 EB 68 F3 0F 10 05 ?? ?? ?? ?? 0F 2F C6 76 0D 0F 28 C6 F3 0F 58 35 ?? ?? ?? ?? EB 1D F3 0F 10 0D ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? 0F 2F CE 76 0F F3 0F 58 35 ?? ?? ?? ?? 33 C9 66 89 0A EB 3D 0F 2F F1 F3 0F 11 44 24 40 76 17 F3 0F 58 35 ?? ?? ?? ?? 0F 2F F1 F3 0F 5E C6 77 EF F3 0F 11 44 24 40 F3 0F 58 35 ?? ?? ?? ?? 48 8D 54 24 40 48 8B C8 E8 ?? ?? ?? ?? F3 0F 10 44 24 40 F3 0F 11 03 0F 28 CE 0F 28 C6 F3 0F 59 05 ?? ?? ?? ?? F3 0F 59 0D ?? ?? ?? ?? F3 0F 58 05 ?? ?? ?? ?? F3 0F 5C 0D ?? ?? ?? ?? F3 0F 59 C6 F3 0F 59 CE F3 0F 58 05 ?? ?? ?? ?? F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 C6 F3 0F 59 CE F3 0F 58 05 ?? ?? ?? ?? F3 0F 58 0D ?? ?? ?? ?? F3 0F 5E C1 F3 0F 59 C6 0F 28 74 24 20 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_259_2_0 {
	meta:
		name = "stirling"
		size = 222
		refs = "0038 __real@3f000000 003d _fdpow 0048 __real@3f800000 0060 approx0 006c __real@3cc5aaec 0074 _fdpoly 0094 __xmm@80000000800000008000000080000000 00a5 expf"
	strings:
		$1 = { 48 8B C4 48 89 58 08 57 48 83 EC 60 0F 29 70 E8 0F 29 78 D8 44 0F 29 40 C8 4C 8B C2 48 8B DA 48 8B F9 44 0F 29 48 B8 F3 44 0F 10 09 41 0F 28 C9 41 0F 28 C1 F3 0F 5C 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B7 03 F3 0F 10 3D ?? ?? ?? ?? 66 F7 D8 41 B8 01 00 00 00 F3 41 0F 5E F9 66 89 03 48 8B 15 ?? ?? ?? ?? 44 0F 28 C0 F3 0F 5C 3D ?? ?? ?? ?? 0F 28 C7 E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 41 B8 07 00 00 00 0F 28 F0 0F 28 C7 E8 ?? ?? ?? ?? 44 0F 57 0D ?? ?? ?? ?? F3 0F 5E F0 41 0F 28 C1 F3 0F 11 37 E8 ?? ?? ?? ?? F3 0F 10 0F 48 8B 5C 24 70 0F 28 74 24 50 0F 28 7C 24 40 F3 41 0F 59 C0 F3 0F 5E C8 0F 57 C0 44 0F 28 44 24 30 44 0F 28 4C 24 20 F3 0F 11 0F 48 83 C4 60 5F C3 }
	condition:
		$1
}

rule file_259_3_0 {
	meta:
		name = "tgammaf"
		size = 572
		refs = "001f _fd_int 0055 _fperrraise 005d _FNan_C 0080 _FInf_C 0091 __xmm@80000000800000008000000080000000 00a3 __real@c2180000 00c2 _fdgamma_big 00f5 __real@3f800000 010c __real@bf800000 0130 __real@40490fdb 0137 _fdsin 0170 _fdtgamma 0198 _fdscale 01c3 __real@42180000"
	strings:
		$1 = { F3 0F 11 44 24 08 55 48 8B EC 48 83 EC 40 48 8D 4D 28 33 D2 F3 0F 11 45 28 0F 29 74 24 30 E8 ?? ?? ?? ?? 0F BF C8 F3 0F 10 55 10 0F 57 F6 85 C9 74 34 FF C9 74 0E FF C9 75 65 F3 0F 10 45 10 E9 ED 01 00 00 B8 00 80 00 00 66 85 45 12 74 EB B9 01 00 00 00 E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? E9 CB 01 00 00 0F 2E D6 7A 2F 75 2D B9 04 00 00 00 E8 ?? ?? ?? ?? B8 00 80 00 00 F3 0F 10 05 ?? ?? ?? ?? 66 85 45 12 0F 84 A3 01 00 00 0F 57 05 ?? ?? ?? ?? E9 97 01 00 00 0F 2F F2 77 B0 F3 0F 10 0D ?? ?? ?? ?? 0F 2F CA 72 12 B9 10 00 00 00 E8 ?? ?? ?? ?? 0F 28 C6 E9 73 01 00 00 F3 0F 10 05 ?? ?? ?? ?? F3 0F 10 35 ?? ?? ?? ?? 0F 57 C6 0F 2F C2 0F 86 E5 00 00 00 0F 28 C2 F3 0F 11 55 20 F3 0F 5C 55 28 48 8D 4D 20 83 CA FF 0F 57 C6 F3 0F 5C 05 ?? ?? ?? ?? F3 0F 11 55 28 F3 0F 11 45 E0 E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? F3 0F 10 4D 10 F3 0F 5C 4D 20 0F 2F C1 F3 0F 10 45 28 76 08 0F 57 C6 F3 0F 11 45 28 F3 0F 59 05 ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? F3 0F 10 4D 10 48 8D 55 18 48 8D 4D E0 F3 0F 59 C1 0F 57 CE F3 0F 5C 0D ?? ?? ?? ?? F3 0F 59 C1 F3 0F 10 0D ?? ?? ?? ?? 0F 57 C6 F3 0F 5E C8 F3 0F 11 4D 20 E8 ?? ?? ?? ?? F3 0F 10 4D 20 0F BF 55 18 48 8D 4D 20 F3 0F 58 05 ?? ?? ?? ?? F3 0F 5E C8 F3 0F 59 4D E0 F3 0F 11 4D 20 E8 ?? ?? ?? ?? 0F BF C8 85 C9 74 0B FF C9 75 11 B9 08 00 00 00 EB 05 B9 10 00 00 00 E8 ?? ?? ?? ?? F3 0F 10 45 20 EB 72 F3 0F 10 05 ?? ?? ?? ?? 0F 2F C2 72 53 48 8D 55 18 48 8D 4D 10 E8 ?? ?? ?? ?? 0F BF 55 18 48 8D 4D 10 F3 0F 58 05 ?? ?? ?? ?? F7 DA F3 0F 5E 45 10 F3 0F 11 45 10 E8 ?? ?? ?? ?? 0F BF C8 85 C9 74 0F FF C9 0F 85 31 FE FF FF B9 08 00 00 00 EB 05 B9 10 00 00 00 E8 ?? ?? ?? ?? E9 1B FE FF FF B9 08 00 00 00 E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? 0F 28 74 24 30 48 83 C4 40 5D C3 }
	condition:
		$1
}

rule file_260_25_0 {
	meta:
		name = "?CreateRemoteThreadEx@UMS@details@Concurrency@@SAPEAXPEAXPEAU_SECURITY_ATTRIBUTES@@_KP6AK0@Z0KPEAU_PROC_THREAD_ATTRIBUTE_LIST@@PEAK@Z"
		size = 79
		refs = "001a ?s_pfn_CreateRemoteThreadEx@UMS@details@Concurrency@@0P6APEAXPEAXPEAU_SECURITY_ATTRIBUTES@@_KP6AK0@Z0KPEAU_PROC_THREAD_ATTRIBUTE_LIST@@PEAK@ZEA 0028 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 40 48 8B E9 48 8B 0D ?? ?? ?? ?? 49 8B D9 49 8B F8 48 8B F2 E8 ?? ?? ?? ?? 4C 8B CB 4C 8B C7 48 8B D6 48 8B CD 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 40 5F 48 FF E0 }
	condition:
		$1
}

rule file_260_31_0 {
	meta:
		name = "?DequeueUmsCompletionListItems@UMS@details@Concurrency@@SAHPEAXKPEAPEAX@Z"
		size = 61
		refs = "0015 ?s_pfn_DequeueUmsCompletionListItems@UMS@details@Concurrency@@0P6AHPEAXKPEAPEAX@ZEA 001f ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F1 48 8B 0D ?? ?? ?? ?? 49 8B D8 8B FA E8 ?? ?? ?? ?? 4C 8B C3 8B D7 48 8B CE 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F 48 FF E0 }
	condition:
		$1
}

rule file_260_36_0 {
	meta:
		name = "?GetUmsCompletionListEvent@UMS@details@Concurrency@@SAHPEAXPEAPEAX@Z"
		size = 47
		refs = "0010 ?s_pfn_GetUmsCompletionListEvent@UMS@details@Concurrency@@0P6AHPEAXPEAPEAX@ZEA 0018 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 48 8B 0D ?? ?? ?? ?? 48 8B DA E8 ?? ?? ?? ?? 48 8B D3 48 8B CF 48 8B 5C 24 30 48 83 C4 20 5F 48 FF E0 }
	condition:
		$1
}

rule file_260_37_0 {
	meta:
		name = "?Initialize@UMS@details@Concurrency@@SAXXZ"
		size = 1713
		refs = "0018 ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0021 __imp_GetModuleHandleW 0028 ??_C@_0BF@PHKBGNNA@CreateRemoteThreadEx?$AA@ 0031 __imp_GetProcAddress 0042 ?EncodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z 004c ?s_pfn_CreateRemoteThreadEx@UMS@details@Concurrency@@0P6APEAXPEAXPEAU_SECURITY_ATTRIBUTES@@_KP6AK0@Z0KPEAU_PROC_THREAD_ATTRIBUTE_LIST@@PEAK@ZEA 0059 ??_C@_0BI@OFOMFECC@CreateUmsCompletionList?$AA@ 007d ?s_pfn_CreateUmsCompletionList@UMS@details@Concurrency@@0P6AHPEAPEAX@ZEA 008a ??_C@_0BH@NBGNADAH@CreateUmsThreadContext?$AA@ 00ae ?s_pfn_CreateUmsThreadContext@UMS@details@Concurrency@@0P6AHPEAPEAX@ZEA 00bb ??_C@_0BO@JONJJOMF@DeleteProcThreadAttributeList?$AA@ 00df ?s_pfn_DeleteProcThreadAttributeList@UMS@details@Concurrency@@0P6AXPEAU_PROC_THREAD_ATTRIBUTE_LIST@@@ZEA 00ec ??_C@_0BI@BPKNDLMM@DeleteUmsCompletionList?$AA@ 0110 ?s_pfn_DeleteUmsCompletionList@UMS@details@Concurrency@@0P6AHPEAX@ZEA 011d ??_C@_0BH@JPDPIOBJ@DeleteUmsThreadContext?$AA@ 0141 ?s_pfn_DeleteUmsThreadContext@UMS@details@Concurrency@@0P6AHPEAX@ZEA 014e ??_C@_0BO@GGFJEFKK@DequeueUmsCompletionListItems?$AA@ 0172 ?s_pfn_DequeueUmsCompletionListItems@UMS@details@Concurrency@@0P6AHPEAXKPEAPEAX@ZEA 017f ??_C@_0BH@BLPFNIKG@EnterUmsSchedulingMode?$AA@ 01a3 ?s_pfn_EnterUmsSchedulingMode@UMS@details@Concurrency@@0P6AHPEAU_UMS_SCHEDULER_STARTUP_INFO@@@ZEA 01b0 ??_C@_0BB@DHABPDKF@ExecuteUmsThread?$AA@ 01d4 ?s_pfn_ExecuteUmsThread@UMS@details@Concurrency@@0P6AHPEAX@ZEA 01e1 ??_C@_0BE@FLBMLIK@GetCurrentUmsThread?$AA@ 0205 ?s_pfn_GetCurrentUmsThread@UMS@details@Concurrency@@0P6APEAXXZEA 0212 ??_C@_0BD@FNFEEGCI@GetNextUmsListItem?$AA@ 0236 ?s_pfn_GetNextUmsListItem@UMS@details@Concurrency@@0P6APEAXPEAX@ZEA 0243 ??_C@_0BK@MGNBLFMB@GetUmsCompletionListEvent?$AA@ 0267 ?s_pfn_GetUmsCompletionListEvent@UMS@details@Concurrency@@0P6AHPEAXPEAPEAX@ZEA 0274 ??_C@_0CC@PLANOPMM@InitializeProcThreadAttributeLis@ 0298 ?s_pfn_InitializeProcThreadAttributeList@UMS@details@Concurrency@@0P6AHPEAU_PROC_THREAD_ATTRIBUTE_LIST@@KKPEA_K@ZEA 02a5 ??_C@_0BK@DAKPFGE@QueryUmsThreadInformation?$AA@ 02c9 ?s_pfn_QueryUmsThreadInformation@UMS@details@Concurrency@@0P6AHPEAXW4_RTL_UMS_THREAD_INFO_CLASS@@0KPEAK@ZEA 02d6 ??_C@_0BI@DPBBCPDB@SetUmsThreadInformation?$AA@ 02fa ?s_pfn_SetUmsThreadInformation@UMS@details@Concurrency@@0P6AHPEAXW4_RTL_UMS_THREAD_INFO_CLASS@@0K@ZEA 0307 ??_C@_0P@ILGNBNP@UmsThreadYield?$AA@ 032b ?s_pfn_UmsThreadYield@UMS@details@Concurrency@@0P6AHPEAX@ZEA 0338 ??_C@_0BK@LCOMJCNI@UpdateProcThreadAttribute?$AA@ 0361 ?s_pfn_UpdateProcThreadAttribute@UMS@details@Concurrency@@0P6AHPEAU_PROC_THREAD_ATTRIBUTE_LIST@@K_KPEAX12PEA_K@ZEA 036c ?s_fInitialized@UMS@details@Concurrency@@0JC 037b __imp_GetLastError 0393 ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 039a _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 03a4 _CxxThrowException"
	strings:
		$1 = { 48 89 5C 24 08 55 48 8D AC 24 C0 FE FF FF 48 81 EC 40 02 00 00 48 8D 1D ?? ?? ?? ?? 48 8B CB FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 3B 03 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 3A 03 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 37 03 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 34 03 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 37 03 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 34 03 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 37 03 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 34 03 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 37 03 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 36 03 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 35 03 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 32 03 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 2F 03 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 2C 03 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 29 03 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 2C 03 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 2F 03 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B 9C 24 50 02 00 00 48 89 05 ?? ?? ?? ?? B8 01 00 00 00 87 05 ?? ?? ?? ?? 48 81 C4 40 02 00 00 5D C3 FF 15 ?? ?? ?? ?? 48 8D 4C 24 40 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 40 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 4D 40 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D 40 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 4D 80 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D 80 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 8D C0 00 00 00 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8D C0 00 00 00 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 4D C0 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D C0 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 8D 80 00 00 00 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8D 80 00 00 00 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 4D 00 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D 00 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 8D 00 01 00 00 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8D 00 01 00 00 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 4C 24 20 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 4C 24 60 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 4D A0 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D A0 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 4D E0 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D E0 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 4D 20 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D 20 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 4D 60 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D 60 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 8D A0 00 00 00 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8D A0 00 00 00 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 8D E0 00 00 00 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8D E0 00 00 00 E8 ?? ?? ?? ?? CC FF 15 ?? ?? ?? ?? 48 8D 8D 20 01 00 00 0F B7 D0 81 CA 00 00 07 80 85 C0 0F 4E D0 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8D 20 01 00 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_260_38_0 {
	meta:
		name = "?InitializeProcThreadAttributeList@UMS@details@Concurrency@@SAHPEAU_PROC_THREAD_ATTRIBUTE_LIST@@KKPEA_K@Z"
		size = 77
		refs = "001a ?s_pfn_InitializeProcThreadAttributeList@UMS@details@Concurrency@@0P6AHPEAU_PROC_THREAD_ATTRIBUTE_LIST@@KKPEA_K@ZEA 0027 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B E9 48 8B 0D ?? ?? ?? ?? 49 8B D9 41 8B F8 8B F2 E8 ?? ?? ?? ?? 4C 8B CB 44 8B C7 8B D6 48 8B CD 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F 48 FF E0 }
	condition:
		$1
}

rule file_260_40_0 {
	meta:
		name = "?QueryUmsThreadInformation@UMS@details@Concurrency@@SAHPEAXW4_RTL_UMS_THREAD_INFO_CLASS@@0KPEAK@Z"
		size = 77
		refs = "001a ?s_pfn_QueryUmsThreadInformation@UMS@details@Concurrency@@0P6AHPEAXW4_RTL_UMS_THREAD_INFO_CLASS@@0KPEAK@ZEA 0027 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 30 48 8B E9 48 8B 0D ?? ?? ?? ?? 41 8B D9 49 8B F8 8B F2 E8 ?? ?? ?? ?? 44 8B CB 4C 8B C7 8B D6 48 8B CD 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 30 5F 48 FF E0 }
	condition:
		$1
}

rule file_260_41_0 {
	meta:
		name = "?SetUmsThreadInformation@UMS@details@Concurrency@@SAHPEAXW4_RTL_UMS_THREAD_INFO_CLASS@@0K@Z"
		size = 77
		refs = "001a ?s_pfn_SetUmsThreadInformation@UMS@details@Concurrency@@0P6AHPEAXW4_RTL_UMS_THREAD_INFO_CLASS@@0K@ZEA 0027 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B E9 48 8B 0D ?? ?? ?? ?? 41 8B D9 49 8B F8 8B F2 E8 ?? ?? ?? ?? 44 8B CB 4C 8B C7 8B D6 48 8B CD 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F 48 FF E0 }
	condition:
		$1
}

rule file_260_43_0 {
	meta:
		name = "?UpdateProcThreadAttribute@UMS@details@Concurrency@@SAHPEAU_PROC_THREAD_ATTRIBUTE_LIST@@K_KPEAX12PEA_K@Z"
		size = 77
		refs = "001a ?s_pfn_UpdateProcThreadAttribute@UMS@details@Concurrency@@0P6AHPEAU_PROC_THREAD_ATTRIBUTE_LIST@@K_KPEAX12PEA_K@ZEA 0027 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 40 48 8B E9 48 8B 0D ?? ?? ?? ?? 49 8B D9 49 8B F8 8B F2 E8 ?? ?? ?? ?? 4C 8B CB 4C 8B C7 8B D6 48 8B CD 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 40 5F 48 FF E0 }
	condition:
		$1
}

rule file_261_4_0 {
	meta:
		name = "_mbsnbcoll_l"
		size = 275
		refs = "0037 _errno 0042 _invalid_parameter_noinfo 007d ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0099 _strncoll_l 00cb __crtCompareStringA"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 60 4D 8B F1 49 8B F8 48 8B F2 48 8B E9 4D 85 C0 75 07 33 C0 E9 C7 00 00 00 48 85 C9 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F E9 A8 00 00 00 48 85 D2 74 E1 BB FF FF FF 7F 4C 3B C3 76 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 82 00 00 00 48 8D 4C 24 40 49 8B D1 E8 ?? ?? ?? ?? 48 8B 54 24 48 83 7A 08 00 75 15 4D 8B CE 4C 8B C7 48 8B D6 48 8B CD E8 ?? ?? ?? ?? 8B D8 EB 42 8B 42 04 48 8B 92 20 02 00 00 48 8D 4C 24 40 89 44 24 38 89 7C 24 30 4C 8B CD 41 B8 00 10 00 00 48 89 74 24 28 89 7C 24 20 E8 ?? ?? ?? ?? 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 03 8D 58 FE 80 7C 24 58 00 74 0C 48 8B 44 24 50 83 A0 C8 00 00 00 FD 8B C3 4C 8D 5C 24 60 49 8B 5B 10 49 8B 6B 18 49 8B 73 20 49 8B 7B 28 49 8B E3 41 5E C3 }
	condition:
		$1
}

rule file_262_0_0 {
	meta:
		name = "_FindPESection"
		size = 68
	strings:
		$1 = { 4C 63 41 3C 45 33 C9 4C 8B D2 4C 03 C1 41 0F B7 40 14 45 0F B7 58 06 48 83 C0 18 49 03 C0 45 85 DB 74 1E 8B 50 0C 4C 3B D2 72 0A 8B 48 08 03 CA 4C 3B D1 72 0E 41 FF C1 48 83 C0 28 45 3B CB 72 E2 33 C0 C3 }
	condition:
		$1
}

rule file_262_1_0 {
	meta:
		name = "_IsNonwritableInCurrentImage"
		size = 77
		refs = "0010 __ImageBase 0018 _ValidateImageBase 002a _FindPESection"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B D9 48 8D 3D ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 22 48 2B DF 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 48 85 C0 74 0F 8B 40 24 C1 E8 1F F7 D0 83 E0 01 EB 02 33 C0 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_262_2_0 {
	meta:
		name = "_IsNonwritableInCurrentImage$filt$0"
		size = 32
		altNames = "__RTCastToVoid$filt$0 __RTtypeid$filt$0 _heapwalk$filt$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 01 33 C9 81 38 05 00 00 C0 0F 94 C1 8B C1 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_262_3_0 {
	meta:
		name = "_ValidateImageBase"
		size = 46
	strings:
		$1 = { 48 8B C1 B9 4D 5A 00 00 66 39 08 74 03 33 C0 C3 48 63 48 3C 48 03 C8 33 C0 81 39 50 45 00 00 75 0C BA 0B 02 00 00 66 39 51 18 0F 94 C0 C3 }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "_open"
		size = 209
		refs = "002f _errno 003a _invalid_parameter_noinfo 0076 _sopen_nolock 009a __pioinfo 00b3 _unlock_fhandle"
	strings:
		$1 = { 48 8B C4 89 50 10 4C 89 40 18 4C 89 48 20 53 48 83 EC 50 83 48 E8 FF 83 60 F0 00 83 60 EC 00 45 33 C0 48 85 C9 41 0F 95 C0 45 85 C0 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 85 00 00 00 48 8D 44 24 70 48 83 C0 08 44 8B 40 F8 83 64 24 30 00 44 89 44 24 28 C7 44 24 20 40 00 00 00 44 8B CA 4C 8B C1 48 8D 54 24 40 48 8D 4C 24 44 E8 ?? ?? ?? ?? 8B D8 89 44 24 48 83 7C 24 44 00 74 30 85 C0 74 23 48 63 4C 24 40 48 8B C1 48 C1 F8 05 48 8D 15 ?? ?? ?? ?? 83 E1 1F 48 6B C9 58 48 8B 04 C2 80 64 08 08 FE 8B 4C 24 40 E8 ?? ?? ?? ?? 85 DB 74 0C E8 ?? ?? ?? ?? 89 18 E9 77 FF FF FF 8B 44 24 40 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_318_2_0 {
	meta:
		name = "_wopen"
		size = 209
		refs = "002f _errno 003a _invalid_parameter_noinfo 0076 _wsopen_nolock 009a __pioinfo 00b3 _unlock_fhandle"
	strings:
		$1 = { 48 8B C4 89 50 10 4C 89 40 18 4C 89 48 20 53 48 83 EC 50 83 48 E8 FF 83 60 F0 00 83 60 EC 00 45 33 C0 48 85 C9 41 0F 95 C0 45 85 C0 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 85 00 00 00 48 8D 44 24 70 48 83 C0 08 44 8B 40 F8 83 64 24 30 00 44 89 44 24 28 C7 44 24 20 40 00 00 00 44 8B CA 4C 8B C1 48 8D 54 24 40 48 8D 4C 24 44 E8 ?? ?? ?? ?? 8B D8 89 44 24 48 83 7C 24 44 00 74 30 85 C0 74 23 48 63 4C 24 40 48 8B C1 48 C1 F8 05 48 8D 15 ?? ?? ?? ?? 83 E1 1F 48 6B C9 58 48 8B 04 C2 80 64 08 08 FE 8B 4C 24 40 E8 ?? ?? ?? ?? 85 DB 74 0C E8 ?? ?? ?? ?? 89 18 E9 77 FF FF FF 8B 44 24 40 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_263_1_0 {
	meta:
		name = "_open$fin$0"
		size = 71
		refs = "0023 __pioinfo 003b _unlock_fhandle"
		altNames = "_wopen$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 40 48 8B EA 83 7D 44 00 74 31 83 7D 48 00 74 22 48 63 4D 40 48 8B C1 48 C1 F8 05 48 8D 15 ?? ?? ?? ?? 83 E1 1F 48 6B C9 58 48 8B 04 C2 80 64 08 08 FE 8B 4D 40 E8 ?? ?? ?? ?? 90 48 83 C4 40 5D C3 CC }
	condition:
		$1
}

rule file_263_2_0 {
	meta:
		name = "_sopen"
		size = 65
		refs = "002c _sopen_helper"
	strings:
		$1 = { 4C 8B DC 45 89 43 18 4D 89 4B 20 53 48 83 EC 40 83 64 24 28 00 4D 8D 4B E8 49 8D 43 20 4D 89 4B D8 83 CB FF 89 5C 24 30 44 8B 08 E8 ?? ?? ?? ?? 8B 4C 24 30 85 C0 0F 45 CB 8B C1 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_263_3_0 {
	meta:
		name = "_sopen_helper"
		size = 222
		refs = "002f _errno 003b _invalid_parameter_noinfo 008d _sopen_nolock 00af __pioinfo 00c6 _unlock_fhandle"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 50 45 8B D0 4C 8B C1 83 64 24 44 00 83 64 24 40 00 33 C0 48 8B 9C 24 80 00 00 00 48 85 DB 0F 95 C0 85 C0 75 18 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 E9 8D 00 00 00 83 0B FF 33 C0 48 85 C9 0F 95 C0 85 C0 74 D9 8B 8C 24 88 00 00 00 85 C9 74 13 41 F7 C1 7F FE FF FF B8 00 00 00 00 0F 94 C0 85 C0 74 BB 89 4C 24 30 44 89 4C 24 28 44 89 54 24 20 44 8B CA 48 8B D3 48 8D 4C 24 40 E8 ?? ?? ?? ?? 8B F8 89 44 24 44 83 7C 24 40 00 74 2C 85 C0 74 21 48 63 0B 48 8B C1 48 C1 F8 05 48 8D 15 ?? ?? ?? ?? 83 E1 1F 48 6B C9 58 48 8B 04 C2 80 64 08 08 FE 8B 0B E8 ?? ?? ?? ?? 85 FF 74 03 83 0B FF 8B C7 48 8B 5C 24 60 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_318_5_0 {
	meta:
		name = "_wsopen_helper"
		size = 222
		refs = "002f _errno 003b _invalid_parameter_noinfo 008d _wsopen_nolock 00af __pioinfo 00c6 _unlock_fhandle"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 50 45 8B D0 4C 8B C1 83 64 24 44 00 83 64 24 40 00 33 C0 48 8B 9C 24 80 00 00 00 48 85 DB 0F 95 C0 85 C0 75 18 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 E9 8D 00 00 00 83 0B FF 33 C0 48 85 C9 0F 95 C0 85 C0 74 D9 8B 8C 24 88 00 00 00 85 C9 74 13 41 F7 C1 7F FE FF FF B8 00 00 00 00 0F 94 C0 85 C0 74 BB 89 4C 24 30 44 89 4C 24 28 44 89 54 24 20 44 8B CA 48 8B D3 48 8D 4C 24 40 E8 ?? ?? ?? ?? 8B F8 89 44 24 44 83 7C 24 40 00 74 2C 85 C0 74 21 48 63 0B 48 8B C1 48 C1 F8 05 48 8D 15 ?? ?? ?? ?? 83 E1 1F 48 6B C9 58 48 8B 04 C2 80 64 08 08 FE 8B 0B E8 ?? ?? ?? ?? 85 FF 74 03 83 0B FF 8B C7 48 8B 5C 24 60 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_263_4_0 {
	meta:
		name = "_sopen_helper$fin$0"
		size = 83
		refs = "0029 __pioinfo 0047 _unlock_fhandle"
		altNames = "_wsopen_helper$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 40 48 8B EA 83 7D 40 00 74 3D 83 7D 44 00 74 28 48 8B 85 80 00 00 00 48 63 08 48 8B C1 48 C1 F8 05 48 8D 15 ?? ?? ?? ?? 83 E1 1F 48 6B C9 58 48 8B 04 C2 80 64 08 08 FE 48 8B 85 80 00 00 00 8B 08 E8 ?? ?? ?? ?? 90 48 83 C4 40 5D C3 CC }
	condition:
		$1
}

rule file_263_5_0 {
	meta:
		name = "_sopen_nolock"
		size = 133
		refs = "0026 __copy_path_to_wide_string 0063 _wsopen_nolock 006f free"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 57 48 83 EC 50 48 83 60 E8 00 48 8B FA 48 8B F1 48 8D 50 E8 49 8B C8 41 8B D9 E8 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 42 8B 84 24 90 00 00 00 4C 8B 44 24 40 44 8B CB 89 44 24 30 8B 84 24 88 00 00 00 48 8B D7 89 44 24 28 8B 84 24 80 00 00 00 48 8B CE 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 40 8B D8 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 60 48 8B 74 24 68 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_263_6_0 {
	meta:
		name = "_sopen_s"
		size = 50
		refs = "0029 _sopen_helper"
	strings:
		$1 = { 48 83 EC 38 41 8B C1 44 8B 4C 24 60 45 8B D0 4C 8B DA C7 44 24 28 01 00 00 00 48 89 4C 24 20 44 8B C0 41 8B D2 49 8B CB E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_318_8_0 {
	meta:
		name = "_wsopen_s"
		size = 50
		refs = "0029 _wsopen_helper"
	strings:
		$1 = { 48 83 EC 38 41 8B C1 44 8B 4C 24 60 45 8B D0 4C 8B DA C7 44 24 28 01 00 00 00 48 89 4C 24 20 44 8B C0 41 8B D2 49 8B CB E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "_vsnprintf"
		size = 22
		refs = "000d _vsnprintf_l"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_487_2_0 {
	meta:
		name = "?vswprintf@@YAHPEAG_KPEBGPEAD@Z"
		size = 22
		refs = "000d ?_vswprintf_l@@YAHPEA_W_KPEB_WPEAUlocaleinfo_struct@@PEAD@Z"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_487_3_0 {
	meta:
		name = "?vswprintf@@YAHPEA_W_KPEB_WPEAD@Z"
		size = 22
		refs = "000d ?_vswprintf_l@@YAHPEA_W_KPEB_WPEAUlocaleinfo_struct@@PEAD@Z"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_547_0_0 {
	meta:
		name = "_vsnwprintf"
		size = 22
		refs = "000d _vsnwprintf_l"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_667_8_0 {
	meta:
		name = "vsprintf_s"
		size = 22
		refs = "000d _vsprintf_s_l"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_714_8_0 {
	meta:
		name = "vswprintf_s"
		size = 22
		refs = "000d _vswprintf_s_l"
	strings:
		$1 = { 48 83 EC 38 4C 89 4C 24 20 45 33 C9 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_265_1_0 {
	meta:
		name = "_vsnprintf_l"
		size = 203
		refs = "0030 memset 003a _errno 0045 _invalid_parameter_noinfo 008d _output_l 00b0 _flsbuf"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 57 48 83 EC 50 48 83 60 C8 00 48 8B DA 33 D2 49 8B F0 48 8B F9 44 8D 42 28 48 8D 48 D0 49 8B E9 E8 ?? ?? ?? ?? 48 85 F6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 68 48 85 DB 74 05 48 85 FF 74 E1 4C 8B 8C 24 80 00 00 00 B8 FF FF FF 7F 48 8D 4C 24 20 48 3B D8 4C 8B C5 48 8B D6 0F 47 D8 C7 44 24 38 42 00 00 00 48 89 7C 24 30 89 5C 24 28 48 89 7C 24 20 E8 ?? ?? ?? ?? 8B D8 48 85 FF 74 1E FF 4C 24 28 78 0A 48 8B 44 24 20 C6 00 00 EB 0C 48 8D 54 24 20 33 C9 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 60 48 8B 6C 24 68 48 8B 74 24 70 48 83 C4 50 5F C3 }
	condition:
		$1
}

rule file_266_0_0 {
	meta:
		name = "_LCmulcc"
		size = 209
		refs = "0033 creall 004a cimagl 00a3 _LCbuild"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 57 48 83 EC 60 0F 10 02 0F 29 70 E8 48 8B F1 0F 29 78 D8 48 8D 48 B8 49 8B F8 48 8B DA F3 0F 7F 40 B8 44 0F 29 40 C8 E8 ?? ?? ?? ?? 48 8D 4C 24 20 0F 10 0B 44 0F 28 C0 F3 0F 7F 4C 24 20 E8 ?? ?? ?? ?? 0F 10 0F 48 8D 4C 24 20 0F 28 F8 F3 0F 7F 4C 24 20 E8 ?? ?? ?? ?? 0F 10 0F 48 8D 4C 24 20 0F 28 F0 F3 0F 7F 4C 24 20 E8 ?? ?? ?? ?? 0F 28 D6 48 8D 4C 24 20 0F 28 C8 F2 41 0F 59 F0 F2 0F 59 C7 F2 0F 59 D7 F2 0F 5C F0 F2 41 0F 59 C8 F2 0F 58 D1 0F 28 CE E8 ?? ?? ?? ?? 48 8B 5C 24 70 0F 28 74 24 50 0F 28 7C 24 40 44 0F 28 44 24 30 0F 10 00 48 8B C6 F3 0F 7F 06 48 8B 74 24 78 48 83 C4 60 5F C3 }
	condition:
		$1
}

rule file_1300_0_0 {
	meta:
		name = "_Cmulcc"
		size = 209
		refs = "0033 creal 004a cimag 00a3 _Cbuild"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 57 48 83 EC 60 0F 10 02 0F 29 70 E8 48 8B F1 0F 29 78 D8 48 8D 48 B8 49 8B F8 48 8B DA F3 0F 7F 40 B8 44 0F 29 40 C8 E8 ?? ?? ?? ?? 48 8D 4C 24 20 0F 10 0B 44 0F 28 C0 F3 0F 7F 4C 24 20 E8 ?? ?? ?? ?? 0F 10 0F 48 8D 4C 24 20 0F 28 F8 F3 0F 7F 4C 24 20 E8 ?? ?? ?? ?? 0F 10 0F 48 8D 4C 24 20 0F 28 F0 F3 0F 7F 4C 24 20 E8 ?? ?? ?? ?? 0F 28 D6 48 8D 4C 24 20 0F 28 C8 F2 41 0F 59 F0 F2 0F 59 C7 F2 0F 59 D7 F2 0F 5C F0 F2 41 0F 59 C8 F2 0F 58 D1 0F 28 CE E8 ?? ?? ?? ?? 48 8B 5C 24 70 0F 28 74 24 50 0F 28 7C 24 40 44 0F 28 44 24 30 0F 10 00 48 8B C6 F3 0F 7F 06 48 8B 74 24 78 48 83 C4 60 5F C3 }
	condition:
		$1
}

rule file_266_1_0 {
	meta:
		name = "_LCmulcr"
		size = 110
		refs = "002b cimagl 003c creall 0050 _LCbuild"
	strings:
		$1 = { 48 8B C4 53 48 83 EC 70 0F 10 02 48 8B D9 0F 29 70 E8 0F 29 78 D8 48 8D 48 A8 0F 10 C8 0F 28 FA F3 0F 7F 40 A8 F3 0F 7F 48 B8 E8 ?? ?? ?? ?? 48 8D 4C 24 30 0F 28 F0 F2 0F 59 F7 E8 ?? ?? ?? ?? 48 8D 4C 24 40 0F 28 D6 F2 0F 59 C7 0F 28 C8 E8 ?? ?? ?? ?? 0F 28 74 24 60 0F 28 7C 24 50 0F 10 00 48 8B C3 F3 0F 7F 03 48 83 C4 70 5B C3 }
	condition:
		$1
}

rule file_1300_1_0 {
	meta:
		name = "_Cmulcr"
		size = 110
		refs = "002b cimag 003c creal 0050 _Cbuild"
	strings:
		$1 = { 48 8B C4 53 48 83 EC 70 0F 10 02 48 8B D9 0F 29 70 E8 0F 29 78 D8 48 8D 48 A8 0F 10 C8 0F 28 FA F3 0F 7F 40 A8 F3 0F 7F 48 B8 E8 ?? ?? ?? ?? 48 8D 4C 24 30 0F 28 F0 F2 0F 59 F7 E8 ?? ?? ?? ?? 48 8D 4C 24 40 0F 28 D6 F2 0F 59 C7 0F 28 C8 E8 ?? ?? ?? ?? 0F 28 74 24 60 0F 28 7C 24 50 0F 10 00 48 8B C3 F3 0F 7F 03 48 83 C4 70 5B C3 }
	condition:
		$1
}

rule file_266_2_0 {
	meta:
		name = "cpowl"
		size = 334
		refs = "0034 cimagl 003c __real@0000000000000000 007e creall 0092 pow 00a1 _LCbuild 00c1 log 00d1 _LCmulcr 00ec clogl 010d _LCmulcc 0122 cexpl"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 55 48 8B EC 48 81 EC 80 00 00 00 0F 10 02 48 8B F1 48 8D 4D A0 0F 29 70 E8 49 8B D8 48 8B FA F3 0F 7F 45 A0 E8 ?? ?? ?? ?? 66 0F 2E 05 ?? ?? ?? ?? 0F 8A 95 00 00 00 0F 85 8F 00 00 00 0F 10 03 48 8D 4D A0 F3 0F 7F 45 A0 E8 ?? ?? ?? ?? 66 0F 2E 05 ?? ?? ?? ?? 7A 40 75 3E 0F 10 03 0F 10 0F 48 8D 4D A0 F3 0F 7F 45 A0 F3 0F 7F 4D B0 E8 ?? ?? ?? ?? 48 8D 4D B0 0F 28 F0 E8 ?? ?? ?? ?? 0F 28 CE E8 ?? ?? ?? ?? 48 8D 4D C0 0F 57 D2 0F 28 C8 E8 ?? ?? ?? ?? EB 7F 0F 10 07 0F 10 0B 48 8D 4D B0 F3 0F 7F 45 B0 F3 0F 7F 4D A0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 55 A0 48 8D 4D C0 0F 28 D0 E8 ?? ?? ?? ?? 48 8D 4D D0 EB 3A 0F 10 07 48 8D 55 B0 48 8D 4D D0 F3 0F 7F 45 B0 E8 ?? ?? ?? ?? 0F 10 0B 4C 8D 45 B0 48 8D 55 A0 48 8D 4D C0 0F 10 00 F3 0F 7F 4D A0 F3 0F 7F 45 B0 E8 ?? ?? ?? ?? 48 8D 4D E0 0F 10 00 48 8D 55 B0 F3 0F 7F 45 B0 E8 ?? ?? ?? ?? 0F 10 00 0F 28 74 24 70 4C 8D 9C 24 80 00 00 00 48 8B C6 49 8B 5B 10 49 8B 7B 20 F3 0F 7F 06 49 8B 73 18 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_1300_2_0 {
	meta:
		name = "cpow"
		size = 334
		refs = "0034 cimag 003c __real@0000000000000000 007e creal 0092 pow 00a1 _Cbuild 00c1 log 00d1 _Cmulcr 00ec clog 010d _Cmulcc 0122 cexp"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 55 48 8B EC 48 81 EC 80 00 00 00 0F 10 02 48 8B F1 48 8D 4D A0 0F 29 70 E8 49 8B D8 48 8B FA F3 0F 7F 45 A0 E8 ?? ?? ?? ?? 66 0F 2E 05 ?? ?? ?? ?? 0F 8A 95 00 00 00 0F 85 8F 00 00 00 0F 10 03 48 8D 4D A0 F3 0F 7F 45 A0 E8 ?? ?? ?? ?? 66 0F 2E 05 ?? ?? ?? ?? 7A 40 75 3E 0F 10 03 0F 10 0F 48 8D 4D A0 F3 0F 7F 45 A0 F3 0F 7F 4D B0 E8 ?? ?? ?? ?? 48 8D 4D B0 0F 28 F0 E8 ?? ?? ?? ?? 0F 28 CE E8 ?? ?? ?? ?? 48 8D 4D C0 0F 57 D2 0F 28 C8 E8 ?? ?? ?? ?? EB 7F 0F 10 07 0F 10 0B 48 8D 4D B0 F3 0F 7F 45 B0 F3 0F 7F 4D A0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 55 A0 48 8D 4D C0 0F 28 D0 E8 ?? ?? ?? ?? 48 8D 4D D0 EB 3A 0F 10 07 48 8D 55 B0 48 8D 4D D0 F3 0F 7F 45 B0 E8 ?? ?? ?? ?? 0F 10 0B 4C 8D 45 B0 48 8D 55 A0 48 8D 4D C0 0F 10 00 F3 0F 7F 4D A0 F3 0F 7F 45 B0 E8 ?? ?? ?? ?? 48 8D 4D E0 0F 10 00 48 8D 55 B0 F3 0F 7F 45 B0 E8 ?? ?? ?? ?? 0F 10 00 0F 28 74 24 70 4C 8D 9C 24 80 00 00 00 48 8B C6 49 8B 5B 10 49 8B 7B 20 F3 0F 7F 06 49 8B 73 18 49 8B E3 5D C3 }
	condition:
		$1
}

rule file_267_0_0 {
	meta:
		name = "__sse2_exp2"
		size = 752
		refs = "0012 s_dwInvLn 001a s_dwNegRS 0026 s_dwLnHi 002e s_dwBias 0064 s_dwLnLo 0078 s_dwExp2 0096 s_dwA4 00b5 s_dwA5 00d8 s_dwA3 00e0 s_dwA2 00f8 s_dwOne 01c2 iAbsMask 01ce dbB1 01e7 dbB2 026a dbInf"
	strings:
		$1 = { 48 83 EC 68 0F 29 7C 24 40 0F 29 74 24 50 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 5C 15 ?? ?? ?? ?? 66 0F C5 C8 03 66 0F 28 E8 66 0F 58 DA 66 0F 7E D0 81 E1 FF 7F 00 00 66 0F 59 E3 66 0F C5 D2 04 81 F9 86 40 00 00 66 0F 59 1D ?? ?? ?? ?? 66 0F FE CA 66 0F C5 C8 07 66 0F 5C C4 4C 8D 05 ?? ?? ?? ?? 0F 8D 9E 00 00 00 81 E1 FF 7F 00 00 83 E0 3F 83 E2 3F 66 0F 5C C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 73 D1 06 F3 41 0F 7E 24 C0 81 F9 86 40 00 00 0F 8D 8F 00 00 00 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 E8 66 0F 59 C0 66 0F 73 F1 34 66 41 0F 16 24 D0 66 0F 59 D0 66 0F 59 D8 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 59 C3 66 0F 59 D5 66 0F 58 C5 66 0F 58 15 ?? ?? ?? ?? 66 0F EB CC 66 0F 58 C2 66 0F 59 C1 0F 28 74 24 50 0F 28 7C 24 40 48 83 C4 68 C3 66 0F 1F 84 00 00 00 00 00 83 E0 3F 83 E2 3F 66 0F 5C C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 73 D1 06 F3 41 0F 7E 24 C0 0F 1F 00 89 44 24 20 89 54 24 24 8B 44 24 20 8B 54 24 24 89 44 24 28 89 54 24 30 8B 44 24 28 8B 54 24 30 4C 8D 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 F8 66 0F 59 C0 66 0F 73 F1 34 66 41 0F 16 24 D0 66 0F 59 F0 66 0F 59 D8 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 F0 66 0F 59 C3 66 0F 59 F7 66 0F 58 C7 66 0F 58 35 ?? ?? ?? ?? 66 0F EB CC 66 0F 58 C6 66 0F 59 C8 66 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 66 0F C2 1D ?? ?? ?? ?? 01 66 0F DB CB 66 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 66 0F C2 35 ?? ?? ?? ?? 01 66 0F DF DE 66 0F DB C3 66 0F DB D3 66 0F DB E3 66 0F C5 C5 03 66 0F C5 D5 07 C1 E8 0F C1 EA 0F 66 0F FE 15 ?? ?? ?? ?? 66 0F 73 D2 06 F3 41 0F 7E BC C0 00 02 00 00 66 41 0F 16 BC D0 00 02 00 00 66 0F FE D7 66 0F 73 F2 34 66 0F EB D4 66 0F 59 C2 F3 41 0F 7E BC C0 10 02 00 00 66 41 0F 16 BC D0 10 02 00 00 66 0F 59 C7 66 0F EB C1 66 0F 28 3D ?? ?? ?? ?? 66 0F DB FD 66 0F C2 3D ?? ?? ?? ?? 01 66 0F DF F7 F3 41 0F 7E 8C C0 20 02 00 00 66 41 0F 16 8C D0 20 02 00 00 66 0F DB CE 66 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 66 0F C2 35 ?? ?? ?? ?? 00 F3 41 0F 7E BC C0 30 02 00 00 66 41 0F 16 BC D0 30 02 00 00 66 0F DB F7 66 0F EB CE 66 0F 28 35 ?? ?? ?? ?? 66 0F C2 F5 03 66 0F DB EE 66 0F EB CD 66 0F 59 C9 66 0F EB C1 0F 28 74 24 50 0F 28 7C 24 40 48 83 C4 68 C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_268_4_0 {
	meta:
		name = "_mbsncat_l"
		size = 301
		refs = "0030 _errno 003b _invalid_parameter_noinfo 0054 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 006d strncat 0094 _ismbslead_l 00df _mbsbtype_l"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 40 49 8B E8 48 8B FA 48 8B D9 4D 85 C0 75 08 48 8B C1 E9 EE 00 00 00 48 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 D2 00 00 00 48 85 D2 74 E4 48 8D 4C 24 20 49 8B D1 E8 ?? ?? ?? ?? 48 8B 44 24 28 83 78 08 00 75 16 4C 8B C5 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 48 8B F0 E9 89 00 00 00 48 8B F3 8A 03 48 FF C3 84 C0 75 F7 48 FF CB 4C 8D 44 24 20 48 8B CE 48 8B D3 E8 ?? ?? ?? ?? 85 C0 74 03 48 FF CB 48 8B 4C 24 28 0F B6 07 48 FF CD F6 44 08 19 04 88 03 74 3B 8A 47 01 48 83 C3 02 48 83 C7 02 88 43 FF 84 C0 75 33 88 43 FE 48 3B DE 74 32 8B C3 4C 8D 44 24 20 48 8B CE 2B C6 FF C8 48 63 D0 E8 ?? ?? ?? ?? 83 F8 01 75 17 C6 43 FF 00 EB 14 48 FF C3 48 FF C7 84 C0 74 D0 48 85 ED 74 CB EB A5 C6 03 00 80 7C 24 38 00 74 0C 48 8B 44 24 30 83 A0 C8 00 00 00 FD 48 8B C6 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_270_10_0 {
	meta:
		name = "_winput_s_l"
		size = 4866
		refs = "0022 __security_cookie 0081 _errno 008c _invalid_parameter_noinfo 00a5 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 00e4 iswctype 00fd _whiteout 010e _ungetwc_nolock 01c0 isdigit 0392 _fgetwc_nolock 0573 __check_float_string 082a _malloc_crt 084f wcstombs_s 0868 _cfltcvt_tab 0873 __imp_DecodePointer 088b free 09a1 memset 0d10 wctomb_s 0eda isxdigit 12ce __security_check_cookie 12fd _invoke_watson"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 40 FD FF FF 48 81 EC C0 03 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 B0 02 00 00 45 33 ED 4C 8D 7D F0 4C 89 4D C0 41 8B C5 41 0F B7 FD 48 8B DA 48 89 54 24 68 48 8B F1 48 89 4C 24 78 89 45 B8 89 7C 24 40 4C 89 7D 98 48 C7 45 A8 5E 01 00 00 44 89 6D 90 4C 89 6C 24 70 4C 89 6D 80 44 89 6C 24 50 4C 89 6D B0 48 85 D2 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 2B 12 00 00 48 85 C9 74 E3 48 8D 4D D0 49 8B D0 E8 ?? ?? ?? ?? 0F B7 03 44 88 6C 24 3C 45 8B F5 44 89 6C 24 30 44 89 6C 24 48 45 8B FD 44 89 6C 24 38 66 85 C0 0F 84 DF 11 00 00 41 BF FF FF 00 00 41 BC 25 00 00 00 BA 08 00 00 00 0F B7 C8 E8 ?? ?? ?? ?? 85 C0 74 4F 48 8D 4C 24 48 41 FF CE 48 8B D6 44 89 74 24 48 E8 ?? ?? ?? ?? 66 44 3B F8 74 0B 48 8B D6 0F B7 C8 E8 ?? ?? ?? ?? 48 83 C3 02 BA 08 00 00 00 0F B7 0B E8 ?? ?? ?? ?? 85 C0 75 EB 44 8B 74 24 48 48 89 5C 24 68 44 89 74 24 30 E9 26 10 00 00 4C 8B 54 24 68 66 45 3B 22 0F 85 CA 0F 00 00 66 45 3B 62 02 0F 84 A8 0F 00 00 45 33 DB 45 0F B7 FD 41 8B D5 4D 8B E5 45 8D 4B 01 44 89 6C 24 60 44 89 7D 88 44 89 6C 24 64 45 8B C5 44 89 6C 24 58 4C 89 6D C8 44 88 6C 24 5C 44 88 6C 24 4C 41 8A FD 41 8A F5 44 89 6D A0 45 8A E1 89 54 24 44 45 8A F3 45 8B EB 41 83 CF FF 49 83 C2 02 B8 00 FF 00 00 41 0F B7 1A 4C 89 54 24 68 66 85 D8 75 3B 0F B6 CB E8 ?? ?? ?? ?? 44 8B 44 24 58 8B 54 24 44 4C 8B 54 24 68 45 33 DB 45 8D 4B 01 85 C0 74 1A 8D 14 92 45 03 C1 8D 52 E8 44 89 44 24 58 8D 14 53 89 54 24 44 E9 D5 00 00 00 83 FB 2A 0F 84 C9 00 00 00 83 FB 46 0F 84 C3 00 00 00 83 FB 49 74 4E 83 FB 4C 74 44 83 FB 4E 0F 84 B0 00 00 00 83 FB 68 74 2E B9 6C 00 00 00 3B D9 74 0A 83 FB 77 74 1B E9 90 00 00 00 49 8D 42 02 66 39 08 75 0A 4C 8B D0 48 89 44 24 68 EB 32 45 02 E1 45 02 F1 EB 7D 45 02 E7 45 02 F7 EB 75 45 02 E1 EB 70 41 0F B7 42 02 66 83 F8 36 75 1B 49 8D 4A 04 66 83 39 34 75 11 4C 8B D1 48 89 4C 24 68 45 03 E9 4C 89 5D 80 EB 4A 66 83 F8 33 75 14 49 8D 4A 04 66 83 39 32 75 0A 4C 8B D1 48 89 4C 24 68 EB 30 66 83 E8 58 B9 20 00 00 00 66 3B C1 77 13 0F B7 C0 48 B9 01 10 82 00 01 00 00 00 48 0F A3 C1 72 BC 45 03 E9 4C 89 5D 80 41 02 F1 EB 03 41 02 F9 40 84 F6 0F 84 D0 FE FF FF 44 8B 7D 88 40 88 7C 24 34 8B 7C 24 40 8A 4C 24 34 44 88 64 24 35 4C 8B 65 C8 44 89 6C 24 54 44 8B 6D A0 84 C9 75 1A 48 8B 45 C0 48 89 45 B0 48 83 C0 08 48 89 45 C0 48 8B 40 F8 48 89 45 88 EB 04 4C 89 5D 88 41 8A DB 45 84 F6 75 25 41 0F B7 02 41 B9 EF FF 00 00 66 83 E8 43 66 41 23 C1 41 B9 01 00 00 00 66 F7 D8 45 1A F6 41 80 E6 02 41 FE CE 41 0F B7 32 B8 6E 00 00 00 83 CE 20 3B F0 74 66 83 FE 63 74 21 83 FE 7B 74 1C 48 8B 54 24 78 48 8D 4C 24 48 E8 ?? ?? ?? ?? 0F B7 F8 8B 44 24 48 89 44 24 30 EB 1C 8B 44 24 30 48 8B 4C 24 78 41 03 C1 89 44 24 30 89 44 24 48 E8 ?? ?? ?? ?? 0F B7 F8 B8 FF FF 00 00 89 7C 24 40 66 3B C7 0F 84 86 0E 00 00 8B 54 24 44 4C 8B 54 24 68 44 8B 44 24 58 8A 4C 24 34 45 85 C0 74 08 85 D2 0F 84 A4 0D 00 00 84 C9 75 50 8D 46 9D A9 E7 FF FF FF 75 46 83 FE 6B 74 41 4C 8B 4D B0 49 8B 01 49 83 C1 08 45 8B 21 4D 8B D9 4C 89 4D B0 49 83 C1 08 48 89 45 88 4C 89 4D C0 41 B9 01 00 00 00 4D 3B E1 73 1F 45 84 F6 0F 8E 84 0D 00 00 45 33 F6 66 44 89 30 E9 7E 0D 00 00 4C 8B 5D B0 41 B9 01 00 00 00 83 FE 6F 0F 8F AE 04 00 00 0F 84 AF 09 00 00 83 FE 63 0F 84 7D 04 00 00 83 FE 64 0F 84 9D 09 00 00 0F 8E B9 04 00 00 83 FE 67 7E 60 83 FE 69 74 3E B8 6E 00 00 00 3B F0 0F 85 A2 04 00 00 44 8B 74 24 30 45 33 ED 41 8B C6 84 C9 0F 85 19 04 00 00 44 8B 64 24 54 45 85 E4 0F 84 4E 0C 00 00 48 8B 45 88 48 8B 4D 80 48 89 08 E9 FB 03 00 00 BE 64 00 00 00 B8 2D 00 00 00 66 3B C7 0F 85 FC 05 00 00 44 88 4C 24 4C E9 FC 05 00 00 45 33 ED 41 8B DD 41 8D 4D 2D 66 3B CF 75 0C 48 8B 45 98 49 8B D9 66 89 08 EB 0A B8 2B 00 00 00 66 3B C7 75 2B 4C 8B 64 24 78 44 8B 7C 24 44 44 8B 74 24 30 49 8B CC 45 2B F9 45 03 F1 E8 ?? ?? ?? ?? 44 8B 44 24 58 0F B7 F8 89 7C 24 40 EB 0F 44 8B 74 24 30 44 8B 7C 24 44 4C 8B 64 24 78 45 85 C0 B8 FF FF FF FF 44 0F 44 F8 B8 00 FF 00 00 66 85 F8 75 72 BE 01 00 00 00 0F B7 C7 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 74 5E 41 8B C7 44 2B FE 85 C0 74 54 48 8B 4D 98 01 74 24 64 40 0F BE C7 66 89 04 59 48 8D 45 90 48 03 DE 4C 8D 4D F0 4C 8D 45 98 48 8D 55 A8 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 28 0C 00 00 49 8B CC 44 03 F6 E8 ?? ?? ?? ?? 0F B7 F8 B8 00 FF 00 00 89 7C 24 40 66 85 F8 74 93 48 8B 45 D0 BA 01 00 00 00 48 8B 88 F0 00 00 00 48 8B 41 58 0F B7 30 40 0F BE C7 8B CE 3B F0 0F 85 C3 00 00 00 41 8B C7 44 2B FA 85 C0 0F 84 B5 00 00 00 49 8B CC 44 03 F2 E8 ?? ?? ?? ?? 4C 8D 4D F0 4C 8D 45 98 0F B7 F8 48 8B 45 98 48 8D 55 A8 66 89 34 58 48 8D 45 90 BE 01 00 00 00 48 03 DE 89 7C 24 40 48 89 44 24 20 48 8B CB E8 ?? ?? ?? ?? 85 C0 0F 84 92 0B 00 00 EB 5F 0F B7 C7 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 74 5A 41 8B C7 44 2B FE 85 C0 74 50 48 8B 45 98 01 74 24 64 4C 8D 4D F0 66 89 3C 58 48 8D 45 90 48 03 DE 4C 8D 45 98 48 8D 55 A8 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 43 0B 00 00 49 8B CC 44 03 F6 E8 ?? ?? ?? ?? 0F B7 F8 89 7C 24 40 B8 00 FF 00 00 66 85 F8 74 97 48 8B D6 8B 74 24 64 85 F6 0F 84 31 01 00 00 8D 47 BB B9 DF FF 00 00 66 85 C1 0F 85 20 01 00 00 41 8B C7 44 2B FA 85 C0 0F 84 12 01 00 00 48 8B 45 98 B9 65 00 00 00 4C 8D 4D F0 66 89 0C 58 48 03 DA 48 8D 45 90 48 8D 55 A8 4C 8D 45 98 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 C4 0A 00 00 49 8B CC 41 FF C6 E8 ?? ?? ?? ?? B9 2D 00 00 00 0F B7 F8 89 7C 24 40 66 3B C8 75 32 48 8B 45 98 4C 8D 4D F0 4C 8D 45 98 66 89 0C 58 48 8D 45 90 48 FF C3 48 8D 55 A8 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 78 0A 00 00 EB 0A B8 2B 00 00 00 66 3B C7 75 7B 41 8B C7 B9 01 00 00 00 44 2B F9 85 C0 75 05 45 8B FD EB 67 44 03 F1 EB 53 0F B7 C7 0F B6 C8 E8 ?? ?? ?? ?? 85 C0 74 5D 41 8B C7 B9 01 00 00 00 44 2B F9 85 C0 74 4E 48 8B 45 98 03 F1 4C 8D 4D F0 66 89 3C 58 48 03 D9 48 8D 45 90 4C 8D 45 98 48 8D 55 A8 48 8B CB 48 89 44 24 20 E8 ?? ?? ?? ?? 85 C0 0F 84 03 0A 00 00 41 FF C6 49 8B CC E8 ?? ?? ?? ?? 0F B7 F8 89 7C 24 40 B8 00 FF 00 00 66 85 F8 74 94 B8 01 00 00 00 41 BF FF FF 00 00 44 2B F0 44 89 74 24 30 44 89 74 24 48 66 44 3B FF 74 10 49 8B D4 0F B7 CF E8 ?? ?? ?? ?? B8 01 00 00 00 85 F6 0F 84 91 09 00 00 44 38 6C 24 34 0F 85 97 00 00 00 44 8B 6C 24 38 4C 8B 7D 98 45 33 E4 44 03 E8 48 8B 45 A8 66 45 89 24 5F 48 8D 1C 45 02 00 00 00 44 89 6C 24 38 48 8B CB E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 0F 84 06 0A 00 00 48 8D 43 FF 4D 8B CF 4C 8B C3 48 8B D6 33 C9 48 89 44 24 20 E8 ?? ?? ?? ?? 83 F8 16 0F 84 91 0A 00 00 83 F8 22 0F 84 88 0A 00 00 48 8B 0D ?? ?? ?? ?? 0F BE 5C 24 35 FF 15 ?? ?? ?? ?? 48 8B 55 88 4C 8D 4D D0 8D 4B FF 4C 8B C6 FF D0 48 8B CE E8 ?? ?? ?? ?? 45 33 ED 41 BF FF FF 00 00 48 8B 5C 24 68 48 8B 74 24 78 B8 01 00 00 00 00 44 24 3C 48 83 C3 02 44 8D 60 24 48 89 5C 24 68 E9 8D 08 00 00 45 85 C0 75 0C 41 03 D1 44 89 4C 24 58 89 54 24 44 45 84 F6 0F 8E 17 03 00 00 45 8A E9 E9 0F 03 00 00 83 FE 70 0F 84 E8 04 00 00 83 FE 73 0F 84 F2 02 00 00 83 FE 75 0F 84 EC 04 00 00 83 FE 78 0F 84 99 FB FF FF 83 FE 7B 74 2D 41 BF FF FF 00 00 66 41 39 3A 0F 85 9E 08 00 00 FE 4C 24 3C 44 8B 74 24 30 45 33 ED 84 C9 0F 85 6C FF FF FF 4C 89 5D C0 E9 63 FF FF FF 45 84 F6 45 0F B6 ED B8 5E 00 00 00 45 0F 4F E9 49 83 C2 02 44 89 6D A0 4C 89 54 24 68 66 41 3B 02 75 0E 49 83 C2 02 C6 44 24 5C FF 4C 89 54 24 68 48 8B 5C 24 70 45 33 F6 48 85 DB 75 22 B9 00 20 00 00 E8 ?? ?? ?? ?? 48 8B D8 48 89 44 24 70 48 85 C0 0F 84 8D 08 00 00 41 8D 46 01 89 45 B8 33 D2 41 B8 00 20 00 00 48 8B CB E8 ?? ?? ?? ?? 4C 8B 54 24 68 BA 5D 00 00 00 66 41 3B 12 75 0D 8D 42 C3 44 8B FA 49 83 C2 02 88 43 0B 41 0F B7 02 41 B9 01 00 00 00 66 3B D0 0F 84 BD 00 00 00 45 8D 69 2C 49 83 C2 02 66 44 3B E8 75 7C 66 45 85 FF 74 76 41 0F B7 0A 66 3B D1 74 6D 49 83 C2 02 4C 89 54 24 68 66 44 3B F9 73 06 44 0F B7 C9 EB 08 45 0F B7 CF 44 0F B7 F9 41 BB 01 00 00 00 66 45 3B F9 73 2D 45 0F B7 D7 41 0F B7 CF 4D 8B C2 41 8B D3 83 E1 07 49 C1 E8 03 66 45 03 FB D2 E2 4D 03 D3 41 08 14 18 66 45 3B F9 72 DC 4C 8B 54 24 68 45 0F B7 C1 41 0F B7 C1 41 8B D3 41 B9 01 00 00 00 45 0F B7 FE EB 0E 44 0F B7 F8 44 0F B7 C0 41 8B D1 0F B7 C0 83 E0 07 49 C1 E8 03 8A C8 D2 E2 41 08 14 18 41 0F B7 02 BA 5D 00 00 00 66 3B D0 0F 85 4B FF FF FF 44 8B 6D A0 66 45 39 32 0F 84 85 07 00 00 4C 89 54 24 68 E9 48 01 00 00 B8 2B 00 00 00 66 3B C7 75 11 41 2B D1 89 54 24 44 75 7D 45 85 C0 74 78 41 8A D9 4C 8B 7C 24 78 44 8B 74 24 30 B8 30 00 00 00 66 3B C7 0F 85 7B 03 00 00 44 8D 60 D1 49 8B CF 45 03 F4 44 89 74 24 30 44 89 74 24 48 E8 ?? ?? ?? ?? 0F B7 F8 B9 DF FF 00 00 8D 47 A8 89 7C 24 40 66 85 C1 0F 84 8E 00 00 00 45 8B EC 83 FE 78 74 4F 44 8B 7C 24 44 33 C9 39 4C 24 58 74 08 45 2B FC 75 03 41 02 DC 44 8B 64 24 54 BE 6F 00 00 00 E9 2F 03 00 00 44 8B 74 24 30 4C 8B 7C 24 78 45 03 F1 49 8B CF 44 89 74 24 30 44 89 74 24 48 E8 ?? ?? ?? ?? 0F B7 F8 89 7C 24 40 E9 6A FF FF FF 45 2B F4 B8 FF FF 00 00 44 89 74 24 30 44 89 74 24 48 66 3B C7 74 0B 49 8B D7 0F B7 CF E8 ?? ?? ?? ?? 44 8B 64 24 54 B8 30 00 00 00 8B F8 89 44 24 40 E9 C6 02 00 00 45 03 F4 49 8B CF 44 89 74 24 30 44 89 74 24 48 E8 ?? ?? ?? ?? 33 C9 0F B7 F8 89 7C 24 40 39 4C 24 58 74 13 8B 44 24 44 83 E8 02 89 44 24 44 41 3B C4 7D 03 41 02 DC 44 8B 64 24 54 44 8B 6C 24 64 BE 78 00 00 00 E9 7D 02 00 00 45 0F B6 ED 45 84 F6 45 0F 4F E9 44 8B 74 24 30 48 8B 5D 88 BA 01 00 00 00 44 2B F2 B8 FF FF 00 00 44 89 74 24 30 44 89 74 24 48 66 3B C7 74 12 48 8B 54 24 78 0F B7 CF E8 ?? ?? ?? ?? BA 01 00 00 00 83 FE 63 74 03 4C 2B E2 44 8A 7C 24 5C 45 33 DB 44 39 5C 24 58 74 14 8B 4C 24 44 8B C1 2B CA 89 4C 24 44 85 C0 0F 84 33 01 00 00 48 8B 4C 24 78 44 03 F2 44 89 74 24 30 44 89 74 24 48 E8 ?? ?? ?? ?? 0F B7 F8 B8 FF FF 00 00 89 7C 24 40 66 3B C7 0F 84 CE 00 00 00 83 FE 63 74 48 83 FE 73 75 15 8D 47 F7 66 83 F8 04 0F 86 B7 00 00 00 8D 46 AD 66 3B F8 75 2E 83 FE 7B 0F 85 A6 00 00 00 48 8B 4C 24 70 0F B7 C7 0F B7 D7 48 C1 E8 03 83 E2 07 0F BE 0C 08 41 0F BE C7 33 C8 0F A3 D1 0F 83 81 00 00 00 45 33 DB 44 38 5C 24 34 75 69 4D 85 E4 0F 84 FD 04 00 00 45 84 ED 74 1B 48 8B 4D 88 41 8D 53 01 66 89 39 48 83 C1 02 4C 2B E2 48 89 4D 88 E9 39 FF FF FF 48 8B 55 88 48 8D 4D A0 44 0F B7 CF 4D 8B C4 44 89 5D A0 E8 ?? ?? ?? ?? 83 F8 22 0F 84 BC 04 00 00 48 63 45 A0 45 33 DB 41 8D 53 01 85 C0 0F 8E 05 FF FF FF 48 01 45 88 4C 2B E0 E9 F9 FE FF FF 48 83 C3 02 BA 01 00 00 00 E9 EB FE FF FF BA 01 00 00 00 41 BF FF FF 00 00 44 2B F2 44 89 74 24 30 44 89 74 24 48 66 44 3B FF 74 16 48 8B 54 24 78 0F B7 CF E8 ?? ?? ?? ?? 45 33 DB 41 8D 53 01 EB 0B 45 33 DB EB 06 41 BF FF FF 00 00 48 8B 45 88 48 3B D8 0F 84 F1 03 00 00 44 38 5C 24 34 0F 85 54 03 00 00 01 54 24 38 83 FE 63 0F 84 E1 FA FF FF 41 BF FF FF 00 00 45 84 ED 74 0C 45 33 ED 66 44 89 28 E9 D3 FA FF FF 45 33 ED 44 88 28 E9 C8 FA FF FF 44 8B 64 24 54 44 88 4C 24 35 45 03 E1 45 33 F6 4C 89 75 80 EB 05 44 8B 64 24 54 B8 2D 00 00 00 66 3B C7 75 07 44 88 4C 24 4C EB 0A B8 2B 00 00 00 66 3B C7 75 53 41 2B D1 89 54 24 44 75 14 45 85 C0 74 0F 44 8B 6C 24 64 41 8A D9 44 8B FA 33 C9 EB 42 44 8B 74 24 30 48 8B 4C 24 78 45 03 F1 44 89 74 24 30 44 89 74 24 48 E8 ?? ?? ?? ?? 44 8B 7C 24 44 44 8B 6C 24 64 0F B7 F8 89 7C 24 40 33 C9 EB 16 44 8B 64 24 54 44 8B 6C 24 64 33 C9 44 8B 7C 24 44 44 8B 74 24 30 45 85 E4 0F 84 1E 01 00 00 84 DB 48 8B 5D 80 0F 85 F8 00 00 00 8D 46 90 A9 F7 FF FF FF B8 00 FF 00 00 74 3E 66 85 F8 0F 85 B8 00 00 00 0F B7 C7 0F B6 C8 E8 ?? ?? ?? ?? 33 C9 85 C0 0F 84 A3 00 00 00 83 FE 6F 75 12 8D 41 38 66 3B C7 0F 86 92 00 00 00 48 C1 E3 03 EB 45 48 8D 1C 9B 48 03 DB EB 3C 66 85 F8 75 7E 0F B7 C7 0F B6 D8 8B CB E8 ?? ?? ?? ?? 33 C9 85 C0 74 6B 48 C1 65 80 04 8B CB E8 ?? ?? ?? ?? 48 8B 5D 80 85 C0 75 10 B8 DF FF 00 00 66 23 F8 66 83 EF 07 89 7C 24 40 0F B7 C7 B9 01 00 00 00 83 E8 30 44 03 E9 48 98 48 03 D8 33 C0 48 89 5D 80 39 44 24 58 74 05 44 2B F9 74 4B 44 03 F1 48 8B 4C 24 78 44 89 74 24 30 44 89 74 24 48 E8 ?? ?? ?? ?? 0F B7 F8 89 7C 24 40 E9 30 FF FF FF 41 FF CE B8 FF FF 00 00 44 89 74 24 30 44 89 74 24 48 66 3B C7 74 0D 48 8B 54 24 78 0F B7 CF E8 ?? ?? ?? ?? 48 8B 5D 80 45 33 DB 44 38 5C 24 4C 0F 84 25 01 00 00 48 F7 DB 48 89 5D 80 E9 19 01 00 00 84 DB 8B 5C 24 60 0F 85 FD 00 00 00 8D 46 90 A9 F7 FF FF FF B8 00 FF 00 00 74 3C 66 85 F8 0F 85 BD 00 00 00 0F B7 C7 0F B6 C8 E8 ?? ?? ?? ?? 33 C9 85 C0 0F 84 A8 00 00 00 83 FE 6F 75 11 8D 41 38 66 3B C7 0F 86 97 00 00 00 C1 E3 03 EB 4E 8D 04 9B 8D 1C 00 EB 46 66 85 F8 0F 85 81 00 00 00 0F B7 C7 0F B6 D8 8B CB E8 ?? ?? ?? ?? 33 C9 }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "strpbrk"
		size = 161
		refs = "0007 __security_cookie 008d __security_check_cookie 009c __report_rangecheckfailure"
	strings:
		$1 = { 48 83 EC 58 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 40 33 C0 4C 8B D2 4C 8B C9 48 83 F8 20 73 7A C6 44 04 20 00 48 FF C0 48 83 F8 20 7C F0 8A 02 EB 22 44 0F B6 C0 0F B6 C0 BA 01 00 00 00 83 E0 07 49 C1 E8 03 8A C8 D2 E2 42 08 54 04 20 49 FF C2 41 8A 02 84 C0 75 DA EB 1F 41 0F B6 C8 41 0F B6 C0 BA 01 00 00 00 83 E1 07 48 C1 E8 03 D3 E2 84 54 04 20 75 1F 49 FF C1 45 8A 01 45 84 C0 75 D9 33 C0 48 8B 4C 24 40 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 58 C3 49 8B C1 EB E9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_272_0_0 {
	meta:
		name = "_dospawn"
		size = 664
		refs = "004d __doserrno 0054 _errno 005f _invalid_parameter_noinfo 0091 memset 009a _nhandle 00a1 __pioinfo 0100 _calloc_crt 01f3 __imp_CreateProcessA 01fb __imp_GetLastError 0207 free 0213 _dosmaperr 022d __imp_WaitForSingleObject 023b __imp_GetExitCodeProcess 0255 __imp_CloseHandle 0293 _exit"
	strings:
		$1 = { 4C 89 4C 24 20 48 89 54 24 10 55 53 57 41 54 41 55 41 56 41 57 48 8D 6C 24 D9 48 81 EC F0 00 00 00 33 FF 44 8B F1 8D 47 04 44 8D 7F 03 89 7D 67 44 8A EF 83 F9 01 76 0E 7E 12 41 3B CF 7E 07 3B C8 75 09 41 B5 01 4C 89 45 A7 EB 31 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 11 02 00 00 49 FF C0 41 38 38 75 F8 41 38 78 01 74 07 41 C6 00 20 49 FF C0 41 38 38 75 E6 BB 68 00 00 00 48 8D 4D B7 33 D2 44 8B C3 E8 ?? ?? ?? ?? 89 5D B7 8B 1D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 85 DB 74 27 8D 53 FF 48 63 CA 48 8B C1 83 E1 1F 48 C1 F8 05 48 6B C9 58 49 8B 04 C0 40 38 7C 08 08 75 06 FF CA FF CB 75 DE 85 DB 0F 88 98 01 00 00 4C 63 E3 49 81 FC 71 1C 00 00 0F 83 88 01 00 00 0F B7 C3 8D 4B 04 BA 01 00 00 00 66 C1 E0 03 66 03 C8 66 89 4D F9 0F B7 C9 E8 ?? ?? ?? ?? 48 89 45 FF 48 85 C0 0F 84 5D 01 00 00 89 18 48 8B 45 FF 4C 8D 40 04 48 8D 50 04 4D 03 C4 85 DB 7E 4E 4C 8B CF 44 8B D3 4C 8D 1D ?? ?? ?? ?? 49 8B C1 49 8B C9 83 E0 1F 48 C1 F9 05 48 6B C0 58 49 03 04 CB 8A 48 08 F6 C1 10 75 0A 88 0A 48 8B 00 49 89 00 EB 07 40 88 3A 49 83 08 FF 49 FF C1 48 FF C2 49 83 C0 08 49 FF CA 75 C3 48 8B 45 FF 45 84 ED 74 34 48 8D 50 04 48 8D 48 04 49 03 D4 41 3B DF 44 0F 4C FB 45 85 FF 7E 16 41 8B C7 40 88 39 48 83 0A FF 48 FF C1 48 8D 52 08 48 FF C8 75 ED C7 45 67 08 00 00 00 E8 ?? ?? ?? ?? 48 8B 55 A7 48 8B 4D 6F 89 38 48 8D 45 8F 45 33 C9 48 89 44 24 48 48 8D 45 B7 45 33 C0 48 89 44 24 40 48 8B 45 7F 48 89 7C 24 38 48 89 44 24 30 8B 45 67 89 44 24 28 C7 44 24 20 01 00 00 00 FF 15 ?? ?? ?? ?? 8B D8 FF 15 ?? ?? ?? ?? 48 8B 4D FF 44 8B F8 E8 ?? ?? ?? ?? 85 DB 75 0A 41 8B CF E8 ?? ?? ?? ?? EB 60 41 83 FE 02 74 71 45 85 F6 75 21 48 8B 4D 8F 83 CA FF FF 15 ?? ?? ?? ?? 48 8B 4D 8F 48 8D 55 87 FF 15 ?? ?? ?? ?? 48 63 7D 87 EB 0A B8 04 00 00 00 44 3B F0 75 0C 48 8B 4D 8F FF 15 ?? ?? ?? ?? EB 04 48 8B 7D 8F 48 8B 4D 97 FF 15 ?? ?? ?? ?? 48 8B C7 EB 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 48 83 C8 FF 48 81 C4 F0 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5B 5D C3 33 C9 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_273_0_0 {
	meta:
		name = "__DestructExceptionObject"
		size = 110
		refs = "004d ?terminate@@YAXXZ"
	strings:
		$1 = { 48 85 C9 74 68 88 54 24 10 48 83 EC 28 81 39 63 73 6D E0 75 54 83 79 18 04 75 4E 8B 41 20 2D 20 05 93 19 83 F8 02 77 41 48 8B 41 30 48 85 C0 74 38 48 63 50 04 85 D2 74 19 48 8B C2 48 8B 51 38 48 03 D0 48 8B 49 28 FF D2 90 EB 1D E8 ?? ?? ?? ?? 90 F6 00 10 74 12 48 8B 41 28 48 8B 08 48 85 C9 74 06 48 8B 01 FF 50 10 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_5_0 {
	meta:
		name = "?CatchIt@@YAXPEAUEHExceptionRecord@@PEA_KPEAU_CONTEXT@@PEAU_xDISPATCHER_CONTEXT@@PEBU_s_FuncInfo@@PEBU_s_HandlerType@@PEBU_s_CatchableType@@PEBU_s_TryBlockMapEntry@@H1EE@Z"
		size = 193
		refs = "0039 ?_GetEstablisherFrame@@YAPEA_KPEA_KPEAU_xDISPATCHER_CONTEXT@@PEBU_s_FuncInfo@@0@Z 005f __BuildCatchObject 0064 _GetImageBase 00a4 _UnwindNestedFrames"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 18 56 57 41 54 41 56 41 57 48 83 EC 50 4C 8B BC 24 A0 00 00 00 49 8B E9 4C 8B F2 4D 8B E0 48 8B D9 4C 8D 48 10 4D 8B C7 48 8B D5 49 8B CE E8 ?? ?? ?? ?? 4C 8B 8C 24 B0 00 00 00 48 8B B4 24 A8 00 00 00 48 8B F8 4D 85 C9 74 0E 4C 8B C6 48 8B D0 48 8B CB E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 63 4E 0C 4C 8B CF 48 03 C1 8A 8C 24 D8 00 00 00 4D 8B C4 88 4C 24 40 48 8B 8C 24 B8 00 00 00 48 89 6C 24 38 8B 11 4C 89 7C 24 30 49 8B CE 89 54 24 28 48 8B D3 48 89 44 24 20 E8 ?? ?? ?? ?? 4C 8D 5C 24 50 49 8B 5B 30 49 8B 6B 40 49 8B E3 41 5F 41 5E 41 5C 5F 5E C3 }
	condition:
		$1
}

rule file_273_6_0 {
	meta:
		name = "?ExFilterRethrow@@YAHPEAU_EXCEPTION_POINTERS@@PEAUEHExceptionRecord@@PEAH@Z"
		size = 137
		refs = "006c _getptd"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 4C 8B 09 41 83 20 00 49 8B D8 41 B8 63 73 6D E0 45 39 01 75 5D 41 83 79 18 04 BF 01 00 00 00 41 BA 20 05 93 19 75 1B 41 8B 41 20 41 2B C2 83 F8 02 77 0F 48 8B 42 28 8B 0B 49 39 41 28 0F 44 CF 89 0B 45 39 01 75 2B 41 83 79 18 04 75 24 41 8B 49 20 41 2B CA 83 F9 02 77 18 49 83 79 30 00 75 11 E8 ?? ?? ?? ?? 89 B8 60 04 00 00 89 3B 8B C7 EB 02 33 C0 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_273_7_0 {
	meta:
		name = "?FindHandler@@YAXPEAUEHExceptionRecord@@PEA_KPEAU_CONTEXT@@PEAU_xDISPATCHER_CONTEXT@@PEBU_s_FuncInfo@@EH1@Z"
		size = 1204
		refs = "0043 ?__StateFromControlPc@@YAHPEBU_s_FuncInfo@@PEAU_xDISPATCHER_CONTEXT@@@Z 0057 ?_GetEstablisherFrame@@YAPEA_KPEA_KPEAU_xDISPATCHER_CONTEXT@@PEBU_s_FuncInfo@@0@Z 0065 ?__GetUnwindTryBlock@@YAHPEA_KPEAU_xDISPATCHER_CONTEXT@@PEBU_s_FuncInfo@@@Z 007b ?__SetState@@YAXPEA_KPEAU_xDISPATCHER_CONTEXT@@PEBU_s_FuncInfo@@H@Z 008c ?__SetUnwindTryBlock@@YAXPEA_KPEAU_xDISPATCHER_CONTEXT@@PEBU_s_FuncInfo@@H@Z 00a7 ?_inconsistency@@YAXXZ 00dd _getptd 0113 _SetThrowImageBase 0120 ?_ValidateRead@@YAHPEBXI@Z 0184 ?IsInExceptionSpec@@YAEPEAUEHExceptionRecord@@PEBU_s_ESTypeList@@@Z 019c _GetImageBase 01cf ??_R0?AVbad_exception@std@@@8 01d7 ??8type_info@@QEBA_NAEBV0@@Z 024e ?_GetRangeOfTrysToCheck@@YAPEBU_s_TryBlockMapEntry@@PEA_KPEBU_s_FuncInfo@@HHPEAI2PEAU_xDISPATCHER_CONTEXT@@@Z 0293 _GetThrowImageBase 02df __TypeMatch 034f ?CatchIt@@YAXPEAUEHExceptionRecord@@PEA_KPEAU_CONTEXT@@PEAU_xDISPATCHER_CONTEXT@@PEBU_s_FuncInfo@@PEBU_s_HandlerType@@PEBU_s_CatchableType@@PEBU_s_TryBlockMapEntry@@H1EE@Z 0400 _UnwindNestedFrames 0464 ?FindHandlerForForeignException@@YAXPEAUEHExceptionRecord@@PEA_KPEAU_CONTEXT@@PEAU_xDISPATCHER_CONTEXT@@PEBU_s_FuncInfo@@HH1@Z 046b ?terminate@@YAXXZ 0476 __DestructExceptionObject 047d ??_C@_0O@DPKOEFFH@bad?5exception?$AA@ 048e ??0exception@std@@QEAA@AEBQEBD@Z 0495 ??_7bad_exception@std@@6B@ 049c _TI2?AVbad_exception@std@@ 04a9 _CxxThrowException"
	strings:
		$1 = { 48 89 5C 24 10 4C 89 44 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8D 6C 24 F9 48 81 EC B0 00 00 00 48 8B 5D 67 4C 8B EA 48 8B F9 45 33 E4 49 8B D1 48 8B CB 4D 8B F9 4D 8B F0 44 88 65 47 44 88 65 B7 E8 ?? ?? ?? ?? 4C 8D 4D DF 4C 8B C3 49 8B D7 49 8B CD 8B F0 E8 ?? ?? ?? ?? 4C 8B C3 49 8B D7 49 8B CD E8 ?? ?? ?? ?? 4C 8B C3 49 8B D7 3B F0 7E 1F 48 8D 4D DF 44 8B CE E8 ?? ?? ?? ?? 44 8B CE 4C 8B C3 49 8B D7 49 8B CD E8 ?? ?? ?? ?? EB 0A 49 8B CD E8 ?? ?? ?? ?? 8B F0 83 FE FF 7C 05 3B 73 04 7C 05 E8 ?? ?? ?? ?? 81 3F 63 73 6D E0 0F 85 7B 03 00 00 83 7F 18 04 0F 85 37 01 00 00 8B 47 20 2D 20 05 93 19 83 F8 02 0F 87 26 01 00 00 4C 39 67 30 0F 85 1C 01 00 00 E8 ?? ?? ?? ?? 4C 39 A0 F0 00 00 00 0F 84 29 03 00 00 E8 ?? ?? ?? ?? 48 8B B8 F0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4F 38 4C 8B B0 F8 00 00 00 C6 45 47 01 4C 89 75 57 E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF E8 ?? ?? ?? ?? 85 C0 75 05 E8 ?? ?? ?? ?? 81 3F 63 73 6D E0 75 1E 83 7F 18 04 75 18 8B 47 20 2D 20 05 93 19 83 F8 02 77 0B 4C 39 67 30 75 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 39 A0 08 01 00 00 0F 84 93 00 00 00 E8 ?? ?? ?? ?? 4C 8B B0 08 01 00 00 E8 ?? ?? ?? ?? 49 8B D6 48 8B CF 4C 89 A0 08 01 00 00 E8 ?? ?? ?? ?? 84 C0 75 68 45 8B FC 45 39 26 0F 8E D2 02 00 00 49 8B F4 E8 ?? ?? ?? ?? 49 63 4E 04 48 03 C6 44 39 64 01 04 74 1B E8 ?? ?? ?? ?? 49 63 4E 04 48 03 C6 48 63 5C 01 04 E8 ?? ?? ?? ?? 48 03 C3 EB 03 49 8B C4 48 8D 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 84 C0 0F 85 8D 02 00 00 41 FF C7 48 83 C6 14 45 3B 3E 7C AC E9 76 02 00 00 4C 8B 75 57 81 3F 63 73 6D E0 0F 85 2E 02 00 00 83 7F 18 04 0F 85 24 02 00 00 8B 47 20 2D 20 05 93 19 83 F8 02 0F 87 13 02 00 00 44 39 63 0C 0F 86 4E 01 00 00 44 8B 45 77 48 8D 45 BF 4C 89 7C 24 30 48 89 44 24 28 48 8D 45 BB 44 8B CE 48 8B D3 49 8B CD 48 89 44 24 20 E8 ?? ?? ?? ?? 8B 4D BB 8B 55 BF 3B CA 0F 83 17 01 00 00 4C 8D 70 10 41 39 76 F0 0F 8F EB 00 00 00 41 3B 76 F4 0F 8F E1 00 00 00 E8 ?? ?? ?? ?? 4D 63 26 4C 03 E0 41 8B 46 FC 89 45 C3 85 C0 0F 8E C1 00 00 00 E8 ?? ?? ?? ?? 48 8B 4F 30 48 63 51 0C 48 83 C0 04 48 03 C2 48 89 45 CF E8 ?? ?? ?? ?? 48 8B 4F 30 48 63 51 0C 8B 0C 10 89 4D C7 85 C9 7E 37 E8 ?? ?? ?? ?? 48 8B 4D CF 4C 8B 47 30 48 63 09 48 03 C1 49 8B CC 48 8B D0 48 89 45 D7 E8 ?? ?? ?? ?? 85 C0 75 1C 8B 45 C7 48 83 45 CF 04 FF C8 89 45 C7 85 C0 7F C9 8B 45 C3 FF C8 49 83 C4 14 EB 84 8A 45 6F 4C 8B 45 57 4D 8B CF 88 44 24 58 8A 45 47 49 8B D5 88 44 24 50 48 8B 45 7F 48 8B CF 48 89 44 24 48 8B 45 77 C6 45 B7 01 89 44 24 40 49 8D 46 F0 48 89 44 24 38 48 8B 45 D7 48 89 44 24 30 4C 89 64 24 28 48 89 5C 24 20 E8 ?? ?? ?? ?? 8B 55 BF 8B 4D BB FF C1 49 83 C6 14 89 4D BB 3B CA 0F 82 FA FE FF FF 45 33 E4 44 38 65 B7 0F 85 8D 00 00 00 8B 03 25 FF FF FF 1F 3D 21 05 93 19 72 7F 8B 73 20 85 F6 74 0D 48 63 F6 E8 ?? ?? ?? ?? 48 03 C6 EB 03 49 8B C4 48 85 C0 74 63 85 F6 74 11 E8 ?? ?? ?? ?? 48 8B D0 48 63 43 20 48 03 D0 EB 03 49 8B D4 48 8B CF E8 ?? ?? ?? ?? 84 C0 75 3F 4C 8D 4D 47 4C 8B C3 49 8B D7 49 8B CD E8 ?? ?? ?? ?? 8A 4D 6F 4C 8B 45 57 88 4C 24 40 4C 89 7C 24 38 48 89 5C 24 30 83 4C 24 28 FF 4C 8B C8 48 8B D7 49 8B CD 4C 89 64 24 20 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 39 A0 08 01 00 00 74 05 E8 ?? ?? ?? ?? 48 8B 9C 24 F8 00 00 00 48 81 C4 B0 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 44 39 63 0C 76 CC 44 38 65 6F 75 70 48 8B 45 7F 4D 8B CF 4D 8B C6 48 89 44 24 38 8B 45 77 49 8B D5 89 44 24 30 48 8B CF 89 74 24 28 48 89 5C 24 20 E8 ?? ?? ?? ?? EB 9A E8 ?? ?? ?? ?? CC B2 01 48 8B CF E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8D 55 47 48 8D 4D E7 48 89 45 47 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4D E7 48 89 45 E7 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_273_8_0 {
	meta:
		name = "?FindHandlerForForeignException@@YAXPEAUEHExceptionRecord@@PEA_KPEAU_CONTEXT@@PEAU_xDISPATCHER_CONTEXT@@PEBU_s_FuncInfo@@HH1@Z"
		size = 613
		refs = "0032 _getptd 004c __imp_EncodePointer 009b _CallSETranslator 00b7 ?_inconsistency@@YAXXZ 00ec ?_GetRangeOfTrysToCheck@@YAPEBU_s_TryBlockMapEntry@@PEA_KPEBU_s_FuncInfo@@HHPEAI2PEAU_xDISPATCHER_CONTEXT@@@Z 011e _GetImageBase 022b ?CatchIt@@YAXPEAUEHExceptionRecord@@PEA_KPEAU_CONTEXT@@PEAU_xDISPATCHER_CONTEXT@@PEBU_s_FuncInfo@@PEBU_s_HandlerType@@PEBU_s_CatchableType@@PEBU_s_TryBlockMapEntry@@H1EE@Z"
	strings:
		$1 = { 48 89 5C 24 10 4C 89 44 24 18 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 70 81 39 03 00 00 80 4D 8B F9 49 8B F8 4C 8B E2 48 8B F1 0F 84 1C 02 00 00 E8 ?? ?? ?? ?? 48 8B AC 24 D0 00 00 00 48 83 B8 E0 00 00 00 00 74 61 33 C9 FF 15 ?? ?? ?? ?? 48 8B D8 E8 ?? ?? ?? ?? 48 39 98 E0 00 00 00 74 48 81 3E 4D 4F 43 E0 74 40 81 3E 52 43 43 E0 8B 9C 24 E0 00 00 00 74 38 48 8B 84 24 E8 00 00 00 4D 8B CF 4C 8B C7 48 89 44 24 30 49 8B D4 48 8B CE 89 5C 24 28 48 89 6C 24 20 E8 ?? ?? ?? ?? 85 C0 0F 85 A6 01 00 00 EB 07 8B 9C 24 E0 00 00 00 83 7D 0C 00 75 05 E8 ?? ?? ?? ?? 44 8B B4 24 D8 00 00 00 48 8D 44 24 60 4C 89 7C 24 30 48 89 44 24 28 48 8D 84 24 B0 00 00 00 44 8B C3 45 8B CE 48 8B D5 49 8B CC 48 89 44 24 20 E8 ?? ?? ?? ?? 8B 8C 24 B0 00 00 00 3B 4C 24 60 0F 83 4C 01 00 00 48 8D 78 0C 4C 8D 6F F4 45 3B 75 00 0F 8C 23 01 00 00 44 3B 77 F8 0F 8F 19 01 00 00 E8 ?? ?? ?? ?? 48 63 0F 48 8D 14 89 48 63 4F 04 48 8D 14 91 83 7C 10 F0 00 74 23 E8 ?? ?? ?? ?? 48 63 0F 48 8D 14 89 48 63 4F 04 48 8D 14 91 48 63 5C 10 F0 E8 ?? ?? ?? ?? 48 03 C3 EB 02 33 C0 48 85 C0 74 4A E8 ?? ?? ?? ?? 48 63 0F 48 8D 14 89 48 63 4F 04 48 8D 14 91 83 7C 10 F0 00 74 23 E8 ?? ?? ?? ?? 48 63 0F 48 8D 14 89 48 63 4F 04 48 8D 14 91 48 63 5C 10 F0 E8 ?? ?? ?? ?? 48 03 C3 EB 02 33 C0 80 78 10 00 0F 85 83 00 00 00 E8 ?? ?? ?? ?? 48 63 0F 48 8D 14 89 48 63 4F 04 48 8D 14 91 F6 44 10 EC 40 75 68 E8 ?? ?? ?? ?? 8B 0F 4C 8B 84 24 C0 00 00 00 C6 44 24 58 00 C6 44 24 50 01 FF C9 48 63 C9 4D 8B CF 48 8D 14 89 48 8D 0C 90 48 63 47 04 49 8B D4 48 03 C8 48 8B 84 24 E8 00 00 00 48 89 44 24 48 8B 84 24 E0 00 00 00 89 44 24 40 4C 89 6C 24 38 48 83 64 24 30 00 48 89 4C 24 28 48 8B CE 48 89 6C 24 20 E8 ?? ?? ?? ?? 8B 8C 24 B0 00 00 00 FF C1 48 83 C7 14 89 8C 24 B0 00 00 00 3B 4C 24 60 0F 82 B8 FE FF FF 48 8B 9C 24 B8 00 00 00 48 83 C4 70 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_273_9_0 {
	meta:
		name = "?IsInExceptionSpec@@YAEPEAUEHExceptionRecord@@PEBU_s_ESTypeList@@@Z"
		size = 215
		refs = "0035 _GetThrowImageBase 0078 _GetImageBase 008f __TypeMatch 00cd ?_inconsistency@@YAXXZ 00d2 ?terminate@@YAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 20 48 8B F2 4C 8B E9 48 85 D2 0F 84 A1 00 00 00 33 FF 45 32 F6 39 3A 7E 78 E8 ?? ?? ?? ?? 48 8B D0 49 8B 45 30 4C 63 78 0C 49 83 C7 04 4C 03 FA E8 ?? ?? ?? ?? 48 8B D0 49 8B 45 30 48 63 48 0C 8B 2C 0A 85 ED 7E 44 48 63 C7 4C 8D 24 80 E8 ?? ?? ?? ?? 48 8B D8 49 63 07 48 03 D8 E8 ?? ?? ?? ?? 48 63 4E 04 4D 8B 45 30 4A 8D 04 A0 48 8B D3 48 03 C8 E8 ?? ?? ?? ?? 85 C0 75 0C FF CD 49 83 C7 04 85 ED 7F C8 EB 03 41 B6 01 FF C7 3B 3E 7C 88 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 41 8A C6 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_273_10_0 {
	meta:
		name = "?Is_bad_exception_allowed@@YAEPEBU_s_ESTypeList@@@Z"
		size = 135
		refs = "0020 _GetImageBase 0052 ??_R0?AVbad_exception@std@@@8 005a ??8type_info@@QEBA_NAEBV0@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 33 ED 48 8B F9 39 29 7E 4F 33 F6 E8 ?? ?? ?? ?? 48 63 4F 04 48 03 C6 83 7C 01 04 00 74 1B E8 ?? ?? ?? ?? 48 63 4F 04 48 03 C6 48 63 5C 01 04 E8 ?? ?? ?? ?? 48 03 C3 EB 02 33 C0 48 8D 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 84 C0 75 21 FF C5 48 83 C6 14 3B 2F 7C B3 32 C0 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 B0 01 EB E7 }
	condition:
		$1
}

rule file_273_11_0 {
	meta:
		name = "?__RethrowException@@YAXPEAUEHExceptionRecord@@@Z"
		size = 20
		refs = "0010 __imp_RaiseException"
	strings:
		$1 = { 44 8B 41 18 8B 51 04 4C 8D 49 20 8B 09 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_273_12_0 {
	meta:
		name = "?__uncaught_exception@@YA_NXZ"
		size = 25
		refs = "0005 _getptd"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 33 C9 39 88 00 01 00 00 0F 95 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_13_0 {
	meta:
		name = "?_is_exception_typeof@@YAHAEBVtype_info@@PEAU_EXCEPTION_POINTERS@@@Z"
		size = 191
		refs = "0025 ?_inconsistency@@YAXXZ 007a ?raw_name@type_info@@QEBAPEBDXZ 0089 strcmp"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 48 8B DA 4C 8B F1 48 85 D2 75 05 E8 ?? ?? ?? ?? 48 8B 1B 48 85 DB 75 05 E8 ?? ?? ?? ?? 81 3B 63 73 6D E0 75 13 83 7B 18 04 75 0D 8B 43 20 2D 20 05 93 19 83 F8 02 76 05 E8 ?? ?? ?? ?? 48 8B 6B 38 48 8B 43 30 48 63 48 0C 48 8D 75 04 8B 3C 29 48 03 F1 EB 29 48 63 06 49 8B CE 48 63 5C 28 04 E8 ?? ?? ?? ?? 48 8D 55 10 48 8B C8 48 03 D3 E8 ?? ?? ?? ?? 85 C0 74 27 FF CF 48 83 C6 04 85 FF 7F D3 33 C0 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 B8 01 00 00 00 EB DE }
	condition:
		$1
}

rule file_273_15_0 {
	meta:
		name = "__AdjustPointer"
		size = 35
	strings:
		$1 = { 48 63 02 48 03 C1 83 7A 04 00 7C 16 4C 63 4A 04 48 63 52 08 49 8B 0C 09 4C 63 04 0A 4D 03 C1 49 03 C0 C3 }
	condition:
		$1
}

rule file_273_16_0 {
	meta:
		name = "__BuildCatchObject"
		size = 182
		refs = "0031 __BuildCatchObjectHelper 0045 _GetThrowImageBase 005c __AdjustPointer 009b ?terminate@@YAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 56 48 83 EC 20 49 8B F9 4C 8B F1 41 F7 00 00 00 00 80 74 05 48 8B F2 EB 07 49 63 70 08 48 03 32 E8 ?? ?? ?? ?? FF C8 74 37 FF C8 75 5B 33 DB 39 5F 18 74 0F E8 ?? ?? ?? ?? 48 8B D8 48 63 47 18 48 03 D8 48 8D 57 08 49 8B 4E 28 E8 ?? ?? ?? ?? 48 8B D0 41 B8 01 00 00 00 48 8B CE FF D3 EB 28 33 DB 39 5F 18 74 0C E8 ?? ?? ?? ?? 48 63 5F 18 48 03 D8 48 8D 57 08 49 8B 4E 28 E8 ?? ?? ?? ?? 48 8B D0 48 8B CE FF D3 EB 06 E8 ?? ?? ?? ?? 90 48 8B 5C 24 30 48 8B 74 24 38 48 8B 7C 24 40 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_273_17_0 {
	meta:
		name = "__BuildCatchObjectHelper"
		size = 591
		refs = "0034 _GetImageBase 009b ?g_OutOfMemoryExceptionCallback@@3P6APEAXXZEA 00b4 ?_ValidateRead@@YAHPEBXI@Z 00c6 ?_ValidateWrite@@YAHPEAXI@Z 00dd __AdjustPointer 0157 memmove 017e _GetThrowImageBase 0206 ?_ValidateExecute@@YAHP6A_JXZ@Z 0224 ?_inconsistency@@YAXXZ 022e ?terminate@@YAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 55 41 56 41 57 48 83 EC 30 4D 8B F1 49 8B D8 48 8B F2 4C 8B E9 33 FF 45 8B 78 04 45 85 FF 74 0E 4D 63 FF E8 ?? ?? ?? ?? 49 8D 14 07 EB 03 48 8B D7 48 85 D2 0F 84 E9 01 00 00 45 85 FF 74 11 E8 ?? ?? ?? ?? 48 8B C8 48 63 43 04 48 03 C8 EB 03 48 8B CF 40 38 79 10 0F 84 C6 01 00 00 39 7B 08 75 0C F7 03 00 00 00 80 0F 84 B5 01 00 00 8B 0B 85 C9 78 0A 48 63 43 08 48 03 06 48 8B F0 84 C9 79 57 41 F6 06 10 74 51 48 8B 05 ?? ?? ?? ?? 48 85 C0 74 45 FF D0 4C 8B F8 BB 01 00 00 00 8B D3 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 84 63 01 00 00 8B D3 48 8B CE E8 ?? ?? ?? ?? 85 C0 0F 84 51 01 00 00 4C 89 3E 49 8B CF 49 8D 56 08 E8 ?? ?? ?? ?? 48 89 06 E9 40 01 00 00 BB 01 00 00 00 F6 C1 08 74 2E 8B D3 49 8B 4D 28 E8 ?? ?? ?? ?? 85 C0 0F 84 1D 01 00 00 8B D3 48 8B CE E8 ?? ?? ?? ?? 85 C0 0F 84 0B 01 00 00 49 8B 4D 28 48 89 0E EB B7 41 84 1E 74 51 8B D3 49 8B 4D 28 E8 ?? ?? ?? ?? 85 C0 0F 84 EA 00 00 00 8B D3 48 8B CE E8 ?? ?? ?? ?? 85 C0 0F 84 D8 00 00 00 4D 63 46 14 49 8B 55 28 48 8B CE E8 ?? ?? ?? ?? 41 83 7E 14 08 0F 85 C3 00 00 00 48 39 3E 0F 84 BA 00 00 00 48 8B 0E E9 61 FF FF FF 41 39 7E 18 74 11 E8 ?? ?? ?? ?? 48 8B C8 49 63 46 18 48 03 C8 EB 03 48 8B CF 8B D3 48 85 C9 49 8B 4D 28 75 38 E8 ?? ?? ?? ?? 85 C0 74 7E 8B D3 48 8B CE E8 ?? ?? ?? ?? 85 C0 74 70 49 63 5E 14 49 8D 56 08 49 8B 4D 28 E8 ?? ?? ?? ?? 48 8B D0 4C 8B C3 48 8B CE E8 ?? ?? ?? ?? EB 55 E8 ?? ?? ?? ?? 85 C0 74 46 8B D3 48 8B CE E8 ?? ?? ?? ?? 85 C0 74 38 41 39 7E 18 74 11 E8 ?? ?? ?? ?? 48 8B C8 49 63 46 18 48 03 C8 EB 03 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 15 41 8A 06 24 04 F6 D8 1B C9 F7 D9 03 CB 8B F9 89 4C 24 20 EB 06 E8 ?? ?? ?? ?? 90 8B C7 EB 08 E8 ?? ?? ?? ?? 90 33 C0 48 8B 5C 24 50 48 8B 74 24 58 48 8B 7C 24 60 48 83 C4 30 41 5F 41 5E 41 5D C3 }
	condition:
		$1
}

rule file_273_18_0 {
	meta:
		name = "__CxxCallCatchBlock"
		size = 515
		refs = "0034 _getptd 00b1 _CreateFrameInfo 00f1 _CallSettingFrame 0133 __DestructExceptionObject 015d __imp_RaiseException 0186 _FindAndUnlinkFrame 01af _IsExceptionObjectToBeDestroyed"
	strings:
		$1 = { 40 53 56 57 41 54 41 55 41 56 41 57 48 81 EC 90 00 00 00 48 8B F9 45 33 FF 44 89 7C 24 20 44 21 BC 24 D0 00 00 00 4C 21 7C 24 40 4C 21 BC 24 E8 00 00 00 E8 ?? ?? ?? ?? 4C 8B A8 F8 00 00 00 4C 89 6C 24 50 E8 ?? ?? ?? ?? 48 8B 80 F0 00 00 00 48 89 84 24 E0 00 00 00 48 8B 77 50 48 89 B4 24 D8 00 00 00 48 8B 47 48 48 89 44 24 48 48 8B 5F 40 48 8B 47 30 48 89 44 24 58 4C 8B 77 28 4C 89 74 24 60 E8 ?? ?? ?? ?? 48 89 B0 F0 00 00 00 E8 ?? ?? ?? ?? 48 89 98 F8 00 00 00 E8 ?? ?? ?? ?? 48 8B 90 F0 00 00 00 48 8B 52 28 48 8D 4C 24 78 E8 ?? ?? ?? ?? 4C 8B E0 48 89 44 24 38 4C 39 7F 58 74 1F C7 84 24 D0 00 00 00 01 00 00 00 E8 ?? ?? ?? ?? 48 8B 88 38 01 00 00 48 89 8C 24 E8 00 00 00 41 B8 00 01 00 00 49 8B D6 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B D8 48 89 44 24 40 48 8B BC 24 E0 00 00 00 EB 7B C7 44 24 20 01 00 00 00 E8 ?? ?? ?? ?? 83 A0 60 04 00 00 00 48 8B B4 24 D8 00 00 00 83 BC 24 D0 00 00 00 00 74 21 B2 01 48 8B CE E8 ?? ?? ?? ?? 48 8B 84 24 E8 00 00 00 4C 8D 48 20 44 8B 40 18 8B 50 04 8B 08 EB 0D 4C 8D 4E 20 44 8B 46 18 8B 56 04 8B 0E FF 15 ?? ?? ?? ?? 44 8B 7C 24 20 48 8B 5C 24 40 4C 8B 6C 24 50 48 8B BC 24 E0 00 00 00 4C 8B 74 24 60 4C 8B 64 24 38 49 8B CC E8 ?? ?? ?? ?? 45 85 FF 75 32 81 3E 63 73 6D E0 75 2A 83 7E 18 04 75 24 8B 46 20 2D 20 05 93 19 83 F8 02 77 17 48 8B 4E 28 E8 ?? ?? ?? ?? 85 C0 74 0A B2 01 48 8B CE E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 B8 F0 00 00 00 E8 ?? ?? ?? ?? 4C 89 A8 F8 00 00 00 48 8B 44 24 48 48 63 48 1C 49 8B 06 48 C7 04 01 FE FF FF FF 48 8B C3 48 81 C4 90 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5B C3 }
	condition:
		$1
}

rule file_273_19_0 {
	meta:
		name = "__CxxCallCatchBlock$filt$0"
		size = 244
		refs = "00c5 _getptd"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 89 4D 70 48 89 4D 68 48 8B 45 68 48 8B 08 48 89 4D 28 C7 45 20 00 00 00 00 48 8B 45 28 81 38 63 73 6D E0 75 4D 48 8B 45 28 83 78 18 04 75 43 48 8B 45 28 81 78 20 20 05 93 19 74 1A 48 8B 45 28 81 78 20 21 05 93 19 74 0D 48 8B 45 28 81 78 20 22 05 93 19 75 1C 48 8B 55 28 48 8B 85 D8 00 00 00 48 8B 48 28 48 39 4A 28 75 07 C7 45 20 01 00 00 00 48 8B 45 28 81 38 63 73 6D E0 75 5B 48 8B 45 28 83 78 18 04 75 51 48 8B 45 28 81 78 20 20 05 93 19 74 1A 48 8B 45 28 81 78 20 21 05 93 19 74 0D 48 8B 45 28 81 78 20 22 05 93 19 75 2A 48 8B 45 28 48 83 78 30 00 75 1F E8 ?? ?? ?? ?? C7 80 60 04 00 00 01 00 00 00 C7 45 20 01 00 00 00 C7 45 30 01 00 00 00 EB 07 C7 45 30 00 00 00 00 8B 45 30 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_273_20_0 {
	meta:
		name = "__CxxCallCatchBlock$fin$1"
		size = 126
		refs = "000f _FindAndUnlinkFrame 0040 _IsExceptionObjectToBeDestroyed 004e __DestructExceptionObject 0054 _getptd"
	strings:
		$1 = { 40 53 55 48 83 EC 28 48 8B EA 48 8B 4D 38 E8 ?? ?? ?? ?? 83 7D 20 00 75 3A 48 8B 9D D8 00 00 00 81 3B 63 73 6D E0 75 2B 83 7B 18 04 75 25 8B 43 20 2D 20 05 93 19 83 F8 02 77 18 48 8B 4B 28 E8 ?? ?? ?? ?? 85 C0 74 0B B2 01 48 8B CB E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 48 8B 8D E0 00 00 00 48 89 88 F0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4D 50 48 89 88 F8 00 00 00 48 83 C4 28 5D 5B C3 CC }
	condition:
		$1
}

rule file_273_21_0 {
	meta:
		name = "__CxxDetectRethrow"
		size = 71
		refs = "002f _getptd"
	strings:
		$1 = { 48 83 EC 28 48 85 C9 74 37 48 8B 09 81 39 63 73 6D E0 75 2C 83 79 18 04 75 26 8B 41 20 2D 20 05 93 19 83 F8 02 77 19 48 83 79 30 00 75 12 E8 ?? ?? ?? ?? FF 80 00 01 00 00 B8 01 00 00 00 EB 02 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_273_22_0 {
	meta:
		name = "__CxxExceptionFilter"
		size = 502
		refs = "0086 _getptd 00a1 _GetImageBase 00b2 _SetThrowImageBase 00c4 __imp_RtlPcToFileHeader 00d4 _SetImageBase 00f1 _GetThrowImageBase 013c __TypeMatch 0163 __BuildCatchObject 0174 _local_unwind"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 48 89 7C 24 20 41 54 41 56 41 57 48 83 EC 60 48 89 64 24 38 4D 8B E1 41 8B F0 48 8B FA 48 85 C9 75 07 33 C0 E9 A8 01 00 00 48 8B 19 48 85 D2 74 06 80 7A 10 00 75 22 81 3B 4D 4F 43 E0 0F 84 49 01 00 00 81 3B 52 43 43 E0 0F 84 3D 01 00 00 40 F6 C6 40 0F 84 33 01 00 00 81 3B 63 73 6D E0 75 C1 83 7B 18 04 75 BB 8B 43 20 2D 20 05 93 19 83 F8 02 77 AE 48 83 7B 30 00 75 1B E8 ?? ?? ?? ?? 48 83 B8 F0 00 00 00 00 74 98 E8 ?? ?? ?? ?? 48 8B 98 F0 00 00 00 E8 ?? ?? ?? ?? 4C 8B F8 48 89 44 24 30 48 8B 4B 38 E8 ?? ?? ?? ?? 90 48 8D 94 24 80 00 00 00 48 8B CF FF 15 ?? ?? ?? ?? 48 89 84 24 80 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 2B BC 24 80 00 00 00 89 7C 24 44 89 74 24 40 0F BA EE 1F 89 74 24 40 E8 ?? ?? ?? ?? 48 8B 4B 30 48 63 71 0C 48 83 C0 04 48 03 F0 48 89 74 24 28 E8 ?? ?? ?? ?? 48 8B 4B 30 48 63 51 0C 8B 3C 10 89 7C 24 20 85 FF 7E 68 E8 ?? ?? ?? ?? 4C 8B F0 48 63 06 4C 03 F0 4C 8B 43 30 49 8B D6 48 8D 4C 24 40 E8 ?? ?? ?? ?? 85 C0 74 34 E8 ?? ?? ?? ?? FF 80 00 01 00 00 4D 85 E4 74 13 4D 8B CE 4C 8D 44 24 40 49 8B D4 48 8B CB E8 ?? ?? ?? ?? 48 8D 15 68 00 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? FF CF 89 7C 24 20 48 83 C6 04 48 89 74 24 28 EB 94 49 8B CF E8 ?? ?? ?? ?? E9 96 FE FF FF 81 3B 63 73 6D E0 75 2D 83 7B 18 04 75 27 8B 43 20 2D 20 05 93 19 83 F8 02 77 1A 48 83 7B 30 00 75 13 E8 ?? ?? ?? ?? 48 83 B8 F0 00 00 00 00 0F 84 61 FE FF FF E8 ?? ?? ?? ?? FF 80 00 01 00 00 B8 01 00 00 00 4C 8D 5C 24 60 49 8B 5B 28 49 8B 73 30 49 8B 7B 38 49 8B E3 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_273_23_0 {
	meta:
		name = "__CxxExceptionFilter$fin$0"
		size = 26
		refs = "000e _SetImageBase"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 30 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_273_25_0 {
	meta:
		name = "__CxxRegisterExceptionObject"
		size = 193
		refs = "003d _getptd 0050 _CreateFrameInfo"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B FA 48 85 C9 74 70 48 8B 19 48 85 DB 74 68 81 3B 63 73 6D E0 75 26 83 7B 18 04 75 20 8B 43 20 2D 20 05 93 19 83 F8 02 77 13 48 83 7B 30 00 75 0C E8 ?? ?? ?? ?? 48 8B 98 F0 00 00 00 48 8B 53 28 48 8B CF E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 88 F0 00 00 00 48 89 4F 10 E8 ?? ?? ?? ?? 48 8B 88 F8 00 00 00 48 89 4F 18 E8 ?? ?? ?? ?? 48 89 98 F0 00 00 00 EB 0A 48 83 4A 10 FF 48 83 4A 18 FF E8 ?? ?? ?? ?? FF 88 00 01 00 00 E8 ?? ?? ?? ?? 83 B8 00 01 00 00 00 7D 0C E8 ?? ?? ?? ?? 83 A0 00 01 00 00 00 B8 01 00 00 00 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_273_26_0 {
	meta:
		name = "__CxxUnregisterExceptionObject"
		size = 343
		refs = "001b _FindAndUnlinkFrame 0028 _getptd 009d _IsExceptionObjectToBeDestroyed 00b4 __DestructExceptionObject"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 83 79 10 FF 8B FA 48 8B D9 0F 84 32 01 00 00 E8 ?? ?? ?? ?? 85 FF 0F 85 91 00 00 00 E8 ?? ?? ?? ?? 48 8B 88 F0 00 00 00 81 39 63 73 6D E0 75 7D E8 ?? ?? ?? ?? 48 8B 88 F0 00 00 00 83 79 18 04 75 6B E8 ?? ?? ?? ?? 48 8B 88 F0 00 00 00 81 79 20 20 05 93 19 74 2A E8 ?? ?? ?? ?? 48 8B 88 F0 00 00 00 81 79 20 21 05 93 19 74 15 E8 ?? ?? ?? ?? 48 8B 88 F0 00 00 00 81 79 20 22 05 93 19 75 2C E8 ?? ?? ?? ?? 48 8B 88 F0 00 00 00 48 8B 49 28 E8 ?? ?? ?? ?? 85 C0 74 13 E8 ?? ?? ?? ?? B2 01 48 8B 88 F0 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 88 F0 00 00 00 81 39 63 73 6D E0 75 60 E8 ?? ?? ?? ?? 48 8B 88 F0 00 00 00 83 79 18 04 75 4E E8 ?? ?? ?? ?? 48 8B 88 F0 00 00 00 81 79 20 20 05 93 19 74 2A E8 ?? ?? ?? ?? 48 8B 88 F0 00 00 00 81 79 20 21 05 93 19 74 15 E8 ?? ?? ?? ?? 48 8B 88 F0 00 00 00 81 79 20 22 05 93 19 75 0F 85 FF 74 0B E8 ?? ?? ?? ?? FF 88 00 01 00 00 E8 ?? ?? ?? ?? 48 8B 4B 10 48 89 88 F0 00 00 00 E8 ?? ?? ?? ?? 48 8B 4B 18 48 89 88 F8 00 00 00 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_273_27_0 {
	meta:
		name = "__DestructExceptionObject$filt$0"
		size = 24
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 33 C0 38 45 38 0F 95 C0 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_273_28_0 {
	meta:
		name = "__FrameUnwindFilter"
		size = 83
		refs = "0022 _getptd 004e ?terminate@@YAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8B 01 81 38 52 43 43 E0 74 12 81 38 4D 4F 43 E0 74 0A 81 38 63 73 6D E0 75 1B EB 20 E8 ?? ?? ?? ?? 83 B8 00 01 00 00 00 7E 0B E8 ?? ?? ?? ?? FF 88 00 01 00 00 33 C0 48 83 C4 28 C3 E8 ?? ?? ?? ?? 83 A0 00 01 00 00 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_273_29_0 {
	meta:
		name = "__FrameUnwindToState"
		size = 402
		refs = "002f _GetImageBase 0042 ?__GetCurrentState@@YAHPEA_KPEAU_xDISPATCHER_CONTEXT@@PEBU_s_FuncInfo@@@Z 0049 _getptd 0070 ?_inconsistency@@YAXXZ 00cf ?__SetState@@YAXPEA_KPEAU_xDISPATCHER_CONTEXT@@PEBU_s_FuncInfo@@H@Z 0112 _CallSettingFrame 011c _SetImageBase"
	strings:
		$1 = { 48 8B C4 44 89 48 20 4C 89 40 18 48 89 50 10 48 89 48 08 53 56 57 41 54 41 55 41 56 41 57 48 83 EC 30 45 8B E1 49 8B F0 4C 8B EA 4C 8B F9 E8 ?? ?? ?? ?? 48 89 44 24 28 4C 8B C6 49 8B D5 49 8B CF E8 ?? ?? ?? ?? 8B F8 E8 ?? ?? ?? ?? FF 80 00 01 00 00 83 FF FF 0F 84 ED 00 00 00 41 3B FC 0F 8E E4 00 00 00 83 FF FF 7E 05 3B 7E 04 7C 05 E8 ?? ?? ?? ?? 4C 63 F7 E8 ?? ?? ?? ?? 48 63 4E 08 4A 8D 04 F0 8B 3C 01 89 7C 24 20 E8 ?? ?? ?? ?? 48 63 4E 08 4A 8D 04 F0 83 7C 01 04 00 74 1C E8 ?? ?? ?? ?? 48 63 4E 08 4A 8D 04 F0 48 63 5C 01 04 E8 ?? ?? ?? ?? 48 03 C3 EB 02 33 C0 48 85 C0 74 5E 44 8B CF 4C 8B C6 49 8B D5 49 8B CF E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 63 4E 08 4A 8D 04 F0 83 7C 01 04 00 74 1C E8 ?? ?? ?? ?? 48 63 4E 08 4A 8D 04 F0 48 63 5C 01 04 E8 ?? ?? ?? ?? 48 03 C3 EB 02 33 C0 41 B8 03 01 00 00 49 8B D7 48 8B C8 E8 ?? ?? ?? ?? 48 8B 4C 24 28 E8 ?? ?? ?? ?? EB 1E 44 8B A4 24 88 00 00 00 48 8B B4 24 80 00 00 00 4C 8B 6C 24 78 4C 8B 7C 24 70 8B 7C 24 20 89 7C 24 24 E9 0A FF FF FF E8 ?? ?? ?? ?? 83 B8 00 01 00 00 00 7E 0B E8 ?? ?? ?? ?? FF 88 00 01 00 00 83 FF FF 74 0A 41 3B FC 7E 05 E8 ?? ?? ?? ?? 44 8B CF 4C 8B C6 49 8B D5 49 8B CF E8 ?? ?? ?? ?? 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F 5E 5B C3 }
	condition:
		$1
}

rule file_273_30_0 {
	meta:
		name = "__FrameUnwindToState$filt$0"
		size = 22
		refs = "000a __FrameUnwindFilter"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_273_31_0 {
	meta:
		name = "__FrameUnwindToState$fin$1"
		size = 41
		refs = "000a _getptd"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA E8 ?? ?? ?? ?? 83 B8 00 01 00 00 00 7E 0B E8 ?? ?? ?? ?? FF 88 00 01 00 00 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_273_32_0 {
	meta:
		name = "__GetPlatformExceptionInfo"
		size = 145
		refs = "0016 _getptd 0042 _GetThrowImageBase"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 83 21 00 48 8B F1 E8 ?? ?? ?? ?? 48 8B 80 F0 00 00 00 48 85 C0 74 59 48 8B 58 30 48 85 DB 74 12 F6 03 10 74 0D 48 8B 40 28 48 8B 00 48 8B 40 F8 EB 40 E8 ?? ?? ?? ?? 48 63 7B 0C 48 83 C0 04 48 03 F8 E8 ?? ?? ?? ?? 48 63 4B 0C 8B 1C 08 EB 14 E8 ?? ?? ?? ?? 48 63 0F F6 04 08 10 75 0C FF CB 48 83 C7 04 85 DB 7F E8 EB 06 C7 06 01 00 00 00 33 C0 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_273_33_0 {
	meta:
		name = "__InternalCxxFrameHandler"
		size = 548
		refs = "0025 _getptd 00c4 ?__StateFromIp@@YAHPEBU_s_FuncInfo@@PEAU_xDISPATCHER_CONTEXT@@_J@Z 00d5 ?_inconsistency@@YAXXZ 00e6 __FrameUnwindToState 011d ?__FrameUnwindToEmptyState@@YAXPEA_KPEAU_xDISPATCHER_CONTEXT@@PEBU_s_FuncInfo@@@Z 0142 _GetImageBase 017c _GetThrowImageBase 0204 ?FindHandler@@YAXPEAUEHExceptionRecord@@PEA_KPEAU_CONTEXT@@PEAU_xDISPATCHER_CONTEXT@@PEBU_s_FuncInfo@@EH1@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 56 48 83 EC 40 49 8B E9 4D 8B F0 48 8B F2 48 8B D9 E8 ?? ?? ?? ?? 48 8B BC 24 80 00 00 00 83 B8 60 04 00 00 00 BA FF FF FF 1F 41 B8 29 00 00 80 41 B9 26 00 00 80 41 BC 01 00 00 00 75 38 81 3B 63 73 6D E0 74 30 44 39 03 75 10 83 7B 18 0F 75 0A 48 81 7B 60 20 05 93 19 74 1B 44 39 0B 74 16 8B 0F 23 CA 81 F9 22 05 93 19 72 0A 44 84 67 24 0F 85 7F 01 00 00 8B 43 04 A8 66 0F 84 92 00 00 00 83 7F 04 00 0F 84 6A 01 00 00 83 BC 24 88 00 00 00 00 0F 85 5C 01 00 00 83 E0 20 74 3E 44 39 0B 75 39 4D 8B 86 F8 00 00 00 48 8B D5 48 8B CF E8 ?? ?? ?? ?? 8B D8 83 F8 FF 7C 05 3B 47 04 7C 05 E8 ?? ?? ?? ?? 44 8B CB 48 8B CE 48 8B D5 4C 8B C7 E8 ?? ?? ?? ?? E9 19 01 00 00 85 C0 74 20 44 39 03 75 1B 8B 73 38 83 FE FF 7C 05 3B 77 04 7C 05 E8 ?? ?? ?? ?? 48 8B 4B 28 44 8B CE EB CC 4C 8B C7 48 8B D5 48 8B CE E8 ?? ?? ?? ?? E9 E2 00 00 00 83 7F 0C 00 75 2E 8B 07 23 C2 3D 21 05 93 19 0F 82 CD 00 00 00 83 7F 20 00 74 0E E8 ?? ?? ?? ?? 48 63 4F 20 48 03 C1 EB 02 33 C0 48 85 C0 0F 84 AE 00 00 00 81 3B 63 73 6D E0 75 6D 83 7B 18 03 72 67 81 7B 20 22 05 93 19 76 5E 48 8B 43 30 83 78 08 00 74 12 E8 ?? ?? ?? ?? 48 8B 4B 30 4C 63 51 08 4C 03 D0 EB 03 45 33 D2 4D 85 D2 74 3A 0F B6 84 24 98 00 00 00 4C 8B CD 4D 8B C6 89 44 24 38 48 8B 84 24 90 00 00 00 48 8B D6 48 89 44 24 30 8B 84 24 88 00 00 00 48 8B CB 89 44 24 28 48 89 7C 24 20 41 FF D2 EB 3C 48 8B 84 24 90 00 00 00 4C 8B CD 4D 8B C6 48 89 44 24 38 8B 84 24 88 00 00 00 48 8B D6 89 44 24 30 8A 84 24 98 00 00 00 48 8B CB 88 44 24 28 48 89 7C 24 20 E8 ?? ?? ?? ?? 41 8B C4 48 8B 5C 24 60 48 8B 6C 24 68 48 8B 74 24 70 48 83 C4 40 41 5E 41 5C 5F C3 }
	condition:
		$1
}

rule file_273_34_0 {
	meta:
		name = "__TypeMatch"
		size = 301
		refs = "002f _GetImageBase 008c _GetThrowImageBase 00cd strcmp"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 8B 71 04 33 DB 4D 8B F0 48 8B EA 48 8B F9 85 F6 74 0E 48 63 F6 E8 ?? ?? ?? ?? 48 8D 0C 06 EB 03 48 8B CB 48 85 C9 0F 84 C8 00 00 00 85 F6 74 0F 48 63 77 04 E8 ?? ?? ?? ?? 48 8D 0C 06 EB 03 48 8B CB 38 59 10 0F 84 A9 00 00 00 F6 07 80 74 0A F6 45 00 10 0F 85 9A 00 00 00 85 F6 74 11 E8 ?? ?? ?? ?? 48 8B F0 48 63 47 04 48 03 F0 EB 03 48 8B F3 E8 ?? ?? ?? ?? 48 8B C8 48 63 45 04 48 03 C8 48 3B F1 74 3A 39 5F 04 74 11 E8 ?? ?? ?? ?? 48 8B F0 48 63 47 04 48 03 F0 EB 03 48 8B F3 E8 ?? ?? ?? ?? 48 63 55 04 48 8D 4E 10 48 83 C2 10 48 03 D0 E8 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 39 B0 02 84 45 00 74 05 F6 07 08 74 24 41 F6 06 01 74 05 F6 07 01 74 19 41 F6 06 04 74 05 F6 07 04 74 0E 41 84 06 74 04 84 07 74 05 BB 01 00 00 00 8B C3 EB 05 B8 01 00 00 00 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_274_4_0 {
	meta:
		name = "_mbctolower_l"
		size = 192
		refs = "0015 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0075 __crtLCMapStringA"
	strings:
		$1 = { 48 89 5C 24 10 55 48 8B EC 48 83 EC 70 48 63 D9 48 8D 4D E0 E8 ?? ?? ?? ?? 81 FB FF 00 00 00 76 6B 48 8B 55 E8 8B C3 88 5D 11 C1 E8 08 88 45 10 0F B6 C0 F6 44 10 19 04 74 65 8B 42 04 48 8B 92 20 02 00 00 C7 44 24 40 01 00 00 00 89 44 24 38 B9 02 00 00 00 48 8D 45 20 89 4C 24 30 48 89 44 24 28 89 4C 24 20 48 8D 4D E0 4C 8D 4D 10 41 B8 00 01 00 00 E8 ?? ?? ?? ?? 85 C0 74 22 0F B6 5D 20 0F B6 45 21 C1 E3 08 03 D8 EB 13 48 8B 4D E8 F6 44 0B 19 10 74 08 0F B6 9C 0B 19 01 00 00 80 7D F8 00 74 0B 48 8B 4D F0 83 A1 C8 00 00 00 FD 8B C3 48 8B 9C 24 88 00 00 00 48 83 C4 70 5D C3 }
	condition:
		$1
}

rule file_275_0_0 {
	meta:
		name = "__avx_atan24"
		size = 768
		refs = "0063 __common_datan2_data 02f4 __common_datan2_cout_rare"
	strings:
		$1 = { 48 81 EC 58 02 00 00 C5 7C 11 AC 24 70 01 00 00 C5 7C 11 A4 24 D0 01 00 00 C5 7C 11 9C 24 B0 01 00 00 C5 7C 11 94 24 10 02 00 00 C5 7C 11 8C 24 F0 01 00 00 C5 7C 11 84 24 90 01 00 00 C5 FC 11 BC 24 50 01 00 00 C5 FC 11 B4 24 30 02 00 00 4C 89 AC 24 50 02 00 00 4C 8D AC 24 AF 00 00 00 C5 FD 10 25 ?? ?? ?? ?? 49 83 E5 C0 C5 7D 10 15 ?? ?? ?? ?? C5 F5 54 D4 C5 FD 54 EC C5 D5 C2 DA 15 C4 41 6D 56 EA C4 C3 55 4B E5 30 C4 63 6D 4B C5 30 C4 41 5D 5E E8 C5 F8 10 25 ?? ?? ?? ?? C5 65 54 25 ?? ?? ?? ?? C4 41 75 54 DA C4 41 7D 54 CA C5 78 10 15 ?? ?? ?? ?? C4 E3 7D 19 D6 01 C4 E3 7D 19 EF 01 C5 E8 C6 DE DD C5 D0 C6 EF DD C5 61 FA C4 C5 D1 FA FC C4 C1 39 66 D2 C5 F5 C2 25 ?? ?? ?? ?? 12 C4 C1 39 76 F2 C4 C1 41 66 EA C4 41 41 76 D2 C5 E9 EB DE C4 41 51 EB D2 C4 C1 61 EB EA C5 5D 54 15 ?? ?? ?? ?? C4 C1 15 59 E5 C5 F8 50 D5 C5 DD 59 EC C5 D5 59 DD C5 65 59 05 ?? ?? ?? ?? C5 E5 59 3D ?? ?? ?? ?? C5 E5 59 15 ?? ?? ?? ?? C5 BD 58 35 ?? ?? ?? ?? C5 45 58 05 ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 CD 59 F3 C5 E5 59 3D ?? ?? ?? ?? C5 ED 59 D3 C5 3D 59 C3 C5 CD 58 35 ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 3D 58 05 ?? ?? ?? ?? C5 CD 59 F3 C5 C5 59 FB C5 ED 59 D3 C5 3D 59 C3 C5 CD 58 35 ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 3D 58 05 ?? ?? ?? ?? C5 CD 59 F3 C5 C5 59 FB C5 ED 59 D3 C5 3D 59 C3 C5 CD 58 35 ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 3D 58 05 ?? ?? ?? ?? C5 CD 59 F4 C5 C5 59 DB C5 BD 59 E4 C5 CD 58 FA C5 E5 58 1D ?? ?? ?? ?? C5 C5 59 ED C5 DD 58 D3 C5 D5 58 DA C4 41 65 59 ED C4 41 15 58 E4 C4 41 1D 56 DB C4 C1 25 58 D2 C4 C1 6D 56 D1 85 D2 75 5C C5 FC 10 B4 24 30 02 00 00 C5 FC 10 BC 24 50 01 00 00 C5 7C 10 84 24 90 01 00 00 C5 7C 10 8C 24 F0 01 00 00 C5 7C 10 94 24 10 02 00 00 C5 7C 10 9C 24 B0 01 00 00 C5 7C 10 A4 24 D0 01 00 00 C5 7C 10 AC 24 70 01 00 00 4C 8B AC 24 50 02 00 00 C5 FD 28 C2 48 81 C4 58 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 C4 C1 7D 11 95 80 00 00 00 74 8D 33 C0 C5 7C 11 74 24 40 C5 7C 11 7C 24 20 48 89 5C 24 68 8B D8 48 89 74 24 60 8B F2 0F A3 DE 72 2B FF C3 83 FB 20 7C F4 C5 7C 10 74 24 40 C5 7C 10 7C 24 20 C4 C1 7D 10 95 80 00 00 00 48 8B 5C 24 68 48 8B 74 24 60 E9 41 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 4D 8D 84 DD 80 00 00 00 E8 ?? ?? ?? ?? EB B9 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_276_0_0 {
	meta:
		name = "_fprintf_l"
		size = 29
		refs = "0014 _vfprintf_l"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 28 4C 8D 4C 24 48 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_297_0_0 {
	meta:
		name = "__swprintf_l"
		size = 29
		refs = "0014 __vswprintf_l"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 28 4C 8D 4C 24 48 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_276_2_0 {
	meta:
		name = "_fprintf_p_l"
		size = 29
		refs = "0014 _vfprintf_p_l"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 28 4C 8D 4C 24 48 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_276_3_0 {
	meta:
		name = "_fprintf_s_l"
		size = 29
		refs = "0014 _vfprintf_s_l"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 28 4C 8D 4C 24 48 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1293_0_0 {
	meta:
		name = "_fwprintf_l"
		size = 29
		refs = "0014 _vfwprintf_l"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 28 4C 8D 4C 24 48 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1293_2_0 {
	meta:
		name = "_fwprintf_p_l"
		size = 29
		refs = "0014 _vfwprintf_p_l"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 28 4C 8D 4C 24 48 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1293_3_0 {
	meta:
		name = "_fwprintf_s_l"
		size = 29
		refs = "0014 _vfwprintf_s_l"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 28 4C 8D 4C 24 48 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_722_6_0 {
	meta:
		name = "_sprintf_l"
		size = 29
		refs = "0014 _vsprintf_l"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 28 4C 8D 4C 24 48 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_276_1_0 {
	meta:
		name = "_fprintf_p"
		size = 36
		refs = "001b _vfprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 48 18 45 33 C0 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1293_1_0 {
	meta:
		name = "_fwprintf_p"
		size = 36
		refs = "001b _vfwprintf_p_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 48 18 45 33 C0 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_276_6_0 {
	meta:
		name = "fprintf_s"
		size = 36
		refs = "001b _vfprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 48 18 45 33 C0 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1293_6_0 {
	meta:
		name = "fwprintf_s"
		size = 36
		refs = "001b _vfwprintf_s_l"
	strings:
		$1 = { 48 8B C4 48 89 50 10 4C 89 40 18 4C 89 48 20 48 83 EC 28 4C 8D 48 18 45 33 C0 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_276_4_0 {
	meta:
		name = "fprintf"
		size = 296
		refs = "002e _errno 0039 _invalid_parameter_noinfo 0057 _lock_file 006a _fileno 0078 __pioinfo 0099 __badioinfo 00ee _stbuf 0103 _output_l 010f _ftbuf 0118 _unlock_file"
	strings:
		$1 = { 48 8B C4 48 89 50 10 48 89 48 08 4C 89 40 18 4C 89 48 20 53 56 57 41 56 48 83 EC 28 48 8B F1 33 FF 33 C0 48 85 C9 0F 95 C0 85 C0 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 D9 00 00 00 33 C0 48 85 D2 0F 95 C0 85 C0 74 DC 4C 8D 74 24 60 E8 ?? ?? ?? ?? 90 F6 46 18 40 0F 85 80 00 00 00 48 8B CE E8 ?? ?? ?? ?? 4C 63 C0 41 8D 48 02 4C 8D 0D ?? ?? ?? ?? 83 F9 01 76 1E 49 8B D0 49 8B C8 48 C1 F9 05 83 E2 1F 48 6B C2 58 49 03 04 C9 48 8D 0D ?? ?? ?? ?? EB 0A 48 8D 0D ?? ?? ?? ?? 48 8B C1 F6 40 38 7F 75 24 41 8D 40 02 83 F8 01 76 15 49 8B C8 49 8B C0 48 C1 F8 05 83 E1 1F 48 6B C9 58 49 03 0C C1 F6 41 38 80 74 13 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 CF FF 85 FF 75 2A 48 8B CE E8 ?? ?? ?? ?? 8B D8 4D 8B CE 45 33 C0 48 8B 54 24 58 48 8B CE E8 ?? ?? ?? ?? 8B F8 48 8B D6 8B CB E8 ?? ?? ?? ?? 90 48 8B CE E8 ?? ?? ?? ?? 8B C7 48 83 C4 28 41 5E 5F 5E 5B C3 }
	condition:
		$1
}

rule file_276_5_0 {
	meta:
		name = "fprintf$fin$0"
		size = 26
		refs = "000e _unlock_file"
		altNames = "_wfsopen$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 50 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "strncat"
		size = 405
	strings:
		$1 = { 4C 8B D9 4D 0B C0 0F 84 AF 00 00 00 F6 C1 07 74 0F 8A 01 84 C0 74 7F 48 FF C1 F6 C1 07 75 F2 90 48 8B 01 4C 8B D0 49 B9 FF FE FE FE FE FE FE 7E 4D 03 CA 49 83 F2 FF 4D 33 D1 48 83 C1 08 49 B9 00 01 01 01 01 01 01 81 4D 85 D1 74 D3 48 83 E9 08 84 C0 74 41 48 FF C1 84 E4 74 3A 48 FF C1 48 C1 E8 10 84 C0 74 2F 48 FF C1 84 E4 74 28 48 FF C1 48 C1 E8 10 84 C0 74 1D 48 FF C1 84 E4 74 16 48 FF C1 C1 E8 10 84 C0 74 0C 48 FF C1 84 E4 74 05 48 FF C1 EB 8A 48 2B CA F6 C2 07 74 2A 8A 02 88 04 11 84 C0 74 14 48 FF C2 49 FF C8 74 07 F6 C2 07 75 EA EB 12 32 C0 88 04 11 49 8B C3 C3 90 48 89 04 11 48 83 C2 08 48 8B 02 49 83 E8 08 72 26 49 B9 FF FE FE FE FE FE FE 7E 4C 03 C8 4C 8B D0 49 83 F2 FF 4D 33 D1 49 B9 00 01 01 01 01 01 01 81 4D 85 D1 74 C9 49 83 C0 08 0F 84 8B 00 00 00 84 C0 88 04 11 0F 84 85 00 00 00 48 FF C2 49 FF C8 74 78 84 E4 88 24 11 74 76 48 FF C2 49 FF C8 74 69 48 C1 E8 10 84 C0 88 04 11 74 63 48 FF C2 49 FF C8 74 56 84 E4 88 24 11 74 54 48 FF C2 49 FF C8 74 47 48 C1 E8 10 84 C0 88 04 11 74 41 48 FF C2 49 FF C8 74 34 84 E4 88 24 11 74 32 48 FF C2 49 FF C8 74 25 C1 E8 10 84 C0 88 04 11 74 20 48 FF C2 49 FF C8 74 13 84 E4 88 24 11 74 11 48 FF C2 49 FF C8 0F 85 3C FF FF FF 32 C0 88 04 11 49 8B C3 C3 }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "_wfltin2"
		size = 198
		refs = "0011 __security_cookie 0044 __wstrgtold12_l 006a _ld12tod 00b2 __security_check_cookie"
	strings:
		$1 = { 4C 8B DC 49 89 5B 20 55 56 57 48 83 EC 70 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 60 4D 89 43 B0 33 DB 48 8B EA 21 5C 24 30 21 5C 24 28 21 5C 24 20 4C 8B C2 48 8B F9 49 8D 53 C0 49 8D 4B C8 45 33 C9 E8 ?? ?? ?? ?? 8B F0 A8 04 74 11 83 64 24 40 00 83 64 24 44 00 BB 00 02 00 00 EB 2E 48 8D 54 24 40 48 8D 4C 24 50 E8 ?? ?? ?? ?? 40 F6 C6 02 75 05 83 F8 01 75 05 BB 80 00 00 00 40 F6 C6 01 75 05 83 F8 02 75 04 0F BA EB 08 48 8B 4C 24 48 89 1F 48 8B C7 48 2B CD 48 D1 F9 89 4F 04 48 8B 4C 24 40 48 89 4F 10 48 8B 4C 24 60 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 A8 00 00 00 48 83 C4 70 5F 5E 5D C3 }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "_aligned_free"
		size = 27
		refs = "0012 free"
	strings:
		$1 = { 48 83 EC 28 48 85 C9 74 0D 48 83 E1 F8 48 8B 49 F8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_282_1_0 {
	meta:
		name = "_aligned_malloc"
		size = 116
		refs = "0010 _errno 001b _invalid_parameter_noinfo 004f malloc"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 42 FF 48 85 C2 74 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 4B BB 08 00 00 00 48 8D 41 08 48 3B D3 48 0F 47 DA 48 FF CB 48 03 C3 48 3B C8 76 0D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB D4 48 8B C8 E8 ?? ?? ?? ?? 48 8B C8 33 C0 48 85 C9 74 11 48 8D 43 08 48 F7 D3 48 03 C1 48 23 C3 48 89 48 F8 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_282_2_0 {
	meta:
		name = "_aligned_msize"
		size = 101
		refs = "0016 _errno 0021 _invalid_parameter_noinfo 0034 _msize"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 49 8B D8 48 8B FA 48 85 C9 75 16 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 48 83 C8 FF EB 2F 48 83 E1 F8 48 8B 49 F8 E8 ?? ?? ?? ?? B9 08 00 00 00 48 C7 C2 F9 FF FF FF 48 3B F9 48 0F 47 CF 48 F7 DB 83 E3 07 48 2B D1 48 2B D3 48 03 C2 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_282_3_0 {
	meta:
		name = "_aligned_offset_malloc"
		size = 179
		refs = "0022 _errno 002d _invalid_parameter_noinfo 0078 malloc"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 56 48 83 EC 20 48 8D 42 FF 49 8B D8 48 85 C2 74 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 68 48 85 DB 74 05 48 3B D9 73 E2 BF 08 00 00 00 48 8B F3 48 3B D7 48 0F 47 FA 48 F7 DE 48 FF CF 83 E6 07 4C 8D 77 08 4C 03 F6 49 8D 04 0E 48 3B C8 76 0D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB BD 48 8B C8 E8 ?? ?? ?? ?? 48 8B D0 48 85 C0 74 AD 49 03 C6 48 F7 D7 48 03 C3 48 23 C7 48 2B C3 48 8B C8 48 2B CE 48 89 51 F8 48 8B 5C 24 30 48 8B 74 24 38 48 8B 7C 24 40 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_282_4_0 {
	meta:
		name = "_aligned_offset_realloc"
		size = 458
		refs = "003a _aligned_offset_malloc 0051 free 0066 _errno 0071 _invalid_parameter_noinfo 00b4 _msize 0104 malloc 012e _expand 018f memmove"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 48 89 74 24 20 57 41 54 41 55 41 56 41 57 48 83 EC 30 45 33 E4 49 8B F1 48 8B FA 4D 8B C8 48 8B D9 48 85 C9 75 13 4C 8B C6 49 8B D1 48 8B CF E8 ?? ?? ?? ?? E9 6A 01 00 00 48 85 D2 75 14 48 83 E3 F8 48 8B 4B F8 E8 ?? ?? ?? ?? 33 C0 E9 51 01 00 00 49 8D 40 FF 49 85 C0 74 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB DE 48 85 F6 74 05 48 3B F2 73 E4 48 8B C1 BD 08 00 00 00 4C 8B FE 48 83 E0 F8 4C 3B C5 4C 8B 70 F8 49 0F 47 E8 48 8B C1 49 2B C6 49 F7 DF 49 8B CE 48 89 44 24 20 48 FF CD 41 83 E7 07 E8 ?? ?? ?? ?? 4C 8D 6D 08 48 8B C8 49 8B C6 48 2B C3 48 03 C8 49 8D 04 3F 48 3B CF 48 0F 47 CF 4C 03 E8 48 89 4C 24 28 49 3B FD 76 10 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E9 65 FF FF FF 4B 8D 04 37 48 8D 55 08 48 03 D0 48 3B D3 73 1C 49 8B CD E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 0F 84 41 FF FF FF 41 BC 01 00 00 00 EB 2E E8 ?? ?? ?? ?? 49 8B D5 49 8B CE 8B 00 89 44 24 60 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 0D E8 ?? ?? ?? ?? 8B 4C 24 60 89 08 EB B9 4C 8B F0 48 8B 54 24 20 48 8B C3 48 2B C2 48 3B F8 75 12 49 8D 0C 1F 48 8B C5 48 03 CE 48 F7 D0 48 85 C8 74 3E 4C 8B 44 24 28 4A 8D 04 3F 48 8D 5E 08 48 03 C5 48 F7 D5 49 03 D6 48 03 D8 48 23 DD 48 2B DE 48 8B CB E8 ?? ?? ?? ?? 45 85 E4 74 08 49 8B CE E8 ?? ?? ?? ?? 48 8B CB 49 2B CF 48 89 79 F8 48 8B C3 48 8B 5C 24 68 48 8B 6C 24 70 48 8B 74 24 78 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_282_5_0 {
	meta:
		name = "_aligned_offset_recalloc"
		size = 163
		refs = "0033 _errno 0053 _aligned_msize 0069 _aligned_offset_realloc 0087 memset"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 33 FF 49 8B E9 48 8B DA 48 8B F1 48 85 D2 74 1D 33 D2 48 8D 47 E0 48 F7 F3 49 3B C0 73 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 4D 49 0F AF D8 48 85 C9 74 10 4C 8B 44 24 50 49 8B D1 E8 ?? ?? ?? ?? 48 8B F8 4C 8B 4C 24 50 4C 8B C5 48 8B D3 48 8B CE E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 74 16 48 3B FB 73 11 48 2B DF 48 8D 0C 38 33 D2 4C 8B C3 E8 ?? ?? ?? ?? 48 8B C6 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_284_0_0 {
	meta:
		name = "_concrt_static_cleanup"
		size = 24
		refs = "0007 ?HostModule@details@Concurrency@@3PEAUHINSTANCE__@@EA 000f ?CheckOneShotStaticDestruction@SchedulerBase@details@Concurrency@@SAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 83 3D ?? ?? ?? ?? 00 74 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_284_5_0 {
	meta:
		name = "??$ConcRT_FillBuffer@$0EAB@@details@Concurrency@@YAXAEAY0EAB@_WPEB_WPEAD@Z"
		size = 277
		refs = "002b ?SafeFastCurrentContext@SchedulerBase@details@Concurrency@@SAPEAVContextBase@23@XZ 0041 ?GetScheduler@ContextBase@details@Concurrency@@QEBAPEAVSchedulerBase@23@XZ 004c __imp_GetCurrentThreadId 0056 ?ScheduleGroupRefCount@ContextBase@details@Concurrency@@QEBAIXZ 0085 ??_C@_1CG@CBCHDCDB@?$AA?$FL?$AA?$CF?$AAd?$AA?3?$AA?$CF?$AAd?$AA?3?$AA?$CF?$AAd?$AA?3?$AA?$CF?$AAd?$AA?$CI?$AA?$CF?$AAd?$AA?$CJ?$AA?$FN?$AA?5?$AA?$AA@ 009b swprintf_s 00be vswprintf_s"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 18 48 89 70 20 48 89 50 10 57 41 54 41 55 41 56 41 57 48 83 EC 40 33 FF 4D 8B E8 4C 8B F1 8B DF E8 ?? ?? ?? ?? 41 BC 01 04 00 00 4C 8B F8 48 85 C0 74 6B 48 8B C8 E8 ?? ?? ?? ?? 48 85 C0 74 5E FF 1