private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "__invoke_watson_if_error"
		size = 38
		refs = "0020 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 02 EB 19 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_0_1_0 {
	meta:
		name = "__invoke_watson_if_oneof"
		size = 60
		refs = "0033 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 74 10 8B 45 08 3B 45 0C 74 0D 8B 4D 08 3B 4D 10 74 05 8B 45 08 EB 1C 8B 55 24 52 8B 45 20 50 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 E8 ?? ?? ?? ?? 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_0_2_0 {
	meta:
		name = "__wspawnvpe"
		size = 1260
		refs = "0038 ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 003d ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0046 ??_C@_1FC@DNJFLFHP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAe?$AAx?$AAe?$AAc?$AA?2?$AAs?$AAp@ 004d __CrtDbgReportW 0061 __errno 0075 ??_C@_1BG@NJDAJIEB@?$AA_?$AAw?$AAs?$AAp?$AAa?$AAw?$AAn?$AAv?$AAp?$AAe?$AA?$AA@ 007f __invalid_parameter 00b5 ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 012e ??_C@_1BK@DKFDJEHE@?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01a9 ??_C@_1BM@CNLEOMNN@?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0228 ??_C@_1CG@JGBGIIEL@?$AA?$CK?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 02a4 __wspawnve 02c9 _wcschr 02e3 ??_C@_1MO@HCMFGKOL@?$AA_?$AAw?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAd?$AAb?$AAg?$AA?$CI?$AA?$CG?$AAe?$AAn?$AAv?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK@ 02ee ??_C@_0CJ@IPJLLODM@f?3?2dd?2vctools?2crt?2crtw32?2exec?2sp@ 02f5 ??_C@_19IJOJOJIB@?$AAP?$AAA?$AAT?$AAH?$AA?$AA@ 0300 __wdupenv_s_dbg 0309 __invoke_watson_if_oneof 032b __calloc_dbg 0354 __wgetpath 037b _wcslen 03b4 ??_C@_1DE@CIMJAAKO@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA2?$AA6?$AA0?$AA?0?$AA?5?$AAL?$AA?$CC?$AA?2?$AA?2?$AA?$CC?$AA?$CJ?$AA?$AA@ 03b9 ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 03c7 _wcscat_s 03d0 __invoke_watson_if_error 040d ??_C@_1DK@JGMPLNHE@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA2?$AA6?$AA0?$AA?0?$AA?5?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?$CJ?$AA?$AA@ 046a ___doserrno 04c9 __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 40 56 C7 45 F8 00 00 00 00 C7 45 FC 00 00 00 00 83 7D 0C 00 74 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 45 EC 89 45 E8 83 7D E8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 50 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 59 04 00 00 8B 55 0C 0F B7 02 85 C0 74 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 4D E4 89 4D E0 83 7D E0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 51 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 51 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 DC 03 00 00 83 7D 10 00 74 09 C7 45 DC 01 00 00 00 EB 07 C7 45 DC 00 00 00 00 8B 45 DC 89 45 D8 83 7D D8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 52 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 52 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 63 03 00 00 8B 55 10 83 3A 00 74 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 45 D4 89 45 D0 83 7D D0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 53 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 53 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 E8 02 00 00 8B 55 10 8B 02 0F B7 08 85 C9 74 09 C7 45 CC 01 00 00 00 EB 07 C7 45 CC 00 00 00 00 8B 55 CC 89 55 C8 83 7D C8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 54 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D C8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 54 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 69 02 00 00 E8 ?? ?? ?? ?? 8B 08 89 4D C0 E8 ?? ?? ?? ?? C7 00 00 00 00 00 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 7D F4 FF 0F 85 83 00 00 00 E8 ?? ?? ?? ?? 83 38 02 75 79 6A 2F 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 67 6A 00 6A 63 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 16 6A 16 6A 63 68 ?? ?? ?? ?? 6A 02 68 ?? ?? ?? ?? 6A 00 8D 4D F8 51 E8 ?? ?? ?? ?? 83 C4 18 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 27 83 7D F8 00 74 21 6A 67 68 ?? ?? ?? ?? 6A 02 6A 02 68 04 01 00 00 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 83 7D FC 00 75 05 E9 68 01 00 00 8B 55 F8 89 55 F0 68 03 01 00 00 8B 45 FC 50 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F0 83 7D F0 00 0F 84 40 01 00 00 8B 55 FC 0F B7 02 85 C0 0F 84 32 01 00 00 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 8D 44 42 FE 89 45 C4 8B 4D C4 0F B7 11 83 FA 5C 74 40 8B 45 C4 0F B7 08 83 F9 2F 74 35 6A 00 68 89 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 04 01 00 00 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 03 F0 81 FE 04 01 00 00 73 36 6A 00 68 90 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 0C 52 68 04 01 00 00 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 EB 02 EB 75 E8 ?? ?? ?? ?? C7 00 00 00 00 00 8B 4D 14 51 8B 55 10 52 8B 45 FC 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 7D F4 FF 75 42 E8 ?? ?? ?? ?? 83 38 02 74 3A E8 ?? ?? ?? ?? 83 38 15 74 30 8B 55 FC 0F B7 02 83 F8 5C 74 0B 8B 4D FC 0F B7 11 83 FA 2F 75 18 8B 45 FC 0F B7 48 02 83 F9 5C 74 0E 8B 55 FC 0F B7 42 02 83 F8 2F 74 02 EB 05 E9 9E FE FF FF E8 ?? ?? ?? ?? 83 38 00 75 0A E8 ?? ?? ?? ?? 8B 4D C0 89 08 83 7D FC 00 74 0E 6A 02 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 83 7D F8 00 74 0E 6A 02 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F4 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "__cwait"
		size = 177
		refs = "0013 __errno 002d __imp__WaitForSingleObject@8 003f __imp__GetExitCodeProcess@8 0051 __imp__GetLastError@0 006a ___doserrno 007d __dosmaperr 0098 __imp__CloseHandle@4"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 7D 0C FF 74 06 83 7D 0C FE 75 13 E8 ?? ?? ?? ?? C7 00 0A 00 00 00 83 C8 FF E9 88 00 00 00 6A FF 8B 45 0C 50 FF 15 ?? ?? ?? ?? 85 C0 75 1A 8D 4D F8 51 8B 55 0C 52 FF 15 ?? ?? ?? ?? 85 C0 74 08 8B 45 0C 89 45 F4 EB 43 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 06 75 17 E8 ?? ?? ?? ?? C7 00 0A 00 00 00 E8 ?? ?? ?? ?? 8B 4D FC 89 08 EB 0F FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 F4 FF FF FF FF C7 45 F8 FF FF FF FF 8B 55 0C 52 FF 15 ?? ?? ?? ?? 83 7D 08 00 74 08 8B 45 08 8B 4D F8 89 08 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "___common_dexp_cout_rare"
		size = 912
		refs = "0011 __imldExpHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 83 EC 4C 8B 45 08 F2 0F 10 15 ?? ?? ?? ?? 0F B7 0D ?? ?? ?? ?? F2 0F 10 00 0F B7 40 06 25 F0 7F 00 00 C1 E8 04 F2 0F 11 44 24 40 3D FF 07 00 00 0F 84 01 03 00 00 3D CA 03 00 00 0F 8E D9 02 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 82 A7 02 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 79 02 00 00 F2 0F 10 0D ?? ?? ?? ?? 0F 28 F0 F2 0F 59 C8 F2 0F 11 4C 24 30 F2 0F 11 54 24 40 F2 0F 10 54 24 30 F2 0F 58 15 ?? ?? ?? ?? F2 0F 11 54 24 38 F2 0F 10 5C 24 38 8B 74 24 38 8B C6 83 E6 3F F2 0F 5C 1D ?? ?? ?? ?? F2 0F 11 5C 24 30 F2 0F 10 64 24 30 F2 0F 59 25 ?? ?? ?? ?? F2 0F 10 6C 24 30 F2 0F 5C F4 F2 0F 59 2D ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 5C F5 F2 0F 59 DE C1 E6 04 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE C1 E8 06 F2 0F 58 1D ?? ?? ?? ?? 66 0F 2F 05 ?? ?? ?? ?? F2 0F 59 DE F2 0F 10 8E ?? ?? ?? ?? 8D 90 FF 03 00 00 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE F2 0F 59 DE F2 0F 58 DE F2 0F 58 9E ?? ?? ?? ?? F2 0F 59 D9 72 73 81 E2 FF 07 00 00 F2 0F 58 D9 81 FA FE 07 00 00 77 27 C1 E2 04 81 E1 0F 80 FF FF 0B CA 66 89 4C 24 46 F2 0F 59 5C 24 40 8B 45 0C F2 0F 11 18 33 C0 83 C4 4C 5E 8B E5 5D C3 4A 81 E2 FF 07 00 00 0F B7 44 24 46 C1 E2 04 25 0F 80 FF FF 0B C2 66 89 44 24 46 33 C0 F2 0F 59 5C 24 40 F2 0F 59 1D ?? ?? ?? ?? 8B 55 0C F2 0F 11 1A 83 C4 4C 5E 8B E5 5D C3 05 3B 04 00 00 25 FF 07 00 00 8B D0 0F B7 4C 24 46 C1 E2 04 81 E1 0F 80 FF FF 0B CA 66 89 4C 24 46 83 F8 32 F2 0F 10 54 24 40 F2 0F 59 DA F2 0F 59 D1 0F 28 C2 F2 0F 58 C3 77 14 F2 0F 59 05 ?? ?? ?? ?? 8B 45 0C F2 0F 11 00 E9 CC 00 00 00 F2 0F 11 04 24 F2 0F 10 04 24 8B 45 0C F2 0F 5C D0 F2 0F 11 54 24 08 F2 0F 10 4C 24 08 F2 0F 58 D9 F2 0F 11 5C 24 08 F2 0F 10 14 24 F2 0F 59 15 ?? ?? ?? ?? F2 0F 11 54 24 10 F2 0F 10 24 24 F2 0F 10 5C 24 10 F2 0F 58 E3 F2 0F 11 64 24 18 F2 0F 10 74 24 18 F2 0F 10 6C 24 10 F2 0F 5C F5 F2 0F 11 74 24 20 F2 0F 10 04 24 F2 0F 10 7C 24 20 F2 0F 5C C7 F2 0F 11 44 24 28 F2 0F 10 4C 24 08 F2 0F 10 54 24 28 F2 0F 58 D1 F2 0F 11 54 24 28 F2 0F 10 5C 24 20 F2 0F 59 1D ?? ?? ?? ?? F2 0F 11 5C 24 20 F2 0F 10 64 24 28 F2 0F 59 25 ?? ?? ?? ?? F2 0F 11 64 24 28 F2 0F 10 74 24 20 F2 0F 10 6C 24 28 F2 0F 58 F5 F2 0F 11 30 B8 04 00 00 00 83 C4 4C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C0 8B 45 0C F2 0F 11 00 B8 04 00 00 00 83 C4 4C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C0 8B 45 0C F2 0F 11 00 B8 03 00 00 00 83 C4 4C 5E 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? 8B 45 0C F2 0F 58 C8 F2 0F 11 08 33 C0 83 C4 4C 5E 8B E5 5D C3 0F B6 44 24 47 A9 80 00 00 00 75 15 F2 0F 59 C0 8B 45 0C F2 0F 11 00 33 C0 83 C4 4C 5E 8B E5 5D C3 F7 44 24 44 FF FF 0F 00 75 E1 83 7C 24 40 00 75 DA 8B 45 0C F2 0F 11 10 33 C0 83 C4 4C 5E 8B E5 5D C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "___vdecl_fmod4"
		size = 89
		refs = "0016 __CIfmod"
	strings:
		$1 = { 83 EC 40 C5 FE 7F 04 24 C5 FE 7F 4C 24 20 DD 04 24 DD 44 24 20 E8 ?? ?? ?? ?? DD 1C 24 DD 44 24 08 DD 44 24 28 E8 ?? ?? ?? ?? DD 5C 24 08 DD 44 24 10 DD 44 24 30 E8 ?? ?? ?? ?? DD 5C 24 10 DD 44 24 18 DD 44 24 38 E8 ?? ?? ?? ?? DD 5C 24 18 C5 FE 6F 04 24 83 C4 40 C3 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "___isa_available_init"
		size = 677
		refs = "0007 ___security_cookie 0014 ___isa_available 001d ___isa_enabled 002c _IsProcessorFeaturePresent@4 0199 ___favor 029d @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 C7 05 ?? ?? ?? ?? 00 00 00 00 A1 ?? ?? ?? ?? 83 C8 01 A3 ?? ?? ?? ?? 6A 0A E8 ?? ?? ?? ?? 85 C0 0F 84 5B 02 00 00 C7 45 F0 00 00 00 00 C7 45 F4 00 00 00 00 C7 45 F8 00 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 8B 0D ?? ?? ?? ?? 83 C9 02 89 0D ?? ?? ?? ?? 8D 75 E0 33 C0 33 C9 0F A2 89 06 89 5E 04 89 4E 08 89 56 0C BA 04 00 00 00 6B C2 00 8B 4C 05 E0 89 4D D0 BA 04 00 00 00 C1 E2 00 8B 44 15 E0 35 47 65 6E 75 B9 04 00 00 00 6B D1 03 8B 4C 15 E0 81 F1 69 6E 65 49 0B C1 BA 04 00 00 00 D1 E2 8B 4C 15 E0 81 F1 6E 74 65 6C 0B C1 75 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8A 55 D4 88 55 DF 8D 75 E0 B8 01 00 00 00 33 C9 0F A2 89 06 89 5E 04 89 4E 08 89 56 0C B8 04 00 00 00 6B C8 03 BA 04 00 00 00 6B C2 00 8B 4C 0D E0 89 4C 05 F0 BA 04 00 00 00 D1 E2 B8 04 00 00 00 C1 E0 00 8B 4C 15 E0 89 4C 05 F0 BA 04 00 00 00 6B C2 00 8B 4C 05 E0 89 4D D8 0F B6 55 DF 85 D2 74 6F 8B 45 D8 25 F0 3F FF 0F 3D C0 06 01 00 74 53 8B 4D D8 81 E1 F0 3F FF 0F 81 F9 60 06 02 00 74 42 8B 55 D8 81 E2 F0 3F FF 0F 81 FA 70 06 02 00 74 31 8B 45 D8 25 F0 3F FF 0F 3D 50 06 03 00 74 22 8B 4D D8 81 E1 F0 3F FF 0F 81 F9 60 06 03 00 74 11 8B 55 D8 81 E2 F0 3F FF 0F 81 FA 70 06 03 00 75 0D A1 ?? ?? ?? ?? 83 C8 01 A3 ?? ?? ?? ?? 83 7D D0 07 7C 4F 8D 75 E0 B8 07 00 00 00 33 C9 0F A2 89 06 89 5E 04 89 4E 08 89 56 0C B9 04 00 00 00 C1 E1 00 BA 04 00 00 00 D1 E2 8B 44 0D E0 89 44 15 F0 B9 04 00 00 00 C1 E1 00 8B 54 0D E0 81 E2 00 02 00 00 74 0D A1 ?? ?? ?? ?? 83 C8 02 A3 ?? ?? ?? ?? B9 04 00 00 00 C1 E1 00 8B 54 0D F0 81 E2 00 00 10 00 0F 84 81 00 00 00 C7 05 ?? ?? ?? ?? 02 00 00 00 A1 ?? ?? ?? ?? 83 C8 04 A3 ?? ?? ?? ?? B9 04 00 00 00 C1 E1 00 8B 54 0D F0 81 E2 00 00 00 08 74 56 B8 04 00 00 00 C1 E0 00 8B 4C 05 F0 81 E1 00 00 00 10 74 42 C7 05 ?? ?? ?? ?? 03 00 00 00 8B 15 ?? ?? ?? ?? 83 CA 08 89 15 ?? ?? ?? ?? B8 04 00 00 00 D1 E0 8B 4C 05 F0 83 E1 20 74 19 C7 05 ?? ?? ?? ?? 05 00 00 00 8B 15 ?? ?? ?? ?? 83 CA 20 89 15 ?? ?? ?? ?? 33 C0 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "__time32"
		size = 106
		refs = "000c __imp__GetSystemTimeAsFileTime@4 002c __aulldiv"
	strings:
		$1 = { 55 8B EC 83 EC 10 8D 45 F0 50 FF 15 ?? ?? ?? ?? 8B 4D F0 81 E9 00 80 3E D5 8B 55 F4 81 DA DE B1 9D 01 6A 00 68 80 96 98 00 52 51 E8 ?? ?? ?? ?? 89 45 F8 89 55 FC 83 7D FC 00 7C 19 7F 09 81 7D F8 7F D2 FF 7F 76 0E C7 45 F8 FF FF FF FF C7 45 FC FF FF FF FF 83 7D 08 00 74 08 8B 45 F8 8B 4D 08 89 01 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "___sse2_tanhf4"
		size = 240
		refs = "000f _static_const_table"
	strings:
		$1 = { 8B C4 83 EC 70 83 E4 F0 89 44 24 34 0F 28 35 ?? ?? ?? ?? 0F 28 3D ?? ?? ?? ?? 0F 54 F8 0F 58 F7 0F 28 15 ?? ?? ?? ?? 0F 54 D6 0F 29 54 24 10 0F 28 1D ?? ?? ?? ?? 0F C2 DF 02 0F 57 C7 0F 28 15 ?? ?? ?? ?? 0F 28 CF 0F C2 CA 02 0F 54 CB 0F 28 2D ?? ?? ?? ?? 8B 4C 24 10 8B 14 8D ?? ?? ?? ?? 89 14 24 0F 54 E9 8B 4C 24 14 8B 14 8D ?? ?? ?? ?? 89 54 24 04 8B 4C 24 18 8B 14 8D ?? ?? ?? ?? 89 54 24 08 8B 4C 24 1C 8B 14 8D ?? ?? ?? ?? 89 54 24 0C 0F 28 15 ?? ?? ?? ?? 0F 5C F2 0F 5C FE 0F 28 E7 0F 59 E7 0F 28 1D ?? ?? ?? ?? 0F 59 DC 0F 58 1D ?? ?? ?? ?? 0F 56 C5 0F 28 15 ?? ?? ?? ?? 0F 59 E2 0F 58 25 ?? ?? ?? ?? 0F 59 E7 0F 28 14 24 0F 28 F3 0F 59 F2 0F 58 F4 0F 59 E2 0F 58 E3 0F 5E F4 0F 55 CE 0F 56 C1 8B 64 24 34 C3 90 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
		size = 215
		refs = "0019 __getptd 0047 ___ptlocinfo 0058 ___globallocalestatus 005f ___updatetlocinfo 0070 ___ptmbcinfo 0088 ___updatetmbcinfo"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C6 40 0C 00 83 7D 08 00 0F 85 A6 00 00 00 E8 ?? ?? ?? ?? 8B 4D FC 89 41 08 8B 55 FC 8B 42 08 8B 4D FC 8B 50 6C 89 11 8B 45 FC 8B 48 08 8B 55 FC 8B 41 68 89 42 04 8B 4D FC 8B 11 3B 15 ?? ?? ?? ?? 74 1B 8B 45 FC 8B 48 08 8B 51 70 23 15 ?? ?? ?? ?? 75 0A E8 ?? ?? ?? ?? 8B 4D FC 89 01 8B 55 FC 8B 42 04 3B 05 ?? ?? ?? ?? 74 1C 8B 4D FC 8B 51 08 8B 42 70 23 05 ?? ?? ?? ?? 75 0B E8 ?? ?? ?? ?? 8B 4D FC 89 41 04 8B 55 FC 8B 42 08 8B 48 70 83 E1 02 75 1C 8B 55 FC 8B 42 08 8B 48 70 83 C9 02 8B 55 FC 8B 42 08 89 48 70 8B 4D FC C6 41 0C 01 EB 10 8B 55 08 8B 02 8B 4A 04 8B 55 FC 89 02 89 4A 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_8_1_0 {
	meta:
		name = "??1_LocaleUpdate@@QAE@XZ"
		size = 43
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 0F B6 48 0C 85 C9 74 15 8B 55 FC 8B 42 08 8B 48 70 83 E1 FD 8B 55 FC 8B 42 08 89 48 70 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_3_0 {
	meta:
		name = "__wcsnicoll"
		size = 590
		refs = "0008 ___locale_changed 0036 ??_C@_1CC@ICKKAGJA@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 003b ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0044 ??_C@_1FG@EJDCBLCG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?2@ 004b __CrtDbgReportW 005f __errno 0073 ??_C@_1BG@PCPANGGF@?$AA_?$AAw?$AAc?$AAs?$AAn?$AAi?$AAc?$AAo?$AAl?$AAl?$AA?$AA@ 007d __invalid_parameter 00b1 ??_C@_1CC@CNADELFK@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 012f ??_C@_1CC@JLPHKJPH@?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 0243 __wcsnicoll_l"
	strings:
		$1 = { 55 8B EC 83 EC 28 83 3D ?? ?? ?? ?? 00 0F 85 21 02 00 00 83 7D 08 00 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 89 45 F0 83 7D F0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 73 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 73 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 BC 01 00 00 83 7D 0C 00 74 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 55 EC 89 55 E8 83 7D E8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 74 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 74 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 41 01 00 00 81 7D 10 FF FF FF 7F 77 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 4D E4 89 4D E0 83 7D E0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 75 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 75 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 C3 00 00 00 8B 45 08 0F B7 08 83 F9 41 7C 19 8B 55 08 0F B7 02 83 F8 5A 7F 0E 8B 4D 08 0F B7 11 83 C2 20 89 55 DC EB 09 8B 45 08 0F B7 08 89 4D DC 66 8B 55 DC 66 89 55 FC 8B 45 0C 0F B7 08 83 F9 41 7C 19 8B 55 0C 0F B7 02 83 F8 5A 7F 0E 8B 4D 0C 0F B7 11 83 C2 20 89 55 D8 EB 09 8B 45 0C 0F B7 08 89 4D D8 66 8B 55 D8 66 89 55 F8 8B 45 08 83 C0 02 89 45 08 8B 4D 0C 83 C1 02 89 4D 0C 8B 55 10 83 EA 01 89 55 10 74 18 0F B7 45 FC 85 C0 74 10 0F B7 4D FC 0F B7 55 F8 3B CA 0F 84 61 FF FF FF 0F B7 45 FC 0F B7 4D F8 2B C1 EB 18 EB 16 6A 00 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_4_0 {
	meta:
		name = "__wcsnicoll_l"
		size = 739
		refs = "0036 ??_C@_1CC@ICKKAGJA@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 003b ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0044 ??_C@_1FG@EJDCBLCG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?2@ 004b __CrtDbgReportW 005f __errno 0073 ??_C@_1BK@EONLMOKH@?$AA_?$AAw?$AAc?$AAs?$AAn?$AAi?$AAc?$AAo?$AAl?$AAl?$AA_?$AAl?$AA?$AA@ 007d __invalid_parameter 00b1 ??_C@_1CC@CNADELFK@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 012f ??_C@_1CC@JLPHKJPH@?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 018f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0197 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0263 ??1_LocaleUpdate@@QAE@XZ 029c ___crtCompareStringW"
	strings:
		$1 = { 55 8B EC 83 EC 48 83 7D 10 00 75 07 33 C0 E9 CC 02 00 00 83 7D 08 00 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 89 45 F0 83 7D F0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 43 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 43 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 51 02 00 00 83 7D 0C 00 74 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 55 EC 89 55 E8 83 7D E8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 44 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 44 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 D6 01 00 00 81 7D 10 FF FF FF 7F 77 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 4D E4 89 4D E0 83 7D E0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 45 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 45 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 58 01 00 00 8B 45 14 50 8D 4D B8 E8 ?? ?? ?? ?? 8D 4D B8 E8 ?? ?? ?? ?? 8B 08 BA 04 00 00 00 C1 E2 00 83 BC 11 A0 00 00 00 00 0F 85 B9 00 00 00 8B 45 08 0F B7 08 83 F9 41 7C 19 8B 55 08 0F B7 02 83 F8 5A 7F 0E 8B 4D 08 0F B7 11 83 C2 20 89 55 DC EB 09 8B 45 08 0F B7 08 89 4D DC 66 8B 55 DC 66 89 55 FC 8B 45 0C 0F B7 08 83 F9 41 7C 19 8B 55 0C 0F B7 02 83 F8 5A 7F 0E 8B 4D 0C 0F B7 11 83 C2 20 89 55 D8 EB 09 8B 45 0C 0F B7 08 89 4D D8 66 8B 55 D8 66 89 55 F8 8B 45 08 83 C0 02 89 45 08 8B 4D 0C 83 C1 02 89 4D 0C 8B 55 10 83 EA 01 89 55 10 74 18 0F B7 45 FC 85 C0 74 10 0F B7 4D FC 0F B7 55 F8 3B CA 0F 84 61 FF FF FF 0F B7 45 FC 0F B7 4D F8 2B C1 89 45 D0 8D 4D B8 E8 ?? ?? ?? ?? 8B 45 D0 EB 73 8B 55 10 52 8B 45 0C 50 8B 4D 10 51 8B 55 08 52 68 01 10 00 00 8D 4D B8 E8 ?? ?? ?? ?? 8B 00 B9 04 00 00 00 C1 E1 00 8B 94 08 A0 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 18 89 45 D4 83 7D D4 00 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 45 CC FF FF FF 7F 8D 4D B8 E8 ?? ?? ?? ?? 8B 45 CC EB 14 8B 45 D4 83 E8 02 89 45 C8 8D 4D B8 E8 ?? ?? ?? ?? 8B 45 C8 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "__setjmp"
		size = 56
		refs = "001a __except_list"
	strings:
		$1 = { 8B 54 24 04 89 2A 89 5A 04 89 7A 08 89 72 0C 89 62 10 8B 04 24 89 42 14 64 A1 ?? ?? ?? ?? 89 42 18 83 F8 FF 75 09 C7 42 1C FF FF FF FF EB 06 8B 40 0C 89 42 1C 2B C0 C3 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "___libm_sse2_atan2"
		size = 1302
		refs = "013d _a2 0145 _b2 0155 _P_TBL 015e _SGN_TBL 0176 _ATAN_TBL 0223 _P_TBL2 023c _SELECT_B 02d2 _SGNMASK 02da _pi_table 02f2 _pi2_table 032b _POW55 0338 _INVEXPMASK 0344 _EXPMASK 043a _pi4_table"
	strings:
		$1 = { 83 EC 14 66 0F C5 C0 03 25 F0 7F 00 00 66 0F 13 44 24 04 2D 70 38 00 00 3D 00 0F 00 00 66 0F 13 4C 24 0C 0F 87 D2 02 00 00 66 0F C5 C1 03 25 F0 7F 00 00 2D 70 38 00 00 3D 00 0F 00 00 0F 87 B8 02 00 00 66 0F 14 C1 66 0F 57 ED 66 0F 57 DB B8 00 08 00 00 66 0F C4 E8 03 66 0F FD E9 66 0F 73 D5 1D F3 0F 53 DD 66 0F 57 E4 B9 00 38 00 00 66 0F C4 E1 03 66 0F 73 F3 1D 66 0F FD DC F2 0F 59 D8 66 0F 57 D2 66 0F 57 F6 66 0F 57 FF B8 00 80 00 00 66 0F C4 F0 02 B9 FF 7F 00 00 66 0F C4 F9 03 66 0F FE DE 66 0F 54 DF F2 0F 10 EB 66 0F C5 C3 03 B9 40 40 00 00 66 0F C4 D1 03 F2 0F 5D DA 66 0F 50 D0 66 0F 73 F0 01 66 0F 73 D0 01 F2 0F C2 EA 02 66 0F 73 F1 01 66 0F 73 D1 01 F2 0F 10 F1 F2 0F 10 F9 F2 0F 10 D0 B9 00 00 00 00 66 0F C4 F1 00 F2 0F 5C FE F2 0F 10 E0 F2 0F 59 F3 F2 0F 59 E3 F2 0F 59 FB 66 0F 54 C5 F2 0F 5C C6 66 0F 54 CD F2 0F 58 E1 F2 0F 5C C7 25 F0 7F 00 00 2D 9E 3F 00 00 3D 61 04 00 00 0F 87 AE 00 00 00 F2 0F 5E C4 66 0F C5 CB 03 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? 66 0F C5 C5 00 03 D2 66 0F 28 34 D5 ?? ?? ?? ?? 66 0F 28 0C D5 ?? ?? ?? ?? 81 E9 9E 3F 00 00 F7 D0 83 E0 01 03 C8 03 C9 66 0F 28 2C CD ?? ?? ?? ?? 66 0F 57 E9 66 0F 58 EE F2 0F 10 F5 66 0F 15 ED 83 C4 14 66 0F 57 C8 F2 0F 10 E1 F2 0F 59 C0 F2 0F 59 D0 F2 0F 58 D8 F2 0F 58 CE F2 0F 5C F1 F2 0F 58 F4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D8 F2 0F 59 E0 F2 0F 58 F5 F2 0F 59 D4 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 D3 F2 0F 58 D6 F2 0F 58 CA 66 0F 28 C1 C3 05 AE 03 00 00 3D AE 03 00 00 0F 87 A3 00 00 00 66 0F 57 E4 B9 F0 3F 00 00 66 0F C4 E1 03 F2 0F 5E E1 83 C4 14 03 D2 66 0F 28 34 D5 ?? ?? ?? ?? 66 0F 14 DB 66 0F 57 C6 66 0F 57 D6 66 0F 57 DE 66 0F 28 3C D5 ?? ?? ?? ?? 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 2D ?? ?? ?? ?? 66 0F 54 1C D5 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 59 C4 F2 0F 10 F2 F2 0F 59 D2 F2 0F 59 CA F2 0F 58 EA F2 0F 59 F2 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 EA F2 0F 58 F8 66 0F 58 FB F2 0F 59 CE F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 F2 0F 58 EF 66 0F 15 FF F2 0F 58 EF 66 0F 28 C5 C3 66 0F 12 4C 24 0C 66 0F 12 44 24 04 66 0F C5 C1 03 25 F0 7F 00 00 66 0F C5 C8 03 81 E1 F0 7F 00 00 3B C8 7F 2D 66 0F C5 C9 03 81 F9 FF 7F 00 00 7F 08 83 C4 14 F2 0F 5E C1 C3 83 C4 14 66 0F 54 05 ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 57 C2 C3 83 C4 14 66 0F 54 05 ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 57 C2 C3 66 0F C5 C8 03 81 E1 F0 7F 00 00 66 0F C5 C1 03 25 F0 7F 00 00 81 F9 F0 7F 00 00 0F 84 A5 00 00 00 3D F0 7F 00 00 0F 84 52 01 00 00 66 0F 12 1D ?? ?? ?? ?? BA 00 04 00 00 66 0F 12 25 ?? ?? ?? ?? 66 0F 57 F6 66 0F 12 3D ?? ?? ?? ?? 83 F9 00 74 35 83 F8 00 74 50 03 D1 2B D0 81 FA 00 08 00 00 0F 87 2F FF FF FF 81 C2 F0 3B 00 00 66 0F C4 F2 03 66 0F 54 C4 66 0F 54 CC 66 0F 56 C6 66 0F 56 CF E9 C1 FC FF FF 81 EA 70 03 00 00 F2 0F 59 C3 66 0F C5 C8 03 81 E1 F0 7F 00 00 83 F9 00 0F 84 2A 01 00 00 EB AB 81 C2 70 03 00 00 F2 0F 59 CB 66 0F C5 C1 03 25 F0 7F 00 00 83 F8 00 0F 84 34 01 00 00 EB 91 66 0F 7E C2 F2 0F 10 D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B CA 83 F9 00 75 26 66 0F 73 D0 3F 66 0F 73 F0 3F 3D F0 7F 00 00 73 19 66 0F 28 2D ?? ?? ?? ?? 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 83 C4 14 C3 66 0F 7E C8 F2 0F 10 D1 66 0F 73 D2 20 66 0F 7E D1 BA 00 00 00 80 23 D1 81 E1 FF FF 0F 00 0B C8 83 F9 00 75 1E 83 FA 00 75 21 83 C4 14 66 0F 28 2D ?? ?? ?? ?? 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 C3 83 C4 14 F2 0F 10 C1 C3 83 C4 14 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 58 EE 66 0F 70 F5 EE 66 0F 58 EE 66 0F 56 C5 C3 66 0F 7E C8 F2 0F 10 D1 66 0F 73 D2 20 66 0F 7E D1 BA 00 00 00 80 23 D1 81 E1 FF FF 0F 00 0B C8 83 F9 00 75 AE 66 0F 73 D0 3F 66 0F 73 F0 3F 83 FA 00 75 04 83 C4 14 C3 83 C4 14 66 0F 28 2D ?? ?? ?? ?? 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 C3 66 0F C5 D1 03 81 E2 00 80 00 00 83 FA 00 74 15 66 0F 28 2D ?? ?? ?? ?? 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 83 C4 14 C3 83 C4 14 66 0F 28 2D ?? ?? ?? ?? 66 0F 73 D0 3F 66 0F 73 F0 3F 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 C3 }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "_atan2l"
		size = 31
		refs = "0016 _atan2"
	strings:
		$1 = { 55 8B EC 83 EC 08 DD 45 10 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_507_3_0 {
	meta:
		name = "_fmodl"
		size = 31
		refs = "0016 _fmod"
	strings:
		$1 = { 55 8B EC 83 EC 08 DD 45 10 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_81_407_2 {
	meta:
		name = "_hypot"
		size = 31
		refs = "0016 __hypot"
	strings:
		$1 = { 55 8B EC 83 EC 08 DD 45 10 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1183_1_0 {
	meta:
		name = "_hypotl"
		size = 31
		refs = "0016 __hypot"
	strings:
		$1 = { 55 8B EC 83 EC 08 DD 45 10 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_982_0_0 {
	meta:
		name = "_nextafter"
		size = 31
		refs = "0016 _nexttoward"
	strings:
		$1 = { 55 8B EC 83 EC 08 DD 45 10 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1301_0_0 {
	meta:
		name = "_nextafterl"
		size = 31
		refs = "0016 _nexttowardl"
	strings:
		$1 = { 55 8B EC 83 EC 08 DD 45 10 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_924_4_0 {
	meta:
		name = "_powl"
		size = 31
		refs = "0016 _pow"
	strings:
		$1 = { 55 8B EC 83 EC 08 DD 45 10 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_11_1_0 {
	meta:
		name = "_cargl"
		size = 91
		refs = "0020 _creall 0047 _cimagl 0052 _atan2l"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_325_0_0 {
	meta:
		name = "_cabs"
		size = 91
		refs = "0020 _cimag 0047 _creal 0052 _hypot"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1183_0_0 {
	meta:
		name = "_cabsl"
		size = 91
		refs = "0020 _cimagl 0047 _creall 0052 _hypotl"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_992_0_0 {
	meta:
		name = "_carg"
		size = 91
		refs = "0020 _creal 0047 _cimag 0052 _atan2"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "___libm_sse2_atanf"
		size = 416
		refs = "000d _BMASK1 0019 _SGNMASK_S 0021 _BMASK2 0085 _ONEMASK 00b4 _cv 00c7 _atan_tbl 00fe _cvs 015c _pi_table"
	strings:
		$1 = { B9 C0 01 00 00 66 0F 6E D1 F3 0F 10 1D ?? ?? ?? ?? 66 0F 57 E4 F3 0F 10 3D ?? ?? ?? ?? 66 0F 12 35 ?? ?? ?? ?? 66 0F 73 F2 18 0F 54 D8 66 0F C5 D0 01 0F 54 F8 66 0F 57 C9 8B C2 81 E2 F8 7F 00 00 81 EA 00 3D 00 00 81 FA F8 22 00 00 0F 87 99 00 00 00 66 0F D4 DA B9 50 40 00 00 66 0F C4 E1 03 66 0F D4 FA 66 0F 73 F3 1D 66 0F C4 C9 03 66 0F 73 F7 1D F2 0F C2 E3 06 66 0F 56 DE F2 0F 10 C7 66 0F 12 2D ?? ?? ?? ?? F2 0F 5D D9 66 0F 54 C4 F2 0F 59 FB 66 0F 54 EC F2 0F 5C C3 F2 0F 58 FD F2 0F 5E C7 66 0F C5 D3 03 81 EA 9F 3F 00 00 66 0F 12 25 ?? ?? ?? ?? 25 00 80 00 00 66 0F C4 C8 03 66 0F 12 34 D5 ?? ?? ?? ?? 66 0F 57 F1 66 0F 57 C8 F2 0F 59 C0 F2 0F 59 E1 F2 0F 58 CE F2 0F 59 C4 F2 0F 58 C1 66 0F 5A C0 C3 81 C2 80 1D 00 00 81 FA 7F 40 00 00 77 35 F3 0F 10 15 ?? ?? ?? ?? F3 0F 10 25 ?? ?? ?? ?? F3 0F 59 FF F3 0F 59 E0 F3 0F 59 D0 F3 0F 10 EF F3 0F 59 FF F3 0F 59 E5 F3 0F 59 FA F3 0F 58 FC F3 0F 58 C7 C3 81 C2 80 1F 00 00 81 FA 80 5F 00 00 73 1B B8 01 00 80 3F 66 0F 7E C1 81 FA 80 00 00 00 0F 42 C1 66 0F 6E C8 F3 0F 59 C9 C3 F3 0F 10 15 ?? ?? ?? ?? F3 0F 10 1D ?? ?? ?? ?? 81 FA 7F 7F 00 00 77 19 25 00 80 00 00 66 0F 57 C0 66 0F C4 C0 01 0F 56 D0 0F 56 C3 F3 0F 58 C2 C3 66 0F 7E C2 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 74 D5 F3 0F 58 C0 C3 }
	condition:
		$1
}

rule file_13_1_0 {
	meta:
		name = "_rand_s"
		size = 605
		refs = "0008 _g_pfnRtlGenRandom 000f __imp__DecodePointer@4 0039 ??_C@_1CK@GFDNDKK@?$AA_?$AAR?$AAa?$AAn?$AAd?$AAo?$AAm?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 003e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0047 ??_C@_1EO@GANOMFFN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAr?$AAa@ 004e __CrtDbgReportW 0062 __errno 0076 ??_C@_1O@IJGPPOGF@?$AAr?$AAa?$AAn?$AAd?$AA_?$AAs?$AA?$AA@ 0080 __invalid_parameter 00ac ??_C@_1BK@GAEMIDIL@?$AAA?$AAD?$AAV?$AAA?$AAP?$AAI?$AA3?$AA2?$AA?4?$AAD?$AAL?$AAL?$AA?$AA@ 00b2 __imp__LoadLibraryExW@12 00c1 __imp__GetLastError@0 0103 ??_C@_1GA@EBEDGGGB@?$AA?$CI?$AA?$CC?$AAr?$AAa?$AAn?$AAd?$AA_?$AAs?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAa?$AAv?$AAa?$AAi?$AAl?$AAa?$AAb?$AAl?$AAe?$AA?5?$AAo?$AAn?$AA?5?$AAt?$AAh?$AAi@ 015c ??_C@_0BC@JEAENNKH@SystemFunction036?$AA@ 0166 __imp__GetProcAddress@8 01c8 __get_errno_from_oserr 020a __imp__EncodePointer@4 0231 __imp__FreeLibrary@4"
	strings:
		$1 = { 55 8B EC 83 EC 28 56 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 F8 83 7D 08 00 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 4D F4 89 4D F0 83 7D F0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 3E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 C7 01 00 00 8B 45 08 C7 00 00 00 00 00 83 7D F8 00 0F 85 91 01 00 00 68 00 08 00 00 6A 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 1D FF 15 ?? ?? ?? ?? 83 F8 57 75 12 6A 00 6A 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 79 33 C9 74 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 55 EC 89 55 E8 83 7D E8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 56 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 FD 00 00 00 68 ?? ?? ?? ?? 8B 4D FC 51 FF 15 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 0F 85 8D 00 00 00 33 D2 74 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 45 E4 89 45 E0 83 7D E0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 5C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E0 00 75 44 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 E8 ?? ?? ?? ?? 89 30 6A 00 6A 5C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 EB 54 8B 55 F8 52 FF 15 ?? ?? ?? ?? 89 45 DC 6A 00 FF 15 ?? ?? ?? ?? 89 45 D8 8B 45 DC B9 ?? ?? ?? ?? 87 01 3B 45 D8 74 0A 8B 55 FC 52 FF 15 ?? ?? ?? ?? 6A 04 8B 45 08 50 FF 55 F8 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 EB 02 33 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "??_U@YAPAXIABUnothrow_t@std@@@Z"
		size = 21
		refs = "000c ??2@YAPAXIABUnothrow_t@std@@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_27_230_3 {
	meta:
		name = "??$_Swap_adl@PAU_Container_proxy@std@@@std@@YAXAAPAU_Container_proxy@0@0@Z"
		size = 21
		refs = "000c ??$swap@PAU_Container_proxy@std@@@std@@YAXAAPAU_Container_proxy@0@0@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_100_219_1 {
	meta:
		name = "??$_Swap_adl@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@YAXAAPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@0@Z"
		size = 21
		refs = "000c ??$swap@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@YAXAAPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@0@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_113_223_2 {
	meta:
		name = "??$_Swap_adl@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@YAXAAPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@0@Z"
		size = 21
		refs = "000c ??$swap@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@YAXAAPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@0@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_64_213_2 {
	meta:
		name = "??$send@I@Concurrency@@YA_NAAV?$ITarget@I@0@ABI@Z"
		size = 21
		refs = "000c ??$send@I@Concurrency@@YA_NPAV?$ITarget@I@0@ABI@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_64_214_2 {
	meta:
		name = "??$send@I@Concurrency@@YA_NPAV?$ITarget@I@0@ABI@Z"
		size = 21
		refs = "000c ??$_send@I@_Originator@details@Concurrency@@SA_NPAV?$ITarget@I@2@ABI@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_83_215_1 {
	meta:
		name = "??$send@W4agent_status@Concurrency@@@Concurrency@@YA_NAAV?$ITarget@W4agent_status@Concurrency@@@0@ABW4agent_status@0@@Z"
		size = 21
		refs = "000c ??$send@W4agent_status@Concurrency@@@Concurrency@@YA_NPAV?$ITarget@W4agent_status@Concurrency@@@0@ABW4agent_status@0@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_83_216_1 {
	meta:
		name = "??$send@W4agent_status@Concurrency@@@Concurrency@@YA_NPAV?$ITarget@W4agent_status@Concurrency@@@0@ABW4agent_status@0@@Z"
		size = 21
		refs = "000c ??$_send@W4agent_status@Concurrency@@@_Originator@details@Concurrency@@SA_NPAV?$ITarget@W4agent_status@Concurrency@@@2@ABW4agent_status@2@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_98_106_1 {
	meta:
		name = "?_Lstat@sys@tr2@std@@YA?AW4file_type@123@PBDAAH@Z"
		size = 21
		refs = "000c ?_Stat@sys@tr2@std@@YA?AW4file_type@123@PBDAAH@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_98_107_1 {
	meta:
		name = "?_Lstat@sys@tr2@std@@YA?AW4file_type@123@PB_WAAH@Z"
		size = 21
		refs = "000c ?_Stat@sys@tr2@std@@YA?AW4file_type@123@PB_WAAH@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_101_224_2 {
	meta:
		name = "?publish_segment@_Helper@_Concurrent_vector_base_v4@details@Concurrency@@SAXAAU_Segment_t@234@PAX@Z"
		size = 21
		refs = "000c ??$_StoreWithRelease@PAX@?$_Subatomic_impl@$03@details@Concurrency@@SAXACRAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_140_3_0 {
	meta:
		name = "?strrchr@@YAPADPADH@Z"
		size = 21
		refs = "000c _strrchr"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_52_0_2 {
	meta:
		name = "__LDscale"
		size = 21
		refs = "000c __Dscale"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_111_0_2 {
	meta:
		name = "__LDunscale"
		size = 21
		refs = "000c __Dunscale"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_409_5_0 {
	meta:
		name = "___create_locale"
		size = 21
		refs = "000c __create_locale"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_914_2_0 {
	meta:
		name = "__atoi_l"
		size = 21
		refs = "000c __atol_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_717_2_0 {
	meta:
		name = "__ldscale"
		size = 21
		refs = "000c __dscale"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_1306_2_0 {
	meta:
		name = "__ldunscale"
		size = 21
		refs = "000c __dunscale"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_736_3_0 {
	meta:
		name = "__wtoi_l"
		size = 21
		refs = "000c __wtol_l"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_840_18_0 {
	meta:
		name = "_strtold"
		size = 21
		refs = "000c _strtod"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_366_17_0 {
	meta:
		name = "_wcstold"
		size = 21
		refs = "000c _wcstod"
	strings:
		$1 = { 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "__ioinit"
		size = 1245
		refs = "0006 __sehtable$__ioinit 000b __except_handler4 001d ___security_cookie 0033 __lock 0047 ??_C@_0CI@BIOGDJKL@f?3?2dd?2vctools?2crt?2crtw32?2lowio?2i@ 0052 __calloc_dbg 0075 __local_unwind4 0091 ___pioinfo 0097 __nhandle 0141 __imp__GetStartupInfoW@4 02ec __imp__GetFileType@4 0331 ___crtInitializeCriticalSectionEx 03cb __imp__GetStdHandle@4 047c ___piob 04c1 __unlock"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 84 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 6A 0B E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 68 85 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 40 6A 20 E8 ?? ?? ?? ?? 83 C4 14 89 45 E4 83 7D E4 00 75 22 C7 45 B8 FF FF FF FF 6A FE 8D 45 F0 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 B8 E9 47 04 00 00 B9 04 00 00 00 6B D1 00 8B 45 E4 89 82 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 20 00 00 00 EB 09 8B 4D E4 83 C1 40 89 4D E4 BA 04 00 00 00 6B C2 00 8B 88 ?? ?? ?? ?? 81 C1 00 08 00 00 39 4D E4 73 75 8B 55 E4 C6 42 04 00 8B 45 E4 C7 00 FF FF FF FF 8B 4D E4 C6 41 05 0A 8B 55 E4 C7 42 08 00 00 00 00 8B 45 E4 8A 48 24 80 E1 80 8B 55 E4 88 4A 24 8B 45 E4 8A 48 24 80 E1 7F 8B 55 E4 88 4A 24 B8 01 00 00 00 6B C8 00 8B 55 E4 C6 44 0A 25 0A B8 01 00 00 00 C1 E0 00 8B 4D E4 C6 44 01 25 0A 8B 55 E4 C7 42 38 00 00 00 00 8B 45 E4 C6 40 34 00 E9 69 FF FF FF 8D 8D 74 FF FF FF 51 FF 15 ?? ?? ?? ?? 0F B7 55 A6 85 D2 0F 84 FB 01 00 00 83 7D A8 00 0F 84 F1 01 00 00 8B 45 A8 8B 08 89 4D DC 8B 55 A8 83 C2 04 89 55 D4 8B 45 D4 03 45 DC 89 45 D8 81 7D DC 00 08 00 00 7D 08 8B 4D DC 89 4D C4 EB 07 C7 45 C4 00 08 00 00 8B 55 C4 89 55 DC C7 45 D0 01 00 00 00 EB 09 8B 45 D0 83 C0 01 89 45 D0 8B 0D ?? ?? ?? ?? 3B 4D DC 0F 8D D6 00 00 00 68 BF 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 40 6A 20 E8 ?? ?? ?? ?? 83 C4 14 89 45 E4 83 7D E4 00 75 0E 8B 15 ?? ?? ?? ?? 89 55 DC E9 A7 00 00 00 8B 45 D0 8B 4D E4 89 0C 85 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 83 C2 20 89 15 ?? ?? ?? ?? EB 09 8B 45 E4 83 C0 40 89 45 E4 8B 4D D0 8B 14 8D ?? ?? ?? ?? 81 C2 00 08 00 00 39 55 E4 73 66 8B 45 E4 C6 40 04 00 8B 4D E4 C7 01 FF FF FF FF 8B 55 E4 C6 42 05 0A 8B 45 E4 C7 40 08 00 00 00 00 8B 4D E4 8A 51 24 80 E2 80 8B 45 E4 88 50 24 B9 01 00 00 00 6B D1 00 8B 45 E4 C6 44 10 25 0A B9 01 00 00 00 C1 E1 00 8B 55 E4 C6 44 0A 25 0A 8B 45 E4 C7 40 38 00 00 00 00 8B 4D E4 C6 41 34 00 E9 7C FF FF FF E9 12 FF FF FF C7 45 E0 00 00 00 00 EB 1B 8B 55 E0 83 C2 01 89 55 E0 8B 45 D4 83 C0 01 89 45 D4 8B 4D D8 83 C1 04 89 4D D8 8B 55 E0 3B 55 DC 0F 8D 92 00 00 00 8B 45 D8 83 38 FF 0F 84 81 00 00 00 8B 4D D8 83 39 FE 74 79 8B 55 D4 0F BE 02 83 E0 01 74 6E 8B 4D D4 0F BE 11 83 E2 08 75 10 8B 45 D8 8B 08 51 FF 15 ?? ?? ?? ?? 85 C0 74 53 8B 55 E0 C1 FA 05 8B 45 E0 83 E0 1F C1 E0 06 03 04 95 ?? ?? ?? ?? 89 45 E4 8B 4D E4 8B 55 D8 8B 02 89 01 8B 4D E4 8B 55 D4 8A 02 88 41 04 6A 00 68 A0 0F 00 00 8B 4D E4 83 C1 0C 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 E4 8B 42 08 83 C0 01 8B 4D E4 89 41 08 E9 47 FF FF FF C7 45 E0 00 00 00 00 EB 09 8B 55 E0 83 C2 01 89 55 E0 83 7D E0 03 0F 8D 48 01 00 00 B8 04 00 00 00 6B C8 00 8B 55 E0 C1 E2 06 03 91 ?? ?? ?? ?? 89 55 E4 8B 45 E4 83 38 FF 74 0C 8B 4D E4 83 39 FE 0F 85 05 01 00 00 8B 55 E4 C6 42 04 81 83 7D E0 00 75 09 C7 45 BC F6 FF FF FF EB 1C 83 7D E0 01 75 09 C7 45 C0 F5 FF FF FF EB 07 C7 45 C0 F4 FF FF FF 8B 45 C0 89 45 BC 8B 4D BC 51 FF 15 ?? ?? ?? ?? 89 45 CC 83 7D CC FF 0F 84 85 00 00 00 83 7D CC 00 74 7F 8B 55 CC 52 FF 15 ?? ?? ?? ?? 89 45 C8 83 7D C8 00 74 6C 8B 45 E4 8B 4D CC 89 08 8B 55 C8 81 E2 FF 00 00 00 83 FA 02 75 12 8B 45 E4 0F BE 48 04 83 C9 40 8B 55 E4 88 4A 04 EB 1D 8B 45 C8 25 FF 00 00 00 83 F8 03 75 10 8B 4D E4 0F BE 51 04 83 CA 08 8B 45 E4 88 50 04 6A 00 68 A0 0F 00 00 8B 4D E4 83 C1 0C 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 E4 8B 42 08 83 C0 01 8B 4D E4 89 41 08 EB 35 8B 55 E4 0F BE 42 04 83 C8 40 8B 4D E4 88 41 04 8B 55 E4 C7 02 FE FF FF FF 83 3D ?? ?? ?? ?? 00 74 13 8B 45 E0 8B 0D ?? ?? ?? ?? 8B 14 81 C7 42 10 FE FF FF FF EB 13 8B 45 E4 0F BE 48 04 81 C9 80 00 00 00 8B 55 E4 88 4A 04 E9 A5 FE FF FF C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 0B E8 ?? ?? ?? ?? 83 C4 04 C3 33 C0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_15_1_0 {
	meta:
		name = "__ioterm"
		size = 155
		refs = "0024 ___pioinfo 0069 __imp__DeleteCriticalSection@4 007d __free_dbg"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 83 7D FC 40 7D 79 8B 4D FC 83 3C 8D ?? ?? ?? ?? 00 74 67 8B 55 FC 8B 04 95 ?? ?? ?? ?? 89 45 F8 EB 09 8B 4D F8 83 C1 40 89 4D F8 8B 55 FC 8B 04 95 ?? ?? ?? ?? 05 00 08 00 00 39 45 F8 73 18 8B 4D F8 83 79 08 00 74 0D 8B 55 F8 83 C2 0C 52 FF 15 ?? ?? ?? ?? EB CB 6A 02 8B 45 FC 8B 0C 85 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 FC C7 04 95 ?? ?? ?? ?? 00 00 00 00 E9 78 FF FF FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "___common_scos_cout_rare"
		size = 96
		altNames = "___common_ssin_cout_rare"
	strings:
		$1 = { 56 8B 54 24 08 8B 02 0F B7 4A 02 89 04 24 81 E1 80 7F 00 00 C1 E8 18 83 E0 7F F3 0F 10 0A 81 F9 80 7F 00 00 75 30 88 44 24 03 8B 54 24 0C 81 3C 24 00 00 80 7F 75 13 B8 01 00 00 00 66 0F EF C0 F3 0F 59 C8 F3 0F 11 0A 59 C3 F3 0F 59 C9 33 C0 F3 0F 11 0A 59 C3 33 C0 59 C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "__wspawnl"
		size = 521
		refs = "0029 ??_C@_1CC@MODLNCFO@?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0037 ??_C@_1EO@EHMNKFKC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAe?$AAx?$AAe?$AAc?$AA?2?$AAs?$AAp@ 003e __CrtDbgReportW 0052 __errno 0066 ??_C@_1BC@LBNADFPC@?$AA_?$AAw?$AAs?$AAp?$AAa?$AAw?$AAn?$AAl?$AA?$AA@ 0070 __invalid_parameter 00a6 ??_C@_1CM@PKENOFGE@?$AA?$CK?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 011f ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 019c ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 01fe __wspawnve"
	strings:
		$1 = { 55 8B EC 83 EC 20 83 7D 0C 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 89 45 F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 86 01 00 00 8B 55 0C 0F B7 02 85 C0 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 4D F4 89 4D F0 83 7D F0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 09 01 00 00 83 7D 10 00 74 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 45 EC 89 45 E8 83 7D E8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 39 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 90 00 00 00 8B 55 10 0F B7 02 85 C0 74 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 4D E4 89 4D E0 83 7D E0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 16 6A 00 8D 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "__get_sys_err_msg"
		size = 55
		refs = "000b ___sys_nerr 0029 ___sys_errlist"
	strings:
		$1 = { 55 8B EC 51 83 7D 08 00 7C 14 E8 ?? ?? ?? ?? 8B 4D 08 3B 08 7D 08 8B 55 08 89 55 FC EB 0A E8 ?? ?? ?? ?? 8B 00 89 45 FC E8 ?? ?? ?? ?? 8B 4D FC 8B 04 88 8B E5 5D C3 }
	condition:
		$1
}

rule file_18_2_0 {
	meta:
		name = "_strerror"
		size = 164
		refs = "0007 __getptd_noexit 0015 ??_C@_0EA@FCLIIPNN@Visual?5C?$CL?$CL?5CRT?3?5Not?5enough?5memor@ 002a ??_C@_0CJ@CJMICBEP@f?3?2dd?2vctools?2crt?2crtw32?2misc?2st@ 0038 __calloc_dbg 0068 ??_C@_1FC@IIDLIEAI@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAs?$AAt@ 006d ??_C@_1BC@CPPAPMCG@?$AAs?$AAt?$AAr?$AAe?$AAr?$AAr?$AAo?$AAr?$AA?$AA@ 0072 ??_C@_1GM@HFLCJPGH@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAe?$AAr?$AAr?$AAm?$AAs?$AAg?$AA?0?$AA?5?$AA?$CI?$AA9?$AA4?$AA?$CL?$AA3?$AA8?$AA?$CL?$AA2?$AA?$CJ?$AA?0?$AA?5?$AA_?$AAg?$AAe?$AAt@ 007b __get_sys_err_msg 008d _strcpy_s 0096 __invoke_watson_if_error"
	strings:
		$1 = { 55 8B EC 83 EC 0C E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 0A B8 ?? ?? ?? ?? E9 82 00 00 00 8B 45 FC 83 78 24 00 75 33 6A 4A 68 ?? ?? ?? ?? 6A 02 6A 01 68 86 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 89 45 F8 8B 4D FC 8B 55 F8 89 51 24 83 7D F8 00 75 09 B8 ?? ?? ?? ?? EB 48 EB 09 8B 45 FC 8B 48 24 89 4D F4 6A 00 6A 53 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 68 86 00 00 00 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_18_3_0 {
	meta:
		name = "_strerror_s"
		size = 330
		refs = "0030 ??_C@_1BO@PNINNIGK@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0035 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 003e ??_C@_1FC@IIDLIEAI@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAs?$AAt@ 0045 __CrtDbgReportW 0059 __errno 006d ??_C@_1BG@CLIBDOC@?$AAs?$AAt?$AAr?$AAe?$AAr?$AAr?$AAo?$AAr?$AA_?$AAs?$AA?$AA@ 0077 __invalid_parameter 00ab ??_C@_1CC@JNJFIMGE@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0112 ??_C@_1JI@GAHGOJMC@?$AAs?$AAt?$AAr?$AAn?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?0?$AA?5@ 0122 __get_sys_err_msg 0133 _strncpy_s 013c __invoke_watson_if_error"
	strings:
		$1 = { 55 8B EC 83 EC 14 C7 45 EC 00 00 00 00 83 7D 08 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 89 45 F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 7B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 7B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 BE 00 00 00 83 7D 0C 00 76 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 55 F4 89 55 F0 83 7D F0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 7C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 7C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 46 6A 00 68 89 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D 0C 83 E9 01 51 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 50 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "__SEH_prolog"
		size = 59
		refs = "0001 __except_handler3"
	strings:
		$1 = { 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 8B 44 24 10 89 6C 24 10 8D 6C 24 10 2B E0 53 56 57 8B 45 F8 89 65 E8 50 8B 45 FC C7 45 FC FF FF FF FF 89 45 F8 8D 45 F0 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_19_1_0 {
	meta:
		name = "__SEH_epilog"
		size = 17
	strings:
		$1 = { 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B C9 51 C3 }
	condition:
		$1
}

rule file_21_3_0 {
	meta:
		name = "__output_l"
		size = 5796
		refs = "000a ___security_cookie 0078 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0087 __errno 00c3 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 00c8 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00d4 ??_C@_1FA@KMIJDCIC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAi?$AAo?$AA?2?$AAo@ 00db __CrtDbgReportW 0109 ??_C@_1BE@IONLIDNC@?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAl?$AA?$AA@ 0113 __invalid_parameter 012b ??1_LocaleUpdate@@QAE@XZ 015d __fileno 0194 ___pioinfo 01a6 ___badioinfo 0240 ??_C@_1BAA@ODEGEDCK@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 02e9 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 03ef ___lookuptable 0453 $LN171 0468 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0476 __isleadbyte_l 0499 _write_char 04eb ??_C@_1CC@IFFHEMNF@?$AA?$CI?$AAc?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 0601 $LN167 0608 $LN172 0678 _get_int_arg 075b $LN168 0762 $LN173 08bc $LN169 08c3 $LN174 0903 _get_short_arg 092d _wctomb_s 09bb ___nullstring 09cd _strlen 0ac0 ___wnullstring 0bc5 __get_printf_count_output 0c01 ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 0d54 ??_C@_0CI@CMOPBIOD@f?3?2dd?2vctools?2crt?2crtw32?2stdio?2o@ 0d68 __malloc_dbg 0e07 __cfltcvt_tab 0e0e __imp__DecodePointer@4 0fbd _get_int64_arg 11e8 __aullrem 120d __aulldiv 13a2 _write_multi_char 13ca _write_string 155e __free_dbg 1597 @__security_check_cookie@4 15a0 $NORMAL_STATE$175 15a4 $LN130 15a8 $LN129 15ac $LN121 15b0 $LN117 15b4 $LN116 15b8 $LN112 15bc $LN96 15c0 $LN124 15c4 $LN123 15c8 $LN125 15cc $LN126 15d0 $LN122 15d4 $LN127 15ec $LN106 15f0 $LN98 15f4 $LN109 15f8 $LN97 15fc $LN110 1630 $LN65 1634 $LN93 1638 $LN81 163c $LN47 1640 $LN87 1644 $LN64 1648 $LN91 164c $LN52 1650 $LN70 1654 $LN42 1658 $LN48 165c $LN79 1660 $LN50 1664 $LN45 1668 $LN94"
	strings:
		$1 = { 55 8B EC 81 EC 38 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC C7 85 90 FD FF FF 00 00 00 00 C7 85 EC FD FF FF 00 00 00 00 C7 85 D4 FD FF FF 00 00 00 00 C7 85 E4 FD FF FF 00 00 00 00 C7 85 C4 FD FF FF 00 00 00 00 C7 85 98 FD FF FF 00 00 00 00 C7 85 A8 FD FF FF 00 00 00 00 C7 85 E8 FD FF FF 00 00 00 00 C7 85 AC FD FF FF 00 00 00 00 8B 45 10 50 8D 8D 00 FD FF FF E8 ?? ?? ?? ?? C7 85 B8 FD FF FF 00 00 00 00 E8 ?? ?? ?? ?? 89 85 64 FD FF FF 83 7D 08 00 74 0C C7 85 1C FD FF FF 01 00 00 00 EB 0A C7 85 1C FD FF FF 00 00 00 00 8B 8D 1C FD FF FF 89 8D 24 FD FF FF 83 BD 24 FD FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 24 FD FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 F4 FC FF FF FF FF FF FF 8D 8D 00 FD FF FF E8 ?? ?? ?? ?? 8B 85 F4 FC FF FF E9 57 14 00 00 8B 45 08 89 85 5C FD FF FF 8B 8D 5C FD FF FF 8B 51 0C 83 E2 40 0F 85 CB 00 00 00 8B 85 5C FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 D0 FD FF FF 83 BD D0 FD FF FF FF 74 2D 83 BD D0 FD FF FF FE 74 24 8B 8D D0 FD FF FF C1 F9 05 8B 95 D0 FD FF FF 83 E2 1F C1 E2 06 03 14 8D ?? ?? ?? ?? 89 95 14 FD FF FF EB 0A C7 85 14 FD FF FF ?? ?? ?? ?? 8B 85 14 FD FF FF 8A 48 24 D0 E1 D0 F9 0F BE D1 85 D2 75 56 83 BD D0 FD FF FF FF 74 2D 83 BD D0 FD FF FF FE 74 24 8B 85 D0 FD FF FF C1 F8 05 8B 8D D0 FD FF FF 83 E1 1F C1 E1 06 03 0C 85 ?? ?? ?? ?? 89 8D 30 FD FF FF EB 0A C7 85 30 FD FF FF ?? ?? ?? ?? 8B 95 30 FD FF FF 8A 42 24 C0 E0 00 C0 F8 07 0F BE C8 85 C9 74 0C C7 85 2C FD FF FF 00 00 00 00 EB 0A C7 85 2C FD FF FF 01 00 00 00 8B 95 2C FD FF FF 89 95 50 FD FF FF 83 BD 50 FD FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 09 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 50 FD FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 09 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 FC FC FF FF FF FF FF FF 8D 8D 00 FD FF FF E8 ?? ?? ?? ?? 8B 85 FC FC FF FF E9 DA 12 00 00 83 7D 0C 00 74 0C C7 85 10 FD FF FF 01 00 00 00 EB 0A C7 85 10 FD FF FF 00 00 00 00 8B 8D 10 FD FF FF 89 8D 48 FD FF FF 83 BD 48 FD FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 0C 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 48 FD FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 0C 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 EC FC FF FF FF FF FF FF 8D 8D 00 FD FF FF E8 ?? ?? ?? ?? 8B 85 EC FC FF FF E9 31 12 00 00 C7 85 DC FD FF FF 00 00 00 00 C7 85 E0 FD FF FF 00 00 00 00 C7 85 80 FD FF FF 00 00 00 00 C7 85 B8 FD FF FF 00 00 00 00 C7 85 7C FD FF FF 00 00 00 00 8B 45 0C 8A 08 88 8D F3 FD FF FF 0F BE 95 F3 FD FF FF 89 95 E4 FC FF FF 8B 45 0C 83 C0 01 89 45 0C 83 BD E4 FC FF FF 00 0F 84 B4 11 00 00 83 BD DC FD FF FF 00 0F 8C A7 11 00 00 0F BE 8D F3 FD FF FF 83 F9 20 7C 25 0F BE 95 F3 FD FF FF 83 FA 78 7F 19 0F BE 85 F3 FD FF FF 0F BE 88 ?? ?? ?? ?? 83 E1 0F 89 8D 28 FD FF FF EB 0A C7 85 28 FD FF FF 00 00 00 00 8B 95 28 FD FF FF 89 95 D0 FC FF FF 8B 85 D0 FC FF FF 8B 8D 80 FD FF FF 0F BE 94 C1 ?? ?? ?? ?? C1 FA 04 89 95 80 FD FF FF 8B 85 80 FD FF FF 89 85 40 FD FF FF 83 BD 40 FD FF FF 07 0F 87 25 11 00 00 8B 8D 40 FD FF FF FF 24 8D ?? ?? ?? ?? C7 85 AC FD FF FF 00 00 00 00 8D 8D 00 FD FF FF E8 ?? ?? ?? ?? 50 0F B6 95 F3 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 DD 00 00 00 8D 85 DC FD FF FF 50 8B 4D 08 51 0F B6 95 F3 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 0C 8A 08 88 8D F3 FD FF FF 8B 55 0C 83 C2 01 89 55 0C 0F BE 85 F3 FD FF FF 85 C0 74 0C C7 85 18 FD FF FF 01 00 00 00 EB 0A C7 85 18 FD FF FF 00 00 00 00 8B 8D 18 FD FF FF 89 8D 38 FD FF FF 83 BD 38 FD FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 8B 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 38 FD FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 8B 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 D4 FC FF FF FF FF FF FF 8D 8D 00 FD FF FF E8 ?? ?? ?? ?? 8B 85 D4 FC FF FF E9 2F 10 00 00 8D 85 DC FD FF FF 50 8B 4D 08 51 0F B6 95 F3 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C E9 ED 0F 00 00 C7 85 98 FD FF FF 00 00 00 00 8B 85 98 FD FF FF 89 85 A8 FD FF FF 8B 8D A8 FD FF FF 89 8D D4 FD FF FF 8B 95 D4 FD FF FF 89 95 C4 FD FF FF C7 85 EC FD FF FF 00 00 00 00 C7 85 E4 FD FF FF FF FF FF FF C7 85 AC FD FF FF 00 00 00 00 E9 9C 0F 00 00 0F BE 85 F3 FD FF FF 89 85 88 FD FF FF 8B 8D 88 FD FF FF 83 E9 20 89 8D 88 FD FF FF 83 BD 88 FD FF FF 10 77 6A 8B 95 88 FD FF FF 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 8D EC FD FF FF 83 C9 04 89 8D EC FD FF FF EB 45 8B 95 EC FD FF FF 83 CA 01 89 95 EC FD FF FF EB 34 8B 85 EC FD FF FF 83 C8 02 89 85 EC FD FF FF EB 23 8B 8D EC FD FF FF 81 C9 80 00 00 00 89 8D EC FD FF FF EB 0F 8B 95 EC FD FF FF 83 CA 08 89 95 EC FD FF FF E9 08 0F 00 00 0F BE 85 F3 FD FF FF 83 F8 2A 75 3A 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 D4 FD FF FF 83 BD D4 FD FF FF 00 7D 1D 8B 95 EC FD FF FF 83 CA 04 89 95 EC FD FF FF 8B 85 D4 FD FF FF F7 D8 89 85 D4 FD FF FF EB 18 6B 8D D4 FD FF FF 0A 0F BE 95 F3 FD FF FF 8D 44 11 D0 89 85 D4 FD FF FF E9 A5 0E 00 00 C7 85 E4 FD FF FF 00 00 00 00 E9 96 0E 00 00 0F BE 8D F3 FD FF FF 83 F9 2A 75 27 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 E4 FD FF FF 83 BD E4 FD FF FF 00 7D 0A C7 85 E4 FD FF FF FF FF FF FF EB 18 6B 85 E4 FD FF FF 0A 0F BE 8D F3 FD FF FF 8D 54 08 D0 89 95 E4 FD FF FF E9 46 0E 00 00 0F BE 85 F3 FD FF FF 89 85 8C FD FF FF 8B 8D 8C FD FF FF 83 E9 49 89 8D 8C FD FF FF 83 BD 8C FD FF FF 2E 0F 87 33 01 00 00 8B 95 8C FD FF FF 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D 0C 0F BE 11 83 FA 6C 75 1D 8B 45 0C 83 C0 01 89 45 0C 8B 8D EC FD FF FF 81 C9 00 10 00 00 89 8D EC FD FF FF EB 0F 8B 95 EC FD FF FF 83 CA 10 89 95 EC FD FF FF E9 E3 00 00 00 8B 45 0C 0F BE 08 83 F9 36 75 2C 8B 55 0C 0F BE 42 01 83 F8 34 75 20 8B 4D 0C 83 C1 02 89 4D 0C 8B 95 EC FD FF FF 81 CA 00 80 00 00 89 95 EC FD FF FF E9 87 00 00 00 8B 45 0C 0F BE 08 83 F9 33 75 29 8B 55 0C 0F BE 42 01 83 F8 32 75 1D 8B 4D 0C 83 C1 02 89 4D 0C 8B 95 EC FD FF FF 81 E2 FF 7F FF FF 89 95 EC FD FF FF EB 53 8B 45 0C 0F BE 08 83 F9 64 74 37 8B 55 0C 0F BE 02 83 F8 69 74 2C 8B 4D 0C 0F BE 11 83 FA 6F 74 21 8B 45 0C 0F BE 08 83 F9 75 74 16 8B 55 0C 0F BE 02 83 F8 78 74 0B 8B 4D 0C 0F BE 11 83 FA 58 75 02 EB 0F C7 85 80 FD FF FF 00 00 00 00 E9 F7 FB FF FF EB 23 8B 85 EC FD FF FF 83 C8 20 89 85 EC FD FF FF EB 12 8B 8D EC FD FF FF 81 C9 00 08 00 00 89 8D EC FD FF FF E9 E5 0C 00 00 0F BE 95 F3 FD FF FF 89 95 94 FD FF FF 8B 85 94 FD FF FF 83 E8 41 89 85 94 FD FF FF 83 BD 94 FD FF FF 37 0F 87 29 0A 00 00 8B 8D 94 FD FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 85 EC FD FF FF 25 30 08 00 00 75 12 8B 8D EC FD FF FF 81 C9 00 08 00 00 89 8D EC FD FF FF 8B 95 EC FD FF FF 81 E2 10 08 00 00 74 5B C7 85 20 FD FF FF 00 00 00 00 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 60 FD FF FF 0F B7 8D 60 FD FF FF 51 68 00 02 00 00 8D 95 F4 FD FF FF 52 8D 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 89 85 20 FD FF FF 83 BD 20 FD FF FF 00 74 0A C7 85 A8 FD FF FF 01 00 00 00 EB 32 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 78 FD FF FF BA 01 00 00 00 6B C2 00 8A 8D 78 FD FF FF 88 8C 05 F4 FD FF FF C7 85 E0 FD FF FF 01 00 00 00 8D 95 F4 FD FF FF 89 95 E8 FD FF FF E9 4A 09 00 00 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 B4 FD FF FF 83 BD B4 FD FF FF 00 74 0C 8B 8D B4 FD FF FF 83 79 04 00 75 23 8B 15 ?? ?? ?? ?? 89 95 E8 FD FF FF 8B 85 E8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 E0 FD FF FF EB 65 8B 8D EC FD FF FF 81 E1 00 08 00 00 74 2F 8B 95 B4 FD FF FF 8B 42 04 89 85 E8 FD FF FF 8B 8D B4 FD FF FF 0F BF 01 99 2B C2 D1 F8 89 85 E0 FD FF FF C7 85 AC FD FF FF 01 00 00 00 EB 28 C7 85 AC FD FF FF 00 00 00 00 8B 95 B4 FD FF FF 8B 42 04 89 85 E8 FD FF FF 8B 8D B4 FD FF FF 0F BF 11 89 95 E0 FD FF FF E9 96 08 00 00 8B 85 EC FD FF FF 25 30 08 00 00 75 12 8B 8D EC FD FF FF 81 C9 00 08 00 00 89 8D EC FD FF FF 83 BD E4 FD FF FF FF 75 0C C7 85 58 FD FF FF FF FF FF 7F EB 0C 8B 95 E4 FD FF FF 89 95 58 FD FF FF 8B 85 58 FD FF FF 89 85 B0 FD FF FF 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 E8 FD FF FF 8B 95 EC FD FF FF 81 E2 10 08 00 00 0F 84 82 00 00 00 83 BD E8 FD FF FF 00 75 0B A1 ?? ?? ?? ?? 89 85 E8 FD FF FF C7 85 AC FD FF FF 01 00 00 00 8B 8D E8 FD FF FF 89 8D 84 FD FF FF 8B 95 B0 FD FF FF 89 95 E0 FC FF FF 8B 85 B0 FD FF FF 83 E8 01 89 85 B0 FD FF FF 83 BD E0 FC FF FF 00 74 1E 8B 8D 84 FD FF FF 0F B7 11 85 D2 74 11 8B 85 84 FD FF FF 83 C0 02 89 85 84 FD FF FF EB BE 8B 8D 84 FD FF FF 2B 8D E8 FD FF FF D1 F9 89 8D E0 FD FF FF EB 75 83 BD E8 FD FF FF 00 75 0C 8B 15 ?? ?? ?? ?? 89 95 E8 FD FF FF 8B 85 E8 FD FF FF 89 85 9C FD FF FF 8B 8D B0 FD FF FF 89 8D F0 FC FF FF 8B 95 B0 FD FF FF 83 EA 01 89 95 B0 FD FF FF 83 BD F0 FC FF FF 00 74 1E 8B 85 9C FD FF FF 0F BE 08 85 C9 74 11 8B 95 9C FD FF FF 83 C2 01 89 95 9C FD FF FF EB BE 8B 85 9C FD FF FF 2B 85 E8 FD FF FF 89 85 E0 FD FF FF E9 2A 07 00 00 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 44 FD FF FF E8 ?? ?? ?? ?? 85 C0 0F 85 AC 00 00 00 33 D2 74 0C C7 85 54 FD FF FF 01 00 00 00 EB 0A C7 85 54 FD FF FF 00 00 00 00 8B 85 54 FD FF FF 89 85 4C FD FF FF 83 BD 4C FD FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 9A 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 4C FD FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9A 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 DC FC FF FF FF FF FF FF 8D 8D 00 FD FF FF E8 ?? ?? ?? ?? 8B 85 DC FC FF FF E9 19 09 00 00 E9 5F 06 00 00 8B 95 EC FD FF FF 83 E2 20 74 12 8B 85 44 FD FF FF 66 8B 8D DC FD FF FF 66 89 08 EB 0E 8B 95 44 FD FF FF 8B 85 DC FD FF FF 89 02 C7 85 A8 FD FF FF 01 00 00 00 E9 25 06 00 00 C7 85 98 FD FF FF 01 00 00 00 0F BE 8D F3 FD FF FF 83 C1 20 88 8D F3 FD FF FF 8B 95 EC FD FF FF 83 CA 40 89 95 EC FD FF FF 8D 85 F4 FD FF FF 89 85 E8 FD FF FF C7 85 7C FD FF FF 00 02 00 00 83 BD E4 FD FF FF 00 7D 0C C7 85 E4 FD FF FF 06 00 00 00 EB 37 83 BD E4 FD FF FF 00 75 18 0F BE 8D F3 FD FF FF 83 F9 67 75 0C C7 85 E4 FD FF FF 01 00 00 00 EB 16 81 BD E4 FD FF FF 00 02 00 00 7E 0A C7 85 E4 FD FF FF 00 02 00 00 81 BD E4 FD FF FF A3 00 00 00 7E 5A 68 DF 06 00 00 68 ?? ?? ?? ?? 6A 02 8B 95 E4 FD FF FF 81 C2 5D 01 00 00 52 E8 ?? ?? ?? ?? 83 C4 10 89 85 B8 FD FF FF 83 BD B8 FD FF FF 00 74 20 8B 85 B8 FD FF FF 89 85 E8 FD FF FF 8B 8D E4 FD FF FF 81 C1 5D 01 00 00 89 8D 7C FD FF FF EB 0A C7 85 E4 FD FF FF A3 00 00 00 8B 55 14 83 C2 08 89 55 14 8B 45 14 8B 48 F8 8B 50 FC 89 8D C8 FC FF FF 89 95 CC FC FF FF 8D 8D 00 FD FF FF E8 ?? ?? ?? ?? 50 8B 85 98 FD FF FF 50 8B 8D E4 FD FF FF 51 0F BE 95 F3 FD FF FF 52 8B 85 7C FD FF FF 50 8B 8D E8 FD FF FF 51 8D 95 C8 FC FF FF 52 B8 04 00 00 00 6B C8 06 8B 91 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? FF D0 83 C4 1C 8B 85 EC FD FF FF 25 80 00 00 00 74 36 83 BD E4 FD FF FF 00 75 2D 8D 8D 00 FD FF FF E8 ?? ?? ?? ?? 50 8B 8D E8 FD FF FF 51 BA 04 00 00 00 6B C2 09 8B 88 ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? FF D0 83 C4 08 0F BE 95 F3 FD FF FF 83 FA 67 75 3A 8B 85 EC FD FF FF 25 80 00 00 00 75 2D 8D 8D 00 FD FF FF E8 ?? ?? ?? ?? 50 8B 8D E8 FD FF FF 51 BA 04 00 00 00 C1 E2 03 8B 82 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? FF D0 83 C4 08 8B 8D E8 FD FF FF 0F BE 11 83 FA 2D 75 20 8B 85 EC FD FF FF 0D 00 01 00 00 89 85 EC FD FF FF 8B 8D E8 FD FF FF 83 C1 01 89 8D E8 FD FF FF 8B 95 E8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 E0 FD FF FF E9 F4 03 00 00 8B 85 EC FD FF FF 83 C8 40 89 85 EC FD FF FF C7 85 A4 FD FF FF 0A 00 00 00 E9 A4 00 00 00 C7 85 A4 FD FF FF 0A 00 00 00 E9 95 00 00 00 C7 85 E4 FD FF FF 08 00 00 00 C7 85 90 FD FF FF 07 00 00 00 EB 0A C7 85 90 FD FF FF 27 00 00 00 C7 85 A4 FD FF FF 10 00 00 00 8B 8D EC FD FF FF 81 E1 80 00 00 00 74 32 BA 01 00 00 00 6B C2 00 C6 84 05 D8 FD FF FF 30 8B 8D 90 FD FF FF 83 C1 51 BA 01 00 00 00 C1 E2 00 88 8C 15 D8 FD FF FF C7 85 C4 FD FF FF 02 00 00 00 EB 29 C7 85 A4 FD FF FF 08 00 00 00 8B 85 EC FD FF FF 25 80 00 00 00 74 12 8B 8D EC FD FF FF 81 C9 00 02 00 00 89 8D EC FD FF FF 8B 95 EC FD FF FF 81 E2 00 80 00 00 74 1D 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 BC FD FF FF 89 95 C0 FD FF FF E9 BB 00 00 00 8B 8D EC FD FF FF 81 E1 00 10 00 00 74 1D 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 BC FD FF FF 89 95 C0 FD FF FF E9 90 00 00 00 }
	condition:
		$1
}

rule file_21_4_0 {
	meta:
		name = "_get_int64_arg"
		size = 29
		altNames = "_get_crtdouble_arg"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 08 83 C1 08 8B 55 08 89 0A 8B 45 08 8B 08 8B 41 F8 8B 51 FC 5D C3 }
	condition:
		$1
}

rule file_21_5_0 {
	meta:
		name = "_get_int_arg"
		size = 26
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 08 83 C1 04 8B 55 08 89 0A 8B 45 08 8B 08 8B 41 FC 5D C3 }
	condition:
		$1
}

rule file_21_6_0 {
	meta:
		name = "_get_short_arg"
		size = 27
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 08 83 C1 04 8B 55 08 89 0A 8B 45 08 8B 08 66 8B 41 FC 5D C3 }
	condition:
		$1
}

rule file_21_7_0 {
	meta:
		name = "_write_char"
		size = 160
		refs = "0074 __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 08 8B 45 0C 8B 48 0C 83 E1 40 74 18 8B 55 0C 83 7A 08 00 75 0F 8B 45 10 8B 08 83 C1 01 8B 55 10 89 0A EB 73 8B 45 0C 8B 48 04 83 E9 01 89 4D FC 8B 55 0C 8B 45 FC 89 42 04 83 7D FC 00 7C 26 8B 4D 0C 8B 11 8A 45 08 88 02 0F BE 4D 08 81 E1 FF 00 00 00 89 4D F8 8B 55 0C 8B 02 83 C0 01 8B 4D 0C 89 01 EB 14 8B 55 0C 52 0F BE 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 83 7D F8 FF 75 0B 8B 4D 10 C7 01 FF FF FF FF EB 0D 8B 55 10 8B 02 83 C0 01 8B 4D 10 89 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_8_0 {
	meta:
		name = "_write_multi_char"
		size = 62
		refs = "0027 _write_char"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 45 FC 8B 4D 0C 83 E9 01 89 4D 0C 83 7D FC 00 7E 21 8B 55 14 52 8B 45 10 50 0F B6 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 14 83 3A FF 75 02 EB 02 EB CA 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_9_0 {
	meta:
		name = "_write_string"
		size = 177
		refs = "0065 _write_char"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 18 8B 08 89 4D F4 8B 55 10 8B 42 0C 83 E0 40 74 18 8B 4D 10 83 79 08 00 75 0F 8B 55 14 8B 02 03 45 0C 8B 4D 14 89 01 EB 7C 8B 55 18 C7 02 00 00 00 00 8B 45 0C 89 45 F8 8B 4D 0C 83 E9 01 89 4D 0C 83 7D F8 00 7E 4E 8B 55 08 8A 02 88 45 FF 8B 4D 14 51 8B 55 10 52 0F B6 45 FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 83 C1 01 89 4D 08 8B 55 14 83 3A FF 75 1E 8B 45 18 83 38 2A 75 14 8B 4D 14 51 8B 55 10 52 6A 3F E8 ?? ?? ?? ?? 83 C4 0C EB 02 EB 02 EB 9D 8B 45 18 83 38 00 75 08 8B 4D 18 8B 55 F4 89 11 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_6_0 {
	meta:
		name = "??$_InternalDeleteHelper@VWorkQueue@details@Concurrency@@@details@Concurrency@@YAXPAVWorkQueue@01@@Z"
		size = 50
		refs = "001e ??_GWorkQueue@details@Concurrency@@QAEPAXI@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 89 45 F8 8B 4D F8 89 4D FC 83 7D FC 00 74 0F 6A 01 8B 4D FC E8 ?? ?? ?? ?? 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_130_0 {
	meta:
		name = "?StaticDelete@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@SAXPAU1234@@Z"
		size = 50
		refs = "001e ??_GSegment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEPAXI@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 89 45 F8 8B 4D F8 89 4D FC 83 7D FC 00 74 0F 6A 01 8B 4D FC E8 ?? ?? ?? ?? 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_230_0 {
	meta:
		name = "?StaticDelete@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@SAXPAU1234@@Z"
		size = 50
		refs = "001e ??_GSegment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEPAXI@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 89 45 F8 8B 4D F8 89 4D FC 83 7D FC 00 74 0F 6A 01 8B 4D FC E8 ?? ?? ?? ?? 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_9_0 {
	meta:
		name = "??$swap@PAU_Node@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@@std@@YAXAAPAU_Node@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@0@Z"
		size = 63
		refs = "0009 ??$_Move@AAPAU_Node@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@@std@@YA$$QAPAU_Node@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@AAPAU12345@@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 08 89 4D FC 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 8B 10 89 11 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 8B 10 89 11 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_378_1 {
	meta:
		name = "??$swap@PAU?$_Task_impl@E@details@Concurrency@@@std@@YAXAAPAU?$_Task_impl@E@details@Concurrency@@0@Z"
		size = 63
		refs = "0009 ??$_Move@AAPAU?$_Task_impl@E@details@Concurrency@@@std@@YA$$QAPAU?$_Task_impl@E@details@Concurrency@@AAPAU123@@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 08 89 4D FC 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 8B 10 89 11 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 8B 10 89 11 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_379_1 {
	meta:
		name = "??$swap@PAU?$_Task_impl@_N@details@Concurrency@@@std@@YAXAAPAU?$_Task_impl@_N@details@Concurrency@@0@Z"
		size = 63
		refs = "0009 ??$_Move@AAPAU?$_Task_impl@_N@details@Concurrency@@@std@@YA$$QAPAU?$_Task_impl@_N@details@Concurrency@@AAPAU123@@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 08 89 4D FC 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 8B 10 89 11 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 8B 10 89 11 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_410_3 {
	meta:
		name = "??$swap@PAU_Container_proxy@std@@@std@@YAXAAPAU_Container_proxy@0@0@Z"
		size = 63
		refs = "0009 ??$_Move@AAPAU_Container_proxy@std@@@std@@YA$$QAPAU_Container_proxy@0@AAPAU10@@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 08 89 4D FC 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 8B 10 89 11 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 8B 10 89 11 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_411_3 {
	meta:
		name = "??$swap@PAU_ExceptionHolder@details@Concurrency@@@std@@YAXAAPAU_ExceptionHolder@details@Concurrency@@0@Z"
		size = 63
		refs = "0009 ??$_Move@AAPAU_ExceptionHolder@details@Concurrency@@@std@@YA$$QAPAU_ExceptionHolder@details@Concurrency@@AAPAU123@@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 08 89 4D FC 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 8B 10 89 11 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 8B 10 89 11 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_413_3 {
	meta:
		name = "??$swap@PAUscheduler_interface@Concurrency@@@std@@YAXAAPAUscheduler_interface@Concurrency@@0@Z"
		size = 63
		refs = "0009 ??$_Move@AAPAUscheduler_interface@Concurrency@@@std@@YA$$QAPAUscheduler_interface@Concurrency@@AAPAU12@@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 08 89 4D FC 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 8B 10 89 11 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 8B 10 89 11 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_405_2 {
	meta:
		name = "??$swap@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@YAXAAPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@0@Z"
		size = 63
		refs = "0009 ??$_Move@AAPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@YA$$QAPAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@AAPAV10@@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 08 89 4D FC 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 8B 10 89 11 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 8B 10 89 11 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_415_3 {
	meta:
		name = "??$swap@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@YAXAAPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@0@Z"
		size = 63
		refs = "0009 ??$_Move@AAPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@YA$$QAPAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@AAPAV10@@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 08 89 4D FC 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 8B 10 89 11 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 8B 10 89 11 8B E5 5D C3 }
	condition:
		$1
}

rule file_105_18_2 {
	meta:
		name = "??$swap@PAV_Concurrent_queue_rep@details@Concurrency@@@std@@YAXAAPAV_Concurrent_queue_rep@details@Concurrency@@0@Z"
		size = 63
		refs = "0009 ??$_Move@AAPAV_Concurrent_queue_rep@details@Concurrency@@@std@@YA$$QAPAV_Concurrent_queue_rep@details@Concurrency@@AAPAV123@@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 08 89 4D FC 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 8B 10 89 11 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 8B 10 89 11 8B E5 5D C3 }
	condition:
		$1
}

rule file_151_27_0 {
	meta:
		name = "??$swap@PAV_Ref_count_base@std@@@std@@YAXAAPAV_Ref_count_base@0@0@Z"
		size = 63
		refs = "0009 ??$_Move@AAPAV_Ref_count_base@std@@@std@@YA$$QAPAV_Ref_count_base@0@AAPAV10@@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 08 89 4D FC 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 8B 10 89 11 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 8B 10 89 11 8B E5 5D C3 }
	condition:
		$1
}

rule file_151_28_0 {
	meta:
		name = "??$swap@PAV__ExceptionPtr@@@std@@YAXAAPAV__ExceptionPtr@@0@Z"
		size = 63
		refs = "0009 ??$_Move@AAPAV__ExceptionPtr@@@std@@YA$$QAPAV__ExceptionPtr@@AAPAV1@@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 08 89 4D FC 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 8B 10 89 11 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 8B 10 89 11 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_11_0 {
	meta:
		name = "??0?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE@H@Z"
		size = 124
		refs = "0026 ??_C@_0CO@JCPJEILM@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0046 ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 006c _memset"
		altNames = "??0?$Hash@II@details@Concurrency@@QAE@H@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F8 8B 45 F8 8B 4D 08 89 08 8B 55 F8 C7 42 04 00 00 00 00 33 C0 88 45 FF 68 E1 02 00 00 68 ?? ?? ?? ?? 0F B6 4D FF 51 33 C9 8B 55 F8 8B 02 BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 8B 45 F8 8B 4D F4 89 48 08 8B 55 F8 8B 02 C1 E0 02 50 6A 00 8B 4D F8 8B 51 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F8 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_12_0 {
	meta:
		name = "??0?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAE@XZ"
		size = 23
		altNames = "??0?$ISource@I@Concurrency@@QAE@XZ ??0?$ISource@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ ??0?$ITarget@I@Concurrency@@QAE@XZ ??0?$ITarget@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ ??0?$List@UBoostedObject@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAE@XZ ??0?$List@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@@details@Concurrency@@QAE@XZ ??0?$LockFreePushStack@VContextNode@SchedulerBase@details@Concurrency@@@details@Concurrency@@QAE@XZ ??0?$_Func_base@EV?$task@_N@Concurrency@@@std@@QAE@XZ ??0?$_Func_base@V?$task@_N@Concurrency@@_N@std@@QAE@XZ ??0?$_Func_base@X$$$V@std@@QAE@XZ ??0?$_Func_base@XABI@std@@QAE@XZ ??0?$_Func_base@XPAV?$message@I@Concurrency@@@std@@QAE@XZ ??0?$_Func_base@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@QAE@XZ ??0?$_Func_base@XV?$task@_N@Concurrency@@@std@@QAE@XZ ??0?$_Func_base@_NABW4agent_status@Concurrency@@@std@@QAE@XZ ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@XZ ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@XZ ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@XZ ??0?$message_processor@I@Concurrency@@QAE@XZ ??0?$message_processor@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ ??0?$network_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@QAE@XZ ??0?$network_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ ??0?$network_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@QAE@XZ ??0?$network_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ ??0Block@_HeapManager@@QAE@XZ ??0ClaimTicket@VirtualProcessor@details@Concurrency@@QAE@XZ ??0Context@Concurrency@@QAE@XZ ??0Count@CollectionTypes@details@Concurrency@@QAE@XZ ??0DNameNode@@IAE@XZ ??0IExecutionContext@Concurrency@@QAE@XZ ??0IExecutionResource@Concurrency@@QAE@XZ ??0IResourceManager@Concurrency@@QAE@XZ ??0IScheduler@Concurrency@@QAE@XZ ??0ISchedulerProxy@Concurrency@@QAE@XZ ??0IThreadProxy@Concurrency@@QAE@XZ ??0IThreadProxyFactory@details@Concurrency@@QAE@XZ ??0ITopologyExecutionResource@Concurrency@@QAE@XZ ??0ITopologyNode@Concurrency@@QAE@XZ ??0IUMSCompletionList@Concurrency@@QAE@XZ ??0IUMSUnblockNotification@Concurrency@@QAE@XZ ??0ScheduleGroup@Concurrency@@QAE@XZ ??0Scheduler@Concurrency@@IAE@XZ ??0StructuredEvent@details@Concurrency@@QAE@XZ ??0UMSBaseObject@details@Concurrency@@QAE@XZ ??0_Chore@details@Concurrency@@IAE@XZ ??0_Container_base12@std@@QAE@XZ ??0_Facet_base@std@@QAE@XZ ??0_NonReentrantLock@details@Concurrency@@QAE@XZ ??0cancellation_token@Concurrency@@AAE@XZ ??0error_category@std@@QAE@XZ ??0ios_base@std@@IAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_13_0 {
	meta:
		name = "??0?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@XZ"
		size = 33
		refs = "000b ??0?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAE@XZ 0016 ??0_ReaderWriterLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_764_29_0 {
	meta:
		name = "??0?$SafeRWList@UBoostedObject@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@XZ"
		size = 33
		refs = "000b ??0?$List@UBoostedObject@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAE@XZ 0016 ??0_ReaderWriterLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_764_30_0 {
	meta:
		name = "??0?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QAE@XZ"
		size = 33
		refs = "000b ??0?$List@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@@details@Concurrency@@QAE@XZ 0016 ??0_ReaderWriterLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_14_0 {
	meta:
		name = "??0?$_SpinWait@$00@details@Concurrency@@QAE@P6AXXZ@Z"
		size = 35
		altNames = "??0?$_SpinWait@$0A@@details@Concurrency@@QAE@P6AXXZ@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 40 08 00 00 00 00 8B 4D FC 8B 55 08 89 51 0C 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_16_0 {
	meta:
		name = "??0ArrayNode@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE@PAPAVWorkQueue@23@@Z"
		size = 44
		altNames = "??0ArrayNode@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE@PAPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z ??0ArrayNode@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAE@PAPAVExternalStatistics@23@@Z ??0ArrayNode@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QAE@PAPAVScheduleGroupBase@23@@Z ??0ArrayNode@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@QAE@PAPAVScheduleGroupSegmentBase@23@@Z ??0ArrayNode@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE@PAPAVVirtualProcessor@23@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC C7 42 04 00 00 00 00 8B 45 FC C7 40 08 FF FF FF FF 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_17_0 {
	meta:
		name = "??0CancellationBeaconNode@CancellationBeaconStack@ContextBase@details@Concurrency@@QAE@XZ"
		size = 70
		refs = "001e ??_C@_0CO@JBGNEBPL@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 002d ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F8 8B 45 F8 C7 40 04 00 00 00 00 33 C9 88 4D FF 68 C5 03 00 00 68 ?? ?? ?? ?? 0F B6 55 FF 52 68 80 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 8B 45 F8 8B 4D F4 89 08 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_18_0 {
	meta:
		name = "??0CancellationBeaconStack@ContextBase@details@Concurrency@@QAE@XZ"
		size = 77
		refs = "0027 ??_C@_0CO@JBGNEBPL@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0033 ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F8 8B 45 F8 C7 00 00 00 00 00 8B 4D F8 C7 41 04 00 00 00 00 33 D2 88 55 FF 68 0A 04 00 00 68 ?? ?? ?? ?? 0F B6 45 FF 50 6A 10 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 8B 4D F8 8B 55 F4 89 51 08 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_20_0 {
	meta:
		name = "??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z"
		size = 419
		refs = "0006 __ehhandler$??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 0013 ___security_cookie 002a ??0Context@Concurrency@@QAE@XZ 003a ??_7ContextBase@details@Concurrency@@6B@ 00e0 ??0?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@XZ 0136 ??0?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE@H@Z 0148 ??0CancellationBeaconStack@ContextBase@details@Concurrency@@QAE@XZ 0157 ?GetNewContextId@SchedulerBase@details@Concurrency@@QAEIXZ 0184 ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 45 F0 C7 00 ?? ?? ?? ?? 8B 4D F0 C7 41 0C 00 00 00 00 8B 55 F0 C7 42 10 00 00 00 00 8B 45 F0 C7 40 14 00 00 00 00 8B 4D F0 8B 55 08 89 51 1C 8B 45 F0 C7 40 20 00 00 00 00 8B 4D F0 C7 41 24 00 00 00 00 8B 55 F0 C7 42 28 01 00 00 00 8B 45 F0 C7 40 2C 00 00 00 00 8B 4D F0 C7 41 30 00 00 00 00 8B 55 F0 C7 42 34 00 00 00 00 8B 45 F0 C7 40 38 00 00 00 00 8B 4D F0 C7 41 3C FF FF FF FF 8B 55 F0 C7 42 40 00 00 00 00 8B 45 F0 C7 40 44 00 00 00 00 8B 4D F0 8A 55 0C 88 51 4C 8B 45 F0 C6 40 4E 00 8B 4D F0 83 C1 50 E8 ?? ?? ?? ?? 8B 4D F0 C7 41 64 00 00 00 00 8B 55 F0 C7 42 68 FF FF FF FF 8B 45 F0 C7 40 6C FF FF FF FF 8B 4D F0 C7 41 70 00 00 00 00 8B 55 F0 C7 42 74 00 00 00 00 8B 45 F0 C7 40 78 00 00 00 00 8B 4D F0 C7 41 7C 00 00 00 00 6A 07 8B 4D F0 81 C1 80 00 00 00 E8 ?? ?? ?? ?? C6 45 FC 01 8B 4D F0 81 C1 8C 00 00 00 E8 ?? ?? ?? ?? C6 45 FC 02 8B 55 F0 8B 4A 1C E8 ?? ?? ?? ?? 8B 4D F0 89 41 08 8B 55 F0 8B 42 08 50 8B 4D F0 8B 51 1C 8B 45 F0 8B 12 8B 48 1C 8B 42 04 FF D0 50 6A 04 6A 01 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_22_24_0 {
	meta:
		name = "__ehhandler$??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_8_2 {
	meta:
		name = "__ehhandler$??$?0$$A6A_NABW4agent_status@Concurrency@@@Z@?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAE@A6A_NABW4agent_status@Concurrency@@@Z@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0$$A6A_NABW4agent_status@Concurrency@@@Z@?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAE@A6A_NABW4agent_status@Concurrency@@@Z@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_284_3 {
	meta:
		name = "__ehhandler$??$_Unchecked@V?$_Vector_val@U?$_Simple_types@PAX@std@@@std@@@std@@YAPBQAXV?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@PAX@std@@@std@@@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Unchecked@V?$_Vector_val@U?$_Simple_types@PAX@std@@@std@@@std@@YAPBQAXV?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@PAX@std@@@std@@@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1099_14_0 {
	meta:
		name = "__ehhandler$??0?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1099_17_0 {
	meta:
		name = "__ehhandler$??0?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_254_2 {
	meta:
		name = "__ehhandler$??0?$_Func_impl@U?$_Callable_obj@P6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@@std@@@2@_NABW4agent_status@Concurrency@@@std@@QAE@$$QAP6A_NABW4agent_status@Concurrency@@@ZABV?$allocator@V?$_Func_impl@U?$_Callable_obj@P6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@@std@@@2@_NABW4agent_status@Concurrency@@@std@@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Func_impl@U?$_Callable_obj@P6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@@std@@@2@_NABW4agent_status@Concurrency@@@std@@QAE@$$QAP6A_NABW4agent_status@Concurrency@@@ZABV?$allocator@V?$_Func_impl@U?$_Callable_obj@P6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@@std@@@2@_NABW4agent_status@Concurrency@@@std@@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_257_2 {
	meta:
		name = "__ehhandler$??0?$_Func_impl@U?$_Callable_obj@P6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@@std@@@2@_NABW4agent_status@Concurrency@@@std@@QAE@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Func_impl@U?$_Callable_obj@P6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@@std@@@2@_NABW4agent_status@Concurrency@@@std@@QAE@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_260_2 {
	meta:
		name = "__ehhandler$??0?$_Func_impl@U?$_Callable_obj@P6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@@std@@@2@_NABW4agent_status@Concurrency@@@std@@QAE@AAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Func_impl@U?$_Callable_obj@P6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@@std@@@2@_NABW4agent_status@Concurrency@@@std@@QAE@AAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_319_1 {
	meta:
		name = "__ehhandler$??0?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@QAE@PAV?$ISource@W4agent_status@Concurrency@@@1@IPAV?$ITarget@I@1@ABV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@QAE@PAV?$ISource@W4agent_status@Concurrency@@@1@IPAV?$ITarget@I@1@ABV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_67_1 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@D@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@D@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_206_2 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@G@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@G@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_209_2 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@_W@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@_W@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_151_39_0 {
	meta:
		name = "__ehhandler$??0?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@QAE@PAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@V?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@QAE@PAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@V?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_333_2 {
	meta:
		name = "__ehhandler$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_336_2 {
	meta:
		name = "__ehhandler$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_32_2 {
	meta:
		name = "__ehhandler$??0?$_String_alloc@$0A@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAE@ABV?$allocator@D@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_alloc@$0A@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAE@ABV?$allocator@D@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_249_3 {
	meta:
		name = "__ehhandler$??0?$_String_alloc@$0A@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAE@ABV?$allocator@G@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_alloc@$0A@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAE@ABV?$allocator@G@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_218_2 {
	meta:
		name = "__ehhandler$??0?$_String_alloc@$0A@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAE@ABV?$allocator@_W@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_alloc@$0A@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAE@ABV?$allocator@_W@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_117_36_2 {
	meta:
		name = "__ehhandler$??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@PBDPBU_Container_base12@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@PBDPBU_Container_base12@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_222_2 {
	meta:
		name = "__ehhandler$??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@PBGPBU_Container_base12@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@PBGPBU_Container_base12@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_39_2 {
	meta:
		name = "__ehhandler$??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@PB_WPBU_Container_base12@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@PB_WPBU_Container_base12@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_342_2 {
	meta:
		name = "__ehhandler$??0?$_SyncOriginator@I@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_SyncOriginator@I@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_347_2 {
	meta:
		name = "__ehhandler$??0?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_574_3 {
	meta:
		name = "__ehhandler$??0?$_Vector_alloc@$0A@U?$_Vec_base_types@PAXV?$allocator@PAX@std@@@std@@@std@@QAE@ABV?$allocator@PAX@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Vector_alloc@$0A@U?$_Vec_base_types@PAXV?$allocator@PAX@std@@@std@@@std@@QAE@ABV?$allocator@PAX@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_568_2 {
	meta:
		name = "__ehhandler$??0?$_Vector_alloc@$0A@U?$_Vec_base_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@@std@@QAE@ABV?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Vector_alloc@$0A@U?$_Vec_base_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@@std@@QAE@ABV?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_571_2 {
	meta:
		name = "__ehhandler$??0?$_Vector_alloc@$0A@U?$_Vec_base_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@@std@@QAE@ABV?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Vector_alloc@$0A@U?$_Vec_base_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@@std@@QAE@ABV?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_575_2 {
	meta:
		name = "__ehhandler$??0?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@PAX@std@@@std@@@std@@QAE@PAPAXPBU_Container_base12@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@PAX@std@@@std@@@std@@QAE@PAPAXPBU_Container_base12@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_578_2 {
	meta:
		name = "__ehhandler$??0?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@1@PBU_Container_base12@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@PAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@1@PBU_Container_base12@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_590_3 {
	meta:
		name = "__ehhandler$??0?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@1@PBU_Container_base12@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@PAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@1@PBU_Container_base12@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_53_3 {
	meta:
		name = "__ehhandler$??0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QAE@PAU_iobuf@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QAE@PAU_iobuf@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_48_2 {
	meta:
		name = "__ehhandler$??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAE@PAU_iobuf@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAE@PAU_iobuf@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_36_1 {
	meta:
		name = "__ehhandler$??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAE@PAU_iobuf@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAE@PAU_iobuf@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_375_1 {
	meta:
		name = "__ehhandler$??0?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@QAE@ABV?$function@$$A6AXABI@Z@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@QAE@ABV?$function@$$A6AXABI@Z@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_55_1 {
	meta:
		name = "__ehhandler$??0?$codecvt@DDH@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$codecvt@DDH@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_86_3 {
	meta:
		name = "__ehhandler$??0?$codecvt@GDH@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$codecvt@GDH@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_49_1 {
	meta:
		name = "__ehhandler$??0?$codecvt@_WDH@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$codecvt@_WDH@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_136_3 {
	meta:
		name = "__ehhandler$??0?$collate@D@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$collate@D@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_333_3 {
	meta:
		name = "__ehhandler$??0?$collate@G@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$collate@G@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_302_2 {
	meta:
		name = "__ehhandler$??0?$collate@_W@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$collate@_W@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_90_1 {
	meta:
		name = "__ehhandler$??0?$ctype@D@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ctype@D@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_339_3 {
	meta:
		name = "__ehhandler$??0?$ctype@G@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ctype@G@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_236_1 {
	meta:
		name = "__ehhandler$??0?$ctype@_W@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ctype@_W@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_583_1 {
	meta:
		name = "__ehhandler$??0?$function@$$A6A?AV?$task@_N@Concurrency@@XZ@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6A?AV?$task@_N@Concurrency@@XZ@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_640_3 {
	meta:
		name = "__ehhandler$??0?$function@$$A6A?AV?$task@_N@Concurrency@@_N@Z@std@@QAE@AAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6A?AV?$task@_N@Concurrency@@_N@Z@std@@QAE@AAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_380_3 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXABI@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXABI@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_634_2 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXE@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXE@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_592_1 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_595_1 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXV?$task@X@Concurrency@@@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXV?$task@X@Concurrency@@@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_598_1 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXV?$task@_N@Concurrency@@@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXV?$task@_N@Concurrency@@@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_646_2 {
	meta:
		name = "__ehhandler$??0?$function@$$A6AXXZ@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6AXXZ@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_386_3 {
	meta:
		name = "__ehhandler$??0?$function@$$A6A_NABI@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6A_NABI@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_389_3 {
	meta:
		name = "__ehhandler$??0?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_129_2 {
	meta:
		name = "__ehhandler$??0?$messages@D@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$messages@D@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_311_2 {
	meta:
		name = "__ehhandler$??0?$messages@G@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$messages@G@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_242_1 {
	meta:
		name = "__ehhandler$??0?$messages@_W@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$messages@_W@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_96_1 {
	meta:
		name = "__ehhandler$??0?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_245_1 {
	meta:
		name = "__ehhandler$??0?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_248_1 {
	meta:
		name = "__ehhandler$??0?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_99_1 {
	meta:
		name = "__ehhandler$??0?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_323_2 {
	meta:
		name = "__ehhandler$??0?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_326_2 {
	meta:
		name = "__ehhandler$??0?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_76_2 {
	meta:
		name = "__ehhandler$??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_333_2 {
	meta:
		name = "__ehhandler$??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_370_3 {
	meta:
		name = "__ehhandler$??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_88_3 {
	meta:
		name = "__ehhandler$??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_339_2 {
	meta:
		name = "__ehhandler$??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_342_2 {
	meta:
		name = "__ehhandler$??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_67_1 {
	meta:
		name = "__ehhandler$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_379_3 {
	meta:
		name = "__ehhandler$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_382_3 {
	meta:
		name = "__ehhandler$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_410_1 {
	meta:
		name = "__ehhandler$??0?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_414_3 {
	meta:
		name = "__ehhandler$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_418_3 {
	meta:
		name = "__ehhandler$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_422_2 {
	meta:
		name = "__ehhandler$??0?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_426_2 {
	meta:
		name = "__ehhandler$??0?$single_assignment@I@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$single_assignment@I@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_434_3 {
	meta:
		name = "__ehhandler$??0?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_440_3 {
	meta:
		name = "__ehhandler$??0?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_446_2 {
	meta:
		name = "__ehhandler$??0?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_450_2 {
	meta:
		name = "__ehhandler$??0?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_454_2 {
	meta:
		name = "__ehhandler$??0?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_459_2 {
	meta:
		name = "__ehhandler$??0?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_140_2 {
	meta:
		name = "__ehhandler$??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_385_3 {
	meta:
		name = "__ehhandler$??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_388_3 {
	meta:
		name = "__ehhandler$??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_144_2 {
	meta:
		name = "__ehhandler$??0?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_286_1 {
	meta:
		name = "__ehhandler$??0?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_290_1 {
	meta:
		name = "__ehhandler$??0?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_39_0 {
	meta:
		name = "__ehhandler$??0CacheLocalScheduleGroupSegment@details@Concurrency@@QAE@PAVScheduleGroupBase@12@PAVSchedulingRing@12@PAVlocation@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0CacheLocalScheduleGroupSegment@details@Concurrency@@QAE@PAVScheduleGroupBase@12@PAVSchedulingRing@12@PAVlocation@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_44_0 {
	meta:
		name = "__ehhandler$??0FairScheduleGroup@details@Concurrency@@QAE@PAVSchedulerBase@12@PAVlocation@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0FairScheduleGroup@details@Concurrency@@QAE@PAVSchedulerBase@12@PAVlocation@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_47_0 {
	meta:
		name = "__ehhandler$??0FairScheduleGroupSegment@details@Concurrency@@QAE@PAVScheduleGroupBase@12@PAVSchedulingRing@12@PAVlocation@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0FairScheduleGroupSegment@details@Concurrency@@QAE@PAVScheduleGroupBase@12@PAVSchedulingRing@12@PAVlocation@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1099_20_0 {
	meta:
		name = "__ehhandler$??0FreeThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0FreeThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_51_0 {
	meta:
		name = "__ehhandler$??0NumaInformation@SchedulerBase@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0NumaInformation@SchedulerBase@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_57_0 {
	meta:
		name = "__ehhandler$??0RealizedChore@details@Concurrency@@QAE@P6AXPAX@Z0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0RealizedChore@details@Concurrency@@QAE@P6AXPAX@Z0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_36_0 {
	meta:
		name = "__ehhandler$??0ScheduleGroupBase@details@Concurrency@@QAE@PAVSchedulerBase@12@PAVlocation@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ScheduleGroupBase@details@Concurrency@@QAE@PAVSchedulerBase@12@PAVlocation@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_680_23_0 {
	meta:
		name = "__ehhandler$??0SchedulingNode@details@Concurrency@@QAE@ABVQuickBitSet@12@KPAVSchedulingRing@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0SchedulingNode@details@Concurrency@@QAE@ABVQuickBitSet@12@KPAVSchedulingRing@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1099_26_0 {
	meta:
		name = "__ehhandler$??0ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_828_12_0 {
	meta:
		name = "__ehhandler$??0ThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1142_12_0 {
	meta:
		name = "__ehhandler$??0TimerObj@?6??wait@Concurrency@@YAXI@Z@QAE@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0TimerObj@?6??wait@Concurrency@@YAXI@Z@QAE@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1083_16_0 {
	meta:
		name = "__ehhandler$??0TransmogrifiedPrimary@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0TransmogrifiedPrimary@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1099_30_0 {
	meta:
		name = "__ehhandler$??0UMSFreeThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@PAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0UMSFreeThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@PAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_14_0 {
	meta:
		name = "__ehhandler$??0UMSThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0UMSThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_24_0 {
	meta:
		name = "__ehhandler$??0VirtualProcessor@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0VirtualProcessor@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1064_15_0 {
	meta:
		name = "__ehhandler$??0VirtualProcessorRoot@details@Concurrency@@QAE@PAVSchedulerProxy@12@PAUSchedulerNode@12@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0VirtualProcessorRoot@details@Concurrency@@QAE@PAVSchedulerProxy@12@PAUSchedulerNode@12@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_21_0 {
	meta:
		name = "__ehhandler$??0WorkQueue@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0WorkQueue@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_686_24_0 {
	meta:
		name = "__ehhandler$??0_AsyncTaskCollection@details@Concurrency@@AAE@PAV_CancellationTokenState@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_AsyncTaskCollection@details@Concurrency@@AAE@PAV_CancellationTokenState@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_469_3 {
	meta:
		name = "__ehhandler$??0_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@QAE@0I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@QAE@0I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_478_3 {
	meta:
		name = "__ehhandler$??0_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@QAE@0I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@QAE@0I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_697_3 {
	meta:
		name = "__ehhandler$??0_ContinuationTaskHandleBase@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_ContinuationTaskHandleBase@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_691_2 {
	meta:
		name = "__ehhandler$??0_ExceptionHolder@details@Concurrency@@QAE@ABVexception_ptr@std@@ABV_TaskCreationCallstack@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_ExceptionHolder@details@Concurrency@@QAE@ABVexception_ptr@std@@ABV_TaskCreationCallstack@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_27_1 {
	meta:
		name = "__ehhandler$??0_Locimp@locale@std@@AAE@ABV012@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Locimp@locale@std@@AAE@ABV012@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_30_1 {
	meta:
		name = "__ehhandler$??0_Locimp@locale@std@@AAE@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Locimp@locale@std@@AAE@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_657_1 {
	meta:
		name = "__ehhandler$??0_TaskCollectionImpl@details@Concurrency@@QAE@Uscheduler_ptr@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskCollectionImpl@details@Concurrency@@QAE@Uscheduler_ptr@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_663_1 {
	meta:
		name = "__ehhandler$??0_TaskProcHandle@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskProcHandle@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_128_1 {
	meta:
		name = "__ehhandler$??0facet@locale@std@@IAE@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0facet@locale@std@@IAE@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_7_53_2 {
	meta:
		name = "__ehhandler$??0sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_55_3 {
	meta:
		name = "__ehhandler$??0sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_54_2 {
	meta:
		name = "__ehhandler$??0sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_151_59_0 {
	meta:
		name = "__ehhandler$??1?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_817_3 {
	meta:
		name = "__ehhandler$??1?$_RunAnyParam@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_RunAnyParam@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_545_2 {
	meta:
		name = "__ehhandler$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_548_2 {
	meta:
		name = "__ehhandler$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_758_1 {
	meta:
		name = "__ehhandler$??1?$_Task_impl@E@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Task_impl@E@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_761_1 {
	meta:
		name = "__ehhandler$??1?$_Task_impl@_N@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Task_impl@_N@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_564_1 {
	meta:
		name = "__ehhandler$??1?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_567_3 {
	meta:
		name = "__ehhandler$??1?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_570_2 {
	meta:
		name = "__ehhandler$??1?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_597_2 {
	meta:
		name = "__ehhandler$??1?$ordered_message_processor@I@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$ordered_message_processor@I@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_604_3 {
	meta:
		name = "__ehhandler$??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_607_3 {
	meta:
		name = "__ehhandler$??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_626_2 {
	meta:
		name = "__ehhandler$??1?$single_assignment@I@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$single_assignment@I@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_634_2 {
	meta:
		name = "__ehhandler$??1?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_640_2 {
	meta:
		name = "__ehhandler$??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_646_3 {
	meta:
		name = "__ehhandler$??1?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_651_3 {
	meta:
		name = "__ehhandler$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_656_3 {
	meta:
		name = "__ehhandler$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_149_36_0 {
	meta:
		name = "__ehhandler$??1ContextBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ContextBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_611_33_0 {
	meta:
		name = "__ehhandler$??1ExternalContextBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ExternalContextBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_149_40_0 {
	meta:
		name = "__ehhandler$??1InternalContextBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1InternalContextBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_106_0 {
	meta:
		name = "__ehhandler$??1NumaInformation@SchedulerBase@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1NumaInformation@SchedulerBase@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_73_0 {
	meta:
		name = "__ehhandler$??1ScheduleGroupBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ScheduleGroupBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_80_0 {
	meta:
		name = "__ehhandler$??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_128_0 {
	meta:
		name = "__ehhandler$??1SchedulerBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulerBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_680_35_0 {
	meta:
		name = "__ehhandler$??1SchedulingNode@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulingNode@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_157_27_0 {
	meta:
		name = "__ehhandler$??1SchedulingRing@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulingRing@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1099_47_0 {
	meta:
		name = "__ehhandler$??1ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1083_26_0 {
	meta:
		name = "__ehhandler$??1TransmogrifiedPrimary@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1TransmogrifiedPrimary@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1099_52_0 {
	meta:
		name = "__ehhandler$??1UMSFreeThreadProxyFactory@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1UMSFreeThreadProxyFactory@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_40_0 {
	meta:
		name = "__ehhandler$??1VirtualProcessor@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1VirtualProcessor@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_475_21_0 {
	meta:
		name = "__ehhandler$??1WaiterThreadPool@platform@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1WaiterThreadPool@platform@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_51_0 {
	meta:
		name = "__ehhandler$??1WorkQueue@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1WorkQueue@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_686_54_0 {
	meta:
		name = "__ehhandler$??1_AsyncTaskCollection@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_AsyncTaskCollection@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_162_40_0 {
	meta:
		name = "__ehhandler$??1_Condition_variable@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Condition_variable@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_859_2 {
	meta:
		name = "__ehhandler$??1_ExceptionHolder@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_ExceptionHolder@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_806_1 {
	meta:
		name = "__ehhandler$??1_TaskCollectionImpl@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_TaskCollectionImpl@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_815_1 {
	meta:
		name = "__ehhandler$??1_Task_impl_base@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Task_impl_base@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_678_1 {
	meta:
		name = "__ehhandler$??1agent@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1agent@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_908_3 {
	meta:
		name = "__ehhandler$??1task_options@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1task_options@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_1007_2 {
	meta:
		name = "__ehhandler$??R?$_Func_class@XV?$task@X@Concurrency@@@std@@QBEXV?$task@X@Concurrency@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??R?$_Func_class@XV?$task@X@Concurrency@@@std@@QBEXV?$task@X@Concurrency@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_1010_2 {
	meta:
		name = "__ehhandler$??R?$_Func_class@XV?$task@_N@Concurrency@@@std@@QBEXV?$task@_N@Concurrency@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??R?$_Func_class@XV?$task@_N@Concurrency@@@std@@QBEXV?$task@_N@Concurrency@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_221_0 {
	meta:
		name = "__ehhandler$?CheckStaticConstruction@SchedulerBase@details@Concurrency@@CAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CheckStaticConstruction@SchedulerBase@details@Concurrency@@CAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_744_149_0 {
	meta:
		name = "__ehhandler$?GetCoreCount@ResourceManager@details@Concurrency@@SAIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetCoreCount@ResourceManager@details@Concurrency@@SAIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_744_167_0 {
	meta:
		name = "__ehhandler$?GetNodeCount@ResourceManager@details@Concurrency@@SAIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetNodeCount@ResourceManager@details@Concurrency@@SAIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_744_269_0 {
	meta:
		name = "__ehhandler$?Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_1109_3 {
	meta:
		name = "__ehhandler$?_CallInContext@_ContextCallback@details@Concurrency@@QBEXV?$function@$$A6AXXZ@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CallInContext@_ContextCallback@details@Concurrency@@QBEXV?$function@$$A6AXXZ@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_151_113_0 {
	meta:
		name = "__ehhandler$?_DeleteExceptionPtr@@YAXQAV__ExceptionPtr@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_DeleteExceptionPtr@@YAXQAV__ExceptionPtr@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_1252_1 {
	meta:
		name = "__ehhandler$?_Make@?$_Task_ptr@E@details@Concurrency@@SA?AV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@PAV_CancellationTokenState@23@Uscheduler_ptr@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Make@?$_Task_ptr@E@details@Concurrency@@SA?AV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@PAV_CancellationTokenState@23@Uscheduler_ptr@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_1255_1 {
	meta:
		name = "__ehhandler$?_Make@?$_Task_ptr@_N@details@Concurrency@@SA?AV?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@std@@PAV_CancellationTokenState@23@Uscheduler_ptr@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Make@?$_Task_ptr@_N@details@Concurrency@@SA?AV?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@std@@PAV_CancellationTokenState@23@Uscheduler_ptr@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_1285_1 {
	meta:
		name = "__ehhandler$?_Perform@?$_Continuation_func_transformer@V?$task@_N@Concurrency@@X@Concurrency@@SA?AV?$function@$$A6AEV?$task@_N@Concurrency@@@Z@std@@V?$function@$$A6AXV?$task@_N@Concurrency@@@Z@4@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Perform@?$_Continuation_func_transformer@V?$task@_N@Concurrency@@X@Concurrency@@SA?AV?$function@$$A6AEV?$task@_N@Concurrency@@@Z@std@@V?$function@$$A6AXV?$task@_N@Concurrency@@@Z@4@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_1288_1 {
	meta:
		name = "__ehhandler$?_Perform@?$_Continuation_func_transformer@_NV?$task@_N@Concurrency@@@Concurrency@@SA?AV?$function@$$A6A?AV?$task@_N@Concurrency@@_N@Z@std@@V34@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Perform@?$_Continuation_func_transformer@_NV?$task@_N@Concurrency@@@Concurrency@@SA?AV?$function@$$A6A?AV?$task@_N@Concurrency@@_N@Z@std@@V34@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_1419_2 {
	meta:
		name = "__ehhandler$?_RunTask@_TaskCollectionImpl@details@Concurrency@@SAXP6AXPAX@Z0W4_TaskInliningMode@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RunTask@_TaskCollectionImpl@details@Concurrency@@SAXP6AXPAX@Z0W4_TaskInliningMode@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_25_0 {
	meta:
		name = "??0Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@ABV0123@@Z"
		size = 38
		altNames = "??0?$_Network_link_iterator@V?$ISource@I@Concurrency@@@Concurrency@@QAE@ABV01@@Z ??0?$_Network_link_iterator@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@QAE@ABV01@@Z ??4Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEAAV0123@ABV0123@@Z ??4Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEAAV0123@ABV0123@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 8B 11 89 10 8B 45 FC 8B 4D 08 8B 51 04 89 50 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_26_0 {
	meta:
		name = "??0Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 33
		altNames = "??0?$_Ptr_base@U?$_Task_impl@E@details@Concurrency@@@std@@QAE@XZ ??0?$_Ptr_base@U?$_Task_impl@_N@details@Concurrency@@@std@@QAE@XZ ??0?$_Ptr_base@U_ExceptionHolder@details@Concurrency@@@std@@QAE@XZ ??0?$_Ptr_base@U_Task_impl_base@details@Concurrency@@@std@@QAE@XZ ??0?$_Ptr_base@Uscheduler_interface@Concurrency@@@std@@QAE@XZ ??0?$_Ptr_base@V__ExceptionPtr@@@std@@QAE@XZ ??0QuickBitSet@details@Concurrency@@QAE@XZ ??0Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE@XZ ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ ??0_Container_proxy@std@@QAE@XZ ??0_Iterator_base12@std@@QAE@XZ ??0_ReaderWriterLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 00 00 00 00 8B 4D FC C7 41 04 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_28_0 {
	meta:
		name = "??0_Cancellation_beacon@details@Concurrency@@QAE@XZ"
		size = 37
		refs = "000a ?CurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0015 ?PushCancellationBeacon@ContextBase@details@Concurrency@@QAEPAU_Beacon_reference@23@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC E8 ?? ?? ?? ?? 89 45 F8 8B 4D F8 E8 ?? ?? ?? ?? 8B 4D FC 89 01 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_29_0 {
	meta:
		name = "??0_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 34
		refs = "0015 ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_149_14_0 {
	meta:
		name = "??0ScopedCriticalRegion@ContextBase@details@Concurrency@@QAE@PAV123@@Z"
		size = 34
		refs = "0015 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1006_14_0 {
	meta:
		name = "??0_Scoped_lock@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@AAV123@@Z"
		size = 34
		refs = "0015 ?AcquireWrite@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_136_11_0 {
	meta:
		name = "??0_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 34
		refs = "0015 ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1099_36_0 {
	meta:
		name = "??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 34
		refs = "0015 ?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_542_12_0 {
	meta:
		name = "??0_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 34
		refs = "0015 ?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1372_16_0 {
	meta:
		name = "??0_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 34
		refs = "0015 ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1338_18_0 {
	meta:
		name = "??0_Scoped_lock@_ReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 34
		refs = "0015 ?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_686_29_0 {
	meta:
		name = "??0_Scoped_lock_read@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@AAV123@@Z"
		size = 34
		refs = "0015 ?AcquireRead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_429_43_0 {
	meta:
		name = "??0scoped_lock_read@reader_writer_lock@Concurrency@@QAE@AAV12@@Z"
		size = 34
		refs = "0015 ?lock_read@reader_writer_lock@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_32_0 {
	meta:
		name = "??0cancellation_token_source@Concurrency@@QAE@ABV01@@Z"
		size = 30
		refs = "0011 ?_Assign@cancellation_token_source@Concurrency@@AAEXPAV_CancellationTokenState@details@2@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 8B 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_680_1 {
	meta:
		name = "??0cancellation_token@Concurrency@@QAE@ABV01@@Z"
		size = 30
		refs = "0011 ?_Assign@cancellation_token@Concurrency@@AAEXPAV_CancellationTokenState@details@2@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 8B 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_33_0 {
	meta:
		name = "??0location@Concurrency@@QAE@ABV01@@Z"
		size = 28
		refs = "000f ?_Assign@location@Concurrency@@QAEXABV12@@Z"
		altNames = "??4location@Concurrency@@QAEAAV01@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_71_95_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAE@ABU01@@Z"
		size = 28
		refs = "000f ??0_Iterator_base12@std@@QAE@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_13_234_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAE@ABU01@@Z"
		size = 28
		refs = "000f ??0_Iterator_base12@std@@QAE@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_113_538_2 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@PAXHPBQAXABQAXU_Iterator_base12@2@@std@@QAE@ABU01@@Z"
		size = 28
		refs = "000f ??0_Iterator_base12@std@@QAE@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_13_236_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAE@ABU01@@Z"
		size = 28
		refs = "000f ??0_Iterator_base12@std@@QAE@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_76_95_2 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@ABV01@@Z"
		size = 28
		refs = "000f ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_229_2 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@ABV01@@Z"
		size = 28
		refs = "000f ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_4_40_2 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@ABV01@@Z"
		size = 28
		refs = "000f ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_117_39_2 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAE@ABV?$allocator@D@1@@Z"
		size = 28
		refs = "000f ??0?$allocator@D@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_13_271_3 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAE@ABV?$allocator@G@1@@Z"
		size = 28
		refs = "000f ??0?$allocator@G@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_113_588_2 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@PAX@std@@@std@@QAE@ABV?$allocator@PAX@1@@Z"
		size = 28
		refs = "000f ??0?$allocator@PAX@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_239_2 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAE@ABV?$allocator@_W@1@@Z"
		size = 28
		refs = "000f ??0?$allocator@_W@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_618_1 {
	meta:
		name = "??0?$task@E@Concurrency@@QAE@ABV01@@Z"
		size = 28
		refs = "000f ??0?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_621_1 {
	meta:
		name = "??0?$task@X@Concurrency@@QAE@ABV01@@Z"
		size = 28
		refs = "000f ??0?$task@E@Concurrency@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_624_1 {
	meta:
		name = "??0?$task@_N@Concurrency@@QAE@ABV01@@Z"
		size = 28
		refs = "000f ??0?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_664_1 {
	meta:
		name = "??0_TaskProcThunk@details@Concurrency@@QAE@ABV?$function@$$A6AXXZ@std@@@Z"
		size = 28
		refs = "000f ??0?$function@$$A6AXXZ@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_754_3 {
	meta:
		name = "??0task_continuation_context@Concurrency@@QAE@ABV01@@Z"
		size = 28
		refs = "000f ??0_ContextCallback@details@Concurrency@@QAE@ABV012@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_71_228_3 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAEAAU01@ABU01@@Z"
		size = 28
		refs = "000f ??4_Iterator_base12@std@@QAEAAU01@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_13_496_3 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAEAAU01@ABU01@@Z"
		size = 28
		refs = "000f ??4_Iterator_base12@std@@QAEAAU01@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_463_2 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAEAAU01@ABU01@@Z"
		size = 28
		refs = "000f ??4_Iterator_base12@std@@QAEAAU01@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_764_145_0 {
	meta:
		name = "??4QuickBitSet@details@Concurrency@@QAEAAV012@ABV012@@Z"
		size = 28
		refs = "000f ?CopyFrom@QuickBitSet@details@Concurrency@@IAEXABV123@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1193_25_0 {
	meta:
		name = "??4SchedulerPolicy@Concurrency@@QAEAAV01@ABV01@@Z"
		size = 28
		refs = "000f ?_Assign@SchedulerPolicy@Concurrency@@AAEXABV12@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_927_3 {
	meta:
		name = "??4task_continuation_context@Concurrency@@QAEAAV01@ABV01@@Z"
		size = 28
		refs = "000f ??4_ContextCallback@details@Concurrency@@QAEAAV012@ABV012@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_71_263_3 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAEAAV01@H@Z"
		size = 28
		refs = "000f ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAEAAV01@H@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_527_2 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAEAAV01@H@Z"
		size = 28
		refs = "000f ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAEAAV01@H@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_94_3 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAEAAV01@H@Z"
		size = 28
		refs = "000f ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAEAAV01@H@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_34_0 {
	meta:
		name = "??0location@Concurrency@@QAE@XZ"
		size = 66
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 81 E1 00 00 00 F0 8B 55 FC 89 0A 8B 45 FC 8B 08 81 E1 FF FF FF 0F 8B 55 FC 89 0A 8B 45 FC C7 40 08 00 00 00 00 8B 4D FC C7 41 0C 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_35_0 {
	meta:
		name = "??1?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE@XZ"
		size = 42
		refs = "000d ?Wipe@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEXXZ 001f ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B 48 08 89 4D F8 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_680_27_0 {
	meta:
		name = "??1?$Hash@II@details@Concurrency@@QAE@XZ"
		size = 42
		refs = "000d ?Wipe@?$Hash@II@details@Concurrency@@QAEXXZ 001f ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B 48 08 89 4D F8 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_36_0 {
	meta:
		name = "??1?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@XZ"
		size = 55
		refs = "0017 ??_V@YAXPAX@Z"
		altNames = "??1?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 8B 48 0C 89 4D F8 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B 48 10 89 4D F4 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_37_0 {
	meta:
		name = "??1?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@XZ"
		size = 55
		refs = "0017 ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 8B 48 1C 89 4D F8 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B 48 20 89 4D F4 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_38_0 {
	meta:
		name = "??1CancellationBeaconNode@CancellationBeaconStack@ContextBase@details@Concurrency@@QAE@XZ"
		size = 33
		refs = "0016 ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 08 89 4D F8 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_1193_19_0 {
	meta:
		name = "??1SchedulerPolicy@Concurrency@@QAE@XZ"
		size = 33
		refs = "0016 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 08 89 4D F8 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_39_0 {
	meta:
		name = "??1CancellationBeaconStack@ContextBase@details@Concurrency@@QAE@XZ"
		size = 126
		refs = "004d ??_GCancellationBeaconNode@CancellationBeaconStack@ContextBase@details@Concurrency@@QAEPAXI@Z 0073 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 1C 89 4D F8 8B 45 F8 83 78 04 00 7E 53 B9 04 00 00 00 6B D1 00 8B 45 F8 8B 48 08 8B 14 0A 89 55 FC 83 7D FC 00 74 39 8B 45 FC 8B 48 04 89 4D E8 8B 55 FC 89 55 F0 8B 45 F0 89 45 F4 83 7D F4 00 74 0F 6A 01 8B 4D F4 E8 ?? ?? ?? ?? 89 45 EC EB 07 C7 45 EC 00 00 00 00 8B 4D E8 89 4D FC EB C1 8B 55 F8 8B 42 08 89 45 E4 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_40_0 {
	meta:
		name = "??1Context@Concurrency@@MAE@XZ"
		size = 20
		refs = "000c ??_7Context@Concurrency@@6B@"
		altNames = "?Reset@SafePointMarker@details@Concurrency@@QAEXXZ ?_Clrcont@_Iterator_base12@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_503_1 {
	meta:
		name = "??1?$ISource@I@Concurrency@@UAE@XZ"
		size = 20
		refs = "000c ??_7?$ISource@I@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_504_3 {
	meta:
		name = "??1?$ISource@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 20
		refs = "000c ??_7?$ISource@W4agent_status@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_505_3 {
	meta:
		name = "??1?$ITarget@I@Concurrency@@UAE@XZ"
		size = 20
		refs = "000c ??_7?$ITarget@I@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_506_1 {
	meta:
		name = "??1?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 20
		refs = "000c ??_7?$ITarget@W4agent_status@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_721_1 {
	meta:
		name = "??1?$_Func_base@EV?$task@_N@Concurrency@@@std@@UAE@XZ"
		size = 20
		refs = "000c ??_7?$_Func_base@EV?$task@_N@Concurrency@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_722_1 {
	meta:
		name = "??1?$_Func_base@V?$task@_N@Concurrency@@_N@std@@UAE@XZ"
		size = 20
		refs = "000c ??_7?$_Func_base@V?$task@_N@Concurrency@@_N@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_723_1 {
	meta:
		name = "??1?$_Func_base@X$$$V@std@@UAE@XZ"
		size = 20
		refs = "000c ??_7?$_Func_base@X$$$V@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_517_1 {
	meta:
		name = "??1?$_Func_base@XABI@std@@UAE@XZ"
		size = 20
		refs = "000c ??_7?$_Func_base@XABI@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_518_1 {
	meta:
		name = "??1?$_Func_base@XPAV?$message@I@Concurrency@@@std@@UAE@XZ"
		size = 20
		refs = "000c ??_7?$_Func_base@XPAV?$message@I@Concurrency@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_519_1 {
	meta:
		name = "??1?$_Func_base@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@UAE@XZ"
		size = 20
		refs = "000c ??_7?$_Func_base@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_774_2 {
	meta:
		name = "??1?$_Func_base@XV?$task@_N@Concurrency@@@std@@UAE@XZ"
		size = 20
		refs = "000c ??_7?$_Func_base@XV?$task@_N@Concurrency@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_520_2 {
	meta:
		name = "??1?$_Func_base@_NABW4agent_status@Concurrency@@@std@@UAE@XZ"
		size = 20
		refs = "000c ??_7?$_Func_base@_NABW4agent_status@Concurrency@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_577_1 {
	meta:
		name = "??1?$message@I@Concurrency@@UAE@XZ"
		size = 20
		refs = "000c ??_7?$message@I@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_578_1 {
	meta:
		name = "??1?$message@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 20
		refs = "000c ??_7?$message@W4agent_status@Concurrency@@@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1099_44_0 {
	meta:
		name = "??1IThreadProxyFactory@details@Concurrency@@UAE@XZ"
		size = 20
		refs = "000c ??_7IThreadProxyFactory@details@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_173_70_0 {
	meta:
		name = "??1ScheduleGroup@Concurrency@@MAE@XZ"
		size = 20
		refs = "000c ??_7ScheduleGroup@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_764_114_0 {
	meta:
		name = "??1Scheduler@Concurrency@@MAE@XZ"
		size = 20
		refs = "000c ??_7Scheduler@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_362_19_0 {
	meta:
		name = "??1UMSSchedulingContext@details@Concurrency@@QAE@XZ"
		size = 20
		refs = "000c ??_7UMSSchedulingContext@details@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_764_131_0 {
	meta:
		name = "??1_Chore@details@Concurrency@@MAE@XZ"
		size = 20
		refs = "000c ??_7_Chore@details@Concurrency@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_18_131_2 {
	meta:
		name = "??1_Facet_base@std@@UAE@XZ"
		size = 20
		refs = "000c ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_151_61_0 {
	meta:
		name = "??1_Ref_count_base@std@@UAE@XZ"
		size = 20
		refs = "000c ??_7_Ref_count_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_84_137_3 {
	meta:
		name = "??1error_category@std@@UAE@XZ"
		size = 20
		refs = "000c ??_7error_category@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_41_0 {
	meta:
		name = "??1ContextBase@details@Concurrency@@UAE@XZ"
		size = 107
		refs = "0006 __ehhandler$??1ContextBase@details@Concurrency@@UAE@XZ 0013 ___security_cookie 0037 ??1CancellationBeaconStack@ContextBase@details@Concurrency@@QAE@XZ 0049 ??1?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE@XZ 0058 ??1Context@Concurrency@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 C7 45 FC 01 00 00 00 8B 4D F0 81 C1 8C 00 00 00 E8 ?? ?? ?? ?? C6 45 FC 00 8B 4D F0 81 C1 80 00 00 00 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_45_0 {
	meta:
		name = "??1GlobalCore@details@Concurrency@@QAE@XZ"
		size = 34
		refs = "0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 20 89 4D F8 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_46_0 {
	meta:
		name = "??1QuickBitSet@details@Concurrency@@QAE@XZ"
		size = 34
		refs = "0017 ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 04 89 4D F8 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_744_42_0 {
	meta:
		name = "??1AffinityRestriction@ResourceManager@details@Concurrency@@QAE@XZ"
		size = 34
		refs = "0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 04 89 4D F8 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_47_0 {
	meta:
		name = "??1Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 45
		refs = "0017 ??_V@YAXPAX@Z 0025 ??1QuickBitSet@details@Concurrency@@QAE@XZ"
		altNames = "??1Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 0C 89 4D F8 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_48_0 {
	meta:
		name = "??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
		size = 56
		refs = "002b _free"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F8 8B 45 F8 8B 08 89 4D FC 83 7D FC 00 74 1D 8B 55 FC 89 55 F4 8B 45 FC 8B 48 04 89 4D FC 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 EB DD 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_49_0 {
	meta:
		name = "??1WorkQueue@details@Concurrency@@QAE@XZ"
		size = 86
		refs = "0006 __ehhandler$??1WorkQueue@details@Concurrency@@QAE@XZ 0013 ___security_cookie 0034 ??1?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@XZ 0043 ??1?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 C7 45 FC 00 00 00 00 8B 4D F0 83 C1 4C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_52_0 {
	meta:
		name = "??1_Cancellation_beacon@details@Concurrency@@QAE@XZ"
		size = 29
		refs = "000a ?CurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0015 ?PopCancellationBeacon@ContextBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 E8 ?? ?? ?? ?? 89 45 FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_53_0 {
	meta:
		name = "??1_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_149_41_0 {
	meta:
		name = "??1ScopedCriticalRegion@ContextBase@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1006_21_0 {
	meta:
		name = "??1_Scoped_lock@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?ReleaseWrite@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_323_25_0 {
	meta:
		name = "??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_Release@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1099_53_0 {
	meta:
		name = "??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_Release@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_542_16_0 {
	meta:
		name = "??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_Release@_NonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_429_48_0 {
	meta:
		name = "??1_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_Release@_NonReentrantPPLLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_764_134_0 {
	meta:
		name = "??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1338_30_0 {
	meta:
		name = "??1_Scoped_lock@_ReentrantBlockingLock@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_Release@_ReentrantBlockingLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_429_49_0 {
	meta:
		name = "??1_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?_Release@_ReentrantPPLLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_686_59_0 {
	meta:
		name = "??1_Scoped_lock_read@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?ReleaseRead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_429_54_0 {
	meta:
		name = "??1scoped_lock@critical_section@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?unlock@critical_section@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_429_55_0 {
	meta:
		name = "??1scoped_lock@reader_writer_lock@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?unlock@reader_writer_lock@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_429_56_0 {
	meta:
		name = "??1scoped_lock_read@reader_writer_lock@Concurrency@@QAE@XZ"
		size = 21
		refs = "000d ?unlock@reader_writer_lock@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1094_65_0 {
	meta:
		name = "?cancel@cancellation_token_source@Concurrency@@QBEXXZ"
		size = 21
		refs = "000d ?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_56_0 {
	meta:
		name = "??2@YAPAXIV_ConcRTNewMoniker@@PBDH@Z"
		size = 27
		refs = "0012 ??2@YAPAXIHPBDH@Z"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 6A 02 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_680_55_0 {
	meta:
		name = "??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z"
		size = 27
		refs = "0012 ??_U@YAPAXIHPBDH@Z"
	strings:
		$1 = { 55 8B EC 8B 45 14 50 8B 4D 10 51 6A 02 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_22_57_0 {
	meta:
		name = "??3@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
		size = 17
		refs = "0008 ??3@YAXPAX@Z"
		altNames = "??3@YAXPAXABUnothrow_t@std@@@Z ??3@YAXPAXHPBDH@Z ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_113_901_2 {
	meta:
		name = "??2_AllocBase@details@Concurrency@@SAPAXI@Z"
		size = 17
		refs = "0008 ?Alloc@Concurrency@@YAPAXI@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_27_912_3 {
	meta:
		name = "??3_AllocBase@details@Concurrency@@SAXPAX@Z"
		size = 17
		refs = "0008 ?Free@Concurrency@@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_18_150_2 {
	meta:
		name = "??3facet@locale@std@@SAXPAX@Z"
		size = 17
		refs = "0008 ??$_DebugHeapDelete@Vfacet@locale@std@@@std@@YAXPAVfacet@locale@0@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_81_151_2 {
	meta:
		name = "??3facet@locale@std@@SAXPAXABU_DebugHeapTag_t@2@PADH@Z"
		size = 17
		refs = "0008 ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_22_0_1 {
	meta:
		name = "??_U@YAPAXI@Z"
		size = 17
		refs = "0008 ??2@YAPAXI@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_644_0_6 {
	meta:
		name = "??_V@YAXPAXABUnothrow_t@std@@@Z"
		size = 17
		refs = "0008 ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_221_1_0 {
	meta:
		name = "??_V@YAXPAXHPBDH@Z"
		size = 17
		refs = "0008 ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_744_82_0 {
	meta:
		name = "??_V@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
		size = 17
		refs = "0008 ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_922_36_0 {
	meta:
		name = "?DecodePointer@Security@details@Concurrency@@SAPAXPAX@Z"
		size = 17
		refs = "0008 ?EncodePointer@Security@details@Concurrency@@SAPAXPAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_1099_102_0 {
	meta:
		name = "?FromUMSContext@UMSFreeThreadProxy@details@Concurrency@@SAPAV123@PAX@Z"
		size = 17
		refs = "0008 ?FromUMSContext@UMSThreadProxy@details@Concurrency@@SAPAV123@PAX@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_764_466_0 {
	meta:
		name = "?SetDefaultSchedulerPolicy@Scheduler@Concurrency@@SAXABVSchedulerPolicy@2@@Z"
		size = 17
		refs = "0008 ?SetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXABVSchedulerPolicy@3@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_744_284_0 {
	meta:
		name = "?set_task_execution_resources@Concurrency@@YAXK@Z"
		size = 17
		refs = "0008 ?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAXK@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_97_0_2 {
	meta:
		name = "__LDtest"
		size = 17
		refs = "0008 __Dtest"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_409_6_0 {
	meta:
		name = "___free_locale"
		size = 17
		refs = "0008 __free_locale"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_806_27_0 {
	meta:
		name = "__aligned_free"
		size = 17
		refs = "0008 __aligned_free_dbg"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_324_0_0 {
	meta:
		name = "__ftime32"
		size = 17
		refs = "0008 __ftime32_s"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_1044_0_0 {
	meta:
		name = "__ftime64"
		size = 17
		refs = "0008 __ftime64_s"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_609_6_0 {
	meta:
		name = "__inc"
		size = 17
		refs = "0008 __fgetwc_nolock"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_1037_6_0 {
	meta:
		name = "__ldtest"
		size = 17
		refs = "0008 __dtest"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_419_0_0 {
	meta:
		name = "__unlink"
		size = 17
		refs = "0008 _remove"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_736_0_0 {
	meta:
		name = "__wtoi"
		size = 17
		refs = "0008 __wtol"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_448_1_0 {
	meta:
		name = "__wunlink"
		size = 17
		refs = "0008 __wremove"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_914_5_0 {
	meta:
		name = "_atoi"
		size = 17
		refs = "0008 _atol"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_690_0_0 {
	meta:
		name = "_clearerr"
		size = 17
		refs = "0008 _clearerr_s"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_167_2_0 {
	meta:
		name = "_getwc"
		size = 17
		refs = "0008 _fgetwc"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_802_1_0 {
	meta:
		name = "_putchar"
		size = 17
		refs = "0008 __fputchar"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_61_11_1 {
	meta:
		name = "_sys_tss_get"
		size = 17
		refs = "0008 ___crtFlsGetValue"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_22_59_0 {
	meta:
		name = "??8location@Concurrency@@QBE_NABV01@@Z"
		size = 73
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 08 81 E1 FF FF FF 0F 8B 55 08 8B 02 25 FF FF FF 0F 3B C8 75 17 8B 4D FC 8B 55 08 8B 41 08 3B 42 08 75 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8A 45 F8 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_60_0 {
	meta:
		name = "??9location@Concurrency@@QBE_NABV01@@Z"
		size = 53
		refs = "0011 ??8location@Concurrency@@QBE_NABV01@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 08 50 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_71_240_3 {
	meta:
		name = "??9?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBE_NABV01@@Z"
		size = 53
		refs = "0011 ??8?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBE_NABV01@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 08 50 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_78_385_1 {
	meta:
		name = "??9?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBE_NABV01@@Z"
		size = 53
		refs = "0011 ??8?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBE_NABV01@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 08 50 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_481_2 {
	meta:
		name = "??9?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBE_NABV01@@Z"
		size = 53
		refs = "0011 ??8?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBE_NABV01@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 08 50 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_113_922_2 {
	meta:
		name = "??9?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QBE_NABV01@@Z"
		size = 53
		refs = "0011 ??8?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QBE_NABV01@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 08 50 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_854_1 {
	meta:
		name = "??9?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QBE_NABV01@@Z"
		size = 53
		refs = "0011 ??8?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QBE_NABV01@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 08 50 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_499_42_0 {
	meta:
		name = "??9HardwareAffinity@details@Concurrency@@QAE_NABU012@@Z"
		size = 53
		refs = "0011 ??8HardwareAffinity@details@Concurrency@@QAE_NABU012@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 08 50 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_61_0 {
	meta:
		name = "??ACancellationBeaconStack@ContextBase@details@Concurrency@@QAEPAUCancellationBeacon@123@J@Z"
		size = 132
	strings:
		$1 = { 55 8B EC 83 EC 10 89 4D F4 C7 45 F8 00 00 00 00 8B 45 08 83 E0 F0 C1 F8 04 89 45 FC 83 7D FC 04 7D 11 8B 4D F4 8B 51 08 8B 45 FC 8B 0C 82 89 4D F8 EB 3D BA 04 00 00 00 6B C2 03 8B 4D F4 8B 51 08 8B 04 10 89 45 F8 8B 4D FC 83 E9 03 89 4D FC 8B 55 FC 89 55 F0 8B 45 FC 83 E8 01 89 45 FC 83 7D F0 00 74 0B 8B 4D F8 8B 51 04 89 55 F8 EB E0 8B 45 08 83 E0 0F 8B 4D F8 8B 11 8D 04 C2 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_71_0 {
	meta:
		name = "??_EGlobalCore@details@Concurrency@@QAEPAXI@Z"
		size = 106
		refs = "0010 ??1GlobalCore@details@Concurrency@@QAE@XZ 0022 ??_M@YGXPAXIHP6EX0@Z@Z 0036 ??_V@YAXPAX@Z 005a ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 83 E0 02 74 36 68 ?? ?? ?? ?? 8B 4D FC 8B 51 FC 52 6A 24 8B 45 FC 50 E8 ?? ?? ?? ?? 8B 4D 08 83 E1 01 74 0F 8B 55 FC 83 EA 04 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 83 E8 04 EB 1F 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_72_0 {
	meta:
		name = "??_GCancellationBeaconNode@CancellationBeaconStack@ContextBase@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1CancellationBeaconNode@CancellationBeaconStack@ContextBase@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_751_2 {
	meta:
		name = "??_G?$ISource@I@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ISource@I@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_752_1 {
	meta:
		name = "??_G?$ISource@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ISource@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_753_1 {
	meta:
		name = "??_G?$ITarget@I@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ITarget@I@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_30_754_3 {
	meta:
		name = "??_G?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1099_67_0 {
	meta:
		name = "??_G?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1099_68_0 {
	meta:
		name = "??_G?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_30_755_3 {
	meta:
		name = "??_G?$_AnonymousOriginator@I@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_AnonymousOriginator@I@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_756_2 {
	meta:
		name = "??_G?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_1028_3 {
	meta:
		name = "??_G?$_Func_base@EV?$task@_N@Concurrency@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Func_base@EV?$task@_N@Concurrency@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_949_1 {
	meta:
		name = "??_G?$_Func_base@V?$task@_N@Concurrency@@_N@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Func_base@V?$task@_N@Concurrency@@_N@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_950_1 {
	meta:
		name = "??_G?$_Func_base@X$$$V@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Func_base@X$$$V@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_757_2 {
	meta:
		name = "??_G?$_Func_base@XABI@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Func_base@XABI@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_758_1 {
	meta:
		name = "??_G?$_Func_base@XPAV?$message@I@Concurrency@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Func_base@XPAV?$message@I@Concurrency@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_759_2 {
	meta:
		name = "??_G?$_Func_base@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Func_base@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_1031_3 {
	meta:
		name = "??_G?$_Func_base@XV?$task@_N@Concurrency@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Func_base@XV?$task@_N@Concurrency@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_760_1 {
	meta:
		name = "??_G?$_Func_base@_NABW4agent_status@Concurrency@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Func_base@_NABW4agent_status@Concurrency@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_30_761_3 {
	meta:
		name = "??_G?$_Func_impl@U?$_Callable_obj@P6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@@std@@@2@_NABW4agent_status@Concurrency@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Func_impl@U?$_Callable_obj@P6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@@std@@@2@_NABW4agent_status@Concurrency@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_768_2 {
	meta:
		name = "??_G?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_162_61_0 {
	meta:
		name = "??_G?$_MallocaArrayHolder@PAVContext@Concurrency@@@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_MallocaArrayHolder@PAVContext@Concurrency@@@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_686_82_0 {
	meta:
		name = "??_G?$_MallocaArrayHolder@PAVevent@Concurrency@@@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_MallocaArrayHolder@PAVevent@Concurrency@@@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_71_266_3 {
	meta:
		name = "??_G?$_Mpunct@D@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Mpunct@D@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_536_2 {
	meta:
		name = "??_G?$_Mpunct@G@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Mpunct@G@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_537_2 {
	meta:
		name = "??_G?$_Mpunct@_W@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Mpunct@_W@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_30_769_3 {
	meta:
		name = "??_G?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_151_73_0 {
	meta:
		name = "??_G?$_Ref_count@V__ExceptionPtr@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Ref_count@V__ExceptionPtr@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_151_74_0 {
	meta:
		name = "??_G?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_1041_3 {
	meta:
		name = "??_G?$_Ref_count_obj@U?$_Task_impl@E@details@Concurrency@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Ref_count_obj@U?$_Task_impl@E@details@Concurrency@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_1042_3 {
	meta:
		name = "??_G?$_Ref_count_obj@U?$_Task_impl@_N@details@Concurrency@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Ref_count_obj@U?$_Task_impl@_N@details@Concurrency@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_1043_3 {
	meta:
		name = "??_G?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_1044_3 {
	meta:
		name = "??_G?$_RunAllParam@E@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_RunAllParam@E@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_1045_3 {
	meta:
		name = "??_G?$_RunAnyParam@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_RunAnyParam@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_770_2 {
	meta:
		name = "??_G?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_771_2 {
	meta:
		name = "??_G?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_772_2 {
	meta:
		name = "??_G?$_SyncOriginator@I@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_SyncOriginator@I@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_773_1 {
	meta:
		name = "??_G?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_113_1035_2 {
	meta:
		name = "??_G?$_Task_impl@E@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Task_impl@E@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_1047_3 {
	meta:
		name = "??_G?$_Task_impl@_N@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$_Task_impl@_N@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_48_161_2 {
	meta:
		name = "??_G?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_177_3 {
	meta:
		name = "??_G?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_23_177_3 {
	meta:
		name = "??_G?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_167_3 {
	meta:
		name = "??_G?$basic_ios@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_161_2 {
	meta:
		name = "??_G?$basic_ios@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_51_161_2 {
	meta:
		name = "??_G?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_77_134_1 {
	meta:
		name = "??_G?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_180_3 {
	meta:
		name = "??_G?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_11_133_1 {
	meta:
		name = "??_G?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_774_2 {
	meta:
		name = "??_G?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$call@IV?$function@$$A6AXABI@Z@std@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_84_160_3 {
	meta:
		name = "??_G?$codecvt@DDH@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$codecvt@DDH@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_72_181_3 {
	meta:
		name = "??_G?$codecvt@GDH@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$codecvt@GDH@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_25_164_2 {
	meta:
		name = "??_G?$codecvt@_WDH@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$codecvt@_WDH@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_71_267_3 {
	meta:
		name = "??_G?$collate@D@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$collate@D@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_540_2 {
	meta:
		name = "??_G?$collate@G@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$collate@G@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_541_2 {
	meta:
		name = "??_G?$collate@_W@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$collate@_W@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_30_775_3 {
	meta:
		name = "??_G?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_30_776_3 {
	meta:
		name = "??_G?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_19_152_2 {
	meta:
		name = "??_G?$ctype@D@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ctype@D@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_81_165_2 {
	meta:
		name = "??_G?$ctype@G@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ctype@G@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_55_165_2 {
	meta:
		name = "??_G?$ctype@_W@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ctype@_W@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_30_777_3 {
	meta:
		name = "??_G?$function@$$A6A_NABI@Z@std@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1?$function@$$A6A_NABI@Z@std@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_30_778_3 {
	meta:
		name = "??_G?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_779_2 {
	meta:
		name = "??_G?$message@I@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$message@I@Concurrency@@UAE@XZ 001c ??3_AllocBase@details@Concurrency@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_780_1 {
	meta:
		name = "??_G?$message@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$message@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001c ??3_AllocBase@details@Concurrency@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_71_269_3 {
	meta:
		name = "??_G?$messages@D@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$messages@D@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_78_437_1 {
	meta:
		name = "??_G?$messages@G@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$messages@G@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_78_438_1 {
	meta:
		name = "??_G?$messages@_W@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$messages@_W@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_110_199_1 {
	meta:
		name = "??_G?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_13_582_3 {
	meta:
		name = "??_G?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_13_583_3 {
	meta:
		name = "??_G?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_76_256_2 {
	meta:
		name = "??_G?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_78_441_1 {
	meta:
		name = "??_G?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_78_442_1 {
	meta:
		name = "??_G?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_110_201_1 {
	meta:
		name = "??_G?$moneypunct@D$00@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$moneypunct@D$00@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_76_258_2 {
	meta:
		name = "??_G?$moneypunct@D$0A@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$moneypunct@D$0A@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_13_586_3 {
	meta:
		name = "??_G?$moneypunct@G$00@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$moneypunct@G$00@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_13_587_3 {
	meta:
		name = "??_G?$moneypunct@G$0A@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$moneypunct@G$0A@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_552_2 {
	meta:
		name = "??_G?$moneypunct@_W$00@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$moneypunct@_W$00@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_78_446_1 {
	meta:
		name = "??_G?$moneypunct@_W$0A@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$moneypunct@_W$0A@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_30_781_3 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_30_782_3 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_783_1 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_784_1 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_19_153_2 {
	meta:
		name = "??_G?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_554_2 {
	meta:
		name = "??_G?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_555_2 {
	meta:
		name = "??_G?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_81_134_1 {
	meta:
		name = "??_G?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_78_449_1 {
	meta:
		name = "??_G?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_557_2 {
	meta:
		name = "??_G?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_84_164_3 {
	meta:
		name = "??_G?$numpunct@D@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$numpunct@D@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_558_2 {
	meta:
		name = "??_G?$numpunct@G@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$numpunct@G@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_559_2 {
	meta:
		name = "??_G?$numpunct@_W@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$numpunct@_W@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_785_2 {
	meta:
		name = "??_G?$ordered_message_processor@I@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ordered_message_processor@I@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_30_786_3 {
	meta:
		name = "??_G?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_787_2 {
	meta:
		name = "??_G?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_788_1 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_789_1 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_30_790_3 {
	meta:
		name = "??_G?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_968_1 {
	meta:
		name = "??_G?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_969_1 {
	meta:
		name = "??_G?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_151_75_0 {
	meta:
		name = "??_G?$shared_ptr@V__ExceptionPtr@@@std@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1?$shared_ptr@V__ExceptionPtr@@@std@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_30_791_3 {
	meta:
		name = "??_G?$single_assignment@I@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$single_assignment@I@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_792_2 {
	meta:
		name = "??_G?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_793_1 {
	meta:
		name = "??_G?$single_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$single_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_794_1 {
	meta:
		name = "??_G?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_795_2 {
	meta:
		name = "??_G?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_796_2 {
	meta:
		name = "??_G?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_30_797_3 {
	meta:
		name = "??_G?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_71_274_3 {
	meta:
		name = "??_G?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_13_596_3 {
	meta:
		name = "??_G?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_13_597_3 {
	meta:
		name = "??_G?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_110_204_1 {
	meta:
		name = "??_G?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_13_598_3 {
	meta:
		name = "??_G?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_78_456_1 {
	meta:
		name = "??_G?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_744_72_0 {
	meta:
		name = "??_GAffinityRestriction@ResourceManager@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1AffinityRestriction@ResourceManager@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_764_160_0 {
	meta:
		name = "??_GCacheLocalScheduleGroup@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1CacheLocalScheduleGroup@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_764_161_0 {
	meta:
		name = "??_GCacheLocalScheduleGroupSegment@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1CacheLocalScheduleGroupSegment@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1372_40_0 {
	meta:
		name = "??_GCancellationTokenRegistration_TaskProc@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1CancellationTokenRegistration_TaskProc@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_149_64_0 {
	meta:
		name = "??_GContext@Concurrency@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1Context@Concurrency@@MAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_74_0 {
	meta:
		name = "??_GContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ContextBase@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1338_45_0 {
	meta:
		name = "??_GExecutionResource@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1ExecutionResource@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_611_54_0 {
	meta:
		name = "??_GExternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ExternalContextBase@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_764_162_0 {
	meta:
		name = "??_GFairScheduleGroup@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1FairScheduleGroup@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_764_163_0 {
	meta:
		name = "??_GFairScheduleGroupSegment@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1FairScheduleGroupSegment@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1099_69_0 {
	meta:
		name = "??_GFreeThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1FreeThreadProxy@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1099_70_0 {
	meta:
		name = "??_GFreeThreadProxyFactory@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1FreeThreadProxyFactory@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_517_42_0 {
	meta:
		name = "??_GFreeVirtualProcessorRoot@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1FreeVirtualProcessorRoot@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1099_71_0 {
	meta:
		name = "??_GIThreadProxyFactory@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1IThreadProxyFactory@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_149_65_0 {
	meta:
		name = "??_GInternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1InternalContextBase@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_764_164_0 {
	meta:
		name = "??_GRealizedChore@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1RealizedChore@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_744_73_0 {
	meta:
		name = "??_GResourceManager@details@Concurrency@@AAEPAXI@Z"
		size = 44
		refs = "000b ??1ResourceManager@details@Concurrency@@AAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_764_165_0 {
	meta:
		name = "??_GScheduleGroup@Concurrency@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1ScheduleGroup@Concurrency@@MAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_173_110_0 {
	meta:
		name = "??_GScheduleGroupBase@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ScheduleGroupBase@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_173_111_0 {
	meta:
		name = "??_GScheduleGroupSegmentBase@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_764_167_0 {
	meta:
		name = "??_GScheduler@Concurrency@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1Scheduler@Concurrency@@MAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_764_168_0 {
	meta:
		name = "??_GSchedulerBase@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1SchedulerBase@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_764_169_0 {
	meta:
		name = "??_GSchedulerPolicy@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1SchedulerPolicy@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1338_46_0 {
	meta:
		name = "??_GSchedulerProxy@details@Concurrency@@IAEPAXI@Z"
		size = 44
		refs = "000b ??1SchedulerProxy@details@Concurrency@@IAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_764_170_0 {
	meta:
		name = "??_GSchedulingNode@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1SchedulingNode@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_764_171_0 {
	meta:
		name = "??_GSchedulingRing@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1SchedulingRing@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_680_53_0 {
	meta:
		name = "??_GSegment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_173_112_0 {
	meta:
		name = "??_GSegment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_764_172_0 {
	meta:
		name = "??_GSubAllocator@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1SubAllocator@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_686_84_0 {
	meta:
		name = "??_GTaskStack@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1TaskStack@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_278_36_0 {
	meta:
		name = "??_GThreadInternalContext@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ThreadInternalContext@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_851_32_0 {
	meta:
		name = "??_GThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ThreadProxy@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_278_37_0 {
	meta:
		name = "??_GThreadScheduler@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ThreadScheduler@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_828_28_0 {
	meta:
		name = "??_GThreadVirtualProcessor@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ThreadVirtualProcessor@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1142_33_0 {
	meta:
		name = "??_GTimerObj@?6??wait@Concurrency@@YAXI@Z@UAEPAXI@Z"
		size = 44
		refs = "000b ??1TimerObj@?6??wait@Concurrency@@YAXI@Z@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1083_39_0 {
	meta:
		name = "??_GTransmogrifiedPrimary@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1TransmogrifiedPrimary@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1099_72_0 {
	meta:
		name = "??_GUMSFreeThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1UMSFreeThreadProxy@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1099_73_0 {
	meta:
		name = "??_GUMSFreeThreadProxyFactory@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1UMSFreeThreadProxyFactory@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_499_54_0 {
	meta:
		name = "??_GUMSFreeVirtualProcessorRoot@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1UMSFreeVirtualProcessorRoot@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_638_41_0 {
	meta:
		name = "??_GUMSSchedulerProxy@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1UMSSchedulerProxy@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_362_35_0 {
	meta:
		name = "??_GUMSSchedulingContext@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1UMSSchedulingContext@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_292_31_0 {
	meta:
		name = "??_GUMSThreadInternalContext@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1UMSThreadInternalContext@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_214_35_0 {
	meta:
		name = "??_GUMSThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1UMSThreadProxy@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_719_36_0 {
	meta:
		name = "??_GUMSThreadScheduler@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1UMSThreadScheduler@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_362_36_0 {
	meta:
		name = "??_GUMSThreadVirtualProcessor@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1UMSThreadVirtualProcessor@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_54_0 {
	meta:
		name = "??_GVirtualProcessor@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1VirtualProcessor@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_517_43_0 {
	meta:
		name = "??_GVirtualProcessorRoot@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1VirtualProcessorRoot@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_475_34_0 {
	meta:
		name = "??_GWaiterThreadPool@platform@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1WaiterThreadPool@platform@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_173_113_0 {
	meta:
		name = "??_GWorkQueue@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1WorkQueue@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_686_85_0 {
	meta:
		name = "??_G_AsyncTaskCollection@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_AsyncTaskCollection@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_30_798_3 {
	meta:
		name = "??_G_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_30_799_3 {
	meta:
		name = "??_G_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_113_1039_2 {
	meta:
		name = "??_G_CancellationTokenRegistration@details@Concurrency@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1_CancellationTokenRegistration@details@Concurrency@@MAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_971_1 {
	meta:
		name = "??_G_Chore@details@Concurrency@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1_Chore@details@Concurrency@@MAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_62_1 {
	meta:
		name = "??_G_Concurrent_queue_base_v4@details@Concurrency@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1_Concurrent_queue_base_v4@details@Concurrency@@MAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_25_1_3 {
	meta:
		name = "??_G_Condition_variable@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1_Condition_variable@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_972_1 {
	meta:
		name = "??_G_ContinuationTaskHandleBase@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_ContinuationTaskHandleBase@details@Concurrency@@UAE@XZ 001c ??3_AllocBase@details@Concurrency@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_973_1 {
	meta:
		name = "??_G_ExceptionHolder@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1_ExceptionHolder@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1235_5_5 {
	meta:
		name = "??_G_Fac_node@std@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1_Fac_node@std@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_118_167_2 {
	meta:
		name = "??_G_Facet_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_Facet_base@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_974_1 {
	meta:
		name = "??_G_Future_error_category@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_Future_error_category@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_84_166_3 {
	meta:
		name = "??_G_Generic_error_category@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_Generic_error_category@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_112_99_0 {
	meta:
		name = "??_G_Interruption_exception@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_Interruption_exception@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_54_71_3 {
	meta:
		name = "??_G_Iostream_error_category@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_Iostream_error_category@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_33_79_2 {
	meta:
		name = "??_G_Locimp@locale@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1_Locimp@locale@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_1057_3 {
	meta:
		name = "??_G_RefCounter@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_RefCounter@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_686_89_0 {
	meta:
		name = "??_G_RefCounterBase@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_RefCounterBase@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_151_76_0 {
	meta:
		name = "??_G_Ref_count_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_Ref_count_base@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_175_3 {
	meta:
		name = "??_G_System_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_System_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_187_3 {
	meta:
		name = "??_G_System_error_category@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_System_error_category@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_77_0 {
	meta:
		name = "??_G_TaskCollection@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1_TaskCollection@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_1060_3 {
	meta:
		name = "??_G_TaskProcHandle@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_TaskProcHandle@details@Concurrency@@UAE@XZ 001c ??3_AllocBase@details@Concurrency@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_1061_3 {
	meta:
		name = "??_G_TaskProcThunk@details@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1_TaskProcThunk@details@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_113_1051_2 {
	meta:
		name = "??_G_Task_impl_base@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_Task_impl_base@details@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1142_34_0 {
	meta:
		name = "??_G_Timer@details@Concurrency@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1_Timer@details@Concurrency@@MAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_113_1052_2 {
	meta:
		name = "??_G_UnrealizedChore@details@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1_UnrealizedChore@details@Concurrency@@UAE@XZ 001c ??3_AllocBase@details@Concurrency@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_151_77_0 {
	meta:
		name = "??_G__ExceptionPtr@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1__ExceptionPtr@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_559_15_0 {
	meta:
		name = "??_G__non_rtti_object@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1__non_rtti_object@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_800_1 {
	meta:
		name = "??_Gagent@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1agent@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1372_44_0 {
	meta:
		name = "??_Gbad_alloc@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1bad_alloc@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_559_16_0 {
	meta:
		name = "??_Gbad_cast@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1bad_cast@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_151_79_0 {
	meta:
		name = "??_Gbad_exception@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1bad_exception@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_87_62_1 {
	meta:
		name = "??_Gbad_function_call@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1bad_function_call@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_112_100_0 {
	meta:
		name = "??_Gbad_target@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1bad_target@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_559_17_0 {
	meta:
		name = "??_Gbad_typeid@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1bad_typeid@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_985_1 {
	meta:
		name = "??_Gbad_weak_ptr@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1bad_weak_ptr@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_93_188_3 {
	meta:
		name = "??_Gcodecvt_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1codecvt_base@std@@UAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_112_101_0 {
	meta:
		name = "??_Gcontext_self_unblock@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1context_self_unblock@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_149_67_0 {
	meta:
		name = "??_Gcontext_unblock_unbalanced@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1context_unblock_unbalanced@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_73_2 {
	meta:
		name = "??_Gcritical_section@Concurrency@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1critical_section@Concurrency@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_23_189_3 {
	meta:
		name = "??_Gctype_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ctype_base@std@@UAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_112_103_0 {
	meta:
		name = "??_Gdefault_scheduler_exists@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1default_scheduler_exists@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_28_99_3 {
	meta:
		name = "??_Gerror_category@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1error_category@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_559_18_0 {
	meta:
		name = "??_Gexception@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1exception@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1094_29_0 {
	meta:
		name = "??_Gexception_ptr@std@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1exception_ptr@std@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_7_144_1 {
	meta:
		name = "??_Gfacet@locale@std@@MAEPAXI@Z"
		size = 44
		refs = "000b ??1facet@locale@std@@MAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_146_1 {
	meta:
		name = "??_Gfailure@ios_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1failure@ios_base@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_987_1 {
	meta:
		name = "??_Gfuture_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1future_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_112_104_0 {
	meta:
		name = "??_Gimproper_lock@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1improper_lock@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_112_105_0 {
	meta:
		name = "??_Gimproper_scheduler_attach@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1improper_scheduler_attach@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_764_176_0 {
	meta:
		name = "??_Gimproper_scheduler_detach@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1improper_scheduler_detach@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_764_177_0 {
	meta:
		name = "??_Gimproper_scheduler_reference@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1improper_scheduler_reference@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_108_81_3 {
	meta:
		name = "??_Ginvalid_argument@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1invalid_argument@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_112_108_0 {
	meta:
		name = "??_Ginvalid_link_target@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1invalid_link_target@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_686_93_0 {
	meta:
		name = "??_Ginvalid_multiple_scheduling@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1invalid_multiple_scheduling@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_883_33_0 {
	meta:
		name = "??_Ginvalid_operation@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1invalid_operation@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_611_57_0 {
	meta:
		name = "??_Ginvalid_oversubscribe_operation@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1invalid_oversubscribe_operation@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_112_112_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_key@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1invalid_scheduler_policy_key@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1193_37_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_thread_specification@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1invalid_scheduler_policy_thread_specification@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1193_38_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_value@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1invalid_scheduler_policy_value@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_36_182_3 {
	meta:
		name = "??_Gios_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1ios_base@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_14_96_1 {
	meta:
		name = "??_Glength_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1length_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_93_194_3 {
	meta:
		name = "??_Glocale@std@@QAEPAXI@Z"
		size = 44
		refs = "000b ??1locale@std@@QAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_60_3 {
	meta:
		name = "??_Glock_error@threads@stdext@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1lock_error@threads@stdext@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_101_113_2 {
	meta:
		name = "??_Glogic_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1logic_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_64_806_2 {
	meta:
		name = "??_Gmessage_not_found@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1message_not_found@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_110_212_1 {
	meta:
		name = "??_Gmessages_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1messages_base@std@@UAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_686_94_0 {
	meta:
		name = "??_Gmissing_wait@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1missing_wait@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_76_269_2 {
	meta:
		name = "??_Gmoney_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1money_base@std@@UAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_112_117_0 {
	meta:
		name = "??_Gnested_scheduler_missing_detach@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1nested_scheduler_missing_detach@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_807_1 {
	meta:
		name = "??_Goperation_timed_out@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1operation_timed_out@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_108_84_3 {
	meta:
		name = "??_Gout_of_range@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1out_of_range@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_108_85_3 {
	meta:
		name = "??_Goverflow_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1overflow_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_14_99_1 {
	meta:
		name = "??_Grange_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1range_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_87_85_2 {
	meta:
		name = "??_Gregex_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1regex_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_98_86_3 {
	meta:
		name = "??_Gruntime_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1runtime_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_112_119_0 {
	meta:
		name = "??_Gscheduler_not_attached@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1scheduler_not_attached@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1083_40_0 {
	meta:
		name = "??_Gscheduler_resource_allocation_error@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1scheduler_resource_allocation_error@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_112_121_0 {
	meta:
		name = "??_Gscheduler_worker_creation_error@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1scheduler_worker_creation_error@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_48_180_2 {
	meta:
		name = "??_Gsystem_error@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1system_error@std@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_112_122_0 {
	meta:
		name = "??_Gtask_canceled@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1task_canceled@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_62_3 {
	meta:
		name = "??_Gthread_resource_error@threads@stdext@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1thread_resource_error@threads@stdext@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_69_575_2 {
	meta:
		name = "??_Gtime_base@std@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1time_base@std@@UAE@XZ 001c ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_123_5_0 {
	meta:
		name = "??_Gtype_info@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1type_info@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_744_79_0 {
	meta:
		name = "??_Gunsupported_os@Concurrency@@UAEPAXI@Z"
		size = 44
		refs = "000b ??1unsupported_os@Concurrency@@UAE@XZ 001c ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_78_0 {
	meta:
		name = "??_H@YGXPAXIHP6EPAX0@Z@Z"
		size = 35
	strings:
		$1 = { 55 8B EC 8B 45 10 83 E8 01 89 45 10 78 11 8B 4D 08 FF 55 14 8B 4D 08 03 4D 0C 89 4D 08 EB E4 5D C2 10 00 }
	condition:
		$1
}

rule file_22_83_0 {
	meta:
		name = "?AcquirePushBeacon@CancellationBeaconStack@ContextBase@details@Concurrency@@QAEPAUCancellationBeacon@234@H@Z"
		size = 92
		refs = "001a ?Grow@CancellationBeaconStack@ContextBase@details@Concurrency@@AAEXXZ 0028 ??ACancellationBeaconStack@ContextBase@details@Concurrency@@QAEPAUCancellationBeacon@123@J@Z 004f _MemoryBarrier"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 4D FC 8B 10 3B 51 04 7C 08 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B 08 51 8B 4D FC E8 ?? ?? ?? ?? 89 45 F8 8B 55 F8 C7 02 00 00 00 00 8B 45 F8 8B 4D 08 89 48 04 8B 55 FC 8B 02 83 C0 01 8B 4D FC 89 01 E8 ?? ?? ?? ?? 8B 45 F8 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_84_0 {
	meta:
		name = "?AcquireRead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
		size = 22
		refs = "000e ?_AcquireRead@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_872_3 {
	meta:
		name = "??1_Internal_task_options@details@Concurrency@@QAE@XZ"
		size = 22
		refs = "000e ??1_TaskCreationCallstack@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_884_3 {
	meta:
		name = "??1_TaskCreationCallstack@details@Concurrency@@QAE@XZ"
		size = 22
		refs = "000e ??1?$vector@PAXV?$allocator@PAX@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_764_188_0 {
	meta:
		name = "?AcquireWrite@?$SafeRWList@UBoostedObject@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
		size = 22
		refs = "000e ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_85_0 {
	meta:
		name = "?AcquireWrite@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
		size = 22
		refs = "000e ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_140_0 {
	meta:
		name = "?FlushWriteOwners@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
		size = 22
		refs = "000e ?_FlushWriteOwners@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_686_142_0 {
	meta:
		name = "?ReleaseRead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
		size = 22
		refs = "000e ?_ReleaseRead@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_764_437_0 {
	meta:
		name = "?ReleaseWrite@?$SafeRWList@UBoostedObject@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
		size = 22
		refs = "000e ?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1372_64_0 {
	meta:
		name = "?ReleaseWrite@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ"
		size = 22
		refs = "000e ?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_248_0 {
	meta:
		name = "?TryAcquireWrite@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBE_NXZ"
		size = 22
		refs = "000e ?_TryAcquireWrite@_ReaderWriterLock@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_912_1 {
	meta:
		name = "?_Get@?$_Func_impl@U?$_Callable_obj@P6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@@std@@@2@_NABW4agent_status@Concurrency@@@std@@EBEPBXXZ"
		size = 22
		refs = "000e ?_Get@?$_Callable_base@P6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@QBEABQ6A_NABW4agent_status@Concurrency@@@ZXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_86_0 {
	meta:
		name = "?Add@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAEHPAVWorkQueue@23@@Z"
		size = 814
		refs = "0006 __ehhandler$?Add@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAEHPAVWorkQueue@23@@Z 0015 ___security_cookie 003d ??_C@_1BK@NMGGIMFF@?$AAm?$AA_?$AAp?$AAA?$AAr?$AAr?$AAa?$AAy?$AAH?$AAe?$AAa?$AAd?$AA?$AA@ 0042 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 004e ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0055 __CrtDbgReportW 0185 ??_C@_0CO@JCPJEILM@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 01a6 ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 01c7 _memset 01ed ??2@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 020c ??0ArrayNode@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE@PAPAVWorkQueue@23@@Z 0273 ?_UnderlyingYield@details@Concurrency@@YAXXZ 027b ??0?$_SpinWait@$00@details@Concurrency@@QAE@P6AXXZ@Z 0283 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ 02ab ??_C@_1HM@PHFLIKEP@?$AAi?$AAn?$AAs?$AAe?$AAr?$AAt?$AAe?$AAd?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAt?$AAr?$AAu?$AAe?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAi?$AAn?$AAs?$AAe?$AAr?$AAt?$AAe?$AAd?$AA?5?$AA?$DN?$AA?$DN@ 02ed ??_C@_1BG@HMJJDGFN@?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 4C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC C6 45 F3 00 C7 45 E0 00 00 00 00 8B 45 EC 83 78 30 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 26 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 8B 4D EC 8B 51 30 89 55 E8 0F B6 45 F3 85 C0 0F 85 67 02 00 00 8B 4D E8 83 79 08 FF 0F 8C 9E 00 00 00 8B 55 E8 8B 02 89 45 DC C7 45 E4 00 00 00 00 EB 09 8B 4D E4 83 C1 01 89 4D E4 8B 55 EC 8B 45 E4 3B 42 28 7D 79 8B 4D E4 8B 55 DC 83 3C 8A 00 74 02 EB DE 8B 45 E0 03 45 E4 8B 4D 08 89 41 44 8B 55 EC 8B 42 40 89 45 C4 8B 4D 08 8B 55 E4 8B 45 DC 8D 14 90 33 C0 F0 0F B1 0A 89 45 C8 83 7D C8 00 75 36 C6 45 F3 01 8B 45 E0 03 45 E4 89 45 E0 8B 4D E0 3B 4D C4 7C 0F 8B 55 EC 83 C2 40 B8 01 00 00 00 F0 0F C1 02 83 C9 FF 8B 55 E8 83 C2 08 8B 45 E4 F0 0F B1 0A EB 05 E9 73 FF FF FF 0F B6 45 F3 85 C0 0F 85 5A 01 00 00 B9 FE FF FF FF 8B 55 E8 83 C2 08 83 C8 FF F0 0F B1 0A 8B 45 EC 8B 4D E0 03 48 28 89 4D E0 8B 55 E8 83 7A 04 00 0F 85 08 01 00 00 B9 01 00 00 00 8B 55 E8 83 C2 04 33 C0 F0 0F B1 0A 85 C0 0F 85 EF 00 00 00 33 C0 88 45 F2 68 78 05 00 00 68 ?? ?? ?? ?? 0F B6 4D F2 51 33 C9 8B 55 EC 8B 42 28 BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 C0 8B 45 C0 89 45 D8 8B 4D EC 8B 51 28 C1 E2 02 52 6A 00 8B 45 D8 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C9 88 4D F1 8D 55 F1 89 55 BC 68 7E 05 00 00 68 ?? ?? ?? ?? 8B 45 BC 0F B6 08 51 6A 0C E8 ?? ?? ?? ?? 83 C4 10 89 45 D4 C7 45 FC 00 00 00 00 83 7D D4 00 74 11 8B 55 D8 52 8B 4D D4 E8 ?? ?? ?? ?? 89 45 D0 EB 07 C7 45 D0 00 00 00 00 8B 45 D0 89 45 B8 C7 45 FC FF FF FF FF 8B 4D B8 89 4D CC 8B 55 EC 8B 45 EC 8B 4A 3C 3B 48 38 7D 21 8B 55 EC 8B 42 3C 8B 4D EC 8B 51 34 8B 4D CC 89 0C 82 8B 55 EC 8B 42 3C 83 C0 01 8B 4D EC 89 41 3C 8B 55 CC 8B 45 E8 83 C0 04 87 10 8B 4D E8 83 79 04 01 75 1E 68 ?? ?? ?? ?? 8D 4D A8 E8 ?? ?? ?? ?? 8D 4D A8 E8 ?? ?? ?? ?? 8B 55 E8 83 7A 04 01 74 EF 0F B6 45 F3 83 F8 01 74 37 0F B6 4D F3 85 C9 75 09 8B 55 E8 83 7A 04 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 A3 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 BC 33 D2 75 B8 8B 45 E8 8B 48 04 89 4D E8 E9 8D FD FF FF 83 7D E0 00 7D 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 A9 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 D0 33 C9 75 CC 8B 45 E0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_87_0 {
	meta:
		name = "__unwindfunclet$?Add@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAEHPAVWorkQueue@23@@Z$0"
		size = 30
		refs = "0006 ??_C@_0CO@JCPJEILM@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0016 ??3@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
		altNames = "__unwindfunclet$?Add@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAEHPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z$0 __unwindfunclet$?Add@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAEHPAVExternalStatistics@23@@Z$0 __unwindfunclet$?Add@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QAEHPAVScheduleGroupBase@23@@Z$0 __unwindfunclet$?Add@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@QAEHPAVScheduleGroupSegmentBase@23@@Z$0 __unwindfunclet$?Add@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAEHPAVVirtualProcessor@23@@Z$0"
	strings:
		$1 = { 68 7E 05 00 00 68 ?? ?? ?? ?? 8B 45 BC 0F B6 00 50 8B 45 D4 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_22_88_0 {
	meta:
		name = "__ehhandler$?Add@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAEHPAVWorkQueue@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Add@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAEHPAVWorkQueue@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_123_0 {
	meta:
		name = "__ehhandler$?Add@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAEHPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Add@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAEHPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_126_0 {
	meta:
		name = "__ehhandler$?Add@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAEHPAVExternalStatistics@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Add@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAEHPAVExternalStatistics@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_191_0 {
	meta:
		name = "__ehhandler$?Add@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QAEHPAVScheduleGroupBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Add@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QAEHPAVScheduleGroupBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_129_0 {
	meta:
		name = "__ehhandler$?Add@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@QAEHPAVScheduleGroupSegmentBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Add@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@QAEHPAVScheduleGroupSegmentBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_680_61_0 {
	meta:
		name = "__ehhandler$?Add@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAEHPAVVirtualProcessor@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Add@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAEHPAVVirtualProcessor@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1099_86_0 {
	meta:
		name = "__ehhandler$?Create@UMSFreeThreadProxyFactory@details@Concurrency@@EAEPAVUMSFreeThreadProxy@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@UMSFreeThreadProxyFactory@details@Concurrency@@EAEPAVUMSFreeThreadProxy@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_954_5_0 {
	meta:
		name = "__ehhandler$?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_162_147_0 {
	meta:
		name = "__ehhandler$?wait@_Condition_variable@details@Concurrency@@QAEXAAVcritical_section@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?wait@_Condition_variable@details@Concurrency@@QAEXAAVcritical_section@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_162_154_0 {
	meta:
		name = "__ehhandler$?wait_for@_Condition_variable@details@Concurrency@@QAE_NAAVcritical_section@3@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?wait_for@_Condition_variable@details@Concurrency@@QAE_NAAVcritical_section@3@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_89_0 {
	meta:
		name = "?AddStealer@ContextBase@details@Concurrency@@QAEXPAV123@_N@Z"
		size = 54
		refs = "0015 ?AddTail@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z 002c ?DereferenceForCancellation@ContextBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 83 C0 5C 50 8B 4D FC 83 C1 50 E8 ?? ?? ?? ?? 8B 4D 08 C6 41 4D 01 0F B6 55 0C 85 D2 74 08 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_22_90_0 {
	meta:
		name = "?AddTail@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
		size = 153
		refs = "000e ??_C@_1BG@DFKLBKHK@?$AAp?$AAN?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0013 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 001f ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0026 __CrtDbgReportW 008f ?Increment@NoCount@CollectionTypes@details@Concurrency@@SAXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 83 7D 08 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 8B 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 D0 33 D2 75 CC 8B 45 FC 83 38 00 75 13 8B 4D 08 8B 55 08 89 51 04 8B 45 08 8B 4D 08 89 08 EB 30 8B 55 FC 8B 02 8B 4D 08 8B 50 04 89 51 04 8B 45 08 8B 4D FC 8B 11 89 10 8B 45 FC 8B 08 8B 51 04 8B 45 08 89 02 8B 4D FC 8B 11 8B 45 08 89 42 04 8B 4D FC 8B 55 08 89 11 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_91_0 {
	meta:
		name = "?AddTail@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
		size = 106
		refs = "0006 __ehhandler$?AddTail@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z 0015 ___security_cookie 0033 ??0_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QAE@AAV123@@Z 0046 ?AddTail@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z 0055 ??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 83 C0 04 50 8D 4D EC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D 08 51 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D EC E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_764_197_0 {
	meta:
		name = "?AddTail@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QAEXPAVWaitNode@SchedulerBase@23@@Z"
		size = 106
		refs = "0006 __ehhandler$?AddTail@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QAEXPAVWaitNode@SchedulerBase@23@@Z 0015 ___security_cookie 0033 ??0_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QAE@AAV123@@Z 0046 ?AddTail@?$List@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@@details@Concurrency@@QAEXPAVWaitNode@SchedulerBase@23@@Z 0055 ??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 83 C0 04 50 8D 4D EC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D 08 51 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D EC E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_222_0 {
	meta:
		name = "?Remove@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
		size = 106
		refs = "0006 __ehhandler$?Remove@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z 0015 ___security_cookie 0033 ??0_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QAE@AAV123@@Z 0046 ?Remove@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z 0055 ??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 83 C0 04 50 8D 4D EC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D 08 51 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D EC E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_93_0 {
	meta:
		name = "__ehhandler$?AddTail@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddTail@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_52_2 {
	meta:
		name = "__ehhandler$??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_52_2 {
	meta:
		name = "__ehhandler$??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_52_2 {
	meta:
		name = "__ehhandler$??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_117_52_2 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_40_1 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_52_2 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_57_2 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_77_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_34_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_117_2 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBDI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBDI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_72_83_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_296_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_299_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@IG@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@IG@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_302_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_305_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBGI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBGI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_308_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_312_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_281_2 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@I_W@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@I_W@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_284_2 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_321_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_WI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_WI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_324_3 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_404_3 {
	meta:
		name = "__ehhandler$??0?$ordered_message_processor@I@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ordered_message_processor@I@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_407_3 {
	meta:
		name = "__ehhandler$??0?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_686_36_0 {
	meta:
		name = "__ehhandler$??0_TaskCollection@details@Concurrency@@QAE@PAV_CancellationTokenState@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskCollection@details@Concurrency@@QAE@PAV_CancellationTokenState@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_686_39_0 {
	meta:
		name = "__ehhandler$??0_TaskCollection@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskCollection@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1338_28_0 {
	meta:
		name = "__ehhandler$??1SchedulerProxy@details@Concurrency@@IAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulerProxy@details@Concurrency@@IAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_638_25_0 {
	meta:
		name = "__ehhandler$??1UMSSchedulerProxy@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1UMSSchedulerProxy@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_235_3 {
	meta:
		name = "__ehhandler$??4_Iterator_base12@std@@QAEAAU01@ABU01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??4_Iterator_base12@std@@QAEAAU01@ABU01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_1010_3 {
	meta:
		name = "__ehhandler$??R?$_Func_class@EV?$task@_N@Concurrency@@@std@@QBEEV?$task@_N@Concurrency@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??R?$_Func_class@EV?$task@_N@Concurrency@@@std@@QBEEV?$task@_N@Concurrency@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_199_0 {
	meta:
		name = "__ehhandler$?AddTail@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QAEXPAVWaitNode@SchedulerBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddTail@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QAEXPAVWaitNode@SchedulerBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_56_0 {
	meta:
		name = "__ehhandler$?Enqueue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Enqueue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_162_0 {
	meta:
		name = "__ehhandler$?Enqueue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVRealizedChore@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Enqueue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVRealizedChore@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1083_53_0 {
	meta:
		name = "__ehhandler$?Enqueue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QAEXPAVUMSThreadProxy@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Enqueue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QAEXPAVUMSThreadProxy@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1099_111_0 {
	meta:
		name = "__ehhandler$?GetFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVFreeThreadProxyFactory@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVFreeThreadProxyFactory@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1099_119_0 {
	meta:
		name = "__ehhandler$?GetUMSFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVUMSFreeThreadProxyFactory@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetUMSFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVUMSFreeThreadProxyFactory@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_224_0 {
	meta:
		name = "__ehhandler$?Remove@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Remove@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_1105_3 {
	meta:
		name = "__ehhandler$?_Bridge@_TaskProcThunk@details@Concurrency@@SAXPAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Bridge@_TaskProcThunk@details@Concurrency@@SAXPAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_151_117_0 {
	meta:
		name = "__ehhandler$?_Delete_this@?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@EAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Delete_this@?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@std@@EAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_130_3 {
	meta:
		name = "__ehhandler$?_Locimp_dtor@_Locimp@locale@std@@CAXPAV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Locimp_dtor@_Locimp@locale@std@@CAXPAV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_422_2 {
	meta:
		name = "__ehhandler$?_Pdif@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@SAIV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Pdif@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@SAIV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_982_2 {
	meta:
		name = "__ehhandler$?_Pdif@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@SAIV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Pdif@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@SAIV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@2@0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_1026_3 {
	meta:
		name = "__ehhandler$?_Pdif@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@SAIV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Pdif@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@SAIV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@2@0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_1410_2 {
	meta:
		name = "__ehhandler$?_Rethrow_future_exception@std@@YAXVexception_ptr@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Rethrow_future_exception@std@@YAXVexception_ptr@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_1434_3 {
	meta:
		name = "__ehhandler$?_RunChoreBridge@_TaskProcHandle@details@Concurrency@@SAXPAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RunChoreBridge@_TaskProcHandle@details@Concurrency@@SAXPAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_151_140_0 {
	meta:
		name = "__ehhandler$?__ExceptionPtrCurrentException@@YAXPAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?__ExceptionPtrCurrentException@@YAXPAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_94_0 {
	meta:
		name = "?BeaconCount@CancellationBeaconStack@ContextBase@details@Concurrency@@QBEJXZ"
		size = 16
		altNames = "??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEABDXZ ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBEABGXZ ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBEAB_WXZ ??D?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QBEABV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@1@XZ ??D?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QBEABV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@1@XZ ?Current@?$SQueue@VSafePointInvocation@details@Concurrency@@@details@Concurrency@@QBEPAVSafePointInvocation@23@XZ ?GetEvent@UMSBackgroundPoller@details@Concurrency@@QAEPAXXZ ?GetMask@HardwareAffinity@details@Concurrency@@QAEKXZ ?GetScheduler@SchedulingNode@details@Concurrency@@QAEPAVSchedulerBase@23@XZ ?GetType@WorkItem@details@Concurrency@@QBE?AW4WorkItemType@123@XZ ?Value@Count@CollectionTypes@details@Concurrency@@QBEHXZ ?_Get@?$_Ptr_base@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QBEPAU?$_Task_completion_event_impl@E@details@Concurrency@@XZ ?_Get@?$_Ptr_base@U?$_Task_completion_event_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QBEPAU?$_Task_completion_event_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ ?_Get@?$_Ptr_base@U?$_Task_impl@E@details@Concurrency@@@std@@QBEPAU?$_Task_impl@E@details@Concurrency@@XZ ?_Get@?$_Ptr_base@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QBEPAU?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ ?_Get@?$_Ptr_base@U?$_Task_impl@_N@details@Concurrency@@@std@@QBEPAU?$_Task_impl@_N@details@Concurrency@@XZ ?_Get@?$_Ptr_base@U_ExceptionHolder@details@Concurrency@@@std@@QBEPAU_ExceptionHolder@details@Concurrency@@XZ ?_Get@?$_Ptr_base@U_Task_impl_base@details@Concurrency@@@std@@QBEPAU_Task_impl_base@details@Concurrency@@XZ ?_Get@?$_Ptr_base@Uscheduler_interface@Concurrency@@@std@@QBEPAUscheduler_interface@Concurrency@@XZ ?_Get@?$_Ptr_base@V__ExceptionPtr@@@std@@QBEPAV__ExceptionPtr@@XZ ?_Getptr@_Timevec@std@@QBEPAXXZ ?_Unchecked@?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@PAX@std@@@std@@@std@@QBEPBQAXXZ ?value@error_code@std@@QBEHXZ ?value@error_condition@std@@QBEHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_95_0 {
	meta:
		name = "?CancelCollection@ContextBase@details@Concurrency@@QAEXH@Z"
		size = 198
		refs = "0052 ?IsEntireContextCanceled@ContextBase@details@Concurrency@@QBE_NXZ 0074 ?FlagCancellationBeacons@ContextBase@details@Concurrency@@QAEXH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 89 4D FC 8B 45 FC 83 C0 70 B9 01 00 00 00 F0 0F C1 08 8B 55 FC 8B 42 68 89 45 F8 83 7D F8 FF 74 0A 8B 4D 08 3B 4D F8 7E 02 EB 51 8B 55 08 8B 45 FC 83 C0 68 8B C8 8B 45 F8 F0 0F B1 11 89 45 EC 8B 55 EC 3B 55 F8 75 2C 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 09 C7 45 F0 FF FF FF FF EB 06 8B 4D 08 89 4D F0 8B 55 F0 52 8B 4D FC E8 ?? ?? ?? ?? EB 08 8B 45 EC 89 45 F8 EB 9F 8B 4D FC 8B 51 6C 89 55 F4 83 7D F4 FF 74 0A 8B 45 08 3B 45 F4 7D 02 EB 25 8B 4D 08 8B 55 FC 83 C2 6C 8B 45 F4 F0 0F B1 0A 89 45 E8 8B 45 E8 3B 45 F4 75 02 EB 08 8B 4D E8 89 4D F4 EB CB 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_96_0 {
	meta:
		name = "?CancelCollectionComplete@ContextBase@details@Concurrency@@QAE_NH@Z"
		size = 129
		refs = "0013 ??_C@_1DE@KMJDCFIF@?$AAm?$AA_?$AAi?$AAn?$AAl?$AAi?$AAn?$AAe?$AAC?$AAa?$AAn?$AAc?$AAe?$AAl?$AAl?$AAa?$AAt?$AAi?$AAo?$AAn?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0018 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0024 ??_C@_1GA@BONIEFMP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 002b __CrtDbgReportW 0054 ?RecomputeMaximumCancellationDepth@ContextBase@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 78 70 00 7F 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 F9 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 83 C9 FF 8B 55 FC 83 C2 68 8B 45 08 F0 0F B1 0A 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 83 C0 70 83 C9 FF F0 0F C1 08 49 75 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8A 45 F8 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_97_0 {
	meta:
		name = "?CancelEntireContext@ContextBase@details@Concurrency@@QAEXXZ"
		size = 37
		refs = "001d ?CancelCollection@ContextBase@details@Concurrency@@QAEXH@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC B8 01 00 00 00 8B 4D FC 83 C1 74 87 01 68 19 FC FF FF 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_98_0 {
	meta:
		name = "?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z"
		size = 589
		refs = "0006 __ehhandler$?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z 0016 ___security_cookie 0033 ?IsEntireContextCanceled@ContextBase@details@Concurrency@@QBE_NXZ 003f ??_C@_1GM@LMPAMKKF@?$AAp?$AAC?$AAa?$AAn?$AAc?$AAe?$AAl?$AAe?$AAd?$AAC?$AAo?$AAl?$AAl?$AAe?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAI?$AAs?$AAE?$AAn@ 0044 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 004d ??_C@_1GA@BONIEFMP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0054 __CrtDbgReportW 0074 ??0_Scoped_lock_read@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@AAV123@@Z 0086 ?First@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QBEPAUListEntry@23@XZ 00b7 ?GetRootCollection@ContextBase@details@Concurrency@@QAEPAV_TaskCollectionBase@23@XZ 00c5 ??_C@_1CK@GIFOLDBL@?$AAp?$AAR?$AAo?$AAo?$AAt?$AAC?$AAo?$AAl?$AAl?$AAe?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0104 ?_IsCurrentlyInlined@_TaskCollectionBase@details@Concurrency@@QBE_NXZ 0130 ?_InliningDepth@_TaskCollectionBase@details@Concurrency@@QBEHXZ 0164 ??_C@_1NK@ECFLOACE@?$AAp?$AAR?$AAo?$AAo?$AAt?$AAC?$AAo?$AAl?$AAl?$AAe?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAp?$AAC?$AAa?$AAn?$AAc?$AAe?$AAl?$AAe?$AAd?$AAC?$AAo?$AAl?$AAl@ 01bf ??_C@_1IM@NDHLPHGO@?$AAp?$AAR?$AAo?$AAo?$AAt?$AAC?$AAo?$AAl?$AAl?$AAe?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?9?$AA?$DO?$AA_?$AAI?$AAs?$AAC?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AAl?$AAy?$AAI?$AAn?$AAl@ 01f4 ?IsCanceledAtDepth@ContextBase@details@Concurrency@@QAE_NPAV_TaskCollectionBase@23@@Z 0207 ?CancelEntireContext@ContextBase@details@Concurrency@@QAEXXZ 0211 ?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z 0220 ?Next@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QBEPAUListEntry@23@PAU423@@Z 0237 ??1_Scoped_lock_read@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 18 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D E8 83 7D 08 00 75 32 8B 4D E8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 79 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C4 33 C0 75 C0 8B 4D E8 83 C1 50 51 8D 4D DC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D E8 83 C1 50 E8 ?? ?? ?? ?? 89 45 E0 83 7D E0 00 0F 84 95 01 00 00 8B 55 E0 83 EA 5C 89 55 E4 8B 4D E4 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 0F 85 62 01 00 00 8B 4D E4 E8 ?? ?? ?? ?? 89 45 EC 83 7D EC 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 89 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 D0 33 C0 75 CC 8B 4D EC 3B 4D 08 74 4C 83 7D 08 00 75 0F 8B 4D EC E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 37 83 7D 08 00 0F 84 FC 00 00 00 8B 4D 08 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 0F 84 E9 00 00 00 8B 4D EC E8 ?? ?? ?? ?? 8B F0 8B 4D 08 E8 ?? ?? ?? ?? 3B F0 0F 8E CF 00 00 00 8B 4D EC 3B 4D 08 74 3B 83 7D 08 00 74 35 8B 4D EC E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 AE 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 B9 33 D2 75 B5 C6 45 F3 01 8B 45 EC 3B 45 08 74 5E 8B 4D E8 83 79 3C FF 74 55 8B 4D EC E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 09 8B 45 E8 83 78 38 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 B6 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 BE 33 C0 75 BA 8B 4D EC 51 8B 4D E8 E8 ?? ?? ?? ?? 88 45 F3 0F B6 55 F3 85 D2 74 12 8B 4D E4 E8 ?? ?? ?? ?? 6A 00 8B 4D E4 E8 ?? ?? ?? ?? 8B 45 E0 50 8B 4D E8 83 C1 50 E8 ?? ?? ?? ?? 89 45 E0 E9 61 FE FF FF C7 45 FC FF FF FF FF 8D 4D DC E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_100_0 {
	meta:
		name = "__ehhandler$?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_382_3 {
	meta:
		name = "__ehhandler$??$make_shared@U?$_Task_impl@E@details@Concurrency@@AAPAV_CancellationTokenState@23@AAUscheduler_ptr@3@@std@@YA?AV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@4@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$make_shared@U?$_Task_impl@E@details@Concurrency@@AAPAV_CancellationTokenState@23@AAUscheduler_ptr@3@@std@@YA?AV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@4@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_386_3 {
	meta:
		name = "__ehhandler$??$make_shared@U?$_Task_impl@_N@details@Concurrency@@AAPAV_CancellationTokenState@23@AAUscheduler_ptr@3@@std@@YA?AV?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@0@AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@4@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$make_shared@U?$_Task_impl@_N@details@Concurrency@@AAPAV_CancellationTokenState@23@AAUscheduler_ptr@3@@std@@YA?AV?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@0@AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@4@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_390_3 {
	meta:
		name = "__ehhandler$??$make_shared@U_ExceptionHolder@details@Concurrency@@ABVexception_ptr@std@@V_TaskCreationCallstack@23@@std@@YA?AV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@0@ABVexception_ptr@0@$$QAV_TaskCreationCallstack@details@Concurrency@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$make_shared@U_ExceptionHolder@details@Concurrency@@ABVexception_ptr@std@@V_TaskCreationCallstack@23@@std@@YA?AV?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@0@ABVexception_ptr@0@$$QAV_TaskCreationCallstack@details@Concurrency@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_151_26_0 {
	meta:
		name = "__ehhandler$??$reset@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@std@@QAEXPAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$reset@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@std@@QAEXPAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_13_0 {
	meta:
		name = "__ehhandler$??0?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@PAV_HyperNonReentrantLock@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@PAV_HyperNonReentrantLock@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_12_0 {
	meta:
		name = "__ehhandler$??0?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@PAV_CriticalNonReentrantLock@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@PAV_CriticalNonReentrantLock@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_15_0 {
	meta:
		name = "__ehhandler$??0?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@PAV_CriticalNonReentrantLock@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@PAV_CriticalNonReentrantLock@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_542_1 {
	meta:
		name = "__ehhandler$??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_258_3 {
	meta:
		name = "__ehhandler$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_548_3 {
	meta:
		name = "__ehhandler$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBEHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBEHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_554_3 {
	meta:
		name = "__ehhandler$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBEHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBEHABV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_37_0 {
	meta:
		name = "__ehhandler$??IQuickBitSet@details@Concurrency@@QBE?AV012@ABV012@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??IQuickBitSet@details@Concurrency@@QBE?AV012@ABV012@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_194_0 {
	meta:
		name = "__ehhandler$?AddContext@SchedulerBase@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddContext@SchedulerBase@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1338_70_0 {
	meta:
		name = "__ehhandler$?CreateExternalThreadResource@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@PAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateExternalThreadResource@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@PAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_278_48_0 {
	meta:
		name = "__ehhandler$?CreateInternalContext@ThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateInternalContext@ThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_719_48_0 {
	meta:
		name = "__ehhandler$?CreateInternalContext@UMSThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateInternalContext@UMSThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1338_85_0 {
	meta:
		name = "__ehhandler$?DestroyExecutionResource@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?DestroyExecutionResource@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_136_38_0 {
	meta:
		name = "__ehhandler$?FindSegment@FairScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVlocation@3@PAVSchedulingRing@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?FindSegment@FairScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVlocation@3@PAVSchedulingRing@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_306_0 {
	meta:
		name = "__ehhandler$?GetExternalContext@SchedulerBase@details@Concurrency@@AAEPAVExternalContextBase@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetExternalContext@SchedulerBase@details@Concurrency@@AAEPAVExternalContextBase@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_333_0 {
	meta:
		name = "__ehhandler$?GetRealizedChore@SchedulerBase@details@Concurrency@@QAEPAVRealizedChore@23@P6AXPAX@Z0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetRealizedChore@SchedulerBase@details@Concurrency@@QAEPAVRealizedChore@23@P6AXPAX@Z0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1338_105_0 {
	meta:
		name = "__ehhandler$?GetResourceForNewSubscription@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@PAV423@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetResourceForNewSubscription@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@PAV423@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_179_0 {
	meta:
		name = "__ehhandler$?Grow@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEPAUSegment@123@PAU4123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Grow@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@AAEPAUSegment@123@PAU4123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_422_0 {
	meta:
		name = "__ehhandler$?PushRunnableToInactive@SchedulerBase@details@Concurrency@@UAE_NPAVInternalContextBase@23@Vlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?PushRunnableToInactive@SchedulerBase@details@Concurrency@@UAE_NPAVInternalContextBase@23@Vlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_744_222_0 {
	meta:
		name = "__ehhandler$?Release@ResourceManager@details@Concurrency@@UAEIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Release@ResourceManager@details@Concurrency@@UAEIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_373_3 {
	meta:
		name = "__ehhandler$?_Getfmt@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getfmt@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_694_1 {
	meta:
		name = "__ehhandler$?_Getfmt@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getfmt@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_811_2 {
	meta:
		name = "__ehhandler$?_Getfmt@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getfmt@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_1082_3 {
	meta:
		name = "__ehhandler$?_internal_send@?$_AnonymousOriginator@I@details@Concurrency@@AAE_NPAV?$ITarget@I@3@ABI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_internal_send@?$_AnonymousOriginator@I@details@Concurrency@@AAE_NPAV?$ITarget@I@3@ABI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_1085_1 {
	meta:
		name = "__ehhandler$?_internal_send@?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@AAE_NPAV?$ITarget@W4agent_status@Concurrency@@@3@ABW4agent_status@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_internal_send@?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@AAE_NPAV?$ITarget@W4agent_status@Concurrency@@@3@ABW4agent_status@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_483_5_0 {
	meta:
		name = "__ehhandler$?x_ismbbtype_l@@YAHPAUlocaleinfo_struct@@IHH@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?x_ismbbtype_l@@YAHPAUlocaleinfo_struct@@IHH@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_137_2 {
	meta:
		name = "__ehhandler$__Call_func@4"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$__Call_func@4 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_101_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 66
		refs = "000e ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0026 ?DeleteElements@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 24 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 02 EB 23 8B 55 FC 8B 42 10 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 41 10 00 00 00 00 33 D2 8B 45 FC 83 C0 48 87 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_173_135_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 66
		refs = "000e ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0026 ?DeleteElements@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 24 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 02 EB 23 8B 55 FC 8B 42 10 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 41 10 00 00 00 00 33 D2 8B 45 FC 83 C0 48 87 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_764_214_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 66
		refs = "000e ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0026 ?DeleteElements@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 24 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 02 EB 23 8B 55 FC 8B 42 10 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 41 10 00 00 00 00 33 D2 8B 45 FC 83 C0 48 87 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_764_215_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 66
		refs = "000e ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0026 ?DeleteElements@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 24 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 02 EB 23 8B 55 FC 8B 42 10 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 41 10 00 00 00 00 33 D2 8B 45 FC 83 C0 48 87 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_157_47_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 66
		refs = "000e ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0026 ?DeleteElements@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 24 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 02 EB 23 8B 55 FC 8B 42 10 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 41 10 00 00 00 00 33 D2 8B 45 FC 83 C0 48 87 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_65_0 {
	meta:
		name = "?CheckForDeletion@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@AAEXXZ"
		size = 66
		refs = "000e ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 0026 ?DeleteElements@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 24 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 02 EB 23 8B 55 FC 8B 42 10 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 41 10 00 00 00 00 33 D2 8B 45 FC 83 C0 48 87 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_103_0 {
	meta:
		name = "?Claim@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE_NPAPAV_UnrealizedChore@34@@Z"
		size = 158
		refs = "0024 ??_C@_1BK@NBINLAEN@?$AAp?$AAO?$AAb?$AAj?$AAe?$AAc?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0029 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0035 ??_C@_1FE@DLHEPCDH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 003c __CrtDbgReportW 0092 ?Dereference@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 8B 08 8B 55 FC 8B 42 04 8B 49 0C 8B 14 81 89 55 F8 83 7D F8 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 DE 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 D0 33 D2 75 CC 83 7D F8 01 74 35 B8 01 00 00 00 8B 4D FC 8B 11 8B 4D FC 8B 49 04 8B 52 0C 8D 0C 8A 87 01 89 45 F4 8B 55 F4 3B 55 F8 75 12 83 7D 08 00 74 08 8B 45 08 8B 4D F8 89 08 B0 01 EB 0C 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 32 C0 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_67_0 {
	meta:
		name = "?Claim@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE_NPAPAVInternalContextBase@34@@Z"
		size = 158
		refs = "0024 ??_C@_1BK@NBINLAEN@?$AAp?$AAO?$AAb?$AAj?$AAe?$AAc?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0029 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0035 ??_C@_1FE@DLHEPCDH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 003c __CrtDbgReportW 0092 ?Dereference@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 8B 08 8B 55 FC 8B 42 04 8B 49 0C 8B 14 81 89 55 F8 83 7D F8 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 DE 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 D0 33 D2 75 CC 83 7D F8 01 74 35 B8 01 00 00 00 8B 4D FC 8B 11 8B 4D FC 8B 49 04 8B 52 0C 8D 0C 8A 87 01 89 45 F4 8B 55 F4 3B 55 F8 75 12 83 7D 08 00 74 08 8B 45 08 8B 4D F8 89 08 B0 01 EB 0C 8B 55 FC 8B 0A E8 ?? ?? ?? ?? 32 C0 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_104_0 {
	meta:
		name = "?Cleanup@ContextBase@details@Concurrency@@QAEXXZ"
		size = 58
		refs = "000b ?ReleaseWorkQueue@ContextBase@details@Concurrency@@IAEXXZ 0032 ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B 48 08 51 8B 55 FC 8B 42 1C 8B 4D FC 8B 10 8B 49 1C 8B 42 04 FF D0 50 6A 04 6A 02 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_105_0 {
	meta:
		name = "?ClearAliasTable@ContextBase@details@Concurrency@@QAEXXZ"
		size = 92
		refs = "0017 ?First@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEPAUListNode@123@PAH@Z 002b ?_ReleaseAlias@_TaskCollection@details@Concurrency@@AAEXXZ 0041 ?Next@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEPAUListNode@123@PAHPAU4123@@Z 0054 ?Wipe@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F8 8D 45 F4 50 8B 4D F8 81 C1 80 00 00 00 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 26 8B 4D FC 8B 49 08 E8 ?? ?? ?? ?? 8B 55 FC 52 8D 45 F4 50 8B 4D F8 81 C1 80 00 00 00 E8 ?? ?? ?? ?? 89 45 FC EB D4 8B 4D F8 81 C1 80 00 00 00 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_106_0 {
	meta:
		name = "?ClearContextTls@ContextBase@details@Concurrency@@AAEXXZ"
		size = 92
		refs = "0008 ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 000e ?__TlsGetValue@platform@details@Concurrency@@YAPAXK@Z 001a ??_C@_1HM@IPEGFIAI@?$AAp?$AAl?$AAa?$AAt?$AAf?$AAo?$AAr?$AAm?$AA?3?$AA?3?$AA_?$AA_?$AAT?$AAl?$AAs?$AAG?$AAe?$AAt?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?$CI?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe@ 001f ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 002b ??_C@_1GA@BONIEFMP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0032 __CrtDbgReportW 0051 ?__TlsSetValue@platform@details@Concurrency@@YAXKPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 0E 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C4 33 C0 75 C0 6A 00 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_107_0 {
	meta:
		name = "?ConfirmCancel@ContextBase@details@Concurrency@@QAE_NPAU_Beacon_reference@23@@Z"
		size = 36
		refs = "001a ?IsCanceledAtDepth@ContextBase@details@Concurrency@@QAE_NH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 08 89 45 FC 8B 4D FC 8B 51 04 52 8B 4D F8 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_108_0 {
	meta:
		name = "?Count@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QBEHXZ"
		size = 17
		altNames = "?GetExecutionResourceTls@?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAEKXZ ?GetExecutionResourceTls@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UAEKXZ ?GetId@UMSSchedulingContext@details@Concurrency@@UBEIXZ ?GetOwningNode@SchedulingRing@details@Concurrency@@QBEPAVSchedulingNode@23@XZ ?GetScheduleGroupSegment@WorkItem@details@Concurrency@@QBEPAVScheduleGroupSegmentBase@23@XZ ?GetScheduler@ScheduleGroupBase@details@Concurrency@@QAEPAVSchedulerBase@23@XZ ?GetSchedulingRing@SchedulingNode@details@Concurrency@@QAEPAVSchedulingRing@23@XZ ?_GetBindingId@location@Concurrency@@QBEIXZ ?_GetId@_Runtime_object@details@Concurrency@@UBEHXZ ?_Size@?$_Dynamic_array@PAV?$ISource@I@Concurrency@@@details@Concurrency@@QBEIXZ ?_Size@?$_Dynamic_array@PAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QBEIXZ ?_Size@?$_Dynamic_array@PAV?$ITarget@I@Concurrency@@@details@Concurrency@@QBEIXZ ?_Size@?$_Dynamic_array@PAV?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QBEIXZ ?category@error_code@std@@QBEABVerror_category@2@XZ ?category@error_condition@std@@QBEABVerror_category@2@XZ ?msg_id@?$message@I@Concurrency@@QBEHXZ ?msg_id@?$message@W4agent_status@Concurrency@@@Concurrency@@QBEHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_109_0 {
	meta:
		name = "?Count@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QBEHXZ"
		size = 22
		altNames = "?Count@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QBEHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 04 8B 4D FC 2B 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_110_0 {
	meta:
		name = "?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
		size = 335
		refs = "0006 __ehhandler$?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0032 ?PullFromFreePool@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAEPAVWorkQueue@23@XZ 0050 ?GetDetachedWorkQueue@ScheduleGroupSegmentBase@details@Concurrency@@IAEPAVWorkQueue@23@XZ 0074 ??_C@_0DA@FKFMEOLK@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0082 ??2@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 009d ??0WorkQueue@details@Concurrency@@QAE@XZ 00d4 ?Add@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAEHPAVWorkQueue@23@@Z 00e1 ?Reinitialize@WorkQueue@details@Concurrency@@AAEXXZ 0104 ??_C@_1CE@MFPOBKIK@?$AAm?$AA_?$AAp?$AAW?$AAo?$AAr?$AAk?$AAQ?$AAu?$AAe?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0109 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0115 ??_C@_1GA@BONIEFMP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 011c __CrtDbgReportW 013c ?SetOwningContext@WorkQueue@details@Concurrency@@QAEXPAVContextBase@23@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 18 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 8B 45 EC 8B 48 18 83 C1 58 E8 ?? ?? ?? ?? 8B 4D EC 89 41 20 8B 55 EC 83 7A 20 00 0F 85 91 00 00 00 8B 45 EC 8B 48 18 E8 ?? ?? ?? ?? 8B 4D EC 89 41 20 8B 55 EC 83 7A 20 00 75 75 33 C0 88 45 F3 8D 4D F3 89 4D E0 68 94 02 00 00 68 ?? ?? ?? ?? 8B 55 E0 0F B6 02 50 6A 74 E8 ?? ?? ?? ?? 83 C4 10 89 45 E8 C7 45 FC 00 00 00 00 83 7D E8 00 74 0D 8B 4D E8 E8 ?? ?? ?? ?? 89 45 E4 EB 07 C7 45 E4 00 00 00 00 8B 4D E4 89 4D DC C7 45 FC FF FF FF FF 8B 55 EC 8B 45 DC 89 42 20 8B 4D EC 8B 51 20 52 8B 45 EC 8B 48 18 83 C1 58 E8 ?? ?? ?? ?? EB 20 8B 4D EC 8B 49 20 E8 ?? ?? ?? ?? 8B 55 EC 8B 42 20 50 8B 4D EC 8B 49 18 83 C1 58 E8 ?? ?? ?? ?? 8B 55 EC 83 7A 20 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 A1 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 8B 45 EC 50 8B 4D EC 8B 49 20 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_111_0 {
	meta:
		name = "__unwindfunclet$?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ$0"
		size = 30
		refs = "0006 ??_C@_0DA@FKFMEOLK@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0016 ??3@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 68 94 02 00 00 68 ?? ?? ?? ?? 8B 45 E0 0F B6 00 50 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_22_112_0 {
	meta:
		name = "__ehhandler$?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_121_3 {
	meta:
		name = "__ehhandler$??$_AsyncInit@_N_N@_Task_impl_base@details@Concurrency@@SAXABV?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@std@@ABV?$task@_N@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_AsyncInit@_N_N@_Task_impl_base@details@Concurrency@@SAXABV?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@std@@ABV?$task@_N@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_21_0 {
	meta:
		name = "__ehhandler$??0?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@ABVQuickBitSet@12@_NI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@ABVQuickBitSet@12@_NI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_611_15_0 {
	meta:
		name = "__ehhandler$??0ExternalContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ExternalContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_744_25_0 {
	meta:
		name = "__ehhandler$??0ResourceManager@details@Concurrency@@AAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ResourceManager@details@Concurrency@@AAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1091_2_6 {
	meta:
		name = "__ehhandler$??2@YAPAXIABUnothrow_t@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??2@YAPAXIABUnothrow_t@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1338_61_0 {
	meta:
		name = "__ehhandler$?AddVirtualProcessorRoots@SchedulerProxy@details@Concurrency@@QAEXPAPAUIVirtualProcessorRoot@3@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddVirtualProcessorRoots@SchedulerProxy@details@Concurrency@@QAEXPAPAUIVirtualProcessorRoot@3@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_149_82_0 {
	meta:
		name = "__ehhandler$?Alloc@InternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Alloc@InternalContextBase@details@Concurrency@@UAEPAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_203_0 {
	meta:
		name = "__ehhandler$?AllocateSegment@CacheLocalScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AllocateSegment@CacheLocalScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1099_83_0 {
	meta:
		name = "__ehhandler$?Create@FreeThreadProxyFactory@details@Concurrency@@EAEPAVFreeThreadProxy@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@FreeThreadProxyFactory@details@Concurrency@@EAEPAVFreeThreadProxy@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_719_52_0 {
	meta:
		name = "__ehhandler$?CreateScheduleGroup@SchedulerBase@details@Concurrency@@UAEPAVScheduleGroup@3@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateScheduleGroup@SchedulerBase@details@Concurrency@@UAEPAVScheduleGroup@3@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_278_55_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessor@ThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessor@ThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_719_55_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessor@UMSThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessor@UMSThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1338_76_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_115_0 {
	meta:
		name = "__ehhandler$?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_744_121_0 {
	meta:
		name = "__ehhandler$?CurrentSubscriptionLevel@ResourceManager@details@Concurrency@@QAEIII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CurrentSubscriptionLevel@ResourceManager@details@Concurrency@@QAEIII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_342_0 {
	meta:
		name = "__ehhandler$?GetSubAllocator@SchedulerBase@details@Concurrency@@SAPAVSubAllocator@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetSubAllocator@SchedulerBase@details@Concurrency@@SAPAVSubAllocator@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_744_195_0 {
	meta:
		name = "__ehhandler$?Initialize@GlobalCore@details@Concurrency@@QAEXPAUGlobalNode@23@IE@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Initialize@GlobalCore@details@Concurrency@@QAEXPAUGlobalNode@23@IE@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_486_0 {
	meta:
		name = "__ehhandler$?StartupVirtualProcessor@SchedulerBase@details@Concurrency@@QAE_NPAVScheduleGroupSegmentBase@23@Vlocation@3@K@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?StartupVirtualProcessor@SchedulerBase@details@Concurrency@@QAE_NPAVScheduleGroupSegmentBase@23@Vlocation@3@K@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_151_90_0 {
	meta:
		name = "__ehhandler$?_CallCopyCtor@__ExceptionPtr@@ABEXPAX0IQBU_s_CatchableType@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CallCopyCtor@__ExceptionPtr@@ABEXPAX0IQBU_s_CatchableType@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_686_166_0 {
	meta:
		name = "__ehhandler$?_CancelStolenContexts@_TaskCollection@details@Concurrency@@AAEX_N0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CancelStolenContexts@_TaskCollection@details@Concurrency@@AAEX_N0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_1147_3 {
	meta:
		name = "__ehhandler$?_CaptureMultiFramesCallstack@_TaskCreationCallstack@details@Concurrency@@SA?AV123@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CaptureMultiFramesCallstack@_TaskCreationCallstack@details@Concurrency@@SA?AV123@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_399_2 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_783_1 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_916_2 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_1405_3 {
	meta:
		name = "__ehhandler$?_RegisterCancellation@_Task_impl_base@details@Concurrency@@QAEXV?$weak_ptr@U_Task_impl_base@details@Concurrency@@@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RegisterCancellation@_Task_impl_base@details@Concurrency@@QAEXV?$weak_ptr@U_Task_impl_base@details@Concurrency@@@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_542_55_0 {
	meta:
		name = "__ehhandler$?_RegisterConcRTEventTracing@details@Concurrency@@YAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RegisterConcRTEventTracing@details@Concurrency@@YAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_1334_1 {
	meta:
		name = "__ehhandler$?_RunContinuation@_Task_impl_base@details@Concurrency@@QAEXPAU_ContinuationTaskHandleBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RunContinuation@_Task_impl_base@details@Concurrency@@QAEXPAU_ContinuationTaskHandleBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_506_2 {
	meta:
		name = "__ehhandler$?do_get_year@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_year@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_1286_3 {
	meta:
		name = "__ehhandler$?do_get_year@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_year@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_1088_1 {
	meta:
		name = "__ehhandler$?do_get_year@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_year@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_372_1 {
	meta:
		name = "__ehhandler$?global@locale@std@@SA?AV12@ABV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?global@locale@std@@SA?AV12@ABV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_1618_2 {
	meta:
		name = "__ehhandler$?resize@?$vector@PAXV?$allocator@PAX@std@@@std@@QAEXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?resize@?$vector@PAXV?$allocator@PAX@std@@@std@@QAEXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_113_0 {
	meta:
		name = "?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
		size = 314
		refs = "0006 __ehhandler$?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 0015 ___security_cookie 002f ?GetDetachedWorkQueue@ScheduleGroupSegmentBase@details@Concurrency@@IAEPAVWorkQueue@23@XZ 0050 ?PullFromFreePool@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAEPAVWorkQueue@23@XZ 0074 ??_C@_0DA@FKFMEOLK@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0082 ??2@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 009d ??0WorkQueue@details@Concurrency@@QAE@XZ 00cc ?Reinitialize@WorkQueue@details@Concurrency@@AAEXXZ 00e1 ?Add@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAEHPAVWorkQueue@23@@Z 00ef ??_C@_1CE@MFPOBKIK@?$AAm?$AA_?$AAp?$AAW?$AAo?$AAr?$AAk?$AAQ?$AAu?$AAe?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 00f4 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0100 ??_C@_1GA@BONIEFMP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0107 __CrtDbgReportW 0127 ?SetOwningContext@WorkQueue@details@Concurrency@@QAEXPAVContextBase@23@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 18 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 8B 45 EC 8B 48 18 E8 ?? ?? ?? ?? 8B 4D EC 89 41 20 8B 55 EC 83 7A 20 00 0F 85 9F 00 00 00 8B 45 EC 8B 48 18 83 C1 58 E8 ?? ?? ?? ?? 8B 4D EC 89 41 20 8B 55 EC 83 7A 20 00 75 62 33 C0 88 45 F3 8D 4D F3 89 4D E0 68 6B 02 00 00 68 ?? ?? ?? ?? 8B 55 E0 0F B6 02 50 6A 74 E8 ?? ?? ?? ?? 83 C4 10 89 45 E8 C7 45 FC 00 00 00 00 83 7D E8 00 74 0D 8B 4D E8 E8 ?? ?? ?? ?? 89 45 E4 EB 07 C7 45 E4 00 00 00 00 8B 4D E4 89 4D DC C7 45 FC FF FF FF FF 8B 55 EC 8B 45 DC 89 42 20 EB 0B 8B 4D EC 8B 49 20 E8 ?? ?? ?? ?? 8B 55 EC 8B 42 20 50 8B 4D EC 8B 49 18 83 C1 58 E8 ?? ?? ?? ?? 8B 55 EC 83 7A 20 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 78 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 8B 45 EC 50 8B 4D EC 8B 49 20 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_114_0 {
	meta:
		name = "__unwindfunclet$?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ$0"
		size = 30
		refs = "0006 ??_C@_0DA@FKFMEOLK@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0016 ??3@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 68 6B 02 00 00 68 ?? ?? ?? ?? 8B 45 E0 0F B6 00 50 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_22_116_0 {
	meta:
		name = "?CurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ"
		size = 61
		refs = "0005 ?IsOneShotInitialized@SchedulerBase@details@Concurrency@@SA_NXZ 0011 ?CreateContextFromDefaultScheduler@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0019 ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 001f ?__TlsGetValue@platform@details@Concurrency@@YAPAXK@Z"
	strings:
		$1 = { 55 8B EC 51 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 07 E8 ?? ?? ?? ?? EB 22 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 75 07 E8 ?? ?? ?? ?? EB 03 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_118_0 {
	meta:
		name = "?Delete@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE_NABQAV_TaskCollection@23@@Z"
		size = 27
		refs = "0011 ?FindAndDelete@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE_NABQAV_TaskCollection@23@PAPAV423@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 00 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_20_305_3 {
	meta:
		name = "?clear@ios_base@std@@QAEXH@Z"
		size = 27
		refs = "0011 ?clear@ios_base@std@@QAEXH_N@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 00 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_110_496_1 {
	meta:
		name = "?resize@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z"
		size = 27
		refs = "0011 ?resize@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXID@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 00 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_13_1513_3 {
	meta:
		name = "?resize@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXI@Z"
		size = 27
		refs = "0011 ?resize@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXIG@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 00 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_13_1515_3 {
	meta:
		name = "?resize@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXI@Z"
		size = 27
		refs = "0011 ?resize@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXI_W@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 00 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_119_0 {
	meta:
		name = "?DeleteElements@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
		size = 52
		refs = "0025 ??$_InternalDeleteHelper@VWorkQueue@details@Concurrency@@@details@Concurrency@@YAXPAVWorkQueue@01@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 83 7D 08 00 74 1F 8B 45 08 83 E8 18 89 45 FC 8B 4D 08 8B 11 89 55 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 EB DB 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_122_0 {
	meta:
		name = "?Dereference@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEXXZ"
		size = 35
		refs = "001b ?Expire@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 C0 14 83 C9 FF F0 0F C1 08 49 75 08 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_77_0 {
	meta:
		name = "?Dereference@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEXXZ"
		size = 35
		refs = "001b ?Expire@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 C0 14 83 C9 FF F0 0F C1 08 49 75 08 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_123_0 {
	meta:
		name = "?DereferenceForCancellation@ContextBase@details@Concurrency@@QAEXXZ"
		size = 24
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 C0 64 83 C9 FF F0 0F C1 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_124_0 {
	meta:
		name = "?DetachStealers@ContextBase@details@Concurrency@@QAEXXZ"
		size = 558
		refs = "0006 __sehtable$?DetachStealers@ContextBase@details@Concurrency@@QAEXXZ 000b __except_handler4 001d ___security_cookie 003d ?_UnderlyingYield@details@Concurrency@@YAXXZ 0045 ??0?$_SpinWait@$0A@@details@Concurrency@@QAE@P6AXXZ@Z 004d ?_SpinOnce@?$_SpinWait@$0A@@details@Concurrency@@QAE_NXZ 0064 ?Count@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QBEHXZ 0070 ?ClearAliasTable@ContextBase@details@Concurrency@@QAEXXZ 007b ?Empty@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QBE_NXZ 008d ?FlushWriteOwners@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ 00b1 ?AcquireWrite@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ 00c7 ?First@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QBEPAUListEntry@23@XZ 00ef ?Next@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QBEPAUListEntry@23@PAU423@@Z 0103 ?GetRootCollection@ContextBase@details@Concurrency@@QAEPAV_TaskCollectionBase@23@XZ 0114 ?_IsStructured@_TaskCollectionBase@details@Concurrency@@QAE_NXZ 0120 ??_C@_1HE@ELLCNDJM@?$AAp?$AAC?$AAo?$AAl?$AAl?$AAe?$AAc?$AAt?$AAi?$AAo?$AAn?$AAB?$AAa?$AAs?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CB?$AAp?$AAC?$AAo?$AAl?$AAl?$AAe?$AAc@ 0125 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0131 ??_C@_1GA@BONIEFMP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0138 __CrtDbgReportW 0157 ?_GetStealTrackingList@_TaskCollection@details@Concurrency@@ABEPAXXZ 0162 ?TryAcquireWrite@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBE_NXZ 0174 ?ReleaseWrite@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QBEXXZ 017f ?__Sleep@platform@details@Concurrency@@YAXK@Z 019d ?UnlockedRemove@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z 01b3 ?UnlockedAddTail@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 C4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 4D E0 8B 45 E0 83 78 64 00 74 1E 68 ?? ?? ?? ?? 8D 4D B4 E8 ?? ?? ?? ?? 8D 4D B4 E8 ?? ?? ?? ?? 8B 4D E0 83 79 64 00 75 EF 8B 4D E0 81 C1 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 7E 08 8B 4D E0 E8 ?? ?? ?? ?? 8B 4D E0 83 C1 50 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 10 8B 4D E0 83 C1 50 E8 ?? ?? ?? ?? E9 86 01 00 00 C6 45 E6 00 0F B6 45 E6 85 C0 0F 85 76 01 00 00 C6 45 E7 01 8B 4D E0 83 C1 50 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 C6 45 E7 01 8B 4D E0 83 C1 50 E8 ?? ?? ?? ?? 89 45 DC 83 7D DC 00 0F 84 01 01 00 00 0F B6 4D E7 85 C9 0F 84 F5 00 00 00 8B 55 DC 52 8B 4D E0 83 C1 50 E8 ?? ?? ?? ?? 89 45 C4 8B 45 DC 83 E8 5C 89 45 D8 8B 4D D8 E8 ?? ?? ?? ?? 89 45 D4 83 7D D4 00 74 0F 8B 4D D4 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 13 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C1 33 C9 75 BD 8B 55 D4 89 55 C8 8B 4D C8 E8 ?? ?? ?? ?? 89 45 D0 8B 4D D0 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 1B 8B 4D E0 83 C1 50 E8 ?? ?? ?? ?? C6 45 E7 00 6A 01 E8 ?? ?? ?? ?? 83 C4 04 EB 51 C7 45 FC 01 00 00 00 8B 4D D8 83 C1 5C 51 8B 4D E0 83 C1 50 E8 ?? ?? ?? ?? 8B 55 D8 C6 42 4D 00 8B 45 D8 83 C0 5C 50 8B 4D D0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 E8 02 00 00 00 EB 09 8B 4D D0 E8 ?? ?? ?? ?? C3 8B 4D C4 89 4D DC E9 F5 FE FF FF 83 7D DC 00 75 09 C7 45 CC 01 00 00 00 EB 07 C7 45 CC 00 00 00 00 8A 55 CC 88 55 E6 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 14 0F B6 45 E7 85 C0 74 0B 8B 4D E0 83 C1 50 E8 ?? ?? ?? ?? C3 E9 7E FE FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_125_0 {
	meta:
		name = "?Empty@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QBE_NXZ"
		size = 40
		altNames = "?Empty@?$List@UBoostedObject@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QBE_NXZ ?Empty@?$List@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@@details@Concurrency@@QBE_NXZ ?Empty@?$SQueue@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QBE_NXZ ?Empty@?$SQueue@VRealizedChore@details@Concurrency@@@details@Concurrency@@QBE_NXZ ?Empty@?$SQueue@VSafePointInvocation@details@Concurrency@@@details@Concurrency@@QBE_NXZ ?IsEmpty@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QBE_NXZ ?IsEmpty@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QBE_NXZ ?IsScheduleGroupSegment@BoostedObject@details@Concurrency@@QBE_NXZ ?_Empty@?$_Yarn@D@std@@QBE_NXZ ?_Empty@?$_Yarn@_W@std@@QBE_NXZ ?empty@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 83 38 00 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_126_0 {
	meta:
		name = "?Empty@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QBE_NXZ"
		size = 45
		altNames = "?Empty@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QBE_NXZ ?Empty@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 4D FC 8B 11 39 50 04 7F 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8A 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_127_0 {
	meta:
		name = "?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
		size = 46
		refs = "000e ?IsUMSScheduler@SchedulerBase@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 1C E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0F 8B 55 FC 8B 02 8B 4D FC 8B 50 30 FF D2 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_128_0 {
	meta:
		name = "?EnterCriticalRegionHelper@ContextBase@details@Concurrency@@UAEHXZ"
		size = 72
		refs = "000a ?CurrentContext@Context@Concurrency@@SAPAV12@XZ 001b ??_C@_0CO@JBGNEBPL@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0020 ??_C@_0CC@DPOLDNHN@Context?3?3CurrentContext?$CI?$CJ?5?$DN?$DN?5thi@ 0025 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC E8 ?? ?? ?? ?? 3B 45 FC 75 02 EB 17 68 92 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 8B 48 0C 83 C1 01 89 4D F8 8B 55 FC 8B 45 F8 89 42 0C 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_129_0 {
	meta:
		name = "?EnterHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
		size = 46
		refs = "000e ?IsUMSScheduler@SchedulerBase@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 1C E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0F 8B 55 FC 8B 02 8B 4D FC 8B 50 34 FF D2 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_130_0 {
	meta:
		name = "?EnterHyperCriticalRegionHelper@ContextBase@details@Concurrency@@UAEHXZ"
		size = 52
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 0C 83 C1 01 8B 55 FC 89 4A 0C 8B 45 FC 8B 48 10 83 C1 01 89 4D F8 8B 55 FC 8B 45 F8 89 42 10 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_131_0 {
	meta:
		name = "?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
		size = 46
		refs = "000e ?IsUMSScheduler@SchedulerBase@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 1C E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0F 8B 55 FC 8B 02 8B 4D FC 8B 50 38 FF D2 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_132_0 {
	meta:
		name = "?ExitCriticalRegionHelper@ContextBase@details@Concurrency@@UAEHXZ"
		size = 106
		refs = "001a ??_C@_0CO@JBGNEBPL@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 001f ??_C@_0BK@KHDLBAFP@m_criticalRegionCount?5?$DO?50?$AA@ 0024 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 002c ?CurrentContext@Context@Concurrency@@SAPAV12@XZ 0042 ??_C@_0CC@DPOLDNHN@Context?3?3CurrentContext?$CI?$CJ?5?$DN?$DN?5thi@"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 78 0C 00 76 02 EB 17 68 B5 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 3B 45 FC 75 02 EB 17 68 B6 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 8B 51 0C 83 EA 01 89 55 F8 8B 45 FC 8B 4D F8 89 48 0C 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_133_0 {
	meta:
		name = "?ExitHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
		size = 46
		refs = "000e ?IsUMSScheduler@SchedulerBase@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 1C E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0F 8B 55 FC 8B 02 8B 4D FC 8B 50 3C FF D2 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_134_0 {
	meta:
		name = "?ExitHyperCriticalRegionHelper@ContextBase@details@Concurrency@@UAEHXZ"
		size = 120
		refs = "001a ??_C@_0CO@JBGNEBPL@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 001f ??_C@_0BP@KFKOBDFI@m_hyperCriticalRegionCount?5?$DO?50?$AA@ 0024 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 0041 ??_C@_0BK@KHDLBAFP@m_criticalRegionCount?5?$DO?50?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 78 10 00 76 02 EB 17 68 C6 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 83 79 0C 00 76 02 EB 17 68 C7 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 FC 8B 42 0C 83 E8 01 8B 4D FC 89 41 0C 8B 55 FC 8B 42 10 83 E8 01 89 45 F8 8B 4D FC 8B 55 F8 89 51 10 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_135_0 {
	meta:
		name = "?Expire@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEXXZ"
		size = 37
		refs = "0012 ?StaticDelete@Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@SAXPAU1234@@Z 001d ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 51 8B 55 FC 52 68 ?? ?? ?? ?? 8B 4D FC 83 C1 1C E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_83_0 {
	meta:
		name = "?Expire@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEXXZ"
		size = 37
		refs = "0012 ?StaticDelete@Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@SAXPAU1234@@Z 001d ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 51 8B 55 FC 52 68 ?? ?? ?? ?? 8B 4D FC 83 C1 1C E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_136_0 {
	meta:
		name = "?FindAndDelete@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE_NABQAV_TaskCollection@23@PAPAV423@@Z"
		size = 90
		refs = "0014 ?HashValue@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAIABQAV_TaskCollection@23@H@Z 0024 ?Remove@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@ABQAV_TaskCollection@23@H@Z 0047 ?FreeNode@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAXPAUListNode@123@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 50 8B 45 08 50 8B 4D F8 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 21 83 7D 0C 00 74 0B 8B 4D 0C 8B 55 FC 8B 42 08 89 01 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 B0 01 EB 02 32 C0 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_22_137_0 {
	meta:
		name = "?First@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEPAUListNode@123@PAH@Z"
		size = 86
		refs = "000e ??_C@_1O@KGJDCDGG@?$AAx?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0013 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 001f ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0026 __CrtDbgReportW 004c ?NextList@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@PAH@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 83 7D 08 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 F0 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 D0 33 D2 75 CC 8B 45 08 C7 00 00 00 00 00 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_138_0 {
	meta:
		name = "?First@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QBEPAUListEntry@23@XZ"
		size = 44
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 38 00 74 0D 8B 4D FC 8B 11 8B 42 04 89 45 F8 EB 07 C7 45 F8 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_139_0 {
	meta:
		name = "?FlagCancellationBeacons@ContextBase@details@Concurrency@@QAEXH@Z"
		size = 123
		refs = "0013 ?BeaconCount@CancellationBeaconStack@ContextBase@details@Concurrency@@QBEJXZ 0042 ??ACancellationBeaconStack@ContextBase@details@Concurrency@@QAEPAUCancellationBeacon@123@J@Z 006f ?InternalSignal@CancellationBeacon@ContextBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 89 4D F8 8B 4D F8 81 C1 8C 00 00 00 E8 ?? ?? ?? ?? 89 45 EC C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 3B 4D EC 7D 41 8B 55 FC 52 8B 4D F8 81 C1 8C 00 00 00 E8 ?? ?? ?? ?? 89 45 F0 8B 45 F0 8B 48 04 3B 4D 08 7C 1F 8B 55 F8 8B 42 3C 89 45 F4 83 7D F4 FF 74 08 8B 4D F4 3B 4D 08 7F 08 8B 4D F0 E8 ?? ?? ?? ?? EB AE 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_141_0 {
	meta:
		name = "?FreeNode@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAXPAUListNode@123@@Z"
		size = 56
		refs = "000c ?DeleteKey@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAXAAPAV_TaskCollection@23@@Z 001b ?DeleteValue@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAXAAPAV_TaskCollection@23@@Z 002d ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 83 C0 04 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 83 C1 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 89 55 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_680_77_0 {
	meta:
		name = "?FreeNode@?$Hash@II@details@Concurrency@@CAXPAUListNode@123@@Z"
		size = 56
		refs = "000c ?DeleteKey@?$Hash@II@details@Concurrency@@CAXAAI@Z 001b ?DeleteValue@?$Hash@II@details@Concurrency@@CAXAAI@Z 002d ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 83 C0 04 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 83 C1 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 89 55 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_142_0 {
	meta:
		name = "?GetAffinity@ScheduleGroupSegmentBase@details@Concurrency@@IBEABVlocation@3@XZ"
		size = 17
		altNames = "?_Getptr@?$_Ref_count_obj@U?$_Task_impl@E@details@Concurrency@@@std@@QBEPAU?$_Task_impl@E@details@Concurrency@@XZ ?_Getptr@?$_Ref_count_obj@U?$_Task_impl@_N@details@Concurrency@@@std@@QBEPAU?$_Task_impl@_N@details@Concurrency@@XZ ?_Getptr@?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@QBEPAU_ExceptionHolder@details@Concurrency@@XZ ?getEventNode@TimedSingleWaitBlock@details@Concurrency@@QAEPAVEventWaitNode@23@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 C0 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_143_0 {
	meta:
		name = "?GetCriticalRegionType@ContextBase@details@Concurrency@@UBE?AW4CriticalRegionType@3@XZ"
		size = 45
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 78 10 00 76 07 B8 02 00 00 00 EB 12 8B 4D FC 83 79 0C 00 76 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_144_0 {
	meta:
		name = "?GetGroup@ScheduleGroupSegmentBase@details@Concurrency@@QBEPAVScheduleGroupBase@23@XZ"
		size = 20
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 80 00 01 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_145_0 {
	meta:
		name = "?GetId@ContextBase@details@Concurrency@@UBEIXZ"
		size = 17
		altNames = "?GetAnonymousScheduleGroupSegment@SchedulingRing@details@Concurrency@@QBEPAVScheduleGroupSegmentBase@23@XZ ?GetExecutionResourceTls@ThreadProxyFactoryManager@details@Concurrency@@QBEKXZ ?GetSchedulingRing@ScheduleGroupSegmentBase@details@Concurrency@@QBEPAVSchedulingRing@23@XZ ?GetThreadHandle@ThreadProxy@details@Concurrency@@QAEPAXXZ ?Scheduler@SchedulerProxy@details@Concurrency@@QBEPAUIScheduler@3@XZ ?_GetId@location@Concurrency@@QBEIXZ ?_OwningCollection@_UnrealizedChore@details@Concurrency@@QBEPAV_TaskCollectionBase@23@XZ ?_Unchecked@?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@PAX@std@@@std@@@std@@QBEPBQAXXZ ?get@scheduler_ptr@Concurrency@@QBEPAUscheduler_interface@2@XZ ?length@DNameStatusNode@@UBEHXZ ?length@pcharNode@@UBEHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_146_0 {
	meta:
		name = "?GetIndirectAlias@ContextBase@details@Concurrency@@QBEPAV_TaskCollection@23@XZ"
		size = 17
		altNames = "?GetExecutingContext@VirtualProcessor@details@Concurrency@@QAEPAUIExecutionContext@3@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 7C 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_147_0 {
	meta:
		name = "?GetRootCollection@ContextBase@details@Concurrency@@QAEPAV_TaskCollectionBase@23@XZ"
		size = 17
		altNames = "?Id@SchedulingNode@details@Concurrency@@QBEHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 30 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_148_0 {
	meta:
		name = "?GetScheduleGroup@ContextBase@details@Concurrency@@QBEPAVScheduleGroupBase@23@XZ"
		size = 48
		refs = "0019 ?GetGroup@ScheduleGroupSegmentBase@details@Concurrency@@QBEPAVScheduleGroupBase@23@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 78 18 00 74 10 8B 4D FC 8B 49 18 E8 ?? ?? ?? ?? 89 45 F8 EB 07 C7 45 F8 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_149_0 {
	meta:
		name = "?GetScheduleGroupId@ContextBase@details@Concurrency@@UBEIXZ"
		size = 64
		refs = "0019 ?GetGroup@ScheduleGroupSegmentBase@details@Concurrency@@QBEPAVScheduleGroupBase@23@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 83 78 18 00 74 20 8B 4D FC 8B 49 18 E8 ?? ?? ?? ?? 89 45 F8 8B 55 F8 8B 02 8B 4D F8 8B 50 04 FF D2 89 45 F4 EB 07 C7 45 F4 FF FF FF FF 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_150_0 {
	meta:
		name = "?GetScheduleGroupSegment@ContextBase@details@Concurrency@@QBEPAVScheduleGroupSegmentBase@23@XZ"
		size = 17
		altNames = "?GetAvailableNodeCount@ResourceManager@details@Concurrency@@UBEIXZ ?GetPriority@ThreadProxy@details@Concurrency@@QAEHXZ ?LastDataPointCount@MeasuredHistory@HillClimbing@details@Concurrency@@QAEIXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 18 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_151_0 {
	meta:
		name = "?GetScheduler@ContextBase@details@Concurrency@@QBEPAVSchedulerBase@23@XZ"
		size = 17
		altNames = "?GetVirtualProcessorRoot@ExecutionResource@details@Concurrency@@QAEPAVVirtualProcessorRoot@23@XZ ?Id@ScheduleGroupBase@details@Concurrency@@UBEIXZ ?do_frac_digits@?$_Mpunct@D@std@@MBEHXZ ?do_frac_digits@?$_Mpunct@G@std@@MBEHXZ ?do_frac_digits@?$_Mpunct@_W@std@@MBEHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 1C 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_152_0 {
	meta:
		name = "?GetStructuredWorkQueue@ContextBase@details@Concurrency@@QAEPAVWorkQueue@23@XZ"
		size = 34
		refs = "0014 ?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 78 20 00 75 08 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 8B 41 20 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_153_0 {
	meta:
		name = "?GetWorkQueue@ContextBase@details@Concurrency@@QAEPAVWorkQueue@23@XZ"
		size = 34
		refs = "0014 ?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 78 20 00 75 08 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 8B 41 20 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_154_0 {
	meta:
		name = "?Grow@CancellationBeaconStack@ContextBase@details@Concurrency@@AAEXXZ"
		size = 470
		refs = "0006 __ehhandler$?Grow@CancellationBeaconStack@ContextBase@details@Concurrency@@AAEXXZ 0015 ___security_cookie 006f ??_C@_0CO@JBGNEBPL@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 007d ??2@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 0098 ??0CancellationBeaconNode@CancellationBeaconStack@ContextBase@details@Concurrency@@QAE@XZ 011f ??_C@_1BM@JLCCNOPM@?$AAp?$AAN?$AAe?$AAw?$AAN?$AAo?$AAd?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0124 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0130 ??_C@_1FM@EAKMKOMN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0137 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 38 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D E0 C7 45 E4 00 00 00 00 8B 45 E0 8B 48 04 83 E1 F0 C1 F9 04 89 4D EC 83 7D EC 04 0F 8D 87 00 00 00 83 7D EC 00 7E 10 8B 55 E0 8B 42 08 8B 4D EC 8B 54 88 FC 89 55 E4 33 C0 88 45 F3 8D 4D F3 89 4D C8 68 E9 03 00 00 68 ?? ?? ?? ?? 8B 55 C8 0F B6 02 50 6A 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 DC C7 45 FC 00 00 00 00 83 7D DC 00 74 0D 8B 4D DC E8 ?? ?? ?? ?? 89 45 D8 EB 07 C7 45 D8 00 00 00 00 8B 4D D8 89 4D D4 C7 45 FC FF FF FF FF 8B 55 E0 8B 42 08 8B 4D EC 8B 55 D4 89 14 88 8B 45 D4 89 45 E8 E9 DA 00 00 00 B9 04 00 00 00 6B D1 03 8B 45 E0 8B 48 08 8B 14 0A 89 55 E4 8B 45 E4 89 45 E8 8B 4D EC 83 E9 03 89 4D EC 8B 55 EC 89 55 C4 8B 45 EC 83 E8 01 89 45 EC 83 7D C4 00 74 11 8B 4D E8 89 4D E4 8B 55 E8 8B 42 04 89 45 E8 EB DA 83 7D E8 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 F6 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 D0 33 C0 75 CC 33 C9 88 4D F2 8D 55 F2 89 55 C0 68 F7 03 00 00 68 ?? ?? ?? ?? 8B 45 C0 0F B6 08 51 6A 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 D0 C7 45 FC 01 00 00 00 83 7D D0 00 74 0D 8B 4D D0 E8 ?? ?? ?? ?? 89 45 CC EB 07 C7 45 CC 00 00 00 00 8B 55 CC 89 55 BC C7 45 FC FF FF FF FF 8B 45 BC 89 45 E8 83 7D E4 00 74 09 8B 4D E4 8B 55 E8 89 51 04 8B 45 E0 8B 48 04 83 C1 10 8B 55 E0 89 4A 04 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_155_0 {
	meta:
		name = "__unwindfunclet$?Grow@CancellationBeaconStack@ContextBase@details@Concurrency@@AAEXXZ$0"
		size = 30
		refs = "0006 ??_C@_0CO@JBGNEBPL@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0016 ??3@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 68 E9 03 00 00 68 ?? ?? ?? ?? 8B 45 C8 0F B6 00 50 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_22_156_0 {
	meta:
		name = "__unwindfunclet$?Grow@CancellationBeaconStack@ContextBase@details@Concurrency@@AAEXXZ$1"
		size = 30
		refs = "0006 ??_C@_0CO@JBGNEBPL@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0016 ??3@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 68 F7 03 00 00 68 ?? ?? ?? ?? 8B 45 C0 0F B6 00 50 8B 45 D0 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_22_157_0 {
	meta:
		name = "__ehhandler$?Grow@CancellationBeaconStack@ContextBase@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Grow@CancellationBeaconStack@ContextBase@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_151_19_0 {
	meta:
		name = "__ehhandler$??$_Resetp@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@std@@AAEXPAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Resetp@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@std@@AAEXPAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1338_16_0 {
	meta:
		name = "__ehhandler$??0SchedulerProxy@details@Concurrency@@QAE@PAUIScheduler@2@PAVResourceManager@12@ABVSchedulerPolicy@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0SchedulerProxy@details@Concurrency@@QAE@PAUIScheduler@2@PAVResourceManager@12@ABVSchedulerPolicy@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1099_35_0 {
	meta:
		name = "__ehhandler$??0UMSFreeThreadProxyFactory@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0UMSFreeThreadProxyFactory@details@Concurrency@@IAE@PAVThreadProxyFactoryManager@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_149_79_0 {
	meta:
		name = "__ehhandler$?AddToRunnables@InternalContextBase@details@Concurrency@@MAEXVlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddToRunnables@InternalContextBase@details@Concurrency@@MAEXVlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_149_96_0 {
	meta:
		name = "__ehhandler$?Dispatch@InternalContextBase@details@Concurrency@@UAEXPAUDispatchState@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Dispatch@InternalContextBase@details@Concurrency@@UAEXPAUDispatchState@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_149_183_0 {
	meta:
		name = "__ehhandler$?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_1043_1 {
	meta:
		name = "__ehhandler$?_CancelInternal@?$task_completion_event@E@Concurrency@@ABE_NXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CancelInternal@?$task_completion_event@E@Concurrency@@ABE_NXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_1047_1 {
	meta:
		name = "__ehhandler$?_CancelInternal@?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@ABE_NXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CancelInternal@?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@ABE_NXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1094_55_0 {
	meta:
		name = "__ehhandler$?_RaisedException@_TaskCollectionBase@details@Concurrency@@IAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RaisedException@_TaskCollectionBase@details@Concurrency@@IAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_1065_1 {
	meta:
		name = "__ehhandler$?_To_array@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@AAEXAAV?$_Dynamic_array@PAV?$ISource@I@Concurrency@@@details@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_To_array@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@AAEXAAV?$_Dynamic_array@PAV?$ISource@I@Concurrency@@@details@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_1068_1 {
	meta:
		name = "__ehhandler$?_To_array@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@AAEXAAV?$_Dynamic_array@PAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_To_array@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@AAEXAAV?$_Dynamic_array@PAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_1310_2 {
	meta:
		name = "__ehhandler$?release@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXHPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXHPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_1313_2 {
	meta:
		name = "__ehhandler$?release@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXHPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXHPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_1316_1 {
	meta:
		name = "__ehhandler$?release@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXHPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXHPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_1542_1 {
	meta:
		name = "__ehhandler$?set@?$task_completion_event@E@Concurrency@@QBE_NE@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?set@?$task_completion_event@E@Concurrency@@QBE_NE@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A C4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_158_0 {
	meta:
		name = "?GrowAndPush@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEXPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
		size = 633
		refs = "0006 __ehhandler$?GrowAndPush@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEXPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z 0016 ___security_cookie 0041 ??_C@_0DO@PDCHCLMC@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 005f ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 00c7 ??0Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ 00d6 ??_H@YGXPAXIHP6EPAX0@Z@Z 0110 ??0_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 0130 ?Count@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QBEHXZ 018f ??4Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEAAV0123@ABV0123@@Z 01ac _memset 01e4 ?IsEmpty@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QBE_NXZ 023f ??1_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@XZ 024e ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 50 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 8B 45 EC 8B 48 08 8D 54 09 02 89 55 E0 33 C0 88 45 F3 68 63 01 00 00 68 ?? ?? ?? ?? 0F B6 4D F3 51 33 C9 8B 45 E0 BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 C0 8B 45 C0 89 45 D4 8B 4D EC 8B 51 0C 89 55 B0 8B 45 E0 89 45 D0 33 C9 88 4D F2 8D 55 F2 89 55 BC 68 66 01 00 00 68 ?? ?? ?? ?? 8B 45 BC 0F B6 08 51 33 C9 8B 45 D0 BA 08 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 D8 C7 45 FC 00 00 00 00 83 7D D8 00 74 1C 68 ?? ?? ?? ?? 8B 45 D0 50 6A 08 8B 4D D8 51 E8 ?? ?? ?? ?? 8B 55 D8 89 55 CC EB 07 C7 45 CC 00 00 00 00 8B 45 CC 89 45 B8 C7 45 FC FF FF FF FF 8B 4D B8 89 4D C4 8B 55 EC 8B 42 10 89 45 A8 8B 4D EC 8B 51 14 52 8D 4D B4 E8 ?? ?? ?? ?? C7 45 FC 01 00 00 00 8B 45 EC 8B 48 04 89 4D DC 8B 55 EC 8B 02 89 45 C8 8B 4D EC E8 ?? ?? ?? ?? 89 45 E4 C7 45 E8 00 00 00 00 EB 09 8B 4D E8 83 C1 01 89 4D E8 8B 55 E8 3B 55 E4 7D 44 8B 45 E8 03 45 C8 8B 4D EC 23 41 08 8B 55 EC 8B 4A 0C 8B 55 E8 8B 75 D4 8B 04 81 89 04 96 8B 4D E8 03 4D C8 8B 55 EC 23 4A 08 8B 45 EC 8B 50 10 8D 04 CA 50 8B 4D E8 8B 55 C4 8D 0C CA E8 ?? ?? ?? ?? EB AB 8B 45 E0 2B 45 E4 C1 E0 02 50 6A 00 8B 4D E4 8B 55 D4 8D 04 8A 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D EC 8B 55 D4 89 51 0C 8B 45 EC 8B 4D C4 89 48 10 8B 55 EC C7 02 00 00 00 00 8B 45 E4 89 45 DC 8B 4D E0 83 E9 01 8B 55 EC 89 4A 08 8D 4D 0C E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 24 8D 4D 0C 51 8B 55 EC 8B 45 DC 23 42 08 8B 4D EC 8B 51 10 8D 0C C2 E8 ?? ?? ?? ?? 8B 45 08 83 C8 01 89 45 08 8B 4D EC 8B 55 DC 23 51 08 8B 45 EC 8B 48 0C 8B 45 08 89 04 91 8B 4D DC 83 C1 01 8B 55 EC 89 4A 04 C7 45 FC FF FF FF FF 8D 4D B4 E8 ?? ?? ?? ?? 8B 45 B0 89 45 AC 8B 4D AC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 A8 89 55 A4 8B 45 A4 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_149_125_0 {
	meta:
		name = "?GrowAndPush@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@AAEXPAVInternalContextBase@23@VSlot@?$Mailbox@VInternalContextBase@details@Concurrency@@@23@@Z"
		size = 633
		refs = "0006 __ehhandler$?GrowAndPush@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@AAEXPAVInternalContextBase@23@VSlot@?$Mailbox@VInternalContextBase@details@Concurrency@@@23@@Z 0016 ___security_cookie 0041 ??_C@_0DO@PDCHCLMC@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 005f ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 00c7 ??0Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE@XZ 00d6 ??_H@YGXPAXIHP6EPAX0@Z@Z 0110 ??0_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 0130 ?Count@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QBEHXZ 018f ??4Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEAAV0123@ABV0123@@Z 01ac _memset 01e4 ?IsEmpty@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QBE_NXZ 023f ??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@XZ 024e ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 50 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 8B 45 EC 8B 48 08 8D 54 09 02 89 55 E0 33 C0 88 45 F3 68 63 01 00 00 68 ?? ?? ?? ?? 0F B6 4D F3 51 33 C9 8B 45 E0 BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 C0 8B 45 C0 89 45 D4 8B 4D EC 8B 51 0C 89 55 B0 8B 45 E0 89 45 D0 33 C9 88 4D F2 8D 55 F2 89 55 BC 68 66 01 00 00 68 ?? ?? ?? ?? 8B 45 BC 0F B6 08 51 33 C9 8B 45 D0 BA 08 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 D8 C7 45 FC 00 00 00 00 83 7D D8 00 74 1C 68 ?? ?? ?? ?? 8B 45 D0 50 6A 08 8B 4D D8 51 E8 ?? ?? ?? ?? 8B 55 D8 89 55 CC EB 07 C7 45 CC 00 00 00 00 8B 45 CC 89 45 B8 C7 45 FC FF FF FF FF 8B 4D B8 89 4D C4 8B 55 EC 8B 42 10 89 45 A8 8B 4D EC 8B 51 14 52 8D 4D B4 E8 ?? ?? ?? ?? C7 45 FC 01 00 00 00 8B 45 EC 8B 48 04 89 4D DC 8B 55 EC 8B 02 89 45 C8 8B 4D EC E8 ?? ?? ?? ?? 89 45 E4 C7 45 E8 00 00 00 00 EB 09 8B 4D E8 83 C1 01 89 4D E8 8B 55 E8 3B 55 E4 7D 44 8B 45 E8 03 45 C8 8B 4D EC 23 41 08 8B 55 EC 8B 4A 0C 8B 55 E8 8B 75 D4 8B 04 81 89 04 96 8B 4D E8 03 4D C8 8B 55 EC 23 4A 08 8B 45 EC 8B 50 10 8D 04 CA 50 8B 4D E8 8B 55 C4 8D 0C CA E8 ?? ?? ?? ?? EB AB 8B 45 E0 2B 45 E4 C1 E0 02 50 6A 00 8B 4D E4 8B 55 D4 8D 04 8A 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D EC 8B 55 D4 89 51 0C 8B 45 EC 8B 4D C4 89 48 10 8B 55 EC C7 02 00 00 00 00 8B 45 E4 89 45 DC 8B 4D E0 83 E9 01 8B 55 EC 89 4A 08 8D 4D 0C E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 24 8D 4D 0C 51 8B 55 EC 8B 45 DC 23 42 08 8B 4D EC 8B 51 10 8D 0C C2 E8 ?? ?? ?? ?? 8B 45 08 83 C8 01 89 45 08 8B 4D EC 8B 55 DC 23 51 08 8B 45 EC 8B 48 0C 8B 45 08 89 04 91 8B 4D DC 83 C1 01 8B 55 EC 89 4A 04 C7 45 FC FF FF FF FF 8D 4D B4 E8 ?? ?? ?? ?? 8B 45 B0 89 45 AC 8B 4D AC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 A8 89 55 A4 8B 45 A4 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_22_159_0 {
	meta:
		name = "__unwindfunclet$?GrowAndPush@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEXPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z$0"
		size = 30
		refs = "0006 ??_C@_0DO@PDCHCLMC@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0016 ??_V@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
		altNames = "__unwindfunclet$?GrowAndPush@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@AAEXPAVInternalContextBase@23@VSlot@?$Mailbox@VInternalContextBase@details@Concurrency@@@23@@Z$0"
	strings:
		$1 = { 68 66 01 00 00 68 ?? ?? ?? ?? 8B 45 BC 0F B6 00 50 8B 45 D8 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_22_161_0 {
	meta:
		name = "__ehhandler$?GrowAndPush@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEXPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GrowAndPush@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEXPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_149_128_0 {
	meta:
		name = "__ehhandler$?GrowAndPush@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@AAEXPAVInternalContextBase@23@VSlot@?$Mailbox@VInternalContextBase@details@Concurrency@@@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GrowAndPush@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@AAEXPAVInternalContextBase@23@VSlot@?$Mailbox@VInternalContextBase@details@Concurrency@@@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_212_0 {
	meta:
		name = "__ehhandler$?LocateSegment@ScheduleGroupBase@details@Concurrency@@UAEPAVScheduleGroupSegmentBase@23@PAVlocation@3@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?LocateSegment@ScheduleGroupBase@details@Concurrency@@UAEPAVScheduleGroupSegmentBase@23@PAVlocation@3@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_1118_2 {
	meta:
		name = "__ehhandler$?_CancelInternal@?$task_completion_event@E@Concurrency@@ABE_NXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CancelInternal@?$task_completion_event@E@Concurrency@@ABE_NXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_1124_2 {
	meta:
		name = "__ehhandler$?_CancelInternal@?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@ABE_NXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CancelInternal@?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@ABE_NXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_96_1 {
	meta:
		name = "__ehhandler$?_Push@_Micro_queue@details@Concurrency@@QAEXPAXIAAV_Concurrent_queue_base_v4@23@P8423@AEXAAU_Page@423@I0@Z@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Push@_Micro_queue@details@Concurrency@@QAEXPAXIAAV_Concurrent_queue_base_v4@23@P8423@AEXAAU_Page@423@I0@Z@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_1630_2 {
	meta:
		name = "__ehhandler$?set@?$task_completion_event@E@Concurrency@@QBE_NE@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?set@?$task_completion_event@E@Concurrency@@QBE_NE@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_162_143_0 {
	meta:
		name = "__ehhandler$?set@event@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?set@event@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_162_150_0 {
	meta:
		name = "__ehhandler$?wait@event@Concurrency@@QAEII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?wait@event@Concurrency@@QAEII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_162_0 {
	meta:
		name = "?HasAnyCancellation@ContextBase@details@Concurrency@@QBE_NXZ"
		size = 48
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 78 8B 55 FC 03 4A 70 85 C9 7E 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8A 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_163_0 {
	meta:
		name = "?HasInlineCancellation@ContextBase@details@Concurrency@@QBE_NXZ"
		size = 41
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 83 78 70 00 7E 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_164_0 {
	meta:
		name = "?HasPendingCancellation@ContextBase@details@Concurrency@@QBE_NXZ"
		size = 41
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 83 78 78 00 7E 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_165_0 {
	meta:
		name = "?HasVirtualProcessorAvailableForNewWork@SchedulerBase@details@Concurrency@@QBE_NXZ"
		size = 54
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 88 B4 01 00 00 8B 55 FC 2B 8A B8 01 00 00 85 C9 7E 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8A 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_166_0 {
	meta:
		name = "?HashValue@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAIABQAV_TaskCollection@23@H@Z"
		size = 144
		refs = "0055 ??_C@_1BK@FGMEFJOD@?$AAt?$AAh?$AAe?$AA_?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 005a ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0066 ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 006d __CrtDbgReportW"
		altNames = "?HashValue@?$Hash@II@details@Concurrency@@CAIABIH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 C7 45 F4 C5 9D 1C 81 C7 45 F0 93 01 00 01 C7 45 FC C5 9D 1C 81 C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 83 7D F8 04 73 1B 8B 4D 08 03 4D F8 0F B6 11 33 55 FC 89 55 FC 69 45 FC 93 01 00 01 89 45 FC EB D6 83 7D 0C 00 7F 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 D2 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 D0 33 C0 75 CC 8B 45 FC 33 D2 F7 75 0C 8B C2 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_168_0 {
	meta:
		name = "?IncrementEnqueuedTaskCounter@ExternalContextBase@details@Concurrency@@QAEXXZ"
		size = 25
		refs = "0011 ?IncrementEnqueuedTaskCounter@ExternalStatistics@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 88 9C 00 00 00 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_686_122_0 {
	meta:
		name = "?IncrementDequeuedTaskCounter@ExternalContextBase@details@Concurrency@@QAEXXZ"
		size = 25
		refs = "0011 ?IncrementDequeuedTaskCounter@ExternalStatistics@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 88 9C 00 00 00 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_169_0 {
	meta:
		name = "?IncrementEnqueuedTaskCounter@ExternalStatistics@details@Concurrency@@QAEXXZ"
		size = 26
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 48 08 83 C1 01 8B 55 FC 89 4A 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_170_0 {
	meta:
		name = "?IncrementEnqueuedTaskCounter@InternalContextBase@details@Concurrency@@QAEXXZ"
		size = 68
		refs = "0010 ?IsUMSScheduler@SchedulerBase@details@Concurrency@@QBE_NXZ 001f ?IncrementEnqueuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QAEXXZ 0029 ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 20 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0A 8B 4D FC E8 ?? ?? ?? ?? EB 1B 8B 4D FC E8 ?? ?? ?? ?? 83 C0 68 89 45 F8 8B 55 F8 8B 02 83 C0 01 8B 4D F8 89 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_171_0 {
	meta:
		name = "?InternalSignal@CancellationBeacon@ContextBase@details@Concurrency@@QAEXXZ"
		size = 19
		refs = "000b ?Raise@CancellationBeacon@ContextBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_513_2 {
	meta:
		name = "??1?$_Dynamic_array@PAV?$ISource@I@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ?_Clear@?$_Dynamic_array@PAV?$ISource@I@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_514_2 {
	meta:
		name = "??1?$_Dynamic_array@PAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ?_Clear@?$_Dynamic_array@PAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_515_1 {
	meta:
		name = "??1?$_Dynamic_array@PAV?$ITarget@I@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ?_Clear@?$_Dynamic_array@PAV?$ITarget@I@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_516_2 {
	meta:
		name = "??1?$_Dynamic_array@PAV?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ?_Clear@?$_Dynamic_array@PAV?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_725_1 {
	meta:
		name = "??1?$_Func_class@EV?$task@_N@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@EV?$task@_N@Concurrency@@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_726_1 {
	meta:
		name = "??1?$_Func_class@V?$task@_N@Concurrency@@$$$V@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@V?$task@_N@Concurrency@@$$$V@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_777_2 {
	meta:
		name = "??1?$_Func_class@V?$task@_N@Concurrency@@_N@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@V?$task@_N@Concurrency@@_N@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_521_3 {
	meta:
		name = "??1?$_Func_class@X$$$V@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@X$$$V@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_522_2 {
	meta:
		name = "??1?$_Func_class@XABI@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@XABI@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_729_1 {
	meta:
		name = "??1?$_Func_class@XE@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@XE@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_523_1 {
	meta:
		name = "??1?$_Func_class@XPAV?$message@I@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@XPAV?$message@I@Concurrency@@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_524_3 {
	meta:
		name = "??1?$_Func_class@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@XPAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_730_1 {
	meta:
		name = "??1?$_Func_class@XU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@XU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_790_3 {
	meta:
		name = "??1?$_Func_class@XV?$task@X@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@XV?$task@X@Concurrency@@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_782_2 {
	meta:
		name = "??1?$_Func_class@XV?$task@_N@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@XV?$task@_N@Concurrency@@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_525_3 {
	meta:
		name = "??1?$_Func_class@_NABI@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@_NABI@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_526_3 {
	meta:
		name = "??1?$_Func_class@_NABW4agent_status@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Func_class@_NABW4agent_status@Concurrency@@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_76_176_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_13_429_3 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_790_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@PAXHPBQAXABQAXU_Iterator_base12@2@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_791_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@HPBV32@ABV32@U_Iterator_base12@2@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_801_3 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@HPBV32@ABV32@U_Iterator_base12@2@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_396_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_151_56_0 {
	meta:
		name = "??1?$_Ref_count@V__ExceptionPtr@@@std@@UAE@XZ"
		size = 19
		refs = "000b ??1_Ref_count_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_748_1 {
	meta:
		name = "??1?$_Ref_count_obj@U?$_Task_impl@E@details@Concurrency@@@std@@UAE@XZ"
		size = 19
		refs = "000b ??1_Ref_count_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_749_1 {
	meta:
		name = "??1?$_Ref_count_obj@U?$_Task_impl@_N@details@Concurrency@@@std@@UAE@XZ"
		size = 19
		refs = "000b ??1_Ref_count_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_803_2 {
	meta:
		name = "??1?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@UAE@XZ"
		size = 19
		refs = "000b ??1_Ref_count_base@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_804_2 {
	meta:
		name = "??1?$_RunAllParam@E@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ??1?$task_completion_event@E@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_118_2 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_402_2 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_68_2 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_55_119_2 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_13_438_3 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_405_2 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_137_3 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@D@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Container_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_13_441_3 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@G@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Container_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_408_2 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@_W@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Container_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_829_3 {
	meta:
		name = "??1?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@PAX@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Iterator012@Urandom_access_iterator_tag@std@@PAXHPBQAXABQAXU_Iterator_base12@2@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_821_2 {
	meta:
		name = "??1?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@HPBV32@ABV32@U_Iterator_base12@2@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_822_2 {
	meta:
		name = "??1?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@HPBV32@ABV32@U_Iterator_base12@2@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_823_2 {
	meta:
		name = "??1?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_824_2 {
	meta:
		name = "??1?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_825_2 {
	meta:
		name = "??1?$_Vector_val@U?$_Simple_types@PAX@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Container_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_826_2 {
	meta:
		name = "??1?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Container_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_827_2 {
	meta:
		name = "??1?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ??1_Container_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_93_1 {
	meta:
		name = "??1?$_Yarn@D@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Yarn@D@std@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_94_1 {
	meta:
		name = "??1?$_Yarn@_W@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$_Yarn@_W@std@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_768_1 {
	meta:
		name = "??1?$shared_ptr@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Decref@?$_Ptr_base@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_769_1 {
	meta:
		name = "??1?$shared_ptr@U?$_Task_completion_event_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Decref@?$_Ptr_base@U?$_Task_completion_event_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_770_1 {
	meta:
		name = "??1?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Decref@?$_Ptr_base@U?$_Task_impl@E@details@Concurrency@@@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_846_3 {
	meta:
		name = "??1?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Decref@?$_Ptr_base@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_772_1 {
	meta:
		name = "??1?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Decref@?$_Ptr_base@U?$_Task_impl@_N@details@Concurrency@@@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_848_3 {
	meta:
		name = "??1?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Decref@?$_Ptr_base@U_ExceptionHolder@details@Concurrency@@@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_774_1 {
	meta:
		name = "??1?$shared_ptr@U_Task_impl_base@details@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Decref@?$_Ptr_base@U_Task_impl_base@details@Concurrency@@@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_775_1 {
	meta:
		name = "??1?$shared_ptr@Uscheduler_interface@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Decref@?$_Ptr_base@Uscheduler_interface@Concurrency@@@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_151_60_0 {
	meta:
		name = "??1?$shared_ptr@V__ExceptionPtr@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Decref@?$_Ptr_base@V__ExceptionPtr@@@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_842_2 {
	meta:
		name = "??1?$task@E@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ??1?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_843_2 {
	meta:
		name = "??1?$task@X@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ??1?$task@E@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_853_3 {
	meta:
		name = "??1?$task@_N@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ??1?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_845_2 {
	meta:
		name = "??1?$task_completion_event@E@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ??1?$shared_ptr@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_780_1 {
	meta:
		name = "??1?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ??1?$shared_ptr@U?$_Task_completion_event_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_781_1 {
	meta:
		name = "??1?$vector@PAXV?$allocator@PAX@std@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$vector@PAXV?$allocator@PAX@std@@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_782_1 {
	meta:
		name = "??1?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_783_1 {
	meta:
		name = "??1?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Tidy@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_859_3 {
	meta:
		name = "??1?$weak_ptr@U_Task_impl_base@details@Concurrency@@@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Decwref@?$_Ptr_base@U_Task_impl_base@details@Concurrency@@@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_764_99_0 {
	meta:
		name = "??1CacheLocalScheduleGroup@details@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1ScheduleGroupBase@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_764_100_0 {
	meta:
		name = "??1CacheLocalScheduleGroupSegment@details@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1372_21_0 {
	meta:
		name = "??1CancellationTokenRegistration_TaskProc@details@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1_CancellationTokenRegistration@details@Concurrency@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_764_101_0 {
	meta:
		name = "??1FairScheduleGroup@details@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1ScheduleGroupBase@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_764_102_0 {
	meta:
		name = "??1FairScheduleGroupSegment@details@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1ScheduleGroupSegmentBase@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_517_22_0 {
	meta:
		name = "??1FreeVirtualProcessorRoot@details@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1VirtualProcessorRoot@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_764_108_0 {
	meta:
		name = "??1RealizedChore@details@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1_Chore@details@Concurrency@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1142_19_0 {
	meta:
		name = "??1TimerObj@?6??wait@Concurrency@@YAXI@Z@UAE@XZ"
		size = 19
		refs = "000b ??1_Timer@details@Concurrency@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_26_51_3 {
	meta:
		name = "??1_Container_base12@std@@QAE@XZ"
		size = 19
		refs = "000b ?_Orphan_all@_Container_base12@std@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_869_3 {
	meta:
		name = "??1_Future_error_category@std@@UAE@XZ"
		size = 19
		refs = "000b ??1_Generic_error_category@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_51_79_3 {
	meta:
		name = "??1_Generic_error_category@std@@UAE@XZ"
		size = 19
		refs = "000b ??1error_category@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_686_56_0 {
	meta:
		name = "??1_Interruption_exception@details@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_105_150_3 {
	meta:
		name = "??1_Iostream_error_category@std@@UAE@XZ"
		size = 19
		refs = "000b ??1_Generic_error_category@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_674_3 {
	meta:
		name = "??1_NonReentrantPPLLock@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ??1critical_section@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_675_3 {
	meta:
		name = "??1_ReentrantPPLLock@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ??1critical_section@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_142_3 {
	meta:
		name = "??1_System_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_107_41_2 {
	meta:
		name = "??1_System_error_category@std@@UAE@XZ"
		size = 19
		refs = "000b ??1_Generic_error_category@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_809_1 {
	meta:
		name = "??1_TaskProcThunk@details@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ??1?$function@$$A6AXXZ@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_108_62_3 {
	meta:
		name = "??1bad_function_call@std@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_679_3 {
	meta:
		name = "??1bad_target@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_895_3 {
	meta:
		name = "??1bad_weak_ptr@std@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_887_2 {
	meta:
		name = "??1cancellation_token@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ?_Clear@cancellation_token@Concurrency@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_820_1 {
	meta:
		name = "??1cancellation_token_registration@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ?_Clear@cancellation_token_registration@Concurrency@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_611_36_0 {
	meta:
		name = "??1context_self_unblock@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_67_0 {
	meta:
		name = "??1context_unblock_unbalanced@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_764_135_0 {
	meta:
		name = "??1default_scheduler_exists@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_93_159_3 {
	meta:
		name = "??1failure@ios_base@std@@UAE@XZ"
		size = 19
		refs = "000b ??1system_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_892_2 {
	meta:
		name = "??1future_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1logic_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_69_0 {
	meta:
		name = "??1improper_lock@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_70_0 {
	meta:
		name = "??1improper_scheduler_attach@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_764_137_0 {
	meta:
		name = "??1improper_scheduler_detach@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_72_0 {
	meta:
		name = "??1improper_scheduler_reference@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_149_46_0 {
	meta:
		name = "??1invalid_argument@std@@UAE@XZ"
		size = 19
		refs = "000b ??1logic_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_681_3 {
	meta:
		name = "??1invalid_link_target@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_74_0 {
	meta:
		name = "??1invalid_multiple_scheduling@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_517_27_0 {
	meta:
		name = "??1invalid_operation@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_611_38_0 {
	meta:
		name = "??1invalid_oversubscribe_operation@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1193_21_0 {
	meta:
		name = "??1invalid_scheduler_policy_key@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_78_0 {
	meta:
		name = "??1invalid_scheduler_policy_thread_specification@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_79_0 {
	meta:
		name = "??1invalid_scheduler_policy_value@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_108_65_3 {
	meta:
		name = "??1length_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1logic_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_60_48_2 {
	meta:
		name = "??1lock_error@threads@stdext@@UAE@XZ"
		size = 19
		refs = "000b ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_101_84_2 {
	meta:
		name = "??1logic_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_684_2 {
	meta:
		name = "??1message_not_found@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_71_219_3 {
	meta:
		name = "??1messages_base@std@@UAE@XZ"
		size = 19
		refs = "000b ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_81_0 {
	meta:
		name = "??1missing_wait@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_76_207_2 {
	meta:
		name = "??1money_base@std@@UAE@XZ"
		size = 19
		refs = "000b ??1facet@locale@std@@MAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_82_0 {
	meta:
		name = "??1nested_scheduler_missing_detach@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_685_2 {
	meta:
		name = "??1operation_timed_out@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_14_69_1 {
	meta:
		name = "??1out_of_range@std@@UAE@XZ"
		size = 19
		refs = "000b ??1logic_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_108_68_3 {
	meta:
		name = "??1overflow_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_14_70_1 {
	meta:
		name = "??1range_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_87_52_1 {
	meta:
		name = "??1regex_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_71_2 {
	meta:
		name = "??1runtime_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_84_0 {
	meta:
		name = "??1scheduler_not_attached@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_896_2 {
	meta:
		name = "??1scheduler_ptr@Concurrency@@QAE@XZ"
		size = 19
		refs = "000b ??1?$shared_ptr@Uscheduler_interface@Concurrency@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_611_39_0 {
	meta:
		name = "??1scheduler_resource_allocation_error@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_86_0 {
	meta:
		name = "??1scheduler_worker_creation_error@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1scheduler_resource_allocation_error@Concurrency@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_63_163_3 {
	meta:
		name = "??1system_error@std@@UAE@XZ"
		size = 19
		refs = "000b ??1_System_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_87_0 {
	meta:
		name = "??1task_canceled@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_74_34_1 {
	meta:
		name = "??1thread_resource_error@threads@stdext@@UAE@XZ"
		size = 19
		refs = "000b ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_744_57_0 {
	meta:
		name = "??1unsupported_os@Concurrency@@UAE@XZ"
		size = 19
		refs = "000b ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_872_1 {
	meta:
		name = "??C?$shared_ptr@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QBEPAU?$_Task_completion_event_impl@E@details@Concurrency@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QBEPAU?$_Task_completion_event_impl@E@details@Concurrency@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_953_3 {
	meta:
		name = "??C?$shared_ptr@U?$_Task_completion_event_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QBEPAU?$_Task_completion_event_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@U?$_Task_completion_event_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QBEPAU?$_Task_completion_event_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_954_3 {
	meta:
		name = "??C?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QBEPAU?$_Task_impl@E@details@Concurrency@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@U?$_Task_impl@E@details@Concurrency@@@std@@QBEPAU?$_Task_impl@E@details@Concurrency@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_955_3 {
	meta:
		name = "??C?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QBEPAU?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QBEPAU?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_945_2 {
	meta:
		name = "??C?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@std@@QBEPAU?$_Task_impl@_N@details@Concurrency@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@U?$_Task_impl@_N@details@Concurrency@@@std@@QBEPAU?$_Task_impl@_N@details@Concurrency@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_946_2 {
	meta:
		name = "??C?$shared_ptr@U_Task_impl_base@details@Concurrency@@@std@@QBEPAU_Task_impl_base@details@Concurrency@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@U_Task_impl_base@details@Concurrency@@@std@@QBEPAU_Task_impl_base@details@Concurrency@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_151_72_0 {
	meta:
		name = "??C?$shared_ptr@V__ExceptionPtr@@@std@@QBEPAV__ExceptionPtr@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@V__ExceptionPtr@@@std@@QBEPAV__ExceptionPtr@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_947_2 {
	meta:
		name = "??Cscheduler_ptr@Concurrency@@QBEPAUscheduler_interface@1@XZ"
		size = 19
		refs = "000b ?get@scheduler_ptr@Concurrency@@QBEPAUscheduler_interface@2@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_157_2 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEAADXZ"
		size = 19
		refs = "000b ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEABDXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_13_527_3 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBEAAGXZ"
		size = 19
		refs = "000b ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBEABGXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_85_2 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBEAA_WXZ"
		size = 19
		refs = "000b ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBEAB_WXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_950_2 {
	meta:
		name = "??D?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QBEAAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@1@XZ"
		size = 19
		refs = "000b ??D?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QBEABV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@1@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_951_2 {
	meta:
		name = "??D?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QBEAAV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@1@XZ"
		size = 19
		refs = "000b ??D?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QBEABV?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@1@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1338_67_0 {
	meta:
		name = "?Count@?$List@VExecutionResource@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QBEHXZ"
		size = 19
		refs = "000b ?Value@Count@CollectionTypes@details@Concurrency@@QBEHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_162_72_0 {
	meta:
		name = "?Destroy@WaitAllBlock@details@Concurrency@@UAEXXZ"
		size = 19
		refs = "000b ?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_764_363_0 {
	meta:
		name = "?InitializeSchedulerEventHandlers@SchedulerBase@details@Concurrency@@MAEXXZ"
		size = 19
		refs = "000b ?IncrementInternalContextCount@SchedulerBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_173_204_0 {
	meta:
		name = "?IsStructuredEmpty@WorkQueue@details@Concurrency@@QBE_NXZ"
		size = 19
		refs = "000b ?Empty@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_194_0 {
	meta:
		name = "?PopStructured@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ"
		size = 19
		refs = "000b ?Pop@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_173_223_0 {
	meta:
		name = "?Reference@ScheduleGroupBase@details@Concurrency@@UAEIXZ"
		size = 19
		refs = "000b ?InternalReference@ScheduleGroupBase@details@Concurrency@@IAEJXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_173_224_0 {
	meta:
		name = "?Release@ScheduleGroupBase@details@Concurrency@@UAEIXZ"
		size = 19
		refs = "000b ?InternalRelease@ScheduleGroupBase@details@Concurrency@@IAEJXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_744_271_0 {
	meta:
		name = "?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ"
		size = 19
		refs = "000b ?_DebugAcquire@_NonReentrantLock@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_1110_3 {
	meta:
		name = "?_Cancel@?$task_completion_event@E@Concurrency@@QBE_NXZ"
		size = 19
		refs = "000b ?_CancelInternal@?$task_completion_event@E@Concurrency@@ABE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_1024_1 {
	meta:
		name = "?_Cancel@?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@QBE_NXZ"
		size = 19
		refs = "000b ?_CancelInternal@?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@ABE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_273_0 {
	meta:
		name = "?_IsLockHeld@_CriticalNonReentrantLock@details@Concurrency@@QBE_NXZ"
		size = 19
		refs = "000b ?_IsLockHeld@_NonReentrantLock@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_686_216_0 {
	meta:
		name = "?_NotificationHandler@_AsyncTaskCollection@details@Concurrency@@AAEXXZ"
		size = 19
		refs = "000b ?_Release@_RefCounterBase@details@Concurrency@@QAEJXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_429_123_0 {
	meta:
		name = "?_Release@_NonReentrantPPLLock@details@Concurrency@@QAEXXZ"
		size = 19
		refs = "000b ?unlock@critical_section@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_1372_1 {
	meta:
		name = "?_SetScheduled@_TaskCollectionImpl@details@Concurrency@@AAEXXZ"
		size = 19
		refs = "000b ?set@event@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_922_76_0 {
	meta:
		name = "?_TryAcquire@_NonReentrantLock@details@Concurrency@@QAE_NXZ"
		size = 19
		refs = "000b ?_DebugTryAcquire@_NonReentrantLock@details@Concurrency@@AAE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_25_279_2 {
	meta:
		name = "?c_str@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEPBDXZ"
		size = 19
		refs = "000b ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QBEPBDXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_1099_2 {
	meta:
		name = "?c_str@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEPBGXZ"
		size = 19
		refs = "000b ?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QBEPBGXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_1100_2 {
	meta:
		name = "?c_str@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEPB_WXZ"
		size = 19
		refs = "000b ?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QBEPB_WXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_1183_1 {
	meta:
		name = "?count@?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@UAEIXZ"
		size = 19
		refs = "000b ?_Count@?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@ABEIXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_1184_1 {
	meta:
		name = "?count@?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEIXZ"
		size = 19
		refs = "000b ?_Count@?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@ABEIXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_1185_1 {
	meta:
		name = "?count@?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAEIXZ"
		size = 19
		refs = "000b ?_Count@?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@ABEIXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_1186_1 {
	meta:
		name = "?count@?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEIXZ"
		size = 19
		refs = "000b ?_Count@?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@ABEIXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_1207_1 {
	meta:
		name = "?empty@?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@QBE_NXZ"
		size = 19
		refs = "000b ?_Internal_empty@_Concurrent_queue_base_v4@details@Concurrency@@IBE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_1208_3 {
	meta:
		name = "?empty@?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@QBE_NXZ"
		size = 19
		refs = "000b ?_Internal_empty@_Concurrent_queue_base_v4@details@Concurrency@@IBE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_1592_3 {
	meta:
		name = "?get@?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@QBEPAU_ExceptionHolder@details@Concurrency@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@U_ExceptionHolder@details@Concurrency@@@std@@QBEPAU_ExceptionHolder@details@Concurrency@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_1593_3 {
	meta:
		name = "?get@?$shared_ptr@U_Task_impl_base@details@Concurrency@@@std@@QBEPAU_Task_impl_base@details@Concurrency@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@U_Task_impl_base@details@Concurrency@@@std@@QBEPAU_Task_impl_base@details@Concurrency@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_1594_3 {
	meta:
		name = "?get@?$shared_ptr@Uscheduler_interface@Concurrency@@@std@@QBEPAUscheduler_interface@Concurrency@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@Uscheduler_interface@Concurrency@@@std@@QBEPAUscheduler_interface@Concurrency@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_151_151_0 {
	meta:
		name = "?get@?$shared_ptr@V__ExceptionPtr@@@std@@QBEPAV__ExceptionPtr@@XZ"
		size = 19
		refs = "000b ?_Get@?$_Ptr_base@V__ExceptionPtr@@@std@@QBEPAV__ExceptionPtr@@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_172_0 {
	meta:
		name = "?IsCanceledAtDepth@ContextBase@details@Concurrency@@AAE_NPAV_TaskCollectionBase@23@H@Z"
		size = 474
		refs = "001b ??_C@_1FO@DGGHNLOD@?$AAp?$AAS?$AAt?$AAa?$AAr?$AAt?$AAi?$AAn?$AAg?$AAC?$AAo?$AAl?$AAl?$AAe?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?9?$AA?$DO?$AA_?$AAM?$AA_?$AAi?$AAn?$AAl?$AAi?$AAn?$AAi?$AAn?$AAg@ 0020 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 002c ??_C@_1GA@BONIEFMP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0033 __CrtDbgReportW 004c ?HasInlineCancellation@ContextBase@details@Concurrency@@QBE_NXZ 00a8 ?_None@_CancellationTokenState@details@Concurrency@@SAPAV123@XZ 00c2 ?_IsCanceled@_CancellationTokenState@details@Concurrency@@QBE_NXZ 00f7 ?_SafeGetParent@_TaskCollectionBase@details@Concurrency@@IAEPAV123@XZ 0117 ?_GetTokenState@_TaskCollectionBase@details@Concurrency@@QAEPAV_CancellationTokenState@23@PAPAV_CancellationTokenRegistration@23@@Z 0123 ?_IsStructured@_TaskCollectionBase@details@Concurrency@@QAE_NXZ 0132 ?_IsMarkedForCancellation@_TaskCollectionBase@details@Concurrency@@IBE_NXZ 0150 ?_IsMarkedForAbnormalExit@_TaskCollection@details@Concurrency@@QBE_NXZ 0191 ??_C@_1DE@NMAJHCK@?$AAp?$AAG?$AAo?$AAv?$AAe?$AAr?$AAn?$AAi?$AAn?$AAg?$AAT?$AAo?$AAk?$AAe?$AAn?$AAS?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F8 8B 45 08 8B 48 04 C1 E1 04 C1 F9 04 3B 4D 0C 7D 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 1B 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C5 33 C9 75 C1 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 0F 84 77 01 00 00 8B 45 F8 8B 48 68 3B 4D 0C 0F 8F 68 01 00 00 8B 55 F8 83 7A 3C FF 74 0E 8B 45 F8 8B 48 68 8B 55 F8 3B 4A 3C 7C 07 B0 01 E9 4C 01 00 00 8B 45 F8 8B 4D 08 3B 48 34 75 38 8B 55 F8 8B 42 34 8B 48 04 C1 E1 04 C1 F9 04 39 4D 0C 75 24 E8 ?? ?? ?? ?? 8B 55 F8 39 42 38 75 07 32 C0 E9 19 01 00 00 8B 45 F8 8B 48 38 E8 ?? ?? ?? ?? E9 09 01 00 00 8B 4D 08 89 4D FC 83 7D FC 00 74 29 8B 55 F8 8B 45 FC 3B 42 30 74 1E 8B 4D FC 8B 51 04 C1 E2 04 C1 FA 04 3B 55 0C 74 0D 8B 4D FC E8 ?? ?? ?? ?? 89 45 FC EB D1 83 7D FC 00 74 66 8B 45 F8 8B 4D FC 3B 48 30 74 5B 6A 00 8B 4D FC E8 ?? ?? ?? ?? 85 C0 75 4D 8B 4D FC E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 0F 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 1E 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 13 8B 4D FC E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 04 B0 01 EB 75 8B 4D FC E8 ?? ?? ?? ?? 89 45 FC EB 94 83 7D FC 00 74 60 8B 45 F8 8B 4D FC 3B 48 30 74 55 6A 00 8B 4D FC E8 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 4B 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 D0 33 C9 75 CC E8 ?? ?? ?? ?? 39 45 F4 74 0A 8B 4D F4 E8 ?? ?? ?? ?? EB 02 32 C0 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_22_173_0 {
	meta:
		name = "?IsCanceledAtDepth@ContextBase@details@Concurrency@@QAE_NH@Z"
		size = 32
		refs = "0016 ?IsCanceledAtDepth@ContextBase@details@Concurrency@@AAE_NPAV_TaskCollectionBase@23@H@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC 8B 51 34 52 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_174_0 {
	meta:
		name = "?IsCanceledAtDepth@ContextBase@details@Concurrency@@QAE_NPAV_TaskCollectionBase@23@@Z"
		size = 38
		refs = "001c ?IsCanceledAtDepth@ContextBase@details@Concurrency@@AAE_NPAV_TaskCollectionBase@23@H@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 8B 48 04 C1 E1 04 C1 F9 04 51 8B 55 08 52 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_175_0 {
	meta:
		name = "?IsCancellationVisible@ContextBase@details@Concurrency@@QBE_NPAV_TaskCollectionBase@23@_N@Z"
		size = 301
		refs = "000a ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 001f ??_C@_1MC@CECNOHJK@?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAB?$AAa?$AAs?$AAe?$AA?3?$AA?3?$AAF?$AAa?$AAs?$AAt?$AAC?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AAC?$AAo?$AAn?$AAt?$AAe?$AAx@ 0024 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0030 ??_C@_1GA@BONIEFMP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0037 __CrtDbgReportW 0065 ??_C@_1OC@ODPONFNA@?$AAm?$AA_?$AAp?$AAE?$AAx?$AAe?$AAc?$AAu?$AAt?$AAi?$AAn?$AAg?$AAC?$AAo?$AAl?$AAl?$AAe?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAp?$AAC?$AAu?$AAr?$AAr?$AAe@ 0096 ?HasAnyCancellation@ContextBase@details@Concurrency@@QBE_NXZ 00a2 ??_C@_1CK@OBLENABC@?$AAH?$AAa?$AAs?$AAA?$AAn?$AAy?$AAC?$AAa?$AAn?$AAc?$AAe?$AAl?$AAl?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?$CI?$AA?$CJ?$AA?$AA@ 00d3 ?HasInlineCancellation@ContextBase@details@Concurrency@@QBE_NXZ 00eb ?TokenHidesCancellation@ContextBase@details@Concurrency@@QBE_NPAV_TaskCollectionBase@23@_N@Z 00fa ?HasPendingCancellation@ContextBase@details@Concurrency@@QBE_NXZ 0109 ?_WillInterruptForPendingCancel@_TaskCollectionBase@details@Concurrency@@IAE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC E8 ?? ?? ?? ?? 3B 45 FC 75 0B 8B 45 08 8B 48 0C 3B 4D FC 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 06 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C1 33 C9 75 BD 8B 55 FC 8B 42 34 3B 45 08 74 33 8B 4D FC 8B 55 08 8B 41 34 3B 02 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 07 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 BE 33 C0 75 BA 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 08 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C7 33 C9 75 C3 8B 4D FC E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 18 0F B6 45 0C 50 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 27 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 0F 8B 4D 08 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 09 C7 45 F8 00 00 00 00 EB 07 C7 45 F8 01 00 00 00 8A 45 F8 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_22_177_0 {
	meta:
		name = "?IsEntireContextCanceled@ContextBase@details@Concurrency@@QBE_NXZ"
		size = 41
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 83 78 74 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_178_0 {
	meta:
		name = "?IsExternal@ContextBase@details@Concurrency@@QBE_NXZ"
		size = 17
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8A 40 4C 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_179_0 {
	meta:
		name = "?IsInsideCriticalRegion@ContextBase@details@Concurrency@@QBE_NXZ"
		size = 71
		refs = "0010 ?IsUMSScheduler@SchedulerBase@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 1C E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 26 8B 55 FC 8B 02 8B 4D FC 8B 50 40 FF D2 85 C0 74 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8A 45 F8 EB 02 B0 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_180_0 {
	meta:
		name = "?IsLockHeld@WorkQueue@details@Concurrency@@QBE_NXZ"
		size = 22
		refs = "000e ?_IsLockHeld@_CriticalNonReentrantLock@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 70 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_181_0 {
	meta:
		name = "?IsOneShotInitialized@SchedulerBase@details@Concurrency@@SA_NXZ"
		size = 39
		refs = "0005 ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA"
	strings:
		$1 = { 55 8B EC 51 A1 ?? ?? ?? ?? 25 00 00 00 80 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_183_0 {
	meta:
		name = "?IsUnstructuredEmpty@WorkQueue@details@Concurrency@@QBE_NXZ"
		size = 22
		refs = "000e ?Empty@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 4C E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_173_216_0 {
	meta:
		name = "?MarkDetachment@WorkQueue@details@Concurrency@@QAEXXZ"
		size = 22
		refs = "000e ?MarkDetachment@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 4C E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_184_0 {
	meta:
		name = "?LockedSetOwningContext@WorkQueue@details@Concurrency@@QAEXPAVContextBase@23@@Z"
		size = 44
		refs = "000e ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ 0022 ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 70 E8 ?? ?? ?? ?? 8B 45 FC 8B 4D 08 89 48 48 8B 4D FC 83 C1 70 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_185_0 {
	meta:
		name = "?Next@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEPAUListNode@123@PAHPAU4123@@Z"
		size = 125
		refs = "0020 ??_C@_1EA@IHPEJDIL@?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAx?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CK?$AAx?$AA?5?$AA?$DM?$AA?5?$AAm?$AA_?$AAs?$AAi?$AAz?$AAe?$AA?$AA@ 0025 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0031 ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0038 __CrtDbgReportW 0073 ?NextList@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@PAH@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 83 7D 0C 00 74 12 83 7D 08 00 74 0C 8B 45 08 8B 4D FC 8B 10 3B 11 7C 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 F7 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 BE 33 D2 75 BA 8B 45 0C 83 38 00 74 09 8B 4D 0C 8B 01 EB 1B EB 19 8B 55 08 8B 02 83 C0 01 8B 4D 08 89 01 8B 55 08 52 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_22_186_0 {
	meta:
		name = "?Next@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QBEPAUListEntry@23@PAU423@@Z"
		size = 46
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 4D 08 3B 08 74 0B 8B 55 08 8B 42 04 89 45 FC EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_187_0 {
	meta:
		name = "?NextList@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@PAH@Z"
		size = 157
		refs = "0024 ??_C@_1EE@CIMHFEJH@?$AAx?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CK?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CK?$AAx?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAm?$AA_?$AAs?$AAi?$AAz@ 0029 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0035 ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 003c __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 83 7D 08 00 74 14 8B 45 08 83 38 00 7C 0C 8B 4D 08 8B 55 F8 8B 01 3B 02 7E 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 80 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 BC 33 C0 75 B8 8B 4D 08 8B 11 89 55 FC EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D F8 8B 55 FC 3B 11 7D 27 8B 45 F8 8B 48 08 8B 55 FC 83 3C 91 00 74 16 8B 45 08 8B 4D FC 89 08 8B 55 F8 8B 42 08 8B 4D FC 8B 04 88 EB 04 EB C6 33 C0 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_188_0 {
	meta:
		name = "?Pop@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ"
		size = 136
		refs = "006f ?Claim@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE_NPAPAV_UnrealizedChore@34@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 8B 48 04 83 E9 01 89 4D F4 8B 55 FC 8B 45 F4 89 42 04 33 C9 8B 55 FC 8B 45 F4 23 42 08 8B 55 FC 8B 52 0C 8D 04 82 87 08 89 4D F8 83 7D F8 00 75 0C 8B 4D F4 83 C1 01 8B 55 FC 89 4A 04 8B 45 F8 83 E0 01 74 30 8B 4D F8 83 E1 FE 89 4D F8 6A 00 8B 55 FC 8B 45 F4 23 42 08 8B 4D FC 8B 51 10 8D 0C C2 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 07 B8 01 00 00 00 EB 03 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_117_0 {
	meta:
		name = "?Pop@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ"
		size = 136
		refs = "006f ?Claim@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE_NPAPAVInternalContextBase@34@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 8B 48 04 83 E9 01 89 4D F4 8B 55 FC 8B 45 F4 89 42 04 33 C9 8B 55 FC 8B 45 F4 23 42 08 8B 55 FC 8B 52 0C 8D 04 82 87 08 89 4D F8 83 7D F8 00 75 0C 8B 4D F4 83 C1 01 8B 55 FC 89 4A 04 8B 45 F8 83 E0 01 74 30 8B 4D F8 83 E1 FE 89 4D F8 6A 00 8B 55 FC 8B 45 F4 23 42 08 8B 4D FC 8B 51 10 8D 0C C2 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 07 B8 01 00 00 00 EB 03 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_189_0 {
	meta:
		name = "?Pop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ"
		size = 169
		refs = "0062 ?SyncPop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEPAV_UnrealizedChore@23@XZ 0090 ?Claim@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE_NPAPAV_UnrealizedChore@34@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC C7 45 F8 00 00 00 00 8B 45 FC 8B 48 04 83 E9 01 89 4D F4 8B 55 F4 8B 45 FC 83 C0 04 87 10 8B 4D FC 8B 11 3B 55 F4 7F 21 8B 45 FC 8B 4D F4 23 48 08 8B 55 FC 8B 42 1C 8B 0C 88 89 4D F8 83 7D F8 00 75 02 EB C2 EB 1A EB 16 8B 55 F4 83 C2 01 8B 45 FC 89 50 04 8B 4D FC E8 ?? ?? ?? ?? EB 3D EB A6 8B 4D F8 83 E1 01 74 30 8B 55 F8 83 E2 FE 89 55 F8 6A 00 8B 45 FC 8B 4D F4 23 48 08 8B 55 FC 8B 42 20 8D 0C C8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 07 B8 01 00 00 00 EB 03 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_190_0 {
	meta:
		name = "?PopCancellationBeacon@ContextBase@details@Concurrency@@QAEXXZ"
		size = 25
		refs = "0011 ?ReleaseBeacon@CancellationBeaconStack@ContextBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 81 C1 8C 00 00 00 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_191_0 {
	meta:
		name = "?PopContextFromTls@ContextBase@details@Concurrency@@AAEPAV123@XZ"
		size = 53
		refs = "0017 ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 001d ?__TlsSetValue@platform@details@Concurrency@@YAXKPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 24 89 4D F8 8B 55 F8 52 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D FC C7 41 24 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_192_0 {
	meta:
		name = "?PopGoverningTokenState@ContextBase@details@Concurrency@@QAEXPAV_CancellationTokenState@23@@Z"
		size = 397
		refs = "000a ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0014 ??_C@_1FI@PHNNBKGB@?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAB?$AAa?$AAs?$AAe?$AA?3?$AA?3?$AAF?$AAa?$AAs?$AAt?$AAC?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AAC?$AAo?$AAn?$AAt?$AAe?$AAx@ 0019 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0025 ??_C@_1GA@BONIEFMP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 002c __CrtDbgReportW 004d ??_C@_1EM@LMOLIJPB@?$AAm?$AA_?$AAp?$AAG?$AAo?$AAv?$AAe?$AAr?$AAn?$AAi?$AAn?$AAg?$AAT?$AAo?$AAk?$AAe?$AAn?$AAS?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAp?$AAT?$AAo?$AAk?$AAe?$AAn@ 0081 ?_InliningDepth@_TaskCollectionBase@details@Concurrency@@QBEHXZ 008e ??_C@_1IE@JGDPADJP@?$AAm?$AA_?$AAp?$AAE?$AAx?$AAe?$AAc?$AAu?$AAt?$AAi?$AAn?$AAg?$AAC?$AAo?$AAl?$AAl?$AAe?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?9?$AA?$DO?$AA_?$AAI?$AAn?$AAl?$AAi?$AAn?$AAi?$AAn@ 00c2 ?_SafeGetParent@_TaskCollectionBase@details@Concurrency@@IAEPAV123@XZ 00e0 ?_GetTokenState@_TaskCollectionBase@details@Concurrency@@QAEPAV_CancellationTokenState@23@PAPAV_CancellationTokenRegistration@23@@Z 0122 ??_C@_1JE@BALHIPJJ@?$AAp?$AAC?$AAo?$AAl?$AAl?$AAe?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?9?$AA?$DO?$AA_?$AAG?$AAe?$AAt?$AAT?$AAo?$AAk?$AAe?$AAn?$AAS?$AAt?$AAa?$AAt?$AAe?$AA?$CI?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN@"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 E8 ?? ?? ?? ?? 3B 45 F8 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 70 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CC 33 D2 75 C8 8B 45 F8 8B 48 38 3B 4D 08 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 71 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CB 33 C9 75 C7 8B 55 F8 8B 4A 34 E8 ?? ?? ?? ?? 8B 4D F8 3B 41 3C 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 72 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C3 33 C9 75 BF 8B 55 F8 8B 4A 34 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 26 8B 45 F8 8B 4D FC 3B 48 30 74 1B 6A 00 8B 4D FC E8 ?? ?? ?? ?? 85 C0 75 0D 8B 4D FC E8 ?? ?? ?? ?? 89 45 FC EB D4 83 7D FC 00 74 78 8B 55 F8 8B 45 FC 3B 42 30 74 6D 6A 00 8B 4D FC E8 ?? ?? ?? ?? 85 C0 74 0D 8B 4D FC E8 ?? ?? ?? ?? 83 F8 FF 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 81 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 BB 33 C0 75 B7 6A 00 8B 4D FC E8 ?? ?? ?? ?? 8B 4D F8 89 41 38 8B 55 FC 8B 42 04 C1 E0 04 C1 F8 04 8B 4D F8 89 41 3C EB 14 8B 55 F8 C7 42 38 00 00 00 00 8B 45 F8 C7 40 3C FF FF FF FF 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_193_0 {
	meta:
		name = "?PopStructured@ContextBase@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ"
		size = 85
		refs = "0013 ??_C@_1CE@MFPOBKIK@?$AAm?$AA_?$AAp?$AAW?$AAo?$AAr?$AAk?$AAQ?$AAu?$AAe?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0018 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0024 ??_C@_1GA@BONIEFMP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 002b __CrtDbgReportW 0047 ?PopStructured@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 78 20 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 13 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 8B 4D FC 8B 49 20 E8 ?? ?? ?? ?? 89 45 F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_195_0 {
	meta:
		name = "?PullFromFreePool@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAEPAVWorkQueue@23@XZ"
		size = 48
		refs = "000f __imp__InterlockedPopEntrySList@4"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F8 8B 45 F8 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 04 33 C0 EB 0C 8B 4D FC 83 E9 18 89 4D F4 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_196_0 {
	meta:
		name = "?Push@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"
		size = 97
		refs = "004b ??0Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ 0057 ?GrowAndPush@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEXPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 04 89 4D F8 8B 55 FC 8B 02 8B 4D FC 03 41 08 39 45 F8 7D 23 8B 55 FC 8B 45 F8 23 42 08 8B 4D FC 8B 51 0C 8B 4D 08 89 0C 82 8B 55 F8 83 C2 01 8B 45 FC 89 50 04 EB 16 83 EC 08 8B CC E8 ?? ?? ?? ?? 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_149_158_0 {
	meta:
		name = "?Push@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z"
		size = 97
		refs = "004b ??0Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE@XZ 0057 ?GrowAndPush@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@AAEXPAVInternalContextBase@23@VSlot@?$Mailbox@VInternalContextBase@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 04 89 4D F8 8B 55 FC 8B 02 8B 4D FC 03 41 08 39 45 F8 7D 23 8B 55 FC 8B 45 F8 23 42 08 8B 4D FC 8B 51 0C 8B 4D 08 89 0C 82 8B 55 F8 83 C2 01 8B 45 FC 89 50 04 EB 16 83 EC 08 8B CC E8 ?? ?? ?? ?? 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_197_0 {
	meta:
		name = "?Push@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
		size = 152
		refs = "0026 ?IsEmpty@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QBE_NXZ 0048 ??4Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEAAV0123@ABV0123@@Z 0082 ??0Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@ABV0123@@Z 008e ?GrowAndPush@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEXPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 04 89 4D F8 8B 55 FC 8B 02 8B 4D FC 03 41 08 39 45 F8 7D 56 8D 4D 0C E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 24 8D 45 0C 50 8B 4D FC 8B 55 F8 23 51 08 8B 45 FC 8B 48 10 8D 0C D1 E8 ?? ?? ?? ?? 8B 55 08 83 CA 01 89 55 08 8B 45 FC 8B 4D F8 23 48 08 8B 55 FC 8B 42 0C 8B 55 08 89 14 88 8B 45 F8 83 C0 01 8B 4D FC 89 41 04 EB 1A 83 EC 08 8B CC 8D 55 0C 52 E8 ?? ?? ?? ?? 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_22_198_0 {
	meta:
		name = "?Push@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEHPAV_UnrealizedChore@23@@Z"
		size = 108
		refs = "0056 ??0Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ 0062 ?SyncPush@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEHPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 04 89 4D F8 8B 55 FC 8B 02 8B 4D FC 03 41 08 39 45 F8 7D 2E 8B 55 FC 8B 45 F8 23 42 08 8B 4D FC 8B 51 1C 8B 4D 08 89 0C 82 8B 55 F8 83 C2 01 8B 45 FC 89 50 04 8B 4D FC 8B 45 F8 03 41 0C EB 18 EB 16 83 EC 08 8B CC E8 ?? ?? ?? ?? 8B 55 08 52 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_199_0 {
	meta:
		name = "?Push@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEHPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
		size = 163
		refs = "0026 ?IsEmpty@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QBE_NXZ 0048 ??4Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEAAV0123@ABV0123@@Z 008d ??0Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@ABV0123@@Z 0099 ?SyncPush@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEHPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 04 89 4D F8 8B 55 FC 8B 02 8B 4D FC 03 41 08 39 45 F8 7D 61 8D 4D 0C E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 24 8D 45 0C 50 8B 4D FC 8B 55 F8 23 51 08 8B 45 FC 8B 48 20 8D 0C D1 E8 ?? ?? ?? ?? 8B 55 08 83 CA 01 89 55 08 8B 45 FC 8B 4D F8 23 48 08 8B 55 FC 8B 42 1C 8B 55 08 89 14 88 8B 45 F8 83 C0 01 8B 4D FC 89 41 04 8B 55 FC 8B 45 F8 03 42 0C EB 1C EB 1A 83 EC 08 8B CC 8D 45 0C 50 E8 ?? ?? ?? ?? 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_22_200_0 {
	meta:
		name = "?PushCancellationBeacon@ContextBase@details@Concurrency@@QAEPAU_Beacon_reference@23@XZ"
		size = 121
		refs = "0019 ?_InliningDepth@_TaskCollectionBase@details@Concurrency@@QBEHXZ 003d ?AcquirePushBeacon@CancellationBeaconStack@ContextBase@details@Concurrency@@QAEPAUCancellationBeacon@234@H@Z 0048 ?IsEntireContextCanceled@ContextBase@details@Concurrency@@QBE_NXZ 006e ?InternalSignal@CancellationBeacon@ContextBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 10 89 4D FC 8B 45 FC 83 78 34 00 74 10 8B 4D FC 8B 49 34 E8 ?? ?? ?? ?? 89 45 F4 EB 07 C7 45 F4 FF FF FF FF 8B 55 F4 89 55 F0 8B 45 F0 50 8B 4D FC 81 C1 8C 00 00 00 E8 ?? ?? ?? ?? 89 45 F8 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 17 8B 55 FC 83 7A 68 FF 74 16 8B 45 FC 8B 48 68 8B 55 F8 3B 4A 04 7F 08 8B 4D F8 E8 ?? ?? ?? ?? 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_201_0 {
	meta:
		name = "?PushContextToTls@ContextBase@details@Concurrency@@AAEXPAV123@@Z"
		size = 106
		refs = "0012 ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 0018 ?__TlsGetValue@platform@details@Concurrency@@YAPAXK@Z 0024 ??_C@_1HM@LCNEDJGO@?$AAp?$AAl?$AAa?$AAt?$AAf?$AAo?$AAr?$AAm?$AA?3?$AA?3?$AA_?$AA_?$AAT?$AAl?$AAs?$AAG?$AAe?$AAt?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?$CI?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe@ 0029 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0035 ??_C@_1GA@BONIEFMP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 003c __CrtDbgReportW 005d ?__TlsSetValue@platform@details@Concurrency@@YAXKPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 48 24 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 04 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 C3 33 D2 75 BF 8B 45 FC 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_202_0 {
	meta:
		name = "?PushGoverningTokenState@ContextBase@details@Concurrency@@QAEXPAV_CancellationTokenState@23@H@Z"
		size = 87
		refs = "0008 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0012 ??_C@_1FI@PHNNBKGB@?$AAS?$AAc?$AAh?$AAe?$AAd?$AAu?$AAl?$AAe?$AAr?$AAB?$AAa?$AAs?$AAe?$AA?3?$AA?3?$AAF?$AAa?$AAs?$AAt?$AAC?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AAC?$AAo?$AAn?$AAt?$AAe?$AAx@ 0017 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0023 ??_C@_1GA@BONIEFMP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 002a __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 51 89 4D FC E8 ?? ?? ?? ?? 3B 45 FC 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 66 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CC 33 D2 75 C8 8B 45 FC 8B 4D 08 89 48 38 8B 55 FC 8B 45 0C 89 42 3C 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_22_203_0 {
	meta:
		name = "?PushStructured@ContextBase@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"
		size = 151
		refs = "0011 ?GetStructuredWorkQueue@ContextBase@details@Concurrency@@QAEPAVWorkQueue@23@XZ 0018 ?PushStructured@WorkQueue@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z 0020 ?IsExternal@ContextBase@details@Concurrency@@QBE_NXZ 002f ?IncrementEnqueuedTaskCounter@ExternalContextBase@details@Concurrency@@QAEXXZ 0051 ?IncrementEnqueuedTaskCounter@InternalContextBase@details@Concurrency@@QAEXXZ 005c ?HasVirtualProcessorAvailableForNewWork@SchedulerBase@details@Concurrency@@QBE_NXZ 0070 ??0location@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 10 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0A 8B 4D FC E8 ?? ?? ?? ?? EB 20 83 7D FC 00 74 0B 8B 55 FC 83 EA 04 89 55 F8 EB 07 C7 45 F8 00 00 00 00 8B 4D F8 E8 ?? ?? ?? ?? 8B 45 FC 8B 48 1C E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 2A 83 EC 10 8B CC 89 65 F4 E8 ?? ?? ?? ?? 89 45 F0 8B 55 FC 8B 42 18 50 8B 4D FC 8B 51 1C 8B 45 FC 8B 12 8B 48 1C 8B 42 38 FF D0 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_204_0 {
	meta:
		name = "?PushStructured@ContextBase@details@Concurrency@@QAEXPAV_UnrealizedChore@23@PAVlocation@3@@Z"
		size = 304
		refs = "000d ??0Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ 0024 ?_Is_system@location@Concurrency@@QBE_NXZ 0036 ?GetAffinity@ScheduleGroupSegmentBase@details@Concurrency@@IBEABVlocation@3@XZ 003f ??9location@Concurrency@@QBE_NABV01@@Z 0051 ?GetGroup@ScheduleGroupSegmentBase@details@Concurrency@@QBEPAVScheduleGroupBase@23@XZ 007a ??4Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEAAV0123@ABV0123@@Z 0098 ??0Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@ABV0123@@Z 00a4 ?GetStructuredWorkQueue@ContextBase@details@Concurrency@@QAEPAVWorkQueue@23@XZ 00ab ?PushStructured@WorkQueue@details@Concurrency@@QAEXPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z 00b3 ?IsExternal@ContextBase@details@Concurrency@@QBE_NXZ 00c2 ?IncrementEnqueuedTaskCounter@ExternalContextBase@details@Concurrency@@QAEXXZ 00e4 ?IncrementEnqueuedTaskCounter@InternalContextBase@details@Concurrency@@QAEXXZ 00ef ?HasVirtualProcessorAvailableForNewWork@SchedulerBase@details@Concurrency@@QBE_NXZ 010c ??0location@Concurrency@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 2C 89 4D FC 8D 4D DC E8 ?? ?? ?? ?? 8B 45 FC 8B 48 18 89 4D F8 83 7D 0C 00 74 6B 8B 4D 0C E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 5C 8B 45 FC 8B 48 18 E8 ?? ?? ?? ?? 50 8B 4D 0C E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 34 8B 55 FC 8B 4A 18 E8 ?? ?? ?? ?? 89 45 F4 8D 45 F8 50 8B 4D 0C 51 8B 55 08 52 8D 45 D4 50 8B 4D F4 8B 11 8B 4D F4 8B 42 18 FF D0 50 8D 4D DC E8 ?? ?? ?? ?? 8B 4D F8 8B 11 8B 4D F8 8B 42 04 FF D0 83 EC 08 8B CC 89 65 EC 8D 55 DC 52 E8 ?? ?? ?? ?? 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0A 8B 4D FC E8 ?? ?? ?? ?? EB 20 83 7D FC 00 74 0B 8B 55 FC 83 EA 04 89 55 F0 EB 07 C7 45 F0 00 00 00 00 8B 4D F0 E8 ?? ?? ?? ?? 8B 45 FC 8B 48 1C E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 30 8B 4D F8 E8 ?? ?? ?? ?? 83 EC 10 8B CC 89 65 E8 50 E8 ?? ?? ?? ?? 89 45 E4 8B 55 F8 52 8B 45 FC 8B 48 1C 8B 55 FC 8B 01 8B 4A 1C 8B 50 38 FF D2 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_22_205_0 {
	meta:
		name = "?PushStructured@WorkQueue@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"
		size = 25
		refs = "000f ?Push@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_81_129_1 {
	meta:
		name = "??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV01@ABV01@@Z"
		size = 25
		refs = "000f ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_78_423_1 {
	meta:
		name = "??Y?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV01@ABV01@@Z"
		size = 25
		refs = "000f ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@ABV12@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_13_568_3 {
	meta:
		name = "??Y?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV01@ABV01@@Z"
		size = 25
		refs = "000f ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@ABV12@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_278_49_0 {
	meta:
		name = "?CreateScheduleGroup@SchedulerBase@details@Concurrency@@UAEPAVScheduleGroup@3@AAVlocation@3@@Z"
		size = 25
		refs = "000f ?InternalCreateScheduleGroup@SchedulerBase@details@Concurrency@@AAEPAVScheduleGroup@3@PAVlocation@3@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_113_1076_2 {
	meta:
		name = "?Set@?$_ResultHolder@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAEXABU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Z"
		size = 25
		refs = "000f ??4?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@QAEAAU01@ABU01@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_1477_3 {
	meta:
		name = "?_SetTaskCreationCallstack@?$task@X@Concurrency@@QAEXABV_TaskCreationCallstack@details@2@@Z"
		size = 25
		refs = "000f ?_SetTaskCreationCallstack@?$task@E@Concurrency@@QAEXABV_TaskCreationCallstack@details@2@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_271_3 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAEPADI@Z"
		size = 25
		refs = "000f ?allocate@?$allocator@D@std@@QAEPADI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_13_1100_3 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAEPAGI@Z"
		size = 25
		refs = "000f ?allocate@?$allocator@G@std@@QAEPAGI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_1529_3 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@PAX@std@@@std@@QAEPAPAXI@Z"
		size = 25
		refs = "000f ?allocate@?$allocator@PAX@std@@QAEPAPAXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_1530_3 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QAEPAU_Container_proxy@2@I@Z"
		size = 25
		refs = "000f ?allocate@?$allocator@U_Container_proxy@std@@@std@@QAEPAU_Container_proxy@2@I@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_4_189_2 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAEPA_WI@Z"
		size = 25
		refs = "000f ?allocate@?$allocator@_W@std@@QAEPA_WI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_30_1297_3 {
	meta:
		name = "?push@?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@QAEXABQAV?$message@I@2@@Z"
		size = 25
		refs = "000f ?_Internal_push@_Concurrent_queue_base_v4@details@Concurrency@@IAEXPBX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_1298_1 {
	meta:
		name = "?push@?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@QAEXABQAV?$message@W4agent_status@Concurrency@@@2@@Z"
		size = 25
		refs = "000f ?_Internal_push@_Concurrent_queue_base_v4@details@Concurrency@@IAEXPBX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_1660_3 {
	meta:
		name = "?swap@?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QAEXAAV12@@Z"
		size = 25
		refs = "000f ?_Swap@?$_Ptr_base@U?$_Task_impl@E@details@Concurrency@@@std@@QAEXAAV12@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_100_1550_1 {
	meta:
		name = "?swap@?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@std@@QAEXAAV12@@Z"
		size = 25
		refs = "000f ?_Swap@?$_Ptr_base@U?$_Task_impl@_N@details@Concurrency@@@std@@QAEXAAV12@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_113_1641_2 {
	meta:
		name = "?swap@?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@QAEXAAV12@@Z"
		size = 25
		refs = "000f ?_Swap@?$_Ptr_base@U_ExceptionHolder@details@Concurrency@@@std@@QAEXAAV12@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_151_154_0 {
	meta:
		name = "?swap@?$shared_ptr@V__ExceptionPtr@@@std@@QAEXAAV12@@Z"
		size = 25
		refs = "000f ?_Swap@?$_Ptr_base@V__ExceptionPtr@@@std@@QAEXAAV12@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_1411_1 {
	meta:
		name = "?try_pop@?$concurrent_queue@PAV?$message@I@Concurrency@@V?$allocator@PAV?$message@I@Concurrency@@@std@@@Concurrency@@QAE_NAAPAV?$message@I@2@@Z"
		size = 25
		refs = "000f ?_Internal_pop_if_present@_Concurrent_queue_base_v4@details@Concurrency@@IAE_NPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_1412_1 {
	meta:
		name = "?try_pop@?$concurrent_queue@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@QAE_NAAPAV?$message@W4agent_status@Concurrency@@@2@@Z"
		size = 25
		refs = "000f ?_Internal_pop_if_present@_Concurrent_queue_base_v4@details@Concurrency@@IAE_NPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_206_0 {
	meta:
		name = "?PushStructured@WorkQueue@details@Concurrency@@QAEXPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
		size = 39
		refs = "0011 ??0Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@ABV0123@@Z 001d ?Push@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 83 EC 08 8B CC 8D 45 0C 50 E8 ?? ?? ?? ?? 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_22_207_0 {
	meta:
		name = "?PushUnstructured@ContextBase@details@Concurrency@@QAEHPAV_UnrealizedChore@23@@Z"
		size = 157
		refs = "0011 ?GetWorkQueue@ContextBase@details@Concurrency@@QAEPAVWorkQueue@23@XZ 0018 ?PushUnstructured@WorkQueue@details@Concurrency@@QAEHPAV_UnrealizedChore@23@@Z 0023 ?IsExternal@ContextBase@details@Concurrency@@QBE_NXZ 0032 ?IncrementEnqueuedTaskCounter@ExternalContextBase@details@Concurrency@@QAEXXZ 0054 ?IncrementEnqueuedTaskCounter@InternalContextBase@details@Concurrency@@QAEXXZ 005f ?HasVirtualProcessorAvailableForNewWork@SchedulerBase@details@Concurrency@@QBE_NXZ 0073 ??0location@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 89 45 F4 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0A 8B 4D FC E8 ?? ?? ?? ?? EB 20 83 7D FC 00 74 0B 8B 55 FC 83 EA 04 89 55 F8 EB 07 C7 45 F8 00 00 00 00 8B 4D F8 E8 ?? ?? ?? ?? 8B 45 FC 8B 48 1C E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 2A 83 EC 10 8B CC 89 65 F0 E8 ?? ?? ?? ?? 89 45 EC 8B 55 FC 8B 42 18 50 8B 4D FC 8B 51 1C 8B 45 FC 8B 12 8B 48 1C 8B 42 38 FF D0 8B 45 F4 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_208_0 {
	meta:
		name = "?PushUnstructured@ContextBase@details@Concurrency@@QAEHPAV_UnrealizedChore@23@PAVlocation@3@@Z"
		size = 310
		refs = "000d ??0Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ 0024 ?_Is_system@location@Concurrency@@QBE_NXZ 0036 ?GetAffinity@ScheduleGroupSegmentBase@details@Concurrency@@IBEABVlocation@3@XZ 003f ??9location@Concurrency@@QBE_NABV01@@Z 0051 ?GetGroup@ScheduleGroupSegmentBase@details@Concurrency@@QBEPAVScheduleGroupBase@23@XZ 007a ??4Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEAAV0123@ABV0123@@Z 0098 ??0Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@ABV0123@@Z 00a4 ?GetWorkQueue@ContextBase@details@Concurrency@@QAEPAVWorkQueue@23@XZ 00ab ?PushUnstructured@WorkQueue@details@Concurrency@@QAEHPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z 00b6 ?IsExternal@ContextBase@details@Concurrency@@QBE_NXZ 00c5 ?IncrementEnqueuedTaskCounter@ExternalContextBase@details@Concurrency@@QAEXXZ 00e7 ?IncrementEnqueuedTaskCounter@InternalContextBase@details@Concurrency@@QAEXXZ 00f2 ?HasVirtualProcessorAvailableForNewWork@SchedulerBase@details@Concurrency@@QBE_NXZ 010f ??0location@Concurrency@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 30 89 4D FC 8D 4D D8 E8 ?? ?? ?? ?? 8B 45 FC 8B 48 18 89 4D F8 83 7D 0C 00 74 6B 8B 4D 0C E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 5C 8B 45 FC 8B 48 18 E8 ?? ?? ?? ?? 50 8B 4D 0C E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 34 8B 55 FC 8B 4A 18 E8 ?? ?? ?? ?? 89 45 F4 8D 45 F8 50 8B 4D 0C 51 8B 55 08 52 8D 45 D0 50 8B 4D F4 8B 11 8B 4D F4 8B 42 18 FF D0 50 8D 4D D8 E8 ?? ?? ?? ?? 8B 4D F8 8B 11 8B 4D F8 8B 42 04 FF D0 83 EC 08 8B CC 89 65 E8 8D 55 D8 52 E8 ?? ?? ?? ?? 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 89 45 EC 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0A 8B 4D FC E8 ?? ?? ?? ?? EB 20 83 7D FC 00 74 0B 8B 55 FC 83 EA 04 89 55 F0 EB 07 C7 45 F0 00 00 00 00 8B 4D F0 E8 ?? ?? ?? ?? 8B 45 FC 8B 48 1C E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 30 8B 4D F8 E8 ?? ?? ?? ?? 83 EC 10 8B CC 89 65 E4 50 E8 ?? ?? ?? ?? 89 45 E0 8B 55 F8 52 8B 45 FC 8B 48 1C 8B 55 FC 8B 01 8B 4A 1C 8B 50 38 FF D2 8B 45 EC 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_22_209_0 {
	meta:
		name = "?PushUnstructured@WorkQueue@details@Concurrency@@QAEHPAV_UnrealizedChore@23@@Z"
		size = 28
		refs = "0012 ?Push@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEHPAV_UnrealizedChore@23@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC 83 C1 4C E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_251_0 {
	meta:
		name = "?TryPopUnstructured@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@H@Z"
		size = 28
		refs = "0012 ?TryPop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@H@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC 83 C1 4C E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_210_0 {
	meta:
		name = "?PushUnstructured@WorkQueue@details@Concurrency@@QAEHPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
		size = 42
		refs = "0011 ??0Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@ABV0123@@Z 0020 ?Push@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEHPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 83 EC 08 8B CC 8D 45 0C 50 E8 ?? ?? ?? ?? 8B 4D 08 51 8B 4D FC 83 C1 4C E8 ?? ?? ?? ?? 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_22_211_0 {
	meta:
		name = "?Raise@CancellationBeacon@ContextBase@details@Concurrency@@QAEXXZ"
		size = 23
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC B9 01 00 00 00 F0 0F C1 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_212_0 {
	meta:
		name = "?RecomputeMaximumCancellationDepth@ContextBase@details@Concurrency@@AAEXXZ"
		size = 237
		refs = "0018 ?IsEntireContextCanceled@ContextBase@details@Concurrency@@QBE_NXZ 0057 ?_IsStructured@_TaskCollectionBase@details@Concurrency@@QAE_NXZ 0066 ?_IsMarkedForCancellation@_TaskCollectionBase@details@Concurrency@@IBE_NXZ 0084 ?_IsMarkedForAbnormalExit@_TaskCollection@details@Concurrency@@QBE_NXZ 00a4 ?_SafeGetParent@_TaskCollectionBase@details@Concurrency@@IAEPAV123@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 18 89 4D F8 83 C8 FF 8B 4D F8 83 C1 6C 87 01 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 09 C7 45 EC 19 FC FF FF EB 07 C7 45 EC FF FF FF FF 8B 45 EC 89 45 F0 8B 4D F8 8B 51 34 89 55 FC 83 7D FC 00 74 65 8B 45 F8 8B 4D FC 3B 48 30 74 5A 8B 4D FC E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 0F 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 1E 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 20 8B 4D FC E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 11 8B 45 FC 8B 48 04 C1 E1 04 C1 F9 04 89 4D F0 EB 0D 8B 4D FC E8 ?? ?? ?? ?? 89 45 FC EB 95 C7 45 F4 FF FF FF FF 83 7D F4 FF 74 0A 8B 55 F0 3B 55 F4 7D 02 EB 25 8B 4D F0 8B 55 F8 83 C2 6C 8B 45 F4 F0 0F B1 0A 89 45 E8 8B 45 E8 3B 45 F4 75 02 EB 08 8B 4D E8 89 4D F4 EB CB 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_213_0 {
	meta:
		name = "?ReferenceForCancellation@ContextBase@details@Concurrency@@QAEXXZ"
		size = 26
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 C0 64 B9 01 00 00 00 F0 0F C1 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_214_0 {
	meta:
		name = "?ReleaseBeacon@CancellationBeaconStack@ContextBase@details@Concurrency@@QAEXXZ"
		size = 78
		refs = "0010 ??_C@_1CE@JBKENDAD@?$AAm?$AA_?$AAb?$AAe?$AAa?$AAc?$AAo?$AAn?$AAD?$AAe?$AAp?$AAt?$AAh?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0015 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0021 ??_C@_1FM@EAKMKOMN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0028 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 38 00 7F 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 3B 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CE 33 C0 75 CA 8B 4D FC 8B 11 83 EA 01 8B 45 FC 89 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_216_0 {
	meta:
		name = "?ReleaseWorkQueue@ContextBase@details@Concurrency@@IAEXXZ"
		size = 148
		refs = "0029 ?IsUnstructuredEmpty@WorkQueue@details@Concurrency@@QBE_NXZ 003a ?LockedSetOwningContext@WorkQueue@details@Concurrency@@QAEXPAVContextBase@23@@Z 0049 ?DetachActiveWorkQueue@ScheduleGroupSegmentBase@details@Concurrency@@IAEXPAVWorkQueue@23@@Z 0053 ?IsLockHeld@WorkQueue@details@Concurrency@@QBE_NXZ 0070 ?SetOwningContext@WorkQueue@details@Concurrency@@QAEXPAVContextBase@23@@Z 0084 ?Remove@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE_NPAVWorkQueue@23@_N@Z 008c ?DetachStealers@ContextBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 83 78 20 00 74 76 8B 4D F8 8B 51 20 89 55 FC 8B 45 F8 C7 40 20 00 00 00 00 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 1B 6A 00 8B 4D FC E8 ?? ?? ?? ?? 8B 55 FC 52 8B 45 F8 8B 48 18 E8 ?? ?? ?? ?? EB 39 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0C 6A 00 8B 4D FC E8 ?? ?? ?? ?? EB 0A 6A 00 8B 4D FC E8 ?? ?? ?? ?? 6A 01 8B 55 FC 52 8B 45 F8 8B 48 18 83 C1 58 E8 ?? ?? ?? ?? 8B 4D F8 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_218_0 {
	meta:
		name = "?Remove@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@ABQAV_TaskCollection@23@H@Z"
		size = 129
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F8 8B 45 F8 8B 48 08 8B 55 0C 8B 04 91 89 45 FC C7 45 F4 00 00 00 00 83 7D FC 00 74 54 8B 4D FC 8B 55 08 8B 41 04 3B 02 75 37 83 7D F4 00 75 13 8B 4D F8 8B 51 08 8B 45 0C 8B 4D FC 8B 09 89 0C 82 EB 0A 8B 55 F4 8B 45 FC 8B 08 89 0A 8B 55 F8 8B 42 04 83 E8 01 8B 4D F8 89 41 04 8B 45 FC EB 12 8B 55 FC 89 55 F4 8B 45 FC 8B 08 89 4D FC EB A6 33 C0 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_22_219_0 {
	meta:
		name = "?Remove@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
		size = 159
		refs = "0018 ??_C@_1DG@KBDKHCCH@?$AAp?$AAN?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAm?$AA_?$AAp?$AAT?$AAa?$AAi?$AAl?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 001d ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0029 ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0030 __CrtDbgReportW 0046 ?Decrement@NoCount@CollectionTypes@details@Concurrency@@SAXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 83 7D 08 00 74 08 8B 45 FC 83 38 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 DE 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C8 33 C0 75 C4 E8 ?? ?? ?? ?? 8B 4D 08 8B 51 04 8B 45 08 8B 08 89 0A 8B 55 08 8B 02 8B 4D 08 8B 51 04 89 50 04 8B 45 FC 8B 4D 08 3B 08 75 2A 8B 55 FC 8B 02 8B 4D FC 8B 11 3B 50 04 75 09 C7 45 F8 00 00 00 00 EB 0A 8B 45 FC 8B 08 8B 11 89 55 F8 8B 45 FC 8B 4D F8 89 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_220_0 {
	meta:
		name = "?Remove@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE_NPAVWorkQueue@23@H_N@Z"
		size = 539
		refs = "00f1 __imp__QueryDepthSList@4 0111 ??_C@_1GC@LJFMHEGO@?$AAm?$AA_?$AAd?$AAe?$AAl?$AAe?$AAt?$AAi?$AAo?$AAn?$AAT?$AAh?$AAr?$AAe?$AAs?$AAh?$AAo?$AAl?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAD?$AAe?$AAl?$AAe?$AAt?$AAi?$AAo?$AAn?$AAT@ 0116 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0122 ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0129 __CrtDbgReportW 014e __imp__InterlockedPushEntrySList@8 017b ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 01a5 ??_C@_1CI@OGGIBFFK@?$AAm?$AA_?$AAd?$AAe?$AAl?$AAe?$AAt?$AAi?$AAo?$AAn?$AAL?$AAi?$AAs?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 01db __imp__InterlockedFlushSList@4 01f1 ?CheckForDeletionBridge@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@CAXPAV123@@Z 01fc ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 24 89 4D FC 8B 45 FC 8B 55 0C 8B 48 2C D3 FA 89 55 F4 8B 45 FC 8B 48 28 83 E9 01 23 4D 0C 89 4D E8 8B 55 FC 8B 45 F4 3B 42 3C 7C 07 32 C0 E9 DD 01 00 00 C7 45 F8 00 00 00 00 8B 4D FC 8B 55 F4 3B 51 38 7C 40 8B 45 FC 8B 48 38 8B 55 FC 8B 42 34 8B 4C 88 FC 89 4D F8 C7 45 F0 00 00 00 00 EB 09 8B 55 F0 83 C2 01 89 55 F0 8B 45 FC 8B 4D F4 2B 48 38 39 4D F0 7F 0B 8B 55 F8 8B 42 04 89 45 F8 EB DE EB 0F 8B 4D FC 8B 51 34 8B 45 F4 8B 0C 82 89 4D F8 8B 55 F8 8B 02 89 45 E4 8B 4D 08 89 4D EC 33 D2 8B 45 E8 8B 4D E4 8D 0C 81 8B 45 EC F0 0F B1 11 89 45 E0 8B 55 EC 39 55 E0 75 14 8B 4D E8 8B 55 F8 83 C2 08 B8 FE FF FF FF F0 0F B1 0A EB 07 32 C0 E9 36 01 00 00 0F B6 45 10 85 C0 0F 84 28 01 00 00 8B 4D FC 51 FF 15 ?? ?? ?? ?? 0F B7 D0 8B 45 FC 3B 50 44 0F 8E FE 00 00 00 8B 4D FC 81 79 44 FF FF FF 7F 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 1E 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CA 33 C9 75 C6 8B 55 08 83 C2 18 52 8B 45 FC 83 C0 08 50 FF 15 ?? ?? ?? ?? 8B 4D FC 83 C1 08 51 FF 15 ?? ?? ?? ?? 0F B7 D0 89 55 DC 8B 45 FC 8B 4D DC 3B 48 44 0F 8E 8C 00 00 00 8B 55 FC 8B 4A 24 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 7A B9 01 00 00 00 8B 55 FC 83 C2 48 33 C0 F0 0F B1 0A 85 C0 75 65 8B 45 FC 83 78 10 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 2F 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 8B 4D FC 83 C1 08 51 FF 15 ?? ?? ?? ?? 8B 55 FC 89 42 10 8B 45 FC 8B 48 24 51 8B 55 FC 52 68 ?? ?? ?? ?? 8B 4D FC 83 C1 14 E8 ?? ?? ?? ?? EB 11 8B 45 08 83 C0 18 50 8B 4D FC 51 FF 15 ?? ?? ?? ?? B0 01 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_22_221_0 {
	meta:
		name = "?Remove@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE_NPAVWorkQueue@23@_N@Z"
		size = 37
		refs = "001b ?Remove@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE_NPAVWorkQueue@23@H_N@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 0F B6 45 0C 50 8B 4D 08 8B 51 44 52 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_22_225_0 {
	meta:
		name = "?RemoveStealer@ContextBase@details@Concurrency@@QAEXPAV123@@Z"
		size = 31
		refs = "0015 ?Remove@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 83 C0 5C 50 8B 4D FC 83 C1 50 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_226_0 {
	meta:
		name = "?ScheduleGroupRefCount@ContextBase@details@Concurrency@@QBEIXZ"
		size = 51
		refs = "0019 ?GetGroup@ScheduleGroupSegmentBase@details@Concurrency@@QBEPAVScheduleGroupBase@23@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 78 18 00 74 13 8B 4D FC 8B 49 18 E8 ?? ?? ?? ?? 8B 50 14 89 55 F8 EB 07 C7 45 F8 FF FF FF FF 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_227_0 {
	meta:
		name = "?SetAsCurrentTls@ContextBase@details@Concurrency@@IAEXXZ"
		size = 30
		refs = "000d ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 0013 ?__TlsSetValue@platform@details@Concurrency@@YAXKPAX@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_228_0 {
	meta:
		name = "?SetIndirectAlias@ContextBase@details@Concurrency@@QAEXPAV_TaskCollection@23@@Z"
		size = 22
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 48 7C 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_229_0 {
	meta:
		name = "?SetOwningContext@WorkQueue@details@Concurrency@@QAEXPAVContextBase@23@@Z"
		size = 22
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 48 48 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_231_0 {
	meta:
		name = "?StaticEnterCriticalRegion@ContextBase@details@Concurrency@@SAXXZ"
		size = 30
		refs = "0005 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0016 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 55 8B EC 51 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 08 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_232_0 {
	meta:
		name = "?StaticEnterHyperCriticalRegion@ContextBase@details@Concurrency@@SAXXZ"
		size = 30
		refs = "0005 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0016 ?EnterHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 55 8B EC 51 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 08 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_233_0 {
	meta:
		name = "?StaticExitCriticalRegion@ContextBase@details@Concurrency@@SAXXZ"
		size = 30
		refs = "0005 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0016 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 55 8B EC 51 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 08 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_234_0 {
	meta:
		name = "?StaticExitHyperCriticalRegion@ContextBase@details@Concurrency@@SAXXZ"
		size = 30
		refs = "0005 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0016 ?ExitHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 55 8B EC 51 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 08 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_235_0 {
	meta:
		name = "?StaticGetCriticalRegionType@ContextBase@details@Concurrency@@SA?AW4CriticalRegionType@3@XZ"
		size = 39
		refs = "0005 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ"
	strings:
		$1 = { 55 8B EC 51 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 0F 8B 45 FC 8B 10 8B 4D FC 8B 42 40 FF D0 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_236_0 {
	meta:
		name = "?SweepAliasTable@ContextBase@details@Concurrency@@QAEXXZ"
		size = 176
		refs = "0017 ?First@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEPAUListNode@123@PAH@Z 003a ?Next@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEPAUListNode@123@PAHPAU4123@@Z 0048 ?_IsStaleAlias@_TaskCollection@details@Concurrency@@ABE_NXZ 0060 ?_OriginalCollection@_TaskCollection@details@Concurrency@@QBEPAV123@XZ 0075 ?Delete@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE_NABQAV_TaskCollection@23@@Z 0091 ??_G_TaskCollection@details@Concurrency@@QAEPAXI@Z"
	strings:
		$1 = { 55 8B EC 83 EC 24 89 4D F8 8D 45 EC 50 8B 4D F8 81 C1 80 00 00 00 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 0F 84 84 00 00 00 8B 4D FC 51 8D 55 EC 52 8B 4D F8 81 C1 80 00 00 00 E8 ?? ?? ?? ?? 89 45 DC 8B 45 FC 8B 48 08 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 4E 8B 55 FC 8B 42 08 89 45 F4 8B 4D F4 E8 ?? ?? ?? ?? 89 45 E8 8D 4D E8 51 8B 4D F8 81 C1 80 00 00 00 E8 ?? ?? ?? ?? 8B 55 F4 89 55 E4 8B 45 E4 89 45 F0 83 7D F0 00 74 0F 6A 01 8B 4D F0 E8 ?? ?? ?? ?? 89 45 E0 EB 07 C7 45 E0 00 00 00 00 8B 4D DC 89 4D FC E9 72 FF FF FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_237_0 {
	meta:
		name = "?SweepUnstructured@ContextBase@details@Concurrency@@QAEXP6A_NPAV_UnrealizedChore@23@PAX@Z12@Z"
		size = 91
		refs = "0011 ??_C@_1CE@MFPOBKIK@?$AAm?$AA_?$AAp?$AAW?$AAo?$AAr?$AAk?$AAQ?$AAu?$AAe?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0016 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0022 ??_C@_1GA@BONIEFMP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0029 __CrtDbgReportW 0051 ?SweepUnstructured@WorkQueue@details@Concurrency@@QAEXP6A_NPAV_UnrealizedChore@23@PAX@Z12@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 78 20 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 4F 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 8B 4D FC 8B 49 20 E8 ?? ?? ?? ?? 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_22_238_0 {
	meta:
		name = "?SyncPop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEPAV_UnrealizedChore@23@XZ"
		size = 333
		refs = "0006 __ehhandler$?SyncPop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEPAV_UnrealizedChore@23@XZ 0015 ___security_cookie 0033 ??0_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 0042 ??0Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ 0098 ??4Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEAAV0123@ABV0123@@Z 0100 ?Claim@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE_NPAPAV_UnrealizedChore@34@@Z 011d ??1_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 20 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 8B 48 10 51 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? C7 45 E8 00 00 00 00 8B 55 F0 8B 42 04 83 E8 01 89 45 EC 8B 4D F0 8B 55 EC 89 51 04 8B 45 F0 8B 08 3B 4D EC 7F 32 8B 55 F0 8B 45 EC 23 42 08 8B 4D F0 8B 51 1C 8B 04 82 89 45 E8 8B 4D F0 8B 55 EC 23 51 08 8B 45 F0 8B 48 20 8D 14 D1 52 8D 4D D4 E8 ?? ?? ?? ?? EB 0C 8B 45 EC 83 C0 01 8B 4D F0 89 41 04 8B 55 F0 8B 02 3B 45 EC 7C 35 8B 4D F0 8B 11 8B 45 F0 03 50 0C 8B 4D F0 89 51 0C 8B 55 F0 C7 02 00 00 00 00 8B 45 F0 C7 40 04 00 00 00 00 8B 4D F0 C7 41 18 00 00 00 00 8B 55 F0 C6 42 14 00 8B 45 E8 83 E0 01 74 35 8B 4D E8 83 E1 FE 89 4D E8 6A 00 8D 4D D4 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 1B C7 45 E0 01 00 00 00 C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 E0 EB 18 8B 45 E8 89 45 DC C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 DC 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_240_0 {
	meta:
		name = "__ehhandler$?SyncPop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEPAV_UnrealizedChore@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?SyncPop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEPAV_UnrealizedChore@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_16_1 {
	meta:
		name = "__ehhandler$??$?0AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@2@@?$_Ref_count_obj@U?$_Task_impl@E@details@Concurrency@@@std@@QAE@AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@4@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@2@@?$_Ref_count_obj@U?$_Task_impl@E@details@Concurrency@@@std@@QAE@AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@4@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_21_1 {
	meta:
		name = "__ehhandler$??$?0AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@2@@?$_Ref_count_obj@U?$_Task_impl@_N@details@Concurrency@@@std@@QAE@AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@4@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@2@@?$_Ref_count_obj@U?$_Task_impl@_N@details@Concurrency@@@std@@QAE@AAPAV_CancellationTokenState@details@Concurrency@@AAUscheduler_ptr@4@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_287_2 {
	meta:
		name = "__ehhandler$??$_Uninitialized_copy@V?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@PAX@std@@@std@@@std@@PAPAXU?$_Wrap_alloc@V?$allocator@PAX@std@@@2@@std@@YAPAPAXV?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@PAX@std@@@std@@@0@0PAPAXAAU?$_Wrap_alloc@V?$allocator@PAX@std@@@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Uninitialized_copy@V?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@PAX@std@@@std@@@std@@PAPAXU?$_Wrap_alloc@V?$allocator@PAX@std@@@2@@std@@YAPAPAXV?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@PAX@std@@@std@@@0@0PAPAXAAU?$_Wrap_alloc@V?$allocator@PAX@std@@@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_667_1 {
	meta:
		name = "__ehhandler$??1_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Blocking_recipient@?1???$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@std@@@Z@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_671_1 {
	meta:
		name = "__ehhandler$??1_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_133_0 {
	meta:
		name = "__ehhandler$?AddRunnableContext@ScheduleGroupSegmentBase@details@Concurrency@@IAEXPAVInternalContextBase@23@Vlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddRunnableContext@ScheduleGroupSegmentBase@details@Concurrency@@IAEXPAVInternalContextBase@23@Vlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_744_113_0 {
	meta:
		name = "__ehhandler$?CreateSchedulerProxy@ResourceManager@details@Concurrency@@AAEPAVSchedulerProxy@23@PAUIScheduler@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateSchedulerProxy@ResourceManager@details@Concurrency@@AAEPAVSchedulerProxy@23@PAUIScheduler@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_638_53_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessorRoot@UMSSchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessorRoot@UMSSchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1006_46_0 {
	meta:
		name = "__ehhandler$?DoPolling@UMSBackgroundPoller@details@Concurrency@@QAE_NXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?DoPolling@UMSBackgroundPoller@details@Concurrency@@QAE_NXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_293_0 {
	meta:
		name = "__ehhandler$?GetBitSet@SchedulerBase@details@Concurrency@@QAE?AVQuickBitSet@23@PBVlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetBitSet@SchedulerBase@details@Concurrency@@QAE?AVQuickBitSet@23@PBVlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_104_0 {
	meta:
		name = "__ehhandler$?Initialize@VirtualProcessor@details@Concurrency@@MAEXPAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Initialize@VirtualProcessor@details@Concurrency@@MAEXPAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_366_0 {
	meta:
		name = "__ehhandler$?Insert@?$Hash@II@details@Concurrency@@QAEPAUListNode@123@ABI0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Insert@?$Hash@II@details@Concurrency@@QAEPAUListNode@123@ABI0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_686_129_0 {
	meta:
		name = "__ehhandler$?Insert@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEPAUListNode@123@ABQAV_TaskCollection@23@0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Insert@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEPAUListNode@123@ABQAV_TaskCollection@23@0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_136_41_0 {
	meta:
		name = "__ehhandler$?LocateSegment@FairScheduleGroup@details@Concurrency@@UAEPAVScheduleGroupSegmentBase@23@PAVlocation@3@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?LocateSegment@FairScheduleGroup@details@Concurrency@@UAEPAVScheduleGroupSegmentBase@23@PAVlocation@3@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1338_129_0 {
	meta:
		name = "__ehhandler$?RemoveCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RemoveCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_744_231_0 {
	meta:
		name = "__ehhandler$?RequestInitialVirtualProcessors@ResourceManager@details@Concurrency@@QAEPAUIExecutionResource@3@PAVSchedulerProxy@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RequestInitialVirtualProcessors@ResourceManager@details@Concurrency@@QAEPAUIExecutionResource@3@PAVSchedulerProxy@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_1154_1 {
	meta:
		name = "__ehhandler$?_FinalizeAndRunContinuations@?$_Task_impl@E@details@Concurrency@@QAEXE@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_FinalizeAndRunContinuations@?$_Task_impl@E@details@Concurrency@@QAEXE@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_1157_1 {
	meta:
		name = "__ehhandler$?_FinalizeAndRunContinuations@?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAEXU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_FinalizeAndRunContinuations@?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QAEXU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_1237_2 {
	meta:
		name = "__ehhandler$?_FinalizeAndRunContinuations@?$_Task_impl@_N@details@Concurrency@@QAEX_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_FinalizeAndRunContinuations@?$_Task_impl@_N@details@Concurrency@@QAEX_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_936_2 {
	meta:
		name = "__ehhandler$?_Handle_message@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@AAEXPAV?$message@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Handle_message@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@AAEXPAV?$message@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_939_2 {
	meta:
		name = "__ehhandler$?_Handle_message@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@AAEXPAV?$message@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Handle_message@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@AAEXPAV?$message@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_942_3 {
	meta:
		name = "__ehhandler$?_Handle_message@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@AAEXPAV?$message@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Handle_message@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@AAEXPAV?$message@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_1374_2 {
	meta:
		name = "__ehhandler$?_Reallocate@?$vector@PAXV?$allocator@PAX@std@@@std@@IAEXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Reallocate@?$vector@PAXV?$allocator@PAX@std@@@std@@IAEXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_1435_2 {
	meta:
		name = "__ehhandler$?_ScheduleTask@_TaskCollectionImpl@details@Concurrency@@QAEXPAU_TaskProcHandle@23@W4_TaskInliningMode@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_ScheduleTask@_TaskCollectionImpl@details@Concurrency@@QAEXPAU_TaskProcHandle@23@W4_TaskInliningMode@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_1125_3 {
	meta:
		name = "__ehhandler$?add@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAEXPAV?$ISource@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?add@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAEXPAV?$ISource@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_1128_2 {
	meta:
		name = "__ehhandler$?add@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAEXPAV?$ISource@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?add@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAEXPAV?$ISource@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_1334_3 {
	meta:
		name = "__ehhandler$?release_ref@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release_ref@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_1337_2 {
	meta:
		name = "__ehhandler$?release_ref@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release_ref@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_1340_1 {
	meta:
		name = "__ehhandler$?release_ref@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release_ref@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_241_0 {
	meta:
		name = "?SyncPush@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEHPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
		size = 885
		refs = "0006 __ehhandler$?SyncPush@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEHPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z 0016 ___security_cookie 0056 ??_C@_0DE@KLEKJPBC@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0074 ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 00dc ??0Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ 00eb ??_H@YGXPAXIHP6EPAX0@Z@Z 0125 ??0_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 0193 ??_C@_0BA@GNDEGJGO@count?5?$DM?5newsize?$AA@ 0198 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 01b2 ??_C@_0BC@EFPMLNL@pNewTasks?5?$CB?$DN?5NULL?$AA@ 0216 ??4Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAEAAV0123@ABV0123@@Z 0264 ??_C@_0BL@BHEFOBAB@m_detachmentTail?5?$DO?$DN?5m_head?$AA@ 02b7 ??_C@_0P@NCHEDLBF@count?5?$DM?5m_mask?$AA@ 02d0 ?IsEmpty@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QBE_NXZ 032b ??1_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@XZ 033a ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 54 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 8B 45 EC 8B 48 08 83 C1 01 89 4D C0 8B 55 C0 D1 E2 89 55 DC 8B 45 EC 8B 48 04 8B 55 EC 2B 0A 89 4D E0 33 C0 88 45 F3 68 2C 02 00 00 68 ?? ?? ?? ?? 0F B6 4D F3 51 33 C9 8B 45 DC BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 BC 8B 45 BC 89 45 D4 8B 4D EC 8B 51 1C 89 55 AC 8B 45 DC 89 45 CC 33 C9 88 4D F2 8D 55 F2 89 55 B8 68 33 02 00 00 68 ?? ?? ?? ?? 8B 45 B8 0F B6 08 51 33 C9 8B 45 CC BA 08 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 D8 C7 45 FC 00 00 00 00 83 7D D8 00 74 1C 68 ?? ?? ?? ?? 8B 45 CC 50 6A 08 8B 4D D8 51 E8 ?? ?? ?? ?? 8B 55 D8 89 55 C8 EB 07 C7 45 C8 00 00 00 00 8B 45 C8 89 45 B4 C7 45 FC FF FF FF FF 8B 4D B4 89 4D C4 8B 55 EC 8B 42 20 89 45 A4 8B 4D EC 8B 51 10 52 8D 4D B0 E8 ?? ?? ?? ?? C7 45 FC 01 00 00 00 8B 45 EC 8B 08 89 4D E8 8B 55 EC 8B 42 04 2B 45 E8 89 45 E0 8B 4D EC 8B 55 E8 23 51 08 89 55 E8 8B 45 E8 03 45 E0 8B 4D EC 8B 51 04 2B D0 8B 45 EC 03 50 0C 8B 4D EC 89 51 0C 8B 55 EC 8B 45 E8 89 02 8B 4D E8 03 4D E0 8B 55 EC 89 4A 04 8B 45 E0 3B 45 DC 7D 02 EB 17 68 4E 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 83 7D D4 00 74 02 EB 17 68 4F 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C C7 45 E4 00 00 00 00 EB 09 8B 4D E4 83 C1 01 89 4D E4 8B 55 E4 3B 55 E0 7D 44 8B 45 E8 03 45 E4 8B 4D EC 23 41 08 8B 55 EC 8B 4A 1C 8B 55 E4 8B 75 D4 8B 04 81 89 04 96 8B 4D E8 03 4D E4 8B 55 EC 23 4A 08 8B 45 EC 8B 50 20 8D 04 CA 50 8B 4D E4 8B 55 C4 8D 0C CA E8 ?? ?? ?? ?? EB AB 8B 45 EC 8B 4D D4 89 48 1C 8B 55 EC 8B 45 C4 89 42 20 8B 4D EC 8B 11 8B 45 EC 03 50 0C 8B 4D EC 89 51 0C 8B 55 EC 0F B6 42 14 85 C0 74 37 8B 4D EC 8B 11 8B 45 EC 39 50 18 7C 02 EB 17 68 65 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D EC 8B 55 EC 8B 42 18 2B 01 8B 4D EC 89 41 18 8B 55 DC 83 EA 01 8B 45 EC 89 50 08 8B 4D EC C7 01 00 00 00 00 8B 55 EC 8B 45 E0 89 42 04 8B 4D EC 8B 55 E0 3B 51 08 7D 02 EB 17 68 6D 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 EC 8B 48 04 89 4D D0 8D 4D 0C E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 24 8D 45 0C 50 8B 4D EC 8B 55 D0 23 51 08 8B 45 EC 8B 48 20 8D 0C D1 E8 ?? ?? ?? ?? 8B 55 08 83 CA 01 89 55 08 8B 45 EC 8B 4D D0 23 48 08 8B 55 EC 8B 42 1C 8B 55 08 89 14 88 8B 45 D0 83 C0 01 8B 4D EC 89 41 04 C7 45 FC FF FF FF FF 8D 4D B0 E8 ?? ?? ?? ?? 8B 55 AC 89 55 A8 8B 45 A8 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D A4 89 4D A0 8B 55 A0 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 EC 8B 48 04 8B 55 EC 8B 42 0C 8D 44 01 FF 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_22_242_0 {
	meta:
		name = "__unwindfunclet$?SyncPush@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEHPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z$0"
		size = 30
		refs = "0006 ??_C@_0DE@KLEKJPBC@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0016 ??_V@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 68 33 02 00 00 68 ?? ?? ?? ?? 8B 45 B8 0F B6 00 50 8B 45 D8 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_22_244_0 {
	meta:
		name = "__ehhandler$?SyncPush@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEHPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?SyncPush@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEHPAV_UnrealizedChore@23@VSlot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_1636_2 {
	meta:
		name = "__ehhandler$?set@?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@QBE_NU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?set@?$task_completion_event@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@QBE_NU?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_245_0 {
	meta:
		name = "?ThrowContextEvent@ContextBase@details@Concurrency@@KAXW4ConcRT_EventType@3@EKK@Z"
		size = 144
		refs = "0008 ?g_pEtw@details@Concurrency@@3PAVEtw@12@A 001e _memset 0043 _ContextEventGuid 0075 ?g_ConcRTSessionHandle@details@Concurrency@@3_KA 0088 ?Trace@Etw@details@Concurrency@@QAEK_KPAU_EVENT_TRACE_HEADER@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 40 83 3D ?? ?? ?? ?? 00 74 7D 33 C0 66 89 45 C0 6A 3E 6A 00 8D 4D C2 51 E8 ?? ?? ?? ?? 83 C4 0C BA 40 00 00 00 66 89 55 C0 C7 45 EC 00 00 02 00 8A 45 08 88 45 C4 8A 4D 0C 88 4D C5 8B 15 ?? ?? ?? ?? 89 55 D8 A1 ?? ?? ?? ?? 89 45 DC 8B 0D ?? ?? ?? ?? 89 4D E0 8B 15 ?? ?? ?? ?? 89 55 E4 8B 45 10 89 45 F4 8B 4D 14 89 4D F8 8D 55 C0 52 A1 ?? ?? ?? ?? 50 8B 0D ?? ?? ?? ?? 51 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_246_0 {
	meta:
		name = "?TokenHidesCancellation@ContextBase@details@Concurrency@@QBE_NPAV_TaskCollectionBase@23@_N@Z"
		size = 204
		refs = "0017 ?_GetTokenState@_TaskCollectionBase@details@Concurrency@@QAEPAV_CancellationTokenState@23@PAPAV_CancellationTokenRegistration@23@@Z 001f ?_None@_CancellationTokenState@details@Concurrency@@SAPAV123@XZ 002c ?_IsCanceled@_CancellationTokenState@details@Concurrency@@QBE_NXZ 005f ??_C@_1DI@ODOPICBE@?$AAm?$AA_?$AAp?$AAG?$AAo?$AAv?$AAe?$AAr?$AAn?$AAi?$AAn?$AAg?$AAT?$AAo?$AAk?$AAe?$AAn?$AAS?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0064 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0070 ??_C@_1GA@BONIEFMP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0077 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 0F B6 45 0C 85 C0 74 2D 6A 00 8B 4D 08 E8 ?? ?? ?? ?? 89 45 F8 E8 ?? ?? ?? ?? 39 45 F8 74 0F 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 07 B0 01 E9 88 00 00 00 8B 55 FC 8B 42 6C 8B 4D FC 3B 41 3C 7D 78 8B 55 FC 83 7A 3C FF 74 6F 8B 45 FC 83 78 38 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 F1 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 E8 ?? ?? ?? ?? 8B 4D FC 39 41 38 75 04 B0 01 EB 29 8B 55 FC 8B 4A 38 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8A 45 F4 EB 02 32 C0 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_22_247_0 {
	meta:
		name = "?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z"
		size = 62
		refs = "000f ?g_TraceInfo@details@Concurrency@@3U_CONCRT_TRACE_INFO@12@A 0014 ?_IsEnabled@_CONCRT_TRACE_INFO@details@Concurrency@@QBE_NEK@Z 0031 ?ThrowContextEvent@ContextBase@details@Concurrency@@KAXW4ConcRT_EventType@3@EKK@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 02 0F B6 45 0C 50 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 19 8B 55 14 52 8B 45 10 50 0F B6 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_22_249_0 {
	meta:
		name = "?TryPop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@H@Z"
		size = 160
		refs = "0027 ?Pop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ 0085 ?Claim@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE_NPAPAV_UnrealizedChore@34@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 4D 08 2B 48 0C 89 4D 08 8B 55 FC 8B 42 04 83 E8 01 39 45 08 75 0A 8B 4D FC E8 ?? ?? ?? ?? EB 6D 8B 4D FC 8B 51 04 39 55 08 7D 0A 8B 45 FC 8B 08 39 4D 08 7D 04 33 C0 EB 54 33 D2 8B 45 FC 8B 4D 08 23 48 08 8B 45 FC 8B 40 1C 8D 0C 88 87 11 89 55 F8 8B 55 F8 83 E2 01 74 30 8B 45 F8 83 E0 FE 89 45 F8 6A 00 8B 4D FC 8B 55 08 23 51 08 8B 45 FC 8B 48 20 8D 0C D1 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 07 B8 01 00 00 00 EB 03 8B 45 F8 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_250_0 {
	meta:
		name = "?TryPopUnstructured@ContextBase@details@Concurrency@@QAEPAV_UnrealizedChore@23@H@Z"
		size = 91
		refs = "0013 ??_C@_1CE@MFPOBKIK@?$AAm?$AA_?$AAp?$AAW?$AAo?$AAr?$AAk?$AAQ?$AAu?$AAe?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0018 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0024 ??_C@_1GA@BONIEFMP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 002b __CrtDbgReportW 004b ?TryPopUnstructured@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@H@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 78 20 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 2F 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 8B 4D 08 51 8B 55 FC 8B 4A 20 E8 ?? ?? ?? ?? 89 45 F8 8B 45 F8 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_252_0 {
	meta:
		name = "?UnlockedAddTail@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
		size = 89
		refs = "000e ?_HasWriteLock@_ReaderWriterLock@details@Concurrency@@QBE_NXZ 001a ??_C@_1CO@HMDDABFP@?$AAm?$AA_?$AAl?$AAo?$AAc?$AAk?$AA?4?$AA_?$AAH?$AAa?$AAs?$AAW?$AAr?$AAi?$AAt?$AAe?$AAL?$AAo?$AAc?$AAk?$AA?$CI?$AA?$CJ?$AA?$AA@ 001f ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 002b ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0032 __CrtDbgReportW 004f ?AddTail@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 59 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C4 33 C0 75 C0 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_253_0 {
	meta:
		name = "?UnlockedRemove@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
		size = 89
		refs = "000e ?_HasWriteLock@_ReaderWriterLock@details@Concurrency@@QBE_NXZ 001a ??_C@_1CO@HMDDABFP@?$AAm?$AA_?$AAl?$AAo?$AAc?$AAk?$AA?4?$AA_?$AAH?$AAa?$AAs?$AAW?$AAr?$AAi?$AAt?$AAe?$AAL?$AAo?$AAc?$AAk?$AA?$CI?$AA?$CJ?$AA?$AA@ 001f ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 002b ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0032 __CrtDbgReportW 004f ?Remove@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAUListEntry@23@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 7B 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C4 33 C0 75 C0 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_764_509_0 {
	meta:
		name = "?UnlockedRemove@?$SafeRWList@UBoostedObject@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEXPAUBoostedObject@23@@Z"
		size = 89
		refs = "000e ?_HasWriteLock@_ReaderWriterLock@details@Concurrency@@QBE_NXZ 001a ??_C@_1CO@HMDDABFP@?$AAm?$AA_?$AAl?$AAo?$AAc?$AAk?$AA?4?$AA_?$AAH?$AAa?$AAs?$AAW?$AAr?$AAi?$AAt?$AAe?$AAL?$AAo?$AAc?$AAk?$AA?$CI?$AA?$CJ?$AA?$AA@ 001f ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 002b ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0032 __CrtDbgReportW 004f ?Remove@?$List@UBoostedObject@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAUBoostedObject@23@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 7B 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 C4 33 C0 75 C0 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_254_0 {
	meta:
		name = "?Wipe@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEXXZ"
		size = 137
		refs = "0050 ?FreeNode@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAXPAUListNode@123@@Z 007e _memset"
	strings:
		$1 = { 55 8B EC 83 EC 10 89 4D FC 8B 45 FC 83 78 04 00 7E 73 C7 45 F8 00 00 00 00 EB 09 8B 4D F8 83 C1 01 89 4D F8 8B 55 FC 8B 45 F8 3B 02 7D 33 8B 4D FC 8B 51 08 8B 45 F8 8B 0C 82 89 4D F4 83 7D F4 00 74 1C 8B 55 F4 8B 02 89 45 F0 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F0 89 55 F4 EB DE EB BA 8B 45 FC C7 40 04 00 00 00 00 8B 4D FC 8B 11 C1 E2 02 52 6A 00 8B 45 FC 8B 48 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_680_104_0 {
	meta:
		name = "?Wipe@?$Hash@II@details@Concurrency@@QAEXXZ"
		size = 137
		refs = "0050 ?FreeNode@?$Hash@II@details@Concurrency@@CAXPAUListNode@123@@Z 007e _memset"
	strings:
		$1 = { 55 8B EC 83 EC 10 89 4D FC 8B 45 FC 83 78 04 00 7E 73 C7 45 F8 00 00 00 00 EB 09 8B 4D F8 83 C1 01 89 4D F8 8B 55 FC 8B 45 F8 3B 02 7D 33 8B 4D FC 8B 51 08 8B 45 F8 8B 0C 82 89 4D F4 83 7D F4 00 74 1C 8B 55 F4 8B 02 89 45 F0 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F0 89 55 F4 EB DE EB BA 8B 45 FC C7 40 04 00 00 00 00 8B 4D FC 8B 11 C1 E2 02 52 6A 00 8B 45 FC 8B 48 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_255_0 {
	meta:
		name = "?_Assign@cancellation_token_source@Concurrency@@AAEXPAV_CancellationTokenState@details@2@@Z"
		size = 35
		refs = "0011 ?_Reference@_RefCounter@details@Concurrency@@QAEJXZ"
		altNames = "?_Assign@cancellation_token@Concurrency@@AAEXPAV_CancellationTokenState@details@2@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 83 7D 08 00 74 08 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 FC 8B 4D 08 89 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_256_0 {
	meta:
		name = "?_Assign@location@Concurrency@@QAEXABV12@@Z"
		size = 118
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 8B 08 81 E1 FF FF FF 0F 81 E1 FF FF FF 0F 8B 55 FC 8B 02 25 00 00 00 F0 0B C1 8B 4D FC 89 01 8B 55 08 8B 02 C1 E8 1C 83 E0 0F 83 E0 0F C1 E0 1C 8B 4D FC 8B 11 81 E2 FF FF FF 0F 0B D0 8B 45 FC 89 10 8B 4D FC 8B 55 08 8B 42 08 89 41 08 8B 4D FC 8B 55 08 8B 42 04 89 41 04 8B 4D FC 8B 55 08 8B 42 0C 89 41 0C 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_257_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_cc1ad237c7bfd08e976271b7ef21d484>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_cc1ad237c7bfd08e976271b7ef21d484>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_1193_50_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_81d371fc01b40673f0490940e39831c0>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_81d371fc01b40673f0490940e39831c0>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_1026_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_69eedd166b4583258960a1f5e9f62c48>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_69eedd166b4583258960a1f5e9f62c48>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_824_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_06a0139f026c74e03afdcc6082f60aac>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_06a0139f026c74e03afdcc6082f60aac>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_70_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_8f377ca82cfd4b42b40e48b104e4ec63>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_8f377ca82cfd4b42b40e48b104e4ec63>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_63_70_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_9002ae328e3e6a2d3e065e7883200ba0>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_9002ae328e3e6a2d3e065e7883200ba0>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_14_111_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_dada0fdf05a893ca97ffdd530586f87d>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_dada0fdf05a893ca97ffdd530586f87d>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_1394_44_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_546ccdbee738e5ae475ce35bb6dfd2da>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_546ccdbee738e5ae475ce35bb6dfd2da>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_1372_72_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_5382000b51713ec16341e6ec71bc1756>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_5382000b51713ec16341e6ec71bc1756>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_1338_143_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_788d01eb0d0374e607cdb40909073f54>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_788d01eb0d0374e607cdb40909073f54>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_1337_48_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_dddd8b2ab1c9c61ddd5ee9c3ebbdfb0b>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_dddd8b2ab1c9c61ddd5ee9c3ebbdfb0b>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_107_73_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_2b713482b066b07477c65b1d3db9e4fe>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_2b713482b066b07477c65b1d3db9e4fe>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_1151_169_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_cc134c257bbce6f938b0c78f35e6542f>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_cc134c257bbce6f938b0c78f35e6542f>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_1142_42_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_587f4439f8b00b235a16f2015ba5f83a>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_587f4439f8b00b235a16f2015ba5f83a>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_1099_150_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_a96f00355e2f588f01331dab094e3fa3>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_a96f00355e2f588f01331dab094e3fa3>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_1094_34_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_443e82f9a5898d6099a11bea7914b6e4>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_443e82f9a5898d6099a11bea7914b6e4>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_1083_73_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_3e5069a54270a4e30c08b6dcc89cc064>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_3e5069a54270a4e30c08b6dcc89cc064>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_1069_35_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_35277a475a06886fa9db6d8f524a6afb>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_35277a475a06886fa9db6d8f524a6afb>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_1064_62_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_a44e2c6a2c6414cd8c2722187381ebe2>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_a44e2c6a2c6414cd8c2722187381ebe2>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_1006_55_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_cd9c5d0064582a2422f30a48d7f8354e>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_cd9c5d0064582a2422f30a48d7f8354e>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_977_28_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_c88c96d0bdfc6b4fa9effa8b4c25b522>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_c88c96d0bdfc6b4fa9effa8b4c25b522>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_105_70_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_8f377ca82cfd4b42b40e48b104e4ec63>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_8f377ca82cfd4b42b40e48b104e4ec63>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_109_91_3 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_2b713482b066b07477c65b1d3db9e4fe>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_2b713482b066b07477c65b1d3db9e4fe>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_106_28_3 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_0d73c2d48883c7601f34bcb22cc05f0c>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_0d73c2d48883c7601f34bcb22cc05f0c>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_99_35_3 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_a303d7d328d5a211509236ec93d6c3fc>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_a303d7d328d5a211509236ec93d6c3fc>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_51_129_3 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_dada0fdf05a893ca97ffdd530586f87d>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_dada0fdf05a893ca97ffdd530586f87d>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_824_3 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_06a0139f026c74e03afdcc6082f60aac>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_06a0139f026c74e03afdcc6082f60aac>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_1113_3 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_69eedd166b4583258960a1f5e9f62c48>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_69eedd166b4583258960a1f5e9f62c48>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_26_88_3 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_9002ae328e3e6a2d3e065e7883200ba0>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_9002ae328e3e6a2d3e065e7883200ba0>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_70_3 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_8f377ca82cfd4b42b40e48b104e4ec63>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_8f377ca82cfd4b42b40e48b104e4ec63>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_1099_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_69eedd166b4583258960a1f5e9f62c48>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_69eedd166b4583258960a1f5e9f62c48>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_949_40_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_02f882f6a7b42b22144cab4627e71adf>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_02f882f6a7b42b22144cab4627e71adf>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_103_90_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_2b713482b066b07477c65b1d3db9e4fe>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_2b713482b066b07477c65b1d3db9e4fe>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_101_128_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_dada0fdf05a893ca97ffdd530586f87d>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_dada0fdf05a893ca97ffdd530586f87d>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_95_28_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_0d73c2d48883c7601f34bcb22cc05f0c>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_0d73c2d48883c7601f34bcb22cc05f0c>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_824_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_06a0139f026c74e03afdcc6082f60aac>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_06a0139f026c74e03afdcc6082f60aac>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_58_35_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_a303d7d328d5a211509236ec93d6c3fc>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_a303d7d328d5a211509236ec93d6c3fc>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_87_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_9002ae328e3e6a2d3e065e7883200ba0>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_9002ae328e3e6a2d3e065e7883200ba0>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_124_35_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_a303d7d328d5a211509236ec93d6c3fc>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_a303d7d328d5a211509236ec93d6c3fc>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_108_28_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_0d73c2d48883c7601f34bcb22cc05f0c>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_0d73c2d48883c7601f34bcb22cc05f0c>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_75_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_61c98ca37ac2cbc78c0f8d0a7145adc0>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_61c98ca37ac2cbc78c0f8d0a7145adc0>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_475_46_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_ea0db563586c7064b5330fcbb2f0152a>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_ea0db563586c7064b5330fcbb2f0152a>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_429_106_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_28202255cf58dc7ad4a724b7391109d0>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_28202255cf58dc7ad4a724b7391109d0>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_362_57_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_e0e14258223a14a2912ae403a2c6d6d2>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_e0e14258223a14a2912ae403a2c6d6d2>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_323_75_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_a283ce1ec5912026183788b72aa64e2d>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_a283ce1ec5912026183788b72aa64e2d>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_308_29_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_75c9db8a8ff6fa987ae1bd09fecf9472>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_75c9db8a8ff6fa987ae1bd09fecf9472>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_292_64_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_3a6929bbb4f8d28f9309e40510d068b6>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_3a6929bbb4f8d28f9309e40510d068b6>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_289_57_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_a04c64dcff2c459f0461385811dc9c5c>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_a04c64dcff2c459f0461385811dc9c5c>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_278_82_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_abe074cb5b24d359ce02dba697c02c84>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_abe074cb5b24d359ce02dba697c02c84>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_267_59_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_a6bc449bbf558c532502fc096c54e309>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_a6bc449bbf558c532502fc096c54e309>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_499_126_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_168ca60959a58f6a992bd27e88b9e5a1>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_168ca60959a58f6a992bd27e88b9e5a1>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_173_249_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_dd12972b160190a7993b1b13863703a9>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_dd12972b160190a7993b1b13863703a9>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_162_107_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_398f2c862cf055c2bd39c6b24098fe73>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_398f2c862cf055c2bd39c6b24098fe73>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_157_56_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_2c491e211f569780d465216fb7768b85>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_2c491e211f569780d465216fb7768b85>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_149_194_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_d02c6b568736c99f116746121d93a1c0>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_d02c6b568736c99f116746121d93a1c0>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_136_44_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_f19b223c80dc4e3e00dbaaf7651a6f60>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_f19b223c80dc4e3e00dbaaf7651a6f60>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_128_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_1454250350d62018defd506422d5e520>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_1454250350d62018defd506422d5e520>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_109_60_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_598a44b1ce407625c16ee2daaffae87c>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_598a44b1ce407625c16ee2daaffae87c>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_138_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_db0252affb69d6920f312c7cd8bb71ee>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_db0252affb69d6920f312c7cd8bb71ee>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_686_153_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_107d1dfecaf7b53f805e7da1cb6adbf0>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_107d1dfecaf7b53f805e7da1cb6adbf0>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_927_67_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_eb7cad34ddb9e92c99e1e255c42b9e08>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_eb7cad34ddb9e92c99e1e255c42b9e08>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_922_54_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_20cc19441c5432c87ae7ea342ba39106>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_20cc19441c5432c87ae7ea342ba39106>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_883_49_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_482a0419c2e79137f2a1fc85b7ae2b8a>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_482a0419c2e79137f2a1fc85b7ae2b8a>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_851_47_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_0cb5d881bcf47953acd3701e03ce69ac>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_0cb5d881bcf47953acd3701e03ce69ac>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_845_48_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_7661b33d842cc74a6df3b75ba8c763e0>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_7661b33d842cc74a6df3b75ba8c763e0>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_828_35_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_60992fec7158c51d16f5f657f29a9f74>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_60992fec7158c51d16f5f657f29a9f74>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_764_522_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_92aa929a7c8ca2abbf2731d5d404a0cd>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_92aa929a7c8ca2abbf2731d5d404a0cd>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_744_273_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_c9d7e137e0fae9b640051ed66675861e>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_c9d7e137e0fae9b640051ed66675861e>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_719_85_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_31750afef8a18df9f55577ac42d65fd6>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_31750afef8a18df9f55577ac42d65fd6>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_86_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_7b21429dfb702ab749ad8dc0a410cfb8>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_7b21429dfb702ab749ad8dc0a410cfb8>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_680_106_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_f642c352163eec99dbcf090fe44b05ec>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_f642c352163eec99dbcf090fe44b05ec>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_671_44_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_afc3b3591c712c5a921b6812735b96aa>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_afc3b3591c712c5a921b6812735b96aa>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_638_68_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_dfd79cf35e198e8575b3f824a5fd97d0>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_dfd79cf35e198e8575b3f824a5fd97d0>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_611_98_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_9a0a8d6e674e333c6e850f322d63d6d3>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_9a0a8d6e674e333c6e850f322d63d6d3>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_542_43_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_94c975ff77b1a00c5ab38394923e5941>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_94c975ff77b1a00c5ab38394923e5941>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_524_36_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_b535e720638a5960fdc1384fc2e4f8c6>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_b535e720638a5960fdc1384fc2e4f8c6>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_517_77_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_83563de9ae34d00953ac46d983c86978>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_83563de9ae34d00953ac46d983c86978>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_512_50_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 188
		refs = "0006 __ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0015 ___security_cookie 0034 ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 0043 ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ 0059 ??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 006c ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z 0078 ??1scoped_lock@critical_section@Concurrency@@QAE@XZ 0085 ??$for_each@V<lambda_1846ad6ef66d11cae48b45e4c3298f80>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXV<lambda_1846ad6ef66d11cae48b45e4c3298f80>@@@Z 009a ?set@event@Concurrency@@QAEXXZ 00a9 ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 2C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 6A 00 6A 01 8B 45 EC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6E 8D 4D E4 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D EC 83 C1 34 51 8D 4D C8 E8 ?? ?? ?? ?? C6 45 FC 01 8D 55 E4 52 8B 4D EC 83 C1 54 E8 ?? ?? ?? ?? C6 45 FC 00 8D 4D C8 E8 ?? ?? ?? ?? 0F B6 45 F3 50 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D EC C7 41 08 02 00 00 00 8B 4D EC 83 C1 0C E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_260_0 {
	meta:
		name = "__ehhandler$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Cancel@_CancellationTokenState@details@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_674_2 {
	meta:
		name = "__ehhandler$??0?$vector@PAXV?$allocator@PAX@std@@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$vector@PAXV?$allocator@PAX@std@@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_207_0 {
	meta:
		name = "__ehhandler$?AllocateSegment@FairScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AllocateSegment@FairScheduleGroup@details@Concurrency@@MAEPAVScheduleGroupSegmentBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_744_118_0 {
	meta:
		name = "__ehhandler$?CreateSingleton@ResourceManager@details@Concurrency@@SAPAV123@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateSingleton@ResourceManager@details@Concurrency@@SAPAV123@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_744_137_0 {
	meta:
		name = "__ehhandler$?DynamicResourceManager@ResourceManager@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?DynamicResourceManager@ResourceManager@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_50_0 {
	meta:
		name = "__ehhandler$?Initialize@UMSThreadVirtualProcessor@details@Concurrency@@MAEXPAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Initialize@UMSThreadVirtualProcessor@details@Concurrency@@MAEXPAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_686_151_0 {
	meta:
		name = "__ehhandler$?_Alias@_TaskCollection@details@Concurrency@@AAEPAV123@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Alias@_TaskCollection@details@Concurrency@@AAEPAV123@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_1396_1 {
	meta:
		name = "__ehhandler$?_Throw_future_error@std@@YAXABVerror_code@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Throw_future_error@std@@YAXABVerror_code@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_1245_1 {
	meta:
		name = "__ehhandler$?link_target@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?link_target@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_1248_3 {
	meta:
		name = "__ehhandler$?link_target@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?link_target@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_1251_2 {
	meta:
		name = "__ehhandler$?link_target@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?link_target@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_162_136_0 {
	meta:
		name = "__ehhandler$?notify_one@_Condition_variable@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?notify_one@_Condition_variable@details@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_1280_3 {
	meta:
		name = "__ehhandler$?propagate_message@?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@MAE?AW4message_status@2@PAV?$message@W4agent_status@Concurrency@@@2@PAV?$ISource@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?propagate_message@?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@MAE?AW4message_status@2@PAV?$message@W4agent_status@Concurrency@@@2@PAV?$ISource@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_1349_3 {
	meta:
		name = "__ehhandler$?remove@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE_NPAV?$ISource@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?remove@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE_NPAV?$ISource@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_1352_3 {
	meta:
		name = "__ehhandler$?remove@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE_NPAV?$ISource@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?remove@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE_NPAV?$ISource@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_162_139_0 {
	meta:
		name = "__ehhandler$?reset@event@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?reset@event@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_1437_2 {
	meta:
		name = "__ehhandler$?unlink_target@?$_SyncOriginator@I@details@Concurrency@@UAEXPAV?$ITarget@I@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_target@?$_SyncOriginator@I@details@Concurrency@@UAEXPAV?$ITarget@I@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_1440_2 {
	meta:
		name = "__ehhandler$?unlink_target@?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_target@?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_1443_2 {
	meta:
		name = "__ehhandler$?unlink_target@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_target@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_1446_2 {
	meta:
		name = "__ehhandler$?unlink_target@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_target@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_1449_2 {
	meta:
		name = "__ehhandler$?unlink_target@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?unlink_target@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_261_0 {
	meta:
		name = "?_CancelState@_TaskCollectionBase@details@Concurrency@@IBEIXZ"
		size = 20
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 18 83 E0 03 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_262_0 {
	meta:
		name = "?_Confirm_cancel@_Cancellation_beacon@details@Concurrency@@QAE_NXZ"
		size = 57
		refs = "000a ?CurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 001b ?ConfirmCancel@ContextBase@details@Concurrency@@QAE_NPAU_Beacon_reference@23@@Z 002e ?_Lower@_Cancellation_beacon@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F8 E8 ?? ?? ?? ?? 89 45 F4 8B 45 F8 8B 08 51 8B 4D F4 E8 ?? ?? ?? ?? 88 45 FF 0F B6 55 FF 85 D2 75 08 8B 4D F8 E8 ?? ?? ?? ?? 8A 45 FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_263_0 {
	meta:
		name = "?_DoYield@?$_SpinWait@$00@details@Concurrency@@IAEXXZ"
		size = 88
		refs = "001f ??_C@_1CM@DGAKBIOO@?$AA_?$AAM?$AA_?$AAy?$AAi?$AAe?$AAl?$AAd?$AAF?$AAu?$AAn?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0024 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0030 ??_C@_1EI@DEEFKHGN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAh?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr@ 0037 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 C6 45 FF 01 0F B6 45 FF 85 C0 74 3D 8B 4D F8 83 79 0C 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 D8 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CD 8B 4D F8 8B 51 0C FF D2 EB 02 F3 90 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_264_0 {
	meta:
		name = "?_DoYield@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ"
		size = 88
		refs = "001f ??_C@_1CM@DGAKBIOO@?$AA_?$AAM?$AA_?$AAy?$AAi?$AAe?$AAl?$AAd?$AAF?$AAu?$AAn?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0024 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0030 ??_C@_1EI@DEEFKHGN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAh?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr@ 0037 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 C6 45 FF 00 0F B6 45 FF 85 C0 74 3D 8B 4D F8 83 79 0C 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 D8 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CD 8B 4D F8 8B 51 0C FF D2 EB 02 F3 90 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_266_0 {
	meta:
		name = "?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ"
		size = 73
		refs = "001a ?IsInsideCriticalRegion@ContextBase@details@Concurrency@@QBE_NXZ 002b ??_C@_0DG@CNBNCCDL@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0030 ??_C@_0DJ@FICHJDBF@_m_pVirtualProcessor?5?$DN?$DN?5NULL?5?$HM?$HM?5@ 0035 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 B8 A0 00 00 00 00 74 29 8B 4D FC 83 C1 04 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 17 68 E8 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 FC 8B 82 A0 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_267_0 {
	meta:
		name = "?_HasWriteLock@_ReaderWriterLock@details@Concurrency@@QBE_NXZ"
		size = 40
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 83 38 FF 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_268_0 {
	meta:
		name = "?_InliningDepth@_TaskCollectionBase@details@Concurrency@@QBEHXZ"
		size = 23
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 04 C1 E0 04 C1 F8 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_269_0 {
	meta:
		name = "?_Invoke@_CancellationTokenRegistration@details@Concurrency@@AAEXXZ"
		size = 159
		refs = "000a ?GetCurrentThreadId@platform@details@Concurrency@@YAJXZ 001a ??_C@_1CC@DDKOAOPH@?$AA?$CI?$AAt?$AAi?$AAd?$AA?5?$AA?$CG?$AA?5?$AA0?$AAx?$AA3?$AA?$CJ?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 001f ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 002b ??_C@_1GG@BBNGEAJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAh?$AA?2?$AAp?$AAp?$AAl?$AAc?$AAa@ 0032 __CrtDbgReportW 004d ?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z 008f ?set@event@Concurrency@@QAEXXZ 0097 ?_Release@_RefCounter@details@Concurrency@@QAEJXZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC E8 ?? ?? ?? ?? 89 45 F8 8B 45 F8 83 E0 03 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 8F 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 6A 00 8B 55 F8 52 8B 45 FC 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 83 7D F4 00 75 36 8B 4D FC 8B 11 8B 4D FC 8B 42 08 FF D0 8B 4D F8 51 6A 03 8B 55 FC 83 C2 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 83 7D F4 02 75 0B 8B 45 FC 8B 48 0C E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_270_0 {
	meta:
		name = "?_IsCanceled@_CancellationTokenState@details@Concurrency@@QBE_NXZ"
		size = 41
		altNames = "?IsAvailable@VirtualProcessor@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 83 78 08 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_271_0 {
	meta:
		name = "?_IsCurrentlyInlined@_TaskCollectionBase@details@Concurrency@@QBE_NXZ"
		size = 49
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 48 04 C1 E1 04 C1 F9 04 83 F9 FF 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_272_0 {
	meta:
		name = "?_IsEnabled@_CONCRT_TRACE_INFO@details@Concurrency@@QBE_NEK@Z"
		size = 62
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 0F B6 45 08 8B 4D FC 0F B6 51 04 3B C2 7F 16 8B 45 FC 8B 08 23 4D 0C 3B 4D 0C 75 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8A 45 F8 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_22_274_0 {
	meta:
		name = "?_IsLockHeld@_NonReentrantLock@details@Concurrency@@QBE_NXZ"
		size = 40
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 83 38 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_275_0 {
	meta:
		name = "?_IsMarkedForCancellation@_TaskCollectionBase@details@Concurrency@@IBE_NXZ"
		size = 45
		refs = "000d ?_CancelState@_TaskCollectionBase@details@Concurrency@@IBEIXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 4D F8 E8 ?? ?? ?? ?? 83 E0 03 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_276_0 {
	meta:
		name = "?_IsStructured@_TaskCollectionBase@details@Concurrency@@QAE_NXZ"
		size = 49
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 48 04 C1 E1 00 C1 F9 1C 83 E1 01 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_277_0 {
	meta:
		name = "?_Is_system@location@Concurrency@@QBE_NXZ"
		size = 45
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 81 E1 FF FF FF 0F 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_278_0 {
	meta:
		name = "?_Lower@_Cancellation_beacon@details@Concurrency@@QAEXXZ"
		size = 23
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 83 CA FF F0 0F C1 11 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_280_0 {
	meta:
		name = "?_NumberOfSpins@?$_SpinWait@$00@details@Concurrency@@IAEKXZ"
		size = 16
		altNames = "?GetContextKind@ThreadInternalContext@details@Concurrency@@UBE?AW4ContextKind@ContextBase@23@XZ ?_Getfalse@_Locinfo@std@@QBEPBDXZ ?_Gettrue@_Locinfo@std@@QBEPBDXZ ?_NumberOfSpins@?$_SpinWait@$0A@@details@Concurrency@@IAEKXZ ?_Target_type@?$_Func_impl@U?$_Callable_obj@P6A_NABW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NABW4agent_status@Concurrency@@@std@@@2@_NABW4agent_status@Concurrency@@@std@@UBEABVtype_info@@XZ ?do_encoding@codecvt_base@std@@MBEHXZ ?do_max_length@codecvt_base@std@@MBEHXZ ?length@charNode@@UBEHXZ ?name@_Future_error_category@std@@UBEPBDXZ ?name@_Generic_error_category@std@@UBEPBDXZ ?name@_Iostream_error_category@std@@UBEPBDXZ ?name@_System_error_category@std@@UBEPBDXZ ?what@bad_function_call@std@@UBEPBDXZ ?what@bad_weak_ptr@std@@UBEPBDXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_282_0 {
	meta:
		name = "?_Reference@_RefCounter@details@Concurrency@@QAEJXZ"
		size = 76
		refs = "0023 ??_C@_1BM@LPMPGBJF@?$AA_?$AAR?$AAe?$AAf?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA1?$AA?$AA@ 0028 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0031 ??_C@_1GG@BBNGEAJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAh?$AA?2?$AAp?$AAp?$AAl?$AAc?$AAa@ 0038 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 83 C0 04 B9 01 00 00 00 F0 0F C1 08 41 89 4D FC 83 7D FC 01 7F 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 41 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_283_0 {
	meta:
		name = "?_Release@_RefCounter@details@Concurrency@@QAEJXZ"
		size = 89
		refs = "001d ??_C@_1BO@OJJMJNDL@?$AA_?$AAR?$AAe?$AAf?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0022 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 002b ??_C@_1GG@BBNGEAJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAh?$AA?2?$AAp?$AAp?$AAl?$AAc?$AAa@ 0032 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 C0 04 83 C9 FF F0 0F C1 08 49 89 4D F8 79 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 4A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 0D 8B 45 FC 8B 10 8B 4D FC 8B 42 04 FF D0 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_284_0 {
	meta:
		name = "?_Reset@?$_SpinWait@$00@details@Concurrency@@IAEXXZ"
		size = 86
		refs = "0012 ?_Value@_SpinCount@details@Concurrency@@SAIXZ 001b ?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QAEXI@Z 0029 ??_C@_1DE@BFFKFMDD@?$AA_?$AAM?$AA_?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAS?$AAt?$AAa?$AAt?$AAe?$AAI?$AAn?$AAi?$AAt?$AAi?$AAa?$AAl?$AA?$AA@ 002e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 003a ??_C@_1EI@DEEFKHGN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAh?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr@ 0041 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 40 08 00 00 00 00 E8 ?? ?? ?? ?? 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 83 79 08 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 ED 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CD 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_285_0 {
	meta:
		name = "?_Reset@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ"
		size = 86
		refs = "0012 ?_Value@_SpinCount@details@Concurrency@@SAIXZ 001b ?_SetSpinCount@?$_SpinWait@$0A@@details@Concurrency@@QAEXI@Z 0029 ??_C@_1DE@BFFKFMDD@?$AA_?$AAM?$AA_?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAS?$AAt?$AAa?$AAt?$AAe?$AAI?$AAn?$AAi?$AAt?$AAi?$AAa?$AAl?$AA?$AA@ 002e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 003a ??_C@_1EI@DEEFKHGN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAh?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr@ 0041 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 40 08 00 00 00 00 E8 ?? ?? ?? ?? 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 83 79 08 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 ED 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CD 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_286_0 {
	meta:
		name = "?_SafeGetParent@_TaskCollectionBase@details@Concurrency@@IAEPAV123@XZ"
		size = 50
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 04 C1 E1 04 C1 F9 04 83 F9 FF 74 0A 8B 55 FC 8B 02 89 45 F8 EB 07 C7 45 F8 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_287_0 {
	meta:
		name = "?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QAEXI@Z"
		size = 110
		refs = "0011 ??_C@_1DE@FNIGIOLJ@?$AA_?$AAM?$AA_?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAS?$AAt?$AAa?$AAt?$AAe?$AAI?$AAn?$AAi?$AAt?$AAi?$AAa?$AAl?$AA?$AA@ 0016 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0022 ??_C@_1EI@DEEFKHGN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAh?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr@ 0029 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 78 08 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 72 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 83 7D 08 00 75 0C 8B 45 FC C7 40 08 04 00 00 00 EB 1C 8B 4D FC 8B 55 08 89 11 8B 45 FC C7 40 04 01 00 00 00 8B 4D FC C7 41 08 01 00 00 00 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_288_0 {
	meta:
		name = "?_SetSpinCount@?$_SpinWait@$0A@@details@Concurrency@@QAEXI@Z"
		size = 110
		refs = "0011 ??_C@_1DE@FNIGIOLJ@?$AA_?$AAM?$AA_?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAS?$AAt?$AAa?$AAt?$AAe?$AAI?$AAn?$AAi?$AAt?$AAi?$AAa?$AAl?$AA?$AA@ 0016 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0022 ??_C@_1EI@DEEFKHGN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAh?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr@ 0029 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 78 08 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 72 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 83 7D 08 00 75 0C 8B 45 FC C7 40 08 04 00 00 00 EB 1C 8B 4D FC 8B 55 08 89 11 8B 45 FC C7 40 04 00 00 00 00 8B 4D FC C7 41 08 01 00 00 00 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_289_0 {
	meta:
		name = "?_ShouldSpinAgain@?$_SpinWait@$00@details@Concurrency@@IAE_NXZ"
		size = 57
		altNames = "?_ShouldSpinAgain@?$_SpinWait@$0A@@details@Concurrency@@IAE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 8B 08 83 E9 01 89 4D F8 8B 55 FC 8B 45 F8 89 02 83 7D F8 00 76 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8A 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_291_0 {
	meta:
		name = "?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
		size = 304
		refs = "0022 $LN24 002a ?_NumberOfSpins@?$_SpinWait@$00@details@Concurrency@@IAEKXZ 0053 ?_ShouldSpinAgain@?$_SpinWait@$00@details@Concurrency@@IAE_NXZ 0091 ??_C@_1CI@KMNHIHDG@?$AA_?$AAM?$AA_?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AAY?$AAi?$AAe?$AAl?$AAd?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0096 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00a2 ??_C@_1EI@DEEFKHGN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAh?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr@ 00a9 __CrtDbgReportW 00e3 ?_DoYield@?$_SpinWait@$00@details@Concurrency@@IAEXXZ 00ef ?_Reset@?$_SpinWait@$00@details@Concurrency@@IAEXXZ 010f ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ 011c $LN2 0120 $LN14 0124 $LN8 0128 $LN4 012c $LN3"
	strings:
		$1 = { 55 8B EC 83 EC 18 89 4D FC 8B 45 FC 8B 48 08 89 4D F4 83 7D F4 04 0F 87 F9 00 00 00 8B 55 F4 FF 24 95 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 89 45 E8 C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 3B 4D E8 73 04 F3 90 EB EB 8B 4D FC E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 22 8B 45 FC 83 78 04 00 75 09 C7 45 F0 03 00 00 00 EB 07 C7 45 F0 02 00 00 00 8B 4D FC 8B 55 F0 89 51 08 B0 01 E9 90 00 00 00 8B 45 FC 83 78 04 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 A2 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 8B 45 FC 8B 48 04 83 E9 01 89 4D EC 8B 55 FC 8B 45 EC 89 42 04 83 7D EC 00 75 0A 8B 4D FC C7 41 08 03 00 00 00 8B 4D FC E8 ?? ?? ?? ?? B0 01 EB 2C 8B 4D FC E8 ?? ?? ?? ?? 32 C0 EB 20 8B 4D FC E8 ?? ?? ?? ?? 32 C0 EB 14 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? EB 02 32 C0 8B E5 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_292_0 {
	meta:
		name = "?_SpinOnce@?$_SpinWait@$0A@@details@Concurrency@@QAE_NXZ"
		size = 304
		refs = "0022 $LN24 002a ?_NumberOfSpins@?$_SpinWait@$0A@@details@Concurrency@@IAEKXZ 0053 ?_ShouldSpinAgain@?$_SpinWait@$0A@@details@Concurrency@@IAE_NXZ 0091 ??_C@_1CI@KMNHIHDG@?$AA_?$AAM?$AA_?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AAY?$AAi?$AAe?$AAl?$AAd?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0096 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00a2 ??_C@_1EI@DEEFKHGN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAh?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr@ 00a9 __CrtDbgReportW 00e3 ?_DoYield@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ 00ef ?_Reset@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ 010f ?_SpinOnce@?$_SpinWait@$0A@@details@Concurrency@@QAE_NXZ 011c $LN2 0120 $LN14 0124 $LN8 0128 $LN4 012c $LN3"
	strings:
		$1 = { 55 8B EC 83 EC 18 89 4D FC 8B 45 FC 8B 48 08 89 4D F4 83 7D F4 04 0F 87 F9 00 00 00 8B 55 F4 FF 24 95 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 89 45 E8 C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 3B 4D E8 73 04 F3 90 EB EB 8B 4D FC E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 22 8B 45 FC 83 78 04 00 75 09 C7 45 F0 03 00 00 00 EB 07 C7 45 F0 02 00 00 00 8B 4D FC 8B 55 F0 89 51 08 B0 01 E9 90 00 00 00 8B 45 FC 83 78 04 00 77 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 A2 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 8B 45 FC 8B 48 04 83 E9 01 89 4D EC 8B 55 FC 8B 45 EC 89 42 04 83 7D EC 00 75 0A 8B 4D FC C7 41 08 03 00 00 00 8B 4D FC E8 ?? ?? ?? ?? B0 01 EB 2C 8B 4D FC E8 ?? ?? ?? ?? 32 C0 EB 20 8B 4D FC E8 ?? ?? ?? ?? 32 C0 EB 14 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? EB 02 32 C0 8B E5 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_293_0 {
	meta:
		name = "?atomic_compare_exchange@details@Concurrency@@YAJACJJJ@Z"
		size = 18
		altNames = "??$_CompareAndSwap@I@?$_Subatomic_impl@$03@details@Concurrency@@SAIACIII@Z ??$_CompareAndSwap@PAU_Segment_t@_Concurrent_vector_base_v4@details@Concurrency@@@?$_Subatomic_impl@$03@details@Concurrency@@SAPAU_Segment_t@_Concurrent_vector_base_v4@12@ACRAU3412@PAU3412@1@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 8B 55 08 8B 45 10 F0 0F B1 0A 5D C3 }
	condition:
		$1
}

rule file_22_295_0 {
	meta:
		name = "?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QAEXAAV1234@@Z"
		size = 51
		refs = "0010 ??$swap@PAU_Node@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@@std@@YAXAAPAU_Node@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@0@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 FC 83 C2 04 52 8B 45 08 83 C0 04 50 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_296_0 {
	meta:
		name = "_MemoryBarrier"
		size = 24
	strings:
		$1 = { 55 8B EC 83 EC 08 33 C0 8D 4D F8 89 4D FC 8B 55 FC F0 09 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "___common_dsinh_cout_rare"
		size = 1888
		refs = "0012 __vmldSinhHATab 00f9 _2il0floatpacket_88"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 53 83 EC 78 8B 4D 08 F2 0F 10 15 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 0F B7 59 06 81 E3 F0 7F 00 00 C1 EB 04 F2 0F 10 19 81 FB FF 07 00 00 0F B6 51 07 F2 0F 11 5C 24 70 0F 84 03 07 00 00 85 DB 0F 8E C5 06 00 00 8B CA 83 E1 7F F2 0F 11 5C 24 10 81 FB C9 03 00 00 88 4C 24 17 0F 8E 84 06 00 00 F2 0F 10 44 24 10 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 4B 06 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 EA 04 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 69 04 00 00 F2 0F 10 3D ?? ?? ?? ?? 25 0F 80 FF FF F2 0F 59 F8 83 E2 80 F2 0F 10 0D ?? ?? ?? ?? F2 0F 11 54 24 68 F2 0F 58 3D ?? ?? ?? ?? F2 0F 11 7C 24 50 F2 0F 10 64 24 50 8B 5C 24 50 8B F3 C1 EE 06 83 E3 3F C1 E3 04 F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 CC 8D 8E FF 03 00 00 0F 57 25 ?? ?? ?? ?? 81 C6 FE 03 00 00 F2 0F 59 25 ?? ?? ?? ?? F2 0F 5C C1 0F 28 D0 0F 28 D8 81 E6 FF 07 00 00 F7 D9 C1 E6 04 83 C1 FC 0B C6 81 E1 FF 07 00 00 66 89 44 24 6E 25 0F 80 FF FF C1 E1 04 F2 0F 58 D4 F2 0F 11 54 24 60 0B C1 F2 0F 10 6C 24 60 F2 0F 5C DD F2 0F 11 1C 24 F2 0F 10 6C 24 60 F2 0F 10 34 24 F2 0F 58 EE F2 0F 11 6C 24 08 F2 0F 10 3C 24 F2 0F 58 E7 F2 0F 11 24 24 F2 0F 10 64 24 08 F2 0F 5C C4 F2 0F 10 25 ?? ?? ?? ?? F2 0F 11 44 24 08 F2 0F 10 34 24 F2 0F 10 44 24 08 F2 0F 58 F0 F2 0F 11 74 24 08 F2 0F 10 74 24 60 0F 28 FE F2 0F 59 FC F2 0F 10 6C 24 08 F2 0F 11 7C 24 60 F2 0F 10 4C 24 60 F2 0F 11 74 24 10 F2 0F 5C CE F2 0F 11 0C 24 F2 0F 10 54 24 60 F2 0F 10 04 24 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C D0 F2 0F 11 54 24 60 0F 28 D6 F2 0F 59 D6 F2 0F 59 CA F2 0F 11 6C 24 18 0F 28 EE F2 0F 10 5C 24 60 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5C EB F2 0F 59 CA F2 0F 59 CE F2 0F 10 35 ?? ?? ?? ?? F2 0F 59 F2 F2 0F 11 2C 24 F2 0F 10 7C 24 60 F2 0F 10 04 24 F2 0F 11 44 24 28 F2 0F 10 83 ?? ?? ?? ?? F2 0F 10 5C 24 68 66 89 44 24 6E F2 0F 11 4C 24 30 F2 0F 59 C3 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F2 0F 28 E8 F2 0F 11 7C 24 20 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F2 F2 0F 10 93 ?? ?? ?? ?? F7 DB F2 0F 11 74 24 38 F2 0F 10 74 24 68 F2 0F 59 D3 F2 0F 10 8B ?? ?? ?? ?? F2 0F 59 CE F2 0F 10 9B ?? ?? ?? ?? F2 0F 5C E9 F2 0F 59 DE F2 0F 11 6C 24 60 0F 28 F0 F2 0F 10 7C 24 60 F2 0F 5C F7 F2 0F 5C F1 F2 0F 11 34 24 F2 0F 10 74 24 60 F2 0F 10 2C 24 0F 28 FE F2 0F 5C EB F2 0F 58 EA F2 0F 58 D3 F2 0F 58 FD F2 0F 11 7C 24 60 F2 0F 10 7C 24 60 F2 0F 5C F7 0F 28 F8 F2 0F 58 F9 F2 0F 58 F5 F2 0F 11 34 24 F2 0F 10 6C 24 60 F2 0F 10 34 24 F2 0F 11 7C 24 60 F2 0F 10 7C 24 60 F2 0F 5C C7 F2 0F 58 C1 F2 0F 11 04 24 F2 0F 10 7C 24 60 F2 0F 10 04 24 0F 28 CF F2 0F 58 D0 F2 0F 58 CA F2 0F 11 4C 24 60 F2 0F 10 5C 24 60 F2 0F 5C FB F2 0F 58 FA F2 0F 11 3C 24 F2 0F 10 7C 24 60 F2 0F 59 E7 0F 28 DF F2 0F 10 0C 24 F2 0F 11 64 24 60 F2 0F 10 64 24 60 F2 0F 5C E7 F2 0F 11 24 24 F2 0F 10 44 24 60 F2 0F 10 24 24 F2 0F 5C C4 F2 0F 11 44 24 60 F2 0F 10 54 24 60 F2 0F 5C DA F2 0F 11 1C 24 F2 0F 10 64 24 60 F2 0F 10 04 24 F2 0F 10 5C 24 18 F2 0F 11 44 24 48 0F 28 D3 F2 0F 11 64 24 40 0F 28 E1 F2 0F 10 44 24 30 F2 0F 59 D1 F2 0F 59 E0 F2 0F 59 C7 F2 0F 59 DF F2 0F 58 D4 0F 28 E6 0F 28 F8 F2 0F 59 64 24 38 F2 0F 58 D4 F2 0F 10 64 24 10 F2 0F 59 E1 F2 0F 58 D4 F2 0F 10 64 24 38 F2 0F 59 E5 F2 0F 58 D3 F2 0F 58 FC F2 0F 58 F2 F2 0F 11 7C 24 60 F2 0F 10 4C 24 60 F2 0F 10 5C 24 48 F2 0F 5C C1 F2 0F 10 4C 24 28 F2 0F 58 C4 F2 0F 11 04 24 0F 28 C1 F2 0F 10 64 24 60 F2 0F 10 14 24 F2 0F 59 C3 F2 0F 58 F2 F2 0F 10 7C 24 20 F2 0F 58 F0 F2 0F 59 DF F2 0F 10 54 24 40 F2 0F 58 F3 F2 0F 59 FA F2 0F 59 CA 0F 28 C7 F2 0F 58 F1 F2 0F 58 C4 F2 0F 11 44 24 60 0F 28 C5 F2 0F 10 4C 24 60 F2 0F 5C F9 F2 0F 58 FC F2 0F 11 3C 24 F2 0F 10 4C 24 60 F2 0F 10 3C 24 F2 0F 58 C1 F2 0F 58 F7 F2 0F 11 44 24 60 F2 0F 10 7C 24 60 F2 0F 5C EF F2 0F 58 E9 F2 0F 11 2C 24 F2 0F 10 44 24 60 F2 0F 10 2C 24 F2 0F 58 F5 F2 0F 58 F0 F2 0F 11 74 24 58 0F B6 44 24 5F 83 E0 7F 0B C2 8B 55 0C 88 44 24 5F 33 C0 F2 0F 10 74 24 58 F2 0F 11 32 83 C4 78 5B 5E 8B E5 5D C3 0F 28 D0 F2 0F 59 D0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CA 0F B6 74 24 77 83 E6 80 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA 8B 55 0C F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 C2 F2 0F 11 44 24 58 0F B6 44 24 5F 83 E0 7F 0B C6 88 44 24 5F 33 C0 F2 0F 10 44 24 58 F2 0F 11 02 83 C4 78 5B 5E 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 11 54 24 68 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 50 F2 0F 10 64 24 50 F2 0F 10 0D ?? ?? ?? ?? 8B 4C 24 50 8B D1 83 E2 3F F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 59 E3 F2 0F 5C C2 C1 E2 04 F2 0F 5C C4 F2 0F 59 C8 C1 E9 06 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 C1 FE 03 00 00 81 E1 FF 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 F9 FE 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 59 C8 F2 0F 58 C8 F2 0F 10 82 ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 8A ?? ?? ?? ?? F2 0F 58 C8 77 21 C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 6E F2 0F 10 44 24 68 F2 0F 59 C8 F2 0F 11 4C 24 58 EB 33 49 81 E1 FF 07 00 00 0F B7 44 24 6E C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 6E F2 0F 10 44 24 68 F2 0F 59 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 4C 24 58 0F B6 44 24 5F 0F B6 74 24 77 83 E0 7F 83 E6 80 8B 55 0C 0B C6 88 44 24 5F 33 C0 F2 0F 10 44 24 58 F2 0F 11 02 83 C4 78 5B 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C3 8B 45 0C F2 0F 11 00 B8 03 00 00 00 83 C4 78 5B 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? 8B 45 0C F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 11 00 33 C0 83 C4 78 5B 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 D8 F2 0F 11 5C 24 60 F2 0F 10 4C 24 60 8B 45 0C F2 0F 11 54 24 68 F2 0F 58 4C 24 70 F2 0F 11 08 33 C0 83 C4 78 5B 5E 8B E5 5D C3 8B 45 0C F2 0F 58 DB F2 0F 11 18 33 C0 83 C4 78 5B 5E 8B E5 5D C3 8D 49 00 }
	condition:
		$1
}

rule file_27_10_0 {
	meta:
		name = "??0?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@PAV_CriticalNonReentrantLock@12@@Z"
		size = 331
		refs = "0006 __ehhandler$??0?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@PAV_CriticalNonReentrantLock@12@@Z 0015 ___security_cookie 005e ??_C@_0DO@PDCHCLMC@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 006d ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 00b7 ??0Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ 00c4 ??_H@YGXPAXIHP6EPAX0@Z@Z 00fc _memset 010d ??_C@_1BK@KHMPIKPH@?$AAm?$AA_?$AAp?$AAL?$AAo?$AAc?$AAk?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0112 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 011b ??_C@_1HM@EKIAPBJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0122 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 1C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 8B 45 EC C7 00 00 00 00 00 8B 4D EC C7 41 04 00 00 00 00 8B 55 EC 8B 45 08 89 42 14 33 C9 75 FC 33 D2 75 F8 8B 45 EC C7 40 08 3F 00 00 00 33 C9 88 4D F3 6A 45 68 ?? ?? ?? ?? 0F B6 55 F3 52 68 00 01 00 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 8B 45 EC 8B 4D E0 89 48 0C 33 D2 88 55 F2 8D 45 F2 89 45 DC 6A 46 68 ?? ?? ?? ?? 8B 4D DC 0F B6 11 52 68 00 02 00 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 E8 C7 45 FC 00 00 00 00 83 7D E8 00 74 1A 68 ?? ?? ?? ?? 6A 40 6A 08 8B 45 E8 50 E8 ?? ?? ?? ?? 8B 4D E8 89 4D E4 EB 07 C7 45 E4 00 00 00 00 8B 55 E4 89 55 D8 C7 45 FC FF FF FF FF 8B 45 EC 8B 4D D8 89 48 10 68 00 01 00 00 6A 00 8B 55 EC 8B 42 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D EC 83 79 14 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 48 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 D0 33 C9 75 CC 8B 45 EC 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_11_0 {
	meta:
		name = "??0?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@PAV_HyperNonReentrantLock@12@@Z"
		size = 331
		refs = "0006 __ehhandler$??0?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@PAV_HyperNonReentrantLock@12@@Z 0015 ___security_cookie 005e ??_C@_0DO@PDCHCLMC@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 006d ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 00b7 ??0Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE@XZ 00c4 ??_H@YGXPAXIHP6EPAX0@Z@Z 00fc _memset 010d ??_C@_1BK@KHMPIKPH@?$AAm?$AA_?$AAp?$AAL?$AAo?$AAc?$AAk?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0112 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 011b ??_C@_1HM@EKIAPBJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0122 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 1C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 8B 45 EC C7 00 00 00 00 00 8B 4D EC C7 41 04 00 00 00 00 8B 55 EC 8B 45 08 89 42 14 33 C9 75 FC 33 D2 75 F8 8B 45 EC C7 40 08 3F 00 00 00 33 C9 88 4D F3 6A 45 68 ?? ?? ?? ?? 0F B6 55 F3 52 68 00 01 00 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 8B 45 EC 8B 4D E0 89 48 0C 33 D2 88 55 F2 8D 45 F2 89 45 DC 6A 46 68 ?? ?? ?? ?? 8B 4D DC 0F B6 11 52 68 00 02 00 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 E8 C7 45 FC 00 00 00 00 83 7D E8 00 74 1A 68 ?? ?? ?? ?? 6A 40 6A 08 8B 45 E8 50 E8 ?? ?? ?? ?? 8B 4D E8 89 4D E4 EB 07 C7 45 E4 00 00 00 00 8B 55 E4 89 55 D8 C7 45 FC FF FF FF FF 8B 45 EC 8B 4D D8 89 48 10 68 00 01 00 00 6A 00 8B 55 EC 8B 42 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D EC 83 79 14 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 48 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 D0 33 C9 75 CC 8B 45 EC 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_11_0 {
	meta:
		name = "__unwindfunclet$??0?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@PAV_CriticalNonReentrantLock@12@@Z$0"
		size = 27
		refs = "0003 ??_C@_0DO@PDCHCLMC@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0013 ??_V@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
		altNames = "__unwindfunclet$??0?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@PAV_HyperNonReentrantLock@12@@Z$0"
	strings:
		$1 = { 6A 46 68 ?? ?? ?? ?? 8B 45 DC 0F B6 00 50 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_27_13_0 {
	meta:
		name = "??0?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@PAV_CriticalNonReentrantLock@12@@Z"
		size = 298
		refs = "0006 __ehhandler$??0?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@PAV_CriticalNonReentrantLock@12@@Z 0015 ___security_cookie 003b ??_C@_1BK@KHMPIKPH@?$AAm?$AA_?$AAp?$AAL?$AAo?$AAc?$AAk?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0040 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0049 ??_C@_1GI@HCNFNBF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0050 __CrtDbgReportW 0071 ?Reinitialize@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXXZ 0087 ??_C@_0DE@KLEKJPBC@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0096 ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 00e0 ??0Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@XZ 00ed ??_H@YGXPAXIHP6EPAX0@Z@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 1C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D EC 8B 45 EC 8B 4D 08 89 48 10 8B 55 EC 83 7A 10 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 53 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 D0 33 D2 75 CC 33 C0 75 FC 33 C9 75 F8 8B 4D EC E8 ?? ?? ?? ?? 8B 55 EC C7 42 08 3F 00 00 00 33 C0 88 45 F3 6A 57 68 ?? ?? ?? ?? 0F B6 4D F3 51 68 00 01 00 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 8B 55 EC 8B 45 E0 89 42 1C 33 C9 88 4D F2 8D 55 F2 89 55 DC 6A 58 68 ?? ?? ?? ?? 8B 45 DC 0F B6 08 51 68 00 02 00 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 E8 C7 45 FC 00 00 00 00 83 7D E8 00 74 1A 68 ?? ?? ?? ?? 6A 40 6A 08 8B 55 E8 52 E8 ?? ?? ?? ?? 8B 45 E8 89 45 E4 EB 07 C7 45 E4 00 00 00 00 8B 4D E4 89 4D D8 C7 45 FC FF FF FF FF 8B 55 EC 8B 45 D8 89 42 20 8B 45 EC 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_14_0 {
	meta:
		name = "__unwindfunclet$??0?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@PAV_CriticalNonReentrantLock@12@@Z$0"
		size = 27
		refs = "0003 ??_C@_0DE@KLEKJPBC@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0013 ??_V@YAXPAXV_ConcRTNewMoniker@@PBDH@Z"
	strings:
		$1 = { 6A 58 68 ?? ?? ?? ?? 8B 45 DC 0F B6 00 50 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_27_18_0 {
	meta:
		name = "??0WorkQueue@details@Concurrency@@QAE@XZ"
		size = 168
		refs = "0006 __ehhandler$??0WorkQueue@details@Concurrency@@QAE@XZ 0013 ___security_cookie 0031 ??0?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@PAV_CriticalNonReentrantLock@12@@Z 005e ??0?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAE@PAV_CriticalNonReentrantLock@12@@Z 006d ??0_CriticalNonReentrantLock@details@Concurrency@@QAE@XZ 0085 ?GetNewWorkQueueId@SchedulerBase@details@Concurrency@@SAIXZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 83 C0 70 50 8B 4D F0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 C7 41 38 00 00 00 00 8B 55 F0 C7 42 48 00 00 00 00 8B 45 F0 83 C0 70 50 8B 4D F0 83 C1 4C E8 ?? ?? ?? ?? C6 45 FC 01 8B 4D F0 83 C1 70 E8 ?? ?? ?? ?? 8B 4D F0 C7 41 2C 00 00 00 00 8B 55 F0 8B 45 F0 89 42 34 E8 ?? ?? ?? ?? 8B 4D F0 89 41 40 C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_22_0 {
	meta:
		name = "??0_CriticalNonReentrantLock@details@Concurrency@@QAE@XZ"
		size = 22
		refs = "000b ??0_NonReentrantLock@details@Concurrency@@QAE@XZ"
		altNames = "??0_HyperNonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_238_2 {
	meta:
		name = "??0?$_Dynamic_array@PAV?$ISource@I@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 22
		refs = "000b ?_Init@?$_Dynamic_array@PAV?$ISource@I@Concurrency@@@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_239_2 {
	meta:
		name = "??0?$_Dynamic_array@PAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 22
		refs = "000b ?_Init@?$_Dynamic_array@PAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_240_2 {
	meta:
		name = "??0?$_Dynamic_array@PAV?$ITarget@I@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 22
		refs = "000b ?_Init@?$_Dynamic_array@PAV?$ITarget@I@Concurrency@@@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_241_2 {
	meta:
		name = "??0?$_Dynamic_array@PAV?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 22
		refs = "000b ?_Init@?$_Dynamic_array@PAV?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_31_30_2 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@DHPBDABDU_Iterator_base12@2@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_13_235_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@GHPBGABGU_Iterator_base12@2@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_539_2 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@PAXHPBQAXABQAXU_Iterator_base12@2@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_549_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@HPBV32@ABV32@U_Iterator_base12@2@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_550_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@HPBV32@ABV32@U_Iterator_base12@2@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_13_237_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@_WHPB_WAB_WU_Iterator_base12@2@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0_Iterator_base12@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_37_29_1 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0?$allocator@D@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_238_2 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0?$allocator@G@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_598_3 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@PAX@std@@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0?$allocator@PAX@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_599_3 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0?$allocator@U_Container_proxy@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_600_3 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_601_3 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_98_29_1 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0?$allocator@_W@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_659_3 {
	meta:
		name = "??0?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0?$_Ptr_base@U?$_Task_impl@E@details@Concurrency@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_663_3 {
	meta:
		name = "??0?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0?$_Ptr_base@U?$_Task_impl@_N@details@Concurrency@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_666_3 {
	meta:
		name = "??0?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0?$_Ptr_base@U_ExceptionHolder@details@Concurrency@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_151_42_0 {
	meta:
		name = "??0?$shared_ptr@V__ExceptionPtr@@@std@@QAE@XZ"
		size = 22
		refs = "000b ??0?$_Ptr_base@V__ExceptionPtr@@@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_676_3 {
	meta:
		name = "??0?$task@X@Concurrency@@QAE@XZ"
		size = 22
		refs = "000b ??0?$task@E@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_17_0 {
	meta:
		name = "??0SafePointMarker@details@Concurrency@@QAE@XZ"
		size = 22
		refs = "000b ?Reset@SafePointMarker@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_429_16_0 {
	meta:
		name = "??0_NonReentrantPPLLock@details@Concurrency@@QAE@XZ"
		size = 22
		refs = "000b ??0critical_section@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_965_3 {
	meta:
		name = "??E?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QAEAAV01@XZ"
		size = 22
		refs = "000b ??E?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QAEAAV01@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_886_1 {
	meta:
		name = "??E?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QAEAAV01@XZ"
		size = 22
		refs = "000b ??E?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QAEAAV01@XZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_19_147_2 {
	meta:
		name = "??E?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@XZ"
		size = 22
		refs = "000b ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_499_2 {
	meta:
		name = "??E?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QAEAAV01@XZ"
		size = 22
		refs = "000b ?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_500_2 {
	meta:
		name = "??E?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAEAAV01@XZ"
		size = 22
		refs = "000b ?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_49_0 {
	meta:
		name = "?ASIZE@QuickBitSet@details@Concurrency@@IBEIXZ"
		size = 22
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 00 83 C0 1F C1 E8 05 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_51_0 {
	meta:
		name = "?DeferToAffineSearchers@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QBE_NXZ"
		size = 134
		refs = "000a ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0040 ?HasSearchers@SchedulerBase@details@Concurrency@@QBE_NABVQuickBitSet@23@@Z 004f ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 0056 ?GetMaskId@VirtualProcessor@details@Concurrency@@QBEIXZ 0064 ?IsSet@QuickBitSet@details@Concurrency@@QBE_NI@Z"
		altNames = "?DeferToAffineSearchers@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 89 4D FC E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 0B 8B 45 F8 83 E8 04 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B 4D F4 89 4D EC 8B 55 FC 8B 02 83 C0 04 50 8B 4D FC 8B 11 8B 0A E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 2D 8B 4D EC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B 4D FC 8B 09 83 C1 04 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 09 C7 45 F0 01 00 00 00 EB 07 C7 45 F0 00 00 00 00 8A 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_57_0 {
	meta:
		name = "?GetMaskId@VirtualProcessor@details@Concurrency@@QBEIXZ"
		size = 20
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 80 90 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_60_0 {
	meta:
		name = "?HasSearchers@SchedulerBase@details@Concurrency@@QBE_NABVQuickBitSet@23@@Z"
		size = 28
		refs = "0012 ?Intersects@QuickBitSet@details@Concurrency@@QBE_NABV123@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC 83 C1 3C E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_61_0 {
	meta:
		name = "?Intersects@QuickBitSet@details@Concurrency@@QBE_NABV123@@Z"
		size = 182
		refs = "0017 ??_C@_1DI@DPDJJEPO@?$AAc?$AAo?$AAm?$AAp?$AAa?$AAr?$AAa?$AAt?$AAo?$AAr?$AA?4?$AAm?$AA_?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAm?$AA_?$AAs?$AAi?$AAz?$AAe?$AA?$AA@ 001c ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0028 ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 002f __CrtDbgReportW 004f ?ASIZE@QuickBitSet@details@Concurrency@@IBEIXZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 56 89 4D F4 8B 45 08 8B 4D F4 8B 10 3B 11 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 8A 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CA 33 D2 75 C6 C7 45 F8 00 00 00 00 8B 4D F4 E8 ?? ?? ?? ?? 89 45 EC C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 3B 4D EC 73 26 83 7D F8 00 75 20 8B 55 F4 8B 42 04 8B 4D 08 8B 51 04 8B 4D FC 8B 75 FC 8B 04 88 23 04 B2 0B 45 F8 89 45 F8 EB C9 83 7D F8 00 74 09 C7 45 F0 01 00 00 00 EB 07 C7 45 F0 00 00 00 00 8A 45 F0 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_62_0 {
	meta:
		name = "?IsEmpty@WorkQueue@details@Concurrency@@QBE_NXZ"
		size = 65
		refs = "000d ?Empty@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QBE_NXZ 001f ?Empty@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QBE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 1B 8B 4D FC 83 C1 4C E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8A 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_63_0 {
	meta:
		name = "?IsSet@QuickBitSet@details@Concurrency@@QBE_NI@Z"
		size = 66
	strings:
		$1 = { 55 8B EC 83 EC 08 56 89 4D F8 8B 45 08 C1 E8 05 8B 4D F8 8B 51 04 8B 4D 08 83 E1 1F BE 01 00 00 00 D3 E6 23 34 82 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_64_0 {
	meta:
		name = "?MarkedForDetachment@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QBE_NXZ"
		size = 17
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8A 40 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_65_0 {
	meta:
		name = "?NotifyWorkSkipped@InternalContextBase@details@Concurrency@@QAEXXZ"
		size = 32
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8A 88 B3 00 00 00 80 C9 02 8B 55 FC 88 8A B3 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_66_0 {
	meta:
		name = "?RedetachFromScheduleGroupAtSafePoint@WorkQueue@details@Concurrency@@QAEXPAVScheduleGroupSegmentBase@23@@Z"
		size = 58
		refs = "0014 ?GetGroup@ScheduleGroupSegmentBase@details@Concurrency@@QBEPAVScheduleGroupBase@23@XZ 001b ?GetScheduler@ScheduleGroupBase@details@Concurrency@@QAEPAVSchedulerBase@23@XZ 0025 ?StaticRedetachFromScheduleGroup@WorkQueue@details@Concurrency@@CAXPAV123@@Z 0030 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 48 3C 8B 4D 08 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B 55 FC 52 68 ?? ?? ?? ?? 8B 4D FC 83 C1 1C E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_70_0 {
	meta:
		name = "?RetireAtSafePoint@WorkQueue@details@Concurrency@@QAEXPAVScheduleGroupSegmentBase@23@@Z"
		size = 58
		refs = "0014 ?GetGroup@ScheduleGroupSegmentBase@details@Concurrency@@QBEPAVScheduleGroupBase@23@XZ 001b ?GetScheduler@ScheduleGroupBase@details@Concurrency@@QAEPAVSchedulerBase@23@XZ 0025 ?StaticRetire@WorkQueue@details@Concurrency@@CAXPAV123@@Z 0030 ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 48 3C 8B 4D 08 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B 55 FC 52 68 ?? ?? ?? ?? 8B 4D FC 83 C1 1C E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_67_0 {
	meta:
		name = "?Reinitialize@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXXZ"
		size = 30
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 00 00 00 00 8B 4D FC C7 41 04 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_68_0 {
	meta:
		name = "?Reinitialize@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXXZ"
		size = 57
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 00 00 00 00 8B 4D FC C7 41 04 00 00 00 00 8B 55 FC C7 42 18 00 00 00 00 8B 45 FC C6 40 14 00 8B 4D FC C7 41 0C 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_69_0 {
	meta:
		name = "?Reinitialize@WorkQueue@details@Concurrency@@AAEXXZ"
		size = 83
		refs = "000e ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ 0013 ?GetNewWorkQueueId@SchedulerBase@details@Concurrency@@SAIXZ 0021 ?Reinitialize@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXXZ 002c ?Reinitialize@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXXZ 004b ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D FC 83 C1 70 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D FC 89 41 40 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC 83 C1 4C E8 ?? ?? ?? ?? 8B 55 FC C7 42 38 00 00 00 00 8B 45 FC C7 40 48 00 00 00 00 8B 4D FC 83 C1 70 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_72_0 {
	meta:
		name = "?StaticRedetachFromScheduleGroup@WorkQueue@details@Concurrency@@CAXPAV123@@Z"
		size = 20
		refs = "000e ?RedetachQueue@ScheduleGroupSegmentBase@details@Concurrency@@QAEXPAVWorkQueue@23@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 8B 4D 08 8B 49 3C E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_27_73_0 {
	meta:
		name = "?StaticRetire@WorkQueue@details@Concurrency@@CAXPAV123@@Z"
		size = 20
		refs = "000e ?RetireDetachedQueue@ScheduleGroupSegmentBase@details@Concurrency@@QAEXPAVWorkQueue@23@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 8B 4D 08 8B 49 3C E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_27_74_0 {
	meta:
		name = "?Steal@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@_N@Z"
		size = 113
		refs = "0006 __ehhandler$?Steal@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@_N@Z 0015 ___security_cookie 0033 ??0_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 0047 ?UnlockedSteal@WorkQueue@details@Concurrency@@AAEPAV_UnrealizedChore@23@_N@Z 0059 ??1_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 0C A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 83 C0 70 50 8D 4D EC E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 0F B6 4D 08 51 8B 4D F0 E8 ?? ?? ?? ?? 89 45 E8 C7 45 FC FF FF FF FF 8D 4D EC E8 ?? ?? ?? ?? 8B 45 E8 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_76_0 {
	meta:
		name = "__ehhandler$?Steal@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Steal@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_151_4_0 {
	meta:
		name = "__ehhandler$??$?0V__ExceptionPtr@@P6AXPAV0@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@std@@QAE@PAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0V__ExceptionPtr@@P6AXPAV0@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@std@@QAE@PAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_47_0 {
	meta:
		name = "__ehhandler$??0Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@23@ABVQuickBitSet@23@II@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@23@ABVQuickBitSet@23@II@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_486_2 {
	meta:
		name = "__ehhandler$??0agent@Concurrency@@QAE@AAVScheduleGroup@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0agent@Concurrency@@QAE@AAVScheduleGroup@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_489_2 {
	meta:
		name = "__ehhandler$??0agent@Concurrency@@QAE@AAVScheduler@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0agent@Concurrency@@QAE@AAVScheduler@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_492_2 {
	meta:
		name = "__ehhandler$??0agent@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0agent@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_162_44_0 {
	meta:
		name = "__ehhandler$??1event@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1event@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_258_0 {
	meta:
		name = "__ehhandler$?Dequeue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Dequeue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_153_0 {
	meta:
		name = "__ehhandler$?Dequeue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVRealizedChore@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Dequeue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVRealizedChore@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1083_49_0 {
	meta:
		name = "__ehhandler$?Dequeue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QAEPAVUMSThreadProxy@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Dequeue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QAEPAVUMSThreadProxy@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1338_88_0 {
	meta:
		name = "__ehhandler$?DestroyVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@QAEXPAVVirtualProcessorRoot@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?DestroyVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@QAEXPAVVirtualProcessorRoot@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_289_51_0 {
	meta:
		name = "__ehhandler$?RemoveHead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEPAUListEntry@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RemoveHead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAEPAUListEntry@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_447_0 {
	meta:
		name = "__ehhandler$?RemoveHead@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QAEPAVWaitNode@SchedulerBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RemoveHead@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QAEPAVWaitNode@SchedulerBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_483_0 {
	meta:
		name = "__ehhandler$?StartupNewVirtualProcessor@SchedulerBase@details@Concurrency@@UAEXPAVScheduleGroupSegmentBase@23@Vlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?StartupNewVirtualProcessor@SchedulerBase@details@Concurrency@@UAEXPAVScheduleGroupSegmentBase@23@Vlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1151_159_0 {
	meta:
		name = "__ehhandler$?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_744_261_0 {
	meta:
		name = "__ehhandler$?SubscribeCurrentThread@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?SubscribeCurrentThread@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_1178_2 {
	meta:
		name = "__ehhandler$?_CreateImpl@?$task@X@Concurrency@@QAEXPAV_CancellationTokenState@details@2@Uscheduler_ptr@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CreateImpl@?$task@X@Concurrency@@QAEXPAV_CancellationTokenState@details@2@Uscheduler_ptr@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_1199_3 {
	meta:
		name = "__ehhandler$?_Current_exception@exception_ptr@std@@SA?AV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Current_exception@exception_ptr@std@@SA?AV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_686_214_0 {
	meta:
		name = "__ehhandler$?_NewCollection@_AsyncTaskCollection@details@Concurrency@@SAPAV123@PAV_CancellationTokenState@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_NewCollection@_AsyncTaskCollection@details@Concurrency@@SAPAV123@PAV_CancellationTokenState@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_1383_3 {
	meta:
		name = "__ehhandler$?_Orphan_range@?$vector@PAXV?$allocator@PAX@std@@@std@@IBEXPAPAX0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Orphan_range@?$vector@PAXV?$allocator@PAX@std@@@std@@IBEXPAPAX0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_1432_2 {
	meta:
		name = "__ehhandler$?_ScheduleFuncWithAutoInline@details@Concurrency@@YAXABV?$function@$$A6AXXZ@std@@W4_TaskInliningMode@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_ScheduleFuncWithAutoInline@details@Concurrency@@YAXABV?$function@$$A6AXXZ@std@@W4_TaskInliningMode@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_151_3 {
	meta:
		name = "__ehhandler$?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEAAV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEAAV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_150_3 {
	meta:
		name = "__ehhandler$?flush@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEAAV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?flush@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEAAV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_150_3 {
	meta:
		name = "__ehhandler$?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEAAV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEAAV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_77_0 {
	meta:
		name = "?Sweep@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXP6A_NPAV_UnrealizedChore@23@PAX@Z12@Z"
		size = 263
		refs = "0006 __ehhandler$?Sweep@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXP6A_NPAV_UnrealizedChore@23@PAX@Z12@Z 0015 ___security_cookie 0033 ??0_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z 00f2 ??1_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 14 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 8B 48 10 51 8D 4D E0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 55 F0 8B 42 04 89 45 E8 8B 4D F0 8B 51 04 83 EA 01 89 55 EC 8B 45 F0 8B 08 39 4D EC 7C 7F 8B 55 F0 8B 45 EC 23 42 08 8B 4D F0 8B 51 1C 8B 04 82 89 45 E4 83 7D E4 00 74 56 8B 4D 0C 51 8B 55 E4 52 FF 55 08 83 C4 08 0F B6 C0 85 C0 74 41 8B 4D 0C 51 8B 55 E4 52 FF 55 10 83 C4 08 0F B6 C0 85 C0 74 2C 8B 4D EC 83 C1 01 3B 4D E8 75 0B 8B 55 E8 83 EA 01 89 55 E8 EB 16 8B 45 F0 8B 4D EC 23 48 08 8B 55 F0 8B 42 1C C7 04 88 00 00 00 00 8B 4D EC 83 E9 01 89 4D EC E9 77 FF FF FF 8B 55 E8 8B 45 F0 83 C0 04 87 10 C7 45 FC FF FF FF FF 8D 4D E0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_27_79_0 {
	meta:
		name = "__ehhandler$?Sweep@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXP6A_NPAV_UnrealizedChore@23@PAX@Z12@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Sweep@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXP6A_NPAV_UnrealizedChore@23@PAX@Z12@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_44_0 {
	meta:
		name = "__ehhandler$??0ScheduleGroupSegmentBase@details@Concurrency@@IAE@PAVScheduleGroupBase@12@PAVSchedulingRing@12@PAVlocation@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ScheduleGroupSegmentBase@details@Concurrency@@IAE@PAVScheduleGroupBase@12@PAVSchedulingRing@12@PAVlocation@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_157_19_0 {
	meta:
		name = "__ehhandler$??0SchedulingRing@details@Concurrency@@QAE@PAVSchedulerBase@12@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0SchedulingRing@details@Concurrency@@QAE@PAVSchedulerBase@12@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_27_3 {
	meta:
		name = "__ehhandler$??0_Concurrent_queue_iterator_base_v4@details@Concurrency@@IAE@ABV_Concurrent_queue_base_v4@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Concurrent_queue_iterator_base_v4@details@Concurrency@@IAE@ABV_Concurrent_queue_base_v4@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_37_3 {
	meta:
		name = "__ehhandler$??0_Pad@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Pad@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_429_39_0 {
	meta:
		name = "__ehhandler$??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_429_42_0 {
	meta:
		name = "__ehhandler$??0scoped_lock@reader_writer_lock@Concurrency@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0scoped_lock@reader_writer_lock@Concurrency@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_255_3 {
	meta:
		name = "__ehhandler$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBE?AV01@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBE?AV01@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_509_2 {
	meta:
		name = "__ehhandler$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBE?AV01@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBE?AV01@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_88_2 {
	meta:
		name = "__ehhandler$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBE?AV01@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??G?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBE?AV01@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_246_2 {
	meta:
		name = "__ehhandler$??H?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBE?AV01@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??H?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBE?AV01@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_521_2 {
	meta:
		name = "__ehhandler$??H?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBE?AV01@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??H?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QBE?AV01@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_524_2 {
	meta:
		name = "__ehhandler$??H?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBE?AV01@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??H?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QBE?AV01@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_278_45_0 {
	meta:
		name = "__ehhandler$?Create@ThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@ThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_719_45_0 {
	meta:
		name = "__ehhandler$?Create@UMSThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@UMSThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1099_89_0 {
	meta:
		name = "__ehhandler$?CreateFactory@FreeThreadProxyFactory@details@Concurrency@@SAPAV123@PAVThreadProxyFactoryManager@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateFactory@FreeThreadProxyFactory@details@Concurrency@@SAPAV123@PAVThreadProxyFactoryManager@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1099_92_0 {
	meta:
		name = "__ehhandler$?CreateFactory@UMSFreeThreadProxyFactory@details@Concurrency@@SAPAV123@PAVThreadProxyFactoryManager@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateFactory@UMSFreeThreadProxyFactory@details@Concurrency@@SAPAV123@PAVThreadProxyFactoryManager@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_680_76_0 {
	meta:
		name = "__ehhandler$?FoundAvailableVirtualProcessor@SchedulingNode@details@Concurrency@@AAE_NAAVClaimTicket@VirtualProcessor@23@Vlocation@3@K@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?FoundAvailableVirtualProcessor@SchedulingNode@details@Concurrency@@AAE_NAAVClaimTicket@VirtualProcessor@23@Vlocation@3@K@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_194_0 {
	meta:
		name = "__ehhandler$?Initialize@ScheduleGroupSegmentBase@details@Concurrency@@IAEXPAVScheduleGroupBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Initialize@ScheduleGroupSegmentBase@details@Concurrency@@IAEXPAVScheduleGroupBase@23@PAVSchedulingRing@23@PAVlocation@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_70_0 {
	meta:
		name = "__ehhandler$?PostAffinityMessage@SchedulerBase@details@Concurrency@@QAEXABVQuickBitSet@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?PostAffinityMessage@SchedulerBase@details@Concurrency@@QAEXABVQuickBitSet@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_744_228_0 {
	meta:
		name = "__ehhandler$?RemoveExecutionResource@ResourceManager@details@Concurrency@@QAEXPAVExecutionResource@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RemoveExecutionResource@ResourceManager@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_490_0 {
	meta:
		name = "__ehhandler$?StaticDestruction@SchedulerBase@details@Concurrency@@CAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?StaticDestruction@SchedulerBase@details@Concurrency@@CAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_1056_1 {
	meta:
		name = "__ehhandler$?_CaptureMultiFramesCallstack@_TaskCreationCallstack@details@Concurrency@@SA?AV123@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CaptureMultiFramesCallstack@_TaskCreationCallstack@details@Concurrency@@SA?AV123@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_33_124_2 {
	meta:
		name = "__ehhandler$?_Init@locale@std@@CAPAV_Locimp@12@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@locale@std@@CAPAV_Locimp@12@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_1236_1 {
	meta:
		name = "__ehhandler$?_JoinAllTokens_Add@details@Concurrency@@YAXABVcancellation_token_source@2@PAV_CancellationTokenState@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_JoinAllTokens_Add@details@Concurrency@@YAXABVcancellation_token_source@2@PAV_CancellationTokenState@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_686_228_0 {
	meta:
		name = "__ehhandler$?_RegisterCallback@_CancellationTokenState@details@Concurrency@@QAEPAV_CancellationTokenRegistration@23@P6AXPAX@Z0H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RegisterCallback@_CancellationTokenState@details@Concurrency@@QAEPAV_CancellationTokenRegistration@23@P6AXPAX@Z0H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_1461_3 {
	meta:
		name = "__ehhandler$?_ScheduleTask@_Task_impl_base@details@Concurrency@@QAEXPAU_TaskProcHandle@23@W4_TaskInliningMode@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_ScheduleTask@_Task_impl_base@details@Concurrency@@QAEXPAU_TaskProcHandle@23@W4_TaskInliningMode@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_1106_3 {
	meta:
		name = "__ehhandler$?accept_message@?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@MAEPAV?$message@W4agent_status@Concurrency@@@2@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?accept_message@?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@MAEPAV?$message@W4agent_status@Concurrency@@@2@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_521_3 {
	meta:
		name = "__ehhandler$?do_get_time@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_time@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_1278_3 {
	meta:
		name = "__ehhandler$?do_get_time@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_time@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_1281_3 {
	meta:
		name = "__ehhandler$?do_get_time@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_time@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_429_161_0 {
	meta:
		name = "__ehhandler$?try_lock_for@critical_section@Concurrency@@QAE_NI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?try_lock_for@critical_section@Concurrency@@QAE_NI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_404_3 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QBEDD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QBEDD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_33_354_1 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBEGD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBEGD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_7_355_1 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBE_WD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBE_WD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_80_0 {
	meta:
		name = "?SweepUnstructured@WorkQueue@details@Concurrency@@QAEXP6A_NPAV_UnrealizedChore@23@PAX@Z12@Z"
		size = 36
		refs = "001a ?Sweep@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXP6A_NPAV_UnrealizedChore@23@PAX@Z12@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 4D FC 83 C1 4C E8 ?? ?? ?? ?? 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_27_81_0 {
	meta:
		name = "?TryToSteal@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@_NAA_N@Z"
		size = 162
		refs = "0006 __sehtable$?TryToSteal@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@_NAA_N@Z 000b __except_handler4 001d ___security_cookie 0041 ?_TryAcquire@_CriticalNonReentrantLock@details@Concurrency@@QAE_NXZ 005c ?UnlockedSteal@WorkQueue@details@Concurrency@@AAEPAV_UnrealizedChore@23@_N@Z 0078 ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 4D E4 C7 45 E0 00 00 00 00 8B 4D E4 83 C1 70 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 39 C7 45 FC 00 00 00 00 0F B6 4D 08 51 8B 4D E4 E8 ?? ?? ?? ?? 89 45 E0 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0C 8B 4D E4 83 C1 70 E8 ?? ?? ?? ?? C3 8B 55 0C C6 02 01 EB 06 8B 45 0C C6 00 00 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_27_82_0 {
	meta:
		name = "?UnlockedSteal@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@_N@Z"
		size = 224
		refs = "0054 ?DeferToAffineSearchers@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QBE_NXZ 00a2 ?Claim@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE_NPAPAV_UnrealizedChore@34@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 8B 4D FC 8B 51 04 39 10 0F 8D BE 00 00 00 8B 45 FC 8B 08 89 4D F8 8B 55 FC 8B 45 F8 23 42 08 8B 4D FC 8B 51 0C 8B 04 82 83 E0 01 74 2A 0F B6 4D 08 85 C9 75 22 8B 55 FC 8B 45 F8 23 42 08 8B 4D FC 8B 51 10 8D 0C C2 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 04 33 C0 EB 77 33 C9 8B 55 FC 8B 45 F8 23 42 08 8B 55 FC 8B 52 0C 8D 04 82 87 08 89 4D F4 8B 4D F4 83 E1 01 74 39 8B 55 F4 83 E2 FE 89 55 F4 6A 00 8B 45 FC 8B 4D F8 23 48 08 8B 55 FC 8B 42 10 8D 0C C8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 10 8B 55 F8 83 C2 01 8B 45 FC 89 10 E9 4C FF FF FF 83 7D F4 00 74 0B 8B 4D F8 83 C1 01 8B 55 FC 89 0A 8B 45 F4 EB 07 E9 31 FF FF FF 33 C0 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_680_103_0 {
	meta:
		name = "?UnlockedSteal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@_N@Z"
		size = 224
		refs = "0054 ?DeferToAffineSearchers@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QBE_NXZ 00a2 ?Claim@Slot@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAE_NPAPAVInternalContextBase@34@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 8B 4D FC 8B 51 04 39 10 0F 8D BE 00 00 00 8B 45 FC 8B 08 89 4D F8 8B 55 FC 8B 45 F8 23 42 08 8B 4D FC 8B 51 0C 8B 04 82 83 E0 01 74 2A 0F B6 4D 08 85 C9 75 22 8B 55 FC 8B 45 F8 23 42 08 8B 4D FC 8B 51 10 8D 0C C2 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 04 33 C0 EB 77 33 C9 8B 55 FC 8B 45 F8 23 42 08 8B 55 FC 8B 52 0C 8D 04 82 87 08 89 4D F4 8B 4D F4 83 E1 01 74 39 8B 55 F4 83 E2 FE 89 55 F4 6A 00 8B 45 FC 8B 4D F8 23 48 08 8B 55 FC 8B 42 10 8D 0C C8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 10 8B 55 F8 83 C2 01 8B 45 FC 89 10 E9 4C FF FF FF 83 7D F4 00 74 0B 8B 4D F8 83 C1 01 8B 55 FC 89 0A 8B 45 F4 EB 07 E9 31 FF FF FF 33 C0 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_83_0 {
	meta:
		name = "?UnlockedSteal@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@_N0@Z"
		size = 277
		refs = "0064 ?DeferToAffineSearchers@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QBE_NXZ 00e2 ?Claim@Slot@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QAE_NPAPAV_UnrealizedChore@34@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC C7 45 F4 00 00 00 00 8B 45 FC 8B 08 89 4D F8 8B 55 F8 83 C2 01 8B 45 FC 87 10 8B 4D FC 8B 51 04 39 55 F8 0F 8D CB 00 00 00 8B 45 FC 8B 4D F8 23 48 08 8B 55 FC 8B 42 1C 8B 0C 88 83 E1 01 74 35 0F B6 55 08 85 D2 75 2D 8B 45 FC 8B 4D F8 23 48 08 8B 55 FC 8B 42 20 8D 0C C8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 0F 8B 55 FC 8B 45 F8 89 02 33 C0 E9 91 00 00 00 8B 4D FC 0F B6 51 14 85 D2 74 14 8B 45 FC 8B 08 8B 55 FC 3B 4A 18 7C 07 8B 45 FC C6 40 14 00 33 C9 8B 55 FC 8B 45 F8 23 42 08 8B 55 FC 8B 52 1C 8D 04 82 87 08 89 4D F4 83 7D F4 00 74 3F 8B 4D F4 83 E1 01 74 35 8B 55 F4 83 E2 FE 89 55 F4 6A 00 8B 45 FC 8B 4D F8 23 48 08 8B 55 FC 8B 42 20 8D 0C C8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 0C C7 45 F4 00 00 00 00 E9 17 FF FF FF EB 11 EB 0A 8B 55 FC 8B 45 F8 89 02 EB 05 E9 04 FF FF FF 8B 45 F4 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_27_84_0 {
	meta:
		name = "?UnlockedSteal@WorkQueue@details@Concurrency@@AAEPAV_UnrealizedChore@23@_N@Z"
		size = 319
		refs = "000d ?IsEmpty@WorkQueue@details@Concurrency@@QBE_NXZ 003d ?HasInlineCancellation@ContextBase@details@Concurrency@@QBE_NXZ 0063 ?MarkedForDetachment@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QBE_NXZ 007c ?UnlockedSteal@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@_N0@Z 008f ?_SetDetached@_UnrealizedChore@details@Concurrency@@QAEX_N@Z 0096 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 00b9 ?NotifyWorkSkipped@InternalContextBase@details@Concurrency@@QAEXXZ 00c8 ?UnlockedSteal@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@_N@Z 0102 ?_OwningCollection@_UnrealizedChore@details@Concurrency@@QBEPAV_TaskCollectionBase@23@XZ 0109 ?_OwningContext@_TaskCollectionBase@details@Concurrency@@QBEPAXXZ 011c ?ReferenceForCancellation@ContextBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 89 4D F8 8B 4D F8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 07 33 C0 E9 1A 01 00 00 C7 45 FC 00 00 00 00 8B 4D F8 8B 51 48 89 55 F4 83 7D F4 00 0F 84 86 00 00 00 8B 4D F4 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 77 8B 4D F4 8B 11 8B 4D F4 8B 42 10 FF D0 0F B6 C8 85 C9 75 63 8B 4D F8 83 C1 4C E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 15 6A 01 0F B6 45 08 50 8B 4D F8 83 C1 4C E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 0C 6A 01 8B 4D FC E8 ?? ?? ?? ?? EB 28 E8 ?? ?? ?? ?? 89 45 F0 83 7D F0 00 74 0B 8B 4D F0 83 E9 04 89 4D EC EB 07 C7 45 EC 00 00 00 00 8B 4D EC E8 ?? ?? ?? ?? EB 77 0F B6 55 08 52 8B 4D F8 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 05 8B 45 FC EB 5F 6A 00 0F B6 45 08 50 8B 4D F8 83 C1 4C E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 41 8B 4D F8 83 79 48 00 74 2E 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 55 F8 3B 42 48 75 17 8B 45 F8 8B 48 48 E8 ?? ?? ?? ?? 6A 00 8B 4D FC E8 ?? ?? ?? ?? EB 0A 6A 01 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_93_0 {
	meta:
		name = "?_OwningContext@_TaskCollectionBase@details@Concurrency@@QBEPAXXZ"
		size = 17
		altNames = "??$_As@VSchedulingNode@details@Concurrency@@@location@Concurrency@@QBEPAVSchedulingNode@details@1@XZ ??$_As@VVirtualProcessor@details@Concurrency@@@location@Concurrency@@QBEPAVVirtualProcessor@details@1@XZ ?GetId@InternalContextBase@details@Concurrency@@UBEIXZ ?GetResourceManager@SchedulerProxy@details@Concurrency@@QBEPAVResourceManager@23@XZ ?GetSchedulingProtocol@SchedulerBase@details@Concurrency@@QAE?AW4SchedulingProtocolType@3@XZ ?get_error_code@scheduler_resource_allocation_error@Concurrency@@QBEJXZ ?rdstate@ios_base@std@@QBEHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "_expf"
		size = 31
		refs = "000e _exp"
	strings:
		$1 = { 55 8B EC 51 D9 45 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_1288_1_0 {
	meta:
		name = "_cosf"
		size = 31
		refs = "000e _cos"
	strings:
		$1 = { 55 8B EC 51 D9 45 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_655_2_0 {
	meta:
		name = "_logf"
		size = 31
		refs = "000e _log"
	strings:
		$1 = { 55 8B EC 51 D9 45 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_588_2_0 {
	meta:
		name = "_sinf"
		size = 31
		refs = "000e _sin"
	strings:
		$1 = { 55 8B EC 51 D9 45 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_715_1_0 {
	meta:
		name = "_sinhf"
		size = 31
		refs = "000e _sinh"
	strings:
		$1 = { 55 8B EC 51 D9 45 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_301_13_0 {
	meta:
		name = "_sqrtf"
		size = 31
		refs = "000e _sqrt"
	strings:
		$1 = { 55 8B EC 51 D9 45 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_715_3_0 {
	meta:
		name = "_tanf"
		size = 31
		refs = "000e _tan"
	strings:
		$1 = { 55 8B EC 51 D9 45 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_1_0 {
	meta:
		name = "_expm1f"
		size = 294
		refs = "000b __fdtest 004a __real@bf800000 0063 _lnhalf 007c _lnone_half 0093 _s 00d3 _c 010f _expf 0118 __real@3ff0000000000000"
	strings:
		$1 = { 55 8B EC 83 EC 10 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D FC 83 7D FC 00 74 0E 83 7D FC 01 74 10 83 7D FC 02 74 02 EB 35 D9 45 08 E9 EE 00 00 00 BA 02 00 00 00 C1 E2 00 0F B7 44 15 08 25 00 80 00 00 74 0B D9 05 ?? ?? ?? ?? D9 5D F8 EB 06 D9 45 08 D9 5D F8 D9 45 F8 E9 C1 00 00 00 D9 05 ?? ?? ?? ?? D9 45 08 DE D9 DF E0 F6 C4 41 0F 85 90 00 00 00 D9 45 08 D9 05 ?? ?? ?? ?? DE D9 DF E0 F6 C4 41 75 7E B9 04 00 00 00 6B D1 00 D9 82 ?? ?? ?? ?? D8 4D 08 B8 04 00 00 00 C1 E0 00 D8 80 ?? ?? ?? ?? D8 4D 08 B9 04 00 00 00 D1 E1 D8 81 ?? ?? ?? ?? D8 4D 08 BA 04 00 00 00 6B C2 03 D8 80 ?? ?? ?? ?? B9 04 00 00 00 6B D1 00 D9 82 ?? ?? ?? ?? D8 4D 08 B8 04 00 00 00 C1 E0 00 D8 80 ?? ?? ?? ?? D8 4D 08 B9 04 00 00 00 D1 E1 D8 81 ?? ?? ?? ?? DE F9 D8 4D 08 D9 5D F4 D9 45 F4 EB 1D EB 1B 51 D9 45 08 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 DC 25 ?? ?? ?? ?? D9 5D F0 D9 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "__rt_probe_read4@4"
		size = 161
		refs = "0006 __sehtable$__rt_probe_read4@4 000b __except_handler4 001d ___security_cookie"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 FC 00 00 00 00 8B 45 08 8B 08 89 4D D8 C7 45 E0 01 00 00 00 C7 45 FC FE FF FF FF EB 38 8B 55 EC 8B 02 8B 08 89 4D DC 81 7D DC 05 00 00 C0 75 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 45 E4 C3 8B 65 E8 C7 45 E0 00 00 00 00 C7 45 FC FE FF FF FF 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "_wctype"
		size = 83
		refs = "001c _tab 0033 _strcmp"
		altNames = "_wctrans"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 83 3C CD ?? ?? ?? ?? 00 74 2A 8B 55 08 52 8B 45 FC 8B 0C C5 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 0D 8B 55 FC 66 8B 04 D5 ?? ?? ?? ?? EB 04 EB C0 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "__loaddll"
		size = 32
		refs = "0004 ___crtIsPackagedApp 001a __imp__LoadLibraryExA@12"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 0E 6A 00 6A 00 8B 45 08 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_32_1_0 {
	meta:
		name = "__unloaddll"
		size = 29
		refs = "0009 __imp__FreeLibrary@4 0013 __imp__GetLastError@0"
	strings:
		$1 = { 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "__realloc_base"
		size = 248
		refs = "0018 __malloc_base 002f __free_base 0063 __crtheap 006a __imp__HeapReAlloc@16 0078 __callnewh 0080 __errno 0096 __newmode 00a7 __imp__GetLastError@0 00ad __get_errno_from_oserr"
	strings:
		$1 = { 55 8B EC 83 EC 08 56 8B 45 0C 89 45 F8 83 7D 08 00 75 11 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 E9 CF 00 00 00 83 7D 0C 00 75 13 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 33 C0 E9 B6 00 00 00 C7 45 FC 00 00 00 00 83 7D 0C E0 77 29 83 7D 0C 00 75 07 C7 45 0C 01 00 00 00 8B 45 0C 50 8B 4D 08 51 6A 00 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 89 45 FC EB 1B 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 65 83 7D FC 00 75 09 83 3D ?? ?? ?? ?? 00 75 25 83 7D FC 00 74 02 EB 18 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 E8 ?? ?? ?? ?? 89 30 8B 45 FC EB 31 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 1C FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 E8 ?? ?? ?? ?? 89 30 33 C0 EB 05 E9 4A FF FF FF 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "__Cosh"
		size = 287
		refs = "000b __dtest 007b __Inf_C 009c __fperrraise 00a5 __Nan_C 00ca __Xbig_C 00e7 __dexp 00f0 __real@3fd0000000000000"
	strings:
		$1 = { 55 8B EC 83 EC 10 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F8 0F BF 55 FC 85 D2 7D 08 0F BF 45 F8 85 C0 7C 7E 0F BF 4D FC 83 F9 02 75 0A DD 45 08 E9 D4 00 00 00 EB 69 0F BF 55 F8 83 FA 02 75 0A DD 45 10 E9 C1 00 00 00 EB 56 0F BF 45 FC 83 F8 01 75 48 0F BF 4D F8 85 C9 74 2C D9 EE DC 5D 10 DF E0 F6 C4 41 75 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D F0 EB 09 DD 05 ?? ?? ?? ?? DD 5D F0 DD 45 F0 E9 84 00 00 00 EB 12 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? EB 70 EB 05 DD 45 10 EB 69 EB 67 D9 EE DC 5D 08 DF E0 F6 C4 41 75 08 DD 45 08 D9 E0 DD 5D 08 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 75 29 6A FF 83 EC 08 D9 E8 DD 1C 24 8D 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 DD 05 ?? ?? ?? ?? DC 75 08 DC 45 08 DC 4D 10 EB 1C EB 1A 6A FF 83 EC 08 DD 45 10 DD 1C 24 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 DD 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_815_0_0 {
	meta:
		name = "__LCosh"
		size = 287
		refs = "000b __ldtest 007b __LInf_C 009c __fperrraise 00a5 __LNan_C 00ca __LXbig_C 00e7 __ldexp 00f0 __real@3fd0000000000000"
	strings:
		$1 = { 55 8B EC 83 EC 10 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F8 0F BF 55 FC 85 D2 7D 08 0F BF 45 F8 85 C0 7C 7E 0F BF 4D FC 83 F9 02 75 0A DD 45 08 E9 D4 00 00 00 EB 69 0F BF 55 F8 83 FA 02 75 0A DD 45 10 E9 C1 00 00 00 EB 56 0F BF 45 FC 83 F8 01 75 48 0F BF 4D F8 85 C9 74 2C D9 EE DC 5D 10 DF E0 F6 C4 41 75 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D F0 EB 09 DD 05 ?? ?? ?? ?? DD 5D F0 DD 45 F0 E9 84 00 00 00 EB 12 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? EB 70 EB 05 DD 45 10 EB 69 EB 67 D9 EE DC 5D 08 DF E0 F6 C4 41 75 08 DD 45 08 D9 E0 DD 5D 08 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 75 29 6A FF 83 EC 08 D9 E8 DD 1C 24 8D 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 DD 05 ?? ?? ?? ?? DC 75 08 DC 45 08 DC 4D 10 EB 1C EB 1A 6A FF 83 EC 08 DD 45 10 DD 1C 24 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 DD 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_38_1_0 {
	meta:
		name = "_ccosh"
		size = 1169
		refs = "0026 _creal 004d _cimag 005c __dtest 009a __Nan_C 00a6 __Cbuild 012d __fperrraise 014a __Zero_C 01bb __Inf_C 03b9 _sin 03d6 _cos 0433 __Sinh 0458 __Cosh"
	strings:
		$1 = { 55 8B EC 81 EC D8 00 00 00 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D F0 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F8 0F BF 55 FC 83 FA 02 0F 85 99 00 00 00 0F BF 45 F8 85 C0 75 44 83 EC 08 DD 45 F0 DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 4D 98 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 BF 03 00 00 EB 48 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 8D 38 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 75 03 00 00 E9 70 03 00 00 0F BF 4D F8 83 F9 01 0F 85 17 01 00 00 6A 01 E8 ?? ?? ?? ?? 83 C4 04 0F BF 55 FC 85 D2 75 65 D9 EE DC 5D F0 DF E0 F6 C4 41 75 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D E0 EB 05 D9 EE DD 5D E0 83 EC 08 DD 45 E0 DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 45 C8 50 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 F1 02 00 00 E9 9B 00 00 00 0F BF 4D FC 83 F9 01 75 4A 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 95 58 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 9B 02 00 00 EB 48 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 8D 78 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 51 02 00 00 E9 4C 02 00 00 0F BF 4D F8 83 F9 02 0F 85 E9 00 00 00 0F BF 55 FC 85 D2 75 47 83 EC 08 DD 45 E8 DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 45 B8 50 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 F5 01 00 00 E9 95 00 00 00 0F BF 4D FC 83 F9 01 75 47 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 55 A8 52 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 A2 01 00 00 EB 45 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 4D 88 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 5B 01 00 00 E9 56 01 00 00 0F BF 4D FC 83 F9 01 0F 85 D4 00 00 00 0F BF 55 F8 85 D2 75 63 D9 EE DC 5D E8 DF E0 F6 C4 41 75 0A DD 45 F0 D9 E0 DD 5D D8 EB 06 DD 45 F0 DD 5D D8 83 EC 08 DD 45 D8 DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 85 68 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 E0 00 00 00 EB 67 83 EC 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 0D ?? ?? ?? ?? 83 EC 08 DD 1C 24 83 EC 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 0D ?? ?? ?? ?? 83 EC 08 DD 1C 24 8D 8D 48 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 EB 77 EB 75 83 EC 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 8D 8D 28 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_815_1_0 {
	meta:
		name = "_ccoshl"
		size = 1169
		refs = "0026 _creall 004d _cimagl 005c __ldtest 009a __LNan_C 00a6 __LCbuild 012d __fperrraise 014a __LZero_C 01bb __LInf_C 03b9 _sinl 03d6 _cosl 0433 __LSinh 0458 __LCosh"
	strings:
		$1 = { 55 8B EC 81 EC D8 00 00 00 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D F0 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F8 0F BF 55 FC 83 FA 02 0F 85 99 00 00 00 0F BF 45 F8 85 C0 75 44 83 EC 08 DD 45 F0 DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 4D 98 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 BF 03 00 00 EB 48 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 8D 38 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 75 03 00 00 E9 70 03 00 00 0F BF 4D F8 83 F9 01 0F 85 17 01 00 00 6A 01 E8 ?? ?? ?? ?? 83 C4 04 0F BF 55 FC 85 D2 75 65 D9 EE DC 5D F0 DF E0 F6 C4 41 75 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D E0 EB 05 D9 EE DD 5D E0 83 EC 08 DD 45 E0 DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 45 C8 50 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 F1 02 00 00 E9 9B 00 00 00 0F BF 4D FC 83 F9 01 75 4A 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 95 58 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 9B 02 00 00 EB 48 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 8D 78 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 51 02 00 00 E9 4C 02 00 00 0F BF 4D F8 83 F9 02 0F 85 E9 00 00 00 0F BF 55 FC 85 D2 75 47 83 EC 08 DD 45 E8 DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 45 B8 50 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 F5 01 00 00 E9 95 00 00 00 0F BF 4D FC 83 F9 01 75 47 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 55 A8 52 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 A2 01 00 00 EB 45 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 4D 88 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 5B 01 00 00 E9 56 01 00 00 0F BF 4D FC 83 F9 01 0F 85 D4 00 00 00 0F BF 55 F8 85 D2 75 63 D9 EE DC 5D E8 DF E0 F6 C4 41 75 0A DD 45 F0 D9 E0 DD 5D D8 EB 06 DD 45 F0 DD 5D D8 83 EC 08 DD 45 D8 DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 85 68 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 E0 00 00 00 EB 67 83 EC 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 0D ?? ?? ?? ?? 83 EC 08 DD 1C 24 83 EC 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 0D ?? ?? ?? ?? 83 EC 08 DD 1C 24 8D 8D 48 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 EB 77 EB 75 83 EC 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 8D 8D 28 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "___avx_cosh4"
		size = 528
		refs = "0010 ___common_dcosh_data 0206 ___common_dcosh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FD 10 1D ?? ?? ?? ?? C5 FD 10 15 ?? ?? ?? ?? C5 FD 11 04 24 C5 FD 11 54 24 20 C5 E5 55 E8 C5 D5 59 35 ?? ?? ?? ?? C5 CD 58 74 24 20 C5 C1 73 D3 0B C4 E3 7D 19 D9 01 C5 D9 73 D1 0B C5 FA 7F 64 24 50 C5 FA 7F 7C 24 40 C5 F8 10 0D ?? ?? ?? ?? C4 E3 7D 19 EA 01 C4 E3 7D 19 F4 01 C5 D0 C6 DA DD C5 C8 C6 C4 88 C5 D9 73 F4 2C C5 E1 66 3D ?? ?? ?? ?? C5 F9 DB 15 ?? ?? ?? ?? C5 F8 50 C7 C5 C1 72 F2 03 C5 F9 7E FA C5 F1 FA DA C5 E1 72 F3 03 C4 E3 79 16 F9 01 C5 FB 10 82 ?? ?? ?? ?? C4 E3 79 16 FA 02 C5 F9 16 91 ?? ?? ?? ?? C4 E3 79 16 F9 03 C5 FB 10 8A ?? ?? ?? ?? C5 F9 7E DA C5 F1 16 89 ?? ?? ?? ?? C4 E3 79 16 D9 01 C5 FB 10 BA ?? ?? ?? ?? C4 E3 79 16 DA 02 C5 C1 16 B9 ?? ?? ?? ?? C4 E3 79 16 D9 03 C5 FB 10 82 ?? ?? ?? ?? C5 F9 11 7C 24 60 C5 F9 16 99 ?? ?? ?? ?? C5 CD 5C 44 24 20 C5 FD 59 3D ?? ?? ?? ?? C5 D5 5C EF C5 FD 59 3D ?? ?? ?? ?? C5 D5 5C C7 C5 C1 73 F6 2C C5 F9 10 35 ?? ?? ?? ?? C5 C1 DB FE C5 D9 DB E6 C5 E9 D4 F7 C5 E1 FB DC C5 F1 D4 CC C5 E1 FB 64 24 50 C5 FD 59 E8 C5 F9 10 54 24 60 C5 E9 FB FF C5 C1 FB 7C 24 40 C4 E3 4D 18 C9 01 C4 E3 45 18 DC 01 C5 F5 5C FB C5 F5 58 DB C5 D5 59 0D ?? ?? ?? ?? C5 F5 59 D0 C5 ED 58 C0 C5 FD 59 D7 C5 D5 59 05 ?? ?? ?? ?? C5 FD 58 0D ?? ?? ?? ?? C5 F5 59 ED C5 D5 59 C3 C5 FD 58 CA C5 F5 58 C3 85 C0 75 04 8B E5 5D C3 C5 FD 10 0C 24 C5 FD 11 84 24 80 00 00 00 C5 FD 11 4C 24 40 74 E6 33 D2 89 74 24 04 8B F2 89 3C 24 8B F8 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FD 10 84 24 80 00 00 00 EB BC C5 F8 77 8D 8C F4 80 00 00 00 8D 44 F4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 90 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "___libm_sse2_sincos"
		size = 489
		refs = "001f _PI32INV 002b _SHIFTER 003b _P_1 0047 _P_2 0060 _SC_4 0066 _Ctable 007b _P_3 009c _SC_2 00ee _SC_3 00fa _SC_1 017a _ONE 0188 _ALL_ONES 0191 _TWO_POW_55 01a1 _TWO_POW_M55 01be _cos 01d2 _sin"
	strings:
		$1 = { 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 4B 01 00 00 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 15 ?? ?? ?? ?? F2 0F 2D D1 66 0F 58 CA 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D9 81 C2 00 76 1C 00 66 0F 28 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 06 03 C2 66 0F 59 D1 66 0F 5C C3 66 0F 59 0D ?? ?? ?? ?? 66 0F 5C E3 66 0F 28 78 10 66 0F 28 DC 66 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 FC 66 0F 5C DC 66 0F 59 E8 66 0F 59 C0 66 0F 5C DA 66 0F 28 10 66 0F 5C CB 66 0F 28 58 30 66 0F 58 D3 66 0F 5C FA 66 0F 59 CF 66 0F 28 78 10 66 0F 59 D4 66 0F 59 F0 66 0F 59 DC 66 0F 59 D0 66 0F 59 F8 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 C3 66 0F 58 58 10 66 0F 58 F5 F2 0F 10 EE 66 0F 15 F6 66 0F 14 ED 66 0F 59 F7 66 0F 59 D5 66 0F 28 FC 66 0F 58 E3 66 0F 28 68 10 66 0F 5C EB 66 0F 5C DC 66 0F 58 48 20 66 0F 58 E8 66 0F 58 DF 66 0F 58 CD 66 0F 58 CB 66 0F 58 CA 66 0F 58 CE 66 0F 58 CC F2 0F 10 C1 66 0F 15 C9 C3 7F 42 F2 0F 10 C8 66 0F C5 C0 03 66 0D 00 80 66 0F C4 C8 03 F2 0F 58 0D ?? ?? ?? ?? 66 3D 10 80 7D 09 F2 0F 59 05 ?? ?? ?? ?? C3 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 5C C3 F2 0F 59 05 ?? ?? ?? ?? C3 8B C4 83 EC 20 83 E4 F0 89 44 24 08 66 0F D6 44 24 10 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 5C 24 18 F3 0F 7E 44 24 10 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 F3 0F 7E 4C 24 18 8B 64 24 08 C3 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "___ascii_strnicmp"
		size = 97
	strings:
		$1 = { 55 8B EC 57 56 53 8B 4D 10 0B C9 74 4D 8B 75 08 8B 7D 0C B7 41 B3 5A B6 20 8D 49 00 8A 26 0A E4 8A 07 74 27 0A C0 74 23 83 C6 01 83 C7 01 3A E7 72 06 3A E3 77 02 02 E6 3A C7 72 06 3A C3 77 02 02 C6 3A E0 75 0B 83 E9 01 75 D1 33 C9 3A E0 74 09 B9 FF FF FF FF 72 02 F7 D9 8B C1 5B 5E 5F C9 C3 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "__gets_helper"
		size = 1604
		refs = "0006 __sehtable$__gets_helper 000b __except_handler4 001d ___security_cookie 0066 ??_C@_1CC@OLIJCKA@?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 006b ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0074 ??_C@_1EM@HBCLBFO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAi?$AAo?$AA?2?$AAg@ 007b __CrtDbgReportW 008f __errno 00a3 ??_C@_1BK@EGLIABPC@?$AA_?$AAg?$AAe?$AAt?$AAs?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 00ad __invalid_parameter 00de ??_C@_1CC@OOLOCGJA@?$AA?$CI?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AAS?$AAi?$AAz?$AAe?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 0134 ___iob_func 0146 __lock_file2 017a __fileno 01a2 ___pioinfo 01ae ___badioinfo 0221 ??_C@_1BAA@ODEGEDCK@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 02ed __filbuf 04b8 ___crtDebugFillThreshold 04e3 _memset 04eb ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 0514 ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 0578 __local_unwind4 0627 __unlock_file2"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 88 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 8B 45 08 89 45 DC 8B 4D 08 89 4D D4 83 7D 08 00 74 09 C7 45 B8 01 00 00 00 EB 07 C7 45 B8 00 00 00 00 8B 55 B8 89 55 B4 83 7D B4 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 25 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D B4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 25 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 77 05 00 00 83 7D 0C 00 76 09 C7 45 B0 01 00 00 00 EB 07 C7 45 B0 00 00 00 00 8B 4D B0 89 4D AC 83 7D AC 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 26 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D AC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 FF 04 00 00 E8 ?? ?? ?? ?? B9 20 00 00 00 6B D1 00 03 C2 50 6A 00 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? B9 20 00 00 00 6B D1 00 03 C2 89 45 A8 8B 45 A8 8B 48 0C 83 E1 40 0F 85 98 00 00 00 8B 55 A8 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 E0 83 7D E0 FF 74 21 83 7D E0 FE 74 1B 8B 45 E0 C1 F8 05 8B 4D E0 83 E1 1F C1 E1 06 03 0C 85 ?? ?? ?? ?? 89 4D A4 EB 07 C7 45 A4 ?? ?? ?? ?? 8B 55 A4 8A 42 24 D0 E0 D0 F8 0F BE C8 85 C9 75 41 83 7D E0 FF 74 21 83 7D E0 FE 74 1B 8B 55 E0 C1 FA 05 8B 45 E0 83 E0 1F C1 E0 06 03 04 95 ?? ?? ?? ?? 89 45 A0 EB 07 C7 45 A0 ?? ?? ?? ?? 8B 4D A0 8A 51 24 C0 E2 00 C0 FA 07 0F BE C2 85 C0 74 09 C7 45 9C 00 00 00 00 EB 07 C7 45 9C 01 00 00 00 8B 4D 9C 89 4D 98 83 7D 98 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D 98 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D4 00 00 00 00 83 7D D4 00 75 05 E9 85 03 00 00 E8 ?? ?? ?? ?? B9 20 00 00 00 6B D1 00 8D 44 10 04 89 45 D0 8B 4D D0 8B 11 83 EA 01 8B 45 D0 89 10 8B 4D D0 83 39 00 7C 32 E8 ?? ?? ?? ?? BA 20 00 00 00 6B CA 00 03 C1 89 45 CC 8B 55 CC 8B 02 0F BE 08 81 E1 FF 00 00 00 89 4D 94 8B 55 CC 8B 02 83 C0 01 8B 4D CC 89 01 EB 1B E8 ?? ?? ?? ?? BA 20 00 00 00 6B CA 00 03 C1 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 94 8B 55 94 89 55 E4 83 7D E4 FF 75 12 C7 45 D4 00 00 00 00 83 7D 10 00 74 05 E9 F1 02 00 00 83 7D 0C FF 0F 85 B1 00 00 00 83 7D E4 0A 0F 84 9C 00 00 00 83 7D E4 FF 0F 84 92 00 00 00 8B 45 DC 8A 4D E4 88 08 8B 55 DC 83 C2 01 89 55 DC E8 ?? ?? ?? ?? B9 20 00 00 00 6B D1 00 8D 44 10 04 89 45 C8 8B 4D C8 8B 11 83 EA 01 8B 45 C8 89 10 8B 4D C8 83 39 00 7C 32 E8 ?? ?? ?? ?? BA 20 00 00 00 6B CA 00 03 C1 89 45 C4 8B 55 C4 8B 02 0F BE 08 81 E1 FF 00 00 00 89 4D 90 8B 55 C4 8B 02 83 C0 01 8B 4D C4 89 01 EB 1B E8 ?? ?? ?? ?? BA 20 00 00 00 6B CA 00 03 C1 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 90 8B 55 90 89 55 E4 E9 5A FF FF FF 8B 45 DC C6 00 00 E9 36 02 00 00 8B 4D 0C 89 4D D8 83 7D E4 0A 0F 84 AB 00 00 00 83 7D E4 FF 0F 84 A1 00 00 00 83 7D D8 00 76 1A 8B 55 D8 83 EA 01 89 55 D8 8B 45 DC 8A 4D E4 88 08 8B 55 DC 83 C2 01 89 55 DC E8 ?? ?? ?? ?? B9 20 00 00 00 6B D1 00 8D 44 10 04 89 45 C0 8B 4D C0 8B 11 83 EA 01 8B 45 C0 89 10 8B 4D C0 83 39 00 7C 32 E8 ?? ?? ?? ?? BA 20 00 00 00 6B CA 00 03 C1 89 45 BC 8B 55 BC 8B 02 0F BE 08 81 E1 FF 00 00 00 89 4D 8C 8B 55 BC 8B 02 83 C0 01 8B 4D BC 89 01 EB 1B E8 ?? ?? ?? ?? BA 20 00 00 00 6B CA 00 03 C1 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 8C 8B 55 8C 89 55 E4 E9 4B FF FF FF 83 7D D8 00 0F 85 F5 00 00 00 8B 45 08 C6 00 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 4D 0C 83 E9 01 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 88 EB 09 8B 45 0C 83 E8 01 89 45 88 8B 4D 88 51 68 FE 00 00 00 8B 55 08 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 0C B8 ?? ?? ?? ?? 85 C0 74 0D 33 C9 74 09 C7 45 84 01 00 00 00 EB 07 C7 45 84 00 00 00 00 8B 55 84 89 55 80 83 7D 80 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 59 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D 80 00 75 4E E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 6A 59 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 78 FF FF FF 00 00 00 00 6A FE 8D 4D F0 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 85 78 FF FF FF E9 A8 00 00 00 8B 55 DC C6 02 00 83 7D 0C FF 74 70 81 7D 0C FF FF FF 7F 74 67 8B 45 0C 2B 45 D8 83 C0 01 3B 45 0C 73 59 8B 4D 0C 2B 4D D8 83 C1 01 8B 55 0C 2B D1 39 15 ?? ?? ?? ?? 73 0D A1 ?? ?? ?? ?? 89 85 7C FF FF FF EB 14 8B 4D 0C 2B 4D D8 83 C1 01 8B 55 0C 2B D1 89 95 7C FF FF FF 8B 85 7C FF FF FF 50 68 FE 00 00 00 8B 4D 0C 2B 4D D8 8B 55 08 8D 44 0A 01 50 E8 ?? ?? ?? ?? 83 C4 0C C7 45 FC FE FF FF FF E8 02 00 00 00 EB 1B E8 ?? ?? ?? ?? B9 20 00 00 00 6B D1 00 03 C2 50 6A 00 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 45 D4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_1_0 {
	meta:
		name = "_gets"
		size = 21
		refs = "000c __gets_helper"
	strings:
		$1 = { 55 8B EC 6A 01 6A FF 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_346_0_0 {
	meta:
		name = "__getws"
		size = 21
		refs = "000c __getws_helper"
	strings:
		$1 = { 55 8B EC 6A 01 6A FF 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_43_2_0 {
	meta:
		name = "_gets_s"
		size = 23
		refs = "000e __gets_helper"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_30_208_3 {
	meta:
		name = "??$receive@I@Concurrency@@YAIPAV?$ISource@I@0@I@Z"
		size = 23
		refs = "000e ??$_Receive_impl@I@Concurrency@@YAIPAV?$ISource@I@0@IPBV?$function@$$A6A_NABI@Z@std@@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_30_210_3 {
	meta:
		name = "??$receive@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@AAV?$ISource@W4agent_status@Concurrency@@@0@I@Z"
		size = 23
		refs = "000e ??$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@PAV?$ISource@W4agent_status@Concurrency@@@0@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_30_212_3 {
	meta:
		name = "??$receive@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@PAV?$ISource@W4agent_status@Concurrency@@@0@I@Z"
		size = 23
		refs = "000e ??$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@PAV?$ISource@W4agent_status@Concurrency@@@0@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@std@@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_475_67_0 {
	meta:
		name = "?__InitializeCriticalSectionEx@platform@details@Concurrency@@YAHPAU_RTL_CRITICAL_SECTION@@K@Z"
		size = 23
		refs = "000e ___crtInitializeCriticalSectionEx"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_25_9_3 {
	meta:
		name = "__Cnd_wait"
		size = 23
		refs = "000e ?do_wait@@YAHPAPAU_Cnd_internal_imp_t@@PAPAU_Mtx_internal_imp_t@@PBUxtime@@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_266_1_0 {
	meta:
		name = "__aligned_malloc_base"
		size = 23
		refs = "000e __aligned_offset_malloc_base"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_304_4_0 {
	meta:
		name = "__atodbl"
		size = 23
		refs = "000e __atodbl_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_304_6_0 {
	meta:
		name = "__atoflt"
		size = 23
		refs = "000e __atoflt_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_304_8_0 {
	meta:
		name = "__atoldbl"
		size = 23
		refs = "000e __atoldbl_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_551_0_0 {
	meta:
		name = "__execvp"
		size = 23
		refs = "000e __execvpe"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_346_2_0 {
	meta:
		name = "__getws_s"
		size = 23
		refs = "000e __getws_helper"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_887_3_0 {
	meta:
		name = "__ismbslead"
		size = 23
		refs = "000e __ismbslead_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_844_3_0 {
	meta:
		name = "__ismbstrail"
		size = 23
		refs = "000e __ismbstrail_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1356_3_0 {
	meta:
		name = "__mbsbtype"
		size = 23
		refs = "000e __mbsbtype_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_331_3_0 {
	meta:
		name = "__mbschr"
		size = 23
		refs = "000e __mbschr_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_595_3_0 {
	meta:
		name = "__mbscmp"
		size = 23
		refs = "000e __mbscmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1082_3_0 {
	meta:
		name = "__mbscoll"
		size = 23
		refs = "000e __mbscoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1268_3_0 {
	meta:
		name = "__mbscspn"
		size = 23
		refs = "000e __mbscspn_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_88_3_0 {
	meta:
		name = "__mbsdec"
		size = 23
		refs = "000e __mbsdec_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_319_3_0 {
	meta:
		name = "__mbsicmp"
		size = 23
		refs = "000e __mbsicmp_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_179_3_0 {
	meta:
		name = "__mbsicoll"
		size = 23
		refs = "000e __mbsicoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1376_5_0 {
	meta:
		name = "__mbslwr_s"
		size = 23
		refs = "000e __mbslwr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1047_3_0 {
	meta:
		name = "__mbsnbcnt"
		size = 23
		refs = "000e __mbsnbcnt_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_810_3_0 {
	meta:
		name = "__mbsnccnt"
		size = 23
		refs = "000e __mbsnccnt_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_563_0_0 {
	meta:
		name = "__mbsninc"
		size = 23
		refs = "000e __mbsninc_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1225_3_0 {
	meta:
		name = "__mbsnlen"
		size = 23
		refs = "000e __mbsnlen_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_206_3_0 {
	meta:
		name = "__mbspbrk"
		size = 23
		refs = "000e __mbspbrk_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_155_3_0 {
	meta:
		name = "__mbsrchr"
		size = 23
		refs = "000e __mbsrchr_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_458_3_0 {
	meta:
		name = "__mbsset"
		size = 23
		refs = "000e __mbsset_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_75_3_0 {
	meta:
		name = "__mbsspn"
		size = 23
		refs = "000e __mbsspn_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_581_3_0 {
	meta:
		name = "__mbsspnp"
		size = 23
		refs = "000e __mbsspnp_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1061_3_0 {
	meta:
		name = "__mbsstr"
		size = 23
		refs = "000e __mbsstr_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_900_0_0 {
	meta:
		name = "__mbstok"
		size = 23
		refs = "000e __mbstok_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1125_3_0 {
	meta:
		name = "__mbstrnlen"
		size = 23
		refs = "000e __mbstrnlen_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1077_5_0 {
	meta:
		name = "__mbsupr_s"
		size = 23
		refs = "000e __mbsupr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1327_9_0 {
	meta:
		name = "__strlwr_s"
		size = 23
		refs = "000e __strlwr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_807_9_0 {
	meta:
		name = "__strupr_s"
		size = 23
		refs = "000e __strupr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_926_9_0 {
	meta:
		name = "__wcslwr_s"
		size = 23
		refs = "000e __wcslwr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_387_9_0 {
	meta:
		name = "__wcsupr_s"
		size = 23
		refs = "000e __wcsupr_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "__wexecvp"
		size = 23
		refs = "000e __wexecvpe"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_823_4_0 {
	meta:
		name = "_strcoll"
		size = 23
		refs = "000e __strcoll_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_147_4_0 {
	meta:
		name = "_strtod"
		size = 23
		refs = "000e __strtod_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_240_4_0 {
	meta:
		name = "_wcstod"
		size = 23
		refs = "000e __wcstod_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_366_15_0 {
	meta:
		name = "_wcstof"
		size = 23
		refs = "000e __wcstof_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "__mbsncat_s"
		size = 31
		refs = "0016 __mbsncat_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_266_7_0 {
	meta:
		name = "__aligned_recalloc_base"
		size = 31
		refs = "0016 __aligned_offset_recalloc_base"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_140_11_0 {
	meta:
		name = "__cftof"
		size = 31
		refs = "0016 __cftof_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_1266_0_0 {
	meta:
		name = "__mbccpy_s"
		size = 31
		refs = "0016 __mbccpy_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "__mbsnbcat_s"
		size = 31
		refs = "0016 __mbsnbcat_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_1146_0_0 {
	meta:
		name = "__mbsnbcpy_s"
		size = 31
		refs = "0016 __mbsnbcpy_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_1339_0_0 {
	meta:
		name = "__mbsnbset_s"
		size = 31
		refs = "0016 __mbsnbset_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_359_0_0 {
	meta:
		name = "__mbsncpy_s"
		size = 31
		refs = "0016 __mbsncpy_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_1221_0_0 {
	meta:
		name = "__mbsnset_s"
		size = 31
		refs = "0016 __mbsnset_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "__cputs"
		size = 303
		refs = "0006 __sehtable$__cputs 000b __except_handler4 001d ___security_cookie 005a ??_C@_1CC@OLIJCKA@?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 005f ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0068 ??_C@_1EO@LLNBJNEI@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAl?$AAo?$AAw?$AAi?$AAo?$AA?2?$AAc@ 006f __CrtDbgReportW 0083 ___doserrno 008e __errno 00a2 ??_C@_1O@PLNHBNGC@?$AA_?$AAc?$AAp?$AAu?$AAt?$AAs?$AA?$AA@ 00ac __invalid_parameter 00bb __lock 00ea __putch_nolock 0112 __unlock"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 DC 00 00 00 00 83 7D 08 00 74 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 45 E4 89 45 E0 83 7D E0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E0 00 75 36 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 31 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 65 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 55 08 0F BE 02 85 C0 74 2E 8B 4D 08 0F BE 11 89 55 D8 8B 45 08 83 C0 01 89 45 08 8B 4D D8 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 75 09 C7 45 DC FF FF FF FF EB 02 EB C8 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 DC 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_48_3_0 {
	meta:
		name = "__ismbcgraph"
		size = 19
		refs = "000a __ismbcgraph_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_25_7_3 {
	meta:
		name = "__Cnd_signal"
		size = 19
		refs = "000a ?do_signal@@YAHPAPAU_Cnd_internal_imp_t@@H@Z"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_26_155_3 {
	meta:
		name = "__Mtx_lock"
		size = 19
		refs = "000a ?mtx_do_lock@@YAHPAPAU_Mtx_internal_imp_t@@PBUxtime@@@Z"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_140_16_0 {
	meta:
		name = "__cropzeros"
		size = 19
		refs = "000a __cropzeros_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_140_20_0 {
	meta:
		name = "__forcdecpt"
		size = 19
		refs = "000a __forcdecpt_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_483_16_0 {
	meta:
		name = "__ismbbkana"
		size = 19
		refs = "000a __ismbbkana_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_1381_3_0 {
	meta:
		name = "__ismbcalnum"
		size = 19
		refs = "000a __ismbcalnum_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_1166_3_0 {
	meta:
		name = "__ismbcalpha"
		size = 19
		refs = "000a __ismbcalpha_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_445_3_0 {
	meta:
		name = "__ismbcblank"
		size = 19
		refs = "000a __ismbcblank_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_1292_3_0 {
	meta:
		name = "__ismbcdigit"
		size = 19
		refs = "000a __ismbcdigit_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_378_3_0 {
	meta:
		name = "__ismbchira"
		size = 19
		refs = "000a __ismbchira_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_378_5_0 {
	meta:
		name = "__ismbckata"
		size = 19
		refs = "000a __ismbckata_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_574_3_0 {
	meta:
		name = "__ismbcl0"
		size = 19
		refs = "000a __ismbcl0_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_574_5_0 {
	meta:
		name = "__ismbcl1"
		size = 19
		refs = "000a __ismbcl1_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_574_7_0 {
	meta:
		name = "__ismbcl2"
		size = 19
		refs = "000a __ismbcl2_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_732_3_0 {
	meta:
		name = "__ismbclegal"
		size = 19
		refs = "000a __ismbclegal_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_120_3_0 {
	meta:
		name = "__ismbclower"
		size = 19
		refs = "000a __ismbclower_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_796_3_0 {
	meta:
		name = "__ismbcprint"
		size = 19
		refs = "000a __ismbcprint_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_445_5_0 {
	meta:
		name = "__ismbcpunct"
		size = 19
		refs = "000a __ismbcpunct_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_290_3_0 {
	meta:
		name = "__ismbcspace"
		size = 19
		refs = "000a __ismbcspace_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_378_7_0 {
	meta:
		name = "__ismbcsymbol"
		size = 19
		refs = "000a __ismbcsymbol_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_489_3_0 {
	meta:
		name = "__ismbcupper"
		size = 19
		refs = "000a __ismbcupper_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_1097_3_0 {
	meta:
		name = "__mbbtombc"
		size = 19
		refs = "000a __mbbtombc_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_791_3_0 {
	meta:
		name = "__mbcjistojms"
		size = 19
		refs = "000a __mbcjistojms_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_791_5_0 {
	meta:
		name = "__mbcjmstojis"
		size = 19
		refs = "000a __mbcjmstojis_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_1034_0_0 {
	meta:
		name = "__mbctohira"
		size = 19
		refs = "000a __mbctohira_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_1171_0_0 {
	meta:
		name = "__mbctokata"
		size = 19
		refs = "000a __mbctokata_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_902_3_0 {
	meta:
		name = "__mbctolower"
		size = 19
		refs = "000a __mbctolower_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_1097_5_0 {
	meta:
		name = "__mbctombb"
		size = 19
		refs = "000a __mbctombb_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_1062_3_0 {
	meta:
		name = "__mbctoupper"
		size = 19
		refs = "000a __mbctoupper_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_1404_3_0 {
	meta:
		name = "__mbslen"
		size = 19
		refs = "000a __mbslen_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_1231_3_0 {
	meta:
		name = "__mbsnextc"
		size = 19
		refs = "000a __mbsnextc_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_300_3_0 {
	meta:
		name = "__mbsrev"
		size = 19
		refs = "000a __mbsrev_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_268_2_0 {
	meta:
		name = "__mkgmtime32"
		size = 19
		refs = "000a __make__time32_t"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_1294_2_0 {
	meta:
		name = "__mkgmtime64"
		size = 19
		refs = "000a __make__time64_t"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_357_5_0 {
	meta:
		name = "__wtof"
		size = 19
		refs = "000a __wtof_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_1180_6_0 {
	meta:
		name = "_atof"
		size = 19
		refs = "000a __atof_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_965_20_0 {
	meta:
		name = "_isleadbyte"
		size = 19
		refs = "000a __isleadbyte_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_48_4_0 {
	meta:
		name = "__ismbcgraph_l"
		size = 378
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 005a ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0072 ??1_LocaleUpdate@@QAE@XZ 00a5 ___crtGetStringTypeA"
	strings:
		$1 = { 55 8B EC 83 EC 30 8B 45 0C 50 8D 4D D0 E8 ?? ?? ?? ?? 81 7D 08 FF 00 00 00 0F 86 F3 00 00 00 33 C9 66 89 4D F8 33 D2 66 89 55 FA 8B 45 08 C1 E8 08 25 FF 00 00 00 B9 01 00 00 00 6B D1 00 88 44 15 FC 8B 45 08 25 FF 00 00 00 B9 01 00 00 00 C1 E1 00 88 44 0D FC 8D 4D D0 E8 ?? ?? ?? ?? 8B 50 04 83 7A 08 00 75 17 C7 45 EC 00 00 00 00 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 EC E9 F8 00 00 00 6A 01 8D 4D D0 E8 ?? ?? ?? ?? 8B 40 04 8B 48 04 51 8D 55 F8 52 6A 02 8D 45 FC 50 6A 01 8D 4D D0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 17 C7 45 E8 00 00 00 00 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 E8 E9 AF 00 00 00 B9 02 00 00 00 C1 E1 00 0F B7 54 0D F8 85 D2 75 1E B8 02 00 00 00 6B C8 00 0F B7 54 0D F8 81 E2 17 01 00 00 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 89 45 E4 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 E4 EB 66 EB 5C 8D 4D D0 E8 ?? ?? ?? ?? 8B 08 0F B6 55 08 8B 81 90 00 00 00 0F B7 0C 50 81 E1 17 01 00 00 75 22 8D 4D D0 E8 ?? ?? ?? ?? 8B 50 04 0F B6 45 08 0F B6 4C 02 19 83 E1 03 75 09 C7 45 F0 00 00 00 00 EB 07 C7 45 F0 01 00 00 00 8B 55 F0 89 55 E0 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 E0 EB 08 8D 4D D0 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "___sse2_asinf4"
		size = 336
		refs = "000f ___common_sasin_data 013c ___common_sasin_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 0F 28 2D ?? ?? ?? ?? 0F 28 F5 0F 55 E8 0F 54 F0 0F 28 1D ?? ?? ?? ?? 0F 28 FE 0F 59 FB 0F 28 E6 0F 59 E6 0F 28 15 ?? ?? ?? ?? 0F C2 D6 02 0F 29 04 24 0F 28 C3 0F 50 D2 0F 28 D6 0F C2 D3 05 0F 5C C7 0F 52 D8 0F 5D E0 0F 58 C0 0F 28 CB 0F 28 FC 0F 59 CB 85 D2 0F 59 D8 0F 59 FC 0F 59 C1 0F 28 0D ?? ?? ?? ?? 0F 5C 05 ?? ?? ?? ?? 0F 59 C8 0F 59 C3 0F 58 0D ?? ?? ?? ?? 0F 59 C8 0F 28 05 ?? ?? ?? ?? 0F 5C CB 0F 59 C4 0F 28 1D ?? ?? ?? ?? 0F 54 CA 0F 59 DC 0F 58 05 ?? ?? ?? ?? 0F 59 C7 0F 58 1D ?? ?? ?? ?? 0F 58 C3 0F 59 C4 0F 58 05 ?? ?? ?? ?? 0F 59 C4 0F 28 E2 0F 55 E6 0F 56 E1 0F 59 C4 0F 28 35 ?? ?? ?? ?? 0F 58 C4 0F 54 F2 0F 58 C6 66 0F EF C5 75 04 8B E5 5D C3 0F 28 0C 24 0F 29 4C 24 40 0F 29 84 24 80 00 00 00 74 E9 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 8B CE B8 01 00 00 00 D3 E0 85 F8 75 17 46 83 FE 20 7C ED 8B 74 24 04 8B 3C 24 0F 28 84 24 80 00 00 00 EB B8 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB D2 8D A4 24 00 00 00 00 8D 64 24 00 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "__execle"
		size = 552
		refs = "002f ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0034 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 003d ??_C@_1EO@BJAJEIPO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAe?$AAx?$AAe?$AAc?$AA?2?$AAe?$AAx@ 0044 __CrtDbgReportW 0058 __errno 006c ??_C@_1BA@GFKLKNMG@?$AA_?$AAe?$AAx?$AAe?$AAc?$AAl?$AAe?$AA?$AA@ 0076 __invalid_parameter 00ac ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 0125 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01a2 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 021d __execve"
	strings:
		$1 = { 55 8B EC 83 EC 28 8D 45 0C 89 45 FC 83 7D 08 00 74 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8B 4D F8 89 4D F4 83 7D F4 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 9F 01 00 00 8B 45 08 0F BE 08 85 C9 74 09 C7 45 F0 01 00 00 00 EB 07 C7 45 F0 00 00 00 00 8B 55 F0 89 55 EC 83 7D EC 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D EC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 35 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 22 01 00 00 83 7D 0C 00 74 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D E4 83 7D E4 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A9 00 00 00 8B 45 0C 0F BE 08 85 C9 74 09 C7 45 E0 01 00 00 00 EB 07 C7 45 E0 00 00 00 00 8B 55 E0 89 55 DC 83 7D DC 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D DC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 2F 8B 4D FC 8B 11 89 55 D8 8B 45 FC 83 C0 04 89 45 FC 83 7D D8 00 74 02 EB E7 8B 4D FC 8B 11 52 8D 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "_feupdateenv"
		size = 62
		refs = "0007 _fetestexcept 0016 _fesetenv 0026 _feraiseexcept"
	strings:
		$1 = { 55 8B EC 51 6A 1F E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 10 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_6_0 {
	meta:
		name = "??$_InternalDeleteHelper@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@YAXPAVVirtualProcessor@01@@Z"
		size = 54
		altNames = "??$_InternalDeleteHelper@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@YAXPAVScheduleGroupSegmentBase@01@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 08 89 45 F8 8B 4D F8 89 4D FC 83 7D FC 00 74 13 6A 01 8B 55 FC 8B 02 8B 4D FC 8B 10 FF D2 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_20_0 {
	meta:
		name = "??0VirtualProcessor@details@Concurrency@@QAE@XZ"
		size = 175
		refs = "0006 __ehhandler$??0VirtualProcessor@details@Concurrency@@QAE@XZ 0013 ___security_cookie 002b ??_7VirtualProcessor@details@Concurrency@@6B@ 0040 ??0?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@PAV_HyperNonReentrantLock@12@@Z 0052 ??0WorkSearchContext@details@Concurrency@@QAE@XZ 0060 ??0_HyperNonReentrantLock@details@Concurrency@@QAE@XZ 006e ??0location@Concurrency@@QAE@XZ 0080 ??0QuickBitSet@details@Concurrency@@QAE@XZ 0092 ??0SafePointMarker@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 C7 00 ?? ?? ?? ?? 8B 4D F0 81 C1 84 00 00 00 51 8B 4D F0 83 C1 10 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 8B 4D F0 83 C1 28 E8 ?? ?? ?? ?? 8B 4D F0 81 C1 84 00 00 00 E8 ?? ?? ?? ?? 8B 4D F0 81 C1 94 00 00 00 E8 ?? ?? ?? ?? C6 45 FC 01 8B 4D F0 81 C1 A4 00 00 00 E8 ?? ?? ?? ?? C6 45 FC 02 8B 4D F0 81 C1 C0 00 00 00 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 45 F0 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_25_0 {
	meta:
		name = "??0WorkSearchContext@details@Concurrency@@QAE@XZ"
		size = 53
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 00 00 00 00 00 8B 4D FC C7 41 04 00 00 00 00 8B 55 FC C7 42 20 00 00 00 00 8B 45 FC C7 40 24 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_36_0 {
	meta:
		name = "??1VirtualProcessor@details@Concurrency@@UAE@XZ"
		size = 215
		refs = "0006 __ehhandler$??1VirtualProcessor@details@Concurrency@@UAE@XZ 0013 ___security_cookie 002b ??_7VirtualProcessor@details@Concurrency@@6B@ 003d ?Count@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QBEHXZ 0046 ??_C@_1EK@KEDHMOCL@?$AAm?$AA_?$AAl?$AAo?$AAc?$AAa?$AAl?$AAR?$AAu?$AAn?$AAn?$AAa?$AAb?$AAl?$AAe?$AAC?$AAo?$AAn?$AAt?$AAe?$AAx?$AAt?$AAs?$AA?4?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?$CI?$AA?$CJ?$AA?5@ 004b ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0054 ??_C@_1GK@KLIIPLJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 005b __CrtDbgReportW 0081 ?ReturnSubAllocator@SchedulerBase@details@Concurrency@@SAXPAVSubAllocator@23@@Z 00a0 ??1QuickBitSet@details@Concurrency@@QAE@XZ 00b2 ??1location@Concurrency@@QAE@XZ 00c4 ??1?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 C7 00 ?? ?? ?? ?? C7 45 FC 02 00 00 00 8B 4D F0 83 C1 10 E8 ?? ?? ?? ?? 85 C0 74 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 65 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CA 33 C0 75 C6 8B 4D F0 83 79 5C 00 74 19 8B 55 F0 8B 42 5C 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F0 C7 41 5C 00 00 00 00 C6 45 FC 01 8B 4D F0 81 C1 A4 00 00 00 E8 ?? ?? ?? ?? C6 45 FC 00 8B 4D F0 81 C1 94 00 00 00 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8B 4D F0 83 C1 10 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_61_0 {
	meta:
		name = "?AcknowledgedAffinityMessage@SchedulerBase@details@Concurrency@@QAE_NI@Z"
		size = 59
		refs = "0014 ?IsSet@QuickBitSet@details@Concurrency@@QBE_NI@Z 002e ?InterlockedClear@QuickBitSet@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 08 50 8B 4D F8 83 C1 54 E8 ?? ?? ?? ?? 88 45 FF 0F B6 4D FF 85 C9 74 0F 8B 55 08 52 8B 4D F8 83 C1 54 E8 ?? ?? ?? ?? 8A 45 FF 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_62_0 {
	meta:
		name = "?Activate@VirtualProcessor@details@Concurrency@@QAEXPAUIExecutionContext@3@@Z"
		size = 36
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC 8B 51 58 8B 45 FC 8B 12 8B 48 58 8B 42 14 FF D0 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_63_0 {
	meta:
		name = "?Affinitize@VirtualProcessor@details@Concurrency@@MAEXPAVInternalContextBase@23@@Z"
		size = 132
		refs = "0011 ?SpinUntilBlocked@InternalContextBase@details@Concurrency@@IAEXXZ 002a ?ClearDebugBits@InternalContextBase@details@Concurrency@@QAEXXZ 0034 ?SetDebugBits@InternalContextBase@details@Concurrency@@QAEXK@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 83 7D 08 00 74 2B 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 4D 08 8B 11 8B 4D 08 8B 42 1C FF D0 8B 4D 08 E8 ?? ?? ?? ?? 6A 40 8B 4D 08 E8 ?? ?? ?? ?? 8B 4D FC 8B 55 08 89 51 7C 83 7D 08 00 74 37 8B 45 08 8A 88 B3 00 00 00 80 E1 01 0F B6 D1 85 D2 74 24 8B 45 FC 8B 48 6C 83 C1 01 8B 55 FC 89 4A 6C 8B 45 08 8A 88 B3 00 00 00 80 E1 FE 8B 55 08 88 8A B3 00 00 00 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_64_0 {
	meta:
		name = "?CheckAffinityNotification@VirtualProcessor@details@Concurrency@@QAE_NXZ"
		size = 75
		refs = "002f ?GetOwningNode@VirtualProcessor@details@Concurrency@@QAEPAVSchedulingNode@23@XZ 0036 ?GetScheduler@SchedulingNode@details@Concurrency@@QAEPAVSchedulerBase@23@XZ 003d ?AcknowledgedAffinityMessage@SchedulerBase@details@Concurrency@@QAE_NI@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 0F B6 48 62 85 C9 74 0D 8B 55 F8 C6 42 62 00 B0 01 EB 28 EB 26 8B 45 F8 8B 88 90 00 00 00 51 8B 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 88 45 FF 8A 45 FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_68_0 {
	meta:
		name = "?ClaimExclusiveOwnership@VirtualProcessor@details@Concurrency@@QAE_NAAVClaimTicket@123@K_N@Z"
		size = 348
		refs = "0017 ??_C@_0DF@MCLEPNNI@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 001c ??_C@_0BM@PDKNNJDG@type?5?$CB?$DN?5AvailabilityClaimed?$AA@ 0021 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 00cd ??_C@_0CK@HEDBOHLP@m_availabilityType?5?$DN?$DN?5Availabili@ 0143 ?InitializeTicket@ClaimTicket@VirtualProcessor@details@Concurrency@@AAEXW4AvailabilityType@234@PAV234@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 14 89 4D F8 83 7D 0C 00 74 02 EB 17 68 84 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F8 8B 48 08 89 4D F0 8B 55 F0 23 55 0C 0F 84 17 01 00 00 C7 45 F4 00 00 00 00 C6 45 FF 00 83 7D 0C 0F 75 2B 33 C0 8B 4D F8 83 C1 08 87 01 89 45 F4 83 7D F4 00 74 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8A 55 EC 88 55 FF EB 32 8B 45 F0 23 45 0C 75 02 EB 28 33 C9 8B 55 F8 83 C2 08 8B 45 F0 F0 0F B1 0A 89 45 F4 8B 45 F4 3B 45 F0 75 06 C6 45 FF 01 EB 08 8B 4D F4 89 4D F0 EB CE 0F B6 55 FF 85 D2 0F 84 9D 00 00 00 8B 45 F8 83 78 08 00 75 02 EB 17 68 A5 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 0F B6 4D 10 85 C9 74 56 8B 55 F8 8B 42 50 8B 08 81 C1 B4 01 00 00 83 CA FF F0 0F C1 11 8B 45 F8 8B 48 50 83 C1 1C 83 CA FF F0 0F C1 11 83 7D F4 04 74 06 83 7D F4 08 75 25 8B 45 F8 8B 48 50 8B 11 81 C2 B8 01 00 00 83 C8 FF F0 0F C1 02 8B 4D F8 8B 51 50 83 C2 20 83 C8 FF F0 0F C1 02 8B 4D F8 51 8B 55 F4 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 F8 8B 4D F4 89 48 0C B0 01 EB 02 32 C0 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_53_69_0 {
	meta:
		name = "?ClaimantType@VirtualProcessor@details@Concurrency@@QBE?AW4AvailabilityType@123@XZ"
		size = 72
		refs = "0011 ??_C@_1FE@CGCEPKIE@?$AAm?$AA_?$AAa?$AAv?$AAa?$AAi?$AAl?$AAa?$AAb?$AAi?$AAl?$AAi?$AAt?$AAy?$AAT?$AAy?$AAp?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAA?$AAv?$AAa?$AAi?$AAl?$AAa?$AAb?$AAi?$AAl?$AAi@ 0016 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0022 ??_C@_1GG@GKIPIGIE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0029 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 78 08 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 F2 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 8B 4D FC 8B 41 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_70_0 {
	meta:
		name = "?ClaimantWasInactive@VirtualProcessor@details@Concurrency@@QBE_NXZ"
		size = 45
		refs = "000d ?ClaimantType@VirtualProcessor@details@Concurrency@@QBE?AW4AvailabilityType@123@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 4D F8 E8 ?? ?? ?? ?? 83 E0 05 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_71_0 {
	meta:
		name = "?ClearDebugBits@InternalContextBase@details@Concurrency@@QAEXXZ"
		size = 24
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC C7 80 CC 00 00 00 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_72_0 {
	meta:
		name = "?ClearQuickCacheSlot@SchedulerBase@details@Concurrency@@QAEXI@Z"
		size = 57
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 C1 E0 05 8B 4D FC 8B 51 5C 83 3C 82 01 75 1A 33 C9 8B 55 08 C1 E2 05 8B 45 FC 8B 40 5C 8D 14 90 B8 01 00 00 00 F0 0F B1 0A 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_74_0 {
	meta:
		name = "?Deactivate@VirtualProcessor@details@Concurrency@@QAE_NPAUIExecutionContext@3@@Z"
		size = 36
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC 8B 51 58 8B 45 FC 8B 12 8B 48 58 8B 42 18 FF D0 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_75_0 {
	meta:
		name = "?DecrementActiveResourcesByMask@SchedulerBase@details@Concurrency@@QAEXI@Z"
		size = 28
		refs = "0012 ?InterlockedClear@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC 83 C1 30 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_680_85_0 {
	meta:
		name = "?IncrementActiveResourcesByMask@SchedulerBase@details@Concurrency@@QAEXI@Z"
		size = 28
		refs = "0012 ?InterlockedSet@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC 83 C1 30 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_76_0 {
	meta:
		name = "?DeleteElements@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
		size = 54
		refs = "0027 ??$_InternalDeleteHelper@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@YAXPAVVirtualProcessor@01@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 83 7D 08 00 74 21 8B 45 08 2D BC 00 00 00 89 45 FC 8B 4D 08 8B 11 89 55 08 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 EB D9 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_78_0 {
	meta:
		name = "?EnsureAllTasksVisible@VirtualProcessor@details@Concurrency@@QAEXPAUIExecutionContext@3@@Z"
		size = 36
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC 8B 51 58 8B 45 FC 8B 12 8B 48 58 8B 42 1C FF D0 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_79_0 {
	meta:
		name = "?Exercise@ClaimTicket@VirtualProcessor@details@Concurrency@@QAE_NPAVScheduleGroupSegmentBase@34@@Z"
		size = 104
		refs = "0012 ??_C@_1DM@DLMMAHEJ@?$AAm?$AA_?$AAt?$AAy?$AAp?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAA?$AAv?$AAa?$AAi?$AAl?$AAa?$AAb?$AAi?$AAl?$AAi?$AAt?$AAy?$AAC?$AAl?$AAa?$AAi?$AAm?$AAe?$AAd?$AA?$AA@ 0017 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0020 ??_C@_1GG@GKIPIGIE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0027 __CrtDbgReportW 004f ?ExerciseClaim@VirtualProcessor@details@Concurrency@@AAE_NW4AvailabilityType@123@PAVScheduleGroupSegmentBase@23@PAVInternalContextBase@23@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 83 38 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 76 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 D1 33 C0 75 CD 6A 00 8B 4D 08 51 8B 55 F8 8B 02 50 8B 4D F8 8B 49 04 E8 ?? ?? ?? ?? 88 45 FF 8B 55 F8 C7 02 00 00 00 00 8A 45 FF 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_80_0 {
	meta:
		name = "?ExerciseClaim@VirtualProcessor@details@Concurrency@@AAE_NW4AvailabilityType@123@PAVScheduleGroupSegmentBase@23@PAVInternalContextBase@23@@Z"
		size = 489
		refs = "000d ?GetOwningNode@VirtualProcessor@details@Concurrency@@QAEPAVSchedulingNode@23@XZ 0014 ?GetScheduler@SchedulingNode@details@Concurrency@@QAEPAVSchedulerBase@23@XZ 002d ??_C@_0DF@MCLEPNNI@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0032 ??_C@_0BM@PDKNNJDG@type?5?$CB?$DN?5AvailabilityClaimed?$AA@ 0037 ?_ConcRT_CoreAssert@details@Concurrency@@YAXPBD0H@Z 0065 ?VirtualProcessorActive@SchedulerBase@details@Concurrency@@QAE_N_N@Z 007a ?IsPrepared@InternalContextBase@details@Concurrency@@QBE_NXZ 0092 ??_C@_0BI@GFELCHNG@?$CBpContext?9?$DOIsPrepared?$CI?$CJ?$AA@ 00a8 ?ReleaseInternalContext@SchedulerBase@details@Concurrency@@QAEXPAVInternalContextBase@23@_N@Z 00b6 ?MakeAvailable@VirtualProcessor@details@Concurrency@@IAEXW4AvailabilityType@123@_N@Z 00cb ?GetAnonymousScheduleGroupSegment@SchedulerBase@details@Concurrency@@QAEPAVScheduleGroupSegmentBase@23@XZ 00ff ??_C@_0BB@BJGACNAO@pContext?5?$DN?$DN?5NULL?$AA@ 0148 ??_C@_0BM@EHJDEOMN@m_pAvailableContext?5?$CB?$DN?5NULL?$AA@ 0189 ?_GetVirtualProcessor@InternalContextBase@details@Concurrency@@IBEPAVVirtualProcessor@23@XZ 01b8 ??_C@_0CB@MIDJGFOP@pVProc?5?$DN?$DN?5this?5?$HM?$HM?5pVProc?5?$DN?$DN?5NULL@"
	strings:
		$1 = { 55 8B EC 83 EC 18 89 4D F8 8B 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 89 45 F0 C6 45 FF 00 83 7D 08 00 74 02 EB 17 68 A5 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 89 45 F4 83 7D F4 01 74 15 83 7D F4 04 74 0F 83 7D F4 08 0F 84 92 00 00 00 E9 B1 00 00 00 6A 01 8B 4D F0 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 51 83 7D 10 00 74 36 8B 4D 10 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 02 EB 17 68 B6 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 6A 01 8B 45 10 50 8B 4D F0 E8 ?? ?? ?? ?? 6A 00 8B 4D 08 51 8B 4D F8 E8 ?? ?? ?? ?? 32 C0 E9 22 01 00 00 83 7D 0C 00 75 0B 8B 4D F0 E8 ?? ?? ?? ?? 89 45 0C 8B 55 10 52 8B 45 0C 50 8B 4D F8 8B 11 8B 4D F8 8B 42 1C FF D0 E9 F7 00 00 00 83 7D 10 00 75 02 EB 17 68 D0 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C E9 B4 00 00 00 83 7D 10 00 75 02 EB 17 68 D8 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F8 83 B9 80 00 00 00 00 74 02 EB 17 68 DA 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 55 F8 8B 82 80 00 00 00 50 8B 4D F8 8B 11 8B 4D F8 8B 42 14 FF D0 85 C0 74 23 8B 4D F8 8B 91 80 00 00 00 52 8B 45 F8 8B 10 8B 4D F8 8B 42 14 FF D0 8B C8 E8 ?? ?? ?? ?? 89 45 EC EB 07 C7 45 EC 00 00 00 00 8B 4D EC 89 4D E8 8B 55 E8 3B 55 F8 74 1D 83 7D E8 00 74 17 68 E7 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F8 8B 88 80 00 00 00 51 8B 55 F8 8B 42 58 8B 4D F8 8B 10 8B 49 58 8B 42 14 FF D0 B0 01 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_53_81_0 {
	meta:
		name = "?ExerciseWakesExisting@ClaimTicket@VirtualProcessor@details@Concurrency@@QBE_NXZ"
		size = 48
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 83 38 02 74 11 8B 4D FC 83 39 08 74 09 C7 45 F8 00 00 00 00 EB 07 C7 45 F8 01 00 00 00 8A 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_82_0 {
	meta:
		name = "?ExerciseWith@ClaimTicket@VirtualProcessor@details@Concurrency@@QAE_NPAVInternalContextBase@34@@Z"
		size = 89
		refs = "0020 ?GetOwningNode@VirtualProcessor@details@Concurrency@@QAEPAVSchedulingNode@23@XZ 0027 ?GetSchedulingRing@SchedulingNode@details@Concurrency@@QAEPAVSchedulingRing@23@XZ 002e ?GetAnonymousScheduleGroupSegment@SchedulingRing@details@Concurrency@@QBEPAVScheduleGroupSegmentBase@23@XZ 0040 ?ExerciseClaim@VirtualProcessor@details@Concurrency@@AAE_NW4AvailabilityType@123@PAVScheduleGroupSegmentBase@23@PAVInternalContextBase@23@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 C6 45 FF 00 8B 45 F8 83 38 00 74 3B 8B 4D 08 51 8B 55 F8 8B 4A 04 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B 45 F8 8B 08 51 8B 55 F8 8B 4A 04 E8 ?? ?? ?? ?? 88 45 FF 8B 45 F8 C7 00 00 00 00 00 8A 45 FF 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_84_0 {
	meta:
		name = "?Find@?$Hash@II@details@Concurrency@@QAEPAUListNode@123@ABIPAI@Z"
		size = 79
		refs = "0014 ?HashValue@?$Hash@II@details@Concurrency@@CAIABIH@Z 0024 ?Lookup@?$Hash@II@details@Concurrency@@AAEPAUListNode@123@ABIH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 50 8B 45 08 50 8B 4D F8 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 16 83 7D 0C 00 74 0B 8B 4D 0C 8B 55 FC 8B 42 08 89 01 8B 45 FC EB 02 33 C0 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_686_108_0 {
	meta:
		name = "?Find@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEPAUListNode@123@ABQAV_TaskCollection@23@PAPAV523@@Z"
		size = 79
		refs = "0014 ?HashValue@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAIABQAV_TaskCollection@23@H@Z 0024 ?Lookup@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@ABQAV_TaskCollection@23@H@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 50 8B 45 08 50 8B 4D F8 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 16 83 7D 0C 00 74 0B 8B 4D 0C 8B 55 FC 8B 42 08 89 01 8B 45 FC EB 02 33 C0 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_53_87_0 {
	meta:
		name = "?GetCurrentSubAllocator@VirtualProcessor@details@Concurrency@@QAEPAVSubAllocator@23@XZ"
		size = 42
		refs = "0013 ?GetSubAllocator@SchedulerBase@details@Concurrency@@SAPAVSubAllocator@23@_N@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 78 5C 00 75 10 6A 00 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 89 41 5C 8B 55 FC 8B 42 5C 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_89_0 {
	meta:
		name = "?GetDequeuedTaskCount@VirtualProcessor@details@Concurrency@@AAEIXZ"
		size = 101
		refs = "0031 ??_C@_1CI@BMIKGCIC@?$AAr?$AAe?$AAt?$AAV?$AAa?$AAl?$AA?5?$AA?$DM?$AA?5?$AA2?$AA1?$AA4?$AA7?$AA4?$AA8?$AA3?$AA6?$AA4?$AA7?$AA?$AA@ 0036 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0042 ??_C@_1GG@GKIPIGIE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0049 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 8B 48 6C 89 4D F8 8B 55 FC 8B 45 F8 2B 42 74 89 45 F4 8B 4D FC 8B 55 F8 89 51 74 81 7D F4 FF FF FF 7F 72 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 DA 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_90_0 {
	meta:
		name = "?GetEnqueuedTaskCount@VirtualProcessor@details@Concurrency@@AAEIXZ"
		size = 101
		refs = "0031 ??_C@_1CI@BMIKGCIC@?$AAr?$AAe?$AAt?$AAV?$AAa?$AAl?$AA?5?$AA?$DM?$AA?5?$AA2?$AA1?$AA4?$AA7?$AA4?$AA8?$AA3?$AA6?$AA4?$AA7?$AA?$AA@ 0036 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0042 ??_C@_1GG@GKIPIGIE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0049 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 45 FC 8B 48 68 89 4D F8 8B 55 FC 8B 45 F8 2B 42 70 89 45 F4 8B 4D FC 8B 55 F8 89 51 70 81 7D F4 FF FF FF 7F 72 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C4 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 CD 33 D2 75 C9 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_91_0 {
	meta:
		name = "?GetLocalRunnableContext@VirtualProcessor@details@Concurrency@@AAEPAVInternalContextBase@23@XZ"
		size = 63
		refs = "0010 ?Count@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QBEHXZ 001f ?Pop@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ 002d ?SetContextDebugBits@details@Concurrency@@YAXPAVInternalContextBase@12@K@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 4D FC 83 C1 10 E8 ?? ?? ?? ?? 85 C0 7E 21 8B 4D FC 83 C1 10 E8 ?? ?? ?? ?? 89 45 F8 6A 08 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F8 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_92_0 {
	meta:
		name = "?GetMaskIdCount@SchedulerBase@details@Concurrency@@QBEIXZ"
		size = 16
		refs = "0008 ?GetProcessorCount@Concurrency@@YAIXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1099_148_0 {
	meta:
		name = "?YieldToSystem@FreeThreadProxy@details@Concurrency@@UAEXXZ"
		size = 16
		refs = "0008 ?__SwitchToThread@platform@details@Concurrency@@YAXXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_76_350_2 {
	meta:
		name = "?_Getdateorder@_Locinfo@std@@QBEHXZ"
		size = 16
		refs = "0008 __Getdateorder"
	strings:
		$1 = { 55 8B EC 51 89 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_110_298_1 {
	meta:
		name = "?_Getlconv@_Locinfo@std@@QBEPBUlconv@@XZ"
		size = 16
		refs = "0008 _localeconv"
	strings:
		$1 = { 55 8B EC 51 89 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_117_389_2 {
	meta:
		name = "?underflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MAEHXZ"
		size = 16
		refs = "0008 ?eof@?$char_traits@D@std@@SAHXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_72_418_3 {
	meta:
		name = "?underflow@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MAEGXZ"
		size = 16
		refs = "0008 ?eof@?$char_traits@G@std@@SAGXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_7_349_1 {
	meta:
		name = "?underflow@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MAEGXZ"
		size = 16
		refs = "0008 ?eof@?$char_traits@_W@std@@SAGXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_93_0 {
	meta:
		name = "?GetOwningNode@VirtualProcessor@details@Concurrency@@QAEPAVSchedulingNode@23@XZ"
		size = 17
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 40 50 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_94_0 {
	meta:
		name = "?GetResourceMaskId@SchedulerBase@details@Concurrency@@QAEII@Z"
		size = 95
		refs = "001b ?Find@?$Hash@II@details@Concurrency@@QAEPAUListNode@123@ABIPAI@Z 0029 ??_C@_1BG@DFKLBKHK@?$AAp?$AAN?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 002e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 003a ??_C@_1GA@HDKDPHDD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0041 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8D 45 F4 50 8D 4D 08 51 8B 4D FC 81 C1 68 01 00 00 E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 64 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 D0 33 C9 75 CC 8B 45 F4 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_96_0 {
	meta:
		name = "?GetSchedulerProxy@SchedulerBase@details@Concurrency@@QBEPAUISchedulerProxy@3@XZ"
		size = 20
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 80 AC 01 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_99_0 {
	meta:
		name = "?Grow@QuickBitSet@details@Concurrency@@QAEXI@Z"
		size = 228
		refs = "002f ??_C@_0CO@JCPJEILM@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 004d ??_U@YAPAXIV_ConcRTNewMoniker@@PBDH@Z 0061 ?ASIZE@QuickBitSet@details@Concurrency@@IBEIXZ 00b0 _memset 00c5 ??_V@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 56 89 4D F8 8B 45 F8 8B 4D 08 3B 08 0F 84 C5 00 00 00 8B 55 08 83 C2 1F C1 EA 05 89 55 E8 33 C0 88 45 FF 68 7A 07 00 00 68 ?? ?? ?? ?? 0F B6 4D FF 51 33 C9 8B 45 E8 BA 04 00 00 00 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E4 8B 45 E4 89 45 EC 8B 4D F8 E8 ?? ?? ?? ?? 89 45 F0 C7 45 F4 00 00 00 00 EB 09 8B 4D F4 83 C1 01 89 4D F4 8B 55 F4 3B 55 F0 73 17 8B 45 F8 8B 48 04 8B 55 F4 8B 45 EC 8B 75 F4 8B 0C B1 89 0C 90 EB D8 8B 55 E8 2B 55 F0 C1 E2 02 52 6A 00 8B 45 F0 8B 4D EC 8D 14 81 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F8 8B 48 04 89 4D E0 8B 55 E0 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 F8 8B 4D EC 89 48 04 8B 55 F8 8B 45 08 89 02 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_101_0 {
	meta:
		name = "?IgnoreAffinity@SchedulerBase@details@Concurrency@@QAEXI@Z"
		size = 28
		refs = "0012 ?InterlockedClear@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC 83 C1 48 E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_102_0 {
	meta:
		name = "?Initialize@VirtualProcessor@details@Concurrency@@MAEXPAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 641
		refs = "0006 __ehhandler$?Initialize@VirtualProcessor@details@Concurrency@@MAEXPAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0015 ___security_cookie 0070 ?GetSchedulingRing@SchedulingNode@details@Concurrency@@QAEPAVSchedulingRing@23@XZ 00ea ?Reset@SafePointMarker@details@Concurrency@@QAEXXZ 0114 ?GetScheduler@SchedulingNode@details@Concurrency@@QAEPAVSchedulerBase@23@XZ 0155 ?GetResourceMaskId@SchedulerBase@details@Concurrency@@QAEII@Z 0166 ?GetMaskIdCount@SchedulerBase@details@Concurrency@@QBEIXZ 0175 ?Grow@QuickBitSet@details@Concurrency@@QAEXI@Z 0183 ?Wipe@QuickBitSet@details@Concurrency@@QAEXXZ 019b ?Set@QuickBitSet@details@Concurrency@@QAEXI@Z 01a3 ?GetSchedulingProtocol@SchedulerBase@details@Concurrency@@QAE?AW4SchedulingProtocolType@3@XZ 01b8 ?Reset@WorkSearchContext@details@Concurrency@@QAEXPAVVirtualProcessor@23@W4Algorithm@123@@Z 01fb ??0location@Concurrency@@QAE@W4_Type@01@IIPAX@Z 021d ??4location@Concurrency@@QAEAAV01@ABV01@@Z 022c ??1location@Concurrency@@QAE@XZ 023e ?ListenAffinity@SchedulerBase@details@Concurrency@@QAEXI@Z 026c ?TraceVirtualProcessorEvent@VirtualProcessor@details@Concurrency@@AAEXW4ConcRT_EventType@3@EKK@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 20 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 4D F0 8B 45 F0 C7 80 C8 00 00 00 00 00 00 00 C7 80 CC 00 00 00 00 00 00 00 8B 4D F0 C7 81 E0 00 00 00 01 00 00 00 8B 55 F0 C7 82 D4 00 00 00 01 00 00 00 8B 45 F0 C7 40 78 00 00 00 00 8B 4D F0 8B 55 08 89 51 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 4D F0 89 41 54 8B 55 F0 8B 45 0C 89 42 58 8B 4D F0 C6 81 AD 00 00 00 00 8B 55 F0 C6 82 AC 00 00 00 00 8B 45 F0 C7 40 08 00 00 00 00 8B 4D F0 C7 41 68 00 00 00 00 8B 55 F0 C7 42 6C 00 00 00 00 8B 45 F0 C7 40 70 00 00 00 00 8B 4D F0 C7 41 74 00 00 00 00 8B 55 F0 C7 42 7C 00 00 00 00 8B 45 F0 C7 80 B0 00 00 00 00 00 00 00 8B 4D F0 81 C1 C0 00 00 00 E8 ?? ?? ?? ?? 8B 4D F0 C7 41 5C 00 00 00 00 8B 55 F0 C6 42 61 00 8B 45 F0 C6 40 60 00 8B 4D F0 C6 41 62 01 8B 55 F0 8B 4A 50 E8 ?? ?? ?? ?? 89 45 EC 8B 45 0C 8B 10 8B 4D 0C 8B 42 10 FF D0 8B 4D F0 89 81 88 00 00 00 8B 55 0C 8B 02 8B 4D 0C 8B 50 04 FF D2 8B 4D F0 89 81 8C 00 00 00 8B 55 F0 8B 82 8C 00 00 00 50 8B 4D EC E8 ?? ?? ?? ?? 8B 4D F0 89 81 90 00 00 00 8B 4D EC E8 ?? ?? ?? ?? 50 8B 4D F0 81 C1 A4 00 00 00 E8 ?? ?? ?? ?? 8B 4D F0 81 C1 A4 00 00 00 E8 ?? ?? ?? ?? 8B 55 F0 8B 82 90 00 00 00 50 8B 4D F0 81 C1 A4 00 00 00 E8 ?? ?? ?? ?? 8B 4D EC E8 ?? ?? ?? ?? 85 C0 75 13 6A 01 8B 4D F0 51 8B 4D F0 83 C1 28 E8 ?? ?? ?? ?? EB 11 6A 02 8B 55 F0 52 8B 4D F0 83 C1 28 E8 ?? ?? ?? ?? 8B 45 F0 50 8B 4D F0 8B 51 50 8B 02 8B 4D F0 8B 51 50 8B 00 8B 0A 8B 50 04 FF D2 50 8B 45 F0 8B 88 8C 00 00 00 51 6A 03 8D 4D D4 E8 ?? ?? ?? ?? 89 45 E8 8B 55 E8 89 55 E4 C7 45 FC 00 00 00 00 8B 45 E4 50 8B 4D F0 81 C1 94 00 00 00 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF 8D 4D D4 E8 ?? ?? ?? ?? 8B 4D F0 8B 91 90 00 00 00 52 8B 4D EC E8 ?? ?? ?? ?? 8B 45 F0 8B 88 88 00 00 00 51 8B 55 F0 8B 42 50 8B 08 8B 55 F0 8B 42 50 8B 11 8B 08 8B 42 04 FF D0 50 6A 04 6A 01 8B 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_53_105_0 {
	meta:
		name = "?InitializeTicket@ClaimTicket@VirtualProcessor@details@Concurrency@@AAEXW4AvailabilityType@234@PAV234@@Z"
		size = 30
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 55 FC 8B 45 0C 89 42 04 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_53_106_0 {
	meta:
		name = "?InterlockedClear@QuickBitSet@details@Concurrency@@QAEXI@Z"
		size = 110
		refs = "0014 ??_C@_1CG@LFGKFKE@?$AAb?$AAi?$AAt?$AAN?$AAu?$AAm?$AAb?$AAe?$AAr?$AA?5?$AA?$DM?$AA?5?$AAm?$AA_?$AAs?$AAi?$AAz?$AAe?$AA?$AA@ 0019 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0025 ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 002c __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 4D 08 3B 08 72 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C8 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CC 33 C9 75 C8 8B 4D 08 83 E1 1F BA 01 00 00 00 D3 E2 F7 D2 8B 45 08 C1 E8 05 8B 4D FC 8B 49 04 8D 04 81 89 45 F8 8B 4D F8 F0 21 11 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_107_0 {
	meta:
		name = "?InterlockedClear@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z"
		size = 179
		refs = "0014 ??_C@_1CG@LFGKFKE@?$AAb?$AAi?$AAt?$AAN?$AAu?$AAm?$AAb?$AAe?$AAr?$AA?5?$AA?$DM?$AA?5?$AAm?$AA_?$AAs?$AAi?$AAz?$AAe?$AA?$AA@ 0019 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0025 ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 002c __CrtDbgReportW 005f ??_C@_1BC@OJLFMICF@?$AAv?$AAa?$AAl?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 009a ?SpinUntilSet@QuickBitSet@details@Concurrency@@QBEXI@Z 00a6 ?InterlockedClear@QuickBitSet@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 4D 08 3B 08 72 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 74 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CC 33 C9 75 C8 8B 55 FC 8B 42 08 8B 4D 08 8D 14 88 83 C8 FF F0 0F C1 02 48 89 45 F8 83 7D F8 00 7D 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 77 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 D0 33 C0 75 CC 83 7D F8 00 75 18 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B 55 08 52 8B 4D FC E8 ?? ?? ?? ?? 8B 45 F8 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_108_0 {
	meta:
		name = "?InterlockedSet@QuickBitSet@details@Concurrency@@QAEXI@Z"
		size = 108
		refs = "0014 ??_C@_1CG@LFGKFKE@?$AAb?$AAi?$AAt?$AAN?$AAu?$AAm?$AAb?$AAe?$AAr?$AA?5?$AA?$DM?$AA?5?$AAm?$AA_?$AAs?$AAi?$AAz?$AAe?$AA?$AA@ 0019 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0025 ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 002c __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 4D 08 3B 08 72 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 AF 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CC 33 C9 75 C8 8B 4D 08 83 E1 1F BA 01 00 00 00 D3 E2 8B 45 08 C1 E8 05 8B 4D FC 8B 49 04 8D 04 81 89 45 F8 8B 4D F8 F0 09 11 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_109_0 {
	meta:
		name = "?InterlockedSet@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z"
		size = 181
		refs = "0014 ??_C@_1CG@LFGKFKE@?$AAb?$AAi?$AAt?$AAN?$AAu?$AAm?$AAb?$AAe?$AAr?$AA?5?$AA?$DM?$AA?5?$AAm?$AA_?$AAs?$AAi?$AAz?$AAe?$AA?$AA@ 0019 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0025 ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 002c __CrtDbgReportW 0061 ??_C@_1BA@ILKEJOIJ@?$AAv?$AAa?$AAl?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 009c ?SpinUntilClear@QuickBitSet@details@Concurrency@@QBEXI@Z 00a8 ?InterlockedSet@QuickBitSet@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 4D 08 3B 08 72 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 65 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CC 33 C9 75 C8 8B 55 FC 8B 42 08 8B 4D 08 8D 14 88 B8 01 00 00 00 F0 0F C1 02 40 89 45 F8 83 7D F8 00 7F 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 68 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 D0 33 C0 75 CC 83 7D F8 01 75 18 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B 55 08 52 8B 4D FC E8 ?? ?? ?? ?? 8B 45 F8 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_110_0 {
	meta:
		name = "?IsPrepared@InternalContextBase@details@Concurrency@@QBE_NXZ"
		size = 41
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 83 78 1C 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_112_0 {
	meta:
		name = "?ListenAffinity@SchedulerBase@details@Concurrency@@QAEXI@Z"
		size = 40
		refs = "0012 ?InterlockedSet@ReferenceCountedQuickBitSet@details@Concurrency@@QAEII@Z 001e ?ClearQuickCacheSlot@SchedulerBase@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC 83 C1 48 E8 ?? ?? ?? ?? 8B 4D 08 51 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_113_0 {
	meta:
		name = "?Lookup@?$Hash@II@details@Concurrency@@AAEPAUListNode@123@ABIH@Z"
		size = 128
		refs = "001a ??_C@_1EK@OHBLIOIL@?$AAh?$AAa?$AAs?$AAh?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAh?$AAa?$AAs?$AAh?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$DM?$AA?5?$AAm?$AA_@ 001f ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 002b ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0032 __CrtDbgReportW"
		altNames = "?Lookup@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@ABQAV_TaskCollection@23@H@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D F8 83 7D 0C 00 7C 0A 8B 45 F8 8B 4D 0C 3B 08 7C 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 8F 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 C6 33 C9 75 C2 8B 55 F8 8B 42 08 8B 4D 0C 8B 14 88 89 55 FC 83 7D FC 00 74 1C 8B 45 FC 8B 4D 08 8B 50 04 3B 11 75 05 8B 45 FC EB 0C 8B 45 FC 8B 08 89 4D FC EB DE 33 C0 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_53_114_0 {
	meta:
		name = "?MakeAvailable@VirtualProcessor@details@Concurrency@@IAEXW4AvailabilityType@123@_N@Z"
		size = 232
		refs = "0011 ??_C@_1FE@CGCEPKIE@?$AAm?$AA_?$AAa?$AAv?$AAa?$AAi?$AAl?$AAa?$AAb?$AAi?$AAl?$AAi?$AAt?$AAy?$AAT?$AAy?$AAp?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAA?$AAv?$AAa?$AAi?$AAl?$AAa?$AAb?$AAi?$AAl?$AAi@ 0016 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0022 ??_C@_1GK@KLIIPLJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0029 __CrtDbgReportW 0067 ?GetOwningNode@VirtualProcessor@details@Concurrency@@QAEPAVSchedulingNode@23@XZ 006e ?GetScheduler@SchedulingNode@details@Concurrency@@QAEPAVSchedulerBase@23@XZ 0075 ?VirtualProcessorActive@SchedulerBase@details@Concurrency@@QAE_N_N@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 83 78 08 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 D0 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 8B 4D FC 8B 51 7C 8B 45 FC 89 90 80 00 00 00 0F B6 4D 0C 85 C9 74 24 83 7D 08 01 74 06 83 7D 08 04 75 18 6A 00 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 55 FC 8B 42 50 8B 08 81 C1 B4 01 00 00 BA 01 00 00 00 F0 0F C1 11 8B 45 FC 8B 48 50 83 C1 1C BA 01 00 00 00 F0 0F C1 11 83 7D 08 04 74 06 83 7D 08 08 75 29 8B 45 FC 8B 48 50 8B 11 81 C2 B8 01 00 00 B8 01 00 00 00 F0 0F C1 02 8B 4D FC 8B 51 50 83 C2 20 B8 01 00 00 00 F0 0F C1 02 8B 4D 08 8B 55 FC 83 C2 08 87 0A 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_53_115_0 {
	meta:
		name = "?MarkForRetirement@VirtualProcessor@details@Concurrency@@AAEXXZ"
		size = 106
		refs = "000d ??0ClaimTicket@VirtualProcessor@details@Concurrency@@QAE@XZ 001d ?ClaimExclusiveOwnership@VirtualProcessor@details@Concurrency@@QAE_NAAVClaimTicket@123@K_N@Z 002c ?ExerciseWakesExisting@ClaimTicket@VirtualProcessor@details@Concurrency@@QBE_NXZ 0047 ?Exercise@ClaimTicket@VirtualProcessor@details@Concurrency@@QAE_NPAVScheduleGroupSegmentBase@34@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8D 4D F4 E8 ?? ?? ?? ?? 6A 01 6A 0F 8D 45 F4 50 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 34 8D 4D F4 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 16 8B 45 FC C6 80 AD 00 00 00 01 6A 00 8D 4D F4 E8 ?? ?? ?? ?? EB 0D 8B 4D FC 8B 11 8B 4D FC 8B 42 0C FF D0 EB 0A 8B 4D FC C6 81 AD 00 00 00 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_116_0 {
	meta:
		name = "?Oversubscribe@VirtualProcessor@details@Concurrency@@EAEPAV123@XZ"
		size = 130
		refs = "000d ?GetOwningNode@VirtualProcessor@details@Concurrency@@QAEPAVSchedulingNode@23@XZ 0014 ?GetScheduler@SchedulingNode@details@Concurrency@@QAEPAVSchedulerBase@23@XZ 001b ?GetSchedulerProxy@SchedulerBase@details@Concurrency@@QBEPAUISchedulerProxy@3@XZ 0040 ??_C@_1DC@MJDEOFNA@?$AAp?$AAO?$AAv?$AAe?$AAr?$AAs?$AAu?$AAb?$AAs?$AAc?$AAr?$AAi?$AAb?$AAe?$AAr?$AAR?$AAo?$AAo?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0045 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0051 ??_C@_1GK@KLIIPLJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0058 __CrtDbgReportW 007a ?AddVirtualProcessor@SchedulingNode@details@Concurrency@@QAEPAVVirtualProcessor@23@PAUIVirtualProcessorRoot@3@_N@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 89 45 F8 8B 45 FC 8B 48 58 51 8B 55 F8 8B 02 8B 4D F8 8B 50 14 FF D2 89 45 F4 83 7D F4 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 FC 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 D0 33 D2 75 CC 6A 01 8B 45 F4 50 8B 4D FC 8B 49 50 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_119_0 {
	meta:
		name = "?Remove@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE_NPAVVirtualProcessor@23@H_N@Z"
		size = 544
		refs = "00f1 __imp__QueryDepthSList@4 0111 ??_C@_1GC@LJFMHEGO@?$AAm?$AA_?$AAd?$AAe?$AAl?$AAe?$AAt?$AAi?$AAo?$AAn?$AAT?$AAh?$AAr?$AAe?$AAs?$AAh?$AAo?$AAl?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAD?$AAe?$AAl?$AAe?$AAt?$AAi?$AAo?$AAn?$AAT@ 0116 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0122 ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0129 __CrtDbgReportW 0151 __imp__InterlockedPushEntrySList@8 017e ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 01a8 ??_C@_1CI@OGGIBFFK@?$AAm?$AA_?$AAd?$AAe?$AAl?$AAe?$AAt?$AAi?$AAo?$AAn?$AAL?$AAi?$AAs?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 01de __imp__InterlockedFlushSList@4 01f4 ?CheckForDeletionBridge@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@CAXPAV123@@Z 01ff ?InvokeAtNextSafePoint@SafePointInvocation@details@Concurrency@@QAEXP6AXPAX@Z0PAVSchedulerBase@23@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 24 89 4D FC 8B 45 FC 8B 55 0C 8B 48 2C D3 FA 89 55 F4 8B 45 FC 8B 48 28 83 E9 01 23 4D 0C 89 4D E8 8B 55 FC 8B 45 F4 3B 42 3C 7C 07 32 C0 E9 E2 01 00 00 C7 45 F8 00 00 00 00 8B 4D FC 8B 55 F4 3B 51 38 7C 40 8B 45 FC 8B 48 38 8B 55 FC 8B 42 34 8B 4C 88 FC 89 4D F8 C7 45 F0 00 00 00 00 EB 09 8B 55 F0 83 C2 01 89 55 F0 8B 45 FC 8B 4D F4 2B 48 38 39 4D F0 7F 0B 8B 55 F8 8B 42 04 89 45 F8 EB DE EB 0F 8B 4D FC 8B 51 34 8B 45 F4 8B 0C 82 89 4D F8 8B 55 F8 8B 02 89 45 E4 8B 4D 08 89 4D EC 33 D2 8B 45 E8 8B 4D E4 8D 0C 81 8B 45 EC F0 0F B1 11 89 45 E0 8B 55 EC 39 55 E0 75 14 8B 4D E8 8B 55 F8 83 C2 08 B8 FE FF FF FF F0 0F B1 0A EB 07 32 C0 E9 3B 01 00 00 0F B6 45 10 85 C0 0F 84 2D 01 00 00 8B 4D FC 51 FF 15 ?? ?? ?? ?? 0F B7 D0 8B 45 FC 3B 50 44 0F 8E 01 01 00 00 8B 4D FC 81 79 44 FF FF FF 7F 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 1E 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CA 33 C9 75 C6 8B 55 08 81 C2 BC 00 00 00 52 8B 45 FC 83 C0 08 50 FF 15 ?? ?? ?? ?? 8B 4D FC 83 C1 08 51 FF 15 ?? ?? ?? ?? 0F B7 D0 89 55 DC 8B 45 FC 8B 4D DC 3B 48 44 0F 8E 8C 00 00 00 8B 55 FC 8B 4A 24 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 7A B9 01 00 00 00 8B 55 FC 83 C2 48 33 C0 F0 0F B1 0A 85 C0 75 65 8B 45 FC 83 78 10 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 2F 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 CD 33 C0 75 C9 8B 4D FC 83 C1 08 51 FF 15 ?? ?? ?? ?? 8B 55 FC 89 42 10 8B 45 FC 8B 48 24 51 8B 55 FC 52 68 ?? ?? ?? ?? 8B 4D FC 83 C1 14 E8 ?? ?? ?? ?? EB 13 8B 45 08 05 BC 00 00 00 50 8B 4D FC 51 FF 15 ?? ?? ?? ?? B0 01 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_53_120_0 {
	meta:
		name = "?Remove@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE_NPAVVirtualProcessor@23@_N@Z"
		size = 37
		refs = "001b ?Remove@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE_NPAVVirtualProcessor@23@H_N@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 0F B6 45 0C 50 8B 4D 08 8B 51 64 52 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_53_122_0 {
	meta:
		name = "?Retire@VirtualProcessor@details@Concurrency@@MAEXXZ"
		size = 644
		refs = "001b ?RemovePrioritizedObject@SchedulerBase@details@Concurrency@@QAEXPAUBoostedObject@23@@Z 0032 ?DecrementActiveResourcesByMask@SchedulerBase@details@Concurrency@@QAEXI@Z 0071 ?GetScheduler@SchedulingNode@details@Concurrency@@QAEPAVSchedulerBase@23@XZ 0078 ?SaveRetiredVirtualProcessorStatistics@SchedulerBase@details@Concurrency@@QAEXPAVVirtualProcessor@23@@Z 009f ?IgnoreAffinity@SchedulerBase@details@Concurrency@@QAEXI@Z 00a7 ?ClaimantWasInactive@VirtualProcessor@details@Concurrency@@QBE_NXZ 00e2 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 00ec ??_C@_1MO@DAELCFGC@?$AAC?$AAl?$AAa?$AAi?$AAm?$AAa?$AAn?$AAt?$AAW?$AAa?$AAs?$AAI?$AAn?$AAa?$AAc?$AAt?$AAi?$AAv?$AAe?$AA?$CI?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAT?$AAo?$AAI?$AAn?$AAt?$AAe?$AAr@ 00f1 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00fd ??_C@_1GK@KLIIPLJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0104 __CrtDbgReportW 0136 ?InFinalizationSweep@SchedulerBase@details@Concurrency@@QAE_NXZ 014f ?HasCompletedShutdown@SchedulerBase@details@Concurrency@@QAE_NXZ 015b ??_C@_1BBG@DBAOMFHF@?$AAC?$AAl?$AAa?$AAi?$AAm?$AAa?$AAn?$AAt?$AAW?$AAa?$AAs?$AAI?$AAn?$AAa?$AAc?$AAt?$AAi?$AAv?$AAe?$AA?$CI?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AA?$CB?$AAm?$AA_?$AAp?$AAO?$AAw@ 0196 ?GetLocalRunnableContext@VirtualProcessor@details@Concurrency@@AAEPAVInternalContextBase@23@XZ 01aa ?GetScheduleGroupSegment@ContextBase@details@Concurrency@@QBEPAVScheduleGroupSegmentBase@23@XZ 01b5 ?GetAffinity@ScheduleGroupSegmentBase@details@Concurrency@@IBEABVlocation@3@XZ 01c3 ??0location@Concurrency@@QAE@ABV01@@Z 01d2 ?AddRunnableContext@ScheduleGroupSegmentBase@details@Concurrency@@IAEXPAVInternalContextBase@23@Vlocation@3@@Z 0246 ?TraceVirtualProcessorEvent@VirtualProcessor@details@Concurrency@@AAEXW4ConcRT_EventType@3@EKK@Z 025b ?ReturnSubAllocator@SchedulerBase@details@Concurrency@@SAXPAVSubAllocator@23@@Z 027c ?Remove@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE_NPAVVirtualProcessor@23@_N@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 89 4D FC 8B 45 FC 05 D4 00 00 00 50 8B 4D FC 8B 51 50 8B 0A E8 ?? ?? ?? ?? 8B 45 FC 8B 88 90 00 00 00 51 8B 55 FC 8B 42 50 8B 08 E8 ?? ?? ?? ?? 8B 4D FC 8B 51 50 83 C2 24 83 C8 FF F0 0F C1 02 8B 4D FC 0F B6 91 AC 00 00 00 85 D2 75 12 8B 45 FC 8B 48 50 8B 11 83 C2 14 83 C8 FF F0 0F C1 02 8B 4D FC 51 8B 55 FC 8B 4A 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 FC 0F B6 48 60 85 C9 75 1C 8B 55 FC 8B 82 90 00 00 00 50 8B 4D FC 8B 49 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 5F 8B 45 FC 8B 48 7C 51 8B 55 FC 8B 02 8B 4D FC 8B 50 14 FF D2 89 45 F4 83 7D F4 00 74 0B 8B 45 F4 83 C0 04 89 45 F0 EB 07 C7 45 F0 00 00 00 00 E8 ?? ?? ?? ?? 39 45 F0 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 21 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 D2 75 8E 33 C0 75 8A 8B 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 58 8B 55 FC 8B 4A 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 19 8B 4D FC 8B 49 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 22 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C9 75 95 33 D2 75 91 8B 45 FC C7 40 7C 00 00 00 00 8B 4D FC E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 40 8B 4D F8 83 C1 04 E8 ?? ?? ?? ?? 89 45 EC 8B 4D EC E8 ?? ?? ?? ?? 83 EC 10 8B CC 89 65 E4 50 E8 ?? ?? ?? ?? 89 45 E0 8B 4D F8 51 8B 4D EC E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 89 45 F8 EB BA 8B 55 FC 8B 4A 50 E8 ?? ?? ?? ?? 89 45 E8 8B 45 E8 8B 10 8B 4D E8 8B 42 34 FF D0 50 8B 4D FC 8B 51 58 8B 45 FC 8B 12 8B 48 58 8B 42 08 FF D0 8B 4D FC C7 41 58 00 00 00 00 8B 55 FC 8B 82 88 00 00 00 50 8B 4D FC 8B 51 50 8B 02 8B 4D FC 8B 51 50 8B 00 8B 0A 8B 50 04 FF D2 50 6A 04 6A 02 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC 83 78 5C 00 74 19 8B 4D FC 8B 51 5C 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC C7 40 5C 00 00 00 00 6A 01 8B 4D FC 51 8B 55 FC 8B 4A 50 83 C1 38 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_123_0 {
	meta:
		name = "?SafePoint@VirtualProcessor@details@Concurrency@@QAE_NXZ"
		size = 42
		refs = "0014 ?GetOwningNode@VirtualProcessor@details@Concurrency@@QAEPAVSchedulingNode@23@XZ 001b ?GetScheduler@SchedulingNode@details@Concurrency@@QAEPAVSchedulerBase@23@XZ 0022 ?MarkSafePoint@SchedulerBase@details@Concurrency@@QAE_NPAVSafePointMarker@23@@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 05 C0 00 00 00 50 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_124_0 {
	meta:
		name = "?SaveRetiredVirtualProcessorStatistics@SchedulerBase@details@Concurrency@@QAEXPAVVirtualProcessor@23@@Z"
		size = 55
		refs = "000b ?GetEnqueuedTaskCount@VirtualProcessor@details@Concurrency@@AAEIXZ 0020 ?GetDequeuedTaskCount@VirtualProcessor@details@Concurrency@@AAEIXZ"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 4D 08 E8 ?? ?? ?? ?? 8B 4D FC 81 C1 BC 01 00 00 F0 0F C1 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 55 FC 81 C2 C0 01 00 00 F0 0F C1 02 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_125_0 {
	meta:
		name = "?Set@QuickBitSet@details@Concurrency@@QAEXI@Z"
		size = 114
		refs = "0013 ??_C@_1CG@LFGKFKE@?$AAb?$AAi?$AAt?$AAN?$AAu?$AAm?$AAb?$AAe?$AAr?$AA?5?$AA?$DM?$AA?5?$AAm?$AA_?$AAs?$AAi?$AAz?$AAe?$AA?$AA@ 0018 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0024 ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 002b __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 51 56 89 4D FC 8B 45 FC 8B 4D 08 3B 08 72 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 A1 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 75 CC 33 C9 75 C8 8B 55 08 C1 EA 05 8B 45 FC 8B 40 04 8B 4D 08 83 E1 1F BE 01 00 00 00 D3 E6 0B 34 90 8B 4D 08 C1 E9 05 8B 55 FC 8B 42 04 89 34 88 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_126_0 {
	meta:
		name = "?SetDebugBits@InternalContextBase@details@Concurrency@@QAEXK@Z"
		size = 34
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 FC 8B 88 CC 00 00 00 0B 4D 08 8B 55 FC 89 8A CC 00 00 00 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_127_0 {
	meta:
		name = "?SpinUntilClear@QuickBitSet@details@Concurrency@@QBEXI@Z"
		size = 92
		refs = "0036 ?_Sleep0@details@Concurrency@@YAXXZ 003e ??0?$_SpinWait@$00@details@Concurrency@@QAE@P6AXXZ@Z 0050 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 1C 89 4D F4 8B 45 08 C1 E8 05 8B 4D F4 8B 51 04 8D 04 82 89 45 FC 8B 4D 08 83 E1 1F BA 01 00 00 00 D3 E2 89 55 F8 8B 45 FC 8B 08 23 4D F8 74 21 68 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 8B 55 FC 8B 02 23 45 F8 74 0A 8D 4D E4 E8 ?? ?? ?? ?? EB EC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_128_0 {
	meta:
		name = "?SpinUntilSet@QuickBitSet@details@Concurrency@@QBEXI@Z"
		size = 92
		refs = "0036 ?_Sleep0@details@Concurrency@@YAXXZ 003e ??0?$_SpinWait@$00@details@Concurrency@@QAE@P6AXXZ@Z 0050 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 55 8B EC 83 EC 1C 89 4D F4 8B 45 08 C1 E8 05 8B 4D F4 8B 51 04 8D 04 82 89 45 FC 8B 4D 08 83 E1 1F BA 01 00 00 00 D3 E2 89 55 F8 8B 45 FC 8B 08 23 4D F8 75 21 68 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 8B 55 FC 8B 02 23 45 F8 75 0A 8D 4D E4 E8 ?? ?? ?? ?? EB EC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_129_0 {
	meta:
		name = "?StartupWorkerContext@VirtualProcessor@details@Concurrency@@EAE_NPAVScheduleGroupSegmentBase@23@PAVInternalContextBase@23@@Z"
		size = 199
		refs = "0013 ?_Sleep0@details@Concurrency@@YAXXZ 001b ??0?$_SpinWait@$00@details@Concurrency@@QAE@P6AXXZ@Z 002c ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ 003c ?IsPrepared@InternalContextBase@details@Concurrency@@QBE_NXZ 0053 ?PrepareForUse@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupSegmentBase@23@PAU_Chore@23@_N@Z 0061 ?GetInternalContext@ScheduleGroupSegmentBase@details@Concurrency@@IAEPAVInternalContextBase@23@PAU_Chore@23@_N@Z 0076 ?MakeAvailable@VirtualProcessor@details@Concurrency@@IAEXW4AvailabilityType@123@_N@Z 007e ?GetOwningNode@VirtualProcessor@details@Concurrency@@QAEPAVSchedulingNode@23@XZ 0085 ?GetScheduler@SchedulingNode@details@Concurrency@@QAEPAVSchedulerBase@23@XZ 008c ?DeferredGetInternalContext@SchedulerBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 14 89 4D FC 8B 45 FC 83 78 7C 00 74 20 68 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 8B 4D FC 83 79 7C 00 74 0A 8D 4D EC E8 ?? ?? ?? ?? EB ED 83 7D 0C 00 74 21 8B 4D 0C E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 10 6A 00 6A 00 8B 45 08 50 8B 4D 0C E8 ?? ?? ?? ?? EB 0F 6A 00 6A 00 8B 4D 08 E8 ?? ?? ?? ?? 89 45 0C 83 7D 0C 00 75 26 6A 01 6A 04 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 32 C0 EB 2D 8B 4D 0C 51 8B 55 FC 8B 02 8B 4D FC 8B 50 10 FF D2 8B 45 FC 8B 48 7C 51 8B 55 FC 8B 42 58 8B 4D FC 8B 10 8B 49 58 8B 42 14 FF D0 B0 01 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_53_131_0 {
	meta:
		name = "?ThrowVirtualProcessorEvent@VirtualProcessor@details@Concurrency@@CAXW4ConcRT_EventType@3@EKK@Z"
		size = 144
		refs = "0008 ?g_pEtw@details@Concurrency@@3PAVEtw@12@A 001e _memset 0043 _VirtualProcessorEventGuid 0075 ?g_ConcRTSessionHandle@details@Concurrency@@3_KA 0088 ?Trace@Etw@details@Concurrency@@QAEK_KPAU_EVENT_TRACE_HEADER@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 40 83 3D ?? ?? ?? ?? 00 74 7D 33 C0 66 89 45 C0 6A 3E 6A 00 8D 4D C2 51 E8 ?? ?? ?? ?? 83 C4 0C BA 40 00 00 00 66 89 55 C0 C7 45 EC 00 00 02 00 8A 45 08 88 45 C4 8A 4D 0C 88 4D C5 8B 15 ?? ?? ?? ?? 89 55 D8 A1 ?? ?? ?? ?? 89 45 DC 8B 0D ?? ?? ?? ?? 89 4D E0 8B 15 ?? ?? ?? ?? 89 55 E4 8B 45 10 89 45 F4 8B 4D 14 89 4D F0 8D 55 C0 52 A1 ?? ?? ?? ?? 50 8B 0D ?? ?? ?? ?? 51 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_53_132_0 {
	meta:
		name = "?ToInternalContext@VirtualProcessor@details@Concurrency@@MAEPAVInternalContextBase@23@PAUIExecutionContext@3@@Z"
		size = 16
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_53_133_0 {
	meta:
		name = "?TraceVirtualProcessorEvent@VirtualProcessor@details@Concurrency@@AAEXW4ConcRT_EventType@3@EKK@Z"
		size = 62
		refs = "000f ?g_TraceInfo@details@Concurrency@@3U_CONCRT_TRACE_INFO@12@A 0014 ?_IsEnabled@_CONCRT_TRACE_INFO@details@Concurrency@@QBE_NEK@Z 0031 ?ThrowVirtualProcessorEvent@VirtualProcessor@details@Concurrency@@CAXW4ConcRT_EventType@3@EKK@Z"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 6A 04 0F B6 45 0C 50 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 19 8B 55 14 52 8B 45 10 50 0F B6 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_53_134_0 {
	meta:
		name = "?UpdateWorkState@VirtualProcessor@details@Concurrency@@QAEX_N0@Z"
		size = 119
		refs = "0010 ?GetScheduler@SchedulingNode@details@Concurrency@@QAEPAVSchedulerBase@23@XZ 003f ?ListenAffinity@SchedulerBase@details@Concurrency@@QAEXI@Z 005b ?IgnoreAffinity@SchedulerBase@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 48 50 E8 ?? ?? ?? ?? 89 45 F8 8B 4D FC 0F B6 51 60 85 D2 74 23 0F B6 45 08 85 C0 75 19 8B 4D FC C6 41 62 01 8B 55 FC 8B 82 90 00 00 00 50 8B 4D F8 E8 ?? ?? ?? ?? EB 1A 0F B6 4D 08 85 C9 74 12 8B 55 FC 8B 82 90 00 00 00 50 8B 4D F8 E8 ?? ?? ?? ?? 8B 4D FC 8A 55 08 88 51 60 8B 45 FC 8A 4D 0C 88 48 61 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_53_135_0 {
	meta:
		name = "?Wipe@QuickBitSet@details@Concurrency@@QAEXXZ"
		size = 68
		refs = "000d ?ASIZE@QuickBitSet@details@Concurrency@@IBEIXZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 89 4D F8 8B 4D F8 E8 ?? ?? ?? ?? 89 45 F4 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 3B 4D F4 73 12 8B 55 F8 8B 42 04 8B 4D FC C7 04 88 00 00 00 00 EB DD 8B E5 5D C3 }
	condition:
		$1
}

rule file_54_3_0 {
	meta:
		name = "?_W_expandtime@@YAHPAUlocaleinfo_struct@@_WPBUtm@@PAPA_WPAIPAU__lc_time_data@@I@Z"
		size = 4351
		refs = "002a $LN128 0031 $LN129 006d ??_C@_1HE@BFLEOKFO@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAw?$AAd?$AAa?$AAy?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5@ 0072 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 007e ??_C@_1FC@MHEEEHDG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAt?$AAi?$AAm?$AAe?$AA?2?$AAw?$AAc@ 0085 __CrtDbgReportW 0099 __errno 00b0 ??_C@_1BM@ONGGIHAI@?$AA_?$AAW?$AA_?$AAe?$AAx?$AAp?$AAa?$AAn?$AAd?$AAt?$AAi?$AAm?$AAe?$AA?$AA@ 00ba __invalid_parameter 00e2 ?_W_store_str@@YAXPA_WPAPA_WPAI@Z 01d6 ??_C@_1HC@OOAMILFB@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAm?$AAo?$AAn?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAt@ 0328 ?_W_store_winword@@YAHPAUlocaleinfo_struct@@HPBUtm@@PAPA_WPAIPAU__lc_time_data@@@Z 0463 ??_C@_1HG@NFHHOAD@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAm?$AAd?$AAa?$AAy?$AA?5?$AA?$DO?$AA?$DN?$AA1?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5@ 04d4 ?_W_store_num@@YAXHHPAPA_WPAII@Z 050f ??_C@_1HG@KCGGFLNI@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAh?$AAo?$AAu?$AAr?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5@ 068e ??_C@_1HI@HHCJCPE@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAy?$AAd?$AAa?$AAy?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5@ 07f5 ??_C@_1HC@IGKDPPHL@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAm?$AAi?$AAn?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAt@ 097f ??_C@_1HC@HLKHIKOB@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAs?$AAe?$AAc?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAt@ 0d92 ??_C@_1DC@NMCFBMJP@?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAy?$AAe?$AAa?$AAr?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?$AA@ 0e64 ??_C@_1HM@LBNGKIAD@?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAy?$AAe?$AAa?$AAr?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA?9?$AA1?$AA9?$AA0?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG@ 0f09 ___tzset 0f45 ??_C@_1MM@JAKLBNNP@?$AA_?$AAm?$AAb?$AAs?$AAt?$AAo?$AAw?$AAc?$AAs?$AA_?$AAs?$AA_?$AAl?$AA?$CI?$AA?$CG?$AAw?$AAn?$AAu?$AAm?$AA?0?$AA?5?$AA?$CK?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?0?$AA?5?$AA?$CK?$AAl@ 0f54 ___tzname 0f73 __mbstowcs_s_l 0f7c __invoke_watson_if_oneof 0ff2 ??_C@_1EG@JNJKHKFI@?$AA?$CI?$AA?5?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAd?$AAi?$AAr?$AAe?$AAc?$AAt?$AAi?$AAv?$AAe?$AA?$CC?$AA?5?$AA?0?$AA?5?$AA0@ 1028 $LN2 102c $LN3 1030 $LN64 1034 $LN60 1038 $LN47 103c $LN45 1040 $LN38 1044 $LN32 1048 $LN30 104c $LN25 1050 $LN12 1054 $LN8 1058 $LN6 105c $LN66 1060 $LN62 1064 $LN58 1068 $LN49 106c $LN42 1070 $LN40 1074 $LN36 1078 $LN27 107c $LN17 1080 $LN10 1084 $LN1"
	strings:
		$1 = { 55 8B EC 81 EC A8 00 00 00 56 0F B7 45 0C 89 45 F8 8B 4D F8 83 E9 04 89 4D F8 83 7D F8 76 0F 87 C9 0F 00 00 8B 55 F8 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D 10 83 79 18 00 7C 15 8B 55 10 83 7A 18 06 7F 0C C7 85 6C FF FF FF 01 00 00 00 EB 0A C7 85 6C FF FF FF 00 00 00 00 8B 85 6C FF FF FF 89 45 E4 83 7D E4 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 D0 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 D0 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 58 0F 00 00 8B 55 18 52 8B 45 14 50 8B 4D 10 8B 51 18 8B 45 1C 8B 8C 90 B4 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 0C E9 2D 0F 00 00 8B 55 10 83 7A 18 00 7C 12 8B 45 10 83 78 18 06 7F 09 C7 45 9C 01 00 00 00 EB 07 C7 45 9C 00 00 00 00 8B 4D 9C 89 4D DC 83 7D DC 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 D9 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 D9 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 A8 0E 00 00 8B 45 18 50 8B 4D 14 51 8B 55 10 8B 42 18 8B 4D 1C 8B 94 81 D0 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 0C E9 7D 0E 00 00 8B 45 10 83 78 10 00 7C 15 8B 4D 10 83 79 10 0B 7F 0C C7 85 5C FF FF FF 01 00 00 00 EB 0A C7 85 5C FF FF FF 00 00 00 00 8B 95 5C FF FF FF 89 55 D4 83 7D D4 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 E1 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 E1 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 EF 0D 00 00 8B 4D 18 51 8B 55 14 52 8B 45 10 8B 48 10 8B 55 1C 8B 84 8A EC 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 0C E9 C4 0D 00 00 8B 4D 10 83 79 10 00 7C 12 8B 55 10 83 7A 10 0B 7F 09 C7 45 94 01 00 00 00 EB 07 C7 45 94 00 00 00 00 8B 45 94 89 45 CC 83 7D CC 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 E9 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D CC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 E9 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 3F 0D 00 00 8B 55 18 52 8B 45 14 50 8B 4D 10 8B 51 10 8B 45 1C 8B 8C 90 1C 01 00 00 51 E8 ?? ?? ?? ?? 83 C4 0C E9 14 0D 00 00 83 7D 20 00 0F 84 8D 00 00 00 8B 55 1C 52 8B 45 18 50 8B 4D 14 51 8B 55 10 52 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 33 C0 E9 E6 0C 00 00 8B 4D 18 83 39 00 75 07 33 C0 E9 D7 0C 00 00 8B 55 14 8B 02 B9 20 00 00 00 66 89 08 8B 55 14 8B 02 83 C0 02 8B 4D 14 89 01 8B 55 18 8B 02 83 E8 01 8B 4D 18 89 01 8B 55 1C 52 8B 45 18 50 8B 4D 14 51 8B 55 10 52 6A 02 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 33 C0 E9 87 0C 00 00 E9 88 00 00 00 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 33 C0 E9 59 0C 00 00 8B 45 18 83 38 00 75 07 33 C0 E9 4A 0C 00 00 8B 4D 14 8B 11 B8 20 00 00 00 66 89 02 8B 4D 14 8B 11 83 C2 02 8B 45 14 89 10 8B 4D 18 8B 11 83 EA 01 8B 45 18 89 10 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 6A 02 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 33 C0 E9 FA 0B 00 00 E9 F0 0B 00 00 8B 45 10 83 78 0C 01 7C 15 8B 4D 10 83 79 0C 1F 7F 0C C7 85 74 FF FF FF 01 00 00 00 EB 0A C7 85 74 FF FF FF 00 00 00 00 8B 95 74 FF FF FF 89 55 C4 83 7D C4 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 28 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D C4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 28 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 62 0B 00 00 8B 4D 20 51 8B 55 18 52 8B 45 14 50 6A 02 8B 4D 10 8B 51 0C 52 E8 ?? ?? ?? ?? 83 C4 14 E9 3B 0B 00 00 8B 45 10 83 78 08 00 7C 12 8B 4D 10 83 79 08 17 7F 09 C7 45 8C 01 00 00 00 EB 07 C7 45 8C 00 00 00 00 8B 55 8C 89 55 BC 83 7D BC 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 31 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D BC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 31 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 B6 0A 00 00 8B 4D 20 51 8B 55 18 52 8B 45 14 50 6A 02 8B 4D 10 8B 51 08 52 E8 ?? ?? ?? ?? 83 C4 14 E9 8F 0A 00 00 8B 45 10 83 78 08 00 7C 15 8B 4D 10 83 79 08 17 7F 0C C7 85 64 FF FF FF 01 00 00 00 EB 0A C7 85 64 FF FF FF 00 00 00 00 8B 95 64 FF FF FF 89 55 B4 83 7D B4 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 39 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D B4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 39 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 01 0A 00 00 8B 4D 10 8B 41 08 99 B9 0C 00 00 00 F7 F9 89 55 FC 83 7D FC 00 75 07 C7 45 FC 0C 00 00 00 8B 55 20 52 8B 45 18 50 8B 4D 14 51 6A 02 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 14 E9 BF 09 00 00 8B 45 10 83 78 1C 00 7C 15 8B 4D 10 81 79 1C 6D 01 00 00 7F 09 C7 45 84 01 00 00 00 EB 07 C7 45 84 00 00 00 00 8B 55 84 89 55 AC 83 7D AC 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 44 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D AC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 44 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 37 09 00 00 8B 4D 20 51 8B 55 18 52 8B 45 14 50 6A 03 8B 4D 10 8B 51 1C 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 14 E9 0D 09 00 00 8B 45 10 83 78 10 00 7C 12 8B 4D 10 83 79 10 0B 7F 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 55 EC 89 55 A4 83 7D A4 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 4D 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D A4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 4D 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 88 08 00 00 8B 4D 20 51 8B 55 18 52 8B 45 14 50 6A 02 8B 4D 10 8B 51 10 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 14 E9 5E 08 00 00 8B 45 10 83 78 04 00 7C 15 8B 4D 10 83 79 04 3B 7F 0C C7 85 7C FF FF FF 01 00 00 00 EB 0A C7 85 7C FF FF FF 00 00 00 00 8B 95 7C FF FF FF 89 55 E8 83 7D E8 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 56 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 56 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 D0 07 00 00 8B 4D 20 51 8B 55 18 52 8B 45 14 50 6A 02 8B 4D 10 8B 51 04 52 E8 ?? ?? ?? ?? 83 C4 14 E9 A9 07 00 00 8B 45 10 83 78 08 00 7C 12 8B 4D 10 83 79 08 17 7F 09 C7 45 E0 01 00 00 00 EB 07 C7 45 E0 00 00 00 00 8B 55 E0 89 55 D8 83 7D D8 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 5E 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 5E 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 24 07 00 00 8B 4D 10 83 79 08 0B 7F 25 8B 55 18 52 8B 45 14 50 B9 04 00 00 00 6B D1 00 8B 45 1C 8B 8C 10 4C 01 00 00 51 E8 ?? ?? ?? ?? 83 C4 0C EB 23 8B 55 18 52 8B 45 14 50 B9 04 00 00 00 C1 E1 00 8B 55 1C 8B 84 0A 4C 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 0C E9 C9 06 00 00 8B 4D 10 83 39 00 7C 11 8B 55 10 83 3A 3B 7F 09 C7 45 D0 01 00 00 00 EB 07 C7 45 D0 00 00 00 00 8B 45 D0 89 45 C8 83 7D C8 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 69 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D C8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 69 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 46 06 00 00 8B 55 20 52 8B 45 18 50 8B 4D 14 51 6A 02 8B 55 10 8B 02 50 E8 ?? ?? ?? ?? 83 C4 14 E9 20 06 00 00 8B 4D 10 83 79 18 00 7C 12 8B 55 10 83 7A 18 06 7F 09 C7 45 C0 01 00 00 00 EB 07 C7 45 C0 00 00 00 00 8B 45 C0 89 45 B8 83 7D B8 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 70 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D B8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 70 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 9B 05 00 00 8B 55 10 8B 42 18 89 45 F4 E9 59 01 00 00 E9 54 01 00 00 8B 4D 10 83 79 18 00 7C 12 8B 55 10 83 7A 18 06 7F 09 C7 45 B0 01 00 00 00 EB 07 C7 45 B0 00 00 00 00 8B 45 B0 89 45 A8 83 7D A8 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 77 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D A8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 77 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 FE 04 00 00 8B 55 20 52 8B 45 18 50 8B 4D 14 51 6A 01 8B 55 10 8B 42 18 50 E8 ?? ?? ?? ?? 83 C4 14 E9 D7 04 00 00 8B 4D 10 83 79 18 00 7C 12 8B 55 10 83 7A 18 06 7F 09 C7 45 A0 01 00 00 00 EB 07 C7 45 A0 00 00 00 00 8B 45 A0 89 45 98 83 7D 98 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 7E 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D 98 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 7E 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 52 04 00 00 8B 55 10 83 7A 18 00 75 09 C7 45 F4 06 00 00 00 EB 0C 8B 45 10 8B 48 18 83 E9 01 89 4D F4 8B 55 10 83 7A 1C 00 7C 15 8B 45 10 81 78 1C 6D 01 00 00 7F 09 C7 45 90 01 00 00 00 EB 07 C7 45 90 00 00 00 00 8B 4D 90 89 4D 88 83 7D 88 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 84 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D 88 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 84 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 A7 03 00 00 8B 45 10 8B 48 1C 3B 4D F4 7D 09 C7 45 FC 00 00 00 00 EB 2D 8B 55 10 8B 42 1C 99 B9 07 00 00 00 F7 F9 89 45 FC 8B 55 10 8B 42 1C 99 B9 07 00 00 00 F7 F9 3B 55 F4 7C 09 8B 55 FC 83 C2 01 89 55 FC 8B 45 20 50 8B 4D 18 51 8B 55 14 52 6A 02 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 14 E9 42 03 00 00 83 7D 20 00 74 2B 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 6A 01 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 33 C0 E9 18 03 00 00 EB 29 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 33 C0 E9 ED 02 00 00 E9 E3 02 00 00 8B 55 1C 52 8B 45 18 50 8B 4D 14 51 8B 55 10 52 6A 02 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 33 C0 E9 BF 02 00 00 E9 B5 02 00 00 8B 4D 10 83 79 14 00 7C 09 C7 45 80 01 00 00 00 EB 07 C7 45 80 00 00 00 00 8B 55 80 89 95 78 FF FF FF 83 BD 78 FF FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 B9 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 78 FF FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 B9 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 30 02 00 00 8B 4D 10 8B 41 14 99 B9 64 00 00 00 F7 F9 89 55 FC 8B 55 20 52 8B 45 18 50 8B 4D 14 51 6A 02 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 14 E9 FB 01 00 00 8B 45 10 81 78 14 94 F8 FF FF 7C 18 8B 4D 10 81 79 14 A3 1F 00 00 7F 0C C7 85 70 FF FF FF 01 00 00 00 EB 0A C7 85 70 FF FF FF 00 00 00 00 8B 95 70 FF FF FF 89 95 68 FF FF FF 83 BD 68 FF FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 C2 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 68 FF FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 C2 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 5E 01 00 00 8B 4D 10 8B 41 14 99 B9 64 00 00 00 F7 F9 83 C0 13 6B C8 64 8B 55 10 8B 42 14 99 BE 64 00 00 00 F7 FE 03 CA 89 4D FC 8B 45 20 50 8B 4D 18 51 8B 55 14 52 6A 04 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 14 E9 13 01 00 00 E8 ?? ?? ?? ?? C7 45 F0 00 00 00 00 8B 4D 10 83 79 20 00 74 0C C7 85 60 FF FF FF 01 00 00 00 EB 0A C7 85 60 FF FF FF 00 00 00 00 6A 00 68 D2 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 8B 55 08 52 6A FF E8 ?? ?? ?? ?? 8B 8D 60 FF FF FF 8B 14 88 52 8B 45 18 8B 08 51 8B 55 14 8B 02 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 18 50 E8 ?? ?? ?? ?? 83 C4 20 89 85 58 FF FF FF 83 BD 58 FF FF FF 50 75 0B 8B 55 18 C7 02 00 00 00 00 EB 12 8B 45 F0 83 E8 01 8B 4D 18 8B 11 2B D0 8B 45 18 89 10 8B 4D 14 8B 11 8B 45 F0 8D 4C 42 FE 8B 55 14 89 0A EB 59 8B 45 14 8B 08 BA 25 00 00 00 66 89 11 8B 45 14 8B 08 83 C1 02 8B 55 14 89 0A 8B 45 18 8B 08 83 E9 01 8B 55 18 89 0A EB 30 EB 2E 33 C0 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 ED 02 }
	condition:
		$1
}

rule file_54_4_0 {
	meta:
		name = "?_W_store_num@@YAXHHPAPA_WPAII@Z"
		size = 175
		refs = "001e ?_W_store_number@@YAXHPAPA_WPAI@Z"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 18 00 74 19 8B 45 14 50 8B 4D 10 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C E9 81 00 00 00 8B 45 14 8B 4D 0C 3B 08 73 6E 8B 55 0C 83 EA 01 89 55 0C EB 09 8B 45 0C 83 E8 01 89 45 0C 8B 4D 0C 83 C1 01 74 33 8B 45 08 99 B9 0A 00 00 00 F7 F9 83 C2 30 8B 45 10 8B 08 8B 45 0C 66 89 14 41 8B 45 08 99 B9 0A 00 00 00 F7 F9 89 45 08 8B 55 FC 83 C2 01 89 55 FC EB BC 8B 45 10 8B 08 8B 55 FC 8D 04 51 8B 4D 10 89 01 8B 55 14 8B 02 2B 45 FC 8B 4D 14 89 01 EB 09 8B 55 14 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_54_5_0 {
	meta:
		name = "?_W_store_number@@YAXHPAPA_WPAI@Z"
		size = 179
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 45 0C 8B 08 89 4D F8 8B 55 10 83 3A 01 76 46 8B 45 08 99 B9 0A 00 00 00 F7 F9 83 C2 30 8B 45 F8 66 89 10 8B 4D F8 83 C1 02 89 4D F8 8B 55 10 8B 02 83 E8 01 8B 4D 10 89 01 8B 45 08 99 B9 0A 00 00 00 F7 F9 89 45 08 83 7D 08 00 7E 08 8B 55 10 83 3A 01 77 BA 8B 45 0C 8B 08 89 4D F4 8B 55 0C 8B 45 F8 89 02 8B 4D F8 83 E9 02 89 4D F8 8B 55 F8 66 8B 02 66 89 45 FC 8B 4D F8 8B 55 F4 66 8B 02 66 89 01 8B 4D F8 83 E9 02 89 4D F8 8B 55 F4 66 8B 45 FC 66 89 02 8B 4D F4 83 C1 02 89 4D F4 8B 55 F4 3B 55 F8 72 C6 8B E5 5D C3 }
	condition:
		$1
}

rule file_54_6_0 {
	meta:
		name = "?_W_store_str@@YAXPA_WPAPA_WPAI@Z"
		size = 74
	strings:
		$1 = { 55 8B EC 8B 45 10 83 38 00 74 3D 8B 4D 08 0F B7 11 85 D2 74 33 8B 45 0C 8B 08 8B 55 08 66 8B 02 66 89 01 8B 4D 0C 8B 11 83 C2 02 8B 45 0C 89 10 8B 4D 08 83 C1 02 89 4D 08 8B 55 10 8B 02 83 E8 01 8B 4D 10 89 01 EB BB 5D C3 }
	condition:
		$1
}

rule file_54_7_0 {
	meta:
		name = "?_W_store_winword@@YAHPAUlocaleinfo_struct@@HPBUtm@@PAPA_WPAIPAU__lc_time_data@@@Z"
		size = 1752
		refs = "0007 ___security_cookie 00dc ___crtGetTimeFormatEx 0101 ___crtGetDateFormatEx 011c __MallocaIsSizeInRange 0135 _malloc 013e __MarkAllocaS 020c __freea 02ac $LN89 02b3 $LN90 02d2 $LN91 031c $LN92 041d ??_C@_1M@PBPMMENC@?$AAa?$AAm?$AA?1?$AAp?$AAm?$AA?$AA@ 0426 __wcsicmp 043d ??_C@_17BLFJJHMM@?$AAa?$AA?1?$AAp?$AA?$AA@ 05d6 ?_W_expandtime@@YAHPAUlocaleinfo_struct@@_WPBUtm@@PAPA_WPAIPAU__lc_time_data@@I@Z 062e @__security_check_cookie@4 0638 $LN10 063c $LN21 0640 $LN36 0644 $LN60 0648 $LN53 064c $LN41 0650 $LN31 0654 $LN26 0658 $LN17 065c $LN46 0660 $LN61 06b8 $LN57 06bc $LN56 06c0 $LN55 06c4 $LN54 06c8 $LN50 06cc $LN49 06d0 $LN48 06d4 $LN47"
	strings:
		$1 = { 55 8B EC 83 EC 68 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 89 45 AC 83 7D AC 00 74 08 83 7D AC 01 74 10 EB 1C 8B 4D 1C 8B 91 54 01 00 00 89 55 E4 EB 1A 8B 45 1C 8B 88 58 01 00 00 89 4D E4 EB 0C 8B 55 1C 8B 82 5C 01 00 00 89 45 E4 8B 4D 1C 83 B9 AC 00 00 00 01 0F 84 C1 01 00 00 C7 45 BC 01 00 00 00 83 7D 0C 02 74 07 C7 45 BC 00 00 00 00 8B 55 10 8B 42 14 05 6C 07 00 00 66 89 45 EC 8B 4D 10 8B 51 10 83 C2 01 66 89 55 EE 8B 45 10 66 8B 48 0C 66 89 4D F2 8B 55 10 66 8B 42 08 66 89 45 F4 8B 4D 10 66 8B 51 04 66 89 55 F6 8B 45 10 66 8B 08 66 89 4D F8 33 D2 66 89 55 FA 83 7D BC 00 74 25 6A 00 6A 00 8B 45 E4 50 8D 4D EC 51 6A 00 8B 55 1C 8B 82 60 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 D8 EB 23 6A 00 6A 00 8B 4D E4 51 8D 55 EC 52 6A 00 8B 45 1C 8B 88 60 01 00 00 51 E8 ?? ?? ?? ?? 83 C4 18 89 45 D8 83 7D D8 00 0F 84 08 01 00 00 8B 55 D8 D1 E2 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 23 68 DD DD 00 00 8B 45 D8 8D 4C 00 08 51 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 A4 EB 07 C7 45 A4 00 00 00 00 8B 55 A4 89 55 CC 83 7D CC 00 0F 84 BC 00 00 00 83 7D BC 00 74 29 8B 45 D8 50 8B 4D CC 51 8B 55 E4 52 8D 45 EC 50 6A 00 8B 4D 1C 8B 91 60 01 00 00 52 E8 ?? ?? ?? ?? 83 C4 18 89 45 D8 EB 27 8B 45 D8 50 8B 4D CC 51 8B 55 E4 52 8D 45 EC 50 6A 00 8B 4D 1C 8B 91 60 01 00 00 52 E8 ?? ?? ?? ?? 83 C4 18 89 45 D8 8B 45 CC 89 45 DC 8B 4D D8 83 E9 01 89 4D D8 83 7D D8 00 7E 3B 8B 55 18 83 3A 00 76 33 8B 45 14 8B 08 8B 55 DC 66 8B 02 66 89 01 8B 4D 14 8B 11 83 C2 02 8B 45 14 89 10 8B 4D DC 83 C1 02 89 4D DC 8B 55 18 8B 02 83 E8 01 8B 4D 18 89 01 EB B6 8B 55 CC 52 E8 ?? ?? ?? ?? 83 C4 04 B8 01 00 00 00 E9 0B 04 00 00 8B 45 E4 0F B7 08 85 C9 0F 84 F8 03 00 00 8B 55 18 83 3A 00 0F 84 EC 03 00 00 33 C0 66 89 45 E8 C7 45 D0 00 00 00 00 C7 45 E0 00 00 00 00 8B 4D E4 89 4D DC EB 09 8B 55 E0 83 C2 01 89 55 E0 8B 45 DC 0F B7 08 89 4D 9C 8B 55 E4 0F B7 02 89 45 98 8B 4D DC 83 C1 02 89 4D DC 8B 55 9C 3B 55 98 75 02 EB D2 8B 45 DC 83 E8 02 89 45 DC 8B 4D E4 0F B7 11 89 55 C4 8B 45 C4 83 E8 27 89 45 C4 83 7D C4 52 0F 87 0A 03 00 00 8B 4D C4 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 E0 89 45 C0 8B 4D C0 83 E9 01 89 4D C0 83 7D C0 03 77 30 8B 55 C0 FF 24 95 ?? ?? ?? ?? C7 45 D0 01 00 00 00 B8 6D 00 00 00 66 89 45 E8 EB 14 B9 62 00 00 00 66 89 4D E8 EB 09 BA 42 00 00 00 66 89 55 E8 E9 AF 02 00 00 8B 45 E0 89 45 C8 8B 4D C8 83 E9 01 89 4D C8 83 7D C8 03 77 30 8B 55 C8 FF 24 95 ?? ?? ?? ?? C7 45 D0 01 00 00 00 B8 64 00 00 00 66 89 45 E8 EB 14 B9 61 00 00 00 66 89 4D E8 EB 09 BA 41 00 00 00 66 89 55 E8 E9 65 02 00 00 8B 45 E0 89 45 A0 83 7D A0 02 74 08 83 7D A0 04 74 0D EB 14 B9 79 00 00 00 66 89 4D E8 EB 09 BA 59 00 00 00 66 89 55 E8 E9 38 02 00 00 8B 45 E0 89 45 B8 83 7D B8 01 74 08 83 7D B8 02 74 09 EB 10 C7 45 D0 01 00 00 00 B9 49 00 00 00 66 89 4D E8 E9 0F 02 00 00 8B 55 E0 89 55 A8 83 7D A8 01 74 08 83 7D A8 02 74 09 EB 10 C7 45 D0 01 00 00 00 B8 48 00 00 00 66 89 45 E8 E9 E6 01 00 00 8B 4D E0 89 4D B4 83 7D B4 01 74 08 83 7D B4 02 74 09 EB 10 C7 45 D0 01 00 00 00 BA 4D 00 00 00 66 89 55 E8 E9 BD 01 00 00 8B 45 E0 89 45 B0 83 7D B0 01 74 08 83 7D B0 02 74 09 EB 10 C7 45 D0 01 00 00 00 B9 53 00 00 00 66 89 4D E8 E9 94 01 00 00 68 ?? ?? ?? ?? 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 0B 8B 45 E4 83 C0 0A 89 45 DC EB 1E 68 ?? ?? ?? ?? 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 09 8B 55 E4 83 C2 06 89 55 DC B8 70 00 00 00 66 89 45 E8 E9 48 01 00 00 8B 4D 10 83 79 08 0B 7F 17 BA 04 00 00 00 6B C2 00 8B 4D 1C 8B 94 01 4C 01 00 00 89 55 D4 EB 15 B8 04 00 00 00 C1 E0 00 8B 4D 1C 8B 94 01 4C 01 00 00 89 55 D4 83 7D E0 01 75 3B 8B 45 18 83 38 00 76 33 8B 4D 14 8B 11 8B 45 D4 66 8B 08 66 89 0A 8B 55 14 8B 02 83 C0 02 8B 4D 14 89 01 8B 55 D4 83 C2 02 89 55 D4 8B 45 18 8B 08 83 E9 01 8B 55 18 89 0A EB 45 8B 45 D4 0F B7 08 85 C9 74 3B 8B 55 18 83 3A 00 76 33 8B 45 14 8B 08 8B 55 D4 66 8B 02 66 89 01 8B 4D 14 8B 11 83 C2 02 8B 45 14 89 10 8B 4D D4 83 C1 02 89 4D D4 8B 55 18 8B 02 83 E8 01 8B 4D 18 89 01 EB BB 8B 55 DC 89 55 E4 E9 EF FC FF FF 8B 45 E0 83 E0 01 74 69 8B 4D E0 8B 55 E4 8D 04 4A 89 45 E4 8B 4D E4 0F B7 11 85 D2 74 51 8B 45 18 83 38 00 74 49 8B 4D E4 0F B7 11 83 FA 27 75 0B 8B 45 E4 83 C0 02 89 45 E4 EB 33 8B 4D 14 8B 11 8B 45 E4 66 8B 08 66 89 0A 8B 55 14 8B 02 83 C0 02 8B 4D 14 89 01 8B 55 E4 83 C2 02 89 55 E4 8B 45 18 8B 08 83 E9 01 8B 55 18 89 0A EB A5 EB 0C 8B 45 E0 8B 4D E4 8D 14 41 89 55 E4 E9 6D FC FF FF 0F B7 45 E8 85 C0 74 35 8B 4D D0 51 8B 55 1C 52 8B 45 18 50 8B 4D 14 51 8B 55 10 52 0F B7 45 E8 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 04 33 C0 EB 43 8B 55 DC 89 55 E4 EB 31 8B 45 14 8B 08 8B 55 E4 66 8B 02 66 89 01 8B 4D 14 8B 11 83 C2 02 8B 45 14 89 10 8B 4D E4 83 C1 02 89 4D E4 8B 55 18 8B 02 83 E8 01 8B 4D 18 89 01 E9 FA FB FF FF B8 01 00 00 00 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 01 0A 0A 0A 0A 0A 0A 02 0A 0A 0A 0A 03 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 01 0A 0A 04 0A 0A 0A 05 0A 0A 0A 0A 06 0A 0A 0A 0A 0A 07 08 0A 0A 0A 0A 09 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_54_8_0 {
	meta:
		name = "__MallocaIsSizeInRange"
		size = 38
	strings:
		$1 = { 55 8B EC 51 8B 45 08 83 C0 08 3B 45 08 76 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_54_9_0 {
	meta:
		name = "__MarkAllocaS"
		size = 31
	strings:
		$1 = { 55 8B EC 83 7D 08 00 74 11 8B 45 08 8B 4D 0C 89 08 8B 55 08 83 C2 08 89 55 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_54_11_0 {
	meta:
		name = "__W_Getdays_l"
		size = 467
		refs = "0016 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001e ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0054 _wcslen 0082 ??_C@_0CJ@EOMIKGKJ@f?3?2dd?2vctools?2crt?2crtw32?2time?2wc@ 0091 __malloc_dbg 00e0 ??_C@_1FC@MHEEEHDG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAt?$AAi?$AAm?$AAe?$AA?2?$AAw?$AAc@ 00e5 ??_C@_1BK@DKAKFCHE@?$AA_?$AAW?$AA_?$AAG?$AAe?$AAt?$AAd?$AAa?$AAy?$AAs?$AA_?$AAl?$AA?$AA@ 00ea ??_C@_1GM@DDFADNDP@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AA?0?$AA?5?$AA?$CI?$AAl?$AAe?$AAn?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAs?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0@ 0112 _wcscpy_s 011b __invoke_watson_if_error 015a ??_C@_1GC@IDMAOELP@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AA?0?$AA?5?$AA?$CI?$AAl?$AAe?$AAn?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAs?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0@ 01c7 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 28 56 C7 45 F4 00 00 00 00 8B 45 08 50 8D 4D D8 E8 ?? ?? ?? ?? 8D 4D D8 E8 ?? ?? ?? ?? 8B 08 8B 91 9C 00 00 00 89 55 EC C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 83 7D F8 07 73 3A 8B 4D F8 8B 55 EC 8B 84 8A B4 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 4D F8 8B 55 EC 8B 84 8A D0 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 04 03 45 F4 8D 4C 30 02 89 4D F4 EB B7 6A 48 68 ?? ?? ?? ?? 6A 02 8B 55 F4 8D 44 12 02 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F0 83 7D F0 00 0F 84 18 01 00 00 8B 4D F0 89 4D FC C7 45 F8 00 00 00 00 EB 09 8B 55 F8 83 C2 01 89 55 F8 83 7D F8 07 0F 83 E5 00 00 00 B8 3A 00 00 00 8B 4D FC 66 89 01 8B 55 FC 83 C2 02 89 55 FC 6A 00 6A 4F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 F8 8B 4D EC 8B 94 81 B4 00 00 00 52 8B 45 F4 83 C0 01 8B 4D FC 2B 4D F0 D1 F9 2B C1 50 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 14 41 89 55 FC B8 3A 00 00 00 8B 4D FC 66 89 01 8B 55 FC 83 C2 02 89 55 FC 6A 00 6A 52 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 F8 8B 4D EC 8B 94 81 D0 00 00 00 52 8B 45 F4 83 C0 01 8B 4D FC 2B 4D F0 D1 F9 2B C1 50 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 14 41 89 55 FC E9 08 FF FF FF 33 C0 8B 4D FC 66 89 01 8B 55 FC 83 C2 02 89 55 FC 8B 45 F0 89 45 E8 8D 4D D8 E8 ?? ?? ?? ?? 8B 45 E8 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_54_13_0 {
	meta:
		name = "__W_Getmonths_l"
		size = 467
		refs = "0016 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001e ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0054 _wcslen 0082 ??_C@_0CJ@EOMIKGKJ@f?3?2dd?2vctools?2crt?2crtw32?2time?2wc@ 0091 __malloc_dbg 00e0 ??_C@_1FC@MHEEEHDG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAt?$AAi?$AAm?$AAe?$AA?2?$AAw?$AAc@ 00e5 ??_C@_1BO@LLHMCFBH@?$AA_?$AAW?$AA_?$AAG?$AAe?$AAt?$AAm?$AAo?$AAn?$AAt?$AAh?$AAs?$AA_?$AAl?$AA?$AA@ 00ea ??_C@_1GO@OOJGCLJA@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AA?0?$AA?5?$AA?$CI?$AAl?$AAe?$AAn?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAs?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0@ 0112 _wcscpy_s 011b __invoke_watson_if_error 015a ??_C@_1GE@BMIICOLH@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AA?0?$AA?5?$AA?$CI?$AAl?$AAe?$AAn?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAs?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0@ 01c7 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 83 EC 28 56 C7 45 F4 00 00 00 00 8B 45 08 50 8D 4D D8 E8 ?? ?? ?? ?? 8D 4D D8 E8 ?? ?? ?? ?? 8B 08 8B 91 9C 00 00 00 89 55 EC C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 83 7D F8 0C 73 3A 8B 4D F8 8B 55 EC 8B 84 8A EC 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 4D F8 8B 55 EC 8B 84 8A 1C 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 04 03 45 F4 8D 4C 30 02 89 4D F4 EB B7 6A 6F 68 ?? ?? ?? ?? 6A 02 8B 55 F4 8D 44 12 02 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F0 83 7D F0 00 0F 84 18 01 00 00 8B 4D F0 89 4D FC C7 45 F8 00 00 00 00 EB 09 8B 55 F8 83 C2 01 89 55 F8 83 7D F8 0C 0F 83 E5 00 00 00 B8 3A 00 00 00 8B 4D FC 66 89 01 8B 55 FC 83 C2 02 89 55 FC 6A 00 6A 76 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 F8 8B 4D EC 8B 94 81 EC 00 00 00 52 8B 45 F4 83 C0 01 8B 4D FC 2B 4D F0 D1 F9 2B C1 50 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 14 41 89 55 FC B8 3A 00 00 00 8B 4D FC 66 89 01 8B 55 FC 83 C2 02 89 55 FC 6A 00 6A 79 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 F8 8B 4D EC 8B 94 81 1C 01 00 00 52 8B 45 F4 83 C0 01 8B 4D FC 2B 4D F0 D1 F9 2B C1 50 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 14 41 89 55 FC E9 08 FF FF FF 33 C0 8B 4D FC 66 89 01 8B 55 FC 83 C2 02 89 55 FC 8B 45 F0 89 45 E8 8D 4D D8 E8 ?? ?? ?? ?? 8B 45 E8 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_54_15_0 {
	meta:
		name = "__W_Gettnames_l"
		size = 3157
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0016 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0062 ??_C@_0CJ@EOMIKGKJ@f?3?2dd?2vctools?2crt?2crtw32?2time?2wc@ 006d __malloc_dbg 0088 ??1_LocaleUpdate@@QAE@XZ 009f _memset 0107 ??_C@_1FC@MHEEEHDG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAt?$AAi?$AAm?$AAe?$AA?2?$AAw?$AAc@ 010c ??_C@_1BO@PBGPBIFI@?$AA_?$AAW?$AA_?$AAG?$AAe?$AAt?$AAt?$AAn?$AAa?$AAm?$AAe?$AAs?$AA_?$AAl?$AA?$AA@ 0111 ??_C@_1LE@EPEEHFIO@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AA?9?$AA?$DO?$AAw?$AAd?$AAa?$AAy?$AA_?$AAa?$AAb?$AAb?$AAr?$AA?$FL?$AAi?$AAd?$AAx?$AA?$FN?$AA?0?$AA?5?$AA?$CI@ 0131 _strcpy_s 013a __invoke_watson_if_error 014c _strlen 01c1 ??_C@_1KA@DNKADEMJ@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AA?9?$AA?$DO?$AAw?$AAd?$AAa?$AAy?$AA?$FL?$AAi?$AAd?$AAx?$AA?$FN?$AA?0?$AA?5?$AA?$CI?$AAt?$AAo?$AAt?$AAa?$AAl@ 0274 ??_C@_1LI@LILLBJL@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AA?9?$AA?$DO?$AAm?$AAo?$AAn?$AAt?$AAh?$AA_?$AAa?$AAb?$AAb?$AAr?$AA?$FL?$AAi?$AAd?$AAx?$AA?$FN?$AA?0?$AA?5@ 0327 ??_C@_1KE@EGBDBCG@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AA?9?$AA?$DO?$AAm?$AAo?$AAn?$AAt?$AAh?$AA?$FL?$AAi?$AAd?$AAx?$AA?$FN?$AA?0?$AA?5?$AA?$CI?$AAt?$AAo?$AAt?$AAa@ 03dd ??_C@_1KA@EAALKIBB@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AA?9?$AA?$DO?$AAa?$AAm?$AAp?$AAm?$AA?$FL?$AAi?$AAd?$AAx?$AA?$FN?$AA?0?$AA?5?$AA?$CI?$AAt?$AAo?$AAt?$AAa?$AAl@ 047c ??_C@_1KI@LLEJMBLB@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AA?9?$AA?$DO?$AAw?$AAw?$AA_?$AAs?$AAd?$AAa?$AAt?$AAe?$AAf?$AAm?$AAt?$AA?0?$AA?5?$AA?$CI?$AAt?$AAo?$AAt@ 050a ??_C@_1KI@GIABBOIC@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AA?9?$AA?$DO?$AAw?$AAw?$AA_?$AAl?$AAd?$AAa?$AAt?$AAe?$AAf?$AAm?$AAt?$AA?0?$AA?5?$AA?$CI?$AAt?$AAo?$AAt@ 0598 ??_C@_1KE@KMENGKAI@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AA?9?$AA?$DO?$AAw?$AAw?$AA_?$AAt?$AAi?$AAm?$AAe?$AAf?$AAm?$AAt?$AA?0?$AA?5?$AA?$CI?$AAt?$AAo?$AAt?$AAa@ 0670 ??_C@_1MG@MAEGINLA@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AA?9?$AA?$DO?$AA_?$AAW?$AA_?$AAw?$AAd?$AAa?$AAy?$AA_?$AAa?$AAb?$AAb?$AAr?$AA?$FL?$AAi?$AAd?$AAx?$AA?$FN@ 069a _wcscpy_s 06b9 _wcslen 0736 ??_C@_1LC@MJCDIPJF@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AA?9?$AA?$DO?$AA_?$AAW?$AA_?$AAw?$AAd?$AAa?$AAy?$AA?$FL?$AAi?$AAd?$AAx?$AA?$FN?$AA?0?$AA?5?$AA?$CI?$AAt?$AAo@ 07fc ??_C@_1MK@EOAFACEP@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AA?9?$AA?$DO?$AA_?$AAW?$AA_?$AAm?$AAo?$AAn?$AAt?$AAh?$AA_?$AAa?$AAb?$AAb?$AAr?$AA?$FL?$AAi?$AAd?$AAx@ 08c2 ??_C@_1LG@LPOFFBCL@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AA?9?$AA?$DO?$AA_?$AAW?$AA_?$AAm?$AAo?$AAn?$AAt?$AAh?$AA?$FL?$AAi?$AAd?$AAx?$AA?$FN?$AA?0?$AA?5?$AA?$CI?$AAt@ 0988 ??_C@_1LC@HNOGCLCC@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AA?9?$AA?$DO?$AA_?$AAW?$AA_?$AAa?$AAm?$AAp?$AAm?$AA?$FL?$AAi?$AAd?$AAx?$AA?$FN?$AA?0?$AA?5?$AA?$CI?$AAt?$AAo@ 0a2e ??_C@_1LK@CAMBHKNN@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AA?9?$AA?$DO?$AA_?$AAW?$AA_?$AAw?$AAw?$AA_?$AAs?$AAd?$AAa?$AAt?$AAe?$AAf?$AAm?$AAt?$AA?0?$AA?5?$AA?$CI@ 0ac3 ??_C@_1LK@KFLHCLNA@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AA?9?$AA?$DO?$AA_?$AAW?$AA_?$AAw?$AAw?$AA_?$AAl?$AAd?$AAa?$AAt?$AAe?$AAf?$AAm?$AAt?$AA?0?$AA?5?$AA?$CI@ 0b58 ??_C@_1LG@IAIDKMAF@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AA?9?$AA?$DO?$AA_?$AAW?$AA_?$AAw?$AAw?$AA_?$AAt?$AAi?$AAm?$AAe?$AAf?$AAm?$AAt?$AA?0?$AA?5?$AA?$CI?$AAt@ 0bed ??_C@_1MG@JFPIJBHF@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AA?9?$AA?$DO?$AA_?$AAW?$AA_?$AAw?$AAw?$AA_?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA_?$AAn?$AAa?$AAm?$AAe@"
	strings:
		$1 = { 55 8B EC 83 EC 54 8B 45 08 50 8D 4D AC E8 ?? ?? ?? ?? 8D 4D AC E8 ?? ?? ?? ?? 8B 08 8B 91 9C 00 00 00 89 55 F4 C7 45 EC 00 00 00 00 C7 45 FC 64 01 00 00 C7 45 F8 00 00 00 00 C7 45 F0 00 00 00 00 EB 09 8B 45 F0 83 C0 01 89 45 F0 83 7D F0 02 0F 8D EA 0B 00 00 83 7D F0 01 75 57 68 99 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 75 17 C7 45 C0 00 00 00 00 8D 4D AC E8 ?? ?? ?? ?? 8B 45 C0 E9 BD 0B 00 00 8B 55 FC 52 6A 00 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 89 4D EC C7 45 FC 64 01 00 00 C7 45 E8 00 00 00 00 EB 09 8B 55 E8 83 C2 01 89 55 E8 83 7D E8 07 0F 83 93 00 00 00 8B 45 FC 33 D2 B9 01 00 00 00 F7 F1 85 D2 74 0B 8B 55 FC 83 C2 01 89 55 FC EB E5 83 7D F0 01 75 51 8B 45 F8 03 45 FC 8B 4D E8 8B 55 F8 89 04 8A 6A 00 68 C0 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 E8 8B 4D F4 8B 14 81 52 8B 45 EC 2B 45 FC 50 8B 4D E8 8B 55 F8 8B 04 8A 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D E8 8B 55 F4 8B 04 8A 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 54 01 01 89 55 FC E9 5A FF FF FF C7 45 E4 00 00 00 00 EB 09 8B 45 E4 83 C0 01 89 45 E4 83 7D E4 07 0F 83 97 00 00 00 8B 45 FC 33 D2 B9 01 00 00 00 F7 F1 85 D2 74 0B 8B 55 FC 83 C2 01 89 55 FC EB E5 83 7D F0 01 75 54 8B 45 F8 03 45 FC 8B 4D E4 8B 55 F8 89 44 8A 1C 6A 00 68 C1 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 E4 8B 4D F4 8B 54 81 1C 52 8B 45 EC 2B 45 FC 50 8B 4D E4 8B 55 F8 8B 44 8A 1C 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D E4 8B 55 F4 8B 44 8A 1C 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 54 01 01 89 55 FC E9 56 FF FF FF C7 45 E0 00 00 00 00 EB 09 8B 45 E0 83 C0 01 89 45 E0 83 7D E0 0C 0F 83 97 00 00 00 8B 45 FC 33 D2 B9 01 00 00 00 F7 F1 85 D2 74 0B 8B 55 FC 83 C2 01 89 55 FC EB E5 83 7D F0 01 75 54 8B 45 F8 03 45 FC 8B 4D E0 8B 55 F8 89 44 8A 38 6A 00 68 C2 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 E0 8B 4D F4 8B 54 81 38 52 8B 45 EC 2B 45 FC 50 8B 4D E0 8B 55 F8 8B 44 8A 38 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D E0 8B 55 F4 8B 44 8A 38 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 54 01 01 89 55 FC E9 56 FF FF FF C7 45 DC 00 00 00 00 EB 09 8B 45 DC 83 C0 01 89 45 DC 83 7D DC 0C 0F 83 97 00 00 00 8B 45 FC 33 D2 B9 01 00 00 00 F7 F1 85 D2 74 0B 8B 55 FC 83 C2 01 89 55 FC EB E5 83 7D F0 01 75 54 8B 45 F8 03 45 FC 8B 4D DC 8B 55 F8 89 44 8A 68 6A 00 68 C3 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 DC 8B 4D F4 8B 54 81 68 52 8B 45 EC 2B 45 FC 50 8B 4D DC 8B 55 F8 8B 44 8A 68 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D DC 8B 55 F4 8B 44 8A 68 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 54 01 01 89 55 FC E9 56 FF FF FF C7 45 D8 00 00 00 00 EB 09 8B 45 D8 83 C0 01 89 45 D8 83 7D D8 02 0F 83 A3 00 00 00 8B 45 FC 33 D2 B9 01 00 00 00 F7 F1 85 D2 74 0B 8B 55 FC 83 C2 01 89 55 FC EB E5 83 7D F0 01 75 5D 8B 45 F8 03 45 FC 8B 4D D8 8B 55 F8 89 84 8A 98 00 00 00 6A 00 68 C4 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 D8 8B 4D F4 8B 94 81 98 00 00 00 52 8B 45 EC 2B 45 FC 50 8B 4D D8 8B 55 F8 8B 84 8A 98 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D D8 8B 55 F4 8B 84 8A 98 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 54 01 01 89 55 FC E9 4A FF FF FF 8B 45 FC 33 D2 B9 01 00 00 00 F7 F1 85 D2 74 0B 8B 55 FC 83 C2 01 89 55 FC EB E5 83 7D F0 01 75 51 8B 45 F8 03 45 FC 8B 4D F8 89 81 A0 00 00 00 6A 00 68 C5 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 F4 8B 82 A0 00 00 00 50 8B 4D EC 2B 4D FC 51 8B 55 F8 8B 82 A0 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D F4 8B 91 A0 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 54 01 01 89 55 FC 8B 45 FC 33 D2 B9 01 00 00 00 F7 F1 85 D2 74 0B 8B 55 FC 83 C2 01 89 55 FC EB E5 83 7D F0 01 75 51 8B 45 F8 03 45 FC 8B 4D F8 89 81 A4 00 00 00 6A 00 68 C6 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 F4 8B 82 A4 00 00 00 50 8B 4D EC 2B 4D FC 51 8B 55 F8 8B 82 A4 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D F4 8B 91 A4 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 54 01 01 89 55 FC 8B 45 FC 33 D2 B9 01 00 00 00 F7 F1 85 D2 74 0B 8B 55 FC 83 C2 01 89 55 FC EB E5 83 7D F0 01 75 51 8B 45 F8 03 45 FC 8B 4D F8 89 81 A8 00 00 00 6A 00 68 C7 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 F4 8B 82 A8 00 00 00 50 8B 4D EC 2B 4D FC 51 8B 55 F8 8B 82 A8 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D F4 8B 91 A8 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 54 01 01 89 55 FC 83 7D F0 01 75 1F 8B 45 F8 8B 4D F4 8B 91 AC 00 00 00 89 90 AC 00 00 00 8B 45 F8 C7 80 B0 00 00 00 00 00 00 00 C7 45 D4 00 00 00 00 EB 09 8B 4D D4 83 C1 01 89 4D D4 83 7D D4 07 0F 83 AA 00 00 00 8B 45 FC 33 D2 B9 02 00 00 00 F7 F1 85 D2 74 0B 8B 55 FC 83 C2 01 89 55 FC EB E5 83 7D F0 01 75 64 8B 45 FC D1 E8 8B 4D F8 8D 14 41 8B 45 D4 8B 4D F8 89 94 81 B4 00 00 00 6A 00 68 CE 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 D4 8B 45 F4 8B 8C 90 B4 00 00 00 51 8B 55 EC 2B 55 FC D1 EA 52 8B 45 D4 8B 4D F8 8B 94 81 B4 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 D4 8B 4D F4 8B 94 81 B4 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 54 41 02 89 55 FC E9 43 FF FF FF C7 45 D0 00 00 00 00 EB 09 8B 45 D0 83 C0 01 89 45 D0 83 7D D0 07 0F 83 AA 00 00 00 8B 45 FC 33 D2 B9 02 00 00 00 F7 F1 85 D2 74 0B 8B 55 FC 83 C2 01 89 55 FC EB E5 83 7D F0 01 75 64 8B 45 FC D1 E8 8B 4D F8 8D 14 41 8B 45 D0 8B 4D F8 89 94 81 D0 00 00 00 6A 00 68 CF 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 D0 8B 45 F4 8B 8C 90 D0 00 00 00 51 8B 55 EC 2B 55 FC D1 EA 52 8B 45 D0 8B 4D F8 8B 94 81 D0 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 D0 8B 4D F4 8B 94 81 D0 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 54 41 02 89 55 FC E9 43 FF FF FF C7 45 CC 00 00 00 00 EB 09 8B 45 CC 83 C0 01 89 45 CC 83 7D CC 0C 0F 83 AA 00 00 00 8B 45 FC 33 D2 B9 02 00 00 00 F7 F1 85 D2 74 0B 8B 55 FC 83 C2 01 89 55 FC EB E5 83 7D F0 01 75 64 8B 45 FC D1 E8 8B 4D F8 8D 14 41 8B 45 CC 8B 4D F8 89 94 81 EC 00 00 00 6A 00 68 D0 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 CC 8B 45 F4 8B 8C 90 EC 00 00 00 51 8B 55 EC 2B 55 FC D1 EA 52 8B 45 CC 8B 4D F8 8B 94 81 EC 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 CC 8B 4D F4 8B 94 81 EC 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 54 41 02 89 55 FC E9 43 FF FF FF C7 45 C8 00 00 00 00 EB 09 8B 45 C8 83 C0 01 89 45 C8 83 7D C8 0C 0F 83 AA 00 00 00 8B 45 FC 33 D2 B9 02 00 00 00 F7 F1 85 D2 74 0B 8B 55 FC 83 C2 01 89 55 FC EB E5 83 7D F0 01 75 64 8B 45 FC D1 E8 8B 4D F8 8D 14 41 8B 45 C8 8B 4D F8 89 94 81 1C 01 00 00 6A 00 68 D1 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 C8 8B 45 F4 8B 8C 90 1C 01 00 00 51 8B 55 EC 2B 55 FC D1 EA 52 8B 45 C8 8B 4D F8 8B 94 81 1C 01 00 00 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 C8 8B 4D F4 8B 94 81 1C 01 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 54 41 02 89 55 FC E9 43 FF FF FF C7 45 C4 00 00 00 00 EB 09 8B 45 C4 83 C0 01 89 45 C4 83 7D C4 02 0F 83 AA 00 00 00 8B 45 FC 33 D2 B9 02 00 00 00 F7 F1 85 D2 74 0B 8B 55 FC 83 C2 01 89 55 FC EB E5 83 7D F0 01 75 64 8B 45 FC D1 E8 8B 4D F8 8D 14 41 8B 45 C4 8B 4D F8 89 94 81 4C 01 00 00 6A 00 68 D2 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 C4 8B 45 F4 8B 8C 90 4C 01 00 00 51 8B 55 EC 2B 55 FC D1 EA 52 8B 45 C4 8B 4D F8 8B 94 81 4C 01 00 00 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 C4 8B 4D F4 8B 94 81 4C 01 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 54 41 02 89 55 FC E9 43 FF FF FF 8B 45 FC 33 D2 B9 02 00 00 00 F7 F1 85 D2 74 0B 8B 55 FC 83 C2 01 89 55 FC EB E5 83 7D F0 01 75 58 8B 45 FC D1 E8 8B 4D F8 8D 14 41 8B 45 F8 89 90 54 01 00 00 6A 00 68 D3 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D F4 8B 91 54 01 00 00 52 8B 45 EC 2B 45 FC D1 E8 50 8B 4D F8 8B 91 54 01 00 00 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 F4 8B 88 54 01 00 00 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 8D 44 42 02 89 45 FC 8B 45 FC 33 D2 B9 02 00 00 00 F7 F1 85 D2 74 0B 8B 55 FC 83 C2 01 89 55 FC EB E5 83 7D F0 01 75 58 8B 45 FC D1 E8 8B 4D F8 8D 14 41 8B 45 F8 89 90 58 01 00 00 6A 00 68 D4 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D F4 8B 91 58 01 00 00 52 8B 45 EC 2B 45 FC D1 E8 50 8B 4D F8 8B 91 58 01 00 00 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 F4 8B 88 58 01 00 00 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 8D 44 42 02 89 45 FC 8B 45 FC 33 D2 B9 02 00 00 00 F7 F1 85 D2 74 0B 8B 55 FC 83 C2 01 89 55 FC EB E5 83 7D F0 01 75 58 8B 45 FC D1 E8 8B 4D F8 8D 14 41 8B 45 F8 89 90 5C 01 00 00 6A 00 68 D5 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D F4 8B 91 5C 01 00 00 52 8B 45 EC 2B 45 FC D1 E8 50 8B 4D F8 8B 91 5C 01 00 00 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 F4 8B 88 5C 01 00 00 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 8D 44 42 02 89 45 FC 8B 45 FC 33 D2 B9 02 00 00 00 F7 F1 85 D2 74 0B 8B 55 FC 83 C2 01 89 55 FC EB E5 83 7D F0 01 75 58 8B 45 FC D1 E8 8B 4D F8 8D 14 41 8B 45 F8 89 90 60 01 00 00 6A 00 68 D6 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D F4 8B 91 60 01 00 00 52 8B 45 EC 2B 45 FC D1 E8 50 8B 4D F8 8B 91 60 01 00 00 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 F4 8B 88 60 01 00 00 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 8D 44 42 02 89 45 FC E9 03 F4 FF FF 8B 4D F8 89 4D BC 8D 4D AC E8 ?? ?? ?? ?? 8B 45 BC 8B E5 5D C3 }
	condition:
		$1
}

rule file_54_16_0 {
	meta:
		name = "__Wcsftime"
		size = 35
		refs = "001a __Wcsftime_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_1297_8_0 {
	meta:
		name = "__Strftime"
		size = 35
		refs = "001a __Strftime_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_140_6_0 {
	meta:
		name = "__cftoa"
		size = 35
		refs = "001a __cftoa_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_140_8_0 {
	meta:
		name = "__cftoe"
		size = 35
		refs = "001a __cftoe_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_140_14_0 {
	meta:
		name = "__cftog"
		size = 35
		refs = "001a __cftog_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_259_7_0 {
	meta:
		name = "_mbstowcs_s"
		size = 35
		refs = "001a __mbstowcs_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_1348_8_0 {
	meta:
		name = "_wcstombs_s"
		size = 35
		refs = "001a __wcstombs_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_54_17_0 {
	meta:
		name = "__Wcsftime_l"
		size = 1087
		refs = "001b ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0042 ??_C@_1CG@MPKJHDAA@?$AA?$CI?$AA?5?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 0047 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0053 ??_C@_1FC@MHEEEHDG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAt?$AAi?$AAm?$AAe?$AA?2?$AAw?$AAc@ 005a __CrtDbgReportW 006e __errno 0085 ??_C@_1BI@FPGNEFIH@?$AA_?$AAW?$AAc?$AAs?$AAf?$AAt?$AAi?$AAm?$AAe?$AA_?$AAl?$AA?$AA@ 008f __invalid_parameter 00a1 ??1_LocaleUpdate@@QAE@XZ 00d0 ??_C@_1CC@IHEJKGMG@?$AA?$CI?$AA?5?$AAm?$AAa?$AAx?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CJ?$AA?$AA@ 0166 ??_C@_1CG@MHIOFJLE@?$AA?$CI?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 01db ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 024a ??_C@_1CA@COHOENPC@?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0305 ?_W_expandtime@@YAHPAUlocaleinfo_struct@@_WPBUtm@@PAPA_WPAIPAU__lc_time_data@@I@Z 03b7 ??_C@_1M@HCOOECOK@?$AAF?$AAA?$AAL?$AAS?$AAE?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 6C C7 45 F8 00 00 00 00 8B 45 08 89 45 AC 8B 4D 1C 51 8D 4D 94 E8 ?? ?? ?? ?? 83 7D 08 00 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 55 F4 89 55 F0 83 7D F0 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 12 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 12 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 C4 00 00 00 00 8D 4D 94 E8 ?? ?? ?? ?? 8B 45 C4 E9 8E 03 00 00 83 7D 0C 00 74 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 4D EC 89 4D E8 83 7D E8 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 13 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E8 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 13 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 C0 00 00 00 00 8D 4D 94 E8 ?? ?? ?? ?? 8B 45 C0 E9 00 03 00 00 33 C0 8B 4D 08 66 89 01 83 7D 10 00 74 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 55 E4 89 55 E0 83 7D E0 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 16 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E0 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 16 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 BC 00 00 00 00 8D 4D 94 E8 ?? ?? ?? ?? 8B 45 BC E9 6A 02 00 00 83 7D 18 00 75 15 8D 4D 94 E8 ?? ?? ?? ?? 8B 08 8B 91 9C 00 00 00 89 55 DC EB 06 8B 45 18 89 45 DC 8B 4D DC 89 4D B4 8B 55 0C 89 55 FC 83 7D FC 00 0F 86 4E 01 00 00 8B 45 10 0F B7 08 89 4D D8 83 7D D8 00 74 0B 83 7D D8 25 74 0A E9 08 01 00 00 E9 2F 01 00 00 83 7D 14 00 74 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 55 D4 89 55 D0 83 7D D0 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 37 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D0 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 37 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 B8 00 00 00 00 8D 4D 94 E8 ?? ?? ?? ?? 8B 45 B8 E9 86 01 00 00 8B 4D 10 83 C1 02 89 4D 10 C7 45 CC 00 00 00 00 8B 55 10 0F B7 02 83 F8 23 75 10 C7 45 CC 01 00 00 00 8B 4D 10 83 C1 02 89 4D 10 8B 55 CC 52 8B 45 B4 50 8D 4D FC 51 8D 55 08 52 8B 45 14 50 8B 4D 10 0F B7 11 52 8D 4D 94 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 0F 83 7D FC 00 76 07 C7 45 F8 01 00 00 00 EB 37 8B 45 10 83 C0 02 89 45 10 EB 27 8B 4D 08 8B 55 10 66 8B 02 66 89 01 8B 4D 08 83 C1 02 89 4D 08 8B 55 10 83 C2 02 89 55 10 8B 45 FC 83 E8 01 89 45 FC E9 A8 FE FF FF 83 7D F8 00 75 2C 83 7D FC 00 76 26 33 C9 8B 55 08 66 89 0A 8B 45 0C 2B 45 FC 89 45 B0 8D 4D 94 E8 ?? ?? ?? ?? 8B 45 B0 E9 B8 00 00 00 E9 AB 00 00 00 33 C9 8B 55 AC 66 89 0A 83 7D F8 00 75 13 83 7D FC 00 77 0D E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 76 C7 45 C8 00 00 00 00 83 7D C8 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 77 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D C8 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 77 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 A8 00 00 00 00 8D 4D 94 E8 ?? ?? ?? ?? 8B 45 A8 EB 1C C7 45 A4 00 00 00 00 8D 4D 94 E8 ?? ?? ?? ?? 8B 45 A4 EB 08 8D 4D 94 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_54_18_0 {
	meta:
		name = "__freea"
		size = 105
		refs = "0029 _free 0040 ??_C@_1FE@KNPCCODH@?$AA?$CI?$AA?$CC?$AAC?$AAo?$AAr?$AAr?$AAu?$AAp?$AAt?$AAe?$AAd?$AA?5?$AAp?$AAo?$AAi?$AAn?$AAt?$AAe?$AAr?$AA?5?$AAp?$AAa?$AAs?$AAs?$AAe?$AAd?$AA?5?$AAt?$AAo?$AA?5?$AA_?$AAf@ 0045 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0051 ??_C@_1EI@DKDOCKPJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAh?$AA?2?$AAm?$AAa?$AAl?$AAl?$AAo@ 0058 __CrtDbgReportW"
	strings:
		$1 = { 55 8B EC 51 83 7D 08 00 74 5B 8B 45 08 83 E8 08 89 45 08 8B 4D 08 8B 11 89 55 FC 81 7D FC DD DD 00 00 75 0E 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 EB 33 81 7D FC CC CC 00 00 74 2A 33 C9 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 0E 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8B E5 5D C3 }
	condition:
		$1
}

rule file_54_21_0 {
	meta:
		name = "__wcsftime_l"
		size = 35
		refs = "001a __Wcsftime_l"
	strings:
		$1 = { 55 8B EC 8B 45 18 50 6A 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_1297_11_0 {
	meta:
		name = "__strftime_l"
		size = 35
		refs = "001a __Strftime_l"
	strings:
		$1 = { 55 8B EC 8B 45 18 50 6A 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_521_3_0 {
	meta:
		name = "__vsnprintf_s"
		size = 35
		refs = "001a __vsnprintf_s_l"
	strings:
		$1 = { 55 8B EC 8B 45 18 50 6A 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_1286_0_0 {
	meta:
		name = "__vsnwprintf_s"
		size = 35
		refs = "001a __vsnwprintf_s_l"
	strings:
		$1 = { 55 8B EC 8B 45 18 50 6A 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_54_22_0 {
	meta:
		name = "_wcsftime"
		size = 33
		refs = "0018 __Wcsftime_l"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_806_35_0 {
	meta:
		name = "__aligned_offset_realloc"
		size = 33
		refs = "0018 __aligned_offset_realloc_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_1297_12_0 {
	meta:
		name = "_strftime"
		size = 33
		refs = "0018 __Strftime_l"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "__rmtmp"
		size = 341
		refs = "0006 __sehtable$__rmtmp 000b __except_handler4 001d ___security_cookie 003a __lock 005f __nstream 006d ___piob 00a7 __lock_file2 00eb __fclose_nolock 011a __unlock_file2 0138 __unlock"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E0 00 00 00 00 6A 01 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 C7 45 E4 00 00 00 00 EB 09 8B 45 E4 83 C0 01 89 45 E4 8B 4D E4 3B 0D ?? ?? ?? ?? 0F 8D BE 00 00 00 8B 55 E4 A1 ?? ?? ?? ?? 83 3C 90 00 0F 84 A7 00 00 00 8B 4D E4 8B 15 ?? ?? ?? ?? 8B 04 8A 8B 48 0C 81 E1 83 00 00 00 0F 84 8C 00 00 00 8B 55 E4 A1 ?? ?? ?? ?? 8B 0C 90 51 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC 01 00 00 00 8B 45 E4 8B 0D ?? ?? ?? ?? 8B 14 81 8B 42 0C 25 83 00 00 00 74 30 8B 4D E4 8B 15 ?? ?? ?? ?? 8B 04 8A 83 78 1C 00 74 1E 8B 4D E4 8B 15 ?? ?? ?? ?? 8B 04 8A 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D E0 83 C1 01 89 4D E0 C7 45 FC 00 00 00 00 E8 02 00 00 00 EB 19 8B 55 E4 A1 ?? ?? ?? ?? 8B 0C 90 51 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 08 C3 E9 2A FF FF FF C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 01 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "@x64tow_s@24"
		size = 1088
		refs = "002f ??_C@_1BI@ICGGMGLK@?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0034 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0040 ??_C@_1FA@LEFFAILN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAv?$AAe?$AAr?$AAt@ 0047 __CrtDbgReportW 005b __errno 0072 ??_C@_1BC@HDEJCFPB@?$AAx?$AA6?$AA4?$AAt?$AAo?$AAw?$AA_?$AAs?$AA?$AA@ 007c __invalid_parameter 00b0 ??_C@_1CC@JNJFIMGE@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0133 ___crtDebugFillThreshold 0160 _memset 01a2 ??_C@_1FA@MKGGAGEI@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AA_?$AAt?$AA?$CJ?$AA?$CI?$AAi?$AAs?$AA_?$AAn?$AAe?$AAg?$AA?5?$AA?$DP@ 0229 ??_C@_1DE@PCJGDBBD@?$AA2?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA3?$AA6?$AA?$AA@ 02e0 __aullrem 02f7 __aulldiv 0392 ??_C@_1CM@HABGDNLJ@?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DM?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 4C 89 55 F4 89 4D EC 83 7D EC 00 74 09 C7 45 E0 01 00 00 00 EB 07 C7 45 E0 00 00 00 00 8B 45 E0 89 45 DC 83 7D DC 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 3E 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D DC 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 3E 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 AD 03 00 00 83 7D F4 00 76 09 C7 45 D8 01 00 00 00 EB 07 C7 45 D8 00 00 00 00 8B 55 D8 89 55 D4 83 7D D4 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 3F 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D4 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 3F 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 2C 03 00 00 33 C9 8B 55 EC 66 89 0A 83 7D F4 FF 74 4B 81 7D F4 FF FF FF 7F 74 42 83 7D F4 01 76 3C 8B 45 F4 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D D0 EB 09 8B 55 F4 83 EA 01 89 55 D0 8B 45 D0 D1 E0 50 68 FE 00 00 00 8B 4D EC 83 C1 02 51 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 14 00 74 09 C7 45 CC 02 00 00 00 EB 07 C7 45 CC 01 00 00 00 8B 55 F4 3B 55 CC 76 09 C7 45 C8 01 00 00 00 EB 07 C7 45 C8 00 00 00 00 8B 45 C8 89 45 C4 83 7D C4 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 41 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D C4 00 75 33 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 41 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 E9 3A 02 00 00 83 7D 10 02 72 0F 83 7D 10 24 77 09 C7 45 C0 01 00 00 00 EB 07 C7 45 C0 00 00 00 00 8B 55 C0 89 55 BC 83 7D BC 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 42 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D BC 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 42 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 B3 01 00 00 C7 45 F0 00 00 00 00 8B 4D EC 89 4D F8 83 7D 14 00 74 30 BA 2D 00 00 00 8B 45 F8 66 89 10 8B 4D F8 83 C1 02 89 4D F8 8B 55 F0 83 C2 01 89 55 F0 8B 45 08 F7 D8 8B 4D 0C 83 D1 00 F7 D9 89 45 08 89 4D 0C 8B 55 F8 89 55 E8 8B 45 10 33 C9 51 50 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 89 45 E4 8B 4D 10 33 D2 52 51 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 89 45 08 89 55 0C 83 7D E4 09 76 17 8B 55 E4 83 C2 57 8B 45 F8 66 89 10 8B 4D F8 83 C1 02 89 4D F8 EB 15 8B 55 E4 83 C2 30 8B 45 F8 66 89 10 8B 4D F8 83 C1 02 89 4D F8 8B 55 F0 83 C2 01 89 55 F0 83 7D 0C 00 77 06 83 7D 08 00 76 08 8B 45 F0 3B 45 F4 72 80 8B 4D F0 3B 4D F4 0F 82 91 00 00 00 BA 02 00 00 00 6B C2 00 33 C9 8B 55 EC 66 89 0C 02 8B 45 F0 3B 45 F4 73 09 C7 45 B8 01 00 00 00 EB 07 C7 45 B8 00 00 00 00 8B 4D B8 89 4D B4 83 7D B4 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 66 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D B4 00 75 30 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 66 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 EB 4D 33 C0 8B 4D F8 66 89 01 8B 55 F8 83 EA 02 89 55 F8 8B 45 F8 66 8B 08 66 89 4D FC 8B 55 F8 8B 45 E8 66 8B 08 66 89 0A 8B 55 E8 66 8B 45 FC 66 89 02 8B 4D F8 83 E9 02 89 4D F8 8B 55 E8 83 C2 02 89 55 E8 8B 45 E8 3B 45 F8 72 C6 33 C0 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_57_1_0 {
	meta:
		name = "__i64tow_s"
		size = 71
		refs = "003f @x64tow_s@24"
	strings:
		$1 = { 55 8B EC 51 83 7D 18 0A 75 17 83 7D 0C 00 7F 11 7C 06 83 7D 08 00 73 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 50 8B 4D 18 51 8B 55 0C 52 8B 45 08 50 8B 55 14 8B 4D 10 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_335_1_0 {
	meta:
		name = "__i64toa_s"
		size = 71
		refs = "003f @x64toa_s@24"
	strings:
		$1 = { 55 8B EC 51 83 7D 18 0A 75 17 83 7D 0C 00 7F 11 7C 06 83 7D 08 00 73 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 50 8B 4D 18 51 8B 55 0C 52 8B 45 08 50 8B 55 14 8B 4D 10 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_2_0 {
	meta:
		name = "__itow_s"
		size = 84
		refs = "002a _xtow_s@20"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 14 0A 75 22 83 7D 08 00 7D 1C 6A 01 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 89 45 FC EB 1A 6A 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_335_2_0 {
	meta:
		name = "__itoa_s"
		size = 84
		refs = "002a _xtoa_s@20"
	strings:
		$1 = { 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 14 0A 75 22 83 7D 08 00 7D 1C 6A 01 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 89 45 FC EB 1A 6A 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_3_0 {
	meta:
		name = "__ltow_s"
		size = 61
		refs = "0035 _xtow_s@20"
	strings:
		$1 = { 55 8B EC 51 83 7D 14 0A 75 0F 83 7D 08 00 7D 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_335_3_0 {
	meta:
		name = "__ltoa_s"
		size = 61
		refs = "0035 _xtoa_s@20"
	strings:
		$1 = { 55 8B EC 51 83 7D 14 0A 75 0F 83 7D 08 00 7D 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_4_0 {
	meta:
		name = "__ui64tow_s"
		size = 30
		refs = "0018 @x64tow_s@24"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 18 50 8B 4D 0C 51 8B 55 08 52 8B 55 14 8B 4D 10 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_335_4_0 {
	meta:
		name = "__ui64toa_s"
		size = 30
		refs = "0018 @x64toa_s@24"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 18 50 8B 4D 0C 51 8B 55 08 52 8B 55 14 8B 4D 10 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_57_5_0 {
	meta:
		name = "__ultow_s"
		size = 28
		refs = "0016 _xtow_s@20"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_335_5_0 {
	meta:
		name = "__ultoa_s"
		size = 28
		refs = "0016 _xtoa_s@20"
	strings:
		$1 = { 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_57_6_0 {
	meta:
		name = "_xtow_s@20"
		size = 1014
		refs = "0029 ??_C@_1BI@ICGGMGLK@?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0037 ??_C@_1FA@LEFFAILN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAv?$AAe?$AAr?$AAt@ 003e __CrtDbgReportW 0052 __errno 0066 ??_C@_1O@NCBFODOE@?$AAx?$AAt?$AAo?$AAw?$AA_?$AAs?$AA?$AA@ 0070 __invalid_parameter 00a4 ??_C@_1CC@JNJFIMGE@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0121 ___crtDebugFillThreshold 014e _memset 0190 ??_C@_1FA@MKGGAGEI@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AA_?$AAt?$AA?$CJ?$AA?$CI?$AAi?$AAs?$AA_?$AAn?$AAe?$AAg?$AA?5?$AA?$DP@ 0211 ??_C@_1DE@PCJGDBBD@?$AA2?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAr?$AAa?$AAd?$AAi?$AAx?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA3?$AA6?$AA?$AA@ 0348 ??_C@_1CM@HABGDNLJ@?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DM?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 44 83 7D 0C 00 74 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 45 E8 89 45 E4 83 7D E4 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 66 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 66 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 6F 03 00 00 83 7D 10 00 76 09 C7 45 E0 01 00 00 00 EB 07 C7 45 E0 00 00 00 00 8B 55 E0 89 55 DC 83 7D DC 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 67 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 67 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 F4 02 00 00 33 C9 8B 55 0C 66 89 0A 83 7D 10 FF 74 4B 81 7D 10 FF FF FF 7F 74 42 83 7D 10 01 76 3C 8B 45 10 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D D8 EB 09 8B 55 10 83 EA 01 89 55 D8 8B 45 D8 D1 E0 50 68 FE 00 00 00 8B 4D 0C 83 C1 02 51 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 18 00 74 09 C7 45 D4 02 00 00 00 EB 07 C7 45 D4 01 00 00 00 8B 55 10 3B 55 D4 76 09 C7 45 D0 01 00 00 00 EB 07 C7 45 D0 00 00 00 00 8B 45 D0 89 45 CC 83 7D CC 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 69 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D CC 00 75 30 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 6A 69 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 E9 08 02 00 00 83 7D 14 02 72 0F 83 7D 14 24 77 09 C7 45 C8 01 00 00 00 EB 07 C7 45 C8 00 00 00 00 8B 55 C8 89 55 C4 83 7D C4 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 6A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D C4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 87 01 00 00 C7 45 F4 00 00 00 00 8B 4D 0C 89 4D F8 83 7D 18 00 74 25 BA 2D 00 00 00 8B 45 F8 66 89 10 8B 4D F8 83 C1 02 89 4D F8 8B 55 F4 83 C2 01 89 55 F4 8B 45 08 F7 D8 89 45 08 8B 4D F8 89 4D F0 8B 45 08 33 D2 F7 75 14 89 55 EC 8B 45 08 33 D2 F7 75 14 89 45 08 83 7D EC 09 76 17 8B 55 EC 83 C2 57 8B 45 F8 66 89 10 8B 4D F8 83 C1 02 89 4D F8 EB 15 8B 55 EC 83 C2 30 8B 45 F8 66 89 10 8B 4D F8 83 C1 02 89 4D F8 8B 55 F4 83 C2 01 89 55 F4 83 7D 08 00 76 08 8B 45 F4 3B 45 10 72 A1 8B 4D F4 3B 4D 10 0F 82 91 00 00 00 BA 02 00 00 00 6B C2 00 33 C9 8B 55 0C 66 89 0C 02 8B 45 F4 3B 45 10 73 09 C7 45 C0 01 00 00 00 EB 07 C7 45 C0 00 00 00 00 8B 4D C0 89 4D BC 83 7D BC 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 8E 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D BC 00 75 30 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 8E 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 EB 4D 33 C0 8B 4D F8 66 89 01 8B 55 F8 83 EA 02 89 55 F8 8B 45 F8 66 8B 08 66 89 4D FC 8B 55 F8 8B 45 F0 66 8B 08 66 89 0A 8B 55 F0 66 8B 45 FC 66 89 02 8B 4D F8 83 E9 02 89 4D F8 8B 55 F0 83 C2 02 89 55 F0 8B 45 F0 3B 45 F8 72 C6 33 C0 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "_atanh"
		size = 245
		refs = "000b __dtest 0057 __real@3ff0000000000000 0065 __fperrraise 006e __Nan_C 0096 __Inf_C 00b3 __real@4000000000000000 00c8 _log1p 00d1 __real@3fe0000000000000"
	strings:
		$1 = { 55 8B EC 83 EC 20 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D F8 83 7D F8 00 74 08 83 7D F8 02 74 02 EB 08 DD 45 08 E9 C3 00 00 00 D9 EE DC 5D 08 DF E0 F6 C4 41 75 11 C7 45 FC 01 00 00 00 DD 45 08 D9 E0 DD 5D 08 EB 07 C7 45 FC 00 00 00 00 DD 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 14 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? EB 7D EB 7B DD 45 08 D9 E8 DA E9 DF E0 F6 C4 44 7A 2D 6A 04 E8 ?? ?? ?? ?? 83 C4 04 83 7D FC 00 74 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D F0 EB 09 DD 05 ?? ?? ?? ?? DD 5D F0 DD 45 F0 EB 42 EB 40 DD 05 ?? ?? ?? ?? DC 4D 08 D9 E8 DC 65 08 DE F9 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 0D ?? ?? ?? ?? DD 5D E8 83 7D FC 00 74 0A DD 45 E8 D9 E0 DD 5D E0 EB 06 DD 45 E8 DD 5D E0 DD 45 E0 8B E5 5D C3 }
	condition:
		$1
}

rule file_1113_0_0 {
	meta:
		name = "_atanhl"
		size = 245
		refs = "000b __ldtest 0057 __real@3ff0000000000000 0065 __fperrraise 006e __LNan_C 0096 __LInf_C 00b3 __real@4000000000000000 00c8 _log1pl 00d1 __real@3fe0000000000000"
	strings:
		$1 = { 55 8B EC 83 EC 20 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D F8 83 7D F8 00 74 08 83 7D F8 02 74 02 EB 08 DD 45 08 E9 C3 00 00 00 D9 EE DC 5D 08 DF E0 F6 C4 41 75 11 C7 45 FC 01 00 00 00 DD 45 08 D9 E0 DD 5D 08 EB 07 C7 45 FC 00 00 00 00 DD 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 14 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? EB 7D EB 7B DD 45 08 D9 E8 DA E9 DF E0 F6 C4 44 7A 2D 6A 04 E8 ?? ?? ?? ?? 83 C4 04 83 7D FC 00 74 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D F0 EB 09 DD 05 ?? ?? ?? ?? DD 5D F0 DD 45 F0 EB 42 EB 40 DD 05 ?? ?? ?? ?? DC 4D 08 D9 E8 DC 65 08 DE F9 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 0D ?? ?? ?? ?? DD 5D E8 83 7D FC 00 74 0A DD 45 E8 D9 E0 DD 5D E0 EB 06 DD 45 E8 DD 5D E0 DD 45 E0 8B E5 5D C3 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "_nearbyintf"
		size = 60
		refs = "0009 __fdtest 0031 __fdrint"
	strings:
		$1 = { 55 8B EC 51 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D FC 83 7D FC 00 7C 0D 83 7D FC 02 7E 02 EB 05 D9 45 08 EB 0F 51 D9 45 08 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "___avx_tanh4"
		size = 720
		refs = "0018 ___common_dtanh_data 02c3 ___common_dtanh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 56 57 81 EC 38 01 00 00 C5 FD 11 44 24 20 C5 F8 10 25 ?? ?? ?? ?? C5 F8 10 1D ?? ?? ?? ?? C5 FD 54 0D ?? ?? ?? ?? C5 FD 54 15 ?? ?? ?? ?? C5 FD 11 14 24 C4 E3 7D 19 C5 01 C5 F8 C6 FD DD C5 C1 DB 2D ?? ?? ?? ?? C5 D1 66 35 ?? ?? ?? ?? C5 D9 66 E5 C5 C9 EB D4 C5 C1 EF FF C5 D1 FA 35 ?? ?? ?? ?? C5 C9 66 C7 C5 F8 50 FA C5 C9 DB E0 C5 C9 66 D3 C4 E3 59 4A DB 20 C5 C9 72 D3 0A C5 F9 7E F0 C4 E3 79 16 F2 01 C4 E3 79 16 F1 02 C4 E3 79 16 F6 03 C5 F9 10 A0 ?? ?? ?? ?? C5 F9 10 9A ?? ?? ?? ?? C5 F9 10 B0 ?? ?? ?? ?? C4 E3 5D 18 A9 ?? ?? ?? ?? 01 C4 E3 65 18 BE ?? ?? ?? ?? 01 C5 F9 10 A2 ?? ?? ?? ?? C5 D5 15 C7 C5 FD 11 44 24 40 C5 F9 10 80 ?? ?? ?? ?? C4 E3 4D 18 91 ?? ?? ?? ?? 01 C4 E3 5D 18 AE ?? ?? ?? ?? 01 C5 F9 10 B2 ?? ?? ?? ?? C5 ED 15 FD C5 ED 14 DD C5 FD 11 BC 24 80 00 00 00 C5 F9 10 B8 ?? ?? ?? ?? C5 FD 11 5C 24 60 C4 E3 4D 18 96 ?? ?? ?? ?? 01 C5 F9 10 B2 ?? ?? ?? ?? C4 E3 7D 18 99 ?? ?? ?? ?? 01 C5 E5 14 E2 C5 E5 15 EA C5 FD 11 AC 24 C0 00 00 00 C5 F9 10 80 ?? ?? ?? ?? C5 FD 11 A4 24 A0 00 00 00 C4 E3 45 18 99 ?? ?? ?? ?? 01 C4 E3 4D 18 96 ?? ?? ?? ?? 01 C5 E5 15 EA C5 FD 11 AC 24 00 01 00 00 C5 F9 10 B2 ?? ?? ?? ?? C5 F9 10 BA ?? ?? ?? ?? C5 F9 10 A8 ?? ?? ?? ?? C5 E5 14 E2 C5 FD 11 A4 24 E0 00 00 00 C4 E3 4D 18 96 ?? ?? ?? ?? 01 C4 E3 55 18 B1 ?? ?? ?? ?? 01 C4 E3 7D 18 99 ?? ?? ?? ?? 01 C5 E5 14 E2 C5 E5 15 DA C5 F9 10 80 ?? ?? ?? ?? C4 E3 45 18 AE ?? ?? ?? ?? 01 C5 CD 14 D5 C5 CD 15 ED C5 F9 10 B2 ?? ?? ?? ?? C4 E3 7D 18 81 ?? ?? ?? ?? 01 C4 E3 4D 18 B6 ?? ?? ?? ?? 01 C5 FD 14 FE C5 F5 58 F7 C5 D5 59 CE C5 F5 58 C2 C5 FD 59 CE C5 F5 58 D3 C5 ED 59 DE C5 E5 58 E4 C5 DD 59 EE C5 D5 58 BC 24 00 01 00 00 C5 C5 59 C6 C5 FD 58 8C 24 E0 00 00 00 C5 F5 59 D6 C5 ED 58 9C 24 C0 00 00 00 C5 E5 59 E6 C5 DD 58 AC 24 A0 00 00 00 C5 D5 59 FE C5 C5 58 84 24 80 00 00 00 C5 FD 59 CE C5 F5 58 54 24 60 C5 ED 59 F6 C5 CD 58 44 24 40 C5 FD 56 04 24 85 FF 75 0C 81 C4 38 01 00 00 5F 5E 8B E5 5D C3 C5 FD 10 4C 24 20 C5 FD 11 44 24 40 C5 FD 11 0C 24 74 E1 33 F6 0F A3 F7 72 18 46 83 FE 20 7C F5 C5 FD 10 44 24 40 81 C4 38 01 00 00 5F 5E 8B E5 5D C3 C5 F8 77 8D 44 F4 40 8D 14 F4 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB D2 8D 64 24 00 }
	condition:
		$1
}

rule file_61_1_0 {
	meta:
		name = "__strdup"
		size = 23
		refs = "000e __strdup_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_806_50_0 {
	meta:
		name = "__heap_alloc"
		size = 23
		refs = "000e __heap_alloc_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_449_1_0 {
	meta:
		name = "__wcsdup"
		size = 23
		refs = "000e __wcsdup_dbg"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_61_2_0 {
	meta:
		name = "__strdup_dbg"
		size = 133
		refs = "001c _strlen 003a __malloc_dbg 004f ??_C@_1FC@OHPAEKHB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?2@ 0054 ??_C@_1BI@CBNECNIC@?$AA_?$AAs?$AAt?$AAr?$AAd?$AAu?$AAp?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 0059 ??_C@_1DO@MOGEFOMO@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAm?$AAe?$AAm?$AAo?$AAr?$AAy?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?0?$AA?5?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?$CJ?$AA?$AA@ 006a _strcpy_s 0073 __invoke_watson_if_error"
	strings:
		$1 = { 55 8B EC 83 EC 08 C7 45 FC 00 00 00 00 83 7D 08 00 75 04 33 C0 EB 6A 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 89 45 FC 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 74 35 6A 00 6A 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 08 52 8B 45 FC 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 F8 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "_imaxdiv"
		size = 190
		refs = "0007 ___security_cookie 0021 __alldiv 003c __allmul 0052 ?fixneg@?1??imaxdiv@@9@9 00b6 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 E8 ?? ?? ?? ?? 89 45 EC 89 55 F0 8B 4D F0 51 8B 55 EC 52 8B 45 18 50 8B 4D 14 51 E8 ?? ?? ?? ?? 8B 4D 0C 2B C8 8B 45 10 1B C2 89 4D F4 89 45 F8 83 3D ?? ?? ?? ?? 00 7D 3A 83 7D F0 00 7F 34 7C 06 83 7D EC 00 73 2C 8B 4D F4 0B 4D F8 74 24 8B 55 EC 83 C2 01 8B 45 F0 83 D0 00 89 55 EC 89 45 F0 8B 4D F4 2B 4D 14 8B 55 F8 1B 55 18 89 4D F4 89 55 F8 8B 45 08 8B 4D EC 89 08 8B 55 F0 89 50 04 8B 4D F4 89 48 08 8B 55 F8 89 50 0C 8B 45 08 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "__commit"
		size = 574
		refs = "0006 __sehtable$__commit 000b __except_handler4 001d ___security_cookie 003e __errno 005b __nhandle 007e ??_C@_1HC@KFLBHHBC@?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAi?$AAl?$AAe?$AAd@ 0083 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 008c ??_C@_1FA@HELGICMG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAl?$AAo?$AAw?$AAi?$AAo?$AA?2?$AAc@ 0093 __CrtDbgReportW 00bb ??_C@_1BA@FLNMBBIM@?$AA_?$AAc?$AAo?$AAm?$AAm?$AAi?$AAt?$AA?$AA@ 00c5 __invalid_parameter 00e6 ___pioinfo 0111 ??_C@_1DG@LNNHNFHJ@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 016c ___lock_fhandle 019f __get_osfhandle 01a9 __imp__FlushFileBuffers@4 01b3 __imp__GetLastError@0 01cc ___doserrno 01ec ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 0221 __unlock_fhandle"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 83 7D 08 FE 75 13 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 DC 01 00 00 83 7D 08 00 7C 14 8B 45 08 3B 05 ?? ?? ?? ?? 73 09 C7 45 E0 01 00 00 00 EB 07 C7 45 E0 00 00 00 00 8B 4D E0 89 4D DC 83 7D DC 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 2C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D DC 00 75 2E E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 2C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 58 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 74 09 C7 45 D8 01 00 00 00 EB 07 C7 45 D8 00 00 00 00 8B 4D D8 89 4D D4 83 7D D4 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 2D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D4 00 75 2E E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 2D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 C5 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 04 83 E1 01 74 3B 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 E4 EB 07 C7 45 E4 00 00 00 00 83 7D E4 00 75 02 EB 43 E8 ?? ?? ?? ?? 8B 4D E4 89 08 E8 ?? ?? ?? ?? C7 00 09 00 00 00 C7 45 E4 FF FF FF FF 33 D2 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 45 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "__libm_sse2_exp_precise"
		size = 720
		refs = "003e cv 0046 Shifter 00c3 Tbl_addr 00e7 mmask 00f3 bias 0151 emask 0213 ___libm_error_support 0237 XMAX 024a XMIN 0277 INF 0283 ZERO 02b2 ONE_val 02c0 __exp_default"
	strings:
		$1 = { 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 0F 85 9E 02 00 00 D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 0F 85 89 02 00 00 66 0F 13 04 24 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F C5 C0 03 25 FF 7F 00 00 BA 8F 40 00 00 2B D0 2D 90 3C 00 00 0B D0 81 FA 00 00 00 80 0F 83 17 02 00 00 66 0F 59 C8 66 0F 58 CE 66 0F 28 F9 66 0F 5C CE 66 0F 59 D1 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F 7E F8 8B C8 83 E1 3F C1 E1 04 C1 F8 06 8B D0 66 0F 5C C3 66 0F 28 91 ?? ?? ?? ?? 66 0F 59 E0 66 0F 28 C8 66 0F 59 C0 66 0F 58 EC F2 0F 59 C0 F2 0F 58 CA 66 0F 15 D2 66 0F 6F 35 ?? ?? ?? ?? 66 0F DB FE 66 0F 6F 35 ?? ?? ?? ?? 66 0F D4 FE 66 0F 73 F7 2E 66 0F 59 C5 F2 0F 58 C8 66 0F 56 D7 66 0F 15 C0 F2 0F 58 C1 81 C2 7E 03 00 00 81 FA 7C 07 00 00 77 0C F2 0F 59 C2 F2 0F 58 C2 83 C4 08 C3 83 EC 12 9B D9 7C 24 10 66 8B 54 24 10 66 81 CA 00 03 66 89 14 24 D9 2C 24 8B D0 D1 F8 2B D0 66 0F 6F 35 ?? ?? ?? ?? 66 0F DF F2 05 FF 03 00 00 66 0F 6E D8 66 0F 73 F3 34 66 0F 56 F3 81 C2 FF 03 00 00 66 0F 6E E2 66 0F 73 F4 34 66 0F 13 04 24 DD 04 24 66 0F 13 74 24 08 DD 44 24 08 DC C9 DE C1 66 0F 13 24 24 DD 04 24 DE C9 DD 1C 24 66 0F 12 04 24 D9 6C 24 10 83 C4 12 66 0F C5 C8 03 81 E1 F0 7F 00 00 81 F9 F0 7F 00 00 73 2A 83 F9 00 74 2C 83 C4 08 C3 81 F9 00 00 00 80 72 19 81 F9 2B 23 86 C0 77 18 72 0B 8B 14 24 81 FA EF 39 FA FE 73 0B 83 C4 08 C3 BA 0E 00 00 00 EB 05 BA 0F 00 00 00 83 EC 18 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 08 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 66 0F 12 44 24 10 83 C4 20 C3 3D 00 00 F0 7F 73 31 8B 44 24 04 3D 00 00 00 80 73 13 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C0 BA 0E 00 00 00 EB AC 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C0 BA 0F 00 00 00 EB 99 8B 14 24 3D 00 00 F0 7F 77 28 83 FA 00 75 23 8B 44 24 04 3D 00 00 F0 7F 75 0C 66 0F 12 05 ?? ?? ?? ?? 83 C4 08 C3 66 0F 12 05 ?? ?? ?? ?? 83 C4 08 C3 BA EA 03 00 00 E9 5D FF FF FF 8B 44 24 04 25 FF FF FF 7F 3D 00 00 90 40 0F 83 78 FF FF FF 66 0F 12 04 24 F2 0F 58 05 ?? ?? ?? ?? 83 C4 08 C3 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 83 C4 08 C3 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "__CIacos_pentium4"
		size = 1364
		refs = "0022 ABSVALMASK 002a ONEMASK 0036 TMASK 0094 T_table 00a1 Tbl_addr 00cd cv 0113 PI_BY_2 01dc NEG_PI 0299 cv2 033f ONE_BY_2 0386 HALFMASK 04bf ___libm_error_support 04f4 PI"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 66 0F 12 25 ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 ED 66 0F 12 15 ?? ?? ?? ?? F2 0F 10 C8 66 0F 73 D0 2C 66 0F 7E C2 F2 0F 10 F9 B9 00 20 00 00 66 0F C4 E9 02 F2 0F 10 C1 B8 FF FF 07 00 23 C2 2D 00 FB 03 00 3D BB 03 00 00 0F 83 D6 00 00 00 F2 0F 59 C9 81 E2 FF FF 00 00 F2 0F 5C D9 F2 0F 51 DB 66 0F 54 D7 83 E2 FC 81 EA 00 FB 00 00 66 0F 12 0C 55 ?? ?? ?? ?? 66 0F 56 D5 66 0F 28 24 95 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 58 FA F2 0F 5C C2 F2 0F 59 F8 F2 0F 59 F1 F2 0F 59 DA F2 0F 10 CE F2 0F 58 F3 F2 0F 5E FE 66 0F 12 05 ?? ?? ?? ?? 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C CB 66 0F 73 D2 3F F2 0F 10 D9 66 0F 73 F2 3F F2 0F 59 C9 66 0F 70 D2 44 66 0F 12 35 ?? ?? ?? ?? F2 0F 59 D9 F2 0F 59 C1 83 EC 10 66 0F 57 E2 F2 0F 59 EB 66 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D9 F2 0F 58 C6 F2 0F 59 C3 F2 0F 5C EC 66 0F 70 E4 EE F2 0F 58 C5 F2 0F 5C C7 F2 0F 5C C4 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 2D BB 03 00 00 83 F8 41 0F 83 2D 01 00 00 66 0F 73 D7 26 66 0F 73 F7 26 66 0F D7 C0 66 0F 55 E0 F2 0F 5C CF F2 0F 10 F7 F2 0F 59 FF F2 0F 58 C6 66 0F 56 EC F2 0F 5C DF F2 0F 59 C1 F2 0F 10 E3 F2 0F 5C D8 F2 0F 51 DB 25 80 00 00 00 C1 E8 07 F7 D8 F2 0F 10 FB 66 0F 54 D3 66 0F 73 F3 02 66 0F C5 D3 03 66 0F 56 D5 66 0F 6E D8 66 0F 70 DB 00 81 EA C0 FE 00 00 03 D2 F2 0F 59 3C 95 ?? ?? ?? ?? F2 0F 59 F2 F2 0F 59 CA F2 0F 59 D2 F2 0F 5C F7 66 0F 54 1D ?? ?? ?? ?? F2 0F 58 F1 F2 0F 5C E2 F2 0F 58 FF 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C E0 F2 0F 58 FE 66 0F 12 05 ?? ?? ?? ?? F2 0F 5E E7 66 0F 12 15 ?? ?? ?? ?? 66 0F 58 1C D5 ?? ?? ?? ?? F2 0F 10 CE F2 0F 59 F6 F2 0F 59 C6 F2 0F 59 CE 83 EC 10 F2 0F 59 E9 F2 0F 59 CE F2 0F 58 C2 66 0F EF F6 F2 0F 59 C1 F2 0F 58 EB F2 0F 58 C5 25 00 80 00 00 66 0F C4 F0 03 F2 0F 10 EC 66 0F 70 DB EE F2 0F 58 E3 F2 0F 5C DC F2 0F 58 EB F2 0F 58 C5 F2 0F 58 C4 66 0F 57 C6 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 05 BB 3B 00 00 3D 00 38 00 00 0F 83 90 00 00 00 66 0F 14 C0 66 0F 28 35 ?? ?? ?? ?? 66 0F 14 C8 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 C0 66 0F 28 2D ?? ?? ?? ?? 83 EC 10 66 0F 59 C8 66 0F 59 F0 66 0F 59 C0 F2 0F 10 D9 F2 0F 59 C9 66 0F 58 F2 66 0F 59 E0 F2 0F 59 CB 66 0F 58 F4 66 0F 70 C5 EE 66 0F 59 CE 66 0F 70 F5 EE F2 0F 5C C7 66 0F 70 D1 EE F2 0F 5C E9 F2 0F 5C F0 F2 0F 5C EA F2 0F 5C FE F2 0F 5C EF F2 0F 58 C5 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 2D FC 3B 00 00 83 F8 04 0F 83 F4 00 00 00 66 0F 57 F6 66 0F 54 3D ?? ?? ?? ?? 66 0F 12 25 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? F2 0F 59 FC 66 0F 28 15 ?? ?? ?? ?? F2 0F 5C E7 66 0F 28 1D ?? ?? ?? ?? 66 0F 70 FC 44 F2 0F 51 E4 66 0F 59 CF 66 0F 70 EF 44 66 0F C5 C0 03 66 0F 59 FF 66 0F 58 D1 66 0F 12 0D ?? ?? ?? ?? 66 0F 59 DF F2 0F C2 C6 01 F2 0F 59 FD 66 0F 58 D3 66 0F 70 C0 44 F2 0F 59 D7 66 0F 54 05 ?? ?? ?? ?? 66 0F 59 D5 66 0F 54 CC 66 0F 70 DC 44 F2 0F 5C E1 F2 0F 58 DB F2 0F 59 C9 F2 0F 5C DC F2 0F 5C E9 F2 0F 59 E3 66 0F 70 DB EE F2 0F 5C EC F2 0F 5E EB 83 EC 10 66 0F 58 DB 66 0F 59 D3 66 0F 70 E2 EE F2 0F 58 D0 25 00 80 00 00 66 0F C4 F0 03 66 0F 70 C0 EE F2 0F 58 D4 F2 0F 58 D5 F2 0F 58 D3 F2 0F 58 C2 66 0F 57 C6 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 05 FC FE 03 00 3D 00 FF 03 00 0F 82 EA 00 00 00 66 0F 7E F9 66 0F 73 D7 20 66 0F 7E FA 81 E2 FF FF FF 7F B8 00 00 F0 3F 2B C2 0B C1 83 F8 00 0F 84 85 00 00 00 66 0F 12 54 24 04 66 0F 7E D2 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF FF 7F 83 EA 01 81 D9 00 00 F0 7F 83 F9 00 0F 8D BF 00 00 00 66 0F 57 C9 66 0F 57 C0 BA F0 7F 00 00 66 0F C4 CA 03 F2 0F 59 C1 BA 3A 00 00 00 83 EC 1C 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 10 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 66 0F 12 44 24 10 83 C4 1C 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F C5 D7 01 C1 EA 0F F7 DA 66 0F 6E FA 66 0F 70 FF 00 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? 66 0F 54 D7 66 0F 54 C7 F2 0F 58 C2 83 EC 10 66