private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule function_0_0 {
	meta:
		name = "CoFormatCondition.Create"
		size = 100
		refs = "000c CoFormatCondition.Create 001a CLASS_FormatCondition 001f CreateComObject 002e @IntfCast 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 2C 99 7A E2 30 A3 D0 11 81 DD 00 C0 4F C2 F5 1B }
	condition:
		$1
}

rule function_1_0 {
	meta:
		name = "CoFormatCondition.CreateRemote"
		size = 128
		refs = "0011 CoFormatCondition.CreateRemote 0021 @WStrFromUStr 002c CLASS_FormatCondition 0031 CreateRemoteComObject 0040 @IntfCast 0055 @WStrClr 005d @IntfClear 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F1 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 45 F8 8D 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 2C 99 7A E2 30 A3 D0 11 81 DD 00 C0 4F C2 F5 1B }
	condition:
		$1
}

rule function_2_0 {
	meta:
		name = "TAccessControl.InitControlData"
		size = 12
		refs = "0001 CControlData"
		altNames = "TAccessField.InitControlData TAccessGroupLevel.InitControlData TAccessImage.InitControlData TAccessLabel.InitControlData TAccessLine.InitControlData TAccessPage.InitControlData TAccessPageBreak.InitControlData TAccessRectangle.InitControlData TAccessSection.InitControlData T_ChildLabel.InitControlData T_ControlInReportEvents.InitControlData T_CustomControlInReport.InitControlData T_DocSiteControl.InitControlData T_RecipientControl.InitControlData"
	strings:
		$1 = { BA ?? ?? ?? ?? 89 90 88 02 00 00 C3 }
	condition:
		$1
}

rule function_3_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 08 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 C1 EA C1 B1 6F 48 CE 11 A6 5D 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_4_0 {
	meta:
		name = "TAccessControl.CreateControl"
		size = 29
		refs = "0015 DoCreate"
		altNames = "TAccessField.CreateControl TAccessGroupLevel.CreateControl TAccessImage.CreateControl TAccessLabel.CreateControl TAccessLine.CreateControl TAccessPage.CreateControl TAccessPageBreak.CreateControl TAccessRectangle.CreateControl TAccessSection.CreateControl T_ChildLabel.CreateControl T_ControlInReportEvents.CreateControl T_CustomControlInReport.CreateControl T_DocSiteControl.CreateControl T_RecipientControl.CreateControl"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC 83 B8 08 03 00 00 00 75 07 55 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_5_0 {
	meta:
		name = "TAccessField.GetControlInterface"
		size = 29
		refs = "0009 TAccessField.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 08 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_13_0 {
	meta:
		name = "TAccessControl.GetControlInterface"
		size = 29
		refs = "0009 TAccessControl.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 08 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_980_0 {
	meta:
		name = "TAccessGroupLevel.GetControlInterface"
		size = 29
		refs = "0009 TAccessGroupLevel.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 08 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_153_0 {
	meta:
		name = "TAccessImage.GetControlInterface"
		size = 29
		refs = "0009 TAccessImage.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 08 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_67_0 {
	meta:
		name = "TAccessLabel.GetControlInterface"
		size = 29
		refs = "0009 TAccessLabel.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 08 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_144_0 {
	meta:
		name = "TAccessLine.GetControlInterface"
		size = 29
		refs = "0009 TAccessLine.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 08 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_933_0 {
	meta:
		name = "TAccessPage.GetControlInterface"
		size = 29
		refs = "0009 TAccessPage.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 08 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_642_0 {
	meta:
		name = "TAccessPageBreak.GetControlInterface"
		size = 29
		refs = "0009 TAccessPageBreak.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 08 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_135_0 {
	meta:
		name = "TAccessRectangle.GetControlInterface"
		size = 29
		refs = "0009 TAccessRectangle.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 08 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_972_0 {
	meta:
		name = "TAccessSection.GetControlInterface"
		size = 29
		refs = "0009 TAccessSection.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 08 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_101_0 {
	meta:
		name = "T_ChildLabel.GetControlInterface"
		size = 29
		refs = "0009 T_ChildLabel.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 08 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_40_0 {
	meta:
		name = "T_ControlInReportEvents.GetControlInterface"
		size = 29
		refs = "0009 T_ControlInReportEvents.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 08 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_850_0 {
	meta:
		name = "T_CustomControlInReport.GetControlInterface"
		size = 29
		refs = "0009 T_CustomControlInReport.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 08 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_77178_0 {
	meta:
		name = "T_DocSiteControl.GetControlInterface"
		size = 29
		refs = "0009 T_DocSiteControl.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 08 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_77172_0 {
	meta:
		name = "T_RecipientControl.GetControlInterface"
		size = 29
		refs = "0009 T_RecipientControl.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 08 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_6_0 {
	meta:
		name = "TAccessField.Get_Value"
		size = 91
		refs = "000f TAccessField.Get_Value 001c @VarClr 0027 TAccessField.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1573_0 {
	meta:
		name = "TAccessApplication.Get_Application"
		size = 91
		refs = "000f TAccessApplication.Get_Application 001c @IntfClear 0027 TAccessApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_419_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accParent"
		size = 91
		refs = "000f TAccessBoundObjectFrame.Get_accParent 001c @IntfClear 0027 TAccessBoundObjectFrame.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_296_0 {
	meta:
		name = "TAccessCheckBox.Get_accParent"
		size = 91
		refs = "000f TAccessCheckBox.Get_accParent 001c @IntfClear 0027 TAccessCheckBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_553_0 {
	meta:
		name = "TAccessComboBox.Get_accParent"
		size = 91
		refs = "000f TAccessComboBox.Get_accParent 001c @IntfClear 0027 TAccessComboBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_173_0 {
	meta:
		name = "TAccessCommandButton.Get_accParent"
		size = 91
		refs = "000f TAccessCommandButton.Get_accParent 001c @IntfClear 0027 TAccessCommandButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_14_0 {
	meta:
		name = "TAccessControl.Get_Application"
		size = 91
		refs = "000f TAccessControl.Get_Application 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_805_0 {
	meta:
		name = "TAccessCustomControl.Get_accParent"
		size = 91
		refs = "000f TAccessCustomControl.Get_accParent 001c @IntfClear 0027 TAccessCustomControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1010_0 {
	meta:
		name = "TAccessForm.Get_accParent"
		size = 91
		refs = "000f TAccessForm.Get_accParent 001c @IntfClear 0027 TAccessForm.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_981_0 {
	meta:
		name = "TAccessGroupLevel.Get_Application"
		size = 91
		refs = "000f TAccessGroupLevel.Get_Application 001c @IntfClear 0027 TAccessGroupLevel.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_154_0 {
	meta:
		name = "TAccessImage.Get_Application"
		size = 91
		refs = "000f TAccessImage.Get_Application 001c @IntfClear 0027 TAccessImage.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_68_0 {
	meta:
		name = "TAccessLabel.Get_accParent"
		size = 91
		refs = "000f TAccessLabel.Get_accParent 001c @IntfClear 0027 TAccessLabel.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_145_0 {
	meta:
		name = "TAccessLine.Get_Application"
		size = 91
		refs = "000f TAccessLine.Get_Application 001c @IntfClear 0027 TAccessLine.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_506_0 {
	meta:
		name = "TAccessListBox.Get_accParent"
		size = 91
		refs = "000f TAccessListBox.Get_accParent 001c @IntfClear 0027 TAccessListBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_599_0 {
	meta:
		name = "TAccessObjectFrame.Get_accParent"
		size = 91
		refs = "000f TAccessObjectFrame.Get_accParent 001c @IntfClear 0027 TAccessObjectFrame.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_216_0 {
	meta:
		name = "TAccessOptionButton.Get_accParent"
		size = 91
		refs = "000f TAccessOptionButton.Get_accParent 001c @IntfClear 0027 TAccessOptionButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_378_0 {
	meta:
		name = "TAccessOptionGroup.Get_accParent"
		size = 91
		refs = "000f TAccessOptionGroup.Get_accParent 001c @IntfClear 0027 TAccessOptionGroup.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_934_0 {
	meta:
		name = "TAccessPage.Get_accParent"
		size = 91
		refs = "000f TAccessPage.Get_accParent 001c @IntfClear 0027 TAccessPage.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_643_0 {
	meta:
		name = "TAccessPageBreak.Get_Application"
		size = 91
		refs = "000f TAccessPageBreak.Get_Application 001c @IntfClear 0027 TAccessPageBreak.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_742_0 {
	meta:
		name = "TAccessPaletteButton.Get_Application"
		size = 91
		refs = "000f TAccessPaletteButton.Get_Application 001c @IntfClear 0027 TAccessPaletteButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_136_0 {
	meta:
		name = "TAccessRectangle.Get_Application"
		size = 91
		refs = "000f TAccessRectangle.Get_Application 001c @IntfClear 0027 TAccessRectangle.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2140_0 {
	meta:
		name = "TAccessReferences.Get_Parent"
		size = 91
		refs = "000f TAccessReferences.Get_Parent 001c @IntfClear 0027 TAccessReferences.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1364_0 {
	meta:
		name = "TAccessReport.Get_FormName"
		size = 91
		refs = "000f TAccessReport.Get_FormName 001c @WStrClr 0027 TAccessReport.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_973_0 {
	meta:
		name = "TAccessSection.Get_Application"
		size = 91
		refs = "000f TAccessSection.Get_Application 001c @IntfClear 0027 TAccessSection.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_758_0 {
	meta:
		name = "TAccessSubForm.Get_accParent"
		size = 91
		refs = "000f TAccessSubForm.Get_accParent 001c @IntfClear 0027 TAccessSubForm.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_797_0 {
	meta:
		name = "TAccessSubReport.Get_Application"
		size = 91
		refs = "000f TAccessSubReport.Get_Application 001c @IntfClear 0027 TAccessSubReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_897_0 {
	meta:
		name = "TAccessTabControl.Get_accParent"
		size = 91
		refs = "000f TAccessTabControl.Get_accParent 001c @IntfClear 0027 TAccessTabControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_463_0 {
	meta:
		name = "TAccessTextBox.Get_accParent"
		size = 91
		refs = "000f TAccessTextBox.Get_accParent 001c @IntfClear 0027 TAccessTextBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_652_0 {
	meta:
		name = "TAccessToggleButton.Get_accParent"
		size = 91
		refs = "000f TAccessToggleButton.Get_accParent 001c @IntfClear 0027 TAccessToggleButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2203_0 {
	meta:
		name = "TAdditionalData.Get_Name"
		size = 91
		refs = "000f TAdditionalData.Get_Name 001c @WStrClr 0027 TAdditionalData.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4852_0 {
	meta:
		name = "TBinder.Get_Name"
		size = 91
		refs = "000f TBinder.Get_Name 001c @WStrClr 0027 TBinder.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76040_0 {
	meta:
		name = "TContactItem.Get_Application"
		size = 91
		refs = "000f TContactItem.Get_Application 001c @IntfClear 0027 TContactItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75812_0 {
	meta:
		name = "TCustomTaskPane.Get_Title"
		size = 91
		refs = "000f TCustomTaskPane.Get_Title 001c @WStrClr 0027 TCustomTaskPane.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2244_0 {
	meta:
		name = "TDependencyInfo.Get_Parent"
		size = 91
		refs = "000f TDependencyInfo.Get_Parent 001c @IntfClear 0027 TDependencyInfo.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2230_0 {
	meta:
		name = "TDependencyObjects.Get_Application"
		size = 91
		refs = "000f TDependencyObjects.Get_Application 001c @IntfClear 0027 TDependencyObjects.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76317_0 {
	meta:
		name = "TDistListItem.Get_Application"
		size = 91
		refs = "000f TDistListItem.Get_Application 001c @IntfClear 0027 TDistListItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76390_0 {
	meta:
		name = "TDocumentItem.Get_Application"
		size = 91
		refs = "000f TDocumentItem.Get_Application 001c @IntfClear 0027 TDocumentItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_53452_0 {
	meta:
		name = "TExcelApplication.Get_Application"
		size = 91
		refs = "000f TExcelApplication.Get_Application 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_54234_0 {
	meta:
		name = "TExcelChart.Get_Application"
		size = 91
		refs = "000f TExcelChart.Get_Application 001c @IntfClear 0027 TExcelChart.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52779_0 {
	meta:
		name = "TExcelGlobal.Get_Application"
		size = 91
		refs = "000f TExcelGlobal.Get_Application 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52971_0 {
	meta:
		name = "TExcelWorkbook.Get_Application"
		size = 91
		refs = "000f TExcelWorkbook.Get_Application 001c @IntfClear 0027 TExcelWorkbook.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_56617_0 {
	meta:
		name = "TExcelWorksheet.Get_Application"
		size = 91
		refs = "000f TExcelWorksheet.Get_Application 001c @IntfClear 0027 TExcelWorksheet.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76452_0 {
	meta:
		name = "TExplorers.Get_Application"
		size = 91
		refs = "000f TExplorers.Get_Application 001c @IntfClear 0027 TExplorers.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76486_0 {
	meta:
		name = "TFolders.Get_Application"
		size = 91
		refs = "000f TFolders.Get_Application 001c @IntfClear 0027 TFolders.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2442_0 {
	meta:
		name = "TFormOld.Get_accParent"
		size = 91
		refs = "000f TFormOld.Get_accParent 001c @IntfClear 0027 TFormOld.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76469_0 {
	meta:
		name = "TInspectors.Get_Application"
		size = 91
		refs = "000f TInspectors.Get_Application 001c @IntfClear 0027 TInspectors.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76510_0 {
	meta:
		name = "TItems.Get_Application"
		size = 91
		refs = "000f TItems.Get_Application 001c @IntfClear 0027 TItems.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76543_0 {
	meta:
		name = "TJournalItem.Get_Application"
		size = 91
		refs = "000f TJournalItem.Get_Application 001c @IntfClear 0027 TJournalItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2355_0 {
	meta:
		name = "TMacroError.Get_Condition"
		size = 91
		refs = "000f TMacroError.Get_Condition 001c @WStrClr 0027 TMacroError.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75871_0 {
	meta:
		name = "TMailItem.Get_Application"
		size = 91
		refs = "000f TMailItem.Get_Application 001c @IntfClear 0027 TMailItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75708_0 {
	meta:
		name = "TMaster.Get_Application"
		size = 91
		refs = "000f TMaster.Get_Application 001c @IntfClear 0027 TMaster.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76629_0 {
	meta:
		name = "TNameSpace.Get_Application"
		size = 91
		refs = "000f TNameSpace.Get_Application 001c @IntfClear 0027 TNameSpace.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76006_0 {
	meta:
		name = "TOutlookApplication.Get_Application"
		size = 91
		refs = "000f TOutlookApplication.Get_Application 001c @IntfClear 0027 TOutlookApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76668_0 {
	meta:
		name = "TOutlookBarGroups.Get_Application"
		size = 91
		refs = "000f TOutlookBarGroups.Get_Application 001c @IntfClear 0027 TOutlookBarGroups.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76687_0 {
	meta:
		name = "TOutlookBarPane.Get_Application"
		size = 91
		refs = "000f TOutlookBarPane.Get_Application 001c @IntfClear 0027 TOutlookBarPane.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76707_0 {
	meta:
		name = "TOutlookBarShortcuts.Get_Application"
		size = 91
		refs = "000f TOutlookBarShortcuts.Get_Application 001c @IntfClear 0027 TOutlookBarShortcuts.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_32877_0 {
	meta:
		name = "TParameter.GetProperties"
		size = 91
		refs = "000f TParameter.GetProperties 001c @IntfClear 0027 TParameter.GetParameter 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76726_0 {
	meta:
		name = "TPostItem.Get_Application"
		size = 91
		refs = "000f TPostItem.Get_Application 001c @IntfClear 0027 TPostItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75646_0 {
	meta:
		name = "TPowerPointApplication.Get_Presentations"
		size = 91
		refs = "000f TPowerPointApplication.Get_Presentations 001c @IntfClear 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75544_0 {
	meta:
		name = "TPowerPointPresentation.Get_Application"
		size = 91
		refs = "000f TPowerPointPresentation.Get_Application 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75503_0 {
	meta:
		name = "TPowerPointSlide.Get_Application"
		size = 91
		refs = "000f TPowerPointSlide.Get_Application 001c @IntfClear 0027 TPowerPointSlide.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76799_0 {
	meta:
		name = "TRemoteItem.Get_Application"
		size = 91
		refs = "000f TRemoteItem.Get_Application 001c @IntfClear 0027 TRemoteItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76865_0 {
	meta:
		name = "TReportItem.Get_Application"
		size = 91
		refs = "000f TReportItem.Get_Application 001c @IntfClear 0027 TReportItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2796_0 {
	meta:
		name = "TReportOld.Get_FormName"
		size = 91
		refs = "000f TReportOld.Get_FormName 001c @WStrClr 0027 TReportOld.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2407_0 {
	meta:
		name = "TReturnVar.Get__Value"
		size = 91
		refs = "000f TReturnVar.Get__Value 001c @VarClr 0027 TReturnVar.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2420_0 {
	meta:
		name = "TReturnVars.Get_Application"
		size = 91
		refs = "000f TReturnVars.Get_Application 001c @IntfClear 0027 TReturnVars.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2333_0 {
	meta:
		name = "TSmartTag.Get_Application"
		size = 91
		refs = "000f TSmartTag.Get_Application 001c @IntfClear 0027 TSmartTag.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2275_0 {
	meta:
		name = "TSmartTagAction.Get_Application"
		size = 91
		refs = "000f TSmartTagAction.Get_Application 001c @IntfClear 0027 TSmartTagAction.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2289_0 {
	meta:
		name = "TSmartTagActions.Get_Application"
		size = 91
		refs = "000f TSmartTagActions.Get_Application 001c @IntfClear 0027 TSmartTagActions.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2318_0 {
	meta:
		name = "TSmartTagProperties.Get_Application"
		size = 91
		refs = "000f TSmartTagProperties.Get_Application 001c @IntfClear 0027 TSmartTagProperties.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2303_0 {
	meta:
		name = "TSmartTagProperty.Get_Name"
		size = 91
		refs = "000f TSmartTagProperty.Get_Name 001c @WStrClr 0027 TSmartTagProperty.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2260_0 {
	meta:
		name = "TSmartTags.Get_Application"
		size = 91
		refs = "000f TSmartTags.Get_Application 001c @IntfClear 0027 TSmartTags.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75850_0 {
	meta:
		name = "TSyncObject.Get_Application"
		size = 91
		refs = "000f TSyncObject.Get_Application 001c @IntfClear 0027 TSyncObject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76927_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_Application"
		size = 91
		refs = "000f TTaskRequestAcceptItem.Get_Application 001c @IntfClear 0027 TTaskRequestAcceptItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76990_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_Application"
		size = 91
		refs = "000f TTaskRequestDeclineItem.Get_Application 001c @IntfClear 0027 TTaskRequestDeclineItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77053_0 {
	meta:
		name = "TTaskRequestItem.Get_Application"
		size = 91
		refs = "000f TTaskRequestItem.Get_Application 001c @IntfClear 0027 TTaskRequestItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77116_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_Application"
		size = 91
		refs = "000f TTaskRequestUpdateItem.Get_Application 001c @IntfClear 0027 TTaskRequestUpdateItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2371_0 {
	meta:
		name = "TTempVar.Get__Value"
		size = 91
		refs = "000f TTempVar.Get__Value 001c @VarClr 0027 TTempVar.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2386_0 {
	meta:
		name = "TTempVars.Get_Application"
		size = 91
		refs = "000f TTempVars.Get_Application 001c @IntfClear 0027 TTempVars.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149193_0 {
	meta:
		name = "TWordApplication.Get_Application"
		size = 91
		refs = "000f TWordApplication.Get_Application 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148553_0 {
	meta:
		name = "TWordDocument.Get_Name"
		size = 91
		refs = "000f TWordDocument.Get_Name 001c @WStrClr 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_151261_0 {
	meta:
		name = "TWordFont.Get_Application"
		size = 91
		refs = "000f TWordFont.Get_Application 001c @IntfClear 0027 TWordFont.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_151474_0 {
	meta:
		name = "TWordLetterContent.Get_Application"
		size = 91
		refs = "000f TWordLetterContent.Get_Application 001c @IntfClear 0027 TWordLetterContent.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_151351_0 {
	meta:
		name = "TWordParagraphFormat.Get_Application"
		size = 91
		refs = "000f TWordParagraphFormat.Get_Application 001c @IntfClear 0027 TWordParagraphFormat.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_337_0 {
	meta:
		name = "T_CheckBoxInOption.Get_accParent"
		size = 91
		refs = "000f T_CheckBoxInOption.Get_accParent 001c @IntfClear 0027 T_CheckBoxInOption.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_102_0 {
	meta:
		name = "T_ChildLabel.Get_accParent"
		size = 91
		refs = "000f T_ChildLabel.Get_accParent 001c @IntfClear 0027 T_ChildLabel.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_41_0 {
	meta:
		name = "T_ControlInReportEvents.Get_Application"
		size = 91
		refs = "000f T_ControlInReportEvents.Get_Application 001c @IntfClear 0027 T_ControlInReportEvents.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_851_0 {
	meta:
		name = "T_CustomControlInReport.Get_accParent"
		size = 91
		refs = "000f T_CustomControlInReport.Get_accParent 001c @IntfClear 0027 T_CustomControlInReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_256_0 {
	meta:
		name = "T_OptionButtonInOption.Get_accParent"
		size = 91
		refs = "000f T_OptionButtonInOption.Get_accParent 001c @IntfClear 0027 T_OptionButtonInOption.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_996_0 {
	meta:
		name = "T_PageHdrFtrInReport.Get_Application"
		size = 91
		refs = "000f T_PageHdrFtrInReport.Get_Application 001c @IntfClear 0027 T_PageHdrFtrInReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_988_0 {
	meta:
		name = "T_SectionInReport.Get_Application"
		size = 91
		refs = "000f T_SectionInReport.Get_Application 001c @IntfClear 0027 T_SectionInReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_697_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_accParent"
		size = 91
		refs = "000f T_ToggleButtonInOption.Get_accParent 001c @IntfClear 0027 T_ToggleButtonInOption.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_7_0 {
	meta:
		name = "TAccessField.Set_Value"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessField.Set_Value 0041 TAccessField.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2372_0 {
	meta:
		name = "TTempVar.Set__Value"
		size = 127
		refs = "001d @VarAddRef 0025 TTempVar.Set__Value 0041 TTempVar.GetDefaultInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_8_0 {
	meta:
		name = "CoAccessHyperlink.Create"
		size = 100
		refs = "000c CoAccessHyperlink.Create 001a CLASS_AccessHyperlink 001f CreateComObject 002e @IntfCast 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 11 66 D5 50 AC 60 CF 11 82 C9 00 AA 00 4B 9F E6 }
	condition:
		$1
}

rule function_9_0 {
	meta:
		name = "CoAccessHyperlink.CreateRemote"
		size = 128
		refs = "0011 CoAccessHyperlink.CreateRemote 0021 @WStrFromUStr 002c CLASS_AccessHyperlink 0031 CreateRemoteComObject 0040 @IntfCast 0055 @WStrClr 005d @IntfClear 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F1 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 45 F8 8D 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 11 66 D5 50 AC 60 CF 11 82 C9 00 AA 00 4B 9F E6 }
	condition:
		$1
}

rule function_11_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 08 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 40 65 B9 26 8E 8F 1B 10 AF 4E 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_15_0 {
	meta:
		name = "TAccessControl.Get_Parent"
		size = 91
		refs = "000f TAccessControl.Get_Parent 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3006_0 {
	meta:
		name = "TAccessApplication.Get_Parent"
		size = 91
		refs = "000f TAccessApplication.Get_Parent 001c @IntfClear 0027 TAccessApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_982_0 {
	meta:
		name = "TAccessGroupLevel.Get_Parent"
		size = 91
		refs = "000f TAccessGroupLevel.Get_Parent 001c @IntfClear 0027 TAccessGroupLevel.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_155_0 {
	meta:
		name = "TAccessImage.Get_Parent"
		size = 91
		refs = "000f TAccessImage.Get_Parent 001c @IntfClear 0027 TAccessImage.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_146_0 {
	meta:
		name = "TAccessLine.Get_Parent"
		size = 91
		refs = "000f TAccessLine.Get_Parent 001c @IntfClear 0027 TAccessLine.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_644_0 {
	meta:
		name = "TAccessPageBreak.Get_Parent"
		size = 91
		refs = "000f TAccessPageBreak.Get_Parent 001c @IntfClear 0027 TAccessPageBreak.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_743_0 {
	meta:
		name = "TAccessPaletteButton.Get_Parent"
		size = 91
		refs = "000f TAccessPaletteButton.Get_Parent 001c @IntfClear 0027 TAccessPaletteButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_137_0 {
	meta:
		name = "TAccessRectangle.Get_Parent"
		size = 91
		refs = "000f TAccessRectangle.Get_Parent 001c @IntfClear 0027 TAccessRectangle.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_974_0 {
	meta:
		name = "TAccessSection.Get_Parent"
		size = 91
		refs = "000f TAccessSection.Get_Parent 001c @IntfClear 0027 TAccessSection.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_798_0 {
	meta:
		name = "TAccessSubReport.Get_Parent"
		size = 91
		refs = "000f TAccessSubReport.Get_Parent 001c @IntfClear 0027 TAccessSubReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4853_0 {
	meta:
		name = "TBinder.Get_Path"
		size = 91
		refs = "000f TBinder.Get_Path 001c @WStrClr 0027 TBinder.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75813_0 {
	meta:
		name = "TCustomTaskPane.Get_Application"
		size = 91
		refs = "000f TCustomTaskPane.Get_Application 001c @IntfClear 0027 TCustomTaskPane.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2245_0 {
	meta:
		name = "TDependencyInfo.Get_Dependants"
		size = 91
		refs = "000f TDependencyInfo.Get_Dependants 001c @IntfClear 0027 TDependencyInfo.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2231_0 {
	meta:
		name = "TDependencyObjects.Get_Parent"
		size = 91
		refs = "000f TDependencyObjects.Get_Parent 001c @IntfClear 0027 TDependencyObjects.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2356_0 {
	meta:
		name = "TMacroError.Get_ActionName"
		size = 91
		refs = "000f TMacroError.Get_ActionName 001c @WStrClr 0027 TMacroError.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75709_0 {
	meta:
		name = "TMaster.Get_Parent"
		size = 91
		refs = "000f TMaster.Get_Parent 001c @IntfClear 0027 TMaster.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_32867_0 {
	meta:
		name = "TParameter.GetName"
		size = 91
		refs = "000f TParameter.GetName 001c @WStrClr 0027 TParameter.GetParameter 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75647_0 {
	meta:
		name = "TPowerPointApplication.Get_Windows"
		size = 91
		refs = "000f TPowerPointApplication.Get_Windows 001c @IntfClear 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75545_0 {
	meta:
		name = "TPowerPointPresentation.Get_Parent"
		size = 91
		refs = "000f TPowerPointPresentation.Get_Parent 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75504_0 {
	meta:
		name = "TPowerPointSlide.Get_Parent"
		size = 91
		refs = "000f TPowerPointSlide.Get_Parent 001c @IntfClear 0027 TPowerPointSlide.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2408_0 {
	meta:
		name = "TReturnVar.Get_Name"
		size = 91
		refs = "000f TReturnVar.Get_Name 001c @WStrClr 0027 TReturnVar.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2421_0 {
	meta:
		name = "TReturnVars.Get_Parent"
		size = 91
		refs = "000f TReturnVars.Get_Parent 001c @IntfClear 0027 TReturnVars.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2334_0 {
	meta:
		name = "TSmartTag.Get_Name"
		size = 91
		refs = "000f TSmartTag.Get_Name 001c @WStrClr 0027 TSmartTag.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2276_0 {
	meta:
		name = "TSmartTagAction.Get_Parent"
		size = 91
		refs = "000f TSmartTagAction.Get_Parent 001c @IntfClear 0027 TSmartTagAction.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2261_0 {
	meta:
		name = "TSmartTags.Get_Parent"
		size = 91
		refs = "000f TSmartTags.Get_Parent 001c @IntfClear 0027 TSmartTags.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2387_0 {
	meta:
		name = "TTempVars.Get_Parent"
		size = 91
		refs = "000f TTempVars.Get_Parent 001c @IntfClear 0027 TTempVars.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148554_0 {
	meta:
		name = "TWordDocument.Get_Application"
		size = 91
		refs = "000f TWordDocument.Get_Application 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_42_0 {
	meta:
		name = "T_ControlInReportEvents.Get_Parent"
		size = 91
		refs = "000f T_ControlInReportEvents.Get_Parent 001c @IntfClear 0027 T_ControlInReportEvents.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_997_0 {
	meta:
		name = "T_PageHdrFtrInReport.Get_Parent"
		size = 91
		refs = "000f T_PageHdrFtrInReport.Get_Parent 001c @IntfClear 0027 T_PageHdrFtrInReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_989_0 {
	meta:
		name = "T_SectionInReport.Get_Parent"
		size = 91
		refs = "000f T_SectionInReport.Get_Parent 001c @IntfClear 0027 T_SectionInReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_16_0 {
	meta:
		name = "TAccessControl.Get_Column"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessControl.Get_Column 0035 @VarClr 004d TAccessControl.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_2322_0 {
	meta:
		name = "TSmartTagProperties.Add"
		size = 141
		refs = "001f @VarAddRef 0027 TSmartTagProperties.Add 0035 @IntfClear 004d TSmartTagProperties.GetDefaultInterface 005b @CheckAutoResult 0078 @VarClr 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_43_0 {
	meta:
		name = "T_ControlInReportEvents.Get_Column"
		size = 141
		refs = "001f @VarAddRef 0027 T_ControlInReportEvents.Get_Column 0035 @VarClr 004d T_ControlInReportEvents.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_17_0 {
	meta:
		name = "TAccessControl.Get_Selected"
		size = 100
		refs = "0015 TAccessControl.Get_Selected 002a TAccessControl.GetControlInterface 0038 @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 56 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_44_0 {
	meta:
		name = "T_ControlInReportEvents.Get_Selected"
		size = 100
		refs = "0015 T_ControlInReportEvents.Get_Selected 002a T_ControlInReportEvents.GetControlInterface 0038 @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 56 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_18_0 {
	meta:
		name = "TAccessControl.Set_Selected"
		size = 89
		refs = "0012 TAccessControl.Set_Selected 0024 TAccessControl.GetControlInterface 0032 @CheckAutoResult 0047 @IntfClear 004d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78375_0 {
	meta:
		name = "TShellWindows.OnNavigate"
		size = 89
		refs = "0012 TShellWindows.OnNavigate 0024 TShellWindows.GetDefaultInterface 0032 @CheckAutoResult 0047 @IntfClear 004d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_45_0 {
	meta:
		name = "T_ControlInReportEvents.Set_Selected"
		size = 89
		refs = "0012 T_ControlInReportEvents.Set_Selected 0024 T_ControlInReportEvents.GetControlInterface 0032 @CheckAutoResult 0047 @IntfClear 004d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_19_0 {
	meta:
		name = "TAccessControl.Get_OldValue"
		size = 91
		refs = "000f TAccessControl.Get_OldValue 001c @VarClr 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52207_0 {
	meta:
		name = "TExcelChart.Get__CodeName"
		size = 91
		refs = "000f TExcelChart.Get__CodeName 001c @WStrClr 0027 TExcelChart.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52977_0 {
	meta:
		name = "TExcelWorkbook.Get_ActiveSheet"
		size = 91
		refs = "000f TExcelWorkbook.Get_ActiveSheet 001c @IntfClear 0027 TExcelWorkbook.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52511_0 {
	meta:
		name = "TExcelWorksheet.Get__CodeName"
		size = 91
		refs = "000f TExcelWorksheet.Get__CodeName 001c @WStrClr 0027 TExcelWorksheet.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75715_0 {
	meta:
		name = "TMaster.Get_Name"
		size = 91
		refs = "000f TMaster.Get_Name 001c @WStrClr 0027 TMaster.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76636_0 {
	meta:
		name = "TNameSpace.Get_AddressLists"
		size = 91
		refs = "000f TNameSpace.Get_AddressLists 001c @IntfClear 0027 TNameSpace.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76021_0 {
	meta:
		name = "TOutlookApplication.ActiveExplorer"
		size = 91
		refs = "000f TOutlookApplication.ActiveExplorer 001c @IntfClear 0027 TOutlookApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76694_0 {
	meta:
		name = "TOutlookBarPane.Get_Name"
		size = 91
		refs = "000f TOutlookBarPane.Get_Name 001c @WStrClr 0027 TOutlookBarPane.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77739_0 {
	meta:
		name = "TPowerPointApplication.Get_Path"
		size = 91
		refs = "000f TPowerPointApplication.Get_Path 001c @WStrClr 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75549_0 {
	meta:
		name = "TPowerPointPresentation.Get_TemplateName"
		size = 91
		refs = "000f TPowerPointPresentation.Get_TemplateName 001c @WStrClr 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75510_0 {
	meta:
		name = "TPowerPointSlide.Get_Background"
		size = 91
		refs = "000f TPowerPointSlide.Get_Background 001c @IntfClear 0027 TPowerPointSlide.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149200_0 {
	meta:
		name = "TWordApplication.Get_ActiveWindow"
		size = 91
		refs = "000f TWordApplication.Get_ActiveWindow 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148560_0 {
	meta:
		name = "TWordDocument.Get_Bookmarks"
		size = 91
		refs = "000f TWordDocument.Get_Bookmarks 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_46_0 {
	meta:
		name = "T_ControlInReportEvents.Get_OldValue"
		size = 91
		refs = "000f T_ControlInReportEvents.Get_OldValue 001c @VarClr 0027 T_ControlInReportEvents.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_20_0 {
	meta:
		name = "TAccessControl.Get_Form"
		size = 91
		refs = "000f TAccessControl.Get_Form 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1579_0 {
	meta:
		name = "TAccessApplication.Get_CurrentObjectName"
		size = 91
		refs = "000f TAccessApplication.Get_CurrentObjectName 001c @WStrClr 0027 TAccessApplication.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_158_0 {
	meta:
		name = "TAccessImage.Get_Controls"
		size = 91
		refs = "000f TAccessImage.Get_Controls 001c @IntfClear 0027 TAccessImage.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_746_0 {
	meta:
		name = "TAccessPaletteButton.Get_Controls"
		size = 91
		refs = "000f TAccessPaletteButton.Get_Controls 001c @IntfClear 0027 TAccessPaletteButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1372_0 {
	meta:
		name = "TAccessReport.Get_OrderBy"
		size = 91
		refs = "000f TAccessReport.Get_OrderBy 001c @WStrClr 0027 TAccessReport.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4856_0 {
	meta:
		name = "TBinder.Get_SelectedSectionNames"
		size = 91
		refs = "000f TBinder.Get_SelectedSectionNames 001c @VarClr 0027 TBinder.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_114108_0 {
	meta:
		name = "TCOMAdminCatalogCollection.Get_Name"
		size = 91
		refs = "000f TCOMAdminCatalogCollection.Get_Name 001c @VarClr 0027 TCOMAdminCatalogCollection.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76048_0 {
	meta:
		name = "TContactItem.Get_Body"
		size = 91
		refs = "000f TContactItem.Get_Body 001c @WStrClr 0027 TContactItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75774_0 {
	meta:
		name = "TCustomXMLPart.Get_NamespaceManager"
		size = 91
		refs = "000f TCustomXMLPart.Get_NamespaceManager 001c @IntfClear 0027 TCustomXMLPart.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75797_0 {
	meta:
		name = "TCustomXMLParts.Get__NewEnum"
		size = 91
		refs = "000f TCustomXMLParts.Get__NewEnum 001c @IntfClear 0027 TCustomXMLParts.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76325_0 {
	meta:
		name = "TDistListItem.Get_Body"
		size = 91
		refs = "000f TDistListItem.Get_Body 001c @WStrClr 0027 TDistListItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76398_0 {
	meta:
		name = "TDocumentItem.Get_Body"
		size = 91
		refs = "000f TDocumentItem.Get_Body 001c @WStrClr 0027 TDocumentItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76495_0 {
	meta:
		name = "TFolders.GetFirst"
		size = 91
		refs = "000f TFolders.GetFirst 001c @IntfClear 0027 TFolders.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78192_0 {
	meta:
		name = "TInternetExplorer.Get_Application"
		size = 91
		refs = "000f TInternetExplorer.Get_Application 001c @IntfClear 0027 TInternetExplorer.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78279_0 {
	meta:
		name = "TInternetExplorerMedium.Get_Application"
		size = 91
		refs = "000f TInternetExplorerMedium.Get_Application 001c @IntfClear 0027 TInternetExplorerMedium.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76551_0 {
	meta:
		name = "TJournalItem.Get_Body"
		size = 91
		refs = "000f TJournalItem.Get_Body 001c @WStrClr 0027 TJournalItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75879_0 {
	meta:
		name = "TMailItem.Get_Body"
		size = 91
		refs = "000f TMailItem.Get_Body 001c @WStrClr 0027 TMailItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76022_0 {
	meta:
		name = "TOutlookApplication.ActiveInspector"
		size = 91
		refs = "000f TOutlookApplication.ActiveInspector 001c @IntfClear 0027 TOutlookApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76734_0 {
	meta:
		name = "TPostItem.Get_Body"
		size = 91
		refs = "000f TPostItem.Get_Body 001c @WStrClr 0027 TPostItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75654_0 {
	meta:
		name = "TPowerPointApplication.Get_Name"
		size = 91
		refs = "000f TPowerPointApplication.Get_Name 001c @WStrClr 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75550_0 {
	meta:
		name = "TPowerPointPresentation.Get_NotesMaster"
		size = 91
		refs = "000f TPowerPointPresentation.Get_NotesMaster 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75511_0 {
	meta:
		name = "TPowerPointSlide.Get_Name"
		size = 91
		refs = "000f TPowerPointSlide.Get_Name 001c @WStrClr 0027 TPowerPointSlide.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76807_0 {
	meta:
		name = "TRemoteItem.Get_Body"
		size = 91
		refs = "000f TRemoteItem.Get_Body 001c @WStrClr 0027 TRemoteItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76873_0 {
	meta:
		name = "TReportItem.Get_Body"
		size = 91
		refs = "000f TReportItem.Get_Body 001c @WStrClr 0027 TReportItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2804_0 {
	meta:
		name = "TReportOld.Get_OrderBy"
		size = 91
		refs = "000f TReportOld.Get_OrderBy 001c @WStrClr 0027 TReportOld.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76935_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_Body"
		size = 91
		refs = "000f TTaskRequestAcceptItem.Get_Body 001c @WStrClr 0027 TTaskRequestAcceptItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76998_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_Body"
		size = 91
		refs = "000f TTaskRequestDeclineItem.Get_Body 001c @WStrClr 0027 TTaskRequestDeclineItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77061_0 {
	meta:
		name = "TTaskRequestItem.Get_Body"
		size = 91
		refs = "000f TTaskRequestItem.Get_Body 001c @WStrClr 0027 TTaskRequestItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77124_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_Body"
		size = 91
		refs = "000f TTaskRequestUpdateItem.Get_Body 001c @WStrClr 0027 TTaskRequestUpdateItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78148_0 {
	meta:
		name = "TWebBrowser.Get_Application"
		size = 91
		refs = "000f TWebBrowser.Get_Application 001c @IntfClear 0027 TWebBrowser.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_151558_0 {
	meta:
		name = "TWordApplication.Get_Selection"
		size = 91
		refs = "000f TWordApplication.Get_Selection 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148561_0 {
	meta:
		name = "TWordDocument.Get_Tables"
		size = 91
		refs = "000f TWordDocument.Get_Tables 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149125_0 {
	meta:
		name = "TWordLetterContent.Get_PageDesign"
		size = 91
		refs = "000f TWordLetterContent.Get_PageDesign 001c @WStrClr 0027 TWordLetterContent.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149098_0 {
	meta:
		name = "TWordOLEControl.Get_Name"
		size = 91
		refs = "000f TWordOLEControl.Get_Name 001c @WStrClr 0027 TWordOLEControl.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_47_0 {
	meta:
		name = "T_ControlInReportEvents.Get_Form"
		size = 91
		refs = "000f T_ControlInReportEvents.Get_Form 001c @IntfClear 0027 T_ControlInReportEvents.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_21_0 {
	meta:
		name = "TAccessControl.Get_Report"
		size = 91
		refs = "000f TAccessControl.Get_Report 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75775_0 {
	meta:
		name = "TCustomXMLPart.Get_XML"
		size = 91
		refs = "000f TCustomXMLPart.Get_XML 001c @WStrClr 0027 TCustomXMLPart.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75754_0 {
	meta:
		name = "TCustomXMLSchemaCollection.Get__NewEnum"
		size = 91
		refs = "000f TCustomXMLSchemaCollection.Get__NewEnum 001c @IntfClear 0027 TCustomXMLSchemaCollection.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_51631_0 {
	meta:
		name = "TExcelApplication.Get_ActiveSheet"
		size = 91
		refs = "000f TExcelApplication.Get_ActiveSheet 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52788_0 {
	meta:
		name = "TExcelGlobal.Get_ActiveSheet"
		size = 91
		refs = "000f TExcelGlobal.Get_ActiveSheet 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76496_0 {
	meta:
		name = "TFolders.GetLast"
		size = 91
		refs = "000f TFolders.GetLast 001c @IntfClear 0027 TFolders.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78193_0 {
	meta:
		name = "TInternetExplorer.Get_Parent"
		size = 91
		refs = "000f TInternetExplorer.Get_Parent 001c @IntfClear 0027 TInternetExplorer.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78280_0 {
	meta:
		name = "TInternetExplorerMedium.Get_Parent"
		size = 91
		refs = "000f TInternetExplorerMedium.Get_Parent 001c @IntfClear 0027 TInternetExplorerMedium.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77611_0 {
	meta:
		name = "TPowerPointApplication.Get_Caption"
		size = 91
		refs = "000f TPowerPointApplication.Get_Caption 001c @WStrClr 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75551_0 {
	meta:
		name = "TPowerPointPresentation.Get_HandoutMaster"
		size = 91
		refs = "000f TPowerPointPresentation.Get_HandoutMaster 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78149_0 {
	meta:
		name = "TWebBrowser.Get_Parent"
		size = 91
		refs = "000f TWebBrowser.Get_Parent 001c @IntfClear 0027 TWebBrowser.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149202_0 {
	meta:
		name = "TWordApplication.Get_WordBasic"
		size = 91
		refs = "000f TWordApplication.Get_WordBasic 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148562_0 {
	meta:
		name = "TWordDocument.Get_Footnotes"
		size = 91
		refs = "000f TWordDocument.Get_Footnotes 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_48_0 {
	meta:
		name = "T_ControlInReportEvents.Get_Report"
		size = 91
		refs = "000f T_ControlInReportEvents.Get_Report 001c @IntfClear 0027 T_ControlInReportEvents.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_22_0 {
	meta:
		name = "TAccessControl.Get_ItemData"
		size = 96
		refs = "0012 TAccessControl.Get_ItemData 001f @VarClr 002b TAccessControl.GetControlInterface 0039 @CheckAutoResult 004e @IntfClear 0054 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76521_0 {
	meta:
		name = "TItems.Find"
		size = 96
		refs = "0012 TItems.Find 001f @IntfClear 002b TItems.GetDefaultInterface 0039 @CheckAutoResult 0054 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_49_0 {
	meta:
		name = "T_ControlInReportEvents.Get_ItemData"
		size = 96
		refs = "0012 T_ControlInReportEvents.Get_ItemData 001f @VarClr 002b T_ControlInReportEvents.GetControlInterface 0039 @CheckAutoResult 004e @IntfClear 0054 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_23_0 {
	meta:
		name = "TAccessControl.Get_Object_"
		size = 91
		refs = "000f TAccessControl.Get_Object_ 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_429_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accFocus"
		size = 91
		refs = "000f TAccessBoundObjectFrame.Get_accFocus 001c @VarClr 0027 TAccessBoundObjectFrame.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_306_0 {
	meta:
		name = "TAccessCheckBox.Get_accFocus"
		size = 91
		refs = "000f TAccessCheckBox.Get_accFocus 001c @VarClr 0027 TAccessCheckBox.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_563_0 {
	meta:
		name = "TAccessComboBox.Get_accFocus"
		size = 91
		refs = "000f TAccessComboBox.Get_accFocus 001c @VarClr 0027 TAccessComboBox.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_183_0 {
	meta:
		name = "TAccessCommandButton.Get_accFocus"
		size = 91
		refs = "000f TAccessCommandButton.Get_accFocus 001c @VarClr 0027 TAccessCommandButton.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_815_0 {
	meta:
		name = "TAccessCustomControl.Get_accFocus"
		size = 91
		refs = "000f TAccessCustomControl.Get_accFocus 001c @VarClr 0027 TAccessCustomControl.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1021_0 {
	meta:
		name = "TAccessForm.Get_accFocus"
		size = 91
		refs = "000f TAccessForm.Get_accFocus 001c @VarClr 0027 TAccessForm.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78_0 {
	meta:
		name = "TAccessLabel.Get_accFocus"
		size = 91
		refs = "000f TAccessLabel.Get_accFocus 001c @VarClr 0027 TAccessLabel.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_516_0 {
	meta:
		name = "TAccessListBox.Get_accFocus"
		size = 91
		refs = "000f TAccessListBox.Get_accFocus 001c @VarClr 0027 TAccessListBox.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_609_0 {
	meta:
		name = "TAccessObjectFrame.Get_accFocus"
		size = 91
		refs = "000f TAccessObjectFrame.Get_accFocus 001c @VarClr 0027 TAccessObjectFrame.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_226_0 {
	meta:
		name = "TAccessOptionButton.Get_accFocus"
		size = 91
		refs = "000f TAccessOptionButton.Get_accFocus 001c @VarClr 0027 TAccessOptionButton.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_388_0 {
	meta:
		name = "TAccessOptionGroup.Get_accFocus"
		size = 91
		refs = "000f TAccessOptionGroup.Get_accFocus 001c @VarClr 0027 TAccessOptionGroup.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_944_0 {
	meta:
		name = "TAccessPage.Get_accFocus"
		size = 91
		refs = "000f TAccessPage.Get_accFocus 001c @VarClr 0027 TAccessPage.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_768_0 {
	meta:
		name = "TAccessSubForm.Get_accFocus"
		size = 91
		refs = "000f TAccessSubForm.Get_accFocus 001c @VarClr 0027 TAccessSubForm.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_907_0 {
	meta:
		name = "TAccessTabControl.Get_accFocus"
		size = 91
		refs = "000f TAccessTabControl.Get_accFocus 001c @VarClr 0027 TAccessTabControl.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_473_0 {
	meta:
		name = "TAccessTextBox.Get_accFocus"
		size = 91
		refs = "000f TAccessTextBox.Get_accFocus 001c @VarClr 0027 TAccessTextBox.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_662_0 {
	meta:
		name = "TAccessToggleButton.Get_accFocus"
		size = 91
		refs = "000f TAccessToggleButton.Get_accFocus 001c @VarClr 0027 TAccessToggleButton.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_114118_0 {
	meta:
		name = "TCOMAdminCatalogCollection.GetUtilInterface"
		size = 91
		refs = "000f TCOMAdminCatalogCollection.GetUtilInterface 001c @IntfClear 0027 TCOMAdminCatalogCollection.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_55595_0 {
	meta:
		name = "TExcelApplication.Get_ActiveWorkbook"
		size = 91
		refs = "000f TExcelApplication.Get_ActiveWorkbook 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_56291_0 {
	meta:
		name = "TExcelChart.Get_Name"
		size = 91
		refs = "000f TExcelChart.Get_Name 001c @WStrClr 0027 TExcelChart.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_56941_0 {
	meta:
		name = "TExcelGlobal.Get_ActiveWorkbook"
		size = 91
		refs = "000f TExcelGlobal.Get_ActiveWorkbook 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52514_0 {
	meta:
		name = "TExcelWorksheet.Get_Name"
		size = 91
		refs = "000f TExcelWorksheet.Get_Name 001c @WStrClr 0027 TExcelWorksheet.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76498_0 {
	meta:
		name = "TFolders.GetPrevious"
		size = 91
		refs = "000f TFolders.GetPrevious 001c @IntfClear 0027 TFolders.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78195_0 {
	meta:
		name = "TInternetExplorer.Get_Document"
		size = 91
		refs = "000f TInternetExplorer.Get_Document 001c @IntfClear 0027 TInternetExplorer.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78282_0 {
	meta:
		name = "TInternetExplorerMedium.Get_Document"
		size = 91
		refs = "000f TInternetExplorerMedium.Get_Document 001c @IntfClear 0027 TInternetExplorerMedium.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76522_0 {
	meta:
		name = "TItems.FindNext"
		size = 91
		refs = "000f TItems.FindNext 001c @IntfClear 0027 TItems.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77718_0 {
	meta:
		name = "TOLECtrl.Get_Name"
		size = 91
		refs = "000f TOLECtrl.Get_Name 001c @WStrClr 0027 TOLECtrl.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77613_0 {
	meta:
		name = "TPowerPointApplication.Get_Assistant"
		size = 91
		refs = "000f TPowerPointApplication.Get_Assistant 001c @IntfClear 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75553_0 {
	meta:
		name = "TPowerPointPresentation.Get_PageSetup"
		size = 91
		refs = "000f TPowerPointPresentation.Get_PageSetup 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78151_0 {
	meta:
		name = "TWebBrowser.Get_Document"
		size = 91
		refs = "000f TWebBrowser.Get_Document 001c @IntfClear 0027 TWebBrowser.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149204_0 {
	meta:
		name = "TWordApplication.Get_NormalTemplate"
		size = 91
		refs = "000f TWordApplication.Get_NormalTemplate 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148564_0 {
	meta:
		name = "TWordDocument.Get_Comments"
		size = 91
		refs = "000f TWordDocument.Get_Comments 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_347_0 {
	meta:
		name = "T_CheckBoxInOption.Get_accFocus"
		size = 91
		refs = "000f T_CheckBoxInOption.Get_accFocus 001c @VarClr 0027 T_CheckBoxInOption.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_112_0 {
	meta:
		name = "T_ChildLabel.Get_accFocus"
		size = 91
		refs = "000f T_ChildLabel.Get_accFocus 001c @VarClr 0027 T_ChildLabel.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_50_0 {
	meta:
		name = "T_ControlInReportEvents.Get_Object_"
		size = 91
		refs = "000f T_ControlInReportEvents.Get_Object_ 001c @IntfClear 0027 T_ControlInReportEvents.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_861_0 {
	meta:
		name = "T_CustomControlInReport.Get_accFocus"
		size = 91
		refs = "000f T_CustomControlInReport.Get_accFocus 001c @VarClr 0027 T_CustomControlInReport.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_266_0 {
	meta:
		name = "T_OptionButtonInOption.Get_accFocus"
		size = 91
		refs = "000f T_OptionButtonInOption.Get_accFocus 001c @VarClr 0027 T_OptionButtonInOption.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_707_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_accFocus"
		size = 91
		refs = "000f T_ToggleButtonInOption.Get_accFocus 001c @VarClr 0027 T_ToggleButtonInOption.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_24_0 {
	meta:
		name = "TAccessControl.Get_ObjectVerbs"
		size = 96
		refs = "0012 TAccessControl.Get_ObjectVerbs 001f @WStrClr 002b TAccessControl.GetControlInterface 0039 @CheckAutoResult 004e @IntfClear 0054 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76644_0 {
	meta:
		name = "TNameSpace.GetRecipientFromID"
		size = 96
		refs = "0012 TNameSpace.GetRecipientFromID 001f @IntfClear 002b TNameSpace.GetDefaultInterface 0039 @CheckAutoResult 0054 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76027_0 {
	meta:
		name = "TOutlookApplication.GetNamespace"
		size = 96
		refs = "0012 TOutlookApplication.GetNamespace 001f @IntfClear 002b TOutlookApplication.GetDefaultInterface 0039 @CheckAutoResult 0054 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_51_0 {
	meta:
		name = "T_ControlInReportEvents.Get_ObjectVerbs"
		size = 96
		refs = "0012 T_ControlInReportEvents.Get_ObjectVerbs 001f @WStrClr 002b T_ControlInReportEvents.GetControlInterface 0039 @CheckAutoResult 004e @IntfClear 0054 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_25_0 {
	meta:
		name = "TAccessControl.Get_Properties"
		size = 91
		refs = "000f TAccessControl.Get_Properties 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_51635_0 {
	meta:
		name = "TExcelApplication.Get_Assistant"
		size = 91
		refs = "000f TExcelApplication.Get_Assistant 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52212_0 {
	meta:
		name = "TExcelChart.Get_Next"
		size = 91
		refs = "000f TExcelChart.Get_Next 001c @IntfClear 0027 TExcelChart.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_56943_0 {
	meta:
		name = "TExcelGlobal.Get_Assistant"
		size = 91
		refs = "000f TExcelGlobal.Get_Assistant 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_56626_0 {
	meta:
		name = "TExcelWorksheet.Get_Next"
		size = 91
		refs = "000f TExcelWorksheet.Get_Next 001c @IntfClear 0027 TExcelWorksheet.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78197_0 {
	meta:
		name = "TInternetExplorer.Get_type_"
		size = 91
		refs = "000f TInternetExplorer.Get_type_ 001c @WStrClr 0027 TInternetExplorer.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78284_0 {
	meta:
		name = "TInternetExplorerMedium.Get_type_"
		size = 91
		refs = "000f TInternetExplorerMedium.Get_type_ 001c @WStrClr 0027 TInternetExplorerMedium.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76524_0 {
	meta:
		name = "TItems.GetLast"
		size = 91
		refs = "000f TItems.GetLast 001c @IntfClear 0027 TItems.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75720_0 {
	meta:
		name = "TMaster.Get_Hyperlinks"
		size = 91
		refs = "000f TMaster.Get_Hyperlinks 001c @IntfClear 0027 TMaster.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75634_0 {
	meta:
		name = "TOLECtrl.Get_AltHTML"
		size = 91
		refs = "000f TOLECtrl.Get_AltHTML 001c @WStrClr 0027 TOLECtrl.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75659_0 {
	meta:
		name = "TPowerPointApplication.Get_FileFind"
		size = 91
		refs = "000f TPowerPointApplication.Get_FileFind 001c @IntfClear 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75555_0 {
	meta:
		name = "TPowerPointPresentation.Get_ExtraColors"
		size = 91
		refs = "000f TPowerPointPresentation.Get_ExtraColors 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149206_0 {
	meta:
		name = "TWordApplication.Get_AutoCorrect"
		size = 91
		refs = "000f TWordApplication.Get_AutoCorrect 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52_0 {
	meta:
		name = "T_ControlInReportEvents.Get_Properties"
		size = 91
		refs = "000f T_ControlInReportEvents.Get_Properties 001c @IntfClear 0027 T_ControlInReportEvents.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_26_0 {
	meta:
		name = "TAccessControl.Get_ItemsSelected"
		size = 91
		refs = "000f TAccessControl.Get_ItemsSelected 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1583_0 {
	meta:
		name = "TAccessApplication.Get_DoCmd"
		size = 91
		refs = "000f TAccessApplication.Get_DoCmd 001c @IntfClear 0027 TAccessApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76057_0 {
	meta:
		name = "TContactItem.Get_EntryID"
		size = 91
		refs = "000f TContactItem.Get_EntryID 001c @WStrClr 0027 TContactItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76334_0 {
	meta:
		name = "TDistListItem.Get_EntryID"
		size = 91
		refs = "000f TDistListItem.Get_EntryID 001c @WStrClr 0027 TDistListItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76407_0 {
	meta:
		name = "TDocumentItem.Get_EntryID"
		size = 91
		refs = "000f TDocumentItem.Get_EntryID 001c @WStrClr 0027 TDocumentItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_55600_0 {
	meta:
		name = "TExcelApplication.Get_Columns"
		size = 91
		refs = "000f TExcelApplication.Get_Columns 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52795_0 {
	meta:
		name = "TExcelGlobal.Get_Columns"
		size = 91
		refs = "000f TExcelGlobal.Get_Columns 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76560_0 {
	meta:
		name = "TJournalItem.Get_EntryID"
		size = 91
		refs = "000f TJournalItem.Get_EntryID 001c @WStrClr 0027 TJournalItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75888_0 {
	meta:
		name = "TMailItem.Get_EntryID"
		size = 91
		refs = "000f TMailItem.Get_EntryID 001c @WStrClr 0027 TMailItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76016_0 {
	meta:
		name = "TOutlookApplication.Get_LanguageSettings"
		size = 91
		refs = "000f TOutlookApplication.Get_LanguageSettings 001c @IntfClear 0027 TOutlookApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76743_0 {
	meta:
		name = "TPostItem.Get_EntryID"
		size = 91
		refs = "000f TPostItem.Get_EntryID 001c @WStrClr 0027 TPostItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75663_0 {
	meta:
		name = "TPowerPointApplication.Get_ActivePrinter"
		size = 91
		refs = "000f TPowerPointApplication.Get_ActivePrinter 001c @WStrClr 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75559_0 {
	meta:
		name = "TPowerPointPresentation.Get_Tags"
		size = 91
		refs = "000f TPowerPointPresentation.Get_Tags 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75531_0 {
	meta:
		name = "TPowerPointSlide.Duplicate"
		size = 91
		refs = "000f TPowerPointSlide.Duplicate 001c @IntfClear 0027 TPowerPointSlide.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76816_0 {
	meta:
		name = "TRemoteItem.Get_EntryID"
		size = 91
		refs = "000f TRemoteItem.Get_EntryID 001c @WStrClr 0027 TRemoteItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76882_0 {
	meta:
		name = "TReportItem.Get_EntryID"
		size = 91
		refs = "000f TReportItem.Get_EntryID 001c @WStrClr 0027 TReportItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78455_0 {
	meta:
		name = "TShellNameSpace.Get_Root"
		size = 91
		refs = "000f TShellNameSpace.Get_Root 001c @VarClr 0027 TShellNameSpace.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76944_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_EntryID"
		size = 91
		refs = "000f TTaskRequestAcceptItem.Get_EntryID 001c @WStrClr 0027 TTaskRequestAcceptItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77007_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_EntryID"
		size = 91
		refs = "000f TTaskRequestDeclineItem.Get_EntryID 001c @WStrClr 0027 TTaskRequestDeclineItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77070_0 {
	meta:
		name = "TTaskRequestItem.Get_EntryID"
		size = 91
		refs = "000f TTaskRequestItem.Get_EntryID 001c @WStrClr 0027 TTaskRequestItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77133_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_EntryID"
		size = 91
		refs = "000f TTaskRequestUpdateItem.Get_EntryID 001c @WStrClr 0027 TTaskRequestUpdateItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149210_0 {
	meta:
		name = "TWordApplication.Get_Languages"
		size = 91
		refs = "000f TWordApplication.Get_Languages 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_53_0 {
	meta:
		name = "T_ControlInReportEvents.Get_ItemsSelected"
		size = 91
		refs = "000f T_ControlInReportEvents.Get_ItemsSelected 001c @IntfClear 0027 T_ControlInReportEvents.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_27_0 {
	meta:
		name = "TAccessControl.Get_Pages"
		size = 91
		refs = "000f TAccessControl.Get_Pages 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52219_0 {
	meta:
		name = "TExcelChart.Get_PageSetup"
		size = 91
		refs = "000f TExcelChart.Get_PageSetup 001c @IntfClear 0027 TExcelChart.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52523_0 {
	meta:
		name = "TExcelWorksheet.Get_PageSetup"
		size = 91
		refs = "000f TExcelWorksheet.Get_PageSetup 001c @IntfClear 0027 TExcelWorksheet.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75666_0 {
	meta:
		name = "TPowerPointApplication.Get_VBE"
		size = 91
		refs = "000f TPowerPointApplication.Get_VBE 001c @IntfClear 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75562_0 {
	meta:
		name = "TPowerPointPresentation.Get_CustomDocumentProperties"
		size = 91
		refs = "000f TPowerPointPresentation.Get_CustomDocumentProperties 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149213_0 {
	meta:
		name = "TWordApplication.Get_FileConverters"
		size = 91
		refs = "000f TWordApplication.Get_FileConverters 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149137_0 {
	meta:
		name = "TWordLetterContent.Get_RecipientAddress"
		size = 91
		refs = "000f TWordLetterContent.Get_RecipientAddress 001c @WStrClr 0027 TWordLetterContent.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_54_0 {
	meta:
		name = "T_ControlInReportEvents.Get_Pages"
		size = 91
		refs = "000f T_ControlInReportEvents.Get_Pages 001c @IntfClear 0027 T_ControlInReportEvents.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_28_0 {
	meta:
		name = "TAccessControl.Get_Controls"
		size = 91
		refs = "000f TAccessControl.Get_Controls 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_434_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_Application"
		size = 91
		refs = "000f TAccessBoundObjectFrame.Get_Application 001c @IntfClear 0027 TAccessBoundObjectFrame.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_311_0 {
	meta:
		name = "TAccessCheckBox.Get_Application"
		size = 91
		refs = "000f TAccessCheckBox.Get_Application 001c @IntfClear 0027 TAccessCheckBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_568_0 {
	meta:
		name = "TAccessComboBox.Get_Application"
		size = 91
		refs = "000f TAccessComboBox.Get_Application 001c @IntfClear 0027 TAccessComboBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_188_0 {
	meta:
		name = "TAccessCommandButton.Get_Application"
		size = 91
		refs = "000f TAccessCommandButton.Get_Application 001c @IntfClear 0027 TAccessCommandButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_820_0 {
	meta:
		name = "TAccessCustomControl.Get_Application"
		size = 91
		refs = "000f TAccessCustomControl.Get_Application 001c @IntfClear 0027 TAccessCustomControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1026_0 {
	meta:
		name = "TAccessForm.Get_FormName"
		size = 91
		refs = "000f TAccessForm.Get_FormName 001c @WStrClr 0027 TAccessForm.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_160_0 {
	meta:
		name = "TAccessImage.Get_PictureData"
		size = 91
		refs = "000f TAccessImage.Get_PictureData 001c @VarClr 0027 TAccessImage.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_83_0 {
	meta:
		name = "TAccessLabel.Get_Application"
		size = 91
		refs = "000f TAccessLabel.Get_Application 001c @IntfClear 0027 TAccessLabel.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_521_0 {
	meta:
		name = "TAccessListBox.Get_Application"
		size = 91
		refs = "000f TAccessListBox.Get_Application 001c @IntfClear 0027 TAccessListBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_614_0 {
	meta:
		name = "TAccessObjectFrame.Get_Application"
		size = 91
		refs = "000f TAccessObjectFrame.Get_Application 001c @IntfClear 0027 TAccessObjectFrame.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_231_0 {
	meta:
		name = "TAccessOptionButton.Get_Application"
		size = 91
		refs = "000f TAccessOptionButton.Get_Application 001c @IntfClear 0027 TAccessOptionButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_393_0 {
	meta:
		name = "TAccessOptionGroup.Get_Application"
		size = 91
		refs = "000f TAccessOptionGroup.Get_Application 001c @IntfClear 0027 TAccessOptionGroup.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_949_0 {
	meta:
		name = "TAccessPage.Get_Application"
		size = 91
		refs = "000f TAccessPage.Get_Application 001c @IntfClear 0027 TAccessPage.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_773_0 {
	meta:
		name = "TAccessSubForm.Get_Application"
		size = 91
		refs = "000f TAccessSubForm.Get_Application 001c @IntfClear 0027 TAccessSubForm.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_912_0 {
	meta:
		name = "TAccessTabControl.Get_Application"
		size = 91
		refs = "000f TAccessTabControl.Get_Application 001c @IntfClear 0027 TAccessTabControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_478_0 {
	meta:
		name = "TAccessTextBox.Get_Application"
		size = 91
		refs = "000f TAccessTextBox.Get_Application 001c @IntfClear 0027 TAccessTextBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_667_0 {
	meta:
		name = "TAccessToggleButton.Get_Application"
		size = 91
		refs = "000f TAccessToggleButton.Get_Application 001c @IntfClear 0027 TAccessToggleButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52220_0 {
	meta:
		name = "TExcelChart.Get_Previous"
		size = 91
		refs = "000f TExcelChart.Get_Previous 001c @IntfClear 0027 TExcelChart.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_57139_0 {
	meta:
		name = "TExcelWorkbook.Get_CodeName"
		size = 91
		refs = "000f TExcelWorkbook.Get_CodeName 001c @WStrClr 0027 TExcelWorkbook.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_56634_0 {
	meta:
		name = "TExcelWorksheet.Get_Previous"
		size = 91
		refs = "000f TExcelWorksheet.Get_Previous 001c @IntfClear 0027 TExcelWorksheet.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2458_0 {
	meta:
		name = "TFormOld.Get_FormName"
		size = 91
		refs = "000f TFormOld.Get_FormName 001c @WStrClr 0027 TFormOld.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75563_0 {
	meta:
		name = "TPowerPointPresentation.Get_VBProject"
		size = 91
		refs = "000f TPowerPointPresentation.Get_VBProject 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_151571_0 {
	meta:
		name = "TWordApplication.Get_MailingLabel"
		size = 91
		refs = "000f TWordApplication.Get_MailingLabel 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148574_0 {
	meta:
		name = "TWordDocument.Get_Sections"
		size = 91
		refs = "000f TWordDocument.Get_Sections 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_352_0 {
	meta:
		name = "T_CheckBoxInOption.Get_Application"
		size = 91
		refs = "000f T_CheckBoxInOption.Get_Application 001c @IntfClear 0027 T_CheckBoxInOption.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_117_0 {
	meta:
		name = "T_ChildLabel.Get_Application"
		size = 91
		refs = "000f T_ChildLabel.Get_Application 001c @IntfClear 0027 T_ChildLabel.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_55_0 {
	meta:
		name = "T_ControlInReportEvents.Get_Controls"
		size = 91
		refs = "000f T_ControlInReportEvents.Get_Controls 001c @IntfClear 0027 T_ControlInReportEvents.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_866_0 {
	meta:
		name = "T_CustomControlInReport.Get_Application"
		size = 91
		refs = "000f T_CustomControlInReport.Get_Application 001c @IntfClear 0027 T_CustomControlInReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_271_0 {
	meta:
		name = "T_OptionButtonInOption.Get_Application"
		size = 91
		refs = "000f T_OptionButtonInOption.Get_Application 001c @IntfClear 0027 T_OptionButtonInOption.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_712_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_Application"
		size = 91
		refs = "000f T_ToggleButtonInOption.Get_Application 001c @IntfClear 0027 T_ToggleButtonInOption.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_29_0 {
	meta:
		name = "TAccessControl.Get_Hyperlink"
		size = 91
		refs = "000f TAccessControl.Get_Hyperlink 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_435_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_Parent"
		size = 91
		refs = "000f TAccessBoundObjectFrame.Get_Parent 001c @IntfClear 0027 TAccessBoundObjectFrame.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_312_0 {
	meta:
		name = "TAccessCheckBox.Get_Parent"
		size = 91
		refs = "000f TAccessCheckBox.Get_Parent 001c @IntfClear 0027 TAccessCheckBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_569_0 {
	meta:
		name = "TAccessComboBox.Get_Parent"
		size = 91
		refs = "000f TAccessComboBox.Get_Parent 001c @IntfClear 0027 TAccessComboBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_189_0 {
	meta:
		name = "TAccessCommandButton.Get_Parent"
		size = 91
		refs = "000f TAccessCommandButton.Get_Parent 001c @IntfClear 0027 TAccessCommandButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_821_0 {
	meta:
		name = "TAccessCustomControl.Get_Parent"
		size = 91
		refs = "000f TAccessCustomControl.Get_Parent 001c @IntfClear 0027 TAccessCustomControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_84_0 {
	meta:
		name = "TAccessLabel.Get_Parent"
		size = 91
		refs = "000f TAccessLabel.Get_Parent 001c @IntfClear 0027 TAccessLabel.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_522_0 {
	meta:
		name = "TAccessListBox.Get_Parent"
		size = 91
		refs = "000f TAccessListBox.Get_Parent 001c @IntfClear 0027 TAccessListBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_615_0 {
	meta:
		name = "TAccessObjectFrame.Get_Parent"
		size = 91
		refs = "000f TAccessObjectFrame.Get_Parent 001c @IntfClear 0027 TAccessObjectFrame.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_232_0 {
	meta:
		name = "TAccessOptionButton.Get_Parent"
		size = 91
		refs = "000f TAccessOptionButton.Get_Parent 001c @IntfClear 0027 TAccessOptionButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_394_0 {
	meta:
		name = "TAccessOptionGroup.Get_Parent"
		size = 91
		refs = "000f TAccessOptionGroup.Get_Parent 001c @IntfClear 0027 TAccessOptionGroup.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_950_0 {
	meta:
		name = "TAccessPage.Get_Parent"
		size = 91
		refs = "000f TAccessPage.Get_Parent 001c @IntfClear 0027 TAccessPage.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_774_0 {
	meta:
		name = "TAccessSubForm.Get_Parent"
		size = 91
		refs = "000f TAccessSubForm.Get_Parent 001c @IntfClear 0027 TAccessSubForm.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_913_0 {
	meta:
		name = "TAccessTabControl.Get_Parent"
		size = 91
		refs = "000f TAccessTabControl.Get_Parent 001c @IntfClear 0027 TAccessTabControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_479_0 {
	meta:
		name = "TAccessTextBox.Get_Parent"
		size = 91
		refs = "000f TAccessTextBox.Get_Parent 001c @IntfClear 0027 TAccessTextBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_668_0 {
	meta:
		name = "TAccessToggleButton.Get_Parent"
		size = 91
		refs = "000f TAccessToggleButton.Get_Parent 001c @IntfClear 0027 TAccessToggleButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_57140_0 {
	meta:
		name = "TExcelWorkbook.Get__CodeName"
		size = 91
		refs = "000f TExcelWorkbook.Get__CodeName 001c @WStrClr 0027 TExcelWorkbook.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78206_0 {
	meta:
		name = "TInternetExplorer.Get_LocationName"
		size = 91
		refs = "000f TInternetExplorer.Get_LocationName 001c @WStrClr 0027 TInternetExplorer.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78293_0 {
	meta:
		name = "TInternetExplorerMedium.Get_LocationName"
		size = 91
		refs = "000f TInternetExplorerMedium.Get_LocationName 001c @WStrClr 0027 TInternetExplorerMedium.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77352_0 {
	meta:
		name = "TOutlookApplication.ActiveWindow"
		size = 91
		refs = "000f TOutlookApplication.ActiveWindow 001c @IntfClear 0027 TOutlookApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149215_0 {
	meta:
		name = "TWordApplication.Get_Dialogs"
		size = 91
		refs = "000f TWordApplication.Get_Dialogs 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148575_0 {
	meta:
		name = "TWordDocument.Get_Paragraphs"
		size = 91
		refs = "000f TWordDocument.Get_Paragraphs 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149139_0 {
	meta:
		name = "TWordLetterContent.Get_Salutation"
		size = 91
		refs = "000f TWordLetterContent.Get_Salutation 001c @WStrClr 0027 TWordLetterContent.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_353_0 {
	meta:
		name = "T_CheckBoxInOption.Get_Parent"
		size = 91
		refs = "000f T_CheckBoxInOption.Get_Parent 001c @IntfClear 0027 T_CheckBoxInOption.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_118_0 {
	meta:
		name = "T_ChildLabel.Get_Parent"
		size = 91
		refs = "000f T_ChildLabel.Get_Parent 001c @IntfClear 0027 T_ChildLabel.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_56_0 {
	meta:
		name = "T_ControlInReportEvents.Get_Hyperlink"
		size = 91
		refs = "000f T_ControlInReportEvents.Get_Hyperlink 001c @IntfClear 0027 T_ControlInReportEvents.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_867_0 {
	meta:
		name = "T_CustomControlInReport.Get_Parent"
		size = 91
		refs = "000f T_CustomControlInReport.Get_Parent 001c @IntfClear 0027 T_CustomControlInReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_272_0 {
	meta:
		name = "T_OptionButtonInOption.Get_Parent"
		size = 91
		refs = "000f T_OptionButtonInOption.Get_Parent 001c @IntfClear 0027 T_OptionButtonInOption.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_713_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_Parent"
		size = 91
		refs = "000f T_ToggleButtonInOption.Get_Parent 001c @IntfClear 0027 T_ToggleButtonInOption.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_30_0 {
	meta:
		name = "TAccessControl.Undo"
		size = 79
		refs = "000c TAccessControl.Undo 001c TAccessControl.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78242_0 {
	meta:
		name = "TInternetExplorer.GoHome"
		size = 79
		refs = "000c TInternetExplorer.GoHome 001c TInternetExplorer.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78329_0 {
	meta:
		name = "TInternetExplorerMedium.GoHome"
		size = 79
		refs = "000c TInternetExplorerMedium.GoHome 001c TInternetExplorerMedium.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78470_0 {
	meta:
		name = "TShellNameSpace.ResetSort"
		size = 79
		refs = "000c TShellNameSpace.ResetSort 001c TShellNameSpace.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78391_0 {
	meta:
		name = "TShellUIHelper.RefreshOfflineDesktop"
		size = 79
		refs = "000c TShellUIHelper.RefreshOfflineDesktop 001c TShellUIHelper.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78155_0 {
	meta:
		name = "TWebBrowser.GoHome"
		size = 79
		refs = "000c TWebBrowser.GoHome 001c TWebBrowser.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_57_0 {
	meta:
		name = "T_ControlInReportEvents.Undo"
		size = 79
		refs = "000c T_ControlInReportEvents.Undo 001c T_ControlInReportEvents.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_31_0 {
	meta:
		name = "TAccessControl.Dropdown"
		size = 79
		refs = "000c TAccessControl.Dropdown 001c TAccessControl.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_148_0 {
	meta:
		name = "TAccessLine.SizeToFit"
		size = 79
		refs = "000c TAccessLine.SizeToFit 001c TAccessLine.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_646_0 {
	meta:
		name = "TAccessPageBreak.SizeToFit"
		size = 79
		refs = "000c TAccessPageBreak.SizeToFit 001c TAccessPageBreak.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_139_0 {
	meta:
		name = "TAccessRectangle.SizeToFit"
		size = 79
		refs = "000c TAccessRectangle.SizeToFit 001c TAccessRectangle.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78243_0 {
	meta:
		name = "TInternetExplorer.GoSearch"
		size = 79
		refs = "000c TInternetExplorer.GoSearch 001c TInternetExplorer.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78330_0 {
	meta:
		name = "TInternetExplorerMedium.GoSearch"
		size = 79
		refs = "000c TInternetExplorerMedium.GoSearch 001c TInternetExplorerMedium.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78471_0 {
	meta:
		name = "TShellNameSpace.NewFolder"
		size = 79
		refs = "000c TShellNameSpace.NewFolder 001c TShellNameSpace.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2278_0 {
	meta:
		name = "TSmartTagAction.Execute"
		size = 79
		refs = "000c TSmartTagAction.Execute 001c TSmartTagAction.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78156_0 {
	meta:
		name = "TWebBrowser.GoSearch"
		size = 79
		refs = "000c TWebBrowser.GoSearch 001c TWebBrowser.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_58_0 {
	meta:
		name = "T_ControlInReportEvents.Dropdown"
		size = 79
		refs = "000c T_ControlInReportEvents.Dropdown 001c T_ControlInReportEvents.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_32_0 {
	meta:
		name = "TAccessControl.Requery"
		size = 79
		refs = "000c TAccessControl.Requery 001c TAccessControl.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_75826_0 {
	meta:
		name = "TCustomTaskPane.Delete"
		size = 79
		refs = "000c TCustomTaskPane.Delete 001c TCustomTaskPane.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_76646_0 {
	meta:
		name = "TNameSpace.Logoff"
		size = 79
		refs = "000c TNameSpace.Logoff 001c TNameSpace.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_75530_0 {
	meta:
		name = "TPowerPointSlide.Copy"
		size = 79
		refs = "000c TPowerPointSlide.Copy 001c TPowerPointSlide.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78411_0 {
	meta:
		name = "TShellUIHelper.RunOnceShown"
		size = 79
		refs = "000c TShellUIHelper.RunOnceShown 001c TShellUIHelper.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_149106_0 {
	meta:
		name = "TWordOLEControl.Delete"
		size = 79
		refs = "000c TWordOLEControl.Delete 001c TWordOLEControl.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_59_0 {
	meta:
		name = "T_ControlInReportEvents.Requery"
		size = 79
		refs = "000c T_ControlInReportEvents.Requery 001c T_ControlInReportEvents.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_33_0 {
	meta:
		name = "TAccessControl.SizeToFit"
		size = 79
		refs = "000c TAccessControl.SizeToFit 001c TAccessControl.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78412_0 {
	meta:
		name = "TShellUIHelper.SkipRunOnce"
		size = 79
		refs = "000c TShellUIHelper.SkipRunOnce 001c TShellUIHelper.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_149107_0 {
	meta:
		name = "TWordOLEControl.Activate"
		size = 79
		refs = "000c TWordOLEControl.Activate 001c TWordOLEControl.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_60_0 {
	meta:
		name = "T_ControlInReportEvents.SizeToFit"
		size = 79
		refs = "000c T_ControlInReportEvents.SizeToFit 001c T_ControlInReportEvents.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_34_0 {
	meta:
		name = "TAccessControl.Goto_"
		size = 79
		refs = "000c TAccessControl.Goto_ 001c TAccessControl.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_61_0 {
	meta:
		name = "T_ControlInReportEvents.Goto_"
		size = 79
		refs = "000c T_ControlInReportEvents.Goto_ 001c T_ControlInReportEvents.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_35_0 {
	meta:
		name = "TAccessControl.SetFocus"
		size = 79
		refs = "000c TAccessControl.SetFocus 001c TAccessControl.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_75532_0 {
	meta:
		name = "TPowerPointSlide.Delete"
		size = 79
		refs = "000c TPowerPointSlide.Delete 001c TPowerPointSlide.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_62_0 {
	meta:
		name = "T_ControlInReportEvents.SetFocus"
		size = 79
		refs = "000c T_ControlInReportEvents.SetFocus 001c T_ControlInReportEvents.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_36_0 {
	meta:
		name = "TAccessControl._Evaluate"
		size = 100
		refs = "0012 TAccessControl._Evaluate 0020 @VarClr 002d TAccessControl.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_63_0 {
	meta:
		name = "T_ControlInReportEvents._Evaluate"
		size = 100
		refs = "0012 T_ControlInReportEvents._Evaluate 0020 @VarClr 002d T_ControlInReportEvents.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_65_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 08 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 48 E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_69_0 {
	meta:
		name = "TAccessLabel.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessLabel.Get_accChild 0034 @IntfClear 004b TAccessLabel.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_420_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.Get_accChild 0034 @IntfClear 004b TAccessBoundObjectFrame.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_297_0 {
	meta:
		name = "TAccessCheckBox.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCheckBox.Get_accChild 0034 @IntfClear 004b TAccessCheckBox.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_554_0 {
	meta:
		name = "TAccessComboBox.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessComboBox.Get_accChild 0034 @IntfClear 004b TAccessComboBox.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_174_0 {
	meta:
		name = "TAccessCommandButton.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCommandButton.Get_accChild 0034 @IntfClear 004b TAccessCommandButton.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_806_0 {
	meta:
		name = "TAccessCustomControl.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCustomControl.Get_accChild 0034 @IntfClear 004b TAccessCustomControl.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1012_0 {
	meta:
		name = "TAccessForm.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessForm.Get_accChild 0034 @IntfClear 004b TAccessForm.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_507_0 {
	meta:
		name = "TAccessListBox.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessListBox.Get_accChild 0034 @IntfClear 004b TAccessListBox.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_600_0 {
	meta:
		name = "TAccessObjectFrame.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.Get_accChild 0034 @IntfClear 004b TAccessObjectFrame.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_217_0 {
	meta:
		name = "TAccessOptionButton.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionButton.Get_accChild 0034 @IntfClear 004b TAccessOptionButton.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_379_0 {
	meta:
		name = "TAccessOptionGroup.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.Get_accChild 0034 @IntfClear 004b TAccessOptionGroup.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_935_0 {
	meta:
		name = "TAccessPage.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessPage.Get_accChild 0034 @IntfClear 004b TAccessPage.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_759_0 {
	meta:
		name = "TAccessSubForm.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessSubForm.Get_accChild 0034 @IntfClear 004b TAccessSubForm.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_898_0 {
	meta:
		name = "TAccessTabControl.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTabControl.Get_accChild 0034 @IntfClear 004b TAccessTabControl.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_464_0 {
	meta:
		name = "TAccessTextBox.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTextBox.Get_accChild 0034 @IntfClear 004b TAccessTextBox.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_653_0 {
	meta:
		name = "TAccessToggleButton.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessToggleButton.Get_accChild 0034 @IntfClear 004b TAccessToggleButton.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2205_0 {
	meta:
		name = "TAdditionalData.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TAdditionalData.Get_Item 0034 @IntfClear 004b TAdditionalData.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2232_0 {
	meta:
		name = "TDependencyObjects.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TDependencyObjects.Get_Item 0034 @IntfClear 004b TDependencyObjects.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2444_0 {
	meta:
		name = "TFormOld.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TFormOld.Get_accChild 0034 @IntfClear 004b TFormOld.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2422_0 {
	meta:
		name = "TReturnVars.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TReturnVars.Get_Item 0034 @IntfClear 004b TReturnVars.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2262_0 {
	meta:
		name = "TSmartTags.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TSmartTags.Get_Item 0034 @IntfClear 004b TSmartTags.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2388_0 {
	meta:
		name = "TTempVars.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TTempVars.Get_Item 0034 @IntfClear 004b TTempVars.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_338_0 {
	meta:
		name = "T_CheckBoxInOption.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 T_CheckBoxInOption.Get_accChild 0034 @IntfClear 004b T_CheckBoxInOption.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_103_0 {
	meta:
		name = "T_ChildLabel.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 T_ChildLabel.Get_accChild 0034 @IntfClear 004b T_ChildLabel.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_852_0 {
	meta:
		name = "T_CustomControlInReport.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 T_CustomControlInReport.Get_accChild 0034 @IntfClear 004b T_CustomControlInReport.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_257_0 {
	meta:
		name = "T_OptionButtonInOption.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 T_OptionButtonInOption.Get_accChild 0034 @IntfClear 004b T_OptionButtonInOption.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_698_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 T_ToggleButtonInOption.Get_accChild 0034 @IntfClear 004b T_ToggleButtonInOption.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_70_0 {
	meta:
		name = "TAccessLabel.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessLabel.Get_accName 0034 @WStrClr 004b TAccessLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_421_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.Get_accName 0034 @WStrClr 004b TAccessBoundObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_298_0 {
	meta:
		name = "TAccessCheckBox.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCheckBox.Get_accName 0034 @WStrClr 004b TAccessCheckBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_555_0 {
	meta:
		name = "TAccessComboBox.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessComboBox.Get_accName 0034 @WStrClr 004b TAccessComboBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_175_0 {
	meta:
		name = "TAccessCommandButton.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCommandButton.Get_accName 0034 @WStrClr 004b TAccessCommandButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_807_0 {
	meta:
		name = "TAccessCustomControl.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCustomControl.Get_accName 0034 @WStrClr 004b TAccessCustomControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1013_0 {
	meta:
		name = "TAccessForm.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessForm.Get_accName 0034 @WStrClr 004b TAccessForm.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_508_0 {
	meta:
		name = "TAccessListBox.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessListBox.Get_accName 0034 @WStrClr 004b TAccessListBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_601_0 {
	meta:
		name = "TAccessObjectFrame.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.Get_accName 0034 @WStrClr 004b TAccessObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_218_0 {
	meta:
		name = "TAccessOptionButton.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionButton.Get_accName 0034 @WStrClr 004b TAccessOptionButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_380_0 {
	meta:
		name = "TAccessOptionGroup.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.Get_accName 0034 @WStrClr 004b TAccessOptionGroup.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_936_0 {
	meta:
		name = "TAccessPage.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessPage.Get_accName 0034 @WStrClr 004b TAccessPage.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_760_0 {
	meta:
		name = "TAccessSubForm.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessSubForm.Get_accName 0034 @WStrClr 004b TAccessSubForm.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_899_0 {
	meta:
		name = "TAccessTabControl.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTabControl.Get_accName 0034 @WStrClr 004b TAccessTabControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_465_0 {
	meta:
		name = "TAccessTextBox.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTextBox.Get_accName 0034 @WStrClr 004b TAccessTextBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_654_0 {
	meta:
		name = "TAccessToggleButton.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessToggleButton.Get_accName 0034 @WStrClr 004b TAccessToggleButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2445_0 {
	meta:
		name = "TFormOld.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TFormOld.Get_accName 0034 @WStrClr 004b TFormOld.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2292_0 {
	meta:
		name = "TSmartTagActions.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TSmartTagActions.Get_Item 0034 @IntfClear 004b TSmartTagActions.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2321_0 {
	meta:
		name = "TSmartTagProperties.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TSmartTagProperties.Get_Item 0034 @IntfClear 004b TSmartTagProperties.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_339_0 {
	meta:
		name = "T_CheckBoxInOption.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 T_CheckBoxInOption.Get_accName 0034 @WStrClr 004b T_CheckBoxInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_104_0 {
	meta:
		name = "T_ChildLabel.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 T_ChildLabel.Get_accName 0034 @WStrClr 004b T_ChildLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_853_0 {
	meta:
		name = "T_CustomControlInReport.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 T_CustomControlInReport.Get_accName 0034 @WStrClr 004b T_CustomControlInReport.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_258_0 {
	meta:
		name = "T_OptionButtonInOption.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 T_OptionButtonInOption.Get_accName 0034 @WStrClr 004b T_OptionButtonInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_699_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 T_ToggleButtonInOption.Get_accName 0034 @WStrClr 004b T_ToggleButtonInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_71_0 {
	meta:
		name = "TAccessLabel.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessLabel.Get_accValue 0034 @WStrClr 004b TAccessLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_422_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.Get_accValue 0034 @WStrClr 004b TAccessBoundObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_299_0 {
	meta:
		name = "TAccessCheckBox.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCheckBox.Get_accValue 0034 @WStrClr 004b TAccessCheckBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_556_0 {
	meta:
		name = "TAccessComboBox.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessComboBox.Get_accValue 0034 @WStrClr 004b TAccessComboBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_176_0 {
	meta:
		name = "TAccessCommandButton.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCommandButton.Get_accValue 0034 @WStrClr 004b TAccessCommandButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_808_0 {
	meta:
		name = "TAccessCustomControl.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCustomControl.Get_accValue 0034 @WStrClr 004b TAccessCustomControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1014_0 {
	meta:
		name = "TAccessForm.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessForm.Get_accValue 0034 @WStrClr 004b TAccessForm.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_509_0 {
	meta:
		name = "TAccessListBox.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessListBox.Get_accValue 0034 @WStrClr 004b TAccessListBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_602_0 {
	meta:
		name = "TAccessObjectFrame.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.Get_accValue 0034 @WStrClr 004b TAccessObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_219_0 {
	meta:
		name = "TAccessOptionButton.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionButton.Get_accValue 0034 @WStrClr 004b TAccessOptionButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_381_0 {
	meta:
		name = "TAccessOptionGroup.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.Get_accValue 0034 @WStrClr 004b TAccessOptionGroup.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_937_0 {
	meta:
		name = "TAccessPage.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessPage.Get_accValue 0034 @WStrClr 004b TAccessPage.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_761_0 {
	meta:
		name = "TAccessSubForm.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessSubForm.Get_accValue 0034 @WStrClr 004b TAccessSubForm.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_900_0 {
	meta:
		name = "TAccessTabControl.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTabControl.Get_accValue 0034 @WStrClr 004b TAccessTabControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_466_0 {
	meta:
		name = "TAccessTextBox.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTextBox.Get_accValue 0034 @WStrClr 004b TAccessTextBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_655_0 {
	meta:
		name = "TAccessToggleButton.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessToggleButton.Get_accValue 0034 @WStrClr 004b TAccessToggleButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_75796_0 {
	meta:
		name = "TCustomXMLParts.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TCustomXMLParts.Get_Item 0034 @IntfClear 004b TCustomXMLParts.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_75752_0 {
	meta:
		name = "TCustomXMLSchemaCollection.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TCustomXMLSchemaCollection.Get_Item 0034 @IntfClear 004b TCustomXMLSchemaCollection.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2446_0 {
	meta:
		name = "TFormOld.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TFormOld.Get_accValue 0034 @WStrClr 004b TFormOld.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_340_0 {
	meta:
		name = "T_CheckBoxInOption.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 T_CheckBoxInOption.Get_accValue 0034 @WStrClr 004b T_CheckBoxInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_105_0 {
	meta:
		name = "T_ChildLabel.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 T_ChildLabel.Get_accValue 0034 @WStrClr 004b T_ChildLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_854_0 {
	meta:
		name = "T_CustomControlInReport.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 T_CustomControlInReport.Get_accValue 0034 @WStrClr 004b T_CustomControlInReport.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_259_0 {
	meta:
		name = "T_OptionButtonInOption.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 T_OptionButtonInOption.Get_accValue 0034 @WStrClr 004b T_OptionButtonInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_700_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 T_ToggleButtonInOption.Get_accValue 0034 @WStrClr 004b T_ToggleButtonInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_72_0 {
	meta:
		name = "TAccessLabel.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessLabel.Get_accDescription 0034 @WStrClr 004b TAccessLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_423_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.Get_accDescription 0034 @WStrClr 004b TAccessBoundObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_300_0 {
	meta:
		name = "TAccessCheckBox.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCheckBox.Get_accDescription 0034 @WStrClr 004b TAccessCheckBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_557_0 {
	meta:
		name = "TAccessComboBox.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessComboBox.Get_accDescription 0034 @WStrClr 004b TAccessComboBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_177_0 {
	meta:
		name = "TAccessCommandButton.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCommandButton.Get_accDescription 0034 @WStrClr 004b TAccessCommandButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_809_0 {
	meta:
		name = "TAccessCustomControl.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCustomControl.Get_accDescription 0034 @WStrClr 004b TAccessCustomControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1015_0 {
	meta:
		name = "TAccessForm.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessForm.Get_accDescription 0034 @WStrClr 004b TAccessForm.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_510_0 {
	meta:
		name = "TAccessListBox.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessListBox.Get_accDescription 0034 @WStrClr 004b TAccessListBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_603_0 {
	meta:
		name = "TAccessObjectFrame.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.Get_accDescription 0034 @WStrClr 004b TAccessObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_220_0 {
	meta:
		name = "TAccessOptionButton.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionButton.Get_accDescription 0034 @WStrClr 004b TAccessOptionButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_382_0 {
	meta:
		name = "TAccessOptionGroup.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.Get_accDescription 0034 @WStrClr 004b TAccessOptionGroup.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_938_0 {
	meta:
		name = "TAccessPage.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessPage.Get_accDescription 0034 @WStrClr 004b TAccessPage.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_762_0 {
	meta:
		name = "TAccessSubForm.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessSubForm.Get_accDescription 0034 @WStrClr 004b TAccessSubForm.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_901_0 {
	meta:
		name = "TAccessTabControl.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTabControl.Get_accDescription 0034 @WStrClr 004b TAccessTabControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_467_0 {
	meta:
		name = "TAccessTextBox.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTextBox.Get_accDescription 0034 @WStrClr 004b TAccessTextBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_656_0 {
	meta:
		name = "TAccessToggleButton.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessToggleButton.Get_accDescription 0034 @WStrClr 004b TAccessToggleButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_76457_0 {
	meta:
		name = "TExplorers.Item"
		size = 137
		refs = "001f @VarAddRef 0027 TExplorers.Item 0034 @IntfClear 004b TExplorers.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_76492_0 {
	meta:
		name = "TFolders.Item"
		size = 137
		refs = "001f @VarAddRef 0027 TFolders.Item 0034 @IntfClear 004b TFolders.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2447_0 {
	meta:
		name = "TFormOld.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TFormOld.Get_accDescription 0034 @WStrClr 004b TFormOld.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_76474_0 {
	meta:
		name = "TInspectors.Item"
		size = 137
		refs = "001f @VarAddRef 0027 TInspectors.Item 0034 @IntfClear 004b TInspectors.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_76518_0 {
	meta:
		name = "TItems.Item"
		size = 137
		refs = "001f @VarAddRef 0027 TItems.Item 0034 @IntfClear 004b TItems.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_76673_0 {
	meta:
		name = "TOutlookBarGroups.Item"
		size = 137
		refs = "001f @VarAddRef 0027 TOutlookBarGroups.Item 0034 @IntfClear 004b TOutlookBarGroups.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_76712_0 {
	meta:
		name = "TOutlookBarShortcuts.Item"
		size = 137
		refs = "001f @VarAddRef 0027 TOutlookBarShortcuts.Item 0034 @IntfClear 004b TOutlookBarShortcuts.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_341_0 {
	meta:
		name = "T_CheckBoxInOption.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 T_CheckBoxInOption.Get_accDescription 0034 @WStrClr 004b T_CheckBoxInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_106_0 {
	meta:
		name = "T_ChildLabel.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 T_ChildLabel.Get_accDescription 0034 @WStrClr 004b T_ChildLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_855_0 {
	meta:
		name = "T_CustomControlInReport.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 T_CustomControlInReport.Get_accDescription 0034 @WStrClr 004b T_CustomControlInReport.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_260_0 {
	meta:
		name = "T_OptionButtonInOption.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 T_OptionButtonInOption.Get_accDescription 0034 @WStrClr 004b T_OptionButtonInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_701_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 T_ToggleButtonInOption.Get_accDescription 0034 @WStrClr 004b T_ToggleButtonInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_73_0 {
	meta:
		name = "TAccessLabel.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessLabel.Get_accRole 0034 @VarClr 004b TAccessLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_424_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.Get_accRole 0034 @VarClr 004b TAccessBoundObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_301_0 {
	meta:
		name = "TAccessCheckBox.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCheckBox.Get_accRole 0034 @VarClr 004b TAccessCheckBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_558_0 {
	meta:
		name = "TAccessComboBox.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessComboBox.Get_accRole 0034 @VarClr 004b TAccessComboBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_178_0 {
	meta:
		name = "TAccessCommandButton.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCommandButton.Get_accRole 0034 @VarClr 004b TAccessCommandButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_810_0 {
	meta:
		name = "TAccessCustomControl.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCustomControl.Get_accRole 0034 @VarClr 004b TAccessCustomControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1016_0 {
	meta:
		name = "TAccessForm.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessForm.Get_accRole 0034 @VarClr 004b TAccessForm.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_511_0 {
	meta:
		name = "TAccessListBox.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessListBox.Get_accRole 0034 @VarClr 004b TAccessListBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_604_0 {
	meta:
		name = "TAccessObjectFrame.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.Get_accRole 0034 @VarClr 004b TAccessObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_221_0 {
	meta:
		name = "TAccessOptionButton.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionButton.Get_accRole 0034 @VarClr 004b TAccessOptionButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_383_0 {
	meta:
		name = "TAccessOptionGroup.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.Get_accRole 0034 @VarClr 004b TAccessOptionGroup.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_939_0 {
	meta:
		name = "TAccessPage.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessPage.Get_accRole 0034 @VarClr 004b TAccessPage.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_763_0 {
	meta:
		name = "TAccessSubForm.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessSubForm.Get_accRole 0034 @VarClr 004b TAccessSubForm.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_902_0 {
	meta:
		name = "TAccessTabControl.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTabControl.Get_accRole 0034 @VarClr 004b TAccessTabControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_468_0 {
	meta:
		name = "TAccessTextBox.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTextBox.Get_accRole 0034 @VarClr 004b TAccessTextBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_657_0 {
	meta:
		name = "TAccessToggleButton.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessToggleButton.Get_accRole 0034 @VarClr 004b TAccessToggleButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_342_0 {
	meta:
		name = "T_CheckBoxInOption.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 T_CheckBoxInOption.Get_accRole 0034 @VarClr 004b T_CheckBoxInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_107_0 {
	meta:
		name = "T_ChildLabel.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 T_ChildLabel.Get_accRole 0034 @VarClr 004b T_ChildLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_856_0 {
	meta:
		name = "T_CustomControlInReport.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 T_CustomControlInReport.Get_accRole 0034 @VarClr 004b T_CustomControlInReport.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_261_0 {
	meta:
		name = "T_OptionButtonInOption.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 T_OptionButtonInOption.Get_accRole 0034 @VarClr 004b T_OptionButtonInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_702_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_accRole"
		size = 137
		refs = "001f @VarAddRef 0027 T_ToggleButtonInOption.Get_accRole 0034 @VarClr 004b T_ToggleButtonInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_74_0 {
	meta:
		name = "TAccessLabel.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessLabel.Get_accState 0034 @VarClr 004b TAccessLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_425_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.Get_accState 0034 @VarClr 004b TAccessBoundObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_302_0 {
	meta:
		name = "TAccessCheckBox.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCheckBox.Get_accState 0034 @VarClr 004b TAccessCheckBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_559_0 {
	meta:
		name = "TAccessComboBox.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessComboBox.Get_accState 0034 @VarClr 004b TAccessComboBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_179_0 {
	meta:
		name = "TAccessCommandButton.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCommandButton.Get_accState 0034 @VarClr 004b TAccessCommandButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_811_0 {
	meta:
		name = "TAccessCustomControl.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCustomControl.Get_accState 0034 @VarClr 004b TAccessCustomControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1017_0 {
	meta:
		name = "TAccessForm.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessForm.Get_accState 0034 @VarClr 004b TAccessForm.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_512_0 {
	meta:
		name = "TAccessListBox.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessListBox.Get_accState 0034 @VarClr 004b TAccessListBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_605_0 {
	meta:
		name = "TAccessObjectFrame.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.Get_accState 0034 @VarClr 004b TAccessObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_222_0 {
	meta:
		name = "TAccessOptionButton.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionButton.Get_accState 0034 @VarClr 004b TAccessOptionButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_384_0 {
	meta:
		name = "TAccessOptionGroup.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.Get_accState 0034 @VarClr 004b TAccessOptionGroup.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_940_0 {
	meta:
		name = "TAccessPage.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessPage.Get_accState 0034 @VarClr 004b TAccessPage.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_764_0 {
	meta:
		name = "TAccessSubForm.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessSubForm.Get_accState 0034 @VarClr 004b TAccessSubForm.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_903_0 {
	meta:
		name = "TAccessTabControl.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTabControl.Get_accState 0034 @VarClr 004b TAccessTabControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_469_0 {
	meta:
		name = "TAccessTextBox.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTextBox.Get_accState 0034 @VarClr 004b TAccessTextBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_658_0 {
	meta:
		name = "TAccessToggleButton.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessToggleButton.Get_accState 0034 @VarClr 004b TAccessToggleButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_343_0 {
	meta:
		name = "T_CheckBoxInOption.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 T_CheckBoxInOption.Get_accState 0034 @VarClr 004b T_CheckBoxInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_108_0 {
	meta:
		name = "T_ChildLabel.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 T_ChildLabel.Get_accState 0034 @VarClr 004b T_ChildLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_857_0 {
	meta:
		name = "T_CustomControlInReport.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 T_CustomControlInReport.Get_accState 0034 @VarClr 004b T_CustomControlInReport.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_262_0 {
	meta:
		name = "T_OptionButtonInOption.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 T_OptionButtonInOption.Get_accState 0034 @VarClr 004b T_OptionButtonInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_703_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_accState"
		size = 137
		refs = "001f @VarAddRef 0027 T_ToggleButtonInOption.Get_accState 0034 @VarClr 004b T_ToggleButtonInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_75_0 {
	meta:
		name = "TAccessLabel.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessLabel.Get_accHelp 0034 @WStrClr 004b TAccessLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_426_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.Get_accHelp 0034 @WStrClr 004b TAccessBoundObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_303_0 {
	meta:
		name = "TAccessCheckBox.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCheckBox.Get_accHelp 0034 @WStrClr 004b TAccessCheckBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_560_0 {
	meta:
		name = "TAccessComboBox.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessComboBox.Get_accHelp 0034 @WStrClr 004b TAccessComboBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_180_0 {
	meta:
		name = "TAccessCommandButton.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCommandButton.Get_accHelp 0034 @WStrClr 004b TAccessCommandButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_812_0 {
	meta:
		name = "TAccessCustomControl.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCustomControl.Get_accHelp 0034 @WStrClr 004b TAccessCustomControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1018_0 {
	meta:
		name = "TAccessForm.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessForm.Get_accHelp 0034 @WStrClr 004b TAccessForm.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_513_0 {
	meta:
		name = "TAccessListBox.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessListBox.Get_accHelp 0034 @WStrClr 004b TAccessListBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_606_0 {
	meta:
		name = "TAccessObjectFrame.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.Get_accHelp 0034 @WStrClr 004b TAccessObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_223_0 {
	meta:
		name = "TAccessOptionButton.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionButton.Get_accHelp 0034 @WStrClr 004b TAccessOptionButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_385_0 {
	meta:
		name = "TAccessOptionGroup.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.Get_accHelp 0034 @WStrClr 004b TAccessOptionGroup.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_941_0 {
	meta:
		name = "TAccessPage.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessPage.Get_accHelp 0034 @WStrClr 004b TAccessPage.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_765_0 {
	meta:
		name = "TAccessSubForm.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessSubForm.Get_accHelp 0034 @WStrClr 004b TAccessSubForm.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_904_0 {
	meta:
		name = "TAccessTabControl.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTabControl.Get_accHelp 0034 @WStrClr 004b TAccessTabControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_470_0 {
	meta:
		name = "TAccessTextBox.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTextBox.Get_accHelp 0034 @WStrClr 004b TAccessTextBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_659_0 {
	meta:
		name = "TAccessToggleButton.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessToggleButton.Get_accHelp 0034 @WStrClr 004b TAccessToggleButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2450_0 {
	meta:
		name = "TFormOld.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TFormOld.Get_accHelp 0034 @WStrClr 004b TFormOld.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_344_0 {
	meta:
		name = "T_CheckBoxInOption.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 T_CheckBoxInOption.Get_accHelp 0034 @WStrClr 004b T_CheckBoxInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_109_0 {
	meta:
		name = "T_ChildLabel.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 T_ChildLabel.Get_accHelp 0034 @WStrClr 004b T_ChildLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_858_0 {
	meta:
		name = "T_CustomControlInReport.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 T_CustomControlInReport.Get_accHelp 0034 @WStrClr 004b T_CustomControlInReport.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_263_0 {
	meta:
		name = "T_OptionButtonInOption.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 T_OptionButtonInOption.Get_accHelp 0034 @WStrClr 004b T_OptionButtonInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_704_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 T_ToggleButtonInOption.Get_accHelp 0034 @WStrClr 004b T_ToggleButtonInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_76_0 {
	meta:
		name = "TAccessLabel.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessLabel.Get_accHelpTopic 0051 @WStrClr 005c TAccessLabel.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_427_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessBoundObjectFrame.Get_accHelpTopic 0051 @WStrClr 005c TAccessBoundObjectFrame.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_304_0 {
	meta:
		name = "TAccessCheckBox.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessCheckBox.Get_accHelpTopic 0051 @WStrClr 005c TAccessCheckBox.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_561_0 {
	meta:
		name = "TAccessComboBox.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessComboBox.Get_accHelpTopic 0051 @WStrClr 005c TAccessComboBox.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_181_0 {
	meta:
		name = "TAccessCommandButton.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessCommandButton.Get_accHelpTopic 0051 @WStrClr 005c TAccessCommandButton.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_813_0 {
	meta:
		name = "TAccessCustomControl.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessCustomControl.Get_accHelpTopic 0051 @WStrClr 005c TAccessCustomControl.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1019_0 {
	meta:
		name = "TAccessForm.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessForm.Get_accHelpTopic 0051 @WStrClr 005c TAccessForm.GetDefaultInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_514_0 {
	meta:
		name = "TAccessListBox.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessListBox.Get_accHelpTopic 0051 @WStrClr 005c TAccessListBox.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_607_0 {
	meta:
		name = "TAccessObjectFrame.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessObjectFrame.Get_accHelpTopic 0051 @WStrClr 005c TAccessObjectFrame.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_224_0 {
	meta:
		name = "TAccessOptionButton.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessOptionButton.Get_accHelpTopic 0051 @WStrClr 005c TAccessOptionButton.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_386_0 {
	meta:
		name = "TAccessOptionGroup.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessOptionGroup.Get_accHelpTopic 0051 @WStrClr 005c TAccessOptionGroup.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_942_0 {
	meta:
		name = "TAccessPage.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessPage.Get_accHelpTopic 0051 @WStrClr 005c TAccessPage.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_766_0 {
	meta:
		name = "TAccessSubForm.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessSubForm.Get_accHelpTopic 0051 @WStrClr 005c TAccessSubForm.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_905_0 {
	meta:
		name = "TAccessTabControl.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessTabControl.Get_accHelpTopic 0051 @WStrClr 005c TAccessTabControl.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_471_0 {
	meta:
		name = "TAccessTextBox.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessTextBox.Get_accHelpTopic 0051 @WStrClr 005c TAccessTextBox.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_660_0 {
	meta:
		name = "TAccessToggleButton.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessToggleButton.Get_accHelpTopic 0051 @WStrClr 005c TAccessToggleButton.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2451_0 {
	meta:
		name = "TFormOld.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TFormOld.Get_accHelpTopic 0051 @WStrClr 005c TFormOld.GetDefaultInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_345_0 {
	meta:
		name = "T_CheckBoxInOption.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 T_CheckBoxInOption.Get_accHelpTopic 0051 @WStrClr 005c T_CheckBoxInOption.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_110_0 {
	meta:
		name = "T_ChildLabel.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 T_ChildLabel.Get_accHelpTopic 0051 @WStrClr 005c T_ChildLabel.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_859_0 {
	meta:
		name = "T_CustomControlInReport.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 T_CustomControlInReport.Get_accHelpTopic 0051 @WStrClr 005c T_CustomControlInReport.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_264_0 {
	meta:
		name = "T_OptionButtonInOption.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 T_OptionButtonInOption.Get_accHelpTopic 0051 @WStrClr 005c T_OptionButtonInOption.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_705_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 T_ToggleButtonInOption.Get_accHelpTopic 0051 @WStrClr 005c T_ToggleButtonInOption.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_77_0 {
	meta:
		name = "TAccessLabel.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessLabel.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_428_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessBoundObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_305_0 {
	meta:
		name = "TAccessCheckBox.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCheckBox.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessCheckBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_562_0 {
	meta:
		name = "TAccessComboBox.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessComboBox.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessComboBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_182_0 {
	meta:
		name = "TAccessCommandButton.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCommandButton.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessCommandButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_814_0 {
	meta:
		name = "TAccessCustomControl.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCustomControl.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessCustomControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1020_0 {
	meta:
		name = "TAccessForm.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessForm.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessForm.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_515_0 {
	meta:
		name = "TAccessListBox.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessListBox.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessListBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_608_0 {
	meta:
		name = "TAccessObjectFrame.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_225_0 {
	meta:
		name = "TAccessOptionButton.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionButton.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessOptionButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_387_0 {
	meta:
		name = "TAccessOptionGroup.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessOptionGroup.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_943_0 {
	meta:
		name = "TAccessPage.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessPage.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessPage.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_767_0 {
	meta:
		name = "TAccessSubForm.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessSubForm.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessSubForm.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_906_0 {
	meta:
		name = "TAccessTabControl.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTabControl.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessTabControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_472_0 {
	meta:
		name = "TAccessTextBox.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTextBox.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessTextBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_661_0 {
	meta:
		name = "TAccessToggleButton.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessToggleButton.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessToggleButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2452_0 {
	meta:
		name = "TFormOld.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TFormOld.Get_accKeyboardShortcut 0034 @WStrClr 004b TFormOld.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_346_0 {
	meta:
		name = "T_CheckBoxInOption.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 T_CheckBoxInOption.Get_accKeyboardShortcut 0034 @WStrClr 004b T_CheckBoxInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_111_0 {
	meta:
		name = "T_ChildLabel.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 T_ChildLabel.Get_accKeyboardShortcut 0034 @WStrClr 004b T_ChildLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_860_0 {
	meta:
		name = "T_CustomControlInReport.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 T_CustomControlInReport.Get_accKeyboardShortcut 0034 @WStrClr 004b T_CustomControlInReport.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_265_0 {
	meta:
		name = "T_OptionButtonInOption.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 T_OptionButtonInOption.Get_accKeyboardShortcut 0034 @WStrClr 004b T_OptionButtonInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_706_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 T_ToggleButtonInOption.Get_accKeyboardShortcut 0034 @WStrClr 004b T_ToggleButtonInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_79_0 {
	meta:
		name = "TAccessLabel.Get_accSelection"
		size = 91
		refs = "000f TAccessLabel.Get_accSelection 001c @VarClr 0027 TAccessLabel.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_430_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accSelection"
		size = 91
		refs = "000f TAccessBoundObjectFrame.Get_accSelection 001c @VarClr 0027 TAccessBoundObjectFrame.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_307_0 {
	meta:
		name = "TAccessCheckBox.Get_accSelection"
		size = 91
		refs = "000f TAccessCheckBox.Get_accSelection 001c @VarClr 0027 TAccessCheckBox.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_564_0 {
	meta:
		name = "TAccessComboBox.Get_accSelection"
		size = 91
		refs = "000f TAccessComboBox.Get_accSelection 001c @VarClr 0027 TAccessComboBox.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_184_0 {
	meta:
		name = "TAccessCommandButton.Get_accSelection"
		size = 91
		refs = "000f TAccessCommandButton.Get_accSelection 001c @VarClr 0027 TAccessCommandButton.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_816_0 {
	meta:
		name = "TAccessCustomControl.Get_accSelection"
		size = 91
		refs = "000f TAccessCustomControl.Get_accSelection 001c @VarClr 0027 TAccessCustomControl.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1022_0 {
	meta:
		name = "TAccessForm.Get_accSelection"
		size = 91
		refs = "000f TAccessForm.Get_accSelection 001c @VarClr 0027 TAccessForm.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_517_0 {
	meta:
		name = "TAccessListBox.Get_accSelection"
		size = 91
		refs = "000f TAccessListBox.Get_accSelection 001c @VarClr 0027 TAccessListBox.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_610_0 {
	meta:
		name = "TAccessObjectFrame.Get_accSelection"
		size = 91
		refs = "000f TAccessObjectFrame.Get_accSelection 001c @VarClr 0027 TAccessObjectFrame.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_227_0 {
	meta:
		name = "TAccessOptionButton.Get_accSelection"
		size = 91
		refs = "000f TAccessOptionButton.Get_accSelection 001c @VarClr 0027 TAccessOptionButton.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_389_0 {
	meta:
		name = "TAccessOptionGroup.Get_accSelection"
		size = 91
		refs = "000f TAccessOptionGroup.Get_accSelection 001c @VarClr 0027 TAccessOptionGroup.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_945_0 {
	meta:
		name = "TAccessPage.Get_accSelection"
		size = 91
		refs = "000f TAccessPage.Get_accSelection 001c @VarClr 0027 TAccessPage.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1376_0 {
	meta:
		name = "TAccessReport.Get_ServerFilter"
		size = 91
		refs = "000f TAccessReport.Get_ServerFilter 001c @WStrClr 0027 TAccessReport.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_769_0 {
	meta:
		name = "TAccessSubForm.Get_accSelection"
		size = 91
		refs = "000f TAccessSubForm.Get_accSelection 001c @VarClr 0027 TAccessSubForm.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_908_0 {
	meta:
		name = "TAccessTabControl.Get_accSelection"
		size = 91
		refs = "000f TAccessTabControl.Get_accSelection 001c @VarClr 0027 TAccessTabControl.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_474_0 {
	meta:
		name = "TAccessTextBox.Get_accSelection"
		size = 91
		refs = "000f TAccessTextBox.Get_accSelection 001c @VarClr 0027 TAccessTextBox.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_663_0 {
	meta:
		name = "TAccessToggleButton.Get_accSelection"
		size = 91
		refs = "000f TAccessToggleButton.Get_accSelection 001c @VarClr 0027 TAccessToggleButton.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76052_0 {
	meta:
		name = "TContactItem.Get_Companies"
		size = 91
		refs = "000f TContactItem.Get_Companies 001c @WStrClr 0027 TContactItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76329_0 {
	meta:
		name = "TDistListItem.Get_Companies"
		size = 91
		refs = "000f TDistListItem.Get_Companies 001c @WStrClr 0027 TDistListItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76402_0 {
	meta:
		name = "TDocumentItem.Get_Companies"
		size = 91
		refs = "000f TDocumentItem.Get_Companies 001c @WStrClr 0027 TDocumentItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_53464_0 {
	meta:
		name = "TExcelApplication.Get_AddIns"
		size = 91
		refs = "000f TExcelApplication.Get_AddIns 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52791_0 {
	meta:
		name = "TExcelGlobal.Get_AddIns"
		size = 91
		refs = "000f TExcelGlobal.Get_AddIns 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76523_0 {
	meta:
		name = "TItems.GetFirst"
		size = 91
		refs = "000f TItems.GetFirst 001c @IntfClear 0027 TItems.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76555_0 {
	meta:
		name = "TJournalItem.Get_Companies"
		size = 91
		refs = "000f TJournalItem.Get_Companies 001c @WStrClr 0027 TJournalItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75883_0 {
	meta:
		name = "TMailItem.Get_Companies"
		size = 91
		refs = "000f TMailItem.Get_Companies 001c @WStrClr 0027 TMailItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75719_0 {
	meta:
		name = "TMaster.Get_TextStyles"
		size = 91
		refs = "000f TMaster.Get_TextStyles 001c @IntfClear 0027 TMaster.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76738_0 {
	meta:
		name = "TPostItem.Get_Companies"
		size = 91
		refs = "000f TPostItem.Get_Companies 001c @WStrClr 0027 TPostItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75658_0 {
	meta:
		name = "TPowerPointApplication.Get_FileSearch"
		size = 91
		refs = "000f TPowerPointApplication.Get_FileSearch 001c @IntfClear 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75554_0 {
	meta:
		name = "TPowerPointPresentation.Get_ColorSchemes"
		size = 91
		refs = "000f TPowerPointPresentation.Get_ColorSchemes 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76811_0 {
	meta:
		name = "TRemoteItem.Get_Companies"
		size = 91
		refs = "000f TRemoteItem.Get_Companies 001c @WStrClr 0027 TRemoteItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76877_0 {
	meta:
		name = "TReportItem.Get_Companies"
		size = 91
		refs = "000f TReportItem.Get_Companies 001c @WStrClr 0027 TReportItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2808_0 {
	meta:
		name = "TReportOld.Get_ServerFilter"
		size = 91
		refs = "000f TReportOld.Get_ServerFilter 001c @WStrClr 0027 TReportOld.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76939_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_Companies"
		size = 91
		refs = "000f TTaskRequestAcceptItem.Get_Companies 001c @WStrClr 0027 TTaskRequestAcceptItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77002_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_Companies"
		size = 91
		refs = "000f TTaskRequestDeclineItem.Get_Companies 001c @WStrClr 0027 TTaskRequestDeclineItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77065_0 {
	meta:
		name = "TTaskRequestItem.Get_Companies"
		size = 91
		refs = "000f TTaskRequestItem.Get_Companies 001c @WStrClr 0027 TTaskRequestItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77128_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_Companies"
		size = 91
		refs = "000f TTaskRequestUpdateItem.Get_Companies 001c @WStrClr 0027 TTaskRequestUpdateItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149205_0 {
	meta:
		name = "TWordApplication.Get_System_"
		size = 91
		refs = "000f TWordApplication.Get_System_ 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_348_0 {
	meta:
		name = "T_CheckBoxInOption.Get_accSelection"
		size = 91
		refs = "000f T_CheckBoxInOption.Get_accSelection 001c @VarClr 0027 T_CheckBoxInOption.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_113_0 {
	meta:
		name = "T_ChildLabel.Get_accSelection"
		size = 91
		refs = "000f T_ChildLabel.Get_accSelection 001c @VarClr 0027 T_ChildLabel.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_862_0 {
	meta:
		name = "T_CustomControlInReport.Get_accSelection"
		size = 91
		refs = "000f T_CustomControlInReport.Get_accSelection 001c @VarClr 0027 T_CustomControlInReport.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_267_0 {
	meta:
		name = "T_OptionButtonInOption.Get_accSelection"
		size = 91
		refs = "000f T_OptionButtonInOption.Get_accSelection 001c @VarClr 0027 T_OptionButtonInOption.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_708_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_accSelection"
		size = 91
		refs = "000f T_ToggleButtonInOption.Get_accSelection 001c @VarClr 0027 T_ToggleButtonInOption.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_80_0 {
	meta:
		name = "TAccessLabel.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessLabel.Get_accDefaultAction 0034 @WStrClr 004b TAccessLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_431_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.Get_accDefaultAction 0034 @WStrClr 004b TAccessBoundObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_308_0 {
	meta:
		name = "TAccessCheckBox.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCheckBox.Get_accDefaultAction 0034 @WStrClr 004b TAccessCheckBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_565_0 {
	meta:
		name = "TAccessComboBox.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessComboBox.Get_accDefaultAction 0034 @WStrClr 004b TAccessComboBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_185_0 {
	meta:
		name = "TAccessCommandButton.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCommandButton.Get_accDefaultAction 0034 @WStrClr 004b TAccessCommandButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_817_0 {
	meta:
		name = "TAccessCustomControl.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCustomControl.Get_accDefaultAction 0034 @WStrClr 004b TAccessCustomControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1023_0 {
	meta:
		name = "TAccessForm.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessForm.Get_accDefaultAction 0034 @WStrClr 004b TAccessForm.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_518_0 {
	meta:
		name = "TAccessListBox.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessListBox.Get_accDefaultAction 0034 @WStrClr 004b TAccessListBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_611_0 {
	meta:
		name = "TAccessObjectFrame.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.Get_accDefaultAction 0034 @WStrClr 004b TAccessObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_228_0 {
	meta:
		name = "TAccessOptionButton.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionButton.Get_accDefaultAction 0034 @WStrClr 004b TAccessOptionButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_390_0 {
	meta:
		name = "TAccessOptionGroup.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.Get_accDefaultAction 0034 @WStrClr 004b TAccessOptionGroup.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_946_0 {
	meta:
		name = "TAccessPage.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessPage.Get_accDefaultAction 0034 @WStrClr 004b TAccessPage.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_770_0 {
	meta:
		name = "TAccessSubForm.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessSubForm.Get_accDefaultAction 0034 @WStrClr 004b TAccessSubForm.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_909_0 {
	meta:
		name = "TAccessTabControl.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTabControl.Get_accDefaultAction 0034 @WStrClr 004b TAccessTabControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_475_0 {
	meta:
		name = "TAccessTextBox.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTextBox.Get_accDefaultAction 0034 @WStrClr 004b TAccessTextBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_664_0 {
	meta:
		name = "TAccessToggleButton.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessToggleButton.Get_accDefaultAction 0034 @WStrClr 004b TAccessToggleButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2455_0 {
	meta:
		name = "TFormOld.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TFormOld.Get_accDefaultAction 0034 @WStrClr 004b TFormOld.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_349_0 {
	meta:
		name = "T_CheckBoxInOption.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 T_CheckBoxInOption.Get_accDefaultAction 0034 @WStrClr 004b T_CheckBoxInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_114_0 {
	meta:
		name = "T_ChildLabel.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 T_ChildLabel.Get_accDefaultAction 0034 @WStrClr 004b T_ChildLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_863_0 {
	meta:
		name = "T_CustomControlInReport.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 T_CustomControlInReport.Get_accDefaultAction 0034 @WStrClr 004b T_CustomControlInReport.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_268_0 {
	meta:
		name = "T_OptionButtonInOption.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 T_OptionButtonInOption.Get_accDefaultAction 0034 @WStrClr 004b T_OptionButtonInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_709_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 T_ToggleButtonInOption.Get_accDefaultAction 0034 @WStrClr 004b T_ToggleButtonInOption.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_81_0 {
	meta:
		name = "TAccessLabel.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessLabel.Set_accName 0044 TAccessLabel.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_432_0 {
	meta:
		name = "TAccessBoundObjectFrame.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.Set_accName 0044 TAccessBoundObjectFrame.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_309_0 {
	meta:
		name = "TAccessCheckBox.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessCheckBox.Set_accName 0044 TAccessCheckBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_566_0 {
	meta:
		name = "TAccessComboBox.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessComboBox.Set_accName 0044 TAccessComboBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_186_0 {
	meta:
		name = "TAccessCommandButton.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessCommandButton.Set_accName 0044 TAccessCommandButton.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_818_0 {
	meta:
		name = "TAccessCustomControl.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessCustomControl.Set_accName 0044 TAccessCustomControl.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1024_0 {
	meta:
		name = "TAccessForm.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessForm.Set_accName 0044 TAccessForm.GetDefaultInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_519_0 {
	meta:
		name = "TAccessListBox.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessListBox.Set_accName 0044 TAccessListBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_612_0 {
	meta:
		name = "TAccessObjectFrame.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.Set_accName 0044 TAccessObjectFrame.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_229_0 {
	meta:
		name = "TAccessOptionButton.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessOptionButton.Set_accName 0044 TAccessOptionButton.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_391_0 {
	meta:
		name = "TAccessOptionGroup.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.Set_accName 0044 TAccessOptionGroup.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_947_0 {
	meta:
		name = "TAccessPage.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessPage.Set_accName 0044 TAccessPage.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_771_0 {
	meta:
		name = "TAccessSubForm.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessSubForm.Set_accName 0044 TAccessSubForm.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_910_0 {
	meta:
		name = "TAccessTabControl.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessTabControl.Set_accName 0044 TAccessTabControl.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_476_0 {
	meta:
		name = "TAccessTextBox.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessTextBox.Set_accName 0044 TAccessTextBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_665_0 {
	meta:
		name = "TAccessToggleButton.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessToggleButton.Set_accName 0044 TAccessToggleButton.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2456_0 {
	meta:
		name = "TFormOld.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 TFormOld.Set_accName 0044 TFormOld.GetDefaultInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_350_0 {
	meta:
		name = "T_CheckBoxInOption.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 T_CheckBoxInOption.Set_accName 0044 T_CheckBoxInOption.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_115_0 {
	meta:
		name = "T_ChildLabel.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 T_ChildLabel.Set_accName 0044 T_ChildLabel.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_864_0 {
	meta:
		name = "T_CustomControlInReport.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 T_CustomControlInReport.Set_accName 0044 T_CustomControlInReport.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_269_0 {
	meta:
		name = "T_OptionButtonInOption.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 T_OptionButtonInOption.Set_accName 0044 T_OptionButtonInOption.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_710_0 {
	meta:
		name = "T_ToggleButtonInOption.Set_accName"
		size = 130
		refs = "001f @VarAddRef 0027 T_ToggleButtonInOption.Set_accName 0044 T_ToggleButtonInOption.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_82_0 {
	meta:
		name = "TAccessLabel.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessLabel.Set_accValue 0044 TAccessLabel.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_433_0 {
	meta:
		name = "TAccessBoundObjectFrame.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.Set_accValue 0044 TAccessBoundObjectFrame.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_310_0 {
	meta:
		name = "TAccessCheckBox.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessCheckBox.Set_accValue 0044 TAccessCheckBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_567_0 {
	meta:
		name = "TAccessComboBox.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessComboBox.Set_accValue 0044 TAccessComboBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_187_0 {
	meta:
		name = "TAccessCommandButton.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessCommandButton.Set_accValue 0044 TAccessCommandButton.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_819_0 {
	meta:
		name = "TAccessCustomControl.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessCustomControl.Set_accValue 0044 TAccessCustomControl.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1025_0 {
	meta:
		name = "TAccessForm.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessForm.Set_accValue 0044 TAccessForm.GetDefaultInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_520_0 {
	meta:
		name = "TAccessListBox.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessListBox.Set_accValue 0044 TAccessListBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_613_0 {
	meta:
		name = "TAccessObjectFrame.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.Set_accValue 0044 TAccessObjectFrame.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_230_0 {
	meta:
		name = "TAccessOptionButton.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessOptionButton.Set_accValue 0044 TAccessOptionButton.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_392_0 {
	meta:
		name = "TAccessOptionGroup.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.Set_accValue 0044 TAccessOptionGroup.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_948_0 {
	meta:
		name = "TAccessPage.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessPage.Set_accValue 0044 TAccessPage.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_772_0 {
	meta:
		name = "TAccessSubForm.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessSubForm.Set_accValue 0044 TAccessSubForm.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_911_0 {
	meta:
		name = "TAccessTabControl.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessTabControl.Set_accValue 0044 TAccessTabControl.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_477_0 {
	meta:
		name = "TAccessTextBox.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessTextBox.Set_accValue 0044 TAccessTextBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_666_0 {
	meta:
		name = "TAccessToggleButton.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessToggleButton.Set_accValue 0044 TAccessToggleButton.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2457_0 {
	meta:
		name = "TFormOld.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 TFormOld.Set_accValue 0044 TFormOld.GetDefaultInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_351_0 {
	meta:
		name = "T_CheckBoxInOption.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 T_CheckBoxInOption.Set_accValue 0044 T_CheckBoxInOption.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_116_0 {
	meta:
		name = "T_ChildLabel.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 T_ChildLabel.Set_accValue 0044 T_ChildLabel.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_865_0 {
	meta:
		name = "T_CustomControlInReport.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 T_CustomControlInReport.Set_accValue 0044 T_CustomControlInReport.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_270_0 {
	meta:
		name = "T_OptionButtonInOption.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 T_OptionButtonInOption.Set_accValue 0044 T_OptionButtonInOption.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_711_0 {
	meta:
		name = "T_ToggleButtonInOption.Set_accValue"
		size = 130
		refs = "001f @VarAddRef 0027 T_ToggleButtonInOption.Set_accValue 0044 T_ToggleButtonInOption.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_85_0 {
	meta:
		name = "TAccessLabel.Get_Properties"
		size = 91
		refs = "000f TAccessLabel.Get_Properties 001c @IntfClear 0027 TAccessLabel.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_436_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_OldValue"
		size = 91
		refs = "000f TAccessBoundObjectFrame.Get_OldValue 001c @VarClr 0027 TAccessBoundObjectFrame.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_190_0 {
	meta:
		name = "TAccessCommandButton.Get_OldValue"
		size = 91
		refs = "000f TAccessCommandButton.Get_OldValue 001c @VarClr 0027 TAccessCommandButton.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_822_0 {
	meta:
		name = "TAccessCustomControl.Get_OldValue"
		size = 91
		refs = "000f TAccessCustomControl.Get_OldValue 001c @VarClr 0027 TAccessCustomControl.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1028_0 {
	meta:
		name = "TAccessForm.Get_RecordSource"
		size = 91
		refs = "000f TAccessForm.Get_RecordSource 001c @WStrClr 0027 TAccessForm.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_616_0 {
	meta:
		name = "TAccessObjectFrame.Get_OldValue"
		size = 91
		refs = "000f TAccessObjectFrame.Get_OldValue 001c @VarClr 0027 TAccessObjectFrame.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_233_0 {
	meta:
		name = "TAccessOptionButton.Get_OldValue"
		size = 91
		refs = "000f TAccessOptionButton.Get_OldValue 001c @VarClr 0027 TAccessOptionButton.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_951_0 {
	meta:
		name = "TAccessPage.Get_Properties"
		size = 91
		refs = "000f TAccessPage.Get_Properties 001c @IntfClear 0027 TAccessPage.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_775_0 {
	meta:
		name = "TAccessSubForm.Get_Form"
		size = 91
		refs = "000f TAccessSubForm.Get_Form 001c @IntfClear 0027 TAccessSubForm.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_914_0 {
	meta:
		name = "TAccessTabControl.Get_OldValue"
		size = 91
		refs = "000f TAccessTabControl.Get_OldValue 001c @VarClr 0027 TAccessTabControl.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4871_0 {
	meta:
		name = "TBinder.Get_DefaultFilePath"
		size = 91
		refs = "000f TBinder.Get_DefaultFilePath 001c @WStrClr 0027 TBinder.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76063_0 {
	meta:
		name = "TContactItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TContactItem.Get_MAPIOBJECT 001c @IntfClear 0027 TContactItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76340_0 {
	meta:
		name = "TDistListItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TDistListItem.Get_MAPIOBJECT 001c @IntfClear 0027 TDistListItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76413_0 {
	meta:
		name = "TDocumentItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TDocumentItem.Get_MAPIOBJECT 001c @IntfClear 0027 TDocumentItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2460_0 {
	meta:
		name = "TFormOld.Get_RecordSource"
		size = 91
		refs = "000f TFormOld.Get_RecordSource 001c @WStrClr 0027 TFormOld.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78207_0 {
	meta:
		name = "TInternetExplorer.Get_LocationURL"
		size = 91
		refs = "000f TInternetExplorer.Get_LocationURL 001c @WStrClr 0027 TInternetExplorer.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78294_0 {
	meta:
		name = "TInternetExplorerMedium.Get_LocationURL"
		size = 91
		refs = "000f TInternetExplorerMedium.Get_LocationURL 001c @WStrClr 0027 TInternetExplorerMedium.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76566_0 {
	meta:
		name = "TJournalItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TJournalItem.Get_MAPIOBJECT 001c @IntfClear 0027 TJournalItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75894_0 {
	meta:
		name = "TMailItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TMailItem.Get_MAPIOBJECT 001c @IntfClear 0027 TMailItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76749_0 {
	meta:
		name = "TPostItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TPostItem.Get_MAPIOBJECT 001c @IntfClear 0027 TPostItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75565_0 {
	meta:
		name = "TPowerPointPresentation.Get_FullName"
		size = 91
		refs = "000f TPowerPointPresentation.Get_FullName 001c @WStrClr 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76822_0 {
	meta:
		name = "TRemoteItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TRemoteItem.Get_MAPIOBJECT 001c @IntfClear 0027 TRemoteItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76888_0 {
	meta:
		name = "TReportItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TReportItem.Get_MAPIOBJECT 001c @IntfClear 0027 TReportItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76950_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TTaskRequestAcceptItem.Get_MAPIOBJECT 001c @IntfClear 0027 TTaskRequestAcceptItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77013_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TTaskRequestDeclineItem.Get_MAPIOBJECT 001c @IntfClear 0027 TTaskRequestDeclineItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77076_0 {
	meta:
		name = "TTaskRequestItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TTaskRequestItem.Get_MAPIOBJECT 001c @IntfClear 0027 TTaskRequestItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77139_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TTaskRequestUpdateItem.Get_MAPIOBJECT 001c @IntfClear 0027 TTaskRequestUpdateItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149818_0 {
	meta:
		name = "TWordApplication.Get_CaptionLabels"
		size = 91
		refs = "000f TWordApplication.Get_CaptionLabels 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148576_0 {
	meta:
		name = "TWordDocument.Get_Words"
		size = 91
		refs = "000f TWordDocument.Get_Words 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_119_0 {
	meta:
		name = "T_ChildLabel.Get_Properties"
		size = 91
		refs = "000f T_ChildLabel.Get_Properties 001c @IntfClear 0027 T_ChildLabel.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_868_0 {
	meta:
		name = "T_CustomControlInReport.Get_OldValue"
		size = 91
		refs = "000f T_CustomControlInReport.Get_OldValue 001c @VarClr 0027 T_CustomControlInReport.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_273_0 {
	meta:
		name = "T_OptionButtonInOption.Get_OldValue"
		size = 91
		refs = "000f T_OptionButtonInOption.Get_OldValue 001c @VarClr 0027 T_OptionButtonInOption.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_86_0 {
	meta:
		name = "TAccessLabel.Get_Hyperlink"
		size = 94
		refs = "000f TAccessLabel.Get_Hyperlink 001c @IntfClear 0027 TAccessLabel.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_439_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_Properties"
		size = 94
		refs = "000f TAccessBoundObjectFrame.Get_Properties 001c @IntfClear 0027 TAccessBoundObjectFrame.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_571_0 {
	meta:
		name = "TAccessComboBox.Get_OldValue"
		size = 94
		refs = "000f TAccessComboBox.Get_OldValue 001c @VarClr 0027 TAccessComboBox.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_825_0 {
	meta:
		name = "TAccessCustomControl.Get_Properties"
		size = 94
		refs = "000f TAccessCustomControl.Get_Properties 001c @IntfClear 0027 TAccessCustomControl.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_619_0 {
	meta:
		name = "TAccessObjectFrame.Get_Properties"
		size = 94
		refs = "000f TAccessObjectFrame.Get_Properties 001c @IntfClear 0027 TAccessObjectFrame.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_916_0 {
	meta:
		name = "TAccessTabControl.Get_Pages"
		size = 94
		refs = "000f TAccessTabControl.Get_Pages 001c @IntfClear 0027 TAccessTabControl.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76066_0 {
	meta:
		name = "TContactItem.Get_Mileage"
		size = 94
		refs = "000f TContactItem.Get_Mileage 001c @WStrClr 0027 TContactItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76343_0 {
	meta:
		name = "TDistListItem.Get_Mileage"
		size = 94
		refs = "000f TDistListItem.Get_Mileage 001c @WStrClr 0027 TDistListItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76416_0 {
	meta:
		name = "TDocumentItem.Get_Mileage"
		size = 94
		refs = "000f TDocumentItem.Get_Mileage 001c @WStrClr 0027 TDocumentItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52993_0 {
	meta:
		name = "TExcelWorkbook.Get_CommandBars"
		size = 94
		refs = "000f TExcelWorkbook.Get_CommandBars 001c @IntfClear 0027 TExcelWorkbook.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76569_0 {
	meta:
		name = "TJournalItem.Get_Mileage"
		size = 94
		refs = "000f TJournalItem.Get_Mileage 001c @WStrClr 0027 TJournalItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75897_0 {
	meta:
		name = "TMailItem.Get_Mileage"
		size = 94
		refs = "000f TMailItem.Get_Mileage 001c @WStrClr 0027 TMailItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76752_0 {
	meta:
		name = "TPostItem.Get_Mileage"
		size = 94
		refs = "000f TPostItem.Get_Mileage 001c @WStrClr 0027 TPostItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75524_0 {
	meta:
		name = "TPowerPointSlide.Get_NotesPage"
		size = 94
		refs = "000f TPowerPointSlide.Get_NotesPage 001c @IntfClear 0027 TPowerPointSlide.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76825_0 {
	meta:
		name = "TRemoteItem.Get_Mileage"
		size = 94
		refs = "000f TRemoteItem.Get_Mileage 001c @WStrClr 0027 TRemoteItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76891_0 {
	meta:
		name = "TReportItem.Get_Mileage"
		size = 94
		refs = "000f TReportItem.Get_Mileage 001c @WStrClr 0027 TReportItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76953_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_Mileage"
		size = 94
		refs = "000f TTaskRequestAcceptItem.Get_Mileage 001c @WStrClr 0027 TTaskRequestAcceptItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77016_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_Mileage"
		size = 94
		refs = "000f TTaskRequestDeclineItem.Get_Mileage 001c @WStrClr 0027 TTaskRequestDeclineItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77079_0 {
	meta:
		name = "TTaskRequestItem.Get_Mileage"
		size = 94
		refs = "000f TTaskRequestItem.Get_Mileage 001c @WStrClr 0027 TTaskRequestItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77142_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_Mileage"
		size = 94
		refs = "000f TTaskRequestUpdateItem.Get_Mileage 001c @WStrClr 0027 TTaskRequestUpdateItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3284_0 {
	meta:
		name = "TWizHook.LocalFont"
		size = 94
		refs = "000f TWizHook.LocalFont 001c @WStrClr 0027 TWizHook.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148579_0 {
	meta:
		name = "TWordDocument.Get_Fields"
		size = 94
		refs = "000f TWordDocument.Get_Fields 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149143_0 {
	meta:
		name = "TWordLetterContent.Get_RecipientReference"
		size = 94
		refs = "000f TWordLetterContent.Get_RecipientReference 001c @WStrClr 0027 TWordLetterContent.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_120_0 {
	meta:
		name = "T_ChildLabel.Get_Hyperlink"
		size = 94
		refs = "000f T_ChildLabel.Get_Hyperlink 001c @IntfClear 0027 T_ChildLabel.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_871_0 {
	meta:
		name = "T_CustomControlInReport.Get_Properties"
		size = 94
		refs = "000f T_CustomControlInReport.Get_Properties 001c @IntfClear 0027 T_CustomControlInReport.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_87_0 {
	meta:
		name = "TAccessLabel.accSelect"
		size = 118
		refs = "0014 TAccessLabel.accSelect 0022 EmptyParam 0039 TAccessLabel.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_445_0 {
	meta:
		name = "TAccessBoundObjectFrame.accSelect"
		size = 118
		refs = "0014 TAccessBoundObjectFrame.accSelect 0022 EmptyParam 0039 TAccessBoundObjectFrame.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_318_0 {
	meta:
		name = "TAccessCheckBox.accSelect"
		size = 118
		refs = "0014 TAccessCheckBox.accSelect 0022 EmptyParam 0039 TAccessCheckBox.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_579_0 {
	meta:
		name = "TAccessComboBox.accSelect"
		size = 118
		refs = "0014 TAccessComboBox.accSelect 0022 EmptyParam 0039 TAccessComboBox.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_198_0 {
	meta:
		name = "TAccessCommandButton.accSelect"
		size = 118
		refs = "0014 TAccessCommandButton.accSelect 0022 EmptyParam 0039 TAccessCommandButton.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_833_0 {
	meta:
		name = "TAccessCustomControl.accSelect"
		size = 118
		refs = "0014 TAccessCustomControl.accSelect 0022 EmptyParam 0039 TAccessCustomControl.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1337_0 {
	meta:
		name = "TAccessForm.accSelect"
		size = 118
		refs = "0014 TAccessForm.accSelect 0022 EmptyParam 0039 TAccessForm.GetDefaultInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_534_0 {
	meta:
		name = "TAccessListBox.accSelect"
		size = 118
		refs = "0014 TAccessListBox.accSelect 0022 EmptyParam 0039 TAccessListBox.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_625_0 {
	meta:
		name = "TAccessObjectFrame.accSelect"
		size = 118
		refs = "0014 TAccessObjectFrame.accSelect 0022 EmptyParam 0039 TAccessObjectFrame.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_238_0 {
	meta:
		name = "TAccessOptionButton.accSelect"
		size = 118
		refs = "0014 TAccessOptionButton.accSelect 0022 EmptyParam 0039 TAccessOptionButton.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_400_0 {
	meta:
		name = "TAccessOptionGroup.accSelect"
		size = 118
		refs = "0014 TAccessOptionGroup.accSelect 0022 EmptyParam 0039 TAccessOptionGroup.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_955_0 {
	meta:
		name = "TAccessPage.accSelect"
		size = 118
		refs = "0014 TAccessPage.accSelect 0022 EmptyParam 0039 TAccessPage.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_779_0 {
	meta:
		name = "TAccessSubForm.accSelect"
		size = 118
		refs = "0014 TAccessSubForm.accSelect 0022 EmptyParam 0039 TAccessSubForm.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_919_0 {
	meta:
		name = "TAccessTabControl.accSelect"
		size = 118
		refs = "0014 TAccessTabControl.accSelect 0022 EmptyParam 0039 TAccessTabControl.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_487_0 {
	meta:
		name = "TAccessTextBox.accSelect"
		size = 118
		refs = "0014 TAccessTextBox.accSelect 0022 EmptyParam 0039 TAccessTextBox.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_678_0 {
	meta:
		name = "TAccessToggleButton.accSelect"
		size = 118
		refs = "0014 TAccessToggleButton.accSelect 0022 EmptyParam 0039 TAccessToggleButton.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2769_0 {
	meta:
		name = "TFormOld.accSelect"
		size = 118
		refs = "0014 TFormOld.accSelect 0022 EmptyParam 0039 TFormOld.GetDefaultInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_359_0 {
	meta:
		name = "T_CheckBoxInOption.accSelect"
		size = 118
		refs = "0014 T_CheckBoxInOption.accSelect 0022 EmptyParam 0039 T_CheckBoxInOption.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_121_0 {
	meta:
		name = "T_ChildLabel.accSelect"
		size = 118
		refs = "0014 T_ChildLabel.accSelect 0022 EmptyParam 0039 T_ChildLabel.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_879_0 {
	meta:
		name = "T_CustomControlInReport.accSelect"
		size = 118
		refs = "0014 T_CustomControlInReport.accSelect 0022 EmptyParam 0039 T_CustomControlInReport.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_278_0 {
	meta:
		name = "T_OptionButtonInOption.accSelect"
		size = 118
		refs = "0014 T_OptionButtonInOption.accSelect 0022 EmptyParam 0039 T_OptionButtonInOption.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_723_0 {
	meta:
		name = "T_ToggleButtonInOption.accSelect"
		size = 118
		refs = "0014 T_ToggleButtonInOption.accSelect 0022 EmptyParam 0039 T_ToggleButtonInOption.GetControlInterface 0047 @CheckAutoResult 005c @IntfClear 0064 @VarClr 006a @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_88_0 {
	meta:
		name = "TAccessLabel.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessLabel.accSelect 0044 TAccessLabel.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_446_0 {
	meta:
		name = "TAccessBoundObjectFrame.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.accSelect 0044 TAccessBoundObjectFrame.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_319_0 {
	meta:
		name = "TAccessCheckBox.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessCheckBox.accSelect 0044 TAccessCheckBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_580_0 {
	meta:
		name = "TAccessComboBox.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessComboBox.accSelect 0044 TAccessComboBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_199_0 {
	meta:
		name = "TAccessCommandButton.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessCommandButton.accSelect 0044 TAccessCommandButton.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_834_0 {
	meta:
		name = "TAccessCustomControl.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessCustomControl.accSelect 0044 TAccessCustomControl.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1338_0 {
	meta:
		name = "TAccessForm.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessForm.accSelect 0044 TAccessForm.GetDefaultInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_535_0 {
	meta:
		name = "TAccessListBox.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessListBox.accSelect 0044 TAccessListBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_626_0 {
	meta:
		name = "TAccessObjectFrame.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.accSelect 0044 TAccessObjectFrame.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_239_0 {
	meta:
		name = "TAccessOptionButton.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessOptionButton.accSelect 0044 TAccessOptionButton.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_401_0 {
	meta:
		name = "TAccessOptionGroup.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.accSelect 0044 TAccessOptionGroup.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_956_0 {
	meta:
		name = "TAccessPage.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessPage.accSelect 0044 TAccessPage.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_780_0 {
	meta:
		name = "TAccessSubForm.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessSubForm.accSelect 0044 TAccessSubForm.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_920_0 {
	meta:
		name = "TAccessTabControl.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessTabControl.accSelect 0044 TAccessTabControl.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_488_0 {
	meta:
		name = "TAccessTextBox.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessTextBox.accSelect 0044 TAccessTextBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_679_0 {
	meta:
		name = "TAccessToggleButton.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessToggleButton.accSelect 0044 TAccessToggleButton.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2770_0 {
	meta:
		name = "TFormOld.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TFormOld.accSelect 0044 TFormOld.GetDefaultInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_360_0 {
	meta:
		name = "T_CheckBoxInOption.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 T_CheckBoxInOption.accSelect 0044 T_CheckBoxInOption.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_122_0 {
	meta:
		name = "T_ChildLabel.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 T_ChildLabel.accSelect 0044 T_ChildLabel.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_880_0 {
	meta:
		name = "T_CustomControlInReport.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 T_CustomControlInReport.accSelect 0044 T_CustomControlInReport.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_279_0 {
	meta:
		name = "T_OptionButtonInOption.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 T_OptionButtonInOption.accSelect 0044 T_OptionButtonInOption.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_724_0 {
	meta:
		name = "T_ToggleButtonInOption.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 T_ToggleButtonInOption.accSelect 0044 T_ToggleButtonInOption.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_89_0 {
	meta:
		name = "TAccessLabel.accLocation"
		size = 136
		refs = "001a TAccessLabel.accLocation 0028 EmptyParam 0048 TAccessLabel.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_447_0 {
	meta:
		name = "TAccessBoundObjectFrame.accLocation"
		size = 136
		refs = "001a TAccessBoundObjectFrame.accLocation 0028 EmptyParam 0048 TAccessBoundObjectFrame.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_320_0 {
	meta:
		name = "TAccessCheckBox.accLocation"
		size = 136
		refs = "001a TAccessCheckBox.accLocation 0028 EmptyParam 0048 TAccessCheckBox.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_581_0 {
	meta:
		name = "TAccessComboBox.accLocation"
		size = 136
		refs = "001a TAccessComboBox.accLocation 0028 EmptyParam 0048 TAccessComboBox.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_200_0 {
	meta:
		name = "TAccessCommandButton.accLocation"
		size = 136
		refs = "001a TAccessCommandButton.accLocation 0028 EmptyParam 0048 TAccessCommandButton.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_835_0 {
	meta:
		name = "TAccessCustomControl.accLocation"
		size = 136
		refs = "001a TAccessCustomControl.accLocation 0028 EmptyParam 0048 TAccessCustomControl.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_1339_0 {
	meta:
		name = "TAccessForm.accLocation"
		size = 136
		refs = "001a TAccessForm.accLocation 0028 EmptyParam 0048 TAccessForm.GetDefaultInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_536_0 {
	meta:
		name = "TAccessListBox.accLocation"
		size = 136
		refs = "001a TAccessListBox.accLocation 0028 EmptyParam 0048 TAccessListBox.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_627_0 {
	meta:
		name = "TAccessObjectFrame.accLocation"
		size = 136
		refs = "001a TAccessObjectFrame.accLocation 0028 EmptyParam 0048 TAccessObjectFrame.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_240_0 {
	meta:
		name = "TAccessOptionButton.accLocation"
		size = 136
		refs = "001a TAccessOptionButton.accLocation 0028 EmptyParam 0048 TAccessOptionButton.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_402_0 {
	meta:
		name = "TAccessOptionGroup.accLocation"
		size = 136
		refs = "001a TAccessOptionGroup.accLocation 0028 EmptyParam 0048 TAccessOptionGroup.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_957_0 {
	meta:
		name = "TAccessPage.accLocation"
		size = 136
		refs = "001a TAccessPage.accLocation 0028 EmptyParam 0048 TAccessPage.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_781_0 {
	meta:
		name = "TAccessSubForm.accLocation"
		size = 136
		refs = "001a TAccessSubForm.accLocation 0028 EmptyParam 0048 TAccessSubForm.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_921_0 {
	meta:
		name = "TAccessTabControl.accLocation"
		size = 136
		refs = "001a TAccessTabControl.accLocation 0028 EmptyParam 0048 TAccessTabControl.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_489_0 {
	meta:
		name = "TAccessTextBox.accLocation"
		size = 136
		refs = "001a TAccessTextBox.accLocation 0028 EmptyParam 0048 TAccessTextBox.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_680_0 {
	meta:
		name = "TAccessToggleButton.accLocation"
		size = 136
		refs = "001a TAccessToggleButton.accLocation 0028 EmptyParam 0048 TAccessToggleButton.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_2771_0 {
	meta:
		name = "TFormOld.accLocation"
		size = 136
		refs = "001a TFormOld.accLocation 0028 EmptyParam 0048 TFormOld.GetDefaultInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_361_0 {
	meta:
		name = "T_CheckBoxInOption.accLocation"
		size = 136
		refs = "001a T_CheckBoxInOption.accLocation 0028 EmptyParam 0048 T_CheckBoxInOption.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_123_0 {
	meta:
		name = "T_ChildLabel.accLocation"
		size = 136
		refs = "001a T_ChildLabel.accLocation 0028 EmptyParam 0048 T_ChildLabel.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_881_0 {
	meta:
		name = "T_CustomControlInReport.accLocation"
		size = 136
		refs = "001a T_CustomControlInReport.accLocation 0028 EmptyParam 0048 T_CustomControlInReport.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_280_0 {
	meta:
		name = "T_OptionButtonInOption.accLocation"
		size = 136
		refs = "001a T_OptionButtonInOption.accLocation 0028 EmptyParam 0048 T_OptionButtonInOption.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_725_0 {
	meta:
		name = "T_ToggleButtonInOption.accLocation"
		size = 136
		refs = "001a T_ToggleButtonInOption.accLocation 0028 EmptyParam 0048 T_ToggleButtonInOption.GetControlInterface 0056 @CheckAutoResult 006b @IntfClear 0073 @VarClr 0079 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 08 50 8B 45 0C 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_90_0 {
	meta:
		name = "TAccessLabel.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessLabel.accLocation 0050 TAccessLabel.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_448_0 {
	meta:
		name = "TAccessBoundObjectFrame.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessBoundObjectFrame.accLocation 0050 TAccessBoundObjectFrame.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_321_0 {
	meta:
		name = "TAccessCheckBox.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessCheckBox.accLocation 0050 TAccessCheckBox.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_582_0 {
	meta:
		name = "TAccessComboBox.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessComboBox.accLocation 0050 TAccessComboBox.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_201_0 {
	meta:
		name = "TAccessCommandButton.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessCommandButton.accLocation 0050 TAccessCommandButton.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_836_0 {
	meta:
		name = "TAccessCustomControl.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessCustomControl.accLocation 0050 TAccessCustomControl.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_1340_0 {
	meta:
		name = "TAccessForm.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessForm.accLocation 0050 TAccessForm.GetDefaultInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_537_0 {
	meta:
		name = "TAccessListBox.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessListBox.accLocation 0050 TAccessListBox.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_628_0 {
	meta:
		name = "TAccessObjectFrame.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessObjectFrame.accLocation 0050 TAccessObjectFrame.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_241_0 {
	meta:
		name = "TAccessOptionButton.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessOptionButton.accLocation 0050 TAccessOptionButton.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_403_0 {
	meta:
		name = "TAccessOptionGroup.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessOptionGroup.accLocation 0050 TAccessOptionGroup.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_958_0 {
	meta:
		name = "TAccessPage.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessPage.accLocation 0050 TAccessPage.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_782_0 {
	meta:
		name = "TAccessSubForm.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessSubForm.accLocation 0050 TAccessSubForm.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_922_0 {
	meta:
		name = "TAccessTabControl.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessTabControl.accLocation 0050 TAccessTabControl.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_490_0 {
	meta:
		name = "TAccessTextBox.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessTextBox.accLocation 0050 TAccessTextBox.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_681_0 {
	meta:
		name = "TAccessToggleButton.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessToggleButton.accLocation 0050 TAccessToggleButton.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_2772_0 {
	meta:
		name = "TFormOld.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TFormOld.accLocation 0050 TFormOld.GetDefaultInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_362_0 {
	meta:
		name = "T_CheckBoxInOption.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a T_CheckBoxInOption.accLocation 0050 T_CheckBoxInOption.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_124_0 {
	meta:
		name = "T_ChildLabel.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a T_ChildLabel.accLocation 0050 T_ChildLabel.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_882_0 {
	meta:
		name = "T_CustomControlInReport.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a T_CustomControlInReport.accLocation 0050 T_CustomControlInReport.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_281_0 {
	meta:
		name = "T_OptionButtonInOption.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a T_OptionButtonInOption.accLocation 0050 T_OptionButtonInOption.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_726_0 {
	meta:
		name = "T_ToggleButtonInOption.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a T_ToggleButtonInOption.accLocation 0050 T_ToggleButtonInOption.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_91_0 {
	meta:
		name = "TAccessLabel.accNavigate"
		size = 133
		refs = "001a TAccessLabel.accNavigate 0028 EmptyParam 002f @VarClr 0047 TAccessLabel.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_449_0 {
	meta:
		name = "TAccessBoundObjectFrame.accNavigate"
		size = 133
		refs = "001a TAccessBoundObjectFrame.accNavigate 0028 EmptyParam 002f @VarClr 0047 TAccessBoundObjectFrame.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_322_0 {
	meta:
		name = "TAccessCheckBox.accNavigate"
		size = 133
		refs = "001a TAccessCheckBox.accNavigate 0028 EmptyParam 002f @VarClr 0047 TAccessCheckBox.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_583_0 {
	meta:
		name = "TAccessComboBox.accNavigate"
		size = 133
		refs = "001a TAccessComboBox.accNavigate 0028 EmptyParam 002f @VarClr 0047 TAccessComboBox.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_202_0 {
	meta:
		name = "TAccessCommandButton.accNavigate"
		size = 133
		refs = "001a TAccessCommandButton.accNavigate 0028 EmptyParam 002f @VarClr 0047 TAccessCommandButton.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_837_0 {
	meta:
		name = "TAccessCustomControl.accNavigate"
		size = 133
		refs = "001a TAccessCustomControl.accNavigate 0028 EmptyParam 002f @VarClr 0047 TAccessCustomControl.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1341_0 {
	meta:
		name = "TAccessForm.accNavigate"
		size = 133
		refs = "001a TAccessForm.accNavigate 0028 EmptyParam 002f @VarClr 0047 TAccessForm.GetDefaultInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_538_0 {
	meta:
		name = "TAccessListBox.accNavigate"
		size = 133
		refs = "001a TAccessListBox.accNavigate 0028 EmptyParam 002f @VarClr 0047 TAccessListBox.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_629_0 {
	meta:
		name = "TAccessObjectFrame.accNavigate"
		size = 133
		refs = "001a TAccessObjectFrame.accNavigate 0028 EmptyParam 002f @VarClr 0047 TAccessObjectFrame.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_242_0 {
	meta:
		name = "TAccessOptionButton.accNavigate"
		size = 133
		refs = "001a TAccessOptionButton.accNavigate 0028 EmptyParam 002f @VarClr 0047 TAccessOptionButton.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_404_0 {
	meta:
		name = "TAccessOptionGroup.accNavigate"
		size = 133
		refs = "001a TAccessOptionGroup.accNavigate 0028 EmptyParam 002f @VarClr 0047 TAccessOptionGroup.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_959_0 {
	meta:
		name = "TAccessPage.accNavigate"
		size = 133
		refs = "001a TAccessPage.accNavigate 0028 EmptyParam 002f @VarClr 0047 TAccessPage.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_783_0 {
	meta:
		name = "TAccessSubForm.accNavigate"
		size = 133
		refs = "001a TAccessSubForm.accNavigate 0028 EmptyParam 002f @VarClr 0047 TAccessSubForm.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_923_0 {
	meta:
		name = "TAccessTabControl.accNavigate"
		size = 133
		refs = "001a TAccessTabControl.accNavigate 0028 EmptyParam 002f @VarClr 0047 TAccessTabControl.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_491_0 {
	meta:
		name = "TAccessTextBox.accNavigate"
		size = 133
		refs = "001a TAccessTextBox.accNavigate 0028 EmptyParam 002f @VarClr 0047 TAccessTextBox.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_682_0 {
	meta:
		name = "TAccessToggleButton.accNavigate"
		size = 133
		refs = "001a TAccessToggleButton.accNavigate 0028 EmptyParam 002f @VarClr 0047 TAccessToggleButton.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2773_0 {
	meta:
		name = "TFormOld.accNavigate"
		size = 133
		refs = "001a TFormOld.accNavigate 0028 EmptyParam 002f @VarClr 0047 TFormOld.GetDefaultInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_363_0 {
	meta:
		name = "T_CheckBoxInOption.accNavigate"
		size = 133
		refs = "001a T_CheckBoxInOption.accNavigate 0028 EmptyParam 002f @VarClr 0047 T_CheckBoxInOption.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_125_0 {
	meta:
		name = "T_ChildLabel.accNavigate"
		size = 133
		refs = "001a T_ChildLabel.accNavigate 0028 EmptyParam 002f @VarClr 0047 T_ChildLabel.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_883_0 {
	meta:
		name = "T_CustomControlInReport.accNavigate"
		size = 133
		refs = "001a T_CustomControlInReport.accNavigate 0028 EmptyParam 002f @VarClr 0047 T_CustomControlInReport.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_282_0 {
	meta:
		name = "T_OptionButtonInOption.accNavigate"
		size = 133
		refs = "001a T_OptionButtonInOption.accNavigate 0028 EmptyParam 002f @VarClr 0047 T_OptionButtonInOption.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_727_0 {
	meta:
		name = "T_ToggleButtonInOption.accNavigate"
		size = 133
		refs = "001a T_ToggleButtonInOption.accNavigate 0028 EmptyParam 002f @VarClr 0047 T_ToggleButtonInOption.GetControlInterface 0055 @CheckAutoResult 006a @IntfClear 0078 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_92_0 {
	meta:
		name = "TAccessLabel.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessLabel.accNavigate 0035 @VarClr 004d TAccessLabel.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_450_0 {
	meta:
		name = "TAccessBoundObjectFrame.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.accNavigate 0035 @VarClr 004d TAccessBoundObjectFrame.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_323_0 {
	meta:
		name = "TAccessCheckBox.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessCheckBox.accNavigate 0035 @VarClr 004d TAccessCheckBox.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_584_0 {
	meta:
		name = "TAccessComboBox.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessComboBox.accNavigate 0035 @VarClr 004d TAccessComboBox.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_203_0 {
	meta:
		name = "TAccessCommandButton.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessCommandButton.accNavigate 0035 @VarClr 004d TAccessCommandButton.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_838_0 {
	meta:
		name = "TAccessCustomControl.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessCustomControl.accNavigate 0035 @VarClr 004d TAccessCustomControl.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_1342_0 {
	meta:
		name = "TAccessForm.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessForm.accNavigate 0035 @VarClr 004d TAccessForm.GetDefaultInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_539_0 {
	meta:
		name = "TAccessListBox.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessListBox.accNavigate 0035 @VarClr 004d TAccessListBox.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_630_0 {
	meta:
		name = "TAccessObjectFrame.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.accNavigate 0035 @VarClr 004d TAccessObjectFrame.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_243_0 {
	meta:
		name = "TAccessOptionButton.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessOptionButton.accNavigate 0035 @VarClr 004d TAccessOptionButton.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_405_0 {
	meta:
		name = "TAccessOptionGroup.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.accNavigate 0035 @VarClr 004d TAccessOptionGroup.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_960_0 {
	meta:
		name = "TAccessPage.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessPage.accNavigate 0035 @VarClr 004d TAccessPage.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_784_0 {
	meta:
		name = "TAccessSubForm.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessSubForm.accNavigate 0035 @VarClr 004d TAccessSubForm.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_924_0 {
	meta:
		name = "TAccessTabControl.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessTabControl.accNavigate 0035 @VarClr 004d TAccessTabControl.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_492_0 {
	meta:
		name = "TAccessTextBox.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessTextBox.accNavigate 0035 @VarClr 004d TAccessTextBox.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_683_0 {
	meta:
		name = "TAccessToggleButton.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessToggleButton.accNavigate 0035 @VarClr 004d TAccessToggleButton.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_2774_0 {
	meta:
		name = "TFormOld.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TFormOld.accNavigate 0035 @VarClr 004d TFormOld.GetDefaultInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_364_0 {
	meta:
		name = "T_CheckBoxInOption.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 T_CheckBoxInOption.accNavigate 0035 @VarClr 004d T_CheckBoxInOption.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_126_0 {
	meta:
		name = "T_ChildLabel.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 T_ChildLabel.accNavigate 0035 @VarClr 004d T_ChildLabel.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_884_0 {
	meta:
		name = "T_CustomControlInReport.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 T_CustomControlInReport.accNavigate 0035 @VarClr 004d T_CustomControlInReport.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_283_0 {
	meta:
		name = "T_OptionButtonInOption.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 T_OptionButtonInOption.accNavigate 0035 @VarClr 004d T_OptionButtonInOption.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_728_0 {
	meta:
		name = "T_ToggleButtonInOption.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 T_ToggleButtonInOption.accNavigate 0035 @VarClr 004d T_ToggleButtonInOption.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_93_0 {
	meta:
		name = "TAccessLabel.accHitTest"
		size = 100
		refs = "0012 TAccessLabel.accHitTest 0020 @VarClr 002d TAccessLabel.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_451_0 {
	meta:
		name = "TAccessBoundObjectFrame.accHitTest"
		size = 100
		refs = "0012 TAccessBoundObjectFrame.accHitTest 0020 @VarClr 002d TAccessBoundObjectFrame.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_324_0 {
	meta:
		name = "TAccessCheckBox.accHitTest"
		size = 100
		refs = "0012 TAccessCheckBox.accHitTest 0020 @VarClr 002d TAccessCheckBox.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_585_0 {
	meta:
		name = "TAccessComboBox.accHitTest"
		size = 100
		refs = "0012 TAccessComboBox.accHitTest 0020 @VarClr 002d TAccessComboBox.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_204_0 {
	meta:
		name = "TAccessCommandButton.accHitTest"
		size = 100
		refs = "0012 TAccessCommandButton.accHitTest 0020 @VarClr 002d TAccessCommandButton.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_839_0 {
	meta:
		name = "TAccessCustomControl.accHitTest"
		size = 100
		refs = "0012 TAccessCustomControl.accHitTest 0020 @VarClr 002d TAccessCustomControl.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1343_0 {
	meta:
		name = "TAccessForm.accHitTest"
		size = 100
		refs = "0012 TAccessForm.accHitTest 0020 @VarClr 002d TAccessForm.GetDefaultInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_540_0 {
	meta:
		name = "TAccessListBox.accHitTest"
		size = 100
		refs = "0012 TAccessListBox.accHitTest 0020 @VarClr 002d TAccessListBox.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_631_0 {
	meta:
		name = "TAccessObjectFrame.accHitTest"
		size = 100
		refs = "0012 TAccessObjectFrame.accHitTest 0020 @VarClr 002d TAccessObjectFrame.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_244_0 {
	meta:
		name = "TAccessOptionButton.accHitTest"
		size = 100
		refs = "0012 TAccessOptionButton.accHitTest 0020 @VarClr 002d TAccessOptionButton.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_406_0 {
	meta:
		name = "TAccessOptionGroup.accHitTest"
		size = 100
		refs = "0012 TAccessOptionGroup.accHitTest 0020 @VarClr 002d TAccessOptionGroup.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_961_0 {
	meta:
		name = "TAccessPage.accHitTest"
		size = 100
		refs = "0012 TAccessPage.accHitTest 0020 @VarClr 002d TAccessPage.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_785_0 {
	meta:
		name = "TAccessSubForm.accHitTest"
		size = 100
		refs = "0012 TAccessSubForm.accHitTest 0020 @VarClr 002d TAccessSubForm.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_925_0 {
	meta:
		name = "TAccessTabControl.accHitTest"
		size = 100
		refs = "0012 TAccessTabControl.accHitTest 0020 @VarClr 002d TAccessTabControl.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_493_0 {
	meta:
		name = "TAccessTextBox.accHitTest"
		size = 100
		refs = "0012 TAccessTextBox.accHitTest 0020 @VarClr 002d TAccessTextBox.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_684_0 {
	meta:
		name = "TAccessToggleButton.accHitTest"
		size = 100
		refs = "0012 TAccessToggleButton.accHitTest 0020 @VarClr 002d TAccessToggleButton.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_2775_0 {
	meta:
		name = "TFormOld.accHitTest"
		size = 100
		refs = "0012 TFormOld.accHitTest 0020 @VarClr 002d TFormOld.GetDefaultInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_365_0 {
	meta:
		name = "T_CheckBoxInOption.accHitTest"
		size = 100
		refs = "0012 T_CheckBoxInOption.accHitTest 0020 @VarClr 002d T_CheckBoxInOption.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_127_0 {
	meta:
		name = "T_ChildLabel.accHitTest"
		size = 100
		refs = "0012 T_ChildLabel.accHitTest 0020 @VarClr 002d T_ChildLabel.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_885_0 {
	meta:
		name = "T_CustomControlInReport.accHitTest"
		size = 100
		refs = "0012 T_CustomControlInReport.accHitTest 0020 @VarClr 002d T_CustomControlInReport.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_284_0 {
	meta:
		name = "T_OptionButtonInOption.accHitTest"
		size = 100
		refs = "0012 T_OptionButtonInOption.accHitTest 0020 @VarClr 002d T_OptionButtonInOption.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_729_0 {
	meta:
		name = "T_ToggleButtonInOption.accHitTest"
		size = 100
		refs = "0012 T_ToggleButtonInOption.accHitTest 0020 @VarClr 002d T_ToggleButtonInOption.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_94_0 {
	meta:
		name = "TAccessLabel.accDoDefaultAction"
		size = 113
		refs = "0011 TAccessLabel.accDoDefaultAction 001f EmptyParam 0035 TAccessLabel.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_452_0 {
	meta:
		name = "TAccessBoundObjectFrame.accDoDefaultAction"
		size = 113
		refs = "0011 TAccessBoundObjectFrame.accDoDefaultAction 001f EmptyParam 0035 TAccessBoundObjectFrame.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_325_0 {
	meta:
		name = "TAccessCheckBox.accDoDefaultAction"
		size = 113
		refs = "0011 TAccessCheckBox.accDoDefaultAction 001f EmptyParam 0035 TAccessCheckBox.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_586_0 {
	meta:
		name = "TAccessComboBox.accDoDefaultAction"
		size = 113
		refs = "0011 TAccessComboBox.accDoDefaultAction 001f EmptyParam 0035 TAccessComboBox.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_205_0 {
	meta:
		name = "TAccessCommandButton.accDoDefaultAction"
		size = 113
		refs = "0011 TAccessCommandButton.accDoDefaultAction 001f EmptyParam 0035 TAccessCommandButton.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_840_0 {
	meta:
		name = "TAccessCustomControl.accDoDefaultAction"
		size = 113
		refs = "0011 TAccessCustomControl.accDoDefaultAction 001f EmptyParam 0035 TAccessCustomControl.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1344_0 {
	meta:
		name = "TAccessForm.accDoDefaultAction"
		size = 113
		refs = "0011 TAccessForm.accDoDefaultAction 001f EmptyParam 0035 TAccessForm.GetDefaultInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_541_0 {
	meta:
		name = "TAccessListBox.accDoDefaultAction"
		size = 113
		refs = "0011 TAccessListBox.accDoDefaultAction 001f EmptyParam 0035 TAccessListBox.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_632_0 {
	meta:
		name = "TAccessObjectFrame.accDoDefaultAction"
		size = 113
		refs = "0011 TAccessObjectFrame.accDoDefaultAction 001f EmptyParam 0035 TAccessObjectFrame.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_245_0 {
	meta:
		name = "TAccessOptionButton.accDoDefaultAction"
		size = 113
		refs = "0011 TAccessOptionButton.accDoDefaultAction 001f EmptyParam 0035 TAccessOptionButton.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_407_0 {
	meta:
		name = "TAccessOptionGroup.accDoDefaultAction"
		size = 113
		refs = "0011 TAccessOptionGroup.accDoDefaultAction 001f EmptyParam 0035 TAccessOptionGroup.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_962_0 {
	meta:
		name = "TAccessPage.accDoDefaultAction"
		size = 113
		refs = "0011 TAccessPage.accDoDefaultAction 001f EmptyParam 0035 TAccessPage.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_786_0 {
	meta:
		name = "TAccessSubForm.accDoDefaultAction"
		size = 113
		refs = "0011 TAccessSubForm.accDoDefaultAction 001f EmptyParam 0035 TAccessSubForm.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_926_0 {
	meta:
		name = "TAccessTabControl.accDoDefaultAction"
		size = 113
		refs = "0011 TAccessTabControl.accDoDefaultAction 001f EmptyParam 0035 TAccessTabControl.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_494_0 {
	meta:
		name = "TAccessTextBox.accDoDefaultAction"
		size = 113
		refs = "0011 TAccessTextBox.accDoDefaultAction 001f EmptyParam 0035 TAccessTextBox.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_685_0 {
	meta:
		name = "TAccessToggleButton.accDoDefaultAction"
		size = 113
		refs = "0011 TAccessToggleButton.accDoDefaultAction 001f EmptyParam 0035 TAccessToggleButton.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2776_0 {
	meta:
		name = "TFormOld.accDoDefaultAction"
		size = 113
		refs = "0011 TFormOld.accDoDefaultAction 001f EmptyParam 0035 TFormOld.GetDefaultInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_366_0 {
	meta:
		name = "T_CheckBoxInOption.accDoDefaultAction"
		size = 113
		refs = "0011 T_CheckBoxInOption.accDoDefaultAction 001f EmptyParam 0035 T_CheckBoxInOption.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_128_0 {
	meta:
		name = "T_ChildLabel.accDoDefaultAction"
		size = 113
		refs = "0011 T_ChildLabel.accDoDefaultAction 001f EmptyParam 0035 T_ChildLabel.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_886_0 {
	meta:
		name = "T_CustomControlInReport.accDoDefaultAction"
		size = 113
		refs = "0011 T_CustomControlInReport.accDoDefaultAction 001f EmptyParam 0035 T_CustomControlInReport.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_285_0 {
	meta:
		name = "T_OptionButtonInOption.accDoDefaultAction"
		size = 113
		refs = "0011 T_OptionButtonInOption.accDoDefaultAction 001f EmptyParam 0035 T_OptionButtonInOption.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_730_0 {
	meta:
		name = "T_ToggleButtonInOption.accDoDefaultAction"
		size = 113
		refs = "0011 T_ToggleButtonInOption.accDoDefaultAction 001f EmptyParam 0035 T_ToggleButtonInOption.GetControlInterface 0043 @CheckAutoResult 0058 @IntfClear 0060 @VarClr 0066 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 E8 ?? ?? ?? ?? FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_95_0 {
	meta:
		name = "TAccessLabel.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessLabel.accDoDefaultAction 0041 TAccessLabel.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_453_0 {
	meta:
		name = "TAccessBoundObjectFrame.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessBoundObjectFrame.accDoDefaultAction 0041 TAccessBoundObjectFrame.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_326_0 {
	meta:
		name = "TAccessCheckBox.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessCheckBox.accDoDefaultAction 0041 TAccessCheckBox.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_587_0 {
	meta:
		name = "TAccessComboBox.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessComboBox.accDoDefaultAction 0041 TAccessComboBox.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_206_0 {
	meta:
		name = "TAccessCommandButton.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessCommandButton.accDoDefaultAction 0041 TAccessCommandButton.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_841_0 {
	meta:
		name = "TAccessCustomControl.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessCustomControl.accDoDefaultAction 0041 TAccessCustomControl.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1345_0 {
	meta:
		name = "TAccessForm.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessForm.accDoDefaultAction 0041 TAccessForm.GetDefaultInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_542_0 {
	meta:
		name = "TAccessListBox.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessListBox.accDoDefaultAction 0041 TAccessListBox.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_633_0 {
	meta:
		name = "TAccessObjectFrame.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessObjectFrame.accDoDefaultAction 0041 TAccessObjectFrame.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_246_0 {
	meta:
		name = "TAccessOptionButton.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessOptionButton.accDoDefaultAction 0041 TAccessOptionButton.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_408_0 {
	meta:
		name = "TAccessOptionGroup.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessOptionGroup.accDoDefaultAction 0041 TAccessOptionGroup.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_963_0 {
	meta:
		name = "TAccessPage.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessPage.accDoDefaultAction 0041 TAccessPage.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_787_0 {
	meta:
		name = "TAccessSubForm.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessSubForm.accDoDefaultAction 0041 TAccessSubForm.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_927_0 {
	meta:
		name = "TAccessTabControl.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessTabControl.accDoDefaultAction 0041 TAccessTabControl.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_495_0 {
	meta:
		name = "TAccessTextBox.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessTextBox.accDoDefaultAction 0041 TAccessTextBox.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_686_0 {
	meta:
		name = "TAccessToggleButton.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessToggleButton.accDoDefaultAction 0041 TAccessToggleButton.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2777_0 {
	meta:
		name = "TFormOld.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TFormOld.accDoDefaultAction 0041 TFormOld.GetDefaultInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_78456_0 {
	meta:
		name = "TShellNameSpace.Set_Root"
		size = 127
		refs = "001d @VarAddRef 0025 TShellNameSpace.Set_Root 0041 TShellNameSpace.GetDefaultInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_367_0 {
	meta:
		name = "T_CheckBoxInOption.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 T_CheckBoxInOption.accDoDefaultAction 0041 T_CheckBoxInOption.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_129_0 {
	meta:
		name = "T_ChildLabel.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 T_ChildLabel.accDoDefaultAction 0041 T_ChildLabel.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_887_0 {
	meta:
		name = "T_CustomControlInReport.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 T_CustomControlInReport.accDoDefaultAction 0041 T_CustomControlInReport.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_286_0 {
	meta:
		name = "T_OptionButtonInOption.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 T_OptionButtonInOption.accDoDefaultAction 0041 T_OptionButtonInOption.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_731_0 {
	meta:
		name = "T_ToggleButtonInOption.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 T_ToggleButtonInOption.accDoDefaultAction 0041 T_ToggleButtonInOption.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_96_0 {
	meta:
		name = "TAccessLabel.SizeToFit"
		size = 79
		refs = "000c TAccessLabel.SizeToFit 001c TAccessLabel.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_589_0 {
	meta:
		name = "TAccessComboBox.Dropdown"
		size = 79
		refs = "000c TAccessComboBox.Dropdown 001c TAccessComboBox.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_964_0 {
	meta:
		name = "TAccessPage.SizeToFit"
		size = 79
		refs = "000c TAccessPage.SizeToFit 001c TAccessPage.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_130_0 {
	meta:
		name = "T_ChildLabel.SizeToFit"
		size = 79
		refs = "000c T_ChildLabel.SizeToFit 001c T_ChildLabel.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_97_0 {
	meta:
		name = "TAccessLabel._Evaluate"
		size = 103
		refs = "0012 TAccessLabel._Evaluate 0020 @VarClr 002d TAccessLabel.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_965_0 {
	meta:
		name = "TAccessPage._Evaluate"
		size = 103
		refs = "0012 TAccessPage._Evaluate 0020 @VarClr 002d TAccessPage.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_131_0 {
	meta:
		name = "T_ChildLabel._Evaluate"
		size = 103
		refs = "0012 T_ChildLabel._Evaluate 0020 @VarClr 002d T_ChildLabel.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_133_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 08 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 4A E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_138_0 {
	meta:
		name = "TAccessRectangle.Get_Properties"
		size = 91
		refs = "000f TAccessRectangle.Get_Properties 001c @IntfClear 0027 TAccessRectangle.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1575_0 {
	meta:
		name = "TAccessApplication.Get_CodeContextObject"
		size = 91
		refs = "000f TAccessApplication.Get_CodeContextObject 001c @IntfClear 0027 TAccessApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_983_0 {
	meta:
		name = "TAccessGroupLevel.Get_Properties"
		size = 91
		refs = "000f TAccessGroupLevel.Get_Properties 001c @IntfClear 0027 TAccessGroupLevel.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_156_0 {
	meta:
		name = "TAccessImage.Get_OldValue"
		size = 91
		refs = "000f TAccessImage.Get_OldValue 001c @VarClr 0027 TAccessImage.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_147_0 {
	meta:
		name = "TAccessLine.Get_Properties"
		size = 91
		refs = "000f TAccessLine.Get_Properties 001c @IntfClear 0027 TAccessLine.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_645_0 {
	meta:
		name = "TAccessPageBreak.Get_Properties"
		size = 91
		refs = "000f TAccessPageBreak.Get_Properties 001c @IntfClear 0027 TAccessPageBreak.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_744_0 {
	meta:
		name = "TAccessPaletteButton.Get_OldValue"
		size = 91
		refs = "000f TAccessPaletteButton.Get_OldValue 001c @VarClr 0027 TAccessPaletteButton.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1366_0 {
	meta:
		name = "TAccessReport.Get_RecordSource"
		size = 91
		refs = "000f TAccessReport.Get_RecordSource 001c @WStrClr 0027 TAccessReport.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_975_0 {
	meta:
		name = "TAccessSection.Get_Properties"
		size = 91
		refs = "000f TAccessSection.Get_Properties 001c @IntfClear 0027 TAccessSection.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_799_0 {
	meta:
		name = "TAccessSubReport.Get_Form"
		size = 91
		refs = "000f TAccessSubReport.Get_Form 001c @IntfClear 0027 TAccessSubReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4854_0 {
	meta:
		name = "TBinder.Get_ActiveSection"
		size = 91
		refs = "000f TBinder.Get_ActiveSection 001c @IntfClear 0027 TBinder.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_114093_0 {
	meta:
		name = "TCOMAdminCatalogObject.Get_Key"
		size = 91
		refs = "000f TCOMAdminCatalogObject.Get_Key 001c @VarClr 0027 TCOMAdminCatalogObject.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76042_0 {
	meta:
		name = "TContactItem.Get_Session"
		size = 91
		refs = "000f TContactItem.Get_Session 001c @IntfClear 0027 TContactItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75814_0 {
	meta:
		name = "TCustomTaskPane.Get_Window"
		size = 91
		refs = "000f TCustomTaskPane.Get_Window 001c @IntfClear 0027 TCustomTaskPane.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75768_0 {
	meta:
		name = "TCustomXMLPart.Get_Parent"
		size = 91
		refs = "000f TCustomXMLPart.Get_Parent 001c @IntfClear 0027 TCustomXMLPart.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75794_0 {
	meta:
		name = "TCustomXMLParts.Get_Parent"
		size = 91
		refs = "000f TCustomXMLParts.Get_Parent 001c @IntfClear 0027 TCustomXMLParts.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75750_0 {
	meta:
		name = "TCustomXMLSchemaCollection.Get_Parent"
		size = 91
		refs = "000f TCustomXMLSchemaCollection.Get_Parent 001c @IntfClear 0027 TCustomXMLSchemaCollection.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2246_0 {
	meta:
		name = "TDependencyInfo.Get_Dependencies"
		size = 91
		refs = "000f TDependencyInfo.Get_Dependencies 001c @IntfClear 0027 TDependencyInfo.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76319_0 {
	meta:
		name = "TDistListItem.Get_Session"
		size = 91
		refs = "000f TDistListItem.Get_Session 001c @IntfClear 0027 TDistListItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76392_0 {
	meta:
		name = "TDocumentItem.Get_Session"
		size = 91
		refs = "000f TDocumentItem.Get_Session 001c @IntfClear 0027 TDocumentItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_55586_0 {
	meta:
		name = "TExcelApplication.Get_Parent"
		size = 91
		refs = "000f TExcelApplication.Get_Parent 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52205_0 {
	meta:
		name = "TExcelChart.Get_Parent"
		size = 91
		refs = "000f TExcelChart.Get_Parent 001c @IntfClear 0027 TExcelChart.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52781_0 {
	meta:
		name = "TExcelGlobal.Get_Parent"
		size = 91
		refs = "000f TExcelGlobal.Get_Parent 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52973_0 {
	meta:
		name = "TExcelWorkbook.Get_Parent"
		size = 91
		refs = "000f TExcelWorkbook.Get_Parent 001c @IntfClear 0027 TExcelWorkbook.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_56619_0 {
	meta:
		name = "TExcelWorksheet.Get_Parent"
		size = 91
		refs = "000f TExcelWorksheet.Get_Parent 001c @IntfClear 0027 TExcelWorksheet.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76454_0 {
	meta:
		name = "TExplorers.Get_Session"
		size = 91
		refs = "000f TExplorers.Get_Session 001c @IntfClear 0027 TExplorers.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76488_0 {
	meta:
		name = "TFolders.Get_Session"
		size = 91
		refs = "000f TFolders.Get_Session 001c @IntfClear 0027 TFolders.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76471_0 {
	meta:
		name = "TInspectors.Get_Session"
		size = 91
		refs = "000f TInspectors.Get_Session 001c @IntfClear 0027 TInspectors.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76512_0 {
	meta:
		name = "TItems.Get_Session"
		size = 91
		refs = "000f TItems.Get_Session 001c @IntfClear 0027 TItems.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76545_0 {
	meta:
		name = "TJournalItem.Get_Session"
		size = 91
		refs = "000f TJournalItem.Get_Session 001c @IntfClear 0027 TJournalItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2357_0 {
	meta:
		name = "TMacroError.Get_Arguments"
		size = 91
		refs = "000f TMacroError.Get_Arguments 001c @WStrClr 0027 TMacroError.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75873_0 {
	meta:
		name = "TMailItem.Get_Session"
		size = 91
		refs = "000f TMailItem.Get_Session 001c @IntfClear 0027 TMailItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75710_0 {
	meta:
		name = "TMaster.Get_Shapes"
		size = 91
		refs = "000f TMaster.Get_Shapes 001c @IntfClear 0027 TMaster.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76631_0 {
	meta:
		name = "TNameSpace.Get_Session"
		size = 91
		refs = "000f TNameSpace.Get_Session 001c @IntfClear 0027 TNameSpace.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77481_0 {
	meta:
		name = "TOutlookApplication.Get_Session"
		size = 91
		refs = "000f TOutlookApplication.Get_Session 001c @IntfClear 0027 TOutlookApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76670_0 {
	meta:
		name = "TOutlookBarGroups.Get_Session"
		size = 91
		refs = "000f TOutlookBarGroups.Get_Session 001c @IntfClear 0027 TOutlookBarGroups.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76689_0 {
	meta:
		name = "TOutlookBarPane.Get_Session"
		size = 91
		refs = "000f TOutlookBarPane.Get_Session 001c @IntfClear 0027 TOutlookBarPane.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76709_0 {
	meta:
		name = "TOutlookBarShortcuts.Get_Session"
		size = 91
		refs = "000f TOutlookBarShortcuts.Get_Session 001c @IntfClear 0027 TOutlookBarShortcuts.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76728_0 {
	meta:
		name = "TPostItem.Get_Session"
		size = 91
		refs = "000f TPostItem.Get_Session 001c @IntfClear 0027 TPostItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77734_0 {
	meta:
		name = "TPowerPointApplication.Get_Dialogs"
		size = 91
		refs = "000f TPowerPointApplication.Get_Dialogs 001c @IntfClear 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75546_0 {
	meta:
		name = "TPowerPointPresentation.Get_SlideMaster"
		size = 91
		refs = "000f TPowerPointPresentation.Get_SlideMaster 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75505_0 {
	meta:
		name = "TPowerPointSlide.Get_Shapes"
		size = 91
		refs = "000f TPowerPointSlide.Get_Shapes 001c @IntfClear 0027 TPowerPointSlide.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76801_0 {
	meta:
		name = "TRemoteItem.Get_Session"
		size = 91
		refs = "000f TRemoteItem.Get_Session 001c @IntfClear 0027 TRemoteItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76867_0 {
	meta:
		name = "TReportItem.Get_Session"
		size = 91
		refs = "000f TReportItem.Get_Session 001c @IntfClear 0027 TReportItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2798_0 {
	meta:
		name = "TReportOld.Get_RecordSource"
		size = 91
		refs = "000f TReportOld.Get_RecordSource 001c @WStrClr 0027 TReportOld.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2409_0 {
	meta:
		name = "TReturnVar.Get_Value"
		size = 91
		refs = "000f TReturnVar.Get_Value 001c @VarClr 0027 TReturnVar.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78371_0 {
	meta:
		name = "TShellWindows._NewEnum"
		size = 91
		refs = "000f TShellWindows._NewEnum 001c @IntfClear 0027 TShellWindows.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2335_0 {
	meta:
		name = "TSmartTag.Get_Parent"
		size = 91
		refs = "000f TSmartTag.Get_Parent 001c @IntfClear 0027 TSmartTag.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2277_0 {
	meta:
		name = "TSmartTagAction.Get_Name"
		size = 91
		refs = "000f TSmartTagAction.Get_Name 001c @WStrClr 0027 TSmartTagAction.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2291_0 {
	meta:
		name = "TSmartTagActions.Get_Parent"
		size = 91
		refs = "000f TSmartTagActions.Get_Parent 001c @IntfClear 0027 TSmartTagActions.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2320_0 {
	meta:
		name = "TSmartTagProperties.Get_Parent"
		size = 91
		refs = "000f TSmartTagProperties.Get_Parent 001c @IntfClear 0027 TSmartTagProperties.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2305_0 {
	meta:
		name = "TSmartTagProperty.Get_Value"
		size = 91
		refs = "000f TSmartTagProperty.Get_Value 001c @WStrClr 0027 TSmartTagProperty.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75852_0 {
	meta:
		name = "TSyncObject.Get_Session"
		size = 91
		refs = "000f TSyncObject.Get_Session 001c @IntfClear 0027 TSyncObject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76929_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_Session"
		size = 91
		refs = "000f TTaskRequestAcceptItem.Get_Session 001c @IntfClear 0027 TTaskRequestAcceptItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76992_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_Session"
		size = 91
		refs = "000f TTaskRequestDeclineItem.Get_Session 001c @IntfClear 0027 TTaskRequestDeclineItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77055_0 {
	meta:
		name = "TTaskRequestItem.Get_Session"
		size = 91
		refs = "000f TTaskRequestItem.Get_Session 001c @IntfClear 0027 TTaskRequestItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77118_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_Session"
		size = 91
		refs = "000f TTaskRequestUpdateItem.Get_Session 001c @IntfClear 0027 TTaskRequestUpdateItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2373_0 {
	meta:
		name = "TTempVar.Get_Name"
		size = 91
		refs = "000f TTempVar.Get_Name 001c @WStrClr 0027 TTempVar.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_151552_0 {
	meta:
		name = "TWordApplication.Get_Parent"
		size = 91
		refs = "000f TWordApplication.Get_Parent 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148906_0 {
	meta:
		name = "TWordFont.Get_Parent"
		size = 91
		refs = "000f TWordFont.Get_Parent 001c @IntfClear 0027 TWordFont.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149119_0 {
	meta:
		name = "TWordLetterContent.Get_Parent"
		size = 91
		refs = "000f TWordLetterContent.Get_Parent 001c @IntfClear 0027 TWordLetterContent.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148996_0 {
	meta:
		name = "TWordParagraphFormat.Get_Parent"
		size = 91
		refs = "000f TWordParagraphFormat.Get_Parent 001c @IntfClear 0027 TWordParagraphFormat.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_998_0 {
	meta:
		name = "T_PageHdrFtrInReport.Get_Properties"
		size = 91
		refs = "000f T_PageHdrFtrInReport.Get_Properties 001c @IntfClear 0027 T_PageHdrFtrInReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_990_0 {
	meta:
		name = "T_SectionInReport.Get_Properties"
		size = 91
		refs = "000f T_SectionInReport.Get_Properties 001c @IntfClear 0027 T_SectionInReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_140_0 {
	meta:
		name = "TAccessRectangle._Evaluate"
		size = 100
		refs = "0012 TAccessRectangle._Evaluate 0020 @VarClr 002d TAccessRectangle.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_149_0 {
	meta:
		name = "TAccessLine._Evaluate"
		size = 100
		refs = "0012 TAccessLine._Evaluate 0020 @VarClr 002d TAccessLine.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_647_0 {
	meta:
		name = "TAccessPageBreak._Evaluate"
		size = 100
		refs = "0012 TAccessPageBreak._Evaluate 0020 @VarClr 002d TAccessPageBreak.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_142_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 08 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 4C E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_151_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 08 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 4E E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_157_0 {
	meta:
		name = "TAccessImage.Get_Properties"
		size = 91
		refs = "000f TAccessImage.Get_Properties 001c @IntfClear 0027 TAccessImage.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_745_0 {
	meta:
		name = "TAccessPaletteButton.Get_Properties"
		size = 91
		refs = "000f TAccessPaletteButton.Get_Properties 001c @IntfClear 0027 TAccessPaletteButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3213_0 {
	meta:
		name = "TAccessReferences._NewEnum"
		size = 91
		refs = "000f TAccessReferences._NewEnum 001c @IntfClear 0027 TAccessReferences.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_976_0 {
	meta:
		name = "TAccessSection.Get_Controls"
		size = 91
		refs = "000f TAccessSection.Get_Controls 001c @IntfClear 0027 TAccessSection.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_800_0 {
	meta:
		name = "TAccessSubReport.Get_Report"
		size = 91
		refs = "000f TAccessSubReport.Get_Report 001c @IntfClear 0027 TAccessSubReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4855_0 {
	meta:
		name = "TBinder.Get_Sections"
		size = 91
		refs = "000f TBinder.Get_Sections 001c @IntfClear 0027 TBinder.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_114094_0 {
	meta:
		name = "TCOMAdminCatalogObject.Get_Name"
		size = 91
		refs = "000f TCOMAdminCatalogObject.Get_Name 001c @VarClr 0027 TCOMAdminCatalogObject.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76043_0 {
	meta:
		name = "TContactItem.Get_Parent"
		size = 91
		refs = "000f TContactItem.Get_Parent 001c @IntfClear 0027 TContactItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75769_0 {
	meta:
		name = "TCustomXMLPart.Get_DocumentElement"
		size = 91
		refs = "000f TCustomXMLPart.Get_DocumentElement 001c @IntfClear 0027 TCustomXMLPart.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2247_0 {
	meta:
		name = "TDependencyInfo.Get_OutOfDateObjects"
		size = 91
		refs = "000f TDependencyInfo.Get_OutOfDateObjects 001c @IntfClear 0027 TDependencyInfo.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76320_0 {
	meta:
		name = "TDistListItem.Get_Parent"
		size = 91
		refs = "000f TDistListItem.Get_Parent 001c @IntfClear 0027 TDistListItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76393_0 {
	meta:
		name = "TDocumentItem.Get_Parent"
		size = 91
		refs = "000f TDocumentItem.Get_Parent 001c @IntfClear 0027 TDocumentItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_51625_0 {
	meta:
		name = "TExcelApplication.Get_ActiveCell"
		size = 91
		refs = "000f TExcelApplication.Get_ActiveCell 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52782_0 {
	meta:
		name = "TExcelGlobal.Get_ActiveCell"
		size = 91
		refs = "000f TExcelGlobal.Get_ActiveCell 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76455_0 {
	meta:
		name = "TExplorers.Get_Parent"
		size = 91
		refs = "000f TExplorers.Get_Parent 001c @IntfClear 0027 TExplorers.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76489_0 {
	meta:
		name = "TFolders.Get_Parent"
		size = 91
		refs = "000f TFolders.Get_Parent 001c @IntfClear 0027 TFolders.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76472_0 {
	meta:
		name = "TInspectors.Get_Parent"
		size = 91
		refs = "000f TInspectors.Get_Parent 001c @IntfClear 0027 TInspectors.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76513_0 {
	meta:
		name = "TItems.Get_Parent"
		size = 91
		refs = "000f TItems.Get_Parent 001c @IntfClear 0027 TItems.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76546_0 {
	meta:
		name = "TJournalItem.Get_Parent"
		size = 91
		refs = "000f TJournalItem.Get_Parent 001c @IntfClear 0027 TJournalItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2358_0 {
	meta:
		name = "TMacroError.Get_Description"
		size = 91
		refs = "000f TMacroError.Get_Description 001c @WStrClr 0027 TMacroError.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75874_0 {
	meta:
		name = "TMailItem.Get_Parent"
		size = 91
		refs = "000f TMailItem.Get_Parent 001c @IntfClear 0027 TMailItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75711_0 {
	meta:
		name = "TMaster.Get_HeadersFooters"
		size = 91
		refs = "000f TMaster.Get_HeadersFooters 001c @IntfClear 0027 TMaster.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76632_0 {
	meta:
		name = "TNameSpace.Get_Parent"
		size = 91
		refs = "000f TNameSpace.Get_Parent 001c @IntfClear 0027 TNameSpace.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77326_0 {
	meta:
		name = "TOutlookApplication.Get_Parent"
		size = 91
		refs = "000f TOutlookApplication.Get_Parent 001c @IntfClear 0027 TOutlookApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76671_0 {
	meta:
		name = "TOutlookBarGroups.Get_Parent"
		size = 91
		refs = "000f TOutlookBarGroups.Get_Parent 001c @IntfClear 0027 TOutlookBarGroups.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76690_0 {
	meta:
		name = "TOutlookBarPane.Get_Parent"
		size = 91
		refs = "000f TOutlookBarPane.Get_Parent 001c @IntfClear 0027 TOutlookBarPane.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76710_0 {
	meta:
		name = "TOutlookBarShortcuts.Get_Parent"
		size = 91
		refs = "000f TOutlookBarShortcuts.Get_Parent 001c @IntfClear 0027 TOutlookBarShortcuts.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_32880_0 {
	meta:
		name = "TParameter.GetValue"
		size = 91
		refs = "000f TParameter.GetValue 001c @VarClr 0027 TParameter.GetParameter 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76729_0 {
	meta:
		name = "TPostItem.Get_Parent"
		size = 91
		refs = "000f TPostItem.Get_Parent 001c @IntfClear 0027 TPostItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77735_0 {
	meta:
		name = "TPowerPointApplication.Get_ActiveWindow"
		size = 91
		refs = "000f TPowerPointApplication.Get_ActiveWindow 001c @IntfClear 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75547_0 {
	meta:
		name = "TPowerPointPresentation.Get_TitleMaster"
		size = 91
		refs = "000f TPowerPointPresentation.Get_TitleMaster 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75506_0 {
	meta:
		name = "TPowerPointSlide.Get_HeadersFooters"
		size = 91
		refs = "000f TPowerPointSlide.Get_HeadersFooters 001c @IntfClear 0027 TPowerPointSlide.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76802_0 {
	meta:
		name = "TRemoteItem.Get_Parent"
		size = 91
		refs = "000f TRemoteItem.Get_Parent 001c @IntfClear 0027 TRemoteItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76868_0 {
	meta:
		name = "TReportItem.Get_Parent"
		size = 91
		refs = "000f TReportItem.Get_Parent 001c @IntfClear 0027 TReportItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2336_0 {
	meta:
		name = "TSmartTag.Get_Properties"
		size = 91
		refs = "000f TSmartTag.Get_Properties 001c @IntfClear 0027 TSmartTag.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75853_0 {
	meta:
		name = "TSyncObject.Get_Parent"
		size = 91
		refs = "000f TSyncObject.Get_Parent 001c @IntfClear 0027 TSyncObject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76930_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_Parent"
		size = 91
		refs = "000f TTaskRequestAcceptItem.Get_Parent 001c @IntfClear 0027 TTaskRequestAcceptItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76993_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_Parent"
		size = 91
		refs = "000f TTaskRequestDeclineItem.Get_Parent 001c @IntfClear 0027 TTaskRequestDeclineItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77056_0 {
	meta:
		name = "TTaskRequestItem.Get_Parent"
		size = 91
		refs = "000f TTaskRequestItem.Get_Parent 001c @IntfClear 0027 TTaskRequestItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77119_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_Parent"
		size = 91
		refs = "000f TTaskRequestUpdateItem.Get_Parent 001c @IntfClear 0027 TTaskRequestUpdateItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2374_0 {
	meta:
		name = "TTempVar.Get_Value"
		size = 91
		refs = "000f TTempVar.Get_Value 001c @VarClr 0027 TTempVar.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_151553_0 {
	meta:
		name = "TWordApplication.Get_Name"
		size = 91
		refs = "000f TWordApplication.Get_Name 001c @WStrClr 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148556_0 {
	meta:
		name = "TWordDocument.Get_Parent"
		size = 91
		refs = "000f TWordDocument.Get_Parent 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149508_0 {
	meta:
		name = "TWordFont.Get_Duplicate"
		size = 91
		refs = "000f TWordFont.Get_Duplicate 001c @IntfClear 0027 TWordFont.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149722_0 {
	meta:
		name = "TWordLetterContent.Get_Duplicate"
		size = 91
		refs = "000f TWordLetterContent.Get_Duplicate 001c @IntfClear 0027 TWordLetterContent.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149621_0 {
	meta:
		name = "TWordParagraphFormat.Get_Duplicate"
		size = 91
		refs = "000f TWordParagraphFormat.Get_Duplicate 001c @IntfClear 0027 TWordParagraphFormat.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_999_0 {
	meta:
		name = "T_PageHdrFtrInReport.Get_Controls"
		size = 91
		refs = "000f T_PageHdrFtrInReport.Get_Controls 001c @IntfClear 0027 T_PageHdrFtrInReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_991_0 {
	meta:
		name = "T_SectionInReport.Get_Controls"
		size = 91
		refs = "000f T_SectionInReport.Get_Controls 001c @IntfClear 0027 T_SectionInReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_159_0 {
	meta:
		name = "TAccessImage.Get_Hyperlink"
		size = 91
		refs = "000f TAccessImage.Get_Hyperlink 001c @IntfClear 0027 TAccessImage.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_747_0 {
	meta:
		name = "TAccessPaletteButton.Get_Value"
		size = 91
		refs = "000f TAccessPaletteButton.Get_Value 001c @VarClr 0027 TAccessPaletteButton.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76050_0 {
	meta:
		name = "TContactItem.Get_Categories"
		size = 91
		refs = "000f TContactItem.Get_Categories 001c @WStrClr 0027 TContactItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76327_0 {
	meta:
		name = "TDistListItem.Get_Categories"
		size = 91
		refs = "000f TDistListItem.Get_Categories 001c @WStrClr 0027 TDistListItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76400_0 {
	meta:
		name = "TDocumentItem.Get_Categories"
		size = 91
		refs = "000f TDocumentItem.Get_Categories 001c @WStrClr 0027 TDocumentItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_51632_0 {
	meta:
		name = "TExcelApplication.Get_ActiveWindow"
		size = 91
		refs = "000f TExcelApplication.Get_ActiveWindow 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_56940_0 {
	meta:
		name = "TExcelGlobal.Get_ActiveWindow"
		size = 91
		refs = "000f TExcelGlobal.Get_ActiveWindow 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76497_0 {
	meta:
		name = "TFolders.GetNext"
		size = 91
		refs = "000f TFolders.GetNext 001c @IntfClear 0027 TFolders.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78194_0 {
	meta:
		name = "TInternetExplorer.Get_Container"
		size = 91
		refs = "000f TInternetExplorer.Get_Container 001c @IntfClear 0027 TInternetExplorer.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78281_0 {
	meta:
		name = "TInternetExplorerMedium.Get_Container"
		size = 91
		refs = "000f TInternetExplorerMedium.Get_Container 001c @IntfClear 0027 TInternetExplorerMedium.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76553_0 {
	meta:
		name = "TJournalItem.Get_Categories"
		size = 91
		refs = "000f TJournalItem.Get_Categories 001c @WStrClr 0027 TJournalItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75881_0 {
	meta:
		name = "TMailItem.Get_Categories"
		size = 91
		refs = "000f TMailItem.Get_Categories 001c @WStrClr 0027 TMailItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76736_0 {
	meta:
		name = "TPostItem.Get_Categories"
		size = 91
		refs = "000f TPostItem.Get_Categories 001c @WStrClr 0027 TPostItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75552_0 {
	meta:
		name = "TPowerPointPresentation.Get_Slides"
		size = 91
		refs = "000f TPowerPointPresentation.Get_Slides 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76809_0 {
	meta:
		name = "TRemoteItem.Get_Categories"
		size = 91
		refs = "000f TRemoteItem.Get_Categories 001c @WStrClr 0027 TRemoteItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76875_0 {
	meta:
		name = "TReportItem.Get_Categories"
		size = 91
		refs = "000f TReportItem.Get_Categories 001c @WStrClr 0027 TReportItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76937_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_Categories"
		size = 91
		refs = "000f TTaskRequestAcceptItem.Get_Categories 001c @WStrClr 0027 TTaskRequestAcceptItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77000_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_Categories"
		size = 91
		refs = "000f TTaskRequestDeclineItem.Get_Categories 001c @WStrClr 0027 TTaskRequestDeclineItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77063_0 {
	meta:
		name = "TTaskRequestItem.Get_Categories"
		size = 91
		refs = "000f TTaskRequestItem.Get_Categories 001c @WStrClr 0027 TTaskRequestItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77126_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_Categories"
		size = 91
		refs = "000f TTaskRequestUpdateItem.Get_Categories 001c @WStrClr 0027 TTaskRequestUpdateItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78150_0 {
	meta:
		name = "TWebBrowser.Get_Container"
		size = 91
		refs = "000f TWebBrowser.Get_Container 001c @IntfClear 0027 TWebBrowser.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149203_0 {
	meta:
		name = "TWordApplication.Get_RecentFiles"
		size = 91
		refs = "000f TWordApplication.Get_RecentFiles 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148563_0 {
	meta:
		name = "TWordDocument.Get_Endnotes"
		size = 91
		refs = "000f TWordDocument.Get_Endnotes 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149100_0 {
	meta:
		name = "TWordOLEControl.Get_Automation"
		size = 91
		refs = "000f TWordOLEControl.Get_Automation 001c @IntfClear 0027 TWordOLEControl.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_161_0 {
	meta:
		name = "TAccessImage.Set_PictureData"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessImage.Set_PictureData 0041 TAccessImage.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_162_0 {
	meta:
		name = "TAccessImage.Get_ObjectPalette"
		size = 94
		refs = "000f TAccessImage.Get_ObjectPalette 001c @VarClr 0027 TAccessImage.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 30 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76101_0 {
	meta:
		name = "TContactItem.Get_BusinessAddressPostOfficeBox"
		size = 94
		refs = "000f TContactItem.Get_BusinessAddressPostOfficeBox 001c @WStrClr 0027 TContactItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 30 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76615_0 {
	meta:
		name = "TJournalItem.Reply"
		size = 94
		refs = "000f TJournalItem.Reply 001c @IntfClear 0027 TJournalItem.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 30 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75932_0 {
	meta:
		name = "TMailItem.Get_HTMLBody"
		size = 94
		refs = "000f TMailItem.Get_HTMLBody 001c @WStrClr 0027 TMailItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 30 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148622_0 {
	meta:
		name = "TWordDocument.Get_CommandBars"
		size = 94
		refs = "000f TWordDocument.Get_CommandBars 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 30 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_163_0 {
	meta:
		name = "TAccessImage.Set_ObjectPalette"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessImage.Set_ObjectPalette 0041 TAccessImage.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 34 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_164_0 {
	meta:
		name = "TAccessImage.SizeToFit"
		size = 79
		refs = "000c TAccessImage.SizeToFit 001c TAccessImage.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_749_0 {
	meta:
		name = "TAccessPaletteButton.SizeToFit"
		size = 79
		refs = "000c TAccessPaletteButton.SizeToFit 001c TAccessPaletteButton.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78472_0 {
	meta:
		name = "TShellNameSpace.Synchronize"
		size = 79
		refs = "000c TShellNameSpace.Synchronize 001c TShellNameSpace.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2307_0 {
	meta:
		name = "TSmartTagProperty.Delete"
		size = 79
		refs = "000c TSmartTagProperty.Delete 001c TSmartTagProperty.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_165_0 {
	meta:
		name = "TAccessImage.Requery"
		size = 79
		refs = "000c TAccessImage.Requery 001c TAccessImage.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_750_0 {
	meta:
		name = "TAccessPaletteButton.Requery"
		size = 79
		refs = "000c TAccessPaletteButton.Requery 001c TAccessPaletteButton.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_4877_0 {
	meta:
		name = "TBinder.Save"
		size = 79
		refs = "000c TBinder.Save 001c TBinder.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_114115_0 {
	meta:
		name = "TCOMAdminCatalogCollection.Populate"
		size = 79
		refs = "000c TCOMAdminCatalogCollection.Populate 001c TCOMAdminCatalogCollection.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78249_0 {
	meta:
		name = "TInternetExplorer.Refresh"
		size = 79
		refs = "000c TInternetExplorer.Refresh 001c TInternetExplorer.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78336_0 {
	meta:
		name = "TInternetExplorerMedium.Refresh"
		size = 79
		refs = "000c TInternetExplorerMedium.Refresh 001c TInternetExplorerMedium.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78473_0 {
	meta:
		name = "TShellNameSpace.Import"
		size = 79
		refs = "000c TShellNameSpace.Import 001c TShellNameSpace.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_75855_0 {
	meta:
		name = "TSyncObject.Start"
		size = 79
		refs = "000c TSyncObject.Start 001c TSyncObject.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78162_0 {
	meta:
		name = "TWebBrowser.Refresh"
		size = 79
		refs = "000c TWebBrowser.Refresh 001c TWebBrowser.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_166_0 {
	meta:
		name = "TAccessImage.Goto_"
		size = 79
		refs = "000c TAccessImage.Goto_ 001c TAccessImage.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_751_0 {
	meta:
		name = "TAccessPaletteButton.Goto_"
		size = 79
		refs = "000c TAccessPaletteButton.Goto_ 001c TAccessPaletteButton.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78474_0 {
	meta:
		name = "TShellNameSpace.Export"
		size = 79
		refs = "000c TShellNameSpace.Export 001c TShellNameSpace.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2340_0 {
	meta:
		name = "TSmartTag.Delete"
		size = 79
		refs = "000c TSmartTag.Delete 001c TSmartTag.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_75856_0 {
	meta:
		name = "TSyncObject.Stop"
		size = 79
		refs = "000c TSyncObject.Stop 001c TSyncObject.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_167_0 {
	meta:
		name = "TAccessImage.SetFocus"
		size = 79
		refs = "000c TAccessImage.SetFocus 001c TAccessImage.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_752_0 {
	meta:
		name = "TAccessPaletteButton.SetFocus"
		size = 79
		refs = "000c TAccessPaletteButton.SetFocus 001c TAccessPaletteButton.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78252_0 {
	meta:
		name = "TInternetExplorer.Stop"
		size = 79
		refs = "000c TInternetExplorer.Stop 001c TInternetExplorer.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78339_0 {
	meta:
		name = "TInternetExplorerMedium.Stop"
		size = 79
		refs = "000c TInternetExplorerMedium.Stop 001c TInternetExplorerMedium.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2392_0 {
	meta:
		name = "TTempVars.RemoveAll"
		size = 79
		refs = "000c TTempVars.RemoveAll 001c TTempVars.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78165_0 {
	meta:
		name = "TWebBrowser.Stop"
		size = 79
		refs = "000c TWebBrowser.Stop 001c TWebBrowser.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_168_0 {
	meta:
		name = "TAccessImage._Evaluate"
		size = 100
		refs = "0012 TAccessImage._Evaluate 0020 @VarClr 002d TAccessImage.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_753_0 {
	meta:
		name = "TAccessPaletteButton._Evaluate"
		size = 100
		refs = "0012 TAccessPaletteButton._Evaluate 0020 @VarClr 002d TAccessPaletteButton.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_169_0 {
	meta:
		name = "TAccessBoundObjectFrame.InitControlData"
		size = 26
		refs = "0001 CControlData"
		altNames = "TAccessCheckBox.InitControlData TAccessComboBox.InitControlData TAccessCommandButton.InitControlData TAccessCustomControl.InitControlData TAccessListBox.InitControlData TAccessObjectFrame.InitControlData TAccessOptionButton.InitControlData TAccessOptionGroup.InitControlData TAccessPaletteButton.InitControlData TAccessSubForm.InitControlData TAccessSubReport.InitControlData TAccessTabControl.InitControlData TAccessTextBox.InitControlData TAccessToggleButton.InitControlData TScriptlet.InitControlData T_CheckBoxInOption.InitControlData T_OptionButtonInOption.InitControlData T_PageHdrFtrInReport.InitControlData T_SectionInReport.InitControlData T_ToggleButtonInOption.InitControlData"
	strings:
		$1 = { BA ?? ?? ?? ?? 89 90 88 02 00 00 8D 90 08 03 00 00 2B D0 89 15 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_170_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 28 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 50 E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_171_0 {
	meta:
		name = "TAccessCommandButton.CreateControl"
		size = 29
		refs = "0015 DoCreate"
		altNames = "TAccessOptionGroup.CreateControl"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC 83 B8 28 03 00 00 00 75 07 55 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_172_0 {
	meta:
		name = "TAccessCommandButton.GetControlInterface"
		size = 29
		refs = "0009 TAccessCommandButton.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 28 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_377_0 {
	meta:
		name = "TAccessOptionGroup.GetControlInterface"
		size = 29
		refs = "0009 TAccessOptionGroup.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 28 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_191_0 {
	meta:
		name = "TAccessCommandButton.Get_Properties"
		size = 91
		refs = "000f TAccessCommandButton.Get_Properties 001c @IntfClear 0027 TAccessCommandButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_437_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_Object_"
		size = 91
		refs = "000f TAccessBoundObjectFrame.Get_Object_ 001c @IntfClear 0027 TAccessBoundObjectFrame.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_313_0 {
	meta:
		name = "TAccessCheckBox.Get_OldValue"
		size = 91
		refs = "000f TAccessCheckBox.Get_OldValue 001c @VarClr 0027 TAccessCheckBox.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_823_0 {
	meta:
		name = "TAccessCustomControl.Get_Object_"
		size = 91
		refs = "000f TAccessCustomControl.Get_Object_ 001c @IntfClear 0027 TAccessCustomControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_617_0 {
	meta:
		name = "TAccessObjectFrame.Get_Object_"
		size = 91
		refs = "000f TAccessObjectFrame.Get_Object_ 001c @IntfClear 0027 TAccessObjectFrame.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_234_0 {
	meta:
		name = "TAccessOptionButton.Get_Properties"
		size = 91
		refs = "000f TAccessOptionButton.Get_Properties 001c @IntfClear 0027 TAccessOptionButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_395_0 {
	meta:
		name = "TAccessOptionGroup.Get_OldValue"
		size = 91
		refs = "000f TAccessOptionGroup.Get_OldValue 001c @VarClr 0027 TAccessOptionGroup.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_776_0 {
	meta:
		name = "TAccessSubForm.Get_Report"
		size = 91
		refs = "000f TAccessSubForm.Get_Report 001c @IntfClear 0027 TAccessSubForm.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_915_0 {
	meta:
		name = "TAccessTabControl.Get_Properties"
		size = 91
		refs = "000f TAccessTabControl.Get_Properties 001c @IntfClear 0027 TAccessTabControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_480_0 {
	meta:
		name = "TAccessTextBox.Get_OldValue"
		size = 91
		refs = "000f TAccessTextBox.Get_OldValue 001c @VarClr 0027 TAccessTextBox.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_669_0 {
	meta:
		name = "TAccessToggleButton.Get_OldValue"
		size = 91
		refs = "000f TAccessToggleButton.Get_OldValue 001c @VarClr 0027 TAccessToggleButton.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76064_0 {
	meta:
		name = "TContactItem.Get_MessageClass"
		size = 91
		refs = "000f TContactItem.Get_MessageClass 001c @WStrClr 0027 TContactItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76341_0 {
	meta:
		name = "TDistListItem.Get_MessageClass"
		size = 91
		refs = "000f TDistListItem.Get_MessageClass 001c @WStrClr 0027 TDistListItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76414_0 {
	meta:
		name = "TDocumentItem.Get_MessageClass"
		size = 91
		refs = "000f TDocumentItem.Get_MessageClass 001c @WStrClr 0027 TDocumentItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76567_0 {
	meta:
		name = "TJournalItem.Get_MessageClass"
		size = 91
		refs = "000f TJournalItem.Get_MessageClass 001c @WStrClr 0027 TJournalItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75895_0 {
	meta:
		name = "TMailItem.Get_MessageClass"
		size = 91
		refs = "000f TMailItem.Get_MessageClass 001c @WStrClr 0027 TMailItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76750_0 {
	meta:
		name = "TPostItem.Get_MessageClass"
		size = 91
		refs = "000f TPostItem.Get_MessageClass 001c @WStrClr 0027 TPostItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75566_0 {
	meta:
		name = "TPowerPointPresentation.Get_Name"
		size = 91
		refs = "000f TPowerPointPresentation.Get_Name 001c @WStrClr 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76823_0 {
	meta:
		name = "TRemoteItem.Get_MessageClass"
		size = 91
		refs = "000f TRemoteItem.Get_MessageClass 001c @WStrClr 0027 TRemoteItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76889_0 {
	meta:
		name = "TReportItem.Get_MessageClass"
		size = 91
		refs = "000f TReportItem.Get_MessageClass 001c @WStrClr 0027 TReportItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76951_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_MessageClass"
		size = 91
		refs = "000f TTaskRequestAcceptItem.Get_MessageClass 001c @WStrClr 0027 TTaskRequestAcceptItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77014_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_MessageClass"
		size = 91
		refs = "000f TTaskRequestDeclineItem.Get_MessageClass 001c @WStrClr 0027 TTaskRequestDeclineItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77077_0 {
	meta:
		name = "TTaskRequestItem.Get_MessageClass"
		size = 91
		refs = "000f TTaskRequestItem.Get_MessageClass 001c @WStrClr 0027 TTaskRequestItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77140_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_MessageClass"
		size = 91
		refs = "000f TTaskRequestUpdateItem.Get_MessageClass 001c @WStrClr 0027 TTaskRequestUpdateItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_151574_0 {
	meta:
		name = "TWordApplication.Get_AutoCaptions"
		size = 91
		refs = "000f TWordApplication.Get_AutoCaptions 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148577_0 {
	meta:
		name = "TWordDocument.Get_Sentences"
		size = 91
		refs = "000f TWordDocument.Get_Sentences 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_354_0 {
	meta:
		name = "T_CheckBoxInOption.Get_OldValue"
		size = 91
		refs = "000f T_CheckBoxInOption.Get_OldValue 001c @VarClr 0027 T_CheckBoxInOption.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_869_0 {
	meta:
		name = "T_CustomControlInReport.Get_Object_"
		size = 91
		refs = "000f T_CustomControlInReport.Get_Object_ 001c @IntfClear 0027 T_CustomControlInReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_274_0 {
	meta:
		name = "T_OptionButtonInOption.Get_Properties"
		size = 91
		refs = "000f T_OptionButtonInOption.Get_Properties 001c @IntfClear 0027 T_OptionButtonInOption.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_714_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_OldValue"
		size = 91
		refs = "000f T_ToggleButtonInOption.Get_OldValue 001c @VarClr 0027 T_ToggleButtonInOption.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_192_0 {
	meta:
		name = "TAccessCommandButton.Get_Controls"
		size = 94
		refs = "000f TAccessCommandButton.Get_Controls 001c @IntfClear 0027 TAccessCommandButton.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1034_0 {
	meta:
		name = "TAccessForm.Get_OrderBy"
		size = 94
		refs = "000f TAccessForm.Get_OrderBy 001c @WStrClr 0027 TAccessForm.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_528_0 {
	meta:
		name = "TAccessListBox.Get_Properties"
		size = 94
		refs = "000f TAccessListBox.Get_Properties 001c @IntfClear 0027 TAccessListBox.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_235_0 {
	meta:
		name = "TAccessOptionButton.Get_Controls"
		size = 94
		refs = "000f TAccessOptionButton.Get_Controls 001c @IntfClear 0027 TAccessOptionButton.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_952_0 {
	meta:
		name = "TAccessPage.Get_Controls"
		size = 94
		refs = "000f TAccessPage.Get_Controls 001c @IntfClear 0027 TAccessPage.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2466_0 {
	meta:
		name = "TFormOld.Get_OrderBy"
		size = 94
		refs = "000f TFormOld.Get_OrderBy 001c @WStrClr 0027 TFormOld.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78209_0 {
	meta:
		name = "TInternetExplorer.Get_Name"
		size = 94
		refs = "000f TInternetExplorer.Get_Name 001c @WStrClr 0027 TInternetExplorer.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78296_0 {
	meta:
		name = "TInternetExplorerMedium.Get_Name"
		size = 94
		refs = "000f TInternetExplorerMedium.Get_Name 001c @WStrClr 0027 TInternetExplorerMedium.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148582_0 {
	meta:
		name = "TWordDocument.Get_Frames"
		size = 94
		refs = "000f TWordDocument.Get_Frames 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_275_0 {
	meta:
		name = "T_OptionButtonInOption.Get_Controls"
		size = 94
		refs = "000f T_OptionButtonInOption.Get_Controls 001c @IntfClear 0027 T_OptionButtonInOption.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_193_0 {
	meta:
		name = "TAccessCommandButton.Get_Hyperlink"
		size = 94
		refs = "000f TAccessCommandButton.Get_Hyperlink 001c @IntfClear 0027 TAccessCommandButton.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_440_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_Controls"
		size = 94
		refs = "000f TAccessBoundObjectFrame.Get_Controls 001c @IntfClear 0027 TAccessBoundObjectFrame.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_826_0 {
	meta:
		name = "TAccessCustomControl.Get_Controls"
		size = 94
		refs = "000f TAccessCustomControl.Get_Controls 001c @IntfClear 0027 TAccessCustomControl.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_620_0 {
	meta:
		name = "TAccessObjectFrame.Get_Controls"
		size = 94
		refs = "000f TAccessObjectFrame.Get_Controls 001c @IntfClear 0027 TAccessObjectFrame.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_236_0 {
	meta:
		name = "TAccessOptionButton.Get_Value"
		size = 94
		refs = "000f TAccessOptionButton.Get_Value 001c @VarClr 0027 TAccessOptionButton.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_778_0 {
	meta:
		name = "TAccessSubForm.Get_Controls"
		size = 94
		refs = "000f TAccessSubForm.Get_Controls 001c @IntfClear 0027 TAccessSubForm.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76071_0 {
	meta:
		name = "TContactItem.Get_OutlookVersion"
		size = 94
		refs = "000f TContactItem.Get_OutlookVersion 001c @WStrClr 0027 TContactItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76348_0 {
	meta:
		name = "TDistListItem.Get_OutlookVersion"
		size = 94
		refs = "000f TDistListItem.Get_OutlookVersion 001c @WStrClr 0027 TDistListItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76421_0 {
	meta:
		name = "TDocumentItem.Get_OutlookVersion"
		size = 94
		refs = "000f TDocumentItem.Get_OutlookVersion 001c @WStrClr 0027 TDocumentItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_51643_0 {
	meta:
		name = "TExcelApplication.Get_Modules"
		size = 94
		refs = "000f TExcelApplication.Get_Modules 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52800_0 {
	meta:
		name = "TExcelGlobal.Get_Modules"
		size = 94
		refs = "000f TExcelGlobal.Get_Modules 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_57149_0 {
	meta:
		name = "TExcelWorkbook.Get_Container"
		size = 94
		refs = "000f TExcelWorkbook.Get_Container 001c @IntfClear 0027 TExcelWorkbook.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78211_0 {
	meta:
		name = "TInternetExplorer.Get_FullName"
		size = 94
		refs = "000f TInternetExplorer.Get_FullName 001c @WStrClr 0027 TInternetExplorer.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78298_0 {
	meta:
		name = "TInternetExplorerMedium.Get_FullName"
		size = 94
		refs = "000f TInternetExplorerMedium.Get_FullName 001c @WStrClr 0027 TInternetExplorerMedium.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76574_0 {
	meta:
		name = "TJournalItem.Get_OutlookVersion"
		size = 94
		refs = "000f TJournalItem.Get_OutlookVersion 001c @WStrClr 0027 TJournalItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75902_0 {
	meta:
		name = "TMailItem.Get_OutlookVersion"
		size = 94
		refs = "000f TMailItem.Get_OutlookVersion 001c @WStrClr 0027 TMailItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77341_0 {
	meta:
		name = "TOutlookApplication.Get_Assistance"
		size = 94
		refs = "000f TOutlookApplication.Get_Assistance 001c @IntfClear 0027 TOutlookApplication.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76757_0 {
	meta:
		name = "TPostItem.Get_OutlookVersion"
		size = 94
		refs = "000f TPostItem.Get_OutlookVersion 001c @WStrClr 0027 TPostItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76830_0 {
	meta:
		name = "TRemoteItem.Get_OutlookVersion"
		size = 94
		refs = "000f TRemoteItem.Get_OutlookVersion 001c @WStrClr 0027 TRemoteItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76896_0 {
	meta:
		name = "TReportItem.Get_OutlookVersion"
		size = 94
		refs = "000f TReportItem.Get_OutlookVersion 001c @WStrClr 0027 TReportItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78481_0 {
	meta:
		name = "TShellNameSpace.SelectedItems"
		size = 94
		refs = "000f TShellNameSpace.SelectedItems 001c @IntfClear 0027 TShellNameSpace.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76958_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_OutlookVersion"
		size = 94
		refs = "000f TTaskRequestAcceptItem.Get_OutlookVersion 001c @WStrClr 0027 TTaskRequestAcceptItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77021_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_OutlookVersion"
		size = 94
		refs = "000f TTaskRequestDeclineItem.Get_OutlookVersion 001c @WStrClr 0027 TTaskRequestDeclineItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77084_0 {
	meta:
		name = "TTaskRequestItem.Get_OutlookVersion"
		size = 94
		refs = "000f TTaskRequestItem.Get_OutlookVersion 001c @WStrClr 0027 TTaskRequestItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77147_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_OutlookVersion"
		size = 94
		refs = "000f TTaskRequestUpdateItem.Get_OutlookVersion 001c @WStrClr 0027 TTaskRequestUpdateItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1840_0 {
	meta:
		name = "TWizHook.OfficeAddInDir"
		size = 94
		refs = "000f TWizHook.OfficeAddInDir 001c @WStrClr 0027 TWizHook.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_150206_0 {
	meta:
		name = "TWordDocument.Get_Variables"
		size = 94
		refs = "000f TWordDocument.Get_Variables 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_872_0 {
	meta:
		name = "T_CustomControlInReport.Get_Controls"
		size = 94
		refs = "000f T_CustomControlInReport.Get_Controls 001c @IntfClear 0027 T_CustomControlInReport.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_276_0 {
	meta:
		name = "T_OptionButtonInOption.Get_Value"
		size = 94
		refs = "000f T_OptionButtonInOption.Get_Value 001c @VarClr 0027 T_OptionButtonInOption.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_194_0 {
	meta:
		name = "TAccessCommandButton.Get_PictureData"
		size = 94
		refs = "000f TAccessCommandButton.Get_PictureData 001c @VarClr 0027 TAccessCommandButton.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 CC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1408_0 {
	meta:
		name = "TAccessReport.Get_MenuBar"
		size = 94
		refs = "000f TAccessReport.Get_MenuBar 001c @WStrClr 0027 TAccessReport.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 CC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_51652_0 {
	meta:
		name = "TExcelApplication.Get_Windows"
		size = 94
		refs = "000f TExcelApplication.Get_Windows 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 CC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52809_0 {
	meta:
		name = "TExcelGlobal.Get_Windows"
		size = 94
		refs = "000f TExcelGlobal.Get_Windows 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 CC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75683_0 {
	meta:
		name = "TPowerPointApplication.Get_DefaultWebOptions"
		size = 94
		refs = "000f TPowerPointApplication.Get_DefaultWebOptions 001c @IntfClear 0027 TPowerPointApplication.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 CC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2840_0 {
	meta:
		name = "TReportOld.Get_MenuBar"
		size = 94
		refs = "000f TReportOld.Get_MenuBar 001c @WStrClr 0027 TReportOld.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 CC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149161_0 {
	meta:
		name = "TWordLetterContent.Get_SenderCompany"
		size = 94
		refs = "000f TWordLetterContent.Get_SenderCompany 001c @WStrClr 0027 TWordLetterContent.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 CC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_195_0 {
	meta:
		name = "TAccessCommandButton.Set_PictureData"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessCommandButton.Set_PictureData 0041 TAccessCommandButton.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 D0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_196_0 {
	meta:
		name = "TAccessCommandButton.Get_ObjectPalette"
		size = 94
		refs = "000f TAccessCommandButton.Get_ObjectPalette 001c @VarClr 0027 TAccessCommandButton.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 F4 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1924_0 {
	meta:
		name = "TAccessApplication.Get_Printer"
		size = 94
		refs = "000f TAccessApplication.Get_Printer 001c @IntfClear 0027 TAccessApplication.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 F4 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76150_0 {
	meta:
		name = "TContactItem.Get_FileAs"
		size = 94
		refs = "000f TContactItem.Get_FileAs 001c @WStrClr 0027 TContactItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 F4 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148671_0 {
	meta:
		name = "TWordDocument.Get_ReadabilityStatistics"
		size = 94
		refs = "000f TWordDocument.Get_ReadabilityStatistics 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 F4 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_197_0 {
	meta:
		name = "TAccessCommandButton.Set_ObjectPalette"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessCommandButton.Set_ObjectPalette 0041 TAccessCommandButton.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 F8 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_207_0 {
	meta:
		name = "TAccessCommandButton.SizeToFit"
		size = 82
		refs = "000c TAccessCommandButton.SizeToFit 001c TAccessCommandButton.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_247_0 {
	meta:
		name = "TAccessOptionButton.SizeToFit"
		size = 82
		refs = "000c TAccessOptionButton.SizeToFit 001c TAccessOptionButton.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_928_0 {
	meta:
		name = "TAccessTabControl.SizeToFit"
		size = 82
		refs = "000c TAccessTabControl.SizeToFit 001c TAccessTabControl.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78253_0 {
	meta:
		name = "TInternetExplorer.Quit"
		size = 82
		refs = "000c TInternetExplorer.Quit 001c TInternetExplorer.GetDefaultInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78340_0 {
	meta:
		name = "TInternetExplorerMedium.Quit"
		size = 82
		refs = "000c TInternetExplorerMedium.Quit 001c TInternetExplorerMedium.GetDefaultInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78166_0 {
	meta:
		name = "TWebBrowser.Quit"
		size = 82
		refs = "000c TWebBrowser.Quit 001c TWebBrowser.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_287_0 {
	meta:
		name = "T_OptionButtonInOption.SizeToFit"
		size = 82
		refs = "000c T_OptionButtonInOption.SizeToFit 001c T_OptionButtonInOption.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_208_0 {
	meta:
		name = "TAccessCommandButton.Requery"
		size = 82
		refs = "000c TAccessCommandButton.Requery 001c TAccessCommandButton.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_328_0 {
	meta:
		name = "TAccessCheckBox.SizeToFit"
		size = 82
		refs = "000c TAccessCheckBox.SizeToFit 001c TAccessCheckBox.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_248_0 {
	meta:
		name = "TAccessOptionButton.Requery"
		size = 82
		refs = "000c TAccessOptionButton.Requery 001c TAccessOptionButton.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_410_0 {
	meta:
		name = "TAccessOptionGroup.SizeToFit"
		size = 82
		refs = "000c TAccessOptionGroup.SizeToFit 001c TAccessOptionGroup.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_966_0 {
	meta:
		name = "TAccessPage.Requery"
		size = 82
		refs = "000c TAccessPage.Requery 001c TAccessPage.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_788_0 {
	meta:
		name = "TAccessSubForm.SizeToFit"
		size = 82
		refs = "000c TAccessSubForm.SizeToFit 001c TAccessSubForm.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_497_0 {
	meta:
		name = "TAccessTextBox.SizeToFit"
		size = 82
		refs = "000c TAccessTextBox.SizeToFit 001c TAccessTextBox.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_688_0 {
	meta:
		name = "TAccessToggleButton.SizeToFit"
		size = 82
		refs = "000c TAccessToggleButton.SizeToFit 001c TAccessToggleButton.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_369_0 {
	meta:
		name = "T_CheckBoxInOption.SizeToFit"
		size = 82
		refs = "000c T_CheckBoxInOption.SizeToFit 001c T_CheckBoxInOption.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_288_0 {
	meta:
		name = "T_OptionButtonInOption.Requery"
		size = 82
		refs = "000c T_OptionButtonInOption.Requery 001c T_OptionButtonInOption.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_733_0 {
	meta:
		name = "T_ToggleButtonInOption.SizeToFit"
		size = 82
		refs = "000c T_ToggleButtonInOption.SizeToFit 001c T_ToggleButtonInOption.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_209_0 {
	meta:
		name = "TAccessCommandButton.Goto_"
		size = 82
		refs = "000c TAccessCommandButton.Goto_ 001c TAccessCommandButton.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_454_0 {
	meta:
		name = "TAccessBoundObjectFrame.SizeToFit"
		size = 82
		refs = "000c TAccessBoundObjectFrame.SizeToFit 001c TAccessBoundObjectFrame.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_329_0 {
	meta:
		name = "TAccessCheckBox.Requery"
		size = 82
		refs = "000c TAccessCheckBox.Requery 001c TAccessCheckBox.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_842_0 {
	meta:
		name = "TAccessCustomControl.SizeToFit"
		size = 82
		refs = "000c TAccessCustomControl.SizeToFit 001c TAccessCustomControl.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_634_0 {
	meta:
		name = "TAccessObjectFrame.SizeToFit"
		size = 82
		refs = "000c TAccessObjectFrame.SizeToFit 001c TAccessObjectFrame.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_249_0 {
	meta:
		name = "TAccessOptionButton.Goto_"
		size = 82
		refs = "000c TAccessOptionButton.Goto_ 001c TAccessOptionButton.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_411_0 {
	meta:
		name = "TAccessOptionGroup.Requery"
		size = 82
		refs = "000c TAccessOptionGroup.Requery 001c TAccessOptionGroup.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_967_0 {
	meta:
		name = "TAccessPage.Goto_"
		size = 82
		refs = "000c TAccessPage.Goto_ 001c TAccessPage.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_498_0 {
	meta:
		name = "TAccessTextBox.Requery"
		size = 82
		refs = "000c TAccessTextBox.Requery 001c TAccessTextBox.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_689_0 {
	meta:
		name = "TAccessToggleButton.Requery"
		size = 82
		refs = "000c TAccessToggleButton.Requery 001c TAccessToggleButton.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_370_0 {
	meta:
		name = "T_CheckBoxInOption.Requery"
		size = 82
		refs = "000c T_CheckBoxInOption.Requery 001c T_CheckBoxInOption.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_888_0 {
	meta:
		name = "T_CustomControlInReport.SizeToFit"
		size = 82
		refs = "000c T_CustomControlInReport.SizeToFit 001c T_CustomControlInReport.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_289_0 {
	meta:
		name = "T_OptionButtonInOption.Goto_"
		size = 82
		refs = "000c T_OptionButtonInOption.Goto_ 001c T_OptionButtonInOption.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_734_0 {
	meta:
		name = "T_ToggleButtonInOption.Requery"
		size = 82
		refs = "000c T_ToggleButtonInOption.Requery 001c T_ToggleButtonInOption.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_210_0 {
	meta:
		name = "TAccessCommandButton.SetFocus"
		size = 82
		refs = "000c TAccessCommandButton.SetFocus 001c TAccessCommandButton.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_455_0 {
	meta:
		name = "TAccessBoundObjectFrame.Requery"
		size = 82
		refs = "000c TAccessBoundObjectFrame.Requery 001c TAccessBoundObjectFrame.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_330_0 {
	meta:
		name = "TAccessCheckBox.Goto_"
		size = 82
		refs = "000c TAccessCheckBox.Goto_ 001c TAccessCheckBox.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_843_0 {
	meta:
		name = "TAccessCustomControl.Requery"
		size = 82
		refs = "000c TAccessCustomControl.Requery 001c TAccessCustomControl.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_635_0 {
	meta:
		name = "TAccessObjectFrame.Requery"
		size = 82
		refs = "000c TAccessObjectFrame.Requery 001c TAccessObjectFrame.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_250_0 {
	meta:
		name = "TAccessOptionButton.SetFocus"
		size = 82
		refs = "000c TAccessOptionButton.SetFocus 001c TAccessOptionButton.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_412_0 {
	meta:
		name = "TAccessOptionGroup.Goto_"
		size = 82
		refs = "000c TAccessOptionGroup.Goto_ 001c TAccessOptionGroup.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_968_0 {
	meta:
		name = "TAccessPage.SetFocus"
		size = 82
		refs = "000c TAccessPage.SetFocus 001c TAccessPage.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_790_0 {
	meta:
		name = "TAccessSubForm.Goto_"
		size = 82
		refs = "000c TAccessSubForm.Goto_ 001c TAccessSubForm.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_499_0 {
	meta:
		name = "TAccessTextBox.Goto_"
		size = 82
		refs = "000c TAccessTextBox.Goto_ 001c TAccessTextBox.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_690_0 {
	meta:
		name = "TAccessToggleButton.Goto_"
		size = 82
		refs = "000c TAccessToggleButton.Goto_ 001c TAccessToggleButton.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_4889_0 {
	meta:
		name = "TBinder.ViewOpenMode"
		size = 82
		refs = "000c TBinder.ViewOpenMode 001c TBinder.GetDefaultInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_371_0 {
	meta:
		name = "T_CheckBoxInOption.Goto_"
		size = 82
		refs = "000c T_CheckBoxInOption.Goto_ 001c T_CheckBoxInOption.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_889_0 {
	meta:
		name = "T_CustomControlInReport.Requery"
		size = 82
		refs = "000c T_CustomControlInReport.Requery 001c T_CustomControlInReport.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_290_0 {
	meta:
		name = "T_OptionButtonInOption.SetFocus"
		size = 82
		refs = "000c T_OptionButtonInOption.SetFocus 001c T_OptionButtonInOption.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_735_0 {
	meta:
		name = "T_ToggleButtonInOption.Goto_"
		size = 82
		refs = "000c T_ToggleButtonInOption.Goto_ 001c T_ToggleButtonInOption.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_211_0 {
	meta:
		name = "TAccessCommandButton._Evaluate"
		size = 103
		refs = "0012 TAccessCommandButton._Evaluate 0020 @VarClr 002d TAccessCommandButton.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_251_0 {
	meta:
		name = "TAccessOptionButton._Evaluate"
		size = 103
		refs = "0012 TAccessOptionButton._Evaluate 0020 @VarClr 002d TAccessOptionButton.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_77360_0 {
	meta:
		name = "TOutlookApplication.GetObjectReference"
		size = 103
		refs = "0012 TOutlookApplication.GetObjectReference 0020 @IntfClear 002d TOutlookApplication.GetDefaultInterface 003e @CheckAutoResult 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_291_0 {
	meta:
		name = "T_OptionButtonInOption._Evaluate"
		size = 103
		refs = "0012 T_OptionButtonInOption._Evaluate 0020 @VarClr 002d T_OptionButtonInOption.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_213_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 38 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 52 E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_214_0 {
	meta:
		name = "TAccessCheckBox.CreateControl"
		size = 29
		refs = "0015 DoCreate"
		altNames = "TAccessListBox.CreateControl TAccessOptionButton.CreateControl TAccessPaletteButton.CreateControl TAccessToggleButton.CreateControl"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC 83 B8 38 03 00 00 00 75 07 55 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_215_0 {
	meta:
		name = "TAccessOptionButton.GetControlInterface"
		size = 29
		refs = "0009 TAccessOptionButton.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 38 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_295_0 {
	meta:
		name = "TAccessCheckBox.GetControlInterface"
		size = 29
		refs = "0009 TAccessCheckBox.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 38 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_505_0 {
	meta:
		name = "TAccessListBox.GetControlInterface"
		size = 29
		refs = "0009 TAccessListBox.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 38 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_741_0 {
	meta:
		name = "TAccessPaletteButton.GetControlInterface"
		size = 29
		refs = "0009 TAccessPaletteButton.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 38 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_651_0 {
	meta:
		name = "TAccessToggleButton.GetControlInterface"
		size = 29
		refs = "0009 TAccessToggleButton.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 38 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_237_0 {
	meta:
		name = "TAccessOptionButton.Set_Value"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessOptionButton.Set_Value 0041 TAccessOptionButton.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_277_0 {
	meta:
		name = "T_OptionButtonInOption.Set_Value"
		size = 130
		refs = "001d @VarAddRef 0025 T_OptionButtonInOption.Set_Value 0041 T_OptionButtonInOption.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_253_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 18 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 52 E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_254_0 {
	meta:
		name = "TAccessSubForm.CreateControl"
		size = 29
		refs = "0015 DoCreate"
		altNames = "TAccessSubReport.CreateControl TScriptlet.CreateControl T_CheckBoxInOption.CreateControl T_OptionButtonInOption.CreateControl T_PageHdrFtrInReport.CreateControl T_ToggleButtonInOption.CreateControl"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC 83 B8 18 03 00 00 00 75 07 55 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_255_0 {
	meta:
		name = "T_OptionButtonInOption.GetControlInterface"
		size = 29
		refs = "0009 T_OptionButtonInOption.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 18 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_757_0 {
	meta:
		name = "TAccessSubForm.GetControlInterface"
		size = 29
		refs = "0009 TAccessSubForm.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 18 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_796_0 {
	meta:
		name = "TAccessSubReport.GetControlInterface"
		size = 29
		refs = "0009 TAccessSubReport.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 18 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_75398_0 {
	meta:
		name = "TScriptlet.GetControlInterface"
		size = 29
		refs = "0009 TScriptlet.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 18 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_336_0 {
	meta:
		name = "T_CheckBoxInOption.GetControlInterface"
		size = 29
		refs = "0009 T_CheckBoxInOption.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 18 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_995_0 {
	meta:
		name = "T_PageHdrFtrInReport.GetControlInterface"
		size = 29
		refs = "0009 T_PageHdrFtrInReport.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 18 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_696_0 {
	meta:
		name = "T_ToggleButtonInOption.GetControlInterface"
		size = 29
		refs = "0009 T_ToggleButtonInOption.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 18 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_293_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 38 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 54 E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_314_0 {
	meta:
		name = "TAccessCheckBox.Get_Properties"
		size = 94
		refs = "000f TAccessCheckBox.Get_Properties 001c @IntfClear 0027 TAccessCheckBox.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1030_0 {
	meta:
		name = "TAccessForm.Get_Filter"
		size = 94
		refs = "000f TAccessForm.Get_Filter 001c @WStrClr 0027 TAccessForm.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_396_0 {
	meta:
		name = "TAccessOptionGroup.Get_Properties"
		size = 94
		refs = "000f TAccessOptionGroup.Get_Properties 001c @IntfClear 0027 TAccessOptionGroup.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_777_0 {
	meta:
		name = "TAccessSubForm.Get_Properties"
		size = 94
		refs = "000f TAccessSubForm.Get_Properties 001c @IntfClear 0027 TAccessSubForm.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_481_0 {
	meta:
		name = "TAccessTextBox.Get_Properties"
		size = 94
		refs = "000f TAccessTextBox.Get_Properties 001c @IntfClear 0027 TAccessTextBox.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_670_0 {
	meta:
		name = "TAccessToggleButton.Get_Properties"
		size = 94
		refs = "000f TAccessToggleButton.Get_Properties 001c @IntfClear 0027 TAccessToggleButton.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_53471_0 {
	meta:
		name = "TExcelApplication.Get_DialogSheets"
		size = 94
		refs = "000f TExcelApplication.Get_DialogSheets 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52798_0 {
	meta:
		name = "TExcelGlobal.Get_DialogSheets"
		size = 94
		refs = "000f TExcelGlobal.Get_DialogSheets 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2462_0 {
	meta:
		name = "TFormOld.Get_Filter"
		size = 94
		refs = "000f TFormOld.Get_Filter 001c @WStrClr 0027 TFormOld.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75567_0 {
	meta:
		name = "TPowerPointPresentation.Get_Path"
		size = 94
		refs = "000f TPowerPointPresentation.Get_Path 001c @WStrClr 0027 TPowerPointPresentation.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78422_0 {
	meta:
		name = "TShellUIHelper.DefaultSearchProvider"
		size = 94
		refs = "000f TShellUIHelper.DefaultSearchProvider 001c @WStrClr 0027 TShellUIHelper.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149218_0 {
	meta:
		name = "TWordApplication.Get_AddIns"
		size = 94
		refs = "000f TWordApplication.Get_AddIns 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148578_0 {
	meta:
		name = "TWordDocument.Get_Characters"
		size = 94
		refs = "000f TWordDocument.Get_Characters 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_355_0 {
	meta:
		name = "T_CheckBoxInOption.Get_Properties"
		size = 94
		refs = "000f T_CheckBoxInOption.Get_Properties 001c @IntfClear 0027 T_CheckBoxInOption.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_715_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_Properties"
		size = 94
		refs = "000f T_ToggleButtonInOption.Get_Properties 001c @IntfClear 0027 T_ToggleButtonInOption.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_315_0 {
	meta:
		name = "TAccessCheckBox.Get_Controls"
		size = 94
		refs = "000f TAccessCheckBox.Get_Controls 001c @IntfClear 0027 TAccessCheckBox.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_397_0 {
	meta:
		name = "TAccessOptionGroup.Get_Controls"
		size = 94
		refs = "000f TAccessOptionGroup.Get_Controls 001c @IntfClear 0027 TAccessOptionGroup.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_482_0 {
	meta:
		name = "TAccessTextBox.Get_Controls"
		size = 94
		refs = "000f TAccessTextBox.Get_Controls 001c @IntfClear 0027 TAccessTextBox.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_671_0 {
	meta:
		name = "TAccessToggleButton.Get_Controls"
		size = 94
		refs = "000f TAccessToggleButton.Get_Controls 001c @IntfClear 0027 TAccessToggleButton.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_55604_0 {
	meta:
		name = "TExcelApplication.Get_MenuBars"
		size = 94
		refs = "000f TExcelApplication.Get_MenuBars 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52799_0 {
	meta:
		name = "TExcelGlobal.Get_MenuBars"
		size = 94
		refs = "000f TExcelGlobal.Get_MenuBars 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75596_0 {
	meta:
		name = "TPowerPointPresentation.NewWindow"
		size = 94
		refs = "000f TPowerPointPresentation.NewWindow 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75527_0 {
	meta:
		name = "TPowerPointSlide.Get_Scripts"
		size = 94
		refs = "000f TPowerPointSlide.Get_Scripts 001c @IntfClear 0027 TPowerPointSlide.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3288_0 {
	meta:
		name = "TWizHook.AccessUserDataDir"
		size = 94
		refs = "000f TWizHook.AccessUserDataDir 001c @WStrClr 0027 TWizHook.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148583_0 {
	meta:
		name = "TWordDocument.Get_TablesOfFigures"
		size = 94
		refs = "000f TWordDocument.Get_TablesOfFigures 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149147_0 {
	meta:
		name = "TWordLetterContent.Get_AttentionLine"
		size = 94
		refs = "000f TWordLetterContent.Get_AttentionLine 001c @WStrClr 0027 TWordLetterContent.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_356_0 {
	meta:
		name = "T_CheckBoxInOption.Get_Controls"
		size = 94
		refs = "000f T_CheckBoxInOption.Get_Controls 001c @IntfClear 0027 T_CheckBoxInOption.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_716_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_Controls"
		size = 94
		refs = "000f T_ToggleButtonInOption.Get_Controls 001c @IntfClear 0027 T_ToggleButtonInOption.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_316_0 {
	meta:
		name = "TAccessCheckBox.Get_Value"
		size = 94
		refs = "000f TAccessCheckBox.Get_Value 001c @VarClr 0027 TAccessCheckBox.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_398_0 {
	meta:
		name = "TAccessOptionGroup.Get_Value"
		size = 94
		refs = "000f TAccessOptionGroup.Get_Value 001c @VarClr 0027 TAccessOptionGroup.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1396_0 {
	meta:
		name = "TAccessReport.Get_Picture"
		size = 94
		refs = "000f TAccessReport.Get_Picture 001c @WStrClr 0027 TAccessReport.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_483_0 {
	meta:
		name = "TAccessTextBox.Get_Hyperlink"
		size = 94
		refs = "000f TAccessTextBox.Get_Hyperlink 001c @IntfClear 0027 TAccessTextBox.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_672_0 {
	meta:
		name = "TAccessToggleButton.Get_Value"
		size = 94
		refs = "000f TAccessToggleButton.Get_Value 001c @VarClr 0027 TAccessToggleButton.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_55606_0 {
	meta:
		name = "TExcelApplication.Get_Names"
		size = 94
		refs = "000f TExcelApplication.Get_Names 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52801_0 {
	meta:
		name = "TExcelGlobal.Get_Names"
		size = 94
		refs = "000f TExcelGlobal.Get_Names 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78212_0 {
	meta:
		name = "TInternetExplorer.Get_Path"
		size = 94
		refs = "000f TInternetExplorer.Get_Path 001c @WStrClr 0027 TInternetExplorer.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78299_0 {
	meta:
		name = "TInternetExplorerMedium.Get_Path"
		size = 94
		refs = "000f TInternetExplorerMedium.Get_Path 001c @WStrClr 0027 TInternetExplorerMedium.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77342_0 {
	meta:
		name = "TOutlookApplication.Get_TimeZones"
		size = 94
		refs = "000f TOutlookApplication.Get_TimeZones 001c @IntfClear 0027 TOutlookApplication.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2828_0 {
	meta:
		name = "TReportOld.Get_Picture"
		size = 94
		refs = "000f TReportOld.Get_Picture 001c @WStrClr 0027 TReportOld.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148585_0 {
	meta:
		name = "TWordDocument.Get_MailMerge"
		size = 94
		refs = "000f TWordDocument.Get_MailMerge 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149149_0 {
	meta:
		name = "TWordLetterContent.Get_Subject"
		size = 94
		refs = "000f TWordLetterContent.Get_Subject 001c @WStrClr 0027 TWordLetterContent.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_357_0 {
	meta:
		name = "T_CheckBoxInOption.Get_Value"
		size = 94
		refs = "000f T_CheckBoxInOption.Get_Value 001c @VarClr 0027 T_CheckBoxInOption.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_717_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_Value"
		size = 94
		refs = "000f T_ToggleButtonInOption.Get_Value 001c @VarClr 0027 T_ToggleButtonInOption.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_317_0 {
	meta:
		name = "TAccessCheckBox.Set_Value"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessCheckBox.Set_Value 0041 TAccessCheckBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 A0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_399_0 {
	meta:
		name = "TAccessOptionGroup.Set_Value"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessOptionGroup.Set_Value 0041 TAccessOptionGroup.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 A0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_673_0 {
	meta:
		name = "TAccessToggleButton.Set_Value"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessToggleButton.Set_Value 0041 TAccessToggleButton.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 A0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_358_0 {
	meta:
		name = "T_CheckBoxInOption.Set_Value"
		size = 130
		refs = "001d @VarAddRef 0025 T_CheckBoxInOption.Set_Value 0041 T_CheckBoxInOption.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 A0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_718_0 {
	meta:
		name = "T_ToggleButtonInOption.Set_Value"
		size = 130
		refs = "001d @VarAddRef 0025 T_ToggleButtonInOption.Set_Value 0041 T_ToggleButtonInOption.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 A0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_327_0 {
	meta:
		name = "TAccessCheckBox.Undo"
		size = 79
		refs = "000c TAccessCheckBox.Undo 001c TAccessCheckBox.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_588_0 {
	meta:
		name = "TAccessComboBox.Undo"
		size = 79
		refs = "000c TAccessComboBox.Undo 001c TAccessComboBox.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_543_0 {
	meta:
		name = "TAccessListBox.Undo"
		size = 79
		refs = "000c TAccessListBox.Undo 001c TAccessListBox.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_409_0 {
	meta:
		name = "TAccessOptionGroup.Undo"
		size = 79
		refs = "000c TAccessOptionGroup.Undo 001c TAccessOptionGroup.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_496_0 {
	meta:
		name = "TAccessTextBox.Undo"
		size = 79
		refs = "000c TAccessTextBox.Undo 001c TAccessTextBox.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_687_0 {
	meta:
		name = "TAccessToggleButton.Undo"
		size = 79
		refs = "000c TAccessToggleButton.Undo 001c TAccessToggleButton.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_368_0 {
	meta:
		name = "T_CheckBoxInOption.Undo"
		size = 79
		refs = "000c T_CheckBoxInOption.Undo 001c T_CheckBoxInOption.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_732_0 {
	meta:
		name = "T_ToggleButtonInOption.Undo"
		size = 79
		refs = "000c T_ToggleButtonInOption.Undo 001c T_ToggleButtonInOption.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_331_0 {
	meta:
		name = "TAccessCheckBox.SetFocus"
		size = 82
		refs = "000c TAccessCheckBox.SetFocus 001c TAccessCheckBox.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_456_0 {
	meta:
		name = "TAccessBoundObjectFrame.Goto_"
		size = 82
		refs = "000c TAccessBoundObjectFrame.Goto_ 001c TAccessBoundObjectFrame.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_590_0 {
	meta:
		name = "TAccessComboBox.SizeToFit"
		size = 82
		refs = "000c TAccessComboBox.SizeToFit 001c TAccessComboBox.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_844_0 {
	meta:
		name = "TAccessCustomControl.Goto_"
		size = 82
		refs = "000c TAccessCustomControl.Goto_ 001c TAccessCustomControl.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_636_0 {
	meta:
		name = "TAccessObjectFrame.Goto_"
		size = 82
		refs = "000c TAccessObjectFrame.Goto_ 001c TAccessObjectFrame.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_413_0 {
	meta:
		name = "TAccessOptionGroup.SetFocus"
		size = 82
		refs = "000c TAccessOptionGroup.SetFocus 001c TAccessOptionGroup.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_791_0 {
	meta:
		name = "TAccessSubForm.SetFocus"
		size = 82
		refs = "000c TAccessSubForm.SetFocus 001c TAccessSubForm.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_500_0 {
	meta:
		name = "TAccessTextBox.SetFocus"
		size = 82
		refs = "000c TAccessTextBox.SetFocus 001c TAccessTextBox.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_691_0 {
	meta:
		name = "TAccessToggleButton.SetFocus"
		size = 82
		refs = "000c TAccessToggleButton.SetFocus 001c TAccessToggleButton.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_4890_0 {
	meta:
		name = "TBinder.ExitOpenMode"
		size = 82
		refs = "000c TBinder.ExitOpenMode 001c TBinder.GetDefaultInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_372_0 {
	meta:
		name = "T_CheckBoxInOption.SetFocus"
		size = 82
		refs = "000c T_CheckBoxInOption.SetFocus 001c T_CheckBoxInOption.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_890_0 {
	meta:
		name = "T_CustomControlInReport.Goto_"
		size = 82
		refs = "000c T_CustomControlInReport.Goto_ 001c T_CustomControlInReport.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_736_0 {
	meta:
		name = "T_ToggleButtonInOption.SetFocus"
		size = 82
		refs = "000c T_ToggleButtonInOption.SetFocus 001c T_ToggleButtonInOption.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_332_0 {
	meta:
		name = "TAccessCheckBox._Evaluate"
		size = 103
		refs = "0012 TAccessCheckBox._Evaluate 0020 @VarClr 002d TAccessCheckBox.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_414_0 {
	meta:
		name = "TAccessOptionGroup._Evaluate"
		size = 103
		refs = "0012 TAccessOptionGroup._Evaluate 0020 @VarClr 002d TAccessOptionGroup.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_501_0 {
	meta:
		name = "TAccessTextBox._Evaluate"
		size = 103
		refs = "0012 TAccessTextBox._Evaluate 0020 @VarClr 002d TAccessTextBox.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_692_0 {
	meta:
		name = "TAccessToggleButton._Evaluate"
		size = 103
		refs = "0012 TAccessToggleButton._Evaluate 0020 @VarClr 002d TAccessToggleButton.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_373_0 {
	meta:
		name = "T_CheckBoxInOption._Evaluate"
		size = 103
		refs = "0012 T_CheckBoxInOption._Evaluate 0020 @VarClr 002d T_CheckBoxInOption.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_737_0 {
	meta:
		name = "T_ToggleButtonInOption._Evaluate"
		size = 103
		refs = "0012 T_ToggleButtonInOption._Evaluate 0020 @VarClr 002d T_ToggleButtonInOption.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_334_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 18 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 54 E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_375_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 28 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 56 E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_416_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 40 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 58 E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_417_0 {
	meta:
		name = "TAccessBoundObjectFrame.CreateControl"
		size = 29
		refs = "0015 DoCreate"
		altNames = "TAccessTextBox.CreateControl"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC 83 B8 40 03 00 00 00 75 07 55 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_418_0 {
	meta:
		name = "TAccessBoundObjectFrame.GetControlInterface"
		size = 29
		refs = "0009 TAccessBoundObjectFrame.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 40 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_462_0 {
	meta:
		name = "TAccessTextBox.GetControlInterface"
		size = 29
		refs = "0009 TAccessTextBox.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 40 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_438_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_ObjectVerbs"
		size = 99
		refs = "0012 TAccessBoundObjectFrame.Get_ObjectVerbs 001f @WStrClr 002b TAccessBoundObjectFrame.GetControlInterface 003c @CheckAutoResult 0051 @IntfClear 0057 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_824_0 {
	meta:
		name = "TAccessCustomControl.Get_ObjectVerbs"
		size = 99
		refs = "0012 TAccessCustomControl.Get_ObjectVerbs 001f @WStrClr 002b TAccessCustomControl.GetControlInterface 003c @CheckAutoResult 0051 @IntfClear 0057 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_618_0 {
	meta:
		name = "TAccessObjectFrame.Get_ObjectVerbs"
		size = 99
		refs = "0012 TAccessObjectFrame.Get_ObjectVerbs 001f @WStrClr 002b TAccessObjectFrame.GetControlInterface 003c @CheckAutoResult 0051 @IntfClear 0057 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_870_0 {
	meta:
		name = "T_CustomControlInReport.Get_ObjectVerbs"
		size = 99
		refs = "0012 T_CustomControlInReport.Get_ObjectVerbs 001f @WStrClr 002b T_CustomControlInReport.GetControlInterface 003c @CheckAutoResult 0051 @IntfClear 0057 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_441_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_Value"
		size = 94
		refs = "000f TAccessBoundObjectFrame.Get_Value 001c @VarClr 0027 TAccessBoundObjectFrame.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_574_0 {
	meta:
		name = "TAccessComboBox.Get_Controls"
		size = 94
		refs = "000f TAccessComboBox.Get_Controls 001c @IntfClear 0027 TAccessComboBox.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_827_0 {
	meta:
		name = "TAccessCustomControl.Get_Value"
		size = 94
		refs = "000f TAccessCustomControl.Get_Value 001c @VarClr 0027 TAccessCustomControl.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_484_0 {
	meta:
		name = "TAccessTextBox.Get_FormatConditions"
		size = 94
		refs = "000f TAccessTextBox.Get_FormatConditions 001c @IntfClear 0027 TAccessTextBox.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_53000_0 {
	meta:
		name = "TExcelWorkbook.Get_CustomDocumentProperties"
		size = 94
		refs = "000f TExcelWorkbook.Get_CustomDocumentProperties 001c @IntfClear 0027 TExcelWorkbook.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77343_0 {
	meta:
		name = "TOutlookApplication.Get_PickerDialog"
		size = 94
		refs = "000f TOutlookApplication.Get_PickerDialog 001c @IntfClear 0027 TOutlookApplication.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1808_0 {
	meta:
		name = "TWizHook.Get_DbcVbProject"
		size = 94
		refs = "000f TWizHook.Get_DbcVbProject 001c @IntfClear 0027 TWizHook.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149226_0 {
	meta:
		name = "TWordApplication.Get_Tasks"
		size = 94
		refs = "000f TWordApplication.Get_Tasks 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148586_0 {
	meta:
		name = "TWordDocument.Get_Envelope"
		size = 94
		refs = "000f TWordDocument.Get_Envelope 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_873_0 {
	meta:
		name = "T_CustomControlInReport.Get_Value"
		size = 94
		refs = "000f T_CustomControlInReport.Get_Value 001c @VarClr 0027 T_CustomControlInReport.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_442_0 {
	meta:
		name = "TAccessBoundObjectFrame.Set_Value"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessBoundObjectFrame.Set_Value 0041 TAccessBoundObjectFrame.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 A4 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_828_0 {
	meta:
		name = "TAccessCustomControl.Set_Value"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessCustomControl.Set_Value 0041 TAccessCustomControl.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 A4 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_874_0 {
	meta:
		name = "T_CustomControlInReport.Set_Value"
		size = 130
		refs = "001d @VarAddRef 0025 T_CustomControlInReport.Set_Value 0041 T_CustomControlInReport.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 A4 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_443_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_ObjectPalette"
		size = 94
		refs = "000f TAccessBoundObjectFrame.Get_ObjectPalette 001c @VarClr 0027 TAccessBoundObjectFrame.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 18 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_53064_0 {
	meta:
		name = "TExcelWorkbook.Get_Excel4IntlMacroSheets"
		size = 94
		refs = "000f TExcelWorkbook.Get_Excel4IntlMacroSheets 001c @IntfClear 0027 TExcelWorkbook.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 18 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_444_0 {
	meta:
		name = "TAccessBoundObjectFrame.Set_ObjectPalette"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessBoundObjectFrame.Set_ObjectPalette 0041 TAccessBoundObjectFrame.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 1C 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_457_0 {
	meta:
		name = "TAccessBoundObjectFrame.SetFocus"
		size = 82
		refs = "000c TAccessBoundObjectFrame.SetFocus 001c TAccessBoundObjectFrame.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_591_0 {
	meta:
		name = "TAccessComboBox.Requery"
		size = 82
		refs = "000c TAccessComboBox.Requery 001c TAccessComboBox.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_845_0 {
	meta:
		name = "TAccessCustomControl.SetFocus"
		size = 82
		refs = "000c TAccessCustomControl.SetFocus 001c TAccessCustomControl.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_544_0 {
	meta:
		name = "TAccessListBox.SizeToFit"
		size = 82
		refs = "000c TAccessListBox.SizeToFit 001c TAccessListBox.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_637_0 {
	meta:
		name = "TAccessObjectFrame.SetFocus"
		size = 82
		refs = "000c TAccessObjectFrame.SetFocus 001c TAccessObjectFrame.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_792_0 {
	meta:
		name = "TAccessSubForm.Requery"
		size = 82
		refs = "000c TAccessSubForm.Requery 001c TAccessSubForm.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_891_0 {
	meta:
		name = "T_CustomControlInReport.SetFocus"
		size = 82
		refs = "000c T_CustomControlInReport.SetFocus 001c T_CustomControlInReport.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 94 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_458_0 {
	meta:
		name = "TAccessBoundObjectFrame._Evaluate"
		size = 103
		refs = "0012 TAccessBoundObjectFrame._Evaluate 0020 @VarClr 002d TAccessBoundObjectFrame.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_846_0 {
	meta:
		name = "TAccessCustomControl._Evaluate"
		size = 103
		refs = "0012 TAccessCustomControl._Evaluate 0020 @VarClr 002d TAccessCustomControl.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_638_0 {
	meta:
		name = "TAccessObjectFrame._Evaluate"
		size = 103
		refs = "0012 TAccessObjectFrame._Evaluate 0020 @VarClr 002d TAccessObjectFrame.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_1841_0 {
	meta:
		name = "TWizHook.EmbedFileOnDataPage"
		size = 103
		refs = "0012 TWizHook.EmbedFileOnDataPage 0020 @WStrClr 002d TWizHook.GetDefaultInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_892_0 {
	meta:
		name = "T_CustomControlInReport._Evaluate"
		size = 103
		refs = "0012 T_CustomControlInReport._Evaluate 0020 @VarClr 002d T_CustomControlInReport.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_460_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 40 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 46 E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_485_0 {
	meta:
		name = "TAccessTextBox.Get_Value"
		size = 94
		refs = "000f TAccessTextBox.Get_Value 001c @VarClr 0027 TAccessTextBox.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A4 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_529_0 {
	meta:
		name = "TAccessListBox.Get_Controls"
		size = 94
		refs = "000f TAccessListBox.Get_Controls 001c @IntfClear 0027 TAccessListBox.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A4 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_51646_0 {
	meta:
		name = "TExcelApplication.Get_Rows"
		size = 94
		refs = "000f TExcelApplication.Get_Rows 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A4 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52226_0 {
	meta:
		name = "TExcelChart.Get_Shapes"
		size = 94
		refs = "000f TExcelChart.Get_Shapes 001c @IntfClear 0027 TExcelChart.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A4 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52803_0 {
	meta:
		name = "TExcelGlobal.Get_Rows"
		size = 94
		refs = "000f TExcelGlobal.Get_Rows 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A4 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52531_0 {
	meta:
		name = "TExcelWorksheet.Get_Shapes"
		size = 94
		refs = "000f TExcelWorksheet.Get_Shapes 001c @IntfClear 0027 TExcelWorksheet.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A4 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75572_0 {
	meta:
		name = "TPowerPointPresentation.Get_PrintOptions"
		size = 94
		refs = "000f TPowerPointPresentation.Get_PrintOptions 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A4 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148587_0 {
	meta:
		name = "TWordDocument.Get_FullName"
		size = 94
		refs = "000f TWordDocument.Get_FullName 001c @WStrClr 0027 TWordDocument.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A4 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_486_0 {
	meta:
		name = "TAccessTextBox.Set_Value"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessTextBox.Set_Value 0041 TAccessTextBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 A8 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_503_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 38 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 5A E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_523_0 {
	meta:
		name = "TAccessListBox.Get_Column"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessListBox.Get_Column 0035 @VarClr 004d TAccessListBox.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_524_0 {
	meta:
		name = "TAccessListBox.Get_Selected"
		size = 103
		refs = "0015 TAccessListBox.Get_Selected 002a TAccessListBox.GetControlInterface 003b @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 56 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_525_0 {
	meta:
		name = "TAccessListBox.Set_Selected"
		size = 92
		refs = "0012 TAccessListBox.Set_Selected 0024 TAccessListBox.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78254_0 {
	meta:
		name = "TInternetExplorer.ClientToWindow"
		size = 92
		refs = "0012 TInternetExplorer.ClientToWindow 0024 TInternetExplorer.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78341_0 {
	meta:
		name = "TInternetExplorerMedium.ClientToWindow"
		size = 92
		refs = "0012 TInternetExplorerMedium.ClientToWindow 0024 TInternetExplorerMedium.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78167_0 {
	meta:
		name = "TWebBrowser.ClientToWindow"
		size = 92
		refs = "0012 TWebBrowser.ClientToWindow 0024 TWebBrowser.GetControlInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_526_0 {
	meta:
		name = "TAccessListBox.Get_OldValue"
		size = 94
		refs = "000f TAccessListBox.Get_OldValue 001c @VarClr 0027 TAccessListBox.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77338_0 {
	meta:
		name = "TOutlookApplication.Get_Reminders"
		size = 94
		refs = "000f TOutlookApplication.Get_Reminders 001c @IntfClear 0027 TOutlookApplication.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75525_0 {
	meta:
		name = "TPowerPointSlide.Get_Master"
		size = 94
		refs = "000f TPowerPointSlide.Get_Master 001c @IntfClear 0027 TPowerPointSlide.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78465_0 {
	meta:
		name = "TShellNameSpace.Get_Columns"
		size = 94
		refs = "000f TShellNameSpace.Get_Columns 001c @WStrClr 0027 TShellNameSpace.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148580_0 {
	meta:
		name = "TWordDocument.Get_FormFields"
		size = 94
		refs = "000f TWordDocument.Get_FormFields 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_527_0 {
	meta:
		name = "TAccessListBox.Get_ItemData"
		size = 99
		refs = "0012 TAccessListBox.Get_ItemData 001f @VarClr 002b TAccessListBox.GetControlInterface 003c @CheckAutoResult 0051 @IntfClear 0057 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78256_0 {
	meta:
		name = "TInternetExplorer.GetProperty"
		size = 99
		refs = "0012 TInternetExplorer.GetProperty 001f @VarClr 002b TInternetExplorer.GetDefaultInterface 003c @CheckAutoResult 0051 @IntfClear 0057 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78343_0 {
	meta:
		name = "TInternetExplorerMedium.GetProperty"
		size = 99
		refs = "0012 TInternetExplorerMedium.GetProperty 001f @VarClr 002b TInternetExplorerMedium.GetDefaultInterface 003c @CheckAutoResult 0051 @IntfClear 0057 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78169_0 {
	meta:
		name = "TWebBrowser.GetProperty"
		size = 99
		refs = "0012 TWebBrowser.GetProperty 001f @VarClr 002b TWebBrowser.GetControlInterface 003c @CheckAutoResult 0051 @IntfClear 0057 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_530_0 {
	meta:
		name = "TAccessListBox.Get_ItemsSelected"
		size = 94
		refs = "000f TAccessListBox.Get_ItemsSelected 001c @IntfClear 0027 TAccessListBox.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A8 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_575_0 {
	meta:
		name = "TAccessComboBox.Get_Hyperlink"
		size = 94
		refs = "000f TAccessComboBox.Get_Hyperlink 001c @IntfClear 0027 TAccessComboBox.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A8 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1040_0 {
	meta:
		name = "TAccessForm.Get_Caption"
		size = 94
		refs = "000f TAccessForm.Get_Caption 001c @WStrClr 0027 TAccessForm.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A8 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2472_0 {
	meta:
		name = "TFormOld.Get_Caption"
		size = 94
		refs = "000f TFormOld.Get_Caption 001c @WStrClr 0027 TFormOld.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A8 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148588_0 {
	meta:
		name = "TWordDocument.Get_Revisions"
		size = 94
		refs = "000f TWordDocument.Get_Revisions 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A8 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_531_0 {
	meta:
		name = "TAccessListBox.Get_Hyperlink"
		size = 94
		refs = "000f TAccessListBox.Get_Hyperlink 001c @IntfClear 0027 TAccessListBox.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 B0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_577_0 {
	meta:
		name = "TAccessComboBox.Get_Value"
		size = 94
		refs = "000f TAccessComboBox.Get_Value 001c @VarClr 0027 TAccessComboBox.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 B0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_53003_0 {
	meta:
		name = "TExcelWorkbook.Get_DialogSheets"
		size = 94
		refs = "000f TExcelWorkbook.Get_DialogSheets 001c @IntfClear 0027 TExcelWorkbook.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 B0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78217_0 {
	meta:
		name = "TInternetExplorer.Get_StatusText"
		size = 94
		refs = "000f TInternetExplorer.Get_StatusText 001c @WStrClr 0027 TInternetExplorer.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 B0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78304_0 {
	meta:
		name = "TInternetExplorerMedium.Get_StatusText"
		size = 94
		refs = "000f TInternetExplorerMedium.Get_StatusText 001c @WStrClr 0027 TInternetExplorerMedium.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 B0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148590_0 {
	meta:
		name = "TWordDocument.Get_TablesOfAuthorities"
		size = 94
		refs = "000f TWordDocument.Get_TablesOfAuthorities 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 B0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_532_0 {
	meta:
		name = "TAccessListBox.Get_Value"
		size = 94
		refs = "000f TAccessListBox.Get_Value 001c @VarClr 0027 TAccessListBox.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 B4 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148591_0 {
	meta:
		name = "TWordDocument.Get_PageSetup"
		size = 94
		refs = "000f TWordDocument.Get_PageSetup 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 B4 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149155_0 {
	meta:
		name = "TWordLetterContent.Get_ReturnAddress"
		size = 94
		refs = "000f TWordLetterContent.Get_ReturnAddress 001c @WStrClr 0027 TWordLetterContent.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 B4 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_533_0 {
	meta:
		name = "TAccessListBox.Set_Value"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessListBox.Set_Value 0041 TAccessListBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 B8 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_545_0 {
	meta:
		name = "TAccessListBox.Requery"
		size = 82
		refs = "000c TAccessListBox.Requery 001c TAccessListBox.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_592_0 {
	meta:
		name = "TAccessComboBox.Goto_"
		size = 82
		refs = "000c TAccessComboBox.Goto_ 001c TAccessComboBox.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 98 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_546_0 {
	meta:
		name = "TAccessListBox.Goto_"
		size = 82
		refs = "000c TAccessListBox.Goto_ 001c TAccessListBox.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_593_0 {
	meta:
		name = "TAccessComboBox.SetFocus"
		size = 82
		refs = "000c TAccessComboBox.SetFocus 001c TAccessComboBox.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_75598_0 {
	meta:
		name = "TPowerPointPresentation.AddToFavorites"
		size = 82
		refs = "000c TPowerPointPresentation.AddToFavorites 001c TPowerPointPresentation.GetDefaultInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 9C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_547_0 {
	meta:
		name = "TAccessListBox.SetFocus"
		size = 82
		refs = "000c TAccessListBox.SetFocus 001c TAccessListBox.GetControlInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78483_0 {
	meta:
		name = "TShellNameSpace.UnselectAll"
		size = 82
		refs = "000c TShellNameSpace.UnselectAll 001c TShellNameSpace.GetDefaultInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_78431_0 {
	meta:
		name = "TShellUIHelper.BuildNewTabPage"
		size = 82
		refs = "000c TShellUIHelper.BuildNewTabPage 001c TShellUIHelper.GetDefaultInterface 002d @CheckAutoResult 0042 @IntfClear 0048 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_548_0 {
	meta:
		name = "TAccessListBox._Evaluate"
		size = 103
		refs = "0012 TAccessListBox._Evaluate 0020 @VarClr 002d TAccessListBox.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 AC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_550_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 48 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 5C E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_551_0 {
	meta:
		name = "TAccessComboBox.CreateControl"
		size = 29
		refs = "0015 DoCreate"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC 83 B8 48 03 00 00 00 75 07 55 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_552_0 {
	meta:
		name = "TAccessComboBox.GetControlInterface"
		size = 29
		refs = "0009 TAccessComboBox.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 48 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_570_0 {
	meta:
		name = "TAccessComboBox.Get_Column"
		size = 144
		refs = "001f @VarAddRef 0027 TAccessComboBox.Get_Column 0035 @VarClr 004d TAccessComboBox.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_572_0 {
	meta:
		name = "TAccessComboBox.Get_ItemData"
		size = 99
		refs = "0012 TAccessComboBox.Get_ItemData 001f @VarClr 002b TAccessComboBox.GetControlInterface 003c @CheckAutoResult 0051 @IntfClear 0057 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52994_0 {
	meta:
		name = "TExcelWorkbook.Get_Comments"
		size = 99
		refs = "0012 TExcelWorkbook.Get_Comments 001f @WStrClr 002b TExcelWorkbook.GetDefaultInterface 003c @CheckAutoResult 0051 @IntfClear 0057 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_573_0 {
	meta:
		name = "TAccessComboBox.Get_Properties"
		size = 94
		refs = "000f TAccessComboBox.Get_Properties 001c @IntfClear 0027 TAccessComboBox.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_917_0 {
	meta:
		name = "TAccessTabControl.Get_Value"
		size = 94
		refs = "000f TAccessTabControl.Get_Value 001c @VarClr 0027 TAccessTabControl.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77339_0 {
	meta:
		name = "TOutlookApplication.Get_DefaultProfileName"
		size = 94
		refs = "000f TOutlookApplication.Get_DefaultProfileName 001c @WStrClr 0027 TOutlookApplication.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75526_0 {
	meta:
		name = "TPowerPointSlide.Get_Hyperlinks"
		size = 94
		refs = "000f TPowerPointSlide.Get_Hyperlinks 001c @IntfClear 0027 TPowerPointSlide.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_78425_0 {
	meta:
		name = "TShellUIHelper.SearchGuideUrl"
		size = 94
		refs = "000f TShellUIHelper.SearchGuideUrl 001c @WStrClr 0027 TShellUIHelper.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149221_0 {
	meta:
		name = "TWordApplication.Get_Version"
		size = 94
		refs = "000f TWordApplication.Get_Version 001c @WStrClr 0027 TWordApplication.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148581_0 {
	meta:
		name = "TWordDocument.Get_Styles"
		size = 94
		refs = "000f TWordDocument.Get_Styles 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148932_0 {
	meta:
		name = "TWordFont.Get_Name"
		size = 94
		refs = "000f TWordFont.Get_Name 001c @WStrClr 0027 TWordFont.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149145_0 {
	meta:
		name = "TWordLetterContent.Get_MailingInstructions"
		size = 94
		refs = "000f TWordLetterContent.Get_MailingInstructions 001c @WStrClr 0027 TWordLetterContent.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 8C 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_576_0 {
	meta:
		name = "TAccessComboBox.Get_FormatConditions"
		size = 94
		refs = "000f TAccessComboBox.Get_FormatConditions 001c @IntfClear 0027 TAccessComboBox.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 AC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76076_0 {
	meta:
		name = "TContactItem.Get_Subject"
		size = 94
		refs = "000f TContactItem.Get_Subject 001c @WStrClr 0027 TContactItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 AC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76353_0 {
	meta:
		name = "TDistListItem.Get_Subject"
		size = 94
		refs = "000f TDistListItem.Get_Subject 001c @WStrClr 0027 TDistListItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 AC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76426_0 {
	meta:
		name = "TDocumentItem.Get_Subject"
		size = 94
		refs = "000f TDocumentItem.Get_Subject 001c @WStrClr 0027 TDocumentItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 AC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76579_0 {
	meta:
		name = "TJournalItem.Get_Subject"
		size = 94
		refs = "000f TJournalItem.Get_Subject 001c @WStrClr 0027 TJournalItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 AC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_75907_0 {
	meta:
		name = "TMailItem.Get_Subject"
		size = 94
		refs = "000f TMailItem.Get_Subject 001c @WStrClr 0027 TMailItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 AC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76762_0 {
	meta:
		name = "TPostItem.Get_Subject"
		size = 94
		refs = "000f TPostItem.Get_Subject 001c @WStrClr 0027 TPostItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 AC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76835_0 {
	meta:
		name = "TRemoteItem.Get_Subject"
		size = 94
		refs = "000f TRemoteItem.Get_Subject 001c @WStrClr 0027 TRemoteItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 AC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76901_0 {
	meta:
		name = "TReportItem.Get_Subject"
		size = 94
		refs = "000f TReportItem.Get_Subject 001c @WStrClr 0027 TReportItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 AC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76963_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_Subject"
		size = 94
		refs = "000f TTaskRequestAcceptItem.Get_Subject 001c @WStrClr 0027 TTaskRequestAcceptItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 AC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77026_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_Subject"
		size = 94
		refs = "000f TTaskRequestDeclineItem.Get_Subject 001c @WStrClr 0027 TTaskRequestDeclineItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 AC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77089_0 {
	meta:
		name = "TTaskRequestItem.Get_Subject"
		size = 94
		refs = "000f TTaskRequestItem.Get_Subject 001c @WStrClr 0027 TTaskRequestItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 AC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_77152_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_Subject"
		size = 94
		refs = "000f TTaskRequestUpdateItem.Get_Subject 001c @WStrClr 0027 TTaskRequestUpdateItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 AC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148589_0 {
	meta:
		name = "TWordDocument.Get_TablesOfContents"
		size = 94
		refs = "000f TWordDocument.Get_TablesOfContents 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 AC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149153_0 {
	meta:
		name = "TWordLetterContent.Get_CCList"
		size = 94
		refs = "000f TWordLetterContent.Get_CCList 001c @WStrClr 0027 TWordLetterContent.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 AC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_578_0 {
	meta:
		name = "TAccessComboBox.Set_Value"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessComboBox.Set_Value 0041 TAccessComboBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 B4 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_594_0 {
	meta:
		name = "TAccessComboBox._Evaluate"
		size = 103
		refs = "0012 TAccessComboBox._Evaluate 0020 @VarClr 002d TAccessComboBox.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 A4 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_596_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 30 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 5E E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_597_0 {
	meta:
		name = "TAccessCustomControl.CreateControl"
		size = 29
		refs = "0015 DoCreate"
		altNames = "TAccessObjectFrame.CreateControl"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC 83 B8 30 03 00 00 00 75 07 55 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_598_0 {
	meta:
		name = "TAccessObjectFrame.GetControlInterface"
		size = 29
		refs = "0009 TAccessObjectFrame.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 30 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_804_0 {
	meta:
		name = "TAccessCustomControl.GetControlInterface"
		size = 29
		refs = "0009 TAccessCustomControl.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 30 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_621_0 {
	meta:
		name = "TAccessObjectFrame.Get_OleData"
		size = 94
		refs = "000f TAccessObjectFrame.Get_OleData 001c @VarClr 0027 TAccessObjectFrame.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 60 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76113_0 {
	meta:
		name = "TContactItem.Get_CallbackTelephoneNumber"
		size = 94
		refs = "000f TContactItem.Get_CallbackTelephoneNumber 001c @WStrClr 0027 TContactItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 60 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148634_0 {
	meta:
		name = "TWordDocument.Get_InlineShapes"
		size = 94
		refs = "000f TWordDocument.Get_InlineShapes 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 60 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149582_0 {
	meta:
		name = "TWordFont.Get_Glow"
		size = 94
		refs = "000f TWordFont.Get_Glow 001c @IntfClear 0027 TWordFont.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 60 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_622_0 {
	meta:
		name = "TAccessObjectFrame.Set_OleData"
		size = 128
		refs = "001c @VarAddRef 0024 TAccessObjectFrame.Set_OleData 0040 TAccessObjectFrame.GetControlInterface 0051 @CheckAutoResult 0066 @IntfClear 006e @VarClr 0074 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F0 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C6 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 64 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule function_623_0 {
	meta:
		name = "TAccessObjectFrame.Get_ObjectPalette"
		size = 94
		refs = "000f TAccessObjectFrame.Get_ObjectPalette 001c @VarClr 0027 TAccessObjectFrame.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 30 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76165_0 {
	meta:
		name = "TContactItem.Get_Home2TelephoneNumber"
		size = 94
		refs = "000f TContactItem.Get_Home2TelephoneNumber 001c @WStrClr 0027 TContactItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 30 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_54698_0 {
	meta:
		name = "TExcelWorksheet.Get_Protection"
		size = 94
		refs = "000f TExcelWorksheet.Get_Protection 001c @IntfClear 0027 TExcelWorksheet.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 30 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_624_0 {
	meta:
		name = "TAccessObjectFrame.Set_ObjectPalette"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessObjectFrame.Set_ObjectPalette 0041 TAccessObjectFrame.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 34 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_640_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 08 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 60 E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_649_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 38 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 62 E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_674_0 {
	meta:
		name = "TAccessToggleButton.Get_PictureData"
		size = 94
		refs = "000f TAccessToggleButton.Get_PictureData 001c @VarClr 0027 TAccessToggleButton.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 DC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1412_0 {
	meta:
		name = "TAccessReport.Get_ShortcutMenuBar"
		size = 94
		refs = "000f TAccessReport.Get_ShortcutMenuBar 001c @WStrClr 0027 TAccessReport.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 DC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_51656_0 {
	meta:
		name = "TExcelApplication.Get_Excel4IntlMacroSheets"
		size = 94
		refs = "000f TExcelApplication.Get_Excel4IntlMacroSheets 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 DC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_52813_0 {
	meta:
		name = "TExcelGlobal.Get_Excel4IntlMacroSheets"
		size = 94
		refs = "000f TExcelGlobal.Get_Excel4IntlMacroSheets 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 DC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2844_0 {
	meta:
		name = "TReportOld.Get_ShortcutMenuBar"
		size = 94
		refs = "000f TReportOld.Get_ShortcutMenuBar 001c @WStrClr 0027 TReportOld.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 DC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148952_0 {
	meta:
		name = "TWordFont.Get_Borders"
		size = 94
		refs = "000f TWordFont.Get_Borders 001c @IntfClear 0027 TWordFont.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 DC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149165_0 {
	meta:
		name = "TWordLetterContent.Get_SenderInitials"
		size = 94
		refs = "000f TWordLetterContent.Get_SenderInitials 001c @WStrClr 0027 TWordLetterContent.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 DC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_719_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_PictureData"
		size = 94
		refs = "000f T_ToggleButtonInOption.Get_PictureData 001c @VarClr 0027 T_ToggleButtonInOption.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 DC 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_675_0 {
	meta:
		name = "TAccessToggleButton.Set_PictureData"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessToggleButton.Set_PictureData 0041 TAccessToggleButton.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 E0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_720_0 {
	meta:
		name = "T_ToggleButtonInOption.Set_PictureData"
		size = 130
		refs = "001d @VarAddRef 0025 T_ToggleButtonInOption.Set_PictureData 0041 T_ToggleButtonInOption.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 E0 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_676_0 {
	meta:
		name = "TAccessToggleButton.Get_ObjectPalette"
		size = 94
		refs = "000f TAccessToggleButton.Get_ObjectPalette 001c @VarClr 0027 TAccessToggleButton.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 1C 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_53065_0 {
	meta:
		name = "TExcelWorkbook.Get_Excel4MacroSheets"
		size = 94
		refs = "000f TExcelWorkbook.Get_Excel4MacroSheets 001c @IntfClear 0027 TExcelWorkbook.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 1C 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_54694_0 {
	meta:
		name = "TExcelWorksheet.Get_Tab"
		size = 94
		refs = "000f TExcelWorksheet.Get_Tab 001c @IntfClear 0027 TExcelWorksheet.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 1C 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_721_0 {
	meta:
		name = "T_ToggleButtonInOption.Get_ObjectPalette"
		size = 94
		refs = "000f T_ToggleButtonInOption.Get_ObjectPalette 001c @VarClr 0027 T_ToggleButtonInOption.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 1C 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_677_0 {
	meta:
		name = "TAccessToggleButton.Set_ObjectPalette"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessToggleButton.Set_ObjectPalette 0041 TAccessToggleButton.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 20 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_722_0 {
	meta:
		name = "T_ToggleButtonInOption.Set_ObjectPalette"
		size = 130
		refs = "001d @VarAddRef 0025 T_ToggleButtonInOption.Set_ObjectPalette 0041 T_ToggleButtonInOption.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 20 02 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_694_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 18 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 62 E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_739_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 38 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 60 A7 D4 9C A9 A6 CE 11 A6 86 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_748_0 {
	meta:
		name = "TAccessPaletteButton.Set_Value"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessPaletteButton.Set_Value 0041 TAccessPaletteButton.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_755_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 18 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 64 E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_789_0 {
	meta:
		name = "TAccessSubForm._Evaluate"
		size = 103
		refs = "0012 TAccessSubForm._Evaluate 0020 @VarClr 002d TAccessSubForm.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_929_0 {
	meta:
		name = "TAccessTabControl._Evaluate"
		size = 103
		refs = "0012 TAccessTabControl._Evaluate 0020 @VarClr 002d TAccessTabControl.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 88 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_794_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 18 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 66 E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_802_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 30 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 68 E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_829_0 {
	meta:
		name = "TAccessCustomControl.Get_OleData"
		size = 94
		refs = "000f TAccessCustomControl.Get_OleData 001c @VarClr 0027 TAccessCustomControl.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 00 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76366_0 {
	meta:
		name = "TDistListItem.Get_Links"
		size = 94
		refs = "000f TDistListItem.Get_Links 001c @IntfClear 0027 TDistListItem.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 00 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_53018_0 {
	meta:
		name = "TExcelWorkbook.Get_Modules"
		size = 94
		refs = "000f TExcelWorkbook.Get_Modules 001c @IntfClear 0027 TExcelWorkbook.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 00 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_76786_0 {
	meta:
		name = "TPostItem.Forward"
		size = 94
		refs = "000f TPostItem.Forward 001c @IntfClear 0027 TPostItem.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 00 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149250_0 {
	meta:
		name = "TWordApplication.Get_DefaultSaveFormat"
		size = 94
		refs = "000f TWordApplication.Get_DefaultSaveFormat 001c @WStrClr 0027 TWordApplication.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 00 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_148961_0 {
	meta:
		name = "TWordFont.Get_NameAscii"
		size = 94
		refs = "000f TWordFont.Get_NameAscii 001c @WStrClr 0027 TWordFont.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 00 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_875_0 {
	meta:
		name = "T_CustomControlInReport.Get_OleData"
		size = 94
		refs = "000f T_CustomControlInReport.Get_OleData 001c @VarClr 0027 T_CustomControlInReport.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 00 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_830_0 {
	meta:
		name = "TAccessCustomControl.Set_OleData"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessCustomControl.Set_OleData 0041 TAccessCustomControl.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 04 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_876_0 {
	meta:
		name = "T_CustomControlInReport.Set_OleData"
		size = 130
		refs = "001d @VarAddRef 0025 T_CustomControlInReport.Set_OleData 0041 T_CustomControlInReport.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 04 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_831_0 {
	meta:
		name = "TAccessCustomControl.Get_ObjectPalette"
		size = 94
		refs = "000f TAccessCustomControl.Get_ObjectPalette 001c @VarClr 0027 TAccessCustomControl.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_53041_0 {
	meta:
		name = "TExcelWorkbook.Get_RoutingSlip"
		size = 94
		refs = "000f TExcelWorkbook.Get_RoutingSlip 001c @IntfClear 0027 TExcelWorkbook.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149286_0 {
	meta:
		name = "TWordApplication.Get_PathSeparator"
		size = 94
		refs = "000f TWordApplication.Get_PathSeparator 001c @WStrClr 0027 TWordApplication.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_149594_0 {
	meta:
		name = "TWordFont.Get_TextColor"
		size = 94
		refs = "000f TWordFont.Get_TextColor 001c @IntfClear 0027 TWordFont.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_877_0 {
	meta:
		name = "T_CustomControlInReport.Get_ObjectPalette"
		size = 94
		refs = "000f T_CustomControlInReport.Get_ObjectPalette 001c @VarClr 0027 T_CustomControlInReport.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 90 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_832_0 {
	meta:
		name = "TAccessCustomControl.Set_ObjectPalette"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessCustomControl.Set_ObjectPalette 0041 TAccessCustomControl.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 94 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_878_0 {
	meta:
		name = "T_CustomControlInReport.Set_ObjectPalette"
		size = 130
		refs = "001d @VarAddRef 0025 T_CustomControlInReport.Set_ObjectPalette 0041 T_CustomControlInReport.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 94 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_848_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 08 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 68 E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_894_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 10 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 71 E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_895_0 {
	meta:
		name = "TAccessTabControl.CreateControl"
		size = 29
		refs = "0015 DoCreate"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC 83 B8 10 03 00 00 00 75 07 55 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_896_0 {
	meta:
		name = "TAccessTabControl.GetControlInterface"
		size = 29
		refs = "0009 TAccessTabControl.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 10 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_918_0 {
	meta:
		name = "TAccessTabControl.Set_Value"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessTabControl.Set_Value 0041 TAccessTabControl.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 90 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_931_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 08 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 74 E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_953_0 {
	meta:
		name = "TAccessPage.Get_PictureData"
		size = 94
		refs = "000f TAccessPage.Get_PictureData 001c @VarClr 0027 TAccessPage.GetControlInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 6C 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1594_0 {
	meta:
		name = "TAccessApplication.Get_Modules"
		size = 94
		refs = "000f TAccessApplication.Get_Modules 001c @IntfClear 0027 TAccessApplication.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 6C 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_954_0 {
	meta:
		name = "TAccessPage.Set_PictureData"
		size = 130
		refs = "001d @VarAddRef 0025 TAccessPage.Set_PictureData 0041 TAccessPage.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 90 70 01 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_970_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 08 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 FC DC 1F 33 31 CF CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_978_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 08 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 27 DD 1F 33 31 CF CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_985_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 20 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 FC DC 1F 33 31 CF CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_986_0 {
	meta:
		name = "T_SectionInReport.CreateControl"
		size = 29
		refs = "0015 DoCreate"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC 83 B8 20 03 00 00 00 75 07 55 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_987_0 {
	meta:
		name = "T_SectionInReport.GetControlInterface"
		size = 29
		refs = "0009 T_SectionInReport.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 20 03 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_993_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 18 03 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 FC DC 1F 33 31 CF CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_1000_0 {
	meta:
		name = "CoAccessForm.Create"
		size = 100
		refs = "000c CoAccessForm.Create 001a CLASS_AccessForm 001f CreateComObject 002e @IntfCast 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 80 5D 13 E5 8D 8F 1B 10 AF 4E 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_1867_0 {
	meta:
		name = "CoFormOld.Create"
		size = 100
		refs = "000c CoFormOld.Create 001a CLASS_FormOld 001f CreateComObject 002e @IntfCast 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 80 5D 13 E5 8D 8F 1B 10 AF 4E 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_1001_0 {
	meta:
		name = "CoAccessForm.CreateRemote"
		size = 128
		refs = "0011 CoAccessForm.CreateRemote 0021 @WStrFromUStr 002c CLASS_AccessForm 0031 CreateRemoteComObject 0040 @IntfCast 0055 @WStrClr 005d @IntfClear 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F1 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 45 F8 8D 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 80 5D 13 E5 8D 8F 1B 10 AF 4E 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_1868_0 {
	meta:
		name = "CoFormOld.CreateRemote"
		size = 128
		refs = "0011 CoFormOld.CreateRemote 0021 @WStrFromUStr 002c CLASS_FormOld 0031 CreateRemoteComObject 0040 @IntfCast 0055 @WStrClr 005d @IntfClear 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F1 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 45 F8 8D 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 80 5D 13 E5 8D 8F 1B 10 AF 4E 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_1002_0 {
	meta:
		name = "TAccessApplication.InitServerData"
		size = 9
		refs = "0001 CServerData"
		altNames = "TAccessForm.InitServerData TAccessReferences.InitServerData TAccessReport.InitServerData TAdditionalData.InitServerData TAutoCorrect.InitServerData TBinder.InitServerData TCOMAdminCatalog.InitServerData TCOMAdminCatalogCollection.InitServerData TCOMAdminCatalogObject.InitServerData TClass_.InitServerData TContactItem.InitServerData TCustomTaskPane.InitServerData TCustomXMLPart.InitServerData TCustomXMLParts.InitServerData TCustomXMLSchemaCollection.InitServerData TDependencyInfo.InitServerData TDependencyObjects.InitServerData TDistListItem.InitServerData TDocumentItem.InitServerData TExcelApplication.InitServerData TExcelChart.InitServerData TExcelGlobal.InitServerData TExcelOLEObject.InitServerData TExcelQueryTable.InitServerData TExcelWorkbook.InitServerData TExcelWorksheet.InitServerData TExplorers.InitServerData TFolders.InitServerData TFormOld.InitServerData TInspectors.InitServerData TInternetExplorer.InitServerData TInternetExplorerMedium.InitServerData TItems.InitServerData TJournalItem.InitServerData TMacroError.InitServerData TMailItem.InitServerData TMaster.InitServerData TNameSpace.InitServerData TOLECtrl.InitServerData TOutlookApplication.InitServerData TOutlookBarGroups.InitServerData TOutlookBarPane.InitServerData TOutlookBarShortcuts.InitServerData TPostItem.InitServerData TPowerPointApplication.InitServerData TPowerPointPresentation.InitServerData TPowerPointSlide.InitServerData TPowerRex.InitServerData TRemoteItem.InitServerData TReportItem.InitServerData TReportOld.InitServerData TReturnVar.InitServerData TReturnVars.InitServerData TShellNameSpace.InitServerData TShellUIHelper.InitServerData TShellWindows.InitServerData TSmartTag.InitServerData TSmartTagAction.InitServerData TSmartTagActions.InitServerData TSmartTagProperties.InitServerData TSmartTagProperty.InitServerData TSmartTags.InitServerData TSyncObject.InitServerData TTaskRequestAcceptItem.InitServerData TTaskRequestDeclineItem.InitServerData TTaskRequestItem.InitServerData TTaskRequestUpdateItem.InitServerData TTempVar.InitServerData TTempVars.InitServerData TWizHook.InitServerData TWordApplication.InitServerData TWordDocument.InitServerData TWordFont.InitServerData TWordLetterContent.InitServerData TWordOLEControl.InitServerData TWordParagraphFormat.InitServerData"
	strings:
		$1 = { BA ?? ?? ?? ?? 89 50 38 C3 }
	condition:
		$1
}

rule function_1003_0 {
	meta:
		name = "TAccessForm.Connect"
		size = 120
		refs = "000c TAccessForm.Connect 002f TOleServer.ConnectEvents 0042 @IntfCast 0057 @IntfClear 005d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 BB 48 01 00 00 00 75 27 8D 55 FC 8B C3 8B 08 FF 51 44 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 8D 83 48 01 00 00 8B 55 FC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 80 5D 13 E5 8D 8F 1B 10 AF 4E 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_1004_0 {
	meta:
		name = "TAccessForm.ConnectTo"
		size = 99
		refs = "000e @IntfAddRef 0016 TAccessForm.ConnectTo 0031 @IntfCopy 003e TOleServer.ConnectEvents 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 50 8D 83 48 01 00 00 8B 55 FC E8 ?? ?? ?? ?? 8B 93 48 01 00 00 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1005_0 {
	meta:
		name = "TAccessForm.Disconnect"
		size = 38
		refs = "0015 TOleServer.DisconnectEvents 0020 @IntfClear"
	strings:
		$1 = { 53 8B D8 83 BB 48 01 00 00 00 74 18 8B 93 48 01 00 00 8B C3 E8 ?? ?? ?? ?? 8D 83 48 01 00 00 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_1006_0 {
	meta:
		name = "TAccessForm.GetDefaultInterface"
		size = 38
		refs = "001f @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 BB 48 01 00 00 00 75 07 8B C3 8B 10 FF 52 4C 8B C6 8B 93 48 01 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_1007_0 {
	meta:
		name = "TAccessApplication.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
		altNames = "TAccessForm.Create TAccessReferences.Create TAccessReport.Create TAdditionalData.Create TAutoCorrect.Create TBinder.Create TCOMAdminCatalog.Create TCOMAdminCatalogCollection.Create TCOMAdminCatalogObject.Create TClass_.Create TContactItem.Create TCustomTaskPane.Create TCustomXMLPart.Create TCustomXMLParts.Create TCustomXMLSchemaCollection.Create TDependencyInfo.Create TDependencyObjects.Create TDistListItem.Create TDocumentItem.Create TExcelApplication.Create TExcelChart.Create TExcelGlobal.Create TExcelOLEObject.Create TExcelQueryTable.Create TExcelWorkbook.Create TExcelWorksheet.Create TExplorers.Create TFolders.Create TFormOld.Create TInspectors.Create TInternetExplorer.Create TInternetExplorerMedium.Create TItems.Create TJournalItem.Create TMacroError.Create TMailItem.Create TMaster.Create TNameSpace.Create TOLECtrl.Create TOutlookApplication.Create TOutlookBarGroups.Create TOutlookBarPane.Create TOutlookBarShortcuts.Create TPostItem.Create TPowerPointApplication.Create TPowerPointPresentation.Create TPowerPointSlide.Create TPowerRex.Create TRemoteItem.Create TReportItem.Create TReportOld.Create TReturnVar.Create TReturnVars.Create TShellNameSpace.Create TShellUIHelper.Create TShellWindows.Create TSmartTag.Create TSmartTagAction.Create TSmartTagActions.Create TSmartTagProperties.Create TSmartTagProperty.Create TSmartTags.Create TSyncObject.Create TTaskRequestAcceptItem.Create TTaskRequestDeclineItem.Create TTaskRequestItem.Create TTaskRequestUpdateItem.Create TTempVar.Create TTempVars.Create TWizHook.Create TWordApplication.Create TWordDocument.Create TWordFont.Create TWordLetterContent.Create TWordOLEControl.Create TWordParagraphFormat.Create"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_35363_0 {
	meta:
		name = "DSAdmin.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDSCustomAdmin.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_35444_0 {
	meta:
		name = "DSMetadata.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDSCustomAdmin.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_65037_0 {
	meta:
		name = "EIdException.Create"
		size = 53
		refs = "000a @ClassCreate 0017 Exception.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_135673_0 {
	meta:
		name = "TAbstractActiveScriptLanguages.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_91273_0 {
	meta:
		name = "TAbstractObjectMemberInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAbstractMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_111576_0 {
	meta:
		name = "TActiveForm.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCustomActiveForm.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_111566_0 {
	meta:
		name = "TActiveFormControl.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TActiveXControl.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_111567_0 {
	meta:
		name = "TActiveFormControl.CreateAggregated"
		size = 53
		refs = "000a @ClassCreate 0017 TActiveXControl.CreateAggregated 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_111426_0 {
	meta:
		name = "TActiveXControl.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAutoObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_111427_0 {
	meta:
		name = "TActiveXControl.CreateAggregated"
		size = 53
		refs = "000a @ClassCreate 0017 TAutoObject.CreateAggregated 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_107997_0 {
	meta:
		name = "TAutoObject.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TTypedComObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_107998_0 {
	meta:
		name = "TAutoObject.CreateAggregated"
		size = 53
		refs = "000a @ClassCreate 0017 TTypedComObject.CreateAggregated 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_108088_0 {
	meta:
		name = "TAutoObjectEvent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAutoObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_108090_0 {
	meta:
		name = "TAutoObjectEvent.CreateAggregated"
		size = 53
		refs = "000a @ClassCreate 0017 TAutoObject.CreateAggregated 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_49768_0 {
	meta:
		name = "TAzureBlobService.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAzureService.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_49817_0 {
	meta:
		name = "TAzureTableService.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAzureService.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_50097_0 {
	meta:
		name = "TBBlock.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBEnumerationItem<DSAzureBlob.TBBlockList>.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_50091_0 {
	meta:
		name = "TBPageRange.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBEnumerationItem<DSAzureBlob.TBPageList>.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_50083_0 {
	meta:
		name = "TBSignedIdentifier.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBEnumerationItem<DSAzureBlob.TBSignedIdentifiers>.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_28834_0 {
	meta:
		name = "TBaseTransportFilterItem.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCollectionItem.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_3400_0 {
	meta:
		name = "TBasicImageResponseImpl.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAbstractAdapterResponse.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_17974_0 {
	meta:
		name = "TBinaryField.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TField.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_58310_0 {
	meta:
		name = "TBindCheckBoxEditorFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBindEditorFactory.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_58249_0 {
	meta:
		name = "TBindComboBoxEditorFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBindEditorFactory.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_58252_0 {
	meta:
		name = "TBindComboEditEditorFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBindEditorFactory.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_57574_0 {
	meta:
		name = "TBindDBStringGridColumnFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBindDBColumnFactory.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_58258_0 {
	meta:
		name = "TBindGridEditorFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBindEditorFactory.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_58246_0 {
	meta:
		name = "TBindListBoxEditorFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBindEditorFactory.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_111848_0 {
	meta:
		name = "TBindListViewEditorFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBindEditorFactory.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_7975_0 {
	meta:
		name = "TBindNavigatorController.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_58255_0 {
	meta:
		name = "TBindStringGridEditorFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBindEditorFactory.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_132357_0 {
	meta:
		name = "TCGIRequest.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TWebRequest.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_19703_0 {
	meta:
		name = "TClassRegistryObject.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_121611_0 {
	meta:
		name = "TColorLookup.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_5157_0 {
	meta:
		name = "TCommonBindComponent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TContainedBindComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_97826_0 {
	meta:
		name = "TComponentList.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObjectList.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_80759_0 {
	meta:
		name = "TConnectionIntercept.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TIdBaseComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_5120_0 {
	meta:
		name = "TContainedBindComponent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_114772_0 {
	meta:
		name = "TConversion.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_25007_0 {
	meta:
		name = "TConverterEvent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_110440_0 {
	meta:
		name = "TCustomAction.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TContainedAction.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_5619_0 {
	meta:
		name = "TCustomBindExpression.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBaseBindExpression.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_125890_0 {
	meta:
		name = "TCustomComboBoxStrings.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TStrings.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_132252_0 {
	meta:
		name = "TCustomHTMLDragDropDesigner.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_132264_0 {
	meta:
		name = "TCustomHTMLRegionDesigner.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_33441_0 {
	meta:
		name = "TCustomRemoteServer.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCustomConnection.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_128356_0 {
	meta:
		name = "TCustomStyleServices.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_19364_0 {
	meta:
		name = "TDBByteBuffer.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_20947_0 {
	meta:
		name = "TDBXAnsiMemoValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXByteArrayValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47924_0 {
	meta:
		name = "TDBXAnsiStringSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_20926_0 {
	meta:
		name = "TDBXAnsiStringValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWritableValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47919_0 {
	meta:
		name = "TDBXBlobSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47913_0 {
	meta:
		name = "TDBXBooleanSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_20232_0 {
	meta:
		name = "TDBXClientDriverLoader.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TClassRegistryObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_21278_0 {
	meta:
		name = "TDBXClosedByteReader.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXByteReader.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_27483_0 {
	meta:
		name = "TDBXColumnsTableCursor.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDelegateTable.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_21371_0 {
	meta:
		name = "TDBXConnectionBuilder.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_26328_0 {
	meta:
		name = "TDBXConnectionHandler.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXCommandHandler.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_23483_0 {
	meta:
		name = "TDBXDataExpressMetaDataProvider.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXMetaDataProvider.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_27168_0 {
	meta:
		name = "TDBXDataExpressProviderContext.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47888_0 {
	meta:
		name = "TDBXDataGeneratedRow.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXRow.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47928_0 {
	meta:
		name = "TDBXDataGeneratorException.Create"
		size = 53
		refs = "000a @ClassCreate 0017 Exception.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_23736_0 {
	meta:
		name = "TDBXDataSetReader.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXTableReader.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47929_0 {
	meta:
		name = "TDBXDateSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47936_0 {
	meta:
		name = "TDBXDecimalSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47941_0 {
	meta:
		name = "TDBXDoubleSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_29209_0 {
	meta:
		name = "TDBXIdTCPLayer.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TFactoryObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47946_0 {
	meta:
		name = "TDBXInt16SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47951_0 {
	meta:
		name = "TDBXInt32SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47956_0 {
	meta:
		name = "TDBXInt64SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47961_0 {
	meta:
		name = "TDBXInt8SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_21417_0 {
	meta:
		name = "TDBXMemoryConnectionFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXConnectionFactory.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_27301_0 {
	meta:
		name = "TDBXMetaDataProvider.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_24271_0 {
	meta:
		name = "TDBXMethodTable.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_23361_0 {
	meta:
		name = "TDBXNoOpRow.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXStreamerRow.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_29202_0 {
	meta:
		name = "TDBXSocketChannel.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_21057_0 {
	meta:
		name = "TDBXStringValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWideStringValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_23380_0 {
	meta:
		name = "TDBXTable.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXTableRow.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_23378_0 {
	meta:
		name = "TDBXTableRow.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWritableValueList.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47966_0 {
	meta:
		name = "TDBXTimeSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47973_0 {
	meta:
		name = "TDBXTimestampSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_20685_0 {
	meta:
		name = "TDBXTransaction.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_20528_0 {
	meta:
		name = "TDBXValueType.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_21050_0 {
	meta:
		name = "TDBXWideMemoValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXByteArrayValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47984_0 {
	meta:
		name = "TDBXWideStringSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_21027_0 {
	meta:
		name = "TDBXWideStringValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWritableValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_20701_0 {
	meta:
		name = "TDBXWritableValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_21523_0 {
	meta:
		name = "TDBXWritableValueList.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXValueList.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_47226_0 {
	meta:
		name = "TDCOMConnection.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDispatchConnection.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_42372_0 {
	meta:
		name = "TDSAdminRestClient.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDSRestClient.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_35359_0 {
	meta:
		name = "TDSCustomAdmin.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXServerComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_34128_0 {
	meta:
		name = "TDSCustomProxyGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_35483_0 {
	meta:
		name = "TDSCustomServerClass.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDSServerComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_35471_0 {
	meta:
		name = "TDSServerCommandHandler.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXCommandHandler.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_35480_0 {
	meta:
		name = "TDSServerComponent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_35541_0 {
	meta:
		name = "TDSServerMethod.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_35562_0 {
	meta:
		name = "TDSServerMethodProvider.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_35614_0 {
	meta:
		name = "TDSVoidConnectionHandler.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXConnectionHandler.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_78939_0 {
	meta:
		name = "TDataContext.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_91333_0 {
	meta:
		name = "TDynamicObjectMemberInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TPhysicalObjectMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_3708_0 {
	meta:
		name = "TEnumDispatcherAS.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCustomEnumDispatcher.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_28838_0 {
	meta:
		name = "TFactoryObject.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_120832_0 {
	meta:
		name = "TGraphic.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_62169_0 {
	meta:
		name = "TIBValidationService.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TIBControlAndQueryService.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_133662_0 {
	meta:
		name = "TISAPIFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_63259_0 {
	meta:
		name = "TIdBaseComponent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TIdInitializerComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_64936_0 {
	meta:
		name = "TIdEMailAddressItem.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCollectionItem.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_65710_0 {
	meta:
		name = "TIdFTPRegParseList.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_66912_0 {
	meta:
		name = "TIdHash.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_68162_0 {
	meta:
		name = "TIdIRCReplies.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_68851_0 {
	meta:
		name = "TIdMessageDecoderInfo.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_68859_0 {
	meta:
		name = "TIdMessageEncoderInfo.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_71369_0 {
	meta:
		name = "TIdNotify.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_67181_0 {
	meta:
		name = "TIdProxyConnectionInfo.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_71339_0 {
	meta:
		name = "TIdStruct.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_71366_0 {
	meta:
		name = "TIdSync.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_91261_0 {
	meta:
		name = "TIndexedObjectPropertyInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TPhysicalObjectMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_91442_0 {
	meta:
		name = "TIndexedRecordPropertyInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TPhysicalRecordMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_112471_0 {
	meta:
		name = "TInternalBitmap.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBitmap.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_24717_0 {
	meta:
		name = "TJSONException.Create"
		size = 53
		refs = "000a @ClassCreate 0017 Exception.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_24751_0 {
	meta:
		name = "TJSONNumber.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TJSONString.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_24718_0 {
	meta:
		name = "TJSONPair.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TJSONAncestor.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_24738_0 {
	meta:
		name = "TJSONString.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TJSONAncestor.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_50111_0 {
	meta:
		name = "TLeaseItem.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_80820_0 {
	meta:
		name = "TLogDetail.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCustomForm.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_79404_0 {
	meta:
		name = "TLogLinkedWebNode.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TLinkedWebNode.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_135903_0 {
	meta:
		name = "TModuleObj.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponentsEnumerator.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_91290_0 {
	meta:
		name = "TObjectFieldInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TPhysicalObjectMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_91283_0 {
	meta:
		name = "TObjectMethodInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TPhysicalObjectMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_91247_0 {
	meta:
		name = "TObjectPropertyInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TPhysicalObjectMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_111632_0 {
	meta:
		name = "TOleGraphic.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TGraphic.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_91271_0 {
	meta:
		name = "TPhysicalObjectMemberInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAbstractObjectMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_91426_0 {
	meta:
		name = "TPhysicalRecordMemberInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAbstractMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_111596_0 {
	meta:
		name = "TPropertyPageImpl.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAggregatedObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_91447_0 {
	meta:
		name = "TRecordFieldInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TPhysicalRecordMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_91451_0 {
	meta:
		name = "TRecordMethodInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TPhysicalRecordMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_91438_0 {
	meta:
		name = "TRecordPropertyInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TPhysicalRecordMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_25014_0 {
	meta:
		name = "TReverterEvent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_95140_0 {
	meta:
		name = "TStringList.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TStrings.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_79427_0 {
	meta:
		name = "TTypeTranslator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_107990_0 {
	meta:
		name = "TTypedComObject.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_107991_0 {
	meta:
		name = "TTypedComObject.CreateAggregated"
		size = 53
		refs = "000a @ClassCreate 0017 TComObject.CreateAggregated 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_91296_0 {
	meta:
		name = "TVirtualObjectMemberInstance.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAbstractObjectMemberInstance.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_72568_0 {
	meta:
		name = "TWebBrowserSearchFindFirst.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TWebBrowserSearchFind.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_75024_0 {
	meta:
		name = "TWebButton.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TWebContainedComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 