import wx
from wx.lib.embeddedimage import PyEmbeddedImage


RAW_ICONS = {
"nn": b"""iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAIAAABvFaqvAAAACXBIWXMAAAxMAAAMTAEAiU+qAAAACXZwQWcAAAAYAAAAGAB4TKWmAAAB3klEQVQ4y+2VMW7bQBBF/3CHkhrFCFwlKV2l9gF8Al8k6dy5IkEV7twld1GlE1gG3aRymVAuXBiGERq7Mz8FEUoiBQRIm/yKnP3zwJmd5UprVAGJPQlAmHGay6fP3wF8/fLhNTIE6Zb2vIJEIDrHcqcZSS6qBrgFbhdVQ9KMfsgfnYh2gJKSkyzLBliHUIdQA+uybEim5GNWtBHInTE6yaLoKHcitUgdwh2wLoqGZIxD1hDkzpQ4oAA1MGSltFfjHmhQkWrdU3qW6uEaozHrOk/CjCFIUWzKsglBzYZbScIMIWhZNkWxCUHM2HsyCEiIQFUWi4eq2kwmKoIsw1hZBhFMJlpVm8XiQVWkGx2BRGMQxMjLyx/X1w2gO3MSRijbmbR0cfHu6up9nosR6g5VLJfPq9XL2dlbd5AIAa+vvLn5GeO2vDyX09P5dCpm6D55tXpZLp/Pz9+4QaJRM7Stz2Z7xTw9+cnJt8fHJCIASB4f6/39x6OjPVuXmBzavc9mmfu2qSJoWx83u219Ps86Q5/YPehu8m5Tu74OzlQXd98u9YnamwaSceh3UOSA/9Am/5X+g/5pkEL+4BheMAclUCNk1y2gIw9wQFVCkDzPAMToqtIdx+SQbPuzEYERvwBwYMALE1tK0wAAACV0RVh0Y3JlYXRlLWRhdGUAMjAxMC0xMS0xMlQxMTozNDo0NS0wNjowMF4RciAAAAAldEVYdG1vZGlmeS1kYXRlADIwMTAtMTEtMTJUMTA6NDc6MzEtMDY6MDDgsF4bAAAAHXRFWHRTb2Z0d2FyZQBHUEwgR2hvc3RzY3JpcHQgOC43MQM/aDQAAAAASUVORK5CYII=""",
"ss": b"""iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAIAAABvFaqvAAAACXBIWXMAAAxMAAAMTAEAiU+qAAAACXZwQWcAAAAYAAAAGAB4TKWmAAAB4UlEQVQ4y+2Vv3LTQBDGv72TYleuPDiBB6BheI40eRHo0qWQ5NhFunTwMnkHZ+yhoaEDAePKQ2HrbvejOFuOZTOhh280o9H++d3tanWStTITkNhKQEPu8XOpb998Xi5jnjsAIdhwmC0+vX4x9EEhDtiliCASmRd4AQSt6ADAATFSlaqWzDEmDzIH6aQArgX/SSIQeSYGhHsu5G/1H/RPg7J045OxJCEC8sSkJmPHk8Y1ax/M9iAzmHUTTtrdrqQtaL22fv+gzH7fdb4MEfT7zh02o03MzACHh4dfVfV9MPBpQe+x2XC1MkB268tqZZeXX3o9UYUInMNqpbe351dXAzNIUHpBCLy5+XZ/XwPZ/oCAP+qStvsD4vX1xd3dyzwXJSQY/a5h0+mPsqzPztK+qNrFeA8RcQ5No5PJRVGMUu80HSMiIBEji2JUludNE1Nfj5UKb5pYludFMYqR6RWDQFAmmTFGIzke18Asy+Yic2B/icyzbA7MxuOaZIxmts0Nyj1oxyLJqqqBmfeLliUy934BzKoqUdhSToASKwTrsDqUEOwp5TTouEbv596frugQdGRNLFWSnE5q4BF4nE5qkqq0U/HBKN3fUTslhCp7ubx7/xXAxw+vNoHeS3J1Jj4SvwHUp92N41HPcAAAACV0RVh0Y3JlYXRlLWRhdGUAMjAxMC0xMS0xMlQxMTozNDo0NS0wNjowMF4RciAAAAAldEVYdG1vZGlmeS1kYXRlADIwMTAtMTEtMTJUMTA6NDc6NDUtMDY6MDAeOnMRAAAAHXRFWHRTb2Z0d2FyZQBHUEwgR2hvc3RzY3JpcHQgOC43MQM/aDQAAAAASUVORK5CYII=""",
"sw": b"""iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAIAAABvFaqvAAAACXBIWXMAAAxMAAAMTAEAiU+qAAAACXZwQWcAAAAYAAAAGAB4TKWmAAACWklEQVQ4y42VTU4bQRCFX1XbFmNbipULOAfhEKzsJXgBghslIMsjFthmiVhGiVAOwIyl7IOXUcCgBPwz0/WyGMd2sIEpjUat/vn6ve7qbpl4FgQkcoYIvAcA5+ajRJASBSdwAkhekBlKhXnB6bySgCK3FgBJQlWE4ajXu1dFknBJSjxzxmxmJHu9UbEYlcvxxcUDySQxkolnXlA2oN8fVauRSCwS12rx5eUDSTOmlg+00BIEERCJxKqxSFypxN3uiOQ0oeZZl2JRer37VutmPBZVJUFCBEli06nN+6VG8zkdRc4NgNi5gUhUrUbn56OltVlCkmn6tiPVARBn/yCIMlOzmdGYeOLr1Z9PH39lVWbPKd1uRolXKFEQRL3eaNFnvmufv/x27joMb0mmqeVx1O+PFn2WoKtvjypRqXTd6dxmk0yn+RytLmVmzblYNS4Wr9vt26zh7CyXo1VQAQCN6iRN9ehoWKno1pbs799MJnBOvKdzYmbVKtrteqNRS1MWixtOZiE70t5DRGYzabWGqnh8hKp6T1XxnkGAk5N6o1HLcmpjuhX+nTmhUUTG4+xmEDOKiJkFATqderP5GgXASmbLPF9FQEIVgJXLDMN6s/mio2eKlrG4q0hUq3J6+mFn593rWtYUrYUZJhNm9Dev0M2gbNjTE3d3f4ThXakkZm+QCtnSbmwT0TTl4eEQwN7e+zRh4WWD810TkXXxJNUhSfTgYM7yHqrYOK+KwAgaBRDw/w/0FAEprdbw+Phu8XKsiYf8vEu/DyYEXvAHAk5lOjXnZHu7ss7KnqO/bT27tA7euksAAAAldEVYdGNyZWF0ZS1kYXRlADIwMTAtMTEtMTJUMTE6MzQ6NDUtMDY6MDBeEXIgAAAAJXRFWHRtb2RpZnktZGF0ZQAyMDEwLTExLTEyVDEwOjQ3OjA5LTA2OjAwXdAXnwAAAB10RVh0U29mdHdhcmUAR1BMIEdob3N0c2NyaXB0IDguNzEDP2g0AAAAAElFTkSuQmCC""",
"ne": b"""iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAIAAABvFaqvAAAACXBIWXMAAAxMAAAMTAEAiU+qAAAACXZwQWcAAAAYAAAAGAB4TKWmAAACX0lEQVQ4y42UMU/bQBzF3//ONjiJVJoPEDp0q9SvwoaQGGIGCJ8JBpMBJc6IGKtWqOzYjFWlCnYEqASSnO9eB4c0pknqJ8uy5Hc/v3d3PhlZegIS8xKBtbi8HFrLtTVlHQWLRUKAT5/XPS3QApSNziHw8PPHuNO59TwhhY6AACx/T0gS+HbxUZVflRIdHDTjuCVCEqKFACHlC6JECUiohYFFoDVywyhqHh21fN/RQWRBPxJFHQ/L5fliLaOoCaDTuTVGAOGCBgSWJJpJKZlMGEXNbvdDrSZF2MXO1SCR6cj1dVErvf8B5Tl9XwaDh93dX09PFAH5l14VZAw9T5LkIYpunp8FUM6hYBW4+RVXKyi+L/3+w97ezcuLKKVIKiUk63WEIUiKKoLJUtCs0f7+zWgErcU5ai2kq9dxeroZx60gIEmtp6vmLcuSJEUWKKWspVJiLcMQx8ebW1vvAAyHrcPDW2vVNJexnNdk4kj2evdhmAKZUtev9zQM037/nuR47ApbHN8FwZWS9OL7sAQyxpFMkvtGIxVJtb4GMq2vRdJGI02S+5mHZJ47kicnd1pfffn626veaHt7o/DM9qoxbLeb4xG1FhhLukqNCs8b5TlJTgyROzpHkoNBpUb/ylnmjhgbkux274LgSqlMJJslCsO011uaZV7GcrqPgkD5vpptf+dcGDKON3d2SvOy8m96rXZ+/rixkYlkIlmVRm8STZe/GHB29lirZb6/anaXgcRYeqq0/KMR2+33VRtNa0GMo/fqdw7FoTN7qAoiPEvI9OiFCCY5AGiN3FWliMASfwDgYH5MXi5Z8wAAACV0RVh0Y3JlYXRlLWRhdGUAMjAxMC0xMS0xMlQxMTozNDo0NS0wNjowMF4RciAAAAAldEVYdG1vZGlmeS1kYXRlADIwMTAtMTEtMTJUMTA6NDY6NTYtMDY6MDAMugIsAAAAHXRFWHRTb2Z0d2FyZQBHUEwgR2hvc3RzY3JpcHQgOC43MQM/aDQAAAAASUVORK5CYII=""",
"ww": b"""iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAIAAABvFaqvAAAACXBIWXMAAAxMAAAMTAEAiU+qAAAACXZwQWcAAAAYAAAAGAB4TKWmAAAB3UlEQVQ4y6VVO27bUBCc/YiFgcBllDZXsK+U3gewxI9dJQjgs9iNG3eukhOkD0DGCAzIQGBZfLubgpIiyw7JIFM+koOZnTdLWlooIQJ7IMAczBgEEVJAhSAE0LNnHa2MYNm+z3ihJQIIWIqrq4fl0tcng0ytxS7co209Ik5Ovh8ff3MPs3CPfrQWvKfFHap0dvbj4qI+OBCiIS0b8HOWEEFZNvN5zaxjOQAQdMtiFqqU501V1Vmmq1Vy34xscEQBBf1xVBRNVdUi2n3c+RIZJpoQFIFAiFBVNWVZq4rZWkPbxmLhT09OBOqdlgXoaeXZhIqiKctaRN1j62UyocNDjkAEengikGVEEXF+3sxm+yw7N2QYqiR3Pz98+ninKu6vFWUcsmxMl8ZBvn75LIKbmwd5PZ5R1gDoqo3T02lK+MuwZeSwlYXcoyimzMjzLn4ww8yOjt5cX78fGb+CQCAzzOdT97UuZpit49+tUZ81BIjBjJSiKKYR6C43NuUwAxH625ti0zUiiJBZlOWUGUXRMFMXacfST0S7sonATGbI82lVvXNP/xD+VtEOF1KK2ezt/X26vf01pvpr7G3Ibkl2e/LycvH4aN3J4Iak1kPppdK185FIAbUA4X9/Rxb4DQ6meRDp8UWOAAAAJXRFWHRjcmVhdGUtZGF0ZQAyMDEwLTExLTEyVDExOjM0OjQ1LTA2OjAwXhFyIAAAACV0RVh0bW9kaWZ5LWRhdGUAMjAxMC0xMS0xMlQxMDo0Nzo0MS0wNjowMOp1VwIAAAAddEVYdFNvZnR3YXJlAEdQTCBHaG9zdHNjcmlwdCA4LjcxAz9oNAAAAABJRU5ErkJggg==""",
"ee": b"""iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAIAAABvFaqvAAAACXBIWXMAAAxMAAAMTAEAiU+qAAAACXZwQWcAAAAYAAAAGAB4TKWmAAABxklEQVQ4y61VS04bQRSs1/0MiDUoM/fgEBwlyooDWPOxL8BZ4BJsoyiLbLKKZEhWThaYmX6vshgDNgZPR6RWLc1Tqaq6+o2sjCogMQp3xIDdQREkQqMgCiDjRHhk2Z3l88e3MYhdrfz6+rclgq/JJ9Ab98OdZnTn2dm3i4sfJPve3bdmemPIsLQO4vg4Xl4u5vM7VXF/qStkpfM0HbSqFm17GyPcucml5EhKfAzFHe48ONCmWbijbYuUGKOIAIBOxsyJbB1IxKiz2UIETVOYIQRAoHe/LO51R5LE4WHoewJwpztUY9suQkBVFe4ERIria9dRZA8RRCCC5dIHrkFdCGKW6rpsmqLrKaqfU8roNfCiiU9c83k5nRZydPTl4cFzaHZ7KIIYYeYfP53m9mgUmtJ2H/7RWkpra3pyou8Mezotup5y+zNlXv/5+febmz8xRnfEiJSsbcvh+h2iH05jZgqTiQAIQQCklOq6rKqhkAJAe4eOKBravL41EZilqiqbZuOJOHTwn4MQEIJ0nTVNWdeF2fNDQ85i24R7ms0GFoQgWwr+12LLIiJ5f29XV8uB4gXLQCS9U7N321vLPxFqhOC9vyMj/gJsaMELYgNmYQAAACV0RVh0Y3JlYXRlLWRhdGUAMjAxMC0xMS0xMlQxMTozNDo0NS0wNjowMF4RciAAAAAldEVYdG1vZGlmeS1kYXRlADIwMTAtMTEtMTJUMTA6NDc6MzYtMDY6MDAlF2CVAAAAHXRFWHRTb2Z0d2FyZQBHUEwgR2hvc3RzY3JpcHQgOC43MQM/aDQAAAAASUVORK5CYII=""",
"camera": b"""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""",
"se": b"""iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAIAAABvFaqvAAAACXBIWXMAAAxMAAAMTAEAiU+qAAAACXZwQWcAAAAYAAAAGAB4TKWmAAACaUlEQVQ4y5WVwW4TSRCG/796xsGOD34DhDgi8TjADRkEgjcCJMRcgiccEcfdZaPlnpk8wTrnTRwExo57un4O4xgTQuwtjUatUc1X9Vd3VXOelBESAJBICQBCWH7Zxkg0QhaIQIAA4I5OtlwE2xYEQIDhInKMMkNZnhXFxAwxbp1SS4pJkmJ0Se/ff+716jyvynIiabFwbWcxCY3LXZI+fPg8GNRkTdb9frW/P1kF2Ap0HiVpNJrs7tZkbVaTNVB1u/8jr5i0LOli4TE6CQkSzGw243A4LsuzPOdW9VpJe/du0u9XZBXCEVCHcERW22j0pMaFmCRf5j8aTbrdCqjNji7eGzQ2jSQtopa7tvIry5ZVrbHqbrcajS6z/CL8yxf/fTz4+gO0yn9/fyuNTeOSiuIkhMM//vryE2gV83qN5+feur15c9LpHBqrg3+ml0EbNb59O2ndXr8+yfNDszqE+uPB1+zXfcxzNo3u3x+QePx4PJ16CJaSQuB8ridPxr0e53M9f37cNBYCPAkAY1J2VX/GqDxnWZ49ejSezWhGd5nR3Xd36Y7ZTGYmicCff9/Ofne+2nP44MGAxHA4ns1EmrtITqft9KBcYNuyuG5YrDQWxc1eT4CbQQKJtgfa4dPahqmTZYxR9+4N9vZu9ftsKW0bXbINoNU/87ncr/PcAHJXp8OiOH348N9v39Sir879GkoTleUsitNnz46bxkhK4lpd2jXB34IkuKOlPH16nJLRluflkpHLJG298uugEPDq1elweCyRhJIIEPr5gVze7uP6dbQeJyV8+jRNSTs7llzE1SaBwJ27N74DejPTVruTNQsAAAAldEVYdGNyZWF0ZS1kYXRlADIwMTAtMTEtMTJUMTE6MzQ6NDUtMDY6MDBeEXIgAAAAJXRFWHRtb2RpZnktZGF0ZQAyMDEwLTExLTEyVDEwOjQ2OjUyLTA2OjAw+PUmPwAAAB10RVh0U29mdHdhcmUAR1BMIEdob3N0c2NyaXB0IDguNzEDP2g0AAAAAElFTkSuQmCC""",
"nw": b"""iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAIAAABvFaqvAAAACXBIWXMAAAxMAAAMTAEAiU+qAAAACXZwQWcAAAAYAAAAGAB4TKWmAAACVUlEQVQ4y5WUvU4bQRSFz53ZMV7biiwewLwIRUJPjSUau+CdAIFMA/4pEWUUhPIA7FpJqkiR2yjEoDj4Z2bnpFhjjP9zitVq5u53zxntXPn5231tDwiIYKEIaCXDoddadnfzWoN8UyACRwTfvgz2PnwXQEQ4UwIBKEpE6BxPTkp77/PeQ6sFzQISSgAREsSsK6WFHkqxVitVKttJAjVHSUnpssxaGXsWehjjT09Llcq2s9R66QkEAEimXqZxIiC9MTw+Tr0wMEsYE9AiLwCQy8nZ2U65XByNaFZSAKhVewrZrKRcWcOZA6XfkBBBr8fDwx+t1qMx4hw3BnGMSCneA1DPz1KpdJrNxyAQa7kWJABECckwRD4PkkoJSaVUvy/VaqfReDRmFSsFUWuQzGRYq5UuL3fyeZBea/GeWstggKOjzpqMt3c9rWOlYmPuz88fSJK8uuqGYQTESrVfnlEYRo1Gl+Ro5PlWNiHuPv9VEmUy97XaQ1o0HHqSjUbKiqZYcRhG9foClk2Ij5/+aH1/cfFA0rnxtrWeZLPZLRQikUjrNhBr3RaJCoWo2exOal5Bt3e9k+NfaRM/1SbtWa9vlNEmxMiSpHOcV1q3PqOnTQjn6RMu0+qMrVaXpPd0nrDLKSsyisRKxZnM+HCHlgHWKf0Py+WiCKrVTr9PEUnvgDFqa+vlbqx1tChjLBIXi/HNzdN/RJs/e2OiXC6+vn6aNLDJBtFmMh4cFAcDZrOyv//O2tc5JdYzWDdrpuX9eGxPXgA4IkgIAchNQSIYOQDQGs6PVxLiH5XrpvEOYi2tAAAAJXRFWHRjcmVhdGUtZGF0ZQAyMDEwLTExLTEyVDExOjM0OjQ1LTA2OjAwXhFyIAAAACV0RVh0bW9kaWZ5LWRhdGUAMjAxMC0xMS0xMlQxMDo0NzowMS0wNjowMG4/WfgAAAAddEVYdFNvZnR3YXJlAEdQTCBHaG9zdHNjcmlwdCA4LjcxAz9oNAAAAABJRU5ErkJggg==""",

"cross": b"iVBORw0KGgoAAAANSUhEUgAAAAoAAAAKCAYAAACNMs+9AAAABHNCSVQICAgIfAhkiAAAADtJREFUGJVjYGBg+M9AGPxnRFPIiK4AXQKbYhQxZBNwOYERr1XoTmHCYQp2Y0mxmijPEBU8THgUoYgBABqMDQrxNogwAAAAAElFTkSuQmCC",

"plus": b"iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgIfAhkiAAAAFlJREFUOI3FUkEOwCAMAuP/v4wXu4PWrkuXyKWHUgIocBsMdspwW6QuCdKq80Egg7JAnzP2eebQitFb1v2SAMByhMeBtzRX5PG1aR14jPo/yOC3DjykItzHAE3QExOIgOhpAAAAAElFTkSuQmCC",

"redo": b"iVBORw0KGgoAAAANSUhEUgAAABAAAAAPCAYAAADtc08vAAAABHNCSVQICAgIfAhkiAAAAgFJREFUKJGdks9Lk3Ecx1/P8+zR55nP89VoMa1EMtYSpDCIaJfEQ108dZSO28VLCJPA/yBYjaBE2MBD4Ml+SNKhgxGpRaSRusPyUjMnC9fapm3+mN8O0nLNjHof358378/780NhD0Yn5+XdsSmW0tky13XWQ+T6VYU/oFwIRsblo1cx6o2aKlG2uMkFbzMjN3oqjIKRcakAhB+/lPefvcVlqABslFTyW9vYuoNabaeCmx3sU/Y2VAA6+4ekS5PomkY8s05Xh4f2FjcLn1JMvFukVRjomka+uEOyUOB0i5vlZJr81jYOgNx6AU+TYK1YoqvDQyjQXTlzb1h6D9XR1KBjGyqbmSynXE5mVnKoALbuwDKcWIbGsSP1VTuYHexT4pl1ABobbJoPN2AZToDdBABC2AjLZGwqtu+2RZ2JZTgRwi5ztr66a3C+/QRrxQJHbYGrpvpi53rD8lJrI8I0q2oqQCjQrcwk0gjL5EpHG539Q/KnoOfmiARYTK2S+JYmVyggLBNhmSg1+q8/CNx5KIVawuc9ydfcGsOvPzAd8lfEGZ2cl/GlFLHEF5aTaT7nv1MhuDwQldcutnHc7WIlleHei4Uqk7/CF4zKBxNzci7+UT55/l76glF5kF79nZgO+ZVbT9+wmt3gjLcZn7fxwIaO/cjpkF+5bQ1LYdb+U/r/wg/0p7W1+p/g5QAAAABJRU5ErkJggg==",

"info": b"iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAACzElEQVR42m2TW0gUURjHv3Nmb+6ut028lOaldm0RL2gGxWamSWHWi4JhPRjokyhCYWA9lfRQD0FUBJbdCBEEUzFILFjxQaxQWi+prXfXXV11J2zXXXdmOjPO7no78zAcvu//+/7nO+dDcMD6Ob14OiwisnDItpk0aXOi5XWXecm68qW5Irtvby7aualq/q49k6FrlEulOQ4Pi4ALxLa8DFjsG/0zc9bKDzezhvcByt8PntRr Y7vlCmk4QmhXkGNZAIyBI0CXy7MxNW8vaizVG/05RQ9aNOmGHJNCIT3Mi3m9T3xcjSAvXgXG eSeM0SyBcOBxe1cnRn6ntVTlWoS86s6ZxwqV/DYWxXjHwc7HKcFwVA0dEzQMLbuBJS5YAnG7 PK+eXo6vRNk36qisa1VWhHEEFsU+F5gkRisR8O1Y2eSE6tsAQmZZ5/i39ghUUN+UEpmZM8xX x0QtAMiXGEJBoS4MUmKCYWCOhre/1gMAlhNcOBfMBpR3911+cPKpHgoToQBAEKmkIDZUDqlR QXBBdwg6Ru3QOrImNFGA8ADSV2ZtsQQZ6prOKpIye4XqGPntKyQYGku0oJRJoLb9D8zT7j0A sqGtV1FaeUOUKq1gCRM1Eo/BX8FFXTjcyk+EcdsG1LRNCkIQ7YsQjlkwnRD6ndlgHGARzg44 QPC8VA/pcWHw5OsU2Bwu6Jv+Kwh9DhDHTgzeO5csAPR1n4pZiboViQCVnALjHQNQ5PG0/ViA 7jE79E85eP/bEAKgwFsx+vDSa/+NJ9R2fuQQVcY3QCbF8Kg0FWjXFrzpnYXZVacoBuGPgOly mrquLPe85PwATX61TKbNbeIAXxeeMto1JiCqSRO87cySqWyl475z3zDxS51bU0yFHqmnNAkZ /MX65Mz6rHlz9PMzxm5+4V2b2zpwGgMziiQoSBODQ6KPEa2EpS0WzuWwkMg/fjB3pv4HvQJH bUDKnS4AAAAASUVORK5CYII=",

"target": b"iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAG7AAABuwBHnU4NQAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAI8SURBVEiJ5VVNaxNRFD33jf3yAzctLtwLKsaVdFWUbp24qvWjJZnZuBETkJm0aoaOtGrIDIWErlwkraRQoiubbqWCK12IEQv+ARHajYuStCHvujBJG51MJwU3ejbz3p13z7nn8ngX+K/ARjjFRjjVTc6RrhSIpxqr6aApoiuBQ4AOOhB5NH9aETIGcDhXfXsWAPT+yxsgrAohszl76ptfvq8DPemMClH/xCT7GBRtxqWUOjEGZF2UtaRz5VAONCs90q+c+FqtV04tzt7/DABsqgwA5JQIACK2EzqK4993a9tnck+Md4Ed6A+eDgFU3MH2YJO8UU4WhGxz+8I2y5X6jyEp+OUd2x0MLICenjgBxbxtbLTZTZfilC7F98eWZqe/MPBqV3IssAAzX2NQoS0GEBtXb7Kp3uDfWiuAAiTCXlytg5xQbTBm/lTDArmle2yEb4N4uVHBLXLXVthUFwDc9WB9TOmS3dFBGwTkry/vVU2isSZ5YL4XNCtd1iz3UruRzi3SLWdYSzofvbg8nwoieg3mSQAfWjGA4a6teJ2XwCQJrHr9825RrZZhYFy33XNtLhJqhhNqZn8saqXOEzDWKygLD3gK5J893AR4vA/HtjRr/sKeAmJgtK5jxHZCA8rJTSHp+nPb2PLi8n2L9KQzyoQiiAtgsZyvrr8HgGjvyLAixAQDE2CMLc6Z6504fG9Rfs58I6VykVjsEHiplSREngkVociQH3nXYFPl5nsUFH99HnQ70QJPsn8HPwGaGNNZ8MsV4wAAAABJRU5ErkJggg==",

"pin": b"iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAG7AAABuwBHnU4NQAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAKGSURBVEiJ1ZXPS1RRFIC/648ZnVHG9yatxCyNhMIoyqj+hCBrhNq0cRNtsqiw2kUQ2EKwbGMt2rTrh2gEBe4KCSrToCTDTELDLObdMXXQ0Xmnhc44Ph/juBE8u3fvOd93uJd3Lmz0UOk2RcSrtT4tInVKqf2AsbillVJ9ItJhGMYzpdTsmgXhcPiUUqoZ2LFKk8MicjUYDLZnJBCRbMuyWpRSF1cBO+vumqbZqJSKp65nORO11q2ZwL3dHeR33FvqVKlLlmW1OPOWCbTWIeB8Jh17errI63pEblM9iCQkFyzLqnUVDA8P54nInUzgEp1kfCbOnC0UjPTjuXUGxIaFI28VEe8KQSAQCLH6hTI30Ev4ynGmPr5mdCLKvG3jHxvE97g5kVJhWdaJxEdOSm3IDaii//C8e4m9qYzIwCei7W1IfB6AWNxmvKKGEr+X+e17lmqUCgFPnYKDboKC+43kDPYCMBuNMb0IB8guKSOvoZmpgoCzLMlKveQtboLp+pvYwVIAgj4PJf6F41WePALX28haCQcodRO4/nR2sJTJhlZmfEUAGPkeiv1eCs/eIKe8yq1kWSQFSqlfbgkiQvffGE8On2PGvzApzHwPhUYwHTfJSgpEpM8N/vbzN76PjLG5+gCxaw+xi4oByP7zM52gd4UA6HRm9XwdYmj0N7u2beXQ7p3ES8qZvPyA+cq9zB6tdaanNpZkqZTF3Egk8kVEqgAmpqI8f/OeqvJSjlSvftYp0W8Yxr7ETFp2sVrrkIh0JAQiQlGhfy1wAU6apvkisbBsFhmG0QncBggU+NYKB2hKhcM6jOv1f3AcXXm11nXAMaAGqFzc+iEiH4BXpml2pnsyN378B2mABOAjSpYvAAAAAElFTkSuQmCC",

"pw_hide": b"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",

"pw_show": b"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"

}

# recipe for converting png file to icon:
#   import base64
#   f = open('my.png', 'rb')
#   print(base64.b64encode(f.read()))

aliases = dict(ww='leftarrow', ee='rightarrow', nn='uparrow', ss='downarrow')
for old, new in aliases.items():
    RAW_ICONS[new] = RAW_ICONS[old]

def get_icon(name):
    if name in RAW_ICONS:
        return wx.Bitmap(PyEmbeddedImage(RAW_ICONS[name]).GetImage())
