/* $Id: system.h.in,v 1.21 2005/09/05 05:35:36 pekberg Exp $
******************************************************************************

   GGI - Architecture specific things (autogenerated by configure)

******************************************************************************
*/

#ifndef _GGI_SYSTEM_H
#define _GGI_SYSTEM_H

#include <stdlib.h>

#include <inttypes.h>
#include <sys/time.h>



#ifndef __BEGIN_DECLS
# ifdef __cplusplus
#  define __BEGIN_DECLS extern "C" {
#  define __END_DECLS }
# else
#  define __BEGIN_DECLS /* empty */
#  define __END_DECLS /* empty */
# endif
#endif

#ifdef __CYGWIN32__
# ifndef __CYGWIN__
#  define __CYGWIN__	1
# endif
#endif

#ifndef __WIN32__
# if defined(__CYGWIN__)  || \
    defined(__MINGW32__) || \
    defined(__MINGW__)   || \
    defined(_WIN32)
# define __WIN32__
# endif
#endif /* ! __WIN32__ */

/* EXPORTVAR and IMPORTVAR are supposed to be used in
 * declarations of exported and imported variables
 * respectively.
 */

#if defined(__WIN32__) && defined(_MSC_VER)
/* On win32 with MSVC, rely on the compiler/linker
 * to do the right thing if a variable is declared
 * dllimport even if there is no need to import it
 * from a dll (i.e. when linking statically).
 */
# define EXPORTVAR      extern
# define IMPORTVAR      extern __declspec(dllimport)
# define EXPORTFUNC     /* empty */
# define IMPORTFUNC     extern
#elif defined(__WIN32__)
/* But on win32, gcc can't build shared and static
 * libraries at the same time. auto-import should work
 * but it doesn't for variables (segfault in libggiwmh,
 * libgii and libggi seem fine by themselves).
 * So favour shared, and force users to configure
 * --disable-static.
 */
# define EXPORTVAR      extern __declspec(dllexport)
# define IMPORTVAR      extern __declspec(dllimport)
# define EXPORTFUNC     __declspec(dllexport)
# define IMPORTFUNC     extern __declspec(dllimport)
#else
# define EXPORTVAR	extern
# define IMPORTVAR	extern
# define EXPORTFUNC	/* empty */
# define IMPORTFUNC	extern
#endif



#define GG_HAVE_INT64

/* If inttypes can not be found at compile time, GGI libraries (or any
 * app) can define GG_NEED_INTTYPES at configure time to build anyway.
 */
#ifdef GG_NEED_INTTYPES
typedef signed char     int8_t;
typedef unsigned char   uint8_t;
typedef signed short    int16_t;
typedef unsigned short  uint16_t;
typedef signed int    int32_t;
typedef unsigned int  uint32_t;
# ifdef GG_HAVE_INT64
typedef signed long    int64_t;
typedef unsigned long  uint64_t;
# endif
#endif /* GG_NEED_INTTYPES */


/* If a GGI library or app has not been updated to the new inttypes
 * notation, it can define GG_NEED_OLD_INTTYPES in configure to build
 * the library anyway.
 */
#ifdef GG_NEED_OLD_INTTYPES
/* Define old types for compatibility */
typedef int8_t    sint8;
typedef uint8_t   uint8;
typedef int16_t   sint16;
typedef uint16_t  uint16;
typedef int32_t   sint32;
typedef uint32_t  uint32;
# ifdef GG_HAVE_INT64
typedef int64_t   sint64;
typedef uint64_t  uint64;
# endif
typedef	signed int   ggi_sint;
typedef unsigned int ggi_uint;
typedef	signed int   gg_sint;
typedef unsigned int gg_uint;
#endif /* GG_NEED_OLD_INTTYPES */

#define GGI_LITTLE_ENDIAN		1

#ifdef GGI_LITTLE_ENDIAN
#define GG_LITTLE_ENDIAN
#endif
#ifdef GGI_BIG_ENDIAN
#define GG_BIG_ENDIAN
#endif
/* TODO: what about PDP endian? */

#ifndef ssize_t
#define ssize_t __darwin_ssize_t
#endif



#endif /* _GGI_SYSTEM_H */
