/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.resolvers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.Collections;
import java.util.Set;
import java.util.jar.JarFile;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;

public class UrlBasedJarFileResolver
implements JarFileResolver {
    private final URL url;
    private final Path cacheDirectory;
    private JarFile jarFile;

    public UrlBasedJarFileResolver(Path cacheDirectory, URL url) {
        this.cacheDirectory = cacheDirectory;
        this.url = url;
    }

    @Override
    public Set<JarFile> resolveJarFiles() {
        if (null != this.jarFile) {
            return Collections.singleton(this.jarFile);
        }
        Path path = Paths.get(this.url.getPath(), new String[0]).getFileName();
        if (!path.getFileName().toString().endsWith(".jar")) {
            throw new JarvizException(RB.$("ERROR_PATH_IS_NOT_JAR", path.toAbsolutePath()));
        }
        Path file = this.cacheDirectory.resolve(path);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                Instant localLastModified = Files.getLastModifiedTime(file, new LinkOption[0]).toInstant();
                Instant remoteLastModified = Instant.ofEpochMilli(this.url.openConnection().getLastModified());
                if (localLastModified.isAfter(remoteLastModified)) {
                    this.jarFile = new JarFile(file.toFile());
                    return Collections.singleton(this.jarFile);
                }
            }
            catch (IOException e) {
                throw new JarvizException(RB.$("ERROR_OPENING_JAR", file.toAbsolutePath()));
            }
        }
        try (InputStream stream = this.url.openStream();){
            Files.copy(stream, file, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new JarvizException(RB.$("ERROR_DOWNLOADING_URL", this.url), e);
        }
        try {
            this.jarFile = new JarFile(file.toFile());
            return Collections.singleton(this.jarFile);
        }
        catch (IOException e) {
            throw new JarvizException(RB.$("ERROR_OPENING_JAR", file.toAbsolutePath()));
        }
    }
}

