/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.reflect.ProblemRecordingTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.model.internal.type.ModelType;
import org.jspecify.annotations.Nullable;

public class DefaultTypeValidationContext
extends ProblemRecordingTypeValidationContext {
    public static final String MISSING_NORMALIZATION_ANNOTATION = "MISSING_NORMALIZATION_ANNOTATION";
    private final boolean reportCacheabilityProblems;
    private final ImmutableList.Builder<InternalProblem> problems = ImmutableList.builder();
    public static final ProblemId MISSING_NORMALIZATION_ID = ProblemId.create((String)"missing-normalization-annotation", (String)"Missing normalization", (ProblemGroup)GradleCoreProblemGroup.validation().property());

    public static DefaultTypeValidationContext withRootType(Class<?> rootType, boolean cacheable, InternalProblems problems) {
        return new DefaultTypeValidationContext(rootType, cacheable, problems);
    }

    public static DefaultTypeValidationContext withoutRootType(boolean reportCacheabilityProblems, InternalProblems problems) {
        return new DefaultTypeValidationContext(null, reportCacheabilityProblems, problems);
    }

    private DefaultTypeValidationContext(@Nullable Class<?> rootType, boolean reportCacheabilityProblems, InternalProblems problems) {
        super(rootType, Optional::empty, problems);
        this.reportCacheabilityProblems = reportCacheabilityProblems;
    }

    public static boolean onlyAffectsCacheableWork(ProblemId id) {
        return MISSING_NORMALIZATION_ID.equals(id);
    }

    @Override
    protected void recordProblem(InternalProblem problem) {
        if (DefaultTypeValidationContext.onlyAffectsCacheableWork(problem.getDefinition().getId()) && !this.reportCacheabilityProblems) {
            return;
        }
        this.problems.add((Object)problem);
    }

    public ImmutableList<InternalProblem> getProblems() {
        return this.problems.build();
    }

    public static void throwOnProblemsOf(Class<?> implementation, ImmutableList<InternalProblem> validationMessages) {
        if (!validationMessages.isEmpty()) {
            String formatString = validationMessages.size() == 1 ? "A problem was found with the configuration of %s." : "Some problems were found with the configuration of %s.";
            throw new DefaultMultiCauseException(String.format(formatString, ModelType.of(implementation).getDisplayName()), (Iterable)validationMessages.stream().map(TypeValidationProblemRenderer::renderMinimalInformationAbout).sorted().map(InvalidUserDataException::new).collect(Collectors.toList()));
        }
    }
}

