searchData={"items":[{"type":"module","title":"gl","doc":"Erlang wrapper functions for OpenGL\n\nStandard OpenGL API\n\nThis documents the functions as a brief version of the complete\n[OpenGL reference pages.](https://www.khronos.org/registry/OpenGL-Refpages/)","ref":"gl.html"},{"type":"function","title":"gl.accum/2","doc":"The accumulation buffer is an extended-range color buffer. Images are not\nrendered into it. Rather, images rendered into one of the color buffers are\nadded to the contents of the accumulation buffer after rendering. Effects such\nas antialiasing (of points, lines, and polygons), motion blur, and depth of\nfield can be created by accumulating images generated with different\ntransformation matrices.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glAccum.xml)","ref":"gl.html#accum/2"},{"type":"function","title":"gl.activeShaderProgram/2","doc":"[`gl:activeShaderProgram/2`](`activeShaderProgram/2`) sets the linked program\nnamed by `Program` to be the active program for the program pipeline object\n`Pipeline`. The active program in the active program pipeline object is the\ntarget of calls to [`gl:uniform()`](`uniform1f/2`) when no program has been made\ncurrent through a call to [`gl:useProgram/1`](`useProgram/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glActiveShaderProgram.xhtml)","ref":"gl.html#activeShaderProgram/2"},{"type":"function","title":"gl.activeTexture/1","doc":"[`gl:activeTexture/1`](`activeTexture/1`) selects which texture unit subsequent\ntexture state calls will affect. The number of texture units an implementation\nsupports is implementation dependent, but must be at least 80.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glActiveTexture.xhtml)","ref":"gl.html#activeTexture/1"},{"type":"function","title":"gl.alphaFunc/2","doc":"The alpha test discards fragments depending on the outcome of a comparison\nbetween an incoming fragment's alpha value and a constant reference value.\n[`gl:alphaFunc/2`](`alphaFunc/2`) specifies the reference value and the\ncomparison function. The comparison is performed only if alpha testing is\nenabled. By default, it is not enabled. (See [`gl:enable/1`](`enable/1`) and\n[`gl:disable/1`](`enable/1`) of `?GL_ALPHA_TEST`.)\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glAlphaFunc.xml)","ref":"gl.html#alphaFunc/2"},{"type":"function","title":"gl.areTexturesResident/1","doc":"GL establishes a \\`\\`working set'' of textures that are resident in texture\nmemory. These textures can be bound to a texture target much more efficiently\nthan textures that are not resident.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glAreTexturesResident.xml)","ref":"gl.html#areTexturesResident/1"},{"type":"function","title":"gl.arrayElement/1","doc":"[`gl:arrayElement/1`](`arrayElement/1`) commands are used within\n[`gl:'begin'/1`](`'begin'/1`)/[`gl:'end'/0`](`'begin'/1`) pairs to specify\nvertex and attribute data for point, line, and polygon primitives. If\n`?GL_VERTEX_ARRAY` is enabled when [`gl:arrayElement/1`](`arrayElement/1`) is\ncalled, a single vertex is drawn, using vertex and attribute data taken from\nlocation `I` of the enabled arrays. If `?GL_VERTEX_ARRAY` is not enabled, no\ndrawing occurs but the attributes corresponding to the enabled arrays are\nmodified.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glArrayElement.xml)","ref":"gl.html#arrayElement/1"},{"type":"function","title":"gl.attachShader/2","doc":"In order to create a complete shader program, there must be a way to specify the\nlist of things that will be linked together. Program objects provide this\nmechanism. Shaders that are to be linked together in a program object must first\nbe attached to that program object. [`gl:attachShader/2`](`attachShader/2`)\nattaches the shader object specified by `Shader` to the program object specified\nby `Program`. This indicates that `Shader` will be included in link operations\nthat will be performed on `Program`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glAttachShader.xhtml)","ref":"gl.html#attachShader/2"},{"type":"function","title":"gl.begin/1","doc":"Equivalent to  '\\'end\\''/0 .","ref":"gl.html#begin/1"},{"type":"function","title":"gl.beginConditionalRender/2","doc":"Equivalent to  endConditionalRender/0 .","ref":"gl.html#beginConditionalRender/2"},{"type":"function","title":"gl.beginQuery/2","doc":"Equivalent to  endQuery/1 .","ref":"gl.html#beginQuery/2"},{"type":"function","title":"gl.beginQueryIndexed/3","doc":"Equivalent to  endQueryIndexed/2 .","ref":"gl.html#beginQueryIndexed/3"},{"type":"function","title":"gl.beginTransformFeedback/1","doc":"Equivalent to  endTransformFeedback/0 .","ref":"gl.html#beginTransformFeedback/1"},{"type":"function","title":"gl.bindAttribLocation/3","doc":"[`gl:bindAttribLocation/3`](`bindAttribLocation/3`) is used to associate a\nuser-defined attribute variable in the program object specified by `Program`\nwith a generic vertex attribute index. The name of the user-defined attribute\nvariable is passed as a null terminated string in `Name`. The generic vertex\nattribute index to be bound to this variable is specified by `Index`. When\n`Program` is made part of current state, values provided via the generic vertex\nattribute `Index` will modify the value of the user-defined attribute variable\nspecified by `Name`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindAttribLocation.xhtml)","ref":"gl.html#bindAttribLocation/3"},{"type":"function","title":"gl.bindBuffer/2","doc":"[`gl:bindBuffer/2`](`bindBuffer/2`) binds a buffer object to the specified\nbuffer binding point. Calling [`gl:bindBuffer/2`](`bindBuffer/2`) with `Target`\nset to one of the accepted symbolic constants and `Buffer` set to the name of a\nbuffer object binds that buffer object name to the target. If no buffer object\nwith name `Buffer` exists, one is created with that name. When a buffer object\nis bound to a target, the previous binding for that target is automatically\nbroken.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindBuffer.xhtml)","ref":"gl.html#bindBuffer/2"},{"type":"function","title":"gl.bindBufferBase/3","doc":"[`gl:bindBufferBase/3`](`bindBufferBase/3`) binds the buffer object `Buffer` to\nthe binding point at index `Index` of the array of targets specified by\n`Target`. Each `Target` represents an indexed array of buffer binding points, as\nwell as a single general binding point that can be used by other buffer\nmanipulation functions such as [`gl:bindBuffer/2`](`bindBuffer/2`) or\n`glMapBuffer`. In addition to binding `Buffer` to the indexed buffer binding\ntarget, [`gl:bindBufferBase/3`](`bindBufferBase/3`) also binds `Buffer` to the\ngeneric buffer binding point specified by `Target`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindBufferBase.xhtml)","ref":"gl.html#bindBufferBase/3"},{"type":"function","title":"gl.bindBufferRange/5","doc":"[`gl:bindBufferRange/5`](`bindBufferRange/5`) binds a range the buffer object\n`Buffer` represented by `Offset` and `Size` to the binding point at index\n`Index` of the array of targets specified by `Target`. Each `Target` represents\nan indexed array of buffer binding points, as well as a single general binding\npoint that can be used by other buffer manipulation functions such as\n[`gl:bindBuffer/2`](`bindBuffer/2`) or `glMapBuffer`. In addition to binding a\nrange of `Buffer` to the indexed buffer binding target,\n[`gl:bindBufferRange/5`](`bindBufferRange/5`) also binds the range to the\ngeneric buffer binding point specified by `Target`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindBufferRange.xhtml)","ref":"gl.html#bindBufferRange/5"},{"type":"function","title":"gl.bindBuffersBase/3","doc":"[`gl:bindBuffersBase/3`](`bindBuffersBase/3`) binds a set of `Count` buffer\nobjects whose names are given in the array `Buffers` to the `Count` consecutive\nbinding points starting from index `First` of the array of targets specified by\n`Target`. If `Buffers` is `?NULL` then\n[`gl:bindBuffersBase/3`](`bindBuffersBase/3`) unbinds any buffers that are\ncurrently bound to the referenced binding points. Assuming no errors are\ngenerated, it is equivalent to the following pseudo-code, which calls\n[`gl:bindBufferBase/3`](`bindBufferBase/3`), with the exception that the\nnon-indexed `Target` is not changed by\n[`gl:bindBuffersBase/3`](`bindBuffersBase/3`):\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindBuffersBase.xhtml)","ref":"gl.html#bindBuffersBase/3"},{"type":"function","title":"gl.bindBuffersRange/5","doc":"[`gl:bindBuffersRange/5`](`bindBuffersRange/5`) binds a set of `Count` ranges\nfrom buffer objects whose names are given in the array `Buffers` to the `Count`\nconsecutive binding points starting from index `First` of the array of targets\nspecified by `Target`. `Offsets` specifies the address of an array containing\n`Count` starting offsets within the buffers, and `Sizes` specifies the address\nof an array of `Count` sizes of the ranges. If `Buffers` is `?NULL` then\n`Offsets` and `Sizes` are ignored and\n[`gl:bindBuffersRange/5`](`bindBuffersRange/5`) unbinds any buffers that are\ncurrently bound to the referenced binding points. Assuming no errors are\ngenerated, it is equivalent to the following pseudo-code, which calls\n[`gl:bindBufferRange/5`](`bindBufferRange/5`), with the exception that the\nnon-indexed `Target` is not changed by\n[`gl:bindBuffersRange/5`](`bindBuffersRange/5`):\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindBuffersRange.xhtml)","ref":"gl.html#bindBuffersRange/5"},{"type":"function","title":"gl.bindFragDataLocation/3","doc":"[`gl:bindFragDataLocation/3`](`bindFragDataLocation/3`) explicitly specifies the\nbinding of the user-defined varying out variable `Name` to fragment shader color\nnumber `ColorNumber` for program `Program`. If `Name` was bound previously, its\nassigned binding is replaced with `ColorNumber`. `Name` must be a\nnull-terminated string. `ColorNumber` must be less than `?GL_MAX_DRAW_BUFFERS`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindFragDataLocation.xhtml)","ref":"gl.html#bindFragDataLocation/3"},{"type":"function","title":"gl.bindFragDataLocationIndexed/4","doc":"[`gl:bindFragDataLocationIndexed/4`](`bindFragDataLocationIndexed/4`) specifies\nthat the varying out variable `Name` in `Program` should be bound to fragment\ncolor `ColorNumber` when the program is next linked. `Index` may be zero or one\nto specify that the color be used as either the first or second color input to\nthe blend equation, respectively.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindFragDataLocationIndexed.xhtml)","ref":"gl.html#bindFragDataLocationIndexed/4"},{"type":"function","title":"gl.bindFramebuffer/2","doc":"[`gl:bindFramebuffer/2`](`bindFramebuffer/2`) binds the framebuffer object with\nname `Framebuffer` to the framebuffer target specified by `Target`. `Target`\nmust be either `?GL_DRAW_FRAMEBUFFER`, `?GL_READ_FRAMEBUFFER` or\n`?GL_FRAMEBUFFER`. If a framebuffer object is bound to `?GL_DRAW_FRAMEBUFFER` or\n`?GL_READ_FRAMEBUFFER`, it becomes the target for rendering or readback\noperations, respectively, until it is deleted or another framebuffer is bound to\nthe corresponding bind point. Calling\n[`gl:bindFramebuffer/2`](`bindFramebuffer/2`) with `Target` set to\n`?GL_FRAMEBUFFER` binds `Framebuffer` to both the read and draw framebuffer\ntargets. `Framebuffer` is the name of a framebuffer object previously returned\nfrom a call to [`gl:genFramebuffers/1`](`genFramebuffers/1`), or zero to break\nthe existing binding of a framebuffer object to `Target`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindFramebuffer.xhtml)","ref":"gl.html#bindFramebuffer/2"},{"type":"function","title":"gl.bindImageTexture/7","doc":"[`gl:bindImageTexture/7`](`bindImageTexture/7`) binds a single level of a\ntexture to an image unit for the purpose of reading and writing it from shaders.\n`Unit` specifies the zero-based index of the image unit to which to bind the\ntexture level. `Texture` specifies the name of an existing texture object to\nbind to the image unit. If `Texture` is zero, then any existing binding to the\nimage unit is broken. `Level` specifies the level of the texture to bind to the\nimage unit.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindImageTexture.xhtml)","ref":"gl.html#bindImageTexture/7"},{"type":"function","title":"gl.bindImageTextures/2","doc":"[`gl:bindImageTextures/2`](`bindImageTextures/2`) binds images from an array of\nexisting texture objects to a specified number of consecutive image units.\n`Count` specifies the number of texture objects whose names are stored in the\narray `Textures`. That number of texture names are read from the array and bound\nto the `Count` consecutive texture units starting from `First`. If the name zero\nappears in the `Textures` array, any existing binding to the image unit is\nreset. Any non-zero entry in `Textures` must be the name of an existing texture\nobject. When a non-zero entry in `Textures` is present, the image at level zero\nis bound, the binding is considered layered, with the first layer set to zero,\nand the image is bound for read-write access. The image unit format parameter is\ntaken from the internal format of the image at level zero of the texture object.\nFor cube map textures, the internal format of the positive X image of level zero\nis used. If `Textures` is `?NULL` then it is as if an appropriately sized array\ncontaining only zeros had been specified.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindImageTextures.xhtml)","ref":"gl.html#bindImageTextures/2"},{"type":"function","title":"gl.bindProgramPipeline/1","doc":"[`gl:bindProgramPipeline/1`](`bindProgramPipeline/1`) binds a program pipeline\nobject to the current context. `Pipeline` must be a name previously returned\nfrom a call to [`gl:genProgramPipelines/1`](`genProgramPipelines/1`). If no\nprogram pipeline exists with name `Pipeline` then a new pipeline object is\ncreated with that name and initialized to the default state vector.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindProgramPipeline.xhtml)","ref":"gl.html#bindProgramPipeline/1"},{"type":"function","title":"gl.bindRenderbuffer/2","doc":"[`gl:bindRenderbuffer/2`](`bindRenderbuffer/2`) binds the renderbuffer object\nwith name `Renderbuffer` to the renderbuffer target specified by `Target`.\n`Target` must be `?GL_RENDERBUFFER`. `Renderbuffer` is the name of a\nrenderbuffer object previously returned from a call to\n[`gl:genRenderbuffers/1`](`genRenderbuffers/1`), or zero to break the existing\nbinding of a renderbuffer object to `Target`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindRenderbuffer.xhtml)","ref":"gl.html#bindRenderbuffer/2"},{"type":"function","title":"gl.bindSampler/2","doc":"[`gl:bindSampler/2`](`bindSampler/2`) binds `Sampler` to the texture unit at\nindex `Unit`. `Sampler` must be zero or the name of a sampler object previously\nreturned from a call to [`gl:genSamplers/1`](`genSamplers/1`). `Unit` must be\nless than the value of `?GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindSampler.xhtml)","ref":"gl.html#bindSampler/2"},{"type":"function","title":"gl.bindSamplers/2","doc":"[`gl:bindSamplers/2`](`bindSamplers/2`) binds samplers from an array of existing\nsampler objects to a specified number of consecutive sampler units. `Count`\nspecifies the number of sampler objects whose names are stored in the array\n`Samplers`. That number of sampler names is read from the array and bound to the\n`Count` consecutive sampler units starting from `First`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindSamplers.xhtml)","ref":"gl.html#bindSamplers/2"},{"type":"function","title":"gl.bindTexture/2","doc":"[`gl:bindTexture/2`](`bindTexture/2`) lets you create or use a named texture.\nCalling [`gl:bindTexture/2`](`bindTexture/2`) with `Target` set to\n`?GL_TEXTURE_1D`, `?GL_TEXTURE_2D`, `?GL_TEXTURE_3D`, `?GL_TEXTURE_1D_ARRAY`,\n`?GL_TEXTURE_2D_ARRAY`, `?GL_TEXTURE_RECTANGLE`, `?GL_TEXTURE_CUBE_MAP`,\n`?GL_TEXTURE_CUBE_MAP_ARRAY`, `?GL_TEXTURE_BUFFER`, `?GL_TEXTURE_2D_MULTISAMPLE`\nor `?GL_TEXTURE_2D_MULTISAMPLE_ARRAY` and `Texture` set to the name of the new\ntexture binds the texture name to the target. When a texture is bound to a\ntarget, the previous binding for that target is automatically broken.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindTexture.xhtml)","ref":"gl.html#bindTexture/2"},{"type":"function","title":"gl.bindTextures/2","doc":"[`gl:bindTextures/2`](`bindTextures/2`) binds an array of existing texture\nobjects to a specified number of consecutive texture units. `Count` specifies\nthe number of texture objects whose names are stored in the array `Textures`.\nThat number of texture names are read from the array and bound to the `Count`\nconsecutive texture units starting from `First`. The target, or type of texture\nis deduced from the texture object and each texture is bound to the\ncorresponding target of the texture unit. If the name zero appears in the\n`Textures` array, any existing binding to any target of the texture unit is\nreset and the default texture for that target is bound in its place. Any\nnon-zero entry in `Textures` must be the name of an existing texture object. If\n`Textures` is `?NULL` then it is as if an appropriately sized array containing\nonly zeros had been specified.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindTextures.xhtml)","ref":"gl.html#bindTextures/2"},{"type":"function","title":"gl.bindTextureUnit/2","doc":"[`gl:bindTextureUnit/2`](`bindTextureUnit/2`) binds an existing texture object\nto the texture unit numbered `Unit`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindTextureUnit.xhtml)","ref":"gl.html#bindTextureUnit/2"},{"type":"function","title":"gl.bindTransformFeedback/2","doc":"[`gl:bindTransformFeedback/2`](`bindTransformFeedback/2`) binds the transform\nfeedback object with name `Id` to the current GL state. `Id` must be a name\npreviously returned from a call to\n[`gl:genTransformFeedbacks/1`](`genTransformFeedbacks/1`). If `Id` has not\npreviously been bound, a new transform feedback object with name `Id` and\ninitialized with the default transform state vector is created.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindTransformFeedback.xhtml)","ref":"gl.html#bindTransformFeedback/2"},{"type":"function","title":"gl.bindVertexArray/1","doc":"[`gl:bindVertexArray/1`](`bindVertexArray/1`) binds the vertex array object with\nname `Array`. `Array` is the name of a vertex array object previously returned\nfrom a call to [`gl:genVertexArrays/1`](`genVertexArrays/1`), or zero to break\nthe existing vertex array object binding.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindVertexArray.xhtml)","ref":"gl.html#bindVertexArray/1"},{"type":"function","title":"gl.bindVertexBuffer/4","doc":"Equivalent to  vertexArrayVertexBuffer/5 .","ref":"gl.html#bindVertexBuffer/4"},{"type":"function","title":"gl.bindVertexBuffers/4","doc":"Equivalent to  vertexArrayVertexBuffers/5 .","ref":"gl.html#bindVertexBuffers/4"},{"type":"function","title":"gl.bitmap/7","doc":"A bitmap is a binary image. When drawn, the bitmap is positioned relative to the\ncurrent raster position, and frame buffer pixels corresponding to 1's in the\nbitmap are written using the current raster color or index. Frame buffer pixels\ncorresponding to 0's in the bitmap are not modified.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glBitmap.xml)","ref":"gl.html#bitmap/7"},{"type":"function","title":"gl.blendColor/4","doc":"The `?GL_BLEND_COLOR` may be used to calculate the source and destination\nblending factors. The color components are clamped to the range \\[0 1] before\nbeing stored. See [`gl:blendFunc/2`](`blendFunc/2`) for a complete description\nof the blending operations. Initially the `?GL_BLEND_COLOR` is set to (0, 0, 0,\n0).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBlendColor.xhtml)","ref":"gl.html#blendColor/4"},{"type":"function","title":"gl.blendEquation/1","doc":"Equivalent to  blendEquationi/2 .","ref":"gl.html#blendEquation/1"},{"type":"function","title":"gl.blendEquationi/2","doc":"The blend equations determine how a new pixel (the ''source'' color) is combined\nwith a pixel already in the framebuffer (the ''destination'' color). This\nfunction sets both the RGB blend equation and the alpha blend equation to a\nsingle equation. [`gl:blendEquationi/2`](`blendEquation/1`) specifies the blend\nequation for a single draw buffer whereas\n[`gl:blendEquation/1`](`blendEquation/1`) sets the blend equation for all draw\nbuffers.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBlendEquation.xhtml)","ref":"gl.html#blendEquationi/2"},{"type":"function","title":"gl.blendEquationSeparate/2","doc":"Equivalent to  blendEquationSeparatei/3 .","ref":"gl.html#blendEquationSeparate/2"},{"type":"function","title":"gl.blendEquationSeparatei/3","doc":"The blend equations determines how a new pixel (the ''source'' color) is\ncombined with a pixel already in the framebuffer (the ''destination'' color).\nThese functions specify one blend equation for the RGB-color components and one\nblend equation for the alpha component.\n[`gl:blendEquationSeparatei/3`](`blendEquationSeparate/2`) specifies the blend\nequations for a single draw buffer whereas\n[`gl:blendEquationSeparate/2`](`blendEquationSeparate/2`) sets the blend\nequations for all draw buffers.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBlendEquationSeparate.xhtml)","ref":"gl.html#blendEquationSeparatei/3"},{"type":"function","title":"gl.blendFunc/2","doc":"Equivalent to  blendFunci/3 .","ref":"gl.html#blendFunc/2"},{"type":"function","title":"gl.blendFunci/3","doc":"Pixels can be drawn using a function that blends the incoming (source) RGBA\nvalues with the RGBA values that are already in the frame buffer (the\ndestination values). Blending is initially disabled. Use\n[`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`) with argument\n`?GL_BLEND` to enable and disable blending.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBlendFunc.xhtml)","ref":"gl.html#blendFunci/3"},{"type":"function","title":"gl.blendFuncSeparate/4","doc":"Equivalent to  blendFuncSeparatei/5 .","ref":"gl.html#blendFuncSeparate/4"},{"type":"function","title":"gl.blendFuncSeparatei/5","doc":"Pixels can be drawn using a function that blends the incoming (source) RGBA\nvalues with the RGBA values that are already in the frame buffer (the\ndestination values). Blending is initially disabled. Use\n[`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`) with argument\n`?GL_BLEND` to enable and disable blending.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBlendFuncSeparate.xhtml)","ref":"gl.html#blendFuncSeparatei/5"},{"type":"function","title":"gl.blitFramebuffer/10","doc":"[`gl:blitFramebuffer/10`](`blitFramebuffer/10`) and `glBlitNamedFramebuffer`\ntransfer a rectangle of pixel values from one region of a read framebuffer to\nanother region of a draw framebuffer.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBlitFramebuffer.xhtml)","ref":"gl.html#blitFramebuffer/10"},{"type":"function","title":"gl.bufferData/4","doc":"[`gl:bufferData/4`](`bufferData/4`) and `glNamedBufferData` create a new data\nstore for a buffer object. In case of [`gl:bufferData/4`](`bufferData/4`), the\nbuffer object currently bound to `Target` is used. For `glNamedBufferData`, a\nbuffer object associated with ID specified by the caller in `Buffer` will be\nused instead.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBufferData.xhtml)","ref":"gl.html#bufferData/4"},{"type":"function","title":"gl.bufferStorage/4","doc":"[`gl:bufferStorage/4`](`bufferStorage/4`) and `glNamedBufferStorage` create a\nnew immutable data store. For [`gl:bufferStorage/4`](`bufferStorage/4`), the\nbuffer object currently bound to `Target` will be initialized. For\n`glNamedBufferStorage`, `Buffer` is the name of the buffer object that will be\nconfigured. The size of the data store is specified by `Size`. If an initial\ndata is available, its address may be supplied in `Data`. Otherwise, to create\nan uninitialized data store, `Data` should be `?NULL`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBufferStorage.xhtml)","ref":"gl.html#bufferStorage/4"},{"type":"function","title":"gl.bufferSubData/4","doc":"[`gl:bufferSubData/4`](`bufferSubData/4`) and `glNamedBufferSubData` redefine\nsome or all of the data store for the specified buffer object. Data starting at\nbyte offset `Offset` and extending for `Size` bytes is copied to the data store\nfrom the memory pointed to by `Data`. `Offset` and `Size` must define a range\nlying entirely within the buffer object's data store.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBufferSubData.xhtml)","ref":"gl.html#bufferSubData/4"},{"type":"function","title":"gl.callList/1","doc":"[`gl:callList/1`](`callList/1`) causes the named display list to be executed.\nThe commands saved in the display list are executed in order, just as if they\nwere called without using a display list. If `List` has not been defined as a\ndisplay list, [`gl:callList/1`](`callList/1`) is ignored.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glCallList.xml)","ref":"gl.html#callList/1"},{"type":"function","title":"gl.callLists/1","doc":"[`gl:callLists/1`](`callLists/1`) causes each display list in the list of names\npassed as `Lists` to be executed. As a result, the commands saved in each\ndisplay list are executed in order, just as if they were called without using a\ndisplay list. Names of display lists that have not been defined are ignored.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glCallLists.xml)","ref":"gl.html#callLists/1"},{"type":"function","title":"gl.checkFramebufferStatus/1","doc":"[`gl:checkFramebufferStatus/1`](`checkFramebufferStatus/1`) and\n`glCheckNamedFramebufferStatus` return the completeness status of a framebuffer\nobject when treated as a read or draw framebuffer, depending on the value of\n`Target`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCheckFramebufferStatus.xhtml)","ref":"gl.html#checkFramebufferStatus/1"},{"type":"type","title":"gl.clamp/0","doc":"","ref":"gl.html#t:clamp/0"},{"type":"function","title":"gl.clampColor/2","doc":"[`gl:clampColor/2`](`clampColor/2`) controls color clamping that is performed\nduring [`gl:readPixels/7`](`readPixels/7`). `Target` must be\n`?GL_CLAMP_READ_COLOR`. If `Clamp` is `?GL_TRUE`, read color clamping is\nenabled; if `Clamp` is `?GL_FALSE`, read color clamping is disabled. If `Clamp`\nis `?GL_FIXED_ONLY`, read color clamping is enabled only if the selected read\nbuffer has fixed point components and disabled otherwise.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClampColor.xhtml)","ref":"gl.html#clampColor/2"},{"type":"function","title":"gl.clear/1","doc":"[`gl:clear/1`](`clear/1`) sets the bitplane area of the window to values\npreviously selected by [`gl:clearColor/4`](`clearColor/4`),\n[`gl:clearDepth/1`](`clearDepth/1`), and\n[`gl:clearStencil/1`](`clearStencil/1`). Multiple color buffers can be cleared\nsimultaneously by selecting more than one buffer at a time using\n[`gl:drawBuffer/1`](`drawBuffer/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClear.xhtml)","ref":"gl.html#clear/1"},{"type":"function","title":"gl.clearAccum/4","doc":"[`gl:clearAccum/4`](`clearAccum/4`) specifies the red, green, blue, and alpha\nvalues used by [`gl:clear/1`](`clear/1`) to clear the accumulation buffer.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glClearAccum.xml)","ref":"gl.html#clearAccum/4"},{"type":"function","title":"gl.clearBufferData/5","doc":"Equivalent to  clearBufferuiv/3 .","ref":"gl.html#clearBufferData/5"},{"type":"function","title":"gl.clearBufferfi/4","doc":"Equivalent to  clearBufferuiv/3 .","ref":"gl.html#clearBufferfi/4"},{"type":"function","title":"gl.clearBufferfv/3","doc":"Equivalent to  clearBufferuiv/3 .","ref":"gl.html#clearBufferfv/3"},{"type":"function","title":"gl.clearBufferiv/3","doc":"Equivalent to  clearBufferuiv/3 .","ref":"gl.html#clearBufferiv/3"},{"type":"function","title":"gl.clearBufferSubData/7","doc":"Equivalent to  clearBufferuiv/3 .","ref":"gl.html#clearBufferSubData/7"},{"type":"function","title":"gl.clearBufferuiv/3","doc":"These commands clear a specified buffer of a framebuffer to specified value(s).\nFor [`gl:clearBuffer*()`](`clearBufferiv/3`), the framebuffer is the currently\nbound draw framebuffer object. For `glClearNamedFramebuffer*`, `Framebuffer` is\nzero, indicating the default draw framebuffer, or the name of a framebuffer\nobject.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClearBuffer.xhtml)","ref":"gl.html#clearBufferuiv/3"},{"type":"function","title":"gl.clearColor/4","doc":"[`gl:clearColor/4`](`clearColor/4`) specifies the red, green, blue, and alpha\nvalues used by [`gl:clear/1`](`clear/1`) to clear the color buffers. Values\nspecified by [`gl:clearColor/4`](`clearColor/4`) are clamped to the range \\[0\n1].\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClearColor.xhtml)","ref":"gl.html#clearColor/4"},{"type":"function","title":"gl.clearDepth/1","doc":"Equivalent to  clearDepthf/1 .","ref":"gl.html#clearDepth/1"},{"type":"function","title":"gl.clearDepthf/1","doc":"[`gl:clearDepth/1`](`clearDepth/1`) specifies the depth value used by\n[`gl:clear/1`](`clear/1`) to clear the depth buffer. Values specified by\n[`gl:clearDepth/1`](`clearDepth/1`) are clamped to the range \\[0 1].\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClearDepth.xhtml)","ref":"gl.html#clearDepthf/1"},{"type":"function","title":"gl.clearIndex/1","doc":"[`gl:clearIndex/1`](`clearIndex/1`) specifies the index used by\n[`gl:clear/1`](`clear/1`) to clear the color index buffers. `C` is not clamped.\nRather, `C` is converted to a fixed-point value with unspecified precision to\nthe right of the binary point. The integer part of this value is then masked\nwith 2 m-1, where m is the number of bits in a color index stored in the frame\nbuffer.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glClearIndex.xml)","ref":"gl.html#clearIndex/1"},{"type":"function","title":"gl.clearStencil/1","doc":"[`gl:clearStencil/1`](`clearStencil/1`) specifies the index used by\n[`gl:clear/1`](`clear/1`) to clear the stencil buffer. `S` is masked with 2 m-1,\nwhere m is the number of bits in the stencil buffer.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClearStencil.xhtml)","ref":"gl.html#clearStencil/1"},{"type":"function","title":"gl.clearTexImage/5","doc":"[`gl:clearTexImage/5`](`clearTexImage/5`) fills all an image contained in a\ntexture with an application supplied value. `Texture` must be the name of an\nexisting texture. Further, `Texture` may not be the name of a buffer texture,\nnor may its internal format be compressed.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClearTexImage.xhtml)","ref":"gl.html#clearTexImage/5"},{"type":"function","title":"gl.clearTexSubImage/11","doc":"[`gl:clearTexSubImage/11`](`clearTexSubImage/11`) fills all or part of an image\ncontained in a texture with an application supplied value. `Texture` must be the\nname of an existing texture. Further, `Texture` may not be the name of a buffer\ntexture, nor may its internal format be compressed.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClearTexSubImage.xhtml)","ref":"gl.html#clearTexSubImage/11"},{"type":"function","title":"gl.clientActiveTexture/1","doc":"[`gl:clientActiveTexture/1`](`clientActiveTexture/1`) selects the vertex array\nclient state parameters to be modified by\n[`gl:texCoordPointer/4`](`texCoordPointer/4`), and enabled or disabled with\n[`gl:enableClientState/1`](`enableClientState/1`) or\n[`gl:disableClientState/1`](`enableClientState/1`), respectively, when called\nwith a parameter of `?GL_TEXTURE_COORD_ARRAY`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glClientActiveTexture.xml)","ref":"gl.html#clientActiveTexture/1"},{"type":"function","title":"gl.clientWaitSync/3","doc":"[`gl:clientWaitSync/3`](`clientWaitSync/3`) causes the client to block and wait\nfor the sync object specified by `Sync` to become signaled. If `Sync` is\nsignaled when [`gl:clientWaitSync/3`](`clientWaitSync/3`) is called,\n[`gl:clientWaitSync/3`](`clientWaitSync/3`) returns immediately, otherwise it\nwill block and wait for up to `Timeout` nanoseconds for `Sync` to become\nsignaled.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClientWaitSync.xhtml)","ref":"gl.html#clientWaitSync/3"},{"type":"function","title":"gl.clipControl/2","doc":"[`gl:clipControl/2`](`clipControl/2`) controls the clipping volume behavior and\nthe clip coordinate to window coordinate transformation behavior.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClipControl.xhtml)","ref":"gl.html#clipControl/2"},{"type":"function","title":"gl.clipPlane/2","doc":"Geometry is always clipped against the boundaries of a six-plane frustum in `x`,\n`y`, and `z`. [`gl:clipPlane/2`](`clipPlane/2`) allows the specification of\nadditional planes, not necessarily perpendicular to the `x`, `y`, or `z` axis,\nagainst which all geometry is clipped. To determine the maximum number of\nadditional clipping planes, call [`gl:getIntegerv/1`](`getBooleanv/1`) with\nargument `?GL_MAX_CLIP_PLANES`. All implementations support at least six such\nclipping planes. Because the resulting clipping region is the intersection of\nthe defined half-spaces, it is always convex.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glClipPlane.xml)","ref":"gl.html#clipPlane/2"},{"type":"function","title":"gl.color3b/3","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color3b/3"},{"type":"function","title":"gl.color3bv/1","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color3bv/1"},{"type":"function","title":"gl.color3d/3","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color3d/3"},{"type":"function","title":"gl.color3dv/1","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color3dv/1"},{"type":"function","title":"gl.color3f/3","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color3f/3"},{"type":"function","title":"gl.color3fv/1","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color3fv/1"},{"type":"function","title":"gl.color3i/3","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color3i/3"},{"type":"function","title":"gl.color3iv/1","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color3iv/1"},{"type":"function","title":"gl.color3s/3","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color3s/3"},{"type":"function","title":"gl.color3sv/1","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color3sv/1"},{"type":"function","title":"gl.color3ub/3","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color3ub/3"},{"type":"function","title":"gl.color3ubv/1","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color3ubv/1"},{"type":"function","title":"gl.color3ui/3","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color3ui/3"},{"type":"function","title":"gl.color3uiv/1","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color3uiv/1"},{"type":"function","title":"gl.color3us/3","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color3us/3"},{"type":"function","title":"gl.color3usv/1","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color3usv/1"},{"type":"function","title":"gl.color4b/4","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color4b/4"},{"type":"function","title":"gl.color4bv/1","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color4bv/1"},{"type":"function","title":"gl.color4d/4","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color4d/4"},{"type":"function","title":"gl.color4dv/1","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color4dv/1"},{"type":"function","title":"gl.color4f/4","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color4f/4"},{"type":"function","title":"gl.color4fv/1","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color4fv/1"},{"type":"function","title":"gl.color4i/4","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color4i/4"},{"type":"function","title":"gl.color4iv/1","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color4iv/1"},{"type":"function","title":"gl.color4s/4","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color4s/4"},{"type":"function","title":"gl.color4sv/1","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color4sv/1"},{"type":"function","title":"gl.color4ub/4","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color4ub/4"},{"type":"function","title":"gl.color4ubv/1","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color4ubv/1"},{"type":"function","title":"gl.color4ui/4","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color4ui/4"},{"type":"function","title":"gl.color4uiv/1","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color4uiv/1"},{"type":"function","title":"gl.color4us/4","doc":"Equivalent to  color4usv/1 .","ref":"gl.html#color4us/4"},{"type":"function","title":"gl.color4usv/1","doc":"The GL stores both a current single-valued color index and a current four-valued\nRGBA color. [`gl:color()`](`color3b/3`) sets a new four-valued RGBA color.\n[`gl:color()`](`color3b/3`) has two major variants: [`gl:color3()`](`color3b/3`)\nand [`gl:color4()`](`color3b/3`). [`gl:color3()`](`color3b/3`) variants specify\nnew red, green, and blue values explicitly and set the current alpha value to\n1.0 (full intensity) implicitly. [`gl:color4()`](`color3b/3`) variants specify\nall four color components explicitly.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glColor.xml)","ref":"gl.html#color4usv/1"},{"type":"function","title":"gl.colorMask/4","doc":"Equivalent to  colorMaski/5 .","ref":"gl.html#colorMask/4"},{"type":"function","title":"gl.colorMaski/5","doc":"[`gl:colorMask/4`](`colorMask/4`) and [`gl:colorMaski/5`](`colorMask/4`) specify\nwhether the individual color components in the frame buffer can or cannot be\nwritten. [`gl:colorMaski/5`](`colorMask/4`) sets the mask for a specific draw\nbuffer, whereas [`gl:colorMask/4`](`colorMask/4`) sets the mask for all draw\nbuffers. If `Red` is `?GL_FALSE`, for example, no change is made to the red\ncomponent of any pixel in any of the color buffers, regardless of the drawing\noperation attempted.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glColorMask.xhtml)","ref":"gl.html#colorMaski/5"},{"type":"function","title":"gl.colorMaterial/2","doc":"[`gl:colorMaterial/2`](`colorMaterial/2`) specifies which material parameters\ntrack the current color. When `?GL_COLOR_MATERIAL` is enabled, the material\nparameter or parameters specified by `Mode`, of the material or materials\nspecified by `Face`, track the current color at all times.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glColorMaterial.xml)","ref":"gl.html#colorMaterial/2"},{"type":"function","title":"gl.colorPointer/4","doc":"[`gl:colorPointer/4`](`colorPointer/4`) specifies the location and data format\nof an array of color components to use when rendering. `Size` specifies the\nnumber of components per color, and must be 3 or 4. `Type` specifies the data\ntype of each color component, and `Stride` specifies the byte stride from one\ncolor to the next, allowing vertices and attributes to be packed into a single\narray or stored in separate arrays. (Single-array storage may be more efficient\non some implementations; see [`gl:interleavedArrays/3`](`interleavedArrays/3`).)\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glColorPointer.xml)","ref":"gl.html#colorPointer/4"},{"type":"function","title":"gl.colorSubTable/6","doc":"[`gl:colorSubTable/6`](`colorSubTable/6`) is used to respecify a contiguous\nportion of a color table previously defined using\n[`gl:colorTable/6`](`colorTable/6`). The pixels referenced by `Data` replace the\nportion of the existing table from indices `Start` to start+count-1, inclusive.\nThis region may not include any entries outside the range of the color table as\nit was originally specified. It is not an error to specify a subtexture with\nwidth of 0, but such a specification has no effect.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glColorSubTable.xml)","ref":"gl.html#colorSubTable/6"},{"type":"function","title":"gl.colorTable/6","doc":"[`gl:colorTable/6`](`colorTable/6`) may be used in two ways: to test the actual\nsize and color resolution of a lookup table given a particular set of\nparameters, or to load the contents of a color lookup table. Use the targets\n`?GL_PROXY_*` for the first case and the other targets for the second case.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glColorTable.xml)","ref":"gl.html#colorTable/6"},{"type":"function","title":"gl.colorTableParameterfv/3","doc":"Equivalent to  colorTableParameteriv/3 .","ref":"gl.html#colorTableParameterfv/3"},{"type":"function","title":"gl.colorTableParameteriv/3","doc":"[`gl:colorTableParameter()`](`colorTableParameterfv/3`) is used to specify the\nscale factors and bias terms applied to color components when they are loaded\ninto a color table. `Target` indicates which color table the scale and bias\nterms apply to; it must be set to `?GL_COLOR_TABLE`,\n`?GL_POST_CONVOLUTION_COLOR_TABLE`, or `?GL_POST_COLOR_MATRIX_COLOR_TABLE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glColorTableParameter.xml)","ref":"gl.html#colorTableParameteriv/3"},{"type":"function","title":"gl.compileShader/1","doc":"[`gl:compileShader/1`](`compileShader/1`) compiles the source code strings that\nhave been stored in the shader object specified by `Shader`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCompileShader.xhtml)","ref":"gl.html#compileShader/1"},{"type":"function","title":"gl.compressedTexImage1D/7","doc":"Texturing allows elements of an image array to be read by shaders.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCompressedTexImage1D.xhtml)","ref":"gl.html#compressedTexImage1D/7"},{"type":"function","title":"gl.compressedTexImage2D/8","doc":"Texturing allows elements of an image array to be read by shaders.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCompressedTexImage2D.xhtml)","ref":"gl.html#compressedTexImage2D/8"},{"type":"function","title":"gl.compressedTexImage3D/9","doc":"Texturing allows elements of an image array to be read by shaders.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCompressedTexImage3D.xhtml)","ref":"gl.html#compressedTexImage3D/9"},{"type":"function","title":"gl.compressedTexSubImage1D/7","doc":"Equivalent to  compressedTextureSubImage1D/7 .","ref":"gl.html#compressedTexSubImage1D/7"},{"type":"function","title":"gl.compressedTexSubImage2D/9","doc":"Equivalent to  compressedTextureSubImage2D/9 .","ref":"gl.html#compressedTexSubImage2D/9"},{"type":"function","title":"gl.compressedTexSubImage3D/11","doc":"Equivalent to  compressedTextureSubImage3D/11 .","ref":"gl.html#compressedTexSubImage3D/11"},{"type":"function","title":"gl.compressedTextureSubImage1D/7","doc":"Texturing allows elements of an image array to be read by shaders.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCompressedTexSubImage1D.xhtml)","ref":"gl.html#compressedTextureSubImage1D/7"},{"type":"function","title":"gl.compressedTextureSubImage2D/9","doc":"Texturing allows elements of an image array to be read by shaders.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCompressedTexSubImage2D.xhtml)","ref":"gl.html#compressedTextureSubImage2D/9"},{"type":"function","title":"gl.compressedTextureSubImage3D/11","doc":"Texturing allows elements of an image array to be read by shaders.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCompressedTexSubImage3D.xhtml)","ref":"gl.html#compressedTextureSubImage3D/11"},{"type":"function","title":"gl.convolutionFilter1D/6","doc":"[`gl:convolutionFilter1D/6`](`convolutionFilter1D/6`) builds a one-dimensional\nconvolution filter kernel from an array of pixels.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glConvolutionFilter1D.xml)","ref":"gl.html#convolutionFilter1D/6"},{"type":"function","title":"gl.convolutionFilter2D/7","doc":"[`gl:convolutionFilter2D/7`](`convolutionFilter2D/7`) builds a two-dimensional\nconvolution filter kernel from an array of pixels.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glConvolutionFilter2D.xml)","ref":"gl.html#convolutionFilter2D/7"},{"type":"function","title":"gl.convolutionParameterf/3","doc":"Equivalent to  convolutionParameteriv/3 .","ref":"gl.html#convolutionParameterf/3"},{"type":"function","title":"gl.convolutionParameterfv/3","doc":"Equivalent to  convolutionParameteriv/3 .","ref":"gl.html#convolutionParameterfv/3"},{"type":"function","title":"gl.convolutionParameteri/3","doc":"Equivalent to  convolutionParameteriv/3 .","ref":"gl.html#convolutionParameteri/3"},{"type":"function","title":"gl.convolutionParameteriv/3","doc":"[`gl:convolutionParameter()`](`convolutionParameterf/3`) sets the value of a\nconvolution parameter.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glConvolutionParameter.xml)","ref":"gl.html#convolutionParameteriv/3"},{"type":"function","title":"gl.copyBufferSubData/5","doc":"[`gl:copyBufferSubData/5`](`copyBufferSubData/5`) and `glCopyNamedBufferSubData`\ncopy part of the data store attached to a source buffer object to the data store\nattached to a destination buffer object. The number of basic machine units\nindicated by `Size` is copied from the source at offset `ReadOffset` to the\ndestination at `WriteOffset`. `ReadOffset`, `WriteOffset` and `Size` are in\nterms of basic machine units.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCopyBufferSubData.xhtml)","ref":"gl.html#copyBufferSubData/5"},{"type":"function","title":"gl.copyColorSubTable/5","doc":"[`gl:copyColorSubTable/5`](`copyColorSubTable/5`) is used to respecify a\ncontiguous portion of a color table previously defined using\n[`gl:colorTable/6`](`colorTable/6`). The pixels copied from the framebuffer\nreplace the portion of the existing table from indices `Start` to start+x-1,\ninclusive. This region may not include any entries outside the range of the\ncolor table, as was originally specified. It is not an error to specify a\nsubtexture with width of 0, but such a specification has no effect.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glCopyColorSubTable.xml)","ref":"gl.html#copyColorSubTable/5"},{"type":"function","title":"gl.copyColorTable/5","doc":"[`gl:copyColorTable/5`](`copyColorTable/5`) loads a color table with pixels from\nthe current `?GL_READ_BUFFER` (rather than from main memory, as is the case for\n[`gl:colorTable/6`](`colorTable/6`)).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glCopyColorTable.xml)","ref":"gl.html#copyColorTable/5"},{"type":"function","title":"gl.copyConvolutionFilter1D/5","doc":"[`gl:copyConvolutionFilter1D/5`](`copyConvolutionFilter1D/5`) defines a\none-dimensional convolution filter kernel with pixels from the current\n`?GL_READ_BUFFER` (rather than from main memory, as is the case for\n[`gl:convolutionFilter1D/6`](`convolutionFilter1D/6`)).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glCopyConvolutionFilter1D.xml)","ref":"gl.html#copyConvolutionFilter1D/5"},{"type":"function","title":"gl.copyConvolutionFilter2D/6","doc":"[`gl:copyConvolutionFilter2D/6`](`copyConvolutionFilter2D/6`) defines a\ntwo-dimensional convolution filter kernel with pixels from the current\n`?GL_READ_BUFFER` (rather than from main memory, as is the case for\n[`gl:convolutionFilter2D/7`](`convolutionFilter2D/7`)).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glCopyConvolutionFilter2D.xml)","ref":"gl.html#copyConvolutionFilter2D/6"},{"type":"function","title":"gl.copyImageSubData/15","doc":"[`gl:copyImageSubData/15`](`copyImageSubData/15`) may be used to copy data from\none image (i.e. texture or renderbuffer) to another.\n[`gl:copyImageSubData/15`](`copyImageSubData/15`) does not perform\ngeneral-purpose conversions such as scaling, resizing, blending, color-space, or\nformat conversions. It should be considered to operate in a manner similar to a\nCPU memcpy. CopyImageSubData can copy between images with different internal\nformats, provided the formats are compatible.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCopyImageSubData.xhtml)","ref":"gl.html#copyImageSubData/15"},{"type":"function","title":"gl.copyPixels/5","doc":"[`gl:copyPixels/5`](`copyPixels/5`) copies a screen-aligned rectangle of pixels\nfrom the specified frame buffer location to a region relative to the current\nraster position. Its operation is well defined only if the entire pixel source\nregion is within the exposed portion of the window. Results of copies from\noutside the window, or from regions of the window that are not exposed, are\nhardware dependent and undefined.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glCopyPixels.xml)","ref":"gl.html#copyPixels/5"},{"type":"function","title":"gl.copyTexImage1D/7","doc":"[`gl:copyTexImage1D/7`](`copyTexImage1D/7`) defines a one-dimensional texture\nimage with pixels from the current `?GL_READ_BUFFER`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCopyTexImage1D.xhtml)","ref":"gl.html#copyTexImage1D/7"},{"type":"function","title":"gl.copyTexImage2D/8","doc":"[`gl:copyTexImage2D/8`](`copyTexImage2D/8`) defines a two-dimensional texture\nimage, or cube-map texture image with pixels from the current `?GL_READ_BUFFER`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCopyTexImage2D.xhtml)","ref":"gl.html#copyTexImage2D/8"},{"type":"function","title":"gl.copyTexSubImage1D/6","doc":"[`gl:copyTexSubImage1D/6`](`copyTexSubImage1D/6`) and `glCopyTextureSubImage1D`\nreplace a portion of a one-dimensional texture image with pixels from the\ncurrent `?GL_READ_BUFFER` (rather than from main memory, as is the case for\n[`gl:texSubImage1D/7`](`texSubImage1D/7`)). For\n[`gl:copyTexSubImage1D/6`](`copyTexSubImage1D/6`), the texture object that is\nbound to `Target` will be used for the process. For `glCopyTextureSubImage1D`,\n`Texture` tells which texture object should be used for the purpose of the call.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCopyTexSubImage1D.xhtml)","ref":"gl.html#copyTexSubImage1D/6"},{"type":"function","title":"gl.copyTexSubImage2D/8","doc":"[`gl:copyTexSubImage2D/8`](`copyTexSubImage2D/8`) and `glCopyTextureSubImage2D`\nreplace a rectangular portion of a two-dimensional texture image, cube-map\ntexture image, rectangular image, or a linear portion of a number of slices of a\none-dimensional array texture with pixels from the current `?GL_READ_BUFFER`\n(rather than from main memory, as is the case for\n[`gl:texSubImage2D/9`](`texSubImage2D/9`)).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCopyTexSubImage2D.xhtml)","ref":"gl.html#copyTexSubImage2D/8"},{"type":"function","title":"gl.copyTexSubImage3D/9","doc":"[`gl:copyTexSubImage3D/9`](`copyTexSubImage3D/9`) and `glCopyTextureSubImage3D`\nfunctions replace a rectangular portion of a three-dimensional or\ntwo-dimensional array texture image with pixels from the current\n`?GL_READ_BUFFER` (rather than from main memory, as is the case for\n[`gl:texSubImage3D/11`](`texSubImage3D/11`)).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCopyTexSubImage3D.xhtml)","ref":"gl.html#copyTexSubImage3D/9"},{"type":"function","title":"gl.createBuffers/1","doc":"[`gl:createBuffers/1`](`createBuffers/1`) returns `N` previously unused buffer\nnames in `Buffers`, each representing a new buffer object initialized as if it\nhad been bound to an unspecified target.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateBuffers.xhtml)","ref":"gl.html#createBuffers/1"},{"type":"function","title":"gl.createFramebuffers/1","doc":"[`gl:createFramebuffers/1`](`createFramebuffers/1`) returns `N` previously\nunused framebuffer names in `Framebuffers`, each representing a new framebuffer\nobject initialized to the default state.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateFramebuffers.xhtml)","ref":"gl.html#createFramebuffers/1"},{"type":"function","title":"gl.createProgram/0","doc":"[`gl:createProgram/0`](`createProgram/0`) creates an empty program object and\nreturns a non-zero value by which it can be referenced. A program object is an\nobject to which shader objects can be attached. This provides a mechanism to\nspecify the shader objects that will be linked to create a program. It also\nprovides a means for checking the compatibility of the shaders that will be used\nto create a program (for instance, checking the compatibility between a vertex\nshader and a fragment shader). When no longer needed as part of a program\nobject, shader objects can be detached.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateProgram.xhtml)","ref":"gl.html#createProgram/0"},{"type":"function","title":"gl.createProgramPipelines/1","doc":"[`gl:createProgramPipelines/1`](`createProgramPipelines/1`) returns `N`\npreviously unused program pipeline names in `Pipelines`, each representing a new\nprogram pipeline object initialized to the default state.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateProgramPipelines.xhtml)","ref":"gl.html#createProgramPipelines/1"},{"type":"function","title":"gl.createQueries/2","doc":"[`gl:createQueries/2`](`createQueries/2`) returns `N` previously unused query\nobject names in `Ids`, each representing a new query object with the specified\n`Target`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateQueries.xhtml)","ref":"gl.html#createQueries/2"},{"type":"function","title":"gl.createRenderbuffers/1","doc":"[`gl:createRenderbuffers/1`](`createRenderbuffers/1`) returns `N` previously\nunused renderbuffer object names in `Renderbuffers`, each representing a new\nrenderbuffer object initialized to the default state.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateRenderbuffers.xhtml)","ref":"gl.html#createRenderbuffers/1"},{"type":"function","title":"gl.createSamplers/1","doc":"[`gl:createSamplers/1`](`createSamplers/1`) returns `N` previously unused\nsampler names in `Samplers`, each representing a new sampler object initialized\nto the default state.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateSamplers.xhtml)","ref":"gl.html#createSamplers/1"},{"type":"function","title":"gl.createShader/1","doc":"[`gl:createShader/1`](`createShader/1`) creates an empty shader object and\nreturns a non-zero value by which it can be referenced. A shader object is used\nto maintain the source code strings that define a shader. `ShaderType` indicates\nthe type of shader to be created. Five types of shader are supported. A shader\nof type `?GL_COMPUTE_SHADER` is a shader that is intended to run on the\nprogrammable compute processor. A shader of type `?GL_VERTEX_SHADER` is a shader\nthat is intended to run on the programmable vertex processor. A shader of type\n`?GL_TESS_CONTROL_SHADER` is a shader that is intended to run on the\nprogrammable tessellation processor in the control stage. A shader of type\n`?GL_TESS_EVALUATION_SHADER` is a shader that is intended to run on the\nprogrammable tessellation processor in the evaluation stage. A shader of type\n`?GL_GEOMETRY_SHADER` is a shader that is intended to run on the programmable\ngeometry processor. A shader of type `?GL_FRAGMENT_SHADER` is a shader that is\nintended to run on the programmable fragment processor.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateShader.xhtml)","ref":"gl.html#createShader/1"},{"type":"function","title":"gl.createShaderProgramv/2","doc":"[`gl:createShaderProgram()`](`createShaderProgramv/2`) creates a program object\ncontaining compiled and linked shaders for a single stage specified by `Type`.\n`Strings` refers to an array of `Count` strings from which to create the shader\nexecutables.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateShaderProgram.xhtml)","ref":"gl.html#createShaderProgramv/2"},{"type":"function","title":"gl.createTextures/2","doc":"[`gl:createTextures/2`](`createTextures/2`) returns `N` previously unused\ntexture names in `Textures`, each representing a new texture object of the\ndimensionality and type specified by `Target` and initialized to the default\nvalues for that texture type.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateTextures.xhtml)","ref":"gl.html#createTextures/2"},{"type":"function","title":"gl.createTransformFeedbacks/1","doc":"[`gl:createTransformFeedbacks/1`](`createTransformFeedbacks/1`) returns `N`\npreviously unused transform feedback object names in `Ids`, each representing a\nnew transform feedback object initialized to the default state.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateTransformFeedbacks.xhtml)","ref":"gl.html#createTransformFeedbacks/1"},{"type":"function","title":"gl.createVertexArrays/1","doc":"[`gl:createVertexArrays/1`](`createVertexArrays/1`) returns `N` previously\nunused vertex array object names in `Arrays`, each representing a new vertex\narray object initialized to the default state.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateVertexArrays.xhtml)","ref":"gl.html#createVertexArrays/1"},{"type":"function","title":"gl.cullFace/1","doc":"[`gl:cullFace/1`](`cullFace/1`) specifies whether front- or back-facing facets\nare culled (as specified by `mode`) when facet culling is enabled. Facet culling\nis initially disabled. To enable and disable facet culling, call the\n[`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`) commands with the\nargument `?GL_CULL_FACE`. Facets include triangles, quadrilaterals, polygons,\nand rectangles.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCullFace.xhtml)","ref":"gl.html#cullFace/1"},{"type":"function","title":"gl.debugMessageControl/5","doc":"[`gl:debugMessageControl/5`](`debugMessageControl/5`) controls the reporting of\ndebug messages generated by a debug context. The parameters `Source`, `Type` and\n`Severity` form a filter to select messages from the pool of potential messages\ngenerated by the GL.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDebugMessageControl.xhtml)","ref":"gl.html#debugMessageControl/5"},{"type":"function","title":"gl.debugMessageInsert/5","doc":"[`gl:debugMessageInsert/5`](`debugMessageInsert/5`) inserts a user-supplied\nmessage into the debug output queue. `Source` specifies the source that will be\nused to classify the message and must be `?GL_DEBUG_SOURCE_APPLICATION` or\n`?GL_DEBUG_SOURCE_THIRD_PARTY`. All other sources are reserved for use by the GL\nimplementation. `Type` indicates the type of the message to be inserted and may\nbe one of `?GL_DEBUG_TYPE_ERROR`, `?GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR`,\n`?GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR`, `?GL_DEBUG_TYPE_PORTABILITY`,\n`?GL_DEBUG_TYPE_PERFORMANCE`, `?GL_DEBUG_TYPE_MARKER`,\n`?GL_DEBUG_TYPE_PUSH_GROUP`, `?GL_DEBUG_TYPE_POP_GROUP`, or\n`?GL_DEBUG_TYPE_OTHER`. `Severity` indicates the severity of the message and may\nbe `?GL_DEBUG_SEVERITY_LOW`, `?GL_DEBUG_SEVERITY_MEDIUM`,\n`?GL_DEBUG_SEVERITY_HIGH` or `?GL_DEBUG_SEVERITY_NOTIFICATION`. `Id` is\navailable for application defined use and may be any value. This value will be\nrecorded and used to identify the message.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDebugMessageInsert.xhtml)","ref":"gl.html#debugMessageInsert/5"},{"type":"function","title":"gl.deleteBuffers/1","doc":"[`gl:deleteBuffers/1`](`deleteBuffers/1`) deletes `N` buffer objects named by\nthe elements of the array `Buffers`. After a buffer object is deleted, it has no\ncontents, and its name is free for reuse (for example by\n[`gl:genBuffers/1`](`genBuffers/1`)). If a buffer object that is currently bound\nis deleted, the binding reverts to 0 (the absence of any buffer object).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteBuffers.xhtml)","ref":"gl.html#deleteBuffers/1"},{"type":"function","title":"gl.deleteFramebuffers/1","doc":"[`gl:deleteFramebuffers/1`](`deleteFramebuffers/1`) deletes the `N` framebuffer\nobjects whose names are stored in the array addressed by `Framebuffers`. The\nname zero is reserved by the GL and is silently ignored, should it occur in\n`Framebuffers`, as are other unused names. Once a framebuffer object is deleted,\nits name is again unused and it has no attachments. If a framebuffer that is\ncurrently bound to one or more of the targets `?GL_DRAW_FRAMEBUFFER` or\n`?GL_READ_FRAMEBUFFER` is deleted, it is as though\n[`gl:bindFramebuffer/2`](`bindFramebuffer/2`) had been executed with the\ncorresponding `Target` and `Framebuffer` zero.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteFramebuffers.xhtml)","ref":"gl.html#deleteFramebuffers/1"},{"type":"function","title":"gl.deleteLists/2","doc":"[`gl:deleteLists/2`](`deleteLists/2`) causes a contiguous group of display lists\nto be deleted. `List` is the name of the first display list to be deleted, and\n`Range` is the number of display lists to delete. All display lists d with\nlist&lt;= d&lt;= list+range-1 are deleted.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glDeleteLists.xml)","ref":"gl.html#deleteLists/2"},{"type":"function","title":"gl.deleteProgram/1","doc":"[`gl:deleteProgram/1`](`deleteProgram/1`) frees the memory and invalidates the\nname associated with the program object specified by `Program.` This command\neffectively undoes the effects of a call to\n[`gl:createProgram/0`](`createProgram/0`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteProgram.xhtml)","ref":"gl.html#deleteProgram/1"},{"type":"function","title":"gl.deleteProgramPipelines/1","doc":"[`gl:deleteProgramPipelines/1`](`deleteProgramPipelines/1`) deletes the `N`\nprogram pipeline objects whose names are stored in the array `Pipelines`. Unused\nnames in `Pipelines` are ignored, as is the name zero. After a program pipeline\nobject is deleted, its name is again unused and it has no contents. If program\npipeline object that is currently bound is deleted, the binding for that object\nreverts to zero and no program pipeline object becomes current.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteProgramPipelines.xhtml)","ref":"gl.html#deleteProgramPipelines/1"},{"type":"function","title":"gl.deleteQueries/1","doc":"[`gl:deleteQueries/1`](`deleteQueries/1`) deletes `N` query objects named by the\nelements of the array `Ids`. After a query object is deleted, it has no\ncontents, and its name is free for reuse (for example by\n[`gl:genQueries/1`](`genQueries/1`)).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteQueries.xhtml)","ref":"gl.html#deleteQueries/1"},{"type":"function","title":"gl.deleteRenderbuffers/1","doc":"[`gl:deleteRenderbuffers/1`](`deleteRenderbuffers/1`) deletes the `N`\nrenderbuffer objects whose names are stored in the array addressed by\n`Renderbuffers`. The name zero is reserved by the GL and is silently ignored,\nshould it occur in `Renderbuffers`, as are other unused names. Once a\nrenderbuffer object is deleted, its name is again unused and it has no contents.\nIf a renderbuffer that is currently bound to the target `?GL_RENDERBUFFER` is\ndeleted, it is as though [`gl:bindRenderbuffer/2`](`bindRenderbuffer/2`) had\nbeen executed with a `Target` of `?GL_RENDERBUFFER` and a `Name` of zero.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteRenderbuffers.xhtml)","ref":"gl.html#deleteRenderbuffers/1"},{"type":"function","title":"gl.deleteSamplers/1","doc":"[`gl:deleteSamplers/1`](`deleteSamplers/1`) deletes `N` sampler objects named by\nthe elements of the array `Samplers`. After a sampler object is deleted, its\nname is again unused. If a sampler object that is currently bound to a sampler\nunit is deleted, it is as though [`gl:bindSampler/2`](`bindSampler/2`) is called\nwith unit set to the unit the sampler is bound to and sampler zero. Unused names\nin samplers are silently ignored, as is the reserved name zero.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteSamplers.xhtml)","ref":"gl.html#deleteSamplers/1"},{"type":"function","title":"gl.deleteShader/1","doc":"[`gl:deleteShader/1`](`deleteShader/1`) frees the memory and invalidates the\nname associated with the shader object specified by `Shader`. This command\neffectively undoes the effects of a call to\n[`gl:createShader/1`](`createShader/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteShader.xhtml)","ref":"gl.html#deleteShader/1"},{"type":"function","title":"gl.deleteSync/1","doc":"[`gl:deleteSync/1`](`deleteSync/1`) deletes the sync object specified by `Sync`.\nIf the fence command corresponding to the specified sync object has completed,\nor if no [`gl:waitSync/3`](`waitSync/3`) or\n[`gl:clientWaitSync/3`](`clientWaitSync/3`) commands are blocking on `Sync`, the\nobject is deleted immediately. Otherwise, `Sync` is flagged for deletion and\nwill be deleted when it is no longer associated with any fence command and is no\nlonger blocking any [`gl:waitSync/3`](`waitSync/3`) or\n[`gl:clientWaitSync/3`](`clientWaitSync/3`) command. In either case, after\n[`gl:deleteSync/1`](`deleteSync/1`) returns, the name `Sync` is invalid and can\nno longer be used to refer to the sync object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteSync.xhtml)","ref":"gl.html#deleteSync/1"},{"type":"function","title":"gl.deleteTextures/1","doc":"[`gl:deleteTextures/1`](`deleteTextures/1`) deletes `N` textures named by the\nelements of the array `Textures`. After a texture is deleted, it has no contents\nor dimensionality, and its name is free for reuse (for example by\n[`gl:genTextures/1`](`genTextures/1`)). If a texture that is currently bound is\ndeleted, the binding reverts to 0 (the default texture).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteTextures.xhtml)","ref":"gl.html#deleteTextures/1"},{"type":"function","title":"gl.deleteTransformFeedbacks/1","doc":"[`gl:deleteTransformFeedbacks/1`](`deleteTransformFeedbacks/1`) deletes the `N`\ntransform feedback objects whose names are stored in the array `Ids`. Unused\nnames in `Ids` are ignored, as is the name zero. After a transform feedback\nobject is deleted, its name is again unused and it has no contents. If an active\ntransform feedback object is deleted, its name immediately becomes unused, but\nthe underlying object is not deleted until it is no longer active.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteTransformFeedbacks.xhtml)","ref":"gl.html#deleteTransformFeedbacks/1"},{"type":"function","title":"gl.deleteVertexArrays/1","doc":"[`gl:deleteVertexArrays/1`](`deleteVertexArrays/1`) deletes `N` vertex array\nobjects whose names are stored in the array addressed by `Arrays`. Once a vertex\narray object is deleted it has no contents and its name is again unused. If a\nvertex array object that is currently bound is deleted, the binding for that\nobject reverts to zero and the default vertex array becomes current. Unused\nnames in `Arrays` are silently ignored, as is the value zero.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteVertexArrays.xhtml)","ref":"gl.html#deleteVertexArrays/1"},{"type":"function","title":"gl.depthFunc/1","doc":"[`gl:depthFunc/1`](`depthFunc/1`) specifies the function used to compare each\nincoming pixel depth value with the depth value present in the depth buffer. The\ncomparison is performed only if depth testing is enabled. (See\n[`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`) of\n`?GL_DEPTH_TEST`.)\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDepthFunc.xhtml)","ref":"gl.html#depthFunc/1"},{"type":"function","title":"gl.depthMask/1","doc":"[`gl:depthMask/1`](`depthMask/1`) specifies whether the depth buffer is enabled\nfor writing. If `Flag` is `?GL_FALSE`, depth buffer writing is disabled.\nOtherwise, it is enabled. Initially, depth buffer writing is enabled.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDepthMask.xhtml)","ref":"gl.html#depthMask/1"},{"type":"function","title":"gl.depthRange/2","doc":"Equivalent to  depthRangef/2 .","ref":"gl.html#depthRange/2"},{"type":"function","title":"gl.depthRangeArrayv/2","doc":"After clipping and division by `w`, depth coordinates range from -1 to 1,\ncorresponding to the near and far clipping planes. Each viewport has an\nindependent depth range specified as a linear mapping of the normalized depth\ncoordinates in this range to window depth coordinates. Regardless of the actual\ndepth buffer implementation, window coordinate depth values are treated as\nthough they range from 0 through 1 (like color components).\n[`gl:depthRangeArray()`](`depthRangeArrayv/2`) specifies a linear mapping of the\nnormalized depth coordinates in this range to window depth coordinates for each\nviewport in the range [`First`, `First` \\+ `Count`). Thus, the values accepted\nby [`gl:depthRangeArray()`](`depthRangeArrayv/2`) are both clamped to this range\nbefore they are accepted.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDepthRangeArray.xhtml)","ref":"gl.html#depthRangeArrayv/2"},{"type":"function","title":"gl.depthRangef/2","doc":"After clipping and division by `w`, depth coordinates range from -1 to 1,\ncorresponding to the near and far clipping planes.\n[`gl:depthRange/2`](`depthRange/2`) specifies a linear mapping of the normalized\ndepth coordinates in this range to window depth coordinates. Regardless of the\nactual depth buffer implementation, window coordinate depth values are treated\nas though they range from 0 through 1 (like color components). Thus, the values\naccepted by [`gl:depthRange/2`](`depthRange/2`) are both clamped to this range\nbefore they are accepted.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDepthRange.xhtml)","ref":"gl.html#depthRangef/2"},{"type":"function","title":"gl.depthRangeIndexed/3","doc":"After clipping and division by `w`, depth coordinates range from -1 to 1,\ncorresponding to the near and far clipping planes. Each viewport has an\nindependent depth range specified as a linear mapping of the normalized depth\ncoordinates in this range to window depth coordinates. Regardless of the actual\ndepth buffer implementation, window coordinate depth values are treated as\nthough they range from 0 through 1 (like color components).\n[`gl:depthRangeIndexed/3`](`depthRangeIndexed/3`) specifies a linear mapping of\nthe normalized depth coordinates in this range to window depth coordinates for a\nspecified viewport. Thus, the values accepted by\n[`gl:depthRangeIndexed/3`](`depthRangeIndexed/3`) are both clamped to this range\nbefore they are accepted.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDepthRangeIndexed.xhtml)","ref":"gl.html#depthRangeIndexed/3"},{"type":"function","title":"gl.detachShader/2","doc":"[`gl:detachShader/2`](`detachShader/2`) detaches the shader object specified by\n`Shader` from the program object specified by `Program`. This command can be\nused to undo the effect of the command [`gl:attachShader/2`](`attachShader/2`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDetachShader.xhtml)","ref":"gl.html#detachShader/2"},{"type":"function","title":"gl.disable/1","doc":"Equivalent to  enablei/2 .","ref":"gl.html#disable/1"},{"type":"function","title":"gl.disableClientState/1","doc":"Equivalent to  enableClientState/1 .","ref":"gl.html#disableClientState/1"},{"type":"function","title":"gl.disablei/2","doc":"Equivalent to  enablei/2 .","ref":"gl.html#disablei/2"},{"type":"function","title":"gl.disableVertexArrayAttrib/2","doc":"Equivalent to  enableVertexAttribArray/1 .","ref":"gl.html#disableVertexArrayAttrib/2"},{"type":"function","title":"gl.disableVertexAttribArray/1","doc":"Equivalent to  enableVertexAttribArray/1 .","ref":"gl.html#disableVertexAttribArray/1"},{"type":"function","title":"gl.dispatchCompute/3","doc":"[`gl:dispatchCompute/3`](`dispatchCompute/3`) launches one or more compute work\ngroups. Each work group is processed by the active program object for the\ncompute shader stage. While the individual shader invocations within a work\ngroup are executed as a unit, work groups are executed completely independently\nand in unspecified order. `Num_groups_x`, `Num_groups_y` and `Num_groups_z`\nspecify the number of local work groups that will be dispatched in the X, Y and\nZ dimensions, respectively.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDispatchCompute.xhtml)","ref":"gl.html#dispatchCompute/3"},{"type":"function","title":"gl.dispatchComputeIndirect/1","doc":"[`gl:dispatchComputeIndirect/1`](`dispatchComputeIndirect/1`) launches one or\nmore compute work groups using parameters stored in the buffer object currently\nbound to the `?GL_DISPATCH_INDIRECT_BUFFER` target. Each work group is processed\nby the active program object for the compute shader stage. While the individual\nshader invocations within a work group are executed as a unit, work groups are\nexecuted completely independently and in unspecified order. `Indirect` contains\nthe offset into the data store of the buffer object bound to the\n`?GL_DISPATCH_INDIRECT_BUFFER` target at which the parameters are stored.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDispatchComputeIndirect.xhtml)","ref":"gl.html#dispatchComputeIndirect/1"},{"type":"function","title":"gl.drawArrays/3","doc":"[`gl:drawArrays/3`](`drawArrays/3`) specifies multiple geometric primitives with\nvery few subroutine calls. Instead of calling a GL procedure to pass each\nindividual vertex, normal, texture coordinate, edge flag, or color, you can\nprespecify separate arrays of vertices, normals, and colors and use them to\nconstruct a sequence of primitives with a single call to\n[`gl:drawArrays/3`](`drawArrays/3`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawArrays.xhtml)","ref":"gl.html#drawArrays/3"},{"type":"function","title":"gl.drawArraysIndirect/2","doc":"[`gl:drawArraysIndirect/2`](`drawArraysIndirect/2`) specifies multiple geometric\nprimitives with very few subroutine calls.\n[`gl:drawArraysIndirect/2`](`drawArraysIndirect/2`) behaves similarly to\n[`gl:drawArraysInstancedBaseInstance/5`](`drawArraysInstancedBaseInstance/5`),\nexecept that the parameters to\n[`gl:drawArraysInstancedBaseInstance/5`](`drawArraysInstancedBaseInstance/5`)\nare stored in memory at the address given by `Indirect`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawArraysIndirect.xhtml)","ref":"gl.html#drawArraysIndirect/2"},{"type":"function","title":"gl.drawArraysInstanced/4","doc":"[`gl:drawArraysInstanced/4`](`drawArraysInstanced/4`) behaves identically to\n[`gl:drawArrays/3`](`drawArrays/3`) except that `Instancecount` instances of the\nrange of elements are executed and the value of the internal counter\n`InstanceID` advances for each iteration. `InstanceID` is an internal 32-bit\ninteger counter that may be read by a vertex shader as `?gl_InstanceID`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawArraysInstanced.xhtml)","ref":"gl.html#drawArraysInstanced/4"},{"type":"function","title":"gl.drawArraysInstancedBaseInstance/5","doc":"[`gl:drawArraysInstancedBaseInstance/5`](`drawArraysInstancedBaseInstance/5`)\nbehaves identically to [`gl:drawArrays/3`](`drawArrays/3`) except that\n`Instancecount` instances of the range of elements are executed and the value of\nthe internal counter `InstanceID` advances for each iteration. `InstanceID` is\nan internal 32-bit integer counter that may be read by a vertex shader as\n`?gl_InstanceID`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawArraysInstancedBaseInstance.xhtml)","ref":"gl.html#drawArraysInstancedBaseInstance/5"},{"type":"function","title":"gl.drawBuffer/1","doc":"When colors are written to the frame buffer, they are written into the color\nbuffers specified by [`gl:drawBuffer/1`](`drawBuffer/1`). One of the following\nvalues can be used for default framebuffer:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawBuffer.xhtml)","ref":"gl.html#drawBuffer/1"},{"type":"function","title":"gl.drawBuffers/1","doc":"[`gl:drawBuffers/1`](`drawBuffers/1`) and `glNamedFramebufferDrawBuffers` define\nan array of buffers into which outputs from the fragment shader data will be\nwritten. If a fragment shader writes a value to one or more user defined output\nvariables, then the value of each variable will be written into the buffer\nspecified at a location within `Bufs` corresponding to the location assigned to\nthat user defined output. The draw buffer used for user defined outputs assigned\nto locations greater than or equal to `N` is implicitly set to `?GL_NONE` and\nany data written to such an output is discarded.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawBuffers.xhtml)","ref":"gl.html#drawBuffers/1"},{"type":"function","title":"gl.drawElements/4","doc":"[`gl:drawElements/4`](`drawElements/4`) specifies multiple geometric primitives\nwith very few subroutine calls. Instead of calling a GL function to pass each\nindividual vertex, normal, texture coordinate, edge flag, or color, you can\nprespecify separate arrays of vertices, normals, and so on, and use them to\nconstruct a sequence of primitives with a single call to\n[`gl:drawElements/4`](`drawElements/4`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawElements.xhtml)","ref":"gl.html#drawElements/4"},{"type":"function","title":"gl.drawElementsBaseVertex/5","doc":"[`gl:drawElementsBaseVertex/5`](`drawElementsBaseVertex/5`) behaves identically\nto [`gl:drawElements/4`](`drawElements/4`) except that the `i`th element\ntransferred by the corresponding draw call will be taken from element\n`Indices`\\[i] + `Basevertex` of each enabled array. If the resulting value is\nlarger than the maximum value representable by `Type`, it is as if the\ncalculation were upconverted to 32-bit unsigned integers (with wrapping on\noverflow conditions). The operation is undefined if the sum would be negative.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawElementsBaseVertex.xhtml)","ref":"gl.html#drawElementsBaseVertex/5"},{"type":"function","title":"gl.drawElementsIndirect/3","doc":"[`gl:drawElementsIndirect/3`](`drawElementsIndirect/3`) specifies multiple\nindexed geometric primitives with very few subroutine calls.\n[`gl:drawElementsIndirect/3`](`drawElementsIndirect/3`) behaves similarly to\n[`gl:drawElementsInstancedBaseVertexBaseInstance/7`](`drawElementsInstancedBaseVertexBaseInstance/7`),\nexecpt that the parameters to\n[`gl:drawElementsInstancedBaseVertexBaseInstance/7`](`drawElementsInstancedBaseVertexBaseInstance/7`)\nare stored in memory at the address given by `Indirect`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawElementsIndirect.xhtml)","ref":"gl.html#drawElementsIndirect/3"},{"type":"function","title":"gl.drawElementsInstanced/5","doc":"[`gl:drawElementsInstanced/5`](`drawElementsInstanced/5`) behaves identically to\n[`gl:drawElements/4`](`drawElements/4`) except that `Instancecount` instances of\nthe set of elements are executed and the value of the internal counter\n`InstanceID` advances for each iteration. `InstanceID` is an internal 32-bit\ninteger counter that may be read by a vertex shader as `?gl_InstanceID`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawElementsInstanced.xhtml)","ref":"gl.html#drawElementsInstanced/5"},{"type":"function","title":"gl.drawElementsInstancedBaseInstance/6","doc":"[`gl:drawElementsInstancedBaseInstance/6`](`drawElementsInstancedBaseInstance/6`)\nbehaves identically to [`gl:drawElements/4`](`drawElements/4`) except that\n`Instancecount` instances of the set of elements are executed and the value of\nthe internal counter `InstanceID` advances for each iteration. `InstanceID` is\nan internal 32-bit integer counter that may be read by a vertex shader as\n`?gl_InstanceID`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawElementsInstancedBaseInstance.xhtml)","ref":"gl.html#drawElementsInstancedBaseInstance/6"},{"type":"function","title":"gl.drawElementsInstancedBaseVertex/6","doc":"[`gl:drawElementsInstancedBaseVertex/6`](`drawElementsInstancedBaseVertex/6`)\nbehaves identically to [`gl:drawElementsInstanced/5`](`drawElementsInstanced/5`)\nexcept that the `i`th element transferred by the corresponding draw call will be\ntaken from element `Indices`\\[i] + `Basevertex` of each enabled array. If the\nresulting value is larger than the maximum value representable by `Type`, it is\nas if the calculation were upconverted to 32-bit unsigned integers (with\nwrapping on overflow conditions). The operation is undefined if the sum would be\nnegative.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawElementsInstancedBaseVertex.xhtml)","ref":"gl.html#drawElementsInstancedBaseVertex/6"},{"type":"function","title":"gl.drawElementsInstancedBaseVertexBaseInstance/7","doc":"[`gl:drawElementsInstancedBaseVertexBaseInstance/7`](`drawElementsInstancedBaseVertexBaseInstance/7`)\nbehaves identically to [`gl:drawElementsInstanced/5`](`drawElementsInstanced/5`)\nexcept that the `i`th element transferred by the corresponding draw call will be\ntaken from element `Indices`\\[i] + `Basevertex` of each enabled array. If the\nresulting value is larger than the maximum value representable by `Type`, it is\nas if the calculation were upconverted to 32-bit unsigned integers (with\nwrapping on overflow conditions). The operation is undefined if the sum would be\nnegative.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawElementsInstancedBaseVertexBaseInstance.xhtml)","ref":"gl.html#drawElementsInstancedBaseVertexBaseInstance/7"},{"type":"function","title":"gl.drawPixels/5","doc":"[`gl:drawPixels/5`](`drawPixels/5`) reads pixel data from memory and writes it\ninto the frame buffer relative to the current raster position, provided that the\nraster position is valid. Use [`gl:rasterPos()`](`rasterPos2d/2`) or\n[`gl:windowPos()`](`windowPos2d/2`) to set the current raster position; use\n[`gl:get()`](`getBooleanv/1`) with argument `?GL_CURRENT_RASTER_POSITION_VALID`\nto determine if the specified raster position is valid, and\n[`gl:get()`](`getBooleanv/1`) with argument `?GL_CURRENT_RASTER_POSITION` to\nquery the raster position.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glDrawPixels.xml)","ref":"gl.html#drawPixels/5"},{"type":"function","title":"gl.drawRangeElements/6","doc":"[`gl:drawRangeElements/6`](`drawRangeElements/6`) is a restricted form of\n[`gl:drawElements/4`](`drawElements/4`). `Mode`, and `Count` match the\ncorresponding arguments to [`gl:drawElements/4`](`drawElements/4`), with the\nadditional constraint that all values in the arrays `Count` must lie between\n`Start` and `End`, inclusive.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawRangeElements.xhtml)","ref":"gl.html#drawRangeElements/6"},{"type":"function","title":"gl.drawRangeElementsBaseVertex/7","doc":"[`gl:drawRangeElementsBaseVertex/7`](`drawRangeElementsBaseVertex/7`) is a\nrestricted form of [`gl:drawElementsBaseVertex/5`](`drawElementsBaseVertex/5`).\n`Mode`, `Count` and `Basevertex` match the corresponding arguments to\n[`gl:drawElementsBaseVertex/5`](`drawElementsBaseVertex/5`), with the additional\nconstraint that all values in the array `Indices` must lie between `Start` and\n`End`, inclusive, prior to adding `Basevertex`. Index values lying outside the\nrange [`Start`, `End`] are treated in the same way as\n[`gl:drawElementsBaseVertex/5`](`drawElementsBaseVertex/5`). The `i`th element\ntransferred by the corresponding draw call will be taken from element\n`Indices`\\[i] + `Basevertex` of each enabled array. If the resulting value is\nlarger than the maximum value representable by `Type`, it is as if the\ncalculation were upconverted to 32-bit unsigned integers (with wrapping on\noverflow conditions). The operation is undefined if the sum would be negative.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawRangeElementsBaseVertex.xhtml)","ref":"gl.html#drawRangeElementsBaseVertex/7"},{"type":"function","title":"gl.drawTransformFeedback/2","doc":"[`gl:drawTransformFeedback/2`](`drawTransformFeedback/2`) draws primitives of a\ntype specified by `Mode` using a count retrieved from the transform feedback\nspecified by `Id`. Calling\n[`gl:drawTransformFeedback/2`](`drawTransformFeedback/2`) is equivalent to\ncalling [`gl:drawArrays/3`](`drawArrays/3`) with `Mode` as specified, `First`\nset to zero, and `Count` set to the number of vertices captured on vertex stream\nzero the last time transform feedback was active on the transform feedback\nobject named by `Id`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawTransformFeedback.xhtml)","ref":"gl.html#drawTransformFeedback/2"},{"type":"function","title":"gl.drawTransformFeedbackInstanced/3","doc":"[`gl:drawTransformFeedbackInstanced/3`](`drawTransformFeedbackInstanced/3`)\ndraws multiple copies of a range of primitives of a type specified by `Mode`\nusing a count retrieved from the transform feedback stream specified by `Stream`\nof the transform feedback object specified by `Id`. Calling\n[`gl:drawTransformFeedbackInstanced/3`](`drawTransformFeedbackInstanced/3`) is\nequivalent to calling [`gl:drawArraysInstanced/4`](`drawArraysInstanced/4`) with\n`Mode` and `Instancecount` as specified, `First` set to zero, and `Count` set to\nthe number of vertices captured on vertex stream zero the last time transform\nfeedback was active on the transform feedback object named by `Id`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawTransformFeedbackInstanced.xhtml)","ref":"gl.html#drawTransformFeedbackInstanced/3"},{"type":"function","title":"gl.drawTransformFeedbackStream/3","doc":"[`gl:drawTransformFeedbackStream/3`](`drawTransformFeedbackStream/3`) draws\nprimitives of a type specified by `Mode` using a count retrieved from the\ntransform feedback stream specified by `Stream` of the transform feedback object\nspecified by `Id`. Calling\n[`gl:drawTransformFeedbackStream/3`](`drawTransformFeedbackStream/3`) is\nequivalent to calling [`gl:drawArrays/3`](`drawArrays/3`) with `Mode` as\nspecified, `First` set to zero, and `Count` set to the number of vertices\ncaptured on vertex stream `Stream` the last time transform feedback was active\non the transform feedback object named by `Id`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawTransformFeedbackStream.xhtml)","ref":"gl.html#drawTransformFeedbackStream/3"},{"type":"function","title":"gl.drawTransformFeedbackStreamInstanced/4","doc":"[`gl:drawTransformFeedbackStreamInstanced/4`](`drawTransformFeedbackStreamInstanced/4`)\ndraws multiple copies of a range of primitives of a type specified by `Mode`\nusing a count retrieved from the transform feedback stream specified by `Stream`\nof the transform feedback object specified by `Id`. Calling\n[`gl:drawTransformFeedbackStreamInstanced/4`](`drawTransformFeedbackStreamInstanced/4`)\nis equivalent to calling [`gl:drawArraysInstanced/4`](`drawArraysInstanced/4`)\nwith `Mode` and `Instancecount` as specified, `First` set to zero, and `Count`\nset to the number of vertices captured on vertex stream `Stream` the last time\ntransform feedback was active on the transform feedback object named by `Id`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawTransformFeedbackStreamInstanced.xhtml)","ref":"gl.html#drawTransformFeedbackStreamInstanced/4"},{"type":"function","title":"gl.edgeFlag/1","doc":"Equivalent to  edgeFlagv/1 .","ref":"gl.html#edgeFlag/1"},{"type":"function","title":"gl.edgeFlagPointer/2","doc":"[`gl:edgeFlagPointer/2`](`edgeFlagPointer/2`) specifies the location and data\nformat of an array of boolean edge flags to use when rendering. `Stride`\nspecifies the byte stride from one edge flag to the next, allowing vertices and\nattributes to be packed into a single array or stored in separate arrays.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glEdgeFlagPointer.xml)","ref":"gl.html#edgeFlagPointer/2"},{"type":"function","title":"gl.edgeFlagv/1","doc":"Each vertex of a polygon, separate triangle, or separate quadrilateral specified\nbetween a [`gl:'begin'/1`](`'begin'/1`)/[`gl:'end'/0`](`'begin'/1`) pair is\nmarked as the start of either a boundary or nonboundary edge. If the current\nedge flag is true when the vertex is specified, the vertex is marked as the\nstart of a boundary edge. Otherwise, the vertex is marked as the start of a\nnonboundary edge. [`gl:edgeFlag/1`](`edgeFlag/1`) sets the edge flag bit to\n`?GL_TRUE` if `Flag` is `?GL_TRUE` and to `?GL_FALSE` otherwise.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glEdgeFlag.xml)","ref":"gl.html#edgeFlagv/1"},{"type":"function","title":"gl.enable/1","doc":"Equivalent to  enablei/2 .","ref":"gl.html#enable/1"},{"type":"function","title":"gl.enableClientState/1","doc":"[`gl:enableClientState/1`](`enableClientState/1`) and\n[`gl:disableClientState/1`](`enableClientState/1`) enable or disable individual\nclient-side capabilities. By default, all client-side capabilities are disabled.\nBoth [`gl:enableClientState/1`](`enableClientState/1`) and\n[`gl:disableClientState/1`](`enableClientState/1`) take a single argument,\n`Cap`, which can assume one of the following values:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glEnableClientState.xml)","ref":"gl.html#enableClientState/1"},{"type":"function","title":"gl.enablei/2","doc":"[`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`) enable and disable\nvarious capabilities. Use [`gl:isEnabled/1`](`isEnabled/1`) or\n[`gl:get()`](`getBooleanv/1`) to determine the current setting of any\ncapability. The initial value for each capability with the exception of\n`?GL_DITHER` and `?GL_MULTISAMPLE` is `?GL_FALSE`. The initial value for\n`?GL_DITHER` and `?GL_MULTISAMPLE` is `?GL_TRUE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glEnable.xhtml)","ref":"gl.html#enablei/2"},{"type":"function","title":"gl.enableVertexArrayAttrib/2","doc":"Equivalent to  enableVertexAttribArray/1 .","ref":"gl.html#enableVertexArrayAttrib/2"},{"type":"function","title":"gl.enableVertexAttribArray/1","doc":"[`gl:enableVertexAttribArray/1`](`enableVertexAttribArray/1`) and\n[`gl:enableVertexArrayAttrib/2`](`disableVertexAttribArray/1`) enable the\ngeneric vertex attribute array specified by `Index`.\n[`gl:enableVertexAttribArray/1`](`enableVertexAttribArray/1`) uses currently\nbound vertex array object for the operation, whereas\n[`gl:enableVertexArrayAttrib/2`](`disableVertexAttribArray/1`) updates state of\nthe vertex array object with ID `Vaobj`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glEnableVertexAttribArray.xhtml)","ref":"gl.html#enableVertexAttribArray/1"},{"type":"function","title":"gl.end/0","doc":"[`gl:'begin'/1`](`'begin'/1`) and [`gl:'end'/0`](`'begin'/1`) delimit the\nvertices that define a primitive or a group of like primitives.\n[`gl:'begin'/1`](`'begin'/1`) accepts a single argument that specifies in which\nof ten ways the vertices are interpreted. Taking n as an integer count starting\nat one, and N as the total number of vertices specified, the interpretations are\nas follows:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glBegin.xml)","ref":"gl.html#end/0"},{"type":"function","title":"gl.endConditionalRender/0","doc":"Conditional rendering is started using\n[`gl:beginConditionalRender/2`](`beginConditionalRender/2`) and ended using\n[`gl:endConditionalRender/0`](`beginConditionalRender/2`). During conditional\nrendering, all vertex array commands, as well as [`gl:clear/1`](`clear/1`) and\n[`gl:clearBuffer()`](`clearBufferiv/3`) have no effect if the\n(`?GL_SAMPLES_PASSED`) result of the query object `Id` is zero, or if the\n(`?GL_ANY_SAMPLES_PASSED`) result is `?GL_FALSE`. The results of commands\nsetting the current vertex state, such as\n[`gl:vertexAttrib()`](`vertexAttrib1d/2`) are undefined. If the\n(`?GL_SAMPLES_PASSED`) result is non-zero or if the (`?GL_ANY_SAMPLES_PASSED`)\nresult is `?GL_TRUE`, such commands are not discarded. The `Id` parameter to\n[`gl:beginConditionalRender/2`](`beginConditionalRender/2`) must be the name of\na query object previously returned from a call to\n[`gl:genQueries/1`](`genQueries/1`). `Mode` specifies how the results of the\nquery object are to be interpreted. If `Mode` is `?GL_QUERY_WAIT`, the GL waits\nfor the results of the query to be available and then uses the results to\ndetermine if subsequent rendering commands are discarded. If `Mode` is\n`?GL_QUERY_NO_WAIT`, the GL may choose to unconditionally execute the subsequent\nrendering commands without waiting for the query to complete.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBeginConditionalRender.xhtml)","ref":"gl.html#endConditionalRender/0"},{"type":"function","title":"gl.endList/0","doc":"Equivalent to  newList/2 .","ref":"gl.html#endList/0"},{"type":"function","title":"gl.endQuery/1","doc":"[`gl:beginQuery/2`](`beginQuery/2`) and [`gl:endQuery/1`](`beginQuery/2`)\ndelimit the boundaries of a query object. `Query` must be a name previously\nreturned from a call to [`gl:genQueries/1`](`genQueries/1`). If a query object\nwith name `Id` does not yet exist it is created with the type determined by\n`Target`. `Target` must be one of `?GL_SAMPLES_PASSED`,\n`?GL_ANY_SAMPLES_PASSED`, `?GL_PRIMITIVES_GENERATED`,\n`?GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN`, or `?GL_TIME_ELAPSED`. The behavior\nof the query object depends on its type and is as follows.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBeginQuery.xhtml)","ref":"gl.html#endQuery/1"},{"type":"function","title":"gl.endQueryIndexed/2","doc":"[`gl:beginQueryIndexed/3`](`beginQueryIndexed/3`) and\n[`gl:endQueryIndexed/2`](`beginQueryIndexed/3`) delimit the boundaries of a\nquery object. `Query` must be a name previously returned from a call to\n[`gl:genQueries/1`](`genQueries/1`). If a query object with name `Id` does not\nyet exist it is created with the type determined by `Target`. `Target` must be\none of `?GL_SAMPLES_PASSED`, `?GL_ANY_SAMPLES_PASSED`,\n`?GL_PRIMITIVES_GENERATED`, `?GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN`, or\n`?GL_TIME_ELAPSED`. The behavior of the query object depends on its type and is\nas follows.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBeginQueryIndexed.xhtml)","ref":"gl.html#endQueryIndexed/2"},{"type":"function","title":"gl.endTransformFeedback/0","doc":"Transform feedback mode captures the values of varying variables written by the\nvertex shader (or, if active, the geometry shader). Transform feedback is said\nto be active after a call to\n[`gl:beginTransformFeedback/1`](`beginTransformFeedback/1`) until a subsequent\ncall to [`gl:endTransformFeedback/0`](`beginTransformFeedback/1`). Transform\nfeedback commands must be paired.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBeginTransformFeedback.xhtml)","ref":"gl.html#endTransformFeedback/0"},{"type":"type","title":"gl.enum/0","doc":"","ref":"gl.html#t:enum/0"},{"type":"function","title":"gl.evalCoord1d/1","doc":"Equivalent to  evalCoord2fv/1 .","ref":"gl.html#evalCoord1d/1"},{"type":"function","title":"gl.evalCoord1dv/1","doc":"Equivalent to  evalCoord2fv/1 .","ref":"gl.html#evalCoord1dv/1"},{"type":"function","title":"gl.evalCoord1f/1","doc":"Equivalent to  evalCoord2fv/1 .","ref":"gl.html#evalCoord1f/1"},{"type":"function","title":"gl.evalCoord1fv/1","doc":"Equivalent to  evalCoord2fv/1 .","ref":"gl.html#evalCoord1fv/1"},{"type":"function","title":"gl.evalCoord2d/2","doc":"Equivalent to  evalCoord2fv/1 .","ref":"gl.html#evalCoord2d/2"},{"type":"function","title":"gl.evalCoord2dv/1","doc":"Equivalent to  evalCoord2fv/1 .","ref":"gl.html#evalCoord2dv/1"},{"type":"function","title":"gl.evalCoord2f/2","doc":"Equivalent to  evalCoord2fv/1 .","ref":"gl.html#evalCoord2f/2"},{"type":"function","title":"gl.evalCoord2fv/1","doc":"[`gl:evalCoord1()`](`evalCoord1d/1`) evaluates enabled one-dimensional maps at\nargument `U`. [`gl:evalCoord2()`](`evalCoord1d/1`) does the same for\ntwo-dimensional maps using two domain values, `U` and `V`. To define a map, call\n`glMap1` and `glMap2`; to enable and disable it, call\n[`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glEvalCoord.xml)","ref":"gl.html#evalCoord2fv/1"},{"type":"function","title":"gl.evalMesh1/3","doc":"Equivalent to  evalMesh2/5 .","ref":"gl.html#evalMesh1/3"},{"type":"function","title":"gl.evalMesh2/5","doc":"[`gl:mapGrid()`](`mapGrid1d/3`) and [`gl:evalMesh()`](`evalMesh1/3`) are used in\ntandem to efficiently generate and evaluate a series of evenly-spaced map domain\nvalues. [`gl:evalMesh()`](`evalMesh1/3`) steps through the integer domain of a\none- or two-dimensional grid, whose range is the domain of the evaluation maps\nspecified by `glMap1` and `glMap2`. `Mode` determines whether the resulting\nvertices are connected as points, lines, or filled polygons.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glEvalMesh.xml)","ref":"gl.html#evalMesh2/5"},{"type":"function","title":"gl.evalPoint1/1","doc":"Equivalent to  evalPoint2/2 .","ref":"gl.html#evalPoint1/1"},{"type":"function","title":"gl.evalPoint2/2","doc":"[`gl:mapGrid()`](`mapGrid1d/3`) and [`gl:evalMesh()`](`evalMesh1/3`) are used in\ntandem to efficiently generate and evaluate a series of evenly spaced map domain\nvalues. [`gl:evalPoint()`](`evalPoint1/1`) can be used to evaluate a single grid\npoint in the same gridspace that is traversed by\n[`gl:evalMesh()`](`evalMesh1/3`). Calling [`gl:evalPoint1/1`](`evalPoint1/1`) is\nequivalent to calling glEvalCoord1( i.ð u+u 1 ); where ð u=(u 2-u 1)/n\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glEvalPoint.xml)","ref":"gl.html#evalPoint2/2"},{"type":"type","title":"gl.f/0","doc":"","ref":"gl.html#t:f/0"},{"type":"function","title":"gl.feedbackBuffer/3","doc":"The [`gl:feedbackBuffer/3`](`feedbackBuffer/3`) function controls feedback.\nFeedback, like selection, is a GL mode. The mode is selected by calling\n[`gl:renderMode/1`](`renderMode/1`) with `?GL_FEEDBACK`. When the GL is in\nfeedback mode, no pixels are produced by rasterization. Instead, information\nabout primitives that would have been rasterized is fed back to the application\nusing the GL.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glFeedbackBuffer.xml)","ref":"gl.html#feedbackBuffer/3"},{"type":"function","title":"gl.fenceSync/2","doc":"[`gl:fenceSync/2`](`fenceSync/2`) creates a new fence sync object, inserts a\nfence command into the GL command stream and associates it with that sync\nobject, and returns a non-zero name corresponding to the sync object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFenceSync.xhtml)","ref":"gl.html#fenceSync/2"},{"type":"function","title":"gl.finish/0","doc":"[`gl:finish/0`](`finish/0`) does not return until the effects of all previously\ncalled GL commands are complete. Such effects include all changes to GL state,\nall changes to connection state, and all changes to the frame buffer contents.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFinish.xhtml)","ref":"gl.html#finish/0"},{"type":"function","title":"gl.flush/0","doc":"Different GL implementations buffer commands in several different locations,\nincluding network buffers and the graphics accelerator itself.\n[`gl:flush/0`](`flush/0`) empties all of these buffers, causing all issued\ncommands to be executed as quickly as they are accepted by the actual rendering\nengine. Though this execution may not be completed in any particular time\nperiod, it does complete in finite time.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFlush.xhtml)","ref":"gl.html#flush/0"},{"type":"function","title":"gl.flushMappedBufferRange/3","doc":"Equivalent to  flushMappedNamedBufferRange/3 .","ref":"gl.html#flushMappedBufferRange/3"},{"type":"function","title":"gl.flushMappedNamedBufferRange/3","doc":"[`gl:flushMappedBufferRange/3`](`flushMappedBufferRange/3`) indicates that\nmodifications have been made to a range of a mapped buffer object. The buffer\nobject must previously have been mapped with the `?GL_MAP_FLUSH_EXPLICIT_BIT`\nflag.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFlushMappedBufferRange.xhtml)","ref":"gl.html#flushMappedNamedBufferRange/3"},{"type":"function","title":"gl.fogCoordd/1","doc":"Equivalent to  fogCoordfv/1 .","ref":"gl.html#fogCoordd/1"},{"type":"function","title":"gl.fogCoorddv/1","doc":"Equivalent to  fogCoordfv/1 .","ref":"gl.html#fogCoorddv/1"},{"type":"function","title":"gl.fogCoordf/1","doc":"Equivalent to  fogCoordfv/1 .","ref":"gl.html#fogCoordf/1"},{"type":"function","title":"gl.fogCoordfv/1","doc":"[`gl:fogCoord()`](`fogCoordf/1`) specifies the fog coordinate that is associated\nwith each vertex and the current raster position. The value specified is\ninterpolated and used in computing the fog color (see [`gl:fog()`](`fogf/2`)).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glFogCoord.xml)","ref":"gl.html#fogCoordfv/1"},{"type":"function","title":"gl.fogCoordPointer/3","doc":"[`gl:fogCoordPointer/3`](`fogCoordPointer/3`) specifies the location and data\nformat of an array of fog coordinates to use when rendering. `Type` specifies\nthe data type of each fog coordinate, and `Stride` specifies the byte stride\nfrom one fog coordinate to the next, allowing vertices and attributes to be\npacked into a single array or stored in separate arrays.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glFogCoordPointer.xml)","ref":"gl.html#fogCoordPointer/3"},{"type":"function","title":"gl.fogf/2","doc":"Equivalent to  fogiv/2 .","ref":"gl.html#fogf/2"},{"type":"function","title":"gl.fogfv/2","doc":"Equivalent to  fogiv/2 .","ref":"gl.html#fogfv/2"},{"type":"function","title":"gl.fogi/2","doc":"Equivalent to  fogiv/2 .","ref":"gl.html#fogi/2"},{"type":"function","title":"gl.fogiv/2","doc":"Fog is initially disabled. While enabled, fog affects rasterized geometry,\nbitmaps, and pixel blocks, but not buffer clear operations. To enable and\ndisable fog, call [`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`)\nwith argument `?GL_FOG`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glFog.xml)","ref":"gl.html#fogiv/2"},{"type":"function","title":"gl.framebufferParameteri/3","doc":"[`gl:framebufferParameteri/3`](`framebufferParameteri/3`) and\n`glNamedFramebufferParameteri` modify the value of the parameter named `Pname`\nin the specified framebuffer object. There are no modifiable parameters of the\ndefault draw and read framebuffer, so they are not valid targets of these\ncommands.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFramebufferParameteri.xhtml)","ref":"gl.html#framebufferParameteri/3"},{"type":"function","title":"gl.framebufferRenderbuffer/4","doc":"[`gl:framebufferRenderbuffer/4`](`framebufferRenderbuffer/4`) and\n`glNamedFramebufferRenderbuffer` attaches a renderbuffer as one of the logical\nbuffers of the specified framebuffer object. Renderbuffers cannot be attached to\nthe default draw and read framebuffer, so they are not valid targets of these\ncommands.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFramebufferRenderbuffer.xhtml)","ref":"gl.html#framebufferRenderbuffer/4"},{"type":"function","title":"gl.framebufferTexture1D/5","doc":"Equivalent to  framebufferTextureLayer/5 .","ref":"gl.html#framebufferTexture1D/5"},{"type":"function","title":"gl.framebufferTexture2D/5","doc":"Equivalent to  framebufferTextureLayer/5 .","ref":"gl.html#framebufferTexture2D/5"},{"type":"function","title":"gl.framebufferTexture3D/6","doc":"Equivalent to  framebufferTextureLayer/5 .","ref":"gl.html#framebufferTexture3D/6"},{"type":"function","title":"gl.framebufferTexture/4","doc":"Equivalent to  framebufferTextureLayer/5 .","ref":"gl.html#framebufferTexture/4"},{"type":"function","title":"gl.framebufferTextureFaceARB/5","doc":"Equivalent to  framebufferTextureLayer/5 .","ref":"gl.html#framebufferTextureFaceARB/5"},{"type":"function","title":"gl.framebufferTextureLayer/5","doc":"These commands attach a selected mipmap level or image of a texture object as\none of the logical buffers of the specified framebuffer object. Textures cannot\nbe attached to the default draw and read framebuffer, so they are not valid\ntargets of these commands.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFramebufferTexture.xhtml)","ref":"gl.html#framebufferTextureLayer/5"},{"type":"function","title":"gl.frontFace/1","doc":"In a scene composed entirely of opaque closed surfaces, back-facing polygons are\nnever visible. Eliminating these invisible polygons has the obvious benefit of\nspeeding up the rendering of the image. To enable and disable elimination of\nback-facing polygons, call [`gl:enable/1`](`enable/1`) and\n[`gl:disable/1`](`enable/1`) with argument `?GL_CULL_FACE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFrontFace.xhtml)","ref":"gl.html#frontFace/1"},{"type":"function","title":"gl.frustum/6","doc":"[`gl:frustum/6`](`frustum/6`) describes a perspective matrix that produces a\nperspective projection. The current matrix (see\n[`gl:matrixMode/1`](`matrixMode/1`)) is multiplied by this matrix and the result\nreplaces the current matrix, as if [`gl:multMatrix()`](`multMatrixd/1`) were\ncalled with the following matrix as its argument:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glFrustum.xml)","ref":"gl.html#frustum/6"},{"type":"function","title":"gl.genBuffers/1","doc":"[`gl:genBuffers/1`](`genBuffers/1`) returns `N` buffer object names in\n`Buffers`. There is no guarantee that the names form a contiguous set of\nintegers; however, it is guaranteed that none of the returned names was in use\nimmediately before the call to [`gl:genBuffers/1`](`genBuffers/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenBuffers.xhtml)","ref":"gl.html#genBuffers/1"},{"type":"function","title":"gl.generateMipmap/1","doc":"Equivalent to  generateTextureMipmap/1 .","ref":"gl.html#generateMipmap/1"},{"type":"function","title":"gl.generateTextureMipmap/1","doc":"[`gl:generateMipmap/1`](`generateMipmap/1`) and\n[`gl:generateTextureMipmap/1`](`generateMipmap/1`) generates mipmaps for the\nspecified texture object. For [`gl:generateMipmap/1`](`generateMipmap/1`), the\ntexture object that is bound to `Target`. For\n[`gl:generateTextureMipmap/1`](`generateMipmap/1`), `Texture` is the name of the\ntexture object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenerateMipmap.xhtml)","ref":"gl.html#generateTextureMipmap/1"},{"type":"function","title":"gl.genFramebuffers/1","doc":"[`gl:genFramebuffers/1`](`genFramebuffers/1`) returns `N` framebuffer object\nnames in `Ids`. There is no guarantee that the names form a contiguous set of\nintegers; however, it is guaranteed that none of the returned names was in use\nimmediately before the call to [`gl:genFramebuffers/1`](`genFramebuffers/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenFramebuffers.xhtml)","ref":"gl.html#genFramebuffers/1"},{"type":"function","title":"gl.genLists/1","doc":"[`gl:genLists/1`](`genLists/1`) has one argument, `Range`. It returns an integer\n`n` such that `Range` contiguous empty display lists, named n, n+1, ...,\nn+range-1, are created. If `Range` is 0, if there is no group of `Range`\ncontiguous names available, or if any error is generated, no display lists are\ngenerated, and 0 is returned.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGenLists.xml)","ref":"gl.html#genLists/1"},{"type":"function","title":"gl.genProgramPipelines/1","doc":"[`gl:genProgramPipelines/1`](`genProgramPipelines/1`) returns `N` previously\nunused program pipeline object names in `Pipelines`. These names are marked as\nused, for the purposes of [`gl:genProgramPipelines/1`](`genProgramPipelines/1`)\nonly, but they acquire program pipeline state only when they are first bound.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenProgramPipelines.xhtml)","ref":"gl.html#genProgramPipelines/1"},{"type":"function","title":"gl.genQueries/1","doc":"[`gl:genQueries/1`](`genQueries/1`) returns `N` query object names in `Ids`.\nThere is no guarantee that the names form a contiguous set of integers; however,\nit is guaranteed that none of the returned names was in use immediately before\nthe call to [`gl:genQueries/1`](`genQueries/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenQueries.xhtml)","ref":"gl.html#genQueries/1"},{"type":"function","title":"gl.genRenderbuffers/1","doc":"[`gl:genRenderbuffers/1`](`genRenderbuffers/1`) returns `N` renderbuffer object\nnames in `Renderbuffers`. There is no guarantee that the names form a contiguous\nset of integers; however, it is guaranteed that none of the returned names was\nin use immediately before the call to\n[`gl:genRenderbuffers/1`](`genRenderbuffers/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenRenderbuffers.xhtml)","ref":"gl.html#genRenderbuffers/1"},{"type":"function","title":"gl.genSamplers/1","doc":"[`gl:genSamplers/1`](`genSamplers/1`) returns `N` sampler object names in\n`Samplers`. There is no guarantee that the names form a contiguous set of\nintegers; however, it is guaranteed that none of the returned names was in use\nimmediately before the call to [`gl:genSamplers/1`](`genSamplers/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenSamplers.xhtml)","ref":"gl.html#genSamplers/1"},{"type":"function","title":"gl.genTextures/1","doc":"[`gl:genTextures/1`](`genTextures/1`) returns `N` texture names in `Textures`.\nThere is no guarantee that the names form a contiguous set of integers; however,\nit is guaranteed that none of the returned names was in use immediately before\nthe call to [`gl:genTextures/1`](`genTextures/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenTextures.xhtml)","ref":"gl.html#genTextures/1"},{"type":"function","title":"gl.genTransformFeedbacks/1","doc":"[`gl:genTransformFeedbacks/1`](`genTransformFeedbacks/1`) returns `N` previously\nunused transform feedback object names in `Ids`. These names are marked as used,\nfor the purposes of [`gl:genTransformFeedbacks/1`](`genTransformFeedbacks/1`)\nonly, but they acquire transform feedback state only when they are first bound.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenTransformFeedbacks.xhtml)","ref":"gl.html#genTransformFeedbacks/1"},{"type":"function","title":"gl.genVertexArrays/1","doc":"[`gl:genVertexArrays/1`](`genVertexArrays/1`) returns `N` vertex array object\nnames in `Arrays`. There is no guarantee that the names form a contiguous set of\nintegers; however, it is guaranteed that none of the returned names was in use\nimmediately before the call to [`gl:genVertexArrays/1`](`genVertexArrays/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenVertexArrays.xhtml)","ref":"gl.html#genVertexArrays/1"},{"type":"function","title":"gl.getActiveAttrib/3","doc":"[`gl:getActiveAttrib/3`](`getActiveAttrib/3`) returns information about an\nactive attribute variable in the program object specified by `Program`. The\nnumber of active attributes can be obtained by calling\n[`gl:getProgram()`](`getProgramiv/2`) with the value `?GL_ACTIVE_ATTRIBUTES`. A\nvalue of 0 for `Index` selects the first active attribute variable. Permissible\nvalues for `Index` range from zero to the number of active attribute variables\nminus one.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetActiveAttrib.xhtml)","ref":"gl.html#getActiveAttrib/3"},{"type":"function","title":"gl.getActiveSubroutineName/4","doc":"[`gl:getActiveSubroutineName/4`](`getActiveSubroutineName/4`) queries the name\nof an active shader subroutine uniform from the program object given in\n`Program`. `Index` specifies the index of the shader subroutine uniform within\nthe shader stage given by `Stage`, and must between zero and the value of\n`?GL_ACTIVE_SUBROUTINES` minus one for the shader stage.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetActiveSubroutineName.xhtml)","ref":"gl.html#getActiveSubroutineName/4"},{"type":"function","title":"gl.getActiveSubroutineUniformName/4","doc":"[`gl:getActiveSubroutineUniformName/4`](`getActiveSubroutineUniformName/4`)\nretrieves the name of an active shader subroutine uniform. `Program` contains\nthe name of the program containing the uniform. `Shadertype` specifies the stage\nfor which the uniform location, given by `Index`, is valid. `Index` must be\nbetween zero and the value of `?GL_ACTIVE_SUBROUTINE_UNIFORMS` minus one for the\nshader stage.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetActiveSubroutineUniformName.xhtml)","ref":"gl.html#getActiveSubroutineUniformName/4"},{"type":"function","title":"gl.getActiveUniform/3","doc":"[`gl:getActiveUniform/3`](`getActiveUniform/3`) returns information about an\nactive uniform variable in the program object specified by `Program`. The number\nof active uniform variables can be obtained by calling\n[`gl:getProgram()`](`getProgramiv/2`) with the value `?GL_ACTIVE_UNIFORMS`. A\nvalue of 0 for `Index` selects the first active uniform variable. Permissible\nvalues for `Index` range from zero to the number of active uniform variables\nminus one.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetActiveUniform.xhtml)","ref":"gl.html#getActiveUniform/3"},{"type":"function","title":"gl.getActiveUniformBlockiv/4","doc":"[`gl:getActiveUniformBlockiv/4`](`getActiveUniformBlockiv/4`) retrieves\ninformation about an active uniform block within `Program`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetActiveUniformBlock.xhtml)","ref":"gl.html#getActiveUniformBlockiv/4"},{"type":"function","title":"gl.getActiveUniformBlockName/3","doc":"[`gl:getActiveUniformBlockName/3`](`getActiveUniformBlockName/3`) retrieves the\nname of the active uniform block at `UniformBlockIndex` within `Program`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetActiveUniformBlockName.xhtml)","ref":"gl.html#getActiveUniformBlockName/3"},{"type":"function","title":"gl.getActiveUniformName/3","doc":"[`gl:getActiveUniformName/3`](`getActiveUniformName/3`) returns the name of the\nactive uniform at `UniformIndex` within `Program`. If `UniformName` is not NULL,\nup to `BufSize` characters (including a nul-terminator) will be written into the\narray whose address is specified by `UniformName`. If `Length` is not NULL, the\nnumber of characters that were (or would have been) written into `UniformName`\n(not including the nul-terminator) will be placed in the variable whose address\nis specified in `Length`. If `Length` is NULL, no length is returned. The length\nof the longest uniform name in `Program` is given by the value of\n`?GL_ACTIVE_UNIFORM_MAX_LENGTH`, which can be queried with\n[`gl:getProgram()`](`getProgramiv/2`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetActiveUniformName.xhtml)","ref":"gl.html#getActiveUniformName/3"},{"type":"function","title":"gl.getActiveUniformsiv/3","doc":"[`gl:getActiveUniformsiv/3`](`getActiveUniformsiv/3`) queries the value of the\nparameter named `Pname` for each of the uniforms within `Program` whose indices\nare specified in the array of `UniformCount` unsigned integers `UniformIndices`.\nUpon success, the value of the parameter for each uniform is written into the\ncorresponding entry in the array whose address is given in `Params`. If an error\nis generated, nothing is written into `Params`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetActiveUniformsiv.xhtml)","ref":"gl.html#getActiveUniformsiv/3"},{"type":"function","title":"gl.getAttachedShaders/2","doc":"[`gl:getAttachedShaders/2`](`getAttachedShaders/2`) returns the names of the\nshader objects attached to `Program`. The names of shader objects that are\nattached to `Program` will be returned in `Shaders.` The actual number of shader\nnames written into `Shaders` is returned in `Count.` If no shader objects are\nattached to `Program`, `Count` is set to 0. The maximum number of shader names\nthat may be returned in `Shaders` is specified by `MaxCount`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetAttachedShaders.xhtml)","ref":"gl.html#getAttachedShaders/2"},{"type":"function","title":"gl.getAttribLocation/2","doc":"[`gl:getAttribLocation/2`](`getAttribLocation/2`) queries the previously linked\nprogram object specified by `Program` for the attribute variable specified by\n`Name` and returns the index of the generic vertex attribute that is bound to\nthat attribute variable. If `Name` is a matrix attribute variable, the index of\nthe first column of the matrix is returned. If the named attribute variable is\nnot an active attribute in the specified program object or if `Name` starts with\nthe reserved prefix \"gl\\_\", a value of -1 is returned.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetAttribLocation.xhtml)","ref":"gl.html#getAttribLocation/2"},{"type":"function","title":"gl.getBooleani_v/2","doc":"Equivalent to  getIntegerv/1 .","ref":"gl.html#getBooleani_v/2"},{"type":"function","title":"gl.getBooleanv/1","doc":"Equivalent to  getIntegerv/1 .","ref":"gl.html#getBooleanv/1"},{"type":"function","title":"gl.getBufferParameteri64v/2","doc":"Equivalent to  getBufferParameterivARB/2 .","ref":"gl.html#getBufferParameteri64v/2"},{"type":"function","title":"gl.getBufferParameteriv/2","doc":"[`gl:getBufferParameteriv/2`](`getBufferParameteriv/2`) returns in `Data` a\nselected parameter of the buffer object specified by `Target`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetBufferParameteriv.xml)","ref":"gl.html#getBufferParameteriv/2"},{"type":"function","title":"gl.getBufferParameterivARB/2","doc":"These functions return in `Data` a selected parameter of the specified buffer\nobject.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetBufferParameter.xhtml)","ref":"gl.html#getBufferParameterivARB/2"},{"type":"function","title":"gl.getBufferSubData/4","doc":"[`gl:getBufferSubData/4`](`getBufferSubData/4`) and `glGetNamedBufferSubData`\nreturn some or all of the data contents of the data store of the specified\nbuffer object. Data starting at byte offset `Offset` and extending for `Size`\nbytes is copied from the buffer object's data store to the memory pointed to by\n`Data`. An error is thrown if the buffer object is currently mapped, or if\n`Offset` and `Size` together define a range beyond the bounds of the buffer\nobject's data store.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetBufferSubData.xhtml)","ref":"gl.html#getBufferSubData/4"},{"type":"function","title":"gl.getClipPlane/1","doc":"[`gl:getClipPlane/1`](`getClipPlane/1`) returns in `Equation` the four\ncoefficients of the plane equation for `Plane`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetClipPlane.xml)","ref":"gl.html#getClipPlane/1"},{"type":"function","title":"gl.getColorTable/4","doc":"[`gl:getColorTable/4`](`getColorTable/4`) returns in `Table` the contents of the\ncolor table specified by `Target`. No pixel transfer operations are performed,\nbut pixel storage modes that are applicable to\n[`gl:readPixels/7`](`readPixels/7`) are performed.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetColorTable.xml)","ref":"gl.html#getColorTable/4"},{"type":"function","title":"gl.getColorTableParameterfv/2","doc":"Equivalent to  getColorTableParameteriv/2 .","ref":"gl.html#getColorTableParameterfv/2"},{"type":"function","title":"gl.getColorTableParameteriv/2","doc":"Returns parameters specific to color table `Target`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetColorTableParameter.xml)","ref":"gl.html#getColorTableParameteriv/2"},{"type":"function","title":"gl.getCompressedTexImage/3","doc":"[`gl:getCompressedTexImage/3`](`getCompressedTexImage/3`) and\n`glGetnCompressedTexImage` return the compressed texture image associated with\n`Target` and `Lod` into `Pixels`. `glGetCompressedTextureImage` serves the same\npurpose, but instead of taking a texture target, it takes the ID of the texture\nobject. `Pixels` should be an array of `BufSize` bytes for\n`glGetnCompresedTexImage` and `glGetCompressedTextureImage` functions, and of\n`?GL_TEXTURE_COMPRESSED_IMAGE_SIZE` bytes in case of\n[`gl:getCompressedTexImage/3`](`getCompressedTexImage/3`). If the actual data\ntakes less space than `BufSize`, the remaining bytes will not be touched.\n`Target` specifies the texture target, to which the texture the data the\nfunction should extract the data from is bound to. `Lod` specifies the\nlevel-of-detail number of the desired image.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetCompressedTexImage.xhtml)","ref":"gl.html#getCompressedTexImage/3"},{"type":"function","title":"gl.getConvolutionFilter/4","doc":"[`gl:getConvolutionFilter/4`](`getConvolutionFilter/4`) returns the current 1D\nor 2D convolution filter kernel as an image. The one- or two-dimensional image\nis placed in `Image` according to the specifications in `Format` and `Type`. No\npixel transfer operations are performed on this image, but the relevant pixel\nstorage modes are applied.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetConvolutionFilter.xml)","ref":"gl.html#getConvolutionFilter/4"},{"type":"function","title":"gl.getConvolutionParameterfv/2","doc":"Equivalent to  getConvolutionParameteriv/2 .","ref":"gl.html#getConvolutionParameterfv/2"},{"type":"function","title":"gl.getConvolutionParameteriv/2","doc":"[`gl:getConvolutionParameter()`](`getConvolutionParameterfv/2`) retrieves\nconvolution parameters. `Target` determines which convolution filter is queried.\n`Pname` determines which parameter is returned:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetConvolutionParameter.xml)","ref":"gl.html#getConvolutionParameteriv/2"},{"type":"function","title":"gl.getDebugMessageLog/2","doc":"[`gl:getDebugMessageLog/2`](`getDebugMessageLog/2`) retrieves messages from the\ndebug message log. A maximum of `Count` messages are retrieved from the log. If\n`Sources` is not NULL then the source of each message is written into up to\n`Count` elements of the array. If `Types` is not NULL then the type of each\nmessage is written into up to `Count` elements of the array. If `Id` is not NULL\nthen the identifier of each message is written into up to `Count` elements of\nthe array. If `Severities` is not NULL then the severity of each message is\nwritten into up to `Count` elements of the array. If `Lengths` is not NULL then\nthe length of each message is written into up to `Count` elements of the array.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetDebugMessageLog.xhtml)","ref":"gl.html#getDebugMessageLog/2"},{"type":"function","title":"gl.getDoublei_v/2","doc":"Equivalent to  getIntegerv/1 .","ref":"gl.html#getDoublei_v/2"},{"type":"function","title":"gl.getDoublev/1","doc":"Equivalent to  getIntegerv/1 .","ref":"gl.html#getDoublev/1"},{"type":"function","title":"gl.getError/0","doc":"[`gl:getError/0`](`getError/0`) returns the value of the error flag. Each\ndetectable error is assigned a numeric code and symbolic name. When an error\noccurs, the error flag is set to the appropriate error code value. No other\nerrors are recorded until [`gl:getError/0`](`getError/0`) is called, the error\ncode is returned, and the flag is reset to `?GL_NO_ERROR`. If a call to\n[`gl:getError/0`](`getError/0`) returns `?GL_NO_ERROR`, there has been no\ndetectable error since the last call to [`gl:getError/0`](`getError/0`), or\nsince the GL was initialized.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetError.xhtml)","ref":"gl.html#getError/0"},{"type":"function","title":"gl.getFloati_v/2","doc":"Equivalent to  getIntegerv/1 .","ref":"gl.html#getFloati_v/2"},{"type":"function","title":"gl.getFloatv/1","doc":"Equivalent to  getIntegerv/1 .","ref":"gl.html#getFloatv/1"},{"type":"function","title":"gl.getFragDataIndex/2","doc":"[`gl:getFragDataIndex/2`](`getFragDataIndex/2`) returns the index of the\nfragment color to which the variable `Name` was bound when the program object\n`Program` was last linked. If `Name` is not a varying out variable of `Program`,\nor if an error occurs, -1 will be returned.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetFragDataIndex.xhtml)","ref":"gl.html#getFragDataIndex/2"},{"type":"function","title":"gl.getFragDataLocation/2","doc":"[`gl:getFragDataLocation/2`](`getFragDataLocation/2`) retrieves the assigned\ncolor number binding for the user-defined varying out variable `Name` for\nprogram `Program`. `Program` must have previously been linked. `Name` must be a\nnull-terminated string. If `Name` is not the name of an active user-defined\nvarying out fragment shader variable within `Program`, -1 will be returned.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetFragDataLocation.xhtml)","ref":"gl.html#getFragDataLocation/2"},{"type":"function","title":"gl.getFramebufferAttachmentParameteriv/3","doc":"[`gl:getFramebufferAttachmentParameteriv/3`](`getFramebufferAttachmentParameteriv/3`)\nand `glGetNamedFramebufferAttachmentParameteriv` return parameters of\nattachments of a specified framebuffer object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetFramebufferAttachmentParameter.xhtml)","ref":"gl.html#getFramebufferAttachmentParameteriv/3"},{"type":"function","title":"gl.getFramebufferParameteriv/2","doc":"[`gl:getFramebufferParameteriv/2`](`getFramebufferParameteriv/2`) and\n`glGetNamedFramebufferParameteriv` query parameters of a specified framebuffer\nobject.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetFramebufferParameter.xhtml)","ref":"gl.html#getFramebufferParameteriv/2"},{"type":"function","title":"gl.getGraphicsResetStatus/0","doc":"Certain events can result in a reset of the GL context. Such a reset causes all\ncontext state to be lost and requires the application to recreate all objects in\nthe affected context.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetGraphicsResetStatus.xhtml)","ref":"gl.html#getGraphicsResetStatus/0"},{"type":"function","title":"gl.getHistogram/5","doc":"[`gl:getHistogram/5`](`getHistogram/5`) returns the current histogram table as a\none-dimensional image with the same width as the histogram. No pixel transfer\noperations are performed on this image, but pixel storage modes that are\napplicable to 1D images are honored.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetHistogram.xml)","ref":"gl.html#getHistogram/5"},{"type":"function","title":"gl.getHistogramParameterfv/2","doc":"Equivalent to  getHistogramParameteriv/2 .","ref":"gl.html#getHistogramParameterfv/2"},{"type":"function","title":"gl.getHistogramParameteriv/2","doc":"[`gl:getHistogramParameter()`](`getHistogramParameterfv/2`) is used to query\nparameter values for the current histogram or for a proxy. The histogram state\ninformation may be queried by calling\n[`gl:getHistogramParameter()`](`getHistogramParameterfv/2`) with a `Target` of\n`?GL_HISTOGRAM` (to obtain information for the current histogram table) or\n`?GL_PROXY_HISTOGRAM` (to obtain information from the most recent proxy request)\nand one of the following values for the `Pname` argument:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetHistogramParameter.xml)","ref":"gl.html#getHistogramParameteriv/2"},{"type":"function","title":"gl.getInteger64i_v/2","doc":"Equivalent to  getIntegerv/1 .","ref":"gl.html#getInteger64i_v/2"},{"type":"function","title":"gl.getInteger64v/1","doc":"Equivalent to  getIntegerv/1 .","ref":"gl.html#getInteger64v/1"},{"type":"function","title":"gl.getIntegeri_v/2","doc":"Equivalent to  getIntegerv/1 .","ref":"gl.html#getIntegeri_v/2"},{"type":"function","title":"gl.getIntegerv/1","doc":"These commands return values for simple state variables in GL. `Pname` is a\nsymbolic constant indicating the state variable to be returned, and `Data` is a\npointer to an array of the indicated type in which to place the returned data.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGet.xhtml)","ref":"gl.html#getIntegerv/1"},{"type":"function","title":"gl.getInternalformati64v/4","doc":"Equivalent to  getInternalformativ/4 .","ref":"gl.html#getInternalformati64v/4"},{"type":"function","title":"gl.getInternalformativ/4","doc":"No documentation available.","ref":"gl.html#getInternalformativ/4"},{"type":"function","title":"gl.getLightfv/2","doc":"Equivalent to  getLightiv/2 .","ref":"gl.html#getLightfv/2"},{"type":"function","title":"gl.getLightiv/2","doc":"[`gl:getLight()`](`getLightfv/2`) returns in `Params` the value or values of a\nlight source parameter. `Light` names the light and is a symbolic name of the\nform `?GL_LIGHT` i where i ranges from 0 to the value of `?GL_MAX_LIGHTS` \\- 1.\n`?GL_MAX_LIGHTS` is an implementation dependent constant that is greater than or\nequal to eight. `Pname` specifies one of ten light source parameters, again by\nsymbolic name.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetLight.xml)","ref":"gl.html#getLightiv/2"},{"type":"function","title":"gl.getMapdv/3","doc":"Equivalent to  getMapiv/3 .","ref":"gl.html#getMapdv/3"},{"type":"function","title":"gl.getMapfv/3","doc":"Equivalent to  getMapiv/3 .","ref":"gl.html#getMapfv/3"},{"type":"function","title":"gl.getMapiv/3","doc":"`glMap1` and `glMap2` define evaluators. [`gl:getMap()`](`getMapdv/3`) returns\nevaluator parameters. `Target` chooses a map, `Query` selects a specific\nparameter, and `V` points to storage where the values will be returned.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetMap.xml)","ref":"gl.html#getMapiv/3"},{"type":"function","title":"gl.getMaterialfv/2","doc":"Equivalent to  getMaterialiv/2 .","ref":"gl.html#getMaterialfv/2"},{"type":"function","title":"gl.getMaterialiv/2","doc":"[`gl:getMaterial()`](`getMaterialfv/2`) returns in `Params` the value or values\nof parameter `Pname` of material `Face`. Six parameters are defined:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetMaterial.xml)","ref":"gl.html#getMaterialiv/2"},{"type":"function","title":"gl.getMinmax/5","doc":"[`gl:getMinmax/5`](`getMinmax/5`) returns the accumulated minimum and maximum\npixel values (computed on a per-component basis) in a one-dimensional image of\nwidth 2. The first set of return values are the minima, and the second set of\nreturn values are the maxima. The format of the return values is determined by\n`Format`, and their type is determined by `Types`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetMinmax.xml)","ref":"gl.html#getMinmax/5"},{"type":"function","title":"gl.getMinmaxParameterfv/2","doc":"Equivalent to  getMinmaxParameteriv/2 .","ref":"gl.html#getMinmaxParameterfv/2"},{"type":"function","title":"gl.getMinmaxParameteriv/2","doc":"[`gl:getMinmaxParameter()`](`getMinmaxParameterfv/2`) retrieves parameters for\nthe current minmax table by setting `Pname` to one of the following values:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetMinmaxParameter.xml)","ref":"gl.html#getMinmaxParameteriv/2"},{"type":"function","title":"gl.getMultisamplefv/2","doc":"[`gl:getMultisamplefv/2`](`getMultisamplefv/2`) queries the location of a given\nsample. `Pname` specifies the sample parameter to retrieve and must be\n`?GL_SAMPLE_POSITION`. `Index` corresponds to the sample for which the location\nshould be returned. The sample location is returned as two floating-point values\nin `Val[0]` and `Val[1]`, each between 0 and 1, corresponding to the `X` and `Y`\nlocations respectively in the GL pixel space of that sample. (0.5, 0.5) this\ncorresponds to the pixel center. `Index` must be between zero and the value of\n`?GL_SAMPLES` minus one.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetMultisample.xhtml)","ref":"gl.html#getMultisamplefv/2"},{"type":"function","title":"gl.getPixelMapfv/2","doc":"Equivalent to  getPixelMapusv/2 .","ref":"gl.html#getPixelMapfv/2"},{"type":"function","title":"gl.getPixelMapuiv/2","doc":"Equivalent to  getPixelMapusv/2 .","ref":"gl.html#getPixelMapuiv/2"},{"type":"function","title":"gl.getPixelMapusv/2","doc":"See the [`gl:pixelMap()`](`pixelMapfv/3`) reference page for a description of\nthe acceptable values for the `Map` parameter.\n[`gl:getPixelMap()`](`getPixelMapfv/2`) returns in `Data` the contents of the\npixel map specified in `Map`. Pixel maps are used during the execution of\n[`gl:readPixels/7`](`readPixels/7`), [`gl:drawPixels/5`](`drawPixels/5`),\n[`gl:copyPixels/5`](`copyPixels/5`), [`gl:texImage1D/8`](`texImage1D/8`),\n[`gl:texImage2D/9`](`texImage2D/9`), [`gl:texImage3D/10`](`texImage3D/10`),\n[`gl:texSubImage1D/7`](`texSubImage1D/7`),\n[`gl:texSubImage2D/9`](`texSubImage2D/9`),\n[`gl:texSubImage3D/11`](`texSubImage3D/11`),\n[`gl:copyTexImage1D/7`](`copyTexImage1D/7`),\n[`gl:copyTexImage2D/8`](`copyTexImage2D/8`),\n[`gl:copyTexSubImage1D/6`](`copyTexSubImage1D/6`),\n[`gl:copyTexSubImage2D/8`](`copyTexSubImage2D/8`), and\n[`gl:copyTexSubImage3D/9`](`copyTexSubImage3D/9`). to map color indices, stencil\nindices, color components, and depth components to other values.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetPixelMap.xml)","ref":"gl.html#getPixelMapusv/2"},{"type":"function","title":"gl.getPolygonStipple/0","doc":"[`gl:getPolygonStipple/0`](`getPolygonStipple/0`) returns to `Pattern` a 32×32\npolygon stipple pattern. The pattern is packed into memory as if\n[`gl:readPixels/7`](`readPixels/7`) with both `height` and `width` of 32, `type`\nof `?GL_BITMAP`, and `format` of `?GL_COLOR_INDEX` were called, and the stipple\npattern were stored in an internal 32×32 color index buffer. Unlike\n[`gl:readPixels/7`](`readPixels/7`), however, pixel transfer operations (shift,\noffset, pixel map) are not applied to the returned stipple image.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetPolygonStipple.xml)","ref":"gl.html#getPolygonStipple/0"},{"type":"function","title":"gl.getProgramBinary/2","doc":"[`gl:getProgramBinary/2`](`getProgramBinary/2`) returns a binary representation\nof the compiled and linked executable for `Program` into the array of bytes\nwhose address is specified in `Binary`. The maximum number of bytes that may be\nwritten into `Binary` is specified by `BufSize`. If the program binary is\ngreater in size than `BufSize` bytes, then an error is generated, otherwise the\nactual number of bytes written into `Binary` is returned in the variable whose\naddress is given by `Length`. If `Length` is `?NULL`, then no length is\nreturned.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramBinary.xhtml)","ref":"gl.html#getProgramBinary/2"},{"type":"function","title":"gl.getProgramInfoLog/2","doc":"[`gl:getProgramInfoLog/2`](`getProgramInfoLog/2`) returns the information log\nfor the specified program object. The information log for a program object is\nmodified when the program object is linked or validated. The string that is\nreturned will be null terminated.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramInfoLog.xhtml)","ref":"gl.html#getProgramInfoLog/2"},{"type":"function","title":"gl.getProgramInterfaceiv/3","doc":"[`gl:getProgramInterfaceiv/3`](`getProgramInterfaceiv/3`) queries the property\nof the interface identifed by `ProgramInterface` in `Program`, the property name\nof which is given by `Pname`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramInterface.xhtml)","ref":"gl.html#getProgramInterfaceiv/3"},{"type":"function","title":"gl.getProgramiv/2","doc":"[`gl:getProgram()`](`getProgramiv/2`) returns in `Params` the value of a\nparameter for a specific program object. The following parameters are defined:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgram.xhtml)","ref":"gl.html#getProgramiv/2"},{"type":"function","title":"gl.getProgramPipelineInfoLog/2","doc":"[`gl:getProgramPipelineInfoLog/2`](`getProgramPipelineInfoLog/2`) retrieves the\ninfo log for the program pipeline object `Pipeline`. The info log, including its\nnull terminator, is written into the array of characters whose address is given\nby `InfoLog`. The maximum number of characters that may be written into\n`InfoLog` is given by `BufSize`, and the actual number of characters written\ninto `InfoLog` is returned in the integer whose address is given by `Length`. If\n`Length` is `?NULL`, no length is returned.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramPipelineInfoLog.xhtml)","ref":"gl.html#getProgramPipelineInfoLog/2"},{"type":"function","title":"gl.getProgramPipelineiv/2","doc":"[`gl:getProgramPipelineiv/2`](`getProgramPipelineiv/2`) retrieves the value of a\nproperty of the program pipeline object `Pipeline`. `Pname` specifies the name\nof the parameter whose value to retrieve. The value of the parameter is written\nto the variable whose address is given by `Params`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramPipeline.xhtml)","ref":"gl.html#getProgramPipelineiv/2"},{"type":"function","title":"gl.getProgramResourceIndex/3","doc":"[`gl:getProgramResourceIndex/3`](`getProgramResourceIndex/3`) returns the\nunsigned integer index assigned to a resource named `Name` in the interface type\n`ProgramInterface` of program object `Program`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramResourceIndex.xhtml)","ref":"gl.html#getProgramResourceIndex/3"},{"type":"function","title":"gl.getProgramResourceLocation/3","doc":"[`gl:getProgramResourceLocation/3`](`getProgramResourceLocation/3`) returns the\nlocation assigned to the variable named `Name` in interface `ProgramInterface`\nof program object `Program`. `Program` must be the name of a program that has\nbeen linked successfully. `ProgramInterface` must be one of `?GL_UNIFORM`,\n`?GL_PROGRAM_INPUT`, `?GL_PROGRAM_OUTPUT`, `?GL_VERTEX_SUBROUTINE_UNIFORM`,\n`?GL_TESS_CONTROL_SUBROUTINE_UNIFORM`, `?GL_TESS_EVALUATION_SUBROUTINE_UNIFORM`,\n`?GL_GEOMETRY_SUBROUTINE_UNIFORM`, `?GL_FRAGMENT_SUBROUTINE_UNIFORM`,\n`?GL_COMPUTE_SUBROUTINE_UNIFORM`, or `?GL_TRANSFORM_FEEDBACK_BUFFER`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramResourceLocation.xhtml)","ref":"gl.html#getProgramResourceLocation/3"},{"type":"function","title":"gl.getProgramResourceLocationIndex/3","doc":"[`gl:getProgramResourceLocationIndex/3`](`getProgramResourceLocationIndex/3`)\nreturns the fragment color index assigned to the variable named `Name` in\ninterface `ProgramInterface` of program object `Program`. `Program` must be the\nname of a program that has been linked successfully. `ProgramInterface` must be\n`?GL_PROGRAM_OUTPUT`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramResourceLocationIndex.xhtml)","ref":"gl.html#getProgramResourceLocationIndex/3"},{"type":"function","title":"gl.getProgramResourceName/4","doc":"[`gl:getProgramResourceName/4`](`getProgramResourceName/4`) retrieves the name\nstring assigned to the single active resource with an index of `Index` in the\ninterface `ProgramInterface` of program object `Program`. `Index` must be less\nthan the number of entries in the active resource list for `ProgramInterface`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramResourceName.xhtml)","ref":"gl.html#getProgramResourceName/4"},{"type":"function","title":"gl.getProgramStageiv/3","doc":"[`gl:getProgramStage()`](`getProgramStageiv/3`) queries a parameter of a shader\nstage attached to a program object. `Program` contains the name of the program\nto which the shader is attached. `Shadertype` specifies the stage from which to\nquery the parameter. `Pname` specifies which parameter should be queried. The\nvalue or values of the parameter to be queried is returned in the variable whose\naddress is given in `Values`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramStage.xhtml)","ref":"gl.html#getProgramStageiv/3"},{"type":"function","title":"gl.getQueryBufferObjecti64v/4","doc":"Equivalent to  getQueryObjectuiv/2 .","ref":"gl.html#getQueryBufferObjecti64v/4"},{"type":"function","title":"gl.getQueryBufferObjectiv/4","doc":"Equivalent to  getQueryObjectuiv/2 .","ref":"gl.html#getQueryBufferObjectiv/4"},{"type":"function","title":"gl.getQueryBufferObjectui64v/4","doc":"Equivalent to  getQueryObjectuiv/2 .","ref":"gl.html#getQueryBufferObjectui64v/4"},{"type":"function","title":"gl.getQueryBufferObjectuiv/4","doc":"Equivalent to  getQueryObjectuiv/2 .","ref":"gl.html#getQueryBufferObjectuiv/4"},{"type":"function","title":"gl.getQueryIndexediv/3","doc":"[`gl:getQueryIndexediv/3`](`getQueryIndexediv/3`) returns in `Params` a selected\nparameter of the indexed query object target specified by `Target` and `Index`.\n`Index` specifies the index of the query object target and must be between zero\nand a target-specific maxiumum.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetQueryIndexed.xhtml)","ref":"gl.html#getQueryIndexediv/3"},{"type":"function","title":"gl.getQueryiv/2","doc":"[`gl:getQueryiv/2`](`getQueryiv/2`) returns in `Params` a selected parameter of\nthe query object target specified by `Target`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetQueryiv.xhtml)","ref":"gl.html#getQueryiv/2"},{"type":"function","title":"gl.getQueryObjecti64v/2","doc":"Equivalent to  getQueryObjectuiv/2 .","ref":"gl.html#getQueryObjecti64v/2"},{"type":"function","title":"gl.getQueryObjectiv/2","doc":"Equivalent to  getQueryObjectuiv/2 .","ref":"gl.html#getQueryObjectiv/2"},{"type":"function","title":"gl.getQueryObjectui64v/2","doc":"Equivalent to  getQueryObjectuiv/2 .","ref":"gl.html#getQueryObjectui64v/2"},{"type":"function","title":"gl.getQueryObjectuiv/2","doc":"These commands return a selected parameter of the query object specified by\n`Id`. [`gl:getQueryObject()`](`getQueryObjectiv/2`) returns in `Params` a\nselected parameter of the query object specified by `Id`.\n[`gl:getQueryBufferObject()`](`getQueryObjectiv/2`) returns in `Buffer` a\nselected parameter of the query object specified by `Id`, by writing it to\n`Buffer`'s data store at the byte offset specified by `Offset`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetQueryObject.xhtml)","ref":"gl.html#getQueryObjectuiv/2"},{"type":"function","title":"gl.getRenderbufferParameteriv/2","doc":"[`gl:getRenderbufferParameteriv/2`](`getRenderbufferParameteriv/2`) and\n`glGetNamedRenderbufferParameteriv` query parameters of a specified renderbuffer\nobject.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetRenderbufferParameter.xhtml)","ref":"gl.html#getRenderbufferParameteriv/2"},{"type":"function","title":"gl.getSamplerParameterfv/2","doc":"Equivalent to  getSamplerParameteriv/2 .","ref":"gl.html#getSamplerParameterfv/2"},{"type":"function","title":"gl.getSamplerParameterIiv/2","doc":"Equivalent to  getSamplerParameteriv/2 .","ref":"gl.html#getSamplerParameterIiv/2"},{"type":"function","title":"gl.getSamplerParameterIuiv/2","doc":"Equivalent to  getSamplerParameteriv/2 .","ref":"gl.html#getSamplerParameterIuiv/2"},{"type":"function","title":"gl.getSamplerParameteriv/2","doc":"[`gl:getSamplerParameter()`](`getSamplerParameteriv/2`) returns in `Params` the\nvalue or values of the sampler parameter specified as `Pname`. `Sampler` defines\nthe target sampler, and must be the name of an existing sampler object, returned\nfrom a previous call to [`gl:genSamplers/1`](`genSamplers/1`). `Pname` accepts\nthe same symbols as [`gl:samplerParameter()`](`samplerParameteri/3`), with the\nsame interpretations:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetSamplerParameter.xhtml)","ref":"gl.html#getSamplerParameteriv/2"},{"type":"function","title":"gl.getShaderInfoLog/2","doc":"[`gl:getShaderInfoLog/2`](`getShaderInfoLog/2`) returns the information log for\nthe specified shader object. The information log for a shader object is modified\nwhen the shader is compiled. The string that is returned will be null\nterminated.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetShaderInfoLog.xhtml)","ref":"gl.html#getShaderInfoLog/2"},{"type":"function","title":"gl.getShaderiv/2","doc":"[`gl:getShader()`](`getShaderiv/2`) returns in `Params` the value of a parameter\nfor a specific shader object. The following parameters are defined:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetShader.xhtml)","ref":"gl.html#getShaderiv/2"},{"type":"function","title":"gl.getShaderPrecisionFormat/2","doc":"[`gl:getShaderPrecisionFormat/2`](`getShaderPrecisionFormat/2`) retrieves the\nnumeric range and precision for the implementation's representation of\nquantities in different numeric formats in specified shader type. `ShaderType`\nspecifies the type of shader for which the numeric precision and range is to be\nretrieved and must be one of `?GL_VERTEX_SHADER` or `?GL_FRAGMENT_SHADER`.\n`PrecisionType` specifies the numeric format to query and must be one of\n`?GL_LOW_FLOAT`, `?GL_MEDIUM_FLOAT``?GL_HIGH_FLOAT`, `?GL_LOW_INT`,\n`?GL_MEDIUM_INT`, or `?GL_HIGH_INT`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetShaderPrecisionFormat.xhtml)","ref":"gl.html#getShaderPrecisionFormat/2"},{"type":"function","title":"gl.getShaderSource/2","doc":"[`gl:getShaderSource/2`](`getShaderSource/2`) returns the concatenation of the\nsource code strings from the shader object specified by `Shader`. The source\ncode strings for a shader object are the result of a previous call to\n[`gl:shaderSource/2`](`shaderSource/2`). The string returned by the function\nwill be null terminated.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetShaderSource.xhtml)","ref":"gl.html#getShaderSource/2"},{"type":"function","title":"gl.getString/1","doc":"Equivalent to  getStringi/2 .","ref":"gl.html#getString/1"},{"type":"function","title":"gl.getStringi/2","doc":"[`gl:getString/1`](`getString/1`) returns a pointer to a static string\ndescribing some aspect of the current GL connection. `Name` can be one of the\nfollowing:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetString.xhtml)","ref":"gl.html#getStringi/2"},{"type":"function","title":"gl.getSubroutineIndex/3","doc":"[`gl:getSubroutineIndex/3`](`getSubroutineIndex/3`) returns the index of a\nsubroutine uniform within a shader stage attached to a program object. `Program`\ncontains the name of the program to which the shader is attached. `Shadertype`\nspecifies the stage from which to query shader subroutine index. `Name` contains\nthe null-terminated name of the subroutine uniform whose name to query.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetSubroutineIndex.xhtml)","ref":"gl.html#getSubroutineIndex/3"},{"type":"function","title":"gl.getSubroutineUniformLocation/3","doc":"[`gl:getSubroutineUniformLocation/3`](`getSubroutineUniformLocation/3`) returns\nthe location of the subroutine uniform variable `Name` in the shader stage of\ntype `Shadertype` attached to `Program`, with behavior otherwise identical to\n[`gl:getUniformLocation/2`](`getUniformLocation/2`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetSubroutineUniformLocation.xhtml)","ref":"gl.html#getSubroutineUniformLocation/3"},{"type":"function","title":"gl.getSynciv/3","doc":"[`gl:getSynciv/3`](`getSynciv/3`) retrieves properties of a sync object. `Sync`\nspecifies the name of the sync object whose properties to retrieve.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetSync.xhtml)","ref":"gl.html#getSynciv/3"},{"type":"function","title":"gl.getTexEnvfv/2","doc":"Equivalent to  getTexEnviv/2 .","ref":"gl.html#getTexEnvfv/2"},{"type":"function","title":"gl.getTexEnviv/2","doc":"[`gl:getTexEnv()`](`getTexEnvfv/2`) returns in `Params` selected values of a\ntexture environment that was specified with [`gl:texEnv()`](`texEnvf/3`).\n`Target` specifies a texture environment.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetTexEnv.xml)","ref":"gl.html#getTexEnviv/2"},{"type":"function","title":"gl.getTexGendv/2","doc":"Equivalent to  getTexGeniv/2 .","ref":"gl.html#getTexGendv/2"},{"type":"function","title":"gl.getTexGenfv/2","doc":"Equivalent to  getTexGeniv/2 .","ref":"gl.html#getTexGenfv/2"},{"type":"function","title":"gl.getTexGeniv/2","doc":"[`gl:getTexGen()`](`getTexGendv/2`) returns in `Params` selected parameters of a\ntexture coordinate generation function that was specified using\n[`gl:texGen()`](`texGend/3`). `Coord` names one of the (`s`, `t`, `r`, `q`)\ntexture coordinates, using the symbolic constant `?GL_S`, `?GL_T`, `?GL_R`, or\n`?GL_Q`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetTexGen.xml)","ref":"gl.html#getTexGeniv/2"},{"type":"function","title":"gl.getTexImage/5","doc":"[`gl:getTexImage/5`](`getTexImage/5`), `glGetnTexImage` and `glGetTextureImage`\nfunctions return a texture image into `Pixels`. For\n[`gl:getTexImage/5`](`getTexImage/5`) and `glGetnTexImage`, `Target` specifies\nwhether the desired texture image is one specified by\n[`gl:texImage1D/8`](`texImage1D/8`) (`?GL_TEXTURE_1D`),\n[`gl:texImage2D/9`](`texImage2D/9`) (`?GL_TEXTURE_1D_ARRAY`,\n`?GL_TEXTURE_RECTANGLE`, `?GL_TEXTURE_2D` or any of `?GL_TEXTURE_CUBE_MAP_*`),\nor [`gl:texImage3D/10`](`texImage3D/10`) (`?GL_TEXTURE_2D_ARRAY`,\n`?GL_TEXTURE_3D`, `?GL_TEXTURE_CUBE_MAP_ARRAY`). For `glGetTextureImage`,\n`Texture` specifies the texture object name. In addition to types of textures\naccepted by [`gl:getTexImage/5`](`getTexImage/5`) and `glGetnTexImage`, the\nfunction also accepts cube map texture objects (with effective target\n`?GL_TEXTURE_CUBE_MAP`). `Level` specifies the level-of-detail number of the\ndesired image. `Format` and `Type` specify the format and type of the desired\nimage array. See the reference page for [`gl:texImage1D/8`](`texImage1D/8`) for\na description of the acceptable values for the `Format` and `Type` parameters,\nrespectively. For glGetnTexImage and glGetTextureImage functions, bufSize tells\nthe size of the buffer to receive the retrieved pixel data. `glGetnTexImage` and\n`glGetTextureImage` do not write more than `BufSize` bytes into `Pixels`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetTexImage.xhtml)","ref":"gl.html#getTexImage/5"},{"type":"function","title":"gl.getTexLevelParameterfv/3","doc":"Equivalent to  getTexLevelParameteriv/3 .","ref":"gl.html#getTexLevelParameterfv/3"},{"type":"function","title":"gl.getTexLevelParameteriv/3","doc":"[`gl:getTexLevelParameterfv/3`](`getTexLevelParameterfv/3`),\n[`gl:getTexLevelParameteriv/3`](`getTexLevelParameterfv/3`),\n`glGetTextureLevelParameterfv` and `glGetTextureLevelParameteriv` return in\n`Params` texture parameter values for a specific level-of-detail value,\nspecified as `Level`. For the first two functions, `Target` defines the target\ntexture, either `?GL_TEXTURE_1D`, `?GL_TEXTURE_2D`, `?GL_TEXTURE_3D`,\n`?GL_PROXY_TEXTURE_1D`, `?GL_PROXY_TEXTURE_2D`, `?GL_PROXY_TEXTURE_3D`,\n`?GL_TEXTURE_CUBE_MAP_POSITIVE_X`, `?GL_TEXTURE_CUBE_MAP_NEGATIVE_X`,\n`?GL_TEXTURE_CUBE_MAP_POSITIVE_Y`, `?GL_TEXTURE_CUBE_MAP_NEGATIVE_Y`,\n`?GL_TEXTURE_CUBE_MAP_POSITIVE_Z`, `?GL_TEXTURE_CUBE_MAP_NEGATIVE_Z`, or\n`?GL_PROXY_TEXTURE_CUBE_MAP`. The remaining two take a `Texture` argument which\nspecifies the name of the texture object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetTexLevelParameter.xhtml)","ref":"gl.html#getTexLevelParameteriv/3"},{"type":"function","title":"gl.getTexParameterfv/2","doc":"Equivalent to  getTexParameteriv/2 .","ref":"gl.html#getTexParameterfv/2"},{"type":"function","title":"gl.getTexParameterIiv/2","doc":"Equivalent to  getTexParameteriv/2 .","ref":"gl.html#getTexParameterIiv/2"},{"type":"function","title":"gl.getTexParameterIuiv/2","doc":"Equivalent to  getTexParameteriv/2 .","ref":"gl.html#getTexParameterIuiv/2"},{"type":"function","title":"gl.getTexParameteriv/2","doc":"[`gl:getTexParameter()`](`getTexParameterfv/2`) and `glGetTextureParameter`\nreturn in `Params` the value or values of the texture parameter specified as\n`Pname`. `Target` defines the target texture. `?GL_TEXTURE_1D`,\n`?GL_TEXTURE_2D`, `?GL_TEXTURE_3D`, `?GL_TEXTURE_1D_ARRAY`,\n`?GL_TEXTURE_2D_ARRAY`, `?GL_TEXTURE_RECTANGLE`, `?GL_TEXTURE_CUBE_MAP`,\n`?GL_TEXTURE_CUBE_MAP_ARRAY`, `?GL_TEXTURE_2D_MULTISAMPLE`, or\n`?GL_TEXTURE_2D_MULTISAMPLE_ARRAY` specify one-, two-, or three-dimensional,\none-dimensional array, two-dimensional array, rectangle, cube-mapped or\ncube-mapped array, two-dimensional multisample, or two-dimensional multisample\narray texturing, respectively. `Pname` accepts the same symbols as\n[`gl:texParameter()`](`texParameterf/3`), with the same interpretations:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetTexParameter.xhtml)","ref":"gl.html#getTexParameteriv/2"},{"type":"function","title":"gl.getTransformFeedbackVarying/3","doc":"Information about the set of varying variables in a linked program that will be\ncaptured during transform feedback may be retrieved by calling\n[`gl:getTransformFeedbackVarying/3`](`getTransformFeedbackVarying/3`).\n[`gl:getTransformFeedbackVarying/3`](`getTransformFeedbackVarying/3`) provides\ninformation about the varying variable selected by `Index`. An `Index` of 0\nselects the first varying variable specified in the `Varyings` array passed to\n[`gl:transformFeedbackVaryings/3`](`transformFeedbackVaryings/3`), and an\n`Index` of the value of `?GL_TRANSFORM_FEEDBACK_VARYINGS` minus one selects the\nlast such variable.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetTransformFeedbackVarying.xhtml)","ref":"gl.html#getTransformFeedbackVarying/3"},{"type":"function","title":"gl.getUniformBlockIndex/2","doc":"[`gl:getUniformBlockIndex/2`](`getUniformBlockIndex/2`) retrieves the index of a\nuniform block within `Program`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetUniformBlockIndex.xhtml)","ref":"gl.html#getUniformBlockIndex/2"},{"type":"function","title":"gl.getUniformdv/2","doc":"Equivalent to  getUniformuiv/2 .","ref":"gl.html#getUniformdv/2"},{"type":"function","title":"gl.getUniformfv/2","doc":"Equivalent to  getUniformuiv/2 .","ref":"gl.html#getUniformfv/2"},{"type":"function","title":"gl.getUniformIndices/2","doc":"[`gl:getUniformIndices/2`](`getUniformIndices/2`) retrieves the indices of a\nnumber of uniforms within `Program`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetUniformIndices.xhtml)","ref":"gl.html#getUniformIndices/2"},{"type":"function","title":"gl.getUniformiv/2","doc":"Equivalent to  getUniformuiv/2 .","ref":"gl.html#getUniformiv/2"},{"type":"function","title":"gl.getUniformLocation/2","doc":"`glGetUniformLocation `returns an integer that represents the location of a\nspecific uniform variable within a program object. `Name` must be a null\nterminated string that contains no white space. `Name` must be an active uniform\nvariable name in `Program` that is not a structure, an array of structures, or a\nsubcomponent of a vector or a matrix. This function returns -1 if `Name` does\nnot correspond to an active uniform variable in `Program`, if `Name` starts with\nthe reserved prefix \"gl\\_\", or if `Name` is associated with an atomic counter or\na named uniform block.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetUniformLocation.xhtml)","ref":"gl.html#getUniformLocation/2"},{"type":"function","title":"gl.getUniformSubroutineuiv/2","doc":"[`gl:getUniformSubroutine()`](`getUniformSubroutineuiv/2`) retrieves the value\nof the subroutine uniform at location `Location` for shader stage `Shadertype`\nof the current program. `Location` must be less than the value of\n`?GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS` for the shader currently in use at\nshader stage `Shadertype`. The value of the subroutine uniform is returned in\n`Values`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetUniformSubroutine.xhtml)","ref":"gl.html#getUniformSubroutineuiv/2"},{"type":"function","title":"gl.getUniformuiv/2","doc":"[`gl:getUniform()`](`getUniformfv/2`) and `glGetnUniform` return in `Params` the\nvalue(s) of the specified uniform variable. The type of the uniform variable\nspecified by `Location` determines the number of values returned. If the uniform\nvariable is defined in the shader as a boolean, int, or float, a single value\nwill be returned. If it is defined as a vec2, ivec2, or bvec2, two values will\nbe returned. If it is defined as a vec3, ivec3, or bvec3, three values will be\nreturned, and so on. To query values stored in uniform variables declared as\narrays, call [`gl:getUniform()`](`getUniformfv/2`) for each element of the\narray. To query values stored in uniform variables declared as structures, call\n[`gl:getUniform()`](`getUniformfv/2`) for each field in the structure. The\nvalues for uniform variables declared as a matrix will be returned in column\nmajor order.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetUniform.xhtml)","ref":"gl.html#getUniformuiv/2"},{"type":"function","title":"gl.getVertexAttribdv/2","doc":"Equivalent to  getVertexAttribiv/2 .","ref":"gl.html#getVertexAttribdv/2"},{"type":"function","title":"gl.getVertexAttribfv/2","doc":"Equivalent to  getVertexAttribiv/2 .","ref":"gl.html#getVertexAttribfv/2"},{"type":"function","title":"gl.getVertexAttribIiv/2","doc":"Equivalent to  getVertexAttribiv/2 .","ref":"gl.html#getVertexAttribIiv/2"},{"type":"function","title":"gl.getVertexAttribIuiv/2","doc":"Equivalent to  getVertexAttribiv/2 .","ref":"gl.html#getVertexAttribIuiv/2"},{"type":"function","title":"gl.getVertexAttribiv/2","doc":"[`gl:getVertexAttrib()`](`getVertexAttribdv/2`) returns in `Params` the value of\na generic vertex attribute parameter. The generic vertex attribute to be queried\nis specified by `Index`, and the parameter to be queried is specified by\n`Pname`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetVertexAttrib.xhtml)","ref":"gl.html#getVertexAttribiv/2"},{"type":"function","title":"gl.getVertexAttribLdv/2","doc":"Equivalent to  getVertexAttribiv/2 .","ref":"gl.html#getVertexAttribLdv/2"},{"type":"function","title":"gl.hint/2","doc":"Certain aspects of GL behavior, when there is room for interpretation, can be\ncontrolled with hints. A hint is specified with two arguments. `Target` is a\nsymbolic constant indicating the behavior to be controlled, and `Mode` is\nanother symbolic constant indicating the desired behavior. The initial value for\neach `Target` is `?GL_DONT_CARE`. `Mode` can be one of the following:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glHint.xhtml)","ref":"gl.html#hint/2"},{"type":"function","title":"gl.histogram/4","doc":"When `?GL_HISTOGRAM` is enabled, RGBA color components are converted to\nhistogram table indices by clamping to the range \\[0,1], multiplying by the\nwidth of the histogram table, and rounding to the nearest integer. The table\nentries selected by the RGBA indices are then incremented. (If the internal\nformat of the histogram table includes luminance, then the index derived from\nthe R color component determines the luminance table entry to be incremented.)\nIf a histogram table entry is incremented beyond its maximum value, then its\nvalue becomes undefined. (This is not an error.)\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glHistogram.xml)","ref":"gl.html#histogram/4"},{"type":"type","title":"gl.i/0","doc":"","ref":"gl.html#t:i/0"},{"type":"function","title":"gl.indexd/1","doc":"Equivalent to  indexubv/1 .","ref":"gl.html#indexd/1"},{"type":"function","title":"gl.indexdv/1","doc":"Equivalent to  indexubv/1 .","ref":"gl.html#indexdv/1"},{"type":"function","title":"gl.indexf/1","doc":"Equivalent to  indexubv/1 .","ref":"gl.html#indexf/1"},{"type":"function","title":"gl.indexfv/1","doc":"Equivalent to  indexubv/1 .","ref":"gl.html#indexfv/1"},{"type":"function","title":"gl.indexi/1","doc":"Equivalent to  indexubv/1 .","ref":"gl.html#indexi/1"},{"type":"function","title":"gl.indexiv/1","doc":"Equivalent to  indexubv/1 .","ref":"gl.html#indexiv/1"},{"type":"function","title":"gl.indexMask/1","doc":"[`gl:indexMask/1`](`indexMask/1`) controls the writing of individual bits in the\ncolor index buffers. The least significant n bits of `Mask`, where n is the\nnumber of bits in a color index buffer, specify a mask. Where a 1 (one) appears\nin the mask, it's possible to write to the corresponding bit in the color index\nbuffer (or buffers). Where a 0 (zero) appears, the corresponding bit is\nwrite-protected.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glIndexMask.xml)","ref":"gl.html#indexMask/1"},{"type":"function","title":"gl.indexPointer/3","doc":"[`gl:indexPointer/3`](`indexPointer/3`) specifies the location and data format\nof an array of color indexes to use when rendering. `Type` specifies the data\ntype of each color index and `Stride` specifies the byte stride from one color\nindex to the next, allowing vertices and attributes to be packed into a single\narray or stored in separate arrays.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glIndexPointer.xml)","ref":"gl.html#indexPointer/3"},{"type":"function","title":"gl.indexs/1","doc":"Equivalent to  indexubv/1 .","ref":"gl.html#indexs/1"},{"type":"function","title":"gl.indexsv/1","doc":"Equivalent to  indexubv/1 .","ref":"gl.html#indexsv/1"},{"type":"function","title":"gl.indexub/1","doc":"Equivalent to  indexubv/1 .","ref":"gl.html#indexub/1"},{"type":"function","title":"gl.indexubv/1","doc":"[`gl:index()`](`indexd/1`) updates the current (single-valued) color index. It\ntakes one argument, the new value for the current color index.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glIndex.xml)","ref":"gl.html#indexubv/1"},{"type":"function","title":"gl.initNames/0","doc":"The name stack is used during selection mode to allow sets of rendering commands\nto be uniquely identified. It consists of an ordered set of unsigned integers.\n[`gl:initNames/0`](`initNames/0`) causes the name stack to be initialized to its\ndefault empty state.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glInitNames.xml)","ref":"gl.html#initNames/0"},{"type":"function","title":"gl.interleavedArrays/3","doc":"[`gl:interleavedArrays/3`](`interleavedArrays/3`) lets you specify and enable\nindividual color, normal, texture and vertex arrays whose elements are part of a\nlarger aggregate array element. For some implementations, this is more efficient\nthan specifying the arrays separately.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glInterleavedArrays.xml)","ref":"gl.html#interleavedArrays/3"},{"type":"function","title":"gl.invalidateBufferData/1","doc":"[`gl:invalidateBufferData/1`](`invalidateBufferData/1`) invalidates all of the\ncontent of the data store of a buffer object. After invalidation, the content of\nthe buffer's data store becomes undefined.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glInvalidateBufferData.xhtml)","ref":"gl.html#invalidateBufferData/1"},{"type":"function","title":"gl.invalidateBufferSubData/3","doc":"[`gl:invalidateBufferSubData/3`](`invalidateBufferSubData/3`) invalidates all or\npart of the content of the data store of a buffer object. After invalidation,\nthe content of the specified range of the buffer's data store becomes undefined.\nThe start of the range is given by `Offset` and its size is given by `Length`,\nboth measured in basic machine units.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glInvalidateBufferSubData.xhtml)","ref":"gl.html#invalidateBufferSubData/3"},{"type":"function","title":"gl.invalidateFramebuffer/2","doc":"[`gl:invalidateFramebuffer/2`](`invalidateFramebuffer/2`) and\n`glInvalidateNamedFramebufferData` invalidate the entire contents of a specified\nset of attachments of a framebuffer.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glInvalidateFramebuffer.xhtml)","ref":"gl.html#invalidateFramebuffer/2"},{"type":"function","title":"gl.invalidateSubFramebuffer/6","doc":"[`gl:invalidateSubFramebuffer/6`](`invalidateSubFramebuffer/6`) and\n`glInvalidateNamedFramebufferSubData` invalidate the contents of a specified\nregion of a specified set of attachments of a framebuffer.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glInvalidateSubFramebuffer.xhtml)","ref":"gl.html#invalidateSubFramebuffer/6"},{"type":"function","title":"gl.invalidateTexImage/2","doc":"[`gl:invalidateTexSubImage/8`](`invalidateTexSubImage/8`) invalidates all of a\ntexture image. `Texture` and `Level` indicated which texture image is being\ninvalidated. After this command, data in the texture image has undefined values.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glInvalidateTexImage.xhtml)","ref":"gl.html#invalidateTexImage/2"},{"type":"function","title":"gl.invalidateTexSubImage/8","doc":"[`gl:invalidateTexSubImage/8`](`invalidateTexSubImage/8`) invalidates all or\npart of a texture image. `Texture` and `Level` indicated which texture image is\nbeing invalidated. After this command, data in that subregion have undefined\nvalues. `Xoffset`, `Yoffset`, `Zoffset`, `Width`, `Height`, and `Depth` are\ninterpreted as they are in [`gl:texSubImage3D/11`](`texSubImage3D/11`). For\ntexture targets that don't have certain dimensions, this command treats those\ndimensions as having a size of 1. For example, to invalidate a portion of a two-\ndimensional texture, the application would use `Zoffset` equal to zero and\n`Depth` equal to one. Cube map textures are treated as an array of six slices in\nthe z-dimension, where a value of `Zoffset` is interpreted as specifying face\n`?GL_TEXTURE_CUBE_MAP_POSITIVE_X` \\+ `Zoffset`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glInvalidateTexSubImage.xhtml)","ref":"gl.html#invalidateTexSubImage/8"},{"type":"function","title":"gl.isBuffer/1","doc":"[`gl:isBuffer/1`](`isBuffer/1`) returns `?GL_TRUE` if `Buffer` is currently the\nname of a buffer object. If `Buffer` is zero, or is a non-zero value that is not\ncurrently the name of a buffer object, or if an error occurs,\n[`gl:isBuffer/1`](`isBuffer/1`) returns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsBuffer.xhtml)","ref":"gl.html#isBuffer/1"},{"type":"function","title":"gl.isEnabled/1","doc":"Equivalent to  isEnabledi/2 .","ref":"gl.html#isEnabled/1"},{"type":"function","title":"gl.isEnabledi/2","doc":"[`gl:isEnabled/1`](`isEnabled/1`) returns `?GL_TRUE` if `Cap` is an enabled\ncapability and returns `?GL_FALSE` otherwise. Boolean states that are indexed\nmay be tested with [`gl:isEnabledi/2`](`isEnabled/1`). For\n[`gl:isEnabledi/2`](`isEnabled/1`), `Index` specifies the index of the\ncapability to test. `Index` must be between zero and the count of indexed\ncapabilities for `Cap`. Initially all capabilities except `?GL_DITHER` are\ndisabled; `?GL_DITHER` is initially enabled.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsEnabled.xhtml)","ref":"gl.html#isEnabledi/2"},{"type":"function","title":"gl.isFramebuffer/1","doc":"[`gl:isFramebuffer/1`](`isFramebuffer/1`) returns `?GL_TRUE` if `Framebuffer` is\ncurrently the name of a framebuffer object. If `Framebuffer` is zero, or if\n`?framebuffer` is not the name of a framebuffer object, or if an error occurs,\n[`gl:isFramebuffer/1`](`isFramebuffer/1`) returns `?GL_FALSE`. If `Framebuffer`\nis a name returned by [`gl:genFramebuffers/1`](`genFramebuffers/1`), by that has\nnot yet been bound through a call to\n[`gl:bindFramebuffer/2`](`bindFramebuffer/2`), then the name is not a\nframebuffer object and [`gl:isFramebuffer/1`](`isFramebuffer/1`) returns\n`?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsFramebuffer.xhtml)","ref":"gl.html#isFramebuffer/1"},{"type":"function","title":"gl.isList/1","doc":"[`gl:isList/1`](`isList/1`) returns `?GL_TRUE` if `List` is the name of a\ndisplay list and returns `?GL_FALSE` if it is not, or if an error occurs.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glIsList.xml)","ref":"gl.html#isList/1"},{"type":"function","title":"gl.isProgram/1","doc":"[`gl:isProgram/1`](`isProgram/1`) returns `?GL_TRUE` if `Program` is the name of\na program object previously created with\n[`gl:createProgram/0`](`createProgram/0`) and not yet deleted with\n[`gl:deleteProgram/1`](`deleteProgram/1`). If `Program` is zero or a non-zero\nvalue that is not the name of a program object, or if an error occurs,\n[`gl:isProgram/1`](`isProgram/1`) returns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsProgram.xhtml)","ref":"gl.html#isProgram/1"},{"type":"function","title":"gl.isProgramPipeline/1","doc":"[`gl:isProgramPipeline/1`](`isProgramPipeline/1`) returns `?GL_TRUE` if\n`Pipeline` is currently the name of a program pipeline object. If `Pipeline` is\nzero, or if `?pipeline` is not the name of a program pipeline object, or if an\nerror occurs, [`gl:isProgramPipeline/1`](`isProgramPipeline/1`) returns\n`?GL_FALSE`. If `Pipeline` is a name returned by\n[`gl:genProgramPipelines/1`](`genProgramPipelines/1`), but that has not yet been\nbound through a call to [`gl:bindProgramPipeline/1`](`bindProgramPipeline/1`),\nthen the name is not a program pipeline object and\n[`gl:isProgramPipeline/1`](`isProgramPipeline/1`) returns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsProgramPipeline.xhtml)","ref":"gl.html#isProgramPipeline/1"},{"type":"function","title":"gl.isQuery/1","doc":"[`gl:isQuery/1`](`isQuery/1`) returns `?GL_TRUE` if `Id` is currently the name\nof a query object. If `Id` is zero, or is a non-zero value that is not currently\nthe name of a query object, or if an error occurs, [`gl:isQuery/1`](`isQuery/1`)\nreturns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsQuery.xhtml)","ref":"gl.html#isQuery/1"},{"type":"function","title":"gl.isRenderbuffer/1","doc":"[`gl:isRenderbuffer/1`](`isRenderbuffer/1`) returns `?GL_TRUE` if `Renderbuffer`\nis currently the name of a renderbuffer object. If `Renderbuffer` is zero, or if\n`Renderbuffer` is not the name of a renderbuffer object, or if an error occurs,\n[`gl:isRenderbuffer/1`](`isRenderbuffer/1`) returns `?GL_FALSE`. If\n`Renderbuffer` is a name returned by\n[`gl:genRenderbuffers/1`](`genRenderbuffers/1`), by that has not yet been bound\nthrough a call to [`gl:bindRenderbuffer/2`](`bindRenderbuffer/2`) or\n[`gl:framebufferRenderbuffer/4`](`framebufferRenderbuffer/4`), then the name is\nnot a renderbuffer object and [`gl:isRenderbuffer/1`](`isRenderbuffer/1`)\nreturns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsRenderbuffer.xhtml)","ref":"gl.html#isRenderbuffer/1"},{"type":"function","title":"gl.isSampler/1","doc":"[`gl:isSampler/1`](`isSampler/1`) returns `?GL_TRUE` if `Id` is currently the\nname of a sampler object. If `Id` is zero, or is a non-zero value that is not\ncurrently the name of a sampler object, or if an error occurs,\n[`gl:isSampler/1`](`isSampler/1`) returns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsSampler.xhtml)","ref":"gl.html#isSampler/1"},{"type":"function","title":"gl.isShader/1","doc":"[`gl:isShader/1`](`isShader/1`) returns `?GL_TRUE` if `Shader` is the name of a\nshader object previously created with [`gl:createShader/1`](`createShader/1`)\nand not yet deleted with [`gl:deleteShader/1`](`deleteShader/1`). If `Shader` is\nzero or a non-zero value that is not the name of a shader object, or if an error\noccurs, `glIsShader `returns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsShader.xhtml)","ref":"gl.html#isShader/1"},{"type":"function","title":"gl.isSync/1","doc":"[`gl:isSync/1`](`isSync/1`) returns `?GL_TRUE` if `Sync` is currently the name\nof a sync object. If `Sync` is not the name of a sync object, or if an error\noccurs, [`gl:isSync/1`](`isSync/1`) returns `?GL_FALSE`. Note that zero is not\nthe name of a sync object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsSync.xhtml)","ref":"gl.html#isSync/1"},{"type":"function","title":"gl.isTexture/1","doc":"[`gl:isTexture/1`](`isTexture/1`) returns `?GL_TRUE` if `Texture` is currently\nthe name of a texture. If `Texture` is zero, or is a non-zero value that is not\ncurrently the name of a texture, or if an error occurs,\n[`gl:isTexture/1`](`isTexture/1`) returns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsTexture.xhtml)","ref":"gl.html#isTexture/1"},{"type":"function","title":"gl.isTransformFeedback/1","doc":"[`gl:isTransformFeedback/1`](`isTransformFeedback/1`) returns `?GL_TRUE` if `Id`\nis currently the name of a transform feedback object. If `Id` is zero, or if\n`?id` is not the name of a transform feedback object, or if an error occurs,\n[`gl:isTransformFeedback/1`](`isTransformFeedback/1`) returns `?GL_FALSE`. If\n`Id` is a name returned by\n[`gl:genTransformFeedbacks/1`](`genTransformFeedbacks/1`), but that has not yet\nbeen bound through a call to\n[`gl:bindTransformFeedback/2`](`bindTransformFeedback/2`), then the name is not\na transform feedback object and\n[`gl:isTransformFeedback/1`](`isTransformFeedback/1`) returns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsTransformFeedback.xhtml)","ref":"gl.html#isTransformFeedback/1"},{"type":"function","title":"gl.isVertexArray/1","doc":"[`gl:isVertexArray/1`](`isVertexArray/1`) returns `?GL_TRUE` if `Array` is\ncurrently the name of a vertex array object. If `Array` is zero, or if `Array`\nis not the name of a vertex array object, or if an error occurs,\n[`gl:isVertexArray/1`](`isVertexArray/1`) returns `?GL_FALSE`. If `Array` is a\nname returned by [`gl:genVertexArrays/1`](`genVertexArrays/1`), by that has not\nyet been bound through a call to [`gl:bindVertexArray/1`](`bindVertexArray/1`),\nthen the name is not a vertex array object and\n[`gl:isVertexArray/1`](`isVertexArray/1`) returns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsVertexArray.xhtml)","ref":"gl.html#isVertexArray/1"},{"type":"function","title":"gl.lightf/3","doc":"Equivalent to  lightiv/3 .","ref":"gl.html#lightf/3"},{"type":"function","title":"gl.lightfv/3","doc":"Equivalent to  lightiv/3 .","ref":"gl.html#lightfv/3"},{"type":"function","title":"gl.lighti/3","doc":"Equivalent to  lightiv/3 .","ref":"gl.html#lighti/3"},{"type":"function","title":"gl.lightiv/3","doc":"[`gl:light()`](`lightf/3`) sets the values of individual light source\nparameters. `Light` names the light and is a symbolic name of the form\n`?GL_LIGHT` i, where i ranges from 0 to the value of `?GL_MAX_LIGHTS` \\- 1.\n`Pname` specifies one of ten light source parameters, again by symbolic name.\n`Params` is either a single value or a pointer to an array that contains the new\nvalues.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glLight.xml)","ref":"gl.html#lightiv/3"},{"type":"function","title":"gl.lightModelf/2","doc":"Equivalent to  lightModeliv/2 .","ref":"gl.html#lightModelf/2"},{"type":"function","title":"gl.lightModelfv/2","doc":"Equivalent to  lightModeliv/2 .","ref":"gl.html#lightModelfv/2"},{"type":"function","title":"gl.lightModeli/2","doc":"Equivalent to  lightModeliv/2 .","ref":"gl.html#lightModeli/2"},{"type":"function","title":"gl.lightModeliv/2","doc":"[`gl:lightModel()`](`lightModelf/2`) sets the lighting model parameter. `Pname`\nnames a parameter and `Params` gives the new value. There are three lighting\nmodel parameters:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glLightModel.xml)","ref":"gl.html#lightModeliv/2"},{"type":"function","title":"gl.lineStipple/2","doc":"Line stippling masks out certain fragments produced by rasterization; those\nfragments will not be drawn. The masking is achieved by using three parameters:\nthe 16-bit line stipple pattern `Pattern`, the repeat count `Factor`, and an\ninteger stipple counter s.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glLineStipple.xml)","ref":"gl.html#lineStipple/2"},{"type":"function","title":"gl.lineWidth/1","doc":"[`gl:lineWidth/1`](`lineWidth/1`) specifies the rasterized width of both aliased\nand antialiased lines. Using a line width other than 1 has different effects,\ndepending on whether line antialiasing is enabled. To enable and disable line\nantialiasing, call [`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`)\nwith argument `?GL_LINE_SMOOTH`. Line antialiasing is initially disabled.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glLineWidth.xhtml)","ref":"gl.html#lineWidth/1"},{"type":"function","title":"gl.linkProgram/1","doc":"[`gl:linkProgram/1`](`linkProgram/1`) links the program object specified by\n`Program`. If any shader objects of type `?GL_VERTEX_SHADER` are attached to\n`Program`, they will be used to create an executable that will run on the\nprogrammable vertex processor. If any shader objects of type\n`?GL_GEOMETRY_SHADER` are attached to `Program`, they will be used to create an\nexecutable that will run on the programmable geometry processor. If any shader\nobjects of type `?GL_FRAGMENT_SHADER` are attached to `Program`, they will be\nused to create an executable that will run on the programmable fragment\nprocessor.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glLinkProgram.xhtml)","ref":"gl.html#linkProgram/1"},{"type":"function","title":"gl.listBase/1","doc":"[`gl:callLists/1`](`callLists/1`) specifies an array of offsets. Display-list\nnames are generated by adding `Base` to each offset. Names that reference valid\ndisplay lists are executed; the others are ignored.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glListBase.xml)","ref":"gl.html#listBase/1"},{"type":"function","title":"gl.loadIdentity/0","doc":"[`gl:loadIdentity/0`](`loadIdentity/0`) replaces the current matrix with the\nidentity matrix. It is semantically equivalent to calling\n[`gl:loadMatrix()`](`loadMatrixd/1`) with the identity matrix\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glLoadIdentity.xml)","ref":"gl.html#loadIdentity/0"},{"type":"function","title":"gl.loadMatrixd/1","doc":"Equivalent to  loadMatrixf/1 .","ref":"gl.html#loadMatrixd/1"},{"type":"function","title":"gl.loadMatrixf/1","doc":"[`gl:loadMatrix()`](`loadMatrixd/1`) replaces the current matrix with the one\nwhose elements are specified by `M`. The current matrix is the projection\nmatrix, modelview matrix, or texture matrix, depending on the current matrix\nmode (see [`gl:matrixMode/1`](`matrixMode/1`)).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glLoadMatrix.xml)","ref":"gl.html#loadMatrixf/1"},{"type":"function","title":"gl.loadName/1","doc":"The name stack is used during selection mode to allow sets of rendering commands\nto be uniquely identified. It consists of an ordered set of unsigned integers\nand is initially empty.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glLoadName.xml)","ref":"gl.html#loadName/1"},{"type":"function","title":"gl.loadTransposeMatrixd/1","doc":"Equivalent to  loadTransposeMatrixf/1 .","ref":"gl.html#loadTransposeMatrixd/1"},{"type":"function","title":"gl.loadTransposeMatrixf/1","doc":"[`gl:loadTransposeMatrix()`](`loadTransposeMatrixf/1`) replaces the current\nmatrix with the one whose elements are specified by `M`. The current matrix is\nthe projection matrix, modelview matrix, or texture matrix, depending on the\ncurrent matrix mode (see [`gl:matrixMode/1`](`matrixMode/1`)).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glLoadTransposeMatrix.xml)","ref":"gl.html#loadTransposeMatrixf/1"},{"type":"function","title":"gl.logicOp/1","doc":"[`gl:logicOp/1`](`logicOp/1`) specifies a logical operation that, when enabled,\nis applied between the incoming RGBA color and the RGBA color at the\ncorresponding location in the frame buffer. To enable or disable the logical\noperation, call [`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`)\nusing the symbolic constant `?GL_COLOR_LOGIC_OP`. The initial value is disabled.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glLogicOp.xhtml)","ref":"gl.html#logicOp/1"},{"type":"type","title":"gl.m12/0","doc":"","ref":"gl.html#t:m12/0"},{"type":"type","title":"gl.m16/0","doc":"","ref":"gl.html#t:m16/0"},{"type":"function","title":"gl.map1d/6","doc":"Equivalent to  map1f/6 .","ref":"gl.html#map1d/6"},{"type":"function","title":"gl.map1f/6","doc":"Evaluators provide a way to use polynomial or rational polynomial mapping to\nproduce vertices, normals, texture coordinates, and colors. The values produced\nby an evaluator are sent to further stages of GL processing just as if they had\nbeen presented using [`gl:vertex()`](`vertex2d/2`),\n[`gl:normal()`](`normal3b/3`), [`gl:texCoord()`](`texCoord1d/1`), and\n[`gl:color()`](`color3b/3`) commands, except that the generated values do not\nupdate the current normal, texture coordinates, or color.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glMap1.xml)","ref":"gl.html#map1f/6"},{"type":"function","title":"gl.map2d/10","doc":"Equivalent to  map2f/10 .","ref":"gl.html#map2d/10"},{"type":"function","title":"gl.map2f/10","doc":"Evaluators provide a way to use polynomial or rational polynomial mapping to\nproduce vertices, normals, texture coordinates, and colors. The values produced\nby an evaluator are sent on to further stages of GL processing just as if they\nhad been presented using [`gl:vertex()`](`vertex2d/2`),\n[`gl:normal()`](`normal3b/3`), [`gl:texCoord()`](`texCoord1d/1`), and\n[`gl:color()`](`color3b/3`) commands, except that the generated values do not\nupdate the current normal, texture coordinates, or color.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glMap2.xml)","ref":"gl.html#map2f/10"},{"type":"function","title":"gl.mapGrid1d/3","doc":"Equivalent to  mapGrid2f/6 .","ref":"gl.html#mapGrid1d/3"},{"type":"function","title":"gl.mapGrid1f/3","doc":"Equivalent to  mapGrid2f/6 .","ref":"gl.html#mapGrid1f/3"},{"type":"function","title":"gl.mapGrid2d/6","doc":"Equivalent to  mapGrid2f/6 .","ref":"gl.html#mapGrid2d/6"},{"type":"function","title":"gl.mapGrid2f/6","doc":"[`gl:mapGrid()`](`mapGrid1d/3`) and [`gl:evalMesh()`](`evalMesh1/3`) are used\ntogether to efficiently generate and evaluate a series of evenly-spaced map\ndomain values. [`gl:evalMesh()`](`evalMesh1/3`) steps through the integer domain\nof a one- or two-dimensional grid, whose range is the domain of the evaluation\nmaps specified by `glMap1` and `glMap2`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glMapGrid.xml)","ref":"gl.html#mapGrid2f/6"},{"type":"function","title":"gl.materialf/3","doc":"Equivalent to  materialiv/3 .","ref":"gl.html#materialf/3"},{"type":"function","title":"gl.materialfv/3","doc":"Equivalent to  materialiv/3 .","ref":"gl.html#materialfv/3"},{"type":"function","title":"gl.materiali/3","doc":"Equivalent to  materialiv/3 .","ref":"gl.html#materiali/3"},{"type":"function","title":"gl.materialiv/3","doc":"[`gl:material()`](`materialf/3`) assigns values to material parameters. There\nare two matched sets of material parameters. One, the `front-facing` set, is\nused to shade points, lines, bitmaps, and all polygons (when two-sided lighting\nis disabled), or just front-facing polygons (when two-sided lighting is\nenabled). The other set, `back-facing`, is used to shade back-facing polygons\nonly when two-sided lighting is enabled. Refer to the\n[`gl:lightModel()`](`lightModelf/2`) reference page for details concerning one-\nand two-sided lighting calculations.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glMaterial.xml)","ref":"gl.html#materialiv/3"},{"type":"type","title":"gl.matrix/0","doc":"","ref":"gl.html#t:matrix/0"},{"type":"function","title":"gl.matrixMode/1","doc":"[`gl:matrixMode/1`](`matrixMode/1`) sets the current matrix mode. `Mode` can\nassume one of four values:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glMatrixMode.xml)","ref":"gl.html#matrixMode/1"},{"type":"type","title":"gl.mem/0","doc":"","ref":"gl.html#t:mem/0"},{"type":"function","title":"gl.memoryBarrier/1","doc":"Equivalent to  memoryBarrierByRegion/1 .","ref":"gl.html#memoryBarrier/1"},{"type":"function","title":"gl.memoryBarrierByRegion/1","doc":"[`gl:memoryBarrier/1`](`memoryBarrier/1`) defines a barrier ordering the memory\ntransactions issued prior to the command relative to those issued after the\nbarrier. For the purposes of this ordering, memory transactions performed by\nshaders are considered to be issued by the rendering command that triggered the\nexecution of the shader. `Barriers` is a bitfield indicating the set of\noperations that are synchronized with shader stores; the bits used in `Barriers`\nare as follows:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glMemoryBarrier.xhtml)","ref":"gl.html#memoryBarrierByRegion/1"},{"type":"function","title":"gl.minmax/3","doc":"When `?GL_MINMAX` is enabled, the RGBA components of incoming pixels are\ncompared to the minimum and maximum values for each component, which are stored\nin the two-element minmax table. (The first element stores the minima, and the\nsecond element stores the maxima.) If a pixel component is greater than the\ncorresponding component in the maximum element, then the maximum element is\nupdated with the pixel component value. If a pixel component is less than the\ncorresponding component in the minimum element, then the minimum element is\nupdated with the pixel component value. (In both cases, if the internal format\nof the minmax table includes luminance, then the R color component of incoming\npixels is used for comparison.) The contents of the minmax table may be\nretrieved at a later time by calling [`gl:getMinmax/5`](`getMinmax/5`). The\nminmax operation is enabled or disabled by calling [`gl:enable/1`](`enable/1`)\nor [`gl:disable/1`](`enable/1`), respectively, with an argument of `?GL_MINMAX`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glMinmax.xml)","ref":"gl.html#minmax/3"},{"type":"function","title":"gl.minSampleShading/1","doc":"[`gl:minSampleShading/1`](`minSampleShading/1`) specifies the rate at which\nsamples are shaded within a covered pixel. Sample-rate shading is enabled by\ncalling [`gl:enable/1`](`enable/1`) with the parameter `?GL_SAMPLE_SHADING`. If\n`?GL_MULTISAMPLE` or `?GL_SAMPLE_SHADING` is disabled, sample shading has no\neffect. Otherwise, an implementation must provide at least as many unique color\nvalues for each covered fragment as specified by `Value` times `Samples` where\n`Samples` is the value of `?GL_SAMPLES` for the current framebuffer. At least 1\nsample for each covered fragment is generated.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glMinSampleShading.xhtml)","ref":"gl.html#minSampleShading/1"},{"type":"function","title":"gl.multiDrawArrays/3","doc":"[`gl:multiDrawArrays/3`](`multiDrawArrays/3`) specifies multiple sets of\ngeometric primitives with very few subroutine calls. Instead of calling a GL\nprocedure to pass each individual vertex, normal, texture coordinate, edge flag,\nor color, you can prespecify separate arrays of vertices, normals, and colors\nand use them to construct a sequence of primitives with a single call to\n[`gl:multiDrawArrays/3`](`multiDrawArrays/3`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glMultiDrawArrays.xhtml)","ref":"gl.html#multiDrawArrays/3"},{"type":"function","title":"gl.multiDrawArraysIndirect/4","doc":"[`gl:multiDrawArraysIndirect/4`](`multiDrawArraysIndirect/4`) specifies multiple\ngeometric primitives with very few subroutine calls.\n[`gl:multiDrawArraysIndirect/4`](`multiDrawArraysIndirect/4`) behaves similarly\nto a multitude of calls to\n[`gl:drawArraysInstancedBaseInstance/5`](`drawArraysInstancedBaseInstance/5`),\nexecept that the parameters to each call to\n[`gl:drawArraysInstancedBaseInstance/5`](`drawArraysInstancedBaseInstance/5`)\nare stored in an array in memory at the address given by `Indirect`, separated\nby the stride, in basic machine units, specified by `Stride`. If `Stride` is\nzero, then the array is assumed to be tightly packed in memory.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glMultiDrawArraysIndirect.xhtml)","ref":"gl.html#multiDrawArraysIndirect/4"},{"type":"function","title":"gl.multiDrawArraysIndirectCount/5","doc":"No documentation available.","ref":"gl.html#multiDrawArraysIndirectCount/5"},{"type":"function","title":"gl.multiTexCoord1d/2","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord1d/2"},{"type":"function","title":"gl.multiTexCoord1dv/2","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord1dv/2"},{"type":"function","title":"gl.multiTexCoord1f/2","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord1f/2"},{"type":"function","title":"gl.multiTexCoord1fv/2","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord1fv/2"},{"type":"function","title":"gl.multiTexCoord1i/2","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord1i/2"},{"type":"function","title":"gl.multiTexCoord1iv/2","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord1iv/2"},{"type":"function","title":"gl.multiTexCoord1s/2","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord1s/2"},{"type":"function","title":"gl.multiTexCoord1sv/2","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord1sv/2"},{"type":"function","title":"gl.multiTexCoord2d/3","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord2d/3"},{"type":"function","title":"gl.multiTexCoord2dv/2","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord2dv/2"},{"type":"function","title":"gl.multiTexCoord2f/3","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord2f/3"},{"type":"function","title":"gl.multiTexCoord2fv/2","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord2fv/2"},{"type":"function","title":"gl.multiTexCoord2i/3","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord2i/3"},{"type":"function","title":"gl.multiTexCoord2iv/2","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord2iv/2"},{"type":"function","title":"gl.multiTexCoord2s/3","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord2s/3"},{"type":"function","title":"gl.multiTexCoord2sv/2","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord2sv/2"},{"type":"function","title":"gl.multiTexCoord3d/4","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord3d/4"},{"type":"function","title":"gl.multiTexCoord3dv/2","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord3dv/2"},{"type":"function","title":"gl.multiTexCoord3f/4","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord3f/4"},{"type":"function","title":"gl.multiTexCoord3fv/2","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord3fv/2"},{"type":"function","title":"gl.multiTexCoord3i/4","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord3i/4"},{"type":"function","title":"gl.multiTexCoord3iv/2","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord3iv/2"},{"type":"function","title":"gl.multiTexCoord3s/4","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord3s/4"},{"type":"function","title":"gl.multiTexCoord3sv/2","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord3sv/2"},{"type":"function","title":"gl.multiTexCoord4d/5","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord4d/5"},{"type":"function","title":"gl.multiTexCoord4dv/2","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord4dv/2"},{"type":"function","title":"gl.multiTexCoord4f/5","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord4f/5"},{"type":"function","title":"gl.multiTexCoord4fv/2","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord4fv/2"},{"type":"function","title":"gl.multiTexCoord4i/5","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord4i/5"},{"type":"function","title":"gl.multiTexCoord4iv/2","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord4iv/2"},{"type":"function","title":"gl.multiTexCoord4s/5","doc":"Equivalent to  multiTexCoord4sv/2 .","ref":"gl.html#multiTexCoord4s/5"},{"type":"function","title":"gl.multiTexCoord4sv/2","doc":"[`gl:multiTexCoord()`](`multiTexCoord1d/2`) specifies texture coordinates in\none, two, three, or four dimensions.\n[`gl:multiTexCoord1()`](`multiTexCoord1d/2`) sets the current texture\ncoordinates to (s 0 0 1); a call to [`gl:multiTexCoord2()`](`multiTexCoord1d/2`)\nsets them to (s t 0 1). Similarly, [`gl:multiTexCoord3()`](`multiTexCoord1d/2`)\nspecifies the texture coordinates as (s t r 1), and\n[`gl:multiTexCoord4()`](`multiTexCoord1d/2`) defines all four components\nexplicitly as (s t r q).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glMultiTexCoord.xml)","ref":"gl.html#multiTexCoord4sv/2"},{"type":"function","title":"gl.multMatrixd/1","doc":"Equivalent to  multMatrixf/1 .","ref":"gl.html#multMatrixd/1"},{"type":"function","title":"gl.multMatrixf/1","doc":"[`gl:multMatrix()`](`multMatrixd/1`) multiplies the current matrix with the one\nspecified using `M`, and replaces the current matrix with the product.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glMultMatrix.xml)","ref":"gl.html#multMatrixf/1"},{"type":"function","title":"gl.multTransposeMatrixd/1","doc":"Equivalent to  multTransposeMatrixf/1 .","ref":"gl.html#multTransposeMatrixd/1"},{"type":"function","title":"gl.multTransposeMatrixf/1","doc":"[`gl:multTransposeMatrix()`](`multTransposeMatrixf/1`) multiplies the current\nmatrix with the one specified using `M`, and replaces the current matrix with\nthe product.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glMultTransposeMatrix.xml)","ref":"gl.html#multTransposeMatrixf/1"},{"type":"function","title":"gl.newList/2","doc":"Display lists are groups of GL commands that have been stored for subsequent\nexecution. Display lists are created with [`gl:newList/2`](`newList/2`). All\nsubsequent commands are placed in the display list, in the order issued, until\n[`gl:endList/0`](`newList/2`) is called.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glNewList.xml)","ref":"gl.html#newList/2"},{"type":"function","title":"gl.normal3b/3","doc":"Equivalent to  normal3sv/1 .","ref":"gl.html#normal3b/3"},{"type":"function","title":"gl.normal3bv/1","doc":"Equivalent to  normal3sv/1 .","ref":"gl.html#normal3bv/1"},{"type":"function","title":"gl.normal3d/3","doc":"Equivalent to  normal3sv/1 .","ref":"gl.html#normal3d/3"},{"type":"function","title":"gl.normal3dv/1","doc":"Equivalent to  normal3sv/1 .","ref":"gl.html#normal3dv/1"},{"type":"function","title":"gl.normal3f/3","doc":"Equivalent to  normal3sv/1 .","ref":"gl.html#normal3f/3"},{"type":"function","title":"gl.normal3fv/1","doc":"Equivalent to  normal3sv/1 .","ref":"gl.html#normal3fv/1"},{"type":"function","title":"gl.normal3i/3","doc":"Equivalent to  normal3sv/1 .","ref":"gl.html#normal3i/3"},{"type":"function","title":"gl.normal3iv/1","doc":"Equivalent to  normal3sv/1 .","ref":"gl.html#normal3iv/1"},{"type":"function","title":"gl.normal3s/3","doc":"Equivalent to  normal3sv/1 .","ref":"gl.html#normal3s/3"},{"type":"function","title":"gl.normal3sv/1","doc":"The current normal is set to the given coordinates whenever\n[`gl:normal()`](`normal3b/3`) is issued. Byte, short, or integer arguments are\nconverted to floating-point format with a linear mapping that maps the most\npositive representable integer value to 1.0 and the most negative representable\ninteger value to -1.0.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glNormal.xml)","ref":"gl.html#normal3sv/1"},{"type":"function","title":"gl.normalPointer/3","doc":"[`gl:normalPointer/3`](`normalPointer/3`) specifies the location and data format\nof an array of normals to use when rendering. `Type` specifies the data type of\neach normal coordinate, and `Stride` specifies the byte stride from one normal\nto the next, allowing vertices and attributes to be packed into a single array\nor stored in separate arrays. (Single-array storage may be more efficient on\nsome implementations; see [`gl:interleavedArrays/3`](`interleavedArrays/3`).)\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glNormalPointer.xml)","ref":"gl.html#normalPointer/3"},{"type":"function","title":"gl.objectPtrLabel/3","doc":"[`gl:objectPtrLabel/3`](`objectPtrLabel/3`) labels the sync object identified by\n`Ptr`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glObjectPtrLabel.xhtml)","ref":"gl.html#objectPtrLabel/3"},{"type":"type","title":"gl.offset/0","doc":"","ref":"gl.html#t:offset/0"},{"type":"function","title":"gl.ortho/6","doc":"[`gl:ortho/6`](`ortho/6`) describes a transformation that produces a parallel\nprojection. The current matrix (see [`gl:matrixMode/1`](`matrixMode/1`)) is\nmultiplied by this matrix and the result replaces the current matrix, as if\n[`gl:multMatrix()`](`multMatrixd/1`) were called with the following matrix as\nits argument:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glOrtho.xml)","ref":"gl.html#ortho/6"},{"type":"function","title":"gl.passThrough/1","doc":"[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPassThrough.xml)","ref":"gl.html#passThrough/1"},{"type":"function","title":"gl.patchParameterfv/2","doc":"Equivalent to  patchParameteri/2 .","ref":"gl.html#patchParameterfv/2"},{"type":"function","title":"gl.patchParameteri/2","doc":"[`gl:patchParameter()`](`patchParameteri/2`) specifies the parameters that will\nbe used for patch primitives. `Pname` specifies the parameter to modify and must\nbe either `?GL_PATCH_VERTICES`, `?GL_PATCH_DEFAULT_OUTER_LEVEL` or\n`?GL_PATCH_DEFAULT_INNER_LEVEL`. For\n[`gl:patchParameteri/2`](`patchParameteri/2`), `Value` specifies the new value\nfor the parameter specified by `Pname`. For\n[`gl:patchParameterfv/2`](`patchParameteri/2`), `Values` specifies the address\nof an array containing the new values for the parameter specified by `Pname`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPatchParameter.xhtml)","ref":"gl.html#patchParameteri/2"},{"type":"function","title":"gl.pauseTransformFeedback/0","doc":"[`gl:pauseTransformFeedback/0`](`pauseTransformFeedback/0`) pauses transform\nfeedback operations on the currently active transform feedback object. When\ntransform feedback operations are paused, transform feedback is still considered\nactive and changing most transform feedback state related to the object results\nin an error. However, a new transform feedback object may be bound while\ntransform feedback is paused.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPauseTransformFeedback.xhtml)","ref":"gl.html#pauseTransformFeedback/0"},{"type":"function","title":"gl.pixelMapfv/3","doc":"Equivalent to  pixelMapusv/3 .","ref":"gl.html#pixelMapfv/3"},{"type":"function","title":"gl.pixelMapuiv/3","doc":"Equivalent to  pixelMapusv/3 .","ref":"gl.html#pixelMapuiv/3"},{"type":"function","title":"gl.pixelMapusv/3","doc":"[`gl:pixelMap()`](`pixelMapfv/3`) sets up translation tables, or `maps`, used by\n[`gl:copyPixels/5`](`copyPixels/5`),\n[`gl:copyTexImage1D/7`](`copyTexImage1D/7`),\n[`gl:copyTexImage2D/8`](`copyTexImage2D/8`),\n[`gl:copyTexSubImage1D/6`](`copyTexSubImage1D/6`),\n[`gl:copyTexSubImage2D/8`](`copyTexSubImage2D/8`),\n[`gl:copyTexSubImage3D/9`](`copyTexSubImage3D/9`),\n[`gl:drawPixels/5`](`drawPixels/5`), [`gl:readPixels/7`](`readPixels/7`),\n[`gl:texImage1D/8`](`texImage1D/8`), [`gl:texImage2D/9`](`texImage2D/9`),\n[`gl:texImage3D/10`](`texImage3D/10`),\n[`gl:texSubImage1D/7`](`texSubImage1D/7`),\n[`gl:texSubImage2D/9`](`texSubImage2D/9`), and\n[`gl:texSubImage3D/11`](`texSubImage3D/11`). Additionally, if the ARB_imaging\nsubset is supported, the routines [`gl:colorTable/6`](`colorTable/6`),\n[`gl:colorSubTable/6`](`colorSubTable/6`),\n[`gl:convolutionFilter1D/6`](`convolutionFilter1D/6`),\n[`gl:convolutionFilter2D/7`](`convolutionFilter2D/7`),\n[`gl:histogram/4`](`histogram/4`), [`gl:minmax/3`](`minmax/3`), and\n[`gl:separableFilter2D/8`](`separableFilter2D/8`). Use of these maps is\ndescribed completely in the [`gl:pixelTransfer()`](`pixelTransferf/2`) reference\npage, and partly in the reference pages for the pixel and texture image\ncommands. Only the specification of the maps is described in this reference\npage.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPixelMap.xml)","ref":"gl.html#pixelMapusv/3"},{"type":"function","title":"gl.pixelStoref/2","doc":"Equivalent to  pixelStorei/2 .","ref":"gl.html#pixelStoref/2"},{"type":"function","title":"gl.pixelStorei/2","doc":"[`gl:pixelStore()`](`pixelStoref/2`) sets pixel storage modes that affect the\noperation of subsequent [`gl:readPixels/7`](`readPixels/7`) as well as the\nunpacking of texture patterns (see [`gl:texImage1D/8`](`texImage1D/8`),\n[`gl:texImage2D/9`](`texImage2D/9`), [`gl:texImage3D/10`](`texImage3D/10`),\n[`gl:texSubImage1D/7`](`texSubImage1D/7`),\n[`gl:texSubImage2D/9`](`texSubImage2D/9`),\n[`gl:texSubImage3D/11`](`texSubImage3D/11`)),\n[`gl:compressedTexImage1D/7`](`compressedTexImage1D/7`),\n[`gl:compressedTexImage2D/8`](`compressedTexImage2D/8`),\n[`gl:compressedTexImage3D/9`](`compressedTexImage3D/9`),\n[`gl:compressedTexSubImage1D/7`](`compressedTexSubImage1D/7`),\n[`gl:compressedTexSubImage2D/9`](`compressedTexSubImage2D/9`) or\n[`gl:compressedTexSubImage1D/7`](`compressedTexSubImage1D/7`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPixelStore.xhtml)","ref":"gl.html#pixelStorei/2"},{"type":"function","title":"gl.pixelTransferf/2","doc":"Equivalent to  pixelTransferi/2 .","ref":"gl.html#pixelTransferf/2"},{"type":"function","title":"gl.pixelTransferi/2","doc":"[`gl:pixelTransfer()`](`pixelTransferf/2`) sets pixel transfer modes that affect\nthe operation of subsequent [`gl:copyPixels/5`](`copyPixels/5`),\n[`gl:copyTexImage1D/7`](`copyTexImage1D/7`),\n[`gl:copyTexImage2D/8`](`copyTexImage2D/8`),\n[`gl:copyTexSubImage1D/6`](`copyTexSubImage1D/6`),\n[`gl:copyTexSubImage2D/8`](`copyTexSubImage2D/8`),\n[`gl:copyTexSubImage3D/9`](`copyTexSubImage3D/9`),\n[`gl:drawPixels/5`](`drawPixels/5`), [`gl:readPixels/7`](`readPixels/7`),\n[`gl:texImage1D/8`](`texImage1D/8`), [`gl:texImage2D/9`](`texImage2D/9`),\n[`gl:texImage3D/10`](`texImage3D/10`),\n[`gl:texSubImage1D/7`](`texSubImage1D/7`),\n[`gl:texSubImage2D/9`](`texSubImage2D/9`), and\n[`gl:texSubImage3D/11`](`texSubImage3D/11`) commands. Additionally, if the\nARB_imaging subset is supported, the routines\n[`gl:colorTable/6`](`colorTable/6`), [`gl:colorSubTable/6`](`colorSubTable/6`),\n[`gl:convolutionFilter1D/6`](`convolutionFilter1D/6`),\n[`gl:convolutionFilter2D/7`](`convolutionFilter2D/7`),\n[`gl:histogram/4`](`histogram/4`), [`gl:minmax/3`](`minmax/3`), and\n[`gl:separableFilter2D/8`](`separableFilter2D/8`) are also affected. The\nalgorithms that are specified by pixel transfer modes operate on pixels after\nthey are read from the frame buffer\n([`gl:copyPixels/5`](`copyPixels/5`)[`gl:copyTexImage1D/7`](`copyTexImage1D/7`),\n[`gl:copyTexImage2D/8`](`copyTexImage2D/8`),\n[`gl:copyTexSubImage1D/6`](`copyTexSubImage1D/6`),\n[`gl:copyTexSubImage2D/8`](`copyTexSubImage2D/8`),\n[`gl:copyTexSubImage3D/9`](`copyTexSubImage3D/9`), and\n[`gl:readPixels/7`](`readPixels/7`)), or unpacked from client memory\n([`gl:drawPixels/5`](`drawPixels/5`), [`gl:texImage1D/8`](`texImage1D/8`),\n[`gl:texImage2D/9`](`texImage2D/9`), [`gl:texImage3D/10`](`texImage3D/10`),\n[`gl:texSubImage1D/7`](`texSubImage1D/7`),\n[`gl:texSubImage2D/9`](`texSubImage2D/9`), and\n[`gl:texSubImage3D/11`](`texSubImage3D/11`)). Pixel transfer operations happen\nin the same order, and in the same manner, regardless of the command that\nresulted in the pixel operation. Pixel storage modes (see\n[`gl:pixelStore()`](`pixelStoref/2`)) control the unpacking of pixels being read\nfrom client memory and the packing of pixels being written back into client\nmemory.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPixelTransfer.xml)","ref":"gl.html#pixelTransferi/2"},{"type":"function","title":"gl.pixelZoom/2","doc":"[`gl:pixelZoom/2`](`pixelZoom/2`) specifies values for the x and y zoom factors.\nDuring the execution of [`gl:drawPixels/5`](`drawPixels/5`) or\n[`gl:copyPixels/5`](`copyPixels/5`), if ( xr, yr) is the current raster\nposition, and a given element is in the mth row and nth column of the pixel\nrectangle, then pixels whose centers are in the rectangle with corners at\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPixelZoom.xml)","ref":"gl.html#pixelZoom/2"},{"type":"function","title":"gl.pointParameterf/2","doc":"Equivalent to  pointParameteriv/2 .","ref":"gl.html#pointParameterf/2"},{"type":"function","title":"gl.pointParameterfv/2","doc":"Equivalent to  pointParameteriv/2 .","ref":"gl.html#pointParameterfv/2"},{"type":"function","title":"gl.pointParameteri/2","doc":"Equivalent to  pointParameteriv/2 .","ref":"gl.html#pointParameteri/2"},{"type":"function","title":"gl.pointParameteriv/2","doc":"The following values are accepted for `Pname`:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPointParameter.xhtml)","ref":"gl.html#pointParameteriv/2"},{"type":"function","title":"gl.pointSize/1","doc":"[`gl:pointSize/1`](`pointSize/1`) specifies the rasterized diameter of points.\nIf point size mode is disabled (see [`gl:enable/1`](`enable/1`) with parameter\n`?GL_PROGRAM_POINT_SIZE`), this value will be used to rasterize points.\nOtherwise, the value written to the shading language built-in variable\ngl_PointSize will be used.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPointSize.xhtml)","ref":"gl.html#pointSize/1"},{"type":"function","title":"gl.polygonMode/2","doc":"[`gl:polygonMode/2`](`polygonMode/2`) controls the interpretation of polygons\nfor rasterization. `Face` describes which polygons `Mode` applies to: both front\nand back-facing polygons (`?GL_FRONT_AND_BACK`). The polygon mode affects only\nthe final rasterization of polygons. In particular, a polygon's vertices are lit\nand the polygon is clipped and possibly culled before these modes are applied.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPolygonMode.xhtml)","ref":"gl.html#polygonMode/2"},{"type":"function","title":"gl.polygonOffset/2","doc":"When `?GL_POLYGON_OFFSET_FILL`, `?GL_POLYGON_OFFSET_LINE`, or\n`?GL_POLYGON_OFFSET_POINT` is enabled, each fragment's `depth` value will be\noffset after it is interpolated from the `depth` values of the appropriate\nvertices. The value of the offset is factor×DZ+r×units, where DZ is a\nmeasurement of the change in depth relative to the screen area of the polygon,\nand r is the smallest value that is guaranteed to produce a resolvable offset\nfor a given implementation. The offset is added before the depth test is\nperformed and before the value is written into the depth buffer.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPolygonOffset.xhtml)","ref":"gl.html#polygonOffset/2"},{"type":"function","title":"gl.polygonOffsetClamp/3","doc":"No documentation available.","ref":"gl.html#polygonOffsetClamp/3"},{"type":"function","title":"gl.polygonStipple/1","doc":"Polygon stippling, like line stippling (see\n[`gl:lineStipple/2`](`lineStipple/2`)), masks out certain fragments produced by\nrasterization, creating a pattern. Stippling is independent of polygon\nantialiasing.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPolygonStipple.xml)","ref":"gl.html#polygonStipple/1"},{"type":"function","title":"gl.popAttrib/0","doc":"Equivalent to  pushAttrib/1 .","ref":"gl.html#popAttrib/0"},{"type":"function","title":"gl.popClientAttrib/0","doc":"Equivalent to  pushClientAttrib/1 .","ref":"gl.html#popClientAttrib/0"},{"type":"function","title":"gl.popDebugGroup/0","doc":"Equivalent to  pushDebugGroup/4 .","ref":"gl.html#popDebugGroup/0"},{"type":"function","title":"gl.popMatrix/0","doc":"Equivalent to  pushMatrix/0 .","ref":"gl.html#popMatrix/0"},{"type":"function","title":"gl.popName/0","doc":"Equivalent to  pushName/1 .","ref":"gl.html#popName/0"},{"type":"function","title":"gl.primitiveRestartIndex/1","doc":"[`gl:primitiveRestartIndex/1`](`primitiveRestartIndex/1`) specifies a vertex\narray element that is treated specially when primitive restarting is enabled.\nThis is known as the primitive restart index.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPrimitiveRestartIndex.xhtml)","ref":"gl.html#primitiveRestartIndex/1"},{"type":"function","title":"gl.prioritizeTextures/2","doc":"[`gl:prioritizeTextures/2`](`prioritizeTextures/2`) assigns the `N` texture\npriorities given in `Priorities` to the `N` textures named in `Textures`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPrioritizeTextures.xml)","ref":"gl.html#prioritizeTextures/2"},{"type":"function","title":"gl.programBinary/3","doc":"[`gl:programBinary/3`](`programBinary/3`) loads a program object with a program\nbinary previously returned from [`gl:getProgramBinary/2`](`getProgramBinary/2`).\n`BinaryFormat` and `Binary` must be those returned by a previous call to\n[`gl:getProgramBinary/2`](`getProgramBinary/2`), and `Length` must be the length\nreturned by [`gl:getProgramBinary/2`](`getProgramBinary/2`), or by\n[`gl:getProgram()`](`getProgramiv/2`) when called with `Pname` set to\n`?GL_PROGRAM_BINARY_LENGTH`. If these conditions are not met, loading the\nprogram binary will fail and `Program`'s `?GL_LINK_STATUS` will be set to\n`?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glProgramBinary.xhtml)","ref":"gl.html#programBinary/3"},{"type":"function","title":"gl.programParameteri/3","doc":"[`gl:programParameter()`](`programParameteri/3`) specifies a new value for the\nparameter nameed by `Pname` for the program object `Program`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glProgramParameter.xhtml)","ref":"gl.html#programParameteri/3"},{"type":"function","title":"gl.programUniform1d/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform1d/3"},{"type":"function","title":"gl.programUniform1dv/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform1dv/3"},{"type":"function","title":"gl.programUniform1f/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform1f/3"},{"type":"function","title":"gl.programUniform1fv/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform1fv/3"},{"type":"function","title":"gl.programUniform1i/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform1i/3"},{"type":"function","title":"gl.programUniform1iv/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform1iv/3"},{"type":"function","title":"gl.programUniform1ui/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform1ui/3"},{"type":"function","title":"gl.programUniform1uiv/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform1uiv/3"},{"type":"function","title":"gl.programUniform2d/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform2d/4"},{"type":"function","title":"gl.programUniform2dv/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform2dv/3"},{"type":"function","title":"gl.programUniform2f/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform2f/4"},{"type":"function","title":"gl.programUniform2fv/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform2fv/3"},{"type":"function","title":"gl.programUniform2i/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform2i/4"},{"type":"function","title":"gl.programUniform2iv/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform2iv/3"},{"type":"function","title":"gl.programUniform2ui/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform2ui/4"},{"type":"function","title":"gl.programUniform2uiv/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform2uiv/3"},{"type":"function","title":"gl.programUniform3d/5","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform3d/5"},{"type":"function","title":"gl.programUniform3dv/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform3dv/3"},{"type":"function","title":"gl.programUniform3f/5","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform3f/5"},{"type":"function","title":"gl.programUniform3fv/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform3fv/3"},{"type":"function","title":"gl.programUniform3i/5","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform3i/5"},{"type":"function","title":"gl.programUniform3iv/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform3iv/3"},{"type":"function","title":"gl.programUniform3ui/5","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform3ui/5"},{"type":"function","title":"gl.programUniform3uiv/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform3uiv/3"},{"type":"function","title":"gl.programUniform4d/6","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform4d/6"},{"type":"function","title":"gl.programUniform4dv/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform4dv/3"},{"type":"function","title":"gl.programUniform4f/6","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform4f/6"},{"type":"function","title":"gl.programUniform4fv/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform4fv/3"},{"type":"function","title":"gl.programUniform4i/6","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform4i/6"},{"type":"function","title":"gl.programUniform4iv/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform4iv/3"},{"type":"function","title":"gl.programUniform4ui/6","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform4ui/6"},{"type":"function","title":"gl.programUniform4uiv/3","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniform4uiv/3"},{"type":"function","title":"gl.programUniformMatrix2dv/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniformMatrix2dv/4"},{"type":"function","title":"gl.programUniformMatrix2fv/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniformMatrix2fv/4"},{"type":"function","title":"gl.programUniformMatrix2x3dv/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniformMatrix2x3dv/4"},{"type":"function","title":"gl.programUniformMatrix2x3fv/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniformMatrix2x3fv/4"},{"type":"function","title":"gl.programUniformMatrix2x4dv/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniformMatrix2x4dv/4"},{"type":"function","title":"gl.programUniformMatrix2x4fv/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniformMatrix2x4fv/4"},{"type":"function","title":"gl.programUniformMatrix3dv/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniformMatrix3dv/4"},{"type":"function","title":"gl.programUniformMatrix3fv/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniformMatrix3fv/4"},{"type":"function","title":"gl.programUniformMatrix3x2dv/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniformMatrix3x2dv/4"},{"type":"function","title":"gl.programUniformMatrix3x2fv/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniformMatrix3x2fv/4"},{"type":"function","title":"gl.programUniformMatrix3x4dv/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniformMatrix3x4dv/4"},{"type":"function","title":"gl.programUniformMatrix3x4fv/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniformMatrix3x4fv/4"},{"type":"function","title":"gl.programUniformMatrix4dv/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniformMatrix4dv/4"},{"type":"function","title":"gl.programUniformMatrix4fv/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniformMatrix4fv/4"},{"type":"function","title":"gl.programUniformMatrix4x2dv/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniformMatrix4x2dv/4"},{"type":"function","title":"gl.programUniformMatrix4x2fv/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniformMatrix4x2fv/4"},{"type":"function","title":"gl.programUniformMatrix4x3dv/4","doc":"Equivalent to  programUniformMatrix4x3fv/4 .","ref":"gl.html#programUniformMatrix4x3dv/4"},{"type":"function","title":"gl.programUniformMatrix4x3fv/4","doc":"[`gl:programUniform()`](`programUniform1i/3`) modifies the value of a uniform\nvariable or a uniform variable array. The location of the uniform variable to be\nmodified is specified by `Location`, which should be a value returned by\n[`gl:getUniformLocation/2`](`getUniformLocation/2`).\n[`gl:programUniform()`](`programUniform1i/3`) operates on the program object\nspecified by `Program`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glProgramUniform.xhtml)","ref":"gl.html#programUniformMatrix4x3fv/4"},{"type":"function","title":"gl.provokingVertex/1","doc":"`Flatshading` a vertex shader varying output means to assign all vetices of the\nprimitive the same value for that output. The vertex from which these values is\nderived is known as the `provoking vertex` and\n[`gl:provokingVertex/1`](`provokingVertex/1`) specifies which vertex is to be\nused as the source of data for flat shaded varyings.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glProvokingVertex.xhtml)","ref":"gl.html#provokingVertex/1"},{"type":"function","title":"gl.pushAttrib/1","doc":"[`gl:pushAttrib/1`](`pushAttrib/1`) takes one argument, a mask that indicates\nwhich groups of state variables to save on the attribute stack. Symbolic\nconstants are used to set bits in the mask. `Mask` is typically constructed by\nspecifying the bitwise-or of several of these constants together. The special\nmask `?GL_ALL_ATTRIB_BITS` can be used to save all stackable states.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPushAttrib.xml)","ref":"gl.html#pushAttrib/1"},{"type":"function","title":"gl.pushClientAttrib/1","doc":"[`gl:pushClientAttrib/1`](`pushClientAttrib/1`) takes one argument, a mask that\nindicates which groups of client-state variables to save on the client attribute\nstack. Symbolic constants are used to set bits in the mask. `Mask` is typically\nconstructed by specifying the bitwise-or of several of these constants together.\nThe special mask `?GL_CLIENT_ALL_ATTRIB_BITS` can be used to save all stackable\nclient state.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPushClientAttrib.xml)","ref":"gl.html#pushClientAttrib/1"},{"type":"function","title":"gl.pushDebugGroup/4","doc":"[`gl:pushDebugGroup/4`](`pushDebugGroup/4`) pushes a debug group described by\nthe string `Message` into the command stream. The value of `Id` specifies the ID\nof messages generated. The parameter `Length` contains the number of characters\nin `Message`. If `Length` is negative, it is implied that `Message` contains a\nnull terminated string. The message has the specified `Source` and `Id`, the\n`Type``?GL_DEBUG_TYPE_PUSH_GROUP`, and\n`Severity``?GL_DEBUG_SEVERITY_NOTIFICATION`. The GL will put a new debug group\non top of the debug group stack which inherits the control of the volume of\ndebug output of the debug group previously residing on the top of the debug\ngroup stack. Because debug groups are strictly hierarchical, any additional\ncontrol of the debug output volume will only apply within the active debug group\nand the debug groups pushed on top of the active debug group.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPushDebugGroup.xhtml)","ref":"gl.html#pushDebugGroup/4"},{"type":"function","title":"gl.pushMatrix/0","doc":"There is a stack of matrices for each of the matrix modes. In `?GL_MODELVIEW`\nmode, the stack depth is at least 32. In the other modes, `?GL_COLOR`,\n`?GL_PROJECTION`, and `?GL_TEXTURE`, the depth is at least 2. The current matrix\nin any mode is the matrix on the top of the stack for that mode.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPushMatrix.xml)","ref":"gl.html#pushMatrix/0"},{"type":"function","title":"gl.pushName/1","doc":"The name stack is used during selection mode to allow sets of rendering commands\nto be uniquely identified. It consists of an ordered set of unsigned integers\nand is initially empty.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPushName.xml)","ref":"gl.html#pushName/1"},{"type":"function","title":"gl.queryCounter/2","doc":"[`gl:queryCounter/2`](`queryCounter/2`) causes the GL to record the current time\ninto the query object named `Id`. `Target` must be `?GL_TIMESTAMP`. The time is\nrecorded after all previous commands on the GL client and server state and the\nframebuffer have been fully realized. When the time is recorded, the query\nresult for that object is marked available.\n[`gl:queryCounter/2`](`queryCounter/2`) timer queries can be used within a\n[`gl:beginQuery/2`](`beginQuery/2`) / [`gl:endQuery/1`](`beginQuery/2`) block\nwhere the target is `?GL_TIME_ELAPSED` and it does not affect the result of that\nquery object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glQueryCounter.xhtml)","ref":"gl.html#queryCounter/2"},{"type":"function","title":"gl.rasterPos2d/2","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos2d/2"},{"type":"function","title":"gl.rasterPos2dv/1","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos2dv/1"},{"type":"function","title":"gl.rasterPos2f/2","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos2f/2"},{"type":"function","title":"gl.rasterPos2fv/1","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos2fv/1"},{"type":"function","title":"gl.rasterPos2i/2","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos2i/2"},{"type":"function","title":"gl.rasterPos2iv/1","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos2iv/1"},{"type":"function","title":"gl.rasterPos2s/2","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos2s/2"},{"type":"function","title":"gl.rasterPos2sv/1","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos2sv/1"},{"type":"function","title":"gl.rasterPos3d/3","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos3d/3"},{"type":"function","title":"gl.rasterPos3dv/1","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos3dv/1"},{"type":"function","title":"gl.rasterPos3f/3","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos3f/3"},{"type":"function","title":"gl.rasterPos3fv/1","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos3fv/1"},{"type":"function","title":"gl.rasterPos3i/3","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos3i/3"},{"type":"function","title":"gl.rasterPos3iv/1","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos3iv/1"},{"type":"function","title":"gl.rasterPos3s/3","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos3s/3"},{"type":"function","title":"gl.rasterPos3sv/1","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos3sv/1"},{"type":"function","title":"gl.rasterPos4d/4","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos4d/4"},{"type":"function","title":"gl.rasterPos4dv/1","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos4dv/1"},{"type":"function","title":"gl.rasterPos4f/4","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos4f/4"},{"type":"function","title":"gl.rasterPos4fv/1","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos4fv/1"},{"type":"function","title":"gl.rasterPos4i/4","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos4i/4"},{"type":"function","title":"gl.rasterPos4iv/1","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos4iv/1"},{"type":"function","title":"gl.rasterPos4s/4","doc":"Equivalent to  rasterPos4sv/1 .","ref":"gl.html#rasterPos4s/4"},{"type":"function","title":"gl.rasterPos4sv/1","doc":"The GL maintains a 3D position in window coordinates. This position, called the\nraster position, is used to position pixel and bitmap write operations. It is\nmaintained with subpixel accuracy. See [`gl:bitmap/7`](`bitmap/7`),\n[`gl:drawPixels/5`](`drawPixels/5`), and [`gl:copyPixels/5`](`copyPixels/5`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glRasterPos.xml)","ref":"gl.html#rasterPos4sv/1"},{"type":"function","title":"gl.readBuffer/1","doc":"[`gl:readBuffer/1`](`readBuffer/1`) specifies a color buffer as the source for\nsubsequent [`gl:readPixels/7`](`readPixels/7`),\n[`gl:copyTexImage1D/7`](`copyTexImage1D/7`),\n[`gl:copyTexImage2D/8`](`copyTexImage2D/8`),\n[`gl:copyTexSubImage1D/6`](`copyTexSubImage1D/6`),\n[`gl:copyTexSubImage2D/8`](`copyTexSubImage2D/8`), and\n[`gl:copyTexSubImage3D/9`](`copyTexSubImage3D/9`) commands. `Mode` accepts one\nof twelve or more predefined values. In a fully configured system, `?GL_FRONT`,\n`?GL_LEFT`, and `?GL_FRONT_LEFT` all name the front left buffer,\n`?GL_FRONT_RIGHT` and `?GL_RIGHT` name the front right buffer, and\n`?GL_BACK_LEFT` and `?GL_BACK` name the back left buffer. Further more, the\nconstants `?GL_COLOR_ATTACHMENT``i` may be used to indicate the `i`th color\nattachment where `i` ranges from zero to the value of\n`?GL_MAX_COLOR_ATTACHMENTS` minus one.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glReadBuffer.xhtml)","ref":"gl.html#readBuffer/1"},{"type":"function","title":"gl.readPixels/7","doc":"[`gl:readPixels/7`](`readPixels/7`) and `glReadnPixels` return pixel data from\nthe frame buffer, starting with the pixel whose lower left corner is at location\n(`X`, `Y`), into client memory starting at location `Data`. Several parameters\ncontrol the processing of the pixel data before it is placed into client memory.\nThese parameters are set with [`gl:pixelStore()`](`pixelStoref/2`). This\nreference page describes the effects on [`gl:readPixels/7`](`readPixels/7`) and\n`glReadnPixels` of most, but not all of the parameters specified by these three\ncommands.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glReadPixels.xhtml)","ref":"gl.html#readPixels/7"},{"type":"function","title":"gl.rectd/4","doc":"Equivalent to  rectsv/2 .","ref":"gl.html#rectd/4"},{"type":"function","title":"gl.rectdv/2","doc":"Equivalent to  rectsv/2 .","ref":"gl.html#rectdv/2"},{"type":"function","title":"gl.rectf/4","doc":"Equivalent to  rectsv/2 .","ref":"gl.html#rectf/4"},{"type":"function","title":"gl.rectfv/2","doc":"Equivalent to  rectsv/2 .","ref":"gl.html#rectfv/2"},{"type":"function","title":"gl.recti/4","doc":"Equivalent to  rectsv/2 .","ref":"gl.html#recti/4"},{"type":"function","title":"gl.rectiv/2","doc":"Equivalent to  rectsv/2 .","ref":"gl.html#rectiv/2"},{"type":"function","title":"gl.rects/4","doc":"Equivalent to  rectsv/2 .","ref":"gl.html#rects/4"},{"type":"function","title":"gl.rectsv/2","doc":"[`gl:rect()`](`rectd/4`) supports efficient specification of rectangles as two\ncorner points. Each rectangle command takes four arguments, organized either as\ntwo consecutive pairs of (x y) coordinates or as two pointers to arrays, each\ncontaining an (x y) pair. The resulting rectangle is defined in the z=0 plane.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glRect.xml)","ref":"gl.html#rectsv/2"},{"type":"function","title":"gl.releaseShaderCompiler/0","doc":"[`gl:releaseShaderCompiler/0`](`releaseShaderCompiler/0`) provides a hint to the\nimplementation that it may free internal resources associated with its shader\ncompiler. [`gl:compileShader/1`](`compileShader/1`) may subsequently be called\nand the implementation may at that time reallocate resources previously freed by\nthe call to [`gl:releaseShaderCompiler/0`](`releaseShaderCompiler/0`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glReleaseShaderCompiler.xhtml)","ref":"gl.html#releaseShaderCompiler/0"},{"type":"function","title":"gl.renderbufferStorage/4","doc":"[`gl:renderbufferStorage/4`](`renderbufferStorage/4`) is equivalent to calling\n[`gl:renderbufferStorageMultisample/5`](`renderbufferStorageMultisample/5`) with\nthe `Samples` set to zero, and `glNamedRenderbufferStorage` is equivalent to\ncalling `glNamedRenderbufferStorageMultisample` with the samples set to zero.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glRenderbufferStorage.xhtml)","ref":"gl.html#renderbufferStorage/4"},{"type":"function","title":"gl.renderbufferStorageMultisample/5","doc":"[`gl:renderbufferStorageMultisample/5`](`renderbufferStorageMultisample/5`) and\n`glNamedRenderbufferStorageMultisample` establish the data storage, format,\ndimensions and number of samples of a renderbuffer object's image.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glRenderbufferStorageMultisample.xhtml)","ref":"gl.html#renderbufferStorageMultisample/5"},{"type":"function","title":"gl.renderMode/1","doc":"[`gl:renderMode/1`](`renderMode/1`) sets the rasterization mode. It takes one\nargument, `Mode`, which can assume one of three predefined values:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glRenderMode.xml)","ref":"gl.html#renderMode/1"},{"type":"function","title":"gl.resetHistogram/1","doc":"[`gl:resetHistogram/1`](`resetHistogram/1`) resets all the elements of the\ncurrent histogram table to zero.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glResetHistogram.xml)","ref":"gl.html#resetHistogram/1"},{"type":"function","title":"gl.resetMinmax/1","doc":"[`gl:resetMinmax/1`](`resetMinmax/1`) resets the elements of the current minmax\ntable to their initial values: the \\`\\`maximum'' element receives the minimum\npossible component values, and the \\`\\`minimum'' element receives the maximum\npossible component values.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glResetMinmax.xml)","ref":"gl.html#resetMinmax/1"},{"type":"function","title":"gl.resumeTransformFeedback/0","doc":"[`gl:resumeTransformFeedback/0`](`resumeTransformFeedback/0`) resumes transform\nfeedback operations on the currently active transform feedback object. When\ntransform feedback operations are paused, transform feedback is still considered\nactive and changing most transform feedback state related to the object results\nin an error. However, a new transform feedback object may be bound while\ntransform feedback is paused.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glResumeTransformFeedback.xhtml)","ref":"gl.html#resumeTransformFeedback/0"},{"type":"function","title":"gl.rotated/4","doc":"Equivalent to  rotatef/4 .","ref":"gl.html#rotated/4"},{"type":"function","title":"gl.rotatef/4","doc":"[`gl:rotate()`](`rotated/4`) produces a rotation of `Angle` degrees around the\nvector (x y z). The current matrix (see [`gl:matrixMode/1`](`matrixMode/1`)) is\nmultiplied by a rotation matrix with the product replacing the current matrix,\nas if [`gl:multMatrix()`](`multMatrixd/1`) were called with the following matrix\nas its argument:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glRotate.xml)","ref":"gl.html#rotatef/4"},{"type":"function","title":"gl.sampleCoverage/2","doc":"Multisampling samples a pixel multiple times at various implementation-dependent\nsubpixel locations to generate antialiasing effects. Multisampling transparently\nantialiases points, lines, polygons, and images if it is enabled.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glSampleCoverage.xhtml)","ref":"gl.html#sampleCoverage/2"},{"type":"function","title":"gl.sampleMaski/2","doc":"[`gl:sampleMaski/2`](`sampleMaski/2`) sets one 32-bit sub-word of the multi-word\nsample mask, `?GL_SAMPLE_MASK_VALUE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glSampleMaski.xhtml)","ref":"gl.html#sampleMaski/2"},{"type":"function","title":"gl.samplerParameterf/3","doc":"Equivalent to  samplerParameteriv/3 .","ref":"gl.html#samplerParameterf/3"},{"type":"function","title":"gl.samplerParameterfv/3","doc":"Equivalent to  samplerParameteriv/3 .","ref":"gl.html#samplerParameterfv/3"},{"type":"function","title":"gl.samplerParameterIiv/3","doc":"Equivalent to  samplerParameteriv/3 .","ref":"gl.html#samplerParameterIiv/3"},{"type":"function","title":"gl.samplerParameterIuiv/3","doc":"Equivalent to  samplerParameteriv/3 .","ref":"gl.html#samplerParameterIuiv/3"},{"type":"function","title":"gl.samplerParameteri/3","doc":"Equivalent to  samplerParameteriv/3 .","ref":"gl.html#samplerParameteri/3"},{"type":"function","title":"gl.samplerParameteriv/3","doc":"[`gl:samplerParameter()`](`samplerParameteri/3`) assigns the value or values in\n`Params` to the sampler parameter specified as `Pname`. `Sampler` specifies the\nsampler object to be modified, and must be the name of a sampler object\npreviously returned from a call to [`gl:genSamplers/1`](`genSamplers/1`). The\nfollowing symbols are accepted in `Pname`:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glSamplerParameter.xhtml)","ref":"gl.html#samplerParameteriv/3"},{"type":"function","title":"gl.scaled/3","doc":"Equivalent to  scalef/3 .","ref":"gl.html#scaled/3"},{"type":"function","title":"gl.scalef/3","doc":"[`gl:scale()`](`scaled/3`) produces a nonuniform scaling along the `x`, `y`, and\n`z` axes. The three parameters indicate the desired scale factor along each of\nthe three axes.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glScale.xml)","ref":"gl.html#scalef/3"},{"type":"function","title":"gl.scissor/4","doc":"[`gl:scissor/4`](`scissor/4`) defines a rectangle, called the scissor box, in\nwindow coordinates. The first two arguments, `X` and `Y`, specify the lower left\ncorner of the box. `Width` and `Height` specify the width and height of the box.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glScissor.xhtml)","ref":"gl.html#scissor/4"},{"type":"function","title":"gl.scissorArrayv/2","doc":"[`gl:scissorArrayv/2`](`scissorArrayv/2`) defines rectangles, called scissor\nboxes, in window coordinates for each viewport. `First` specifies the index of\nthe first scissor box to modify and `Count` specifies the number of scissor\nboxes to modify. `First` must be less than the value of `?GL_MAX_VIEWPORTS`, and\n`First` \\+ `Count` must be less than or equal to the value of\n`?GL_MAX_VIEWPORTS`. `V` specifies the address of an array containing integers\nspecifying the lower left corner of the scissor boxes, and the width and height\nof the scissor boxes, in that order.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glScissorArray.xhtml)","ref":"gl.html#scissorArrayv/2"},{"type":"function","title":"gl.scissorIndexed/5","doc":"Equivalent to  scissorIndexedv/2 .","ref":"gl.html#scissorIndexed/5"},{"type":"function","title":"gl.scissorIndexedv/2","doc":"[`gl:scissorIndexed/5`](`scissorIndexed/5`) defines the scissor box for a\nspecified viewport. `Index` specifies the index of scissor box to modify.\n`Index` must be less than the value of `?GL_MAX_VIEWPORTS`. For\n[`gl:scissorIndexed/5`](`scissorIndexed/5`), `Left`, `Bottom`, `Width` and\n`Height` specify the left, bottom, width and height of the scissor box, in\npixels, respectively. For [`gl:scissorIndexedv/2`](`scissorIndexed/5`), `V`\nspecifies the address of an array containing integers specifying the lower left\ncorner of the scissor box, and the width and height of the scissor box, in that\norder.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glScissorIndexed.xhtml)","ref":"gl.html#scissorIndexedv/2"},{"type":"function","title":"gl.secondaryColor3b/3","doc":"Equivalent to  secondaryColor3usv/1 .","ref":"gl.html#secondaryColor3b/3"},{"type":"function","title":"gl.secondaryColor3bv/1","doc":"Equivalent to  secondaryColor3usv/1 .","ref":"gl.html#secondaryColor3bv/1"},{"type":"function","title":"gl.secondaryColor3d/3","doc":"Equivalent to  secondaryColor3usv/1 .","ref":"gl.html#secondaryColor3d/3"},{"type":"function","title":"gl.secondaryColor3dv/1","doc":"Equivalent to  secondaryColor3usv/1 .","ref":"gl.html#secondaryColor3dv/1"},{"type":"function","title":"gl.secondaryColor3f/3","doc":"Equivalent to  secondaryColor3usv/1 .","ref":"gl.html#secondaryColor3f/3"},{"type":"function","title":"gl.secondaryColor3fv/1","doc":"Equivalent to  secondaryColor3usv/1 .","ref":"gl.html#secondaryColor3fv/1"},{"type":"function","title":"gl.secondaryColor3i/3","doc":"Equivalent to  secondaryColor3usv/1 .","ref":"gl.html#secondaryColor3i/3"},{"type":"function","title":"gl.secondaryColor3iv/1","doc":"Equivalent to  secondaryColor3usv/1 .","ref":"gl.html#secondaryColor3iv/1"},{"type":"function","title":"gl.secondaryColor3s/3","doc":"Equivalent to  secondaryColor3usv/1 .","ref":"gl.html#secondaryColor3s/3"},{"type":"function","title":"gl.secondaryColor3sv/1","doc":"Equivalent to  secondaryColor3usv/1 .","ref":"gl.html#secondaryColor3sv/1"},{"type":"function","title":"gl.secondaryColor3ub/3","doc":"Equivalent to  secondaryColor3usv/1 .","ref":"gl.html#secondaryColor3ub/3"},{"type":"function","title":"gl.secondaryColor3ubv/1","doc":"Equivalent to  secondaryColor3usv/1 .","ref":"gl.html#secondaryColor3ubv/1"},{"type":"function","title":"gl.secondaryColor3ui/3","doc":"Equivalent to  secondaryColor3usv/1 .","ref":"gl.html#secondaryColor3ui/3"},{"type":"function","title":"gl.secondaryColor3uiv/1","doc":"Equivalent to  secondaryColor3usv/1 .","ref":"gl.html#secondaryColor3uiv/1"},{"type":"function","title":"gl.secondaryColor3us/3","doc":"Equivalent to  secondaryColor3usv/1 .","ref":"gl.html#secondaryColor3us/3"},{"type":"function","title":"gl.secondaryColor3usv/1","doc":"The GL stores both a primary four-valued RGBA color and a secondary four-valued\nRGBA color (where alpha is always set to 0.0) that is associated with every\nvertex.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glSecondaryColor.xml)","ref":"gl.html#secondaryColor3usv/1"},{"type":"function","title":"gl.secondaryColorPointer/4","doc":"[`gl:secondaryColorPointer/4`](`secondaryColorPointer/4`) specifies the location\nand data format of an array of color components to use when rendering. `Size`\nspecifies the number of components per color, and must be 3. `Type` specifies\nthe data type of each color component, and `Stride` specifies the byte stride\nfrom one color to the next, allowing vertices and attributes to be packed into a\nsingle array or stored in separate arrays.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glSecondaryColorPointer.xml)","ref":"gl.html#secondaryColorPointer/4"},{"type":"function","title":"gl.selectBuffer/2","doc":"[`gl:selectBuffer/2`](`selectBuffer/2`) has two arguments: `Buffer` is a pointer\nto an array of unsigned integers, and `Size` indicates the size of the array.\n`Buffer` returns values from the name stack (see\n[`gl:initNames/0`](`initNames/0`), [`gl:loadName/1`](`loadName/1`),\n[`gl:pushName/1`](`pushName/1`)) when the rendering mode is `?GL_SELECT` (see\n[`gl:renderMode/1`](`renderMode/1`)). [`gl:selectBuffer/2`](`selectBuffer/2`)\nmust be issued before selection mode is enabled, and it must not be issued while\nthe rendering mode is `?GL_SELECT`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glSelectBuffer.xml)","ref":"gl.html#selectBuffer/2"},{"type":"function","title":"gl.separableFilter2D/8","doc":"[`gl:separableFilter2D/8`](`separableFilter2D/8`) builds a two-dimensional\nseparable convolution filter kernel from two arrays of pixels.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glSeparableFilter2D.xml)","ref":"gl.html#separableFilter2D/8"},{"type":"function","title":"gl.shadeModel/1","doc":"GL primitives can have either flat or smooth shading. Smooth shading, the\ndefault, causes the computed colors of vertices to be interpolated as the\nprimitive is rasterized, typically assigning different colors to each resulting\npixel fragment. Flat shading selects the computed color of just one vertex and\nassigns it to all the pixel fragments generated by rasterizing a single\nprimitive. In either case, the computed color of a vertex is the result of\nlighting if lighting is enabled, or it is the current color at the time the\nvertex was specified if lighting is disabled.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glShadeModel.xml)","ref":"gl.html#shadeModel/1"},{"type":"function","title":"gl.shaderBinary/3","doc":"[`gl:shaderBinary/3`](`shaderBinary/3`) loads pre-compiled shader binary code\ninto the `Count` shader objects whose handles are given in `Shaders`. `Binary`\npoints to `Length` bytes of binary shader code stored in client memory.\n`BinaryFormat` specifies the format of the pre-compiled code.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glShaderBinary.xhtml)","ref":"gl.html#shaderBinary/3"},{"type":"function","title":"gl.shaderSource/2","doc":"[`gl:shaderSource/2`](`shaderSource/2`) sets the source code in `Shader` to the\nsource code in the array of strings specified by `String`. Any source code\npreviously stored in the shader object is completely replaced. The number of\nstrings in the array is specified by `Count`. If `Length` is `?NULL`, each\nstring is assumed to be null terminated. If `Length` is a value other than\n`?NULL`, it points to an array containing a string length for each of the\ncorresponding elements of `String`. Each element in the `Length` array may\ncontain the length of the corresponding string (the null character is not\ncounted as part of the string length) or a value less than 0 to indicate that\nthe string is null terminated. The source code strings are not scanned or parsed\nat this time; they are simply copied into the specified shader object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glShaderSource.xhtml)","ref":"gl.html#shaderSource/2"},{"type":"function","title":"gl.shaderStorageBlockBinding/3","doc":"[`gl:shaderStorageBlockBinding/3`](`shaderStorageBlockBinding/3`), changes the\nactive shader storage block with an assigned index of `StorageBlockIndex` in\nprogram object `Program`. `StorageBlockIndex` must be an active shader storage\nblock index in `Program`. `StorageBlockBinding` must be less than the value of\n`?GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS`. If successful,\n[`gl:shaderStorageBlockBinding/3`](`shaderStorageBlockBinding/3`) specifies that\n`Program` will use the data store of the buffer object bound to the binding\npoint `StorageBlockBinding` to read and write the values of the buffer variables\nin the shader storage block identified by `StorageBlockIndex`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glShaderStorageBlockBinding.xhtml)","ref":"gl.html#shaderStorageBlockBinding/3"},{"type":"function","title":"gl.stencilFunc/3","doc":"Stenciling, like depth-buffering, enables and disables drawing on a per-pixel\nbasis. Stencil planes are first drawn into using GL drawing primitives, then\ngeometry and images are rendered using the stencil planes to mask out portions\nof the screen. Stenciling is typically used in multipass rendering algorithms to\nachieve special effects, such as decals, outlining, and constructive solid\ngeometry rendering.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glStencilFunc.xhtml)","ref":"gl.html#stencilFunc/3"},{"type":"function","title":"gl.stencilFuncSeparate/4","doc":"Stenciling, like depth-buffering, enables and disables drawing on a per-pixel\nbasis. You draw into the stencil planes using GL drawing primitives, then render\ngeometry and images, using the stencil planes to mask out portions of the\nscreen. Stenciling is typically used in multipass rendering algorithms to\nachieve special effects, such as decals, outlining, and constructive solid\ngeometry rendering.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glStencilFuncSeparate.xhtml)","ref":"gl.html#stencilFuncSeparate/4"},{"type":"function","title":"gl.stencilMask/1","doc":"[`gl:stencilMask/1`](`stencilMask/1`) controls the writing of individual bits in\nthe stencil planes. The least significant n bits of `Mask`, where n is the\nnumber of bits in the stencil buffer, specify a mask. Where a 1 appears in the\nmask, it's possible to write to the corresponding bit in the stencil buffer.\nWhere a 0 appears, the corresponding bit is write-protected. Initially, all bits\nare enabled for writing.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glStencilMask.xhtml)","ref":"gl.html#stencilMask/1"},{"type":"function","title":"gl.stencilMaskSeparate/2","doc":"[`gl:stencilMaskSeparate/2`](`stencilMaskSeparate/2`) controls the writing of\nindividual bits in the stencil planes. The least significant n bits of `Mask`,\nwhere n is the number of bits in the stencil buffer, specify a mask. Where a 1\nappears in the mask, it's possible to write to the corresponding bit in the\nstencil buffer. Where a 0 appears, the corresponding bit is write-protected.\nInitially, all bits are enabled for writing.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glStencilMaskSeparate.xhtml)","ref":"gl.html#stencilMaskSeparate/2"},{"type":"function","title":"gl.stencilOp/3","doc":"Stenciling, like depth-buffering, enables and disables drawing on a per-pixel\nbasis. You draw into the stencil planes using GL drawing primitives, then render\ngeometry and images, using the stencil planes to mask out portions of the\nscreen. Stenciling is typically used in multipass rendering algorithms to\nachieve special effects, such as decals, outlining, and constructive solid\ngeometry rendering.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glStencilOp.xhtml)","ref":"gl.html#stencilOp/3"},{"type":"function","title":"gl.stencilOpSeparate/4","doc":"Stenciling, like depth-buffering, enables and disables drawing on a per-pixel\nbasis. You draw into the stencil planes using GL drawing primitives, then render\ngeometry and images, using the stencil planes to mask out portions of the\nscreen. Stenciling is typically used in multipass rendering algorithms to\nachieve special effects, such as decals, outlining, and constructive solid\ngeometry rendering.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glStencilOpSeparate.xhtml)","ref":"gl.html#stencilOpSeparate/4"},{"type":"function","title":"gl.texBuffer/3","doc":"Equivalent to  textureBuffer/3 .","ref":"gl.html#texBuffer/3"},{"type":"function","title":"gl.texBufferRange/5","doc":"Equivalent to  textureBufferRange/5 .","ref":"gl.html#texBufferRange/5"},{"type":"function","title":"gl.texCoord1d/1","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord1d/1"},{"type":"function","title":"gl.texCoord1dv/1","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord1dv/1"},{"type":"function","title":"gl.texCoord1f/1","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord1f/1"},{"type":"function","title":"gl.texCoord1fv/1","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord1fv/1"},{"type":"function","title":"gl.texCoord1i/1","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord1i/1"},{"type":"function","title":"gl.texCoord1iv/1","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord1iv/1"},{"type":"function","title":"gl.texCoord1s/1","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord1s/1"},{"type":"function","title":"gl.texCoord1sv/1","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord1sv/1"},{"type":"function","title":"gl.texCoord2d/2","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord2d/2"},{"type":"function","title":"gl.texCoord2dv/1","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord2dv/1"},{"type":"function","title":"gl.texCoord2f/2","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord2f/2"},{"type":"function","title":"gl.texCoord2fv/1","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord2fv/1"},{"type":"function","title":"gl.texCoord2i/2","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord2i/2"},{"type":"function","title":"gl.texCoord2iv/1","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord2iv/1"},{"type":"function","title":"gl.texCoord2s/2","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord2s/2"},{"type":"function","title":"gl.texCoord2sv/1","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord2sv/1"},{"type":"function","title":"gl.texCoord3d/3","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord3d/3"},{"type":"function","title":"gl.texCoord3dv/1","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord3dv/1"},{"type":"function","title":"gl.texCoord3f/3","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord3f/3"},{"type":"function","title":"gl.texCoord3fv/1","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord3fv/1"},{"type":"function","title":"gl.texCoord3i/3","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord3i/3"},{"type":"function","title":"gl.texCoord3iv/1","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord3iv/1"},{"type":"function","title":"gl.texCoord3s/3","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord3s/3"},{"type":"function","title":"gl.texCoord3sv/1","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord3sv/1"},{"type":"function","title":"gl.texCoord4d/4","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord4d/4"},{"type":"function","title":"gl.texCoord4dv/1","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord4dv/1"},{"type":"function","title":"gl.texCoord4f/4","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord4f/4"},{"type":"function","title":"gl.texCoord4fv/1","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord4fv/1"},{"type":"function","title":"gl.texCoord4i/4","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord4i/4"},{"type":"function","title":"gl.texCoord4iv/1","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord4iv/1"},{"type":"function","title":"gl.texCoord4s/4","doc":"Equivalent to  texCoord4sv/1 .","ref":"gl.html#texCoord4s/4"},{"type":"function","title":"gl.texCoord4sv/1","doc":"[`gl:texCoord()`](`texCoord1d/1`) specifies texture coordinates in one, two,\nthree, or four dimensions. [`gl:texCoord1()`](`texCoord1d/1`) sets the current\ntexture coordinates to (s 0 0 1); a call to [`gl:texCoord2()`](`texCoord1d/1`)\nsets them to (s t 0 1). Similarly, [`gl:texCoord3()`](`texCoord1d/1`) specifies\nthe texture coordinates as (s t r 1), and [`gl:texCoord4()`](`texCoord1d/1`)\ndefines all four components explicitly as (s t r q).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glTexCoord.xml)","ref":"gl.html#texCoord4sv/1"},{"type":"function","title":"gl.texCoordPointer/4","doc":"[`gl:texCoordPointer/4`](`texCoordPointer/4`) specifies the location and data\nformat of an array of texture coordinates to use when rendering. `Size`\nspecifies the number of coordinates per texture coordinate set, and must be 1,\n2, 3, or 4. `Type` specifies the data type of each texture coordinate, and\n`Stride` specifies the byte stride from one texture coordinate set to the next,\nallowing vertices and attributes to be packed into a single array or stored in\nseparate arrays. (Single-array storage may be more efficient on some\nimplementations; see [`gl:interleavedArrays/3`](`interleavedArrays/3`).)\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glTexCoordPointer.xml)","ref":"gl.html#texCoordPointer/4"},{"type":"function","title":"gl.texEnvf/3","doc":"Equivalent to  texEnviv/3 .","ref":"gl.html#texEnvf/3"},{"type":"function","title":"gl.texEnvfv/3","doc":"Equivalent to  texEnviv/3 .","ref":"gl.html#texEnvfv/3"},{"type":"function","title":"gl.texEnvi/3","doc":"Equivalent to  texEnviv/3 .","ref":"gl.html#texEnvi/3"},{"type":"function","title":"gl.texEnviv/3","doc":"A texture environment specifies how texture values are interpreted when a\nfragment is textured. When `Target` is `?GL_TEXTURE_FILTER_CONTROL`, `Pname`\nmust be `?GL_TEXTURE_LOD_BIAS`. When `Target` is `?GL_TEXTURE_ENV`, `Pname` can\nbe `?GL_TEXTURE_ENV_MODE`, `?GL_TEXTURE_ENV_COLOR`, `?GL_COMBINE_RGB`,\n`?GL_COMBINE_ALPHA`, `?GL_RGB_SCALE`, `?GL_ALPHA_SCALE`, `?GL_SRC0_RGB`,\n`?GL_SRC1_RGB`, `?GL_SRC2_RGB`, `?GL_SRC0_ALPHA`, `?GL_SRC1_ALPHA`, or\n`?GL_SRC2_ALPHA`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glTexEnv.xml)","ref":"gl.html#texEnviv/3"},{"type":"function","title":"gl.texGend/3","doc":"Equivalent to  texGeniv/3 .","ref":"gl.html#texGend/3"},{"type":"function","title":"gl.texGendv/3","doc":"Equivalent to  texGeniv/3 .","ref":"gl.html#texGendv/3"},{"type":"function","title":"gl.texGenf/3","doc":"Equivalent to  texGeniv/3 .","ref":"gl.html#texGenf/3"},{"type":"function","title":"gl.texGenfv/3","doc":"Equivalent to  texGeniv/3 .","ref":"gl.html#texGenfv/3"},{"type":"function","title":"gl.texGeni/3","doc":"Equivalent to  texGeniv/3 .","ref":"gl.html#texGeni/3"},{"type":"function","title":"gl.texGeniv/3","doc":"[`gl:texGen()`](`texGend/3`) selects a texture-coordinate generation function or\nsupplies coefficients for one of the functions. `Coord` names one of the (`s`,\n`t`, `r`, `q`) texture coordinates; it must be one of the symbols `?GL_S`,\n`?GL_T`, `?GL_R`, or `?GL_Q`. `Pname` must be one of three symbolic constants:\n`?GL_TEXTURE_GEN_MODE`, `?GL_OBJECT_PLANE`, or `?GL_EYE_PLANE`. If `Pname` is\n`?GL_TEXTURE_GEN_MODE`, then `Params` chooses a mode, one of\n`?GL_OBJECT_LINEAR`, `?GL_EYE_LINEAR`, `?GL_SPHERE_MAP`, `?GL_NORMAL_MAP`, or\n`?GL_REFLECTION_MAP`. If `Pname` is either `?GL_OBJECT_PLANE` or\n`?GL_EYE_PLANE`, `Params` contains coefficients for the corresponding texture\ngeneration function.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glTexGen.xml)","ref":"gl.html#texGeniv/3"},{"type":"function","title":"gl.texImage1D/8","doc":"Texturing maps a portion of a specified texture image onto each graphical\nprimitive for which texturing is enabled. To enable and disable one-dimensional\ntexturing, call [`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`)\nwith argument `?GL_TEXTURE_1D`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexImage1D.xhtml)","ref":"gl.html#texImage1D/8"},{"type":"function","title":"gl.texImage2D/9","doc":"Texturing allows elements of an image array to be read by shaders.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexImage2D.xhtml)","ref":"gl.html#texImage2D/9"},{"type":"function","title":"gl.texImage2DMultisample/6","doc":"[`gl:texImage2DMultisample/6`](`texImage2DMultisample/6`) establishes the data\nstorage, format, dimensions and number of samples of a multisample texture's\nimage.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexImage2DMultisample.xhtml)","ref":"gl.html#texImage2DMultisample/6"},{"type":"function","title":"gl.texImage3D/10","doc":"Texturing maps a portion of a specified texture image onto each graphical\nprimitive for which texturing is enabled. To enable and disable\nthree-dimensional texturing, call [`gl:enable/1`](`enable/1`) and\n[`gl:disable/1`](`enable/1`) with argument `?GL_TEXTURE_3D`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexImage3D.xhtml)","ref":"gl.html#texImage3D/10"},{"type":"function","title":"gl.texImage3DMultisample/7","doc":"[`gl:texImage3DMultisample/7`](`texImage3DMultisample/7`) establishes the data\nstorage, format, dimensions and number of samples of a multisample texture's\nimage.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexImage3DMultisample.xhtml)","ref":"gl.html#texImage3DMultisample/7"},{"type":"function","title":"gl.texParameterf/3","doc":"Equivalent to  texParameteriv/3 .","ref":"gl.html#texParameterf/3"},{"type":"function","title":"gl.texParameterfv/3","doc":"Equivalent to  texParameteriv/3 .","ref":"gl.html#texParameterfv/3"},{"type":"function","title":"gl.texParameterIiv/3","doc":"Equivalent to  texParameteriv/3 .","ref":"gl.html#texParameterIiv/3"},{"type":"function","title":"gl.texParameterIuiv/3","doc":"Equivalent to  texParameteriv/3 .","ref":"gl.html#texParameterIuiv/3"},{"type":"function","title":"gl.texParameteri/3","doc":"Equivalent to  texParameteriv/3 .","ref":"gl.html#texParameteri/3"},{"type":"function","title":"gl.texParameteriv/3","doc":"[`gl:texParameter()`](`texParameterf/3`) and\n[`gl:textureParameter()`](`texParameterf/3`) assign the value or values in\n`Params` to the texture parameter specified as `Pname`. For\n[`gl:texParameter()`](`texParameterf/3`), `Target` defines the target texture,\neither `?GL_TEXTURE_1D`, `?GL_TEXTURE_1D_ARRAY`, `?GL_TEXTURE_2D`,\n`?GL_TEXTURE_2D_ARRAY`, `?GL_TEXTURE_2D_MULTISAMPLE`,\n`?GL_TEXTURE_2D_MULTISAMPLE_ARRAY`, `?GL_TEXTURE_3D`, `?GL_TEXTURE_CUBE_MAP`,\n`?GL_TEXTURE_CUBE_MAP_ARRAY`, or `?GL_TEXTURE_RECTANGLE`. The following symbols\nare accepted in `Pname`:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexParameter.xhtml)","ref":"gl.html#texParameteriv/3"},{"type":"function","title":"gl.texStorage1D/4","doc":"[`gl:texStorage1D/4`](`texStorage1D/4`) and\n[`gl:textureStorage1D()`](`texStorage1D/4`) specify the storage requirements for\nall levels of a one-dimensional texture simultaneously. Once a texture is\nspecified with this command, the format and dimensions of all levels become\nimmutable unless it is a proxy texture. The contents of the image may still be\nmodified, however, its storage requirements may not change. Such a texture is\nreferred to as an `immutable-format` texture.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexStorage1D.xhtml)","ref":"gl.html#texStorage1D/4"},{"type":"function","title":"gl.texStorage2D/5","doc":"[`gl:texStorage2D/5`](`texStorage2D/5`) and\n[`gl:textureStorage2D()`](`texStorage2D/5`) specify the storage requirements for\nall levels of a two-dimensional texture or one-dimensional texture array\nsimultaneously. Once a texture is specified with this command, the format and\ndimensions of all levels become immutable unless it is a proxy texture. The\ncontents of the image may still be modified, however, its storage requirements\nmay not change. Such a texture is referred to as an `immutable-format` texture.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexStorage2D.xhtml)","ref":"gl.html#texStorage2D/5"},{"type":"function","title":"gl.texStorage2DMultisample/6","doc":"[`gl:texStorage2DMultisample/6`](`texStorage2DMultisample/6`) and\n[`gl:textureStorage2DMultisample()`](`texStorage2DMultisample/6`) specify the\nstorage requirements for a two-dimensional multisample texture. Once a texture\nis specified with this command, its format and dimensions become immutable\nunless it is a proxy texture. The contents of the image may still be modified,\nhowever, its storage requirements may not change. Such a texture is referred to\nas an `immutable-format` texture.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexStorage2DMultisample.xhtml)","ref":"gl.html#texStorage2DMultisample/6"},{"type":"function","title":"gl.texStorage3D/6","doc":"[`gl:texStorage3D/6`](`texStorage3D/6`) and\n[`gl:textureStorage3D()`](`texStorage3D/6`) specify the storage requirements for\nall levels of a three-dimensional, two-dimensional array or cube-map array\ntexture simultaneously. Once a texture is specified with this command, the\nformat and dimensions of all levels become immutable unless it is a proxy\ntexture. The contents of the image may still be modified, however, its storage\nrequirements may not change. Such a texture is referred to as an\n`immutable-format` texture.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexStorage3D.xhtml)","ref":"gl.html#texStorage3D/6"},{"type":"function","title":"gl.texStorage3DMultisample/7","doc":"[`gl:texStorage3DMultisample/7`](`texStorage3DMultisample/7`) and\n[`gl:textureStorage3DMultisample()`](`texStorage3DMultisample/7`) specify the\nstorage requirements for a two-dimensional multisample array texture. Once a\ntexture is specified with this command, its format and dimensions become\nimmutable unless it is a proxy texture. The contents of the image may still be\nmodified, however, its storage requirements may not change. Such a texture is\nreferred to as an `immutable-format` texture.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexStorage3DMultisample.xhtml)","ref":"gl.html#texStorage3DMultisample/7"},{"type":"function","title":"gl.texSubImage1D/7","doc":"Texturing maps a portion of a specified texture image onto each graphical\nprimitive for which texturing is enabled. To enable or disable one-dimensional\ntexturing, call [`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`)\nwith argument `?GL_TEXTURE_1D`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexSubImage1D.xhtml)","ref":"gl.html#texSubImage1D/7"},{"type":"function","title":"gl.texSubImage2D/9","doc":"Texturing maps a portion of a specified texture image onto each graphical\nprimitive for which texturing is enabled.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexSubImage2D.xhtml)","ref":"gl.html#texSubImage2D/9"},{"type":"function","title":"gl.texSubImage3D/11","doc":"Texturing maps a portion of a specified texture image onto each graphical\nprimitive for which texturing is enabled.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexSubImage3D.xhtml)","ref":"gl.html#texSubImage3D/11"},{"type":"function","title":"gl.textureBarrier/0","doc":"The values of rendered fragments are undefined when a shader stage fetches\ntexels and the same texels are written via fragment shader outputs, even if the\nreads and writes are not in the same drawing command. To safely read the result\nof a written texel via a texel fetch in a subsequent drawing command, call\n[`gl:textureBarrier/0`](`textureBarrier/0`) between the two drawing commands to\nguarantee that writes have completed and caches have been invalidated before\nsubsequent drawing commands are executed.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTextureBarrier.xhtml)","ref":"gl.html#textureBarrier/0"},{"type":"function","title":"gl.textureBuffer/3","doc":"[`gl:texBuffer/3`](`texBuffer/3`) and [`gl:textureBuffer/3`](`texBuffer/3`)\nattaches the data store of a specified buffer object to a specified texture\nobject, and specify the storage format for the texture image found in the buffer\nobject. The texture object must be a buffer texture.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexBuffer.xhtml)","ref":"gl.html#textureBuffer/3"},{"type":"function","title":"gl.textureBufferRange/5","doc":"[`gl:texBufferRange/5`](`texBufferRange/5`) and\n[`gl:textureBufferRange/5`](`texBufferRange/5`) attach a range of the data store\nof a specified buffer object to a specified texture object, and specify the\nstorage format for the texture image found in the buffer object. The texture\nobject must be a buffer texture.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexBufferRange.xhtml)","ref":"gl.html#textureBufferRange/5"},{"type":"function","title":"gl.textureView/8","doc":"[`gl:textureView/8`](`textureView/8`) initializes a texture object as an alias,\nor view of another texture object, sharing some or all of the parent texture's\ndata store with the initialized texture. `Texture` specifies a name previously\nreserved by a successful call to [`gl:genTextures/1`](`genTextures/1`) but that\nhas not yet been bound or given a target. `Target` specifies the target for the\nnewly initialized texture and must be compatible with the target of the parent\ntexture, given in `Origtexture` as specified in the following table:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTextureView.xhtml)","ref":"gl.html#textureView/8"},{"type":"function","title":"gl.transformFeedbackBufferBase/3","doc":"[`gl:transformFeedbackBufferBase/3`](`transformFeedbackBufferBase/3`) binds the\nbuffer object `Buffer` to the binding point at index `Index` of the transform\nfeedback object `Xfb`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTransformFeedbackBufferBase.xhtml)","ref":"gl.html#transformFeedbackBufferBase/3"},{"type":"function","title":"gl.transformFeedbackBufferRange/5","doc":"[`gl:transformFeedbackBufferRange/5`](`transformFeedbackBufferRange/5`) binds a\nrange of the buffer object `Buffer` represented by `Offset` and `Size` to the\nbinding point at index `Index` of the transform feedback object `Xfb`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTransformFeedbackBufferRange.xhtml)","ref":"gl.html#transformFeedbackBufferRange/5"},{"type":"function","title":"gl.transformFeedbackVaryings/3","doc":"The names of the vertex or geometry shader outputs to be recorded in transform\nfeedback mode are specified using\n[`gl:transformFeedbackVaryings/3`](`transformFeedbackVaryings/3`). When a\ngeometry shader is active, transform feedback records the values of selected\ngeometry shader output variables from the emitted vertices. Otherwise, the\nvalues of the selected vertex shader outputs are recorded.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTransformFeedbackVaryings.xhtml)","ref":"gl.html#transformFeedbackVaryings/3"},{"type":"function","title":"gl.translated/3","doc":"Equivalent to  translatef/3 .","ref":"gl.html#translated/3"},{"type":"function","title":"gl.translatef/3","doc":"[`gl:translate()`](`translated/3`) produces a translation by (x y z). The\ncurrent matrix (see [`gl:matrixMode/1`](`matrixMode/1`)) is multiplied by this\ntranslation matrix, with the product replacing the current matrix, as if\n[`gl:multMatrix()`](`multMatrixd/1`) were called with the following matrix for\nits argument:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glTranslate.xml)","ref":"gl.html#translatef/3"},{"type":"function","title":"gl.uniform1d/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform1d/2"},{"type":"function","title":"gl.uniform1dv/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform1dv/2"},{"type":"function","title":"gl.uniform1f/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform1f/2"},{"type":"function","title":"gl.uniform1fv/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform1fv/2"},{"type":"function","title":"gl.uniform1i/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform1i/2"},{"type":"function","title":"gl.uniform1iv/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform1iv/2"},{"type":"function","title":"gl.uniform1ui/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform1ui/2"},{"type":"function","title":"gl.uniform1uiv/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform1uiv/2"},{"type":"function","title":"gl.uniform2d/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform2d/3"},{"type":"function","title":"gl.uniform2dv/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform2dv/2"},{"type":"function","title":"gl.uniform2f/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform2f/3"},{"type":"function","title":"gl.uniform2fv/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform2fv/2"},{"type":"function","title":"gl.uniform2i/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform2i/3"},{"type":"function","title":"gl.uniform2iv/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform2iv/2"},{"type":"function","title":"gl.uniform2ui/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform2ui/3"},{"type":"function","title":"gl.uniform2uiv/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform2uiv/2"},{"type":"function","title":"gl.uniform3d/4","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform3d/4"},{"type":"function","title":"gl.uniform3dv/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform3dv/2"},{"type":"function","title":"gl.uniform3f/4","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform3f/4"},{"type":"function","title":"gl.uniform3fv/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform3fv/2"},{"type":"function","title":"gl.uniform3i/4","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform3i/4"},{"type":"function","title":"gl.uniform3iv/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform3iv/2"},{"type":"function","title":"gl.uniform3ui/4","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform3ui/4"},{"type":"function","title":"gl.uniform3uiv/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform3uiv/2"},{"type":"function","title":"gl.uniform4d/5","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform4d/5"},{"type":"function","title":"gl.uniform4dv/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform4dv/2"},{"type":"function","title":"gl.uniform4f/5","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform4f/5"},{"type":"function","title":"gl.uniform4fv/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform4fv/2"},{"type":"function","title":"gl.uniform4i/5","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform4i/5"},{"type":"function","title":"gl.uniform4iv/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform4iv/2"},{"type":"function","title":"gl.uniform4ui/5","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform4ui/5"},{"type":"function","title":"gl.uniform4uiv/2","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniform4uiv/2"},{"type":"function","title":"gl.uniformBlockBinding/3","doc":"Binding points for active uniform blocks are assigned using\n[`gl:uniformBlockBinding/3`](`uniformBlockBinding/3`). Each of a program's\nactive uniform blocks has a corresponding uniform buffer binding point.\n`Program` is the name of a program object for which the command\n[`gl:linkProgram/1`](`linkProgram/1`) has been issued in the past.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniformBlockBinding.xhtml)","ref":"gl.html#uniformBlockBinding/3"},{"type":"function","title":"gl.uniformMatrix2dv/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniformMatrix2dv/3"},{"type":"function","title":"gl.uniformMatrix2fv/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniformMatrix2fv/3"},{"type":"function","title":"gl.uniformMatrix2x3dv/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniformMatrix2x3dv/3"},{"type":"function","title":"gl.uniformMatrix2x3fv/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniformMatrix2x3fv/3"},{"type":"function","title":"gl.uniformMatrix2x4dv/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniformMatrix2x4dv/3"},{"type":"function","title":"gl.uniformMatrix2x4fv/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniformMatrix2x4fv/3"},{"type":"function","title":"gl.uniformMatrix3dv/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniformMatrix3dv/3"},{"type":"function","title":"gl.uniformMatrix3fv/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniformMatrix3fv/3"},{"type":"function","title":"gl.uniformMatrix3x2dv/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniformMatrix3x2dv/3"},{"type":"function","title":"gl.uniformMatrix3x2fv/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniformMatrix3x2fv/3"},{"type":"function","title":"gl.uniformMatrix3x4dv/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniformMatrix3x4dv/3"},{"type":"function","title":"gl.uniformMatrix3x4fv/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniformMatrix3x4fv/3"},{"type":"function","title":"gl.uniformMatrix4dv/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniformMatrix4dv/3"},{"type":"function","title":"gl.uniformMatrix4fv/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniformMatrix4fv/3"},{"type":"function","title":"gl.uniformMatrix4x2dv/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniformMatrix4x2dv/3"},{"type":"function","title":"gl.uniformMatrix4x2fv/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniformMatrix4x2fv/3"},{"type":"function","title":"gl.uniformMatrix4x3dv/3","doc":"Equivalent to  uniformMatrix4x3fv/3 .","ref":"gl.html#uniformMatrix4x3dv/3"},{"type":"function","title":"gl.uniformMatrix4x3fv/3","doc":"[`gl:uniform()`](`uniform1f/2`) modifies the value of a uniform variable or a\nuniform variable array. The location of the uniform variable to be modified is\nspecified by `Location`, which should be a value returned by\n[`gl:getUniformLocation/2`](`getUniformLocation/2`).\n[`gl:uniform()`](`uniform1f/2`) operates on the program object that was made\npart of current state by calling [`gl:useProgram/1`](`useProgram/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniform.xhtml)","ref":"gl.html#uniformMatrix4x3fv/3"},{"type":"function","title":"gl.uniformSubroutinesuiv/2","doc":"[`gl:uniformSubroutines()`](`uniformSubroutinesuiv/2`) loads all active\nsubroutine uniforms for shader stage `Shadertype` of the current program with\nsubroutine indices from `Indices`, storing `Indices[i]` into the uniform at\nlocation `I`. `Count` must be equal to the value of\n`?GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS` for the program currently in use at\nshader stage `Shadertype`. Furthermore, all values in `Indices` must be less\nthan the value of `?GL_ACTIVE_SUBROUTINES` for the shader stage.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniformSubroutines.xhtml)","ref":"gl.html#uniformSubroutinesuiv/2"},{"type":"function","title":"gl.useProgram/1","doc":"[`gl:useProgram/1`](`useProgram/1`) installs the program object specified by\n`Program` as part of current rendering state. One or more executables are\ncreated in a program object by successfully attaching shader objects to it with\n[`gl:attachShader/2`](`attachShader/2`), successfully compiling the shader\nobjects with [`gl:compileShader/1`](`compileShader/1`), and successfully linking\nthe program object with [`gl:linkProgram/1`](`linkProgram/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUseProgram.xhtml)","ref":"gl.html#useProgram/1"},{"type":"function","title":"gl.useProgramStages/3","doc":"[`gl:useProgramStages/3`](`useProgramStages/3`) binds executables from a program\nobject associated with a specified set of shader stages to the program pipeline\nobject given by `Pipeline`. `Pipeline` specifies the program pipeline object to\nwhich to bind the executables. `Stages` contains a logical combination of bits\nindicating the shader stages to use within `Program` with the program pipeline\nobject `Pipeline`. `Stages` must be a logical combination of\n`?GL_VERTEX_SHADER_BIT`, `?GL_TESS_CONTROL_SHADER_BIT`,\n`?GL_TESS_EVALUATION_SHADER_BIT`, `?GL_GEOMETRY_SHADER_BIT`,\n`?GL_FRAGMENT_SHADER_BIT` and `?GL_COMPUTE_SHADER_BIT`. Additionally, the\nspecial value `?GL_ALL_SHADER_BITS` may be specified to indicate that all\nexecutables contained in `Program` should be installed in `Pipeline`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUseProgramStages.xhtml)","ref":"gl.html#useProgramStages/3"},{"type":"function","title":"gl.validateProgram/1","doc":"[`gl:validateProgram/1`](`validateProgram/1`) checks to see whether the\nexecutables contained in `Program` can execute given the current OpenGL state.\nThe information generated by the validation process will be stored in\n`Program`'s information log. The validation information may consist of an empty\nstring, or it may be a string containing information about how the current\nprogram object interacts with the rest of current OpenGL state. This provides a\nway for OpenGL implementers to convey more information about why the current\nprogram is inefficient, suboptimal, failing to execute, and so on.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glValidateProgram.xhtml)","ref":"gl.html#validateProgram/1"},{"type":"function","title":"gl.validateProgramPipeline/1","doc":"[`gl:validateProgramPipeline/1`](`validateProgramPipeline/1`) instructs the\nimplementation to validate the shader executables contained in `Pipeline`\nagainst the current GL state. The implementation may use this as an opportunity\nto perform any internal shader modifications that may be required to ensure\ncorrect operation of the installed shaders given the current GL state.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glValidateProgramPipeline.xhtml)","ref":"gl.html#validateProgramPipeline/1"},{"type":"function","title":"gl.vertex2d/2","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex2d/2"},{"type":"function","title":"gl.vertex2dv/1","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex2dv/1"},{"type":"function","title":"gl.vertex2f/2","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex2f/2"},{"type":"function","title":"gl.vertex2fv/1","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex2fv/1"},{"type":"function","title":"gl.vertex2i/2","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex2i/2"},{"type":"function","title":"gl.vertex2iv/1","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex2iv/1"},{"type":"function","title":"gl.vertex2s/2","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex2s/2"},{"type":"function","title":"gl.vertex2sv/1","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex2sv/1"},{"type":"function","title":"gl.vertex3d/3","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex3d/3"},{"type":"function","title":"gl.vertex3dv/1","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex3dv/1"},{"type":"function","title":"gl.vertex3f/3","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex3f/3"},{"type":"function","title":"gl.vertex3fv/1","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex3fv/1"},{"type":"function","title":"gl.vertex3i/3","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex3i/3"},{"type":"function","title":"gl.vertex3iv/1","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex3iv/1"},{"type":"function","title":"gl.vertex3s/3","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex3s/3"},{"type":"function","title":"gl.vertex3sv/1","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex3sv/1"},{"type":"function","title":"gl.vertex4d/4","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex4d/4"},{"type":"function","title":"gl.vertex4dv/1","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex4dv/1"},{"type":"function","title":"gl.vertex4f/4","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex4f/4"},{"type":"function","title":"gl.vertex4fv/1","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex4fv/1"},{"type":"function","title":"gl.vertex4i/4","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex4i/4"},{"type":"function","title":"gl.vertex4iv/1","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex4iv/1"},{"type":"function","title":"gl.vertex4s/4","doc":"Equivalent to  vertex4sv/1 .","ref":"gl.html#vertex4s/4"},{"type":"function","title":"gl.vertex4sv/1","doc":"[`gl:vertex()`](`vertex2d/2`) commands are used within\n[`gl:'begin'/1`](`'begin'/1`)/[`gl:'end'/0`](`'begin'/1`) pairs to specify\npoint, line, and polygon vertices. The current color, normal, texture\ncoordinates, and fog coordinate are associated with the vertex when\n[`gl:vertex()`](`vertex2d/2`) is called.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glVertex.xml)","ref":"gl.html#vertex4sv/1"},{"type":"function","title":"gl.vertexArrayAttribBinding/3","doc":"Equivalent to  vertexAttribBinding/2 .","ref":"gl.html#vertexArrayAttribBinding/3"},{"type":"function","title":"gl.vertexArrayAttribFormat/6","doc":"Equivalent to  vertexAttribLPointer/5 .","ref":"gl.html#vertexArrayAttribFormat/6"},{"type":"function","title":"gl.vertexArrayAttribIFormat/5","doc":"Equivalent to  vertexAttribLPointer/5 .","ref":"gl.html#vertexArrayAttribIFormat/5"},{"type":"function","title":"gl.vertexArrayAttribLFormat/5","doc":"Equivalent to  vertexAttribLPointer/5 .","ref":"gl.html#vertexArrayAttribLFormat/5"},{"type":"function","title":"gl.vertexArrayBindingDivisor/3","doc":"Equivalent to  vertexBindingDivisor/2 .","ref":"gl.html#vertexArrayBindingDivisor/3"},{"type":"function","title":"gl.vertexArrayElementBuffer/2","doc":"[`gl:vertexArrayElementBuffer/2`](`vertexArrayElementBuffer/2`) binds a buffer\nobject with id `Buffer` to the element array buffer bind point of a vertex array\nobject with id `Vaobj`. If `Buffer` is zero, any existing element array buffer\nbinding to `Vaobj` is removed.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glVertexArrayElementBuffer.xhtml)","ref":"gl.html#vertexArrayElementBuffer/2"},{"type":"function","title":"gl.vertexArrayVertexBuffer/5","doc":"[`gl:bindVertexBuffer/4`](`bindVertexBuffer/4`) and\n[`gl:vertexArrayVertexBuffer/5`](`bindVertexBuffer/4`) bind the buffer named\n`Buffer` to the vertex buffer binding point whose index is given by\n`Bindingindex`. [`gl:bindVertexBuffer/4`](`bindVertexBuffer/4`) modifies the\nbinding of the currently bound vertex array object, whereas\n[`gl:vertexArrayVertexBuffer/5`](`bindVertexBuffer/4`) allows the caller to\nspecify ID of the vertex array object with an argument named `Vaobj`, for which\nthe binding should be modified. `Offset` and `Stride` specify the offset of the\nfirst element within the buffer and the distance between elements within the\nbuffer, respectively, and are both measured in basic machine units.\n`Bindingindex` must be less than the value of `?GL_MAX_VERTEX_ATTRIB_BINDINGS`.\n`Offset` and `Stride` must be greater than or equal to zero. If `Buffer` is\nzero, then any buffer currently bound to the specified binding point is unbound.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindVertexBuffer.xhtml)","ref":"gl.html#vertexArrayVertexBuffer/5"},{"type":"function","title":"gl.vertexArrayVertexBuffers/5","doc":"[`gl:bindVertexBuffers/4`](`bindVertexBuffers/4`) and\n[`gl:vertexArrayVertexBuffers/5`](`bindVertexBuffers/4`) bind storage from an\narray of existing buffer objects to a specified number of consecutive vertex\nbuffer binding points units in a vertex array object. For\n[`gl:bindVertexBuffers/4`](`bindVertexBuffers/4`), the vertex array object is\nthe currently bound vertex array object. For\n[`gl:vertexArrayVertexBuffers/5`](`bindVertexBuffers/4`), `Vaobj` is the name of\nthe vertex array object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindVertexBuffers.xhtml)","ref":"gl.html#vertexArrayVertexBuffers/5"},{"type":"function","title":"gl.vertexAttrib1d/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib1d/2"},{"type":"function","title":"gl.vertexAttrib1dv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib1dv/2"},{"type":"function","title":"gl.vertexAttrib1f/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib1f/2"},{"type":"function","title":"gl.vertexAttrib1fv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib1fv/2"},{"type":"function","title":"gl.vertexAttrib1s/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib1s/2"},{"type":"function","title":"gl.vertexAttrib1sv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib1sv/2"},{"type":"function","title":"gl.vertexAttrib2d/3","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib2d/3"},{"type":"function","title":"gl.vertexAttrib2dv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib2dv/2"},{"type":"function","title":"gl.vertexAttrib2f/3","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib2f/3"},{"type":"function","title":"gl.vertexAttrib2fv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib2fv/2"},{"type":"function","title":"gl.vertexAttrib2s/3","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib2s/3"},{"type":"function","title":"gl.vertexAttrib2sv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib2sv/2"},{"type":"function","title":"gl.vertexAttrib3d/4","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib3d/4"},{"type":"function","title":"gl.vertexAttrib3dv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib3dv/2"},{"type":"function","title":"gl.vertexAttrib3f/4","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib3f/4"},{"type":"function","title":"gl.vertexAttrib3fv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib3fv/2"},{"type":"function","title":"gl.vertexAttrib3s/4","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib3s/4"},{"type":"function","title":"gl.vertexAttrib3sv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib3sv/2"},{"type":"function","title":"gl.vertexAttrib4bv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib4bv/2"},{"type":"function","title":"gl.vertexAttrib4d/5","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib4d/5"},{"type":"function","title":"gl.vertexAttrib4dv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib4dv/2"},{"type":"function","title":"gl.vertexAttrib4f/5","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib4f/5"},{"type":"function","title":"gl.vertexAttrib4fv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib4fv/2"},{"type":"function","title":"gl.vertexAttrib4iv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib4iv/2"},{"type":"function","title":"gl.vertexAttrib4Nbv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib4Nbv/2"},{"type":"function","title":"gl.vertexAttrib4Niv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib4Niv/2"},{"type":"function","title":"gl.vertexAttrib4Nsv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib4Nsv/2"},{"type":"function","title":"gl.vertexAttrib4Nub/5","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib4Nub/5"},{"type":"function","title":"gl.vertexAttrib4Nubv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib4Nubv/2"},{"type":"function","title":"gl.vertexAttrib4Nuiv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib4Nuiv/2"},{"type":"function","title":"gl.vertexAttrib4Nusv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib4Nusv/2"},{"type":"function","title":"gl.vertexAttrib4s/5","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib4s/5"},{"type":"function","title":"gl.vertexAttrib4sv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib4sv/2"},{"type":"function","title":"gl.vertexAttrib4ubv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib4ubv/2"},{"type":"function","title":"gl.vertexAttrib4uiv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib4uiv/2"},{"type":"function","title":"gl.vertexAttrib4usv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttrib4usv/2"},{"type":"function","title":"gl.vertexAttribBinding/2","doc":"[`gl:vertexAttribBinding/2`](`vertexAttribBinding/2`) and\n[`gl:vertexArrayAttribBinding/3`](`vertexAttribBinding/2`) establishes an\nassociation between the generic vertex attribute of a vertex array object whose\nindex is given by `Attribindex`, and a vertex buffer binding whose index is\ngiven by `Bindingindex`. For\n[`gl:vertexAttribBinding/2`](`vertexAttribBinding/2`), the vertex array object\naffected is that currently bound. For\n[`gl:vertexArrayAttribBinding/3`](`vertexAttribBinding/2`), `Vaobj` is the name\nof the vertex array object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glVertexAttribBinding.xhtml)","ref":"gl.html#vertexAttribBinding/2"},{"type":"function","title":"gl.vertexAttribDivisor/2","doc":"[`gl:vertexAttribDivisor/2`](`vertexAttribDivisor/2`) modifies the rate at which\ngeneric vertex attributes advance when rendering multiple instances of\nprimitives in a single draw call. If `Divisor` is zero, the attribute at slot\n`Index` advances once per vertex. If `Divisor` is non-zero, the attribute\nadvances once per `Divisor` instances of the set(s) of vertices being rendered.\nAn attribute is referred to as instanced if its\n`?GL_VERTEX_ATTRIB_ARRAY_DIVISOR` value is non-zero.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glVertexAttribDivisor.xhtml)","ref":"gl.html#vertexAttribDivisor/2"},{"type":"function","title":"gl.vertexAttribFormat/5","doc":"Equivalent to  vertexAttribLPointer/5 .","ref":"gl.html#vertexAttribFormat/5"},{"type":"function","title":"gl.vertexAttribI1i/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI1i/2"},{"type":"function","title":"gl.vertexAttribI1iv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI1iv/2"},{"type":"function","title":"gl.vertexAttribI1ui/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI1ui/2"},{"type":"function","title":"gl.vertexAttribI1uiv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI1uiv/2"},{"type":"function","title":"gl.vertexAttribI2i/3","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI2i/3"},{"type":"function","title":"gl.vertexAttribI2iv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI2iv/2"},{"type":"function","title":"gl.vertexAttribI2ui/3","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI2ui/3"},{"type":"function","title":"gl.vertexAttribI2uiv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI2uiv/2"},{"type":"function","title":"gl.vertexAttribI3i/4","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI3i/4"},{"type":"function","title":"gl.vertexAttribI3iv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI3iv/2"},{"type":"function","title":"gl.vertexAttribI3ui/4","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI3ui/4"},{"type":"function","title":"gl.vertexAttribI3uiv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI3uiv/2"},{"type":"function","title":"gl.vertexAttribI4bv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI4bv/2"},{"type":"function","title":"gl.vertexAttribI4i/5","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI4i/5"},{"type":"function","title":"gl.vertexAttribI4iv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI4iv/2"},{"type":"function","title":"gl.vertexAttribI4sv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI4sv/2"},{"type":"function","title":"gl.vertexAttribI4ubv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI4ubv/2"},{"type":"function","title":"gl.vertexAttribI4ui/5","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI4ui/5"},{"type":"function","title":"gl.vertexAttribI4uiv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI4uiv/2"},{"type":"function","title":"gl.vertexAttribI4usv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribI4usv/2"},{"type":"function","title":"gl.vertexAttribIFormat/4","doc":"Equivalent to  vertexAttribLPointer/5 .","ref":"gl.html#vertexAttribIFormat/4"},{"type":"function","title":"gl.vertexAttribIPointer/5","doc":"Equivalent to  vertexAttribLPointer/5 .","ref":"gl.html#vertexAttribIPointer/5"},{"type":"function","title":"gl.vertexAttribL1d/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribL1d/2"},{"type":"function","title":"gl.vertexAttribL1dv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribL1dv/2"},{"type":"function","title":"gl.vertexAttribL2d/3","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribL2d/3"},{"type":"function","title":"gl.vertexAttribL2dv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribL2dv/2"},{"type":"function","title":"gl.vertexAttribL3d/4","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribL3d/4"},{"type":"function","title":"gl.vertexAttribL3dv/2","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribL3dv/2"},{"type":"function","title":"gl.vertexAttribL4d/5","doc":"Equivalent to  vertexAttribL4dv/2 .","ref":"gl.html#vertexAttribL4d/5"},{"type":"function","title":"gl.vertexAttribL4dv/2","doc":"The [`gl:vertexAttrib()`](`vertexAttrib1d/2`) family of entry points allows an\napplication to pass generic vertex attributes in numbered locations.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glVertexAttrib.xhtml)","ref":"gl.html#vertexAttribL4dv/2"},{"type":"function","title":"gl.vertexAttribLFormat/4","doc":"Equivalent to  vertexAttribLPointer/5 .","ref":"gl.html#vertexAttribLFormat/4"},{"type":"function","title":"gl.vertexAttribLPointer/5","doc":"[`gl:vertexAttribFormat/5`](`vertexAttribFormat/5`),\n[`gl:vertexAttribIFormat/4`](`vertexAttribIPointer/5`) and\n[`gl:vertexAttribLFormat/4`](`vertexAttribIPointer/5`), as well as\n[`gl:vertexArrayAttribFormat/6`](`vertexAttribIPointer/5`),\n[`gl:vertexArrayAttribIFormat/5`](`vertexAttribIPointer/5`) and\n[`gl:vertexArrayAttribLFormat/5`](`vertexAttribIPointer/5`) specify the\norganization of data in vertex arrays. The first three calls operate on the\nbound vertex array object, whereas the last three ones modify the state of a\nvertex array object with ID `Vaobj`. `Attribindex` specifies the index of the\ngeneric vertex attribute array whose data layout is being described, and must be\nless than the value of `?GL_MAX_VERTEX_ATTRIBS`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glVertexAttribFormat.xhtml)","ref":"gl.html#vertexAttribLPointer/5"},{"type":"function","title":"gl.vertexAttribPointer/6","doc":"[`gl:vertexAttribPointer/6`](`vertexAttribPointer/6`),\n[`gl:vertexAttribIPointer/5`](`vertexAttribIPointer/5`) and\n[`gl:vertexAttribLPointer/5`](`vertexAttribIPointer/5`) specify the location and\ndata format of the array of generic vertex attributes at index `Index` to use\nwhen rendering. `Size` specifies the number of components per attribute and must\nbe 1, 2, 3, 4, or `?GL_BGRA`. `Type` specifies the data type of each component,\nand `Stride` specifies the byte stride from one attribute to the next, allowing\nvertices and attributes to be packed into a single array or stored in separate\narrays.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glVertexAttribPointer.xhtml)","ref":"gl.html#vertexAttribPointer/6"},{"type":"function","title":"gl.vertexBindingDivisor/2","doc":"[`gl:vertexBindingDivisor/2`](`vertexBindingDivisor/2`) and\n[`gl:vertexArrayBindingDivisor/3`](`vertexBindingDivisor/2`) modify the rate at\nwhich generic vertex attributes advance when rendering multiple instances of\nprimitives in a single draw command. If `Divisor` is zero, the attributes using\nthe buffer bound to `Bindingindex` advance once per vertex. If `Divisor` is\nnon-zero, the attributes advance once per `Divisor` instances of the set(s) of\nvertices being rendered. An attribute is referred to as `instanced` if the\ncorresponding `Divisor` value is non-zero.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glVertexBindingDivisor.xhtml)","ref":"gl.html#vertexBindingDivisor/2"},{"type":"function","title":"gl.vertexPointer/4","doc":"[`gl:vertexPointer/4`](`vertexPointer/4`) specifies the location and data format\nof an array of vertex coordinates to use when rendering. `Size` specifies the\nnumber of coordinates per vertex, and must be 2, 3, or 4. `Type` specifies the\ndata type of each coordinate, and `Stride` specifies the byte stride from one\nvertex to the next, allowing vertices and attributes to be packed into a single\narray or stored in separate arrays. (Single-array storage may be more efficient\non some implementations; see [`gl:interleavedArrays/3`](`interleavedArrays/3`).)\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glVertexPointer.xml)","ref":"gl.html#vertexPointer/4"},{"type":"function","title":"gl.viewport/4","doc":"[`gl:viewport/4`](`viewport/4`) specifies the affine transformation of x and y\nfrom normalized device coordinates to window coordinates. Let (x nd y nd) be\nnormalized device coordinates. Then the window coordinates (x w y w) are\ncomputed as follows:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glViewport.xhtml)","ref":"gl.html#viewport/4"},{"type":"function","title":"gl.viewportArrayv/2","doc":"[`gl:viewportArrayv/2`](`viewportArrayv/2`) specifies the parameters for\nmultiple viewports simulataneously. `First` specifies the index of the first\nviewport to modify and `Count` specifies the number of viewports to modify.\n`First` must be less than the value of `?GL_MAX_VIEWPORTS`, and `First` \\+\n`Count` must be less than or equal to the value of `?GL_MAX_VIEWPORTS`.\nViewports whose indices lie outside the range [`First`, `First` \\+ `Count`) are\nnot modified. `V` contains the address of an array of floating point values\nspecifying the left ( x), bottom ( y), width ( w), and height ( h) of each\nviewport, in that order. x and y give the location of the viewport's lower left\ncorner, and w and h give the width and height of the viewport, respectively. The\nviewport specifies the affine transformation of x and y from normalized device\ncoordinates to window coordinates. Let (x nd y nd) be normalized device\ncoordinates. Then the window coordinates (x w y w) are computed as follows:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glViewportArray.xhtml)","ref":"gl.html#viewportArrayv/2"},{"type":"function","title":"gl.viewportIndexedf/5","doc":"Equivalent to  viewportIndexedfv/2 .","ref":"gl.html#viewportIndexedf/5"},{"type":"function","title":"gl.viewportIndexedfv/2","doc":"[`gl:viewportIndexedf/5`](`viewportIndexedf/5`) and\n[`gl:viewportIndexedfv/2`](`viewportIndexedf/5`) specify the parameters for a\nsingle viewport. `Index` specifies the index of the viewport to modify. `Index`\nmust be less than the value of `?GL_MAX_VIEWPORTS`. For\n[`gl:viewportIndexedf/5`](`viewportIndexedf/5`), `X`, `Y`, `W`, and `H` specify\nthe left, bottom, width and height of the viewport in pixels, respectively. For\n[`gl:viewportIndexedfv/2`](`viewportIndexedf/5`), `V` contains the address of an\narray of floating point values specifying the left ( x), bottom ( y), width (\nw), and height ( h) of each viewport, in that order. x and y give the location\nof the viewport's lower left corner, and w and h give the width and height of\nthe viewport, respectively. The viewport specifies the affine transformation of\nx and y from normalized device coordinates to window coordinates. Let (x nd y\nnd) be normalized device coordinates. Then the window coordinates (x w y w) are\ncomputed as follows:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glViewportIndexed.xhtml)","ref":"gl.html#viewportIndexedfv/2"},{"type":"function","title":"gl.waitSync/3","doc":"[`gl:waitSync/3`](`waitSync/3`) causes the GL server to block and wait until\n`Sync` becomes signaled. `Sync` is the name of an existing sync object upon\nwhich to wait. `Flags` and `Timeout` are currently not used and must be set to\nzero and the special value `?GL_TIMEOUT_IGNORED`, respectively\n\n`Flags` and `Timeout` are placeholders for anticipated future extensions of sync\nobject capabilities. They must have these reserved values in order that existing\ncode calling [`gl:waitSync/3`](`waitSync/3`) operate properly in the presence of\nsuch extensions.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glWaitSync.xhtml)","ref":"gl.html#waitSync/3"},{"type":"function","title":"gl.windowPos2d/2","doc":"Equivalent to  windowPos3sv/1 .","ref":"gl.html#windowPos2d/2"},{"type":"function","title":"gl.windowPos2dv/1","doc":"Equivalent to  windowPos3sv/1 .","ref":"gl.html#windowPos2dv/1"},{"type":"function","title":"gl.windowPos2f/2","doc":"Equivalent to  windowPos3sv/1 .","ref":"gl.html#windowPos2f/2"},{"type":"function","title":"gl.windowPos2fv/1","doc":"Equivalent to  windowPos3sv/1 .","ref":"gl.html#windowPos2fv/1"},{"type":"function","title":"gl.windowPos2i/2","doc":"Equivalent to  windowPos3sv/1 .","ref":"gl.html#windowPos2i/2"},{"type":"function","title":"gl.windowPos2iv/1","doc":"Equivalent to  windowPos3sv/1 .","ref":"gl.html#windowPos2iv/1"},{"type":"function","title":"gl.windowPos2s/2","doc":"Equivalent to  windowPos3sv/1 .","ref":"gl.html#windowPos2s/2"},{"type":"function","title":"gl.windowPos2sv/1","doc":"Equivalent to  windowPos3sv/1 .","ref":"gl.html#windowPos2sv/1"},{"type":"function","title":"gl.windowPos3d/3","doc":"Equivalent to  windowPos3sv/1 .","ref":"gl.html#windowPos3d/3"},{"type":"function","title":"gl.windowPos3dv/1","doc":"Equivalent to  windowPos3sv/1 .","ref":"gl.html#windowPos3dv/1"},{"type":"function","title":"gl.windowPos3f/3","doc":"Equivalent to  windowPos3sv/1 .","ref":"gl.html#windowPos3f/3"},{"type":"function","title":"gl.windowPos3fv/1","doc":"Equivalent to  windowPos3sv/1 .","ref":"gl.html#windowPos3fv/1"},{"type":"function","title":"gl.windowPos3i/3","doc":"Equivalent to  windowPos3sv/1 .","ref":"gl.html#windowPos3i/3"},{"type":"function","title":"gl.windowPos3iv/1","doc":"Equivalent to  windowPos3sv/1 .","ref":"gl.html#windowPos3iv/1"},{"type":"function","title":"gl.windowPos3s/3","doc":"Equivalent to  windowPos3sv/1 .","ref":"gl.html#windowPos3s/3"},{"type":"function","title":"gl.windowPos3sv/1","doc":"The GL maintains a 3D position in window coordinates. This position, called the\nraster position, is used to position pixel and bitmap write operations. It is\nmaintained with subpixel accuracy. See [`gl:bitmap/7`](`bitmap/7`),\n[`gl:drawPixels/5`](`drawPixels/5`), and [`gl:copyPixels/5`](`copyPixels/5`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glWindowPos.xml)","ref":"gl.html#windowPos3sv/1"},{"type":"module","title":"glu","doc":"Erlang wrapper functions for OpenGL\n\nStandard OpenGL API\n\nThis documents the functions as a brief version of the complete\n[OpenGL reference pages.](https://www.khronos.org/registry/OpenGL-Refpages/)","ref":"glu.html"},{"type":"function","title":"glu.build1DMipmapLevels/9","doc":"[`glu:build1DMipmapLevels/9`](`build1DMipmapLevels/9`) builds a subset of\nprefiltered one-dimensional texture maps of decreasing resolutions called a\nmipmap. This is used for the antialiasing of texture mapped primitives.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluBuild1DMipmapLevels.xml)","ref":"glu.html#build1DMipmapLevels/9"},{"type":"function","title":"glu.build1DMipmaps/6","doc":"[`glu:build1DMipmaps/6`](`build1DMipmaps/6`) builds a series of prefiltered\none-dimensional texture maps of decreasing resolutions called a mipmap. This is\nused for the antialiasing of texture mapped primitives.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluBuild1DMipmaps.xml)","ref":"glu.html#build1DMipmaps/6"},{"type":"function","title":"glu.build2DMipmapLevels/10","doc":"[`glu:build2DMipmapLevels/10`](`build2DMipmapLevels/10`) builds a subset of\nprefiltered two-dimensional texture maps of decreasing resolutions called a\nmipmap. This is used for the antialiasing of texture mapped primitives.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluBuild2DMipmapLevels.xml)","ref":"glu.html#build2DMipmapLevels/10"},{"type":"function","title":"glu.build2DMipmaps/7","doc":"[`glu:build2DMipmaps/7`](`build2DMipmaps/7`) builds a series of prefiltered\ntwo-dimensional texture maps of decreasing resolutions called a mipmap. This is\nused for the antialiasing of texture-mapped primitives.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluBuild2DMipmaps.xml)","ref":"glu.html#build2DMipmaps/7"},{"type":"function","title":"glu.build3DMipmapLevels/11","doc":"[`glu:build3DMipmapLevels/11`](`build3DMipmapLevels/11`) builds a subset of\nprefiltered three-dimensional texture maps of decreasing resolutions called a\nmipmap. This is used for the antialiasing of texture mapped primitives.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluBuild3DMipmapLevels.xml)","ref":"glu.html#build3DMipmapLevels/11"},{"type":"function","title":"glu.build3DMipmaps/8","doc":"[`glu:build3DMipmaps/8`](`build3DMipmaps/8`) builds a series of prefiltered\nthree-dimensional texture maps of decreasing resolutions called a mipmap. This\nis used for the antialiasing of texture-mapped primitives.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluBuild3DMipmaps.xml)","ref":"glu.html#build3DMipmaps/8"},{"type":"function","title":"glu.checkExtension/2","doc":"[`glu:checkExtension/2`](`checkExtension/2`) returns `?GLU_TRUE` if `ExtName` is\nsupported otherwise `?GLU_FALSE` is returned.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluCheckExtension.xml)","ref":"glu.html#checkExtension/2"},{"type":"function","title":"glu.cylinder/6","doc":"[`glu:cylinder/6`](`cylinder/6`) draws a cylinder oriented along the `z` axis.\nThe base of the cylinder is placed at `z` = 0 and the top at z=height. Like a\nsphere, a cylinder is subdivided around the `z` axis into slices and along the\n`z` axis into stacks.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluCylinder.xml)","ref":"glu.html#cylinder/6"},{"type":"function","title":"glu.deleteQuadric/1","doc":"[`glu:deleteQuadric/1`](`deleteQuadric/1`) destroys the quadrics object (created\nwith [`glu:newQuadric/0`](`newQuadric/0`)) and frees any memory it uses. Once\n[`glu:deleteQuadric/1`](`deleteQuadric/1`) has been called, `Quad` cannot be\nused again.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluDeleteQuadric.xml)","ref":"glu.html#deleteQuadric/1"},{"type":"function","title":"glu.disk/5","doc":"[`glu:disk/5`](`disk/5`) renders a disk on the `z` = 0 plane. The disk has a\nradius of `Outer` and contains a concentric circular hole with a radius of\n`Inner`. If `Inner` is 0, then no hole is generated. The disk is subdivided\naround the `z` axis into slices (like pizza slices) and also about the `z` axis\ninto rings (as specified by `Slices` and `Loops`, respectively).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluDisk.xml)","ref":"glu.html#disk/5"},{"type":"type","title":"glu.enum/0","doc":"","ref":"glu.html#t:enum/0"},{"type":"function","title":"glu.errorString/1","doc":"[`glu:errorString/1`](`errorString/1`) produces an error string from a GL or GLU\nerror code. The string is in ISO Latin 1 format. For example,\n[`glu:errorString/1`](`errorString/1`)(`?GLU_OUT_OF_MEMORY`) returns the string\n`out of memory`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluErrorString.xml)","ref":"glu.html#errorString/1"},{"type":"type","title":"glu.f/0","doc":"","ref":"glu.html#t:f/0"},{"type":"function","title":"glu.getString/1","doc":"[`glu:getString/1`](`getString/1`) returns a pointer to a static string\ndescribing the GLU version or the GLU extensions that are supported.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluGetString.xml)","ref":"glu.html#getString/1"},{"type":"type","title":"glu.i/0","doc":"","ref":"glu.html#t:i/0"},{"type":"function","title":"glu.lookAt/9","doc":"[`glu:lookAt/9`](`lookAt/9`) creates a viewing matrix derived from an eye point,\na reference point indicating the center of the scene, and an `UP` vector.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluLookAt.xml)","ref":"glu.html#lookAt/9"},{"type":"type","title":"glu.m12/0","doc":"","ref":"glu.html#t:m12/0"},{"type":"type","title":"glu.m16/0","doc":"","ref":"glu.html#t:m16/0"},{"type":"type","title":"glu.matrix/0","doc":"","ref":"glu.html#t:matrix/0"},{"type":"type","title":"glu.mem/0","doc":"","ref":"glu.html#t:mem/0"},{"type":"function","title":"glu.newQuadric/0","doc":"[`glu:newQuadric/0`](`newQuadric/0`) creates and returns a pointer to a new\nquadrics object. This object must be referred to when calling quadrics rendering\nand control functions. A return value of 0 means that there is not enough memory\nto allocate the object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluNewQuadric.xml)","ref":"glu.html#newQuadric/0"},{"type":"function","title":"glu.ortho2D/4","doc":"[`glu:ortho2D/4`](`ortho2D/4`) sets up a two-dimensional orthographic viewing\nregion. This is equivalent to calling `gl:ortho/6` with near=-1 and far=1.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluOrtho2D.xml)","ref":"glu.html#ortho2D/4"},{"type":"function","title":"glu.partialDisk/7","doc":"[`glu:partialDisk/7`](`partialDisk/7`) renders a partial disk on the z=0 plane.\nA partial disk is similar to a full disk, except that only the subset of the\ndisk from `Start` through `Start` \\+ `Sweep` is included (where 0 degrees is\nalong the +f2yf axis, 90 degrees along the +`x` axis, 180 degrees along the -`y`\naxis, and 270 degrees along the -`x` axis).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluPartialDisk.xml)","ref":"glu.html#partialDisk/7"},{"type":"function","title":"glu.perspective/4","doc":"[`glu:perspective/4`](`perspective/4`) specifies a viewing frustum into the\nworld coordinate system. In general, the aspect ratio in\n[`glu:perspective/4`](`perspective/4`) should match the aspect ratio of the\nassociated viewport. For example, aspect=2.0 means the viewer's angle of view is\ntwice as wide in `x` as it is in `y`. If the viewport is twice as wide as it is\ntall, it displays the image without distortion.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluPerspective.xml)","ref":"glu.html#perspective/4"},{"type":"function","title":"glu.pickMatrix/5","doc":"[`glu:pickMatrix/5`](`pickMatrix/5`) creates a projection matrix that can be\nused to restrict drawing to a small region of the viewport. This is typically\nuseful to determine what objects are being drawn near the cursor. Use\n[`glu:pickMatrix/5`](`pickMatrix/5`) to restrict drawing to a small region\naround the cursor. Then, enter selection mode (with `gl:renderMode/1`) and\nrerender the scene. All primitives that would have been drawn near the cursor\nare identified and stored in the selection buffer.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluPickMatrix.xml)","ref":"glu.html#pickMatrix/5"},{"type":"function","title":"glu.project/6","doc":"[`glu:project/6`](`project/6`) transforms the specified object coordinates into\nwindow coordinates using `Model`, `Proj`, and `View`. The result is stored in\n`WinX`, `WinY`, and `WinZ`. A return value of `?GLU_TRUE` indicates success, a\nreturn value of `?GLU_FALSE` indicates failure.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluProject.xml)","ref":"glu.html#project/6"},{"type":"function","title":"glu.quadricDrawStyle/2","doc":"[`glu:quadricDrawStyle/2`](`quadricDrawStyle/2`) specifies the draw style for\nquadrics rendered with `Quad`. The legal values are as follows:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluQuadricDrawStyle.xml)","ref":"glu.html#quadricDrawStyle/2"},{"type":"function","title":"glu.quadricNormals/2","doc":"[`glu:quadricNormals/2`](`quadricNormals/2`) specifies what kind of normals are\ndesired for quadrics rendered with `Quad`. The legal values are as follows:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluQuadricNormals.xml)","ref":"glu.html#quadricNormals/2"},{"type":"function","title":"glu.quadricOrientation/2","doc":"[`glu:quadricOrientation/2`](`quadricOrientation/2`) specifies what kind of\norientation is desired for quadrics rendered with `Quad`. The `Orientation`\nvalues are as follows:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluQuadricOrientation.xml)","ref":"glu.html#quadricOrientation/2"},{"type":"function","title":"glu.quadricTexture/2","doc":"[`glu:quadricTexture/2`](`quadricTexture/2`) specifies if texture coordinates\nshould be generated for quadrics rendered with `Quad`. If the value of `Texture`\nis `?GLU_TRUE`, then texture coordinates are generated, and if `Texture` is\n`?GLU_FALSE`, they are not. The initial value is `?GLU_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluQuadricTexture.xml)","ref":"glu.html#quadricTexture/2"},{"type":"function","title":"glu.scaleImage/9","doc":"[`glu:scaleImage/9`](`scaleImage/9`) scales a pixel image using the appropriate\npixel store modes to unpack data from the source image and pack data into the\ndestination image.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluScaleImage.xml)","ref":"glu.html#scaleImage/9"},{"type":"function","title":"glu.sphere/4","doc":"[`glu:sphere/4`](`sphere/4`) draws a sphere of the given radius centered around\nthe origin. The sphere is subdivided around the `z` axis into slices and along\nthe `z` axis into stacks (similar to lines of longitude and latitude).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluSphere.xml)","ref":"glu.html#sphere/4"},{"type":"function","title":"glu.tesselate/2","doc":"Triangulates a polygon, the polygon is specified by a `Normal` and `Vs` a list\nof vertex positions.\n\nThe function returns a list of indices of the vertices and a binary (64bit\nnative float) containing an array of vertex positions, it starts with the\nvertices in `Vs` and may contain newly created vertices in the end.","ref":"glu.html#tesselate/2"},{"type":"function","title":"glu.unProject4/9","doc":"[`glu:unProject/6`](`unProject/6`) maps the specified window coordinates into\nobject coordinates using `Model`, `Proj`, and `View`. The result is stored in\n`ObjX`, `ObjY`, and `ObjZ`. A return value of `?GLU_TRUE` indicates success; a\nreturn value of `?GLU_FALSE` indicates failure.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluUnProject.xml)","ref":"glu.html#unProject4/9"},{"type":"function","title":"glu.unProject/6","doc":"Equivalent to  unProject4/9 .","ref":"glu.html#unProject/6"},{"type":"type","title":"glu.vertex/0","doc":"","ref":"glu.html#t:vertex/0"},{"type":"module","title":"wx","doc":"A port of [wxWidgets](http://www.wxwidgets.org/).\n\nThis is the base api of [wxWidgets](http://www.wxwidgets.org/). This module\ncontains functions for starting and stopping the wx-server, as well as other\nutility functions.\n\nwxWidgets is object oriented, and not functional. Thus, in Wx a module\nrepresents a class, and the object created by this class has an own type,\nwxCLASS(). This module represents the base class, and all other wxMODULE's are\nsub-classes of this class.\n\nObjects of a class are created with wxCLASS:new(...) and destroyed with\nwxCLASS:destroy(). Member functions are called with wxCLASS:member(Object, ...)\ninstead of as in C++ Object.member(...).\n\nSub class modules inherit (non static) functions from their parents. The\ninherited functions are not documented in the sub-classes.\n\nThis erlang port of wxWidgets tries to be a one-to-one mapping with the original\nwxWidgets library. Some things are different though, as the optional arguments\nuse property lists and can be in any order. The main difference is the event\nhandling which is different from the original library. See `m:wxEvtHandler`.\n\nThe following classes are implemented directly as erlang types:  \nwxPoint=\\{x,y\\},wxSize=\\{w,h\\},wxRect=\\{x,y,w,h\\},wxColour=\\{r,g,b \\[,a]\\},\nwxString=[unicode:chardata()](`t:unicode:chardata/0`),\nwxGBPosition=\\{r,c\\},wxGBSpan=\\{rs,cs\\},wxGridCellCoords=\\{r,c\\}.\n\nwxWidgets uses a process specific environment, which is created by\n[wx:new/0](`new/0`). To be able to use the environment from other processes,\ncall `get_env/0` to retrieve the environment and `set_env/1` to assign the\nenvironment in the other process.\n\nGlobal (classless) functions are located in the wx_misc module.","ref":"wx.html"},{"type":"module","title":"DATA TYPES - wx","doc":"- **[](){: #type-wx_colour } wx_colour() = \\{R::byte(), G::byte(), B::byte()\\} |\n  [wx_colour4()](`m:wx#type-wx_colour4`)**\n\n- **[](){: #type-wx_colour4 } wx_colour4() = \\{R::byte(), G::byte(), B::byte(),\n  A::byte()\\}**\n\n- **[](){: #type-wx_datetime } wx_datetime() = \\{\\{Year::integer(),\n  Month::integer(), Day::integer()\\}, \\{Hour::integer(), Minute::integer(),\n  Second::integer()\\}\\}**\n\n  In Local Timezone\n\n- **[](){: #type-wx_enum } wx_enum() = integer()**\n\n  Constant defined in wx.hrl\n\n- **[](){: #type-wx_env } wx_env() = #wx_env\\{\\}**\n\n  Opaque process environment\n\n- **[](){: #type-wx_memory } wx_memory() = binary() | #wx_mem\\{\\}**\n\n  Opaque memory reference\n\n- **[](){: #type-wx_object } wx_object() = #wx_ref\\{\\}**\n\n  Opaque object reference\n\n- **[](){: #type-wx_wxHtmlLinkInfo } wx_wxHtmlLinkInfo() =\n  #wxHtmlLinkInfo\\{href=[unicode:chardata()](`t:unicode:chardata/0`),\n  target=[unicode:chardata()](`t:unicode:chardata/0`)\\}**\n\n- **[](){: #type-wx_wxMouseState } wx_wxMouseState() =\n  #wxMouseState\\{x=integer(), y=integer(), leftDown=boolean(),\n  middleDown=boolean(), rightDown=boolean(), controlDown=boolean(),\n  shiftDown=boolean(), altDown=boolean(), metaDown=boolean(),\n  cmdDown=boolean()\\}**\n\n  See #wxMouseState\\{\\} defined in wx.hrl","ref":"wx.html#module-data-types"},{"type":"function","title":"wx.batch/1","doc":"Batches all `wx` commands used in the fun. Improves performance of the command\nprocessing by grabbing the wxWidgets thread so that no event processing will be\ndone before the complete batch of commands is invoked.\n\n_See also:_ `foldl/3`, `foldr/3`, `foreach/2`, `map/2`.","ref":"wx.html#batch/1"},{"type":"function","title":"wx.create_memory/1","doc":"Creates a memory area (of Size in bytes) which can be used by an external\nlibrary (i.e. opengl). It is up to the client to keep a reference to this object\nso it does not get garbage collected by erlang while still in use by the\nexternal library.\n\nThis is far from erlang's intentional usage and can crash the erlang emulator.\nUse it carefully.","ref":"wx.html#create_memory/1"},{"type":"function","title":"wx.debug/1","doc":"Sets debug level. If debug level is 'verbose' or 'trace' each call is printed on\nconsole. If Level is 'driver' each allocated object and deletion is printed on\nthe console.","ref":"wx.html#debug/1"},{"type":"function","title":"wx.demo/0","doc":"Starts a Wx demo if examples directory exists and is compiled","ref":"wx.html#demo/0"},{"type":"function","title":"wx.destroy/0","doc":"Stops a wx server.","ref":"wx.html#destroy/0"},{"type":"function","title":"wx.equal/2","doc":"Returns true if both arguments references the same object, false otherwise","ref":"wx.html#equal/2"},{"type":"function","title":"wx.foldl/3","doc":"Behaves like `lists:foldl/3` but batches wx commands. See `batch/1`.","ref":"wx.html#foldl/3"},{"type":"function","title":"wx.foldr/3","doc":"Behaves like `lists:foldr/3` but batches wx commands. See `batch/1`.","ref":"wx.html#foldr/3"},{"type":"function","title":"wx.foreach/2","doc":"Behaves like `lists:foreach/2` but batches wx commands. See `batch/1`.","ref":"wx.html#foreach/2"},{"type":"function","title":"wx.get_env/0","doc":"Gets this process's current wx environment. Can be sent to other processes to\nallow them use this process wx environment.\n\n_See also:_ `set_env/1`.","ref":"wx.html#get_env/0"},{"type":"function","title":"wx.get_memory_bin/1","doc":"Returns the memory area as a binary.","ref":"wx.html#get_memory_bin/1"},{"type":"function","title":"wx.getObjectType/1","doc":"Returns the object type","ref":"wx.html#getObjectType/1"},{"type":"function","title":"wx.is_null/1","doc":"Returns true if object is null, false otherwise","ref":"wx.html#is_null/1"},{"type":"function","title":"wx.map/2","doc":"Behaves like `lists:map/2` but batches wx commands. See `batch/1`.","ref":"wx.html#map/2"},{"type":"function","title":"wx.new/0","doc":"Starts a wx server.","ref":"wx.html#new/0"},{"type":"function","title":"wx.new/1","doc":"Starts a wx server.\n\nOption may be `{debug, Level}`, see `debug/1`. Or `{silent_start, Bool}`,\nwhich causes error messages at startup to be suppressed.\nThe latter can be used as a silent test of whether wx is properly installed or\nnot.","ref":"wx.html#new/1"},{"type":"function","title":"wx.null/0","doc":"Returns the null object","ref":"wx.html#null/0"},{"type":"function","title":"wx.parent_class/1","doc":"","ref":"wx.html#parent_class/1"},{"type":"function","title":"wx.release_memory/1","doc":"Releases the memory retained by `retain_memory/1`","ref":"wx.html#release_memory/1"},{"type":"function","title":"wx.retain_memory/1","doc":"Saves the memory from deletion until `release_memory/1` is called. If\n`release_memory/1` is not called the memory will not be garbage collected.","ref":"wx.html#retain_memory/1"},{"type":"function","title":"wx.set_env/1","doc":"Sets the process wx environment, allows this process to use another process wx\nenvironment.","ref":"wx.html#set_env/1"},{"type":"function","title":"wx.subscribe_events/0","doc":"Adds the calling process to the list of of processes that are listening to wx\napplication events.\n\nAt the moment these are all MacOSX specific events corresponding to\n`MacNewFile()` and friends from wxWidgets\n[wxApp](https://docs.wxwidgets.org/trunk/classwx_app.html):\n\n- `{new_file, \"\"}`\n- `{open_file, Filename}`\n- `{print_file, Filename}`\n- `{open_url, Url}`\n- `{reopen_app, \"\"}`\n\nThe call always returns ok but will have sent any already received events to the\ncalling process.","ref":"wx.html#subscribe_events/0"},{"type":"function","title":"wx.typeCast/2","doc":"Casts the object to class NewType. It is needed when using functions like\nwxWindow:findWindow/2, which returns a generic wxObject type.","ref":"wx.html#typeCast/2"},{"type":"type","title":"wx.wx_colour4/0","doc":"","ref":"wx.html#t:wx_colour4/0"},{"type":"type","title":"wx.wx_colour/0","doc":"","ref":"wx.html#t:wx_colour/0"},{"type":"type","title":"wx.wx_datetime/0","doc":"","ref":"wx.html#t:wx_datetime/0"},{"type":"type","title":"wx.wx_enum/0","doc":"","ref":"wx.html#t:wx_enum/0"},{"type":"type","title":"wx.wx_env/0","doc":"","ref":"wx.html#t:wx_env/0"},{"type":"type","title":"wx.wx_memory/0","doc":"","ref":"wx.html#t:wx_memory/0"},{"type":"type","title":"wx.wx_object/0","doc":"","ref":"wx.html#t:wx_object/0"},{"type":"type","title":"wx.wx_wxHtmlLinkInfo/0","doc":"","ref":"wx.html#t:wx_wxHtmlLinkInfo/0"},{"type":"type","title":"wx.wx_wxMouseState/0","doc":"","ref":"wx.html#t:wx_wxMouseState/0"},{"type":"module","title":"wxAcceleratorEntry","doc":"An object used by an application wishing to create an accelerator table (see `m:wxAcceleratorTable`).\n\nSee:\n* `m:wxAcceleratorTable`\n\n* `wxWindow:setAcceleratorTable/2`\n\nwxWidgets docs: [wxAcceleratorEntry](https://docs.wxwidgets.org/3.2/classwx_accelerator_entry.html)","ref":"wxAcceleratorEntry.html"},{"type":"function","title":"wxAcceleratorEntry.destroy/1","doc":"Destroys the object","ref":"wxAcceleratorEntry.html#destroy/1"},{"type":"function","title":"wxAcceleratorEntry.getCommand/1","doc":"Returns the command identifier for the accelerator table entry.","ref":"wxAcceleratorEntry.html#getCommand/1"},{"type":"function","title":"wxAcceleratorEntry.getFlags/1","doc":"Returns the flags for the accelerator table entry.","ref":"wxAcceleratorEntry.html#getFlags/1"},{"type":"function","title":"wxAcceleratorEntry.getKeyCode/1","doc":"Returns the keycode for the accelerator table entry.","ref":"wxAcceleratorEntry.html#getKeyCode/1"},{"type":"function","title":"wxAcceleratorEntry.new/0","doc":"Equivalent to  new([]) .","ref":"wxAcceleratorEntry.html#new/0"},{"type":"function","title":"wxAcceleratorEntry.new/1","doc":"Copy ctor.","ref":"wxAcceleratorEntry.html#new/1"},{"type":"function","title":"wxAcceleratorEntry.set/4","doc":"Equivalent to  set(This, Flags, KeyCode, Cmd, []) .","ref":"wxAcceleratorEntry.html#set/4"},{"type":"function","title":"wxAcceleratorEntry.set/5","doc":"Sets the accelerator entry parameters.","ref":"wxAcceleratorEntry.html#set/5"},{"type":"type","title":"wxAcceleratorEntry.wxAcceleratorEntry/0","doc":"","ref":"wxAcceleratorEntry.html#t:wxAcceleratorEntry/0"},{"type":"module","title":"wxAcceleratorTable","doc":"An accelerator table allows the application to specify a table of keyboard shortcuts for\nmenu or button commands.\n\nThe object ?wxNullAcceleratorTable is defined to be a table with no data, and is the\ninitial accelerator table for a window.\n\nExample:\n\nRemark: An accelerator takes precedence over normal processing and can be a convenient\nway to program some event handling. For example, you can use an accelerator table to\nenable a dialog with a multi-line text control to accept CTRL-Enter as meaning 'OK'.\n\nPredefined objects (include wx.hrl): ?wxNullAcceleratorTable\n\nSee:\n* `m:wxAcceleratorEntry`\n\n* `wxWindow:setAcceleratorTable/2`\n\nwxWidgets docs: [wxAcceleratorTable](https://docs.wxwidgets.org/3.2/classwx_accelerator_table.html)","ref":"wxAcceleratorTable.html"},{"type":"function","title":"wxAcceleratorTable.destroy/1","doc":"Destroys the object","ref":"wxAcceleratorTable.html#destroy/1"},{"type":"function","title":"wxAcceleratorTable.isOk/1","doc":"Returns true if the accelerator table is valid.","ref":"wxAcceleratorTable.html#isOk/1"},{"type":"function","title":"wxAcceleratorTable.new/0","doc":"Default ctor.","ref":"wxAcceleratorTable.html#new/0"},{"type":"function","title":"wxAcceleratorTable.new/2","doc":"Initializes the accelerator table from an array of `m:wxAcceleratorEntry`.","ref":"wxAcceleratorTable.html#new/2"},{"type":"function","title":"wxAcceleratorTable.ok/1","doc":"Equivalent to: `isOk/1`","ref":"wxAcceleratorTable.html#ok/1"},{"type":"type","title":"wxAcceleratorTable.wxAcceleratorTable/0","doc":"","ref":"wxAcceleratorTable.html#t:wxAcceleratorTable/0"},{"type":"module","title":"wxActivateEvent","doc":"An activate event is sent when a window or application is being activated or deactivated.\n\nSee: [Overview events](https://docs.wxwidgets.org/3.2/overview_events.html#overview_events)\n\nThis class is derived, and can use functions, from:\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxActivateEvent](https://docs.wxwidgets.org/3.2/classwx_activate_event.html)","ref":"wxActivateEvent.html"},{"type":"module","title":"Events - wxActivateEvent","doc":"Use `wxEvtHandler:connect/3` with `wxActivateEventType` to subscribe to events of this type.","ref":"wxActivateEvent.html#module-events"},{"type":"function","title":"wxActivateEvent.getActive/1","doc":"Returns true if the application or window is being activated, false otherwise.","ref":"wxActivateEvent.html#getActive/1"},{"type":"type","title":"wxActivateEvent.wxActivate/0","doc":"","ref":"wxActivateEvent.html#t:wxActivate/0"},{"type":"type","title":"wxActivateEvent.wxActivateEvent/0","doc":"","ref":"wxActivateEvent.html#t:wxActivateEvent/0"},{"type":"type","title":"wxActivateEvent.wxActivateEventType/0","doc":"","ref":"wxActivateEvent.html#t:wxActivateEventType/0"},{"type":"module","title":"wxArtProvider","doc":"`m:wxArtProvider` class is used to customize the look of wxWidgets application.\n\nWhen wxWidgets needs to display an icon or a bitmap (e.g. in the standard file dialog),\nit does not use a hard-coded resource but asks `m:wxArtProvider` for it instead. This way\nusers can plug in their own `m:wxArtProvider` class and easily replace standard art with\ntheir own version.\n\nAll that is needed is to derive a class from `m:wxArtProvider`, override either its `wxArtProvider::CreateBitmap()`\n(not implemented in wx) and/or its `wxArtProvider::CreateIconBundle()` (not implemented\nin wx) methods and register the provider with `wxArtProvider::Push()` (not implemented in wx):\n\nIf you need bitmap images (of the same artwork) that should be displayed at different\nsizes you should probably consider overriding `wxArtProvider::CreateIconBundle` (not\nimplemented in wx) and supplying icon bundles that contain different bitmap sizes.\n\nThere's another way of taking advantage of this class: you can use it in your code and\nuse platform native icons as provided by `getBitmap/2` or `getIcon/2`.\n\nIdentifying art resources\n\nEvery bitmap and icon bundle are known to `m:wxArtProvider` under an unique ID that is\nused when requesting a resource from it. The ID is represented by the ?wxArtID type and\ncan have one of these predefined values (you can see bitmaps represented by these\nconstants in the page_samples_artprov):\n\nAdditionally, any string recognized by custom art providers registered using `wxArtProvider::Push`\n(not implemented in wx) may be used.\n\nNote: When running under GTK+ 2, GTK+ stock item IDs (e.g. `\"gtk-cdrom\"`) may be used as\nwell: For a list of the GTK+ stock items please refer to the [GTK+ documentation page](http://library.gnome.org/devel/gtk/stable/gtk-Stock-Items.html).\nIt is also possible to load icons from the current icon theme by specifying their name\n(without extension and directory components). Icon themes recognized by GTK+ follow the\nfreedesktop.org [Icon Themes specification](http://freedesktop.org/Standards/icon-theme-spec).\nNote that themes are not guaranteed to contain all icons, so `m:wxArtProvider` may return\n?wxNullBitmap or ?wxNullIcon. The default theme is typically installed in `/usr/share/icons/hicolor`.\n\nClients\n\nThe `client` is the entity that calls `m:wxArtProvider`'s `getBitmap/2` or `getIcon/2` function. It is\nrepresented by wxClientID type and can have one of these values:\n\n* `wxART_TOOLBAR`\n\n* `wxART_MENU`\n\n* `wxART_BUTTON`\n\n* `wxART_FRAME_ICON`\n\n* `wxART_CMN_DIALOG`\n\n* `wxART_HELP_BROWSER`\n\n* `wxART_MESSAGE_BOX`\n\n* `wxART_OTHER` (used for all requests that don't fit into any of the categories above)\n\nClient ID serve as a hint to `m:wxArtProvider` that is supposed to help it to choose the\nbest looking bitmap. For example it is often desirable to use slightly different icons in\nmenus and toolbars even though they represent the same action (e.g. wxART_FILE_OPEN).\nRemember that this is really only a hint for `m:wxArtProvider` - it is common that `getBitmap/2`\nreturns identical bitmap for different client values!\n\nSee:\n* [Examples](https://docs.wxwidgets.org/3.2/page_samples.html#page_samples_artprov)\n\n* `m:wxArtProvider`\n\nwxWidgets docs: [wxArtProvider](https://docs.wxwidgets.org/3.2/classwx_art_provider.html)","ref":"wxArtProvider.html"},{"type":"function","title":"wxArtProvider.getBitmap/1","doc":"Equivalent to  getBitmap(Id, []) .","ref":"wxArtProvider.html#getBitmap/1"},{"type":"function","title":"wxArtProvider.getBitmap/2","doc":"Query registered providers for bitmap with given ID.\n\nReturn: The bitmap if one of registered providers recognizes the ID or wxNullBitmap\notherwise.","ref":"wxArtProvider.html#getBitmap/2"},{"type":"function","title":"wxArtProvider.getIcon/1","doc":"Equivalent to  getIcon(Id, []) .","ref":"wxArtProvider.html#getIcon/1"},{"type":"function","title":"wxArtProvider.getIcon/2","doc":"Same as `getBitmap/2`, but return a `m:wxIcon` object (or ?wxNullIcon on failure).","ref":"wxArtProvider.html#getIcon/2"},{"type":"type","title":"wxArtProvider.wxArtProvider/0","doc":"","ref":"wxArtProvider.html#t:wxArtProvider/0"},{"type":"module","title":"wxAuiDockArt","doc":"`m:wxAuiDockArt` is part of the wxAUI class framework.\n\nSee also overview_aui.\n\n`m:wxAuiDockArt` is the art provider: provides all drawing functionality to the wxAui\ndock manager. This allows the dock manager to have a pluggable look-and-feel.\n\nBy default, a `m:wxAuiManager` uses an instance of this class called `wxAuiDefaultDockArt`\n(not implemented in wx) which provides bitmap art and a colour scheme that is adapted to\nthe major platforms' look. You can either derive from that class to alter its behaviour or\nwrite a completely new dock art class. Call `wxAuiManager:setArtProvider/2` to force wxAUI to use your new dock art provider.\n\nSee:\n* `m:wxAuiManager`\n\n* `m:wxAuiPaneInfo`\n\nwxWidgets docs: [wxAuiDockArt](https://docs.wxwidgets.org/3.2/classwx_aui_dock_art.html)","ref":"wxAuiDockArt.html"},{"type":"function","title":"wxAuiDockArt.getColour/2","doc":"Get the colour of a certain setting.\n\n`id` can be one of the colour values of `wxAuiPaneDockArtSetting`.","ref":"wxAuiDockArt.html#getColour/2"},{"type":"function","title":"wxAuiDockArt.getFont/2","doc":"Get a font setting.","ref":"wxAuiDockArt.html#getFont/2"},{"type":"function","title":"wxAuiDockArt.getMetric/2","doc":"Get the value of a certain setting.\n\n`id` can be one of the size values of `wxAuiPaneDockArtSetting`.","ref":"wxAuiDockArt.html#getMetric/2"},{"type":"function","title":"wxAuiDockArt.setColour/3","doc":"Set a certain setting with the value `colour`.\n\n`id` can be one of the colour values of `wxAuiPaneDockArtSetting`.","ref":"wxAuiDockArt.html#setColour/3"},{"type":"function","title":"wxAuiDockArt.setFont/3","doc":"Set a font setting.","ref":"wxAuiDockArt.html#setFont/3"},{"type":"function","title":"wxAuiDockArt.setMetric/3","doc":"Set a certain setting with the value `new\\_val`.\n\n`id` can be one of the size values of `wxAuiPaneDockArtSetting`.","ref":"wxAuiDockArt.html#setMetric/3"},{"type":"type","title":"wxAuiDockArt.wxAuiDockArt/0","doc":"","ref":"wxAuiDockArt.html#t:wxAuiDockArt/0"},{"type":"module","title":"wxAuiManager","doc":"`m:wxAuiManager` is the central class of the wxAUI class framework.\n\n`m:wxAuiManager` manages the panes associated with it for a particular `m:wxFrame`, using\na pane's `m:wxAuiPaneInfo` information to determine each pane's docking and floating behaviour.\n\n`m:wxAuiManager` uses wxWidgets' sizer mechanism to plan the layout of each frame. It\nuses a replaceable dock art class to do all drawing, so all drawing is localized in one\narea, and may be customized depending on an application's specific needs.\n\n`m:wxAuiManager` works as follows: the programmer adds panes to the class, or makes\nchanges to existing pane properties (dock position, floating state, show state, etc.). To\napply these changes, `m:wxAuiManager`'s `update/1` function is called. This batch processing can be\nused to avoid flicker, by modifying more than one pane at a time, and then \"committing\"\nall of the changes at once by calling `update/1`.\n\nPanes can be added quite easily:\n\nLater on, the positions can be modified easily. The following will float an existing pane\nin a tool window:\n\nLayers, Rows and Directions, Positions\n\nInside wxAUI, the docking layout is figured out by checking several pane parameters. Four\nof these are important for determining where a pane will end up:\n\n* Direction: Each docked pane has a direction, Top, Bottom, Left, Right, or Center. This is\nfairly self-explanatory. The pane will be placed in the location specified by this\nvariable.\n\n* Position: More than one pane can be placed inside of a dock. Imagine two panes being\ndocked on the left side of a window. One pane can be placed over another. In\nproportionally managed docks, the pane position indicates its sequential position,\nstarting with zero. So, in our scenario with two panes docked on the left side, the top\npane in the dock would have position 0, and the second one would occupy position 1.\n\n* Row: A row can allow for two docks to be placed next to each other. One of the most\ncommon places for this to happen is in the toolbar. Multiple toolbar rows are allowed, the\nfirst row being row 0, and the second row 1. Rows can also be used on vertically docked\npanes.\n\n* Layer: A layer is akin to an onion. Layer 0 is the very center of the managed pane. Thus,\nif a pane is in layer 0, it will be closest to the center window (also sometimes known as\nthe \"content window\"). Increasing layers \"swallow up\" all layers of a lower value. This\ncan look very similar to multiple rows, but is different because all panes in a lower\nlevel yield to panes in higher levels. The best way to understand layers is by running the\nwxAUI sample.","ref":"wxAuiManager.html"},{"type":"module","title":"Styles - wxAuiManager","doc":"This class supports the following styles:\n\n* wxAUI_MGR_ALLOW_FLOATING: Allow a pane to be undocked to take the form of a `m:wxMiniFrame`.\n\n* wxAUI_MGR_ALLOW_ACTIVE_PANE: Change the color of the title bar of the pane when it is\nactivated.\n\n* wxAUI_MGR_TRANSPARENT_DRAG: Make the pane transparent during its movement.\n\n* wxAUI_MGR_TRANSPARENT_HINT: The possible location for docking is indicated by a\ntranslucent area.\n\n* wxAUI_MGR_VENETIAN_BLINDS_HINT: The possible location for docking is indicated by\ngradually appearing partially transparent hint.\n\n* wxAUI_MGR_RECTANGLE_HINT: The possible location for docking is indicated by a rectangular\noutline.\n\n* wxAUI_MGR_HINT_FADE: The translucent area where the pane could be docked appears\ngradually.\n\n* wxAUI_MGR_NO_VENETIAN_BLINDS_FADE: Used in complement of wxAUI_MGR_VENETIAN_BLINDS_HINT\nto show the docking hint immediately.\n\n* wxAUI_MGR_LIVE_RESIZE: When a docked pane is resized, its content is refreshed in live\n(instead of moving the border alone and refreshing the content at the end).\n\n* wxAUI_MGR_DEFAULT: Default behaviour, combines: wxAUI_MGR_ALLOW_FLOATING |\nwxAUI_MGR_TRANSPARENT_HINT | wxAUI_MGR_HINT_FADE | wxAUI_MGR_NO_VENETIAN_BLINDS_FADE.\n\nSee:\n* [Overview aui](https://docs.wxwidgets.org/3.2/overview_aui.html#overview_aui)\n\n* `m:wxAuiNotebook`\n\n* `m:wxAuiDockArt`\n\n* `m:wxAuiPaneInfo`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxAuiManager](https://docs.wxwidgets.org/3.2/classwx_aui_manager.html)","ref":"wxAuiManager.html#module-styles"},{"type":"module","title":"Events - wxAuiManager","doc":"Event types emitted from this class:\n\n* [`aui_pane_button`](`m:wxAuiManagerEvent`)\n\n* [`aui_pane_close`](`m:wxAuiManagerEvent`)\n\n* [`aui_pane_maximize`](`m:wxAuiManagerEvent`)\n\n* [`aui_pane_restore`](`m:wxAuiManagerEvent`)\n\n* [`aui_pane_activated`](`m:wxAuiManagerEvent`)\n\n* [`aui_render`](`m:wxAuiManagerEvent`)","ref":"wxAuiManager.html#module-events"},{"type":"function","title":"wxAuiManager.addPane/2","doc":"Equivalent to  addPane(This, Window, []) .","ref":"wxAuiManager.html#addPane/2"},{"type":"function","title":"wxAuiManager.addPane/3","doc":"`addPane/4` tells the frame manager to start managing a child window.\n\nThere are several versions of this function. The first version allows the full spectrum\nof pane parameter possibilities. The second version is used for simpler user interfaces\nwhich do not require as much configuration. The last version allows a drop position to be\nspecified, which will determine where the pane will be added.","ref":"wxAuiManager.html#addPane/3"},{"type":"function","title":"wxAuiManager.addPane/4","doc":"","ref":"wxAuiManager.html#addPane/4"},{"type":"function","title":"wxAuiManager.destroy/1","doc":"Destroys the object","ref":"wxAuiManager.html#destroy/1"},{"type":"function","title":"wxAuiManager.detachPane/2","doc":"Tells the `m:wxAuiManager` to stop managing the pane specified by window.\n\nThe window, if in a floated frame, is reparented to the frame managed by `m:wxAuiManager`.","ref":"wxAuiManager.html#detachPane/2"},{"type":"function","title":"wxAuiManager.getAllPanes/1","doc":"Returns an array of all panes managed by the frame manager.","ref":"wxAuiManager.html#getAllPanes/1"},{"type":"function","title":"wxAuiManager.getArtProvider/1","doc":"Returns the current art provider being used.\n\nSee: `m:wxAuiDockArt`","ref":"wxAuiManager.html#getArtProvider/1"},{"type":"function","title":"wxAuiManager.getDockSizeConstraint/1","doc":"Returns the current dock constraint values.\n\nSee `setDockSizeConstraint/3` for more information.","ref":"wxAuiManager.html#getDockSizeConstraint/1"},{"type":"function","title":"wxAuiManager.getFlags/1","doc":"Returns the current ?wxAuiManagerOption's flags.","ref":"wxAuiManager.html#getFlags/1"},{"type":"function","title":"wxAuiManager.getManagedWindow/1","doc":"Returns the frame currently being managed by `m:wxAuiManager`.","ref":"wxAuiManager.html#getManagedWindow/1"},{"type":"function","title":"wxAuiManager.getManager/1","doc":"Calling this method will return the `m:wxAuiManager` for a given window.\n\nThe `window` parameter should specify any child window or sub-child window of the frame\nor window managed by `m:wxAuiManager`.\n\nThe `window` parameter need not be managed by the manager itself, nor does it even need\nto be a child or sub-child of a managed window. It must however be inside the window\nhierarchy underneath the managed window.","ref":"wxAuiManager.html#getManager/1"},{"type":"function","title":"wxAuiManager.getPane/2","doc":"`getPane/2` is used to lookup a `m:wxAuiPaneInfo` object either by window pointer or by\npane name, which acts as a unique id for a window pane.\n\nThe returned `m:wxAuiPaneInfo` object may then be modified to change a pane's look, state\nor position. After one or more modifications to `m:wxAuiPaneInfo`, `update/1` should be called to\ncommit the changes to the user interface. If the lookup failed (meaning the pane could not\nbe found in the manager), a call to the returned `m:wxAuiPaneInfo`'s IsOk() method will\nreturn false.","ref":"wxAuiManager.html#getPane/2"},{"type":"function","title":"wxAuiManager.hideHint/1","doc":"`hideHint/1` hides any docking hint that may be visible.","ref":"wxAuiManager.html#hideHint/1"},{"type":"function","title":"wxAuiManager.insertPane/3","doc":"Equivalent to  insertPane(This, Window, Insert_location, []) .","ref":"wxAuiManager.html#insertPane/3"},{"type":"function","title":"wxAuiManager.insertPane/4","doc":"This method is used to insert either a previously unmanaged pane window into the frame\nmanager, or to insert a currently managed pane somewhere else.\n\n`insertPane/4` will push all panes, rows, or docks aside and insert the window into the position\nspecified by `insert_location`.\n\nBecause `insert_location` can specify either a pane, dock row, or dock layer, the `insert_level`\nparameter is used to disambiguate this. The parameter `insert_level` can take a value of\nwxAUI_INSERT_PANE, wxAUI_INSERT_ROW or wxAUI_INSERT_DOCK.","ref":"wxAuiManager.html#insertPane/4"},{"type":"function","title":"wxAuiManager.loadPaneInfo/3","doc":"`loadPaneInfo/3` is similar to LoadPerspective, with the exception that it only loads\ninformation about a single pane.\n\nThis method writes the serialized data into the passed pane. Pointers to UI elements are\nnot modified.\n\nNote: This operation also changes the name in the pane information!\n\nSee: `loadPerspective/3`\n\nSee: `savePaneInfo/2`\n\nSee: `savePerspective/1`","ref":"wxAuiManager.html#loadPaneInfo/3"},{"type":"function","title":"wxAuiManager.loadPerspective/2","doc":"Equivalent to  loadPerspective(This, Perspective, []) .","ref":"wxAuiManager.html#loadPerspective/2"},{"type":"function","title":"wxAuiManager.loadPerspective/3","doc":"Loads a saved perspective.\n\nA perspective is the layout state of an AUI managed window.\n\nAll currently existing panes that have an object in \"perspective\" with the same name\n(\"equivalent\") will receive the layout parameters of the object in \"perspective\". Existing\npanes that do not have an equivalent in \"perspective\" remain unchanged, objects in\n\"perspective\" having no equivalent in the manager are ignored.\n\nSee: `loadPaneInfo/3`\n\nSee: `loadPerspective/3`\n\nSee: `savePerspective/1`","ref":"wxAuiManager.html#loadPerspective/3"},{"type":"function","title":"wxAuiManager.new/0","doc":"Equivalent to  new([]) .","ref":"wxAuiManager.html#new/0"},{"type":"function","title":"wxAuiManager.new/1","doc":"Constructor.","ref":"wxAuiManager.html#new/1"},{"type":"function","title":"wxAuiManager.savePaneInfo/2","doc":"`savePaneInfo/2` is similar to SavePerspective, with the exception that it only saves\ninformation about a single pane.\n\nReturn: The serialized layout parameters of the pane are returned within the string.\nInformation about the pointers to UI elements stored in the pane are not serialized.\n\nSee: `loadPaneInfo/3`\n\nSee: `loadPerspective/3`\n\nSee: `savePerspective/1`","ref":"wxAuiManager.html#savePaneInfo/2"},{"type":"function","title":"wxAuiManager.savePerspective/1","doc":"Saves the entire user interface layout into an encoded `wxString` (not implemented in\nwx), which can then be stored by the application (probably using wxConfig).\n\nSee: `loadPerspective/3`\n\nSee: `loadPaneInfo/3`\n\nSee: `savePaneInfo/2`","ref":"wxAuiManager.html#savePerspective/1"},{"type":"function","title":"wxAuiManager.setArtProvider/2","doc":"Instructs `m:wxAuiManager` to use art provider specified by parameter `art\\_provider` for\nall drawing calls.\n\nThis allows pluggable look-and-feel features. The previous art provider object, if any,\nwill be deleted by `m:wxAuiManager`.\n\nSee: `m:wxAuiDockArt`","ref":"wxAuiManager.html#setArtProvider/2"},{"type":"function","title":"wxAuiManager.setDockSizeConstraint/3","doc":"When a user creates a new dock by dragging a window into a docked position, often times\nthe large size of the window will create a dock that is unwieldy large.\n\n`m:wxAuiManager` by default limits the size of any new dock to 1/3 of the window size.\nFor horizontal docks, this would be 1/3 of the window height. For vertical docks, 1/3 of\nthe width.\n\nCalling this function will adjust this constraint value. The numbers must be between 0.0\nand 1.0. For instance, calling SetDockSizeContraint with 0.5, 0.5 will cause new docks to\nbe limited to half of the size of the entire managed window.","ref":"wxAuiManager.html#setDockSizeConstraint/3"},{"type":"function","title":"wxAuiManager.setFlags/2","doc":"This method is used to specify ?wxAuiManagerOption's flags.\n\n`flags` specifies options which allow the frame management behaviour to be modified.","ref":"wxAuiManager.html#setFlags/2"},{"type":"function","title":"wxAuiManager.setManagedWindow/2","doc":"Called to specify the frame or window which is to be managed by `m:wxAuiManager`.\n\nFrame management is not restricted to just frames. Child windows or custom controls are\nalso allowed.","ref":"wxAuiManager.html#setManagedWindow/2"},{"type":"function","title":"wxAuiManager.showHint/2","doc":"This function is used by controls to explicitly show a hint window at the specified\nrectangle.\n\nIt is rarely called, and is mostly used by controls implementing custom pane drag/drop\nbehaviour. The specified rectangle should be in screen coordinates.","ref":"wxAuiManager.html#showHint/2"},{"type":"function","title":"wxAuiManager.unInit/1","doc":"Dissociate the managed window from the manager.\n\nThis function may be called before the managed frame or window is destroyed, but, since\nwxWidgets 3.1.4, it's unnecessary to call it explicitly, as it will be called\nautomatically when this window is destroyed, as well as when the manager itself is.","ref":"wxAuiManager.html#unInit/1"},{"type":"function","title":"wxAuiManager.update/1","doc":"This method is called after any number of changes are made to any of the managed panes.\n\n`update/1` must be invoked after `addPane/4` or `insertPane/4` are called in order to \"realize\" or \"commit\" the changes. In\naddition, any number of changes may be made to `m:wxAuiPaneInfo` structures (retrieved\nwith `getPane/2`), but to realize the changes, `update/1` must be called. This construction allows pane flicker\nto be avoided by updating the whole layout at one time.","ref":"wxAuiManager.html#update/1"},{"type":"type","title":"wxAuiManager.wxAuiManager/0","doc":"","ref":"wxAuiManager.html#t:wxAuiManager/0"},{"type":"module","title":"wxAuiManagerEvent","doc":"Event used to indicate various actions taken with `m:wxAuiManager`.\n\nSee `m:wxAuiManager` for available event types.\n\nSee:\n* `m:wxAuiManager`\n\n* `m:wxAuiPaneInfo`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxAuiManagerEvent](https://docs.wxwidgets.org/3.2/classwx_aui_manager_event.html)","ref":"wxAuiManagerEvent.html"},{"type":"module","title":"Events - wxAuiManagerEvent","doc":"Use `wxEvtHandler:connect/3` with `wxAuiManagerEventType` to subscribe to events of this type.","ref":"wxAuiManagerEvent.html#module-events"},{"type":"function","title":"wxAuiManagerEvent.canVeto/1","doc":"Return: true if this event can be vetoed.\n\nSee: `veto/2`","ref":"wxAuiManagerEvent.html#canVeto/1"},{"type":"function","title":"wxAuiManagerEvent.getButton/1","doc":"Return: The ID of the button that was clicked.","ref":"wxAuiManagerEvent.html#getButton/1"},{"type":"function","title":"wxAuiManagerEvent.getDC/1","doc":"","ref":"wxAuiManagerEvent.html#getDC/1"},{"type":"function","title":"wxAuiManagerEvent.getManager/1","doc":"Return: The `m:wxAuiManager` this event is associated with.","ref":"wxAuiManagerEvent.html#getManager/1"},{"type":"function","title":"wxAuiManagerEvent.getPane/1","doc":"Return: The pane this event is associated with.","ref":"wxAuiManagerEvent.html#getPane/1"},{"type":"function","title":"wxAuiManagerEvent.getVeto/1","doc":"Return: true if this event was vetoed.\n\nSee: `veto/2`","ref":"wxAuiManagerEvent.html#getVeto/1"},{"type":"function","title":"wxAuiManagerEvent.setButton/2","doc":"Sets the ID of the button clicked that triggered this event.","ref":"wxAuiManagerEvent.html#setButton/2"},{"type":"function","title":"wxAuiManagerEvent.setCanVeto/2","doc":"Sets whether or not this event can be vetoed.","ref":"wxAuiManagerEvent.html#setCanVeto/2"},{"type":"function","title":"wxAuiManagerEvent.setDC/2","doc":"","ref":"wxAuiManagerEvent.html#setDC/2"},{"type":"function","title":"wxAuiManagerEvent.setManager/2","doc":"Sets the `m:wxAuiManager` this event is associated with.","ref":"wxAuiManagerEvent.html#setManager/2"},{"type":"function","title":"wxAuiManagerEvent.setPane/2","doc":"Sets the pane this event is associated with.","ref":"wxAuiManagerEvent.html#setPane/2"},{"type":"function","title":"wxAuiManagerEvent.veto/1","doc":"Equivalent to  veto(This, []) .","ref":"wxAuiManagerEvent.html#veto/1"},{"type":"function","title":"wxAuiManagerEvent.veto/2","doc":"Cancels the action indicated by this event if `canVeto/1` is true.","ref":"wxAuiManagerEvent.html#veto/2"},{"type":"type","title":"wxAuiManagerEvent.wxAuiManager/0","doc":"","ref":"wxAuiManagerEvent.html#t:wxAuiManager/0"},{"type":"type","title":"wxAuiManagerEvent.wxAuiManagerEvent/0","doc":"","ref":"wxAuiManagerEvent.html#t:wxAuiManagerEvent/0"},{"type":"type","title":"wxAuiManagerEvent.wxAuiManagerEventType/0","doc":"","ref":"wxAuiManagerEvent.html#t:wxAuiManagerEventType/0"},{"type":"module","title":"wxAuiNotebook","doc":"`m:wxAuiNotebook` is part of the wxAUI class framework, which represents a notebook\ncontrol, managing multiple windows with associated tabs.\n\nSee also overview_aui.\n\n`m:wxAuiNotebook` is a notebook control which implements many features common in\napplications with dockable panes. Specifically, `m:wxAuiNotebook` implements functionality\nwhich allows the user to rearrange tab order via drag-and-drop, split the tab window into\nmany different splitter configurations, and toggle through different themes to customize\nthe control's look and feel.\n\nThe default theme that is used is `wxAuiDefaultTabArt` (not implemented in wx), which\nprovides a modern, glossy look and feel. The theme can be changed by calling `setArtProvider/2`.","ref":"wxAuiNotebook.html"},{"type":"module","title":"Styles - wxAuiNotebook","doc":"This class supports the following styles:\n\n* wxAUI_NB_DEFAULT_STYLE: Defined as wxAUI_NB_TOP | wxAUI_NB_TAB_SPLIT | wxAUI_NB_TAB_MOVE\n| wxAUI_NB_SCROLL_BUTTONS | wxAUI_NB_CLOSE_ON_ACTIVE_TAB | wxAUI_NB_MIDDLE_CLICK_CLOSE.\n\n* wxAUI_NB_TAB_SPLIT: Allows the tab control to be split by dragging a tab.\n\n* wxAUI_NB_TAB_MOVE: Allows a tab to be moved horizontally by dragging.\n\n* wxAUI_NB_TAB_EXTERNAL_MOVE: Allows a tab to be moved to another tab control.\n\n* wxAUI_NB_TAB_FIXED_WIDTH: With this style, all tabs have the same width.\n\n* wxAUI_NB_SCROLL_BUTTONS: With this style, left and right scroll buttons are displayed.\n\n* wxAUI_NB_WINDOWLIST_BUTTON: With this style, a drop-down list of windows is available.\n\n* wxAUI_NB_CLOSE_BUTTON: With this style, a close button is available on the tab bar.\n\n* wxAUI_NB_CLOSE_ON_ACTIVE_TAB: With this style, the close button is visible on the active\ntab.\n\n* wxAUI_NB_CLOSE_ON_ALL_TABS: With this style, the close button is visible on all tabs.\n\n* wxAUI_NB_MIDDLE_CLICK_CLOSE: With this style, middle click on a tab closes the tab.\n\n* wxAUI_NB_TOP: With this style, tabs are drawn along the top of the notebook.\n\n* wxAUI_NB_BOTTOM: With this style, tabs are drawn along the bottom of the notebook.\n\nThis class is derived, and can use functions, from:\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxAuiNotebook](https://docs.wxwidgets.org/3.2/classwx_aui_notebook.html)","ref":"wxAuiNotebook.html#module-styles"},{"type":"module","title":"Events - wxAuiNotebook","doc":"Event types emitted from this class:\n\n* [`command_auinotebook_page_close`](`m:wxAuiNotebookEvent`)\n\n* [`command_auinotebook_page_closed`](`m:wxAuiNotebookEvent`)\n\n* [`command_auinotebook_page_changed`](`m:wxAuiNotebookEvent`)\n\n* [`command_auinotebook_page_changing`](`m:wxAuiNotebookEvent`)\n\n* [`command_auinotebook_button`](`m:wxAuiNotebookEvent`)\n\n* [`command_auinotebook_begin_drag`](`m:wxAuiNotebookEvent`)\n\n* [`command_auinotebook_end_drag`](`m:wxAuiNotebookEvent`)\n\n* [`command_auinotebook_drag_motion`](`m:wxAuiNotebookEvent`)\n\n* [`command_auinotebook_allow_dnd`](`m:wxAuiNotebookEvent`)\n\n* [`command_auinotebook_drag_done`](`m:wxAuiNotebookEvent`)\n\n* [`command_auinotebook_tab_middle_down`](`m:wxAuiNotebookEvent`)\n\n* [`command_auinotebook_tab_middle_up`](`m:wxAuiNotebookEvent`)\n\n* [`command_auinotebook_tab_right_down`](`m:wxAuiNotebookEvent`)\n\n* [`command_auinotebook_tab_right_up`](`m:wxAuiNotebookEvent`)\n\n* [`command_auinotebook_bg_dclick`](`m:wxAuiNotebookEvent`)","ref":"wxAuiNotebook.html#module-events"},{"type":"function","title":"wxAuiNotebook.addPage/3","doc":"Equivalent to  addPage(This, Page, Caption, []) .","ref":"wxAuiNotebook.html#addPage/3"},{"type":"function","title":"wxAuiNotebook.addPage/4","doc":"Adds a page.\n\nIf the `select` parameter is true, calling this will generate a page change event.","ref":"wxAuiNotebook.html#addPage/4"},{"type":"function","title":"wxAuiNotebook.addPage/5","doc":"Adds a new page.\n\nThe page must have the book control itself as the parent and must not have been added to\nthis control previously.\n\nThe call to this function may generate the page changing events.\n\nReturn: true if successful, false otherwise.\n\nRemark: Do not delete the page, it will be deleted by the book control.\n\nSee: `insertPage/6`\n\nSince: 2.9.3","ref":"wxAuiNotebook.html#addPage/5"},{"type":"function","title":"wxAuiNotebook.create/2","doc":"Equivalent to  create(This, Parent, []) .","ref":"wxAuiNotebook.html#create/2"},{"type":"function","title":"wxAuiNotebook.create/3","doc":"Creates the notebook window.","ref":"wxAuiNotebook.html#create/3"},{"type":"function","title":"wxAuiNotebook.create/4","doc":"Constructs the book control with the given parameters.","ref":"wxAuiNotebook.html#create/4"},{"type":"function","title":"wxAuiNotebook.deletePage/2","doc":"Deletes a page at the given index.\n\nCalling this method will generate a page change event.","ref":"wxAuiNotebook.html#deletePage/2"},{"type":"function","title":"wxAuiNotebook.destroy/1","doc":"Destroys the object","ref":"wxAuiNotebook.html#destroy/1"},{"type":"function","title":"wxAuiNotebook.getArtProvider/1","doc":"Returns the associated art provider.","ref":"wxAuiNotebook.html#getArtProvider/1"},{"type":"function","title":"wxAuiNotebook.getPage/2","doc":"Returns the page specified by the given index.","ref":"wxAuiNotebook.html#getPage/2"},{"type":"function","title":"wxAuiNotebook.getPageBitmap/2","doc":"Returns the tab bitmap for the page.","ref":"wxAuiNotebook.html#getPageBitmap/2"},{"type":"function","title":"wxAuiNotebook.getPageCount/1","doc":"Returns the number of pages in the notebook.","ref":"wxAuiNotebook.html#getPageCount/1"},{"type":"function","title":"wxAuiNotebook.getPageIndex/2","doc":"Returns the page index for the specified window.\n\nIf the window is not found in the notebook, wxNOT_FOUND is returned.","ref":"wxAuiNotebook.html#getPageIndex/2"},{"type":"function","title":"wxAuiNotebook.getPageText/2","doc":"Returns the tab label for the page.","ref":"wxAuiNotebook.html#getPageText/2"},{"type":"function","title":"wxAuiNotebook.getSelection/1","doc":"Returns the currently selected page.","ref":"wxAuiNotebook.html#getSelection/1"},{"type":"function","title":"wxAuiNotebook.insertPage/4","doc":"Equivalent to  insertPage(This, Page_idx, Page, Caption, []) .","ref":"wxAuiNotebook.html#insertPage/4"},{"type":"function","title":"wxAuiNotebook.insertPage/5","doc":"`insertPage/6` is similar to AddPage, but allows the ability to specify the insert\nlocation.\n\nIf the `select` parameter is true, calling this will generate a page change event.","ref":"wxAuiNotebook.html#insertPage/5"},{"type":"function","title":"wxAuiNotebook.insertPage/6","doc":"Inserts a new page at the specified position.\n\nReturn: true if successful, false otherwise.\n\nRemark: Do not delete the page, it will be deleted by the book control.\n\nSee: `addPage/5`\n\nSince: 2.9.3","ref":"wxAuiNotebook.html#insertPage/6"},{"type":"function","title":"wxAuiNotebook.new/0","doc":"Default ctor.","ref":"wxAuiNotebook.html#new/0"},{"type":"function","title":"wxAuiNotebook.new/1","doc":"Equivalent to  new(Parent, []) .","ref":"wxAuiNotebook.html#new/1"},{"type":"function","title":"wxAuiNotebook.new/2","doc":"Constructor.\n\nCreates a wxAuiNotebok control.","ref":"wxAuiNotebook.html#new/2"},{"type":"function","title":"wxAuiNotebook.removePage/2","doc":"Removes a page, without deleting the window pointer.","ref":"wxAuiNotebook.html#removePage/2"},{"type":"function","title":"wxAuiNotebook.setArtProvider/2","doc":"Sets the art provider to be used by the notebook.","ref":"wxAuiNotebook.html#setArtProvider/2"},{"type":"function","title":"wxAuiNotebook.setFont/2","doc":"Sets the font for drawing the tab labels, using a bold version of the font for selected\ntab labels.","ref":"wxAuiNotebook.html#setFont/2"},{"type":"function","title":"wxAuiNotebook.setPageBitmap/3","doc":"Sets the bitmap for the page.\n\nTo remove a bitmap from the tab caption, pass wxNullBitmap.","ref":"wxAuiNotebook.html#setPageBitmap/3"},{"type":"function","title":"wxAuiNotebook.setPageText/3","doc":"Sets the tab label for the page.","ref":"wxAuiNotebook.html#setPageText/3"},{"type":"function","title":"wxAuiNotebook.setSelection/2","doc":"Sets the page selection.\n\nCalling this method will generate a page change event.","ref":"wxAuiNotebook.html#setSelection/2"},{"type":"function","title":"wxAuiNotebook.setTabCtrlHeight/2","doc":"Sets the tab height.\n\nBy default, the tab control height is calculated by measuring the text height and bitmap\nsizes on the tab captions. Calling this method will override that calculation and set the\ntab control to the specified height parameter. A call to this method will override any\ncall to `setUniformBitmapSize/2`.\n\nSpecifying -1 as the height will return the control to its default auto-sizing behaviour.","ref":"wxAuiNotebook.html#setTabCtrlHeight/2"},{"type":"function","title":"wxAuiNotebook.setUniformBitmapSize/2","doc":"Ensure that all tabs have the same height, even if some of them don't have bitmaps.\n\nPassing ?wxDefaultSize as `size` undoes the effect of a previous call to this function\nand instructs the control to use dynamic tab height.","ref":"wxAuiNotebook.html#setUniformBitmapSize/2"},{"type":"type","title":"wxAuiNotebook.wxAuiNotebook/0","doc":"","ref":"wxAuiNotebook.html#t:wxAuiNotebook/0"},{"type":"module","title":"wxAuiNotebookEvent","doc":"This class is used by the events generated by `m:wxAuiNotebook`.\n\nSee:\n* `m:wxAuiNotebook`\n\n* `m:wxBookCtrlEvent`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxBookCtrlEvent`\n\n* `m:wxNotifyEvent`\n\n* `m:wxCommandEvent`\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxAuiNotebookEvent](https://docs.wxwidgets.org/3.2/classwx_aui_notebook_event.html)","ref":"wxAuiNotebookEvent.html"},{"type":"module","title":"Events - wxAuiNotebookEvent","doc":"Use `wxEvtHandler:connect/3` with `wxAuiNotebookEventType` to subscribe to events of this type.","ref":"wxAuiNotebookEvent.html#module-events"},{"type":"function","title":"wxAuiNotebookEvent.getDragSource/1","doc":"","ref":"wxAuiNotebookEvent.html#getDragSource/1"},{"type":"function","title":"wxAuiNotebookEvent.getOldSelection/1","doc":"Returns the page that was selected before the change, `wxNOT\\_FOUND` if none was\nselected.","ref":"wxAuiNotebookEvent.html#getOldSelection/1"},{"type":"function","title":"wxAuiNotebookEvent.getSelection/1","doc":"Returns the currently selected page, or `wxNOT\\_FOUND` if none was selected.\n\nNote: under Windows, `getSelection/1` will return the same value as `getOldSelection/1` when called from the `EVT_BOOKCTRL_PAGE_CHANGING`\nhandler and not the page which is going to be selected.","ref":"wxAuiNotebookEvent.html#getSelection/1"},{"type":"function","title":"wxAuiNotebookEvent.setDragSource/2","doc":"","ref":"wxAuiNotebookEvent.html#setDragSource/2"},{"type":"function","title":"wxAuiNotebookEvent.setOldSelection/2","doc":"Sets the id of the page selected before the change.","ref":"wxAuiNotebookEvent.html#setOldSelection/2"},{"type":"function","title":"wxAuiNotebookEvent.setSelection/2","doc":"Sets the selection member variable.","ref":"wxAuiNotebookEvent.html#setSelection/2"},{"type":"type","title":"wxAuiNotebookEvent.wxAuiNotebook/0","doc":"","ref":"wxAuiNotebookEvent.html#t:wxAuiNotebook/0"},{"type":"type","title":"wxAuiNotebookEvent.wxAuiNotebookEvent/0","doc":"","ref":"wxAuiNotebookEvent.html#t:wxAuiNotebookEvent/0"},{"type":"type","title":"wxAuiNotebookEvent.wxAuiNotebookEventType/0","doc":"","ref":"wxAuiNotebookEvent.html#t:wxAuiNotebookEventType/0"},{"type":"module","title":"wxAuiPaneInfo","doc":"`m:wxAuiPaneInfo` is part of the wxAUI class framework.\n\nSee also overview_aui.\n\n`m:wxAuiPaneInfo` specifies all the parameters for a pane. These parameters specify where\nthe pane is on the screen, whether it is docked or floating, or hidden. In addition, these\nparameters specify the pane's docked position, floating position, preferred size, minimum\nsize, caption text among many other parameters.\n\nSee:\n* `m:wxAuiManager`\n\n* `m:wxAuiDockArt`\n\nwxWidgets docs: [wxAuiPaneInfo](https://docs.wxwidgets.org/3.2/classwx_aui_pane_info.html)","ref":"wxAuiPaneInfo.html"},{"type":"function","title":"wxAuiPaneInfo.bestSize/2","doc":"`bestSize/3` sets the ideal size for the pane.\n\nThe docking manager will attempt to use this size as much as possible when docking or\nfloating the pane.","ref":"wxAuiPaneInfo.html#bestSize/2"},{"type":"function","title":"wxAuiPaneInfo.bestSize/3","doc":"","ref":"wxAuiPaneInfo.html#bestSize/3"},{"type":"function","title":"wxAuiPaneInfo.bottom/1","doc":"`bottom/1` sets the pane dock position to the bottom side of the frame.\n\nThis is the same thing as calling Direction(wxAUI_DOCK_BOTTOM).","ref":"wxAuiPaneInfo.html#bottom/1"},{"type":"function","title":"wxAuiPaneInfo.bottomDockable/1","doc":"Equivalent to  bottomDockable(This, []) .","ref":"wxAuiPaneInfo.html#bottomDockable/1"},{"type":"function","title":"wxAuiPaneInfo.bottomDockable/2","doc":"`bottomDockable/2` indicates whether a pane can be docked at the bottom of the frame.","ref":"wxAuiPaneInfo.html#bottomDockable/2"},{"type":"function","title":"wxAuiPaneInfo.caption/2","doc":"`caption/2` sets the caption of the pane.","ref":"wxAuiPaneInfo.html#caption/2"},{"type":"function","title":"wxAuiPaneInfo.captionVisible/1","doc":"Equivalent to  captionVisible(This, []) .","ref":"wxAuiPaneInfo.html#captionVisible/1"},{"type":"function","title":"wxAuiPaneInfo.captionVisible/2","doc":"CaptionVisible indicates that a pane caption should be visible.\n\nIf false, no pane caption is drawn.","ref":"wxAuiPaneInfo.html#captionVisible/2"},{"type":"function","title":"wxAuiPaneInfo.centre/1","doc":"`Center()` (not implemented in wx) sets the pane dock position to the left side of the\nframe.\n\nThe centre pane is the space in the middle after all border panes (left, top, right,\nbottom) are subtracted from the layout. This is the same thing as calling\nDirection(wxAUI_DOCK_CENTRE).","ref":"wxAuiPaneInfo.html#centre/1"},{"type":"function","title":"wxAuiPaneInfo.centrePane/1","doc":"`centrePane/1` specifies that the pane should adopt the default center pane settings.\n\nCentre panes usually do not have caption bars. This function provides an easy way of\npreparing a pane to be displayed in the center dock position.","ref":"wxAuiPaneInfo.html#centrePane/1"},{"type":"function","title":"wxAuiPaneInfo.closeButton/1","doc":"Equivalent to  closeButton(This, []) .","ref":"wxAuiPaneInfo.html#closeButton/1"},{"type":"function","title":"wxAuiPaneInfo.closeButton/2","doc":"`closeButton/2` indicates that a close button should be drawn for the pane.","ref":"wxAuiPaneInfo.html#closeButton/2"},{"type":"function","title":"wxAuiPaneInfo.defaultPane/1","doc":"`defaultPane/1` specifies that the pane should adopt the default pane settings.","ref":"wxAuiPaneInfo.html#defaultPane/1"},{"type":"function","title":"wxAuiPaneInfo.destroy/1","doc":"Destroys the object","ref":"wxAuiPaneInfo.html#destroy/1"},{"type":"function","title":"wxAuiPaneInfo.destroyOnClose/1","doc":"Equivalent to  destroyOnClose(This, []) .","ref":"wxAuiPaneInfo.html#destroyOnClose/1"},{"type":"function","title":"wxAuiPaneInfo.destroyOnClose/2","doc":"`destroyOnClose/2` indicates whether a pane should be destroyed when it is closed.\n\nNormally a pane is simply hidden when the close button is clicked. Setting DestroyOnClose\nto true will cause the window to be destroyed when the user clicks the pane's close\nbutton.","ref":"wxAuiPaneInfo.html#destroyOnClose/2"},{"type":"function","title":"wxAuiPaneInfo.direction/2","doc":"`direction/2` determines the direction of the docked pane.\n\nIt is functionally the same as calling `left/1`, `right/1`, `top/1` or `bottom/1`, except that docking direction may be\nspecified programmatically via the parameter.","ref":"wxAuiPaneInfo.html#direction/2"},{"type":"function","title":"wxAuiPaneInfo.dock/1","doc":"`dock/1` indicates that a pane should be docked.\n\nIt is the opposite of `float/1`.","ref":"wxAuiPaneInfo.html#dock/1"},{"type":"function","title":"wxAuiPaneInfo.dockable/1","doc":"Equivalent to  dockable(This, []) .","ref":"wxAuiPaneInfo.html#dockable/1"},{"type":"function","title":"wxAuiPaneInfo.dockable/2","doc":"`dockable/2` specifies whether a frame can be docked or not.\n\nIt is the same as specifying\nTopDockable(b).BottomDockable(b).LeftDockable(b).RightDockable(b).","ref":"wxAuiPaneInfo.html#dockable/2"},{"type":"function","title":"wxAuiPaneInfo.fixed/1","doc":"`fixed/1` forces a pane to be fixed size so that it cannot be resized.\n\nAfter calling `fixed/1`, `isFixed/1` will return true.","ref":"wxAuiPaneInfo.html#fixed/1"},{"type":"function","title":"wxAuiPaneInfo.float/1","doc":"`float/1` indicates that a pane should be floated.\n\nIt is the opposite of `dock/1`.","ref":"wxAuiPaneInfo.html#float/1"},{"type":"function","title":"wxAuiPaneInfo.floatable/1","doc":"Equivalent to  floatable(This, []) .","ref":"wxAuiPaneInfo.html#floatable/1"},{"type":"function","title":"wxAuiPaneInfo.floatable/2","doc":"`floatable/2` sets whether the user will be able to undock a pane and turn it into a\nfloating window.","ref":"wxAuiPaneInfo.html#floatable/2"},{"type":"function","title":"wxAuiPaneInfo.floatingPosition/2","doc":"`floatingPosition/3` sets the position of the floating pane.","ref":"wxAuiPaneInfo.html#floatingPosition/2"},{"type":"function","title":"wxAuiPaneInfo.floatingPosition/3","doc":"","ref":"wxAuiPaneInfo.html#floatingPosition/3"},{"type":"function","title":"wxAuiPaneInfo.floatingSize/2","doc":"`floatingSize/3` sets the size of the floating pane.","ref":"wxAuiPaneInfo.html#floatingSize/2"},{"type":"function","title":"wxAuiPaneInfo.floatingSize/3","doc":"","ref":"wxAuiPaneInfo.html#floatingSize/3"},{"type":"function","title":"wxAuiPaneInfo.getDirection/1","doc":"","ref":"wxAuiPaneInfo.html#getDirection/1"},{"type":"function","title":"wxAuiPaneInfo.getFloatingPosition/1","doc":"","ref":"wxAuiPaneInfo.html#getFloatingPosition/1"},{"type":"function","title":"wxAuiPaneInfo.getFloatingSize/1","doc":"","ref":"wxAuiPaneInfo.html#getFloatingSize/1"},{"type":"function","title":"wxAuiPaneInfo.getFrame/1","doc":"","ref":"wxAuiPaneInfo.html#getFrame/1"},{"type":"function","title":"wxAuiPaneInfo.getLayer/1","doc":"","ref":"wxAuiPaneInfo.html#getLayer/1"},{"type":"function","title":"wxAuiPaneInfo.getPosition/1","doc":"","ref":"wxAuiPaneInfo.html#getPosition/1"},{"type":"function","title":"wxAuiPaneInfo.getRow/1","doc":"","ref":"wxAuiPaneInfo.html#getRow/1"},{"type":"function","title":"wxAuiPaneInfo.getWindow/1","doc":"","ref":"wxAuiPaneInfo.html#getWindow/1"},{"type":"function","title":"wxAuiPaneInfo.gripper/1","doc":"Equivalent to  gripper(This, []) .","ref":"wxAuiPaneInfo.html#gripper/1"},{"type":"function","title":"wxAuiPaneInfo.gripper/2","doc":"`gripper/2` indicates that a gripper should be drawn for the pane.","ref":"wxAuiPaneInfo.html#gripper/2"},{"type":"function","title":"wxAuiPaneInfo.gripperTop/1","doc":"Equivalent to  gripperTop(This, []) .","ref":"wxAuiPaneInfo.html#gripperTop/1"},{"type":"function","title":"wxAuiPaneInfo.gripperTop/2","doc":"`gripperTop/2` indicates that a gripper should be drawn at the top of the pane.","ref":"wxAuiPaneInfo.html#gripperTop/2"},{"type":"function","title":"wxAuiPaneInfo.hasBorder/1","doc":"`hasBorder/1` returns true if the pane displays a border.","ref":"wxAuiPaneInfo.html#hasBorder/1"},{"type":"function","title":"wxAuiPaneInfo.hasCaption/1","doc":"`hasCaption/1` returns true if the pane displays a caption.","ref":"wxAuiPaneInfo.html#hasCaption/1"},{"type":"function","title":"wxAuiPaneInfo.hasCloseButton/1","doc":"`hasCloseButton/1` returns true if the pane displays a button to close the pane.","ref":"wxAuiPaneInfo.html#hasCloseButton/1"},{"type":"function","title":"wxAuiPaneInfo.hasFlag/2","doc":"`hasFlag/2` returns true if the property specified by flag is active for the pane.","ref":"wxAuiPaneInfo.html#hasFlag/2"},{"type":"function","title":"wxAuiPaneInfo.hasGripper/1","doc":"`hasGripper/1` returns true if the pane displays a gripper.","ref":"wxAuiPaneInfo.html#hasGripper/1"},{"type":"function","title":"wxAuiPaneInfo.hasGripperTop/1","doc":"`hasGripper/1` returns true if the pane displays a gripper at the top.","ref":"wxAuiPaneInfo.html#hasGripperTop/1"},{"type":"function","title":"wxAuiPaneInfo.hasMaximizeButton/1","doc":"`hasMaximizeButton/1` returns true if the pane displays a button to maximize the pane.","ref":"wxAuiPaneInfo.html#hasMaximizeButton/1"},{"type":"function","title":"wxAuiPaneInfo.hasMinimizeButton/1","doc":"`hasMinimizeButton/1` returns true if the pane displays a button to minimize the pane.","ref":"wxAuiPaneInfo.html#hasMinimizeButton/1"},{"type":"function","title":"wxAuiPaneInfo.hasPinButton/1","doc":"`hasPinButton/1` returns true if the pane displays a button to float the pane.","ref":"wxAuiPaneInfo.html#hasPinButton/1"},{"type":"function","title":"wxAuiPaneInfo.hide/1","doc":"`hide/1` indicates that a pane should be hidden.","ref":"wxAuiPaneInfo.html#hide/1"},{"type":"function","title":"wxAuiPaneInfo.isBottomDockable/1","doc":"`isBottomDockable/1` returns true if the pane can be docked at the bottom of the managed\nframe.","ref":"wxAuiPaneInfo.html#isBottomDockable/1"},{"type":"function","title":"wxAuiPaneInfo.isDocked/1","doc":"`isDocked/1` returns true if the pane is currently docked.","ref":"wxAuiPaneInfo.html#isDocked/1"},{"type":"function","title":"wxAuiPaneInfo.isFixed/1","doc":"`isFixed/1` returns true if the pane cannot be resized.","ref":"wxAuiPaneInfo.html#isFixed/1"},{"type":"function","title":"wxAuiPaneInfo.isFloatable/1","doc":"`isFloatable/1` returns true if the pane can be undocked and displayed as a floating\nwindow.","ref":"wxAuiPaneInfo.html#isFloatable/1"},{"type":"function","title":"wxAuiPaneInfo.isFloating/1","doc":"`isFloating/1` returns true if the pane is floating.","ref":"wxAuiPaneInfo.html#isFloating/1"},{"type":"function","title":"wxAuiPaneInfo.isLeftDockable/1","doc":"`isLeftDockable/1` returns true if the pane can be docked on the left of the managed\nframe.","ref":"wxAuiPaneInfo.html#isLeftDockable/1"},{"type":"function","title":"wxAuiPaneInfo.isMovable/1","doc":"IsMoveable() returns true if the docked frame can be undocked or moved to another dock\nposition.","ref":"wxAuiPaneInfo.html#isMovable/1"},{"type":"function","title":"wxAuiPaneInfo.isOk/1","doc":"`isOk/1` returns true if the `m:wxAuiPaneInfo` structure is valid.\n\nA pane structure is valid if it has an associated window.","ref":"wxAuiPaneInfo.html#isOk/1"},{"type":"function","title":"wxAuiPaneInfo.isResizable/1","doc":"`isResizable/1` returns true if the pane can be resized.","ref":"wxAuiPaneInfo.html#isResizable/1"},{"type":"function","title":"wxAuiPaneInfo.isRightDockable/1","doc":"`isRightDockable/1` returns true if the pane can be docked on the right of the managed\nframe.","ref":"wxAuiPaneInfo.html#isRightDockable/1"},{"type":"function","title":"wxAuiPaneInfo.isShown/1","doc":"`isShown/1` returns true if the pane is currently shown.","ref":"wxAuiPaneInfo.html#isShown/1"},{"type":"function","title":"wxAuiPaneInfo.isToolbar/1","doc":"`isToolbar/1` returns true if the pane contains a toolbar.","ref":"wxAuiPaneInfo.html#isToolbar/1"},{"type":"function","title":"wxAuiPaneInfo.isTopDockable/1","doc":"`isTopDockable/1` returns true if the pane can be docked at the top of the managed frame.","ref":"wxAuiPaneInfo.html#isTopDockable/1"},{"type":"function","title":"wxAuiPaneInfo.layer/2","doc":"`layer/2` determines the layer of the docked pane.\n\nThe dock layer is similar to an onion, the inner-most layer being layer 0. Each shell\nmoving in the outward direction has a higher layer number. This allows for more complex\ndocking layout formation.","ref":"wxAuiPaneInfo.html#layer/2"},{"type":"function","title":"wxAuiPaneInfo.left/1","doc":"`left/1` sets the pane dock position to the left side of the frame.\n\nThis is the same thing as calling Direction(wxAUI_DOCK_LEFT).","ref":"wxAuiPaneInfo.html#left/1"},{"type":"function","title":"wxAuiPaneInfo.leftDockable/1","doc":"Equivalent to  leftDockable(This, []) .","ref":"wxAuiPaneInfo.html#leftDockable/1"},{"type":"function","title":"wxAuiPaneInfo.leftDockable/2","doc":"`leftDockable/2` indicates whether a pane can be docked on the left of the frame.","ref":"wxAuiPaneInfo.html#leftDockable/2"},{"type":"function","title":"wxAuiPaneInfo.maximizeButton/1","doc":"Equivalent to  maximizeButton(This, []) .","ref":"wxAuiPaneInfo.html#maximizeButton/1"},{"type":"function","title":"wxAuiPaneInfo.maximizeButton/2","doc":"`maximizeButton/2` indicates that a maximize button should be drawn for the pane.","ref":"wxAuiPaneInfo.html#maximizeButton/2"},{"type":"function","title":"wxAuiPaneInfo.maxSize/2","doc":"`maxSize/3` sets the maximum size of the pane.","ref":"wxAuiPaneInfo.html#maxSize/2"},{"type":"function","title":"wxAuiPaneInfo.maxSize/3","doc":"","ref":"wxAuiPaneInfo.html#maxSize/3"},{"type":"function","title":"wxAuiPaneInfo.minimizeButton/1","doc":"Equivalent to  minimizeButton(This, []) .","ref":"wxAuiPaneInfo.html#minimizeButton/1"},{"type":"function","title":"wxAuiPaneInfo.minimizeButton/2","doc":"`minimizeButton/2` indicates that a minimize button should be drawn for the pane.","ref":"wxAuiPaneInfo.html#minimizeButton/2"},{"type":"function","title":"wxAuiPaneInfo.minSize/2","doc":"`minSize/3` sets the minimum size of the pane.\n\nPlease note that this is only partially supported as of this writing.","ref":"wxAuiPaneInfo.html#minSize/2"},{"type":"function","title":"wxAuiPaneInfo.minSize/3","doc":"","ref":"wxAuiPaneInfo.html#minSize/3"},{"type":"function","title":"wxAuiPaneInfo.movable/1","doc":"Equivalent to  movable(This, []) .","ref":"wxAuiPaneInfo.html#movable/1"},{"type":"function","title":"wxAuiPaneInfo.movable/2","doc":"Movable indicates whether a frame can be moved.","ref":"wxAuiPaneInfo.html#movable/2"},{"type":"function","title":"wxAuiPaneInfo.name/2","doc":"`name/2` sets the name of the pane so it can be referenced in lookup functions.\n\nIf a name is not specified by the user, a random name is assigned to the pane when it is\nadded to the manager.","ref":"wxAuiPaneInfo.html#name/2"},{"type":"function","title":"wxAuiPaneInfo.new/0","doc":"","ref":"wxAuiPaneInfo.html#new/0"},{"type":"function","title":"wxAuiPaneInfo.new/1","doc":"Copy constructor.","ref":"wxAuiPaneInfo.html#new/1"},{"type":"function","title":"wxAuiPaneInfo.paneBorder/1","doc":"Equivalent to  paneBorder(This, []) .","ref":"wxAuiPaneInfo.html#paneBorder/1"},{"type":"function","title":"wxAuiPaneInfo.paneBorder/2","doc":"PaneBorder indicates that a border should be drawn for the pane.","ref":"wxAuiPaneInfo.html#paneBorder/2"},{"type":"function","title":"wxAuiPaneInfo.pinButton/1","doc":"Equivalent to  pinButton(This, []) .","ref":"wxAuiPaneInfo.html#pinButton/1"},{"type":"function","title":"wxAuiPaneInfo.pinButton/2","doc":"`pinButton/2` indicates that a pin button should be drawn for the pane.","ref":"wxAuiPaneInfo.html#pinButton/2"},{"type":"function","title":"wxAuiPaneInfo.position/2","doc":"`position/2` determines the position of the docked pane.","ref":"wxAuiPaneInfo.html#position/2"},{"type":"function","title":"wxAuiPaneInfo.resizable/1","doc":"Equivalent to  resizable(This, []) .","ref":"wxAuiPaneInfo.html#resizable/1"},{"type":"function","title":"wxAuiPaneInfo.resizable/2","doc":"`resizable/2` allows a pane to be resized if the parameter is true, and forces it to be a\nfixed size if the parameter is false.\n\nThis is simply an antonym for `fixed/1`.","ref":"wxAuiPaneInfo.html#resizable/2"},{"type":"function","title":"wxAuiPaneInfo.right/1","doc":"`right/1` sets the pane dock position to the right side of the frame.\n\nThis is the same thing as calling Direction(wxAUI_DOCK_RIGHT).","ref":"wxAuiPaneInfo.html#right/1"},{"type":"function","title":"wxAuiPaneInfo.rightDockable/1","doc":"Equivalent to  rightDockable(This, []) .","ref":"wxAuiPaneInfo.html#rightDockable/1"},{"type":"function","title":"wxAuiPaneInfo.rightDockable/2","doc":"`rightDockable/2` indicates whether a pane can be docked on the right of the frame.","ref":"wxAuiPaneInfo.html#rightDockable/2"},{"type":"function","title":"wxAuiPaneInfo.row/2","doc":"`row/2` determines the row of the docked pane.","ref":"wxAuiPaneInfo.html#row/2"},{"type":"function","title":"wxAuiPaneInfo.safeSet/2","doc":"Write the safe parts of a PaneInfo object \"source\" into \"this\".\n\n\"Safe parts\" are all non-UI elements (e.g. all layout determining parameters like the\nsize, position etc.). \"Unsafe parts\" (pointers to button, frame and window) are not\nmodified by this write operation.\n\nRemark: This method is used when loading perspectives.","ref":"wxAuiPaneInfo.html#safeSet/2"},{"type":"function","title":"wxAuiPaneInfo.setFlag/3","doc":"`setFlag/3` turns the property given by flag on or off with the option_state parameter.","ref":"wxAuiPaneInfo.html#setFlag/3"},{"type":"function","title":"wxAuiPaneInfo.show/1","doc":"Equivalent to  show(This, []) .","ref":"wxAuiPaneInfo.html#show/1"},{"type":"function","title":"wxAuiPaneInfo.show/2","doc":"`show/2` indicates that a pane should be shown.","ref":"wxAuiPaneInfo.html#show/2"},{"type":"function","title":"wxAuiPaneInfo.toolbarPane/1","doc":"`toolbarPane/1` specifies that the pane should adopt the default toolbar pane settings.","ref":"wxAuiPaneInfo.html#toolbarPane/1"},{"type":"function","title":"wxAuiPaneInfo.top/1","doc":"`top/1` sets the pane dock position to the top of the frame.\n\nThis is the same thing as calling Direction(wxAUI_DOCK_TOP).","ref":"wxAuiPaneInfo.html#top/1"},{"type":"function","title":"wxAuiPaneInfo.topDockable/1","doc":"Equivalent to  topDockable(This, []) .","ref":"wxAuiPaneInfo.html#topDockable/1"},{"type":"function","title":"wxAuiPaneInfo.topDockable/2","doc":"`topDockable/2` indicates whether a pane can be docked at the top of the frame.","ref":"wxAuiPaneInfo.html#topDockable/2"},{"type":"function","title":"wxAuiPaneInfo.window/2","doc":"`window/2` assigns the window pointer that the `m:wxAuiPaneInfo` should use.\n\nThis normally does not need to be specified, as the window pointer is automatically\nassigned to the `m:wxAuiPaneInfo` structure as soon as it is added to the manager.","ref":"wxAuiPaneInfo.html#window/2"},{"type":"type","title":"wxAuiPaneInfo.wxAuiPaneInfo/0","doc":"","ref":"wxAuiPaneInfo.html#t:wxAuiPaneInfo/0"},{"type":"module","title":"wxAuiSimpleTabArt","doc":"Another standard tab art provider for `m:wxAuiNotebook`.\n\n`m:wxAuiSimpleTabArt` is derived from `m:wxAuiTabArt` demonstrating how to write a\ncompletely new tab art class. It can also be used as alternative to `wxAuiDefaultTabArt`\n(not implemented in wx).\n\nThis class is derived, and can use functions, from:\n\n* `m:wxAuiTabArt`\n\nwxWidgets docs: [wxAuiSimpleTabArt](https://docs.wxwidgets.org/3.2/classwx_aui_simple_tab_art.html)","ref":"wxAuiSimpleTabArt.html"},{"type":"function","title":"wxAuiSimpleTabArt.destroy/1","doc":"Destroys the object","ref":"wxAuiSimpleTabArt.html#destroy/1"},{"type":"function","title":"wxAuiSimpleTabArt.new/0","doc":"","ref":"wxAuiSimpleTabArt.html#new/0"},{"type":"type","title":"wxAuiSimpleTabArt.wxAuiSimpleTabArt/0","doc":"","ref":"wxAuiSimpleTabArt.html#t:wxAuiSimpleTabArt/0"},{"type":"module","title":"wxAuiTabArt","doc":"Tab art provider defines all the drawing functions used by `m:wxAuiNotebook`.\n\nThis allows the `m:wxAuiNotebook` to have a pluggable look-and-feel.\n\nBy default, a `m:wxAuiNotebook` uses an instance of this class called `wxAuiDefaultTabArt`\n(not implemented in wx) which provides bitmap art and a colour scheme that is adapted to\nthe major platforms' look. You can either derive from that class to alter its behaviour or\nwrite a completely new tab art class.\n\nAnother example of creating a new `m:wxAuiNotebook` tab bar is `m:wxAuiSimpleTabArt`.\n\nCall `wxAuiNotebook:setArtProvider/2` to make use of this new tab art.\n\nwxWidgets docs: [wxAuiTabArt](https://docs.wxwidgets.org/3.2/classwx_aui_tab_art.html)","ref":"wxAuiTabArt.html"},{"type":"function","title":"wxAuiTabArt.setActiveColour/2","doc":"Sets the colour of the selected tab.\n\nSince: 2.9.2","ref":"wxAuiTabArt.html#setActiveColour/2"},{"type":"function","title":"wxAuiTabArt.setColour/2","doc":"Sets the colour of the inactive tabs.\n\nSince: 2.9.2","ref":"wxAuiTabArt.html#setColour/2"},{"type":"function","title":"wxAuiTabArt.setFlags/2","doc":"Sets flags.","ref":"wxAuiTabArt.html#setFlags/2"},{"type":"function","title":"wxAuiTabArt.setMeasuringFont/2","doc":"Sets the font used for calculating measurements.","ref":"wxAuiTabArt.html#setMeasuringFont/2"},{"type":"function","title":"wxAuiTabArt.setNormalFont/2","doc":"Sets the normal font for drawing labels.","ref":"wxAuiTabArt.html#setNormalFont/2"},{"type":"function","title":"wxAuiTabArt.setSelectedFont/2","doc":"Sets the font for drawing text for selected UI elements.","ref":"wxAuiTabArt.html#setSelectedFont/2"},{"type":"type","title":"wxAuiTabArt.wxAuiTabArt/0","doc":"","ref":"wxAuiTabArt.html#t:wxAuiTabArt/0"},{"type":"module","title":"wxBitmap","doc":"This class encapsulates the concept of a platform-dependent bitmap, either monochrome or\ncolour or colour with alpha channel support.\n\nIf you need direct access the bitmap data instead going through drawing to it using `m:wxMemoryDC`\nyou need to use the `wxPixelData` (not implemented in wx) class (either wxNativePixelData\nfor RGB bitmaps or wxAlphaPixelData for bitmaps with an additionally alpha channel).\n\nNote that many `m:wxBitmap` functions take a `type` parameter, which is a value of the\n?wxBitmapType enumeration. The validity of those values depends however on the platform\nwhere your program is running and from the wxWidgets configuration. If all possible\nwxWidgets settings are used:\n\n* wxMSW supports BMP and ICO files, BMP and ICO resources;\n\n* wxGTK supports any file supported by gdk-pixbuf;\n\n* wxMac supports PICT resources;\n\n* wxX11 supports XPM files, XPM data, XBM data;\n\nIn addition, `m:wxBitmap` can load and save all formats that `m:wxImage` can; see `m:wxImage`\nfor more info. Of course, you must have loaded the `m:wxImage` handlers (see\n?wxInitAllImageHandlers() and `wxImage::AddHandler` (not implemented in wx)). Note that\nall available wxBitmapHandlers for a given wxWidgets port are automatically loaded at\nstartup so you won't need to use `wxBitmap::AddHandler` (not implemented in wx).\n\nMore on the difference between `m:wxImage` and `m:wxBitmap`: `m:wxImage` is just a buffer\nof RGB bytes with an optional buffer for the alpha bytes. It is all generic, platform\nindependent and image file format independent code. It includes generic code for scaling,\nresizing, clipping, and other manipulations of the image data. OTOH, `m:wxBitmap` is\nintended to be a wrapper of whatever is the native image format that is quickest/easiest\nto draw to a DC or to be the target of the drawing operations performed on a `m:wxMemoryDC`.\nBy splitting the responsibilities between wxImage/wxBitmap like this then it's easier to\nuse generic code shared by all platforms and image types for generic operations and\nplatform specific code where performance or compatibility is needed.\n\nPredefined objects (include wx.hrl): ?wxNullBitmap\n\nSee:\n* [Overview bitmap](https://docs.wxwidgets.org/3.2/overview_bitmap.html#overview_bitmap)\n\n* [Overview bitmap](https://docs.wxwidgets.org/3.2/overview_bitmap.html#overview_bitmap_supportedformats)\n\n* `wxDC:blit/6`\n\n* `m:wxIcon`\n\n* `m:wxCursor`\n\n* `m:wxMemoryDC`\n\n* `m:wxImage`\n\nwxWidgets docs: [wxBitmap](https://docs.wxwidgets.org/3.2/classwx_bitmap.html)","ref":"wxBitmap.html"},{"type":"function","title":"wxBitmap.convertToImage/1","doc":"Creates an image from a platform-dependent bitmap.\n\nThis preserves mask information so that bitmaps and images can be converted back and\nforth without loss in that respect.","ref":"wxBitmap.html#convertToImage/1"},{"type":"function","title":"wxBitmap.copyFromIcon/2","doc":"Creates the bitmap from an icon.","ref":"wxBitmap.html#copyFromIcon/2"},{"type":"function","title":"wxBitmap.create/2","doc":"Equivalent to  create(This, Sz, []) .","ref":"wxBitmap.html#create/2"},{"type":"function","title":"wxBitmap.create/3","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxBitmap.html#create/3"},{"type":"function","title":"wxBitmap.create/4","doc":"Create a bitmap compatible with the given DC, inheriting its magnification factor.\n\nReturn: true if the creation was successful.\n\nSince: 3.1.0","ref":"wxBitmap.html#create/4"},{"type":"function","title":"wxBitmap.destroy/1","doc":"Destroys the object","ref":"wxBitmap.html#destroy/1"},{"type":"function","title":"wxBitmap.getDepth/1","doc":"Gets the colour depth of the bitmap.\n\nA value of 1 indicates a monochrome bitmap.","ref":"wxBitmap.html#getDepth/1"},{"type":"function","title":"wxBitmap.getHeight/1","doc":"Gets the height of the bitmap in pixels.\n\nSee: `getWidth/1`","ref":"wxBitmap.html#getHeight/1"},{"type":"function","title":"wxBitmap.getMask/1","doc":"Gets the associated mask (if any) which may have been loaded from a file or set for the\nbitmap.\n\nSee:\n* `setMask/2`\n\n* `m:wxMask`","ref":"wxBitmap.html#getMask/1"},{"type":"function","title":"wxBitmap.getPalette/1","doc":"Gets the associated palette (if any) which may have been loaded from a file or set for\nthe bitmap.\n\nSee: `m:wxPalette`","ref":"wxBitmap.html#getPalette/1"},{"type":"function","title":"wxBitmap.getSubBitmap/2","doc":"Returns a sub bitmap of the current one as long as the rect belongs entirely to the\nbitmap.\n\nThis function preserves bit depth and mask information.","ref":"wxBitmap.html#getSubBitmap/2"},{"type":"function","title":"wxBitmap.getWidth/1","doc":"Gets the width of the bitmap in pixels.\n\nSee: `getHeight/1`","ref":"wxBitmap.html#getWidth/1"},{"type":"function","title":"wxBitmap.isOk/1","doc":"Returns true if bitmap data is present.","ref":"wxBitmap.html#isOk/1"},{"type":"function","title":"wxBitmap.loadFile/2","doc":"Equivalent to  loadFile(This, Name, []) .","ref":"wxBitmap.html#loadFile/2"},{"type":"function","title":"wxBitmap.loadFile/3","doc":"Loads a bitmap from a file or resource.\n\nReturn: true if the operation succeeded, false otherwise.\n\nRemark: A palette may be associated with the bitmap if one exists (especially for colour\nWindows bitmaps), and if the code supports it. You can check if one has been created by\nusing the `getPalette/1` member.\n\nSee: `saveFile/4`","ref":"wxBitmap.html#loadFile/3"},{"type":"function","title":"wxBitmap.new/0","doc":"Default constructor.\n\nConstructs a bitmap object with no data; an assignment or another member function such as `create/4`\nor `loadFile/3` must be called subsequently.","ref":"wxBitmap.html#new/0"},{"type":"function","title":"wxBitmap.new/1","doc":"","ref":"wxBitmap.html#new/1"},{"type":"function","title":"wxBitmap.new/2","doc":"Creates this bitmap object from the given image.\n\nThis has to be done to actually display an image as you cannot draw an image directly on\na window.\n\nThe resulting bitmap will use the provided colour depth (or that of the current system if\ndepth is ?wxBITMAP\\_SCREEN\\_DEPTH) which entails that a colour reduction may take place.\n\nOn Windows, if there is a palette present (set with SetPalette), it will be used when\ncreating the `m:wxBitmap` (most useful in 8-bit display mode). On other platforms, the\npalette is currently ignored.","ref":"wxBitmap.html#new/2"},{"type":"function","title":"wxBitmap.new/3","doc":"Creates a new bitmap.\n\nA depth of ?wxBITMAP\\_SCREEN\\_DEPTH indicates the depth of the current screen or visual.\n\nSome platforms only support 1 for monochrome and ?wxBITMAP\\_SCREEN\\_DEPTH for the current\ncolour setting.\n\nA depth of 32 including an alpha channel is supported under MSW, Mac and GTK+.","ref":"wxBitmap.html#new/3"},{"type":"function","title":"wxBitmap.new/4","doc":"Creates a bitmap from the given array `bits`.\n\nYou should only use this function for monochrome bitmaps (depth 1) in portable programs:\nin this case the bits parameter should contain an XBM image.\n\nFor other bit depths, the behaviour is platform dependent: under Windows, the data is\npassed without any changes to the underlying CreateBitmap() API. Under other platforms,\nonly monochrome bitmaps may be created using this constructor and `m:wxImage` should be\nused for creating colour bitmaps from static data.","ref":"wxBitmap.html#new/4"},{"type":"function","title":"wxBitmap.ok/1","doc":"Equivalent to: `isOk/1`","ref":"wxBitmap.html#ok/1"},{"type":"function","title":"wxBitmap.saveFile/3","doc":"Equivalent to  saveFile(This, Name, Type, []) .","ref":"wxBitmap.html#saveFile/3"},{"type":"function","title":"wxBitmap.saveFile/4","doc":"Saves a bitmap in the named file.\n\nReturn: true if the operation succeeded, false otherwise.\n\nRemark: Depending on how wxWidgets has been configured, not all formats may be available.\n\nSee: `loadFile/3`","ref":"wxBitmap.html#saveFile/4"},{"type":"function","title":"wxBitmap.setDepth/2","doc":"Deprecated:\n\nThis function is deprecated since version 3.1.2, dimensions and depth can only be set at\nconstruction time.\n\nSets the depth member (does not affect the bitmap data).","ref":"wxBitmap.html#setDepth/2"},{"type":"function","title":"wxBitmap.setHeight/2","doc":"Deprecated:\n\nThis function is deprecated since version 3.1.2, dimensions and depth can only be set at\nconstruction time.\n\nSets the height member (does not affect the bitmap data).","ref":"wxBitmap.html#setHeight/2"},{"type":"function","title":"wxBitmap.setMask/2","doc":"Sets the mask for this bitmap.\n\nRemark: The bitmap object owns the mask once this has been called.\n\nNote: A mask can be set also for bitmap with an alpha channel but doing so under wxMSW is\nnot recommended because performance of drawing such bitmap is not very good.\n\nSee:\n* `getMask/1`\n\n* `m:wxMask`","ref":"wxBitmap.html#setMask/2"},{"type":"function","title":"wxBitmap.setPalette/2","doc":"Sets the associated palette.\n\n(Not implemented under GTK+).\n\nSee: `m:wxPalette`","ref":"wxBitmap.html#setPalette/2"},{"type":"function","title":"wxBitmap.setWidth/2","doc":"Deprecated:\n\nThis function is deprecated since version 3.1.2, dimensions and depth can only be set at\nconstruction time.\n\nSets the width member (does not affect the bitmap data).","ref":"wxBitmap.html#setWidth/2"},{"type":"type","title":"wxBitmap.wxBitmap/0","doc":"","ref":"wxBitmap.html#t:wxBitmap/0"},{"type":"module","title":"wxBitmapButton","doc":"A bitmap button is a control that contains a bitmap.\n\nNotice that since wxWidgets 2.9.1 bitmap display is supported by the base `m:wxButton`\nclass itself and the only tiny advantage of using this class is that it allows specifying\nthe bitmap in its constructor, unlike `m:wxButton`. Please see the base class\ndocumentation for more information about images support in `m:wxButton`.","ref":"wxBitmapButton.html"},{"type":"module","title":"Styles - wxBitmapButton","doc":"This class supports the following styles:\n\n* wxBU_LEFT: Left-justifies the bitmap label.\n\n* wxBU_TOP: Aligns the bitmap label to the top of the button.\n\n* wxBU_RIGHT: Right-justifies the bitmap label.\n\n* wxBU_BOTTOM: Aligns the bitmap label to the bottom of the button. Note that the\nwxBU_EXACTFIT style supported by `m:wxButton` is not used by this class as bitmap buttons\ndon't have any minimal standard size by default.\n\nSee: `m:wxButton`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxButton`\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxBitmapButton](https://docs.wxwidgets.org/3.2/classwx_bitmap_button.html)","ref":"wxBitmapButton.html#module-styles"},{"type":"module","title":"Events - wxBitmapButton","doc":"Event types emitted from this class:\n\n* [`command_button_clicked`](`m:wxCommandEvent`)","ref":"wxBitmapButton.html#module-events"},{"type":"function","title":"wxBitmapButton.create/4","doc":"Equivalent to  create(This, Parent, Id, Bitmap, []) .","ref":"wxBitmapButton.html#create/4"},{"type":"function","title":"wxBitmapButton.create/5","doc":"Button creation function for two-step creation.\n\nFor more details, see `new/4`.","ref":"wxBitmapButton.html#create/5"},{"type":"function","title":"wxBitmapButton.destroy/1","doc":"Destroys the object","ref":"wxBitmapButton.html#destroy/1"},{"type":"function","title":"wxBitmapButton.new/0","doc":"Default ctor.","ref":"wxBitmapButton.html#new/0"},{"type":"function","title":"wxBitmapButton.new/3","doc":"Equivalent to  new(Parent, Id, Bitmap, []) .","ref":"wxBitmapButton.html#new/3"},{"type":"function","title":"wxBitmapButton.new/4","doc":"Constructor, creating and showing a button.\n\nRemark: The bitmap parameter is normally the only bitmap you need to provide, and\nwxWidgets will draw the button correctly in its different states. If you want more\ncontrol, call any of the functions `SetBitmapPressed()` (not implemented in wx), `wxButton:setBitmapFocus/2`, `wxButton:setBitmapDisabled/2`.\n\nSee: `create/5`","ref":"wxBitmapButton.html#new/4"},{"type":"function","title":"wxBitmapButton.newCloseButton/2","doc":"Helper function creating a standard-looking \"Close\" button.\n\nTo get the best results, platform-specific code may need to be used to create a small,\ntitle bar-like \"Close\" button. This function is provided to avoid the need to test for the\ncurrent platform and creates the button with as native look as possible.\n\nReturn: The new button.\n\nSince: 2.9.5","ref":"wxBitmapButton.html#newCloseButton/2"},{"type":"type","title":"wxBitmapButton.wxBitmapButton/0","doc":"","ref":"wxBitmapButton.html#t:wxBitmapButton/0"},{"type":"module","title":"wxBitmapDataObject","doc":"`m:wxBitmapDataObject` is a specialization of `m:wxDataObject` for bitmap data.\n\nIt can be used without change to paste data into the `m:wxClipboard` or a `wxDropSource`\n(not implemented in wx). A user may wish to derive a new class from this class for\nproviding a bitmap on-demand in order to minimize memory consumption when offering data in\nseveral formats, such as a bitmap and GIF.\n\nThis class may be used as is, but `getBitmap/1` may be overridden to increase efficiency.\n\nSee:\n* [Overview dnd](https://docs.wxwidgets.org/3.2/overview_dnd.html#overview_dnd)\n\n* `m:wxDataObject`\n\n* `m:wxFileDataObject`\n\n* `m:wxTextDataObject`\n\n* `m:wxDataObject`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxDataObject`\n\nwxWidgets docs: [wxBitmapDataObject](https://docs.wxwidgets.org/3.2/classwx_bitmap_data_object.html)","ref":"wxBitmapDataObject.html"},{"type":"function","title":"wxBitmapDataObject.destroy/1","doc":"Destroys the object","ref":"wxBitmapDataObject.html#destroy/1"},{"type":"function","title":"wxBitmapDataObject.getBitmap/1","doc":"Returns the bitmap associated with the data object.\n\nYou may wish to override this method when offering data on-demand, but this is not\nrequired by wxWidgets' internals. Use this method to get data in bitmap form from the `m:wxClipboard`.","ref":"wxBitmapDataObject.html#getBitmap/1"},{"type":"function","title":"wxBitmapDataObject.new/0","doc":"Equivalent to  new([]) .","ref":"wxBitmapDataObject.html#new/0"},{"type":"function","title":"wxBitmapDataObject.new/1","doc":"Constructor, optionally passing a bitmap (otherwise use `setBitmap/2` later).","ref":"wxBitmapDataObject.html#new/1"},{"type":"function","title":"wxBitmapDataObject.setBitmap/2","doc":"Sets the bitmap associated with the data object.\n\nThis method is called when the data object receives data. Usually there will be no reason\nto override this function.","ref":"wxBitmapDataObject.html#setBitmap/2"},{"type":"type","title":"wxBitmapDataObject.wxBitmapDataObject/0","doc":"","ref":"wxBitmapDataObject.html#t:wxBitmapDataObject/0"},{"type":"module","title":"wxBookCtrlBase","doc":"A book control is a convenient way of displaying multiple pages of information, displayed\none page at a time.\n\nwxWidgets has five variants of this control:\n\n* `m:wxChoicebook`: controlled by a `m:wxChoice`\n\n* `m:wxListbook`: controlled by a `m:wxListCtrl`\n\n* `m:wxNotebook`: uses a row of tabs\n\n* `m:wxTreebook`: controlled by a `m:wxTreeCtrl`\n\n* `m:wxToolbook`: controlled by a `m:wxToolBar`\n\nThis abstract class is the parent of all these book controls, and provides their basic\ninterface. This is a pure virtual class so you cannot allocate it directly.\n\nSee: [Overview bookctrl](https://docs.wxwidgets.org/3.2/overview_bookctrl.html#overview_bookctrl)\n\nThis class is derived, and can use functions, from:\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxBookCtrlBase](https://docs.wxwidgets.org/3.2/classwx_book_ctrl_base.html)","ref":"wxBookCtrlBase.html"},{"type":"function","title":"wxBookCtrlBase.addPage/3","doc":"Equivalent to  addPage(This, Page, Text, []) .","ref":"wxBookCtrlBase.html#addPage/3"},{"type":"function","title":"wxBookCtrlBase.addPage/4","doc":"Adds a new page.\n\nThe page must have the book control itself as the parent and must not have been added to\nthis control previously.\n\nThe call to this function will generate the page changing and page changed events if `select`\nis true, but not when inserting the very first page (as there is no previous page\nselection to switch from in this case and so it wouldn't make sense to e.g. veto such event).\n\nReturn: true if successful, false otherwise.\n\nRemark: Do not delete the page, it will be deleted by the book control.\n\nSee: `insertPage/5`","ref":"wxBookCtrlBase.html#addPage/4"},{"type":"function","title":"wxBookCtrlBase.advanceSelection/1","doc":"Equivalent to  advanceSelection(This, []) .","ref":"wxBookCtrlBase.html#advanceSelection/1"},{"type":"function","title":"wxBookCtrlBase.advanceSelection/2","doc":"Cycles through the tabs.\n\nThe call to this function generates the page changing events.","ref":"wxBookCtrlBase.html#advanceSelection/2"},{"type":"function","title":"wxBookCtrlBase.changeSelection/2","doc":"Changes the selection to the given page, returning the previous selection.\n\nThis function behaves as `setSelection/2` but does `not` generate the page changing events.\n\nSee overview_events_prog for more information.","ref":"wxBookCtrlBase.html#changeSelection/2"},{"type":"function","title":"wxBookCtrlBase.deleteAllPages/1","doc":"Deletes all pages.","ref":"wxBookCtrlBase.html#deleteAllPages/1"},{"type":"function","title":"wxBookCtrlBase.deletePage/2","doc":"Deletes the specified page, and the associated window.\n\nThe call to this function generates the page changing events when deleting the currently\nselected page or a page preceding it in the index order, but it does `not` send any events\nwhen deleting the last page: while in this case the selection also changes, it becomes\ninvalid and for compatibility reasons the control never generates events with the invalid\nselection index.","ref":"wxBookCtrlBase.html#deletePage/2"},{"type":"function","title":"wxBookCtrlBase.getCurrentPage/1","doc":"Returns the currently selected page or NULL.","ref":"wxBookCtrlBase.html#getCurrentPage/1"},{"type":"function","title":"wxBookCtrlBase.getPage/2","doc":"Returns the window at the given page position.","ref":"wxBookCtrlBase.html#getPage/2"},{"type":"function","title":"wxBookCtrlBase.getPageCount/1","doc":"Returns the number of pages in the control.","ref":"wxBookCtrlBase.html#getPageCount/1"},{"type":"function","title":"wxBookCtrlBase.getPageText/2","doc":"Returns the string for the given page.","ref":"wxBookCtrlBase.html#getPageText/2"},{"type":"function","title":"wxBookCtrlBase.getSelection/1","doc":"Returns the currently selected page, or `wxNOT\\_FOUND` if none was selected.\n\nNote that this method may return either the previously or newly selected page when called\nfrom the `EVT_BOOKCTRL_PAGE_CHANGED` handler depending on the platform and so `wxBookCtrlEvent:getSelection/1` should be\nused instead in this case.","ref":"wxBookCtrlBase.html#getSelection/1"},{"type":"function","title":"wxBookCtrlBase.hitTest/2","doc":"Returns the index of the tab at the specified position or `wxNOT\\_FOUND` if none.\n\nIf `flags` parameter is non-NULL, the position of the point inside the tab is returned as well.\n\nReturn: Returns the zero-based tab index or `wxNOT_FOUND` if there is no tab at the\nspecified position.","ref":"wxBookCtrlBase.html#hitTest/2"},{"type":"function","title":"wxBookCtrlBase.insertPage/4","doc":"Equivalent to  insertPage(This, Index, Page, Text, []) .","ref":"wxBookCtrlBase.html#insertPage/4"},{"type":"function","title":"wxBookCtrlBase.insertPage/5","doc":"Inserts a new page at the specified position.\n\nReturn: true if successful, false otherwise.\n\nRemark: Do not delete the page, it will be deleted by the book control.\n\nSee: `addPage/4`","ref":"wxBookCtrlBase.html#insertPage/5"},{"type":"function","title":"wxBookCtrlBase.removePage/2","doc":"Deletes the specified page, without deleting the associated window.\n\nSee `deletePage/2` for a note about the events generated by this function.","ref":"wxBookCtrlBase.html#removePage/2"},{"type":"function","title":"wxBookCtrlBase.setPageText/3","doc":"Sets the text for the given page.","ref":"wxBookCtrlBase.html#setPageText/3"},{"type":"function","title":"wxBookCtrlBase.setSelection/2","doc":"Sets the selection to the given page, returning the previous selection.\n\nNotice that the call to this function generates the page changing events, use the `changeSelection/2`\nfunction if you don't want these events to be generated.\n\nSee: `getSelection/1`","ref":"wxBookCtrlBase.html#setSelection/2"},{"type":"type","title":"wxBookCtrlBase.wxBookCtrlBase/0","doc":"","ref":"wxBookCtrlBase.html#t:wxBookCtrlBase/0"},{"type":"module","title":"wxBookCtrlEvent","doc":"This class represents the events generated by book controls (`m:wxNotebook`, `m:wxListbook`, `m:wxChoicebook`, `m:wxTreebook`, `m:wxAuiNotebook`).\n\nThe PAGE_CHANGING events are sent before the current page is changed. It allows the\nprogram to examine the current page (which can be retrieved with `getOldSelection/1`) and to veto the page\nchange by calling `wxNotifyEvent:veto/1` if, for example, the current values in the controls of the old page are invalid.\n\nThe PAGE_CHANGED events are sent after the page has been changed and the program cannot\nveto it any more, it just informs it about the page change.\n\nTo summarize, if the program is interested in validating the page values before allowing\nthe user to change it, it should process the PAGE_CHANGING event, otherwise PAGE_CHANGED\nis probably enough. In any case, it is probably unnecessary to process both events at once.\n\nSee:\n* `m:wxNotebook`\n\n* `m:wxListbook`\n\n* `m:wxChoicebook`\n\n* `m:wxTreebook`\n\n* `m:wxToolbook`\n\n* `m:wxAuiNotebook`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxNotifyEvent`\n\n* `m:wxCommandEvent`\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxBookCtrlEvent](https://docs.wxwidgets.org/3.2/classwx_book_ctrl_event.html)","ref":"wxBookCtrlEvent.html"},{"type":"function","title":"wxBookCtrlEvent.getOldSelection/1","doc":"Returns the page that was selected before the change, `wxNOT\\_FOUND` if none was\nselected.","ref":"wxBookCtrlEvent.html#getOldSelection/1"},{"type":"function","title":"wxBookCtrlEvent.getSelection/1","doc":"Returns the currently selected page, or `wxNOT\\_FOUND` if none was selected.\n\nNote: under Windows, `getSelection/1` will return the same value as `getOldSelection/1` when called from the `EVT_BOOKCTRL_PAGE_CHANGING`\nhandler and not the page which is going to be selected.","ref":"wxBookCtrlEvent.html#getSelection/1"},{"type":"function","title":"wxBookCtrlEvent.setOldSelection/2","doc":"Sets the id of the page selected before the change.","ref":"wxBookCtrlEvent.html#setOldSelection/2"},{"type":"function","title":"wxBookCtrlEvent.setSelection/2","doc":"Sets the selection member variable.","ref":"wxBookCtrlEvent.html#setSelection/2"},{"type":"type","title":"wxBookCtrlEvent.wxBookCtrl/0","doc":"","ref":"wxBookCtrlEvent.html#t:wxBookCtrl/0"},{"type":"type","title":"wxBookCtrlEvent.wxBookCtrlEvent/0","doc":"","ref":"wxBookCtrlEvent.html#t:wxBookCtrlEvent/0"},{"type":"type","title":"wxBookCtrlEvent.wxBookCtrlEventType/0","doc":"","ref":"wxBookCtrlEvent.html#t:wxBookCtrlEventType/0"},{"type":"module","title":"wxBoxSizer","doc":"The basic idea behind a box sizer is that windows will most often be laid out in rather\nsimple basic geometry, typically in a row or a column or several hierarchies of either.\n\nFor more information, please see overview_sizer_box.\n\nSee:\n* `m:wxSizer`\n\n* [Overview sizer](https://docs.wxwidgets.org/3.2/overview_sizer.html#overview_sizer)\n\nThis class is derived, and can use functions, from:\n\n* `m:wxSizer`\n\nwxWidgets docs: [wxBoxSizer](https://docs.wxwidgets.org/3.2/classwx_box_sizer.html)","ref":"wxBoxSizer.html"},{"type":"function","title":"wxBoxSizer.destroy/1","doc":"Destroys the object","ref":"wxBoxSizer.html#destroy/1"},{"type":"function","title":"wxBoxSizer.getOrientation/1","doc":"Returns the orientation of the box sizer, either wxVERTICAL or wxHORIZONTAL.","ref":"wxBoxSizer.html#getOrientation/1"},{"type":"function","title":"wxBoxSizer.new/1","doc":"Constructor for a `m:wxBoxSizer`.\n\n`orient` may be either of wxVERTICAL or wxHORIZONTAL for creating either a column sizer\nor a row sizer.","ref":"wxBoxSizer.html#new/1"},{"type":"type","title":"wxBoxSizer.wxBoxSizer/0","doc":"","ref":"wxBoxSizer.html#t:wxBoxSizer/0"},{"type":"module","title":"wxBrush","doc":"A brush is a drawing tool for filling in areas.\n\nIt is used for painting the background of rectangles, ellipses, etc. It has a colour and\na style.\n\nOn a monochrome display, wxWidgets shows all brushes as white unless the colour is really black.\n\nDo not initialize objects on the stack before the program commences, since other required\nstructures may not have been set up yet. Instead, define global pointers to objects and\ncreate them in `wxApp::OnInit` (not implemented in wx) or when required.\n\nAn application may wish to create brushes with different characteristics dynamically, and\nthere is the consequent danger that a large number of duplicate brushes will be created.\nTherefore an application may wish to get a pointer to a brush by using the global list of\nbrushes ?wxTheBrushList, and calling the member function `wxBrushList::FindOrCreateBrush()`\n(not implemented in wx).\n\nThis class uses reference counting and copy-on-write internally so that assignments\nbetween two instances of this class are very cheap. You can therefore use actual objects\ninstead of pointers without efficiency problems. If an instance of this class is changed\nit will create its own data internally so that other instances, which previously shared\nthe data using the reference counting, are not affected.\n\nPredefined objects (include wx.hrl):\n\n* ?wxNullBrush\n\n* ?wxBLACK\\_BRUSH\n\n* ?wxBLUE\\_BRUSH\n\n* ?wxCYAN\\_BRUSH\n\n* ?wxGREEN\\_BRUSH\n\n* ?wxYELLOW\\_BRUSH\n\n* ?wxGREY\\_BRUSH\n\n* ?wxLIGHT\\_GREY\\_BRUSH\n\n* ?wxMEDIUM\\_GREY\\_BRUSH\n\n* ?wxRED\\_BRUSH\n\n* ?wxTRANSPARENT\\_BRUSH\n\n* ?wxWHITE\\_BRUSH\n\nSee:\n* `m:wxDC`\n\n* `wxDC:setBrush/2`\n\nwxWidgets docs: [wxBrush](https://docs.wxwidgets.org/3.2/classwx_brush.html)","ref":"wxBrush.html"},{"type":"function","title":"wxBrush.destroy/1","doc":"Destroys the object","ref":"wxBrush.html#destroy/1"},{"type":"function","title":"wxBrush.getColour/1","doc":"Returns a reference to the brush colour.\n\nSee: `setColour/4`","ref":"wxBrush.html#getColour/1"},{"type":"function","title":"wxBrush.getStipple/1","doc":"Gets a pointer to the stipple bitmap.\n\nIf the brush does not have a `wxBRUSHSTYLE_STIPPLE` style, this bitmap may be non-NULL\nbut uninitialised (i.e. `m:wxBitmap`:`isOk/1` returns false).\n\nSee: `setStipple/2`","ref":"wxBrush.html#getStipple/1"},{"type":"function","title":"wxBrush.getStyle/1","doc":"Returns the brush style, one of the ?wxBrushStyle values.\n\nSee:\n* `setStyle/2`\n\n* `setColour/4`\n\n* `setStipple/2`","ref":"wxBrush.html#getStyle/1"},{"type":"function","title":"wxBrush.isHatch/1","doc":"Returns true if the style of the brush is any of hatched fills.\n\nSee: `getStyle/1`","ref":"wxBrush.html#isHatch/1"},{"type":"function","title":"wxBrush.isOk/1","doc":"Returns true if the brush is initialised.\n\nNotice that an uninitialized brush object can't be queried for any brush properties and\nall calls to the accessor methods on it will result in an assert failure.","ref":"wxBrush.html#isOk/1"},{"type":"function","title":"wxBrush.new/0","doc":"Default constructor.\n\nThe brush will be uninitialised, and `m:wxBrush`:`isOk/1` will return false.","ref":"wxBrush.html#new/0"},{"type":"function","title":"wxBrush.new/1","doc":"Copy constructor, uses reference counting.","ref":"wxBrush.html#new/1"},{"type":"function","title":"wxBrush.new/2","doc":"Constructs a brush from a colour object and `style`.","ref":"wxBrush.html#new/2"},{"type":"function","title":"wxBrush.setColour/2","doc":"Sets the brush colour using red, green and blue values.\n\nSee: `getColour/1`","ref":"wxBrush.html#setColour/2"},{"type":"function","title":"wxBrush.setColour/4","doc":"","ref":"wxBrush.html#setColour/4"},{"type":"function","title":"wxBrush.setStipple/2","doc":"Sets the stipple bitmap.\n\nRemark: The style will be set to `wxBRUSHSTYLE_STIPPLE`, unless the bitmap has a mask\nassociated to it, in which case the style will be set to `wxBRUSHSTYLE_STIPPLE_MASK_OPAQUE`.\n\nSee: `m:wxBitmap`","ref":"wxBrush.html#setStipple/2"},{"type":"function","title":"wxBrush.setStyle/2","doc":"Sets the brush style.\n\nSee: `getStyle/1`","ref":"wxBrush.html#setStyle/2"},{"type":"type","title":"wxBrush.wxBrush/0","doc":"","ref":"wxBrush.html#t:wxBrush/0"},{"type":"module","title":"wxBufferedDC","doc":"This class provides a simple way to avoid flicker: when drawing on it, everything is in\nfact first drawn on an in-memory buffer (a `m:wxBitmap`) and then copied to the screen,\nusing the associated `m:wxDC`, only once, when this object is destroyed.\n\n`m:wxBufferedDC` itself is typically associated with `m:wxClientDC`, if you want to use\nit in your `EVT_PAINT` handler, you should look at `m:wxBufferedPaintDC` instead.\n\nWhen used like this, a valid `DC` must be specified in the constructor while the `buffer`\nbitmap doesn't have to be explicitly provided, by default this class will allocate the\nbitmap of required size itself. However using a dedicated bitmap can speed up the\nredrawing process by eliminating the repeated creation and destruction of a possibly big\nbitmap. Otherwise, `m:wxBufferedDC` can be used in the same way as any other device context.\n\nAnother possible use for `m:wxBufferedDC` is to use it to maintain a backing store for\nthe window contents. In this case, the associated `DC` may be NULL but a valid backing\nstore bitmap should be specified.\n\nFinally, please note that GTK+ 2.0 as well as macOS provide double buffering themselves\nnatively. You can either use `wxWindow:isDoubleBuffered/1` to determine whether you need to use buffering or not, or\nuse `wxAutoBufferedPaintDC` (not implemented in wx) to avoid needless double buffering on\nthe systems which already do it automatically.\n\nSee:\n* `m:wxDC`\n\n* `m:wxMemoryDC`\n\n* `m:wxBufferedPaintDC`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxMemoryDC`\n\n* `m:wxDC`\n\nwxWidgets docs: [wxBufferedDC](https://docs.wxwidgets.org/3.2/classwx_buffered_d_c.html)","ref":"wxBufferedDC.html"},{"type":"function","title":"wxBufferedDC.destroy/1","doc":"Destroys the object","ref":"wxBufferedDC.html#destroy/1"},{"type":"function","title":"wxBufferedDC.init/2","doc":"Equivalent to  init(This, Dc, []) .","ref":"wxBufferedDC.html#init/2"},{"type":"function","title":"wxBufferedDC.init/3","doc":"","ref":"wxBufferedDC.html#init/3"},{"type":"function","title":"wxBufferedDC.init/4","doc":"Initializes the object created using the default constructor.\n\nPlease see the constructors for parameter details.","ref":"wxBufferedDC.html#init/4"},{"type":"function","title":"wxBufferedDC.new/0","doc":"Default constructor.\n\nYou must call one of the `init/4` methods later in order to use the device context.","ref":"wxBufferedDC.html#new/0"},{"type":"function","title":"wxBufferedDC.new/1","doc":"Equivalent to  new(Dc, []) .","ref":"wxBufferedDC.html#new/1"},{"type":"function","title":"wxBufferedDC.new/2","doc":"Creates a buffer for the provided dc.\n\n`init/4` must not be called when using this constructor.","ref":"wxBufferedDC.html#new/2"},{"type":"function","title":"wxBufferedDC.new/3","doc":"Creates a buffer for the provided `dc`.\n\n`init/4` must not be called when using this constructor.","ref":"wxBufferedDC.html#new/3"},{"type":"type","title":"wxBufferedDC.wxBufferedDC/0","doc":"","ref":"wxBufferedDC.html#t:wxBufferedDC/0"},{"type":"module","title":"wxBufferedPaintDC","doc":"This is a subclass of `m:wxBufferedDC` which can be used inside of an `EVT\\_PAINT()`\nevent handler to achieve double-buffered drawing.\n\nJust use this class instead of `m:wxPaintDC` and make sure `wxWindow:setBackgroundStyle/2` is called with\nwxBG_STYLE_PAINT somewhere in the class initialization code, and that's all you have to do\nto (mostly) avoid flicker. The only thing to watch out for is that if you are using this\nclass together with `wxScrolled` (not implemented in wx), you probably do `not` want to\ncall `wxScrolledWindow:prepareDC/2` on it as it already does this internally for the real underlying `m:wxPaintDC`.\n\nSee:\n* `m:wxDC`\n\n* `m:wxBufferedDC`\n\n* `m:wxPaintDC`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxBufferedDC`\n\n* `m:wxMemoryDC`\n\n* `m:wxDC`\n\nwxWidgets docs: [wxBufferedPaintDC](https://docs.wxwidgets.org/3.2/classwx_buffered_paint_d_c.html)","ref":"wxBufferedPaintDC.html"},{"type":"function","title":"wxBufferedPaintDC.destroy/1","doc":"Destroys the object","ref":"wxBufferedPaintDC.html#destroy/1"},{"type":"function","title":"wxBufferedPaintDC.new/1","doc":"Equivalent to  new(Window, []) .","ref":"wxBufferedPaintDC.html#new/1"},{"type":"function","title":"wxBufferedPaintDC.new/2","doc":"","ref":"wxBufferedPaintDC.html#new/2"},{"type":"function","title":"wxBufferedPaintDC.new/3","doc":"As with `m:wxBufferedDC`, you may either provide the bitmap to be used for buffering or\nlet this object create one internally (in the latter case, the size of the client part of\nthe window is used).\n\nPass wxBUFFER_CLIENT_AREA for the `style` parameter to indicate that just the client area\nof the window is buffered, or wxBUFFER_VIRTUAL_AREA to indicate that the buffer bitmap\ncovers the virtual area.","ref":"wxBufferedPaintDC.html#new/3"},{"type":"type","title":"wxBufferedPaintDC.wxBufferedPaintDC/0","doc":"","ref":"wxBufferedPaintDC.html#t:wxBufferedPaintDC/0"},{"type":"module","title":"wxButton","doc":"A button is a control that contains a text string, and is one of the most common elements\nof a GUI.\n\nIt may be placed on a `m:wxDialog` or on a `m:wxPanel` panel, or indeed on almost any\nother window.\n\nBy default, i.e. if none of the alignment styles are specified, the label is centered\nboth horizontally and vertically. If the button has both a label and a bitmap, the\nalignment styles above specify the location of the rectangle combining both the label and\nthe bitmap and the bitmap position set with `wxButton::SetBitmapPosition()` (not\nimplemented in wx) defines the relative position of the bitmap with respect to the label\n(however currently non-default alignment combinations are not implemented on all platforms).\n\nSince version 2.9.1 `m:wxButton` supports showing both text and an image (currently only\nwhen using wxMSW, wxGTK or wxOSX/Cocoa ports), see `SetBitmap()` (not implemented in wx)\nand `setBitmapLabel/2`, `setBitmapDisabled/2` &c methods. In the previous wxWidgets versions this functionality was only\navailable in (the now trivial) `m:wxBitmapButton` class which was only capable of showing\nan image without text.\n\nA button may have either a single image for all states or different images for the\nfollowing states (different images are not currently supported under macOS where the\nnormal image is used for all states):\n\n* `normal:` the default state\n\n* `disabled:` bitmap shown when the button is disabled.\n\n* `pressed:` bitmap shown when the button is pushed (e.g. while the user keeps the mouse\nbutton pressed on it)\n\n* `focus:` bitmap shown when the button has keyboard focus (but is not pressed as in this\ncase the button is in the pressed state)\n\n* `current:` bitmap shown when the mouse is over the button (but it is not pressed although\nit may have focus). Notice that if current bitmap is not specified but the current\nplatform UI uses hover images for the buttons (such as Windows or GTK+), then the focus\nbitmap is used for hover state as well. This makes it possible to set focus bitmap only to\nget reasonably good behaviour on all platforms.\n\nAll of the bitmaps must be of the same size and the normal bitmap must be set first (to\na valid bitmap), before setting any other ones. Also, if the size of the bitmaps is\nchanged later, you need to change the size of the normal bitmap before setting any other\nbitmaps with the new size (and you do need to reset all of them as their original values\ncan be lost when the normal bitmap size changes).\n\nThe position of the image inside the button be configured using `SetBitmapPosition()`\n(not implemented in wx). By default the image is on the left of the text.\n\nPlease also notice that GTK+ uses a global setting called `gtk-button-images` to\ndetermine if the images should be shown in the buttons at all. If it is off (which is the\ncase in e.g. Gnome 2.28 by default), no images will be shown, consistently with the native behaviour.","ref":"wxButton.html"},{"type":"module","title":"Styles - wxButton","doc":"This class supports the following styles:\n\n* wxBU_LEFT: Left-justifies the label. Windows and GTK+ only.\n\n* wxBU_TOP: Aligns the label to the top of the button. Windows and GTK+ only.\n\n* wxBU_RIGHT: Right-justifies the bitmap label. Windows and GTK+ only.\n\n* wxBU_BOTTOM: Aligns the label to the bottom of the button. Windows and GTK+ only.\n\n* wxBU_EXACTFIT: By default, all buttons are made of at least the standard button size,\neven if their contents is small enough to fit into a smaller size. This is done for\nconsistency as most platforms use buttons of the same size in the native dialogs, but can\nbe overridden by specifying this flag. If it is given, the button will be made just big\nenough for its contents. Notice that under MSW the button will still have at least the\nstandard height, even with this style, if it has a non-empty label.\n\n* wxBU_NOTEXT: Disables the display of the text label in the button even if it has one or\nits id is one of the standard stock ids with an associated label: without using this style\na button which is only supposed to show a bitmap but uses a standard id would display a\nlabel too.\n\n* wxBORDER_NONE: Creates a button without border. This is currently implemented in MSW,\nGTK2 and OSX/Cocoa.\n\nSee: `m:wxBitmapButton`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxButton](https://docs.wxwidgets.org/3.2/classwx_button.html)","ref":"wxButton.html#module-styles"},{"type":"module","title":"Events - wxButton","doc":"Event types emitted from this class:\n\n* [`command_button_clicked`](`m:wxCommandEvent`)","ref":"wxButton.html#module-events"},{"type":"function","title":"wxButton.create/3","doc":"Equivalent to  create(This, Parent, Id, []) .","ref":"wxButton.html#create/3"},{"type":"function","title":"wxButton.create/4","doc":"Button creation function for two-step creation.\n\nFor more details, see `new/3`.","ref":"wxButton.html#create/4"},{"type":"function","title":"wxButton.destroy/1","doc":"Destroys the object","ref":"wxButton.html#destroy/1"},{"type":"function","title":"wxButton.getBitmapDisabled/1","doc":"Returns the bitmap for the disabled state, which may be invalid.\n\nSee: `setBitmapDisabled/2`\n\nSince: 2.9.1 (available in `m:wxBitmapButton` only in previous versions)","ref":"wxButton.html#getBitmapDisabled/1"},{"type":"function","title":"wxButton.getBitmapFocus/1","doc":"Returns the bitmap for the focused state, which may be invalid.\n\nSee: `setBitmapFocus/2`\n\nSince: 2.9.1 (available in `m:wxBitmapButton` only in previous versions)","ref":"wxButton.html#getBitmapFocus/1"},{"type":"function","title":"wxButton.getBitmapLabel/1","doc":"Returns the bitmap for the normal state.\n\nThis is exactly the same as `GetBitmap()` (not implemented in wx) but uses a name\nbackwards-compatible with `m:wxBitmapButton`.\n\nSee: `setBitmapLabel/2`\n\nSince: 2.9.1 (available in `m:wxBitmapButton` only in previous versions)","ref":"wxButton.html#getBitmapLabel/1"},{"type":"function","title":"wxButton.getDefaultSize/0","doc":"Returns the default size for the buttons.\n\nIt is advised to make all the dialog buttons of the same size and this function allows\nretrieving the (platform, and current font dependent) size which should be the best suited\nfor this.\n\nThe optional `win` argument is new since wxWidgets 3.1.3 and allows to get a per-monitor\nDPI specific size.","ref":"wxButton.html#getDefaultSize/0"},{"type":"function","title":"wxButton.getDefaultSize/1","doc":"","ref":"wxButton.html#getDefaultSize/1"},{"type":"function","title":"wxButton.new/0","doc":"Default ctor.","ref":"wxButton.html#new/0"},{"type":"function","title":"wxButton.new/2","doc":"Equivalent to  new(Parent, Id, []) .","ref":"wxButton.html#new/2"},{"type":"function","title":"wxButton.new/3","doc":"Constructor, creating and showing a button.\n\nThe preferred way to create standard buttons is to use default value of `label`. If no\nlabel is supplied and `id` is one of standard IDs from this list, a standard label will be\nused. In other words, if you use a predefined `wxID_XXX` constant, just omit the label\ncompletely rather than specifying it. In particular, help buttons (the ones with `id` of `wxID_HELP`)\nunder macOS can't display any label at all and while `m:wxButton` will detect if the\nstandard \"Help\" label is used and ignore it, using any other label will prevent the button\nfrom correctly appearing as a help button and so should be avoided.\n\nIn addition to that, the button will be decorated with stock icons under GTK+ 2.\n\nSee: `create/4`","ref":"wxButton.html#new/3"},{"type":"function","title":"wxButton.setBitmapDisabled/2","doc":"Sets the bitmap for the disabled button appearance.\n\nIf `bitmap` is invalid, the disabled bitmap is set to the automatically generated greyed\nout version of the normal bitmap, i.e. the same bitmap as is used by default if this\nmethod is not called at all. Use `SetBitmap()` (not implemented in wx) with an invalid\nbitmap to remove the bitmap completely (for all states).\n\nSee:\n* `getBitmapDisabled/1`\n\n* `setBitmapLabel/2`\n\n* `setBitmapFocus/2`\n\nSince: 2.9.1 (available in `m:wxBitmapButton` only in previous versions)","ref":"wxButton.html#setBitmapDisabled/2"},{"type":"function","title":"wxButton.setBitmapFocus/2","doc":"Sets the bitmap for the button appearance when it has the keyboard focus.\n\nIf `bitmap` is invalid, the normal bitmap will be used in the focused state.\n\nSee:\n* `getBitmapFocus/1`\n\n* `setBitmapLabel/2`\n\n* `setBitmapDisabled/2`\n\nSince: 2.9.1 (available in `m:wxBitmapButton` only in previous versions)","ref":"wxButton.html#setBitmapFocus/2"},{"type":"function","title":"wxButton.setBitmapLabel/2","doc":"Sets the bitmap label for the button.\n\nRemark: This is the bitmap used for the unselected state, and for all other states if no\nother bitmaps are provided.\n\nSee: `getBitmapLabel/1`\n\nSince: 2.9.1 (available in `m:wxBitmapButton` only in previous versions)","ref":"wxButton.html#setBitmapLabel/2"},{"type":"function","title":"wxButton.setDefault/1","doc":"This sets the button to be the default item in its top-level window (e.g.\n\nthe panel or the dialog box containing it).\n\nAs normal, pressing return causes the default button to be depressed when the return key\nis pressed.\n\nSee also `wxWindow:setFocus/1` which sets the keyboard focus for windows and text panel items, and `wxTopLevelWindow::SetDefaultItem()`\n(not implemented in wx).\n\nRemark: Under Windows, only dialog box buttons respond to this function.\n\nReturn: the old default item (possibly NULL)","ref":"wxButton.html#setDefault/1"},{"type":"function","title":"wxButton.setLabel/2","doc":"Sets the string label for the button.","ref":"wxButton.html#setLabel/2"},{"type":"type","title":"wxButton.wxButton/0","doc":"","ref":"wxButton.html#t:wxButton/0"},{"type":"module","title":"wxCalendarCtrl","doc":"The calendar control allows the user to pick a date.\n\nThe user can move the current selection using the keyboard and select the date\n(generating `EVT_CALENDAR` event) by pressing ` ` or double clicking it.\n\nGeneric calendar has advanced possibilities for the customization of its display,\ndescribed below. If you want to use these possibilities on every platform, use\nwxGenericCalendarCtrl instead of `m:wxCalendarCtrl`.\n\nAll global settings (such as colours and fonts used) can, of course, be changed. But\nalso, the display style for each day in the month can be set independently using `m:wxCalendarDateAttr`\nclass.\n\nAn item without custom attributes is drawn with the default colours and font and without\nborder, but setting custom attributes with `setAttr/3` allows modifying its appearance. Just create a\ncustom attribute object and set it for the day you want to be displayed specially (note\nthat the control will take ownership of the pointer, i.e. it will delete it itself). A day\nmay be marked as being a holiday, even if it is not recognized as one by `wx_datetime()` using the `wxCalendarDateAttr:setHoliday/2` method.\n\nAs the attributes are specified for each day, they may change when the month is changed,\nso you will often want to update them in `EVT_CALENDAR_PAGE_CHANGED` event handler.\n\nIf neither the `wxCAL_SUNDAY_FIRST` or `wxCAL_MONDAY_FIRST` style is given, the first day\nof the week is determined from operating system's settings, if possible. The native wxGTK\ncalendar chooses the first weekday based on locale, and these styles have no effect on it.","ref":"wxCalendarCtrl.html"},{"type":"module","title":"Styles - wxCalendarCtrl","doc":"This class supports the following styles:\n\n* wxCAL_SUNDAY_FIRST: Show Sunday as the first day in the week (not in wxGTK)\n\n* wxCAL_MONDAY_FIRST: Show Monday as the first day in the week (not in wxGTK)\n\n* wxCAL_SHOW_HOLIDAYS: Highlight holidays in the calendar (only generic)\n\n* wxCAL_NO_YEAR_CHANGE: Disable the year changing (deprecated, only generic)\n\n* wxCAL_NO_MONTH_CHANGE: Disable the month (and, implicitly, the year) changing\n\n* wxCAL_SHOW_SURROUNDING_WEEKS: Show the neighbouring weeks in the previous and next months\n(only generic, always on for the native controls)\n\n* wxCAL_SEQUENTIAL_MONTH_SELECTION: Use alternative, more compact, style for the month and\nyear selection controls. (only generic)\n\n* wxCAL_SHOW_WEEK_NUMBERS: Show week numbers on the left side of the calendar. (not in\ngeneric)\n\nSee:\n* [Examples](https://docs.wxwidgets.org/3.2/page_samples.html#page_samples_calendar)\n\n* `m:wxCalendarDateAttr`\n\n* `m:wxCalendarEvent`\n\n* `m:wxDatePickerCtrl`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxCalendarCtrl](https://docs.wxwidgets.org/3.2/classwx_calendar_ctrl.html)","ref":"wxCalendarCtrl.html#module-styles"},{"type":"module","title":"Events - wxCalendarCtrl","doc":"Event types emitted from this class:\n\n* [`calendar_sel_changed`](`m:wxCalendarEvent`)\n\n* [`calendar_weekday_clicked`](`m:wxCalendarEvent`)","ref":"wxCalendarCtrl.html#module-events"},{"type":"function","title":"wxCalendarCtrl.create/3","doc":"Equivalent to  create(This, Parent, Id, []) .","ref":"wxCalendarCtrl.html#create/3"},{"type":"function","title":"wxCalendarCtrl.create/4","doc":"Creates the control.\n\nSee `wxWindow:new/3` for the meaning of the parameters and the control overview for the possible styles.","ref":"wxCalendarCtrl.html#create/4"},{"type":"function","title":"wxCalendarCtrl.destroy/1","doc":"Destroys the object","ref":"wxCalendarCtrl.html#destroy/1"},{"type":"function","title":"wxCalendarCtrl.enableHolidayDisplay/1","doc":"Equivalent to  enableHolidayDisplay(This, []) .","ref":"wxCalendarCtrl.html#enableHolidayDisplay/1"},{"type":"function","title":"wxCalendarCtrl.enableHolidayDisplay/2","doc":"This function should be used instead of changing `wxCAL\\_SHOW\\_HOLIDAYS` style bit\ndirectly.\n\nIt enables or disables the special highlighting of the holidays.","ref":"wxCalendarCtrl.html#enableHolidayDisplay/2"},{"type":"function","title":"wxCalendarCtrl.enableMonthChange/1","doc":"Equivalent to  enableMonthChange(This, []) .","ref":"wxCalendarCtrl.html#enableMonthChange/1"},{"type":"function","title":"wxCalendarCtrl.enableMonthChange/2","doc":"This function should be used instead of changing `wxCAL\\_NO\\_MONTH\\_CHANGE` style bit.\n\nIt allows or disallows the user to change the month interactively. Note that if the month\ncannot be changed, the year cannot be changed neither.\n\nReturn: true if the value of this option really changed or false if it was already set to\nthe requested value.","ref":"wxCalendarCtrl.html#enableMonthChange/2"},{"type":"function","title":"wxCalendarCtrl.enableYearChange/1","doc":"Equivalent to  enableYearChange(This, []) .","ref":"wxCalendarCtrl.html#enableYearChange/1"},{"type":"function","title":"wxCalendarCtrl.enableYearChange/2","doc":"Deprecated:\n\nThis function should be used instead of changing `wxCAL_NO_YEAR_CHANGE` style bit\ndirectly. It allows or disallows the user to change the year interactively. Only in\ngeneric `m:wxCalendarCtrl`.","ref":"wxCalendarCtrl.html#enableYearChange/2"},{"type":"function","title":"wxCalendarCtrl.getAttr/2","doc":"Returns the attribute for the given date (should be in the range 1...31).\n\nThe returned pointer may be NULL. Only in generic `m:wxCalendarCtrl`.","ref":"wxCalendarCtrl.html#getAttr/2"},{"type":"function","title":"wxCalendarCtrl.getDate/1","doc":"Gets the currently selected date.","ref":"wxCalendarCtrl.html#getDate/1"},{"type":"function","title":"wxCalendarCtrl.getHeaderColourBg/1","doc":"Gets the background colour of the header part of the calendar window.\n\nThis method is currently only implemented in generic `m:wxCalendarCtrl` and always\nreturns `wxNullColour` in the native versions.\n\nSee: `setHeaderColours/3`","ref":"wxCalendarCtrl.html#getHeaderColourBg/1"},{"type":"function","title":"wxCalendarCtrl.getHeaderColourFg/1","doc":"Gets the foreground colour of the header part of the calendar window.\n\nThis method is currently only implemented in generic `m:wxCalendarCtrl` and always\nreturns `wxNullColour` in the native versions.\n\nSee: `setHeaderColours/3`","ref":"wxCalendarCtrl.html#getHeaderColourFg/1"},{"type":"function","title":"wxCalendarCtrl.getHighlightColourBg/1","doc":"Gets the background highlight colour.\n\nOnly in generic `m:wxCalendarCtrl`.\n\nThis method is currently only implemented in generic `m:wxCalendarCtrl` and always\nreturns `wxNullColour` in the native versions.\n\nSee: `setHighlightColours/3`","ref":"wxCalendarCtrl.html#getHighlightColourBg/1"},{"type":"function","title":"wxCalendarCtrl.getHighlightColourFg/1","doc":"Gets the foreground highlight colour.\n\nOnly in generic `m:wxCalendarCtrl`.\n\nThis method is currently only implemented in generic `m:wxCalendarCtrl` and always\nreturns `wxNullColour` in the native versions.\n\nSee: `setHighlightColours/3`","ref":"wxCalendarCtrl.html#getHighlightColourFg/1"},{"type":"function","title":"wxCalendarCtrl.getHolidayColourBg/1","doc":"Return the background colour currently used for holiday highlighting.\n\nOnly useful with generic `m:wxCalendarCtrl` as native versions currently don't support\nholidays display at all and always return `wxNullColour`.\n\nSee: `setHolidayColours/3`","ref":"wxCalendarCtrl.html#getHolidayColourBg/1"},{"type":"function","title":"wxCalendarCtrl.getHolidayColourFg/1","doc":"Return the foreground colour currently used for holiday highlighting.\n\nOnly useful with generic `m:wxCalendarCtrl` as native versions currently don't support\nholidays display at all and always return `wxNullColour`.\n\nSee: `setHolidayColours/3`","ref":"wxCalendarCtrl.html#getHolidayColourFg/1"},{"type":"function","title":"wxCalendarCtrl.hitTest/2","doc":"Returns one of wxCalendarHitTestResult constants and fills either `date` or `wd` pointer\nwith the corresponding value depending on the hit test code.\n\nNot implemented in wxGTK currently.","ref":"wxCalendarCtrl.html#hitTest/2"},{"type":"function","title":"wxCalendarCtrl.new/0","doc":"Default constructor.","ref":"wxCalendarCtrl.html#new/0"},{"type":"function","title":"wxCalendarCtrl.new/2","doc":"Equivalent to  new(Parent, Id, []) .","ref":"wxCalendarCtrl.html#new/2"},{"type":"function","title":"wxCalendarCtrl.new/3","doc":"Does the same as `create/4` method.","ref":"wxCalendarCtrl.html#new/3"},{"type":"function","title":"wxCalendarCtrl.resetAttr/2","doc":"Clears any attributes associated with the given day (in the range 1...31).\n\nOnly in generic `m:wxCalendarCtrl`.","ref":"wxCalendarCtrl.html#resetAttr/2"},{"type":"function","title":"wxCalendarCtrl.setAttr/3","doc":"Associates the attribute with the specified date (in the range 1...31).\n\nIf the pointer is NULL, the items attribute is cleared. Only in generic `m:wxCalendarCtrl`.","ref":"wxCalendarCtrl.html#setAttr/3"},{"type":"function","title":"wxCalendarCtrl.setDate/2","doc":"Sets the current date.\n\nThe `date` parameter must be valid and in the currently valid range as set by `SetDateRange()`\n(not implemented in wx), otherwise the current date is not changed and the function\nreturns false and, additionally, triggers an assertion failure if the date is invalid.","ref":"wxCalendarCtrl.html#setDate/2"},{"type":"function","title":"wxCalendarCtrl.setHeaderColours/3","doc":"Set the colours used for painting the weekdays at the top of the control.\n\nThis method is currently only implemented in generic `m:wxCalendarCtrl` and does nothing\nin the native versions.","ref":"wxCalendarCtrl.html#setHeaderColours/3"},{"type":"function","title":"wxCalendarCtrl.setHighlightColours/3","doc":"Set the colours to be used for highlighting the currently selected date.\n\nThis method is currently only implemented in generic `m:wxCalendarCtrl` and does nothing\nin the native versions.","ref":"wxCalendarCtrl.html#setHighlightColours/3"},{"type":"function","title":"wxCalendarCtrl.setHoliday/2","doc":"Marks the specified day as being a holiday in the current month.\n\nThis method is only implemented in the generic version of the control and does nothing in\nthe native ones.","ref":"wxCalendarCtrl.html#setHoliday/2"},{"type":"function","title":"wxCalendarCtrl.setHolidayColours/3","doc":"Sets the colours to be used for the holidays highlighting.\n\nThis method is only implemented in the generic version of the control and does nothing in\nthe native ones. It should also only be called if the window style includes `wxCAL_SHOW_HOLIDAYS`\nflag or `enableHolidayDisplay/2` had been called.","ref":"wxCalendarCtrl.html#setHolidayColours/3"},{"type":"type","title":"wxCalendarCtrl.wxCalendarCtrl/0","doc":"","ref":"wxCalendarCtrl.html#t:wxCalendarCtrl/0"},{"type":"module","title":"wxCalendarDateAttr","doc":"`m:wxCalendarDateAttr` is a custom attributes for a calendar date.\n\nThe objects of this class are used with `m:wxCalendarCtrl`.\n\nSee: `m:wxCalendarCtrl`\n\nwxWidgets docs: [wxCalendarDateAttr](https://docs.wxwidgets.org/3.2/classwx_calendar_date_attr.html)","ref":"wxCalendarDateAttr.html"},{"type":"function","title":"wxCalendarDateAttr.destroy/1","doc":"Destroys the object","ref":"wxCalendarDateAttr.html#destroy/1"},{"type":"function","title":"wxCalendarDateAttr.getBackgroundColour/1","doc":"Returns the background colour set for the calendar date.","ref":"wxCalendarDateAttr.html#getBackgroundColour/1"},{"type":"function","title":"wxCalendarDateAttr.getBorder/1","doc":"Returns the border set for the calendar date.","ref":"wxCalendarDateAttr.html#getBorder/1"},{"type":"function","title":"wxCalendarDateAttr.getBorderColour/1","doc":"Returns the border colour set for the calendar date.","ref":"wxCalendarDateAttr.html#getBorderColour/1"},{"type":"function","title":"wxCalendarDateAttr.getFont/1","doc":"Returns the font set for the calendar date.","ref":"wxCalendarDateAttr.html#getFont/1"},{"type":"function","title":"wxCalendarDateAttr.getTextColour/1","doc":"Returns the text colour set for the calendar date.","ref":"wxCalendarDateAttr.html#getTextColour/1"},{"type":"function","title":"wxCalendarDateAttr.hasBackgroundColour/1","doc":"Returns true if a non-default text background colour is set.","ref":"wxCalendarDateAttr.html#hasBackgroundColour/1"},{"type":"function","title":"wxCalendarDateAttr.hasBorder/1","doc":"Returns true if a non-default (i.e. any) border is set.","ref":"wxCalendarDateAttr.html#hasBorder/1"},{"type":"function","title":"wxCalendarDateAttr.hasBorderColour/1","doc":"Returns true if a non-default border colour is set.","ref":"wxCalendarDateAttr.html#hasBorderColour/1"},{"type":"function","title":"wxCalendarDateAttr.hasFont/1","doc":"Returns true if a non-default font is set.","ref":"wxCalendarDateAttr.html#hasFont/1"},{"type":"function","title":"wxCalendarDateAttr.hasTextColour/1","doc":"Returns true if a non-default text foreground colour is set.","ref":"wxCalendarDateAttr.html#hasTextColour/1"},{"type":"function","title":"wxCalendarDateAttr.isHoliday/1","doc":"Returns true if this calendar day is displayed as a holiday.","ref":"wxCalendarDateAttr.html#isHoliday/1"},{"type":"function","title":"wxCalendarDateAttr.new/0","doc":"Equivalent to  new([]) .","ref":"wxCalendarDateAttr.html#new/0"},{"type":"function","title":"wxCalendarDateAttr.new/1","doc":"Constructor for specifying all `m:wxCalendarDateAttr` properties.","ref":"wxCalendarDateAttr.html#new/1"},{"type":"function","title":"wxCalendarDateAttr.new/2","doc":"Constructor using default properties except the given border.","ref":"wxCalendarDateAttr.html#new/2"},{"type":"function","title":"wxCalendarDateAttr.setBackgroundColour/2","doc":"Sets the text background colour to use.","ref":"wxCalendarDateAttr.html#setBackgroundColour/2"},{"type":"function","title":"wxCalendarDateAttr.setBorder/2","doc":"Sets the border to use.","ref":"wxCalendarDateAttr.html#setBorder/2"},{"type":"function","title":"wxCalendarDateAttr.setBorderColour/2","doc":"Sets the border colour to use.","ref":"wxCalendarDateAttr.html#setBorderColour/2"},{"type":"function","title":"wxCalendarDateAttr.setFont/2","doc":"Sets the font to use.","ref":"wxCalendarDateAttr.html#setFont/2"},{"type":"function","title":"wxCalendarDateAttr.setHoliday/2","doc":"If `holiday` is true, this calendar day will be displayed as a holiday.","ref":"wxCalendarDateAttr.html#setHoliday/2"},{"type":"function","title":"wxCalendarDateAttr.setTextColour/2","doc":"Sets the text (foreground) colour to use.","ref":"wxCalendarDateAttr.html#setTextColour/2"},{"type":"type","title":"wxCalendarDateAttr.wxCalendarDateAttr/0","doc":"","ref":"wxCalendarDateAttr.html#t:wxCalendarDateAttr/0"},{"type":"module","title":"wxCalendarEvent","doc":"The `m:wxCalendarEvent` class is used together with `m:wxCalendarCtrl`.\n\nSee: `m:wxCalendarCtrl`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxDateEvent`\n\n* `m:wxCommandEvent`\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxCalendarEvent](https://docs.wxwidgets.org/3.2/classwx_calendar_event.html)","ref":"wxCalendarEvent.html"},{"type":"function","title":"wxCalendarEvent.getDate/1","doc":"Returns the date.","ref":"wxCalendarEvent.html#getDate/1"},{"type":"function","title":"wxCalendarEvent.getWeekDay/1","doc":"Returns the week day on which the user clicked in `EVT\\_CALENDAR\\_WEEKDAY\\_CLICKED`\nhandler.\n\nIt doesn't make sense to call this function in other handlers.","ref":"wxCalendarEvent.html#getWeekDay/1"},{"type":"type","title":"wxCalendarEvent.wxCalendar/0","doc":"","ref":"wxCalendarEvent.html#t:wxCalendar/0"},{"type":"type","title":"wxCalendarEvent.wxCalendarEvent/0","doc":"","ref":"wxCalendarEvent.html#t:wxCalendarEvent/0"},{"type":"type","title":"wxCalendarEvent.wxCalendarEventType/0","doc":"","ref":"wxCalendarEvent.html#t:wxCalendarEventType/0"},{"type":"module","title":"wxCaret","doc":"A caret is a blinking cursor showing the position where the typed text will appear.\n\nText controls usually have their own caret but `m:wxCaret` provides a way to use a caret\nin other windows.\n\nCurrently, the caret appears as a rectangle of the given size. In the future, it will be\npossible to specify a bitmap to be used for the caret shape.\n\nA caret is always associated with a window and the current caret can be retrieved using `wxWindow:getCaret/1`.\nThe same caret can't be reused in two different windows.\n\nwxWidgets docs: [wxCaret](https://docs.wxwidgets.org/3.2/classwx_caret.html)","ref":"wxCaret.html"},{"type":"function","title":"wxCaret.create/3","doc":"","ref":"wxCaret.html#create/3"},{"type":"function","title":"wxCaret.create/4","doc":"Creates a caret with the given size (in pixels) and associates it with the `window` (same\nas the equivalent constructors).","ref":"wxCaret.html#create/4"},{"type":"function","title":"wxCaret.destroy/1","doc":"Destroys the object","ref":"wxCaret.html#destroy/1"},{"type":"function","title":"wxCaret.getBlinkTime/0","doc":"Returns the blink time which is measured in milliseconds and is the time elapsed between\n2 inversions of the caret (blink time of the caret is the same for all carets, so this\nfunctions is static).","ref":"wxCaret.html#getBlinkTime/0"},{"type":"function","title":"wxCaret.getPosition/1","doc":"","ref":"wxCaret.html#getPosition/1"},{"type":"function","title":"wxCaret.getSize/1","doc":"","ref":"wxCaret.html#getSize/1"},{"type":"function","title":"wxCaret.getWindow/1","doc":"Get the window the caret is associated with.","ref":"wxCaret.html#getWindow/1"},{"type":"function","title":"wxCaret.hide/1","doc":"Hides the caret, same as Show(false).","ref":"wxCaret.html#hide/1"},{"type":"function","title":"wxCaret.isOk/1","doc":"Returns true if the caret was created successfully.","ref":"wxCaret.html#isOk/1"},{"type":"function","title":"wxCaret.isVisible/1","doc":"Returns true if the caret is visible and false if it is permanently hidden (if it is\nblinking and not shown currently but will be after the next blink, this method still\nreturns true).","ref":"wxCaret.html#isVisible/1"},{"type":"function","title":"wxCaret.move/2","doc":"","ref":"wxCaret.html#move/2"},{"type":"function","title":"wxCaret.move/3","doc":"Move the caret to given position (in logical coordinates).","ref":"wxCaret.html#move/3"},{"type":"function","title":"wxCaret.new/2","doc":"","ref":"wxCaret.html#new/2"},{"type":"function","title":"wxCaret.new/3","doc":"Creates a caret with the given size (in pixels) and associates it with the `window`.","ref":"wxCaret.html#new/3"},{"type":"function","title":"wxCaret.setBlinkTime/1","doc":"Sets the blink time for all the carets.\n\nWarning:\n\nUnder Windows, this function will change the blink time for all carets permanently (until\nthe next time it is called), even for carets in other applications.\n\nSee: `getBlinkTime/0`","ref":"wxCaret.html#setBlinkTime/1"},{"type":"function","title":"wxCaret.setSize/2","doc":"","ref":"wxCaret.html#setSize/2"},{"type":"function","title":"wxCaret.setSize/3","doc":"Changes the size of the caret.","ref":"wxCaret.html#setSize/3"},{"type":"function","title":"wxCaret.show/1","doc":"Equivalent to  show(This, []) .","ref":"wxCaret.html#show/1"},{"type":"function","title":"wxCaret.show/2","doc":"Shows or hides the caret.\n\nNotice that if the caret was hidden N times, it must be shown N times as well to reappear\non the screen.","ref":"wxCaret.html#show/2"},{"type":"type","title":"wxCaret.wxCaret/0","doc":"","ref":"wxCaret.html#t:wxCaret/0"},{"type":"module","title":"wxCheckBox","doc":"A checkbox is a labelled box which by default is either on (checkmark is visible) or off\n(no checkmark).\n\nOptionally (when the wxCHK_3STATE style flag is set) it can have a third state, called\nthe mixed or undetermined state. Often this is used as a \"Does Not Apply\" state.","ref":"wxCheckBox.html"},{"type":"module","title":"Styles - wxCheckBox","doc":"This class supports the following styles:\n\n* wxCHK_2STATE: Create a 2-state checkbox. This is the default.\n\n* wxCHK_3STATE: Create a 3-state checkbox. Not implemented in wxGTK1.\n\n* wxCHK_ALLOW_3RD_STATE_FOR_USER: By default a user can't set a 3-state checkbox to the\nthird state. It can only be done from code. Using this flags allows the user to set the\ncheckbox to the third state by clicking.\n\n* wxALIGN_RIGHT: Makes the text appear on the left of the checkbox.\n\nSee:\n* `m:wxRadioButton`\n\n* `m:wxCommandEvent`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxCheckBox](https://docs.wxwidgets.org/3.2/classwx_check_box.html)","ref":"wxCheckBox.html#module-styles"},{"type":"module","title":"Events - wxCheckBox","doc":"Event types emitted from this class:\n\n* [`command_checkbox_clicked`](`m:wxCommandEvent`)","ref":"wxCheckBox.html#module-events"},{"type":"function","title":"wxCheckBox.create/4","doc":"Equivalent to  create(This, Parent, Id, Label, []) .","ref":"wxCheckBox.html#create/4"},{"type":"function","title":"wxCheckBox.create/5","doc":"Creates the checkbox for two-step construction.\n\nSee `new/4` for details.","ref":"wxCheckBox.html#create/5"},{"type":"function","title":"wxCheckBox.destroy/1","doc":"Destroys the object","ref":"wxCheckBox.html#destroy/1"},{"type":"function","title":"wxCheckBox.get3StateValue/1","doc":"Gets the state of a 3-state checkbox.\n\nAsserts when the function is used with a 2-state checkbox.","ref":"wxCheckBox.html#get3StateValue/1"},{"type":"function","title":"wxCheckBox.getValue/1","doc":"Gets the state of a 2-state checkbox.\n\nReturn: Returns true if it is checked, false otherwise.","ref":"wxCheckBox.html#getValue/1"},{"type":"function","title":"wxCheckBox.is3rdStateAllowedForUser/1","doc":"Returns whether or not the user can set the checkbox to the third state.\n\nReturn: true if the user can set the third state of this checkbox, false if it can only\nbe set programmatically or if it's a 2-state checkbox.","ref":"wxCheckBox.html#is3rdStateAllowedForUser/1"},{"type":"function","title":"wxCheckBox.is3State/1","doc":"Returns whether or not the checkbox is a 3-state checkbox.\n\nReturn: true if this checkbox is a 3-state checkbox, false if it's a 2-state checkbox.","ref":"wxCheckBox.html#is3State/1"},{"type":"function","title":"wxCheckBox.isChecked/1","doc":"This is just a maybe more readable synonym for `getValue/1`: just as the latter, it\nreturns true if the checkbox is checked and false otherwise.","ref":"wxCheckBox.html#isChecked/1"},{"type":"function","title":"wxCheckBox.new/0","doc":"Default constructor.\n\nSee: `create/5`","ref":"wxCheckBox.html#new/0"},{"type":"function","title":"wxCheckBox.new/3","doc":"Equivalent to  new(Parent, Id, Label, []) .","ref":"wxCheckBox.html#new/3"},{"type":"function","title":"wxCheckBox.new/4","doc":"Constructor, creating and showing a checkbox.\n\nSee: `create/5`","ref":"wxCheckBox.html#new/4"},{"type":"function","title":"wxCheckBox.set3StateValue/2","doc":"Sets the checkbox to the given state.\n\nThis does not cause a `wxEVT_CHECKBOX` event to get emitted.\n\nAsserts when the checkbox is a 2-state checkbox and setting the state to\nwxCHK_UNDETERMINED.","ref":"wxCheckBox.html#set3StateValue/2"},{"type":"function","title":"wxCheckBox.setValue/2","doc":"Sets the checkbox to the given state.\n\nThis does not cause a `wxEVT_CHECKBOX` event to get emitted.","ref":"wxCheckBox.html#setValue/2"},{"type":"type","title":"wxCheckBox.wxCheckBox/0","doc":"","ref":"wxCheckBox.html#t:wxCheckBox/0"},{"type":"module","title":"wxCheckListBox","doc":"A `m:wxCheckListBox` is like a `m:wxListBox`, but allows items to be checked or\nunchecked.\n\nWhen using this class under Windows wxWidgets must be compiled with wxUSE_OWNER_DRAWN set\nto 1.\n\nSee:\n* `m:wxListBox`\n\n* `m:wxChoice`\n\n* `m:wxComboBox`\n\n* `m:wxListCtrl`\n\n* `m:wxCommandEvent`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxListBox`\n\n* `m:wxControlWithItems`\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxCheckListBox](https://docs.wxwidgets.org/3.2/classwx_check_list_box.html)","ref":"wxCheckListBox.html"},{"type":"module","title":"Events - wxCheckListBox","doc":"Event types emitted from this class:\n\n* [`command_checklistbox_toggled`](`m:wxCommandEvent`)","ref":"wxCheckListBox.html#module-events"},{"type":"function","title":"wxCheckListBox.check/2","doc":"Equivalent to  check(This, Item, []) .","ref":"wxCheckListBox.html#check/2"},{"type":"function","title":"wxCheckListBox.check/3","doc":"Checks the given item.\n\nNote that calling this method does not result in a `wxEVT_CHECKLISTBOX` event being emitted.","ref":"wxCheckListBox.html#check/3"},{"type":"function","title":"wxCheckListBox.destroy/1","doc":"Destroys the object","ref":"wxCheckListBox.html#destroy/1"},{"type":"function","title":"wxCheckListBox.isChecked/2","doc":"Returns true if the given item is checked, false otherwise.","ref":"wxCheckListBox.html#isChecked/2"},{"type":"function","title":"wxCheckListBox.new/0","doc":"Default constructor.","ref":"wxCheckListBox.html#new/0"},{"type":"function","title":"wxCheckListBox.new/2","doc":"Equivalent to  new(Parent, Id, []) .","ref":"wxCheckListBox.html#new/2"},{"type":"function","title":"wxCheckListBox.new/3","doc":"Constructor, creating and showing a list box.","ref":"wxCheckListBox.html#new/3"},{"type":"type","title":"wxCheckListBox.wxCheckListBox/0","doc":"","ref":"wxCheckListBox.html#t:wxCheckListBox/0"},{"type":"module","title":"wxChildFocusEvent","doc":"A child focus event is sent to a (parent-)window when one of its child windows gains\nfocus, so that the window could restore the focus back to its corresponding child if it\nloses it now and regains later.\n\nNotice that child window is the direct child of the window receiving event. Use `wxWindow:findFocus/0` to\nretrieve the window which is actually getting focus.\n\nSee: [Overview events](https://docs.wxwidgets.org/3.2/overview_events.html#overview_events)\n\nThis class is derived, and can use functions, from:\n\n* `m:wxCommandEvent`\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxChildFocusEvent](https://docs.wxwidgets.org/3.2/classwx_child_focus_event.html)","ref":"wxChildFocusEvent.html"},{"type":"module","title":"Events - wxChildFocusEvent","doc":"Use `wxEvtHandler:connect/3` with `wxChildFocusEventType` to subscribe to events of this type.","ref":"wxChildFocusEvent.html#module-events"},{"type":"function","title":"wxChildFocusEvent.getWindow/1","doc":"Returns the direct child which receives the focus, or a (grand-)parent of the control\nreceiving the focus.\n\nTo get the actually focused control use `wxWindow:findFocus/0`.","ref":"wxChildFocusEvent.html#getWindow/1"},{"type":"type","title":"wxChildFocusEvent.wxChildFocus/0","doc":"","ref":"wxChildFocusEvent.html#t:wxChildFocus/0"},{"type":"type","title":"wxChildFocusEvent.wxChildFocusEvent/0","doc":"","ref":"wxChildFocusEvent.html#t:wxChildFocusEvent/0"},{"type":"type","title":"wxChildFocusEvent.wxChildFocusEventType/0","doc":"","ref":"wxChildFocusEvent.html#t:wxChildFocusEventType/0"},{"type":"module","title":"wxChoice","doc":"A choice item is used to select one of a list of strings.\n\nUnlike a `m:wxListBox`, only the selection is visible until the user pulls down the menu\nof choices.","ref":"wxChoice.html"},{"type":"module","title":"Styles - wxChoice","doc":"This class supports the following styles:\n\n* wxCB_SORT: Sorts the entries alphabetically.\n\nSee:\n* `m:wxListBox`\n\n* `m:wxComboBox`\n\n* `m:wxCommandEvent`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxControlWithItems`\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxChoice](https://docs.wxwidgets.org/3.2/classwx_choice.html)","ref":"wxChoice.html#module-styles"},{"type":"module","title":"Events - wxChoice","doc":"Event types emitted from this class:\n\n* [`command_choice_selected`](`m:wxCommandEvent`)","ref":"wxChoice.html#module-events"},{"type":"function","title":"wxChoice.create/6","doc":"Equivalent to  create(This, Parent, Id, Pos, Size, Choices, []) .","ref":"wxChoice.html#create/6"},{"type":"function","title":"wxChoice.create/7","doc":"","ref":"wxChoice.html#create/7"},{"type":"function","title":"wxChoice.delete/2","doc":"Deletes an item from the control.\n\nThe client data associated with the item will be also deleted if it is owned by the\ncontrol. Note that it is an error (signalled by an assert failure in debug builds) to\nremove an item with the index negative or greater or equal than the number of items in the control.\n\nIf there is a currently selected item below the item being deleted, i.e. if `wxControlWithItems:getSelection/1` returns a\nvalid index greater than or equal to `n`, the selection is invalidated when this function\nis called. However if the selected item appears before the item being deleted, the\nselection is preserved unchanged.\n\nSee: `wxControlWithItems:clear/1`","ref":"wxChoice.html#delete/2"},{"type":"function","title":"wxChoice.destroy/1","doc":"Destroys the object","ref":"wxChoice.html#destroy/1"},{"type":"function","title":"wxChoice.getColumns/1","doc":"Gets the number of columns in this choice item.\n\nRemark: This is implemented for GTK and Motif only and always returns 1 for the other\nplatforms.","ref":"wxChoice.html#getColumns/1"},{"type":"function","title":"wxChoice.new/0","doc":"Default constructor.\n\nSee: `create/7`","ref":"wxChoice.html#new/0"},{"type":"function","title":"wxChoice.new/2","doc":"Equivalent to  new(Parent, Id, []) .","ref":"wxChoice.html#new/2"},{"type":"function","title":"wxChoice.new/3","doc":"Constructor, creating and showing a choice.\n\nSee: `create/7`","ref":"wxChoice.html#new/3"},{"type":"function","title":"wxChoice.setColumns/1","doc":"Equivalent to  setColumns(This, []) .","ref":"wxChoice.html#setColumns/1"},{"type":"function","title":"wxChoice.setColumns/2","doc":"Sets the number of columns in this choice item.\n\nRemark: This is implemented for GTK and Motif only and doesn’t do anything under other\nplatforms.","ref":"wxChoice.html#setColumns/2"},{"type":"type","title":"wxChoice.wxChoice/0","doc":"","ref":"wxChoice.html#t:wxChoice/0"},{"type":"module","title":"wxChoicebook","doc":"`m:wxChoicebook` is a class similar to `m:wxNotebook`, but uses a `m:wxChoice` control to\nshow the labels instead of the tabs.\n\nFor usage documentation of this class, please refer to the base abstract class\nwxBookCtrl. You can also use the page_samples_notebook to see `m:wxChoicebook` in action.\n\n`m:wxChoicebook` allows the use of wxBookCtrlBase::GetControlSizer(), allowing a program\nto add other controls next to the choice control. This is particularly useful when screen\nspace is restricted, as it often is when `m:wxChoicebook` is being employed.","ref":"wxChoicebook.html"},{"type":"module","title":"Styles - wxChoicebook","doc":"This class supports the following styles:\n\n* wxCHB_DEFAULT: Choose the default location for the labels depending on the current\nplatform (but currently it's the same everywhere, namely wxCHB_TOP).\n\n* wxCHB_TOP: Place labels above the page area.\n\n* wxCHB_LEFT: Place labels on the left side.\n\n* wxCHB_RIGHT: Place labels on the right side.\n\n* wxCHB_BOTTOM: Place labels below the page area.\n\nSee:\n* [Overview bookctrl](https://docs.wxwidgets.org/3.2/overview_bookctrl.html#overview_bookctrl)\n\n* `m:wxNotebook`\n\n* [Examples](https://docs.wxwidgets.org/3.2/page_samples.html#page_samples_notebook)\n\nThis class is derived, and can use functions, from:\n\n* `m:wxBookCtrlBase`\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxChoicebook](https://docs.wxwidgets.org/3.2/classwx_choicebook.html)","ref":"wxChoicebook.html#module-styles"},{"type":"module","title":"Events - wxChoicebook","doc":"Event types emitted from this class:\n\n* [`choicebook_page_changed`](`m:wxBookCtrlEvent`)\n\n* [`choicebook_page_changing`](`m:wxBookCtrlEvent`)","ref":"wxChoicebook.html#module-events"},{"type":"function","title":"wxChoicebook.addPage/3","doc":"Equivalent to  addPage(This, Page, Text, []) .","ref":"wxChoicebook.html#addPage/3"},{"type":"function","title":"wxChoicebook.addPage/4","doc":"Adds a new page.\n\nThe page must have the book control itself as the parent and must not have been added to\nthis control previously.\n\nThe call to this function will generate the page changing and page changed events if `select`\nis true, but not when inserting the very first page (as there is no previous page\nselection to switch from in this case and so it wouldn't make sense to e.g. veto such event).\n\nReturn: true if successful, false otherwise.\n\nRemark: Do not delete the page, it will be deleted by the book control.\n\nSee: `insertPage/5`","ref":"wxChoicebook.html#addPage/4"},{"type":"function","title":"wxChoicebook.advanceSelection/1","doc":"Equivalent to  advanceSelection(This, []) .","ref":"wxChoicebook.html#advanceSelection/1"},{"type":"function","title":"wxChoicebook.advanceSelection/2","doc":"Cycles through the tabs.\n\nThe call to this function generates the page changing events.","ref":"wxChoicebook.html#advanceSelection/2"},{"type":"function","title":"wxChoicebook.assignImageList/2","doc":"Sets the image list for the page control and takes ownership of the list.\n\nSee:\n* `m:wxImageList`\n\n* `setImageList/2`","ref":"wxChoicebook.html#assignImageList/2"},{"type":"function","title":"wxChoicebook.changeSelection/2","doc":"Changes the selection to the given page, returning the previous selection.\n\nThis function behaves as `setSelection/2` but does `not` generate the page changing events.\n\nSee overview_events_prog for more information.","ref":"wxChoicebook.html#changeSelection/2"},{"type":"function","title":"wxChoicebook.create/3","doc":"Equivalent to  create(This, Parent, Id, []) .","ref":"wxChoicebook.html#create/3"},{"type":"function","title":"wxChoicebook.create/4","doc":"Create the choicebook control that has already been constructed with the default\nconstructor.","ref":"wxChoicebook.html#create/4"},{"type":"function","title":"wxChoicebook.deleteAllPages/1","doc":"Deletes all pages.","ref":"wxChoicebook.html#deleteAllPages/1"},{"type":"function","title":"wxChoicebook.destroy/1","doc":"Destroys the object","ref":"wxChoicebook.html#destroy/1"},{"type":"function","title":"wxChoicebook.getCurrentPage/1","doc":"Returns the currently selected page or NULL.","ref":"wxChoicebook.html#getCurrentPage/1"},{"type":"function","title":"wxChoicebook.getImageList/1","doc":"Returns the associated image list, may be NULL.\n\nSee:\n* `m:wxImageList`\n\n* `setImageList/2`","ref":"wxChoicebook.html#getImageList/1"},{"type":"function","title":"wxChoicebook.getPage/2","doc":"Returns the window at the given page position.","ref":"wxChoicebook.html#getPage/2"},{"type":"function","title":"wxChoicebook.getPageCount/1","doc":"Returns the number of pages in the control.","ref":"wxChoicebook.html#getPageCount/1"},{"type":"function","title":"wxChoicebook.getPageImage/2","doc":"Returns the image index for the given page.","ref":"wxChoicebook.html#getPageImage/2"},{"type":"function","title":"wxChoicebook.getPageText/2","doc":"Returns the string for the given page.","ref":"wxChoicebook.html#getPageText/2"},{"type":"function","title":"wxChoicebook.getSelection/1","doc":"Returns the currently selected page, or `wxNOT\\_FOUND` if none was selected.\n\nNote that this method may return either the previously or newly selected page when called\nfrom the `EVT_BOOKCTRL_PAGE_CHANGED` handler depending on the platform and so `wxBookCtrlEvent:getSelection/1` should be\nused instead in this case.","ref":"wxChoicebook.html#getSelection/1"},{"type":"function","title":"wxChoicebook.hitTest/2","doc":"Returns the index of the tab at the specified position or `wxNOT\\_FOUND` if none.\n\nIf `flags` parameter is non-NULL, the position of the point inside the tab is returned as well.\n\nReturn: Returns the zero-based tab index or `wxNOT_FOUND` if there is no tab at the\nspecified position.","ref":"wxChoicebook.html#hitTest/2"},{"type":"function","title":"wxChoicebook.insertPage/4","doc":"Equivalent to  insertPage(This, Index, Page, Text, []) .","ref":"wxChoicebook.html#insertPage/4"},{"type":"function","title":"wxChoicebook.insertPage/5","doc":"Inserts a new page at the specified position.\n\nReturn: true if successful, false otherwise.\n\nRemark: Do not delete the page, it will be deleted by the book control.\n\nSee: `addPage/4`","ref":"wxChoicebook.html#insertPage/5"},{"type":"function","title":"wxChoicebook.new/0","doc":"Constructs a choicebook control.","ref":"wxChoicebook.html#new/0"},{"type":"function","title":"wxChoicebook.new/2","doc":"Equivalent to  new(Parent, Id, []) .","ref":"wxChoicebook.html#new/2"},{"type":"function","title":"wxChoicebook.new/3","doc":"","ref":"wxChoicebook.html#new/3"},{"type":"function","title":"wxChoicebook.setImageList/2","doc":"Sets the image list to use.\n\nIt does not take ownership of the image list, you must delete it yourself.\n\nSee:\n* `m:wxImageList`\n\n* `assignImageList/2`","ref":"wxChoicebook.html#setImageList/2"},{"type":"function","title":"wxChoicebook.setPageImage/3","doc":"Sets the image index for the given page.\n\n`image` is an index into the image list which was set with `setImageList/2`.","ref":"wxChoicebook.html#setPageImage/3"},{"type":"function","title":"wxChoicebook.setPageSize/2","doc":"Sets the width and height of the pages.\n\nNote: This method is currently not implemented for wxGTK.","ref":"wxChoicebook.html#setPageSize/2"},{"type":"function","title":"wxChoicebook.setPageText/3","doc":"Sets the text for the given page.","ref":"wxChoicebook.html#setPageText/3"},{"type":"function","title":"wxChoicebook.setSelection/2","doc":"Sets the selection to the given page, returning the previous selection.\n\nNotice that the call to this function generates the page changing events, use the `changeSelection/2`\nfunction if you don't want these events to be generated.\n\nSee: `getSelection/1`","ref":"wxChoicebook.html#setSelection/2"},{"type":"type","title":"wxChoicebook.wxChoicebook/0","doc":"","ref":"wxChoicebook.html#t:wxChoicebook/0"},{"type":"module","title":"wxClientDC","doc":"`m:wxClientDC` is primarily useful for obtaining information about the window from\noutside EVT\\_PAINT() handler.\n\nTypical use of this class is to obtain the extent of some text string in order to\nallocate enough size for a window, e.g.\n\nNote: While `m:wxClientDC` may also be used for drawing on the client area of a window\nfrom outside an EVT_PAINT() handler in some ports, this does `not` work on all platforms\n(neither wxOSX nor wxGTK with GTK 3 Wayland backend support this, so drawing using `m:wxClientDC`\nsimply doesn't have any effect there) and the only portable way of drawing is via `m:wxPaintDC`.\nTo redraw a small part of the window, use `wxWindow:refreshRect/3` to invalidate just this part and check `wxWindow:getUpdateRegion/1` in the\npaint event handler to redraw this part only.\n\n`m:wxClientDC` objects should normally be constructed as temporary stack objects, i.e.\ndon't store a `m:wxClientDC` object.\n\nA `m:wxClientDC` object is initialized to use the same font and colours as the window it\nis associated with.\n\nSee:\n* `m:wxDC`\n\n* `m:wxMemoryDC`\n\n* `m:wxPaintDC`\n\n* `m:wxWindowDC`\n\n* `m:wxScreenDC`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxWindowDC`\n\n* `m:wxDC`\n\nwxWidgets docs: [wxClientDC](https://docs.wxwidgets.org/3.2/classwx_client_d_c.html)","ref":"wxClientDC.html"},{"type":"function","title":"wxClientDC.destroy/1","doc":"Destroys the object","ref":"wxClientDC.html#destroy/1"},{"type":"function","title":"wxClientDC.new/1","doc":"Constructor.\n\nPass a pointer to the window on which you wish to paint.","ref":"wxClientDC.html#new/1"},{"type":"type","title":"wxClientDC.wxClientDC/0","doc":"","ref":"wxClientDC.html#t:wxClientDC/0"},{"type":"module","title":"wxClipboard","doc":"A class for manipulating the clipboard.\n\nTo use the clipboard, you call member functions of the global ?wxTheClipboard object.\n\nSee the overview_dataobject for further information.\n\nCall `open/1` to get ownership of the clipboard. If this operation returns true, you now own the\nclipboard. Call `setData/2` to put data on the clipboard, or `getData/2` to retrieve data from the clipboard.\nCall `close/1` to close the clipboard and relinquish ownership. You should keep the clipboard open\nonly momentarily.\n\nFor example:\n\nNote: On GTK, the clipboard behavior can vary depending on the configuration of the\nend-user's machine. In order for the clipboard data to persist after the window closes, a\nclipboard manager must be installed. Some clipboard managers will automatically flush the\nclipboard after each new piece of data is added, while others will not. The @Flush()\nfunction will force the clipboard manager to flush the data.\n\nSee:\n* [Overview dnd](https://docs.wxwidgets.org/3.2/overview_dnd.html#overview_dnd)\n\n* [Overview dataobject](https://docs.wxwidgets.org/3.2/overview_dataobject.html#overview_dataobject)\n\n* `m:wxDataObject`\n\nwxWidgets docs: [wxClipboard](https://docs.wxwidgets.org/3.2/classwx_clipboard.html)","ref":"wxClipboard.html"},{"type":"function","title":"wxClipboard.addData/2","doc":"Call this function to add the data object to the clipboard.\n\nThis is an obsolete synonym for `setData/2`.","ref":"wxClipboard.html#addData/2"},{"type":"function","title":"wxClipboard.clear/1","doc":"Clears the global clipboard object and the system's clipboard if possible.","ref":"wxClipboard.html#clear/1"},{"type":"function","title":"wxClipboard.close/1","doc":"Call this function to close the clipboard, having opened it with `open/1`.","ref":"wxClipboard.html#close/1"},{"type":"function","title":"wxClipboard.destroy/1","doc":"Destroys the object","ref":"wxClipboard.html#destroy/1"},{"type":"function","title":"wxClipboard.flush/1","doc":"Flushes the clipboard: this means that the data which is currently on clipboard will stay\navailable even after the application exits (possibly eating memory), otherwise the\nclipboard will be emptied on exit.\n\nCurrently this method is implemented in MSW and GTK and always returns false otherwise.\n\nNote: On GTK, only the non-primary selection can be flushed. Calling this function when\nthe clipboard is using the primary selection will return false and not make any data\navailable after the program exits.\n\nReturn: false if the operation is unsuccessful for any reason.","ref":"wxClipboard.html#flush/1"},{"type":"function","title":"wxClipboard.get/0","doc":"Returns the global instance (wxTheClipboard) of the clipboard object.","ref":"wxClipboard.html#get/0"},{"type":"function","title":"wxClipboard.getData/2","doc":"Call this function to fill `data` with data on the clipboard, if available in the\nrequired format.\n\nReturns true on success.","ref":"wxClipboard.html#getData/2"},{"type":"function","title":"wxClipboard.isOpened/1","doc":"Returns true if the clipboard has been opened.","ref":"wxClipboard.html#isOpened/1"},{"type":"function","title":"wxClipboard.isSupported/2","doc":"Returns true if there is data which matches the data format of the given data object\ncurrently `available` on the clipboard.","ref":"wxClipboard.html#isSupported/2"},{"type":"function","title":"wxClipboard.new/0","doc":"Default constructor.","ref":"wxClipboard.html#new/0"},{"type":"function","title":"wxClipboard.open/1","doc":"Call this function to open the clipboard before calling `setData/2` and `getData/2`.\n\nCall `close/1` when you have finished with the clipboard. You should keep the clipboard open for\nonly a very short time.\n\nReturn: true on success. This should be tested (as in the sample shown above).","ref":"wxClipboard.html#open/1"},{"type":"function","title":"wxClipboard.setData/2","doc":"Call this function to set the data object to the clipboard.\n\nThe new data object replaces any previously set one, so if the application wants to\nprovide clipboard data in several different formats, it must use a composite data object\nsupporting all of the formats instead of calling this function several times with\ndifferent data objects as this would only leave data from the last one in the clipboard.\n\nAfter this function has been called, the clipboard owns the data, so do not delete the\ndata explicitly.","ref":"wxClipboard.html#setData/2"},{"type":"function","title":"wxClipboard.usePrimarySelection/1","doc":"Equivalent to  usePrimarySelection(This, []) .","ref":"wxClipboard.html#usePrimarySelection/1"},{"type":"function","title":"wxClipboard.usePrimarySelection/2","doc":"On platforms supporting it (all X11-based ports), `m:wxClipboard` uses the CLIPBOARD X11\nselection by default.\n\nWhen this function is called with true, all subsequent clipboard operations will use\nPRIMARY selection until this function is called again with false.\n\nOn the other platforms, there is no PRIMARY selection and so all clipboard operations\nwill fail. This allows implementing the standard X11 handling of the clipboard which\nconsists in copying data to the CLIPBOARD selection only when the user explicitly requests\nit (i.e. by selecting the \"Copy\" menu command) but putting the currently selected text\ninto the PRIMARY selection automatically, without overwriting the normal clipboard\ncontents with the currently selected text on the other platforms.","ref":"wxClipboard.html#usePrimarySelection/2"},{"type":"type","title":"wxClipboard.wxClipboard/0","doc":"","ref":"wxClipboard.html#t:wxClipboard/0"},{"type":"module","title":"wxClipboardTextEvent","doc":"This class represents the events generated by a control (typically a `m:wxTextCtrl` but\nother windows can generate these events as well) when its content gets copied or cut to,\nor pasted from the clipboard.\n\nThere are three types of corresponding events `wxEVT_TEXT_COPY`, `wxEVT_TEXT_CUT` and `wxEVT_TEXT_PASTE`.\n\nIf any of these events is processed (without being skipped) by an event handler, the\ncorresponding operation doesn't take place which allows preventing the text from being\ncopied from or pasted to a control. It is also possible to examine the clipboard contents\nin the PASTE event handler and transform it in some way before inserting in a control -\nfor example, changing its case or removing invalid characters.\n\nFinally notice that a CUT event is always preceded by the COPY event which makes it\npossible to only process the latter if it doesn't matter if the text was copied or cut.\n\nNote: These events are currently only generated by `m:wxTextCtrl` in wxGTK and wxOSX but\nare also generated by `m:wxComboBox` without wxCB_READONLY style in wxMSW.\n\nSee: `m:wxClipboard`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxCommandEvent`\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxClipboardTextEvent](https://docs.wxwidgets.org/3.2/classwx_clipboard_text_event.html)","ref":"wxClipboardTextEvent.html"},{"type":"module","title":"Events - wxClipboardTextEvent","doc":"Use `wxEvtHandler:connect/3` with `wxClipboardTextEventType` to subscribe to events of this type.","ref":"wxClipboardTextEvent.html#module-events"},{"type":"type","title":"wxClipboardTextEvent.wxClipboardText/0","doc":"","ref":"wxClipboardTextEvent.html#t:wxClipboardText/0"},{"type":"type","title":"wxClipboardTextEvent.wxClipboardTextEvent/0","doc":"","ref":"wxClipboardTextEvent.html#t:wxClipboardTextEvent/0"},{"type":"type","title":"wxClipboardTextEvent.wxClipboardTextEventType/0","doc":"","ref":"wxClipboardTextEvent.html#t:wxClipboardTextEventType/0"},{"type":"module","title":"wxCloseEvent","doc":"This event class contains information about window and session close events.\n\nThe handler function for EVT_CLOSE is called when the user has tried to close a a frame\nor dialog box using the window manager (X) or system menu (Windows). It can also be\ninvoked by the application itself programmatically, for example by calling the `wxWindow:close/2` function.\n\nYou should check whether the application is forcing the deletion of the window using `canVeto/1`. If\nthis is false, you `must` destroy the window using `wxWindow:'Destroy'/1`.\n\nIf the return value is true, it is up to you whether you respond by destroying the window.\n\nIf you don't destroy the window, you should call `veto/2` to let the calling code know that you\ndid not destroy the window. This allows the `wxWindow:close/2` function to return true or false depending on\nwhether the close instruction was honoured or not.\n\nExample of a `m:wxCloseEvent` handler:\n\nThe EVT_END_SESSION event is slightly different as it is sent by the system when the user\nsession is ending (e.g. because of log out or shutdown) and so all windows are being\nforcefully closed. At least under MSW, after the handler for this event is executed the\nprogram is simply killed by the system. Because of this, the default handler for this\nevent provided by wxWidgets calls all the usual cleanup code (including `wxApp::OnExit()`\n(not implemented in wx)) so that it could still be executed and exit()s the process\nitself, without waiting for being killed. If this behaviour is for some reason\nundesirable, make sure that you define a handler for this event in your wxApp-derived\nclass and do not call `event.Skip()` in it (but be aware that the system will still kill\nyour application).\n\nSee:\n* `wxWindow:close/2`\n\n* [Overview windowdeletion](https://docs.wxwidgets.org/3.2/overview_windowdeletion.html#overview_windowdeletion)\n\nThis class is derived, and can use functions, from:\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxCloseEvent](https://docs.wxwidgets.org/3.2/classwx_close_event.html)","ref":"wxCloseEvent.html"},{"type":"module","title":"Events - wxCloseEvent","doc":"Use `wxEvtHandler:connect/3` with `wxCloseEventType` to subscribe to events of this type.","ref":"wxCloseEvent.html#module-events"},{"type":"function","title":"wxCloseEvent.canVeto/1","doc":"Returns true if you can veto a system shutdown or a window close event.\n\nVetoing a window close event is not possible if the calling code wishes to force the\napplication to exit, and so this function must be called to check this.","ref":"wxCloseEvent.html#canVeto/1"},{"type":"function","title":"wxCloseEvent.getLoggingOff/1","doc":"Returns true if the user is just logging off or false if the system is shutting down.\n\nThis method can only be called for end session and query end session events, it doesn't\nmake sense for close window event.","ref":"wxCloseEvent.html#getLoggingOff/1"},{"type":"function","title":"wxCloseEvent.setCanVeto/2","doc":"Sets the 'can veto' flag.","ref":"wxCloseEvent.html#setCanVeto/2"},{"type":"function","title":"wxCloseEvent.setLoggingOff/2","doc":"Sets the 'logging off' flag.","ref":"wxCloseEvent.html#setLoggingOff/2"},{"type":"function","title":"wxCloseEvent.veto/1","doc":"Equivalent to  veto(This, []) .","ref":"wxCloseEvent.html#veto/1"},{"type":"function","title":"wxCloseEvent.veto/2","doc":"Call this from your event handler to veto a system shutdown or to signal to the calling\napplication that a window close did not happen.\n\nYou can only veto a shutdown if `canVeto/1` returns true.","ref":"wxCloseEvent.html#veto/2"},{"type":"type","title":"wxCloseEvent.wxClose/0","doc":"","ref":"wxCloseEvent.html#t:wxClose/0"},{"type":"type","title":"wxCloseEvent.wxCloseEvent/0","doc":"","ref":"wxCloseEvent.html#t:wxCloseEvent/0"},{"type":"type","title":"wxCloseEvent.wxCloseEventType/0","doc":"","ref":"wxCloseEvent.html#t:wxCloseEventType/0"},{"type":"module","title":"wxColourData","doc":"This class holds a variety of information related to colour dialogs.\n\nSee:\n* `wx_color()`\n\n* `m:wxColourDialog`\n\n* [Overview cmndlg](https://docs.wxwidgets.org/3.2/overview_cmndlg.html#overview_cmndlg_colour)\n\nwxWidgets docs: [wxColourData](https://docs.wxwidgets.org/3.2/classwx_colour_data.html)","ref":"wxColourData.html"},{"type":"function","title":"wxColourData.destroy/1","doc":"Destroys the object","ref":"wxColourData.html#destroy/1"},{"type":"function","title":"wxColourData.getChooseFull/1","doc":"Under Windows, determines whether the Windows colour dialog will display the full dialog\nwith custom colour selection controls.\n\nHas no meaning under other platforms.\n\nThe default value is true.","ref":"wxColourData.html#getChooseFull/1"},{"type":"function","title":"wxColourData.getColour/1","doc":"Gets the current colour associated with the colour dialog.\n\nThe default colour is black.","ref":"wxColourData.html#getColour/1"},{"type":"function","title":"wxColourData.getCustomColour/2","doc":"Returns custom colours associated with the colour dialog.","ref":"wxColourData.html#getCustomColour/2"},{"type":"function","title":"wxColourData.new/0","doc":"Constructor.\n\nInitializes the custom colours to `wxNullColour`, the `data` colour setting to black, and\nthe `choose` full setting to true.","ref":"wxColourData.html#new/0"},{"type":"function","title":"wxColourData.setChooseFull/2","doc":"Under Windows, tells the Windows colour dialog to display the full dialog with custom\ncolour selection controls.\n\nUnder other platforms, has no effect.\n\nThe default value is true.","ref":"wxColourData.html#setChooseFull/2"},{"type":"function","title":"wxColourData.setColour/2","doc":"Sets the default colour for the colour dialog.\n\nThe default colour is black.","ref":"wxColourData.html#setColour/2"},{"type":"function","title":"wxColourData.setCustomColour/3","doc":"Sets custom colours for the colour dialog.","ref":"wxColourData.html#setCustomColour/3"},{"type":"type","title":"wxColourData.wxColourData/0","doc":"","ref":"wxColourData.html#t:wxColourData/0"},{"type":"module","title":"wxColourDialog","doc":"This class represents the colour chooser dialog.\n\nStarting from wxWidgets 3.1.3 and currently in the MSW port only, this dialog generates\nwxEVT_COLOUR_CHANGED events while it is being shown, i.e. from inside its `wxDialog:showModal/1` method, that\nnotify the program about the change of the currently selected colour and allow it to e.g.\npreview the effect of selecting this colour. Note that if you react to this event, you\nshould also correctly revert to the previously selected colour if the dialog is cancelled\nby the user.\n\nExample of using this class with dynamic feedback for the selected colour:\n\nSee:\n* [Overview cmndlg](https://docs.wxwidgets.org/3.2/overview_cmndlg.html#overview_cmndlg_colour)\n\n* `wx_color()`\n\n* `m:wxColourData`\n\n* ?wxGetColourFromUser()\n\nThis class is derived, and can use functions, from:\n\n* `m:wxDialog`\n\n* `m:wxTopLevelWindow`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxColourDialog](https://docs.wxwidgets.org/3.2/classwx_colour_dialog.html)","ref":"wxColourDialog.html"},{"type":"function","title":"wxColourDialog.create/2","doc":"Equivalent to  create(This, Parent, []) .","ref":"wxColourDialog.html#create/2"},{"type":"function","title":"wxColourDialog.create/3","doc":"Same as `new/2`.","ref":"wxColourDialog.html#create/3"},{"type":"function","title":"wxColourDialog.destroy/1","doc":"Destroys the object","ref":"wxColourDialog.html#destroy/1"},{"type":"function","title":"wxColourDialog.getColourData/1","doc":"Returns the colour data associated with the colour dialog.","ref":"wxColourDialog.html#getColourData/1"},{"type":"function","title":"wxColourDialog.new/0","doc":"","ref":"wxColourDialog.html#new/0"},{"type":"function","title":"wxColourDialog.new/1","doc":"Equivalent to  new(Parent, []) .","ref":"wxColourDialog.html#new/1"},{"type":"function","title":"wxColourDialog.new/2","doc":"Constructor.\n\nPass a parent window, and optionally a pointer to a block of colour data, which will be\ncopied to the colour dialog's colour data.\n\nCustom colours from colour data object will be used in the dialog's colour palette.\nInvalid entries in custom colours list will be ignored on some platforms(GTK) or replaced\nwith white colour on platforms where custom colours palette has fixed size (MSW).\n\nSee: `m:wxColourData`","ref":"wxColourDialog.html#new/2"},{"type":"type","title":"wxColourDialog.wxColourDialog/0","doc":"","ref":"wxColourDialog.html#t:wxColourDialog/0"},{"type":"module","title":"wxColourPickerCtrl","doc":"This control allows the user to select a colour.\n\nThe generic implementation is a button which brings up a `m:wxColourDialog` when clicked.\nNative implementation may differ but this is usually a (small) widget which give access to\nthe colour-chooser dialog. It is only available if `wxUSE_COLOURPICKERCTRL` is set to 1\n(the default).","ref":"wxColourPickerCtrl.html"},{"type":"module","title":"Styles - wxColourPickerCtrl","doc":"This class supports the following styles:\n\n* wxCLRP_DEFAULT_STYLE: The default style: 0.\n\n* wxCLRP_USE_TEXTCTRL: Creates a text control to the left of the picker button which is\ncompletely managed by the `m:wxColourPickerCtrl` and which can be used by the user to\nspecify a colour (see SetColour). The text control is automatically synchronized with\nbutton's value. Use functions defined in `m:wxPickerBase` to modify the text control.\n\n* wxCLRP_SHOW_LABEL: Shows the colour in HTML form (AABBCC) as colour button label (instead\nof no label at all).\n\n* wxCLRP_SHOW_ALPHA: Allows selecting opacity in the colour-chooser (effective under wxGTK\nand wxOSX).\n\nSee:\n* `m:wxColourDialog`\n\n* `m:wxColourPickerEvent`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxPickerBase`\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxColourPickerCtrl](https://docs.wxwidgets.org/3.2/classwx_colour_picker_ctrl.html)","ref":"wxColourPickerCtrl.html#module-styles"},{"type":"module","title":"Events - wxColourPickerCtrl","doc":"Event types emitted from this class:\n\n* [`command_colourpicker_changed`](`m:wxColourPickerEvent`)","ref":"wxColourPickerCtrl.html#module-events"},{"type":"function","title":"wxColourPickerCtrl.create/3","doc":"Equivalent to  create(This, Parent, Id, []) .","ref":"wxColourPickerCtrl.html#create/3"},{"type":"function","title":"wxColourPickerCtrl.create/4","doc":"Creates a colour picker with the given arguments.\n\nReturn: true if the control was successfully created or false if creation failed.","ref":"wxColourPickerCtrl.html#create/4"},{"type":"function","title":"wxColourPickerCtrl.destroy/1","doc":"Destroys the object","ref":"wxColourPickerCtrl.html#destroy/1"},{"type":"function","title":"wxColourPickerCtrl.getColour/1","doc":"Returns the currently selected colour.","ref":"wxColourPickerCtrl.html#getColour/1"},{"type":"function","title":"wxColourPickerCtrl.new/0","doc":"","ref":"wxColourPickerCtrl.html#new/0"},{"type":"function","title":"wxColourPickerCtrl.new/2","doc":"Equivalent to  new(Parent, Id, []) .","ref":"wxColourPickerCtrl.html#new/2"},{"type":"function","title":"wxColourPickerCtrl.new/3","doc":"Initializes the object and calls `create/4` with all the parameters.","ref":"wxColourPickerCtrl.html#new/3"},{"type":"function","title":"wxColourPickerCtrl.setColour/2","doc":"Sets the currently selected colour.\n\nSee `wxColour::Set()` (not implemented in wx).","ref":"wxColourPickerCtrl.html#setColour/2"},{"type":"type","title":"wxColourPickerCtrl.wxColourPickerCtrl/0","doc":"","ref":"wxColourPickerCtrl.html#t:wxColourPickerCtrl/0"},{"type":"module","title":"wxColourPickerEvent","doc":"This event class is used for the events generated by `m:wxColourPickerCtrl`.\n\nSee: `m:wxColourPickerCtrl`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxCommandEvent`\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxColourPickerEvent](https://docs.wxwidgets.org/3.2/classwx_colour_picker_event.html)","ref":"wxColourPickerEvent.html"},{"type":"module","title":"Events - wxColourPickerEvent","doc":"Use `wxEvtHandler:connect/3` with `wxColourPickerEventType` to subscribe to events of this type.","ref":"wxColourPickerEvent.html#module-events"},{"type":"function","title":"wxColourPickerEvent.getColour/1","doc":"Retrieve the colour the user has just selected.","ref":"wxColourPickerEvent.html#getColour/1"},{"type":"type","title":"wxColourPickerEvent.wxColourPicker/0","doc":"","ref":"wxColourPickerEvent.html#t:wxColourPicker/0"},{"type":"type","title":"wxColourPickerEvent.wxColourPickerEvent/0","doc":"","ref":"wxColourPickerEvent.html#t:wxColourPickerEvent/0"},{"type":"type","title":"wxColourPickerEvent.wxColourPickerEventType/0","doc":"","ref":"wxColourPickerEvent.html#t:wxColourPickerEventType/0"},{"type":"module","title":"wxComboBox","doc":"A combobox is like a combination of an edit control and a listbox.\n\nIt can be displayed as static list with editable or read-only text field; or a drop-down\nlist with text field; or a drop-down list without a text field depending on the platform\nand presence of wxCB_READONLY style.\n\nA combobox permits a single selection only. Combobox items are numbered from zero.\n\nIf you need a customized combobox, have a look at `wxComboCtrl` (not implemented in wx), `wxOwnerDrawnComboBox`\n(not implemented in wx), `wxComboPopup` (not implemented in wx) and the ready-to-use `wxBitmapComboBox`\n(not implemented in wx).\n\nPlease refer to `wxTextEntry` (not implemented in wx) documentation for the description\nof methods operating with the text entry part of the combobox and to `wxItemContainer`\n(not implemented in wx) for the methods operating with the list of strings. Notice that at\nleast under MSW `m:wxComboBox` doesn't behave correctly if it contains strings differing\nin case only so portable programs should avoid adding such strings to this control.","ref":"wxComboBox.html"},{"type":"module","title":"Styles - wxComboBox","doc":"This class supports the following styles:\n\n* wxCB_SIMPLE: Creates a combobox with a permanently displayed list. Windows only.\n\n* wxCB_DROPDOWN: Creates a combobox with a drop-down list. MSW and Motif only.\n\n* wxCB_READONLY: A combobox with this style behaves like a `m:wxChoice` (and may look in\nthe same way as well, although this is platform-dependent), i.e. it allows the user to\nchoose from the list of options but doesn't allow to enter a value not present in the\nlist.\n\n* wxCB_SORT: Sorts the entries in the list alphabetically.\n\n* wxTE_PROCESS_ENTER: The control will generate the event `wxEVT_TEXT_ENTER` that can be\nhandled by the program. Otherwise, i.e. either if this style not specified at all, or it\nis used, but there is no event handler for this event or the event handler called `wxEvent:skip/2` to\navoid overriding the default handling, pressing Enter key is either processed internally\nby the control or used to activate the default button of the dialog, if any.\n\nSee:\n* `m:wxListBox`\n\n* `m:wxTextCtrl`\n\n* `m:wxChoice`\n\n* `m:wxCommandEvent`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxControlWithItems`\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxComboBox](https://docs.wxwidgets.org/3.2/classwx_combo_box.html)","ref":"wxComboBox.html#module-styles"},{"type":"module","title":"Events - wxComboBox","doc":"Event types emitted from this class:\n\n* [`command_combobox_selected`](`m:wxCommandEvent`)\n\n* [`command_text_updated`](`m:wxCommandEvent`)\n\n* [`command_text_enter`](`m:wxCommandEvent`)\n\n* [`combobox_dropdown`](`m:wxCommandEvent`)\n\n* [`combobox_closeup`](`m:wxCommandEvent`)","ref":"wxComboBox.html#module-events"},{"type":"function","title":"wxComboBox.canCopy/1","doc":"Returns true if the selection can be copied to the clipboard.","ref":"wxComboBox.html#canCopy/1"},{"type":"function","title":"wxComboBox.canCut/1","doc":"Returns true if the selection can be cut to the clipboard.","ref":"wxComboBox.html#canCut/1"},{"type":"function","title":"wxComboBox.canPaste/1","doc":"Returns true if the contents of the clipboard can be pasted into the text control.\n\nOn some platforms (Motif, GTK) this is an approximation and returns true if the control\nis editable, false otherwise.","ref":"wxComboBox.html#canPaste/1"},{"type":"function","title":"wxComboBox.canRedo/1","doc":"Returns true if there is a redo facility available and the last operation can be redone.","ref":"wxComboBox.html#canRedo/1"},{"type":"function","title":"wxComboBox.canUndo/1","doc":"Returns true if there is an undo facility available and the last operation can be undone.","ref":"wxComboBox.html#canUndo/1"},{"type":"function","title":"wxComboBox.copy/1","doc":"Copies the selected text to the clipboard.","ref":"wxComboBox.html#copy/1"},{"type":"function","title":"wxComboBox.create/7","doc":"Equivalent to  create(This, Parent, Id, Value, Pos, Size, Choices, []) .","ref":"wxComboBox.html#create/7"},{"type":"function","title":"wxComboBox.create/8","doc":"","ref":"wxComboBox.html#create/8"},{"type":"function","title":"wxComboBox.cut/1","doc":"Copies the selected text to the clipboard and removes it from the control.","ref":"wxComboBox.html#cut/1"},{"type":"function","title":"wxComboBox.destroy/1","doc":"Destroys the object","ref":"wxComboBox.html#destroy/1"},{"type":"function","title":"wxComboBox.getInsertionPoint/1","doc":"Same as `wxTextCtrl:getInsertionPoint/1`.\n\nNote: Under wxMSW, this function always returns 0 if the combobox doesn't have the focus.","ref":"wxComboBox.html#getInsertionPoint/1"},{"type":"function","title":"wxComboBox.getLastPosition/1","doc":"Returns the zero based index of the last position in the text control, which is equal to\nthe number of characters in the control.","ref":"wxComboBox.html#getLastPosition/1"},{"type":"function","title":"wxComboBox.getValue/1","doc":"Gets the contents of the control.\n\nNotice that for a multiline text control, the lines will be separated by (Unix-style) `\\n`\ncharacters, even under Windows where they are separated by a `\\r\\n` sequence in the\nnative control.","ref":"wxComboBox.html#getValue/1"},{"type":"function","title":"wxComboBox.new/0","doc":"Default constructor.","ref":"wxComboBox.html#new/0"},{"type":"function","title":"wxComboBox.new/2","doc":"Equivalent to  new(Parent, Id, []) .","ref":"wxComboBox.html#new/2"},{"type":"function","title":"wxComboBox.new/3","doc":"Constructor, creating and showing a combobox.\n\nSee: `create/8`","ref":"wxComboBox.html#new/3"},{"type":"function","title":"wxComboBox.paste/1","doc":"Pastes text from the clipboard to the text item.","ref":"wxComboBox.html#paste/1"},{"type":"function","title":"wxComboBox.redo/1","doc":"If there is a redo facility and the last operation can be redone, redoes the last\noperation.\n\nDoes nothing if there is no redo facility.","ref":"wxComboBox.html#redo/1"},{"type":"function","title":"wxComboBox.remove/3","doc":"Removes the text starting at the first given position up to (but not including) the\ncharacter at the last position.\n\nThis function puts the current insertion point position at `to` as a side effect.","ref":"wxComboBox.html#remove/3"},{"type":"function","title":"wxComboBox.replace/4","doc":"Replaces the text starting at the first position up to (but not including) the character\nat the last position with the given text.\n\nThis function puts the current insertion point position at `to` as a side effect.","ref":"wxComboBox.html#replace/4"},{"type":"function","title":"wxComboBox.setInsertionPoint/2","doc":"Sets the insertion point at the given position.","ref":"wxComboBox.html#setInsertionPoint/2"},{"type":"function","title":"wxComboBox.setInsertionPointEnd/1","doc":"Sets the insertion point at the end of the text control.\n\nThis is equivalent to calling `setInsertionPoint/2` with `getLastPosition/1` argument.","ref":"wxComboBox.html#setInsertionPointEnd/1"},{"type":"function","title":"wxComboBox.setSelection/2","doc":"Sets the selection to the given item `n` or removes the selection entirely if `n` == `wxNOT\\_FOUND`.\n\nNote that this does not cause any command events to be emitted nor does it deselect any\nother items in the controls which support multiple selections.\n\nSee:\n* `wxControlWithItems:setString/3`\n\n* `wxControlWithItems:setStringSelection/2`","ref":"wxComboBox.html#setSelection/2"},{"type":"function","title":"wxComboBox.setSelection/3","doc":"Same as `wxTextCtrl:setSelection/3`.","ref":"wxComboBox.html#setSelection/3"},{"type":"function","title":"wxComboBox.setValue/2","doc":"Sets the text for the combobox text field.\n\nFor normal, editable comboboxes with a text entry field calling this method will generate\na `wxEVT_TEXT` event, consistently with `wxTextCtrl:setValue/2` behaviour, use `wxTextCtrl:changeValue/2` if this is undesirable.\n\nFor controls with `wxCB_READONLY` style the method behaves somewhat differently: the\nstring must be in the combobox choices list (the check for this is case-insensitive) and `wxEVT_TEXT`\nis `not` generated in this case.","ref":"wxComboBox.html#setValue/2"},{"type":"function","title":"wxComboBox.undo/1","doc":"If there is an undo facility and the last operation can be undone, undoes the last\noperation.\n\nDoes nothing if there is no undo facility.","ref":"wxComboBox.html#undo/1"},{"type":"type","title":"wxComboBox.wxComboBox/0","doc":"","ref":"wxComboBox.html#t:wxComboBox/0"},{"type":"module","title":"wxCommandEvent","doc":"This event class contains information about command events, which originate from a\nvariety of simple controls.\n\nNote that wxCommandEvents and wxCommandEvent-derived event classes by default and unlike\nother wxEvent-derived classes propagate upward from the source window (the window which\nemits the event) up to the first parent which processes the event. Be sure to read overview_events_propagation.\n\nMore complex controls, such as `m:wxTreeCtrl`, have separate command event classes.\n\nThis class is derived, and can use functions, from:\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxCommandEvent](https://docs.wxwidgets.org/3.2/classwx_command_event.html)","ref":"wxCommandEvent.html"},{"type":"module","title":"Events - wxCommandEvent","doc":"Use `wxEvtHandler:connect/3` with `wxCommandEventType` to subscribe to events of this type.","ref":"wxCommandEvent.html#module-events"},{"type":"function","title":"wxCommandEvent.getClientData/1","doc":"Returns client object pointer for a listbox or choice selection event (not valid for a\ndeselection).","ref":"wxCommandEvent.html#getClientData/1"},{"type":"function","title":"wxCommandEvent.getExtraLong/1","doc":"Returns extra information dependent on the event objects type.\n\nIf the event comes from a listbox selection, it is a boolean determining whether the\nevent was a selection (true) or a deselection (false). A listbox deselection only occurs\nfor multiple-selection boxes, and in this case the index and string values are\nindeterminate and the listbox must be examined by the application.","ref":"wxCommandEvent.html#getExtraLong/1"},{"type":"function","title":"wxCommandEvent.getInt/1","doc":"Returns the integer identifier corresponding to a listbox, choice or radiobox selection\n(only if the event was a selection, not a deselection), or a boolean value representing\nthe value of a checkbox.\n\nFor a menu item, this method returns -1 if the item is not checkable or a boolean value\n(true or false) for checkable items indicating the new state of the item.","ref":"wxCommandEvent.html#getInt/1"},{"type":"function","title":"wxCommandEvent.getSelection/1","doc":"Returns item index for a listbox or choice selection event (not valid for a deselection).","ref":"wxCommandEvent.html#getSelection/1"},{"type":"function","title":"wxCommandEvent.getString/1","doc":"Returns item string for a listbox or choice selection event.\n\nIf one or several items have been deselected, returns the index of the first deselected\nitem. If some items have been selected and others deselected at the same time, it will\nreturn the index of the first selected item.","ref":"wxCommandEvent.html#getString/1"},{"type":"function","title":"wxCommandEvent.isChecked/1","doc":"This method can be used with checkbox and menu events: for the checkboxes, the method\nreturns true for a selection event and false for a deselection one.\n\nFor the menu events, this method indicates if the menu item just has become checked or\nunchecked (and thus only makes sense for checkable menu items).\n\nNotice that this method cannot be used with `m:wxCheckListBox` currently.","ref":"wxCommandEvent.html#isChecked/1"},{"type":"function","title":"wxCommandEvent.isSelection/1","doc":"For a listbox or similar event, returns true if it is a selection, false if it is a\ndeselection.\n\nIf some items have been selected and others deselected at the same time, it will return\ntrue.","ref":"wxCommandEvent.html#isSelection/1"},{"type":"function","title":"wxCommandEvent.setInt/2","doc":"Sets the `m_commandInt` member.","ref":"wxCommandEvent.html#setInt/2"},{"type":"function","title":"wxCommandEvent.setString/2","doc":"Sets the `m_commandString` member.","ref":"wxCommandEvent.html#setString/2"},{"type":"type","title":"wxCommandEvent.wxCommand/0","doc":"","ref":"wxCommandEvent.html#t:wxCommand/0"},{"type":"type","title":"wxCommandEvent.wxCommandEvent/0","doc":"","ref":"wxCommandEvent.html#t:wxCommandEvent/0"},{"type":"type","title":"wxCommandEvent.wxCommandEventType/0","doc":"","ref":"wxCommandEvent.html#t:wxCommandEventType/0"},{"type":"module","title":"wxContextMenuEvent","doc":"This class is used for context menu events, sent to give the application a chance to show\na context (popup) menu for a `m:wxWindow`.\n\nNote that if `getPosition/1` returns wxDefaultPosition, this means that the event originated from a\nkeyboard context button event, and you should compute a suitable position yourself, for\nexample by calling `wx_misc:getMousePosition/0`.\n\nNotice that the exact sequence of mouse events is different across the platforms. For\nexample, under MSW the context menu event is generated after `EVT_RIGHT_UP` event and only\nif it was not handled but under GTK the context menu event is generated after `EVT_RIGHT_DOWN`\nevent. This is correct in the sense that it ensures that the context menu is shown\naccording to the current platform UI conventions and also means that you must not handle\n(or call `wxEvent:skip/2` in your handler if you do have one) neither right mouse down nor right mouse up\nevent if you plan on handling `EVT_CONTEXT_MENU` event.\n\nSee:\n* `m:wxCommandEvent`\n\n* [Overview events](https://docs.wxwidgets.org/3.2/overview_events.html#overview_events)\n\nThis class is derived, and can use functions, from:\n\n* `m:wxCommandEvent`\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxContextMenuEvent](https://docs.wxwidgets.org/3.2/classwx_context_menu_event.html)","ref":"wxContextMenuEvent.html"},{"type":"module","title":"Events - wxContextMenuEvent","doc":"Use `wxEvtHandler:connect/3` with `wxContextMenuEventType` to subscribe to events of this type.","ref":"wxContextMenuEvent.html#module-events"},{"type":"function","title":"wxContextMenuEvent.getPosition/1","doc":"Returns the position in screen coordinates at which the menu should be shown.\n\nUse `wxWindow:screenToClient/2` to convert to client coordinates.\n\nYou can also omit a position from `wxWindow:popupMenu/4` in order to use the current mouse pointer position.\n\nIf the event originated from a keyboard event, the value returned from this function will\nbe wxDefaultPosition.","ref":"wxContextMenuEvent.html#getPosition/1"},{"type":"function","title":"wxContextMenuEvent.setPosition/2","doc":"Sets the position at which the menu should be shown.","ref":"wxContextMenuEvent.html#setPosition/2"},{"type":"type","title":"wxContextMenuEvent.wxContextMenu/0","doc":"","ref":"wxContextMenuEvent.html#t:wxContextMenu/0"},{"type":"type","title":"wxContextMenuEvent.wxContextMenuEvent/0","doc":"","ref":"wxContextMenuEvent.html#t:wxContextMenuEvent/0"},{"type":"type","title":"wxContextMenuEvent.wxContextMenuEventType/0","doc":"","ref":"wxContextMenuEvent.html#t:wxContextMenuEventType/0"},{"type":"module","title":"wxControl","doc":"This is the base class for a control or \"widget\".\n\nA control is generally a small window which processes user input and/or displays one or\nmore item of data.\n\nThis class is derived, and can use functions, from:\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxControl](https://docs.wxwidgets.org/3.2/classwx_control.html)","ref":"wxControl.html"},{"type":"module","title":"Events - wxControl","doc":"Event types emitted from this class:\n\n* [`command_text_copy`](`m:wxClipboardTextEvent`)\n\n* [`command_text_cut`](`m:wxClipboardTextEvent`)\n\n* [`command_text_paste`](`m:wxClipboardTextEvent`)","ref":"wxControl.html#module-events"},{"type":"function","title":"wxControl.getLabel/1","doc":"Returns the control's label, as it was passed to `setLabel/2`.\n\nNote that the returned string may contains mnemonics (\"&\" characters) if they were passed\nto the `setLabel/2` function; use `GetLabelText()` (not implemented in wx) if they are undesired.\n\nAlso note that the returned string is always the string which was passed to `setLabel/2` but may be\ndifferent from the string passed to `SetLabelText()` (not implemented in wx) (since this\nlast one escapes mnemonic characters).","ref":"wxControl.html#getLabel/1"},{"type":"function","title":"wxControl.setLabel/2","doc":"Sets the control's label.\n\nAll \"&\" characters in the `label` are special and indicate that the following character\nis a `mnemonic` for this control and can be used to activate it from the keyboard\n(typically by using `Alt` key in combination with it). To insert a literal ampersand\ncharacter, you need to double it, i.e. use \"&&\". If this behaviour is undesirable, use `SetLabelText()`\n(not implemented in wx) instead.","ref":"wxControl.html#setLabel/2"},{"type":"type","title":"wxControl.wxControl/0","doc":"","ref":"wxControl.html#t:wxControl/0"},{"type":"module","title":"wxControlWithItems","doc":"This is convenience class that derives from both `m:wxControl` and `wxItemContainer` (not\nimplemented in wx).\n\nIt is used as basis for some wxWidgets controls (`m:wxChoice` and `m:wxListBox`).\n\nThis class is derived, and can use functions, from:\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxControlWithItems](https://docs.wxwidgets.org/3.2/classwx_control_with_items.html)","ref":"wxControlWithItems.html"},{"type":"function","title":"wxControlWithItems.append/2","doc":"Appends item into the control.\n\nReturn: The return value is the index of the newly inserted item. Note that this may be\ndifferent from the last one if the control is sorted (e.g. has `wxLB_SORT` or `wxCB_SORT`\nstyle).","ref":"wxControlWithItems.html#append/2"},{"type":"function","title":"wxControlWithItems.append/3","doc":"Appends item into the control.\n\nReturn: The return value is the index of the newly inserted item. Note that this may be\ndifferent from the last one if the control is sorted (e.g. has `wxLB_SORT` or `wxCB_SORT`\nstyle).","ref":"wxControlWithItems.html#append/3"},{"type":"function","title":"wxControlWithItems.appendStrings/2","doc":"Appends several items at once into the control.\n\nNotice that calling this method is usually much faster than appending them one by one if\nyou need to add a lot of items.","ref":"wxControlWithItems.html#appendStrings/2"},{"type":"function","title":"wxControlWithItems.appendStrings/3","doc":"Appends several items at once into the control.\n\nNotice that calling this method is usually much faster than appending them one by one if\nyou need to add a lot of items.","ref":"wxControlWithItems.html#appendStrings/3"},{"type":"function","title":"wxControlWithItems.clear/1","doc":"Removes all items from the control.\n\n`clear/1` also deletes the client data of the existing items if it is owned by the control.","ref":"wxControlWithItems.html#clear/1"},{"type":"function","title":"wxControlWithItems.delete/2","doc":"Deletes an item from the control.\n\nThe client data associated with the item will be also deleted if it is owned by the\ncontrol. Note that it is an error (signalled by an assert failure in debug builds) to\nremove an item with the index negative or greater or equal than the number of items in the control.\n\nIf there is a currently selected item below the item being deleted, i.e. if `getSelection/1` returns a\nvalid index greater than or equal to `n`, the selection is invalidated when this function\nis called. However if the selected item appears before the item being deleted, the\nselection is preserved unchanged.\n\nSee: `clear/1`","ref":"wxControlWithItems.html#delete/2"},{"type":"function","title":"wxControlWithItems.findString/2","doc":"Equivalent to  findString(This, String, []) .","ref":"wxControlWithItems.html#findString/2"},{"type":"function","title":"wxControlWithItems.findString/3","doc":"Finds an item whose label matches the given string.\n\nReturn: The zero-based position of the item, or wxNOT_FOUND if the string was not found.","ref":"wxControlWithItems.html#findString/3"},{"type":"function","title":"wxControlWithItems.getClientData/2","doc":"Returns a pointer to the client data associated with the given item (if any).\n\nIt is an error to call this function for a control which doesn't have typed client data\nat all although it is OK to call it even if the given item doesn't have any client data\nassociated with it (but other items do).\n\nNotice that the returned pointer is still owned by the control and will be deleted by it,\nuse `DetachClientObject()` (not implemented in wx) if you want to remove the pointer from\nthe control.\n\nReturn: A pointer to the client data, or NULL if not present.","ref":"wxControlWithItems.html#getClientData/2"},{"type":"function","title":"wxControlWithItems.getCount/1","doc":"Returns the number of items in the control.\n\nSee: `isEmpty/1`","ref":"wxControlWithItems.html#getCount/1"},{"type":"function","title":"wxControlWithItems.getSelection/1","doc":"Returns the index of the selected item or `wxNOT\\_FOUND` if no item is selected.\n\nReturn: The position of the current selection.\n\nRemark: This method can be used with single selection list boxes only, you should use `wxListBox:getSelections/1`\nfor the list boxes with wxLB_MULTIPLE style.\n\nSee:\n* `setSelection/2`\n\n* `getStringSelection/1`","ref":"wxControlWithItems.html#getSelection/1"},{"type":"function","title":"wxControlWithItems.getString/2","doc":"Returns the label of the item with the given index.\n\nReturn: The label of the item or an empty string if the position was invalid.","ref":"wxControlWithItems.html#getString/2"},{"type":"function","title":"wxControlWithItems.getStringSelection/1","doc":"Returns the label of the selected item or an empty string if no item is selected.\n\nSee: `getSelection/1`","ref":"wxControlWithItems.html#getStringSelection/1"},{"type":"function","title":"wxControlWithItems.insert/3","doc":"Inserts item into the control.\n\nReturn: The return value is the index of the newly inserted item. If the insertion failed\nfor some reason, -1 is returned.","ref":"wxControlWithItems.html#insert/3"},{"type":"function","title":"wxControlWithItems.insert/4","doc":"Inserts item into the control.\n\nReturn: The return value is the index of the newly inserted item. If the insertion failed\nfor some reason, -1 is returned.","ref":"wxControlWithItems.html#insert/4"},{"type":"function","title":"wxControlWithItems.insertStrings/3","doc":"Inserts several items at once into the control.\n\nNotice that calling this method is usually much faster than inserting them one by one if\nyou need to insert a lot of items.\n\nReturn: The return value is the index of the last inserted item. If the insertion failed\nfor some reason, -1 is returned.","ref":"wxControlWithItems.html#insertStrings/3"},{"type":"function","title":"wxControlWithItems.insertStrings/4","doc":"Inserts several items at once into the control.\n\nNotice that calling this method is usually much faster than inserting them one by one if\nyou need to insert a lot of items.\n\nReturn: The return value is the index of the last inserted item. If the insertion failed\nfor some reason, -1 is returned.","ref":"wxControlWithItems.html#insertStrings/4"},{"type":"function","title":"wxControlWithItems.isEmpty/1","doc":"Returns true if the control is empty or false if it has some items.\n\nSee: `getCount/1`","ref":"wxControlWithItems.html#isEmpty/1"},{"type":"function","title":"wxControlWithItems.select/2","doc":"This is the same as `setSelection/2` and exists only because it is slightly more natural\nfor controls which support multiple selection.","ref":"wxControlWithItems.html#select/2"},{"type":"function","title":"wxControlWithItems.setClientData/3","doc":"Associates the given typed client data pointer with the given item: the `data` object\nwill be deleted when the item is deleted (either explicitly by using `delete/2` or\nimplicitly when the control itself is destroyed).\n\nNote that it is an error to call this function if any untyped client data pointers had\nbeen associated with the control items before.","ref":"wxControlWithItems.html#setClientData/3"},{"type":"function","title":"wxControlWithItems.setSelection/2","doc":"Sets the selection to the given item `n` or removes the selection entirely if `n` == `wxNOT\\_FOUND`.\n\nNote that this does not cause any command events to be emitted nor does it deselect any\nother items in the controls which support multiple selections.\n\nSee:\n* `setString/3`\n\n* `setStringSelection/2`","ref":"wxControlWithItems.html#setSelection/2"},{"type":"function","title":"wxControlWithItems.setString/3","doc":"Sets the label for the given item.","ref":"wxControlWithItems.html#setString/3"},{"type":"function","title":"wxControlWithItems.setStringSelection/2","doc":"Selects the item with the specified string in the control.\n\nThis method doesn't cause any command events to be emitted.\n\nNotice that this method is case-insensitive, i.e. the string is compared with all the\nelements of the control case-insensitively and the first matching entry is selected, even\nif it doesn't have exactly the same case as this string and there is an exact match afterwards.\n\nReturn: true if the specified string has been selected, false if it wasn't found in the\ncontrol.","ref":"wxControlWithItems.html#setStringSelection/2"},{"type":"type","title":"wxControlWithItems.wxControlWithItems/0","doc":"","ref":"wxControlWithItems.html#t:wxControlWithItems/0"},{"type":"module","title":"wxCursor","doc":"A cursor is a small bitmap usually used for denoting where the mouse pointer is, with a\npicture that might indicate the interpretation of a mouse click.\n\nAs with icons, cursors in X and MS Windows are created in a different manner. Therefore,\nseparate cursors will be created for the different environments. Platform-specific methods\nfor creating a `m:wxCursor` object are catered for, and this is an occasion where\nconditional compilation will probably be required (see `m:wxIcon` for an example).\n\nA single cursor object may be used in many windows (any subwindow type). The wxWidgets\nconvention is to set the cursor for a window, as in X, rather than to set it globally as\nin MS Windows, although a global `wx_misc:setCursor/1` function is also available for MS Windows use.\n\nCreating a Custom Cursor\n\nThe following is an example of creating a cursor from 32x32 bitmap data (down_bits) and a\nmask (down_mask) where 1 is black and 0 is white for the bits, and 1 is opaque and 0 is\ntransparent for the mask. It works on Windows and GTK+.\n\nPredefined objects (include wx.hrl):\n\n* ?wxNullCursor\n\n* ?wxSTANDARD\\_CURSOR\n\n* ?wxHOURGLASS\\_CURSOR\n\n* ?wxCROSS\\_CURSOR\n\nSee:\n* `m:wxBitmap`\n\n* `m:wxIcon`\n\n* `wxWindow:setCursor/2`\n\n* `wx_misc:setCursor/1`\n\n* ?wxStockCursor\n\nThis class is derived, and can use functions, from:\n\n* `m:wxBitmap`\n\nwxWidgets docs: [wxCursor](https://docs.wxwidgets.org/3.2/classwx_cursor.html)","ref":"wxCursor.html"},{"type":"function","title":"wxCursor.destroy/1","doc":"Destroys the object","ref":"wxCursor.html#destroy/1"},{"type":"function","title":"wxCursor.isOk/1","doc":"Returns true if cursor data is present.","ref":"wxCursor.html#isOk/1"},{"type":"function","title":"wxCursor.new/0","doc":"Default constructor.","ref":"wxCursor.html#new/0"},{"type":"function","title":"wxCursor.new/1","doc":"Constructs a cursor using a cursor identifier.","ref":"wxCursor.html#new/1"},{"type":"function","title":"wxCursor.new/2","doc":"Constructs a cursor by passing a string resource name or filename.\n\nThe arguments `hotSpotX` and `hotSpotY` are only used when there's no hotspot info in the\nresource/image-file to load (e.g. when using `wxBITMAP_TYPE_ICO` under wxMSW or `wxBITMAP_TYPE_XPM`\nunder wxGTK).","ref":"wxCursor.html#new/2"},{"type":"function","title":"wxCursor.ok/1","doc":"Equivalent to: `isOk/1`","ref":"wxCursor.html#ok/1"},{"type":"type","title":"wxCursor.wxCursor/0","doc":"","ref":"wxCursor.html#t:wxCursor/0"},{"type":"module","title":"wxDC","doc":"A `m:wxDC` is a `\"device context\"` onto which graphics and text can be drawn.\n\nIt is intended to represent different output devices and offers a common abstract API for\ndrawing on any of them.\n\nwxWidgets offers an alternative drawing API based on the modern drawing backends GDI+,\nCoreGraphics, Cairo and Direct2D. See `m:wxGraphicsContext`, `m:wxGraphicsRenderer` and\nrelated classes. There is also a `m:wxGCDC` linking the APIs by offering the `m:wxDC` API\non top of a `m:wxGraphicsContext`.\n\n`m:wxDC` is an abstract base class and cannot be created directly. Use `m:wxPaintDC`, `m:wxClientDC`, `m:wxWindowDC`, `m:wxScreenDC`, `m:wxMemoryDC`\nor `wxPrinterDC` (not implemented in wx). Notice that device contexts which are\nassociated with windows (i.e. `m:wxClientDC`, `m:wxWindowDC` and `m:wxPaintDC`) use the\nwindow font and colours by default (starting with wxWidgets 2.9.0) but the other device\ncontext classes use system-default values so you always must set the appropriate fonts and\ncolours before using them.\n\nIn addition to the versions of the methods documented below, there are also versions\nwhich accept single {X,Y} parameter instead of the two wxCoord ones or {X,Y} and\n{Width,Height} instead of the four wxCoord parameters.\n\nBeginning with wxWidgets 2.9.0 the entire `m:wxDC` code has been reorganized. All\nplatform dependent code (actually all drawing code) has been moved into backend classes\nwhich derive from a common wxDCImpl class. The user-visible classes such as `m:wxClientDC`\nand `m:wxPaintDC` merely forward all calls to the backend implementation.\n\nDevice and logical units\n\nIn the `m:wxDC` context there is a distinction between `logical` units and `device` units.\n\n`Device` units are the units native to the particular device; e.g. for a screen, a device\nunit is a `pixel`. For a printer, the device unit is defined by the resolution of the\nprinter (usually given in `DPI:` dot-per-inch).\n\nAll `m:wxDC` functions use instead `logical` units, unless where explicitly stated.\nLogical units are arbitrary units mapped to device units using the current mapping mode\n(see `setMapMode/2`).\n\nThis mechanism allows reusing the same code which prints on e.g. a window on the screen\nto print on e.g. a paper.\n\nSupport for Transparency / Alpha Channel\n\nIn general `m:wxDC` methods don't support alpha transparency and the alpha component of `wx_color()`\nis simply ignored and you need to use `m:wxGraphicsContext` for full transparency support.\nThere are, however, a few exceptions: first, under macOS and GTK+ 3 colours with alpha\nchannel are supported in all the normal wxDC-derived classes as they use `m:wxGraphicsContext`\ninternally. Second, under all platforms `wxSVGFileDC` (not implemented in wx) also fully\nsupports alpha channel. In both of these cases the instances of `m:wxPen` or `m:wxBrush`\nthat are built from `wx_color()` use the colour's alpha values when stroking or filling.\n\nSupport for Transformation Matrix\n\nOn some platforms (currently under MSW, GTK+ 3, macOS) `m:wxDC` has support for applying\nan arbitrary affine transformation matrix to its coordinate system (since 3.1.1 this\nfeature is also supported by `m:wxGCDC` in all ports). Call `CanUseTransformMatrix()` (not\nimplemented in wx) to check if this support is available and then call `SetTransformMatrix()`\n(not implemented in wx) if it is. If the transformation matrix is not supported, `SetTransformMatrix()`\n(not implemented in wx) always simply returns `false` and doesn't do anything.\n\nThis feature is only available when `wxUSE_DC_TRANSFORM_MATRIX` build option is enabled.\n\nSee:\n* [Overview dc](https://docs.wxwidgets.org/3.2/overview_dc.html#overview_dc)\n\n* `m:wxGraphicsContext`\n\nwxWidgets docs: [wxDC](https://docs.wxwidgets.org/3.2/classwx_d_c.html)","ref":"wxDC.html"},{"type":"function","title":"wxDC.blit/5","doc":"Equivalent to  blit(This, Dest, Size, Source, Src, []) .","ref":"wxDC.html#blit/5"},{"type":"function","title":"wxDC.blit/6","doc":"Copy from a source DC to this DC.\n\nWith this method you can specify the destination coordinates and the size of area to copy\nwhich will be the same for both the source and target DCs. If you need to apply scaling\nwhile copying, use `StretchBlit()` (not implemented in wx).\n\nNotice that source DC coordinates `xsrc` and `ysrc` are interpreted using the current\nsource DC coordinate system, i.e. the scale, origin position and axis directions are taken\ninto account when transforming them to physical (pixel) coordinates.\n\nRemark: There is partial support for `blit/6` in `m:wxPostScriptDC`, under X.\n\nSee:\n* `m:wxMemoryDC`\n\n* `m:wxBitmap`\n\n* `m:wxMask`","ref":"wxDC.html#blit/6"},{"type":"function","title":"wxDC.calcBoundingBox/3","doc":"Adds the specified point to the bounding box which can be retrieved with `minX/1`, `maxX/1`\nand `minY/1`, `maxY/1` functions.\n\nSee: `resetBoundingBox/1`","ref":"wxDC.html#calcBoundingBox/3"},{"type":"function","title":"wxDC.clear/1","doc":"Clears the device context using the current background brush.\n\nNote that `setBackground/2` method must be used to set the brush used by `clear/1`, the brush used for filling the\nshapes set by `setBrush/2` is ignored by it.\n\nIf no background brush was set, solid white brush is used to clear the device context.","ref":"wxDC.html#clear/1"},{"type":"function","title":"wxDC.crossHair/2","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#crossHair/2"},{"type":"function","title":"wxDC.destroyClippingRegion/1","doc":"Destroys the current clipping region so that none of the DC is clipped.\n\nSee: `setClippingRegion/3`","ref":"wxDC.html#destroyClippingRegion/1"},{"type":"function","title":"wxDC.deviceToLogicalX/2","doc":"Convert `device` X coordinate to logical coordinate, using the current mapping mode, user\nscale factor, device origin and axis orientation.","ref":"wxDC.html#deviceToLogicalX/2"},{"type":"function","title":"wxDC.deviceToLogicalXRel/2","doc":"Convert `device` X coordinate to relative logical coordinate, using the current mapping\nmode and user scale factor but ignoring the axis orientation.\n\nUse this for converting a width, for example.","ref":"wxDC.html#deviceToLogicalXRel/2"},{"type":"function","title":"wxDC.deviceToLogicalY/2","doc":"Converts `device` Y coordinate to logical coordinate, using the current mapping mode,\nuser scale factor, device origin and axis orientation.","ref":"wxDC.html#deviceToLogicalY/2"},{"type":"function","title":"wxDC.deviceToLogicalYRel/2","doc":"Convert `device` Y coordinate to relative logical coordinate, using the current mapping\nmode and user scale factor but ignoring the axis orientation.\n\nUse this for converting a height, for example.","ref":"wxDC.html#deviceToLogicalYRel/2"},{"type":"function","title":"wxDC.drawArc/4","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#drawArc/4"},{"type":"function","title":"wxDC.drawBitmap/3","doc":"Equivalent to  drawBitmap(This, Bmp, Pt, []) .","ref":"wxDC.html#drawBitmap/3"},{"type":"function","title":"wxDC.drawBitmap/4","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#drawBitmap/4"},{"type":"function","title":"wxDC.drawCheckMark/2","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#drawCheckMark/2"},{"type":"function","title":"wxDC.drawCircle/3","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#drawCircle/3"},{"type":"function","title":"wxDC.drawEllipse/2","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#drawEllipse/2"},{"type":"function","title":"wxDC.drawEllipse/3","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#drawEllipse/3"},{"type":"function","title":"wxDC.drawEllipticArc/5","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#drawEllipticArc/5"},{"type":"function","title":"wxDC.drawIcon/3","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#drawIcon/3"},{"type":"function","title":"wxDC.drawLabel/3","doc":"Equivalent to  drawLabel(This, Text, Rect, []) .","ref":"wxDC.html#drawLabel/3"},{"type":"function","title":"wxDC.drawLabel/4","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#drawLabel/4"},{"type":"function","title":"wxDC.drawLine/3","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#drawLine/3"},{"type":"function","title":"wxDC.drawLines/2","doc":"Equivalent to  drawLines(This, Points, []) .","ref":"wxDC.html#drawLines/2"},{"type":"function","title":"wxDC.drawLines/3","doc":"Draws lines using an array of points of size `n` adding the optional offset coordinate.\n\nThe current pen is used for drawing the lines.","ref":"wxDC.html#drawLines/3"},{"type":"function","title":"wxDC.drawPoint/2","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#drawPoint/2"},{"type":"function","title":"wxDC.drawPolygon/2","doc":"Equivalent to  drawPolygon(This, Points, []) .","ref":"wxDC.html#drawPolygon/2"},{"type":"function","title":"wxDC.drawPolygon/3","doc":"Draws a filled polygon using an array of points of size `n`, adding the optional offset\ncoordinate.\n\nThe first and last points are automatically closed.\n\nThe last argument specifies the fill rule: `wxODDEVEN_RULE` (the default) or `wxWINDING_RULE`.\n\nThe current pen is used for drawing the outline, and the current brush for filling the\nshape. Using a transparent brush suppresses filling.","ref":"wxDC.html#drawPolygon/3"},{"type":"function","title":"wxDC.drawRectangle/2","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#drawRectangle/2"},{"type":"function","title":"wxDC.drawRectangle/3","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#drawRectangle/3"},{"type":"function","title":"wxDC.drawRotatedText/4","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#drawRotatedText/4"},{"type":"function","title":"wxDC.drawRoundedRectangle/3","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#drawRoundedRectangle/3"},{"type":"function","title":"wxDC.drawRoundedRectangle/4","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#drawRoundedRectangle/4"},{"type":"function","title":"wxDC.drawText/3","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#drawText/3"},{"type":"function","title":"wxDC.endDoc/1","doc":"Ends a document (only relevant when outputting to a printer).","ref":"wxDC.html#endDoc/1"},{"type":"function","title":"wxDC.endPage/1","doc":"Ends a document page (only relevant when outputting to a printer).","ref":"wxDC.html#endPage/1"},{"type":"function","title":"wxDC.floodFill/3","doc":"Equivalent to  floodFill(This, Pt, Col, []) .","ref":"wxDC.html#floodFill/3"},{"type":"function","title":"wxDC.floodFill/4","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#floodFill/4"},{"type":"function","title":"wxDC.getBackground/1","doc":"Gets the brush used for painting the background.\n\nSee: `setBackground/2`","ref":"wxDC.html#getBackground/1"},{"type":"function","title":"wxDC.getBackgroundMode/1","doc":"Returns the current background mode: `wxPENSTYLE\\_SOLID` or `wxPENSTYLE\\_TRANSPARENT`.\n\nSee: `setBackgroundMode/2`","ref":"wxDC.html#getBackgroundMode/1"},{"type":"function","title":"wxDC.getBrush/1","doc":"Gets the current brush.\n\nSee: `setBrush/2`","ref":"wxDC.html#getBrush/1"},{"type":"function","title":"wxDC.getCharHeight/1","doc":"Gets the character height of the currently set font.","ref":"wxDC.html#getCharHeight/1"},{"type":"function","title":"wxDC.getCharWidth/1","doc":"Gets the average character width of the currently set font.","ref":"wxDC.html#getCharWidth/1"},{"type":"function","title":"wxDC.getClippingBox/1","doc":"` Gets the rectangle surrounding the current clipping region. If no clipping region is set\nthis function returns the extent of the device context. @remarks Clipping region is given\nin logical coordinates. @param x If non- NULL , filled in with\nthe logical horizontal coordinate of the top left corner of the clipping region if the\nfunction returns true or 0 otherwise. @param y If non- NULL ,\nfilled in with the logical vertical coordinate of the top left corner of the clipping\nregion if the function returns true or 0 otherwise. @param width If non- NULL , filled in with the width of the clipping region if the\nfunction returns true or the device context width otherwise. @param height If non- NULL , filled in with the height of the clipping region if the\nfunction returns true or the device context height otherwise. `\n\nReturn: true if there is a clipping region or false if there is no active clipping region\n(note that this return value is available only since wxWidgets 3.1.2, this function didn't\nreturn anything in the previous versions).","ref":"wxDC.html#getClippingBox/1"},{"type":"function","title":"wxDC.getFont/1","doc":"Gets the current font.\n\nNotice that even although each device context object has some default font after\ncreation, this method would return a ?wxNullFont initially and only after calling `setFont/2` a valid\nfont is returned.","ref":"wxDC.html#getFont/1"},{"type":"function","title":"wxDC.getLayoutDirection/1","doc":"Gets the current layout direction of the device context.\n\nOn platforms where RTL layout is supported, the return value will either be `wxLayout_LeftToRight`\nor `wxLayout_RightToLeft`. If RTL layout is not supported, the return value will be `wxLayout_Default`.\n\nSee: `setLayoutDirection/2`","ref":"wxDC.html#getLayoutDirection/1"},{"type":"function","title":"wxDC.getLogicalFunction/1","doc":"Gets the current logical function.\n\nSee: `setLogicalFunction/2`","ref":"wxDC.html#getLogicalFunction/1"},{"type":"function","title":"wxDC.getMapMode/1","doc":"Gets the current mapping mode for the device context.\n\nSee: `setMapMode/2`","ref":"wxDC.html#getMapMode/1"},{"type":"function","title":"wxDC.getMultiLineTextExtent/2","doc":"Gets the dimensions of the string using the currently selected font.\n\n`string` is the text string to measure.\n\nReturn: The text extent as a {Width,Height} object.\n\nNote: This function works with both single-line and multi-line strings.\n\nSee:\n* `m:wxFont`\n\n* `setFont/2`\n\n* `getPartialTextExtents/2`\n\n* `getTextExtent/3`","ref":"wxDC.html#getMultiLineTextExtent/2"},{"type":"function","title":"wxDC.getMultiLineTextExtent/3","doc":"Gets the dimensions of the string using the currently selected font.\n\n`string` is the text string to measure, `heightLine`, if non NULL, is where to store the\nheight of a single line.\n\nThe text extent is set in the given `w` and `h` pointers.\n\nIf the optional parameter `font` is specified and valid, then it is used for the text\nextent calculation, otherwise the currently selected font is used.\n\nIf `string` is empty, its horizontal extent is 0 but, for convenience when using this\nfunction for allocating enough space for a possibly multi-line string, its vertical extent\nis the same as the height of an empty line of text. Please note that this behaviour\ndiffers from that of `getTextExtent/3`.\n\nNote: This function works with both single-line and multi-line strings.\n\nSee:\n* `m:wxFont`\n\n* `setFont/2`\n\n* `getPartialTextExtents/2`\n\n* `getTextExtent/3`","ref":"wxDC.html#getMultiLineTextExtent/3"},{"type":"function","title":"wxDC.getPartialTextExtents/2","doc":"Fills the `widths` array with the widths from the beginning of `text` to the\ncorresponding character of `text`.\n\nThe generic version simply builds a running total of the widths of each character using `getTextExtent/3`,\nhowever if the various platforms have a native API function that is faster or more\naccurate than the generic implementation then it should be used instead.\n\nSee:\n* `getMultiLineTextExtent/3`\n\n* `getTextExtent/3`","ref":"wxDC.html#getPartialTextExtents/2"},{"type":"function","title":"wxDC.getPen/1","doc":"Gets the current pen.\n\nSee: `setPen/2`","ref":"wxDC.html#getPen/1"},{"type":"function","title":"wxDC.getPixel/2","doc":"Gets in `colour` the colour at the specified location.\n\nThis method isn't available for `m:wxPostScriptDC` or `wxMetafileDC` (not implemented in\nwx) nor for any DC in wxOSX port and simply returns false there.\n\nNote: Setting a pixel can be done using `drawPoint/2`.\n\nNote: This method shouldn't be used with `m:wxPaintDC` as accessing the DC while drawing\ncan result in unexpected results, notably in wxGTK.","ref":"wxDC.html#getPixel/2"},{"type":"function","title":"wxDC.getPPI/1","doc":"Returns the resolution of the device in pixels per inch.","ref":"wxDC.html#getPPI/1"},{"type":"function","title":"wxDC.getSize/1","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#getSize/1"},{"type":"function","title":"wxDC.getSizeMM/1","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#getSizeMM/1"},{"type":"function","title":"wxDC.getTextBackground/1","doc":"Gets the current text background colour.\n\nSee: `setTextBackground/2`","ref":"wxDC.html#getTextBackground/1"},{"type":"function","title":"wxDC.getTextExtent/2","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#getTextExtent/2"},{"type":"function","title":"wxDC.getTextExtent/3","doc":"Gets the dimensions of the string using the currently selected font.\n\n`string` is the text string to measure, `descent` is the dimension from the baseline of\nthe font to the bottom of the descender, and `externalLeading` is any extra vertical space\nadded to the font by the font designer (usually is zero).\n\nThe text extent is returned in `w` and `h` pointers or as a {Width,Height} object\ndepending on which version of this function is used.\n\nIf the optional parameter `font` is specified and valid, then it is used for the text\nextent calculation. Otherwise the currently selected font is.\n\nIf `string` is empty, its extent is 0 in both directions, as expected.\n\nNote: This function only works with single-line strings.\n\nSee:\n* `m:wxFont`\n\n* `setFont/2`\n\n* `getPartialTextExtents/2`\n\n* `getMultiLineTextExtent/3`","ref":"wxDC.html#getTextExtent/3"},{"type":"function","title":"wxDC.getTextForeground/1","doc":"Gets the current text foreground colour.\n\nSee: `setTextForeground/2`","ref":"wxDC.html#getTextForeground/1"},{"type":"function","title":"wxDC.getUserScale/1","doc":"Gets the current user scale factor.\n\nSee: `setUserScale/3`","ref":"wxDC.html#getUserScale/1"},{"type":"function","title":"wxDC.gradientFillConcentric/4","doc":"Fill the area specified by rect with a radial gradient, starting from `initialColour` at\nthe centre of the circle and fading to `destColour` on the circle outside.\n\nThe circle is placed at the centre of `rect`.\n\nNote: Currently this function is very slow, don't use it for real-time drawing.","ref":"wxDC.html#gradientFillConcentric/4"},{"type":"function","title":"wxDC.gradientFillConcentric/5","doc":"Fill the area specified by rect with a radial gradient, starting from `initialColour` at\nthe centre of the circle and fading to `destColour` on the circle outside.\n\n`circleCenter` are the relative coordinates of centre of the circle in the specified `rect`.\n\nNote: Currently this function is very slow, don't use it for real-time drawing.","ref":"wxDC.html#gradientFillConcentric/5"},{"type":"function","title":"wxDC.gradientFillLinear/4","doc":"Equivalent to  gradientFillLinear(This, Rect, InitialColour, DestColour, []) .","ref":"wxDC.html#gradientFillLinear/4"},{"type":"function","title":"wxDC.gradientFillLinear/5","doc":"Fill the area specified by `rect` with a linear gradient, starting from `initialColour`\nand eventually fading to `destColour`.\n\nThe `nDirection` specifies the direction of the colour change, default is to use `initialColour`\non the left part of the rectangle and `destColour` on the right one.","ref":"wxDC.html#gradientFillLinear/5"},{"type":"function","title":"wxDC.isOk/1","doc":"Returns true if the DC is ok to use.","ref":"wxDC.html#isOk/1"},{"type":"function","title":"wxDC.logicalToDeviceX/2","doc":"Converts logical X coordinate to device coordinate, using the current mapping mode, user\nscale factor, device origin and axis orientation.","ref":"wxDC.html#logicalToDeviceX/2"},{"type":"function","title":"wxDC.logicalToDeviceXRel/2","doc":"Converts logical X coordinate to relative device coordinate, using the current mapping\nmode and user scale factor but ignoring the axis orientation.\n\nUse this for converting a width, for example.","ref":"wxDC.html#logicalToDeviceXRel/2"},{"type":"function","title":"wxDC.logicalToDeviceY/2","doc":"Converts logical Y coordinate to device coordinate, using the current mapping mode, user\nscale factor, device origin and axis orientation.","ref":"wxDC.html#logicalToDeviceY/2"},{"type":"function","title":"wxDC.logicalToDeviceYRel/2","doc":"Converts logical Y coordinate to relative device coordinate, using the current mapping\nmode and user scale factor but ignoring the axis orientation.\n\nUse this for converting a height, for example.","ref":"wxDC.html#logicalToDeviceYRel/2"},{"type":"function","title":"wxDC.maxX/1","doc":"Gets the maximum horizontal extent used in drawing commands so far.","ref":"wxDC.html#maxX/1"},{"type":"function","title":"wxDC.maxY/1","doc":"Gets the maximum vertical extent used in drawing commands so far.","ref":"wxDC.html#maxY/1"},{"type":"function","title":"wxDC.minX/1","doc":"Gets the minimum horizontal extent used in drawing commands so far.","ref":"wxDC.html#minX/1"},{"type":"function","title":"wxDC.minY/1","doc":"Gets the minimum vertical extent used in drawing commands so far.","ref":"wxDC.html#minY/1"},{"type":"function","title":"wxDC.resetBoundingBox/1","doc":"Resets the bounding box: after a call to this function, the bounding box doesn't contain\nanything.\n\nSee: `calcBoundingBox/3`","ref":"wxDC.html#resetBoundingBox/1"},{"type":"function","title":"wxDC.setAxisOrientation/3","doc":"Sets the x and y axis orientation (i.e. the direction from lowest to highest values on\nthe axis).\n\nThe default orientation is x axis from left to right and y axis from top down.","ref":"wxDC.html#setAxisOrientation/3"},{"type":"function","title":"wxDC.setBackground/2","doc":"Sets the current background brush for the DC.","ref":"wxDC.html#setBackground/2"},{"type":"function","title":"wxDC.setBackgroundMode/2","doc":"`mode` may be one of `wxPENSTYLE\\_SOLID` and `wxPENSTYLE\\_TRANSPARENT`.\n\nThis setting determines whether text will be drawn with a background colour or not.","ref":"wxDC.html#setBackgroundMode/2"},{"type":"function","title":"wxDC.setBrush/2","doc":"Sets the current brush for the DC.\n\nIf the argument is ?wxNullBrush (or another invalid brush; see `wxBrush:isOk/1`), the current brush is\nselected out of the device context (leaving `m:wxDC` without any valid brush), allowing\nthe current brush to be destroyed safely.\n\nSee:\n* `m:wxBrush`\n\n* `m:wxMemoryDC`","ref":"wxDC.html#setBrush/2"},{"type":"function","title":"wxDC.setClippingRegion/2","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#setClippingRegion/2"},{"type":"function","title":"wxDC.setClippingRegion/3","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxDC.html#setClippingRegion/3"},{"type":"function","title":"wxDC.setDeviceOrigin/3","doc":"Sets the device origin (i.e. the origin in pixels after scaling has been applied).\n\nThis function may be useful in Windows printing operations for placing a graphic on a\npage.","ref":"wxDC.html#setDeviceOrigin/3"},{"type":"function","title":"wxDC.setFont/2","doc":"Sets the current font for the DC.\n\nIf the argument is ?wxNullFont (or another invalid font; see `wxFont:isOk/1`), the current font is\nselected out of the device context (leaving `m:wxDC` without any valid font), allowing the\ncurrent font to be destroyed safely.\n\nSee: `m:wxFont`","ref":"wxDC.html#setFont/2"},{"type":"function","title":"wxDC.setLayoutDirection/2","doc":"Sets the current layout direction for the device context.\n\nSee: `getLayoutDirection/1`","ref":"wxDC.html#setLayoutDirection/2"},{"type":"function","title":"wxDC.setLogicalFunction/2","doc":"Sets the current logical function for the device context.\n\nNote: This function is not fully supported in all ports, due to the limitations of the\nunderlying drawing model. Notably, `wxINVERT` which was commonly used for drawing rubber\nbands or other moving outlines in the past, is not, and will not, be supported by wxGTK3\nand wxMac. The suggested alternative is to draw temporarily objects normally and refresh\nthe (affected part of the) window to remove them later.\n\nIt determines how a `source` pixel (from a pen or brush colour, or source device context\nif using `blit/6`) combines with a `destination` pixel in the current device context. Text drawing\nis not affected by this function.\n\nSee ?wxRasterOperationMode enumeration values for more info.\n\nThe default is `wxCOPY`, which simply draws with the current colour. The others combine\nthe current colour and the background using a logical operation.","ref":"wxDC.html#setLogicalFunction/2"},{"type":"function","title":"wxDC.setMapMode/2","doc":"The mapping mode of the device context defines the unit of measurement used to convert `logical`\nunits to `device` units.\n\nNote that in X, text drawing isn't handled consistently with the mapping mode; a font is\nalways specified in point size. However, setting the user scale (see `setUserScale/3`) scales the text\nappropriately. In Windows, scalable TrueType fonts are always used; in X, results depend\non availability of fonts, but usually a reasonable match is found.\n\nThe coordinate origin is always at the top left of the screen/printer.\n\nDrawing to a Windows printer device context uses the current mapping mode, but mapping\nmode is currently ignored for PostScript output.","ref":"wxDC.html#setMapMode/2"},{"type":"function","title":"wxDC.setPalette/2","doc":"If this is a window DC or memory DC, assigns the given palette to the window or bitmap\nassociated with the DC.\n\nIf the argument is ?wxNullPalette, the current palette is selected out of the device\ncontext, and the original palette restored.\n\nSee: `m:wxPalette`","ref":"wxDC.html#setPalette/2"},{"type":"function","title":"wxDC.setPen/2","doc":"Sets the current pen for the DC.\n\nIf the argument is ?wxNullPen (or another invalid pen; see `wxPen:isOk/1`), the current pen is selected\nout of the device context (leaving `m:wxDC` without any valid pen), allowing the current\npen to be destroyed safely.\n\nSee: `m:wxMemoryDC`","ref":"wxDC.html#setPen/2"},{"type":"function","title":"wxDC.setTextBackground/2","doc":"Sets the current text background colour for the DC.","ref":"wxDC.html#setTextBackground/2"},{"type":"function","title":"wxDC.setTextForeground/2","doc":"Sets the current text foreground colour for the DC.\n\nSee: `m:wxMemoryDC`","ref":"wxDC.html#setTextForeground/2"},{"type":"function","title":"wxDC.setUserScale/3","doc":"Sets the user scaling factor, useful for applications which require 'zooming'.","ref":"wxDC.html#setUserScale/3"},{"type":"function","title":"wxDC.startDoc/2","doc":"Starts a document (only relevant when outputting to a printer).\n\n`message` is a message to show while printing.","ref":"wxDC.html#startDoc/2"},{"type":"function","title":"wxDC.startPage/1","doc":"Starts a document page (only relevant when outputting to a printer).","ref":"wxDC.html#startPage/1"},{"type":"type","title":"wxDC.wxDC/0","doc":"","ref":"wxDC.html#t:wxDC/0"},{"type":"module","title":"wxDCOverlay","doc":"Connects an overlay with a drawing DC.\n\nSee:\n* `m:wxOverlay`\n\n* `m:wxDC`\n\nwxWidgets docs: [wxDCOverlay](https://docs.wxwidgets.org/3.2/classwx_d_c_overlay.html)","ref":"wxDCOverlay.html"},{"type":"function","title":"wxDCOverlay.clear/1","doc":"Clears the layer, restoring the state at the last init.","ref":"wxDCOverlay.html#clear/1"},{"type":"function","title":"wxDCOverlay.destroy/1","doc":"Destroys the object","ref":"wxDCOverlay.html#destroy/1"},{"type":"function","title":"wxDCOverlay.new/2","doc":"Convenience wrapper that behaves the same using the entire area of the dc.","ref":"wxDCOverlay.html#new/2"},{"type":"function","title":"wxDCOverlay.new/6","doc":"Connects this overlay to the corresponding drawing dc, if the overlay is not initialized\nyet this call will do so.","ref":"wxDCOverlay.html#new/6"},{"type":"type","title":"wxDCOverlay.wxDCOverlay/0","doc":"","ref":"wxDCOverlay.html#t:wxDCOverlay/0"},{"type":"module","title":"wxDataObject","doc":"A `m:wxDataObject` represents data that can be copied to or from the clipboard, or\ndragged and dropped.\n\nThe important thing about `m:wxDataObject` is that this is a 'smart' piece of data unlike\n'dumb' data containers such as memory buffers or files. Being 'smart' here means that the\ndata object itself should know what data formats it supports and how to render itself in\neach of its supported formats.\n\nA supported format, incidentally, is exactly the format in which the data can be\nrequested from a data object or from which the data object may be set. In the general\ncase, an object may support different formats on 'input' and 'output', i.e. it may be able\nto render itself in a given format but not be created from data on this format or vice\nversa. `m:wxDataObject` defines the `wxDataObject::Direction` (not implemented in wx)\nenumeration type which distinguishes between them.\n\nSee `wxDataFormat` (not implemented in wx) documentation for more about formats.\n\nNot surprisingly, being 'smart' comes at a price of added complexity. This is reasonable\nfor the situations when you really need to support multiple formats, but may be annoying\nif you only want to do something simple like cut and paste text.\n\nTo provide a solution for both cases, wxWidgets has two predefined classes which derive\nfrom `m:wxDataObject`: `wxDataObjectSimple` (not implemented in wx) and `wxDataObjectComposite`\n(not implemented in wx). `wxDataObjectSimple` (not implemented in wx) is the simplest `m:wxDataObject`\npossible and only holds data in a single format (such as HTML or text) and `wxDataObjectComposite`\n(not implemented in wx) is the simplest way to implement a `m:wxDataObject` that does\nsupport multiple formats because it achieves this by simply holding several `wxDataObjectSimple`\n(not implemented in wx) objects.\n\nSo, you have several solutions when you need a `m:wxDataObject` class (and you need one\nas soon as you want to transfer data via the clipboard or drag and drop):\n\nPlease note that the easiest way to use drag and drop and the clipboard with multiple\nformats is by using `wxDataObjectComposite` (not implemented in wx), but it is not the\nmost efficient one as each `wxDataObjectSimple` (not implemented in wx) would contain the\nwhole data in its respective formats. Now imagine that you want to paste 200 pages of text\nin your proprietary format, as well as Word, RTF, HTML, Unicode and plain text to the\nclipboard and even today's computers are in trouble. For this case, you will have to\nderive from `m:wxDataObject` directly and make it enumerate its formats and provide the\ndata in the requested format on demand.\n\nNote that neither the GTK+ data transfer mechanisms for clipboard and drag and drop, nor\nOLE data transfer, `copies` any data until another application actually requests the data.\nThis is in contrast to the 'feel' offered to the user of a program who would normally\nthink that the data resides in the clipboard after having pressed 'Copy' - in reality it\nis only declared to be `available`.\n\nYou may also derive your own data object classes from `wxCustomDataObject` (not\nimplemented in wx) for user-defined types. The format of user-defined data is given as a\nmime-type string literal, such as \"application/word\" or \"image/png\". These strings are\nused as they are under Unix (so far only GTK+) to identify a format and are translated\ninto their Windows equivalent under Win32 (using the OLE IDataObject for data exchange to\nand from the clipboard and for drag and drop). Note that the format string translation\nunder Windows is not yet finished.\n\nEach class derived directly from `m:wxDataObject` must override and implement all of its\nfunctions which are pure virtual in the base class. The data objects which only render\ntheir data or only set it (i.e. work in only one direction), should return 0 from `GetFormatCount()`\n(not implemented in wx).\n\nSee:\n* [Overview dnd](https://docs.wxwidgets.org/3.2/overview_dnd.html#overview_dnd)\n\n* [Examples](https://docs.wxwidgets.org/3.2/page_samples.html#page_samples_dnd)\n\n* `m:wxFileDataObject`\n\n* `m:wxTextDataObject`\n\n* `m:wxBitmapDataObject`\n\nwxWidgets docs: [wxDataObject](https://docs.wxwidgets.org/3.2/classwx_data_object.html)","ref":"wxDataObject.html"},{"type":"type","title":"wxDataObject.wxDataObject/0","doc":"","ref":"wxDataObject.html#t:wxDataObject/0"},{"type":"module","title":"wxDateEvent","doc":"This event class holds information about a date change and is used together with `m:wxDatePickerCtrl`.\n\nIt also serves as a base class for `m:wxCalendarEvent`.\n\nThis class is derived, and can use functions, from:\n\n* `m:wxCommandEvent`\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxDateEvent](https://docs.wxwidgets.org/3.2/classwx_date_event.html)","ref":"wxDateEvent.html"},{"type":"function","title":"wxDateEvent.getDate/1","doc":"Returns the date.","ref":"wxDateEvent.html#getDate/1"},{"type":"type","title":"wxDateEvent.wxDate/0","doc":"","ref":"wxDateEvent.html#t:wxDate/0"},{"type":"type","title":"wxDateEvent.wxDateEvent/0","doc":"","ref":"wxDateEvent.html#t:wxDateEvent/0"},{"type":"type","title":"wxDateEvent.wxDateEventType/0","doc":"","ref":"wxDateEvent.html#t:wxDateEventType/0"},{"type":"module","title":"wxDatePickerCtrl","doc":"This control allows the user to select a date.\n\nUnlike `m:wxCalendarCtrl`, which is a relatively big control, `m:wxDatePickerCtrl` is\nimplemented as a small window showing the currently selected date. The control can be\nedited using the keyboard, and can also display a popup window for more user-friendly date\nselection, depending on the styles used and the platform.\n\nIt is only available if `wxUSE_DATEPICKCTRL` is set to 1.","ref":"wxDatePickerCtrl.html"},{"type":"module","title":"Styles - wxDatePickerCtrl","doc":"This class supports the following styles:\n\n* wxDP_SPIN: Creates a control without a month calendar drop down but with\nspin-control-like arrows to change individual date components. This style is not supported\nby the generic version.\n\n* wxDP_DROPDOWN: Creates a control with a month calendar drop-down part from which the user\ncan select a date. This style is not supported in OSX/Cocoa native version.\n\n* wxDP_DEFAULT: Creates a control with the style that is best supported for the current\nplatform (currently wxDP_SPIN under Windows and OSX/Cocoa and wxDP_DROPDOWN elsewhere).\n\n* wxDP_ALLOWNONE: With this style, the control allows the user to not enter any valid date\nat all. Without it - the default - the control always has some valid date. This style is\nnot supported in OSX/Cocoa native version.\n\n* wxDP_SHOWCENTURY: Forces display of the century in the default date format. Without this\nstyle the century could be displayed, or not, depending on the default date representation\nin the system. This style is not supported in OSX/Cocoa native version currently. As can\nbe seen from the remarks above, most of the control style are only supported in the native\nMSW implementation. In portable code it's recommended to use `wxDP_DEFAULT` style only,\npossibly combined with `wxDP_SHOWCENTURY` (this is also the style used by default if none\nis specified).\n\nSee:\n* `m:wxCalendarCtrl`\n\n* `m:wxDateEvent`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxPickerBase`\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxDatePickerCtrl](https://docs.wxwidgets.org/3.2/classwx_date_picker_ctrl.html)","ref":"wxDatePickerCtrl.html#module-styles"},{"type":"module","title":"Events - wxDatePickerCtrl","doc":"Event types emitted from this class:\n\n* [`date_changed`](`m:wxDateEvent`)","ref":"wxDatePickerCtrl.html#module-events"},{"type":"function","title":"wxDatePickerCtrl.destroy/1","doc":"Destroys the object","ref":"wxDatePickerCtrl.html#destroy/1"},{"type":"function","title":"wxDatePickerCtrl.getRange/3","doc":"If the control had been previously limited to a range of dates using `setRange/3`,\nreturns the lower and upper bounds of this range.\n\nIf no range is set (or only one of the bounds is set), `dt1` and/or `dt2` are set to be invalid.\n\nNotice that when using a native MSW implementation of this control the lower range is\nalways set, even if `setRange/3` hadn't been called explicitly, as the native control only supports\ndates later than year 1601.\n\nReturn: false if no range limits are currently set, true if at least one bound is set.","ref":"wxDatePickerCtrl.html#getRange/3"},{"type":"function","title":"wxDatePickerCtrl.getValue/1","doc":"Returns the currently entered date.\n\nFor a control with `wxDP_ALLOWNONE` style the returned value may be invalid if no date is\nentered, otherwise it is always valid.","ref":"wxDatePickerCtrl.html#getValue/1"},{"type":"function","title":"wxDatePickerCtrl.new/0","doc":"Default constructor.","ref":"wxDatePickerCtrl.html#new/0"},{"type":"function","title":"wxDatePickerCtrl.new/2","doc":"Equivalent to  new(Parent, Id, []) .","ref":"wxDatePickerCtrl.html#new/2"},{"type":"function","title":"wxDatePickerCtrl.new/3","doc":"Initializes the object and calls `Create()` (not implemented in wx) with all the\nparameters.","ref":"wxDatePickerCtrl.html#new/3"},{"type":"function","title":"wxDatePickerCtrl.setRange/3","doc":"Sets the valid range for the date selection.\n\nIf `dt1` is valid, it becomes the earliest date (inclusive) accepted by the control. If `dt2`\nis valid, it becomes the latest possible date.\n\nNotice that if the current value is not inside the new range, it will be adjusted to lie\ninside it, i.e. calling this method can change the control value, however no events are\ngenerated by it.\n\nRemark: If the current value of the control is outside of the newly set range bounds, the\nbehaviour is undefined.","ref":"wxDatePickerCtrl.html#setRange/3"},{"type":"function","title":"wxDatePickerCtrl.setValue/2","doc":"Changes the current value of the control.\n\nThe date should be valid unless the control was created with `wxDP_ALLOWNONE` style and\nincluded in the currently selected range, if any.\n\nCalling this method does not result in a date change event.","ref":"wxDatePickerCtrl.html#setValue/2"},{"type":"type","title":"wxDatePickerCtrl.wxDatePickerCtrl/0","doc":"","ref":"wxDatePickerCtrl.html#t:wxDatePickerCtrl/0"},{"type":"module","title":"wxDialog","doc":"A dialog box is a window with a title bar and sometimes a system menu, which can be moved\naround the screen.\n\nIt can contain controls and other windows and is often used to allow the user to make\nsome choice or to answer a question.\n\nDialogs can be made scrollable, automatically, for computers with low resolution screens:\nplease see overview_dialog_autoscrolling for further details.\n\nDialogs usually contain either a single button allowing to close the dialog or two\nbuttons, one accepting the changes and the other one discarding them (such button, if\npresent, is automatically activated if the user presses the \"Esc\" key). By default,\nbuttons with the standard wxID_OK and wxID_CANCEL identifiers behave as expected. Starting\nwith wxWidgets 2.7 it is also possible to use a button with a different identifier\ninstead, see `setAffirmativeId/2` and `SetEscapeId()` (not implemented in wx).\n\nAlso notice that the `createButtonSizer/2` should be used to create the buttons appropriate for the current\nplatform and positioned correctly (including their order which is platform-dependent).\n\nModal and Modeless\n\nThere are two kinds of dialog, modal and modeless. A modal dialog blocks program flow and\nuser input on other windows until it is dismissed, whereas a modeless dialog behaves more\nlike a frame in that program flow continues, and input in other windows is still possible.\nTo show a modal dialog you should use the `showModal/1` method while to show a dialog modelessly you\nsimply use `show/2`, just as with frames.\n\nNote that the modal dialog is one of the very few examples of wxWindow-derived objects\nwhich may be created on the stack and not on the heap. In other words, while most windows\nwould be created like this:\n\nYou can achieve the same result with dialogs by using simpler code:\n\nAn application can define a `m:wxCloseEvent` handler for the dialog to respond to system\nclose events.","ref":"wxDialog.html"},{"type":"module","title":"Styles - wxDialog","doc":"This class supports the following styles:\n\n* wxCAPTION: Puts a caption on the dialog box.\n\n* wxDEFAULT_DIALOG_STYLE: Equivalent to a combination of wxCAPTION, wxCLOSE_BOX and\nwxSYSTEM_MENU (the last one is not used under Unix).\n\n* wxRESIZE_BORDER: Display a resizable frame around the window.\n\n* wxSYSTEM_MENU: Display a system menu.\n\n* wxCLOSE_BOX: Displays a close box on the frame.\n\n* wxMAXIMIZE_BOX: Displays a maximize box on the dialog.\n\n* wxMINIMIZE_BOX: Displays a minimize box on the dialog.\n\n* wxTHICK_FRAME: Display a thick frame around the window.\n\n* wxSTAY_ON_TOP: The dialog stays on top of all other windows.\n\n* wxNO_3D: This style is obsolete and doesn't do anything any more, don't use it in any new\ncode.\n\n* wxDIALOG_NO_PARENT: By default, a dialog created with a NULL parent window will be given\nthe `application's top level window` (not implemented in wx) as parent. Use this style to\nprevent this from happening and create an orphan dialog. This is not recommended for modal\ndialogs.\n\n* wxDIALOG_EX_CONTEXTHELP: Under Windows, puts a query button on the caption. When pressed,\nWindows will go into a context-sensitive help mode and wxWidgets will send a `wxEVT_HELP`\nevent if the user clicked on an application window. Note that this is an extended style\nand must be set by calling `wxWindow:setExtraStyle/2` before Create is called (two-step construction).\n\n* wxDIALOG_EX_METAL: On macOS, frames with this style will be shown with a metallic look.\nThis is an extra style. Under Unix or Linux, MWM (the Motif Window Manager) or other\nwindow managers recognizing the MHM hints should be running for any of these styles to\nhave an effect.\n\nSee:\n* [Overview dialog](https://docs.wxwidgets.org/3.2/overview_dialog.html#overview_dialog)\n\n* `m:wxFrame`\n\n* [Overview validator](https://docs.wxwidgets.org/3.2/overview_validator.html#overview_validator)\n\nThis class is derived, and can use functions, from:\n\n* `m:wxTopLevelWindow`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxDialog](https://docs.wxwidgets.org/3.2/classwx_dialog.html)","ref":"wxDialog.html#module-styles"},{"type":"module","title":"Events - wxDialog","doc":"Event types emitted from this class:\n\n* [`close_window`](`m:wxCloseEvent`)\n\n* [`init_dialog`](`m:wxInitDialogEvent`)","ref":"wxDialog.html#module-events"},{"type":"function","title":"wxDialog.create/4","doc":"Equivalent to  create(This, Parent, Id, Title, []) .","ref":"wxDialog.html#create/4"},{"type":"function","title":"wxDialog.create/5","doc":"Used for two-step dialog box construction.\n\nSee: `new/4`","ref":"wxDialog.html#create/5"},{"type":"function","title":"wxDialog.createButtonSizer/2","doc":"Creates a sizer with standard buttons.\n\n`flags` is a bit list of the following flags: wxOK, wxCANCEL, wxYES, wxNO, wxAPPLY,\nwxCLOSE, wxHELP, wxNO_DEFAULT.\n\nThe sizer lays out the buttons in a manner appropriate to the platform.\n\nThis function uses `createStdDialogButtonSizer/2` internally for most platforms but doesn't create the sizer at all for\nthe platforms with hardware buttons (such as smartphones) for which it sets up the\nhardware buttons appropriately and returns NULL, so don't forget to test that the return\nvalue is valid before using it.","ref":"wxDialog.html#createButtonSizer/2"},{"type":"function","title":"wxDialog.createStdDialogButtonSizer/2","doc":"Creates a `m:wxStdDialogButtonSizer` with standard buttons.\n\n`flags` is a bit list of the following flags: wxOK, wxCANCEL, wxYES, wxNO, wxAPPLY,\nwxCLOSE, wxHELP, wxNO_DEFAULT.\n\nThe sizer lays out the buttons in a manner appropriate to the platform.","ref":"wxDialog.html#createStdDialogButtonSizer/2"},{"type":"function","title":"wxDialog.destroy/1","doc":"Destroys the object","ref":"wxDialog.html#destroy/1"},{"type":"function","title":"wxDialog.endModal/2","doc":"Ends a modal dialog, passing a value to be returned from the `showModal/1` invocation.\n\nSee:\n* `showModal/1`\n\n* `getReturnCode/1`\n\n* `setReturnCode/2`","ref":"wxDialog.html#endModal/2"},{"type":"function","title":"wxDialog.getAffirmativeId/1","doc":"Gets the identifier of the button which works like standard OK button in this dialog.\n\nSee: `setAffirmativeId/2`","ref":"wxDialog.html#getAffirmativeId/1"},{"type":"function","title":"wxDialog.getReturnCode/1","doc":"Gets the return code for this window.\n\nRemark: A return code is normally associated with a modal dialog, where `showModal/1` returns a code\nto the application.\n\nSee:\n* `setReturnCode/2`\n\n* `showModal/1`\n\n* `endModal/2`","ref":"wxDialog.html#getReturnCode/1"},{"type":"function","title":"wxDialog.isModal/1","doc":"Returns true if the dialog box is modal, false otherwise.","ref":"wxDialog.html#isModal/1"},{"type":"function","title":"wxDialog.new/0","doc":"Default constructor.","ref":"wxDialog.html#new/0"},{"type":"function","title":"wxDialog.new/3","doc":"Equivalent to  new(Parent, Id, Title, []) .","ref":"wxDialog.html#new/3"},{"type":"function","title":"wxDialog.new/4","doc":"Constructor.\n\nSee: `create/5`","ref":"wxDialog.html#new/4"},{"type":"function","title":"wxDialog.setAffirmativeId/2","doc":"Sets the identifier to be used as OK button.\n\nWhen the button with this identifier is pressed, the dialog calls `wxWindow:validate/1` and `wxWindow:transferDataFromWindow/1` and, if they both\nreturn true, closes the dialog with the affirmative id return code.\n\nAlso, when the user presses a hardware OK button on the devices having one or the special\nOK button in the PocketPC title bar, an event with this id is generated.\n\nBy default, the affirmative id is wxID_OK.\n\nSee: `getAffirmativeId/1`","ref":"wxDialog.html#setAffirmativeId/2"},{"type":"function","title":"wxDialog.setReturnCode/2","doc":"Sets the return code for this window.\n\nA return code is normally associated with a modal dialog, where `showModal/1` returns a code to the\napplication. The function `endModal/2` calls `setReturnCode/2`.\n\nSee:\n* `getReturnCode/1`\n\n* `showModal/1`\n\n* `endModal/2`","ref":"wxDialog.html#setReturnCode/2"},{"type":"function","title":"wxDialog.show/1","doc":"Equivalent to  show(This, []) .","ref":"wxDialog.html#show/1"},{"type":"function","title":"wxDialog.show/2","doc":"Hides or shows the dialog.\n\nThe preferred way of dismissing a modal dialog is to use `endModal/2`.","ref":"wxDialog.html#show/2"},{"type":"function","title":"wxDialog.showModal/1","doc":"Shows an application-modal dialog.\n\nProgram flow does not return until the dialog has been dismissed with `endModal/2`.\n\nNotice that it is possible to call `showModal/1` for a dialog which had been previously shown with `show/2`,\nthis allows making an existing modeless dialog modal. However `showModal/1` can't be called twice\nwithout intervening `endModal/2` calls.\n\nNote that this function creates a temporary event loop which takes precedence over the\napplication's main event loop (see `wxEventLoopBase` (not implemented in wx)) and which is\ndestroyed when the dialog is dismissed. This also results in a call to `wxApp::ProcessPendingEvents()`\n(not implemented in wx).\n\nReturn: The value set with `setReturnCode/2`.\n\nSee:\n* `endModal/2`\n\n* `getReturnCode/1`\n\n* `setReturnCode/2`","ref":"wxDialog.html#showModal/1"},{"type":"type","title":"wxDialog.wxDialog/0","doc":"","ref":"wxDialog.html#t:wxDialog/0"},{"type":"module","title":"wxDirDialog","doc":"This class represents the directory chooser dialog.","ref":"wxDirDialog.html"},{"type":"module","title":"Styles - wxDirDialog","doc":"This class supports the following styles:\n\n* wxDD_DEFAULT_STYLE: Equivalent to a combination of wxDEFAULT_DIALOG_STYLE and\nwxRESIZE_BORDER.\n\n* wxDD_DIR_MUST_EXIST: The dialog will allow the user to choose only an existing folder.\nWhen this style is not given, a \"Create new directory\" button is added to the dialog (on\nWindows) or some other way is provided to the user to type the name of a new folder.\n\n* wxDD_CHANGE_DIR: Change the current working directory to the directory chosen by the\nuser.\n\nNote: This flag cannot be used with the `wxDD_MULTIPLE` style.\n\n* wxDD_MULTIPLE: Allow the user to select multiple directories. This flag is only\navailable since wxWidgets 3.1.4\n\n* wxDD_SHOW_HIDDEN: Show hidden and system folders. This flag is only available since\nwxWidgets 3.1.4 Notice that `wxRESIZE_BORDER` has special side effect under Windows where\ntwo different directory selection dialogs are available and this style also implicitly\nselects the new version as the old one always has fixed size. As the new version is almost\nalways preferable, it is recommended that `wxRESIZE_BORDER` style be always used. This is\nthe case if the dialog is created with the default style value but if you need to use any\nadditional styles you should still specify `wxDD_DEFAULT_STYLE` unless you explicitly need\nto use the old dialog version under Windows. E.g. do instead of just using `wxDD_DIR_MUST_EXIST`\nstyle alone.\n\nRemark: MacOS 10.11+ does not display a title bar on the dialog. Use `setMessage/2` to change the\nstring displayed to the user at the top of the dialog after creation. The `wxTopLevelWindow:setTitle/2` method is\nprovided for compatibility with pre-10.11 MacOS versions that do still support displaying\nthe title bar.\n\nSee:\n* [Overview cmndlg](https://docs.wxwidgets.org/3.2/overview_cmndlg.html#overview_cmndlg_dir)\n\n* `m:wxFileDialog`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxDialog`\n\n* `m:wxTopLevelWindow`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxDirDialog](https://docs.wxwidgets.org/3.2/classwx_dir_dialog.html)","ref":"wxDirDialog.html#module-styles"},{"type":"function","title":"wxDirDialog.destroy/1","doc":"Destroys the object","ref":"wxDirDialog.html#destroy/1"},{"type":"function","title":"wxDirDialog.getMessage/1","doc":"Returns the message that will be displayed on the dialog.","ref":"wxDirDialog.html#getMessage/1"},{"type":"function","title":"wxDirDialog.getPath/1","doc":"Returns the default or user-selected path.\n\nNote: This function can't be used with dialogs which have the `wxDD_MULTIPLE` style, use `GetPaths()`\n(not implemented in wx) instead.","ref":"wxDirDialog.html#getPath/1"},{"type":"function","title":"wxDirDialog.new/1","doc":"Equivalent to  new(Parent, []) .","ref":"wxDirDialog.html#new/1"},{"type":"function","title":"wxDirDialog.new/2","doc":"Constructor.\n\nUse `wxDialog:showModal/1` to show the dialog.","ref":"wxDirDialog.html#new/2"},{"type":"function","title":"wxDirDialog.setMessage/2","doc":"Sets the message that will be displayed on the dialog.","ref":"wxDirDialog.html#setMessage/2"},{"type":"function","title":"wxDirDialog.setPath/2","doc":"Sets the default path.","ref":"wxDirDialog.html#setPath/2"},{"type":"type","title":"wxDirDialog.wxDirDialog/0","doc":"","ref":"wxDirDialog.html#t:wxDirDialog/0"},{"type":"module","title":"wxDirPickerCtrl","doc":"This control allows the user to select a directory.\n\nThe generic implementation is a button which brings up a `m:wxDirDialog` when clicked.\nNative implementation may differ but this is usually a (small) widget which give access to\nthe dir-chooser dialog. It is only available if `wxUSE_DIRPICKERCTRL` is set to 1 (the default).","ref":"wxDirPickerCtrl.html"},{"type":"module","title":"Styles - wxDirPickerCtrl","doc":"This class supports the following styles:\n\n* wxDIRP_DEFAULT_STYLE: The default style: includes wxDIRP_DIR_MUST_EXIST and, under wxMSW\nonly, wxDIRP_USE_TEXTCTRL.\n\n* wxDIRP_USE_TEXTCTRL: Creates a text control to the left of the picker button which is\ncompletely managed by the `m:wxDirPickerCtrl` and which can be used by the user to specify\na path (see SetPath). The text control is automatically synchronized with button's value.\nUse functions defined in `m:wxPickerBase` to modify the text control.\n\n* wxDIRP_DIR_MUST_EXIST: Creates a picker which allows selecting only existing directories\nin the popup `m:wxDirDialog`. Notice that, as with `wxFLP_FILE_MUST_EXIST`, it is still\npossible to enter a non-existent directory even when this file is specified if `wxDIRP_USE_TEXTCTRL`\nstyle is also used. Also note that if `wxDIRP_USE_TEXTCTRL` is not used, the native wxGTK\nimplementation always uses this style as it doesn't support selecting non-existent\ndirectories.\n\n* wxDIRP_CHANGE_DIR: Change current working directory on each user directory selection\nchange.\n\n* wxDIRP_SMALL: Use smaller version of the control with a small \"...\" button instead of the\nnormal \"Browse\" one. This flag is new since wxWidgets 2.9.3.\n\nSee:\n* `m:wxDirDialog`\n\n* `m:wxFileDirPickerEvent`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxPickerBase`\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxDirPickerCtrl](https://docs.wxwidgets.org/3.2/classwx_dir_picker_ctrl.html)","ref":"wxDirPickerCtrl.html#module-styles"},{"type":"module","title":"Events - wxDirPickerCtrl","doc":"Event types emitted from this class:\n\n* [`command_dirpicker_changed`](`m:wxFileDirPickerEvent`)","ref":"wxDirPickerCtrl.html#module-events"},{"type":"function","title":"wxDirPickerCtrl.create/3","doc":"Equivalent to  create(This, Parent, Id, []) .","ref":"wxDirPickerCtrl.html#create/3"},{"type":"function","title":"wxDirPickerCtrl.create/4","doc":"Creates the widgets with the given parameters.\n\nReturn: true if the control was successfully created or false if creation failed.","ref":"wxDirPickerCtrl.html#create/4"},{"type":"function","title":"wxDirPickerCtrl.destroy/1","doc":"Destroys the object","ref":"wxDirPickerCtrl.html#destroy/1"},{"type":"function","title":"wxDirPickerCtrl.getPath/1","doc":"Returns the absolute path of the currently selected directory.","ref":"wxDirPickerCtrl.html#getPath/1"},{"type":"function","title":"wxDirPickerCtrl.new/0","doc":"","ref":"wxDirPickerCtrl.html#new/0"},{"type":"function","title":"wxDirPickerCtrl.new/2","doc":"Equivalent to  new(Parent, Id, []) .","ref":"wxDirPickerCtrl.html#new/2"},{"type":"function","title":"wxDirPickerCtrl.new/3","doc":"Initializes the object and calls `create/4` with all the parameters.","ref":"wxDirPickerCtrl.html#new/3"},{"type":"function","title":"wxDirPickerCtrl.setPath/2","doc":"Sets the absolute path of the currently selected directory.\n\nIf the control uses `wxDIRP_DIR_MUST_EXIST` and does not use `wxDIRP_USE_TEXTCTRL` style,\nthe `dirname` must be a name of an existing directory and will be simply ignored by the\nnative wxGTK implementation if this is not the case.","ref":"wxDirPickerCtrl.html#setPath/2"},{"type":"type","title":"wxDirPickerCtrl.wxDirPickerCtrl/0","doc":"","ref":"wxDirPickerCtrl.html#t:wxDirPickerCtrl/0"},{"type":"module","title":"wxDisplay","doc":"Determines the sizes and locations of displays connected to the system.\n\nwxWidgets docs: [wxDisplay](https://docs.wxwidgets.org/3.2/classwx_display.html)","ref":"wxDisplay.html"},{"type":"function","title":"wxDisplay.destroy/1","doc":"Destroys the object","ref":"wxDisplay.html#destroy/1"},{"type":"function","title":"wxDisplay.getClientArea/1","doc":"Returns the client area of the display.\n\nThe client area is the part of the display available for the normal (non full screen)\nwindows, usually it is the same as `getGeometry/1` but it could be less if there is a taskbar (or\nequivalent) on this display.","ref":"wxDisplay.html#getClientArea/1"},{"type":"function","title":"wxDisplay.getCount/0","doc":"Returns the number of connected displays.","ref":"wxDisplay.html#getCount/0"},{"type":"function","title":"wxDisplay.getFromPoint/1","doc":"Returns the index of the display on which the given point lies, or `wxNOT\\_FOUND` if the\npoint is not on any connected display.","ref":"wxDisplay.html#getFromPoint/1"},{"type":"function","title":"wxDisplay.getFromWindow/1","doc":"Returns the index of the display on which the given window lies.\n\nIf the window is on more than one display it gets the display that overlaps the window\nthe most.\n\nReturns `wxNOT_FOUND` if the window is not on any connected display.","ref":"wxDisplay.html#getFromWindow/1"},{"type":"function","title":"wxDisplay.getGeometry/1","doc":"Returns the bounding rectangle of the display whose index was passed to the constructor.\n\nSee:\n* `getClientArea/1`\n\n* `wx_misc:displaySize/0`","ref":"wxDisplay.html#getGeometry/1"},{"type":"function","title":"wxDisplay.getName/1","doc":"Returns the display's name.\n\nThe returned value is currently an empty string under all platforms except MSW.","ref":"wxDisplay.html#getName/1"},{"type":"function","title":"wxDisplay.getPPI/1","doc":"Returns display resolution in pixels per inch.\n\nHorizontal and vertical resolution are returned in `x` and `y` components of the\n{Width,Height} object respectively.\n\nIf the resolution information is not available, returns.\n\nSince: 3.1.2","ref":"wxDisplay.html#getPPI/1"},{"type":"function","title":"wxDisplay.isOk/1","doc":"Returns true if the object was initialized successfully.","ref":"wxDisplay.html#isOk/1"},{"type":"function","title":"wxDisplay.isPrimary/1","doc":"Returns true if the display is the primary display.\n\nThe primary display is the one whose index is 0.","ref":"wxDisplay.html#isPrimary/1"},{"type":"function","title":"wxDisplay.new/0","doc":"Default constructor creating `m:wxDisplay` object representing the primary display.","ref":"wxDisplay.html#new/0"},{"type":"function","title":"wxDisplay.new/1","doc":"Constructor creating the display object associated with the given window.\n\nThis is the most convenient way of finding the display on which the given window is shown\nwhile falling back to the default display if it is not shown at all or positioned outside\nof any display.\n\nSee: `getFromWindow/1`\n\nSince: 3.1.2","ref":"wxDisplay.html#new/1"},{"type":"type","title":"wxDisplay.wxDisplay/0","doc":"","ref":"wxDisplay.html#t:wxDisplay/0"},{"type":"module","title":"wxDisplayChangedEvent","doc":"A display changed event is sent to top-level windows when the display resolution has\nchanged.\n\nThis event is currently emitted under Windows only.\n\nSee: `m:wxDisplay`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxDisplayChangedEvent](https://docs.wxwidgets.org/3.2/classwx_display_changed_event.html)","ref":"wxDisplayChangedEvent.html"},{"type":"module","title":"Events - wxDisplayChangedEvent","doc":"Use `wxEvtHandler:connect/3` with `wxDisplayChangedEventType` to subscribe to events of this type.","ref":"wxDisplayChangedEvent.html#module-events"},{"type":"type","title":"wxDisplayChangedEvent.wxDisplayChanged/0","doc":"","ref":"wxDisplayChangedEvent.html#t:wxDisplayChanged/0"},{"type":"type","title":"wxDisplayChangedEvent.wxDisplayChangedEvent/0","doc":"","ref":"wxDisplayChangedEvent.html#t:wxDisplayChangedEvent/0"},{"type":"type","title":"wxDisplayChangedEvent.wxDisplayChangedEventType/0","doc":"","ref":"wxDisplayChangedEvent.html#t:wxDisplayChangedEventType/0"},{"type":"module","title":"wxDropFilesEvent","doc":"This class is used for drop files events, that is, when files have been dropped onto the\nwindow.\n\nThe window must have previously been enabled for dropping by calling `wxWindow:dragAcceptFiles/2`.\n\nImportant note: this is a separate implementation to the more general drag and drop\nimplementation documented in the overview_dnd. It uses the older, Windows message-based\napproach of dropping files.\n\nSee:\n* [Overview events](https://docs.wxwidgets.org/3.2/overview_events.html#overview_events)\n\n* `wxWindow:dragAcceptFiles/2`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxDropFilesEvent](https://docs.wxwidgets.org/3.2/classwx_drop_files_event.html)","ref":"wxDropFilesEvent.html"},{"type":"module","title":"Events - wxDropFilesEvent","doc":"Use `wxEvtHandler:connect/3` with `wxDropFilesEventType` to subscribe to events of this type.","ref":"wxDropFilesEvent.html#module-events"},{"type":"function","title":"wxDropFilesEvent.getFiles/1","doc":"Returns an array of filenames.","ref":"wxDropFilesEvent.html#getFiles/1"},{"type":"function","title":"wxDropFilesEvent.getNumberOfFiles/1","doc":"Returns the number of files dropped.","ref":"wxDropFilesEvent.html#getNumberOfFiles/1"},{"type":"function","title":"wxDropFilesEvent.getPosition/1","doc":"Returns the position at which the files were dropped.\n\nReturns an array of filenames.","ref":"wxDropFilesEvent.html#getPosition/1"},{"type":"type","title":"wxDropFilesEvent.wxDropFiles/0","doc":"","ref":"wxDropFilesEvent.html#t:wxDropFiles/0"},{"type":"type","title":"wxDropFilesEvent.wxDropFilesEvent/0","doc":"","ref":"wxDropFilesEvent.html#t:wxDropFilesEvent/0"},{"type":"type","title":"wxDropFilesEvent.wxDropFilesEventType/0","doc":"","ref":"wxDropFilesEvent.html#t:wxDropFilesEventType/0"},{"type":"module","title":"wxEraseEvent","doc":"An erase event is sent when a window's background needs to be repainted.\n\nOn some platforms, such as GTK+, this event is simulated (simply generated just before\nthe paint event) and may cause flicker. It is therefore recommended that you set the text\nbackground colour explicitly in order to prevent flicker. The default background colour\nunder GTK+ is grey.\n\nTo intercept this event, use the EVT_ERASE_BACKGROUND macro in an event table definition.\n\nYou must use the device context returned by `getDC/1` to draw on, don't create a `m:wxPaintDC` in\nthe event handler.\n\nSee: [Overview events](https://docs.wxwidgets.org/3.2/overview_events.html#overview_events)\n\nThis class is derived, and can use functions, from:\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxEraseEvent](https://docs.wxwidgets.org/3.2/classwx_erase_event.html)","ref":"wxEraseEvent.html"},{"type":"module","title":"Events - wxEraseEvent","doc":"Use `wxEvtHandler:connect/3` with `wxEraseEventType` to subscribe to events of this type.","ref":"wxEraseEvent.html#module-events"},{"type":"function","title":"wxEraseEvent.getDC/1","doc":"Returns the device context associated with the erase event to draw on.\n\nThe returned pointer is never NULL.","ref":"wxEraseEvent.html#getDC/1"},{"type":"type","title":"wxEraseEvent.wxErase/0","doc":"","ref":"wxEraseEvent.html#t:wxErase/0"},{"type":"type","title":"wxEraseEvent.wxEraseEvent/0","doc":"","ref":"wxEraseEvent.html#t:wxEraseEvent/0"},{"type":"type","title":"wxEraseEvent.wxEraseEventType/0","doc":"","ref":"wxEraseEvent.html#t:wxEraseEventType/0"},{"type":"module","title":"wxEvent","doc":"An event is a structure holding information about an event passed to a callback or member\nfunction.\n\n`m:wxEvent` used to be a multipurpose event object, and is an abstract base class for\nother event classes (see below).\n\nFor more information about events, see the overview_events overview.\n\nSee:\n* `m:wxCommandEvent`\n\n* `m:wxMouseEvent`\n\nwxWidgets docs: [wxEvent](https://docs.wxwidgets.org/3.2/classwx_event.html)","ref":"wxEvent.html"},{"type":"function","title":"wxEvent.getId/1","doc":"Returns the identifier associated with this event, such as a button command id.","ref":"wxEvent.html#getId/1"},{"type":"function","title":"wxEvent.getSkipped/1","doc":"Returns true if the event handler should be skipped, false otherwise.","ref":"wxEvent.html#getSkipped/1"},{"type":"function","title":"wxEvent.getTimestamp/1","doc":"Gets the timestamp for the event.\n\nThe timestamp is the time in milliseconds since some fixed moment (not necessarily the\nstandard Unix Epoch, so only differences between the timestamps and not their absolute\nvalues usually make sense).\n\nWarning:\n\nwxWidgets returns a non-NULL timestamp only for mouse and key events (see `m:wxMouseEvent`\nand `m:wxKeyEvent`).","ref":"wxEvent.html#getTimestamp/1"},{"type":"function","title":"wxEvent.isCommandEvent/1","doc":"Returns true if the event is or is derived from `m:wxCommandEvent` else it returns false.\n\nNote: exists only for optimization purposes.","ref":"wxEvent.html#isCommandEvent/1"},{"type":"function","title":"wxEvent.resumePropagation/2","doc":"Sets the propagation level to the given value (for example returned from an earlier call\nto `stopPropagation/1`).","ref":"wxEvent.html#resumePropagation/2"},{"type":"function","title":"wxEvent.shouldPropagate/1","doc":"Test if this event should be propagated or not, i.e. if the propagation level is\ncurrently greater than 0.","ref":"wxEvent.html#shouldPropagate/1"},{"type":"function","title":"wxEvent.skip/1","doc":"Equivalent to  skip(This, []) .","ref":"wxEvent.html#skip/1"},{"type":"function","title":"wxEvent.skip/2","doc":"This method can be used inside an event handler to control whether further event handlers\nbound to this event will be called after the current one returns.\n\nWithout `skip/2` (or equivalently if Skip(false) is used), the event will not be processed any\nmore. If Skip(true) is called, the event processing system continues searching for a\nfurther handler function for this event, even though it has been processed already in the\ncurrent handler.\n\nIn general, it is recommended to skip all non-command events to allow the default\nhandling to take place. The command events are, however, normally not skipped as usually a\nsingle command such as a button click or menu item selection must only be processed by one\nhandler.","ref":"wxEvent.html#skip/2"},{"type":"function","title":"wxEvent.stopPropagation/1","doc":"Stop the event from propagating to its parent window.\n\nReturns the old propagation level value which may be later passed to `resumePropagation/2` to allow\npropagating the event again.","ref":"wxEvent.html#stopPropagation/1"},{"type":"type","title":"wxEvent.wxEvent/0","doc":"","ref":"wxEvent.html#t:wxEvent/0"},{"type":"module","title":"wxEvtHandler","doc":"The Event handler\n\nA class that can handle events from the windowing system. `m:wxWindow` is (and\ntherefore all window classes are) derived from this class.\n\nTo get events from wxwidgets objects you subscribe to them by calling `connect/3`.\n\nIf the `callback` option is not supplied events are sent as messages.\n\nThese messages will be `#wx{}` where `EventRecord` is a record that depends on\nthe `wxEventType`. The records are defined in: `wx/include/wx.hrl`.\n\nIf a callback was supplied to connect, the callback will be invoked (in another\nprocess) to handle the event. The callback should be of arity 2.\n\n`fun Callback (EventRecord::wx(), EventObject::wxObject()).`\n\nNote: The callback will be in executed in new process each time.\n\nSee:\n[Overview events](https://docs.wxwidgets.org/3.2/overview_events.html#overview_events_processing)\n\nwxWidgets docs:\n[wxEvtHandler](https://docs.wxwidgets.org/3.2/classwx_evt_handler.html)","ref":"wxEvtHandler.html"},{"type":"function","title":"wxEvtHandler.connect/2","doc":"Equivalent to  connect(This, EventType, []) .","ref":"wxEvtHandler.html#connect/2"},{"type":"function","title":"wxEvtHandler.connect/3","doc":"This function subscribes to events.\n\nSubscribes to events of type `EventType`, in the range `id`, `lastId`.\n\nThe events will be received as messages if no callback is supplied.\n\nOptions\n\nid:`{id, integer()} `The identifier (or first of the identifier range) to be\nassociated with this event handler. Default is ?wxID_ANY\n\nlastid:`{lastId,integer()} `The second part of the identifier range. If used\n'id' must be set as the starting identifier range. Default is ?wxID_ANY\n\nskip:`{skip,boolean()} `If skip is true further event_handlers will be called.\nThis is not used if the 'callback' option is used. Default is `false`.\n\ncallback:`{callback,function()} `Use a\ncallback`fun(EventRecord::wx(),EventObject::wxObject()) `to process the event.\nDefault not specified i.e. a message will be delivered to the process calling\nthis function.\n\nuserData:`{userData,term()} `An erlang term that will be sent with the event.\nDefault: [].","ref":"wxEvtHandler.html#connect/3"},{"type":"function","title":"wxEvtHandler.disconnect/1","doc":"Equivalent to  disconnect(This, null, []) .","ref":"wxEvtHandler.html#disconnect/1"},{"type":"function","title":"wxEvtHandler.disconnect/2","doc":"Equivalent to  disconnect(This, EventType, []) .","ref":"wxEvtHandler.html#disconnect/2"},{"type":"function","title":"wxEvtHandler.disconnect/3","doc":"This function unsubscribes the process or callback fun from the event handler.\n\nEventType may be the atom 'null' to match any eventtype. Notice that the options\nskip and userdata is not used to match the eventhandler.","ref":"wxEvtHandler.html#disconnect/3"},{"type":"type","title":"wxEvtHandler.event/0","doc":"","ref":"wxEvtHandler.html#t:event/0"},{"type":"type","title":"wxEvtHandler.wx/0","doc":"","ref":"wxEvtHandler.html#t:wx/0"},{"type":"type","title":"wxEvtHandler.wxEventType/0","doc":"","ref":"wxEvtHandler.html#t:wxEventType/0"},{"type":"type","title":"wxEvtHandler.wxEvtHandler/0","doc":"","ref":"wxEvtHandler.html#t:wxEvtHandler/0"},{"type":"module","title":"wxFileDataObject","doc":"`m:wxFileDataObject` is a specialization of `m:wxDataObject` for file names.\n\nThe program works with it just as if it were a list of absolute file names, but\ninternally it uses the same format as Explorer and other compatible programs under Windows\nor GNOME/KDE file manager under Unix which makes it possible to receive files from them\nusing this class.\n\nSee:\n* `m:wxDataObject`\n\n* `m:wxTextDataObject`\n\n* `m:wxBitmapDataObject`\n\n* `m:wxDataObject`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxDataObject`\n\nwxWidgets docs: [wxFileDataObject](https://docs.wxwidgets.org/3.2/classwx_file_data_object.html)","ref":"wxFileDataObject.html"},{"type":"function","title":"wxFileDataObject.addFile/2","doc":"Adds a file to the file list represented by this data object (Windows only).","ref":"wxFileDataObject.html#addFile/2"},{"type":"function","title":"wxFileDataObject.destroy/1","doc":"Destroys the object","ref":"wxFileDataObject.html#destroy/1"},{"type":"function","title":"wxFileDataObject.getFilenames/1","doc":"Returns the array of file names.","ref":"wxFileDataObject.html#getFilenames/1"},{"type":"function","title":"wxFileDataObject.new/0","doc":"Constructor.","ref":"wxFileDataObject.html#new/0"},{"type":"type","title":"wxFileDataObject.wxFileDataObject/0","doc":"","ref":"wxFileDataObject.html#t:wxFileDataObject/0"},{"type":"module","title":"wxFileDialog","doc":"This class represents the file chooser dialog.\n\nThe path and filename are distinct elements of a full file pathname. If path is\n?wxEmptyString, the current directory will be used. If filename is ?wxEmptyString, no\ndefault filename will be supplied. The wildcard determines what files are displayed in the\nfile selector, and file extension supplies a type extension for the required filename.\n\nThe typical usage for the open file dialog is:\n\nThe typical usage for the save file dialog is instead somewhat simpler:\n\nRemark: All implementations of the `m:wxFileDialog` provide a wildcard filter. Typing a\nfilename containing wildcards (*, ?) in the filename text item, and clicking on Ok, will\nresult in only those files matching the pattern being displayed. The wildcard may be a\nspecification for multiple types of file with a description for each, such as: It must be\nnoted that wildcard support in the native Motif file dialog is quite limited: only one\nfile type is supported, and it is displayed without the descriptive test; \"BMP files\n(*.bmp)|*.bmp\" is displayed as \"*.bmp\", and both \"BMP files (*.bmp)|*.bmp|GIF files\n(*.gif)|*.gif\" and \"Image files|*.bmp;*.gif\" are errors. On Mac macOS in the open file\ndialog the filter choice box is not shown by default. Instead all given wildcards are\nappplied at the same time: So in the above example all bmp, gif and png files are\ndisplayed. To enforce the display of the filter choice set the corresponding `m:wxSystemOptions`\nbefore calling the file open dialog: But in contrast to Windows and Unix, where the file\ntype choice filters only the selected files, on Mac macOS even in this case the dialog\nshows all files matching all file types. The files which does not match the currently\nselected file type are greyed out and are not selectable.","ref":"wxFileDialog.html"},{"type":"module","title":"Styles - wxFileDialog","doc":"This class supports the following styles:\n\n* wxFD_DEFAULT_STYLE: Equivalent to `wxFD_OPEN`.\n\n* wxFD_OPEN: This is an open dialog; usually this means that the default button's label of\nthe dialog is \"Open\". Cannot be combined with `wxFD_SAVE`.\n\n* wxFD_SAVE: This is a save dialog; usually this means that the default button's label of\nthe dialog is \"Save\". Cannot be combined with `wxFD_OPEN`.\n\n* wxFD_OVERWRITE_PROMPT: For save dialog only: prompt for a confirmation if a file will be\noverwritten.\n\n* wxFD_NO_FOLLOW: Directs the dialog to return the path and file name of the selected\nshortcut file, not its target as it does by default. Currently this flag is only\nimplemented in wxMSW and wxOSX (where it prevents aliases from being resolved). The\nnon-dereferenced link path is always returned, even without this flag, under Unix and so\nusing it there doesn't do anything. This flag was added in wxWidgets 3.1.0.\n\n* wxFD_FILE_MUST_EXIST: For open dialog only: the user may only select files that actually\nexist. Notice that under macOS the file dialog with `wxFD_OPEN` style always behaves as if\nthis style was specified, because it is impossible to choose a file that doesn't exist\nfrom a standard macOS file dialog.\n\n* wxFD_MULTIPLE: For open dialog only: allows selecting multiple files.\n\n* wxFD_CHANGE_DIR: Change the current working directory (when the dialog is dismissed) to\nthe directory where the file(s) chosen by the user are.\n\n* wxFD_PREVIEW: Show the preview of the selected files (currently only supported by wxGTK).\n\n* wxFD_SHOW_HIDDEN: Show hidden files. This flag was added in wxWidgets 3.1.3\n\nSee:\n* [Overview cmndlg](https://docs.wxwidgets.org/3.2/overview_cmndlg.html#overview_cmndlg_file)\n\n* ?wxFileSelector()\n\nThis class is derived, and can use functions, from:\n\n* `m:wxDialog`\n\n* `m:wxTopLevelWindow`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxFileDialog](https://docs.wxwidgets.org/3.2/classwx_file_dialog.html)","ref":"wxFileDialog.html#module-styles"},{"type":"function","title":"wxFileDialog.destroy/1","doc":"Destroys the object","ref":"wxFileDialog.html#destroy/1"},{"type":"function","title":"wxFileDialog.getDirectory/1","doc":"Returns the default directory.","ref":"wxFileDialog.html#getDirectory/1"},{"type":"function","title":"wxFileDialog.getFilename/1","doc":"Returns the default filename.\n\nNote: This function can't be used with dialogs which have the `wxFD_MULTIPLE` style, use `getFilenames/1`\ninstead.","ref":"wxFileDialog.html#getFilename/1"},{"type":"function","title":"wxFileDialog.getFilenames/1","doc":"Fills the array `filenames` with the names of the files chosen.\n\nThis function should only be used with the dialogs which have `wxFD_MULTIPLE` style, use `getFilename/1`\nfor the others.\n\nNote that under Windows, if the user selects shortcuts, the filenames include paths,\nsince the application cannot determine the full path of each referenced file by appending\nthe directory containing the shortcuts to the filename.","ref":"wxFileDialog.html#getFilenames/1"},{"type":"function","title":"wxFileDialog.getFilterIndex/1","doc":"Returns the index into the list of filters supplied, optionally, in the wildcard\nparameter.\n\nBefore the dialog is shown, this is the index which will be used when the dialog is first displayed.\n\nAfter the dialog is shown, this is the index selected by the user.","ref":"wxFileDialog.html#getFilterIndex/1"},{"type":"function","title":"wxFileDialog.getMessage/1","doc":"Returns the message that will be displayed on the dialog.","ref":"wxFileDialog.html#getMessage/1"},{"type":"function","title":"wxFileDialog.getPath/1","doc":"Returns the full path (directory and filename) of the selected file.\n\nNote: This function can't be used with dialogs which have the `wxFD_MULTIPLE` style, use `getPaths/1`\ninstead.","ref":"wxFileDialog.html#getPath/1"},{"type":"function","title":"wxFileDialog.getPaths/1","doc":"Fills the array `paths` with the full paths of the files chosen.\n\nThis function should only be used with the dialogs which have `wxFD_MULTIPLE` style, use `getPath/1`\nfor the others.","ref":"wxFileDialog.html#getPaths/1"},{"type":"function","title":"wxFileDialog.getWildcard/1","doc":"Returns the file dialog wildcard.","ref":"wxFileDialog.html#getWildcard/1"},{"type":"function","title":"wxFileDialog.new/1","doc":"Equivalent to  new(Parent, []) .","ref":"wxFileDialog.html#new/1"},{"type":"function","title":"wxFileDialog.new/2","doc":"Constructor.\n\nUse `wxDialog:showModal/1` to show the dialog.","ref":"wxFileDialog.html#new/2"},{"type":"function","title":"wxFileDialog.setDirectory/2","doc":"Sets the default directory.","ref":"wxFileDialog.html#setDirectory/2"},{"type":"function","title":"wxFileDialog.setFilename/2","doc":"Sets the default filename.\n\nIn wxGTK this will have little effect unless a default directory has previously been set.","ref":"wxFileDialog.html#setFilename/2"},{"type":"function","title":"wxFileDialog.setFilterIndex/2","doc":"Sets the default filter index, starting from zero.","ref":"wxFileDialog.html#setFilterIndex/2"},{"type":"function","title":"wxFileDialog.setMessage/2","doc":"Sets the message that will be displayed on the dialog.","ref":"wxFileDialog.html#setMessage/2"},{"type":"function","title":"wxFileDialog.setPath/2","doc":"Sets the path (the combined directory and filename that will be returned when the dialog\nis dismissed).","ref":"wxFileDialog.html#setPath/2"},{"type":"function","title":"wxFileDialog.setWildcard/2","doc":"Sets the wildcard, which can contain multiple file types, for example: \"BMP files\n(\\*.bmp)|\\*.bmp|GIF files (\\*.gif)|\\*.gif\".\n\nNote that the native Motif dialog has some limitations with respect to wildcards; see the\nRemarks section above.","ref":"wxFileDialog.html#setWildcard/2"},{"type":"type","title":"wxFileDialog.wxFileDialog/0","doc":"","ref":"wxFileDialog.html#t:wxFileDialog/0"},{"type":"module","title":"wxFileDirPickerEvent","doc":"This event class is used for the events generated by `m:wxFilePickerCtrl` and by `m:wxDirPickerCtrl`.\n\nSee:\n* `m:wxFilePickerCtrl`\n\n* `m:wxDirPickerCtrl`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxCommandEvent`\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxFileDirPickerEvent](https://docs.wxwidgets.org/3.2/classwx_file_dir_picker_event.html)","ref":"wxFileDirPickerEvent.html"},{"type":"module","title":"Events - wxFileDirPickerEvent","doc":"Use `wxEvtHandler:connect/3` with `wxFileDirPickerEventType` to subscribe to events of this type.","ref":"wxFileDirPickerEvent.html#module-events"},{"type":"function","title":"wxFileDirPickerEvent.getPath/1","doc":"Retrieve the absolute path of the file/directory the user has just selected.","ref":"wxFileDirPickerEvent.html#getPath/1"},{"type":"type","title":"wxFileDirPickerEvent.wxFileDirPicker/0","doc":"","ref":"wxFileDirPickerEvent.html#t:wxFileDirPicker/0"},{"type":"type","title":"wxFileDirPickerEvent.wxFileDirPickerEvent/0","doc":"","ref":"wxFileDirPickerEvent.html#t:wxFileDirPickerEvent/0"},{"type":"type","title":"wxFileDirPickerEvent.wxFileDirPickerEventType/0","doc":"","ref":"wxFileDirPickerEvent.html#t:wxFileDirPickerEventType/0"},{"type":"module","title":"wxFilePickerCtrl","doc":"This control allows the user to select a file.\n\nThe generic implementation is a button which brings up a `m:wxFileDialog` when clicked.\nNative implementation may differ but this is usually a (small) widget which give access to\nthe file-chooser dialog. It is only available if `wxUSE_FILEPICKERCTRL` is set to 1 (the default).","ref":"wxFilePickerCtrl.html"},{"type":"module","title":"Styles - wxFilePickerCtrl","doc":"This class supports the following styles:\n\n* wxFLP_DEFAULT_STYLE: The default style: includes wxFLP_OPEN | wxFLP_FILE_MUST_EXIST and,\nunder wxMSW and wxOSX, wxFLP_USE_TEXTCTRL.\n\n* wxFLP_USE_TEXTCTRL: Creates a text control to the left of the picker button which is\ncompletely managed by the `m:wxFilePickerCtrl` and which can be used by the user to\nspecify a path (see SetPath). The text control is automatically synchronized with button's\nvalue. Use functions defined in `m:wxPickerBase` to modify the text control.\n\n* wxFLP_OPEN: Creates a picker which allows the user to select a file to open.\n\n* wxFLP_SAVE: Creates a picker which allows the user to select a file to save.\n\n* wxFLP_OVERWRITE_PROMPT: Can be combined with wxFLP_SAVE only: ask confirmation to the\nuser before selecting a file.\n\n* wxFLP_FILE_MUST_EXIST: Can be combined with wxFLP_OPEN only: the file selected in the\npopup `m:wxFileDialog` must be an existing file. Notice that it still remains possible for\nthe user to enter a non-existent file name in the text control if `wxFLP_USE_TEXTCTRL` is\nalso used, this flag is a hint for the user rather than a guarantee that the selected file\ndoes exist for the program.\n\n* wxFLP_CHANGE_DIR: Change current working directory on each user file selection change.\n\n* wxFLP_SMALL: Use smaller version of the control with a small \"...\" button instead of the\nnormal \"Browse\" one. This flag is new since wxWidgets 2.9.3.\n\nSee:\n* `m:wxFileDialog`\n\n* `m:wxFileDirPickerEvent`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxPickerBase`\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxFilePickerCtrl](https://docs.wxwidgets.org/3.2/classwx_file_picker_ctrl.html)","ref":"wxFilePickerCtrl.html#module-styles"},{"type":"module","title":"Events - wxFilePickerCtrl","doc":"Event types emitted from this class:\n\n* [`command_filepicker_changed`](`m:wxFileDirPickerEvent`)","ref":"wxFilePickerCtrl.html#module-events"},{"type":"function","title":"wxFilePickerCtrl.create/3","doc":"Equivalent to  create(This, Parent, Id, []) .","ref":"wxFilePickerCtrl.html#create/3"},{"type":"function","title":"wxFilePickerCtrl.create/4","doc":"Creates this widget with the given parameters.\n\nReturn: true if the control was successfully created or false if creation failed.","ref":"wxFilePickerCtrl.html#create/4"},{"type":"function","title":"wxFilePickerCtrl.destroy/1","doc":"Destroys the object","ref":"wxFilePickerCtrl.html#destroy/1"},{"type":"function","title":"wxFilePickerCtrl.getPath/1","doc":"Returns the absolute path of the currently selected file.","ref":"wxFilePickerCtrl.html#getPath/1"},{"type":"function","title":"wxFilePickerCtrl.new/0","doc":"","ref":"wxFilePickerCtrl.html#new/0"},{"type":"function","title":"wxFilePickerCtrl.new/2","doc":"Equivalent to  new(Parent, Id, []) .","ref":"wxFilePickerCtrl.html#new/2"},{"type":"function","title":"wxFilePickerCtrl.new/3","doc":"Initializes the object and calls `create/4` with all the parameters.","ref":"wxFilePickerCtrl.html#new/3"},{"type":"function","title":"wxFilePickerCtrl.setPath/2","doc":"Sets the absolute path of the currently selected file.\n\nIf the control uses `wxFLP_FILE_MUST_EXIST` and does not use `wxFLP_USE_TEXTCTRL` style,\nthe `filename` must be a name of an existing file and will be simply ignored by the native\nwxGTK implementation if this is not the case (the generic implementation used under the\nother platforms accepts even invalid file names currently, but this is subject to change\nin the future, don't rely on being able to use non-existent paths with it).","ref":"wxFilePickerCtrl.html#setPath/2"},{"type":"type","title":"wxFilePickerCtrl.wxFilePickerCtrl/0","doc":"","ref":"wxFilePickerCtrl.html#t:wxFilePickerCtrl/0"},{"type":"module","title":"wxFindReplaceData","doc":"`m:wxFindReplaceData` holds the data for `m:wxFindReplaceDialog`.\n\nIt is used to initialize the dialog with the default values and will keep the last values\nfrom the dialog when it is closed. It is also updated each time a `wxFindDialogEvent` (not\nimplemented in wx) is generated so instead of using the `wxFindDialogEvent` (not\nimplemented in wx) methods you can also directly query this object.\n\nNote that all `SetXXX()` methods may only be called before showing the dialog and calling\nthem has no effect later.\n\nwxWidgets docs: [wxFindReplaceData](https://docs.wxwidgets.org/3.2/classwx_find_replace_data.html)","ref":"wxFindReplaceData.html"},{"type":"function","title":"wxFindReplaceData.destroy/1","doc":"Destroys the object","ref":"wxFindReplaceData.html#destroy/1"},{"type":"function","title":"wxFindReplaceData.getFindString/1","doc":"Get the string to find.","ref":"wxFindReplaceData.html#getFindString/1"},{"type":"function","title":"wxFindReplaceData.getFlags/1","doc":"Get the combination of `wxFindReplaceFlags` values.","ref":"wxFindReplaceData.html#getFlags/1"},{"type":"function","title":"wxFindReplaceData.getReplaceString/1","doc":"Get the replacement string.","ref":"wxFindReplaceData.html#getReplaceString/1"},{"type":"function","title":"wxFindReplaceData.new/0","doc":"Equivalent to  new([]) .","ref":"wxFindReplaceData.html#new/0"},{"type":"function","title":"wxFindReplaceData.new/1","doc":"Constructor initializes the flags to default value (0).","ref":"wxFindReplaceData.html#new/1"},{"type":"function","title":"wxFindReplaceData.setFindString/2","doc":"Set the string to find (used as initial value by the dialog).","ref":"wxFindReplaceData.html#setFindString/2"},{"type":"function","title":"wxFindReplaceData.setFlags/2","doc":"Set the flags to use to initialize the controls of the dialog.","ref":"wxFindReplaceData.html#setFlags/2"},{"type":"function","title":"wxFindReplaceData.setReplaceString/2","doc":"Set the replacement string (used as initial value by the dialog).","ref":"wxFindReplaceData.html#setReplaceString/2"},{"type":"type","title":"wxFindReplaceData.wxFindReplaceData/0","doc":"","ref":"wxFindReplaceData.html#t:wxFindReplaceData/0"},{"type":"module","title":"wxFindReplaceDialog","doc":"`m:wxFindReplaceDialog` is a standard modeless dialog which is used to allow the user to\nsearch for some text (and possibly replace it with something else).\n\nThe actual searching is supposed to be done in the owner window which is the parent of\nthis dialog. Note that it means that unlike for the other standard dialogs this one `must`\nhave a parent window. Also note that there is no way to use this dialog in a modal way; it\nis always, by design and implementation, modeless.\n\nPlease see the page_samples_dialogs sample for an example of using it.\n\nThis class is derived, and can use functions, from:\n\n* `m:wxDialog`\n\n* `m:wxTopLevelWindow`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxFindReplaceDialog](https://docs.wxwidgets.org/3.2/classwx_find_replace_dialog.html)","ref":"wxFindReplaceDialog.html"},{"type":"function","title":"wxFindReplaceDialog.create/4","doc":"Equivalent to  create(This, Parent, Data, Title, []) .","ref":"wxFindReplaceDialog.html#create/4"},{"type":"function","title":"wxFindReplaceDialog.create/5","doc":"Creates the dialog; use `wxWindow:show/2` to show it on screen.\n\nThe `parent` and `data` parameters must be non-NULL.","ref":"wxFindReplaceDialog.html#create/5"},{"type":"function","title":"wxFindReplaceDialog.destroy/1","doc":"Destroys the object","ref":"wxFindReplaceDialog.html#destroy/1"},{"type":"function","title":"wxFindReplaceDialog.getData/1","doc":"Get the `m:wxFindReplaceData` object used by this dialog.","ref":"wxFindReplaceDialog.html#getData/1"},{"type":"function","title":"wxFindReplaceDialog.new/0","doc":"","ref":"wxFindReplaceDialog.html#new/0"},{"type":"function","title":"wxFindReplaceDialog.new/3","doc":"Equivalent to  new(Parent, Data, Title, []) .","ref":"wxFindReplaceDialog.html#new/3"},{"type":"function","title":"wxFindReplaceDialog.new/4","doc":"After using default constructor `create/5` must be called.\n\nThe `parent` and `data` parameters must be non-NULL.","ref":"wxFindReplaceDialog.html#new/4"},{"type":"type","title":"wxFindReplaceDialog.wxFindReplaceDialog/0","doc":"","ref":"wxFindReplaceDialog.html#t:wxFindReplaceDialog/0"},{"type":"module","title":"wxFlexGridSizer","doc":"A flex grid sizer is a sizer which lays out its children in a two-dimensional table with\nall table fields in one row having the same height and all fields in one column having the\nsame width, but all rows or all columns are not necessarily the same height or width as in\nthe `m:wxGridSizer`.\n\nSince wxWidgets 2.5.0, `m:wxFlexGridSizer` can also size items equally in one direction\nbut unequally (\"flexibly\") in the other. If the sizer is only flexible in one direction\n(this can be changed using `setFlexibleDirection/2`), it needs to be decided how the sizer should grow in the other\n(\"non-flexible\") direction in order to fill the available space. The `setNonFlexibleGrowMode/2` method serves this purpose.\n\nSee:\n* `m:wxSizer`\n\n* [Overview sizer](https://docs.wxwidgets.org/3.2/overview_sizer.html#overview_sizer)\n\nThis class is derived, and can use functions, from:\n\n* `m:wxGridSizer`\n\n* `m:wxSizer`\n\nwxWidgets docs: [wxFlexGridSizer](https://docs.wxwidgets.org/3.2/classwx_flex_grid_sizer.html)","ref":"wxFlexGridSizer.html"},{"type":"function","title":"wxFlexGridSizer.addGrowableCol/2","doc":"Equivalent to  addGrowableCol(This, Idx, []) .","ref":"wxFlexGridSizer.html#addGrowableCol/2"},{"type":"function","title":"wxFlexGridSizer.addGrowableCol/3","doc":"Specifies that column `idx` (starting from zero) should be grown if there is extra space\navailable to the sizer.\n\nThe `proportion` parameter has the same meaning as the stretch factor for the sizers (see `m:wxBoxSizer`)\nexcept that if all proportions are 0, then all columns are resized equally (instead of not\nbeing resized at all).\n\nNotice that the column must not be already growable, if you need to change the proportion\nyou must call `removeGrowableCol/2` first and then make it growable (with a different proportion) again. You\ncan use `IsColGrowable()` (not implemented in wx) to check whether a column is already\ngrowable.","ref":"wxFlexGridSizer.html#addGrowableCol/3"},{"type":"function","title":"wxFlexGridSizer.addGrowableRow/2","doc":"Equivalent to  addGrowableRow(This, Idx, []) .","ref":"wxFlexGridSizer.html#addGrowableRow/2"},{"type":"function","title":"wxFlexGridSizer.addGrowableRow/3","doc":"Specifies that row idx (starting from zero) should be grown if there is extra space\navailable to the sizer.\n\nThis is identical to `addGrowableCol/3` except that it works with rows and not columns.","ref":"wxFlexGridSizer.html#addGrowableRow/3"},{"type":"function","title":"wxFlexGridSizer.destroy/1","doc":"Destroys the object","ref":"wxFlexGridSizer.html#destroy/1"},{"type":"function","title":"wxFlexGridSizer.getFlexibleDirection/1","doc":"Returns a ?wxOrientation value that specifies whether the sizer flexibly resizes its\ncolumns, rows, or both (default).\n\nReturn: One of the following values:\n\n* wxVERTICAL: Rows are flexibly sized.\n\n* wxHORIZONTAL: Columns are flexibly sized.\n\n* wxBOTH: Both rows and columns are flexibly sized (this is the default value).\n\nSee: `setFlexibleDirection/2`","ref":"wxFlexGridSizer.html#getFlexibleDirection/1"},{"type":"function","title":"wxFlexGridSizer.getNonFlexibleGrowMode/1","doc":"Returns the value that specifies how the sizer grows in the \"non-flexible\" direction if\nthere is one.\n\nThe behaviour of the elements in the flexible direction (i.e. both rows and columns by\ndefault, or rows only if `getFlexibleDirection/1` is `wxVERTICAL` or columns only if it is `wxHORIZONTAL`) is\nalways governed by their proportion as specified in the call to `addGrowableRow/3` or `addGrowableCol/3`. What happens in the\nother direction depends on the value of returned by this function as described below.\n\nReturn: One of the following values:\n\n* wxFLEX_GROWMODE_NONE: Sizer doesn't grow its elements at all in the non-flexible direction.\n\n* wxFLEX_GROWMODE_SPECIFIED: Sizer honors growable columns/rows set with `addGrowableCol/3` and `addGrowableRow/3` in the\nnon-flexible direction as well. In this case equal sizing applies to minimum sizes of\ncolumns or rows (this is the default value).\n\n* wxFLEX_GROWMODE_ALL: Sizer equally stretches all columns or rows in the non-flexible\ndirection, independently of the proportions applied in the flexible direction.\n\nSee:\n* `setFlexibleDirection/2`\n\n* `setNonFlexibleGrowMode/2`","ref":"wxFlexGridSizer.html#getNonFlexibleGrowMode/1"},{"type":"function","title":"wxFlexGridSizer.new/1","doc":"Equivalent to  new(Cols, []) .","ref":"wxFlexGridSizer.html#new/1"},{"type":"function","title":"wxFlexGridSizer.new/2","doc":"","ref":"wxFlexGridSizer.html#new/2"},{"type":"function","title":"wxFlexGridSizer.new/3","doc":"","ref":"wxFlexGridSizer.html#new/3"},{"type":"function","title":"wxFlexGridSizer.new/4","doc":"","ref":"wxFlexGridSizer.html#new/4"},{"type":"function","title":"wxFlexGridSizer.removeGrowableCol/2","doc":"Specifies that the `idx` column index is no longer growable.","ref":"wxFlexGridSizer.html#removeGrowableCol/2"},{"type":"function","title":"wxFlexGridSizer.removeGrowableRow/2","doc":"Specifies that the `idx` row index is no longer growable.","ref":"wxFlexGridSizer.html#removeGrowableRow/2"},{"type":"function","title":"wxFlexGridSizer.setFlexibleDirection/2","doc":"Specifies whether the sizer should flexibly resize its columns, rows, or both.\n\nArgument `direction` can be `wxVERTICAL`, `wxHORIZONTAL` or `wxBOTH` (which is the\ndefault value). Any other value is ignored.\n\nSee `getFlexibleDirection/1` for the explanation of these values. Note that this method does not trigger\nrelayout.","ref":"wxFlexGridSizer.html#setFlexibleDirection/2"},{"type":"function","title":"wxFlexGridSizer.setNonFlexibleGrowMode/2","doc":"Specifies how the sizer should grow in the non-flexible direction if there is one (so `setFlexibleDirection/2`\nmust have been called previously).\n\nArgument `mode` can be one of those documented in `getNonFlexibleGrowMode/1`, please see there for their\nexplanation. Note that this method does not trigger relayout.","ref":"wxFlexGridSizer.html#setNonFlexibleGrowMode/2"},{"type":"type","title":"wxFlexGridSizer.wxFlexGridSizer/0","doc":"","ref":"wxFlexGridSizer.html#t:wxFlexGridSizer/0"},{"type":"module","title":"wxFocusEvent","doc":"A focus event is sent when a window's focus changes.\n\nThe window losing focus receives a \"kill focus\" event while the window gaining it gets a\n\"set focus\" one.\n\nNotice that the set focus event happens both when the user gives focus to the window\n(whether using the mouse or keyboard) and when it is done from the program itself using `wxWindow:setFocus/1`.\n\nThe focus event handlers should almost invariably call `wxEvent:skip/2` on their event argument to allow\nthe default handling to take place. Failure to do this may result in incorrect behaviour\nof the native controls. Also note that wxEVT_KILL_FOCUS handler must not call `wxWindow:setFocus/1` as this,\nagain, is not supported by all native controls. If you need to do this, consider using the `Delayed Action Mechanism`\n(not implemented in wx) described in `m:wxIdleEvent` documentation.\n\nSee: [Overview events](https://docs.wxwidgets.org/3.2/overview_events.html#overview_events)\n\nThis class is derived, and can use functions, from:\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxFocusEvent](https://docs.wxwidgets.org/3.2/classwx_focus_event.html)","ref":"wxFocusEvent.html"},{"type":"module","title":"Events - wxFocusEvent","doc":"Use `wxEvtHandler:connect/3` with `wxFocusEventType` to subscribe to events of this type.","ref":"wxFocusEvent.html#module-events"},{"type":"function","title":"wxFocusEvent.getWindow/1","doc":"Returns the window associated with this event, that is the window which had the focus\nbefore for the `wxEVT\\_SET\\_FOCUS` event and the window which is going to receive focus\nfor the `wxEVT\\_KILL\\_FOCUS` one.\n\nWarning: the window pointer may be NULL!","ref":"wxFocusEvent.html#getWindow/1"},{"type":"type","title":"wxFocusEvent.wxFocus/0","doc":"","ref":"wxFocusEvent.html#t:wxFocus/0"},{"type":"type","title":"wxFocusEvent.wxFocusEvent/0","doc":"","ref":"wxFocusEvent.html#t:wxFocusEvent/0"},{"type":"type","title":"wxFocusEvent.wxFocusEventType/0","doc":"","ref":"wxFocusEvent.html#t:wxFocusEventType/0"},{"type":"module","title":"wxFont","doc":"A font is an object which determines the appearance of text.\n\nFonts are used for drawing text to a device context, and setting the appearance of a\nwindow's text, see `wxDC:setFont/2` and `wxWindow:setFont/2`.\n\nThe easiest way to create a custom font is to use `wxFontInfo` (not implemented in wx)\nobject to specify the font attributes and then use `new/5` constructor. Alternatively, you could\nstart with one of the pre-defined fonts or use `wxWindow:getFont/1` and modify the font, e.g. by increasing\nits size using `MakeLarger()` (not implemented in wx) or changing its weight using `MakeBold()`\n(not implemented in wx).\n\nThis class uses reference counting and copy-on-write internally so that assignments\nbetween two instances of this class are very cheap. You can therefore use actual objects\ninstead of pointers without efficiency problems. If an instance of this class is changed\nit will create its own data internally so that other instances, which previously shared\nthe data using the reference counting, are not affected.\n\nYou can retrieve the current system font settings with `m:wxSystemSettings`.\n\nPredefined objects (include wx.hrl): ?wxNullFont, ?wxNORMAL\\_FONT, ?wxSMALL\\_FONT,\n?wxITALIC\\_FONT, ?wxSWISS\\_FONT\n\nSee:\n* [Overview font](https://docs.wxwidgets.org/3.2/overview_font.html#overview_font)\n\n* `wxDC:setFont/2`\n\n* `wxDC:drawText/3`\n\n* `wxDC:getTextExtent/3`\n\n* `m:wxFontDialog`\n\n* `m:wxSystemSettings`\n\nwxWidgets docs: [wxFont](https://docs.wxwidgets.org/3.2/classwx_font.html)","ref":"wxFont.html"},{"type":"function","title":"wxFont.destroy/1","doc":"Destroys the object","ref":"wxFont.html#destroy/1"},{"type":"function","title":"wxFont.getDefaultEncoding/0","doc":"Returns the current application's default encoding.\n\nSee:\n* [Overview fontencoding](https://docs.wxwidgets.org/3.2/overview_fontencoding.html#overview_fontencoding)\n\n* `setDefaultEncoding/1`","ref":"wxFont.html#getDefaultEncoding/0"},{"type":"function","title":"wxFont.getFaceName/1","doc":"Returns the face name associated with the font, or the empty string if there is no face\ninformation.\n\nSee: `setFaceName/2`","ref":"wxFont.html#getFaceName/1"},{"type":"function","title":"wxFont.getFamily/1","doc":"Gets the font family if possible.\n\nAs described in ?wxFontFamily docs the returned value acts as a rough, basic\nclassification of the main font properties (look, spacing).\n\nIf the current font face name is not recognized by `m:wxFont` or by the underlying\nsystem, `wxFONTFAMILY_DEFAULT` is returned.\n\nNote that currently this function is not very precise and so not particularly useful.\nFont families mostly make sense only for font creation, see `setFamily/2`.\n\nSee: `setFamily/2`","ref":"wxFont.html#getFamily/1"},{"type":"function","title":"wxFont.getNativeFontInfoDesc/1","doc":"Returns the platform-dependent string completely describing this font.\n\nReturned string is always non-empty unless the font is invalid (in which case an assert\nis triggered).\n\nNote that the returned string is not meant to be shown or edited by the user: a typical\nuse of this function is for serializing in string-form a `m:wxFont` object.\n\nSee: `getNativeFontInfoUserDesc/1`","ref":"wxFont.html#getNativeFontInfoDesc/1"},{"type":"function","title":"wxFont.getNativeFontInfoUserDesc/1","doc":"Returns a user-friendly string for this font object.\n\nReturned string is always non-empty unless the font is invalid (in which case an assert\nis triggered).\n\nThe string does not encode all `m:wxFont` infos under all platforms; e.g. under wxMSW the\nfont family is not present in the returned string.\n\nSome examples of the formats of returned strings (which are platform-dependent) are in `SetNativeFontInfoUserDesc()`\n(not implemented in wx).\n\nSee: `getNativeFontInfoDesc/1`","ref":"wxFont.html#getNativeFontInfoUserDesc/1"},{"type":"function","title":"wxFont.getPointSize/1","doc":"Gets the point size as an integer number.\n\nThis function is kept for compatibility reasons. New code should use `GetFractionalPointSize()`\n(not implemented in wx) and support fractional point sizes.\n\nSee: `setPointSize/2`","ref":"wxFont.html#getPointSize/1"},{"type":"function","title":"wxFont.getStyle/1","doc":"Gets the font style.\n\nSee ?wxFontStyle for a list of valid styles.\n\nSee: `setStyle/2`","ref":"wxFont.html#getStyle/1"},{"type":"function","title":"wxFont.getUnderlined/1","doc":"Returns true if the font is underlined, false otherwise.\n\nSee: `setUnderlined/2`","ref":"wxFont.html#getUnderlined/1"},{"type":"function","title":"wxFont.getWeight/1","doc":"Gets the font weight.\n\nSee ?wxFontWeight for a list of valid weight identifiers.\n\nSee: `setWeight/2`","ref":"wxFont.html#getWeight/1"},{"type":"function","title":"wxFont.isFixedWidth/1","doc":"Returns true if the font is a fixed width (or monospaced) font, false if it is a\nproportional one or font is invalid.\n\nNote that this function under some platforms is different from just testing for the font\nfamily being equal to `wxFONTFAMILY_TELETYPE` because native platform-specific functions\nare used for the check (resulting in a more accurate return value).","ref":"wxFont.html#isFixedWidth/1"},{"type":"function","title":"wxFont.isOk/1","doc":"Returns true if this object is a valid font, false otherwise.","ref":"wxFont.html#isOk/1"},{"type":"function","title":"wxFont.new/0","doc":"Default ctor.","ref":"wxFont.html#new/0"},{"type":"function","title":"wxFont.new/1","doc":"Copy constructor, uses reference counting.","ref":"wxFont.html#new/1"},{"type":"function","title":"wxFont.new/4","doc":"Equivalent to: `new/5`","ref":"wxFont.html#new/4"},{"type":"function","title":"wxFont.new/5","doc":"Creates a font object with the specified attributes and size in pixels.\n\nNotice that the use of this constructor is often more verbose and less readable than the\nuse of constructor from `wxFontInfo` (not implemented in wx), consider using that\nconstructor instead.\n\nRemark: If the desired font does not exist, the closest match will be chosen. Under\nWindows, only scalable TrueType fonts are used.","ref":"wxFont.html#new/5"},{"type":"function","title":"wxFont.ok/1","doc":"Equivalent to: `isOk/1`","ref":"wxFont.html#ok/1"},{"type":"function","title":"wxFont.setDefaultEncoding/1","doc":"Sets the default font encoding.\n\nSee:\n* [Overview fontencoding](https://docs.wxwidgets.org/3.2/overview_fontencoding.html#overview_fontencoding)\n\n* `getDefaultEncoding/0`","ref":"wxFont.html#setDefaultEncoding/1"},{"type":"function","title":"wxFont.setFaceName/2","doc":"Sets the facename for the font.\n\nRemark: To avoid portability problems, don't rely on a specific face, but specify the\nfont family instead (see ?wxFontFamily and `setFamily/2`).\n\nReturn: true if the given face name exists; if the face name doesn't exist in the user's\nsystem then the font is invalidated (so that `isOk/1` will return false) and false is returned.\n\nSee:\n* `getFaceName/1`\n\n* `setFamily/2`","ref":"wxFont.html#setFaceName/2"},{"type":"function","title":"wxFont.setFamily/2","doc":"Sets the font family.\n\nAs described in ?wxFontFamily docs the given `family` value acts as a rough, basic\nindication of the main font properties (look, spacing).\n\nNote that changing the font family results in changing the font face name.\n\nSee:\n* `getFamily/1`\n\n* `setFaceName/2`","ref":"wxFont.html#setFamily/2"},{"type":"function","title":"wxFont.setPointSize/2","doc":"Sets the font size in points to an integer value.\n\nThis is a legacy version of the function only supporting integer point sizes. It can\nstill be used, but to avoid unnecessarily restricting the font size in points to integer\nvalues, consider using the new (added in wxWidgets 3.1.2) `SetFractionalPointSize()` (not\nimplemented in wx) function instead.","ref":"wxFont.html#setPointSize/2"},{"type":"function","title":"wxFont.setStyle/2","doc":"Sets the font style.\n\nSee: `getStyle/1`","ref":"wxFont.html#setStyle/2"},{"type":"function","title":"wxFont.setUnderlined/2","doc":"Sets underlining.\n\nSee: `getUnderlined/1`","ref":"wxFont.html#setUnderlined/2"},{"type":"function","title":"wxFont.setWeight/2","doc":"Sets the font weight.\n\nSee: `getWeight/1`","ref":"wxFont.html#setWeight/2"},{"type":"type","title":"wxFont.wxFont/0","doc":"","ref":"wxFont.html#t:wxFont/0"},{"type":"module","title":"wxFontData","doc":"This class holds a variety of information related to font dialogs.\n\nSee:\n* [Overview cmndlg](https://docs.wxwidgets.org/3.2/overview_cmndlg.html#overview_cmndlg_font)\n\n* `m:wxFont`\n\n* `m:wxFontDialog`\n\nwxWidgets docs: [wxFontData](https://docs.wxwidgets.org/3.2/classwx_font_data.html)","ref":"wxFontData.html"},{"type":"function","title":"wxFontData.destroy/1","doc":"Destroys the object","ref":"wxFontData.html#destroy/1"},{"type":"function","title":"wxFontData.enableEffects/2","doc":"Enables or disables \"effects\" under Windows or generic only.\n\nThis refers to the controls for manipulating colour, strikeout and underline properties.\n\nThe default value is true.","ref":"wxFontData.html#enableEffects/2"},{"type":"function","title":"wxFontData.getAllowSymbols/1","doc":"Under Windows, returns a flag determining whether symbol fonts can be selected.\n\nHas no effect on other platforms.\n\nThe default value is true.","ref":"wxFontData.html#getAllowSymbols/1"},{"type":"function","title":"wxFontData.getChosenFont/1","doc":"Gets the font chosen by the user if the user pressed OK (`wxFontDialog::ShowModal()` (not\nimplemented in wx) returned wxID\\_OK).","ref":"wxFontData.html#getChosenFont/1"},{"type":"function","title":"wxFontData.getColour/1","doc":"Gets the colour associated with the font dialog.\n\nThe default value is black.","ref":"wxFontData.html#getColour/1"},{"type":"function","title":"wxFontData.getEnableEffects/1","doc":"Determines whether \"effects\" are enabled under Windows.\n\nThis refers to the controls for manipulating colour, strikeout and underline properties.\n\nThe default value is true.","ref":"wxFontData.html#getEnableEffects/1"},{"type":"function","title":"wxFontData.getInitialFont/1","doc":"Gets the font that will be initially used by the font dialog.\n\nThis should have previously been set by the application.","ref":"wxFontData.html#getInitialFont/1"},{"type":"function","title":"wxFontData.getShowHelp/1","doc":"Returns true if the Help button will be shown (Windows only).\n\nThe default value is false.","ref":"wxFontData.html#getShowHelp/1"},{"type":"function","title":"wxFontData.new/0","doc":"Constructor.\n\nInitializes `fontColour` to black, `showHelp` to false, `allowSymbols` to true, `enableEffects`\nto true, `minSize` to 0 and `maxSize` to 0.","ref":"wxFontData.html#new/0"},{"type":"function","title":"wxFontData.new/1","doc":"Copy Constructor.","ref":"wxFontData.html#new/1"},{"type":"function","title":"wxFontData.setAllowSymbols/2","doc":"Under Windows, determines whether symbol fonts can be selected.\n\nHas no effect on other platforms.\n\nThe default value is true.","ref":"wxFontData.html#setAllowSymbols/2"},{"type":"function","title":"wxFontData.setChosenFont/2","doc":"Sets the font that will be returned to the user (for internal use only).","ref":"wxFontData.html#setChosenFont/2"},{"type":"function","title":"wxFontData.setColour/2","doc":"Sets the colour that will be used for the font foreground colour.\n\nThe default colour is black.","ref":"wxFontData.html#setColour/2"},{"type":"function","title":"wxFontData.setInitialFont/2","doc":"Sets the font that will be initially used by the font dialog.","ref":"wxFontData.html#setInitialFont/2"},{"type":"function","title":"wxFontData.setRange/3","doc":"Sets the valid range for the font point size (Windows only).\n\nThe default is 0, 0 (unrestricted range).","ref":"wxFontData.html#setRange/3"},{"type":"function","title":"wxFontData.setShowHelp/2","doc":"Determines whether the Help button will be displayed in the font dialog (Windows only).\n\nThe default value is false.","ref":"wxFontData.html#setShowHelp/2"},{"type":"type","title":"wxFontData.wxFontData/0","doc":"","ref":"wxFontData.html#t:wxFontData/0"},{"type":"module","title":"wxFontDialog","doc":"This class represents the font chooser dialog.\n\nSee:\n* [Overview cmndlg](https://docs.wxwidgets.org/3.2/overview_cmndlg.html#overview_cmndlg_font)\n\n* `m:wxFontData`\n\n* ?wxGetFontFromUser()\n\nThis class is derived, and can use functions, from:\n\n* `m:wxDialog`\n\n* `m:wxTopLevelWindow`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxFontDialog](https://docs.wxwidgets.org/3.2/classwx_font_dialog.html)","ref":"wxFontDialog.html"},{"type":"function","title":"wxFontDialog.create/3","doc":"Creates the dialog if the `m:wxFontDialog` object had been initialized using the default\nconstructor.\n\nReturn: true on success and false if an error occurred.","ref":"wxFontDialog.html#create/3"},{"type":"function","title":"wxFontDialog.destroy/1","doc":"Destroys the object","ref":"wxFontDialog.html#destroy/1"},{"type":"function","title":"wxFontDialog.getFontData/1","doc":"Returns the `m:wxFontData` associated with the font dialog.","ref":"wxFontDialog.html#getFontData/1"},{"type":"function","title":"wxFontDialog.new/0","doc":"Default ctor.\n\n`create/3` must be called before the dialog can be shown.","ref":"wxFontDialog.html#new/0"},{"type":"function","title":"wxFontDialog.new/2","doc":"Constructor.\n\nPass a parent window, and the `m:wxFontData` object to be used to initialize the dialog\ncontrols.","ref":"wxFontDialog.html#new/2"},{"type":"type","title":"wxFontDialog.wxFontDialog/0","doc":"","ref":"wxFontDialog.html#t:wxFontDialog/0"},{"type":"module","title":"wxFontPickerCtrl","doc":"This control allows the user to select a font.\n\nThe generic implementation is a button which brings up a `m:wxFontDialog` when clicked.\nNative implementation may differ but this is usually a (small) widget which give access to\nthe font-chooser dialog. It is only available if `wxUSE_FONTPICKERCTRL` is set to 1 (the default).","ref":"wxFontPickerCtrl.html"},{"type":"module","title":"Styles - wxFontPickerCtrl","doc":"This class supports the following styles:\n\n* wxFNTP_DEFAULT_STYLE: The default style: wxFNTP_FONTDESC_AS_LABEL |\nwxFNTP_USEFONT_FOR_LABEL.\n\n* wxFNTP_USE_TEXTCTRL: Creates a text control to the left of the picker button which is\ncompletely managed by the `m:wxFontPickerCtrl` and which can be used by the user to\nspecify a font (see SetSelectedFont). The text control is automatically synchronized with\nbutton's value. Use functions defined in `m:wxPickerBase` to modify the text control.\n\n* wxFNTP_FONTDESC_AS_LABEL: Keeps the label of the button updated with the fontface name\nand the font size. E.g. choosing \"Times New Roman bold, italic with size 10\" from the\nfontdialog, will update the label (overwriting any previous label) with the \"Times New\nRoman, 10\" text.\n\n* wxFNTP_USEFONT_FOR_LABEL: Uses the currently selected font to draw the label of the\nbutton.\n\nSee:\n* `m:wxFontDialog`\n\n* `m:wxFontPickerEvent`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxPickerBase`\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxFontPickerCtrl](https://docs.wxwidgets.org/3.2/classwx_font_picker_ctrl.html)","ref":"wxFontPickerCtrl.html#module-styles"},{"type":"module","title":"Events - wxFontPickerCtrl","doc":"Event types emitted from this class:\n\n* [`command_fontpicker_changed`](`m:wxFontPickerEvent`)","ref":"wxFontPickerCtrl.html#module-events"},{"type":"function","title":"wxFontPickerCtrl.create/3","doc":"Equivalent to  create(This, Parent, Id, []) .","ref":"wxFontPickerCtrl.html#create/3"},{"type":"function","title":"wxFontPickerCtrl.create/4","doc":"Creates this widget with given parameters.\n\nReturn: true if the control was successfully created or false if creation failed.","ref":"wxFontPickerCtrl.html#create/4"},{"type":"function","title":"wxFontPickerCtrl.destroy/1","doc":"Destroys the object","ref":"wxFontPickerCtrl.html#destroy/1"},{"type":"function","title":"wxFontPickerCtrl.getMaxPointSize/1","doc":"Returns the maximum point size value allowed for the user-chosen font.","ref":"wxFontPickerCtrl.html#getMaxPointSize/1"},{"type":"function","title":"wxFontPickerCtrl.getSelectedFont/1","doc":"Returns the currently selected font.\n\nNote that this function is completely different from `wxWindow:getFont/1`.","ref":"wxFontPickerCtrl.html#getSelectedFont/1"},{"type":"function","title":"wxFontPickerCtrl.new/0","doc":"","ref":"wxFontPickerCtrl.html#new/0"},{"type":"function","title":"wxFontPickerCtrl.new/2","doc":"Equivalent to  new(Parent, Id, []) .","ref":"wxFontPickerCtrl.html#new/2"},{"type":"function","title":"wxFontPickerCtrl.new/3","doc":"Initializes the object and calls `create/4` with all the parameters.","ref":"wxFontPickerCtrl.html#new/3"},{"type":"function","title":"wxFontPickerCtrl.setMaxPointSize/2","doc":"Sets the maximum point size value allowed for the user-chosen font.\n\nThe default value is 100. Note that big fonts can require a lot of memory and CPU time\nboth for creation and for rendering; thus, specially because the user has the option to\nspecify the fontsize through a text control (see wxFNTP_USE_TEXTCTRL), it's a good idea to\nput a limit to the maximum font size when huge fonts do not make much sense.","ref":"wxFontPickerCtrl.html#setMaxPointSize/2"},{"type":"function","title":"wxFontPickerCtrl.setSelectedFont/2","doc":"Sets the currently selected font.\n\nNote that this function is completely different from `wxWindow:setFont/2`.","ref":"wxFontPickerCtrl.html#setSelectedFont/2"},{"type":"type","title":"wxFontPickerCtrl.wxFontPickerCtrl/0","doc":"","ref":"wxFontPickerCtrl.html#t:wxFontPickerCtrl/0"},{"type":"module","title":"wxFontPickerEvent","doc":"This event class is used for the events generated by `m:wxFontPickerCtrl`.\n\nSee: `m:wxFontPickerCtrl`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxCommandEvent`\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxFontPickerEvent](https://docs.wxwidgets.org/3.2/classwx_font_picker_event.html)","ref":"wxFontPickerEvent.html"},{"type":"module","title":"Events - wxFontPickerEvent","doc":"Use `wxEvtHandler:connect/3` with `wxFontPickerEventType` to subscribe to events of this type.","ref":"wxFontPickerEvent.html#module-events"},{"type":"function","title":"wxFontPickerEvent.getFont/1","doc":"Retrieve the font the user has just selected.","ref":"wxFontPickerEvent.html#getFont/1"},{"type":"type","title":"wxFontPickerEvent.wxFontPicker/0","doc":"","ref":"wxFontPickerEvent.html#t:wxFontPicker/0"},{"type":"type","title":"wxFontPickerEvent.wxFontPickerEvent/0","doc":"","ref":"wxFontPickerEvent.html#t:wxFontPickerEvent/0"},{"type":"type","title":"wxFontPickerEvent.wxFontPickerEventType/0","doc":"","ref":"wxFontPickerEvent.html#t:wxFontPickerEventType/0"},{"type":"module","title":"wxFrame","doc":"A frame is a window whose size and position can (usually) be changed by the user.\n\nIt usually has thick borders and a title bar, and can optionally contain a menu bar,\ntoolbar and status bar. A frame can contain any window that is not a frame or dialog.\n\nA frame that has a status bar and toolbar, created via the `createStatusBar/2` and `createToolBar/2` functions, manages these\nwindows and adjusts the value returned by `wxWindow:getClientSize/1` to reflect the remaining size available to\napplication windows.\n\nRemark: An application should normally define an `m:wxCloseEvent` handler for the frame\nto respond to system close events, for example so that related data and subwindows can be\ncleaned up.\n\nDefault event processing\n\n`m:wxFrame` processes the following events:\n\n* `wxEVT_SIZE:` if the frame has exactly one child window, not counting the status and\ntoolbar, this child is resized to take the entire frame client area. If two or more\nwindows are present, they should be laid out explicitly either by manually handling `wxEVT_SIZE`\nor using sizers;\n\n* `wxEVT_MENU_HIGHLIGHT:` the default implementation displays the help string associated\nwith the selected item in the first pane of the status bar, if there is one.","ref":"wxFrame.html"},{"type":"module","title":"Styles - wxFrame","doc":"This class supports the following styles:\n\n* wxDEFAULT_FRAME_STYLE: Defined as wxMINIMIZE_BOX | wxMAXIMIZE_BOX | wxRESIZE_BORDER |\nwxSYSTEM_MENU | wxCAPTION | wxCLOSE_BOX | wxCLIP_CHILDREN.\n\n* wxICONIZE: Display the frame iconized (minimized). Windows only.\n\n* wxCAPTION: Puts a caption on the frame. Notice that this flag is required by\nwxMINIMIZE_BOX, wxMAXIMIZE_BOX and wxCLOSE_BOX on most systems as the corresponding\nbuttons cannot be shown if the window has no title bar at all. I.e. if wxCAPTION is not\nspecified those styles would be simply ignored.\n\n* wxMINIMIZE: Identical to wxICONIZE. Windows only.\n\n* wxMINIMIZE_BOX: Displays a minimize box on the frame.\n\n* wxMAXIMIZE: Displays the frame maximized. Windows and GTK+ only.\n\n* wxMAXIMIZE_BOX: Displays a maximize box on the frame. Notice that under wxGTK\nwxRESIZE_BORDER must be used as well or this style is ignored.\n\n* wxCLOSE_BOX: Displays a close box on the frame.\n\n* wxSTAY_ON_TOP: Stay on top of all other windows, see also wxFRAME_FLOAT_ON_PARENT.\n\n* wxSYSTEM_MENU: Displays a system menu containing the list of various windows commands in\nthe window title bar. Unlike wxMINIMIZE_BOX, wxMAXIMIZE_BOX and wxCLOSE_BOX styles this\nstyle can be used without wxCAPTION, at least under Windows, and makes the system menu\navailable without showing it on screen in this case. However it is recommended to only use\nit together with wxCAPTION for consistent behaviour under all platforms.\n\n* wxRESIZE_BORDER: Displays a resizable border around the window.\n\n* wxFRAME_TOOL_WINDOW: Causes a frame with a small title bar to be created; the frame does\nnot appear in the taskbar under Windows or GTK+.\n\n* wxFRAME_NO_TASKBAR: Creates an otherwise normal frame but it does not appear in the\ntaskbar under Windows or GTK+ (note that it will minimize to the desktop window under\nWindows which may seem strange to the users and thus it might be better to use this style\nonly without wxMINIMIZE_BOX style). In wxGTK, the flag is respected only if the window\nmanager supports _NET_WM_STATE_SKIP_TASKBAR hint.\n\n* wxFRAME_FLOAT_ON_PARENT: The frame will always be on top of its parent (unlike\nwxSTAY_ON_TOP). A frame created with this style must have a non-NULL parent.\n\n* wxFRAME_SHAPED: Windows with this style are allowed to have their shape changed with the `wxTopLevelWindow:setShape/2`\nmethod. The default frame style is for normal, resizable frames. To create a frame which\ncannot be resized by user, you may use the following combination of styles:\n\nSee also the overview_windowstyles.","ref":"wxFrame.html#module-styles"},{"type":"module","title":"Extra Styles - wxFrame","doc":"This class supports the following extra styles:\n\n* wxFRAME_EX_CONTEXTHELP: Under Windows, puts a query button on the caption. When pressed,\nWindows will go into a context-sensitive help mode and wxWidgets will send a `wxEVT_HELP`\nevent if the user clicked on an application window. Note that this is an extended style\nand must be set by calling SetExtraStyle before Create is called (two-step construction).\nYou cannot use this style together with wxMAXIMIZE_BOX or wxMINIMIZE_BOX, so you should\nuse wxDEFAULT_FRAME_STYLE ~ (wxMINIMIZE_BOX | wxMAXIMIZE_BOX) for the frames having this\nstyle (the dialogs don't have a minimize or a maximize box by default)\n\n* wxFRAME_EX_METAL: On macOS, frames with this style will be shown with a metallic look.\nThis is an extra style.\n\nSee:\n* `m:wxMDIParentFrame`\n\n* `m:wxMDIChildFrame`\n\n* `m:wxMiniFrame`\n\n* `m:wxDialog`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxTopLevelWindow`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxFrame](https://docs.wxwidgets.org/3.2/classwx_frame.html)","ref":"wxFrame.html#module-extra-styles"},{"type":"module","title":"Events - wxFrame","doc":"Event types emitted from this class:\n\n* [`close_window`](`m:wxCloseEvent`)\n\n* [`iconize`](`m:wxIconizeEvent`)\n\n* [`menu_open`](`m:wxMenuEvent`)\n\n* [`menu_close`](`m:wxMenuEvent`)\n\n* [`menu_highlight`](`m:wxMenuEvent`)","ref":"wxFrame.html#module-events"},{"type":"function","title":"wxFrame.create/4","doc":"Equivalent to  create(This, Parent, Id, Title, []) .","ref":"wxFrame.html#create/4"},{"type":"function","title":"wxFrame.create/5","doc":"Used in two-step frame construction.\n\nSee `new/4` for further details.","ref":"wxFrame.html#create/5"},{"type":"function","title":"wxFrame.createStatusBar/1","doc":"Equivalent to  createStatusBar(This, []) .","ref":"wxFrame.html#createStatusBar/1"},{"type":"function","title":"wxFrame.createStatusBar/2","doc":"Creates a status bar at the bottom of the frame.\n\nReturn: A pointer to the status bar if it was created successfully, NULL otherwise.\n\nRemark: The width of the status bar is the whole width of the frame (adjusted\nautomatically when resizing), and the height and text size are chosen by the host\nwindowing system.\n\nSee:\n* `setStatusText/3`\n\n* `getStatusBar/1`","ref":"wxFrame.html#createStatusBar/2"},{"type":"function","title":"wxFrame.createToolBar/1","doc":"Equivalent to  createToolBar(This, []) .","ref":"wxFrame.html#createToolBar/1"},{"type":"function","title":"wxFrame.createToolBar/2","doc":"Creates a toolbar at the top or left of the frame.\n\nReturn: A pointer to the toolbar if it was created successfully, NULL otherwise.\n\nRemark: By default, the toolbar is an instance of `m:wxToolBar`. To use a different\nclass, override `OnCreateToolBar()` (not implemented in wx). When a toolbar has been\ncreated with this function, or made known to the frame with `setToolBar/2`, the frame will manage the\ntoolbar position and adjust the return value from `wxWindow:getClientSize/1` to reflect the available space for\napplication windows. Under Pocket PC, you should always use this function for creating the\ntoolbar to be managed by the frame, so that wxWidgets can use a combined menubar and\ntoolbar. Where you manage your own toolbars, create a `m:wxToolBar` as usual.\n\nSee:\n* `createStatusBar/2`\n\n* `setToolBar/2`\n\n* `getToolBar/1`","ref":"wxFrame.html#createToolBar/2"},{"type":"function","title":"wxFrame.destroy/1","doc":"Destroys the object","ref":"wxFrame.html#destroy/1"},{"type":"function","title":"wxFrame.getClientAreaOrigin/1","doc":"Returns the origin of the frame client area (in client coordinates).\n\nIt may be different from (0, 0) if the frame has a toolbar.","ref":"wxFrame.html#getClientAreaOrigin/1"},{"type":"function","title":"wxFrame.getMenuBar/1","doc":"Returns a pointer to the menubar currently associated with the frame (if any).\n\nSee:\n* `setMenuBar/2`\n\n* `m:wxMenuBar`\n\n* `m:wxMenu`","ref":"wxFrame.html#getMenuBar/1"},{"type":"function","title":"wxFrame.getStatusBar/1","doc":"Returns a pointer to the status bar currently associated with the frame (if any).\n\nSee:\n* `createStatusBar/2`\n\n* `m:wxStatusBar`","ref":"wxFrame.html#getStatusBar/1"},{"type":"function","title":"wxFrame.getStatusBarPane/1","doc":"Returns the status bar pane used to display menu and toolbar help.\n\nSee: `setStatusBarPane/2`","ref":"wxFrame.html#getStatusBarPane/1"},{"type":"function","title":"wxFrame.getToolBar/1","doc":"Returns a pointer to the toolbar currently associated with the frame (if any).\n\nSee:\n* `createToolBar/2`\n\n* `m:wxToolBar`\n\n* `setToolBar/2`","ref":"wxFrame.html#getToolBar/1"},{"type":"function","title":"wxFrame.new/0","doc":"Default constructor.","ref":"wxFrame.html#new/0"},{"type":"function","title":"wxFrame.new/3","doc":"Equivalent to  new(Parent, Id, Title, []) .","ref":"wxFrame.html#new/3"},{"type":"function","title":"wxFrame.new/4","doc":"Constructor, creating the window.\n\nRemark: For Motif, MWM (the Motif Window Manager) should be running for any window styles\nto work (otherwise all styles take effect).\n\nSee: `create/5`","ref":"wxFrame.html#new/4"},{"type":"function","title":"wxFrame.processCommand/2","doc":"Simulate a menu command.","ref":"wxFrame.html#processCommand/2"},{"type":"function","title":"wxFrame.sendSizeEvent/1","doc":"Equivalent to  sendSizeEvent(This, []) .","ref":"wxFrame.html#sendSizeEvent/1"},{"type":"function","title":"wxFrame.sendSizeEvent/2","doc":"This function sends a dummy `m:wxSizeEvent` to the window allowing it to re-layout its\nchildren positions.\n\nIt is sometimes useful to call this function after adding or deleting a children after\nthe frame creation or if a child size changes. Note that if the frame is using either\nsizers or constraints for the children layout, it is enough to call `wxWindow:layout/1` directly and this\nfunction should not be used in this case.\n\nIf `flags` includes `wxSEND_EVENT_POST` value, this function posts the event, i.e.\nschedules it for later processing, instead of dispatching it directly. You can also use `PostSizeEvent()`\n(not implemented in wx) as a more readable equivalent of calling this function with this flag.","ref":"wxFrame.html#sendSizeEvent/2"},{"type":"function","title":"wxFrame.setMenuBar/2","doc":"Tells the frame to show the given menu bar.\n\nRemark: If the frame is destroyed, the menu bar and its menus will be destroyed also, so\ndo not delete the menu bar explicitly (except by resetting the frame's menu bar to another\nframe or NULL). Under Windows, a size event is generated, so be sure to initialize data\nmembers properly before calling `setMenuBar/2`. Note that on some platforms, it is not possible to call\nthis function twice for the same frame object.\n\nSee:\n* `getMenuBar/1`\n\n* `m:wxMenuBar`\n\n* `m:wxMenu`","ref":"wxFrame.html#setMenuBar/2"},{"type":"function","title":"wxFrame.setStatusBar/2","doc":"Associates a status bar with the frame.\n\nIf `statusBar` is NULL, then the status bar, if present, is detached from the frame, but `not`\ndeleted.\n\nSee:\n* `createStatusBar/2`\n\n* `m:wxStatusBar`\n\n* `getStatusBar/1`","ref":"wxFrame.html#setStatusBar/2"},{"type":"function","title":"wxFrame.setStatusBarPane/2","doc":"Set the status bar pane used to display menu and toolbar help.\n\nUsing -1 disables help display.","ref":"wxFrame.html#setStatusBarPane/2"},{"type":"function","title":"wxFrame.setStatusText/2","doc":"Equivalent to  setStatusText(This, Text, []) .","ref":"wxFrame.html#setStatusText/2"},{"type":"function","title":"wxFrame.setStatusText/3","doc":"Sets the status bar text and updates the status bar display.\n\nThis is a simple wrapper for `wxStatusBar:setStatusText/3` which doesn't do anything if the frame has no status bar,\ni.e. `getStatusBar/1` returns NULL.\n\nRemark: Use an empty string to clear the status bar.\n\nSee:\n* `createStatusBar/2`\n\n* `m:wxStatusBar`","ref":"wxFrame.html#setStatusText/3"},{"type":"function","title":"wxFrame.setStatusWidths/2","doc":"Sets the widths of the fields in the status bar.\n\nRemark: The widths of the variable fields are calculated from the total width of all\nfields, minus the sum of widths of the non-variable fields, divided by the number of\nvariable fields.","ref":"wxFrame.html#setStatusWidths/2"},{"type":"function","title":"wxFrame.setToolBar/2","doc":"Associates a toolbar with the frame.","ref":"wxFrame.html#setToolBar/2"},{"type":"type","title":"wxFrame.wxFrame/0","doc":"","ref":"wxFrame.html#t:wxFrame/0"},{"type":"module","title":"wxGBSizerItem","doc":"The `m:wxGBSizerItem` class is used by the `m:wxGridBagSizer` for tracking the items in\nthe sizer.\n\nIt adds grid position and spanning information to the normal `m:wxSizerItem` by adding `wxGBPosition`\n(not implemented in wx) and `wxGBSpan` (not implemented in wx) attributes. Most of the\ntime you will not need to use a `m:wxGBSizerItem` directly in your code, but there are a\ncouple of cases where it is handy.\n\nThis class is derived, and can use functions, from:\n\n* `m:wxSizerItem`\n\nwxWidgets docs: [wxGBSizerItem](https://docs.wxwidgets.org/3.2/classwx_g_b_sizer_item.html)","ref":"wxGBSizerItem.html"},{"type":"type","title":"wxGBSizerItem.wxGBSizerItem/0","doc":"","ref":"wxGBSizerItem.html#t:wxGBSizerItem/0"},{"type":"module","title":"wxGCDC","doc":"`m:wxGCDC` is a device context that draws on a `m:wxGraphicsContext`.\n\n`m:wxGCDC` does its best to implement `m:wxDC` API, but the following features are not\n(fully) implemented because `m:wxGraphicsContext` doesn't support them:\n\n* `wxDC:getPixel/2` method is not implemented and always returns false because modern graphics layers don't\nsupport retrieving the contents of the drawn pixels.\n\n* `wxDC:floodFill/4` method is not, and can't be, implemented, as its functionality relies on reading the\npixels from `m:wxGraphicsContext` too.\n\n* `wxDC:setLogicalFunction/2` method only works with `wxCOPY`, `wxOR`, `wxNO_OP`, `wxCLEAR` and `wxXOR` functions,\nattempts to use any other function (including `wxINVERT`) don't do anything.\n\n* Similarly, ?wxRasterOperationMode parameter of `wxDC:blit/6` and `StretchBlit()` (not implemented in\nwx) can only be one of the supported logical functions listed above, using any other\nfunction will result in an assertion failure and not drawing anything.\n\n* For Direct2D-based `m:wxGraphicsContext`, only true-type fonts can be used in the\nfont-related functions.\n\nSee:\n* `m:wxDC`\n\n* `m:wxGraphicsContext`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxDC`\n\nwxWidgets docs: [wxGCDC](https://docs.wxwidgets.org/3.2/classwx_g_c_d_c.html)","ref":"wxGCDC.html"},{"type":"function","title":"wxGCDC.destroy/1","doc":"Destroys the object","ref":"wxGCDC.html#destroy/1"},{"type":"function","title":"wxGCDC.getGraphicsContext/1","doc":"Retrieves associated `m:wxGraphicsContext`.","ref":"wxGCDC.html#getGraphicsContext/1"},{"type":"function","title":"wxGCDC.new/0","doc":"","ref":"wxGCDC.html#new/0"},{"type":"function","title":"wxGCDC.new/1","doc":"Constructs a `m:wxGCDC` from a `m:wxWindowDC`.","ref":"wxGCDC.html#new/1"},{"type":"function","title":"wxGCDC.setGraphicsContext/2","doc":"Set the graphics context to be used for this `m:wxGCDC`.\n\nNote that this object takes ownership of `context` and will delete it when it is\ndestroyed or when `setGraphicsContext/2` is called again.\n\nAlso, unlike the constructor taking `m:wxGraphicsContext`, this method will reapply the\ncurrent font, pen and brush, so that this object continues to use them, if they had been\nchanged before (which is never the case when constructing `m:wxGCDC` directly from `m:wxGraphicsContext`).","ref":"wxGCDC.html#setGraphicsContext/2"},{"type":"type","title":"wxGCDC.wxGCDC/0","doc":"","ref":"wxGCDC.html#t:wxGCDC/0"},{"type":"module","title":"wxGLCanvas","doc":"`m:wxGLCanvas` is a class for displaying OpenGL graphics.\n\nIt is always used in conjunction with `m:wxGLContext` as the context can only be made\ncurrent (i.e. active for the OpenGL commands) when it is associated to a `m:wxGLCanvas`.\n\nMore precisely, you first need to create a `m:wxGLCanvas` window and then create an\ninstance of a `m:wxGLContext` that is initialized with this `m:wxGLCanvas` and then later\nuse either `setCurrent/2` with the instance of the `m:wxGLContext` or `wxGLContext:setCurrent/2` with the instance of the `m:wxGLCanvas`\n(which might be not the same as was used for the creation of the context) to bind the\nOpenGL state that is represented by the rendering context to the canvas, and then finally\ncall `swapBuffers/1` to swap the buffers of the OpenGL canvas and thus show your current output.\n\nPlease note that `m:wxGLContext` always uses physical pixels, even on the platforms where `m:wxWindow`\nuses logical pixels, affected by the coordinate scaling, on high DPI displays. Thus, if\nyou want to set the OpenGL view port to the size of entire window, you must multiply the\nresult returned by `wxWindow:getClientSize/1` by `wxWindow:getContentScaleFactor/1` before passing it to `glViewport()`. Same considerations apply to\nother OpenGL functions and other coordinates, notably those retrieved from `m:wxMouseEvent`\nin the event handlers.\n\nNotice that versions of wxWidgets previous to 2.9 used to implicitly create a `m:wxGLContext`\ninside `m:wxGLCanvas` itself. This is still supported in the current version but is\ndeprecated now and will be removed in the future, please update your code to create the\nrendering contexts explicitly.\n\nTo set up the attributes for the canvas (number of bits for the depth buffer, number of\nbits for the stencil buffer and so on) you pass them in the constructor using a `wxGLAttributes`\n(not implemented in wx) instance. You can still use the way before 3.1.0 (setting up the\ncorrect values of the `attribList` parameter) but it's discouraged.\n\nNote: On those platforms which use a configure script (e.g. Linux and macOS) OpenGL\nsupport is automatically enabled if the relative headers and libraries are found. To\nswitch it on under the other platforms (e.g. Windows), you need to edit the `setup.h` file\nand set `wxUSE_GLCANVAS` to `1` and then also pass `USE_OPENGL=1` to the make utility. You\nmay also need to add `opengl32.lib` (and `glu32.lib` for old OpenGL versions) to the list\nof the libraries your program is linked with.\n\nSee: `m:wxGLContext`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxGLCanvas](https://docs.wxwidgets.org/3.2/classwx_g_l_canvas.html)","ref":"wxGLCanvas.html"},{"type":"function","title":"wxGLCanvas.createSurface/1","doc":"","ref":"wxGLCanvas.html#createSurface/1"},{"type":"function","title":"wxGLCanvas.destroy/1","doc":"Destroys the object","ref":"wxGLCanvas.html#destroy/1"},{"type":"function","title":"wxGLCanvas.isDisplaySupported/1","doc":"Determines if a canvas having the specified attributes is available.\n\nThis only applies for visual attributes, not rendering context attributes. Please, use\nthe new form of this method, using `wxGLAttributes` (not implemented in wx).\n\nReturn: true if attributes are supported.","ref":"wxGLCanvas.html#isDisplaySupported/1"},{"type":"function","title":"wxGLCanvas.new/1","doc":"Equivalent to  new(Parent, []) .","ref":"wxGLCanvas.html#new/1"},{"type":"function","title":"wxGLCanvas.new/2","doc":"This constructor is still available only for compatibility reasons.\n\nPlease use the constructor with `wxGLAttributes` (not implemented in wx) instead.\n\nIf `attribList` is not specified, `wxGLAttributes::PlatformDefaults()` (not implemented\nin wx) is used, plus some other attributes (see below).","ref":"wxGLCanvas.html#new/2"},{"type":"function","title":"wxGLCanvas.setCurrent/2","doc":"Makes the OpenGL state that is represented by the OpenGL rendering context `context`\ncurrent, i.e.\n\nit will be used by all subsequent OpenGL calls.\n\nThis is equivalent to `wxGLContext:setCurrent/2` called with this window as parameter.\n\nNote: This function may only be called when the window is shown on screen, in particular\nit can't usually be called from the constructor as the window isn't yet shown at this moment.\n\nReturn: false if an error occurred.","ref":"wxGLCanvas.html#setCurrent/2"},{"type":"function","title":"wxGLCanvas.swapBuffers/1","doc":"Swaps the double-buffer of this window, making the back-buffer the front-buffer and vice\nversa, so that the output of the previous OpenGL commands is displayed on the window.\n\nReturn: false if an error occurred.","ref":"wxGLCanvas.html#swapBuffers/1"},{"type":"type","title":"wxGLCanvas.wxGLCanvas/0","doc":"","ref":"wxGLCanvas.html#t:wxGLCanvas/0"},{"type":"module","title":"wxGLContext","doc":"An instance of a `m:wxGLContext` represents the state of an OpenGL state machine and the\nconnection between OpenGL and the system.\n\nThe OpenGL state includes everything that can be set with the OpenGL API: colors,\nrendering variables, buffer data ids, texture objects, etc. It is possible to have\nmultiple rendering contexts share buffer data and textures. This feature is specially\nuseful when the application use multiple threads for updating data into the memory of the\ngraphics card.\n\nWhether one only rendering context is used with or bound to multiple output windows or if\neach window has its own bound context is a developer decision. It is important to take\ninto account that GPU makers may set different pointers to the same OGL function for\ndifferent contexts. The way these pointers are retrieved from the OGL driver should be\nused again for each new context.\n\nBinding (making current) a rendering context with another instance of a `m:wxGLCanvas`\nhowever works only if the both `m:wxGLCanvas` instances were created with the same attributes.\n\nOpenGL version 3 introduced a new type of specification profile, the modern core profile.\nThe old compatibility profile maintains all legacy features. Since wxWidgets 3.1.0 you can\nchoose the type of context and even ask for a specified OGL version number. However, its\nadvised to use only core profile as the compatibility profile may run a bit slower.\n\nOpenGL core profile specification defines several flags at context creation that\ndetermine not only the type of context but also some features. Some of these flags can be\nset in the list of attributes used at `m:wxGLCanvas` ctor. But since wxWidgets 3.1.0 it is\nstrongly encouraged to use the new mechanism: setting the context attributes with a `wxGLContextAttrs`\n(not implemented in wx) object and the canvas attributes with a `wxGLAttributes` (not\nimplemented in wx) object.\n\nThe best way of knowing if your OpenGL environment supports a specific type of context is\ncreating a `m:wxGLContext` instance and checking `isOK/1`. If it returns false, then simply delete\nthat instance and create a new one with other attributes.\n\nwxHAS_OPENGL_ES is defined on platforms that only have this implementation available\n(e.g. the iPhone) and don't support the full specification.\n\nSee: `m:wxGLCanvas`\n\nwxWidgets docs: [wxGLContext](https://docs.wxwidgets.org/3.2/classwx_g_l_context.html)","ref":"wxGLContext.html"},{"type":"function","title":"wxGLContext.destroy/1","doc":"Destroys the object","ref":"wxGLContext.html#destroy/1"},{"type":"function","title":"wxGLContext.isOK/1","doc":"Checks if the underlying OpenGL rendering context was correctly created by the system\nwith the requested attributes.\n\nIf this function returns false then the `m:wxGLContext` object is useless and should be\ndeleted and recreated with different attributes.\n\nSince: 3.1.0","ref":"wxGLContext.html#isOK/1"},{"type":"function","title":"wxGLContext.new/1","doc":"Equivalent to  new(Win, []) .","ref":"wxGLContext.html#new/1"},{"type":"function","title":"wxGLContext.new/2","doc":"Constructor.","ref":"wxGLContext.html#new/2"},{"type":"function","title":"wxGLContext.setCurrent/2","doc":"Makes the OpenGL state that is represented by this rendering context current with the `m:wxGLCanvas`\n`win`.\n\nNote: `win` can be a different `m:wxGLCanvas` window than the one that was passed to the\nconstructor of this rendering context. If `RC` is an object of type `m:wxGLContext`, the\nstatements `\"RC.SetCurrent(win);\"` and `\"win.SetCurrent(RC);\"` are equivalent, see `wxGLCanvas:setCurrent/2`.","ref":"wxGLContext.html#setCurrent/2"},{"type":"type","title":"wxGLContext.wxGLContext/0","doc":"","ref":"wxGLContext.html#t:wxGLContext/0"},{"type":"module","title":"wxGauge","doc":"A gauge is a horizontal or vertical bar which shows a quantity (often time).\n\n`m:wxGauge` supports two working modes: determinate and indeterminate progress.\n\nThe first is the usual working mode (see `setValue/2` and `setRange/2`) while the second can be used when the\nprogram is doing some processing but you don't know how much progress is being done. In\nthis case, you can periodically call the `pulse/1` function to make the progress bar switch to\nindeterminate mode (graphically it's usually a set of blocks which move or bounce in the\nbar control).\n\n`m:wxGauge` supports dynamic switch between these two work modes.\n\nThere are no user commands for the gauge.","ref":"wxGauge.html"},{"type":"module","title":"Styles - wxGauge","doc":"This class supports the following styles:\n\n* wxGA_HORIZONTAL: Creates a horizontal gauge.\n\n* wxGA_VERTICAL: Creates a vertical gauge.\n\n* wxGA_SMOOTH: Creates smooth progress bar with one pixel wide update step (not supported\nby all platforms).\n\n* wxGA_TEXT: Display the current value in percents in the gauge itself. This style is only\nsupported in wxQt and ignored under the other platforms. This flag is only available in\nwxWidgets 3.1.0 and later.\n\n* wxGA_PROGRESS: Reflect the value of gauge in the application taskbar button under Windows\n7 and later and the dock icon under macOS, ignored under the other platforms. This flag is\nonly available in wxWidgets 3.1.0 and later.\n\nSee:\n* `m:wxSlider`\n\n* `m:wxScrollBar`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxGauge](https://docs.wxwidgets.org/3.2/classwx_gauge.html)","ref":"wxGauge.html#module-styles"},{"type":"function","title":"wxGauge.create/4","doc":"Equivalent to  create(This, Parent, Id, Range, []) .","ref":"wxGauge.html#create/4"},{"type":"function","title":"wxGauge.create/5","doc":"Creates the gauge for two-step construction.\n\nSee `new/4` for further details.","ref":"wxGauge.html#create/5"},{"type":"function","title":"wxGauge.destroy/1","doc":"Destroys the object","ref":"wxGauge.html#destroy/1"},{"type":"function","title":"wxGauge.getRange/1","doc":"Returns the maximum position of the gauge.\n\nSee: `setRange/2`","ref":"wxGauge.html#getRange/1"},{"type":"function","title":"wxGauge.getValue/1","doc":"Returns the current position of the gauge.\n\nSee: `setValue/2`","ref":"wxGauge.html#getValue/1"},{"type":"function","title":"wxGauge.isVertical/1","doc":"Returns true if the gauge is vertical (has `wxGA_VERTICAL` style) and false otherwise.","ref":"wxGauge.html#isVertical/1"},{"type":"function","title":"wxGauge.new/0","doc":"Default constructor.","ref":"wxGauge.html#new/0"},{"type":"function","title":"wxGauge.new/3","doc":"Equivalent to  new(Parent, Id, Range, []) .","ref":"wxGauge.html#new/3"},{"type":"function","title":"wxGauge.new/4","doc":"Constructor, creating and showing a gauge.\n\nSee: `create/5`","ref":"wxGauge.html#new/4"},{"type":"function","title":"wxGauge.pulse/1","doc":"Switch the gauge to indeterminate mode (if required) and makes the gauge move a bit to\nindicate the user that some progress has been made.\n\nNote: After calling this function the value returned by `getValue/1` is undefined and thus you need\nto explicitly call `setValue/2` if you want to restore the determinate mode.","ref":"wxGauge.html#pulse/1"},{"type":"function","title":"wxGauge.setRange/2","doc":"Sets the range (maximum value) of the gauge.\n\nThis function makes the gauge switch to determinate mode, if it's not already.\n\nWhen the gauge is in indeterminate mode, under wxMSW the gauge repeatedly goes from zero\nto `range` and back; under other ports when in indeterminate mode, the `range` setting is ignored.\n\nSee: `getRange/1`","ref":"wxGauge.html#setRange/2"},{"type":"function","title":"wxGauge.setValue/2","doc":"Sets the position of the gauge.\n\nThe `pos` must be between 0 and the gauge range as returned by `getRange/1`, inclusive.\n\nThis function makes the gauge switch to determinate mode, if it was in indeterminate mode before.\n\nSee: `getValue/1`","ref":"wxGauge.html#setValue/2"},{"type":"type","title":"wxGauge.wxGauge/0","doc":"","ref":"wxGauge.html#t:wxGauge/0"},{"type":"module","title":"wxGenericDirCtrl","doc":"This control can be used to place a directory listing (with optional files) on an\narbitrary window.\n\nThe control contains a `m:wxTreeCtrl` window representing the directory hierarchy, and\noptionally, a `m:wxChoice` window containing a list of filters.","ref":"wxGenericDirCtrl.html"},{"type":"module","title":"Styles - wxGenericDirCtrl","doc":"This class supports the following styles:\n\n* wxDIRCTRL_DIR_ONLY: Only show directories, and not files.\n\n* wxDIRCTRL_3D_INTERNAL: Use 3D borders for internal controls. This is the default.\n\n* wxDIRCTRL_SELECT_FIRST: When setting the default path, select the first file in the\ndirectory.\n\n* wxDIRCTRL_SHOW_FILTERS: Show the drop-down filter list.\n\n* wxDIRCTRL_EDIT_LABELS: Allow the folder and file labels to be editable.\n\n* wxDIRCTRL_MULTIPLE: Allows multiple files and folders to be selected.\n\nThis class is derived, and can use functions, from:\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxGenericDirCtrl](https://docs.wxwidgets.org/3.2/classwx_generic_dir_ctrl.html)","ref":"wxGenericDirCtrl.html#module-styles"},{"type":"module","title":"Events - wxGenericDirCtrl","doc":"Event types emitted from this class:\n\n* [`dirctrl_selectionchanged`](`m:wxTreeEvent`)\n\n* [`dirctrl_fileactivated`](`m:wxTreeEvent`)","ref":"wxGenericDirCtrl.html#module-events"},{"type":"function","title":"wxGenericDirCtrl.collapseTree/1","doc":"Collapses the entire tree.","ref":"wxGenericDirCtrl.html#collapseTree/1"},{"type":"function","title":"wxGenericDirCtrl.create/2","doc":"Equivalent to  create(This, Parent, []) .","ref":"wxGenericDirCtrl.html#create/2"},{"type":"function","title":"wxGenericDirCtrl.create/3","doc":"Create function for two-step construction.\n\nSee `new/2` for details.","ref":"wxGenericDirCtrl.html#create/3"},{"type":"function","title":"wxGenericDirCtrl.destroy/1","doc":"Destroys the object","ref":"wxGenericDirCtrl.html#destroy/1"},{"type":"function","title":"wxGenericDirCtrl.expandPath/2","doc":"Tries to expand as much of the given `path` as possible, so that the filename or\ndirectory is visible in the tree control.","ref":"wxGenericDirCtrl.html#expandPath/2"},{"type":"function","title":"wxGenericDirCtrl.getDefaultPath/1","doc":"Gets the default path.","ref":"wxGenericDirCtrl.html#getDefaultPath/1"},{"type":"function","title":"wxGenericDirCtrl.getFilePath/1","doc":"Gets selected filename path only (else empty string).\n\nThis function doesn't count a directory as a selection.","ref":"wxGenericDirCtrl.html#getFilePath/1"},{"type":"function","title":"wxGenericDirCtrl.getFilter/1","doc":"Returns the filter string.","ref":"wxGenericDirCtrl.html#getFilter/1"},{"type":"function","title":"wxGenericDirCtrl.getFilterIndex/1","doc":"Returns the current filter index (zero-based).","ref":"wxGenericDirCtrl.html#getFilterIndex/1"},{"type":"function","title":"wxGenericDirCtrl.getPath/1","doc":"Gets the currently-selected directory or filename.","ref":"wxGenericDirCtrl.html#getPath/1"},{"type":"function","title":"wxGenericDirCtrl.getPath/2","doc":"Gets the path corresponding to the given tree control item.\n\nSince: 2.9.5","ref":"wxGenericDirCtrl.html#getPath/2"},{"type":"function","title":"wxGenericDirCtrl.getRootId/1","doc":"Returns the root id for the tree control.","ref":"wxGenericDirCtrl.html#getRootId/1"},{"type":"function","title":"wxGenericDirCtrl.getTreeCtrl/1","doc":"Returns a pointer to the tree control.","ref":"wxGenericDirCtrl.html#getTreeCtrl/1"},{"type":"function","title":"wxGenericDirCtrl.init/1","doc":"Initializes variables.","ref":"wxGenericDirCtrl.html#init/1"},{"type":"function","title":"wxGenericDirCtrl.new/0","doc":"Default constructor.","ref":"wxGenericDirCtrl.html#new/0"},{"type":"function","title":"wxGenericDirCtrl.new/1","doc":"Equivalent to  new(Parent, []) .","ref":"wxGenericDirCtrl.html#new/1"},{"type":"function","title":"wxGenericDirCtrl.new/2","doc":"Main constructor.","ref":"wxGenericDirCtrl.html#new/2"},{"type":"function","title":"wxGenericDirCtrl.reCreateTree/1","doc":"Collapse and expand the tree, thus re-creating it from scratch.\n\nMay be used to update the displayed directory content.","ref":"wxGenericDirCtrl.html#reCreateTree/1"},{"type":"function","title":"wxGenericDirCtrl.setDefaultPath/2","doc":"Sets the default path.","ref":"wxGenericDirCtrl.html#setDefaultPath/2"},{"type":"function","title":"wxGenericDirCtrl.setFilter/2","doc":"Sets the filter string.","ref":"wxGenericDirCtrl.html#setFilter/2"},{"type":"function","title":"wxGenericDirCtrl.setFilterIndex/2","doc":"Sets the current filter index (zero-based).","ref":"wxGenericDirCtrl.html#setFilterIndex/2"},{"type":"function","title":"wxGenericDirCtrl.setPath/2","doc":"Sets the current path.","ref":"wxGenericDirCtrl.html#setPath/2"},{"type":"type","title":"wxGenericDirCtrl.wxGenericDirCtrl/0","doc":"","ref":"wxGenericDirCtrl.html#t:wxGenericDirCtrl/0"},{"type":"module","title":"wxGraphicsBrush","doc":"A `m:wxGraphicsBrush` is a native representation of a brush.\n\nThe contents are specific and private to the respective renderer. Instances are ref\ncounted and can therefore be assigned as usual. The only way to get a valid instance is\nvia `wxGraphicsContext:createBrush/2` or `wxGraphicsRenderer:createBrush/2`.\n\nThis class is derived, and can use functions, from:\n\n* `m:wxGraphicsObject`\n\nwxWidgets docs: [wxGraphicsBrush](https://docs.wxwidgets.org/3.2/classwx_graphics_brush.html)","ref":"wxGraphicsBrush.html"},{"type":"type","title":"wxGraphicsBrush.wxGraphicsBrush/0","doc":"","ref":"wxGraphicsBrush.html#t:wxGraphicsBrush/0"},{"type":"module","title":"wxGraphicsContext","doc":"A `m:wxGraphicsContext` instance is the object that is drawn upon.\n\nIt is created by a renderer using `wxGraphicsRenderer:createContext/2`. This can be either directly using a renderer\ninstance, or indirectly using the static convenience `create/1` functions of `m:wxGraphicsContext`\nthat always delegate the task to the default renderer.\n\nRemark: For some renderers (like Direct2D or Cairo) processing of drawing operations may\nbe deferred (Direct2D render target normally builds up a batch of rendering commands but\ndefers processing of these commands, Cairo operates on a separate surface) so to make\ndrawing results visible you need to update the content of the context by calling `wxGraphicsContext::Flush()`\n(not implemented in wx) or by destroying the context.\n\nSee:\n* `wxGraphicsRenderer:createContext/2`\n\n* `m:wxGCDC`\n\n* `m:wxDC`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxGraphicsObject`\n\nwxWidgets docs: [wxGraphicsContext](https://docs.wxwidgets.org/3.2/classwx_graphics_context.html)","ref":"wxGraphicsContext.html"},{"type":"function","title":"wxGraphicsContext.clip/2","doc":"Sets the clipping region to the intersection of the given region and the previously set\nclipping region.\n\nThe clipping region is an area to which drawing is restricted.\n\nRemark:\n\n* Clipping region should be given in logical coordinates.\n\n* Calling this function can only make the clipping region smaller, never larger.\n\n* You need to call `resetClip/1` first if you want to set the clipping region exactly to the region specified.\n\n* If resulting clipping region is empty, then all drawing upon the context is clipped out\n(all changes made by drawing operations are masked out).","ref":"wxGraphicsContext.html#clip/2"},{"type":"function","title":"wxGraphicsContext.clip/5","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxGraphicsContext.html#clip/5"},{"type":"function","title":"wxGraphicsContext.concatTransform/2","doc":"Concatenates the passed in transform with the current transform of this context.","ref":"wxGraphicsContext.html#concatTransform/2"},{"type":"function","title":"wxGraphicsContext.create/0","doc":"Create a lightweight context that can be used only for measuring text.","ref":"wxGraphicsContext.html#create/0"},{"type":"function","title":"wxGraphicsContext.create/1","doc":"Creates a `m:wxGraphicsContext` from a `m:wxWindowDC`.\n\nSee: `wxGraphicsRenderer:createContext/2`","ref":"wxGraphicsContext.html#create/1"},{"type":"function","title":"wxGraphicsContext.createBrush/2","doc":"Creates a native brush from a `m:wxBrush`.","ref":"wxGraphicsContext.html#createBrush/2"},{"type":"function","title":"wxGraphicsContext.createFont/2","doc":"Equivalent to  createFont(This, Font, []) .","ref":"wxGraphicsContext.html#createFont/2"},{"type":"function","title":"wxGraphicsContext.createFont/3","doc":"Creates a native graphics font from a `m:wxFont` and a text colour.\n\nRemark: For Direct2D graphics fonts can be created from TrueType fonts only.","ref":"wxGraphicsContext.html#createFont/3"},{"type":"function","title":"wxGraphicsContext.createFont/4","doc":"Creates a font object with the specified attributes.\n\nThe use of overload taking `m:wxFont` is preferred, see `wxGraphicsRenderer:createFont/4` for more details.\n\nRemark: For Direct2D graphics fonts can be created from TrueType fonts only.\n\nSince: 2.9.3","ref":"wxGraphicsContext.html#createFont/4"},{"type":"function","title":"wxGraphicsContext.createLinearGradientBrush/6","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxGraphicsContext.html#createLinearGradientBrush/6"},{"type":"function","title":"wxGraphicsContext.createLinearGradientBrush/7","doc":"` Creates a native brush with a linear gradient. The brush starts at (@a x1, @a y1) and\nends at (@a x2, @a y2). Either just the start and end gradient colours (@a c1 and @a c2)\nor full set of gradient @a stops can be specified. The version taking\nwxGraphicsGradientStops is new in wxWidgets 2.9.1. `\nThe `matrix` parameter was added in wxWidgets 3.1.3","ref":"wxGraphicsContext.html#createLinearGradientBrush/7"},{"type":"function","title":"wxGraphicsContext.createMatrix/1","doc":"Equivalent to  createMatrix(This, []) .","ref":"wxGraphicsContext.html#createMatrix/1"},{"type":"function","title":"wxGraphicsContext.createMatrix/2","doc":"Creates a native affine transformation matrix from the passed in values.\n\nThe default parameters result in an identity matrix.","ref":"wxGraphicsContext.html#createMatrix/2"},{"type":"function","title":"wxGraphicsContext.createPath/1","doc":"Creates a native graphics path which is initially empty.","ref":"wxGraphicsContext.html#createPath/1"},{"type":"function","title":"wxGraphicsContext.createPen/2","doc":"Creates a native pen from a `m:wxPen`.\n\nPrefer to use the overload taking `wxGraphicsPenInfo` (not implemented in wx) unless you\nalready have a `m:wxPen` as constructing one only to pass it to this method is wasteful.","ref":"wxGraphicsContext.html#createPen/2"},{"type":"function","title":"wxGraphicsContext.createRadialGradientBrush/7","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxGraphicsContext.html#createRadialGradientBrush/7"},{"type":"function","title":"wxGraphicsContext.createRadialGradientBrush/8","doc":"` Creates a native brush with a radial gradient. The brush originates at (@a startX, @a\nstartY) and ends on a circle around (@a endX, @a endY) with the given @a radius. The\ngradient may be specified either by its start and end colours @a oColor and @a cColor or\nby a full set of gradient @a stops. The version taking wxGraphicsGradientStops is new in\nwxWidgets 2.9.1. `\nThe ability to apply a transformation matrix to the gradient was added in 3.1.3","ref":"wxGraphicsContext.html#createRadialGradientBrush/8"},{"type":"function","title":"wxGraphicsContext.destroy/1","doc":"Destroys the object","ref":"wxGraphicsContext.html#destroy/1"},{"type":"function","title":"wxGraphicsContext.drawBitmap/6","doc":"Draws the bitmap.\n\nIn case of a mono bitmap, this is treated as a mask and the current brushed is used for\nfilling.","ref":"wxGraphicsContext.html#drawBitmap/6"},{"type":"function","title":"wxGraphicsContext.drawEllipse/5","doc":"Draws an ellipse.","ref":"wxGraphicsContext.html#drawEllipse/5"},{"type":"function","title":"wxGraphicsContext.drawIcon/6","doc":"Draws the icon.","ref":"wxGraphicsContext.html#drawIcon/6"},{"type":"function","title":"wxGraphicsContext.drawLines/2","doc":"Equivalent to  drawLines(This, Points, []) .","ref":"wxGraphicsContext.html#drawLines/2"},{"type":"function","title":"wxGraphicsContext.drawLines/3","doc":"Draws a polygon.","ref":"wxGraphicsContext.html#drawLines/3"},{"type":"function","title":"wxGraphicsContext.drawPath/2","doc":"Equivalent to  drawPath(This, Path, []) .","ref":"wxGraphicsContext.html#drawPath/2"},{"type":"function","title":"wxGraphicsContext.drawPath/3","doc":"Draws the path by first filling and then stroking.","ref":"wxGraphicsContext.html#drawPath/3"},{"type":"function","title":"wxGraphicsContext.drawRectangle/5","doc":"Draws a rectangle.","ref":"wxGraphicsContext.html#drawRectangle/5"},{"type":"function","title":"wxGraphicsContext.drawRoundedRectangle/6","doc":"Draws a rounded rectangle.","ref":"wxGraphicsContext.html#drawRoundedRectangle/6"},{"type":"function","title":"wxGraphicsContext.drawText/4","doc":"Draws text at the defined position.","ref":"wxGraphicsContext.html#drawText/4"},{"type":"function","title":"wxGraphicsContext.drawText/5","doc":"Draws text at the defined position.","ref":"wxGraphicsContext.html#drawText/5"},{"type":"function","title":"wxGraphicsContext.drawText/6","doc":"Draws text at the defined position.","ref":"wxGraphicsContext.html#drawText/6"},{"type":"function","title":"wxGraphicsContext.fillPath/2","doc":"Equivalent to  fillPath(This, Path, []) .","ref":"wxGraphicsContext.html#fillPath/2"},{"type":"function","title":"wxGraphicsContext.fillPath/3","doc":"Fills the path with the current brush.","ref":"wxGraphicsContext.html#fillPath/3"},{"type":"function","title":"wxGraphicsContext.getPartialTextExtents/2","doc":"Fills the `widths` array with the widths from the beginning of `text` to the\ncorresponding character of `text`.","ref":"wxGraphicsContext.html#getPartialTextExtents/2"},{"type":"function","title":"wxGraphicsContext.getTextExtent/2","doc":"Gets the dimensions of the string using the currently selected font.","ref":"wxGraphicsContext.html#getTextExtent/2"},{"type":"function","title":"wxGraphicsContext.getTransform/1","doc":"Gets the current transformation matrix of this context.","ref":"wxGraphicsContext.html#getTransform/1"},{"type":"function","title":"wxGraphicsContext.resetClip/1","doc":"Resets the clipping to original shape.","ref":"wxGraphicsContext.html#resetClip/1"},{"type":"function","title":"wxGraphicsContext.rotate/2","doc":"Rotates the current transformation matrix (in radians).","ref":"wxGraphicsContext.html#rotate/2"},{"type":"function","title":"wxGraphicsContext.scale/3","doc":"Scales the current transformation matrix.","ref":"wxGraphicsContext.html#scale/3"},{"type":"function","title":"wxGraphicsContext.setBrush/2","doc":"Sets the brush for filling paths.","ref":"wxGraphicsContext.html#setBrush/2"},{"type":"function","title":"wxGraphicsContext.setFont/2","doc":"Sets the font for drawing text.","ref":"wxGraphicsContext.html#setFont/2"},{"type":"function","title":"wxGraphicsContext.setFont/3","doc":"Sets the font for drawing text.\n\nRemark: For Direct2D only TrueType fonts can be used.","ref":"wxGraphicsContext.html#setFont/3"},{"type":"function","title":"wxGraphicsContext.setPen/2","doc":"Sets the pen used for stroking.","ref":"wxGraphicsContext.html#setPen/2"},{"type":"function","title":"wxGraphicsContext.setTransform/2","doc":"Sets the current transformation matrix of this context.","ref":"wxGraphicsContext.html#setTransform/2"},{"type":"function","title":"wxGraphicsContext.strokeLine/5","doc":"Strokes a single line.","ref":"wxGraphicsContext.html#strokeLine/5"},{"type":"function","title":"wxGraphicsContext.strokeLines/2","doc":"Stroke lines connecting all the points.\n\nUnlike the other overload of this function, this method draws a single polyline and not a\nnumber of disconnected lines.","ref":"wxGraphicsContext.html#strokeLines/2"},{"type":"function","title":"wxGraphicsContext.strokePath/2","doc":"Strokes along a path with the current pen.","ref":"wxGraphicsContext.html#strokePath/2"},{"type":"function","title":"wxGraphicsContext.translate/3","doc":"Translates the current transformation matrix.","ref":"wxGraphicsContext.html#translate/3"},{"type":"type","title":"wxGraphicsContext.wxGraphicsContext/0","doc":"","ref":"wxGraphicsContext.html#t:wxGraphicsContext/0"},{"type":"module","title":"wxGraphicsFont","doc":"A `m:wxGraphicsFont` is a native representation of a font.\n\nThe contents are specific and private to the respective renderer. Instances are ref\ncounted and can therefore be assigned as usual. The only way to get a valid instance is\nvia `wxGraphicsContext:createFont/4` or `wxGraphicsRenderer:createFont/4`.\n\nThis class is derived, and can use functions, from:\n\n* `m:wxGraphicsObject`\n\nwxWidgets docs: [wxGraphicsFont](https://docs.wxwidgets.org/3.2/classwx_graphics_font.html)","ref":"wxGraphicsFont.html"},{"type":"type","title":"wxGraphicsFont.wxGraphicsFont/0","doc":"","ref":"wxGraphicsFont.html#t:wxGraphicsFont/0"},{"type":"module","title":"wxGraphicsGradientStops","doc":"Represents a collection of wxGraphicGradientStop values for use with\nCreateLinearGradientBrush and CreateRadialGradientBrush.\n\nThe stops are maintained in order of position. If two or more stops are added with the\nsame position then the one(s) added later come later. This can be useful for producing\ndiscontinuities in the colour gradient.\n\nNotice that this class is write-once, you can't modify the stops once they had been added.\n\nSince: 2.9.1\n\nwxWidgets docs: [wxGraphicsGradientStops](https://docs.wxwidgets.org/3.2/classwx_graphics_gradient_stops.html)","ref":"wxGraphicsGradientStops.html"},{"type":"function","title":"wxGraphicsGradientStops.add/3","doc":"Add a new stop.","ref":"wxGraphicsGradientStops.html#add/3"},{"type":"function","title":"wxGraphicsGradientStops.destroy/1","doc":"Destroys the object","ref":"wxGraphicsGradientStops.html#destroy/1"},{"type":"function","title":"wxGraphicsGradientStops.getCount/1","doc":"Returns the number of stops.","ref":"wxGraphicsGradientStops.html#getCount/1"},{"type":"function","title":"wxGraphicsGradientStops.getEndColour/1","doc":"Returns the end colour.","ref":"wxGraphicsGradientStops.html#getEndColour/1"},{"type":"function","title":"wxGraphicsGradientStops.getStartColour/1","doc":"Returns the start colour.","ref":"wxGraphicsGradientStops.html#getStartColour/1"},{"type":"function","title":"wxGraphicsGradientStops.item/2","doc":"Returns the stop at the given index.","ref":"wxGraphicsGradientStops.html#item/2"},{"type":"function","title":"wxGraphicsGradientStops.new/0","doc":"Equivalent to  new([]) .","ref":"wxGraphicsGradientStops.html#new/0"},{"type":"function","title":"wxGraphicsGradientStops.new/1","doc":"Initializes the gradient stops with the given boundary colours.\n\nCreates a `m:wxGraphicsGradientStops` instance with start colour given by `startCol` and\nend colour given by `endCol`.","ref":"wxGraphicsGradientStops.html#new/1"},{"type":"function","title":"wxGraphicsGradientStops.setEndColour/2","doc":"Set the end colour to `col`.","ref":"wxGraphicsGradientStops.html#setEndColour/2"},{"type":"function","title":"wxGraphicsGradientStops.setStartColour/2","doc":"Set the start colour to `col`.","ref":"wxGraphicsGradientStops.html#setStartColour/2"},{"type":"type","title":"wxGraphicsGradientStops.wxGraphicsGradientStops/0","doc":"","ref":"wxGraphicsGradientStops.html#t:wxGraphicsGradientStops/0"},{"type":"module","title":"wxGraphicsMatrix","doc":"A `m:wxGraphicsMatrix` is a native representation of an affine matrix.\n\nThe contents are specific and private to the respective renderer. Instances are ref\ncounted and can therefore be assigned as usual. The only way to get a valid instance is\nvia `wxGraphicsContext:createMatrix/2` or `wxGraphicsRenderer:createMatrix/2`.\n\nThis class is derived, and can use functions, from:\n\n* `m:wxGraphicsObject`\n\nwxWidgets docs: [wxGraphicsMatrix](https://docs.wxwidgets.org/3.2/classwx_graphics_matrix.html)","ref":"wxGraphicsMatrix.html"},{"type":"function","title":"wxGraphicsMatrix.concat/2","doc":"Concatenates the matrix passed with the current matrix.\n\nThe effect of the resulting transformation is to first apply the transformation in `t` to\nthe coordinates and then apply the transformation in the current matrix to the coordinates.","ref":"wxGraphicsMatrix.html#concat/2"},{"type":"function","title":"wxGraphicsMatrix.get/1","doc":"Returns the component values of the matrix via the argument pointers.","ref":"wxGraphicsMatrix.html#get/1"},{"type":"function","title":"wxGraphicsMatrix.invert/1","doc":"Inverts the matrix.","ref":"wxGraphicsMatrix.html#invert/1"},{"type":"function","title":"wxGraphicsMatrix.isEqual/2","doc":"Returns true if the elements of the transformation matrix are equal.","ref":"wxGraphicsMatrix.html#isEqual/2"},{"type":"function","title":"wxGraphicsMatrix.isIdentity/1","doc":"Return true if this is the identity matrix.","ref":"wxGraphicsMatrix.html#isIdentity/1"},{"type":"function","title":"wxGraphicsMatrix.rotate/2","doc":"Rotates this matrix clockwise (in radians).","ref":"wxGraphicsMatrix.html#rotate/2"},{"type":"function","title":"wxGraphicsMatrix.scale/3","doc":"Scales this matrix.","ref":"wxGraphicsMatrix.html#scale/3"},{"type":"function","title":"wxGraphicsMatrix.set/1","doc":"Equivalent to  set(This, []) .","ref":"wxGraphicsMatrix.html#set/1"},{"type":"function","title":"wxGraphicsMatrix.set/2","doc":"Sets the matrix to the respective values (default values are the identity matrix).","ref":"wxGraphicsMatrix.html#set/2"},{"type":"function","title":"wxGraphicsMatrix.transformDistance/1","doc":"Applies this matrix to a distance (ie.\n\nperforms all transforms except translations).","ref":"wxGraphicsMatrix.html#transformDistance/1"},{"type":"function","title":"wxGraphicsMatrix.transformPoint/1","doc":"Applies this matrix to a point.","ref":"wxGraphicsMatrix.html#transformPoint/1"},{"type":"function","title":"wxGraphicsMatrix.translate/3","doc":"Translates this matrix.","ref":"wxGraphicsMatrix.html#translate/3"},{"type":"type","title":"wxGraphicsMatrix.wxGraphicsMatrix/0","doc":"","ref":"wxGraphicsMatrix.html#t:wxGraphicsMatrix/0"},{"type":"module","title":"wxGraphicsObject","doc":"This class is the superclass of native graphics objects like pens etc.\n\nIt allows reference counting. Not instantiated by user code.\n\nSee:\n* `m:wxGraphicsBrush`\n\n* `m:wxGraphicsPen`\n\n* `m:wxGraphicsMatrix`\n\n* `m:wxGraphicsPath`\n\nwxWidgets docs: [wxGraphicsObject](https://docs.wxwidgets.org/3.2/classwx_graphics_object.html)","ref":"wxGraphicsObject.html"},{"type":"function","title":"wxGraphicsObject.destroy/1","doc":"Destroys the object","ref":"wxGraphicsObject.html#destroy/1"},{"type":"function","title":"wxGraphicsObject.getRenderer/1","doc":"Returns the renderer that was used to create this instance, or NULL if it has not been\ninitialized yet.","ref":"wxGraphicsObject.html#getRenderer/1"},{"type":"function","title":"wxGraphicsObject.isNull/1","doc":"Return: false if this object is valid, otherwise returns true.","ref":"wxGraphicsObject.html#isNull/1"},{"type":"type","title":"wxGraphicsObject.wxGraphicsObject/0","doc":"","ref":"wxGraphicsObject.html#t:wxGraphicsObject/0"},{"type":"module","title":"wxGraphicsPath","doc":"A `m:wxGraphicsPath` is a native representation of a geometric path.\n\nThe contents are specific and private to the respective renderer. Instances are reference\ncounted and can therefore be assigned as usual. The only way to get a valid instance is by\nusing `wxGraphicsContext:createPath/1` or `wxGraphicsRenderer:createPath/1`.\n\nThis class is derived, and can use functions, from:\n\n* `m:wxGraphicsObject`\n\nwxWidgets docs: [wxGraphicsPath](https://docs.wxwidgets.org/3.2/classwx_graphics_path.html)","ref":"wxGraphicsPath.html"},{"type":"function","title":"wxGraphicsPath.addArc/6","doc":"","ref":"wxGraphicsPath.html#addArc/6"},{"type":"function","title":"wxGraphicsPath.addArc/7","doc":"Adds an arc of a circle.\n\nThe circle is defined by the coordinates of its centre (`x`, `y`) or `c` and its radius `r`.\nThe arc goes from the starting angle `startAngle` to `endAngle` either clockwise or\ncounter-clockwise depending on the value of `clockwise` argument.\n\nThe angles are measured in radians but, contrary to the usual mathematical convention,\nare always `clockwise` from the horizontal axis.\n\nIf for clockwise arc `endAngle` is less than `startAngle` it will be progressively\nincreased by 2*pi until it is greater than `startAngle`. If for counter-clockwise arc `endAngle`\nis greater than `startAngle` it will be progressively decreased by 2*pi until it is less\nthan `startAngle`.\n\nIf there is a current point set, an initial line segment will be added to the path to\nconnect the current point to the beginning of the arc.","ref":"wxGraphicsPath.html#addArc/7"},{"type":"function","title":"wxGraphicsPath.addArcToPoint/6","doc":"Adds an arc (of a circle with radius `r`) that is tangent to the line connecting current\npoint and (`x1`, `y1`) and to the line connecting (`x1`, `y1`) and (`x2`, `y2`).\n\nIf the current point and the starting point of the arc are different, a straight line\nconnecting these points is also appended. If there is no current point before the call to `addArcToPoint/6`\nthis function will behave as if preceded by a call to MoveToPoint(0, 0). After this call\nthe current point will be at the ending point of the arc.","ref":"wxGraphicsPath.html#addArcToPoint/6"},{"type":"function","title":"wxGraphicsPath.addCircle/4","doc":"Appends a circle around (`x`,`y`) with radius `r` as a new closed subpath.\n\nAfter this call the current point will be at (x+`r`, `y`).","ref":"wxGraphicsPath.html#addCircle/4"},{"type":"function","title":"wxGraphicsPath.addCurveToPoint/4","doc":"Adds a cubic bezier curve from the current point, using two control points and an end\npoint.\n\nIf there is no current point before the call to `addCurveToPoint/7` this function will behave as if preceded\nby a call to MoveToPoint(`c1`).","ref":"wxGraphicsPath.html#addCurveToPoint/4"},{"type":"function","title":"wxGraphicsPath.addCurveToPoint/7","doc":"Adds a cubic bezier curve from the current point, using two control points and an end\npoint.\n\nIf there is no current point before the call to `addCurveToPoint/7` this function will behave as if preceded\nby a call to MoveToPoint(`cx1`, `cy1`).","ref":"wxGraphicsPath.html#addCurveToPoint/7"},{"type":"function","title":"wxGraphicsPath.addEllipse/5","doc":"Appends an ellipse fitting into the passed in rectangle as a new closed subpath.\n\nAfter this call the current point will be at (x+`w`, y+`h/2`).","ref":"wxGraphicsPath.html#addEllipse/5"},{"type":"function","title":"wxGraphicsPath.addLineToPoint/2","doc":"Adds a straight line from the current point to `p`.\n\nIf current point is not yet set before the call to `addLineToPoint/3` this function will behave as `moveToPoint/3`.","ref":"wxGraphicsPath.html#addLineToPoint/2"},{"type":"function","title":"wxGraphicsPath.addLineToPoint/3","doc":"Adds a straight line from the current point to (`x`,`y`).\n\nIf current point is not yet set before the call to `addLineToPoint/3` this function will behave as `moveToPoint/3`.","ref":"wxGraphicsPath.html#addLineToPoint/3"},{"type":"function","title":"wxGraphicsPath.addPath/2","doc":"Adds another path onto the current path.\n\nAfter this call the current point will be at the added path's current point. For Direct2D\nthe path being appended shouldn't contain a started non-empty subpath when this function\nis called.","ref":"wxGraphicsPath.html#addPath/2"},{"type":"function","title":"wxGraphicsPath.addQuadCurveToPoint/5","doc":"Adds a quadratic bezier curve from the current point, using a control point and an end\npoint.\n\nIf there is no current point before the call to `addQuadCurveToPoint/5` this function will behave as if preceded\nby a call to MoveToPoint(`cx`, `cy`).","ref":"wxGraphicsPath.html#addQuadCurveToPoint/5"},{"type":"function","title":"wxGraphicsPath.addRectangle/5","doc":"Appends a rectangle as a new closed subpath.\n\nAfter this call the current point will be at (`x`, `y`).","ref":"wxGraphicsPath.html#addRectangle/5"},{"type":"function","title":"wxGraphicsPath.addRoundedRectangle/6","doc":"Appends a rounded rectangle as a new closed subpath.\n\nIf `radius` equals 0 this function will behave as `addRectangle/5`, otherwise after this call the current\npoint will be at (x+`w`, y+`h/2`).","ref":"wxGraphicsPath.html#addRoundedRectangle/6"},{"type":"function","title":"wxGraphicsPath.closeSubpath/1","doc":"Closes the current sub-path.\n\nAfter this call the current point will be at the joined endpoint of the sub-path.","ref":"wxGraphicsPath.html#closeSubpath/1"},{"type":"function","title":"wxGraphicsPath.contains/2","doc":"Equivalent to  contains(This, C, []) .","ref":"wxGraphicsPath.html#contains/2"},{"type":"function","title":"wxGraphicsPath.contains/3","doc":"Return: true if the point is within the path.","ref":"wxGraphicsPath.html#contains/3"},{"type":"function","title":"wxGraphicsPath.contains/4","doc":"Return: true if the point is within the path.","ref":"wxGraphicsPath.html#contains/4"},{"type":"function","title":"wxGraphicsPath.getBox/1","doc":"Gets the bounding box enclosing all points (possibly including control points).","ref":"wxGraphicsPath.html#getBox/1"},{"type":"function","title":"wxGraphicsPath.getCurrentPoint/1","doc":"Gets the last point of the current path, (0,0) if not yet set.","ref":"wxGraphicsPath.html#getCurrentPoint/1"},{"type":"function","title":"wxGraphicsPath.moveToPoint/2","doc":"Begins a new subpath at `p`.","ref":"wxGraphicsPath.html#moveToPoint/2"},{"type":"function","title":"wxGraphicsPath.moveToPoint/3","doc":"Begins a new subpath at (`x`,`y`).","ref":"wxGraphicsPath.html#moveToPoint/3"},{"type":"function","title":"wxGraphicsPath.transform/2","doc":"Transforms each point of this path by the matrix.\n\nFor Direct2D the current path shouldn't contain a started non-empty subpath when this\nfunction is called.","ref":"wxGraphicsPath.html#transform/2"},{"type":"type","title":"wxGraphicsPath.wxGraphicsPath/0","doc":"","ref":"wxGraphicsPath.html#t:wxGraphicsPath/0"},{"type":"module","title":"wxGraphicsPen","doc":"A `m:wxGraphicsPen` is a native representation of a pen.\n\nThe contents are specific and private to the respective renderer. Instances are ref\ncounted and can therefore be assigned as usual. The only way to get a valid instance is\nvia `wxGraphicsContext:createPen/2` or `wxGraphicsRenderer::CreatePen()` (not implemented in wx).\n\nThis class is derived, and can use functions, from:\n\n* `m:wxGraphicsObject`\n\nwxWidgets docs: [wxGraphicsPen](https://docs.wxwidgets.org/3.2/classwx_graphics_pen.html)","ref":"wxGraphicsPen.html"},{"type":"type","title":"wxGraphicsPen.wxGraphicsPen/0","doc":"","ref":"wxGraphicsPen.html#t:wxGraphicsPen/0"},{"type":"module","title":"wxGraphicsRenderer","doc":"A `m:wxGraphicsRenderer` is the instance corresponding to the rendering engine used.\n\nThere may be multiple instances on a system, if there are different rendering engines\npresent, but there is always only one instance per engine. This instance is pointed back\nto by all objects created by it (`m:wxGraphicsContext`, `m:wxGraphicsPath` etc.) and can\nbe retrieved through their `wxGraphicsObject:getRenderer/1` method. Therefore you can create an additional instance of a\npath etc. by calling `wxGraphicsObject:getRenderer/1` and then using the appropriate CreateXXX() function of that renderer.\n\nwxWidgets docs: [wxGraphicsRenderer](https://docs.wxwidgets.org/3.2/classwx_graphics_renderer.html)","ref":"wxGraphicsRenderer.html"},{"type":"function","title":"wxGraphicsRenderer.createBrush/2","doc":"Creates a native brush from a `m:wxBrush`.","ref":"wxGraphicsRenderer.html#createBrush/2"},{"type":"function","title":"wxGraphicsRenderer.createContext/2","doc":"Creates a `m:wxGraphicsContext` from a `m:wxWindowDC`.","ref":"wxGraphicsRenderer.html#createContext/2"},{"type":"function","title":"wxGraphicsRenderer.createFont/2","doc":"Equivalent to  createFont(This, Font, []) .","ref":"wxGraphicsRenderer.html#createFont/2"},{"type":"function","title":"wxGraphicsRenderer.createFont/3","doc":"Creates a native graphics font from a `m:wxFont` and a text colour.","ref":"wxGraphicsRenderer.html#createFont/3"},{"type":"function","title":"wxGraphicsRenderer.createFont/4","doc":"Creates a graphics font with the given characteristics.\n\nIf possible, the `createFont/4` overload taking `m:wxFont` should be used instead. The main advantage\nof this overload is that it can be used without X server connection under Unix when using Cairo.\n\nSince: 2.9.3","ref":"wxGraphicsRenderer.html#createFont/4"},{"type":"function","title":"wxGraphicsRenderer.createLinearGradientBrush/6","doc":"Creates a native brush with a linear gradient.\n\nStops support is new since wxWidgets 2.9.1, previously only the start and end colours\ncould be specified.\n\nThe ability to apply a transformation matrix to the gradient was added in 3.1.3","ref":"wxGraphicsRenderer.html#createLinearGradientBrush/6"},{"type":"function","title":"wxGraphicsRenderer.createMatrix/1","doc":"Equivalent to  createMatrix(This, []) .","ref":"wxGraphicsRenderer.html#createMatrix/1"},{"type":"function","title":"wxGraphicsRenderer.createMatrix/2","doc":"Creates a native affine transformation matrix from the passed in values.\n\nThe defaults result in an identity matrix.","ref":"wxGraphicsRenderer.html#createMatrix/2"},{"type":"function","title":"wxGraphicsRenderer.createPath/1","doc":"Creates a native graphics path which is initially empty.","ref":"wxGraphicsRenderer.html#createPath/1"},{"type":"function","title":"wxGraphicsRenderer.createRadialGradientBrush/7","doc":"Creates a native brush with a radial gradient.\n\nStops support is new since wxWidgets 2.9.1, previously only the start and end colours\ncould be specified.\n\nThe ability to apply a transformation matrix to the gradient was added in 3.1.3","ref":"wxGraphicsRenderer.html#createRadialGradientBrush/7"},{"type":"function","title":"wxGraphicsRenderer.getDefaultRenderer/0","doc":"Returns the default renderer on this platform.\n\nOn macOS this is the Core Graphics (a.k.a. Quartz 2D) renderer, on MSW the GDIPlus\nrenderer, and on GTK we currently default to the Cairo renderer.","ref":"wxGraphicsRenderer.html#getDefaultRenderer/0"},{"type":"type","title":"wxGraphicsRenderer.wxGraphicsRenderer/0","doc":"","ref":"wxGraphicsRenderer.html#t:wxGraphicsRenderer/0"},{"type":"module","title":"wxGrid","doc":"`m:wxGrid` and its related classes are used for displaying and editing tabular data.\n\nThey provide a rich set of features for display, editing, and interacting with a variety\nof data sources. For simple applications, and to help you get started, `m:wxGrid` is the\nonly class you need to refer to directly. It will set up default instances of the other\nclasses and manage them for you. For more complex applications you can derive your own\nclasses for custom grid views, grid data tables, cell editors and renderers. The\noverview_grid has examples of simple and more complex applications, explains the\nrelationship between the various grid classes and has a summary of the keyboard shortcuts\nand mouse functions provided by `m:wxGrid`.\n\nA `wxGridTableBase` (not implemented in wx) class holds the actual data to be displayed\nby a `m:wxGrid` class. One or more `m:wxGrid` classes may act as a view for one table\nclass. The default table class is called `wxGridStringTable` (not implemented in wx) and\nholds an array of strings. An instance of such a class is created by `createGrid/4`.\n\n`m:wxGridCellRenderer` is the abstract base class for rendering contents in a cell. The\nfollowing renderers are predefined:\n\n* `m:wxGridCellBoolRenderer`\n\n* `m:wxGridCellFloatRenderer`\n\n* `m:wxGridCellNumberRenderer`\n\n* `m:wxGridCellStringRenderer`\n\n* `wxGridCellDateRenderer` (not implemented in wx)\n\n* `wxGridCellDateTimeRenderer` (not implemented in wx)\n\nThe look of a cell can be further defined using `m:wxGridCellAttr`. An object of this\ntype may be returned by `wxGridTableBase::GetAttr()` (not implemented in wx).\n\n`m:wxGridCellEditor` is the abstract base class for editing the value of a cell. The\nfollowing editors are predefined:\n\n* `m:wxGridCellBoolEditor`\n\n* `m:wxGridCellChoiceEditor`\n\n* `m:wxGridCellFloatEditor`\n\n* `m:wxGridCellNumberEditor`\n\n* `m:wxGridCellTextEditor`\n\n* `wxGridCellDateEditor` (not implemented in wx)\n\nPlease see `m:wxGridEvent`, `wxGridSizeEvent` (not implemented in wx), `wxGridRangeSelectEvent`\n(not implemented in wx), and `wxGridEditorCreatedEvent` (not implemented in wx) for the\ndocumentation of all event types you can use with `m:wxGrid`.\n\nSee: [Overview grid](https://docs.wxwidgets.org/3.2/overview_grid.html#overview_grid)\n\nThis class is derived, and can use functions, from:\n\n* `m:wxScrolledWindow`\n\n* `m:wxPanel`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxGrid](https://docs.wxwidgets.org/3.2/classwx_grid.html)","ref":"wxGrid.html"},{"type":"function","title":"wxGrid.appendCols/1","doc":"Equivalent to  appendCols(This, []) .","ref":"wxGrid.html#appendCols/1"},{"type":"function","title":"wxGrid.appendCols/2","doc":"Appends one or more new columns to the right of the grid.\n\nThe `updateLabels` argument is not used at present. If you are using a derived grid table\nclass you will need to override `wxGridTableBase::AppendCols()` (not implemented in wx).\nSee `insertCols/2` for further information.\n\nReturn: true on success or false if appending columns failed.","ref":"wxGrid.html#appendCols/2"},{"type":"function","title":"wxGrid.appendRows/1","doc":"Equivalent to  appendRows(This, []) .","ref":"wxGrid.html#appendRows/1"},{"type":"function","title":"wxGrid.appendRows/2","doc":"Appends one or more new rows to the bottom of the grid.\n\nThe `updateLabels` argument is not used at present. If you are using a derived grid table\nclass you will need to override `wxGridTableBase::AppendRows()` (not implemented in wx).\nSee `insertRows/2` for further information.\n\nReturn: true on success or false if appending rows failed.","ref":"wxGrid.html#appendRows/2"},{"type":"function","title":"wxGrid.autoSize/1","doc":"Automatically sets the height and width of all rows and columns to fit their contents.","ref":"wxGrid.html#autoSize/1"},{"type":"function","title":"wxGrid.autoSizeColumn/2","doc":"Equivalent to  autoSizeColumn(This, Col, []) .","ref":"wxGrid.html#autoSizeColumn/2"},{"type":"function","title":"wxGrid.autoSizeColumn/3","doc":"Automatically sizes the column to fit its contents.\n\nIf `setAsMin` is true the calculated width will also be set as the minimal width for the\ncolumn.","ref":"wxGrid.html#autoSizeColumn/3"},{"type":"function","title":"wxGrid.autoSizeColumns/1","doc":"Equivalent to  autoSizeColumns(This, []) .","ref":"wxGrid.html#autoSizeColumns/1"},{"type":"function","title":"wxGrid.autoSizeColumns/2","doc":"Automatically sizes all columns to fit their contents.\n\nIf `setAsMin` is true the calculated widths will also be set as the minimal widths for\nthe columns.","ref":"wxGrid.html#autoSizeColumns/2"},{"type":"function","title":"wxGrid.autoSizeRow/2","doc":"Equivalent to  autoSizeRow(This, Row, []) .","ref":"wxGrid.html#autoSizeRow/2"},{"type":"function","title":"wxGrid.autoSizeRow/3","doc":"Automatically sizes the row to fit its contents.\n\nIf `setAsMin` is true the calculated height will also be set as the minimal height for\nthe row.","ref":"wxGrid.html#autoSizeRow/3"},{"type":"function","title":"wxGrid.autoSizeRows/1","doc":"Equivalent to  autoSizeRows(This, []) .","ref":"wxGrid.html#autoSizeRows/1"},{"type":"function","title":"wxGrid.autoSizeRows/2","doc":"Automatically sizes all rows to fit their contents.\n\nIf `setAsMin` is true the calculated heights will also be set as the minimal heights for\nthe rows.","ref":"wxGrid.html#autoSizeRows/2"},{"type":"function","title":"wxGrid.beginBatch/1","doc":"Increments the grid's batch count.\n\nWhen the count is greater than zero repainting of the grid is suppressed. Each call to\nBeginBatch must be matched by a later call to `endBatch/1`. Code that does a lot of grid modification\ncan be enclosed between `beginBatch/1` and `endBatch/1` calls to avoid screen flicker. The final `endBatch/1` call will cause\nthe grid to be repainted.\n\nNotice that you should use `wxGridUpdateLocker` (not implemented in wx) which ensures\nthat there is always a matching `endBatch/1` call for this `beginBatch/1` if possible instead of calling this method\ndirectly.","ref":"wxGrid.html#beginBatch/1"},{"type":"function","title":"wxGrid.blockToDeviceRect/3","doc":"Convert grid cell coordinates to grid window pixel coordinates.\n\nThis function returns the rectangle that encloses the block of cells limited by `topLeft`\nand `bottomRight` cell in device coords and clipped to the client size of the grid window.\n\nSince: 3.1.3 Parameter `gridWindow` has been added.\n\nSee: `cellToRect/3`","ref":"wxGrid.html#blockToDeviceRect/3"},{"type":"function","title":"wxGrid.canDragCell/1","doc":"Return true if the dragging of cells is enabled or false otherwise.","ref":"wxGrid.html#canDragCell/1"},{"type":"function","title":"wxGrid.canDragColMove/1","doc":"Returns true if columns can be moved by dragging with the mouse.\n\nColumns can be moved by dragging on their labels.","ref":"wxGrid.html#canDragColMove/1"},{"type":"function","title":"wxGrid.canDragColSize/2","doc":"Returns true if the given column can be resized by dragging with the mouse.\n\nThis function returns true if resizing the columns interactively is globally enabled,\ni.e. if `disableDragColSize/1` hadn't been called, and if this column wasn't explicitly marked as non-resizable\nwith `DisableColResize()` (not implemented in wx).","ref":"wxGrid.html#canDragColSize/2"},{"type":"function","title":"wxGrid.canDragGridRowEdges/1","doc":"Return true if row edges inside the grid can be dragged to resize the rows.\n\nSee:\n* `canDragGridSize/1`\n\n* `canDragRowSize/2`\n\nSince: 3.1.4","ref":"wxGrid.html#canDragGridRowEdges/1"},{"type":"function","title":"wxGrid.canDragGridSize/1","doc":"Return true if the dragging of grid lines to resize rows and columns is enabled or false\notherwise.","ref":"wxGrid.html#canDragGridSize/1"},{"type":"function","title":"wxGrid.canDragRowSize/2","doc":"Returns true if the given row can be resized by dragging with the mouse.\n\nThis is the same as `canDragColSize/2` but for rows.","ref":"wxGrid.html#canDragRowSize/2"},{"type":"function","title":"wxGrid.canEnableCellControl/1","doc":"Returns true if the in-place edit control for the current grid cell can be used and false\notherwise.\n\nThis function always returns false for the read-only cells.","ref":"wxGrid.html#canEnableCellControl/1"},{"type":"function","title":"wxGrid.cellToRect/2","doc":"Return the rectangle corresponding to the grid cell's size and position in logical\ncoordinates.\n\nSee: `blockToDeviceRect/3`","ref":"wxGrid.html#cellToRect/2"},{"type":"function","title":"wxGrid.cellToRect/3","doc":"Return the rectangle corresponding to the grid cell's size and position in logical\ncoordinates.\n\nSee: `blockToDeviceRect/3`","ref":"wxGrid.html#cellToRect/3"},{"type":"function","title":"wxGrid.clearGrid/1","doc":"Clears all data in the underlying grid table and repaints the grid.\n\nThe table is not deleted by this function. If you are using a derived table class then\nyou need to override `wxGridTableBase::Clear()` (not implemented in wx) for this function\nto have any effect.","ref":"wxGrid.html#clearGrid/1"},{"type":"function","title":"wxGrid.clearSelection/1","doc":"Deselects all cells that are currently selected.","ref":"wxGrid.html#clearSelection/1"},{"type":"function","title":"wxGrid.createGrid/3","doc":"Equivalent to  createGrid(This, NumRows, NumCols, []) .","ref":"wxGrid.html#createGrid/3"},{"type":"function","title":"wxGrid.createGrid/4","doc":"Creates a grid with the specified initial number of rows and columns.\n\nCall this directly after the grid constructor. When you use this function `m:wxGrid` will\ncreate and manage a simple table of string values for you. All of the grid data will be\nstored in memory.\n\nFor applications with more complex data types or relationships, or for dealing with very\nlarge datasets, you should derive your own grid table class and pass a table object to the\ngrid with `SetTable()` (not implemented in wx) or `AssignTable()` (not implemented in wx).","ref":"wxGrid.html#createGrid/4"},{"type":"function","title":"wxGrid.deleteCols/1","doc":"Equivalent to  deleteCols(This, []) .","ref":"wxGrid.html#deleteCols/1"},{"type":"function","title":"wxGrid.deleteCols/2","doc":"Deletes one or more columns from a grid starting at the specified position.\n\nThe `updateLabels` argument is not used at present. If you are using a derived grid table\nclass you will need to override `wxGridTableBase::DeleteCols()` (not implemented in wx).\nSee `insertCols/2` for further information.\n\nReturn: true on success or false if deleting columns failed.","ref":"wxGrid.html#deleteCols/2"},{"type":"function","title":"wxGrid.deleteRows/1","doc":"Equivalent to  deleteRows(This, []) .","ref":"wxGrid.html#deleteRows/1"},{"type":"function","title":"wxGrid.deleteRows/2","doc":"Deletes one or more rows from a grid starting at the specified position.\n\nThe `updateLabels` argument is not used at present. If you are using a derived grid table\nclass you will need to override `wxGridTableBase::DeleteRows()` (not implemented in wx).\nSee `insertRows/2` for further information.\n\nReturn: true on success or false if deleting rows failed.","ref":"wxGrid.html#deleteRows/2"},{"type":"function","title":"wxGrid.destroy/1","doc":"Destroys the object","ref":"wxGrid.html#destroy/1"},{"type":"function","title":"wxGrid.disableCellEditControl/1","doc":"Disables in-place editing of grid cells.\n\nEquivalent to calling EnableCellEditControl(false).","ref":"wxGrid.html#disableCellEditControl/1"},{"type":"function","title":"wxGrid.disableDragColSize/1","doc":"Disables column sizing by dragging with the mouse.\n\nEquivalent to passing false to `enableDragColSize/2`.","ref":"wxGrid.html#disableDragColSize/1"},{"type":"function","title":"wxGrid.disableDragGridSize/1","doc":"Disable mouse dragging of grid lines to resize rows and columns.\n\nEquivalent to passing false to `enableDragGridSize/2`","ref":"wxGrid.html#disableDragGridSize/1"},{"type":"function","title":"wxGrid.disableDragRowSize/1","doc":"Disables row sizing by dragging with the mouse.\n\nEquivalent to passing false to `enableDragRowSize/2`.","ref":"wxGrid.html#disableDragRowSize/1"},{"type":"function","title":"wxGrid.enableCellEditControl/1","doc":"Equivalent to  enableCellEditControl(This, []) .","ref":"wxGrid.html#enableCellEditControl/1"},{"type":"function","title":"wxGrid.enableCellEditControl/2","doc":"Enables or disables in-place editing of grid cell data.\n\nEnabling in-place editing generates `wxEVT_GRID_EDITOR_SHOWN` and, if it isn't vetoed by\nthe application, shows the in-place editor which allows the user to change the cell value.\n\nDisabling in-place editing does nothing if the in-place editor isn't currently shown,\notherwise the `wxEVT_GRID_EDITOR_HIDDEN` event is generated but, unlike the \"shown\" event,\nit can't be vetoed and the in-place editor is dismissed unconditionally.\n\nNote that it is an error to call this function if the current cell is read-only, use `canEnableCellControl/1` to\ncheck for this precondition.","ref":"wxGrid.html#enableCellEditControl/2"},{"type":"function","title":"wxGrid.enableDragColSize/1","doc":"Equivalent to  enableDragColSize(This, []) .","ref":"wxGrid.html#enableDragColSize/1"},{"type":"function","title":"wxGrid.enableDragColSize/2","doc":"Enables or disables column sizing by dragging with the mouse.","ref":"wxGrid.html#enableDragColSize/2"},{"type":"function","title":"wxGrid.enableDragGridSize/1","doc":"Equivalent to  enableDragGridSize(This, []) .","ref":"wxGrid.html#enableDragGridSize/1"},{"type":"function","title":"wxGrid.enableDragGridSize/2","doc":"Enables or disables row and column resizing by dragging gridlines with the mouse.","ref":"wxGrid.html#enableDragGridSize/2"},{"type":"function","title":"wxGrid.enableDragRowSize/1","doc":"Equivalent to  enableDragRowSize(This, []) .","ref":"wxGrid.html#enableDragRowSize/1"},{"type":"function","title":"wxGrid.enableDragRowSize/2","doc":"Enables or disables row sizing by dragging with the mouse.","ref":"wxGrid.html#enableDragRowSize/2"},{"type":"function","title":"wxGrid.enableEditing/2","doc":"Makes the grid globally editable or read-only.\n\nIf the edit argument is false this function sets the whole grid as read-only. If the\nargument is true the grid is set to the default state where cells may be editable. In the\ndefault state you can set single grid cells and whole rows and columns to be editable or\nread-only via `wxGridCellAttr:setReadOnly/2`. For single cells you can also use the shortcut function `setReadOnly/4`.\n\nFor more information about controlling grid cell attributes see the `m:wxGridCellAttr`\nclass and the overview_grid.","ref":"wxGrid.html#enableEditing/2"},{"type":"function","title":"wxGrid.enableGridLines/1","doc":"Equivalent to  enableGridLines(This, []) .","ref":"wxGrid.html#enableGridLines/1"},{"type":"function","title":"wxGrid.enableGridLines/2","doc":"Turns the drawing of grid lines on or off.","ref":"wxGrid.html#enableGridLines/2"},{"type":"function","title":"wxGrid.endBatch/1","doc":"Decrements the grid's batch count.\n\nWhen the count is greater than zero repainting of the grid is suppressed. Each previous\ncall to `beginBatch/1` must be matched by a later call to `endBatch/1`. Code that does a lot of grid modification\ncan be enclosed between `beginBatch/1` and `endBatch/1` calls to avoid screen flicker. The final `endBatch/1` will cause the\ngrid to be repainted.","ref":"wxGrid.html#endBatch/1"},{"type":"function","title":"wxGrid.fit/1","doc":"Overridden `m:wxWindow` method.","ref":"wxGrid.html#fit/1"},{"type":"function","title":"wxGrid.forceRefresh/1","doc":"Causes immediate repainting of the grid.\n\nUse this instead of the usual `wxWindow:refresh/2`.","ref":"wxGrid.html#forceRefresh/1"},{"type":"function","title":"wxGrid.getBatchCount/1","doc":"Returns the number of times that `beginBatch/1` has been called without (yet) matching\ncalls to `endBatch/1`.\n\nWhile the grid's batch count is greater than zero the display will not be updated.","ref":"wxGrid.html#getBatchCount/1"},{"type":"function","title":"wxGrid.getCellAlignment/3","doc":"Sets the arguments to the horizontal and vertical text alignment values for the grid cell\nat the specified location.\n\nHorizontal alignment will be one of `wxALIGN_LEFT`, `wxALIGN_CENTRE` or `wxALIGN_RIGHT`.\n\nVertical alignment will be one of `wxALIGN_TOP`, `wxALIGN_CENTRE` or `wxALIGN_BOTTOM`.","ref":"wxGrid.html#getCellAlignment/3"},{"type":"function","title":"wxGrid.getCellBackgroundColour/3","doc":"Returns the background colour of the cell at the specified location.","ref":"wxGrid.html#getCellBackgroundColour/3"},{"type":"function","title":"wxGrid.getCellEditor/3","doc":"Returns a pointer to the editor for the cell at the specified location.\n\nSee `m:wxGridCellEditor` and the overview_grid for more information about cell editors\nand renderers.\n\nThe caller must call DecRef() on the returned pointer.","ref":"wxGrid.html#getCellEditor/3"},{"type":"function","title":"wxGrid.getCellFont/3","doc":"Returns the font for text in the grid cell at the specified location.","ref":"wxGrid.html#getCellFont/3"},{"type":"function","title":"wxGrid.getCellRenderer/3","doc":"Returns a pointer to the renderer for the grid cell at the specified location.\n\nSee `m:wxGridCellRenderer` and the overview_grid for more information about cell editors\nand renderers.\n\nThe caller must call DecRef() on the returned pointer.","ref":"wxGrid.html#getCellRenderer/3"},{"type":"function","title":"wxGrid.getCellTextColour/3","doc":"Returns the text colour for the grid cell at the specified location.","ref":"wxGrid.html#getCellTextColour/3"},{"type":"function","title":"wxGrid.getCellValue/2","doc":"Returns the string contained in the cell at the specified location.\n\nFor simple applications where a grid object automatically uses a default grid table of\nstring values you use this function together with `setCellValue/4` to access cell values. For more complex\napplications where you have derived your own grid table class that contains various data\ntypes (e.g. numeric, boolean or user-defined custom types) then you only use this function\nfor those cells that contain string values.\n\nSee `wxGridTableBase::CanGetValueAs()` (not implemented in wx) and the overview_grid for\nmore information.","ref":"wxGrid.html#getCellValue/2"},{"type":"function","title":"wxGrid.getCellValue/3","doc":"Returns the string contained in the cell at the specified location.\n\nFor simple applications where a grid object automatically uses a default grid table of\nstring values you use this function together with `setCellValue/4` to access cell values. For more complex\napplications where you have derived your own grid table class that contains various data\ntypes (e.g. numeric, boolean or user-defined custom types) then you only use this function\nfor those cells that contain string values.\n\nSee `wxGridTableBase::CanGetValueAs()` (not implemented in wx) and the overview_grid for\nmore information.","ref":"wxGrid.html#getCellValue/3"},{"type":"function","title":"wxGrid.getColLabelAlignment/1","doc":"Sets the arguments to the current column label alignment values.\n\nHorizontal alignment will be one of `wxALIGN_LEFT`, `wxALIGN_CENTRE` or `wxALIGN_RIGHT`.\n\nVertical alignment will be one of `wxALIGN_TOP`, `wxALIGN_CENTRE` or `wxALIGN_BOTTOM`.","ref":"wxGrid.html#getColLabelAlignment/1"},{"type":"function","title":"wxGrid.getColLabelSize/1","doc":"Returns the current height of the column labels.","ref":"wxGrid.html#getColLabelSize/1"},{"type":"function","title":"wxGrid.getColLabelValue/2","doc":"Returns the specified column label.\n\nThe default grid table class provides column labels of the form A,B...Z,AA,AB...ZZ,AAA...\nIf you are using a custom grid table you can override `wxGridTableBase::GetColLabelValue()`\n(not implemented in wx) to provide your own labels.","ref":"wxGrid.html#getColLabelValue/2"},{"type":"function","title":"wxGrid.getColMinimalAcceptableWidth/1","doc":"Returns the minimal width to which a column may be resized.\n\nUse `setColMinimalAcceptableWidth/2` to change this value globally or `setColMinimalWidth/3` to do it for individual columns.\n\nSee: `getRowMinimalAcceptableHeight/1`","ref":"wxGrid.html#getColMinimalAcceptableWidth/1"},{"type":"function","title":"wxGrid.getDefaultCellAlignment/1","doc":"Returns the default cell alignment.\n\nHorizontal alignment will be one of `wxALIGN_LEFT`, `wxALIGN_CENTRE` or `wxALIGN_RIGHT`.\n\nVertical alignment will be one of `wxALIGN_TOP`, `wxALIGN_CENTRE` or `wxALIGN_BOTTOM`.\n\nSee: `setDefaultCellAlignment/3`","ref":"wxGrid.html#getDefaultCellAlignment/1"},{"type":"function","title":"wxGrid.getDefaultCellBackgroundColour/1","doc":"Returns the current default background colour for grid cells.","ref":"wxGrid.html#getDefaultCellBackgroundColour/1"},{"type":"function","title":"wxGrid.getDefaultCellFont/1","doc":"Returns the current default font for grid cell text.","ref":"wxGrid.html#getDefaultCellFont/1"},{"type":"function","title":"wxGrid.getDefaultCellTextColour/1","doc":"Returns the current default colour for grid cell text.","ref":"wxGrid.html#getDefaultCellTextColour/1"},{"type":"function","title":"wxGrid.getDefaultColLabelSize/1","doc":"Returns the default height for column labels.","ref":"wxGrid.html#getDefaultColLabelSize/1"},{"type":"function","title":"wxGrid.getDefaultColSize/1","doc":"Returns the current default width for grid columns.","ref":"wxGrid.html#getDefaultColSize/1"},{"type":"function","title":"wxGrid.getDefaultEditor/1","doc":"Returns a pointer to the current default grid cell editor.\n\nSee `m:wxGridCellEditor` and the overview_grid for more information about cell editors\nand renderers.","ref":"wxGrid.html#getDefaultEditor/1"},{"type":"function","title":"wxGrid.getDefaultEditorForCell/2","doc":"Returns the default editor for the specified cell.\n\nThe base class version returns the editor appropriate for the current cell type but this\nmethod may be overridden in the derived classes to use custom editors for some cells by default.\n\nNotice that the same may be achieved in a usually simpler way by associating a custom\neditor with the given cell or cells.\n\nThe caller must call DecRef() on the returned pointer.","ref":"wxGrid.html#getDefaultEditorForCell/2"},{"type":"function","title":"wxGrid.getDefaultEditorForCell/3","doc":"Returns the default editor for the specified cell.\n\nThe base class version returns the editor appropriate for the current cell type but this\nmethod may be overridden in the derived classes to use custom editors for some cells by default.\n\nNotice that the same may be achieved in a usually simpler way by associating a custom\neditor with the given cell or cells.\n\nThe caller must call DecRef() on the returned pointer.","ref":"wxGrid.html#getDefaultEditorForCell/3"},{"type":"function","title":"wxGrid.getDefaultEditorForType/2","doc":"Returns the default editor for the cells containing values of the given type.\n\nThe base class version returns the editor which was associated with the specified `typeName`\nwhen it was registered `registerDataType/4` but this function may be overridden to return something\ndifferent. This allows overriding an editor used for one of the standard types.\n\nThe caller must call DecRef() on the returned pointer.","ref":"wxGrid.html#getDefaultEditorForType/2"},{"type":"function","title":"wxGrid.getDefaultRenderer/1","doc":"Returns a pointer to the current default grid cell renderer.\n\nSee `m:wxGridCellRenderer` and the overview_grid for more information about cell editors\nand renderers.\n\nThe caller must call DecRef() on the returned pointer.","ref":"wxGrid.html#getDefaultRenderer/1"},{"type":"function","title":"wxGrid.getDefaultRendererForCell/3","doc":"Returns the default renderer for the given cell.\n\nThe base class version returns the renderer appropriate for the current cell type but\nthis method may be overridden in the derived classes to use custom renderers for some\ncells by default.\n\nThe caller must call DecRef() on the returned pointer.","ref":"wxGrid.html#getDefaultRendererForCell/3"},{"type":"function","title":"wxGrid.getDefaultRendererForType/2","doc":"Returns the default renderer for the cell containing values of the given type.\n\nSee: `getDefaultEditorForType/2`","ref":"wxGrid.html#getDefaultRendererForType/2"},{"type":"function","title":"wxGrid.getDefaultRowLabelSize/1","doc":"Returns the default width for the row labels.","ref":"wxGrid.html#getDefaultRowLabelSize/1"},{"type":"function","title":"wxGrid.getDefaultRowSize/1","doc":"Returns the current default height for grid rows.","ref":"wxGrid.html#getDefaultRowSize/1"},{"type":"function","title":"wxGrid.getGridColLabelWindow/1","doc":"Return the column labels window.\n\nThis window is not shown if the columns labels were hidden using `HideColLabels()` (not\nimplemented in wx).\n\nDepending on whether `UseNativeColHeader()` (not implemented in wx) was called or not\nthis can be either a `wxHeaderCtrl` (not implemented in wx) or a plain `m:wxWindow`. This\nfunction returns a valid window pointer in either case but in the former case you can also\nuse `GetGridColHeader()` (not implemented in wx) to access it if you need\nwxHeaderCtrl-specific functionality.","ref":"wxGrid.html#getGridColLabelWindow/1"},{"type":"function","title":"wxGrid.getGridCornerLabelWindow/1","doc":"Return the window in the top left grid corner.\n\nThis window is shown only of both columns and row labels are shown and normally doesn't\ncontain anything. Clicking on it is handled by `m:wxGrid` however and can be used to\nselect the entire grid.","ref":"wxGrid.html#getGridCornerLabelWindow/1"},{"type":"function","title":"wxGrid.getGridCursorCol/1","doc":"Returns the current grid cell column position.","ref":"wxGrid.html#getGridCursorCol/1"},{"type":"function","title":"wxGrid.getGridCursorRow/1","doc":"Returns the current grid cell row position.","ref":"wxGrid.html#getGridCursorRow/1"},{"type":"function","title":"wxGrid.getGridLineColour/1","doc":"Returns the colour used for grid lines.","ref":"wxGrid.html#getGridLineColour/1"},{"type":"function","title":"wxGrid.getGridRowLabelWindow/1","doc":"Return the row labels window.\n\nThis window is not shown if the row labels were hidden using `HideRowLabels()` (not\nimplemented in wx).","ref":"wxGrid.html#getGridRowLabelWindow/1"},{"type":"function","title":"wxGrid.getGridWindow/1","doc":"Return the main grid window containing the grid cells.\n\nThis window is always shown.","ref":"wxGrid.html#getGridWindow/1"},{"type":"function","title":"wxGrid.getLabelBackgroundColour/1","doc":"Returns the colour used for the background of row and column labels.","ref":"wxGrid.html#getLabelBackgroundColour/1"},{"type":"function","title":"wxGrid.getLabelFont/1","doc":"Returns the font used for row and column labels.","ref":"wxGrid.html#getLabelFont/1"},{"type":"function","title":"wxGrid.getLabelTextColour/1","doc":"Returns the colour used for row and column label text.","ref":"wxGrid.html#getLabelTextColour/1"},{"type":"function","title":"wxGrid.getNumberCols/1","doc":"Returns the total number of grid columns.\n\nThis is the same as the number of columns in the underlying grid table.","ref":"wxGrid.html#getNumberCols/1"},{"type":"function","title":"wxGrid.getNumberRows/1","doc":"Returns the total number of grid rows.\n\nThis is the same as the number of rows in the underlying grid table.","ref":"wxGrid.html#getNumberRows/1"},{"type":"function","title":"wxGrid.getOrCreateCellAttr/3","doc":"Returns the attribute for the given cell creating one if necessary.\n\nIf the cell already has an attribute, it is returned. Otherwise a new attribute is\ncreated, associated with the cell and returned. In any case the caller must call DecRef()\non the returned pointer.\n\nPrefer to use `GetOrCreateCellAttrPtr()` (not implemented in wx) to avoid the need to\ncall DecRef() on the returned pointer.\n\nThis function may only be called if `CanHaveAttributes()` (not implemented in wx) returns\ntrue.","ref":"wxGrid.html#getOrCreateCellAttr/3"},{"type":"function","title":"wxGrid.getRowLabelAlignment/1","doc":"Returns the alignment used for row labels.\n\nHorizontal alignment will be one of `wxALIGN_LEFT`, `wxALIGN_CENTRE` or `wxALIGN_RIGHT`.\n\nVertical alignment will be one of `wxALIGN_TOP`, `wxALIGN_CENTRE` or `wxALIGN_BOTTOM`.","ref":"wxGrid.html#getRowLabelAlignment/1"},{"type":"function","title":"wxGrid.getRowLabelSize/1","doc":"Returns the current width of the row labels.","ref":"wxGrid.html#getRowLabelSize/1"},{"type":"function","title":"wxGrid.getRowLabelValue/2","doc":"Returns the specified row label.\n\nThe default grid table class provides numeric row labels. If you are using a custom grid\ntable you can override `wxGridTableBase::GetRowLabelValue()` (not implemented in wx) to\nprovide your own labels.","ref":"wxGrid.html#getRowLabelValue/2"},{"type":"function","title":"wxGrid.getRowMinimalAcceptableHeight/1","doc":"Returns the minimal size to which rows can be resized.\n\nUse `setRowMinimalAcceptableHeight/2` to change this value globally or `setRowMinimalHeight/3` to do it for individual cells.\n\nSee: `getColMinimalAcceptableWidth/1`","ref":"wxGrid.html#getRowMinimalAcceptableHeight/1"},{"type":"function","title":"wxGrid.getRowSize/2","doc":"Returns the height of the specified row.","ref":"wxGrid.html#getRowSize/2"},{"type":"function","title":"wxGrid.getScrollLineX/1","doc":"Returns the number of pixels per horizontal scroll increment.\n\nThe default is 15.\n\nSee:\n* `getScrollLineY/1`\n\n* `setScrollLineX/2`\n\n* `setScrollLineY/2`","ref":"wxGrid.html#getScrollLineX/1"},{"type":"function","title":"wxGrid.getScrollLineY/1","doc":"Returns the number of pixels per vertical scroll increment.\n\nThe default is 15.\n\nSee:\n* `getScrollLineX/1`\n\n* `setScrollLineX/2`\n\n* `setScrollLineY/2`","ref":"wxGrid.html#getScrollLineY/1"},{"type":"function","title":"wxGrid.getSelectedCells/1","doc":"Returns an array of individually selected cells.\n\nNotice that this array does `not` contain all the selected cells in general as it doesn't\ninclude the cells selected as part of column, row or block selection. You must use this\nmethod, `getSelectedCols/1`, `getSelectedRows/1` and `getSelectionBlockTopLeft/1` and `getSelectionBlockBottomRight/1` methods to obtain the entire selection in general.\n\nPlease notice this behaviour is by design and is needed in order to support grids of\narbitrary size (when an entire column is selected in a grid with a million of columns, we\ndon't want to create an array with a million of entries in this function, instead it\nreturns an empty array and `getSelectedCols/1` returns an array containing one element).\n\nThe function can be slow for the big grids, use `GetSelectedBlocks()` (not implemented in\nwx) in the new code.","ref":"wxGrid.html#getSelectedCells/1"},{"type":"function","title":"wxGrid.getSelectedCols/1","doc":"Returns an array of selected columns.\n\nPlease notice that this method alone is not sufficient to find all the selected columns\nas it contains only the columns which were individually selected but not those being part\nof the block selection or being selected in virtue of all of their cells being selected\nindividually, please see `getSelectedCells/1` for more details.\n\nThe function can be slow for the big grids, use `GetSelectedBlocks()` (not implemented in\nwx) in the new code.","ref":"wxGrid.html#getSelectedCols/1"},{"type":"function","title":"wxGrid.getSelectedRows/1","doc":"Returns an array of selected rows.\n\nPlease notice that this method alone is not sufficient to find all the selected rows as\nit contains only the rows which were individually selected but not those being part of the\nblock selection or being selected in virtue of all of their cells being selected\nindividually, please see `getSelectedCells/1` for more details.\n\nThe function can be slow for the big grids, use `GetSelectedBlocks()` (not implemented in\nwx) in the new code.","ref":"wxGrid.html#getSelectedRows/1"},{"type":"function","title":"wxGrid.getSelectionBackground/1","doc":"Returns the colour used for drawing the selection background.","ref":"wxGrid.html#getSelectionBackground/1"},{"type":"function","title":"wxGrid.getSelectionBlockBottomRight/1","doc":"Returns an array of the bottom right corners of blocks of selected cells.\n\nPlease see `getSelectedCells/1` for more information about the selection representation in `m:wxGrid`.\n\nThe function can be slow for the big grids, use `GetSelectedBlocks()` (not implemented in\nwx) in the new code.\n\nSee: `getSelectionBlockTopLeft/1`","ref":"wxGrid.html#getSelectionBlockBottomRight/1"},{"type":"function","title":"wxGrid.getSelectionBlockTopLeft/1","doc":"Returns an array of the top left corners of blocks of selected cells.\n\nPlease see `getSelectedCells/1` for more information about the selection representation in `m:wxGrid`.\n\nThe function can be slow for the big grids, use `GetSelectedBlocks()` (not implemented in\nwx) in the new code.\n\nSee: `getSelectionBlockBottomRight/1`","ref":"wxGrid.html#getSelectionBlockTopLeft/1"},{"type":"function","title":"wxGrid.getSelectionForeground/1","doc":"Returns the colour used for drawing the selection foreground.","ref":"wxGrid.html#getSelectionForeground/1"},{"type":"function","title":"wxGrid.gridLinesEnabled/1","doc":"Returns true if drawing of grid lines is turned on, false otherwise.","ref":"wxGrid.html#gridLinesEnabled/1"},{"type":"function","title":"wxGrid.hideCellEditControl/1","doc":"Hides the in-place cell edit control.","ref":"wxGrid.html#hideCellEditControl/1"},{"type":"function","title":"wxGrid.insertCols/1","doc":"Equivalent to  insertCols(This, []) .","ref":"wxGrid.html#insertCols/1"},{"type":"function","title":"wxGrid.insertCols/2","doc":"Inserts one or more new columns into a grid with the first new column at the specified\nposition.\n\nNotice that inserting the columns in the grid requires grid table cooperation: when this\nmethod is called, grid object begins by requesting the underlying grid table to insert new\ncolumns. If this is successful the table notifies the grid and the grid updates the\ndisplay. For a default grid (one where you have called `createGrid/4`) this process is automatic. If you\nare using a custom grid table (specified with `SetTable()` (not implemented in wx) or `AssignTable()`\n(not implemented in wx)) then you must override `wxGridTableBase::InsertCols()` (not\nimplemented in wx) in your derived table class.\n\nReturn: true if the columns were successfully inserted, false if an error occurred (most\nlikely the table couldn't be updated).","ref":"wxGrid.html#insertCols/2"},{"type":"function","title":"wxGrid.insertRows/1","doc":"Equivalent to  insertRows(This, []) .","ref":"wxGrid.html#insertRows/1"},{"type":"function","title":"wxGrid.insertRows/2","doc":"Inserts one or more new rows into a grid with the first new row at the specified\nposition.\n\nNotice that you must implement `wxGridTableBase::InsertRows()` (not implemented in wx) if\nyou use a grid with a custom table, please see `insertCols/2` for more information.\n\nReturn: true if the rows were successfully inserted, false if an error occurred (most\nlikely the table couldn't be updated).","ref":"wxGrid.html#insertRows/2"},{"type":"function","title":"wxGrid.isCellEditControlEnabled/1","doc":"Returns true if the in-place edit control is currently enabled.","ref":"wxGrid.html#isCellEditControlEnabled/1"},{"type":"function","title":"wxGrid.isCurrentCellReadOnly/1","doc":"Returns true if the current cell is read-only.\n\nSee:\n* `setReadOnly/4`\n\n* `isReadOnly/3`","ref":"wxGrid.html#isCurrentCellReadOnly/1"},{"type":"function","title":"wxGrid.isEditable/1","doc":"Returns false if the whole grid has been set as read-only or true otherwise.\n\nSee `enableEditing/2` for more information about controlling the editing status of grid cells.","ref":"wxGrid.html#isEditable/1"},{"type":"function","title":"wxGrid.isInSelection/2","doc":"Returns true if the given cell is selected.","ref":"wxGrid.html#isInSelection/2"},{"type":"function","title":"wxGrid.isInSelection/3","doc":"Returns true if the given cell is selected.","ref":"wxGrid.html#isInSelection/3"},{"type":"function","title":"wxGrid.isReadOnly/3","doc":"Returns true if the cell at the specified location can't be edited.\n\nSee:\n* `setReadOnly/4`\n\n* `isCurrentCellReadOnly/1`","ref":"wxGrid.html#isReadOnly/3"},{"type":"function","title":"wxGrid.isSelection/1","doc":"Returns true if there are currently any selected cells, rows, columns or blocks.","ref":"wxGrid.html#isSelection/1"},{"type":"function","title":"wxGrid.isVisible/2","doc":"Equivalent to  isVisible(This, Coords, []) .","ref":"wxGrid.html#isVisible/2"},{"type":"function","title":"wxGrid.isVisible/3","doc":"Returns true if a cell is either entirely or at least partially visible in the grid\nwindow.\n\nBy default, the cell must be entirely visible for this function to return true but if `wholeCellVisible`\nis false, the function returns true even if the cell is only partially visible.","ref":"wxGrid.html#isVisible/3"},{"type":"function","title":"wxGrid.isVisible/4","doc":"Returns true if a cell is either entirely or at least partially visible in the grid\nwindow.\n\nBy default, the cell must be entirely visible for this function to return true but if `wholeCellVisible`\nis false, the function returns true even if the cell is only partially visible.","ref":"wxGrid.html#isVisible/4"},{"type":"function","title":"wxGrid.makeCellVisible/2","doc":"Brings the specified cell into the visible grid cell area with minimal scrolling.\n\nDoes nothing if the cell is already visible.","ref":"wxGrid.html#makeCellVisible/2"},{"type":"function","title":"wxGrid.makeCellVisible/3","doc":"Brings the specified cell into the visible grid cell area with minimal scrolling.\n\nDoes nothing if the cell is already visible.","ref":"wxGrid.html#makeCellVisible/3"},{"type":"function","title":"wxGrid.moveCursorDown/2","doc":"Moves the grid cursor down by one row.\n\nIf a block of cells was previously selected it will expand if the argument is true or be\ncleared if the argument is false.","ref":"wxGrid.html#moveCursorDown/2"},{"type":"function","title":"wxGrid.moveCursorDownBlock/2","doc":"Moves the grid cursor down in the current column such that it skips to the beginning or\nend of a block of non-empty cells.\n\nIf a block of cells was previously selected it will expand if the argument is true or be\ncleared if the argument is false.","ref":"wxGrid.html#moveCursorDownBlock/2"},{"type":"function","title":"wxGrid.moveCursorLeft/2","doc":"Moves the grid cursor left by one column.\n\nIf a block of cells was previously selected it will expand if the argument is true or be\ncleared if the argument is false.","ref":"wxGrid.html#moveCursorLeft/2"},{"type":"function","title":"wxGrid.moveCursorLeftBlock/2","doc":"Moves the grid cursor left in the current row such that it skips to the beginning or end\nof a block of non-empty cells.\n\nIf a block of cells was previously selected it will expand if the argument is true or be\ncleared if the argument is false.","ref":"wxGrid.html#moveCursorLeftBlock/2"},{"type":"function","title":"wxGrid.moveCursorRight/2","doc":"Moves the grid cursor right by one column.\n\nIf a block of cells was previously selected it will expand if the argument is true or be\ncleared if the argument is false.","ref":"wxGrid.html#moveCursorRight/2"},{"type":"function","title":"wxGrid.moveCursorRightBlock/2","doc":"Moves the grid cursor right in the current row such that it skips to the beginning or end\nof a block of non-empty cells.\n\nIf a block of cells was previously selected it will expand if the argument is true or be\ncleared if the argument is false.","ref":"wxGrid.html#moveCursorRightBlock/2"},{"type":"function","title":"wxGrid.moveCursorUp/2","doc":"Moves the grid cursor up by one row.\n\nIf a block of cells was previously selected it will expand if the argument is true or be\ncleared if the argument is false.","ref":"wxGrid.html#moveCursorUp/2"},{"type":"function","title":"wxGrid.moveCursorUpBlock/2","doc":"Moves the grid cursor up in the current column such that it skips to the beginning or end\nof a block of non-empty cells.\n\nIf a block of cells was previously selected it will expand if the argument is true or be\ncleared if the argument is false.","ref":"wxGrid.html#moveCursorUpBlock/2"},{"type":"function","title":"wxGrid.movePageDown/1","doc":"Moves the grid cursor down by some number of rows so that the previous bottom visible row\nbecomes the top visible row.","ref":"wxGrid.html#movePageDown/1"},{"type":"function","title":"wxGrid.movePageUp/1","doc":"Moves the grid cursor up by some number of rows so that the previous top visible row\nbecomes the bottom visible row.","ref":"wxGrid.html#movePageUp/1"},{"type":"function","title":"wxGrid.new/0","doc":"Default constructor.\n\nYou must call `Create()` (not implemented in wx) to really create the grid window and\nalso call `createGrid/4` or `SetTable()` (not implemented in wx) or `AssignTable()` (not implemented in\nwx) to initialize its contents.","ref":"wxGrid.html#new/0"},{"type":"function","title":"wxGrid.new/2","doc":"Equivalent to  new(Parent, Id, []) .","ref":"wxGrid.html#new/2"},{"type":"function","title":"wxGrid.new/3","doc":"Constructor creating the grid window.\n\nYou must call either `createGrid/4` or `SetTable()` (not implemented in wx) or `AssignTable()` (not\nimplemented in wx) to initialize the grid contents before using it.","ref":"wxGrid.html#new/3"},{"type":"function","title":"wxGrid.registerDataType/4","doc":"Register a new data type.\n\nThe data types allow to naturally associate specific renderers and editors to the cells\ncontaining values of the given type. For example, the grid automatically registers a data\ntype with the name `wxGRID_VALUE_STRING` which uses `m:wxGridCellStringRenderer` and `m:wxGridCellTextEditor`\nas its renderer and editor respectively - this is the data type used by all the cells of\nthe default `wxGridStringTable` (not implemented in wx), so this renderer and editor are\nused by default for all grid cells.\n\nHowever if a custom table returns `wxGRID_VALUE_BOOL` from its `wxGridTableBase::GetTypeName()`\n(not implemented in wx) method, then `m:wxGridCellBoolRenderer` and `m:wxGridCellBoolEditor`\nare used for it because the grid also registers a boolean data type with this name.\n\nAnd as this mechanism is completely generic, you may register your own data types using\nyour own custom renderers and editors. Just remember that the table must identify a cell\nas being of the given type for them to be used for this cell.","ref":"wxGrid.html#registerDataType/4"},{"type":"function","title":"wxGrid.saveEditControlValue/1","doc":"Sets the value of the current grid cell to the current in-place edit control value.\n\nThis is called automatically when the grid cursor moves from the current cell to a new\ncell. It is also a good idea to call this function when closing a grid since any edits to\nthe final cell location will not be saved otherwise.","ref":"wxGrid.html#saveEditControlValue/1"},{"type":"function","title":"wxGrid.selectAll/1","doc":"Selects all cells in the grid.","ref":"wxGrid.html#selectAll/1"},{"type":"function","title":"wxGrid.selectBlock/3","doc":"Equivalent to  selectBlock(This, TopLeft, BottomRight, []) .","ref":"wxGrid.html#selectBlock/3"},{"type":"function","title":"wxGrid.selectBlock/4","doc":"Selects a rectangular block of cells.\n\nIf `addToSelected` is false then any existing selection will be deselected; if true the\ncolumn will be added to the existing selection.","ref":"wxGrid.html#selectBlock/4"},{"type":"function","title":"wxGrid.selectBlock/5","doc":"Equivalent to  selectBlock(This, TopRow, LeftCol, BottomRow, RightCol, []) .","ref":"wxGrid.html#selectBlock/5"},{"type":"function","title":"wxGrid.selectBlock/6","doc":"Selects a rectangular block of cells.\n\nIf `addToSelected` is false then any existing selection will be deselected; if true the\ncolumn will be added to the existing selection.","ref":"wxGrid.html#selectBlock/6"},{"type":"function","title":"wxGrid.selectCol/2","doc":"Equivalent to  selectCol(This, Col, []) .","ref":"wxGrid.html#selectCol/2"},{"type":"function","title":"wxGrid.selectCol/3","doc":"Selects the specified column.\n\nIf `addToSelected` is false then any existing selection will be deselected; if true the\ncolumn will be added to the existing selection.\n\nThis method won't select anything if the current selection mode is wxGridSelectRows.","ref":"wxGrid.html#selectCol/3"},{"type":"function","title":"wxGrid.selectRow/2","doc":"Equivalent to  selectRow(This, Row, []) .","ref":"wxGrid.html#selectRow/2"},{"type":"function","title":"wxGrid.selectRow/3","doc":"Selects the specified row.\n\nIf `addToSelected` is false then any existing selection will be deselected; if true the\nrow will be added to the existing selection.\n\nThis method won't select anything if the current selection mode is wxGridSelectColumns.","ref":"wxGrid.html#selectRow/3"},{"type":"function","title":"wxGrid.setCellAlignment/5","doc":"Sets the horizontal and vertical alignment for grid cell text at the specified location.\n\nHorizontal alignment should be one of `wxALIGN_LEFT`, `wxALIGN_CENTRE` or `wxALIGN_RIGHT`.\n\nVertical alignment should be one of `wxALIGN_TOP`, `wxALIGN_CENTRE` or `wxALIGN_BOTTOM`.","ref":"wxGrid.html#setCellAlignment/5"},{"type":"function","title":"wxGrid.setCellBackgroundColour/4","doc":"Set the background colour for the given cell or all cells by default.","ref":"wxGrid.html#setCellBackgroundColour/4"},{"type":"function","title":"wxGrid.setCellEditor/4","doc":"Sets the editor for the grid cell at the specified location.\n\nThe grid will take ownership of the pointer.\n\nSee `m:wxGridCellEditor` and the overview_grid for more information about cell editors\nand renderers.","ref":"wxGrid.html#setCellEditor/4"},{"type":"function","title":"wxGrid.setCellFont/4","doc":"Sets the font for text in the grid cell at the specified location.","ref":"wxGrid.html#setCellFont/4"},{"type":"function","title":"wxGrid.setCellRenderer/4","doc":"Sets the renderer for the grid cell at the specified location.\n\nThe grid will take ownership of the pointer.\n\nSee `m:wxGridCellRenderer` and the overview_grid for more information about cell editors\nand renderers.","ref":"wxGrid.html#setCellRenderer/4"},{"type":"function","title":"wxGrid.setCellTextColour/4","doc":"Sets the text colour for the given cell.","ref":"wxGrid.html#setCellTextColour/4"},{"type":"function","title":"wxGrid.setCellValue/3","doc":"Sets the string value for the cell at the specified location.\n\nFor simple applications where a grid object automatically uses a default grid table of\nstring values you use this function together with `getCellValue/3` to access cell values. For more complex\napplications where you have derived your own grid table class that contains various data\ntypes (e.g. numeric, boolean or user-defined custom types) then you only use this function\nfor those cells that contain string values.\n\nSee `wxGridTableBase::CanSetValueAs()` (not implemented in wx) and the overview_grid for\nmore information.","ref":"wxGrid.html#setCellValue/3"},{"type":"function","title":"wxGrid.setCellValue/4","doc":"Sets the string value for the cell at the specified location.\n\nFor simple applications where a grid object automatically uses a default grid table of\nstring values you use this function together with `getCellValue/3` to access cell values. For more complex\napplications where you have derived your own grid table class that contains various data\ntypes (e.g. numeric, boolean or user-defined custom types) then you only use this function\nfor those cells that contain string values.\n\nSee `wxGridTableBase::CanSetValueAs()` (not implemented in wx) and the overview_grid for\nmore information.","ref":"wxGrid.html#setCellValue/4"},{"type":"function","title":"wxGrid.setColAttr/3","doc":"Sets the cell attributes for all cells in the specified column.\n\nFor more information about controlling grid cell attributes see the `m:wxGridCellAttr`\ncell attribute class and the overview_grid.","ref":"wxGrid.html#setColAttr/3"},{"type":"function","title":"wxGrid.setColFormatBool/2","doc":"Sets the specified column to display boolean values.\n\nSee: `setColFormatCustom/3`","ref":"wxGrid.html#setColFormatBool/2"},{"type":"function","title":"wxGrid.setColFormatCustom/3","doc":"Sets the specified column to display data in a custom format.\n\nThis method provides an alternative to defining a custom grid table which would return `typeName`\nfrom its GetTypeName() method for the cells in this column: while it doesn't really\nchange the type of the cells in this column, it does associate the renderer and editor\nused for the cells of the specified type with them.\n\nSee the overview_grid for more information on working with custom data types.","ref":"wxGrid.html#setColFormatCustom/3"},{"type":"function","title":"wxGrid.setColFormatFloat/2","doc":"Equivalent to  setColFormatFloat(This, Col, []) .","ref":"wxGrid.html#setColFormatFloat/2"},{"type":"function","title":"wxGrid.setColFormatFloat/3","doc":"Sets the specified column to display floating point values with the given width and\nprecision.\n\nSee: `setColFormatCustom/3`","ref":"wxGrid.html#setColFormatFloat/3"},{"type":"function","title":"wxGrid.setColFormatNumber/2","doc":"Sets the specified column to display integer values.\n\nSee: `setColFormatCustom/3`","ref":"wxGrid.html#setColFormatNumber/2"},{"type":"function","title":"wxGrid.setColLabelAlignment/3","doc":"Sets the horizontal and vertical alignment of column label text.\n\nHorizontal alignment should be one of `wxALIGN_LEFT`, `wxALIGN_CENTRE` or `wxALIGN_RIGHT`.\nVertical alignment should be one of `wxALIGN_TOP`, `wxALIGN_CENTRE` or `wxALIGN_BOTTOM`.","ref":"wxGrid.html#setColLabelAlignment/3"},{"type":"function","title":"wxGrid.setColLabelSize/2","doc":"Sets the height of the column labels.\n\nIf `height` equals to `wxGRID_AUTOSIZE` then height is calculated automatically so that\nno label is truncated. Note that this could be slow for a large table.","ref":"wxGrid.html#setColLabelSize/2"},{"type":"function","title":"wxGrid.setColLabelValue/3","doc":"Set the value for the given column label.\n\nIf you are using a custom grid table you must override `wxGridTableBase::SetColLabelValue()`\n(not implemented in wx) for this to have any effect.","ref":"wxGrid.html#setColLabelValue/3"},{"type":"function","title":"wxGrid.setColMinimalAcceptableWidth/2","doc":"Sets the minimal `width` to which the user can resize columns.\n\nSee: `getColMinimalAcceptableWidth/1`","ref":"wxGrid.html#setColMinimalAcceptableWidth/2"},{"type":"function","title":"wxGrid.setColMinimalWidth/3","doc":"Sets the minimal `width` for the specified column `col`.\n\nIt is usually best to call this method during grid creation as calling it later will not\nresize the column to the given minimal width even if it is currently narrower than it.\n\n`width` must be greater than the minimal acceptable column width as returned by `getColMinimalAcceptableWidth/1`.","ref":"wxGrid.html#setColMinimalWidth/3"},{"type":"function","title":"wxGrid.setColSize/3","doc":"Sets the width of the specified column.","ref":"wxGrid.html#setColSize/3"},{"type":"function","title":"wxGrid.setDefaultCellAlignment/3","doc":"Sets the default horizontal and vertical alignment for grid cell text.\n\nHorizontal alignment should be one of `wxALIGN_LEFT`, `wxALIGN_CENTRE` or `wxALIGN_RIGHT`.\nVertical alignment should be one of `wxALIGN_TOP`, `wxALIGN_CENTRE` or `wxALIGN_BOTTOM`.","ref":"wxGrid.html#setDefaultCellAlignment/3"},{"type":"function","title":"wxGrid.setDefaultCellBackgroundColour/2","doc":"Sets the default background colour for grid cells.","ref":"wxGrid.html#setDefaultCellBackgroundColour/2"},{"type":"function","title":"wxGrid.setDefaultCellFont/2","doc":"Sets the default font to be used for grid cell text.","ref":"wxGrid.html#setDefaultCellFont/2"},{"type":"function","title":"wxGrid.setDefaultCellTextColour/2","doc":"Sets the current default colour for grid cell text.","ref":"wxGrid.html#setDefaultCellTextColour/2"},{"type":"function","title":"wxGrid.setDefaultColSize/2","doc":"Equivalent to  setDefaultColSize(This, Width, []) .","ref":"wxGrid.html#setDefaultColSize/2"},{"type":"function","title":"wxGrid.setDefaultColSize/3","doc":"Sets the default width for columns in the grid.\n\nThis will only affect columns subsequently added to the grid unless `resizeExistingCols`\nis true.\n\nIf `width` is less than `getColMinimalAcceptableWidth/1`, then the minimal acceptable width is used instead of it.","ref":"wxGrid.html#setDefaultColSize/3"},{"type":"function","title":"wxGrid.setDefaultEditor/2","doc":"Sets the default editor for grid cells.\n\nThe grid will take ownership of the pointer.\n\nSee `m:wxGridCellEditor` and the overview_grid for more information about cell editors\nand renderers.","ref":"wxGrid.html#setDefaultEditor/2"},{"type":"function","title":"wxGrid.setDefaultRenderer/2","doc":"Sets the default renderer for grid cells.\n\nThe grid will take ownership of the pointer.\n\nSee `m:wxGridCellRenderer` and the overview_grid for more information about cell editors\nand renderers.","ref":"wxGrid.html#setDefaultRenderer/2"},{"type":"function","title":"wxGrid.setDefaultRowSize/2","doc":"Equivalent to  setDefaultRowSize(This, Height, []) .","ref":"wxGrid.html#setDefaultRowSize/2"},{"type":"function","title":"wxGrid.setDefaultRowSize/3","doc":"Sets the default height for rows in the grid.\n\nThis will only affect rows subsequently added to the grid unless `resizeExistingRows` is true.\n\nIf `height` is less than `getRowMinimalAcceptableHeight/1`, then the minimal acceptable height is used instead of it.","ref":"wxGrid.html#setDefaultRowSize/3"},{"type":"function","title":"wxGrid.setGridCursor/2","doc":"Set the grid cursor to the specified cell.\n\nThe grid cursor indicates the current cell and can be moved by the user using the arrow\nkeys or the mouse.\n\nCalling this function generates a `wxEVT_GRID_SELECT_CELL` event and if the event handler\nvetoes this event, the cursor is not moved.\n\nThis function doesn't make the target call visible, use `GoToCell()` (not implemented in\nwx) to do this.","ref":"wxGrid.html#setGridCursor/2"},{"type":"function","title":"wxGrid.setGridCursor/3","doc":"Set the grid cursor to the specified cell.\n\nThe grid cursor indicates the current cell and can be moved by the user using the arrow\nkeys or the mouse.\n\nCalling this function generates a `wxEVT_GRID_SELECT_CELL` event and if the event handler\nvetoes this event, the cursor is not moved.\n\nThis function doesn't make the target call visible, use `GoToCell()` (not implemented in\nwx) to do this.","ref":"wxGrid.html#setGridCursor/3"},{"type":"function","title":"wxGrid.setGridLineColour/2","doc":"Sets the colour used to draw grid lines.","ref":"wxGrid.html#setGridLineColour/2"},{"type":"function","title":"wxGrid.setLabelBackgroundColour/2","doc":"Sets the background colour for row and column labels.","ref":"wxGrid.html#setLabelBackgroundColour/2"},{"type":"function","title":"wxGrid.setLabelFont/2","doc":"Sets the font for row and column labels.","ref":"wxGrid.html#setLabelFont/2"},{"type":"function","title":"wxGrid.setLabelTextColour/2","doc":"Sets the colour for row and column label text.","ref":"wxGrid.html#setLabelTextColour/2"},{"type":"function","title":"wxGrid.setMargins/3","doc":"Sets the extra margins used around the grid area.\n\nA grid may occupy more space than needed for its data display and this function allows\nsetting how big this extra space is","ref":"wxGrid.html#setMargins/3"},{"type":"function","title":"wxGrid.setReadOnly/3","doc":"Equivalent to  setReadOnly(This, Row, Col, []) .","ref":"wxGrid.html#setReadOnly/3"},{"type":"function","title":"wxGrid.setReadOnly/4","doc":"Makes the cell at the specified location read-only or editable.\n\nSee: `isReadOnly/3`","ref":"wxGrid.html#setReadOnly/4"},{"type":"function","title":"wxGrid.setRowAttr/3","doc":"Sets the cell attributes for all cells in the specified row.\n\nThe grid takes ownership of the attribute pointer.\n\nSee the `m:wxGridCellAttr` class for more information about controlling cell attributes.","ref":"wxGrid.html#setRowAttr/3"},{"type":"function","title":"wxGrid.setRowLabelAlignment/3","doc":"Sets the horizontal and vertical alignment of row label text.\n\nHorizontal alignment should be one of `wxALIGN_LEFT`, `wxALIGN_CENTRE` or `wxALIGN_RIGHT`.\nVertical alignment should be one of `wxALIGN_TOP`, `wxALIGN_CENTRE` or `wxALIGN_BOTTOM`.","ref":"wxGrid.html#setRowLabelAlignment/3"},{"type":"function","title":"wxGrid.setRowLabelSize/2","doc":"Sets the width of the row labels.\n\nIf `width` equals `wxGRID_AUTOSIZE` then width is calculated automatically so that no\nlabel is truncated. Note that this could be slow for a large table.","ref":"wxGrid.html#setRowLabelSize/2"},{"type":"function","title":"wxGrid.setRowLabelValue/3","doc":"Sets the value for the given row label.\n\nIf you are using a derived grid table you must override `wxGridTableBase::SetRowLabelValue()`\n(not implemented in wx) for this to have any effect.","ref":"wxGrid.html#setRowLabelValue/3"},{"type":"function","title":"wxGrid.setRowMinimalAcceptableHeight/2","doc":"Sets the minimal row `height` used by default.\n\nSee `setColMinimalAcceptableWidth/2` for more information.","ref":"wxGrid.html#setRowMinimalAcceptableHeight/2"},{"type":"function","title":"wxGrid.setRowMinimalHeight/3","doc":"Sets the minimal `height` for the specified `row`.\n\nSee `setColMinimalWidth/3` for more information.","ref":"wxGrid.html#setRowMinimalHeight/3"},{"type":"function","title":"wxGrid.setRowSize/3","doc":"Sets the height of the specified row.\n\nSee `setColSize/3` for more information.","ref":"wxGrid.html#setRowSize/3"},{"type":"function","title":"wxGrid.setScrollLineX/2","doc":"Sets the number of pixels per horizontal scroll increment.\n\nThe default is 15.\n\nSee:\n* `getScrollLineX/1`\n\n* `getScrollLineY/1`\n\n* `setScrollLineY/2`","ref":"wxGrid.html#setScrollLineX/2"},{"type":"function","title":"wxGrid.setScrollLineY/2","doc":"Sets the number of pixels per vertical scroll increment.\n\nThe default is 15.\n\nSee:\n* `getScrollLineX/1`\n\n* `getScrollLineY/1`\n\n* `setScrollLineX/2`","ref":"wxGrid.html#setScrollLineY/2"},{"type":"function","title":"wxGrid.setSelectionBackground/2","doc":"Set the colour to be used for drawing the selection background.","ref":"wxGrid.html#setSelectionBackground/2"},{"type":"function","title":"wxGrid.setSelectionForeground/2","doc":"Set the colour to be used for drawing the selection foreground.","ref":"wxGrid.html#setSelectionForeground/2"},{"type":"function","title":"wxGrid.setSelectionMode/2","doc":"Set the selection behaviour of the grid.\n\nThe existing selection is converted to conform to the new mode if possible and discarded\notherwise (e.g. any individual selected cells are deselected if the new mode allows only\nthe selection of the entire rows or columns).","ref":"wxGrid.html#setSelectionMode/2"},{"type":"function","title":"wxGrid.showCellEditControl/1","doc":"Displays the active in-place cell edit control for the current cell after it was hidden.\n\nThis method should only be called after calling `hideCellEditControl/1`, to start editing the current grid cell\nuse `enableCellEditControl/2` instead.","ref":"wxGrid.html#showCellEditControl/1"},{"type":"type","title":"wxGrid.wxGrid/0","doc":"","ref":"wxGrid.html#t:wxGrid/0"},{"type":"function","title":"wxGrid.xToCol/2","doc":"Equivalent to  xToCol(This, X, []) .","ref":"wxGrid.html#xToCol/2"},{"type":"function","title":"wxGrid.xToCol/3","doc":"Returns the column at the given pixel position depending on the window.\n\nReturn: The column index or `wxNOT_FOUND`.","ref":"wxGrid.html#xToCol/3"},{"type":"function","title":"wxGrid.xToEdgeOfCol/2","doc":"Returns the column whose right hand edge is close to the given logical `x` position.\n\nIf no column edge is near to this position `wxNOT_FOUND` is returned.","ref":"wxGrid.html#xToEdgeOfCol/2"},{"type":"function","title":"wxGrid.yToEdgeOfRow/2","doc":"Returns the row whose bottom edge is close to the given logical `y` position.\n\nIf no row edge is near to this position `wxNOT_FOUND` is returned.","ref":"wxGrid.html#yToEdgeOfRow/2"},{"type":"function","title":"wxGrid.yToRow/2","doc":"Equivalent to  yToRow(This, Y, []) .","ref":"wxGrid.html#yToRow/2"},{"type":"function","title":"wxGrid.yToRow/3","doc":"Returns the grid row that corresponds to the logical `y` coordinate.\n\nThe parameter `gridWindow` is new since wxWidgets 3.1.3. If it is specified, i.e.\nnon-NULL, only the cells of this window are considered, i.e. the function returns `wxNOT_FOUND`\nif `y` is out of bounds.\n\nIf `gridWindow` is NULL, the function returns `wxNOT_FOUND` only if there is no row at\nall at the `y` position.","ref":"wxGrid.html#yToRow/3"},{"type":"module","title":"wxGridBagSizer","doc":"A `m:wxSizer` that can lay out items in a virtual grid like a `m:wxFlexGridSizer` but in\nthis case explicit positioning of the items is allowed using `wxGBPosition` (not\nimplemented in wx), and items can optionally span more than one row and/or column using `wxGBSpan`\n(not implemented in wx).\n\nThis class is derived, and can use functions, from:\n\n* `m:wxFlexGridSizer`\n\n* `m:wxGridSizer`\n\n* `m:wxSizer`\n\nwxWidgets docs: [wxGridBagSizer](https://docs.wxwidgets.org/3.2/classwx_grid_bag_sizer.html)","ref":"wxGridBagSizer.html"},{"type":"function","title":"wxGridBagSizer.add/2","doc":"","ref":"wxGridBagSizer.html#add/2"},{"type":"function","title":"wxGridBagSizer.add/3","doc":"Equivalent to  add(This, Window, Pos, []) .","ref":"wxGridBagSizer.html#add/3"},{"type":"function","title":"wxGridBagSizer.add/4","doc":"Adds the given item to the given position.\n\nReturn: A valid pointer if the item was successfully placed at the given position, or\nNULL if something was already there.","ref":"wxGridBagSizer.html#add/4"},{"type":"function","title":"wxGridBagSizer.add/5","doc":"Adds a spacer to the given position.\n\n`width` and `height` specify the dimension of the spacer to be added.\n\nReturn: A valid pointer if the spacer was successfully placed at the given position, or\nNULL if something was already there.","ref":"wxGridBagSizer.html#add/5"},{"type":"function","title":"wxGridBagSizer.calcMin/1","doc":"Called when the managed size of the sizer is needed or when layout needs done.","ref":"wxGridBagSizer.html#calcMin/1"},{"type":"function","title":"wxGridBagSizer.checkForIntersection/2","doc":"Equivalent to  checkForIntersection(This, Item, []) .","ref":"wxGridBagSizer.html#checkForIntersection/2"},{"type":"function","title":"wxGridBagSizer.checkForIntersection/3","doc":"Look at all items and see if any intersect (or would overlap) the given item.\n\nReturns true if so, false if there would be no overlap. If an `excludeItem` is given then\nit will not be checked for intersection, for example it may be the item we are checking\nthe position of.","ref":"wxGridBagSizer.html#checkForIntersection/3"},{"type":"function","title":"wxGridBagSizer.checkForIntersection/4","doc":"","ref":"wxGridBagSizer.html#checkForIntersection/4"},{"type":"function","title":"wxGridBagSizer.destroy/1","doc":"Destroys the object","ref":"wxGridBagSizer.html#destroy/1"},{"type":"function","title":"wxGridBagSizer.findItem/2","doc":"Find the sizer item for the given window or subsizer, returns NULL if not found.\n\n(non-recursive)","ref":"wxGridBagSizer.html#findItem/2"},{"type":"function","title":"wxGridBagSizer.findItemAtPoint/2","doc":"Return the sizer item located at the point given in pt, or NULL if there is no item at\nthat point.\n\nThe (x,y) coordinates in `pt` correspond to the client coordinates of the window using\nthe sizer for layout. (non-recursive)","ref":"wxGridBagSizer.html#findItemAtPoint/2"},{"type":"function","title":"wxGridBagSizer.findItemAtPosition/2","doc":"Return the sizer item for the given grid cell, or NULL if there is no item at that\nposition.\n\n(non-recursive)","ref":"wxGridBagSizer.html#findItemAtPosition/2"},{"type":"function","title":"wxGridBagSizer.findItemWithData/2","doc":"Return the sizer item that has a matching user data (it only compares pointer values) or\nNULL if not found.\n\n(non-recursive)","ref":"wxGridBagSizer.html#findItemWithData/2"},{"type":"function","title":"wxGridBagSizer.getCellSize/3","doc":"Get the size of the specified cell, including hgap and vgap.\n\nOnly valid after window layout has been performed.","ref":"wxGridBagSizer.html#getCellSize/3"},{"type":"function","title":"wxGridBagSizer.getEmptyCellSize/1","doc":"Get the size used for cells in the grid with no item.","ref":"wxGridBagSizer.html#getEmptyCellSize/1"},{"type":"function","title":"wxGridBagSizer.getItemPosition/2","doc":"","ref":"wxGridBagSizer.html#getItemPosition/2"},{"type":"function","title":"wxGridBagSizer.getItemSpan/2","doc":"","ref":"wxGridBagSizer.html#getItemSpan/2"},{"type":"function","title":"wxGridBagSizer.new/0","doc":"Equivalent to  new([]) .","ref":"wxGridBagSizer.html#new/0"},{"type":"function","title":"wxGridBagSizer.new/1","doc":"Constructor, with optional parameters to specify the gap between the rows and columns.","ref":"wxGridBagSizer.html#new/1"},{"type":"function","title":"wxGridBagSizer.setEmptyCellSize/2","doc":"Set the size used for cells in the grid with no item.","ref":"wxGridBagSizer.html#setEmptyCellSize/2"},{"type":"function","title":"wxGridBagSizer.setItemPosition/3","doc":"","ref":"wxGridBagSizer.html#setItemPosition/3"},{"type":"function","title":"wxGridBagSizer.setItemSpan/3","doc":"","ref":"wxGridBagSizer.html#setItemSpan/3"},{"type":"type","title":"wxGridBagSizer.wxGridBagSizer/0","doc":"","ref":"wxGridBagSizer.html#t:wxGridBagSizer/0"},{"type":"module","title":"wxGridCellAttr","doc":"This class can be used to alter the cells' appearance in the grid by changing their\nattributes from the defaults.\n\nAn object of this class may be returned by `wxGridTableBase::GetAttr()` (not implemented\nin wx).\n\nNote that objects of this class are reference-counted and it's recommended to use\nwxGridCellAttrPtr smart pointer class when working with them to avoid memory leaks.\n\nwxWidgets docs: [wxGridCellAttr](https://docs.wxwidgets.org/3.2/classwx_grid_cell_attr.html)","ref":"wxGridCellAttr.html"},{"type":"function","title":"wxGridCellAttr.getAlignment/1","doc":"Get the alignment to use for the cell with the given attribute.\n\nIf this attribute doesn't specify any alignment, the default attribute alignment is used\n(which can be changed using `wxGrid:setDefaultCellAlignment/3` but is left and top by default).\n\nNotice that `hAlign` and `vAlign` values are always overwritten by this function, use `GetNonDefaultAlignment()`\n(not implemented in wx) if this is not desirable.","ref":"wxGridCellAttr.html#getAlignment/1"},{"type":"function","title":"wxGridCellAttr.getBackgroundColour/1","doc":"Returns the background colour.","ref":"wxGridCellAttr.html#getBackgroundColour/1"},{"type":"function","title":"wxGridCellAttr.getEditor/4","doc":"Returns the cell editor.\n\nThe caller is responsible for calling `DecRef()` (not implemented in wx) on the returned\npointer, use `GetEditorPtr()` (not implemented in wx) to do it automatically.","ref":"wxGridCellAttr.html#getEditor/4"},{"type":"function","title":"wxGridCellAttr.getFont/1","doc":"Returns the font.","ref":"wxGridCellAttr.html#getFont/1"},{"type":"function","title":"wxGridCellAttr.getRenderer/4","doc":"Returns the cell renderer.\n\nThe caller is responsible for calling `DecRef()` (not implemented in wx) on the returned\npointer, use `GetRendererPtr()` (not implemented in wx) to do it automatically.","ref":"wxGridCellAttr.html#getRenderer/4"},{"type":"function","title":"wxGridCellAttr.getTextColour/1","doc":"Returns the text colour.","ref":"wxGridCellAttr.html#getTextColour/1"},{"type":"function","title":"wxGridCellAttr.hasAlignment/1","doc":"Returns true if this attribute has a valid alignment set.","ref":"wxGridCellAttr.html#hasAlignment/1"},{"type":"function","title":"wxGridCellAttr.hasBackgroundColour/1","doc":"Returns true if this attribute has a valid background colour set.","ref":"wxGridCellAttr.html#hasBackgroundColour/1"},{"type":"function","title":"wxGridCellAttr.hasEditor/1","doc":"Returns true if this attribute has a valid cell editor set.","ref":"wxGridCellAttr.html#hasEditor/1"},{"type":"function","title":"wxGridCellAttr.hasFont/1","doc":"Returns true if this attribute has a valid font set.","ref":"wxGridCellAttr.html#hasFont/1"},{"type":"function","title":"wxGridCellAttr.hasRenderer/1","doc":"Returns true if this attribute has a valid cell renderer set.","ref":"wxGridCellAttr.html#hasRenderer/1"},{"type":"function","title":"wxGridCellAttr.hasTextColour/1","doc":"Returns true if this attribute has a valid text colour set.","ref":"wxGridCellAttr.html#hasTextColour/1"},{"type":"function","title":"wxGridCellAttr.isReadOnly/1","doc":"Returns true if this cell is set as read-only.","ref":"wxGridCellAttr.html#isReadOnly/1"},{"type":"function","title":"wxGridCellAttr.setAlignment/3","doc":"Sets the alignment.\n\n`hAlign` can be one of `wxALIGN_LEFT`, `wxALIGN_CENTRE` or `wxALIGN_RIGHT` and `vAlign`\ncan be one of `wxALIGN_TOP`, `wxALIGN_CENTRE` or `wxALIGN_BOTTOM`.","ref":"wxGridCellAttr.html#setAlignment/3"},{"type":"function","title":"wxGridCellAttr.setBackgroundColour/2","doc":"Sets the background colour.","ref":"wxGridCellAttr.html#setBackgroundColour/2"},{"type":"function","title":"wxGridCellAttr.setDefAttr/2","doc":"","ref":"wxGridCellAttr.html#setDefAttr/2"},{"type":"function","title":"wxGridCellAttr.setEditor/2","doc":"Sets the editor to be used with the cells with this attribute.","ref":"wxGridCellAttr.html#setEditor/2"},{"type":"function","title":"wxGridCellAttr.setFont/2","doc":"Sets the font.","ref":"wxGridCellAttr.html#setFont/2"},{"type":"function","title":"wxGridCellAttr.setReadOnly/1","doc":"Equivalent to  setReadOnly(This, []) .","ref":"wxGridCellAttr.html#setReadOnly/1"},{"type":"function","title":"wxGridCellAttr.setReadOnly/2","doc":"Sets the cell as read-only.","ref":"wxGridCellAttr.html#setReadOnly/2"},{"type":"function","title":"wxGridCellAttr.setRenderer/2","doc":"Sets the renderer to be used for cells with this attribute.\n\nTakes ownership of the pointer.","ref":"wxGridCellAttr.html#setRenderer/2"},{"type":"function","title":"wxGridCellAttr.setTextColour/2","doc":"Sets the text colour.","ref":"wxGridCellAttr.html#setTextColour/2"},{"type":"type","title":"wxGridCellAttr.wxGridCellAttr/0","doc":"","ref":"wxGridCellAttr.html#t:wxGridCellAttr/0"},{"type":"module","title":"wxGridCellBoolEditor","doc":"Grid cell editor for boolean data.\n\nSee:\n* `m:wxGridCellEditor`\n\n* `m:wxGridCellChoiceEditor`\n\n* `m:wxGridCellFloatEditor`\n\n* `m:wxGridCellNumberEditor`\n\n* `m:wxGridCellTextEditor`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxGridCellEditor`\n\nwxWidgets docs: [wxGridCellBoolEditor](https://docs.wxwidgets.org/3.2/classwx_grid_cell_bool_editor.html)","ref":"wxGridCellBoolEditor.html"},{"type":"function","title":"wxGridCellBoolEditor.destroy/1","doc":"Destroys the object","ref":"wxGridCellBoolEditor.html#destroy/1"},{"type":"function","title":"wxGridCellBoolEditor.isTrueValue/1","doc":"Returns true if the given `value` is equal to the string representation of the truth\nvalue we currently use (see `useStringValues/1`).","ref":"wxGridCellBoolEditor.html#isTrueValue/1"},{"type":"function","title":"wxGridCellBoolEditor.new/0","doc":"Default constructor.","ref":"wxGridCellBoolEditor.html#new/0"},{"type":"function","title":"wxGridCellBoolEditor.useStringValues/0","doc":"Equivalent to  useStringValues([]) .","ref":"wxGridCellBoolEditor.html#useStringValues/0"},{"type":"function","title":"wxGridCellBoolEditor.useStringValues/1","doc":"This method allows you to customize the values returned by `wxGridCellNumberEditor:getValue/1`\nfor the cell using this editor.\n\nBy default, the default values of the arguments are used, i.e. `\"1\"` is returned if the\ncell is checked and an empty string otherwise.","ref":"wxGridCellBoolEditor.html#useStringValues/1"},{"type":"type","title":"wxGridCellBoolEditor.wxGridCellBoolEditor/0","doc":"","ref":"wxGridCellBoolEditor.html#t:wxGridCellBoolEditor/0"},{"type":"module","title":"wxGridCellBoolRenderer","doc":"This class may be used to format boolean data in a cell.\n\nSee:\n* `m:wxGridCellRenderer`\n\n* `m:wxGridCellFloatRenderer`\n\n* `m:wxGridCellNumberRenderer`\n\n* `m:wxGridCellStringRenderer`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxGridCellRenderer`\n\nwxWidgets docs: [wxGridCellBoolRenderer](https://docs.wxwidgets.org/3.2/classwx_grid_cell_bool_renderer.html)","ref":"wxGridCellBoolRenderer.html"},{"type":"function","title":"wxGridCellBoolRenderer.destroy/1","doc":"Destroys the object","ref":"wxGridCellBoolRenderer.html#destroy/1"},{"type":"function","title":"wxGridCellBoolRenderer.new/0","doc":"","ref":"wxGridCellBoolRenderer.html#new/0"},{"type":"type","title":"wxGridCellBoolRenderer.wxGridCellBoolRenderer/0","doc":"","ref":"wxGridCellBoolRenderer.html#t:wxGridCellBoolRenderer/0"},{"type":"module","title":"wxGridCellChoiceEditor","doc":"Grid cell editor for string data providing the user a choice from a list of strings.\n\nSee:\n* `m:wxGridCellEditor`\n\n* `m:wxGridCellBoolEditor`\n\n* `m:wxGridCellFloatEditor`\n\n* `m:wxGridCellNumberEditor`\n\n* `m:wxGridCellTextEditor`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxGridCellEditor`\n\nwxWidgets docs: [wxGridCellChoiceEditor](https://docs.wxwidgets.org/3.2/classwx_grid_cell_choice_editor.html)","ref":"wxGridCellChoiceEditor.html"},{"type":"function","title":"wxGridCellChoiceEditor.destroy/1","doc":"Destroys the object","ref":"wxGridCellChoiceEditor.html#destroy/1"},{"type":"function","title":"wxGridCellChoiceEditor.new/1","doc":"Equivalent to  new(Choices, []) .","ref":"wxGridCellChoiceEditor.html#new/1"},{"type":"function","title":"wxGridCellChoiceEditor.new/2","doc":"Choice cell renderer ctor.","ref":"wxGridCellChoiceEditor.html#new/2"},{"type":"function","title":"wxGridCellChoiceEditor.setParameters/2","doc":"Parameters string format is \"item1[,item2[...,itemN]]\".\n\nThis method can be called before the editor is used for the first time, or later, in\nwhich case it replaces the previously specified strings with the new ones.","ref":"wxGridCellChoiceEditor.html#setParameters/2"},{"type":"type","title":"wxGridCellChoiceEditor.wxGridCellChoiceEditor/0","doc":"","ref":"wxGridCellChoiceEditor.html#t:wxGridCellChoiceEditor/0"},{"type":"module","title":"wxGridCellEditor","doc":"This class is responsible for providing and manipulating the in-place edit controls for\nthe grid.\n\nInstances of `m:wxGridCellEditor` (actually, instances of derived classes since it is an\nabstract class) can be associated with the cell attributes for individual cells, rows,\ncolumns, or even for the entire grid.\n\nNormally `m:wxGridCellEditor` shows some UI control allowing the user to edit the cell,\nbut starting with wxWidgets 3.1.4 it's also possible to define \"activatable\" cell editors,\nthat change the value of the cell directly when it's activated (typically by pressing\nSpace key or clicking on it), see `TryActivate()` (not implemented in wx) method. Note\nthat when implementing an editor which is always activatable, i.e. never shows any\nin-place editor, it is more convenient to derive its class from `wxGridCellActivatableEditor`\n(not implemented in wx) than from `m:wxGridCellEditor` itself.\n\nSee:\n* `m:wxGridCellBoolEditor`\n\n* `m:wxGridCellChoiceEditor`\n\n* `m:wxGridCellFloatEditor`\n\n* `m:wxGridCellNumberEditor`\n\n* `m:wxGridCellTextEditor`\n\nwxWidgets docs: [wxGridCellEditor](https://docs.wxwidgets.org/3.2/classwx_grid_cell_editor.html)","ref":"wxGridCellEditor.html"},{"type":"function","title":"wxGridCellEditor.create/4","doc":"Creates the actual edit control.","ref":"wxGridCellEditor.html#create/4"},{"type":"function","title":"wxGridCellEditor.handleReturn/2","doc":"Some types of controls on some platforms may need some help with the Return key.","ref":"wxGridCellEditor.html#handleReturn/2"},{"type":"function","title":"wxGridCellEditor.isCreated/1","doc":"Returns true if the edit control has been created.","ref":"wxGridCellEditor.html#isCreated/1"},{"type":"function","title":"wxGridCellEditor.reset/1","doc":"Reset the value in the control back to its starting value.","ref":"wxGridCellEditor.html#reset/1"},{"type":"function","title":"wxGridCellEditor.setSize/2","doc":"Size and position the edit control.","ref":"wxGridCellEditor.html#setSize/2"},{"type":"function","title":"wxGridCellEditor.show/2","doc":"Equivalent to  show(This, Show, []) .","ref":"wxGridCellEditor.html#show/2"},{"type":"function","title":"wxGridCellEditor.show/3","doc":"Show or hide the edit control, use the specified attributes to set colours/fonts for it.","ref":"wxGridCellEditor.html#show/3"},{"type":"function","title":"wxGridCellEditor.startingClick/1","doc":"If the editor is enabled by clicking on the cell, this method will be called.","ref":"wxGridCellEditor.html#startingClick/1"},{"type":"function","title":"wxGridCellEditor.startingKey/2","doc":"If the editor is enabled by pressing keys on the grid, this will be called to let the\neditor do something about that first key if desired.","ref":"wxGridCellEditor.html#startingKey/2"},{"type":"type","title":"wxGridCellEditor.wxGridCellEditor/0","doc":"","ref":"wxGridCellEditor.html#t:wxGridCellEditor/0"},{"type":"module","title":"wxGridCellFloatEditor","doc":"The editor for floating point numbers data.\n\nSee:\n* `m:wxGridCellEditor`\n\n* `m:wxGridCellBoolEditor`\n\n* `m:wxGridCellChoiceEditor`\n\n* `m:wxGridCellNumberEditor`\n\n* `m:wxGridCellTextEditor`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxGridCellEditor`\n\nwxWidgets docs: [wxGridCellFloatEditor](https://docs.wxwidgets.org/3.2/classwx_grid_cell_float_editor.html)","ref":"wxGridCellFloatEditor.html"},{"type":"function","title":"wxGridCellFloatEditor.destroy/1","doc":"Destroys the object","ref":"wxGridCellFloatEditor.html#destroy/1"},{"type":"function","title":"wxGridCellFloatEditor.new/0","doc":"Equivalent to  new([]) .","ref":"wxGridCellFloatEditor.html#new/0"},{"type":"function","title":"wxGridCellFloatEditor.new/1","doc":"Float cell editor ctor.","ref":"wxGridCellFloatEditor.html#new/1"},{"type":"function","title":"wxGridCellFloatEditor.setParameters/2","doc":"The parameters string format is \"width[,precision[,format]]\" where `format` should be\nchosen between f|e|g|E|G (f is used by default)","ref":"wxGridCellFloatEditor.html#setParameters/2"},{"type":"type","title":"wxGridCellFloatEditor.wxGridCellFloatEditor/0","doc":"","ref":"wxGridCellFloatEditor.html#t:wxGridCellFloatEditor/0"},{"type":"module","title":"wxGridCellFloatRenderer","doc":"This class may be used to format floating point data in a cell.\n\nSee:\n* `m:wxGridCellRenderer`\n\n* `m:wxGridCellBoolRenderer`\n\n* `m:wxGridCellNumberRenderer`\n\n* `m:wxGridCellStringRenderer`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxGridCellStringRenderer`\n\n* `m:wxGridCellRenderer`\n\nwxWidgets docs: [wxGridCellFloatRenderer](https://docs.wxwidgets.org/3.2/classwx_grid_cell_float_renderer.html)","ref":"wxGridCellFloatRenderer.html"},{"type":"function","title":"wxGridCellFloatRenderer.destroy/1","doc":"Destroys the object","ref":"wxGridCellFloatRenderer.html#destroy/1"},{"type":"function","title":"wxGridCellFloatRenderer.getPrecision/1","doc":"Returns the precision.","ref":"wxGridCellFloatRenderer.html#getPrecision/1"},{"type":"function","title":"wxGridCellFloatRenderer.getWidth/1","doc":"Returns the width.","ref":"wxGridCellFloatRenderer.html#getWidth/1"},{"type":"function","title":"wxGridCellFloatRenderer.new/0","doc":"Equivalent to  new([]) .","ref":"wxGridCellFloatRenderer.html#new/0"},{"type":"function","title":"wxGridCellFloatRenderer.new/1","doc":"Float cell renderer ctor.","ref":"wxGridCellFloatRenderer.html#new/1"},{"type":"function","title":"wxGridCellFloatRenderer.setParameters/2","doc":"The parameters string format is \"width[,precision[,format]]\" where `format` should be\nchosen between f|e|g|E|G (f is used by default)","ref":"wxGridCellFloatRenderer.html#setParameters/2"},{"type":"function","title":"wxGridCellFloatRenderer.setPrecision/2","doc":"Sets the precision.","ref":"wxGridCellFloatRenderer.html#setPrecision/2"},{"type":"function","title":"wxGridCellFloatRenderer.setWidth/2","doc":"Sets the width.","ref":"wxGridCellFloatRenderer.html#setWidth/2"},{"type":"type","title":"wxGridCellFloatRenderer.wxGridCellFloatRenderer/0","doc":"","ref":"wxGridCellFloatRenderer.html#t:wxGridCellFloatRenderer/0"},{"type":"module","title":"wxGridCellNumberEditor","doc":"Grid cell editor for numeric integer data.\n\nSee:\n* `m:wxGridCellEditor`\n\n* `m:wxGridCellBoolEditor`\n\n* `m:wxGridCellChoiceEditor`\n\n* `m:wxGridCellFloatEditor`\n\n* `m:wxGridCellTextEditor`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxGridCellTextEditor`\n\n* `m:wxGridCellEditor`\n\nwxWidgets docs: [wxGridCellNumberEditor](https://docs.wxwidgets.org/3.2/classwx_grid_cell_number_editor.html)","ref":"wxGridCellNumberEditor.html"},{"type":"function","title":"wxGridCellNumberEditor.destroy/1","doc":"Destroys the object","ref":"wxGridCellNumberEditor.html#destroy/1"},{"type":"function","title":"wxGridCellNumberEditor.getValue/1","doc":"Returns the value currently in the editor control.","ref":"wxGridCellNumberEditor.html#getValue/1"},{"type":"function","title":"wxGridCellNumberEditor.new/0","doc":"Equivalent to  new([]) .","ref":"wxGridCellNumberEditor.html#new/0"},{"type":"function","title":"wxGridCellNumberEditor.new/1","doc":"Allows you to specify the range for acceptable data.\n\nValues equal to -1 for both `min` and `max` indicate that no range checking should be\ndone.","ref":"wxGridCellNumberEditor.html#new/1"},{"type":"function","title":"wxGridCellNumberEditor.setParameters/2","doc":"Parameters string format is \"min,max\".","ref":"wxGridCellNumberEditor.html#setParameters/2"},{"type":"type","title":"wxGridCellNumberEditor.wxGridCellNumberEditor/0","doc":"","ref":"wxGridCellNumberEditor.html#t:wxGridCellNumberEditor/0"},{"type":"module","title":"wxGridCellNumberRenderer","doc":"This class may be used to format integer data in a cell.\n\nSee:\n* `m:wxGridCellRenderer`\n\n* `m:wxGridCellBoolRenderer`\n\n* `m:wxGridCellFloatRenderer`\n\n* `m:wxGridCellStringRenderer`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxGridCellStringRenderer`\n\n* `m:wxGridCellRenderer`\n\nwxWidgets docs: [wxGridCellNumberRenderer](https://docs.wxwidgets.org/3.2/classwx_grid_cell_number_renderer.html)","ref":"wxGridCellNumberRenderer.html"},{"type":"function","title":"wxGridCellNumberRenderer.destroy/1","doc":"Destroys the object","ref":"wxGridCellNumberRenderer.html#destroy/1"},{"type":"function","title":"wxGridCellNumberRenderer.new/0","doc":"Default constructor.","ref":"wxGridCellNumberRenderer.html#new/0"},{"type":"type","title":"wxGridCellNumberRenderer.wxGridCellNumberRenderer/0","doc":"","ref":"wxGridCellNumberRenderer.html#t:wxGridCellNumberRenderer/0"},{"type":"module","title":"wxGridCellRenderer","doc":"This class is responsible for actually drawing the cell in the grid.\n\nYou may pass it to the `m:wxGridCellAttr` (below) to change the format of one given cell\nor to `wxGrid:setDefaultRenderer/2` to change the view of all cells. This is an abstract class, and you will normally\nuse one of the predefined derived classes or derive your own class from it.\n\nSee:\n* `m:wxGridCellBoolRenderer`\n\n* `m:wxGridCellFloatRenderer`\n\n* `m:wxGridCellNumberRenderer`\n\n* `m:wxGridCellStringRenderer`\n\nwxWidgets docs: [wxGridCellRenderer](https://docs.wxwidgets.org/3.2/classwx_grid_cell_renderer.html)","ref":"wxGridCellRenderer.html"},{"type":"function","title":"wxGridCellRenderer.draw/8","doc":"Draw the given cell on the provided DC inside the given rectangle using the style\nspecified by the attribute and the default or selected state corresponding to the\nisSelected value.\n\nThis pure virtual function has a default implementation which will prepare the DC using\nthe given attribute: it will draw the rectangle with the background colour from attr and\nset the text colour and font.","ref":"wxGridCellRenderer.html#draw/8"},{"type":"function","title":"wxGridCellRenderer.getBestSize/6","doc":"Get the preferred size of the cell for its contents.\n\nThis method must be overridden in the derived classes to return the minimal fitting size\nfor displaying the content of the given grid cell.","ref":"wxGridCellRenderer.html#getBestSize/6"},{"type":"type","title":"wxGridCellRenderer.wxGridCellRenderer/0","doc":"","ref":"wxGridCellRenderer.html#t:wxGridCellRenderer/0"},{"type":"module","title":"wxGridCellStringRenderer","doc":"This class may be used to format string data in a cell; it is the default for string\ncells.\n\nSee:\n* `m:wxGridCellRenderer`\n\n* `m:wxGridCellBoolRenderer`\n\n* `m:wxGridCellFloatRenderer`\n\n* `m:wxGridCellNumberRenderer`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxGridCellRenderer`\n\nwxWidgets docs: [wxGridCellStringRenderer](https://docs.wxwidgets.org/3.2/classwx_grid_cell_string_renderer.html)","ref":"wxGridCellStringRenderer.html"},{"type":"function","title":"wxGridCellStringRenderer.destroy/1","doc":"Destroys the object","ref":"wxGridCellStringRenderer.html#destroy/1"},{"type":"function","title":"wxGridCellStringRenderer.new/0","doc":"","ref":"wxGridCellStringRenderer.html#new/0"},{"type":"type","title":"wxGridCellStringRenderer.wxGridCellStringRenderer/0","doc":"","ref":"wxGridCellStringRenderer.html#t:wxGridCellStringRenderer/0"},{"type":"module","title":"wxGridCellTextEditor","doc":"Grid cell editor for string/text data.\n\nSee:\n* `m:wxGridCellEditor`\n\n* `m:wxGridCellBoolEditor`\n\n* `m:wxGridCellChoiceEditor`\n\n* `m:wxGridCellFloatEditor`\n\n* `m:wxGridCellNumberEditor`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxGridCellEditor`\n\nwxWidgets docs: [wxGridCellTextEditor](https://docs.wxwidgets.org/3.2/classwx_grid_cell_text_editor.html)","ref":"wxGridCellTextEditor.html"},{"type":"function","title":"wxGridCellTextEditor.destroy/1","doc":"Destroys the object","ref":"wxGridCellTextEditor.html#destroy/1"},{"type":"function","title":"wxGridCellTextEditor.new/0","doc":"Equivalent to  new([]) .","ref":"wxGridCellTextEditor.html#new/0"},{"type":"function","title":"wxGridCellTextEditor.new/1","doc":"Text cell editor constructor.","ref":"wxGridCellTextEditor.html#new/1"},{"type":"function","title":"wxGridCellTextEditor.setParameters/2","doc":"The parameters string format is \"n\" where n is a number representing the maximum width.","ref":"wxGridCellTextEditor.html#setParameters/2"},{"type":"type","title":"wxGridCellTextEditor.wxGridCellTextEditor/0","doc":"","ref":"wxGridCellTextEditor.html#t:wxGridCellTextEditor/0"},{"type":"module","title":"wxGridEvent","doc":"This event class contains information about various grid events.\n\nNotice that all grid event table macros are available in two versions: `EVT_GRID_XXX` and `EVT_GRID_CMD_XXX`.\nThe only difference between the two is that the former doesn't allow to specify the grid\nwindow identifier and so takes a single parameter, the event handler, but is not suitable\nif there is more than one grid control in the window where the event table is used (as it\nwould catch the events from all the grids). The version with `CMD` takes the id as first\nargument and the event handler as the second one and so can be used with multiple grids as\nwell. Otherwise there are no difference between the two and only the versions without the\nid are documented below for brevity.\n\nThis class is derived, and can use functions, from:\n\n* `m:wxNotifyEvent`\n\n* `m:wxCommandEvent`\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxGridEvent](https://docs.wxwidgets.org/3.2/classwx_grid_event.html)","ref":"wxGridEvent.html"},{"type":"module","title":"Events - wxGridEvent","doc":"Use `wxEvtHandler:connect/3` with `wxGridEventType` to subscribe to events of this type.","ref":"wxGridEvent.html#module-events"},{"type":"function","title":"wxGridEvent.altDown/1","doc":"Returns true if the Alt key was down at the time of the event.","ref":"wxGridEvent.html#altDown/1"},{"type":"function","title":"wxGridEvent.controlDown/1","doc":"Returns true if the Control key was down at the time of the event.","ref":"wxGridEvent.html#controlDown/1"},{"type":"function","title":"wxGridEvent.getCol/1","doc":"Column at which the event occurred.\n\nNotice that for a `wxEVT_GRID_SELECT_CELL` event this column is the column of the newly\nselected cell while the previously selected cell can be retrieved using `wxGrid:getGridCursorCol/1`.","ref":"wxGridEvent.html#getCol/1"},{"type":"function","title":"wxGridEvent.getPosition/1","doc":"Position in pixels at which the event occurred.","ref":"wxGridEvent.html#getPosition/1"},{"type":"function","title":"wxGridEvent.getRow/1","doc":"Row at which the event occurred.\n\nNotice that for a `wxEVT_GRID_SELECT_CELL` event this row is the row of the newly\nselected cell while the previously selected cell can be retrieved using `wxGrid:getGridCursorRow/1`.","ref":"wxGridEvent.html#getRow/1"},{"type":"function","title":"wxGridEvent.metaDown/1","doc":"Returns true if the Meta key was down at the time of the event.","ref":"wxGridEvent.html#metaDown/1"},{"type":"function","title":"wxGridEvent.selecting/1","doc":"Returns true if the user is selecting grid cells, or false if deselecting.","ref":"wxGridEvent.html#selecting/1"},{"type":"function","title":"wxGridEvent.shiftDown/1","doc":"Returns true if the Shift key was down at the time of the event.","ref":"wxGridEvent.html#shiftDown/1"},{"type":"type","title":"wxGridEvent.wxGrid/0","doc":"","ref":"wxGridEvent.html#t:wxGrid/0"},{"type":"type","title":"wxGridEvent.wxGridEvent/0","doc":"","ref":"wxGridEvent.html#t:wxGridEvent/0"},{"type":"type","title":"wxGridEvent.wxGridEventType/0","doc":"","ref":"wxGridEvent.html#t:wxGridEventType/0"},{"type":"module","title":"wxGridSizer","doc":"A grid sizer is a sizer which lays out its children in a two-dimensional table with all\ntable fields having the same size, i.e.\n\nthe width of each field is the width of the widest child, the height of each field is the\nheight of the tallest child.\n\nSee:\n* `m:wxSizer`\n\n* [Overview sizer](https://docs.wxwidgets.org/3.2/overview_sizer.html#overview_sizer)\n\nThis class is derived, and can use functions, from:\n\n* `m:wxSizer`\n\nwxWidgets docs: [wxGridSizer](https://docs.wxwidgets.org/3.2/classwx_grid_sizer.html)","ref":"wxGridSizer.html"},{"type":"function","title":"wxGridSizer.destroy/1","doc":"Destroys the object","ref":"wxGridSizer.html#destroy/1"},{"type":"function","title":"wxGridSizer.getCols/1","doc":"Returns the number of columns that has been specified for the sizer.\n\nReturns zero if the sizer is automatically adjusting the number of columns depending on\nnumber of its children. To get the effective number of columns or rows being currently\nused, see `GetEffectiveColsCount()` (not implemented in wx)","ref":"wxGridSizer.html#getCols/1"},{"type":"function","title":"wxGridSizer.getHGap/1","doc":"Returns the horizontal gap (in pixels) between cells in the sizer.","ref":"wxGridSizer.html#getHGap/1"},{"type":"function","title":"wxGridSizer.getRows/1","doc":"Returns the number of rows that has been specified for the sizer.\n\nReturns zero if the sizer is automatically adjusting the number of rows depending on\nnumber of its children. To get the effective number of columns or rows being currently\nused, see `GetEffectiveRowsCount()` (not implemented in wx).","ref":"wxGridSizer.html#getRows/1"},{"type":"function","title":"wxGridSizer.getVGap/1","doc":"Returns the vertical gap (in pixels) between the cells in the sizer.","ref":"wxGridSizer.html#getVGap/1"},{"type":"function","title":"wxGridSizer.new/1","doc":"Equivalent to  new(Cols, []) .","ref":"wxGridSizer.html#new/1"},{"type":"function","title":"wxGridSizer.new/2","doc":"","ref":"wxGridSizer.html#new/2"},{"type":"function","title":"wxGridSizer.new/3","doc":"","ref":"wxGridSizer.html#new/3"},{"type":"function","title":"wxGridSizer.new/4","doc":"","ref":"wxGridSizer.html#new/4"},{"type":"function","title":"wxGridSizer.setCols/2","doc":"Sets the number of columns in the sizer.","ref":"wxGridSizer.html#setCols/2"},{"type":"function","title":"wxGridSizer.setHGap/2","doc":"Sets the horizontal gap (in pixels) between cells in the sizer.","ref":"wxGridSizer.html#setHGap/2"},{"type":"function","title":"wxGridSizer.setRows/2","doc":"Sets the number of rows in the sizer.","ref":"wxGridSizer.html#setRows/2"},{"type":"function","title":"wxGridSizer.setVGap/2","doc":"Sets the vertical gap (in pixels) between the cells in the sizer.","ref":"wxGridSizer.html#setVGap/2"},{"type":"type","title":"wxGridSizer.wxGridSizer/0","doc":"","ref":"wxGridSizer.html#t:wxGridSizer/0"},{"type":"module","title":"wxHelpEvent","doc":"A help event is sent when the user has requested context-sensitive help.\n\nThis can either be caused by the application requesting context-sensitive help mode via `wxContextHelp`\n(not implemented in wx), or (on MS Windows) by the system generating a WM_HELP message\nwhen the user pressed F1 or clicked on the query button in a dialog caption.\n\nA help event is sent to the window that the user clicked on, and is propagated up the\nwindow hierarchy until the event is processed or there are no more event handlers.\n\nThe application should call `wxEvent:getId/1` to check the identity of the clicked-on window, and then\neither show some suitable help or call `wxEvent:skip/2` if the identifier is unrecognised.\n\nCalling Skip is important because it allows wxWidgets to generate further events for\nancestors of the clicked-on window. Otherwise it would be impossible to show help for\ncontainer windows, since processing would stop after the first window found.\n\nSee:\n* `m:wxDialog`\n\n* [Overview events](https://docs.wxwidgets.org/3.2/overview_events.html#overview_events)\n\nThis class is derived, and can use functions, from:\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxHelpEvent](https://docs.wxwidgets.org/3.2/classwx_help_event.html)","ref":"wxHelpEvent.html"},{"type":"module","title":"Events - wxHelpEvent","doc":"Use `wxEvtHandler:connect/3` with `wxHelpEventType` to subscribe to events of this type.","ref":"wxHelpEvent.html#module-events"},{"type":"function","title":"wxHelpEvent.getOrigin/1","doc":"Returns the origin of the help event which is one of the `wxHelpEvent::Origin` (not\nimplemented in wx) values.\n\nThe application may handle events generated using the keyboard or mouse differently, e.g.\nby using `wx_misc:getMousePosition/0` for the mouse events.\n\nSee: `setOrigin/2`","ref":"wxHelpEvent.html#getOrigin/1"},{"type":"function","title":"wxHelpEvent.getPosition/1","doc":"Returns the left-click position of the mouse, in screen coordinates.\n\nThis allows the application to position the help appropriately.","ref":"wxHelpEvent.html#getPosition/1"},{"type":"function","title":"wxHelpEvent.setOrigin/2","doc":"Set the help event origin, only used internally by wxWidgets normally.\n\nSee: `getOrigin/1`","ref":"wxHelpEvent.html#setOrigin/2"},{"type":"function","title":"wxHelpEvent.setPosition/2","doc":"Sets the left-click position of the mouse, in screen coordinates.","ref":"wxHelpEvent.html#setPosition/2"},{"type":"type","title":"wxHelpEvent.wxHelp/0","doc":"","ref":"wxHelpEvent.html#t:wxHelp/0"},{"type":"type","title":"wxHelpEvent.wxHelpEvent/0","doc":"","ref":"wxHelpEvent.html#t:wxHelpEvent/0"},{"type":"type","title":"wxHelpEvent.wxHelpEventType/0","doc":"","ref":"wxHelpEvent.html#t:wxHelpEventType/0"},{"type":"module","title":"wxHtmlEasyPrinting","doc":"This class provides very simple interface to printing architecture.\n\nIt allows you to print HTML documents using only a few commands.\n\nNote: Do not create this class on the stack only. You should create an instance on app\nstartup and use this instance for all printing operations. The reason is that this class\nstores various settings in it.\n\nwxWidgets docs: [wxHtmlEasyPrinting](https://docs.wxwidgets.org/3.2/classwx_html_easy_printing.html)","ref":"wxHtmlEasyPrinting.html"},{"type":"function","title":"wxHtmlEasyPrinting.destroy/1","doc":"Destroys the object","ref":"wxHtmlEasyPrinting.html#destroy/1"},{"type":"function","title":"wxHtmlEasyPrinting.getPageSetupData/1","doc":"Returns a pointer to `m:wxPageSetupDialogData` instance used by this class.\n\nYou can set its parameters (via SetXXXX methods).","ref":"wxHtmlEasyPrinting.html#getPageSetupData/1"},{"type":"function","title":"wxHtmlEasyPrinting.getPrintData/1","doc":"Returns pointer to `m:wxPrintData` instance used by this class.\n\nYou can set its parameters (via SetXXXX methods).","ref":"wxHtmlEasyPrinting.html#getPrintData/1"},{"type":"function","title":"wxHtmlEasyPrinting.new/0","doc":"Equivalent to  new([]) .","ref":"wxHtmlEasyPrinting.html#new/0"},{"type":"function","title":"wxHtmlEasyPrinting.new/1","doc":"Constructor.","ref":"wxHtmlEasyPrinting.html#new/1"},{"type":"function","title":"wxHtmlEasyPrinting.pageSetup/1","doc":"Display page setup dialog and allows the user to modify settings.","ref":"wxHtmlEasyPrinting.html#pageSetup/1"},{"type":"function","title":"wxHtmlEasyPrinting.previewFile/2","doc":"Preview HTML file.\n\nReturns false in case of error - call `wxPrinter:getLastError/0` to get detailed information about the kind of the\nerror.","ref":"wxHtmlEasyPrinting.html#previewFile/2"},{"type":"function","title":"wxHtmlEasyPrinting.previewText/2","doc":"Equivalent to  previewText(This, Htmltext, []) .","ref":"wxHtmlEasyPrinting.html#previewText/2"},{"type":"function","title":"wxHtmlEasyPrinting.previewText/3","doc":"Preview HTML text (not file!).\n\nReturns false in case of error - call `wxPrinter:getLastError/0` to get detailed information about the kind of the error.","ref":"wxHtmlEasyPrinting.html#previewText/3"},{"type":"function","title":"wxHtmlEasyPrinting.printFile/2","doc":"Print HTML file.\n\nReturns false in case of error - call `wxPrinter:getLastError/0` to get detailed information about the kind of the\nerror.","ref":"wxHtmlEasyPrinting.html#printFile/2"},{"type":"function","title":"wxHtmlEasyPrinting.printText/2","doc":"Equivalent to  printText(This, Htmltext, []) .","ref":"wxHtmlEasyPrinting.html#printText/2"},{"type":"function","title":"wxHtmlEasyPrinting.printText/3","doc":"Print HTML text (not file!).\n\nReturns false in case of error - call `wxPrinter:getLastError/0` to get detailed information about the kind of the error.","ref":"wxHtmlEasyPrinting.html#printText/3"},{"type":"function","title":"wxHtmlEasyPrinting.setFonts/3","doc":"Equivalent to  setFonts(This, Normal_face, Fixed_face, []) .","ref":"wxHtmlEasyPrinting.html#setFonts/3"},{"type":"function","title":"wxHtmlEasyPrinting.setFonts/4","doc":"Sets fonts.\n\nSee `wxHtmlDCRenderer::SetFonts` (not implemented in wx) for detailed description.","ref":"wxHtmlEasyPrinting.html#setFonts/4"},{"type":"function","title":"wxHtmlEasyPrinting.setFooter/2","doc":"Equivalent to  setFooter(This, Footer, []) .","ref":"wxHtmlEasyPrinting.html#setFooter/2"},{"type":"function","title":"wxHtmlEasyPrinting.setFooter/3","doc":"Set page footer.\n\nThe following macros can be used inside it: @DATE@ is replaced by the current date in\ndefault format @PAGENUM@ is replaced by page number @PAGESCNT@ is replaced by total number\nof pages @TIME@ is replaced by the current time in default format @TITLE@ is replaced with\nthe title of the document","ref":"wxHtmlEasyPrinting.html#setFooter/3"},{"type":"function","title":"wxHtmlEasyPrinting.setHeader/2","doc":"Equivalent to  setHeader(This, Header, []) .","ref":"wxHtmlEasyPrinting.html#setHeader/2"},{"type":"function","title":"wxHtmlEasyPrinting.setHeader/3","doc":"Set page header.\n\nThe following macros can be used inside it:\n\n* @DATE@ is replaced by the current date in default format\n\n* @PAGENUM@ is replaced by page number\n\n* @PAGESCNT@ is replaced by total number of pages\n\n* @TIME@ is replaced by the current time in default format\n\n* @TITLE@ is replaced with the title of the document","ref":"wxHtmlEasyPrinting.html#setHeader/3"},{"type":"type","title":"wxHtmlEasyPrinting.wxHtmlEasyPrinting/0","doc":"","ref":"wxHtmlEasyPrinting.html#t:wxHtmlEasyPrinting/0"},{"type":"module","title":"wxHtmlLinkEvent","doc":"This event class is used for the events generated by `m:wxHtmlWindow`.\n\nThis class is derived, and can use functions, from:\n\n* `m:wxCommandEvent`\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxHtmlLinkEvent](https://docs.wxwidgets.org/3.2/classwx_html_link_event.html)","ref":"wxHtmlLinkEvent.html"},{"type":"module","title":"Events - wxHtmlLinkEvent","doc":"Use `wxEvtHandler:connect/3` with `wxHtmlLinkEventType` to subscribe to events of this type.","ref":"wxHtmlLinkEvent.html#module-events"},{"type":"function","title":"wxHtmlLinkEvent.getLinkInfo/1","doc":"Returns the `wx_wxHtmlLinkInfo()` which contains info about the cell clicked and the\nhyperlink it contains.","ref":"wxHtmlLinkEvent.html#getLinkInfo/1"},{"type":"type","title":"wxHtmlLinkEvent.wxHtmlLink/0","doc":"","ref":"wxHtmlLinkEvent.html#t:wxHtmlLink/0"},{"type":"type","title":"wxHtmlLinkEvent.wxHtmlLinkEvent/0","doc":"","ref":"wxHtmlLinkEvent.html#t:wxHtmlLinkEvent/0"},{"type":"type","title":"wxHtmlLinkEvent.wxHtmlLinkEventType/0","doc":"","ref":"wxHtmlLinkEvent.html#t:wxHtmlLinkEventType/0"},{"type":"module","title":"wxHtmlWindow","doc":"`m:wxHtmlWindow` is probably the only class you will directly use unless you want to do\nsomething special (like adding new tag handlers or MIME filters).\n\nThe purpose of this class is to display rich content pages (either local file or\ndownloaded via HTTP protocol) in a window based on a subset of the HTML standard. The\nwidth of the window is constant, given in the constructor and virtual height is changed\ndynamically depending on page size. Once the window is created you can set its content by\ncalling `setPage/2` with raw HTML, `loadPage/2` with a `wxFileSystem` (not implemented in wx) location or `loadFile/2` with a filename.\n\nNote: If you want complete HTML/CSS support as well as a Javascript engine, consider\nusing `m:wxWebView` instead.\n\n`m:wxHtmlWindow` uses the `m:wxImage` class for displaying images, so you need to\ninitialize the handlers for any image formats you use before loading a page. See\n?wxInitAllImageHandlers and `wxImage::AddHandler` (not implemented in wx).","ref":"wxHtmlWindow.html"},{"type":"module","title":"Styles - wxHtmlWindow","doc":"This class supports the following styles:\n\n* wxHW_SCROLLBAR_NEVER: Never display scrollbars, not even when the page is larger than the\nwindow.\n\n* wxHW_SCROLLBAR_AUTO: Display scrollbars only if page's size exceeds window's size.\n\n* wxHW_NO_SELECTION: Don't allow the user to select text.\n\nSee: `m:wxHtmlLinkEvent`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxScrolledWindow`\n\n* `m:wxPanel`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxHtmlWindow](https://docs.wxwidgets.org/3.2/classwx_html_window.html)","ref":"wxHtmlWindow.html#module-styles"},{"type":"module","title":"Events - wxHtmlWindow","doc":"Event types emitted from this class:\n\n* [`html_cell_clicked`](`m:wxHtmlLinkEvent`)\n\n* [`html_cell_hover`](`m:wxHtmlLinkEvent`)\n\n* [`command_html_link_clicked`](`m:wxHtmlLinkEvent`)","ref":"wxHtmlWindow.html#module-events"},{"type":"function","title":"wxHtmlWindow.appendToPage/2","doc":"Appends HTML fragment to currently displayed text and refreshes the window.\n\nReturn: false if an error occurred, true otherwise.","ref":"wxHtmlWindow.html#appendToPage/2"},{"type":"function","title":"wxHtmlWindow.destroy/1","doc":"Destroys the object","ref":"wxHtmlWindow.html#destroy/1"},{"type":"function","title":"wxHtmlWindow.getOpenedAnchor/1","doc":"Returns anchor within currently opened page (see `getOpenedPage/1`).\n\nIf no page is opened or if the displayed page wasn't produced by call to `loadPage/2`, empty string\nis returned.","ref":"wxHtmlWindow.html#getOpenedAnchor/1"},{"type":"function","title":"wxHtmlWindow.getOpenedPage/1","doc":"Returns full location of the opened page.\n\nIf no page is opened or if the displayed page wasn't produced by call to `loadPage/2`, empty string\nis returned.","ref":"wxHtmlWindow.html#getOpenedPage/1"},{"type":"function","title":"wxHtmlWindow.getOpenedPageTitle/1","doc":"Returns title of the opened page or wxEmptyString if the current page does not contain\n* * tag.","ref":"wxHtmlWindow.html#getOpenedPageTitle/1"},{"type":"function","title":"wxHtmlWindow.getRelatedFrame/1","doc":"Returns the related frame.","ref":"wxHtmlWindow.html#getRelatedFrame/1"},{"type":"function","title":"wxHtmlWindow.historyBack/1","doc":"Moves back to the previous page.\n\nOnly pages displayed using `loadPage/2` are stored in history list.","ref":"wxHtmlWindow.html#historyBack/1"},{"type":"function","title":"wxHtmlWindow.historyCanBack/1","doc":"Returns true if it is possible to go back in the history i.e.\n\n`historyBack/1` won't fail.","ref":"wxHtmlWindow.html#historyCanBack/1"},{"type":"function","title":"wxHtmlWindow.historyCanForward/1","doc":"Returns true if it is possible to go forward in the history i.e.\n\n`historyForward/1` won't fail.","ref":"wxHtmlWindow.html#historyCanForward/1"},{"type":"function","title":"wxHtmlWindow.historyClear/1","doc":"Clears history.","ref":"wxHtmlWindow.html#historyClear/1"},{"type":"function","title":"wxHtmlWindow.historyForward/1","doc":"Moves to next page in history.\n\nOnly pages displayed using `loadPage/2` are stored in history list.","ref":"wxHtmlWindow.html#historyForward/1"},{"type":"function","title":"wxHtmlWindow.loadFile/2","doc":"Loads an HTML page from a file and displays it.\n\nReturn: false if an error occurred, true otherwise\n\nSee: `loadPage/2`","ref":"wxHtmlWindow.html#loadFile/2"},{"type":"function","title":"wxHtmlWindow.loadPage/2","doc":"Unlike `setPage/2` this function first loads the HTML page from `location` and then\ndisplays it.\n\nReturn: false if an error occurred, true otherwise\n\nSee: `loadFile/2`","ref":"wxHtmlWindow.html#loadPage/2"},{"type":"function","title":"wxHtmlWindow.new/0","doc":"Default ctor.","ref":"wxHtmlWindow.html#new/0"},{"type":"function","title":"wxHtmlWindow.new/1","doc":"Equivalent to  new(Parent, []) .","ref":"wxHtmlWindow.html#new/1"},{"type":"function","title":"wxHtmlWindow.new/2","doc":"Constructor.\n\nThe parameters are the same as `wxScrolled::wxScrolled()` (not implemented in wx)\nconstructor.","ref":"wxHtmlWindow.html#new/2"},{"type":"function","title":"wxHtmlWindow.selectAll/1","doc":"Selects all text in the window.\n\nSee:\n* `selectLine/2`\n\n* `selectWord/2`","ref":"wxHtmlWindow.html#selectAll/1"},{"type":"function","title":"wxHtmlWindow.selectionToText/1","doc":"Returns the current selection as plain text.\n\nReturns an empty string if no text is currently selected.","ref":"wxHtmlWindow.html#selectionToText/1"},{"type":"function","title":"wxHtmlWindow.selectLine/2","doc":"Selects the line of text that `pos` points at.\n\nNote that `pos` is relative to the top of displayed page, not to window's origin, use `wxScrolledWindow:calcUnscrolledPosition/3` to\nconvert physical coordinate.\n\nSee:\n* `selectAll/1`\n\n* `selectWord/2`","ref":"wxHtmlWindow.html#selectLine/2"},{"type":"function","title":"wxHtmlWindow.selectWord/2","doc":"Selects the word at position `pos`.\n\nNote that `pos` is relative to the top of displayed page, not to window's origin, use `wxScrolledWindow:calcUnscrolledPosition/3` to\nconvert physical coordinate.\n\nSee:\n* `selectAll/1`\n\n* `selectLine/2`","ref":"wxHtmlWindow.html#selectWord/2"},{"type":"function","title":"wxHtmlWindow.setBorders/2","doc":"This function sets the space between border of window and HTML contents.\n\nSee image:","ref":"wxHtmlWindow.html#setBorders/2"},{"type":"function","title":"wxHtmlWindow.setFonts/3","doc":"Equivalent to  setFonts(This, Normal_face, Fixed_face, []) .","ref":"wxHtmlWindow.html#setFonts/3"},{"type":"function","title":"wxHtmlWindow.setFonts/4","doc":"This function sets font sizes and faces.\n\nSee `wxHtmlDCRenderer::SetFonts` (not implemented in wx) for detailed description.","ref":"wxHtmlWindow.html#setFonts/4"},{"type":"function","title":"wxHtmlWindow.setPage/2","doc":"Sets the source of a page and displays it, for example:\n\nIf you want to load a document from some location use `loadPage/2` instead.\n\nReturn: false if an error occurred, true otherwise.","ref":"wxHtmlWindow.html#setPage/2"},{"type":"function","title":"wxHtmlWindow.setRelatedFrame/3","doc":"Sets the frame in which page title will be displayed.\n\n`format` is the format of the frame title, e.g. \"HtmlHelp : %s\". It must contain exactly\none s. This s is substituted with HTML page title.","ref":"wxHtmlWindow.html#setRelatedFrame/3"},{"type":"function","title":"wxHtmlWindow.setRelatedStatusBar/2","doc":"`After` calling `setRelatedFrame/3`, this sets statusbar slot where messages will be\ndisplayed.\n\n(Default is -1 = no messages.)","ref":"wxHtmlWindow.html#setRelatedStatusBar/2"},{"type":"function","title":"wxHtmlWindow.setRelatedStatusBar/3","doc":"`Sets` the associated statusbar where messages will be displayed.\n\nCall this instead of `setRelatedFrame/3` if you want statusbar updates only, no changing of the frame title.\n\nSince: 2.9.0","ref":"wxHtmlWindow.html#setRelatedStatusBar/3"},{"type":"function","title":"wxHtmlWindow.toText/1","doc":"Returns content of currently displayed page as plain text.","ref":"wxHtmlWindow.html#toText/1"},{"type":"type","title":"wxHtmlWindow.wxHtmlWindow/0","doc":"","ref":"wxHtmlWindow.html#t:wxHtmlWindow/0"},{"type":"module","title":"wxIcon","doc":"An icon is a small rectangular bitmap usually used for denoting a minimized application.\n\nIt differs from a `m:wxBitmap` in always having a mask associated with it for transparent\ndrawing. On some platforms, icons and bitmaps are implemented identically, since there is\nno real distinction between a `m:wxBitmap` with a mask and an icon; and there is no\nspecific icon format on some platforms (X-based applications usually standardize on XPMs\nfor small bitmaps and icons). However, some platforms (such as Windows) make the\ndistinction, so a separate class is provided.\n\nRemark: It is usually desirable to associate a pertinent icon with a frame. Icons can\nalso be used for other purposes, for example with `m:wxTreeCtrl` and `m:wxListCtrl`. Icons\nhave different formats on different platforms therefore separate icons will usually be\ncreated for the different environments. Platform-specific methods for creating a `m:wxIcon`\nstructure are catered for, and this is an occasion where conditional compilation will\nprobably be required. Note that a new icon must be created for every time the icon is to\nbe used for a new window. In Windows, the icon will not be reloaded if it has already been\nused. An icon allocated to a frame will be deleted when the frame is deleted. For more\ninformation please see overview_bitmap.\n\nPredefined objects (include wx.hrl): ?wxNullIcon\n\nSee:\n* [Overview bitmap](https://docs.wxwidgets.org/3.2/overview_bitmap.html#overview_bitmap)\n\n* [Overview bitmap](https://docs.wxwidgets.org/3.2/overview_bitmap.html#overview_bitmap_supportedformats)\n\n* `m:wxIconBundle`\n\n* `wxDC:drawIcon/3`\n\n* `m:wxCursor`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxBitmap`\n\nwxWidgets docs: [wxIcon](https://docs.wxwidgets.org/3.2/classwx_icon.html)","ref":"wxIcon.html"},{"type":"function","title":"wxIcon.copyFromBitmap/2","doc":"Copies `bmp` bitmap to this icon.\n\nUnder MS Windows the bitmap must have mask colour set.\n\nSee: `wxBitmap:loadFile/3`","ref":"wxIcon.html#copyFromBitmap/2"},{"type":"function","title":"wxIcon.destroy/1","doc":"Destroys the object","ref":"wxIcon.html#destroy/1"},{"type":"function","title":"wxIcon.new/0","doc":"Default ctor.\n\nConstructs an icon object with no data; an assignment or another member function such as `wxBitmap:loadFile/3`\nmust be called subsequently.","ref":"wxIcon.html#new/0"},{"type":"function","title":"wxIcon.new/1","doc":"Copy ctor.","ref":"wxIcon.html#new/1"},{"type":"function","title":"wxIcon.new/2","doc":"Loads an icon from a file or resource.\n\nSee: `wxBitmap:loadFile/3`","ref":"wxIcon.html#new/2"},{"type":"type","title":"wxIcon.wxIcon/0","doc":"","ref":"wxIcon.html#t:wxIcon/0"},{"type":"module","title":"wxIconBundle","doc":"This class contains multiple copies of an icon in different sizes.\n\nIt is typically used in `wxDialog::SetIcons` (not implemented in wx) and `wxTopLevelWindow:setIcons/2`.\n\nPredefined objects (include wx.hrl): ?wxNullIconBundle\n\nwxWidgets docs: [wxIconBundle](https://docs.wxwidgets.org/3.2/classwx_icon_bundle.html)","ref":"wxIconBundle.html"},{"type":"function","title":"wxIconBundle.addIcon/2","doc":"Adds the icon to the collection; if the collection already contains an icon with the same\nwidth and height, it is replaced by the new one.","ref":"wxIconBundle.html#addIcon/2"},{"type":"function","title":"wxIconBundle.addIcon/3","doc":"","ref":"wxIconBundle.html#addIcon/3"},{"type":"function","title":"wxIconBundle.destroy/1","doc":"Destroys the object","ref":"wxIconBundle.html#destroy/1"},{"type":"function","title":"wxIconBundle.getIcon/1","doc":"Equivalent to  getIcon(This, []) .","ref":"wxIconBundle.html#getIcon/1"},{"type":"function","title":"wxIconBundle.getIcon/2","doc":"Same as.\n\n.","ref":"wxIconBundle.html#getIcon/2"},{"type":"function","title":"wxIconBundle.getIcon/3","doc":"Returns the icon with the given size.\n\nIf `size` is ?wxDefaultSize, it is interpreted as the standard system icon size, i.e. the\nsize returned by `wxSystemSettings:getMetric/2` for `wxSYS_ICON_X` and `wxSYS_ICON_Y`.\n\nIf the bundle contains an icon with exactly the requested size, it's always returned.\nOtherwise, the behaviour depends on the flags. If only `wxIconBundle::FALLBACK_NONE` (not\nimplemented in wx) is given, the function returns an invalid icon. If `wxIconBundle::FALLBACK_SYSTEM`\n(not implemented in wx) is given, it tries to find the icon of standard system size,\nregardless of the size passed as parameter. Otherwise, or if the icon system size is not\nfound neither, but `wxIconBundle::FALLBACK_NEAREST_LARGER` (not implemented in wx) flag is\nspecified, the function returns the smallest icon of the size larger than the requested\none or, if this fails too, just the icon closest to the specified size.\n\nThe `flags` parameter is available only since wxWidgets 2.9.4.","ref":"wxIconBundle.html#getIcon/3"},{"type":"function","title":"wxIconBundle.new/0","doc":"Default ctor.","ref":"wxIconBundle.html#new/0"},{"type":"function","title":"wxIconBundle.new/1","doc":"Initializes the bundle with the icon(s) found in the file.","ref":"wxIconBundle.html#new/1"},{"type":"function","title":"wxIconBundle.new/2","doc":"","ref":"wxIconBundle.html#new/2"},{"type":"type","title":"wxIconBundle.wxIconBundle/0","doc":"","ref":"wxIconBundle.html#t:wxIconBundle/0"},{"type":"module","title":"wxIconizeEvent","doc":"An event being sent when the frame is iconized (minimized) or restored.\n\nSee:\n* [Overview events](https://docs.wxwidgets.org/3.2/overview_events.html#overview_events)\n\n* `wxTopLevelWindow:iconize/2`\n\n* `wxTopLevelWindow:isIconized/1`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxIconizeEvent](https://docs.wxwidgets.org/3.2/classwx_iconize_event.html)","ref":"wxIconizeEvent.html"},{"type":"module","title":"Events - wxIconizeEvent","doc":"Use `wxEvtHandler:connect/3` with `wxIconizeEventType` to subscribe to events of this type.","ref":"wxIconizeEvent.html#module-events"},{"type":"function","title":"wxIconizeEvent.isIconized/1","doc":"Returns true if the frame has been iconized, false if it has been restored.","ref":"wxIconizeEvent.html#isIconized/1"},{"type":"type","title":"wxIconizeEvent.wxIconize/0","doc":"","ref":"wxIconizeEvent.html#t:wxIconize/0"},{"type":"type","title":"wxIconizeEvent.wxIconizeEvent/0","doc":"","ref":"wxIconizeEvent.html#t:wxIconizeEvent/0"},{"type":"type","title":"wxIconizeEvent.wxIconizeEventType/0","doc":"","ref":"wxIconizeEvent.html#t:wxIconizeEventType/0"},{"type":"module","title":"wxIdleEvent","doc":"This class is used for idle events, which are generated when the system becomes idle.\n\nNote that, unless you do something specifically, the idle events are not sent if the\nsystem remains idle once it has become it, e.g. only a single idle event will be generated\nuntil something else resulting in more normal events happens and only then is the next\nidle event sent again.\n\nIf you need to ensure a continuous stream of idle events, you can either use `requestMore/2` method in\nyour handler or call ?wxWakeUpIdle() periodically (for example from a timer event\nhandler), but note that both of these approaches (and especially the first one) increase\nthe system load and so should be avoided if possible.\n\nBy default, idle events are sent to all windows, including even the hidden ones because\nthey may be shown if some condition is met from their `wxEVT_IDLE` (or related `wxEVT_UPDATE_UI`)\nhandler. The children of hidden windows do not receive idle events however as they can't\nchange their state in any way noticeable by the user. Finally, the global `wxApp` (not\nimplemented in wx) object also receives these events, as usual, so it can be used for any\nglobal idle time processing.\n\nIf sending idle events to all windows is causing a significant overhead in your\napplication, you can call `setMode/1` with the value wxIDLE_PROCESS_SPECIFIED, and set the\nwxWS_EX_PROCESS_IDLE extra window style for every window which should receive idle events,\nall the other ones will not receive them in this case.\n\nDelayed Action Mechanism\n\n`m:wxIdleEvent` can be used to perform some action \"at slightly later time\". This can be\nnecessary in several circumstances when, for whatever reason, something can't be done in\nthe current event handler. For example, if a mouse event handler is called with the mouse\nbutton pressed, the mouse can be currently captured and some operations with it - notably\ncapturing it again - might be impossible or lead to undesirable results. If you still want\nto capture it, you can do it from `wxEVT_IDLE` handler when it is called the next time\ninstead of doing it immediately.\n\nThis can be achieved in two different ways: when using static event tables, you will need\na flag indicating to the (always connected) idle event handler whether the desired action\nshould be performed. The originally called handler would then set it to indicate that it\nshould indeed be done and the idle handler itself would reset it to prevent it from doing\nthe same action again.\n\nUsing dynamically connected event handlers things are even simpler as the original event\nhandler can simply `wxEvtHandler::Connect()` (not implemented in wx) or `wxEvtHandler::Bind()`\n(not implemented in wx) the idle event handler which would only be executed then and\ncould `wxEvtHandler::Disconnect()` (not implemented in wx) or `wxEvtHandler::Unbind()`\n(not implemented in wx) itself.\n\nSee:\n* [Overview events](https://docs.wxwidgets.org/3.2/overview_events.html#overview_events)\n\n* `m:wxUpdateUIEvent`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxIdleEvent](https://docs.wxwidgets.org/3.2/classwx_idle_event.html)","ref":"wxIdleEvent.html"},{"type":"module","title":"Events - wxIdleEvent","doc":"Use `wxEvtHandler:connect/3` with `wxIdleEventType` to subscribe to events of this type.","ref":"wxIdleEvent.html#module-events"},{"type":"function","title":"wxIdleEvent.getMode/0","doc":"Static function returning a value specifying how wxWidgets will send idle events: to all\nwindows, or only to those which specify that they will process the events.\n\nSee: `setMode/1`","ref":"wxIdleEvent.html#getMode/0"},{"type":"function","title":"wxIdleEvent.moreRequested/1","doc":"Returns true if the OnIdle function processing this event requested more processing time.\n\nSee: `requestMore/2`","ref":"wxIdleEvent.html#moreRequested/1"},{"type":"function","title":"wxIdleEvent.requestMore/1","doc":"Equivalent to  requestMore(This, []) .","ref":"wxIdleEvent.html#requestMore/1"},{"type":"function","title":"wxIdleEvent.requestMore/2","doc":"Tells wxWidgets that more processing is required.\n\nThis function can be called by an OnIdle handler for a window or window event handler to\nindicate that wxApp::OnIdle should forward the OnIdle event once more to the application windows.\n\nIf no window calls this function during OnIdle, then the application will remain in a\npassive event loop (not calling OnIdle) until a new event is posted to the application by\nthe windowing system.\n\nSee: `moreRequested/1`","ref":"wxIdleEvent.html#requestMore/2"},{"type":"function","title":"wxIdleEvent.setMode/1","doc":"Static function for specifying how wxWidgets will send idle events: to all windows, or\nonly to those which specify that they will process the events.","ref":"wxIdleEvent.html#setMode/1"},{"type":"type","title":"wxIdleEvent.wxIdle/0","doc":"","ref":"wxIdleEvent.html#t:wxIdle/0"},{"type":"type","title":"wxIdleEvent.wxIdleEvent/0","doc":"","ref":"wxIdleEvent.html#t:wxIdleEvent/0"},{"type":"type","title":"wxIdleEvent.wxIdleEventType/0","doc":"","ref":"wxIdleEvent.html#t:wxIdleEventType/0"},{"type":"module","title":"wxImage","doc":"This class encapsulates a platform-independent image.\n\nAn image can be created from data, or using `wxBitmap:convertToImage/1`. An image can be loaded from a file in a\nvariety of formats, and is extensible to new formats via image format handlers. Functions\nare available to set and get image bits, so it can be used for basic image manipulation.\n\nA `m:wxImage` cannot (currently) be drawn directly to a `m:wxDC`. Instead, a\nplatform-specific `m:wxBitmap` object must be created from it using the\nwxBitmap::wxBitmap(wxImage,int depth) constructor. This bitmap can then be drawn in a\ndevice context, using `wxDC:drawBitmap/4`.\n\nMore on the difference between `m:wxImage` and `m:wxBitmap`: `m:wxImage` is just a buffer\nof RGB bytes with an optional buffer for the alpha bytes. It is all generic, platform\nindependent and image file format independent code. It includes generic code for scaling,\nresizing, clipping, and other manipulations of the image data. OTOH, `m:wxBitmap` is\nintended to be a wrapper of whatever is the native image format that is quickest/easiest\nto draw to a DC or to be the target of the drawing operations performed on a `m:wxMemoryDC`.\nBy splitting the responsibilities between wxImage/wxBitmap like this then it's easier to\nuse generic code shared by all platforms and image types for generic operations and\nplatform specific code where performance or compatibility is needed.\n\nOne colour value of the image may be used as a mask colour which will lead to the\nautomatic creation of a `m:wxMask` object associated to the bitmap object.\n\nAlpha channel support\n\nStarting from wxWidgets 2.5.0 `m:wxImage` supports alpha channel data, that is in\naddition to a byte for the red, green and blue colour components for each pixel it also\nstores a byte representing the pixel opacity.\n\nAn alpha value of 0 corresponds to a transparent pixel (null opacity) while a value of\n255 means that the pixel is 100% opaque. The constants ?wxIMAGE\\_ALPHA\\_TRANSPARENT and\n?wxIMAGE\\_ALPHA\\_OPAQUE can be used to indicate those values in a more readable form.\n\nWhile all images have RGB data, not all images have an alpha channel. Before using `getAlpha/3` you\nshould check if this image contains an alpha channel with `hasAlpha/1`. Currently the BMP, PNG, TGA,\nand TIFF format handlers have full alpha channel support for loading so if you want to use\nalpha you have to use one of these formats. If you initialize the image alpha channel\nyourself using `setAlpha/4`, you should save it in either PNG, TGA, or TIFF format to avoid losing it\nas these are the only handlers that currently support saving with alpha.\n\nAvailable image handlers\n\nThe following image handlers are available. wxBMPHandler is always installed by default.\nTo use other image formats, install the appropriate handler with `wxImage::AddHandler`\n(not implemented in wx) or call ?wxInitAllImageHandlers().\n\n* wxBMPHandler: For loading (including alpha support) and saving, always installed.\n\n* `wxPNGHandler` (not implemented in wx): For loading and saving. Includes alpha support.\n\n* `wxJPEGHandler` (not implemented in wx): For loading and saving.\n\n* `wxGIFHandler` (not implemented in wx): For loading and saving (see below).\n\n* `wxPCXHandler` (not implemented in wx): For loading and saving (see below).\n\n* `wxPNMHandler` (not implemented in wx): For loading and saving (see below).\n\n* `wxTIFFHandler` (not implemented in wx): For loading and saving. Includes alpha support.\n\n* `wxTGAHandler` (not implemented in wx): For loading and saving. Includes alpha support.\n\n* `wxIFFHandler` (not implemented in wx): For loading only.\n\n* `wxXPMHandler` (not implemented in wx): For loading and saving.\n\n* wxICOHandler: For loading and saving.\n\n* wxCURHandler: For loading and saving.\n\n* wxANIHandler: For loading only.\n\nWhen saving in PCX format, `wxPCXHandler` (not implemented in wx) will count the number\nof different colours in the image; if there are 256 or less colours, it will save as 8\nbit, else it will save as 24 bit.\n\nLoading PNMs only works for ASCII or raw RGB images. When saving in PNM format, `wxPNMHandler`\n(not implemented in wx) will always save as raw RGB.\n\nSaving GIFs requires images of maximum 8 bpp (see `wxQuantize` (not implemented in wx)),\nand the alpha channel converted to a mask (see `convertAlphaToMask/5`). Saving an animated GIF requires images of\nthe same size (see `wxGIFHandler::SaveAnimation` (not implemented in wx))\n\nPredefined objects (include wx.hrl): ?wxNullImage\n\nSee:\n* `m:wxBitmap`\n\n* ?wxInitAllImageHandlers()\n\nwxWidgets docs: [wxImage](https://docs.wxwidgets.org/3.2/classwx_image.html)","ref":"wxImage.html"},{"type":"function","title":"wxImage.blur/2","doc":"Blurs the image in both horizontal and vertical directions by the specified pixel `blurRadius`.\n\nThis should not be used when using a single mask colour for transparency.\n\nSee:\n* `blurHorizontal/2`\n\n* `blurVertical/2`","ref":"wxImage.html#blur/2"},{"type":"function","title":"wxImage.blurHorizontal/2","doc":"Blurs the image in the horizontal direction only.\n\nThis should not be used when using a single mask colour for transparency.\n\nSee:\n* `blur/2`\n\n* `blurVertical/2`","ref":"wxImage.html#blurHorizontal/2"},{"type":"function","title":"wxImage.blurVertical/2","doc":"Blurs the image in the vertical direction only.\n\nThis should not be used when using a single mask colour for transparency.\n\nSee:\n* `blur/2`\n\n* `blurHorizontal/2`","ref":"wxImage.html#blurVertical/2"},{"type":"function","title":"wxImage.convertAlphaToMask/1","doc":"Equivalent to  convertAlphaToMask(This, []) .","ref":"wxImage.html#convertAlphaToMask/1"},{"type":"function","title":"wxImage.convertAlphaToMask/2","doc":"If the image has alpha channel, this method converts it to mask.\n\nIf the image has an alpha channel, all pixels with alpha value less than `threshold` are\nreplaced with the mask colour and the alpha channel is removed. Otherwise nothing is done.\n\nThe mask colour is chosen automatically using `findFirstUnusedColour/2`, see the overload below if this is not appropriate.\n\nReturn: Returns true on success, false on error.","ref":"wxImage.html#convertAlphaToMask/2"},{"type":"function","title":"wxImage.convertAlphaToMask/4","doc":"Equivalent to  convertAlphaToMask(This, Mr, Mg, Mb, []) .","ref":"wxImage.html#convertAlphaToMask/4"},{"type":"function","title":"wxImage.convertAlphaToMask/5","doc":"If the image has alpha channel, this method converts it to mask using the specified\ncolour as the mask colour.\n\nIf the image has an alpha channel, all pixels with alpha value less than `threshold` are\nreplaced with the mask colour and the alpha channel is removed. Otherwise nothing is done.\n\nSince: 2.9.0\n\nReturn: Returns true on success, false on error.","ref":"wxImage.html#convertAlphaToMask/5"},{"type":"function","title":"wxImage.convertToGreyscale/1","doc":"Returns a greyscale version of the image.\n\nSince: 2.9.0","ref":"wxImage.html#convertToGreyscale/1"},{"type":"function","title":"wxImage.convertToGreyscale/4","doc":"Returns a greyscale version of the image.\n\nThe returned image uses the luminance component of the original to calculate the\ngreyscale. Defaults to using the standard ITU-T BT.601 when converting to YUV, where every\npixel equals (R * `weight_r`) + (G * `weight_g`) + (B * `weight_b`).","ref":"wxImage.html#convertToGreyscale/4"},{"type":"function","title":"wxImage.convertToMono/4","doc":"Returns monochromatic version of the image.\n\nThe returned image has white colour where the original has (r,g,b) colour and black\ncolour everywhere else.","ref":"wxImage.html#convertToMono/4"},{"type":"function","title":"wxImage.copy/1","doc":"Returns an identical copy of this image.","ref":"wxImage.html#copy/1"},{"type":"function","title":"wxImage.create/2","doc":"Equivalent to  create(This, Sz, []) .","ref":"wxImage.html#create/2"},{"type":"function","title":"wxImage.create/3","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxImage.html#create/3"},{"type":"function","title":"wxImage.create/4","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxImage.html#create/4"},{"type":"function","title":"wxImage.create/5","doc":"Creates a fresh image.\n\nSee `new/4` for more info.\n\nReturn: true if the call succeeded, false otherwise.","ref":"wxImage.html#create/5"},{"type":"function","title":"wxImage.Destroy/1","doc":"Destroys the image data.","ref":"wxImage.html#Destroy/1"},{"type":"function","title":"wxImage.destroy/1","doc":"Destroys the object","ref":"wxImage.html#destroy/1"},{"type":"function","title":"wxImage.findFirstUnusedColour/1","doc":"Equivalent to  findFirstUnusedColour(This, []) .","ref":"wxImage.html#findFirstUnusedColour/1"},{"type":"function","title":"wxImage.findFirstUnusedColour/2","doc":"Finds the first colour that is never used in the image.\n\nThe search begins at given initial colour and continues by increasing R, G and B\ncomponents (in this order) by 1 until an unused colour is found or the colour space exhausted.\n\nThe parameters `r`, `g`, `b` are pointers to variables to save the colour.\n\nThe parameters `startR`, `startG`, `startB` define the initial values of the colour. The\nreturned colour will have RGB values equal to or greater than these.\n\nReturn: Returns false if there is no unused colour left, true on success.\n\nNote: This method involves computing the histogram, which is a computationally intensive\noperation.","ref":"wxImage.html#findFirstUnusedColour/2"},{"type":"function","title":"wxImage.getAlpha/1","doc":"Returns pointer to the array storing the alpha values for this image.\n\nThis pointer is NULL for the images without the alpha channel. If the image does have it,\nthis pointer may be used to directly manipulate the alpha values which are stored as the\nRGB ones.","ref":"wxImage.html#getAlpha/1"},{"type":"function","title":"wxImage.getAlpha/3","doc":"Return alpha value at given pixel location.","ref":"wxImage.html#getAlpha/3"},{"type":"function","title":"wxImage.getBlue/3","doc":"Returns the blue intensity at the given coordinate.","ref":"wxImage.html#getBlue/3"},{"type":"function","title":"wxImage.getData/1","doc":"Returns the image data as an array.\n\nThis is most often used when doing direct image manipulation. The return value points to\nan array of characters in RGBRGBRGB... format in the top-to-bottom, left-to-right order,\nthat is the first RGB triplet corresponds to the first pixel of the first row, the second\none - to the second pixel of the first row and so on until the end of the first row, with\nsecond row following after it and so on.\n\nYou should not delete the returned pointer nor pass it to `setData/4`.","ref":"wxImage.html#getData/1"},{"type":"function","title":"wxImage.getGreen/3","doc":"Returns the green intensity at the given coordinate.","ref":"wxImage.html#getGreen/3"},{"type":"function","title":"wxImage.getHeight/1","doc":"Gets the height of the image in pixels.\n\nSee: `getWidth/1`","ref":"wxImage.html#getHeight/1"},{"type":"function","title":"wxImage.getImageCount/1","doc":"Equivalent to  getImageCount(Filename, []) .","ref":"wxImage.html#getImageCount/1"},{"type":"function","title":"wxImage.getImageCount/2","doc":"If the image file contains more than one image and the image handler is capable of\nretrieving these individually, this function will return the number of available images.\n\nFor the overload taking the parameter `filename`, that's the name of the file to query.\nFor the overload taking the parameter `stream`, that's the opened input stream with image data.\n\nSee `wxImageHandler::GetImageCount()` (not implemented in wx) for more info.\n\nThe parameter `type` may be one of the following values:\n\n* wxBITMAP_TYPE_BMP: Load a Windows bitmap file.\n\n* wxBITMAP_TYPE_GIF: Load a GIF bitmap file.\n\n* wxBITMAP_TYPE_JPEG: Load a JPEG bitmap file.\n\n* wxBITMAP_TYPE_PNG: Load a PNG bitmap file.\n\n* wxBITMAP_TYPE_PCX: Load a PCX bitmap file.\n\n* wxBITMAP_TYPE_PNM: Load a PNM bitmap file.\n\n* wxBITMAP_TYPE_TIFF: Load a TIFF bitmap file.\n\n* wxBITMAP_TYPE_TGA: Load a TGA bitmap file.\n\n* wxBITMAP_TYPE_XPM: Load a XPM bitmap file.\n\n* wxBITMAP_TYPE_ICO: Load a Windows icon file (ICO).\n\n* wxBITMAP_TYPE_CUR: Load a Windows cursor file (CUR).\n\n* wxBITMAP_TYPE_ANI: Load a Windows animated cursor file (ANI).\n\n* wxBITMAP_TYPE_ANY: Will try to autodetect the format.\n\nReturn: Number of available images. For most image handlers, this is 1 (exceptions are\nTIFF and ICO formats as well as animated GIFs for which this function returns the number\nof frames in the animation).","ref":"wxImage.html#getImageCount/2"},{"type":"function","title":"wxImage.getImageExtWildcard/0","doc":"Iterates all registered `wxImageHandler` (not implemented in wx) objects, and returns a\nstring containing file extension masks suitable for passing to file open/save dialog\nboxes.\n\nReturn: The format of the returned string is `\"(*.ext1;*.ext2)|*.ext1;*.ext2\"`. It is\nusually a good idea to prepend a description before passing the result to the dialog.\nExample:","ref":"wxImage.html#getImageExtWildcard/0"},{"type":"function","title":"wxImage.getMaskBlue/1","doc":"Gets the blue value of the mask colour.","ref":"wxImage.html#getMaskBlue/1"},{"type":"function","title":"wxImage.getMaskGreen/1","doc":"Gets the green value of the mask colour.","ref":"wxImage.html#getMaskGreen/1"},{"type":"function","title":"wxImage.getMaskRed/1","doc":"Gets the red value of the mask colour.","ref":"wxImage.html#getMaskRed/1"},{"type":"function","title":"wxImage.getOption/2","doc":"Gets a user-defined string-valued option.\n\nGeneric options:\n\n* `wxIMAGE_OPTION_FILENAME:` The name of the file from which the image was loaded.\n\nOptions specific to `wxGIFHandler` (not implemented in wx):\n\n* `wxIMAGE_OPTION_GIF_COMMENT:` The comment text that is read from or written to the GIF\nfile. In an animated GIF each frame can have its own comment. If there is only a comment\nin the first frame of a GIF it will not be repeated in other frames.\n\nReturn: The value of the option or an empty string if not found. Use `hasOption/2` if an empty string\ncan be a valid option value.\n\nSee:\n* `setOption/3`\n\n* `getOptionInt/2`\n\n* `hasOption/2`","ref":"wxImage.html#getOption/2"},{"type":"function","title":"wxImage.getOptionInt/2","doc":"Gets a user-defined integer-valued option.\n\nThe function is case-insensitive to `name`. If the given option is not present, the\nfunction returns 0. Use `hasOption/2` if 0 is a possibly valid value for the option.\n\nGeneric options:\n\n* `wxIMAGE_OPTION_MAX_WIDTH` and `wxIMAGE_OPTION_MAX_HEIGHT:` If either of these options is\nspecified, the loaded image will be scaled down (preserving its aspect ratio) so that its\nwidth is less than the max width given if it is not 0 `and` its height is less than the\nmax height given if it is not 0. This is typically used for loading thumbnails and the\nadvantage of using these options compared to calling `rescale/4` after loading is that some handlers\n(only JPEG one right now) support rescaling the image during loading which is vastly more\nefficient than loading the entire huge image and rescaling it later (if these options are\nnot supported by the handler, this is still what happens however). These options must be\nset before calling `loadFile/4` to have any effect.\n\n* `wxIMAGE_OPTION_ORIGINAL_WIDTH` and `wxIMAGE_OPTION_ORIGINAL_HEIGHT:` These options will\nreturn the original size of the image if either `wxIMAGE_OPTION_MAX_WIDTH` or `wxIMAGE_OPTION_MAX_HEIGHT`\nis specified.\n\nSince: 2.9.3\n\n* `wxIMAGE_OPTION_QUALITY:` JPEG quality used when saving. This is an integer in 0..100\nrange with 0 meaning very poor and 100 excellent (but very badly compressed). This option\nis currently ignored for the other formats.\n\n* `wxIMAGE_OPTION_RESOLUTIONUNIT:` The value of this option determines whether the\nresolution of the image is specified in centimetres or inches, see wxImageResolution enum elements.\n\n* `wxIMAGE_OPTION_RESOLUTION`, `wxIMAGE_OPTION_RESOLUTIONX` and `wxIMAGE_OPTION_RESOLUTIONY:`\nThese options define the resolution of the image in the units corresponding to `wxIMAGE_OPTION_RESOLUTIONUNIT`\noptions value. The first option can be set before saving the image to set both horizontal\nand vertical resolution to the same value. The X and Y options are set by the image\nhandlers if they support the image resolution (currently BMP, JPEG and TIFF handlers do)\nand the image provides the resolution information and can be queried after loading the image.\n\nOptions specific to `wxPNGHandler` (not implemented in wx):\n\n* `wxIMAGE_OPTION_PNG_FORMAT:` Format for saving a PNG file, see wxImagePNGType for the\nsupported values.\n\n* `wxIMAGE_OPTION_PNG_BITDEPTH:` Bit depth for every channel (R/G/B/A).\n\n* `wxIMAGE_OPTION_PNG_FILTER:` Filter for saving a PNG file, see libpng ([http://www.libpng.org/pub/png/libpng-1.2.5-manual.html](http://www.libpng.org/pub/png/libpng-1.2.5-manual.html))\nfor possible values (e.g. PNG_FILTER_NONE, PNG_FILTER_SUB, PNG_FILTER_UP, etc).\n\n* `wxIMAGE_OPTION_PNG_COMPRESSION_LEVEL:` Compression level (0..9) for saving a PNG file.\nAn high value creates smaller-but-slower PNG file. Note that unlike other formats (e.g.\nJPEG) the PNG format is always lossless and thus this compression level doesn't tradeoff\nthe image quality.\n\n* `wxIMAGE_OPTION_PNG_COMPRESSION_MEM_LEVEL:` Compression memory usage level (1..9) for\nsaving a PNG file. An high value means the saving process consumes more memory, but may\ncreate smaller PNG file.\n\n* `wxIMAGE_OPTION_PNG_COMPRESSION_STRATEGY:` Possible values are 0 for default strategy, 1\nfor filter, and 2 for Huffman-only. You can use OptiPNG ([http://optipng.sourceforge.net/](http://optipng.sourceforge.net/))\nto get a suitable value for your application.\n\n* `wxIMAGE_OPTION_PNG_COMPRESSION_BUFFER_SIZE:` Internal buffer size (in bytes) for saving\na PNG file. Ideally this should be as big as the resulting PNG file. Use this option if\nyour application produces images with small size variation.\n\nOptions specific to `wxTIFFHandler` (not implemented in wx):\n\n* `wxIMAGE_OPTION_TIFF_BITSPERSAMPLE:` Number of bits per sample (channel). Currently\nvalues of 1 and 8 are supported. A value of 1 results in a black and white image. A value\nof 8 (the default) can mean greyscale or RGB, depending on the value of `wxIMAGE_OPTION_TIFF_SAMPLESPERPIXEL`.\n\n* `wxIMAGE_OPTION_TIFF_SAMPLESPERPIXEL:` Number of samples (channels) per pixel. Currently\nvalues of 1 and 3 are supported. A value of 1 results in either a greyscale (by default)\nor black and white image, depending on the value of `wxIMAGE_OPTION_TIFF_BITSPERSAMPLE`. A\nvalue of 3 (the default) will result in an RGB image.\n\n* `wxIMAGE_OPTION_TIFF_COMPRESSION:` Compression type. By default it is set to 1\n(COMPRESSION_NONE). Typical other values are 5 (COMPRESSION_LZW) and 7 (COMPRESSION_JPEG).\nSee tiff.h for more options.\n\n* `wxIMAGE_OPTION_TIFF_PHOTOMETRIC:` Specifies the photometric interpretation. By default\nit is set to 2 (PHOTOMETRIC_RGB) for RGB images and 0 (PHOTOMETRIC_MINISWHITE) for\ngreyscale or black and white images. It can also be set to 1 (PHOTOMETRIC_MINISBLACK) to\ntreat the lowest value as black and highest as white. If you want a greyscale image it is\nalso sufficient to only specify `wxIMAGE_OPTION_TIFF_PHOTOMETRIC` and set it to either\nPHOTOMETRIC_MINISWHITE or PHOTOMETRIC_MINISBLACK. The other values are taken care of.\n\nOptions specific to `wxGIFHandler` (not implemented in wx):\n\n* `wxIMAGE_OPTION_GIF_TRANSPARENCY:` How to deal with transparent pixels. By default, the\ncolor of transparent pixels is changed to bright pink, so that if the image is\naccidentally drawn without transparency, it will be obvious. Normally, this would not be\nnoticed, as these pixels will not be rendered. But in some cases it might be useful to\nload a GIF without making any modifications to its colours. Use `wxIMAGE_OPTION_GIF_TRANSPARENCY_UNCHANGED`\nto keep the colors correct. Use `wxIMAGE_OPTION_GIF_TRANSPARENCY_HIGHLIGHT` to convert\ntransparent pixels to pink (default). This option has been added in wxWidgets 3.1.1.\n\nNote: Be careful when combining the options `wxIMAGE_OPTION_TIFF_SAMPLESPERPIXEL`, `wxIMAGE_OPTION_TIFF_BITSPERSAMPLE`,\nand `wxIMAGE_OPTION_TIFF_PHOTOMETRIC`. While some measures are taken to prevent illegal\ncombinations and/or values, it is still easy to abuse them and come up with invalid\nresults in the form of either corrupted images or crashes.\n\nReturn: The value of the option or 0 if not found. Use `hasOption/2` if 0 can be a valid option value.\n\nSee:\n* `setOption/3`\n\n* `getOption/2`","ref":"wxImage.html#getOptionInt/2"},{"type":"function","title":"wxImage.getOrFindMaskColour/1","doc":"Get the current mask colour or find a suitable unused colour that could be used as a mask\ncolour.\n\nReturns true if the image currently has a mask.","ref":"wxImage.html#getOrFindMaskColour/1"},{"type":"function","title":"wxImage.getPalette/1","doc":"Returns the palette associated with the image.\n\nCurrently the palette is only used when converting to `m:wxBitmap` under Windows.\n\nSome of the `m:wxImage` handlers have been modified to set the palette if one exists in\nthe image file (usually 256 or less colour images in GIF or PNG format).","ref":"wxImage.html#getPalette/1"},{"type":"function","title":"wxImage.getRed/3","doc":"Returns the red intensity at the given coordinate.","ref":"wxImage.html#getRed/3"},{"type":"function","title":"wxImage.getSubImage/2","doc":"Returns a sub image of the current one as long as the rect belongs entirely to the image.","ref":"wxImage.html#getSubImage/2"},{"type":"function","title":"wxImage.getWidth/1","doc":"Gets the width of the image in pixels.\n\nSee: `getHeight/1`","ref":"wxImage.html#getWidth/1"},{"type":"function","title":"wxImage.hasAlpha/1","doc":"Returns true if this image has alpha channel, false otherwise.\n\nSee:\n* `getAlpha/3`\n\n* `setAlpha/4`","ref":"wxImage.html#hasAlpha/1"},{"type":"function","title":"wxImage.hasMask/1","doc":"Returns true if there is a mask active, false otherwise.","ref":"wxImage.html#hasMask/1"},{"type":"function","title":"wxImage.hasOption/2","doc":"Returns true if the given option is present.\n\nThe function is case-insensitive to `name`.\n\nThe lists of the currently supported options are in `getOption/2` and `getOptionInt/2` function docs.\n\nSee:\n* `setOption/3`\n\n* `getOption/2`\n\n* `getOptionInt/2`","ref":"wxImage.html#hasOption/2"},{"type":"function","title":"wxImage.initAlpha/1","doc":"Initializes the image alpha channel data.\n\nIt is an error to call it if the image already has alpha data. If it doesn't, alpha data\nwill be by default initialized to all pixels being fully opaque. But if the image has a\nmask colour, all mask pixels will be completely transparent.","ref":"wxImage.html#initAlpha/1"},{"type":"function","title":"wxImage.initStandardHandlers/0","doc":"Internal use only.\n\nAdds standard image format handlers. It only install wxBMPHandler for the time being,\nwhich is used by `m:wxBitmap`.\n\nThis function is called by wxWidgets on startup, and shouldn't be called by the user.\n\nSee: ?wxInitAllImageHandlers()","ref":"wxImage.html#initStandardHandlers/0"},{"type":"function","title":"wxImage.isOk/1","doc":"Returns true if image data is present.","ref":"wxImage.html#isOk/1"},{"type":"function","title":"wxImage.isTransparent/3","doc":"Equivalent to  isTransparent(This, X, Y, []) .","ref":"wxImage.html#isTransparent/3"},{"type":"function","title":"wxImage.isTransparent/4","doc":"Returns true if the given pixel is transparent, i.e. either has the mask colour if this\nimage has a mask or if this image has alpha channel and alpha value of this pixel is\nstrictly less than `threshold`.","ref":"wxImage.html#isTransparent/4"},{"type":"function","title":"wxImage.loadFile/2","doc":"Equivalent to  loadFile(This, Name, []) .","ref":"wxImage.html#loadFile/2"},{"type":"function","title":"wxImage.loadFile/3","doc":"Loads an image from a file.\n\nIf no handler type is provided, the library will try to autodetect the format.","ref":"wxImage.html#loadFile/3"},{"type":"function","title":"wxImage.loadFile/4","doc":"Loads an image from a file.\n\nIf no handler type is provided, the library will try to autodetect the format.","ref":"wxImage.html#loadFile/4"},{"type":"function","title":"wxImage.mirror/1","doc":"Equivalent to  mirror(This, []) .","ref":"wxImage.html#mirror/1"},{"type":"function","title":"wxImage.mirror/2","doc":"Returns a mirrored copy of the image.\n\nThe parameter `horizontally` indicates the orientation.","ref":"wxImage.html#mirror/2"},{"type":"function","title":"wxImage.new/0","doc":"Creates an empty `m:wxImage` object without an alpha channel.","ref":"wxImage.html#new/0"},{"type":"function","title":"wxImage.new/1","doc":"Equivalent to: `new/2`","ref":"wxImage.html#new/1"},{"type":"function","title":"wxImage.new/2","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxImage.html#new/2"},{"type":"function","title":"wxImage.new/3","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxImage.html#new/3"},{"type":"function","title":"wxImage.new/4","doc":"Creates an image from data in memory.\n\nIf `static_data` is false then the `m:wxImage` will take ownership of the data and free\nit afterwards. For this, it has to be allocated with `malloc`.","ref":"wxImage.html#new/4"},{"type":"function","title":"wxImage.ok/1","doc":"Equivalent to: `isOk/1`","ref":"wxImage.html#ok/1"},{"type":"function","title":"wxImage.removeHandler/1","doc":"Finds the handler with the given name, and removes it.\n\nThe handler is also deleted.\n\nReturn: true if the handler was found and removed, false otherwise.","ref":"wxImage.html#removeHandler/1"},{"type":"function","title":"wxImage.replace/7","doc":"Replaces the colour specified by `r1`,g1,b1 by the colour `r2`,g2,b2.","ref":"wxImage.html#replace/7"},{"type":"function","title":"wxImage.rescale/3","doc":"Equivalent to  rescale(This, Width, Height, []) .","ref":"wxImage.html#rescale/3"},{"type":"function","title":"wxImage.rescale/4","doc":"Changes the size of the image in-place by scaling it: after a call to this function,the\nimage will have the given width and height.\n\nFor a description of the `quality` parameter, see the `scale/4` function. Returns the (modified)\nimage itself.\n\nSee: `scale/4`","ref":"wxImage.html#rescale/4"},{"type":"function","title":"wxImage.resize/3","doc":"Equivalent to  resize(This, Size, Pos, []) .","ref":"wxImage.html#resize/3"},{"type":"function","title":"wxImage.resize/4","doc":"Changes the size of the image in-place without scaling it by adding either a border with\nthe given colour or cropping as necessary.\n\nThe image is pasted into a new image with the given `size` and background colour at the\nposition `pos` relative to the upper left of the new image.\n\nIf `red` = green = blue = -1 then use either the current mask colour if set or find, use,\nand set a suitable mask colour for any newly exposed areas.\n\nReturn: The (modified) image itself.\n\nSee: `size/4`","ref":"wxImage.html#resize/4"},{"type":"function","title":"wxImage.rotate90/1","doc":"Equivalent to  rotate90(This, []) .","ref":"wxImage.html#rotate90/1"},{"type":"function","title":"wxImage.rotate90/2","doc":"Returns a copy of the image rotated 90 degrees in the direction indicated by `clockwise`.","ref":"wxImage.html#rotate90/2"},{"type":"function","title":"wxImage.rotate/3","doc":"Equivalent to  rotate(This, Angle, RotationCentre, []) .","ref":"wxImage.html#rotate/3"},{"type":"function","title":"wxImage.rotate/4","doc":"Rotates the image about the given point, by `angle` radians.\n\nPassing true to `interpolating` results in better image quality, but is slower.\n\nIf the image has a mask, then the mask colour is used for the uncovered pixels in the\nrotated image background. Else, black (rgb 0, 0, 0) will be used.\n\nReturns the rotated image, leaving this image intact.","ref":"wxImage.html#rotate/4"},{"type":"function","title":"wxImage.rotateHue/2","doc":"Rotates the hue of each pixel in the image by `angle`, which is a double in the range of\n-1.0 to +1.0, where -1.0 corresponds to -360 degrees and +1.0 corresponds to +360 degrees.","ref":"wxImage.html#rotateHue/2"},{"type":"function","title":"wxImage.saveFile/2","doc":"Saves an image in the named file.\n\nFile type is determined from the extension of the file name. Note that this function may\nfail if the extension is not recognized! You can use one of the forms above to save images\nto files with non-standard extensions.","ref":"wxImage.html#saveFile/2"},{"type":"function","title":"wxImage.saveFile/3","doc":"Saves an image in the named file.","ref":"wxImage.html#saveFile/3"},{"type":"function","title":"wxImage.scale/3","doc":"Equivalent to  scale(This, Width, Height, []) .","ref":"wxImage.html#scale/3"},{"type":"function","title":"wxImage.scale/4","doc":"Returns a scaled version of the image.\n\nThis is also useful for scaling bitmaps in general as the only other way to scale bitmaps\nis to blit a `m:wxMemoryDC` into another `m:wxMemoryDC`.\n\nThe parameter `quality` determines what method to use for resampling the image, see\nwxImageResizeQuality documentation.\n\nIt should be noted that although using `wxIMAGE_QUALITY_HIGH` produces much nicer looking\nresults it is a slower method. Downsampling will use the box averaging method which seems\nto operate very fast. If you are upsampling larger images using this method you will most\nlikely notice that it is a bit slower and in extreme cases it will be quite substantially\nslower as the bicubic algorithm has to process a lot of data.\n\nIt should also be noted that the high quality scaling may not work as expected when using\na single mask colour for transparency, as the scaling will blur the image and will\ntherefore remove the mask partially. Using the alpha channel will work.\n\nExample:\n\nSee: `rescale/4`","ref":"wxImage.html#scale/4"},{"type":"function","title":"wxImage.setAlpha/2","doc":"This function is similar to `setData/4` and has similar restrictions.\n\nThe pointer passed to it may however be NULL in which case the function will allocate the\nalpha array internally - this is useful to add alpha channel data to an image which\ndoesn't have any.\n\nIf the pointer is not NULL, it must have one byte for each image pixel and be allocated\nwith malloc(). `m:wxImage` takes ownership of the pointer and will free it unless `static_data`\nparameter is set to true - in this case the caller should do it.","ref":"wxImage.html#setAlpha/2"},{"type":"function","title":"wxImage.setAlpha/4","doc":"Sets the alpha value for the given pixel.\n\nThis function should only be called if the image has alpha channel data, use `hasAlpha/1` to check\nfor this.","ref":"wxImage.html#setAlpha/4"},{"type":"function","title":"wxImage.setData/2","doc":"Sets the image data without performing checks.\n\nThe data given must have the size (width*height*3) or results will be unexpected. Don't\nuse this method if you aren't sure you know what you are doing.\n\nThe data must have been allocated with `malloc()`, `NOT` with `operator` new.\n\nIf `static_data` is false, after this call the pointer to the data is owned by the `m:wxImage`\nobject, that will be responsible for deleting it. Do not pass to this function a pointer\nobtained through `getData/1`.","ref":"wxImage.html#setData/2"},{"type":"function","title":"wxImage.setData/4","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxImage.html#setData/4"},{"type":"function","title":"wxImage.setMask/1","doc":"Equivalent to  setMask(This, []) .","ref":"wxImage.html#setMask/1"},{"type":"function","title":"wxImage.setMask/2","doc":"Specifies whether there is a mask or not.\n\nThe area of the mask is determined by the current mask colour.","ref":"wxImage.html#setMask/2"},{"type":"function","title":"wxImage.setMaskColour/4","doc":"Sets the mask colour for this image (and tells the image to use the mask).","ref":"wxImage.html#setMaskColour/4"},{"type":"function","title":"wxImage.setMaskFromImage/5","doc":"Sets image's mask so that the pixels that have RGB value of mr,mg,mb in mask will be\nmasked in the image.\n\nThis is done by first finding an unused colour in the image, setting this colour as the\nmask colour and then using this colour to draw all pixels in the image who corresponding\npixel in mask has given RGB value.\n\nThe parameter `mask` is the mask image to extract mask shape from. It must have the same\ndimensions as the image.\n\nThe parameters `mr`, `mg`, `mb` are the RGB values of the pixels in mask that will be\nused to create the mask.\n\nReturn: Returns false if mask does not have same dimensions as the image or if there is\nno unused colour left. Returns true if the mask was successfully applied.\n\nNote: Note that this method involves computing the histogram, which is a computationally\nintensive operation.","ref":"wxImage.html#setMaskFromImage/5"},{"type":"function","title":"wxImage.setOption/3","doc":"Sets a user-defined option.\n\nThe function is case-insensitive to `name`.\n\nFor example, when saving as a JPEG file, the option `quality` is used, which is a number\nbetween 0 and 100 (0 is terrible, 100 is very good).\n\nThe lists of the currently supported options are in `getOption/2` and `getOptionInt/2` function docs.\n\nSee:\n* `getOption/2`\n\n* `getOptionInt/2`\n\n* `hasOption/2`","ref":"wxImage.html#setOption/3"},{"type":"function","title":"wxImage.setPalette/2","doc":"Associates a palette with the image.\n\nThe palette may be used when converting `m:wxImage` to `m:wxBitmap` (MSW only at present)\nor in file save operations (none as yet).","ref":"wxImage.html#setPalette/2"},{"type":"function","title":"wxImage.setRGB/5","doc":"Sets the colour of the pixels within the given rectangle.\n\nThis routine performs bounds-checks for the coordinate so it can be considered a safe way\nto manipulate the data.","ref":"wxImage.html#setRGB/5"},{"type":"function","title":"wxImage.setRGB/6","doc":"Set the color of the pixel at the given x and y coordinate.","ref":"wxImage.html#setRGB/6"},{"type":"function","title":"wxImage.size/3","doc":"Equivalent to  size(This, Size, Pos, []) .","ref":"wxImage.html#size/3"},{"type":"function","title":"wxImage.size/4","doc":"Returns a resized version of this image without scaling it by adding either a border with\nthe given colour or cropping as necessary.\n\nThe image is pasted into a new image with the given `size` and background colour at the\nposition `pos` relative to the upper left of the new image.\n\nIf `red` = green = blue = -1 then the areas of the larger image not covered by this image\nare made transparent by filling them with the image mask colour (which will be allocated\nautomatically if it isn't currently set).\n\nOtherwise, the areas will be filled with the colour with the specified RGB components.\n\nSee: `resize/4`","ref":"wxImage.html#size/4"},{"type":"type","title":"wxImage.wxImage/0","doc":"","ref":"wxImage.html#t:wxImage/0"},{"type":"module","title":"wxImageList","doc":"A `m:wxImageList` contains a list of images, which are stored in an unspecified form.\n\nImages can have masks for transparent drawing, and can be made from a variety of sources\nincluding bitmaps and icons.\n\n`m:wxImageList` is used principally in conjunction with `m:wxTreeCtrl` and `m:wxListCtrl` classes.\n\nSee:\n* `m:wxTreeCtrl`\n\n* `m:wxListCtrl`\n\nwxWidgets docs: [wxImageList](https://docs.wxwidgets.org/3.2/classwx_image_list.html)","ref":"wxImageList.html"},{"type":"function","title":"wxImageList.add/2","doc":"Adds a new image using an icon.\n\nReturn: The new zero-based image index.\n\nRemark: The original bitmap or icon is not affected by the `add/3` operation, and can be deleted\nafterwards. If the bitmap is wider than the images in the list, then the bitmap will\nautomatically be split into smaller images, each matching the dimensions of the image\nlist. This does not apply when adding icons.\n\nOnly for:wxmsw,wxosx","ref":"wxImageList.html#add/2"},{"type":"function","title":"wxImageList.add/3","doc":"Adds a new image or images using a bitmap and mask colour.\n\nReturn: The new zero-based image index.\n\nRemark: The original bitmap or icon is not affected by the `add/3` operation, and can be deleted\nafterwards. If the bitmap is wider than the images in the list, then the bitmap will\nautomatically be split into smaller images, each matching the dimensions of the image\nlist. This does not apply when adding icons.","ref":"wxImageList.html#add/3"},{"type":"function","title":"wxImageList.create/3","doc":"Equivalent to  create(This, Width, Height, []) .","ref":"wxImageList.html#create/3"},{"type":"function","title":"wxImageList.create/4","doc":"Initializes the list.\n\nSee `new/3` for details.","ref":"wxImageList.html#create/4"},{"type":"function","title":"wxImageList.destroy/1","doc":"Destroys the object","ref":"wxImageList.html#destroy/1"},{"type":"function","title":"wxImageList.draw/5","doc":"Equivalent to  draw(This, Index, Dc, X, Y, []) .","ref":"wxImageList.html#draw/5"},{"type":"function","title":"wxImageList.draw/6","doc":"Draws a specified image onto a device context.","ref":"wxImageList.html#draw/6"},{"type":"function","title":"wxImageList.getBitmap/2","doc":"Returns the bitmap corresponding to the given index.","ref":"wxImageList.html#getBitmap/2"},{"type":"function","title":"wxImageList.getIcon/2","doc":"Returns the icon corresponding to the given index.","ref":"wxImageList.html#getIcon/2"},{"type":"function","title":"wxImageList.getImageCount/1","doc":"Returns the number of images in the list.","ref":"wxImageList.html#getImageCount/1"},{"type":"function","title":"wxImageList.getSize/2","doc":"Retrieves the size of the images in the list.\n\nCurrently, the `index` parameter is ignored as all images in the list have the same size.\n\nReturn: true if the function succeeded, false if it failed (for example, if the image\nlist was not yet initialized).","ref":"wxImageList.html#getSize/2"},{"type":"function","title":"wxImageList.new/0","doc":"Default ctor.","ref":"wxImageList.html#new/0"},{"type":"function","title":"wxImageList.new/2","doc":"Equivalent to  new(Width, Height, []) .","ref":"wxImageList.html#new/2"},{"type":"function","title":"wxImageList.new/3","doc":"Constructor specifying the image size, whether image masks should be created, and the\ninitial size of the list.\n\nSee: `create/4`","ref":"wxImageList.html#new/3"},{"type":"function","title":"wxImageList.remove/2","doc":"Removes the image at the given position.","ref":"wxImageList.html#remove/2"},{"type":"function","title":"wxImageList.removeAll/1","doc":"Removes all the images in the list.","ref":"wxImageList.html#removeAll/1"},{"type":"function","title":"wxImageList.replace/3","doc":"Replaces the existing image with the new image.\n\nReturn: true if the replacement was successful, false otherwise.\n\nRemark: The original bitmap or icon is not affected by the `replace/4` operation, and can be deleted afterwards.\n\nOnly for:wxmsw,wxosx","ref":"wxImageList.html#replace/3"},{"type":"function","title":"wxImageList.replace/4","doc":"Replaces the existing image with the new image.\n\nWindows only.\n\nReturn: true if the replacement was successful, false otherwise.\n\nRemark: The original bitmap or icon is not affected by the `replace/4` operation, and can be deleted\nafterwards.","ref":"wxImageList.html#replace/4"},{"type":"type","title":"wxImageList.wxImageList/0","doc":"","ref":"wxImageList.html#t:wxImageList/0"},{"type":"module","title":"wxInitDialogEvent","doc":"A `m:wxInitDialogEvent` is sent as a dialog or panel is being initialised.\n\nHandlers for this event can transfer data to the window.\n\nThe default handler calls `wxWindow:transferDataToWindow/1`.\n\nSee: [Overview events](https://docs.wxwidgets.org/3.2/overview_events.html#overview_events)\n\nThis class is derived, and can use functions, from:\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxInitDialogEvent](https://docs.wxwidgets.org/3.2/classwx_init_dialog_event.html)","ref":"wxInitDialogEvent.html"},{"type":"module","title":"Events - wxInitDialogEvent","doc":"Use `wxEvtHandler:connect/3` with `wxInitDialogEventType` to subscribe to events of this type.","ref":"wxInitDialogEvent.html#module-events"},{"type":"type","title":"wxInitDialogEvent.wxInitDialog/0","doc":"","ref":"wxInitDialogEvent.html#t:wxInitDialog/0"},{"type":"type","title":"wxInitDialogEvent.wxInitDialogEvent/0","doc":"","ref":"wxInitDialogEvent.html#t:wxInitDialogEvent/0"},{"type":"type","title":"wxInitDialogEvent.wxInitDialogEventType/0","doc":"","ref":"wxInitDialogEvent.html#t:wxInitDialogEventType/0"},{"type":"module","title":"wxJoystickEvent","doc":"This event class contains information about joystick events, particularly events received\nby windows.\n\nThis class is derived, and can use functions, from:\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxJoystickEvent](https://docs.wxwidgets.org/3.2/classwx_joystick_event.html)","ref":"wxJoystickEvent.html"},{"type":"module","title":"Events - wxJoystickEvent","doc":"Use `wxEvtHandler:connect/3` with `wxJoystickEventType` to subscribe to events of this type.","ref":"wxJoystickEvent.html#module-events"},{"type":"function","title":"wxJoystickEvent.buttonDown/1","doc":"Equivalent to  buttonDown(This, []) .","ref":"wxJoystickEvent.html#buttonDown/1"},{"type":"function","title":"wxJoystickEvent.buttonDown/2","doc":"Returns true if the event was a down event from the specified button (or any button).","ref":"wxJoystickEvent.html#buttonDown/2"},{"type":"function","title":"wxJoystickEvent.buttonIsDown/1","doc":"Equivalent to  buttonIsDown(This, []) .","ref":"wxJoystickEvent.html#buttonIsDown/1"},{"type":"function","title":"wxJoystickEvent.buttonIsDown/2","doc":"Returns true if the specified button (or any button) was in a down state.","ref":"wxJoystickEvent.html#buttonIsDown/2"},{"type":"function","title":"wxJoystickEvent.buttonUp/1","doc":"Equivalent to  buttonUp(This, []) .","ref":"wxJoystickEvent.html#buttonUp/1"},{"type":"function","title":"wxJoystickEvent.buttonUp/2","doc":"Returns true if the event was an up event from the specified button (or any button).","ref":"wxJoystickEvent.html#buttonUp/2"},{"type":"function","title":"wxJoystickEvent.getButtonChange/1","doc":"Returns the identifier of the button changing state.\n\nThe return value is where `n` is the index of the button changing state, which can also\nbe retrieved using `GetButtonOrdinal()` (not implemented in wx).\n\nNote that for `n` equal to 1, 2, 3 or 4 there are predefined `wxJOY_BUTTONn` constants\nwhich can be used for more clarity, however these constants are not defined for the\nbuttons beyond the first four.","ref":"wxJoystickEvent.html#getButtonChange/1"},{"type":"function","title":"wxJoystickEvent.getButtonState/1","doc":"Returns the down state of the buttons.\n\nThis is a `wxJOY_BUTTONn` identifier, where `n` is one of 1, 2, 3, 4.","ref":"wxJoystickEvent.html#getButtonState/1"},{"type":"function","title":"wxJoystickEvent.getJoystick/1","doc":"Returns the identifier of the joystick generating the event - one of wxJOYSTICK1 and\nwxJOYSTICK2.","ref":"wxJoystickEvent.html#getJoystick/1"},{"type":"function","title":"wxJoystickEvent.getPosition/1","doc":"Returns the x, y position of the joystick event.\n\nThese coordinates are valid for all the events except wxEVT_JOY_ZMOVE.","ref":"wxJoystickEvent.html#getPosition/1"},{"type":"function","title":"wxJoystickEvent.getZPosition/1","doc":"Returns the z position of the joystick event.\n\nThis method can only be used for wxEVT_JOY_ZMOVE events.","ref":"wxJoystickEvent.html#getZPosition/1"},{"type":"function","title":"wxJoystickEvent.isButton/1","doc":"Returns true if this was a button up or down event (`not` 'is any button down?').","ref":"wxJoystickEvent.html#isButton/1"},{"type":"function","title":"wxJoystickEvent.isMove/1","doc":"Returns true if this was an x, y move event.","ref":"wxJoystickEvent.html#isMove/1"},{"type":"function","title":"wxJoystickEvent.isZMove/1","doc":"Returns true if this was a z move event.","ref":"wxJoystickEvent.html#isZMove/1"},{"type":"type","title":"wxJoystickEvent.wxJoystick/0","doc":"","ref":"wxJoystickEvent.html#t:wxJoystick/0"},{"type":"type","title":"wxJoystickEvent.wxJoystickEvent/0","doc":"","ref":"wxJoystickEvent.html#t:wxJoystickEvent/0"},{"type":"type","title":"wxJoystickEvent.wxJoystickEventType/0","doc":"","ref":"wxJoystickEvent.html#t:wxJoystickEventType/0"},{"type":"module","title":"wxKeyEvent","doc":"This event class contains information about key press and release events.\n\nThe main information carried by this event is the key being pressed or released. It can\nbe accessed using either `getKeyCode/1` function or `getUnicodeKey/1`. For the printable characters, the latter should be\nused as it works for any keys, including non-Latin-1 characters that can be entered when\nusing national keyboard layouts. `getKeyCode/1` should be used to handle special characters (such as\ncursor arrows keys or `HOME` or `INS` and so on) which correspond to ?wxKeyCode enum\nelements above the `WXK_START` constant. While `getKeyCode/1` also returns the character code for\nLatin-1 keys for compatibility, it doesn't work for Unicode characters in general and will\nreturn `WXK_NONE` for any non-Latin-1 ones. For this reason, it's recommended to always\nuse `getUnicodeKey/1` and only fall back to `getKeyCode/1` if `getUnicodeKey/1` returned `WXK_NONE` meaning that the event corresponds to\na non-printable special keys.\n\nWhile both of these functions can be used with the events of `wxEVT_KEY_DOWN`, `wxEVT_KEY_UP`\nand `wxEVT_CHAR` types, the values returned by them are different for the first two\nevents and the last one. For the latter, the key returned corresponds to the character\nthat would appear in e.g. a text zone if the user pressed the key in it. As such, its\nvalue depends on the current state of the Shift key and, for the letters, on the state of\nCaps Lock modifier. For example, if `A` key is pressed without Shift being held down, `m:wxKeyEvent`\nof type `wxEVT_CHAR` generated for this key press will return (from either `getKeyCode/1` or `getUnicodeKey/1` as their\nmeanings coincide for ASCII characters) key code of 97 corresponding the ASCII value of `a`.\nAnd if the same key is pressed but with Shift being held (or Caps Lock being active), then\nthe key could would be 65, i.e. ASCII value of capital `A`.\n\nHowever for the key down and up events the returned key code will instead be `A`\nindependently of the state of the modifier keys i.e. it depends only on physical key being\npressed and is not translated to its logical representation using the current keyboard\nstate. Such untranslated key codes are defined as follows:\n\n* For the letters they correspond to the `upper` case value of the letter.\n\n* For the other alphanumeric keys (e.g. `7` or `+`), the untranslated key code corresponds to\nthe character produced by the key when it is pressed without Shift. E.g. in standard US\nkeyboard layout the untranslated key code for the key `=/+` in the upper right corner of\nthe keyboard is 61 which is the ASCII value of `=`.\n\n* For the rest of the keys (i.e. special non-printable keys) it is the same as the normal\nkey code as no translation is used anyhow.\n\nNotice that the first rule applies to all Unicode letters, not just the usual Latin-1\nones. However for non-Latin-1 letters only `getUnicodeKey/1` can be used to retrieve the key code as `getKeyCode/1` just\nreturns `WXK_NONE` in this case.\n\nTo summarize: you should handle `wxEVT_CHAR` if you need the translated key and `wxEVT_KEY_DOWN`\nif you only need the value of the key itself, independent of the current keyboard state.\n\nNote: Not all key down events may be generated by the user. As an example, `wxEVT_KEY_DOWN`\nwith `=` key code can be generated using the standard US keyboard layout but not using\nthe German one because the `=` key corresponds to Shift-0 key combination in this layout\nand the key code for it is `0`, not `=`. Because of this you should avoid requiring your\nusers to type key events that might be impossible to enter on their keyboard.\n\nAnother difference between key and char events is that another kind of translation is\ndone for the latter ones when the Control key is pressed: char events for ASCII letters in\nthis case carry codes corresponding to the ASCII value of Ctrl-Latter, i.e. 1 for Ctrl-A,\n2 for Ctrl-B and so on until 26 for Ctrl-Z. This is convenient for terminal-like\napplications and can be completely ignored by all the other ones (if you need to handle\nCtrl-A it is probably a better idea to use the key event rather than the char one). Notice\nthat currently no translation is done for the presses of [, `\\`, ], `^` and `_` keys which\nmight be mapped to ASCII values from 27 to 31. Since version 2.9.2, the enum values `WXK_CONTROL_A`\n- `WXK_CONTROL_Z` can be used instead of the non-descriptive constant values 1-26.\n\nFinally, modifier keys only generate key events but no char events at all. The modifiers\nkeys are `WXK_SHIFT`, `WXK_CONTROL`, `WXK_ALT` and various `WXK_WINDOWS_XXX` from\n?wxKeyCode enum.\n\nModifier keys events are special in one additional aspect: usually the keyboard state\nassociated with a key press is well defined, e.g. `shiftDown/1` returns `true` only if the Shift key\nwas held pressed when the key that generated this event itself was pressed. There is an\nambiguity for the key press events for Shift key itself however. By convention, it is\nconsidered to be already pressed when it is pressed and already released when it is\nreleased. In other words, `wxEVT_KEY_DOWN` event for the Shift key itself will have `wxMOD_SHIFT`\nin `getModifiers/1` and `shiftDown/1` will return true while the `wxEVT_KEY_UP` event for Shift itself will not have `wxMOD_SHIFT`\nin its modifiers and `shiftDown/1` will return false.\n\n`Tip:` You may discover the key codes and modifiers generated by all the keys on your\nsystem interactively by running the page_samples_keyboard wxWidgets sample and pressing\nsome keys in it.\n\nNote: If a key down (`EVT_KEY_DOWN`) event is caught and the event handler does not call `event.Skip()`\nthen the corresponding char event (`EVT_CHAR`) will not happen. This is by design and\nenables the programs that handle both types of events to avoid processing the same key\ntwice. As a consequence, if you do not want to suppress the `wxEVT_CHAR` events for the\nkeys you handle, always call `event.Skip()` in your `wxEVT_KEY_DOWN` handler. Not doing\nmay also prevent accelerators defined using this key from working.\n\nNote: If a key is maintained in a pressed state, you will typically get a lot of\n(automatically generated) key down events but only one key up one at the end when the key\nis released so it is wrong to assume that there is one up event corresponding to each down one.\n\nNote: For Windows programmers: The key and char events in wxWidgets are similar to but\nslightly different from Windows `WM_KEYDOWN` and `WM_CHAR` events. In particular, Alt-x\ncombination will generate a char event in wxWidgets (unless it is used as an accelerator)\nand almost all keys, including ones without ASCII equivalents, generate char events too.\n\nThis class is derived, and can use functions, from:\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxKeyEvent](https://docs.wxwidgets.org/3.2/classwx_key_event.html)","ref":"wxKeyEvent.html"},{"type":"module","title":"Events - wxKeyEvent","doc":"Use `wxEvtHandler:connect/3` with `wxKeyEventType` to subscribe to events of this type.","ref":"wxKeyEvent.html#module-events"},{"type":"function","title":"wxKeyEvent.altDown/1","doc":"Returns true if the Alt key is pressed.\n\nNotice that `getModifiers/1` should usually be used instead of this one.","ref":"wxKeyEvent.html#altDown/1"},{"type":"function","title":"wxKeyEvent.cmdDown/1","doc":"Returns true if the key used for command accelerators is pressed.\n\nSame as `controlDown/1`. Deprecated.\n\nNotice that `getModifiers/1` should usually be used instead of this one.","ref":"wxKeyEvent.html#cmdDown/1"},{"type":"function","title":"wxKeyEvent.controlDown/1","doc":"Returns true if the Control key or Apple/Command key under macOS is pressed.\n\nThis function doesn't distinguish between right and left control keys.\n\nNotice that `getModifiers/1` should usually be used instead of this one.","ref":"wxKeyEvent.html#controlDown/1"},{"type":"function","title":"wxKeyEvent.getKeyCode/1","doc":"Returns the key code of the key that generated this event.\n\nASCII symbols return normal ASCII values, while events from special keys such as \"left\ncursor arrow\" (`WXK_LEFT`) return values outside of the ASCII range. See ?wxKeyCode for a\nfull list of the virtual key codes.\n\nNote that this method returns a meaningful value only for special non-alphanumeric keys\nor if the user entered a Latin-1 character (this includes ASCII and the accented letters\nfound in Western European languages but not letters of other alphabets such as e.g.\nCyrillic). Otherwise it simply method returns `WXK_NONE` and `getUnicodeKey/1` should be used to obtain the\ncorresponding Unicode character.\n\nUsing `getUnicodeKey/1` is in general the right thing to do if you are interested in the characters typed\nby the user, `getKeyCode/1` should be only used for special keys (for which `getUnicodeKey/1` returns `WXK_NONE`). To\nhandle both kinds of keys you might write:","ref":"wxKeyEvent.html#getKeyCode/1"},{"type":"function","title":"wxKeyEvent.getModifiers/1","doc":"Return the bit mask of all pressed modifier keys.\n\nThe return value is a combination of `wxMOD_ALT`, `wxMOD_CONTROL`, `wxMOD_SHIFT` and `wxMOD_META`\nbit masks. Additionally, `wxMOD_NONE` is defined as 0, i.e. corresponds to no modifiers\n(see `HasAnyModifiers()` (not implemented in wx)) and `wxMOD_CMD` is either `wxMOD_CONTROL`\n(MSW and Unix) or `wxMOD_META` (Mac), see `cmdDown/1`. See ?wxKeyModifier for the full list of modifiers.\n\nNotice that this function is easier to use correctly than, for example, `controlDown/1` because when\nusing the latter you also have to remember to test that none of the other modifiers is pressed:\n\nand forgetting to do it can result in serious program bugs (e.g. program not working with\nEuropean keyboard layout where `AltGr` key which is seen by the program as combination of\nCTRL and ALT is used). On the other hand, you can simply write:\n\nwith this function.","ref":"wxKeyEvent.html#getModifiers/1"},{"type":"function","title":"wxKeyEvent.getPosition/1","doc":"Obtains the position (in client coordinates) at which the key was pressed.\n\nNotice that under most platforms this position is simply the current mouse pointer\nposition and has no special relationship to the key event itself.\n\n`x` and `y` may be NULL if the corresponding coordinate is not needed.","ref":"wxKeyEvent.html#getPosition/1"},{"type":"function","title":"wxKeyEvent.getRawKeyCode/1","doc":"Returns the raw key code for this event.\n\nThe flags are platform-dependent and should only be used if the functionality provided by\nother `m:wxKeyEvent` methods is insufficient.\n\nUnder MSW, the raw key code is the value of `wParam` parameter of the corresponding message.\n\nUnder GTK, the raw key code is the `keyval` field of the corresponding GDK event.\n\nUnder macOS, the raw key code is the `keyCode` field of the corresponding NSEvent.\n\nNote: Currently the raw key codes are not supported by all ports, use #ifdef\nwxHAS_RAW_KEY_CODES to determine if this feature is available.","ref":"wxKeyEvent.html#getRawKeyCode/1"},{"type":"function","title":"wxKeyEvent.getRawKeyFlags/1","doc":"Returns the low level key flags for this event.\n\nThe flags are platform-dependent and should only be used if the functionality provided by\nother `m:wxKeyEvent` methods is insufficient.\n\nUnder MSW, the raw flags are just the value of `lParam` parameter of the corresponding message.\n\nUnder GTK, the raw flags contain the `hardware_keycode` field of the corresponding GDK event.\n\nUnder macOS, the raw flags contain the modifiers state.\n\nNote: Currently the raw key flags are not supported by all ports, use #ifdef\nwxHAS_RAW_KEY_CODES to determine if this feature is available.","ref":"wxKeyEvent.html#getRawKeyFlags/1"},{"type":"function","title":"wxKeyEvent.getUnicodeKey/1","doc":"Returns the Unicode character corresponding to this key event.\n\nIf the key pressed doesn't have any character value (e.g. a cursor key) this method will\nreturn `WXK_NONE`. In this case you should use `getKeyCode/1` to retrieve the value of the key.\n\nThis function is only available in Unicode build, i.e. when `wxUSE_UNICODE` is 1.","ref":"wxKeyEvent.html#getUnicodeKey/1"},{"type":"function","title":"wxKeyEvent.getX/1","doc":"Returns the X position (in client coordinates) of the event.\n\nSee: `getPosition/1`","ref":"wxKeyEvent.html#getX/1"},{"type":"function","title":"wxKeyEvent.getY/1","doc":"Returns the Y position (in client coordinates) of the event.\n\nSee: `getPosition/1`","ref":"wxKeyEvent.html#getY/1"},{"type":"function","title":"wxKeyEvent.hasModifiers/1","doc":"Returns true if Control or Alt are pressed.\n\nChecks if Control, Alt or, under macOS only, Command key are pressed (notice that the\nreal Control key is still taken into account under OS X too).\n\nThis method returns false if only Shift is pressed for compatibility reasons and also\nbecause pressing Shift usually doesn't change the interpretation of key events, see `HasAnyModifiers()`\n(not implemented in wx) if you want to take Shift into account as well.","ref":"wxKeyEvent.html#hasModifiers/1"},{"type":"function","title":"wxKeyEvent.metaDown/1","doc":"Returns true if the Meta/Windows/Apple key is pressed.\n\nThis function tests the state of the key traditionally called Meta under Unix systems,\nWindows keys under MSW Notice that `getModifiers/1` should usually be used instead of this one.\n\nSee: `cmdDown/1`","ref":"wxKeyEvent.html#metaDown/1"},{"type":"function","title":"wxKeyEvent.shiftDown/1","doc":"Returns true if the Shift key is pressed.\n\nThis function doesn't distinguish between right and left shift keys.\n\nNotice that `getModifiers/1` should usually be used instead of this one.","ref":"wxKeyEvent.html#shiftDown/1"},{"type":"type","title":"wxKeyEvent.wxKey/0","doc":"","ref":"wxKeyEvent.html#t:wxKey/0"},{"type":"type","title":"wxKeyEvent.wxKeyEvent/0","doc":"","ref":"wxKeyEvent.html#t:wxKeyEvent/0"},{"type":"type","title":"wxKeyEvent.wxKeyEventType/0","doc":"","ref":"wxKeyEvent.html#t:wxKeyEventType/0"},{"type":"module","title":"wxLayoutAlgorithm","doc":"`m:wxLayoutAlgorithm` implements layout of subwindows in MDI or SDI frames.\n\nIt sends a `wxCalculateLayoutEvent` (not implemented in wx) event to children of the\nframe, asking them for information about their size. For MDI parent frames, the algorithm\nallocates the remaining space to the MDI client window (which contains the MDI child frames).\n\nFor SDI (normal) frames, a 'main' window is specified as taking up the remaining space.\n\nBecause the event system is used, this technique can be applied to any windows, which are\nnot necessarily 'aware' of the layout classes (no virtual functions in `m:wxWindow` refer\nto `m:wxLayoutAlgorithm` or its events). However, you may wish to use `m:wxSashLayoutWindow`\nfor your subwindows since this class provides handlers for the required events, and\naccessors to specify the desired size of the window. The sash behaviour in the base class\ncan be used, optionally, to make the windows user-resizable.\n\n`m:wxLayoutAlgorithm` is typically used in IDE (integrated development environment)\napplications, where there are several resizable windows in addition to the MDI client\nwindow, or other primary editing window. Resizable windows might include toolbars, a\nproject window, and a window for displaying error and warning messages.\n\nWhen a window receives an OnCalculateLayout event, it should call SetRect in the given\nevent object, to be the old supplied rectangle minus whatever space the window takes up.\nIt should also set its own size accordingly. `wxSashLayoutWindow::OnCalculateLayout` (not\nimplemented in wx) generates an OnQueryLayoutInfo event which it sends to itself to\ndetermine the orientation, alignment and size of the window, which it gets from internal\nmember variables set by the application.\n\nThe algorithm works by starting off with a rectangle equal to the whole frame client\narea. It iterates through the frame children, generating\nwxLayoutAlgorithm::OnCalculateLayout events which subtract the window size and return the\nremaining rectangle for the next window to process. It is assumed (by `wxSashLayoutWindow::OnCalculateLayout`\n(not implemented in wx)) that a window stretches the full dimension of the frame client,\naccording to the orientation it specifies. For example, a horizontal window will stretch\nthe full width of the remaining portion of the frame client area. In the other\norientation, the window will be fixed to whatever size was specified by\nwxLayoutAlgorithm::OnQueryLayoutInfo. An alignment setting will make the window 'stick' to\nthe left, top, right or bottom of the remaining client area. This scheme implies that\norder of window creation is important. Say you wish to have an extra toolbar at the top of\nthe frame, a project window to the left of the MDI client window, and an output window\nabove the status bar. You should therefore create the windows in this order: toolbar,\noutput window, project window. This ensures that the toolbar and output window take up\nspace at the top and bottom, and then the remaining height in-between is used for the\nproject window.\n\n`m:wxLayoutAlgorithm` is quite independent of the way in which\nwxLayoutAlgorithm::OnCalculateLayout chooses to interpret a window's size and alignment.\nTherefore you could implement a different window class with a new\nwxLayoutAlgorithm::OnCalculateLayout event handler, that has a more sophisticated way of\nlaying out the windows. It might allow specification of whether stretching occurs in the\nspecified orientation, for example, rather than always assuming stretching. (This could,\nand probably should, be added to the existing implementation).\n\nNote: `m:wxLayoutAlgorithm` has nothing to do with `wxLayoutConstraints` (not implemented\nin wx). It is an alternative way of specifying layouts for which the normal constraint\nsystem is unsuitable.\n\nSee:\n* `m:wxSashEvent`\n\n* `m:wxSashLayoutWindow`\n\n* [Overview events](https://docs.wxwidgets.org/3.2/overview_events.html#overview_events)\n\nwxWidgets docs: [wxLayoutAlgorithm](https://docs.wxwidgets.org/3.2/classwx_layout_algorithm.html)","ref":"wxLayoutAlgorithm.html"},{"type":"function","title":"wxLayoutAlgorithm.destroy/1","doc":"Destroys the object","ref":"wxLayoutAlgorithm.html#destroy/1"},{"type":"function","title":"wxLayoutAlgorithm.layoutFrame/2","doc":"Equivalent to  layoutFrame(This, Frame, []) .","ref":"wxLayoutAlgorithm.html#layoutFrame/2"},{"type":"function","title":"wxLayoutAlgorithm.layoutFrame/3","doc":"Lays out the children of a normal frame.\n\n`mainWindow` is set to occupy the remaining space. This function simply calls `layoutWindow/3`.","ref":"wxLayoutAlgorithm.html#layoutFrame/3"},{"type":"function","title":"wxLayoutAlgorithm.layoutMDIFrame/2","doc":"Equivalent to  layoutMDIFrame(This, Frame, []) .","ref":"wxLayoutAlgorithm.html#layoutMDIFrame/2"},{"type":"function","title":"wxLayoutAlgorithm.layoutMDIFrame/3","doc":"Lays out the children of an MDI parent frame.\n\nIf `rect` is non-NULL, the given rectangle will be used as a starting point instead of\nthe frame's client area. The MDI client window is set to occupy the remaining space.","ref":"wxLayoutAlgorithm.html#layoutMDIFrame/3"},{"type":"function","title":"wxLayoutAlgorithm.layoutWindow/2","doc":"Equivalent to  layoutWindow(This, Parent, []) .","ref":"wxLayoutAlgorithm.html#layoutWindow/2"},{"type":"function","title":"wxLayoutAlgorithm.layoutWindow/3","doc":"Lays out the children of a normal frame or other window.\n\n`mainWindow` is set to occupy the remaining space. If this is not specified, then the\nlast window that responds to a calculate layout event in query mode will get the remaining\nspace (that is, a non-query OnCalculateLayout event will not be sent to this window and\nthe window will be set to the remaining size).","ref":"wxLayoutAlgorithm.html#layoutWindow/3"},{"type":"function","title":"wxLayoutAlgorithm.new/0","doc":"Default constructor.","ref":"wxLayoutAlgorithm.html#new/0"},{"type":"type","title":"wxLayoutAlgorithm.wxLayoutAlgorithm/0","doc":"","ref":"wxLayoutAlgorithm.html#t:wxLayoutAlgorithm/0"},{"type":"module","title":"wxListBox","doc":"A listbox is used to select one or more of a list of strings.\n\nThe strings are displayed in a scrolling box, with the selected string(s) marked in\nreverse video. A listbox can be single selection (if an item is selected, the previous\nselection is removed) or multiple selection (clicking an item toggles the item on or off\nindependently of other selections).\n\nList box elements are numbered from zero and while the maximal number of elements is\nunlimited, it is usually better to use a virtual control, not requiring to add all the\nitems to it at once, such as `wxDataViewCtrl` (not implemented in wx) or `m:wxListCtrl`\nwith `wxLC_VIRTUAL` style, once more than a few hundreds items need to be displayed\nbecause this control is not optimized, neither from performance nor from user interface\npoint of view, for large number of items.\n\nNotice that the list box doesn't support control characters other than `TAB`.","ref":"wxListBox.html"},{"type":"module","title":"Styles - wxListBox","doc":"This class supports the following styles:\n\n* wxLB_SINGLE: Single-selection list.\n\n* wxLB_MULTIPLE: Multiple-selection list: the user can toggle multiple items on and off.\nThis is the same as wxLB_EXTENDED in wxGTK2 port.\n\n* wxLB_EXTENDED: Extended-selection list: the user can extend the selection by using `SHIFT`\nor `CTRL` keys together with the cursor movement keys or the mouse.\n\n* wxLB_HSCROLL: Create horizontal scrollbar if contents are too wide (Windows only).\n\n* wxLB_ALWAYS_SB: Always show a vertical scrollbar.\n\n* wxLB_NEEDED_SB: Only create a vertical scrollbar if needed.\n\n* wxLB_NO_SB: Don't create vertical scrollbar (wxMSW and wxGTK only).\n\n* wxLB_SORT: The listbox contents are sorted in alphabetical order. Note that `wxLB_SINGLE`, `wxLB_MULTIPLE`\nand `wxLB_EXTENDED` styles are mutually exclusive and you can specify at most one of them\n(single selection is the default). See also overview_windowstyles.\n\nSee:\n* `m:wxChoice`\n\n* `m:wxComboBox`\n\n* `m:wxListCtrl`\n\n* `m:wxCommandEvent`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxControlWithItems`\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxListBox](https://docs.wxwidgets.org/3.2/classwx_list_box.html)","ref":"wxListBox.html#module-styles"},{"type":"module","title":"Events - wxListBox","doc":"Event types emitted from this class:\n\n* [`command_listbox_selected`](`m:wxCommandEvent`)\n\n* [`command_listbox_doubleclicked`](`m:wxCommandEvent`)","ref":"wxListBox.html#module-events"},{"type":"function","title":"wxListBox.create/6","doc":"Equivalent to  create(This, Parent, Id, Pos, Size, Choices, []) .","ref":"wxListBox.html#create/6"},{"type":"function","title":"wxListBox.create/7","doc":"","ref":"wxListBox.html#create/7"},{"type":"function","title":"wxListBox.deselect/2","doc":"Deselects an item in the list box.\n\nRemark: This applies to multiple selection listboxes only.","ref":"wxListBox.html#deselect/2"},{"type":"function","title":"wxListBox.destroy/1","doc":"Destroys the object","ref":"wxListBox.html#destroy/1"},{"type":"function","title":"wxListBox.getSelections/1","doc":"Fill an array of ints with the positions of the currently selected items.\n\nReturn: The number of selections.\n\nRemark: Use this with a multiple selection listbox.\n\nSee:\n* `wxControlWithItems:getSelection/1`\n\n* `wxControlWithItems:getStringSelection/1`\n\n* `wxControlWithItems:setSelection/2`","ref":"wxListBox.html#getSelections/1"},{"type":"function","title":"wxListBox.hitTest/2","doc":"Returns the item located at `point`, or `wxNOT\\_FOUND` if there is no item located at `point`.\n\nIt is currently implemented for wxMSW, wxMac and wxGTK2 ports.\n\nReturn: Item located at point, or wxNOT_FOUND if unimplemented or the item does not exist.\n\nSince: 2.7.0","ref":"wxListBox.html#hitTest/2"},{"type":"function","title":"wxListBox.hitTest/3","doc":"This is an overloaded member function, provided for convenience. It differs from the\nabove function only in what argument(s) it accepts.","ref":"wxListBox.html#hitTest/3"},{"type":"function","title":"wxListBox.insertItems/3","doc":"Insert the given number of strings before the specified position.","ref":"wxListBox.html#insertItems/3"},{"type":"function","title":"wxListBox.isSelected/2","doc":"Determines whether an item is selected.\n\nReturn: true if the given item is selected, false otherwise.","ref":"wxListBox.html#isSelected/2"},{"type":"function","title":"wxListBox.new/0","doc":"Default constructor.","ref":"wxListBox.html#new/0"},{"type":"function","title":"wxListBox.new/2","doc":"Equivalent to  new(Parent, Id, []) .","ref":"wxListBox.html#new/2"},{"type":"function","title":"wxListBox.new/3","doc":"Constructor, creating and showing a list box.\n\nSee the other `new/3` constructor; the only difference is that this overload takes a `wxArrayString`\n(not implemented in wx) instead of a pointer to an array of `wxString` (not implemented\nin wx).","ref":"wxListBox.html#new/3"},{"type":"function","title":"wxListBox.set/2","doc":"Replaces the current control contents with the given items.\n\nNotice that calling this method is usually much faster than appending them one by one if\nyou need to add a lot of items.","ref":"wxListBox.html#set/2"},{"type":"function","title":"wxListBox.setFirstItem/2","doc":"Set the specified item to be the first visible item.","ref":"wxListBox.html#setFirstItem/2"},{"type":"type","title":"wxListBox.wxListBox/0","doc":"","ref":"wxListBox.html#t:wxListBox/0"},{"type":"module","title":"wxListCtrl","doc":"A list control presents lists in a number of formats: list view, report view, icon view\nand small icon view.\n\nIn any case, elements are numbered from zero. For all these modes, the items are stored\nin the control and must be added to it using `insertItem/4` method.\n\nA special case of report view quite different from the other modes of the list control is\na virtual control in which the items data (including text, images and attributes) is\nmanaged by the main program and is requested by the control itself only when needed which\nallows having controls with millions of items without consuming much memory. To use\nvirtual list control you must use `setItemCount/2` first and override at least `wxListCtrl::OnGetItemText`\n(not implemented in wx) (and optionally `wxListCtrl::OnGetItemImage` (not implemented in\nwx) or `wxListCtrl::OnGetItemColumnImage` (not implemented in wx) and `wxListCtrl::OnGetItemAttr`\n(not implemented in wx)) to return the information about the items when the control\nrequests it.\n\nVirtual list control can be used as a normal one except that no operations which can take\ntime proportional to the number of items in the control happen - this is required to allow\nhaving a practically infinite number of items. For example, in a multiple selection\nvirtual list control, the selections won't be sent when many items are selected at once\nbecause this could mean iterating over all the items.\n\nUsing many of `m:wxListCtrl` features is shown in the corresponding sample.\n\nTo intercept events from a list control, use the event table macros described in `m:wxListEvent`.\n\n`wxMac Note`: Starting with wxWidgets 2.8, `m:wxListCtrl` uses a native implementation\nfor report mode, and uses a generic implementation for other modes. You can use the\ngeneric implementation for report mode as well by setting the `mac.listctrl.always_use_generic`\nsystem option (see `m:wxSystemOptions`) to 1.","ref":"wxListCtrl.html"},{"type":"module","title":"Styles - wxListCtrl","doc":"This class supports the following styles:\n\n* wxLC_LIST: Multicolumn list view, with optional small icons. Columns are computed\nautomatically, i.e. you don't set columns as in `wxLC_REPORT`. In other words, the list\nwraps, unlike a `m:wxListBox`.\n\n* wxLC_REPORT: Single or multicolumn report view, with optional header.\n\n* wxLC_VIRTUAL: The application provides items text on demand. May only be used with `wxLC_REPORT`.\n\n* wxLC_ICON: Large icon view, with optional labels.\n\n* wxLC_SMALL_ICON: Small icon view, with optional labels.\n\n* wxLC_ALIGN_TOP: Icons align to the top. Win32 default, Win32 only.\n\n* wxLC_ALIGN_LEFT: Icons align to the left.\n\n* wxLC_AUTOARRANGE: Icons arrange themselves. Win32 only.\n\n* wxLC_EDIT_LABELS: Labels are editable: the application will be notified when editing\nstarts.\n\n* wxLC_NO_HEADER: No header in report mode.\n\n* wxLC_SINGLE_SEL: Single selection (default is multiple).\n\n* wxLC_SORT_ASCENDING: Sort in ascending order. (You must still supply a comparison\ncallback in `sortItems/2`.)\n\n* wxLC_SORT_DESCENDING: Sort in descending order. (You must still supply a comparison\ncallback in `sortItems/2`.)\n\n* wxLC_HRULES: Draws light horizontal rules between rows in report mode.\n\n* wxLC_VRULES: Draws light vertical rules between columns in report mode.\n\nSee:\n* [Overview listctrl](https://docs.wxwidgets.org/3.2/overview_listctrl.html#overview_listctrl)\n\n* `m:wxListView`\n\n* `m:wxListBox`\n\n* `m:wxTreeCtrl`\n\n* `m:wxImageList`\n\n* `m:wxListEvent`\n\n* `m:wxListItem`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxListCtrl](https://docs.wxwidgets.org/3.2/classwx_list_ctrl.html)","ref":"wxListCtrl.html#module-styles"},{"type":"module","title":"Events - wxListCtrl","doc":"Event types emitted from this class:\n\n* [`command_list_begin_drag`](`m:wxListEvent`)\n\n* [`command_list_begin_rdrag`](`m:wxListEvent`)\n\n* [`command_list_begin_label_edit`](`m:wxListEvent`)\n\n* [`command_list_end_label_edit`](`m:wxListEvent`)\n\n* [`command_list_delete_item`](`m:wxListEvent`)\n\n* [`command_list_delete_all_items`](`m:wxListEvent`)\n\n* [`command_list_item_selected`](`m:wxListEvent`)\n\n* [`command_list_item_deselected`](`m:wxListEvent`)\n\n* [`command_list_item_activated`](`m:wxListEvent`)\n\n* [`command_list_item_focused`](`m:wxListEvent`)\n\n* [`command_list_item_middle_click`](`m:wxListEvent`)\n\n* [`command_list_item_right_click`](`m:wxListEvent`)\n\n* [`command_list_key_down`](`m:wxListEvent`)\n\n* [`command_list_insert_item`](`m:wxListEvent`)\n\n* [`command_list_col_click`](`m:wxListEvent`)\n\n* [`command_list_col_right_click`](`m:wxListEvent`)\n\n* [`command_list_col_begin_drag`](`m:wxListEvent`)\n\n* [`command_list_col_dragging`](`m:wxListEvent`)\n\n* [`command_list_col_end_drag`](`m:wxListEvent`)\n\n* [`command_list_cache_hint`](`m:wxListEvent`)","ref":"wxListCtrl.html#module-events"},{"type":"function","title":"wxListCtrl.arrange/1","doc":"Equivalent to  arrange(This, []) .","ref":"wxListCtrl.html#arrange/1"},{"type":"function","title":"wxListCtrl.arrange/2","doc":"Arranges the items in icon or small icon view.\n\nThis only has effect on Win32. `flag` is one of:\n\n* wxLIST_ALIGN_DEFAULT: Default alignment.\n\n* wxLIST_ALIGN_LEFT: Align to the left side of the control.\n\n* wxLIST_ALIGN_TOP: Align to the top side of the control.\n\n* wxLIST_ALIGN_SNAP_TO_GRID: Snap to grid.","ref":"wxListCtrl.html#arrange/2"},{"type":"function","title":"wxListCtrl.assignImageList/3","doc":"Sets the image list associated with the control and takes ownership of it (i.e.\n\nthe control will, unlike when using `setImageList/3`, delete the list when destroyed). `which` is one of `wxIMAGE_LIST_NORMAL`, `wxIMAGE_LIST_SMALL`, `wxIMAGE_LIST_STATE`\n(the last is unimplemented).\n\nSee: `setImageList/3`","ref":"wxListCtrl.html#assignImageList/3"},{"type":"function","title":"wxListCtrl.clearAll/1","doc":"Deletes all items and all columns.\n\nNote: This sends an event of type `wxEVT_LIST_DELETE_ALL_ITEMS` under all platforms.","ref":"wxListCtrl.html#clearAll/1"},{"type":"function","title":"wxListCtrl.create/2","doc":"","ref":"wxListCtrl.html#create/2"},{"type":"function","title":"wxListCtrl.create/3","doc":"","ref":"wxListCtrl.html#create/3"},{"type":"function","title":"wxListCtrl.deleteAllItems/1","doc":"Deletes all items in the list control.\n\nThis function does `not` send the `wxEVT_LIST_DELETE_ITEM` event because deleting many\nitems from the control would be too slow then (unlike `deleteItem/2`) but it does send the special `wxEVT_LIST_DELETE_ALL_ITEMS`\nevent if the control was not empty. If it was already empty, nothing is done and no event\nis sent.\n\nReturn: true if the items were successfully deleted or if the control was already empty,\nfalse if an error occurred while deleting the items.","ref":"wxListCtrl.html#deleteAllItems/1"},{"type":"function","title":"wxListCtrl.deleteColumn/2","doc":"Deletes a column.","ref":"wxListCtrl.html#deleteColumn/2"},{"type":"function","title":"wxListCtrl.deleteItem/2","doc":"Deletes the specified item.\n\nThis function sends the `wxEVT_LIST_DELETE_ITEM` event for the item being deleted.\n\nSee: `deleteAllItems/1`","ref":"wxListCtrl.html#deleteItem/2"},{"type":"function","title":"wxListCtrl.destroy/1","doc":"Destroys the object","ref":"wxListCtrl.html#destroy/1"},{"type":"function","title":"wxListCtrl.editLabel/2","doc":"Starts editing the label of the given item.\n\nThis function generates a `EVT_LIST_BEGIN_LABEL_EDIT` event which can be vetoed so that\nno text control will appear for in-place editing.\n\nIf the user changed the label (i.e. s/he does not press ESC or leave the text control\nwithout changes, a `EVT_LIST_END_LABEL_EDIT` event will be sent which can be vetoed as\nwell.","ref":"wxListCtrl.html#editLabel/2"},{"type":"function","title":"wxListCtrl.ensureVisible/2","doc":"Ensures this item is visible.","ref":"wxListCtrl.html#ensureVisible/2"},{"type":"function","title":"wxListCtrl.findItem/3","doc":"Equivalent to  findItem(This, Start, Str, []) .","ref":"wxListCtrl.html#findItem/3"},{"type":"function","title":"wxListCtrl.findItem/4","doc":"Find an item nearest this position in the specified direction, starting from `start` or\nthe beginning if `start` is -1.\n\nReturn: The next matching item if any or `-1` (wxNOT_FOUND) otherwise.","ref":"wxListCtrl.html#findItem/4"},{"type":"function","title":"wxListCtrl.getColumn/3","doc":"Gets information about this column.\n\nSee `setItem/5` for more information.","ref":"wxListCtrl.html#getColumn/3"},{"type":"function","title":"wxListCtrl.getColumnCount/1","doc":"Returns the number of columns.","ref":"wxListCtrl.html#getColumnCount/1"},{"type":"function","title":"wxListCtrl.getColumnWidth/2","doc":"Gets the column width (report view only).","ref":"wxListCtrl.html#getColumnWidth/2"},{"type":"function","title":"wxListCtrl.getCountPerPage/1","doc":"Gets the number of items that can fit vertically in the visible area of the list control\n(list or report view) or the total number of items in the list control (icon or small icon\nview).","ref":"wxListCtrl.html#getCountPerPage/1"},{"type":"function","title":"wxListCtrl.getEditControl/1","doc":"Returns the edit control being currently used to edit a label.\n\nReturns NULL if no label is being edited.\n\nNote: It is currently only implemented for wxMSW and the generic version, not for the\nnative macOS version.","ref":"wxListCtrl.html#getEditControl/1"},{"type":"function","title":"wxListCtrl.getImageList/2","doc":"Returns the specified image list.\n\n`which` may be one of:\n\n* wxIMAGE_LIST_NORMAL: The normal (large icon) image list.\n\n* wxIMAGE_LIST_SMALL: The small icon image list.\n\n* wxIMAGE_LIST_STATE: The user-defined state image list (unimplemented).","ref":"wxListCtrl.html#getImageList/2"},{"type":"function","title":"wxListCtrl.getItem/2","doc":"Gets information about the item.\n\nSee `setItem/5` for more information.\n\nYou must call `info.SetId()` to set the ID of item you're interested in before calling\nthis method, and `info.SetMask()` with the flags indicating what fields you need to\nretrieve from `info`.","ref":"wxListCtrl.html#getItem/2"},{"type":"function","title":"wxListCtrl.getItemBackgroundColour/2","doc":"Returns the colour for this item.\n\nIf the item has no specific colour, returns an invalid colour (and not the default\nbackground control of the control itself).\n\nSee: `getItemTextColour/2`","ref":"wxListCtrl.html#getItemBackgroundColour/2"},{"type":"function","title":"wxListCtrl.getItemCount/1","doc":"Returns the number of items in the list control.","ref":"wxListCtrl.html#getItemCount/1"},{"type":"function","title":"wxListCtrl.getItemData/2","doc":"Gets the application-defined data associated with this item.","ref":"wxListCtrl.html#getItemData/2"},{"type":"function","title":"wxListCtrl.getItemFont/2","doc":"Returns the item's font.","ref":"wxListCtrl.html#getItemFont/2"},{"type":"function","title":"wxListCtrl.getItemPosition/2","doc":"Returns the position of the item, in icon or small icon view.","ref":"wxListCtrl.html#getItemPosition/2"},{"type":"function","title":"wxListCtrl.getItemRect/2","doc":"Equivalent to  getItemRect(This, Item, []) .","ref":"wxListCtrl.html#getItemRect/2"},{"type":"function","title":"wxListCtrl.getItemRect/3","doc":"Returns the rectangle representing the item's size and position, in physical coordinates.\n\n`code` is one of wxLIST_RECT_BOUNDS, wxLIST_RECT_ICON, wxLIST_RECT_LABEL.","ref":"wxListCtrl.html#getItemRect/3"},{"type":"function","title":"wxListCtrl.getItemSpacing/1","doc":"Retrieves the spacing between icons in pixels: horizontal spacing is returned as `x`\ncomponent of the {Width,Height} object and the vertical spacing as its `y` component.","ref":"wxListCtrl.html#getItemSpacing/1"},{"type":"function","title":"wxListCtrl.getItemState/3","doc":"Gets the item state.\n\nFor a list of state flags, see `setItem/5`. The `stateMask` indicates which state flags are of\ninterest.","ref":"wxListCtrl.html#getItemState/3"},{"type":"function","title":"wxListCtrl.getItemText/2","doc":"Equivalent to  getItemText(This, Item, []) .","ref":"wxListCtrl.html#getItemText/2"},{"type":"function","title":"wxListCtrl.getItemText/3","doc":"Gets the item text for this item.","ref":"wxListCtrl.html#getItemText/3"},{"type":"function","title":"wxListCtrl.getItemTextColour/2","doc":"Returns the colour for this item.\n\nIf the item has no specific colour, returns an invalid colour (and not the default\nforeground control of the control itself as this wouldn't allow distinguishing between\nitems having the same colour as the current control foreground and items with default\ncolour which, hence, have always the same colour as the control).","ref":"wxListCtrl.html#getItemTextColour/2"},{"type":"function","title":"wxListCtrl.getNextItem/2","doc":"Equivalent to  getNextItem(This, Item, []) .","ref":"wxListCtrl.html#getNextItem/2"},{"type":"function","title":"wxListCtrl.getNextItem/3","doc":"Searches for an item with the given geometry or state, starting from `item` but excluding\nthe `item` itself.\n\nIf `item` is -1, the first item that matches the specified flags will be returned.\nReturns the first item with given state following `item` or -1 if no such item found. This\nfunction may be used to find all selected items in the control like this:\n\n`geometry` can be one of:\n\n* wxLIST_NEXT_ABOVE: Searches for an item above the specified item.\n\n* wxLIST_NEXT_ALL: Searches for subsequent item by index.\n\n* wxLIST_NEXT_BELOW: Searches for an item below the specified item.\n\n* wxLIST_NEXT_LEFT: Searches for an item to the left of the specified item.\n\n* wxLIST_NEXT_RIGHT: Searches for an item to the right of the specified item.\n\nNote: this parameter is only supported by wxMSW currently and ignored on other platforms.\n\n`state` can be a bitlist of the following:\n\n* wxLIST_STATE_DONTCARE: Don't care what the state is.\n\n* wxLIST_STATE_DROPHILITED: The item indicates it is a drop target.\n\n* wxLIST_STATE_FOCUSED: The item has the focus.\n\n* wxLIST_STATE_SELECTED: The item is selected.\n\n* wxLIST_STATE_CUT: The item is selected as part of a cut and paste operation.","ref":"wxListCtrl.html#getNextItem/3"},{"type":"function","title":"wxListCtrl.getSelectedItemCount/1","doc":"Returns the number of selected items in the list control.","ref":"wxListCtrl.html#getSelectedItemCount/1"},{"type":"function","title":"wxListCtrl.getTextColour/1","doc":"Gets the text colour of the list control.","ref":"wxListCtrl.html#getTextColour/1"},{"type":"function","title":"wxListCtrl.getTopItem/1","doc":"Gets the index of the topmost visible item when in list or report view.","ref":"wxListCtrl.html#getTopItem/1"},{"type":"function","title":"wxListCtrl.getViewRect/1","doc":"Returns the rectangle taken by all items in the control.\n\nIn other words, if the controls client size were equal to the size of this rectangle, no\nscrollbars would be needed and no free space would be left.\n\nNote that this function only works in the icon and small icon views, not in list or\nreport views (this is a limitation of the native Win32 control).","ref":"wxListCtrl.html#getViewRect/1"},{"type":"function","title":"wxListCtrl.hitTest/2","doc":"Determines which item (if any) is at the specified point, giving details in `flags`.\n\nReturns index of the item or `wxNOT_FOUND` if no item is at the specified point.\n\n`flags` will be a combination of the following flags:\n\n* wxLIST_HITTEST_ABOVE: Above the control's client area.\n\n* wxLIST_HITTEST_BELOW: Below the control's client area.\n\n* wxLIST_HITTEST_TOLEFT: To the left of the control's client area.\n\n* wxLIST_HITTEST_TORIGHT: To the right of the control's client area.\n\n* wxLIST_HITTEST_NOWHERE: Inside the control's client area but not over an item.\n\n* wxLIST_HITTEST_ONITEMICON: Over an item's icon.\n\n* wxLIST_HITTEST_ONITEMLABEL: Over an item's text.\n\n* wxLIST_HITTEST_ONITEMSTATEICON: Over the checkbox of an item.\n\n* wxLIST_HITTEST_ONITEM: Combination of `wxLIST_HITTEST_ONITEMICON`, `wxLIST_HITTEST_ONITEMLABEL`, `wxLIST_HITTEST_ONITEMSTATEICON`.\n\nIf `ptrSubItem` is not NULL and the `m:wxListCtrl` is in the report mode the subitem (or\ncolumn) number will also be provided. This feature is only available in version 2.7.0 or\nhigher and is currently only implemented under wxMSW and requires at least comctl32.dll of\nversion 4.70 on the host system or the value stored in `ptrSubItem` will be always -1. To\ncompile this feature into wxWidgets library you need to have access to commctrl.h of\nversion 4.70 that is provided by Microsoft.","ref":"wxListCtrl.html#hitTest/2"},{"type":"function","title":"wxListCtrl.insertColumn/3","doc":"For report view mode (only), inserts a column.\n\nFor more details, see `setItem/5`. Also see `insertColumn/4` overload for a usually more convenient alternative to\nthis method and the description of how the item width is interpreted by this method.","ref":"wxListCtrl.html#insertColumn/3"},{"type":"function","title":"wxListCtrl.insertColumn/4","doc":"For report view mode (only), inserts a column.\n\nInsert a new column in the list control in report view mode at the given position\nspecifying its most common attributes.\n\nNotice that to set the image for the column you need to use `insertColumn/4` overload and specify\n?wxLIST\\_MASK\\_IMAGE in the item mask.\n\nReturn: The index of the inserted column or -1 if adding it failed.","ref":"wxListCtrl.html#insertColumn/4"},{"type":"function","title":"wxListCtrl.insertItem/2","doc":"Inserts an item, returning the index of the new item if successful, -1 otherwise.","ref":"wxListCtrl.html#insertItem/2"},{"type":"function","title":"wxListCtrl.insertItem/3","doc":"Insert a string item.","ref":"wxListCtrl.html#insertItem/3"},{"type":"function","title":"wxListCtrl.insertItem/4","doc":"Insert an image/string item.","ref":"wxListCtrl.html#insertItem/4"},{"type":"function","title":"wxListCtrl.new/0","doc":"","ref":"wxListCtrl.html#new/0"},{"type":"function","title":"wxListCtrl.new/1","doc":"","ref":"wxListCtrl.html#new/1"},{"type":"function","title":"wxListCtrl.new/2","doc":"","ref":"wxListCtrl.html#new/2"},{"type":"function","title":"wxListCtrl.refreshItem/2","doc":"Redraws the given `item`.\n\nThis is only useful for the virtual list controls as without calling this function the\ndisplayed value of the item doesn't change even when the underlying data does change.\n\nSee: `refreshItems/3`","ref":"wxListCtrl.html#refreshItem/2"},{"type":"function","title":"wxListCtrl.refreshItems/3","doc":"Redraws the items between `itemFrom` and `itemTo`.\n\nThe starting item must be less than or equal to the ending one.\n\nJust as `refreshItem/2` this is only useful for virtual list controls.","ref":"wxListCtrl.html#refreshItems/3"},{"type":"function","title":"wxListCtrl.scrollList/3","doc":"Scrolls the list control.\n\nIf in icon, small icon or report view mode, `dx` specifies the number of pixels to\nscroll. If in list view mode, `dx` specifies the number of columns to scroll. `dy` always\nspecifies the number of pixels to scroll vertically.\n\nNote: This method is currently only implemented in the Windows version.","ref":"wxListCtrl.html#scrollList/3"},{"type":"function","title":"wxListCtrl.setBackgroundColour/2","doc":"Sets the background colour.\n\nNote that the `wxWindow:getBackgroundColour/1` function of `m:wxWindow` base class can be used to retrieve the current\nbackground colour.","ref":"wxListCtrl.html#setBackgroundColour/2"},{"type":"function","title":"wxListCtrl.setColumn/3","doc":"Sets information about this column.\n\nSee `setItem/5` for more information.","ref":"wxListCtrl.html#setColumn/3"},{"type":"function","title":"wxListCtrl.setColumnWidth/3","doc":"Sets the column width.\n\n`width` can be a width in pixels or `wxLIST_AUTOSIZE` (-1) or `wxLIST_AUTOSIZE_USEHEADER` (-2).\n\n`wxLIST_AUTOSIZE` will resize the column to the length of its longest item.\n\n`wxLIST_AUTOSIZE_USEHEADER` will resize the column to the length of the header (Win32) or\n80 pixels (other platforms).\n\nIn small or normal icon view, `col` must be -1, and the column width is set for all\ncolumns.","ref":"wxListCtrl.html#setColumnWidth/3"},{"type":"function","title":"wxListCtrl.setImageList/3","doc":"Sets the image list associated with the control.\n\n`which` is one of `wxIMAGE_LIST_NORMAL`, `wxIMAGE_LIST_SMALL`, `wxIMAGE_LIST_STATE` (the\nlast is unimplemented).\n\nThis method does not take ownership of the image list, you have to delete it yourself.\n\nSee: `assignImageList/3`","ref":"wxListCtrl.html#setImageList/3"},{"type":"function","title":"wxListCtrl.setItem/2","doc":"Sets the data of an item.\n\nUsing the `m:wxListItem`'s mask and state mask, you can change only selected attributes\nof a `m:wxListCtrl` item.\n\nReturn: true if the item was successfully updated or false if the update failed for some\nreason (e.g. an invalid item index).","ref":"wxListCtrl.html#setItem/2"},{"type":"function","title":"wxListCtrl.setItem/4","doc":"Equivalent to  setItem(This, Index, Column, Label, []) .","ref":"wxListCtrl.html#setItem/4"},{"type":"function","title":"wxListCtrl.setItem/5","doc":"Sets an item string field at a particular column.\n\nReturn: true if the item was successfully updated or false if the update failed for some\nreason (e.g. an invalid item index).","ref":"wxListCtrl.html#setItem/5"},{"type":"function","title":"wxListCtrl.setItemBackgroundColour/3","doc":"Sets the background colour for this item.\n\nThis function only works in report view mode. The colour can be retrieved using `getItemBackgroundColour/2`.","ref":"wxListCtrl.html#setItemBackgroundColour/3"},{"type":"function","title":"wxListCtrl.setItemColumnImage/4","doc":"Sets the image associated with the item.\n\nIn report view, you can specify the column. The image is an index into the image list\nassociated with the list control.","ref":"wxListCtrl.html#setItemColumnImage/4"},{"type":"function","title":"wxListCtrl.setItemCount/2","doc":"This method can only be used with virtual list controls.\n\nIt is used to indicate to the control the number of items it contains. After calling it,\nthe main program should be ready to handle calls to various item callbacks (such as `wxListCtrl::OnGetItemText`\n(not implemented in wx)) for all items in the range from 0 to `count`.\n\nNotice that the control is not necessarily redrawn after this call as it may be\nundesirable if an item which is not visible on the screen anyhow was added to or removed\nfrom a control displaying many items, if you do need to refresh the display you can just\ncall `wxWindow:refresh/2` manually.","ref":"wxListCtrl.html#setItemCount/2"},{"type":"function","title":"wxListCtrl.setItemData/3","doc":"Associates application-defined data with this item.\n\nNotice that this function cannot be used to associate pointers with the control items,\nuse `SetItemPtrData()` (not implemented in wx) instead.","ref":"wxListCtrl.html#setItemData/3"},{"type":"function","title":"wxListCtrl.setItemFont/3","doc":"Sets the item's font.","ref":"wxListCtrl.html#setItemFont/3"},{"type":"function","title":"wxListCtrl.setItemImage/3","doc":"Equivalent to  setItemImage(This, Item, Image, []) .","ref":"wxListCtrl.html#setItemImage/3"},{"type":"function","title":"wxListCtrl.setItemImage/4","doc":"Sets the unselected and selected images associated with the item.\n\nThe images are indices into the image list associated with the list control.","ref":"wxListCtrl.html#setItemImage/4"},{"type":"function","title":"wxListCtrl.setItemPosition/3","doc":"Sets the position of the item, in icon or small icon view.\n\nWindows only.","ref":"wxListCtrl.html#setItemPosition/3"},{"type":"function","title":"wxListCtrl.setItemState/4","doc":"Sets the item state.\n\nThe `stateMask` is a combination of `wxLIST_STATE_XXX` constants described in `m:wxListItem`\ndocumentation. For each of the bits specified in `stateMask`, the corresponding state is\nset or cleared depending on whether `state` argument contains the same bit or not.\n\nSo to select an item you can use while to deselect it you should use\n\nConsider using `m:wxListView` if possible to avoid dealing with this error-prone and\nconfusing method.\n\nAlso notice that contrary to the usual rule that only user actions generate events, this\nmethod does generate wxEVT_LIST_ITEM_SELECTED event when it is used to select an item.","ref":"wxListCtrl.html#setItemState/4"},{"type":"function","title":"wxListCtrl.setItemText/3","doc":"Sets the item text for this item.","ref":"wxListCtrl.html#setItemText/3"},{"type":"function","title":"wxListCtrl.setItemTextColour/3","doc":"Sets the colour for this item.\n\nThis function only works in report view. The colour can be retrieved using `getItemTextColour/2`.","ref":"wxListCtrl.html#setItemTextColour/3"},{"type":"function","title":"wxListCtrl.setSingleStyle/2","doc":"Equivalent to  setSingleStyle(This, Style, []) .","ref":"wxListCtrl.html#setSingleStyle/2"},{"type":"function","title":"wxListCtrl.setSingleStyle/3","doc":"Adds or removes a single window style.","ref":"wxListCtrl.html#setSingleStyle/3"},{"type":"function","title":"wxListCtrl.setTextColour/2","doc":"Sets the text colour of the list control.","ref":"wxListCtrl.html#setTextColour/2"},{"type":"function","title":"wxListCtrl.setWindowStyleFlag/2","doc":"Sets the whole window style, deleting all items.","ref":"wxListCtrl.html#setWindowStyleFlag/2"},{"type":"function","title":"wxListCtrl.sortItems/2","doc":"","ref":"wxListCtrl.html#sortItems/2"},{"type":"type","title":"wxListCtrl.wxListCtrl/0","doc":"","ref":"wxListCtrl.html#t:wxListCtrl/0"},{"type":"module","title":"wxListEvent","doc":"A list event holds information about events associated with `m:wxListCtrl` objects.\n\nSee: `m:wxListCtrl`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxNotifyEvent`\n\n* `m:wxCommandEvent`\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxListEvent](https://docs.wxwidgets.org/3.2/classwx_list_event.html)","ref":"wxListEvent.html"},{"type":"module","title":"Events - wxListEvent","doc":"Use `wxEvtHandler:connect/3` with `wxListEventType` to subscribe to events of this type.","ref":"wxListEvent.html#module-events"},{"type":"function","title":"wxListEvent.getCacheFrom/1","doc":"For `EVT\\_LIST\\_CACHE\\_HINT` event only: return the first item which the list control\nadvises us to cache.","ref":"wxListEvent.html#getCacheFrom/1"},{"type":"function","title":"wxListEvent.getCacheTo/1","doc":"For `EVT\\_LIST\\_CACHE\\_HINT` event only: return the last item (inclusive) which the list\ncontrol advises us to cache.","ref":"wxListEvent.html#getCacheTo/1"},{"type":"function","title":"wxListEvent.getColumn/1","doc":"The column position: it is only used with `COL` events.\n\nFor the column dragging events, it is the column to the left of the divider being\ndragged, for the column click events it may be -1 if the user clicked in the list control\nheader outside any column.","ref":"wxListEvent.html#getColumn/1"},{"type":"function","title":"wxListEvent.getData/1","doc":"The data.","ref":"wxListEvent.html#getData/1"},{"type":"function","title":"wxListEvent.getImage/1","doc":"The image.","ref":"wxListEvent.html#getImage/1"},{"type":"function","title":"wxListEvent.getIndex/1","doc":"The item index.","ref":"wxListEvent.html#getIndex/1"},{"type":"function","title":"wxListEvent.getItem/1","doc":"An item object, used by some events.\n\nSee also `wxListCtrl:setItem/5`.","ref":"wxListEvent.html#getItem/1"},{"type":"function","title":"wxListEvent.getKeyCode/1","doc":"Key code if the event is a keypress event.","ref":"wxListEvent.html#getKeyCode/1"},{"type":"function","title":"wxListEvent.getLabel/1","doc":"The (new) item label for `EVT_LIST_END_LABEL_EDIT` event.","ref":"wxListEvent.html#getLabel/1"},{"type":"function","title":"wxListEvent.getMask/1","doc":"The mask.","ref":"wxListEvent.html#getMask/1"},{"type":"function","title":"wxListEvent.getPoint/1","doc":"The position of the mouse pointer if the event is a drag event.","ref":"wxListEvent.html#getPoint/1"},{"type":"function","title":"wxListEvent.getText/1","doc":"The text.","ref":"wxListEvent.html#getText/1"},{"type":"function","title":"wxListEvent.isEditCancelled/1","doc":"This method only makes sense for `EVT\\_LIST\\_END\\_LABEL\\_EDIT` message and returns true\nif it the label editing has been cancelled by the user (`getLabel/1` returns an empty\nstring in this case but it doesn't allow the application to distinguish between really\ncancelling the edit and the admittedly rare case when the user wants to rename it to an\nempty string).","ref":"wxListEvent.html#isEditCancelled/1"},{"type":"type","title":"wxListEvent.wxList/0","doc":"","ref":"wxListEvent.html#t:wxList/0"},{"type":"type","title":"wxListEvent.wxListEvent/0","doc":"","ref":"wxListEvent.html#t:wxListEvent/0"},{"type":"type","title":"wxListEvent.wxListEventType/0","doc":"","ref":"wxListEvent.html#t:wxListEventType/0"},{"type":"module","title":"wxListItem","doc":"This class stores information about a `m:wxListCtrl` item or column.\n\n`m:wxListItem` is a class which contains information about:\n\n* Zero based item position; see `setId/2` and `getId/1`.\n\n* Zero based column index; see `setColumn/2` and `getColumn/1`.\n\n* The label (or header for columns); see `setText/2` and `getText/1`.\n\n* The zero based index into an image list; see `getImage/1` and `setImage/2`.\n\n* Application defined data; see `SetData()` (not implemented in wx) and `GetData()` (not\nimplemented in wx).\n\n* For columns only: the width of the column; see `setWidth/2` and `getWidth/1`.\n\n* For columns only: the format of the column; one of `wxLIST_FORMAT_LEFT`, `wxLIST_FORMAT_RIGHT`, `wxLIST_FORMAT_CENTRE`.\nSee `setAlign/2` and `getAlign/1`.\n\n* The state of the item; see `setState/2` and `getState/1`. This is a bitlist of the following flags:\n\n* `wxLIST_STATE_FOCUSED:` The item has the focus.\n\n* `wxLIST_STATE_SELECTED:` The item is selected.\n\n* `wxLIST_STATE_DONTCARE:` No special flags (the value of this constant is 0).\n\n* `wxLIST_STATE_DROPHILITED:` The item is highlighted to receive a drop event. Win32 only.\n\n* `wxLIST_STATE_CUT:` The item is in the cut state. Win32 only.\n\n* A mask indicating which state flags are valid; this is a bitlist of the flags reported\nabove for the item state. See `setStateMask/2` and GetStateMask().\n\n* A mask indicating which fields of this class are valid; see `setMask/2` and `getMask/1`. This is a bitlist of\nthe following flags:\n\n* `wxLIST_MASK_STATE:` The state field is valid.\n\n* `wxLIST_MASK_TEXT:` The label field is valid.\n\n* `wxLIST_MASK_IMAGE:` The image field is valid.\n\n* `wxLIST_MASK_DATA:` The application-defined data field is valid.\n\n* `wxLIST_MASK_WIDTH:` The column width field is valid.\n\n* `wxLIST_MASK_FORMAT:` The column format field is valid.\n\nThe `m:wxListItem` object can also contain item-specific colour and font information: for\nthis you need to call one of `setTextColour/2`, `setBackgroundColour/2` or `setFont/2` functions on it passing it the colour/font to use. If\nthe colour/font is not specified, the default list control colour/font is used.\n\nSee: `m:wxListCtrl`\n\nwxWidgets docs: [wxListItem](https://docs.wxwidgets.org/3.2/classwx_list_item.html)","ref":"wxListItem.html"},{"type":"function","title":"wxListItem.clear/1","doc":"Resets the item state to the default.","ref":"wxListItem.html#clear/1"},{"type":"function","title":"wxListItem.destroy/1","doc":"Destroys the object","ref":"wxListItem.html#destroy/1"},{"type":"function","title":"wxListItem.getAlign/1","doc":"Returns the alignment for this item.\n\nCan be one of `wxLIST_FORMAT_LEFT`, `wxLIST_FORMAT_RIGHT` or `wxLIST_FORMAT_CENTRE`.","ref":"wxListItem.html#getAlign/1"},{"type":"function","title":"wxListItem.getBackgroundColour/1","doc":"Returns the background colour for this item.","ref":"wxListItem.html#getBackgroundColour/1"},{"type":"function","title":"wxListItem.getColumn/1","doc":"Returns the zero-based column; meaningful only in report mode.","ref":"wxListItem.html#getColumn/1"},{"type":"function","title":"wxListItem.getFont/1","doc":"Returns the font used to display the item.","ref":"wxListItem.html#getFont/1"},{"type":"function","title":"wxListItem.getId/1","doc":"Returns the zero-based item position.","ref":"wxListItem.html#getId/1"},{"type":"function","title":"wxListItem.getImage/1","doc":"Returns the zero-based index of the image associated with the item into the image list.","ref":"wxListItem.html#getImage/1"},{"type":"function","title":"wxListItem.getMask/1","doc":"Returns a bit mask indicating which fields of the structure are valid.\n\nCan be any combination of the following values:\n\n* wxLIST_MASK_STATE: `GetState` is valid.\n\n* wxLIST_MASK_TEXT: `GetText` is valid.\n\n* wxLIST_MASK_IMAGE: `GetImage` is valid.\n\n* wxLIST_MASK_DATA: `GetData` is valid.\n\n* wxLIST_MASK_WIDTH: `GetWidth` is valid.\n\n* wxLIST_MASK_FORMAT: `GetFormat` is valid.","ref":"wxListItem.html#getMask/1"},{"type":"function","title":"wxListItem.getState/1","doc":"Returns a bit field representing the state of the item.\n\nCan be any combination of:\n\n* wxLIST_STATE_DONTCARE: No special flags (the values of this constant is 0).\n\n* wxLIST_STATE_DROPHILITED: The item is highlighted to receive a drop event. Win32 only.\n\n* wxLIST_STATE_FOCUSED: The item has the focus.\n\n* wxLIST_STATE_SELECTED: The item is selected.\n\n* wxLIST_STATE_CUT: The item is in the cut state. Win32 only.","ref":"wxListItem.html#getState/1"},{"type":"function","title":"wxListItem.getText/1","doc":"Returns the label/header text.","ref":"wxListItem.html#getText/1"},{"type":"function","title":"wxListItem.getTextColour/1","doc":"Returns the text colour.","ref":"wxListItem.html#getTextColour/1"},{"type":"function","title":"wxListItem.getWidth/1","doc":"Meaningful only for column headers in report mode.\n\nReturns the column width.","ref":"wxListItem.html#getWidth/1"},{"type":"function","title":"wxListItem.new/0","doc":"Constructor.","ref":"wxListItem.html#new/0"},{"type":"function","title":"wxListItem.new/1","doc":"","ref":"wxListItem.html#new/1"},{"type":"function","title":"wxListItem.setAlign/2","doc":"Sets the alignment for the item.\n\nSee also `getAlign/1`","ref":"wxListItem.html#setAlign/2"},{"type":"function","title":"wxListItem.setBackgroundColour/2","doc":"Sets the background colour for the item.","ref":"wxListItem.html#setBackgroundColour/2"},{"type":"function","title":"wxListItem.setColumn/2","doc":"Sets the zero-based column.\n\nMeaningful only in report mode.","ref":"wxListItem.html#setColumn/2"},{"type":"function","title":"wxListItem.setFont/2","doc":"Sets the font for the item.","ref":"wxListItem.html#setFont/2"},{"type":"function","title":"wxListItem.setId/2","doc":"Sets the zero-based item position.","ref":"wxListItem.html#setId/2"},{"type":"function","title":"wxListItem.setImage/2","doc":"Sets the zero-based index of the image associated with the item into the image list.","ref":"wxListItem.html#setImage/2"},{"type":"function","title":"wxListItem.setMask/2","doc":"Sets the mask of valid fields.\n\nSee `getMask/1`.","ref":"wxListItem.html#setMask/2"},{"type":"function","title":"wxListItem.setState/2","doc":"Sets the item state flags (note that the valid state flags are influenced by the value of\nthe state mask, see `setStateMask/2`).\n\nSee `getState/1` for valid flag values.","ref":"wxListItem.html#setState/2"},{"type":"function","title":"wxListItem.setStateMask/2","doc":"Sets the bitmask that is used to determine which of the state flags are to be set.\n\nSee also `setState/2`.","ref":"wxListItem.html#setStateMask/2"},{"type":"function","title":"wxListItem.setText/2","doc":"Sets the text label for the item.","ref":"wxListItem.html#setText/2"},{"type":"function","title":"wxListItem.setTextColour/2","doc":"Sets the text colour for the item.","ref":"wxListItem.html#setTextColour/2"},{"type":"function","title":"wxListItem.setWidth/2","doc":"Meaningful only for column headers in report mode.\n\nSets the column width.","ref":"wxListItem.html#setWidth/2"},{"type":"type","title":"wxListItem.wxListItem/0","doc":"","ref":"wxListItem.html#t:wxListItem/0"},{"type":"module","title":"wxListItemAttr","doc":"Functions for wxListItemAttr class\n\nwxWidgets docs: [wxListItemAttr](https://docs.wxwidgets.org/3.2/classwx_list_item_attr.html)","ref":"wxListItemAttr.html"},{"type":"function","title":"wxListItemAttr.destroy/1","doc":"Destroys the object","ref":"wxListItemAttr.html#destroy/1"},{"type":"function","title":"wxListItemAttr.getBackgroundColour/1","doc":"","ref":"wxListItemAttr.html#getBackgroundColour/1"},{"type":"function","title":"wxListItemAttr.getFont/1","doc":"","ref":"wxListItemAttr.html#getFont/1"},{"type":"function","title":"wxListItemAttr.getTextColour/1","doc":"","ref":"wxListItemAttr.html#getTextColour/1"},{"type":"function","title":"wxListItemAttr.hasBackgroundColour/1","doc":"","ref":"wxListItemAttr.html#hasBackgroundColour/1"},{"type":"function","title":"wxListItemAttr.hasFont/1","doc":"","ref":"wxListItemAttr.html#hasFont/1"},{"type":"function","title":"wxListItemAttr.hasTextColour/1","doc":"","ref":"wxListItemAttr.html#hasTextColour/1"},{"type":"function","title":"wxListItemAttr.new/0","doc":"","ref":"wxListItemAttr.html#new/0"},{"type":"function","title":"wxListItemAttr.new/3","doc":"","ref":"wxListItemAttr.html#new/3"},{"type":"function","title":"wxListItemAttr.setBackgroundColour/2","doc":"","ref":"wxListItemAttr.html#setBackgroundColour/2"},{"type":"function","title":"wxListItemAttr.setFont/2","doc":"","ref":"wxListItemAttr.html#setFont/2"},{"type":"function","title":"wxListItemAttr.setTextColour/2","doc":"","ref":"wxListItemAttr.html#setTextColour/2"},{"type":"type","title":"wxListItemAttr.wxListItemAttr/0","doc":"","ref":"wxListItemAttr.html#t:wxListItemAttr/0"},{"type":"module","title":"wxListView","doc":"This class currently simply presents a simpler to use interface for the `m:wxListCtrl` --\nit can be thought of as a `façade` for that complicated class.\n\nUsing it is preferable to using `m:wxListCtrl` directly whenever possible because in the\nfuture some ports might implement `m:wxListView` but not the full set of `m:wxListCtrl` features.\n\nOther than different interface, this class is identical to `m:wxListCtrl`. In particular,\nit uses the same events, same window styles and so on.\n\nSee: `setColumnImage/3`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxListView](https://docs.wxwidgets.org/3.2/classwx_list_view.html)","ref":"wxListView.html"},{"type":"function","title":"wxListView.clearColumnImage/2","doc":"Resets the column image -- after calling this function, no image will be shown.\n\nSee: `setColumnImage/3`","ref":"wxListView.html#clearColumnImage/2"},{"type":"function","title":"wxListView.focus/2","doc":"Sets focus to the item with the given `index`.","ref":"wxListView.html#focus/2"},{"type":"function","title":"wxListView.getFirstSelected/1","doc":"Returns the first selected item in a (presumably) multiple selection control.\n\nTogether with `getNextSelected/2` it can be used to iterate over all selected items in the control.\n\nReturn: The first selected item, if any, -1 otherwise.","ref":"wxListView.html#getFirstSelected/1"},{"type":"function","title":"wxListView.getFocusedItem/1","doc":"Returns the currently focused item or -1 if none.\n\nSee:\n* `isSelected/2`\n\n* `focus/2`","ref":"wxListView.html#getFocusedItem/1"},{"type":"function","title":"wxListView.getNextSelected/2","doc":"Used together with `getFirstSelected/1` to iterate over all selected items in the\ncontrol.\n\nReturn: Returns the next selected item or -1 if there are no more of them.","ref":"wxListView.html#getNextSelected/2"},{"type":"function","title":"wxListView.isSelected/2","doc":"Returns true if the item with the given `index` is selected, false otherwise.\n\nSee:\n* `getFirstSelected/1`\n\n* `getNextSelected/2`","ref":"wxListView.html#isSelected/2"},{"type":"function","title":"wxListView.select/2","doc":"Equivalent to  select(This, N, []) .","ref":"wxListView.html#select/2"},{"type":"function","title":"wxListView.select/3","doc":"Selects or unselects the given item.\n\nNotice that this method inherits the unusual behaviour of `wxListCtrl:setItemState/4` which sends a\nwxEVT_LIST_ITEM_SELECTED event when it is used to select an item, contrary to the usual\nrule that only the user actions result in selection.","ref":"wxListView.html#select/3"},{"type":"function","title":"wxListView.setColumnImage/3","doc":"Sets the column image for the specified column.\n\nTo use the column images, the control must have a valid image list with at least one image.","ref":"wxListView.html#setColumnImage/3"},{"type":"type","title":"wxListView.wxListView/0","doc":"","ref":"wxListView.html#t:wxListView/0"},{"type":"module","title":"wxListbook","doc":"`m:wxListbook` is a class similar to `m:wxNotebook` but which uses a `m:wxListCtrl` to\nshow the labels instead of the tabs.\n\nThe underlying `m:wxListCtrl` displays page labels in a one-column report view by\ndefault. Calling wxBookCtrl::SetImageList will implicitly switch the control to use an\nicon view.\n\nFor usage documentation of this class, please refer to the base abstract class\nwxBookCtrl. You can also use the page_samples_notebook to see `m:wxListbook` in action.","ref":"wxListbook.html"},{"type":"module","title":"Styles - wxListbook","doc":"This class supports the following styles:\n\n* wxLB_DEFAULT: Choose the default location for the labels depending on the current\nplatform (left everywhere except Mac where it is top).\n\n* wxLB_TOP: Place labels above the page area.\n\n* wxLB_LEFT: Place labels on the left side.\n\n* wxLB_RIGHT: Place labels on the right side.\n\n* wxLB_BOTTOM: Place labels below the page area.\n\nSee:\n* ?wxBookCtrl\n\n* `m:wxNotebook`\n\n* [Examples](https://docs.wxwidgets.org/3.2/page_samples.html#page_samples_notebook)\n\nThis class is derived, and can use functions, from:\n\n* `m:wxBookCtrlBase`\n\n* `m:wxControl`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxListbook](https://docs.wxwidgets.org/3.2/classwx_listbook.html)","ref":"wxListbook.html#module-styles"},{"type":"module","title":"Events - wxListbook","doc":"Event types emitted from this class:\n\n* [`listbook_page_changed`](`m:wxBookCtrlEvent`)\n\n* [`listbook_page_changing`](`m:wxBookCtrlEvent`)","ref":"wxListbook.html#module-events"},{"type":"function","title":"wxListbook.addPage/3","doc":"Equivalent to  addPage(This, Page, Text, []) .","ref":"wxListbook.html#addPage/3"},{"type":"function","title":"wxListbook.addPage/4","doc":"Adds a new page.\n\nThe page must have the book control itself as the parent and must not have been added to\nthis control previously.\n\nThe call to this function will generate the page changing and page changed events if `select`\nis true, but not when inserting the very first page (as there is no previous page\nselection to switch from in this case and so it wouldn't make sense to e.g. veto such event).\n\nReturn: true if successful, false otherwise.\n\nRemark: Do not delete the page, it will be deleted by the book control.\n\nSee: `insertPage/5`","ref":"wxListbook.html#addPage/4"},{"type":"function","title":"wxListbook.advanceSelection/1","doc":"Equivalent to  advanceSelection(This, []) .","ref":"wxListbook.html#advanceSelection/1"},{"type":"function","title":"wxListbook.advanceSelection/2","doc":"Cycles through the tabs.\n\nThe call to this function generates the page changing events.","ref":"wxListbook.html#advanceSelection/2"},{"type":"function","title":"wxListbook.assignImageList/2","doc":"Sets the image list for the page control and takes ownership of the list.\n\nSee:\n* `m:wxImageList`\n\n* `setImageList/2`","ref":"wxListbook.html#assignImageList/2"},{"type":"function","title":"wxListbook.changeSelection/2","doc":"Changes the selection to the given page, returning the previous selection.\n\nThis function behaves as `setSelection/2` but does `not` generate the page changing events.\n\nSee overview_events_prog for more information.","ref":"wxListbook.html#changeSelection/2"},{"type":"function","title":"wxListbook.create/3","doc":"Equivalent to  create(This, Parent, Id, []) .","ref":"wxListbook.html#create/3"},{"type":"function","title":"wxListbook.create/4","doc":"Create the list book control that has already been constructed with the default\nconstructor.","ref":"wxListbook.html#create/4"},{"type":"function","title":"wxListbook.deleteAllPages/1","doc":"Deletes all pages.","ref":"wxListbook.html#deleteAllPages/1"},{"type":"function","title":"wxListbook.destroy/1","doc":"Destroys the object","ref":"wxListbook.html#destroy/1"},{"type":"function","title":"wxListbook.getCurrentPage/1","doc":"Returns the currently selected page or NULL.","ref":"wxListbook.html#getCurrentPage/1"},{"type":"function","title":"wxListbook.getImageList/1","doc":"Returns the associated image list, may be NULL.\n\nSee:\n* `m:wxImageList`\n\n* `setImageList/2`","ref":"wxListbook.html#getImageList/1"},{"type":"function","title":"wxListbook.getPage/2","doc":"Returns the window at the given page position.","ref":"wxListbook.html#getPage/2"},{"type":"function","title":"wxListbook.getPageCount/1","doc":"Returns the number of pages in the control.","ref":"wxListbook.html#getPageCount/1"},{"type":"function","title":"wxListbook.getPageImage/2","doc":"Returns the image index for the given page.","ref":"wxListbook.html#getPageImage/2"},{"type":"function","title":"wxListbook.getPageText/2","doc":"Returns the string for the given page.","ref":"wxListbook.html#getPageText/2"},{"type":"function","title":"wxListbook.getSelection/1","doc":"Returns the currently selected page, or `wxNOT\\_FOUND` if none was selected.\n\nNote that this method may return either the previously or newly selected page when called\nfrom the `EVT_BOOKCTRL_PAGE_CHANGED` handler depending on the platform and so `wxBookCtrlEvent:getSelection/1` should be\nused instead in this case.","ref":"wxListbook.html#getSelection/1"},{"type":"function","title":"wxListbook.hitTest/2","doc":"Returns the index of the tab at the specified position or `wxNOT\\_FOUND` if none.\n\nIf `flags` parameter is non-NULL, the position of the point inside the tab is returned as well.\n\nReturn: Returns the zero-based tab index or `wxNOT_FOUND` if there is no tab at the\nspecified position.","ref":"wxListbook.html#hitTest/2"},{"type":"function","title":"wxListbook.insertPage/4","doc":"Equivalent to  insertPage(This, Index, Page, Text, []) .","ref":"wxListbook.html#insertPage/4"},{"type":"function","title":"wxListbook.insertPage/5","doc":"Inserts a new page at the specified position.\n\nReturn: true if successful, false otherwise.\n\nRemark: Do not delete the page, it will be deleted by the book control.\n\nSee: `addPage/4`","ref":"wxListbook.html#insertPage/5"},{"type":"function","title":"wxListbook.new/0","doc":"Default ctor.","ref":"wxListbook.html#new/0"},{"type":"function","title":"wxListbook.new/2","doc":"Equivalent to  new(Parent, Id, []) .","ref":"wxListbook.html#new/2"},{"type":"function","title":"wxListbook.new/3","doc":"Constructs a listbook control.","ref":"wxListbook.html#new/3"},{"type":"function","title":"wxListbook.setImageList/2","doc":"Sets the image list to use.\n\nIt does not take ownership of the image list, you must delete it yourself.\n\nSee:\n* `m:wxImageList`\n\n* `assignImageList/2`","ref":"wxListbook.html#setImageList/2"},{"type":"function","title":"wxListbook.setPageImage/3","doc":"Sets the image index for the given page.\n\n`image` is an index into the image list which was set with `setImageList/2`.","ref":"wxListbook.html#setPageImage/3"},{"type":"function","title":"wxListbook.setPageSize/2","doc":"Sets the width and height of the pages.\n\nNote: This method is currently not implemented for wxGTK.","ref":"wxListbook.html#setPageSize/2"},{"type":"function","title":"wxListbook.setPageText/3","doc":"Sets the text for the given page.","ref":"wxListbook.html#setPageText/3"},{"type":"function","title":"wxListbook.setSelection/2","doc":"Sets the selection to the given page, returning the previous selection.\n\nNotice that the call to this function generates the page changing events, use the `changeSelection/2`\nfunction if you don't want these events to be generated.\n\nSee: `getSelection/1`","ref":"wxListbook.html#setSelection/2"},{"type":"type","title":"wxListbook.wxListbook/0","doc":"","ref":"wxListbook.html#t:wxListbook/0"},{"type":"module","title":"wxLocale","doc":"`m:wxLocale` class encapsulates all language-dependent settings and is a generalization\nof the C locale concept.\n\nIn wxWidgets this class manages current locale. It also initializes and activates `wxTranslations`\n(not implemented in wx) object that manages message catalogs.\n\nFor a list of the supported languages, please see ?wxLanguage enum values. These\nconstants may be used to specify the language in `init/3` and are returned by `getSystemLanguage/0`.\n\nSee:\n* [Overview i18n](https://docs.wxwidgets.org/3.2/overview_i18n.html#overview_i18n)\n\n* [Examples](https://docs.wxwidgets.org/3.2/page_samples.html#page_samples_internat)\n\nwxWidgets docs: [wxLocale](https://docs.wxwidgets.org/3.2/classwx_locale.html)","ref":"wxLocale.html"},{"type":"function","title":"wxLocale.addCatalog/2","doc":"Calls wxTranslations::AddCatalog(const wxString&).","ref":"wxLocale.html#addCatalog/2"},{"type":"function","title":"wxLocale.addCatalog/3","doc":"Calls `wxTranslations::AddCatalog(const wxString&, wxLanguage)` (not implemented in wx).","ref":"wxLocale.html#addCatalog/3"},{"type":"function","title":"wxLocale.addCatalog/4","doc":"Calls `wxTranslations::AddCatalog(const wxString&, wxLanguage, const wxString&)` (not\nimplemented in wx).","ref":"wxLocale.html#addCatalog/4"},{"type":"function","title":"wxLocale.addCatalogLookupPathPrefix/1","doc":"Calls `wxFileTranslationsLoader::AddCatalogLookupPathPrefix()` (not implemented in wx).","ref":"wxLocale.html#addCatalogLookupPathPrefix/1"},{"type":"function","title":"wxLocale.destroy/1","doc":"Destroys the object","ref":"wxLocale.html#destroy/1"},{"type":"function","title":"wxLocale.getCanonicalName/1","doc":"Returns the canonical form of current locale name.\n\nCanonical form is the one that is used on UNIX systems: it is a two- or five-letter\nstring in xx or xx_YY format, where xx is ISO 639 code of language and YY is ISO 3166 code\nof the country. Examples are \"en\", \"en_GB\", \"en_US\" or \"fr_FR\". This form is internally\nused when looking up message catalogs. Compare `getSysName/1`.","ref":"wxLocale.html#getCanonicalName/1"},{"type":"function","title":"wxLocale.getHeaderValue/2","doc":"Equivalent to  getHeaderValue(This, Header, []) .","ref":"wxLocale.html#getHeaderValue/2"},{"type":"function","title":"wxLocale.getHeaderValue/3","doc":"Calls `wxTranslations::GetHeaderValue()` (not implemented in wx).","ref":"wxLocale.html#getHeaderValue/3"},{"type":"function","title":"wxLocale.getLanguage/1","doc":"Returns the ?wxLanguage constant of current language.\n\nNote that you can call this function only if you used the form of `init/3` that takes ?wxLanguage\nargument.","ref":"wxLocale.html#getLanguage/1"},{"type":"function","title":"wxLocale.getLanguageName/1","doc":"Returns English name of the given language or empty string if this language is unknown.\n\nSee `GetLanguageInfo()` (not implemented in wx) for a remark about special meaning of `wxLANGUAGE_DEFAULT`.","ref":"wxLocale.html#getLanguageName/1"},{"type":"function","title":"wxLocale.getLocale/1","doc":"Returns the locale name as passed to the constructor or `init/3`.\n\nThis is a full, human-readable name, e.g. \"English\" or \"French\".","ref":"wxLocale.html#getLocale/1"},{"type":"function","title":"wxLocale.getName/1","doc":"Returns the current short name for the locale (as given to the constructor or the `init/3`\nfunction).","ref":"wxLocale.html#getName/1"},{"type":"function","title":"wxLocale.getString/2","doc":"Equivalent to  getString(This, OrigString, []) .","ref":"wxLocale.html#getString/2"},{"type":"function","title":"wxLocale.getString/3","doc":"Calls wxGetTranslation(const wxString&, const wxString&).","ref":"wxLocale.html#getString/3"},{"type":"function","title":"wxLocale.getString/4","doc":"Equivalent to  getString(This, OrigString, OrigString2, N, []) .","ref":"wxLocale.html#getString/4"},{"type":"function","title":"wxLocale.getString/5","doc":"Calls wxGetTranslation(const wxString&, const wxString&, unsigned, const wxString&).","ref":"wxLocale.html#getString/5"},{"type":"function","title":"wxLocale.getSysName/1","doc":"Returns current platform-specific locale name as passed to setlocale().\n\nCompare `getCanonicalName/1`.","ref":"wxLocale.html#getSysName/1"},{"type":"function","title":"wxLocale.getSystemEncoding/0","doc":"Tries to detect the user's default font encoding.\n\nReturns ?wxFontEncoding() value or `wxFONTENCODING_SYSTEM` if it couldn't be determined.","ref":"wxLocale.html#getSystemEncoding/0"},{"type":"function","title":"wxLocale.getSystemEncodingName/0","doc":"Tries to detect the name of the user's default font encoding.\n\nThis string isn't particularly useful for the application as its form is\nplatform-dependent and so you should probably use `getSystemEncoding/0` instead.\n\nReturns a user-readable string value or an empty string if it couldn't be determined.","ref":"wxLocale.html#getSystemEncodingName/0"},{"type":"function","title":"wxLocale.getSystemLanguage/0","doc":"Tries to detect the user's default locale setting.\n\nReturns the ?wxLanguage value or `wxLANGUAGE_UNKNOWN` if the language-guessing algorithm failed.\n\nNote: This function works with `locales` and returns the user's default locale. This may\nbe, and usually is, the same as their preferred UI language, but it's not the same thing.\nUse wxTranslation to obtain `language` information.","ref":"wxLocale.html#getSystemLanguage/0"},{"type":"function","title":"wxLocale.init/1","doc":"Equivalent to  init(This, []) .","ref":"wxLocale.html#init/1"},{"type":"function","title":"wxLocale.init/2","doc":"Initializes the `m:wxLocale` instance.\n\nThe call of this function has several global side effects which you should understand:\nfirst of all, the application locale is changed - note that this will affect many of\nstandard C library functions such as printf() or strftime(). Second, this `m:wxLocale`\nobject becomes the new current global locale for the application and so all subsequent\ncalls to ?wxGetTranslation() will try to translate the messages using the message catalogs\nfor this locale.\n\nReturn: true on success or false if the given locale couldn't be set.","ref":"wxLocale.html#init/2"},{"type":"function","title":"wxLocale.init/3","doc":"Deprecated:\n\nThis form is deprecated, use the other one unless you know what you are doing.","ref":"wxLocale.html#init/3"},{"type":"function","title":"wxLocale.isLoaded/2","doc":"Calls `wxTranslations::IsLoaded()` (not implemented in wx).","ref":"wxLocale.html#isLoaded/2"},{"type":"function","title":"wxLocale.isOk/1","doc":"Returns true if the locale could be set successfully.","ref":"wxLocale.html#isOk/1"},{"type":"function","title":"wxLocale.new/0","doc":"This is the default constructor and it does nothing to initialize the object: `init/3`\nmust be used to do that.","ref":"wxLocale.html#new/0"},{"type":"function","title":"wxLocale.new/1","doc":"Equivalent to: `new/2`","ref":"wxLocale.html#new/1"},{"type":"function","title":"wxLocale.new/2","doc":"See `init/3` for parameters description.\n\nThe call of this function has several global side effects which you should understand:\nfirst of all, the application locale is changed - note that this will affect many of\nstandard C library functions such as printf() or strftime(). Second, this `m:wxLocale`\nobject becomes the new current global locale for the application and so all subsequent\ncalls to ?wxGetTranslation() will try to translate the messages using the message catalogs\nfor this locale.","ref":"wxLocale.html#new/2"},{"type":"type","title":"wxLocale.wxLocale/0","doc":"","ref":"wxLocale.html#t:wxLocale/0"},{"type":"module","title":"wxLogNull","doc":"This class allows you to temporarily suspend logging.\n\nAll calls to the log functions during the life time of an object of this class are just ignored.\n\nIn particular, it can be used to suppress the log messages given by wxWidgets itself but\nit should be noted that it is rarely the best way to cope with this problem as `all` log\nmessages are suppressed, even if they indicate a completely different error than the one\nthe programmer wanted to suppress.\n\nFor instance, the example of the overview:\n\nwould be better written as:\n\nwxWidgets docs: [wxLogNull](https://docs.wxwidgets.org/3.2/classwx_log_null.html)","ref":"wxLogNull.html"},{"type":"function","title":"wxLogNull.destroy/1","doc":"Destroys the object","ref":"wxLogNull.html#destroy/1"},{"type":"function","title":"wxLogNull.new/0","doc":"Suspends logging.","ref":"wxLogNull.html#new/0"},{"type":"type","title":"wxLogNull.wxLogNull/0","doc":"","ref":"wxLogNull.html#t:wxLogNull/0"},{"type":"module","title":"wxMDIChildFrame","doc":"An MDI child frame is a frame that can only exist inside a `m:wxMDIClientWindow`, which\nis itself a child of `m:wxMDIParentFrame`.","ref":"wxMDIChildFrame.html"},{"type":"module","title":"Styles - wxMDIChildFrame","doc":"This class supports the following styles:\n\nAll of the standard `m:wxFrame` styles can be used but most of them are ignored by\nTDI-based MDI implementations.\n\nRemark: Although internally an MDI child frame is a child of the MDI client window, in\nwxWidgets you create it as a child of `m:wxMDIParentFrame`. In fact, you can usually\nforget that the client window exists. MDI child frames are clipped to the area of the MDI\nclient window, and may be iconized on the client window. You can associate a menubar with\na child frame as usual, although an MDI child doesn't display its menubar under its own\ntitle bar. The MDI parent frame's menubar will be changed to reflect the currently active\nchild frame. If there are currently no children, the parent frame's own menubar will be displayed.\n\nSee:\n* `m:wxMDIClientWindow`\n\n* `m:wxMDIParentFrame`\n\n* `m:wxFrame`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxFrame`\n\n* `m:wxTopLevelWindow`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxMDIChildFrame](https://docs.wxwidgets.org/3.2/classwx_m_d_i_child_frame.html)","ref":"wxMDIChildFrame.html#module-styles"},{"type":"function","title":"wxMDIChildFrame.activate/1","doc":"Activates this MDI child frame.\n\nSee:\n* `maximize/2`\n\n* `restore/1`","ref":"wxMDIChildFrame.html#activate/1"},{"type":"function","title":"wxMDIChildFrame.create/4","doc":"Equivalent to  create(This, Parent, Id, Title, []) .","ref":"wxMDIChildFrame.html#create/4"},{"type":"function","title":"wxMDIChildFrame.create/5","doc":"Used in two-step frame construction.\n\nSee `new/4` for further details.","ref":"wxMDIChildFrame.html#create/5"},{"type":"function","title":"wxMDIChildFrame.destroy/1","doc":"Destroys the object","ref":"wxMDIChildFrame.html#destroy/1"},{"type":"function","title":"wxMDIChildFrame.maximize/1","doc":"Equivalent to  maximize(This, []) .","ref":"wxMDIChildFrame.html#maximize/1"},{"type":"function","title":"wxMDIChildFrame.maximize/2","doc":"Maximizes this MDI child frame.\n\nThis function doesn't do anything if `IsAlwaysMaximized()` (not implemented in wx)\nreturns true.\n\nSee:\n* `activate/1`\n\n* `restore/1`","ref":"wxMDIChildFrame.html#maximize/2"},{"type":"function","title":"wxMDIChildFrame.new/0","doc":"Default constructor.","ref":"wxMDIChildFrame.html#new/0"},{"type":"function","title":"wxMDIChildFrame.new/3","doc":"Equivalent to  new(Parent, Id, Title, []) .","ref":"wxMDIChildFrame.html#new/3"},{"type":"function","title":"wxMDIChildFrame.new/4","doc":"Constructor, creating the window.\n\nSee: `create/5`","ref":"wxMDIChildFrame.html#new/4"},{"type":"function","title":"wxMDIChildFrame.restore/1","doc":"Restores this MDI child frame (unmaximizes).\n\nThis function doesn't do anything if `IsAlwaysMaximized()` (not implemented in wx)\nreturns true.\n\nSee:\n* `activate/1`\n\n* `maximize/2`","ref":"wxMDIChildFrame.html#restore/1"},{"type":"type","title":"wxMDIChildFrame.wxMDIChildFrame/0","doc":"","ref":"wxMDIChildFrame.html#t:wxMDIChildFrame/0"},{"type":"module","title":"wxMDIClientWindow","doc":"An MDI client window is a child of `m:wxMDIParentFrame`, and manages zero or more `m:wxMDIChildFrame`\nobjects.\n\nThe client window is the area where MDI child windows exist. It doesn't have to cover\nthe whole parent frame; other windows such as toolbars and a help window might coexist\nwith it. There can be scrollbars on a client window, which are controlled by the parent\nwindow style.\n\nThe `m:wxMDIClientWindow` class is usually adequate without further derivation, and it is\ncreated automatically when the MDI parent frame is created. If the application needs to\nderive a new class, the function `wxMDIParentFrame::OnCreateClient()` (not implemented in\nwx) must be overridden in order to give an opportunity to use a different class of client window.\n\nUnder wxMSW, the client window will automatically have a sunken border style when the\nactive child is not maximized, and no border style when a child is maximized.\n\nSee:\n* `m:wxMDIChildFrame`\n\n* `m:wxMDIParentFrame`\n\n* `m:wxFrame`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxMDIClientWindow](https://docs.wxwidgets.org/3.2/classwx_m_d_i_client_window.html)","ref":"wxMDIClientWindow.html"},{"type":"function","title":"wxMDIClientWindow.createClient/2","doc":"Equivalent to  createClient(This, Parent, []) .","ref":"wxMDIClientWindow.html#createClient/2"},{"type":"function","title":"wxMDIClientWindow.createClient/3","doc":"Called by `m:wxMDIParentFrame` immediately after creating the client window.\n\nThis function may be overridden in the derived class but the base class version must\nusually be called first to really create the window.","ref":"wxMDIClientWindow.html#createClient/3"},{"type":"function","title":"wxMDIClientWindow.destroy/1","doc":"Destroys the object","ref":"wxMDIClientWindow.html#destroy/1"},{"type":"function","title":"wxMDIClientWindow.new/0","doc":"Default constructor.\n\nObjects of this class are only created by `m:wxMDIParentFrame` which uses the default\nconstructor and calls `createClient/3` immediately afterwards.","ref":"wxMDIClientWindow.html#new/0"},{"type":"type","title":"wxMDIClientWindow.wxMDIClientWindow/0","doc":"","ref":"wxMDIClientWindow.html#t:wxMDIClientWindow/0"},{"type":"module","title":"wxMDIParentFrame","doc":"An MDI (Multiple Document Interface) parent frame is a window which can contain MDI child\nframes in its client area which emulates the full desktop.\n\nMDI is a user-interface model in which all the window reside inside the single parent\nwindow as opposed to being separate from each other. It remains popular despite dire\nwarnings from Microsoft itself (which popularized this model in the first model) that MDI\nis obsolete.\n\nAn MDI parent frame always has a `m:wxMDIClientWindow` associated with it, which is the\nparent for MDI child frames. In the simplest case, the client window takes up the entire\nparent frame area but it is also possible to resize it to be smaller in order to have\nother windows in the frame, a typical example is using a sidebar along one of the window edges.\n\nThe appearance of MDI applications differs between different ports. The classic MDI\nmodel, with child windows which can be independently moved, resized etc, is only available\nunder MSW, which provides native support for it. In Mac ports, multiple top level windows\nare used for the MDI children too and the MDI parent frame itself is invisible, to\naccommodate the native look and feel requirements. In all the other ports, a tab-based MDI\nimplementation (sometimes called TDI) is used and so at most one MDI child is visible at\nany moment (child frames are always maximized).\n\nAlthough it is possible to have multiple MDI parent frames, a typical MDI application\nhas a single MDI parent frame window inside which multiple MDI child frames, i.e. objects\nof class `m:wxMDIChildFrame`, can be created.","ref":"wxMDIParentFrame.html"},{"type":"module","title":"Styles - wxMDIParentFrame","doc":"This class supports the following styles:\n\nThere are no special styles for this class, all `m:wxFrame` styles apply to it in the\nusual way. The only exception is that wxHSCROLL and wxVSCROLL styles apply not to the\nframe itself but to the client window, so that using them enables horizontal and vertical\nscrollbars for this window and not the frame.\n\nSee:\n* `m:wxMDIChildFrame`\n\n* `m:wxMDIClientWindow`\n\n* `m:wxFrame`\n\n* `m:wxDialog`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxFrame`\n\n* `m:wxTopLevelWindow`\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxMDIParentFrame](https://docs.wxwidgets.org/3.2/classwx_m_d_i_parent_frame.html)","ref":"wxMDIParentFrame.html#module-styles"},{"type":"function","title":"wxMDIParentFrame.activateNext/1","doc":"Activates the MDI child following the currently active one.\n\nThe MDI children are maintained in an ordered list and this function switches to the next\nelement in this list, wrapping around the end of it if the currently active child is the\nlast one.\n\nSee: `activatePrevious/1`","ref":"wxMDIParentFrame.html#activateNext/1"},{"type":"function","title":"wxMDIParentFrame.activatePrevious/1","doc":"Activates the MDI child preceding the currently active one.\n\nSee: `activateNext/1`","ref":"wxMDIParentFrame.html#activatePrevious/1"},{"type":"function","title":"wxMDIParentFrame.arrangeIcons/1","doc":"Arranges any iconized (minimized) MDI child windows.\n\nThis method is only implemented in MSW MDI implementation and does nothing under the\nother platforms.\n\nSee:\n* `cascade/1`\n\n* `tile/2`","ref":"wxMDIParentFrame.html#arrangeIcons/1"},{"type":"function","title":"wxMDIParentFrame.cascade/1","doc":"Arranges the MDI child windows in a cascade.\n\nThis method is only implemented in MSW MDI implementation and does nothing under the\nother platforms.\n\nSee:\n* `tile/2`\n\n* `arrangeIcons/1`","ref":"wxMDIParentFrame.html#cascade/1"},{"type":"function","title":"wxMDIParentFrame.create/4","doc":"Equivalent to  create(This, Parent, Id, Title, []) .","ref":"wxMDIParentFrame.html#create/4"},{"type":"function","title":"wxMDIParentFrame.create/5","doc":"Used in two-step frame construction.\n\nSee `new/4` for further details.","ref":"wxMDIParentFrame.html#create/5"},{"type":"function","title":"wxMDIParentFrame.destroy/1","doc":"Destroys the object","ref":"wxMDIParentFrame.html#destroy/1"},{"type":"function","title":"wxMDIParentFrame.getActiveChild/1","doc":"Returns a pointer to the active MDI child, if there is one.\n\nIf there are any children at all this function returns a non-NULL pointer.","ref":"wxMDIParentFrame.html#getActiveChild/1"},{"type":"function","title":"wxMDIParentFrame.getClientWindow/1","doc":"Returns a pointer to the client window.","ref":"wxMDIParentFrame.html#getClientWindow/1"},{"type":"function","title":"wxMDIParentFrame.new/0","doc":"Default constructor.\n\nUse `create/5` for the objects created using this constructor.","ref":"wxMDIParentFrame.html#new/0"},{"type":"function","title":"wxMDIParentFrame.new/3","doc":"Equivalent to  new(Parent, Id, Title, []) .","ref":"wxMDIParentFrame.html#new/3"},{"type":"function","title":"wxMDIParentFrame.new/4","doc":"Constructor, creating the window.\n\nNotice that if you override virtual `OnCreateClient()` (not implemented in wx) method you\nshouldn't be using this constructor but the default constructor and `create/5` as otherwise your\noverridden method is never going to be called because of the usual C++ virtual call\nresolution rules.\n\nUnder wxMSW, the client window will automatically have a sunken border style when the\nactive child is not maximized, and no border style when a child is maximized.\n\nSee: `create/5`","ref":"wxMDIParentFrame.html#new/4"},{"type":"function","title":"wxMDIParentFrame.tile/1","doc":"Equivalent to  tile(This, []) .","ref":"wxMDIParentFrame.html#tile/1"},{"type":"function","title":"wxMDIParentFrame.tile/2","doc":"Tiles the MDI child windows either horizontally or vertically depending on whether `orient`\nis `wxHORIZONTAL` or `wxVERTICAL`.\n\nThis method is only implemented in MSW MDI implementation and does nothing under the\nother platforms.","ref":"wxMDIParentFrame.html#tile/2"},{"type":"type","title":"wxMDIParentFrame.wxMDIParentFrame/0","doc":"","ref":"wxMDIParentFrame.html#t:wxMDIParentFrame/0"},{"type":"module","title":"wxMask","doc":"This class encapsulates a monochrome mask bitmap, where the masked area is black and the\nunmasked area is white.\n\nWhen associated with a bitmap and drawn in a device context, the unmasked area of the\nbitmap will be drawn, and the masked area will not be drawn.\n\nNote: A mask can be associated also with a bitmap with an alpha channel but drawing such\nbitmaps under wxMSW may be slow so using them should be avoided if drawing performance is\nan important factor.\n\nSee:\n* `m:wxBitmap`\n\n* `wxDC:blit/6`\n\n* `m:wxMemoryDC`\n\nwxWidgets docs: [wxMask](https://docs.wxwidgets.org/3.2/classwx_mask.html)","ref":"wxMask.html"},{"type":"function","title":"wxMask.create/2","doc":"Constructs a mask from a monochrome bitmap.","ref":"wxMask.html#create/2"},{"type":"function","title":"wxMask.create/3","doc":"Constructs a mask from a bitmap and a colour that indicates the background.","ref":"wxMask.html#create/3"},{"type":"function","title":"wxMask.destroy/1","doc":"Destroys the object","ref":"wxMask.html#destroy/1"},{"type":"function","title":"wxMask.new/0","doc":"Default constructor.","ref":"wxMask.html#new/0"},{"type":"function","title":"wxMask.new/1","doc":"Constructs a mask from a monochrome bitmap.","ref":"wxMask.html#new/1"},{"type":"function","title":"wxMask.new/2","doc":"Constructs a mask from a bitmap and a colour that indicates the background.","ref":"wxMask.html#new/2"},{"type":"type","title":"wxMask.wxMask/0","doc":"","ref":"wxMask.html#t:wxMask/0"},{"type":"module","title":"wxMaximizeEvent","doc":"An event being sent when a top level window is maximized.\n\nNotice that it is not sent when the window is restored to its original size after it had\nbeen maximized, only a normal `m:wxSizeEvent` is generated in this case.\n\nCurrently this event is only generated in wxMSW, wxGTK and wxOSX/Cocoa ports so portable\nprograms should only rely on receiving `wxEVT_SIZE` and not necessarily this event when\nthe window is maximized.\n\nSee:\n* [Overview events](https://docs.wxwidgets.org/3.2/overview_events.html#overview_events)\n\n* `wxTopLevelWindow:maximize/2`\n\n* `wxTopLevelWindow:isMaximized/1`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxEvent`\n\nwxWidgets docs: [wxMaximizeEvent](https://docs.wxwidgets.org/3.2/classwx_maximize_event.html)","ref":"wxMaximizeEvent.html"},{"type":"module","title":"Events - wxMaximizeEvent","doc":"Use `wxEvtHandler:connect/3` with `wxMaximizeEventType` to subscribe to events of this type.","ref":"wxMaximizeEvent.html#module-events"},{"type":"type","title":"wxMaximizeEvent.wxMaximize/0","doc":"","ref":"wxMaximizeEvent.html#t:wxMaximize/0"},{"type":"type","title":"wxMaximizeEvent.wxMaximizeEvent/0","doc":"","ref":"wxMaximizeEvent.html#t:wxMaximizeEvent/0"},{"type":"type","title":"wxMaximizeEvent.wxMaximizeEventType/0","doc":"","ref":"wxMaximizeEvent.html#t:wxMaximizeEventType/0"},{"type":"module","title":"wxMemoryDC","doc":"A memory device context provides a means to draw graphics onto a bitmap.\n\nWhen drawing in to a mono-bitmap, using `wxWHITE`, `wxWHITE_PEN` and `wxWHITE_BRUSH` will\ndraw the background colour (i.e. 0) whereas all other colours will draw the foreground\ncolour (i.e. 1).\n\nA bitmap must be selected into the new memory DC before it may be used for anything.\nTypical usage is as follows:\n\nNote that the memory DC must be deleted (or the bitmap selected out of it) before a\nbitmap can be reselected into another memory DC.\n\nAnd, before performing any other operations on the bitmap data, the bitmap must be\nselected out of the memory DC:\n\nThis happens automatically when `m:wxMemoryDC` object goes out of scope.\n\nSee:\n* `m:wxBitmap`\n\n* `m:wxDC`\n\nThis class is derived, and can use functions, from:\n\n* `m:wxDC`\n\nwxWidgets docs: [wxMemoryDC](https://docs.wxwidgets.org/3.2/classwx_memory_d_c.html)","ref":"wxMemoryDC.html"},{"type":"function","title":"wxMemoryDC.destroy/1","doc":"Destroys the object","ref":"wxMemoryDC.html#destroy/1"},{"type":"function","title":"wxMemoryDC.new/0","doc":"Constructs a new memory device context.\n\nUse the `wxDC:isOk/1` member to test whether the constructor was successful in creating a usable\ndevice context. Don't forget to select a bitmap into the DC before drawing on it.","ref":"wxMemoryDC.html#new/0"},{"type":"function","title":"wxMemoryDC.new/1","doc":"Constructs a new memory device context having the same characteristics as the given\nexisting device context.\n\nThis constructor creates a memory device context `compatible` with `dc` in wxMSW, the\nargument is ignored in the other ports. If `dc` is NULL, a device context compatible with\nthe screen is created, just as with the default constructor.","ref":"wxMemoryDC.html#new/1"},{"type":"function","title":"wxMemoryDC.selectObject/2","doc":"Works exactly like `selectObjectAsSource/2` but this is the function you should use when\nyou select a bitmap because you want to modify it, e.g.\n\ndrawing on this DC.\n\nUsing `selectObjectAsSource/2` when modifying the bitmap may incur some problems related to `m:wxBitmap` being a\nreference counted object (see overview_refcount).\n\nBefore using the updated bitmap data, make sure to select it out of context first either\nby selecting ?wxNullBitmap into the device context or destroying the device context entirely.\n\nIf the bitmap is already selected in this device context, nothing is done. If it is\nselected in another context, the function asserts and drawing on the bitmap won't work correctly.\n\nSee: `wxDC:drawBitmap/4`","ref":"wxMemoryDC.html#selectObject/2"},{"type":"function","title":"wxMemoryDC.selectObjectAsSource/2","doc":"Selects the given bitmap into the device context, to use as the memory bitmap.\n\nSelecting the bitmap into a memory DC allows you to draw into the DC (and therefore the\nbitmap) and also to use `wxDC:blit/6` to copy the bitmap to a window. For this purpose, you may find `wxDC:drawIcon/3`\neasier to use instead.\n\nIf the argument is ?wxNullBitmap (or some other uninitialised `m:wxBitmap`) the current\nbitmap is selected out of the device context, and the original bitmap restored, allowing\nthe current bitmap to be destroyed safely.","ref":"wxMemoryDC.html#selectObjectAsSource/2"},{"type":"type","title":"wxMemoryDC.wxMemoryDC/0","doc":"","ref":"wxMemoryDC.html#t:wxMemoryDC/0"},{"type":"module","title":"wxMenu","doc":"A menu is a popup (or pull down) list of items, one of which may be selected before the\nmenu goes away (clicking elsewhere dismisses the menu).\n\nMenus may be used to construct either menu bars or popup menus.\n\nA menu item has an integer ID associated with it which can be used to identify the\nselection, or to change the menu item in some way. A menu item with a special identifier `wxID_SEPARATOR`\nis a separator item and doesn't have an associated command but just makes a separator\nline appear in the menu.\n\nNote: Please note that `wxID_ABOUT` and `wxID_EXIT` are predefined by wxWidgets and have\na special meaning since entries using these IDs will be taken out of the normal menus\nunder macOS and will be inserted into the system menu (following the appropriate macOS\ninterface guideline).\n\nMenu items may be either `normal` items, `check` items or `radio` items. Normal items\ndon't have any special properties while the check items have a boolean flag associated to\nthem and they show a checkmark in the menu when the flag is set. wxWidgets automatically\ntoggles the flag value when the item is clicked and its value may be retrieved using\neither `isChecked/2` method of `m:wxMenu` or `m:wxMenuBar` itself or by using wxEvent::IsChecked when\nyou get the menu notification for the item in question.\n\nThe radio items are similar to the check items except that all the other items in the\nsame radio group are unchecked when a radio item is checked. The radio group is formed by\na contiguous range of radio items, i.e. it starts at the first item of this kind and ends\nwith the first item of a different kind (or the end of the menu). Notice that because the\nradio groups are defined in terms of the item positions inserting or removing the items in\nthe menu containing the radio items risks to not work correctly.\n\nAllocation strategy\n\nAll menus must be created on the `heap` because all menus attached to a menubar or to\nanother menu will be deleted by their parent when it is deleted. The only exception to\nthis rule are the popup menus (i.e. menus used with `wxWindow:popupMenu/4`) as wxWidgets does not destroy them\nto allow reusing the same menu more than once. But the exception applies only to the menus\nthemselves and not to any submenus of popup menus which are still destroyed by wxWidgets\nas usual and so must be heap-allocated.\n\nAs the frame menubar is deleted by the frame itself, it means that normally all menus\nused are deleted automatically.\n\nEvent handling\n\nEvent handlers for the commands generated by the menu items can be connected directly to\nthe menu object itself using `wxEvtHandler::Bind()` (not implemented in wx). If this menu\nis a submenu of another one, the events from its items can also be processed in the parent\nmenu and so on, recursively.\n\nIf the menu is part of a menu bar, then events can also be handled in `m:wxMenuBar` object.\n\nFinally, menu events can also be handled in the associated window, which is either the `m:wxFrame`\nassociated with the menu bar this menu belongs to or the window for which `wxWindow:popupMenu/4` was called for\nthe popup menus.\n\nSee overview_events_bind for how to bind event handlers to the various objects.\n\nSee:\n* `m:wxMenuBar`\n\n* `wxWindow:popupMenu/4`\n\n* [Overview events](https://docs.wxwidgets.org/3.2/overview_events.html#overview_events)\n\nThis class is derived, and can use functions, from:\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxMenu](https://docs.wxwidgets.org/3.2/classwx_menu.html)","ref":"wxMenu.html"},{"type":"function","title":"wxMenu.append/2","doc":"Adds a menu item object.\n\nThis is the most generic variant of `append/5` method because it may be used for both items\n(including separators) and submenus and because you can also specify various extra\nproperties of a menu item this way, such as bitmaps and fonts.\n\nRemark: See the remarks for the other `append/5` overloads.\n\nSee:\n* `appendSeparator/1`\n\n* `appendCheckItem/4`\n\n* `appendRadioItem/4`\n\n* `insert/6`\n\n* `setLabel/3`\n\n* `getHelpString/2`\n\n* `setHelpString/3`\n\n* `m:wxMenuItem`","ref":"wxMenu.html#append/2"},{"type":"function","title":"wxMenu.append/3","doc":"Equivalent to  append(This, Id, Item, []) .","ref":"wxMenu.html#append/3"},{"type":"function","title":"wxMenu.append/4","doc":"Adds a menu item.\n\nExample: or even better for stock menu items (see `wxMenuItem:new/1`):\n\nRemark: This command can be used after the menu has been shown, as well as on initial\ncreation of a menu or menubar.\n\nSee:\n* `appendSeparator/1`\n\n* `appendCheckItem/4`\n\n* `appendRadioItem/4`\n\n* `insert/6`\n\n* `setLabel/3`\n\n* `getHelpString/2`\n\n* `setHelpString/3`\n\n* `m:wxMenuItem`","ref":"wxMenu.html#append/4"},{"type":"function","title":"wxMenu.append/5","doc":"Adds a submenu.\n\nDeprecated:\n\nThis function is deprecated, use `AppendSubMenu()` (not implemented in wx) instead.\n\nSee:\n* `appendSeparator/1`\n\n* `appendCheckItem/4`\n\n* `appendRadioItem/4`\n\n* `insert/6`\n\n* `setLabel/3`\n\n* `getHelpString/2`\n\n* `setHelpString/3`\n\n* `m:wxMenuItem`","ref":"wxMenu.html#append/5"},{"type":"function","title":"wxMenu.appendCheckItem/3","doc":"Equivalent to  appendCheckItem(This, Id, Item, []) .","ref":"wxMenu.html#appendCheckItem/3"},{"type":"function","title":"wxMenu.appendCheckItem/4","doc":"Adds a checkable item to the end of the menu.\n\nSee:\n* `append/5`\n\n* `insertCheckItem/5`","ref":"wxMenu.html#appendCheckItem/4"},{"type":"function","title":"wxMenu.appendRadioItem/3","doc":"Equivalent to  appendRadioItem(This, Id, Item, []) .","ref":"wxMenu.html#appendRadioItem/3"},{"type":"function","title":"wxMenu.appendRadioItem/4","doc":"Adds a radio item to the end of the menu.\n\nAll consequent radio items form a group and when an item in the group is checked, all the\nothers are automatically unchecked.\n\nNote: Radio items are not supported under wxMotif.\n\nSee:\n* `append/5`\n\n* `insertRadioItem/5`","ref":"wxMenu.html#appendRadioItem/4"},{"type":"function","title":"wxMenu.appendSeparator/1","doc":"Adds a separator to the end of the menu.\n\nSee:\n* `append/5`\n\n* `insertSeparator/2`","ref":"wxMenu.html#appendSeparator/1"},{"type":"function","title":"wxMenu.break/1","doc":"Inserts a break in a menu, causing the next appended item to appear in a new column.\n\nThis function only actually inserts a break in wxMSW and does nothing under the other\nplatforms.","ref":"wxMenu.html#break/1"},{"type":"function","title":"wxMenu.check/3","doc":"Checks or unchecks the menu item.\n\nSee: `isChecked/2`","ref":"wxMenu.html#check/3"},{"type":"function","title":"wxMenu.Destroy/2","doc":"Deletes the menu item from the menu.\n\nIf the item is a submenu, it will be deleted. Use `remove/2` if you want to keep the submenu (for\nexample, to reuse it later).\n\nSee:\n* `findItem/2`\n\n* `delete/2`\n\n* `remove/2`","ref":"wxMenu.html#Destroy/2"},{"type":"function","title":"wxMenu.delete/2","doc":"Deletes the menu item from the menu.\n\nIf the item is a submenu, it will `not` be deleted. Use `'Destroy'/2` if you want to delete a submenu.\n\nSee:\n* `findItem/2`\n\n* `'Destroy'/2`\n\n* `remove/2`","ref":"wxMenu.html#delete/2"},{"type":"function","title":"wxMenu.destroy/1","doc":"Destroys the object","ref":"wxMenu.html#destroy/1"},{"type":"function","title":"wxMenu.enable/3","doc":"Enables or disables (greys out) a menu item.\n\nSee: `isEnabled/2`","ref":"wxMenu.html#enable/3"},{"type":"function","title":"wxMenu.findItem/2","doc":"Finds the menu id for a menu item string.\n\nReturn: Menu item identifier, or wxNOT_FOUND if none is found.\n\nRemark: Any special menu codes are stripped out of source and target strings before\nmatching.","ref":"wxMenu.html#findItem/2"},{"type":"function","title":"wxMenu.findItemByPosition/2","doc":"Returns the `m:wxMenuItem` given a position in the menu.","ref":"wxMenu.html#findItemByPosition/2"},{"type":"function","title":"wxMenu.getHelpString/2","doc":"Returns the help string associated with a menu item.\n\nReturn: The help string, or the empty string if there is no help string or the item was\nnot found.\n\nSee:\n* `setHelpString/3`\n\n* `append/5`","ref":"wxMenu.html#getHelpString/2"},{"type":"function","title":"wxMenu.getLabel/2","doc":"Returns a menu item label.\n\nReturn: The item label, or the empty string if the item was not found.\n\nSee: `setLabel/3`","ref":"wxMenu.html#getLabel/2"},{"type":"function","title":"wxMenu.getMenuItemCount/1","doc":"Returns the number of items in the menu.","ref":"wxMenu.html#getMenuItemCount/1"},{"type":"function","title":"wxMenu.getMenuItems/1","doc":"","ref":"wxMenu.html#getMenuItems/1"},{"type":"function","title":"wxMenu.getTitle/1","doc":"Returns the title of the menu.\n\nSee: `setTitle/2`","ref":"wxMenu.html#getTitle/1"},{"type":"function","title":"wxMenu.insert/3","doc":"Inserts the given `item` before the position `pos`.\n\nInserting the item at position `getMenuItemCount/1` is the same as appending it.\n\nSee:\n* `append/5`\n\n* `prepend/5`","ref":"wxMenu.html#insert/3"},{"type":"function","title":"wxMenu.insert/4","doc":"Inserts the given `item` before the position `pos`.\n\nInserting the item at position `getMenuItemCount/1` is the same as appending it.\n\nSee:\n* `append/5`\n\n* `prepend/5`","ref":"wxMenu.html#insert/4"},{"type":"function","title":"wxMenu.insert/5","doc":"Equivalent to  insert(This, Pos, Id, Text, Submenu, []) .","ref":"wxMenu.html#insert/5"},{"type":"function","title":"wxMenu.insert/6","doc":"Inserts the given `submenu` before the position `pos`.\n\n`text` is the text shown in the menu for it and `help` is the help string shown in the\nstatus bar when the submenu item is selected.\n\nSee: `prepend/5`","ref":"wxMenu.html#insert/6"},{"type":"function","title":"wxMenu.insertCheckItem/4","doc":"Equivalent to  insertCheckItem(This, Pos, Id, Item, []) .","ref":"wxMenu.html#insertCheckItem/4"},{"type":"function","title":"wxMenu.insertCheckItem/5","doc":"Inserts a checkable item at the given position.\n\nSee:\n* `insert/6`\n\n* `appendCheckItem/4`","ref":"wxMenu.html#insertCheckItem/5"},{"type":"function","title":"wxMenu.insertRadioItem/4","doc":"Equivalent to  insertRadioItem(This, Pos, Id, Item, []) .","ref":"wxMenu.html#insertRadioItem/4"},{"type":"function","title":"wxMenu.insertRadioItem/5","doc":"Inserts a radio item at the given position.\n\nSee:\n* `insert/6`\n\n* `appendRadioItem/4`","ref":"wxMenu.html#insertRadioItem/5"},{"type":"function","title":"wxMenu.insertSeparator/2","doc":"Inserts a separator at the given position.\n\nSee:\n* `insert/6`\n\n* `appendSeparator/1`","ref":"wxMenu.html#insertSeparator/2"},{"type":"function","title":"wxMenu.isChecked/2","doc":"Determines whether a menu item is checked.\n\nReturn: true if the menu item is checked, false otherwise.\n\nSee: `check/3`","ref":"wxMenu.html#isChecked/2"},{"type":"function","title":"wxMenu.isEnabled/2","doc":"Determines whether a menu item is enabled.\n\nReturn: true if the menu item is enabled, false otherwise.\n\nSee: `enable/3`","ref":"wxMenu.html#isEnabled/2"},{"type":"function","title":"wxMenu.new/0","doc":"Constructs a `m:wxMenu` object.","ref":"wxMenu.html#new/0"},{"type":"function","title":"wxMenu.new/1","doc":"Constructs a `m:wxMenu` object.","ref":"wxMenu.html#new/1"},{"type":"function","title":"wxMenu.new/2","doc":"Constructs a `m:wxMenu` object with a title.","ref":"wxMenu.html#new/2"},{"type":"function","title":"wxMenu.prepend/2","doc":"Inserts the given `item` at position 0, i.e. before all the other existing items.\n\nSee:\n* `append/5`\n\n* `insert/6`","ref":"wxMenu.html#prepend/2"},{"type":"function","title":"wxMenu.prepend/3","doc":"Inserts the given `item` at position 0, i.e. before all the other existing items.\n\nSee:\n* `append/5`\n\n* `insert/6`","ref":"wxMenu.html#prepend/3"},{"type":"function","title":"wxMenu.prepend/4","doc":"Equivalent to  prepend(This, Id, Text, Submenu, []) .","ref":"wxMenu.html#prepend/4"},{"type":"function","title":"wxMenu.prepend/5","doc":"Inserts the given `submenu` at position 0.\n\nSee: `insert/6`","ref":"wxMenu.html#prepend/5"},{"type":"function","title":"wxMenu.prependCheckItem/3","doc":"Equivalent to  prependCheckItem(This, Id, Item, []) .","ref":"wxMenu.html#prependCheckItem/3"},{"type":"function","title":"wxMenu.prependCheckItem/4","doc":"Inserts a checkable item at position 0.\n\nSee:\n* `prepend/5`\n\n* `appendCheckItem/4`","ref":"wxMenu.html#prependCheckItem/4"},{"type":"function","title":"wxMenu.prependRadioItem/3","doc":"Equivalent to  prependRadioItem(This, Id, Item, []) .","ref":"wxMenu.html#prependRadioItem/3"},{"type":"function","title":"wxMenu.prependRadioItem/4","doc":"Inserts a radio item at position 0.\n\nSee:\n* `prepend/5`\n\n* `appendRadioItem/4`","ref":"wxMenu.html#prependRadioItem/4"},{"type":"function","title":"wxMenu.prependSeparator/1","doc":"Inserts a separator at position 0.\n\nSee:\n* `prepend/5`\n\n* `appendSeparator/1`","ref":"wxMenu.html#prependSeparator/1"},{"type":"function","title":"wxMenu.remove/2","doc":"Removes the menu item from the menu but doesn't delete the associated C++ object.\n\nThis allows you to reuse the same item later by adding it back to the menu (especially\nuseful with submenus).\n\nReturn: A pointer to the item which was detached from the menu.","ref":"wxMenu.html#remove/2"},{"type":"function","title":"wxMenu.setHelpString/3","doc":"Sets an item's help string.\n\nSee: `getHelpString/2`","ref":"wxMenu.html#setHelpString/3"},{"type":"function","title":"wxMenu.setLabel/3","doc":"Sets the label of a menu item.\n\nSee:\n* `append/5`\n\n* `getLabel/2`","ref":"wxMenu.html#setLabel/3"},{"type":"function","title":"wxMenu.setTitle/2","doc":"Sets the title of the menu.\n\nRemark: Notice that you can only call this method directly for the popup menus, to change\nthe title of a menu that is part of a menu bar you need to use `wxMenuBar:setLabelTop/3`.\n\nSee: `getTitle/1`","ref":"wxMenu.html#setTitle/2"},{"type":"type","title":"wxMenu.wxMenu/0","doc":"","ref":"wxMenu.html#t:wxMenu/0"},{"type":"module","title":"wxMenuBar","doc":"A menu bar is a series of menus accessible from the top of a frame.\n\nRemark: To respond to a menu selection, provide a handler for EVT_MENU, in the frame that\ncontains the menu bar.\n\nIf you have a toolbar which uses the same identifiers as your EVT_MENU entries, events\nfrom the toolbar will also be processed by your EVT_MENU event handlers.\n\nTip: under Windows, if you discover that menu shortcuts (for example, Alt-F to show the\nfile menu) are not working, check any EVT_CHAR events you are handling in child windows.\nIf you are not calling event.Skip() for events that you don't process in these event\nhandlers, menu shortcuts may cease to work.\n\nSee:\n* `m:wxMenu`\n\n* [Overview events](https://docs.wxwidgets.org/3.2/overview_events.html#overview_events)\n\nThis class is derived, and can use functions, from:\n\n* `m:wxWindow`\n\n* `m:wxEvtHandler`\n\nwxWidgets docs: [wxMenuBar](https://docs.wxwidgets.org/3.2/classwx_menu_bar.html)","ref":"wxMenuBar.html"},{"type":"function","title":"wxMenuBar.append/3","doc":"Adds the item to the end of the menu bar.\n\nReturn: true on success, false if an error occurred.\n\nSee: `insert/4`","ref":"wxMenuBar.html#append/3"},{"type":"function","title":"wxMenuBar.check/3","doc":"Checks or unchecks a menu item.\n\nRemark: Only use this when the menu bar has been associated with a frame; otherwise, use\nthe `m