/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.irods;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.irods.IRODSExceptionMappingService;
import ch.cyberduck.core.irods.IRODSSession;
import java.io.File;
import java.io.FileFilter;
import java.util.EnumSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.domain.ObjStat;
import org.irods.jargon.core.pub.io.IRODSFile;

public class IRODSListService
implements ListService {
    private final IRODSSession session;

    public IRODSListService(IRODSSession session) {
        this.session = session;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            AttributedList children = new AttributedList();
            IRODSFileSystemAO fs = (IRODSFileSystemAO)this.session.getClient();
            IRODSFile f = fs.getIRODSFileFactory().instanceIRODSFile(directory.getAbsolute());
            if (!f.exists()) {
                throw new NotfoundException(directory.getAbsolute());
            }
            for (File file : fs.getListInDirWithFileFilter(f, (FileFilter)TrueFileFilter.TRUE)) {
                String normalized = PathNormalizer.normalize((String)file.getAbsolutePath(), (boolean)true);
                if (StringUtils.equals((CharSequence)normalized, (CharSequence)directory.getAbsolute())) continue;
                PathAttributes attributes = new PathAttributes();
                ObjStat stats = fs.getObjStat(file.getAbsolutePath());
                attributes.setModificationDate(stats.getModifiedAt().getTime());
                attributes.setCreationDate(stats.getCreatedAt().getTime());
                attributes.setSize(stats.getObjSize());
                attributes.setChecksum(Checksum.parse((String)Hex.encodeHexString((byte[])Base64.decodeBase64((String)stats.getChecksum()))));
                attributes.setOwner(stats.getOwnerName());
                attributes.setGroup(stats.getOwnerZone());
                children.add((Referenceable)new Path(directory, PathNormalizer.name((String)normalized), file.isDirectory() ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file), attributes));
                listener.chunk(directory, children);
            }
            return children;
        }
        catch (JargonException e) {
            throw new IRODSExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }
}

