/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.irods;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.exception.NotfoundException;
import org.irods.jargon.core.exception.AuthenticationException;
import org.irods.jargon.core.exception.CatNoAccessException;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.FileNotFoundException;
import org.irods.jargon.core.exception.InvalidGroupException;
import org.irods.jargon.core.exception.InvalidUserException;
import org.irods.jargon.core.exception.JargonException;

public class IRODSExceptionMappingService
extends AbstractExceptionMappingService<JargonException> {
    public BackgroundException map(JargonException e) {
        StringBuilder buffer = new StringBuilder();
        this.append(buffer, e.getMessage());
        if (e instanceof CatNoAccessException) {
            return new AccessDeniedException(buffer.toString(), (Throwable)e);
        }
        if (e instanceof FileNotFoundException) {
            return new NotfoundException(buffer.toString(), (Throwable)e);
        }
        if (e instanceof DataNotFoundException) {
            return new NotfoundException(buffer.toString(), (Throwable)e);
        }
        if (e instanceof AuthenticationException) {
            return new LoginFailureException(buffer.toString(), (Throwable)e);
        }
        if (e instanceof InvalidUserException) {
            return new LoginFailureException(buffer.toString(), (Throwable)e);
        }
        if (e instanceof InvalidGroupException) {
            return new LoginFailureException(buffer.toString(), (Throwable)e);
        }
        return this.wrap(e, buffer);
    }
}

