/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxPathContainerService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.features.PromptUrlProvider;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.sharing.DbxUserSharingRequests;
import com.dropbox.core.v2.sharing.RequestedVisibility;
import com.dropbox.core.v2.sharing.SharedLinkMetadata;
import com.dropbox.core.v2.sharing.SharedLinkSettings;
import java.net.URI;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class DropboxPasswordShareUrlProvider
implements PromptUrlProvider<Void, Void> {
    private static final Logger log = Logger.getLogger(DropboxPasswordShareUrlProvider.class);
    private final DropboxSession session;
    private final PathContainerService containerService = new DropboxPathContainerService();

    public DropboxPasswordShareUrlProvider(DropboxSession session) {
        this.session = session;
    }

    public DescriptiveUrl toDownloadUrl(Path file, Void options, PasswordCallback callback) throws BackgroundException {
        try {
            Host bookmark = this.session.getHost();
            SharedLinkSettings.Builder settings = SharedLinkSettings.newBuilder();
            try {
                settings.withLinkPassword(callback.prompt(bookmark, LocaleFactory.localizedString((String)"Passphrase", (String)"Cryptomator"), MessageFormat.format(LocaleFactory.localizedString((String)"Create a passphrase required to access {0}", (String)"Credentials"), file.getName()), new LoginOptions().keychain(false).icon(bookmark.getProtocol().disk())).getPassword());
                settings.withRequestedVisibility(RequestedVisibility.PASSWORD);
            }
            catch (LoginCanceledException e) {
                settings.withRequestedVisibility(RequestedVisibility.PUBLIC);
            }
            SharedLinkMetadata share = new DbxUserSharingRequests((DbxRawClientV2)this.session.getClient(file)).createSharedLinkWithSettings(this.containerService.getKey(file), settings.build());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Created shared link %s", share));
            }
            return new DescriptiveUrl(URI.create(share.getUrl()), DescriptiveUrl.Type.signed, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Password Share", (String)"Dropbox")));
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map(e);
        }
    }

    public DescriptiveUrl toUploadUrl(Path file, Void options, PasswordCallback callback) throws BackgroundException {
        return DescriptiveUrl.EMPTY;
    }

    public boolean isSupported(Path file, PromptUrlProvider.Type type) {
        switch (type) {
            case download: {
                return file.isFile();
            }
        }
        return false;
    }
}

