/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.List;
import org.irods.jargon.core.query.AVUQueryOperatorEnum;
import org.irods.jargon.core.query.JargonQueryException;

public class AVUQueryElement {
    private AVUQueryPart avuQueryPart;
    private AVUQueryOperatorEnum operator;
    private String value;
    private String valueEndOfRange;
    private List<Object> valuesTable;

    public static AVUQueryElement instanceForValueQuery(AVUQueryPart avuQueryPart, AVUQueryOperatorEnum operator, String value) throws JargonQueryException {
        return new AVUQueryElement(avuQueryPart, operator, value, null, null);
    }

    public AVUQueryElement(AVUQueryPart avuQueryPart, AVUQueryOperatorEnum operator, String value, String valueEndOfRange, List<Object> valuesTable) throws JargonQueryException {
        if (avuQueryPart == null) {
            throw new JargonQueryException("avuQueryPart is null");
        }
        if (operator == null) {
            throw new JargonQueryException("avuQueryOperator is null");
        }
        if (value == null) {
            throw new JargonQueryException("null value");
        }
        this.avuQueryPart = avuQueryPart;
        this.operator = operator;
        this.value = value;
        this.valueEndOfRange = valueEndOfRange;
        this.valuesTable = null;
        if (valueEndOfRange != null) {
            throw new JargonQueryException("currently unsupported");
        }
        if (valuesTable != null) {
            throw new JargonQueryException("currently unsupported");
        }
    }

    public AVUQueryElement() {
    }

    public String toString() {
        int maxLen = 10;
        StringBuilder builder = new StringBuilder();
        builder.append("AVUQueryElement [");
        if (this.avuQueryPart != null) {
            builder.append("avuQueryPart=").append((Object)this.avuQueryPart).append(", ");
        }
        if (this.operator != null) {
            builder.append("operator=").append((Object)this.operator).append(", ");
        }
        if (this.value != null) {
            builder.append("value=").append(this.value).append(", ");
        }
        if (this.valueEndOfRange != null) {
            builder.append("valueEndOfRange=").append(this.valueEndOfRange).append(", ");
        }
        if (this.valuesTable != null) {
            builder.append("valuesTable=").append(this.valuesTable.subList(0, Math.min(this.valuesTable.size(), 10)));
        }
        builder.append("]");
        return builder.toString();
    }

    public AVUQueryPart getAvuQueryPart() {
        return this.avuQueryPart;
    }

    public AVUQueryOperatorEnum getOperator() {
        return this.operator;
    }

    public String getValue() {
        return this.value;
    }

    public String getValueEndOfRange() {
        return this.valueEndOfRange;
    }

    public List<Object> getValuesTable() {
        return this.valuesTable;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AVUQueryElement)) {
            return false;
        }
        AVUQueryElement otherObj = (AVUQueryElement)other;
        return this.avuQueryPart.equals((Object)otherObj.avuQueryPart) && this.operator.equals((Object)otherObj.operator) && this.value.equals(otherObj.value);
    }

    public int hashCode() {
        return this.avuQueryPart.hashCode() + this.operator.hashCode() + this.value.hashCode();
    }

    public static enum AVUQueryPart {
        ATTRIBUTE,
        VALUE,
        UNITS;

    }
}

