/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.DuplicateDataException;
import org.irods.jargon.core.exception.InvalidGroupException;
import org.irods.jargon.core.exception.InvalidUserException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.NoMoreRulesException;
import org.irods.jargon.core.packinstr.GeneralAdminInp;
import org.irods.jargon.core.pub.IRODSGenQueryExecutor;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.UserGroupAO;
import org.irods.jargon.core.pub.aohelper.UserAOHelper;
import org.irods.jargon.core.pub.domain.User;
import org.irods.jargon.core.pub.domain.UserGroup;
import org.irods.jargon.core.query.GenQueryBuilderException;
import org.irods.jargon.core.query.IRODSGenQuery;
import org.irods.jargon.core.query.IRODSGenQueryBuilder;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.QueryConditionOperators;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserGroupAOImpl
extends IRODSGenericAO
implements UserGroupAO {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final char COMMA = ',';
    private IRODSGenQueryExecutor irodsGenQueryExecutor = null;

    protected UserGroupAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public void addUserGroup(UserGroup userGroup) throws DuplicateDataException, JargonException {
        this.log.info("addUserGroup()");
        if (userGroup == null) {
            throw new IllegalArgumentException("null userGroup");
        }
        if (userGroup.getUserGroupName() == null || userGroup.getUserGroupName().isEmpty()) {
            throw new IllegalArgumentException("userGroup has no userGroupName");
        }
        if (userGroup.getZone() == null || userGroup.getZone().isEmpty()) {
            throw new IllegalArgumentException("userGroup has no zone");
        }
        this.log.info("user group:{}", (Object)userGroup);
        GeneralAdminInp adminPI = GeneralAdminInp.instanceForAddUserGroup(userGroup);
        this.log.debug("executing admin PI");
        try {
            this.getIRODSProtocol().irodsFunction(adminPI);
        }
        catch (NoMoreRulesException nmr) {
            this.log.warn("no more rules exception will be treated as duplicate user to normalize behavior for pre-2.5 iRODS servers");
            throw new DuplicateDataException("no more rules exception interpreted as duplicate user", nmr);
        }
    }

    @Override
    public void removeUserGroup(String userGroupName) throws JargonException {
        this.log.info("removeUserGroup()");
        if (userGroupName == null || userGroupName.isEmpty()) {
            throw new IllegalArgumentException("null or empty user group name");
        }
        this.log.info("userGroupName:{}", (Object)userGroupName);
        UserGroup userGroup = this.findByName(userGroupName);
        if (userGroup == null) {
            this.log.info("userGroup not found, treat as deleted");
            return;
        }
        this.removeUserGroup(userGroup);
    }

    @Override
    public void removeUserGroup(UserGroup userGroup) throws JargonException {
        this.log.info("removeUserGroup()");
        if (userGroup == null) {
            throw new IllegalArgumentException("null userGroup");
        }
        if (userGroup.getUserGroupName() == null || userGroup.getUserGroupName().isEmpty()) {
            throw new IllegalArgumentException("userGroup has no userGroupName");
        }
        if (userGroup.getZone() == null || userGroup.getZone().isEmpty()) {
            userGroup.setZone(this.getIRODSAccount().getZone());
        }
        this.log.info("user group:{}", (Object)userGroup);
        GeneralAdminInp adminPI = GeneralAdminInp.instanceForRemoveUserGroup(userGroup);
        this.log.debug("executing admin PI");
        try {
            this.getIRODSProtocol().irodsFunction(adminPI);
        }
        catch (DataNotFoundException dnf) {
            this.log.warn("user group does not exist, ignoring remove");
        }
        catch (InvalidUserException e) {
            this.log.warn("user group {} does not exist, ignoring remove", (Object)userGroup);
        }
        catch (NoMoreRulesException nmr) {
            this.log.debug("no more rules exception interpereted as user does not exist, just behave as if deleted");
        }
    }

    @Override
    public UserGroup find(String userGroupId) throws JargonException {
        IRODSQueryResultRow row;
        IRODSQueryResultSet resultSet;
        if (userGroupId == null || userGroupId.length() == 0) {
            throw new JargonException("null or missing userGroupId");
        }
        try {
            Integer.parseInt(userGroupId);
        }
        catch (NumberFormatException nfe) {
            this.log.error("user group not an integer: {}", (Object)userGroupId);
            throw new IllegalArgumentException("user group not numeric");
        }
        this.log.info("finding user group with id: {}", (Object)userGroupId);
        IRODSGenQueryExecutor irodsGenQueryExecutor = this.getGenQueryExecutor();
        StringBuilder query = new StringBuilder();
        query.append(this.buildUserGroupSelects());
        query.append(" where ");
        query.append(RodsGenQueryEnum.COL_USER_GROUP_ID.getName());
        query.append(" = '");
        query.append(userGroupId.trim());
        query.append("'");
        String queryString = query.toString();
        this.log.info("query string: {}", (Object)queryString);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, 500);
        try {
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for user query:" + queryString, (Throwable)e);
            throw new JargonException("error in user group query");
        }
        if (resultSet.getResults().size() == 0) {
            this.log.info("no user group found");
            return null;
        }
        if (resultSet.getResults().size() > 1) {
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("more than one user group found for id:");
            messageBuilder.append(userGroupId);
            String message = messageBuilder.toString();
            this.log.error(message);
            throw new JargonException(message);
        }
        try {
            row = resultSet.getFirstResult();
        }
        catch (DataNotFoundException e) {
            return null;
        }
        return this.buildUserGroupFromResultSet(row);
    }

    @Override
    public List<UserGroup> findAll() throws JargonException {
        IRODSQueryResultSet resultSet;
        this.log.info("findAll()");
        IRODSGenQueryExecutor irodsGenQueryExecutor = this.getGenQueryExecutor();
        StringBuilder query = new StringBuilder();
        query.append(this.buildUserGroupSelects());
        String queryString = query.toString();
        this.log.info("query string: {}", (Object)queryString);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, 500);
        try {
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for user query:" + queryString, (Throwable)e);
            throw new JargonException("error in user group query");
        }
        ArrayList<UserGroup> userGroups = new ArrayList<UserGroup>();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            userGroups.add(this.buildUserGroupFromResultSet(row));
        }
        return userGroups;
    }

    @Override
    public UserGroup findByName(String userGroupName) throws JargonException {
        IRODSQueryResultRow row;
        if (userGroupName == null || userGroupName.length() == 0) {
            throw new JargonException("null or missing userGroupName");
        }
        IRODSQueryResultSet resultSet = null;
        try {
            IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_USER_GROUP_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_USER_GROUP_ID).addConditionAsGenQueryField(RodsGenQueryEnum.COL_USER_GROUP_NAME, QueryConditionOperators.EQUAL, userGroupName.trim());
            IRODSGenQueryExecutor irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(builder.exportIRODSQueryFromBuilder(this.getIRODSAccessObjectFactory().getJargonProperties().getMaxFilesAndDirsQueryMax()), 0);
        }
        catch (JargonQueryException e) {
            this.log.error("jargon query exception getting results", (Throwable)e);
            throw new JargonException(e);
        }
        catch (GenQueryBuilderException e) {
            this.log.error("jargon query exception getting results", (Throwable)e);
            throw new JargonException(e);
        }
        if (resultSet.getResults().size() == 0) {
            this.log.info("no user group found");
            return null;
        }
        try {
            row = resultSet.getFirstResult();
        }
        catch (DataNotFoundException e) {
            return null;
        }
        return this.buildUserGroupFromResultSet(row);
    }

    @Override
    public List<UserGroup> findWhere(String whereClause) throws JargonException, JargonQueryException {
        IRODSQueryResultSet resultSet;
        if (whereClause == null || whereClause.length() == 0) {
            throw new JargonException("null or missing where clause");
        }
        this.log.info("find user group with provided where clause: {}", (Object)whereClause);
        IRODSGenQueryExecutor irodsGenQueryExecutor = this.getGenQueryExecutor();
        StringBuilder query = new StringBuilder();
        query.append(this.buildUserGroupSelects());
        query.append(" where ");
        query.append(whereClause);
        String queryString = query.toString();
        this.log.info("query string: {}", (Object)queryString);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, 500);
        try {
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for user query:" + queryString, (Throwable)e);
            throw new JargonException("error in user group query");
        }
        ArrayList<UserGroup> userGroups = new ArrayList<UserGroup>();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            userGroups.add(this.buildUserGroupFromResultSet(row));
        }
        return userGroups;
    }

    @Override
    public List<User> listUserGroupMembers(String userGroupName) throws JargonException {
        IRODSQueryResultSet resultSet;
        this.log.info("listUserGroupMembers()");
        if (userGroupName == null || userGroupName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userGroupName");
        }
        this.log.info("for user group name:{}", (Object)userGroupName);
        ArrayList<User> users = new ArrayList<User>();
        IRODSGenQueryExecutor irodsGenQueryExecutor = this.getGenQueryExecutor();
        StringBuilder query = new StringBuilder();
        query.append(UserAOHelper.buildUserSelects());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_USER_GROUP_NAME.getName());
        query.append(" where ");
        query.append(RodsGenQueryEnum.COL_USER_GROUP_NAME.getName());
        query.append(" = '");
        query.append(userGroupName.trim());
        query.append("'");
        String queryString = query.toString();
        this.log.info("query string: {}", (Object)queryString);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, 5000);
        try {
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for user query:" + queryString, (Throwable)e);
            throw new JargonException("error in user group query");
        }
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            if (row.getColumn(1).equals(userGroupName)) continue;
            users.add(UserAOHelper.buildUserFromResultSet(row, irodsGenQueryExecutor, false));
        }
        return users;
    }

    @Override
    public List<UserGroup> findUserGroupsForUser(String userName) throws JargonException {
        IRODSQueryResultSet resultSet;
        if (userName == null || userName.length() == 0) {
            throw new JargonException("null or missing userName");
        }
        this.log.info("find user group with user name: {}", (Object)userName);
        IRODSGenQueryExecutor irodsGenQueryExecutor = this.getGenQueryExecutor();
        StringBuilder query = new StringBuilder();
        query.append(this.buildUserGroupSelects());
        query.append(" WHERE ");
        query.append(RodsGenQueryEnum.COL_USER_NAME.getName());
        query.append(" = '");
        query.append(userName.trim());
        query.append("'");
        String queryString = query.toString();
        this.log.info("query string: {}", (Object)queryString);
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, 500);
        try {
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            this.log.error("query exception for user query:" + queryString, (Throwable)e);
            throw new JargonException("error in user group query");
        }
        ArrayList<UserGroup> userGroups = new ArrayList<UserGroup>();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            if (row.getColumn(0).equals(userName)) continue;
            userGroups.add(this.buildUserGroupFromResultSet(row));
        }
        return userGroups;
    }

    @Override
    public boolean isUserInGroup(String userName, String groupName) throws JargonException {
        this.log.info("isUserinGroup()");
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("userName is null or empty");
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("groupName is null or empty");
        }
        this.log.info("userName:{}", (Object)userName);
        this.log.info("groupName:{}", (Object)groupName);
        boolean inGroup = false;
        IRODSQueryResultSet resultSet = null;
        try {
            IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_USER_GROUP_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_USER_NAME).addConditionAsGenQueryField(RodsGenQueryEnum.COL_USER_GROUP_NAME, QueryConditionOperators.EQUAL, groupName.trim()).addConditionAsGenQueryField(RodsGenQueryEnum.COL_USER_NAME, QueryConditionOperators.EQUAL, userName.trim());
            IRODSGenQueryExecutor irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(builder.exportIRODSQueryFromBuilder(this.getIRODSAccessObjectFactory().getJargonProperties().getMaxFilesAndDirsQueryMax()), 0);
            inGroup = !resultSet.getResults().isEmpty();
            return inGroup;
        }
        catch (JargonQueryException e) {
            this.log.error("jargon query exception getting results", (Throwable)e);
            throw new JargonException(e);
        }
        catch (GenQueryBuilderException e) {
            this.log.error("jargon query exception getting results", (Throwable)e);
            throw new JargonException(e);
        }
    }

    @Override
    public void addUserToGroup(String userGroupName, String userName, String zoneName) throws DuplicateDataException, InvalidGroupException, InvalidUserException, JargonException {
        this.log.info("addUserToGroup()");
        if (userGroupName == null || userGroupName.isEmpty()) {
            throw new IllegalArgumentException("null or emtpy userGroupName");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or emtpy userName");
        }
        this.log.info("userName:{}", (Object)userName);
        this.log.info("userGroupName:{}", (Object)userGroupName);
        if (zoneName != null) {
            this.log.info("zoneName:{}", (Object)zoneName);
        }
        GeneralAdminInp adminPI = GeneralAdminInp.instanceForAddUserToGroup(userGroupName, userName, zoneName);
        this.log.debug("executing admin PI");
        this.getIRODSProtocol().irodsFunction(adminPI);
    }

    @Override
    public void removeUserFromGroup(String userGroupName, String userName, String zoneName) throws InvalidUserException, InvalidGroupException, JargonException {
        this.log.info("removeUserFromGroup()");
        if (userGroupName == null || userGroupName.isEmpty()) {
            throw new IllegalArgumentException("null or emtpy userGroupName");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or emtpy userName");
        }
        this.log.info("userName:{}", (Object)userName);
        this.log.info("userGroupName:{}", (Object)userGroupName);
        if (zoneName != null) {
            this.log.info("zoneName:{}", (Object)zoneName);
        }
        GeneralAdminInp adminPI = GeneralAdminInp.instanceForRemoveUserFromGroup(userGroupName, userName, zoneName);
        this.log.debug("executing admin PI");
        this.getIRODSProtocol().irodsFunction(adminPI);
    }

    private String buildUserGroupSelects() {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append(RodsGenQueryEnum.COL_USER_GROUP_NAME.getName());
        query.append(',');
        query.append(RodsGenQueryEnum.COL_USER_GROUP_ID.getName());
        return query.toString();
    }

    private UserGroup buildUserGroupFromResultSet(IRODSQueryResultRow row) throws JargonException {
        UserGroup userGroup = new UserGroup();
        userGroup.setUserGroupId(row.getColumn(1));
        userGroup.setUserGroupName(row.getColumn(0));
        return userGroup;
    }

    private IRODSGenQueryExecutor getGenQueryExecutor() throws JargonException {
        if (this.irodsGenQueryExecutor == null) {
            this.irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
        }
        return this.irodsGenQueryExecutor;
    }
}

