/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import org.irods.jargon.core.connection.ConnectionProgressStatus;
import org.irods.jargon.core.connection.ConnectionProgressStatusListener;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.packinstr.TransferOptions;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatus;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;

public class DefaultIntraFileProgressCallbackListener
implements ConnectionProgressStatusListener {
    private final TransferStatusCallbackListener transferStatusCallbackListener;
    private final TransferStatus.TransferType transferType;
    private final long totalBytesToTransfer;
    private long totalBytesTransferred;
    private final int interval;
    private final TransferOptions transferOptions;
    private int countOfMessagesSinceLastSend = 0;
    private long countOfBytesSinceLastSend = 0L;
    public static final int BYTE_COUNT_MESSAGE_THRESHOLD = 5;
    public static final long BYTE_COUNT_BYTE_THRESHOLD = 0x400000L;

    public static ConnectionProgressStatusListener instanceSettingTransferOptions(TransferStatus.TransferType transferType, long totalBytesToTransfer, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener, TransferOptions transferOptions) {
        return new DefaultIntraFileProgressCallbackListener(transferType, totalBytesToTransfer, transferControlBlock, transferStatusCallbackListener, 5, transferOptions);
    }

    public static ConnectionProgressStatusListener instance(TransferStatus.TransferType transferType, long totalBytesToTransfer, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) {
        return new DefaultIntraFileProgressCallbackListener(transferType, totalBytesToTransfer, transferControlBlock, transferStatusCallbackListener, 5, null);
    }

    @Deprecated
    public static ConnectionProgressStatusListener instanceSettingInterval(TransferStatus.TransferType transferType, long totalBytesToTransfer, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener, int interval) {
        return new DefaultIntraFileProgressCallbackListener(transferType, totalBytesToTransfer, transferControlBlock, transferStatusCallbackListener, interval, null);
    }

    private DefaultIntraFileProgressCallbackListener(TransferStatus.TransferType transferType, long totalBytesToTransfer, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener, int interval, TransferOptions transferOptions) {
        if (transferControlBlock == null) {
            throw new IllegalArgumentException("transferControlBlock is null");
        }
        if (transferStatusCallbackListener == null) {
            throw new IllegalArgumentException("transferStatusCallbackListener is null");
        }
        if (transferType == null) {
            throw new IllegalArgumentException("null transferType");
        }
        this.transferStatusCallbackListener = transferStatusCallbackListener;
        this.transferType = transferType;
        this.totalBytesToTransfer = totalBytesToTransfer;
        this.interval = interval;
        if (transferOptions == null) {
            this.transferOptions = new TransferOptions();
            this.transferOptions.setIntraFileStatusCallbacksNumberCallsInterval(5);
            this.transferOptions.setIntraFileStatusCallbacksTotalBytesInterval(0x400000L);
        } else {
            this.transferOptions = transferOptions;
        }
    }

    @Override
    public synchronized void connectionProgressStatusCallback(ConnectionProgressStatus connectionProgressStatus) {
        if (connectionProgressStatus.getCallbackType() == ConnectionProgressStatus.CallbackType.SEND_PROGRESS || connectionProgressStatus.getCallbackType() == ConnectionProgressStatus.CallbackType.RECEIVE_PROGRESS) {
            this.accumulateAndSend(connectionProgressStatus);
        } else if (connectionProgressStatus.getCallbackType() == ConnectionProgressStatus.CallbackType.OPERATIONAL_MESSAGE) {
            // empty if block
        }
    }

    private void accumulateAndSend(ConnectionProgressStatus connectionProgressStatus) {
        ++this.countOfMessagesSinceLastSend;
        this.countOfBytesSinceLastSend += connectionProgressStatus.getByteCount();
        this.totalBytesTransferred += connectionProgressStatus.getByteCount();
        if (this.countOfMessagesSinceLastSend > this.transferOptions.getIntraFileStatusCallbacksNumberCallsInterval() || this.countOfBytesSinceLastSend > this.transferOptions.getIntraFileStatusCallbacksTotalBytesInterval()) {
            try {
                TransferStatus transferStatus = TransferStatus.instanceForIntraFileStatus(this.transferType, this.totalBytesToTransfer, this.totalBytesTransferred);
                this.transferStatusCallbackListener.statusCallback(transferStatus);
                this.countOfMessagesSinceLastSend = 0;
                this.countOfBytesSinceLastSend = 0L;
            }
            catch (JargonException e) {
                throw new JargonRuntimeException("error sending status callback", e);
            }
        }
    }

    public synchronized TransferOptions getTransferOptions() {
        return this.transferOptions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DefaultIntraFileProgressCallbackListener [");
        if (this.transferStatusCallbackListener != null) {
            builder.append("transferStatusCallbackListener=");
            builder.append(this.transferStatusCallbackListener);
            builder.append(", ");
        }
        if (this.transferType != null) {
            builder.append("transferType=");
            builder.append((Object)this.transferType);
            builder.append(", ");
        }
        builder.append("totalBytesToTransfer=");
        builder.append(this.totalBytesToTransfer);
        builder.append(", totalBytesTransferred=");
        builder.append(this.totalBytesTransferred);
        builder.append(", interval=");
        builder.append(this.interval);
        builder.append(", ");
        if (this.transferOptions != null) {
            builder.append("transferOptions=");
            builder.append(this.transferOptions);
            builder.append(", ");
        }
        builder.append("countOfMessagesSinceLastSend=");
        builder.append(this.countOfMessagesSinceLastSend);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void finalConnectionProgressStatusCallback(ConnectionProgressStatus connectionProgressStatus) {
        try {
            TransferStatus transferStatus = TransferStatus.instanceForIntraFileStatus(this.transferType, this.totalBytesToTransfer, this.totalBytesToTransfer);
            this.transferStatusCallbackListener.statusCallback(transferStatus);
        }
        catch (JargonException e) {
            throw new JargonRuntimeException("error sending status callback", e);
        }
    }
}

