/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import java.util.ArrayList;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.KeyValuePair;
import org.irods.jargon.core.packinstr.Tag;

public class OpenedDataObjInp
extends AbstractIRODSPackingInstruction {
    public static final String PI_TAG = "OpenedDataObjInp_PI";
    public static final String L1_DESC_INX = "l1descInx";
    public static final String LEN = "len";
    public static final String WHENCE = "whence";
    public static final String OPR_TYPE = "oprType";
    public static final String OFFSET = "offset";
    public static final String BYTES_WRITTEN = "bytesWritten";
    public static final int SEEK_API_NBR = 674;
    public static final int READ_API_NBR = 675;
    public static final int WRITE_API_NBR = 676;
    public static final int CLOSE_API_NBR = 673;
    public static final int DEFAULT_OPERATION_TYPE = 0;
    private final long offset;
    private static int operationType = 0;
    private final int fileDescriptor;
    private final int whence;
    private final long length;
    private final boolean putOprNeeded;
    public static final int SEEK_START = 0;
    public static final int SEEK_CURRENT = 1;
    public static final int SEEK_END = 2;

    public static final OpenedDataObjInp instanceForFileSeek(long offset, int fileDescriptor, int whence) {
        return new OpenedDataObjInp(674, offset, fileDescriptor, whence, 0L, false);
    }

    public static final OpenedDataObjInp instanceForFileRead(int fileDescriptor, long length) {
        return new OpenedDataObjInp(675, 0L, fileDescriptor, 0, length, false);
    }

    public static final OpenedDataObjInp instanceForFileWrite(int fileDescriptor, long offset, long length) {
        return new OpenedDataObjInp(676, offset, fileDescriptor, 0, length, false);
    }

    public static final OpenedDataObjInp instanceForFilePut(int fileDescriptor, long length) {
        return new OpenedDataObjInp(676, 0L, fileDescriptor, 0, length, false);
    }

    public static final OpenedDataObjInp instanceForFileCloseWithPutOpr(int fileDescriptor) {
        return new OpenedDataObjInp(673, 0L, fileDescriptor, 0, 0L, true);
    }

    public static final OpenedDataObjInp instanceForFileClose(int fileDescriptor) {
        return new OpenedDataObjInp(673, 0L, fileDescriptor, 0, 0L, true);
    }

    private OpenedDataObjInp(int apiNumber, long offset, int fileDescriptor, int whence, long length, boolean putOprNeeded) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset is less than zero");
        }
        if (fileDescriptor <= 0) {
            throw new IllegalArgumentException("fileDescriptor must be > 0");
        }
        if (whence < 0 || whence > 2) {
            throw new IllegalArgumentException("invalid whence value");
        }
        this.offset = offset;
        this.fileDescriptor = fileDescriptor;
        this.setApiNumber(apiNumber);
        this.whence = whence;
        this.length = length;
        this.putOprNeeded = putOprNeeded;
    }

    @Override
    public Tag getTagValue() throws JargonException {
        int myOprType = 0;
        if (this.putOprNeeded) {
            myOprType = 1;
        }
        Tag message = new Tag(PI_TAG, new Tag[]{new Tag(L1_DESC_INX, this.getFileDescriptor()), new Tag(LEN, this.length), new Tag(WHENCE, this.whence), new Tag(OPR_TYPE, myOprType), new Tag(OFFSET, this.getOffset()), new Tag(BYTES_WRITTEN, 0)});
        ArrayList<KeyValuePair> kvps = new ArrayList<KeyValuePair>();
        message.addTag(this.createKeyValueTag(kvps));
        return message;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getOperationType() {
        return operationType;
    }

    public int getFileDescriptor() {
        return this.fileDescriptor;
    }

    public int getWhence() {
        return this.whence;
    }
}

