/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.azure.AzureExceptionMappingService;
import ch.cyberduck.core.azure.AzurePathContainerService;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.SharedAccessBlobPermissions;
import com.microsoft.azure.storage.blob.SharedAccessBlobPolicy;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.TimeZone;

public class AzureUrlProvider
implements PromptUrlProvider<Void, Void> {
    private final PathContainerService containerService = new AzurePathContainerService();
    private final AzureSession session;

    public AzureUrlProvider(AzureSession session) {
        this.session = session;
    }

    public boolean isSupported(Path file, PromptUrlProvider.Type type) {
        switch (type) {
            case download: {
                return file.isFile();
            }
        }
        return false;
    }

    public DescriptiveUrl toDownloadUrl(Path file, Void options, PasswordCallback callback) throws BackgroundException {
        return this.createSignedUrl(file, PreferencesFactory.get().getInteger("s3.url.expire.seconds"));
    }

    public DescriptiveUrl toUploadUrl(Path file, Void options, PasswordCallback callback) throws BackgroundException {
        return DescriptiveUrl.EMPTY;
    }

    private DescriptiveUrl createSignedUrl(Path file, int seconds) throws BackgroundException {
        try {
            String token;
            CloudBlob blob;
            try {
                if (!this.session.isConnected()) {
                    return DescriptiveUrl.EMPTY;
                }
                blob = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(file).getName()).getBlobReferenceFromServer(this.containerService.getKey(file));
            }
            catch (URISyntaxException e) {
                return DescriptiveUrl.EMPTY;
            }
            try {
                token = blob.generateSharedAccessSignature(this.getPolicy(seconds), null);
            }
            catch (InvalidKeyException e) {
                return DescriptiveUrl.EMPTY;
            }
            return new DescriptiveUrl(URI.create(String.format("%s://%s%s?%s", Scheme.https.name(), this.session.getHost().getHostname(), URIEncoder.encode((String)file.getAbsolute()), token)), DescriptiveUrl.Type.signed, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Pre-Signed", (String)"S3")) + " (" + MessageFormat.format(LocaleFactory.localizedString((String)"Expires {0}", (String)"S3") + ")", UserDateFormatterFactory.get().getShortFormat(this.getExpiry(seconds).longValue())));
        }
        catch (StorageException e) {
            throw new AzureExceptionMappingService().map(e);
        }
    }

    private SharedAccessBlobPolicy getPolicy(int expiry) {
        SharedAccessBlobPolicy policy = new SharedAccessBlobPolicy();
        policy.setSharedAccessExpiryTime(new Date(this.getExpiry(expiry)));
        policy.setPermissions(EnumSet.of(SharedAccessBlobPermissions.READ));
        return policy;
    }

    protected Long getExpiry(int seconds) {
        Calendar expiry = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        expiry.add(13, seconds);
        return expiry.getTimeInMillis();
    }
}

