/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.spectralogic.ds3client.helpers.JobPartTracker;
import com.spectralogic.ds3client.helpers.JobPartTrackerImpl;
import com.spectralogic.ds3client.helpers.ObjectPart;
import com.spectralogic.ds3client.helpers.ObjectPartTracker;
import com.spectralogic.ds3client.helpers.ObjectPartTrackerImpl;
import com.spectralogic.ds3client.helpers.events.EventRunner;
import com.spectralogic.ds3client.models.BulkObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public final class JobPartTrackerFactory {
    public static JobPartTracker buildPartTracker(Iterable<BulkObject> objects, EventRunner eventRunner) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        for (BulkObject bulkObject : (Iterable)Preconditions.checkNotNull(objects)) {
            multimap.put((Object)bulkObject.getName(), (Object)new ObjectPart(bulkObject.getOffset(), bulkObject.getLength()));
        }
        return new JobPartTrackerImpl(new HashMap<String, ObjectPartTracker>(Maps.transformEntries((Map)multimap.asMap(), (Maps.EntryTransformer)new BuildObjectPartTrackerFromObjectPartGroup(eventRunner))));
    }

    private static final class BuildObjectPartTrackerFromObjectPartGroup
    implements Maps.EntryTransformer<String, Collection<ObjectPart>, ObjectPartTracker> {
        private final EventRunner eventRunner;

        public BuildObjectPartTrackerFromObjectPartGroup(EventRunner eventRunner) {
            this.eventRunner = eventRunner;
        }

        public ObjectPartTracker transformEntry(@Nonnull String key, @Nonnull Collection<ObjectPart> value) {
            return new ObjectPartTrackerImpl((String)Preconditions.checkNotNull((Object)key), (Collection)Preconditions.checkNotNull(value), this.eventRunner);
        }
    }
}

