/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.GetJobToReplicateSpectraS3Response;
import com.spectralogic.ds3client.networking.WebResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class GetJobToReplicateSpectraS3ResponseParser
extends AbstractResponseParser<GetJobToReplicateSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetJobToReplicateSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        String result = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                        GetJobToReplicateSpectraS3Response getJobToReplicateSpectraS3Response = new GetJobToReplicateSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return getJobToReplicateSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

