/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class ListMultiPartUploadPartsRequest
extends AbstractRequest {
    private final String bucketName;
    private final String objectName;
    private final String uploadId;
    private int maxParts;
    private Integer partNumberMarker;

    public ListMultiPartUploadPartsRequest(String bucketName, String objectName, UUID uploadId) {
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.uploadId = uploadId.toString();
        this.updateQueryParam("upload_id", uploadId);
    }

    public ListMultiPartUploadPartsRequest(String bucketName, String objectName, String uploadId) {
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.uploadId = uploadId;
        this.updateQueryParam("upload_id", uploadId);
    }

    public ListMultiPartUploadPartsRequest withMaxParts(int maxParts) {
        this.maxParts = maxParts;
        this.updateQueryParam("max_parts", maxParts);
        return this;
    }

    public ListMultiPartUploadPartsRequest withPartNumberMarker(Integer partNumberMarker) {
        this.partNumberMarker = partNumberMarker;
        this.updateQueryParam("part_number_marker", partNumberMarker);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/" + this.bucketName + "/" + this.objectName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public int getMaxParts() {
        return this.maxParts;
    }

    public Integer getPartNumberMarker() {
        return this.partNumberMarker;
    }
}

