/*
 * Decompiled with CFR 0.152.
 */
package org.rococoa.internal;

public abstract class OperationBatcher {
    private final int batchSize;
    private int count;
    private boolean closed;

    public OperationBatcher(int batchSize) {
        this.batchSize = batchSize;
        this.reset();
    }

    public void operate() {
        if (this.closed) {
            throw new IllegalStateException("Batcher closed");
        }
        if (++this.count < this.batchSize) {
            return;
        }
        this.operation();
        this.reset();
        this.count = 0;
    }

    public void close() {
        if (this.closed) {
            throw new IllegalStateException("Batcher closed");
        }
        this.operation();
        this.closed = true;
    }

    protected abstract void operation();

    protected abstract void reset();
}

