/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io.watchservice;

import ch.cyberduck.binding.foundation.CFIndex;
import ch.cyberduck.binding.foundation.CFRunLoopRef;
import ch.cyberduck.binding.foundation.CFStringRef;
import ch.cyberduck.core.io.watchservice.AbstractWatchKey;
import ch.cyberduck.core.io.watchservice.AbstractWatchService;
import ch.cyberduck.core.io.watchservice.FSEventStreamRef;
import ch.cyberduck.core.io.watchservice.FSEvents;
import ch.cyberduck.core.threading.NamedThreadFactory;
import com.google.common.util.concurrent.Uninterruptibles;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.IOException;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class FSEventWatchService
extends AbstractWatchService {
    private static final Logger log = Logger.getLogger(FSEventWatchService.class);
    private final FSEvents library = FSEvents.library;
    private final Map<WatchKey, CFRunLoop> loops = new HashMap<WatchKey, CFRunLoop>();
    private final Map<WatchKey, FSEvents.FSEventStreamCallback> callbacks = new HashMap<WatchKey, FSEvents.FSEventStreamCallback>();
    private final ThreadFactory threadFactory = new NamedThreadFactory("fsevent");
    private static final int kFSEventStreamCreateFlagNone = 0;
    private static final int kFSEventStreamCreateFlagUseCFTypes = 1;
    private static final int kFSEventStreamCreateFlagNoDefer = 2;
    private static final int kFSEventStreamCreateFlagWatchRoot = 4;
    private static final int kFSEventStreamCreateFlagIgnoreSelf = 8;
    private static final int kFSEventStreamCreateFlagFileEvents = 16;

    public FSEventWatchService() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Create new watch service");
        }
    }

    public WatchKey register(Watchable folder, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Register file %s for events %s", folder, Arrays.toString(events)));
        }
        Pointer[] values = new Pointer[]{CFStringRef.toCFString((String)folder.toString()).getPointer()};
        MacOSXWatchKey key = new MacOSXWatchKey(folder, this, events);
        double latency = 1.0;
        Map<File, Long> timestamps = FSEventWatchService.createLastModifiedMap(new File(folder.toString()));
        Callback callback = new Callback(key, timestamps);
        FSEventStreamRef stream = this.library.FSEventStreamCreate(Pointer.NULL, callback, Pointer.NULL, this.library.CFArrayCreate(null, values, CFIndex.valueOf((int)1), null), -1L, 1.0, 2);
        CountDownLatch lock = new CountDownLatch(1);
        CFRunLoop loop = new CFRunLoop(lock, stream);
        this.threadFactory.newThread(loop).start();
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)lock);
        this.loops.put((WatchKey)((Object)key), loop);
        this.callbacks.put((WatchKey)((Object)key), callback);
        return key;
    }

    private static Map<File, Long> createLastModifiedMap(File folder) {
        ConcurrentHashMap<File, Long> lastModifiedMap = new ConcurrentHashMap<File, Long>();
        for (File file : FSEventWatchService.listFiles(folder)) {
            lastModifiedMap.put(file, file.lastModified());
        }
        return lastModifiedMap;
    }

    private static Set<File> listFiles(File folder) {
        HashSet<File> files = new HashSet<File>();
        if (folder.isDirectory()) {
            File[] children = folder.listFiles();
            if (null == children) {
                return files;
            }
            Collections.addAll(files, children);
        }
        return files;
    }

    public void release() {
        for (CFRunLoop l : this.loops.values()) {
            this.library.FSEventStreamStop(l.getStreamRef());
            this.library.FSEventStreamUnscheduleFromRunLoop(l.getStreamRef(), l.getRunLoop(), CFStringRef.toCFString((String)"kCFRunLoopDefaultMode"));
            this.library.FSEventStreamInvalidate(l.getStreamRef());
            this.library.FSEventStreamRelease(l.getStreamRef());
        }
        this.loops.clear();
        this.callbacks.clear();
    }

    private final class MacOSXWatchKey
    extends AbstractWatchKey {
        private final Watchable file;
        private final AtomicBoolean cancelled;
        private final boolean reportCreateEvents;
        private final boolean reportModifyEvents;
        private final boolean reportDeleteEvents;

        public MacOSXWatchKey(Watchable file, FSEventWatchService service, WatchEvent.Kind<?>[] events) {
            super((AbstractWatchService)service);
            this.cancelled = new AtomicBoolean(false);
            this.file = file;
            boolean reportCreateEvents = false;
            boolean reportModifyEvents = false;
            boolean reportDeleteEvents = false;
            for (WatchEvent.Kind<?> event : events) {
                if (event == StandardWatchEventKinds.ENTRY_CREATE) {
                    reportCreateEvents = true;
                    continue;
                }
                if (event == StandardWatchEventKinds.ENTRY_MODIFY) {
                    reportModifyEvents = true;
                    continue;
                }
                if (event != StandardWatchEventKinds.ENTRY_DELETE) continue;
                reportDeleteEvents = true;
            }
            this.reportCreateEvents = reportCreateEvents;
            this.reportDeleteEvents = reportDeleteEvents;
            this.reportModifyEvents = reportModifyEvents;
        }

        public boolean isValid() {
            return !this.cancelled.get() && FSEventWatchService.this.callbacks.containsKey((Object)this) && FSEventWatchService.this.loops.containsKey((Object)this) && ((CFRunLoop)FSEventWatchService.this.loops.get((Object)this)).isStarted();
        }

        public void cancel() {
            this.cancelled.set(true);
        }

        public Watchable watchable() {
            return this.file;
        }

        public boolean isReportCreateEvents() {
            return this.reportCreateEvents;
        }

        public boolean isReportModifyEvents() {
            return this.reportModifyEvents;
        }

        public boolean isReportDeleteEvents() {
            return this.reportDeleteEvents;
        }
    }

    private static final class Callback
    implements FSEvents.FSEventStreamCallback {
        private final MacOSXWatchKey key;
        private final Map<File, Long> timestamps;

        private Callback(MacOSXWatchKey key, Map<File, Long> timestamps) {
            this.key = key;
            this.timestamps = timestamps;
        }

        @Override
        public void invoke(FSEventStreamRef streamRef, Pointer clientCallBackInfo, NativeLong numEvents, Pointer eventPaths, Pointer eventFlags, Pointer eventIds) {
            int length = numEvents.intValue();
            for (String folder : eventPaths.getStringArray(0L, length)) {
                Set filesOnDisk = FSEventWatchService.listFiles(new File(folder));
                for (File file : this.findCreatedFiles(filesOnDisk)) {
                    if (this.key.isReportCreateEvents()) {
                        this.key.signalEvent(StandardWatchEventKinds.ENTRY_CREATE, file);
                    }
                    this.timestamps.put(file, file.lastModified());
                }
                for (File file : this.findModifiedFiles(filesOnDisk)) {
                    if (this.key.isReportModifyEvents()) {
                        this.key.signalEvent(StandardWatchEventKinds.ENTRY_MODIFY, file);
                    }
                    this.timestamps.put(file, file.lastModified());
                }
                for (File file : this.findDeletedFiles(folder, filesOnDisk)) {
                    if (this.key.isReportDeleteEvents()) {
                        this.key.signalEvent(StandardWatchEventKinds.ENTRY_DELETE, file);
                    }
                    this.timestamps.remove(file);
                }
            }
        }

        private List<File> findModifiedFiles(Set<File> files) {
            ArrayList<File> modifiedFileList = new ArrayList<File>();
            for (File file : files) {
                Long lastModified = this.timestamps.get(file);
                if (lastModified == null || lastModified.longValue() == file.lastModified()) continue;
                modifiedFileList.add(file);
            }
            return modifiedFileList;
        }

        private List<File> findCreatedFiles(Set<File> files) {
            ArrayList<File> createdFileList = new ArrayList<File>();
            for (File file : files) {
                if (this.timestamps.containsKey(file)) continue;
                createdFileList.add(file);
            }
            return createdFileList;
        }

        private List<File> findDeletedFiles(String folder, Set<File> files) {
            ArrayList<File> deletedFileList = new ArrayList<File>();
            for (File file : this.timestamps.keySet()) {
                if (!file.getAbsolutePath().startsWith(folder) || files.contains(file)) continue;
                deletedFileList.add(file);
            }
            return deletedFileList;
        }
    }

    private final class CFRunLoop
    implements Runnable {
        private final CountDownLatch lock;
        private final FSEventStreamRef streamRef;
        private CFRunLoopRef runLoop;

        public CFRunLoop(CountDownLatch lock, FSEventStreamRef streamRef) {
            this.streamRef = streamRef;
            this.lock = lock;
        }

        @Override
        public void run() {
            this.runLoop = FSEvents.library.CFRunLoopGetCurrent();
            FSEventWatchService.this.library.FSEventStreamScheduleWithRunLoop(this.streamRef, this.runLoop, CFStringRef.toCFString((String)"kCFRunLoopDefaultMode"));
            FSEventWatchService.this.library.FSEventStreamStart(this.streamRef);
            this.lock.countDown();
            FSEventWatchService.this.library.CFRunLoopRun();
        }

        public CFRunLoopRef getRunLoop() {
            return this.runLoop;
        }

        public FSEventStreamRef getStreamRef() {
            return this.streamRef;
        }

        public boolean isStarted() {
            return this.lock.getCount() == 0L;
        }
    }
}

