/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.secret;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.types.UInt64;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.secret.Pair;
import org.freedesktop.secret.Secret;
import org.freedesktop.secret.Service;
import org.freedesktop.secret.Static;
import org.freedesktop.secret.interfaces.Collection;

public class Collection
extends org.freedesktop.secret.interfaces.Collection {
    private String id;
    public static final List<Class<? extends DBusSignal>> signals = Arrays.asList(Collection.ItemCreated.class, Collection.ItemChanged.class, Collection.ItemDeleted.class);

    public Collection(DBusPath path, Service service) {
        super(service.getConnection(), signals, "org.freedesktop.secrets", path.getPath(), "org.freedesktop.Secret.Collection");
        String[] split = path.getPath().split("/");
        this.id = split[split.length - 1];
    }

    public Collection(DBusPath path, Service service, List<Class<? extends DBusSignal>> signals) {
        super(service.getConnection(), signals, "org.freedesktop.secrets", path.getPath(), "org.freedesktop.Secret.Collection");
        String[] split = path.getPath().split("/");
        this.id = split[split.length - 1];
    }

    public Collection(String id, Service service) {
        super(service.getConnection(), signals, "org.freedesktop.secrets", Static.ObjectPaths.collection(id), "org.freedesktop.Secret.Collection");
        this.id = id;
    }

    @Override
    public ObjectPath delete() {
        Object[] result = this.send("Delete", "", new Object[0]);
        ObjectPath prompt = (ObjectPath)result[0];
        return prompt;
    }

    @Override
    public List<ObjectPath> searchItems(Map<String, String> attributes) {
        Object[] response = this.send("SearchItems", "a{ss}", attributes);
        return (List)response[0];
    }

    @Override
    public Pair<ObjectPath, ObjectPath> createItem(Map<String, Variant> properties, Secret secret, boolean replace) {
        Object[] response = this.send("CreateItem", "a{sv}(oayays)b", properties, secret, replace);
        return new Pair<Object, Object>(response[0], response[1]);
    }

    @Override
    public List<ObjectPath> getItems() {
        Variant response = this.getProperty("Items");
        return (ArrayList)response.getValue();
    }

    @Override
    public String getLabel() {
        Variant response = this.getProperty("Label");
        return (String)response.getValue();
    }

    @Override
    public void setLabel(String label) {
        this.setProperty("Label", new Variant((Object)label));
    }

    @Override
    public boolean isLocked() {
        Variant response = this.getProperty("Locked");
        return (Boolean)response.getValue();
    }

    @Override
    public UInt64 created() {
        Variant response = this.getProperty("Created");
        return (UInt64)response.getValue();
    }

    @Override
    public UInt64 modified() {
        Variant response = this.getProperty("Modified");
        return (UInt64)response.getValue();
    }

    public boolean isRemote() {
        return false;
    }

    @Override
    public String getObjectPath() {
        return super.getObjectPath();
    }

    public String getId() {
        return this.id;
    }
}

