/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp.parser;

import ch.cyberduck.core.ftp.parser.CommonUnixFTPEntryParser;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPFile;

public class LaxUnixFTPEntryParser
extends CommonUnixFTPEntryParser {
    private static final String REGEX_WHITESPACE_AWARE = "([bcdlfmpSs-])(((r|-)(w|-)([xsStTL-]))((r|-)(w|-)([xsStTL-]))((r|-)(w|-)([xsStTL-])))\\+?\\s+(\\d+)\\s+(\\S+)\\s+(?:(\\S+)\\s+)?(\\d+)(\\.?\\d?)(\\w?)\\s+((?:\\d+[-/]\\d+[-/]\\d+)|(?:\\S+\\s+\\S+))\\s+((?:\\d{4}\\s?)|(?:\\d{1,2}:\\d{2}))\\s(\\s*\\S+)(\\s*.*)";

    public LaxUnixFTPEntryParser() {
        super(REGEX_WHITESPACE_AWARE);
    }

    public FTPFile parseFTPEntry(String entry) {
        if (this.matches(entry)) {
            String typeStr = this.group(1);
            String usr = this.group(16);
            String grp = this.group(17);
            String filesize = this.group(18) + this.group(19);
            String filesizeIndicator = this.group(20);
            String datestr = this.group(21) + " " + this.group(22).trim();
            String name = this.group(23);
            String endtoken = this.group(24);
            if (StringUtils.isNotBlank((CharSequence)filesizeIndicator)) {
                try {
                    double size = Double.parseDouble(filesize);
                    if (filesizeIndicator.equalsIgnoreCase("K")) {
                        size *= 1024.0;
                    } else if (filesizeIndicator.equalsIgnoreCase("M")) {
                        size *= 1048576.0;
                    } else if (filesizeIndicator.equalsIgnoreCase("G")) {
                        size *= 1.073741824E9;
                    }
                    return this.parseFTPEntry(typeStr, usr, grp, (long)size, datestr, name, endtoken);
                }
                catch (NumberFormatException e) {
                    return this.parseFTPEntry(typeStr, usr, grp, -1L, datestr, name, endtoken);
                }
            }
            return this.parseFTPEntry(typeStr, usr, grp, filesize, datestr, name, endtoken);
        }
        return null;
    }
}

