/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.ftp.FTPAttributesFinderFeature;
import ch.cyberduck.core.ftp.FTPClient;
import ch.cyberduck.core.ftp.FTPException;
import ch.cyberduck.core.ftp.FTPExceptionMappingService;
import ch.cyberduck.core.ftp.FTPSession;
import ch.cyberduck.core.shared.DefaultUnixPermissionFeature;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FTPUnixPermissionFeature
extends DefaultUnixPermissionFeature
implements UnixPermission {
    private static final Logger log = Logger.getLogger(FTPUnixPermissionFeature.class);
    private final FTPSession session;
    private BackgroundException failure;

    public FTPUnixPermissionFeature(FTPSession session) {
        this.session = session;
    }

    public void setUnixOwner(Path file, String owner) throws BackgroundException {
        String command = "chown";
        try {
            if (!((FTPClient)((Object)this.session.getClient())).sendSiteCommand(String.format("%s %s %s", "chown", owner, file.getAbsolute()))) {
                throw new FTPException(((FTPClient)((Object)this.session.getClient())).getReplyCode(), ((FTPClient)((Object)this.session.getClient())).getReplyString());
            }
        }
        catch (IOException e) {
            throw new FTPExceptionMappingService().map("Cannot change owner", e, file);
        }
    }

    public void setUnixGroup(Path file, String group) throws BackgroundException {
        String command = "chgrp";
        try {
            if (!((FTPClient)((Object)this.session.getClient())).sendSiteCommand(String.format("%s %s %s", "chgrp", group, file.getAbsolute()))) {
                throw new FTPException(((FTPClient)((Object)this.session.getClient())).getReplyCode(), ((FTPClient)((Object)this.session.getClient())).getReplyString());
            }
        }
        catch (IOException e) {
            throw new FTPExceptionMappingService().map("Cannot change group", e, file);
        }
    }

    public Permission getUnixPermission(Path file) throws BackgroundException {
        try {
            return new FTPAttributesFinderFeature(this.session).find(file).getPermission();
        }
        catch (InteroperabilityException e) {
            for (Path f : ((ListService)this.session.getFeature(ListService.class)).list(file.getParent(), (ListProgressListener)new DisabledListProgressListener())) {
                if (!f.equals((Object)file)) continue;
                return f.attributes().getPermission();
            }
            throw new NotfoundException(file.getAbsolute());
        }
    }

    public void setUnixPermission(Path file, Permission permission) throws BackgroundException {
        if (this.failure != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Skip setting permission for %s due to previous failure %s", file, this.failure.getMessage()));
            }
            throw this.failure;
        }
        try {
            if (!((FTPClient)((Object)this.session.getClient())).sendSiteCommand(String.format("CHMOD %s %s", permission.getMode(), file.getAbsolute()))) {
                throw new FTPException(((FTPClient)((Object)this.session.getClient())).getReplyCode(), ((FTPClient)((Object)this.session.getClient())).getReplyString());
            }
        }
        catch (IOException e) {
            this.failure = new FTPExceptionMappingService().map("Cannot change permissions of {0}", e, file);
            throw this.failure;
        }
    }
}

