/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine.ant;

import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import com.github.sardine.ant.Command;
import com.github.sardine.ant.command.Copy;
import com.github.sardine.ant.command.CreateDirectory;
import com.github.sardine.ant.command.Delete;
import com.github.sardine.ant.command.Exists;
import com.github.sardine.ant.command.Move;
import com.github.sardine.ant.command.Put;
import com.github.sardine.ant.command.RecursiveGet;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class SardineTask
extends Task {
    private List<Command> commands = new ArrayList<Command>();
    private boolean failOnError = false;
    private String username = null;
    private String password = null;
    private String domain = null;
    private String workstation = null;
    private boolean ignoreCookies = false;
    private String preemptiveAuthenticationHost;
    private Sardine sardine = null;

    public void addCopy(Copy copy) {
        this.addCommand(copy);
    }

    public void addCreateDirectory(CreateDirectory createDirectory) {
        this.addCommand(createDirectory);
    }

    public void addDelete(Delete delete) {
        this.addCommand(delete);
    }

    public void addExists(Exists exists) {
        this.addCommand(exists);
    }

    public void addMove(Move move) {
        this.addCommand(move);
    }

    public void addPut(Put put) {
        this.addCommand(put);
    }

    public void addRecursiveGet(RecursiveGet get) {
        this.addCommand(get);
    }

    private void addCommand(Command command) {
        command.setTask(this);
        this.commands.add(command);
    }

    public void execute() throws BuildException {
        try {
            if (this.domain == null && this.workstation == null) {
                this.sardine = SardineFactory.begin(this.username, this.password);
            } else {
                this.sardine = SardineFactory.begin();
                this.sardine.setCredentials(this.username, this.password, this.domain, this.workstation);
            }
            if (this.ignoreCookies) {
                this.sardine.ignoreCookies();
            }
            if (this.preemptiveAuthenticationHost != null && !this.preemptiveAuthenticationHost.isEmpty()) {
                this.sardine.enablePreemptiveAuthentication(this.preemptiveAuthenticationHost);
            }
            for (Command command : this.commands) {
                command.executeCommand();
            }
        }
        catch (Exception e) {
            throw new BuildException("failed: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setFailonerror(boolean failonerror) {
        this.failOnError = failonerror;
    }

    public boolean isFailonerror() {
        return this.failOnError;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setWorkstation(String workstation) {
        this.workstation = workstation;
    }

    public void setIgnoreCookies(boolean ignoreCookies) {
        this.ignoreCookies = ignoreCookies;
    }

    public void setPreemptiveAuthenticationHost(String host) {
        this.preemptiveAuthenticationHost = host;
    }

    public Sardine getSardine() {
        return this.sardine;
    }
}

