/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.b2.response;

import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.BaseB2Response;

public class B2AuthorizeAccountResponse
extends BaseB2Response {
    private static final Logger LOGGER = LoggerFactory.getLogger(B2AuthorizeAccountResponse.class);
    private final String accountId = this.readString("accountId");
    private final String apiUrl = this.readString("apiUrl");
    private final String authorizationToken = this.readString("authorizationToken");
    private final String downloadUrl = this.readString("downloadUrl");
    private final int recommendedPartSize = this.readInt("recommendedPartSize");
    private final int absoluteMinimumPartSize = this.readInt("absoluteMinimumPartSize");
    private final String bucketId;
    private final String bucketName;
    private final Set<String> capabilities;
    private final String namePrefix;

    public B2AuthorizeAccountResponse(String json) throws B2ApiException {
        super(json);
        JSONObject allowed = this.readObject("allowed");
        JSONArray capabilities = allowed.getJSONArray("capabilities");
        this.capabilities = new HashSet<String>();
        for (Object object : capabilities) {
            this.capabilities.add(object.toString());
        }
        this.bucketId = allowed.optString("bucketId");
        this.bucketName = allowed.optString("bucketName");
        this.namePrefix = allowed.optString("bucketName");
        this.warnOnMissedKeys();
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getAuthorizationToken() {
        return this.authorizationToken;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public int getRecommendedPartSize() {
        return this.recommendedPartSize;
    }

    public int getAbsoluteMinimumPartSize() {
        return this.absoluteMinimumPartSize;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public Set<String> getCapabilities() {
        return this.capabilities;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("B2AuthorizeAccountResponse [accountId=");
        stringBuilder.append(this.accountId);
        stringBuilder.append(", apiUrl=");
        stringBuilder.append(this.apiUrl);
        stringBuilder.append(", authorizationToken=");
        stringBuilder.append(this.authorizationToken);
        stringBuilder.append(", downloadUrl=");
        stringBuilder.append(this.downloadUrl);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

