/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveSession;

public class DriveFindFeature
implements Find {
    private final DriveFileidProvider fileid;

    public DriveFindFeature(DriveSession session, DriveFileidProvider fileid) {
        this.fileid = fileid;
    }

    public boolean find(Path file) throws BackgroundException {
        try {
            this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener());
            return true;
        }
        catch (NotfoundException e) {
            return false;
        }
    }

    public Find withCache(Cache<Path> cache) {
        this.fileid.withCache((Cache)cache);
        return this;
    }
}

