/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn;

import java.nio.CharBuffer;
import java.util.Arrays;

public class WipeableString
implements CharSequence {
    private char[] content;
    private int hash = 0;
    private boolean wiped = false;

    public WipeableString(CharSequence source) {
        this.content = new char[source.length()];
        for (int n = 0; n < this.content.length; ++n) {
            this.content[n] = source.charAt(n);
        }
    }

    public WipeableString(char[] source) {
        this.content = Arrays.copyOf(source, source.length);
    }

    @Override
    public int length() {
        return this.content == null ? 0 : this.content.length;
    }

    @Override
    public char charAt(int index) {
        return this.content[index];
    }

    @Override
    public WipeableString subSequence(int start, int end) {
        return new WipeableString(Arrays.copyOfRange(this.content, start, end));
    }

    public void wipe() {
        Arrays.fill(this.content, ' ');
        this.hash = 0;
        this.content = new char[0];
        this.wiped = true;
    }

    public static WipeableString lowerCase(CharSequence source) {
        assert (source != null);
        char[] chars = new char[source.length()];
        for (int n = 0; n < source.length(); ++n) {
            chars[n] = Character.toLowerCase(source.charAt(n));
        }
        return new WipeableString(chars);
    }

    public static WipeableString reversed(CharSequence source) {
        assert (source != null);
        int length = source.length();
        char[] chars = new char[length];
        for (int n = 0; n < source.length(); ++n) {
            chars[n] = source.charAt(length - n - 1);
        }
        return new WipeableString(chars);
    }

    public static WipeableString copy(CharSequence source, int start, int end) {
        return new WipeableString(source.subSequence(start, end));
    }

    public int indexOf(char character) {
        for (int n = 0; n < this.content.length; ++n) {
            if (this.content[n] != character) continue;
            return n;
        }
        return -1;
    }

    public int codePointAt(int index) {
        if (index < 0 || index >= this.content.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return Character.codePointAt(this.content, index, this.content.length);
    }

    public boolean isWiped() {
        return this.wiped;
    }

    public char[] charArray() {
        return Arrays.copyOf(this.content, this.content.length);
    }

    static CharSequence trimTrailingWhitespace(CharSequence s) {
        int length;
        if (!Character.isWhitespace(s.charAt(s.length() - 1))) {
            return s;
        }
        for (length = s.length(); length > 0 && Character.isWhitespace(s.charAt(length - 1)); --length) {
        }
        return WipeableString.copy(s, 0, length);
    }

    public static int parseInt(CharSequence s) throws NumberFormatException {
        return WipeableString.parseInt(s, 10);
    }

    public static int parseInt(CharSequence s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        s = WipeableString.trimTrailingWhitespace(s);
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        int result = 0;
        boolean negative = false;
        int i = 0;
        int len = s.length();
        int limit = -2147483647;
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Integer.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw new NumberFormatException("For input string: \"" + s + "\"");
                }
                if (len == 1) {
                    throw new NumberFormatException("For input string: \"" + s + "\"");
                }
                ++i;
            }
            int multmin = limit / radix;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                    throw new NumberFormatException("For input string: \"" + s + "\"");
                }
                if (result < multmin) {
                    throw new NumberFormatException("For input string: \"" + s + "\"");
                }
                if ((result *= radix) < limit + digit) {
                    throw new NumberFormatException("For input string: \"" + s + "\"");
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException("For input string: \"" + s + "\"");
        }
        return negative ? result : -result;
    }

    @Override
    public String toString() {
        return new String(this.content);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && this.content.length > 0) {
            char[] val = this.content;
            for (int i = 0; i < this.content.length; ++i) {
                h = 31 * h + val[i];
            }
            this.hash = h;
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof CharSequence) {
            CharSequence other = (CharSequence)obj;
            if (other.length() != this.length()) {
                return false;
            }
            for (int n = 0; n < this.length(); ++n) {
                if (this.charAt(n) == other.charAt(n)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void wipeIfPossible(CharSequence text) {
        if (text == null) {
            return;
        }
        if (text instanceof WipeableString) {
            ((WipeableString)text).wipe();
        } else if (text instanceof StringBuilder) {
            for (int n = 0; n < text.length(); ++n) {
                ((StringBuilder)text).setCharAt(n, ' ');
            }
            ((StringBuilder)text).setLength(0);
        } else if (text instanceof StringBuffer) {
            for (int n = 0; n < text.length(); ++n) {
                ((StringBuffer)text).setCharAt(n, ' ');
            }
            ((StringBuffer)text).setLength(0);
        } else if (text instanceof CharBuffer && !((CharBuffer)text).isReadOnly()) {
            for (int n = 0; n < text.length(); ++n) {
                ((CharBuffer)text).put(n, ' ');
            }
        }
    }
}

