/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.vault.VaultCredentials;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.Objects;

public class CreateVaultWorker
extends Worker<Path> {
    private final String region;
    private final VaultCredentials passphrase;
    private final PasswordStore keychain;
    private final Vault vault;

    public CreateVaultWorker(String region, VaultCredentials passphrase, PasswordStore keychain, Vault vault) {
        this.region = region;
        this.passphrase = passphrase;
        this.keychain = keychain;
        this.vault = vault;
    }

    @Override
    public Path run(Session<?> session) throws BackgroundException {
        Path home = this.vault.create(session, this.region, this.passphrase, this.keychain);
        this.vault.close();
        return home;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Making directory {0}", "Status"), this.vault.getHome().getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateVaultWorker that = (CreateVaultWorker)o;
        return Objects.equals(this.vault, that.vault);
    }

    public int hashCode() {
        return Objects.hash(this.vault);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("CreateVaultWorker{");
        sb.append("vault=").append(this.vault);
        sb.append('}');
        return sb.toString();
    }
}

