/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.TransferAcceleration;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.vault.VaultRegistry;

public class VaultRegistryTransferAccelerationFeature<C extends HttpSession<?>>
implements TransferAcceleration {
    private final Session<?> session;
    private final TransferAcceleration proxy;
    private final VaultRegistry registry;

    public VaultRegistryTransferAccelerationFeature(Session<?> session, TransferAcceleration proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public boolean getStatus(Path file) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, TransferAcceleration.class, this.proxy).getStatus(file);
    }

    @Override
    public void setStatus(Path file, boolean enabled) throws BackgroundException {
        this.registry.find(this.session, file).getFeature(this.session, TransferAcceleration.class, this.proxy).setStatus(file, enabled);
    }

    @Override
    public boolean prompt(Host bookmark, Path file, ConnectionCallback prompt) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, TransferAcceleration.class, this.proxy).prompt(bookmark, file, prompt);
    }

    @Override
    public void configure(boolean enable, Path file) throws BackgroundException {
        this.registry.find(this.session, file).getFeature(this.session, TransferAcceleration.class, this.proxy).configure(enable, file);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryTransferAccelerationFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

