/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.Archive;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Compress;
import ch.cyberduck.core.vault.VaultRegistry;
import java.util.List;

public class VaultRegistryCompressFeature
implements Compress {
    private final Session<?> session;
    private final Compress proxy;
    private final VaultRegistry registry;

    public VaultRegistryCompressFeature(Session<?> session, Compress proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public void archive(Archive archive, Path workdir, List<Path> files, ProgressListener listener, TranscriptListener transcript) throws BackgroundException {
        this.registry.find(this.session, workdir).getFeature(this.session, Compress.class, this.proxy).archive(archive, workdir, files, listener, transcript);
    }

    @Override
    public void unarchive(Archive archive, Path file, ProgressListener listener, TranscriptListener transcript) throws BackgroundException {
        this.registry.find(this.session, file).getFeature(this.session, Compress.class, this.proxy).unarchive(archive, file, listener, transcript);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryCompressFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

