/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProxyListProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.vault.DecryptingListProgressListener;
import ch.cyberduck.core.vault.VaultFinderListProgressListener;
import ch.cyberduck.core.vault.VaultFoundListCanceledException;
import org.apache.log4j.Logger;

public class VaultFinderListService
implements ListService {
    private static final Logger log = Logger.getLogger(VaultFinderListService.class);
    private final Session<?> session;
    private final ListService delegate;
    private final VaultFinderListProgressListener finder;

    public VaultFinderListService(Session<?> session, ListService delegate, VaultFinderListProgressListener finder) {
        this.session = session;
        this.delegate = delegate;
        this.finder = finder;
    }

    @Override
    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            return this.delegate.list(directory, new ProxyListProgressListener(this.finder, listener));
        }
        catch (VaultFoundListCanceledException finder) {
            Vault cryptomator = finder.getVault();
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Found vault %s", cryptomator));
            }
            return this.delegate.list(cryptomator.encrypt(this.session, directory), new DecryptingListProgressListener(this.session, cryptomator, listener.reset()));
        }
    }

    @Override
    public ListService withCache(Cache<Path> cache) {
        this.delegate.withCache(cache);
        return this;
    }
}

