/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.download;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.download.PathPriorityComparator;

public class DownloadRegexPriorityComparator
extends PathPriorityComparator {
    private final String pattern;

    public DownloadRegexPriorityComparator() {
        this(PreferencesFactory.get().getProperty("queue.download.priority.regex"));
    }

    public DownloadRegexPriorityComparator(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public int compare(Path o1, Path o2) {
        String c1 = PathNormalizer.name(o1.getAbsolute());
        boolean c2 = PathNormalizer.name(o2.getAbsolute()).matches(this.pattern);
        if (c1.matches(this.pattern) && c2) {
            return 0;
        }
        if (c1.matches(this.pattern)) {
            return -1;
        }
        if (c2) {
            return 1;
        }
        return super.compare(o1, o2);
    }
}

